/*
** ###################################################################
**     Processors:          MIMXRT533SFAWC
**                          MIMXRT533SFFOC
**                          MIMXRT555SFAWC
**                          MIMXRT555SFFOC
**                          MIMXRT595SFAWC_cm33
**                          MIMXRT595SFAWC_dsp
**                          MIMXRT595SFFOC_cm33
**                          MIMXRT595SFFOC_dsp
**
**     Version:             rev. 5.0, 2020-08-27
**     Build:               b240705
**
**     Abstract:
**         CMSIS Peripheral Access Layer for INPUTMUX
**
**     Copyright 1997-2016 Freescale Semiconductor, Inc.
**     Copyright 2016-2024 NXP
**     SPDX-License-Identifier: BSD-3-Clause
**
**     http:                 www.nxp.com
**     mail:                 support@nxp.com
**
**     Revisions:
**     - rev. 1.0 (2019-04-19)
**         Initial version.
**     - rev. 2.0 (2019-07-22)
**         Base on rev 0.7 RM.
**     - rev. 3.0 (2020-03-16)
**         Base on Rev.A RM.
**     - rev. 4.0 (2020-05-18)
**         Base on Rev.B RM.
**     - rev. 5.0 (2020-08-27)
**         Base on Rev.C RM.
**
** ###################################################################
*/

/*!
 * @file INPUTMUX.h
 * @version 5.0
 * @date 2020-08-27
 * @brief CMSIS Peripheral Access Layer for INPUTMUX
 *
 * CMSIS Peripheral Access Layer for INPUTMUX
 */

#if !defined(INPUTMUX_H_)
#define INPUTMUX_H_                              /**< Symbol preventing repeated inclusion */

#if (defined(CPU_MIMXRT533SFAWC) || defined(CPU_MIMXRT533SFFOC))
#include "MIMXRT533S_COMMON.h"
#elif (defined(CPU_MIMXRT555SFAWC) || defined(CPU_MIMXRT555SFFOC))
#include "MIMXRT555S_COMMON.h"
#elif (defined(CPU_MIMXRT595SFAWC_cm33) || defined(CPU_MIMXRT595SFFOC_cm33))
#include "MIMXRT595S_cm33_COMMON.h"
#elif (defined(CPU_MIMXRT595SFAWC_dsp) || defined(CPU_MIMXRT595SFFOC_dsp))
#include "MIMXRT595S_dsp_COMMON.h"
#else
  #error "No valid CPU defined!"
#endif

/* ----------------------------------------------------------------------------
   -- Device Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Peripheral_access_layer Device Peripheral Access Layer
 * @{
 */


/*
** Start of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #if (__ARMCC_VERSION >= 6010050)
    #pragma clang diagnostic push
  #else
    #pragma push
    #pragma anon_unions
  #endif
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=extended
#elif defined(__XTENSA__)
  /* anonymous unions are enabled by default */
#else
  #error Not supported compiler type
#endif

/* ----------------------------------------------------------------------------
   -- INPUTMUX Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup INPUTMUX_Peripheral_Access_Layer INPUTMUX Peripheral Access Layer
 * @{
 */

/** INPUTMUX - Size of Registers Arrays */
#define INPUTMUX_SCT0_IN_SEL_COUNT                7u
#define INPUTMUX_PINT_SEL_COUNT                   8u
#define INPUTMUX_DSP_INT_SEL_COUNT                27u
#define INPUTMUX_DMAC0_ITRIG_SEL_COUNT            37u
#define INPUTMUX_DMAC0_OTRIG_SEL_COUNT            4u
#define INPUTMUX_DMAC0_CHMUX_SEL_COUNT            16u
#define INPUTMUX_DMAC1_ITRIG_SEL_COUNT            37u
#define INPUTMUX_DMAC1_OTRIG_SEL_COUNT            4u
#define INPUTMUX_DMAC1_CHMUX_SEL_COUNT            16u
#define INPUTMUX_CT32BIT_CAP_SEL_COUNT            5u
#define INPUTMUX_CT32BIT_CAP_SEL_CT32BITY_CAPX_SEL_COUNT 4u
#define INPUTMUX_FMEASURE_CH_SEL_COUNT            2u
#define INPUTMUX_SMART_DMA_TRIG_CHN_SEL_COUNT     8u

/** INPUTMUX - Register Layout Typedef */
typedef struct {
  __IO uint32_t SCT0_IN_SEL[INPUTMUX_SCT0_IN_SEL_COUNT]; /**< SCT Peripheral Input multiplexer 0..SCT Peripheral Input multiplexer 6, array offset: 0x0, array step: 0x4 */
       uint8_t RESERVED_0[228];
  __IO uint32_t PINT_SEL[INPUTMUX_PINT_SEL_COUNT]; /**< GPIO Pin Input Multiplexer 0..GPIO Pin Input Multiplexer 7, array offset: 0x100, array step: 0x4 */
       uint8_t RESERVED_1[32];
  __IO uint32_t DSP_INT_SEL[INPUTMUX_DSP_INT_SEL_COUNT]; /**< Fusion DSP Interrupt Input Multiplexer, array offset: 0x140, array step: 0x4 */
       uint8_t RESERVED_2[84];
  __IO uint32_t DMAC0_ITRIG_SEL[INPUTMUX_DMAC0_ITRIG_SEL_COUNT]; /**< DMAC0 Input Trigger Select, array offset: 0x200, array step: 0x4 */
       uint8_t RESERVED_3[108];
  __IO uint32_t DMAC0_OTRIG_SEL[INPUTMUX_DMAC0_OTRIG_SEL_COUNT]; /**< DMAC0 Output Trigger Select, array offset: 0x300, array step: 0x4 */
       uint8_t RESERVED_4[16];
  __IO uint32_t DMAC0_CHMUX_SEL[INPUTMUX_DMAC0_CHMUX_SEL_COUNT]; /**< DMAC0 Channel mux select 0..DMAC0 Channel mux select 15, array offset: 0x320, array step: 0x4 */
       uint8_t RESERVED_5[160];
  __IO uint32_t DMAC1_ITRIG_SEL[INPUTMUX_DMAC1_ITRIG_SEL_COUNT]; /**< DMAC1 Input Trigger Select, array offset: 0x400, array step: 0x4 */
       uint8_t RESERVED_6[108];
  __IO uint32_t DMAC1_OTRIG_SEL[INPUTMUX_DMAC1_OTRIG_SEL_COUNT]; /**< DMAC1 Output Trigger Select, array offset: 0x500, array step: 0x4 */
       uint8_t RESERVED_7[16];
  __IO uint32_t DMAC1_CHMUX_SEL[INPUTMUX_DMAC1_CHMUX_SEL_COUNT]; /**< DMAC1 Channel mux select 0..DMAC1 Channel mux select 15, array offset: 0x520, array step: 0x4 */
       uint8_t RESERVED_8[160];
  __IO uint32_t CT32BIT_CAP_SEL[INPUTMUX_CT32BIT_CAP_SEL_COUNT][INPUTMUX_CT32BIT_CAP_SEL_CT32BITY_CAPX_SEL_COUNT]; /**< CT32BIT Timer Capture Multiplexers, array offset: 0x600, array step: index*0x10, index2*0x4 */
       uint8_t RESERVED_9[176];
  __IO uint32_t FMEASURE_CH_SEL[INPUTMUX_FMEASURE_CH_SEL_COUNT]; /**< Frequency Measurement Input Channel Multiplexers, array offset: 0x700, array step: 0x4 */
       uint8_t RESERVED_10[24];
  __IO uint32_t SMART_DMA_TRIG_CH_SEL[INPUTMUX_SMART_DMA_TRIG_CHN_SEL_COUNT]; /**< SMART_DMA trigger channel select, array offset: 0x720, array step: 0x4 */
  __IO uint32_t DMAC0_REQ_ENA0;                    /**< DMAC0 request enable 0, offset: 0x740 */
  __IO uint32_t DMAC0_REQ_ENA1;                    /**< DMAC0 request enable 1, offset: 0x744 */
  __IO uint32_t DMAC0_REQ_ENA0_SET;                /**< DMAC0 request enable set 0, offset: 0x748 */
  __IO uint32_t DMAC0_REQ_ENA1_SET;                /**< DMAC0 request enable set 1, offset: 0x74C */
  __IO uint32_t DMAC0_REQ_ENA0_CLR;                /**< DMAC0 request enable clear 0, offset: 0x750 */
  __IO uint32_t DMAC0_REQ_ENA1_CLR;                /**< DMAC0 request enable 1 clear, offset: 0x754 */
       uint8_t RESERVED_11[8];
  __IO uint32_t DMAC1_REQ_ENA0;                    /**< DMAC1 request enable 0, offset: 0x760 */
  __IO uint32_t DMAC1_REQ_ENA1;                    /**< DMAC1 request enable 1, offset: 0x764 */
  __IO uint32_t DMAC1_REQ_ENA0_SET;                /**< DMAC1 request enable set 0, offset: 0x768 */
  __IO uint32_t DMAC1_REQ_ENA1_SET;                /**< DMAC1 request enable set 1, offset: 0x76C */
  __IO uint32_t DMAC1_REQ_ENA0_CLR;                /**< DMAC1 request enable clear 0, offset: 0x770 */
  __IO uint32_t DMAC1_REQ_ENA1_CLR;                /**< DMAC1 request enable 1 clear, offset: 0x774 */
       uint8_t RESERVED_12[8];
  __IO uint32_t DMAC0_ITRIG_ENA0;                  /**< DMAC0 Input Trigger Enable 0, offset: 0x780 */
       uint8_t RESERVED_13[4];
  __O  uint32_t DMAC0_ITRIG_ENA0_SET;              /**< DMAC0 Input Trigger Enable 0 Set, offset: 0x788 */
       uint8_t RESERVED_14[4];
  __O  uint32_t DMAC0_ITRIG_ENA0_CLR;              /**< DMAC0 Input Trigger Enable 0 Clear, offset: 0x790 */
       uint8_t RESERVED_15[12];
  __IO uint32_t DMAC1_ITRIG_ENA0;                  /**< DMAC1 Input Trigger Enable 0, offset: 0x7A0 */
       uint8_t RESERVED_16[4];
  __O  uint32_t DMAC1_ITRIG_ENA0_SET;              /**< DMAC1 Input Trigger Enable 0 set, offset: 0x7A8 */
       uint8_t RESERVED_17[4];
  __O  uint32_t DMAC1_ITRIG_ENA0_CLR;              /**< DMAC1 Input Trigger Enable 0 clear, offset: 0x7B0 */
} INPUTMUX_Type;

/* ----------------------------------------------------------------------------
   -- INPUTMUX Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup INPUTMUX_Register_Masks INPUTMUX Register Masks
 * @{
 */

/*! @name SCT0_IN_SEL - SCT Peripheral Input multiplexer 0..SCT Peripheral Input multiplexer 6 */
/*! @{ */

#define INPUTMUX_SCT0_IN_SEL_SCT_IN_SEL_MASK     (0x1FU)
#define INPUTMUX_SCT0_IN_SEL_SCT_IN_SEL_SHIFT    (0U)
/*! SCT_IN_SEL - SCT0 Input Selection.
 *  0b00000..SCT0_PIN_INP0
 *  0b00001..SCT0_PIN_INP1
 *  0b00010..SCT0_PIN_INP2
 *  0b00011..SCT0_PIN_INP3
 *  0b00100..SCT0_PIN_INP4
 *  0b00101..SCT0_PIN_INP5
 *  0b00110..SCT0_PIN_INP6
 *  0b00111..SCT0_PIN_INP7
 *  0b01000..CT32BIT0_MAT0
 *  0b01001..CT32BIT1_MAT0
 *  0b01010..CT32BIT2_MAT0
 *  0b01011..CT32BIT3_MAT0
 *  0b01100..CT32BIT4_MAT0
 *  0b01101..ADCIRQ
 *  0b01110..GPIOINT_BMATCH
 *  0b01111..USB0_FRAME_TOGGLE
 *  0b10000..CMP0_OUT
 *  0b10001..SHARED I2S0_SCLK
 *  0b10010..SHARED I2S1_SCLK
 *  0b10011..SHARED I2S0_WS
 *  0b10100..SHARED I2S1_WS
 *  0b10101..MCLK
 *  0b10110..ARM_TXEV
 *  0b10111..DEBUG_HALTED
 *  0b11000..Reserved
 *  0b11001..Reserved
 *  0b11010..Reserved
 *  0b11011..Reserved
 *  0b11100..Reserved
 *  0b11101..Reserved
 *  0b11110..Reserved
 *  0b11111..Reserved
 */
#define INPUTMUX_SCT0_IN_SEL_SCT_IN_SEL(x)       (((uint32_t)(((uint32_t)(x)) << INPUTMUX_SCT0_IN_SEL_SCT_IN_SEL_SHIFT)) & INPUTMUX_SCT0_IN_SEL_SCT_IN_SEL_MASK)
/*! @} */

/*! @name PINT_SEL - GPIO Pin Input Multiplexer 0..GPIO Pin Input Multiplexer 7 */
/*! @{ */

#define INPUTMUX_PINT_SEL_PINT_SEL_MASK          (0xFFU)
#define INPUTMUX_PINT_SEL_PINT_SEL_SHIFT         (0U)
/*! PINT_SEL - Interrupt select */
#define INPUTMUX_PINT_SEL_PINT_SEL(x)            (((uint32_t)(((uint32_t)(x)) << INPUTMUX_PINT_SEL_PINT_SEL_SHIFT)) & INPUTMUX_PINT_SEL_PINT_SEL_MASK)
/*! @} */

/*! @name DSP_INT_SEL - Fusion DSP Interrupt Input Multiplexer */
/*! @{ */

#define INPUTMUX_DSP_INT_SEL_DSP_INT_SEL_MASK    (0x3FU)
#define INPUTMUX_DSP_INT_SEL_DSP_INT_SEL_SHIFT   (0U)
/*! DSP_INT_SEL
 *  0b000000..FLEXCOMM0_IRQ
 *  0b000001..FLEXCOMM1_IRQ
 *  0b000010..FLEXCOMM2_IRQ
 *  0b000011..FLEXCOMM3_IRQ
 *  0b000100..FLEXCOMM4_IRQ
 *  0b000101..FLEXCOMM5_IRQ
 *  0b000110..FLEXCOMM6_IRQ
 *  0b000111..FLEXCOMM7_IRQ
 *  0b001000..FLEXCOMM14_IRQ
 *  0b001001..FLEXCOMM16_IRQ
 *  0b001010..GPIO_INT0_IRQ0
 *  0b001011..GPIO_INT0_IRQ1
 *  0b001100..GPIO_INT0_IRQ2
 *  0b001101..GPIO_INT0_IRQ3
 *  0b001110..GPIO_INT0_IRQ4
 *  0b001111..GPIO_INT0_IRQ5
 *  0b010000..GPIO_INT0_IRQ6
 *  0b010001..GPIO_INT0_IRQ7
 *  0b010010..NSHSGPIO_INT0_IRQ0
 *  0b010011..NSHSGPIO_INT1_IRQ1
 *  0b010100..WDT1
 *  0b010101..DMAC0_IRQ
 *  0b010110..DMAC1_IRQ
 *  0b010111..MU_B_IRQ
 *  0b011000..UTICK0_IRQ
 *  0b011001..MRT0_IRQ
 *  0b011010..OS_EVENT_TIMER or OS_EVENT_WAKEUP
 *  0b011011..CTIMER0
 *  0b011100..CTIMER1
 *  0b011101..CTIMER2
 *  0b011110..CTIMER3
 *  0b011111..CTIMER4
 *  0b100000..RTC_LITE0_ALARM or RTC_LITE0_WAKEUP
 *  0b100001..I3C0
 *  0b100010..I3C1
 *  0b100011..DMIC0
 *  0b100100..HWVAD
 *  0b100101..LCDIF_IRQ
 *  0b100110..GPU_IRQ
 *  0b100111..SMARTDMA_IRQ
 *  0b101000..FLEXIO_IRQ
 */
#define INPUTMUX_DSP_INT_SEL_DSP_INT_SEL(x)      (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DSP_INT_SEL_DSP_INT_SEL_SHIFT)) & INPUTMUX_DSP_INT_SEL_DSP_INT_SEL_MASK)
/*! @} */

/*! @name DMAC0_ITRIG_SEL - DMAC0 Input Trigger Select */
/*! @{ */

#define INPUTMUX_DMAC0_ITRIG_SEL_DMAC0_ITRIG_SEL_MASK (0x1FU)
#define INPUTMUX_DMAC0_ITRIG_SEL_DMAC0_ITRIG_SEL_SHIFT (0U)
/*! DMAC0_ITRIG_SEL - DMA Input Trigger Selection.
 *  0b00000..GPIO_INT0
 *  0b00001..GPIO_INT1
 *  0b00010..GPIO_INT2
 *  0b00011..GPIO_INT3
 *  0b00100..T0_DMAREQ_M0
 *  0b00101..T0_DMAREQ_M1
 *  0b00110..T1_DMAREQ_M0
 *  0b00111..T1_DMAREQ_M1
 *  0b01000..T2_DMAREQ_M0
 *  0b01001..T2_DMAREQ_M1
 *  0b01010..T3_DMAREQ_M0
 *  0b01011..T3_DMAREQ_M1
 *  0b01100..T4_DMAREQ_M0
 *  0b01101..T4_DMAREQ_M1
 *  0b01110..DMA0_TRIGOUT_A
 *  0b01111..DMA0_TRIGOUT_B
 *  0b10000..DMA0_TRIGOUT_C
 *  0b10001..DMA0_TRIGOUT_D
 *  0b10010..SCT_DMAC0_REQ0
 *  0b10011..SCT_DMAC1_REQ1
 *  0b10100..HASHCRYPT_OUT_DMA
 *  0b10101..ACMP_DMA
 *  0b10110..FlexSPI0_RX_DMA
 *  0b10111..FlexSPI0_TX_DMA
 *  0b11000..ADC_DMA
 *  0b11001..FlexSPI1_RX_DMA
 *  0b11010..FlexSPI1_TX_DMA
 *  0b11011..Reserved
 *  0b11100..Reserved
 *  0b11101..Reserved
 *  0b11111..Reserved
 */
#define INPUTMUX_DMAC0_ITRIG_SEL_DMAC0_ITRIG_SEL(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_SEL_DMAC0_ITRIG_SEL_SHIFT)) & INPUTMUX_DMAC0_ITRIG_SEL_DMAC0_ITRIG_SEL_MASK)
/*! @} */

/*! @name DMAC0_OTRIG_SEL - DMAC0 Output Trigger Select */
/*! @{ */

#define INPUTMUX_DMAC0_OTRIG_SEL_DMAC0_OTRIG_SEL_MASK (0x3FU)
#define INPUTMUX_DMAC0_OTRIG_SEL_DMAC0_OTRIG_SEL_SHIFT (0U)
/*! DMAC0_OTRIG_SEL
 *  0b000000..DMAC0_OTRIG_CH0
 *  0b000001..DMAC0_OTRIG_CH1
 *  0b000010..DMAC0_OTRIG_CH2
 *  0b000011..DMAC0_OTRIG_CH3
 *  0b000100..DMAC0_OTRIG_CH4
 *  0b000101..DMAC0_OTRIG_CH5
 *  0b000110..DMAC0_OTRIG_CH6
 *  0b000111..DMAC0_OTRIG_CH7
 *  0b001000..DMAC0_OTRIG_CH8
 *  0b001001..DMAC0_OTRIG_CH9
 *  0b001010..DMAC0_OTRIG_CH10
 *  0b001011..DMAC0_OTRIG_CH11
 *  0b001100..DMAC0_OTRIG_CH12
 *  0b001101..DMAC0_OTRIG_CH13
 *  0b001110..DMAC0_OTRIG_CH14
 *  0b001111..DMAC0_OTRIG_CH15
 *  0b010000..DMAC0_OTRIG_CH16
 *  0b010001..DMAC0_OTRIG_CH17
 *  0b010010..DMAC0_OTRIG_CH18
 *  0b010011..DMAC0_OTRIG_CH19
 *  0b010100..DMAC0_OTRIG_CH20
 *  0b010101..DMAC0_OTRIG_CH21
 *  0b010110..DMAC0_OTRIG_CH22
 *  0b010111..DMAC0_OTRIG_CH23
 *  0b011000..DMAC0_OTRIG_CH24
 *  0b011001..DMAC0_OTRIG_CH25
 *  0b011010..DMAC0_OTRIG_CH26
 *  0b011011..DMAC0_OTRIG_CH27
 *  0b011100..DMAC0_OTRIG_CH28
 *  0b011101..DMAC0_OTRIG_CH29
 *  0b011110..DMAC0_OTRIG_CH30
 *  0b011111..DMAC0_OTRIG_CH31
 *  0b100000..DMAC0_OTRIG_CH32
 *  0b100001..DMAC0_OTRIG_CH33
 *  0b100010..DMAC0_OTRIG_CH34
 *  0b100011..DMAC0_OTRIG_CH35
 *  0b100100..DMAC0_OTRIG_CH36
 */
#define INPUTMUX_DMAC0_OTRIG_SEL_DMAC0_OTRIG_SEL(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_OTRIG_SEL_DMAC0_OTRIG_SEL_SHIFT)) & INPUTMUX_DMAC0_OTRIG_SEL_DMAC0_OTRIG_SEL_MASK)
/*! @} */

/*! @name DMAC0_CHMUX_SEL - DMAC0 Channel mux select 0..DMAC0 Channel mux select 15 */
/*! @{ */

#define INPUTMUX_DMAC0_CHMUX_SEL_DMAC0_CHMUX_SEL_MASK (0x1U)
#define INPUTMUX_DMAC0_CHMUX_SEL_DMAC0_CHMUX_SEL_SHIFT (0U)
/*! DMAC0_CHMUX_SEL - DMAC0 Channel mux select 1
 *  0b0..DMIC_CH4_DMA
 *  0b1..FLEXCOM10_RX_DMA
 */
#define INPUTMUX_DMAC0_CHMUX_SEL_DMAC0_CHMUX_SEL(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_CHMUX_SEL_DMAC0_CHMUX_SEL_SHIFT)) & INPUTMUX_DMAC0_CHMUX_SEL_DMAC0_CHMUX_SEL_MASK)
/*! @} */

/*! @name DMAC1_ITRIG_SEL - DMAC1 Input Trigger Select */
/*! @{ */

#define INPUTMUX_DMAC1_ITRIG_SEL_DMAC1_ITRIG_SEL_MASK (0x1FU)
#define INPUTMUX_DMAC1_ITRIG_SEL_DMAC1_ITRIG_SEL_SHIFT (0U)
/*! DMAC1_ITRIG_SEL - DMA Input Trigger Selection.
 *  0b00000..GPIO_INT0
 *  0b00001..GPIO_INT1
 *  0b00010..GPIO_INT2
 *  0b00011..GPIO_INT3
 *  0b00100..T0_DMAREQ_M0
 *  0b00101..T0_DMAREQ_M1
 *  0b00110..T1_DMAREQ_M0
 *  0b00111..T1_DMAREQ_M1
 *  0b01000..T2_DMAREQ_M0
 *  0b01001..T2_DMAREQ_M1
 *  0b01010..T3_DMAREQ_M0
 *  0b01011..T3_DMAREQ_M1
 *  0b01100..T4_DMAREQ_M0
 *  0b01101..T4_DMAREQ_M1
 *  0b01110..DMA0_TRIGOUT_A
 *  0b01111..DMA0_TRIGOUT_B
 *  0b10000..DMA0_TRIGOUT_C
 *  0b10001..DMA0_TRIGOUT_D
 *  0b10010..SCT_DMAC0_REQ0
 *  0b10011..SCT_DMAC1_REQ1
 *  0b10100..HASHCRYPT_OUT_DMA
 *  0b10101..ACMP_DMA
 *  0b10110..FlexSPI0_RX_DMA
 *  0b10111..FlexSPI0_TX_DMA
 *  0b11000..ADC_DMA
 *  0b11001..FlexSPI1_RX_DMA
 *  0b11010..FlexSPI1_TX_DMA
 *  0b11011..Reserved
 *  0b11100..Reserved
 *  0b11101..Reserved
 *  0b11111..Reserved
 */
#define INPUTMUX_DMAC1_ITRIG_SEL_DMAC1_ITRIG_SEL(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_SEL_DMAC1_ITRIG_SEL_SHIFT)) & INPUTMUX_DMAC1_ITRIG_SEL_DMAC1_ITRIG_SEL_MASK)
/*! @} */

/*! @name DMAC1_OTRIG_SEL - DMAC1 Output Trigger Select */
/*! @{ */

#define INPUTMUX_DMAC1_OTRIG_SEL_DMAC1_OTRIG_SEL_MASK (0x3FU)
#define INPUTMUX_DMAC1_OTRIG_SEL_DMAC1_OTRIG_SEL_SHIFT (0U)
/*! DMAC1_OTRIG_SEL - DMA Output Trigger Selection.
 *  0b000000..DMAC1_OTRIG_CH0
 *  0b000001..DMAC1_OTRIG_CH1
 *  0b000010..DMAC1_OTRIG_CH2
 *  0b000011..DMAC1_OTRIG_CH3
 *  0b000100..DMAC1_OTRIG_CH4
 *  0b000101..DMAC1_OTRIG_CH5
 *  0b000110..DMAC1_OTRIG_CH6
 *  0b000111..DMAC1_OTRIG_CH7
 *  0b001000..DMAC1_OTRIG_CH8
 *  0b001001..DMAC1_OTRIG_CH9
 *  0b001010..DMAC1_OTRIG_CH10
 *  0b001011..DMAC1_OTRIG_CH11
 *  0b001100..DMAC1_OTRIG_CH12
 *  0b001101..DMAC1_OTRIG_CH13
 *  0b001110..DMAC1_OTRIG_CH14
 *  0b001111..DMAC1_OTRIG_CH15
 *  0b010000..DMAC1_OTRIG_CH16
 *  0b010001..DMAC1_OTRIG_CH17
 *  0b010010..DMAC1_OTRIG_CH18
 *  0b010011..DMAC1_OTRIG_CH19
 *  0b010100..DMAC1_OTRIG_CH20
 *  0b010101..DMAC1_OTRIG_CH21
 *  0b010110..DMAC1_OTRIG_CH22
 *  0b010111..DMAC1_OTRIG_CH23
 *  0b011000..DMAC1_OTRIG_CH24
 *  0b011001..DMAC1_OTRIG_CH25
 *  0b011010..DMAC1_OTRIG_CH26
 *  0b011011..DMAC1_OTRIG_CH27
 *  0b011100..DMAC1_OTRIG_CH28
 *  0b011101..DMAC1_OTRIG_CH29
 *  0b011110..DMAC1_OTRIG_CH30
 *  0b011111..DMAC1_OTRIG_CH31
 *  0b100000..DMAC1_OTRIG_CH32
 *  0b100001..DMAC1_OTRIG_CH33
 *  0b100010..DMAC1_OTRIG_CH34
 *  0b100011..DMAC1_OTRIG_CH35
 *  0b100100..DMAC1_OTRIG_CH36
 */
#define INPUTMUX_DMAC1_OTRIG_SEL_DMAC1_OTRIG_SEL(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_OTRIG_SEL_DMAC1_OTRIG_SEL_SHIFT)) & INPUTMUX_DMAC1_OTRIG_SEL_DMAC1_OTRIG_SEL_MASK)
/*! @} */

/*! @name DMAC1_CHMUX_SEL - DMAC1 Channel mux select 0..DMAC1 Channel mux select 15 */
/*! @{ */

#define INPUTMUX_DMAC1_CHMUX_SEL_DMAC1_CHMUX_SEL_MASK (0x1U)
#define INPUTMUX_DMAC1_CHMUX_SEL_DMAC1_CHMUX_SEL_SHIFT (0U)
/*! DMAC1_CHMUX_SEL - DMAC1 Channel mux select
 *  0b0..DMIC_CH4_DMA
 *  0b1..FLEXCOM10_RX_DMA
 */
#define INPUTMUX_DMAC1_CHMUX_SEL_DMAC1_CHMUX_SEL(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_CHMUX_SEL_DMAC1_CHMUX_SEL_SHIFT)) & INPUTMUX_DMAC1_CHMUX_SEL_DMAC1_CHMUX_SEL_MASK)
/*! @} */

/*! @name CT32BITY_CAPX_SEL_CT32BIT_CAP_SEL - CT32BIT Timer Capture Multiplexers */
/*! @{ */

#define INPUTMUX_CT32BITY_CAPX_SEL_CT32BIT_CAP_SEL_CAPn_SEL_MASK (0x1FU)
#define INPUTMUX_CT32BITY_CAPX_SEL_CT32BIT_CAP_SEL_CAPn_SEL_SHIFT (0U)
/*! CAPn_SEL - Counter Timer n, Capture Input m
 *  0b00000..CT_INP0 (function must be selected in IOPCTL)
 *  0b00001..CT_INP1 (function must be selected in IOPCTL)
 *  0b00010..CT_INP2 (function must be selected in IOPCTL)
 *  0b00011..CT_INP3 (function must be selected in IOPCTL)
 *  0b00100..CT_INP4 (function must be selected in IOPCTL)
 *  0b00101..CT_INP5 (function must be selected in IOPCTL)
 *  0b00110..CT_INP6 (function must be selected in IOPCTL)
 *  0b00111..CT_INP7 (function must be selected in IOPCTL)
 *  0b01000..CT_INP8 (function must be selected in IOPCTL)
 *  0b01001..CT_INP9 (function must be selected in IOPCTL)
 *  0b01010..CT_INP10 (function must be selected in IOPCTL)
 *  0b01011..CT_INP11 (function must be selected in IOPCTL)
 *  0b01100..CT_INP12 (function must be selected in IOPCTL)
 *  0b01101..CT_INP13 (function must be selected in IOPCTL)
 *  0b01110..CT_INP14 (function must be selected in IOPCTL)
 *  0b01111..CT_INP15 (function must be selected in IOPCTL)
 *  0b10000..SHARED I2S0_WS
 *  0b10001..SHARED I2S1_WS
 *  0b10010..USB1_FRAME_TOGGLE (see USB Controller Chapter)
 */
#define INPUTMUX_CT32BITY_CAPX_SEL_CT32BIT_CAP_SEL_CAPn_SEL(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_CT32BITY_CAPX_SEL_CT32BIT_CAP_SEL_CAPn_SEL_SHIFT)) & INPUTMUX_CT32BITY_CAPX_SEL_CT32BIT_CAP_SEL_CAPn_SEL_MASK)
/*! @} */

/* The count of INPUTMUX_CT32BITY_CAPX_SEL_CT32BIT_CAP_SEL */
#define INPUTMUX_CT32BITY_CAPX_SEL_CT32BIT_CAP_SEL_COUNT (5U)

/* The count of INPUTMUX_CT32BITY_CAPX_SEL_CT32BIT_CAP_SEL */
#define INPUTMUX_CT32BITY_CAPX_SEL_CT32BIT_CAP_SEL_COUNT2 (4U)

/*! @name FMEASURE_CH_SEL - Frequency Measurement Input Channel Multiplexers */
/*! @{ */

#define INPUTMUX_FMEASURE_CH_SEL_FMEASURE_SEL_MASK (0x1FU)
#define INPUTMUX_FMEASURE_CH_SEL_FMEASURE_SEL_SHIFT (0U)
/*! FMEASURE_SEL - Frequency Measure Channel Selection
 *  0b00000..OSC_CLK
 *  0b00001..FRO_DIV16
 *  0b00010..FRO_DIV1
 *  0b00011..Low Power Oscillator Clock (LPOSC)
 *  0b00100..RTC 32 kHz OSC
 *  0b00101..Main SYSCLK
 *  0b00110..FREQME_GPIO_CLK
 *  0b00111..Reserved
 *  0b01000..Reserved
 *  0b01001..Reserved
 *  0b01010..Reserved
 *  0b01011..Clock Out
 *  0b01100..Reserved
 *  0b01101..Reserved
 *  0b01110..Reserved
 *  0b01111..Reserved
 *  0b10000..Reserved
 *  0b10001..Reserved
 */
#define INPUTMUX_FMEASURE_CH_SEL_FMEASURE_SEL(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_FMEASURE_CH_SEL_FMEASURE_SEL_SHIFT)) & INPUTMUX_FMEASURE_CH_SEL_FMEASURE_SEL_MASK)
/*! @} */

/*! @name SMART_DMA_TRIG_CHN_SEL_SMART_DMA_TRIG_CH_SEL - SMART_DMA trigger channel select */
/*! @{ */

#define INPUTMUX_SMART_DMA_TRIG_CHN_SEL_SMART_DMA_TRIG_CH_SEL_SMART_DMA_IN_SEL_MASK (0x7FU)
#define INPUTMUX_SMART_DMA_TRIG_CHN_SEL_SMART_DMA_TRIG_CH_SEL_SMART_DMA_IN_SEL_SHIFT (0U)
/*! SMART_DMA_IN_SEL - SMART_DMA Input(n) Selection */
#define INPUTMUX_SMART_DMA_TRIG_CHN_SEL_SMART_DMA_TRIG_CH_SEL_SMART_DMA_IN_SEL(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_SMART_DMA_TRIG_CHN_SEL_SMART_DMA_TRIG_CH_SEL_SMART_DMA_IN_SEL_SHIFT)) & INPUTMUX_SMART_DMA_TRIG_CHN_SEL_SMART_DMA_TRIG_CH_SEL_SMART_DMA_IN_SEL_MASK)
/*! @} */

/* The count of INPUTMUX_SMART_DMA_TRIG_CHN_SEL_SMART_DMA_TRIG_CH_SEL */
#define INPUTMUX_SMART_DMA_TRIG_CHN_SEL_SMART_DMA_TRIG_CH_SEL_COUNT (8U)

/*! @name DMAC0_REQ_ENA0 - DMAC0 request enable 0 */
/*! @{ */

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM0_RX_MASK (0x1U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM0_RX_SHIFT (0U)
/*! FLEXCOMM0_RX - FLEXCOMM0 RX enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM0_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM0_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM0_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM0_TX_MASK (0x2U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM0_TX_SHIFT (1U)
/*! FLEXCOMM0_TX - FLEXCOMM0 TX enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM0_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM0_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM0_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM1_RX_MASK (0x4U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM1_RX_SHIFT (2U)
/*! FLEXCOMM1_RX - FLEXCOMM1 RX enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM1_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM1_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM1_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM1_TX_MASK (0x8U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM1_TX_SHIFT (3U)
/*! FLEXCOMM1_TX - FLEXCOMM1 TX enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM1_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM1_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM1_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM2_RX_MASK (0x10U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM2_RX_SHIFT (4U)
/*! FLEXCOMM2_RX - FLEXCOMM2 RX enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM2_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM2_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM2_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM2_TX_MASK (0x20U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM2_TX_SHIFT (5U)
/*! FLEXCOMM2_TX - FLEXCOMM2 TX enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM2_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM2_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM2_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM3_RX_MASK (0x40U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM3_RX_SHIFT (6U)
/*! FLEXCOMM3_RX - FLEXCOMM3 RX enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM3_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM3_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM3_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM3_TX_MASK (0x80U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM3_TX_SHIFT (7U)
/*! FLEXCOMM3_TX - FLEXCOMM3 TX enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM3_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM3_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM3_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM4_RX_MASK (0x100U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM4_RX_SHIFT (8U)
/*! FLEXCOMM4_RX - FLEXCOMM4 RX enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM4_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM4_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM4_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM4_TX_MASK (0x200U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM4_TX_SHIFT (9U)
/*! FLEXCOMM4_TX - FLEXCOMM4 TX enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM4_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM4_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM4_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM5_RX_MASK (0x400U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM5_RX_SHIFT (10U)
/*! FLEXCOMM5_RX - FLEXCOMM5 RX enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM5_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM5_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM5_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM5_TX_MASK (0x800U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM5_TX_SHIFT (11U)
/*! FLEXCOMM5_TX - FLEXCOMM5 TX enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM5_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM5_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM5_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM6_RX_MASK (0x1000U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM6_RX_SHIFT (12U)
/*! FLEXCOMM6_RX - FLEXCOMM6 RX enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM6_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM6_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM6_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM6_TX_MASK (0x2000U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM6_TX_SHIFT (13U)
/*! FLEXCOMM6_TX - FLEXCOMM6 TX enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM6_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM6_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM6_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM7_RX_MASK (0x4000U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM7_RX_SHIFT (14U)
/*! FLEXCOMM7_RX - FLEXCOMM7 RX enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM7_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM7_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM7_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM7_TX_MASK (0x8000U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM7_TX_SHIFT (15U)
/*! FLEXCOMM7_TX - FLEXCOMM7 TX enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM7_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM7_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM7_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH0_FLEXCOMM8_RX_DMA_MASK (0x10000U)
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH0_FLEXCOMM8_RX_DMA_SHIFT (16U)
/*! DMIC0_CH0_FLEXCOMM8_RX_DMA - DMIC0 channel 0 / FLEXCOMM8 RX DMA enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH0_FLEXCOMM8_RX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH0_FLEXCOMM8_RX_DMA_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH0_FLEXCOMM8_RX_DMA_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH1_FLEXCOMM8_TX_DMA_MASK (0x20000U)
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH1_FLEXCOMM8_TX_DMA_SHIFT (17U)
/*! DMIC0_CH1_FLEXCOMM8_TX_DMA - DMIC0 channel 1 / FLEXCOMM8 TX DMA enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH1_FLEXCOMM8_TX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH1_FLEXCOMM8_TX_DMA_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH1_FLEXCOMM8_TX_DMA_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH2_FLEXCOMM9_RX_DMA_MASK (0x40000U)
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH2_FLEXCOMM9_RX_DMA_SHIFT (18U)
/*! DMIC0_CH2_FLEXCOMM9_RX_DMA - DMIC0 channel 2 / FLEXCOMM9 RX DMA enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH2_FLEXCOMM9_RX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH2_FLEXCOMM9_RX_DMA_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH2_FLEXCOMM9_RX_DMA_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH3_FLEXCOMM9_TX_DMA_MASK (0x80000U)
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH3_FLEXCOMM9_TX_DMA_SHIFT (19U)
/*! DMIC0_CH3_FLEXCOMM9_TX_DMA - DMIC0 channel 3 / FLEXCOMM9 TX DMA enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH3_FLEXCOMM9_TX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH3_FLEXCOMM9_TX_DMA_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH3_FLEXCOMM9_TX_DMA_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH4_FLEXCOMM10_RX_DMA_MASK (0x100000U)
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH4_FLEXCOMM10_RX_DMA_SHIFT (20U)
/*! DMIC0_CH4_FLEXCOMM10_RX_DMA - DMIC0 channel 4 / FLEXCOMM10 RX DMA enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH4_FLEXCOMM10_RX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH4_FLEXCOMM10_RX_DMA_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH4_FLEXCOMM10_RX_DMA_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH5_FLEXCOMM10_TX_DMA_MASK (0x200000U)
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH5_FLEXCOMM10_TX_DMA_SHIFT (21U)
/*! DMIC0_CH5_FLEXCOMM10_TX_DMA - DMIC0 channel 5 / FLEXCOMM10 TX DMA enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH5_FLEXCOMM10_TX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH5_FLEXCOMM10_TX_DMA_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH5_FLEXCOMM10_TX_DMA_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH6_FLEXCOMM13_RX_DMA_MASK (0x400000U)
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH6_FLEXCOMM13_RX_DMA_SHIFT (22U)
/*! DMIC0_CH6_FLEXCOMM13_RX_DMA - DMIC0 channel 6 / FLEXCOMM13 RX DMA enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH6_FLEXCOMM13_RX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH6_FLEXCOMM13_RX_DMA_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH6_FLEXCOMM13_RX_DMA_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH7_FLEXCOMM13_TX_DMA_MASK (0x800000U)
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH7_FLEXCOMM13_TX_DMA_SHIFT (23U)
/*! DMIC0_CH7_FLEXCOMM13_TX_DMA - DMIC0 channel 7 / FLEXCOMM13 TX DMA enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH7_FLEXCOMM13_TX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH7_FLEXCOMM13_TX_DMA_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_DMIC0_CH7_FLEXCOMM13_TX_DMA_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_I3C0_RX_MASK     (0x1000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_I3C0_RX_SHIFT    (24U)
/*! I3C0_RX - I3C RX enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_I3C0_RX(x)       (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_I3C0_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_I3C0_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_I3C0_TX_MASK     (0x2000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_I3C0_TX_SHIFT    (25U)
/*! I3C0_TX - I3C TX enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_I3C0_TX(x)       (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_I3C0_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_I3C0_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM14_RX_MASK (0x4000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM14_RX_SHIFT (26U)
/*! FLEXCOMM14_RX - FLEXCOMM14 RX enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM14_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM14_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM14_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM14_TX_MASK (0x8000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM14_TX_SHIFT (27U)
/*! FLEXCOMM14_TX - FLEXCOMM14 TX enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM14_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM14_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM14_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM16_RX_MASK (0x10000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM16_RX_SHIFT (28U)
/*! FLEXCOMM16_RX - FLEXCOMM16 RX enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM16_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM16_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM16_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM16_TX_MASK (0x20000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM16_TX_SHIFT (29U)
/*! FLEXCOMM16_TX - FLEXCOMM16 TX enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM16_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM16_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM16_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_I3C1_RX_MASK     (0x40000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_I3C1_RX_SHIFT    (30U)
/*! I3C1_RX - I3C1_RX enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_I3C1_RX(x)       (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_I3C1_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_I3C1_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_I3C1_TX_MASK     (0x80000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_I3C1_TX_SHIFT    (31U)
/*! I3C1_TX - I3C1_TX enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_I3C1_TX(x)       (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_I3C1_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_I3C1_TX_MASK)
/*! @} */

/*! @name DMAC0_REQ_ENA1 - DMAC0 request enable 1 */
/*! @{ */

#define INPUTMUX_DMAC0_REQ_ENA1_FLEXCOMM11_RX_MASK (0x1U)
#define INPUTMUX_DMAC0_REQ_ENA1_FLEXCOMM11_RX_SHIFT (0U)
/*! FLEXCOMM11_RX - FLEXCOMM11_RX
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA1_FLEXCOMM11_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA1_FLEXCOMM11_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA1_FLEXCOMM11_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA1_FLEXCOMM11_TX_MASK (0x2U)
#define INPUTMUX_DMAC0_REQ_ENA1_FLEXCOMM11_TX_SHIFT (1U)
/*! FLEXCOMM11_TX - FLEXCOMM11_TX
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA1_FLEXCOMM11_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA1_FLEXCOMM11_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA1_FLEXCOMM11_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA1_FLEXCOMM12_RX_MASK (0x4U)
#define INPUTMUX_DMAC0_REQ_ENA1_FLEXCOMM12_RX_SHIFT (2U)
/*! FLEXCOMM12_RX - FLEXCOMM12_RX
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA1_FLEXCOMM12_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA1_FLEXCOMM12_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA1_FLEXCOMM12_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA1_FLEXCOMM12_TX_MASK (0x8U)
#define INPUTMUX_DMAC0_REQ_ENA1_FLEXCOMM12_TX_SHIFT (3U)
/*! FLEXCOMM12_TX - FLEXCOMM12_TX
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA1_FLEXCOMM12_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA1_FLEXCOMM12_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA1_FLEXCOMM12_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA1_HASHCRYPT_IN_MASK (0x10U)
#define INPUTMUX_DMAC0_REQ_ENA1_HASHCRYPT_IN_SHIFT (4U)
/*! HASHCRYPT_IN - HASHCRYPT_IN
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_REQ_ENA1_HASHCRYPT_IN(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA1_HASHCRYPT_IN_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA1_HASHCRYPT_IN_MASK)
/*! @} */

/*! @name DMAC0_REQ_ENA0_SET - DMAC0 request enable set 0 */
/*! @{ */

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM0_RX_MASK (0x1U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM0_RX_SHIFT (0U)
/*! FLEXCOMM0_RX - FLEXCOMM0 RX enable set
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM0_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM0_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM0_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM0_TX_MASK (0x2U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM0_TX_SHIFT (1U)
/*! FLEXCOMM0_TX - FLEXCOMM0 TX enable set
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM0_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM0_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM0_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM1_RX_MASK (0x4U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM1_RX_SHIFT (2U)
/*! FLEXCOMM1_RX - FLEXCOMM1 RX enable set
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM1_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM1_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM1_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM1_TX_MASK (0x8U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM1_TX_SHIFT (3U)
/*! FLEXCOMM1_TX - FLEXCOMM1 TX enable set
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM1_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM1_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM1_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM2_RX_MASK (0x10U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM2_RX_SHIFT (4U)
/*! FLEXCOMM2_RX - FLEXCOMM2 RX enable set
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM2_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM2_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM2_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM2_TX_MASK (0x20U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM2_TX_SHIFT (5U)
/*! FLEXCOMM2_TX - FLEXCOMM2 TX enable set
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM2_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM2_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM2_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM3_RX_MASK (0x40U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM3_RX_SHIFT (6U)
/*! FLEXCOMM3_RX - FLEXCOMM3 RX enable set
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM3_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM3_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM3_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM3_TX_MASK (0x80U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM3_TX_SHIFT (7U)
/*! FLEXCOMM3_TX - FLEXCOMM3 TX enable set
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM3_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM3_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM3_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM4_RX_MASK (0x100U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM4_RX_SHIFT (8U)
/*! FLEXCOMM4_RX - FLEXCOMM4 RX enable set
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM4_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM4_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM4_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM4_TX_MASK (0x200U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM4_TX_SHIFT (9U)
/*! FLEXCOMM4_TX - FLEXCOMM4 TX enable set
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM4_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM4_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM4_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM5_RX_MASK (0x400U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM5_RX_SHIFT (10U)
/*! FLEXCOMM5_RX - FLEXCOMM5 RX enable set
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM5_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM5_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM5_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM5_TX_MASK (0x800U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM5_TX_SHIFT (11U)
/*! FLEXCOMM5_TX - FLEXCOMM5 TX enable set
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM5_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM5_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM5_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM6_RX_MASK (0x1000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM6_RX_SHIFT (12U)
/*! FLEXCOMM6_RX - FLEXCOMM6 RX enable
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM6_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM6_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM6_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM6_TX_MASK (0x2000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM6_TX_SHIFT (13U)
/*! FLEXCOMM6_TX - FLEXCOMM6 TX enable
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM6_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM6_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM6_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM7_RX_MASK (0x4000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM7_RX_SHIFT (14U)
/*! FLEXCOMM7_RX - FLEXCOMM7 RX enable
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM7_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM7_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM7_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM7_TX_MASK (0x8000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM7_TX_SHIFT (15U)
/*! FLEXCOMM7_TX - FLEXCOMM7 TX enable
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM7_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM7_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM7_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH0_FLEXCOMM8_RX_DMA_MASK (0x10000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH0_FLEXCOMM8_RX_DMA_SHIFT (16U)
/*! DMIC0_CH0_FLEXCOMM8_RX_DMA - DMIC0 channel 0 / FLEXCOMM8 RX DMA enable
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH0_FLEXCOMM8_RX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH0_FLEXCOMM8_RX_DMA_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH0_FLEXCOMM8_RX_DMA_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH1_FLEXCOMM8_TX_DMA_MASK (0x20000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH1_FLEXCOMM8_TX_DMA_SHIFT (17U)
/*! DMIC0_CH1_FLEXCOMM8_TX_DMA - DMIC0 channel 1 / FLEXCOMM8 TX DMA enable
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH1_FLEXCOMM8_TX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH1_FLEXCOMM8_TX_DMA_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH1_FLEXCOMM8_TX_DMA_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH2_FLEXCOMM9_RX_DMA_MASK (0x40000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH2_FLEXCOMM9_RX_DMA_SHIFT (18U)
/*! DMIC0_CH2_FLEXCOMM9_RX_DMA - DMIC0 channel 2 / FLEXCOMM9 RX DMA enable
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH2_FLEXCOMM9_RX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH2_FLEXCOMM9_RX_DMA_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH2_FLEXCOMM9_RX_DMA_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH3_FLEXCOMM9_TX_DMA_MASK (0x80000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH3_FLEXCOMM9_TX_DMA_SHIFT (19U)
/*! DMIC0_CH3_FLEXCOMM9_TX_DMA - DMIC0 channel 3 / FLEXCOMM9 TX DMA enable
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH3_FLEXCOMM9_TX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH3_FLEXCOMM9_TX_DMA_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH3_FLEXCOMM9_TX_DMA_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH4_FLEXCOMM10_RX_DMA_MASK (0x100000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH4_FLEXCOMM10_RX_DMA_SHIFT (20U)
/*! DMIC0_CH4_FLEXCOMM10_RX_DMA - DMIC0 channel 4 / FLEXCOMM10 RX DMA enable
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH4_FLEXCOMM10_RX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH4_FLEXCOMM10_RX_DMA_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH4_FLEXCOMM10_RX_DMA_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH5_FLEXCOMM10_TX_DMA_MASK (0x200000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH5_FLEXCOMM10_TX_DMA_SHIFT (21U)
/*! DMIC0_CH5_FLEXCOMM10_TX_DMA - DMIC0 channel 5 / FLEXCOMM10 TX DMA enable
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH5_FLEXCOMM10_TX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH5_FLEXCOMM10_TX_DMA_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH5_FLEXCOMM10_TX_DMA_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH6_FLEXCOMM13_RX_DMA_MASK (0x400000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH6_FLEXCOMM13_RX_DMA_SHIFT (22U)
/*! DMIC0_CH6_FLEXCOMM13_RX_DMA - DMIC0 channel 6 / FLEXCOMM10 RX DMA enable
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH6_FLEXCOMM13_RX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH6_FLEXCOMM13_RX_DMA_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH6_FLEXCOMM13_RX_DMA_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH7_FLEXCOMM13_TX_DMA_MASK (0x800000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH7_FLEXCOMM13_TX_DMA_SHIFT (23U)
/*! DMIC0_CH7_FLEXCOMM13_TX_DMA - DMIC0 channel 7 / FLEXCOMM13 TX DMA enable
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH7_FLEXCOMM13_TX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH7_FLEXCOMM13_TX_DMA_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0_CH7_FLEXCOMM13_TX_DMA_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_I3C0_RX_MASK (0x1000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_I3C0_RX_SHIFT (24U)
/*! I3C0_RX - I3C RX enable set
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_I3C0_RX(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_I3C0_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_I3C0_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_I3C0_TX_MASK (0x2000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_I3C0_TX_SHIFT (25U)
/*! I3C0_TX - I3C TX enable set
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_I3C0_TX(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_I3C0_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_I3C0_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM14_RX_MASK (0x4000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM14_RX_SHIFT (26U)
/*! FLEXCOMM14_RX - FLEXCOMM14 RX enable set
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM14_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM14_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM14_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM14_TX_MASK (0x8000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM14_TX_SHIFT (27U)
/*! FLEXCOMM14_TX - FLEXCOMM14 TX enable set
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM14_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM14_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM14_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM16_RX_MASK (0x10000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM16_RX_SHIFT (28U)
/*! FLEXCOMM16_RX - FLEXCOMM16 RX enable
 *  0b0..No effect
 *  0b1..Sets the ENA0 bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM16_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM16_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM16_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM16_TX_MASK (0x20000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM16_TX_SHIFT (29U)
/*! FLEXCOMM16_TX - FLEXCOMM16 RX enable
 *  0b0..No effect
 *  0b1..Sets the ENA0 bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM16_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM16_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM16_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_I3C1_RX_MASK (0x40000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_I3C1_RX_SHIFT (30U)
/*! I3C1_RX - I3C1_RX enable
 *  0b0..No effect
 *  0b1..Sets the ENA0 bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_I3C1_RX(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_I3C1_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_I3C1_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_I3C1_TX_MASK (0x80000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_I3C1_TX_SHIFT (31U)
/*! I3C1_TX - I3C1_TX enable
 *  0b0..No effect
 *  0b1..Sets the ENA0 bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_I3C1_TX(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_I3C1_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_I3C1_TX_MASK)
/*! @} */

/*! @name DMAC0_REQ_ENA1_SET - DMAC0 request enable set 1 */
/*! @{ */

#define INPUTMUX_DMAC0_REQ_ENA1_SET_FLEXCOMM11_RX_MASK (0x1U)
#define INPUTMUX_DMAC0_REQ_ENA1_SET_FLEXCOMM11_RX_SHIFT (0U)
/*! FLEXCOMM11_RX - FLEXCOMM11_RX
 *  0b0..No Effect
 *  0b1..Sets the ENA1 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA1_SET_FLEXCOMM11_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA1_SET_FLEXCOMM11_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA1_SET_FLEXCOMM11_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA1_SET_FLEXCOMM11_TX_MASK (0x2U)
#define INPUTMUX_DMAC0_REQ_ENA1_SET_FLEXCOMM11_TX_SHIFT (1U)
/*! FLEXCOMM11_TX - FLEXCOMM11_TX
 *  0b0..No Effect
 *  0b1..Sets the ENA1 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA1_SET_FLEXCOMM11_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA1_SET_FLEXCOMM11_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA1_SET_FLEXCOMM11_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA1_SET_FLEXCOMM12_RX_MASK (0x4U)
#define INPUTMUX_DMAC0_REQ_ENA1_SET_FLEXCOMM12_RX_SHIFT (2U)
/*! FLEXCOMM12_RX - FLEXCOMM12_RX
 *  0b0..No Effect
 *  0b1..Sets the ENA1 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA1_SET_FLEXCOMM12_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA1_SET_FLEXCOMM12_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA1_SET_FLEXCOMM12_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA1_SET_FLEXCOMM12_TX_MASK (0x8U)
#define INPUTMUX_DMAC0_REQ_ENA1_SET_FLEXCOMM12_TX_SHIFT (3U)
/*! FLEXCOMM12_TX - FLEXCOMM12_TX
 *  0b0..No Effect
 *  0b1..Sets the ENA1 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA1_SET_FLEXCOMM12_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA1_SET_FLEXCOMM12_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA1_SET_FLEXCOMM12_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA1_SET_HASHCRYPT_IN_MASK (0x10U)
#define INPUTMUX_DMAC0_REQ_ENA1_SET_HASHCRYPT_IN_SHIFT (4U)
/*! HASHCRYPT_IN - HASHCRYPT_IN
 *  0b0..No Effect
 *  0b1..Sets the ENA1 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA1_SET_HASHCRYPT_IN(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA1_SET_HASHCRYPT_IN_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA1_SET_HASHCRYPT_IN_MASK)
/*! @} */

/*! @name DMAC0_REQ_ENA0_CLR - DMAC0 request enable clear 0 */
/*! @{ */

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM0_RX_MASK (0x1U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM0_RX_SHIFT (0U)
/*! FLEXCOMM0_RX - FLEXCOMM0 RX enable clear
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM0_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM0_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM0_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM0_TX_MASK (0x2U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM0_TX_SHIFT (1U)
/*! FLEXCOMM0_TX - FLEXCOMM0 TX enable clear
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM0_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM0_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM0_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM1_RX_MASK (0x4U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM1_RX_SHIFT (2U)
/*! FLEXCOMM1_RX - FLEXCOMM1 RX enable clear
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM1_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM1_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM1_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM1_TX_MASK (0x8U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM1_TX_SHIFT (3U)
/*! FLEXCOMM1_TX - FLEXCOMM1 TX enable clear
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM1_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM1_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM1_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM2_RX_MASK (0x10U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM2_RX_SHIFT (4U)
/*! FLEXCOMM2_RX - FLEXCOMM2 RX enable clear
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM2_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM2_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM2_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM2_TX_MASK (0x20U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM2_TX_SHIFT (5U)
/*! FLEXCOMM2_TX - FLEXCOMM2 TX enable clear
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM2_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM2_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM2_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM3_RX_MASK (0x40U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM3_RX_SHIFT (6U)
/*! FLEXCOMM3_RX - FLEXCOMM3 RX enable clear
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM3_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM3_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM3_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM3_TX_MASK (0x80U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM3_TX_SHIFT (7U)
/*! FLEXCOMM3_TX - FLEXCOMM3 TX enable clear
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM3_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM3_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM3_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM4_RX_MASK (0x100U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM4_RX_SHIFT (8U)
/*! FLEXCOMM4_RX - FLEXCOMM4 RX enable clear
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM4_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM4_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM4_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM4_TX_MASK (0x200U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM4_TX_SHIFT (9U)
/*! FLEXCOMM4_TX - FLEXCOMM4 TX enable clear
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM4_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM4_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM4_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM5_RX_MASK (0x400U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM5_RX_SHIFT (10U)
/*! FLEXCOMM5_RX - FLEXCOMM5 RX enable clear
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM5_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM5_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM5_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM5_TX_MASK (0x800U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM5_TX_SHIFT (11U)
/*! FLEXCOMM5_TX - FLEXCOMM5 TX enable clear
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM5_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM5_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM5_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM6_RX_MASK (0x1000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM6_RX_SHIFT (12U)
/*! FLEXCOMM6_RX - FLEXCOMM6 RX enable
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM6_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM6_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM6_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM6_TX_MASK (0x2000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM6_TX_SHIFT (13U)
/*! FLEXCOMM6_TX - FLEXCOMM6 TX enable
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM6_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM6_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM6_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM7_RX_MASK (0x4000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM7_RX_SHIFT (14U)
/*! FLEXCOMM7_RX - FLEXCOMM7 RX enable
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM7_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM7_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM7_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM7_TX_MASK (0x8000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM7_TX_SHIFT (15U)
/*! FLEXCOMM7_TX - FLEXCOMM7 TX enable
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM7_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM7_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM7_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH0_FLEXCOMM8_RX_DMA_MASK (0x10000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH0_FLEXCOMM8_RX_DMA_SHIFT (16U)
/*! DMIC0_CH0_FLEXCOMM8_RX_DMA - DMIC0 channel 0 / FLEXCOMM8 RX DMA enable
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH0_FLEXCOMM8_RX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH0_FLEXCOMM8_RX_DMA_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH0_FLEXCOMM8_RX_DMA_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH1_FLEXCOMM8_TX_DMA_MASK (0x20000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH1_FLEXCOMM8_TX_DMA_SHIFT (17U)
/*! DMIC0_CH1_FLEXCOMM8_TX_DMA - DMIC0 channel 1 / FLEXCOMM8 TX DMA enable
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH1_FLEXCOMM8_TX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH1_FLEXCOMM8_TX_DMA_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH1_FLEXCOMM8_TX_DMA_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH2_FLEXCOMM9_RX_DMA_MASK (0x40000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH2_FLEXCOMM9_RX_DMA_SHIFT (18U)
/*! DMIC0_CH2_FLEXCOMM9_RX_DMA - DMIC0 channel 2 / FLEXCOMM9 RX DMA enable
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH2_FLEXCOMM9_RX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH2_FLEXCOMM9_RX_DMA_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH2_FLEXCOMM9_RX_DMA_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH3_FLEXCOMM9_TX_DMA_MASK (0x80000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH3_FLEXCOMM9_TX_DMA_SHIFT (19U)
/*! DMIC0_CH3_FLEXCOMM9_TX_DMA - DMIC0 channel 3 / FLEXCOMM9 TX DMA enable
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH3_FLEXCOMM9_TX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH3_FLEXCOMM9_TX_DMA_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH3_FLEXCOMM9_TX_DMA_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH4_FLEXCOMM10_RX_DMA_MASK (0x100000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH4_FLEXCOMM10_RX_DMA_SHIFT (20U)
/*! DMIC0_CH4_FLEXCOMM10_RX_DMA - DMIC0 channel 4 / FLEXCOMM10 RX DMA enable
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH4_FLEXCOMM10_RX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH4_FLEXCOMM10_RX_DMA_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH4_FLEXCOMM10_RX_DMA_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH5_FLEXCOMM10_TX_DMA_MASK (0x200000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH5_FLEXCOMM10_TX_DMA_SHIFT (21U)
/*! DMIC0_CH5_FLEXCOMM10_TX_DMA - DMIC0 channel 5 / FLEXCOMM10 TX DMA enable
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH5_FLEXCOMM10_TX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH5_FLEXCOMM10_TX_DMA_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH5_FLEXCOMM10_TX_DMA_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH6_FLEXCOMM13_RX_DMA_MASK (0x400000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH6_FLEXCOMM13_RX_DMA_SHIFT (22U)
/*! DMIC0_CH6_FLEXCOMM13_RX_DMA - DMIC0 channel 6 / FLEXCOMM13 RX DMA enable
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH6_FLEXCOMM13_RX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH6_FLEXCOMM13_RX_DMA_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH6_FLEXCOMM13_RX_DMA_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH7_FLEXCOMM13_TX_DMA_MASK (0x800000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH7_FLEXCOMM13_TX_DMA_SHIFT (23U)
/*! DMIC0_CH7_FLEXCOMM13_TX_DMA - DMIC0 channel 7 / FLEXCOMM13 TX DMA enable
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH7_FLEXCOMM13_TX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH7_FLEXCOMM13_TX_DMA_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0_CH7_FLEXCOMM13_TX_DMA_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_I3C0_RX_MASK (0x1000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_I3C0_RX_SHIFT (24U)
/*! I3C0_RX - I3C RX enable clear
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_I3C0_RX(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_I3C0_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_I3C0_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_I3C0_TX_MASK (0x2000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_I3C0_TX_SHIFT (25U)
/*! I3C0_TX - I3C TX enable clear
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_I3C0_TX(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_I3C0_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_I3C0_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM14_RX_MASK (0x4000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM14_RX_SHIFT (26U)
/*! FLEXCOMM14_RX - FLEXCOMM14 RX enable clear
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM14_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM14_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM14_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM14_TX_MASK (0x8000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM14_TX_SHIFT (27U)
/*! FLEXCOMM14_TX - FLEXCOMM14 TX enable clear
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM14_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM14_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM14_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM16_RX_MASK (0x10000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM16_RX_SHIFT (28U)
/*! FLEXCOMM16_RX - FLEXCOMM16 RX enable
 *  0b0..No effect
 *  0b1..Clears the ENA0 bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM16_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM16_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM16_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM16_TX_MASK (0x20000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM16_TX_SHIFT (29U)
/*! FLEXCOMM16_TX - FLEXCOMM16 TX enable
 *  0b0..No effect
 *  0b1..Clears the ENA0 bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM16_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM16_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM16_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_I3C1_RX_MASK (0x40000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_I3C1_RX_SHIFT (30U)
/*! I3C1_RX - I3C1_RX enable
 *  0b0..No effect
 *  0b1..Clears the ENA0 bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_I3C1_RX(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_I3C1_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_I3C1_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_I3C1_TX_MASK (0x80000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_I3C1_TX_SHIFT (31U)
/*! I3C1_TX - I3C1_TX enable
 *  0b0..No effect
 *  0b1..Clears the ENA0 bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_I3C1_TX(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_I3C1_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_I3C1_TX_MASK)
/*! @} */

/*! @name DMAC0_REQ_ENA1_CLR - DMAC0 request enable 1 clear */
/*! @{ */

#define INPUTMUX_DMAC0_REQ_ENA1_CLR_FLEXCOMM11_RX_MASK (0x1U)
#define INPUTMUX_DMAC0_REQ_ENA1_CLR_FLEXCOMM11_RX_SHIFT (0U)
/*! FLEXCOMM11_RX - FLEXCOMM11_RX
 *  0b0..No effect
 *  0b1..Clears the ENA1 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA1_CLR_FLEXCOMM11_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA1_CLR_FLEXCOMM11_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA1_CLR_FLEXCOMM11_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA1_CLR_FLEXCOMM11_TX_MASK (0x2U)
#define INPUTMUX_DMAC0_REQ_ENA1_CLR_FLEXCOMM11_TX_SHIFT (1U)
/*! FLEXCOMM11_TX - FLEXCOMM11_TX
 *  0b0..No effect
 *  0b1..Clears the ENA1 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA1_CLR_FLEXCOMM11_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA1_CLR_FLEXCOMM11_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA1_CLR_FLEXCOMM11_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA1_CLR_FLEXCOMM12_RX_MASK (0x4U)
#define INPUTMUX_DMAC0_REQ_ENA1_CLR_FLEXCOMM12_RX_SHIFT (2U)
/*! FLEXCOMM12_RX - FLEXCOMM12_RX
 *  0b0..No effect
 *  0b1..Clears the ENA1 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA1_CLR_FLEXCOMM12_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA1_CLR_FLEXCOMM12_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA1_CLR_FLEXCOMM12_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA1_CLR_FLEXCOMM12_TX_MASK (0x8U)
#define INPUTMUX_DMAC0_REQ_ENA1_CLR_FLEXCOMM12_TX_SHIFT (3U)
/*! FLEXCOMM12_TX - FLEXCOMM12_TX
 *  0b0..No effect
 *  0b1..Clears the ENA1 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA1_CLR_FLEXCOMM12_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA1_CLR_FLEXCOMM12_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA1_CLR_FLEXCOMM12_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA1_CLR_HASHCRYPT_IN_MASK (0x10U)
#define INPUTMUX_DMAC0_REQ_ENA1_CLR_HASHCRYPT_IN_SHIFT (4U)
/*! HASHCRYPT_IN - HASHCRYPT_IN
 *  0b0..No effect
 *  0b1..Clears the ENA1 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA1_CLR_HASHCRYPT_IN(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA1_CLR_HASHCRYPT_IN_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA1_CLR_HASHCRYPT_IN_MASK)
/*! @} */

/*! @name DMAC1_REQ_ENA0 - DMAC1 request enable 0 */
/*! @{ */

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM0_RX_MASK (0x1U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM0_RX_SHIFT (0U)
/*! FLEXCOMM0_RX - FLEXCOMM0_RX
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM0_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM0_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM0_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM0_TX_MASK (0x2U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM0_TX_SHIFT (1U)
/*! FLEXCOMM0_TX - FLEXCOMM0_TX
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM0_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM0_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM0_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM1_RX_MASK (0x4U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM1_RX_SHIFT (2U)
/*! FLEXCOMM1_RX - FLEXCOMM1_RX
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM1_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM1_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM1_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM1_TX_MASK (0x8U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM1_TX_SHIFT (3U)
/*! FLEXCOMM1_TX - FLEXCOMM1_TX
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM1_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM1_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM1_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM2_RX_MASK (0x10U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM2_RX_SHIFT (4U)
/*! FLEXCOMM2_RX - FLEXCOMM2_RX
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM2_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM2_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM2_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM2_TX_MASK (0x20U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM2_TX_SHIFT (5U)
/*! FLEXCOMM2_TX - FLEXCOMM2_TX
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM2_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM2_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM2_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM3_RX_MASK (0x40U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM3_RX_SHIFT (6U)
/*! FLEXCOMM3_RX - FLEXCOMM3_RX
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM3_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM3_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM3_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM3_TX_MASK (0x80U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM3_TX_SHIFT (7U)
/*! FLEXCOMM3_TX - FLEXCOMM3_TX
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM3_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM3_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM3_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM4_RX_MASK (0x100U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM4_RX_SHIFT (8U)
/*! FLEXCOMM4_RX - FLEXCOMM4_RX
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM4_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM4_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM4_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM4_TX_MASK (0x200U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM4_TX_SHIFT (9U)
/*! FLEXCOMM4_TX - FLEXCOMM4_TX
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM4_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM4_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM4_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM5_RX_MASK (0x400U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM5_RX_SHIFT (10U)
/*! FLEXCOMM5_RX - FLEXCOMM5_RX
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM5_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM5_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM5_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM5_TX_MASK (0x800U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM5_TX_SHIFT (11U)
/*! FLEXCOMM5_TX - FLEXCOMM5_TX
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM5_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM5_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM5_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM6_RX_MASK (0x1000U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM6_RX_SHIFT (12U)
/*! FLEXCOMM6_RX - FLEXCOMM6_RX
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM6_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM6_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM6_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM6_TX_MASK (0x2000U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM6_TX_SHIFT (13U)
/*! FLEXCOMM6_TX - FLEXCOMM6_TX
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM6_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM6_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM6_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM7_RX_MASK (0x4000U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM7_RX_SHIFT (14U)
/*! FLEXCOMM7_RX - FLEXCOMM7_RX
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM7_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM7_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM7_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM7_TX_MASK (0x8000U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM7_TX_SHIFT (15U)
/*! FLEXCOMM7_TX - FLEXCOMM7_TX
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM7_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM7_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM7_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH0_FLEXCOMM8_RX_DMA_MASK (0x10000U)
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH0_FLEXCOMM8_RX_DMA_SHIFT (16U)
/*! DMIC0_CH0_FLEXCOMM8_RX_DMA - DMIC0 channel 0 / FLEXCOMM8 RX DMA enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH0_FLEXCOMM8_RX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH0_FLEXCOMM8_RX_DMA_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH0_FLEXCOMM8_RX_DMA_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH1_FLEXCOMM8_TX_DMA_MASK (0x20000U)
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH1_FLEXCOMM8_TX_DMA_SHIFT (17U)
/*! DMIC0_CH1_FLEXCOMM8_TX_DMA - DMIC0 channel 1 / FLEXCOMM8 TX DMA enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH1_FLEXCOMM8_TX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH1_FLEXCOMM8_TX_DMA_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH1_FLEXCOMM8_TX_DMA_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH2_FLEXCOMM9_RX_DMA_MASK (0x40000U)
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH2_FLEXCOMM9_RX_DMA_SHIFT (18U)
/*! DMIC0_CH2_FLEXCOMM9_RX_DMA - DMIC0 channel 2/ FLEXCOMM9 RX DMA enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH2_FLEXCOMM9_RX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH2_FLEXCOMM9_RX_DMA_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH2_FLEXCOMM9_RX_DMA_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH3_FLEXCOMM9_TX_DMA_MASK (0x80000U)
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH3_FLEXCOMM9_TX_DMA_SHIFT (19U)
/*! DMIC0_CH3_FLEXCOMM9_TX_DMA - DMIC0 channel 3 / FLEXCOMM9 TX DMA enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH3_FLEXCOMM9_TX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH3_FLEXCOMM9_TX_DMA_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH3_FLEXCOMM9_TX_DMA_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH4_FLEXCOMM10_RX_DMA_MASK (0x100000U)
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH4_FLEXCOMM10_RX_DMA_SHIFT (20U)
/*! DMIC0_CH4_FLEXCOMM10_RX_DMA - DMIC0 channel 4 / FLEXCOMM10 RX DMA enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH4_FLEXCOMM10_RX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH4_FLEXCOMM10_RX_DMA_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH4_FLEXCOMM10_RX_DMA_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH5_FLEXCOMM10_TX_DMA_MASK (0x200000U)
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH5_FLEXCOMM10_TX_DMA_SHIFT (21U)
/*! DMIC0_CH5_FLEXCOMM10_TX_DMA - DMIC0 channel 5 / FLEXCOMM10 TX DMA enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH5_FLEXCOMM10_TX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH5_FLEXCOMM10_TX_DMA_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH5_FLEXCOMM10_TX_DMA_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH6_FLEXCOMM13_RX_DMA_MASK (0x400000U)
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH6_FLEXCOMM13_RX_DMA_SHIFT (22U)
/*! DMIC0_CH6_FLEXCOMM13_RX_DMA - DMIC0 channel 6 / FLEXCOMM13 RX DMA enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH6_FLEXCOMM13_RX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH6_FLEXCOMM13_RX_DMA_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH6_FLEXCOMM13_RX_DMA_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH7_FLEXCOMM13_TX_DMA_MASK (0x800000U)
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH7_FLEXCOMM13_TX_DMA_SHIFT (23U)
/*! DMIC0_CH7_FLEXCOMM13_TX_DMA - DMIC0 channel 7 / FLEXCOMM13 TX DMA enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH7_FLEXCOMM13_TX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH7_FLEXCOMM13_TX_DMA_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_DMIC0_CH7_FLEXCOMM13_TX_DMA_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_I3C0_RX_MASK     (0x1000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_I3C0_RX_SHIFT    (24U)
/*! I3C0_RX - I3C RX enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_I3C0_RX(x)       (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_I3C0_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_I3C0_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_I3C0_TX_MASK     (0x2000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_I3C0_TX_SHIFT    (25U)
/*! I3C0_TX - I3C TX enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_I3C0_TX(x)       (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_I3C0_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_I3C0_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM14_RX_MASK (0x4000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM14_RX_SHIFT (26U)
/*! FLEXCOMM14_RX - FLEXCOMM14 RX enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM14_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM14_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM14_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM14_TX_MASK (0x8000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM14_TX_SHIFT (27U)
/*! FLEXCOMM14_TX - FLEXCOMM14 TX enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM14_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM14_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM14_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM16_RX_MASK (0x10000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM16_RX_SHIFT (28U)
/*! FLEXCOMM16_RX - FLEXCOMM16 RX enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM16_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM16_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM16_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM16_TX_MASK (0x20000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM16_TX_SHIFT (29U)
/*! FLEXCOMM16_TX - FLEXCOMM16 RX enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM16_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM16_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM16_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_I3C1_RX_MASK     (0x40000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_I3C1_RX_SHIFT    (30U)
/*! I3C1_RX - I3C1_RX enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_I3C1_RX(x)       (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_I3C1_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_I3C1_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_I3C1_TX_MASK     (0x80000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_I3C1_TX_SHIFT    (31U)
/*! I3C1_TX - I3C1_TX enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_I3C1_TX(x)       (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_I3C1_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_I3C1_TX_MASK)
/*! @} */

/*! @name DMAC1_REQ_ENA1 - DMAC1 request enable 1 */
/*! @{ */

#define INPUTMUX_DMAC1_REQ_ENA1_FLEXCOMM11_RX_MASK (0x1U)
#define INPUTMUX_DMAC1_REQ_ENA1_FLEXCOMM11_RX_SHIFT (0U)
/*! FLEXCOMM11_RX - FLEXCOMM11_RX
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA1_FLEXCOMM11_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA1_FLEXCOMM11_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA1_FLEXCOMM11_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA1_FLEXCOMM11_TX_MASK (0x2U)
#define INPUTMUX_DMAC1_REQ_ENA1_FLEXCOMM11_TX_SHIFT (1U)
/*! FLEXCOMM11_TX - FLEXCOMM11_TX
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA1_FLEXCOMM11_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA1_FLEXCOMM11_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA1_FLEXCOMM11_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA1_FLEXCOMM12_RX_MASK (0x4U)
#define INPUTMUX_DMAC1_REQ_ENA1_FLEXCOMM12_RX_SHIFT (2U)
/*! FLEXCOMM12_RX - FLEXCOMM12_RX
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA1_FLEXCOMM12_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA1_FLEXCOMM12_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA1_FLEXCOMM12_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA1_FLEXCOMM12_TX_MASK (0x8U)
#define INPUTMUX_DMAC1_REQ_ENA1_FLEXCOMM12_TX_SHIFT (3U)
/*! FLEXCOMM12_TX - FLEXCOMM12_TX
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA1_FLEXCOMM12_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA1_FLEXCOMM12_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA1_FLEXCOMM12_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA1_HASHCRYPT_IN_MASK (0x10U)
#define INPUTMUX_DMAC1_REQ_ENA1_HASHCRYPT_IN_SHIFT (4U)
/*! HASHCRYPT_IN - HASHCRYPT_IN
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_REQ_ENA1_HASHCRYPT_IN(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA1_HASHCRYPT_IN_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA1_HASHCRYPT_IN_MASK)
/*! @} */

/*! @name DMAC1_REQ_ENA0_SET - DMAC1 request enable set 0 */
/*! @{ */

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM0_RX_MASK (0x1U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM0_RX_SHIFT (0U)
/*! FLEXCOMM0_RX
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM0_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM0_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM0_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM0_TX_MASK (0x2U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM0_TX_SHIFT (1U)
/*! FLEXCOMM0_TX
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM0_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM0_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM0_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM1_RX_MASK (0x4U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM1_RX_SHIFT (2U)
/*! FLEXCOMM1_RX
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM1_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM1_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM1_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM1_TX_MASK (0x8U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM1_TX_SHIFT (3U)
/*! FLEXCOMM1_TX
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM1_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM1_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM1_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM2_RX_MASK (0x10U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM2_RX_SHIFT (4U)
/*! FLEXCOMM2_RX
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM2_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM2_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM2_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM2_TX_MASK (0x20U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM2_TX_SHIFT (5U)
/*! FLEXCOMM2_TX
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM2_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM2_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM2_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM3_RX_MASK (0x40U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM3_RX_SHIFT (6U)
/*! FLEXCOMM3_RX
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM3_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM3_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM3_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM3_TX_MASK (0x80U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM3_TX_SHIFT (7U)
/*! FLEXCOMM3_TX
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM3_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM3_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM3_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM4_RX_MASK (0x100U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM4_RX_SHIFT (8U)
/*! FLEXCOMM4_RX
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM4_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM4_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM4_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM4_TX_MASK (0x200U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM4_TX_SHIFT (9U)
/*! FLEXCOMM4_TX
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM4_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM4_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM4_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM5_RX_MASK (0x400U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM5_RX_SHIFT (10U)
/*! FLEXCOMM5_RX
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM5_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM5_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM5_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM5_TX_MASK (0x800U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM5_TX_SHIFT (11U)
/*! FLEXCOMM5_TX
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM5_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM5_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM5_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM6_RX_MASK (0x1000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM6_RX_SHIFT (12U)
/*! FLEXCOMM6_RX
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM6_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM6_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM6_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM6_TX_MASK (0x2000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM6_TX_SHIFT (13U)
/*! FLEXCOMM6_TX - FLEXCOMM6 TX enable
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM6_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM6_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM6_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM7_RX_MASK (0x4000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM7_RX_SHIFT (14U)
/*! FLEXCOMM7_RX - FLEXCOMM7 RX enable
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM7_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM7_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM7_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM7_TX_MASK (0x8000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM7_TX_SHIFT (15U)
/*! FLEXCOMM7_TX - FLEXCOMM7 TX enable
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM7_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM7_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM7_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH0_FLEXCOMM8_RX_DMA_MASK (0x10000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH0_FLEXCOMM8_RX_DMA_SHIFT (16U)
/*! DMIC0_CH0_FLEXCOMM8_RX_DMA - DMIC0 channel 0 / FLEXCOMM8 RX DMA enable
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH0_FLEXCOMM8_RX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH0_FLEXCOMM8_RX_DMA_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH0_FLEXCOMM8_RX_DMA_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH1_FLEXCOMM8_TX_DMA_MASK (0x20000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH1_FLEXCOMM8_TX_DMA_SHIFT (17U)
/*! DMIC0_CH1_FLEXCOMM8_TX_DMA - DMIC0 channel 1 / FLEXCOMM8 TX DMA enable
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH1_FLEXCOMM8_TX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH1_FLEXCOMM8_TX_DMA_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH1_FLEXCOMM8_TX_DMA_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH2_FLEXCOMM9_RX_DMA_MASK (0x40000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH2_FLEXCOMM9_RX_DMA_SHIFT (18U)
/*! DMIC0_CH2_FLEXCOMM9_RX_DMA - DMIC0 channel 2 / FLEXCOMM9 RX DMA enable
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH2_FLEXCOMM9_RX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH2_FLEXCOMM9_RX_DMA_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH2_FLEXCOMM9_RX_DMA_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH3_FLEXCOMM9_TX_DMA_MASK (0x80000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH3_FLEXCOMM9_TX_DMA_SHIFT (19U)
/*! DMIC0_CH3_FLEXCOMM9_TX_DMA - DMIC0 channel 3 / FLEXCOMM9 TX DMA enable
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH3_FLEXCOMM9_TX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH3_FLEXCOMM9_TX_DMA_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH3_FLEXCOMM9_TX_DMA_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH4_FLEXCOMM10_RX_DMA_MASK (0x100000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH4_FLEXCOMM10_RX_DMA_SHIFT (20U)
/*! DMIC0_CH4_FLEXCOMM10_RX_DMA - DMIC0 channel 4 / FLEXCOMM10 RX DMA enable
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH4_FLEXCOMM10_RX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH4_FLEXCOMM10_RX_DMA_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH4_FLEXCOMM10_RX_DMA_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH5_FLEXCOMM10_TX_DMA_MASK (0x200000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH5_FLEXCOMM10_TX_DMA_SHIFT (21U)
/*! DMIC0_CH5_FLEXCOMM10_TX_DMA - DMIC0 channel 5 / FLEXCOMM10 TX DMA enable
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH5_FLEXCOMM10_TX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH5_FLEXCOMM10_TX_DMA_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH5_FLEXCOMM10_TX_DMA_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH6_FLEXCOMM13_RX_DMA_MASK (0x400000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH6_FLEXCOMM13_RX_DMA_SHIFT (22U)
/*! DMIC0_CH6_FLEXCOMM13_RX_DMA - DMIC0 channel 6 / FLEXCOMM13 RX DMA enable
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH6_FLEXCOMM13_RX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH6_FLEXCOMM13_RX_DMA_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH6_FLEXCOMM13_RX_DMA_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH7_FLEXCOMM13_TX_DMA_MASK (0x800000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH7_FLEXCOMM13_TX_DMA_SHIFT (23U)
/*! DMIC0_CH7_FLEXCOMM13_TX_DMA - DMIC0 channel 7 / FLEXCOMM13 TX DMA enable
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH7_FLEXCOMM13_TX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH7_FLEXCOMM13_TX_DMA_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0_CH7_FLEXCOMM13_TX_DMA_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_I3C0_RX_MASK (0x1000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_I3C0_RX_SHIFT (24U)
/*! I3C0_RX - I3C RX enable set
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_I3C0_RX(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_I3C0_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_I3C0_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_I3C0_TX_MASK (0x2000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_I3C0_TX_SHIFT (25U)
/*! I3C0_TX - I3C TX enable set
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_I3C0_TX(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_I3C0_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_I3C0_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM14_RX_MASK (0x4000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM14_RX_SHIFT (26U)
/*! FLEXCOMM14_RX - FLEXCOMM14 RX enable set
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM14_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM14_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM14_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM14_TX_MASK (0x8000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM14_TX_SHIFT (27U)
/*! FLEXCOMM14_TX - FLEXCOMM14 TX enable set
 *  0b0..No effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM14_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM14_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM14_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM16_RX_MASK (0x10000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM16_RX_SHIFT (28U)
/*! FLEXCOMM16_RX - FLEXCOMM16 RX enable
 *  0b0..No effect
 *  0b1..Sets the ENA0 bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM16_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM16_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM16_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM16_TX_MASK (0x20000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM16_TX_SHIFT (29U)
/*! FLEXCOMM16_TX - FLEXCOMM16 TX enable
 *  0b0..No effect
 *  0b1..Sets the ENA0 bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM16_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM16_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM16_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_I3C1_RX_MASK (0x40000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_I3C1_RX_SHIFT (30U)
/*! I3C1_RX - I3C1_RX enable
 *  0b0..No effect
 *  0b1..Sets the ENA0 bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_I3C1_RX(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_I3C1_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_I3C1_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_I3C1_TX_MASK (0x80000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_I3C1_TX_SHIFT (31U)
/*! I3C1_TX - I3C1_TX enable
 *  0b0..No effect
 *  0b1..Sets the ENA0 bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_I3C1_TX(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_I3C1_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_I3C1_TX_MASK)
/*! @} */

/*! @name DMAC1_REQ_ENA1_SET - DMAC1 request enable set 1 */
/*! @{ */

#define INPUTMUX_DMAC1_REQ_ENA1_SET_FLEXCOMM11_RX_MASK (0x1U)
#define INPUTMUX_DMAC1_REQ_ENA1_SET_FLEXCOMM11_RX_SHIFT (0U)
/*! FLEXCOMM11_RX - FLEXIO_SHFT_FLEXCOMM_RX
 *  0b0..No Effect
 *  0b1..Sets the ENA1 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA1_SET_FLEXCOMM11_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA1_SET_FLEXCOMM11_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA1_SET_FLEXCOMM11_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA1_SET_FLEXCOMM11_TX_MASK (0x2U)
#define INPUTMUX_DMAC1_REQ_ENA1_SET_FLEXCOMM11_TX_SHIFT (1U)
/*! FLEXCOMM11_TX - FLEXIO_SHFT_FLEXCOMM_TX
 *  0b0..No Effect
 *  0b1..Sets the ENA1 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA1_SET_FLEXCOMM11_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA1_SET_FLEXCOMM11_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA1_SET_FLEXCOMM11_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA1_SET_FLEXCOMM12_RX_MASK (0x4U)
#define INPUTMUX_DMAC1_REQ_ENA1_SET_FLEXCOMM12_RX_SHIFT (2U)
/*! FLEXCOMM12_RX - FLEXCOMM12_RX
 *  0b0..No Effect
 *  0b1..Sets the ENA1 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA1_SET_FLEXCOMM12_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA1_SET_FLEXCOMM12_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA1_SET_FLEXCOMM12_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA1_SET_FLEXCOMM12_TX_MASK (0x8U)
#define INPUTMUX_DMAC1_REQ_ENA1_SET_FLEXCOMM12_TX_SHIFT (3U)
/*! FLEXCOMM12_TX - FLEXCOMM12_TX
 *  0b0..No Effect
 *  0b1..Sets the ENA1 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA1_SET_FLEXCOMM12_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA1_SET_FLEXCOMM12_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA1_SET_FLEXCOMM12_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA1_SET_HASHCRYPT_IN_MASK (0x10U)
#define INPUTMUX_DMAC1_REQ_ENA1_SET_HASHCRYPT_IN_SHIFT (4U)
/*! HASHCRYPT_IN - HASHCRYPT_IN
 *  0b0..No Effect
 *  0b1..Sets the ENA1 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA1_SET_HASHCRYPT_IN(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA1_SET_HASHCRYPT_IN_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA1_SET_HASHCRYPT_IN_MASK)
/*! @} */

/*! @name DMAC1_REQ_ENA0_CLR - DMAC1 request enable clear 0 */
/*! @{ */

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM0_RX_MASK (0x1U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM0_RX_SHIFT (0U)
/*! FLEXCOMM0_RX - FLEXCOMM0 RX enable clear
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM0_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM0_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM0_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM0_TX_MASK (0x2U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM0_TX_SHIFT (1U)
/*! FLEXCOMM0_TX - FLEXCOMM0 TX enable clear
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM0_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM0_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM0_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM1_RX_MASK (0x4U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM1_RX_SHIFT (2U)
/*! FLEXCOMM1_RX - FLEXCOMM1 RX enable clear
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM1_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM1_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM1_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM1_TX_MASK (0x8U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM1_TX_SHIFT (3U)
/*! FLEXCOMM1_TX - FLEXCOMM1 TX enable clear
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM1_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM1_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM1_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM2_RX_MASK (0x10U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM2_RX_SHIFT (4U)
/*! FLEXCOMM2_RX - FLEXCOMM2 RX enable clear
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM2_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM2_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM2_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM2_TX_MASK (0x20U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM2_TX_SHIFT (5U)
/*! FLEXCOMM2_TX - FLEXCOMM2 TX enable clear
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM2_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM2_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM2_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM3_RX_MASK (0x40U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM3_RX_SHIFT (6U)
/*! FLEXCOMM3_RX - FLEXCOMM3 RX enable clear
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM3_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM3_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM3_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM3_TX_MASK (0x80U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM3_TX_SHIFT (7U)
/*! FLEXCOMM3_TX - FLEXCOMM3 TX enable clear
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM3_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM3_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM3_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM4_RX_MASK (0x100U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM4_RX_SHIFT (8U)
/*! FLEXCOMM4_RX - FLEXCOMM4 RX enable clear
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM4_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM4_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM4_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM4_TX_MASK (0x200U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM4_TX_SHIFT (9U)
/*! FLEXCOMM4_TX - FLEXCOMM4 TX enable clear
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM4_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM4_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM4_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM5_RX_MASK (0x400U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM5_RX_SHIFT (10U)
/*! FLEXCOMM5_RX - FLEXCOMM5 RX enable clear
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM5_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM5_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM5_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM5_TX_MASK (0x800U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM5_TX_SHIFT (11U)
/*! FLEXCOMM5_TX - FLEXCOMM5 TX enable clear
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM5_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM5_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM5_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM6_RX_MASK (0x1000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM6_RX_SHIFT (12U)
/*! FLEXCOMM6_RX - FLEXCOMM6 RX enable
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM6_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM6_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM6_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM6_TX_MASK (0x2000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM6_TX_SHIFT (13U)
/*! FLEXCOMM6_TX - FLEXCOMM6 TX enable
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM6_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM6_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM6_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM7_RX_MASK (0x4000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM7_RX_SHIFT (14U)
/*! FLEXCOMM7_RX - FLEXCOMM7 RX enable
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM7_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM7_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM7_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM7_TX_MASK (0x8000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM7_TX_SHIFT (15U)
/*! FLEXCOMM7_TX - FLEXCOMM7 TX enable
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM7_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM7_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM7_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH0_FLEXCOMM8_RX_DMA_MASK (0x10000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH0_FLEXCOMM8_RX_DMA_SHIFT (16U)
/*! DMIC0_CH0_FLEXCOMM8_RX_DMA - DMIC0 channel 0 / FLEXCOMM8_RX_DMA enable
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH0_FLEXCOMM8_RX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH0_FLEXCOMM8_RX_DMA_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH0_FLEXCOMM8_RX_DMA_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH1_FLEXCOMM8_TX_DMA_MASK (0x20000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH1_FLEXCOMM8_TX_DMA_SHIFT (17U)
/*! DMIC0_CH1_FLEXCOMM8_TX_DMA - DMIC0 channel 1 / FLEXCOMM8 TX DMA enable
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH1_FLEXCOMM8_TX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH1_FLEXCOMM8_TX_DMA_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH1_FLEXCOMM8_TX_DMA_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH2_FLEXCOMM9_RX_DMA_MASK (0x40000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH2_FLEXCOMM9_RX_DMA_SHIFT (18U)
/*! DMIC0_CH2_FLEXCOMM9_RX_DMA - DMIC0 channel 2 / FLEXCOMM9 RX DMA enable
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH2_FLEXCOMM9_RX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH2_FLEXCOMM9_RX_DMA_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH2_FLEXCOMM9_RX_DMA_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH3_FLEXCOMM9_TX_DMA_MASK (0x80000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH3_FLEXCOMM9_TX_DMA_SHIFT (19U)
/*! DMIC0_CH3_FLEXCOMM9_TX_DMA - DMIC0 channel 3 / FLEXCOMM9 TX DMA enable
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH3_FLEXCOMM9_TX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH3_FLEXCOMM9_TX_DMA_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH3_FLEXCOMM9_TX_DMA_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH4_FLEXCOMM10_RX_DMA_MASK (0x100000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH4_FLEXCOMM10_RX_DMA_SHIFT (20U)
/*! DMIC0_CH4_FLEXCOMM10_RX_DMA - DMIC0 channel 4 / FLEXCOMM10 RX DMA enable
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH4_FLEXCOMM10_RX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH4_FLEXCOMM10_RX_DMA_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH4_FLEXCOMM10_RX_DMA_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH5_FLEXCOMM10_TX_DMA_MASK (0x200000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH5_FLEXCOMM10_TX_DMA_SHIFT (21U)
/*! DMIC0_CH5_FLEXCOMM10_TX_DMA - DMIC0 channel 5 / FLEXCOMM10 TX DMA enable
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH5_FLEXCOMM10_TX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH5_FLEXCOMM10_TX_DMA_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH5_FLEXCOMM10_TX_DMA_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH6_FLEXCOMM13_RX_DMA_MASK (0x400000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH6_FLEXCOMM13_RX_DMA_SHIFT (22U)
/*! DMIC0_CH6_FLEXCOMM13_RX_DMA - DMIC0 channel 6 / FLEXCOMM13 RX DMA enable
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH6_FLEXCOMM13_RX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH6_FLEXCOMM13_RX_DMA_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH6_FLEXCOMM13_RX_DMA_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH7_FLEXCOMM13_TX_DMA_MASK (0x800000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH7_FLEXCOMM13_TX_DMA_SHIFT (23U)
/*! DMIC0_CH7_FLEXCOMM13_TX_DMA - DMIC0 channel 7 / FLEXCOMM13 TX DMA enable
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH7_FLEXCOMM13_TX_DMA(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH7_FLEXCOMM13_TX_DMA_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0_CH7_FLEXCOMM13_TX_DMA_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_I3C0_RX_MASK (0x1000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_I3C0_RX_SHIFT (24U)
/*! I3C0_RX - I3C RX enable clear
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_I3C0_RX(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_I3C0_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_I3C0_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_I3C0_TX_MASK (0x2000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_I3C0_TX_SHIFT (25U)
/*! I3C0_TX - I3C TX enable clear
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_I3C0_TX(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_I3C0_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_I3C0_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM14_RX_MASK (0x4000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM14_RX_SHIFT (26U)
/*! FLEXCOMM14_RX - FLEXCOMM14 RX enable clear
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM14_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM14_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM14_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM14_TX_MASK (0x8000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM14_TX_SHIFT (27U)
/*! FLEXCOMM14_TX - FLEXCOMM14 TX enable clear
 *  0b0..No effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM14_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM14_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM14_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM16_RX_MASK (0x10000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM16_RX_SHIFT (28U)
/*! FLEXCOMM16_RX - FLEXCOMM16 RX enable
 *  0b0..No effect
 *  0b1..Clears the ENA0 bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM16_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM16_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM16_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM16_TX_MASK (0x20000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM16_TX_SHIFT (29U)
/*! FLEXCOMM16_TX - FLEXCOMM16 TX enable
 *  0b0..No effect
 *  0b1..Clears the ENA0 bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM16_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM16_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM16_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_I3C1_RX_MASK (0x40000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_I3C1_RX_SHIFT (30U)
/*! I3C1_RX - I3C1_RX enable
 *  0b0..No effect
 *  0b1..Clears the ENA0 bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_I3C1_RX(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_I3C1_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_I3C1_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_I3C1_TX_MASK (0x80000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_I3C1_TX_SHIFT (31U)
/*! I3C1_TX - I3C1_TX enable
 *  0b0..No effect
 *  0b1..Clears the ENA0 bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_I3C1_TX(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_I3C1_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_I3C1_TX_MASK)
/*! @} */

/*! @name DMAC1_REQ_ENA1_CLR - DMAC1 request enable 1 clear */
/*! @{ */

#define INPUTMUX_DMAC1_REQ_ENA1_CLR_FLEXCOMM11_RX_MASK (0x1U)
#define INPUTMUX_DMAC1_REQ_ENA1_CLR_FLEXCOMM11_RX_SHIFT (0U)
/*! FLEXCOMM11_RX - FLEXCOMM11_RX
 *  0b0..No effect
 *  0b1..Clears the ENA1 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA1_CLR_FLEXCOMM11_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA1_CLR_FLEXCOMM11_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA1_CLR_FLEXCOMM11_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA1_CLR_FLEXCOMM11_TX_MASK (0x2U)
#define INPUTMUX_DMAC1_REQ_ENA1_CLR_FLEXCOMM11_TX_SHIFT (1U)
/*! FLEXCOMM11_TX - FLEXCOMM11_TX
 *  0b0..No effect
 *  0b1..Clears the ENA1 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA1_CLR_FLEXCOMM11_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA1_CLR_FLEXCOMM11_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA1_CLR_FLEXCOMM11_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA1_CLR_FLEXCOMM12_RX_MASK (0x4U)
#define INPUTMUX_DMAC1_REQ_ENA1_CLR_FLEXCOMM12_RX_SHIFT (2U)
/*! FLEXCOMM12_RX - FLEXCOMM12_RX
 *  0b0..No effect
 *  0b1..Clears the ENA1 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA1_CLR_FLEXCOMM12_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA1_CLR_FLEXCOMM12_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA1_CLR_FLEXCOMM12_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA1_CLR_FLEXCOMM12_TX_MASK (0x8U)
#define INPUTMUX_DMAC1_REQ_ENA1_CLR_FLEXCOMM12_TX_SHIFT (3U)
/*! FLEXCOMM12_TX - FLEXCOMM12_TX
 *  0b0..No effect
 *  0b1..Clears the ENA1 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA1_CLR_FLEXCOMM12_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA1_CLR_FLEXCOMM12_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA1_CLR_FLEXCOMM12_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA1_CLR_HASHCRYPT_IN_MASK (0x10U)
#define INPUTMUX_DMAC1_REQ_ENA1_CLR_HASHCRYPT_IN_SHIFT (4U)
/*! HASHCRYPT_IN - HASHCRYPT_IN
 *  0b0..No effect
 *  0b1..Clears the ENA1 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA1_CLR_HASHCRYPT_IN(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA1_CLR_HASHCRYPT_IN_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA1_CLR_HASHCRYPT_IN_MASK)
/*! @} */

/*! @name DMAC0_ITRIG_ENA0 - DMAC0 Input Trigger Enable 0 */
/*! @{ */

#define INPUTMUX_DMAC0_ITRIG_ENA0_GPIO_INT0_MASK (0x1U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_GPIO_INT0_SHIFT (0U)
/*! GPIO_INT0 - GPIO_INT0
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_GPIO_INT0(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_GPIO_INT0_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_GPIO_INT0_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_GPIO_INT1_MASK (0x2U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_GPIO_INT1_SHIFT (1U)
/*! GPIO_INT1 - GPIO_INT1
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_GPIO_INT1(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_GPIO_INT1_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_GPIO_INT1_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_GPIO_INT2_MASK (0x4U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_GPIO_INT2_SHIFT (2U)
/*! GPIO_INT2 - GPIO_INT2
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_GPIO_INT2(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_GPIO_INT2_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_GPIO_INT2_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_GPIO_INT3_MASK (0x8U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_GPIO_INT3_SHIFT (3U)
/*! GPIO_INT3 - GPIO_INT3
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_GPIO_INT3(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_GPIO_INT3_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_GPIO_INT3_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_T0_DMAREQ_M0_MASK (0x10U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_T0_DMAREQ_M0_SHIFT (4U)
/*! T0_DMAREQ_M0 - T0_DMAREQ_M0
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_T0_DMAREQ_M0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_T0_DMAREQ_M0_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_T0_DMAREQ_M0_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_T0_DMAREQ_M1_MASK (0x20U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_T0_DMAREQ_M1_SHIFT (5U)
/*! T0_DMAREQ_M1 - T0_DMAREQ_M1
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_T0_DMAREQ_M1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_T0_DMAREQ_M1_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_T0_DMAREQ_M1_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_T1_DMAREQ_M0_MASK (0x40U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_T1_DMAREQ_M0_SHIFT (6U)
/*! T1_DMAREQ_M0 - T1_DMAREQ_M0
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_T1_DMAREQ_M0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_T1_DMAREQ_M0_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_T1_DMAREQ_M0_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_T1_DMAREQ_M1_MASK (0x80U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_T1_DMAREQ_M1_SHIFT (7U)
/*! T1_DMAREQ_M1 - T1_DMAREQ_M1
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_T1_DMAREQ_M1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_T1_DMAREQ_M1_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_T1_DMAREQ_M1_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_T2_DMAREQ_M0_MASK (0x100U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_T2_DMAREQ_M0_SHIFT (8U)
/*! T2_DMAREQ_M0 - T2_DMAREQ_M0
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_T2_DMAREQ_M0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_T2_DMAREQ_M0_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_T2_DMAREQ_M0_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_T2_DMAREQ_M1_MASK (0x200U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_T2_DMAREQ_M1_SHIFT (9U)
/*! T2_DMAREQ_M1 - T2_DMAREQ_M1
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_T2_DMAREQ_M1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_T2_DMAREQ_M1_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_T2_DMAREQ_M1_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_T3_DMAREQ_M0_MASK (0x400U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_T3_DMAREQ_M0_SHIFT (10U)
/*! T3_DMAREQ_M0 - T3_DMAREQ_M0
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_T3_DMAREQ_M0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_T3_DMAREQ_M0_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_T3_DMAREQ_M0_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_T3_DMAREQ_M1_MASK (0x800U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_T3_DMAREQ_M1_SHIFT (11U)
/*! T3_DMAREQ_M1 - T3_DMAREQ_M1
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_T3_DMAREQ_M1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_T3_DMAREQ_M1_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_T3_DMAREQ_M1_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_T4_DMAREQ_M0_MASK (0x1000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_T4_DMAREQ_M0_SHIFT (12U)
/*! T4_DMAREQ_M0 - T4_DMAREQ_M0
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_T4_DMAREQ_M0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_T4_DMAREQ_M0_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_T4_DMAREQ_M0_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_T4_DMAREQ_M1_MASK (0x2000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_T4_DMAREQ_M1_SHIFT (13U)
/*! T4_DMAREQ_M1 - T4_DMAREQ_M1
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_T4_DMAREQ_M1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_T4_DMAREQ_M1_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_T4_DMAREQ_M1_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMA_TRIGOUT_A_MASK (0x4000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMA_TRIGOUT_A_SHIFT (14U)
/*! DMA_TRIGOUT_A - DMA_TRIGOUT_A
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMA_TRIGOUT_A(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMA_TRIGOUT_A_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMA_TRIGOUT_A_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMA_TRIGOUT_B_MASK (0x8000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMA_TRIGOUT_B_SHIFT (15U)
/*! DMA_TRIGOUT_B - DMA_TRIGOUT_B
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMA_TRIGOUT_B(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMA_TRIGOUT_B_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMA_TRIGOUT_B_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMA_TRIGOUT_C_MASK (0x10000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMA_TRIGOUT_C_SHIFT (16U)
/*! DMA_TRIGOUT_C - DMA_TRIGOUT_C
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMA_TRIGOUT_C(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMA_TRIGOUT_C_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMA_TRIGOUT_C_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMA_TRIGOUT_D_MASK (0x20000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMA_TRIGOUT_D_SHIFT (17U)
/*! DMA_TRIGOUT_D - DMA_TRIGOUT_D
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMA_TRIGOUT_D(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMA_TRIGOUT_D_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMA_TRIGOUT_D_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SCT_DMA_REQ0_MASK (0x40000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SCT_DMA_REQ0_SHIFT (18U)
/*! SCT_DMA_REQ0 - SCT_DMA_REQ0
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SCT_DMA_REQ0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SCT_DMA_REQ0_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SCT_DMA_REQ0_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SCT_DMA_REQ1_MASK (0x80000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SCT_DMA_REQ1_SHIFT (19U)
/*! SCT_DMA_REQ1 - SCT_DMA_REQ1
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SCT_DMA_REQ1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SCT_DMA_REQ1_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SCT_DMA_REQ1_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_HASHCRYPT_OUT_MASK (0x100000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_HASHCRYPT_OUT_SHIFT (20U)
/*! HASHCRYPT_OUT - HASHCRYPT_OUT
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_HASHCRYPT_OUT(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_HASHCRYPT_OUT_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_HASHCRYPT_OUT_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_ACMP_MASK      (0x200000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_ACMP_SHIFT     (21U)
/*! ACMP - ACMP
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_ACMP(x)        (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_ACMP_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_ACMP_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_FLEXSPI0_RX_MASK (0x400000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_FLEXSPI0_RX_SHIFT (22U)
/*! FLEXSPI0_RX - FlexSPI0_RX
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_FLEXSPI0_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_FLEXSPI0_RX_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_FLEXSPI0_RX_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_FLEXSPI0_TX_MASK (0x800000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_FLEXSPI0_TX_SHIFT (23U)
/*! FLEXSPI0_TX - FlexSPI0_TX
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_FLEXSPI0_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_FLEXSPI0_TX_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_FLEXSPI0_TX_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_ADC_MASK       (0x1000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_ADC_SHIFT      (24U)
/*! ADC - ADC
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_ADC(x)         (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_ADC_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_ADC_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_FLEXSPI1_RX_MASK (0x2000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_FLEXSPI1_RX_SHIFT (25U)
/*! FLEXSPI1_RX - FlexSPI1_RX
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_FLEXSPI1_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_FLEXSPI1_RX_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_FLEXSPI1_RX_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_FLEXSPI1_TX_MASK (0x4000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_FLEXSPI1_TX_SHIFT (26U)
/*! FLEXSPI1_TX - FlexSPI1_TX
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_FLEXSPI1_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_FLEXSPI1_TX_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_FLEXSPI1_TX_MASK)
/*! @} */

/*! @name DMAC0_ITRIG_ENA0_SET - DMAC0 Input Trigger Enable 0 Set */
/*! @{ */

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_GPIO_INT0_MASK (0x1U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_GPIO_INT0_SHIFT (0U)
/*! GPIO_INT0 - GPIO_INT0 set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_GPIO_INT0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_GPIO_INT0_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_GPIO_INT0_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_GPIO_INT1_MASK (0x2U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_GPIO_INT1_SHIFT (1U)
/*! GPIO_INT1 - GPIO_INT1 set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_GPIO_INT1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_GPIO_INT1_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_GPIO_INT1_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_GPIO_INT2_MASK (0x4U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_GPIO_INT2_SHIFT (2U)
/*! GPIO_INT2 - GPIO_INT2 set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_GPIO_INT2(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_GPIO_INT2_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_GPIO_INT2_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_GPIO_INT3_MASK (0x8U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_GPIO_INT3_SHIFT (3U)
/*! GPIO_INT3 - GPIO_INT3 set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_GPIO_INT3(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_GPIO_INT3_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_GPIO_INT3_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_T0_DMAREQ_M0_MASK (0x10U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_T0_DMAREQ_M0_SHIFT (4U)
/*! T0_DMAREQ_M0 - T0_DMAREQ_M0 set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_T0_DMAREQ_M0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_T0_DMAREQ_M0_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_T0_DMAREQ_M0_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_T0_DMAREQ_M1_MASK (0x20U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_T0_DMAREQ_M1_SHIFT (5U)
/*! T0_DMAREQ_M1 - T0_DMAREQ_M1 set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_T0_DMAREQ_M1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_T0_DMAREQ_M1_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_T0_DMAREQ_M1_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_T1_DMAREQ_M0_MASK (0x40U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_T1_DMAREQ_M0_SHIFT (6U)
/*! T1_DMAREQ_M0 - T1_DMAREQ_M0 set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_T1_DMAREQ_M0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_T1_DMAREQ_M0_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_T1_DMAREQ_M0_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_T1_DMAREQ_M1_MASK (0x80U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_T1_DMAREQ_M1_SHIFT (7U)
/*! T1_DMAREQ_M1 - T1_DMAREQ_M1 set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_T1_DMAREQ_M1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_T1_DMAREQ_M1_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_T1_DMAREQ_M1_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_T2_DMAREQ_M0_MASK (0x100U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_T2_DMAREQ_M0_SHIFT (8U)
/*! T2_DMAREQ_M0 - T2_DMAREQ_M0 set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_T2_DMAREQ_M0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_T2_DMAREQ_M0_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_T2_DMAREQ_M0_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_T2_DMAREQ_M1_MASK (0x200U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_T2_DMAREQ_M1_SHIFT (9U)
/*! T2_DMAREQ_M1 - T2_DMAREQ_M1 set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_T2_DMAREQ_M1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_T2_DMAREQ_M1_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_T2_DMAREQ_M1_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_T3_DMAREQ_M0_MASK (0x400U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_T3_DMAREQ_M0_SHIFT (10U)
/*! T3_DMAREQ_M0 - T3_DMAREQ_M0 set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_T3_DMAREQ_M0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_T3_DMAREQ_M0_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_T3_DMAREQ_M0_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_T3_DMAREQ_M1_MASK (0x800U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_T3_DMAREQ_M1_SHIFT (11U)
/*! T3_DMAREQ_M1 - T3_DMAREQ_M1 set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_T3_DMAREQ_M1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_T3_DMAREQ_M1_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_T3_DMAREQ_M1_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_T4_DMAREQ_M0_MASK (0x1000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_T4_DMAREQ_M0_SHIFT (12U)
/*! T4_DMAREQ_M0 - T4_DMAREQ_M0 set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_T4_DMAREQ_M0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_T4_DMAREQ_M0_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_T4_DMAREQ_M0_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_T4_DMAREQ_M1_MASK (0x2000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_T4_DMAREQ_M1_SHIFT (13U)
/*! T4_DMAREQ_M1 - T4_DMAREQ_M1 set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_T4_DMAREQ_M1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_T4_DMAREQ_M1_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_T4_DMAREQ_M1_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_SDMA0_TRIGOUT_A_MASK (0x4000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_SDMA0_TRIGOUT_A_SHIFT (14U)
/*! SDMA0_TRIGOUT_A - SDMA0_TRIGOUT_Aset
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_SDMA0_TRIGOUT_A(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_SDMA0_TRIGOUT_A_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_SDMA0_TRIGOUT_A_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_SDMA0_TRIGOUT_B_MASK (0x8000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_SDMA0_TRIGOUT_B_SHIFT (15U)
/*! SDMA0_TRIGOUT_B - SDMA0_TRIGOUT_B set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_SDMA0_TRIGOUT_B(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_SDMA0_TRIGOUT_B_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_SDMA0_TRIGOUT_B_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_SDMA0_TRIGOUT_C_MASK (0x10000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_SDMA0_TRIGOUT_C_SHIFT (16U)
/*! SDMA0_TRIGOUT_C - SDMA0_TRIGOUT_C set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_SDMA0_TRIGOUT_C(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_SDMA0_TRIGOUT_C_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_SDMA0_TRIGOUT_C_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_SDMA0_TRIGOUT_D_MASK (0x20000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_SDMA0_TRIGOUT_D_SHIFT (17U)
/*! SDMA0_TRIGOUT_D - SDMA0_TRIGOUT_D set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_SDMA0_TRIGOUT_D(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_SDMA0_TRIGOUT_D_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_SDMA0_TRIGOUT_D_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_SCT_DMA_REQ0_MASK (0x40000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_SCT_DMA_REQ0_SHIFT (18U)
/*! SCT_DMA_REQ0 - SCT_DMA_REQ0 set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_SCT_DMA_REQ0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_SCT_DMA_REQ0_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_SCT_DMA_REQ0_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_SCT_DMA_REQ1_MASK (0x80000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_SCT_DMA_REQ1_SHIFT (19U)
/*! SCT_DMA_REQ1 - SCT_DMA_REQ1 set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_SCT_DMA_REQ1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_SCT_DMA_REQ1_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_SCT_DMA_REQ1_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_HASHCRYPT_OUT_MASK (0x100000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_HASHCRYPT_OUT_SHIFT (20U)
/*! HASHCRYPT_OUT - HASHCRYPT_OUT set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_HASHCRYPT_OUT(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_HASHCRYPT_OUT_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_HASHCRYPT_OUT_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_ACMP_MASK  (0x200000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_ACMP_SHIFT (21U)
/*! ACMP - ACMP set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_ACMP(x)    (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_ACMP_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_ACMP_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_FLEXSPI0_RX_MASK (0x400000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_FLEXSPI0_RX_SHIFT (22U)
/*! FLEXSPI0_RX - FlexSPI0_RX set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_FLEXSPI0_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_FLEXSPI0_RX_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_FLEXSPI0_RX_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_FLEXSPI0_TX_MASK (0x800000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_FLEXSPI0_TX_SHIFT (23U)
/*! FLEXSPI0_TX - FlexSPI0_TX set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_FLEXSPI0_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_FLEXSPI0_TX_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_FLEXSPI0_TX_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_ADC_MASK   (0x1000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_ADC_SHIFT  (24U)
/*! ADC - ADC set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_ADC(x)     (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_ADC_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_ADC_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_FLEXSPI1_RX_MASK (0x2000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_FLEXSPI1_RX_SHIFT (25U)
/*! FLEXSPI1_RX - FlexSPI1_RX set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_FLEXSPI1_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_FLEXSPI1_RX_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_FLEXSPI1_RX_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_FLEXSPI1_TX_MASK (0x4000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_FLEXSPI1_TX_SHIFT (26U)
/*! FLEXSPI1_TX - FlexSPI1_TX set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_FLEXSPI1_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_FLEXSPI1_TX_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_FLEXSPI1_TX_MASK)
/*! @} */

/*! @name DMAC0_ITRIG_ENA0_CLR - DMAC0 Input Trigger Enable 0 Clear */
/*! @{ */

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_GPIO_INT0_MASK (0x1U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_GPIO_INT0_SHIFT (0U)
/*! GPIO_INT0 - GPIO_INT0 clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_GPIO_INT0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_GPIO_INT0_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_GPIO_INT0_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_GPIO_INT1_MASK (0x2U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_GPIO_INT1_SHIFT (1U)
/*! GPIO_INT1 - GPIO_INT1 clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_GPIO_INT1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_GPIO_INT1_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_GPIO_INT1_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_GPIO_INT2_MASK (0x4U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_GPIO_INT2_SHIFT (2U)
/*! GPIO_INT2 - GPIO_INT2 clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_GPIO_INT2(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_GPIO_INT2_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_GPIO_INT2_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_GPIO_INT3_MASK (0x8U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_GPIO_INT3_SHIFT (3U)
/*! GPIO_INT3 - GPIO_INT3 clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_GPIO_INT3(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_GPIO_INT3_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_GPIO_INT3_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T0_DMAREQ_M0_MASK (0x10U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T0_DMAREQ_M0_SHIFT (4U)
/*! T0_DMAREQ_M0 - T0_DMAREQ_M0 clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T0_DMAREQ_M0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T0_DMAREQ_M0_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T0_DMAREQ_M0_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T0_DMAREQ_M1_MASK (0x20U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T0_DMAREQ_M1_SHIFT (5U)
/*! T0_DMAREQ_M1 - T0_DMAREQ_M1 clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T0_DMAREQ_M1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T0_DMAREQ_M1_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T0_DMAREQ_M1_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T1_DMAREQ_M0_MASK (0x40U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T1_DMAREQ_M0_SHIFT (6U)
/*! T1_DMAREQ_M0 - T1_DMAREQ_M0 clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T1_DMAREQ_M0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T1_DMAREQ_M0_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T1_DMAREQ_M0_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T1_DMAREQ_M1_MASK (0x80U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T1_DMAREQ_M1_SHIFT (7U)
/*! T1_DMAREQ_M1 - T1_DMAREQ_M1 clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T1_DMAREQ_M1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T1_DMAREQ_M1_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T1_DMAREQ_M1_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T2_DMAREQ_M0_MASK (0x100U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T2_DMAREQ_M0_SHIFT (8U)
/*! T2_DMAREQ_M0 - T2_DMAREQ_M0 clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T2_DMAREQ_M0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T2_DMAREQ_M0_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T2_DMAREQ_M0_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T2_DMAREQ_M1_MASK (0x200U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T2_DMAREQ_M1_SHIFT (9U)
/*! T2_DMAREQ_M1 - T2_DMAREQ_M1 clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T2_DMAREQ_M1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T2_DMAREQ_M1_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T2_DMAREQ_M1_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T3_DMAREQ_M0_MASK (0x400U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T3_DMAREQ_M0_SHIFT (10U)
/*! T3_DMAREQ_M0 - T3_DMAREQ_M0 clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T3_DMAREQ_M0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T3_DMAREQ_M0_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T3_DMAREQ_M0_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T3_DMAREQ_M1_MASK (0x800U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T3_DMAREQ_M1_SHIFT (11U)
/*! T3_DMAREQ_M1 - T3_DMAREQ_M1 clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T3_DMAREQ_M1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T3_DMAREQ_M1_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T3_DMAREQ_M1_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T4_DMAREQ_M0_MASK (0x1000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T4_DMAREQ_M0_SHIFT (12U)
/*! T4_DMAREQ_M0 - T4_DMAREQ_M0 clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T4_DMAREQ_M0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T4_DMAREQ_M0_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T4_DMAREQ_M0_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T4_DMAREQ_M1_MASK (0x2000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T4_DMAREQ_M1_SHIFT (13U)
/*! T4_DMAREQ_M1 - T4_DMAREQ_M1 clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T4_DMAREQ_M1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T4_DMAREQ_M1_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_T4_DMAREQ_M1_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_A_MASK (0x4000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_A_SHIFT (14U)
/*! SDMA0_TRIGOUT_A - SDMA0_TRIGOUT_A clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_A(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_A_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_A_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_B_MASK (0x8000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_B_SHIFT (15U)
/*! SDMA0_TRIGOUT_B - SDMA0_TRIGOUT_B clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_B(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_B_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_B_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_C_MASK (0x10000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_C_SHIFT (16U)
/*! SDMA0_TRIGOUT_C - SDMA0_TRIGOUT_C clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_C(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_C_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_C_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_D_MASK (0x20000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_D_SHIFT (17U)
/*! SDMA0_TRIGOUT_D - SDMA0_TRIGOUT_D clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_D(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_D_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_D_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_SCT_DMA_REQ0_MASK (0x40000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_SCT_DMA_REQ0_SHIFT (18U)
/*! SCT_DMA_REQ0 - SCT_DMA_REQ0 clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_SCT_DMA_REQ0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_SCT_DMA_REQ0_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_SCT_DMA_REQ0_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_SCT_DMA_REQ1_MASK (0x80000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_SCT_DMA_REQ1_SHIFT (19U)
/*! SCT_DMA_REQ1 - SCT_DMA_REQ1 clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_SCT_DMA_REQ1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_SCT_DMA_REQ1_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_SCT_DMA_REQ1_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_HASHCRYPT_OUT_MASK (0x100000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_HASHCRYPT_OUT_SHIFT (20U)
/*! HASHCRYPT_OUT - HASHCRYPT_OUT clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_HASHCRYPT_OUT(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_HASHCRYPT_OUT_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_HASHCRYPT_OUT_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_ACMP_MASK  (0x200000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_ACMP_SHIFT (21U)
/*! ACMP - ACMP clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_ACMP(x)    (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_ACMP_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_ACMP_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_FLEXSPI0_RX_MASK (0x400000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_FLEXSPI0_RX_SHIFT (22U)
/*! FLEXSPI0_RX - FlexSPI0_RX clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_FLEXSPI0_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_FLEXSPI0_RX_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_FLEXSPI0_RX_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_FLEXSPI0_TX_MASK (0x800000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_FLEXSPI0_TX_SHIFT (23U)
/*! FLEXSPI0_TX - FlexSPI0_TX clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_FLEXSPI0_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_FLEXSPI0_TX_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_FLEXSPI0_TX_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_ADC_MASK   (0x1000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_ADC_SHIFT  (24U)
/*! ADC - ADC clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_ADC(x)     (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_ADC_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_ADC_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_FLEXSPI1_RX_MASK (0x2000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_FLEXSPI1_RX_SHIFT (25U)
/*! FLEXSPI1_RX - FlexSPI1_RX clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_FLEXSPI1_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_FLEXSPI1_RX_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_FLEXSPI1_RX_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_FLEXSPI1_TX_MASK (0x4000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_FLEXSPI1_TX_SHIFT (26U)
/*! FLEXSPI1_TX - FlexSPI1_TX clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_FLEXSPI1_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_FLEXSPI1_TX_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_FLEXSPI1_TX_MASK)
/*! @} */

/*! @name DMAC1_ITRIG_ENA0 - DMAC1 Input Trigger Enable 0 */
/*! @{ */

#define INPUTMUX_DMAC1_ITRIG_ENA0_GPIO_INT0_MASK (0x1U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_GPIO_INT0_SHIFT (0U)
/*! GPIO_INT0 - GPIO_INT0
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_GPIO_INT0(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_GPIO_INT0_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_GPIO_INT0_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_GPIO_INT1_MASK (0x2U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_GPIO_INT1_SHIFT (1U)
/*! GPIO_INT1 - GPIO_INT1
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_GPIO_INT1(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_GPIO_INT1_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_GPIO_INT1_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_GPIO_INT2_MASK (0x4U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_GPIO_INT2_SHIFT (2U)
/*! GPIO_INT2 - GPIO_INT2
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_GPIO_INT2(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_GPIO_INT2_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_GPIO_INT2_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_GPIO_INT3_MASK (0x8U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_GPIO_INT3_SHIFT (3U)
/*! GPIO_INT3 - GPIO_INT3
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_GPIO_INT3(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_GPIO_INT3_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_GPIO_INT3_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_T0_DMAREQ_M0_MASK (0x10U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_T0_DMAREQ_M0_SHIFT (4U)
/*! T0_DMAREQ_M0 - T0_DMAREQ_M0
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_T0_DMAREQ_M0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_T0_DMAREQ_M0_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_T0_DMAREQ_M0_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_T0_DMAREQ_M1_MASK (0x20U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_T0_DMAREQ_M1_SHIFT (5U)
/*! T0_DMAREQ_M1 - T0_DMAREQ_M1
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_T0_DMAREQ_M1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_T0_DMAREQ_M1_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_T0_DMAREQ_M1_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_T1_DMAREQ_M0_MASK (0x40U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_T1_DMAREQ_M0_SHIFT (6U)
/*! T1_DMAREQ_M0 - T1_DMAREQ_M0
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_T1_DMAREQ_M0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_T1_DMAREQ_M0_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_T1_DMAREQ_M0_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_T1_DMAREQ_M1_MASK (0x80U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_T1_DMAREQ_M1_SHIFT (7U)
/*! T1_DMAREQ_M1 - T1_DMAREQ_M1
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_T1_DMAREQ_M1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_T1_DMAREQ_M1_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_T1_DMAREQ_M1_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_T2_DMAREQ_M0_MASK (0x100U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_T2_DMAREQ_M0_SHIFT (8U)
/*! T2_DMAREQ_M0 - T2_DMAREQ_M0
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_T2_DMAREQ_M0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_T2_DMAREQ_M0_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_T2_DMAREQ_M0_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_T2_DMAREQ_M1_MASK (0x200U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_T2_DMAREQ_M1_SHIFT (9U)
/*! T2_DMAREQ_M1 - T2_DMAREQ_M1
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_T2_DMAREQ_M1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_T2_DMAREQ_M1_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_T2_DMAREQ_M1_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_T3_DMAREQ_M0_MASK (0x400U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_T3_DMAREQ_M0_SHIFT (10U)
/*! T3_DMAREQ_M0 - T3_DMAREQ_M0
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_T3_DMAREQ_M0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_T3_DMAREQ_M0_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_T3_DMAREQ_M0_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_T3_DMAREQ_M1_MASK (0x800U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_T3_DMAREQ_M1_SHIFT (11U)
/*! T3_DMAREQ_M1 - T3_DMAREQ_M1
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_T3_DMAREQ_M1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_T3_DMAREQ_M1_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_T3_DMAREQ_M1_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_T4_DMAREQ_M0_MASK (0x1000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_T4_DMAREQ_M0_SHIFT (12U)
/*! T4_DMAREQ_M0 - T4_DMAREQ_M0
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_T4_DMAREQ_M0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_T4_DMAREQ_M0_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_T4_DMAREQ_M0_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_T4_DMAREQ_M1_MASK (0x2000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_T4_DMAREQ_M1_SHIFT (13U)
/*! T4_DMAREQ_M1 - T4_DMAREQ_M1
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_T4_DMAREQ_M1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_T4_DMAREQ_M1_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_T4_DMAREQ_M1_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMA_TRIGOUT_A_MASK (0x4000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMA_TRIGOUT_A_SHIFT (14U)
/*! DMA_TRIGOUT_A - DMA_TRIGOUT_A
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMA_TRIGOUT_A(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMA_TRIGOUT_A_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMA_TRIGOUT_A_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMA_TRIGOUT_B_MASK (0x8000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMA_TRIGOUT_B_SHIFT (15U)
/*! DMA_TRIGOUT_B - DMA_TRIGOUT_B
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMA_TRIGOUT_B(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMA_TRIGOUT_B_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMA_TRIGOUT_B_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMA_TRIGOUT_C_MASK (0x10000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMA_TRIGOUT_C_SHIFT (16U)
/*! DMA_TRIGOUT_C - DMA_TRIGOUT_C
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMA_TRIGOUT_C(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMA_TRIGOUT_C_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMA_TRIGOUT_C_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMA_TRIGOUT_D_MASK (0x20000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMA_TRIGOUT_D_SHIFT (17U)
/*! DMA_TRIGOUT_D - DMA_TRIGOUT_D
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMA_TRIGOUT_D(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMA_TRIGOUT_D_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMA_TRIGOUT_D_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SCT_DMA_REQ0_MASK (0x40000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SCT_DMA_REQ0_SHIFT (18U)
/*! SCT_DMA_REQ0 - SCT_DMA_REQ0
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SCT_DMA_REQ0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SCT_DMA_REQ0_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SCT_DMA_REQ0_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SCT_DMA_REQ1_MASK (0x80000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SCT_DMA_REQ1_SHIFT (19U)
/*! SCT_DMA_REQ1 - SCT_DMA_REQ1
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SCT_DMA_REQ1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SCT_DMA_REQ1_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SCT_DMA_REQ1_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_HASHCRYPT_OUT_MASK (0x100000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_HASHCRYPT_OUT_SHIFT (20U)
/*! HASHCRYPT_OUT - HASHCRYPT_OUT
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_HASHCRYPT_OUT(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_HASHCRYPT_OUT_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_HASHCRYPT_OUT_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_ACMP_MASK      (0x200000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_ACMP_SHIFT     (21U)
/*! ACMP - ACMP
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_ACMP(x)        (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_ACMP_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_ACMP_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_FLEXSPI0_RX_MASK (0x400000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_FLEXSPI0_RX_SHIFT (22U)
/*! FLEXSPI0_RX - FlexSPI0_RX
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_FLEXSPI0_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_FLEXSPI0_RX_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_FLEXSPI0_RX_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_FLEXSPI0_TX_MASK (0x800000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_FLEXSPI0_TX_SHIFT (23U)
/*! FLEXSPI0_TX - FlexSPI0_TX
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_FLEXSPI0_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_FLEXSPI0_TX_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_FLEXSPI0_TX_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_ADC_MASK       (0x1000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_ADC_SHIFT      (24U)
/*! ADC - ADC
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_ADC(x)         (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_ADC_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_ADC_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_FLEXSPI1_RX_MASK (0x2000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_FLEXSPI1_RX_SHIFT (25U)
/*! FLEXSPI1_RX - FlexSPI1_RX
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_FLEXSPI1_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_FLEXSPI1_RX_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_FLEXSPI1_RX_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_FLEXSPI1_TX_MASK (0x4000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_FLEXSPI1_TX_SHIFT (26U)
/*! FLEXSPI1_TX - FlexSPI1_TX
 *  0b0..Disable
 *  0b1..Enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_FLEXSPI1_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_FLEXSPI1_TX_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_FLEXSPI1_TX_MASK)
/*! @} */

/*! @name DMAC1_ITRIG_ENA0_SET - DMAC1 Input Trigger Enable 0 set */
/*! @{ */

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_GPIO_INT0_MASK (0x1U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_GPIO_INT0_SHIFT (0U)
/*! GPIO_INT0 - GPIO_INT0 set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_GPIO_INT0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_GPIO_INT0_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_GPIO_INT0_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_GPIO_INT1_MASK (0x2U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_GPIO_INT1_SHIFT (1U)
/*! GPIO_INT1 - GPIO_INT1 set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_GPIO_INT1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_GPIO_INT1_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_GPIO_INT1_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_GPIO_INT2_MASK (0x4U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_GPIO_INT2_SHIFT (2U)
/*! GPIO_INT2 - GPIO_INT2 set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_GPIO_INT2(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_GPIO_INT2_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_GPIO_INT2_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_GPIO_INT3_MASK (0x8U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_GPIO_INT3_SHIFT (3U)
/*! GPIO_INT3 - GPIO_INT3 set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_GPIO_INT3(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_GPIO_INT3_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_GPIO_INT3_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_T0_DMAREQ_M0_MASK (0x10U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_T0_DMAREQ_M0_SHIFT (4U)
/*! T0_DMAREQ_M0 - T0_DMAREQ_M0 set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_T0_DMAREQ_M0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_T0_DMAREQ_M0_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_T0_DMAREQ_M0_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_T0_DMAREQ_M1_MASK (0x20U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_T0_DMAREQ_M1_SHIFT (5U)
/*! T0_DMAREQ_M1 - T0_DMAREQ_M1 set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_T0_DMAREQ_M1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_T0_DMAREQ_M1_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_T0_DMAREQ_M1_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_T1_DMAREQ_M0_MASK (0x40U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_T1_DMAREQ_M0_SHIFT (6U)
/*! T1_DMAREQ_M0 - T1_DMAREQ_M0 set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_T1_DMAREQ_M0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_T1_DMAREQ_M0_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_T1_DMAREQ_M0_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_T1_DMAREQ_M1_MASK (0x80U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_T1_DMAREQ_M1_SHIFT (7U)
/*! T1_DMAREQ_M1 - T1_DMAREQ_M1 set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_T1_DMAREQ_M1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_T1_DMAREQ_M1_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_T1_DMAREQ_M1_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_T2_DMAREQ_M0_MASK (0x100U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_T2_DMAREQ_M0_SHIFT (8U)
/*! T2_DMAREQ_M0 - T2_DMAREQ_M0 set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_T2_DMAREQ_M0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_T2_DMAREQ_M0_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_T2_DMAREQ_M0_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_T2_DMAREQ_M1_MASK (0x200U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_T2_DMAREQ_M1_SHIFT (9U)
/*! T2_DMAREQ_M1 - T2_DMAREQ_M1 set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_T2_DMAREQ_M1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_T2_DMAREQ_M1_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_T2_DMAREQ_M1_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_T3_DMAREQ_M0_MASK (0x400U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_T3_DMAREQ_M0_SHIFT (10U)
/*! T3_DMAREQ_M0 - T3_DMAREQ_M0 set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_T3_DMAREQ_M0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_T3_DMAREQ_M0_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_T3_DMAREQ_M0_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_T3_DMAREQ_M1_MASK (0x800U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_T3_DMAREQ_M1_SHIFT (11U)
/*! T3_DMAREQ_M1 - T3_DMAREQ_M1 set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_T3_DMAREQ_M1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_T3_DMAREQ_M1_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_T3_DMAREQ_M1_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_T4_DMAREQ_M0_MASK (0x1000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_T4_DMAREQ_M0_SHIFT (12U)
/*! T4_DMAREQ_M0 - T4_DMAREQ_M0 set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_T4_DMAREQ_M0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_T4_DMAREQ_M0_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_T4_DMAREQ_M0_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_T4_DMAREQ_M1_MASK (0x2000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_T4_DMAREQ_M1_SHIFT (13U)
/*! T4_DMAREQ_M1 - T4_DMAREQ_M1 set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_T4_DMAREQ_M1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_T4_DMAREQ_M1_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_T4_DMAREQ_M1_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_SDMA0_TRIGOUT_A_MASK (0x4000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_SDMA0_TRIGOUT_A_SHIFT (14U)
/*! SDMA0_TRIGOUT_A - SDMA0_TRIGOUT_A set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_SDMA0_TRIGOUT_A(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_SDMA0_TRIGOUT_A_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_SDMA0_TRIGOUT_A_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_SDMA0_TRIGOUT_B_MASK (0x8000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_SDMA0_TRIGOUT_B_SHIFT (15U)
/*! SDMA0_TRIGOUT_B - SDMA0_TRIGOUT_B set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_SDMA0_TRIGOUT_B(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_SDMA0_TRIGOUT_B_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_SDMA0_TRIGOUT_B_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_SDMA0_TRIGOUT_C_MASK (0x10000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_SDMA0_TRIGOUT_C_SHIFT (16U)
/*! SDMA0_TRIGOUT_C - SDMA0_TRIGOUT_C set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_SDMA0_TRIGOUT_C(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_SDMA0_TRIGOUT_C_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_SDMA0_TRIGOUT_C_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_SDMA0_TRIGOUT_D_MASK (0x20000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_SDMA0_TRIGOUT_D_SHIFT (17U)
/*! SDMA0_TRIGOUT_D - SDMA0_TRIGOUT_D set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_SDMA0_TRIGOUT_D(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_SDMA0_TRIGOUT_D_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_SDMA0_TRIGOUT_D_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_SCT_DMA_REQ0_MASK (0x40000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_SCT_DMA_REQ0_SHIFT (18U)
/*! SCT_DMA_REQ0 - SCT_DMA_REQ0 set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_SCT_DMA_REQ0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_SCT_DMA_REQ0_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_SCT_DMA_REQ0_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_SCT_DMA_REQ1_MASK (0x80000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_SCT_DMA_REQ1_SHIFT (19U)
/*! SCT_DMA_REQ1 - SCT_DMA_REQ1 set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_SCT_DMA_REQ1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_SCT_DMA_REQ1_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_SCT_DMA_REQ1_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_HASHCRYPT_OUT_MASK (0x100000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_HASHCRYPT_OUT_SHIFT (20U)
/*! HASHCRYPT_OUT - HASHCRYPT_OUT set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_HASHCRYPT_OUT(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_HASHCRYPT_OUT_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_HASHCRYPT_OUT_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_ACMP_MASK  (0x200000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_ACMP_SHIFT (21U)
/*! ACMP - ACMP set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_ACMP(x)    (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_ACMP_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_ACMP_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_FLEXSPI0_RX_MASK (0x400000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_FLEXSPI0_RX_SHIFT (22U)
/*! FLEXSPI0_RX - FlexSPI0_RX set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_FLEXSPI0_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_FLEXSPI0_RX_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_FLEXSPI0_RX_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_FLEXSPI0_TX_MASK (0x800000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_FLEXSPI0_TX_SHIFT (23U)
/*! FLEXSPI0_TX - FlexSPI0_TX set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_FLEXSPI0_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_FLEXSPI0_TX_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_FLEXSPI0_TX_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_ADC_MASK   (0x1000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_ADC_SHIFT  (24U)
/*! ADC - ADC set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_ADC(x)     (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_ADC_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_ADC_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_FLEXSPI1_RX_MASK (0x2000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_FLEXSPI1_RX_SHIFT (25U)
/*! FLEXSPI1_RX - FlexSPI1_RX set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_FLEXSPI1_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_FLEXSPI1_RX_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_FLEXSPI1_RX_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_FLEXSPI1_TX_MASK (0x4000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_FLEXSPI1_TX_SHIFT (26U)
/*! FLEXSPI1_TX - FlexSPI1_TX set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_FLEXSPI1_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_FLEXSPI1_TX_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_FLEXSPI1_TX_MASK)
/*! @} */

/*! @name DMAC1_ITRIG_ENA0_CLR - DMAC1 Input Trigger Enable 0 clear */
/*! @{ */

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_GPIO_INT0_MASK (0x1U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_GPIO_INT0_SHIFT (0U)
/*! GPIO_INT0 - GPIO_INT0 clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_GPIO_INT0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_GPIO_INT0_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_GPIO_INT0_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_GPIO_INT1_MASK (0x2U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_GPIO_INT1_SHIFT (1U)
/*! GPIO_INT1 - GPIO_INT1 clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_GPIO_INT1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_GPIO_INT1_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_GPIO_INT1_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_GPIO_INT2_MASK (0x4U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_GPIO_INT2_SHIFT (2U)
/*! GPIO_INT2 - GPIO_INT2 clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_GPIO_INT2(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_GPIO_INT2_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_GPIO_INT2_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_GPIO_INT3_MASK (0x8U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_GPIO_INT3_SHIFT (3U)
/*! GPIO_INT3 - GPIO_INT3 clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_GPIO_INT3(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_GPIO_INT3_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_GPIO_INT3_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T0_DMAREQ_M0_MASK (0x10U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T0_DMAREQ_M0_SHIFT (4U)
/*! T0_DMAREQ_M0 - T0_DMAREQ_M0 clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T0_DMAREQ_M0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T0_DMAREQ_M0_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T0_DMAREQ_M0_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T0_DMAREQ_M1_MASK (0x20U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T0_DMAREQ_M1_SHIFT (5U)
/*! T0_DMAREQ_M1 - T0_DMAREQ_M1 clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T0_DMAREQ_M1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T0_DMAREQ_M1_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T0_DMAREQ_M1_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T1_DMAREQ_M0_MASK (0x40U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T1_DMAREQ_M0_SHIFT (6U)
/*! T1_DMAREQ_M0 - T1_DMAREQ_M0 clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T1_DMAREQ_M0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T1_DMAREQ_M0_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T1_DMAREQ_M0_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T1_DMAREQ_M1_MASK (0x80U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T1_DMAREQ_M1_SHIFT (7U)
/*! T1_DMAREQ_M1 - T1_DMAREQ_M1 clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T1_DMAREQ_M1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T1_DMAREQ_M1_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T1_DMAREQ_M1_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T2_DMAREQ_M0_MASK (0x100U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T2_DMAREQ_M0_SHIFT (8U)
/*! T2_DMAREQ_M0 - T2_DMAREQ_M0 clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T2_DMAREQ_M0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T2_DMAREQ_M0_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T2_DMAREQ_M0_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T2_DMAREQ_M1_MASK (0x200U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T2_DMAREQ_M1_SHIFT (9U)
/*! T2_DMAREQ_M1 - T2_DMAREQ_M1 clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T2_DMAREQ_M1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T2_DMAREQ_M1_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T2_DMAREQ_M1_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T3_DMAREQ_M0_MASK (0x400U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T3_DMAREQ_M0_SHIFT (10U)
/*! T3_DMAREQ_M0 - T3_DMAREQ_M0 clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T3_DMAREQ_M0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T3_DMAREQ_M0_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T3_DMAREQ_M0_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T3_DMAREQ_M1_MASK (0x800U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T3_DMAREQ_M1_SHIFT (11U)
/*! T3_DMAREQ_M1 - T3_DMAREQ_M1 clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T3_DMAREQ_M1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T3_DMAREQ_M1_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T3_DMAREQ_M1_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T4_DMAREQ_M0_MASK (0x1000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T4_DMAREQ_M0_SHIFT (12U)
/*! T4_DMAREQ_M0 - T4_DMAREQ_M0 clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T4_DMAREQ_M0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T4_DMAREQ_M0_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T4_DMAREQ_M0_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T4_DMAREQ_M1_MASK (0x2000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T4_DMAREQ_M1_SHIFT (13U)
/*! T4_DMAREQ_M1 - T4_DMAREQ_M1 clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T4_DMAREQ_M1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T4_DMAREQ_M1_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_T4_DMAREQ_M1_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_A_MASK (0x4000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_A_SHIFT (14U)
/*! SDMA0_TRIGOUT_A - SDMA0_TRIGOUT_A clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_A(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_A_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_A_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_B_MASK (0x8000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_B_SHIFT (15U)
/*! SDMA0_TRIGOUT_B - SDMA0_TRIGOUT_B clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_B(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_B_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_B_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_C_MASK (0x10000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_C_SHIFT (16U)
/*! SDMA0_TRIGOUT_C - SDMA0_TRIGOUT_C clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_C(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_C_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_C_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_D_MASK (0x20000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_D_SHIFT (17U)
/*! SDMA0_TRIGOUT_D - SDMA0_TRIGOUT_D clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_D(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_D_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_SDMA0_TRIGOUT_D_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_SCT_DMA_REQ0_MASK (0x40000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_SCT_DMA_REQ0_SHIFT (18U)
/*! SCT_DMA_REQ0 - SCT_DMA_REQ0 clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_SCT_DMA_REQ0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_SCT_DMA_REQ0_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_SCT_DMA_REQ0_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_SCT_DMA_REQ1_MASK (0x80000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_SCT_DMA_REQ1_SHIFT (19U)
/*! SCT_DMA_REQ1 - SCT_DMA_REQ1 clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_SCT_DMA_REQ1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_SCT_DMA_REQ1_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_SCT_DMA_REQ1_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_HASHCRYPT_OUT_MASK (0x100000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_HASHCRYPT_OUT_SHIFT (20U)
/*! HASHCRYPT_OUT - HASHCRYPT_OUTclear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_HASHCRYPT_OUT(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_HASHCRYPT_OUT_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_HASHCRYPT_OUT_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_ACMP_MASK  (0x200000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_ACMP_SHIFT (21U)
/*! ACMP - ACMP clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_ACMP(x)    (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_ACMP_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_ACMP_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_FLEXSPI0_RX_MASK (0x400000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_FLEXSPI0_RX_SHIFT (22U)
/*! FLEXSPI0_RX - FlexSPI0_RXclear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_FLEXSPI0_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_FLEXSPI0_RX_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_FLEXSPI0_RX_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_FLEXSPI0_TX_MASK (0x800000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_FLEXSPI0_TX_SHIFT (23U)
/*! FLEXSPI0_TX - FlexSPI0_TX clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_FLEXSPI0_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_FLEXSPI0_TX_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_FLEXSPI0_TX_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_ADC_MASK   (0x1000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_ADC_SHIFT  (24U)
/*! ADC - ADC clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_ADC(x)     (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_ADC_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_ADC_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_FLEXSPI1_RX_MASK (0x2000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_FLEXSPI1_RX_SHIFT (25U)
/*! FLEXSPI1_RX - FlexSPI1_RX clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_FLEXSPI1_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_FLEXSPI1_RX_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_FLEXSPI1_RX_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_FLEXSPI1_TX_MASK (0x4000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_FLEXSPI1_TX_SHIFT (26U)
/*! FLEXSPI1_TX - FlexSPI1_TX clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_FLEXSPI1_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_FLEXSPI1_TX_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_FLEXSPI1_TX_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group INPUTMUX_Register_Masks */


/*!
 * @}
 */ /* end of group INPUTMUX_Peripheral_Access_Layer */


/*
** End of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #if (__ARMCC_VERSION >= 6010050)
    #pragma clang diagnostic pop
  #else
    #pragma pop
  #endif
#elif defined(__GNUC__)
  /* leave anonymous unions enabled */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=default
#elif defined(__XTENSA__)
  /* leave anonymous unions enabled */
#else
  #error Not supported compiler type
#endif

/*!
 * @}
 */ /* end of group Peripheral_access_layer */


#endif  /* INPUTMUX_H_ */

