# 预备知识

1. KE17Z512Flash一共512KB， 分为2个物理Block， 每个256KB，扇区大小为2K
2. 物理地址: 0x00000 - 0x40000(0-256K)         叫做 LB(Lower Block)
3. 物理地址: 0x40000 - 0x80000(256K - 512K)叫做 UB(Upper Block)
4. 逻辑地址: CPU所认为的地址，如果没有FlashSwap功能，那么逻辑地址就是物理地址

## FlashSwap

FlashSwap的意思就是用户可以执行一次操作，让逻辑地址映射到LB或者UB上

* 比如默认情况下代码存在LB从0地址开始的区域上，逻辑地址也是0。
* 当启动一次Swap后，下次启动时候，逻辑地址的0已经映射到UB(物理:0x40000)上， 对于CPU来说，CPU看到的0地址已经是物理地址的(0x40000)了。 
* 如果再次执行SWAP，则再换回来，互相Ping-Pang, 以此类推。

## 运行代码

将代码烧录到板子后，连接串口，按复位，会打印:

```
PFlash Swap Example Start
APP VERSION location offset:0x24
APP VERSION:0
CURRENT SWAP STAT: LowerAtZero(Physical Address:0x0, mapped to Logial 0x00000000)
Current swap system status: Uninitialized 
swapIndicatorAddress:0x3F800

PLEASE SELECT...
1 - Show flash info
2 - Simulate update firmware
3 - Swap flash and reboot
4 - Reboot
```

其中 `CURRENT SWAP STAT: LowerAtZero(Physical Address:0x0, mapped to Logicl 0x00000000)` 代表当前CPU的逻辑地址映射到物理地址:0x0000_0000上(相当并没有FlashSwap)

1. 输入1： 可以打印Flash的基本信息
2. 输入2： 模仿固件升级行为，实际上就是把LB的IMAGE整体copy到 UB上，只是在VPP_VERSION这个位置自加1.
3. 输入3： 使能FlashSwap并且重启(生效)
4. 输入4:   重启
