/*
 * Copyright  2018 ,2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Pins v9.0
processor: LPC804
package_id: LPC804M101JDH24
mcu_data: ksdk2_0
processor_version: 9.0.0
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

#include "fsl_common.h"
#include "fsl_swm.h"
#include "pin_mux.h"

//#include "fsl_gpio.h"

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitBootPins
 * Description   : Calls initialization functions.
 *
 * END ****************************************************************************************************************/
void BOARD_InitBootPins(void)
{
    BOARD_InitPins();
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPins:
- options: {callFromInitBoot: 'true', coreID: core0, enableClock: 'true'}
- pin_list:
  - {pin_num: '22', peripheral: USART0, signal: RXD, pin_signal: PIO0_0/ACMP_I1}
  - {pin_num: '7', peripheral: USART0, signal: TXD, pin_signal: PIO0_4/ADC_11}
  - {pin_num: '13', peripheral: CTIMER0, signal: 'MATCH, 1', pin_signal: PIO0_20}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M0P */
void BOARD_InitPins(void)
{
    /* Enables clock for switch matrix.: enable */
    CLOCK_EnableClock(kCLOCK_Swm);

    /* USART0_TXD connect to P0_4 */
    SWM_SetMovablePinSelect(SWM0, kSWM_USART0_TXD, kSWM_PortPin_P0_4);

    /* USART0_RXD connect to P0_0 */
    SWM_SetMovablePinSelect(SWM0, kSWM_USART0_RXD, kSWM_PortPin_P0_0);

    /* TimerMatchChannel1 connect to P0_12 */
    SWM_SetMovablePinSelect(SWM0, kSWM_T0_MAT_CHN1, kSWM_PortPin_P0_12);

    /* TimerMatchChannel2 connect to P0_13 */
    SWM_SetMovablePinSelect(SWM0, kSWM_T0_MAT_CHN2, kSWM_PortPin_P0_13);	


    /* PLU_INPUT4 connect to kSWM_PLU_INPUT4_PortPin_P0_12 */
    SWM_SetFixedMovablePinSelect(SWM0, kSWM_PLU_INPUT4, kSWM_PLU_INPUT4_PortPin_P0_12);

    /* PLU_INPUT5 connect to kSWM_PLU_INPUT5_PortPin_P0_13 */
    SWM_SetFixedMovablePinSelect(SWM0, kSWM_PLU_INPUT5, kSWM_PLU_INPUT5_PortPin_P0_13);

		
    /* PLU_OUT0 connect to kSWM_PLU_OUT0_PortPin_P0_14 */
    SWM_SetFixedMovablePinSelect(SWM0, kSWM_PLU_OUT0, kSWM_PLU_OUT0_PortPin_P0_14);

	

    /* Disable clock for switch matrix. */
    CLOCK_DisableClock(kCLOCK_Swm);
}
/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
