# NXP Application Code Hub
[<img src="https://mcuxpresso.nxp.com/static/icon/nxp-logo-color.svg" width="100"/>](https://www.nxp.com)

## AN13864: Smart Battery Charger by LPC865 with SMBus Interface
The application of batteries is everywhere: smartphones, notebook computers, wearable devices, handheld electronic products, smart small appliances, and so on. Information about the state of batteries is important for the user, for example, the battery temperature, voltage, current, capacity, how much time is needed to charge the battery and to get it depleted. It is very important to ensure the safety of battery charging and provide a smooth and controllable charging curve. The abovementioned requirements are expected to be realized by a smart charger. A smart charging solution implemented with LPC865 is recommended.
LPC86x is an Arm Cortex-M0+ based, low-cost 32-bit MCU family operating at CPU frequencies of up to 48MHz. LPC86x supports up to 64 KB of flash memory and 8 KB of SRAM. The peripheral complement of the LPC86x includes a CRC engine, one I2C bus interface, one I3C-MIPI bus interface, up to three USARTs, up to two SPI interfaces, one multi-rate timer, self-wake-up timer, two FlexTimers, a DMA, one 12-bit ADC, one analog comparator, function-configurable I/O ports through a switch matrix, an input pattern match engine, and up to 54 general-purpose I/O pins.

#### Boards: LPCXpresso860MAX
#### Categories: Industrial
#### Peripherals: ADC, GPIO, I2C, UART, TIMER, SPI
#### Toolchains: IAR

## Table of Contents
1. [Software](#step1)
2. [Hardware](#step2)
3. [Setup](#step3)
4. [Results](#step4)
5. [FAQs](#step5) 
6. [Support](#step6)
7. [Release Notes](#step7)

## 1. Software<a name="step1"></a>
SDK version: SDK_2.13.0_LPCXpresso860MAX, 2023-04-18
IDE verion: IAR 9.40.1
The software for this Application Note is delivered in raw source files. The user should download SDK , use config tools to create "hello world" independent project, and replace some files with the raw source code. 

## 2. Hardware<a name="step2"></a>
NXP LPC865 battery charger board,
+12V adapter, 
Smart battery,
LPC-Link2.

## 3. Setup<a name="step3"></a>
Please refer to AN13864 at https://www.nxp.com/products/processors-and-microcontrollers/arm-microcontrollers/general-purpose-mcus/lpc800-arm-cortex-m0-plus-/lpc860-32-bit-arm-cortex-m0-plus-based-low-cost-mcu-with-i3c-interface:LPC86X

### 3.1 Step 1
Open hello world example in SDK, replace below files in project:
board.c,
board.h,
clock_config.c,
clock_config.h,
pin_mux.c,
pin_mux.h,
hello_world.c

### 3.2 Step 2
Add below files in the "drivers" in the project,
fsl_adc.c
fsl_adc.h
fsl_ftm.c
fsl_ftm.h
fsl_i2c.c
fsl_i2c.h
fsl_inputmux.c
fsl_inputmux.h
fsl_inputmux_connections.h
fsl_mrt.c
fsl_mrt.h



### 3.3 Step 3

### 3.4 Step 4

### 3.5 Step 5


## 4. Results<a name="step4"></a>
*For app notes and ap sw packs you can refer the reader to the documentation from the introduction here, or just say "Not applicable for this example". For demos and code snippets/general code you should normally provide a description of what should happen when you run the code.*

*For training content you would usually refer the reader to the training workbook here.*

## 5. FAQs<a name="step5"></a>
*Include FAQs here if appropriate. If there are none, then state "No FAQs have been identified for this project".*

## 6. Support<a name="step6"></a>
*Provide URLs for help here.*

#### Project Metadata
<!----- Boards ----->
[![Board badge](https://img.shields.io/badge/Board-LPCXPRESSO860MAX-blue)](https://github.com/search?q=org%3Anxp-appcodehub+LPCXpresso860MAX+in%3Areadme&type=Repositories)

<!----- Categories ----->
[![Category badge](https://img.shields.io/badge/Category-INDUSTRIAL-yellowgreen)](https://github.com/search?q=org%3Anxp-appcodehub+industrial+in%3Areadme&type=Repositories)

<!----- Peripherals ----->
[![Peripheral badge](https://img.shields.io/badge/Peripheral-ADC-yellow)](https://github.com/search?q=org%3Anxp-appcodehub+adc+in%3Areadme&type=Repositories) [![Peripheral badge](https://img.shields.io/badge/Peripheral-GPIO-yellow)](https://github.com/search?q=org%3Anxp-appcodehub+gpio+in%3Areadme&type=Repositories) [![Peripheral badge](https://img.shields.io/badge/Peripheral-I2C-yellow)](https://github.com/search?q=org%3Anxp-appcodehub+i2c+in%3Areadme&type=Repositories) [![Peripheral badge](https://img.shields.io/badge/Peripheral-UART-yellow)](https://github.com/search?q=org%3Anxp-appcodehub+uart+in%3Areadme&type=Repositories) [![Peripheral badge](https://img.shields.io/badge/Peripheral-TIMER-yellow)](https://github.com/search?q=org%3Anxp-appcodehub+timer+in%3Areadme&type=Repositories) [![Peripheral badge](https://img.shields.io/badge/Peripheral-SPI-yellow)](https://github.com/search?q=org%3Anxp-appcodehub+spi+in%3Areadme&type=Repositories)

<!----- Toolchains ----->
[![Toolchain badge](https://img.shields.io/badge/Toolchain-IAR-orange)](https://github.com/search?q=org%3Anxp-appcodehub+iar+in%3Areadme&type=Repositories)

Questions regarding the content/correctness of this example can be entered as Issues within this GitHub repository.

>**Warning**: For more general technical questions regarding NXP Microcontrollers and the difference in expected funcionality, enter your questions on the [NXP Community Forum](https://community.nxp.com/)

[![Follow us on Youtube](https://img.shields.io/badge/Youtube-Follow%20us%20on%20Youtube-red.svg)](https://www.youtube.com/@NXP_Semiconductors)
[![Follow us on LinkedIn](https://img.shields.io/badge/LinkedIn-Follow%20us%20on%20LinkedIn-blue.svg)](https://www.linkedin.com/company/nxp-semiconductors)
[![Follow us on Facebook](https://img.shields.io/badge/Facebook-Follow%20us%20on%20Facebook-blue.svg)](https://www.facebook.com/nxpsemi/)
[![Follow us on Twitter](https://img.shields.io/badge/Twitter-Follow%20us%20on%20Twitter-white.svg)](https://twitter.com/NXP)

## 7. Release Notes<a name="step7"></a>
| Version | Description / Update                           | Date                        |
|:-------:|------------------------------------------------|----------------------------:|
| 1.0     | Initial release on Application Code Hub        | August 14<sup>th</sup> 2023 |

