/*! *********************************************************************************
* Copyright (c) 2014, Freescale Semiconductor, Inc.
* Copyright 2016-2017 NXP
* All rights reserved.
*
* \file
*
* SPDX-License-Identifier: BSD-3-Clause
********************************************************************************** */
#ifndef GATT_DB_X_MACROS_H
#define GATT_DB_X_MACROS_H

#define XALLOC_PRIMARY_SERVICE(name, uuid)                                              PRIMARY_SERVICE_ALLOC(name, (uuid) )
#define XALLOC_PRIMARY_SERVICE_UUID32(name, uuid32)                                     PRIMARY_SERVICE_UUID32_ALLOC(name, (uuid32) )
#define XALLOC_PRIMARY_SERVICE_UUID128(name, uuid128)                                   PRIMARY_SERVICE_UUID128_ALLOC(name, (uuid128) )
#define XALLOC_SECONDARY_SERVICE(name, uuid)                                            SECONDARY_SERVICE_ALLOC(name, (uuid) )
#define XALLOC_SECONDARY_SERVICE_UUID32(name, uuid32)                                   SECONDARY_SERVICE_UUID32_ALLOC(name, (uuid32) )
#define XALLOC_SECONDARY_SERVICE_UUID128(name, uuid128)                                 SECONDARY_SERVICE_UUID128_ALLOC(name, (uuid128) )
#define XALLOC_INCLUDE(service_attribute_handle)                                        INCLUDE_ALLOC(service_attribute_handle)
#define XALLOC_INCLUDE_CUSTOM(service_attribute_handle)                                 INCLUDE_CUSTOM_ALLOC(service_attribute_handle)
#define XALLOC_CHARACTERISTIC(name, uuid, properties)                                   CHARACTERISTIC_ALLOC(name, (uuid), (properties) )
#define XALLOC_CHARACTERISTIC_UUID32(name, uuid32, properties)                          CHARACTERISTIC_UUID32_ALLOC(name, (uuid32), (properties) )
#define XALLOC_CHARACTERISTIC_UUID128(name, uuid128, properties)                        CHARACTERISTIC_UUID128_ALLOC(name, (properties) )
#define XALLOC_VALUE(name, uuid, permissions, size, ...)                                VALUE_ALLOC(name, (size), __VA_ARGS__)
#define XALLOC_VALUE_UUID32(name, uuid, permissions, size, ...)                         VALUE_ALLOC(name, (size), __VA_ARGS__)
#define XALLOC_VALUE_UUID128(name, uuid, permissions, size, ...)                        VALUE_ALLOC(name, (size), __VA_ARGS__)
#define XALLOC_VALUE_VARLEN(name, uuid, permissions, maxSize, initSize, ...)            VALUE_ALLOC(name, (maxSize), __VA_ARGS__)
#define XALLOC_VALUE_UUID32_VARLEN(name, uuid, permissions, maxSize, initSize, ...)     VALUE_ALLOC(name, (maxSize), __VA_ARGS__)
#define XALLOC_VALUE_UUID128_VARLEN(name, uuid, permissions, maxSize, initSize, ...)    VALUE_ALLOC(name, (maxSize), __VA_ARGS__)
#define XALLOC_CCCD(name)                                                               CCCD_ALLOC(name)
#define XALLOC_DESCRIPTOR(name, uuid, permissions, size, ...)                           DESCRIPTOR_ALLOC(name, (size), __VA_ARGS__)
#define XALLOC_UUID32_DESCRIPTOR(name, uuid, permissions, size, ...)                    DESCRIPTOR_ALLOC(name, (size), __VA_ARGS__)
#define XALLOC_UUID128_DESCRIPTOR(name, uuid, permissions, size, ...)                   DESCRIPTOR_ALLOC(name, (size), __VA_ARGS__)
#define XALLOC_CHARACTERISTIC_AGGREGATE(name, uuid, permissions, size, ...)             DESCRIPTOR_ALLOC(name, (size), __VA_ARGS__)

#define XDECL_PRIMARY_SERVICE(name, uuid)                                               PRIMARY_SERVICE_DECL(name)
#define XDECL_PRIMARY_SERVICE_UUID32(name, uuid32)                                      PRIMARY_SERVICE_UUID32_DECL(name)
#define XDECL_PRIMARY_SERVICE_UUID128(name, uuid128)                                    PRIMARY_SERVICE_UUID128_DECL(name)
#define XDECL_SECONDARY_SERVICE(name, uuid)                                             SECONDARY_SERVICE_DECL(name)
#define XDECL_SECONDARY_SERVICE_UUID32(name, uuid32)                                    SECONDARY_SERVICE_UUID32_DECL(name)
#define XDECL_SECONDARY_SERVICE_UUID128(name, uuid128)                                  SECONDARY_SERVICE_UUID128_DECL(name)
#define XDECL_INCLUDE(service_attribute_handle)                                         INCLUDE_DECL(service_attribute_handle)
#define XDECL_INCLUDE_CUSTOM(service_attribute_handle)                                  INCLUDE_CUSTOM_DECL(service_attribute_handle)
#define XDECL_CHARACTERISTIC(name, uuid, properties)                                    CHARACTERISTIC_DECL(name)
#define XDECL_CHARACTERISTIC_UUID32(name, uuid32, properties)                           CHARACTERISTIC_UUID32_DECL(name)
#define XDECL_CHARACTERISTIC_UUID128(name, uuid128, properties)                         CHARACTERISTIC_UUID128_DECL(name)
#define XDECL_VALUE(name, uuid, permissions, size, ...)                                 VALUE_DECL(name, (size), (uuid), (permissions) )
#define XDECL_VALUE_UUID32(name, uuid32, permissions, size, ...)                        VALUE_UUID32_DECL(name, (size), (uuid32), (permissions) )
#define XDECL_VALUE_UUID128(name, uuid128, permissions, size, ...)                      VALUE_UUID128_DECL(name, (size), uuid128, (permissions) )
#define XDECL_VALUE_VARLEN(name, uuid, permissions, maxSize, initSize, ...)             VALUE_VARLEN_DECL(name, maxSize, initSize, (uuid), (permissions) )
#define XDECL_VALUE_UUID32_VARLEN(name, uuid32, permissions, maxSize, initSize, ...)    VALUE_UUID32_VARLEN_DECL(name, maxSize, initSize, (uuid32), (permissions) )
#define XDECL_VALUE_UUID128_VARLEN(name, uuid128, permissions, maxSize, initSize, ...)  VALUE_UUID128_VARLEN_DECL(name, maxSize, initSize, uuid128, (permissions) )
#define XDECL_CCCD(name)                                                                CCCD_DECL(name)
#define XDECL_DESCRIPTOR(name, uuid, permissions, size, ...)                            DESCRIPTOR_DECL(name, (size), (uuid), (permissions) )
#define XDECL_DESCRIPTOR_UUID32(name, uuid32, permissions, size, ...)                   DESCRIPTOR_UUID32_DECL(name, (size), (uuid32), (permissions) )
#define XDECL_DESCRIPTOR_UUID128(name, uuid128, permissions, size, ...)                 DESCRIPTOR_UUID128_DECL(name, (size), (uuid128), (permissions) )
#define XDECL_CHARACTERISTIC_AGGREGATE(name, uuid, permissions, size, ...)              DESCRIPTOR_DECL(name, (size), (uuid), (permissions) )

#define XINIT_PRIMARY_SERVICE_UUID128(name, uuid128)                                    PRIMARY_SERVICE_UUID128_INIT(name, uuid128 )
#define XINIT_SECONDARY_SERVICE_UUID128(name, uuid128)                                  SECONDARY_SERVICE_UUID128_INIT(name, uuid128 )
#define XINIT_CHARACTERISTIC_UUID128(name, uuid128, properties)                         CHARACTERISTIC_UUID128_INIT(name, uuid128 )
#define XINIT_INCLUDE(service_attribute_handle)                                         INCLUDE_INIT(service_attribute_handle)
#define XINIT_INCLUDE_CUSTOM(service_attribute_handle)                                  INCLUDE_CUSTOM_INIT(service_attribute_handle)

#define XSIZE_PRIMARY_SERVICE(name, uuid)                                               UNIVERSAL_MACRO_SIZE(name)
#define XSIZE_PRIMARY_SERVICE_UUID32(name, uuid32)                                      UNIVERSAL_MACRO_SIZE(name)
#define XSIZE_PRIMARY_SERVICE_UUID128(name, uuid128)                                    UNIVERSAL_MACRO_SIZE(name)
#define XSIZE_SECONDARY_SERVICE(name, uuid)                                             UNIVERSAL_MACRO_SIZE(name)
#define XSIZE_SECONDARY_SERVICE_UUID32(name, uuid32)                                    UNIVERSAL_MACRO_SIZE(name)
#define XSIZE_SECONDARY_SERVICE_UUID128(name, uuid128)                                  UNIVERSAL_MACRO_SIZE(name)
#define XSIZE_INCLUDE(service_attribute_handle)                                         INCLUDE_MACRO_SIZE(include##service_attribute_handle)
#define XSIZE_INCLUDE_CUSTOM(service_attribute_handle)                                  INCLUDE_MACRO_SIZE(include##service_attribute_handle)
#define XSIZE_CHARACTERISTIC(name, uuid, properties)                                    UNIVERSAL_MACRO_SIZE(name)
#define XSIZE_CHARACTERISTIC_UUID32(name, uuid32, properties)                           UNIVERSAL_MACRO_SIZE(name)
#define XSIZE_CHARACTERISTIC_UUID128(name, uuid128, properties)                         UNIVERSAL_MACRO_SIZE(name)
#define XSIZE_VALUE(name, uuid, permissions, size, ...)                                 UNIVERSAL_MACRO_SIZE(name)
#define XSIZE_VALUE_UUID32(name, uuid32, permissions, size, ...)                        UNIVERSAL_MACRO_SIZE(name)
#define XSIZE_VALUE_UUID128(name, uuid128, permissions, size, ...)                      UNIVERSAL_MACRO_SIZE(name)
#define XSIZE_VALUE_VARLEN(name, uuid, permissions, maxSize, initSize, ...)             UNIVERSAL_MACRO_SIZE(name)
#define XSIZE_VALUE_UUID32_VARLEN(name, uuid32, permissions, maxSize, initSize, ...)    UNIVERSAL_MACRO_SIZE(name)
#define XSIZE_VALUE_UUID128_VARLEN(name, uuid128, permissions, maxSize, initSize, ...)  UNIVERSAL_MACRO_SIZE(name)
#define XSIZE_CCCD(name)                                                                UNIVERSAL_MACRO_SIZE(name)
#define XSIZE_DESCRIPTOR(name, uuid, permissions, size, ...)                            UNIVERSAL_MACRO_SIZE(name)
#define XSIZE_DESCRIPTOR_UUID32(name, uuid, permissions, size, ...)                     UNIVERSAL_MACRO_SIZE(name)
#define XSIZE_DESCRIPTOR_UUID128(name, uuid, permissions, size, ...)                    UNIVERSAL_MACRO_SIZE(name)
#define XSIZE_CHARACTERISTIC_AGGREGATE(name, uuid, permissions, size, ...)              UNIVERSAL_MACRO_SIZE(name)

#define XENUM_PRIMARY_SERVICE(name, uuid)                                               UNIVERSAL_MACRO_ENUM(name)
#define XENUM_PRIMARY_SERVICE_UUID32(name, uuid32)                                      UNIVERSAL_MACRO_ENUM(name)
#define XENUM_PRIMARY_SERVICE_UUID128(name, uuid128)                                    UNIVERSAL_MACRO_ENUM(name)
#define XENUM_SECONDARY_SERVICE(name, uuid)                                             UNIVERSAL_MACRO_ENUM(name)
#define XENUM_SECONDARY_SERVICE_UUID32(name, uuid32)                                    UNIVERSAL_MACRO_ENUM(name)
#define XENUM_SECONDARY_SERVICE_UUID128(name, uuid128)                                  UNIVERSAL_MACRO_ENUM(name)
#define XENUM_INCLUDE(service_attribute_handle)                                         INCLUDE_MACRO_ENUM(include##service_attribute_handle)
#define XENUM_INCLUDE_CUSTOM(service_attribute_handle)                                  INCLUDE_MACRO_ENUM(include##service_attribute_handle)
#define XENUM_CHARACTERISTIC(name, uuid, properties)                                    UNIVERSAL_MACRO_ENUM(name)
#define XENUM_CHARACTERISTIC_UUID32(name, uuid32, properties)                           UNIVERSAL_MACRO_ENUM(name)
#define XENUM_CHARACTERISTIC_UUID128(name, uuid128, properties)                         UNIVERSAL_MACRO_ENUM(name)
#define XENUM_VALUE(name, uuid, permissions, size, ...)                                 UNIVERSAL_MACRO_ENUM(name)
#define XENUM_VALUE_UUID32(name, uuid32, permissions, size, ...)                        UNIVERSAL_MACRO_ENUM(name)
#define XENUM_VALUE_UUID128(name, uuid128, permissions, size, ...)                      UNIVERSAL_MACRO_ENUM(name)
#define XENUM_VALUE_VARLEN(name, uuid, permissions, maxSize, initSize, ...)             UNIVERSAL_MACRO_ENUM(name)
#define XENUM_VALUE_UUID32_VARLEN(name, uuid32, permissions, maxSize, initSize, ...)    UNIVERSAL_MACRO_ENUM(name)
#define XENUM_VALUE_UUID128_VARLEN(name, uuid128, permissions, maxSize, initSize, ...)  UNIVERSAL_MACRO_ENUM(name)
#define XENUM_CCCD(name)                                                                UNIVERSAL_MACRO_ENUM(name)
#define XENUM_DESCRIPTOR(name, uuid, permissions, size, ...)                            UNIVERSAL_MACRO_ENUM(name)
#define XENUM_DESCRIPTOR_UUID32(name, uuid, permissions, size, ...)                     UNIVERSAL_MACRO_ENUM(name)
#define XENUM_DESCRIPTOR_UUID128(name, uuid, permissions, size, ...)                    UNIVERSAL_MACRO_ENUM(name)
#define XENUM_CHARACTERISTIC_AGGREGATE(name, uuid, permissions, size, ...)              UNIVERSAL_MACRO_ENUM(name)

#endif /* GATT_DB_X_MACROS_H */
