/*! *********************************************************************************
 * \addtogroup BLE
 * @{
 ********************************************************************************** */
/*! *********************************************************************************
* Copyright (c) 2015, Freescale Semiconductor, Inc.
* Copyright 2016-2017, 2021 NXP
* All rights reserved.
*
* \file
*
* SPDX-License-Identifier: BSD-3-Clause
********************************************************************************** */

#ifndef BLE_HOST_TASKS_H
#define BLE_HOST_TASKS_H

/************************************************************************************
*************************************************************************************
* Include
*************************************************************************************
************************************************************************************/
#include "EmbeddedTypes.h"
#include "fsl_component_messaging.h"
#include "fsl_os_abstraction.h"
#include "ble_general.h"

#if defined(gBLE_ChannelSounding_d) && (gBLE_ChannelSounding_d == TRUE)
#include "hci_interface.h"
#endif

/************************************************************************************
*************************************************************************************
* Public memory declarations
*************************************************************************************
************************************************************************************/
/*! App to Host message queue for the Host Task */
extern messaging_t   gApp2Host_TaskQueue;
/*! HCI to Host message queue for the Host Task */
extern messaging_t   gHci2Host_TaskQueue;
/*! Event for the Host Task Queue */
extern OSA_EVENT_HANDLE_DEFINE(gHost_TaskEvent);

/************************************************************************************
*************************************************************************************
* Public prototypes
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Public type definitions
*************************************************************************************
************************************************************************************/
#if defined(gBLE_ChannelSounding_d) && (gBLE_ChannelSounding_d == TRUE)
typedef bool_t (*csEventCallback_t) (uint8_t *pMsg);
typedef bleResult_t (*csEventHandlerLeMetaEvent) (hciLeMetaEvent_t* pHciEvent);
typedef bleResult_t (*csEventHandlerCmdCompleteEvent) (hciCommandCompleteEvent_t *pHciCmdCompleteEvent);
typedef bleResult_t (*csEventHandlerCmdStatusEvent) (hciCommandStatusEvent_t* pHciEvent);
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*! *********************************************************************************
* \brief  Contains the Host Task logic.
*
* \remarks This function must be called exclusively by the Host Task code
* from the application.
*
********************************************************************************** */
void Host_TaskHandler(void * args);

#if defined(gBLE_ChannelSounding_d) && (gBLE_ChannelSounding_d == TRUE)
/*! *********************************************************************************
* \brief  Register the application to CS callback
*
* \remarks This function must be called exclusively by the CS library
*
********************************************************************************** */
void Host_RegisterCsEventCallback(csEventCallback_t eventCallback);

/*! *********************************************************************************
* \brief  Register the HCI to CS HCI LE Meta event callback
*
* \remarks This function must be called exclusively by the CS library
*
********************************************************************************** */
void Host_RegisterLeCsMetaEventCallback(csEventHandlerLeMetaEvent eventCallback);

/*! *********************************************************************************
* \brief  Register the HCI to CS command complete event callback
*
* \remarks This function must be called exclusively by the CS library
*
********************************************************************************** */
void Host_RegisterCmdCompleteEventCallback(csEventHandlerCmdCompleteEvent eventCallback);

/*! *********************************************************************************
* \brief  Register the HCI to CS command status event callback
*
* \remarks This function must be called exclusively by the CS library
*
********************************************************************************** */
void Host_RegisterCmdStatusEventCallback(csEventHandlerCmdStatusEvent eventCallback);
#endif

#ifdef __cplusplus
}
#endif

#endif /* BLE_HOST_TASKS_H */

/*! *********************************************************************************
* @}
********************************************************************************** */
