/*
	* Copyright 2021 NXP
	*
	* SPDX-License-Identifier: BSD-3-Clause
*/

/*
    * FILE NAME: ../boards/lpcxpresso55s36/mc_pmsm/pmsm_enc_dual/m2_pmsm_appconfig.h
    * DATE: Fri Dec 10 2021, 13:32:26
*/
#ifndef __M2_PMSM_APPCONFIG_H
#define __M2_PMSM_APPCONFIG_H

/********************************************************************************
 * Motor Connector 2 config
 ********************************************************************************/
#define M2_MOTOR_LINIX				(1)		// Set to 1 to use Linix
#define M2_MOTOR_TEKNIC				(0)		// Set to 1 to use Teknic

#if ( (0 != M2_MOTOR_TEKNIC) == (0 != M2_MOTOR_LINIX) )
#error Incorrect configuration, select either Linix or Teknic motor.
#endif

#if M2_MOTOR_TEKNIC

/* PARAMETERS*/
#define M2_MOTOR_PP (4)
#define M2_I_PH_NOM (2.0F)
#define M2_N_NOM (1675.52F)
#define M2_I_MAX (8.25F)
#define M2_U_DCB_MAX (60.8F)
#define M2_U_DCB_TRIP (28.0F)
#define M2_U_DCB_UNDERVOLTAGE (16.0F)
#define M2_U_DCB_OVERVOLTAGE (30.0F)
#define M2_N_OVERSPEED (1842.65F)
#define M2_N_MIN (125.664F)
#define M2_E_BLOCK_TRH (0.7F)
#define M2_E_BLOCK_PER (2000)
#define M2_N_MAX (1843.07F)
#define M2_CALIB_DURATION (200)
#define M2_FAULT_DURATION (6000)
#define M2_FREEWHEEL_DURATION (1500)
#define M2_SCALAR_UQ_MIN (1.0F)
#define M2_ALIGN_VOLTAGE (1.2F)
#define M2_ALIGN_DURATION (1000)
#define M2_U_MAX (35.1029F)
#define M2_FREQ_MAX (293.333F)
#define M2_N_ANGULAR_MAX (2.38732F)
#define M2_UDCB_IIR_B0 (0.0304590F)
#define M2_UDCB_IIR_B1 (0.0304590F)
#define M2_UDCB_IIR_A1 (0.939082F)
#define M2_SCALAR_VHZ_FACTOR_GAIN (0.0562500F)
#define M2_SCALAR_INTEG_GAIN ACC32(0.0586667)
#define M2_SCALAR_RAMP_UP (0.0666667F)
#define M2_SCALAR_RAMP_DOWN (0.0666667F)
/* CURRENTLOOP*/
#define M2_D_KP_GAIN (0.459831F)
#define M2_D_KI_GAIN (0.106749F)
#define M2_Q_KP_GAIN (0.344020F)
#define M2_Q_KI_GAIN (0.0962702F)
#define M2_CLOOP_LIMIT (0.519615F)
/* SPEEDLOOP*/
#define M2_SPEED_RAMP_UP (4.18879F)
#define M2_SPEED_RAMP_DOWN (4.18879F)
#define M2_SPEED_LOOP_HIGH_LIMIT (2.0F)
#define M2_SPEED_LOOP_LOW_LIMIT (-2.0F)
#define M2_SPEED_PI_PROP_GAIN (0.00920221F)
#define M2_SPEED_PI_INTEG_GAIN (0.0000809469F)
#define M2_POS_P_PROP_GAIN FRAC16(0.12)
#define M2_SPEED_IIR_B0 (0.0304590F)
#define M2_SPEED_IIR_B1 (0.0304590F)
#define M2_SPEED_IIR_A1 (0.939082F)
/* SENSORS*/
#define M2_POSPE_ENC_PULSES (1000)
#define M2_POSPE_ENC_DIRECTION (0)
#define M2_POSPE_ENC_N_MIN (0.0F)
#define M2_POSPE_MECH_POS_GAIN ACC32(16.384)
#define M2_POSPE_KP_GAIN (1256.64F)
#define M2_POSPE_KI_GAIN (39.4784F)
#define M2_POSPE_INTEG_GAIN (0.0000318310F)
/* SENSORLESS*/
#define M2_OL_START_RAMP_INC (0.125664F)
#define M2_OL_START_I (0.65F)
#define M2_MERG_SPEED_TRH (209.440F)
#define M2_MERG_COEFF FRAC16(0.00457764)
#define M2_I_SCALE (0.819095F)
#define M2_U_SCALE (0.251256F)
#define M2_E_SCALE (0.251256F)
#define M2_WI_SCALE (0.0000738693F)
#define M2_BEMF_DQ_KP_GAIN (0.508991F)
#define M2_BEMF_DQ_KI_GAIN (0.115830F)
#define M2_TO_KP_GAIN (879.646F)
#define M2_TO_KI_GAIN (19.3444F)
#define M2_TO_THETA_GAIN (0.0000318310F)
#define M2_TO_SPEED_IIR_B0 (0.111635F)
#define M2_TO_SPEED_IIR_B1 (0.111635F)
#define M2_TO_SPEED_IIR_A1 (0.776730F)

#else

/* PARAMETERS*/
#define M2_MOTOR_PP (2)
#define M2_I_PH_NOM (2.0F)
#define M2_N_NOM (837.758F)
#define M2_I_MAX (8.25F)
#define M2_U_DCB_MAX (60.8F)
#define M2_U_DCB_TRIP (29.0F)
#define M2_U_DCB_UNDERVOLTAGE (16.0F)
#define M2_U_DCB_OVERVOLTAGE (32.0F)
#define M2_N_OVERSPEED (921.324F)
#define M2_N_MIN (62.8319F)
#define M2_E_BLOCK_TRH (1.4F)
#define M2_E_BLOCK_PER (2000)
#define M2_N_MAX (921.534F)
#define M2_CALIB_DURATION (200)
#define M2_FAULT_DURATION (6000)
#define M2_FREEWHEEL_DURATION (1500)
#define M2_SCALAR_UQ_MIN (1.0F)
#define M2_ALIGN_VOLTAGE (1.2F)
#define M2_ALIGN_DURATION (400)
#define M2_U_MAX (35.1029F)
#define M2_FREQ_MAX (146.667F)
#define M2_N_ANGULAR_MAX (4.77465F)
#define M2_UDCB_IIR_B0 (0.0304590F)
#define M2_UDCB_IIR_B1 (0.0304590F)
#define M2_UDCB_IIR_A1 (0.939082F)
#define M2_SCALAR_VHZ_FACTOR_GAIN (0.112500F)
#define M2_SCALAR_INTEG_GAIN ACC32(0.0293333)
#define M2_SCALAR_RAMP_UP (0.0333333F)
#define M2_SCALAR_RAMP_DOWN (0.0333333F)
/* CURRENTLOOP*/
#define M2_D_KP_GAIN (0.907168F)
#define M2_D_KI_GAIN (0.122794F)
#define M2_Q_KP_GAIN (1.10260F)
#define M2_Q_KI_GAIN (0.140476F)
#define M2_CLOOP_LIMIT (0.519615F)
/* SPEEDLOOP*/
#define M2_SPEED_RAMP_UP (2.09440F)
#define M2_SPEED_RAMP_DOWN (2.09440F)
#define M2_SPEED_LOOP_HIGH_LIMIT (2.0F)
#define M2_SPEED_LOOP_LOW_LIMIT (-2.0F)
#define M2_SPEED_PI_PROP_GAIN (0.00246648F)
#define M2_SPEED_PI_INTEG_GAIN (0.0000216963F)
#define M2_POS_P_PROP_GAIN FRAC16(0.12)
#define M2_SPEED_IIR_B0 (0.0304590F)
#define M2_SPEED_IIR_B1 (0.0304590F)
#define M2_SPEED_IIR_A1 (0.939082F)
/* SENSORS*/
#define M2_POSPE_ENC_PULSES (1000)
#define M2_POSPE_ENC_DIRECTION (0)
#define M2_POSPE_ENC_N_MIN (0.0F)
#define M2_POSPE_MECH_POS_GAIN ACC32(16.384)
#define M2_POSPE_KP_GAIN (1256.64F)
#define M2_POSPE_KI_GAIN (39.4784F)
#define M2_POSPE_INTEG_GAIN (0.0000318310F)
/* SENSORLESS*/
#define M2_OL_START_RAMP_INC (0.0628319F)
#define M2_OL_START_I (0.65F)
#define M2_MERG_SPEED_TRH (104.720F)
#define M2_MERG_COEFF FRAC16(0.00915527)
#define M2_I_SCALE (0.892857F)
#define M2_U_SCALE (0.238095F)
#define M2_E_SCALE (0.238095F)
#define M2_WI_SCALE (0.000102143F)
#define M2_BEMF_DQ_KP_GAIN (0.963717F)
#define M2_BEMF_DQ_KI_GAIN (0.133240F)
#define M2_TO_KP_GAIN (879.646F)
#define M2_TO_KI_GAIN (19.3444F)
#define M2_TO_THETA_GAIN (0.0000318310F)
#define M2_TO_SPEED_IIR_B0 (0.111635F)
#define M2_TO_SPEED_IIR_B1 (0.111635F)
#define M2_TO_SPEED_IIR_A1 (0.776730F)

#endif	/* #if M2_MOTOR_TEKNIC */

/* USER INPUT START */
#define AA 1
#define BB 3
#define CC 4
#define DD 2
/* USER INPUT END */
#endif /* __M2_PMSM_APPCONFIG_H */
