/*
 * Copyright 2018-2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 */

#ifndef _FSL_FLASH_ADAPTER_H_
#define _FSL_FLASH_ADAPTER_H_

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*!
 * @name FTFx configuration
 * @{
 */
/*! @brief Flash driver location. */
#if !defined(FLASH_DRIVER_IS_FLASH_RESIDENT)
#if (!defined(BL_TARGET_ROM) && !defined(BL_TARGET_RAM))
#define FLASH_DRIVER_IS_FLASH_RESIDENT 1 /*!< Used for the flash resident application. */
#else
#define FLASH_DRIVER_IS_FLASH_RESIDENT 0 /*!< Used for the non-flash resident application. */
#endif
#endif

#if defined(FMU0_MSF1)
#define FLASH                   FMU0_MSF1_NS
#define FLASH_FSTAT_FAIL_MASK   FMU_FSTAT_FAIL_MASK
#define FLASH_FSTAT_CMDABT_MASK FMU_FSTAT_CMDABT_MASK
#define FLASH_FSTAT_PVIOL_MASK  FMU_FSTAT_PVIOL_MASK
#define FLASH_FSTAT_ACCERR_MASK FMU_FSTAT_ACCERR_MASK
#define FLASH_FSTAT_CWSABT_MASK FMU_FSTAT_CWSABT_MASK
#define FLASH_FSTAT_CCIF_MASK   FMU_FSTAT_CCIF_MASK
#define FLASH_FSTAT_CMDPRT_MASK FMU_FSTAT_CMDPRT_MASK
#define FLASH_FSTAT_CMDP_MASK   FMU_FSTAT_CMDP_MASK
#define FLASH_FSTAT_CMDDID_MASK FMU_FSTAT_CMDDID_MASK
#define FLASH_FSTAT_DFDIF_MASK  FMU_FSTAT_DFDIF_MASK
#define FLASH_FSTAT_PEWEN_MASK  FMU_FSTAT_PEWEN_MASK
#define FLASH_FSTAT_PERDY_MASK  FMU_FSTAT_PERDY_MASK
#elif defined(MSF1)
#define FLASH                   MSF1
#define FLASH_FSTAT_FAIL_MASK   MSF1_FSTAT_FAIL_MASK
#define FLASH_FSTAT_CMDABT_MASK MSF1_FSTAT_CMDABT_MASK
#define FLASH_FSTAT_PVIOL_MASK  MSF1_FSTAT_PVIOL_MASK
#define FLASH_FSTAT_ACCERR_MASK MSF1_FSTAT_ACCERR_MASK
#define FLASH_FSTAT_CWSABT_MASK MSF1_FSTAT_CWSABT_MASK
#define FLASH_FSTAT_CCIF_MASK   MSF1_FSTAT_CCIF_MASK
#define FLASH_FSTAT_CMDPRT_MASK MSF1_FSTAT_CMDPRT_MASK
#define FLASH_FSTAT_CMDP_MASK   MSF1_FSTAT_CMDP_MASK
#define FLASH_FSTAT_CMDDID_MASK MSF1_FSTAT_CMDDID_MASK
#define FLASH_FSTAT_DFDIF_MASK  MSF1_FSTAT_DFDIF_MASK
#define FLASH_FSTAT_PEWEN_MASK  MSF1_FSTAT_PEWEN_MASK
#define FLASH_FSTAT_PERDY_MASK  MSF1_FSTAT_PERDY_MASK
#elif defined(FMU0)
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
#define FLASH FMU0_NS
#if defined(RF_FMU)
#define NBU_FLASH RF_FMU_NS
#endif
#else
#define FLASH FMU0
#if defined(RF_FMU)
#define NBU_FLASH RF_FMU
#endif
#endif
#define FLASH_FSTAT_FAIL_MASK   FMU_FSTAT_FAIL_MASK
#define FLASH_FSTAT_CMDABT_MASK FMU_FSTAT_CMDABT_MASK
#define FLASH_FSTAT_PVIOL_MASK  FMU_FSTAT_PVIOL_MASK
#define FLASH_FSTAT_ACCERR_MASK FMU_FSTAT_ACCERR_MASK
#define FLASH_FSTAT_CWSABT_MASK FMU_FSTAT_CWSABT_MASK
#define FLASH_FSTAT_CCIF_MASK   FMU_FSTAT_CCIF_MASK
#define FLASH_FSTAT_CMDPRT_MASK FMU_FSTAT_CMDPRT_MASK
#define FLASH_FSTAT_CMDP_MASK   FMU_FSTAT_CMDP_MASK
#define FLASH_FSTAT_CMDDID_MASK FMU_FSTAT_CMDDID_MASK
#define FLASH_FSTAT_DFDIF_MASK  FMU_FSTAT_DFDIF_MASK
#define FLASH_FSTAT_PEWEN_MASK  FMU_FSTAT_PEWEN_MASK
#define FLASH_FSTAT_PERDY_MASK  FMU_FSTAT_PERDY_MASK
#endif

#if defined(SMSCM)
#define SMSCM_FLASH_CACHE_CTRL_MASK       SMSCM_OCMDR0_OCMCF2_MASK
#define SMSCM_FLASH_CACHE_CTRL(x)         SMSCM_OCMDR0_OCMCF2(x)
#define SMSCM_FLASH_SPECULATION_CTRL_MASK SMSCM_OCMDR0_OCMCF1_MASK
#define SMSCM_FLASH_SPECULATION_CTRL(x)   SMSCM_OCMDR0_OCMCF1(x)
#endif

#if defined(RF_FMCCFG)
#define NBU_FLASH_CACHE_CTRL_MASK       RF_FMCCFG_RFMCCFG_RFCF3_MASK
#define NBU_FLASH_CACHE_CTRL(x)         RF_FMCCFG_RFMCCFG_RFCF3(x)
#define NBU_FLASH_SPECULATION_CTRL_MASK RF_FMCCFG_RFMCCFG_RFCF2_MASK
#define NBU_FLASH_SPECULATION_CTRL(x)   RF_FMCCFG_RFMCCFG_RFCF2(x)
#endif

#define FLASH_FEATURE_PFLASH0_START_ADDRESS      FSL_FEATURE_FLASH_PFLASH_START_ADDRESS
#define FLASH_FEATURE_PFLASH0_BLOCK_COUNT        FSL_FEATURE_FLASH_PFLASH_BLOCK_COUNT
#define FLASH_FEATURE_PFLASH0_BLOCK_SIZE_512KB   FSL_FEATURE_FLASH_PFLASH_BLOCK_SIZE_512KB
#define FLASH_FEATURE_PFLASH0_BLOCK_SIZE         FSL_FEATURE_FLASH_PFLASH_BLOCK_SIZE
#define FLASH_FEATURE_PFLASH0_IFR0_START_ADDRESS FSL_FEATURE_FLASH_IFR0_START_ADDRESS
#define FLASH_FEATURE_PFLASH0_IFR0_SIZE          FSL_FEATURE_FLASH_IFR0_SIZE

#define FLASH_FEATURE_PFLASH1_START_ADDRESS      FSL_FEATURE_RF_FLASH_PFLASH_START_ADDRESS
#define FLASH_FEATURE_PFLASH1_BLOCK_COUNT        FSL_FEATURE_RF_FLASH_PFLASH_BLOCK_COUNT
#define FLASH_FEATURE_PFLASH1_BLOCK_SIZE         FSL_FEATURE_RF_FLASH_PFLASH_BLOCK_SIZE
#define FLASH_FEATURE_PFLASH1_IFR0_START_ADDRESS FSL_FEATURE_RF_FLASH_IFR0_START_ADDRESS
#define FLASH_FEATURE_PFLASH1_IFR0_SIZE          FSL_FEATURE_RF_FLASH_IFR0_SIZE

#define FLASH_FEATURE_SECTOR_SIZE         FSL_FEATURE_FLASH_PFLASH_SECTOR_SIZE
#define FLASH_FEATURE_PHRASE_SIZE         FSL_FEATURE_FLASH_PFLASH_PHRASE_SIZE
#define FLASH_FEATURE_PAGE_SIZE           FSL_FEATURE_FLASH_PFLASH_PAGE_SIZE
#define FLASH_FEATURE_PHRASE_SIZE_IN_WORD (4u)
#define FLASH_FEATURE_PAGE_SIZE_IN_WORD   (32u)

#endif /* _FSL_FLASH_ADAPTER_H_ */
