/*
 * Copyright 2018-2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause

 */

#include "nxp_xcvr_lcl_config.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*******************************************************************************
 * Prototypes
 ******************************************************************************/

/*******************************************************************************
 * Variables
 ******************************************************************************/

/*******************************************************************************
 * Code
 *******************************************************************************/
const xcvr_lcl_tsm_config_t xcvr_lcl_tsm_generic_config =
{
    /***********************************************/
    /*********** START OF GENERATED CODE ***********/
    /*********** xcvr_lcl_tsm_generic_config *******/
    /***********************************************/
   /* CTRL register value is not modified for RSM operation. */
    /* LPPS_CTRL register value is not modified for RSM operation. */
    .END_OF_SEQ = 0xCDCBBFBD,
    .WU_LATENCY = 0x00090000,
    .RECYCLE_COUNT = 0x002919C9,
    .FAST_CTRL1 = 0x2b802b04,
    .FAST_CTRL2 = 0xC837BB37,
    .FAST_CTRL3 = 0x19001900,
    /* TIMING00 register value is not modified for RSM operation. */
    /* TIMING01 register value is not modified for RSM operation. */
    /* TIMING02 register value is not modified for RSM operation. */
    /* TIMING03 register value is not modified for RSM operation. */
    /* TIMING04 register value is not modified for RSM operation. */
    /* TIMING05 register value is not modified for RSM operation. */
    /* TIMING06 register value is not modified for RSM operation. */
    /* TIMING07 register value is not modified for RSM operation. */
    /* TIMING08 register value is not modified for RSM operation. */
    .TIMING09 = 0xFFFFFFFF,
    .TIMING10 = 0x11081108,
    .TIMING11 = 0xCC1ABE1A,
    .TIMING12 = 0xCC22BE22,
    .TIMING13 = 0xFFFFFFFF,
    .TIMING14 = 0x0000BEBB,
    .TIMING15 = 0xCCCABEBC,
    .TIMING16 = 0xCAC90000,
    .TIMING17 = 0xCCC90000,
    .TIMING18 = 0xCCC90000,
    .TIMING19 = 0x11061106,
    .TIMING20 = 0x11001100,
    .TIMING21 = 0x19001900,
    .TIMING22 = 0x19001900,
    .TIMING23 = 0x19001900,
    .TIMING24 = 0xCC00BE00,
    .TIMING25 = 0xCD00BF00,
    .TIMING26 = 0xCD00BF00,
    .TIMING27 = 0xCD00BF00,
    .TIMING28 = 0xCD00BF00,
    .TIMING29 = 0xCD00BF00,
    .TIMING30 = 0xCC2BFFFF,
    .TIMING31 = 0xCC08BE08,
    .TIMING32 = 0x19111911,
    .TIMING33 = 0x2B112B11,
    .TIMING34 = 0xCC11BE11,
    .TIMING35 = 0xCC11BE11,
    .TIMING36 = 0xCC11BE11,
    .TIMING37 = 0xCC11BE11,
    .TIMING38 = 0xCC11BE11,
    .TIMING39 = 0xCC11BE11,
    .TIMING40 = 0xCC11BE11,
    .TIMING41 = 0xCC11BE11,
    .TIMING42 = 0xCC12BE12,
    .TIMING43 = 0xCC12BE12,
    .TIMING44 = 0xCC12FFFF,
    .TIMING45 = 0xCC12BE12,
    .TIMING46 = 0xFFFFBE12,
    .TIMING47 = 0xCC2ABE2A,
    .TIMING48 = 0xCC2BBE2B,
    .TIMING49 = 0xCC2BBE2B,
    .TIMING50 = 0xCC2BFFFF,
    .TIMING51 = 0xCC2BFFFF,
    /* TIMING52 register value is not modified for RSM operation. */
    /* OVRD0 register value is not modified for RSM operation. */
    /* OVRD1 register value is not modified for RSM operation. */
    /* OVRD2 register value is not modified for RSM operation. */
    /* OVRD3 register value is not modified for RSM operation. */

    /***********************************************/
    /************ END OF GENERATED CODE ************/
    /*********** xcvr_lcl_tsm_generic_config **********/
    /***********************************************/
   
};
    
 const xcvr_lcl_rsm_reg_config_t xcvr_lcl_rsm_generic_config =    /*!<  RSM/TSM register configuration for the generic. Meant to overlay after applying the  ::xcvr_lcl_tsm_generic_config settings */
{
    /***********************************************/
    /*********** START OF GENERATED CODE ***********/
    /*********** xcvr_lcl_rsm_generic_config *******/
    /***********************************************/
    .RSM_CTRL0 = 0x050010f0,
    .RSM_CTRL1 = 0x0a31f8e7,
    .RSM_CTRL2 = 0x001c5103,
    .RSM_CTRL3 = 0x00000106,
    .RSM_CTRL4 = 0x005a000a,
    .do_rxdig_rccal = (bool)true,
    /***********************************************/
    /************ END OF GENERATED CODE ************/
    /*********** xcvr_lcl_rsm_generic_config **********/
    /***********************************************/
};

