/*
 * Copyright 2022 NXP
 *
 * NXP Confidential. This software is owned or controlled by NXP and may only
 * be used strictly in accordance with the applicable license terms found at
 * https://www.nxp.com/docs/en/disclaimer/LA_OPT_NXP_SW.html . The standard 
 * license in Section 2.3 is expressly granted for this software.  
 */

#include "lvgl/lvgl.h"
#include <stdio.h>
#include "gui_guider.h"
#include "events_init.h"
#include "custom.h"


void setup_scr_RideInfo2(lv_ui *ui){

	//Write codes RideInfo2
	ui->RideInfo2 = lv_obj_create(NULL);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_main_main_default
	static lv_style_t style_rideinfo2_main_main_default;
	if (style_rideinfo2_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_main_main_default);
	else
		lv_style_init(&style_rideinfo2_main_main_default);
	lv_style_set_bg_color(&style_rideinfo2_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_opa(&style_rideinfo2_main_main_default, 0);
	lv_obj_add_style(ui->RideInfo2, &style_rideinfo2_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);

	//Write codes RideInfo2_bg_img
	ui->RideInfo2_bg_img = lv_img_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_bg_img, 0, 0);
	lv_obj_set_size(ui->RideInfo2_bg_img, 480, 272);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_bg_img_main_main_default
	static lv_style_t style_rideinfo2_bg_img_main_main_default;
	if (style_rideinfo2_bg_img_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_bg_img_main_main_default);
	else
		lv_style_init(&style_rideinfo2_bg_img_main_main_default);
	lv_style_set_img_recolor(&style_rideinfo2_bg_img_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_img_recolor_opa(&style_rideinfo2_bg_img_main_main_default, 0);
	lv_style_set_img_opa(&style_rideinfo2_bg_img_main_main_default, 255);
	lv_obj_add_style(ui->RideInfo2_bg_img, &style_rideinfo2_bg_img_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);
	lv_obj_add_flag(ui->RideInfo2_bg_img, LV_OBJ_FLAG_CLICKABLE);
	lv_img_set_src(ui->RideInfo2_bg_img,&_bg1_480x272);
	lv_img_set_pivot(ui->RideInfo2_bg_img, 0,0);
	lv_img_set_angle(ui->RideInfo2_bg_img, 0);

	//Write codes RideInfo2_hdr_img
	ui->RideInfo2_hdr_img = lv_img_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_hdr_img, 0, 0);
	lv_obj_set_size(ui->RideInfo2_hdr_img, 480, 51);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_hdr_img_main_main_default
	static lv_style_t style_rideinfo2_hdr_img_main_main_default;
	if (style_rideinfo2_hdr_img_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_hdr_img_main_main_default);
	else
		lv_style_init(&style_rideinfo2_hdr_img_main_main_default);
	lv_style_set_img_recolor(&style_rideinfo2_hdr_img_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_img_recolor_opa(&style_rideinfo2_hdr_img_main_main_default, 0);
	lv_style_set_img_opa(&style_rideinfo2_hdr_img_main_main_default, 255);
	lv_obj_add_style(ui->RideInfo2_hdr_img, &style_rideinfo2_hdr_img_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);
	lv_obj_add_flag(ui->RideInfo2_hdr_img, LV_OBJ_FLAG_CLICKABLE);
	lv_img_set_src(ui->RideInfo2_hdr_img,&_ebike_header_bg_480x51);
	lv_img_set_pivot(ui->RideInfo2_hdr_img, 0,0);
	lv_img_set_angle(ui->RideInfo2_hdr_img, 0);

	//Write codes RideInfo2_date_label
	ui->RideInfo2_date_label = lv_label_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_date_label, 20, 5);
	lv_obj_set_size(ui->RideInfo2_date_label, 100, 32);
	lv_label_set_text(ui->RideInfo2_date_label, "May 5, 2022");
	lv_label_set_long_mode(ui->RideInfo2_date_label, LV_LABEL_LONG_WRAP);
	lv_obj_set_style_text_align(ui->RideInfo2_date_label, LV_TEXT_ALIGN_LEFT, 0);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_date_label_main_main_default
	static lv_style_t style_rideinfo2_date_label_main_main_default;
	if (style_rideinfo2_date_label_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_date_label_main_main_default);
	else
		lv_style_init(&style_rideinfo2_date_label_main_main_default);
	lv_style_set_radius(&style_rideinfo2_date_label_main_main_default, 0);
	lv_style_set_bg_color(&style_rideinfo2_date_label_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_rideinfo2_date_label_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_rideinfo2_date_label_main_main_default, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_rideinfo2_date_label_main_main_default, 0);
	lv_style_set_text_color(&style_rideinfo2_date_label_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_text_font(&style_rideinfo2_date_label_main_main_default, &lv_font_montserratMedium_12);
	lv_style_set_text_letter_space(&style_rideinfo2_date_label_main_main_default, 1);
	lv_style_set_pad_left(&style_rideinfo2_date_label_main_main_default, 0);
	lv_style_set_pad_right(&style_rideinfo2_date_label_main_main_default, 0);
	lv_style_set_pad_top(&style_rideinfo2_date_label_main_main_default, 0);
	lv_style_set_pad_bottom(&style_rideinfo2_date_label_main_main_default, 0);
	lv_obj_add_style(ui->RideInfo2_date_label, &style_rideinfo2_date_label_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);

	//Write codes RideInfo2_time_label
	ui->RideInfo2_time_label = lv_label_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_time_label, 360, 5);
	lv_obj_set_size(ui->RideInfo2_time_label, 100, 32);
	lv_label_set_text(ui->RideInfo2_time_label, "10:28 AM");
	lv_label_set_long_mode(ui->RideInfo2_time_label, LV_LABEL_LONG_WRAP);
	lv_obj_set_style_text_align(ui->RideInfo2_time_label, LV_TEXT_ALIGN_RIGHT, 0);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_time_label_main_main_default
	static lv_style_t style_rideinfo2_time_label_main_main_default;
	if (style_rideinfo2_time_label_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_time_label_main_main_default);
	else
		lv_style_init(&style_rideinfo2_time_label_main_main_default);
	lv_style_set_radius(&style_rideinfo2_time_label_main_main_default, 0);
	lv_style_set_bg_color(&style_rideinfo2_time_label_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_rideinfo2_time_label_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_rideinfo2_time_label_main_main_default, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_rideinfo2_time_label_main_main_default, 0);
	lv_style_set_text_color(&style_rideinfo2_time_label_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_text_font(&style_rideinfo2_time_label_main_main_default, &lv_font_montserratMedium_12);
	lv_style_set_text_letter_space(&style_rideinfo2_time_label_main_main_default, 1);
	lv_style_set_pad_left(&style_rideinfo2_time_label_main_main_default, 0);
	lv_style_set_pad_right(&style_rideinfo2_time_label_main_main_default, 0);
	lv_style_set_pad_top(&style_rideinfo2_time_label_main_main_default, 0);
	lv_style_set_pad_bottom(&style_rideinfo2_time_label_main_main_default, 0);
	lv_obj_add_style(ui->RideInfo2_time_label, &style_rideinfo2_time_label_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);

	//Write codes RideInfo2_sub_label
	ui->RideInfo2_sub_label = lv_label_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_sub_label, 160, 5);
	lv_obj_set_size(ui->RideInfo2_sub_label, 180, 32);
	lv_label_set_text(ui->RideInfo2_sub_label, "RIDE DETAILS");
	lv_label_set_long_mode(ui->RideInfo2_sub_label, LV_LABEL_LONG_WRAP);
	lv_obj_set_style_text_align(ui->RideInfo2_sub_label, LV_TEXT_ALIGN_LEFT, 0);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_sub_label_main_main_default
	static lv_style_t style_rideinfo2_sub_label_main_main_default;
	if (style_rideinfo2_sub_label_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_sub_label_main_main_default);
	else
		lv_style_init(&style_rideinfo2_sub_label_main_main_default);
	lv_style_set_radius(&style_rideinfo2_sub_label_main_main_default, 0);
	lv_style_set_bg_color(&style_rideinfo2_sub_label_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_rideinfo2_sub_label_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_rideinfo2_sub_label_main_main_default, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_rideinfo2_sub_label_main_main_default, 0);
	lv_style_set_text_color(&style_rideinfo2_sub_label_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_text_font(&style_rideinfo2_sub_label_main_main_default, &lv_font_montserratMedium_20);
	lv_style_set_text_letter_space(&style_rideinfo2_sub_label_main_main_default, 1);
	lv_style_set_pad_left(&style_rideinfo2_sub_label_main_main_default, 0);
	lv_style_set_pad_right(&style_rideinfo2_sub_label_main_main_default, 0);
	lv_style_set_pad_top(&style_rideinfo2_sub_label_main_main_default, 0);
	lv_style_set_pad_bottom(&style_rideinfo2_sub_label_main_main_default, 0);
	lv_obj_add_style(ui->RideInfo2_sub_label, &style_rideinfo2_sub_label_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);

	//Write codes RideInfo2_gps_icon
	ui->RideInfo2_gps_icon = lv_img_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_gps_icon, 274, 50);
	lv_obj_set_size(ui->RideInfo2_gps_icon, 28, 48);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_gps_icon_main_main_default
	static lv_style_t style_rideinfo2_gps_icon_main_main_default;
	if (style_rideinfo2_gps_icon_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_gps_icon_main_main_default);
	else
		lv_style_init(&style_rideinfo2_gps_icon_main_main_default);
	lv_style_set_img_recolor(&style_rideinfo2_gps_icon_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_img_recolor_opa(&style_rideinfo2_gps_icon_main_main_default, 0);
	lv_style_set_img_opa(&style_rideinfo2_gps_icon_main_main_default, 255);
	lv_obj_add_style(ui->RideInfo2_gps_icon, &style_rideinfo2_gps_icon_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);
	lv_obj_add_flag(ui->RideInfo2_gps_icon, LV_OBJ_FLAG_CLICKABLE);
	lv_img_set_src(ui->RideInfo2_gps_icon,&_ebike_gps_arrow_1_28x48);
	lv_img_set_pivot(ui->RideInfo2_gps_icon, 0,0);
	lv_img_set_angle(ui->RideInfo2_gps_icon, 0);

	//Write codes RideInfo2_calories_icon
	ui->RideInfo2_calories_icon = lv_img_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_calories_icon, 244, 120);
	lv_obj_set_size(ui->RideInfo2_calories_icon, 21, 14);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_calories_icon_main_main_default
	static lv_style_t style_rideinfo2_calories_icon_main_main_default;
	if (style_rideinfo2_calories_icon_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_calories_icon_main_main_default);
	else
		lv_style_init(&style_rideinfo2_calories_icon_main_main_default);
	lv_style_set_img_recolor(&style_rideinfo2_calories_icon_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_img_recolor_opa(&style_rideinfo2_calories_icon_main_main_default, 0);
	lv_style_set_img_opa(&style_rideinfo2_calories_icon_main_main_default, 255);
	lv_obj_add_style(ui->RideInfo2_calories_icon, &style_rideinfo2_calories_icon_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);
	lv_obj_add_flag(ui->RideInfo2_calories_icon, LV_OBJ_FLAG_CLICKABLE);
	lv_img_set_src(ui->RideInfo2_calories_icon,&_ebike_icn_calories_burned_21x14);
	lv_img_set_pivot(ui->RideInfo2_calories_icon, 0,0);
	lv_img_set_angle(ui->RideInfo2_calories_icon, 0);

	//Write codes RideInfo2_hr_icon
	ui->RideInfo2_hr_icon = lv_img_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_hr_icon, 360, 120);
	lv_obj_set_size(ui->RideInfo2_hr_icon, 23, 17);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_hr_icon_main_main_default
	static lv_style_t style_rideinfo2_hr_icon_main_main_default;
	if (style_rideinfo2_hr_icon_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_hr_icon_main_main_default);
	else
		lv_style_init(&style_rideinfo2_hr_icon_main_main_default);
	lv_style_set_img_recolor(&style_rideinfo2_hr_icon_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_img_recolor_opa(&style_rideinfo2_hr_icon_main_main_default, 0);
	lv_style_set_img_opa(&style_rideinfo2_hr_icon_main_main_default, 255);
	lv_obj_add_style(ui->RideInfo2_hr_icon, &style_rideinfo2_hr_icon_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);
	lv_obj_add_flag(ui->RideInfo2_hr_icon, LV_OBJ_FLAG_CLICKABLE);
	lv_img_set_src(ui->RideInfo2_hr_icon,&_ebike_icn_heart_rate_23x17);
	lv_img_set_pivot(ui->RideInfo2_hr_icon, 0,0);
	lv_img_set_angle(ui->RideInfo2_hr_icon, 0);

	//Write codes RideInfo2_cadence_icon
	ui->RideInfo2_cadence_icon = lv_img_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_cadence_icon, 244, 183);
	lv_obj_set_size(ui->RideInfo2_cadence_icon, 20, 20);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_cadence_icon_main_main_default
	static lv_style_t style_rideinfo2_cadence_icon_main_main_default;
	if (style_rideinfo2_cadence_icon_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_cadence_icon_main_main_default);
	else
		lv_style_init(&style_rideinfo2_cadence_icon_main_main_default);
	lv_style_set_img_recolor(&style_rideinfo2_cadence_icon_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_img_recolor_opa(&style_rideinfo2_cadence_icon_main_main_default, 0);
	lv_style_set_img_opa(&style_rideinfo2_cadence_icon_main_main_default, 255);
	lv_obj_add_style(ui->RideInfo2_cadence_icon, &style_rideinfo2_cadence_icon_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);
	lv_obj_add_flag(ui->RideInfo2_cadence_icon, LV_OBJ_FLAG_CLICKABLE);
	lv_img_set_src(ui->RideInfo2_cadence_icon,&_ebike_icn_round_per_minute_20x20);
	lv_img_set_pivot(ui->RideInfo2_cadence_icon, 0,0);
	lv_img_set_angle(ui->RideInfo2_cadence_icon, 0);

	//Write codes RideInfo2_elapsed_icon
	ui->RideInfo2_elapsed_icon = lv_img_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_elapsed_icon, 360, 183);
	lv_obj_set_size(ui->RideInfo2_elapsed_icon, 20, 25);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_elapsed_icon_main_main_default
	static lv_style_t style_rideinfo2_elapsed_icon_main_main_default;
	if (style_rideinfo2_elapsed_icon_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_elapsed_icon_main_main_default);
	else
		lv_style_init(&style_rideinfo2_elapsed_icon_main_main_default);
	lv_style_set_img_recolor(&style_rideinfo2_elapsed_icon_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_img_recolor_opa(&style_rideinfo2_elapsed_icon_main_main_default, 0);
	lv_style_set_img_opa(&style_rideinfo2_elapsed_icon_main_main_default, 255);
	lv_obj_add_style(ui->RideInfo2_elapsed_icon, &style_rideinfo2_elapsed_icon_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);
	lv_obj_add_flag(ui->RideInfo2_elapsed_icon, LV_OBJ_FLAG_CLICKABLE);
	lv_img_set_src(ui->RideInfo2_elapsed_icon,&_ebike_icn_elapsed_time_2_20x25);
	lv_img_set_pivot(ui->RideInfo2_elapsed_icon, 0,0);
	lv_img_set_angle(ui->RideInfo2_elapsed_icon, 0);

	//Write codes RideInfo2_dist_label
	ui->RideInfo2_dist_label = lv_label_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_dist_label, 320, 45);
	lv_obj_set_size(ui->RideInfo2_dist_label, 100, 32);
	lv_label_set_text(ui->RideInfo2_dist_label, "3.1 KM");
	lv_label_set_long_mode(ui->RideInfo2_dist_label, LV_LABEL_LONG_WRAP);
	lv_obj_set_style_text_align(ui->RideInfo2_dist_label, LV_TEXT_ALIGN_LEFT, 0);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_dist_label_main_main_default
	static lv_style_t style_rideinfo2_dist_label_main_main_default;
	if (style_rideinfo2_dist_label_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_dist_label_main_main_default);
	else
		lv_style_init(&style_rideinfo2_dist_label_main_main_default);
	lv_style_set_radius(&style_rideinfo2_dist_label_main_main_default, 0);
	lv_style_set_bg_color(&style_rideinfo2_dist_label_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_rideinfo2_dist_label_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_rideinfo2_dist_label_main_main_default, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_rideinfo2_dist_label_main_main_default, 0);
	lv_style_set_text_color(&style_rideinfo2_dist_label_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_text_font(&style_rideinfo2_dist_label_main_main_default, &lv_font_montserratMedium_28);
	lv_style_set_text_letter_space(&style_rideinfo2_dist_label_main_main_default, 1);
	lv_style_set_pad_left(&style_rideinfo2_dist_label_main_main_default, 0);
	lv_style_set_pad_right(&style_rideinfo2_dist_label_main_main_default, 0);
	lv_style_set_pad_top(&style_rideinfo2_dist_label_main_main_default, 0);
	lv_style_set_pad_bottom(&style_rideinfo2_dist_label_main_main_default, 0);
	lv_obj_add_style(ui->RideInfo2_dist_label, &style_rideinfo2_dist_label_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);

	//Write codes RideInfo2_dir_label
	ui->RideInfo2_dir_label = lv_label_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_dir_label, 320, 73);
	lv_obj_set_size(ui->RideInfo2_dir_label, 100, 32);
	lv_label_set_text(ui->RideInfo2_dir_label, "Turn right to");
	lv_label_set_long_mode(ui->RideInfo2_dir_label, LV_LABEL_LONG_WRAP);
	lv_obj_set_style_text_align(ui->RideInfo2_dir_label, LV_TEXT_ALIGN_LEFT, 0);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_dir_label_main_main_default
	static lv_style_t style_rideinfo2_dir_label_main_main_default;
	if (style_rideinfo2_dir_label_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_dir_label_main_main_default);
	else
		lv_style_init(&style_rideinfo2_dir_label_main_main_default);
	lv_style_set_radius(&style_rideinfo2_dir_label_main_main_default, 0);
	lv_style_set_bg_color(&style_rideinfo2_dir_label_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_rideinfo2_dir_label_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_rideinfo2_dir_label_main_main_default, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_rideinfo2_dir_label_main_main_default, 0);
	lv_style_set_text_color(&style_rideinfo2_dir_label_main_main_default, lv_color_make(0x9e, 0x9e, 0x9e));
	lv_style_set_text_font(&style_rideinfo2_dir_label_main_main_default, &lv_font_montserratMedium_12);
	lv_style_set_text_letter_space(&style_rideinfo2_dir_label_main_main_default, 0);
	lv_style_set_pad_left(&style_rideinfo2_dir_label_main_main_default, 0);
	lv_style_set_pad_right(&style_rideinfo2_dir_label_main_main_default, 0);
	lv_style_set_pad_top(&style_rideinfo2_dir_label_main_main_default, 0);
	lv_style_set_pad_bottom(&style_rideinfo2_dir_label_main_main_default, 0);
	lv_obj_add_style(ui->RideInfo2_dir_label, &style_rideinfo2_dir_label_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);

	//Write codes RideInfo2_str_label
	ui->RideInfo2_str_label = lv_label_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_str_label, 320, 87);
	lv_obj_set_size(ui->RideInfo2_str_label, 120, 32);
	lv_label_set_text(ui->RideInfo2_str_label, "Ed Bluestein Blvd");
	lv_label_set_long_mode(ui->RideInfo2_str_label, LV_LABEL_LONG_WRAP);
	lv_obj_set_style_text_align(ui->RideInfo2_str_label, LV_TEXT_ALIGN_LEFT, 0);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_str_label_main_main_default
	static lv_style_t style_rideinfo2_str_label_main_main_default;
	if (style_rideinfo2_str_label_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_str_label_main_main_default);
	else
		lv_style_init(&style_rideinfo2_str_label_main_main_default);
	lv_style_set_radius(&style_rideinfo2_str_label_main_main_default, 0);
	lv_style_set_bg_color(&style_rideinfo2_str_label_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_rideinfo2_str_label_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_rideinfo2_str_label_main_main_default, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_rideinfo2_str_label_main_main_default, 0);
	lv_style_set_text_color(&style_rideinfo2_str_label_main_main_default, lv_color_make(0xcc, 0xcc, 0xcc));
	lv_style_set_text_font(&style_rideinfo2_str_label_main_main_default, &lv_font_montserratMedium_12);
	lv_style_set_text_letter_space(&style_rideinfo2_str_label_main_main_default, 0);
	lv_style_set_pad_left(&style_rideinfo2_str_label_main_main_default, 0);
	lv_style_set_pad_right(&style_rideinfo2_str_label_main_main_default, 0);
	lv_style_set_pad_top(&style_rideinfo2_str_label_main_main_default, 0);
	lv_style_set_pad_bottom(&style_rideinfo2_str_label_main_main_default, 0);
	lv_obj_add_style(ui->RideInfo2_str_label, &style_rideinfo2_str_label_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);

	//Write codes RideInfo2_info1_label_1
	ui->RideInfo2_info1_label_1 = lv_label_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_info1_label_1, 274, 116);
	lv_obj_set_size(ui->RideInfo2_info1_label_1, 60, 32);
	lv_label_set_text(ui->RideInfo2_info1_label_1, "Calories");
	lv_label_set_long_mode(ui->RideInfo2_info1_label_1, LV_LABEL_LONG_WRAP);
	lv_obj_set_style_text_align(ui->RideInfo2_info1_label_1, LV_TEXT_ALIGN_LEFT, 0);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_info1_label_1_main_main_default
	static lv_style_t style_rideinfo2_info1_label_1_main_main_default;
	if (style_rideinfo2_info1_label_1_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_info1_label_1_main_main_default);
	else
		lv_style_init(&style_rideinfo2_info1_label_1_main_main_default);
	lv_style_set_radius(&style_rideinfo2_info1_label_1_main_main_default, 0);
	lv_style_set_bg_color(&style_rideinfo2_info1_label_1_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_rideinfo2_info1_label_1_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_rideinfo2_info1_label_1_main_main_default, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_rideinfo2_info1_label_1_main_main_default, 0);
	lv_style_set_text_color(&style_rideinfo2_info1_label_1_main_main_default, lv_color_make(0x9e, 0x9e, 0x9e));
	lv_style_set_text_font(&style_rideinfo2_info1_label_1_main_main_default, &lv_font_montserratMedium_12);
	lv_style_set_text_letter_space(&style_rideinfo2_info1_label_1_main_main_default, 0);
	lv_style_set_pad_left(&style_rideinfo2_info1_label_1_main_main_default, 0);
	lv_style_set_pad_right(&style_rideinfo2_info1_label_1_main_main_default, 0);
	lv_style_set_pad_top(&style_rideinfo2_info1_label_1_main_main_default, 0);
	lv_style_set_pad_bottom(&style_rideinfo2_info1_label_1_main_main_default, 0);
	lv_obj_add_style(ui->RideInfo2_info1_label_1, &style_rideinfo2_info1_label_1_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);

	//Write codes RideInfo2_info1_label_2
	ui->RideInfo2_info1_label_2 = lv_label_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_info1_label_2, 274, 128);
	lv_obj_set_size(ui->RideInfo2_info1_label_2, 60, 32);
	lv_label_set_text(ui->RideInfo2_info1_label_2, "Burned");
	lv_label_set_long_mode(ui->RideInfo2_info1_label_2, LV_LABEL_LONG_WRAP);
	lv_obj_set_style_text_align(ui->RideInfo2_info1_label_2, LV_TEXT_ALIGN_LEFT, 0);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_info1_label_2_main_main_default
	static lv_style_t style_rideinfo2_info1_label_2_main_main_default;
	if (style_rideinfo2_info1_label_2_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_info1_label_2_main_main_default);
	else
		lv_style_init(&style_rideinfo2_info1_label_2_main_main_default);
	lv_style_set_radius(&style_rideinfo2_info1_label_2_main_main_default, 0);
	lv_style_set_bg_color(&style_rideinfo2_info1_label_2_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_rideinfo2_info1_label_2_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_rideinfo2_info1_label_2_main_main_default, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_rideinfo2_info1_label_2_main_main_default, 0);
	lv_style_set_text_color(&style_rideinfo2_info1_label_2_main_main_default, lv_color_make(0x9e, 0x9e, 0x9e));
	lv_style_set_text_font(&style_rideinfo2_info1_label_2_main_main_default, &lv_font_montserratMedium_12);
	lv_style_set_text_letter_space(&style_rideinfo2_info1_label_2_main_main_default, 0);
	lv_style_set_pad_left(&style_rideinfo2_info1_label_2_main_main_default, 0);
	lv_style_set_pad_right(&style_rideinfo2_info1_label_2_main_main_default, 0);
	lv_style_set_pad_top(&style_rideinfo2_info1_label_2_main_main_default, 0);
	lv_style_set_pad_bottom(&style_rideinfo2_info1_label_2_main_main_default, 0);
	lv_obj_add_style(ui->RideInfo2_info1_label_2, &style_rideinfo2_info1_label_2_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);

	//Write codes RideInfo2_info2_label_1
	ui->RideInfo2_info2_label_1 = lv_label_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_info2_label_1, 394, 116);
	lv_obj_set_size(ui->RideInfo2_info2_label_1, 60, 32);
	lv_label_set_text(ui->RideInfo2_info2_label_1, "Heart");
	lv_label_set_long_mode(ui->RideInfo2_info2_label_1, LV_LABEL_LONG_WRAP);
	lv_obj_set_style_text_align(ui->RideInfo2_info2_label_1, LV_TEXT_ALIGN_LEFT, 0);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_info2_label_1_main_main_default
	static lv_style_t style_rideinfo2_info2_label_1_main_main_default;
	if (style_rideinfo2_info2_label_1_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_info2_label_1_main_main_default);
	else
		lv_style_init(&style_rideinfo2_info2_label_1_main_main_default);
	lv_style_set_radius(&style_rideinfo2_info2_label_1_main_main_default, 0);
	lv_style_set_bg_color(&style_rideinfo2_info2_label_1_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_rideinfo2_info2_label_1_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_rideinfo2_info2_label_1_main_main_default, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_rideinfo2_info2_label_1_main_main_default, 0);
	lv_style_set_text_color(&style_rideinfo2_info2_label_1_main_main_default, lv_color_make(0x9e, 0x9e, 0x9e));
	lv_style_set_text_font(&style_rideinfo2_info2_label_1_main_main_default, &lv_font_montserratMedium_12);
	lv_style_set_text_letter_space(&style_rideinfo2_info2_label_1_main_main_default, 0);
	lv_style_set_pad_left(&style_rideinfo2_info2_label_1_main_main_default, 0);
	lv_style_set_pad_right(&style_rideinfo2_info2_label_1_main_main_default, 0);
	lv_style_set_pad_top(&style_rideinfo2_info2_label_1_main_main_default, 0);
	lv_style_set_pad_bottom(&style_rideinfo2_info2_label_1_main_main_default, 0);
	lv_obj_add_style(ui->RideInfo2_info2_label_1, &style_rideinfo2_info2_label_1_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);

	//Write codes RideInfo2_info2_label_2
	ui->RideInfo2_info2_label_2 = lv_label_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_info2_label_2, 394, 128);
	lv_obj_set_size(ui->RideInfo2_info2_label_2, 60, 32);
	lv_label_set_text(ui->RideInfo2_info2_label_2, "Rate");
	lv_label_set_long_mode(ui->RideInfo2_info2_label_2, LV_LABEL_LONG_WRAP);
	lv_obj_set_style_text_align(ui->RideInfo2_info2_label_2, LV_TEXT_ALIGN_LEFT, 0);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_info2_label_2_main_main_default
	static lv_style_t style_rideinfo2_info2_label_2_main_main_default;
	if (style_rideinfo2_info2_label_2_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_info2_label_2_main_main_default);
	else
		lv_style_init(&style_rideinfo2_info2_label_2_main_main_default);
	lv_style_set_radius(&style_rideinfo2_info2_label_2_main_main_default, 0);
	lv_style_set_bg_color(&style_rideinfo2_info2_label_2_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_rideinfo2_info2_label_2_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_rideinfo2_info2_label_2_main_main_default, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_rideinfo2_info2_label_2_main_main_default, 0);
	lv_style_set_text_color(&style_rideinfo2_info2_label_2_main_main_default, lv_color_make(0x9e, 0x9e, 0x9e));
	lv_style_set_text_font(&style_rideinfo2_info2_label_2_main_main_default, &lv_font_montserratMedium_12);
	lv_style_set_text_letter_space(&style_rideinfo2_info2_label_2_main_main_default, 0);
	lv_style_set_pad_left(&style_rideinfo2_info2_label_2_main_main_default, 0);
	lv_style_set_pad_right(&style_rideinfo2_info2_label_2_main_main_default, 0);
	lv_style_set_pad_top(&style_rideinfo2_info2_label_2_main_main_default, 0);
	lv_style_set_pad_bottom(&style_rideinfo2_info2_label_2_main_main_default, 0);
	lv_obj_add_style(ui->RideInfo2_info2_label_2, &style_rideinfo2_info2_label_2_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);

	//Write codes RideInfo2_info3_label_1
	ui->RideInfo2_info3_label_1 = lv_label_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_info3_label_1, 274, 178);
	lv_obj_set_size(ui->RideInfo2_info3_label_1, 80, 32);
	lv_label_set_text(ui->RideInfo2_info3_label_1, "Cadence");
	lv_label_set_long_mode(ui->RideInfo2_info3_label_1, LV_LABEL_LONG_WRAP);
	lv_obj_set_style_text_align(ui->RideInfo2_info3_label_1, LV_TEXT_ALIGN_LEFT, 0);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_info3_label_1_main_main_default
	static lv_style_t style_rideinfo2_info3_label_1_main_main_default;
	if (style_rideinfo2_info3_label_1_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_info3_label_1_main_main_default);
	else
		lv_style_init(&style_rideinfo2_info3_label_1_main_main_default);
	lv_style_set_radius(&style_rideinfo2_info3_label_1_main_main_default, 0);
	lv_style_set_bg_color(&style_rideinfo2_info3_label_1_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_rideinfo2_info3_label_1_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_rideinfo2_info3_label_1_main_main_default, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_rideinfo2_info3_label_1_main_main_default, 0);
	lv_style_set_text_color(&style_rideinfo2_info3_label_1_main_main_default, lv_color_make(0x9e, 0x9e, 0x9e));
	lv_style_set_text_font(&style_rideinfo2_info3_label_1_main_main_default, &lv_font_montserratMedium_12);
	lv_style_set_text_letter_space(&style_rideinfo2_info3_label_1_main_main_default, 0);
	lv_style_set_pad_left(&style_rideinfo2_info3_label_1_main_main_default, 0);
	lv_style_set_pad_right(&style_rideinfo2_info3_label_1_main_main_default, 0);
	lv_style_set_pad_top(&style_rideinfo2_info3_label_1_main_main_default, 0);
	lv_style_set_pad_bottom(&style_rideinfo2_info3_label_1_main_main_default, 0);
	lv_obj_add_style(ui->RideInfo2_info3_label_1, &style_rideinfo2_info3_label_1_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);

	//Write codes RideInfo2_linfo4_label_1
	ui->RideInfo2_linfo4_label_1 = lv_label_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_linfo4_label_1, 394, 178);
	lv_obj_set_size(ui->RideInfo2_linfo4_label_1, 60, 32);
	lv_label_set_text(ui->RideInfo2_linfo4_label_1, "Elapsed");
	lv_label_set_long_mode(ui->RideInfo2_linfo4_label_1, LV_LABEL_LONG_WRAP);
	lv_obj_set_style_text_align(ui->RideInfo2_linfo4_label_1, LV_TEXT_ALIGN_LEFT, 0);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_linfo4_label_1_main_main_default
	static lv_style_t style_rideinfo2_linfo4_label_1_main_main_default;
	if (style_rideinfo2_linfo4_label_1_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_linfo4_label_1_main_main_default);
	else
		lv_style_init(&style_rideinfo2_linfo4_label_1_main_main_default);
	lv_style_set_radius(&style_rideinfo2_linfo4_label_1_main_main_default, 0);
	lv_style_set_bg_color(&style_rideinfo2_linfo4_label_1_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_rideinfo2_linfo4_label_1_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_rideinfo2_linfo4_label_1_main_main_default, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_rideinfo2_linfo4_label_1_main_main_default, 0);
	lv_style_set_text_color(&style_rideinfo2_linfo4_label_1_main_main_default, lv_color_make(0x9e, 0x9e, 0x9e));
	lv_style_set_text_font(&style_rideinfo2_linfo4_label_1_main_main_default, &lv_font_montserratMedium_12);
	lv_style_set_text_letter_space(&style_rideinfo2_linfo4_label_1_main_main_default, 0);
	lv_style_set_pad_left(&style_rideinfo2_linfo4_label_1_main_main_default, 0);
	lv_style_set_pad_right(&style_rideinfo2_linfo4_label_1_main_main_default, 0);
	lv_style_set_pad_top(&style_rideinfo2_linfo4_label_1_main_main_default, 0);
	lv_style_set_pad_bottom(&style_rideinfo2_linfo4_label_1_main_main_default, 0);
	lv_obj_add_style(ui->RideInfo2_linfo4_label_1, &style_rideinfo2_linfo4_label_1_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);

	//Write codes RideInfo2_linfo4_label_2
	ui->RideInfo2_linfo4_label_2 = lv_label_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_linfo4_label_2, 394, 190);
	lv_obj_set_size(ui->RideInfo2_linfo4_label_2, 60, 32);
	lv_label_set_text(ui->RideInfo2_linfo4_label_2, "Time");
	lv_label_set_long_mode(ui->RideInfo2_linfo4_label_2, LV_LABEL_LONG_WRAP);
	lv_obj_set_style_text_align(ui->RideInfo2_linfo4_label_2, LV_TEXT_ALIGN_LEFT, 0);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_linfo4_label_2_main_main_default
	static lv_style_t style_rideinfo2_linfo4_label_2_main_main_default;
	if (style_rideinfo2_linfo4_label_2_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_linfo4_label_2_main_main_default);
	else
		lv_style_init(&style_rideinfo2_linfo4_label_2_main_main_default);
	lv_style_set_radius(&style_rideinfo2_linfo4_label_2_main_main_default, 0);
	lv_style_set_bg_color(&style_rideinfo2_linfo4_label_2_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_rideinfo2_linfo4_label_2_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_rideinfo2_linfo4_label_2_main_main_default, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_rideinfo2_linfo4_label_2_main_main_default, 0);
	lv_style_set_text_color(&style_rideinfo2_linfo4_label_2_main_main_default, lv_color_make(0x9e, 0x9e, 0x9e));
	lv_style_set_text_font(&style_rideinfo2_linfo4_label_2_main_main_default, &lv_font_montserratMedium_12);
	lv_style_set_text_letter_space(&style_rideinfo2_linfo4_label_2_main_main_default, 0);
	lv_style_set_pad_left(&style_rideinfo2_linfo4_label_2_main_main_default, 0);
	lv_style_set_pad_right(&style_rideinfo2_linfo4_label_2_main_main_default, 0);
	lv_style_set_pad_top(&style_rideinfo2_linfo4_label_2_main_main_default, 0);
	lv_style_set_pad_bottom(&style_rideinfo2_linfo4_label_2_main_main_default, 0);
	lv_obj_add_style(ui->RideInfo2_linfo4_label_2, &style_rideinfo2_linfo4_label_2_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);

	//Write codes RideInfo2_info1_label_3
	ui->RideInfo2_info1_label_3 = lv_label_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_info1_label_3, 244, 145);
	lv_obj_set_size(ui->RideInfo2_info1_label_3, 50, 32);
	lv_label_set_text(ui->RideInfo2_info1_label_3, "462");
	lv_label_set_long_mode(ui->RideInfo2_info1_label_3, LV_LABEL_LONG_WRAP);
	lv_obj_set_style_text_align(ui->RideInfo2_info1_label_3, LV_TEXT_ALIGN_LEFT, 0);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_info1_label_3_main_main_default
	static lv_style_t style_rideinfo2_info1_label_3_main_main_default;
	if (style_rideinfo2_info1_label_3_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_info1_label_3_main_main_default);
	else
		lv_style_init(&style_rideinfo2_info1_label_3_main_main_default);
	lv_style_set_radius(&style_rideinfo2_info1_label_3_main_main_default, 0);
	lv_style_set_bg_color(&style_rideinfo2_info1_label_3_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_rideinfo2_info1_label_3_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_rideinfo2_info1_label_3_main_main_default, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_rideinfo2_info1_label_3_main_main_default, 0);
	lv_style_set_text_color(&style_rideinfo2_info1_label_3_main_main_default, lv_color_make(0x00, 0x80, 0xff));
	lv_style_set_text_font(&style_rideinfo2_info1_label_3_main_main_default, &lv_font_montserratMedium_20);
	lv_style_set_text_letter_space(&style_rideinfo2_info1_label_3_main_main_default, 0);
	lv_style_set_pad_left(&style_rideinfo2_info1_label_3_main_main_default, 0);
	lv_style_set_pad_right(&style_rideinfo2_info1_label_3_main_main_default, 0);
	lv_style_set_pad_top(&style_rideinfo2_info1_label_3_main_main_default, 0);
	lv_style_set_pad_bottom(&style_rideinfo2_info1_label_3_main_main_default, 0);
	lv_obj_add_style(ui->RideInfo2_info1_label_3, &style_rideinfo2_info1_label_3_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);

	//Write codes RideInfo2_info2_label_3
	ui->RideInfo2_info2_label_3 = lv_label_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_info2_label_3, 360, 145);
	lv_obj_set_size(ui->RideInfo2_info2_label_3, 50, 32);
	lv_label_set_text(ui->RideInfo2_info2_label_3, "118");
	lv_label_set_long_mode(ui->RideInfo2_info2_label_3, LV_LABEL_LONG_WRAP);
	lv_obj_set_style_text_align(ui->RideInfo2_info2_label_3, LV_TEXT_ALIGN_LEFT, 0);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_info2_label_3_main_main_default
	static lv_style_t style_rideinfo2_info2_label_3_main_main_default;
	if (style_rideinfo2_info2_label_3_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_info2_label_3_main_main_default);
	else
		lv_style_init(&style_rideinfo2_info2_label_3_main_main_default);
	lv_style_set_radius(&style_rideinfo2_info2_label_3_main_main_default, 0);
	lv_style_set_bg_color(&style_rideinfo2_info2_label_3_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_rideinfo2_info2_label_3_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_rideinfo2_info2_label_3_main_main_default, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_rideinfo2_info2_label_3_main_main_default, 0);
	lv_style_set_text_color(&style_rideinfo2_info2_label_3_main_main_default, lv_color_make(0x00, 0x80, 0xff));
	lv_style_set_text_font(&style_rideinfo2_info2_label_3_main_main_default, &lv_font_montserratMedium_20);
	lv_style_set_text_letter_space(&style_rideinfo2_info2_label_3_main_main_default, 0);
	lv_style_set_pad_left(&style_rideinfo2_info2_label_3_main_main_default, 0);
	lv_style_set_pad_right(&style_rideinfo2_info2_label_3_main_main_default, 0);
	lv_style_set_pad_top(&style_rideinfo2_info2_label_3_main_main_default, 0);
	lv_style_set_pad_bottom(&style_rideinfo2_info2_label_3_main_main_default, 0);
	lv_obj_add_style(ui->RideInfo2_info2_label_3, &style_rideinfo2_info2_label_3_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);

	//Write codes RideInfo2_info3_label_3
	ui->RideInfo2_info3_label_3 = lv_label_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_info3_label_3, 244, 215);
	lv_obj_set_size(ui->RideInfo2_info3_label_3, 50, 32);
	lv_label_set_text(ui->RideInfo2_info3_label_3, "86");
	lv_label_set_long_mode(ui->RideInfo2_info3_label_3, LV_LABEL_LONG_WRAP);
	lv_obj_set_style_text_align(ui->RideInfo2_info3_label_3, LV_TEXT_ALIGN_LEFT, 0);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_info3_label_3_main_main_default
	static lv_style_t style_rideinfo2_info3_label_3_main_main_default;
	if (style_rideinfo2_info3_label_3_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_info3_label_3_main_main_default);
	else
		lv_style_init(&style_rideinfo2_info3_label_3_main_main_default);
	lv_style_set_radius(&style_rideinfo2_info3_label_3_main_main_default, 0);
	lv_style_set_bg_color(&style_rideinfo2_info3_label_3_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_rideinfo2_info3_label_3_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_rideinfo2_info3_label_3_main_main_default, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_rideinfo2_info3_label_3_main_main_default, 0);
	lv_style_set_text_color(&style_rideinfo2_info3_label_3_main_main_default, lv_color_make(0x00, 0x80, 0xff));
	lv_style_set_text_font(&style_rideinfo2_info3_label_3_main_main_default, &lv_font_montserratMedium_20);
	lv_style_set_text_letter_space(&style_rideinfo2_info3_label_3_main_main_default, 0);
	lv_style_set_pad_left(&style_rideinfo2_info3_label_3_main_main_default, 0);
	lv_style_set_pad_right(&style_rideinfo2_info3_label_3_main_main_default, 0);
	lv_style_set_pad_top(&style_rideinfo2_info3_label_3_main_main_default, 0);
	lv_style_set_pad_bottom(&style_rideinfo2_info3_label_3_main_main_default, 0);
	lv_obj_add_style(ui->RideInfo2_info3_label_3, &style_rideinfo2_info3_label_3_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);

	//Write codes RideInfo2_info4_label_3
	ui->RideInfo2_info4_label_3 = lv_label_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_info4_label_3, 360, 215);
	lv_obj_set_size(ui->RideInfo2_info4_label_3, 100, 32);
	lv_label_set_text(ui->RideInfo2_info4_label_3, "46:28");
	lv_label_set_long_mode(ui->RideInfo2_info4_label_3, LV_LABEL_LONG_WRAP);
	lv_obj_set_style_text_align(ui->RideInfo2_info4_label_3, LV_TEXT_ALIGN_LEFT, 0);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_info4_label_3_main_main_default
	static lv_style_t style_rideinfo2_info4_label_3_main_main_default;
	if (style_rideinfo2_info4_label_3_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_info4_label_3_main_main_default);
	else
		lv_style_init(&style_rideinfo2_info4_label_3_main_main_default);
	lv_style_set_radius(&style_rideinfo2_info4_label_3_main_main_default, 0);
	lv_style_set_bg_color(&style_rideinfo2_info4_label_3_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_rideinfo2_info4_label_3_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_rideinfo2_info4_label_3_main_main_default, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_rideinfo2_info4_label_3_main_main_default, 0);
	lv_style_set_text_color(&style_rideinfo2_info4_label_3_main_main_default, lv_color_make(0x00, 0x80, 0xff));
	lv_style_set_text_font(&style_rideinfo2_info4_label_3_main_main_default, &lv_font_montserratMedium_20);
	lv_style_set_text_letter_space(&style_rideinfo2_info4_label_3_main_main_default, 0);
	lv_style_set_pad_left(&style_rideinfo2_info4_label_3_main_main_default, 0);
	lv_style_set_pad_right(&style_rideinfo2_info4_label_3_main_main_default, 0);
	lv_style_set_pad_top(&style_rideinfo2_info4_label_3_main_main_default, 0);
	lv_style_set_pad_bottom(&style_rideinfo2_info4_label_3_main_main_default, 0);
	lv_obj_add_style(ui->RideInfo2_info4_label_3, &style_rideinfo2_info4_label_3_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);

	//Write codes RideInfo2_info1_label_4
	ui->RideInfo2_info1_label_4 = lv_label_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_info1_label_4, 286, 150);
	lv_obj_set_size(ui->RideInfo2_info1_label_4, 30, 32);
	lv_label_set_text(ui->RideInfo2_info1_label_4, "kcal");
	lv_label_set_long_mode(ui->RideInfo2_info1_label_4, LV_LABEL_LONG_WRAP);
	lv_obj_set_style_text_align(ui->RideInfo2_info1_label_4, LV_TEXT_ALIGN_LEFT, 0);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_info1_label_4_main_main_default
	static lv_style_t style_rideinfo2_info1_label_4_main_main_default;
	if (style_rideinfo2_info1_label_4_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_info1_label_4_main_main_default);
	else
		lv_style_init(&style_rideinfo2_info1_label_4_main_main_default);
	lv_style_set_radius(&style_rideinfo2_info1_label_4_main_main_default, 0);
	lv_style_set_bg_color(&style_rideinfo2_info1_label_4_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_rideinfo2_info1_label_4_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_rideinfo2_info1_label_4_main_main_default, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_rideinfo2_info1_label_4_main_main_default, 0);
	lv_style_set_text_color(&style_rideinfo2_info1_label_4_main_main_default, lv_color_make(0x9e, 0x9e, 0x9e));
	lv_style_set_text_font(&style_rideinfo2_info1_label_4_main_main_default, &lv_font_montserratMedium_12);
	lv_style_set_text_letter_space(&style_rideinfo2_info1_label_4_main_main_default, 0);
	lv_style_set_pad_left(&style_rideinfo2_info1_label_4_main_main_default, 0);
	lv_style_set_pad_right(&style_rideinfo2_info1_label_4_main_main_default, 0);
	lv_style_set_pad_top(&style_rideinfo2_info1_label_4_main_main_default, 0);
	lv_style_set_pad_bottom(&style_rideinfo2_info1_label_4_main_main_default, 0);
	lv_obj_add_style(ui->RideInfo2_info1_label_4, &style_rideinfo2_info1_label_4_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);

	//Write codes RideInfo2_info2_label_4
	ui->RideInfo2_info2_label_4 = lv_label_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_info2_label_4, 402, 150);
	lv_obj_set_size(ui->RideInfo2_info2_label_4, 50, 32);
	lv_label_set_text(ui->RideInfo2_info2_label_4, "BPM");
	lv_label_set_long_mode(ui->RideInfo2_info2_label_4, LV_LABEL_LONG_WRAP);
	lv_obj_set_style_text_align(ui->RideInfo2_info2_label_4, LV_TEXT_ALIGN_LEFT, 0);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_info2_label_4_main_main_default
	static lv_style_t style_rideinfo2_info2_label_4_main_main_default;
	if (style_rideinfo2_info2_label_4_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_info2_label_4_main_main_default);
	else
		lv_style_init(&style_rideinfo2_info2_label_4_main_main_default);
	lv_style_set_radius(&style_rideinfo2_info2_label_4_main_main_default, 0);
	lv_style_set_bg_color(&style_rideinfo2_info2_label_4_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_rideinfo2_info2_label_4_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_rideinfo2_info2_label_4_main_main_default, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_rideinfo2_info2_label_4_main_main_default, 0);
	lv_style_set_text_color(&style_rideinfo2_info2_label_4_main_main_default, lv_color_make(0x9e, 0x9e, 0x9e));
	lv_style_set_text_font(&style_rideinfo2_info2_label_4_main_main_default, &lv_font_montserratMedium_12);
	lv_style_set_text_letter_space(&style_rideinfo2_info2_label_4_main_main_default, 0);
	lv_style_set_pad_left(&style_rideinfo2_info2_label_4_main_main_default, 0);
	lv_style_set_pad_right(&style_rideinfo2_info2_label_4_main_main_default, 0);
	lv_style_set_pad_top(&style_rideinfo2_info2_label_4_main_main_default, 0);
	lv_style_set_pad_bottom(&style_rideinfo2_info2_label_4_main_main_default, 0);
	lv_obj_add_style(ui->RideInfo2_info2_label_4, &style_rideinfo2_info2_label_4_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);

	//Write codes RideInfo2_info3_label_4
	ui->RideInfo2_info3_label_4 = lv_label_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_info3_label_4, 286, 220);
	lv_obj_set_size(ui->RideInfo2_info3_label_4, 32, 32);
	lv_label_set_text(ui->RideInfo2_info3_label_4, "RPM");
	lv_label_set_long_mode(ui->RideInfo2_info3_label_4, LV_LABEL_LONG_WRAP);
	lv_obj_set_style_text_align(ui->RideInfo2_info3_label_4, LV_TEXT_ALIGN_LEFT, 0);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_info3_label_4_main_main_default
	static lv_style_t style_rideinfo2_info3_label_4_main_main_default;
	if (style_rideinfo2_info3_label_4_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_info3_label_4_main_main_default);
	else
		lv_style_init(&style_rideinfo2_info3_label_4_main_main_default);
	lv_style_set_radius(&style_rideinfo2_info3_label_4_main_main_default, 0);
	lv_style_set_bg_color(&style_rideinfo2_info3_label_4_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_rideinfo2_info3_label_4_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_rideinfo2_info3_label_4_main_main_default, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_rideinfo2_info3_label_4_main_main_default, 0);
	lv_style_set_text_color(&style_rideinfo2_info3_label_4_main_main_default, lv_color_make(0x9e, 0x9e, 0x9e));
	lv_style_set_text_font(&style_rideinfo2_info3_label_4_main_main_default, &lv_font_montserratMedium_12);
	lv_style_set_text_letter_space(&style_rideinfo2_info3_label_4_main_main_default, 0);
	lv_style_set_pad_left(&style_rideinfo2_info3_label_4_main_main_default, 0);
	lv_style_set_pad_right(&style_rideinfo2_info3_label_4_main_main_default, 0);
	lv_style_set_pad_top(&style_rideinfo2_info3_label_4_main_main_default, 0);
	lv_style_set_pad_bottom(&style_rideinfo2_info3_label_4_main_main_default, 0);
	lv_obj_add_style(ui->RideInfo2_info3_label_4, &style_rideinfo2_info3_label_4_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);

	//Write codes RideInfo2_info_img_v
	ui->RideInfo2_info_img_v = lv_img_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_info_img_v, 240, 170);
	lv_obj_set_size(ui->RideInfo2_info_img_v, 210, 3);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_info_img_v_main_main_default
	static lv_style_t style_rideinfo2_info_img_v_main_main_default;
	if (style_rideinfo2_info_img_v_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_info_img_v_main_main_default);
	else
		lv_style_init(&style_rideinfo2_info_img_v_main_main_default);
	lv_style_set_img_recolor(&style_rideinfo2_info_img_v_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_img_recolor_opa(&style_rideinfo2_info_img_v_main_main_default, 0);
	lv_style_set_img_opa(&style_rideinfo2_info_img_v_main_main_default, 255);
	lv_obj_add_style(ui->RideInfo2_info_img_v, &style_rideinfo2_info_img_v_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);
	lv_obj_add_flag(ui->RideInfo2_info_img_v, LV_OBJ_FLAG_CLICKABLE);
	lv_img_set_src(ui->RideInfo2_info_img_v,&_info_h_210x3);
	lv_img_set_pivot(ui->RideInfo2_info_img_v, 0,0);
	lv_img_set_angle(ui->RideInfo2_info_img_v, 0);

	//Write codes RideInfo2_info_img_h
	ui->RideInfo2_info_img_h = lv_img_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_info_img_h, 342, 116);
	lv_obj_set_size(ui->RideInfo2_info_img_h, 3, 120);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_info_img_h_main_main_default
	static lv_style_t style_rideinfo2_info_img_h_main_main_default;
	if (style_rideinfo2_info_img_h_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_info_img_h_main_main_default);
	else
		lv_style_init(&style_rideinfo2_info_img_h_main_main_default);
	lv_style_set_img_recolor(&style_rideinfo2_info_img_h_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_img_recolor_opa(&style_rideinfo2_info_img_h_main_main_default, 0);
	lv_style_set_img_opa(&style_rideinfo2_info_img_h_main_main_default, 255);
	lv_obj_add_style(ui->RideInfo2_info_img_h, &style_rideinfo2_info_img_h_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);
	lv_obj_add_flag(ui->RideInfo2_info_img_h, LV_OBJ_FLAG_CLICKABLE);
	lv_img_set_src(ui->RideInfo2_info_img_h,&_info_v_3x120);
	lv_img_set_pivot(ui->RideInfo2_info_img_h, 0,0);
	lv_img_set_angle(ui->RideInfo2_info_img_h, 0);

	//Write codes RideInfo2_gauge_bg_img
	ui->RideInfo2_gauge_bg_img = lv_img_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_gauge_bg_img, 5, 25);
	lv_obj_set_size(ui->RideInfo2_gauge_bg_img, 233, 234);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_gauge_bg_img_main_main_default
	static lv_style_t style_rideinfo2_gauge_bg_img_main_main_default;
	if (style_rideinfo2_gauge_bg_img_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_gauge_bg_img_main_main_default);
	else
		lv_style_init(&style_rideinfo2_gauge_bg_img_main_main_default);
	lv_style_set_img_recolor(&style_rideinfo2_gauge_bg_img_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_img_recolor_opa(&style_rideinfo2_gauge_bg_img_main_main_default, 0);
	lv_style_set_img_opa(&style_rideinfo2_gauge_bg_img_main_main_default, 255);
	lv_obj_add_style(ui->RideInfo2_gauge_bg_img, &style_rideinfo2_gauge_bg_img_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);
	lv_obj_add_flag(ui->RideInfo2_gauge_bg_img, LV_OBJ_FLAG_CLICKABLE);
	lv_img_set_src(ui->RideInfo2_gauge_bg_img,&_ebike_gauge_bg_233x234);
	lv_img_set_pivot(ui->RideInfo2_gauge_bg_img, 0,0);
	lv_img_set_angle(ui->RideInfo2_gauge_bg_img, 0);

	//Write codes RideInfo2_battery_line_img
	ui->RideInfo2_battery_line_img = lv_img_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_battery_line_img, 5, 139);
	lv_obj_set_size(ui->RideInfo2_battery_line_img, 237, 120);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_battery_line_img_main_main_default
	static lv_style_t style_rideinfo2_battery_line_img_main_main_default;
	if (style_rideinfo2_battery_line_img_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_battery_line_img_main_main_default);
	else
		lv_style_init(&style_rideinfo2_battery_line_img_main_main_default);
	lv_style_set_img_recolor(&style_rideinfo2_battery_line_img_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_img_recolor_opa(&style_rideinfo2_battery_line_img_main_main_default, 0);
	lv_style_set_img_opa(&style_rideinfo2_battery_line_img_main_main_default, 255);
	lv_obj_add_style(ui->RideInfo2_battery_line_img, &style_rideinfo2_battery_line_img_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);
	lv_obj_add_flag(ui->RideInfo2_battery_line_img, LV_OBJ_FLAG_CLICKABLE);
	lv_img_set_src(ui->RideInfo2_battery_line_img,&_ebike_gauge_battery_line_237x120);
	lv_img_set_pivot(ui->RideInfo2_battery_line_img, 0,0);
	lv_img_set_angle(ui->RideInfo2_battery_line_img, 0);

	//Write codes RideInfo2_battery_icon
	ui->RideInfo2_battery_icon = lv_img_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_battery_icon, 110, 200);
	lv_obj_set_size(ui->RideInfo2_battery_icon, 15, 12);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_battery_icon_main_main_default
	static lv_style_t style_rideinfo2_battery_icon_main_main_default;
	if (style_rideinfo2_battery_icon_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_battery_icon_main_main_default);
	else
		lv_style_init(&style_rideinfo2_battery_icon_main_main_default);
	lv_style_set_img_recolor(&style_rideinfo2_battery_icon_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_img_recolor_opa(&style_rideinfo2_battery_icon_main_main_default, 0);
	lv_style_set_img_opa(&style_rideinfo2_battery_icon_main_main_default, 255);
	lv_obj_add_style(ui->RideInfo2_battery_icon, &style_rideinfo2_battery_icon_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);
	lv_obj_add_flag(ui->RideInfo2_battery_icon, LV_OBJ_FLAG_CLICKABLE);
	lv_img_set_src(ui->RideInfo2_battery_icon,&_ebike_gauge_battery_15x12);
	lv_img_set_pivot(ui->RideInfo2_battery_icon, 0,0);
	lv_img_set_angle(ui->RideInfo2_battery_icon, 0);

	//Write codes RideInfo2_battery_label
	ui->RideInfo2_battery_label = lv_label_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_battery_label, 130, 200);
	lv_obj_set_size(ui->RideInfo2_battery_label, 50, 32);
	lv_label_set_text(ui->RideInfo2_battery_label, "56%");
	lv_label_set_long_mode(ui->RideInfo2_battery_label, LV_LABEL_LONG_WRAP);
	lv_obj_set_style_text_align(ui->RideInfo2_battery_label, LV_TEXT_ALIGN_LEFT, 0);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_battery_label_main_main_default
	static lv_style_t style_rideinfo2_battery_label_main_main_default;
	if (style_rideinfo2_battery_label_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_battery_label_main_main_default);
	else
		lv_style_init(&style_rideinfo2_battery_label_main_main_default);
	lv_style_set_radius(&style_rideinfo2_battery_label_main_main_default, 0);
	lv_style_set_bg_color(&style_rideinfo2_battery_label_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_rideinfo2_battery_label_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_rideinfo2_battery_label_main_main_default, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_rideinfo2_battery_label_main_main_default, 0);
	lv_style_set_text_color(&style_rideinfo2_battery_label_main_main_default, lv_color_make(0x00, 0x80, 0xff));
	lv_style_set_text_font(&style_rideinfo2_battery_label_main_main_default, &lv_font_montserratMedium_12);
	lv_style_set_text_letter_space(&style_rideinfo2_battery_label_main_main_default, 0);
	lv_style_set_pad_left(&style_rideinfo2_battery_label_main_main_default, 0);
	lv_style_set_pad_right(&style_rideinfo2_battery_label_main_main_default, 0);
	lv_style_set_pad_top(&style_rideinfo2_battery_label_main_main_default, 0);
	lv_style_set_pad_bottom(&style_rideinfo2_battery_label_main_main_default, 0);
	lv_obj_add_style(ui->RideInfo2_battery_label, &style_rideinfo2_battery_label_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);

	//Write codes RideInfo2_battery_arc
	ui->RideInfo2_battery_arc = lv_arc_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_battery_arc, 25, 38);
	lv_obj_set_size(ui->RideInfo2_battery_arc, 200, 200);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_battery_arc_main_main_default
	static lv_style_t style_rideinfo2_battery_arc_main_main_default;
	if (style_rideinfo2_battery_arc_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_battery_arc_main_main_default);
	else
		lv_style_init(&style_rideinfo2_battery_arc_main_main_default);
	lv_style_set_bg_color(&style_rideinfo2_battery_arc_main_main_default, lv_color_make(0x09, 0x80, 0xff));
	lv_style_set_bg_grad_color(&style_rideinfo2_battery_arc_main_main_default, lv_color_make(0x00, 0x80, 0xff));
	lv_style_set_bg_grad_dir(&style_rideinfo2_battery_arc_main_main_default, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_rideinfo2_battery_arc_main_main_default, 0);
	lv_style_set_border_width(&style_rideinfo2_battery_arc_main_main_default, 0);
	lv_style_set_arc_color(&style_rideinfo2_battery_arc_main_main_default, lv_color_make(0x00, 0x80, 0xff));
	lv_style_set_arc_width(&style_rideinfo2_battery_arc_main_main_default, 5);
	lv_obj_add_style(ui->RideInfo2_battery_arc, &style_rideinfo2_battery_arc_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_battery_arc_main_indicator_default
	static lv_style_t style_rideinfo2_battery_arc_main_indicator_default;
	if (style_rideinfo2_battery_arc_main_indicator_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_battery_arc_main_indicator_default);
	else
		lv_style_init(&style_rideinfo2_battery_arc_main_indicator_default);
	lv_style_set_arc_color(&style_rideinfo2_battery_arc_main_indicator_default, lv_color_make(0x21, 0x95, 0xf6));
	lv_style_set_arc_width(&style_rideinfo2_battery_arc_main_indicator_default, 5);
	lv_obj_add_style(ui->RideInfo2_battery_arc, &style_rideinfo2_battery_arc_main_indicator_default, LV_PART_INDICATOR|LV_STATE_DEFAULT);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_battery_arc_main_knob_default
	static lv_style_t style_rideinfo2_battery_arc_main_knob_default;
	if (style_rideinfo2_battery_arc_main_knob_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_battery_arc_main_knob_default);
	else
		lv_style_init(&style_rideinfo2_battery_arc_main_knob_default);
	lv_style_set_bg_color(&style_rideinfo2_battery_arc_main_knob_default, lv_color_make(0x00, 0x80, 0xff));
	lv_style_set_bg_grad_color(&style_rideinfo2_battery_arc_main_knob_default, lv_color_make(0x00, 0x80, 0xff));
	lv_style_set_bg_grad_dir(&style_rideinfo2_battery_arc_main_knob_default, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_rideinfo2_battery_arc_main_knob_default, 0);
	lv_style_set_pad_all(&style_rideinfo2_battery_arc_main_knob_default, 5);
	lv_obj_add_style(ui->RideInfo2_battery_arc, &style_rideinfo2_battery_arc_main_knob_default, LV_PART_KNOB|LV_STATE_DEFAULT);
	lv_arc_set_bg_angles(ui->RideInfo2_battery_arc, 85, 130);
	lv_arc_set_angles(ui->RideInfo2_battery_arc, 85, 130);
	lv_arc_set_rotation(ui->RideInfo2_battery_arc, 0);
	lv_obj_set_style_pad_top(ui->RideInfo2_battery_arc, 0, LV_STATE_DEFAULT);
	lv_obj_set_style_pad_bottom(ui->RideInfo2_battery_arc, 0, LV_STATE_DEFAULT);
	lv_obj_set_style_pad_left(ui->RideInfo2_battery_arc, 0, LV_STATE_DEFAULT);
	lv_obj_set_style_pad_right(ui->RideInfo2_battery_arc, 0, LV_STATE_DEFAULT);

	//Write codes RideInfo2_footer_bg_img
	ui->RideInfo2_footer_bg_img = lv_img_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_footer_bg_img, 0, 237);
	lv_obj_set_size(ui->RideInfo2_footer_bg_img, 480, 35);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_footer_bg_img_main_main_default
	static lv_style_t style_rideinfo2_footer_bg_img_main_main_default;
	if (style_rideinfo2_footer_bg_img_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_footer_bg_img_main_main_default);
	else
		lv_style_init(&style_rideinfo2_footer_bg_img_main_main_default);
	lv_style_set_img_recolor(&style_rideinfo2_footer_bg_img_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_img_recolor_opa(&style_rideinfo2_footer_bg_img_main_main_default, 0);
	lv_style_set_img_opa(&style_rideinfo2_footer_bg_img_main_main_default, 255);
	lv_obj_add_style(ui->RideInfo2_footer_bg_img, &style_rideinfo2_footer_bg_img_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);
	lv_obj_add_flag(ui->RideInfo2_footer_bg_img, LV_OBJ_FLAG_CLICKABLE);
	lv_img_set_src(ui->RideInfo2_footer_bg_img,&_ebike_footer_bg_480x35);
	lv_img_set_pivot(ui->RideInfo2_footer_bg_img, 0,0);
	lv_img_set_angle(ui->RideInfo2_footer_bg_img, 0);

	//Write codes RideInfo2_footer_line_1
	ui->RideInfo2_footer_line_1 = lv_img_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_footer_line_1, 190, 260);
	lv_obj_set_size(ui->RideInfo2_footer_line_1, 22, 4);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_footer_line_1_main_main_default
	static lv_style_t style_rideinfo2_footer_line_1_main_main_default;
	if (style_rideinfo2_footer_line_1_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_footer_line_1_main_main_default);
	else
		lv_style_init(&style_rideinfo2_footer_line_1_main_main_default);
	lv_style_set_img_recolor(&style_rideinfo2_footer_line_1_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_img_recolor_opa(&style_rideinfo2_footer_line_1_main_main_default, 0);
	lv_style_set_img_opa(&style_rideinfo2_footer_line_1_main_main_default, 255);
	lv_obj_add_style(ui->RideInfo2_footer_line_1, &style_rideinfo2_footer_line_1_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);
	lv_obj_add_flag(ui->RideInfo2_footer_line_1, LV_OBJ_FLAG_CLICKABLE);
	lv_img_set_src(ui->RideInfo2_footer_line_1,&_ebike_footer_line_2_22x4);
	lv_img_set_pivot(ui->RideInfo2_footer_line_1, 0,0);
	lv_img_set_angle(ui->RideInfo2_footer_line_1, 0);

	//Write codes RideInfo2_footer_line_2
	ui->RideInfo2_footer_line_2 = lv_img_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_footer_line_2, 230, 260);
	lv_obj_set_size(ui->RideInfo2_footer_line_2, 22, 4);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_footer_line_2_main_main_default
	static lv_style_t style_rideinfo2_footer_line_2_main_main_default;
	if (style_rideinfo2_footer_line_2_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_footer_line_2_main_main_default);
	else
		lv_style_init(&style_rideinfo2_footer_line_2_main_main_default);
	lv_style_set_img_recolor(&style_rideinfo2_footer_line_2_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_img_recolor_opa(&style_rideinfo2_footer_line_2_main_main_default, 0);
	lv_style_set_img_opa(&style_rideinfo2_footer_line_2_main_main_default, 255);
	lv_obj_add_style(ui->RideInfo2_footer_line_2, &style_rideinfo2_footer_line_2_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);
	lv_obj_add_flag(ui->RideInfo2_footer_line_2, LV_OBJ_FLAG_CLICKABLE);
	lv_img_set_src(ui->RideInfo2_footer_line_2,&_ebike_footer_line_2_22x4);
	lv_img_set_pivot(ui->RideInfo2_footer_line_2, 0,0);
	lv_img_set_angle(ui->RideInfo2_footer_line_2, 0);

	//Write codes RideInfo2_footer_line_3
	ui->RideInfo2_footer_line_3 = lv_img_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_footer_line_3, 270, 260);
	lv_obj_set_size(ui->RideInfo2_footer_line_3, 22, 4);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_footer_line_3_main_main_default
	static lv_style_t style_rideinfo2_footer_line_3_main_main_default;
	if (style_rideinfo2_footer_line_3_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_footer_line_3_main_main_default);
	else
		lv_style_init(&style_rideinfo2_footer_line_3_main_main_default);
	lv_style_set_img_recolor(&style_rideinfo2_footer_line_3_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_img_recolor_opa(&style_rideinfo2_footer_line_3_main_main_default, 0);
	lv_style_set_img_opa(&style_rideinfo2_footer_line_3_main_main_default, 255);
	lv_obj_add_style(ui->RideInfo2_footer_line_3, &style_rideinfo2_footer_line_3_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);
	lv_obj_add_flag(ui->RideInfo2_footer_line_3, LV_OBJ_FLAG_CLICKABLE);
	lv_img_set_src(ui->RideInfo2_footer_line_3,&_ebike_footer_line_1_22x4);
	lv_img_set_pivot(ui->RideInfo2_footer_line_3, 0,0);
	lv_img_set_angle(ui->RideInfo2_footer_line_3, 0);

	//Write codes RideInfo2_watts_label_1
	ui->RideInfo2_watts_label_1 = lv_label_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_watts_label_1, 100, 65);
	lv_obj_set_size(ui->RideInfo2_watts_label_1, 50, 40);
	lv_label_set_text(ui->RideInfo2_watts_label_1, "15.7");
	lv_label_set_long_mode(ui->RideInfo2_watts_label_1, LV_LABEL_LONG_WRAP);
	lv_obj_set_style_text_align(ui->RideInfo2_watts_label_1, LV_TEXT_ALIGN_LEFT, 0);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_watts_label_1_main_main_default
	static lv_style_t style_rideinfo2_watts_label_1_main_main_default;
	if (style_rideinfo2_watts_label_1_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_watts_label_1_main_main_default);
	else
		lv_style_init(&style_rideinfo2_watts_label_1_main_main_default);
	lv_style_set_radius(&style_rideinfo2_watts_label_1_main_main_default, 0);
	lv_style_set_bg_color(&style_rideinfo2_watts_label_1_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_rideinfo2_watts_label_1_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_rideinfo2_watts_label_1_main_main_default, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_rideinfo2_watts_label_1_main_main_default, 0);
	lv_style_set_text_color(&style_rideinfo2_watts_label_1_main_main_default, lv_color_make(0x00, 0x80, 0xff));
	lv_style_set_text_font(&style_rideinfo2_watts_label_1_main_main_default, &lv_font_montserratMedium_20);
	lv_style_set_text_letter_space(&style_rideinfo2_watts_label_1_main_main_default, 0);
	lv_style_set_pad_left(&style_rideinfo2_watts_label_1_main_main_default, 0);
	lv_style_set_pad_right(&style_rideinfo2_watts_label_1_main_main_default, 0);
	lv_style_set_pad_top(&style_rideinfo2_watts_label_1_main_main_default, 0);
	lv_style_set_pad_bottom(&style_rideinfo2_watts_label_1_main_main_default, 0);
	lv_obj_add_style(ui->RideInfo2_watts_label_1, &style_rideinfo2_watts_label_1_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);

	//Write codes RideInfo2_watts_label_2
	ui->RideInfo2_watts_label_2 = lv_label_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_watts_label_2, 100, 86);
	lv_obj_set_size(ui->RideInfo2_watts_label_2, 80, 32);
	lv_label_set_text(ui->RideInfo2_watts_label_2, "Watts");
	lv_label_set_long_mode(ui->RideInfo2_watts_label_2, LV_LABEL_LONG_WRAP);
	lv_obj_set_style_text_align(ui->RideInfo2_watts_label_2, LV_TEXT_ALIGN_LEFT, 0);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_watts_label_2_main_main_default
	static lv_style_t style_rideinfo2_watts_label_2_main_main_default;
	if (style_rideinfo2_watts_label_2_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_watts_label_2_main_main_default);
	else
		lv_style_init(&style_rideinfo2_watts_label_2_main_main_default);
	lv_style_set_radius(&style_rideinfo2_watts_label_2_main_main_default, 0);
	lv_style_set_bg_color(&style_rideinfo2_watts_label_2_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_rideinfo2_watts_label_2_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_rideinfo2_watts_label_2_main_main_default, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_rideinfo2_watts_label_2_main_main_default, 0);
	lv_style_set_text_color(&style_rideinfo2_watts_label_2_main_main_default, lv_color_make(0x9e, 0x9e, 0x9e));
	lv_style_set_text_font(&style_rideinfo2_watts_label_2_main_main_default, &lv_font_montserratMedium_12);
	lv_style_set_text_letter_space(&style_rideinfo2_watts_label_2_main_main_default, 0);
	lv_style_set_pad_left(&style_rideinfo2_watts_label_2_main_main_default, 0);
	lv_style_set_pad_right(&style_rideinfo2_watts_label_2_main_main_default, 0);
	lv_style_set_pad_top(&style_rideinfo2_watts_label_2_main_main_default, 0);
	lv_style_set_pad_bottom(&style_rideinfo2_watts_label_2_main_main_default, 0);
	lv_obj_add_style(ui->RideInfo2_watts_label_2, &style_rideinfo2_watts_label_2_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);

	//Write codes RideInfo2_watts_img
	ui->RideInfo2_watts_img = lv_img_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_watts_img, 31, 112);
	lv_obj_set_size(ui->RideInfo2_watts_img, 182, 75);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_watts_img_main_main_default
	static lv_style_t style_rideinfo2_watts_img_main_main_default;
	if (style_rideinfo2_watts_img_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_watts_img_main_main_default);
	else
		lv_style_init(&style_rideinfo2_watts_img_main_main_default);
	lv_style_set_img_recolor(&style_rideinfo2_watts_img_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_img_recolor_opa(&style_rideinfo2_watts_img_main_main_default, 0);
	lv_style_set_img_opa(&style_rideinfo2_watts_img_main_main_default, 255);
	lv_obj_add_style(ui->RideInfo2_watts_img, &style_rideinfo2_watts_img_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);
	lv_obj_add_flag(ui->RideInfo2_watts_img, LV_OBJ_FLAG_CLICKABLE);
	lv_img_set_src(ui->RideInfo2_watts_img,&_watts_182x75);
	lv_img_set_pivot(ui->RideInfo2_watts_img, 0,0);
	lv_img_set_angle(ui->RideInfo2_watts_img, 0);

	//Write codes RideInfo2_cover_imgbtn
	ui->RideInfo2_cover_imgbtn = lv_imgbtn_create(ui->RideInfo2);
	lv_obj_set_pos(ui->RideInfo2_cover_imgbtn, 0, 0);
	lv_obj_set_size(ui->RideInfo2_cover_imgbtn, 480, 272);

	//Write style state: LV_STATE_DEFAULT for style_rideinfo2_cover_imgbtn_main_main_default
	static lv_style_t style_rideinfo2_cover_imgbtn_main_main_default;
	if (style_rideinfo2_cover_imgbtn_main_main_default.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_cover_imgbtn_main_main_default);
	else
		lv_style_init(&style_rideinfo2_cover_imgbtn_main_main_default);
	lv_style_set_text_color(&style_rideinfo2_cover_imgbtn_main_main_default, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_img_recolor(&style_rideinfo2_cover_imgbtn_main_main_default, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_img_recolor_opa(&style_rideinfo2_cover_imgbtn_main_main_default, 0);
	lv_style_set_img_opa(&style_rideinfo2_cover_imgbtn_main_main_default, 0);
	lv_obj_add_style(ui->RideInfo2_cover_imgbtn, &style_rideinfo2_cover_imgbtn_main_main_default, LV_PART_MAIN|LV_STATE_DEFAULT);

	//Write style state: LV_STATE_PRESSED for style_rideinfo2_cover_imgbtn_main_main_pressed
	static lv_style_t style_rideinfo2_cover_imgbtn_main_main_pressed;
	if (style_rideinfo2_cover_imgbtn_main_main_pressed.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_cover_imgbtn_main_main_pressed);
	else
		lv_style_init(&style_rideinfo2_cover_imgbtn_main_main_pressed);
	lv_style_set_text_color(&style_rideinfo2_cover_imgbtn_main_main_pressed, lv_color_make(0xFF, 0x33, 0xFF));
	lv_style_set_img_recolor(&style_rideinfo2_cover_imgbtn_main_main_pressed, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_img_recolor_opa(&style_rideinfo2_cover_imgbtn_main_main_pressed, 0);
	lv_obj_add_style(ui->RideInfo2_cover_imgbtn, &style_rideinfo2_cover_imgbtn_main_main_pressed, LV_PART_MAIN|LV_STATE_PRESSED);

	//Write style state: LV_STATE_CHECKED for style_rideinfo2_cover_imgbtn_main_main_checked
	static lv_style_t style_rideinfo2_cover_imgbtn_main_main_checked;
	if (style_rideinfo2_cover_imgbtn_main_main_checked.prop_cnt > 1)
		lv_style_reset(&style_rideinfo2_cover_imgbtn_main_main_checked);
	else
		lv_style_init(&style_rideinfo2_cover_imgbtn_main_main_checked);
	lv_style_set_text_color(&style_rideinfo2_cover_imgbtn_main_main_checked, lv_color_make(0xFF, 0x33, 0xFF));
	lv_style_set_img_recolor(&style_rideinfo2_cover_imgbtn_main_main_checked, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_img_recolor_opa(&style_rideinfo2_cover_imgbtn_main_main_checked, 0);
	lv_obj_add_style(ui->RideInfo2_cover_imgbtn, &style_rideinfo2_cover_imgbtn_main_main_checked, LV_PART_MAIN|LV_STATE_CHECKED);
	lv_imgbtn_set_src(ui->RideInfo2_cover_imgbtn, LV_IMGBTN_STATE_RELEASED, NULL, &_bg1_alpha_480x272, NULL);
	lv_imgbtn_set_src(ui->RideInfo2_cover_imgbtn, LV_IMGBTN_STATE_PRESSED, NULL, &_bg1_alpha_480x272, NULL);

	//Init events for screen
	events_init_RideInfo2(ui);
}
