/*
 * Copyright 2022 NXP
 *
 * NXP Confidential. This software is owned or controlled by NXP and may only
 * be used strictly in accordance with the applicable license terms found at
 * https://www.nxp.com/docs/en/disclaimer/LA_OPT_NXP_SW.html . The standard 
 * license in Section 2.3 is expressly granted for this software.  
 */

#include "events_init.h"
#include <stdio.h>
#include "lvgl/lvgl.h"

void events_init(lv_ui *ui)
{
}

static void Overview_cover_imgbtn_event_handler(lv_event_t *e)
{
	lv_event_code_t code = lv_event_get_code(e);
	switch (code)
	{
	case LV_EVENT_CLICKED:
	{
		lv_scr_load_anim(guider_ui.RideInfo1, LV_SCR_LOAD_ANIM_MOVE_LEFT, 1, 0, false);
	}
		break;
	default:
		break;
	}
}

void events_init_Overview(lv_ui *ui)
{
	lv_obj_add_event_cb(ui->Overview_cover_imgbtn, Overview_cover_imgbtn_event_handler, LV_EVENT_ALL, NULL);
}

static void RideInfo1_cover_imgbtn_event_handler(lv_event_t *e)
{
	lv_event_code_t code = lv_event_get_code(e);
	switch (code)
	{
	case LV_EVENT_CLICKED:
	{
		lv_scr_load_anim(guider_ui.RideInfo2, LV_SCR_LOAD_ANIM_MOVE_LEFT, 1, 0, false);
	}
		break;
	default:
		break;
	}
}

void events_init_RideInfo1(lv_ui *ui)
{
	lv_obj_add_event_cb(ui->RideInfo1_cover_imgbtn, RideInfo1_cover_imgbtn_event_handler, LV_EVENT_ALL, NULL);
}

static void RideInfo2_cover_imgbtn_event_handler(lv_event_t *e)
{
	lv_event_code_t code = lv_event_get_code(e);
	switch (code)
	{
	case LV_EVENT_CLICKED:
	{
		lv_scr_load_anim(guider_ui.Overview, LV_SCR_LOAD_ANIM_MOVE_LEFT, 1, 0, false);
	}
		break;
	default:
		break;
	}
}

void events_init_RideInfo2(lv_ui *ui)
{
	lv_obj_add_event_cb(ui->RideInfo2_cover_imgbtn, RideInfo2_cover_imgbtn_event_handler, LV_EVENT_ALL, NULL);
}
