/*
 * Copyright 2018-2021 NXP
 * All rights reserved.
 *
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include "fsl_common.h"
#include "board.h"
#include "fsl_dsp.h"
#include "dsp_support.h"
#include "pmic_support.h"
#include "fsl_pca9420.h"
#include "flexspi_octal_flash_ops.h"
#include "fsl_debug_console.h"
/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*******************************************************************************
 * Variables
 ******************************************************************************/

/*******************************************************************************
 * Code
 ******************************************************************************/
void BOARD_DSP_Init(void)
{
#if DSP_IMAGE_COPY_TO_RAM
    dsp_copy_image_t reset_image;
    dsp_copy_image_t text_image;
    dsp_copy_image_t data_image;

    reset_image.destAddr = DSP_RESET_ADDRESS;
    text_image.destAddr  = DSP_TEXT_ADDRESS;
    data_image.destAddr  = DSP_SRAM_ADDRESS;

#if defined(__ICCARM__)
#pragma section = "__dsp_reset_section"
    reset_image.srcAddr = DSP_IMAGE_RESET_START;
    reset_image.size    = DSP_IMAGE_RESET_SIZE;
#pragma section = "__dsp_text_section"
    text_image.srcAddr = DSP_IMAGE_TEXT_START;
    text_image.size    = DSP_IMAGE_TEXT_SIZE;
#pragma section = "__dsp_data_section"
    data_image.srcAddr = DSP_IMAGE_DATA_START;
    data_image.size    = DSP_IMAGE_DATA_SIZE;
#elif defined(__GNUC__)
    reset_image.srcAddr = DSP_IMAGE_RESET_START;
    reset_image.size    = DSP_IMAGE_RESET_SIZE;
    text_image.srcAddr  = DSP_IMAGE_TEXT_START;
    text_image.size     = DSP_IMAGE_TEXT_SIZE;
    data_image.srcAddr  = DSP_IMAGE_DATA_START;
    data_image.size     = DSP_IMAGE_DATA_SIZE;
#endif
#endif
    /* Initialize PMIC PCA9420 */
//    BOARD_InitPmic();
    
    CLOCK_AttachClk(kFRO_DIV1_to_DSP_MAIN_CLK);
    CLOCK_SetClkDiv(kCLOCK_DivDspCpuClk, 1);
    
#if USE_FRO_96M  
    BOARD_SetPmicVoltage_0V750();
#else
    /* Configure PMIC Vddcore value according to CM33 clock. DSP not used in this demo. */
     BOARD_SetPmicVoltageForFreq(CLOCK_GetFreq(kCLOCK_CoreSysClk), CLOCK_GetFreq(kCLOCK_DspCpuClk));
#endif 
    /* Configure PMIC Vddcore value according to main/dsp clock. */


    /* Set DSP to use primary static vector base(0x0000_0000) and remap to 0x180000. */
    DSP_SetVecRemap(kDSP_StatVecSelPrimary, 0x600U);

    /* Initializing DSP core */
    DSP_Init();

#if DSP_IMAGE_COPY_TO_RAM
    /* Copy application from RAM to DSP_TCM */
    DSP_CopyImage(&reset_image);
    DSP_CopyImage(&text_image);
    DSP_CopyImage(&data_image);
#endif

    /* Run DSP core */
//    DSP_Start();
}


void DSP_POWERDOWN(void)
{
    CLOCK_EnableClock(kCLOCK_Pmc);
    DSP_Deinit();
    DSP_Stop();
    /*
        DSP_RESET_ADDRESS,DSP_TEXT_ADDRESS   0x20180000 (Partition 18-21);
        DSP_SRAM_ADDRESS                     0x20020000 (Partition 4-17);
    */
    
    POWER_EnablePD(kPDRUNCFG_PPD_SRAM_IF4);
    POWER_EnablePD(kPDRUNCFG_PPD_SRAM_IF5);
    POWER_EnablePD(kPDRUNCFG_PPD_SRAM_IF6);
    POWER_EnablePD(kPDRUNCFG_PPD_SRAM_IF7);
    POWER_EnablePD(kPDRUNCFG_PPD_SRAM_IF8);
    POWER_EnablePD(kPDRUNCFG_PPD_SRAM_IF9);
    POWER_EnablePD(kPDRUNCFG_PPD_SRAM_IF10);
    POWER_EnablePD(kPDRUNCFG_PPD_SRAM_IF11);
    POWER_EnablePD(kPDRUNCFG_PPD_SRAM_IF12);
    POWER_EnablePD(kPDRUNCFG_PPD_SRAM_IF13);
    POWER_EnablePD(kPDRUNCFG_PPD_SRAM_IF14);
    POWER_EnablePD(kPDRUNCFG_PPD_SRAM_IF15);
    POWER_EnablePD(kPDRUNCFG_PPD_SRAM_IF16);
    POWER_EnablePD(kPDRUNCFG_PPD_SRAM_IF17);


    POWER_EnablePD(kPDRUNCFG_PPD_SRAM_IF18);
    POWER_EnablePD(kPDRUNCFG_PPD_SRAM_IF19);
    POWER_EnablePD(kPDRUNCFG_PPD_SRAM_IF20);
    POWER_EnablePD(kPDRUNCFG_PPD_SRAM_IF21);
	
    POWER_EnablePD(kPDRUNCFG_APD_SRAM_IF4);
    POWER_EnablePD(kPDRUNCFG_APD_SRAM_IF5);
    POWER_EnablePD(kPDRUNCFG_APD_SRAM_IF6);
    POWER_EnablePD(kPDRUNCFG_APD_SRAM_IF7);
    POWER_EnablePD(kPDRUNCFG_APD_SRAM_IF8);
    POWER_EnablePD(kPDRUNCFG_APD_SRAM_IF9);
    POWER_EnablePD(kPDRUNCFG_APD_SRAM_IF10);
    POWER_EnablePD(kPDRUNCFG_APD_SRAM_IF11);
    POWER_EnablePD(kPDRUNCFG_APD_SRAM_IF12);
    POWER_EnablePD(kPDRUNCFG_APD_SRAM_IF13);
    POWER_EnablePD(kPDRUNCFG_APD_SRAM_IF14);
    POWER_EnablePD(kPDRUNCFG_APD_SRAM_IF15);
    POWER_EnablePD(kPDRUNCFG_APD_SRAM_IF16);
    POWER_EnablePD(kPDRUNCFG_APD_SRAM_IF17);
    POWER_ApplyPD();
    
    
#if USE_FRO_96M  
    BOARD_SetPmicVoltage_0V750();
  //  BOARD_SetPmicVoltage_0V725();
#else
    /* Configure PMIC Vddcore value according to CM33 clock. DSP not used in this demo. */
  BOARD_SetPmicVoltageForFreq(CLOCK_GetFreq(kCLOCK_CoreSysClk), 0U); 
#endif 

//    CLOCK_DisableClock(kCLOCK_Pmc);
    
//    PRINTF("POWERDOWN\r\n");

}

void DSP_RESUME(void)
{
#if DSP_IMAGE_COPY_TO_RAM
    dsp_copy_image_t reset_image;
    dsp_copy_image_t text_image;
    dsp_copy_image_t data_image;
#endif

#if DSP_IMAGE_IN_FLEXSPI0
    uint8_t vendorID = 0;
    volatile status_t status;
    void *p = (void *)BOARD_DSP_Init;
#endif
    reset_image.destAddr = DSP_RESET_ADDRESS;
    text_image.destAddr  = DSP_TEXT_ADDRESS;
    data_image.destAddr  = DSP_SRAM_ADDRESS;

#if defined(__ICCARM__)
#pragma section = "__dsp_reset_section"
    reset_image.srcAddr = DSP_IMAGE_RESET_START;
    reset_image.size    = DSP_IMAGE_RESET_SIZE;
#pragma section = "__dsp_text_section"
    text_image.srcAddr = DSP_IMAGE_TEXT_START;
    text_image.size    = DSP_IMAGE_TEXT_SIZE;
#pragma section = "__dsp_data_section"
    data_image.srcAddr = DSP_IMAGE_DATA_START;
    data_image.size    = DSP_IMAGE_DATA_SIZE;
#elif defined(__GNUC__)
    reset_image.srcAddr = DSP_IMAGE_RESET_START;
    reset_image.size    = DSP_IMAGE_RESET_SIZE;
    text_image.srcAddr = DSP_IMAGE_TEXT_START;
    text_image.size    = DSP_IMAGE_TEXT_SIZE;
    data_image.srcAddr = DSP_IMAGE_DATA_START;
    data_image.size    = DSP_IMAGE_DATA_SIZE;
#endif
    CLOCK_EnableClock(kCLOCK_Pmc);
    
    POWER_DisablePD(kPDRUNCFG_PPD_SRAM_IF4);
    POWER_DisablePD(kPDRUNCFG_PPD_SRAM_IF5);
    POWER_DisablePD(kPDRUNCFG_PPD_SRAM_IF6);
    POWER_DisablePD(kPDRUNCFG_PPD_SRAM_IF7);
    POWER_DisablePD(kPDRUNCFG_PPD_SRAM_IF8);
    POWER_DisablePD(kPDRUNCFG_PPD_SRAM_IF9);
    POWER_DisablePD(kPDRUNCFG_PPD_SRAM_IF10);
    POWER_DisablePD(kPDRUNCFG_PPD_SRAM_IF11);
    POWER_DisablePD(kPDRUNCFG_PPD_SRAM_IF12);
    POWER_DisablePD(kPDRUNCFG_PPD_SRAM_IF13);
    POWER_DisablePD(kPDRUNCFG_PPD_SRAM_IF14);
    POWER_DisablePD(kPDRUNCFG_PPD_SRAM_IF15);
    POWER_DisablePD(kPDRUNCFG_PPD_SRAM_IF16);
    POWER_DisablePD(kPDRUNCFG_PPD_SRAM_IF17);


    POWER_DisablePD(kPDRUNCFG_PPD_SRAM_IF18);
    POWER_DisablePD(kPDRUNCFG_PPD_SRAM_IF19);
    POWER_DisablePD(kPDRUNCFG_PPD_SRAM_IF20);
    POWER_DisablePD(kPDRUNCFG_PPD_SRAM_IF21);
	
    POWER_DisablePD(kPDRUNCFG_APD_SRAM_IF4);
    POWER_DisablePD(kPDRUNCFG_APD_SRAM_IF5);
    POWER_DisablePD(kPDRUNCFG_APD_SRAM_IF6);
    POWER_DisablePD(kPDRUNCFG_APD_SRAM_IF7);
    POWER_DisablePD(kPDRUNCFG_APD_SRAM_IF8);
    POWER_DisablePD(kPDRUNCFG_APD_SRAM_IF9);
    POWER_DisablePD(kPDRUNCFG_APD_SRAM_IF10);
    POWER_DisablePD(kPDRUNCFG_APD_SRAM_IF11);
    POWER_DisablePD(kPDRUNCFG_APD_SRAM_IF12);
    POWER_DisablePD(kPDRUNCFG_APD_SRAM_IF13);
    POWER_DisablePD(kPDRUNCFG_APD_SRAM_IF14);
    POWER_DisablePD(kPDRUNCFG_APD_SRAM_IF15);
    POWER_DisablePD(kPDRUNCFG_APD_SRAM_IF16);
    POWER_DisablePD(kPDRUNCFG_APD_SRAM_IF17);
    POWER_ApplyPD();

    CLOCK_AttachClk(kFRO_DIV1_to_DSP_MAIN_CLK);
    CLOCK_SetClkDiv(kCLOCK_DivDspCpuClk, 1);

    
#if USE_FRO_96M  
    BOARD_SetPmicVoltage_0V750();
//    BOARD_SetPmicVoltage_0V725();
#else
    /* Configure PMIC Vddcore value according to CM33 clock. DSP not used in this demo. */
    BOARD_SetPmicVoltageForFreq(CLOCK_GetFreq(kCLOCK_CoreSysClk), CLOCK_GetFreq(kCLOCK_DspCpuClk)); 
#endif

    /* Set DSP to use primary static vector base(0x0000_0000) and remap to 0x180000. */
    DSP_SetVecRemap(kDSP_StatVecSelPrimary, 0x600U);

    /* Initializing DSP core */
    DSP_Init();

#if DSP_IMAGE_COPY_TO_RAM
    /* Copy application from RAM to DSP_TCM */
    DSP_CopyImage(&reset_image);
    DSP_CopyImage(&text_image);
    DSP_CopyImage(&data_image);
#endif

    /* Run DSP core */
    DSP_Start();
    __DSB();
    __ISB();
//    CLOCK_DisableClock(kCLOCK_Pmc);
}
