/* ------------------------------------------------------------------------ */
/* Copyright (c) 2016 by Cadence Design Systems, Inc. ALL RIGHTS RESERVED.  */
/* These coded instructions, statements, and computer programs (Cadence    */
/* Libraries) are the copyrighted works of Cadence Design Systems Inc.	    */
/* Cadence IP is licensed for use with Cadence processor cores only and     */
/* must not be used for any other processors and platforms. Your use of the */
/* Cadence Libraries is subject to the terms of the license agreement you   */
/* have entered into with Cadence Design Systems, or a sublicense granted   */
/* to you by a direct Cadence licensee.                                     */
/* ------------------------------------------------------------------------ */
/*  IntegrIT, Ltd.   www.integrIT.com, info@integrIT.com                    */
/*                                                                          */
/* DSP Library                                                              */
/*                                                                          */
/* This library contains copyrighted materials, trade secrets and other     */
/* proprietary information of IntegrIT, Ltd. This software is licensed for  */
/* use with Cadence processor cores only and must not be used for any other */
/* processors and platforms. The license to use these sources was given to  */
/* Cadence, Inc. under Terms and Condition of a Software License Agreement  */
/* between Cadence, Inc. and IntegrIT, Ltd.                                 */
/* ------------------------------------------------------------------------ */
/*          Copyright (C) 2015-2016 IntegrIT, Limited.                      */
/*                      All Rights Reserved.                                */
/* ------------------------------------------------------------------------ */

#include "vec_log_table.h"
#include "common.h"

#ifdef COMPILER_MSVC
const int32_t _declspec(align(8)) log2_table[] =
#else
const int32_t                     log2_table[] __attribute__((aligned(8))) =
#endif
/*
MATLAB code:
ord=128;
xt=0.5:0.5/ord:1;
for (i=1:(ord))
  tbl_x(i)=xt(i)+((xt(i+1)-xt(i))/2); 
end;
tbl_y=log2(tbl_x);
tbl_z=(1./tbl_x)*log2(2.718281828);
tbl_y=round(tbl_y*2^31);%Q31
tbl_z=round(tbl_y*2^29);%Q29
tbl_y=min(2^31-1,tbl_y);
tbl_z=min(2^31-1,tbl_z);
tbl_log = [tbl_y;tbl_z];
*/
{
 -2135405020, 1543054448, -2111388125, 1531138969,
 -2087555976, 1519406104, -2063905754, 1507851685,
 -2040434703, 1496471672, -2017140127, 1485262146,
 -1994019392, 1474219305, -1971069924, 1463339458,
 -1948289204, 1452619022, -1925674768, 1442054520,
 -1903224206, 1431642574, -1880935160, 1421379903,
 -1858805323, 1411263320, -1836832436, 1401289728,
 -1815014290, 1391456116, -1793348719, 1381759558,
 -1771833605, 1372197208, -1750466872, 1362766299,
 -1729246487, 1353464140, -1708170460, 1344288112,
 -1687236840, 1335235667, -1666443715, 1326304325,
 -1645789212, 1317491671, -1625271494, 1308795357,
 -1604888763, 1300213092, -1584639253, 1291742648,
 -1564521234, 1283381855, -1544533010, 1275128595,
 -1524672916, 1266980808, -1504939321, 1258936486,
 -1485330622, 1250993669, -1465845250, 1243150448,
 -1446481662, 1235404963, -1427238345, 1227755396,
 -1408113815, 1220199979, -1389106614, 1212736982,
 -1370215312, 1205364720, -1351438503, 1198081550,
 -1332774808, 1190885865, -1314222872, 1183776099,
 -1295781365, 1176750721, -1277448980, 1169808239,
 -1259224434, 1162947194, -1241106464, 1156166160,
 -1223093832, 1149463748, -1205185319, 1142838597,
 -1187379730, 1136289378, -1169675887, 1129814795,
 -1152072635, 1123413578, -1134568837, 1117084487,
 -1117163376, 1110826311, -1099855152, 1104637864,
 -1082643085, 1098517986, -1065526114, 1092465546,
 -1048503192, 1086479433, -1031573292, 1080558564,
 -1014735402, 1074701878, -997988529,  1068908337,
 -981331693,  1063176925, -964763932,  1057506648,
 -948284297,  1051896533, -931891857,  1046345628,
 -915585693,  1040853000, -899364902,  1035417736,
 -883228594,  1030038943, -867175895,  1024715744,
 -851205942,  1019447283, -835317887,  1014232719,
 -819510893,  1009071229, -803784139,  1003962008,
 -788136812,  998904264,  -772568116,  993897226,
 -757077264,  988940132,  -741663481,  984032241,
 -726326004,  979172822,  -711064081,  974361162,
 -695876973,  969596560,  -680763947,  964878328,
 -665724287,  960205794,  -650757282,  955578296,
 -635862234,  950995187,  -621038454,  946455831,
 -606285264,  941959603,  -591601995,  937505894,
 -576987987,  933094101,  -562442589,  928723637,
 -547965161,  924393923,  -533555070,  920104392,
 -519211692,  915854487,  -504934414,  911643662,
 -490722627,  907471380,  -476575735,  903337114,
 -462493147,  899240347,  -448474281,  895180571,
 -434518564,  891157288,  -420625429,  887170007,
 -406794316,  883218247,  -393024676,  879301537,
 -379315963,  875419411,  -365667642,  871571413,
 -352079181,  867757096,  -338550059,  863976020,
 -325079760,  860227750,  -311667773,  856511864,
 -298313597,  852827942,  -285016736,  849175574,
 -271776698,  845554356,  -258593002,  841963892,
 -245465169,  838403791,  -232392727,  834873669,
 -219375212,  831373151,  -206412164,  827901864,
 -193503129,  824459445,  -180647658,  821045534,
 -167845309,  817659779,  -155095645,  814301834,
 -142398234,  810971356,  -129752649,  807668010,
 -117158469,  804391466,  -104615278,  801141400,
 -92122664,   797917491,  -79680221,   794719425,
 -67287549,   791546892,  -54944250,   788399588,
 -42649932,   785277214,  -30404208,   782179473,
 -18206696,   779106077,  -6057018,    776056738
};
