/*
 * Copyright 2018-2019 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include <stdio.h>
#include <xtensa/config/core.h>
#include <xtensa/xos.h>
#include "board_fusionf1.h"

#include "fsl_device_registers.h"
#include "fsl_iopctl.h"
#include "fsl_inputmux.h"

#include "audio_capture_render.h"
#include "audio_algo.h"
#include "srtm_utils.h"
#include "vit_model.h"
#include "fsl_debug_console.h"
#include "fsl_i2s.h"
#include "pin_mux.h"
#include "board_fusionf1.h"
#include "fsl_gpio.h"

#if (XA_VIT_PRE_PROC)
#include "xaf-api.h"
#include "vit_pre_proc.h"
#else
#include "vit_glue.h"
#endif
#include "dualcore_ringbuffer_of.h"




#define USE_LOWPOWER_DMIC_ACQUISITION 1
#define VIT_APP_STACK_SIZE 0x2000
static unsigned char vit_app_stack[VIT_APP_STACK_SIZE];
static vit_pre_proc_t vit_context;


//#define CHECK_DATA

#ifdef CHECK_DATA
    #define AUDIO_DUMP_START_0 0x00AC0000
    #define AUDIO_DUMP_MAX     0x00020000
    #define AUDIO_DUMP_DONE    0x00CC0000
    static uint32_t audio_dump_pos = 0;
    uint8_t *p_audio_dump_addr = NULL;
#endif

typedef struct _srtm_capturer_gain_renderer_param
{
	uint32_t channels;
	uint32_t sampling_rate;
	uint32_t width;
} srtm_capturer_gain_renderer_param;


dsp_handle_t dsp;
#define AUDIO_BUFFER_SIZE (32 * 1024)
int srtm_capturer_gain_renderer_init(unsigned int *pCmdParams, bool i2s);

/*******************************************************************************
 * Code
 ******************************************************************************/
static void BOARD_InitClock(void)
{
//    CLOCK_EnableClock(kCLOCK_InputMux);

    /* DSP_INT0_SEL18 = DMA1 */
//    INPUTMUX_AttachSignal(INPUTMUX, 18U, kINPUTMUX_Dmac1ToDspInterrupt);

    /* I2S clocks */
    /* attach AUDIO PLL clock to FLEXCOMM1 (I2S1) for codec output*/
//    CLOCK_AttachClk(kAUDIO_PLL_to_FLEXCOMM1);
    /* attach AUDIO PLL clock to FLEXCOMM5 (I2S5) for I2S capture*/
//    CLOCK_AttachClk(kAUDIO_PLL_to_FLEXCOMM5);

    /* DMIC uses 24.576MHz AUDIO_PLL clock */
//    CLOCK_AttachClk(kAUDIO_PLL_to_DMIC);

    /* 24.576MHz divided by 12 = 2048 KHz PDM clock --> gives 16kHz sample rate */
//    CLOCK_SetClkDiv(kCLOCK_DivDmicClk, 12);

//    CLOCK_AttachClk(kFRO_DIV4_to_FLEXCOMM4);
}

static void DSP_XAF_Init(dsp_handle_t *dsp)
{
    uint8_t *version[3];

    xos_mutex_create(&dsp->audioMutex, XOS_MUTEX_WAIT_PRIORITY, 0);
    xos_mutex_create(&dsp->rpmsgMutex, XOS_MUTEX_WAIT_PRIORITY, 0);
    dsp->audioBuffer = ringbuf_create(AUDIO_BUFFER_SIZE);
    if (!dsp->audioBuffer)
    {
        DSP_PRINTF("[DSP_XAF_Init] ringbuffer allocation failed\r\n");
    }

    xos_event_create(&dsp->pipeline_event, 0xFF, XOS_EVENT_AUTO_CLEAR);

//    xaf_get_verinfo(version);

//    DSP_PRINTF("\r\n");
//    DSP_PRINTF("Cadence Xtensa Audio Framework\r\n");
//    DSP_PRINTF("  Library Name    : %s\r\n", version[0]);
//    DSP_PRINTF("  Library Version : %s\r\n", version[1]);
//    DSP_PRINTF("  API Version     : %s\r\n", version[2]);
//    DSP_PRINTF("\r\n");
}

int16_t vit_in_buf[AUDIO_CAPTURE_TRANSFER_SIZE];
dcringbuf_t *p_dcringbuf_context = NULL;



int32_t Vit_App_task(void * arg, int32_t wake_value)
{
	srtm_capturer_gain_renderer_param param;
	int16_t *pData = vit_in_buf;
	uint32_t size = AUDIO_CAPTURE_TRANSFER_SIZE * sizeof(int16_t);
    int32_t occ;

	memset(&vit_context, 0, sizeof(vit_context));

	VIT_Initialize(&vit_context);
//	PRINTF("VIT Initialize\n");

#ifdef GPIO_DEBUG
//	GPIO_PinWrite(GPIO, GPIO_DEBUG_PORT_1, GPIO_DEBUG_PIN_1, 0);
#endif

	while(1) {
//#ifdef GPIO_DEBUG
//      GPIO_PortToggle(GPIO, GPIO_DEBUG_PORT_0, (1 << GPIO_DEBUG_PIN_0));
//#endif
#if USE_LOWPOWER_DMIC_ACQUISITION
		occ = dc_ringbuf_get_occupancy(p_dcringbuf_context);
		if(occ >= size) {
#ifdef GPIO_DEBUG
		    GPIO_PortToggle(GPIO, GPIO_DEBUG_PORT_0, (1 << GPIO_DEBUG_PIN_0));
#endif
			dc_ringbuf_read(p_dcringbuf_context, (uint8_t*)pData, size);



			vit_context.input = pData;
			vit_context.input_avail = size;

#ifdef CHECK_DATA

		   if((audio_dump_pos < AUDIO_DUMP_MAX) && (audio_dump_pos != AUDIO_DUMP_DONE)) {
		                                                p_audio_dump_addr = (uint8_t *)(AUDIO_DUMP_START_0 + audio_dump_pos);
		               memcpy(p_audio_dump_addr, pData, size);
		                                                audio_dump_pos += size;
		        } else {
		            if(audio_dump_pos != AUDIO_DUMP_DONE)
		            {
		                PRINTF("Dump Done\n");
		            }
		            audio_dump_pos = AUDIO_DUMP_DONE;
		                                }
#endif
			xa_vit_pre_proc_do_execute_16bit(&vit_context);
#ifdef GPIO_DEBUG
		    GPIO_PortToggle(GPIO, GPIO_DEBUG_PORT_0, (1 << GPIO_DEBUG_PIN_0));
#endif
        } else {
			xos_thread_sleep_msec(1);
        }
#endif
	}


    return 0;
}

int main(int argc, char **argv) {
	XosThread thread_vit_app_tcb;
	volatile int32_t state = 0, i;
    uint32_t freq;

	BOARD_InitPins();

#ifdef GPIO_DEBUG
//	gpio_pin_config_t gpio_config;

//	gpio_config.outputLogic = 1;
//	gpio_config.pinDirection = kGPIO_DigitalOutput;
//	GPIO_PinInit(GPIO, GPIO_DEBUG_PORT_0, GPIO_DEBUG_PIN_0, &gpio_config);
//	GPIO_PinInit(GPIO, GPIO_DEBUG_PORT_1, GPIO_DEBUG_PIN_1, &gpio_config);
#endif

	CLOCK_SetXtalFreq(BOARD_XTAL_SYS_CLK_HZ); /* sets external XTAL OSC freq */
#if (SDK_DEBUGCONSOLE < 2)
    BOARD_InitDebugConsole();
#endif
  //  PRINTF("DSP VIT Example\n");

#if USE_LOWPOWER_DMIC_ACQUISITION
	p_dcringbuf_context = dc_ringbuf_create((uint8_t *)BOARD_TX_AUDIOSOURCE_ARM_SHMEM_BASE,
							BOARD_TX_AUDIOSOURCE_ARM_SHMEM_SIZE);
    dc_ringbuf_setmode(p_dcringbuf_context, RINGBUF_MODE_NORMAL);
#endif

    freq = CLOCK_GetFreq(kCLOCK_DspCpuClk);
 //   PRINTF("freq = %d\r\n",freq);

	xos_set_clock_freq(freq);//XOS_CLOCK_FREQ
	xos_start_system_timer(-1, 0);

	xos_thread_create(&thread_vit_app_tcb, 0, Vit_App_task,
			NULL, "VIT APP Task", vit_app_stack,
			VIT_APP_STACK_SIZE, 8, 0, 0);

	xos_start(0);

	return 0;
}

