/*
 * Copyright 2020 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
 
#ifndef AUDIO_ALGO_H
#define AUDIO_ALGO_H

#include "fsl_common.h"

typedef struct _AudioAlgoConfiguration
{
	uint32_t *pInput;
	uint32_t inputSize;
	uint32_t *pOutput;
	uint32_t outputSize;
	
    int32_t  channels;
    int32_t  fs_in;
    int32_t  fs_out;
    int32_t  input_chunk_size;
    int32_t  bytes_per_sample;

	void *algo_specific;
} AudioAlgoConfiguration;

typedef void* AudioAlgoHandle;

typedef enum {
	kAudioAlgo_SRC,
	kAudioAlgo_OpusEnc,
	kAudioAlgo_OpusDec,
	kAudioAlgo_Biquad,
	kAudioAlgo_MaxSupportNum
} AUDIO_ALGO_TYPE;


#endif

