/*
** ###################################################################
**     Processors:          LPC55S36JBD100
**                          LPC55S36JHI48
**
**     Compilers:           GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**                          Keil ARM C/C++ Compiler
**                          MCUXpresso Compiler
**
**     Reference manual:    LPC55S3x Reference Manual Rev. DraftG, 07/2021
**     Version:             rev. 1.1, 2021-08-04
**     Build:               b211210
**
**     Abstract:
**         CMSIS Peripheral Access Layer for LPC55S36
**
**     Copyright 1997-2016 Freescale Semiconductor, Inc.
**     Copyright 2016-2021 NXP
**     All rights reserved.
**
**     SPDX-License-Identifier: BSD-3-Clause
**
**     http:                 www.nxp.com
**     mail:                 support@nxp.com
**
**     Revisions:
**     - rev. 1.0 (2021-04-12)
**         Initial version based on RM DraftF
**     - rev. 1.1 (2021-08-04)
**         Initial version based on RM DraftG
**
** ###################################################################
*/

/*!
 * @file LPC55S36.h
 * @version 1.1
 * @date 2021-08-04
 * @brief CMSIS Peripheral Access Layer for LPC55S36
 *
 * CMSIS Peripheral Access Layer for LPC55S36
 */

#ifndef _LPC55S36_H_
#define _LPC55S36_H_                             /**< Symbol preventing repeated inclusion */

/** Memory map major version (memory maps with equal major version number are
 * compatible) */
#define MCU_MEM_MAP_VERSION 0x0100U
/** Memory map minor version */
#define MCU_MEM_MAP_VERSION_MINOR 0x0001U


/* ----------------------------------------------------------------------------
   -- Interrupt vector numbers
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Interrupt_vector_numbers Interrupt vector numbers
 * @{
 */

/** Interrupt Number Definitions */
#define NUMBER_OF_INT_VECTORS 136                /**< Number of interrupts in the Vector table */

typedef enum IRQn {
  /* Auxiliary constants */
  NotAvail_IRQn                = -128,             /**< Not available device specific interrupt */

  /* Core interrupts */
  NonMaskableInt_IRQn          = -14,              /**< Non Maskable Interrupt */
  HardFault_IRQn               = -13,              /**< Cortex-M33 SV Hard Fault Interrupt */
  MemoryManagement_IRQn        = -12,              /**< Cortex-M33 Memory Management Interrupt */
  BusFault_IRQn                = -11,              /**< Cortex-M33 Bus Fault Interrupt */
  UsageFault_IRQn              = -10,              /**< Cortex-M33 Usage Fault Interrupt */
  SecureFault_IRQn             = -9,               /**< Cortex-M33 Secure Fault Interrupt */
  SVCall_IRQn                  = -5,               /**< Cortex-M33 SV Call Interrupt */
  DebugMonitor_IRQn            = -4,               /**< Cortex-M33 Debug Monitor Interrupt */
  PendSV_IRQn                  = -2,               /**< Cortex-M33 Pend SV Interrupt */
  SysTick_IRQn                 = -1,               /**< Cortex-M33 System Tick Interrupt */

  /* Device specific interrupts */
  WDT_BOD_IRQn                 = 0,                /**< Windowed watchdog timer, Brownout detect, Flash interrupt */
  DMA0_IRQn                    = 1,                /**< DMA0 controller */
  GINT0_IRQn                   = 2,                /**< GPIO group 0 */
  GINT1_IRQn                   = 3,                /**< GPIO group 1 */
  PIN_INT0_IRQn                = 4,                /**< Pin interrupt 0 or pattern match engine slice 0 */
  PIN_INT1_IRQn                = 5,                /**< Pin interrupt 1or pattern match engine slice 1 */
  PIN_INT2_IRQn                = 6,                /**< Pin interrupt 2 or pattern match engine slice 2 */
  PIN_INT3_IRQn                = 7,                /**< Pin interrupt 3 or pattern match engine slice 3 */
  UTICK0_IRQn                  = 8,                /**< Micro-tick Timer */
  MRT0_IRQn                    = 9,                /**< Multi-rate timer */
  CTIMER0_IRQn                 = 10,               /**< Standard counter/timer CTIMER0 */
  CTIMER1_IRQn                 = 11,               /**< Standard counter/timer CTIMER1 */
  SCT0_IRQn                    = 12,               /**< SCTimer/PWM */
  CTIMER3_IRQn                 = 13,               /**< Standard counter/timer CTIMER3 */
  FLEXCOMM0_IRQn               = 14,               /**< Flexcomm Interface 0 (USART, SPI, I2C, I2S, FLEXCOMM) */
  FLEXCOMM1_IRQn               = 15,               /**< Flexcomm Interface 1 (USART, SPI, I2C, I2S, FLEXCOMM) */
  FLEXCOMM2_IRQn               = 16,               /**< Flexcomm Interface 2 (USART, SPI, I2C, I2S, FLEXCOMM) */
  FLEXCOMM3_IRQn               = 17,               /**< Flexcomm Interface 3 (USART, SPI, I2C, I2S, FLEXCOMM) */
  FLEXCOMM4_IRQn               = 18,               /**< Flexcomm Interface 4 (USART, SPI, I2C, I2S, FLEXCOMM) */
  FLEXCOMM5_IRQn               = 19,               /**< Flexcomm Interface 5 (USART, SPI, I2C, I2S, FLEXCOMM) */
  FLEXCOMM6_IRQn               = 20,               /**< Flexcomm Interface 6 (USART, SPI, I2C, I2S, FLEXCOMM) */
  FLEXCOMM7_IRQn               = 21,               /**< Flexcomm Interface 7 (USART, SPI, I2C, I2S, FLEXCOMM) */
  ADC0_IRQn                    = 22,               /**< ADC0  */
  ADC1_IRQn                    = 23,               /**< ADC1 */
  ACMP_IRQn                    = 24,               /**< ACMP interrupts */
  DMIC_IRQn                    = 25,               /**< Digital microphone and DMIC subsystem */
  HWVAD0_IRQn                  = 26,               /**< Hardware Voice Activity Detector */
  USB0_NEEDCLK_IRQn            = 27,               /**< USB Activity Wake-up Interrupt */
  USB0_IRQn                    = 28,               /**< USB device */
  RTC_IRQn                     = 29,               /**< RTC alarm and wake-up interrupts */
  EZH_ARCH_B0_IRQn             = 30,               /**< EZH interrupt */
  WAKEUP_IRQn                  = 31,               /**< Wakeup interrupt */
  PIN_INT4_IRQn                = 32,               /**< Pin interrupt 4 or pattern match engine slice 4 int */
  PIN_INT5_IRQn                = 33,               /**< Pin interrupt 5 or pattern match engine slice 5 int */
  PIN_INT6_IRQn                = 34,               /**< Pin interrupt 6 or pattern match engine slice 6 int */
  PIN_INT7_IRQn                = 35,               /**< Pin interrupt 7 or pattern match engine slice 7 int */
  CTIMER2_IRQn                 = 36,               /**< Standard counter/timer CTIMER2 */
  CTIMER4_IRQn                 = 37,               /**< Standard counter/timer CTIMER4 */
  OS_EVENT_IRQn                = 38,               /**< OS_EVENT_TIMER and OS_EVENT_WAKEUP interrupts */
  FlexSPI0_IRQn                = 39,               /**< FlexSPI interrupt */
  Reserved56_IRQn              = 40,               /**< Reserved interrupt */
  Reserved57_IRQn              = 41,               /**< Reserved interrupt */
  Reserved58_IRQn              = 42,               /**< Reserved interrupt */
  CAN0_IRQ0_IRQn               = 43,               /**< CAN0 interrupt0 */
  CAN0_IRQ1_IRQn               = 44,               /**< CAN0 interrupt1 */
  SPI_FILTER_IRQn              = 45,               /**< SPI Filter interrupt */
  Reserved62_IRQn              = 46,               /**< Reserved interrupt */
  Reserved63_IRQn              = 47,               /**< Reserved interrupt */
  Reserved64_IRQn              = 48,               /**< Reserved interrupt */
  SEC_HYPERVISOR_CALL_IRQn     = 49,               /**< SEC_HYPERVISOR_CALL interrupt */
  SEC_GPIO_INT0_IRQ0_IRQn      = 50,               /**< SEC_GPIO_INT00 interrupt */
  SEC_GPIO_INT0_IRQ1_IRQn      = 51,               /**< SEC_GPIO_INT01 interrupt */
  Freqme_IRQn                  = 52,               /**< frequency measure interrupt */
  SEC_VIO_IRQn                 = 53,               /**< SEC_VIO interrupt */
  CSS_IRQn                     = 54,               /**< SHA interrupt */
  PKC_IRQn                     = 55,               /**< CASPER interrupt */
  PUF_IRQn                     = 56,               /**< PUF interrupt */
  POWERQUAD_IRQn               = 57,               /**< PowerQuad interrupt */
  DMA1_IRQn                    = 58,               /**< DMA1 interrupt */
  FLEXCOMM8_IRQn               = 59,               /**< LSPI_HS interrupt */
  CDOG_IRQn                    = 60,               /**< CodeWDG interrupt */
  Reserved77_IRQn              = 61,               /**< Reserved interrupt */
  I3C0_IRQn                    = 62,               /**< I3C interrupt */
  Reserved79_IRQn              = 63,               /**< Reserved interrupt */
  Reserved80_IRQn              = 64,               /**< Reserved interrupt */
  CSS_IRQ1_IRQn                = 65,               /**< CSS_IRQ1 */
  Tamper_IRQn                  = 66,               /**< Tamper */
  Reserved83_IRQn              = 67,               /**< Reserved interrupt */
  Reserved84_IRQn              = 68,               /**< Reserved interrupt */
  Reserved85_IRQn              = 69,               /**< Reserved interrupt */
  Reserved86_IRQn              = 70,               /**< Reserved interrupt */
  Reserved87_IRQn              = 71,               /**< Reserved interrupt */
  Reserved88_IRQn              = 72,               /**< Reserved interrupt */
  Reserved89_IRQn              = 73,               /**< Reserved interrupt */
  DAC0_IRQn                    = 74,               /**< dac0 interrupt */
  DAC1_IRQn                    = 75,               /**< dac1 interrupt */
  DAC2_IRQn                    = 76,               /**< dac2 interrupt */
  HSCMP0_IRQn                  = 77,               /**< hscmp0 interrupt */
  HSCMP1_IRQn                  = 78,               /**< hscmp1 interrupt */
  HSCMP2_IRQn                  = 79,               /**< hscmp2 interrupt */
  FLEXPWM0_CAPTURE_IRQn        = 80,               /**< flexpwm0_capture interrupt */
  FLEXPWM0_FAULT_IRQn          = 81,               /**< flexpwm0_fault interrupt */
  FLEXPWM0_RELOAD_ERROR_IRQn   = 82,               /**< flexpwm0_reload_error interrupt */
  FLEXPWM0_COMPARE0_IRQn       = 83,               /**< flexpwm0_compare0 interrupt */
  FLEXPWM0_RELOAD0_IRQn        = 84,               /**< flexpwm0_reload0 interrupt */
  FLEXPWM0_COMPARE1_IRQn       = 85,               /**< flexpwm0_compare1 interrupt */
  FLEXPWM0_RELOAD1_IRQn        = 86,               /**< flexpwm0_reload1 interrupt */
  FLEXPWM0_COMPARE2_IRQn       = 87,               /**< flexpwm0_compare2 interrupt */
  FLEXPWM0_RELOAD2_IRQn        = 88,               /**< flexpwm0_reload2 interrupt */
  FLEXPWM0_COMPARE3_IRQn       = 89,               /**< flexpwm0_compare3 interrupt */
  FLEXPWM0_RELOAD3_IRQn        = 90,               /**< flexpwm0_reload3 interrupt */
  FLEXPWM1_CAPTURE_IRQn        = 91,               /**< flexpwm1_capture interrupt */
  FLEXPWM1_FAULT_IRQn          = 92,               /**< flexpwm1_fault interrupt */
  FLEXPWM1_RELOAD_ERROR_IRQn   = 93,               /**< flexpwm1_reload_error interrupt */
  FLEXPWM1_COMPARE0_IRQn       = 94,               /**< flexpwm1_compare0 interrupt */
  FLEXPWM1_RELOAD0_IRQn        = 95,               /**< flexpwm1_reload0 interrupt */
  FLEXPWM1_COMPARE1_IRQn       = 96,               /**< flexpwm1_compare1 interrupt */
  FLEXPWM1_RELOAD1_IRQn        = 97,               /**< flexpwm1_reload1 interrupt */
  FLEXPWM1_COMPARE2_IRQn       = 98,               /**< flexpwm1_compare2 interrupt */
  FLEXPWM1_RELOAD2_IRQn        = 99,               /**< flexpwm1_reload2 interrupt */
  FLEXPWM1_COMPARE3_IRQn       = 100,              /**< flexpwm1_compare3 interrupt */
  FLEXPWM1_RELOAD3_IRQn        = 101,              /**< flexpwm1_reload3 interrupt */
  ENC0_COMPARE_IRQn            = 102,              /**< enc0_compare interrupt */
  ENC0_HOME_IRQn               = 103,              /**< enc0_home interrupt */
  ENC0_WDG_IRQn                = 104,              /**< enc0_wdg interrupt */
  ENC0_IDX_IRQn                = 105,              /**< enc0_idx interrupt */
  ENC1_COMPARE_IRQn            = 106,              /**< enc1_compare interrupt */
  ENC1_HOME_IRQn               = 107,              /**< enc1_home interrupt */
  ENC1_WDG_IRQn                = 108,              /**< enc1_wdg interrupt */
  ENC1_IDX_IRQn                = 109,              /**< enc1_idx interrupt */
  ITRC0_IRQn                   = 110,              /**< itrc0 interrupt */
  Reserved127_IRQn             = 111,              /**< Reserved interrupt */
  CSSV2_ERR_IRQn               = 112,              /**< cssv2_err interrupt */
  PKC_ERR_IRQn                 = 113,              /**< pkc_err interrupt */
  Reserved130_IRQn             = 114,              /**< Reserved interrupt */
  Reserved131_IRQn             = 115,              /**< Reserved interrupt */
  Reserved132_IRQn             = 116,              /**< Reserved interrupt */
  Reserved133_IRQn             = 117,              /**< Reserved interrupt */
  FLASH_IRQn                   = 118,              /**< flash interrupt */
  RAM_PARITY_ECC_ERR_IRQn      = 119               /**< ram_parity_ecc_err interrupt */
} IRQn_Type;

/*!
 * @}
 */ /* end of group Interrupt_vector_numbers */


/* ----------------------------------------------------------------------------
   -- Cortex M33 Core Configuration
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Cortex_Core_Configuration Cortex M33 Core Configuration
 * @{
 */

#define __MPU_PRESENT                  1         /**< Defines if an MPU is present or not */
#define __NVIC_PRIO_BITS               3         /**< Number of priority bits implemented in the NVIC */
#define __Vendor_SysTickConfig         0         /**< Vendor specific implementation of SysTickConfig is defined */
#define __FPU_PRESENT                  1         /**< Defines if an FPU is present or not */
#define __DSP_PRESENT                  1         /**< Defines if Armv8-M Mainline core supports DSP instructions */
#define __SAUREGION_PRESENT            1         /**< Defines if an SAU is present or not */

#include "core_cm33.h"                 /* Core Peripheral Access Layer */
#include "system_LPC55S36.h"           /* Device specific configuration file */

/*!
 * @}
 */ /* end of group Cortex_Core_Configuration */


/* ----------------------------------------------------------------------------
   -- Mapping Information
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Mapping_Information Mapping Information
 * @{
 */

/** Mapping Information */
/*!
 * @addtogroup dma_request
 * @{
 */

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*!
 * @brief Structure for the DMA hardware request
 *
 * Defines the structure for the DMA hardware request collections. The user can configure the
 * hardware request to trigger the DMA transfer accordingly. The index
 * of the hardware request varies according  to the to SoC.
 */
typedef enum _dma_request_source
{
    kDma0RequestFLEXSPIRX           = 0U,          /**< FlexSPI RX */
    kDma1RequestUnusedDMARequest0   = 0U,          /**< Unused DMA request 0 */
    kDma0RequestFLEXSPITX           = 1U,          /**< FlexSPI TX */
    kDma1RequestUnusedDMARequest1   = 1U,          /**< Unused DMA request 1 */
    kDma0RequestHSSPIRX             = 2U,          /**< HS_SPI RX(Flexcomm Interface 8 RX) */
    kDma1RequestHSLSPIRX            = 2U,          /**< High Speed SPI RX( */
    kDma0RequestHSSPITX             = 3U,          /**< HS_SPI TX(Flexcomm Interface 8 TX) */
    kDma1RequestHSLSPITX            = 3U,          /**< High Speed SPI TX( */
    kDma0RequestFlexcomm0Rx         = 4U,          /**< Flexcomm Interface 0 RX/I2C Slave */
    kDma1RequestFlexcomm0Rx         = 4U,          /**< Flexcomm Interface 0 RX */
    kDma0RequestFlexcomm0Tx         = 5U,          /**< Flexcomm Interface 0 TX/I2C Master */
    kDma1RequestFlexcomm0Tx         = 5U,          /**< Flexcomm Interface 0 TX */
    kDma0RequestFlexcomm1Rx         = 6U,          /**< Flexcomm Interface 1 RX/I2C Slave */
    kDma1RequestFlexcomm1Rx         = 6U,          /**< Flexcomm Interface 1 RX */
    kDma0RequestFlexcomm1Tx         = 7U,          /**< Flexcomm Interface 1 TX/I2C Master */
    kDma1RequestFlexcomm1Tx         = 7U,          /**< Flexcomm Interface 1 TX */
    kDma0RequestFlexcomm3Rx         = 8U,          /**< Flexcomm Interface 3 RX/I2C Slave */
    kDma1RequestFlexcomm3Rx         = 8U,          /**< Flexcomm Interface 3 RX */
    kDma0RequestFlexcomm3Tx         = 9U,          /**< Flexcomm Interface 3 TX/I2C Master */
    kDma1RequestFlexcomm3Tx         = 9U,          /**< Flexcomm Interface 3 TX */
    kDma0RequestFlexcomm2Rx         = 10U,         /**< Flexcomm Interface 2 RX/I2C Slave */
    kDma1RequestDmic0Ch0            = 10U,         /**< DMIC0 CH0 */
    kDma0RequestFlexcomm2Tx         = 11U,         /**< Flexcomm Interface 2 TX/I2C Master */
    kDma1RequestDmic0Ch1            = 11U,         /**< DMIC0 CH1 */
    kDma0RequestFlexcomm4Rx         = 12U,         /**< Flexcomm Interface 4 RX/I2C Slave */
    kDma1RequestI3c0Rx              = 12U,         /**< I3C0 RX */
    kDma0RequestFlexcomm4Tx         = 13U,         /**< Flexcomm Interface 4 TX/I2C Master */
    kDma1RequestI3c0Tx              = 13U,         /**< I3C0 TX */
    kDma0RequestFlexcomm5Rx         = 14U,         /**< Flexcomm Interface 5 RX/I2C Slave */
    kDma1RequestFLEXSPIRX           = 14U,         /**< FlexSpi RX */
    kDma0RequestFlexcomm5Tx         = 15U,         /**< Flexcomm Interface 5 TX/I2C Master */
    kDma1RequestFLEXSPITX           = 15U,         /**< FlexSpi TX */
    kDma0RequestFlexcomm6Rx         = 16U,         /**< Flexcomm Interface 6 RX/I2C Slave */
    kDma0RequestFlexcomm6Tx         = 17U,         /**< Flexcomm Interface 6 TX/I2C Master */
    kDma0RequestFlexcomm7Rx         = 18U,         /**< Flexcomm Interface 7 RX/I2C Slave */
    kDma0RequestFlexcomm7Tx         = 19U,         /**< Flexcomm Interface 7 TX/I2C Master */
    kDma0RequestDAC0                = 20U,         /**< DAC0 */
    kDma0RequestADC0FIFO0           = 21U,         /**< ADC0 FIFO 0 */
    kDma0RequestADC0FIFO1           = 22U,         /**< ADC0 FIFO 1 */
    kDma0RequestDMIC0CH0            = 23U,         /**< DMIC0 channel0 */
    kDma0RequestDMIC0CH1            = 24U,         /**< DMIC0 channel1 */
    kDma0RequestI3C0RX              = 25U,         /**< I3C0 RX */
    kDma0RequestI3C0TX              = 26U,         /**< I3C0 TX */
    kDma0RequestADC1FIFO0           = 27U,         /**< ADC1 FIFO 0 */
    kDma0RequestADC1FIFO1           = 28U,         /**< ADC1 FIFO 1 */
    kDma0RequestDAC1                = 29U,         /**< DAC1 */
    kDma0RequestDAC2                = 30U,         /**< DAC2 */
    kDma0RequestUnusedDMARequest31  = 31U,         /**< Unused DMA request 31 */
    kDma0RequestUnusedDMARequest32  = 32U,         /**< Unused DMA request 32 */
    kDma0RequestUnusedDMARequest33  = 33U,         /**< Unused DMA request 33 */
    kDma0RequestUnusedDMARequest34  = 34U,         /**< Unused DMA request 34 */
    kDma0RequestUnusedDMARequest35  = 35U,         /**< Unused DMA request 35 */
    kDma0RequestUnassignedDMARequest36 = 36U,      /**< Unassigned DMA request 36(but required for FlexPWM0_req_capt0) */
    kDma0RequestUnassignedDMARequest37 = 37U,      /**< Unassigned DMA request 37(but required for FlexPWM0_req_capt1) */
    kDma0RequestUnassignedDMARequest38 = 38U,      /**< Unassigned DMA request 38(but required for FlexPWM0_req_capt2) */
    kDma0RequestUnassignedDMARequest39 = 39U,      /**< Unassigned DMA request 39(but required for FlexPWM0_req_capt3) */
    kDma0RequestUnassignedDMARequest40 = 40U,      /**< Unassigned DMA request 40(but required for FlexPWM0_req_val0) */
    kDma0RequestUnassignedDMARequest41 = 41U,      /**< Unassigned DMA request 41(but required for FlexPWM0_req_val1) */
    kDma0RequestUnassignedDMARequest42 = 42U,      /**< Unassigned DMA request 42(but required for FlexPWM0_req_val2) */
    kDma0RequestUnassignedDMARequest43 = 43U,      /**< Unassigned DMA request 43(but required for FlexPWM0_req_val3) */
    kDma0RequestUnassignedDMARequest44 = 44U,      /**< Unassigned DMA request 44(but required for FlexPWM1_req_capt0) */
    kDma0RequestUnassignedDMARequest45 = 45U,      /**< Unassigned DMA request 45(but required for FlexPWM1_req_capt1) */
    kDma0RequestUnassignedDMARequest46 = 46U,      /**< Unassigned DMA request 46(but required for FlexPWM1_req_capt2) */
    kDma0RequestUnassignedDMARequest47 = 47U,      /**< Unassigned DMA request 47(but required for FlexPWM1_req_capt3) */
    kDma0RequestUnassignedDMARequest48 = 48U,      /**< Unassigned DMA request 48(but required for FlexPWM1_req_val0) */
    kDma0RequestUnassignedDMARequest49 = 49U,      /**< Unassigned DMA request 49(but required for FlexPWM1_req_val1) */
    kDma0RequestUnassignedDMARequest50 = 50U,      /**< Unassigned DMA request 50(but required for FlexPWM1_req_val2) */
    kDma0RequestUnassignedDMARequest51 = 51U,      /**< Unassigned DMA request 51(but required for FlexPWM1_req_val3) */
} dma_request_source_t;

/* @} */


/*!
 * @}
 */ /* end of group Mapping_Information */


/* ----------------------------------------------------------------------------
   -- Device Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Peripheral_access_layer Device Peripheral Access Layer
 * @{
 */


/*
** Start of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #if (__ARMCC_VERSION >= 6010050)
    #pragma clang diagnostic push
  #else
    #pragma push
    #pragma anon_unions
  #endif
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=extended
#else
  #error Not supported compiler type
#endif

/* ----------------------------------------------------------------------------
   -- ADC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Peripheral_Access_Layer ADC Peripheral Access Layer
 * @{
 */

/** ADC - Register Layout Typedef */
typedef struct {
  __I  uint32_t VERID;                             /**< Version ID Register, offset: 0x0 */
  __I  uint32_t PARAM;                             /**< Parameter Register, offset: 0x4 */
       uint8_t RESERVED_0[8];
  __IO uint32_t CTRL;                              /**< ADC Control Register, offset: 0x10 */
  __IO uint32_t STAT;                              /**< ADC Status Register, offset: 0x14 */
  __IO uint32_t IE;                                /**< Interrupt Enable Register, offset: 0x18 */
  __IO uint32_t DE;                                /**< DMA Enable Register, offset: 0x1C */
  __IO uint32_t CFG;                               /**< ADC Configuration Register, offset: 0x20 */
  __IO uint32_t PAUSE;                             /**< ADC Pause Register, offset: 0x24 */
       uint8_t RESERVED_1[12];
  __O  uint32_t SWTRIG;                            /**< Software Trigger Register, offset: 0x34 */
  __IO uint32_t TSTAT;                             /**< Trigger Status Register, offset: 0x38 */
       uint8_t RESERVED_2[4];
  __IO uint32_t OFSTRIM;                           /**< ADC Offset Trim Register, offset: 0x40 */
       uint8_t RESERVED_3[92];
  __IO uint32_t TCTRL[4];                          /**< Trigger Control Register, array offset: 0xA0, array step: 0x4 */
       uint8_t RESERVED_4[48];
  __IO uint32_t FCTRL[2];                          /**< FIFO Control Register, array offset: 0xE0, array step: 0x4 */
       uint8_t RESERVED_5[8];
  __I  uint32_t GCC[2];                            /**< Gain Calibration Control, array offset: 0xF0, array step: 0x4 */
  __IO uint32_t GCR[2];                            /**< Gain Calculation Result, array offset: 0xF8, array step: 0x4 */
  struct {                                         /* offset: 0x100, array step: 0x8 */
    __IO uint32_t CMDL;                              /**< ADC Command Low Buffer Register, array offset: 0x100, array step: 0x8 */
    __IO uint32_t CMDH;                              /**< ADC Command High Buffer Register, array offset: 0x104, array step: 0x8 */
  } CMD[15];
       uint8_t RESERVED_6[136];
  __IO uint32_t CV[15];                            /**< Compare Value Register, array offset: 0x200, array step: 0x4 */
       uint8_t RESERVED_7[196];
  __I  uint32_t RESFIFO[2];                        /**< ADC Data Result FIFO Register, array offset: 0x300, array step: 0x4 */
       uint8_t RESERVED_8[248];
  __IO uint32_t CAL_GAR[33];                       /**< Calibration General A-Side Registers, array offset: 0x400, array step: 0x4 */
       uint8_t RESERVED_9[124];
  __IO uint32_t CAL_GBR[33];                       /**< Calibration General B-Side Registers, array offset: 0x500, array step: 0x4 */
} ADC_Type;

/* ----------------------------------------------------------------------------
   -- ADC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Register_Masks ADC Register Masks
 * @{
 */

/*! @name VERID - Version ID Register */
/*! @{ */

#define ADC_VERID_RES_MASK                       (0x1U)
#define ADC_VERID_RES_SHIFT                      (0U)
/*! RES - Resolution
 *  0b0..Up to 13-bit differential/12-bit single ended resolution supported.
 *  0b1..Up to 16-bit differential/16-bit single ended resolution supported.
 */
#define ADC_VERID_RES(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_VERID_RES_SHIFT)) & ADC_VERID_RES_MASK)

#define ADC_VERID_DIFFEN_MASK                    (0x2U)
#define ADC_VERID_DIFFEN_SHIFT                   (1U)
/*! DIFFEN - Differential Supported
 *  0b0..Differential operation not supported.
 *  0b1..Differential operation supported. CMDLa[CTYPE] controls fields implemented.
 */
#define ADC_VERID_DIFFEN(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_VERID_DIFFEN_SHIFT)) & ADC_VERID_DIFFEN_MASK)

#define ADC_VERID_MVI_MASK                       (0x8U)
#define ADC_VERID_MVI_SHIFT                      (3U)
/*! MVI - Multi Vref Implemented
 *  0b0..Single voltage reference high (VREFH) input supported.
 *  0b1..Multiple voltage reference high (VREFH) inputs supported.
 */
#define ADC_VERID_MVI(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_VERID_MVI_SHIFT)) & ADC_VERID_MVI_MASK)

#define ADC_VERID_CSW_MASK                       (0x70U)
#define ADC_VERID_CSW_SHIFT                      (4U)
/*! CSW - Channel Scale Width
 *  0b000..Channel scaling not supported.
 *  0b001..Channel scaling supported. 1-bit CSCALE control field.
 *  0b110..Channel scaling supported. 6-bit CSCALE control field.
 */
#define ADC_VERID_CSW(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_VERID_CSW_SHIFT)) & ADC_VERID_CSW_MASK)

#define ADC_VERID_VR1RNGI_MASK                   (0x100U)
#define ADC_VERID_VR1RNGI_SHIFT                  (8U)
/*! VR1RNGI - Voltage Reference 1 Range Control Bit Implemented
 *  0b0..Range control not required. CFG[VREF1RNG] is not implemented.
 *  0b1..Range control required. CFG[VREF1RNG] is implemented.
 */
#define ADC_VERID_VR1RNGI(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_VERID_VR1RNGI_SHIFT)) & ADC_VERID_VR1RNGI_MASK)

#define ADC_VERID_IADCKI_MASK                    (0x200U)
#define ADC_VERID_IADCKI_SHIFT                   (9U)
/*! IADCKI - Internal ADC Clock implemented
 *  0b0..Internal clock source not implemented.
 *  0b1..Internal clock source (and CFG[ADCKEN]) implemented.
 */
#define ADC_VERID_IADCKI(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_VERID_IADCKI_SHIFT)) & ADC_VERID_IADCKI_MASK)

#define ADC_VERID_CALOFSI_MASK                   (0x400U)
#define ADC_VERID_CALOFSI_SHIFT                  (10U)
/*! CALOFSI - Calibration Function Implemented
 *  0b0..Calibration Not Implemented.
 *  0b1..Calibration Implemented.
 */
#define ADC_VERID_CALOFSI(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_VERID_CALOFSI_SHIFT)) & ADC_VERID_CALOFSI_MASK)

#define ADC_VERID_NUM_SEC_MASK                   (0x800U)
#define ADC_VERID_NUM_SEC_SHIFT                  (11U)
/*! NUM_SEC - Number of Single Ended Outputs Supported
 *  0b0..This design supports one single ended conversion at a time.
 *  0b1..This design supports two simultanious single ended conversions.
 */
#define ADC_VERID_NUM_SEC(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_VERID_NUM_SEC_SHIFT)) & ADC_VERID_NUM_SEC_MASK)

#define ADC_VERID_NUM_FIFO_MASK                  (0x7000U)
#define ADC_VERID_NUM_FIFO_SHIFT                 (12U)
/*! NUM_FIFO - Number of FIFOs
 *  0b000..N/A
 *  0b001..This design supports one result FIFO.
 *  0b010..This design supports two result FIFOs.
 *  0b011..This design supports three result FIFOs.
 *  0b100..This design supports four result FIFOs.
 */
#define ADC_VERID_NUM_FIFO(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_VERID_NUM_FIFO_SHIFT)) & ADC_VERID_NUM_FIFO_MASK)

#define ADC_VERID_MINOR_MASK                     (0xFF0000U)
#define ADC_VERID_MINOR_SHIFT                    (16U)
/*! MINOR - Minor Version Number
 */
#define ADC_VERID_MINOR(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_VERID_MINOR_SHIFT)) & ADC_VERID_MINOR_MASK)

#define ADC_VERID_MAJOR_MASK                     (0xFF000000U)
#define ADC_VERID_MAJOR_SHIFT                    (24U)
/*! MAJOR - Major Version Number
 */
#define ADC_VERID_MAJOR(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_VERID_MAJOR_SHIFT)) & ADC_VERID_MAJOR_MASK)
/*! @} */

/*! @name PARAM - Parameter Register */
/*! @{ */

#define ADC_PARAM_TRIG_NUM_MASK                  (0xFFU)
#define ADC_PARAM_TRIG_NUM_SHIFT                 (0U)
/*! TRIG_NUM - Trigger Number
 */
#define ADC_PARAM_TRIG_NUM(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_TRIG_NUM_SHIFT)) & ADC_PARAM_TRIG_NUM_MASK)

#define ADC_PARAM_FIFOSIZE_MASK                  (0xFF00U)
#define ADC_PARAM_FIFOSIZE_SHIFT                 (8U)
/*! FIFOSIZE - Result FIFO Depth
 *  0b00000001..Result FIFO depth = 1 dataword.
 *  0b00000100..Result FIFO depth = 4 datawords.
 *  0b00001000..Result FIFO depth = 8 datawords.
 *  0b00010000..Result FIFO depth = 16 datawords.
 *  0b00100000..Result FIFO depth = 32 datawords.
 *  0b01000000..Result FIFO depth = 64 datawords.
 */
#define ADC_PARAM_FIFOSIZE(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_FIFOSIZE_SHIFT)) & ADC_PARAM_FIFOSIZE_MASK)

#define ADC_PARAM_CV_NUM_MASK                    (0xFF0000U)
#define ADC_PARAM_CV_NUM_SHIFT                   (16U)
/*! CV_NUM - Compare Value Number
 */
#define ADC_PARAM_CV_NUM(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_CV_NUM_SHIFT)) & ADC_PARAM_CV_NUM_MASK)

#define ADC_PARAM_CMD_NUM_MASK                   (0xFF000000U)
#define ADC_PARAM_CMD_NUM_SHIFT                  (24U)
/*! CMD_NUM - Command Buffer Number
 */
#define ADC_PARAM_CMD_NUM(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_CMD_NUM_SHIFT)) & ADC_PARAM_CMD_NUM_MASK)
/*! @} */

/*! @name CTRL - ADC Control Register */
/*! @{ */

#define ADC_CTRL_ADCEN_MASK                      (0x1U)
#define ADC_CTRL_ADCEN_SHIFT                     (0U)
/*! ADCEN - ADC Enable
 *  0b0..ADC is disabled.
 *  0b1..ADC is enabled.
 */
#define ADC_CTRL_ADCEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_ADCEN_SHIFT)) & ADC_CTRL_ADCEN_MASK)

#define ADC_CTRL_RST_MASK                        (0x2U)
#define ADC_CTRL_RST_SHIFT                       (1U)
/*! RST - Software Reset
 *  0b0..ADC logic is not reset.
 *  0b1..ADC logic is reset.
 */
#define ADC_CTRL_RST(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_RST_SHIFT)) & ADC_CTRL_RST_MASK)

#define ADC_CTRL_DOZEN_MASK                      (0x4U)
#define ADC_CTRL_DOZEN_SHIFT                     (2U)
/*! DOZEN - Doze Enable
 *  0b0..ADC is enabled in low power mode.
 *  0b1..ADC is disabled in low power mode.
 */
#define ADC_CTRL_DOZEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_DOZEN_SHIFT)) & ADC_CTRL_DOZEN_MASK)

#define ADC_CTRL_CAL_REQ_MASK                    (0x8U)
#define ADC_CTRL_CAL_REQ_SHIFT                   (3U)
/*! CAL_REQ - Auto-Calibration Request
 *  0b0..No request for auto-calibration has been made.
 *  0b1..A request for auto-calibration has been made
 */
#define ADC_CTRL_CAL_REQ(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_CAL_REQ_SHIFT)) & ADC_CTRL_CAL_REQ_MASK)

#define ADC_CTRL_CALOFS_MASK                     (0x10U)
#define ADC_CTRL_CALOFS_SHIFT                    (4U)
/*! CALOFS - Configure for offset calibration function
 *  0b0..Calibration function disabled
 *  0b1..Request for offset calibration function
 */
#define ADC_CTRL_CALOFS(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_CALOFS_SHIFT)) & ADC_CTRL_CALOFS_MASK)

#define ADC_CTRL_RSTFIFO0_MASK                   (0x100U)
#define ADC_CTRL_RSTFIFO0_SHIFT                  (8U)
/*! RSTFIFO0 - Reset FIFO 0
 *  0b0..No effect.
 *  0b1..FIFO 0 is reset.
 */
#define ADC_CTRL_RSTFIFO0(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_RSTFIFO0_SHIFT)) & ADC_CTRL_RSTFIFO0_MASK)

#define ADC_CTRL_RSTFIFO1_MASK                   (0x200U)
#define ADC_CTRL_RSTFIFO1_SHIFT                  (9U)
/*! RSTFIFO1 - Reset FIFO 1
 *  0b0..No effect.
 *  0b1..FIFO 1 is reset.
 */
#define ADC_CTRL_RSTFIFO1(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_RSTFIFO1_SHIFT)) & ADC_CTRL_RSTFIFO1_MASK)

#define ADC_CTRL_CAL_AVGS_MASK                   (0x70000U)
#define ADC_CTRL_CAL_AVGS_SHIFT                  (16U)
/*! CAL_AVGS - Auto-Calibration Averages
 *  0b000..Single conversion.
 *  0b001..2 conversions averaged.
 *  0b010..4 conversions averaged.
 *  0b011..8 conversions averaged.
 *  0b100..16 conversions averaged.
 *  0b101..32 conversions averaged.
 *  0b110..64 conversions averaged.
 *  0b111..128 conversions averaged.
 */
#define ADC_CTRL_CAL_AVGS(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_CAL_AVGS_SHIFT)) & ADC_CTRL_CAL_AVGS_MASK)
/*! @} */

/*! @name STAT - ADC Status Register */
/*! @{ */

#define ADC_STAT_RDY0_MASK                       (0x1U)
#define ADC_STAT_RDY0_SHIFT                      (0U)
/*! RDY0 - Result FIFO 0 Ready Flag
 *  0b0..Result FIFO 0 data level not above watermark level.
 *  0b1..Result FIFO 0 holding data above watermark level.
 */
#define ADC_STAT_RDY0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_STAT_RDY0_SHIFT)) & ADC_STAT_RDY0_MASK)

#define ADC_STAT_FOF0_MASK                       (0x2U)
#define ADC_STAT_FOF0_SHIFT                      (1U)
/*! FOF0 - Result FIFO 0 Overflow Flag
 *  0b0..No result FIFO 0 overflow has occurred since the last time the flag was cleared.
 *  0b1..At least one result FIFO 0 overflow has occurred since the last time the flag was cleared.
 */
#define ADC_STAT_FOF0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_STAT_FOF0_SHIFT)) & ADC_STAT_FOF0_MASK)

#define ADC_STAT_RDY1_MASK                       (0x4U)
#define ADC_STAT_RDY1_SHIFT                      (2U)
/*! RDY1 - Result FIFO1 Ready Flag
 *  0b0..Result FIFO1 data level not above watermark level.
 *  0b1..Result FIFO1 holding data above watermark level.
 */
#define ADC_STAT_RDY1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_STAT_RDY1_SHIFT)) & ADC_STAT_RDY1_MASK)

#define ADC_STAT_FOF1_MASK                       (0x8U)
#define ADC_STAT_FOF1_SHIFT                      (3U)
/*! FOF1 - Result FIFO1 Overflow Flag
 *  0b0..No result FIFO1 overflow has occurred since the last time the flag was cleared.
 *  0b1..At least one result FIFO1 overflow has occurred since the last time the flag was cleared.
 */
#define ADC_STAT_FOF1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_STAT_FOF1_SHIFT)) & ADC_STAT_FOF1_MASK)

#define ADC_STAT_TEXC_INT_MASK                   (0x100U)
#define ADC_STAT_TEXC_INT_SHIFT                  (8U)
/*! TEXC_INT - Interrupt Flag For High Priority Trigger Exception
 *  0b0..No trigger exceptions have occurred.
 *  0b1..A trigger exception has occurred and is pending acknowledgement.
 */
#define ADC_STAT_TEXC_INT(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_STAT_TEXC_INT_SHIFT)) & ADC_STAT_TEXC_INT_MASK)

#define ADC_STAT_TCOMP_INT_MASK                  (0x200U)
#define ADC_STAT_TCOMP_INT_SHIFT                 (9U)
/*! TCOMP_INT - Interrupt Flag For Trigger Completion
 *  0b0..Either IE[TCOMP_IE] is set to 0, or no trigger sequences have run to completion.
 *  0b1..Trigger sequence has been completed and all data is stored in the associated FIFO.
 */
#define ADC_STAT_TCOMP_INT(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_STAT_TCOMP_INT_SHIFT)) & ADC_STAT_TCOMP_INT_MASK)

#define ADC_STAT_CAL_RDY_MASK                    (0x400U)
#define ADC_STAT_CAL_RDY_SHIFT                   (10U)
/*! CAL_RDY - Calibration Ready
 *  0b0..Calibration is incomplete or hasn't been ran.
 *  0b1..The ADC is calibrated.
 */
#define ADC_STAT_CAL_RDY(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_STAT_CAL_RDY_SHIFT)) & ADC_STAT_CAL_RDY_MASK)

#define ADC_STAT_ADC_ACTIVE_MASK                 (0x800U)
#define ADC_STAT_ADC_ACTIVE_SHIFT                (11U)
/*! ADC_ACTIVE - ADC Active
 *  0b0..The ADC is IDLE. There are no pending triggers to service and no active commands are being processed.
 *  0b1..The ADC is processing a conversion, running through the power up delay, or servicing a trigger.
 */
#define ADC_STAT_ADC_ACTIVE(x)                   (((uint32_t)(((uint32_t)(x)) << ADC_STAT_ADC_ACTIVE_SHIFT)) & ADC_STAT_ADC_ACTIVE_MASK)

#define ADC_STAT_TRGACT_MASK                     (0x30000U)
#define ADC_STAT_TRGACT_SHIFT                    (16U)
/*! TRGACT - Trigger Active
 *  0b00..Command (sequence) associated with Trigger 0 currently being executed.
 *  0b01..Command (sequence) associated with Trigger 1 currently being executed.
 *  0b10..Command (sequence) associated with Trigger 2 currently being executed.
 *  0b11..Command (sequence) associated with Trigger 3 currently being executed.
 */
#define ADC_STAT_TRGACT(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_STAT_TRGACT_SHIFT)) & ADC_STAT_TRGACT_MASK)

#define ADC_STAT_CMDACT_MASK                     (0xF000000U)
#define ADC_STAT_CMDACT_SHIFT                    (24U)
/*! CMDACT - Command Active
 *  0b0000..No command is currently in progress.
 *  0b0001..Command 1 currently being executed.
 *  0b0010..Command 2 currently being executed.
 *  0b0011-0b1111..Associated command number is currently being executed.
 */
#define ADC_STAT_CMDACT(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_STAT_CMDACT_SHIFT)) & ADC_STAT_CMDACT_MASK)
/*! @} */

/*! @name IE - Interrupt Enable Register */
/*! @{ */

#define ADC_IE_FWMIE0_MASK                       (0x1U)
#define ADC_IE_FWMIE0_SHIFT                      (0U)
/*! FWMIE0 - FIFO 0 Watermark Interrupt Enable
 *  0b0..FIFO 0 watermark interrupts are not enabled.
 *  0b1..FIFO 0 watermark interrupts are enabled.
 */
#define ADC_IE_FWMIE0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_IE_FWMIE0_SHIFT)) & ADC_IE_FWMIE0_MASK)

#define ADC_IE_FOFIE0_MASK                       (0x2U)
#define ADC_IE_FOFIE0_SHIFT                      (1U)
/*! FOFIE0 - Result FIFO 0 Overflow Interrupt Enable
 *  0b0..FIFO 0 overflow interrupts are not enabled.
 *  0b1..FIFO 0 overflow interrupts are enabled.
 */
#define ADC_IE_FOFIE0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_IE_FOFIE0_SHIFT)) & ADC_IE_FOFIE0_MASK)

#define ADC_IE_FWMIE1_MASK                       (0x4U)
#define ADC_IE_FWMIE1_SHIFT                      (2U)
/*! FWMIE1 - FIFO1 Watermark Interrupt Enable
 *  0b0..FIFO1 watermark interrupts are not enabled.
 *  0b1..FIFO1 watermark interrupts are enabled.
 */
#define ADC_IE_FWMIE1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_IE_FWMIE1_SHIFT)) & ADC_IE_FWMIE1_MASK)

#define ADC_IE_FOFIE1_MASK                       (0x8U)
#define ADC_IE_FOFIE1_SHIFT                      (3U)
/*! FOFIE1 - Result FIFO1 Overflow Interrupt Enable
 *  0b0..No result FIFO1 overflow has occurred since the last time the flag was cleared.
 *  0b1..At least one result FIFO1 overflow has occurred since the last time the flag was cleared.
 */
#define ADC_IE_FOFIE1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_IE_FOFIE1_SHIFT)) & ADC_IE_FOFIE1_MASK)

#define ADC_IE_TEXC_IE_MASK                      (0x100U)
#define ADC_IE_TEXC_IE_SHIFT                     (8U)
/*! TEXC_IE - Trigger Exception Interrupt Enable
 *  0b0..Trigger exception interrupts are disabled.
 *  0b1..Trigger exception interrupts are enabled.
 */
#define ADC_IE_TEXC_IE(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_IE_TEXC_IE_SHIFT)) & ADC_IE_TEXC_IE_MASK)

#define ADC_IE_TCOMP_IE_MASK                     (0xF0000U)
#define ADC_IE_TCOMP_IE_SHIFT                    (16U)
/*! TCOMP_IE - Trigger Completion Interrupt Enable
 *  0b0000..Trigger completion interrupts are disabled.
 *  0b0001..Trigger completion interrupts are enabled for trigger source 0 only.
 *  0b0010..Trigger completion interrupts are enabled for trigger source 1 only.
 *  0b0011-0b1110..Associated trigger completion interrupts are enabled.
 *  0b1111..Trigger completion interrupts are enabled for every trigger source.
 */
#define ADC_IE_TCOMP_IE(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_IE_TCOMP_IE_SHIFT)) & ADC_IE_TCOMP_IE_MASK)
/*! @} */

/*! @name DE - DMA Enable Register */
/*! @{ */

#define ADC_DE_FWMDE0_MASK                       (0x1U)
#define ADC_DE_FWMDE0_SHIFT                      (0U)
/*! FWMDE0 - FIFO 0 Watermark DMA Enable
 *  0b0..DMA request disabled.
 *  0b1..DMA request enabled.
 */
#define ADC_DE_FWMDE0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_DE_FWMDE0_SHIFT)) & ADC_DE_FWMDE0_MASK)

#define ADC_DE_FWMDE1_MASK                       (0x2U)
#define ADC_DE_FWMDE1_SHIFT                      (1U)
/*! FWMDE1 - FIFO1 Watermark DMA Enable
 *  0b0..DMA request disabled.
 *  0b1..DMA request enabled.
 */
#define ADC_DE_FWMDE1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_DE_FWMDE1_SHIFT)) & ADC_DE_FWMDE1_MASK)
/*! @} */

/*! @name CFG - ADC Configuration Register */
/*! @{ */

#define ADC_CFG_TPRICTRL_MASK                    (0x3U)
#define ADC_CFG_TPRICTRL_SHIFT                   (0U)
/*! TPRICTRL - ADC trigger priority control
 *  0b00..If a higher priority trigger is detected during command processing, the current conversion is aborted
 *        and the new command specified by the trigger is started.
 *  0b01..If a higher priority trigger is received during command processing, the current command is stopped after
 *        completing the current conversion. If averaging is enabled, the averaging loop will be completed.
 *        However, CMDHa[LOOP] will be ignored and the higher priority trigger will be serviced.
 *  0b10..If a higher priority trigger is received during command processing, the current command will be
 *        completed (averaging, looping, compare) before servicing the higher priority trigger.
 *  0b11..RESERVED
 */
#define ADC_CFG_TPRICTRL(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_CFG_TPRICTRL_SHIFT)) & ADC_CFG_TPRICTRL_MASK)

#define ADC_CFG_PWRSEL_MASK                      (0x30U)
#define ADC_CFG_PWRSEL_SHIFT                     (4U)
/*! PWRSEL - Power Configuration Select
 *  0b0x..Low power setting.
 *  0b1x..High power setting.
 */
#define ADC_CFG_PWRSEL(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CFG_PWRSEL_SHIFT)) & ADC_CFG_PWRSEL_MASK)

#define ADC_CFG_REFSEL_MASK                      (0xC0U)
#define ADC_CFG_REFSEL_SHIFT                     (6U)
/*! REFSEL - Voltage Reference Selection
 *  0b00..(Default) Option 1 setting.
 *  0b01..Option 2 setting.
 *  0b10..Option 3 setting.
 *  0b11..Reserved
 */
#define ADC_CFG_REFSEL(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CFG_REFSEL_SHIFT)) & ADC_CFG_REFSEL_MASK)

#define ADC_CFG_TRES_MASK                        (0x100U)
#define ADC_CFG_TRES_SHIFT                       (8U)
/*! TRES - Trigger Resume Enable
 *  0b0..Trigger sequences interrupted by a high priority trigger exception are not automatically resumed or restarted.
 *  0b1..Trigger sequences interrupted by a high priority trigger exception are automatically resumed or restarted.
 */
#define ADC_CFG_TRES(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CFG_TRES_SHIFT)) & ADC_CFG_TRES_MASK)

#define ADC_CFG_TCMDRES_MASK                     (0x200U)
#define ADC_CFG_TCMDRES_SHIFT                    (9U)
/*! TCMDRES - Trigger Command Resume
 *  0b0..Trigger sequences interrupted by a high priority trigger exception is automatically restarted.
 *  0b1..Trigger sequences interrupted by a high priority trigger exception is resumed from the command executing before the exception.
 */
#define ADC_CFG_TCMDRES(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_CFG_TCMDRES_SHIFT)) & ADC_CFG_TCMDRES_MASK)

#define ADC_CFG_HPT_EXDI_MASK                    (0x400U)
#define ADC_CFG_HPT_EXDI_SHIFT                   (10U)
/*! HPT_EXDI - High Priority Trigger Exception Disable
 *  0b0..High priority trigger exceptions are enabled.
 *  0b1..High priority trigger exceptions are disabled.
 */
#define ADC_CFG_HPT_EXDI(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_CFG_HPT_EXDI_SHIFT)) & ADC_CFG_HPT_EXDI_MASK)

#define ADC_CFG_PUDLY_MASK                       (0xFF0000U)
#define ADC_CFG_PUDLY_SHIFT                      (16U)
/*! PUDLY - Power Up Delay
 */
#define ADC_CFG_PUDLY(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CFG_PUDLY_SHIFT)) & ADC_CFG_PUDLY_MASK)

#define ADC_CFG_PWREN_MASK                       (0x10000000U)
#define ADC_CFG_PWREN_SHIFT                      (28U)
/*! PWREN - ADC Analog Pre-Enable
 *  0b0..ADC analog circuits are only enabled while conversions are active. Performance is affected due to analog startup delays.
 *  0b1..ADC analog circuits are pre-enabled and ready to execute conversions without startup delays (at the cost
 *       of higher DC current consumption). A single power up delay (CFG[PUDLY]) is executed immediately once PWREN
 *       is set, and any detected trigger does not begin ADC operation until the power up delay time has passed.
 *       After this initial delay expires the analog will remain pre-enabled, and no additional delays will be
 *       executed.
 */
#define ADC_CFG_PWREN(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CFG_PWREN_SHIFT)) & ADC_CFG_PWREN_MASK)
/*! @} */

/*! @name PAUSE - ADC Pause Register */
/*! @{ */

#define ADC_PAUSE_PAUSEDLY_MASK                  (0x1FFU)
#define ADC_PAUSE_PAUSEDLY_SHIFT                 (0U)
/*! PAUSEDLY - Pause Delay
 */
#define ADC_PAUSE_PAUSEDLY(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_PAUSE_PAUSEDLY_SHIFT)) & ADC_PAUSE_PAUSEDLY_MASK)

#define ADC_PAUSE_PAUSEEN_MASK                   (0x80000000U)
#define ADC_PAUSE_PAUSEEN_SHIFT                  (31U)
/*! PAUSEEN - PAUSE Option Enable
 *  0b0..Pause operation disabled
 *  0b1..Pause operation enabled
 */
#define ADC_PAUSE_PAUSEEN(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_PAUSE_PAUSEEN_SHIFT)) & ADC_PAUSE_PAUSEEN_MASK)
/*! @} */

/*! @name SWTRIG - Software Trigger Register */
/*! @{ */

#define ADC_SWTRIG_SWT0_MASK                     (0x1U)
#define ADC_SWTRIG_SWT0_SHIFT                    (0U)
/*! SWT0 - Software trigger 0 event
 *  0b0..No trigger 0 event generated.
 *  0b1..Trigger 0 event generated.
 */
#define ADC_SWTRIG_SWT0(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT0_SHIFT)) & ADC_SWTRIG_SWT0_MASK)

#define ADC_SWTRIG_SWT1_MASK                     (0x2U)
#define ADC_SWTRIG_SWT1_SHIFT                    (1U)
/*! SWT1 - Software trigger 1 event
 *  0b0..No trigger 1 event generated.
 *  0b1..Trigger 1 event generated.
 */
#define ADC_SWTRIG_SWT1(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT1_SHIFT)) & ADC_SWTRIG_SWT1_MASK)

#define ADC_SWTRIG_SWT2_MASK                     (0x4U)
#define ADC_SWTRIG_SWT2_SHIFT                    (2U)
/*! SWT2 - Software trigger 2 event
 *  0b0..No trigger 2 event generated.
 *  0b1..Trigger 2 event generated.
 */
#define ADC_SWTRIG_SWT2(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT2_SHIFT)) & ADC_SWTRIG_SWT2_MASK)

#define ADC_SWTRIG_SWT3_MASK                     (0x8U)
#define ADC_SWTRIG_SWT3_SHIFT                    (3U)
/*! SWT3 - Software trigger 3 event
 *  0b0..No trigger 3 event generated.
 *  0b1..Trigger 3 event generated.
 */
#define ADC_SWTRIG_SWT3(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT3_SHIFT)) & ADC_SWTRIG_SWT3_MASK)
/*! @} */

/*! @name TSTAT - Trigger Status Register */
/*! @{ */

#define ADC_TSTAT_TEXC_NUM_MASK                  (0xFU)
#define ADC_TSTAT_TEXC_NUM_SHIFT                 (0U)
/*! TEXC_NUM - Trigger Exception Number
 *  0b0000..No triggers have been interrupted by a high priority exception. Or CFG[TRES] = 1.
 *  0b0001..Trigger 0 has been interrupted by a high priority exception.
 *  0b0010..Trigger 1 has been interrupted by a high priority exception.
 *  0b0011-0b1110..Associated trigger sequence has interrupted by a high priority exception.
 *  0b1111..Every trigger sequence has been interrupted by a high priority exception.
 */
#define ADC_TSTAT_TEXC_NUM(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_TSTAT_TEXC_NUM_SHIFT)) & ADC_TSTAT_TEXC_NUM_MASK)

#define ADC_TSTAT_TCOMP_FLAG_MASK                (0xF0000U)
#define ADC_TSTAT_TCOMP_FLAG_SHIFT               (16U)
/*! TCOMP_FLAG - Trigger Completion Flag
 *  0b0000..No triggers have been completed. Trigger completion interrupts are disabled.
 *  0b0001..Trigger 0 has been completed and triger 0 has enabled completion interrupts.
 *  0b0010..Trigger 1 has been completed and triger 1 has enabled completion interrupts.
 *  0b0011-0b1110..Associated trigger sequence has completed and has enabled completion interrupts.
 *  0b1111..Every trigger sequence has been completed and every trigger has enabled completion interrupts.
 */
#define ADC_TSTAT_TCOMP_FLAG(x)                  (((uint32_t)(((uint32_t)(x)) << ADC_TSTAT_TCOMP_FLAG_SHIFT)) & ADC_TSTAT_TCOMP_FLAG_MASK)
/*! @} */

/*! @name OFSTRIM - ADC Offset Trim Register */
/*! @{ */

#define ADC_OFSTRIM_OFSTRIM_A_MASK               (0x1FU)
#define ADC_OFSTRIM_OFSTRIM_A_SHIFT              (0U)
/*! OFSTRIM_A - Trim for offset
 */
#define ADC_OFSTRIM_OFSTRIM_A(x)                 (((uint32_t)(((uint32_t)(x)) << ADC_OFSTRIM_OFSTRIM_A_SHIFT)) & ADC_OFSTRIM_OFSTRIM_A_MASK)

#define ADC_OFSTRIM_OFSTRIM_B_MASK               (0x1F0000U)
#define ADC_OFSTRIM_OFSTRIM_B_SHIFT              (16U)
/*! OFSTRIM_B - Trim for offset
 */
#define ADC_OFSTRIM_OFSTRIM_B(x)                 (((uint32_t)(((uint32_t)(x)) << ADC_OFSTRIM_OFSTRIM_B_SHIFT)) & ADC_OFSTRIM_OFSTRIM_B_MASK)
/*! @} */

/*! @name TCTRL - Trigger Control Register */
/*! @{ */

#define ADC_TCTRL_HTEN_MASK                      (0x1U)
#define ADC_TCTRL_HTEN_SHIFT                     (0U)
/*! HTEN - Trigger enable
 *  0b0..Hardware trigger source disabled
 *  0b1..Hardware trigger source enabled
 */
#define ADC_TCTRL_HTEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_HTEN_SHIFT)) & ADC_TCTRL_HTEN_MASK)

#define ADC_TCTRL_FIFO_SEL_A_MASK                (0x2U)
#define ADC_TCTRL_FIFO_SEL_A_SHIFT               (1U)
/*! FIFO_SEL_A - SAR Result Destination For Channel A
 *  0b0..Result written to FIFO 0
 *  0b1..Result written to FIFO 1
 */
#define ADC_TCTRL_FIFO_SEL_A(x)                  (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_FIFO_SEL_A_SHIFT)) & ADC_TCTRL_FIFO_SEL_A_MASK)

#define ADC_TCTRL_FIFO_SEL_B_MASK                (0x4U)
#define ADC_TCTRL_FIFO_SEL_B_SHIFT               (2U)
/*! FIFO_SEL_B - SAR Result Destination For Channel B
 *  0b0..Result written to FIFO 0
 *  0b1..Result written to FIFO 1
 */
#define ADC_TCTRL_FIFO_SEL_B(x)                  (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_FIFO_SEL_B_SHIFT)) & ADC_TCTRL_FIFO_SEL_B_MASK)

#define ADC_TCTRL_TPRI_MASK                      (0x300U)
#define ADC_TCTRL_TPRI_SHIFT                     (8U)
/*! TPRI - Trigger priority setting
 *  0b00..Set to highest priority, Level 1
 *  0b01-0b10..Set to corresponding priority level
 *  0b11..Set to lowest priority, Level 4
 */
#define ADC_TCTRL_TPRI(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_TPRI_SHIFT)) & ADC_TCTRL_TPRI_MASK)

#define ADC_TCTRL_RSYNC_MASK                     (0x8000U)
#define ADC_TCTRL_RSYNC_SHIFT                    (15U)
/*! RSYNC - Trigger Resync
 */
#define ADC_TCTRL_RSYNC(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_RSYNC_SHIFT)) & ADC_TCTRL_RSYNC_MASK)

#define ADC_TCTRL_TDLY_MASK                      (0xF0000U)
#define ADC_TCTRL_TDLY_SHIFT                     (16U)
/*! TDLY - Trigger delay select
 */
#define ADC_TCTRL_TDLY(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_TDLY_SHIFT)) & ADC_TCTRL_TDLY_MASK)

#define ADC_TCTRL_TCMD_MASK                      (0xF000000U)
#define ADC_TCTRL_TCMD_SHIFT                     (24U)
/*! TCMD - Trigger command select
 *  0b0000..Not a valid selection from the command buffer. Trigger event is ignored.
 *  0b0001..CMD1 is executed
 *  0b0010-0b1110..Corresponding CMD is executed
 *  0b1111..CMD15 is executed
 */
#define ADC_TCTRL_TCMD(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_TCMD_SHIFT)) & ADC_TCTRL_TCMD_MASK)
/*! @} */

/* The count of ADC_TCTRL */
#define ADC_TCTRL_COUNT                          (4U)

/*! @name FCTRL - FIFO Control Register */
/*! @{ */

#define ADC_FCTRL_FCOUNT_MASK                    (0x1FU)
#define ADC_FCTRL_FCOUNT_SHIFT                   (0U)
/*! FCOUNT - Result FIFO counter
 */
#define ADC_FCTRL_FCOUNT(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_FCTRL_FCOUNT_SHIFT)) & ADC_FCTRL_FCOUNT_MASK)

#define ADC_FCTRL_FWMARK_MASK                    (0xF0000U)
#define ADC_FCTRL_FWMARK_SHIFT                   (16U)
/*! FWMARK - Watermark level selection
 */
#define ADC_FCTRL_FWMARK(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_FCTRL_FWMARK_SHIFT)) & ADC_FCTRL_FWMARK_MASK)
/*! @} */

/* The count of ADC_FCTRL */
#define ADC_FCTRL_COUNT                          (2U)

/*! @name GCC - Gain Calibration Control */
/*! @{ */

#define ADC_GCC_GAIN_CAL_MASK                    (0xFFFFU)
#define ADC_GCC_GAIN_CAL_SHIFT                   (0U)
/*! GAIN_CAL - Gain Calibration Value
 */
#define ADC_GCC_GAIN_CAL(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_GCC_GAIN_CAL_SHIFT)) & ADC_GCC_GAIN_CAL_MASK)

#define ADC_GCC_RDY_MASK                         (0x1000000U)
#define ADC_GCC_RDY_SHIFT                        (24U)
/*! RDY - Gain Calibration Value Valid
 *  0b0..The gain calibration value is invalid. Run the auto-calibration routine for this value to be written.
 *  0b1..The gain calibration value is valid. It should be used to update the GCRa[GCALR] register field.
 */
#define ADC_GCC_RDY(x)                           (((uint32_t)(((uint32_t)(x)) << ADC_GCC_RDY_SHIFT)) & ADC_GCC_RDY_MASK)
/*! @} */

/* The count of ADC_GCC */
#define ADC_GCC_COUNT                            (2U)

/*! @name GCR - Gain Calculation Result */
/*! @{ */

#define ADC_GCR_GCALR_MASK                       (0xFFFFU)
#define ADC_GCR_GCALR_SHIFT                      (0U)
/*! GCALR - Gain Calculation Result
 */
#define ADC_GCR_GCALR(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_GCR_GCALR_SHIFT)) & ADC_GCR_GCALR_MASK)

#define ADC_GCR_RDY_MASK                         (0x1000000U)
#define ADC_GCR_RDY_SHIFT                        (24U)
/*! RDY - Gain Calculation Ready
 *  0b0..The gain offset calculation value is invalid.
 *  0b1..The gain calibration value is valid.
 */
#define ADC_GCR_RDY(x)                           (((uint32_t)(((uint32_t)(x)) << ADC_GCR_RDY_SHIFT)) & ADC_GCR_RDY_MASK)
/*! @} */

/* The count of ADC_GCR */
#define ADC_GCR_COUNT                            (2U)

/*! @name CMDL - ADC Command Low Buffer Register */
/*! @{ */

#define ADC_CMDL_ADCH_MASK                       (0x1FU)
#define ADC_CMDL_ADCH_SHIFT                      (0U)
/*! ADCH - Input channel select
 *  0b00000..Select CH0A or CH0B or CH0A/CH0B pair.
 *  0b00001..Select CH1A or CH1B or CH1A/CH1B pair.
 *  0b00010..Select CH2A or CH2B or CH2A/CH2B pair.
 *  0b00011..Select CH3A or CH3B or CH3A/CH3B pair.
 *  0b00100-0b11101..Select corresponding channel CHnA or CHnB or CHnA/CHnB pair.
 *  0b11110..Select CH30A or CH30B or CH30A/CH30B pair.
 *  0b11111..Select CH31A or CH31B or CH31A/CH31B pair.
 */
#define ADC_CMDL_ADCH(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_ADCH_SHIFT)) & ADC_CMDL_ADCH_MASK)

#define ADC_CMDL_CTYPE_MASK                      (0x60U)
#define ADC_CMDL_CTYPE_SHIFT                     (5U)
/*! CTYPE - Conversion Type
 *  0b00..Single-Ended Mode. Only A side channel is converted.
 *  0b01..Single-Ended Mode. Only B side channel is converted.
 *  0b10..Differential Mode. A-B.
 *  0b11..Dual-Single-Ended Mode. Both A side and B side channels are converted independently.
 */
#define ADC_CMDL_CTYPE(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_CTYPE_SHIFT)) & ADC_CMDL_CTYPE_MASK)

#define ADC_CMDL_MODE_MASK                       (0x80U)
#define ADC_CMDL_MODE_SHIFT                      (7U)
/*! MODE - Select resolution of conversions
 *  0b0..Standard resolution. Single-ended 12-bit conversion; Differential 13-bit conversion with 2's complement output.
 *  0b1..High resolution. Single-ended 16-bit conversion; Differential 16-bit conversion with 2's complement output.
 */
#define ADC_CMDL_MODE(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_MODE_SHIFT)) & ADC_CMDL_MODE_MASK)

#define ADC_CMDL_ALTB_ADCH_MASK                  (0x1F0000U)
#define ADC_CMDL_ALTB_ADCH_SHIFT                 (16U)
/*! ALTB_ADCH - Alternate Channel B Input channel select
 *  0b00000..Select CH0B
 *  0b00001..Select CH1B
 *  0b00010..Select CH2B
 *  0b00011..Select CH3B
 *  0b00100-0b11101..Select corresponding channel CHnB
 *  0b11110..Select CH30B
 *  0b11111..Select CH31B
 */
#define ADC_CMDL_ALTB_ADCH(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_ALTB_ADCH_SHIFT)) & ADC_CMDL_ALTB_ADCH_MASK)

#define ADC_CMDL_ALTBEN_MASK                     (0x200000U)
#define ADC_CMDL_ALTBEN_SHIFT                    (21U)
/*! ALTBEN - Alternate Channel B Select Enable
 *  0b0..ALTBEN_ADCH disabled. Channel A and Channel B inputs are selected based on ADCH settings.
 *  0b1..ALTBEN_ADCH enabled. Channel A inputs selected by ADCH setting and Channel B inputs selected by ALTB_ADCH setting.
 */
#define ADC_CMDL_ALTBEN(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_ALTBEN_SHIFT)) & ADC_CMDL_ALTBEN_MASK)
/*! @} */

/* The count of ADC_CMDL */
#define ADC_CMDL_COUNT                           (15U)

/*! @name CMDH - ADC Command High Buffer Register */
/*! @{ */

#define ADC_CMDH_CMPEN_MASK                      (0x3U)
#define ADC_CMDH_CMPEN_SHIFT                     (0U)
/*! CMPEN - Compare Function Enable
 *  0b00..Compare disabled.
 *  0b01..Reserved
 *  0b10..Compare enabled. Store on true.
 *  0b11..Compare enabled. Repeat channel acquisition (sample/convert/compare) until true.
 */
#define ADC_CMDH_CMPEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_CMPEN_SHIFT)) & ADC_CMDH_CMPEN_MASK)

#define ADC_CMDH_WAIT_TRIG_MASK                  (0x4U)
#define ADC_CMDH_WAIT_TRIG_SHIFT                 (2U)
/*! WAIT_TRIG - Wait for trigger assertion before execution.
 *  0b0..This command will be automatically executed.
 *  0b1..The active trigger must be asserted again before executing this command.
 */
#define ADC_CMDH_WAIT_TRIG(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_WAIT_TRIG_SHIFT)) & ADC_CMDH_WAIT_TRIG_MASK)

#define ADC_CMDH_LWI_MASK                        (0x80U)
#define ADC_CMDH_LWI_SHIFT                       (7U)
/*! LWI - Loop with Increment
 *  0b0..Auto channel increment disabled
 *  0b1..Auto channel increment enabled
 */
#define ADC_CMDH_LWI(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_LWI_SHIFT)) & ADC_CMDH_LWI_MASK)

#define ADC_CMDH_STS_MASK                        (0x700U)
#define ADC_CMDH_STS_SHIFT                       (8U)
/*! STS - Sample Time Select
 *  0b000..Minimum sample time of 3.5 ADCK cycles.
 *  0b001..3.5 + 21 ADCK cycles; 5.5 ADCK cycles total sample time.
 *  0b010..3.5 + 22 ADCK cycles; 7.5 ADCK cycles total sample time.
 *  0b011..3.5 + 23 ADCK cycles; 11.5 ADCK cycles total sample time.
 *  0b100..3.5 + 24 ADCK cycles; 19.5 ADCK cycles total sample time.
 *  0b101..3.5 + 25 ADCK cycles; 35.5 ADCK cycles total sample time.
 *  0b110..3.5 + 26 ADCK cycles; 67.5 ADCK cycles total sample time.
 *  0b111..3.5 + 27 ADCK cycles; 131.5 ADCK cycles total sample time.
 */
#define ADC_CMDH_STS(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_STS_SHIFT)) & ADC_CMDH_STS_MASK)

#define ADC_CMDH_AVGS_MASK                       (0x7000U)
#define ADC_CMDH_AVGS_SHIFT                      (12U)
/*! AVGS - Hardware Average Select
 *  0b000..Single conversion.
 *  0b001..2 conversions averaged.
 *  0b010..4 conversions averaged.
 *  0b011..8 conversions averaged.
 *  0b100..16 conversions averaged.
 *  0b101..32 conversions averaged.
 *  0b110..64 conversions averaged.
 *  0b111..128 conversions averaged.
 */
#define ADC_CMDH_AVGS(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_AVGS_SHIFT)) & ADC_CMDH_AVGS_MASK)

#define ADC_CMDH_LOOP_MASK                       (0xF0000U)
#define ADC_CMDH_LOOP_SHIFT                      (16U)
/*! LOOP - Loop Count Select
 *  0b0000..Looping not enabled. Command executes 1 time.
 *  0b0001..Loop 1 time. Command executes 2 times.
 *  0b0010..Loop 2 times. Command executes 3 times.
 *  0b0011-0b1110..Loop corresponding number of times. Command executes LOOP+1 times.
 *  0b1111..Loop 15 times. Command executes 16 times.
 */
#define ADC_CMDH_LOOP(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_LOOP_SHIFT)) & ADC_CMDH_LOOP_MASK)

#define ADC_CMDH_NEXT_MASK                       (0xF000000U)
#define ADC_CMDH_NEXT_SHIFT                      (24U)
/*! NEXT - Next Command Select
 *  0b0000..No next command defined. Terminate conversions at completion of current command. If lower priority
 *          trigger pending, begin command associated with lower priority trigger.
 *  0b0001..Select CMD1 command buffer register as next command.
 *  0b0010-0b1110..Select corresponding CMD command buffer register as next command
 *  0b1111..Select CMD15 command buffer register as next command.
 */
#define ADC_CMDH_NEXT(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_NEXT_SHIFT)) & ADC_CMDH_NEXT_MASK)
/*! @} */

/* The count of ADC_CMDH */
#define ADC_CMDH_COUNT                           (15U)

/*! @name CV - Compare Value Register */
/*! @{ */

#define ADC_CV_CVL_MASK                          (0xFFFFU)
#define ADC_CV_CVL_SHIFT                         (0U)
/*! CVL - Compare Value Low.
 */
#define ADC_CV_CVL(x)                            (((uint32_t)(((uint32_t)(x)) << ADC_CV_CVL_SHIFT)) & ADC_CV_CVL_MASK)

#define ADC_CV_CVH_MASK                          (0xFFFF0000U)
#define ADC_CV_CVH_SHIFT                         (16U)
/*! CVH - Compare Value High.
 */
#define ADC_CV_CVH(x)                            (((uint32_t)(((uint32_t)(x)) << ADC_CV_CVH_SHIFT)) & ADC_CV_CVH_MASK)
/*! @} */

/* The count of ADC_CV */
#define ADC_CV_COUNT                             (15U)

/*! @name RESFIFO - ADC Data Result FIFO Register */
/*! @{ */

#define ADC_RESFIFO_D_MASK                       (0xFFFFU)
#define ADC_RESFIFO_D_SHIFT                      (0U)
/*! D - Data result
 */
#define ADC_RESFIFO_D(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_D_SHIFT)) & ADC_RESFIFO_D_MASK)

#define ADC_RESFIFO_TSRC_MASK                    (0x30000U)
#define ADC_RESFIFO_TSRC_SHIFT                   (16U)
/*! TSRC - Trigger Source
 *  0b00..Trigger source 0 initiated this conversion.
 *  0b01..Trigger source 1 initiated this conversion.
 *  0b10-0b10..Corresponding trigger source initiated this conversion.
 *  0b11..Trigger source 3 initiated this conversion.
 */
#define ADC_RESFIFO_TSRC(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_TSRC_SHIFT)) & ADC_RESFIFO_TSRC_MASK)

#define ADC_RESFIFO_LOOPCNT_MASK                 (0xF00000U)
#define ADC_RESFIFO_LOOPCNT_SHIFT                (20U)
/*! LOOPCNT - Loop count value
 *  0b0000..Result is from initial conversion in command.
 *  0b0001..Result is from second conversion in command.
 *  0b0010-0b1110..Result is from LOOPCNT+1 conversion in command.
 *  0b1111..Result is from 16th conversion in command.
 */
#define ADC_RESFIFO_LOOPCNT(x)                   (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_LOOPCNT_SHIFT)) & ADC_RESFIFO_LOOPCNT_MASK)

#define ADC_RESFIFO_CMDSRC_MASK                  (0xF000000U)
#define ADC_RESFIFO_CMDSRC_SHIFT                 (24U)
/*! CMDSRC - Command Buffer Source
 *  0b0000..Not a valid value CMDSRC value for a dataword in RESFIFO. 0x0 is only found in initial FIFO state
 *          prior to an ADC conversion result dataword being stored to a RESFIFO buffer.
 *  0b0001..CMD1 buffer used as control settings for this conversion.
 *  0b0010-0b1110..Corresponding command buffer used as control settings for this conversion.
 *  0b1111..CMD15 buffer used as control settings for this conversion.
 */
#define ADC_RESFIFO_CMDSRC(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_CMDSRC_SHIFT)) & ADC_RESFIFO_CMDSRC_MASK)

#define ADC_RESFIFO_VALID_MASK                   (0x80000000U)
#define ADC_RESFIFO_VALID_SHIFT                  (31U)
/*! VALID - FIFO entry is valid
 *  0b0..FIFO is empty. Discard any read from RESFIFO.
 *  0b1..FIFO record read from RESFIFO is valid.
 */
#define ADC_RESFIFO_VALID(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_VALID_SHIFT)) & ADC_RESFIFO_VALID_MASK)
/*! @} */

/* The count of ADC_RESFIFO */
#define ADC_RESFIFO_COUNT                        (2U)

/*! @name CAL_GAR - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR_CAL_GAR_VAL_MASK             (0xFFFFU)
#define ADC_CAL_GAR_CAL_GAR_VAL_SHIFT            (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR_CAL_GAR_VAL(x)               (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR_CAL_GAR_VAL_MASK)
/*! @} */

/* The count of ADC_CAL_GAR */
#define ADC_CAL_GAR_COUNT                        (33U)

/*! @name CAL_GBR - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR_CAL_GBR_VAL_MASK             (0xFFFFU)
#define ADC_CAL_GBR_CAL_GBR_VAL_SHIFT            (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR_CAL_GBR_VAL(x)               (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR_CAL_GBR_VAL_MASK)
/*! @} */

/* The count of ADC_CAL_GBR */
#define ADC_CAL_GBR_COUNT                        (33U)


/*!
 * @}
 */ /* end of group ADC_Register_Masks */


/* ADC - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral ADC0 base address */
  #define ADC0_BASE                                (0x500A0000u)
  /** Peripheral ADC0 base address */
  #define ADC0_BASE_NS                             (0x400A0000u)
  /** Peripheral ADC0 base pointer */
  #define ADC0                                     ((ADC_Type *)ADC0_BASE)
  /** Peripheral ADC0 base pointer */
  #define ADC0_NS                                  ((ADC_Type *)ADC0_BASE_NS)
  /** Peripheral ADC1 base address */
  #define ADC1_BASE                                (0x500B1000u)
  /** Peripheral ADC1 base address */
  #define ADC1_BASE_NS                             (0x400B1000u)
  /** Peripheral ADC1 base pointer */
  #define ADC1                                     ((ADC_Type *)ADC1_BASE)
  /** Peripheral ADC1 base pointer */
  #define ADC1_NS                                  ((ADC_Type *)ADC1_BASE_NS)
  /** Array initializer of ADC peripheral base addresses */
  #define ADC_BASE_ADDRS                           { ADC0_BASE, ADC1_BASE }
  /** Array initializer of ADC peripheral base pointers */
  #define ADC_BASE_PTRS                            { ADC0, ADC1 }
  /** Array initializer of ADC peripheral base addresses */
  #define ADC_BASE_ADDRS_NS                        { ADC0_BASE_NS, ADC1_BASE_NS }
  /** Array initializer of ADC peripheral base pointers */
  #define ADC_BASE_PTRS_NS                         { ADC0_NS, ADC1_NS }
#else
  /** Peripheral ADC0 base address */
  #define ADC0_BASE                                (0x400A0000u)
  /** Peripheral ADC0 base pointer */
  #define ADC0                                     ((ADC_Type *)ADC0_BASE)
  /** Peripheral ADC1 base address */
  #define ADC1_BASE                                (0x400B1000u)
  /** Peripheral ADC1 base pointer */
  #define ADC1                                     ((ADC_Type *)ADC1_BASE)
  /** Array initializer of ADC peripheral base addresses */
  #define ADC_BASE_ADDRS                           { ADC0_BASE, ADC1_BASE }
  /** Array initializer of ADC peripheral base pointers */
  #define ADC_BASE_PTRS                            { ADC0, ADC1 }
#endif
/** Interrupt vectors for the ADC peripheral type */
#define ADC_IRQS                                 { ADC0_IRQn, ADC1_IRQn }

/*!
 * @}
 */ /* end of group ADC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- ANACTRL Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ANACTRL_Peripheral_Access_Layer ANACTRL Peripheral Access Layer
 * @{
 */

/** ANACTRL - Register Layout Typedef */
typedef struct {
  __IO uint32_t ANALOG_CTRL_CFG;                   /**< Various Analog blocks configuration (like FRO 192MHz trimmings source ...), offset: 0x0 */
  __I  uint32_t ANALOG_CTRL_STATUS;                /**< Analog Control and Status, offset: 0x4 */
       uint8_t RESERVED_0[8];
  __IO uint32_t FRO192M_CTRL;                      /**< 192MHz Free Running Oscillator (FRO) Control, offset: 0x10 */
  __I  uint32_t FRO192M_STATUS;                    /**< 192MHz Free Running Oscillator (FRO) Status, offset: 0x14 */
  __IO uint32_t ADC_CTRL;                          /**< General Purpose ADC VBAT Divider branch control, offset: 0x18 */
       uint8_t RESERVED_1[4];
  __IO uint32_t XO32M_CTRL;                        /**< High speed Crystal Oscillator Control register, offset: 0x20 */
  __I  uint32_t XO32M_STATUS;                      /**< High speed Crystal Oscillator Status, offset: 0x24 */
       uint8_t RESERVED_2[8];
  __IO uint32_t BOD_DCDC_INT_CTRL;                 /**< Brown Out Detectors & DCDC interrupt control, offset: 0x30 */
  __I  uint32_t BOD_DCDC_INT_STATUS;               /**< BoDs & DCDC interrupt status, offset: 0x34 */
       uint8_t RESERVED_3[120];
  __IO uint32_t LDO_XO32M;                         /**< High Speed Crystal Oscillator (12 MHz - 32 MHz) Voltage Source Supply Control register, offset: 0xB0 */
  __IO uint32_t AUX_BIAS;                          /**< AUX_BIAS, offset: 0xB4 */
       uint8_t RESERVED_4[56];
  __IO uint32_t OSC_TESTBUS;                       /**< Oscillators Analog Macrobloc ACBUS and DCBUS control, offset: 0xF0 */
       uint8_t RESERVED_5[4];
  __IO uint32_t DUMMY_CTRL;                        /**< Dummy Control bus to analog modules, offset: 0xF8 */
} ANACTRL_Type;

/* ----------------------------------------------------------------------------
   -- ANACTRL Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ANACTRL_Register_Masks ANACTRL Register Masks
 * @{
 */

/*! @name ANALOG_CTRL_CFG - Various Analog blocks configuration (like FRO 192MHz trimmings source ...) */
/*! @{ */

#define ANACTRL_ANALOG_CTRL_CFG_FRO192M_TRIM_SRC_MASK (0x1U)
#define ANACTRL_ANALOG_CTRL_CFG_FRO192M_TRIM_SRC_SHIFT (0U)
/*! FRO192M_TRIM_SRC - FRO192M trimming and 'Enable' source.
 *  0b0..FRO192M trimming and 'Enable' comes from eFUSE.
 *  0b1..FRO192M trimming and 'Enable' comes from FRO192M_CTRL registers.
 */
#define ANACTRL_ANALOG_CTRL_CFG_FRO192M_TRIM_SRC(x) (((uint32_t)(((uint32_t)(x)) << ANACTRL_ANALOG_CTRL_CFG_FRO192M_TRIM_SRC_SHIFT)) & ANACTRL_ANALOG_CTRL_CFG_FRO192M_TRIM_SRC_MASK)
/*! @} */

/*! @name ANALOG_CTRL_STATUS - Analog Control and Status */
/*! @{ */

#define ANACTRL_ANALOG_CTRL_STATUS_FLASH_PWRDWN_MASK (0x1000U)
#define ANACTRL_ANALOG_CTRL_STATUS_FLASH_PWRDWN_SHIFT (12U)
/*! FLASH_PWRDWN - Flash Power Down status
 *  0b0..Not in power down mode.
 *  0b1..In power down mode.
 */
#define ANACTRL_ANALOG_CTRL_STATUS_FLASH_PWRDWN(x) (((uint32_t)(((uint32_t)(x)) << ANACTRL_ANALOG_CTRL_STATUS_FLASH_PWRDWN_SHIFT)) & ANACTRL_ANALOG_CTRL_STATUS_FLASH_PWRDWN_MASK)

#define ANACTRL_ANALOG_CTRL_STATUS_FLASH_INIT_ERROR_MASK (0x2000U)
#define ANACTRL_ANALOG_CTRL_STATUS_FLASH_INIT_ERROR_SHIFT (13U)
/*! FLASH_INIT_ERROR - Flash initialization error status
 *  0b0..No error
 *  0b1..At least one error occurred
 */
#define ANACTRL_ANALOG_CTRL_STATUS_FLASH_INIT_ERROR(x) (((uint32_t)(((uint32_t)(x)) << ANACTRL_ANALOG_CTRL_STATUS_FLASH_INIT_ERROR_SHIFT)) & ANACTRL_ANALOG_CTRL_STATUS_FLASH_INIT_ERROR_MASK)

#define ANACTRL_ANALOG_CTRL_STATUS_FLASH_ECC_ERROR_FLAG_MASK (0x10000U)
#define ANACTRL_ANALOG_CTRL_STATUS_FLASH_ECC_ERROR_FLAG_SHIFT (16U)
/*! FLASH_ECC_ERROR_FLAG - Flash ECC Error Flag
 */
#define ANACTRL_ANALOG_CTRL_STATUS_FLASH_ECC_ERROR_FLAG(x) (((uint32_t)(((uint32_t)(x)) << ANACTRL_ANALOG_CTRL_STATUS_FLASH_ECC_ERROR_FLAG_SHIFT)) & ANACTRL_ANALOG_CTRL_STATUS_FLASH_ECC_ERROR_FLAG_MASK)
/*! @} */

/*! @name FRO192M_CTRL - 192MHz Free Running Oscillator (FRO) Control */
/*! @{ */

#define ANACTRL_FRO192M_CTRL_ENA_12MHZCLK_MASK   (0x4000U)
#define ANACTRL_FRO192M_CTRL_ENA_12MHZCLK_SHIFT  (14U)
/*! ENA_12MHZCLK - 12 MHz clock control.
 *  0b0..Disable the 12 MHz clock.
 *  0b1..Enable the 12 MHz clock.
 */
#define ANACTRL_FRO192M_CTRL_ENA_12MHZCLK(x)     (((uint32_t)(((uint32_t)(x)) << ANACTRL_FRO192M_CTRL_ENA_12MHZCLK_SHIFT)) & ANACTRL_FRO192M_CTRL_ENA_12MHZCLK_MASK)

#define ANACTRL_FRO192M_CTRL_FREQ_TRIM_MASK      (0xFF0000U)
#define ANACTRL_FRO192M_CTRL_FREQ_TRIM_SHIFT     (16U)
/*! FREQ_TRIM - Frequency trim.
 */
#define ANACTRL_FRO192M_CTRL_FREQ_TRIM(x)        (((uint32_t)(((uint32_t)(x)) << ANACTRL_FRO192M_CTRL_FREQ_TRIM_SHIFT)) & ANACTRL_FRO192M_CTRL_FREQ_TRIM_MASK)

#define ANACTRL_FRO192M_CTRL_USBCLKADJ_MASK      (0x1000000U)
#define ANACTRL_FRO192M_CTRL_USBCLKADJ_SHIFT     (24U)
/*! USBCLKADJ - If USBCLKADJ bit is set and the USB peripheral is enabled for full speed device
 *    mode, the USB block will provide FRO clock adjustments to synchronize the frequency to the host
 *    clock using the SOF packets.
 */
#define ANACTRL_FRO192M_CTRL_USBCLKADJ(x)        (((uint32_t)(((uint32_t)(x)) << ANACTRL_FRO192M_CTRL_USBCLKADJ_SHIFT)) & ANACTRL_FRO192M_CTRL_USBCLKADJ_MASK)

#define ANACTRL_FRO192M_CTRL_USBMODCHG_MASK      (0x2000000U)
#define ANACTRL_FRO192M_CTRL_USBMODCHG_SHIFT     (25U)
/*! USBMODCHG - USBCLKADJ mode trim change
 */
#define ANACTRL_FRO192M_CTRL_USBMODCHG(x)        (((uint32_t)(((uint32_t)(x)) << ANACTRL_FRO192M_CTRL_USBMODCHG_SHIFT)) & ANACTRL_FRO192M_CTRL_USBMODCHG_MASK)

#define ANACTRL_FRO192M_CTRL_ENA_96MHZCLK_MASK   (0x40000000U)
#define ANACTRL_FRO192M_CTRL_ENA_96MHZCLK_SHIFT  (30U)
/*! ENA_96MHZCLK - 96 MHz clock control
 *  0b0..Disable the 96 MHz clock.
 *  0b1..Enable the 96 MHz clock.
 */
#define ANACTRL_FRO192M_CTRL_ENA_96MHZCLK(x)     (((uint32_t)(((uint32_t)(x)) << ANACTRL_FRO192M_CTRL_ENA_96MHZCLK_SHIFT)) & ANACTRL_FRO192M_CTRL_ENA_96MHZCLK_MASK)

#define ANACTRL_FRO192M_CTRL_WRTRIM_MASK         (0x80000000U)
#define ANACTRL_FRO192M_CTRL_WRTRIM_SHIFT        (31U)
/*! WRTRIM - This must be written to 1 to modify the BIAS_TRIM and TEMP_TRIM fields.
 */
#define ANACTRL_FRO192M_CTRL_WRTRIM(x)           (((uint32_t)(((uint32_t)(x)) << ANACTRL_FRO192M_CTRL_WRTRIM_SHIFT)) & ANACTRL_FRO192M_CTRL_WRTRIM_MASK)
/*! @} */

/*! @name FRO192M_STATUS - 192MHz Free Running Oscillator (FRO) Status */
/*! @{ */

#define ANACTRL_FRO192M_STATUS_CLK_VALID_MASK    (0x1U)
#define ANACTRL_FRO192M_STATUS_CLK_VALID_SHIFT   (0U)
/*! CLK_VALID - Output clock valid.
 *  0b0..No output clock available
 *  0b1..Output clock is available
 */
#define ANACTRL_FRO192M_STATUS_CLK_VALID(x)      (((uint32_t)(((uint32_t)(x)) << ANACTRL_FRO192M_STATUS_CLK_VALID_SHIFT)) & ANACTRL_FRO192M_STATUS_CLK_VALID_MASK)

#define ANACTRL_FRO192M_STATUS_ATB_VCTRL_MASK    (0x2U)
#define ANACTRL_FRO192M_STATUS_ATB_VCTRL_SHIFT   (1U)
/*! ATB_VCTRL - CCO threshold voltage detector output (signal vcco_ok).
 */
#define ANACTRL_FRO192M_STATUS_ATB_VCTRL(x)      (((uint32_t)(((uint32_t)(x)) << ANACTRL_FRO192M_STATUS_ATB_VCTRL_SHIFT)) & ANACTRL_FRO192M_STATUS_ATB_VCTRL_MASK)
/*! @} */

/*! @name ADC_CTRL - General Purpose ADC VBAT Divider branch control */
/*! @{ */

#define ANACTRL_ADC_CTRL_VBATDIVENABLE_MASK      (0x1U)
#define ANACTRL_ADC_CTRL_VBATDIVENABLE_SHIFT     (0U)
/*! VBATDIVENABLE - Switch On/Off VBAT divider branch.
 *  0b0..VBAT divider branch is disabled.
 *  0b1..VBAT divider branch is enabled.
 */
#define ANACTRL_ADC_CTRL_VBATDIVENABLE(x)        (((uint32_t)(((uint32_t)(x)) << ANACTRL_ADC_CTRL_VBATDIVENABLE_SHIFT)) & ANACTRL_ADC_CTRL_VBATDIVENABLE_MASK)
/*! @} */

/*! @name XO32M_CTRL - High speed Crystal Oscillator Control register */
/*! @{ */

#define ANACTRL_XO32M_CTRL_SLAVE_MASK            (0x10U)
#define ANACTRL_XO32M_CTRL_SLAVE_SHIFT           (4U)
/*! SLAVE - XO in slave mode.
 */
#define ANACTRL_XO32M_CTRL_SLAVE(x)              (((uint32_t)(((uint32_t)(x)) << ANACTRL_XO32M_CTRL_SLAVE_SHIFT)) & ANACTRL_XO32M_CTRL_SLAVE_MASK)

#define ANACTRL_XO32M_CTRL_OSC_CAP_IN_MASK       (0x7F00U)
#define ANACTRL_XO32M_CTRL_OSC_CAP_IN_SHIFT      (8U)
/*! OSC_CAP_IN - Tune capa banks of High speed Crystal Oscillator input pin
 */
#define ANACTRL_XO32M_CTRL_OSC_CAP_IN(x)         (((uint32_t)(((uint32_t)(x)) << ANACTRL_XO32M_CTRL_OSC_CAP_IN_SHIFT)) & ANACTRL_XO32M_CTRL_OSC_CAP_IN_MASK)

#define ANACTRL_XO32M_CTRL_OSC_CAP_OUT_MASK      (0x3F8000U)
#define ANACTRL_XO32M_CTRL_OSC_CAP_OUT_SHIFT     (15U)
/*! OSC_CAP_OUT - Tune capa banks of High speed Crystal Oscillator output pin
 */
#define ANACTRL_XO32M_CTRL_OSC_CAP_OUT(x)        (((uint32_t)(((uint32_t)(x)) << ANACTRL_XO32M_CTRL_OSC_CAP_OUT_SHIFT)) & ANACTRL_XO32M_CTRL_OSC_CAP_OUT_MASK)

#define ANACTRL_XO32M_CTRL_ACBUF_PASS_ENABLE_MASK (0x400000U)
#define ANACTRL_XO32M_CTRL_ACBUF_PASS_ENABLE_SHIFT (22U)
/*! ACBUF_PASS_ENABLE - Allows XO32M to be configured in bypass mode.
 *  0b0..XO bypass is disabled.
 *  0b1..XO bypass is enabled.
 */
#define ANACTRL_XO32M_CTRL_ACBUF_PASS_ENABLE(x)  (((uint32_t)(((uint32_t)(x)) << ANACTRL_XO32M_CTRL_ACBUF_PASS_ENABLE_SHIFT)) & ANACTRL_XO32M_CTRL_ACBUF_PASS_ENABLE_MASK)

#define ANACTRL_XO32M_CTRL_ENABLE_SYSTEM_CLK_OUT_MASK (0x1000000U)
#define ANACTRL_XO32M_CTRL_ENABLE_SYSTEM_CLK_OUT_SHIFT (24U)
/*! ENABLE_SYSTEM_CLK_OUT - Enable High speed Crystal oscillator output to CPU system.
 *  0b0..Disable the oscillator.
 *  0b1..Enable the oscillator.
 */
#define ANACTRL_XO32M_CTRL_ENABLE_SYSTEM_CLK_OUT(x) (((uint32_t)(((uint32_t)(x)) << ANACTRL_XO32M_CTRL_ENABLE_SYSTEM_CLK_OUT_SHIFT)) & ANACTRL_XO32M_CTRL_ENABLE_SYSTEM_CLK_OUT_MASK)
/*! @} */

/*! @name XO32M_STATUS - High speed Crystal Oscillator Status */
/*! @{ */

#define ANACTRL_XO32M_STATUS_XO_READY_MASK       (0x1U)
#define ANACTRL_XO32M_STATUS_XO_READY_SHIFT      (0U)
/*! XO_READY - Crystal Oscillator Ready
 *  0b0..Frequency is not yet stable.
 *  0b1..Frequency is stable.
 */
#define ANACTRL_XO32M_STATUS_XO_READY(x)         (((uint32_t)(((uint32_t)(x)) << ANACTRL_XO32M_STATUS_XO_READY_SHIFT)) & ANACTRL_XO32M_STATUS_XO_READY_MASK)
/*! @} */

/*! @name BOD_DCDC_INT_CTRL - Brown Out Detectors & DCDC interrupt control */
/*! @{ */

#define ANACTRL_BOD_DCDC_INT_CTRL_BODVDDMAIN_INT_ENABLE_MASK (0x1U)
#define ANACTRL_BOD_DCDC_INT_CTRL_BODVDDMAIN_INT_ENABLE_SHIFT (0U)
/*! BODVDDMAIN_INT_ENABLE - BOD VDDMAIN interrupt control.
 *  0b0..Disable the interrupt.
 *  0b1..Enable the interrupt.
 */
#define ANACTRL_BOD_DCDC_INT_CTRL_BODVDDMAIN_INT_ENABLE(x) (((uint32_t)(((uint32_t)(x)) << ANACTRL_BOD_DCDC_INT_CTRL_BODVDDMAIN_INT_ENABLE_SHIFT)) & ANACTRL_BOD_DCDC_INT_CTRL_BODVDDMAIN_INT_ENABLE_MASK)

#define ANACTRL_BOD_DCDC_INT_CTRL_BODVDDMAIN_INT_CLEAR_MASK (0x2U)
#define ANACTRL_BOD_DCDC_INT_CTRL_BODVDDMAIN_INT_CLEAR_SHIFT (1U)
/*! BODVDDMAIN_INT_CLEAR - BOD VDDMAIN interrupt clear.1: Clear the interrupt. Self-cleared bit.
 */
#define ANACTRL_BOD_DCDC_INT_CTRL_BODVDDMAIN_INT_CLEAR(x) (((uint32_t)(((uint32_t)(x)) << ANACTRL_BOD_DCDC_INT_CTRL_BODVDDMAIN_INT_CLEAR_SHIFT)) & ANACTRL_BOD_DCDC_INT_CTRL_BODVDDMAIN_INT_CLEAR_MASK)

#define ANACTRL_BOD_DCDC_INT_CTRL_BODCORE_INT_ENABLE_MASK (0x4U)
#define ANACTRL_BOD_DCDC_INT_CTRL_BODCORE_INT_ENABLE_SHIFT (2U)
/*! BODCORE_INT_ENABLE - BOD CORE interrupt control.
 *  0b0..Disable the interrupt.
 *  0b1..Enable the interrupt.
 */
#define ANACTRL_BOD_DCDC_INT_CTRL_BODCORE_INT_ENABLE(x) (((uint32_t)(((uint32_t)(x)) << ANACTRL_BOD_DCDC_INT_CTRL_BODCORE_INT_ENABLE_SHIFT)) & ANACTRL_BOD_DCDC_INT_CTRL_BODCORE_INT_ENABLE_MASK)

#define ANACTRL_BOD_DCDC_INT_CTRL_BODCORE_INT_CLEAR_MASK (0x8U)
#define ANACTRL_BOD_DCDC_INT_CTRL_BODCORE_INT_CLEAR_SHIFT (3U)
/*! BODCORE_INT_CLEAR - BOD CORE interrupt clear.1: Clear the interrupt. Self-cleared bit.
 */
#define ANACTRL_BOD_DCDC_INT_CTRL_BODCORE_INT_CLEAR(x) (((uint32_t)(((uint32_t)(x)) << ANACTRL_BOD_DCDC_INT_CTRL_BODCORE_INT_CLEAR_SHIFT)) & ANACTRL_BOD_DCDC_INT_CTRL_BODCORE_INT_CLEAR_MASK)

#define ANACTRL_BOD_DCDC_INT_CTRL_DCDC_INT_ENABLE_MASK (0x10U)
#define ANACTRL_BOD_DCDC_INT_CTRL_DCDC_INT_ENABLE_SHIFT (4U)
/*! DCDC_INT_ENABLE - DCDC interrupt control.
 *  0b0..Disable the interrupt.
 *  0b1..Enable the interrupt.
 */
#define ANACTRL_BOD_DCDC_INT_CTRL_DCDC_INT_ENABLE(x) (((uint32_t)(((uint32_t)(x)) << ANACTRL_BOD_DCDC_INT_CTRL_DCDC_INT_ENABLE_SHIFT)) & ANACTRL_BOD_DCDC_INT_CTRL_DCDC_INT_ENABLE_MASK)

#define ANACTRL_BOD_DCDC_INT_CTRL_DCDC_INT_CLEAR_MASK (0x20U)
#define ANACTRL_BOD_DCDC_INT_CTRL_DCDC_INT_CLEAR_SHIFT (5U)
/*! DCDC_INT_CLEAR - DCDC interrupt clear.1: Clear the interrupt. Self-cleared bit.
 */
#define ANACTRL_BOD_DCDC_INT_CTRL_DCDC_INT_CLEAR(x) (((uint32_t)(((uint32_t)(x)) << ANACTRL_BOD_DCDC_INT_CTRL_DCDC_INT_CLEAR_SHIFT)) & ANACTRL_BOD_DCDC_INT_CTRL_DCDC_INT_CLEAR_MASK)
/*! @} */

/*! @name BOD_DCDC_INT_STATUS - BoDs & DCDC interrupt status */
/*! @{ */

#define ANACTRL_BOD_DCDC_INT_STATUS_BODVDDMAIN_STATUS_MASK (0x1U)
#define ANACTRL_BOD_DCDC_INT_STATUS_BODVDDMAIN_STATUS_SHIFT (0U)
/*! BODVDDMAIN_STATUS - BOD VDDMAIN Interrupt status before Interrupt Enable.
 *  0b0..No interrupt pending.
 *  0b1..Interrupt pending.
 */
#define ANACTRL_BOD_DCDC_INT_STATUS_BODVDDMAIN_STATUS(x) (((uint32_t)(((uint32_t)(x)) << ANACTRL_BOD_DCDC_INT_STATUS_BODVDDMAIN_STATUS_SHIFT)) & ANACTRL_BOD_DCDC_INT_STATUS_BODVDDMAIN_STATUS_MASK)

#define ANACTRL_BOD_DCDC_INT_STATUS_BODVDDMAIN_INT_STATUS_MASK (0x2U)
#define ANACTRL_BOD_DCDC_INT_STATUS_BODVDDMAIN_INT_STATUS_SHIFT (1U)
/*! BODVDDMAIN_INT_STATUS - BOD VDDMAIN Interrupt status after Interrupt Enable.
 *  0b0..No interrupt pending.
 *  0b1..Interrupt pending.
 */
#define ANACTRL_BOD_DCDC_INT_STATUS_BODVDDMAIN_INT_STATUS(x) (((uint32_t)(((uint32_t)(x)) << ANACTRL_BOD_DCDC_INT_STATUS_BODVDDMAIN_INT_STATUS_SHIFT)) & ANACTRL_BOD_DCDC_INT_STATUS_BODVDDMAIN_INT_STATUS_MASK)

#define ANACTRL_BOD_DCDC_INT_STATUS_BODVDDMAIN_VAL_MASK (0x4U)
#define ANACTRL_BOD_DCDC_INT_STATUS_BODVDDMAIN_VAL_SHIFT (2U)
/*! BODVDDMAIN_VAL - BOD VDDMAIN power status
 *  0b0..Below the threshold.
 *  0b1..Above the threshold.
 */
#define ANACTRL_BOD_DCDC_INT_STATUS_BODVDDMAIN_VAL(x) (((uint32_t)(((uint32_t)(x)) << ANACTRL_BOD_DCDC_INT_STATUS_BODVDDMAIN_VAL_SHIFT)) & ANACTRL_BOD_DCDC_INT_STATUS_BODVDDMAIN_VAL_MASK)

#define ANACTRL_BOD_DCDC_INT_STATUS_BODCORE_STATUS_MASK (0x8U)
#define ANACTRL_BOD_DCDC_INT_STATUS_BODCORE_STATUS_SHIFT (3U)
/*! BODCORE_STATUS - BOD CORE Interrupt status before Interrupt Enable.
 *  0b0..No interrupt pending.
 *  0b1..Interrupt pending.
 */
#define ANACTRL_BOD_DCDC_INT_STATUS_BODCORE_STATUS(x) (((uint32_t)(((uint32_t)(x)) << ANACTRL_BOD_DCDC_INT_STATUS_BODCORE_STATUS_SHIFT)) & ANACTRL_BOD_DCDC_INT_STATUS_BODCORE_STATUS_MASK)

#define ANACTRL_BOD_DCDC_INT_STATUS_BODCORE_INT_STATUS_MASK (0x10U)
#define ANACTRL_BOD_DCDC_INT_STATUS_BODCORE_INT_STATUS_SHIFT (4U)
/*! BODCORE_INT_STATUS - BOD CORE Interrupt status after Interrupt Enable.
 *  0b0..No interrupt pending.
 *  0b1..Interrupt pending.
 */
#define ANACTRL_BOD_DCDC_INT_STATUS_BODCORE_INT_STATUS(x) (((uint32_t)(((uint32_t)(x)) << ANACTRL_BOD_DCDC_INT_STATUS_BODCORE_INT_STATUS_SHIFT)) & ANACTRL_BOD_DCDC_INT_STATUS_BODCORE_INT_STATUS_MASK)

#define ANACTRL_BOD_DCDC_INT_STATUS_BODCORE_VAL_MASK (0x20U)
#define ANACTRL_BOD_DCDC_INT_STATUS_BODCORE_VAL_SHIFT (5U)
/*! BODCORE_VAL - BOD CORE power status
 *  0b0..Below the threshold.
 *  0b1..Above the threshold.
 */
#define ANACTRL_BOD_DCDC_INT_STATUS_BODCORE_VAL(x) (((uint32_t)(((uint32_t)(x)) << ANACTRL_BOD_DCDC_INT_STATUS_BODCORE_VAL_SHIFT)) & ANACTRL_BOD_DCDC_INT_STATUS_BODCORE_VAL_MASK)

#define ANACTRL_BOD_DCDC_INT_STATUS_DCDC_STATUS_MASK (0x40U)
#define ANACTRL_BOD_DCDC_INT_STATUS_DCDC_STATUS_SHIFT (6U)
/*! DCDC_STATUS - DCDC Interrupt status before Interrupt Enable.
 *  0b0..No interrupt pending.
 *  0b1..Interrupt pending.
 */
#define ANACTRL_BOD_DCDC_INT_STATUS_DCDC_STATUS(x) (((uint32_t)(((uint32_t)(x)) << ANACTRL_BOD_DCDC_INT_STATUS_DCDC_STATUS_SHIFT)) & ANACTRL_BOD_DCDC_INT_STATUS_DCDC_STATUS_MASK)

#define ANACTRL_BOD_DCDC_INT_STATUS_DCDC_INT_STATUS_MASK (0x80U)
#define ANACTRL_BOD_DCDC_INT_STATUS_DCDC_INT_STATUS_SHIFT (7U)
/*! DCDC_INT_STATUS - DCDC Interrupt status after Interrupt Enable.
 *  0b0..No interrupt pending.
 *  0b1..Interrupt pending.
 */
#define ANACTRL_BOD_DCDC_INT_STATUS_DCDC_INT_STATUS(x) (((uint32_t)(((uint32_t)(x)) << ANACTRL_BOD_DCDC_INT_STATUS_DCDC_INT_STATUS_SHIFT)) & ANACTRL_BOD_DCDC_INT_STATUS_DCDC_INT_STATUS_MASK)

#define ANACTRL_BOD_DCDC_INT_STATUS_DCDC_VAL_MASK (0x100U)
#define ANACTRL_BOD_DCDC_INT_STATUS_DCDC_VAL_SHIFT (8U)
/*! DCDC_VAL - DCDC power status
 *  0b0..Below the target.
 *  0b1..Above the target.
 */
#define ANACTRL_BOD_DCDC_INT_STATUS_DCDC_VAL(x)  (((uint32_t)(((uint32_t)(x)) << ANACTRL_BOD_DCDC_INT_STATUS_DCDC_VAL_SHIFT)) & ANACTRL_BOD_DCDC_INT_STATUS_DCDC_VAL_MASK)
/*! @} */

/*! @name LDO_XO32M - High Speed Crystal Oscillator (12 MHz - 32 MHz) Voltage Source Supply Control register */
/*! @{ */

#define ANACTRL_LDO_XO32M_BYPASS_MASK            (0x2U)
#define ANACTRL_LDO_XO32M_BYPASS_SHIFT           (1U)
/*! BYPASS - Activate LDO bypass.
 *  0b0..Disable bypass mode (for normal operations).
 *  0b1..Activate LDO bypass.
 */
#define ANACTRL_LDO_XO32M_BYPASS(x)              (((uint32_t)(((uint32_t)(x)) << ANACTRL_LDO_XO32M_BYPASS_SHIFT)) & ANACTRL_LDO_XO32M_BYPASS_MASK)

#define ANACTRL_LDO_XO32M_HIGHZ_MASK             (0x4U)
#define ANACTRL_LDO_XO32M_HIGHZ_SHIFT            (2U)
/*! HIGHZ - .
 *  0b0..Output in High normal state.
 *  0b1..Output in High Impedance state.
 */
#define ANACTRL_LDO_XO32M_HIGHZ(x)               (((uint32_t)(((uint32_t)(x)) << ANACTRL_LDO_XO32M_HIGHZ_SHIFT)) & ANACTRL_LDO_XO32M_HIGHZ_MASK)

#define ANACTRL_LDO_XO32M_VOUT_MASK              (0x38U)
#define ANACTRL_LDO_XO32M_VOUT_SHIFT             (3U)
/*! VOUT - Sets the LDO output level.
 *  0b000..0.750 V.
 *  0b001..0.775 V.
 *  0b010..0.800 V.
 *  0b011..0.825 V.
 *  0b100..0.850 V.
 *  0b101..0.875 V.
 *  0b110..0.900 V.
 *  0b111..0.925 V.
 */
#define ANACTRL_LDO_XO32M_VOUT(x)                (((uint32_t)(((uint32_t)(x)) << ANACTRL_LDO_XO32M_VOUT_SHIFT)) & ANACTRL_LDO_XO32M_VOUT_MASK)

#define ANACTRL_LDO_XO32M_IBIAS_MASK             (0xC0U)
#define ANACTRL_LDO_XO32M_IBIAS_SHIFT            (6U)
/*! IBIAS - Adjust the biasing current.
 */
#define ANACTRL_LDO_XO32M_IBIAS(x)               (((uint32_t)(((uint32_t)(x)) << ANACTRL_LDO_XO32M_IBIAS_SHIFT)) & ANACTRL_LDO_XO32M_IBIAS_MASK)

#define ANACTRL_LDO_XO32M_STABMODE_MASK          (0x300U)
#define ANACTRL_LDO_XO32M_STABMODE_SHIFT         (8U)
/*! STABMODE - Stability configuration.
 */
#define ANACTRL_LDO_XO32M_STABMODE(x)            (((uint32_t)(((uint32_t)(x)) << ANACTRL_LDO_XO32M_STABMODE_SHIFT)) & ANACTRL_LDO_XO32M_STABMODE_MASK)
/*! @} */

/*! @name AUX_BIAS - AUX_BIAS */
/*! @{ */

#define ANACTRL_AUX_BIAS_VREF1VENABLE_MASK       (0x2U)
#define ANACTRL_AUX_BIAS_VREF1VENABLE_SHIFT      (1U)
/*! VREF1VENABLE - Control output of 1V reference voltage.
 *  0b0..Output of 1V reference voltage buffer is bypassed.
 *  0b1..Output of 1V reference voltage is enabled.
 */
#define ANACTRL_AUX_BIAS_VREF1VENABLE(x)         (((uint32_t)(((uint32_t)(x)) << ANACTRL_AUX_BIAS_VREF1VENABLE_SHIFT)) & ANACTRL_AUX_BIAS_VREF1VENABLE_MASK)

#define ANACTRL_AUX_BIAS_ITRIM_MASK              (0x7CU)
#define ANACTRL_AUX_BIAS_ITRIM_SHIFT             (2U)
/*! ITRIM - current trimming control word.
 */
#define ANACTRL_AUX_BIAS_ITRIM(x)                (((uint32_t)(((uint32_t)(x)) << ANACTRL_AUX_BIAS_ITRIM_SHIFT)) & ANACTRL_AUX_BIAS_ITRIM_MASK)

#define ANACTRL_AUX_BIAS_PTATITRIM_MASK          (0xF80U)
#define ANACTRL_AUX_BIAS_PTATITRIM_SHIFT         (7U)
/*! PTATITRIM - current trimming control word for ptat current.
 */
#define ANACTRL_AUX_BIAS_PTATITRIM(x)            (((uint32_t)(((uint32_t)(x)) << ANACTRL_AUX_BIAS_PTATITRIM_SHIFT)) & ANACTRL_AUX_BIAS_PTATITRIM_MASK)

#define ANACTRL_AUX_BIAS_VREF1VTRIM_MASK         (0x1F000U)
#define ANACTRL_AUX_BIAS_VREF1VTRIM_SHIFT        (12U)
/*! VREF1VTRIM - voltage trimming control word.
 */
#define ANACTRL_AUX_BIAS_VREF1VTRIM(x)           (((uint32_t)(((uint32_t)(x)) << ANACTRL_AUX_BIAS_VREF1VTRIM_SHIFT)) & ANACTRL_AUX_BIAS_VREF1VTRIM_MASK)

#define ANACTRL_AUX_BIAS_VREF1VCURVETRIM_MASK    (0xE0000U)
#define ANACTRL_AUX_BIAS_VREF1VCURVETRIM_SHIFT   (17U)
/*! VREF1VCURVETRIM - Control bit to configure trimming state of mirror.
 */
#define ANACTRL_AUX_BIAS_VREF1VCURVETRIM(x)      (((uint32_t)(((uint32_t)(x)) << ANACTRL_AUX_BIAS_VREF1VCURVETRIM_SHIFT)) & ANACTRL_AUX_BIAS_VREF1VCURVETRIM_MASK)

#define ANACTRL_AUX_BIAS_ITRIMCTRL0_MASK         (0x100000U)
#define ANACTRL_AUX_BIAS_ITRIMCTRL0_SHIFT        (20U)
/*! ITRIMCTRL0 - Control bit to configure trimming state of mirror.
 */
#define ANACTRL_AUX_BIAS_ITRIMCTRL0(x)           (((uint32_t)(((uint32_t)(x)) << ANACTRL_AUX_BIAS_ITRIMCTRL0_SHIFT)) & ANACTRL_AUX_BIAS_ITRIMCTRL0_MASK)

#define ANACTRL_AUX_BIAS_ITRIMCTRL1_MASK         (0x200000U)
#define ANACTRL_AUX_BIAS_ITRIMCTRL1_SHIFT        (21U)
/*! ITRIMCTRL1 - Control bit to configure trimming state of mirror.
 */
#define ANACTRL_AUX_BIAS_ITRIMCTRL1(x)           (((uint32_t)(((uint32_t)(x)) << ANACTRL_AUX_BIAS_ITRIMCTRL1_SHIFT)) & ANACTRL_AUX_BIAS_ITRIMCTRL1_MASK)
/*! @} */

/*! @name OSC_TESTBUS - Oscillators Analog Macrobloc ACBUS and DCBUS control */
/*! @{ */

#define ANACTRL_OSC_TESTBUS_ACBUS_MASK           (0x3FU)
#define ANACTRL_OSC_TESTBUS_ACBUS_SHIFT          (0U)
/*! ACBUS - Alternate current BUS
 */
#define ANACTRL_OSC_TESTBUS_ACBUS(x)             (((uint32_t)(((uint32_t)(x)) << ANACTRL_OSC_TESTBUS_ACBUS_SHIFT)) & ANACTRL_OSC_TESTBUS_ACBUS_MASK)

#define ANACTRL_OSC_TESTBUS_DCBUS_MASK           (0x3F0000U)
#define ANACTRL_OSC_TESTBUS_DCBUS_SHIFT          (16U)
/*! DCBUS - Direct current BUS
 */
#define ANACTRL_OSC_TESTBUS_DCBUS(x)             (((uint32_t)(((uint32_t)(x)) << ANACTRL_OSC_TESTBUS_DCBUS_SHIFT)) & ANACTRL_OSC_TESTBUS_DCBUS_MASK)
/*! @} */

/*! @name DUMMY_CTRL - Dummy Control bus to analog modules */
/*! @{ */

#define ANACTRL_DUMMY_CTRL_XO32M_ADC_CLK_MODE_MASK (0xC00U)
#define ANACTRL_DUMMY_CTRL_XO32M_ADC_CLK_MODE_SHIFT (10U)
/*! XO32M_ADC_CLK_MODE - Control High speed Crystal oscillator mode of the ADC clock.
 *  0b00..High speed Crystal oscillator output to ADC is disabled.
 *  0b01..High speed Crystal oscillator output to ADC is enable.
 */
#define ANACTRL_DUMMY_CTRL_XO32M_ADC_CLK_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANACTRL_DUMMY_CTRL_XO32M_ADC_CLK_MODE_SHIFT)) & ANACTRL_DUMMY_CTRL_XO32M_ADC_CLK_MODE_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group ANACTRL_Register_Masks */


/* ANACTRL - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral ANACTRL base address */
  #define ANACTRL_BASE                             (0x50013000u)
  /** Peripheral ANACTRL base address */
  #define ANACTRL_BASE_NS                          (0x40013000u)
  /** Peripheral ANACTRL base pointer */
  #define ANACTRL                                  ((ANACTRL_Type *)ANACTRL_BASE)
  /** Peripheral ANACTRL base pointer */
  #define ANACTRL_NS                               ((ANACTRL_Type *)ANACTRL_BASE_NS)
  /** Array initializer of ANACTRL peripheral base addresses */
  #define ANACTRL_BASE_ADDRS                       { ANACTRL_BASE }
  /** Array initializer of ANACTRL peripheral base pointers */
  #define ANACTRL_BASE_PTRS                        { ANACTRL }
  /** Array initializer of ANACTRL peripheral base addresses */
  #define ANACTRL_BASE_ADDRS_NS                    { ANACTRL_BASE_NS }
  /** Array initializer of ANACTRL peripheral base pointers */
  #define ANACTRL_BASE_PTRS_NS                     { ANACTRL_NS }
#else
  /** Peripheral ANACTRL base address */
  #define ANACTRL_BASE                             (0x40013000u)
  /** Peripheral ANACTRL base pointer */
  #define ANACTRL                                  ((ANACTRL_Type *)ANACTRL_BASE)
  /** Array initializer of ANACTRL peripheral base addresses */
  #define ANACTRL_BASE_ADDRS                       { ANACTRL_BASE }
  /** Array initializer of ANACTRL peripheral base pointers */
  #define ANACTRL_BASE_PTRS                        { ANACTRL }
#endif

/*!
 * @}
 */ /* end of group ANACTRL_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- AOI Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AOI_Peripheral_Access_Layer AOI Peripheral Access Layer
 * @{
 */

/** AOI - Register Layout Typedef */
typedef struct {
  struct {                                         /* offset: 0x0, array step: 0x4 */
    __IO uint16_t BFCRT01;                           /**< Boolean Function Term 0 and 1 Configuration Register for EVENTn, array offset: 0x0, array step: 0x4 */
    __IO uint16_t BFCRT23;                           /**< Boolean Function Term 2 and 3 Configuration Register for EVENTn, array offset: 0x2, array step: 0x4 */
  } BFCRT[4];
} AOI_Type;

/* ----------------------------------------------------------------------------
   -- AOI Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AOI_Register_Masks AOI Register Masks
 * @{
 */

/*! @name BFCRT01 - Boolean Function Term 0 and 1 Configuration Register for EVENTn */
/*! @{ */

#define AOI_BFCRT01_PT1_DC_MASK                  (0x3U)
#define AOI_BFCRT01_PT1_DC_SHIFT                 (0U)
/*! PT1_DC - Product term 1, D input configuration
 *  0b00..Force the D input in this product term to a logical zero
 *  0b01..Pass the D input in this product term
 *  0b10..Complement the D input in this product term
 *  0b11..Force the D input in this product term to a logical one
 */
#define AOI_BFCRT01_PT1_DC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT01_PT1_DC_SHIFT)) & AOI_BFCRT01_PT1_DC_MASK)

#define AOI_BFCRT01_PT1_CC_MASK                  (0xCU)
#define AOI_BFCRT01_PT1_CC_SHIFT                 (2U)
/*! PT1_CC - Product term 1, C input configuration
 *  0b00..Force the C input in this product term to a logical zero
 *  0b01..Pass the C input in this product term
 *  0b10..Complement the C input in this product term
 *  0b11..Force the C input in this product term to a logical one
 */
#define AOI_BFCRT01_PT1_CC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT01_PT1_CC_SHIFT)) & AOI_BFCRT01_PT1_CC_MASK)

#define AOI_BFCRT01_PT1_BC_MASK                  (0x30U)
#define AOI_BFCRT01_PT1_BC_SHIFT                 (4U)
/*! PT1_BC - Product term 1, B input configuration
 *  0b00..Force the B input in this product term to a logical zero
 *  0b01..Pass the B input in this product term
 *  0b10..Complement the B input in this product term
 *  0b11..Force the B input in this product term to a logical one
 */
#define AOI_BFCRT01_PT1_BC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT01_PT1_BC_SHIFT)) & AOI_BFCRT01_PT1_BC_MASK)

#define AOI_BFCRT01_PT1_AC_MASK                  (0xC0U)
#define AOI_BFCRT01_PT1_AC_SHIFT                 (6U)
/*! PT1_AC - Product term 1, A input configuration
 *  0b00..Force the A input in this product term to a logical zero
 *  0b01..Pass the A input in this product term
 *  0b10..Complement the A input in this product term
 *  0b11..Force the A input in this product term to a logical one
 */
#define AOI_BFCRT01_PT1_AC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT01_PT1_AC_SHIFT)) & AOI_BFCRT01_PT1_AC_MASK)

#define AOI_BFCRT01_PT0_DC_MASK                  (0x300U)
#define AOI_BFCRT01_PT0_DC_SHIFT                 (8U)
/*! PT0_DC - Product term 0, D input configuration
 *  0b00..Force the D input in this product term to a logical zero
 *  0b01..Pass the D input in this product term
 *  0b10..Complement the D input in this product term
 *  0b11..Force the D input in this product term to a logical one
 */
#define AOI_BFCRT01_PT0_DC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT01_PT0_DC_SHIFT)) & AOI_BFCRT01_PT0_DC_MASK)

#define AOI_BFCRT01_PT0_CC_MASK                  (0xC00U)
#define AOI_BFCRT01_PT0_CC_SHIFT                 (10U)
/*! PT0_CC - Product term 0, C input configuration
 *  0b00..Force the C input in this product term to a logical zero
 *  0b01..Pass the C input in this product term
 *  0b10..Complement the C input in this product term
 *  0b11..Force the C input in this product term to a logical one
 */
#define AOI_BFCRT01_PT0_CC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT01_PT0_CC_SHIFT)) & AOI_BFCRT01_PT0_CC_MASK)

#define AOI_BFCRT01_PT0_BC_MASK                  (0x3000U)
#define AOI_BFCRT01_PT0_BC_SHIFT                 (12U)
/*! PT0_BC - Product term 0, B input configuration
 *  0b00..Force the B input in this product term to a logical zero
 *  0b01..Pass the B input in this product term
 *  0b10..Complement the B input in this product term
 *  0b11..Force the B input in this product term to a logical one
 */
#define AOI_BFCRT01_PT0_BC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT01_PT0_BC_SHIFT)) & AOI_BFCRT01_PT0_BC_MASK)

#define AOI_BFCRT01_PT0_AC_MASK                  (0xC000U)
#define AOI_BFCRT01_PT0_AC_SHIFT                 (14U)
/*! PT0_AC - Product term 0, A input configuration
 *  0b00..Force the A input in this product term to a logical zero
 *  0b01..Pass the A input in this product term
 *  0b10..Complement the A input in this product term
 *  0b11..Force the A input in this product term to a logical one
 */
#define AOI_BFCRT01_PT0_AC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT01_PT0_AC_SHIFT)) & AOI_BFCRT01_PT0_AC_MASK)
/*! @} */

/* The count of AOI_BFCRT01 */
#define AOI_BFCRT01_COUNT                        (4U)

/*! @name BFCRT23 - Boolean Function Term 2 and 3 Configuration Register for EVENTn */
/*! @{ */

#define AOI_BFCRT23_PT3_DC_MASK                  (0x3U)
#define AOI_BFCRT23_PT3_DC_SHIFT                 (0U)
/*! PT3_DC - Product term 3, D input configuration
 *  0b00..Force the D input in this product term to a logical zero
 *  0b01..Pass the D input in this product term
 *  0b10..Complement the D input in this product term
 *  0b11..Force the D input in this product term to a logical one
 */
#define AOI_BFCRT23_PT3_DC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT23_PT3_DC_SHIFT)) & AOI_BFCRT23_PT3_DC_MASK)

#define AOI_BFCRT23_PT3_CC_MASK                  (0xCU)
#define AOI_BFCRT23_PT3_CC_SHIFT                 (2U)
/*! PT3_CC - Product term 3, C input configuration
 *  0b00..Force the C input in this product term to a logical zero
 *  0b01..Pass the C input in this product term
 *  0b10..Complement the C input in this product term
 *  0b11..Force the C input in this product term to a logical one
 */
#define AOI_BFCRT23_PT3_CC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT23_PT3_CC_SHIFT)) & AOI_BFCRT23_PT3_CC_MASK)

#define AOI_BFCRT23_PT3_BC_MASK                  (0x30U)
#define AOI_BFCRT23_PT3_BC_SHIFT                 (4U)
/*! PT3_BC - Product term 3, B input configuration
 *  0b00..Force the B input in this product term to a logical zero
 *  0b01..Pass the B input in this product term
 *  0b10..Complement the B input in this product term
 *  0b11..Force the B input in this product term to a logical one
 */
#define AOI_BFCRT23_PT3_BC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT23_PT3_BC_SHIFT)) & AOI_BFCRT23_PT3_BC_MASK)

#define AOI_BFCRT23_PT3_AC_MASK                  (0xC0U)
#define AOI_BFCRT23_PT3_AC_SHIFT                 (6U)
/*! PT3_AC - Product term 3, A input configuration
 *  0b00..Force the A input in this product term to a logical zero
 *  0b01..Pass the A input in this product term
 *  0b10..Complement the A input in this product term
 *  0b11..Force the A input in this product term to a logical one
 */
#define AOI_BFCRT23_PT3_AC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT23_PT3_AC_SHIFT)) & AOI_BFCRT23_PT3_AC_MASK)

#define AOI_BFCRT23_PT2_DC_MASK                  (0x300U)
#define AOI_BFCRT23_PT2_DC_SHIFT                 (8U)
/*! PT2_DC - Product term 2, D input configuration
 *  0b00..Force the D input in this product term to a logical zero
 *  0b01..Pass the D input in this product term
 *  0b10..Complement the D input in this product term
 *  0b11..Force the D input in this product term to a logical one
 */
#define AOI_BFCRT23_PT2_DC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT23_PT2_DC_SHIFT)) & AOI_BFCRT23_PT2_DC_MASK)

#define AOI_BFCRT23_PT2_CC_MASK                  (0xC00U)
#define AOI_BFCRT23_PT2_CC_SHIFT                 (10U)
/*! PT2_CC - Product term 2, C input configuration
 *  0b00..Force the C input in this product term to a logical zero
 *  0b01..Pass the C input in this product term
 *  0b10..Complement the C input in this product term
 *  0b11..Force the C input in this product term to a logical one
 */
#define AOI_BFCRT23_PT2_CC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT23_PT2_CC_SHIFT)) & AOI_BFCRT23_PT2_CC_MASK)

#define AOI_BFCRT23_PT2_BC_MASK                  (0x3000U)
#define AOI_BFCRT23_PT2_BC_SHIFT                 (12U)
/*! PT2_BC - Product term 2, B input configuration
 *  0b00..Force the B input in this product term to a logical zero
 *  0b01..Pass the B input in this product term
 *  0b10..Complement the B input in this product term
 *  0b11..Force the B input in this product term to a logical one
 */
#define AOI_BFCRT23_PT2_BC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT23_PT2_BC_SHIFT)) & AOI_BFCRT23_PT2_BC_MASK)

#define AOI_BFCRT23_PT2_AC_MASK                  (0xC000U)
#define AOI_BFCRT23_PT2_AC_SHIFT                 (14U)
/*! PT2_AC - Product term 2, A input configuration
 *  0b00..Force the A input in this product term to a logical zero
 *  0b01..Pass the A input in this product term
 *  0b10..Complement the A input in this product term
 *  0b11..Force the A input in this product term to a logical one
 */
#define AOI_BFCRT23_PT2_AC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT23_PT2_AC_SHIFT)) & AOI_BFCRT23_PT2_AC_MASK)
/*! @} */

/* The count of AOI_BFCRT23 */
#define AOI_BFCRT23_COUNT                        (4U)


/*!
 * @}
 */ /* end of group AOI_Register_Masks */


/* AOI - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral AOI0 base address */
  #define AOI0_BASE                                (0x500C7000u)
  /** Peripheral AOI0 base address */
  #define AOI0_BASE_NS                             (0x400C7000u)
  /** Peripheral AOI0 base pointer */
  #define AOI0                                     ((AOI_Type *)AOI0_BASE)
  /** Peripheral AOI0 base pointer */
  #define AOI0_NS                                  ((AOI_Type *)AOI0_BASE_NS)
  /** Peripheral AOI1 base address */
  #define AOI1_BASE                                (0x500C8000u)
  /** Peripheral AOI1 base address */
  #define AOI1_BASE_NS                             (0x400C8000u)
  /** Peripheral AOI1 base pointer */
  #define AOI1                                     ((AOI_Type *)AOI1_BASE)
  /** Peripheral AOI1 base pointer */
  #define AOI1_NS                                  ((AOI_Type *)AOI1_BASE_NS)
  /** Array initializer of AOI peripheral base addresses */
  #define AOI_BASE_ADDRS                           { AOI0_BASE, AOI1_BASE }
  /** Array initializer of AOI peripheral base pointers */
  #define AOI_BASE_PTRS                            { AOI0, AOI1 }
  /** Array initializer of AOI peripheral base addresses */
  #define AOI_BASE_ADDRS_NS                        { AOI0_BASE_NS, AOI1_BASE_NS }
  /** Array initializer of AOI peripheral base pointers */
  #define AOI_BASE_PTRS_NS                         { AOI0_NS, AOI1_NS }
#else
  /** Peripheral AOI0 base address */
  #define AOI0_BASE                                (0x400C7000u)
  /** Peripheral AOI0 base pointer */
  #define AOI0                                     ((AOI_Type *)AOI0_BASE)
  /** Peripheral AOI1 base address */
  #define AOI1_BASE                                (0x400C8000u)
  /** Peripheral AOI1 base pointer */
  #define AOI1                                     ((AOI_Type *)AOI1_BASE)
  /** Array initializer of AOI peripheral base addresses */
  #define AOI_BASE_ADDRS                           { AOI0_BASE, AOI1_BASE }
  /** Array initializer of AOI peripheral base pointers */
  #define AOI_BASE_PTRS                            { AOI0, AOI1 }
#endif

/*!
 * @}
 */ /* end of group AOI_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CACHE64_CTRL Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CACHE64_CTRL_Peripheral_Access_Layer CACHE64_CTRL Peripheral Access Layer
 * @{
 */

/** CACHE64_CTRL - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[2048];
  __IO uint32_t CCR;                               /**< Cache control register, offset: 0x800 */
  __IO uint32_t CLCR;                              /**< Cache line control register, offset: 0x804 */
  __IO uint32_t CSAR;                              /**< Cache search address register, offset: 0x808 */
  __IO uint32_t CCVR;                              /**< Cache read/write value register, offset: 0x80C */
} CACHE64_CTRL_Type;

/* ----------------------------------------------------------------------------
   -- CACHE64_CTRL Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CACHE64_CTRL_Register_Masks CACHE64_CTRL Register Masks
 * @{
 */

/*! @name CCR - Cache control register */
/*! @{ */

#define CACHE64_CTRL_CCR_ENCACHE_MASK            (0x1U)
#define CACHE64_CTRL_CCR_ENCACHE_SHIFT           (0U)
/*! ENCACHE - Cache enable
 *  0b0..Cache disabled
 *  0b1..Cache enabled
 */
#define CACHE64_CTRL_CCR_ENCACHE(x)              (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_ENCACHE_SHIFT)) & CACHE64_CTRL_CCR_ENCACHE_MASK)

#define CACHE64_CTRL_CCR_ENWRBUF_MASK            (0x2U)
#define CACHE64_CTRL_CCR_ENWRBUF_SHIFT           (1U)
/*! ENWRBUF - Enable Write Buffer
 *  0b0..Write buffer disabled
 *  0b1..Write buffer enabled
 */
#define CACHE64_CTRL_CCR_ENWRBUF(x)              (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_ENWRBUF_SHIFT)) & CACHE64_CTRL_CCR_ENWRBUF_MASK)

#define CACHE64_CTRL_CCR_INVW0_MASK              (0x1000000U)
#define CACHE64_CTRL_CCR_INVW0_SHIFT             (24U)
/*! INVW0 - Invalidate Way 0
 *  0b0..No operation
 *  0b1..When setting the GO bit, invalidate all lines in way 0.
 */
#define CACHE64_CTRL_CCR_INVW0(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_INVW0_SHIFT)) & CACHE64_CTRL_CCR_INVW0_MASK)

#define CACHE64_CTRL_CCR_PUSHW0_MASK             (0x2000000U)
#define CACHE64_CTRL_CCR_PUSHW0_SHIFT            (25U)
/*! PUSHW0 - Push Way 0
 *  0b0..No operation
 *  0b1..When setting the GO bit, push all modified lines in way 0
 */
#define CACHE64_CTRL_CCR_PUSHW0(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_PUSHW0_SHIFT)) & CACHE64_CTRL_CCR_PUSHW0_MASK)

#define CACHE64_CTRL_CCR_INVW1_MASK              (0x4000000U)
#define CACHE64_CTRL_CCR_INVW1_SHIFT             (26U)
/*! INVW1 - Invalidate Way 1
 *  0b0..No operation
 *  0b1..When setting the GO bit, invalidate all lines in way 1
 */
#define CACHE64_CTRL_CCR_INVW1(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_INVW1_SHIFT)) & CACHE64_CTRL_CCR_INVW1_MASK)

#define CACHE64_CTRL_CCR_PUSHW1_MASK             (0x8000000U)
#define CACHE64_CTRL_CCR_PUSHW1_SHIFT            (27U)
/*! PUSHW1 - Push Way 1
 *  0b0..No operation
 *  0b1..When setting the GO bit, push all modified lines in way 1
 */
#define CACHE64_CTRL_CCR_PUSHW1(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_PUSHW1_SHIFT)) & CACHE64_CTRL_CCR_PUSHW1_MASK)

#define CACHE64_CTRL_CCR_GO_MASK                 (0x80000000U)
#define CACHE64_CTRL_CCR_GO_SHIFT                (31U)
/*! GO - Initiate Cache Command
 *  0b0..Write: no effect. Read: no cache command active.
 *  0b1..Write: initiate command indicated by bits 27-24. Read: cache command active.
 */
#define CACHE64_CTRL_CCR_GO(x)                   (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_GO_SHIFT)) & CACHE64_CTRL_CCR_GO_MASK)
/*! @} */

/*! @name CLCR - Cache line control register */
/*! @{ */

#define CACHE64_CTRL_CLCR_LGO_MASK               (0x1U)
#define CACHE64_CTRL_CLCR_LGO_SHIFT              (0U)
/*! LGO - Initiate Cache Line Command
 *  0b0..Write: no effect. Read: no line command active.
 *  0b1..Write: initiate line command indicated by bits 27-24. Read: line command active.
 */
#define CACHE64_CTRL_CLCR_LGO(x)                 (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LGO_SHIFT)) & CACHE64_CTRL_CLCR_LGO_MASK)

#define CACHE64_CTRL_CLCR_CACHEADDR_MASK         (0x3FFCU)
#define CACHE64_CTRL_CLCR_CACHEADDR_SHIFT        (2U)
/*! CACHEADDR - Cache address
 */
#define CACHE64_CTRL_CLCR_CACHEADDR(x)           (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_CACHEADDR_SHIFT)) & CACHE64_CTRL_CLCR_CACHEADDR_MASK)

#define CACHE64_CTRL_CLCR_WSEL_MASK              (0x4000U)
#define CACHE64_CTRL_CLCR_WSEL_SHIFT             (14U)
/*! WSEL - Way select
 *  0b0..Way 0
 *  0b1..Way 1
 */
#define CACHE64_CTRL_CLCR_WSEL(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_WSEL_SHIFT)) & CACHE64_CTRL_CLCR_WSEL_MASK)

#define CACHE64_CTRL_CLCR_TDSEL_MASK             (0x10000U)
#define CACHE64_CTRL_CLCR_TDSEL_SHIFT            (16U)
/*! TDSEL - Tag/Data Select
 *  0b0..Data
 *  0b1..Tag
 */
#define CACHE64_CTRL_CLCR_TDSEL(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_TDSEL_SHIFT)) & CACHE64_CTRL_CLCR_TDSEL_MASK)

#define CACHE64_CTRL_CLCR_LCIVB_MASK             (0x100000U)
#define CACHE64_CTRL_CLCR_LCIVB_SHIFT            (20U)
/*! LCIVB - Line Command Initial Valid Bit
 */
#define CACHE64_CTRL_CLCR_LCIVB(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LCIVB_SHIFT)) & CACHE64_CTRL_CLCR_LCIVB_MASK)

#define CACHE64_CTRL_CLCR_LCIMB_MASK             (0x200000U)
#define CACHE64_CTRL_CLCR_LCIMB_SHIFT            (21U)
/*! LCIMB - Line Command Initial Modified Bit
 */
#define CACHE64_CTRL_CLCR_LCIMB(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LCIMB_SHIFT)) & CACHE64_CTRL_CLCR_LCIMB_MASK)

#define CACHE64_CTRL_CLCR_LCWAY_MASK             (0x400000U)
#define CACHE64_CTRL_CLCR_LCWAY_SHIFT            (22U)
/*! LCWAY - Line Command Way
 */
#define CACHE64_CTRL_CLCR_LCWAY(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LCWAY_SHIFT)) & CACHE64_CTRL_CLCR_LCWAY_MASK)

#define CACHE64_CTRL_CLCR_LCMD_MASK              (0x3000000U)
#define CACHE64_CTRL_CLCR_LCMD_SHIFT             (24U)
/*! LCMD - Line Command
 *  0b00..Search and read or write
 *  0b01..Invalidate
 *  0b10..Push
 *  0b11..Clear
 */
#define CACHE64_CTRL_CLCR_LCMD(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LCMD_SHIFT)) & CACHE64_CTRL_CLCR_LCMD_MASK)

#define CACHE64_CTRL_CLCR_LADSEL_MASK            (0x4000000U)
#define CACHE64_CTRL_CLCR_LADSEL_SHIFT           (26U)
/*! LADSEL - Line Address Select
 *  0b0..Cache address
 *  0b1..Physical address
 */
#define CACHE64_CTRL_CLCR_LADSEL(x)              (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LADSEL_SHIFT)) & CACHE64_CTRL_CLCR_LADSEL_MASK)

#define CACHE64_CTRL_CLCR_LACC_MASK              (0x8000000U)
#define CACHE64_CTRL_CLCR_LACC_SHIFT             (27U)
/*! LACC - Line access type
 *  0b0..Read
 *  0b1..Write
 */
#define CACHE64_CTRL_CLCR_LACC(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LACC_SHIFT)) & CACHE64_CTRL_CLCR_LACC_MASK)
/*! @} */

/*! @name CSAR - Cache search address register */
/*! @{ */

#define CACHE64_CTRL_CSAR_LGO_MASK               (0x1U)
#define CACHE64_CTRL_CSAR_LGO_SHIFT              (0U)
/*! LGO - Initiate Cache Line Command
 *  0b0..Write: no effect. Read: no line command active.
 *  0b1..Write: initiate line command indicated by bits CLCR[27:24]. Read: line command active.
 */
#define CACHE64_CTRL_CSAR_LGO(x)                 (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CSAR_LGO_SHIFT)) & CACHE64_CTRL_CSAR_LGO_MASK)

#define CACHE64_CTRL_CSAR_PHYADDR_MASK           (0xFFFFFFFEU)
#define CACHE64_CTRL_CSAR_PHYADDR_SHIFT          (1U)
/*! PHYADDR - Physical Address
 */
#define CACHE64_CTRL_CSAR_PHYADDR(x)             (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CSAR_PHYADDR_SHIFT)) & CACHE64_CTRL_CSAR_PHYADDR_MASK)
/*! @} */

/*! @name CCVR - Cache read/write value register */
/*! @{ */

#define CACHE64_CTRL_CCVR_DATA_MASK              (0xFFFFFFFFU)
#define CACHE64_CTRL_CCVR_DATA_SHIFT             (0U)
/*! DATA - Cache read/write Data
 */
#define CACHE64_CTRL_CCVR_DATA(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCVR_DATA_SHIFT)) & CACHE64_CTRL_CCVR_DATA_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CACHE64_CTRL_Register_Masks */


/* CACHE64_CTRL - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral CACHE64_CTRL0 base address */
  #define CACHE64_CTRL0_BASE                       (0x5002E000u)
  /** Peripheral CACHE64_CTRL0 base address */
  #define CACHE64_CTRL0_BASE_NS                    (0x4002E000u)
  /** Peripheral CACHE64_CTRL0 base pointer */
  #define CACHE64_CTRL0                            ((CACHE64_CTRL_Type *)CACHE64_CTRL0_BASE)
  /** Peripheral CACHE64_CTRL0 base pointer */
  #define CACHE64_CTRL0_NS                         ((CACHE64_CTRL_Type *)CACHE64_CTRL0_BASE_NS)
  /** Array initializer of CACHE64_CTRL peripheral base addresses */
  #define CACHE64_CTRL_BASE_ADDRS                  { CACHE64_CTRL0_BASE }
  /** Array initializer of CACHE64_CTRL peripheral base pointers */
  #define CACHE64_CTRL_BASE_PTRS                   { CACHE64_CTRL0 }
  /** Array initializer of CACHE64_CTRL peripheral base addresses */
  #define CACHE64_CTRL_BASE_ADDRS_NS               { CACHE64_CTRL0_BASE_NS }
  /** Array initializer of CACHE64_CTRL peripheral base pointers */
  #define CACHE64_CTRL_BASE_PTRS_NS                { CACHE64_CTRL0_NS }
#else
  /** Peripheral CACHE64_CTRL0 base address */
  #define CACHE64_CTRL0_BASE                       (0x4002E000u)
  /** Peripheral CACHE64_CTRL0 base pointer */
  #define CACHE64_CTRL0                            ((CACHE64_CTRL_Type *)CACHE64_CTRL0_BASE)
  /** Array initializer of CACHE64_CTRL peripheral base addresses */
  #define CACHE64_CTRL_BASE_ADDRS                  { CACHE64_CTRL0_BASE }
  /** Array initializer of CACHE64_CTRL peripheral base pointers */
  #define CACHE64_CTRL_BASE_PTRS                   { CACHE64_CTRL0 }
#endif
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
/** CACHE64_CTRL physical memory base address */
 #define CACHE64_CTRL_PHYMEM_BASES                { 0x18000000u, 0x38000000u }
/** CACHE64_CTRL physical memory size */
 #define CACHE64_CTRL_PHYMEM_SIZES                { 0x08000000u, 0x08000000u }
/** CACHE64_CTRL physical memory base address */
 #define CACHE64_CTRL_PHYMEM_BASES_NS             { 0x08000000u, 0x28000000u }
/** CACHE64_CTRL physical memory size */
 #define CACHE64_CTRL_PHYMEM_SIZES_NS             { 0x08000000u, 0x08000000u }
#else
/** CACHE64_CTRL physical memory base address */
 #define CACHE64_CTRL_PHYMEM_BASES                { 0x08000000u, 0x28000000u }
/** CACHE64_CTRL physical memory size */
 #define CACHE64_CTRL_PHYMEM_SIZES                { 0x08000000u, 0x08000000u }
#endif
/* Backward compatibility */


/*!
 * @}
 */ /* end of group CACHE64_CTRL_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CACHE64_POLSEL Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CACHE64_POLSEL_Peripheral_Access_Layer CACHE64_POLSEL Peripheral Access Layer
 * @{
 */

/** CACHE64_POLSEL - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[20];
  __IO uint32_t REG0_TOP;                          /**< Region 0 Top Boundary, offset: 0x14 */
  __IO uint32_t REG1_TOP;                          /**< Region 1 Top Boundary, offset: 0x18 */
  __IO uint32_t POLSEL;                            /**< Policy Select, offset: 0x1C */
} CACHE64_POLSEL_Type;

/* ----------------------------------------------------------------------------
   -- CACHE64_POLSEL Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CACHE64_POLSEL_Register_Masks CACHE64_POLSEL Register Masks
 * @{
 */

/*! @name REG0_TOP - Region 0 Top Boundary */
/*! @{ */

#define CACHE64_POLSEL_REG0_TOP_REG0_TOP_MASK    (0x7FFFC00U)
#define CACHE64_POLSEL_REG0_TOP_REG0_TOP_SHIFT   (10U)
/*! REG0_TOP - Upper limit of Region 0
 */
#define CACHE64_POLSEL_REG0_TOP_REG0_TOP(x)      (((uint32_t)(((uint32_t)(x)) << CACHE64_POLSEL_REG0_TOP_REG0_TOP_SHIFT)) & CACHE64_POLSEL_REG0_TOP_REG0_TOP_MASK)
/*! @} */

/*! @name REG1_TOP - Region 1 Top Boundary */
/*! @{ */

#define CACHE64_POLSEL_REG1_TOP_REG1_TOP_MASK    (0x7FFFC00U)
#define CACHE64_POLSEL_REG1_TOP_REG1_TOP_SHIFT   (10U)
/*! REG1_TOP - Upper limit of Region 1
 */
#define CACHE64_POLSEL_REG1_TOP_REG1_TOP(x)      (((uint32_t)(((uint32_t)(x)) << CACHE64_POLSEL_REG1_TOP_REG1_TOP_SHIFT)) & CACHE64_POLSEL_REG1_TOP_REG1_TOP_MASK)
/*! @} */

/*! @name POLSEL - Policy Select */
/*! @{ */

#define CACHE64_POLSEL_POLSEL_REG0_POLICY_MASK   (0x3U)
#define CACHE64_POLSEL_POLSEL_REG0_POLICY_SHIFT  (0U)
/*! REG0_POLICY - Policy Select for Region 0
 *  0b00..Non-cache
 *  0b01..Write-thru
 *  0b10..Write-back
 *  0b11..Invalid
 */
#define CACHE64_POLSEL_POLSEL_REG0_POLICY(x)     (((uint32_t)(((uint32_t)(x)) << CACHE64_POLSEL_POLSEL_REG0_POLICY_SHIFT)) & CACHE64_POLSEL_POLSEL_REG0_POLICY_MASK)

#define CACHE64_POLSEL_POLSEL_REG1_POLICY_MASK   (0xCU)
#define CACHE64_POLSEL_POLSEL_REG1_POLICY_SHIFT  (2U)
/*! REG1_POLICY - Policy Select for Region 0
 *  0b00..Non-cache
 *  0b01..Write-thru
 *  0b10..Write-back
 *  0b11..Invalid
 */
#define CACHE64_POLSEL_POLSEL_REG1_POLICY(x)     (((uint32_t)(((uint32_t)(x)) << CACHE64_POLSEL_POLSEL_REG1_POLICY_SHIFT)) & CACHE64_POLSEL_POLSEL_REG1_POLICY_MASK)

#define CACHE64_POLSEL_POLSEL_REG02_POLICY_MASK  (0x30U)
#define CACHE64_POLSEL_POLSEL_REG02_POLICY_SHIFT (4U)
/*! REG02_POLICY - Policy Select for Region 0
 *  0b00..Non-cache
 *  0b01..Write-thru
 *  0b10..Write-back
 *  0b11..Invalid
 */
#define CACHE64_POLSEL_POLSEL_REG02_POLICY(x)    (((uint32_t)(((uint32_t)(x)) << CACHE64_POLSEL_POLSEL_REG02_POLICY_SHIFT)) & CACHE64_POLSEL_POLSEL_REG02_POLICY_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CACHE64_POLSEL_Register_Masks */


/* CACHE64_POLSEL - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral CACHE64_POLSEL0 base address */
  #define CACHE64_POLSEL0_BASE                     (0x5002E000u)
  /** Peripheral CACHE64_POLSEL0 base address */
  #define CACHE64_POLSEL0_BASE_NS                  (0x4002E000u)
  /** Peripheral CACHE64_POLSEL0 base pointer */
  #define CACHE64_POLSEL0                          ((CACHE64_POLSEL_Type *)CACHE64_POLSEL0_BASE)
  /** Peripheral CACHE64_POLSEL0 base pointer */
  #define CACHE64_POLSEL0_NS                       ((CACHE64_POLSEL_Type *)CACHE64_POLSEL0_BASE_NS)
  /** Array initializer of CACHE64_POLSEL peripheral base addresses */
  #define CACHE64_POLSEL_BASE_ADDRS                { CACHE64_POLSEL0_BASE }
  /** Array initializer of CACHE64_POLSEL peripheral base pointers */
  #define CACHE64_POLSEL_BASE_PTRS                 { CACHE64_POLSEL0 }
  /** Array initializer of CACHE64_POLSEL peripheral base addresses */
  #define CACHE64_POLSEL_BASE_ADDRS_NS             { CACHE64_POLSEL0_BASE_NS }
  /** Array initializer of CACHE64_POLSEL peripheral base pointers */
  #define CACHE64_POLSEL_BASE_PTRS_NS              { CACHE64_POLSEL0_NS }
#else
  /** Peripheral CACHE64_POLSEL0 base address */
  #define CACHE64_POLSEL0_BASE                     (0x4002E000u)
  /** Peripheral CACHE64_POLSEL0 base pointer */
  #define CACHE64_POLSEL0                          ((CACHE64_POLSEL_Type *)CACHE64_POLSEL0_BASE)
  /** Array initializer of CACHE64_POLSEL peripheral base addresses */
  #define CACHE64_POLSEL_BASE_ADDRS                { CACHE64_POLSEL0_BASE }
  /** Array initializer of CACHE64_POLSEL peripheral base pointers */
  #define CACHE64_POLSEL_BASE_PTRS                 { CACHE64_POLSEL0 }
#endif

/*!
 * @}
 */ /* end of group CACHE64_POLSEL_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CAN Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAN_Peripheral_Access_Layer CAN Peripheral Access Layer
 * @{
 */

/** CAN - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[12];
  __IO uint32_t DBTP;                              /**< Data Bit Timing and Prescaler, offset: 0xC */
  __IO uint32_t TEST;                              /**< Test, offset: 0x10 */
       uint8_t RESERVED_1[4];
  __IO uint32_t CCCR;                              /**< CC Control, offset: 0x18 */
  __IO uint32_t NBTP;                              /**< Nominal Bit Timing and Prescaler, offset: 0x1C */
  __IO uint32_t TSCC;                              /**< Timestamp Counter Configuration, offset: 0x20 */
  __I  uint32_t TSCV;                              /**< Timestamp Counter Value, offset: 0x24 */
  __IO uint32_t TOCC;                              /**< Timeout Counter Configuration, offset: 0x28 */
  __I  uint32_t TOCV;                              /**< Timeout Counter Value, offset: 0x2C */
       uint8_t RESERVED_2[16];
  __I  uint32_t ECR;                               /**< Error Counter, offset: 0x40 */
  __I  uint32_t PSR;                               /**< Protocol Status, offset: 0x44 */
  __IO uint32_t TDCR;                              /**< Transmitter Delay Compensator, offset: 0x48 */
       uint8_t RESERVED_3[4];
  __IO uint32_t IR;                                /**< Interrupt, offset: 0x50 */
  __IO uint32_t IE;                                /**< Interrupt Enable, offset: 0x54 */
  __IO uint32_t ILS;                               /**< Interrupt Line Select, offset: 0x58 */
  __IO uint32_t ILE;                               /**< Interrupt Line Enable, offset: 0x5C */
       uint8_t RESERVED_4[32];
  __IO uint32_t GFC;                               /**< Global Filter Configuration, offset: 0x80 */
  __IO uint32_t SIDFC;                             /**< Standard ID Filter Configuration, offset: 0x84 */
  __IO uint32_t XIDFC;                             /**< Extended ID Filter Configuration, offset: 0x88 */
       uint8_t RESERVED_5[4];
  __IO uint32_t XIDAM;                             /**< Extended ID AND Mask, offset: 0x90 */
  __I  uint32_t HPMS;                              /**< High Priority Message Status, offset: 0x94 */
  __IO uint32_t NDAT1;                             /**< New Data 1, offset: 0x98 */
  __IO uint32_t NDAT2;                             /**< New Data 2, offset: 0x9C */
  __IO uint32_t RXF0C;                             /**< Rx FIFO 0 Configuration, offset: 0xA0 */
  __I  uint32_t RXF0S;                             /**< Rx FIFO 0 Status, offset: 0xA4 */
  __IO uint32_t RXF0A;                             /**< Rx FIFO 0 Acknowledge, offset: 0xA8 */
  __IO uint32_t RXBC;                              /**< Rx Buffer Configuration, offset: 0xAC */
  __IO uint32_t RXF1C;                             /**< Rx FIFO 1 Configuration, offset: 0xB0 */
  __I  uint32_t RXF1S;                             /**< Rx FIFO 1 Status, offset: 0xB4 */
  __IO uint32_t RXF1A;                             /**< Rx FIFO 1 Acknowledge, offset: 0xB8 */
  __IO uint32_t RXESC;                             /**< Rx Buffer and FIFO Element Size Configuration, offset: 0xBC */
  __IO uint32_t TXBC;                              /**< Tx Buffer Configuration, offset: 0xC0 */
  __IO uint32_t TXFQS;                             /**< Tx FIFO/Queue Status, offset: 0xC4 */
  __IO uint32_t TXESC;                             /**< Tx Buffer Element Size Configuration, offset: 0xC8 */
  __I  uint32_t TXBRP;                             /**< Tx Buffer Request Pending, offset: 0xCC */
  __IO uint32_t TXBAR;                             /**< Tx Buffer Add Request, offset: 0xD0 */
  __IO uint32_t TXBCR;                             /**< Tx Buffer Cancellation Request, offset: 0xD4 */
  __I  uint32_t TXBTO;                             /**< Tx Buffer Transmission Occurred, offset: 0xD8 */
  __I  uint32_t TXBCF;                             /**< Tx Buffer Cancellation Finished, offset: 0xDC */
  __IO uint32_t TXBTIE;                            /**< Tx Buffer Transmission Interrupt Enable, offset: 0xE0 */
  __IO uint32_t TXBCIE;                            /**< Tx Buffer Cancellation Finished Interrupt Enable, offset: 0xE4 */
       uint8_t RESERVED_6[8];
  __IO uint32_t TXEFC;                             /**< Tx Event FIFO Configuration, offset: 0xF0 */
  __I  uint32_t TXEFS;                             /**< Tx Event FIFO Status, offset: 0xF4 */
  __IO uint32_t TXEFA;                             /**< Tx Event FIFO Acknowledge, offset: 0xF8 */
       uint8_t RESERVED_7[260];
  __IO uint32_t MRBA;                              /**< Message RAM Base Address, offset: 0x200 */
       uint8_t RESERVED_8[508];
  __IO uint32_t ETSCC;                             /**< External Timestamp Counter Configuration, offset: 0x400 */
       uint8_t RESERVED_9[508];
  __IO uint32_t ETSCV;                             /**< External Timestamp Counter Value, offset: 0x600 */
} CAN_Type;

/* ----------------------------------------------------------------------------
   -- CAN Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAN_Register_Masks CAN Register Masks
 * @{
 */

/*! @name DBTP - Data Bit Timing and Prescaler */
/*! @{ */

#define CAN_DBTP_DSJW_MASK                       (0xFU)
#define CAN_DBTP_DSJW_SHIFT                      (0U)
/*! DSJW - Data (Re)Synchronization Jump Width
 */
#define CAN_DBTP_DSJW(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_DBTP_DSJW_SHIFT)) & CAN_DBTP_DSJW_MASK)

#define CAN_DBTP_DTSEG2_MASK                     (0xF0U)
#define CAN_DBTP_DTSEG2_SHIFT                    (4U)
/*! DTSEG2 - Data Time Segment After Sample Point
 */
#define CAN_DBTP_DTSEG2(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_DBTP_DTSEG2_SHIFT)) & CAN_DBTP_DTSEG2_MASK)

#define CAN_DBTP_DTSEG1_MASK                     (0x1F00U)
#define CAN_DBTP_DTSEG1_SHIFT                    (8U)
/*! DTSEG1 - Data Time Segment Before Sample Point
 */
#define CAN_DBTP_DTSEG1(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_DBTP_DTSEG1_SHIFT)) & CAN_DBTP_DTSEG1_MASK)

#define CAN_DBTP_DBRP_MASK                       (0x1F0000U)
#define CAN_DBTP_DBRP_SHIFT                      (16U)
/*! DBRP - Data Bit Rate Prescaler
 */
#define CAN_DBTP_DBRP(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_DBTP_DBRP_SHIFT)) & CAN_DBTP_DBRP_MASK)

#define CAN_DBTP_TDC_MASK                        (0x800000U)
#define CAN_DBTP_TDC_SHIFT                       (23U)
/*! TDC - Transmitter Delay Compensation
 *  0b0..Transmitter delay compensation disabled
 *  0b1..Transmitter delay compensation enabled
 */
#define CAN_DBTP_TDC(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_DBTP_TDC_SHIFT)) & CAN_DBTP_TDC_MASK)
/*! @} */

/*! @name TEST - Test */
/*! @{ */

#define CAN_TEST_LBCK_MASK                       (0x10U)
#define CAN_TEST_LBCK_SHIFT                      (4U)
/*! LBCK - Loop Back Mode
 *  0b0..Loop back mode is disabled.
 *  0b1..Loop back mode is enabled.
 */
#define CAN_TEST_LBCK(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_TEST_LBCK_SHIFT)) & CAN_TEST_LBCK_MASK)

#define CAN_TEST_TX_MASK                         (0x60U)
#define CAN_TEST_TX_SHIFT                        (5U)
/*! TX - Control of Transmit Pin
 *  0b00..Loop back mode is disabled.
 *  0b01..The sample point can be monitored at the CAN_TXD.
 *  0b10..CAN_TXD pin is driven LOW/dominant.
 *  0b11..CAN_TXD is driven HIGH/recessive.
 */
#define CAN_TEST_TX(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_TEST_TX_SHIFT)) & CAN_TEST_TX_MASK)

#define CAN_TEST_RX_MASK                         (0x80U)
#define CAN_TEST_RX_SHIFT                        (7U)
/*! RX - Monitors the Actual Value of the CAN_RXD
 *  0b0..The CAN bus is dominant (CAN_RXD = 0).
 *  0b1..The CAN bus is recessive (CAN_RXD = 1).
 */
#define CAN_TEST_RX(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_TEST_RX_SHIFT)) & CAN_TEST_RX_MASK)
/*! @} */

/*! @name CCCR - CC Control */
/*! @{ */

#define CAN_CCCR_INIT_MASK                       (0x1U)
#define CAN_CCCR_INIT_SHIFT                      (0U)
/*! INIT - Initialization
 *  0b0..Normal operation
 *  0b1..Initialization is started
 */
#define CAN_CCCR_INIT(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CCCR_INIT_SHIFT)) & CAN_CCCR_INIT_MASK)

#define CAN_CCCR_CCE_MASK                        (0x2U)
#define CAN_CCCR_CCE_SHIFT                       (1U)
/*! CCE - Configuration Change Enable
 *  0b0..No write access. The CPU has no write access to the protected configuration registers.
 *  0b1..Write access. The CPU has write access to the protected configuration registers.
 */
#define CAN_CCCR_CCE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_CCCR_CCE_SHIFT)) & CAN_CCCR_CCE_MASK)

#define CAN_CCCR_ASM_MASK                        (0x4U)
#define CAN_CCCR_ASM_SHIFT                       (2U)
/*! ASM - Restricted Operational Mode
 *  0b0..Normal CAN operation
 *  0b1..Restricted operation mode active
 */
#define CAN_CCCR_ASM(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_CCCR_ASM_SHIFT)) & CAN_CCCR_ASM_MASK)

#define CAN_CCCR_CSA_MASK                        (0x8U)
#define CAN_CCCR_CSA_SHIFT                       (3U)
/*! CSA - Clock Stop Acknowledge
 *  0b0..No clock stop acknowledged.
 *  0b1..MCAN may be set in Power Down mode by stopping the internal MCAN clocks.
 */
#define CAN_CCCR_CSA(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_CCCR_CSA_SHIFT)) & CAN_CCCR_CSA_MASK)

#define CAN_CCCR_CSR_MASK                        (0x10U)
#define CAN_CCCR_CSR_SHIFT                       (4U)
/*! CSR - Clock Stop Request
 *  0b0..No clock stop is requested.
 *  0b1..Clock stop requested. When clock stop is requested, first INIT and then CSA will be set after all pending
 *       transfer requests have been completed and the CAN bus reaches idle.
 */
#define CAN_CCCR_CSR(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_CCCR_CSR_SHIFT)) & CAN_CCCR_CSR_MASK)

#define CAN_CCCR_MON_MASK                        (0x20U)
#define CAN_CCCR_MON_SHIFT                       (5U)
/*! MON - Bus Monitoring Mode
 *  0b0..Bus Monitoring mode is disabled.
 *  0b1..Bus Monitoring mode is enabled.
 */
#define CAN_CCCR_MON(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_CCCR_MON_SHIFT)) & CAN_CCCR_MON_MASK)

#define CAN_CCCR_DAR_MASK                        (0x40U)
#define CAN_CCCR_DAR_SHIFT                       (6U)
/*! DAR - Disable Automatic Retransmission
 *  0b0..Automatic retransmission of messages not transmitted successfully enabled.
 *  0b1..Automatic retransmission disabled.
 */
#define CAN_CCCR_DAR(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_CCCR_DAR_SHIFT)) & CAN_CCCR_DAR_MASK)

#define CAN_CCCR_TEST_MASK                       (0x80U)
#define CAN_CCCR_TEST_SHIFT                      (7U)
/*! TEST - Test Mode Enable
 *  0b0..Normal operation
 *  0b1..Test mode enabled
 */
#define CAN_CCCR_TEST(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CCCR_TEST_SHIFT)) & CAN_CCCR_TEST_MASK)

#define CAN_CCCR_FDOE_MASK                       (0x100U)
#define CAN_CCCR_FDOE_SHIFT                      (8U)
/*! FDOE - CAN FD Operation Enable
 *  0b0..CAN FD operation is disabled.
 *  0b1..CAN FD operation is enabled.
 */
#define CAN_CCCR_FDOE(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CCCR_FDOE_SHIFT)) & CAN_CCCR_FDOE_MASK)

#define CAN_CCCR_BRSE_MASK                       (0x200U)
#define CAN_CCCR_BRSE_SHIFT                      (9U)
/*! BRSE - Bit Rate Switching Enable
 *  0b0..Bit rate switching for transmissions is disabled.
 *  0b1..Bit rate switching for transmission is enabled.
 */
#define CAN_CCCR_BRSE(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CCCR_BRSE_SHIFT)) & CAN_CCCR_BRSE_MASK)

#define CAN_CCCR_PXHD_MASK                       (0x1000U)
#define CAN_CCCR_PXHD_SHIFT                      (12U)
/*! PXHD - Protocol Exception Handling Disable
 *  0b0..Protocol exception handling is enabled.
 *  0b1..Protocol exception handling is disabled.
 */
#define CAN_CCCR_PXHD(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CCCR_PXHD_SHIFT)) & CAN_CCCR_PXHD_MASK)

#define CAN_CCCR_EFBI_MASK                       (0x2000U)
#define CAN_CCCR_EFBI_SHIFT                      (13U)
/*! EFBI - Edge Filtering During Bus Integration
 *  0b0..Edge filtering is disabled.
 *  0b1..Two consecutive dominant quanta required to detect an edge for hard synchronization.
 */
#define CAN_CCCR_EFBI(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CCCR_EFBI_SHIFT)) & CAN_CCCR_EFBI_MASK)

#define CAN_CCCR_TXP_MASK                        (0x4000U)
#define CAN_CCCR_TXP_SHIFT                       (14U)
/*! TXP - Transmit Pause
 *  0b0..Transmit pause is disabled.
 *  0b1..Transmit pause is enabled.
 */
#define CAN_CCCR_TXP(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_CCCR_TXP_SHIFT)) & CAN_CCCR_TXP_MASK)

#define CAN_CCCR_NISO_MASK                       (0x8000U)
#define CAN_CCCR_NISO_SHIFT                      (15U)
/*! NISO - Non ISO Operation
 *  0b0..CAN FD frame format will follow according to ISO11898-1.
 *  0b1..CAN FD frame format will follow according to Bosch CAN FD Specification V1.0.
 */
#define CAN_CCCR_NISO(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CCCR_NISO_SHIFT)) & CAN_CCCR_NISO_MASK)
/*! @} */

/*! @name NBTP - Nominal Bit Timing and Prescaler */
/*! @{ */

#define CAN_NBTP_NTSEG2_MASK                     (0x7FU)
#define CAN_NBTP_NTSEG2_SHIFT                    (0U)
/*! NTSEG2 - Nominal Time Segment After Sample Point
 */
#define CAN_NBTP_NTSEG2(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_NBTP_NTSEG2_SHIFT)) & CAN_NBTP_NTSEG2_MASK)

#define CAN_NBTP_NTSEG1_MASK                     (0xFF00U)
#define CAN_NBTP_NTSEG1_SHIFT                    (8U)
/*! NTSEG1 - Nominal Time Segment Before Sample Point
 */
#define CAN_NBTP_NTSEG1(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_NBTP_NTSEG1_SHIFT)) & CAN_NBTP_NTSEG1_MASK)

#define CAN_NBTP_NBRP_MASK                       (0x1FF0000U)
#define CAN_NBTP_NBRP_SHIFT                      (16U)
/*! NBRP - Nominal Bit Rate Prescaler
 */
#define CAN_NBTP_NBRP(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_NBTP_NBRP_SHIFT)) & CAN_NBTP_NBRP_MASK)

#define CAN_NBTP_NSJW_MASK                       (0xFE000000U)
#define CAN_NBTP_NSJW_SHIFT                      (25U)
/*! NSJW - Nominal (Re)Synchronization Jump Width
 */
#define CAN_NBTP_NSJW(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_NBTP_NSJW_SHIFT)) & CAN_NBTP_NSJW_MASK)
/*! @} */

/*! @name TSCC - Timestamp Counter Configuration */
/*! @{ */

#define CAN_TSCC_TSS_MASK                        (0x3U)
#define CAN_TSCC_TSS_SHIFT                       (0U)
/*! TSS - Timestamp Select
 *  0b00, 0b11..Timestamp counter value static at 0x0000
 *  0b01..Timestamp counter value incremented according to TCP bits
 *  0b10..External timestamp counter value used
 */
#define CAN_TSCC_TSS(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_TSCC_TSS_SHIFT)) & CAN_TSCC_TSS_MASK)

#define CAN_TSCC_TCP_MASK                        (0xF0000U)
#define CAN_TSCC_TCP_SHIFT                       (16U)
/*! TCP - Timestamp Counter Prescaler
 */
#define CAN_TSCC_TCP(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_TSCC_TCP_SHIFT)) & CAN_TSCC_TCP_MASK)
/*! @} */

/*! @name TSCV - Timestamp Counter Value */
/*! @{ */

#define CAN_TSCV_TSC_MASK                        (0xFFFFU)
#define CAN_TSCV_TSC_SHIFT                       (0U)
/*! TSC - Timestamp Counter
 */
#define CAN_TSCV_TSC(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_TSCV_TSC_SHIFT)) & CAN_TSCV_TSC_MASK)
/*! @} */

/*! @name TOCC - Timeout Counter Configuration */
/*! @{ */

#define CAN_TOCC_ETOC_MASK                       (0x1U)
#define CAN_TOCC_ETOC_SHIFT                      (0U)
/*! ETOC - Enable Timeout Counter
 *  0b0..Timeout counter is disabled.
 *  0b1..Timeout counter is enabled.
 */
#define CAN_TOCC_ETOC(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_TOCC_ETOC_SHIFT)) & CAN_TOCC_ETOC_MASK)

#define CAN_TOCC_TOS_MASK                        (0x6U)
#define CAN_TOCC_TOS_SHIFT                       (1U)
/*! TOS - Timeout Select
 *  0b00..Continuous operation
 *  0b01..Timeout is controlled by Tx event FIFO.
 *  0b10..Timeout is controlled by Rx FIFO 0.
 *  0b11..Timeout is controlled by Rx FIFO 1.
 */
#define CAN_TOCC_TOS(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_TOCC_TOS_SHIFT)) & CAN_TOCC_TOS_MASK)

#define CAN_TOCC_TOP_MASK                        (0xFFFF0000U)
#define CAN_TOCC_TOP_SHIFT                       (16U)
/*! TOP - Timeout Period
 */
#define CAN_TOCC_TOP(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_TOCC_TOP_SHIFT)) & CAN_TOCC_TOP_MASK)
/*! @} */

/*! @name TOCV - Timeout Counter Value */
/*! @{ */

#define CAN_TOCV_TOC_MASK                        (0xFFFFU)
#define CAN_TOCV_TOC_SHIFT                       (0U)
/*! TOC - Timeout Counter
 */
#define CAN_TOCV_TOC(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_TOCV_TOC_SHIFT)) & CAN_TOCV_TOC_MASK)
/*! @} */

/*! @name ECR - Error Counter */
/*! @{ */

#define CAN_ECR_TEC_MASK                         (0xFFU)
#define CAN_ECR_TEC_SHIFT                        (0U)
/*! TEC - Transmit Error Counter
 */
#define CAN_ECR_TEC(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_ECR_TEC_SHIFT)) & CAN_ECR_TEC_MASK)

#define CAN_ECR_REC_MASK                         (0x7F00U)
#define CAN_ECR_REC_SHIFT                        (8U)
/*! REC - Receive Error Counter
 */
#define CAN_ECR_REC(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_ECR_REC_SHIFT)) & CAN_ECR_REC_MASK)

#define CAN_ECR_RP_MASK                          (0x8000U)
#define CAN_ECR_RP_SHIFT                         (15U)
/*! RP - Receive Error Passive
 *  0b0..Below error level. The receive counter is below the error passive level of 128.
 *  0b1..At error level. The receive counter has reached the error passive level of 128.
 */
#define CAN_ECR_RP(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_ECR_RP_SHIFT)) & CAN_ECR_RP_MASK)

#define CAN_ECR_CEL_MASK                         (0xFF0000U)
#define CAN_ECR_CEL_SHIFT                        (16U)
/*! CEL - CAN Error Logging
 */
#define CAN_ECR_CEL(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_ECR_CEL_SHIFT)) & CAN_ECR_CEL_MASK)
/*! @} */

/*! @name PSR - Protocol Status */
/*! @{ */

#define CAN_PSR_LEC_MASK                         (0x7U)
#define CAN_PSR_LEC_SHIFT                        (0U)
/*! LEC - Last Error Code
 *  0b000..No error: No error has occurred since the LEC bits has been reset by successful reception or transmission.
 *  0b001..Stuff error: More than 5 equal bits in a sequence have occurred in a part of a received message where not allowed.
 *  0b010..Form error: A fixed format part of a received frame has the wrong format.
 *  0b011..AckError: The message transmitted by the MCAN was not acknowledged by another node.
 *  0b100..Bit1Error: During the transmission of a message (with the exception of the arbitration field), the
 *         device wanted to send a recessive level (bit of logical value 1), but the monitored bus value was dominant.
 *  0b101..Bit0Error: During the transmission of a message (or acknowledge bit, or active error flag, or overload
 *         flag), the device wanted to send a dominant level (data or identifier bit logical value 0), but the
 *         monitored bus value was recessive. During Bus_Off recovery this status is set each time a sequence of 11
 *         recessive bits has been monitored. This enables the CPU to monitor the processing of the Bus_Off recovery
 *         sequence (indicating the bus is not stuck at dominant or continuously disturbed).
 *  0b110..CRCError: The CRC check sum of a received message was incorrect. The CRC of an incoming message does
 *         not match with the CRC calculated from the received data.
 *  0b111..NoChange: Any read access to the protocol status register re-initializes the LEC bits to 0x7. When the
 *         LEC equals the value 0x7, no CAN bus event was detected since the last CPU read access to the protocol
 *         status register.
 */
#define CAN_PSR_LEC(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_PSR_LEC_SHIFT)) & CAN_PSR_LEC_MASK)

#define CAN_PSR_ACT_MASK                         (0x18U)
#define CAN_PSR_ACT_SHIFT                        (3U)
/*! ACT - Activity
 *  0b00..Synchronizing - node is synchronizing on CAN communication.
 *  0b01..Idle - node is neither receiver nor transmitter.
 *  0b10..Receiver - node is operating as receiver.
 *  0b11..Transmitter - node is operating as transmitter.
 */
#define CAN_PSR_ACT(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_PSR_ACT_SHIFT)) & CAN_PSR_ACT_MASK)

#define CAN_PSR_EP_MASK                          (0x20U)
#define CAN_PSR_EP_SHIFT                         (5U)
/*! EP - Error Passive
 *  0b0..The MCAN is in Error_Active state. It normally takes part in bus communication and sends an active error
 *       flag when an error has been detected.
 *  0b1..The MCAN is in the Error_Passive state.
 */
#define CAN_PSR_EP(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_PSR_EP_SHIFT)) & CAN_PSR_EP_MASK)

#define CAN_PSR_EW_MASK                          (0x40U)
#define CAN_PSR_EW_SHIFT                         (6U)
/*! EW - Warning Status
 *  0b0..Both error counters are below the Error_Warning limit of 96.
 *  0b1..At least one of error counter has reached the Error_Warning limit of 96.
 */
#define CAN_PSR_EW(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_PSR_EW_SHIFT)) & CAN_PSR_EW_MASK)

#define CAN_PSR_BO_MASK                          (0x80U)
#define CAN_PSR_BO_SHIFT                         (7U)
/*! BO - Bus Off Status
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CAN_PSR_BO(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_PSR_BO_SHIFT)) & CAN_PSR_BO_MASK)

#define CAN_PSR_DLEC_MASK                        (0x700U)
#define CAN_PSR_DLEC_SHIFT                       (8U)
/*! DLEC - Data Phase Last Error Code
 */
#define CAN_PSR_DLEC(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_PSR_DLEC_SHIFT)) & CAN_PSR_DLEC_MASK)

#define CAN_PSR_RESI_MASK                        (0x800U)
#define CAN_PSR_RESI_SHIFT                       (11U)
/*! RESI - ESI Flag of the Last Received CAN FD Message
 *  0b0..Last received CAN FD message did not have its ESI flag set.
 *  0b1..Last received CAN FD message had its ESI flag set.
 */
#define CAN_PSR_RESI(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_PSR_RESI_SHIFT)) & CAN_PSR_RESI_MASK)

#define CAN_PSR_RBRS_MASK                        (0x1000U)
#define CAN_PSR_RBRS_SHIFT                       (12U)
/*! RBRS - BRS Flag of Last Received CAN FD Message
 *  0b0..Last received CAN FD message did not have its BRS flag set.
 *  0b1..Last received CAN FD message had its BRS flag set.
 */
#define CAN_PSR_RBRS(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_PSR_RBRS_SHIFT)) & CAN_PSR_RBRS_MASK)

#define CAN_PSR_RFDF_MASK                        (0x2000U)
#define CAN_PSR_RFDF_SHIFT                       (13U)
/*! RFDF - Received a CAN FD Message
 *  0b0..No CAN FD message received since the last CPU reset.
 *  0b1..Message in CAN FD format with FDF flag set has been received.
 */
#define CAN_PSR_RFDF(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_PSR_RFDF_SHIFT)) & CAN_PSR_RFDF_MASK)

#define CAN_PSR_PXE_MASK                         (0x4000U)
#define CAN_PSR_PXE_SHIFT                        (14U)
/*! PXE - Protocol Exception Event
 *  0b0..No protocol exception event occurred since last read access.
 *  0b1..Protocol exception event occurred.
 */
#define CAN_PSR_PXE(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_PSR_PXE_SHIFT)) & CAN_PSR_PXE_MASK)

#define CAN_PSR_TDCV_MASK                        (0x7F0000U)
#define CAN_PSR_TDCV_SHIFT                       (16U)
/*! TDCV - Transmitter Delay Compensation Value
 */
#define CAN_PSR_TDCV(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_PSR_TDCV_SHIFT)) & CAN_PSR_TDCV_MASK)
/*! @} */

/*! @name TDCR - Transmitter Delay Compensator */
/*! @{ */

#define CAN_TDCR_TDCF_MASK                       (0x7FU)
#define CAN_TDCR_TDCF_SHIFT                      (0U)
/*! TDCF - Transmitter Delay Compensation Filter Window Length
 */
#define CAN_TDCR_TDCF(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_TDCR_TDCF_SHIFT)) & CAN_TDCR_TDCF_MASK)

#define CAN_TDCR_TDCO_MASK                       (0x7F00U)
#define CAN_TDCR_TDCO_SHIFT                      (8U)
/*! TDCO - Transmitter Delay Compensation Offset
 */
#define CAN_TDCR_TDCO(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_TDCR_TDCO_SHIFT)) & CAN_TDCR_TDCO_MASK)
/*! @} */

/*! @name IR - Interrupt */
/*! @{ */

#define CAN_IR_RF0N_MASK                         (0x1U)
#define CAN_IR_RF0N_SHIFT                        (0U)
/*! RF0N - Rx FIFO 0 New Message
 *  0b0..No new message written to Rx FIFO 0.
 *  0b1..New message written to Rx FIFO 0.
 */
#define CAN_IR_RF0N(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IR_RF0N_SHIFT)) & CAN_IR_RF0N_MASK)

#define CAN_IR_RF0W_MASK                         (0x2U)
#define CAN_IR_RF0W_SHIFT                        (1U)
/*! RF0W - Rx FIFO 0 Watermark Reached
 *  0b0..Rx FIFO 0 fill level below watermark.
 *  0b1..Rx FIFO 0 fill level reached watermark.
 */
#define CAN_IR_RF0W(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IR_RF0W_SHIFT)) & CAN_IR_RF0W_MASK)

#define CAN_IR_RF0F_MASK                         (0x4U)
#define CAN_IR_RF0F_SHIFT                        (2U)
/*! RF0F - Rx FIFO 0 Full
 *  0b0..Rx FIFO 0 not full.
 *  0b1..Rx FIFO 0 full.
 */
#define CAN_IR_RF0F(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IR_RF0F_SHIFT)) & CAN_IR_RF0F_MASK)

#define CAN_IR_RF0L_MASK                         (0x8U)
#define CAN_IR_RF0L_SHIFT                        (3U)
/*! RF0L - Rx FIFO 0 Message Lost
 *  0b0..No Rx FIFO 0 message lost.
 *  0b1..Rx FIFO 0 message lost, also set after write attempt to Rx FIFO 0 of size zero.
 */
#define CAN_IR_RF0L(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IR_RF0L_SHIFT)) & CAN_IR_RF0L_MASK)

#define CAN_IR_RF1N_MASK                         (0x10U)
#define CAN_IR_RF1N_SHIFT                        (4U)
/*! RF1N - Rx FIFO 1 New Message
 *  0b0..No new message written to Rx FIFO 1.
 *  0b1..New message written to Rx FIFO 1.
 */
#define CAN_IR_RF1N(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IR_RF1N_SHIFT)) & CAN_IR_RF1N_MASK)

#define CAN_IR_RF1W_MASK                         (0x20U)
#define CAN_IR_RF1W_SHIFT                        (5U)
/*! RF1W - Rx FIFO 1 Watermark Reached
 *  0b0..Rx FIFO 1 fill level below watermark.
 *  0b1..Rx FIFO 1 fill level reached watermark.
 */
#define CAN_IR_RF1W(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IR_RF1W_SHIFT)) & CAN_IR_RF1W_MASK)

#define CAN_IR_RF1F_MASK                         (0x40U)
#define CAN_IR_RF1F_SHIFT                        (6U)
/*! RF1F - Rx FIFO 1 Full
 *  0b0..Rx FIFO 1 not full.
 *  0b1..Rx FIFO 1 full.
 */
#define CAN_IR_RF1F(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IR_RF1F_SHIFT)) & CAN_IR_RF1F_MASK)

#define CAN_IR_RF1L_MASK                         (0x80U)
#define CAN_IR_RF1L_SHIFT                        (7U)
/*! RF1L - Rx FIFO 1 Message Lost
 *  0b0..No Rx FIFO 1 message lost.
 *  0b1..Rx FIFO 1 message lost, also set after write attempt to Rx FIFO 1 of size zero.
 */
#define CAN_IR_RF1L(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IR_RF1L_SHIFT)) & CAN_IR_RF1L_MASK)

#define CAN_IR_HPM_MASK                          (0x100U)
#define CAN_IR_HPM_SHIFT                         (8U)
/*! HPM - High Priority Message
 *  0b0..No high priority message received.
 *  0b1..High priority message received.
 */
#define CAN_IR_HPM(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IR_HPM_SHIFT)) & CAN_IR_HPM_MASK)

#define CAN_IR_TC_MASK                           (0x200U)
#define CAN_IR_TC_SHIFT                          (9U)
/*! TC - Transmission Completed
 *  0b0..No transmission completed.
 *  0b1..Transmission completed.
 */
#define CAN_IR_TC(x)                             (((uint32_t)(((uint32_t)(x)) << CAN_IR_TC_SHIFT)) & CAN_IR_TC_MASK)

#define CAN_IR_TCF_MASK                          (0x400U)
#define CAN_IR_TCF_SHIFT                         (10U)
/*! TCF - Transmission Cancellation Finished
 *  0b0..No transmission cancellation finished.
 *  0b1..Transmission cancellation finished.
 */
#define CAN_IR_TCF(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IR_TCF_SHIFT)) & CAN_IR_TCF_MASK)

#define CAN_IR_TFE_MASK                          (0x800U)
#define CAN_IR_TFE_SHIFT                         (11U)
/*! TFE - Tx FIFO Empty
 *  0b0..Tx FIFO non-empty.
 *  0b1..Tx FIFO empty.
 */
#define CAN_IR_TFE(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IR_TFE_SHIFT)) & CAN_IR_TFE_MASK)

#define CAN_IR_TEFN_MASK                         (0x1000U)
#define CAN_IR_TEFN_SHIFT                        (12U)
/*! TEFN - Tx Event FIFO New Entry
 *  0b0..Tx event FIFO unchanged.
 *  0b1..Tx Handler wrote Tx event FIFO element.
 */
#define CAN_IR_TEFN(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IR_TEFN_SHIFT)) & CAN_IR_TEFN_MASK)

#define CAN_IR_TEFW_MASK                         (0x2000U)
#define CAN_IR_TEFW_SHIFT                        (13U)
/*! TEFW - Tx Event FIFO Watermark Reached
 *  0b0..Tx event FIFO fill level below watermark.
 *  0b1..Tx event FIFO fill level reached watermark.
 */
#define CAN_IR_TEFW(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IR_TEFW_SHIFT)) & CAN_IR_TEFW_MASK)

#define CAN_IR_TEFF_MASK                         (0x4000U)
#define CAN_IR_TEFF_SHIFT                        (14U)
/*! TEFF - Tx Event FIFO Full
 *  0b0..Tx event FIFO not full.
 *  0b1..Tx event FIFO full.
 */
#define CAN_IR_TEFF(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IR_TEFF_SHIFT)) & CAN_IR_TEFF_MASK)

#define CAN_IR_TEFL_MASK                         (0x8000U)
#define CAN_IR_TEFL_SHIFT                        (15U)
/*! TEFL - Tx Event FIFO Element Lost
 *  0b0..No Tx event FIFO element lost.
 *  0b1..Tx event FIFO element lost, also set after write attempt to Tx event FIFO of size zero.
 */
#define CAN_IR_TEFL(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IR_TEFL_SHIFT)) & CAN_IR_TEFL_MASK)

#define CAN_IR_TSW_MASK                          (0x10000U)
#define CAN_IR_TSW_SHIFT                         (16U)
/*! TSW - Timestamp Wraparound
 *  0b0..No timestamp counter wraparound.
 *  0b1..Timestamp counter wrapped around.
 */
#define CAN_IR_TSW(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IR_TSW_SHIFT)) & CAN_IR_TSW_MASK)

#define CAN_IR_MRAF_MASK                         (0x20000U)
#define CAN_IR_MRAF_SHIFT                        (17U)
/*! MRAF - Message RAM Access Failure
 *  0b0..No message RAM access failure occurred.
 *  0b1..Message RAM access failure occurred.
 */
#define CAN_IR_MRAF(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IR_MRAF_SHIFT)) & CAN_IR_MRAF_MASK)

#define CAN_IR_TOO_MASK                          (0x40000U)
#define CAN_IR_TOO_SHIFT                         (18U)
/*! TOO - Timeout Occurred
 *  0b0..No timeout.
 *  0b1..Timeout reached.
 */
#define CAN_IR_TOO(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IR_TOO_SHIFT)) & CAN_IR_TOO_MASK)

#define CAN_IR_DRX_MASK                          (0x80000U)
#define CAN_IR_DRX_SHIFT                         (19U)
/*! DRX - Message Stored in Dedicated Rx Buffer
 *  0b0..No Rx buffer updated.
 *  0b1..At least one received message stored into an Rx buffer.
 */
#define CAN_IR_DRX(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IR_DRX_SHIFT)) & CAN_IR_DRX_MASK)

#define CAN_IR_BEC_MASK                          (0x100000U)
#define CAN_IR_BEC_SHIFT                         (20U)
/*! BEC - Bit Error Corrected
 *  0b0..No bit error detected when reading from message RAM.
 *  0b1..Bit error detected and corrected (example, ECC).
 */
#define CAN_IR_BEC(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IR_BEC_SHIFT)) & CAN_IR_BEC_MASK)

#define CAN_IR_BEU_MASK                          (0x200000U)
#define CAN_IR_BEU_SHIFT                         (21U)
/*! BEU - Bit Error Uncorrected
 *  0b0..No bit error detected when reading from message RAM.
 *  0b1..Bit error detected, uncorrected (example, parity logic).
 */
#define CAN_IR_BEU(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IR_BEU_SHIFT)) & CAN_IR_BEU_MASK)

#define CAN_IR_ELO_MASK                          (0x400000U)
#define CAN_IR_ELO_SHIFT                         (22U)
/*! ELO - Error Logging Overflow
 *  0b0..CAN error logging counter did not overflow.
 *  0b1..Overflow of CAN error logging counter occurred.
 */
#define CAN_IR_ELO(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IR_ELO_SHIFT)) & CAN_IR_ELO_MASK)

#define CAN_IR_EP_MASK                           (0x800000U)
#define CAN_IR_EP_SHIFT                          (23U)
/*! EP - Error Passive
 *  0b0..Error_Passive status unchanged.
 *  0b1..Error_Passive status changed.
 */
#define CAN_IR_EP(x)                             (((uint32_t)(((uint32_t)(x)) << CAN_IR_EP_SHIFT)) & CAN_IR_EP_MASK)

#define CAN_IR_EW_MASK                           (0x1000000U)
#define CAN_IR_EW_SHIFT                          (24U)
/*! EW - Warning Status
 *  0b0..Error_Warning status unchanged.
 *  0b1..Error_Warning status changed.
 */
#define CAN_IR_EW(x)                             (((uint32_t)(((uint32_t)(x)) << CAN_IR_EW_SHIFT)) & CAN_IR_EW_MASK)

#define CAN_IR_BO_MASK                           (0x2000000U)
#define CAN_IR_BO_SHIFT                          (25U)
/*! BO - Bus_Off Status
 *  0b0..Bus_Off status unchanged.
 *  0b1..Bus_Off status changed.
 */
#define CAN_IR_BO(x)                             (((uint32_t)(((uint32_t)(x)) << CAN_IR_BO_SHIFT)) & CAN_IR_BO_MASK)

#define CAN_IR_WDI_MASK                          (0x4000000U)
#define CAN_IR_WDI_SHIFT                         (26U)
/*! WDI - Watchdog Interrupt
 *  0b0..No message RAM watchdog event occurred.
 *  0b1..Message RAM watchdog event due to missing READY.
 */
#define CAN_IR_WDI(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IR_WDI_SHIFT)) & CAN_IR_WDI_MASK)

#define CAN_IR_PEA_MASK                          (0x8000000U)
#define CAN_IR_PEA_SHIFT                         (27U)
/*! PEA - Protocol Error in Arbitration Phase
 *  0b0..No protocol error in arbitration phase.
 *  0b1..Protocol error in arbitration phase detected.
 */
#define CAN_IR_PEA(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IR_PEA_SHIFT)) & CAN_IR_PEA_MASK)

#define CAN_IR_PED_MASK                          (0x10000000U)
#define CAN_IR_PED_SHIFT                         (28U)
/*! PED - Protocol Error in Data Phase
 *  0b0..No protocol error in data phase.
 *  0b1..Protocol error in data phase detected.
 */
#define CAN_IR_PED(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IR_PED_SHIFT)) & CAN_IR_PED_MASK)

#define CAN_IR_ARA_MASK                          (0x20000000U)
#define CAN_IR_ARA_SHIFT                         (29U)
/*! ARA - Access to Reserved Address
 *  0b0..No access to reserved address occurred.
 *  0b1..Access to reserved address occurred.
 */
#define CAN_IR_ARA(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IR_ARA_SHIFT)) & CAN_IR_ARA_MASK)
/*! @} */

/*! @name IE - Interrupt Enable */
/*! @{ */

#define CAN_IE_RF0NE_MASK                        (0x1U)
#define CAN_IE_RF0NE_SHIFT                       (0U)
/*! RF0NE - Rx FIFO 0 New Message Interrupt Enable
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_IE_RF0NE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_IE_RF0NE_SHIFT)) & CAN_IE_RF0NE_MASK)

#define CAN_IE_RF0WE_MASK                        (0x2U)
#define CAN_IE_RF0WE_SHIFT                       (1U)
/*! RF0WE - Rx FIFO 0 Watermark Reached Interrupt Enable
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_IE_RF0WE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_IE_RF0WE_SHIFT)) & CAN_IE_RF0WE_MASK)

#define CAN_IE_RF0FE_MASK                        (0x4U)
#define CAN_IE_RF0FE_SHIFT                       (2U)
/*! RF0FE - Rx FIFO 0 Full Interrupt Enable
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_IE_RF0FE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_IE_RF0FE_SHIFT)) & CAN_IE_RF0FE_MASK)

#define CAN_IE_RF0LE_MASK                        (0x8U)
#define CAN_IE_RF0LE_SHIFT                       (3U)
/*! RF0LE - Rx FIFO 0 Message Lost Interrupt Enable
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_IE_RF0LE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_IE_RF0LE_SHIFT)) & CAN_IE_RF0LE_MASK)

#define CAN_IE_RF1NE_MASK                        (0x10U)
#define CAN_IE_RF1NE_SHIFT                       (4U)
/*! RF1NE - Rx FIFO 1 New Message Interrupt Enable
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_IE_RF1NE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_IE_RF1NE_SHIFT)) & CAN_IE_RF1NE_MASK)

#define CAN_IE_RF1WE_MASK                        (0x20U)
#define CAN_IE_RF1WE_SHIFT                       (5U)
/*! RF1WE - Rx FIFO 1 Watermark Reached Interrupt Enable
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_IE_RF1WE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_IE_RF1WE_SHIFT)) & CAN_IE_RF1WE_MASK)

#define CAN_IE_RF1FE_MASK                        (0x40U)
#define CAN_IE_RF1FE_SHIFT                       (6U)
/*! RF1FE - Rx FIFO 1 Full Interrupt Enable
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_IE_RF1FE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_IE_RF1FE_SHIFT)) & CAN_IE_RF1FE_MASK)

#define CAN_IE_RF1LE_MASK                        (0x80U)
#define CAN_IE_RF1LE_SHIFT                       (7U)
/*! RF1LE - Rx FIFO 1 Message Lost Interrupt Enable
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_IE_RF1LE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_IE_RF1LE_SHIFT)) & CAN_IE_RF1LE_MASK)

#define CAN_IE_HPME_MASK                         (0x100U)
#define CAN_IE_HPME_SHIFT                        (8U)
/*! HPME - High Priority Message Interrupt Enable
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_IE_HPME(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IE_HPME_SHIFT)) & CAN_IE_HPME_MASK)

#define CAN_IE_TCE_MASK                          (0x200U)
#define CAN_IE_TCE_SHIFT                         (9U)
/*! TCE - Transmission Completed Interrupt Enable
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_IE_TCE(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IE_TCE_SHIFT)) & CAN_IE_TCE_MASK)

#define CAN_IE_TCFE_MASK                         (0x400U)
#define CAN_IE_TCFE_SHIFT                        (10U)
/*! TCFE - Transmission Cancellation Finished Interrupt Enable
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_IE_TCFE(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IE_TCFE_SHIFT)) & CAN_IE_TCFE_MASK)

#define CAN_IE_TFEE_MASK                         (0x800U)
#define CAN_IE_TFEE_SHIFT                        (11U)
/*! TFEE - Tx FIFO Empty Interrupt Enable
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_IE_TFEE(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IE_TFEE_SHIFT)) & CAN_IE_TFEE_MASK)

#define CAN_IE_TEFNE_MASK                        (0x1000U)
#define CAN_IE_TEFNE_SHIFT                       (12U)
/*! TEFNE - Tx Event FIFO New Entry Interrupt Enable
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_IE_TEFNE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_IE_TEFNE_SHIFT)) & CAN_IE_TEFNE_MASK)

#define CAN_IE_TEFWE_MASK                        (0x2000U)
#define CAN_IE_TEFWE_SHIFT                       (13U)
/*! TEFWE - Tx Event FIFO Watermark Reached Interrupt Enable
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_IE_TEFWE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_IE_TEFWE_SHIFT)) & CAN_IE_TEFWE_MASK)

#define CAN_IE_TEFFE_MASK                        (0x4000U)
#define CAN_IE_TEFFE_SHIFT                       (14U)
/*! TEFFE - Tx Event FIFO Full Interrupt Enable
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_IE_TEFFE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_IE_TEFFE_SHIFT)) & CAN_IE_TEFFE_MASK)

#define CAN_IE_TEFLE_MASK                        (0x8000U)
#define CAN_IE_TEFLE_SHIFT                       (15U)
/*! TEFLE - Tx Event FIFO Element Lost Interrupt Enable
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_IE_TEFLE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_IE_TEFLE_SHIFT)) & CAN_IE_TEFLE_MASK)

#define CAN_IE_TSWE_MASK                         (0x10000U)
#define CAN_IE_TSWE_SHIFT                        (16U)
/*! TSWE - Timestamp Wraparound Interrupt Enable
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_IE_TSWE(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IE_TSWE_SHIFT)) & CAN_IE_TSWE_MASK)

#define CAN_IE_MRAFE_MASK                        (0x20000U)
#define CAN_IE_MRAFE_SHIFT                       (17U)
/*! MRAFE - Message RAM Access Failure Interrupt Enable
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_IE_MRAFE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_IE_MRAFE_SHIFT)) & CAN_IE_MRAFE_MASK)

#define CAN_IE_TOOE_MASK                         (0x40000U)
#define CAN_IE_TOOE_SHIFT                        (18U)
/*! TOOE - Timeout Occurred Interrupt Enable
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_IE_TOOE(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IE_TOOE_SHIFT)) & CAN_IE_TOOE_MASK)

#define CAN_IE_DRXE_MASK                         (0x80000U)
#define CAN_IE_DRXE_SHIFT                        (19U)
/*! DRXE - Message Stored in Dedicated Rx Buffer Interrupt Enable
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_IE_DRXE(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IE_DRXE_SHIFT)) & CAN_IE_DRXE_MASK)

#define CAN_IE_BECE_MASK                         (0x100000U)
#define CAN_IE_BECE_SHIFT                        (20U)
/*! BECE - Bit Error Corrected Interrupt Enable
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_IE_BECE(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IE_BECE_SHIFT)) & CAN_IE_BECE_MASK)

#define CAN_IE_BEUE_MASK                         (0x200000U)
#define CAN_IE_BEUE_SHIFT                        (21U)
/*! BEUE - Bit Error Uncorrected Interrupt Enable
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_IE_BEUE(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IE_BEUE_SHIFT)) & CAN_IE_BEUE_MASK)

#define CAN_IE_ELOE_MASK                         (0x400000U)
#define CAN_IE_ELOE_SHIFT                        (22U)
/*! ELOE - Error Logging Overflow Interrupt Enable
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_IE_ELOE(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IE_ELOE_SHIFT)) & CAN_IE_ELOE_MASK)

#define CAN_IE_EPE_MASK                          (0x800000U)
#define CAN_IE_EPE_SHIFT                         (23U)
/*! EPE - Error Passive Interrupt Enable
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_IE_EPE(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IE_EPE_SHIFT)) & CAN_IE_EPE_MASK)

#define CAN_IE_EWE_MASK                          (0x1000000U)
#define CAN_IE_EWE_SHIFT                         (24U)
/*! EWE - Warning Status Interrupt Enable
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_IE_EWE(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IE_EWE_SHIFT)) & CAN_IE_EWE_MASK)

#define CAN_IE_BOE_MASK                          (0x2000000U)
#define CAN_IE_BOE_SHIFT                         (25U)
/*! BOE - Bus_Off Status Interrupt Enable
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_IE_BOE(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_IE_BOE_SHIFT)) & CAN_IE_BOE_MASK)

#define CAN_IE_WDIE_MASK                         (0x4000000U)
#define CAN_IE_WDIE_SHIFT                        (26U)
/*! WDIE - Watchdog Interrupt Enable
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_IE_WDIE(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IE_WDIE_SHIFT)) & CAN_IE_WDIE_MASK)

#define CAN_IE_PEAE_MASK                         (0x8000000U)
#define CAN_IE_PEAE_SHIFT                        (27U)
/*! PEAE - Protocol Error in Arbitration Phase Interrupt Enable
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_IE_PEAE(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IE_PEAE_SHIFT)) & CAN_IE_PEAE_MASK)

#define CAN_IE_PEDE_MASK                         (0x10000000U)
#define CAN_IE_PEDE_SHIFT                        (28U)
/*! PEDE - Protocol Error in Data Phase Interrupt Enable
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_IE_PEDE(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IE_PEDE_SHIFT)) & CAN_IE_PEDE_MASK)

#define CAN_IE_ARAE_MASK                         (0x20000000U)
#define CAN_IE_ARAE_SHIFT                        (29U)
/*! ARAE - Access to Reserved Address Interrupt Enable
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_IE_ARAE(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_IE_ARAE_SHIFT)) & CAN_IE_ARAE_MASK)
/*! @} */

/*! @name ILS - Interrupt Line Select */
/*! @{ */

#define CAN_ILS_RF0NL_MASK                       (0x1U)
#define CAN_ILS_RF0NL_SHIFT                      (0U)
/*! RF0NL - Rx FIFO 0 New Message Interrupt Line
 *  0b0..Interrupt assigned to interrupt line MCANx_INT0
 *  0b1..Interrupt assigned to interrupt line MCANx_INT1
 */
#define CAN_ILS_RF0NL(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ILS_RF0NL_SHIFT)) & CAN_ILS_RF0NL_MASK)

#define CAN_ILS_RF0WL_MASK                       (0x2U)
#define CAN_ILS_RF0WL_SHIFT                      (1U)
/*! RF0WL - Rx FIFO 0 Watermark Reached Interrupt Line
 *  0b0..Interrupt assigned to interrupt line MCANx_INT0
 *  0b1..Interrupt assigned to interrupt line MCANx_INT1
 */
#define CAN_ILS_RF0WL(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ILS_RF0WL_SHIFT)) & CAN_ILS_RF0WL_MASK)

#define CAN_ILS_RF0FL_MASK                       (0x4U)
#define CAN_ILS_RF0FL_SHIFT                      (2U)
/*! RF0FL - Rx FIFO 0 Full Interrupt Line
 *  0b0..Interrupt assigned to interrupt line MCANx_INT0
 *  0b1..Interrupt assigned to interrupt line MCANx_INT1
 */
#define CAN_ILS_RF0FL(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ILS_RF0FL_SHIFT)) & CAN_ILS_RF0FL_MASK)

#define CAN_ILS_RF0LL_MASK                       (0x8U)
#define CAN_ILS_RF0LL_SHIFT                      (3U)
/*! RF0LL - Rx FIFO 0 Message Lost Interrupt Line
 *  0b0..Interrupt assigned to interrupt line MCANx_INT0
 *  0b1..Interrupt assigned to interrupt line MCANx_INT1
 */
#define CAN_ILS_RF0LL(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ILS_RF0LL_SHIFT)) & CAN_ILS_RF0LL_MASK)

#define CAN_ILS_RF1NL_MASK                       (0x10U)
#define CAN_ILS_RF1NL_SHIFT                      (4U)
/*! RF1NL - Rx FIFO 1 New Message Interrupt Line
 *  0b0..Interrupt assigned to interrupt line MCANx_INT0
 *  0b1..Interrupt assigned to interrupt line MCANx_INT1
 */
#define CAN_ILS_RF1NL(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ILS_RF1NL_SHIFT)) & CAN_ILS_RF1NL_MASK)

#define CAN_ILS_RF1WL_MASK                       (0x20U)
#define CAN_ILS_RF1WL_SHIFT                      (5U)
/*! RF1WL - Rx FIFO 1 Watermark Reached Interrupt Line
 *  0b0..Interrupt assigned to interrupt line MCANx_INT0
 *  0b1..Interrupt assigned to interrupt line MCANx_INT1
 */
#define CAN_ILS_RF1WL(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ILS_RF1WL_SHIFT)) & CAN_ILS_RF1WL_MASK)

#define CAN_ILS_RF1FL_MASK                       (0x40U)
#define CAN_ILS_RF1FL_SHIFT                      (6U)
/*! RF1FL - Rx FIFO 1 Full Interrupt Line
 *  0b0..Interrupt assigned to interrupt line MCANx_INT0
 *  0b1..Interrupt assigned to interrupt line MCANx_INT1
 */
#define CAN_ILS_RF1FL(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ILS_RF1FL_SHIFT)) & CAN_ILS_RF1FL_MASK)

#define CAN_ILS_RF1LL_MASK                       (0x80U)
#define CAN_ILS_RF1LL_SHIFT                      (7U)
/*! RF1LL - Rx FIFO 1 Message Lost Interrupt Line
 *  0b0..Interrupt assigned to interrupt line MCANx_INT0
 *  0b1..Interrupt assigned to interrupt line MCANx_INT1
 */
#define CAN_ILS_RF1LL(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ILS_RF1LL_SHIFT)) & CAN_ILS_RF1LL_MASK)

#define CAN_ILS_HPML_MASK                        (0x100U)
#define CAN_ILS_HPML_SHIFT                       (8U)
/*! HPML - High Priority Message Interrupt Line
 *  0b0..Interrupt assigned to interrupt line MCANx_INT0
 *  0b1..Interrupt assigned to interrupt line MCANx_INT1
 */
#define CAN_ILS_HPML(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ILS_HPML_SHIFT)) & CAN_ILS_HPML_MASK)

#define CAN_ILS_TCL_MASK                         (0x200U)
#define CAN_ILS_TCL_SHIFT                        (9U)
/*! TCL - Transmission Completed Interrupt Line
 *  0b0..Interrupt assigned to interrupt line MCANx_INT0
 *  0b1..Interrupt assigned to interrupt line MCANx_INT1
 */
#define CAN_ILS_TCL(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_ILS_TCL_SHIFT)) & CAN_ILS_TCL_MASK)

#define CAN_ILS_TCFL_MASK                        (0x400U)
#define CAN_ILS_TCFL_SHIFT                       (10U)
/*! TCFL - Transmission Cancellation Finished Interrupt Line
 *  0b0..Interrupt assigned to interrupt line MCANx_INT0
 *  0b1..Interrupt assigned to interrupt line MCANx_INT1
 */
#define CAN_ILS_TCFL(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ILS_TCFL_SHIFT)) & CAN_ILS_TCFL_MASK)

#define CAN_ILS_TFEL_MASK                        (0x800U)
#define CAN_ILS_TFEL_SHIFT                       (11U)
/*! TFEL - Tx FIFO Empty Interrupt Line
 *  0b0..Interrupt assigned to interrupt line MCANx_INT0
 *  0b1..Interrupt assigned to interrupt line MCANx_INT1
 */
#define CAN_ILS_TFEL(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ILS_TFEL_SHIFT)) & CAN_ILS_TFEL_MASK)

#define CAN_ILS_TEFNL_MASK                       (0x1000U)
#define CAN_ILS_TEFNL_SHIFT                      (12U)
/*! TEFNL - Tx Event FIFO New Entry Interrupt Line
 *  0b0..Interrupt assigned to interrupt line MCANx_INT0
 *  0b1..Interrupt assigned to interrupt line MCANx_INT1
 */
#define CAN_ILS_TEFNL(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ILS_TEFNL_SHIFT)) & CAN_ILS_TEFNL_MASK)

#define CAN_ILS_TEFWL_MASK                       (0x2000U)
#define CAN_ILS_TEFWL_SHIFT                      (13U)
/*! TEFWL - Tx Event FIFO Watermark Reached Interrupt Line
 *  0b0..Interrupt assigned to interrupt line MCANx_INT0
 *  0b1..Interrupt assigned to interrupt line MCANx_INT1
 */
#define CAN_ILS_TEFWL(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ILS_TEFWL_SHIFT)) & CAN_ILS_TEFWL_MASK)

#define CAN_ILS_TEFFL_MASK                       (0x4000U)
#define CAN_ILS_TEFFL_SHIFT                      (14U)
/*! TEFFL - Tx Event FIFO Full Interrupt Line
 *  0b0..Interrupt assigned to interrupt line MCANx_INT0
 *  0b1..Interrupt assigned to interrupt line MCANx_INT1
 */
#define CAN_ILS_TEFFL(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ILS_TEFFL_SHIFT)) & CAN_ILS_TEFFL_MASK)

#define CAN_ILS_TEFLL_MASK                       (0x8000U)
#define CAN_ILS_TEFLL_SHIFT                      (15U)
/*! TEFLL - Tx Event FIFO Element Lost Interrupt Line
 *  0b0..Interrupt assigned to interrupt line MCANx_INT0
 *  0b1..Interrupt assigned to interrupt line MCANx_INT1
 */
#define CAN_ILS_TEFLL(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ILS_TEFLL_SHIFT)) & CAN_ILS_TEFLL_MASK)

#define CAN_ILS_TSWL_MASK                        (0x10000U)
#define CAN_ILS_TSWL_SHIFT                       (16U)
/*! TSWL - Timestamp Wraparound Interrupt Line
 *  0b0..Interrupt assigned to interrupt line MCANx_INT0
 *  0b1..Interrupt assigned to interrupt line MCANx_INT1
 */
#define CAN_ILS_TSWL(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ILS_TSWL_SHIFT)) & CAN_ILS_TSWL_MASK)

#define CAN_ILS_MRAFL_MASK                       (0x20000U)
#define CAN_ILS_MRAFL_SHIFT                      (17U)
/*! MRAFL - Message RAM Access Failure Interrupt Line
 *  0b0..Interrupt assigned to interrupt line MCANx_INT0
 *  0b1..Interrupt assigned to interrupt line MCANx_INT1
 */
#define CAN_ILS_MRAFL(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ILS_MRAFL_SHIFT)) & CAN_ILS_MRAFL_MASK)

#define CAN_ILS_TOOL_MASK                        (0x40000U)
#define CAN_ILS_TOOL_SHIFT                       (18U)
/*! TOOL - Timeout Occurred Interrupt Line
 *  0b0..Interrupt assigned to interrupt line MCANx_INT0
 *  0b1..Interrupt assigned to interrupt line MCANx_INT1
 */
#define CAN_ILS_TOOL(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ILS_TOOL_SHIFT)) & CAN_ILS_TOOL_MASK)

#define CAN_ILS_DRXL_MASK                        (0x80000U)
#define CAN_ILS_DRXL_SHIFT                       (19U)
/*! DRXL - Message Stored in Dedicated Rx Buffer Interrupt Line
 *  0b0..Interrupt assigned to interrupt line MCANx_INT0
 *  0b1..Interrupt assigned to interrupt line MCANx_INT1
 */
#define CAN_ILS_DRXL(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ILS_DRXL_SHIFT)) & CAN_ILS_DRXL_MASK)

#define CAN_ILS_BECL_MASK                        (0x100000U)
#define CAN_ILS_BECL_SHIFT                       (20U)
/*! BECL - Bit Error Corrected Interrupt Line
 *  0b0..Interrupt assigned to interrupt line MCANx_INT0
 *  0b1..Interrupt assigned to interrupt line MCANx_INT1
 */
#define CAN_ILS_BECL(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ILS_BECL_SHIFT)) & CAN_ILS_BECL_MASK)

#define CAN_ILS_BEUL_MASK                        (0x200000U)
#define CAN_ILS_BEUL_SHIFT                       (21U)
/*! BEUL - Bit Error Uncorrected Interrupt Line
 *  0b0..Interrupt assigned to interrupt line MCANx_INT0
 *  0b1..Interrupt assigned to interrupt line MCANx_INT1
 */
#define CAN_ILS_BEUL(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ILS_BEUL_SHIFT)) & CAN_ILS_BEUL_MASK)

#define CAN_ILS_ELOL_MASK                        (0x400000U)
#define CAN_ILS_ELOL_SHIFT                       (22U)
/*! ELOL - Error Logging Overflow Interrupt Line
 *  0b0..Interrupt assigned to interrupt line MCANx_INT0
 *  0b1..Interrupt assigned to interrupt line MCANx_INT1
 */
#define CAN_ILS_ELOL(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ILS_ELOL_SHIFT)) & CAN_ILS_ELOL_MASK)

#define CAN_ILS_EPL_MASK                         (0x800000U)
#define CAN_ILS_EPL_SHIFT                        (23U)
/*! EPL - Error Passive Interrupt Line
 *  0b0..Interrupt assigned to interrupt line MCANx_INT0
 *  0b1..Interrupt assigned to interrupt line MCANx_INT1
 */
#define CAN_ILS_EPL(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_ILS_EPL_SHIFT)) & CAN_ILS_EPL_MASK)

#define CAN_ILS_EWL_MASK                         (0x1000000U)
#define CAN_ILS_EWL_SHIFT                        (24U)
/*! EWL - Warning Status Interrupt Line
 *  0b0..Interrupt assigned to interrupt line MCANx_INT0
 *  0b1..Interrupt assigned to interrupt line MCANx_INT1
 */
#define CAN_ILS_EWL(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_ILS_EWL_SHIFT)) & CAN_ILS_EWL_MASK)

#define CAN_ILS_BOL_MASK                         (0x2000000U)
#define CAN_ILS_BOL_SHIFT                        (25U)
/*! BOL - Bus_Off Status Interrupt Line
 *  0b0..Interrupt assigned to interrupt line MCANx_INT0
 *  0b1..Interrupt assigned to interrupt line MCANx_INT1
 */
#define CAN_ILS_BOL(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_ILS_BOL_SHIFT)) & CAN_ILS_BOL_MASK)

#define CAN_ILS_WDIL_MASK                        (0x4000000U)
#define CAN_ILS_WDIL_SHIFT                       (26U)
/*! WDIL - Watchdog Interrupt Line
 *  0b0..Interrupt assigned to interrupt line MCANx_INT0
 *  0b1..Interrupt assigned to interrupt line MCANx_INT1
 */
#define CAN_ILS_WDIL(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ILS_WDIL_SHIFT)) & CAN_ILS_WDIL_MASK)

#define CAN_ILS_PEAL_MASK                        (0x8000000U)
#define CAN_ILS_PEAL_SHIFT                       (27U)
/*! PEAL - Protocol Error in Arbitration Phase Interrupt Line
 *  0b0..Interrupt assigned to interrupt line MCANx_INT0
 *  0b1..Interrupt assigned to interrupt line MCANx_INT1
 */
#define CAN_ILS_PEAL(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ILS_PEAL_SHIFT)) & CAN_ILS_PEAL_MASK)

#define CAN_ILS_PEDL_MASK                        (0x10000000U)
#define CAN_ILS_PEDL_SHIFT                       (28U)
/*! PEDL - Protocol Error in Data Phase Interrupt Line
 *  0b0..Interrupt assigned to interrupt line MCANx_INT0
 *  0b1..Interrupt assigned to interrupt line MCANx_INT1
 */
#define CAN_ILS_PEDL(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ILS_PEDL_SHIFT)) & CAN_ILS_PEDL_MASK)

#define CAN_ILS_ARAL_MASK                        (0x20000000U)
#define CAN_ILS_ARAL_SHIFT                       (29U)
/*! ARAL - Access to Reserved Address Interrupt Line
 *  0b0..Interrupt assigned to interrupt line MCANx_INT0
 *  0b1..Interrupt assigned to interrupt line MCANx_INT1
 */
#define CAN_ILS_ARAL(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ILS_ARAL_SHIFT)) & CAN_ILS_ARAL_MASK)
/*! @} */

/*! @name ILE - Interrupt Line Enable */
/*! @{ */

#define CAN_ILE_EINT0_MASK                       (0x1U)
#define CAN_ILE_EINT0_SHIFT                      (0U)
/*! EINT0 - Enable Interrupt Line 0
 *  0b0..Interrupt line to MCANx_INT0 is disabled.
 *  0b1..Interrupt line to MCANx_INT0 is enabled.
 */
#define CAN_ILE_EINT0(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ILE_EINT0_SHIFT)) & CAN_ILE_EINT0_MASK)

#define CAN_ILE_EINT1_MASK                       (0x2U)
#define CAN_ILE_EINT1_SHIFT                      (1U)
/*! EINT1 - Enable Interrupt Line 1
 *  0b0..Interrupt line to MCANx_INT1 is disabled.
 *  0b1..Interrupt line to MCANx_INT1 is enabled.
 */
#define CAN_ILE_EINT1(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ILE_EINT1_SHIFT)) & CAN_ILE_EINT1_MASK)
/*! @} */

/*! @name GFC - Global Filter Configuration */
/*! @{ */

#define CAN_GFC_RRFE_MASK                        (0x1U)
#define CAN_GFC_RRFE_SHIFT                       (0U)
/*! RRFE - Reject Remote Frames Extended
 *  0b0..Filter remote frames with 29-bit extended IDs
 *  0b1..Reject all remote frames with 29-bit extended IDs
 */
#define CAN_GFC_RRFE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_GFC_RRFE_SHIFT)) & CAN_GFC_RRFE_MASK)

#define CAN_GFC_RRFS_MASK                        (0x2U)
#define CAN_GFC_RRFS_SHIFT                       (1U)
/*! RRFS - Reject Remote Frames Standard
 *  0b0..Filter remote frames with 11-bit standard IDs
 *  0b1..Reject all remote frames with 11-bit standard IDs
 */
#define CAN_GFC_RRFS(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_GFC_RRFS_SHIFT)) & CAN_GFC_RRFS_MASK)

#define CAN_GFC_ANFE_MASK                        (0xCU)
#define CAN_GFC_ANFE_SHIFT                       (2U)
/*! ANFE - Accept Non-matching Frames Extended
 *  0b00..Accept in Rx FIFO 0
 *  0b01..Accept in Rx FIFO 1
 *  0b10, 0b11..Reject
 */
#define CAN_GFC_ANFE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_GFC_ANFE_SHIFT)) & CAN_GFC_ANFE_MASK)

#define CAN_GFC_ANFS_MASK                        (0x30U)
#define CAN_GFC_ANFS_SHIFT                       (4U)
/*! ANFS - Accept Non-matching Frames Standard
 *  0b00..Accept in Rx FIFO 0
 *  0b01..Accept in Rx FIFO 1
 *  0b10, 0b11..Reject
 */
#define CAN_GFC_ANFS(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_GFC_ANFS_SHIFT)) & CAN_GFC_ANFS_MASK)
/*! @} */

/*! @name SIDFC - Standard ID Filter Configuration */
/*! @{ */

#define CAN_SIDFC_FLSSA_MASK                     (0xFFFCU)
#define CAN_SIDFC_FLSSA_SHIFT                    (2U)
/*! FLSSA - Filter List Standard Start Address
 */
#define CAN_SIDFC_FLSSA(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_SIDFC_FLSSA_SHIFT)) & CAN_SIDFC_FLSSA_MASK)

#define CAN_SIDFC_LSS_MASK                       (0xFF0000U)
#define CAN_SIDFC_LSS_SHIFT                      (16U)
/*! LSS - List Size Standard
 */
#define CAN_SIDFC_LSS(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_SIDFC_LSS_SHIFT)) & CAN_SIDFC_LSS_MASK)
/*! @} */

/*! @name XIDFC - Extended ID Filter Configuration */
/*! @{ */

#define CAN_XIDFC_FLESA_MASK                     (0xFFFCU)
#define CAN_XIDFC_FLESA_SHIFT                    (2U)
/*! FLESA - Filter List Extended Start Address
 */
#define CAN_XIDFC_FLESA(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_XIDFC_FLESA_SHIFT)) & CAN_XIDFC_FLESA_MASK)

#define CAN_XIDFC_LSE_MASK                       (0xFF0000U)
#define CAN_XIDFC_LSE_SHIFT                      (16U)
/*! LSE - List Size Extended
 */
#define CAN_XIDFC_LSE(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_XIDFC_LSE_SHIFT)) & CAN_XIDFC_LSE_MASK)
/*! @} */

/*! @name XIDAM - Extended ID AND Mask */
/*! @{ */

#define CAN_XIDAM_EIDM_MASK                      (0x1FFFFFFFU)
#define CAN_XIDAM_EIDM_SHIFT                     (0U)
/*! EIDM - Extended ID Mask
 */
#define CAN_XIDAM_EIDM(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_XIDAM_EIDM_SHIFT)) & CAN_XIDAM_EIDM_MASK)
/*! @} */

/*! @name HPMS - High Priority Message Status */
/*! @{ */

#define CAN_HPMS_BIDX_MASK                       (0x3FU)
#define CAN_HPMS_BIDX_SHIFT                      (0U)
/*! BIDX - Buffer Index
 */
#define CAN_HPMS_BIDX(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_HPMS_BIDX_SHIFT)) & CAN_HPMS_BIDX_MASK)

#define CAN_HPMS_MSI_MASK                        (0xC0U)
#define CAN_HPMS_MSI_SHIFT                       (6U)
/*! MSI - Message Storage Indicator
 *  0b00..No FIFO selected
 *  0b01..FIFO message lost
 *  0b10..Message stored in FIFO 0
 *  0b11..Message stored in FIFO 1
 */
#define CAN_HPMS_MSI(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_HPMS_MSI_SHIFT)) & CAN_HPMS_MSI_MASK)

#define CAN_HPMS_FIDX_MASK                       (0x7F00U)
#define CAN_HPMS_FIDX_SHIFT                      (8U)
/*! FIDX - Filter Index
 */
#define CAN_HPMS_FIDX(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_HPMS_FIDX_SHIFT)) & CAN_HPMS_FIDX_MASK)

#define CAN_HPMS_FLST_MASK                       (0x8000U)
#define CAN_HPMS_FLST_SHIFT                      (15U)
/*! FLST - Filter List
 *  0b0..Standard filter list
 *  0b1..Extended filter list
 */
#define CAN_HPMS_FLST(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_HPMS_FLST_SHIFT)) & CAN_HPMS_FLST_MASK)
/*! @} */

/*! @name NDAT1 - New Data 1 */
/*! @{ */

#define CAN_NDAT1_ND_MASK                        (0xFFFFFFFFU)
#define CAN_NDAT1_ND_SHIFT                       (0U)
/*! ND - New Data
 */
#define CAN_NDAT1_ND(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_NDAT1_ND_SHIFT)) & CAN_NDAT1_ND_MASK)
/*! @} */

/*! @name NDAT2 - New Data 2 */
/*! @{ */

#define CAN_NDAT2_ND_MASK                        (0xFFFFFFFFU)
#define CAN_NDAT2_ND_SHIFT                       (0U)
/*! ND - New Data
 */
#define CAN_NDAT2_ND(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_NDAT2_ND_SHIFT)) & CAN_NDAT2_ND_MASK)
/*! @} */

/*! @name RXF0C - Rx FIFO 0 Configuration */
/*! @{ */

#define CAN_RXF0C_F0SA_MASK                      (0xFFFCU)
#define CAN_RXF0C_F0SA_SHIFT                     (2U)
/*! F0SA - Rx FIFO 0 Start Address
 */
#define CAN_RXF0C_F0SA(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXF0C_F0SA_SHIFT)) & CAN_RXF0C_F0SA_MASK)

#define CAN_RXF0C_F0S_MASK                       (0x7F0000U)
#define CAN_RXF0C_F0S_SHIFT                      (16U)
/*! F0S - Rx FIFO 0 Size
 */
#define CAN_RXF0C_F0S(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_RXF0C_F0S_SHIFT)) & CAN_RXF0C_F0S_MASK)

#define CAN_RXF0C_F0WM_MASK                      (0x7F000000U)
#define CAN_RXF0C_F0WM_SHIFT                     (24U)
/*! F0WM - Rx FIFO 0 Watermark
 */
#define CAN_RXF0C_F0WM(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXF0C_F0WM_SHIFT)) & CAN_RXF0C_F0WM_MASK)

#define CAN_RXF0C_F0OM_MASK                      (0x80000000U)
#define CAN_RXF0C_F0OM_SHIFT                     (31U)
/*! F0OM - FIFO 0 Operation Mode
 *  0b0..FIFO 0 blocking mode
 *  0b1..FIFO 0 overwrite mode
 */
#define CAN_RXF0C_F0OM(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXF0C_F0OM_SHIFT)) & CAN_RXF0C_F0OM_MASK)
/*! @} */

/*! @name RXF0S - Rx FIFO 0 Status */
/*! @{ */

#define CAN_RXF0S_F0FL_MASK                      (0x7FU)
#define CAN_RXF0S_F0FL_SHIFT                     (0U)
/*! F0FL - Rx FIFO 0 Fill Level
 */
#define CAN_RXF0S_F0FL(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXF0S_F0FL_SHIFT)) & CAN_RXF0S_F0FL_MASK)

#define CAN_RXF0S_F0GI_MASK                      (0x3F00U)
#define CAN_RXF0S_F0GI_SHIFT                     (8U)
/*! F0GI - Rx FIFO 0 Get Index
 */
#define CAN_RXF0S_F0GI(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXF0S_F0GI_SHIFT)) & CAN_RXF0S_F0GI_MASK)

#define CAN_RXF0S_F0PI_MASK                      (0x3F0000U)
#define CAN_RXF0S_F0PI_SHIFT                     (16U)
/*! F0PI - Rx FIFO 0 Put Index
 */
#define CAN_RXF0S_F0PI(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXF0S_F0PI_SHIFT)) & CAN_RXF0S_F0PI_MASK)

#define CAN_RXF0S_F0F_MASK                       (0x1000000U)
#define CAN_RXF0S_F0F_SHIFT                      (24U)
/*! F0F - Rx FIFO 0 Full
 *  0b0..Rx FIFO 0 not full
 *  0b1..Rx FIFO 0 full
 */
#define CAN_RXF0S_F0F(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_RXF0S_F0F_SHIFT)) & CAN_RXF0S_F0F_MASK)

#define CAN_RXF0S_RF0L_MASK                      (0x2000000U)
#define CAN_RXF0S_RF0L_SHIFT                     (25U)
/*! RF0L - Rx FIFO 0 Message Lost
 */
#define CAN_RXF0S_RF0L(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXF0S_RF0L_SHIFT)) & CAN_RXF0S_RF0L_MASK)
/*! @} */

/*! @name RXF0A - Rx FIFO 0 Acknowledge */
/*! @{ */

#define CAN_RXF0A_F0AI_MASK                      (0x3FU)
#define CAN_RXF0A_F0AI_SHIFT                     (0U)
/*! F0AI - Rx FIFO 0 Acknowledge Index
 */
#define CAN_RXF0A_F0AI(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXF0A_F0AI_SHIFT)) & CAN_RXF0A_F0AI_MASK)
/*! @} */

/*! @name RXBC - Rx Buffer Configuration */
/*! @{ */

#define CAN_RXBC_RBSA_MASK                       (0xFFFCU)
#define CAN_RXBC_RBSA_SHIFT                      (2U)
/*! RBSA - Rx Buffer Start Address
 */
#define CAN_RXBC_RBSA(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_RXBC_RBSA_SHIFT)) & CAN_RXBC_RBSA_MASK)
/*! @} */

/*! @name RXF1C - Rx FIFO 1 Configuration */
/*! @{ */

#define CAN_RXF1C_F1SA_MASK                      (0xFFFCU)
#define CAN_RXF1C_F1SA_SHIFT                     (2U)
/*! F1SA - Rx FIFO 1 Start Address
 */
#define CAN_RXF1C_F1SA(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXF1C_F1SA_SHIFT)) & CAN_RXF1C_F1SA_MASK)

#define CAN_RXF1C_F1S_MASK                       (0x7F0000U)
#define CAN_RXF1C_F1S_SHIFT                      (16U)
/*! F1S - Rx FIFO 1 Size
 */
#define CAN_RXF1C_F1S(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_RXF1C_F1S_SHIFT)) & CAN_RXF1C_F1S_MASK)

#define CAN_RXF1C_F1WM_MASK                      (0x7F000000U)
#define CAN_RXF1C_F1WM_SHIFT                     (24U)
/*! F1WM - Rx FIFO 1 Watermark
 */
#define CAN_RXF1C_F1WM(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXF1C_F1WM_SHIFT)) & CAN_RXF1C_F1WM_MASK)

#define CAN_RXF1C_F1OM_MASK                      (0x80000000U)
#define CAN_RXF1C_F1OM_SHIFT                     (31U)
/*! F1OM - FIFO 1 Operation Mode
 *  0b0..FIFO 1 blocking mode
 *  0b1..FIFO 1 overwrite mode
 */
#define CAN_RXF1C_F1OM(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXF1C_F1OM_SHIFT)) & CAN_RXF1C_F1OM_MASK)
/*! @} */

/*! @name RXF1S - Rx FIFO 1 Status */
/*! @{ */

#define CAN_RXF1S_F1FL_MASK                      (0x7FU)
#define CAN_RXF1S_F1FL_SHIFT                     (0U)
/*! F1FL - Rx FIFO 1 Fill Level
 */
#define CAN_RXF1S_F1FL(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXF1S_F1FL_SHIFT)) & CAN_RXF1S_F1FL_MASK)

#define CAN_RXF1S_F1GI_MASK                      (0x3F00U)
#define CAN_RXF1S_F1GI_SHIFT                     (8U)
/*! F1GI - Rx FIFO 1 Get Index
 */
#define CAN_RXF1S_F1GI(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXF1S_F1GI_SHIFT)) & CAN_RXF1S_F1GI_MASK)

#define CAN_RXF1S_F1PI_MASK                      (0x3F0000U)
#define CAN_RXF1S_F1PI_SHIFT                     (16U)
/*! F1PI - Rx FIFO 1 Put Index
 */
#define CAN_RXF1S_F1PI(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXF1S_F1PI_SHIFT)) & CAN_RXF1S_F1PI_MASK)

#define CAN_RXF1S_F1F_MASK                       (0x1000000U)
#define CAN_RXF1S_F1F_SHIFT                      (24U)
/*! F1F - Rx FIFO 1 Full
 *  0b0..Rx FIFO 1 not full
 *  0b1..Rx FIFO 1 full
 */
#define CAN_RXF1S_F1F(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_RXF1S_F1F_SHIFT)) & CAN_RXF1S_F1F_MASK)

#define CAN_RXF1S_RF1L_MASK                      (0x2000000U)
#define CAN_RXF1S_RF1L_SHIFT                     (25U)
/*! RF1L - Rx FIFO 1 message lost.
 *  0b0..No Rx FIFO 1 message lost.
 *  0b1..Rx FIFO 1 message lost, also set after write attempt to Rx FIFO 1 of size zero.
 */
#define CAN_RXF1S_RF1L(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXF1S_RF1L_SHIFT)) & CAN_RXF1S_RF1L_MASK)
/*! @} */

/*! @name RXF1A - Rx FIFO 1 Acknowledge */
/*! @{ */

#define CAN_RXF1A_F1AI_MASK                      (0x3FU)
#define CAN_RXF1A_F1AI_SHIFT                     (0U)
/*! F1AI - Rx FIFO 1 Acknowledge Index
 */
#define CAN_RXF1A_F1AI(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXF1A_F1AI_SHIFT)) & CAN_RXF1A_F1AI_MASK)
/*! @} */

/*! @name RXESC - Rx Buffer and FIFO Element Size Configuration */
/*! @{ */

#define CAN_RXESC_F0DS_MASK                      (0x7U)
#define CAN_RXESC_F0DS_SHIFT                     (0U)
/*! F0DS - Rx FIFO 0 Data Field Size
 *  0b000..8 byte data field
 *  0b001..12 byte data field
 *  0b010..16 byte data field
 *  0b011..20 byte data field
 *  0b100..24 byte data field
 *  0b101..32 byte data field
 *  0b110..48 byte data field
 *  0b111..64 byte data field
 */
#define CAN_RXESC_F0DS(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXESC_F0DS_SHIFT)) & CAN_RXESC_F0DS_MASK)

#define CAN_RXESC_F1DS_MASK                      (0x70U)
#define CAN_RXESC_F1DS_SHIFT                     (4U)
/*! F1DS - Rx FIFO 1 Data Field Size
 *  0b000..8 byte data field
 *  0b001..12 byte data field
 *  0b010..16 byte data field
 *  0b011..20 byte data field
 *  0b100..24 byte data field
 *  0b101..32 byte data field
 *  0b110..48 byte data field
 *  0b111..64 byte data field
 */
#define CAN_RXESC_F1DS(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXESC_F1DS_SHIFT)) & CAN_RXESC_F1DS_MASK)

#define CAN_RXESC_RBDS_MASK                      (0x700U)
#define CAN_RXESC_RBDS_SHIFT                     (8U)
/*! RBDS - Rx Buffer Data Field Size
 *  0b000..8 byte data field
 *  0b001..12 byte data field
 *  0b010..16 byte data field
 *  0b011..20 byte data field
 *  0b100..24 byte data field
 *  0b101..32 byte data field
 *  0b110..48 byte data field
 *  0b111..64 byte data field
 */
#define CAN_RXESC_RBDS(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_RXESC_RBDS_SHIFT)) & CAN_RXESC_RBDS_MASK)
/*! @} */

/*! @name TXBC - Tx Buffer Configuration */
/*! @{ */

#define CAN_TXBC_TBSA_MASK                       (0xFFFCU)
#define CAN_TXBC_TBSA_SHIFT                      (2U)
/*! TBSA - Tx Buffers Start Address
 */
#define CAN_TXBC_TBSA(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_TXBC_TBSA_SHIFT)) & CAN_TXBC_TBSA_MASK)

#define CAN_TXBC_NDTB_MASK                       (0x3F0000U)
#define CAN_TXBC_NDTB_SHIFT                      (16U)
/*! NDTB - Number of Dedicated Transmit Buffers
 */
#define CAN_TXBC_NDTB(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_TXBC_NDTB_SHIFT)) & CAN_TXBC_NDTB_MASK)

#define CAN_TXBC_TFQS_MASK                       (0x3F000000U)
#define CAN_TXBC_TFQS_SHIFT                      (24U)
/*! TFQS - Transmit FIFO/Queue Size
 */
#define CAN_TXBC_TFQS(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_TXBC_TFQS_SHIFT)) & CAN_TXBC_TFQS_MASK)

#define CAN_TXBC_TFQM_MASK                       (0x40000000U)
#define CAN_TXBC_TFQM_SHIFT                      (30U)
/*! TFQM - Tx FIFO/Queue Mode
 *  0b0..Tx FIFO operation
 *  0b1..Tx queue operation
 */
#define CAN_TXBC_TFQM(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_TXBC_TFQM_SHIFT)) & CAN_TXBC_TFQM_MASK)
/*! @} */

/*! @name TXFQS - Tx FIFO/Queue Status */
/*! @{ */

#define CAN_TXFQS_TFGI_MASK                      (0x1F00U)
#define CAN_TXFQS_TFGI_SHIFT                     (8U)
/*! TFGI - Tx FIFO Get Index
 */
#define CAN_TXFQS_TFGI(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_TXFQS_TFGI_SHIFT)) & CAN_TXFQS_TFGI_MASK)

#define CAN_TXFQS_TFQPI_MASK                     (0x1F0000U)
#define CAN_TXFQS_TFQPI_SHIFT                    (16U)
/*! TFQPI - Tx FIFO/Queue Put Index
 */
#define CAN_TXFQS_TFQPI(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_TXFQS_TFQPI_SHIFT)) & CAN_TXFQS_TFQPI_MASK)

#define CAN_TXFQS_TFQF_MASK                      (0x200000U)
#define CAN_TXFQS_TFQF_SHIFT                     (21U)
/*! TFQF - Tx FIFO/Queue Full
 *  0b0..Tx FIFO/Queue not full
 *  0b1..Tx FIFO/Queue full
 */
#define CAN_TXFQS_TFQF(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_TXFQS_TFQF_SHIFT)) & CAN_TXFQS_TFQF_MASK)
/*! @} */

/*! @name TXESC - Tx Buffer Element Size Configuration */
/*! @{ */

#define CAN_TXESC_TBDS_MASK                      (0x7U)
#define CAN_TXESC_TBDS_SHIFT                     (0U)
/*! TBDS - Tx Buffer Data Field Size
 *  0b000..8 byte data field
 *  0b001..12 byte data field
 *  0b010..16 byte data field
 *  0b011..20 byte data field
 *  0b100..24 byte data field
 *  0b101..32 byte data field
 *  0b110..48 byte data field
 *  0b111..64 byte data field
 */
#define CAN_TXESC_TBDS(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_TXESC_TBDS_SHIFT)) & CAN_TXESC_TBDS_MASK)
/*! @} */

/*! @name TXBRP - Tx Buffer Request Pending */
/*! @{ */

#define CAN_TXBRP_TRP_MASK                       (0xFFFFFFFFU)
#define CAN_TXBRP_TRP_SHIFT                      (0U)
/*! TRP - Transmission Request Pending
 */
#define CAN_TXBRP_TRP(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_TXBRP_TRP_SHIFT)) & CAN_TXBRP_TRP_MASK)
/*! @} */

/*! @name TXBAR - Tx Buffer Add Request */
/*! @{ */

#define CAN_TXBAR_AR_MASK                        (0xFFFFFFFFU)
#define CAN_TXBAR_AR_SHIFT                       (0U)
/*! AR - Add Request
 */
#define CAN_TXBAR_AR(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_TXBAR_AR_SHIFT)) & CAN_TXBAR_AR_MASK)
/*! @} */

/*! @name TXBCR - Tx Buffer Cancellation Request */
/*! @{ */

#define CAN_TXBCR_CR_MASK                        (0xFFFFFFFFU)
#define CAN_TXBCR_CR_SHIFT                       (0U)
/*! CR - Cancellation Request
 */
#define CAN_TXBCR_CR(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_TXBCR_CR_SHIFT)) & CAN_TXBCR_CR_MASK)
/*! @} */

/*! @name TXBTO - Tx Buffer Transmission Occurred */
/*! @{ */

#define CAN_TXBTO_TO_MASK                        (0xFFFFFFFFU)
#define CAN_TXBTO_TO_SHIFT                       (0U)
/*! TO - Transmission Occurred
 */
#define CAN_TXBTO_TO(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_TXBTO_TO_SHIFT)) & CAN_TXBTO_TO_MASK)
/*! @} */

/*! @name TXBCF - Tx Buffer Cancellation Finished */
/*! @{ */

#define CAN_TXBCF_TO_MASK                        (0xFFFFFFFFU)
#define CAN_TXBCF_TO_SHIFT                       (0U)
/*! TO - Cancellation Finished
 */
#define CAN_TXBCF_TO(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_TXBCF_TO_SHIFT)) & CAN_TXBCF_TO_MASK)
/*! @} */

/*! @name TXBTIE - Tx Buffer Transmission Interrupt Enable */
/*! @{ */

#define CAN_TXBTIE_TIE_MASK                      (0xFFFFFFFFU)
#define CAN_TXBTIE_TIE_SHIFT                     (0U)
/*! TIE - Transmission Interrupt Enable
 */
#define CAN_TXBTIE_TIE(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_TXBTIE_TIE_SHIFT)) & CAN_TXBTIE_TIE_MASK)
/*! @} */

/*! @name TXBCIE - Tx Buffer Cancellation Finished Interrupt Enable */
/*! @{ */

#define CAN_TXBCIE_CFIE_MASK                     (0xFFFFFFFFU)
#define CAN_TXBCIE_CFIE_SHIFT                    (0U)
/*! CFIE - Cancellation Finished Interrupt Enable
 */
#define CAN_TXBCIE_CFIE(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_TXBCIE_CFIE_SHIFT)) & CAN_TXBCIE_CFIE_MASK)
/*! @} */

/*! @name TXEFC - Tx Event FIFO Configuration */
/*! @{ */

#define CAN_TXEFC_EFSA_MASK                      (0xFFFCU)
#define CAN_TXEFC_EFSA_SHIFT                     (2U)
/*! EFSA - Event FIFO Start Address
 */
#define CAN_TXEFC_EFSA(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_TXEFC_EFSA_SHIFT)) & CAN_TXEFC_EFSA_MASK)

#define CAN_TXEFC_EFS_MASK                       (0x3F0000U)
#define CAN_TXEFC_EFS_SHIFT                      (16U)
/*! EFS - Event FIFO Size
 */
#define CAN_TXEFC_EFS(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_TXEFC_EFS_SHIFT)) & CAN_TXEFC_EFS_MASK)

#define CAN_TXEFC_EFWM_MASK                      (0x3F000000U)
#define CAN_TXEFC_EFWM_SHIFT                     (24U)
/*! EFWM - Event FIFO Watermark
 */
#define CAN_TXEFC_EFWM(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_TXEFC_EFWM_SHIFT)) & CAN_TXEFC_EFWM_MASK)
/*! @} */

/*! @name TXEFS - Tx Event FIFO Status */
/*! @{ */

#define CAN_TXEFS_EFFL_MASK                      (0x3FU)
#define CAN_TXEFS_EFFL_SHIFT                     (0U)
/*! EFFL - Event FIFO Fill Level
 */
#define CAN_TXEFS_EFFL(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_TXEFS_EFFL_SHIFT)) & CAN_TXEFS_EFFL_MASK)

#define CAN_TXEFS_EFGI_MASK                      (0x1F00U)
#define CAN_TXEFS_EFGI_SHIFT                     (8U)
/*! EFGI - Event FIFO Get Index
 */
#define CAN_TXEFS_EFGI(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_TXEFS_EFGI_SHIFT)) & CAN_TXEFS_EFGI_MASK)

#define CAN_TXEFS_EFPI_MASK                      (0x3F0000U)
#define CAN_TXEFS_EFPI_SHIFT                     (16U)
/*! EFPI - Event FIFO Put Index
 */
#define CAN_TXEFS_EFPI(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_TXEFS_EFPI_SHIFT)) & CAN_TXEFS_EFPI_MASK)

#define CAN_TXEFS_EFF_MASK                       (0x1000000U)
#define CAN_TXEFS_EFF_SHIFT                      (24U)
/*! EFF - Event FIFO Full
 *  0b0..Tx event FIFO not full
 *  0b1..Tx event FIFO full
 */
#define CAN_TXEFS_EFF(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_TXEFS_EFF_SHIFT)) & CAN_TXEFS_EFF_MASK)

#define CAN_TXEFS_TEFL_MASK                      (0x2000000U)
#define CAN_TXEFS_TEFL_SHIFT                     (25U)
/*! TEFL - Tx Event FIFO Element Lost
 *  0b0..No Tx event FIFO element lost.
 *  0b1..Tx event FIFO element lost, also set after write attempt to Tx event FIFO of size zero.
 */
#define CAN_TXEFS_TEFL(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_TXEFS_TEFL_SHIFT)) & CAN_TXEFS_TEFL_MASK)
/*! @} */

/*! @name TXEFA - Tx Event FIFO Acknowledge */
/*! @{ */

#define CAN_TXEFA_EFAI_MASK                      (0x1FU)
#define CAN_TXEFA_EFAI_SHIFT                     (0U)
/*! EFAI - Event FIFO Acknowledge Index
 */
#define CAN_TXEFA_EFAI(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_TXEFA_EFAI_SHIFT)) & CAN_TXEFA_EFAI_MASK)
/*! @} */

/*! @name MRBA - Message RAM Base Address */
/*! @{ */

#define CAN_MRBA_BA_MASK                         (0xFFFF0000U)
#define CAN_MRBA_BA_SHIFT                        (16U)
/*! BA - Base Address for the message RAM in the chip memory map.
 */
#define CAN_MRBA_BA(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_MRBA_BA_SHIFT)) & CAN_MRBA_BA_MASK)
/*! @} */

/*! @name ETSCC - External Timestamp Counter Configuration */
/*! @{ */

#define CAN_ETSCC_ETCP_MASK                      (0x7FFU)
#define CAN_ETSCC_ETCP_SHIFT                     (0U)
/*! ETCP - External Timestamp Prescaler Value
 */
#define CAN_ETSCC_ETCP(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ETSCC_ETCP_SHIFT)) & CAN_ETSCC_ETCP_MASK)

#define CAN_ETSCC_ETCE_MASK                      (0x80000000U)
#define CAN_ETSCC_ETCE_SHIFT                     (31U)
/*! ETCE - External Timestamp Counter Enable
 *  0b0..External timestamp counter is disabled
 *  0b1..External timestamp counter is enabled
 */
#define CAN_ETSCC_ETCE(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ETSCC_ETCE_SHIFT)) & CAN_ETSCC_ETCE_MASK)
/*! @} */

/*! @name ETSCV - External Timestamp Counter Value */
/*! @{ */

#define CAN_ETSCV_ETSC_MASK                      (0xFFFFU)
#define CAN_ETSCV_ETSC_SHIFT                     (0U)
/*! ETSC - External Timestamp Counter
 */
#define CAN_ETSCV_ETSC(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ETSCV_ETSC_SHIFT)) & CAN_ETSCV_ETSC_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CAN_Register_Masks */


/* CAN - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral CAN0 base address */
  #define CAN0_BASE                                (0x5009D000u)
  /** Peripheral CAN0 base address */
  #define CAN0_BASE_NS                             (0x4009D000u)
  /** Peripheral CAN0 base pointer */
  #define CAN0                                     ((CAN_Type *)CAN0_BASE)
  /** Peripheral CAN0 base pointer */
  #define CAN0_NS                                  ((CAN_Type *)CAN0_BASE_NS)
  /** Array initializer of CAN peripheral base addresses */
  #define CAN_BASE_ADDRS                           { CAN0_BASE }
  /** Array initializer of CAN peripheral base pointers */
  #define CAN_BASE_PTRS                            { CAN0 }
  /** Array initializer of CAN peripheral base addresses */
  #define CAN_BASE_ADDRS_NS                        { CAN0_BASE_NS }
  /** Array initializer of CAN peripheral base pointers */
  #define CAN_BASE_PTRS_NS                         { CAN0_NS }
#else
  /** Peripheral CAN0 base address */
  #define CAN0_BASE                                (0x4009D000u)
  /** Peripheral CAN0 base pointer */
  #define CAN0                                     ((CAN_Type *)CAN0_BASE)
  /** Array initializer of CAN peripheral base addresses */
  #define CAN_BASE_ADDRS                           { CAN0_BASE }
  /** Array initializer of CAN peripheral base pointers */
  #define CAN_BASE_PTRS                            { CAN0 }
#endif
/** Interrupt vectors for the CAN peripheral type */
#define CAN_IRQS                                 { { CAN0_IRQ0_IRQn, CAN0_IRQ1_IRQn } }

/*!
 * @}
 */ /* end of group CAN_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CDOG Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CDOG_Peripheral_Access_Layer CDOG Peripheral Access Layer
 * @{
 */

/** CDOG - Register Layout Typedef */
typedef struct {
  __IO uint32_t CONTROL;                           /**< Control, offset: 0x0 */
  __IO uint32_t RELOAD;                            /**< Instruction Timer reload, offset: 0x4 */
  __I  uint32_t INSTRUCTION_TIMER;                 /**< Instruction Timer, offset: 0x8 */
  __I  uint32_t SECURE_COUNTER;                    /**< Secure Counter, offset: 0xC */
  __I  uint32_t STATUS;                            /**< Status 1, offset: 0x10 */
  __I  uint32_t STATUS2;                           /**< Status 2, offset: 0x14 */
  __IO uint32_t FLAGS;                             /**< Flags, offset: 0x18 */
  __IO uint32_t PERSISTENT;                        /**< Persistent Data Storage, offset: 0x1C */
  __O  uint32_t START;                             /**< START Command, offset: 0x20 */
  __O  uint32_t STOP;                              /**< STOP Command, offset: 0x24 */
  __O  uint32_t RESTART;                           /**< RESTART Command, offset: 0x28 */
  __O  uint32_t ADD;                               /**< ADD Command, offset: 0x2C */
  __O  uint32_t ADD1;                              /**< ADD1 Command, offset: 0x30 */
  __O  uint32_t ADD16;                             /**< ADD16 Command, offset: 0x34 */
  __O  uint32_t ADD256;                            /**< ADD256 Command, offset: 0x38 */
  __O  uint32_t SUB;                               /**< SUB Command, offset: 0x3C */
  __O  uint32_t SUB1;                              /**< SUB1 Command, offset: 0x40 */
  __O  uint32_t SUB16;                             /**< SUB16 Command, offset: 0x44 */
  __O  uint32_t SUB256;                            /**< SUB256 Command, offset: 0x48 */
} CDOG_Type;

/* ----------------------------------------------------------------------------
   -- CDOG Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CDOG_Register_Masks CDOG Register Masks
 * @{
 */

/*! @name CONTROL - Control */
/*! @{ */

#define CDOG_CONTROL_LOCK_CTRL_MASK              (0x3U)
#define CDOG_CONTROL_LOCK_CTRL_SHIFT             (0U)
/*! LOCK_CTRL - Lock control
 *  0b01..Locked
 *  0b10..Unlocked
 */
#define CDOG_CONTROL_LOCK_CTRL(x)                (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_LOCK_CTRL_SHIFT)) & CDOG_CONTROL_LOCK_CTRL_MASK)

#define CDOG_CONTROL_TIMEOUT_CTRL_MASK           (0x1CU)
#define CDOG_CONTROL_TIMEOUT_CTRL_SHIFT          (2U)
/*! TIMEOUT_CTRL - TIMEOUT fault control
 *  0b100..Disable both reset and interrupt
 *  0b001..Enable reset
 *  0b010..Enable interrupt
 */
#define CDOG_CONTROL_TIMEOUT_CTRL(x)             (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_TIMEOUT_CTRL_SHIFT)) & CDOG_CONTROL_TIMEOUT_CTRL_MASK)

#define CDOG_CONTROL_MISCOMPARE_CTRL_MASK        (0xE0U)
#define CDOG_CONTROL_MISCOMPARE_CTRL_SHIFT       (5U)
/*! MISCOMPARE_CTRL - MISCOMPARE fault control
 *  0b100..Disable both reset and interrupt
 *  0b001..Enable reset
 *  0b010..Enable interrupt
 */
#define CDOG_CONTROL_MISCOMPARE_CTRL(x)          (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_MISCOMPARE_CTRL_SHIFT)) & CDOG_CONTROL_MISCOMPARE_CTRL_MASK)

#define CDOG_CONTROL_SEQUENCE_CTRL_MASK          (0x700U)
#define CDOG_CONTROL_SEQUENCE_CTRL_SHIFT         (8U)
/*! SEQUENCE_CTRL - SEQUENCE fault control
 *  0b001..Enable reset
 *  0b010..Enable interrupt
 *  0b100..Disable both reset and interrupt
 */
#define CDOG_CONTROL_SEQUENCE_CTRL(x)            (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_SEQUENCE_CTRL_SHIFT)) & CDOG_CONTROL_SEQUENCE_CTRL_MASK)

#define CDOG_CONTROL_STATE_CTRL_MASK             (0x1C000U)
#define CDOG_CONTROL_STATE_CTRL_SHIFT            (14U)
/*! STATE_CTRL - STATE fault control
 *  0b001..Enable reset
 *  0b010..Enable interrupt
 *  0b100..Disable both reset and interrupt
 */
#define CDOG_CONTROL_STATE_CTRL(x)               (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_STATE_CTRL_SHIFT)) & CDOG_CONTROL_STATE_CTRL_MASK)

#define CDOG_CONTROL_ADDRESS_CTRL_MASK           (0xE0000U)
#define CDOG_CONTROL_ADDRESS_CTRL_SHIFT          (17U)
/*! ADDRESS_CTRL - ADDRESS fault control
 *  0b001..Enable reset
 *  0b010..Enable interrupt
 *  0b100..Disable both reset and interrupt
 */
#define CDOG_CONTROL_ADDRESS_CTRL(x)             (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_ADDRESS_CTRL_SHIFT)) & CDOG_CONTROL_ADDRESS_CTRL_MASK)

#define CDOG_CONTROL_IRQ_PAUSE_MASK              (0x30000000U)
#define CDOG_CONTROL_IRQ_PAUSE_SHIFT             (28U)
/*! IRQ_PAUSE - IRQ pause control
 *  0b01..Keep the timer running
 *  0b10..Stop the timer
 */
#define CDOG_CONTROL_IRQ_PAUSE(x)                (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_IRQ_PAUSE_SHIFT)) & CDOG_CONTROL_IRQ_PAUSE_MASK)

#define CDOG_CONTROL_DEBUG_HALT_CTRL_MASK        (0xC0000000U)
#define CDOG_CONTROL_DEBUG_HALT_CTRL_SHIFT       (30U)
/*! DEBUG_HALT_CTRL - DEBUG_HALT control
 *  0b01..Keep the timer running
 *  0b10..Stop the timer
 */
#define CDOG_CONTROL_DEBUG_HALT_CTRL(x)          (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_DEBUG_HALT_CTRL_SHIFT)) & CDOG_CONTROL_DEBUG_HALT_CTRL_MASK)
/*! @} */

/*! @name RELOAD - Instruction Timer reload */
/*! @{ */

#define CDOG_RELOAD_RLOAD_MASK                   (0xFFFFFFFFU)
#define CDOG_RELOAD_RLOAD_SHIFT                  (0U)
/*! RLOAD - Instruction Timer reload value
 */
#define CDOG_RELOAD_RLOAD(x)                     (((uint32_t)(((uint32_t)(x)) << CDOG_RELOAD_RLOAD_SHIFT)) & CDOG_RELOAD_RLOAD_MASK)
/*! @} */

/*! @name INSTRUCTION_TIMER - Instruction Timer */
/*! @{ */

#define CDOG_INSTRUCTION_TIMER_INSTIM_MASK       (0xFFFFFFFFU)
#define CDOG_INSTRUCTION_TIMER_INSTIM_SHIFT      (0U)
/*! INSTIM - Current value of the Instruction Timer
 */
#define CDOG_INSTRUCTION_TIMER_INSTIM(x)         (((uint32_t)(((uint32_t)(x)) << CDOG_INSTRUCTION_TIMER_INSTIM_SHIFT)) & CDOG_INSTRUCTION_TIMER_INSTIM_MASK)
/*! @} */

/*! @name SECURE_COUNTER - Secure Counter */
/*! @{ */

#define CDOG_SECURE_COUNTER_SECCNT_MASK          (0xFFFFFFFFU)
#define CDOG_SECURE_COUNTER_SECCNT_SHIFT         (0U)
/*! SECCNT - Secure Counter
 */
#define CDOG_SECURE_COUNTER_SECCNT(x)            (((uint32_t)(((uint32_t)(x)) << CDOG_SECURE_COUNTER_SECCNT_SHIFT)) & CDOG_SECURE_COUNTER_SECCNT_MASK)
/*! @} */

/*! @name STATUS - Status 1 */
/*! @{ */

#define CDOG_STATUS_NUMTOF_MASK                  (0xFFU)
#define CDOG_STATUS_NUMTOF_SHIFT                 (0U)
/*! NUMTOF - Number of TIMEOUT faults since the last POR
 */
#define CDOG_STATUS_NUMTOF(x)                    (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS_NUMTOF_SHIFT)) & CDOG_STATUS_NUMTOF_MASK)

#define CDOG_STATUS_NUMMISCOMPF_MASK             (0xFF00U)
#define CDOG_STATUS_NUMMISCOMPF_SHIFT            (8U)
/*! NUMMISCOMPF - Number of MISCOMPARE faults since the last POR
 */
#define CDOG_STATUS_NUMMISCOMPF(x)               (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS_NUMMISCOMPF_SHIFT)) & CDOG_STATUS_NUMMISCOMPF_MASK)

#define CDOG_STATUS_NUMILSEQF_MASK               (0xFF0000U)
#define CDOG_STATUS_NUMILSEQF_SHIFT              (16U)
/*! NUMILSEQF - Number of SEQUENCE faults since the last POR
 */
#define CDOG_STATUS_NUMILSEQF(x)                 (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS_NUMILSEQF_SHIFT)) & CDOG_STATUS_NUMILSEQF_MASK)

#define CDOG_STATUS_CURST_MASK                   (0xF0000000U)
#define CDOG_STATUS_CURST_SHIFT                  (28U)
/*! CURST - Current State
 */
#define CDOG_STATUS_CURST(x)                     (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS_CURST_SHIFT)) & CDOG_STATUS_CURST_MASK)
/*! @} */

/*! @name STATUS2 - Status 2 */
/*! @{ */

#define CDOG_STATUS2_NUMCNTF_MASK                (0xFFU)
#define CDOG_STATUS2_NUMCNTF_SHIFT               (0U)
/*! NUMCNTF - Number of CONTROL faults since the last POR
 */
#define CDOG_STATUS2_NUMCNTF(x)                  (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS2_NUMCNTF_SHIFT)) & CDOG_STATUS2_NUMCNTF_MASK)

#define CDOG_STATUS2_NUMILLSTF_MASK              (0xFF00U)
#define CDOG_STATUS2_NUMILLSTF_SHIFT             (8U)
/*! NUMILLSTF - Number of STATE faults since the last POR
 */
#define CDOG_STATUS2_NUMILLSTF(x)                (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS2_NUMILLSTF_SHIFT)) & CDOG_STATUS2_NUMILLSTF_MASK)

#define CDOG_STATUS2_NUMILLA_MASK                (0xFF0000U)
#define CDOG_STATUS2_NUMILLA_SHIFT               (16U)
/*! NUMILLA - Number of ADDRESS faults since the last POR
 */
#define CDOG_STATUS2_NUMILLA(x)                  (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS2_NUMILLA_SHIFT)) & CDOG_STATUS2_NUMILLA_MASK)
/*! @} */

/*! @name FLAGS - Flags */
/*! @{ */

#define CDOG_FLAGS_TO_FLAG_MASK                  (0x1U)
#define CDOG_FLAGS_TO_FLAG_SHIFT                 (0U)
/*! TO_FLAG - TIMEOUT fault flag
 *  0b0..A TIMEOUT fault has not occurred
 *  0b1..A TIMEOUT fault has occurred
 */
#define CDOG_FLAGS_TO_FLAG(x)                    (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_TO_FLAG_SHIFT)) & CDOG_FLAGS_TO_FLAG_MASK)

#define CDOG_FLAGS_MISCOM_FLAG_MASK              (0x2U)
#define CDOG_FLAGS_MISCOM_FLAG_SHIFT             (1U)
/*! MISCOM_FLAG - MISCOMPARE fault flag
 *  0b0..A MISCOMPARE fault has not occurred
 *  0b1..A MISCOMPARE fault has occurred
 */
#define CDOG_FLAGS_MISCOM_FLAG(x)                (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_MISCOM_FLAG_SHIFT)) & CDOG_FLAGS_MISCOM_FLAG_MASK)

#define CDOG_FLAGS_SEQ_FLAG_MASK                 (0x4U)
#define CDOG_FLAGS_SEQ_FLAG_SHIFT                (2U)
/*! SEQ_FLAG - SEQUENCE fault flag
 *  0b0..A SEQUENCE fault has not occurred
 *  0b1..A SEQUENCE fault has occurred
 */
#define CDOG_FLAGS_SEQ_FLAG(x)                   (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_SEQ_FLAG_SHIFT)) & CDOG_FLAGS_SEQ_FLAG_MASK)

#define CDOG_FLAGS_CNT_FLAG_MASK                 (0x8U)
#define CDOG_FLAGS_CNT_FLAG_SHIFT                (3U)
/*! CNT_FLAG - CONTROL fault flag
 *  0b0..A CONTROL fault has not occurred
 *  0b1..A CONTROL fault has occurred
 */
#define CDOG_FLAGS_CNT_FLAG(x)                   (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_CNT_FLAG_SHIFT)) & CDOG_FLAGS_CNT_FLAG_MASK)

#define CDOG_FLAGS_STATE_FLAG_MASK               (0x10U)
#define CDOG_FLAGS_STATE_FLAG_SHIFT              (4U)
/*! STATE_FLAG - STATE fault flag
 *  0b0..A STATE fault has not occurred
 *  0b1..A STATE fault has occurred
 */
#define CDOG_FLAGS_STATE_FLAG(x)                 (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_STATE_FLAG_SHIFT)) & CDOG_FLAGS_STATE_FLAG_MASK)

#define CDOG_FLAGS_ADDR_FLAG_MASK                (0x20U)
#define CDOG_FLAGS_ADDR_FLAG_SHIFT               (5U)
/*! ADDR_FLAG - ADDRESS fault flag
 *  0b0..An ADDRESS fault has not occurred
 *  0b1..An ADDRESS fault has occurred
 */
#define CDOG_FLAGS_ADDR_FLAG(x)                  (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_ADDR_FLAG_SHIFT)) & CDOG_FLAGS_ADDR_FLAG_MASK)

#define CDOG_FLAGS_POR_FLAG_MASK                 (0x10000U)
#define CDOG_FLAGS_POR_FLAG_SHIFT                (16U)
/*! POR_FLAG - Power-on reset flag
 *  0b0..A Power-on reset event has not occurred
 *  0b1..A Power-on reset event has occurred
 */
#define CDOG_FLAGS_POR_FLAG(x)                   (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_POR_FLAG_SHIFT)) & CDOG_FLAGS_POR_FLAG_MASK)
/*! @} */

/*! @name PERSISTENT - Persistent Data Storage */
/*! @{ */

#define CDOG_PERSISTENT_PERSIS_MASK              (0xFFFFFFFFU)
#define CDOG_PERSISTENT_PERSIS_SHIFT             (0U)
/*! PERSIS - Persistent Storage
 */
#define CDOG_PERSISTENT_PERSIS(x)                (((uint32_t)(((uint32_t)(x)) << CDOG_PERSISTENT_PERSIS_SHIFT)) & CDOG_PERSISTENT_PERSIS_MASK)
/*! @} */

/*! @name START - START Command */
/*! @{ */

#define CDOG_START_STRT_MASK                     (0xFFFFFFFFU)
#define CDOG_START_STRT_SHIFT                    (0U)
/*! STRT - Start command
 */
#define CDOG_START_STRT(x)                       (((uint32_t)(((uint32_t)(x)) << CDOG_START_STRT_SHIFT)) & CDOG_START_STRT_MASK)
/*! @} */

/*! @name STOP - STOP Command */
/*! @{ */

#define CDOG_STOP_STP_MASK                       (0xFFFFFFFFU)
#define CDOG_STOP_STP_SHIFT                      (0U)
/*! STP - Stop command
 */
#define CDOG_STOP_STP(x)                         (((uint32_t)(((uint32_t)(x)) << CDOG_STOP_STP_SHIFT)) & CDOG_STOP_STP_MASK)
/*! @} */

/*! @name RESTART - RESTART Command */
/*! @{ */

#define CDOG_RESTART_RSTRT_MASK                  (0xFFFFFFFFU)
#define CDOG_RESTART_RSTRT_SHIFT                 (0U)
/*! RSTRT - Restart command
 */
#define CDOG_RESTART_RSTRT(x)                    (((uint32_t)(((uint32_t)(x)) << CDOG_RESTART_RSTRT_SHIFT)) & CDOG_RESTART_RSTRT_MASK)
/*! @} */

/*! @name ADD - ADD Command */
/*! @{ */

#define CDOG_ADD_AD_MASK                         (0xFFFFFFFFU)
#define CDOG_ADD_AD_SHIFT                        (0U)
/*! AD - ADD Write Value
 */
#define CDOG_ADD_AD(x)                           (((uint32_t)(((uint32_t)(x)) << CDOG_ADD_AD_SHIFT)) & CDOG_ADD_AD_MASK)
/*! @} */

/*! @name ADD1 - ADD1 Command */
/*! @{ */

#define CDOG_ADD1_AD1_MASK                       (0xFFFFFFFFU)
#define CDOG_ADD1_AD1_SHIFT                      (0U)
/*! AD1 - ADD 1
 */
#define CDOG_ADD1_AD1(x)                         (((uint32_t)(((uint32_t)(x)) << CDOG_ADD1_AD1_SHIFT)) & CDOG_ADD1_AD1_MASK)
/*! @} */

/*! @name ADD16 - ADD16 Command */
/*! @{ */

#define CDOG_ADD16_AD16_MASK                     (0xFFFFFFFFU)
#define CDOG_ADD16_AD16_SHIFT                    (0U)
/*! AD16 - ADD 16
 */
#define CDOG_ADD16_AD16(x)                       (((uint32_t)(((uint32_t)(x)) << CDOG_ADD16_AD16_SHIFT)) & CDOG_ADD16_AD16_MASK)
/*! @} */

/*! @name ADD256 - ADD256 Command */
/*! @{ */

#define CDOG_ADD256_AD256_MASK                   (0xFFFFFFFFU)
#define CDOG_ADD256_AD256_SHIFT                  (0U)
/*! AD256 - ADD 256
 */
#define CDOG_ADD256_AD256(x)                     (((uint32_t)(((uint32_t)(x)) << CDOG_ADD256_AD256_SHIFT)) & CDOG_ADD256_AD256_MASK)
/*! @} */

/*! @name SUB - SUB Command */
/*! @{ */

#define CDOG_SUB_S0B_MASK                        (0xFFFFFFFFU)
#define CDOG_SUB_S0B_SHIFT                       (0U)
/*! S0B - Subtract Write Value
 */
#define CDOG_SUB_S0B(x)                          (((uint32_t)(((uint32_t)(x)) << CDOG_SUB_S0B_SHIFT)) & CDOG_SUB_S0B_MASK)
/*! @} */

/*! @name SUB1 - SUB1 Command */
/*! @{ */

#define CDOG_SUB1_S1B_MASK                       (0xFFFFFFFFU)
#define CDOG_SUB1_S1B_SHIFT                      (0U)
/*! S1B - Subtract 1
 */
#define CDOG_SUB1_S1B(x)                         (((uint32_t)(((uint32_t)(x)) << CDOG_SUB1_S1B_SHIFT)) & CDOG_SUB1_S1B_MASK)
/*! @} */

/*! @name SUB16 - SUB16 Command */
/*! @{ */

#define CDOG_SUB16_SB16_MASK                     (0xFFFFFFFFU)
#define CDOG_SUB16_SB16_SHIFT                    (0U)
/*! SB16 - Subtract 16
 */
#define CDOG_SUB16_SB16(x)                       (((uint32_t)(((uint32_t)(x)) << CDOG_SUB16_SB16_SHIFT)) & CDOG_SUB16_SB16_MASK)
/*! @} */

/*! @name SUB256 - SUB256 Command */
/*! @{ */

#define CDOG_SUB256_SB256_MASK                   (0xFFFFFFFFU)
#define CDOG_SUB256_SB256_SHIFT                  (0U)
/*! SB256 - Subtract 256
 */
#define CDOG_SUB256_SB256(x)                     (((uint32_t)(((uint32_t)(x)) << CDOG_SUB256_SB256_SHIFT)) & CDOG_SUB256_SB256_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CDOG_Register_Masks */


/* CDOG - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral CDOG base address */
  #define CDOG_BASE                                (0x500A1000u)
  /** Peripheral CDOG base address */
  #define CDOG_BASE_NS                             (0x400A1000u)
  /** Peripheral CDOG base pointer */
  #define CDOG                                     ((CDOG_Type *)CDOG_BASE)
  /** Peripheral CDOG base pointer */
  #define CDOG_NS                                  ((CDOG_Type *)CDOG_BASE_NS)
  /** Array initializer of CDOG peripheral base addresses */
  #define CDOG_BASE_ADDRS                          { CDOG_BASE }
  /** Array initializer of CDOG peripheral base pointers */
  #define CDOG_BASE_PTRS                           { CDOG }
  /** Array initializer of CDOG peripheral base addresses */
  #define CDOG_BASE_ADDRS_NS                       { CDOG_BASE_NS }
  /** Array initializer of CDOG peripheral base pointers */
  #define CDOG_BASE_PTRS_NS                        { CDOG_NS }
#else
  /** Peripheral CDOG base address */
  #define CDOG_BASE                                (0x400A1000u)
  /** Peripheral CDOG base pointer */
  #define CDOG                                     ((CDOG_Type *)CDOG_BASE)
  /** Array initializer of CDOG peripheral base addresses */
  #define CDOG_BASE_ADDRS                          { CDOG_BASE }
  /** Array initializer of CDOG peripheral base pointers */
  #define CDOG_BASE_PTRS                           { CDOG }
#endif
/** Interrupt vectors for the CDOG peripheral type */
#define CDOG_IRQS                                { CDOG_IRQn }

/*!
 * @}
 */ /* end of group CDOG_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CRC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CRC_Peripheral_Access_Layer CRC Peripheral Access Layer
 * @{
 */

/** CRC - Register Layout Typedef */
typedef struct {
  union {                                          /* offset: 0x0 */
    struct {                                         /* offset: 0x0 */
      __IO uint8_t DATALL;                             /**< CRC_DATALL register, offset: 0x0 */
      __IO uint8_t DATALU;                             /**< CRC_DATALU register, offset: 0x1 */
      __IO uint8_t DATAHL;                             /**< CRC_DATAHL register, offset: 0x2 */
      __IO uint8_t DATAHU;                             /**< CRC_DATAHU register, offset: 0x3 */
    } ACCESS8BIT;
    struct {                                         /* offset: 0x0 */
      __IO uint16_t DATAL;                             /**< CRC_DATAL register, offset: 0x0 */
      __IO uint16_t DATAH;                             /**< CRC_DATAH register, offset: 0x2 */
    } ACCESS16BIT;
    __IO uint32_t DATA;                              /**< CRC DATA register, offset: 0x0 */
  };
  union {                                          /* offset: 0x4 */
    struct {                                         /* offset: 0x4 */
      __IO uint8_t GPOLYLL;                            /**< CRC_GPOLYLL register, offset: 0x4 */
      __IO uint8_t GPOLYLU;                            /**< CRC_GPOLYLU register, offset: 0x5 */
      __IO uint8_t GPOLYHL;                            /**< CRC_GPOLYHL register, offset: 0x6 */
      __IO uint8_t GPOLYHU;                            /**< CRC_GPOLYHU register, offset: 0x7 */
    } GPOLY_ACCESS8BIT;
    struct {                                         /* offset: 0x4 */
      __IO uint16_t GPOLYL;                            /**< CRC_GPOLYL register, offset: 0x4 */
      __IO uint16_t GPOLYH;                            /**< CRC_GPOLYH register, offset: 0x6 */
    } GPOLY_ACCESS16BIT;
    __IO uint32_t GPOLY;                             /**< CRC Polynomial register, offset: 0x4 */
  };
  union {                                          /* offset: 0x8 */
    struct {                                         /* offset: 0x8 */
           uint8_t RESERVED_0[3];
      __IO uint8_t CTRLHU;                             /**< CRC_CTRLHU register, offset: 0xB */
    } CTRL_ACCESS8BIT;
    __IO uint32_t CTRL;                              /**< CRC Control register, offset: 0x8 */
  };
} CRC_Type;

/* ----------------------------------------------------------------------------
   -- CRC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CRC_Register_Masks CRC Register Masks
 * @{
 */

/*! @name DATALL - CRC_DATALL register */
/*! @{ */

#define CRC_DATALL_DATALL_MASK                   (0xFFU)
#define CRC_DATALL_DATALL_SHIFT                  (0U)
#define CRC_DATALL_DATALL(x)                     (((uint8_t)(((uint8_t)(x)) << CRC_DATALL_DATALL_SHIFT)) & CRC_DATALL_DATALL_MASK)
/*! @} */

/*! @name DATALU - CRC_DATALU register */
/*! @{ */

#define CRC_DATALU_DATALU_MASK                   (0xFFU)
#define CRC_DATALU_DATALU_SHIFT                  (0U)
#define CRC_DATALU_DATALU(x)                     (((uint8_t)(((uint8_t)(x)) << CRC_DATALU_DATALU_SHIFT)) & CRC_DATALU_DATALU_MASK)
/*! @} */

/*! @name DATAHL - CRC_DATAHL register */
/*! @{ */

#define CRC_DATAHL_DATAHL_MASK                   (0xFFU)
#define CRC_DATAHL_DATAHL_SHIFT                  (0U)
#define CRC_DATAHL_DATAHL(x)                     (((uint8_t)(((uint8_t)(x)) << CRC_DATAHL_DATAHL_SHIFT)) & CRC_DATAHL_DATAHL_MASK)
/*! @} */

/*! @name DATAHU - CRC_DATAHU register */
/*! @{ */

#define CRC_DATAHU_DATAHU_MASK                   (0xFFU)
#define CRC_DATAHU_DATAHU_SHIFT                  (0U)
#define CRC_DATAHU_DATAHU(x)                     (((uint8_t)(((uint8_t)(x)) << CRC_DATAHU_DATAHU_SHIFT)) & CRC_DATAHU_DATAHU_MASK)
/*! @} */

/*! @name DATAL - CRC_DATAL register */
/*! @{ */

#define CRC_DATAL_DATAL_MASK                     (0xFFFFU)
#define CRC_DATAL_DATAL_SHIFT                    (0U)
#define CRC_DATAL_DATAL(x)                       (((uint16_t)(((uint16_t)(x)) << CRC_DATAL_DATAL_SHIFT)) & CRC_DATAL_DATAL_MASK)
/*! @} */

/*! @name DATAH - CRC_DATAH register */
/*! @{ */

#define CRC_DATAH_DATAH_MASK                     (0xFFFFU)
#define CRC_DATAH_DATAH_SHIFT                    (0U)
#define CRC_DATAH_DATAH(x)                       (((uint16_t)(((uint16_t)(x)) << CRC_DATAH_DATAH_SHIFT)) & CRC_DATAH_DATAH_MASK)
/*! @} */

/*! @name DATA - CRC DATA register */
/*! @{ */

#define CRC_DATA_LL_MASK                         (0xFFU)
#define CRC_DATA_LL_SHIFT                        (0U)
/*! LL - CRC Low Lower Byte
 */
#define CRC_DATA_LL(x)                           (((uint32_t)(((uint32_t)(x)) << CRC_DATA_LL_SHIFT)) & CRC_DATA_LL_MASK)

#define CRC_DATA_LU_MASK                         (0xFF00U)
#define CRC_DATA_LU_SHIFT                        (8U)
/*! LU - CRC Low Upper Byte
 */
#define CRC_DATA_LU(x)                           (((uint32_t)(((uint32_t)(x)) << CRC_DATA_LU_SHIFT)) & CRC_DATA_LU_MASK)

#define CRC_DATA_HL_MASK                         (0xFF0000U)
#define CRC_DATA_HL_SHIFT                        (16U)
/*! HL - CRC High Lower Byte
 */
#define CRC_DATA_HL(x)                           (((uint32_t)(((uint32_t)(x)) << CRC_DATA_HL_SHIFT)) & CRC_DATA_HL_MASK)

#define CRC_DATA_HU_MASK                         (0xFF000000U)
#define CRC_DATA_HU_SHIFT                        (24U)
/*! HU - CRC High Upper Byte
 */
#define CRC_DATA_HU(x)                           (((uint32_t)(((uint32_t)(x)) << CRC_DATA_HU_SHIFT)) & CRC_DATA_HU_MASK)
/*! @} */

/*! @name GPOLYLL - CRC_GPOLYLL register */
/*! @{ */

#define CRC_GPOLYLL_GPOLYLL_MASK                 (0xFFU)
#define CRC_GPOLYLL_GPOLYLL_SHIFT                (0U)
#define CRC_GPOLYLL_GPOLYLL(x)                   (((uint8_t)(((uint8_t)(x)) << CRC_GPOLYLL_GPOLYLL_SHIFT)) & CRC_GPOLYLL_GPOLYLL_MASK)
/*! @} */

/*! @name GPOLYLU - CRC_GPOLYLU register */
/*! @{ */

#define CRC_GPOLYLU_GPOLYLU_MASK                 (0xFFU)
#define CRC_GPOLYLU_GPOLYLU_SHIFT                (0U)
#define CRC_GPOLYLU_GPOLYLU(x)                   (((uint8_t)(((uint8_t)(x)) << CRC_GPOLYLU_GPOLYLU_SHIFT)) & CRC_GPOLYLU_GPOLYLU_MASK)
/*! @} */

/*! @name GPOLYHL - CRC_GPOLYHL register */
/*! @{ */

#define CRC_GPOLYHL_GPOLYHL_MASK                 (0xFFU)
#define CRC_GPOLYHL_GPOLYHL_SHIFT                (0U)
#define CRC_GPOLYHL_GPOLYHL(x)                   (((uint8_t)(((uint8_t)(x)) << CRC_GPOLYHL_GPOLYHL_SHIFT)) & CRC_GPOLYHL_GPOLYHL_MASK)
/*! @} */

/*! @name GPOLYHU - CRC_GPOLYHU register */
/*! @{ */

#define CRC_GPOLYHU_GPOLYHU_MASK                 (0xFFU)
#define CRC_GPOLYHU_GPOLYHU_SHIFT                (0U)
#define CRC_GPOLYHU_GPOLYHU(x)                   (((uint8_t)(((uint8_t)(x)) << CRC_GPOLYHU_GPOLYHU_SHIFT)) & CRC_GPOLYHU_GPOLYHU_MASK)
/*! @} */

/*! @name GPOLYL - CRC_GPOLYL register */
/*! @{ */

#define CRC_GPOLYL_GPOLYL_MASK                   (0xFFFFU)
#define CRC_GPOLYL_GPOLYL_SHIFT                  (0U)
#define CRC_GPOLYL_GPOLYL(x)                     (((uint16_t)(((uint16_t)(x)) << CRC_GPOLYL_GPOLYL_SHIFT)) & CRC_GPOLYL_GPOLYL_MASK)
/*! @} */

/*! @name GPOLYH - CRC_GPOLYH register */
/*! @{ */

#define CRC_GPOLYH_GPOLYH_MASK                   (0xFFFFU)
#define CRC_GPOLYH_GPOLYH_SHIFT                  (0U)
#define CRC_GPOLYH_GPOLYH(x)                     (((uint16_t)(((uint16_t)(x)) << CRC_GPOLYH_GPOLYH_SHIFT)) & CRC_GPOLYH_GPOLYH_MASK)
/*! @} */

/*! @name GPOLY - CRC Polynomial register */
/*! @{ */

#define CRC_GPOLY_LOW_MASK                       (0xFFFFU)
#define CRC_GPOLY_LOW_SHIFT                      (0U)
/*! LOW - Low Polynominal Half-word
 */
#define CRC_GPOLY_LOW(x)                         (((uint32_t)(((uint32_t)(x)) << CRC_GPOLY_LOW_SHIFT)) & CRC_GPOLY_LOW_MASK)

#define CRC_GPOLY_HIGH_MASK                      (0xFFFF0000U)
#define CRC_GPOLY_HIGH_SHIFT                     (16U)
/*! HIGH - High Polynominal Half-word
 */
#define CRC_GPOLY_HIGH(x)                        (((uint32_t)(((uint32_t)(x)) << CRC_GPOLY_HIGH_SHIFT)) & CRC_GPOLY_HIGH_MASK)
/*! @} */

/*! @name CTRLHU - CRC_CTRLHU register */
/*! @{ */

#define CRC_CTRLHU_TCRC_MASK                     (0x1U)
#define CRC_CTRLHU_TCRC_SHIFT                    (0U)
/*! TCRC - TCRC
 *  0b0..16-bit CRC protocol.
 *  0b1..32-bit CRC protocol.
 */
#define CRC_CTRLHU_TCRC(x)                       (((uint8_t)(((uint8_t)(x)) << CRC_CTRLHU_TCRC_SHIFT)) & CRC_CTRLHU_TCRC_MASK)

#define CRC_CTRLHU_WAS_MASK                      (0x2U)
#define CRC_CTRLHU_WAS_SHIFT                     (1U)
/*! WAS - Write CRC DATA register As Seed
 *  0b0..Writes to the CRC DATA register are data values.
 *  0b1..Writes to the CRC DATA register are seed values.
 */
#define CRC_CTRLHU_WAS(x)                        (((uint8_t)(((uint8_t)(x)) << CRC_CTRLHU_WAS_SHIFT)) & CRC_CTRLHU_WAS_MASK)

#define CRC_CTRLHU_FXOR_MASK                     (0x4U)
#define CRC_CTRLHU_FXOR_SHIFT                    (2U)
/*! FXOR - Complement Read Of CRC DATA register
 *  0b0..No XOR on reading.
 *  0b1..Invert or complement the read value of the CRC DATA register.
 */
#define CRC_CTRLHU_FXOR(x)                       (((uint8_t)(((uint8_t)(x)) << CRC_CTRLHU_FXOR_SHIFT)) & CRC_CTRLHU_FXOR_MASK)

#define CRC_CTRLHU_TOTR_MASK                     (0x30U)
#define CRC_CTRLHU_TOTR_SHIFT                    (4U)
/*! TOTR - Type Of Transpose For Read
 *  0b00..No transposition.
 *  0b01..Bits in bytes are transposed; bytes are not transposed.
 *  0b10..Both bits in bytes and bytes are transposed.
 *  0b11..Only bytes are transposed; no bits in a byte are transposed.
 */
#define CRC_CTRLHU_TOTR(x)                       (((uint8_t)(((uint8_t)(x)) << CRC_CTRLHU_TOTR_SHIFT)) & CRC_CTRLHU_TOTR_MASK)

#define CRC_CTRLHU_TOT_MASK                      (0xC0U)
#define CRC_CTRLHU_TOT_SHIFT                     (6U)
/*! TOT - Type Of Transpose For Writes
 *  0b00..No transposition.
 *  0b01..Bits in bytes are transposed; bytes are not transposed.
 *  0b10..Both bits in bytes and bytes are transposed.
 *  0b11..Only bytes are transposed; no bits in a byte are transposed.
 */
#define CRC_CTRLHU_TOT(x)                        (((uint8_t)(((uint8_t)(x)) << CRC_CTRLHU_TOT_SHIFT)) & CRC_CTRLHU_TOT_MASK)
/*! @} */

/*! @name CTRL - CRC Control register */
/*! @{ */

#define CRC_CTRL_TCRC_MASK                       (0x1000000U)
#define CRC_CTRL_TCRC_SHIFT                      (24U)
/*! TCRC - TCRC
 *  0b0..16-bit CRC protocol.
 *  0b1..32-bit CRC protocol.
 */
#define CRC_CTRL_TCRC(x)                         (((uint32_t)(((uint32_t)(x)) << CRC_CTRL_TCRC_SHIFT)) & CRC_CTRL_TCRC_MASK)

#define CRC_CTRL_WAS_MASK                        (0x2000000U)
#define CRC_CTRL_WAS_SHIFT                       (25U)
/*! WAS - Write CRC DATA register As Seed
 *  0b0..Writes to the CRC DATA register are data values.
 *  0b1..Writes to the CRC DATA register are seed values.
 */
#define CRC_CTRL_WAS(x)                          (((uint32_t)(((uint32_t)(x)) << CRC_CTRL_WAS_SHIFT)) & CRC_CTRL_WAS_MASK)

#define CRC_CTRL_FXOR_MASK                       (0x4000000U)
#define CRC_CTRL_FXOR_SHIFT                      (26U)
/*! FXOR - Complement Read Of CRC DATA register
 *  0b0..No XOR on reading.
 *  0b1..Invert or complement the read value of the CRC DATA register.
 */
#define CRC_CTRL_FXOR(x)                         (((uint32_t)(((uint32_t)(x)) << CRC_CTRL_FXOR_SHIFT)) & CRC_CTRL_FXOR_MASK)

#define CRC_CTRL_TOTR_MASK                       (0x30000000U)
#define CRC_CTRL_TOTR_SHIFT                      (28U)
/*! TOTR - Type Of Transpose For Read
 *  0b00..No transposition.
 *  0b01..Bits in bytes are transposed; bytes are not transposed.
 *  0b10..Both bits in bytes and bytes are transposed.
 *  0b11..Only bytes are transposed; no bits in a byte are transposed.
 */
#define CRC_CTRL_TOTR(x)                         (((uint32_t)(((uint32_t)(x)) << CRC_CTRL_TOTR_SHIFT)) & CRC_CTRL_TOTR_MASK)

#define CRC_CTRL_TOT_MASK                        (0xC0000000U)
#define CRC_CTRL_TOT_SHIFT                       (30U)
/*! TOT - Type Of Transpose For Writes
 *  0b00..No transposition.
 *  0b01..Bits in bytes are transposed; bytes are not transposed.
 *  0b10..Both bits in bytes and bytes are transposed.
 *  0b11..Only bytes are transposed; no bits in a byte are transposed.
 */
#define CRC_CTRL_TOT(x)                          (((uint32_t)(((uint32_t)(x)) << CRC_CTRL_TOT_SHIFT)) & CRC_CTRL_TOT_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CRC_Register_Masks */


/* CRC - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral CRC0 base address */
  #define CRC0_BASE                                (0x50095000u)
  /** Peripheral CRC0 base address */
  #define CRC0_BASE_NS                             (0x40095000u)
  /** Peripheral CRC0 base pointer */
  #define CRC0                                     ((CRC_Type *)CRC0_BASE)
  /** Peripheral CRC0 base pointer */
  #define CRC0_NS                                  ((CRC_Type *)CRC0_BASE_NS)
  /** Array initializer of CRC peripheral base addresses */
  #define CRC_BASE_ADDRS                           { CRC0_BASE }
  /** Array initializer of CRC peripheral base pointers */
  #define CRC_BASE_PTRS                            { CRC0 }
  /** Array initializer of CRC peripheral base addresses */
  #define CRC_BASE_ADDRS_NS                        { CRC0_BASE_NS }
  /** Array initializer of CRC peripheral base pointers */
  #define CRC_BASE_PTRS_NS                         { CRC0_NS }
#else
  /** Peripheral CRC0 base address */
  #define CRC0_BASE                                (0x40095000u)
  /** Peripheral CRC0 base pointer */
  #define CRC0                                     ((CRC_Type *)CRC0_BASE)
  /** Array initializer of CRC peripheral base addresses */
  #define CRC_BASE_ADDRS                           { CRC0_BASE }
  /** Array initializer of CRC peripheral base pointers */
  #define CRC_BASE_PTRS                            { CRC0 }
#endif

/*!
 * @}
 */ /* end of group CRC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CSS Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CSS_Peripheral_Access_Layer CSS Peripheral Access Layer
 * @{
 */

/** CSS - Register Layout Typedef */
typedef struct {
  __I  uint32_t CSS_STATUS;                        /**< Status register, offset: 0x0 */
  __IO uint32_t CSS_CTRL;                          /**< CSS Control register, offset: 0x4 */
  __IO uint32_t CSS_CMDCFG0;                       /**< CSS command configuration register, offset: 0x8 */
  __IO uint32_t CSS_CFG;                           /**< CSS configuration register, offset: 0xC */
  __IO uint32_t CSS_KIDX0;                         /**< Keystore index 0 - for commands that access a single key, offset: 0x10 */
  __IO uint32_t CSS_KIDX1;                         /**< Keystore index 1 - for commands that access 2 keys, offset: 0x14 */
  __IO uint32_t CSS_KPROPIN;                       /**< key properties request, offset: 0x18 */
       uint8_t RESERVED_0[4];
  __IO uint32_t CSS_DMA_SRC0;                      /**< CSS DMA Source 0, offset: 0x20 */
  __IO uint32_t CSS_DMA_SRC0_LEN;                  /**< CSS DMA Source 0 length, offset: 0x24 */
  __IO uint32_t CSS_DMA_SRC1;                      /**< CSS DMA Source 1, offset: 0x28 */
       uint8_t RESERVED_1[4];
  __IO uint32_t CSS_DMA_SRC2;                      /**< CSS DMA Source 2, offset: 0x30 */
  __IO uint32_t CSS_DMA_SRC2_LEN;                  /**< CSS DMA Source 2 length, offset: 0x34 */
  __IO uint32_t CSS_DMA_RES0;                      /**< CSS DMA Result 0, offset: 0x38 */
  __IO uint32_t CSS_DMA_RES0_LEN;                  /**< CSS DMA Result 0 Size, offset: 0x3C */
  __IO uint32_t CSS_INT_ENABLE;                    /**< Interrupt enable, offset: 0x40 */
  __O  uint32_t CSS_INT_STATUS_CLR;                /**< Interrupt status clear, offset: 0x44 */
  __O  uint32_t CSS_INT_STATUS_SET;                /**< Interrupt status set, offset: 0x48 */
  __I  uint32_t CSS_ERR_STATUS;                    /**< Status register, offset: 0x4C */
  __O  uint32_t CSS_ERR_STATUS_CLR;                /**< Interrupt status clear, offset: 0x50 */
  __I  uint32_t CSS_VERSION;                       /**< CSS Version, offset: 0x54 */
       uint8_t RESERVED_2[4];
  __I  uint32_t CSS_PRNG_DATOUT;                   /**< PRNG SW read out register, offset: 0x5C */
  __I  uint32_t CSS_GDET_EVTCNT;                   /**< CSS GDET Event Counter, offset: 0x60 */
  __O  uint32_t CSS_GDET_EVTCNT_CLR;               /**< CSS GDET Event Counter Clear, offset: 0x64 */
       uint8_t RESERVED_3[152];
  __I  uint32_t CSS_SHA2_STATUS;                   /**< CSS SHA2 Status Register, offset: 0x100 */
  __IO uint32_t CSS_SHA2_CTRL;                     /**< SHA2 Control register, offset: 0x104 */
  __IO uint32_t CSS_SHA2_DIN;                      /**< CSS SHA_DATA IN Register 0, offset: 0x108 */
  __I  uint32_t CSS_SHA2_DOUT0;                    /**< CSS CSS_SHA_DATA Out Register 0, offset: 0x10C */
  __I  uint32_t CSS_SHA2_DOUT1;                    /**< CSS SHA_DATA Out Register 1, offset: 0x110 */
  __I  uint32_t CSS_SHA2_DOUT2;                    /**< CSS SHA_DATA Out Register 2, offset: 0x114 */
  __I  uint32_t CSS_SHA2_DOUT3;                    /**< CSS SHA_DATA Out Register 3, offset: 0x118 */
  __I  uint32_t CSS_SHA2_DOUT4;                    /**< CSS SHA_DATA Out Register 4, offset: 0x11C */
  __I  uint32_t CSS_SHA2_DOUT5;                    /**< CSS SHA_DATA Out Register 5, offset: 0x120 */
  __I  uint32_t CSS_SHA2_DOUT6;                    /**< CSS SHA_DATA Out Register 6, offset: 0x124 */
  __I  uint32_t CSS_SHA2_DOUT7;                    /**< CSS SHA_DATA Out Register 7, offset: 0x128 */
  __I  uint32_t CSS_SHA2_DOUT8;                    /**< CSS CSS_SHA_DATA Out Register 8, offset: 0x12C */
  __I  uint32_t CSS_SHA2_DOUT9;                    /**< CSS SHA_DATA Out Register 9, offset: 0x130 */
  __I  uint32_t CSS_SHA2_DOUT10;                   /**< CSS SHA_DATA Out Register 10, offset: 0x134 */
  __I  uint32_t CSS_SHA2_DOUT11;                   /**< CSS SHA_DATA Out Register 11, offset: 0x138 */
  __I  uint32_t CSS_SHA2_DOUT12;                   /**< CSS SHA_DATA Out Register 12, offset: 0x13C */
  __I  uint32_t CSS_SHA2_DOUT13;                   /**< CSS SHA_DATA Out Register 13, offset: 0x140 */
  __I  uint32_t CSS_SHA2_DOUT14;                   /**< CSS SHA_DATA Out Register 14, offset: 0x144 */
  __I  uint32_t CSS_SHA2_DOUT15;                   /**< CSS SHA_DATA Out Register 15, offset: 0x148 */
       uint8_t RESERVED_4[4];
  __I  uint32_t CSS_KS0;                           /**< Status register, offset: 0x150 */
  __I  uint32_t CSS_KS1;                           /**< Status register, offset: 0x154 */
  __I  uint32_t CSS_KS2;                           /**< Status register, offset: 0x158 */
  __I  uint32_t CSS_KS3;                           /**< Status register, offset: 0x15C */
  __I  uint32_t CSS_KS4;                           /**< Status register, offset: 0x160 */
  __I  uint32_t CSS_KS5;                           /**< Status register, offset: 0x164 */
  __I  uint32_t CSS_KS6;                           /**< Status register, offset: 0x168 */
  __I  uint32_t CSS_KS7;                           /**< Status register, offset: 0x16C */
  __I  uint32_t CSS_KS8;                           /**< Status register, offset: 0x170 */
  __I  uint32_t CSS_KS9;                           /**< Status register, offset: 0x174 */
  __I  uint32_t CSS_KS10;                          /**< Status register, offset: 0x178 */
  __I  uint32_t CSS_KS11;                          /**< Status register, offset: 0x17C */
  __I  uint32_t CSS_KS12;                          /**< Status register, offset: 0x180 */
  __I  uint32_t CSS_KS13;                          /**< Status register, offset: 0x184 */
  __I  uint32_t CSS_KS14;                          /**< Status register, offset: 0x188 */
  __I  uint32_t CSS_KS15;                          /**< Status register, offset: 0x18C */
  __I  uint32_t CSS_KS16;                          /**< Status register, offset: 0x190 */
  __I  uint32_t CSS_KS17;                          /**< Status register, offset: 0x194 */
  __I  uint32_t CSS_KS18;                          /**< Status register, offset: 0x198 */
  __I  uint32_t CSS_KS19;                          /**< Status register, offset: 0x19C */
} CSS_Type;

/* ----------------------------------------------------------------------------
   -- CSS Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CSS_Register_Masks CSS Register Masks
 * @{
 */

/*! @name CSS_STATUS - Status register */
/*! @{ */

#define CSS_CSS_STATUS_css_busy_MASK             (0x1U)
#define CSS_CSS_STATUS_css_busy_SHIFT            (0U)
/*! css_busy - High to indicate the CSS is executing a Crypto Sequence
 */
#define CSS_CSS_STATUS_css_busy(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_STATUS_css_busy_SHIFT)) & CSS_CSS_STATUS_css_busy_MASK)

#define CSS_CSS_STATUS_css_irq_MASK              (0x2U)
#define CSS_CSS_STATUS_css_irq_SHIFT             (1U)
/*! css_irq - High to indicate the CSS has an active interrupt
 */
#define CSS_CSS_STATUS_css_irq(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_STATUS_css_irq_SHIFT)) & CSS_CSS_STATUS_css_irq_MASK)

#define CSS_CSS_STATUS_css_err_MASK              (0x4U)
#define CSS_CSS_STATUS_css_err_SHIFT             (2U)
/*! css_err - High to indicate the CSS has detected an internal error
 */
#define CSS_CSS_STATUS_css_err(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_STATUS_css_err_SHIFT)) & CSS_CSS_STATUS_css_err_MASK)

#define CSS_CSS_STATUS_prng_rdy_MASK             (0x8U)
#define CSS_CSS_STATUS_prng_rdy_SHIFT            (3U)
/*! prng_rdy - High to indicate the internal PRNG is ready. SFR
 */
#define CSS_CSS_STATUS_prng_rdy(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_STATUS_prng_rdy_SHIFT)) & CSS_CSS_STATUS_prng_rdy_MASK)

#define CSS_CSS_STATUS_ecdsa_vfy_status_MASK     (0x30U)
#define CSS_CSS_STATUS_ecdsa_vfy_status_SHIFT    (4U)
/*! ecdsa_vfy_status - Signature Verify Result Status
 */
#define CSS_CSS_STATUS_ecdsa_vfy_status(x)       (((uint32_t)(((uint32_t)(x)) << CSS_CSS_STATUS_ecdsa_vfy_status_SHIFT)) & CSS_CSS_STATUS_ecdsa_vfy_status_MASK)

#define CSS_CSS_STATUS_pprot_MASK                (0xC0U)
#define CSS_CSS_STATUS_pprot_SHIFT               (6U)
/*! pprot - Current command privilege level
 */
#define CSS_CSS_STATUS_pprot(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_STATUS_pprot_SHIFT)) & CSS_CSS_STATUS_pprot_MASK)

#define CSS_CSS_STATUS_drbg_ent_lvl_MASK         (0x300U)
#define CSS_CSS_STATUS_drbg_ent_lvl_SHIFT        (8U)
/*! drbg_ent_lvl - Entropy quality of the current DRBG instance. This value
 */
#define CSS_CSS_STATUS_drbg_ent_lvl(x)           (((uint32_t)(((uint32_t)(x)) << CSS_CSS_STATUS_drbg_ent_lvl_SHIFT)) & CSS_CSS_STATUS_drbg_ent_lvl_MASK)

#define CSS_CSS_STATUS_dtrng_busy_MASK           (0x400U)
#define CSS_CSS_STATUS_dtrng_busy_SHIFT          (10U)
/*! dtrng_busy - When set, it indicates the DTRNG is gathering entropy
 */
#define CSS_CSS_STATUS_dtrng_busy(x)             (((uint32_t)(((uint32_t)(x)) << CSS_CSS_STATUS_dtrng_busy_SHIFT)) & CSS_CSS_STATUS_dtrng_busy_MASK)

#define CSS_CSS_STATUS_gdet_irq_pos_MASK         (0x800U)
#define CSS_CSS_STATUS_gdet_irq_pos_SHIFT        (11U)
/*! gdet_irq_pos - IRQ for GDET has detected a negative glitch: active high irq
 */
#define CSS_CSS_STATUS_gdet_irq_pos(x)           (((uint32_t)(((uint32_t)(x)) << CSS_CSS_STATUS_gdet_irq_pos_SHIFT)) & CSS_CSS_STATUS_gdet_irq_pos_MASK)

#define CSS_CSS_STATUS_gdet_irq_neg_MASK         (0x1000U)
#define CSS_CSS_STATUS_gdet_irq_neg_SHIFT        (12U)
/*! gdet_irq_neg - IRQ for GDET has detected a positive glitch: active high irq
 */
#define CSS_CSS_STATUS_gdet_irq_neg(x)           (((uint32_t)(((uint32_t)(x)) << CSS_CSS_STATUS_gdet_irq_neg_SHIFT)) & CSS_CSS_STATUS_gdet_irq_neg_MASK)

#define CSS_CSS_STATUS_status_rsvd_MASK          (0xFFFFE000U)
#define CSS_CSS_STATUS_status_rsvd_SHIFT         (13U)
/*! status_rsvd - reserved
 */
#define CSS_CSS_STATUS_status_rsvd(x)            (((uint32_t)(((uint32_t)(x)) << CSS_CSS_STATUS_status_rsvd_SHIFT)) & CSS_CSS_STATUS_status_rsvd_MASK)
/*! @} */

/*! @name CSS_CTRL - CSS Control register */
/*! @{ */

#define CSS_CSS_CTRL_css_en_MASK                 (0x1U)
#define CSS_CSS_CTRL_css_en_SHIFT                (0U)
/*! css_en - CSS enable 0=CSS disabled, 1= CSS is enabled
 */
#define CSS_CSS_CTRL_css_en(x)                   (((uint32_t)(((uint32_t)(x)) << CSS_CSS_CTRL_css_en_SHIFT)) & CSS_CSS_CTRL_css_en_MASK)

#define CSS_CSS_CTRL_css_start_MASK              (0x2U)
#define CSS_CSS_CTRL_css_start_SHIFT             (1U)
/*! css_start - Write to 1 to start a CSS Operation
 */
#define CSS_CSS_CTRL_css_start(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_CTRL_css_start_SHIFT)) & CSS_CSS_CTRL_css_start_MASK)

#define CSS_CSS_CTRL_css_reset_MASK              (0x4U)
#define CSS_CSS_CTRL_css_reset_SHIFT             (2U)
/*! css_reset - Write to 1 to perform a CSS synchronous Reset
 */
#define CSS_CSS_CTRL_css_reset(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_CTRL_css_reset_SHIFT)) & CSS_CSS_CTRL_css_reset_MASK)

#define CSS_CSS_CTRL_css_cmd_MASK                (0xF8U)
#define CSS_CSS_CTRL_css_cmd_SHIFT               (3U)
/*! css_cmd - CSS Command Field: List of Valid commands:
 */
#define CSS_CSS_CTRL_css_cmd(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_CTRL_css_cmd_SHIFT)) & CSS_CSS_CTRL_css_cmd_MASK)

#define CSS_CSS_CTRL_byte_order_MASK             (0x100U)
#define CSS_CSS_CTRL_byte_order_SHIFT            (8U)
/*! byte_order - Defines Endianness - 1: BigEndian, 0: Little Endian
 */
#define CSS_CSS_CTRL_byte_order(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_CTRL_byte_order_SHIFT)) & CSS_CSS_CTRL_byte_order_MASK)

#define CSS_CSS_CTRL_ctrl_rfu_MASK               (0xFFFFFE00U)
#define CSS_CSS_CTRL_ctrl_rfu_SHIFT              (9U)
/*! ctrl_rfu - reserved
 */
#define CSS_CSS_CTRL_ctrl_rfu(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_CTRL_ctrl_rfu_SHIFT)) & CSS_CSS_CTRL_ctrl_rfu_MASK)
/*! @} */

/*! @name CSS_CMDCFG0 - CSS command configuration register */
/*! @{ */

#define CSS_CSS_CMDCFG0_cmdcfg0_MASK             (0xFFFFFFFFU)
#define CSS_CSS_CMDCFG0_cmdcfg0_SHIFT            (0U)
/*! cmdcfg0 - refer to reference manual for assignment of this field
 */
#define CSS_CSS_CMDCFG0_cmdcfg0(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_CMDCFG0_cmdcfg0_SHIFT)) & CSS_CSS_CMDCFG0_cmdcfg0_MASK)
/*! @} */

/*! @name CSS_CFG - CSS configuration register */
/*! @{ */

#define CSS_CSS_CFG_cfg_rsvd0_MASK               (0xFFFFU)
#define CSS_CSS_CFG_cfg_rsvd0_SHIFT              (0U)
/*! cfg_rsvd0 - reserved
 */
#define CSS_CSS_CFG_cfg_rsvd0(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_CFG_cfg_rsvd0_SHIFT)) & CSS_CSS_CFG_cfg_rsvd0_MASK)

#define CSS_CSS_CFG_adctrl_MASK                  (0x3FF0000U)
#define CSS_CSS_CFG_adctrl_SHIFT                 (16U)
/*! adctrl - maximum aes start delay
 */
#define CSS_CSS_CFG_adctrl(x)                    (((uint32_t)(((uint32_t)(x)) << CSS_CSS_CFG_adctrl_SHIFT)) & CSS_CSS_CFG_adctrl_MASK)

#define CSS_CSS_CFG_cfg_rsvd1_MASK               (0x7C000000U)
#define CSS_CSS_CFG_cfg_rsvd1_SHIFT              (26U)
/*! cfg_rsvd1 - reserved
 */
#define CSS_CSS_CFG_cfg_rsvd1(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_CFG_cfg_rsvd1_SHIFT)) & CSS_CSS_CFG_cfg_rsvd1_MASK)

#define CSS_CSS_CFG_sha2_direct_MASK             (0x80000000U)
#define CSS_CSS_CFG_sha2_direct_SHIFT            (31U)
/*! sha2_direct - 1=enable sha2 direct mode: direct access from external
 */
#define CSS_CSS_CFG_sha2_direct(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_CFG_sha2_direct_SHIFT)) & CSS_CSS_CFG_sha2_direct_MASK)
/*! @} */

/*! @name CSS_KIDX0 - Keystore index 0 - for commands that access a single key */
/*! @{ */

#define CSS_CSS_KIDX0_kidx0_MASK                 (0x7FU)
#define CSS_CSS_KIDX0_kidx0_SHIFT                (0U)
/*! kidx0 - keystore is indexed as an array of 128 bit key slots
 */
#define CSS_CSS_KIDX0_kidx0(x)                   (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KIDX0_kidx0_SHIFT)) & CSS_CSS_KIDX0_kidx0_MASK)

#define CSS_CSS_KIDX0_kidx0_rsvd_MASK            (0xFFFFFF80U)
#define CSS_CSS_KIDX0_kidx0_rsvd_SHIFT           (7U)
/*! kidx0_rsvd - reserved
 */
#define CSS_CSS_KIDX0_kidx0_rsvd(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KIDX0_kidx0_rsvd_SHIFT)) & CSS_CSS_KIDX0_kidx0_rsvd_MASK)
/*! @} */

/*! @name CSS_KIDX1 - Keystore index 1 - for commands that access 2 keys */
/*! @{ */

#define CSS_CSS_KIDX1_kidx1_MASK                 (0x7FU)
#define CSS_CSS_KIDX1_kidx1_SHIFT                (0U)
/*! kidx1 - keystore is indexed as an array of 128 bit key slots
 */
#define CSS_CSS_KIDX1_kidx1(x)                   (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KIDX1_kidx1_SHIFT)) & CSS_CSS_KIDX1_kidx1_MASK)

#define CSS_CSS_KIDX1_kidx1_rsvd_MASK            (0xFFFFFF80U)
#define CSS_CSS_KIDX1_kidx1_rsvd_SHIFT           (7U)
/*! kidx1_rsvd - reserved
 */
#define CSS_CSS_KIDX1_kidx1_rsvd(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KIDX1_kidx1_rsvd_SHIFT)) & CSS_CSS_KIDX1_kidx1_rsvd_MASK)
/*! @} */

/*! @name CSS_KPROPIN - key properties request */
/*! @{ */

#define CSS_CSS_KPROPIN_kpropin_MASK             (0xFFFFFFFFU)
#define CSS_CSS_KPROPIN_kpropin_SHIFT            (0U)
/*! kpropin - for commands that create a key - requested properties
 */
#define CSS_CSS_KPROPIN_kpropin(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KPROPIN_kpropin_SHIFT)) & CSS_CSS_KPROPIN_kpropin_MASK)
/*! @} */

/*! @name CSS_DMA_SRC0 - CSS DMA Source 0 */
/*! @{ */

#define CSS_CSS_DMA_SRC0_addr_src0_MASK          (0xFFFFFFFFU)
#define CSS_CSS_DMA_SRC0_addr_src0_SHIFT         (0U)
/*! addr_src0 - defines the System address of the start of the
 */
#define CSS_CSS_DMA_SRC0_addr_src0(x)            (((uint32_t)(((uint32_t)(x)) << CSS_CSS_DMA_SRC0_addr_src0_SHIFT)) & CSS_CSS_DMA_SRC0_addr_src0_MASK)
/*! @} */

/*! @name CSS_DMA_SRC0_LEN - CSS DMA Source 0 length */
/*! @{ */

#define CSS_CSS_DMA_SRC0_LEN_size_src0_len_MASK  (0xFFFFFFFFU)
#define CSS_CSS_DMA_SRC0_LEN_size_src0_len_SHIFT (0U)
/*! size_src0_len - Size in bytes of the data to be transferred from
 */
#define CSS_CSS_DMA_SRC0_LEN_size_src0_len(x)    (((uint32_t)(((uint32_t)(x)) << CSS_CSS_DMA_SRC0_LEN_size_src0_len_SHIFT)) & CSS_CSS_DMA_SRC0_LEN_size_src0_len_MASK)
/*! @} */

/*! @name CSS_DMA_SRC1 - CSS DMA Source 1 */
/*! @{ */

#define CSS_CSS_DMA_SRC1_addr_src1_MASK          (0xFFFFFFFFU)
#define CSS_CSS_DMA_SRC1_addr_src1_SHIFT         (0U)
/*! addr_src1 - defines the System address of the start of the
 */
#define CSS_CSS_DMA_SRC1_addr_src1(x)            (((uint32_t)(((uint32_t)(x)) << CSS_CSS_DMA_SRC1_addr_src1_SHIFT)) & CSS_CSS_DMA_SRC1_addr_src1_MASK)
/*! @} */

/*! @name CSS_DMA_SRC2 - CSS DMA Source 2 */
/*! @{ */

#define CSS_CSS_DMA_SRC2_addr_src2_MASK          (0xFFFFFFFFU)
#define CSS_CSS_DMA_SRC2_addr_src2_SHIFT         (0U)
/*! addr_src2 - defines the System address of the start of the
 */
#define CSS_CSS_DMA_SRC2_addr_src2(x)            (((uint32_t)(((uint32_t)(x)) << CSS_CSS_DMA_SRC2_addr_src2_SHIFT)) & CSS_CSS_DMA_SRC2_addr_src2_MASK)
/*! @} */

/*! @name CSS_DMA_SRC2_LEN - CSS DMA Source 2 length */
/*! @{ */

#define CSS_CSS_DMA_SRC2_LEN_size_src2_len_MASK  (0xFFFFFFFFU)
#define CSS_CSS_DMA_SRC2_LEN_size_src2_len_SHIFT (0U)
/*! size_src2_len - Size in bytes of the data to be transferred from
 */
#define CSS_CSS_DMA_SRC2_LEN_size_src2_len(x)    (((uint32_t)(((uint32_t)(x)) << CSS_CSS_DMA_SRC2_LEN_size_src2_len_SHIFT)) & CSS_CSS_DMA_SRC2_LEN_size_src2_len_MASK)
/*! @} */

/*! @name CSS_DMA_RES0 - CSS DMA Result 0 */
/*! @{ */

#define CSS_CSS_DMA_RES0_addr_res0_MASK          (0xFFFFFFFFU)
#define CSS_CSS_DMA_RES0_addr_res0_SHIFT         (0U)
/*! addr_res0 - defines the System Start address of where the result
 */
#define CSS_CSS_DMA_RES0_addr_res0(x)            (((uint32_t)(((uint32_t)(x)) << CSS_CSS_DMA_RES0_addr_res0_SHIFT)) & CSS_CSS_DMA_RES0_addr_res0_MASK)
/*! @} */

/*! @name CSS_DMA_RES0_LEN - CSS DMA Result 0 Size */
/*! @{ */

#define CSS_CSS_DMA_RES0_LEN_size_res0_len_MASK  (0xFFFFFFFFU)
#define CSS_CSS_DMA_RES0_LEN_size_res0_len_SHIFT (0U)
/*! size_res0_len - Size in bytes of the data to be transferred to
 */
#define CSS_CSS_DMA_RES0_LEN_size_res0_len(x)    (((uint32_t)(((uint32_t)(x)) << CSS_CSS_DMA_RES0_LEN_size_res0_len_SHIFT)) & CSS_CSS_DMA_RES0_LEN_size_res0_len_MASK)
/*! @} */

/*! @name CSS_INT_ENABLE - Interrupt enable */
/*! @{ */

#define CSS_CSS_INT_ENABLE_int_en_MASK           (0x1U)
#define CSS_CSS_INT_ENABLE_int_en_SHIFT          (0U)
/*! int_en - Interrupt enable bit
 */
#define CSS_CSS_INT_ENABLE_int_en(x)             (((uint32_t)(((uint32_t)(x)) << CSS_CSS_INT_ENABLE_int_en_SHIFT)) & CSS_CSS_INT_ENABLE_int_en_MASK)

#define CSS_CSS_INT_ENABLE_gdet_int_en_MASK      (0x2U)
#define CSS_CSS_INT_ENABLE_gdet_int_en_SHIFT     (1U)
/*! gdet_int_en - GDET Interrupt enable bit
 */
#define CSS_CSS_INT_ENABLE_gdet_int_en(x)        (((uint32_t)(((uint32_t)(x)) << CSS_CSS_INT_ENABLE_gdet_int_en_SHIFT)) & CSS_CSS_INT_ENABLE_gdet_int_en_MASK)

#define CSS_CSS_INT_ENABLE_int_ena_rsvd_MASK     (0xFFFFFFFCU)
#define CSS_CSS_INT_ENABLE_int_ena_rsvd_SHIFT    (2U)
/*! int_ena_rsvd - reserved
 */
#define CSS_CSS_INT_ENABLE_int_ena_rsvd(x)       (((uint32_t)(((uint32_t)(x)) << CSS_CSS_INT_ENABLE_int_ena_rsvd_SHIFT)) & CSS_CSS_INT_ENABLE_int_ena_rsvd_MASK)
/*! @} */

/*! @name CSS_INT_STATUS_CLR - Interrupt status clear */
/*! @{ */

#define CSS_CSS_INT_STATUS_CLR_int_clr_MASK      (0x1U)
#define CSS_CSS_INT_STATUS_CLR_int_clr_SHIFT     (0U)
/*! int_clr - Interrupt status clear
 */
#define CSS_CSS_INT_STATUS_CLR_int_clr(x)        (((uint32_t)(((uint32_t)(x)) << CSS_CSS_INT_STATUS_CLR_int_clr_SHIFT)) & CSS_CSS_INT_STATUS_CLR_int_clr_MASK)

#define CSS_CSS_INT_STATUS_CLR_gdet_int_clr_MASK (0x2U)
#define CSS_CSS_INT_STATUS_CLR_gdet_int_clr_SHIFT (1U)
/*! gdet_int_clr - GDET Interrupt status clear
 */
#define CSS_CSS_INT_STATUS_CLR_gdet_int_clr(x)   (((uint32_t)(((uint32_t)(x)) << CSS_CSS_INT_STATUS_CLR_gdet_int_clr_SHIFT)) & CSS_CSS_INT_STATUS_CLR_gdet_int_clr_MASK)

#define CSS_CSS_INT_STATUS_CLR_int_stsc_rsvd_MASK (0xFFFFFFFCU)
#define CSS_CSS_INT_STATUS_CLR_int_stsc_rsvd_SHIFT (2U)
/*! int_stsc_rsvd - reserved
 */
#define CSS_CSS_INT_STATUS_CLR_int_stsc_rsvd(x)  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_INT_STATUS_CLR_int_stsc_rsvd_SHIFT)) & CSS_CSS_INT_STATUS_CLR_int_stsc_rsvd_MASK)
/*! @} */

/*! @name CSS_INT_STATUS_SET - Interrupt status set */
/*! @{ */

#define CSS_CSS_INT_STATUS_SET_int_set_MASK      (0x1U)
#define CSS_CSS_INT_STATUS_SET_int_set_SHIFT     (0U)
/*! int_set - Set interrupt by software
 */
#define CSS_CSS_INT_STATUS_SET_int_set(x)        (((uint32_t)(((uint32_t)(x)) << CSS_CSS_INT_STATUS_SET_int_set_SHIFT)) & CSS_CSS_INT_STATUS_SET_int_set_MASK)

#define CSS_CSS_INT_STATUS_SET_gdet_int_neg_set_MASK (0x2U)
#define CSS_CSS_INT_STATUS_SET_gdet_int_neg_set_SHIFT (1U)
/*! gdet_int_neg_set - Set GDET interrupt by software
 */
#define CSS_CSS_INT_STATUS_SET_gdet_int_neg_set(x) (((uint32_t)(((uint32_t)(x)) << CSS_CSS_INT_STATUS_SET_gdet_int_neg_set_SHIFT)) & CSS_CSS_INT_STATUS_SET_gdet_int_neg_set_MASK)

#define CSS_CSS_INT_STATUS_SET_gdet_int_pos_set_MASK (0x4U)
#define CSS_CSS_INT_STATUS_SET_gdet_int_pos_set_SHIFT (2U)
/*! gdet_int_pos_set - Set GDET interrupt by software
 */
#define CSS_CSS_INT_STATUS_SET_gdet_int_pos_set(x) (((uint32_t)(((uint32_t)(x)) << CSS_CSS_INT_STATUS_SET_gdet_int_pos_set_SHIFT)) & CSS_CSS_INT_STATUS_SET_gdet_int_pos_set_MASK)

#define CSS_CSS_INT_STATUS_SET_int_stss_rsvd_MASK (0xFFFFFFF8U)
#define CSS_CSS_INT_STATUS_SET_int_stss_rsvd_SHIFT (3U)
/*! int_stss_rsvd - reserved
 */
#define CSS_CSS_INT_STATUS_SET_int_stss_rsvd(x)  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_INT_STATUS_SET_int_stss_rsvd_SHIFT)) & CSS_CSS_INT_STATUS_SET_int_stss_rsvd_MASK)
/*! @} */

/*! @name CSS_ERR_STATUS - Status register */
/*! @{ */

#define CSS_CSS_ERR_STATUS_bus_err_MASK          (0x1U)
#define CSS_CSS_ERR_STATUS_bus_err_SHIFT         (0U)
/*! bus_err - Bus access error: public or private bus
 */
#define CSS_CSS_ERR_STATUS_bus_err(x)            (((uint32_t)(((uint32_t)(x)) << CSS_CSS_ERR_STATUS_bus_err_SHIFT)) & CSS_CSS_ERR_STATUS_bus_err_MASK)

#define CSS_CSS_ERR_STATUS_opn_err_MASK          (0x2U)
#define CSS_CSS_ERR_STATUS_opn_err_SHIFT         (1U)
/*! opn_err - Operational error:
 */
#define CSS_CSS_ERR_STATUS_opn_err(x)            (((uint32_t)(((uint32_t)(x)) << CSS_CSS_ERR_STATUS_opn_err_SHIFT)) & CSS_CSS_ERR_STATUS_opn_err_MASK)

#define CSS_CSS_ERR_STATUS_alg_err_MASK          (0x4U)
#define CSS_CSS_ERR_STATUS_alg_err_SHIFT         (2U)
/*! alg_err - Algorithm error: An internal algorithm has
 */
#define CSS_CSS_ERR_STATUS_alg_err(x)            (((uint32_t)(((uint32_t)(x)) << CSS_CSS_ERR_STATUS_alg_err_SHIFT)) & CSS_CSS_ERR_STATUS_alg_err_MASK)

#define CSS_CSS_ERR_STATUS_itg_err_MASK          (0x8U)
#define CSS_CSS_ERR_STATUS_itg_err_SHIFT         (3U)
/*! itg_err - Data integrity error:
 */
#define CSS_CSS_ERR_STATUS_itg_err(x)            (((uint32_t)(((uint32_t)(x)) << CSS_CSS_ERR_STATUS_itg_err_SHIFT)) & CSS_CSS_ERR_STATUS_itg_err_MASK)

#define CSS_CSS_ERR_STATUS_flt_err_MASK          (0x10U)
#define CSS_CSS_ERR_STATUS_flt_err_SHIFT         (4U)
/*! flt_err - Hardware fault error: Attempt to change the value
 */
#define CSS_CSS_ERR_STATUS_flt_err(x)            (((uint32_t)(((uint32_t)(x)) << CSS_CSS_ERR_STATUS_flt_err_SHIFT)) & CSS_CSS_ERR_STATUS_flt_err_MASK)

#define CSS_CSS_ERR_STATUS_prng_err_MASK         (0x20U)
#define CSS_CSS_ERR_STATUS_prng_err_SHIFT        (5U)
/*! prng_err - User Read of CSS_PRNG_DATOUT when CSS_STATUS.PRNG_RDY
 */
#define CSS_CSS_ERR_STATUS_prng_err(x)           (((uint32_t)(((uint32_t)(x)) << CSS_CSS_ERR_STATUS_prng_err_SHIFT)) & CSS_CSS_ERR_STATUS_prng_err_MASK)

#define CSS_CSS_ERR_STATUS_err_lvl_MASK          (0xC0U)
#define CSS_CSS_ERR_STATUS_err_lvl_SHIFT         (6U)
/*! err_lvl - Indicates Error Level which has been triggerer. 0, 1 ,2
 */
#define CSS_CSS_ERR_STATUS_err_lvl(x)            (((uint32_t)(((uint32_t)(x)) << CSS_CSS_ERR_STATUS_err_lvl_SHIFT)) & CSS_CSS_ERR_STATUS_err_lvl_MASK)

#define CSS_CSS_ERR_STATUS_dtrng_err_MASK        (0x100U)
#define CSS_CSS_ERR_STATUS_dtrng_err_SHIFT       (8U)
/*! dtrng_err - DTRNG unable to gather entropy with the current
 */
#define CSS_CSS_ERR_STATUS_dtrng_err(x)          (((uint32_t)(((uint32_t)(x)) << CSS_CSS_ERR_STATUS_dtrng_err_SHIFT)) & CSS_CSS_ERR_STATUS_dtrng_err_MASK)

#define CSS_CSS_ERR_STATUS_err_stat_rsvd_MASK    (0xFFFFFE00U)
#define CSS_CSS_ERR_STATUS_err_stat_rsvd_SHIFT   (9U)
/*! err_stat_rsvd - reserved
 */
#define CSS_CSS_ERR_STATUS_err_stat_rsvd(x)      (((uint32_t)(((uint32_t)(x)) << CSS_CSS_ERR_STATUS_err_stat_rsvd_SHIFT)) & CSS_CSS_ERR_STATUS_err_stat_rsvd_MASK)
/*! @} */

/*! @name CSS_ERR_STATUS_CLR - Interrupt status clear */
/*! @{ */

#define CSS_CSS_ERR_STATUS_CLR_err_clr_MASK      (0x1U)
#define CSS_CSS_ERR_STATUS_CLR_err_clr_SHIFT     (0U)
/*! err_clr - 1=clear CSS error status bits and exit CSS error state
 */
#define CSS_CSS_ERR_STATUS_CLR_err_clr(x)        (((uint32_t)(((uint32_t)(x)) << CSS_CSS_ERR_STATUS_CLR_err_clr_SHIFT)) & CSS_CSS_ERR_STATUS_CLR_err_clr_MASK)

#define CSS_CSS_ERR_STATUS_CLR_err_stsc_rsvd_MASK (0xFFFFFFFEU)
#define CSS_CSS_ERR_STATUS_CLR_err_stsc_rsvd_SHIFT (1U)
/*! err_stsc_rsvd - reserved
 */
#define CSS_CSS_ERR_STATUS_CLR_err_stsc_rsvd(x)  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_ERR_STATUS_CLR_err_stsc_rsvd_SHIFT)) & CSS_CSS_ERR_STATUS_CLR_err_stsc_rsvd_MASK)
/*! @} */

/*! @name CSS_VERSION - CSS Version */
/*! @{ */

#define CSS_CSS_VERSION_z_MASK                   (0xFU)
#define CSS_CSS_VERSION_z_SHIFT                  (0U)
/*! z - extended revision version: possible values 0-9
 */
#define CSS_CSS_VERSION_z(x)                     (((uint32_t)(((uint32_t)(x)) << CSS_CSS_VERSION_z_SHIFT)) & CSS_CSS_VERSION_z_MASK)

#define CSS_CSS_VERSION_y2_MASK                  (0xF0U)
#define CSS_CSS_VERSION_y2_SHIFT                 (4U)
/*! y2 - minor release versino digit0: possible values 0-9
 */
#define CSS_CSS_VERSION_y2(x)                    (((uint32_t)(((uint32_t)(x)) << CSS_CSS_VERSION_y2_SHIFT)) & CSS_CSS_VERSION_y2_MASK)

#define CSS_CSS_VERSION_y1_MASK                  (0xF00U)
#define CSS_CSS_VERSION_y1_SHIFT                 (8U)
/*! y1 - minor release version digit1: possible values 0-9
 */
#define CSS_CSS_VERSION_y1(x)                    (((uint32_t)(((uint32_t)(x)) << CSS_CSS_VERSION_y1_SHIFT)) & CSS_CSS_VERSION_y1_MASK)

#define CSS_CSS_VERSION_x_MASK                   (0xF000U)
#define CSS_CSS_VERSION_x_SHIFT                  (12U)
/*! x - major release version: possible values 1-9
 */
#define CSS_CSS_VERSION_x(x)                     (((uint32_t)(((uint32_t)(x)) << CSS_CSS_VERSION_x_SHIFT)) & CSS_CSS_VERSION_x_MASK)

#define CSS_CSS_VERSION_version_rsvd_MASK        (0xFFFF0000U)
#define CSS_CSS_VERSION_version_rsvd_SHIFT       (16U)
/*! version_rsvd - reserved
 */
#define CSS_CSS_VERSION_version_rsvd(x)          (((uint32_t)(((uint32_t)(x)) << CSS_CSS_VERSION_version_rsvd_SHIFT)) & CSS_CSS_VERSION_version_rsvd_MASK)
/*! @} */

/*! @name CSS_PRNG_DATOUT - PRNG SW read out register */
/*! @{ */

#define CSS_CSS_PRNG_DATOUT_prng_datout_MASK     (0xFFFFFFFFU)
#define CSS_CSS_PRNG_DATOUT_prng_datout_SHIFT    (0U)
/*! prng_datout - 32-bit wide pseudo-random number
 */
#define CSS_CSS_PRNG_DATOUT_prng_datout(x)       (((uint32_t)(((uint32_t)(x)) << CSS_CSS_PRNG_DATOUT_prng_datout_SHIFT)) & CSS_CSS_PRNG_DATOUT_prng_datout_MASK)
/*! @} */

/*! @name CSS_GDET_EVTCNT - CSS GDET Event Counter */
/*! @{ */

#define CSS_CSS_GDET_EVTCNT_gdet_evtcnt_MASK     (0xFFU)
#define CSS_CSS_GDET_EVTCNT_gdet_evtcnt_SHIFT    (0U)
/*! gdet_evtcnt - Number of glitch event recorded
 */
#define CSS_CSS_GDET_EVTCNT_gdet_evtcnt(x)       (((uint32_t)(((uint32_t)(x)) << CSS_CSS_GDET_EVTCNT_gdet_evtcnt_SHIFT)) & CSS_CSS_GDET_EVTCNT_gdet_evtcnt_MASK)

#define CSS_CSS_GDET_EVTCNT_gdet_evtcnt_clr_done_MASK (0x100U)
#define CSS_CSS_GDET_EVTCNT_gdet_evtcnt_clr_done_SHIFT (8U)
/*! gdet_evtcnt_clr_done - The GDET event counter has been cleared
 */
#define CSS_CSS_GDET_EVTCNT_gdet_evtcnt_clr_done(x) (((uint32_t)(((uint32_t)(x)) << CSS_CSS_GDET_EVTCNT_gdet_evtcnt_clr_done_SHIFT)) & CSS_CSS_GDET_EVTCNT_gdet_evtcnt_clr_done_MASK)

#define CSS_CSS_GDET_EVTCNT_gdet_evtcnt_rsvd_MASK (0xFFFFFE00U)
#define CSS_CSS_GDET_EVTCNT_gdet_evtcnt_rsvd_SHIFT (9U)
/*! gdet_evtcnt_rsvd - reserved
 */
#define CSS_CSS_GDET_EVTCNT_gdet_evtcnt_rsvd(x)  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_GDET_EVTCNT_gdet_evtcnt_rsvd_SHIFT)) & CSS_CSS_GDET_EVTCNT_gdet_evtcnt_rsvd_MASK)
/*! @} */

/*! @name CSS_GDET_EVTCNT_CLR - CSS GDET Event Counter Clear */
/*! @{ */

#define CSS_CSS_GDET_EVTCNT_CLR_gdet_evtcnt_clr_MASK (0x1U)
#define CSS_CSS_GDET_EVTCNT_CLR_gdet_evtcnt_clr_SHIFT (0U)
/*! gdet_evtcnt_clr - 1=clear GDET event counter clear
 */
#define CSS_CSS_GDET_EVTCNT_CLR_gdet_evtcnt_clr(x) (((uint32_t)(((uint32_t)(x)) << CSS_CSS_GDET_EVTCNT_CLR_gdet_evtcnt_clr_SHIFT)) & CSS_CSS_GDET_EVTCNT_CLR_gdet_evtcnt_clr_MASK)

#define CSS_CSS_GDET_EVTCNT_CLR_gdet_evtcnt_clr_rsvd_MASK (0xFFFFFFFEU)
#define CSS_CSS_GDET_EVTCNT_CLR_gdet_evtcnt_clr_rsvd_SHIFT (1U)
/*! gdet_evtcnt_clr_rsvd - reserved
 */
#define CSS_CSS_GDET_EVTCNT_CLR_gdet_evtcnt_clr_rsvd(x) (((uint32_t)(((uint32_t)(x)) << CSS_CSS_GDET_EVTCNT_CLR_gdet_evtcnt_clr_rsvd_SHIFT)) & CSS_CSS_GDET_EVTCNT_CLR_gdet_evtcnt_clr_rsvd_MASK)
/*! @} */

/*! @name CSS_SHA2_STATUS - CSS SHA2 Status Register */
/*! @{ */

#define CSS_CSS_SHA2_STATUS_sha2_busy_MASK       (0x1U)
#define CSS_CSS_SHA2_STATUS_sha2_busy_SHIFT      (0U)
/*! sha2_busy - SHA2 busy/idle status for sha direct
 */
#define CSS_CSS_SHA2_STATUS_sha2_busy(x)         (((uint32_t)(((uint32_t)(x)) << CSS_CSS_SHA2_STATUS_sha2_busy_SHIFT)) & CSS_CSS_SHA2_STATUS_sha2_busy_MASK)

#define CSS_CSS_SHA2_STATUS_status_rsvd1_MASK    (0xFFFFFFFEU)
#define CSS_CSS_SHA2_STATUS_status_rsvd1_SHIFT   (1U)
/*! status_rsvd1 - reserved
 */
#define CSS_CSS_SHA2_STATUS_status_rsvd1(x)      (((uint32_t)(((uint32_t)(x)) << CSS_CSS_SHA2_STATUS_status_rsvd1_SHIFT)) & CSS_CSS_SHA2_STATUS_status_rsvd1_MASK)
/*! @} */

/*! @name CSS_SHA2_CTRL - SHA2 Control register */
/*! @{ */

#define CSS_CSS_SHA2_CTRL_sha2_start_MASK        (0x1U)
#define CSS_CSS_SHA2_CTRL_sha2_start_SHIFT       (0U)
/*! sha2_start - Write to 1 to Init the SHA2 Module
 */
#define CSS_CSS_SHA2_CTRL_sha2_start(x)          (((uint32_t)(((uint32_t)(x)) << CSS_CSS_SHA2_CTRL_sha2_start_SHIFT)) & CSS_CSS_SHA2_CTRL_sha2_start_MASK)

#define CSS_CSS_SHA2_CTRL_sha2_rst_MASK          (0x2U)
#define CSS_CSS_SHA2_CTRL_sha2_rst_SHIFT         (1U)
/*! sha2_rst - Write to 1 to Reset a SHA2 operation
 */
#define CSS_CSS_SHA2_CTRL_sha2_rst(x)            (((uint32_t)(((uint32_t)(x)) << CSS_CSS_SHA2_CTRL_sha2_rst_SHIFT)) & CSS_CSS_SHA2_CTRL_sha2_rst_MASK)

#define CSS_CSS_SHA2_CTRL_sha2_init_MASK         (0x4U)
#define CSS_CSS_SHA2_CTRL_sha2_init_SHIFT        (2U)
/*! sha2_init - Write to 1 to Init the SHA2 Kernel
 */
#define CSS_CSS_SHA2_CTRL_sha2_init(x)           (((uint32_t)(((uint32_t)(x)) << CSS_CSS_SHA2_CTRL_sha2_init_SHIFT)) & CSS_CSS_SHA2_CTRL_sha2_init_MASK)

#define CSS_CSS_SHA2_CTRL_sha2_load_MASK         (0x8U)
#define CSS_CSS_SHA2_CTRL_sha2_load_SHIFT        (3U)
/*! sha2_load - Write to 1 to Load the SHA2 Kernel
 */
#define CSS_CSS_SHA2_CTRL_sha2_load(x)           (((uint32_t)(((uint32_t)(x)) << CSS_CSS_SHA2_CTRL_sha2_load_SHIFT)) & CSS_CSS_SHA2_CTRL_sha2_load_MASK)

#define CSS_CSS_SHA2_CTRL_sha2_mode_MASK         (0x30U)
#define CSS_CSS_SHA2_CTRL_sha2_mode_SHIFT        (4U)
/*! sha2_mode - SHA2 MODE:
 */
#define CSS_CSS_SHA2_CTRL_sha2_mode(x)           (((uint32_t)(((uint32_t)(x)) << CSS_CSS_SHA2_CTRL_sha2_mode_SHIFT)) & CSS_CSS_SHA2_CTRL_sha2_mode_MASK)

#define CSS_CSS_SHA2_CTRL_ctrl_rsvd1_MASK        (0x1C0U)
#define CSS_CSS_SHA2_CTRL_ctrl_rsvd1_SHIFT       (6U)
/*! ctrl_rsvd1 - r-eserved
 */
#define CSS_CSS_SHA2_CTRL_ctrl_rsvd1(x)          (((uint32_t)(((uint32_t)(x)) << CSS_CSS_SHA2_CTRL_ctrl_rsvd1_SHIFT)) & CSS_CSS_SHA2_CTRL_ctrl_rsvd1_MASK)

#define CSS_CSS_SHA2_CTRL_sha2_byte_order_MASK   (0x200U)
#define CSS_CSS_SHA2_CTRL_sha2_byte_order_SHIFT  (9U)
/*! sha2_byte_order - Write to 1 to Reverse byte endianess
 */
#define CSS_CSS_SHA2_CTRL_sha2_byte_order(x)     (((uint32_t)(((uint32_t)(x)) << CSS_CSS_SHA2_CTRL_sha2_byte_order_SHIFT)) & CSS_CSS_SHA2_CTRL_sha2_byte_order_MASK)

#define CSS_CSS_SHA2_CTRL_ctrl_rsvd_MASK         (0xFFFFFC00U)
#define CSS_CSS_SHA2_CTRL_ctrl_rsvd_SHIFT        (10U)
/*! ctrl_rsvd - r-eserved
 */
#define CSS_CSS_SHA2_CTRL_ctrl_rsvd(x)           (((uint32_t)(((uint32_t)(x)) << CSS_CSS_SHA2_CTRL_ctrl_rsvd_SHIFT)) & CSS_CSS_SHA2_CTRL_ctrl_rsvd_MASK)
/*! @} */

/*! @name CSS_SHA2_DIN - CSS SHA_DATA IN Register 0 */
/*! @{ */

#define CSS_CSS_SHA2_DIN_sha_datin_MASK          (0xFFFFFFFFU)
#define CSS_CSS_SHA2_DIN_sha_datin_SHIFT         (0U)
/*! sha_datin - Output CSS_SHA_DATIN from CSS Application being executed
 */
#define CSS_CSS_SHA2_DIN_sha_datin(x)            (((uint32_t)(((uint32_t)(x)) << CSS_CSS_SHA2_DIN_sha_datin_SHIFT)) & CSS_CSS_SHA2_DIN_sha_datin_MASK)
/*! @} */

/*! @name CSS_SHA2_DOUT0 - CSS CSS_SHA_DATA Out Register 0 */
/*! @{ */

#define CSS_CSS_SHA2_DOUT0_sha_data0_MASK        (0xFFFFFFFFU)
#define CSS_CSS_SHA2_DOUT0_sha_data0_SHIFT       (0U)
/*! sha_data0 - Output SHA_DATA from CSS Application being executed
 */
#define CSS_CSS_SHA2_DOUT0_sha_data0(x)          (((uint32_t)(((uint32_t)(x)) << CSS_CSS_SHA2_DOUT0_sha_data0_SHIFT)) & CSS_CSS_SHA2_DOUT0_sha_data0_MASK)
/*! @} */

/*! @name CSS_SHA2_DOUT1 - CSS SHA_DATA Out Register 1 */
/*! @{ */

#define CSS_CSS_SHA2_DOUT1_sha_data1_MASK        (0xFFFFFFFFU)
#define CSS_CSS_SHA2_DOUT1_sha_data1_SHIFT       (0U)
/*! sha_data1 - Output SHA_DATA from CSS Application being executed
 */
#define CSS_CSS_SHA2_DOUT1_sha_data1(x)          (((uint32_t)(((uint32_t)(x)) << CSS_CSS_SHA2_DOUT1_sha_data1_SHIFT)) & CSS_CSS_SHA2_DOUT1_sha_data1_MASK)
/*! @} */

/*! @name CSS_SHA2_DOUT2 - CSS SHA_DATA Out Register 2 */
/*! @{ */

#define CSS_CSS_SHA2_DOUT2_sha_data2_MASK        (0xFFFFFFFFU)
#define CSS_CSS_SHA2_DOUT2_sha_data2_SHIFT       (0U)
/*! sha_data2 - Output SHA_DATA from CSS Application being executed
 */
#define CSS_CSS_SHA2_DOUT2_sha_data2(x)          (((uint32_t)(((uint32_t)(x)) << CSS_CSS_SHA2_DOUT2_sha_data2_SHIFT)) & CSS_CSS_SHA2_DOUT2_sha_data2_MASK)
/*! @} */

/*! @name CSS_SHA2_DOUT3 - CSS SHA_DATA Out Register 3 */
/*! @{ */

#define CSS_CSS_SHA2_DOUT3_sha_data3_MASK        (0xFFFFFFFFU)
#define CSS_CSS_SHA2_DOUT3_sha_data3_SHIFT       (0U)
/*! sha_data3 - Output SHA_DATA from CSS Application being executed
 */
#define CSS_CSS_SHA2_DOUT3_sha_data3(x)          (((uint32_t)(((uint32_t)(x)) << CSS_CSS_SHA2_DOUT3_sha_data3_SHIFT)) & CSS_CSS_SHA2_DOUT3_sha_data3_MASK)
/*! @} */

/*! @name CSS_SHA2_DOUT4 - CSS SHA_DATA Out Register 4 */
/*! @{ */

#define CSS_CSS_SHA2_DOUT4_sha_data4_MASK        (0xFFFFFFFFU)
#define CSS_CSS_SHA2_DOUT4_sha_data4_SHIFT       (0U)
/*! sha_data4 - Output SHA_DATA from CSS Application being executed
 */
#define CSS_CSS_SHA2_DOUT4_sha_data4(x)          (((uint32_t)(((uint32_t)(x)) << CSS_CSS_SHA2_DOUT4_sha_data4_SHIFT)) & CSS_CSS_SHA2_DOUT4_sha_data4_MASK)
/*! @} */

/*! @name CSS_SHA2_DOUT5 - CSS SHA_DATA Out Register 5 */
/*! @{ */

#define CSS_CSS_SHA2_DOUT5_sha_data5_MASK        (0xFFFFFFFFU)
#define CSS_CSS_SHA2_DOUT5_sha_data5_SHIFT       (0U)
/*! sha_data5 - Output SHA_DATA from CSS Application being executed
 */
#define CSS_CSS_SHA2_DOUT5_sha_data5(x)          (((uint32_t)(((uint32_t)(x)) << CSS_CSS_SHA2_DOUT5_sha_data5_SHIFT)) & CSS_CSS_SHA2_DOUT5_sha_data5_MASK)
/*! @} */

/*! @name CSS_SHA2_DOUT6 - CSS SHA_DATA Out Register 6 */
/*! @{ */

#define CSS_CSS_SHA2_DOUT6_sha_data6_MASK        (0xFFFFFFFFU)
#define CSS_CSS_SHA2_DOUT6_sha_data6_SHIFT       (0U)
/*! sha_data6 - Output SHA_DATA from CSS Application being executed
 */
#define CSS_CSS_SHA2_DOUT6_sha_data6(x)          (((uint32_t)(((uint32_t)(x)) << CSS_CSS_SHA2_DOUT6_sha_data6_SHIFT)) & CSS_CSS_SHA2_DOUT6_sha_data6_MASK)
/*! @} */

/*! @name CSS_SHA2_DOUT7 - CSS SHA_DATA Out Register 7 */
/*! @{ */

#define CSS_CSS_SHA2_DOUT7_sha_data7_MASK        (0xFFFFFFFFU)
#define CSS_CSS_SHA2_DOUT7_sha_data7_SHIFT       (0U)
/*! sha_data7 - Output SHA_DATA from CSS Application being executed
 */
#define CSS_CSS_SHA2_DOUT7_sha_data7(x)          (((uint32_t)(((uint32_t)(x)) << CSS_CSS_SHA2_DOUT7_sha_data7_SHIFT)) & CSS_CSS_SHA2_DOUT7_sha_data7_MASK)
/*! @} */

/*! @name CSS_SHA2_DOUT8 - CSS CSS_SHA_DATA Out Register 8 */
/*! @{ */

#define CSS_CSS_SHA2_DOUT8_sha_data8_MASK        (0xFFFFFFFFU)
#define CSS_CSS_SHA2_DOUT8_sha_data8_SHIFT       (0U)
/*! sha_data8 - Output SHA_DATA from CSS Application being executed
 */
#define CSS_CSS_SHA2_DOUT8_sha_data8(x)          (((uint32_t)(((uint32_t)(x)) << CSS_CSS_SHA2_DOUT8_sha_data8_SHIFT)) & CSS_CSS_SHA2_DOUT8_sha_data8_MASK)
/*! @} */

/*! @name CSS_SHA2_DOUT9 - CSS SHA_DATA Out Register 9 */
/*! @{ */

#define CSS_CSS_SHA2_DOUT9_sha_data9_MASK        (0xFFFFFFFFU)
#define CSS_CSS_SHA2_DOUT9_sha_data9_SHIFT       (0U)
/*! sha_data9 - Output SHA_DATA from CSS Application being executed
 */
#define CSS_CSS_SHA2_DOUT9_sha_data9(x)          (((uint32_t)(((uint32_t)(x)) << CSS_CSS_SHA2_DOUT9_sha_data9_SHIFT)) & CSS_CSS_SHA2_DOUT9_sha_data9_MASK)
/*! @} */

/*! @name CSS_SHA2_DOUT10 - CSS SHA_DATA Out Register 10 */
/*! @{ */

#define CSS_CSS_SHA2_DOUT10_sha_data10_MASK      (0xFFFFFFFFU)
#define CSS_CSS_SHA2_DOUT10_sha_data10_SHIFT     (0U)
/*! sha_data10 - Output SHA_DATA from CSS Application being executed
 */
#define CSS_CSS_SHA2_DOUT10_sha_data10(x)        (((uint32_t)(((uint32_t)(x)) << CSS_CSS_SHA2_DOUT10_sha_data10_SHIFT)) & CSS_CSS_SHA2_DOUT10_sha_data10_MASK)
/*! @} */

/*! @name CSS_SHA2_DOUT11 - CSS SHA_DATA Out Register 11 */
/*! @{ */

#define CSS_CSS_SHA2_DOUT11_sha_data11_MASK      (0xFFFFFFFFU)
#define CSS_CSS_SHA2_DOUT11_sha_data11_SHIFT     (0U)
/*! sha_data11 - Output SHA_DATA from CSS Application being executed
 */
#define CSS_CSS_SHA2_DOUT11_sha_data11(x)        (((uint32_t)(((uint32_t)(x)) << CSS_CSS_SHA2_DOUT11_sha_data11_SHIFT)) & CSS_CSS_SHA2_DOUT11_sha_data11_MASK)
/*! @} */

/*! @name CSS_SHA2_DOUT12 - CSS SHA_DATA Out Register 12 */
/*! @{ */

#define CSS_CSS_SHA2_DOUT12_sha_data12_MASK      (0xFFFFFFFFU)
#define CSS_CSS_SHA2_DOUT12_sha_data12_SHIFT     (0U)
/*! sha_data12 - Output SHA_DATA from CSS Application being executed
 */
#define CSS_CSS_SHA2_DOUT12_sha_data12(x)        (((uint32_t)(((uint32_t)(x)) << CSS_CSS_SHA2_DOUT12_sha_data12_SHIFT)) & CSS_CSS_SHA2_DOUT12_sha_data12_MASK)
/*! @} */

/*! @name CSS_SHA2_DOUT13 - CSS SHA_DATA Out Register 13 */
/*! @{ */

#define CSS_CSS_SHA2_DOUT13_sha_data13_MASK      (0xFFFFFFFFU)
#define CSS_CSS_SHA2_DOUT13_sha_data13_SHIFT     (0U)
/*! sha_data13 - Output SHA_DATA from CSS Application being executed
 */
#define CSS_CSS_SHA2_DOUT13_sha_data13(x)        (((uint32_t)(((uint32_t)(x)) << CSS_CSS_SHA2_DOUT13_sha_data13_SHIFT)) & CSS_CSS_SHA2_DOUT13_sha_data13_MASK)
/*! @} */

/*! @name CSS_SHA2_DOUT14 - CSS SHA_DATA Out Register 14 */
/*! @{ */

#define CSS_CSS_SHA2_DOUT14_sha_data14_MASK      (0xFFFFFFFFU)
#define CSS_CSS_SHA2_DOUT14_sha_data14_SHIFT     (0U)
/*! sha_data14 - Output SHA_DATA from CSS Application being executed
 */
#define CSS_CSS_SHA2_DOUT14_sha_data14(x)        (((uint32_t)(((uint32_t)(x)) << CSS_CSS_SHA2_DOUT14_sha_data14_SHIFT)) & CSS_CSS_SHA2_DOUT14_sha_data14_MASK)
/*! @} */

/*! @name CSS_SHA2_DOUT15 - CSS SHA_DATA Out Register 15 */
/*! @{ */

#define CSS_CSS_SHA2_DOUT15_sha_data15_MASK      (0xFFFFFFFFU)
#define CSS_CSS_SHA2_DOUT15_sha_data15_SHIFT     (0U)
/*! sha_data15 - Output SHA_DATA from CSS Application being executed
 */
#define CSS_CSS_SHA2_DOUT15_sha_data15(x)        (((uint32_t)(((uint32_t)(x)) << CSS_CSS_SHA2_DOUT15_sha_data15_SHIFT)) & CSS_CSS_SHA2_DOUT15_sha_data15_MASK)
/*! @} */

/*! @name CSS_KS0 - Status register */
/*! @{ */

#define CSS_CSS_KS0_ks0_ksize_MASK               (0x1U)
#define CSS_CSS_KS0_ks0_ksize_SHIFT              (0U)
/*! ks0_ksize - Key size: 0-128, 1-256
 */
#define CSS_CSS_KS0_ks0_ksize(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS0_ks0_ksize_SHIFT)) & CSS_CSS_KS0_ks0_ksize_MASK)

#define CSS_CSS_KS0_ks0_rsvd0_MASK               (0x1EU)
#define CSS_CSS_KS0_ks0_rsvd0_SHIFT              (1U)
/*! ks0_rsvd0 - Reserved 0
 */
#define CSS_CSS_KS0_ks0_rsvd0(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS0_ks0_rsvd0_SHIFT)) & CSS_CSS_KS0_ks0_rsvd0_MASK)

#define CSS_CSS_KS0_ks0_kact_MASK                (0x20U)
#define CSS_CSS_KS0_ks0_kact_SHIFT               (5U)
/*! ks0_kact - Key is active
 */
#define CSS_CSS_KS0_ks0_kact(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS0_ks0_kact_SHIFT)) & CSS_CSS_KS0_ks0_kact_MASK)

#define CSS_CSS_KS0_ks0_kbase_MASK               (0x40U)
#define CSS_CSS_KS0_ks0_kbase_SHIFT              (6U)
/*! ks0_kbase - First slot in a multislot key
 */
#define CSS_CSS_KS0_ks0_kbase(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS0_ks0_kbase_SHIFT)) & CSS_CSS_KS0_ks0_kbase_MASK)

#define CSS_CSS_KS0_ks0_fgp_MASK                 (0x80U)
#define CSS_CSS_KS0_ks0_fgp_SHIFT                (7U)
/*! ks0_fgp - Hardware Feature General Purpose
 */
#define CSS_CSS_KS0_ks0_fgp(x)                   (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS0_ks0_fgp_SHIFT)) & CSS_CSS_KS0_ks0_fgp_MASK)

#define CSS_CSS_KS0_ks0_frtn_MASK                (0x100U)
#define CSS_CSS_KS0_ks0_frtn_SHIFT               (8U)
/*! ks0_frtn - Hardware Feature Retention
 */
#define CSS_CSS_KS0_ks0_frtn(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS0_ks0_frtn_SHIFT)) & CSS_CSS_KS0_ks0_frtn_MASK)

#define CSS_CSS_KS0_ks0_fhwo_MASK                (0x200U)
#define CSS_CSS_KS0_ks0_fhwo_SHIFT               (9U)
/*! ks0_fhwo - Hardware Feature Output
 */
#define CSS_CSS_KS0_ks0_fhwo(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS0_ks0_fhwo_SHIFT)) & CSS_CSS_KS0_ks0_fhwo_MASK)

#define CSS_CSS_KS0_ks0_rsvd1_MASK               (0x1C00U)
#define CSS_CSS_KS0_ks0_rsvd1_SHIFT              (10U)
/*! ks0_rsvd1 - Reserved 1
 */
#define CSS_CSS_KS0_ks0_rsvd1(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS0_ks0_rsvd1_SHIFT)) & CSS_CSS_KS0_ks0_rsvd1_MASK)

#define CSS_CSS_KS0_ks0_ucmac_MASK               (0x2000U)
#define CSS_CSS_KS0_ks0_ucmac_SHIFT              (13U)
/*! ks0_ucmac - CMAC key
 */
#define CSS_CSS_KS0_ks0_ucmac(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS0_ks0_ucmac_SHIFT)) & CSS_CSS_KS0_ks0_ucmac_MASK)

#define CSS_CSS_KS0_ks0_uksk_MASK                (0x4000U)
#define CSS_CSS_KS0_ks0_uksk_SHIFT               (14U)
/*! ks0_uksk - KSK key
 */
#define CSS_CSS_KS0_ks0_uksk(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS0_ks0_uksk_SHIFT)) & CSS_CSS_KS0_ks0_uksk_MASK)

#define CSS_CSS_KS0_ks0_urtf_MASK                (0x8000U)
#define CSS_CSS_KS0_ks0_urtf_SHIFT               (15U)
/*! ks0_urtf - Real Time Fingerprint key
 */
#define CSS_CSS_KS0_ks0_urtf(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS0_ks0_urtf_SHIFT)) & CSS_CSS_KS0_ks0_urtf_MASK)

#define CSS_CSS_KS0_ks0_uckdf_MASK               (0x10000U)
#define CSS_CSS_KS0_ks0_uckdf_SHIFT              (16U)
/*! ks0_uckdf - Derivation key for CKDF command
 */
#define CSS_CSS_KS0_ks0_uckdf(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS0_ks0_uckdf_SHIFT)) & CSS_CSS_KS0_ks0_uckdf_MASK)

#define CSS_CSS_KS0_ks0_uhkdf_MASK               (0x20000U)
#define CSS_CSS_KS0_ks0_uhkdf_SHIFT              (17U)
/*! ks0_uhkdf - Derivation key for HKDF command
 */
#define CSS_CSS_KS0_ks0_uhkdf(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS0_ks0_uhkdf_SHIFT)) & CSS_CSS_KS0_ks0_uhkdf_MASK)

#define CSS_CSS_KS0_ks0_uecsg_MASK               (0x40000U)
#define CSS_CSS_KS0_ks0_uecsg_SHIFT              (18U)
/*! ks0_uecsg - Ecc signing key
 */
#define CSS_CSS_KS0_ks0_uecsg(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS0_ks0_uecsg_SHIFT)) & CSS_CSS_KS0_ks0_uecsg_MASK)

#define CSS_CSS_KS0_ks0_uecdh_MASK               (0x80000U)
#define CSS_CSS_KS0_ks0_uecdh_SHIFT              (19U)
/*! ks0_uecdh - Ecc diffie hellman key
 */
#define CSS_CSS_KS0_ks0_uecdh(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS0_ks0_uecdh_SHIFT)) & CSS_CSS_KS0_ks0_uecdh_MASK)

#define CSS_CSS_KS0_ks0_uaes_MASK                (0x100000U)
#define CSS_CSS_KS0_ks0_uaes_SHIFT               (20U)
/*! ks0_uaes - Aes key
 */
#define CSS_CSS_KS0_ks0_uaes(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS0_ks0_uaes_SHIFT)) & CSS_CSS_KS0_ks0_uaes_MASK)

#define CSS_CSS_KS0_ks0_uhmac_MASK               (0x200000U)
#define CSS_CSS_KS0_ks0_uhmac_SHIFT              (21U)
/*! ks0_uhmac - Hmac key
 */
#define CSS_CSS_KS0_ks0_uhmac(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS0_ks0_uhmac_SHIFT)) & CSS_CSS_KS0_ks0_uhmac_MASK)

#define CSS_CSS_KS0_ks0_ukwk_MASK                (0x400000U)
#define CSS_CSS_KS0_ks0_ukwk_SHIFT               (22U)
/*! ks0_ukwk - Key wrapping key
 */
#define CSS_CSS_KS0_ks0_ukwk(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS0_ks0_ukwk_SHIFT)) & CSS_CSS_KS0_ks0_ukwk_MASK)

#define CSS_CSS_KS0_ks0_ukuok_MASK               (0x800000U)
#define CSS_CSS_KS0_ks0_ukuok_SHIFT              (23U)
/*! ks0_ukuok - Key unwrapping key
 */
#define CSS_CSS_KS0_ks0_ukuok(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS0_ks0_ukuok_SHIFT)) & CSS_CSS_KS0_ks0_ukuok_MASK)

#define CSS_CSS_KS0_ks0_utlspms_MASK             (0x1000000U)
#define CSS_CSS_KS0_ks0_utlspms_SHIFT            (24U)
/*! ks0_utlspms - TLS Pre Master Secret
 */
#define CSS_CSS_KS0_ks0_utlspms(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS0_ks0_utlspms_SHIFT)) & CSS_CSS_KS0_ks0_utlspms_MASK)

#define CSS_CSS_KS0_ks0_utlsms_MASK              (0x2000000U)
#define CSS_CSS_KS0_ks0_utlsms_SHIFT             (25U)
/*! ks0_utlsms - TLS Master Secret
 */
#define CSS_CSS_KS0_ks0_utlsms(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS0_ks0_utlsms_SHIFT)) & CSS_CSS_KS0_ks0_utlsms_MASK)

#define CSS_CSS_KS0_ks0_ukgsrc_MASK              (0x4000000U)
#define CSS_CSS_KS0_ks0_ukgsrc_SHIFT             (26U)
/*! ks0_ukgsrc - Supply KEYGEN source
 */
#define CSS_CSS_KS0_ks0_ukgsrc(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS0_ks0_ukgsrc_SHIFT)) & CSS_CSS_KS0_ks0_ukgsrc_MASK)

#define CSS_CSS_KS0_ks0_uhwo_MASK                (0x8000000U)
#define CSS_CSS_KS0_ks0_uhwo_SHIFT               (27U)
/*! ks0_uhwo - Hardware out key
 */
#define CSS_CSS_KS0_ks0_uhwo(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS0_ks0_uhwo_SHIFT)) & CSS_CSS_KS0_ks0_uhwo_MASK)

#define CSS_CSS_KS0_ks0_uwrpok_MASK              (0x10000000U)
#define CSS_CSS_KS0_ks0_uwrpok_SHIFT             (28U)
/*! ks0_uwrpok - Ok to wrap key
 */
#define CSS_CSS_KS0_ks0_uwrpok(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS0_ks0_uwrpok_SHIFT)) & CSS_CSS_KS0_ks0_uwrpok_MASK)

#define CSS_CSS_KS0_ks0_uduk_MASK                (0x20000000U)
#define CSS_CSS_KS0_ks0_uduk_SHIFT               (29U)
/*! ks0_uduk - Device Unique Key
 */
#define CSS_CSS_KS0_ks0_uduk(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS0_ks0_uduk_SHIFT)) & CSS_CSS_KS0_ks0_uduk_MASK)

#define CSS_CSS_KS0_ks0_upprot_MASK              (0xC0000000U)
#define CSS_CSS_KS0_ks0_upprot_SHIFT             (30U)
/*! ks0_upprot - Priviledge level
 */
#define CSS_CSS_KS0_ks0_upprot(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS0_ks0_upprot_SHIFT)) & CSS_CSS_KS0_ks0_upprot_MASK)
/*! @} */

/*! @name CSS_KS1 - Status register */
/*! @{ */

#define CSS_CSS_KS1_ks1_ksize_MASK               (0x1U)
#define CSS_CSS_KS1_ks1_ksize_SHIFT              (0U)
/*! ks1_ksize - Key size: 0-128, 1-256
 */
#define CSS_CSS_KS1_ks1_ksize(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS1_ks1_ksize_SHIFT)) & CSS_CSS_KS1_ks1_ksize_MASK)

#define CSS_CSS_KS1_ks1_rsvd0_MASK               (0x1EU)
#define CSS_CSS_KS1_ks1_rsvd0_SHIFT              (1U)
/*! ks1_rsvd0 - Reserved 0
 */
#define CSS_CSS_KS1_ks1_rsvd0(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS1_ks1_rsvd0_SHIFT)) & CSS_CSS_KS1_ks1_rsvd0_MASK)

#define CSS_CSS_KS1_ks1_kact_MASK                (0x20U)
#define CSS_CSS_KS1_ks1_kact_SHIFT               (5U)
/*! ks1_kact - Key is active
 */
#define CSS_CSS_KS1_ks1_kact(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS1_ks1_kact_SHIFT)) & CSS_CSS_KS1_ks1_kact_MASK)

#define CSS_CSS_KS1_ks1_kbase_MASK               (0x40U)
#define CSS_CSS_KS1_ks1_kbase_SHIFT              (6U)
/*! ks1_kbase - First slot in a multislot key
 */
#define CSS_CSS_KS1_ks1_kbase(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS1_ks1_kbase_SHIFT)) & CSS_CSS_KS1_ks1_kbase_MASK)

#define CSS_CSS_KS1_ks1_fgp_MASK                 (0x80U)
#define CSS_CSS_KS1_ks1_fgp_SHIFT                (7U)
/*! ks1_fgp - Hardware Feature General Purpose
 */
#define CSS_CSS_KS1_ks1_fgp(x)                   (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS1_ks1_fgp_SHIFT)) & CSS_CSS_KS1_ks1_fgp_MASK)

#define CSS_CSS_KS1_ks1_frtn_MASK                (0x100U)
#define CSS_CSS_KS1_ks1_frtn_SHIFT               (8U)
/*! ks1_frtn - Hardware Feature Retention
 */
#define CSS_CSS_KS1_ks1_frtn(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS1_ks1_frtn_SHIFT)) & CSS_CSS_KS1_ks1_frtn_MASK)

#define CSS_CSS_KS1_ks1_fhwo_MASK                (0x200U)
#define CSS_CSS_KS1_ks1_fhwo_SHIFT               (9U)
/*! ks1_fhwo - Hardware Feature Output
 */
#define CSS_CSS_KS1_ks1_fhwo(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS1_ks1_fhwo_SHIFT)) & CSS_CSS_KS1_ks1_fhwo_MASK)

#define CSS_CSS_KS1_ks1_rsvd1_MASK               (0x1C00U)
#define CSS_CSS_KS1_ks1_rsvd1_SHIFT              (10U)
/*! ks1_rsvd1 - Reserved 1
 */
#define CSS_CSS_KS1_ks1_rsvd1(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS1_ks1_rsvd1_SHIFT)) & CSS_CSS_KS1_ks1_rsvd1_MASK)

#define CSS_CSS_KS1_ks1_ucmac_MASK               (0x2000U)
#define CSS_CSS_KS1_ks1_ucmac_SHIFT              (13U)
/*! ks1_ucmac - CMAC key
 */
#define CSS_CSS_KS1_ks1_ucmac(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS1_ks1_ucmac_SHIFT)) & CSS_CSS_KS1_ks1_ucmac_MASK)

#define CSS_CSS_KS1_ks1_uksk_MASK                (0x4000U)
#define CSS_CSS_KS1_ks1_uksk_SHIFT               (14U)
/*! ks1_uksk - KSK key
 */
#define CSS_CSS_KS1_ks1_uksk(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS1_ks1_uksk_SHIFT)) & CSS_CSS_KS1_ks1_uksk_MASK)

#define CSS_CSS_KS1_ks1_urtf_MASK                (0x8000U)
#define CSS_CSS_KS1_ks1_urtf_SHIFT               (15U)
/*! ks1_urtf - Real Time Fingerprint key
 */
#define CSS_CSS_KS1_ks1_urtf(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS1_ks1_urtf_SHIFT)) & CSS_CSS_KS1_ks1_urtf_MASK)

#define CSS_CSS_KS1_ks1_uckdf_MASK               (0x10000U)
#define CSS_CSS_KS1_ks1_uckdf_SHIFT              (16U)
/*! ks1_uckdf - Derivation key for CKDF command
 */
#define CSS_CSS_KS1_ks1_uckdf(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS1_ks1_uckdf_SHIFT)) & CSS_CSS_KS1_ks1_uckdf_MASK)

#define CSS_CSS_KS1_ks1_uhkdf_MASK               (0x20000U)
#define CSS_CSS_KS1_ks1_uhkdf_SHIFT              (17U)
/*! ks1_uhkdf - Derivation key for HKDF command
 */
#define CSS_CSS_KS1_ks1_uhkdf(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS1_ks1_uhkdf_SHIFT)) & CSS_CSS_KS1_ks1_uhkdf_MASK)

#define CSS_CSS_KS1_ks1_uecsg_MASK               (0x40000U)
#define CSS_CSS_KS1_ks1_uecsg_SHIFT              (18U)
/*! ks1_uecsg - Ecc signing key
 */
#define CSS_CSS_KS1_ks1_uecsg(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS1_ks1_uecsg_SHIFT)) & CSS_CSS_KS1_ks1_uecsg_MASK)

#define CSS_CSS_KS1_ks1_uecdh_MASK               (0x80000U)
#define CSS_CSS_KS1_ks1_uecdh_SHIFT              (19U)
/*! ks1_uecdh - Ecc diffie hellman key
 */
#define CSS_CSS_KS1_ks1_uecdh(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS1_ks1_uecdh_SHIFT)) & CSS_CSS_KS1_ks1_uecdh_MASK)

#define CSS_CSS_KS1_ks1_uaes_MASK                (0x100000U)
#define CSS_CSS_KS1_ks1_uaes_SHIFT               (20U)
/*! ks1_uaes - Aes key
 */
#define CSS_CSS_KS1_ks1_uaes(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS1_ks1_uaes_SHIFT)) & CSS_CSS_KS1_ks1_uaes_MASK)

#define CSS_CSS_KS1_ks1_uhmac_MASK               (0x200000U)
#define CSS_CSS_KS1_ks1_uhmac_SHIFT              (21U)
/*! ks1_uhmac - Hmac key
 */
#define CSS_CSS_KS1_ks1_uhmac(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS1_ks1_uhmac_SHIFT)) & CSS_CSS_KS1_ks1_uhmac_MASK)

#define CSS_CSS_KS1_ks1_ukwk_MASK                (0x400000U)
#define CSS_CSS_KS1_ks1_ukwk_SHIFT               (22U)
/*! ks1_ukwk - Key wrapping key
 */
#define CSS_CSS_KS1_ks1_ukwk(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS1_ks1_ukwk_SHIFT)) & CSS_CSS_KS1_ks1_ukwk_MASK)

#define CSS_CSS_KS1_ks1_ukuok_MASK               (0x800000U)
#define CSS_CSS_KS1_ks1_ukuok_SHIFT              (23U)
/*! ks1_ukuok - Key unwrapping key
 */
#define CSS_CSS_KS1_ks1_ukuok(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS1_ks1_ukuok_SHIFT)) & CSS_CSS_KS1_ks1_ukuok_MASK)

#define CSS_CSS_KS1_ks1_utlspms_MASK             (0x1000000U)
#define CSS_CSS_KS1_ks1_utlspms_SHIFT            (24U)
/*! ks1_utlspms - TLS Pre Master Secret
 */
#define CSS_CSS_KS1_ks1_utlspms(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS1_ks1_utlspms_SHIFT)) & CSS_CSS_KS1_ks1_utlspms_MASK)

#define CSS_CSS_KS1_ks1_utlsms_MASK              (0x2000000U)
#define CSS_CSS_KS1_ks1_utlsms_SHIFT             (25U)
/*! ks1_utlsms - TLS Master Secret
 */
#define CSS_CSS_KS1_ks1_utlsms(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS1_ks1_utlsms_SHIFT)) & CSS_CSS_KS1_ks1_utlsms_MASK)

#define CSS_CSS_KS1_ks1_ukgsrc_MASK              (0x4000000U)
#define CSS_CSS_KS1_ks1_ukgsrc_SHIFT             (26U)
/*! ks1_ukgsrc - Supply KEYGEN source
 */
#define CSS_CSS_KS1_ks1_ukgsrc(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS1_ks1_ukgsrc_SHIFT)) & CSS_CSS_KS1_ks1_ukgsrc_MASK)

#define CSS_CSS_KS1_ks1_uhwo_MASK                (0x8000000U)
#define CSS_CSS_KS1_ks1_uhwo_SHIFT               (27U)
/*! ks1_uhwo - Hardware out key
 */
#define CSS_CSS_KS1_ks1_uhwo(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS1_ks1_uhwo_SHIFT)) & CSS_CSS_KS1_ks1_uhwo_MASK)

#define CSS_CSS_KS1_ks1_uwrpok_MASK              (0x10000000U)
#define CSS_CSS_KS1_ks1_uwrpok_SHIFT             (28U)
/*! ks1_uwrpok - Ok to wrap key
 */
#define CSS_CSS_KS1_ks1_uwrpok(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS1_ks1_uwrpok_SHIFT)) & CSS_CSS_KS1_ks1_uwrpok_MASK)

#define CSS_CSS_KS1_ks1_uduk_MASK                (0x20000000U)
#define CSS_CSS_KS1_ks1_uduk_SHIFT               (29U)
/*! ks1_uduk - Device Unique Key
 */
#define CSS_CSS_KS1_ks1_uduk(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS1_ks1_uduk_SHIFT)) & CSS_CSS_KS1_ks1_uduk_MASK)

#define CSS_CSS_KS1_ks1_upprot_MASK              (0xC0000000U)
#define CSS_CSS_KS1_ks1_upprot_SHIFT             (30U)
/*! ks1_upprot - Priviledge level
 */
#define CSS_CSS_KS1_ks1_upprot(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS1_ks1_upprot_SHIFT)) & CSS_CSS_KS1_ks1_upprot_MASK)
/*! @} */

/*! @name CSS_KS2 - Status register */
/*! @{ */

#define CSS_CSS_KS2_ks2_ksize_MASK               (0x1U)
#define CSS_CSS_KS2_ks2_ksize_SHIFT              (0U)
/*! ks2_ksize - Key size: 0-128, 1-256
 */
#define CSS_CSS_KS2_ks2_ksize(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS2_ks2_ksize_SHIFT)) & CSS_CSS_KS2_ks2_ksize_MASK)

#define CSS_CSS_KS2_ks2_rsvd0_MASK               (0x1EU)
#define CSS_CSS_KS2_ks2_rsvd0_SHIFT              (1U)
/*! ks2_rsvd0 - Reserved 0
 */
#define CSS_CSS_KS2_ks2_rsvd0(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS2_ks2_rsvd0_SHIFT)) & CSS_CSS_KS2_ks2_rsvd0_MASK)

#define CSS_CSS_KS2_ks2_kact_MASK                (0x20U)
#define CSS_CSS_KS2_ks2_kact_SHIFT               (5U)
/*! ks2_kact - Key is active
 */
#define CSS_CSS_KS2_ks2_kact(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS2_ks2_kact_SHIFT)) & CSS_CSS_KS2_ks2_kact_MASK)

#define CSS_CSS_KS2_ks2_kbase_MASK               (0x40U)
#define CSS_CSS_KS2_ks2_kbase_SHIFT              (6U)
/*! ks2_kbase - First slot in a multislot key
 */
#define CSS_CSS_KS2_ks2_kbase(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS2_ks2_kbase_SHIFT)) & CSS_CSS_KS2_ks2_kbase_MASK)

#define CSS_CSS_KS2_ks2_fgp_MASK                 (0x80U)
#define CSS_CSS_KS2_ks2_fgp_SHIFT                (7U)
/*! ks2_fgp - Hardware Feature General Purpose
 */
#define CSS_CSS_KS2_ks2_fgp(x)                   (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS2_ks2_fgp_SHIFT)) & CSS_CSS_KS2_ks2_fgp_MASK)

#define CSS_CSS_KS2_ks2_frtn_MASK                (0x100U)
#define CSS_CSS_KS2_ks2_frtn_SHIFT               (8U)
/*! ks2_frtn - Hardware Feature Retention
 */
#define CSS_CSS_KS2_ks2_frtn(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS2_ks2_frtn_SHIFT)) & CSS_CSS_KS2_ks2_frtn_MASK)

#define CSS_CSS_KS2_ks2_fhwo_MASK                (0x200U)
#define CSS_CSS_KS2_ks2_fhwo_SHIFT               (9U)
/*! ks2_fhwo - Hardware Feature Output
 */
#define CSS_CSS_KS2_ks2_fhwo(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS2_ks2_fhwo_SHIFT)) & CSS_CSS_KS2_ks2_fhwo_MASK)

#define CSS_CSS_KS2_ks2_rsvd1_MASK               (0x1C00U)
#define CSS_CSS_KS2_ks2_rsvd1_SHIFT              (10U)
/*! ks2_rsvd1 - Reserved 1
 */
#define CSS_CSS_KS2_ks2_rsvd1(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS2_ks2_rsvd1_SHIFT)) & CSS_CSS_KS2_ks2_rsvd1_MASK)

#define CSS_CSS_KS2_ks2_ucmac_MASK               (0x2000U)
#define CSS_CSS_KS2_ks2_ucmac_SHIFT              (13U)
/*! ks2_ucmac - CMAC key
 */
#define CSS_CSS_KS2_ks2_ucmac(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS2_ks2_ucmac_SHIFT)) & CSS_CSS_KS2_ks2_ucmac_MASK)

#define CSS_CSS_KS2_ks2_uksk_MASK                (0x4000U)
#define CSS_CSS_KS2_ks2_uksk_SHIFT               (14U)
/*! ks2_uksk - KSK key
 */
#define CSS_CSS_KS2_ks2_uksk(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS2_ks2_uksk_SHIFT)) & CSS_CSS_KS2_ks2_uksk_MASK)

#define CSS_CSS_KS2_ks2_urtf_MASK                (0x8000U)
#define CSS_CSS_KS2_ks2_urtf_SHIFT               (15U)
/*! ks2_urtf - Real Time Fingerprint key
 */
#define CSS_CSS_KS2_ks2_urtf(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS2_ks2_urtf_SHIFT)) & CSS_CSS_KS2_ks2_urtf_MASK)

#define CSS_CSS_KS2_ks2_uckdf_MASK               (0x10000U)
#define CSS_CSS_KS2_ks2_uckdf_SHIFT              (16U)
/*! ks2_uckdf - Derivation key for CKDF command
 */
#define CSS_CSS_KS2_ks2_uckdf(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS2_ks2_uckdf_SHIFT)) & CSS_CSS_KS2_ks2_uckdf_MASK)

#define CSS_CSS_KS2_ks2_uhkdf_MASK               (0x20000U)
#define CSS_CSS_KS2_ks2_uhkdf_SHIFT              (17U)
/*! ks2_uhkdf - Derivation key for HKDF command
 */
#define CSS_CSS_KS2_ks2_uhkdf(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS2_ks2_uhkdf_SHIFT)) & CSS_CSS_KS2_ks2_uhkdf_MASK)

#define CSS_CSS_KS2_ks2_uecsg_MASK               (0x40000U)
#define CSS_CSS_KS2_ks2_uecsg_SHIFT              (18U)
/*! ks2_uecsg - Ecc signing key
 */
#define CSS_CSS_KS2_ks2_uecsg(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS2_ks2_uecsg_SHIFT)) & CSS_CSS_KS2_ks2_uecsg_MASK)

#define CSS_CSS_KS2_ks2_uecdh_MASK               (0x80000U)
#define CSS_CSS_KS2_ks2_uecdh_SHIFT              (19U)
/*! ks2_uecdh - Ecc diffie hellman key
 */
#define CSS_CSS_KS2_ks2_uecdh(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS2_ks2_uecdh_SHIFT)) & CSS_CSS_KS2_ks2_uecdh_MASK)

#define CSS_CSS_KS2_ks2_uaes_MASK                (0x100000U)
#define CSS_CSS_KS2_ks2_uaes_SHIFT               (20U)
/*! ks2_uaes - Aes key
 */
#define CSS_CSS_KS2_ks2_uaes(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS2_ks2_uaes_SHIFT)) & CSS_CSS_KS2_ks2_uaes_MASK)

#define CSS_CSS_KS2_ks2_uhmac_MASK               (0x200000U)
#define CSS_CSS_KS2_ks2_uhmac_SHIFT              (21U)
/*! ks2_uhmac - Hmac key
 */
#define CSS_CSS_KS2_ks2_uhmac(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS2_ks2_uhmac_SHIFT)) & CSS_CSS_KS2_ks2_uhmac_MASK)

#define CSS_CSS_KS2_ks2_ukwk_MASK                (0x400000U)
#define CSS_CSS_KS2_ks2_ukwk_SHIFT               (22U)
/*! ks2_ukwk - Key wrapping key
 */
#define CSS_CSS_KS2_ks2_ukwk(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS2_ks2_ukwk_SHIFT)) & CSS_CSS_KS2_ks2_ukwk_MASK)

#define CSS_CSS_KS2_ks2_ukuok_MASK               (0x800000U)
#define CSS_CSS_KS2_ks2_ukuok_SHIFT              (23U)
/*! ks2_ukuok - Key unwrapping key
 */
#define CSS_CSS_KS2_ks2_ukuok(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS2_ks2_ukuok_SHIFT)) & CSS_CSS_KS2_ks2_ukuok_MASK)

#define CSS_CSS_KS2_ks2_utlspms_MASK             (0x1000000U)
#define CSS_CSS_KS2_ks2_utlspms_SHIFT            (24U)
/*! ks2_utlspms - TLS Pre Master Secret
 */
#define CSS_CSS_KS2_ks2_utlspms(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS2_ks2_utlspms_SHIFT)) & CSS_CSS_KS2_ks2_utlspms_MASK)

#define CSS_CSS_KS2_ks2_utlsms_MASK              (0x2000000U)
#define CSS_CSS_KS2_ks2_utlsms_SHIFT             (25U)
/*! ks2_utlsms - TLS Master Secret
 */
#define CSS_CSS_KS2_ks2_utlsms(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS2_ks2_utlsms_SHIFT)) & CSS_CSS_KS2_ks2_utlsms_MASK)

#define CSS_CSS_KS2_ks2_ukgsrc_MASK              (0x4000000U)
#define CSS_CSS_KS2_ks2_ukgsrc_SHIFT             (26U)
/*! ks2_ukgsrc - Supply KEYGEN source
 */
#define CSS_CSS_KS2_ks2_ukgsrc(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS2_ks2_ukgsrc_SHIFT)) & CSS_CSS_KS2_ks2_ukgsrc_MASK)

#define CSS_CSS_KS2_ks2_uhwo_MASK                (0x8000000U)
#define CSS_CSS_KS2_ks2_uhwo_SHIFT               (27U)
/*! ks2_uhwo - Hardware out key
 */
#define CSS_CSS_KS2_ks2_uhwo(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS2_ks2_uhwo_SHIFT)) & CSS_CSS_KS2_ks2_uhwo_MASK)

#define CSS_CSS_KS2_ks2_uwrpok_MASK              (0x10000000U)
#define CSS_CSS_KS2_ks2_uwrpok_SHIFT             (28U)
/*! ks2_uwrpok - Ok to wrap key
 */
#define CSS_CSS_KS2_ks2_uwrpok(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS2_ks2_uwrpok_SHIFT)) & CSS_CSS_KS2_ks2_uwrpok_MASK)

#define CSS_CSS_KS2_ks2_uduk_MASK                (0x20000000U)
#define CSS_CSS_KS2_ks2_uduk_SHIFT               (29U)
/*! ks2_uduk - Device Unique Key
 */
#define CSS_CSS_KS2_ks2_uduk(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS2_ks2_uduk_SHIFT)) & CSS_CSS_KS2_ks2_uduk_MASK)

#define CSS_CSS_KS2_ks2_upprot_MASK              (0xC0000000U)
#define CSS_CSS_KS2_ks2_upprot_SHIFT             (30U)
/*! ks2_upprot - Priviledge level
 */
#define CSS_CSS_KS2_ks2_upprot(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS2_ks2_upprot_SHIFT)) & CSS_CSS_KS2_ks2_upprot_MASK)
/*! @} */

/*! @name CSS_KS3 - Status register */
/*! @{ */

#define CSS_CSS_KS3_ks3_ksize_MASK               (0x1U)
#define CSS_CSS_KS3_ks3_ksize_SHIFT              (0U)
/*! ks3_ksize - Key size: 0-128, 1-256
 */
#define CSS_CSS_KS3_ks3_ksize(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS3_ks3_ksize_SHIFT)) & CSS_CSS_KS3_ks3_ksize_MASK)

#define CSS_CSS_KS3_ks3_rsvd0_MASK               (0x1EU)
#define CSS_CSS_KS3_ks3_rsvd0_SHIFT              (1U)
/*! ks3_rsvd0 - Reserved 0
 */
#define CSS_CSS_KS3_ks3_rsvd0(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS3_ks3_rsvd0_SHIFT)) & CSS_CSS_KS3_ks3_rsvd0_MASK)

#define CSS_CSS_KS3_ks3_kact_MASK                (0x20U)
#define CSS_CSS_KS3_ks3_kact_SHIFT               (5U)
/*! ks3_kact - Key is active
 */
#define CSS_CSS_KS3_ks3_kact(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS3_ks3_kact_SHIFT)) & CSS_CSS_KS3_ks3_kact_MASK)

#define CSS_CSS_KS3_ks3_kbase_MASK               (0x40U)
#define CSS_CSS_KS3_ks3_kbase_SHIFT              (6U)
/*! ks3_kbase - First slot in a multislot key
 */
#define CSS_CSS_KS3_ks3_kbase(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS3_ks3_kbase_SHIFT)) & CSS_CSS_KS3_ks3_kbase_MASK)

#define CSS_CSS_KS3_ks3_fgp_MASK                 (0x80U)
#define CSS_CSS_KS3_ks3_fgp_SHIFT                (7U)
/*! ks3_fgp - Hardware Feature General Purpose
 */
#define CSS_CSS_KS3_ks3_fgp(x)                   (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS3_ks3_fgp_SHIFT)) & CSS_CSS_KS3_ks3_fgp_MASK)

#define CSS_CSS_KS3_ks3_frtn_MASK                (0x100U)
#define CSS_CSS_KS3_ks3_frtn_SHIFT               (8U)
/*! ks3_frtn - Hardware Feature Retention
 */
#define CSS_CSS_KS3_ks3_frtn(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS3_ks3_frtn_SHIFT)) & CSS_CSS_KS3_ks3_frtn_MASK)

#define CSS_CSS_KS3_ks3_fhwo_MASK                (0x200U)
#define CSS_CSS_KS3_ks3_fhwo_SHIFT               (9U)
/*! ks3_fhwo - Hardware Feature Output
 */
#define CSS_CSS_KS3_ks3_fhwo(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS3_ks3_fhwo_SHIFT)) & CSS_CSS_KS3_ks3_fhwo_MASK)

#define CSS_CSS_KS3_ks3_rsvd1_MASK               (0x1C00U)
#define CSS_CSS_KS3_ks3_rsvd1_SHIFT              (10U)
/*! ks3_rsvd1 - Reserved 1
 */
#define CSS_CSS_KS3_ks3_rsvd1(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS3_ks3_rsvd1_SHIFT)) & CSS_CSS_KS3_ks3_rsvd1_MASK)

#define CSS_CSS_KS3_ks3_ucmac_MASK               (0x2000U)
#define CSS_CSS_KS3_ks3_ucmac_SHIFT              (13U)
/*! ks3_ucmac - CMAC key
 */
#define CSS_CSS_KS3_ks3_ucmac(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS3_ks3_ucmac_SHIFT)) & CSS_CSS_KS3_ks3_ucmac_MASK)

#define CSS_CSS_KS3_ks3_uksk_MASK                (0x4000U)
#define CSS_CSS_KS3_ks3_uksk_SHIFT               (14U)
/*! ks3_uksk - KSK key
 */
#define CSS_CSS_KS3_ks3_uksk(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS3_ks3_uksk_SHIFT)) & CSS_CSS_KS3_ks3_uksk_MASK)

#define CSS_CSS_KS3_ks3_urtf_MASK                (0x8000U)
#define CSS_CSS_KS3_ks3_urtf_SHIFT               (15U)
/*! ks3_urtf - Real Time Fingerprint key
 */
#define CSS_CSS_KS3_ks3_urtf(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS3_ks3_urtf_SHIFT)) & CSS_CSS_KS3_ks3_urtf_MASK)

#define CSS_CSS_KS3_ks3_uckdf_MASK               (0x10000U)
#define CSS_CSS_KS3_ks3_uckdf_SHIFT              (16U)
/*! ks3_uckdf - Derivation key for CKDF command
 */
#define CSS_CSS_KS3_ks3_uckdf(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS3_ks3_uckdf_SHIFT)) & CSS_CSS_KS3_ks3_uckdf_MASK)

#define CSS_CSS_KS3_ks3_uhkdf_MASK               (0x20000U)
#define CSS_CSS_KS3_ks3_uhkdf_SHIFT              (17U)
/*! ks3_uhkdf - Derivation key for HKDF command
 */
#define CSS_CSS_KS3_ks3_uhkdf(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS3_ks3_uhkdf_SHIFT)) & CSS_CSS_KS3_ks3_uhkdf_MASK)

#define CSS_CSS_KS3_ks3_uecsg_MASK               (0x40000U)
#define CSS_CSS_KS3_ks3_uecsg_SHIFT              (18U)
/*! ks3_uecsg - Ecc signing key
 */
#define CSS_CSS_KS3_ks3_uecsg(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS3_ks3_uecsg_SHIFT)) & CSS_CSS_KS3_ks3_uecsg_MASK)

#define CSS_CSS_KS3_ks3_uecdh_MASK               (0x80000U)
#define CSS_CSS_KS3_ks3_uecdh_SHIFT              (19U)
/*! ks3_uecdh - Ecc diffie hellman key
 */
#define CSS_CSS_KS3_ks3_uecdh(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS3_ks3_uecdh_SHIFT)) & CSS_CSS_KS3_ks3_uecdh_MASK)

#define CSS_CSS_KS3_ks3_uaes_MASK                (0x100000U)
#define CSS_CSS_KS3_ks3_uaes_SHIFT               (20U)
/*! ks3_uaes - Aes key
 */
#define CSS_CSS_KS3_ks3_uaes(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS3_ks3_uaes_SHIFT)) & CSS_CSS_KS3_ks3_uaes_MASK)

#define CSS_CSS_KS3_ks3_uhmac_MASK               (0x200000U)
#define CSS_CSS_KS3_ks3_uhmac_SHIFT              (21U)
/*! ks3_uhmac - Hmac key
 */
#define CSS_CSS_KS3_ks3_uhmac(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS3_ks3_uhmac_SHIFT)) & CSS_CSS_KS3_ks3_uhmac_MASK)

#define CSS_CSS_KS3_ks3_ukwk_MASK                (0x400000U)
#define CSS_CSS_KS3_ks3_ukwk_SHIFT               (22U)
/*! ks3_ukwk - Key wrapping key
 */
#define CSS_CSS_KS3_ks3_ukwk(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS3_ks3_ukwk_SHIFT)) & CSS_CSS_KS3_ks3_ukwk_MASK)

#define CSS_CSS_KS3_ks3_ukuok_MASK               (0x800000U)
#define CSS_CSS_KS3_ks3_ukuok_SHIFT              (23U)
/*! ks3_ukuok - Key unwrapping key
 */
#define CSS_CSS_KS3_ks3_ukuok(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS3_ks3_ukuok_SHIFT)) & CSS_CSS_KS3_ks3_ukuok_MASK)

#define CSS_CSS_KS3_ks3_utlspms_MASK             (0x1000000U)
#define CSS_CSS_KS3_ks3_utlspms_SHIFT            (24U)
/*! ks3_utlspms - TLS Pre Master Secret
 */
#define CSS_CSS_KS3_ks3_utlspms(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS3_ks3_utlspms_SHIFT)) & CSS_CSS_KS3_ks3_utlspms_MASK)

#define CSS_CSS_KS3_ks3_utlsms_MASK              (0x2000000U)
#define CSS_CSS_KS3_ks3_utlsms_SHIFT             (25U)
/*! ks3_utlsms - TLS Master Secret
 */
#define CSS_CSS_KS3_ks3_utlsms(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS3_ks3_utlsms_SHIFT)) & CSS_CSS_KS3_ks3_utlsms_MASK)

#define CSS_CSS_KS3_ks3_ukgsrc_MASK              (0x4000000U)
#define CSS_CSS_KS3_ks3_ukgsrc_SHIFT             (26U)
/*! ks3_ukgsrc - Supply KEYGEN source
 */
#define CSS_CSS_KS3_ks3_ukgsrc(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS3_ks3_ukgsrc_SHIFT)) & CSS_CSS_KS3_ks3_ukgsrc_MASK)

#define CSS_CSS_KS3_ks3_uhwo_MASK                (0x8000000U)
#define CSS_CSS_KS3_ks3_uhwo_SHIFT               (27U)
/*! ks3_uhwo - Hardware out key
 */
#define CSS_CSS_KS3_ks3_uhwo(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS3_ks3_uhwo_SHIFT)) & CSS_CSS_KS3_ks3_uhwo_MASK)

#define CSS_CSS_KS3_ks3_uwrpok_MASK              (0x10000000U)
#define CSS_CSS_KS3_ks3_uwrpok_SHIFT             (28U)
/*! ks3_uwrpok - Ok to wrap key
 */
#define CSS_CSS_KS3_ks3_uwrpok(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS3_ks3_uwrpok_SHIFT)) & CSS_CSS_KS3_ks3_uwrpok_MASK)

#define CSS_CSS_KS3_ks3_uduk_MASK                (0x20000000U)
#define CSS_CSS_KS3_ks3_uduk_SHIFT               (29U)
/*! ks3_uduk - Device Unique Key
 */
#define CSS_CSS_KS3_ks3_uduk(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS3_ks3_uduk_SHIFT)) & CSS_CSS_KS3_ks3_uduk_MASK)

#define CSS_CSS_KS3_ks3_upprot_MASK              (0xC0000000U)
#define CSS_CSS_KS3_ks3_upprot_SHIFT             (30U)
/*! ks3_upprot - Priviledge level
 */
#define CSS_CSS_KS3_ks3_upprot(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS3_ks3_upprot_SHIFT)) & CSS_CSS_KS3_ks3_upprot_MASK)
/*! @} */

/*! @name CSS_KS4 - Status register */
/*! @{ */

#define CSS_CSS_KS4_ks4_ksize_MASK               (0x1U)
#define CSS_CSS_KS4_ks4_ksize_SHIFT              (0U)
/*! ks4_ksize - Key size: 0-128, 1-256
 */
#define CSS_CSS_KS4_ks4_ksize(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS4_ks4_ksize_SHIFT)) & CSS_CSS_KS4_ks4_ksize_MASK)

#define CSS_CSS_KS4_ks4_rsvd0_MASK               (0x1EU)
#define CSS_CSS_KS4_ks4_rsvd0_SHIFT              (1U)
/*! ks4_rsvd0 - Reserved 0
 */
#define CSS_CSS_KS4_ks4_rsvd0(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS4_ks4_rsvd0_SHIFT)) & CSS_CSS_KS4_ks4_rsvd0_MASK)

#define CSS_CSS_KS4_ks4_kact_MASK                (0x20U)
#define CSS_CSS_KS4_ks4_kact_SHIFT               (5U)
/*! ks4_kact - Key is active
 */
#define CSS_CSS_KS4_ks4_kact(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS4_ks4_kact_SHIFT)) & CSS_CSS_KS4_ks4_kact_MASK)

#define CSS_CSS_KS4_ks4_kbase_MASK               (0x40U)
#define CSS_CSS_KS4_ks4_kbase_SHIFT              (6U)
/*! ks4_kbase - First slot in a multislot key
 */
#define CSS_CSS_KS4_ks4_kbase(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS4_ks4_kbase_SHIFT)) & CSS_CSS_KS4_ks4_kbase_MASK)

#define CSS_CSS_KS4_ks4_fgp_MASK                 (0x80U)
#define CSS_CSS_KS4_ks4_fgp_SHIFT                (7U)
/*! ks4_fgp - Hardware Feature General Purpose
 */
#define CSS_CSS_KS4_ks4_fgp(x)                   (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS4_ks4_fgp_SHIFT)) & CSS_CSS_KS4_ks4_fgp_MASK)

#define CSS_CSS_KS4_ks4_frtn_MASK                (0x100U)
#define CSS_CSS_KS4_ks4_frtn_SHIFT               (8U)
/*! ks4_frtn - Hardware Feature Retention
 */
#define CSS_CSS_KS4_ks4_frtn(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS4_ks4_frtn_SHIFT)) & CSS_CSS_KS4_ks4_frtn_MASK)

#define CSS_CSS_KS4_ks4_fhwo_MASK                (0x200U)
#define CSS_CSS_KS4_ks4_fhwo_SHIFT               (9U)
/*! ks4_fhwo - Hardware Feature Output
 */
#define CSS_CSS_KS4_ks4_fhwo(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS4_ks4_fhwo_SHIFT)) & CSS_CSS_KS4_ks4_fhwo_MASK)

#define CSS_CSS_KS4_ks4_rsvd1_MASK               (0x1C00U)
#define CSS_CSS_KS4_ks4_rsvd1_SHIFT              (10U)
/*! ks4_rsvd1 - Reserved 1
 */
#define CSS_CSS_KS4_ks4_rsvd1(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS4_ks4_rsvd1_SHIFT)) & CSS_CSS_KS4_ks4_rsvd1_MASK)

#define CSS_CSS_KS4_ks4_ucmac_MASK               (0x2000U)
#define CSS_CSS_KS4_ks4_ucmac_SHIFT              (13U)
/*! ks4_ucmac - CMAC key
 */
#define CSS_CSS_KS4_ks4_ucmac(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS4_ks4_ucmac_SHIFT)) & CSS_CSS_KS4_ks4_ucmac_MASK)

#define CSS_CSS_KS4_ks4_uksk_MASK                (0x4000U)
#define CSS_CSS_KS4_ks4_uksk_SHIFT               (14U)
/*! ks4_uksk - KSK key
 */
#define CSS_CSS_KS4_ks4_uksk(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS4_ks4_uksk_SHIFT)) & CSS_CSS_KS4_ks4_uksk_MASK)

#define CSS_CSS_KS4_ks4_urtf_MASK                (0x8000U)
#define CSS_CSS_KS4_ks4_urtf_SHIFT               (15U)
/*! ks4_urtf - Real Time Fingerprint key
 */
#define CSS_CSS_KS4_ks4_urtf(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS4_ks4_urtf_SHIFT)) & CSS_CSS_KS4_ks4_urtf_MASK)

#define CSS_CSS_KS4_ks4_uckdf_MASK               (0x10000U)
#define CSS_CSS_KS4_ks4_uckdf_SHIFT              (16U)
/*! ks4_uckdf - Derivation key for CKDF command
 */
#define CSS_CSS_KS4_ks4_uckdf(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS4_ks4_uckdf_SHIFT)) & CSS_CSS_KS4_ks4_uckdf_MASK)

#define CSS_CSS_KS4_ks4_uhkdf_MASK               (0x20000U)
#define CSS_CSS_KS4_ks4_uhkdf_SHIFT              (17U)
/*! ks4_uhkdf - Derivation key for HKDF command
 */
#define CSS_CSS_KS4_ks4_uhkdf(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS4_ks4_uhkdf_SHIFT)) & CSS_CSS_KS4_ks4_uhkdf_MASK)

#define CSS_CSS_KS4_ks4_uecsg_MASK               (0x40000U)
#define CSS_CSS_KS4_ks4_uecsg_SHIFT              (18U)
/*! ks4_uecsg - Ecc signing key
 */
#define CSS_CSS_KS4_ks4_uecsg(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS4_ks4_uecsg_SHIFT)) & CSS_CSS_KS4_ks4_uecsg_MASK)

#define CSS_CSS_KS4_ks4_uecdh_MASK               (0x80000U)
#define CSS_CSS_KS4_ks4_uecdh_SHIFT              (19U)
/*! ks4_uecdh - Ecc diffie hellman key
 */
#define CSS_CSS_KS4_ks4_uecdh(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS4_ks4_uecdh_SHIFT)) & CSS_CSS_KS4_ks4_uecdh_MASK)

#define CSS_CSS_KS4_ks4_uaes_MASK                (0x100000U)
#define CSS_CSS_KS4_ks4_uaes_SHIFT               (20U)
/*! ks4_uaes - Aes key
 */
#define CSS_CSS_KS4_ks4_uaes(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS4_ks4_uaes_SHIFT)) & CSS_CSS_KS4_ks4_uaes_MASK)

#define CSS_CSS_KS4_ks4_uhmac_MASK               (0x200000U)
#define CSS_CSS_KS4_ks4_uhmac_SHIFT              (21U)
/*! ks4_uhmac - Hmac key
 */
#define CSS_CSS_KS4_ks4_uhmac(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS4_ks4_uhmac_SHIFT)) & CSS_CSS_KS4_ks4_uhmac_MASK)

#define CSS_CSS_KS4_ks4_ukwk_MASK                (0x400000U)
#define CSS_CSS_KS4_ks4_ukwk_SHIFT               (22U)
/*! ks4_ukwk - Key wrapping key
 */
#define CSS_CSS_KS4_ks4_ukwk(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS4_ks4_ukwk_SHIFT)) & CSS_CSS_KS4_ks4_ukwk_MASK)

#define CSS_CSS_KS4_ks4_ukuok_MASK               (0x800000U)
#define CSS_CSS_KS4_ks4_ukuok_SHIFT              (23U)
/*! ks4_ukuok - Key unwrapping key
 */
#define CSS_CSS_KS4_ks4_ukuok(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS4_ks4_ukuok_SHIFT)) & CSS_CSS_KS4_ks4_ukuok_MASK)

#define CSS_CSS_KS4_ks4_utlspms_MASK             (0x1000000U)
#define CSS_CSS_KS4_ks4_utlspms_SHIFT            (24U)
/*! ks4_utlspms - TLS Pre Master Secret
 */
#define CSS_CSS_KS4_ks4_utlspms(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS4_ks4_utlspms_SHIFT)) & CSS_CSS_KS4_ks4_utlspms_MASK)

#define CSS_CSS_KS4_ks4_utlsms_MASK              (0x2000000U)
#define CSS_CSS_KS4_ks4_utlsms_SHIFT             (25U)
/*! ks4_utlsms - TLS Master Secret
 */
#define CSS_CSS_KS4_ks4_utlsms(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS4_ks4_utlsms_SHIFT)) & CSS_CSS_KS4_ks4_utlsms_MASK)

#define CSS_CSS_KS4_ks4_ukgsrc_MASK              (0x4000000U)
#define CSS_CSS_KS4_ks4_ukgsrc_SHIFT             (26U)
/*! ks4_ukgsrc - Supply KEYGEN source
 */
#define CSS_CSS_KS4_ks4_ukgsrc(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS4_ks4_ukgsrc_SHIFT)) & CSS_CSS_KS4_ks4_ukgsrc_MASK)

#define CSS_CSS_KS4_ks4_uhwo_MASK                (0x8000000U)
#define CSS_CSS_KS4_ks4_uhwo_SHIFT               (27U)
/*! ks4_uhwo - Hardware out key
 */
#define CSS_CSS_KS4_ks4_uhwo(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS4_ks4_uhwo_SHIFT)) & CSS_CSS_KS4_ks4_uhwo_MASK)

#define CSS_CSS_KS4_ks4_uwrpok_MASK              (0x10000000U)
#define CSS_CSS_KS4_ks4_uwrpok_SHIFT             (28U)
/*! ks4_uwrpok - Ok to wrap key
 */
#define CSS_CSS_KS4_ks4_uwrpok(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS4_ks4_uwrpok_SHIFT)) & CSS_CSS_KS4_ks4_uwrpok_MASK)

#define CSS_CSS_KS4_ks4_uduk_MASK                (0x20000000U)
#define CSS_CSS_KS4_ks4_uduk_SHIFT               (29U)
/*! ks4_uduk - Device Unique Key
 */
#define CSS_CSS_KS4_ks4_uduk(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS4_ks4_uduk_SHIFT)) & CSS_CSS_KS4_ks4_uduk_MASK)

#define CSS_CSS_KS4_ks4_upprot_MASK              (0xC0000000U)
#define CSS_CSS_KS4_ks4_upprot_SHIFT             (30U)
/*! ks4_upprot - Priviledge level
 */
#define CSS_CSS_KS4_ks4_upprot(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS4_ks4_upprot_SHIFT)) & CSS_CSS_KS4_ks4_upprot_MASK)
/*! @} */

/*! @name CSS_KS5 - Status register */
/*! @{ */

#define CSS_CSS_KS5_ks5_ksize_MASK               (0x1U)
#define CSS_CSS_KS5_ks5_ksize_SHIFT              (0U)
/*! ks5_ksize - Key size: 0-128, 1-256
 */
#define CSS_CSS_KS5_ks5_ksize(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS5_ks5_ksize_SHIFT)) & CSS_CSS_KS5_ks5_ksize_MASK)

#define CSS_CSS_KS5_ks5_rsvd0_MASK               (0x1EU)
#define CSS_CSS_KS5_ks5_rsvd0_SHIFT              (1U)
/*! ks5_rsvd0 - Reserved 0
 */
#define CSS_CSS_KS5_ks5_rsvd0(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS5_ks5_rsvd0_SHIFT)) & CSS_CSS_KS5_ks5_rsvd0_MASK)

#define CSS_CSS_KS5_ks5_kact_MASK                (0x20U)
#define CSS_CSS_KS5_ks5_kact_SHIFT               (5U)
/*! ks5_kact - Key is active
 */
#define CSS_CSS_KS5_ks5_kact(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS5_ks5_kact_SHIFT)) & CSS_CSS_KS5_ks5_kact_MASK)

#define CSS_CSS_KS5_ks5_kbase_MASK               (0x40U)
#define CSS_CSS_KS5_ks5_kbase_SHIFT              (6U)
/*! ks5_kbase - First slot in a multislot key
 */
#define CSS_CSS_KS5_ks5_kbase(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS5_ks5_kbase_SHIFT)) & CSS_CSS_KS5_ks5_kbase_MASK)

#define CSS_CSS_KS5_ks5_fgp_MASK                 (0x80U)
#define CSS_CSS_KS5_ks5_fgp_SHIFT                (7U)
/*! ks5_fgp - Hardware Feature General Purpose
 */
#define CSS_CSS_KS5_ks5_fgp(x)                   (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS5_ks5_fgp_SHIFT)) & CSS_CSS_KS5_ks5_fgp_MASK)

#define CSS_CSS_KS5_ks5_frtn_MASK                (0x100U)
#define CSS_CSS_KS5_ks5_frtn_SHIFT               (8U)
/*! ks5_frtn - Hardware Feature Retention
 */
#define CSS_CSS_KS5_ks5_frtn(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS5_ks5_frtn_SHIFT)) & CSS_CSS_KS5_ks5_frtn_MASK)

#define CSS_CSS_KS5_ks5_fhwo_MASK                (0x200U)
#define CSS_CSS_KS5_ks5_fhwo_SHIFT               (9U)
/*! ks5_fhwo - Hardware Feature Output
 */
#define CSS_CSS_KS5_ks5_fhwo(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS5_ks5_fhwo_SHIFT)) & CSS_CSS_KS5_ks5_fhwo_MASK)

#define CSS_CSS_KS5_ks5_rsvd1_MASK               (0x1C00U)
#define CSS_CSS_KS5_ks5_rsvd1_SHIFT              (10U)
/*! ks5_rsvd1 - Reserved 1
 */
#define CSS_CSS_KS5_ks5_rsvd1(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS5_ks5_rsvd1_SHIFT)) & CSS_CSS_KS5_ks5_rsvd1_MASK)

#define CSS_CSS_KS5_ks5_ucmac_MASK               (0x2000U)
#define CSS_CSS_KS5_ks5_ucmac_SHIFT              (13U)
/*! ks5_ucmac - CMAC key
 */
#define CSS_CSS_KS5_ks5_ucmac(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS5_ks5_ucmac_SHIFT)) & CSS_CSS_KS5_ks5_ucmac_MASK)

#define CSS_CSS_KS5_ks5_uksk_MASK                (0x4000U)
#define CSS_CSS_KS5_ks5_uksk_SHIFT               (14U)
/*! ks5_uksk - KSK key
 */
#define CSS_CSS_KS5_ks5_uksk(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS5_ks5_uksk_SHIFT)) & CSS_CSS_KS5_ks5_uksk_MASK)

#define CSS_CSS_KS5_ks5_urtf_MASK                (0x8000U)
#define CSS_CSS_KS5_ks5_urtf_SHIFT               (15U)
/*! ks5_urtf - Real Time Fingerprint key
 */
#define CSS_CSS_KS5_ks5_urtf(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS5_ks5_urtf_SHIFT)) & CSS_CSS_KS5_ks5_urtf_MASK)

#define CSS_CSS_KS5_ks5_uckdf_MASK               (0x10000U)
#define CSS_CSS_KS5_ks5_uckdf_SHIFT              (16U)
/*! ks5_uckdf - Derivation key for CKDF command
 */
#define CSS_CSS_KS5_ks5_uckdf(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS5_ks5_uckdf_SHIFT)) & CSS_CSS_KS5_ks5_uckdf_MASK)

#define CSS_CSS_KS5_ks5_uhkdf_MASK               (0x20000U)
#define CSS_CSS_KS5_ks5_uhkdf_SHIFT              (17U)
/*! ks5_uhkdf - Derivation key for HKDF command
 */
#define CSS_CSS_KS5_ks5_uhkdf(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS5_ks5_uhkdf_SHIFT)) & CSS_CSS_KS5_ks5_uhkdf_MASK)

#define CSS_CSS_KS5_ks5_uecsg_MASK               (0x40000U)
#define CSS_CSS_KS5_ks5_uecsg_SHIFT              (18U)
/*! ks5_uecsg - Ecc signing key
 */
#define CSS_CSS_KS5_ks5_uecsg(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS5_ks5_uecsg_SHIFT)) & CSS_CSS_KS5_ks5_uecsg_MASK)

#define CSS_CSS_KS5_ks5_uecdh_MASK               (0x80000U)
#define CSS_CSS_KS5_ks5_uecdh_SHIFT              (19U)
/*! ks5_uecdh - Ecc diffie hellman key
 */
#define CSS_CSS_KS5_ks5_uecdh(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS5_ks5_uecdh_SHIFT)) & CSS_CSS_KS5_ks5_uecdh_MASK)

#define CSS_CSS_KS5_ks5_uaes_MASK                (0x100000U)
#define CSS_CSS_KS5_ks5_uaes_SHIFT               (20U)
/*! ks5_uaes - Aes key
 */
#define CSS_CSS_KS5_ks5_uaes(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS5_ks5_uaes_SHIFT)) & CSS_CSS_KS5_ks5_uaes_MASK)

#define CSS_CSS_KS5_ks5_uhmac_MASK               (0x200000U)
#define CSS_CSS_KS5_ks5_uhmac_SHIFT              (21U)
/*! ks5_uhmac - Hmac key
 */
#define CSS_CSS_KS5_ks5_uhmac(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS5_ks5_uhmac_SHIFT)) & CSS_CSS_KS5_ks5_uhmac_MASK)

#define CSS_CSS_KS5_ks5_ukwk_MASK                (0x400000U)
#define CSS_CSS_KS5_ks5_ukwk_SHIFT               (22U)
/*! ks5_ukwk - Key wrapping key
 */
#define CSS_CSS_KS5_ks5_ukwk(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS5_ks5_ukwk_SHIFT)) & CSS_CSS_KS5_ks5_ukwk_MASK)

#define CSS_CSS_KS5_ks5_ukuok_MASK               (0x800000U)
#define CSS_CSS_KS5_ks5_ukuok_SHIFT              (23U)
/*! ks5_ukuok - Key unwrapping key
 */
#define CSS_CSS_KS5_ks5_ukuok(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS5_ks5_ukuok_SHIFT)) & CSS_CSS_KS5_ks5_ukuok_MASK)

#define CSS_CSS_KS5_ks5_utlspms_MASK             (0x1000000U)
#define CSS_CSS_KS5_ks5_utlspms_SHIFT            (24U)
/*! ks5_utlspms - TLS Pre Master Secret
 */
#define CSS_CSS_KS5_ks5_utlspms(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS5_ks5_utlspms_SHIFT)) & CSS_CSS_KS5_ks5_utlspms_MASK)

#define CSS_CSS_KS5_ks5_utlsms_MASK              (0x2000000U)
#define CSS_CSS_KS5_ks5_utlsms_SHIFT             (25U)
/*! ks5_utlsms - TLS Master Secret
 */
#define CSS_CSS_KS5_ks5_utlsms(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS5_ks5_utlsms_SHIFT)) & CSS_CSS_KS5_ks5_utlsms_MASK)

#define CSS_CSS_KS5_ks5_ukgsrc_MASK              (0x4000000U)
#define CSS_CSS_KS5_ks5_ukgsrc_SHIFT             (26U)
/*! ks5_ukgsrc - Supply KEYGEN source
 */
#define CSS_CSS_KS5_ks5_ukgsrc(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS5_ks5_ukgsrc_SHIFT)) & CSS_CSS_KS5_ks5_ukgsrc_MASK)

#define CSS_CSS_KS5_ks5_uhwo_MASK                (0x8000000U)
#define CSS_CSS_KS5_ks5_uhwo_SHIFT               (27U)
/*! ks5_uhwo - Hardware out key
 */
#define CSS_CSS_KS5_ks5_uhwo(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS5_ks5_uhwo_SHIFT)) & CSS_CSS_KS5_ks5_uhwo_MASK)

#define CSS_CSS_KS5_ks5_uwrpok_MASK              (0x10000000U)
#define CSS_CSS_KS5_ks5_uwrpok_SHIFT             (28U)
/*! ks5_uwrpok - Ok to wrap key
 */
#define CSS_CSS_KS5_ks5_uwrpok(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS5_ks5_uwrpok_SHIFT)) & CSS_CSS_KS5_ks5_uwrpok_MASK)

#define CSS_CSS_KS5_ks5_uduk_MASK                (0x20000000U)
#define CSS_CSS_KS5_ks5_uduk_SHIFT               (29U)
/*! ks5_uduk - Device Unique Key
 */
#define CSS_CSS_KS5_ks5_uduk(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS5_ks5_uduk_SHIFT)) & CSS_CSS_KS5_ks5_uduk_MASK)

#define CSS_CSS_KS5_ks5_upprot_MASK              (0xC0000000U)
#define CSS_CSS_KS5_ks5_upprot_SHIFT             (30U)
/*! ks5_upprot - Priviledge level
 */
#define CSS_CSS_KS5_ks5_upprot(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS5_ks5_upprot_SHIFT)) & CSS_CSS_KS5_ks5_upprot_MASK)
/*! @} */

/*! @name CSS_KS6 - Status register */
/*! @{ */

#define CSS_CSS_KS6_ks6_ksize_MASK               (0x1U)
#define CSS_CSS_KS6_ks6_ksize_SHIFT              (0U)
/*! ks6_ksize - Key size: 0-128, 1-256
 */
#define CSS_CSS_KS6_ks6_ksize(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS6_ks6_ksize_SHIFT)) & CSS_CSS_KS6_ks6_ksize_MASK)

#define CSS_CSS_KS6_ks6_rsvd0_MASK               (0x1EU)
#define CSS_CSS_KS6_ks6_rsvd0_SHIFT              (1U)
/*! ks6_rsvd0 - Reserved 0
 */
#define CSS_CSS_KS6_ks6_rsvd0(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS6_ks6_rsvd0_SHIFT)) & CSS_CSS_KS6_ks6_rsvd0_MASK)

#define CSS_CSS_KS6_ks6_kact_MASK                (0x20U)
#define CSS_CSS_KS6_ks6_kact_SHIFT               (5U)
/*! ks6_kact - Key is active
 */
#define CSS_CSS_KS6_ks6_kact(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS6_ks6_kact_SHIFT)) & CSS_CSS_KS6_ks6_kact_MASK)

#define CSS_CSS_KS6_ks6_kbase_MASK               (0x40U)
#define CSS_CSS_KS6_ks6_kbase_SHIFT              (6U)
/*! ks6_kbase - First slot in a multislot key
 */
#define CSS_CSS_KS6_ks6_kbase(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS6_ks6_kbase_SHIFT)) & CSS_CSS_KS6_ks6_kbase_MASK)

#define CSS_CSS_KS6_ks6_fgp_MASK                 (0x80U)
#define CSS_CSS_KS6_ks6_fgp_SHIFT                (7U)
/*! ks6_fgp - Hardware Feature General Purpose
 */
#define CSS_CSS_KS6_ks6_fgp(x)                   (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS6_ks6_fgp_SHIFT)) & CSS_CSS_KS6_ks6_fgp_MASK)

#define CSS_CSS_KS6_ks6_frtn_MASK                (0x100U)
#define CSS_CSS_KS6_ks6_frtn_SHIFT               (8U)
/*! ks6_frtn - Hardware Feature Retention
 */
#define CSS_CSS_KS6_ks6_frtn(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS6_ks6_frtn_SHIFT)) & CSS_CSS_KS6_ks6_frtn_MASK)

#define CSS_CSS_KS6_ks6_fhwo_MASK                (0x200U)
#define CSS_CSS_KS6_ks6_fhwo_SHIFT               (9U)
/*! ks6_fhwo - Hardware Feature Output
 */
#define CSS_CSS_KS6_ks6_fhwo(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS6_ks6_fhwo_SHIFT)) & CSS_CSS_KS6_ks6_fhwo_MASK)

#define CSS_CSS_KS6_ks6_rsvd1_MASK               (0x1C00U)
#define CSS_CSS_KS6_ks6_rsvd1_SHIFT              (10U)
/*! ks6_rsvd1 - Reserved 1
 */
#define CSS_CSS_KS6_ks6_rsvd1(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS6_ks6_rsvd1_SHIFT)) & CSS_CSS_KS6_ks6_rsvd1_MASK)

#define CSS_CSS_KS6_ks6_ucmac_MASK               (0x2000U)
#define CSS_CSS_KS6_ks6_ucmac_SHIFT              (13U)
/*! ks6_ucmac - CMAC key
 */
#define CSS_CSS_KS6_ks6_ucmac(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS6_ks6_ucmac_SHIFT)) & CSS_CSS_KS6_ks6_ucmac_MASK)

#define CSS_CSS_KS6_ks6_uksk_MASK                (0x4000U)
#define CSS_CSS_KS6_ks6_uksk_SHIFT               (14U)
/*! ks6_uksk - KSK key
 */
#define CSS_CSS_KS6_ks6_uksk(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS6_ks6_uksk_SHIFT)) & CSS_CSS_KS6_ks6_uksk_MASK)

#define CSS_CSS_KS6_ks6_urtf_MASK                (0x8000U)
#define CSS_CSS_KS6_ks6_urtf_SHIFT               (15U)
/*! ks6_urtf - Real Time Fingerprint key
 */
#define CSS_CSS_KS6_ks6_urtf(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS6_ks6_urtf_SHIFT)) & CSS_CSS_KS6_ks6_urtf_MASK)

#define CSS_CSS_KS6_ks6_uckdf_MASK               (0x10000U)
#define CSS_CSS_KS6_ks6_uckdf_SHIFT              (16U)
/*! ks6_uckdf - Derivation key for CKDF command
 */
#define CSS_CSS_KS6_ks6_uckdf(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS6_ks6_uckdf_SHIFT)) & CSS_CSS_KS6_ks6_uckdf_MASK)

#define CSS_CSS_KS6_ks6_uhkdf_MASK               (0x20000U)
#define CSS_CSS_KS6_ks6_uhkdf_SHIFT              (17U)
/*! ks6_uhkdf - Derivation key for HKDF command
 */
#define CSS_CSS_KS6_ks6_uhkdf(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS6_ks6_uhkdf_SHIFT)) & CSS_CSS_KS6_ks6_uhkdf_MASK)

#define CSS_CSS_KS6_ks6_uecsg_MASK               (0x40000U)
#define CSS_CSS_KS6_ks6_uecsg_SHIFT              (18U)
/*! ks6_uecsg - Ecc signing key
 */
#define CSS_CSS_KS6_ks6_uecsg(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS6_ks6_uecsg_SHIFT)) & CSS_CSS_KS6_ks6_uecsg_MASK)

#define CSS_CSS_KS6_ks6_uecdh_MASK               (0x80000U)
#define CSS_CSS_KS6_ks6_uecdh_SHIFT              (19U)
/*! ks6_uecdh - Ecc diffie hellman key
 */
#define CSS_CSS_KS6_ks6_uecdh(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS6_ks6_uecdh_SHIFT)) & CSS_CSS_KS6_ks6_uecdh_MASK)

#define CSS_CSS_KS6_ks6_uaes_MASK                (0x100000U)
#define CSS_CSS_KS6_ks6_uaes_SHIFT               (20U)
/*! ks6_uaes - Aes key
 */
#define CSS_CSS_KS6_ks6_uaes(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS6_ks6_uaes_SHIFT)) & CSS_CSS_KS6_ks6_uaes_MASK)

#define CSS_CSS_KS6_ks6_uhmac_MASK               (0x200000U)
#define CSS_CSS_KS6_ks6_uhmac_SHIFT              (21U)
/*! ks6_uhmac - Hmac key
 */
#define CSS_CSS_KS6_ks6_uhmac(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS6_ks6_uhmac_SHIFT)) & CSS_CSS_KS6_ks6_uhmac_MASK)

#define CSS_CSS_KS6_ks6_ukwk_MASK                (0x400000U)
#define CSS_CSS_KS6_ks6_ukwk_SHIFT               (22U)
/*! ks6_ukwk - Key wrapping key
 */
#define CSS_CSS_KS6_ks6_ukwk(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS6_ks6_ukwk_SHIFT)) & CSS_CSS_KS6_ks6_ukwk_MASK)

#define CSS_CSS_KS6_ks6_ukuok_MASK               (0x800000U)
#define CSS_CSS_KS6_ks6_ukuok_SHIFT              (23U)
/*! ks6_ukuok - Key unwrapping key
 */
#define CSS_CSS_KS6_ks6_ukuok(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS6_ks6_ukuok_SHIFT)) & CSS_CSS_KS6_ks6_ukuok_MASK)

#define CSS_CSS_KS6_ks6_utlspms_MASK             (0x1000000U)
#define CSS_CSS_KS6_ks6_utlspms_SHIFT            (24U)
/*! ks6_utlspms - TLS Pre Master Secret
 */
#define CSS_CSS_KS6_ks6_utlspms(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS6_ks6_utlspms_SHIFT)) & CSS_CSS_KS6_ks6_utlspms_MASK)

#define CSS_CSS_KS6_ks6_utlsms_MASK              (0x2000000U)
#define CSS_CSS_KS6_ks6_utlsms_SHIFT             (25U)
/*! ks6_utlsms - TLS Master Secret
 */
#define CSS_CSS_KS6_ks6_utlsms(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS6_ks6_utlsms_SHIFT)) & CSS_CSS_KS6_ks6_utlsms_MASK)

#define CSS_CSS_KS6_ks6_ukgsrc_MASK              (0x4000000U)
#define CSS_CSS_KS6_ks6_ukgsrc_SHIFT             (26U)
/*! ks6_ukgsrc - Supply KEYGEN source
 */
#define CSS_CSS_KS6_ks6_ukgsrc(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS6_ks6_ukgsrc_SHIFT)) & CSS_CSS_KS6_ks6_ukgsrc_MASK)

#define CSS_CSS_KS6_ks6_uhwo_MASK                (0x8000000U)
#define CSS_CSS_KS6_ks6_uhwo_SHIFT               (27U)
/*! ks6_uhwo - Hardware out key
 */
#define CSS_CSS_KS6_ks6_uhwo(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS6_ks6_uhwo_SHIFT)) & CSS_CSS_KS6_ks6_uhwo_MASK)

#define CSS_CSS_KS6_ks6_uwrpok_MASK              (0x10000000U)
#define CSS_CSS_KS6_ks6_uwrpok_SHIFT             (28U)
/*! ks6_uwrpok - Ok to wrap key
 */
#define CSS_CSS_KS6_ks6_uwrpok(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS6_ks6_uwrpok_SHIFT)) & CSS_CSS_KS6_ks6_uwrpok_MASK)

#define CSS_CSS_KS6_ks6_uduk_MASK                (0x20000000U)
#define CSS_CSS_KS6_ks6_uduk_SHIFT               (29U)
/*! ks6_uduk - Device Unique Key
 */
#define CSS_CSS_KS6_ks6_uduk(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS6_ks6_uduk_SHIFT)) & CSS_CSS_KS6_ks6_uduk_MASK)

#define CSS_CSS_KS6_ks6_upprot_MASK              (0xC0000000U)
#define CSS_CSS_KS6_ks6_upprot_SHIFT             (30U)
/*! ks6_upprot - Priviledge level
 */
#define CSS_CSS_KS6_ks6_upprot(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS6_ks6_upprot_SHIFT)) & CSS_CSS_KS6_ks6_upprot_MASK)
/*! @} */

/*! @name CSS_KS7 - Status register */
/*! @{ */

#define CSS_CSS_KS7_ks7_ksize_MASK               (0x1U)
#define CSS_CSS_KS7_ks7_ksize_SHIFT              (0U)
/*! ks7_ksize - Key size: 0-128, 1-256
 */
#define CSS_CSS_KS7_ks7_ksize(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS7_ks7_ksize_SHIFT)) & CSS_CSS_KS7_ks7_ksize_MASK)

#define CSS_CSS_KS7_ks7_rsvd0_MASK               (0x1EU)
#define CSS_CSS_KS7_ks7_rsvd0_SHIFT              (1U)
/*! ks7_rsvd0 - Reserved 0
 */
#define CSS_CSS_KS7_ks7_rsvd0(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS7_ks7_rsvd0_SHIFT)) & CSS_CSS_KS7_ks7_rsvd0_MASK)

#define CSS_CSS_KS7_ks7_kact_MASK                (0x20U)
#define CSS_CSS_KS7_ks7_kact_SHIFT               (5U)
/*! ks7_kact - Key is active
 */
#define CSS_CSS_KS7_ks7_kact(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS7_ks7_kact_SHIFT)) & CSS_CSS_KS7_ks7_kact_MASK)

#define CSS_CSS_KS7_ks7_kbase_MASK               (0x40U)
#define CSS_CSS_KS7_ks7_kbase_SHIFT              (6U)
/*! ks7_kbase - First slot in a multislot key
 */
#define CSS_CSS_KS7_ks7_kbase(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS7_ks7_kbase_SHIFT)) & CSS_CSS_KS7_ks7_kbase_MASK)

#define CSS_CSS_KS7_ks7_fgp_MASK                 (0x80U)
#define CSS_CSS_KS7_ks7_fgp_SHIFT                (7U)
/*! ks7_fgp - Hardware Feature General Purpose
 */
#define CSS_CSS_KS7_ks7_fgp(x)                   (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS7_ks7_fgp_SHIFT)) & CSS_CSS_KS7_ks7_fgp_MASK)

#define CSS_CSS_KS7_ks7_frtn_MASK                (0x100U)
#define CSS_CSS_KS7_ks7_frtn_SHIFT               (8U)
/*! ks7_frtn - Hardware Feature Retention
 */
#define CSS_CSS_KS7_ks7_frtn(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS7_ks7_frtn_SHIFT)) & CSS_CSS_KS7_ks7_frtn_MASK)

#define CSS_CSS_KS7_ks7_fhwo_MASK                (0x200U)
#define CSS_CSS_KS7_ks7_fhwo_SHIFT               (9U)
/*! ks7_fhwo - Hardware Feature Output
 */
#define CSS_CSS_KS7_ks7_fhwo(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS7_ks7_fhwo_SHIFT)) & CSS_CSS_KS7_ks7_fhwo_MASK)

#define CSS_CSS_KS7_ks7_rsvd1_MASK               (0x1C00U)
#define CSS_CSS_KS7_ks7_rsvd1_SHIFT              (10U)
/*! ks7_rsvd1 - Reserved 1
 */
#define CSS_CSS_KS7_ks7_rsvd1(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS7_ks7_rsvd1_SHIFT)) & CSS_CSS_KS7_ks7_rsvd1_MASK)

#define CSS_CSS_KS7_ks7_ucmac_MASK               (0x2000U)
#define CSS_CSS_KS7_ks7_ucmac_SHIFT              (13U)
/*! ks7_ucmac - CMAC key
 */
#define CSS_CSS_KS7_ks7_ucmac(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS7_ks7_ucmac_SHIFT)) & CSS_CSS_KS7_ks7_ucmac_MASK)

#define CSS_CSS_KS7_ks7_uksk_MASK                (0x4000U)
#define CSS_CSS_KS7_ks7_uksk_SHIFT               (14U)
/*! ks7_uksk - KSK key
 */
#define CSS_CSS_KS7_ks7_uksk(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS7_ks7_uksk_SHIFT)) & CSS_CSS_KS7_ks7_uksk_MASK)

#define CSS_CSS_KS7_ks7_urtf_MASK                (0x8000U)
#define CSS_CSS_KS7_ks7_urtf_SHIFT               (15U)
/*! ks7_urtf - Real Time Fingerprint key
 */
#define CSS_CSS_KS7_ks7_urtf(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS7_ks7_urtf_SHIFT)) & CSS_CSS_KS7_ks7_urtf_MASK)

#define CSS_CSS_KS7_ks7_uckdf_MASK               (0x10000U)
#define CSS_CSS_KS7_ks7_uckdf_SHIFT              (16U)
/*! ks7_uckdf - Derivation key for CKDF command
 */
#define CSS_CSS_KS7_ks7_uckdf(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS7_ks7_uckdf_SHIFT)) & CSS_CSS_KS7_ks7_uckdf_MASK)

#define CSS_CSS_KS7_ks7_uhkdf_MASK               (0x20000U)
#define CSS_CSS_KS7_ks7_uhkdf_SHIFT              (17U)
/*! ks7_uhkdf - Derivation key for HKDF command
 */
#define CSS_CSS_KS7_ks7_uhkdf(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS7_ks7_uhkdf_SHIFT)) & CSS_CSS_KS7_ks7_uhkdf_MASK)

#define CSS_CSS_KS7_ks7_uecsg_MASK               (0x40000U)
#define CSS_CSS_KS7_ks7_uecsg_SHIFT              (18U)
/*! ks7_uecsg - Ecc signing key
 */
#define CSS_CSS_KS7_ks7_uecsg(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS7_ks7_uecsg_SHIFT)) & CSS_CSS_KS7_ks7_uecsg_MASK)

#define CSS_CSS_KS7_ks7_uecdh_MASK               (0x80000U)
#define CSS_CSS_KS7_ks7_uecdh_SHIFT              (19U)
/*! ks7_uecdh - Ecc diffie hellman key
 */
#define CSS_CSS_KS7_ks7_uecdh(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS7_ks7_uecdh_SHIFT)) & CSS_CSS_KS7_ks7_uecdh_MASK)

#define CSS_CSS_KS7_ks7_uaes_MASK                (0x100000U)
#define CSS_CSS_KS7_ks7_uaes_SHIFT               (20U)
/*! ks7_uaes - Aes key
 */
#define CSS_CSS_KS7_ks7_uaes(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS7_ks7_uaes_SHIFT)) & CSS_CSS_KS7_ks7_uaes_MASK)

#define CSS_CSS_KS7_ks7_uhmac_MASK               (0x200000U)
#define CSS_CSS_KS7_ks7_uhmac_SHIFT              (21U)
/*! ks7_uhmac - Hmac key
 */
#define CSS_CSS_KS7_ks7_uhmac(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS7_ks7_uhmac_SHIFT)) & CSS_CSS_KS7_ks7_uhmac_MASK)

#define CSS_CSS_KS7_ks7_ukwk_MASK                (0x400000U)
#define CSS_CSS_KS7_ks7_ukwk_SHIFT               (22U)
/*! ks7_ukwk - Key wrapping key
 */
#define CSS_CSS_KS7_ks7_ukwk(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS7_ks7_ukwk_SHIFT)) & CSS_CSS_KS7_ks7_ukwk_MASK)

#define CSS_CSS_KS7_ks7_ukuok_MASK               (0x800000U)
#define CSS_CSS_KS7_ks7_ukuok_SHIFT              (23U)
/*! ks7_ukuok - Key unwrapping key
 */
#define CSS_CSS_KS7_ks7_ukuok(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS7_ks7_ukuok_SHIFT)) & CSS_CSS_KS7_ks7_ukuok_MASK)

#define CSS_CSS_KS7_ks7_utlspms_MASK             (0x1000000U)
#define CSS_CSS_KS7_ks7_utlspms_SHIFT            (24U)
/*! ks7_utlspms - TLS Pre Master Secret
 */
#define CSS_CSS_KS7_ks7_utlspms(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS7_ks7_utlspms_SHIFT)) & CSS_CSS_KS7_ks7_utlspms_MASK)

#define CSS_CSS_KS7_ks7_utlsms_MASK              (0x2000000U)
#define CSS_CSS_KS7_ks7_utlsms_SHIFT             (25U)
/*! ks7_utlsms - TLS Master Secret
 */
#define CSS_CSS_KS7_ks7_utlsms(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS7_ks7_utlsms_SHIFT)) & CSS_CSS_KS7_ks7_utlsms_MASK)

#define CSS_CSS_KS7_ks7_ukgsrc_MASK              (0x4000000U)
#define CSS_CSS_KS7_ks7_ukgsrc_SHIFT             (26U)
/*! ks7_ukgsrc - Supply KEYGEN source
 */
#define CSS_CSS_KS7_ks7_ukgsrc(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS7_ks7_ukgsrc_SHIFT)) & CSS_CSS_KS7_ks7_ukgsrc_MASK)

#define CSS_CSS_KS7_ks7_uhwo_MASK                (0x8000000U)
#define CSS_CSS_KS7_ks7_uhwo_SHIFT               (27U)
/*! ks7_uhwo - Hardware out key
 */
#define CSS_CSS_KS7_ks7_uhwo(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS7_ks7_uhwo_SHIFT)) & CSS_CSS_KS7_ks7_uhwo_MASK)

#define CSS_CSS_KS7_ks7_uwrpok_MASK              (0x10000000U)
#define CSS_CSS_KS7_ks7_uwrpok_SHIFT             (28U)
/*! ks7_uwrpok - Ok to wrap key
 */
#define CSS_CSS_KS7_ks7_uwrpok(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS7_ks7_uwrpok_SHIFT)) & CSS_CSS_KS7_ks7_uwrpok_MASK)

#define CSS_CSS_KS7_ks7_uduk_MASK                (0x20000000U)
#define CSS_CSS_KS7_ks7_uduk_SHIFT               (29U)
/*! ks7_uduk - Device Unique Key
 */
#define CSS_CSS_KS7_ks7_uduk(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS7_ks7_uduk_SHIFT)) & CSS_CSS_KS7_ks7_uduk_MASK)

#define CSS_CSS_KS7_ks7_upprot_MASK              (0xC0000000U)
#define CSS_CSS_KS7_ks7_upprot_SHIFT             (30U)
/*! ks7_upprot - Priviledge level
 */
#define CSS_CSS_KS7_ks7_upprot(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS7_ks7_upprot_SHIFT)) & CSS_CSS_KS7_ks7_upprot_MASK)
/*! @} */

/*! @name CSS_KS8 - Status register */
/*! @{ */

#define CSS_CSS_KS8_ks8_ksize_MASK               (0x1U)
#define CSS_CSS_KS8_ks8_ksize_SHIFT              (0U)
/*! ks8_ksize - Key size: 0-128, 1-256
 */
#define CSS_CSS_KS8_ks8_ksize(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS8_ks8_ksize_SHIFT)) & CSS_CSS_KS8_ks8_ksize_MASK)

#define CSS_CSS_KS8_ks8_rsvd0_MASK               (0x1EU)
#define CSS_CSS_KS8_ks8_rsvd0_SHIFT              (1U)
/*! ks8_rsvd0 - Reserved 0
 */
#define CSS_CSS_KS8_ks8_rsvd0(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS8_ks8_rsvd0_SHIFT)) & CSS_CSS_KS8_ks8_rsvd0_MASK)

#define CSS_CSS_KS8_ks8_kact_MASK                (0x20U)
#define CSS_CSS_KS8_ks8_kact_SHIFT               (5U)
/*! ks8_kact - Key is active
 */
#define CSS_CSS_KS8_ks8_kact(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS8_ks8_kact_SHIFT)) & CSS_CSS_KS8_ks8_kact_MASK)

#define CSS_CSS_KS8_ks8_kbase_MASK               (0x40U)
#define CSS_CSS_KS8_ks8_kbase_SHIFT              (6U)
/*! ks8_kbase - First slot in a multislot key
 */
#define CSS_CSS_KS8_ks8_kbase(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS8_ks8_kbase_SHIFT)) & CSS_CSS_KS8_ks8_kbase_MASK)

#define CSS_CSS_KS8_ks8_fgp_MASK                 (0x80U)
#define CSS_CSS_KS8_ks8_fgp_SHIFT                (7U)
/*! ks8_fgp - Hardware Feature General Purpose
 */
#define CSS_CSS_KS8_ks8_fgp(x)                   (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS8_ks8_fgp_SHIFT)) & CSS_CSS_KS8_ks8_fgp_MASK)

#define CSS_CSS_KS8_ks8_frtn_MASK                (0x100U)
#define CSS_CSS_KS8_ks8_frtn_SHIFT               (8U)
/*! ks8_frtn - Hardware Feature Retention
 */
#define CSS_CSS_KS8_ks8_frtn(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS8_ks8_frtn_SHIFT)) & CSS_CSS_KS8_ks8_frtn_MASK)

#define CSS_CSS_KS8_ks8_fhwo_MASK                (0x200U)
#define CSS_CSS_KS8_ks8_fhwo_SHIFT               (9U)
/*! ks8_fhwo - Hardware Feature Output
 */
#define CSS_CSS_KS8_ks8_fhwo(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS8_ks8_fhwo_SHIFT)) & CSS_CSS_KS8_ks8_fhwo_MASK)

#define CSS_CSS_KS8_ks8_rsvd1_MASK               (0x1C00U)
#define CSS_CSS_KS8_ks8_rsvd1_SHIFT              (10U)
/*! ks8_rsvd1 - Reserved 1
 */
#define CSS_CSS_KS8_ks8_rsvd1(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS8_ks8_rsvd1_SHIFT)) & CSS_CSS_KS8_ks8_rsvd1_MASK)

#define CSS_CSS_KS8_ks8_ucmac_MASK               (0x2000U)
#define CSS_CSS_KS8_ks8_ucmac_SHIFT              (13U)
/*! ks8_ucmac - CMAC key
 */
#define CSS_CSS_KS8_ks8_ucmac(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS8_ks8_ucmac_SHIFT)) & CSS_CSS_KS8_ks8_ucmac_MASK)

#define CSS_CSS_KS8_ks8_uksk_MASK                (0x4000U)
#define CSS_CSS_KS8_ks8_uksk_SHIFT               (14U)
/*! ks8_uksk - KSK key
 */
#define CSS_CSS_KS8_ks8_uksk(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS8_ks8_uksk_SHIFT)) & CSS_CSS_KS8_ks8_uksk_MASK)

#define CSS_CSS_KS8_ks8_urtf_MASK                (0x8000U)
#define CSS_CSS_KS8_ks8_urtf_SHIFT               (15U)
/*! ks8_urtf - Real Time Fingerprint key
 */
#define CSS_CSS_KS8_ks8_urtf(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS8_ks8_urtf_SHIFT)) & CSS_CSS_KS8_ks8_urtf_MASK)

#define CSS_CSS_KS8_ks8_uckdf_MASK               (0x10000U)
#define CSS_CSS_KS8_ks8_uckdf_SHIFT              (16U)
/*! ks8_uckdf - Derivation key for CKDF command
 */
#define CSS_CSS_KS8_ks8_uckdf(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS8_ks8_uckdf_SHIFT)) & CSS_CSS_KS8_ks8_uckdf_MASK)

#define CSS_CSS_KS8_ks8_uhkdf_MASK               (0x20000U)
#define CSS_CSS_KS8_ks8_uhkdf_SHIFT              (17U)
/*! ks8_uhkdf - Derivation key for HKDF command
 */
#define CSS_CSS_KS8_ks8_uhkdf(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS8_ks8_uhkdf_SHIFT)) & CSS_CSS_KS8_ks8_uhkdf_MASK)

#define CSS_CSS_KS8_ks8_uecsg_MASK               (0x40000U)
#define CSS_CSS_KS8_ks8_uecsg_SHIFT              (18U)
/*! ks8_uecsg - Ecc signing key
 */
#define CSS_CSS_KS8_ks8_uecsg(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS8_ks8_uecsg_SHIFT)) & CSS_CSS_KS8_ks8_uecsg_MASK)

#define CSS_CSS_KS8_ks8_uecdh_MASK               (0x80000U)
#define CSS_CSS_KS8_ks8_uecdh_SHIFT              (19U)
/*! ks8_uecdh - Ecc diffie hellman key
 */
#define CSS_CSS_KS8_ks8_uecdh(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS8_ks8_uecdh_SHIFT)) & CSS_CSS_KS8_ks8_uecdh_MASK)

#define CSS_CSS_KS8_ks8_uaes_MASK                (0x100000U)
#define CSS_CSS_KS8_ks8_uaes_SHIFT               (20U)
/*! ks8_uaes - Aes key
 */
#define CSS_CSS_KS8_ks8_uaes(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS8_ks8_uaes_SHIFT)) & CSS_CSS_KS8_ks8_uaes_MASK)

#define CSS_CSS_KS8_ks8_uhmac_MASK               (0x200000U)
#define CSS_CSS_KS8_ks8_uhmac_SHIFT              (21U)
/*! ks8_uhmac - Hmac key
 */
#define CSS_CSS_KS8_ks8_uhmac(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS8_ks8_uhmac_SHIFT)) & CSS_CSS_KS8_ks8_uhmac_MASK)

#define CSS_CSS_KS8_ks8_ukwk_MASK                (0x400000U)
#define CSS_CSS_KS8_ks8_ukwk_SHIFT               (22U)
/*! ks8_ukwk - Key wrapping key
 */
#define CSS_CSS_KS8_ks8_ukwk(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS8_ks8_ukwk_SHIFT)) & CSS_CSS_KS8_ks8_ukwk_MASK)

#define CSS_CSS_KS8_ks8_ukuok_MASK               (0x800000U)
#define CSS_CSS_KS8_ks8_ukuok_SHIFT              (23U)
/*! ks8_ukuok - Key unwrapping key
 */
#define CSS_CSS_KS8_ks8_ukuok(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS8_ks8_ukuok_SHIFT)) & CSS_CSS_KS8_ks8_ukuok_MASK)

#define CSS_CSS_KS8_ks8_utlspms_MASK             (0x1000000U)
#define CSS_CSS_KS8_ks8_utlspms_SHIFT            (24U)
/*! ks8_utlspms - TLS Pre Master Secret
 */
#define CSS_CSS_KS8_ks8_utlspms(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS8_ks8_utlspms_SHIFT)) & CSS_CSS_KS8_ks8_utlspms_MASK)

#define CSS_CSS_KS8_ks8_utlsms_MASK              (0x2000000U)
#define CSS_CSS_KS8_ks8_utlsms_SHIFT             (25U)
/*! ks8_utlsms - TLS Master Secret
 */
#define CSS_CSS_KS8_ks8_utlsms(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS8_ks8_utlsms_SHIFT)) & CSS_CSS_KS8_ks8_utlsms_MASK)

#define CSS_CSS_KS8_ks8_ukgsrc_MASK              (0x4000000U)
#define CSS_CSS_KS8_ks8_ukgsrc_SHIFT             (26U)
/*! ks8_ukgsrc - Supply KEYGEN source
 */
#define CSS_CSS_KS8_ks8_ukgsrc(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS8_ks8_ukgsrc_SHIFT)) & CSS_CSS_KS8_ks8_ukgsrc_MASK)

#define CSS_CSS_KS8_ks8_uhwo_MASK                (0x8000000U)
#define CSS_CSS_KS8_ks8_uhwo_SHIFT               (27U)
/*! ks8_uhwo - Hardware out key
 */
#define CSS_CSS_KS8_ks8_uhwo(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS8_ks8_uhwo_SHIFT)) & CSS_CSS_KS8_ks8_uhwo_MASK)

#define CSS_CSS_KS8_ks8_uwrpok_MASK              (0x10000000U)
#define CSS_CSS_KS8_ks8_uwrpok_SHIFT             (28U)
/*! ks8_uwrpok - Ok to wrap key
 */
#define CSS_CSS_KS8_ks8_uwrpok(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS8_ks8_uwrpok_SHIFT)) & CSS_CSS_KS8_ks8_uwrpok_MASK)

#define CSS_CSS_KS8_ks8_uduk_MASK                (0x20000000U)
#define CSS_CSS_KS8_ks8_uduk_SHIFT               (29U)
/*! ks8_uduk - Device Unique Key
 */
#define CSS_CSS_KS8_ks8_uduk(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS8_ks8_uduk_SHIFT)) & CSS_CSS_KS8_ks8_uduk_MASK)

#define CSS_CSS_KS8_ks8_upprot_MASK              (0xC0000000U)
#define CSS_CSS_KS8_ks8_upprot_SHIFT             (30U)
/*! ks8_upprot - Priviledge level
 */
#define CSS_CSS_KS8_ks8_upprot(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS8_ks8_upprot_SHIFT)) & CSS_CSS_KS8_ks8_upprot_MASK)
/*! @} */

/*! @name CSS_KS9 - Status register */
/*! @{ */

#define CSS_CSS_KS9_ks9_ksize_MASK               (0x1U)
#define CSS_CSS_KS9_ks9_ksize_SHIFT              (0U)
/*! ks9_ksize - Key size: 0-128, 1-256
 */
#define CSS_CSS_KS9_ks9_ksize(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS9_ks9_ksize_SHIFT)) & CSS_CSS_KS9_ks9_ksize_MASK)

#define CSS_CSS_KS9_ks9_rsvd0_MASK               (0x1EU)
#define CSS_CSS_KS9_ks9_rsvd0_SHIFT              (1U)
/*! ks9_rsvd0 - Reserved 0
 */
#define CSS_CSS_KS9_ks9_rsvd0(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS9_ks9_rsvd0_SHIFT)) & CSS_CSS_KS9_ks9_rsvd0_MASK)

#define CSS_CSS_KS9_ks9_kact_MASK                (0x20U)
#define CSS_CSS_KS9_ks9_kact_SHIFT               (5U)
/*! ks9_kact - Key is active
 */
#define CSS_CSS_KS9_ks9_kact(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS9_ks9_kact_SHIFT)) & CSS_CSS_KS9_ks9_kact_MASK)

#define CSS_CSS_KS9_ks9_kbase_MASK               (0x40U)
#define CSS_CSS_KS9_ks9_kbase_SHIFT              (6U)
/*! ks9_kbase - First slot in a multislot key
 */
#define CSS_CSS_KS9_ks9_kbase(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS9_ks9_kbase_SHIFT)) & CSS_CSS_KS9_ks9_kbase_MASK)

#define CSS_CSS_KS9_ks9_fgp_MASK                 (0x80U)
#define CSS_CSS_KS9_ks9_fgp_SHIFT                (7U)
/*! ks9_fgp - Hardware Feature General Purpose
 */
#define CSS_CSS_KS9_ks9_fgp(x)                   (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS9_ks9_fgp_SHIFT)) & CSS_CSS_KS9_ks9_fgp_MASK)

#define CSS_CSS_KS9_ks9_frtn_MASK                (0x100U)
#define CSS_CSS_KS9_ks9_frtn_SHIFT               (8U)
/*! ks9_frtn - Hardware Feature Retention
 */
#define CSS_CSS_KS9_ks9_frtn(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS9_ks9_frtn_SHIFT)) & CSS_CSS_KS9_ks9_frtn_MASK)

#define CSS_CSS_KS9_ks9_fhwo_MASK                (0x200U)
#define CSS_CSS_KS9_ks9_fhwo_SHIFT               (9U)
/*! ks9_fhwo - Hardware Feature Output
 */
#define CSS_CSS_KS9_ks9_fhwo(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS9_ks9_fhwo_SHIFT)) & CSS_CSS_KS9_ks9_fhwo_MASK)

#define CSS_CSS_KS9_ks9_rsvd1_MASK               (0x1C00U)
#define CSS_CSS_KS9_ks9_rsvd1_SHIFT              (10U)
/*! ks9_rsvd1 - Reserved 1
 */
#define CSS_CSS_KS9_ks9_rsvd1(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS9_ks9_rsvd1_SHIFT)) & CSS_CSS_KS9_ks9_rsvd1_MASK)

#define CSS_CSS_KS9_ks9_ucmac_MASK               (0x2000U)
#define CSS_CSS_KS9_ks9_ucmac_SHIFT              (13U)
/*! ks9_ucmac - CMAC key
 */
#define CSS_CSS_KS9_ks9_ucmac(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS9_ks9_ucmac_SHIFT)) & CSS_CSS_KS9_ks9_ucmac_MASK)

#define CSS_CSS_KS9_ks9_uksk_MASK                (0x4000U)
#define CSS_CSS_KS9_ks9_uksk_SHIFT               (14U)
/*! ks9_uksk - KSK key
 */
#define CSS_CSS_KS9_ks9_uksk(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS9_ks9_uksk_SHIFT)) & CSS_CSS_KS9_ks9_uksk_MASK)

#define CSS_CSS_KS9_ks9_urtf_MASK                (0x8000U)
#define CSS_CSS_KS9_ks9_urtf_SHIFT               (15U)
/*! ks9_urtf - Real Time Fingerprint key
 */
#define CSS_CSS_KS9_ks9_urtf(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS9_ks9_urtf_SHIFT)) & CSS_CSS_KS9_ks9_urtf_MASK)

#define CSS_CSS_KS9_ks9_uckdf_MASK               (0x10000U)
#define CSS_CSS_KS9_ks9_uckdf_SHIFT              (16U)
/*! ks9_uckdf - Derivation key for CKDF command
 */
#define CSS_CSS_KS9_ks9_uckdf(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS9_ks9_uckdf_SHIFT)) & CSS_CSS_KS9_ks9_uckdf_MASK)

#define CSS_CSS_KS9_ks9_uhkdf_MASK               (0x20000U)
#define CSS_CSS_KS9_ks9_uhkdf_SHIFT              (17U)
/*! ks9_uhkdf - Derivation key for HKDF command
 */
#define CSS_CSS_KS9_ks9_uhkdf(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS9_ks9_uhkdf_SHIFT)) & CSS_CSS_KS9_ks9_uhkdf_MASK)

#define CSS_CSS_KS9_ks9_uecsg_MASK               (0x40000U)
#define CSS_CSS_KS9_ks9_uecsg_SHIFT              (18U)
/*! ks9_uecsg - Ecc signing key
 */
#define CSS_CSS_KS9_ks9_uecsg(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS9_ks9_uecsg_SHIFT)) & CSS_CSS_KS9_ks9_uecsg_MASK)

#define CSS_CSS_KS9_ks9_uecdh_MASK               (0x80000U)
#define CSS_CSS_KS9_ks9_uecdh_SHIFT              (19U)
/*! ks9_uecdh - Ecc diffie hellman key
 */
#define CSS_CSS_KS9_ks9_uecdh(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS9_ks9_uecdh_SHIFT)) & CSS_CSS_KS9_ks9_uecdh_MASK)

#define CSS_CSS_KS9_ks9_uaes_MASK                (0x100000U)
#define CSS_CSS_KS9_ks9_uaes_SHIFT               (20U)
/*! ks9_uaes - Aes key
 */
#define CSS_CSS_KS9_ks9_uaes(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS9_ks9_uaes_SHIFT)) & CSS_CSS_KS9_ks9_uaes_MASK)

#define CSS_CSS_KS9_ks9_uhmac_MASK               (0x200000U)
#define CSS_CSS_KS9_ks9_uhmac_SHIFT              (21U)
/*! ks9_uhmac - Hmac key
 */
#define CSS_CSS_KS9_ks9_uhmac(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS9_ks9_uhmac_SHIFT)) & CSS_CSS_KS9_ks9_uhmac_MASK)

#define CSS_CSS_KS9_ks9_ukwk_MASK                (0x400000U)
#define CSS_CSS_KS9_ks9_ukwk_SHIFT               (22U)
/*! ks9_ukwk - Key wrapping key
 */
#define CSS_CSS_KS9_ks9_ukwk(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS9_ks9_ukwk_SHIFT)) & CSS_CSS_KS9_ks9_ukwk_MASK)

#define CSS_CSS_KS9_ks9_ukuok_MASK               (0x800000U)
#define CSS_CSS_KS9_ks9_ukuok_SHIFT              (23U)
/*! ks9_ukuok - Key unwrapping key
 */
#define CSS_CSS_KS9_ks9_ukuok(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS9_ks9_ukuok_SHIFT)) & CSS_CSS_KS9_ks9_ukuok_MASK)

#define CSS_CSS_KS9_ks9_utlspms_MASK             (0x1000000U)
#define CSS_CSS_KS9_ks9_utlspms_SHIFT            (24U)
/*! ks9_utlspms - TLS Pre Master Secret
 */
#define CSS_CSS_KS9_ks9_utlspms(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS9_ks9_utlspms_SHIFT)) & CSS_CSS_KS9_ks9_utlspms_MASK)

#define CSS_CSS_KS9_ks9_utlsms_MASK              (0x2000000U)
#define CSS_CSS_KS9_ks9_utlsms_SHIFT             (25U)
/*! ks9_utlsms - TLS Master Secret
 */
#define CSS_CSS_KS9_ks9_utlsms(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS9_ks9_utlsms_SHIFT)) & CSS_CSS_KS9_ks9_utlsms_MASK)

#define CSS_CSS_KS9_ks9_ukgsrc_MASK              (0x4000000U)
#define CSS_CSS_KS9_ks9_ukgsrc_SHIFT             (26U)
/*! ks9_ukgsrc - Supply KEYGEN source
 */
#define CSS_CSS_KS9_ks9_ukgsrc(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS9_ks9_ukgsrc_SHIFT)) & CSS_CSS_KS9_ks9_ukgsrc_MASK)

#define CSS_CSS_KS9_ks9_uhwo_MASK                (0x8000000U)
#define CSS_CSS_KS9_ks9_uhwo_SHIFT               (27U)
/*! ks9_uhwo - Hardware out key
 */
#define CSS_CSS_KS9_ks9_uhwo(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS9_ks9_uhwo_SHIFT)) & CSS_CSS_KS9_ks9_uhwo_MASK)

#define CSS_CSS_KS9_ks9_uwrpok_MASK              (0x10000000U)
#define CSS_CSS_KS9_ks9_uwrpok_SHIFT             (28U)
/*! ks9_uwrpok - Ok to wrap key
 */
#define CSS_CSS_KS9_ks9_uwrpok(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS9_ks9_uwrpok_SHIFT)) & CSS_CSS_KS9_ks9_uwrpok_MASK)

#define CSS_CSS_KS9_ks9_uduk_MASK                (0x20000000U)
#define CSS_CSS_KS9_ks9_uduk_SHIFT               (29U)
/*! ks9_uduk - Device Unique Key
 */
#define CSS_CSS_KS9_ks9_uduk(x)                  (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS9_ks9_uduk_SHIFT)) & CSS_CSS_KS9_ks9_uduk_MASK)

#define CSS_CSS_KS9_ks9_upprot_MASK              (0xC0000000U)
#define CSS_CSS_KS9_ks9_upprot_SHIFT             (30U)
/*! ks9_upprot - Priviledge level
 */
#define CSS_CSS_KS9_ks9_upprot(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS9_ks9_upprot_SHIFT)) & CSS_CSS_KS9_ks9_upprot_MASK)
/*! @} */

/*! @name CSS_KS10 - Status register */
/*! @{ */

#define CSS_CSS_KS10_ks10_ksize_MASK             (0x1U)
#define CSS_CSS_KS10_ks10_ksize_SHIFT            (0U)
/*! ks10_ksize - Key size: 0-128, 1-256
 */
#define CSS_CSS_KS10_ks10_ksize(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS10_ks10_ksize_SHIFT)) & CSS_CSS_KS10_ks10_ksize_MASK)

#define CSS_CSS_KS10_ks10_rsvd0_MASK             (0x1EU)
#define CSS_CSS_KS10_ks10_rsvd0_SHIFT            (1U)
/*! ks10_rsvd0 - Reserved 0
 */
#define CSS_CSS_KS10_ks10_rsvd0(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS10_ks10_rsvd0_SHIFT)) & CSS_CSS_KS10_ks10_rsvd0_MASK)

#define CSS_CSS_KS10_ks10_kact_MASK              (0x20U)
#define CSS_CSS_KS10_ks10_kact_SHIFT             (5U)
/*! ks10_kact - Key is active
 */
#define CSS_CSS_KS10_ks10_kact(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS10_ks10_kact_SHIFT)) & CSS_CSS_KS10_ks10_kact_MASK)

#define CSS_CSS_KS10_ks10_kbase_MASK             (0x40U)
#define CSS_CSS_KS10_ks10_kbase_SHIFT            (6U)
/*! ks10_kbase - First slot in a multislot key
 */
#define CSS_CSS_KS10_ks10_kbase(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS10_ks10_kbase_SHIFT)) & CSS_CSS_KS10_ks10_kbase_MASK)

#define CSS_CSS_KS10_ks10_fgp_MASK               (0x80U)
#define CSS_CSS_KS10_ks10_fgp_SHIFT              (7U)
/*! ks10_fgp - Hardware Feature General Purpose
 */
#define CSS_CSS_KS10_ks10_fgp(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS10_ks10_fgp_SHIFT)) & CSS_CSS_KS10_ks10_fgp_MASK)

#define CSS_CSS_KS10_ks10_frtn_MASK              (0x100U)
#define CSS_CSS_KS10_ks10_frtn_SHIFT             (8U)
/*! ks10_frtn - Hardware Feature Retention
 */
#define CSS_CSS_KS10_ks10_frtn(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS10_ks10_frtn_SHIFT)) & CSS_CSS_KS10_ks10_frtn_MASK)

#define CSS_CSS_KS10_ks10_fhwo_MASK              (0x200U)
#define CSS_CSS_KS10_ks10_fhwo_SHIFT             (9U)
/*! ks10_fhwo - Hardware Feature Output
 */
#define CSS_CSS_KS10_ks10_fhwo(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS10_ks10_fhwo_SHIFT)) & CSS_CSS_KS10_ks10_fhwo_MASK)

#define CSS_CSS_KS10_ks10_rsvd1_MASK             (0x1C00U)
#define CSS_CSS_KS10_ks10_rsvd1_SHIFT            (10U)
/*! ks10_rsvd1 - Reserved 1
 */
#define CSS_CSS_KS10_ks10_rsvd1(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS10_ks10_rsvd1_SHIFT)) & CSS_CSS_KS10_ks10_rsvd1_MASK)

#define CSS_CSS_KS10_ks10_ucmac_MASK             (0x2000U)
#define CSS_CSS_KS10_ks10_ucmac_SHIFT            (13U)
/*! ks10_ucmac - CMAC key
 */
#define CSS_CSS_KS10_ks10_ucmac(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS10_ks10_ucmac_SHIFT)) & CSS_CSS_KS10_ks10_ucmac_MASK)

#define CSS_CSS_KS10_ks10_uksk_MASK              (0x4000U)
#define CSS_CSS_KS10_ks10_uksk_SHIFT             (14U)
/*! ks10_uksk - KSK key
 */
#define CSS_CSS_KS10_ks10_uksk(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS10_ks10_uksk_SHIFT)) & CSS_CSS_KS10_ks10_uksk_MASK)

#define CSS_CSS_KS10_ks10_urtf_MASK              (0x8000U)
#define CSS_CSS_KS10_ks10_urtf_SHIFT             (15U)
/*! ks10_urtf - Real Time Fingerprint key
 */
#define CSS_CSS_KS10_ks10_urtf(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS10_ks10_urtf_SHIFT)) & CSS_CSS_KS10_ks10_urtf_MASK)

#define CSS_CSS_KS10_ks10_uckdf_MASK             (0x10000U)
#define CSS_CSS_KS10_ks10_uckdf_SHIFT            (16U)
/*! ks10_uckdf - Derivation key for CKDF command
 */
#define CSS_CSS_KS10_ks10_uckdf(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS10_ks10_uckdf_SHIFT)) & CSS_CSS_KS10_ks10_uckdf_MASK)

#define CSS_CSS_KS10_ks10_uhkdf_MASK             (0x20000U)
#define CSS_CSS_KS10_ks10_uhkdf_SHIFT            (17U)
/*! ks10_uhkdf - Derivation key for HKDF command
 */
#define CSS_CSS_KS10_ks10_uhkdf(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS10_ks10_uhkdf_SHIFT)) & CSS_CSS_KS10_ks10_uhkdf_MASK)

#define CSS_CSS_KS10_ks10_uecsg_MASK             (0x40000U)
#define CSS_CSS_KS10_ks10_uecsg_SHIFT            (18U)
/*! ks10_uecsg - Ecc signing key
 */
#define CSS_CSS_KS10_ks10_uecsg(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS10_ks10_uecsg_SHIFT)) & CSS_CSS_KS10_ks10_uecsg_MASK)

#define CSS_CSS_KS10_ks10_uecdh_MASK             (0x80000U)
#define CSS_CSS_KS10_ks10_uecdh_SHIFT            (19U)
/*! ks10_uecdh - Ecc diffie hellman key
 */
#define CSS_CSS_KS10_ks10_uecdh(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS10_ks10_uecdh_SHIFT)) & CSS_CSS_KS10_ks10_uecdh_MASK)

#define CSS_CSS_KS10_ks10_uaes_MASK              (0x100000U)
#define CSS_CSS_KS10_ks10_uaes_SHIFT             (20U)
/*! ks10_uaes - Aes key
 */
#define CSS_CSS_KS10_ks10_uaes(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS10_ks10_uaes_SHIFT)) & CSS_CSS_KS10_ks10_uaes_MASK)

#define CSS_CSS_KS10_ks10_uhmac_MASK             (0x200000U)
#define CSS_CSS_KS10_ks10_uhmac_SHIFT            (21U)
/*! ks10_uhmac - Hmac key
 */
#define CSS_CSS_KS10_ks10_uhmac(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS10_ks10_uhmac_SHIFT)) & CSS_CSS_KS10_ks10_uhmac_MASK)

#define CSS_CSS_KS10_ks10_ukwk_MASK              (0x400000U)
#define CSS_CSS_KS10_ks10_ukwk_SHIFT             (22U)
/*! ks10_ukwk - Key wrapping key
 */
#define CSS_CSS_KS10_ks10_ukwk(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS10_ks10_ukwk_SHIFT)) & CSS_CSS_KS10_ks10_ukwk_MASK)

#define CSS_CSS_KS10_ks10_ukuok_MASK             (0x800000U)
#define CSS_CSS_KS10_ks10_ukuok_SHIFT            (23U)
/*! ks10_ukuok - Key unwrapping key
 */
#define CSS_CSS_KS10_ks10_ukuok(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS10_ks10_ukuok_SHIFT)) & CSS_CSS_KS10_ks10_ukuok_MASK)

#define CSS_CSS_KS10_ks10_utlspms_MASK           (0x1000000U)
#define CSS_CSS_KS10_ks10_utlspms_SHIFT          (24U)
/*! ks10_utlspms - TLS Pre Master Secret
 */
#define CSS_CSS_KS10_ks10_utlspms(x)             (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS10_ks10_utlspms_SHIFT)) & CSS_CSS_KS10_ks10_utlspms_MASK)

#define CSS_CSS_KS10_ks10_utlsms_MASK            (0x2000000U)
#define CSS_CSS_KS10_ks10_utlsms_SHIFT           (25U)
/*! ks10_utlsms - TLS Master Secret
 */
#define CSS_CSS_KS10_ks10_utlsms(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS10_ks10_utlsms_SHIFT)) & CSS_CSS_KS10_ks10_utlsms_MASK)

#define CSS_CSS_KS10_ks10_ukgsrc_MASK            (0x4000000U)
#define CSS_CSS_KS10_ks10_ukgsrc_SHIFT           (26U)
/*! ks10_ukgsrc - Supply KEYGEN source
 */
#define CSS_CSS_KS10_ks10_ukgsrc(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS10_ks10_ukgsrc_SHIFT)) & CSS_CSS_KS10_ks10_ukgsrc_MASK)

#define CSS_CSS_KS10_ks10_uhwo_MASK              (0x8000000U)
#define CSS_CSS_KS10_ks10_uhwo_SHIFT             (27U)
/*! ks10_uhwo - Hardware out key
 */
#define CSS_CSS_KS10_ks10_uhwo(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS10_ks10_uhwo_SHIFT)) & CSS_CSS_KS10_ks10_uhwo_MASK)

#define CSS_CSS_KS10_ks10_uwrpok_MASK            (0x10000000U)
#define CSS_CSS_KS10_ks10_uwrpok_SHIFT           (28U)
/*! ks10_uwrpok - Ok to wrap key
 */
#define CSS_CSS_KS10_ks10_uwrpok(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS10_ks10_uwrpok_SHIFT)) & CSS_CSS_KS10_ks10_uwrpok_MASK)

#define CSS_CSS_KS10_ks10_uduk_MASK              (0x20000000U)
#define CSS_CSS_KS10_ks10_uduk_SHIFT             (29U)
/*! ks10_uduk - Device Unique Key
 */
#define CSS_CSS_KS10_ks10_uduk(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS10_ks10_uduk_SHIFT)) & CSS_CSS_KS10_ks10_uduk_MASK)

#define CSS_CSS_KS10_ks10_upprot_MASK            (0xC0000000U)
#define CSS_CSS_KS10_ks10_upprot_SHIFT           (30U)
/*! ks10_upprot - Priviledge level
 */
#define CSS_CSS_KS10_ks10_upprot(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS10_ks10_upprot_SHIFT)) & CSS_CSS_KS10_ks10_upprot_MASK)
/*! @} */

/*! @name CSS_KS11 - Status register */
/*! @{ */

#define CSS_CSS_KS11_ks11_ksize_MASK             (0x1U)
#define CSS_CSS_KS11_ks11_ksize_SHIFT            (0U)
/*! ks11_ksize - Key size: 0-128, 1-256
 */
#define CSS_CSS_KS11_ks11_ksize(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS11_ks11_ksize_SHIFT)) & CSS_CSS_KS11_ks11_ksize_MASK)

#define CSS_CSS_KS11_ks11_rsvd0_MASK             (0x1EU)
#define CSS_CSS_KS11_ks11_rsvd0_SHIFT            (1U)
/*! ks11_rsvd0 - Reserved 0
 */
#define CSS_CSS_KS11_ks11_rsvd0(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS11_ks11_rsvd0_SHIFT)) & CSS_CSS_KS11_ks11_rsvd0_MASK)

#define CSS_CSS_KS11_ks11_kact_MASK              (0x20U)
#define CSS_CSS_KS11_ks11_kact_SHIFT             (5U)
/*! ks11_kact - Key is active
 */
#define CSS_CSS_KS11_ks11_kact(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS11_ks11_kact_SHIFT)) & CSS_CSS_KS11_ks11_kact_MASK)

#define CSS_CSS_KS11_ks11_kbase_MASK             (0x40U)
#define CSS_CSS_KS11_ks11_kbase_SHIFT            (6U)
/*! ks11_kbase - First slot in a multislot key
 */
#define CSS_CSS_KS11_ks11_kbase(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS11_ks11_kbase_SHIFT)) & CSS_CSS_KS11_ks11_kbase_MASK)

#define CSS_CSS_KS11_ks11_fgp_MASK               (0x80U)
#define CSS_CSS_KS11_ks11_fgp_SHIFT              (7U)
/*! ks11_fgp - Hardware Feature General Purpose
 */
#define CSS_CSS_KS11_ks11_fgp(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS11_ks11_fgp_SHIFT)) & CSS_CSS_KS11_ks11_fgp_MASK)

#define CSS_CSS_KS11_ks11_frtn_MASK              (0x100U)
#define CSS_CSS_KS11_ks11_frtn_SHIFT             (8U)
/*! ks11_frtn - Hardware Feature Retention
 */
#define CSS_CSS_KS11_ks11_frtn(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS11_ks11_frtn_SHIFT)) & CSS_CSS_KS11_ks11_frtn_MASK)

#define CSS_CSS_KS11_ks11_fhwo_MASK              (0x200U)
#define CSS_CSS_KS11_ks11_fhwo_SHIFT             (9U)
/*! ks11_fhwo - Hardware Feature Output
 */
#define CSS_CSS_KS11_ks11_fhwo(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS11_ks11_fhwo_SHIFT)) & CSS_CSS_KS11_ks11_fhwo_MASK)

#define CSS_CSS_KS11_ks11_rsvd1_MASK             (0x1C00U)
#define CSS_CSS_KS11_ks11_rsvd1_SHIFT            (10U)
/*! ks11_rsvd1 - Reserved 1
 */
#define CSS_CSS_KS11_ks11_rsvd1(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS11_ks11_rsvd1_SHIFT)) & CSS_CSS_KS11_ks11_rsvd1_MASK)

#define CSS_CSS_KS11_ks11_ucmac_MASK             (0x2000U)
#define CSS_CSS_KS11_ks11_ucmac_SHIFT            (13U)
/*! ks11_ucmac - CMAC key
 */
#define CSS_CSS_KS11_ks11_ucmac(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS11_ks11_ucmac_SHIFT)) & CSS_CSS_KS11_ks11_ucmac_MASK)

#define CSS_CSS_KS11_ks11_uksk_MASK              (0x4000U)
#define CSS_CSS_KS11_ks11_uksk_SHIFT             (14U)
/*! ks11_uksk - KSK key
 */
#define CSS_CSS_KS11_ks11_uksk(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS11_ks11_uksk_SHIFT)) & CSS_CSS_KS11_ks11_uksk_MASK)

#define CSS_CSS_KS11_ks11_urtf_MASK              (0x8000U)
#define CSS_CSS_KS11_ks11_urtf_SHIFT             (15U)
/*! ks11_urtf - Real Time Fingerprint key
 */
#define CSS_CSS_KS11_ks11_urtf(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS11_ks11_urtf_SHIFT)) & CSS_CSS_KS11_ks11_urtf_MASK)

#define CSS_CSS_KS11_ks11_uckdf_MASK             (0x10000U)
#define CSS_CSS_KS11_ks11_uckdf_SHIFT            (16U)
/*! ks11_uckdf - Derivation key for CKDF command
 */
#define CSS_CSS_KS11_ks11_uckdf(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS11_ks11_uckdf_SHIFT)) & CSS_CSS_KS11_ks11_uckdf_MASK)

#define CSS_CSS_KS11_ks11_uhkdf_MASK             (0x20000U)
#define CSS_CSS_KS11_ks11_uhkdf_SHIFT            (17U)
/*! ks11_uhkdf - Derivation key for HKDF command
 */
#define CSS_CSS_KS11_ks11_uhkdf(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS11_ks11_uhkdf_SHIFT)) & CSS_CSS_KS11_ks11_uhkdf_MASK)

#define CSS_CSS_KS11_ks11_uecsg_MASK             (0x40000U)
#define CSS_CSS_KS11_ks11_uecsg_SHIFT            (18U)
/*! ks11_uecsg - Ecc signing key
 */
#define CSS_CSS_KS11_ks11_uecsg(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS11_ks11_uecsg_SHIFT)) & CSS_CSS_KS11_ks11_uecsg_MASK)

#define CSS_CSS_KS11_ks11_uecdh_MASK             (0x80000U)
#define CSS_CSS_KS11_ks11_uecdh_SHIFT            (19U)
/*! ks11_uecdh - Ecc diffie hellman key
 */
#define CSS_CSS_KS11_ks11_uecdh(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS11_ks11_uecdh_SHIFT)) & CSS_CSS_KS11_ks11_uecdh_MASK)

#define CSS_CSS_KS11_ks11_uaes_MASK              (0x100000U)
#define CSS_CSS_KS11_ks11_uaes_SHIFT             (20U)
/*! ks11_uaes - Aes key
 */
#define CSS_CSS_KS11_ks11_uaes(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS11_ks11_uaes_SHIFT)) & CSS_CSS_KS11_ks11_uaes_MASK)

#define CSS_CSS_KS11_ks11_uhmac_MASK             (0x200000U)
#define CSS_CSS_KS11_ks11_uhmac_SHIFT            (21U)
/*! ks11_uhmac - Hmac key
 */
#define CSS_CSS_KS11_ks11_uhmac(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS11_ks11_uhmac_SHIFT)) & CSS_CSS_KS11_ks11_uhmac_MASK)

#define CSS_CSS_KS11_ks11_ukwk_MASK              (0x400000U)
#define CSS_CSS_KS11_ks11_ukwk_SHIFT             (22U)
/*! ks11_ukwk - Key wrapping key
 */
#define CSS_CSS_KS11_ks11_ukwk(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS11_ks11_ukwk_SHIFT)) & CSS_CSS_KS11_ks11_ukwk_MASK)

#define CSS_CSS_KS11_ks11_ukuok_MASK             (0x800000U)
#define CSS_CSS_KS11_ks11_ukuok_SHIFT            (23U)
/*! ks11_ukuok - Key unwrapping key
 */
#define CSS_CSS_KS11_ks11_ukuok(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS11_ks11_ukuok_SHIFT)) & CSS_CSS_KS11_ks11_ukuok_MASK)

#define CSS_CSS_KS11_ks11_utlspms_MASK           (0x1000000U)
#define CSS_CSS_KS11_ks11_utlspms_SHIFT          (24U)
/*! ks11_utlspms - TLS Pre Master Secret
 */
#define CSS_CSS_KS11_ks11_utlspms(x)             (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS11_ks11_utlspms_SHIFT)) & CSS_CSS_KS11_ks11_utlspms_MASK)

#define CSS_CSS_KS11_ks11_utlsms_MASK            (0x2000000U)
#define CSS_CSS_KS11_ks11_utlsms_SHIFT           (25U)
/*! ks11_utlsms - TLS Master Secret
 */
#define CSS_CSS_KS11_ks11_utlsms(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS11_ks11_utlsms_SHIFT)) & CSS_CSS_KS11_ks11_utlsms_MASK)

#define CSS_CSS_KS11_ks11_ukgsrc_MASK            (0x4000000U)
#define CSS_CSS_KS11_ks11_ukgsrc_SHIFT           (26U)
/*! ks11_ukgsrc - Supply KEYGEN source
 */
#define CSS_CSS_KS11_ks11_ukgsrc(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS11_ks11_ukgsrc_SHIFT)) & CSS_CSS_KS11_ks11_ukgsrc_MASK)

#define CSS_CSS_KS11_ks11_uhwo_MASK              (0x8000000U)
#define CSS_CSS_KS11_ks11_uhwo_SHIFT             (27U)
/*! ks11_uhwo - Hardware out key
 */
#define CSS_CSS_KS11_ks11_uhwo(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS11_ks11_uhwo_SHIFT)) & CSS_CSS_KS11_ks11_uhwo_MASK)

#define CSS_CSS_KS11_ks11_uwrpok_MASK            (0x10000000U)
#define CSS_CSS_KS11_ks11_uwrpok_SHIFT           (28U)
/*! ks11_uwrpok - Ok to wrap key
 */
#define CSS_CSS_KS11_ks11_uwrpok(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS11_ks11_uwrpok_SHIFT)) & CSS_CSS_KS11_ks11_uwrpok_MASK)

#define CSS_CSS_KS11_ks11_uduk_MASK              (0x20000000U)
#define CSS_CSS_KS11_ks11_uduk_SHIFT             (29U)
/*! ks11_uduk - Device Unique Key
 */
#define CSS_CSS_KS11_ks11_uduk(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS11_ks11_uduk_SHIFT)) & CSS_CSS_KS11_ks11_uduk_MASK)

#define CSS_CSS_KS11_ks11_upprot_MASK            (0xC0000000U)
#define CSS_CSS_KS11_ks11_upprot_SHIFT           (30U)
/*! ks11_upprot - Priviledge level
 */
#define CSS_CSS_KS11_ks11_upprot(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS11_ks11_upprot_SHIFT)) & CSS_CSS_KS11_ks11_upprot_MASK)
/*! @} */

/*! @name CSS_KS12 - Status register */
/*! @{ */

#define CSS_CSS_KS12_ks12_ksize_MASK             (0x1U)
#define CSS_CSS_KS12_ks12_ksize_SHIFT            (0U)
/*! ks12_ksize - Key size: 0-128, 1-256
 */
#define CSS_CSS_KS12_ks12_ksize(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS12_ks12_ksize_SHIFT)) & CSS_CSS_KS12_ks12_ksize_MASK)

#define CSS_CSS_KS12_ks12_rsvd0_MASK             (0x1EU)
#define CSS_CSS_KS12_ks12_rsvd0_SHIFT            (1U)
/*! ks12_rsvd0 - Reserved 0
 */
#define CSS_CSS_KS12_ks12_rsvd0(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS12_ks12_rsvd0_SHIFT)) & CSS_CSS_KS12_ks12_rsvd0_MASK)

#define CSS_CSS_KS12_ks12_kact_MASK              (0x20U)
#define CSS_CSS_KS12_ks12_kact_SHIFT             (5U)
/*! ks12_kact - Key is active
 */
#define CSS_CSS_KS12_ks12_kact(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS12_ks12_kact_SHIFT)) & CSS_CSS_KS12_ks12_kact_MASK)

#define CSS_CSS_KS12_ks12_kbase_MASK             (0x40U)
#define CSS_CSS_KS12_ks12_kbase_SHIFT            (6U)
/*! ks12_kbase - First slot in a multislot key
 */
#define CSS_CSS_KS12_ks12_kbase(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS12_ks12_kbase_SHIFT)) & CSS_CSS_KS12_ks12_kbase_MASK)

#define CSS_CSS_KS12_ks12_fgp_MASK               (0x80U)
#define CSS_CSS_KS12_ks12_fgp_SHIFT              (7U)
/*! ks12_fgp - Hardware Feature General Purpose
 */
#define CSS_CSS_KS12_ks12_fgp(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS12_ks12_fgp_SHIFT)) & CSS_CSS_KS12_ks12_fgp_MASK)

#define CSS_CSS_KS12_ks12_frtn_MASK              (0x100U)
#define CSS_CSS_KS12_ks12_frtn_SHIFT             (8U)
/*! ks12_frtn - Hardware Feature Retention
 */
#define CSS_CSS_KS12_ks12_frtn(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS12_ks12_frtn_SHIFT)) & CSS_CSS_KS12_ks12_frtn_MASK)

#define CSS_CSS_KS12_ks12_fhwo_MASK              (0x200U)
#define CSS_CSS_KS12_ks12_fhwo_SHIFT             (9U)
/*! ks12_fhwo - Hardware Feature Output
 */
#define CSS_CSS_KS12_ks12_fhwo(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS12_ks12_fhwo_SHIFT)) & CSS_CSS_KS12_ks12_fhwo_MASK)

#define CSS_CSS_KS12_ks12_rsvd1_MASK             (0x1C00U)
#define CSS_CSS_KS12_ks12_rsvd1_SHIFT            (10U)
/*! ks12_rsvd1 - Reserved 1
 */
#define CSS_CSS_KS12_ks12_rsvd1(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS12_ks12_rsvd1_SHIFT)) & CSS_CSS_KS12_ks12_rsvd1_MASK)

#define CSS_CSS_KS12_ks12_ucmac_MASK             (0x2000U)
#define CSS_CSS_KS12_ks12_ucmac_SHIFT            (13U)
/*! ks12_ucmac - CMAC key
 */
#define CSS_CSS_KS12_ks12_ucmac(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS12_ks12_ucmac_SHIFT)) & CSS_CSS_KS12_ks12_ucmac_MASK)

#define CSS_CSS_KS12_ks12_uksk_MASK              (0x4000U)
#define CSS_CSS_KS12_ks12_uksk_SHIFT             (14U)
/*! ks12_uksk - KSK key
 */
#define CSS_CSS_KS12_ks12_uksk(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS12_ks12_uksk_SHIFT)) & CSS_CSS_KS12_ks12_uksk_MASK)

#define CSS_CSS_KS12_ks12_urtf_MASK              (0x8000U)
#define CSS_CSS_KS12_ks12_urtf_SHIFT             (15U)
/*! ks12_urtf - Real Time Fingerprint key
 */
#define CSS_CSS_KS12_ks12_urtf(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS12_ks12_urtf_SHIFT)) & CSS_CSS_KS12_ks12_urtf_MASK)

#define CSS_CSS_KS12_ks12_uckdf_MASK             (0x10000U)
#define CSS_CSS_KS12_ks12_uckdf_SHIFT            (16U)
/*! ks12_uckdf - Derivation key for CKDF command
 */
#define CSS_CSS_KS12_ks12_uckdf(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS12_ks12_uckdf_SHIFT)) & CSS_CSS_KS12_ks12_uckdf_MASK)

#define CSS_CSS_KS12_ks12_uhkdf_MASK             (0x20000U)
#define CSS_CSS_KS12_ks12_uhkdf_SHIFT            (17U)
/*! ks12_uhkdf - Derivation key for HKDF command
 */
#define CSS_CSS_KS12_ks12_uhkdf(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS12_ks12_uhkdf_SHIFT)) & CSS_CSS_KS12_ks12_uhkdf_MASK)

#define CSS_CSS_KS12_ks12_uecsg_MASK             (0x40000U)
#define CSS_CSS_KS12_ks12_uecsg_SHIFT            (18U)
/*! ks12_uecsg - Ecc signing key
 */
#define CSS_CSS_KS12_ks12_uecsg(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS12_ks12_uecsg_SHIFT)) & CSS_CSS_KS12_ks12_uecsg_MASK)

#define CSS_CSS_KS12_ks12_uecdh_MASK             (0x80000U)
#define CSS_CSS_KS12_ks12_uecdh_SHIFT            (19U)
/*! ks12_uecdh - Ecc diffie hellman key
 */
#define CSS_CSS_KS12_ks12_uecdh(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS12_ks12_uecdh_SHIFT)) & CSS_CSS_KS12_ks12_uecdh_MASK)

#define CSS_CSS_KS12_ks12_uaes_MASK              (0x100000U)
#define CSS_CSS_KS12_ks12_uaes_SHIFT             (20U)
/*! ks12_uaes - Aes key
 */
#define CSS_CSS_KS12_ks12_uaes(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS12_ks12_uaes_SHIFT)) & CSS_CSS_KS12_ks12_uaes_MASK)

#define CSS_CSS_KS12_ks12_uhmac_MASK             (0x200000U)
#define CSS_CSS_KS12_ks12_uhmac_SHIFT            (21U)
/*! ks12_uhmac - Hmac key
 */
#define CSS_CSS_KS12_ks12_uhmac(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS12_ks12_uhmac_SHIFT)) & CSS_CSS_KS12_ks12_uhmac_MASK)

#define CSS_CSS_KS12_ks12_ukwk_MASK              (0x400000U)
#define CSS_CSS_KS12_ks12_ukwk_SHIFT             (22U)
/*! ks12_ukwk - Key wrapping key
 */
#define CSS_CSS_KS12_ks12_ukwk(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS12_ks12_ukwk_SHIFT)) & CSS_CSS_KS12_ks12_ukwk_MASK)

#define CSS_CSS_KS12_ks12_ukuok_MASK             (0x800000U)
#define CSS_CSS_KS12_ks12_ukuok_SHIFT            (23U)
/*! ks12_ukuok - Key unwrapping key
 */
#define CSS_CSS_KS12_ks12_ukuok(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS12_ks12_ukuok_SHIFT)) & CSS_CSS_KS12_ks12_ukuok_MASK)

#define CSS_CSS_KS12_ks12_utlspms_MASK           (0x1000000U)
#define CSS_CSS_KS12_ks12_utlspms_SHIFT          (24U)
/*! ks12_utlspms - TLS Pre Master Secret
 */
#define CSS_CSS_KS12_ks12_utlspms(x)             (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS12_ks12_utlspms_SHIFT)) & CSS_CSS_KS12_ks12_utlspms_MASK)

#define CSS_CSS_KS12_ks12_utlsms_MASK            (0x2000000U)
#define CSS_CSS_KS12_ks12_utlsms_SHIFT           (25U)
/*! ks12_utlsms - TLS Master Secret
 */
#define CSS_CSS_KS12_ks12_utlsms(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS12_ks12_utlsms_SHIFT)) & CSS_CSS_KS12_ks12_utlsms_MASK)

#define CSS_CSS_KS12_ks12_ukgsrc_MASK            (0x4000000U)
#define CSS_CSS_KS12_ks12_ukgsrc_SHIFT           (26U)
/*! ks12_ukgsrc - Supply KEYGEN source
 */
#define CSS_CSS_KS12_ks12_ukgsrc(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS12_ks12_ukgsrc_SHIFT)) & CSS_CSS_KS12_ks12_ukgsrc_MASK)

#define CSS_CSS_KS12_ks12_uhwo_MASK              (0x8000000U)
#define CSS_CSS_KS12_ks12_uhwo_SHIFT             (27U)
/*! ks12_uhwo - Hardware out key
 */
#define CSS_CSS_KS12_ks12_uhwo(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS12_ks12_uhwo_SHIFT)) & CSS_CSS_KS12_ks12_uhwo_MASK)

#define CSS_CSS_KS12_ks12_uwrpok_MASK            (0x10000000U)
#define CSS_CSS_KS12_ks12_uwrpok_SHIFT           (28U)
/*! ks12_uwrpok - Ok to wrap key
 */
#define CSS_CSS_KS12_ks12_uwrpok(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS12_ks12_uwrpok_SHIFT)) & CSS_CSS_KS12_ks12_uwrpok_MASK)

#define CSS_CSS_KS12_ks12_uduk_MASK              (0x20000000U)
#define CSS_CSS_KS12_ks12_uduk_SHIFT             (29U)
/*! ks12_uduk - Device Unique Key
 */
#define CSS_CSS_KS12_ks12_uduk(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS12_ks12_uduk_SHIFT)) & CSS_CSS_KS12_ks12_uduk_MASK)

#define CSS_CSS_KS12_ks12_upprot_MASK            (0xC0000000U)
#define CSS_CSS_KS12_ks12_upprot_SHIFT           (30U)
/*! ks12_upprot - Priviledge level
 */
#define CSS_CSS_KS12_ks12_upprot(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS12_ks12_upprot_SHIFT)) & CSS_CSS_KS12_ks12_upprot_MASK)
/*! @} */

/*! @name CSS_KS13 - Status register */
/*! @{ */

#define CSS_CSS_KS13_ks13_ksize_MASK             (0x1U)
#define CSS_CSS_KS13_ks13_ksize_SHIFT            (0U)
/*! ks13_ksize - Key size: 0-128, 1-256
 */
#define CSS_CSS_KS13_ks13_ksize(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS13_ks13_ksize_SHIFT)) & CSS_CSS_KS13_ks13_ksize_MASK)

#define CSS_CSS_KS13_ks13_rsvd0_MASK             (0x1EU)
#define CSS_CSS_KS13_ks13_rsvd0_SHIFT            (1U)
/*! ks13_rsvd0 - Reserved 0
 */
#define CSS_CSS_KS13_ks13_rsvd0(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS13_ks13_rsvd0_SHIFT)) & CSS_CSS_KS13_ks13_rsvd0_MASK)

#define CSS_CSS_KS13_ks13_kact_MASK              (0x20U)
#define CSS_CSS_KS13_ks13_kact_SHIFT             (5U)
/*! ks13_kact - Key is active
 */
#define CSS_CSS_KS13_ks13_kact(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS13_ks13_kact_SHIFT)) & CSS_CSS_KS13_ks13_kact_MASK)

#define CSS_CSS_KS13_ks13_kbase_MASK             (0x40U)
#define CSS_CSS_KS13_ks13_kbase_SHIFT            (6U)
/*! ks13_kbase - First slot in a multislot key
 */
#define CSS_CSS_KS13_ks13_kbase(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS13_ks13_kbase_SHIFT)) & CSS_CSS_KS13_ks13_kbase_MASK)

#define CSS_CSS_KS13_ks13_fgp_MASK               (0x80U)
#define CSS_CSS_KS13_ks13_fgp_SHIFT              (7U)
/*! ks13_fgp - Hardware Feature General Purpose
 */
#define CSS_CSS_KS13_ks13_fgp(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS13_ks13_fgp_SHIFT)) & CSS_CSS_KS13_ks13_fgp_MASK)

#define CSS_CSS_KS13_ks13_frtn_MASK              (0x100U)
#define CSS_CSS_KS13_ks13_frtn_SHIFT             (8U)
/*! ks13_frtn - Hardware Feature Retention
 */
#define CSS_CSS_KS13_ks13_frtn(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS13_ks13_frtn_SHIFT)) & CSS_CSS_KS13_ks13_frtn_MASK)

#define CSS_CSS_KS13_ks13_fhwo_MASK              (0x200U)
#define CSS_CSS_KS13_ks13_fhwo_SHIFT             (9U)
/*! ks13_fhwo - Hardware Feature Output
 */
#define CSS_CSS_KS13_ks13_fhwo(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS13_ks13_fhwo_SHIFT)) & CSS_CSS_KS13_ks13_fhwo_MASK)

#define CSS_CSS_KS13_ks13_rsvd1_MASK             (0x1C00U)
#define CSS_CSS_KS13_ks13_rsvd1_SHIFT            (10U)
/*! ks13_rsvd1 - Reserved 1
 */
#define CSS_CSS_KS13_ks13_rsvd1(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS13_ks13_rsvd1_SHIFT)) & CSS_CSS_KS13_ks13_rsvd1_MASK)

#define CSS_CSS_KS13_ks13_ucmac_MASK             (0x2000U)
#define CSS_CSS_KS13_ks13_ucmac_SHIFT            (13U)
/*! ks13_ucmac - CMAC key
 */
#define CSS_CSS_KS13_ks13_ucmac(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS13_ks13_ucmac_SHIFT)) & CSS_CSS_KS13_ks13_ucmac_MASK)

#define CSS_CSS_KS13_ks13_uksk_MASK              (0x4000U)
#define CSS_CSS_KS13_ks13_uksk_SHIFT             (14U)
/*! ks13_uksk - KSK key
 */
#define CSS_CSS_KS13_ks13_uksk(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS13_ks13_uksk_SHIFT)) & CSS_CSS_KS13_ks13_uksk_MASK)

#define CSS_CSS_KS13_ks13_urtf_MASK              (0x8000U)
#define CSS_CSS_KS13_ks13_urtf_SHIFT             (15U)
/*! ks13_urtf - Real Time Fingerprint key
 */
#define CSS_CSS_KS13_ks13_urtf(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS13_ks13_urtf_SHIFT)) & CSS_CSS_KS13_ks13_urtf_MASK)

#define CSS_CSS_KS13_ks13_uckdf_MASK             (0x10000U)
#define CSS_CSS_KS13_ks13_uckdf_SHIFT            (16U)
/*! ks13_uckdf - Derivation key for CKDF command
 */
#define CSS_CSS_KS13_ks13_uckdf(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS13_ks13_uckdf_SHIFT)) & CSS_CSS_KS13_ks13_uckdf_MASK)

#define CSS_CSS_KS13_ks13_uhkdf_MASK             (0x20000U)
#define CSS_CSS_KS13_ks13_uhkdf_SHIFT            (17U)
/*! ks13_uhkdf - Derivation key for HKDF command
 */
#define CSS_CSS_KS13_ks13_uhkdf(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS13_ks13_uhkdf_SHIFT)) & CSS_CSS_KS13_ks13_uhkdf_MASK)

#define CSS_CSS_KS13_ks13_uecsg_MASK             (0x40000U)
#define CSS_CSS_KS13_ks13_uecsg_SHIFT            (18U)
/*! ks13_uecsg - Ecc signing key
 */
#define CSS_CSS_KS13_ks13_uecsg(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS13_ks13_uecsg_SHIFT)) & CSS_CSS_KS13_ks13_uecsg_MASK)

#define CSS_CSS_KS13_ks13_uecdh_MASK             (0x80000U)
#define CSS_CSS_KS13_ks13_uecdh_SHIFT            (19U)
/*! ks13_uecdh - Ecc diffie hellman key
 */
#define CSS_CSS_KS13_ks13_uecdh(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS13_ks13_uecdh_SHIFT)) & CSS_CSS_KS13_ks13_uecdh_MASK)

#define CSS_CSS_KS13_ks13_uaes_MASK              (0x100000U)
#define CSS_CSS_KS13_ks13_uaes_SHIFT             (20U)
/*! ks13_uaes - Aes key
 */
#define CSS_CSS_KS13_ks13_uaes(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS13_ks13_uaes_SHIFT)) & CSS_CSS_KS13_ks13_uaes_MASK)

#define CSS_CSS_KS13_ks13_uhmac_MASK             (0x200000U)
#define CSS_CSS_KS13_ks13_uhmac_SHIFT            (21U)
/*! ks13_uhmac - Hmac key
 */
#define CSS_CSS_KS13_ks13_uhmac(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS13_ks13_uhmac_SHIFT)) & CSS_CSS_KS13_ks13_uhmac_MASK)

#define CSS_CSS_KS13_ks13_ukwk_MASK              (0x400000U)
#define CSS_CSS_KS13_ks13_ukwk_SHIFT             (22U)
/*! ks13_ukwk - Key wrapping key
 */
#define CSS_CSS_KS13_ks13_ukwk(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS13_ks13_ukwk_SHIFT)) & CSS_CSS_KS13_ks13_ukwk_MASK)

#define CSS_CSS_KS13_ks13_ukuok_MASK             (0x800000U)
#define CSS_CSS_KS13_ks13_ukuok_SHIFT            (23U)
/*! ks13_ukuok - Key unwrapping key
 */
#define CSS_CSS_KS13_ks13_ukuok(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS13_ks13_ukuok_SHIFT)) & CSS_CSS_KS13_ks13_ukuok_MASK)

#define CSS_CSS_KS13_ks13_utlspms_MASK           (0x1000000U)
#define CSS_CSS_KS13_ks13_utlspms_SHIFT          (24U)
/*! ks13_utlspms - TLS Pre Master Secret
 */
#define CSS_CSS_KS13_ks13_utlspms(x)             (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS13_ks13_utlspms_SHIFT)) & CSS_CSS_KS13_ks13_utlspms_MASK)

#define CSS_CSS_KS13_ks13_utlsms_MASK            (0x2000000U)
#define CSS_CSS_KS13_ks13_utlsms_SHIFT           (25U)
/*! ks13_utlsms - TLS Master Secret
 */
#define CSS_CSS_KS13_ks13_utlsms(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS13_ks13_utlsms_SHIFT)) & CSS_CSS_KS13_ks13_utlsms_MASK)

#define CSS_CSS_KS13_ks13_ukgsrc_MASK            (0x4000000U)
#define CSS_CSS_KS13_ks13_ukgsrc_SHIFT           (26U)
/*! ks13_ukgsrc - Supply KEYGEN source
 */
#define CSS_CSS_KS13_ks13_ukgsrc(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS13_ks13_ukgsrc_SHIFT)) & CSS_CSS_KS13_ks13_ukgsrc_MASK)

#define CSS_CSS_KS13_ks13_uhwo_MASK              (0x8000000U)
#define CSS_CSS_KS13_ks13_uhwo_SHIFT             (27U)
/*! ks13_uhwo - Hardware out key
 */
#define CSS_CSS_KS13_ks13_uhwo(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS13_ks13_uhwo_SHIFT)) & CSS_CSS_KS13_ks13_uhwo_MASK)

#define CSS_CSS_KS13_ks13_uwrpok_MASK            (0x10000000U)
#define CSS_CSS_KS13_ks13_uwrpok_SHIFT           (28U)
/*! ks13_uwrpok - Ok to wrap key
 */
#define CSS_CSS_KS13_ks13_uwrpok(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS13_ks13_uwrpok_SHIFT)) & CSS_CSS_KS13_ks13_uwrpok_MASK)

#define CSS_CSS_KS13_ks13_uduk_MASK              (0x20000000U)
#define CSS_CSS_KS13_ks13_uduk_SHIFT             (29U)
/*! ks13_uduk - Device Unique Key
 */
#define CSS_CSS_KS13_ks13_uduk(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS13_ks13_uduk_SHIFT)) & CSS_CSS_KS13_ks13_uduk_MASK)

#define CSS_CSS_KS13_ks13_upprot_MASK            (0xC0000000U)
#define CSS_CSS_KS13_ks13_upprot_SHIFT           (30U)
/*! ks13_upprot - Priviledge level
 */
#define CSS_CSS_KS13_ks13_upprot(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS13_ks13_upprot_SHIFT)) & CSS_CSS_KS13_ks13_upprot_MASK)
/*! @} */

/*! @name CSS_KS14 - Status register */
/*! @{ */

#define CSS_CSS_KS14_ks14_ksize_MASK             (0x1U)
#define CSS_CSS_KS14_ks14_ksize_SHIFT            (0U)
/*! ks14_ksize - Key size: 0-128, 1-256
 */
#define CSS_CSS_KS14_ks14_ksize(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS14_ks14_ksize_SHIFT)) & CSS_CSS_KS14_ks14_ksize_MASK)

#define CSS_CSS_KS14_ks14_rsvd0_MASK             (0x1EU)
#define CSS_CSS_KS14_ks14_rsvd0_SHIFT            (1U)
/*! ks14_rsvd0 - Reserved 0
 */
#define CSS_CSS_KS14_ks14_rsvd0(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS14_ks14_rsvd0_SHIFT)) & CSS_CSS_KS14_ks14_rsvd0_MASK)

#define CSS_CSS_KS14_ks14_kact_MASK              (0x20U)
#define CSS_CSS_KS14_ks14_kact_SHIFT             (5U)
/*! ks14_kact - Key is active
 */
#define CSS_CSS_KS14_ks14_kact(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS14_ks14_kact_SHIFT)) & CSS_CSS_KS14_ks14_kact_MASK)

#define CSS_CSS_KS14_ks14_kbase_MASK             (0x40U)
#define CSS_CSS_KS14_ks14_kbase_SHIFT            (6U)
/*! ks14_kbase - First slot in a multislot key
 */
#define CSS_CSS_KS14_ks14_kbase(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS14_ks14_kbase_SHIFT)) & CSS_CSS_KS14_ks14_kbase_MASK)

#define CSS_CSS_KS14_ks14_fgp_MASK               (0x80U)
#define CSS_CSS_KS14_ks14_fgp_SHIFT              (7U)
/*! ks14_fgp - Hardware Feature General Purpose
 */
#define CSS_CSS_KS14_ks14_fgp(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS14_ks14_fgp_SHIFT)) & CSS_CSS_KS14_ks14_fgp_MASK)

#define CSS_CSS_KS14_ks14_frtn_MASK              (0x100U)
#define CSS_CSS_KS14_ks14_frtn_SHIFT             (8U)
/*! ks14_frtn - Hardware Feature Retention
 */
#define CSS_CSS_KS14_ks14_frtn(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS14_ks14_frtn_SHIFT)) & CSS_CSS_KS14_ks14_frtn_MASK)

#define CSS_CSS_KS14_ks14_fhwo_MASK              (0x200U)
#define CSS_CSS_KS14_ks14_fhwo_SHIFT             (9U)
/*! ks14_fhwo - Hardware Feature Output
 */
#define CSS_CSS_KS14_ks14_fhwo(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS14_ks14_fhwo_SHIFT)) & CSS_CSS_KS14_ks14_fhwo_MASK)

#define CSS_CSS_KS14_ks14_rsvd1_MASK             (0x1C00U)
#define CSS_CSS_KS14_ks14_rsvd1_SHIFT            (10U)
/*! ks14_rsvd1 - Reserved 1
 */
#define CSS_CSS_KS14_ks14_rsvd1(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS14_ks14_rsvd1_SHIFT)) & CSS_CSS_KS14_ks14_rsvd1_MASK)

#define CSS_CSS_KS14_ks14_ucmac_MASK             (0x2000U)
#define CSS_CSS_KS14_ks14_ucmac_SHIFT            (13U)
/*! ks14_ucmac - CMAC key
 */
#define CSS_CSS_KS14_ks14_ucmac(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS14_ks14_ucmac_SHIFT)) & CSS_CSS_KS14_ks14_ucmac_MASK)

#define CSS_CSS_KS14_ks14_uksk_MASK              (0x4000U)
#define CSS_CSS_KS14_ks14_uksk_SHIFT             (14U)
/*! ks14_uksk - KSK key
 */
#define CSS_CSS_KS14_ks14_uksk(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS14_ks14_uksk_SHIFT)) & CSS_CSS_KS14_ks14_uksk_MASK)

#define CSS_CSS_KS14_ks14_urtf_MASK              (0x8000U)
#define CSS_CSS_KS14_ks14_urtf_SHIFT             (15U)
/*! ks14_urtf - Real Time Fingerprint key
 */
#define CSS_CSS_KS14_ks14_urtf(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS14_ks14_urtf_SHIFT)) & CSS_CSS_KS14_ks14_urtf_MASK)

#define CSS_CSS_KS14_ks14_uckdf_MASK             (0x10000U)
#define CSS_CSS_KS14_ks14_uckdf_SHIFT            (16U)
/*! ks14_uckdf - Derivation key for CKDF command
 */
#define CSS_CSS_KS14_ks14_uckdf(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS14_ks14_uckdf_SHIFT)) & CSS_CSS_KS14_ks14_uckdf_MASK)

#define CSS_CSS_KS14_ks14_uhkdf_MASK             (0x20000U)
#define CSS_CSS_KS14_ks14_uhkdf_SHIFT            (17U)
/*! ks14_uhkdf - Derivation key for HKDF command
 */
#define CSS_CSS_KS14_ks14_uhkdf(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS14_ks14_uhkdf_SHIFT)) & CSS_CSS_KS14_ks14_uhkdf_MASK)

#define CSS_CSS_KS14_ks14_uecsg_MASK             (0x40000U)
#define CSS_CSS_KS14_ks14_uecsg_SHIFT            (18U)
/*! ks14_uecsg - Ecc signing key
 */
#define CSS_CSS_KS14_ks14_uecsg(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS14_ks14_uecsg_SHIFT)) & CSS_CSS_KS14_ks14_uecsg_MASK)

#define CSS_CSS_KS14_ks14_uecdh_MASK             (0x80000U)
#define CSS_CSS_KS14_ks14_uecdh_SHIFT            (19U)
/*! ks14_uecdh - Ecc diffie hellman key
 */
#define CSS_CSS_KS14_ks14_uecdh(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS14_ks14_uecdh_SHIFT)) & CSS_CSS_KS14_ks14_uecdh_MASK)

#define CSS_CSS_KS14_ks14_uaes_MASK              (0x100000U)
#define CSS_CSS_KS14_ks14_uaes_SHIFT             (20U)
/*! ks14_uaes - Aes key
 */
#define CSS_CSS_KS14_ks14_uaes(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS14_ks14_uaes_SHIFT)) & CSS_CSS_KS14_ks14_uaes_MASK)

#define CSS_CSS_KS14_ks14_uhmac_MASK             (0x200000U)
#define CSS_CSS_KS14_ks14_uhmac_SHIFT            (21U)
/*! ks14_uhmac - Hmac key
 */
#define CSS_CSS_KS14_ks14_uhmac(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS14_ks14_uhmac_SHIFT)) & CSS_CSS_KS14_ks14_uhmac_MASK)

#define CSS_CSS_KS14_ks14_ukwk_MASK              (0x400000U)
#define CSS_CSS_KS14_ks14_ukwk_SHIFT             (22U)
/*! ks14_ukwk - Key wrapping key
 */
#define CSS_CSS_KS14_ks14_ukwk(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS14_ks14_ukwk_SHIFT)) & CSS_CSS_KS14_ks14_ukwk_MASK)

#define CSS_CSS_KS14_ks14_ukuok_MASK             (0x800000U)
#define CSS_CSS_KS14_ks14_ukuok_SHIFT            (23U)
/*! ks14_ukuok - Key unwrapping key
 */
#define CSS_CSS_KS14_ks14_ukuok(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS14_ks14_ukuok_SHIFT)) & CSS_CSS_KS14_ks14_ukuok_MASK)

#define CSS_CSS_KS14_ks14_utlspms_MASK           (0x1000000U)
#define CSS_CSS_KS14_ks14_utlspms_SHIFT          (24U)
/*! ks14_utlspms - TLS Pre Master Secret
 */
#define CSS_CSS_KS14_ks14_utlspms(x)             (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS14_ks14_utlspms_SHIFT)) & CSS_CSS_KS14_ks14_utlspms_MASK)

#define CSS_CSS_KS14_ks14_utlsms_MASK            (0x2000000U)
#define CSS_CSS_KS14_ks14_utlsms_SHIFT           (25U)
/*! ks14_utlsms - TLS Master Secret
 */
#define CSS_CSS_KS14_ks14_utlsms(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS14_ks14_utlsms_SHIFT)) & CSS_CSS_KS14_ks14_utlsms_MASK)

#define CSS_CSS_KS14_ks14_ukgsrc_MASK            (0x4000000U)
#define CSS_CSS_KS14_ks14_ukgsrc_SHIFT           (26U)
/*! ks14_ukgsrc - Supply KEYGEN source
 */
#define CSS_CSS_KS14_ks14_ukgsrc(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS14_ks14_ukgsrc_SHIFT)) & CSS_CSS_KS14_ks14_ukgsrc_MASK)

#define CSS_CSS_KS14_ks14_uhwo_MASK              (0x8000000U)
#define CSS_CSS_KS14_ks14_uhwo_SHIFT             (27U)
/*! ks14_uhwo - Hardware out key
 */
#define CSS_CSS_KS14_ks14_uhwo(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS14_ks14_uhwo_SHIFT)) & CSS_CSS_KS14_ks14_uhwo_MASK)

#define CSS_CSS_KS14_ks14_uwrpok_MASK            (0x10000000U)
#define CSS_CSS_KS14_ks14_uwrpok_SHIFT           (28U)
/*! ks14_uwrpok - Ok to wrap key
 */
#define CSS_CSS_KS14_ks14_uwrpok(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS14_ks14_uwrpok_SHIFT)) & CSS_CSS_KS14_ks14_uwrpok_MASK)

#define CSS_CSS_KS14_ks14_uduk_MASK              (0x20000000U)
#define CSS_CSS_KS14_ks14_uduk_SHIFT             (29U)
/*! ks14_uduk - Device Unique Key
 */
#define CSS_CSS_KS14_ks14_uduk(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS14_ks14_uduk_SHIFT)) & CSS_CSS_KS14_ks14_uduk_MASK)

#define CSS_CSS_KS14_ks14_upprot_MASK            (0xC0000000U)
#define CSS_CSS_KS14_ks14_upprot_SHIFT           (30U)
/*! ks14_upprot - Priviledge level
 */
#define CSS_CSS_KS14_ks14_upprot(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS14_ks14_upprot_SHIFT)) & CSS_CSS_KS14_ks14_upprot_MASK)
/*! @} */

/*! @name CSS_KS15 - Status register */
/*! @{ */

#define CSS_CSS_KS15_ks15_ksize_MASK             (0x1U)
#define CSS_CSS_KS15_ks15_ksize_SHIFT            (0U)
/*! ks15_ksize - Key size: 0-128, 1-256
 */
#define CSS_CSS_KS15_ks15_ksize(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS15_ks15_ksize_SHIFT)) & CSS_CSS_KS15_ks15_ksize_MASK)

#define CSS_CSS_KS15_ks15_rsvd0_MASK             (0x1EU)
#define CSS_CSS_KS15_ks15_rsvd0_SHIFT            (1U)
/*! ks15_rsvd0 - Reserved 0
 */
#define CSS_CSS_KS15_ks15_rsvd0(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS15_ks15_rsvd0_SHIFT)) & CSS_CSS_KS15_ks15_rsvd0_MASK)

#define CSS_CSS_KS15_ks15_kact_MASK              (0x20U)
#define CSS_CSS_KS15_ks15_kact_SHIFT             (5U)
/*! ks15_kact - Key is active
 */
#define CSS_CSS_KS15_ks15_kact(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS15_ks15_kact_SHIFT)) & CSS_CSS_KS15_ks15_kact_MASK)

#define CSS_CSS_KS15_ks15_kbase_MASK             (0x40U)
#define CSS_CSS_KS15_ks15_kbase_SHIFT            (6U)
/*! ks15_kbase - First slot in a multislot key
 */
#define CSS_CSS_KS15_ks15_kbase(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS15_ks15_kbase_SHIFT)) & CSS_CSS_KS15_ks15_kbase_MASK)

#define CSS_CSS_KS15_ks15_fgp_MASK               (0x80U)
#define CSS_CSS_KS15_ks15_fgp_SHIFT              (7U)
/*! ks15_fgp - Hardware Feature General Purpose
 */
#define CSS_CSS_KS15_ks15_fgp(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS15_ks15_fgp_SHIFT)) & CSS_CSS_KS15_ks15_fgp_MASK)

#define CSS_CSS_KS15_ks15_frtn_MASK              (0x100U)
#define CSS_CSS_KS15_ks15_frtn_SHIFT             (8U)
/*! ks15_frtn - Hardware Feature Retention
 */
#define CSS_CSS_KS15_ks15_frtn(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS15_ks15_frtn_SHIFT)) & CSS_CSS_KS15_ks15_frtn_MASK)

#define CSS_CSS_KS15_ks15_fhwo_MASK              (0x200U)
#define CSS_CSS_KS15_ks15_fhwo_SHIFT             (9U)
/*! ks15_fhwo - Hardware Feature Output
 */
#define CSS_CSS_KS15_ks15_fhwo(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS15_ks15_fhwo_SHIFT)) & CSS_CSS_KS15_ks15_fhwo_MASK)

#define CSS_CSS_KS15_ks15_rsvd1_MASK             (0x1C00U)
#define CSS_CSS_KS15_ks15_rsvd1_SHIFT            (10U)
/*! ks15_rsvd1 - Reserved 1
 */
#define CSS_CSS_KS15_ks15_rsvd1(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS15_ks15_rsvd1_SHIFT)) & CSS_CSS_KS15_ks15_rsvd1_MASK)

#define CSS_CSS_KS15_ks15_ucmac_MASK             (0x2000U)
#define CSS_CSS_KS15_ks15_ucmac_SHIFT            (13U)
/*! ks15_ucmac - CMAC key
 */
#define CSS_CSS_KS15_ks15_ucmac(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS15_ks15_ucmac_SHIFT)) & CSS_CSS_KS15_ks15_ucmac_MASK)

#define CSS_CSS_KS15_ks15_uksk_MASK              (0x4000U)
#define CSS_CSS_KS15_ks15_uksk_SHIFT             (14U)
/*! ks15_uksk - KSK key
 */
#define CSS_CSS_KS15_ks15_uksk(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS15_ks15_uksk_SHIFT)) & CSS_CSS_KS15_ks15_uksk_MASK)

#define CSS_CSS_KS15_ks15_urtf_MASK              (0x8000U)
#define CSS_CSS_KS15_ks15_urtf_SHIFT             (15U)
/*! ks15_urtf - Real Time Fingerprint key
 */
#define CSS_CSS_KS15_ks15_urtf(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS15_ks15_urtf_SHIFT)) & CSS_CSS_KS15_ks15_urtf_MASK)

#define CSS_CSS_KS15_ks15_uckdf_MASK             (0x10000U)
#define CSS_CSS_KS15_ks15_uckdf_SHIFT            (16U)
/*! ks15_uckdf - Derivation key for CKDF command
 */
#define CSS_CSS_KS15_ks15_uckdf(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS15_ks15_uckdf_SHIFT)) & CSS_CSS_KS15_ks15_uckdf_MASK)

#define CSS_CSS_KS15_ks15_uhkdf_MASK             (0x20000U)
#define CSS_CSS_KS15_ks15_uhkdf_SHIFT            (17U)
/*! ks15_uhkdf - Derivation key for HKDF command
 */
#define CSS_CSS_KS15_ks15_uhkdf(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS15_ks15_uhkdf_SHIFT)) & CSS_CSS_KS15_ks15_uhkdf_MASK)

#define CSS_CSS_KS15_ks15_uecsg_MASK             (0x40000U)
#define CSS_CSS_KS15_ks15_uecsg_SHIFT            (18U)
/*! ks15_uecsg - Ecc signing key
 */
#define CSS_CSS_KS15_ks15_uecsg(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS15_ks15_uecsg_SHIFT)) & CSS_CSS_KS15_ks15_uecsg_MASK)

#define CSS_CSS_KS15_ks15_uecdh_MASK             (0x80000U)
#define CSS_CSS_KS15_ks15_uecdh_SHIFT            (19U)
/*! ks15_uecdh - Ecc diffie hellman key
 */
#define CSS_CSS_KS15_ks15_uecdh(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS15_ks15_uecdh_SHIFT)) & CSS_CSS_KS15_ks15_uecdh_MASK)

#define CSS_CSS_KS15_ks15_uaes_MASK              (0x100000U)
#define CSS_CSS_KS15_ks15_uaes_SHIFT             (20U)
/*! ks15_uaes - Aes key
 */
#define CSS_CSS_KS15_ks15_uaes(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS15_ks15_uaes_SHIFT)) & CSS_CSS_KS15_ks15_uaes_MASK)

#define CSS_CSS_KS15_ks15_uhmac_MASK             (0x200000U)
#define CSS_CSS_KS15_ks15_uhmac_SHIFT            (21U)
/*! ks15_uhmac - Hmac key
 */
#define CSS_CSS_KS15_ks15_uhmac(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS15_ks15_uhmac_SHIFT)) & CSS_CSS_KS15_ks15_uhmac_MASK)

#define CSS_CSS_KS15_ks15_ukwk_MASK              (0x400000U)
#define CSS_CSS_KS15_ks15_ukwk_SHIFT             (22U)
/*! ks15_ukwk - Key wrapping key
 */
#define CSS_CSS_KS15_ks15_ukwk(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS15_ks15_ukwk_SHIFT)) & CSS_CSS_KS15_ks15_ukwk_MASK)

#define CSS_CSS_KS15_ks15_ukuok_MASK             (0x800000U)
#define CSS_CSS_KS15_ks15_ukuok_SHIFT            (23U)
/*! ks15_ukuok - Key unwrapping key
 */
#define CSS_CSS_KS15_ks15_ukuok(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS15_ks15_ukuok_SHIFT)) & CSS_CSS_KS15_ks15_ukuok_MASK)

#define CSS_CSS_KS15_ks15_utlspms_MASK           (0x1000000U)
#define CSS_CSS_KS15_ks15_utlspms_SHIFT          (24U)
/*! ks15_utlspms - TLS Pre Master Secret
 */
#define CSS_CSS_KS15_ks15_utlspms(x)             (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS15_ks15_utlspms_SHIFT)) & CSS_CSS_KS15_ks15_utlspms_MASK)

#define CSS_CSS_KS15_ks15_utlsms_MASK            (0x2000000U)
#define CSS_CSS_KS15_ks15_utlsms_SHIFT           (25U)
/*! ks15_utlsms - TLS Master Secret
 */
#define CSS_CSS_KS15_ks15_utlsms(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS15_ks15_utlsms_SHIFT)) & CSS_CSS_KS15_ks15_utlsms_MASK)

#define CSS_CSS_KS15_ks15_ukgsrc_MASK            (0x4000000U)
#define CSS_CSS_KS15_ks15_ukgsrc_SHIFT           (26U)
/*! ks15_ukgsrc - Supply KEYGEN source
 */
#define CSS_CSS_KS15_ks15_ukgsrc(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS15_ks15_ukgsrc_SHIFT)) & CSS_CSS_KS15_ks15_ukgsrc_MASK)

#define CSS_CSS_KS15_ks15_uhwo_MASK              (0x8000000U)
#define CSS_CSS_KS15_ks15_uhwo_SHIFT             (27U)
/*! ks15_uhwo - Hardware out key
 */
#define CSS_CSS_KS15_ks15_uhwo(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS15_ks15_uhwo_SHIFT)) & CSS_CSS_KS15_ks15_uhwo_MASK)

#define CSS_CSS_KS15_ks15_uwrpok_MASK            (0x10000000U)
#define CSS_CSS_KS15_ks15_uwrpok_SHIFT           (28U)
/*! ks15_uwrpok - Ok to wrap key
 */
#define CSS_CSS_KS15_ks15_uwrpok(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS15_ks15_uwrpok_SHIFT)) & CSS_CSS_KS15_ks15_uwrpok_MASK)

#define CSS_CSS_KS15_ks15_uduk_MASK              (0x20000000U)
#define CSS_CSS_KS15_ks15_uduk_SHIFT             (29U)
/*! ks15_uduk - Device Unique Key
 */
#define CSS_CSS_KS15_ks15_uduk(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS15_ks15_uduk_SHIFT)) & CSS_CSS_KS15_ks15_uduk_MASK)

#define CSS_CSS_KS15_ks15_upprot_MASK            (0xC0000000U)
#define CSS_CSS_KS15_ks15_upprot_SHIFT           (30U)
/*! ks15_upprot - Priviledge level
 */
#define CSS_CSS_KS15_ks15_upprot(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS15_ks15_upprot_SHIFT)) & CSS_CSS_KS15_ks15_upprot_MASK)
/*! @} */

/*! @name CSS_KS16 - Status register */
/*! @{ */

#define CSS_CSS_KS16_ks16_ksize_MASK             (0x1U)
#define CSS_CSS_KS16_ks16_ksize_SHIFT            (0U)
/*! ks16_ksize - Key size: 0-128, 1-256
 */
#define CSS_CSS_KS16_ks16_ksize(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS16_ks16_ksize_SHIFT)) & CSS_CSS_KS16_ks16_ksize_MASK)

#define CSS_CSS_KS16_ks16_rsvd0_MASK             (0x1EU)
#define CSS_CSS_KS16_ks16_rsvd0_SHIFT            (1U)
/*! ks16_rsvd0 - Reserved 0
 */
#define CSS_CSS_KS16_ks16_rsvd0(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS16_ks16_rsvd0_SHIFT)) & CSS_CSS_KS16_ks16_rsvd0_MASK)

#define CSS_CSS_KS16_ks16_kact_MASK              (0x20U)
#define CSS_CSS_KS16_ks16_kact_SHIFT             (5U)
/*! ks16_kact - Key is active
 */
#define CSS_CSS_KS16_ks16_kact(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS16_ks16_kact_SHIFT)) & CSS_CSS_KS16_ks16_kact_MASK)

#define CSS_CSS_KS16_ks16_kbase_MASK             (0x40U)
#define CSS_CSS_KS16_ks16_kbase_SHIFT            (6U)
/*! ks16_kbase - First slot in a multislot key
 */
#define CSS_CSS_KS16_ks16_kbase(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS16_ks16_kbase_SHIFT)) & CSS_CSS_KS16_ks16_kbase_MASK)

#define CSS_CSS_KS16_ks16_fgp_MASK               (0x80U)
#define CSS_CSS_KS16_ks16_fgp_SHIFT              (7U)
/*! ks16_fgp - Hardware Feature General Purpose
 */
#define CSS_CSS_KS16_ks16_fgp(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS16_ks16_fgp_SHIFT)) & CSS_CSS_KS16_ks16_fgp_MASK)

#define CSS_CSS_KS16_ks16_frtn_MASK              (0x100U)
#define CSS_CSS_KS16_ks16_frtn_SHIFT             (8U)
/*! ks16_frtn - Hardware Feature Retention
 */
#define CSS_CSS_KS16_ks16_frtn(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS16_ks16_frtn_SHIFT)) & CSS_CSS_KS16_ks16_frtn_MASK)

#define CSS_CSS_KS16_ks16_fhwo_MASK              (0x200U)
#define CSS_CSS_KS16_ks16_fhwo_SHIFT             (9U)
/*! ks16_fhwo - Hardware Feature Output
 */
#define CSS_CSS_KS16_ks16_fhwo(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS16_ks16_fhwo_SHIFT)) & CSS_CSS_KS16_ks16_fhwo_MASK)

#define CSS_CSS_KS16_ks16_rsvd1_MASK             (0x1C00U)
#define CSS_CSS_KS16_ks16_rsvd1_SHIFT            (10U)
/*! ks16_rsvd1 - Reserved 1
 */
#define CSS_CSS_KS16_ks16_rsvd1(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS16_ks16_rsvd1_SHIFT)) & CSS_CSS_KS16_ks16_rsvd1_MASK)

#define CSS_CSS_KS16_ks16_ucmac_MASK             (0x2000U)
#define CSS_CSS_KS16_ks16_ucmac_SHIFT            (13U)
/*! ks16_ucmac - CMAC key
 */
#define CSS_CSS_KS16_ks16_ucmac(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS16_ks16_ucmac_SHIFT)) & CSS_CSS_KS16_ks16_ucmac_MASK)

#define CSS_CSS_KS16_ks16_uksk_MASK              (0x4000U)
#define CSS_CSS_KS16_ks16_uksk_SHIFT             (14U)
/*! ks16_uksk - KSK key
 */
#define CSS_CSS_KS16_ks16_uksk(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS16_ks16_uksk_SHIFT)) & CSS_CSS_KS16_ks16_uksk_MASK)

#define CSS_CSS_KS16_ks16_urtf_MASK              (0x8000U)
#define CSS_CSS_KS16_ks16_urtf_SHIFT             (15U)
/*! ks16_urtf - Real Time Fingerprint key
 */
#define CSS_CSS_KS16_ks16_urtf(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS16_ks16_urtf_SHIFT)) & CSS_CSS_KS16_ks16_urtf_MASK)

#define CSS_CSS_KS16_ks16_uckdf_MASK             (0x10000U)
#define CSS_CSS_KS16_ks16_uckdf_SHIFT            (16U)
/*! ks16_uckdf - Derivation key for CKDF command
 */
#define CSS_CSS_KS16_ks16_uckdf(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS16_ks16_uckdf_SHIFT)) & CSS_CSS_KS16_ks16_uckdf_MASK)

#define CSS_CSS_KS16_ks16_uhkdf_MASK             (0x20000U)
#define CSS_CSS_KS16_ks16_uhkdf_SHIFT            (17U)
/*! ks16_uhkdf - Derivation key for HKDF command
 */
#define CSS_CSS_KS16_ks16_uhkdf(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS16_ks16_uhkdf_SHIFT)) & CSS_CSS_KS16_ks16_uhkdf_MASK)

#define CSS_CSS_KS16_ks16_uecsg_MASK             (0x40000U)
#define CSS_CSS_KS16_ks16_uecsg_SHIFT            (18U)
/*! ks16_uecsg - Ecc signing key
 */
#define CSS_CSS_KS16_ks16_uecsg(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS16_ks16_uecsg_SHIFT)) & CSS_CSS_KS16_ks16_uecsg_MASK)

#define CSS_CSS_KS16_ks16_uecdh_MASK             (0x80000U)
#define CSS_CSS_KS16_ks16_uecdh_SHIFT            (19U)
/*! ks16_uecdh - Ecc diffie hellman key
 */
#define CSS_CSS_KS16_ks16_uecdh(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS16_ks16_uecdh_SHIFT)) & CSS_CSS_KS16_ks16_uecdh_MASK)

#define CSS_CSS_KS16_ks16_uaes_MASK              (0x100000U)
#define CSS_CSS_KS16_ks16_uaes_SHIFT             (20U)
/*! ks16_uaes - Aes key
 */
#define CSS_CSS_KS16_ks16_uaes(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS16_ks16_uaes_SHIFT)) & CSS_CSS_KS16_ks16_uaes_MASK)

#define CSS_CSS_KS16_ks16_uhmac_MASK             (0x200000U)
#define CSS_CSS_KS16_ks16_uhmac_SHIFT            (21U)
/*! ks16_uhmac - Hmac key
 */
#define CSS_CSS_KS16_ks16_uhmac(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS16_ks16_uhmac_SHIFT)) & CSS_CSS_KS16_ks16_uhmac_MASK)

#define CSS_CSS_KS16_ks16_ukwk_MASK              (0x400000U)
#define CSS_CSS_KS16_ks16_ukwk_SHIFT             (22U)
/*! ks16_ukwk - Key wrapping key
 */
#define CSS_CSS_KS16_ks16_ukwk(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS16_ks16_ukwk_SHIFT)) & CSS_CSS_KS16_ks16_ukwk_MASK)

#define CSS_CSS_KS16_ks16_ukuok_MASK             (0x800000U)
#define CSS_CSS_KS16_ks16_ukuok_SHIFT            (23U)
/*! ks16_ukuok - Key unwrapping key
 */
#define CSS_CSS_KS16_ks16_ukuok(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS16_ks16_ukuok_SHIFT)) & CSS_CSS_KS16_ks16_ukuok_MASK)

#define CSS_CSS_KS16_ks16_utlspms_MASK           (0x1000000U)
#define CSS_CSS_KS16_ks16_utlspms_SHIFT          (24U)
/*! ks16_utlspms - TLS Pre Master Secret
 */
#define CSS_CSS_KS16_ks16_utlspms(x)             (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS16_ks16_utlspms_SHIFT)) & CSS_CSS_KS16_ks16_utlspms_MASK)

#define CSS_CSS_KS16_ks16_utlsms_MASK            (0x2000000U)
#define CSS_CSS_KS16_ks16_utlsms_SHIFT           (25U)
/*! ks16_utlsms - TLS Master Secret
 */
#define CSS_CSS_KS16_ks16_utlsms(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS16_ks16_utlsms_SHIFT)) & CSS_CSS_KS16_ks16_utlsms_MASK)

#define CSS_CSS_KS16_ks16_ukgsrc_MASK            (0x4000000U)
#define CSS_CSS_KS16_ks16_ukgsrc_SHIFT           (26U)
/*! ks16_ukgsrc - Supply KEYGEN source
 */
#define CSS_CSS_KS16_ks16_ukgsrc(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS16_ks16_ukgsrc_SHIFT)) & CSS_CSS_KS16_ks16_ukgsrc_MASK)

#define CSS_CSS_KS16_ks16_uhwo_MASK              (0x8000000U)
#define CSS_CSS_KS16_ks16_uhwo_SHIFT             (27U)
/*! ks16_uhwo - Hardware out key
 */
#define CSS_CSS_KS16_ks16_uhwo(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS16_ks16_uhwo_SHIFT)) & CSS_CSS_KS16_ks16_uhwo_MASK)

#define CSS_CSS_KS16_ks16_uwrpok_MASK            (0x10000000U)
#define CSS_CSS_KS16_ks16_uwrpok_SHIFT           (28U)
/*! ks16_uwrpok - Ok to wrap key
 */
#define CSS_CSS_KS16_ks16_uwrpok(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS16_ks16_uwrpok_SHIFT)) & CSS_CSS_KS16_ks16_uwrpok_MASK)

#define CSS_CSS_KS16_ks16_uduk_MASK              (0x20000000U)
#define CSS_CSS_KS16_ks16_uduk_SHIFT             (29U)
/*! ks16_uduk - Device Unique Key
 */
#define CSS_CSS_KS16_ks16_uduk(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS16_ks16_uduk_SHIFT)) & CSS_CSS_KS16_ks16_uduk_MASK)

#define CSS_CSS_KS16_ks16_upprot_MASK            (0xC0000000U)
#define CSS_CSS_KS16_ks16_upprot_SHIFT           (30U)
/*! ks16_upprot - Priviledge level
 */
#define CSS_CSS_KS16_ks16_upprot(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS16_ks16_upprot_SHIFT)) & CSS_CSS_KS16_ks16_upprot_MASK)
/*! @} */

/*! @name CSS_KS17 - Status register */
/*! @{ */

#define CSS_CSS_KS17_ks17_ksize_MASK             (0x1U)
#define CSS_CSS_KS17_ks17_ksize_SHIFT            (0U)
/*! ks17_ksize - Key size: 0-128, 1-256
 */
#define CSS_CSS_KS17_ks17_ksize(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS17_ks17_ksize_SHIFT)) & CSS_CSS_KS17_ks17_ksize_MASK)

#define CSS_CSS_KS17_ks17_rsvd0_MASK             (0x1EU)
#define CSS_CSS_KS17_ks17_rsvd0_SHIFT            (1U)
/*! ks17_rsvd0 - Reserved 0
 */
#define CSS_CSS_KS17_ks17_rsvd0(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS17_ks17_rsvd0_SHIFT)) & CSS_CSS_KS17_ks17_rsvd0_MASK)

#define CSS_CSS_KS17_ks17_kact_MASK              (0x20U)
#define CSS_CSS_KS17_ks17_kact_SHIFT             (5U)
/*! ks17_kact - Key is active
 */
#define CSS_CSS_KS17_ks17_kact(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS17_ks17_kact_SHIFT)) & CSS_CSS_KS17_ks17_kact_MASK)

#define CSS_CSS_KS17_ks17_kbase_MASK             (0x40U)
#define CSS_CSS_KS17_ks17_kbase_SHIFT            (6U)
/*! ks17_kbase - First slot in a multislot key
 */
#define CSS_CSS_KS17_ks17_kbase(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS17_ks17_kbase_SHIFT)) & CSS_CSS_KS17_ks17_kbase_MASK)

#define CSS_CSS_KS17_ks17_fgp_MASK               (0x80U)
#define CSS_CSS_KS17_ks17_fgp_SHIFT              (7U)
/*! ks17_fgp - Hardware Feature General Purpose
 */
#define CSS_CSS_KS17_ks17_fgp(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS17_ks17_fgp_SHIFT)) & CSS_CSS_KS17_ks17_fgp_MASK)

#define CSS_CSS_KS17_ks17_frtn_MASK              (0x100U)
#define CSS_CSS_KS17_ks17_frtn_SHIFT             (8U)
/*! ks17_frtn - Hardware Feature Retention
 */
#define CSS_CSS_KS17_ks17_frtn(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS17_ks17_frtn_SHIFT)) & CSS_CSS_KS17_ks17_frtn_MASK)

#define CSS_CSS_KS17_ks17_fhwo_MASK              (0x200U)
#define CSS_CSS_KS17_ks17_fhwo_SHIFT             (9U)
/*! ks17_fhwo - Hardware Feature Output
 */
#define CSS_CSS_KS17_ks17_fhwo(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS17_ks17_fhwo_SHIFT)) & CSS_CSS_KS17_ks17_fhwo_MASK)

#define CSS_CSS_KS17_ks17_rsvd1_MASK             (0x1C00U)
#define CSS_CSS_KS17_ks17_rsvd1_SHIFT            (10U)
/*! ks17_rsvd1 - Reserved 1
 */
#define CSS_CSS_KS17_ks17_rsvd1(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS17_ks17_rsvd1_SHIFT)) & CSS_CSS_KS17_ks17_rsvd1_MASK)

#define CSS_CSS_KS17_ks17_ucmac_MASK             (0x2000U)
#define CSS_CSS_KS17_ks17_ucmac_SHIFT            (13U)
/*! ks17_ucmac - CMAC key
 */
#define CSS_CSS_KS17_ks17_ucmac(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS17_ks17_ucmac_SHIFT)) & CSS_CSS_KS17_ks17_ucmac_MASK)

#define CSS_CSS_KS17_ks17_uksk_MASK              (0x4000U)
#define CSS_CSS_KS17_ks17_uksk_SHIFT             (14U)
/*! ks17_uksk - KSK key
 */
#define CSS_CSS_KS17_ks17_uksk(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS17_ks17_uksk_SHIFT)) & CSS_CSS_KS17_ks17_uksk_MASK)

#define CSS_CSS_KS17_ks17_urtf_MASK              (0x8000U)
#define CSS_CSS_KS17_ks17_urtf_SHIFT             (15U)
/*! ks17_urtf - Real Time Fingerprint key
 */
#define CSS_CSS_KS17_ks17_urtf(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS17_ks17_urtf_SHIFT)) & CSS_CSS_KS17_ks17_urtf_MASK)

#define CSS_CSS_KS17_ks17_uckdf_MASK             (0x10000U)
#define CSS_CSS_KS17_ks17_uckdf_SHIFT            (16U)
/*! ks17_uckdf - Derivation key for CKDF command
 */
#define CSS_CSS_KS17_ks17_uckdf(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS17_ks17_uckdf_SHIFT)) & CSS_CSS_KS17_ks17_uckdf_MASK)

#define CSS_CSS_KS17_ks17_uhkdf_MASK             (0x20000U)
#define CSS_CSS_KS17_ks17_uhkdf_SHIFT            (17U)
/*! ks17_uhkdf - Derivation key for HKDF command
 */
#define CSS_CSS_KS17_ks17_uhkdf(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS17_ks17_uhkdf_SHIFT)) & CSS_CSS_KS17_ks17_uhkdf_MASK)

#define CSS_CSS_KS17_ks17_uecsg_MASK             (0x40000U)
#define CSS_CSS_KS17_ks17_uecsg_SHIFT            (18U)
/*! ks17_uecsg - Ecc signing key
 */
#define CSS_CSS_KS17_ks17_uecsg(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS17_ks17_uecsg_SHIFT)) & CSS_CSS_KS17_ks17_uecsg_MASK)

#define CSS_CSS_KS17_ks17_uecdh_MASK             (0x80000U)
#define CSS_CSS_KS17_ks17_uecdh_SHIFT            (19U)
/*! ks17_uecdh - Ecc diffie hellman key
 */
#define CSS_CSS_KS17_ks17_uecdh(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS17_ks17_uecdh_SHIFT)) & CSS_CSS_KS17_ks17_uecdh_MASK)

#define CSS_CSS_KS17_ks17_uaes_MASK              (0x100000U)
#define CSS_CSS_KS17_ks17_uaes_SHIFT             (20U)
/*! ks17_uaes - Aes key
 */
#define CSS_CSS_KS17_ks17_uaes(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS17_ks17_uaes_SHIFT)) & CSS_CSS_KS17_ks17_uaes_MASK)

#define CSS_CSS_KS17_ks17_uhmac_MASK             (0x200000U)
#define CSS_CSS_KS17_ks17_uhmac_SHIFT            (21U)
/*! ks17_uhmac - Hmac key
 */
#define CSS_CSS_KS17_ks17_uhmac(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS17_ks17_uhmac_SHIFT)) & CSS_CSS_KS17_ks17_uhmac_MASK)

#define CSS_CSS_KS17_ks17_ukwk_MASK              (0x400000U)
#define CSS_CSS_KS17_ks17_ukwk_SHIFT             (22U)
/*! ks17_ukwk - Key wrapping key
 */
#define CSS_CSS_KS17_ks17_ukwk(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS17_ks17_ukwk_SHIFT)) & CSS_CSS_KS17_ks17_ukwk_MASK)

#define CSS_CSS_KS17_ks17_ukuok_MASK             (0x800000U)
#define CSS_CSS_KS17_ks17_ukuok_SHIFT            (23U)
/*! ks17_ukuok - Key unwrapping key
 */
#define CSS_CSS_KS17_ks17_ukuok(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS17_ks17_ukuok_SHIFT)) & CSS_CSS_KS17_ks17_ukuok_MASK)

#define CSS_CSS_KS17_ks17_utlspms_MASK           (0x1000000U)
#define CSS_CSS_KS17_ks17_utlspms_SHIFT          (24U)
/*! ks17_utlspms - TLS Pre Master Secret
 */
#define CSS_CSS_KS17_ks17_utlspms(x)             (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS17_ks17_utlspms_SHIFT)) & CSS_CSS_KS17_ks17_utlspms_MASK)

#define CSS_CSS_KS17_ks17_utlsms_MASK            (0x2000000U)
#define CSS_CSS_KS17_ks17_utlsms_SHIFT           (25U)
/*! ks17_utlsms - TLS Master Secret
 */
#define CSS_CSS_KS17_ks17_utlsms(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS17_ks17_utlsms_SHIFT)) & CSS_CSS_KS17_ks17_utlsms_MASK)

#define CSS_CSS_KS17_ks17_ukgsrc_MASK            (0x4000000U)
#define CSS_CSS_KS17_ks17_ukgsrc_SHIFT           (26U)
/*! ks17_ukgsrc - Supply KEYGEN source
 */
#define CSS_CSS_KS17_ks17_ukgsrc(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS17_ks17_ukgsrc_SHIFT)) & CSS_CSS_KS17_ks17_ukgsrc_MASK)

#define CSS_CSS_KS17_ks17_uhwo_MASK              (0x8000000U)
#define CSS_CSS_KS17_ks17_uhwo_SHIFT             (27U)
/*! ks17_uhwo - Hardware out key
 */
#define CSS_CSS_KS17_ks17_uhwo(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS17_ks17_uhwo_SHIFT)) & CSS_CSS_KS17_ks17_uhwo_MASK)

#define CSS_CSS_KS17_ks17_uwrpok_MASK            (0x10000000U)
#define CSS_CSS_KS17_ks17_uwrpok_SHIFT           (28U)
/*! ks17_uwrpok - Ok to wrap key
 */
#define CSS_CSS_KS17_ks17_uwrpok(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS17_ks17_uwrpok_SHIFT)) & CSS_CSS_KS17_ks17_uwrpok_MASK)

#define CSS_CSS_KS17_ks17_uduk_MASK              (0x20000000U)
#define CSS_CSS_KS17_ks17_uduk_SHIFT             (29U)
/*! ks17_uduk - Device Unique Key
 */
#define CSS_CSS_KS17_ks17_uduk(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS17_ks17_uduk_SHIFT)) & CSS_CSS_KS17_ks17_uduk_MASK)

#define CSS_CSS_KS17_ks17_upprot_MASK            (0xC0000000U)
#define CSS_CSS_KS17_ks17_upprot_SHIFT           (30U)
/*! ks17_upprot - Priviledge level
 */
#define CSS_CSS_KS17_ks17_upprot(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS17_ks17_upprot_SHIFT)) & CSS_CSS_KS17_ks17_upprot_MASK)
/*! @} */

/*! @name CSS_KS18 - Status register */
/*! @{ */

#define CSS_CSS_KS18_ks18_ksize_MASK             (0x1U)
#define CSS_CSS_KS18_ks18_ksize_SHIFT            (0U)
/*! ks18_ksize - Key size: 0-128, 1-256
 */
#define CSS_CSS_KS18_ks18_ksize(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS18_ks18_ksize_SHIFT)) & CSS_CSS_KS18_ks18_ksize_MASK)

#define CSS_CSS_KS18_ks18_rsvd0_MASK             (0x1EU)
#define CSS_CSS_KS18_ks18_rsvd0_SHIFT            (1U)
/*! ks18_rsvd0 - Reserved 0
 */
#define CSS_CSS_KS18_ks18_rsvd0(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS18_ks18_rsvd0_SHIFT)) & CSS_CSS_KS18_ks18_rsvd0_MASK)

#define CSS_CSS_KS18_ks18_kact_MASK              (0x20U)
#define CSS_CSS_KS18_ks18_kact_SHIFT             (5U)
/*! ks18_kact - Key is active
 */
#define CSS_CSS_KS18_ks18_kact(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS18_ks18_kact_SHIFT)) & CSS_CSS_KS18_ks18_kact_MASK)

#define CSS_CSS_KS18_ks18_kbase_MASK             (0x40U)
#define CSS_CSS_KS18_ks18_kbase_SHIFT            (6U)
/*! ks18_kbase - First slot in a multislot key
 */
#define CSS_CSS_KS18_ks18_kbase(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS18_ks18_kbase_SHIFT)) & CSS_CSS_KS18_ks18_kbase_MASK)

#define CSS_CSS_KS18_ks18_fgp_MASK               (0x80U)
#define CSS_CSS_KS18_ks18_fgp_SHIFT              (7U)
/*! ks18_fgp - Hardware Feature General Purpose
 */
#define CSS_CSS_KS18_ks18_fgp(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS18_ks18_fgp_SHIFT)) & CSS_CSS_KS18_ks18_fgp_MASK)

#define CSS_CSS_KS18_ks18_frtn_MASK              (0x100U)
#define CSS_CSS_KS18_ks18_frtn_SHIFT             (8U)
/*! ks18_frtn - Hardware Feature Retention
 */
#define CSS_CSS_KS18_ks18_frtn(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS18_ks18_frtn_SHIFT)) & CSS_CSS_KS18_ks18_frtn_MASK)

#define CSS_CSS_KS18_ks18_fhwo_MASK              (0x200U)
#define CSS_CSS_KS18_ks18_fhwo_SHIFT             (9U)
/*! ks18_fhwo - Hardware Feature Output
 */
#define CSS_CSS_KS18_ks18_fhwo(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS18_ks18_fhwo_SHIFT)) & CSS_CSS_KS18_ks18_fhwo_MASK)

#define CSS_CSS_KS18_ks18_rsvd1_MASK             (0x1C00U)
#define CSS_CSS_KS18_ks18_rsvd1_SHIFT            (10U)
/*! ks18_rsvd1 - Reserved 1
 */
#define CSS_CSS_KS18_ks18_rsvd1(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS18_ks18_rsvd1_SHIFT)) & CSS_CSS_KS18_ks18_rsvd1_MASK)

#define CSS_CSS_KS18_ks18_ucmac_MASK             (0x2000U)
#define CSS_CSS_KS18_ks18_ucmac_SHIFT            (13U)
/*! ks18_ucmac - CMAC key
 */
#define CSS_CSS_KS18_ks18_ucmac(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS18_ks18_ucmac_SHIFT)) & CSS_CSS_KS18_ks18_ucmac_MASK)

#define CSS_CSS_KS18_ks18_uksk_MASK              (0x4000U)
#define CSS_CSS_KS18_ks18_uksk_SHIFT             (14U)
/*! ks18_uksk - KSK key
 */
#define CSS_CSS_KS18_ks18_uksk(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS18_ks18_uksk_SHIFT)) & CSS_CSS_KS18_ks18_uksk_MASK)

#define CSS_CSS_KS18_ks18_urtf_MASK              (0x8000U)
#define CSS_CSS_KS18_ks18_urtf_SHIFT             (15U)
/*! ks18_urtf - Real Time Fingerprint key
 */
#define CSS_CSS_KS18_ks18_urtf(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS18_ks18_urtf_SHIFT)) & CSS_CSS_KS18_ks18_urtf_MASK)

#define CSS_CSS_KS18_ks18_uckdf_MASK             (0x10000U)
#define CSS_CSS_KS18_ks18_uckdf_SHIFT            (16U)
/*! ks18_uckdf - Derivation key for CKDF command
 */
#define CSS_CSS_KS18_ks18_uckdf(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS18_ks18_uckdf_SHIFT)) & CSS_CSS_KS18_ks18_uckdf_MASK)

#define CSS_CSS_KS18_ks18_uhkdf_MASK             (0x20000U)
#define CSS_CSS_KS18_ks18_uhkdf_SHIFT            (17U)
/*! ks18_uhkdf - Derivation key for HKDF command
 */
#define CSS_CSS_KS18_ks18_uhkdf(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS18_ks18_uhkdf_SHIFT)) & CSS_CSS_KS18_ks18_uhkdf_MASK)

#define CSS_CSS_KS18_ks18_uecsg_MASK             (0x40000U)
#define CSS_CSS_KS18_ks18_uecsg_SHIFT            (18U)
/*! ks18_uecsg - Ecc signing key
 */
#define CSS_CSS_KS18_ks18_uecsg(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS18_ks18_uecsg_SHIFT)) & CSS_CSS_KS18_ks18_uecsg_MASK)

#define CSS_CSS_KS18_ks18_uecdh_MASK             (0x80000U)
#define CSS_CSS_KS18_ks18_uecdh_SHIFT            (19U)
/*! ks18_uecdh - Ecc diffie hellman key
 */
#define CSS_CSS_KS18_ks18_uecdh(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS18_ks18_uecdh_SHIFT)) & CSS_CSS_KS18_ks18_uecdh_MASK)

#define CSS_CSS_KS18_ks18_uaes_MASK              (0x100000U)
#define CSS_CSS_KS18_ks18_uaes_SHIFT             (20U)
/*! ks18_uaes - Aes key
 */
#define CSS_CSS_KS18_ks18_uaes(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS18_ks18_uaes_SHIFT)) & CSS_CSS_KS18_ks18_uaes_MASK)

#define CSS_CSS_KS18_ks18_uhmac_MASK             (0x200000U)
#define CSS_CSS_KS18_ks18_uhmac_SHIFT            (21U)
/*! ks18_uhmac - Hmac key
 */
#define CSS_CSS_KS18_ks18_uhmac(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS18_ks18_uhmac_SHIFT)) & CSS_CSS_KS18_ks18_uhmac_MASK)

#define CSS_CSS_KS18_ks18_ukwk_MASK              (0x400000U)
#define CSS_CSS_KS18_ks18_ukwk_SHIFT             (22U)
/*! ks18_ukwk - Key wrapping key
 */
#define CSS_CSS_KS18_ks18_ukwk(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS18_ks18_ukwk_SHIFT)) & CSS_CSS_KS18_ks18_ukwk_MASK)

#define CSS_CSS_KS18_ks18_ukuok_MASK             (0x800000U)
#define CSS_CSS_KS18_ks18_ukuok_SHIFT            (23U)
/*! ks18_ukuok - Key unwrapping key
 */
#define CSS_CSS_KS18_ks18_ukuok(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS18_ks18_ukuok_SHIFT)) & CSS_CSS_KS18_ks18_ukuok_MASK)

#define CSS_CSS_KS18_ks18_utlspms_MASK           (0x1000000U)
#define CSS_CSS_KS18_ks18_utlspms_SHIFT          (24U)
/*! ks18_utlspms - TLS Pre Master Secret
 */
#define CSS_CSS_KS18_ks18_utlspms(x)             (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS18_ks18_utlspms_SHIFT)) & CSS_CSS_KS18_ks18_utlspms_MASK)

#define CSS_CSS_KS18_ks18_utlsms_MASK            (0x2000000U)
#define CSS_CSS_KS18_ks18_utlsms_SHIFT           (25U)
/*! ks18_utlsms - TLS Master Secret
 */
#define CSS_CSS_KS18_ks18_utlsms(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS18_ks18_utlsms_SHIFT)) & CSS_CSS_KS18_ks18_utlsms_MASK)

#define CSS_CSS_KS18_ks18_ukgsrc_MASK            (0x4000000U)
#define CSS_CSS_KS18_ks18_ukgsrc_SHIFT           (26U)
/*! ks18_ukgsrc - Supply KEYGEN source
 */
#define CSS_CSS_KS18_ks18_ukgsrc(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS18_ks18_ukgsrc_SHIFT)) & CSS_CSS_KS18_ks18_ukgsrc_MASK)

#define CSS_CSS_KS18_ks18_uhwo_MASK              (0x8000000U)
#define CSS_CSS_KS18_ks18_uhwo_SHIFT             (27U)
/*! ks18_uhwo - Hardware out key
 */
#define CSS_CSS_KS18_ks18_uhwo(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS18_ks18_uhwo_SHIFT)) & CSS_CSS_KS18_ks18_uhwo_MASK)

#define CSS_CSS_KS18_ks18_uwrpok_MASK            (0x10000000U)
#define CSS_CSS_KS18_ks18_uwrpok_SHIFT           (28U)
/*! ks18_uwrpok - Ok to wrap key
 */
#define CSS_CSS_KS18_ks18_uwrpok(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS18_ks18_uwrpok_SHIFT)) & CSS_CSS_KS18_ks18_uwrpok_MASK)

#define CSS_CSS_KS18_ks18_uduk_MASK              (0x20000000U)
#define CSS_CSS_KS18_ks18_uduk_SHIFT             (29U)
/*! ks18_uduk - Device Unique Key
 */
#define CSS_CSS_KS18_ks18_uduk(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS18_ks18_uduk_SHIFT)) & CSS_CSS_KS18_ks18_uduk_MASK)

#define CSS_CSS_KS18_ks18_upprot_MASK            (0xC0000000U)
#define CSS_CSS_KS18_ks18_upprot_SHIFT           (30U)
/*! ks18_upprot - Priviledge level
 */
#define CSS_CSS_KS18_ks18_upprot(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS18_ks18_upprot_SHIFT)) & CSS_CSS_KS18_ks18_upprot_MASK)
/*! @} */

/*! @name CSS_KS19 - Status register */
/*! @{ */

#define CSS_CSS_KS19_ks19_ksize_MASK             (0x1U)
#define CSS_CSS_KS19_ks19_ksize_SHIFT            (0U)
/*! ks19_ksize - Key size: 0-128, 1-256
 */
#define CSS_CSS_KS19_ks19_ksize(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS19_ks19_ksize_SHIFT)) & CSS_CSS_KS19_ks19_ksize_MASK)

#define CSS_CSS_KS19_ks19_rsvd0_MASK             (0x1EU)
#define CSS_CSS_KS19_ks19_rsvd0_SHIFT            (1U)
/*! ks19_rsvd0 - Reserved 0
 */
#define CSS_CSS_KS19_ks19_rsvd0(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS19_ks19_rsvd0_SHIFT)) & CSS_CSS_KS19_ks19_rsvd0_MASK)

#define CSS_CSS_KS19_ks19_kact_MASK              (0x20U)
#define CSS_CSS_KS19_ks19_kact_SHIFT             (5U)
/*! ks19_kact - Key is active
 */
#define CSS_CSS_KS19_ks19_kact(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS19_ks19_kact_SHIFT)) & CSS_CSS_KS19_ks19_kact_MASK)

#define CSS_CSS_KS19_ks19_kbase_MASK             (0x40U)
#define CSS_CSS_KS19_ks19_kbase_SHIFT            (6U)
/*! ks19_kbase - First slot in a multislot key
 */
#define CSS_CSS_KS19_ks19_kbase(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS19_ks19_kbase_SHIFT)) & CSS_CSS_KS19_ks19_kbase_MASK)

#define CSS_CSS_KS19_ks19_fgp_MASK               (0x80U)
#define CSS_CSS_KS19_ks19_fgp_SHIFT              (7U)
/*! ks19_fgp - Hardware Feature General Purpose
 */
#define CSS_CSS_KS19_ks19_fgp(x)                 (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS19_ks19_fgp_SHIFT)) & CSS_CSS_KS19_ks19_fgp_MASK)

#define CSS_CSS_KS19_ks19_frtn_MASK              (0x100U)
#define CSS_CSS_KS19_ks19_frtn_SHIFT             (8U)
/*! ks19_frtn - Hardware Feature Retention
 */
#define CSS_CSS_KS19_ks19_frtn(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS19_ks19_frtn_SHIFT)) & CSS_CSS_KS19_ks19_frtn_MASK)

#define CSS_CSS_KS19_ks19_fhwo_MASK              (0x200U)
#define CSS_CSS_KS19_ks19_fhwo_SHIFT             (9U)
/*! ks19_fhwo - Hardware Feature Output
 */
#define CSS_CSS_KS19_ks19_fhwo(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS19_ks19_fhwo_SHIFT)) & CSS_CSS_KS19_ks19_fhwo_MASK)

#define CSS_CSS_KS19_ks19_rsvd1_MASK             (0x1C00U)
#define CSS_CSS_KS19_ks19_rsvd1_SHIFT            (10U)
/*! ks19_rsvd1 - Reserved 1
 */
#define CSS_CSS_KS19_ks19_rsvd1(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS19_ks19_rsvd1_SHIFT)) & CSS_CSS_KS19_ks19_rsvd1_MASK)

#define CSS_CSS_KS19_ks19_ucmac_MASK             (0x2000U)
#define CSS_CSS_KS19_ks19_ucmac_SHIFT            (13U)
/*! ks19_ucmac - CMAC key
 */
#define CSS_CSS_KS19_ks19_ucmac(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS19_ks19_ucmac_SHIFT)) & CSS_CSS_KS19_ks19_ucmac_MASK)

#define CSS_CSS_KS19_ks19_uksk_MASK              (0x4000U)
#define CSS_CSS_KS19_ks19_uksk_SHIFT             (14U)
/*! ks19_uksk - KSK key
 */
#define CSS_CSS_KS19_ks19_uksk(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS19_ks19_uksk_SHIFT)) & CSS_CSS_KS19_ks19_uksk_MASK)

#define CSS_CSS_KS19_ks19_urtf_MASK              (0x8000U)
#define CSS_CSS_KS19_ks19_urtf_SHIFT             (15U)
/*! ks19_urtf - Real Time Fingerprint key
 */
#define CSS_CSS_KS19_ks19_urtf(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS19_ks19_urtf_SHIFT)) & CSS_CSS_KS19_ks19_urtf_MASK)

#define CSS_CSS_KS19_ks19_uckdf_MASK             (0x10000U)
#define CSS_CSS_KS19_ks19_uckdf_SHIFT            (16U)
/*! ks19_uckdf - Derivation key for CKDF command
 */
#define CSS_CSS_KS19_ks19_uckdf(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS19_ks19_uckdf_SHIFT)) & CSS_CSS_KS19_ks19_uckdf_MASK)

#define CSS_CSS_KS19_ks19_uhkdf_MASK             (0x20000U)
#define CSS_CSS_KS19_ks19_uhkdf_SHIFT            (17U)
/*! ks19_uhkdf - Derivation key for HKDF command
 */
#define CSS_CSS_KS19_ks19_uhkdf(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS19_ks19_uhkdf_SHIFT)) & CSS_CSS_KS19_ks19_uhkdf_MASK)

#define CSS_CSS_KS19_ks19_uecsg_MASK             (0x40000U)
#define CSS_CSS_KS19_ks19_uecsg_SHIFT            (18U)
/*! ks19_uecsg - Ecc signing key
 */
#define CSS_CSS_KS19_ks19_uecsg(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS19_ks19_uecsg_SHIFT)) & CSS_CSS_KS19_ks19_uecsg_MASK)

#define CSS_CSS_KS19_ks19_uecdh_MASK             (0x80000U)
#define CSS_CSS_KS19_ks19_uecdh_SHIFT            (19U)
/*! ks19_uecdh - Ecc diffie hellman key
 */
#define CSS_CSS_KS19_ks19_uecdh(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS19_ks19_uecdh_SHIFT)) & CSS_CSS_KS19_ks19_uecdh_MASK)

#define CSS_CSS_KS19_ks19_uaes_MASK              (0x100000U)
#define CSS_CSS_KS19_ks19_uaes_SHIFT             (20U)
/*! ks19_uaes - Aes key
 */
#define CSS_CSS_KS19_ks19_uaes(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS19_ks19_uaes_SHIFT)) & CSS_CSS_KS19_ks19_uaes_MASK)

#define CSS_CSS_KS19_ks19_uhmac_MASK             (0x200000U)
#define CSS_CSS_KS19_ks19_uhmac_SHIFT            (21U)
/*! ks19_uhmac - Hmac key
 */
#define CSS_CSS_KS19_ks19_uhmac(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS19_ks19_uhmac_SHIFT)) & CSS_CSS_KS19_ks19_uhmac_MASK)

#define CSS_CSS_KS19_ks19_ukwk_MASK              (0x400000U)
#define CSS_CSS_KS19_ks19_ukwk_SHIFT             (22U)
/*! ks19_ukwk - Key wrapping key
 */
#define CSS_CSS_KS19_ks19_ukwk(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS19_ks19_ukwk_SHIFT)) & CSS_CSS_KS19_ks19_ukwk_MASK)

#define CSS_CSS_KS19_ks19_ukuok_MASK             (0x800000U)
#define CSS_CSS_KS19_ks19_ukuok_SHIFT            (23U)
/*! ks19_ukuok - Key unwrapping key
 */
#define CSS_CSS_KS19_ks19_ukuok(x)               (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS19_ks19_ukuok_SHIFT)) & CSS_CSS_KS19_ks19_ukuok_MASK)

#define CSS_CSS_KS19_ks19_utlspms_MASK           (0x1000000U)
#define CSS_CSS_KS19_ks19_utlspms_SHIFT          (24U)
/*! ks19_utlspms - TLS Pre Master Secret
 */
#define CSS_CSS_KS19_ks19_utlspms(x)             (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS19_ks19_utlspms_SHIFT)) & CSS_CSS_KS19_ks19_utlspms_MASK)

#define CSS_CSS_KS19_ks19_utlsms_MASK            (0x2000000U)
#define CSS_CSS_KS19_ks19_utlsms_SHIFT           (25U)
/*! ks19_utlsms - TLS Master Secret
 */
#define CSS_CSS_KS19_ks19_utlsms(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS19_ks19_utlsms_SHIFT)) & CSS_CSS_KS19_ks19_utlsms_MASK)

#define CSS_CSS_KS19_ks19_ukgsrc_MASK            (0x4000000U)
#define CSS_CSS_KS19_ks19_ukgsrc_SHIFT           (26U)
/*! ks19_ukgsrc - Supply KEYGEN source
 */
#define CSS_CSS_KS19_ks19_ukgsrc(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS19_ks19_ukgsrc_SHIFT)) & CSS_CSS_KS19_ks19_ukgsrc_MASK)

#define CSS_CSS_KS19_ks19_uhwo_MASK              (0x8000000U)
#define CSS_CSS_KS19_ks19_uhwo_SHIFT             (27U)
/*! ks19_uhwo - Hardware out key
 */
#define CSS_CSS_KS19_ks19_uhwo(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS19_ks19_uhwo_SHIFT)) & CSS_CSS_KS19_ks19_uhwo_MASK)

#define CSS_CSS_KS19_ks19_uwrpok_MASK            (0x10000000U)
#define CSS_CSS_KS19_ks19_uwrpok_SHIFT           (28U)
/*! ks19_uwrpok - Ok to wrap key
 */
#define CSS_CSS_KS19_ks19_uwrpok(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS19_ks19_uwrpok_SHIFT)) & CSS_CSS_KS19_ks19_uwrpok_MASK)

#define CSS_CSS_KS19_ks19_uduk_MASK              (0x20000000U)
#define CSS_CSS_KS19_ks19_uduk_SHIFT             (29U)
/*! ks19_uduk - Device Unique Key
 */
#define CSS_CSS_KS19_ks19_uduk(x)                (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS19_ks19_uduk_SHIFT)) & CSS_CSS_KS19_ks19_uduk_MASK)

#define CSS_CSS_KS19_ks19_upprot_MASK            (0xC0000000U)
#define CSS_CSS_KS19_ks19_upprot_SHIFT           (30U)
/*! ks19_upprot - Priviledge level
 */
#define CSS_CSS_KS19_ks19_upprot(x)              (((uint32_t)(((uint32_t)(x)) << CSS_CSS_KS19_ks19_upprot_SHIFT)) & CSS_CSS_KS19_ks19_upprot_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CSS_Register_Masks */


/* CSS - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral CSS base address */
  #define CSS_BASE                                 (0x50030000u)
  /** Peripheral CSS base address */
  #define CSS_BASE_NS                              (0x40030000u)
  /** Peripheral CSS base pointer */
  #define CSS                                      ((CSS_Type *)CSS_BASE)
  /** Peripheral CSS base pointer */
  #define CSS_NS                                   ((CSS_Type *)CSS_BASE_NS)
  /** Array initializer of CSS peripheral base addresses */
  #define CSS_BASE_ADDRS                           { CSS_BASE }
  /** Array initializer of CSS peripheral base pointers */
  #define CSS_BASE_PTRS                            { CSS }
  /** Array initializer of CSS peripheral base addresses */
  #define CSS_BASE_ADDRS_NS                        { CSS_BASE_NS }
  /** Array initializer of CSS peripheral base pointers */
  #define CSS_BASE_PTRS_NS                         { CSS_NS }
#else
  /** Peripheral CSS base address */
  #define CSS_BASE                                 (0x40030000u)
  /** Peripheral CSS base pointer */
  #define CSS                                      ((CSS_Type *)CSS_BASE)
  /** Array initializer of CSS peripheral base addresses */
  #define CSS_BASE_ADDRS                           { CSS_BASE }
  /** Array initializer of CSS peripheral base pointers */
  #define CSS_BASE_PTRS                            { CSS }
#endif

/*!
 * @}
 */ /* end of group CSS_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CTIMER Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CTIMER_Peripheral_Access_Layer CTIMER Peripheral Access Layer
 * @{
 */

/** CTIMER - Register Layout Typedef */
typedef struct {
  __IO uint32_t IR;                                /**< Interrupt Register, offset: 0x0 */
  __IO uint32_t TCR;                               /**< Timer Control Register, offset: 0x4 */
  __IO uint32_t TC;                                /**< Timer Counter, offset: 0x8 */
  __IO uint32_t PR;                                /**< Prescale Register, offset: 0xC */
  __IO uint32_t PC;                                /**< Prescale Counter, offset: 0x10 */
  __IO uint32_t MCR;                               /**< Match Control Register, offset: 0x14 */
  __IO uint32_t MR[4];                             /**< Match Register, array offset: 0x18, array step: 0x4 */
  __IO uint32_t CCR;                               /**< Capture Control Register, offset: 0x28 */
  __I  uint32_t CR[4];                             /**< Capture Register, array offset: 0x2C, array step: 0x4 */
  __IO uint32_t EMR;                               /**< External Match Register, offset: 0x3C */
       uint8_t RESERVED_0[48];
  __IO uint32_t CTCR;                              /**< Count Control Register, offset: 0x70 */
  __IO uint32_t PWMC;                              /**< PWM Control Register, offset: 0x74 */
  __IO uint32_t MSR[4];                            /**< Match Shadow Register, array offset: 0x78, array step: 0x4 */
} CTIMER_Type;

/* ----------------------------------------------------------------------------
   -- CTIMER Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CTIMER_Register_Masks CTIMER Register Masks
 * @{
 */

/*! @name IR - Interrupt Register */
/*! @{ */

#define CTIMER_IR_MR0INT_MASK                    (0x1U)
#define CTIMER_IR_MR0INT_SHIFT                   (0U)
/*! MR0INT - Interrupt flag for match channel 0
 */
#define CTIMER_IR_MR0INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR0INT_SHIFT)) & CTIMER_IR_MR0INT_MASK)

#define CTIMER_IR_MR1INT_MASK                    (0x2U)
#define CTIMER_IR_MR1INT_SHIFT                   (1U)
/*! MR1INT - Interrupt flag for match channel 1
 */
#define CTIMER_IR_MR1INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR1INT_SHIFT)) & CTIMER_IR_MR1INT_MASK)

#define CTIMER_IR_MR2INT_MASK                    (0x4U)
#define CTIMER_IR_MR2INT_SHIFT                   (2U)
/*! MR2INT - Interrupt flag for match channel 2
 */
#define CTIMER_IR_MR2INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR2INT_SHIFT)) & CTIMER_IR_MR2INT_MASK)

#define CTIMER_IR_MR3INT_MASK                    (0x8U)
#define CTIMER_IR_MR3INT_SHIFT                   (3U)
/*! MR3INT - Interrupt flag for match channel 3
 */
#define CTIMER_IR_MR3INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR3INT_SHIFT)) & CTIMER_IR_MR3INT_MASK)

#define CTIMER_IR_CR0INT_MASK                    (0x10U)
#define CTIMER_IR_CR0INT_SHIFT                   (4U)
/*! CR0INT - Interrupt flag for capture channel 0 event
 */
#define CTIMER_IR_CR0INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR0INT_SHIFT)) & CTIMER_IR_CR0INT_MASK)

#define CTIMER_IR_CR1INT_MASK                    (0x20U)
#define CTIMER_IR_CR1INT_SHIFT                   (5U)
/*! CR1INT - Interrupt flag for capture channel 1 event
 */
#define CTIMER_IR_CR1INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR1INT_SHIFT)) & CTIMER_IR_CR1INT_MASK)

#define CTIMER_IR_CR2INT_MASK                    (0x40U)
#define CTIMER_IR_CR2INT_SHIFT                   (6U)
/*! CR2INT - Interrupt flag for capture channel 2 event
 */
#define CTIMER_IR_CR2INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR2INT_SHIFT)) & CTIMER_IR_CR2INT_MASK)

#define CTIMER_IR_CR3INT_MASK                    (0x80U)
#define CTIMER_IR_CR3INT_SHIFT                   (7U)
/*! CR3INT - Interrupt flag for capture channel 3 event
 */
#define CTIMER_IR_CR3INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR3INT_SHIFT)) & CTIMER_IR_CR3INT_MASK)
/*! @} */

/*! @name TCR - Timer Control Register */
/*! @{ */

#define CTIMER_TCR_CEN_MASK                      (0x1U)
#define CTIMER_TCR_CEN_SHIFT                     (0U)
/*! CEN - Counter enable
 *  0b0..Disabled. The counters are disabled
 *  0b1..Enabled. The Timer Counter and Prescale Counter are enabled. When the timer is enabled by an external
 *       trigger or globally enabled by the external global start enable register, the CEN bit will automatically be
 *       set to 1
 */
#define CTIMER_TCR_CEN(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_TCR_CEN_SHIFT)) & CTIMER_TCR_CEN_MASK)

#define CTIMER_TCR_CRST_MASK                     (0x2U)
#define CTIMER_TCR_CRST_SHIFT                    (1U)
/*! CRST - Counter reset
 *  0b0..Disabled. Do nothing
 *  0b1..Enabled
 */
#define CTIMER_TCR_CRST(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_TCR_CRST_SHIFT)) & CTIMER_TCR_CRST_MASK)

#define CTIMER_TCR_AGCEN_MASK                    (0x10U)
#define CTIMER_TCR_AGCEN_SHIFT                   (4U)
/*! AGCEN - Allow Global Count Enable
 *  0b0..Not allowed
 *  0b1..Allow input global_enable=1 action to take effect
 */
#define CTIMER_TCR_AGCEN(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_TCR_AGCEN_SHIFT)) & CTIMER_TCR_AGCEN_MASK)

#define CTIMER_TCR_ATCEN_MASK                    (0x20U)
#define CTIMER_TCR_ATCEN_SHIFT                   (5U)
/*! ATCEN - Allow Trigger Count Enable
 *  0b0..Not allowed
 *  0b1..Allow input trigger_enable=1 action to take effect
 */
#define CTIMER_TCR_ATCEN(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_TCR_ATCEN_SHIFT)) & CTIMER_TCR_ATCEN_MASK)
/*! @} */

/*! @name TC - Timer Counter */
/*! @{ */

#define CTIMER_TC_TCVAL_MASK                     (0xFFFFFFFFU)
#define CTIMER_TC_TCVAL_SHIFT                    (0U)
/*! TCVAL - Timer counter value
 */
#define CTIMER_TC_TCVAL(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_TC_TCVAL_SHIFT)) & CTIMER_TC_TCVAL_MASK)
/*! @} */

/*! @name PR - Prescale Register */
/*! @{ */

#define CTIMER_PR_PRVAL_MASK                     (0xFFFFFFFFU)
#define CTIMER_PR_PRVAL_SHIFT                    (0U)
/*! PRVAL - Prescale reload value
 */
#define CTIMER_PR_PRVAL(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_PR_PRVAL_SHIFT)) & CTIMER_PR_PRVAL_MASK)
/*! @} */

/*! @name PC - Prescale Counter */
/*! @{ */

#define CTIMER_PC_PCVAL_MASK                     (0xFFFFFFFFU)
#define CTIMER_PC_PCVAL_SHIFT                    (0U)
/*! PCVAL - Prescale counter value
 */
#define CTIMER_PC_PCVAL(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_PC_PCVAL_SHIFT)) & CTIMER_PC_PCVAL_MASK)
/*! @} */

/*! @name MCR - Match Control Register */
/*! @{ */

#define CTIMER_MCR_MR0I_MASK                     (0x1U)
#define CTIMER_MCR_MR0I_SHIFT                    (0U)
/*! MR0I - Interrupt on MR0
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR0I(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0I_SHIFT)) & CTIMER_MCR_MR0I_MASK)

#define CTIMER_MCR_MR0R_MASK                     (0x2U)
#define CTIMER_MCR_MR0R_SHIFT                    (1U)
/*! MR0R - Reset on MR0
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR0R(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0R_SHIFT)) & CTIMER_MCR_MR0R_MASK)

#define CTIMER_MCR_MR0S_MASK                     (0x4U)
#define CTIMER_MCR_MR0S_SHIFT                    (2U)
/*! MR0S - Stop on MR0
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR0S(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0S_SHIFT)) & CTIMER_MCR_MR0S_MASK)

#define CTIMER_MCR_MR1I_MASK                     (0x8U)
#define CTIMER_MCR_MR1I_SHIFT                    (3U)
/*! MR1I - Interrupt on MR1
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR1I(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1I_SHIFT)) & CTIMER_MCR_MR1I_MASK)

#define CTIMER_MCR_MR1R_MASK                     (0x10U)
#define CTIMER_MCR_MR1R_SHIFT                    (4U)
/*! MR1R - Reset on MR1
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR1R(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1R_SHIFT)) & CTIMER_MCR_MR1R_MASK)

#define CTIMER_MCR_MR1S_MASK                     (0x20U)
#define CTIMER_MCR_MR1S_SHIFT                    (5U)
/*! MR1S - Stop on MR1
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR1S(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1S_SHIFT)) & CTIMER_MCR_MR1S_MASK)

#define CTIMER_MCR_MR2I_MASK                     (0x40U)
#define CTIMER_MCR_MR2I_SHIFT                    (6U)
/*! MR2I - Interrupt on MR2
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR2I(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2I_SHIFT)) & CTIMER_MCR_MR2I_MASK)

#define CTIMER_MCR_MR2R_MASK                     (0x80U)
#define CTIMER_MCR_MR2R_SHIFT                    (7U)
/*! MR2R - Reset on MR2
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR2R(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2R_SHIFT)) & CTIMER_MCR_MR2R_MASK)

#define CTIMER_MCR_MR2S_MASK                     (0x100U)
#define CTIMER_MCR_MR2S_SHIFT                    (8U)
/*! MR2S - Stop on MR2
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR2S(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2S_SHIFT)) & CTIMER_MCR_MR2S_MASK)

#define CTIMER_MCR_MR3I_MASK                     (0x200U)
#define CTIMER_MCR_MR3I_SHIFT                    (9U)
/*! MR3I - Interrupt on MR3
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR3I(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3I_SHIFT)) & CTIMER_MCR_MR3I_MASK)

#define CTIMER_MCR_MR3R_MASK                     (0x400U)
#define CTIMER_MCR_MR3R_SHIFT                    (10U)
/*! MR3R - Reset on MR3
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR3R(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3R_SHIFT)) & CTIMER_MCR_MR3R_MASK)

#define CTIMER_MCR_MR3S_MASK                     (0x800U)
#define CTIMER_MCR_MR3S_SHIFT                    (11U)
/*! MR3S - Stop on MR3
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR3S(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3S_SHIFT)) & CTIMER_MCR_MR3S_MASK)

#define CTIMER_MCR_MR0RL_MASK                    (0x1000000U)
#define CTIMER_MCR_MR0RL_SHIFT                   (24U)
/*! MR0RL - Reload MR0
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR0RL(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0RL_SHIFT)) & CTIMER_MCR_MR0RL_MASK)

#define CTIMER_MCR_MR1RL_MASK                    (0x2000000U)
#define CTIMER_MCR_MR1RL_SHIFT                   (25U)
/*! MR1RL - Reload MR1
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR1RL(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1RL_SHIFT)) & CTIMER_MCR_MR1RL_MASK)

#define CTIMER_MCR_MR2RL_MASK                    (0x4000000U)
#define CTIMER_MCR_MR2RL_SHIFT                   (26U)
/*! MR2RL - Reload MR2
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR2RL(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2RL_SHIFT)) & CTIMER_MCR_MR2RL_MASK)

#define CTIMER_MCR_MR3RL_MASK                    (0x8000000U)
#define CTIMER_MCR_MR3RL_SHIFT                   (27U)
/*! MR3RL - Reload MR3
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR3RL(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3RL_SHIFT)) & CTIMER_MCR_MR3RL_MASK)
/*! @} */

/*! @name MR - Match Register */
/*! @{ */

#define CTIMER_MR_MATCH_MASK                     (0xFFFFFFFFU)
#define CTIMER_MR_MATCH_SHIFT                    (0U)
/*! MATCH - Timer counter match value
 */
#define CTIMER_MR_MATCH(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MR_MATCH_SHIFT)) & CTIMER_MR_MATCH_MASK)
/*! @} */

/* The count of CTIMER_MR */
#define CTIMER_MR_COUNT                          (4U)

/*! @name CCR - Capture Control Register */
/*! @{ */

#define CTIMER_CCR_CAP0RE_MASK                   (0x1U)
#define CTIMER_CCR_CAP0RE_SHIFT                  (0U)
/*! CAP0RE - Rising edge of capture channel 0: a sequence of 0 then 1 causes CR0 to be loaded with the contents of TC
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP0RE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP0RE_SHIFT)) & CTIMER_CCR_CAP0RE_MASK)

#define CTIMER_CCR_CAP0FE_MASK                   (0x2U)
#define CTIMER_CCR_CAP0FE_SHIFT                  (1U)
/*! CAP0FE - Falling edge of capture channel 0: a sequence of 1 then 0 causes CR0 to be loaded with the contents of TC
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP0FE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP0FE_SHIFT)) & CTIMER_CCR_CAP0FE_MASK)

#define CTIMER_CCR_CAP0I_MASK                    (0x4U)
#define CTIMER_CCR_CAP0I_SHIFT                   (2U)
/*! CAP0I - Generate interrupt on channel 0 capture event: a CR0 load generates an interrupt
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP0I(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP0I_SHIFT)) & CTIMER_CCR_CAP0I_MASK)

#define CTIMER_CCR_CAP1RE_MASK                   (0x8U)
#define CTIMER_CCR_CAP1RE_SHIFT                  (3U)
/*! CAP1RE - Rising edge of capture channel 1: a sequence of 0 then 1 causes CR1 to be loaded with the contents of TC
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP1RE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP1RE_SHIFT)) & CTIMER_CCR_CAP1RE_MASK)

#define CTIMER_CCR_CAP1FE_MASK                   (0x10U)
#define CTIMER_CCR_CAP1FE_SHIFT                  (4U)
/*! CAP1FE - Falling edge of capture channel 1: a sequence of 1 then 0 causes CR1 to be loaded with the contents of TC
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP1FE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP1FE_SHIFT)) & CTIMER_CCR_CAP1FE_MASK)

#define CTIMER_CCR_CAP1I_MASK                    (0x20U)
#define CTIMER_CCR_CAP1I_SHIFT                   (5U)
/*! CAP1I - Generate interrupt on channel 1 capture event: a CR1 load generates an interrupt
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP1I(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP1I_SHIFT)) & CTIMER_CCR_CAP1I_MASK)

#define CTIMER_CCR_CAP2RE_MASK                   (0x40U)
#define CTIMER_CCR_CAP2RE_SHIFT                  (6U)
/*! CAP2RE - Rising edge of capture channel 2: a sequence of 0 then 1 causes CR2 to be loaded with the contents of TC
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP2RE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP2RE_SHIFT)) & CTIMER_CCR_CAP2RE_MASK)

#define CTIMER_CCR_CAP2FE_MASK                   (0x80U)
#define CTIMER_CCR_CAP2FE_SHIFT                  (7U)
/*! CAP2FE - Falling edge of capture channel 2: a sequence of 1 then 0 causes CR2 to be loaded with the contents of TC
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP2FE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP2FE_SHIFT)) & CTIMER_CCR_CAP2FE_MASK)

#define CTIMER_CCR_CAP2I_MASK                    (0x100U)
#define CTIMER_CCR_CAP2I_SHIFT                   (8U)
/*! CAP2I - Generate interrupt on channel 2 capture event: a CR2 load generates an interrupt
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP2I(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP2I_SHIFT)) & CTIMER_CCR_CAP2I_MASK)

#define CTIMER_CCR_CAP3RE_MASK                   (0x200U)
#define CTIMER_CCR_CAP3RE_SHIFT                  (9U)
/*! CAP3RE - Rising edge of capture channel 3: a sequence of 0 then 1 causes CR3 to be loaded with the contents of TC
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP3RE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP3RE_SHIFT)) & CTIMER_CCR_CAP3RE_MASK)

#define CTIMER_CCR_CAP3FE_MASK                   (0x400U)
#define CTIMER_CCR_CAP3FE_SHIFT                  (10U)
/*! CAP3FE - Falling edge of capture channel 3: a sequence of 1 then 0 causes CR3 to be loaded with the contents of TC
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP3FE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP3FE_SHIFT)) & CTIMER_CCR_CAP3FE_MASK)

#define CTIMER_CCR_CAP3I_MASK                    (0x800U)
#define CTIMER_CCR_CAP3I_SHIFT                   (11U)
/*! CAP3I - Generate interrupt on channel 3 capture event: a CR3 load generates an interrupt
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP3I(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP3I_SHIFT)) & CTIMER_CCR_CAP3I_MASK)
/*! @} */

/*! @name CR - Capture Register */
/*! @{ */

#define CTIMER_CR_CAP_MASK                       (0xFFFFFFFFU)
#define CTIMER_CR_CAP_SHIFT                      (0U)
/*! CAP - Timer counter capture value
 */
#define CTIMER_CR_CAP(x)                         (((uint32_t)(((uint32_t)(x)) << CTIMER_CR_CAP_SHIFT)) & CTIMER_CR_CAP_MASK)
/*! @} */

/* The count of CTIMER_CR */
#define CTIMER_CR_COUNT                          (4U)

/*! @name EMR - External Match Register */
/*! @{ */

#define CTIMER_EMR_EM0_MASK                      (0x1U)
#define CTIMER_EMR_EM0_SHIFT                     (0U)
/*! EM0 - External Match 0
 */
#define CTIMER_EMR_EM0(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM0_SHIFT)) & CTIMER_EMR_EM0_MASK)

#define CTIMER_EMR_EM1_MASK                      (0x2U)
#define CTIMER_EMR_EM1_SHIFT                     (1U)
/*! EM1 - External Match 1
 */
#define CTIMER_EMR_EM1(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM1_SHIFT)) & CTIMER_EMR_EM1_MASK)

#define CTIMER_EMR_EM2_MASK                      (0x4U)
#define CTIMER_EMR_EM2_SHIFT                     (2U)
/*! EM2 - External Match 2
 */
#define CTIMER_EMR_EM2(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM2_SHIFT)) & CTIMER_EMR_EM2_MASK)

#define CTIMER_EMR_EM3_MASK                      (0x8U)
#define CTIMER_EMR_EM3_SHIFT                     (3U)
/*! EM3 - External Match 3
 */
#define CTIMER_EMR_EM3(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM3_SHIFT)) & CTIMER_EMR_EM3_MASK)

#define CTIMER_EMR_EMC0_MASK                     (0x30U)
#define CTIMER_EMR_EMC0_SHIFT                    (4U)
/*! EMC0 - External Match Control 0
 *  0b00..Do Nothing
 *  0b01..Clear. Clear the corresponding External Match bit/output to 0 (MAT0 pin is LOW if pinned out)
 *  0b10..Set. Set the corresponding External Match bit/output to 1 (MAT0 pin is HIGH if pinned out)
 *  0b11..Toggle. Toggle the corresponding External Match bit/output
 */
#define CTIMER_EMR_EMC0(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC0_SHIFT)) & CTIMER_EMR_EMC0_MASK)

#define CTIMER_EMR_EMC1_MASK                     (0xC0U)
#define CTIMER_EMR_EMC1_SHIFT                    (6U)
/*! EMC1 - External Match Control 1
 *  0b00..Do Nothing
 *  0b01..Clear. Clear the corresponding External Match bit/output to 0 (MAT1 pin is LOW if pinned out)
 *  0b10..Set. Set the corresponding External Match bit/output to 1 (MAT1 pin is HIGH if pinned out)
 *  0b11..Toggle. Toggle the corresponding External Match bit/output
 */
#define CTIMER_EMR_EMC1(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC1_SHIFT)) & CTIMER_EMR_EMC1_MASK)

#define CTIMER_EMR_EMC2_MASK                     (0x300U)
#define CTIMER_EMR_EMC2_SHIFT                    (8U)
/*! EMC2 - External Match Control 2
 *  0b00..Do Nothing
 *  0b01..Clear. Clear the corresponding External Match bit/output to 0 (MAT2 pin is LOW if pinned out)
 *  0b10..Set. Set the corresponding External Match bit/output to 1 (MAT2 pin is HIGH if pinned out)
 *  0b11..Toggle. Toggle the corresponding External Match bit/output
 */
#define CTIMER_EMR_EMC2(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC2_SHIFT)) & CTIMER_EMR_EMC2_MASK)

#define CTIMER_EMR_EMC3_MASK                     (0xC00U)
#define CTIMER_EMR_EMC3_SHIFT                    (10U)
/*! EMC3 - External Match Control 3
 *  0b00..Do Nothing
 *  0b01..Clear. Clear the corresponding External Match bit/output to 0 (MAT3 pin is LOW if pinned out)
 *  0b10..Set. Set the corresponding External Match bit/output to 1 (MAT3 pin is HIGH if pinned out)
 *  0b11..Toggle. Toggle the corresponding External Match bit/output
 */
#define CTIMER_EMR_EMC3(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC3_SHIFT)) & CTIMER_EMR_EMC3_MASK)
/*! @} */

/*! @name CTCR - Count Control Register */
/*! @{ */

#define CTIMER_CTCR_CTMODE_MASK                  (0x3U)
#define CTIMER_CTCR_CTMODE_SHIFT                 (0U)
/*! CTMODE - The Count Control Register (CTCR) is used to select between Timer and Counter mode, and
 *    in Counter mode to select the pin and edge(s) for counting.
 *  0b00..Timer Mode
 *  0b01..Counter Mode rising edge
 *  0b10..Counter Mode falling edge
 *  0b11..Counter Mode dual edge
 */
#define CTIMER_CTCR_CTMODE(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_CTMODE_SHIFT)) & CTIMER_CTCR_CTMODE_MASK)

#define CTIMER_CTCR_CINSEL_MASK                  (0xCU)
#define CTIMER_CTCR_CINSEL_SHIFT                 (2U)
/*! CINSEL - Count Input Select
 *  0b00..Channel 0. CAPn[0] for CTIMERn
 *  0b01..Channel 1. CAPn[1] for CTIMERn
 *  0b10..Channel 2. CAPn[2] for CTIMERn
 *  0b11..Channel 3. CAPn[3] for CTIMERn
 */
#define CTIMER_CTCR_CINSEL(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_CINSEL_SHIFT)) & CTIMER_CTCR_CINSEL_MASK)

#define CTIMER_CTCR_ENCC_MASK                    (0x10U)
#define CTIMER_CTCR_ENCC_SHIFT                   (4U)
#define CTIMER_CTCR_ENCC(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_ENCC_SHIFT)) & CTIMER_CTCR_ENCC_MASK)

#define CTIMER_CTCR_SELCC_MASK                   (0xE0U)
#define CTIMER_CTCR_SELCC_SHIFT                  (5U)
/*! SELCC - Edge select
 *  0b000..Channel 0 Rising Edge. Rising edge of the signal on capture channel 0 clears the timer (if bit 4 is set)
 *  0b001..Channel 0 Falling Edge. Falling edge of the signal on capture channel 0 clears the timer (if bit 4 is set)
 *  0b010..Channel 1 Rising Edge. Rising edge of the signal on capture channel 1 clears the timer (if bit 4 is set)
 *  0b011..Channel 1 Falling Edge. Falling edge of the signal on capture channel 1 clears the timer (if bit 4 is set)
 *  0b100..Channel 2 Rising Edge. Rising edge of the signal on capture channel 2 clears the timer (if bit 4 is set)
 *  0b101..Channel 2 Falling Edge. Falling edge of the signal on capture channel 2 clears the timer (if bit 4 is set)
 */
#define CTIMER_CTCR_SELCC(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_SELCC_SHIFT)) & CTIMER_CTCR_SELCC_MASK)
/*! @} */

/*! @name PWMC - PWM Control Register */
/*! @{ */

#define CTIMER_PWMC_PWMEN0_MASK                  (0x1U)
#define CTIMER_PWMC_PWMEN0_SHIFT                 (0U)
/*! PWMEN0 - PWM mode enable for channel 0
 *  0b0..Match. CTIMERn_MAT0 is controlled by EM0
 *  0b1..PWM. PWM mode is enabled for CTIMERn_MAT0
 */
#define CTIMER_PWMC_PWMEN0(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN0_SHIFT)) & CTIMER_PWMC_PWMEN0_MASK)

#define CTIMER_PWMC_PWMEN1_MASK                  (0x2U)
#define CTIMER_PWMC_PWMEN1_SHIFT                 (1U)
/*! PWMEN1 - PWM mode enable for channel 1
 *  0b0..Match. CTIMERn_MAT01 is controlled by EM1
 *  0b1..PWM. PWM mode is enabled for CTIMERn_MAT1
 */
#define CTIMER_PWMC_PWMEN1(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN1_SHIFT)) & CTIMER_PWMC_PWMEN1_MASK)

#define CTIMER_PWMC_PWMEN2_MASK                  (0x4U)
#define CTIMER_PWMC_PWMEN2_SHIFT                 (2U)
/*! PWMEN2 - PWM mode enable for channel 2
 *  0b0..Match. CTIMERn_MAT2 is controlled by EM2
 *  0b1..PWM. PWM mode is enabled for CTIMERn_MAT2
 */
#define CTIMER_PWMC_PWMEN2(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN2_SHIFT)) & CTIMER_PWMC_PWMEN2_MASK)

#define CTIMER_PWMC_PWMEN3_MASK                  (0x8U)
#define CTIMER_PWMC_PWMEN3_SHIFT                 (3U)
/*! PWMEN3 - PWM mode enable for channel 3. It is recommended to use match channel 3 to set the PWM cycle
 *  0b0..Match. CTIMERn_MAT3 is controlled by EM3
 *  0b1..PWM. PWM mode is enabled for CT132Bn_MAT3
 */
#define CTIMER_PWMC_PWMEN3(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN3_SHIFT)) & CTIMER_PWMC_PWMEN3_MASK)
/*! @} */

/*! @name MSR - Match Shadow Register */
/*! @{ */

#define CTIMER_MSR_MATCH_SHADOW_MASK             (0xFFFFFFFFU)
#define CTIMER_MSR_MATCH_SHADOW_SHIFT            (0U)
/*! MATCH_SHADOW - Timer counter match shadow value
 */
#define CTIMER_MSR_MATCH_SHADOW(x)               (((uint32_t)(((uint32_t)(x)) << CTIMER_MSR_MATCH_SHADOW_SHIFT)) & CTIMER_MSR_MATCH_SHADOW_MASK)
/*! @} */

/* The count of CTIMER_MSR */
#define CTIMER_MSR_COUNT                         (4U)


/*!
 * @}
 */ /* end of group CTIMER_Register_Masks */


/* CTIMER - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral CTIMER0 base address */
  #define CTIMER0_BASE                             (0x50008000u)
  /** Peripheral CTIMER0 base address */
  #define CTIMER0_BASE_NS                          (0x40008000u)
  /** Peripheral CTIMER0 base pointer */
  #define CTIMER0                                  ((CTIMER_Type *)CTIMER0_BASE)
  /** Peripheral CTIMER0 base pointer */
  #define CTIMER0_NS                               ((CTIMER_Type *)CTIMER0_BASE_NS)
  /** Peripheral CTIMER1 base address */
  #define CTIMER1_BASE                             (0x50009000u)
  /** Peripheral CTIMER1 base address */
  #define CTIMER1_BASE_NS                          (0x40009000u)
  /** Peripheral CTIMER1 base pointer */
  #define CTIMER1                                  ((CTIMER_Type *)CTIMER1_BASE)
  /** Peripheral CTIMER1 base pointer */
  #define CTIMER1_NS                               ((CTIMER_Type *)CTIMER1_BASE_NS)
  /** Peripheral CTIMER2 base address */
  #define CTIMER2_BASE                             (0x50028000u)
  /** Peripheral CTIMER2 base address */
  #define CTIMER2_BASE_NS                          (0x40028000u)
  /** Peripheral CTIMER2 base pointer */
  #define CTIMER2                                  ((CTIMER_Type *)CTIMER2_BASE)
  /** Peripheral CTIMER2 base pointer */
  #define CTIMER2_NS                               ((CTIMER_Type *)CTIMER2_BASE_NS)
  /** Peripheral CTIMER3 base address */
  #define CTIMER3_BASE                             (0x50029000u)
  /** Peripheral CTIMER3 base address */
  #define CTIMER3_BASE_NS                          (0x40029000u)
  /** Peripheral CTIMER3 base pointer */
  #define CTIMER3                                  ((CTIMER_Type *)CTIMER3_BASE)
  /** Peripheral CTIMER3 base pointer */
  #define CTIMER3_NS                               ((CTIMER_Type *)CTIMER3_BASE_NS)
  /** Peripheral CTIMER4 base address */
  #define CTIMER4_BASE                             (0x5002A000u)
  /** Peripheral CTIMER4 base address */
  #define CTIMER4_BASE_NS                          (0x4002A000u)
  /** Peripheral CTIMER4 base pointer */
  #define CTIMER4                                  ((CTIMER_Type *)CTIMER4_BASE)
  /** Peripheral CTIMER4 base pointer */
  #define CTIMER4_NS                               ((CTIMER_Type *)CTIMER4_BASE_NS)
  /** Array initializer of CTIMER peripheral base addresses */
  #define CTIMER_BASE_ADDRS                        { CTIMER0_BASE, CTIMER1_BASE, CTIMER2_BASE, CTIMER3_BASE, CTIMER4_BASE }
  /** Array initializer of CTIMER peripheral base pointers */
  #define CTIMER_BASE_PTRS                         { CTIMER0, CTIMER1, CTIMER2, CTIMER3, CTIMER4 }
  /** Array initializer of CTIMER peripheral base addresses */
  #define CTIMER_BASE_ADDRS_NS                     { CTIMER0_BASE_NS, CTIMER1_BASE_NS, CTIMER2_BASE_NS, CTIMER3_BASE_NS, CTIMER4_BASE_NS }
  /** Array initializer of CTIMER peripheral base pointers */
  #define CTIMER_BASE_PTRS_NS                      { CTIMER0_NS, CTIMER1_NS, CTIMER2_NS, CTIMER3_NS, CTIMER4_NS }
#else
  /** Peripheral CTIMER0 base address */
  #define CTIMER0_BASE                             (0x40008000u)
  /** Peripheral CTIMER0 base pointer */
  #define CTIMER0                                  ((CTIMER_Type *)CTIMER0_BASE)
  /** Peripheral CTIMER1 base address */
  #define CTIMER1_BASE                             (0x40009000u)
  /** Peripheral CTIMER1 base pointer */
  #define CTIMER1                                  ((CTIMER_Type *)CTIMER1_BASE)
  /** Peripheral CTIMER2 base address */
  #define CTIMER2_BASE                             (0x40028000u)
  /** Peripheral CTIMER2 base pointer */
  #define CTIMER2                                  ((CTIMER_Type *)CTIMER2_BASE)
  /** Peripheral CTIMER3 base address */
  #define CTIMER3_BASE                             (0x40029000u)
  /** Peripheral CTIMER3 base pointer */
  #define CTIMER3                                  ((CTIMER_Type *)CTIMER3_BASE)
  /** Peripheral CTIMER4 base address */
  #define CTIMER4_BASE                             (0x4002A000u)
  /** Peripheral CTIMER4 base pointer */
  #define CTIMER4                                  ((CTIMER_Type *)CTIMER4_BASE)
  /** Array initializer of CTIMER peripheral base addresses */
  #define CTIMER_BASE_ADDRS                        { CTIMER0_BASE, CTIMER1_BASE, CTIMER2_BASE, CTIMER3_BASE, CTIMER4_BASE }
  /** Array initializer of CTIMER peripheral base pointers */
  #define CTIMER_BASE_PTRS                         { CTIMER0, CTIMER1, CTIMER2, CTIMER3, CTIMER4 }
#endif
/** Interrupt vectors for the CTIMER peripheral type */
#define CTIMER_IRQS                              { CTIMER0_IRQn, CTIMER1_IRQn, CTIMER2_IRQn, CTIMER3_IRQn, CTIMER4_IRQn }

/*!
 * @}
 */ /* end of group CTIMER_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DEBUGGER_MAILBOX Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DEBUGGER_MAILBOX_Peripheral_Access_Layer DEBUGGER_MAILBOX Peripheral Access Layer
 * @{
 */

/** DEBUGGER_MAILBOX - Register Layout Typedef */
typedef struct {
  __IO uint32_t CSW;                               /**< Command and status word, offset: 0x0 */
  __IO uint32_t REQUEST;                           /**< Request Value, offset: 0x4 */
  __IO uint32_t RETURN;                            /**< Return Value, offset: 0x8 */
       uint8_t RESERVED_0[240];
  __I  uint32_t ID;                                /**< Identification, offset: 0xFC */
} DEBUGGER_MAILBOX_Type;

/* ----------------------------------------------------------------------------
   -- DEBUGGER_MAILBOX Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DEBUGGER_MAILBOX_Register_Masks DEBUGGER_MAILBOX Register Masks
 * @{
 */

/*! @name CSW - Command and status word */
/*! @{ */

#define DEBUGGER_MAILBOX_CSW_RESYNCH_REQ_MASK    (0x1U)
#define DEBUGGER_MAILBOX_CSW_RESYNCH_REQ_SHIFT   (0U)
/*! RESYNCH_REQ - Re-synchronization Request
 *  0b0..No Request
 *  0b1..Request for re-synchronization
 */
#define DEBUGGER_MAILBOX_CSW_RESYNCH_REQ(x)      (((uint32_t)(((uint32_t)(x)) << DEBUGGER_MAILBOX_CSW_RESYNCH_REQ_SHIFT)) & DEBUGGER_MAILBOX_CSW_RESYNCH_REQ_MASK)

#define DEBUGGER_MAILBOX_CSW_REQ_PENDING_MASK    (0x2U)
#define DEBUGGER_MAILBOX_CSW_REQ_PENDING_SHIFT   (1U)
/*! REQ_PENDING - Request Pending
 *  0b0..No Request Pending
 *  0b1..Request for Re-synchronization Pending
 */
#define DEBUGGER_MAILBOX_CSW_REQ_PENDING(x)      (((uint32_t)(((uint32_t)(x)) << DEBUGGER_MAILBOX_CSW_REQ_PENDING_SHIFT)) & DEBUGGER_MAILBOX_CSW_REQ_PENDING_MASK)

#define DEBUGGER_MAILBOX_CSW_DBG_OR_ERR_MASK     (0x4U)
#define DEBUGGER_MAILBOX_CSW_DBG_OR_ERR_SHIFT    (2U)
/*! DBG_OR_ERR - Debug Overrun Error
 *  0b0..No Debug Overrun error
 *  0b1..Debug Overrun Error. A debug overrun occurred.
 */
#define DEBUGGER_MAILBOX_CSW_DBG_OR_ERR(x)       (((uint32_t)(((uint32_t)(x)) << DEBUGGER_MAILBOX_CSW_DBG_OR_ERR_SHIFT)) & DEBUGGER_MAILBOX_CSW_DBG_OR_ERR_MASK)

#define DEBUGGER_MAILBOX_CSW_AHB_OR_ERR_MASK     (0x8U)
#define DEBUGGER_MAILBOX_CSW_AHB_OR_ERR_SHIFT    (3U)
/*! AHB_OR_ERR - AHB Overrun Error
 *  0b0..No AHB Overrun Error
 *  0b1..AHB Overrun Error. An AHB overrun occurred.
 */
#define DEBUGGER_MAILBOX_CSW_AHB_OR_ERR(x)       (((uint32_t)(((uint32_t)(x)) << DEBUGGER_MAILBOX_CSW_AHB_OR_ERR_SHIFT)) & DEBUGGER_MAILBOX_CSW_AHB_OR_ERR_MASK)

#define DEBUGGER_MAILBOX_CSW_SOFT_RESET_MASK     (0x10U)
#define DEBUGGER_MAILBOX_CSW_SOFT_RESET_SHIFT    (4U)
/*! SOFT_RESET - Soft Reset
 */
#define DEBUGGER_MAILBOX_CSW_SOFT_RESET(x)       (((uint32_t)(((uint32_t)(x)) << DEBUGGER_MAILBOX_CSW_SOFT_RESET_SHIFT)) & DEBUGGER_MAILBOX_CSW_SOFT_RESET_MASK)

#define DEBUGGER_MAILBOX_CSW_CHIP_RESET_REQ_MASK (0x20U)
#define DEBUGGER_MAILBOX_CSW_CHIP_RESET_REQ_SHIFT (5U)
/*! CHIP_RESET_REQ - Chip Reset Request
 */
#define DEBUGGER_MAILBOX_CSW_CHIP_RESET_REQ(x)   (((uint32_t)(((uint32_t)(x)) << DEBUGGER_MAILBOX_CSW_CHIP_RESET_REQ_SHIFT)) & DEBUGGER_MAILBOX_CSW_CHIP_RESET_REQ_MASK)
/*! @} */

/*! @name REQUEST - Request Value */
/*! @{ */

#define DEBUGGER_MAILBOX_REQUEST_REQUEST_MASK    (0xFFFFFFFFU)
#define DEBUGGER_MAILBOX_REQUEST_REQUEST_SHIFT   (0U)
/*! REQUEST - Request Value
 */
#define DEBUGGER_MAILBOX_REQUEST_REQUEST(x)      (((uint32_t)(((uint32_t)(x)) << DEBUGGER_MAILBOX_REQUEST_REQUEST_SHIFT)) & DEBUGGER_MAILBOX_REQUEST_REQUEST_MASK)
/*! @} */

/*! @name RETURN - Return Value */
/*! @{ */

#define DEBUGGER_MAILBOX_RETURN_RET_MASK         (0xFFFFFFFFU)
#define DEBUGGER_MAILBOX_RETURN_RET_SHIFT        (0U)
/*! RET - Return Value
 */
#define DEBUGGER_MAILBOX_RETURN_RET(x)           (((uint32_t)(((uint32_t)(x)) << DEBUGGER_MAILBOX_RETURN_RET_SHIFT)) & DEBUGGER_MAILBOX_RETURN_RET_MASK)
/*! @} */

/*! @name ID - Identification */
/*! @{ */

#define DEBUGGER_MAILBOX_ID_ID_MASK              (0xFFFFFFFFU)
#define DEBUGGER_MAILBOX_ID_ID_SHIFT             (0U)
/*! ID - Identification Value
 */
#define DEBUGGER_MAILBOX_ID_ID(x)                (((uint32_t)(((uint32_t)(x)) << DEBUGGER_MAILBOX_ID_ID_SHIFT)) & DEBUGGER_MAILBOX_ID_ID_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group DEBUGGER_MAILBOX_Register_Masks */


/* DEBUGGER_MAILBOX - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral DEBUGGER_MAILBOX0 base address */
  #define DEBUGGER_MAILBOX0_BASE                   (0x5009C000u)
  /** Peripheral DEBUGGER_MAILBOX0 base address */
  #define DEBUGGER_MAILBOX0_BASE_NS                (0x4009C000u)
  /** Peripheral DEBUGGER_MAILBOX0 base pointer */
  #define DEBUGGER_MAILBOX0                        ((DEBUGGER_MAILBOX_Type *)DEBUGGER_MAILBOX0_BASE)
  /** Peripheral DEBUGGER_MAILBOX0 base pointer */
  #define DEBUGGER_MAILBOX0_NS                     ((DEBUGGER_MAILBOX_Type *)DEBUGGER_MAILBOX0_BASE_NS)
  /** Array initializer of DEBUGGER_MAILBOX peripheral base addresses */
  #define DEBUGGER_MAILBOX_BASE_ADDRS              { DEBUGGER_MAILBOX0_BASE }
  /** Array initializer of DEBUGGER_MAILBOX peripheral base pointers */
  #define DEBUGGER_MAILBOX_BASE_PTRS               { DEBUGGER_MAILBOX0 }
  /** Array initializer of DEBUGGER_MAILBOX peripheral base addresses */
  #define DEBUGGER_MAILBOX_BASE_ADDRS_NS           { DEBUGGER_MAILBOX0_BASE_NS }
  /** Array initializer of DEBUGGER_MAILBOX peripheral base pointers */
  #define DEBUGGER_MAILBOX_BASE_PTRS_NS            { DEBUGGER_MAILBOX0_NS }
#else
  /** Peripheral DEBUGGER_MAILBOX0 base address */
  #define DEBUGGER_MAILBOX0_BASE                   (0x4009C000u)
  /** Peripheral DEBUGGER_MAILBOX0 base pointer */
  #define DEBUGGER_MAILBOX0                        ((DEBUGGER_MAILBOX_Type *)DEBUGGER_MAILBOX0_BASE)
  /** Array initializer of DEBUGGER_MAILBOX peripheral base addresses */
  #define DEBUGGER_MAILBOX_BASE_ADDRS              { DEBUGGER_MAILBOX0_BASE }
  /** Array initializer of DEBUGGER_MAILBOX peripheral base pointers */
  #define DEBUGGER_MAILBOX_BASE_PTRS               { DEBUGGER_MAILBOX0 }
#endif

/*!
 * @}
 */ /* end of group DEBUGGER_MAILBOX_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DMA Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Peripheral_Access_Layer DMA Peripheral Access Layer
 * @{
 */

/** DMA - Register Layout Typedef */
typedef struct {
  __IO uint32_t CTRL;                              /**< DMA control, offset: 0x0 */
  __I  uint32_t INTSTAT;                           /**< Interrupt status, offset: 0x4 */
  __IO uint32_t SRAMBASE;                          /**< SRAM address of the channel configuration table, offset: 0x8 */
       uint8_t RESERVED_0[20];
  struct {                                         /* offset: 0x20, array step: 0x60 */
    __IO uint32_t ENABLESET;                         /**< Channel Enable read and set for all DMA channels, array offset: 0x20, array step: 0x60 */
    __IO uint32_t ENABLESET1;                        /**< Channel Enable read and set for all DMA channels, array offset: 0x24, array step: 0x60 */
    __IO uint32_t ENABLECLR;                         /**< Channel Enable Clear for all DMA channels, array offset: 0x28, array step: 0x60 */
    __IO uint32_t ENABLECLR1;                        /**< Channel Enable Clear for all DMA channels, array offset: 0x2C, array step: 0x60 */
    __I  uint32_t ACTIVE;                            /**< Channel Active status for all DMA channels, array offset: 0x30, array step: 0x60 */
    __I  uint32_t ACTIVE1;                           /**< Channel Active status for all DMA channels, array offset: 0x34, array step: 0x60 */
    __I  uint32_t BUSY;                              /**< Channel Busy status for all DMA channels, array offset: 0x38, array step: 0x60 */
    __I  uint32_t BUSY1;                             /**< Channel Busy status for all DMA channels, array offset: 0x3C, array step: 0x60 */
    __IO uint32_t ERRINT;                            /**< Error Interrupt status for all DMA channels, array offset: 0x40, array step: 0x60 */
    __IO uint32_t ERRINT1;                           /**< Error Interrupt status for all DMA channels, array offset: 0x44, array step: 0x60 */
    __IO uint32_t INTENSET;                          /**< Interrupt Enable read and Set for all DMA channels, array offset: 0x48, array step: 0x60 */
    __IO uint32_t INTENSET1;                         /**< Interrupt Enable read and Set for all DMA channels, array offset: 0x4C, array step: 0x60 */
    __O  uint32_t INTENCLR;                          /**< Interrupt Enable Clear for all DMA channels, array offset: 0x50, array step: 0x60 */
    __O  uint32_t INTENCLR1;                         /**< Interrupt Enable Clear for all DMA channels, array offset: 0x54, array step: 0x60 */
    __IO uint32_t INTA;                              /**< Interrupt A status for all DMA channels, array offset: 0x58, array step: 0x60 */
    __IO uint32_t INTA1;                             /**< Interrupt A status for all DMA channels, array offset: 0x5C, array step: 0x60 */
    __IO uint32_t INTB;                              /**< Interrupt B status for all DMA channels, array offset: 0x60, array step: 0x60 */
    __IO uint32_t INTB1;                             /**< Interrupt B status for all DMA channels, array offset: 0x64, array step: 0x60 */
    __O  uint32_t SETVALID;                          /**< Set ValidPending control bits for all DMA channels, array offset: 0x68, array step: 0x60 */
    __O  uint32_t SETVALID1;                         /**< Set ValidPending control bits for all DMA channels, array offset: 0x6C, array step: 0x60 */
    __O  uint32_t SETTRIG;                           /**< Set Trigger control bits for all DMA channels, array offset: 0x70, array step: 0x60 */
    __O  uint32_t SETTRIG1;                          /**< Set Trigger control bits for all DMA channels, array offset: 0x74, array step: 0x60 */
    __O  uint32_t ABORT;                             /**< Channel Abort control for all DMA channels, array offset: 0x78, array step: 0x60 */
    __O  uint32_t ABORT1;                            /**< Channel Abort control for all DMA channels, array offset: 0x7C, array step: 0x60 */
  } COMMON[1];
       uint8_t RESERVED_1[896];
  struct {                                         /* offset: 0x400, array step: 0x10 */
    __IO uint32_t CFG;                               /**< Configuration register for DMA channel, array offset: 0x400, array step: 0x10 */
    __I  uint32_t CTLSTAT;                           /**< Control and status register for DMA channel, array offset: 0x404, array step: 0x10 */
    __IO uint32_t XFERCFG;                           /**< Transfer configuration register for DMA channel, array offset: 0x408, array step: 0x10 */
         uint8_t RESERVED_0[4];
  } CHANNEL[52];
} DMA_Type;

/* ----------------------------------------------------------------------------
   -- DMA Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Register_Masks DMA Register Masks
 * @{
 */

/*! @name CTRL - DMA control */
/*! @{ */

#define DMA_CTRL_ENABLE_MASK                     (0x1U)
#define DMA_CTRL_ENABLE_SHIFT                    (0U)
/*! ENABLE - DMA controller master enable.
 *  0b0..DMA controller is disabled.
 *  0b1..Enabled.
 */
#define DMA_CTRL_ENABLE(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_CTRL_ENABLE_SHIFT)) & DMA_CTRL_ENABLE_MASK)
/*! @} */

/*! @name INTSTAT - Interrupt status */
/*! @{ */

#define DMA_INTSTAT_ACTIVEINT_MASK               (0x2U)
#define DMA_INTSTAT_ACTIVEINT_SHIFT              (1U)
/*! ACTIVEINT - Summarizes whether any enabled interrupts (other than error interrupts) are pending.
 *  0b0..No enabled interrupts are pending.
 *  0b1..At least one enabled interrupt is pending.
 */
#define DMA_INTSTAT_ACTIVEINT(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_INTSTAT_ACTIVEINT_SHIFT)) & DMA_INTSTAT_ACTIVEINT_MASK)

#define DMA_INTSTAT_ACTIVEERRINT_MASK            (0x4U)
#define DMA_INTSTAT_ACTIVEERRINT_SHIFT           (2U)
/*! ACTIVEERRINT - Summarizes whether any error interrupts are pending.
 *  0b0..No error interrupts are pending.
 *  0b1..At least one error interrupt is pending.
 */
#define DMA_INTSTAT_ACTIVEERRINT(x)              (((uint32_t)(((uint32_t)(x)) << DMA_INTSTAT_ACTIVEERRINT_SHIFT)) & DMA_INTSTAT_ACTIVEERRINT_MASK)
/*! @} */

/*! @name SRAMBASE - SRAM address of the channel configuration table */
/*! @{ */

#define DMA_SRAMBASE_OFFSET_MASK                 (0xFFFFFF00U)  /* Merged from fields with different position or width, of widths (22, 24), largest definition used */
#define DMA_SRAMBASE_OFFSET_SHIFT                (8U)
/*! OFFSET - Offset
 */
#define DMA_SRAMBASE_OFFSET(x)                   (((uint32_t)(((uint32_t)(x)) << DMA_SRAMBASE_OFFSET_SHIFT)) & DMA_SRAMBASE_OFFSET_MASK)  /* Merged from fields with different position or width, of widths (22, 24), largest definition used */
/*! @} */

/*! @name COMMON_ENABLESET - Channel Enable read and set for all DMA channels */
/*! @{ */

#define DMA_COMMON_ENABLESET_ENABLE0_MASK        (0x1U)
#define DMA_COMMON_ENABLESET_ENABLE0_SHIFT       (0U)
/*! ENABLE0 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE0(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE0_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE0_MASK)

#define DMA_COMMON_ENABLESET_ENABLE1_MASK        (0x2U)
#define DMA_COMMON_ENABLESET_ENABLE1_SHIFT       (1U)
/*! ENABLE1 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE1(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE1_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE1_MASK)

#define DMA_COMMON_ENABLESET_ENABLE2_MASK        (0x4U)
#define DMA_COMMON_ENABLESET_ENABLE2_SHIFT       (2U)
/*! ENABLE2 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE2(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE2_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE2_MASK)

#define DMA_COMMON_ENABLESET_ENABLE3_MASK        (0x8U)
#define DMA_COMMON_ENABLESET_ENABLE3_SHIFT       (3U)
/*! ENABLE3 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE3(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE3_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE3_MASK)

#define DMA_COMMON_ENABLESET_ENABLE4_MASK        (0x10U)
#define DMA_COMMON_ENABLESET_ENABLE4_SHIFT       (4U)
/*! ENABLE4 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE4(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE4_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE4_MASK)

#define DMA_COMMON_ENABLESET_ENABLE5_MASK        (0x20U)
#define DMA_COMMON_ENABLESET_ENABLE5_SHIFT       (5U)
/*! ENABLE5 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE5(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE5_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE5_MASK)

#define DMA_COMMON_ENABLESET_ENABLE6_MASK        (0x40U)
#define DMA_COMMON_ENABLESET_ENABLE6_SHIFT       (6U)
/*! ENABLE6 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE6(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE6_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE6_MASK)

#define DMA_COMMON_ENABLESET_ENABLE7_MASK        (0x80U)
#define DMA_COMMON_ENABLESET_ENABLE7_SHIFT       (7U)
/*! ENABLE7 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE7(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE7_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE7_MASK)

#define DMA_COMMON_ENABLESET_ENABLE8_MASK        (0x100U)
#define DMA_COMMON_ENABLESET_ENABLE8_SHIFT       (8U)
/*! ENABLE8 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE8(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE8_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE8_MASK)

#define DMA_COMMON_ENABLESET_ENABLE9_MASK        (0x200U)
#define DMA_COMMON_ENABLESET_ENABLE9_SHIFT       (9U)
/*! ENABLE9 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE9(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE9_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE9_MASK)

#define DMA_COMMON_ENABLESET_ENABLE10_MASK       (0x400U)
#define DMA_COMMON_ENABLESET_ENABLE10_SHIFT      (10U)
/*! ENABLE10 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE10(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE10_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE10_MASK)

#define DMA_COMMON_ENABLESET_ENABLE11_MASK       (0x800U)
#define DMA_COMMON_ENABLESET_ENABLE11_SHIFT      (11U)
/*! ENABLE11 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE11(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE11_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE11_MASK)

#define DMA_COMMON_ENABLESET_ENABLE12_MASK       (0x1000U)
#define DMA_COMMON_ENABLESET_ENABLE12_SHIFT      (12U)
/*! ENABLE12 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE12(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE12_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE12_MASK)

#define DMA_COMMON_ENABLESET_ENABLE13_MASK       (0x2000U)
#define DMA_COMMON_ENABLESET_ENABLE13_SHIFT      (13U)
/*! ENABLE13 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE13(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE13_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE13_MASK)

#define DMA_COMMON_ENABLESET_ENABLE14_MASK       (0x4000U)
#define DMA_COMMON_ENABLESET_ENABLE14_SHIFT      (14U)
/*! ENABLE14 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE14(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE14_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE14_MASK)

#define DMA_COMMON_ENABLESET_ENABLE15_MASK       (0x8000U)
#define DMA_COMMON_ENABLESET_ENABLE15_SHIFT      (15U)
/*! ENABLE15 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE15(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE15_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE15_MASK)

#define DMA_COMMON_ENABLESET_ENABLE16_MASK       (0x10000U)
#define DMA_COMMON_ENABLESET_ENABLE16_SHIFT      (16U)
/*! ENABLE16 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE16(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE16_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE16_MASK)

#define DMA_COMMON_ENABLESET_ENABLE17_MASK       (0x20000U)
#define DMA_COMMON_ENABLESET_ENABLE17_SHIFT      (17U)
/*! ENABLE17 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE17(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE17_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE17_MASK)

#define DMA_COMMON_ENABLESET_ENABLE18_MASK       (0x40000U)
#define DMA_COMMON_ENABLESET_ENABLE18_SHIFT      (18U)
/*! ENABLE18 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE18(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE18_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE18_MASK)

#define DMA_COMMON_ENABLESET_ENABLE19_MASK       (0x80000U)
#define DMA_COMMON_ENABLESET_ENABLE19_SHIFT      (19U)
/*! ENABLE19 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE19(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE19_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE19_MASK)

#define DMA_COMMON_ENABLESET_ENABLE20_MASK       (0x100000U)
#define DMA_COMMON_ENABLESET_ENABLE20_SHIFT      (20U)
/*! ENABLE20 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE20(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE20_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE20_MASK)

#define DMA_COMMON_ENABLESET_ENABLE21_MASK       (0x200000U)
#define DMA_COMMON_ENABLESET_ENABLE21_SHIFT      (21U)
/*! ENABLE21 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE21(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE21_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE21_MASK)

#define DMA_COMMON_ENABLESET_ENABLE22_MASK       (0x400000U)
#define DMA_COMMON_ENABLESET_ENABLE22_SHIFT      (22U)
/*! ENABLE22 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE22(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE22_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE22_MASK)

#define DMA_COMMON_ENABLESET_ENABLE23_MASK       (0x800000U)
#define DMA_COMMON_ENABLESET_ENABLE23_SHIFT      (23U)
/*! ENABLE23 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE23(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE23_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE23_MASK)

#define DMA_COMMON_ENABLESET_ENABLE24_MASK       (0x1000000U)
#define DMA_COMMON_ENABLESET_ENABLE24_SHIFT      (24U)
/*! ENABLE24 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE24(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE24_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE24_MASK)

#define DMA_COMMON_ENABLESET_ENABLE25_MASK       (0x2000000U)
#define DMA_COMMON_ENABLESET_ENABLE25_SHIFT      (25U)
/*! ENABLE25 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE25(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE25_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE25_MASK)

#define DMA_COMMON_ENABLESET_ENABLE26_MASK       (0x4000000U)
#define DMA_COMMON_ENABLESET_ENABLE26_SHIFT      (26U)
/*! ENABLE26 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE26(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE26_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE26_MASK)

#define DMA_COMMON_ENABLESET_ENABLE27_MASK       (0x8000000U)
#define DMA_COMMON_ENABLESET_ENABLE27_SHIFT      (27U)
/*! ENABLE27 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE27(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE27_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE27_MASK)

#define DMA_COMMON_ENABLESET_ENABLE28_MASK       (0x10000000U)
#define DMA_COMMON_ENABLESET_ENABLE28_SHIFT      (28U)
/*! ENABLE28 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE28(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE28_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE28_MASK)

#define DMA_COMMON_ENABLESET_ENABLE29_MASK       (0x20000000U)
#define DMA_COMMON_ENABLESET_ENABLE29_SHIFT      (29U)
/*! ENABLE29 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE29(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE29_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE29_MASK)

#define DMA_COMMON_ENABLESET_ENABLE30_MASK       (0x40000000U)
#define DMA_COMMON_ENABLESET_ENABLE30_SHIFT      (30U)
/*! ENABLE30 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE30(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE30_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE30_MASK)

#define DMA_COMMON_ENABLESET_ENABLE31_MASK       (0x80000000U)
#define DMA_COMMON_ENABLESET_ENABLE31_SHIFT      (31U)
/*! ENABLE31 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE31(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE31_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE31_MASK)
/*! @} */

/* The count of DMA_COMMON_ENABLESET */
#define DMA_COMMON_ENABLESET_COUNT               (1U)

/*! @name COMMON_ENABLESET1 - Channel Enable read and set for all DMA channels */
/*! @{ */

#define DMA_COMMON_ENABLESET1_ENABLE32_MASK      (0x1U)
#define DMA_COMMON_ENABLESET1_ENABLE32_SHIFT     (0U)
/*! ENABLE32 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET1_ENABLE32(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET1_ENABLE32_SHIFT)) & DMA_COMMON_ENABLESET1_ENABLE32_MASK)

#define DMA_COMMON_ENABLESET1_ENABLE33_MASK      (0x2U)
#define DMA_COMMON_ENABLESET1_ENABLE33_SHIFT     (1U)
/*! ENABLE33 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET1_ENABLE33(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET1_ENABLE33_SHIFT)) & DMA_COMMON_ENABLESET1_ENABLE33_MASK)

#define DMA_COMMON_ENABLESET1_ENABLE34_MASK      (0x4U)
#define DMA_COMMON_ENABLESET1_ENABLE34_SHIFT     (2U)
/*! ENABLE34 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET1_ENABLE34(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET1_ENABLE34_SHIFT)) & DMA_COMMON_ENABLESET1_ENABLE34_MASK)

#define DMA_COMMON_ENABLESET1_ENABLE35_MASK      (0x8U)
#define DMA_COMMON_ENABLESET1_ENABLE35_SHIFT     (3U)
/*! ENABLE35 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET1_ENABLE35(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET1_ENABLE35_SHIFT)) & DMA_COMMON_ENABLESET1_ENABLE35_MASK)

#define DMA_COMMON_ENABLESET1_ENABLE36_MASK      (0x10U)
#define DMA_COMMON_ENABLESET1_ENABLE36_SHIFT     (4U)
/*! ENABLE36 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET1_ENABLE36(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET1_ENABLE36_SHIFT)) & DMA_COMMON_ENABLESET1_ENABLE36_MASK)

#define DMA_COMMON_ENABLESET1_ENABLE37_MASK      (0x20U)
#define DMA_COMMON_ENABLESET1_ENABLE37_SHIFT     (5U)
/*! ENABLE37 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET1_ENABLE37(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET1_ENABLE37_SHIFT)) & DMA_COMMON_ENABLESET1_ENABLE37_MASK)

#define DMA_COMMON_ENABLESET1_ENABLE38_MASK      (0x40U)
#define DMA_COMMON_ENABLESET1_ENABLE38_SHIFT     (6U)
/*! ENABLE38 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET1_ENABLE38(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET1_ENABLE38_SHIFT)) & DMA_COMMON_ENABLESET1_ENABLE38_MASK)

#define DMA_COMMON_ENABLESET1_ENABLE39_MASK      (0x80U)
#define DMA_COMMON_ENABLESET1_ENABLE39_SHIFT     (7U)
/*! ENABLE39 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET1_ENABLE39(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET1_ENABLE39_SHIFT)) & DMA_COMMON_ENABLESET1_ENABLE39_MASK)

#define DMA_COMMON_ENABLESET1_ENABLE40_MASK      (0x100U)
#define DMA_COMMON_ENABLESET1_ENABLE40_SHIFT     (8U)
/*! ENABLE40 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET1_ENABLE40(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET1_ENABLE40_SHIFT)) & DMA_COMMON_ENABLESET1_ENABLE40_MASK)

#define DMA_COMMON_ENABLESET1_ENABLE41_MASK      (0x200U)
#define DMA_COMMON_ENABLESET1_ENABLE41_SHIFT     (9U)
/*! ENABLE41 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET1_ENABLE41(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET1_ENABLE41_SHIFT)) & DMA_COMMON_ENABLESET1_ENABLE41_MASK)

#define DMA_COMMON_ENABLESET1_ENABLE42_MASK      (0x400U)
#define DMA_COMMON_ENABLESET1_ENABLE42_SHIFT     (10U)
/*! ENABLE42 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET1_ENABLE42(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET1_ENABLE42_SHIFT)) & DMA_COMMON_ENABLESET1_ENABLE42_MASK)

#define DMA_COMMON_ENABLESET1_ENABLE43_MASK      (0x800U)
#define DMA_COMMON_ENABLESET1_ENABLE43_SHIFT     (11U)
/*! ENABLE43 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET1_ENABLE43(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET1_ENABLE43_SHIFT)) & DMA_COMMON_ENABLESET1_ENABLE43_MASK)

#define DMA_COMMON_ENABLESET1_ENABLE44_MASK      (0x1000U)
#define DMA_COMMON_ENABLESET1_ENABLE44_SHIFT     (12U)
/*! ENABLE44 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET1_ENABLE44(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET1_ENABLE44_SHIFT)) & DMA_COMMON_ENABLESET1_ENABLE44_MASK)

#define DMA_COMMON_ENABLESET1_ENABLE45_MASK      (0x2000U)
#define DMA_COMMON_ENABLESET1_ENABLE45_SHIFT     (13U)
/*! ENABLE45 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET1_ENABLE45(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET1_ENABLE45_SHIFT)) & DMA_COMMON_ENABLESET1_ENABLE45_MASK)

#define DMA_COMMON_ENABLESET1_ENABLE46_MASK      (0x4000U)
#define DMA_COMMON_ENABLESET1_ENABLE46_SHIFT     (14U)
/*! ENABLE46 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET1_ENABLE46(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET1_ENABLE46_SHIFT)) & DMA_COMMON_ENABLESET1_ENABLE46_MASK)

#define DMA_COMMON_ENABLESET1_ENABLE47_MASK      (0x8000U)
#define DMA_COMMON_ENABLESET1_ENABLE47_SHIFT     (15U)
/*! ENABLE47 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET1_ENABLE47(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET1_ENABLE47_SHIFT)) & DMA_COMMON_ENABLESET1_ENABLE47_MASK)

#define DMA_COMMON_ENABLESET1_ENABLE48_MASK      (0x10000U)
#define DMA_COMMON_ENABLESET1_ENABLE48_SHIFT     (16U)
/*! ENABLE48 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET1_ENABLE48(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET1_ENABLE48_SHIFT)) & DMA_COMMON_ENABLESET1_ENABLE48_MASK)

#define DMA_COMMON_ENABLESET1_ENABLE49_MASK      (0x20000U)
#define DMA_COMMON_ENABLESET1_ENABLE49_SHIFT     (17U)
/*! ENABLE49 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET1_ENABLE49(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET1_ENABLE49_SHIFT)) & DMA_COMMON_ENABLESET1_ENABLE49_MASK)

#define DMA_COMMON_ENABLESET1_ENABLE50_MASK      (0x40000U)
#define DMA_COMMON_ENABLESET1_ENABLE50_SHIFT     (18U)
/*! ENABLE50 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET1_ENABLE50(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET1_ENABLE50_SHIFT)) & DMA_COMMON_ENABLESET1_ENABLE50_MASK)

#define DMA_COMMON_ENABLESET1_ENABLE51_MASK      (0x80000U)
#define DMA_COMMON_ENABLESET1_ENABLE51_SHIFT     (19U)
/*! ENABLE51 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET1_ENABLE51(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET1_ENABLE51_SHIFT)) & DMA_COMMON_ENABLESET1_ENABLE51_MASK)
/*! @} */

/* The count of DMA_COMMON_ENABLESET1 */
#define DMA_COMMON_ENABLESET1_COUNT              (1U)

/*! @name COMMON_ENABLECLR - Channel Enable Clear for all DMA channels */
/*! @{ */

#define DMA_COMMON_ENABLECLR_CLR0_MASK           (0x1U)
#define DMA_COMMON_ENABLECLR_CLR0_SHIFT          (0U)
/*! CLR0 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR0(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR0_SHIFT)) & DMA_COMMON_ENABLECLR_CLR0_MASK)

#define DMA_COMMON_ENABLECLR_CLR1_MASK           (0x2U)
#define DMA_COMMON_ENABLECLR_CLR1_SHIFT          (1U)
/*! CLR1 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR1(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR1_SHIFT)) & DMA_COMMON_ENABLECLR_CLR1_MASK)

#define DMA_COMMON_ENABLECLR_CLR2_MASK           (0x4U)
#define DMA_COMMON_ENABLECLR_CLR2_SHIFT          (2U)
/*! CLR2 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR2(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR2_SHIFT)) & DMA_COMMON_ENABLECLR_CLR2_MASK)

#define DMA_COMMON_ENABLECLR_CLR3_MASK           (0x8U)
#define DMA_COMMON_ENABLECLR_CLR3_SHIFT          (3U)
/*! CLR3 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR3(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR3_SHIFT)) & DMA_COMMON_ENABLECLR_CLR3_MASK)

#define DMA_COMMON_ENABLECLR_CLR4_MASK           (0x10U)
#define DMA_COMMON_ENABLECLR_CLR4_SHIFT          (4U)
/*! CLR4 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR4(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR4_SHIFT)) & DMA_COMMON_ENABLECLR_CLR4_MASK)

#define DMA_COMMON_ENABLECLR_CLR5_MASK           (0x20U)
#define DMA_COMMON_ENABLECLR_CLR5_SHIFT          (5U)
/*! CLR5 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR5(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR5_SHIFT)) & DMA_COMMON_ENABLECLR_CLR5_MASK)

#define DMA_COMMON_ENABLECLR_CLR6_MASK           (0x40U)
#define DMA_COMMON_ENABLECLR_CLR6_SHIFT          (6U)
/*! CLR6 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR6(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR6_SHIFT)) & DMA_COMMON_ENABLECLR_CLR6_MASK)

#define DMA_COMMON_ENABLECLR_CLR7_MASK           (0x80U)
#define DMA_COMMON_ENABLECLR_CLR7_SHIFT          (7U)
/*! CLR7 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR7(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR7_SHIFT)) & DMA_COMMON_ENABLECLR_CLR7_MASK)

#define DMA_COMMON_ENABLECLR_CLR8_MASK           (0x100U)
#define DMA_COMMON_ENABLECLR_CLR8_SHIFT          (8U)
/*! CLR8 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR8(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR8_SHIFT)) & DMA_COMMON_ENABLECLR_CLR8_MASK)

#define DMA_COMMON_ENABLECLR_CLR9_MASK           (0x200U)
#define DMA_COMMON_ENABLECLR_CLR9_SHIFT          (9U)
/*! CLR9 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR9(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR9_SHIFT)) & DMA_COMMON_ENABLECLR_CLR9_MASK)

#define DMA_COMMON_ENABLECLR_CLR10_MASK          (0x400U)
#define DMA_COMMON_ENABLECLR_CLR10_SHIFT         (10U)
/*! CLR10 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR10(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR10_SHIFT)) & DMA_COMMON_ENABLECLR_CLR10_MASK)

#define DMA_COMMON_ENABLECLR_CLR11_MASK          (0x800U)
#define DMA_COMMON_ENABLECLR_CLR11_SHIFT         (11U)
/*! CLR11 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR11(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR11_SHIFT)) & DMA_COMMON_ENABLECLR_CLR11_MASK)

#define DMA_COMMON_ENABLECLR_CLR12_MASK          (0x1000U)
#define DMA_COMMON_ENABLECLR_CLR12_SHIFT         (12U)
/*! CLR12 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR12(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR12_SHIFT)) & DMA_COMMON_ENABLECLR_CLR12_MASK)

#define DMA_COMMON_ENABLECLR_CLR13_MASK          (0x2000U)
#define DMA_COMMON_ENABLECLR_CLR13_SHIFT         (13U)
/*! CLR13 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR13(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR13_SHIFT)) & DMA_COMMON_ENABLECLR_CLR13_MASK)

#define DMA_COMMON_ENABLECLR_CLR14_MASK          (0x4000U)
#define DMA_COMMON_ENABLECLR_CLR14_SHIFT         (14U)
/*! CLR14 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR14(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR14_SHIFT)) & DMA_COMMON_ENABLECLR_CLR14_MASK)

#define DMA_COMMON_ENABLECLR_CLR15_MASK          (0x8000U)
#define DMA_COMMON_ENABLECLR_CLR15_SHIFT         (15U)
/*! CLR15 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR15(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR15_SHIFT)) & DMA_COMMON_ENABLECLR_CLR15_MASK)

#define DMA_COMMON_ENABLECLR_CLR16_MASK          (0x10000U)
#define DMA_COMMON_ENABLECLR_CLR16_SHIFT         (16U)
/*! CLR16 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR16(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR16_SHIFT)) & DMA_COMMON_ENABLECLR_CLR16_MASK)

#define DMA_COMMON_ENABLECLR_CLR17_MASK          (0x20000U)
#define DMA_COMMON_ENABLECLR_CLR17_SHIFT         (17U)
/*! CLR17 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR17(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR17_SHIFT)) & DMA_COMMON_ENABLECLR_CLR17_MASK)

#define DMA_COMMON_ENABLECLR_CLR18_MASK          (0x40000U)
#define DMA_COMMON_ENABLECLR_CLR18_SHIFT         (18U)
/*! CLR18 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR18(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR18_SHIFT)) & DMA_COMMON_ENABLECLR_CLR18_MASK)

#define DMA_COMMON_ENABLECLR_CLR19_MASK          (0x80000U)
#define DMA_COMMON_ENABLECLR_CLR19_SHIFT         (19U)
/*! CLR19 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR19(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR19_SHIFT)) & DMA_COMMON_ENABLECLR_CLR19_MASK)

#define DMA_COMMON_ENABLECLR_CLR20_MASK          (0x100000U)
#define DMA_COMMON_ENABLECLR_CLR20_SHIFT         (20U)
/*! CLR20 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR20(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR20_SHIFT)) & DMA_COMMON_ENABLECLR_CLR20_MASK)

#define DMA_COMMON_ENABLECLR_CLR21_MASK          (0x200000U)
#define DMA_COMMON_ENABLECLR_CLR21_SHIFT         (21U)
/*! CLR21 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR21(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR21_SHIFT)) & DMA_COMMON_ENABLECLR_CLR21_MASK)

#define DMA_COMMON_ENABLECLR_CLR22_MASK          (0x400000U)
#define DMA_COMMON_ENABLECLR_CLR22_SHIFT         (22U)
/*! CLR22 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR22(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR22_SHIFT)) & DMA_COMMON_ENABLECLR_CLR22_MASK)

#define DMA_COMMON_ENABLECLR_CLR23_MASK          (0x800000U)
#define DMA_COMMON_ENABLECLR_CLR23_SHIFT         (23U)
/*! CLR23 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR23(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR23_SHIFT)) & DMA_COMMON_ENABLECLR_CLR23_MASK)

#define DMA_COMMON_ENABLECLR_CLR24_MASK          (0x1000000U)
#define DMA_COMMON_ENABLECLR_CLR24_SHIFT         (24U)
/*! CLR24 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR24(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR24_SHIFT)) & DMA_COMMON_ENABLECLR_CLR24_MASK)

#define DMA_COMMON_ENABLECLR_CLR25_MASK          (0x2000000U)
#define DMA_COMMON_ENABLECLR_CLR25_SHIFT         (25U)
/*! CLR25 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR25(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR25_SHIFT)) & DMA_COMMON_ENABLECLR_CLR25_MASK)

#define DMA_COMMON_ENABLECLR_CLR26_MASK          (0x4000000U)
#define DMA_COMMON_ENABLECLR_CLR26_SHIFT         (26U)
/*! CLR26 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR26(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR26_SHIFT)) & DMA_COMMON_ENABLECLR_CLR26_MASK)

#define DMA_COMMON_ENABLECLR_CLR27_MASK          (0x8000000U)
#define DMA_COMMON_ENABLECLR_CLR27_SHIFT         (27U)
/*! CLR27 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR27(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR27_SHIFT)) & DMA_COMMON_ENABLECLR_CLR27_MASK)

#define DMA_COMMON_ENABLECLR_CLR28_MASK          (0x10000000U)
#define DMA_COMMON_ENABLECLR_CLR28_SHIFT         (28U)
/*! CLR28 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR28(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR28_SHIFT)) & DMA_COMMON_ENABLECLR_CLR28_MASK)

#define DMA_COMMON_ENABLECLR_CLR29_MASK          (0x20000000U)
#define DMA_COMMON_ENABLECLR_CLR29_SHIFT         (29U)
/*! CLR29 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR29(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR29_SHIFT)) & DMA_COMMON_ENABLECLR_CLR29_MASK)

#define DMA_COMMON_ENABLECLR_CLR30_MASK          (0x40000000U)
#define DMA_COMMON_ENABLECLR_CLR30_SHIFT         (30U)
/*! CLR30 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR30(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR30_SHIFT)) & DMA_COMMON_ENABLECLR_CLR30_MASK)

#define DMA_COMMON_ENABLECLR_CLR31_MASK          (0x80000000U)
#define DMA_COMMON_ENABLECLR_CLR31_SHIFT         (31U)
/*! CLR31 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR31(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR31_SHIFT)) & DMA_COMMON_ENABLECLR_CLR31_MASK)
/*! @} */

/* The count of DMA_COMMON_ENABLECLR */
#define DMA_COMMON_ENABLECLR_COUNT               (1U)

/*! @name COMMON_ENABLECLR1 - Channel Enable Clear for all DMA channels */
/*! @{ */

#define DMA_COMMON_ENABLECLR1_CLR32_MASK         (0x1U)
#define DMA_COMMON_ENABLECLR1_CLR32_SHIFT        (0U)
/*! CLR32 - Writing ones to this register clears the corresponding bits in ENABLESET1.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR1_CLR32(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR1_CLR32_SHIFT)) & DMA_COMMON_ENABLECLR1_CLR32_MASK)

#define DMA_COMMON_ENABLECLR1_CLR33_MASK         (0x2U)
#define DMA_COMMON_ENABLECLR1_CLR33_SHIFT        (1U)
/*! CLR33 - Writing ones to this register clears the corresponding bits in ENABLESET1.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR1_CLR33(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR1_CLR33_SHIFT)) & DMA_COMMON_ENABLECLR1_CLR33_MASK)

#define DMA_COMMON_ENABLECLR1_CLR34_MASK         (0x4U)
#define DMA_COMMON_ENABLECLR1_CLR34_SHIFT        (2U)
/*! CLR34 - Writing ones to this register clears the corresponding bits in ENABLESET1.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR1_CLR34(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR1_CLR34_SHIFT)) & DMA_COMMON_ENABLECLR1_CLR34_MASK)

#define DMA_COMMON_ENABLECLR1_CLR35_MASK         (0x8U)
#define DMA_COMMON_ENABLECLR1_CLR35_SHIFT        (3U)
/*! CLR35 - Writing ones to this register clears the corresponding bits in ENABLESET1.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR1_CLR35(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR1_CLR35_SHIFT)) & DMA_COMMON_ENABLECLR1_CLR35_MASK)

#define DMA_COMMON_ENABLECLR1_CLR36_MASK         (0x10U)
#define DMA_COMMON_ENABLECLR1_CLR36_SHIFT        (4U)
/*! CLR36 - Writing ones to this register clears the corresponding bits in ENABLESET1.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR1_CLR36(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR1_CLR36_SHIFT)) & DMA_COMMON_ENABLECLR1_CLR36_MASK)

#define DMA_COMMON_ENABLECLR1_CLR37_MASK         (0x20U)
#define DMA_COMMON_ENABLECLR1_CLR37_SHIFT        (5U)
/*! CLR37 - Writing ones to this register clears the corresponding bits in ENABLESET1.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR1_CLR37(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR1_CLR37_SHIFT)) & DMA_COMMON_ENABLECLR1_CLR37_MASK)

#define DMA_COMMON_ENABLECLR1_CLR38_MASK         (0x40U)
#define DMA_COMMON_ENABLECLR1_CLR38_SHIFT        (6U)
/*! CLR38 - Writing ones to this register clears the corresponding bits in ENABLESET1.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR1_CLR38(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR1_CLR38_SHIFT)) & DMA_COMMON_ENABLECLR1_CLR38_MASK)

#define DMA_COMMON_ENABLECLR1_CLR39_MASK         (0x80U)
#define DMA_COMMON_ENABLECLR1_CLR39_SHIFT        (7U)
/*! CLR39 - Writing ones to this register clears the corresponding bits in ENABLESET1.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR1_CLR39(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR1_CLR39_SHIFT)) & DMA_COMMON_ENABLECLR1_CLR39_MASK)

#define DMA_COMMON_ENABLECLR1_CLR40_MASK         (0x100U)
#define DMA_COMMON_ENABLECLR1_CLR40_SHIFT        (8U)
/*! CLR40 - Writing ones to this register clears the corresponding bits in ENABLESET1.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR1_CLR40(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR1_CLR40_SHIFT)) & DMA_COMMON_ENABLECLR1_CLR40_MASK)

#define DMA_COMMON_ENABLECLR1_CLR41_MASK         (0x200U)
#define DMA_COMMON_ENABLECLR1_CLR41_SHIFT        (9U)
/*! CLR41 - Writing ones to this register clears the corresponding bits in ENABLESET1.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR1_CLR41(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR1_CLR41_SHIFT)) & DMA_COMMON_ENABLECLR1_CLR41_MASK)

#define DMA_COMMON_ENABLECLR1_CLR42_MASK         (0x400U)
#define DMA_COMMON_ENABLECLR1_CLR42_SHIFT        (10U)
/*! CLR42 - Writing ones to this register clears the corresponding bits in ENABLESET1.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR1_CLR42(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR1_CLR42_SHIFT)) & DMA_COMMON_ENABLECLR1_CLR42_MASK)

#define DMA_COMMON_ENABLECLR1_CLR43_MASK         (0x800U)
#define DMA_COMMON_ENABLECLR1_CLR43_SHIFT        (11U)
/*! CLR43 - Writing ones to this register clears the corresponding bits in ENABLESET1.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR1_CLR43(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR1_CLR43_SHIFT)) & DMA_COMMON_ENABLECLR1_CLR43_MASK)

#define DMA_COMMON_ENABLECLR1_CLR44_MASK         (0x1000U)
#define DMA_COMMON_ENABLECLR1_CLR44_SHIFT        (12U)
/*! CLR44 - Writing ones to this register clears the corresponding bits in ENABLESET1.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR1_CLR44(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR1_CLR44_SHIFT)) & DMA_COMMON_ENABLECLR1_CLR44_MASK)

#define DMA_COMMON_ENABLECLR1_CLR45_MASK         (0x2000U)
#define DMA_COMMON_ENABLECLR1_CLR45_SHIFT        (13U)
/*! CLR45 - Writing ones to this register clears the corresponding bits in ENABLESET1.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR1_CLR45(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR1_CLR45_SHIFT)) & DMA_COMMON_ENABLECLR1_CLR45_MASK)

#define DMA_COMMON_ENABLECLR1_CLR46_MASK         (0x4000U)
#define DMA_COMMON_ENABLECLR1_CLR46_SHIFT        (14U)
/*! CLR46 - Writing ones to this register clears the corresponding bits in ENABLESET1.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR1_CLR46(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR1_CLR46_SHIFT)) & DMA_COMMON_ENABLECLR1_CLR46_MASK)

#define DMA_COMMON_ENABLECLR1_CLR47_MASK         (0x8000U)
#define DMA_COMMON_ENABLECLR1_CLR47_SHIFT        (15U)
/*! CLR47 - Writing ones to this register clears the corresponding bits in ENABLESET1.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR1_CLR47(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR1_CLR47_SHIFT)) & DMA_COMMON_ENABLECLR1_CLR47_MASK)

#define DMA_COMMON_ENABLECLR1_CLR48_MASK         (0x10000U)
#define DMA_COMMON_ENABLECLR1_CLR48_SHIFT        (16U)
/*! CLR48 - Writing ones to this register clears the corresponding bits in ENABLESET1.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR1_CLR48(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR1_CLR48_SHIFT)) & DMA_COMMON_ENABLECLR1_CLR48_MASK)

#define DMA_COMMON_ENABLECLR1_CLR49_MASK         (0x20000U)
#define DMA_COMMON_ENABLECLR1_CLR49_SHIFT        (17U)
/*! CLR49 - Writing ones to this register clears the corresponding bits in ENABLESET1.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR1_CLR49(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR1_CLR49_SHIFT)) & DMA_COMMON_ENABLECLR1_CLR49_MASK)

#define DMA_COMMON_ENABLECLR1_CLR50_MASK         (0x40000U)
#define DMA_COMMON_ENABLECLR1_CLR50_SHIFT        (18U)
/*! CLR50 - Writing ones to this register clears the corresponding bits in ENABLESET1.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR1_CLR50(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR1_CLR50_SHIFT)) & DMA_COMMON_ENABLECLR1_CLR50_MASK)

#define DMA_COMMON_ENABLECLR1_CLR51_MASK         (0x80000U)
#define DMA_COMMON_ENABLECLR1_CLR51_SHIFT        (19U)
/*! CLR51 - Writing ones to this register clears the corresponding bits in ENABLESET1.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR1_CLR51(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR1_CLR51_SHIFT)) & DMA_COMMON_ENABLECLR1_CLR51_MASK)
/*! @} */

/* The count of DMA_COMMON_ENABLECLR1 */
#define DMA_COMMON_ENABLECLR1_COUNT              (1U)

/*! @name COMMON_ACTIVE - Channel Active status for all DMA channels */
/*! @{ */

#define DMA_COMMON_ACTIVE_ACTIVE0_MASK           (0x1U)
#define DMA_COMMON_ACTIVE_ACTIVE0_SHIFT          (0U)
/*! ACTIVE0 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE0(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE0_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE0_MASK)

#define DMA_COMMON_ACTIVE_ACTIVE1_MASK           (0x2U)
#define DMA_COMMON_ACTIVE_ACTIVE1_SHIFT          (1U)
/*! ACTIVE1 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE1(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE1_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE1_MASK)

#define DMA_COMMON_ACTIVE_ACTIVE2_MASK           (0x4U)
#define DMA_COMMON_ACTIVE_ACTIVE2_SHIFT          (2U)
/*! ACTIVE2 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE2(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE2_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE2_MASK)

#define DMA_COMMON_ACTIVE_ACTIVE3_MASK           (0x8U)
#define DMA_COMMON_ACTIVE_ACTIVE3_SHIFT          (3U)
/*! ACTIVE3 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE3(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE3_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE3_MASK)

#define DMA_COMMON_ACTIVE_ACTIVE4_MASK           (0x10U)
#define DMA_COMMON_ACTIVE_ACTIVE4_SHIFT          (4U)
/*! ACTIVE4 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE4(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE4_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE4_MASK)

#define DMA_COMMON_ACTIVE_ACTIVE5_MASK           (0x20U)
#define DMA_COMMON_ACTIVE_ACTIVE5_SHIFT          (5U)
/*! ACTIVE5 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE5(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE5_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE5_MASK)

#define DMA_COMMON_ACTIVE_ACTIVE6_MASK           (0x40U)
#define DMA_COMMON_ACTIVE_ACTIVE6_SHIFT          (6U)
/*! ACTIVE6 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE6(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE6_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE6_MASK)

#define DMA_COMMON_ACTIVE_ACTIVE7_MASK           (0x80U)
#define DMA_COMMON_ACTIVE_ACTIVE7_SHIFT          (7U)
/*! ACTIVE7 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE7(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE7_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE7_MASK)

#define DMA_COMMON_ACTIVE_ACTIVE8_MASK           (0x100U)
#define DMA_COMMON_ACTIVE_ACTIVE8_SHIFT          (8U)
/*! ACTIVE8 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE8(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE8_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE8_MASK)

#define DMA_COMMON_ACTIVE_ACTIVE9_MASK           (0x200U)
#define DMA_COMMON_ACTIVE_ACTIVE9_SHIFT          (9U)
/*! ACTIVE9 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE9(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE9_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE9_MASK)

#define DMA_COMMON_ACTIVE_ACTIVE10_MASK          (0x400U)
#define DMA_COMMON_ACTIVE_ACTIVE10_SHIFT         (10U)
/*! ACTIVE10 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE10(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE10_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE10_MASK)

#define DMA_COMMON_ACTIVE_ACTIVE11_MASK          (0x800U)
#define DMA_COMMON_ACTIVE_ACTIVE11_SHIFT         (11U)
/*! ACTIVE11 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE11(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE11_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE11_MASK)

#define DMA_COMMON_ACTIVE_ACTIVE12_MASK          (0x1000U)
#define DMA_COMMON_ACTIVE_ACTIVE12_SHIFT         (12U)
/*! ACTIVE12 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE12(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE12_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE12_MASK)

#define DMA_COMMON_ACTIVE_ACTIVE13_MASK          (0x2000U)
#define DMA_COMMON_ACTIVE_ACTIVE13_SHIFT         (13U)
/*! ACTIVE13 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE13(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE13_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE13_MASK)

#define DMA_COMMON_ACTIVE_ACTIVE14_MASK          (0x4000U)
#define DMA_COMMON_ACTIVE_ACTIVE14_SHIFT         (14U)
/*! ACTIVE14 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE14(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE14_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE14_MASK)

#define DMA_COMMON_ACTIVE_ACTIVE15_MASK          (0x8000U)
#define DMA_COMMON_ACTIVE_ACTIVE15_SHIFT         (15U)
/*! ACTIVE15 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE15(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE15_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE15_MASK)

#define DMA_COMMON_ACTIVE_ACTIVE16_MASK          (0x10000U)
#define DMA_COMMON_ACTIVE_ACTIVE16_SHIFT         (16U)
/*! ACTIVE16 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE16(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE16_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE16_MASK)

#define DMA_COMMON_ACTIVE_ACTIVE17_MASK          (0x20000U)
#define DMA_COMMON_ACTIVE_ACTIVE17_SHIFT         (17U)
/*! ACTIVE17 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE17(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE17_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE17_MASK)

#define DMA_COMMON_ACTIVE_ACTIVE18_MASK          (0x40000U)
#define DMA_COMMON_ACTIVE_ACTIVE18_SHIFT         (18U)
/*! ACTIVE18 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE18(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE18_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE18_MASK)

#define DMA_COMMON_ACTIVE_ACTIVE19_MASK          (0x80000U)
#define DMA_COMMON_ACTIVE_ACTIVE19_SHIFT         (19U)
/*! ACTIVE19 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE19(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE19_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE19_MASK)

#define DMA_COMMON_ACTIVE_ACTIVE20_MASK          (0x100000U)
#define DMA_COMMON_ACTIVE_ACTIVE20_SHIFT         (20U)
/*! ACTIVE20 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE20(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE20_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE20_MASK)

#define DMA_COMMON_ACTIVE_ACTIVE21_MASK          (0x200000U)
#define DMA_COMMON_ACTIVE_ACTIVE21_SHIFT         (21U)
/*! ACTIVE21 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE21(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE21_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE21_MASK)

#define DMA_COMMON_ACTIVE_ACTIVE22_MASK          (0x400000U)
#define DMA_COMMON_ACTIVE_ACTIVE22_SHIFT         (22U)
/*! ACTIVE22 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE22(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE22_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE22_MASK)

#define DMA_COMMON_ACTIVE_ACTIVE23_MASK          (0x800000U)
#define DMA_COMMON_ACTIVE_ACTIVE23_SHIFT         (23U)
/*! ACTIVE23 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE23(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE23_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE23_MASK)

#define DMA_COMMON_ACTIVE_ACTIVE24_MASK          (0x1000000U)
#define DMA_COMMON_ACTIVE_ACTIVE24_SHIFT         (24U)
/*! ACTIVE24 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE24(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE24_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE24_MASK)

#define DMA_COMMON_ACTIVE_ACTIVE25_MASK          (0x2000000U)
#define DMA_COMMON_ACTIVE_ACTIVE25_SHIFT         (25U)
/*! ACTIVE25 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE25(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE25_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE25_MASK)

#define DMA_COMMON_ACTIVE_ACTIVE26_MASK          (0x4000000U)
#define DMA_COMMON_ACTIVE_ACTIVE26_SHIFT         (26U)
/*! ACTIVE26 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE26(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE26_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE26_MASK)

#define DMA_COMMON_ACTIVE_ACTIVE27_MASK          (0x8000000U)
#define DMA_COMMON_ACTIVE_ACTIVE27_SHIFT         (27U)
/*! ACTIVE27 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE27(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE27_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE27_MASK)

#define DMA_COMMON_ACTIVE_ACTIVE28_MASK          (0x10000000U)
#define DMA_COMMON_ACTIVE_ACTIVE28_SHIFT         (28U)
/*! ACTIVE28 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE28(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE28_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE28_MASK)

#define DMA_COMMON_ACTIVE_ACTIVE29_MASK          (0x20000000U)
#define DMA_COMMON_ACTIVE_ACTIVE29_SHIFT         (29U)
/*! ACTIVE29 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE29(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE29_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE29_MASK)

#define DMA_COMMON_ACTIVE_ACTIVE30_MASK          (0x40000000U)
#define DMA_COMMON_ACTIVE_ACTIVE30_SHIFT         (30U)
/*! ACTIVE30 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE30(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE30_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE30_MASK)

#define DMA_COMMON_ACTIVE_ACTIVE31_MASK          (0x80000000U)
#define DMA_COMMON_ACTIVE_ACTIVE31_SHIFT         (31U)
/*! ACTIVE31 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE31(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE31_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE31_MASK)
/*! @} */

/* The count of DMA_COMMON_ACTIVE */
#define DMA_COMMON_ACTIVE_COUNT                  (1U)

/*! @name COMMON_ACTIVE1 - Channel Active status for all DMA channels */
/*! @{ */

#define DMA_COMMON_ACTIVE1_ACTIVE32_MASK         (0x1U)
#define DMA_COMMON_ACTIVE1_ACTIVE32_SHIFT        (0U)
/*! ACTIVE32 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE1_ACTIVE32(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE1_ACTIVE32_SHIFT)) & DMA_COMMON_ACTIVE1_ACTIVE32_MASK)

#define DMA_COMMON_ACTIVE1_ACTIVE33_MASK         (0x2U)
#define DMA_COMMON_ACTIVE1_ACTIVE33_SHIFT        (1U)
/*! ACTIVE33 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE1_ACTIVE33(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE1_ACTIVE33_SHIFT)) & DMA_COMMON_ACTIVE1_ACTIVE33_MASK)

#define DMA_COMMON_ACTIVE1_ACTIVE34_MASK         (0x4U)
#define DMA_COMMON_ACTIVE1_ACTIVE34_SHIFT        (2U)
/*! ACTIVE34 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE1_ACTIVE34(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE1_ACTIVE34_SHIFT)) & DMA_COMMON_ACTIVE1_ACTIVE34_MASK)

#define DMA_COMMON_ACTIVE1_ACTIVE35_MASK         (0x8U)
#define DMA_COMMON_ACTIVE1_ACTIVE35_SHIFT        (3U)
/*! ACTIVE35 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE1_ACTIVE35(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE1_ACTIVE35_SHIFT)) & DMA_COMMON_ACTIVE1_ACTIVE35_MASK)

#define DMA_COMMON_ACTIVE1_ACTIVE36_MASK         (0x10U)
#define DMA_COMMON_ACTIVE1_ACTIVE36_SHIFT        (4U)
/*! ACTIVE36 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE1_ACTIVE36(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE1_ACTIVE36_SHIFT)) & DMA_COMMON_ACTIVE1_ACTIVE36_MASK)

#define DMA_COMMON_ACTIVE1_ACTIVE37_MASK         (0x20U)
#define DMA_COMMON_ACTIVE1_ACTIVE37_SHIFT        (5U)
/*! ACTIVE37 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE1_ACTIVE37(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE1_ACTIVE37_SHIFT)) & DMA_COMMON_ACTIVE1_ACTIVE37_MASK)

#define DMA_COMMON_ACTIVE1_ACTIVE38_MASK         (0x40U)
#define DMA_COMMON_ACTIVE1_ACTIVE38_SHIFT        (6U)
/*! ACTIVE38 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE1_ACTIVE38(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE1_ACTIVE38_SHIFT)) & DMA_COMMON_ACTIVE1_ACTIVE38_MASK)

#define DMA_COMMON_ACTIVE1_ACTIVE39_MASK         (0x80U)
#define DMA_COMMON_ACTIVE1_ACTIVE39_SHIFT        (7U)
/*! ACTIVE39 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE1_ACTIVE39(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE1_ACTIVE39_SHIFT)) & DMA_COMMON_ACTIVE1_ACTIVE39_MASK)

#define DMA_COMMON_ACTIVE1_ACTIVE40_MASK         (0x100U)
#define DMA_COMMON_ACTIVE1_ACTIVE40_SHIFT        (8U)
/*! ACTIVE40 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE1_ACTIVE40(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE1_ACTIVE40_SHIFT)) & DMA_COMMON_ACTIVE1_ACTIVE40_MASK)

#define DMA_COMMON_ACTIVE1_ACTIVE41_MASK         (0x200U)
#define DMA_COMMON_ACTIVE1_ACTIVE41_SHIFT        (9U)
/*! ACTIVE41 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE1_ACTIVE41(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE1_ACTIVE41_SHIFT)) & DMA_COMMON_ACTIVE1_ACTIVE41_MASK)

#define DMA_COMMON_ACTIVE1_ACTIVE42_MASK         (0x400U)
#define DMA_COMMON_ACTIVE1_ACTIVE42_SHIFT        (10U)
/*! ACTIVE42 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE1_ACTIVE42(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE1_ACTIVE42_SHIFT)) & DMA_COMMON_ACTIVE1_ACTIVE42_MASK)

#define DMA_COMMON_ACTIVE1_ACTIVE43_MASK         (0x800U)
#define DMA_COMMON_ACTIVE1_ACTIVE43_SHIFT        (11U)
/*! ACTIVE43 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE1_ACTIVE43(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE1_ACTIVE43_SHIFT)) & DMA_COMMON_ACTIVE1_ACTIVE43_MASK)

#define DMA_COMMON_ACTIVE1_ACTIVE44_MASK         (0x1000U)
#define DMA_COMMON_ACTIVE1_ACTIVE44_SHIFT        (12U)
/*! ACTIVE44 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE1_ACTIVE44(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE1_ACTIVE44_SHIFT)) & DMA_COMMON_ACTIVE1_ACTIVE44_MASK)

#define DMA_COMMON_ACTIVE1_ACTIVE45_MASK         (0x2000U)
#define DMA_COMMON_ACTIVE1_ACTIVE45_SHIFT        (13U)
/*! ACTIVE45 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE1_ACTIVE45(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE1_ACTIVE45_SHIFT)) & DMA_COMMON_ACTIVE1_ACTIVE45_MASK)

#define DMA_COMMON_ACTIVE1_ACTIVE46_MASK         (0x4000U)
#define DMA_COMMON_ACTIVE1_ACTIVE46_SHIFT        (14U)
/*! ACTIVE46 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE1_ACTIVE46(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE1_ACTIVE46_SHIFT)) & DMA_COMMON_ACTIVE1_ACTIVE46_MASK)

#define DMA_COMMON_ACTIVE1_ACTIVE47_MASK         (0x8000U)
#define DMA_COMMON_ACTIVE1_ACTIVE47_SHIFT        (15U)
/*! ACTIVE47 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE1_ACTIVE47(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE1_ACTIVE47_SHIFT)) & DMA_COMMON_ACTIVE1_ACTIVE47_MASK)

#define DMA_COMMON_ACTIVE1_ACTIVE48_MASK         (0x10000U)
#define DMA_COMMON_ACTIVE1_ACTIVE48_SHIFT        (16U)
/*! ACTIVE48 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE1_ACTIVE48(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE1_ACTIVE48_SHIFT)) & DMA_COMMON_ACTIVE1_ACTIVE48_MASK)

#define DMA_COMMON_ACTIVE1_ACTIVE49_MASK         (0x20000U)
#define DMA_COMMON_ACTIVE1_ACTIVE49_SHIFT        (17U)
/*! ACTIVE49 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE1_ACTIVE49(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE1_ACTIVE49_SHIFT)) & DMA_COMMON_ACTIVE1_ACTIVE49_MASK)

#define DMA_COMMON_ACTIVE1_ACTIVE50_MASK         (0x40000U)
#define DMA_COMMON_ACTIVE1_ACTIVE50_SHIFT        (18U)
/*! ACTIVE50 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE1_ACTIVE50(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE1_ACTIVE50_SHIFT)) & DMA_COMMON_ACTIVE1_ACTIVE50_MASK)

#define DMA_COMMON_ACTIVE1_ACTIVE51_MASK         (0x80000U)
#define DMA_COMMON_ACTIVE1_ACTIVE51_SHIFT        (19U)
/*! ACTIVE51 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE1_ACTIVE51(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE1_ACTIVE51_SHIFT)) & DMA_COMMON_ACTIVE1_ACTIVE51_MASK)
/*! @} */

/* The count of DMA_COMMON_ACTIVE1 */
#define DMA_COMMON_ACTIVE1_COUNT                 (1U)

/*! @name COMMON_BUSY - Channel Busy status for all DMA channels */
/*! @{ */

#define DMA_COMMON_BUSY_BUSY0_MASK               (0x1U)
#define DMA_COMMON_BUSY_BUSY0_SHIFT              (0U)
/*! BUSY0 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY0(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY0_SHIFT)) & DMA_COMMON_BUSY_BUSY0_MASK)

#define DMA_COMMON_BUSY_BUSY1_MASK               (0x2U)
#define DMA_COMMON_BUSY_BUSY1_SHIFT              (1U)
/*! BUSY1 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY1(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY1_SHIFT)) & DMA_COMMON_BUSY_BUSY1_MASK)

#define DMA_COMMON_BUSY_BUSY2_MASK               (0x4U)
#define DMA_COMMON_BUSY_BUSY2_SHIFT              (2U)
/*! BUSY2 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY2(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY2_SHIFT)) & DMA_COMMON_BUSY_BUSY2_MASK)

#define DMA_COMMON_BUSY_BUSY3_MASK               (0x8U)
#define DMA_COMMON_BUSY_BUSY3_SHIFT              (3U)
/*! BUSY3 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY3(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY3_SHIFT)) & DMA_COMMON_BUSY_BUSY3_MASK)

#define DMA_COMMON_BUSY_BUSY4_MASK               (0x10U)
#define DMA_COMMON_BUSY_BUSY4_SHIFT              (4U)
/*! BUSY4 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY4(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY4_SHIFT)) & DMA_COMMON_BUSY_BUSY4_MASK)

#define DMA_COMMON_BUSY_BUSY5_MASK               (0x20U)
#define DMA_COMMON_BUSY_BUSY5_SHIFT              (5U)
/*! BUSY5 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY5(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY5_SHIFT)) & DMA_COMMON_BUSY_BUSY5_MASK)

#define DMA_COMMON_BUSY_BUSY6_MASK               (0x40U)
#define DMA_COMMON_BUSY_BUSY6_SHIFT              (6U)
/*! BUSY6 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY6(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY6_SHIFT)) & DMA_COMMON_BUSY_BUSY6_MASK)

#define DMA_COMMON_BUSY_BUSY7_MASK               (0x80U)
#define DMA_COMMON_BUSY_BUSY7_SHIFT              (7U)
/*! BUSY7 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY7(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY7_SHIFT)) & DMA_COMMON_BUSY_BUSY7_MASK)

#define DMA_COMMON_BUSY_BUSY8_MASK               (0x100U)
#define DMA_COMMON_BUSY_BUSY8_SHIFT              (8U)
/*! BUSY8 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY8(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY8_SHIFT)) & DMA_COMMON_BUSY_BUSY8_MASK)

#define DMA_COMMON_BUSY_BUSY9_MASK               (0x200U)
#define DMA_COMMON_BUSY_BUSY9_SHIFT              (9U)
/*! BUSY9 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY9(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY9_SHIFT)) & DMA_COMMON_BUSY_BUSY9_MASK)

#define DMA_COMMON_BUSY_BUSY10_MASK              (0x400U)
#define DMA_COMMON_BUSY_BUSY10_SHIFT             (10U)
/*! BUSY10 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY10(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY10_SHIFT)) & DMA_COMMON_BUSY_BUSY10_MASK)

#define DMA_COMMON_BUSY_BUSY11_MASK              (0x800U)
#define DMA_COMMON_BUSY_BUSY11_SHIFT             (11U)
/*! BUSY11 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY11(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY11_SHIFT)) & DMA_COMMON_BUSY_BUSY11_MASK)

#define DMA_COMMON_BUSY_BUSY12_MASK              (0x1000U)
#define DMA_COMMON_BUSY_BUSY12_SHIFT             (12U)
/*! BUSY12 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY12(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY12_SHIFT)) & DMA_COMMON_BUSY_BUSY12_MASK)

#define DMA_COMMON_BUSY_BUSY13_MASK              (0x2000U)
#define DMA_COMMON_BUSY_BUSY13_SHIFT             (13U)
/*! BUSY13 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY13(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY13_SHIFT)) & DMA_COMMON_BUSY_BUSY13_MASK)

#define DMA_COMMON_BUSY_BUSY14_MASK              (0x4000U)
#define DMA_COMMON_BUSY_BUSY14_SHIFT             (14U)
/*! BUSY14 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY14(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY14_SHIFT)) & DMA_COMMON_BUSY_BUSY14_MASK)

#define DMA_COMMON_BUSY_BUSY15_MASK              (0x8000U)
#define DMA_COMMON_BUSY_BUSY15_SHIFT             (15U)
/*! BUSY15 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY15(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY15_SHIFT)) & DMA_COMMON_BUSY_BUSY15_MASK)

#define DMA_COMMON_BUSY_BUSY16_MASK              (0x10000U)
#define DMA_COMMON_BUSY_BUSY16_SHIFT             (16U)
/*! BUSY16 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY16(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY16_SHIFT)) & DMA_COMMON_BUSY_BUSY16_MASK)

#define DMA_COMMON_BUSY_BUSY17_MASK              (0x20000U)
#define DMA_COMMON_BUSY_BUSY17_SHIFT             (17U)
/*! BUSY17 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY17(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY17_SHIFT)) & DMA_COMMON_BUSY_BUSY17_MASK)

#define DMA_COMMON_BUSY_BUSY18_MASK              (0x40000U)
#define DMA_COMMON_BUSY_BUSY18_SHIFT             (18U)
/*! BUSY18 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY18(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY18_SHIFT)) & DMA_COMMON_BUSY_BUSY18_MASK)

#define DMA_COMMON_BUSY_BUSY19_MASK              (0x80000U)
#define DMA_COMMON_BUSY_BUSY19_SHIFT             (19U)
/*! BUSY19 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY19(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY19_SHIFT)) & DMA_COMMON_BUSY_BUSY19_MASK)

#define DMA_COMMON_BUSY_BUSY20_MASK              (0x100000U)
#define DMA_COMMON_BUSY_BUSY20_SHIFT             (20U)
/*! BUSY20 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY20(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY20_SHIFT)) & DMA_COMMON_BUSY_BUSY20_MASK)

#define DMA_COMMON_BUSY_BUSY21_MASK              (0x200000U)
#define DMA_COMMON_BUSY_BUSY21_SHIFT             (21U)
/*! BUSY21 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY21(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY21_SHIFT)) & DMA_COMMON_BUSY_BUSY21_MASK)

#define DMA_COMMON_BUSY_BUSY22_MASK              (0x400000U)
#define DMA_COMMON_BUSY_BUSY22_SHIFT             (22U)
/*! BUSY22 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY22(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY22_SHIFT)) & DMA_COMMON_BUSY_BUSY22_MASK)

#define DMA_COMMON_BUSY_BUSY23_MASK              (0x800000U)
#define DMA_COMMON_BUSY_BUSY23_SHIFT             (23U)
/*! BUSY23 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY23(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY23_SHIFT)) & DMA_COMMON_BUSY_BUSY23_MASK)

#define DMA_COMMON_BUSY_BUSY24_MASK              (0x1000000U)
#define DMA_COMMON_BUSY_BUSY24_SHIFT             (24U)
/*! BUSY24 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY24(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY24_SHIFT)) & DMA_COMMON_BUSY_BUSY24_MASK)

#define DMA_COMMON_BUSY_BUSY25_MASK              (0x2000000U)
#define DMA_COMMON_BUSY_BUSY25_SHIFT             (25U)
/*! BUSY25 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY25(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY25_SHIFT)) & DMA_COMMON_BUSY_BUSY25_MASK)

#define DMA_COMMON_BUSY_BUSY26_MASK              (0x4000000U)
#define DMA_COMMON_BUSY_BUSY26_SHIFT             (26U)
/*! BUSY26 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY26(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY26_SHIFT)) & DMA_COMMON_BUSY_BUSY26_MASK)

#define DMA_COMMON_BUSY_BUSY27_MASK              (0x8000000U)
#define DMA_COMMON_BUSY_BUSY27_SHIFT             (27U)
/*! BUSY27 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY27(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY27_SHIFT)) & DMA_COMMON_BUSY_BUSY27_MASK)

#define DMA_COMMON_BUSY_BUSY28_MASK              (0x10000000U)
#define DMA_COMMON_BUSY_BUSY28_SHIFT             (28U)
/*! BUSY28 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY28(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY28_SHIFT)) & DMA_COMMON_BUSY_BUSY28_MASK)

#define DMA_COMMON_BUSY_BUSY29_MASK              (0x20000000U)
#define DMA_COMMON_BUSY_BUSY29_SHIFT             (29U)
/*! BUSY29 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY29(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY29_SHIFT)) & DMA_COMMON_BUSY_BUSY29_MASK)

#define DMA_COMMON_BUSY_BUSY30_MASK              (0x40000000U)
#define DMA_COMMON_BUSY_BUSY30_SHIFT             (30U)
/*! BUSY30 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY30(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY30_SHIFT)) & DMA_COMMON_BUSY_BUSY30_MASK)

#define DMA_COMMON_BUSY_BUSY31_MASK              (0x80000000U)
#define DMA_COMMON_BUSY_BUSY31_SHIFT             (31U)
/*! BUSY31 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY31(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY31_SHIFT)) & DMA_COMMON_BUSY_BUSY31_MASK)
/*! @} */

/* The count of DMA_COMMON_BUSY */
#define DMA_COMMON_BUSY_COUNT                    (1U)

/*! @name COMMON_BUSY1 - Channel Busy status for all DMA channels */
/*! @{ */

#define DMA_COMMON_BUSY1_BUSY32_MASK             (0x1U)
#define DMA_COMMON_BUSY1_BUSY32_SHIFT            (0U)
/*! BUSY32 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY1_BUSY32(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY1_BUSY32_SHIFT)) & DMA_COMMON_BUSY1_BUSY32_MASK)

#define DMA_COMMON_BUSY1_BUSY33_MASK             (0x2U)
#define DMA_COMMON_BUSY1_BUSY33_SHIFT            (1U)
/*! BUSY33 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY1_BUSY33(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY1_BUSY33_SHIFT)) & DMA_COMMON_BUSY1_BUSY33_MASK)

#define DMA_COMMON_BUSY1_BUSY34_MASK             (0x4U)
#define DMA_COMMON_BUSY1_BUSY34_SHIFT            (2U)
/*! BUSY34 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY1_BUSY34(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY1_BUSY34_SHIFT)) & DMA_COMMON_BUSY1_BUSY34_MASK)

#define DMA_COMMON_BUSY1_BUSY35_MASK             (0x8U)
#define DMA_COMMON_BUSY1_BUSY35_SHIFT            (3U)
/*! BUSY35 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY1_BUSY35(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY1_BUSY35_SHIFT)) & DMA_COMMON_BUSY1_BUSY35_MASK)

#define DMA_COMMON_BUSY1_BUSY36_MASK             (0x10U)
#define DMA_COMMON_BUSY1_BUSY36_SHIFT            (4U)
/*! BUSY36 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY1_BUSY36(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY1_BUSY36_SHIFT)) & DMA_COMMON_BUSY1_BUSY36_MASK)

#define DMA_COMMON_BUSY1_BUSY37_MASK             (0x20U)
#define DMA_COMMON_BUSY1_BUSY37_SHIFT            (5U)
/*! BUSY37 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY1_BUSY37(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY1_BUSY37_SHIFT)) & DMA_COMMON_BUSY1_BUSY37_MASK)

#define DMA_COMMON_BUSY1_BUSY38_MASK             (0x40U)
#define DMA_COMMON_BUSY1_BUSY38_SHIFT            (6U)
/*! BUSY38 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY1_BUSY38(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY1_BUSY38_SHIFT)) & DMA_COMMON_BUSY1_BUSY38_MASK)

#define DMA_COMMON_BUSY1_BUSY39_MASK             (0x80U)
#define DMA_COMMON_BUSY1_BUSY39_SHIFT            (7U)
/*! BUSY39 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY1_BUSY39(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY1_BUSY39_SHIFT)) & DMA_COMMON_BUSY1_BUSY39_MASK)

#define DMA_COMMON_BUSY1_BUSY40_MASK             (0x100U)
#define DMA_COMMON_BUSY1_BUSY40_SHIFT            (8U)
/*! BUSY40 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY1_BUSY40(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY1_BUSY40_SHIFT)) & DMA_COMMON_BUSY1_BUSY40_MASK)

#define DMA_COMMON_BUSY1_BUSY41_MASK             (0x200U)
#define DMA_COMMON_BUSY1_BUSY41_SHIFT            (9U)
/*! BUSY41 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY1_BUSY41(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY1_BUSY41_SHIFT)) & DMA_COMMON_BUSY1_BUSY41_MASK)

#define DMA_COMMON_BUSY1_BUSY42_MASK             (0x400U)
#define DMA_COMMON_BUSY1_BUSY42_SHIFT            (10U)
/*! BUSY42 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY1_BUSY42(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY1_BUSY42_SHIFT)) & DMA_COMMON_BUSY1_BUSY42_MASK)

#define DMA_COMMON_BUSY1_BUSY43_MASK             (0x800U)
#define DMA_COMMON_BUSY1_BUSY43_SHIFT            (11U)
/*! BUSY43 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY1_BUSY43(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY1_BUSY43_SHIFT)) & DMA_COMMON_BUSY1_BUSY43_MASK)

#define DMA_COMMON_BUSY1_BUSY44_MASK             (0x1000U)
#define DMA_COMMON_BUSY1_BUSY44_SHIFT            (12U)
/*! BUSY44 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY1_BUSY44(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY1_BUSY44_SHIFT)) & DMA_COMMON_BUSY1_BUSY44_MASK)

#define DMA_COMMON_BUSY1_BUSY45_MASK             (0x2000U)
#define DMA_COMMON_BUSY1_BUSY45_SHIFT            (13U)
/*! BUSY45 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY1_BUSY45(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY1_BUSY45_SHIFT)) & DMA_COMMON_BUSY1_BUSY45_MASK)

#define DMA_COMMON_BUSY1_BUSY46_MASK             (0x4000U)
#define DMA_COMMON_BUSY1_BUSY46_SHIFT            (14U)
/*! BUSY46 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY1_BUSY46(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY1_BUSY46_SHIFT)) & DMA_COMMON_BUSY1_BUSY46_MASK)

#define DMA_COMMON_BUSY1_BUSY47_MASK             (0x8000U)
#define DMA_COMMON_BUSY1_BUSY47_SHIFT            (15U)
/*! BUSY47 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY1_BUSY47(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY1_BUSY47_SHIFT)) & DMA_COMMON_BUSY1_BUSY47_MASK)

#define DMA_COMMON_BUSY1_BUSY48_MASK             (0x10000U)
#define DMA_COMMON_BUSY1_BUSY48_SHIFT            (16U)
/*! BUSY48 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY1_BUSY48(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY1_BUSY48_SHIFT)) & DMA_COMMON_BUSY1_BUSY48_MASK)

#define DMA_COMMON_BUSY1_BUSY49_MASK             (0x20000U)
#define DMA_COMMON_BUSY1_BUSY49_SHIFT            (17U)
/*! BUSY49 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY1_BUSY49(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY1_BUSY49_SHIFT)) & DMA_COMMON_BUSY1_BUSY49_MASK)

#define DMA_COMMON_BUSY1_BUSY50_MASK             (0x40000U)
#define DMA_COMMON_BUSY1_BUSY50_SHIFT            (18U)
/*! BUSY50 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY1_BUSY50(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY1_BUSY50_SHIFT)) & DMA_COMMON_BUSY1_BUSY50_MASK)

#define DMA_COMMON_BUSY1_BUSY51_MASK             (0x80000U)
#define DMA_COMMON_BUSY1_BUSY51_SHIFT            (19U)
/*! BUSY51 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY1_BUSY51(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY1_BUSY51_SHIFT)) & DMA_COMMON_BUSY1_BUSY51_MASK)
/*! @} */

/* The count of DMA_COMMON_BUSY1 */
#define DMA_COMMON_BUSY1_COUNT                   (1U)

/*! @name COMMON_ERRINT - Error Interrupt status for all DMA channels */
/*! @{ */

#define DMA_COMMON_ERRINT_ERR0_MASK              (0x1U)
#define DMA_COMMON_ERRINT_ERR0_SHIFT             (0U)
/*! ERR0 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR0(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR0_SHIFT)) & DMA_COMMON_ERRINT_ERR0_MASK)

#define DMA_COMMON_ERRINT_ERR1_MASK              (0x2U)
#define DMA_COMMON_ERRINT_ERR1_SHIFT             (1U)
/*! ERR1 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR1(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR1_SHIFT)) & DMA_COMMON_ERRINT_ERR1_MASK)

#define DMA_COMMON_ERRINT_ERR2_MASK              (0x4U)
#define DMA_COMMON_ERRINT_ERR2_SHIFT             (2U)
/*! ERR2 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR2(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR2_SHIFT)) & DMA_COMMON_ERRINT_ERR2_MASK)

#define DMA_COMMON_ERRINT_ERR3_MASK              (0x8U)
#define DMA_COMMON_ERRINT_ERR3_SHIFT             (3U)
/*! ERR3 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR3(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR3_SHIFT)) & DMA_COMMON_ERRINT_ERR3_MASK)

#define DMA_COMMON_ERRINT_ERR4_MASK              (0x10U)
#define DMA_COMMON_ERRINT_ERR4_SHIFT             (4U)
/*! ERR4 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR4(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR4_SHIFT)) & DMA_COMMON_ERRINT_ERR4_MASK)

#define DMA_COMMON_ERRINT_ERR5_MASK              (0x20U)
#define DMA_COMMON_ERRINT_ERR5_SHIFT             (5U)
/*! ERR5 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR5(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR5_SHIFT)) & DMA_COMMON_ERRINT_ERR5_MASK)

#define DMA_COMMON_ERRINT_ERR6_MASK              (0x40U)
#define DMA_COMMON_ERRINT_ERR6_SHIFT             (6U)
/*! ERR6 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR6(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR6_SHIFT)) & DMA_COMMON_ERRINT_ERR6_MASK)

#define DMA_COMMON_ERRINT_ERR7_MASK              (0x80U)
#define DMA_COMMON_ERRINT_ERR7_SHIFT             (7U)
/*! ERR7 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR7(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR7_SHIFT)) & DMA_COMMON_ERRINT_ERR7_MASK)

#define DMA_COMMON_ERRINT_ERR8_MASK              (0x100U)
#define DMA_COMMON_ERRINT_ERR8_SHIFT             (8U)
/*! ERR8 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR8(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR8_SHIFT)) & DMA_COMMON_ERRINT_ERR8_MASK)

#define DMA_COMMON_ERRINT_ERR9_MASK              (0x200U)
#define DMA_COMMON_ERRINT_ERR9_SHIFT             (9U)
/*! ERR9 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR9(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR9_SHIFT)) & DMA_COMMON_ERRINT_ERR9_MASK)

#define DMA_COMMON_ERRINT_ERR10_MASK             (0x400U)
#define DMA_COMMON_ERRINT_ERR10_SHIFT            (10U)
/*! ERR10 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR10(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR10_SHIFT)) & DMA_COMMON_ERRINT_ERR10_MASK)

#define DMA_COMMON_ERRINT_ERR11_MASK             (0x800U)
#define DMA_COMMON_ERRINT_ERR11_SHIFT            (11U)
/*! ERR11 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR11(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR11_SHIFT)) & DMA_COMMON_ERRINT_ERR11_MASK)

#define DMA_COMMON_ERRINT_ERR12_MASK             (0x1000U)
#define DMA_COMMON_ERRINT_ERR12_SHIFT            (12U)
/*! ERR12 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR12(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR12_SHIFT)) & DMA_COMMON_ERRINT_ERR12_MASK)

#define DMA_COMMON_ERRINT_ERR13_MASK             (0x2000U)
#define DMA_COMMON_ERRINT_ERR13_SHIFT            (13U)
/*! ERR13 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR13(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR13_SHIFT)) & DMA_COMMON_ERRINT_ERR13_MASK)

#define DMA_COMMON_ERRINT_ERR14_MASK             (0x4000U)
#define DMA_COMMON_ERRINT_ERR14_SHIFT            (14U)
/*! ERR14 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR14(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR14_SHIFT)) & DMA_COMMON_ERRINT_ERR14_MASK)

#define DMA_COMMON_ERRINT_ERR15_MASK             (0x8000U)
#define DMA_COMMON_ERRINT_ERR15_SHIFT            (15U)
/*! ERR15 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR15(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR15_SHIFT)) & DMA_COMMON_ERRINT_ERR15_MASK)

#define DMA_COMMON_ERRINT_ERR16_MASK             (0x10000U)
#define DMA_COMMON_ERRINT_ERR16_SHIFT            (16U)
/*! ERR16 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR16(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR16_SHIFT)) & DMA_COMMON_ERRINT_ERR16_MASK)

#define DMA_COMMON_ERRINT_ERR17_MASK             (0x20000U)
#define DMA_COMMON_ERRINT_ERR17_SHIFT            (17U)
/*! ERR17 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR17(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR17_SHIFT)) & DMA_COMMON_ERRINT_ERR17_MASK)

#define DMA_COMMON_ERRINT_ERR18_MASK             (0x40000U)
#define DMA_COMMON_ERRINT_ERR18_SHIFT            (18U)
/*! ERR18 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR18(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR18_SHIFT)) & DMA_COMMON_ERRINT_ERR18_MASK)

#define DMA_COMMON_ERRINT_ERR19_MASK             (0x80000U)
#define DMA_COMMON_ERRINT_ERR19_SHIFT            (19U)
/*! ERR19 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR19(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR19_SHIFT)) & DMA_COMMON_ERRINT_ERR19_MASK)

#define DMA_COMMON_ERRINT_ERR20_MASK             (0x100000U)
#define DMA_COMMON_ERRINT_ERR20_SHIFT            (20U)
/*! ERR20 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR20(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR20_SHIFT)) & DMA_COMMON_ERRINT_ERR20_MASK)

#define DMA_COMMON_ERRINT_ERR21_MASK             (0x200000U)
#define DMA_COMMON_ERRINT_ERR21_SHIFT            (21U)
/*! ERR21 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR21(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR21_SHIFT)) & DMA_COMMON_ERRINT_ERR21_MASK)

#define DMA_COMMON_ERRINT_ERR22_MASK             (0x400000U)
#define DMA_COMMON_ERRINT_ERR22_SHIFT            (22U)
/*! ERR22 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR22(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR22_SHIFT)) & DMA_COMMON_ERRINT_ERR22_MASK)

#define DMA_COMMON_ERRINT_ERR23_MASK             (0x800000U)
#define DMA_COMMON_ERRINT_ERR23_SHIFT            (23U)
/*! ERR23 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR23(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR23_SHIFT)) & DMA_COMMON_ERRINT_ERR23_MASK)

#define DMA_COMMON_ERRINT_ERR24_MASK             (0x1000000U)
#define DMA_COMMON_ERRINT_ERR24_SHIFT            (24U)
/*! ERR24 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR24(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR24_SHIFT)) & DMA_COMMON_ERRINT_ERR24_MASK)

#define DMA_COMMON_ERRINT_ERR25_MASK             (0x2000000U)
#define DMA_COMMON_ERRINT_ERR25_SHIFT            (25U)
/*! ERR25 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR25(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR25_SHIFT)) & DMA_COMMON_ERRINT_ERR25_MASK)

#define DMA_COMMON_ERRINT_ERR26_MASK             (0x4000000U)
#define DMA_COMMON_ERRINT_ERR26_SHIFT            (26U)
/*! ERR26 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR26(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR26_SHIFT)) & DMA_COMMON_ERRINT_ERR26_MASK)

#define DMA_COMMON_ERRINT_ERR27_MASK             (0x8000000U)
#define DMA_COMMON_ERRINT_ERR27_SHIFT            (27U)
/*! ERR27 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR27(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR27_SHIFT)) & DMA_COMMON_ERRINT_ERR27_MASK)

#define DMA_COMMON_ERRINT_ERR28_MASK             (0x10000000U)
#define DMA_COMMON_ERRINT_ERR28_SHIFT            (28U)
/*! ERR28 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR28(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR28_SHIFT)) & DMA_COMMON_ERRINT_ERR28_MASK)

#define DMA_COMMON_ERRINT_ERR29_MASK             (0x20000000U)
#define DMA_COMMON_ERRINT_ERR29_SHIFT            (29U)
/*! ERR29 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR29(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR29_SHIFT)) & DMA_COMMON_ERRINT_ERR29_MASK)

#define DMA_COMMON_ERRINT_ERR30_MASK             (0x40000000U)
#define DMA_COMMON_ERRINT_ERR30_SHIFT            (30U)
/*! ERR30 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR30(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR30_SHIFT)) & DMA_COMMON_ERRINT_ERR30_MASK)

#define DMA_COMMON_ERRINT_ERR31_MASK             (0x80000000U)
#define DMA_COMMON_ERRINT_ERR31_SHIFT            (31U)
/*! ERR31 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR31(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR31_SHIFT)) & DMA_COMMON_ERRINT_ERR31_MASK)
/*! @} */

/* The count of DMA_COMMON_ERRINT */
#define DMA_COMMON_ERRINT_COUNT                  (1U)

/*! @name COMMON_ERRINT1 - Error Interrupt status for all DMA channels */
/*! @{ */

#define DMA_COMMON_ERRINT1_ERR32_MASK            (0x1U)
#define DMA_COMMON_ERRINT1_ERR32_SHIFT           (0U)
/*! ERR32 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT1_ERR32(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT1_ERR32_SHIFT)) & DMA_COMMON_ERRINT1_ERR32_MASK)

#define DMA_COMMON_ERRINT1_ERR33_MASK            (0x2U)
#define DMA_COMMON_ERRINT1_ERR33_SHIFT           (1U)
/*! ERR33 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT1_ERR33(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT1_ERR33_SHIFT)) & DMA_COMMON_ERRINT1_ERR33_MASK)

#define DMA_COMMON_ERRINT1_ERR34_MASK            (0x4U)
#define DMA_COMMON_ERRINT1_ERR34_SHIFT           (2U)
/*! ERR34 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT1_ERR34(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT1_ERR34_SHIFT)) & DMA_COMMON_ERRINT1_ERR34_MASK)

#define DMA_COMMON_ERRINT1_ERR35_MASK            (0x8U)
#define DMA_COMMON_ERRINT1_ERR35_SHIFT           (3U)
/*! ERR35 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT1_ERR35(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT1_ERR35_SHIFT)) & DMA_COMMON_ERRINT1_ERR35_MASK)

#define DMA_COMMON_ERRINT1_ERR36_MASK            (0x10U)
#define DMA_COMMON_ERRINT1_ERR36_SHIFT           (4U)
/*! ERR36 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT1_ERR36(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT1_ERR36_SHIFT)) & DMA_COMMON_ERRINT1_ERR36_MASK)

#define DMA_COMMON_ERRINT1_ERR37_MASK            (0x20U)
#define DMA_COMMON_ERRINT1_ERR37_SHIFT           (5U)
/*! ERR37 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT1_ERR37(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT1_ERR37_SHIFT)) & DMA_COMMON_ERRINT1_ERR37_MASK)

#define DMA_COMMON_ERRINT1_ERR38_MASK            (0x40U)
#define DMA_COMMON_ERRINT1_ERR38_SHIFT           (6U)
/*! ERR38 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT1_ERR38(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT1_ERR38_SHIFT)) & DMA_COMMON_ERRINT1_ERR38_MASK)

#define DMA_COMMON_ERRINT1_ERR39_MASK            (0x80U)
#define DMA_COMMON_ERRINT1_ERR39_SHIFT           (7U)
/*! ERR39 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT1_ERR39(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT1_ERR39_SHIFT)) & DMA_COMMON_ERRINT1_ERR39_MASK)

#define DMA_COMMON_ERRINT1_ERR40_MASK            (0x100U)
#define DMA_COMMON_ERRINT1_ERR40_SHIFT           (8U)
/*! ERR40 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT1_ERR40(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT1_ERR40_SHIFT)) & DMA_COMMON_ERRINT1_ERR40_MASK)

#define DMA_COMMON_ERRINT1_ERR41_MASK            (0x200U)
#define DMA_COMMON_ERRINT1_ERR41_SHIFT           (9U)
/*! ERR41 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT1_ERR41(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT1_ERR41_SHIFT)) & DMA_COMMON_ERRINT1_ERR41_MASK)

#define DMA_COMMON_ERRINT1_ERR42_MASK            (0x400U)
#define DMA_COMMON_ERRINT1_ERR42_SHIFT           (10U)
/*! ERR42 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT1_ERR42(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT1_ERR42_SHIFT)) & DMA_COMMON_ERRINT1_ERR42_MASK)

#define DMA_COMMON_ERRINT1_ERR43_MASK            (0x800U)
#define DMA_COMMON_ERRINT1_ERR43_SHIFT           (11U)
/*! ERR43 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT1_ERR43(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT1_ERR43_SHIFT)) & DMA_COMMON_ERRINT1_ERR43_MASK)

#define DMA_COMMON_ERRINT1_ERR44_MASK            (0x1000U)
#define DMA_COMMON_ERRINT1_ERR44_SHIFT           (12U)
/*! ERR44 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT1_ERR44(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT1_ERR44_SHIFT)) & DMA_COMMON_ERRINT1_ERR44_MASK)

#define DMA_COMMON_ERRINT1_ERR45_MASK            (0x2000U)
#define DMA_COMMON_ERRINT1_ERR45_SHIFT           (13U)
/*! ERR45 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT1_ERR45(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT1_ERR45_SHIFT)) & DMA_COMMON_ERRINT1_ERR45_MASK)

#define DMA_COMMON_ERRINT1_ERR46_MASK            (0x4000U)
#define DMA_COMMON_ERRINT1_ERR46_SHIFT           (14U)
/*! ERR46 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT1_ERR46(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT1_ERR46_SHIFT)) & DMA_COMMON_ERRINT1_ERR46_MASK)

#define DMA_COMMON_ERRINT1_ERR47_MASK            (0x8000U)
#define DMA_COMMON_ERRINT1_ERR47_SHIFT           (15U)
/*! ERR47 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT1_ERR47(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT1_ERR47_SHIFT)) & DMA_COMMON_ERRINT1_ERR47_MASK)

#define DMA_COMMON_ERRINT1_ERR48_MASK            (0x10000U)
#define DMA_COMMON_ERRINT1_ERR48_SHIFT           (16U)
/*! ERR48 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT1_ERR48(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT1_ERR48_SHIFT)) & DMA_COMMON_ERRINT1_ERR48_MASK)

#define DMA_COMMON_ERRINT1_ERR49_MASK            (0x20000U)
#define DMA_COMMON_ERRINT1_ERR49_SHIFT           (17U)
/*! ERR49 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT1_ERR49(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT1_ERR49_SHIFT)) & DMA_COMMON_ERRINT1_ERR49_MASK)

#define DMA_COMMON_ERRINT1_ERR50_MASK            (0x40000U)
#define DMA_COMMON_ERRINT1_ERR50_SHIFT           (18U)
/*! ERR50 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT1_ERR50(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT1_ERR50_SHIFT)) & DMA_COMMON_ERRINT1_ERR50_MASK)

#define DMA_COMMON_ERRINT1_ERR51_MASK            (0x80000U)
#define DMA_COMMON_ERRINT1_ERR51_SHIFT           (19U)
/*! ERR51 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT1_ERR51(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT1_ERR51_SHIFT)) & DMA_COMMON_ERRINT1_ERR51_MASK)
/*! @} */

/* The count of DMA_COMMON_ERRINT1 */
#define DMA_COMMON_ERRINT1_COUNT                 (1U)

/*! @name COMMON_INTENSET - Interrupt Enable read and Set for all DMA channels */
/*! @{ */

#define DMA_COMMON_INTENSET_INTEN0_MASK          (0x1U)
#define DMA_COMMON_INTENSET_INTEN0_SHIFT         (0U)
/*! INTEN0 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN0(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN0_SHIFT)) & DMA_COMMON_INTENSET_INTEN0_MASK)

#define DMA_COMMON_INTENSET_INTEN1_MASK          (0x2U)
#define DMA_COMMON_INTENSET_INTEN1_SHIFT         (1U)
/*! INTEN1 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN1(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN1_SHIFT)) & DMA_COMMON_INTENSET_INTEN1_MASK)

#define DMA_COMMON_INTENSET_INTEN2_MASK          (0x4U)
#define DMA_COMMON_INTENSET_INTEN2_SHIFT         (2U)
/*! INTEN2 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN2(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN2_SHIFT)) & DMA_COMMON_INTENSET_INTEN2_MASK)

#define DMA_COMMON_INTENSET_INTEN3_MASK          (0x8U)
#define DMA_COMMON_INTENSET_INTEN3_SHIFT         (3U)
/*! INTEN3 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN3(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN3_SHIFT)) & DMA_COMMON_INTENSET_INTEN3_MASK)

#define DMA_COMMON_INTENSET_INTEN4_MASK          (0x10U)
#define DMA_COMMON_INTENSET_INTEN4_SHIFT         (4U)
/*! INTEN4 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN4(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN4_SHIFT)) & DMA_COMMON_INTENSET_INTEN4_MASK)

#define DMA_COMMON_INTENSET_INTEN5_MASK          (0x20U)
#define DMA_COMMON_INTENSET_INTEN5_SHIFT         (5U)
/*! INTEN5 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN5(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN5_SHIFT)) & DMA_COMMON_INTENSET_INTEN5_MASK)

#define DMA_COMMON_INTENSET_INTEN6_MASK          (0x40U)
#define DMA_COMMON_INTENSET_INTEN6_SHIFT         (6U)
/*! INTEN6 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN6(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN6_SHIFT)) & DMA_COMMON_INTENSET_INTEN6_MASK)

#define DMA_COMMON_INTENSET_INTEN7_MASK          (0x80U)
#define DMA_COMMON_INTENSET_INTEN7_SHIFT         (7U)
/*! INTEN7 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN7(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN7_SHIFT)) & DMA_COMMON_INTENSET_INTEN7_MASK)

#define DMA_COMMON_INTENSET_INTEN8_MASK          (0x100U)
#define DMA_COMMON_INTENSET_INTEN8_SHIFT         (8U)
/*! INTEN8 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN8(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN8_SHIFT)) & DMA_COMMON_INTENSET_INTEN8_MASK)

#define DMA_COMMON_INTENSET_INTEN9_MASK          (0x200U)
#define DMA_COMMON_INTENSET_INTEN9_SHIFT         (9U)
/*! INTEN9 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN9(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN9_SHIFT)) & DMA_COMMON_INTENSET_INTEN9_MASK)

#define DMA_COMMON_INTENSET_INTEN10_MASK         (0x400U)
#define DMA_COMMON_INTENSET_INTEN10_SHIFT        (10U)
/*! INTEN10 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN10(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN10_SHIFT)) & DMA_COMMON_INTENSET_INTEN10_MASK)

#define DMA_COMMON_INTENSET_INTEN11_MASK         (0x800U)
#define DMA_COMMON_INTENSET_INTEN11_SHIFT        (11U)
/*! INTEN11 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN11(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN11_SHIFT)) & DMA_COMMON_INTENSET_INTEN11_MASK)

#define DMA_COMMON_INTENSET_INTEN12_MASK         (0x1000U)
#define DMA_COMMON_INTENSET_INTEN12_SHIFT        (12U)
/*! INTEN12 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN12(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN12_SHIFT)) & DMA_COMMON_INTENSET_INTEN12_MASK)

#define DMA_COMMON_INTENSET_INTEN13_MASK         (0x2000U)
#define DMA_COMMON_INTENSET_INTEN13_SHIFT        (13U)
/*! INTEN13 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN13(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN13_SHIFT)) & DMA_COMMON_INTENSET_INTEN13_MASK)

#define DMA_COMMON_INTENSET_INTEN14_MASK         (0x4000U)
#define DMA_COMMON_INTENSET_INTEN14_SHIFT        (14U)
/*! INTEN14 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN14(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN14_SHIFT)) & DMA_COMMON_INTENSET_INTEN14_MASK)

#define DMA_COMMON_INTENSET_INTEN15_MASK         (0x8000U)
#define DMA_COMMON_INTENSET_INTEN15_SHIFT        (15U)
/*! INTEN15 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN15(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN15_SHIFT)) & DMA_COMMON_INTENSET_INTEN15_MASK)

#define DMA_COMMON_INTENSET_INTEN16_MASK         (0x10000U)
#define DMA_COMMON_INTENSET_INTEN16_SHIFT        (16U)
/*! INTEN16 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN16(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN16_SHIFT)) & DMA_COMMON_INTENSET_INTEN16_MASK)

#define DMA_COMMON_INTENSET_INTEN17_MASK         (0x20000U)
#define DMA_COMMON_INTENSET_INTEN17_SHIFT        (17U)
/*! INTEN17 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN17(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN17_SHIFT)) & DMA_COMMON_INTENSET_INTEN17_MASK)

#define DMA_COMMON_INTENSET_INTEN18_MASK         (0x40000U)
#define DMA_COMMON_INTENSET_INTEN18_SHIFT        (18U)
/*! INTEN18 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN18(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN18_SHIFT)) & DMA_COMMON_INTENSET_INTEN18_MASK)

#define DMA_COMMON_INTENSET_INTEN19_MASK         (0x80000U)
#define DMA_COMMON_INTENSET_INTEN19_SHIFT        (19U)
/*! INTEN19 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN19(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN19_SHIFT)) & DMA_COMMON_INTENSET_INTEN19_MASK)

#define DMA_COMMON_INTENSET_INTEN20_MASK         (0x100000U)
#define DMA_COMMON_INTENSET_INTEN20_SHIFT        (20U)
/*! INTEN20 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN20(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN20_SHIFT)) & DMA_COMMON_INTENSET_INTEN20_MASK)

#define DMA_COMMON_INTENSET_INTEN21_MASK         (0x200000U)
#define DMA_COMMON_INTENSET_INTEN21_SHIFT        (21U)
/*! INTEN21 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN21(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN21_SHIFT)) & DMA_COMMON_INTENSET_INTEN21_MASK)

#define DMA_COMMON_INTENSET_INTEN22_MASK         (0x400000U)
#define DMA_COMMON_INTENSET_INTEN22_SHIFT        (22U)
/*! INTEN22 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN22(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN22_SHIFT)) & DMA_COMMON_INTENSET_INTEN22_MASK)

#define DMA_COMMON_INTENSET_INTEN23_MASK         (0x800000U)
#define DMA_COMMON_INTENSET_INTEN23_SHIFT        (23U)
/*! INTEN23 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN23(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN23_SHIFT)) & DMA_COMMON_INTENSET_INTEN23_MASK)

#define DMA_COMMON_INTENSET_INTEN24_MASK         (0x1000000U)
#define DMA_COMMON_INTENSET_INTEN24_SHIFT        (24U)
/*! INTEN24 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN24(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN24_SHIFT)) & DMA_COMMON_INTENSET_INTEN24_MASK)

#define DMA_COMMON_INTENSET_INTEN25_MASK         (0x2000000U)
#define DMA_COMMON_INTENSET_INTEN25_SHIFT        (25U)
/*! INTEN25 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN25(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN25_SHIFT)) & DMA_COMMON_INTENSET_INTEN25_MASK)

#define DMA_COMMON_INTENSET_INTEN26_MASK         (0x4000000U)
#define DMA_COMMON_INTENSET_INTEN26_SHIFT        (26U)
/*! INTEN26 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN26(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN26_SHIFT)) & DMA_COMMON_INTENSET_INTEN26_MASK)

#define DMA_COMMON_INTENSET_INTEN27_MASK         (0x8000000U)
#define DMA_COMMON_INTENSET_INTEN27_SHIFT        (27U)
/*! INTEN27 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN27(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN27_SHIFT)) & DMA_COMMON_INTENSET_INTEN27_MASK)

#define DMA_COMMON_INTENSET_INTEN28_MASK         (0x10000000U)
#define DMA_COMMON_INTENSET_INTEN28_SHIFT        (28U)
/*! INTEN28 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN28(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN28_SHIFT)) & DMA_COMMON_INTENSET_INTEN28_MASK)

#define DMA_COMMON_INTENSET_INTEN29_MASK         (0x20000000U)
#define DMA_COMMON_INTENSET_INTEN29_SHIFT        (29U)
/*! INTEN29 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN29(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN29_SHIFT)) & DMA_COMMON_INTENSET_INTEN29_MASK)

#define DMA_COMMON_INTENSET_INTEN30_MASK         (0x40000000U)
#define DMA_COMMON_INTENSET_INTEN30_SHIFT        (30U)
/*! INTEN30 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN30(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN30_SHIFT)) & DMA_COMMON_INTENSET_INTEN30_MASK)

#define DMA_COMMON_INTENSET_INTEN31_MASK         (0x80000000U)
#define DMA_COMMON_INTENSET_INTEN31_SHIFT        (31U)
/*! INTEN31 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN31(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN31_SHIFT)) & DMA_COMMON_INTENSET_INTEN31_MASK)
/*! @} */

/* The count of DMA_COMMON_INTENSET */
#define DMA_COMMON_INTENSET_COUNT                (1U)

/*! @name COMMON_INTENSET1 - Interrupt Enable read and Set for all DMA channels */
/*! @{ */

#define DMA_COMMON_INTENSET1_INTEN32_MASK        (0x1U)
#define DMA_COMMON_INTENSET1_INTEN32_SHIFT       (0U)
/*! INTEN32 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET1_INTEN32(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET1_INTEN32_SHIFT)) & DMA_COMMON_INTENSET1_INTEN32_MASK)

#define DMA_COMMON_INTENSET1_INTEN33_MASK        (0x2U)
#define DMA_COMMON_INTENSET1_INTEN33_SHIFT       (1U)
/*! INTEN33 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET1_INTEN33(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET1_INTEN33_SHIFT)) & DMA_COMMON_INTENSET1_INTEN33_MASK)

#define DMA_COMMON_INTENSET1_INTEN34_MASK        (0x4U)
#define DMA_COMMON_INTENSET1_INTEN34_SHIFT       (2U)
/*! INTEN34 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET1_INTEN34(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET1_INTEN34_SHIFT)) & DMA_COMMON_INTENSET1_INTEN34_MASK)

#define DMA_COMMON_INTENSET1_INTEN35_MASK        (0x8U)
#define DMA_COMMON_INTENSET1_INTEN35_SHIFT       (3U)
/*! INTEN35 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET1_INTEN35(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET1_INTEN35_SHIFT)) & DMA_COMMON_INTENSET1_INTEN35_MASK)

#define DMA_COMMON_INTENSET1_INTEN36_MASK        (0x10U)
#define DMA_COMMON_INTENSET1_INTEN36_SHIFT       (4U)
/*! INTEN36 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET1_INTEN36(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET1_INTEN36_SHIFT)) & DMA_COMMON_INTENSET1_INTEN36_MASK)

#define DMA_COMMON_INTENSET1_INTEN37_MASK        (0x20U)
#define DMA_COMMON_INTENSET1_INTEN37_SHIFT       (5U)
/*! INTEN37 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET1_INTEN37(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET1_INTEN37_SHIFT)) & DMA_COMMON_INTENSET1_INTEN37_MASK)

#define DMA_COMMON_INTENSET1_INTEN38_MASK        (0x40U)
#define DMA_COMMON_INTENSET1_INTEN38_SHIFT       (6U)
/*! INTEN38 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET1_INTEN38(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET1_INTEN38_SHIFT)) & DMA_COMMON_INTENSET1_INTEN38_MASK)

#define DMA_COMMON_INTENSET1_INTEN39_MASK        (0x80U)
#define DMA_COMMON_INTENSET1_INTEN39_SHIFT       (7U)
/*! INTEN39 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET1_INTEN39(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET1_INTEN39_SHIFT)) & DMA_COMMON_INTENSET1_INTEN39_MASK)

#define DMA_COMMON_INTENSET1_INTEN40_MASK        (0x100U)
#define DMA_COMMON_INTENSET1_INTEN40_SHIFT       (8U)
/*! INTEN40 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET1_INTEN40(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET1_INTEN40_SHIFT)) & DMA_COMMON_INTENSET1_INTEN40_MASK)

#define DMA_COMMON_INTENSET1_INTEN41_MASK        (0x200U)
#define DMA_COMMON_INTENSET1_INTEN41_SHIFT       (9U)
/*! INTEN41 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET1_INTEN41(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET1_INTEN41_SHIFT)) & DMA_COMMON_INTENSET1_INTEN41_MASK)

#define DMA_COMMON_INTENSET1_INTEN42_MASK        (0x400U)
#define DMA_COMMON_INTENSET1_INTEN42_SHIFT       (10U)
/*! INTEN42 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET1_INTEN42(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET1_INTEN42_SHIFT)) & DMA_COMMON_INTENSET1_INTEN42_MASK)

#define DMA_COMMON_INTENSET1_INTEN43_MASK        (0x800U)
#define DMA_COMMON_INTENSET1_INTEN43_SHIFT       (11U)
/*! INTEN43 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET1_INTEN43(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET1_INTEN43_SHIFT)) & DMA_COMMON_INTENSET1_INTEN43_MASK)

#define DMA_COMMON_INTENSET1_INTEN44_MASK        (0x1000U)
#define DMA_COMMON_INTENSET1_INTEN44_SHIFT       (12U)
/*! INTEN44 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET1_INTEN44(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET1_INTEN44_SHIFT)) & DMA_COMMON_INTENSET1_INTEN44_MASK)

#define DMA_COMMON_INTENSET1_INTEN45_MASK        (0x2000U)
#define DMA_COMMON_INTENSET1_INTEN45_SHIFT       (13U)
/*! INTEN45 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET1_INTEN45(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET1_INTEN45_SHIFT)) & DMA_COMMON_INTENSET1_INTEN45_MASK)

#define DMA_COMMON_INTENSET1_INTEN46_MASK        (0x4000U)
#define DMA_COMMON_INTENSET1_INTEN46_SHIFT       (14U)
/*! INTEN46 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET1_INTEN46(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET1_INTEN46_SHIFT)) & DMA_COMMON_INTENSET1_INTEN46_MASK)

#define DMA_COMMON_INTENSET1_INTEN47_MASK        (0x8000U)
#define DMA_COMMON_INTENSET1_INTEN47_SHIFT       (15U)
/*! INTEN47 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET1_INTEN47(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET1_INTEN47_SHIFT)) & DMA_COMMON_INTENSET1_INTEN47_MASK)

#define DMA_COMMON_INTENSET1_INTEN48_MASK        (0x10000U)
#define DMA_COMMON_INTENSET1_INTEN48_SHIFT       (16U)
/*! INTEN48 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET1_INTEN48(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET1_INTEN48_SHIFT)) & DMA_COMMON_INTENSET1_INTEN48_MASK)

#define DMA_COMMON_INTENSET1_INTEN49_MASK        (0x20000U)
#define DMA_COMMON_INTENSET1_INTEN49_SHIFT       (17U)
/*! INTEN49 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET1_INTEN49(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET1_INTEN49_SHIFT)) & DMA_COMMON_INTENSET1_INTEN49_MASK)

#define DMA_COMMON_INTENSET1_INTEN50_MASK        (0x40000U)
#define DMA_COMMON_INTENSET1_INTEN50_SHIFT       (18U)
/*! INTEN50 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET1_INTEN50(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET1_INTEN50_SHIFT)) & DMA_COMMON_INTENSET1_INTEN50_MASK)

#define DMA_COMMON_INTENSET1_INTEN51_MASK        (0x80000U)
#define DMA_COMMON_INTENSET1_INTEN51_SHIFT       (19U)
/*! INTEN51 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET1_INTEN51(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET1_INTEN51_SHIFT)) & DMA_COMMON_INTENSET1_INTEN51_MASK)
/*! @} */

/* The count of DMA_COMMON_INTENSET1 */
#define DMA_COMMON_INTENSET1_COUNT               (1U)

/*! @name COMMON_INTENCLR - Interrupt Enable Clear for all DMA channels */
/*! @{ */

#define DMA_COMMON_INTENCLR_CLR0_MASK            (0x1U)
#define DMA_COMMON_INTENCLR_CLR0_SHIFT           (0U)
/*! CLR0 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR0(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR0_SHIFT)) & DMA_COMMON_INTENCLR_CLR0_MASK)

#define DMA_COMMON_INTENCLR_CLR1_MASK            (0x2U)
#define DMA_COMMON_INTENCLR_CLR1_SHIFT           (1U)
/*! CLR1 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR1(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR1_SHIFT)) & DMA_COMMON_INTENCLR_CLR1_MASK)

#define DMA_COMMON_INTENCLR_CLR2_MASK            (0x4U)
#define DMA_COMMON_INTENCLR_CLR2_SHIFT           (2U)
/*! CLR2 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR2(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR2_SHIFT)) & DMA_COMMON_INTENCLR_CLR2_MASK)

#define DMA_COMMON_INTENCLR_CLR3_MASK            (0x8U)
#define DMA_COMMON_INTENCLR_CLR3_SHIFT           (3U)
/*! CLR3 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR3(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR3_SHIFT)) & DMA_COMMON_INTENCLR_CLR3_MASK)

#define DMA_COMMON_INTENCLR_CLR4_MASK            (0x10U)
#define DMA_COMMON_INTENCLR_CLR4_SHIFT           (4U)
/*! CLR4 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR4(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR4_SHIFT)) & DMA_COMMON_INTENCLR_CLR4_MASK)

#define DMA_COMMON_INTENCLR_CLR5_MASK            (0x20U)
#define DMA_COMMON_INTENCLR_CLR5_SHIFT           (5U)
/*! CLR5 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR5(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR5_SHIFT)) & DMA_COMMON_INTENCLR_CLR5_MASK)

#define DMA_COMMON_INTENCLR_CLR6_MASK            (0x40U)
#define DMA_COMMON_INTENCLR_CLR6_SHIFT           (6U)
/*! CLR6 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR6(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR6_SHIFT)) & DMA_COMMON_INTENCLR_CLR6_MASK)

#define DMA_COMMON_INTENCLR_CLR7_MASK            (0x80U)
#define DMA_COMMON_INTENCLR_CLR7_SHIFT           (7U)
/*! CLR7 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR7(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR7_SHIFT)) & DMA_COMMON_INTENCLR_CLR7_MASK)

#define DMA_COMMON_INTENCLR_CLR8_MASK            (0x100U)
#define DMA_COMMON_INTENCLR_CLR8_SHIFT           (8U)
/*! CLR8 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR8(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR8_SHIFT)) & DMA_COMMON_INTENCLR_CLR8_MASK)

#define DMA_COMMON_INTENCLR_CLR9_MASK            (0x200U)
#define DMA_COMMON_INTENCLR_CLR9_SHIFT           (9U)
/*! CLR9 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR9(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR9_SHIFT)) & DMA_COMMON_INTENCLR_CLR9_MASK)

#define DMA_COMMON_INTENCLR_CLR10_MASK           (0x400U)
#define DMA_COMMON_INTENCLR_CLR10_SHIFT          (10U)
/*! CLR10 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR10(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR10_SHIFT)) & DMA_COMMON_INTENCLR_CLR10_MASK)

#define DMA_COMMON_INTENCLR_CLR11_MASK           (0x800U)
#define DMA_COMMON_INTENCLR_CLR11_SHIFT          (11U)
/*! CLR11 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR11(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR11_SHIFT)) & DMA_COMMON_INTENCLR_CLR11_MASK)

#define DMA_COMMON_INTENCLR_CLR12_MASK           (0x1000U)
#define DMA_COMMON_INTENCLR_CLR12_SHIFT          (12U)
/*! CLR12 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR12(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR12_SHIFT)) & DMA_COMMON_INTENCLR_CLR12_MASK)

#define DMA_COMMON_INTENCLR_CLR13_MASK           (0x2000U)
#define DMA_COMMON_INTENCLR_CLR13_SHIFT          (13U)
/*! CLR13 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR13(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR13_SHIFT)) & DMA_COMMON_INTENCLR_CLR13_MASK)

#define DMA_COMMON_INTENCLR_CLR14_MASK           (0x4000U)
#define DMA_COMMON_INTENCLR_CLR14_SHIFT          (14U)
/*! CLR14 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR14(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR14_SHIFT)) & DMA_COMMON_INTENCLR_CLR14_MASK)

#define DMA_COMMON_INTENCLR_CLR15_MASK           (0x8000U)
#define DMA_COMMON_INTENCLR_CLR15_SHIFT          (15U)
/*! CLR15 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR15(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR15_SHIFT)) & DMA_COMMON_INTENCLR_CLR15_MASK)

#define DMA_COMMON_INTENCLR_CLR16_MASK           (0x10000U)
#define DMA_COMMON_INTENCLR_CLR16_SHIFT          (16U)
/*! CLR16 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR16(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR16_SHIFT)) & DMA_COMMON_INTENCLR_CLR16_MASK)

#define DMA_COMMON_INTENCLR_CLR17_MASK           (0x20000U)
#define DMA_COMMON_INTENCLR_CLR17_SHIFT          (17U)
/*! CLR17 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR17(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR17_SHIFT)) & DMA_COMMON_INTENCLR_CLR17_MASK)

#define DMA_COMMON_INTENCLR_CLR18_MASK           (0x40000U)
#define DMA_COMMON_INTENCLR_CLR18_SHIFT          (18U)
/*! CLR18 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR18(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR18_SHIFT)) & DMA_COMMON_INTENCLR_CLR18_MASK)

#define DMA_COMMON_INTENCLR_CLR19_MASK           (0x80000U)
#define DMA_COMMON_INTENCLR_CLR19_SHIFT          (19U)
/*! CLR19 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR19(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR19_SHIFT)) & DMA_COMMON_INTENCLR_CLR19_MASK)

#define DMA_COMMON_INTENCLR_CLR20_MASK           (0x100000U)
#define DMA_COMMON_INTENCLR_CLR20_SHIFT          (20U)
/*! CLR20 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR20(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR20_SHIFT)) & DMA_COMMON_INTENCLR_CLR20_MASK)

#define DMA_COMMON_INTENCLR_CLR21_MASK           (0x200000U)
#define DMA_COMMON_INTENCLR_CLR21_SHIFT          (21U)
/*! CLR21 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR21(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR21_SHIFT)) & DMA_COMMON_INTENCLR_CLR21_MASK)

#define DMA_COMMON_INTENCLR_CLR22_MASK           (0x400000U)
#define DMA_COMMON_INTENCLR_CLR22_SHIFT          (22U)
/*! CLR22 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR22(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR22_SHIFT)) & DMA_COMMON_INTENCLR_CLR22_MASK)

#define DMA_COMMON_INTENCLR_CLR23_MASK           (0x800000U)
#define DMA_COMMON_INTENCLR_CLR23_SHIFT          (23U)
/*! CLR23 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR23(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR23_SHIFT)) & DMA_COMMON_INTENCLR_CLR23_MASK)

#define DMA_COMMON_INTENCLR_CLR24_MASK           (0x1000000U)
#define DMA_COMMON_INTENCLR_CLR24_SHIFT          (24U)
/*! CLR24 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR24(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR24_SHIFT)) & DMA_COMMON_INTENCLR_CLR24_MASK)

#define DMA_COMMON_INTENCLR_CLR25_MASK           (0x2000000U)
#define DMA_COMMON_INTENCLR_CLR25_SHIFT          (25U)
/*! CLR25 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR25(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR25_SHIFT)) & DMA_COMMON_INTENCLR_CLR25_MASK)

#define DMA_COMMON_INTENCLR_CLR26_MASK           (0x4000000U)
#define DMA_COMMON_INTENCLR_CLR26_SHIFT          (26U)
/*! CLR26 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR26(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR26_SHIFT)) & DMA_COMMON_INTENCLR_CLR26_MASK)

#define DMA_COMMON_INTENCLR_CLR27_MASK           (0x8000000U)
#define DMA_COMMON_INTENCLR_CLR27_SHIFT          (27U)
/*! CLR27 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR27(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR27_SHIFT)) & DMA_COMMON_INTENCLR_CLR27_MASK)

#define DMA_COMMON_INTENCLR_CLR28_MASK           (0x10000000U)
#define DMA_COMMON_INTENCLR_CLR28_SHIFT          (28U)
/*! CLR28 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR28(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR28_SHIFT)) & DMA_COMMON_INTENCLR_CLR28_MASK)

#define DMA_COMMON_INTENCLR_CLR29_MASK           (0x20000000U)
#define DMA_COMMON_INTENCLR_CLR29_SHIFT          (29U)
/*! CLR29 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR29(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR29_SHIFT)) & DMA_COMMON_INTENCLR_CLR29_MASK)

#define DMA_COMMON_INTENCLR_CLR30_MASK           (0x40000000U)
#define DMA_COMMON_INTENCLR_CLR30_SHIFT          (30U)
/*! CLR30 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR30(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR30_SHIFT)) & DMA_COMMON_INTENCLR_CLR30_MASK)

#define DMA_COMMON_INTENCLR_CLR31_MASK           (0x80000000U)
#define DMA_COMMON_INTENCLR_CLR31_SHIFT          (31U)
/*! CLR31 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR31(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR31_SHIFT)) & DMA_COMMON_INTENCLR_CLR31_MASK)
/*! @} */

/* The count of DMA_COMMON_INTENCLR */
#define DMA_COMMON_INTENCLR_COUNT                (1U)

/*! @name COMMON_INTENCLR1 - Interrupt Enable Clear for all DMA channels */
/*! @{ */

#define DMA_COMMON_INTENCLR1_CLR32_MASK          (0x1U)
#define DMA_COMMON_INTENCLR1_CLR32_SHIFT         (0U)
/*! CLR32 - Writing ones to this register clears corresponding bits in the DMAIntEnSet1.
 */
#define DMA_COMMON_INTENCLR1_CLR32(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR1_CLR32_SHIFT)) & DMA_COMMON_INTENCLR1_CLR32_MASK)

#define DMA_COMMON_INTENCLR1_CLR33_MASK          (0x2U)
#define DMA_COMMON_INTENCLR1_CLR33_SHIFT         (1U)
/*! CLR33 - Writing ones to this register clears corresponding bits in the DMAIntEnSet1.
 */
#define DMA_COMMON_INTENCLR1_CLR33(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR1_CLR33_SHIFT)) & DMA_COMMON_INTENCLR1_CLR33_MASK)

#define DMA_COMMON_INTENCLR1_CLR34_MASK          (0x4U)
#define DMA_COMMON_INTENCLR1_CLR34_SHIFT         (2U)
/*! CLR34 - Writing ones to this register clears corresponding bits in the DMAIntEnSet1.
 */
#define DMA_COMMON_INTENCLR1_CLR34(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR1_CLR34_SHIFT)) & DMA_COMMON_INTENCLR1_CLR34_MASK)

#define DMA_COMMON_INTENCLR1_CLR35_MASK          (0x8U)
#define DMA_COMMON_INTENCLR1_CLR35_SHIFT         (3U)
/*! CLR35 - Writing ones to this register clears corresponding bits in the DMAIntEnSet1.
 */
#define DMA_COMMON_INTENCLR1_CLR35(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR1_CLR35_SHIFT)) & DMA_COMMON_INTENCLR1_CLR35_MASK)

#define DMA_COMMON_INTENCLR1_CLR36_MASK          (0x10U)
#define DMA_COMMON_INTENCLR1_CLR36_SHIFT         (4U)
/*! CLR36 - Writing ones to this register clears corresponding bits in the DMAIntEnSet1.
 */
#define DMA_COMMON_INTENCLR1_CLR36(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR1_CLR36_SHIFT)) & DMA_COMMON_INTENCLR1_CLR36_MASK)

#define DMA_COMMON_INTENCLR1_CLR37_MASK          (0x20U)
#define DMA_COMMON_INTENCLR1_CLR37_SHIFT         (5U)
/*! CLR37 - Writing ones to this register clears corresponding bits in the DMAIntEnSet1.
 */
#define DMA_COMMON_INTENCLR1_CLR37(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR1_CLR37_SHIFT)) & DMA_COMMON_INTENCLR1_CLR37_MASK)

#define DMA_COMMON_INTENCLR1_CLR38_MASK          (0x40U)
#define DMA_COMMON_INTENCLR1_CLR38_SHIFT         (6U)
/*! CLR38 - Writing ones to this register clears corresponding bits in the DMAIntEnSet1.
 */
#define DMA_COMMON_INTENCLR1_CLR38(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR1_CLR38_SHIFT)) & DMA_COMMON_INTENCLR1_CLR38_MASK)

#define DMA_COMMON_INTENCLR1_CLR39_MASK          (0x80U)
#define DMA_COMMON_INTENCLR1_CLR39_SHIFT         (7U)
/*! CLR39 - Writing ones to this register clears corresponding bits in the DMAIntEnSet1.
 */
#define DMA_COMMON_INTENCLR1_CLR39(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR1_CLR39_SHIFT)) & DMA_COMMON_INTENCLR1_CLR39_MASK)

#define DMA_COMMON_INTENCLR1_CLR40_MASK          (0x100U)
#define DMA_COMMON_INTENCLR1_CLR40_SHIFT         (8U)
/*! CLR40 - Writing ones to this register clears corresponding bits in the DMAIntEnSet1.
 */
#define DMA_COMMON_INTENCLR1_CLR40(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR1_CLR40_SHIFT)) & DMA_COMMON_INTENCLR1_CLR40_MASK)

#define DMA_COMMON_INTENCLR1_CLR41_MASK          (0x200U)
#define DMA_COMMON_INTENCLR1_CLR41_SHIFT         (9U)
/*! CLR41 - Writing ones to this register clears corresponding bits in the DMAIntEnSet1.
 */
#define DMA_COMMON_INTENCLR1_CLR41(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR1_CLR41_SHIFT)) & DMA_COMMON_INTENCLR1_CLR41_MASK)

#define DMA_COMMON_INTENCLR1_CLR42_MASK          (0x400U)
#define DMA_COMMON_INTENCLR1_CLR42_SHIFT         (10U)
/*! CLR42 - Writing ones to this register clears corresponding bits in the DMAIntEnSet1.
 */
#define DMA_COMMON_INTENCLR1_CLR42(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR1_CLR42_SHIFT)) & DMA_COMMON_INTENCLR1_CLR42_MASK)

#define DMA_COMMON_INTENCLR1_CLR43_MASK          (0x800U)
#define DMA_COMMON_INTENCLR1_CLR43_SHIFT         (11U)
/*! CLR43 - Writing ones to this register clears corresponding bits in the DMAIntEnSet1.
 */
#define DMA_COMMON_INTENCLR1_CLR43(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR1_CLR43_SHIFT)) & DMA_COMMON_INTENCLR1_CLR43_MASK)

#define DMA_COMMON_INTENCLR1_CLR44_MASK          (0x1000U)
#define DMA_COMMON_INTENCLR1_CLR44_SHIFT         (12U)
/*! CLR44 - Writing ones to this register clears corresponding bits in the DMAIntEnSet1.
 */
#define DMA_COMMON_INTENCLR1_CLR44(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR1_CLR44_SHIFT)) & DMA_COMMON_INTENCLR1_CLR44_MASK)

#define DMA_COMMON_INTENCLR1_CLR45_MASK          (0x2000U)
#define DMA_COMMON_INTENCLR1_CLR45_SHIFT         (13U)
/*! CLR45 - Writing ones to this register clears corresponding bits in the DMAIntEnSet1.
 */
#define DMA_COMMON_INTENCLR1_CLR45(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR1_CLR45_SHIFT)) & DMA_COMMON_INTENCLR1_CLR45_MASK)

#define DMA_COMMON_INTENCLR1_CLR46_MASK          (0x4000U)
#define DMA_COMMON_INTENCLR1_CLR46_SHIFT         (14U)
/*! CLR46 - Writing ones to this register clears corresponding bits in the DMAIntEnSet1.
 */
#define DMA_COMMON_INTENCLR1_CLR46(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR1_CLR46_SHIFT)) & DMA_COMMON_INTENCLR1_CLR46_MASK)

#define DMA_COMMON_INTENCLR1_CLR47_MASK          (0x8000U)
#define DMA_COMMON_INTENCLR1_CLR47_SHIFT         (15U)
/*! CLR47 - Writing ones to this register clears corresponding bits in the DMAIntEnSet1.
 */
#define DMA_COMMON_INTENCLR1_CLR47(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR1_CLR47_SHIFT)) & DMA_COMMON_INTENCLR1_CLR47_MASK)

#define DMA_COMMON_INTENCLR1_CLR48_MASK          (0x10000U)
#define DMA_COMMON_INTENCLR1_CLR48_SHIFT         (16U)
/*! CLR48 - Writing ones to this register clears corresponding bits in the DMAIntEnSet1.
 */
#define DMA_COMMON_INTENCLR1_CLR48(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR1_CLR48_SHIFT)) & DMA_COMMON_INTENCLR1_CLR48_MASK)

#define DMA_COMMON_INTENCLR1_CLR49_MASK          (0x20000U)
#define DMA_COMMON_INTENCLR1_CLR49_SHIFT         (17U)
/*! CLR49 - Writing ones to this register clears corresponding bits in the DMAIntEnSet1.
 */
#define DMA_COMMON_INTENCLR1_CLR49(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR1_CLR49_SHIFT)) & DMA_COMMON_INTENCLR1_CLR49_MASK)

#define DMA_COMMON_INTENCLR1_CLR50_MASK          (0x40000U)
#define DMA_COMMON_INTENCLR1_CLR50_SHIFT         (18U)
/*! CLR50 - Writing ones to this register clears corresponding bits in the DMAIntEnSet1.
 */
#define DMA_COMMON_INTENCLR1_CLR50(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR1_CLR50_SHIFT)) & DMA_COMMON_INTENCLR1_CLR50_MASK)

#define DMA_COMMON_INTENCLR1_CLR51_MASK          (0x80000U)
#define DMA_COMMON_INTENCLR1_CLR51_SHIFT         (19U)
/*! CLR51 - Writing ones to this register clears corresponding bits in the DMAIntEnSet1.
 */
#define DMA_COMMON_INTENCLR1_CLR51(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR1_CLR51_SHIFT)) & DMA_COMMON_INTENCLR1_CLR51_MASK)
/*! @} */

/* The count of DMA_COMMON_INTENCLR1 */
#define DMA_COMMON_INTENCLR1_COUNT               (1U)

/*! @name COMMON_INTA - Interrupt A status for all DMA channels */
/*! @{ */

#define DMA_COMMON_INTA_INTA0_MASK               (0x1U)
#define DMA_COMMON_INTA_INTA0_SHIFT              (0U)
/*! INTA0 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA0(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA0_SHIFT)) & DMA_COMMON_INTA_INTA0_MASK)

#define DMA_COMMON_INTA_INTA1_MASK               (0x2U)
#define DMA_COMMON_INTA_INTA1_SHIFT              (1U)
/*! INTA1 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA1(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA1_SHIFT)) & DMA_COMMON_INTA_INTA1_MASK)

#define DMA_COMMON_INTA_INTA2_MASK               (0x4U)
#define DMA_COMMON_INTA_INTA2_SHIFT              (2U)
/*! INTA2 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA2(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA2_SHIFT)) & DMA_COMMON_INTA_INTA2_MASK)

#define DMA_COMMON_INTA_INTA3_MASK               (0x8U)
#define DMA_COMMON_INTA_INTA3_SHIFT              (3U)
/*! INTA3 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA3(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA3_SHIFT)) & DMA_COMMON_INTA_INTA3_MASK)

#define DMA_COMMON_INTA_INTA4_MASK               (0x10U)
#define DMA_COMMON_INTA_INTA4_SHIFT              (4U)
/*! INTA4 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA4(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA4_SHIFT)) & DMA_COMMON_INTA_INTA4_MASK)

#define DMA_COMMON_INTA_INTA5_MASK               (0x20U)
#define DMA_COMMON_INTA_INTA5_SHIFT              (5U)
/*! INTA5 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA5(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA5_SHIFT)) & DMA_COMMON_INTA_INTA5_MASK)

#define DMA_COMMON_INTA_INTA6_MASK               (0x40U)
#define DMA_COMMON_INTA_INTA6_SHIFT              (6U)
/*! INTA6 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA6(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA6_SHIFT)) & DMA_COMMON_INTA_INTA6_MASK)

#define DMA_COMMON_INTA_INTA7_MASK               (0x80U)
#define DMA_COMMON_INTA_INTA7_SHIFT              (7U)
/*! INTA7 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA7(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA7_SHIFT)) & DMA_COMMON_INTA_INTA7_MASK)

#define DMA_COMMON_INTA_INTA8_MASK               (0x100U)
#define DMA_COMMON_INTA_INTA8_SHIFT              (8U)
/*! INTA8 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA8(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA8_SHIFT)) & DMA_COMMON_INTA_INTA8_MASK)

#define DMA_COMMON_INTA_INTA9_MASK               (0x200U)
#define DMA_COMMON_INTA_INTA9_SHIFT              (9U)
/*! INTA9 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA9(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA9_SHIFT)) & DMA_COMMON_INTA_INTA9_MASK)

#define DMA_COMMON_INTA_INTA10_MASK              (0x400U)
#define DMA_COMMON_INTA_INTA10_SHIFT             (10U)
/*! INTA10 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA10(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA10_SHIFT)) & DMA_COMMON_INTA_INTA10_MASK)

#define DMA_COMMON_INTA_INTA11_MASK              (0x800U)
#define DMA_COMMON_INTA_INTA11_SHIFT             (11U)
/*! INTA11 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA11(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA11_SHIFT)) & DMA_COMMON_INTA_INTA11_MASK)

#define DMA_COMMON_INTA_INTA12_MASK              (0x1000U)
#define DMA_COMMON_INTA_INTA12_SHIFT             (12U)
/*! INTA12 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA12(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA12_SHIFT)) & DMA_COMMON_INTA_INTA12_MASK)

#define DMA_COMMON_INTA_INTA13_MASK              (0x2000U)
#define DMA_COMMON_INTA_INTA13_SHIFT             (13U)
/*! INTA13 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA13(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA13_SHIFT)) & DMA_COMMON_INTA_INTA13_MASK)

#define DMA_COMMON_INTA_INTA14_MASK              (0x4000U)
#define DMA_COMMON_INTA_INTA14_SHIFT             (14U)
/*! INTA14 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA14(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA14_SHIFT)) & DMA_COMMON_INTA_INTA14_MASK)

#define DMA_COMMON_INTA_INTA15_MASK              (0x8000U)
#define DMA_COMMON_INTA_INTA15_SHIFT             (15U)
/*! INTA15 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA15(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA15_SHIFT)) & DMA_COMMON_INTA_INTA15_MASK)

#define DMA_COMMON_INTA_INTA16_MASK              (0x10000U)
#define DMA_COMMON_INTA_INTA16_SHIFT             (16U)
/*! INTA16 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA16(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA16_SHIFT)) & DMA_COMMON_INTA_INTA16_MASK)

#define DMA_COMMON_INTA_INTA17_MASK              (0x20000U)
#define DMA_COMMON_INTA_INTA17_SHIFT             (17U)
/*! INTA17 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA17(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA17_SHIFT)) & DMA_COMMON_INTA_INTA17_MASK)

#define DMA_COMMON_INTA_INTA18_MASK              (0x40000U)
#define DMA_COMMON_INTA_INTA18_SHIFT             (18U)
/*! INTA18 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA18(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA18_SHIFT)) & DMA_COMMON_INTA_INTA18_MASK)

#define DMA_COMMON_INTA_INTA19_MASK              (0x80000U)
#define DMA_COMMON_INTA_INTA19_SHIFT             (19U)
/*! INTA19 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA19(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA19_SHIFT)) & DMA_COMMON_INTA_INTA19_MASK)

#define DMA_COMMON_INTA_INTA20_MASK              (0x100000U)
#define DMA_COMMON_INTA_INTA20_SHIFT             (20U)
/*! INTA20 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA20(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA20_SHIFT)) & DMA_COMMON_INTA_INTA20_MASK)

#define DMA_COMMON_INTA_INTA21_MASK              (0x200000U)
#define DMA_COMMON_INTA_INTA21_SHIFT             (21U)
/*! INTA21 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA21(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA21_SHIFT)) & DMA_COMMON_INTA_INTA21_MASK)

#define DMA_COMMON_INTA_INTA22_MASK              (0x400000U)
#define DMA_COMMON_INTA_INTA22_SHIFT             (22U)
/*! INTA22 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA22(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA22_SHIFT)) & DMA_COMMON_INTA_INTA22_MASK)

#define DMA_COMMON_INTA_INTA23_MASK              (0x800000U)
#define DMA_COMMON_INTA_INTA23_SHIFT             (23U)
/*! INTA23 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA23(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA23_SHIFT)) & DMA_COMMON_INTA_INTA23_MASK)

#define DMA_COMMON_INTA_INTA24_MASK              (0x1000000U)
#define DMA_COMMON_INTA_INTA24_SHIFT             (24U)
/*! INTA24 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA24(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA24_SHIFT)) & DMA_COMMON_INTA_INTA24_MASK)

#define DMA_COMMON_INTA_INTA25_MASK              (0x2000000U)
#define DMA_COMMON_INTA_INTA25_SHIFT             (25U)
/*! INTA25 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA25(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA25_SHIFT)) & DMA_COMMON_INTA_INTA25_MASK)

#define DMA_COMMON_INTA_INTA26_MASK              (0x4000000U)
#define DMA_COMMON_INTA_INTA26_SHIFT             (26U)
/*! INTA26 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA26(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA26_SHIFT)) & DMA_COMMON_INTA_INTA26_MASK)

#define DMA_COMMON_INTA_INTA27_MASK              (0x8000000U)
#define DMA_COMMON_INTA_INTA27_SHIFT             (27U)
/*! INTA27 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA27(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA27_SHIFT)) & DMA_COMMON_INTA_INTA27_MASK)

#define DMA_COMMON_INTA_INTA28_MASK              (0x10000000U)
#define DMA_COMMON_INTA_INTA28_SHIFT             (28U)
/*! INTA28 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA28(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA28_SHIFT)) & DMA_COMMON_INTA_INTA28_MASK)

#define DMA_COMMON_INTA_INTA29_MASK              (0x20000000U)
#define DMA_COMMON_INTA_INTA29_SHIFT             (29U)
/*! INTA29 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA29(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA29_SHIFT)) & DMA_COMMON_INTA_INTA29_MASK)

#define DMA_COMMON_INTA_INTA30_MASK              (0x40000000U)
#define DMA_COMMON_INTA_INTA30_SHIFT             (30U)
/*! INTA30 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA30(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA30_SHIFT)) & DMA_COMMON_INTA_INTA30_MASK)

#define DMA_COMMON_INTA_INTA31_MASK              (0x80000000U)
#define DMA_COMMON_INTA_INTA31_SHIFT             (31U)
/*! INTA31 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA31(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA31_SHIFT)) & DMA_COMMON_INTA_INTA31_MASK)
/*! @} */

/* The count of DMA_COMMON_INTA */
#define DMA_COMMON_INTA_COUNT                    (1U)

/*! @name COMMON_INTA1 - Interrupt A status for all DMA channels */
/*! @{ */

#define DMA_COMMON_INTA1_INTA32_MASK             (0x1U)
#define DMA_COMMON_INTA1_INTA32_SHIFT            (0U)
/*! INTA32 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA1_INTA32(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA1_INTA32_SHIFT)) & DMA_COMMON_INTA1_INTA32_MASK)

#define DMA_COMMON_INTA1_INTA33_MASK             (0x2U)
#define DMA_COMMON_INTA1_INTA33_SHIFT            (1U)
/*! INTA33 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA1_INTA33(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA1_INTA33_SHIFT)) & DMA_COMMON_INTA1_INTA33_MASK)

#define DMA_COMMON_INTA1_INTA34_MASK             (0x4U)
#define DMA_COMMON_INTA1_INTA34_SHIFT            (2U)
/*! INTA34 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA1_INTA34(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA1_INTA34_SHIFT)) & DMA_COMMON_INTA1_INTA34_MASK)

#define DMA_COMMON_INTA1_INTA35_MASK             (0x8U)
#define DMA_COMMON_INTA1_INTA35_SHIFT            (3U)
/*! INTA35 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA1_INTA35(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA1_INTA35_SHIFT)) & DMA_COMMON_INTA1_INTA35_MASK)

#define DMA_COMMON_INTA1_INTA36_MASK             (0x10U)
#define DMA_COMMON_INTA1_INTA36_SHIFT            (4U)
/*! INTA36 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA1_INTA36(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA1_INTA36_SHIFT)) & DMA_COMMON_INTA1_INTA36_MASK)

#define DMA_COMMON_INTA1_INTA37_MASK             (0x20U)
#define DMA_COMMON_INTA1_INTA37_SHIFT            (5U)
/*! INTA37 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA1_INTA37(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA1_INTA37_SHIFT)) & DMA_COMMON_INTA1_INTA37_MASK)

#define DMA_COMMON_INTA1_INTA38_MASK             (0x40U)
#define DMA_COMMON_INTA1_INTA38_SHIFT            (6U)
/*! INTA38 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA1_INTA38(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA1_INTA38_SHIFT)) & DMA_COMMON_INTA1_INTA38_MASK)

#define DMA_COMMON_INTA1_INTA39_MASK             (0x80U)
#define DMA_COMMON_INTA1_INTA39_SHIFT            (7U)
/*! INTA39 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA1_INTA39(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA1_INTA39_SHIFT)) & DMA_COMMON_INTA1_INTA39_MASK)

#define DMA_COMMON_INTA1_INTA40_MASK             (0x100U)
#define DMA_COMMON_INTA1_INTA40_SHIFT            (8U)
/*! INTA40 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA1_INTA40(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA1_INTA40_SHIFT)) & DMA_COMMON_INTA1_INTA40_MASK)

#define DMA_COMMON_INTA1_INTA41_MASK             (0x200U)
#define DMA_COMMON_INTA1_INTA41_SHIFT            (9U)
/*! INTA41 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA1_INTA41(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA1_INTA41_SHIFT)) & DMA_COMMON_INTA1_INTA41_MASK)

#define DMA_COMMON_INTA1_INTA42_MASK             (0x400U)
#define DMA_COMMON_INTA1_INTA42_SHIFT            (10U)
/*! INTA42 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA1_INTA42(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA1_INTA42_SHIFT)) & DMA_COMMON_INTA1_INTA42_MASK)

#define DMA_COMMON_INTA1_INTA43_MASK             (0x800U)
#define DMA_COMMON_INTA1_INTA43_SHIFT            (11U)
/*! INTA43 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA1_INTA43(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA1_INTA43_SHIFT)) & DMA_COMMON_INTA1_INTA43_MASK)

#define DMA_COMMON_INTA1_INTA44_MASK             (0x1000U)
#define DMA_COMMON_INTA1_INTA44_SHIFT            (12U)
/*! INTA44 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA1_INTA44(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA1_INTA44_SHIFT)) & DMA_COMMON_INTA1_INTA44_MASK)

#define DMA_COMMON_INTA1_INTA45_MASK             (0x2000U)
#define DMA_COMMON_INTA1_INTA45_SHIFT            (13U)
/*! INTA45 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA1_INTA45(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA1_INTA45_SHIFT)) & DMA_COMMON_INTA1_INTA45_MASK)

#define DMA_COMMON_INTA1_INTA46_MASK             (0x4000U)
#define DMA_COMMON_INTA1_INTA46_SHIFT            (14U)
/*! INTA46 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA1_INTA46(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA1_INTA46_SHIFT)) & DMA_COMMON_INTA1_INTA46_MASK)

#define DMA_COMMON_INTA1_INTA47_MASK             (0x8000U)
#define DMA_COMMON_INTA1_INTA47_SHIFT            (15U)
/*! INTA47 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA1_INTA47(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA1_INTA47_SHIFT)) & DMA_COMMON_INTA1_INTA47_MASK)

#define DMA_COMMON_INTA1_INTA48_MASK             (0x10000U)
#define DMA_COMMON_INTA1_INTA48_SHIFT            (16U)
/*! INTA48 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA1_INTA48(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA1_INTA48_SHIFT)) & DMA_COMMON_INTA1_INTA48_MASK)

#define DMA_COMMON_INTA1_INTA49_MASK             (0x20000U)
#define DMA_COMMON_INTA1_INTA49_SHIFT            (17U)
/*! INTA49 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA1_INTA49(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA1_INTA49_SHIFT)) & DMA_COMMON_INTA1_INTA49_MASK)

#define DMA_COMMON_INTA1_INTA50_MASK             (0x40000U)
#define DMA_COMMON_INTA1_INTA50_SHIFT            (18U)
/*! INTA50 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA1_INTA50(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA1_INTA50_SHIFT)) & DMA_COMMON_INTA1_INTA50_MASK)

#define DMA_COMMON_INTA1_INTA51_MASK             (0x80000U)
#define DMA_COMMON_INTA1_INTA51_SHIFT            (19U)
/*! INTA51 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA1_INTA51(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA1_INTA51_SHIFT)) & DMA_COMMON_INTA1_INTA51_MASK)
/*! @} */

/* The count of DMA_COMMON_INTA1 */
#define DMA_COMMON_INTA1_COUNT                   (1U)

/*! @name COMMON_INTB - Interrupt B status for all DMA channels */
/*! @{ */

#define DMA_COMMON_INTB_INTB0_MASK               (0x1U)
#define DMA_COMMON_INTB_INTB0_SHIFT              (0U)
/*! INTB0 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB0(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB0_SHIFT)) & DMA_COMMON_INTB_INTB0_MASK)

#define DMA_COMMON_INTB_INTB1_MASK               (0x2U)
#define DMA_COMMON_INTB_INTB1_SHIFT              (1U)
/*! INTB1 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB1(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB1_SHIFT)) & DMA_COMMON_INTB_INTB1_MASK)

#define DMA_COMMON_INTB_INTB2_MASK               (0x4U)
#define DMA_COMMON_INTB_INTB2_SHIFT              (2U)
/*! INTB2 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB2(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB2_SHIFT)) & DMA_COMMON_INTB_INTB2_MASK)

#define DMA_COMMON_INTB_INTB3_MASK               (0x8U)
#define DMA_COMMON_INTB_INTB3_SHIFT              (3U)
/*! INTB3 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB3(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB3_SHIFT)) & DMA_COMMON_INTB_INTB3_MASK)

#define DMA_COMMON_INTB_INTB4_MASK               (0x10U)
#define DMA_COMMON_INTB_INTB4_SHIFT              (4U)
/*! INTB4 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB4(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB4_SHIFT)) & DMA_COMMON_INTB_INTB4_MASK)

#define DMA_COMMON_INTB_INTB5_MASK               (0x20U)
#define DMA_COMMON_INTB_INTB5_SHIFT              (5U)
/*! INTB5 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB5(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB5_SHIFT)) & DMA_COMMON_INTB_INTB5_MASK)

#define DMA_COMMON_INTB_INTB6_MASK               (0x40U)
#define DMA_COMMON_INTB_INTB6_SHIFT              (6U)
/*! INTB6 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB6(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB6_SHIFT)) & DMA_COMMON_INTB_INTB6_MASK)

#define DMA_COMMON_INTB_INTB7_MASK               (0x80U)
#define DMA_COMMON_INTB_INTB7_SHIFT              (7U)
/*! INTB7 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB7(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB7_SHIFT)) & DMA_COMMON_INTB_INTB7_MASK)

#define DMA_COMMON_INTB_INTB8_MASK               (0x100U)
#define DMA_COMMON_INTB_INTB8_SHIFT              (8U)
/*! INTB8 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB8(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB8_SHIFT)) & DMA_COMMON_INTB_INTB8_MASK)

#define DMA_COMMON_INTB_INTB9_MASK               (0x200U)
#define DMA_COMMON_INTB_INTB9_SHIFT              (9U)
/*! INTB9 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB9(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB9_SHIFT)) & DMA_COMMON_INTB_INTB9_MASK)

#define DMA_COMMON_INTB_INTB10_MASK              (0x400U)
#define DMA_COMMON_INTB_INTB10_SHIFT             (10U)
/*! INTB10 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB10(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB10_SHIFT)) & DMA_COMMON_INTB_INTB10_MASK)

#define DMA_COMMON_INTB_INTB11_MASK              (0x800U)
#define DMA_COMMON_INTB_INTB11_SHIFT             (11U)
/*! INTB11 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB11(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB11_SHIFT)) & DMA_COMMON_INTB_INTB11_MASK)

#define DMA_COMMON_INTB_INTB12_MASK              (0x1000U)
#define DMA_COMMON_INTB_INTB12_SHIFT             (12U)
/*! INTB12 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB12(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB12_SHIFT)) & DMA_COMMON_INTB_INTB12_MASK)

#define DMA_COMMON_INTB_INTB13_MASK              (0x2000U)
#define DMA_COMMON_INTB_INTB13_SHIFT             (13U)
/*! INTB13 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB13(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB13_SHIFT)) & DMA_COMMON_INTB_INTB13_MASK)

#define DMA_COMMON_INTB_INTB14_MASK              (0x4000U)
#define DMA_COMMON_INTB_INTB14_SHIFT             (14U)
/*! INTB14 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB14(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB14_SHIFT)) & DMA_COMMON_INTB_INTB14_MASK)

#define DMA_COMMON_INTB_INTB15_MASK              (0x8000U)
#define DMA_COMMON_INTB_INTB15_SHIFT             (15U)
/*! INTB15 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB15(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB15_SHIFT)) & DMA_COMMON_INTB_INTB15_MASK)

#define DMA_COMMON_INTB_INTB16_MASK              (0x10000U)
#define DMA_COMMON_INTB_INTB16_SHIFT             (16U)
/*! INTB16 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB16(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB16_SHIFT)) & DMA_COMMON_INTB_INTB16_MASK)

#define DMA_COMMON_INTB_INTB17_MASK              (0x20000U)
#define DMA_COMMON_INTB_INTB17_SHIFT             (17U)
/*! INTB17 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB17(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB17_SHIFT)) & DMA_COMMON_INTB_INTB17_MASK)

#define DMA_COMMON_INTB_INTB18_MASK              (0x40000U)
#define DMA_COMMON_INTB_INTB18_SHIFT             (18U)
/*! INTB18 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB18(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB18_SHIFT)) & DMA_COMMON_INTB_INTB18_MASK)

#define DMA_COMMON_INTB_INTB19_MASK              (0x80000U)
#define DMA_COMMON_INTB_INTB19_SHIFT             (19U)
/*! INTB19 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB19(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB19_SHIFT)) & DMA_COMMON_INTB_INTB19_MASK)

#define DMA_COMMON_INTB_INTB20_MASK              (0x100000U)
#define DMA_COMMON_INTB_INTB20_SHIFT             (20U)
/*! INTB20 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB20(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB20_SHIFT)) & DMA_COMMON_INTB_INTB20_MASK)

#define DMA_COMMON_INTB_INTB21_MASK              (0x200000U)
#define DMA_COMMON_INTB_INTB21_SHIFT             (21U)
/*! INTB21 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB21(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB21_SHIFT)) & DMA_COMMON_INTB_INTB21_MASK)

#define DMA_COMMON_INTB_INTB22_MASK              (0x400000U)
#define DMA_COMMON_INTB_INTB22_SHIFT             (22U)
/*! INTB22 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB22(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB22_SHIFT)) & DMA_COMMON_INTB_INTB22_MASK)

#define DMA_COMMON_INTB_INTB23_MASK              (0x800000U)
#define DMA_COMMON_INTB_INTB23_SHIFT             (23U)
/*! INTB23 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB23(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB23_SHIFT)) & DMA_COMMON_INTB_INTB23_MASK)

#define DMA_COMMON_INTB_INTB24_MASK              (0x1000000U)
#define DMA_COMMON_INTB_INTB24_SHIFT             (24U)
/*! INTB24 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB24(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB24_SHIFT)) & DMA_COMMON_INTB_INTB24_MASK)

#define DMA_COMMON_INTB_INTB25_MASK              (0x2000000U)
#define DMA_COMMON_INTB_INTB25_SHIFT             (25U)
/*! INTB25 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB25(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB25_SHIFT)) & DMA_COMMON_INTB_INTB25_MASK)

#define DMA_COMMON_INTB_INTB26_MASK              (0x4000000U)
#define DMA_COMMON_INTB_INTB26_SHIFT             (26U)
/*! INTB26 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB26(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB26_SHIFT)) & DMA_COMMON_INTB_INTB26_MASK)

#define DMA_COMMON_INTB_INTB27_MASK              (0x8000000U)
#define DMA_COMMON_INTB_INTB27_SHIFT             (27U)
/*! INTB27 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB27(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB27_SHIFT)) & DMA_COMMON_INTB_INTB27_MASK)

#define DMA_COMMON_INTB_INTB28_MASK              (0x10000000U)
#define DMA_COMMON_INTB_INTB28_SHIFT             (28U)
/*! INTB28 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB28(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB28_SHIFT)) & DMA_COMMON_INTB_INTB28_MASK)

#define DMA_COMMON_INTB_INTB29_MASK              (0x20000000U)
#define DMA_COMMON_INTB_INTB29_SHIFT             (29U)
/*! INTB29 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB29(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB29_SHIFT)) & DMA_COMMON_INTB_INTB29_MASK)

#define DMA_COMMON_INTB_INTB30_MASK              (0x40000000U)
#define DMA_COMMON_INTB_INTB30_SHIFT             (30U)
/*! INTB30 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB30(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB30_SHIFT)) & DMA_COMMON_INTB_INTB30_MASK)

#define DMA_COMMON_INTB_INTB31_MASK              (0x80000000U)
#define DMA_COMMON_INTB_INTB31_SHIFT             (31U)
/*! INTB31 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB31(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB31_SHIFT)) & DMA_COMMON_INTB_INTB31_MASK)
/*! @} */

/* The count of DMA_COMMON_INTB */
#define DMA_COMMON_INTB_COUNT                    (1U)

/*! @name COMMON_INTB1 - Interrupt B status for all DMA channels */
/*! @{ */

#define DMA_COMMON_INTB1_INTB0_MASK              (0x1U)
#define DMA_COMMON_INTB1_INTB0_SHIFT             (0U)
/*! INTB0 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB1_INTB0(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB1_INTB0_SHIFT)) & DMA_COMMON_INTB1_INTB0_MASK)

#define DMA_COMMON_INTB1_INTB1_MASK              (0x2U)
#define DMA_COMMON_INTB1_INTB1_SHIFT             (1U)
/*! INTB1 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB1_INTB1(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB1_INTB1_SHIFT)) & DMA_COMMON_INTB1_INTB1_MASK)

#define DMA_COMMON_INTB1_INTB2_MASK              (0x4U)
#define DMA_COMMON_INTB1_INTB2_SHIFT             (2U)
/*! INTB2 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB1_INTB2(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB1_INTB2_SHIFT)) & DMA_COMMON_INTB1_INTB2_MASK)

#define DMA_COMMON_INTB1_INTB3_MASK              (0x8U)
#define DMA_COMMON_INTB1_INTB3_SHIFT             (3U)
/*! INTB3 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB1_INTB3(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB1_INTB3_SHIFT)) & DMA_COMMON_INTB1_INTB3_MASK)

#define DMA_COMMON_INTB1_INTB4_MASK              (0x10U)
#define DMA_COMMON_INTB1_INTB4_SHIFT             (4U)
/*! INTB4 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB1_INTB4(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB1_INTB4_SHIFT)) & DMA_COMMON_INTB1_INTB4_MASK)

#define DMA_COMMON_INTB1_INTB5_MASK              (0x20U)
#define DMA_COMMON_INTB1_INTB5_SHIFT             (5U)
/*! INTB5 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB1_INTB5(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB1_INTB5_SHIFT)) & DMA_COMMON_INTB1_INTB5_MASK)

#define DMA_COMMON_INTB1_INTB6_MASK              (0x40U)
#define DMA_COMMON_INTB1_INTB6_SHIFT             (6U)
/*! INTB6 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB1_INTB6(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB1_INTB6_SHIFT)) & DMA_COMMON_INTB1_INTB6_MASK)

#define DMA_COMMON_INTB1_INTB7_MASK              (0x80U)
#define DMA_COMMON_INTB1_INTB7_SHIFT             (7U)
/*! INTB7 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB1_INTB7(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB1_INTB7_SHIFT)) & DMA_COMMON_INTB1_INTB7_MASK)

#define DMA_COMMON_INTB1_INTB8_MASK              (0x100U)
#define DMA_COMMON_INTB1_INTB8_SHIFT             (8U)
/*! INTB8 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB1_INTB8(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB1_INTB8_SHIFT)) & DMA_COMMON_INTB1_INTB8_MASK)

#define DMA_COMMON_INTB1_INTB9_MASK              (0x200U)
#define DMA_COMMON_INTB1_INTB9_SHIFT             (9U)
/*! INTB9 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB1_INTB9(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB1_INTB9_SHIFT)) & DMA_COMMON_INTB1_INTB9_MASK)

#define DMA_COMMON_INTB1_INTB10_MASK             (0x400U)
#define DMA_COMMON_INTB1_INTB10_SHIFT            (10U)
/*! INTB10 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB1_INTB10(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB1_INTB10_SHIFT)) & DMA_COMMON_INTB1_INTB10_MASK)

#define DMA_COMMON_INTB1_INTB11_MASK             (0x800U)
#define DMA_COMMON_INTB1_INTB11_SHIFT            (11U)
/*! INTB11 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB1_INTB11(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB1_INTB11_SHIFT)) & DMA_COMMON_INTB1_INTB11_MASK)

#define DMA_COMMON_INTB1_INTB12_MASK             (0x1000U)
#define DMA_COMMON_INTB1_INTB12_SHIFT            (12U)
/*! INTB12 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB1_INTB12(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB1_INTB12_SHIFT)) & DMA_COMMON_INTB1_INTB12_MASK)

#define DMA_COMMON_INTB1_INTB13_MASK             (0x2000U)
#define DMA_COMMON_INTB1_INTB13_SHIFT            (13U)
/*! INTB13 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB1_INTB13(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB1_INTB13_SHIFT)) & DMA_COMMON_INTB1_INTB13_MASK)

#define DMA_COMMON_INTB1_INTB14_MASK             (0x4000U)
#define DMA_COMMON_INTB1_INTB14_SHIFT            (14U)
/*! INTB14 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB1_INTB14(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB1_INTB14_SHIFT)) & DMA_COMMON_INTB1_INTB14_MASK)

#define DMA_COMMON_INTB1_INTB15_MASK             (0x8000U)
#define DMA_COMMON_INTB1_INTB15_SHIFT            (15U)
/*! INTB15 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB1_INTB15(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB1_INTB15_SHIFT)) & DMA_COMMON_INTB1_INTB15_MASK)

#define DMA_COMMON_INTB1_INTB16_MASK             (0x10000U)
#define DMA_COMMON_INTB1_INTB16_SHIFT            (16U)
/*! INTB16 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB1_INTB16(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB1_INTB16_SHIFT)) & DMA_COMMON_INTB1_INTB16_MASK)

#define DMA_COMMON_INTB1_INTB17_MASK             (0x20000U)
#define DMA_COMMON_INTB1_INTB17_SHIFT            (17U)
/*! INTB17 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB1_INTB17(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB1_INTB17_SHIFT)) & DMA_COMMON_INTB1_INTB17_MASK)

#define DMA_COMMON_INTB1_INTB18_MASK             (0x40000U)
#define DMA_COMMON_INTB1_INTB18_SHIFT            (18U)
/*! INTB18 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB1_INTB18(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB1_INTB18_SHIFT)) & DMA_COMMON_INTB1_INTB18_MASK)

#define DMA_COMMON_INTB1_INTB19_MASK             (0x80000U)
#define DMA_COMMON_INTB1_INTB19_SHIFT            (19U)
/*! INTB19 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB1_INTB19(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB1_INTB19_SHIFT)) & DMA_COMMON_INTB1_INTB19_MASK)
/*! @} */

/* The count of DMA_COMMON_INTB1 */
#define DMA_COMMON_INTB1_COUNT                   (1U)

/*! @name COMMON_SETVALID - Set ValidPending control bits for all DMA channels */
/*! @{ */

#define DMA_COMMON_SETVALID_SETVALID0_MASK       (0x1U)
#define DMA_COMMON_SETVALID_SETVALID0_SHIFT      (0U)
/*! SETVALID0 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID0(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID0_SHIFT)) & DMA_COMMON_SETVALID_SETVALID0_MASK)

#define DMA_COMMON_SETVALID_SETVALID1_MASK       (0x2U)
#define DMA_COMMON_SETVALID_SETVALID1_SHIFT      (1U)
/*! SETVALID1 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID1(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID1_SHIFT)) & DMA_COMMON_SETVALID_SETVALID1_MASK)

#define DMA_COMMON_SETVALID_SETVALID2_MASK       (0x4U)
#define DMA_COMMON_SETVALID_SETVALID2_SHIFT      (2U)
/*! SETVALID2 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID2(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID2_SHIFT)) & DMA_COMMON_SETVALID_SETVALID2_MASK)

#define DMA_COMMON_SETVALID_SETVALID3_MASK       (0x8U)
#define DMA_COMMON_SETVALID_SETVALID3_SHIFT      (3U)
/*! SETVALID3 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID3(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID3_SHIFT)) & DMA_COMMON_SETVALID_SETVALID3_MASK)

#define DMA_COMMON_SETVALID_SETVALID4_MASK       (0x10U)
#define DMA_COMMON_SETVALID_SETVALID4_SHIFT      (4U)
/*! SETVALID4 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID4(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID4_SHIFT)) & DMA_COMMON_SETVALID_SETVALID4_MASK)

#define DMA_COMMON_SETVALID_SETVALID5_MASK       (0x20U)
#define DMA_COMMON_SETVALID_SETVALID5_SHIFT      (5U)
/*! SETVALID5 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID5(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID5_SHIFT)) & DMA_COMMON_SETVALID_SETVALID5_MASK)

#define DMA_COMMON_SETVALID_SETVALID6_MASK       (0x40U)
#define DMA_COMMON_SETVALID_SETVALID6_SHIFT      (6U)
/*! SETVALID6 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID6(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID6_SHIFT)) & DMA_COMMON_SETVALID_SETVALID6_MASK)

#define DMA_COMMON_SETVALID_SETVALID7_MASK       (0x80U)
#define DMA_COMMON_SETVALID_SETVALID7_SHIFT      (7U)
/*! SETVALID7 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID7(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID7_SHIFT)) & DMA_COMMON_SETVALID_SETVALID7_MASK)

#define DMA_COMMON_SETVALID_SETVALID8_MASK       (0x100U)
#define DMA_COMMON_SETVALID_SETVALID8_SHIFT      (8U)
/*! SETVALID8 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID8(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID8_SHIFT)) & DMA_COMMON_SETVALID_SETVALID8_MASK)

#define DMA_COMMON_SETVALID_SETVALID9_MASK       (0x200U)
#define DMA_COMMON_SETVALID_SETVALID9_SHIFT      (9U)
/*! SETVALID9 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID9(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID9_SHIFT)) & DMA_COMMON_SETVALID_SETVALID9_MASK)

#define DMA_COMMON_SETVALID_SETVALID10_MASK      (0x400U)
#define DMA_COMMON_SETVALID_SETVALID10_SHIFT     (10U)
/*! SETVALID10 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID10(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID10_SHIFT)) & DMA_COMMON_SETVALID_SETVALID10_MASK)

#define DMA_COMMON_SETVALID_SETVALID11_MASK      (0x800U)
#define DMA_COMMON_SETVALID_SETVALID11_SHIFT     (11U)
/*! SETVALID11 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID11(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID11_SHIFT)) & DMA_COMMON_SETVALID_SETVALID11_MASK)

#define DMA_COMMON_SETVALID_SETVALID12_MASK      (0x1000U)
#define DMA_COMMON_SETVALID_SETVALID12_SHIFT     (12U)
/*! SETVALID12 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID12(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID12_SHIFT)) & DMA_COMMON_SETVALID_SETVALID12_MASK)

#define DMA_COMMON_SETVALID_SETVALID13_MASK      (0x2000U)
#define DMA_COMMON_SETVALID_SETVALID13_SHIFT     (13U)
/*! SETVALID13 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID13(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID13_SHIFT)) & DMA_COMMON_SETVALID_SETVALID13_MASK)

#define DMA_COMMON_SETVALID_SETVALID14_MASK      (0x4000U)
#define DMA_COMMON_SETVALID_SETVALID14_SHIFT     (14U)
/*! SETVALID14 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID14(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID14_SHIFT)) & DMA_COMMON_SETVALID_SETVALID14_MASK)

#define DMA_COMMON_SETVALID_SETVALID15_MASK      (0x8000U)
#define DMA_COMMON_SETVALID_SETVALID15_SHIFT     (15U)
/*! SETVALID15 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID15(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID15_SHIFT)) & DMA_COMMON_SETVALID_SETVALID15_MASK)

#define DMA_COMMON_SETVALID_SETVALID16_MASK      (0x10000U)
#define DMA_COMMON_SETVALID_SETVALID16_SHIFT     (16U)
/*! SETVALID16 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID16(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID16_SHIFT)) & DMA_COMMON_SETVALID_SETVALID16_MASK)

#define DMA_COMMON_SETVALID_SETVALID17_MASK      (0x20000U)
#define DMA_COMMON_SETVALID_SETVALID17_SHIFT     (17U)
/*! SETVALID17 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID17(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID17_SHIFT)) & DMA_COMMON_SETVALID_SETVALID17_MASK)

#define DMA_COMMON_SETVALID_SETVALID18_MASK      (0x40000U)
#define DMA_COMMON_SETVALID_SETVALID18_SHIFT     (18U)
/*! SETVALID18 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID18(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID18_SHIFT)) & DMA_COMMON_SETVALID_SETVALID18_MASK)

#define DMA_COMMON_SETVALID_SETVALID19_MASK      (0x80000U)
#define DMA_COMMON_SETVALID_SETVALID19_SHIFT     (19U)
/*! SETVALID19 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID19(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID19_SHIFT)) & DMA_COMMON_SETVALID_SETVALID19_MASK)

#define DMA_COMMON_SETVALID_SETVALID20_MASK      (0x100000U)
#define DMA_COMMON_SETVALID_SETVALID20_SHIFT     (20U)
/*! SETVALID20 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID20(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID20_SHIFT)) & DMA_COMMON_SETVALID_SETVALID20_MASK)

#define DMA_COMMON_SETVALID_SETVALID21_MASK      (0x200000U)
#define DMA_COMMON_SETVALID_SETVALID21_SHIFT     (21U)
/*! SETVALID21 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID21(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID21_SHIFT)) & DMA_COMMON_SETVALID_SETVALID21_MASK)

#define DMA_COMMON_SETVALID_SETVALID22_MASK      (0x400000U)
#define DMA_COMMON_SETVALID_SETVALID22_SHIFT     (22U)
/*! SETVALID22 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID22(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID22_SHIFT)) & DMA_COMMON_SETVALID_SETVALID22_MASK)

#define DMA_COMMON_SETVALID_SETVALID23_MASK      (0x800000U)
#define DMA_COMMON_SETVALID_SETVALID23_SHIFT     (23U)
/*! SETVALID23 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID23(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID23_SHIFT)) & DMA_COMMON_SETVALID_SETVALID23_MASK)

#define DMA_COMMON_SETVALID_SETVALID24_MASK      (0x1000000U)
#define DMA_COMMON_SETVALID_SETVALID24_SHIFT     (24U)
/*! SETVALID24 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID24(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID24_SHIFT)) & DMA_COMMON_SETVALID_SETVALID24_MASK)

#define DMA_COMMON_SETVALID_SETVALID25_MASK      (0x2000000U)
#define DMA_COMMON_SETVALID_SETVALID25_SHIFT     (25U)
/*! SETVALID25 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID25(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID25_SHIFT)) & DMA_COMMON_SETVALID_SETVALID25_MASK)

#define DMA_COMMON_SETVALID_SETVALID26_MASK      (0x4000000U)
#define DMA_COMMON_SETVALID_SETVALID26_SHIFT     (26U)
/*! SETVALID26 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID26(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID26_SHIFT)) & DMA_COMMON_SETVALID_SETVALID26_MASK)

#define DMA_COMMON_SETVALID_SETVALID27_MASK      (0x8000000U)
#define DMA_COMMON_SETVALID_SETVALID27_SHIFT     (27U)
/*! SETVALID27 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID27(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID27_SHIFT)) & DMA_COMMON_SETVALID_SETVALID27_MASK)

#define DMA_COMMON_SETVALID_SETVALID28_MASK      (0x10000000U)
#define DMA_COMMON_SETVALID_SETVALID28_SHIFT     (28U)
/*! SETVALID28 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID28(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID28_SHIFT)) & DMA_COMMON_SETVALID_SETVALID28_MASK)

#define DMA_COMMON_SETVALID_SETVALID29_MASK      (0x20000000U)
#define DMA_COMMON_SETVALID_SETVALID29_SHIFT     (29U)
/*! SETVALID29 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID29(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID29_SHIFT)) & DMA_COMMON_SETVALID_SETVALID29_MASK)

#define DMA_COMMON_SETVALID_SETVALID30_MASK      (0x40000000U)
#define DMA_COMMON_SETVALID_SETVALID30_SHIFT     (30U)
/*! SETVALID30 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID30(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID30_SHIFT)) & DMA_COMMON_SETVALID_SETVALID30_MASK)

#define DMA_COMMON_SETVALID_SETVALID31_MASK      (0x80000000U)
#define DMA_COMMON_SETVALID_SETVALID31_SHIFT     (31U)
/*! SETVALID31 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID31(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID31_SHIFT)) & DMA_COMMON_SETVALID_SETVALID31_MASK)
/*! @} */

/* The count of DMA_COMMON_SETVALID */
#define DMA_COMMON_SETVALID_COUNT                (1U)

/*! @name COMMON_SETVALID1 - Set ValidPending control bits for all DMA channels */
/*! @{ */

#define DMA_COMMON_SETVALID1_SETVALID32_MASK     (0x1U)
#define DMA_COMMON_SETVALID1_SETVALID32_SHIFT    (0U)
/*! SETVALID32 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID1_SETVALID32(x)       (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID1_SETVALID32_SHIFT)) & DMA_COMMON_SETVALID1_SETVALID32_MASK)

#define DMA_COMMON_SETVALID1_SETVALID33_MASK     (0x2U)
#define DMA_COMMON_SETVALID1_SETVALID33_SHIFT    (1U)
/*! SETVALID33 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID1_SETVALID33(x)       (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID1_SETVALID33_SHIFT)) & DMA_COMMON_SETVALID1_SETVALID33_MASK)

#define DMA_COMMON_SETVALID1_SETVALID34_MASK     (0x4U)
#define DMA_COMMON_SETVALID1_SETVALID34_SHIFT    (2U)
/*! SETVALID34 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID1_SETVALID34(x)       (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID1_SETVALID34_SHIFT)) & DMA_COMMON_SETVALID1_SETVALID34_MASK)

#define DMA_COMMON_SETVALID1_SETVALID35_MASK     (0x8U)
#define DMA_COMMON_SETVALID1_SETVALID35_SHIFT    (3U)
/*! SETVALID35 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID1_SETVALID35(x)       (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID1_SETVALID35_SHIFT)) & DMA_COMMON_SETVALID1_SETVALID35_MASK)

#define DMA_COMMON_SETVALID1_SETVALID36_MASK     (0x10U)
#define DMA_COMMON_SETVALID1_SETVALID36_SHIFT    (4U)
/*! SETVALID36 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID1_SETVALID36(x)       (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID1_SETVALID36_SHIFT)) & DMA_COMMON_SETVALID1_SETVALID36_MASK)

#define DMA_COMMON_SETVALID1_SETVALID37_MASK     (0x20U)
#define DMA_COMMON_SETVALID1_SETVALID37_SHIFT    (5U)
/*! SETVALID37 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID1_SETVALID37(x)       (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID1_SETVALID37_SHIFT)) & DMA_COMMON_SETVALID1_SETVALID37_MASK)

#define DMA_COMMON_SETVALID1_SETVALID38_MASK     (0x40U)
#define DMA_COMMON_SETVALID1_SETVALID38_SHIFT    (6U)
/*! SETVALID38 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID1_SETVALID38(x)       (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID1_SETVALID38_SHIFT)) & DMA_COMMON_SETVALID1_SETVALID38_MASK)

#define DMA_COMMON_SETVALID1_SETVALID39_MASK     (0x80U)
#define DMA_COMMON_SETVALID1_SETVALID39_SHIFT    (7U)
/*! SETVALID39 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID1_SETVALID39(x)       (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID1_SETVALID39_SHIFT)) & DMA_COMMON_SETVALID1_SETVALID39_MASK)

#define DMA_COMMON_SETVALID1_SETVALID40_MASK     (0x100U)
#define DMA_COMMON_SETVALID1_SETVALID40_SHIFT    (8U)
/*! SETVALID40 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID1_SETVALID40(x)       (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID1_SETVALID40_SHIFT)) & DMA_COMMON_SETVALID1_SETVALID40_MASK)

#define DMA_COMMON_SETVALID1_SETVALID41_MASK     (0x200U)
#define DMA_COMMON_SETVALID1_SETVALID41_SHIFT    (9U)
/*! SETVALID41 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID1_SETVALID41(x)       (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID1_SETVALID41_SHIFT)) & DMA_COMMON_SETVALID1_SETVALID41_MASK)

#define DMA_COMMON_SETVALID1_SETVALID42_MASK     (0x400U)
#define DMA_COMMON_SETVALID1_SETVALID42_SHIFT    (10U)
/*! SETVALID42 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID1_SETVALID42(x)       (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID1_SETVALID42_SHIFT)) & DMA_COMMON_SETVALID1_SETVALID42_MASK)

#define DMA_COMMON_SETVALID1_SETVALID43_MASK     (0x800U)
#define DMA_COMMON_SETVALID1_SETVALID43_SHIFT    (11U)
/*! SETVALID43 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID1_SETVALID43(x)       (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID1_SETVALID43_SHIFT)) & DMA_COMMON_SETVALID1_SETVALID43_MASK)

#define DMA_COMMON_SETVALID1_SETVALID44_MASK     (0x1000U)
#define DMA_COMMON_SETVALID1_SETVALID44_SHIFT    (12U)
/*! SETVALID44 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID1_SETVALID44(x)       (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID1_SETVALID44_SHIFT)) & DMA_COMMON_SETVALID1_SETVALID44_MASK)

#define DMA_COMMON_SETVALID1_SETVALID45_MASK     (0x2000U)
#define DMA_COMMON_SETVALID1_SETVALID45_SHIFT    (13U)
/*! SETVALID45 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID1_SETVALID45(x)       (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID1_SETVALID45_SHIFT)) & DMA_COMMON_SETVALID1_SETVALID45_MASK)

#define DMA_COMMON_SETVALID1_SETVALID46_MASK     (0x4000U)
#define DMA_COMMON_SETVALID1_SETVALID46_SHIFT    (14U)
/*! SETVALID46 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID1_SETVALID46(x)       (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID1_SETVALID46_SHIFT)) & DMA_COMMON_SETVALID1_SETVALID46_MASK)

#define DMA_COMMON_SETVALID1_SETVALID47_MASK     (0x8000U)
#define DMA_COMMON_SETVALID1_SETVALID47_SHIFT    (15U)
/*! SETVALID47 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID1_SETVALID47(x)       (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID1_SETVALID47_SHIFT)) & DMA_COMMON_SETVALID1_SETVALID47_MASK)

#define DMA_COMMON_SETVALID1_SETVALID48_MASK     (0x10000U)
#define DMA_COMMON_SETVALID1_SETVALID48_SHIFT    (16U)
/*! SETVALID48 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID1_SETVALID48(x)       (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID1_SETVALID48_SHIFT)) & DMA_COMMON_SETVALID1_SETVALID48_MASK)

#define DMA_COMMON_SETVALID1_SETVALID49_MASK     (0x20000U)
#define DMA_COMMON_SETVALID1_SETVALID49_SHIFT    (17U)
/*! SETVALID49 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID1_SETVALID49(x)       (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID1_SETVALID49_SHIFT)) & DMA_COMMON_SETVALID1_SETVALID49_MASK)

#define DMA_COMMON_SETVALID1_SETVALID50_MASK     (0x40000U)
#define DMA_COMMON_SETVALID1_SETVALID50_SHIFT    (18U)
/*! SETVALID50 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID1_SETVALID50(x)       (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID1_SETVALID50_SHIFT)) & DMA_COMMON_SETVALID1_SETVALID50_MASK)

#define DMA_COMMON_SETVALID1_SETVALID51_MASK     (0x80000U)
#define DMA_COMMON_SETVALID1_SETVALID51_SHIFT    (19U)
/*! SETVALID51 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID1_SETVALID51(x)       (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID1_SETVALID51_SHIFT)) & DMA_COMMON_SETVALID1_SETVALID51_MASK)
/*! @} */

/* The count of DMA_COMMON_SETVALID1 */
#define DMA_COMMON_SETVALID1_COUNT               (1U)

/*! @name COMMON_SETTRIG - Set Trigger control bits for all DMA channels */
/*! @{ */

#define DMA_COMMON_SETTRIG_SETTRIG0_MASK         (0x1U)
#define DMA_COMMON_SETTRIG_SETTRIG0_SHIFT        (0U)
/*! SETTRIG0 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG0(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG0_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG0_MASK)

#define DMA_COMMON_SETTRIG_SETTRIG1_MASK         (0x2U)
#define DMA_COMMON_SETTRIG_SETTRIG1_SHIFT        (1U)
/*! SETTRIG1 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG1(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG1_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG1_MASK)

#define DMA_COMMON_SETTRIG_SETTRIG2_MASK         (0x4U)
#define DMA_COMMON_SETTRIG_SETTRIG2_SHIFT        (2U)
/*! SETTRIG2 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG2(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG2_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG2_MASK)

#define DMA_COMMON_SETTRIG_SETTRIG3_MASK         (0x8U)
#define DMA_COMMON_SETTRIG_SETTRIG3_SHIFT        (3U)
/*! SETTRIG3 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG3(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG3_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG3_MASK)

#define DMA_COMMON_SETTRIG_SETTRIG4_MASK         (0x10U)
#define DMA_COMMON_SETTRIG_SETTRIG4_SHIFT        (4U)
/*! SETTRIG4 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG4(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG4_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG4_MASK)

#define DMA_COMMON_SETTRIG_SETTRIG5_MASK         (0x20U)
#define DMA_COMMON_SETTRIG_SETTRIG5_SHIFT        (5U)
/*! SETTRIG5 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG5(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG5_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG5_MASK)

#define DMA_COMMON_SETTRIG_SETTRIG6_MASK         (0x40U)
#define DMA_COMMON_SETTRIG_SETTRIG6_SHIFT        (6U)
/*! SETTRIG6 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG6(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG6_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG6_MASK)

#define DMA_COMMON_SETTRIG_SETTRIG7_MASK         (0x80U)
#define DMA_COMMON_SETTRIG_SETTRIG7_SHIFT        (7U)
/*! SETTRIG7 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG7(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG7_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG7_MASK)

#define DMA_COMMON_SETTRIG_SETTRIG8_MASK         (0x100U)
#define DMA_COMMON_SETTRIG_SETTRIG8_SHIFT        (8U)
/*! SETTRIG8 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG8(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG8_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG8_MASK)

#define DMA_COMMON_SETTRIG_SETTRIG9_MASK         (0x200U)
#define DMA_COMMON_SETTRIG_SETTRIG9_SHIFT        (9U)
/*! SETTRIG9 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG9(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG9_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG9_MASK)

#define DMA_COMMON_SETTRIG_SETTRIG10_MASK        (0x400U)
#define DMA_COMMON_SETTRIG_SETTRIG10_SHIFT       (10U)
/*! SETTRIG10 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG10(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG10_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG10_MASK)

#define DMA_COMMON_SETTRIG_SETTRIG11_MASK        (0x800U)
#define DMA_COMMON_SETTRIG_SETTRIG11_SHIFT       (11U)
/*! SETTRIG11 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG11(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG11_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG11_MASK)

#define DMA_COMMON_SETTRIG_SETTRIG12_MASK        (0x1000U)
#define DMA_COMMON_SETTRIG_SETTRIG12_SHIFT       (12U)
/*! SETTRIG12 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG12(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG12_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG12_MASK)

#define DMA_COMMON_SETTRIG_SETTRIG13_MASK        (0x2000U)
#define DMA_COMMON_SETTRIG_SETTRIG13_SHIFT       (13U)
/*! SETTRIG13 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG13(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG13_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG13_MASK)

#define DMA_COMMON_SETTRIG_SETTRIG14_MASK        (0x4000U)
#define DMA_COMMON_SETTRIG_SETTRIG14_SHIFT       (14U)
/*! SETTRIG14 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG14(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG14_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG14_MASK)

#define DMA_COMMON_SETTRIG_SETTRIG15_MASK        (0x8000U)
#define DMA_COMMON_SETTRIG_SETTRIG15_SHIFT       (15U)
/*! SETTRIG15 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG15(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG15_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG15_MASK)

#define DMA_COMMON_SETTRIG_SETTRIG16_MASK        (0x10000U)
#define DMA_COMMON_SETTRIG_SETTRIG16_SHIFT       (16U)
/*! SETTRIG16 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG16(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG16_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG16_MASK)

#define DMA_COMMON_SETTRIG_SETTRIG17_MASK        (0x20000U)
#define DMA_COMMON_SETTRIG_SETTRIG17_SHIFT       (17U)
/*! SETTRIG17 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG17(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG17_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG17_MASK)

#define DMA_COMMON_SETTRIG_SETTRIG18_MASK        (0x40000U)
#define DMA_COMMON_SETTRIG_SETTRIG18_SHIFT       (18U)
/*! SETTRIG18 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG18(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG18_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG18_MASK)

#define DMA_COMMON_SETTRIG_SETTRIG19_MASK        (0x80000U)
#define DMA_COMMON_SETTRIG_SETTRIG19_SHIFT       (19U)
/*! SETTRIG19 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG19(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG19_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG19_MASK)

#define DMA_COMMON_SETTRIG_SETTRIG20_MASK        (0x100000U)
#define DMA_COMMON_SETTRIG_SETTRIG20_SHIFT       (20U)
/*! SETTRIG20 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG20(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG20_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG20_MASK)

#define DMA_COMMON_SETTRIG_SETTRIG21_MASK        (0x200000U)
#define DMA_COMMON_SETTRIG_SETTRIG21_SHIFT       (21U)
/*! SETTRIG21 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG21(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG21_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG21_MASK)

#define DMA_COMMON_SETTRIG_SETTRIG22_MASK        (0x400000U)
#define DMA_COMMON_SETTRIG_SETTRIG22_SHIFT       (22U)
/*! SETTRIG22 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG22(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG22_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG22_MASK)

#define DMA_COMMON_SETTRIG_SETTRIG23_MASK        (0x800000U)
#define DMA_COMMON_SETTRIG_SETTRIG23_SHIFT       (23U)
/*! SETTRIG23 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG23(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG23_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG23_MASK)

#define DMA_COMMON_SETTRIG_SETTRIG24_MASK        (0x1000000U)
#define DMA_COMMON_SETTRIG_SETTRIG24_SHIFT       (24U)
/*! SETTRIG24 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG24(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG24_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG24_MASK)

#define DMA_COMMON_SETTRIG_SETTRIG25_MASK        (0x2000000U)
#define DMA_COMMON_SETTRIG_SETTRIG25_SHIFT       (25U)
/*! SETTRIG25 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG25(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG25_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG25_MASK)

#define DMA_COMMON_SETTRIG_SETTRIG26_MASK        (0x4000000U)
#define DMA_COMMON_SETTRIG_SETTRIG26_SHIFT       (26U)
/*! SETTRIG26 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG26(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG26_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG26_MASK)

#define DMA_COMMON_SETTRIG_SETTRIG27_MASK        (0x8000000U)
#define DMA_COMMON_SETTRIG_SETTRIG27_SHIFT       (27U)
/*! SETTRIG27 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG27(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG27_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG27_MASK)

#define DMA_COMMON_SETTRIG_SETTRIG28_MASK        (0x10000000U)
#define DMA_COMMON_SETTRIG_SETTRIG28_SHIFT       (28U)
/*! SETTRIG28 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG28(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG28_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG28_MASK)

#define DMA_COMMON_SETTRIG_SETTRIG29_MASK        (0x20000000U)
#define DMA_COMMON_SETTRIG_SETTRIG29_SHIFT       (29U)
/*! SETTRIG29 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG29(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG29_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG29_MASK)

#define DMA_COMMON_SETTRIG_SETTRIG30_MASK        (0x40000000U)
#define DMA_COMMON_SETTRIG_SETTRIG30_SHIFT       (30U)
/*! SETTRIG30 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG30(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG30_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG30_MASK)

#define DMA_COMMON_SETTRIG_SETTRIG31_MASK        (0x80000000U)
#define DMA_COMMON_SETTRIG_SETTRIG31_SHIFT       (31U)
/*! SETTRIG31 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG31(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG31_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG31_MASK)
/*! @} */

/* The count of DMA_COMMON_SETTRIG */
#define DMA_COMMON_SETTRIG_COUNT                 (1U)

/*! @name COMMON_SETTRIG1 - Set Trigger control bits for all DMA channels */
/*! @{ */

#define DMA_COMMON_SETTRIG1_SETTRIG32_MASK       (0x1U)
#define DMA_COMMON_SETTRIG1_SETTRIG32_SHIFT      (0U)
/*! SETTRIG32 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG1_SETTRIG32(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG1_SETTRIG32_SHIFT)) & DMA_COMMON_SETTRIG1_SETTRIG32_MASK)

#define DMA_COMMON_SETTRIG1_SETTRIG33_MASK       (0x2U)
#define DMA_COMMON_SETTRIG1_SETTRIG33_SHIFT      (1U)
/*! SETTRIG33 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG1_SETTRIG33(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG1_SETTRIG33_SHIFT)) & DMA_COMMON_SETTRIG1_SETTRIG33_MASK)

#define DMA_COMMON_SETTRIG1_SETTRIG34_MASK       (0x4U)
#define DMA_COMMON_SETTRIG1_SETTRIG34_SHIFT      (2U)
/*! SETTRIG34 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG1_SETTRIG34(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG1_SETTRIG34_SHIFT)) & DMA_COMMON_SETTRIG1_SETTRIG34_MASK)

#define DMA_COMMON_SETTRIG1_SETTRIG35_MASK       (0x8U)
#define DMA_COMMON_SETTRIG1_SETTRIG35_SHIFT      (3U)
/*! SETTRIG35 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG1_SETTRIG35(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG1_SETTRIG35_SHIFT)) & DMA_COMMON_SETTRIG1_SETTRIG35_MASK)

#define DMA_COMMON_SETTRIG1_SETTRIG36_MASK       (0x10U)
#define DMA_COMMON_SETTRIG1_SETTRIG36_SHIFT      (4U)
/*! SETTRIG36 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG1_SETTRIG36(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG1_SETTRIG36_SHIFT)) & DMA_COMMON_SETTRIG1_SETTRIG36_MASK)

#define DMA_COMMON_SETTRIG1_SETTRIG37_MASK       (0x20U)
#define DMA_COMMON_SETTRIG1_SETTRIG37_SHIFT      (5U)
/*! SETTRIG37 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG1_SETTRIG37(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG1_SETTRIG37_SHIFT)) & DMA_COMMON_SETTRIG1_SETTRIG37_MASK)

#define DMA_COMMON_SETTRIG1_SETTRIG38_MASK       (0x40U)
#define DMA_COMMON_SETTRIG1_SETTRIG38_SHIFT      (6U)
/*! SETTRIG38 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG1_SETTRIG38(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG1_SETTRIG38_SHIFT)) & DMA_COMMON_SETTRIG1_SETTRIG38_MASK)

#define DMA_COMMON_SETTRIG1_SETTRIG39_MASK       (0x80U)
#define DMA_COMMON_SETTRIG1_SETTRIG39_SHIFT      (7U)
/*! SETTRIG39 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG1_SETTRIG39(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG1_SETTRIG39_SHIFT)) & DMA_COMMON_SETTRIG1_SETTRIG39_MASK)

#define DMA_COMMON_SETTRIG1_SETTRIG40_MASK       (0x100U)
#define DMA_COMMON_SETTRIG1_SETTRIG40_SHIFT      (8U)
/*! SETTRIG40 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG1_SETTRIG40(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG1_SETTRIG40_SHIFT)) & DMA_COMMON_SETTRIG1_SETTRIG40_MASK)

#define DMA_COMMON_SETTRIG1_SETTRIG41_MASK       (0x200U)
#define DMA_COMMON_SETTRIG1_SETTRIG41_SHIFT      (9U)
/*! SETTRIG41 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG1_SETTRIG41(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG1_SETTRIG41_SHIFT)) & DMA_COMMON_SETTRIG1_SETTRIG41_MASK)

#define DMA_COMMON_SETTRIG1_SETTRIG42_MASK       (0x400U)
#define DMA_COMMON_SETTRIG1_SETTRIG42_SHIFT      (10U)
/*! SETTRIG42 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG1_SETTRIG42(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG1_SETTRIG42_SHIFT)) & DMA_COMMON_SETTRIG1_SETTRIG42_MASK)

#define DMA_COMMON_SETTRIG1_SETTRIG43_MASK       (0x800U)
#define DMA_COMMON_SETTRIG1_SETTRIG43_SHIFT      (11U)
/*! SETTRIG43 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG1_SETTRIG43(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG1_SETTRIG43_SHIFT)) & DMA_COMMON_SETTRIG1_SETTRIG43_MASK)

#define DMA_COMMON_SETTRIG1_SETTRIG44_MASK       (0x1000U)
#define DMA_COMMON_SETTRIG1_SETTRIG44_SHIFT      (12U)
/*! SETTRIG44 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG1_SETTRIG44(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG1_SETTRIG44_SHIFT)) & DMA_COMMON_SETTRIG1_SETTRIG44_MASK)

#define DMA_COMMON_SETTRIG1_SETTRIG45_MASK       (0x2000U)
#define DMA_COMMON_SETTRIG1_SETTRIG45_SHIFT      (13U)
/*! SETTRIG45 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG1_SETTRIG45(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG1_SETTRIG45_SHIFT)) & DMA_COMMON_SETTRIG1_SETTRIG45_MASK)

#define DMA_COMMON_SETTRIG1_SETTRIG46_MASK       (0x4000U)
#define DMA_COMMON_SETTRIG1_SETTRIG46_SHIFT      (14U)
/*! SETTRIG46 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG1_SETTRIG46(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG1_SETTRIG46_SHIFT)) & DMA_COMMON_SETTRIG1_SETTRIG46_MASK)

#define DMA_COMMON_SETTRIG1_SETTRIG47_MASK       (0x8000U)
#define DMA_COMMON_SETTRIG1_SETTRIG47_SHIFT      (15U)
/*! SETTRIG47 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG1_SETTRIG47(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG1_SETTRIG47_SHIFT)) & DMA_COMMON_SETTRIG1_SETTRIG47_MASK)

#define DMA_COMMON_SETTRIG1_SETTRIG48_MASK       (0x10000U)
#define DMA_COMMON_SETTRIG1_SETTRIG48_SHIFT      (16U)
/*! SETTRIG48 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG1_SETTRIG48(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG1_SETTRIG48_SHIFT)) & DMA_COMMON_SETTRIG1_SETTRIG48_MASK)

#define DMA_COMMON_SETTRIG1_SETTRIG49_MASK       (0x20000U)
#define DMA_COMMON_SETTRIG1_SETTRIG49_SHIFT      (17U)
/*! SETTRIG49 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG1_SETTRIG49(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG1_SETTRIG49_SHIFT)) & DMA_COMMON_SETTRIG1_SETTRIG49_MASK)

#define DMA_COMMON_SETTRIG1_SETTRIG50_MASK       (0x40000U)
#define DMA_COMMON_SETTRIG1_SETTRIG50_SHIFT      (18U)
/*! SETTRIG50 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG1_SETTRIG50(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG1_SETTRIG50_SHIFT)) & DMA_COMMON_SETTRIG1_SETTRIG50_MASK)

#define DMA_COMMON_SETTRIG1_SETTRIG51_MASK       (0x80000U)
#define DMA_COMMON_SETTRIG1_SETTRIG51_SHIFT      (19U)
/*! SETTRIG51 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG1_SETTRIG51(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG1_SETTRIG51_SHIFT)) & DMA_COMMON_SETTRIG1_SETTRIG51_MASK)
/*! @} */

/* The count of DMA_COMMON_SETTRIG1 */
#define DMA_COMMON_SETTRIG1_COUNT                (1U)

/*! @name COMMON_ABORT - Channel Abort control for all DMA channels */
/*! @{ */

#define DMA_COMMON_ABORT_ABORT0_MASK             (0x1U)
#define DMA_COMMON_ABORT_ABORT0_SHIFT            (0U)
/*! ABORT0 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT0(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT0_SHIFT)) & DMA_COMMON_ABORT_ABORT0_MASK)

#define DMA_COMMON_ABORT_ABORT1_MASK             (0x2U)
#define DMA_COMMON_ABORT_ABORT1_SHIFT            (1U)
/*! ABORT1 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT1(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT1_SHIFT)) & DMA_COMMON_ABORT_ABORT1_MASK)

#define DMA_COMMON_ABORT_ABORT2_MASK             (0x4U)
#define DMA_COMMON_ABORT_ABORT2_SHIFT            (2U)
/*! ABORT2 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT2(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT2_SHIFT)) & DMA_COMMON_ABORT_ABORT2_MASK)

#define DMA_COMMON_ABORT_ABORT3_MASK             (0x8U)
#define DMA_COMMON_ABORT_ABORT3_SHIFT            (3U)
/*! ABORT3 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT3(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT3_SHIFT)) & DMA_COMMON_ABORT_ABORT3_MASK)

#define DMA_COMMON_ABORT_ABORT4_MASK             (0x10U)
#define DMA_COMMON_ABORT_ABORT4_SHIFT            (4U)
/*! ABORT4 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT4(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT4_SHIFT)) & DMA_COMMON_ABORT_ABORT4_MASK)

#define DMA_COMMON_ABORT_ABORT5_MASK             (0x20U)
#define DMA_COMMON_ABORT_ABORT5_SHIFT            (5U)
/*! ABORT5 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT5(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT5_SHIFT)) & DMA_COMMON_ABORT_ABORT5_MASK)

#define DMA_COMMON_ABORT_ABORT6_MASK             (0x40U)
#define DMA_COMMON_ABORT_ABORT6_SHIFT            (6U)
/*! ABORT6 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT6(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT6_SHIFT)) & DMA_COMMON_ABORT_ABORT6_MASK)

#define DMA_COMMON_ABORT_ABORT7_MASK             (0x80U)
#define DMA_COMMON_ABORT_ABORT7_SHIFT            (7U)
/*! ABORT7 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT7(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT7_SHIFT)) & DMA_COMMON_ABORT_ABORT7_MASK)

#define DMA_COMMON_ABORT_ABORT8_MASK             (0x100U)
#define DMA_COMMON_ABORT_ABORT8_SHIFT            (8U)
/*! ABORT8 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT8(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT8_SHIFT)) & DMA_COMMON_ABORT_ABORT8_MASK)

#define DMA_COMMON_ABORT_ABORT9_MASK             (0x200U)
#define DMA_COMMON_ABORT_ABORT9_SHIFT            (9U)
/*! ABORT9 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT9(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT9_SHIFT)) & DMA_COMMON_ABORT_ABORT9_MASK)

#define DMA_COMMON_ABORT_ABORT10_MASK            (0x400U)
#define DMA_COMMON_ABORT_ABORT10_SHIFT           (10U)
/*! ABORT10 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT10(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT10_SHIFT)) & DMA_COMMON_ABORT_ABORT10_MASK)

#define DMA_COMMON_ABORT_ABORT11_MASK            (0x800U)
#define DMA_COMMON_ABORT_ABORT11_SHIFT           (11U)
/*! ABORT11 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT11(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT11_SHIFT)) & DMA_COMMON_ABORT_ABORT11_MASK)

#define DMA_COMMON_ABORT_ABORT12_MASK            (0x1000U)
#define DMA_COMMON_ABORT_ABORT12_SHIFT           (12U)
/*! ABORT12 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT12(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT12_SHIFT)) & DMA_COMMON_ABORT_ABORT12_MASK)

#define DMA_COMMON_ABORT_ABORT13_MASK            (0x2000U)
#define DMA_COMMON_ABORT_ABORT13_SHIFT           (13U)
/*! ABORT13 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT13(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT13_SHIFT)) & DMA_COMMON_ABORT_ABORT13_MASK)

#define DMA_COMMON_ABORT_ABORT14_MASK            (0x4000U)
#define DMA_COMMON_ABORT_ABORT14_SHIFT           (14U)
/*! ABORT14 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT14(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT14_SHIFT)) & DMA_COMMON_ABORT_ABORT14_MASK)

#define DMA_COMMON_ABORT_ABORT15_MASK            (0x8000U)
#define DMA_COMMON_ABORT_ABORT15_SHIFT           (15U)
/*! ABORT15 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT15(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT15_SHIFT)) & DMA_COMMON_ABORT_ABORT15_MASK)

#define DMA_COMMON_ABORT_ABORT16_MASK            (0x10000U)
#define DMA_COMMON_ABORT_ABORT16_SHIFT           (16U)
/*! ABORT16 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT16(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT16_SHIFT)) & DMA_COMMON_ABORT_ABORT16_MASK)

#define DMA_COMMON_ABORT_ABORT17_MASK            (0x20000U)
#define DMA_COMMON_ABORT_ABORT17_SHIFT           (17U)
/*! ABORT17 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT17(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT17_SHIFT)) & DMA_COMMON_ABORT_ABORT17_MASK)

#define DMA_COMMON_ABORT_ABORT18_MASK            (0x40000U)
#define DMA_COMMON_ABORT_ABORT18_SHIFT           (18U)
/*! ABORT18 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT18(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT18_SHIFT)) & DMA_COMMON_ABORT_ABORT18_MASK)

#define DMA_COMMON_ABORT_ABORT19_MASK            (0x80000U)
#define DMA_COMMON_ABORT_ABORT19_SHIFT           (19U)
/*! ABORT19 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT19(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT19_SHIFT)) & DMA_COMMON_ABORT_ABORT19_MASK)

#define DMA_COMMON_ABORT_ABORT20_MASK            (0x100000U)
#define DMA_COMMON_ABORT_ABORT20_SHIFT           (20U)
/*! ABORT20 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT20(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT20_SHIFT)) & DMA_COMMON_ABORT_ABORT20_MASK)

#define DMA_COMMON_ABORT_ABORT21_MASK            (0x200000U)
#define DMA_COMMON_ABORT_ABORT21_SHIFT           (21U)
/*! ABORT21 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT21(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT21_SHIFT)) & DMA_COMMON_ABORT_ABORT21_MASK)

#define DMA_COMMON_ABORT_ABORT22_MASK            (0x400000U)
#define DMA_COMMON_ABORT_ABORT22_SHIFT           (22U)
/*! ABORT22 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT22(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT22_SHIFT)) & DMA_COMMON_ABORT_ABORT22_MASK)

#define DMA_COMMON_ABORT_ABORT23_MASK            (0x800000U)
#define DMA_COMMON_ABORT_ABORT23_SHIFT           (23U)
/*! ABORT23 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT23(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT23_SHIFT)) & DMA_COMMON_ABORT_ABORT23_MASK)

#define DMA_COMMON_ABORT_ABORT24_MASK            (0x1000000U)
#define DMA_COMMON_ABORT_ABORT24_SHIFT           (24U)
/*! ABORT24 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT24(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT24_SHIFT)) & DMA_COMMON_ABORT_ABORT24_MASK)

#define DMA_COMMON_ABORT_ABORT25_MASK            (0x2000000U)
#define DMA_COMMON_ABORT_ABORT25_SHIFT           (25U)
/*! ABORT25 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT25(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT25_SHIFT)) & DMA_COMMON_ABORT_ABORT25_MASK)

#define DMA_COMMON_ABORT_ABORT26_MASK            (0x4000000U)
#define DMA_COMMON_ABORT_ABORT26_SHIFT           (26U)
/*! ABORT26 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT26(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT26_SHIFT)) & DMA_COMMON_ABORT_ABORT26_MASK)

#define DMA_COMMON_ABORT_ABORT27_MASK            (0x8000000U)
#define DMA_COMMON_ABORT_ABORT27_SHIFT           (27U)
/*! ABORT27 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT27(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT27_SHIFT)) & DMA_COMMON_ABORT_ABORT27_MASK)

#define DMA_COMMON_ABORT_ABORT28_MASK            (0x10000000U)
#define DMA_COMMON_ABORT_ABORT28_SHIFT           (28U)
/*! ABORT28 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT28(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT28_SHIFT)) & DMA_COMMON_ABORT_ABORT28_MASK)

#define DMA_COMMON_ABORT_ABORT29_MASK            (0x20000000U)
#define DMA_COMMON_ABORT_ABORT29_SHIFT           (29U)
/*! ABORT29 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT29(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT29_SHIFT)) & DMA_COMMON_ABORT_ABORT29_MASK)

#define DMA_COMMON_ABORT_ABORT30_MASK            (0x40000000U)
#define DMA_COMMON_ABORT_ABORT30_SHIFT           (30U)
/*! ABORT30 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT30(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT30_SHIFT)) & DMA_COMMON_ABORT_ABORT30_MASK)

#define DMA_COMMON_ABORT_ABORT31_MASK            (0x80000000U)
#define DMA_COMMON_ABORT_ABORT31_SHIFT           (31U)
/*! ABORT31 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT31(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT31_SHIFT)) & DMA_COMMON_ABORT_ABORT31_MASK)
/*! @} */

/* The count of DMA_COMMON_ABORT */
#define DMA_COMMON_ABORT_COUNT                   (1U)

/*! @name COMMON_ABORT1 - Channel Abort control for all DMA channels */
/*! @{ */

#define DMA_COMMON_ABORT1_ABORT32_MASK           (0x1U)
#define DMA_COMMON_ABORT1_ABORT32_SHIFT          (0U)
/*! ABORT32 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT1_ABORT32(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT1_ABORT32_SHIFT)) & DMA_COMMON_ABORT1_ABORT32_MASK)

#define DMA_COMMON_ABORT1_ABORT33_MASK           (0x2U)
#define DMA_COMMON_ABORT1_ABORT33_SHIFT          (1U)
/*! ABORT33 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT1_ABORT33(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT1_ABORT33_SHIFT)) & DMA_COMMON_ABORT1_ABORT33_MASK)

#define DMA_COMMON_ABORT1_ABORT34_MASK           (0x4U)
#define DMA_COMMON_ABORT1_ABORT34_SHIFT          (2U)
/*! ABORT34 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT1_ABORT34(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT1_ABORT34_SHIFT)) & DMA_COMMON_ABORT1_ABORT34_MASK)

#define DMA_COMMON_ABORT1_ABORT35_MASK           (0x8U)
#define DMA_COMMON_ABORT1_ABORT35_SHIFT          (3U)
/*! ABORT35 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT1_ABORT35(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT1_ABORT35_SHIFT)) & DMA_COMMON_ABORT1_ABORT35_MASK)

#define DMA_COMMON_ABORT1_ABORT36_MASK           (0x10U)
#define DMA_COMMON_ABORT1_ABORT36_SHIFT          (4U)
/*! ABORT36 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT1_ABORT36(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT1_ABORT36_SHIFT)) & DMA_COMMON_ABORT1_ABORT36_MASK)

#define DMA_COMMON_ABORT1_ABORT37_MASK           (0x20U)
#define DMA_COMMON_ABORT1_ABORT37_SHIFT          (5U)
/*! ABORT37 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT1_ABORT37(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT1_ABORT37_SHIFT)) & DMA_COMMON_ABORT1_ABORT37_MASK)

#define DMA_COMMON_ABORT1_ABORT38_MASK           (0x40U)
#define DMA_COMMON_ABORT1_ABORT38_SHIFT          (6U)
/*! ABORT38 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT1_ABORT38(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT1_ABORT38_SHIFT)) & DMA_COMMON_ABORT1_ABORT38_MASK)

#define DMA_COMMON_ABORT1_ABORT39_MASK           (0x80U)
#define DMA_COMMON_ABORT1_ABORT39_SHIFT          (7U)
/*! ABORT39 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT1_ABORT39(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT1_ABORT39_SHIFT)) & DMA_COMMON_ABORT1_ABORT39_MASK)

#define DMA_COMMON_ABORT1_ABORT40_MASK           (0x100U)
#define DMA_COMMON_ABORT1_ABORT40_SHIFT          (8U)
/*! ABORT40 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT1_ABORT40(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT1_ABORT40_SHIFT)) & DMA_COMMON_ABORT1_ABORT40_MASK)

#define DMA_COMMON_ABORT1_ABORT41_MASK           (0x200U)
#define DMA_COMMON_ABORT1_ABORT41_SHIFT          (9U)
/*! ABORT41 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT1_ABORT41(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT1_ABORT41_SHIFT)) & DMA_COMMON_ABORT1_ABORT41_MASK)

#define DMA_COMMON_ABORT1_ABORT42_MASK           (0x400U)
#define DMA_COMMON_ABORT1_ABORT42_SHIFT          (10U)
/*! ABORT42 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT1_ABORT42(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT1_ABORT42_SHIFT)) & DMA_COMMON_ABORT1_ABORT42_MASK)

#define DMA_COMMON_ABORT1_ABORT43_MASK           (0x800U)
#define DMA_COMMON_ABORT1_ABORT43_SHIFT          (11U)
/*! ABORT43 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT1_ABORT43(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT1_ABORT43_SHIFT)) & DMA_COMMON_ABORT1_ABORT43_MASK)

#define DMA_COMMON_ABORT1_ABORT44_MASK           (0x1000U)
#define DMA_COMMON_ABORT1_ABORT44_SHIFT          (12U)
/*! ABORT44 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT1_ABORT44(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT1_ABORT44_SHIFT)) & DMA_COMMON_ABORT1_ABORT44_MASK)

#define DMA_COMMON_ABORT1_ABORT45_MASK           (0x2000U)
#define DMA_COMMON_ABORT1_ABORT45_SHIFT          (13U)
/*! ABORT45 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT1_ABORT45(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT1_ABORT45_SHIFT)) & DMA_COMMON_ABORT1_ABORT45_MASK)

#define DMA_COMMON_ABORT1_ABORT46_MASK           (0x4000U)
#define DMA_COMMON_ABORT1_ABORT46_SHIFT          (14U)
/*! ABORT46 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT1_ABORT46(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT1_ABORT46_SHIFT)) & DMA_COMMON_ABORT1_ABORT46_MASK)

#define DMA_COMMON_ABORT1_ABORT47_MASK           (0x8000U)
#define DMA_COMMON_ABORT1_ABORT47_SHIFT          (15U)
/*! ABORT47 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT1_ABORT47(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT1_ABORT47_SHIFT)) & DMA_COMMON_ABORT1_ABORT47_MASK)

#define DMA_COMMON_ABORT1_ABORT48_MASK           (0x10000U)
#define DMA_COMMON_ABORT1_ABORT48_SHIFT          (16U)
/*! ABORT48 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT1_ABORT48(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT1_ABORT48_SHIFT)) & DMA_COMMON_ABORT1_ABORT48_MASK)

#define DMA_COMMON_ABORT1_ABORT49_MASK           (0x20000U)
#define DMA_COMMON_ABORT1_ABORT49_SHIFT          (17U)
/*! ABORT49 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT1_ABORT49(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT1_ABORT49_SHIFT)) & DMA_COMMON_ABORT1_ABORT49_MASK)

#define DMA_COMMON_ABORT1_ABORT50_MASK           (0x40000U)
#define DMA_COMMON_ABORT1_ABORT50_SHIFT          (18U)
/*! ABORT50 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT1_ABORT50(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT1_ABORT50_SHIFT)) & DMA_COMMON_ABORT1_ABORT50_MASK)

#define DMA_COMMON_ABORT1_ABORT51_MASK           (0x80000U)
#define DMA_COMMON_ABORT1_ABORT51_SHIFT          (19U)
/*! ABORT51 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT1_ABORT51(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT1_ABORT51_SHIFT)) & DMA_COMMON_ABORT1_ABORT51_MASK)
/*! @} */

/* The count of DMA_COMMON_ABORT1 */
#define DMA_COMMON_ABORT1_COUNT                  (1U)

/*! @name CHANNEL_CFG - Configuration register for DMA channel */
/*! @{ */

#define DMA_CHANNEL_CFG_PERIPHREQEN_MASK         (0x1U)
#define DMA_CHANNEL_CFG_PERIPHREQEN_SHIFT        (0U)
/*! PERIPHREQEN - Peripheral request Enable.
 *  0b0..Peripheral DMA requests disabled.
 *  0b1..Peripheral DMA requests enabled.
 */
#define DMA_CHANNEL_CFG_PERIPHREQEN(x)           (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_PERIPHREQEN_SHIFT)) & DMA_CHANNEL_CFG_PERIPHREQEN_MASK)

#define DMA_CHANNEL_CFG_HWTRIGEN_MASK            (0x2U)
#define DMA_CHANNEL_CFG_HWTRIGEN_SHIFT           (1U)
/*! HWTRIGEN - Hardware Triggering Enable for channel.
 *  0b0..Hardware triggering not used for channel.
 *  0b1..Hardware triggering used for channel.
 */
#define DMA_CHANNEL_CFG_HWTRIGEN(x)              (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_HWTRIGEN_SHIFT)) & DMA_CHANNEL_CFG_HWTRIGEN_MASK)

#define DMA_CHANNEL_CFG_TRIGPOL_MASK             (0x10U)
#define DMA_CHANNEL_CFG_TRIGPOL_SHIFT            (4U)
/*! TRIGPOL - Trigger Polarity.
 *  0b0..Active low - falling edge. Hardware trigger is active low or falling edge triggered, based on TRIGTYPE.
 *  0b1..Active high - rising edge. Hardware trigger is active high or rising edge triggered, based on TRIGTYPE.
 */
#define DMA_CHANNEL_CFG_TRIGPOL(x)               (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_TRIGPOL_SHIFT)) & DMA_CHANNEL_CFG_TRIGPOL_MASK)

#define DMA_CHANNEL_CFG_TRIGTYPE_MASK            (0x20U)
#define DMA_CHANNEL_CFG_TRIGTYPE_SHIFT           (5U)
/*! TRIGTYPE - Trigger Type.
 *  0b0..Edge. Hardware trigger is edge triggered. Transfers will be initiated and completed, as specified for a single trigger.
 *  0b1..Level.
 */
#define DMA_CHANNEL_CFG_TRIGTYPE(x)              (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_TRIGTYPE_SHIFT)) & DMA_CHANNEL_CFG_TRIGTYPE_MASK)

#define DMA_CHANNEL_CFG_TRIGBURST_MASK           (0x40U)
#define DMA_CHANNEL_CFG_TRIGBURST_SHIFT          (6U)
/*! TRIGBURST - Trigger Burst.
 *  0b0..Single transfer.
 *  0b1..Burst transfer.
 */
#define DMA_CHANNEL_CFG_TRIGBURST(x)             (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_TRIGBURST_SHIFT)) & DMA_CHANNEL_CFG_TRIGBURST_MASK)

#define DMA_CHANNEL_CFG_BURSTPOWER_MASK          (0xF00U)
#define DMA_CHANNEL_CFG_BURSTPOWER_SHIFT         (8U)
/*! BURSTPOWER - Burst Power.
 */
#define DMA_CHANNEL_CFG_BURSTPOWER(x)            (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_BURSTPOWER_SHIFT)) & DMA_CHANNEL_CFG_BURSTPOWER_MASK)

#define DMA_CHANNEL_CFG_SRCBURSTWRAP_MASK        (0x4000U)
#define DMA_CHANNEL_CFG_SRCBURSTWRAP_SHIFT       (14U)
/*! SRCBURSTWRAP - Source Burst Wrap.
 *  0b0..Disabled.
 *  0b1..Enabled.
 */
#define DMA_CHANNEL_CFG_SRCBURSTWRAP(x)          (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_SRCBURSTWRAP_SHIFT)) & DMA_CHANNEL_CFG_SRCBURSTWRAP_MASK)

#define DMA_CHANNEL_CFG_DSTBURSTWRAP_MASK        (0x8000U)
#define DMA_CHANNEL_CFG_DSTBURSTWRAP_SHIFT       (15U)
/*! DSTBURSTWRAP - Destination Burst Wrap.
 *  0b0..Disabled. Destination burst wrapping is not enabled for this DMA channel.
 *  0b1..Enabled. Destination burst wrapping is enabled for this DMA channel.
 */
#define DMA_CHANNEL_CFG_DSTBURSTWRAP(x)          (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_DSTBURSTWRAP_SHIFT)) & DMA_CHANNEL_CFG_DSTBURSTWRAP_MASK)

#define DMA_CHANNEL_CFG_CHPRIORITY_MASK          (0x70000U)
#define DMA_CHANNEL_CFG_CHPRIORITY_SHIFT         (16U)
/*! CHPRIORITY - Priority of channel when multiple DMA requests are pending.
 */
#define DMA_CHANNEL_CFG_CHPRIORITY(x)            (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_CHPRIORITY_SHIFT)) & DMA_CHANNEL_CFG_CHPRIORITY_MASK)
/*! @} */

/* The count of DMA_CHANNEL_CFG */
#define DMA_CHANNEL_CFG_COUNT                    (52U)

/*! @name CHANNEL_CTLSTAT - Control and status register for DMA channel */
/*! @{ */

#define DMA_CHANNEL_CTLSTAT_VALIDPENDING_MASK    (0x1U)
#define DMA_CHANNEL_CTLSTAT_VALIDPENDING_SHIFT   (0U)
/*! VALIDPENDING - Valid pending flag for this channel.
 *  0b0..No effect on DMA operation.
 *  0b1..Valid pending.
 */
#define DMA_CHANNEL_CTLSTAT_VALIDPENDING(x)      (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CTLSTAT_VALIDPENDING_SHIFT)) & DMA_CHANNEL_CTLSTAT_VALIDPENDING_MASK)

#define DMA_CHANNEL_CTLSTAT_TRIG_MASK            (0x4U)
#define DMA_CHANNEL_CTLSTAT_TRIG_SHIFT           (2U)
/*! TRIG - Trigger flag.
 *  0b0..Not triggered. The trigger for this DMA channel is not set. DMA operations will not be carried out.
 *  0b1..Triggered. The trigger for this DMA channel is set. DMA operations will be carried out.
 */
#define DMA_CHANNEL_CTLSTAT_TRIG(x)              (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CTLSTAT_TRIG_SHIFT)) & DMA_CHANNEL_CTLSTAT_TRIG_MASK)
/*! @} */

/* The count of DMA_CHANNEL_CTLSTAT */
#define DMA_CHANNEL_CTLSTAT_COUNT                (52U)

/*! @name CHANNEL_XFERCFG - Transfer configuration register for DMA channel */
/*! @{ */

#define DMA_CHANNEL_XFERCFG_CFGVALID_MASK        (0x1U)
#define DMA_CHANNEL_XFERCFG_CFGVALID_SHIFT       (0U)
/*! CFGVALID - Configuration Valid flag.
 *  0b0..Not valid.
 *  0b1..Valid.
 */
#define DMA_CHANNEL_XFERCFG_CFGVALID(x)          (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_CFGVALID_SHIFT)) & DMA_CHANNEL_XFERCFG_CFGVALID_MASK)

#define DMA_CHANNEL_XFERCFG_RELOAD_MASK          (0x2U)
#define DMA_CHANNEL_XFERCFG_RELOAD_SHIFT         (1U)
/*! RELOAD - Reload.
 *  0b0..Disabled. The channels' control structure should not be reloaded when the current descriptor is exhausted.
 *  0b1..Enabled. The channels' control structure should be reloaded when the current descriptor is exhausted.
 */
#define DMA_CHANNEL_XFERCFG_RELOAD(x)            (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_RELOAD_SHIFT)) & DMA_CHANNEL_XFERCFG_RELOAD_MASK)

#define DMA_CHANNEL_XFERCFG_SWTRIG_MASK          (0x4U)
#define DMA_CHANNEL_XFERCFG_SWTRIG_SHIFT         (2U)
/*! SWTRIG - Software Trigger.
 *  0b0..Not set.
 *  0b1..Set.
 */
#define DMA_CHANNEL_XFERCFG_SWTRIG(x)            (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_SWTRIG_SHIFT)) & DMA_CHANNEL_XFERCFG_SWTRIG_MASK)

#define DMA_CHANNEL_XFERCFG_CLRTRIG_MASK         (0x8U)
#define DMA_CHANNEL_XFERCFG_CLRTRIG_SHIFT        (3U)
/*! CLRTRIG - Clear Trigger.
 *  0b0..Not cleared.
 *  0b1..Cleared.
 */
#define DMA_CHANNEL_XFERCFG_CLRTRIG(x)           (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_CLRTRIG_SHIFT)) & DMA_CHANNEL_XFERCFG_CLRTRIG_MASK)

#define DMA_CHANNEL_XFERCFG_SETINTA_MASK         (0x10U)
#define DMA_CHANNEL_XFERCFG_SETINTA_SHIFT        (4U)
/*! SETINTA - Set Interrupt flag A for channel.
 *  0b0..No effect.
 *  0b1..Set. The INTA flag for this channel will be set when the current descriptor is exhausted.
 */
#define DMA_CHANNEL_XFERCFG_SETINTA(x)           (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_SETINTA_SHIFT)) & DMA_CHANNEL_XFERCFG_SETINTA_MASK)

#define DMA_CHANNEL_XFERCFG_SETINTB_MASK         (0x20U)
#define DMA_CHANNEL_XFERCFG_SETINTB_SHIFT        (5U)
/*! SETINTB - Set Interrupt flag B for channel.
 *  0b0..No effect.
 *  0b1..Set. The INTB flag for this channel will be set when the current descriptor is exhausted.
 */
#define DMA_CHANNEL_XFERCFG_SETINTB(x)           (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_SETINTB_SHIFT)) & DMA_CHANNEL_XFERCFG_SETINTB_MASK)

#define DMA_CHANNEL_XFERCFG_WIDTH_MASK           (0x300U)
#define DMA_CHANNEL_XFERCFG_WIDTH_SHIFT          (8U)
/*! WIDTH - Transfer width used for this DMA channel.
 *  0b00..8-bit.
 *  0b01..16-bit.
 *  0b10..32-bit.
 *  0b11..Reserved.
 */
#define DMA_CHANNEL_XFERCFG_WIDTH(x)             (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_WIDTH_SHIFT)) & DMA_CHANNEL_XFERCFG_WIDTH_MASK)

#define DMA_CHANNEL_XFERCFG_SRCINC_MASK          (0x3000U)
#define DMA_CHANNEL_XFERCFG_SRCINC_SHIFT         (12U)
/*! SRCINC - Source address increment
 *  0b00..No increment.
 *  0b01..1 x width.
 *  0b10..2 x width.
 *  0b11..4 x width.
 */
#define DMA_CHANNEL_XFERCFG_SRCINC(x)            (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_SRCINC_SHIFT)) & DMA_CHANNEL_XFERCFG_SRCINC_MASK)

#define DMA_CHANNEL_XFERCFG_DSTINC_MASK          (0xC000U)
#define DMA_CHANNEL_XFERCFG_DSTINC_SHIFT         (14U)
/*! DSTINC - Destination address increment
 *  0b00..No increment.
 *  0b01..1 x width.
 *  0b10..2 x width.
 *  0b11..4 x width.
 */
#define DMA_CHANNEL_XFERCFG_DSTINC(x)            (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_DSTINC_SHIFT)) & DMA_CHANNEL_XFERCFG_DSTINC_MASK)

#define DMA_CHANNEL_XFERCFG_XFERCOUNT_MASK       (0x3FF0000U)
#define DMA_CHANNEL_XFERCFG_XFERCOUNT_SHIFT      (16U)
/*! XFERCOUNT - Total number of transfers to be performed, minus 1 encoded.
 */
#define DMA_CHANNEL_XFERCFG_XFERCOUNT(x)         (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_XFERCOUNT_SHIFT)) & DMA_CHANNEL_XFERCFG_XFERCOUNT_MASK)
/*! @} */

/* The count of DMA_CHANNEL_XFERCFG */
#define DMA_CHANNEL_XFERCFG_COUNT                (52U)


/*!
 * @}
 */ /* end of group DMA_Register_Masks */


/* DMA - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral DMA0 base address */
  #define DMA0_BASE                                (0x50082000u)
  /** Peripheral DMA0 base address */
  #define DMA0_BASE_NS                             (0x40082000u)
  /** Peripheral DMA0 base pointer */
  #define DMA0                                     ((DMA_Type *)DMA0_BASE)
  /** Peripheral DMA0 base pointer */
  #define DMA0_NS                                  ((DMA_Type *)DMA0_BASE_NS)
  /** Peripheral DMA1 base address */
  #define DMA1_BASE                                (0x500A7000u)
  /** Peripheral DMA1 base address */
  #define DMA1_BASE_NS                             (0x400A7000u)
  /** Peripheral DMA1 base pointer */
  #define DMA1                                     ((DMA_Type *)DMA1_BASE)
  /** Peripheral DMA1 base pointer */
  #define DMA1_NS                                  ((DMA_Type *)DMA1_BASE_NS)
  /** Array initializer of DMA peripheral base addresses */
  #define DMA_BASE_ADDRS                           { DMA0_BASE, DMA1_BASE }
  /** Array initializer of DMA peripheral base pointers */
  #define DMA_BASE_PTRS                            { DMA0, DMA1 }
  /** Array initializer of DMA peripheral base addresses */
  #define DMA_BASE_ADDRS_NS                        { DMA0_BASE_NS, DMA1_BASE_NS }
  /** Array initializer of DMA peripheral base pointers */
  #define DMA_BASE_PTRS_NS                         { DMA0_NS, DMA1_NS }
#else
  /** Peripheral DMA0 base address */
  #define DMA0_BASE                                (0x40082000u)
  /** Peripheral DMA0 base pointer */
  #define DMA0                                     ((DMA_Type *)DMA0_BASE)
  /** Peripheral DMA1 base address */
  #define DMA1_BASE                                (0x400A7000u)
  /** Peripheral DMA1 base pointer */
  #define DMA1                                     ((DMA_Type *)DMA1_BASE)
  /** Array initializer of DMA peripheral base addresses */
  #define DMA_BASE_ADDRS                           { DMA0_BASE, DMA1_BASE }
  /** Array initializer of DMA peripheral base pointers */
  #define DMA_BASE_PTRS                            { DMA0, DMA1 }
#endif
/** Interrupt vectors for the DMA peripheral type */
#define DMA_IRQS                                 { DMA0_IRQn, DMA1_IRQn }

/*!
 * @}
 */ /* end of group DMA_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DMIC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMIC_Peripheral_Access_Layer DMIC Peripheral Access Layer
 * @{
 */

/** DMIC - Register Layout Typedef */
typedef struct {
  struct {                                         /* offset: 0x0, array step: 0x100 */
    __IO uint32_t OSR;                               /**< Oversample Rate, array offset: 0x0, array step: 0x100 */
    __IO uint32_t DIVHFCLK;                          /**< DMIC Clock, array offset: 0x4, array step: 0x100 */
    __IO uint32_t PREAC2FSCOEF;                      /**< Compensation Filter for 2 FS, array offset: 0x8, array step: 0x100 */
    __IO uint32_t PREAC4FSCOEF;                      /**< Compensation Filter for 4 FS, array offset: 0xC, array step: 0x100 */
    __IO uint32_t GAINSHIFT;                         /**< Decimator Gain Shift, array offset: 0x10, array step: 0x100 */
         uint8_t RESERVED_0[108];
    __IO uint32_t FIFO_CTRL;                         /**< FIFO Control, array offset: 0x80, array step: 0x100 */
    __IO uint32_t FIFO_STATUS;                       /**< FIFO Status, array offset: 0x84, array step: 0x100 */
    __I  uint32_t FIFO_DATA;                         /**< FIFO Data, array offset: 0x88, array step: 0x100 */
    __IO uint32_t PHY_CTRL;                          /**< Physical Control, array offset: 0x8C, array step: 0x100 */
    __IO uint32_t DC_CTRL;                           /**< DC Filter Control, array offset: 0x90, array step: 0x100 */
         uint8_t RESERVED_1[108];
  } CHANNEL[2];
       uint8_t RESERVED_0[3328];
  __IO uint32_t CHANEN;                            /**< Channel Enable, offset: 0xF00 */
       uint8_t RESERVED_1[12];
  __IO uint32_t USE2FS;                            /**< Use 2 FS register, offset: 0xF10 */
  __IO uint32_t GLOBAL_SYNC_EN;                    /**< Global Channel Synchronization Enable, offset: 0xF14 */
  __IO uint32_t GLOBAL_COUNT_VAL;                  /**< Global channel synchronization counter value, offset: 0xF18 */
  __IO uint32_t DECRESET;                          /**< DMIC decimator reset, offset: 0xF1C */
       uint8_t RESERVED_2[96];
  __IO uint32_t HWVADGAIN;                         /**< HWVAD Input Gain, offset: 0xF80 */
  __IO uint32_t HWVADHPFS;                         /**< HWVAD Filter Control, offset: 0xF84 */
  __IO uint32_t HWVADST10;                         /**< HWVAD Control, offset: 0xF88 */
  __IO uint32_t HWVADRSTT;                         /**< HWVAD Filter Reset, offset: 0xF8C */
  __IO uint32_t HWVADTHGN;                         /**< HWVAD Noise Estimator Gain, offset: 0xF90 */
  __IO uint32_t HWVADTHGS;                         /**< HWVAD Signal Estimator Gain, offset: 0xF94 */
  __I  uint32_t HWVADLOWZ;                         /**< HWVAD Noise Envelope Estimator, offset: 0xF98 */
} DMIC_Type;

/* ----------------------------------------------------------------------------
   -- DMIC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMIC_Register_Masks DMIC Register Masks
 * @{
 */

/*! @name CHANNEL_OSR - Oversample Rate */
/*! @{ */

#define DMIC_CHANNEL_OSR_OSR_MASK                (0xFFU)
#define DMIC_CHANNEL_OSR_OSR_SHIFT               (0U)
/*! OSR - Oversample Rate
 */
#define DMIC_CHANNEL_OSR_OSR(x)                  (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_OSR_OSR_SHIFT)) & DMIC_CHANNEL_OSR_OSR_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_OSR */
#define DMIC_CHANNEL_OSR_COUNT                   (2U)

/*! @name CHANNEL_DIVHFCLK - DMIC Clock */
/*! @{ */

#define DMIC_CHANNEL_DIVHFCLK_PDMDIV_MASK        (0xFU)
#define DMIC_CHANNEL_DIVHFCLK_PDMDIV_SHIFT       (0U)
/*! PDMDIV - PDM Clock Divider Value
 *  0b0000..Divide by 1
 *  0b0001..Divide by 2
 *  0b0010..Divide by 3
 *  0b0011..Divide by 4
 *  0b0100..Divide by 6
 *  0b0101..Divide by 8
 *  0b0110..Divide by 12
 *  0b0111..Divide by 16
 *  0b1000..Divide by 24
 *  0b1001..Divide by 32
 *  0b1010..Divide by 48
 *  0b1011..Divide by 64
 *  0b1100..Divide by 96
 *  0b1101..Divide by 128
 *  0b1110-0b1111..Reserved
 */
#define DMIC_CHANNEL_DIVHFCLK_PDMDIV(x)          (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_DIVHFCLK_PDMDIV_SHIFT)) & DMIC_CHANNEL_DIVHFCLK_PDMDIV_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_DIVHFCLK */
#define DMIC_CHANNEL_DIVHFCLK_COUNT              (2U)

/*! @name CHANNEL_PREAC2FSCOEF - Compensation Filter for 2 FS */
/*! @{ */

#define DMIC_CHANNEL_PREAC2FSCOEF_COMP_MASK      (0x3U)
#define DMIC_CHANNEL_PREAC2FSCOEF_COMP_SHIFT     (0U)
/*! COMP - Compensation value
 *  0b00..Compensation = 0. This is the recommended setting.
 *  0b01..Compensation = -0.16
 *  0b10..Compensation = -0.15
 *  0b11..Compensation = -0.13
 */
#define DMIC_CHANNEL_PREAC2FSCOEF_COMP(x)        (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_PREAC2FSCOEF_COMP_SHIFT)) & DMIC_CHANNEL_PREAC2FSCOEF_COMP_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_PREAC2FSCOEF */
#define DMIC_CHANNEL_PREAC2FSCOEF_COUNT          (2U)

/*! @name CHANNEL_PREAC4FSCOEF - Compensation Filter for 4 FS */
/*! @{ */

#define DMIC_CHANNEL_PREAC4FSCOEF_COMP_MASK      (0x3U)
#define DMIC_CHANNEL_PREAC4FSCOEF_COMP_SHIFT     (0U)
/*! COMP - Compensation value
 *  0b00..Compensation = 0. This is the recommended setting.
 *  0b01..Compensation = -0.16
 *  0b10..Compensation = -0.15
 *  0b11..Compensation = -0.13
 */
#define DMIC_CHANNEL_PREAC4FSCOEF_COMP(x)        (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_PREAC4FSCOEF_COMP_SHIFT)) & DMIC_CHANNEL_PREAC4FSCOEF_COMP_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_PREAC4FSCOEF */
#define DMIC_CHANNEL_PREAC4FSCOEF_COUNT          (2U)

/*! @name CHANNEL_GAINSHIFT - Decimator Gain Shift */
/*! @{ */

#define DMIC_CHANNEL_GAINSHIFT_GAIN_MASK         (0x1FU)
#define DMIC_CHANNEL_GAINSHIFT_GAIN_SHIFT        (0U)
/*! GAIN - Gain
 */
#define DMIC_CHANNEL_GAINSHIFT_GAIN(x)           (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_GAINSHIFT_GAIN_SHIFT)) & DMIC_CHANNEL_GAINSHIFT_GAIN_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_GAINSHIFT */
#define DMIC_CHANNEL_GAINSHIFT_COUNT             (2U)

/*! @name CHANNEL_FIFO_CTRL - FIFO Control */
/*! @{ */

#define DMIC_CHANNEL_FIFO_CTRL_ENABLE_MASK       (0x1U)
#define DMIC_CHANNEL_FIFO_CTRL_ENABLE_SHIFT      (0U)
/*! ENABLE - FIFO Enable.
 *  0b0..Disabled.
 *  0b1..FIFO is enabled. The FIFO must be enabled in order for the CPU or DMA to read data from the DMIC via the FIFODATA register.
 */
#define DMIC_CHANNEL_FIFO_CTRL_ENABLE(x)         (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_CTRL_ENABLE_SHIFT)) & DMIC_CHANNEL_FIFO_CTRL_ENABLE_MASK)

#define DMIC_CHANNEL_FIFO_CTRL_RESETN_MASK       (0x2U)
#define DMIC_CHANNEL_FIFO_CTRL_RESETN_SHIFT      (1U)
/*! RESETN - FIFO Reset
 *  0b0..Reset the FIFO. This must be cleared before resuming operation.
 *  0b1..Normal operation
 */
#define DMIC_CHANNEL_FIFO_CTRL_RESETN(x)         (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_CTRL_RESETN_SHIFT)) & DMIC_CHANNEL_FIFO_CTRL_RESETN_MASK)

#define DMIC_CHANNEL_FIFO_CTRL_INTEN_MASK        (0x4U)
#define DMIC_CHANNEL_FIFO_CTRL_INTEN_SHIFT       (2U)
/*! INTEN - Interrupt Enable.
 *  0b0..FIFO level interrupts are not enabled.
 *  0b1..FIFO level interrupts are enabled.
 */
#define DMIC_CHANNEL_FIFO_CTRL_INTEN(x)          (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_CTRL_INTEN_SHIFT)) & DMIC_CHANNEL_FIFO_CTRL_INTEN_MASK)

#define DMIC_CHANNEL_FIFO_CTRL_DMAEN_MASK        (0x8U)
#define DMIC_CHANNEL_FIFO_CTRL_DMAEN_SHIFT       (3U)
/*! DMAEN - DMA Enable
 *  0b0..DMA requests are not enabled.
 *  0b1..DMA requests based on FIFO level are enabled.
 */
#define DMIC_CHANNEL_FIFO_CTRL_DMAEN(x)          (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_CTRL_DMAEN_SHIFT)) & DMIC_CHANNEL_FIFO_CTRL_DMAEN_MASK)

#define DMIC_CHANNEL_FIFO_CTRL_TRIGLVL_MASK      (0x1F0000U)
#define DMIC_CHANNEL_FIFO_CTRL_TRIGLVL_SHIFT     (16U)
/*! TRIGLVL - FIFO Trigger Level for Interrupt
 *  0b00000..Trigger when the FIFO has received one entry (is no longer empty).
 *  0b00001..Trigger when the FIFO has received two entries.
 *  0b01110..Trigger when the FIFO has received 15 entries.
 *  0b01111..Trigger when the FIFO has received 16 entries (has become full).
 */
#define DMIC_CHANNEL_FIFO_CTRL_TRIGLVL(x)        (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_CTRL_TRIGLVL_SHIFT)) & DMIC_CHANNEL_FIFO_CTRL_TRIGLVL_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_FIFO_CTRL */
#define DMIC_CHANNEL_FIFO_CTRL_COUNT             (2U)

/*! @name CHANNEL_FIFO_STATUS - FIFO Status */
/*! @{ */

#define DMIC_CHANNEL_FIFO_STATUS_INT_MASK        (0x1U)
#define DMIC_CHANNEL_FIFO_STATUS_INT_SHIFT       (0U)
/*! INT - Status of Interrupt (write 1 to clear)
 */
#define DMIC_CHANNEL_FIFO_STATUS_INT(x)          (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_STATUS_INT_SHIFT)) & DMIC_CHANNEL_FIFO_STATUS_INT_MASK)

#define DMIC_CHANNEL_FIFO_STATUS_OVERRUN_MASK    (0x2U)
#define DMIC_CHANNEL_FIFO_STATUS_OVERRUN_SHIFT   (1U)
/*! OVERRUN - Overrun Detected (write 1 to clear)
 */
#define DMIC_CHANNEL_FIFO_STATUS_OVERRUN(x)      (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_STATUS_OVERRUN_SHIFT)) & DMIC_CHANNEL_FIFO_STATUS_OVERRUN_MASK)

#define DMIC_CHANNEL_FIFO_STATUS_UNDERRUN_MASK   (0x4U)
#define DMIC_CHANNEL_FIFO_STATUS_UNDERRUN_SHIFT  (2U)
/*! UNDERRUN - Underrun Detected (write 1 to clear)
 */
#define DMIC_CHANNEL_FIFO_STATUS_UNDERRUN(x)     (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_STATUS_UNDERRUN_SHIFT)) & DMIC_CHANNEL_FIFO_STATUS_UNDERRUN_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_FIFO_STATUS */
#define DMIC_CHANNEL_FIFO_STATUS_COUNT           (2U)

/*! @name CHANNEL_FIFO_DATA - FIFO Data */
/*! @{ */

#define DMIC_CHANNEL_FIFO_DATA_DATA_MASK         (0xFFFFFFU)
#define DMIC_CHANNEL_FIFO_DATA_DATA_SHIFT        (0U)
/*! DATA - PCM Data
 */
#define DMIC_CHANNEL_FIFO_DATA_DATA(x)           (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_DATA_DATA_SHIFT)) & DMIC_CHANNEL_FIFO_DATA_DATA_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_FIFO_DATA */
#define DMIC_CHANNEL_FIFO_DATA_COUNT             (2U)

/*! @name CHANNEL_PHY_CTRL - Physical Control */
/*! @{ */

#define DMIC_CHANNEL_PHY_CTRL_PHY_FALL_MASK      (0x1U)
#define DMIC_CHANNEL_PHY_CTRL_PHY_FALL_SHIFT     (0U)
/*! PHY_FALL - Capture DMIC on Falling edge (0 means on rising)
 *  0b0..Capture PDM_DATA on the rising edge of PDM_CLK.
 *  0b1..Capture PDM_DATA on the falling edge of PDM_CLK.
 */
#define DMIC_CHANNEL_PHY_CTRL_PHY_FALL(x)        (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_PHY_CTRL_PHY_FALL_SHIFT)) & DMIC_CHANNEL_PHY_CTRL_PHY_FALL_MASK)

#define DMIC_CHANNEL_PHY_CTRL_PHY_HALF_MASK      (0x2U)
#define DMIC_CHANNEL_PHY_CTRL_PHY_HALF_SHIFT     (1U)
/*! PHY_HALF - Use Half rate sampling (ie Clock to dmic is sent at half the speed than the decimator is providing)
 *  0b0..Standard half rate sampling. The clock to the DMIC is sent at the same rate as the decimator is providing.
 *  0b1..Use half rate sampling. The clock to the DMIC is sent at half the rate that the decimator is providing.
 */
#define DMIC_CHANNEL_PHY_CTRL_PHY_HALF(x)        (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_PHY_CTRL_PHY_HALF_SHIFT)) & DMIC_CHANNEL_PHY_CTRL_PHY_HALF_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_PHY_CTRL */
#define DMIC_CHANNEL_PHY_CTRL_COUNT              (2U)

/*! @name CHANNEL_DC_CTRL - DC Filter Control */
/*! @{ */

#define DMIC_CHANNEL_DC_CTRL_DCPOLE_MASK         (0x3U)
#define DMIC_CHANNEL_DC_CTRL_DCPOLE_SHIFT        (0U)
/*! DCPOLE - DC Block Filter
 *  0b00..Flat Response, no filter
 *  0b01..155 Hz
 *  0b10..78 Hz
 *  0b11..39 Hz
 */
#define DMIC_CHANNEL_DC_CTRL_DCPOLE(x)           (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_DC_CTRL_DCPOLE_SHIFT)) & DMIC_CHANNEL_DC_CTRL_DCPOLE_MASK)

#define DMIC_CHANNEL_DC_CTRL_DCGAIN_MASK         (0xF0U)
#define DMIC_CHANNEL_DC_CTRL_DCGAIN_SHIFT        (4U)
/*! DCGAIN - DC Gain
 */
#define DMIC_CHANNEL_DC_CTRL_DCGAIN(x)           (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_DC_CTRL_DCGAIN_SHIFT)) & DMIC_CHANNEL_DC_CTRL_DCGAIN_MASK)

#define DMIC_CHANNEL_DC_CTRL_SATURATEAT16BIT_MASK (0x100U)
#define DMIC_CHANNEL_DC_CTRL_SATURATEAT16BIT_SHIFT (8U)
/*! SATURATEAT16BIT - Saturate at 16 Bit
 *  0b0..Do not Saturate. Results roll over if out range and do not saturate.
 *  0b1..Saturate. If the result overflows, it saturates at 0xFFFF for positive overflow and 0x8000 for negative overflow.
 */
#define DMIC_CHANNEL_DC_CTRL_SATURATEAT16BIT(x)  (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_DC_CTRL_SATURATEAT16BIT_SHIFT)) & DMIC_CHANNEL_DC_CTRL_SATURATEAT16BIT_MASK)

#define DMIC_CHANNEL_DC_CTRL_SIGNEXTEND_MASK     (0x200U)
#define DMIC_CHANNEL_DC_CTRL_SIGNEXTEND_SHIFT    (9U)
/*! SIGNEXTEND - Sign Extend
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define DMIC_CHANNEL_DC_CTRL_SIGNEXTEND(x)       (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_DC_CTRL_SIGNEXTEND_SHIFT)) & DMIC_CHANNEL_DC_CTRL_SIGNEXTEND_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_DC_CTRL */
#define DMIC_CHANNEL_DC_CTRL_COUNT               (2U)

/*! @name CHANEN - Channel Enable */
/*! @{ */

#define DMIC_CHANEN_EN_CH0_MASK                  (0x1U)
#define DMIC_CHANEN_EN_CH0_SHIFT                 (0U)
/*! EN_CH0 - Enable Channel n
 *  0b0..PDM channel n is disabled.
 *  0b1..PDM channel n is enabled.
 */
#define DMIC_CHANEN_EN_CH0(x)                    (((uint32_t)(((uint32_t)(x)) << DMIC_CHANEN_EN_CH0_SHIFT)) & DMIC_CHANEN_EN_CH0_MASK)

#define DMIC_CHANEN_EN_CH1_MASK                  (0x2U)
#define DMIC_CHANEN_EN_CH1_SHIFT                 (1U)
/*! EN_CH1 - Enable Channel n
 *  0b0..PDM channel n is disabled.
 *  0b1..PDM channel n is enabled.
 */
#define DMIC_CHANEN_EN_CH1(x)                    (((uint32_t)(((uint32_t)(x)) << DMIC_CHANEN_EN_CH1_SHIFT)) & DMIC_CHANEN_EN_CH1_MASK)
/*! @} */

/*! @name USE2FS - Use 2 FS register */
/*! @{ */

#define DMIC_USE2FS_USE2FS_MASK                  (0x1U)
#define DMIC_USE2FS_USE2FS_SHIFT                 (0U)
/*! USE2FS - Use 2FS register
 *  0b0..Use 1 FS output for PCM data.
 *  0b1..Use 2 FS output for PCM data.
 */
#define DMIC_USE2FS_USE2FS(x)                    (((uint32_t)(((uint32_t)(x)) << DMIC_USE2FS_USE2FS_SHIFT)) & DMIC_USE2FS_USE2FS_MASK)
/*! @} */

/*! @name GLOBAL_SYNC_EN - Global Channel Synchronization Enable */
/*! @{ */

#define DMIC_GLOBAL_SYNC_EN_CH_SYNC_EN_MASK      (0x3U)
#define DMIC_GLOBAL_SYNC_EN_CH_SYNC_EN_SHIFT     (0U)
/*! CH_SYNC_EN - Channel synch enable
 */
#define DMIC_GLOBAL_SYNC_EN_CH_SYNC_EN(x)        (((uint32_t)(((uint32_t)(x)) << DMIC_GLOBAL_SYNC_EN_CH_SYNC_EN_SHIFT)) & DMIC_GLOBAL_SYNC_EN_CH_SYNC_EN_MASK)
/*! @} */

/*! @name GLOBAL_COUNT_VAL - Global channel synchronization counter value */
/*! @{ */

#define DMIC_GLOBAL_COUNT_VAL_CCOUNTVAL_MASK     (0xFFFFFFFFU)
#define DMIC_GLOBAL_COUNT_VAL_CCOUNTVAL_SHIFT    (0U)
/*! CCOUNTVAL - Channel Counter Value
 */
#define DMIC_GLOBAL_COUNT_VAL_CCOUNTVAL(x)       (((uint32_t)(((uint32_t)(x)) << DMIC_GLOBAL_COUNT_VAL_CCOUNTVAL_SHIFT)) & DMIC_GLOBAL_COUNT_VAL_CCOUNTVAL_MASK)
/*! @} */

/*! @name DECRESET - DMIC decimator reset */
/*! @{ */

#define DMIC_DECRESET_DECRESET_MASK              (0x3U)
#define DMIC_DECRESET_DECRESET_SHIFT             (0U)
/*! DECRESET - Decimator reset
 *  0b00..Disable
 *  0b01..Enable
 */
#define DMIC_DECRESET_DECRESET(x)                (((uint32_t)(((uint32_t)(x)) << DMIC_DECRESET_DECRESET_SHIFT)) & DMIC_DECRESET_DECRESET_MASK)
/*! @} */

/*! @name HWVADGAIN - HWVAD Input Gain */
/*! @{ */

#define DMIC_HWVADGAIN_INPUTGAIN_MASK            (0xFU)
#define DMIC_HWVADGAIN_INPUTGAIN_SHIFT           (0U)
/*! INPUTGAIN - Input Gain
 *  0b0000..-10 bits
 *  0b0001..-8 bits
 *  0b0010..-6 bits
 *  0b0011..-4 bits
 *  0b0100..-2 bits
 *  0b0101..0 bits (default)
 *  0b0110..+2 bits
 *  0b0111..+4 bits
 *  0b1000..+6 bits
 *  0b1001..+8 bits
 *  0b1010..+10 bits
 *  0b1011..+12 bits
 *  0b1100..+14 bits
 *  0b1101-0b1111..Reserved
 */
#define DMIC_HWVADGAIN_INPUTGAIN(x)              (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADGAIN_INPUTGAIN_SHIFT)) & DMIC_HWVADGAIN_INPUTGAIN_MASK)
/*! @} */

/*! @name HWVADHPFS - HWVAD Filter Control */
/*! @{ */

#define DMIC_HWVADHPFS_HPFS_MASK                 (0x3U)
#define DMIC_HWVADHPFS_HPFS_SHIFT                (0U)
/*! HPFS - The HPFS field chooses the High Pass filter in first part of HWVAD.
 *  0b00..Bypass
 *  0b01..High Pass 1750 Hz
 *  0b10..High Pass 215 Hz
 *  0b11..Reserved
 */
#define DMIC_HWVADHPFS_HPFS(x)                   (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADHPFS_HPFS_SHIFT)) & DMIC_HWVADHPFS_HPFS_MASK)
/*! @} */

/*! @name HWVADST10 - HWVAD Control */
/*! @{ */

#define DMIC_HWVADST10_ST10_MASK                 (0x1U)
#define DMIC_HWVADST10_ST10_SHIFT                (0U)
/*! ST10 - STAGE 1
 *  0b0..Normal operation, waiting for HWVAD trigger event (stage 0).
 *  0b1..Reset internal interrupt flag by writing a '1' (stage 1) pulse.
 */
#define DMIC_HWVADST10_ST10(x)                   (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADST10_ST10_SHIFT)) & DMIC_HWVADST10_ST10_MASK)
/*! @} */

/*! @name HWVADRSTT - HWVAD Filter Reset */
/*! @{ */

#define DMIC_HWVADRSTT_RSST_MASK                 (0x1U)
#define DMIC_HWVADRSTT_RSST_SHIFT                (0U)
/*! RSST - Reset HWVAD
 */
#define DMIC_HWVADRSTT_RSST(x)                   (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADRSTT_RSST_SHIFT)) & DMIC_HWVADRSTT_RSST_MASK)
/*! @} */

/*! @name HWVADTHGN - HWVAD Noise Estimator Gain */
/*! @{ */

#define DMIC_HWVADTHGN_THGN_MASK                 (0xFU)
#define DMIC_HWVADTHGN_THGN_SHIFT                (0U)
/*! THGN - Gain Factor for Noise Estimator
 */
#define DMIC_HWVADTHGN_THGN(x)                   (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADTHGN_THGN_SHIFT)) & DMIC_HWVADTHGN_THGN_MASK)
/*! @} */

/*! @name HWVADTHGS - HWVAD Signal Estimator Gain */
/*! @{ */

#define DMIC_HWVADTHGS_THGS_MASK                 (0xFU)
#define DMIC_HWVADTHGS_THGS_SHIFT                (0U)
/*! THGS - Signal Gain Factor
 */
#define DMIC_HWVADTHGS_THGS(x)                   (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADTHGS_THGS_SHIFT)) & DMIC_HWVADTHGS_THGS_MASK)
/*! @} */

/*! @name HWVADLOWZ - HWVAD Noise Envelope Estimator */
/*! @{ */

#define DMIC_HWVADLOWZ_LOWZ_MASK                 (0xFFFFU)
#define DMIC_HWVADLOWZ_LOWZ_SHIFT                (0U)
/*! LOWZ - Average Noise-floor Value
 */
#define DMIC_HWVADLOWZ_LOWZ(x)                   (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADLOWZ_LOWZ_SHIFT)) & DMIC_HWVADLOWZ_LOWZ_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group DMIC_Register_Masks */


/* DMIC - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral DMIC0 base address */
  #define DMIC0_BASE                               (0x50090000u)
  /** Peripheral DMIC0 base address */
  #define DMIC0_BASE_NS                            (0x40090000u)
  /** Peripheral DMIC0 base pointer */
  #define DMIC0                                    ((DMIC_Type *)DMIC0_BASE)
  /** Peripheral DMIC0 base pointer */
  #define DMIC0_NS                                 ((DMIC_Type *)DMIC0_BASE_NS)
  /** Array initializer of DMIC peripheral base addresses */
  #define DMIC_BASE_ADDRS                          { DMIC0_BASE }
  /** Array initializer of DMIC peripheral base pointers */
  #define DMIC_BASE_PTRS                           { DMIC0 }
  /** Array initializer of DMIC peripheral base addresses */
  #define DMIC_BASE_ADDRS_NS                       { DMIC0_BASE_NS }
  /** Array initializer of DMIC peripheral base pointers */
  #define DMIC_BASE_PTRS_NS                        { DMIC0_NS }
#else
  /** Peripheral DMIC0 base address */
  #define DMIC0_BASE                               (0x40090000u)
  /** Peripheral DMIC0 base pointer */
  #define DMIC0                                    ((DMIC_Type *)DMIC0_BASE)
  /** Array initializer of DMIC peripheral base addresses */
  #define DMIC_BASE_ADDRS                          { DMIC0_BASE }
  /** Array initializer of DMIC peripheral base pointers */
  #define DMIC_BASE_PTRS                           { DMIC0 }
#endif
/** Interrupt vectors for the DMIC peripheral type */
#define DMIC_IRQS                                { DMIC_IRQn }
#define DMIC_HWVAD_IRQS                          { HWVAD0_IRQn }

/*!
 * @}
 */ /* end of group DMIC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- ENC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ENC_Peripheral_Access_Layer ENC Peripheral Access Layer
 * @{
 */

/** ENC - Register Layout Typedef */
typedef struct {
  __IO uint16_t CTRL;                              /**< Control Register, offset: 0x0 */
  __IO uint16_t FILT;                              /**< Input Filter Register, offset: 0x2 */
  __IO uint16_t WTR;                               /**< Watchdog Timeout Register, offset: 0x4 */
  __IO uint16_t POSD;                              /**< Position Difference Counter Register, offset: 0x6 */
  __I  uint16_t POSDH;                             /**< Position Difference Hold Register, offset: 0x8 */
  __IO uint16_t REV;                               /**< Revolution Counter Register, offset: 0xA */
  __I  uint16_t REVH;                              /**< Revolution Hold Register, offset: 0xC */
  __IO uint16_t UPOS;                              /**< Upper Position Counter Register, offset: 0xE */
  __IO uint16_t LPOS;                              /**< Lower Position Counter Register, offset: 0x10 */
  __I  uint16_t UPOSH;                             /**< Upper Position Hold Register, offset: 0x12 */
  __I  uint16_t LPOSH;                             /**< Lower Position Hold Register, offset: 0x14 */
  __IO uint16_t UINIT;                             /**< Upper Initialization Register, offset: 0x16 */
  __IO uint16_t LINIT;                             /**< Lower Initialization Register, offset: 0x18 */
  __I  uint16_t IMR;                               /**< Input Monitor Register, offset: 0x1A */
  __IO uint16_t TST;                               /**< Test Register, offset: 0x1C */
  __IO uint16_t CTRL2;                             /**< Control 2 Register, offset: 0x1E */
  __IO uint16_t UMOD;                              /**< Upper Modulus Register, offset: 0x20 */
  __IO uint16_t LMOD;                              /**< Lower Modulus Register, offset: 0x22 */
  __IO uint16_t UCOMP;                             /**< Upper Position Compare Register, offset: 0x24 */
  __IO uint16_t LCOMP;                             /**< Lower Position Compare Register, offset: 0x26 */
  __I  uint16_t LASTEDGE;                          /**< Last Edge Time Register, offset: 0x28 */
  __I  uint16_t LASTEDGEH;                         /**< Last Edge Time Hold Register, offset: 0x2A */
  __I  uint16_t POSDPER;                           /**< Position Difference Period Counter Register, offset: 0x2C */
  __I  uint16_t POSDPERBFR;                        /**< Position Difference Period Buffer Register, offset: 0x2E */
  __I  uint16_t POSDPERH;                          /**< Position Difference Period Hold Register, offset: 0x30 */
  __IO uint16_t CTRL3;                             /**< Control 3 Register, offset: 0x32 */
} ENC_Type;

/* ----------------------------------------------------------------------------
   -- ENC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ENC_Register_Masks ENC Register Masks
 * @{
 */

/*! @name CTRL - Control Register */
/*! @{ */

#define ENC_CTRL_CMPIE_MASK                      (0x1U)
#define ENC_CTRL_CMPIE_SHIFT                     (0U)
/*! CMPIE - Compare Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ENC_CTRL_CMPIE(x)                        (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_CMPIE_SHIFT)) & ENC_CTRL_CMPIE_MASK)

#define ENC_CTRL_CMPIRQ_MASK                     (0x2U)
#define ENC_CTRL_CMPIRQ_SHIFT                    (1U)
/*! CMPIRQ - Compare Interrupt Request
 *  0b0..No match has occurred (the counter does not match the COMP value)
 *  0b1..COMP match has occurred (the counter matches the COMP value)
 */
#define ENC_CTRL_CMPIRQ(x)                       (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_CMPIRQ_SHIFT)) & ENC_CTRL_CMPIRQ_MASK)

#define ENC_CTRL_WDE_MASK                        (0x4U)
#define ENC_CTRL_WDE_SHIFT                       (2U)
/*! WDE - Watchdog Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ENC_CTRL_WDE(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_WDE_SHIFT)) & ENC_CTRL_WDE_MASK)

#define ENC_CTRL_DIE_MASK                        (0x8U)
#define ENC_CTRL_DIE_SHIFT                       (3U)
/*! DIE - Watchdog Timeout Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ENC_CTRL_DIE(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_DIE_SHIFT)) & ENC_CTRL_DIE_MASK)

#define ENC_CTRL_DIRQ_MASK                       (0x10U)
#define ENC_CTRL_DIRQ_SHIFT                      (4U)
/*! DIRQ - Watchdog Timeout Interrupt Request
 *  0b0..No Watchdog timeout interrupt has occurred
 *  0b1..Watchdog timeout interrupt has occurred
 */
#define ENC_CTRL_DIRQ(x)                         (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_DIRQ_SHIFT)) & ENC_CTRL_DIRQ_MASK)

#define ENC_CTRL_XNE_MASK                        (0x20U)
#define ENC_CTRL_XNE_SHIFT                       (5U)
/*! XNE - Use Negative Edge of INDEX Pulse
 *  0b0..Use positive edge of INDEX pulse
 *  0b1..Use negative edge of INDEX pulse
 */
#define ENC_CTRL_XNE(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_XNE_SHIFT)) & ENC_CTRL_XNE_MASK)

#define ENC_CTRL_XIP_MASK                        (0x40U)
#define ENC_CTRL_XIP_SHIFT                       (6U)
/*! XIP - INDEX Triggered Initialization of Position Counters UPOS and LPOS
 *  0b0..INDEX pulse does not initialize the position counter
 *  0b1..INDEX pulse initializes the position counter
 */
#define ENC_CTRL_XIP(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_XIP_SHIFT)) & ENC_CTRL_XIP_MASK)

#define ENC_CTRL_XIE_MASK                        (0x80U)
#define ENC_CTRL_XIE_SHIFT                       (7U)
/*! XIE - INDEX Pulse Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ENC_CTRL_XIE(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_XIE_SHIFT)) & ENC_CTRL_XIE_MASK)

#define ENC_CTRL_XIRQ_MASK                       (0x100U)
#define ENC_CTRL_XIRQ_SHIFT                      (8U)
/*! XIRQ - INDEX Pulse Interrupt Request
 *  0b0..INDEX pulse has not occurred
 *  0b1..INDEX pulse has occurred
 */
#define ENC_CTRL_XIRQ(x)                         (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_XIRQ_SHIFT)) & ENC_CTRL_XIRQ_MASK)

#define ENC_CTRL_PH1_MASK                        (0x200U)
#define ENC_CTRL_PH1_SHIFT                       (9U)
/*! PH1 - Enable Signal Phase Count Mode
 *  0b0..Use the standard quadrature decoder, where PHASEA and PHASEB represent a two-phase quadrature signal.
 *  0b1..Bypass the quadrature decoder. A positive transition of the PHASEA input generates a count signal. The
 *       PHASEB input and the REV bit control the counter direction: If CTRL[REV] = 0, PHASEB = 0, then count up If
 *       CTRL[REV] = 1, PHASEB = 1, then count up If CTRL[REV] = 0, PHASEB = 1, then count down If CTRL[REV] = 1,
 *       PHASEB = 0, then count down
 */
#define ENC_CTRL_PH1(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_PH1_SHIFT)) & ENC_CTRL_PH1_MASK)

#define ENC_CTRL_REV_MASK                        (0x400U)
#define ENC_CTRL_REV_SHIFT                       (10U)
/*! REV - Enable Reverse Direction Counting
 *  0b0..Count normally
 *  0b1..Count in the reverse direction
 */
#define ENC_CTRL_REV(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_REV_SHIFT)) & ENC_CTRL_REV_MASK)

#define ENC_CTRL_SWIP_MASK                       (0x800U)
#define ENC_CTRL_SWIP_SHIFT                      (11U)
/*! SWIP - Software-Triggered Initialization of Position Counters UPOS and LPOS
 *  0b0..No action
 *  0b1..Initialize position counter (using upper and lower initialization registers, UINIT and LINIT)
 */
#define ENC_CTRL_SWIP(x)                         (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_SWIP_SHIFT)) & ENC_CTRL_SWIP_MASK)

#define ENC_CTRL_HNE_MASK                        (0x1000U)
#define ENC_CTRL_HNE_SHIFT                       (12U)
/*! HNE - Use Negative Edge of HOME Input
 *  0b0..Use positive-going edge-to-trigger initialization of position counters UPOS and LPOS
 *  0b1..Use negative-going edge-to-trigger initialization of position counters UPOS and LPOS
 */
#define ENC_CTRL_HNE(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_HNE_SHIFT)) & ENC_CTRL_HNE_MASK)

#define ENC_CTRL_HIP_MASK                        (0x2000U)
#define ENC_CTRL_HIP_SHIFT                       (13U)
/*! HIP - Enable HOME to Initialize Position Counters UPOS and LPOS
 *  0b0..No action
 *  0b1..HOME signal initializes the position counter
 */
#define ENC_CTRL_HIP(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_HIP_SHIFT)) & ENC_CTRL_HIP_MASK)

#define ENC_CTRL_HIE_MASK                        (0x4000U)
#define ENC_CTRL_HIE_SHIFT                       (14U)
/*! HIE - HOME Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ENC_CTRL_HIE(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_HIE_SHIFT)) & ENC_CTRL_HIE_MASK)

#define ENC_CTRL_HIRQ_MASK                       (0x8000U)
#define ENC_CTRL_HIRQ_SHIFT                      (15U)
/*! HIRQ - HOME Signal Transition Interrupt Request
 *  0b0..No transition on the HOME signal has occurred
 *  0b1..A transition on the HOME signal has occurred
 */
#define ENC_CTRL_HIRQ(x)                         (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_HIRQ_SHIFT)) & ENC_CTRL_HIRQ_MASK)
/*! @} */

/*! @name FILT - Input Filter Register */
/*! @{ */

#define ENC_FILT_FILT_PER_MASK                   (0xFFU)
#define ENC_FILT_FILT_PER_SHIFT                  (0U)
/*! FILT_PER - Input Filter Sample Period
 */
#define ENC_FILT_FILT_PER(x)                     (((uint16_t)(((uint16_t)(x)) << ENC_FILT_FILT_PER_SHIFT)) & ENC_FILT_FILT_PER_MASK)

#define ENC_FILT_FILT_CNT_MASK                   (0x700U)
#define ENC_FILT_FILT_CNT_SHIFT                  (8U)
/*! FILT_CNT - Input Filter Sample Count
 */
#define ENC_FILT_FILT_CNT(x)                     (((uint16_t)(((uint16_t)(x)) << ENC_FILT_FILT_CNT_SHIFT)) & ENC_FILT_FILT_CNT_MASK)

#define ENC_FILT_FILT_PRSC_MASK                  (0xE000U)
#define ENC_FILT_FILT_PRSC_SHIFT                 (13U)
/*! FILT_PRSC - prescaler divide IPbus clock to FILT clk
 */
#define ENC_FILT_FILT_PRSC(x)                    (((uint16_t)(((uint16_t)(x)) << ENC_FILT_FILT_PRSC_SHIFT)) & ENC_FILT_FILT_PRSC_MASK)
/*! @} */

/*! @name WTR - Watchdog Timeout Register */
/*! @{ */

#define ENC_WTR_WDOG_MASK                        (0xFFFFU)
#define ENC_WTR_WDOG_SHIFT                       (0U)
/*! WDOG - WDOG
 */
#define ENC_WTR_WDOG(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_WTR_WDOG_SHIFT)) & ENC_WTR_WDOG_MASK)
/*! @} */

/*! @name POSD - Position Difference Counter Register */
/*! @{ */

#define ENC_POSD_POSD_MASK                       (0xFFFFU)
#define ENC_POSD_POSD_SHIFT                      (0U)
/*! POSD - POSD
 */
#define ENC_POSD_POSD(x)                         (((uint16_t)(((uint16_t)(x)) << ENC_POSD_POSD_SHIFT)) & ENC_POSD_POSD_MASK)
/*! @} */

/*! @name POSDH - Position Difference Hold Register */
/*! @{ */

#define ENC_POSDH_POSDH_MASK                     (0xFFFFU)
#define ENC_POSDH_POSDH_SHIFT                    (0U)
/*! POSDH - POSDH
 */
#define ENC_POSDH_POSDH(x)                       (((uint16_t)(((uint16_t)(x)) << ENC_POSDH_POSDH_SHIFT)) & ENC_POSDH_POSDH_MASK)
/*! @} */

/*! @name REV - Revolution Counter Register */
/*! @{ */

#define ENC_REV_REV_MASK                         (0xFFFFU)
#define ENC_REV_REV_SHIFT                        (0U)
/*! REV - REV
 */
#define ENC_REV_REV(x)                           (((uint16_t)(((uint16_t)(x)) << ENC_REV_REV_SHIFT)) & ENC_REV_REV_MASK)
/*! @} */

/*! @name REVH - Revolution Hold Register */
/*! @{ */

#define ENC_REVH_REVH_MASK                       (0xFFFFU)
#define ENC_REVH_REVH_SHIFT                      (0U)
/*! REVH - REVH
 */
#define ENC_REVH_REVH(x)                         (((uint16_t)(((uint16_t)(x)) << ENC_REVH_REVH_SHIFT)) & ENC_REVH_REVH_MASK)
/*! @} */

/*! @name UPOS - Upper Position Counter Register */
/*! @{ */

#define ENC_UPOS_POS_MASK                        (0xFFFFU)
#define ENC_UPOS_POS_SHIFT                       (0U)
/*! POS - POS
 */
#define ENC_UPOS_POS(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_UPOS_POS_SHIFT)) & ENC_UPOS_POS_MASK)
/*! @} */

/*! @name LPOS - Lower Position Counter Register */
/*! @{ */

#define ENC_LPOS_POS_MASK                        (0xFFFFU)
#define ENC_LPOS_POS_SHIFT                       (0U)
/*! POS - POS
 */
#define ENC_LPOS_POS(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_LPOS_POS_SHIFT)) & ENC_LPOS_POS_MASK)
/*! @} */

/*! @name UPOSH - Upper Position Hold Register */
/*! @{ */

#define ENC_UPOSH_POSH_MASK                      (0xFFFFU)
#define ENC_UPOSH_POSH_SHIFT                     (0U)
/*! POSH - POSH
 */
#define ENC_UPOSH_POSH(x)                        (((uint16_t)(((uint16_t)(x)) << ENC_UPOSH_POSH_SHIFT)) & ENC_UPOSH_POSH_MASK)
/*! @} */

/*! @name LPOSH - Lower Position Hold Register */
/*! @{ */

#define ENC_LPOSH_POSH_MASK                      (0xFFFFU)
#define ENC_LPOSH_POSH_SHIFT                     (0U)
/*! POSH - POSH
 */
#define ENC_LPOSH_POSH(x)                        (((uint16_t)(((uint16_t)(x)) << ENC_LPOSH_POSH_SHIFT)) & ENC_LPOSH_POSH_MASK)
/*! @} */

/*! @name UINIT - Upper Initialization Register */
/*! @{ */

#define ENC_UINIT_INIT_MASK                      (0xFFFFU)
#define ENC_UINIT_INIT_SHIFT                     (0U)
/*! INIT - INIT
 */
#define ENC_UINIT_INIT(x)                        (((uint16_t)(((uint16_t)(x)) << ENC_UINIT_INIT_SHIFT)) & ENC_UINIT_INIT_MASK)
/*! @} */

/*! @name LINIT - Lower Initialization Register */
/*! @{ */

#define ENC_LINIT_INIT_MASK                      (0xFFFFU)
#define ENC_LINIT_INIT_SHIFT                     (0U)
/*! INIT - INIT
 */
#define ENC_LINIT_INIT(x)                        (((uint16_t)(((uint16_t)(x)) << ENC_LINIT_INIT_SHIFT)) & ENC_LINIT_INIT_MASK)
/*! @} */

/*! @name IMR - Input Monitor Register */
/*! @{ */

#define ENC_IMR_HOME_MASK                        (0x1U)
#define ENC_IMR_HOME_SHIFT                       (0U)
/*! HOME - HOME
 */
#define ENC_IMR_HOME(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_IMR_HOME_SHIFT)) & ENC_IMR_HOME_MASK)

#define ENC_IMR_INDEX_MASK                       (0x2U)
#define ENC_IMR_INDEX_SHIFT                      (1U)
/*! INDEX - INDEX
 */
#define ENC_IMR_INDEX(x)                         (((uint16_t)(((uint16_t)(x)) << ENC_IMR_INDEX_SHIFT)) & ENC_IMR_INDEX_MASK)

#define ENC_IMR_PHB_MASK                         (0x4U)
#define ENC_IMR_PHB_SHIFT                        (2U)
/*! PHB - PHB
 */
#define ENC_IMR_PHB(x)                           (((uint16_t)(((uint16_t)(x)) << ENC_IMR_PHB_SHIFT)) & ENC_IMR_PHB_MASK)

#define ENC_IMR_PHA_MASK                         (0x8U)
#define ENC_IMR_PHA_SHIFT                        (3U)
/*! PHA - PHA
 */
#define ENC_IMR_PHA(x)                           (((uint16_t)(((uint16_t)(x)) << ENC_IMR_PHA_SHIFT)) & ENC_IMR_PHA_MASK)

#define ENC_IMR_FHOM_MASK                        (0x10U)
#define ENC_IMR_FHOM_SHIFT                       (4U)
/*! FHOM - FHOM
 */
#define ENC_IMR_FHOM(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_IMR_FHOM_SHIFT)) & ENC_IMR_FHOM_MASK)

#define ENC_IMR_FIND_MASK                        (0x20U)
#define ENC_IMR_FIND_SHIFT                       (5U)
/*! FIND - FIND
 */
#define ENC_IMR_FIND(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_IMR_FIND_SHIFT)) & ENC_IMR_FIND_MASK)

#define ENC_IMR_FPHB_MASK                        (0x40U)
#define ENC_IMR_FPHB_SHIFT                       (6U)
/*! FPHB - FPHB
 */
#define ENC_IMR_FPHB(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_IMR_FPHB_SHIFT)) & ENC_IMR_FPHB_MASK)

#define ENC_IMR_FPHA_MASK                        (0x80U)
#define ENC_IMR_FPHA_SHIFT                       (7U)
/*! FPHA - FPHA
 */
#define ENC_IMR_FPHA(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_IMR_FPHA_SHIFT)) & ENC_IMR_FPHA_MASK)
/*! @} */

/*! @name TST - Test Register */
/*! @{ */

#define ENC_TST_TEST_COUNT_MASK                  (0xFFU)
#define ENC_TST_TEST_COUNT_SHIFT                 (0U)
/*! TEST_COUNT - TEST_COUNT
 */
#define ENC_TST_TEST_COUNT(x)                    (((uint16_t)(((uint16_t)(x)) << ENC_TST_TEST_COUNT_SHIFT)) & ENC_TST_TEST_COUNT_MASK)

#define ENC_TST_TEST_PERIOD_MASK                 (0x1F00U)
#define ENC_TST_TEST_PERIOD_SHIFT                (8U)
/*! TEST_PERIOD - TEST_PERIOD
 */
#define ENC_TST_TEST_PERIOD(x)                   (((uint16_t)(((uint16_t)(x)) << ENC_TST_TEST_PERIOD_SHIFT)) & ENC_TST_TEST_PERIOD_MASK)

#define ENC_TST_QDN_MASK                         (0x2000U)
#define ENC_TST_QDN_SHIFT                        (13U)
/*! QDN - Quadrature Decoder Negative Signal
 *  0b0..Generates a positive quadrature decoder signal
 *  0b1..Generates a negative quadrature decoder signal
 */
#define ENC_TST_QDN(x)                           (((uint16_t)(((uint16_t)(x)) << ENC_TST_QDN_SHIFT)) & ENC_TST_QDN_MASK)

#define ENC_TST_TCE_MASK                         (0x4000U)
#define ENC_TST_TCE_SHIFT                        (14U)
/*! TCE - Test Counter Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ENC_TST_TCE(x)                           (((uint16_t)(((uint16_t)(x)) << ENC_TST_TCE_SHIFT)) & ENC_TST_TCE_MASK)

#define ENC_TST_TEN_MASK                         (0x8000U)
#define ENC_TST_TEN_SHIFT                        (15U)
/*! TEN - Test Mode Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ENC_TST_TEN(x)                           (((uint16_t)(((uint16_t)(x)) << ENC_TST_TEN_SHIFT)) & ENC_TST_TEN_MASK)
/*! @} */

/*! @name CTRL2 - Control 2 Register */
/*! @{ */

#define ENC_CTRL2_UPDHLD_MASK                    (0x1U)
#define ENC_CTRL2_UPDHLD_SHIFT                   (0U)
/*! UPDHLD - Update Hold Registers
 *  0b0..Disable updates of hold registers on the rising edge of TRIGGER input signal
 *  0b1..Enable updates of hold registers on the rising edge of TRIGGER input signal
 */
#define ENC_CTRL2_UPDHLD(x)                      (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_UPDHLD_SHIFT)) & ENC_CTRL2_UPDHLD_MASK)

#define ENC_CTRL2_UPDPOS_MASK                    (0x2U)
#define ENC_CTRL2_UPDPOS_SHIFT                   (1U)
/*! UPDPOS - Update Position Registers
 *  0b0..No action for POSD, REV, UPOS and LPOS registers on rising edge of TRIGGER
 *  0b1..Clear POSD, REV, UPOS and LPOS registers on rising edge of TRIGGER
 */
#define ENC_CTRL2_UPDPOS(x)                      (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_UPDPOS_SHIFT)) & ENC_CTRL2_UPDPOS_MASK)

#define ENC_CTRL2_MOD_MASK                       (0x4U)
#define ENC_CTRL2_MOD_SHIFT                      (2U)
/*! MOD - Enable Modulo Counting
 *  0b0..Disable modulo counting
 *  0b1..Enable modulo counting
 */
#define ENC_CTRL2_MOD(x)                         (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_MOD_SHIFT)) & ENC_CTRL2_MOD_MASK)

#define ENC_CTRL2_DIR_MASK                       (0x8U)
#define ENC_CTRL2_DIR_SHIFT                      (3U)
/*! DIR - Count Direction Flag
 *  0b0..Last count was in the down direction
 *  0b1..Last count was in the up direction
 */
#define ENC_CTRL2_DIR(x)                         (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_DIR_SHIFT)) & ENC_CTRL2_DIR_MASK)

#define ENC_CTRL2_RUIE_MASK                      (0x10U)
#define ENC_CTRL2_RUIE_SHIFT                     (4U)
/*! RUIE - Roll-under Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ENC_CTRL2_RUIE(x)                        (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_RUIE_SHIFT)) & ENC_CTRL2_RUIE_MASK)

#define ENC_CTRL2_RUIRQ_MASK                     (0x20U)
#define ENC_CTRL2_RUIRQ_SHIFT                    (5U)
/*! RUIRQ - Roll-under Interrupt Request
 *  0b0..No roll-under has occurred
 *  0b1..Roll-under has occurred
 */
#define ENC_CTRL2_RUIRQ(x)                       (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_RUIRQ_SHIFT)) & ENC_CTRL2_RUIRQ_MASK)

#define ENC_CTRL2_ROIE_MASK                      (0x40U)
#define ENC_CTRL2_ROIE_SHIFT                     (6U)
/*! ROIE - Roll-over Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ENC_CTRL2_ROIE(x)                        (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_ROIE_SHIFT)) & ENC_CTRL2_ROIE_MASK)

#define ENC_CTRL2_ROIRQ_MASK                     (0x80U)
#define ENC_CTRL2_ROIRQ_SHIFT                    (7U)
/*! ROIRQ - Roll-over Interrupt Request
 *  0b0..No roll-over has occurred
 *  0b1..Roll-over has occurred
 */
#define ENC_CTRL2_ROIRQ(x)                       (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_ROIRQ_SHIFT)) & ENC_CTRL2_ROIRQ_MASK)

#define ENC_CTRL2_REVMOD_MASK                    (0x100U)
#define ENC_CTRL2_REVMOD_SHIFT                   (8U)
/*! REVMOD - Revolution Counter Modulus Enable
 *  0b0..Use INDEX pulse to increment/decrement revolution counter (REV)
 *  0b1..Use modulus counting roll-over/under to increment/decrement revolution counter (REV)
 */
#define ENC_CTRL2_REVMOD(x)                      (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_REVMOD_SHIFT)) & ENC_CTRL2_REVMOD_MASK)

#define ENC_CTRL2_OUTCTL_MASK                    (0x200U)
#define ENC_CTRL2_OUTCTL_SHIFT                   (9U)
/*! OUTCTL - Output Control
 *  0b0..POSMATCH pulses when a match occurs between the position counters (POS) and the corresponding compare value (COMP )
 *  0b1..POSMATCH pulses when the UPOS, LPOS, REV, or POSD registers are read
 */
#define ENC_CTRL2_OUTCTL(x)                      (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_OUTCTL_SHIFT)) & ENC_CTRL2_OUTCTL_MASK)

#define ENC_CTRL2_SABIE_MASK                     (0x400U)
#define ENC_CTRL2_SABIE_SHIFT                    (10U)
/*! SABIE - Simultaneous PHASEA and PHASEB Change Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ENC_CTRL2_SABIE(x)                       (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_SABIE_SHIFT)) & ENC_CTRL2_SABIE_MASK)

#define ENC_CTRL2_SABIRQ_MASK                    (0x800U)
#define ENC_CTRL2_SABIRQ_SHIFT                   (11U)
/*! SABIRQ - Simultaneous PHASEA and PHASEB Change Interrupt Request
 *  0b0..No simultaneous change of PHASEA and PHASEB has occurred
 *  0b1..A simultaneous change of PHASEA and PHASEB has occurred
 */
#define ENC_CTRL2_SABIRQ(x)                      (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_SABIRQ_SHIFT)) & ENC_CTRL2_SABIRQ_MASK)
/*! @} */

/*! @name UMOD - Upper Modulus Register */
/*! @{ */

#define ENC_UMOD_MOD_MASK                        (0xFFFFU)
#define ENC_UMOD_MOD_SHIFT                       (0U)
/*! MOD - MOD
 */
#define ENC_UMOD_MOD(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_UMOD_MOD_SHIFT)) & ENC_UMOD_MOD_MASK)
/*! @} */

/*! @name LMOD - Lower Modulus Register */
/*! @{ */

#define ENC_LMOD_MOD_MASK                        (0xFFFFU)
#define ENC_LMOD_MOD_SHIFT                       (0U)
/*! MOD - MOD
 */
#define ENC_LMOD_MOD(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_LMOD_MOD_SHIFT)) & ENC_LMOD_MOD_MASK)
/*! @} */

/*! @name UCOMP - Upper Position Compare Register */
/*! @{ */

#define ENC_UCOMP_COMP_MASK                      (0xFFFFU)
#define ENC_UCOMP_COMP_SHIFT                     (0U)
/*! COMP - COMP
 */
#define ENC_UCOMP_COMP(x)                        (((uint16_t)(((uint16_t)(x)) << ENC_UCOMP_COMP_SHIFT)) & ENC_UCOMP_COMP_MASK)
/*! @} */

/*! @name LCOMP - Lower Position Compare Register */
/*! @{ */

#define ENC_LCOMP_COMP_MASK                      (0xFFFFU)
#define ENC_LCOMP_COMP_SHIFT                     (0U)
/*! COMP - COMP
 */
#define ENC_LCOMP_COMP(x)                        (((uint16_t)(((uint16_t)(x)) << ENC_LCOMP_COMP_SHIFT)) & ENC_LCOMP_COMP_MASK)
/*! @} */

/*! @name LASTEDGE - Last Edge Time Register */
/*! @{ */

#define ENC_LASTEDGE_LASTEDGE_MASK               (0xFFFFU)
#define ENC_LASTEDGE_LASTEDGE_SHIFT              (0U)
/*! LASTEDGE - Last Edge Time Counter
 */
#define ENC_LASTEDGE_LASTEDGE(x)                 (((uint16_t)(((uint16_t)(x)) << ENC_LASTEDGE_LASTEDGE_SHIFT)) & ENC_LASTEDGE_LASTEDGE_MASK)
/*! @} */

/*! @name LASTEDGEH - Last Edge Time Hold Register */
/*! @{ */

#define ENC_LASTEDGEH_LASTEDGEH_MASK             (0xFFFFU)
#define ENC_LASTEDGEH_LASTEDGEH_SHIFT            (0U)
/*! LASTEDGEH - Last Edge Time Hold
 */
#define ENC_LASTEDGEH_LASTEDGEH(x)               (((uint16_t)(((uint16_t)(x)) << ENC_LASTEDGEH_LASTEDGEH_SHIFT)) & ENC_LASTEDGEH_LASTEDGEH_MASK)
/*! @} */

/*! @name POSDPER - Position Difference Period Counter Register */
/*! @{ */

#define ENC_POSDPER_POSDPER_MASK                 (0xFFFFU)
#define ENC_POSDPER_POSDPER_SHIFT                (0U)
/*! POSDPER - Position difference period
 */
#define ENC_POSDPER_POSDPER(x)                   (((uint16_t)(((uint16_t)(x)) << ENC_POSDPER_POSDPER_SHIFT)) & ENC_POSDPER_POSDPER_MASK)
/*! @} */

/*! @name POSDPERBFR - Position Difference Period Buffer Register */
/*! @{ */

#define ENC_POSDPERBFR_POSDPERBFR_MASK           (0xFFFFU)
#define ENC_POSDPERBFR_POSDPERBFR_SHIFT          (0U)
/*! POSDPERBFR - Position difference period buffer
 */
#define ENC_POSDPERBFR_POSDPERBFR(x)             (((uint16_t)(((uint16_t)(x)) << ENC_POSDPERBFR_POSDPERBFR_SHIFT)) & ENC_POSDPERBFR_POSDPERBFR_MASK)
/*! @} */

/*! @name POSDPERH - Position Difference Period Hold Register */
/*! @{ */

#define ENC_POSDPERH_POSDPERH_MASK               (0xFFFFU)
#define ENC_POSDPERH_POSDPERH_SHIFT              (0U)
/*! POSDPERH - Position difference period hold
 */
#define ENC_POSDPERH_POSDPERH(x)                 (((uint16_t)(((uint16_t)(x)) << ENC_POSDPERH_POSDPERH_SHIFT)) & ENC_POSDPERH_POSDPERH_MASK)
/*! @} */

/*! @name CTRL3 - Control 3 Register */
/*! @{ */

#define ENC_CTRL3_PMEN_MASK                      (0x1U)
#define ENC_CTRL3_PMEN_SHIFT                     (0U)
/*! PMEN - Period measurement function enable
 *  0b0..Period measurement functions are not used. POSD is loaded to POSDH and then cleared whenever POSD, UPOS, LPOS, or REV is read.
 *  0b1..Period measurement functions are used. POSD is loaded to POSDH and then cleared only when POSD is read.
 */
#define ENC_CTRL3_PMEN(x)                        (((uint16_t)(((uint16_t)(x)) << ENC_CTRL3_PMEN_SHIFT)) & ENC_CTRL3_PMEN_MASK)

#define ENC_CTRL3_PRSC_MASK                      (0xF0U)
#define ENC_CTRL3_PRSC_SHIFT                     (4U)
/*! PRSC - Prescaler
 */
#define ENC_CTRL3_PRSC(x)                        (((uint16_t)(((uint16_t)(x)) << ENC_CTRL3_PRSC_SHIFT)) & ENC_CTRL3_PRSC_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group ENC_Register_Masks */


/* ENC - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral ENC0 base address */
  #define ENC0_BASE                                (0x500C4000u)
  /** Peripheral ENC0 base address */
  #define ENC0_BASE_NS                             (0x400C4000u)
  /** Peripheral ENC0 base pointer */
  #define ENC0                                     ((ENC_Type *)ENC0_BASE)
  /** Peripheral ENC0 base pointer */
  #define ENC0_NS                                  ((ENC_Type *)ENC0_BASE_NS)
  /** Peripheral ENC1 base address */
  #define ENC1_BASE                                (0x500C6000u)
  /** Peripheral ENC1 base address */
  #define ENC1_BASE_NS                             (0x400C6000u)
  /** Peripheral ENC1 base pointer */
  #define ENC1                                     ((ENC_Type *)ENC1_BASE)
  /** Peripheral ENC1 base pointer */
  #define ENC1_NS                                  ((ENC_Type *)ENC1_BASE_NS)
  /** Array initializer of ENC peripheral base addresses */
  #define ENC_BASE_ADDRS                           { ENC0_BASE, ENC1_BASE }
  /** Array initializer of ENC peripheral base pointers */
  #define ENC_BASE_PTRS                            { ENC0, ENC1 }
  /** Array initializer of ENC peripheral base addresses */
  #define ENC_BASE_ADDRS_NS                        { ENC0_BASE_NS, ENC1_BASE_NS }
  /** Array initializer of ENC peripheral base pointers */
  #define ENC_BASE_PTRS_NS                         { ENC0_NS, ENC1_NS }
#else
  /** Peripheral ENC0 base address */
  #define ENC0_BASE                                (0x400C4000u)
  /** Peripheral ENC0 base pointer */
  #define ENC0                                     ((ENC_Type *)ENC0_BASE)
  /** Peripheral ENC1 base address */
  #define ENC1_BASE                                (0x400C6000u)
  /** Peripheral ENC1 base pointer */
  #define ENC1                                     ((ENC_Type *)ENC1_BASE)
  /** Array initializer of ENC peripheral base addresses */
  #define ENC_BASE_ADDRS                           { ENC0_BASE, ENC1_BASE }
  /** Array initializer of ENC peripheral base pointers */
  #define ENC_BASE_PTRS                            { ENC0, ENC1 }
#endif
/** Interrupt vectors for the ENC peripheral type */
#define ENC_COMPARE_IRQS                         { ENC0_COMPARE_IRQn, ENC1_COMPARE_IRQn }
#define ENC_HOME_IRQS                            { ENC0_HOME_IRQn, ENC1_HOME_IRQn }
#define ENC_WDOG_IRQS                            { ENC0_WDG_IRQn, ENC1_WDG_IRQn }
#define ENC_INDEX_IRQS                           { ENC0_IDX_IRQn, ENC1_IDX_IRQn }

/*!
 * @}
 */ /* end of group ENC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FLASH Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLASH_Peripheral_Access_Layer FLASH Peripheral Access Layer
 * @{
 */

/** FLASH - Register Layout Typedef */
typedef struct {
  __O  uint32_t CMD;                               /**< Command, offset: 0x0 */
  __O  uint32_t EVENT;                             /**< Event, offset: 0x4 */
       uint8_t RESERVED_0[8];
  __IO uint32_t STARTA;                            /**< Start address for next flash command, offset: 0x10 */
  __IO uint32_t STOPA;                             /**< End address for next flash command, offset: 0x14 */
       uint8_t RESERVED_1[104];
  __IO uint32_t DATAW[4];                          /**< Data register, array offset: 0x80, array step: 0x4 */
       uint8_t RESERVED_2[3912];
  __O  uint32_t INTEN_CLR;                         /**< Clear interrupt enables, offset: 0xFD8 */
  __O  uint32_t INTEN_SET;                         /**< Set interrupt enables, offset: 0xFDC */
  __I  uint32_t INTSTAT;                           /**< Interrupt status, offset: 0xFE0 */
  __I  uint32_t INTEN;                             /**< Interrupt enable, offset: 0xFE4 */
  __O  uint32_t INTSTAT_CLR;                       /**< Clear interrupt status, offset: 0xFE8 */
  __O  uint32_t INTSTAT_SET;                       /**< Set interrupt status, offset: 0xFEC */
       uint8_t RESERVED_3[12];
  __I  uint32_t MODULE_ID;                         /**< Module identification, offset: 0xFFC */
} FLASH_Type;

/* ----------------------------------------------------------------------------
   -- FLASH Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLASH_Register_Masks FLASH Register Masks
 * @{
 */

/*! @name CMD - Command */
/*! @{ */

#define FLASH_CMD_CMD_MASK                       (0xFFFFFFFFU)
#define FLASH_CMD_CMD_SHIFT                      (0U)
/*! CMD - command register.
 */
#define FLASH_CMD_CMD(x)                         (((uint32_t)(((uint32_t)(x)) << FLASH_CMD_CMD_SHIFT)) & FLASH_CMD_CMD_MASK)
/*! @} */

/*! @name EVENT - Event */
/*! @{ */

#define FLASH_EVENT_RST_MASK                     (0x1U)
#define FLASH_EVENT_RST_SHIFT                    (0U)
/*! RST - When bit is set, the controller and flash are reset.
 */
#define FLASH_EVENT_RST(x)                       (((uint32_t)(((uint32_t)(x)) << FLASH_EVENT_RST_SHIFT)) & FLASH_EVENT_RST_MASK)

#define FLASH_EVENT_WAKEUP_MASK                  (0x2U)
#define FLASH_EVENT_WAKEUP_SHIFT                 (1U)
/*! WAKEUP - When bit is set, the controller wakes up from whatever low power or powerdown mode was active.
 */
#define FLASH_EVENT_WAKEUP(x)                    (((uint32_t)(((uint32_t)(x)) << FLASH_EVENT_WAKEUP_SHIFT)) & FLASH_EVENT_WAKEUP_MASK)

#define FLASH_EVENT_ABORT_MASK                   (0x4U)
#define FLASH_EVENT_ABORT_SHIFT                  (2U)
/*! ABORT - When bit is set, a running program/erase command is aborted.
 */
#define FLASH_EVENT_ABORT(x)                     (((uint32_t)(((uint32_t)(x)) << FLASH_EVENT_ABORT_SHIFT)) & FLASH_EVENT_ABORT_MASK)
/*! @} */

/*! @name STARTA - Start address for next flash command */
/*! @{ */

#define FLASH_STARTA_STARTA_MASK                 (0x3FFFU)
#define FLASH_STARTA_STARTA_SHIFT                (0U)
/*! STARTA - Address / Start address for commands that take an address (range) as a parameter.
 */
#define FLASH_STARTA_STARTA(x)                   (((uint32_t)(((uint32_t)(x)) << FLASH_STARTA_STARTA_SHIFT)) & FLASH_STARTA_STARTA_MASK)
/*! @} */

/*! @name STOPA - End address for next flash command */
/*! @{ */

#define FLASH_STOPA_STOPA_MASK                   (0x3FFFFU)
#define FLASH_STOPA_STOPA_SHIFT                  (0U)
/*! STOPA - Stop address for commands that take an address range as a parameter (the word specified
 *    by STOPA is included in the address range).
 */
#define FLASH_STOPA_STOPA(x)                     (((uint32_t)(((uint32_t)(x)) << FLASH_STOPA_STOPA_SHIFT)) & FLASH_STOPA_STOPA_MASK)
/*! @} */

/*! @name DATAW - Data register */
/*! @{ */

#define FLASH_DATAW_DATAW_MASK                   (0xFFFFFFFFU)
#define FLASH_DATAW_DATAW_SHIFT                  (0U)
/*! DATAW - Memory data, or command parameter, or command result.
 */
#define FLASH_DATAW_DATAW(x)                     (((uint32_t)(((uint32_t)(x)) << FLASH_DATAW_DATAW_SHIFT)) & FLASH_DATAW_DATAW_MASK)
/*! @} */

/* The count of FLASH_DATAW */
#define FLASH_DATAW_COUNT                        (4U)

/*! @name INTEN_CLR - Clear interrupt enables */
/*! @{ */

#define FLASH_INTEN_CLR_FAIL_MASK                (0x1U)
#define FLASH_INTEN_CLR_FAIL_SHIFT               (0U)
/*! FAIL - Clears the fail interrupt.
 */
#define FLASH_INTEN_CLR_FAIL(x)                  (((uint32_t)(((uint32_t)(x)) << FLASH_INTEN_CLR_FAIL_SHIFT)) & FLASH_INTEN_CLR_FAIL_MASK)

#define FLASH_INTEN_CLR_ERR_MASK                 (0x2U)
#define FLASH_INTEN_CLR_ERR_SHIFT                (1U)
/*! ERR - Clears the error interrupt.
 */
#define FLASH_INTEN_CLR_ERR(x)                   (((uint32_t)(((uint32_t)(x)) << FLASH_INTEN_CLR_ERR_SHIFT)) & FLASH_INTEN_CLR_ERR_MASK)

#define FLASH_INTEN_CLR_DONE_MASK                (0x4U)
#define FLASH_INTEN_CLR_DONE_SHIFT               (2U)
/*! DONE - Clears the done interrupt.
 */
#define FLASH_INTEN_CLR_DONE(x)                  (((uint32_t)(((uint32_t)(x)) << FLASH_INTEN_CLR_DONE_SHIFT)) & FLASH_INTEN_CLR_DONE_MASK)

#define FLASH_INTEN_CLR_ECC_ERR_MASK             (0x8U)
#define FLASH_INTEN_CLR_ECC_ERR_SHIFT            (3U)
/*! ECC_ERR - Clears the ECC error interrupt.
 */
#define FLASH_INTEN_CLR_ECC_ERR(x)               (((uint32_t)(((uint32_t)(x)) << FLASH_INTEN_CLR_ECC_ERR_SHIFT)) & FLASH_INTEN_CLR_ECC_ERR_MASK)
/*! @} */

/*! @name INTEN_SET - Set interrupt enables */
/*! @{ */

#define FLASH_INTEN_SET_FAIL_MASK                (0x1U)
#define FLASH_INTEN_SET_FAIL_SHIFT               (0U)
/*! FAIL - Sets Fail interrupt.
 */
#define FLASH_INTEN_SET_FAIL(x)                  (((uint32_t)(((uint32_t)(x)) << FLASH_INTEN_SET_FAIL_SHIFT)) & FLASH_INTEN_SET_FAIL_MASK)

#define FLASH_INTEN_SET_ERR_MASK                 (0x2U)
#define FLASH_INTEN_SET_ERR_SHIFT                (1U)
/*! ERR - Sets error interrupt
 */
#define FLASH_INTEN_SET_ERR(x)                   (((uint32_t)(((uint32_t)(x)) << FLASH_INTEN_SET_ERR_SHIFT)) & FLASH_INTEN_SET_ERR_MASK)

#define FLASH_INTEN_SET_DONE_MASK                (0x4U)
#define FLASH_INTEN_SET_DONE_SHIFT               (2U)
/*! DONE - Sets done interrupt.
 */
#define FLASH_INTEN_SET_DONE(x)                  (((uint32_t)(((uint32_t)(x)) << FLASH_INTEN_SET_DONE_SHIFT)) & FLASH_INTEN_SET_DONE_MASK)

#define FLASH_INTEN_SET_ECC_ERR_MASK             (0x8U)
#define FLASH_INTEN_SET_ECC_ERR_SHIFT            (3U)
/*! ECC_ERR - Sets ECC error interrupt.
 */
#define FLASH_INTEN_SET_ECC_ERR(x)               (((uint32_t)(((uint32_t)(x)) << FLASH_INTEN_SET_ECC_ERR_SHIFT)) & FLASH_INTEN_SET_ECC_ERR_MASK)
/*! @} */

/*! @name INTSTAT - Interrupt status */
/*! @{ */

#define FLASH_INTSTAT_FAIL_MASK                  (0x1U)
#define FLASH_INTSTAT_FAIL_SHIFT                 (0U)
/*! FAIL - This status bit is set if execution of a (legal) command failed.
 */
#define FLASH_INTSTAT_FAIL(x)                    (((uint32_t)(((uint32_t)(x)) << FLASH_INTSTAT_FAIL_SHIFT)) & FLASH_INTSTAT_FAIL_MASK)

#define FLASH_INTSTAT_ERR_MASK                   (0x2U)
#define FLASH_INTSTAT_ERR_SHIFT                  (1U)
/*! ERR - This status bit is set if execution of an illegal command is detected.
 */
#define FLASH_INTSTAT_ERR(x)                     (((uint32_t)(((uint32_t)(x)) << FLASH_INTSTAT_ERR_SHIFT)) & FLASH_INTSTAT_ERR_MASK)

#define FLASH_INTSTAT_DONE_MASK                  (0x4U)
#define FLASH_INTSTAT_DONE_SHIFT                 (2U)
/*! DONE - This status bit is set at the end of command execution.
 */
#define FLASH_INTSTAT_DONE(x)                    (((uint32_t)(((uint32_t)(x)) << FLASH_INTSTAT_DONE_SHIFT)) & FLASH_INTSTAT_DONE_MASK)

#define FLASH_INTSTAT_ECC_ERR_MASK               (0x8U)
#define FLASH_INTSTAT_ECC_ERR_SHIFT              (3U)
/*! ECC_ERR - This status bit is set if, during a memory read operation (either a user-requested
 *    read, or a speculative read, or reads performed by a controller command), a correctable or
 *    uncorrectable error is detected by ECC decoding logic.
 */
#define FLASH_INTSTAT_ECC_ERR(x)                 (((uint32_t)(((uint32_t)(x)) << FLASH_INTSTAT_ECC_ERR_SHIFT)) & FLASH_INTSTAT_ECC_ERR_MASK)
/*! @} */

/*! @name INTEN - Interrupt enable */
/*! @{ */

#define FLASH_INTEN_FAIL_MASK                    (0x1U)
#define FLASH_INTEN_FAIL_SHIFT                   (0U)
/*! FAIL - Enables fail interrupt.
 */
#define FLASH_INTEN_FAIL(x)                      (((uint32_t)(((uint32_t)(x)) << FLASH_INTEN_FAIL_SHIFT)) & FLASH_INTEN_FAIL_MASK)

#define FLASH_INTEN_ERR_MASK                     (0x2U)
#define FLASH_INTEN_ERR_SHIFT                    (1U)
/*! ERR - Enables error interrupt.
 */
#define FLASH_INTEN_ERR(x)                       (((uint32_t)(((uint32_t)(x)) << FLASH_INTEN_ERR_SHIFT)) & FLASH_INTEN_ERR_MASK)

#define FLASH_INTEN_DONE_MASK                    (0x4U)
#define FLASH_INTEN_DONE_SHIFT                   (2U)
/*! DONE - Enables done interrupt.
 */
#define FLASH_INTEN_DONE(x)                      (((uint32_t)(((uint32_t)(x)) << FLASH_INTEN_DONE_SHIFT)) & FLASH_INTEN_DONE_MASK)

#define FLASH_INTEN_ECC_ERR_MASK                 (0x8U)
#define FLASH_INTEN_ECC_ERR_SHIFT                (3U)
/*! ECC_ERR - Enables ECC error interrupt.
 */
#define FLASH_INTEN_ECC_ERR(x)                   (((uint32_t)(((uint32_t)(x)) << FLASH_INTEN_ECC_ERR_SHIFT)) & FLASH_INTEN_ECC_ERR_MASK)
/*! @} */

/*! @name INTSTAT_CLR - Clear interrupt status */
/*! @{ */

#define FLASH_INTSTAT_CLR_FAIL_MASK              (0x1U)
#define FLASH_INTSTAT_CLR_FAIL_SHIFT             (0U)
/*! FAIL - Clears fail interrupt status.
 */
#define FLASH_INTSTAT_CLR_FAIL(x)                (((uint32_t)(((uint32_t)(x)) << FLASH_INTSTAT_CLR_FAIL_SHIFT)) & FLASH_INTSTAT_CLR_FAIL_MASK)

#define FLASH_INTSTAT_CLR_ERR_MASK               (0x2U)
#define FLASH_INTSTAT_CLR_ERR_SHIFT              (1U)
/*! ERR - Clears error interrupt status.
 */
#define FLASH_INTSTAT_CLR_ERR(x)                 (((uint32_t)(((uint32_t)(x)) << FLASH_INTSTAT_CLR_ERR_SHIFT)) & FLASH_INTSTAT_CLR_ERR_MASK)

#define FLASH_INTSTAT_CLR_DONE_MASK              (0x4U)
#define FLASH_INTSTAT_CLR_DONE_SHIFT             (2U)
/*! DONE - Clears done interrupt status.
 */
#define FLASH_INTSTAT_CLR_DONE(x)                (((uint32_t)(((uint32_t)(x)) << FLASH_INTSTAT_CLR_DONE_SHIFT)) & FLASH_INTSTAT_CLR_DONE_MASK)

#define FLASH_INTSTAT_CLR_ECC_ERR_MASK           (0x8U)
#define FLASH_INTSTAT_CLR_ECC_ERR_SHIFT          (3U)
/*! ECC_ERR - Clears ECC error interrupt status.
 */
#define FLASH_INTSTAT_CLR_ECC_ERR(x)             (((uint32_t)(((uint32_t)(x)) << FLASH_INTSTAT_CLR_ECC_ERR_SHIFT)) & FLASH_INTSTAT_CLR_ECC_ERR_MASK)
/*! @} */

/*! @name INTSTAT_SET - Set interrupt status */
/*! @{ */

#define FLASH_INTSTAT_SET_FAIL_MASK              (0x1U)
#define FLASH_INTSTAT_SET_FAIL_SHIFT             (0U)
/*! FAIL - Sets fail interrupt status.
 */
#define FLASH_INTSTAT_SET_FAIL(x)                (((uint32_t)(((uint32_t)(x)) << FLASH_INTSTAT_SET_FAIL_SHIFT)) & FLASH_INTSTAT_SET_FAIL_MASK)

#define FLASH_INTSTAT_SET_ERR_MASK               (0x2U)
#define FLASH_INTSTAT_SET_ERR_SHIFT              (1U)
/*! ERR - Sets error interrupt status.
 */
#define FLASH_INTSTAT_SET_ERR(x)                 (((uint32_t)(((uint32_t)(x)) << FLASH_INTSTAT_SET_ERR_SHIFT)) & FLASH_INTSTAT_SET_ERR_MASK)

#define FLASH_INTSTAT_SET_DONE_MASK              (0x4U)
#define FLASH_INTSTAT_SET_DONE_SHIFT             (2U)
/*! DONE - Sets done interrupt status.
 */
#define FLASH_INTSTAT_SET_DONE(x)                (((uint32_t)(((uint32_t)(x)) << FLASH_INTSTAT_SET_DONE_SHIFT)) & FLASH_INTSTAT_SET_DONE_MASK)

#define FLASH_INTSTAT_SET_ECC_ERR_MASK           (0x8U)
#define FLASH_INTSTAT_SET_ECC_ERR_SHIFT          (3U)
/*! ECC_ERR - Sets ECC error interrupt status.
 */
#define FLASH_INTSTAT_SET_ECC_ERR(x)             (((uint32_t)(((uint32_t)(x)) << FLASH_INTSTAT_SET_ECC_ERR_SHIFT)) & FLASH_INTSTAT_SET_ECC_ERR_MASK)
/*! @} */

/*! @name MODULE_ID - Module identification */
/*! @{ */

#define FLASH_MODULE_ID_MINOR_REV_MASK           (0xF00U)
#define FLASH_MODULE_ID_MINOR_REV_SHIFT          (8U)
/*! MINOR_REV - Minor revision i.
 */
#define FLASH_MODULE_ID_MINOR_REV(x)             (((uint32_t)(((uint32_t)(x)) << FLASH_MODULE_ID_MINOR_REV_SHIFT)) & FLASH_MODULE_ID_MINOR_REV_MASK)

#define FLASH_MODULE_ID_MAJOR_REV_MASK           (0xF000U)
#define FLASH_MODULE_ID_MAJOR_REV_SHIFT          (12U)
/*! MAJOR_REV - Major revision i.
 */
#define FLASH_MODULE_ID_MAJOR_REV(x)             (((uint32_t)(((uint32_t)(x)) << FLASH_MODULE_ID_MAJOR_REV_SHIFT)) & FLASH_MODULE_ID_MAJOR_REV_MASK)

#define FLASH_MODULE_ID_ID_MASK                  (0xFFFF0000U)
#define FLASH_MODULE_ID_ID_SHIFT                 (16U)
/*! ID - Identifier.
 */
#define FLASH_MODULE_ID_ID(x)                    (((uint32_t)(((uint32_t)(x)) << FLASH_MODULE_ID_ID_SHIFT)) & FLASH_MODULE_ID_ID_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group FLASH_Register_Masks */


/* FLASH - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral FLASH base address */
  #define FLASH_BASE                               (0x50034000u)
  /** Peripheral FLASH base address */
  #define FLASH_BASE_NS                            (0x40034000u)
  /** Peripheral FLASH base pointer */
  #define FLASH                                    ((FLASH_Type *)FLASH_BASE)
  /** Peripheral FLASH base pointer */
  #define FLASH_NS                                 ((FLASH_Type *)FLASH_BASE_NS)
  /** Array initializer of FLASH peripheral base addresses */
  #define FLASH_BASE_ADDRS                         { FLASH_BASE }
  /** Array initializer of FLASH peripheral base pointers */
  #define FLASH_BASE_PTRS                          { FLASH }
  /** Array initializer of FLASH peripheral base addresses */
  #define FLASH_BASE_ADDRS_NS                      { FLASH_BASE_NS }
  /** Array initializer of FLASH peripheral base pointers */
  #define FLASH_BASE_PTRS_NS                       { FLASH_NS }
#else
  /** Peripheral FLASH base address */
  #define FLASH_BASE                               (0x40034000u)
  /** Peripheral FLASH base pointer */
  #define FLASH                                    ((FLASH_Type *)FLASH_BASE)
  /** Array initializer of FLASH peripheral base addresses */
  #define FLASH_BASE_ADDRS                         { FLASH_BASE }
  /** Array initializer of FLASH peripheral base pointers */
  #define FLASH_BASE_PTRS                          { FLASH }
#endif

/*!
 * @}
 */ /* end of group FLASH_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FLEXCOMM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXCOMM_Peripheral_Access_Layer FLEXCOMM Peripheral Access Layer
 * @{
 */

/** FLEXCOMM - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[4088];
  __IO uint32_t PSELID;                            /**< Peripheral Select and Flexcomm module ID, offset: 0xFF8 */
  __I  uint32_t PID;                               /**< Peripheral Identification, offset: 0xFFC */
} FLEXCOMM_Type;

/* ----------------------------------------------------------------------------
   -- FLEXCOMM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXCOMM_Register_Masks FLEXCOMM Register Masks
 * @{
 */

/*! @name PSELID - Peripheral Select and Flexcomm module ID */
/*! @{ */

#define FLEXCOMM_PSELID_PERSEL_MASK              (0x7U)
#define FLEXCOMM_PSELID_PERSEL_SHIFT             (0U)
/*! PERSEL - Peripheral Select
 *  0b000..No peripheral selected.
 *  0b001..USART function selected
 *  0b010..SPI function selected
 *  0b011..I2C
 *  0b100..I2S Transmit
 *  0b101..I2S Receive
 *  0b110..Reserved
 *  0b111..Reserved
 */
#define FLEXCOMM_PSELID_PERSEL(x)                (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_PERSEL_SHIFT)) & FLEXCOMM_PSELID_PERSEL_MASK)

#define FLEXCOMM_PSELID_LOCK_MASK                (0x8U)
#define FLEXCOMM_PSELID_LOCK_SHIFT               (3U)
/*! LOCK - Lock the peripheral select
 *  0b0..Peripheral select can be changed by software.
 *  0b1..Peripheral select is locked and cannot be changed until this Flexcomm module or the entire device is reset.
 */
#define FLEXCOMM_PSELID_LOCK(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_LOCK_SHIFT)) & FLEXCOMM_PSELID_LOCK_MASK)

#define FLEXCOMM_PSELID_USARTPRESENT_MASK        (0x10U)
#define FLEXCOMM_PSELID_USARTPRESENT_SHIFT       (4U)
/*! USARTPRESENT - USART present indicator
 *  0b0..This Flexcomm module does not include the USART function.
 *  0b1..This Flexcomm module includes the USART function.
 */
#define FLEXCOMM_PSELID_USARTPRESENT(x)          (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_USARTPRESENT_SHIFT)) & FLEXCOMM_PSELID_USARTPRESENT_MASK)

#define FLEXCOMM_PSELID_SPIPRESENT_MASK          (0x20U)
#define FLEXCOMM_PSELID_SPIPRESENT_SHIFT         (5U)
/*! SPIPRESENT - SPI present indicator
 *  0b0..This Flexcomm module does not include the SPI function.
 *  0b1..This Flexcomm module includes the SPI function.
 */
#define FLEXCOMM_PSELID_SPIPRESENT(x)            (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_SPIPRESENT_SHIFT)) & FLEXCOMM_PSELID_SPIPRESENT_MASK)

#define FLEXCOMM_PSELID_I2CPRESENT_MASK          (0x40U)
#define FLEXCOMM_PSELID_I2CPRESENT_SHIFT         (6U)
/*! I2CPRESENT - I2C present indicator
 *  0b0..I2C Not Present
 *  0b1..I2C Present
 */
#define FLEXCOMM_PSELID_I2CPRESENT(x)            (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_I2CPRESENT_SHIFT)) & FLEXCOMM_PSELID_I2CPRESENT_MASK)

#define FLEXCOMM_PSELID_I2SPRESENT_MASK          (0x80U)
#define FLEXCOMM_PSELID_I2SPRESENT_SHIFT         (7U)
/*! I2SPRESENT - I2S Present
 *  0b0..I2S Not Present
 *  0b1..I2S Present
 */
#define FLEXCOMM_PSELID_I2SPRESENT(x)            (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_I2SPRESENT_SHIFT)) & FLEXCOMM_PSELID_I2SPRESENT_MASK)

#define FLEXCOMM_PSELID_ID_MASK                  (0xFFFFF000U)
#define FLEXCOMM_PSELID_ID_SHIFT                 (12U)
/*! ID - Flexcomm ID
 */
#define FLEXCOMM_PSELID_ID(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_ID_SHIFT)) & FLEXCOMM_PSELID_ID_MASK)
/*! @} */

/*! @name PID - Peripheral Identification */
/*! @{ */

#define FLEXCOMM_PID_Minor_Rev_MASK              (0xF00U)
#define FLEXCOMM_PID_Minor_Rev_SHIFT             (8U)
/*! Minor_Rev - Minor revision of module implementation
 */
#define FLEXCOMM_PID_Minor_Rev(x)                (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PID_Minor_Rev_SHIFT)) & FLEXCOMM_PID_Minor_Rev_MASK)

#define FLEXCOMM_PID_Major_Rev_MASK              (0xF000U)
#define FLEXCOMM_PID_Major_Rev_SHIFT             (12U)
/*! Major_Rev - Major revision of module implementation
 */
#define FLEXCOMM_PID_Major_Rev(x)                (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PID_Major_Rev_SHIFT)) & FLEXCOMM_PID_Major_Rev_MASK)

#define FLEXCOMM_PID_ID_MASK                     (0xFFFF0000U)
#define FLEXCOMM_PID_ID_SHIFT                    (16U)
/*! ID - Module identifier for the selected function
 */
#define FLEXCOMM_PID_ID(x)                       (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PID_ID_SHIFT)) & FLEXCOMM_PID_ID_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group FLEXCOMM_Register_Masks */


/* FLEXCOMM - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral FLEXCOMM0 base address */
  #define FLEXCOMM0_BASE                           (0x50086000u)
  /** Peripheral FLEXCOMM0 base address */
  #define FLEXCOMM0_BASE_NS                        (0x40086000u)
  /** Peripheral FLEXCOMM0 base pointer */
  #define FLEXCOMM0                                ((FLEXCOMM_Type *)FLEXCOMM0_BASE)
  /** Peripheral FLEXCOMM0 base pointer */
  #define FLEXCOMM0_NS                             ((FLEXCOMM_Type *)FLEXCOMM0_BASE_NS)
  /** Peripheral FLEXCOMM1 base address */
  #define FLEXCOMM1_BASE                           (0x50087000u)
  /** Peripheral FLEXCOMM1 base address */
  #define FLEXCOMM1_BASE_NS                        (0x40087000u)
  /** Peripheral FLEXCOMM1 base pointer */
  #define FLEXCOMM1                                ((FLEXCOMM_Type *)FLEXCOMM1_BASE)
  /** Peripheral FLEXCOMM1 base pointer */
  #define FLEXCOMM1_NS                             ((FLEXCOMM_Type *)FLEXCOMM1_BASE_NS)
  /** Peripheral FLEXCOMM2 base address */
  #define FLEXCOMM2_BASE                           (0x50088000u)
  /** Peripheral FLEXCOMM2 base address */
  #define FLEXCOMM2_BASE_NS                        (0x40088000u)
  /** Peripheral FLEXCOMM2 base pointer */
  #define FLEXCOMM2                                ((FLEXCOMM_Type *)FLEXCOMM2_BASE)
  /** Peripheral FLEXCOMM2 base pointer */
  #define FLEXCOMM2_NS                             ((FLEXCOMM_Type *)FLEXCOMM2_BASE_NS)
  /** Peripheral FLEXCOMM3 base address */
  #define FLEXCOMM3_BASE                           (0x50089000u)
  /** Peripheral FLEXCOMM3 base address */
  #define FLEXCOMM3_BASE_NS                        (0x40089000u)
  /** Peripheral FLEXCOMM3 base pointer */
  #define FLEXCOMM3                                ((FLEXCOMM_Type *)FLEXCOMM3_BASE)
  /** Peripheral FLEXCOMM3 base pointer */
  #define FLEXCOMM3_NS                             ((FLEXCOMM_Type *)FLEXCOMM3_BASE_NS)
  /** Peripheral FLEXCOMM4 base address */
  #define FLEXCOMM4_BASE                           (0x5008A000u)
  /** Peripheral FLEXCOMM4 base address */
  #define FLEXCOMM4_BASE_NS                        (0x4008A000u)
  /** Peripheral FLEXCOMM4 base pointer */
  #define FLEXCOMM4                                ((FLEXCOMM_Type *)FLEXCOMM4_BASE)
  /** Peripheral FLEXCOMM4 base pointer */
  #define FLEXCOMM4_NS                             ((FLEXCOMM_Type *)FLEXCOMM4_BASE_NS)
  /** Peripheral FLEXCOMM5 base address */
  #define FLEXCOMM5_BASE                           (0x50096000u)
  /** Peripheral FLEXCOMM5 base address */
  #define FLEXCOMM5_BASE_NS                        (0x40096000u)
  /** Peripheral FLEXCOMM5 base pointer */
  #define FLEXCOMM5                                ((FLEXCOMM_Type *)FLEXCOMM5_BASE)
  /** Peripheral FLEXCOMM5 base pointer */
  #define FLEXCOMM5_NS                             ((FLEXCOMM_Type *)FLEXCOMM5_BASE_NS)
  /** Peripheral FLEXCOMM6 base address */
  #define FLEXCOMM6_BASE                           (0x50097000u)
  /** Peripheral FLEXCOMM6 base address */
  #define FLEXCOMM6_BASE_NS                        (0x40097000u)
  /** Peripheral FLEXCOMM6 base pointer */
  #define FLEXCOMM6                                ((FLEXCOMM_Type *)FLEXCOMM6_BASE)
  /** Peripheral FLEXCOMM6 base pointer */
  #define FLEXCOMM6_NS                             ((FLEXCOMM_Type *)FLEXCOMM6_BASE_NS)
  /** Peripheral FLEXCOMM7 base address */
  #define FLEXCOMM7_BASE                           (0x50098000u)
  /** Peripheral FLEXCOMM7 base address */
  #define FLEXCOMM7_BASE_NS                        (0x40098000u)
  /** Peripheral FLEXCOMM7 base pointer */
  #define FLEXCOMM7                                ((FLEXCOMM_Type *)FLEXCOMM7_BASE)
  /** Peripheral FLEXCOMM7 base pointer */
  #define FLEXCOMM7_NS                             ((FLEXCOMM_Type *)FLEXCOMM7_BASE_NS)
  /** Peripheral FLEXCOMM8 base address */
  #define FLEXCOMM8_BASE                           (0x5009F000u)
  /** Peripheral FLEXCOMM8 base address */
  #define FLEXCOMM8_BASE_NS                        (0x4009F000u)
  /** Peripheral FLEXCOMM8 base pointer */
  #define FLEXCOMM8                                ((FLEXCOMM_Type *)FLEXCOMM8_BASE)
  /** Peripheral FLEXCOMM8 base pointer */
  #define FLEXCOMM8_NS                             ((FLEXCOMM_Type *)FLEXCOMM8_BASE_NS)
  /** Array initializer of FLEXCOMM peripheral base addresses */
  #define FLEXCOMM_BASE_ADDRS                      { FLEXCOMM0_BASE, FLEXCOMM1_BASE, FLEXCOMM2_BASE, FLEXCOMM3_BASE, FLEXCOMM4_BASE, FLEXCOMM5_BASE, FLEXCOMM6_BASE, FLEXCOMM7_BASE, FLEXCOMM8_BASE }
  /** Array initializer of FLEXCOMM peripheral base pointers */
  #define FLEXCOMM_BASE_PTRS                       { FLEXCOMM0, FLEXCOMM1, FLEXCOMM2, FLEXCOMM3, FLEXCOMM4, FLEXCOMM5, FLEXCOMM6, FLEXCOMM7, FLEXCOMM8 }
  /** Array initializer of FLEXCOMM peripheral base addresses */
  #define FLEXCOMM_BASE_ADDRS_NS                   { FLEXCOMM0_BASE_NS, FLEXCOMM1_BASE_NS, FLEXCOMM2_BASE_NS, FLEXCOMM3_BASE_NS, FLEXCOMM4_BASE_NS, FLEXCOMM5_BASE_NS, FLEXCOMM6_BASE_NS, FLEXCOMM7_BASE_NS, FLEXCOMM8_BASE_NS }
  /** Array initializer of FLEXCOMM peripheral base pointers */
  #define FLEXCOMM_BASE_PTRS_NS                    { FLEXCOMM0_NS, FLEXCOMM1_NS, FLEXCOMM2_NS, FLEXCOMM3_NS, FLEXCOMM4_NS, FLEXCOMM5_NS, FLEXCOMM6_NS, FLEXCOMM7_NS, FLEXCOMM8_NS }
#else
  /** Peripheral FLEXCOMM0 base address */
  #define FLEXCOMM0_BASE                           (0x40086000u)
  /** Peripheral FLEXCOMM0 base pointer */
  #define FLEXCOMM0                                ((FLEXCOMM_Type *)FLEXCOMM0_BASE)
  /** Peripheral FLEXCOMM1 base address */
  #define FLEXCOMM1_BASE                           (0x40087000u)
  /** Peripheral FLEXCOMM1 base pointer */
  #define FLEXCOMM1                                ((FLEXCOMM_Type *)FLEXCOMM1_BASE)
  /** Peripheral FLEXCOMM2 base address */
  #define FLEXCOMM2_BASE                           (0x40088000u)
  /** Peripheral FLEXCOMM2 base pointer */
  #define FLEXCOMM2                                ((FLEXCOMM_Type *)FLEXCOMM2_BASE)
  /** Peripheral FLEXCOMM3 base address */
  #define FLEXCOMM3_BASE                           (0x40089000u)
  /** Peripheral FLEXCOMM3 base pointer */
  #define FLEXCOMM3                                ((FLEXCOMM_Type *)FLEXCOMM3_BASE)
  /** Peripheral FLEXCOMM4 base address */
  #define FLEXCOMM4_BASE                           (0x4008A000u)
  /** Peripheral FLEXCOMM4 base pointer */
  #define FLEXCOMM4                                ((FLEXCOMM_Type *)FLEXCOMM4_BASE)
  /** Peripheral FLEXCOMM5 base address */
  #define FLEXCOMM5_BASE                           (0x40096000u)
  /** Peripheral FLEXCOMM5 base pointer */
  #define FLEXCOMM5                                ((FLEXCOMM_Type *)FLEXCOMM5_BASE)
  /** Peripheral FLEXCOMM6 base address */
  #define FLEXCOMM6_BASE                           (0x40097000u)
  /** Peripheral FLEXCOMM6 base pointer */
  #define FLEXCOMM6                                ((FLEXCOMM_Type *)FLEXCOMM6_BASE)
  /** Peripheral FLEXCOMM7 base address */
  #define FLEXCOMM7_BASE                           (0x40098000u)
  /** Peripheral FLEXCOMM7 base pointer */
  #define FLEXCOMM7                                ((FLEXCOMM_Type *)FLEXCOMM7_BASE)
  /** Peripheral FLEXCOMM8 base address */
  #define FLEXCOMM8_BASE                           (0x4009F000u)
  /** Peripheral FLEXCOMM8 base pointer */
  #define FLEXCOMM8                                ((FLEXCOMM_Type *)FLEXCOMM8_BASE)
  /** Array initializer of FLEXCOMM peripheral base addresses */
  #define FLEXCOMM_BASE_ADDRS                      { FLEXCOMM0_BASE, FLEXCOMM1_BASE, FLEXCOMM2_BASE, FLEXCOMM3_BASE, FLEXCOMM4_BASE, FLEXCOMM5_BASE, FLEXCOMM6_BASE, FLEXCOMM7_BASE, FLEXCOMM8_BASE }
  /** Array initializer of FLEXCOMM peripheral base pointers */
  #define FLEXCOMM_BASE_PTRS                       { FLEXCOMM0, FLEXCOMM1, FLEXCOMM2, FLEXCOMM3, FLEXCOMM4, FLEXCOMM5, FLEXCOMM6, FLEXCOMM7, FLEXCOMM8 }
#endif
/** Interrupt vectors for the FLEXCOMM peripheral type */
#define FLEXCOMM_IRQS                            { FLEXCOMM0_IRQn, FLEXCOMM1_IRQn, FLEXCOMM2_IRQn, FLEXCOMM3_IRQn, FLEXCOMM4_IRQn, FLEXCOMM5_IRQn, FLEXCOMM6_IRQn, FLEXCOMM7_IRQn, FLEXCOMM8_IRQn }

/*!
 * @}
 */ /* end of group FLEXCOMM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FLEXSPI Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXSPI_Peripheral_Access_Layer FLEXSPI Peripheral Access Layer
 * @{
 */

/** FLEXSPI - Register Layout Typedef */
typedef struct {
  __IO uint32_t MCR0;                              /**< Module Control Register 0, offset: 0x0 */
  __IO uint32_t MCR1;                              /**< Module Control Register 1, offset: 0x4 */
  __IO uint32_t MCR2;                              /**< Module Control Register 2, offset: 0x8 */
  __IO uint32_t AHBCR;                             /**< AHB Bus Control Register, offset: 0xC */
  __IO uint32_t INTEN;                             /**< Interrupt Enable Register, offset: 0x10 */
  __IO uint32_t INTR;                              /**< Interrupt Register, offset: 0x14 */
  __I  uint32_t LUTKEY;                            /**< LUT Key Register, offset: 0x18 */
  __IO uint32_t LUTCR;                             /**< LUT Control Register, offset: 0x1C */
  __IO uint32_t AHBRXBUFCR0[8];                    /**< AHB RX Buffer 0 Control Register 0..AHB RX Buffer 7 Control Register 0, array offset: 0x20, array step: 0x4 */
       uint8_t RESERVED_0[32];
  __IO uint32_t FLSHCR0[2];                        /**< Flash Control Register 0, array offset: 0x60, array step: 0x4 */
       uint8_t RESERVED_1[8];
  __IO uint32_t FLSHCR1[2];                        /**< Flash Control Register 1, array offset: 0x70, array step: 0x4 */
       uint8_t RESERVED_2[8];
  __IO uint32_t FLSHCR2[2];                        /**< Flash Control Register 2, array offset: 0x80, array step: 0x4 */
       uint8_t RESERVED_3[12];
  __IO uint32_t FLSHCR4;                           /**< Flash Control Register 4, offset: 0x94 */
       uint8_t RESERVED_4[8];
  __IO uint32_t IPCR0;                             /**< IP Control Register 0, offset: 0xA0 */
  __IO uint32_t IPCR1;                             /**< IP Control Register 1, offset: 0xA4 */
       uint8_t RESERVED_5[8];
  __IO uint32_t IPCMD;                             /**< IP Command Register, offset: 0xB0 */
  __IO uint32_t DLPR;                              /**< Data Learn Pattern Register, offset: 0xB4 */
  __IO uint32_t IPRXFCR;                           /**< IP RX FIFO Control Register, offset: 0xB8 */
  __IO uint32_t IPTXFCR;                           /**< IP TX FIFO Control Register, offset: 0xBC */
  __IO uint32_t DLLCR[2];                          /**< DLL Control Register 0, array offset: 0xC0, array step: 0x4 */
       uint8_t RESERVED_6[24];
  __I  uint32_t STS0;                              /**< Status Register 0, offset: 0xE0 */
  __I  uint32_t STS1;                              /**< Status Register 1, offset: 0xE4 */
  __I  uint32_t STS2;                              /**< Status Register 2, offset: 0xE8 */
  __I  uint32_t AHBSPNDSTS;                        /**< AHB Suspend Status Register, offset: 0xEC */
  __I  uint32_t IPRXFSTS;                          /**< IP RX FIFO Status Register, offset: 0xF0 */
  __I  uint32_t IPTXFSTS;                          /**< IP TX FIFO Status Register, offset: 0xF4 */
       uint8_t RESERVED_7[8];
  __I  uint32_t RFDR[32];                          /**< IP RX FIFO Data Register 0..IP RX FIFO Data Register 31, array offset: 0x100, array step: 0x4 */
  __O  uint32_t TFDR[32];                          /**< IP TX FIFO Data Register 0..IP TX FIFO Data Register 31, array offset: 0x180, array step: 0x4 */
  __IO uint32_t LUT[64];                           /**< LUT 0..LUT 63, array offset: 0x200, array step: 0x4 */
       uint8_t RESERVED_8[288];
  __IO uint32_t HADDRSTART;                        /**< HADDR REMAP START ADDR, offset: 0x420 */
  __IO uint32_t HADDREND;                          /**< HADDR REMAP END ADDR, offset: 0x424 */
  __IO uint32_t HADDROFFSET;                       /**< HADDR REMAP OFFSET, offset: 0x428 */
  __IO uint32_t IPEDCTRL;                          /**< IPED function control, offset: 0x42C */
       uint8_t RESERVED_9[208];
  __IO uint32_t IPEDCTXCTRL[2];                    /**< IPED context control 0..IPED context control 1, array offset: 0x500, array step: 0x4 */
       uint8_t RESERVED_10[24];
  __IO uint32_t IPEDCTX0IV0;                       /**< IPED context0 IV0, offset: 0x520 */
  __IO uint32_t IPEDCTX0IV1;                       /**< IPED context0 IV1, offset: 0x524 */
  __IO uint32_t IPEDCTX0START;                     /**< Start address of region 0, offset: 0x528 */
  __IO uint32_t IPEDCTX0END;                       /**< End address of region 0, offset: 0x52C */
  __IO uint32_t IPEDCTX0AAD0;                      /**< IPED context0 AAD0, offset: 0x530 */
  __IO uint32_t IPEDCTX0AAD1;                      /**< IPED context0 AAD1, offset: 0x534 */
       uint8_t RESERVED_11[8];
  __IO uint32_t IPEDCTX1IV0;                       /**< IPED context1 IV0, offset: 0x540 */
  __IO uint32_t IPEDCTX1IV1;                       /**< IPED context1 IV1, offset: 0x544 */
  __IO uint32_t IPEDCTX1START;                     /**< Start address of region 1, offset: 0x548 */
  __IO uint32_t IPEDCTX1END;                       /**< End address of region 1, offset: 0x54C */
  __IO uint32_t IPEDCTX1AAD0;                      /**< IPED context1 AAD0, offset: 0x550 */
  __IO uint32_t IPEDCTX1AAD1;                      /**< IPED context1 AAD1, offset: 0x554 */
       uint8_t RESERVED_12[8];
  __IO uint32_t IPEDCTX2IV0;                       /**< IPED context2 IV0, offset: 0x560 */
  __IO uint32_t IPEDCTX2IV1;                       /**< IPED context2 IV1, offset: 0x564 */
  __IO uint32_t IPEDCTX2START;                     /**< Start address of region 2, offset: 0x568 */
  __IO uint32_t IPEDCTX2END;                       /**< End address of region 2, offset: 0x56C */
  __IO uint32_t IPEDCTX2AAD0;                      /**< IPED context2 AAD0, offset: 0x570 */
  __IO uint32_t IPEDCTX2AAD1;                      /**< IPED context2 AAD1, offset: 0x574 */
       uint8_t RESERVED_13[8];
  __IO uint32_t IPEDCTX3IV0;                       /**< IPED context3 IV0, offset: 0x580 */
  __IO uint32_t IPEDCTX3IV1;                       /**< IPED context3 IV1, offset: 0x584 */
  __IO uint32_t IPEDCTX3START;                     /**< Start address of region 3, offset: 0x588 */
  __IO uint32_t IPEDCTX3END;                       /**< End address of region 3, offset: 0x58C */
  __IO uint32_t IPEDCTX3AAD0;                      /**< IPED context3 AAD0, offset: 0x590 */
  __IO uint32_t IPEDCTX3AAD1;                      /**< IPED context3 AAD1, offset: 0x594 */
} FLEXSPI_Type;

/* ----------------------------------------------------------------------------
   -- FLEXSPI Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXSPI_Register_Masks FLEXSPI Register Masks
 * @{
 */

/*! @name MCR0 - Module Control Register 0 */
/*! @{ */

#define FLEXSPI_MCR0_SWRESET_MASK                (0x1U)
#define FLEXSPI_MCR0_SWRESET_SHIFT               (0U)
/*! SWRESET - Software Reset
 */
#define FLEXSPI_MCR0_SWRESET(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_SWRESET_SHIFT)) & FLEXSPI_MCR0_SWRESET_MASK)

#define FLEXSPI_MCR0_MDIS_MASK                   (0x2U)
#define FLEXSPI_MCR0_MDIS_SHIFT                  (1U)
/*! MDIS - Module Disable
 */
#define FLEXSPI_MCR0_MDIS(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_MDIS_SHIFT)) & FLEXSPI_MCR0_MDIS_MASK)

#define FLEXSPI_MCR0_RXCLKSRC_MASK               (0x30U)
#define FLEXSPI_MCR0_RXCLKSRC_SHIFT              (4U)
/*! RXCLKSRC - Sample Clock source selection for Flash Reading
 *  0b00..Dummy Read strobe generated by FlexSPI Controller and loopback internally.
 *  0b01..Dummy Read strobe generated by FlexSPI Controller and loopback from DQS pad.
 *  0b10..SCLK output clock and loopback from SCLK pad
 *  0b11..Flash provided Read strobe and input from DQS pad
 */
#define FLEXSPI_MCR0_RXCLKSRC(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_RXCLKSRC_SHIFT)) & FLEXSPI_MCR0_RXCLKSRC_MASK)

#define FLEXSPI_MCR0_SERCLKDIV_MASK              (0x700U)
#define FLEXSPI_MCR0_SERCLKDIV_SHIFT             (8U)
/*! SERCLKDIV - Serial root clock
 *  0b000..Divided by 1
 *  0b001..Divided by 2
 *  0b010..Divided by 3
 *  0b011..Divided by 4
 *  0b100..Divided by 5
 *  0b101..Divided by 6
 *  0b110..Divided by 7
 *  0b111..Divided by 8
 */
#define FLEXSPI_MCR0_SERCLKDIV(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_SERCLKDIV_SHIFT)) & FLEXSPI_MCR0_SERCLKDIV_MASK)

#define FLEXSPI_MCR0_HSEN_MASK                   (0x800U)
#define FLEXSPI_MCR0_HSEN_SHIFT                  (11U)
/*! HSEN - Half Speed Serial Flash access Enable.
 *  0b0..Disable divide by 2 of serial flash clock for half speed commands.
 *  0b1..Enable divide by 2 of serial flash clock for half speed commands.
 */
#define FLEXSPI_MCR0_HSEN(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_HSEN_SHIFT)) & FLEXSPI_MCR0_HSEN_MASK)

#define FLEXSPI_MCR0_DOZEEN_MASK                 (0x1000U)
#define FLEXSPI_MCR0_DOZEEN_SHIFT                (12U)
/*! DOZEEN - Doze mode enable bit
 *  0b0..Doze mode support disabled. AHB clock and serial clock will not be gated off when there is doze mode request from system.
 *  0b1..Doze mode support enabled. AHB clock and serial clock will be gated off when there is doze mode request from system.
 */
#define FLEXSPI_MCR0_DOZEEN(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_DOZEEN_SHIFT)) & FLEXSPI_MCR0_DOZEEN_MASK)

#define FLEXSPI_MCR0_SCKFREERUNEN_MASK           (0x4000U)
#define FLEXSPI_MCR0_SCKFREERUNEN_SHIFT          (14U)
/*! SCKFREERUNEN - This bit is used to force SCLK output free-running. For FPGA applications,
 *    external device may use SCLK as reference clock to its internal PLL. If SCLK free-running is
 *    enabled, data sampling with loopback clock from SCLK pad is not supported (MCR0[RXCLKSRC]=2).
 *  0b0..Disable.
 *  0b1..Enable.
 */
#define FLEXSPI_MCR0_SCKFREERUNEN(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_SCKFREERUNEN_SHIFT)) & FLEXSPI_MCR0_SCKFREERUNEN_MASK)

#define FLEXSPI_MCR0_LEARNEN_MASK                (0x8000U)
#define FLEXSPI_MCR0_LEARNEN_SHIFT               (15U)
/*! LEARNEN - This bit is used to enable/disable data learning feature. When data learning is
 *    disabled, the sampling clock phase 0 is always used for RX data sampling even if LEARN instruction
 *    is correctly executed.
 *  0b0..Disable.
 *  0b1..Enable.
 */
#define FLEXSPI_MCR0_LEARNEN(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_LEARNEN_SHIFT)) & FLEXSPI_MCR0_LEARNEN_MASK)

#define FLEXSPI_MCR0_IPGRANTWAIT_MASK            (0xFF0000U)
#define FLEXSPI_MCR0_IPGRANTWAIT_SHIFT           (16U)
/*! IPGRANTWAIT - Timeout wait cycle for IP command grant.
 */
#define FLEXSPI_MCR0_IPGRANTWAIT(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_IPGRANTWAIT_SHIFT)) & FLEXSPI_MCR0_IPGRANTWAIT_MASK)

#define FLEXSPI_MCR0_AHBGRANTWAIT_MASK           (0xFF000000U)
#define FLEXSPI_MCR0_AHBGRANTWAIT_SHIFT          (24U)
/*! AHBGRANTWAIT - Timeout wait cycle for AHB command grant.
 */
#define FLEXSPI_MCR0_AHBGRANTWAIT(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_AHBGRANTWAIT_SHIFT)) & FLEXSPI_MCR0_AHBGRANTWAIT_MASK)
/*! @} */

/*! @name MCR1 - Module Control Register 1 */
/*! @{ */

#define FLEXSPI_MCR1_AHBBUSWAIT_MASK             (0xFFFFU)
#define FLEXSPI_MCR1_AHBBUSWAIT_SHIFT            (0U)
/*! AHBBUSWAIT - AHB Bus wait
 */
#define FLEXSPI_MCR1_AHBBUSWAIT(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR1_AHBBUSWAIT_SHIFT)) & FLEXSPI_MCR1_AHBBUSWAIT_MASK)

#define FLEXSPI_MCR1_SEQWAIT_MASK                (0xFFFF0000U)
#define FLEXSPI_MCR1_SEQWAIT_SHIFT               (16U)
/*! SEQWAIT - Command Sequence Execution will timeout and abort after SEQWAIT * 1024 Serial Root
 *    Clock cycles. When sequence execution timeout occurs, there will be an interrupt generated
 *    (INTR[SEQTIMEOUT]) if this interrupt is enabled (INTEN[SEQTIMEOUTEN] is set 0x1) and AHB command is
 *    ignored by arbitrator.
 */
#define FLEXSPI_MCR1_SEQWAIT(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR1_SEQWAIT_SHIFT)) & FLEXSPI_MCR1_SEQWAIT_MASK)
/*! @} */

/*! @name MCR2 - Module Control Register 2 */
/*! @{ */

#define FLEXSPI_MCR2_CLRAHBBUFOPT_MASK           (0x800U)
#define FLEXSPI_MCR2_CLRAHBBUFOPT_SHIFT          (11U)
/*! CLRAHBBUFOPT - Clear AHB buffer
 *  0b0..AHB RX/TX Buffer will not be cleaned automatically when FlexSPI return Stop mode ACK.
 *  0b1..AHB RX/TX Buffer will be cleaned automatically when FlexSPI return Stop mode ACK.
 */
#define FLEXSPI_MCR2_CLRAHBBUFOPT(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR2_CLRAHBBUFOPT_SHIFT)) & FLEXSPI_MCR2_CLRAHBBUFOPT_MASK)

#define FLEXSPI_MCR2_CLRLEARNPHASE_MASK          (0x4000U)
#define FLEXSPI_MCR2_CLRLEARNPHASE_SHIFT         (14U)
/*! CLRLEARNPHASE - The sampling clock phase selection will be reset to phase 0 when this bit is
 *    written with 0x1. This bit will be auto-cleared immediately.
 */
#define FLEXSPI_MCR2_CLRLEARNPHASE(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR2_CLRLEARNPHASE_SHIFT)) & FLEXSPI_MCR2_CLRLEARNPHASE_MASK)

#define FLEXSPI_MCR2_SAMEDEVICEEN_MASK           (0x8000U)
#define FLEXSPI_MCR2_SAMEDEVICEEN_SHIFT          (15U)
/*! SAMEDEVICEEN - All external devices are same devices (both in types and size) for A1/A2/B1/B2.
 *  0b0..In Individual mode, FLSHA1CRx/FLSHA2CRx register setting will be applied to Flash A1/A2 separately. Disabled.
 *  0b1..FLSHA1CR0/FLSHA1CR1/FLSHA1CR2 register settings will be applied to Flash A1/A2. FLSHA2CRx will be ignored.
 */
#define FLEXSPI_MCR2_SAMEDEVICEEN(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR2_SAMEDEVICEEN_SHIFT)) & FLEXSPI_MCR2_SAMEDEVICEEN_MASK)

#define FLEXSPI_MCR2_RESUMEWAIT_MASK             (0xFF000000U)
#define FLEXSPI_MCR2_RESUMEWAIT_SHIFT            (24U)
/*! RESUMEWAIT - Wait cycle (in AHB clock cycle) for idle state before suspended command sequence resumed.
 */
#define FLEXSPI_MCR2_RESUMEWAIT(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR2_RESUMEWAIT_SHIFT)) & FLEXSPI_MCR2_RESUMEWAIT_MASK)
/*! @} */

/*! @name AHBCR - AHB Bus Control Register */
/*! @{ */

#define FLEXSPI_AHBCR_CLRAHBRXBUF_MASK           (0x2U)
#define FLEXSPI_AHBCR_CLRAHBRXBUF_SHIFT          (1U)
/*! CLRAHBRXBUF - Clear the status/pointers of AHB RX Buffer. Auto-cleared.
 */
#define FLEXSPI_AHBCR_CLRAHBRXBUF(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBCR_CLRAHBRXBUF_SHIFT)) & FLEXSPI_AHBCR_CLRAHBRXBUF_MASK)

#define FLEXSPI_AHBCR_CLRAHBTXBUF_MASK           (0x4U)
#define FLEXSPI_AHBCR_CLRAHBTXBUF_SHIFT          (2U)
/*! CLRAHBTXBUF - Clear the status/pointers of AHB TX Buffer. Auto-cleared.
 */
#define FLEXSPI_AHBCR_CLRAHBTXBUF(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBCR_CLRAHBTXBUF_SHIFT)) & FLEXSPI_AHBCR_CLRAHBTXBUF_MASK)

#define FLEXSPI_AHBCR_CACHABLEEN_MASK            (0x8U)
#define FLEXSPI_AHBCR_CACHABLEEN_SHIFT           (3U)
/*! CACHABLEEN - Enable AHB bus cachable read access support.
 *  0b0..Disabled. When there is AHB bus cachable read access, FlexSPI will not check whether it hit AHB TX Buffer.
 *  0b1..Enabled. When there is AHB bus cachable read access, FlexSPI will check whether it hit AHB TX Buffer first.
 */
#define FLEXSPI_AHBCR_CACHABLEEN(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBCR_CACHABLEEN_SHIFT)) & FLEXSPI_AHBCR_CACHABLEEN_MASK)

#define FLEXSPI_AHBCR_BUFFERABLEEN_MASK          (0x10U)
#define FLEXSPI_AHBCR_BUFFERABLEEN_SHIFT         (4U)
/*! BUFFERABLEEN - Enable AHB bus bufferable write access support.
 *  0b0..Disabled. For all AHB write access (no matter bufferable or non-bufferable ), FlexSPI will return AHB Bus
 *       ready after all data is transmitted to External device and AHB command finished.
 *  0b1..Enabled. For AHB bufferable write access, FlexSPI will return AHB Bus ready when the AHB command is
 *       granted by arbitrator and will not wait for AHB command finished.
 */
#define FLEXSPI_AHBCR_BUFFERABLEEN(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBCR_BUFFERABLEEN_SHIFT)) & FLEXSPI_AHBCR_BUFFERABLEEN_MASK)

#define FLEXSPI_AHBCR_PREFETCHEN_MASK            (0x20U)
#define FLEXSPI_AHBCR_PREFETCHEN_SHIFT           (5U)
/*! PREFETCHEN - AHB Read Prefetch Enable.
 */
#define FLEXSPI_AHBCR_PREFETCHEN(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBCR_PREFETCHEN_SHIFT)) & FLEXSPI_AHBCR_PREFETCHEN_MASK)

#define FLEXSPI_AHBCR_READADDROPT_MASK           (0x40U)
#define FLEXSPI_AHBCR_READADDROPT_SHIFT          (6U)
/*! READADDROPT - AHB Read Address option bit. This option bit is intend to remove AHB burst start address alignment limitation.
 *  0b0..There is AHB read burst start address alignment limitation when flash is accessed in flash is word-addressable.
 *  0b1..There is no AHB read burst start address alignment limitation. FlexSPI will fetch more data than AHB
 *       burst required to meet the alignment requirement.
 */
#define FLEXSPI_AHBCR_READADDROPT(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBCR_READADDROPT_SHIFT)) & FLEXSPI_AHBCR_READADDROPT_MASK)

#define FLEXSPI_AHBCR_READSZALIGN_MASK           (0x400U)
#define FLEXSPI_AHBCR_READSZALIGN_SHIFT          (10U)
/*! READSZALIGN - AHB Read Size Alignment
 *  0b0..AHB read size will be decided by other register setting like PREFETCH_EN
 *  0b1..AHB read size to up size to 8 bytes aligned, no prefetching
 */
#define FLEXSPI_AHBCR_READSZALIGN(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBCR_READSZALIGN_SHIFT)) & FLEXSPI_AHBCR_READSZALIGN_MASK)

#define FLEXSPI_AHBCR_ALIGNMENT_MASK             (0x300000U)
#define FLEXSPI_AHBCR_ALIGNMENT_SHIFT            (20U)
/*! ALIGNMENT - Decides all AHB read/write boundary. All access cross the boundary will be divided into smaller sub accesses.
 *  0b00..No limit
 *  0b01..1 KBytes
 *  0b10..512 Bytes
 *  0b11..256 Bytes
 */
#define FLEXSPI_AHBCR_ALIGNMENT(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBCR_ALIGNMENT_SHIFT)) & FLEXSPI_AHBCR_ALIGNMENT_MASK)
/*! @} */

/*! @name INTEN - Interrupt Enable Register */
/*! @{ */

#define FLEXSPI_INTEN_IPCMDDONEEN_MASK           (0x1U)
#define FLEXSPI_INTEN_IPCMDDONEEN_SHIFT          (0U)
/*! IPCMDDONEEN - IP triggered Command Sequences Execution finished interrupt enable.
 */
#define FLEXSPI_INTEN_IPCMDDONEEN(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_IPCMDDONEEN_SHIFT)) & FLEXSPI_INTEN_IPCMDDONEEN_MASK)

#define FLEXSPI_INTEN_IPCMDGEEN_MASK             (0x2U)
#define FLEXSPI_INTEN_IPCMDGEEN_SHIFT            (1U)
/*! IPCMDGEEN - IP triggered Command Sequences Grant Timeout interrupt enable.
 */
#define FLEXSPI_INTEN_IPCMDGEEN(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_IPCMDGEEN_SHIFT)) & FLEXSPI_INTEN_IPCMDGEEN_MASK)

#define FLEXSPI_INTEN_AHBCMDGEEN_MASK            (0x4U)
#define FLEXSPI_INTEN_AHBCMDGEEN_SHIFT           (2U)
/*! AHBCMDGEEN - AHB triggered Command Sequences Grant Timeout interrupt enable.
 */
#define FLEXSPI_INTEN_AHBCMDGEEN(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_AHBCMDGEEN_SHIFT)) & FLEXSPI_INTEN_AHBCMDGEEN_MASK)

#define FLEXSPI_INTEN_IPCMDERREN_MASK            (0x8U)
#define FLEXSPI_INTEN_IPCMDERREN_SHIFT           (3U)
/*! IPCMDERREN - IP triggered Command Sequences Error Detected interrupt enable.
 */
#define FLEXSPI_INTEN_IPCMDERREN(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_IPCMDERREN_SHIFT)) & FLEXSPI_INTEN_IPCMDERREN_MASK)

#define FLEXSPI_INTEN_AHBCMDERREN_MASK           (0x10U)
#define FLEXSPI_INTEN_AHBCMDERREN_SHIFT          (4U)
/*! AHBCMDERREN - AHB triggered Command Sequences Error Detected interrupt enable.
 */
#define FLEXSPI_INTEN_AHBCMDERREN(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_AHBCMDERREN_SHIFT)) & FLEXSPI_INTEN_AHBCMDERREN_MASK)

#define FLEXSPI_INTEN_IPRXWAEN_MASK              (0x20U)
#define FLEXSPI_INTEN_IPRXWAEN_SHIFT             (5U)
/*! IPRXWAEN - IP RX FIFO WaterMark available interrupt enable.
 */
#define FLEXSPI_INTEN_IPRXWAEN(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_IPRXWAEN_SHIFT)) & FLEXSPI_INTEN_IPRXWAEN_MASK)

#define FLEXSPI_INTEN_IPTXWEEN_MASK              (0x40U)
#define FLEXSPI_INTEN_IPTXWEEN_SHIFT             (6U)
/*! IPTXWEEN - IP TX FIFO WaterMark empty interrupt enable.
 */
#define FLEXSPI_INTEN_IPTXWEEN(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_IPTXWEEN_SHIFT)) & FLEXSPI_INTEN_IPTXWEEN_MASK)

#define FLEXSPI_INTEN_DATALEARNFAILEN_MASK       (0x80U)
#define FLEXSPI_INTEN_DATALEARNFAILEN_SHIFT      (7U)
/*! DATALEARNFAILEN - Data Learning failed interrupt enable.
 */
#define FLEXSPI_INTEN_DATALEARNFAILEN(x)         (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_DATALEARNFAILEN_SHIFT)) & FLEXSPI_INTEN_DATALEARNFAILEN_MASK)

#define FLEXSPI_INTEN_SCKSTOPBYRDEN_MASK         (0x100U)
#define FLEXSPI_INTEN_SCKSTOPBYRDEN_SHIFT        (8U)
/*! SCKSTOPBYRDEN - SCLK is stopped during command sequence because Async RX FIFO full interrupt enable.
 */
#define FLEXSPI_INTEN_SCKSTOPBYRDEN(x)           (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_SCKSTOPBYRDEN_SHIFT)) & FLEXSPI_INTEN_SCKSTOPBYRDEN_MASK)

#define FLEXSPI_INTEN_SCKSTOPBYWREN_MASK         (0x200U)
#define FLEXSPI_INTEN_SCKSTOPBYWREN_SHIFT        (9U)
/*! SCKSTOPBYWREN - SCLK is stopped during command sequence because Async TX FIFO empty interrupt enable.
 */
#define FLEXSPI_INTEN_SCKSTOPBYWREN(x)           (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_SCKSTOPBYWREN_SHIFT)) & FLEXSPI_INTEN_SCKSTOPBYWREN_MASK)

#define FLEXSPI_INTEN_AHBBUSTIMEOUTEN_MASK       (0x400U)
#define FLEXSPI_INTEN_AHBBUSTIMEOUTEN_SHIFT      (10U)
/*! AHBBUSTIMEOUTEN - AHB Bus timeout interrupt.
 */
#define FLEXSPI_INTEN_AHBBUSTIMEOUTEN(x)         (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_AHBBUSTIMEOUTEN_SHIFT)) & FLEXSPI_INTEN_AHBBUSTIMEOUTEN_MASK)

#define FLEXSPI_INTEN_SEQTIMEOUTEN_MASK          (0x800U)
#define FLEXSPI_INTEN_SEQTIMEOUTEN_SHIFT         (11U)
/*! SEQTIMEOUTEN - Sequence execution timeout interrupt enable.
 */
#define FLEXSPI_INTEN_SEQTIMEOUTEN(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_SEQTIMEOUTEN_SHIFT)) & FLEXSPI_INTEN_SEQTIMEOUTEN_MASK)

#define FLEXSPI_INTEN_IPCMDSECUREVIOEN_MASK      (0x10000U)
#define FLEXSPI_INTEN_IPCMDSECUREVIOEN_SHIFT     (16U)
/*! IPCMDSECUREVIOEN - IP command security violation interrupt enable.
 */
#define FLEXSPI_INTEN_IPCMDSECUREVIOEN(x)        (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_IPCMDSECUREVIOEN_SHIFT)) & FLEXSPI_INTEN_IPCMDSECUREVIOEN_MASK)

#define FLEXSPI_INTEN_AHBGCMERREN_MASK           (0x20000U)
#define FLEXSPI_INTEN_AHBGCMERREN_SHIFT          (17U)
/*! AHBGCMERREN - AHB read gcm error interrupt enable.
 */
#define FLEXSPI_INTEN_AHBGCMERREN(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_AHBGCMERREN_SHIFT)) & FLEXSPI_INTEN_AHBGCMERREN_MASK)
/*! @} */

/*! @name INTR - Interrupt Register */
/*! @{ */

#define FLEXSPI_INTR_IPCMDDONE_MASK              (0x1U)
#define FLEXSPI_INTR_IPCMDDONE_SHIFT             (0U)
/*! IPCMDDONE - IP triggered Command Sequences Execution finished interrupt. This interrupt is also
 *    generated when there is IPCMDGE or IPCMDERR interrupt generated.
 */
#define FLEXSPI_INTR_IPCMDDONE(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_IPCMDDONE_SHIFT)) & FLEXSPI_INTR_IPCMDDONE_MASK)

#define FLEXSPI_INTR_IPCMDGE_MASK                (0x2U)
#define FLEXSPI_INTR_IPCMDGE_SHIFT               (1U)
/*! IPCMDGE - IP triggered Command Sequences Grant Timeout interrupt.
 */
#define FLEXSPI_INTR_IPCMDGE(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_IPCMDGE_SHIFT)) & FLEXSPI_INTR_IPCMDGE_MASK)

#define FLEXSPI_INTR_AHBCMDGE_MASK               (0x4U)
#define FLEXSPI_INTR_AHBCMDGE_SHIFT              (2U)
/*! AHBCMDGE - AHB triggered Command Sequences Grant Timeout interrupt.
 */
#define FLEXSPI_INTR_AHBCMDGE(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_AHBCMDGE_SHIFT)) & FLEXSPI_INTR_AHBCMDGE_MASK)

#define FLEXSPI_INTR_IPCMDERR_MASK               (0x8U)
#define FLEXSPI_INTR_IPCMDERR_SHIFT              (3U)
/*! IPCMDERR - IP triggered Command Sequences Error Detected interrupt. When an error detected for
 *    IP command, this command will be ignored and not executed at all.
 */
#define FLEXSPI_INTR_IPCMDERR(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_IPCMDERR_SHIFT)) & FLEXSPI_INTR_IPCMDERR_MASK)

#define FLEXSPI_INTR_AHBCMDERR_MASK              (0x10U)
#define FLEXSPI_INTR_AHBCMDERR_SHIFT             (4U)
/*! AHBCMDERR - AHB triggered Command Sequences Error Detected interrupt. When an error detected for
 *    AHB command, this command will be ignored and not executed at all.
 */
#define FLEXSPI_INTR_AHBCMDERR(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_AHBCMDERR_SHIFT)) & FLEXSPI_INTR_AHBCMDERR_MASK)

#define FLEXSPI_INTR_IPRXWA_MASK                 (0x20U)
#define FLEXSPI_INTR_IPRXWA_SHIFT                (5U)
/*! IPRXWA - IP RX FIFO watermark available interrupt.
 */
#define FLEXSPI_INTR_IPRXWA(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_IPRXWA_SHIFT)) & FLEXSPI_INTR_IPRXWA_MASK)

#define FLEXSPI_INTR_IPTXWE_MASK                 (0x40U)
#define FLEXSPI_INTR_IPTXWE_SHIFT                (6U)
/*! IPTXWE - IP TX FIFO watermark empty interrupt.
 */
#define FLEXSPI_INTR_IPTXWE(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_IPTXWE_SHIFT)) & FLEXSPI_INTR_IPTXWE_MASK)

#define FLEXSPI_INTR_DATALEARNFAIL_MASK          (0x80U)
#define FLEXSPI_INTR_DATALEARNFAIL_SHIFT         (7U)
/*! DATALEARNFAIL - Data Learning failed interrupt.
 */
#define FLEXSPI_INTR_DATALEARNFAIL(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_DATALEARNFAIL_SHIFT)) & FLEXSPI_INTR_DATALEARNFAIL_MASK)

#define FLEXSPI_INTR_SCKSTOPBYRD_MASK            (0x100U)
#define FLEXSPI_INTR_SCKSTOPBYRD_SHIFT           (8U)
/*! SCKSTOPBYRD - SCLK is stopped during command sequence because Async RX FIFO full interrupt.
 */
#define FLEXSPI_INTR_SCKSTOPBYRD(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_SCKSTOPBYRD_SHIFT)) & FLEXSPI_INTR_SCKSTOPBYRD_MASK)

#define FLEXSPI_INTR_SCKSTOPBYWR_MASK            (0x200U)
#define FLEXSPI_INTR_SCKSTOPBYWR_SHIFT           (9U)
/*! SCKSTOPBYWR - SCLK is stopped during command sequence because Async TX FIFO empty interrupt.
 */
#define FLEXSPI_INTR_SCKSTOPBYWR(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_SCKSTOPBYWR_SHIFT)) & FLEXSPI_INTR_SCKSTOPBYWR_MASK)

#define FLEXSPI_INTR_AHBBUSTIMEOUT_MASK          (0x400U)
#define FLEXSPI_INTR_AHBBUSTIMEOUT_SHIFT         (10U)
/*! AHBBUSTIMEOUT - AHB Bus timeout interrupt.
 */
#define FLEXSPI_INTR_AHBBUSTIMEOUT(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_AHBBUSTIMEOUT_SHIFT)) & FLEXSPI_INTR_AHBBUSTIMEOUT_MASK)

#define FLEXSPI_INTR_SEQTIMEOUT_MASK             (0x800U)
#define FLEXSPI_INTR_SEQTIMEOUT_SHIFT            (11U)
/*! SEQTIMEOUT - Sequence execution timeout interrupt.
 */
#define FLEXSPI_INTR_SEQTIMEOUT(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_SEQTIMEOUT_SHIFT)) & FLEXSPI_INTR_SEQTIMEOUT_MASK)

#define FLEXSPI_INTR_IPCMDSECUREVIO_MASK         (0x10000U)
#define FLEXSPI_INTR_IPCMDSECUREVIO_SHIFT        (16U)
/*! IPCMDSECUREVIO - IP command security violation interrupt.
 */
#define FLEXSPI_INTR_IPCMDSECUREVIO(x)           (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_IPCMDSECUREVIO_SHIFT)) & FLEXSPI_INTR_IPCMDSECUREVIO_MASK)

#define FLEXSPI_INTR_AHBGCMERR_MASK              (0x20000U)
#define FLEXSPI_INTR_AHBGCMERR_SHIFT             (17U)
/*! AHBGCMERR - AHB read gcm error interrupt.
 */
#define FLEXSPI_INTR_AHBGCMERR(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_AHBGCMERR_SHIFT)) & FLEXSPI_INTR_AHBGCMERR_MASK)
/*! @} */

/*! @name LUTKEY - LUT Key Register */
/*! @{ */

#define FLEXSPI_LUTKEY_KEY_MASK                  (0xFFFFFFFFU)
#define FLEXSPI_LUTKEY_KEY_SHIFT                 (0U)
/*! KEY - The Key to lock or unlock LUT.
 */
#define FLEXSPI_LUTKEY_KEY(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXSPI_LUTKEY_KEY_SHIFT)) & FLEXSPI_LUTKEY_KEY_MASK)
/*! @} */

/*! @name LUTCR - LUT Control Register */
/*! @{ */

#define FLEXSPI_LUTCR_LOCK_MASK                  (0x1U)
#define FLEXSPI_LUTCR_LOCK_SHIFT                 (0U)
/*! LOCK - Lock LUT
 */
#define FLEXSPI_LUTCR_LOCK(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXSPI_LUTCR_LOCK_SHIFT)) & FLEXSPI_LUTCR_LOCK_MASK)

#define FLEXSPI_LUTCR_UNLOCK_MASK                (0x2U)
#define FLEXSPI_LUTCR_UNLOCK_SHIFT               (1U)
/*! UNLOCK - Unlock LUT
 */
#define FLEXSPI_LUTCR_UNLOCK(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_LUTCR_UNLOCK_SHIFT)) & FLEXSPI_LUTCR_UNLOCK_MASK)

#define FLEXSPI_LUTCR_PROTECT_MASK               (0x4U)
#define FLEXSPI_LUTCR_PROTECT_SHIFT              (2U)
/*! PROTECT - LUT protection
 */
#define FLEXSPI_LUTCR_PROTECT(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_LUTCR_PROTECT_SHIFT)) & FLEXSPI_LUTCR_PROTECT_MASK)
/*! @} */

/*! @name AHBRXBUFCR0 - AHB RX Buffer 0 Control Register 0..AHB RX Buffer 7 Control Register 0 */
/*! @{ */

#define FLEXSPI_AHBRXBUFCR0_BUFSZ_MASK           (0xFFU)
#define FLEXSPI_AHBRXBUFCR0_BUFSZ_SHIFT          (0U)
/*! BUFSZ - AHB RX Buffer Size in 64 bits.
 */
#define FLEXSPI_AHBRXBUFCR0_BUFSZ(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBRXBUFCR0_BUFSZ_SHIFT)) & FLEXSPI_AHBRXBUFCR0_BUFSZ_MASK)

#define FLEXSPI_AHBRXBUFCR0_MSTRID_MASK          (0xF0000U)
#define FLEXSPI_AHBRXBUFCR0_MSTRID_SHIFT         (16U)
/*! MSTRID - This AHB RX Buffer is assigned according to AHB Master with ID (MSTR_ID).
 */
#define FLEXSPI_AHBRXBUFCR0_MSTRID(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBRXBUFCR0_MSTRID_SHIFT)) & FLEXSPI_AHBRXBUFCR0_MSTRID_MASK)

#define FLEXSPI_AHBRXBUFCR0_PRIORITY_MASK        (0x7000000U)
#define FLEXSPI_AHBRXBUFCR0_PRIORITY_SHIFT       (24U)
/*! PRIORITY - This priority for AHB Master Read which this AHB RX Buffer is assigned. 7 is the highest priority, 0 the lowest.
 */
#define FLEXSPI_AHBRXBUFCR0_PRIORITY(x)          (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBRXBUFCR0_PRIORITY_SHIFT)) & FLEXSPI_AHBRXBUFCR0_PRIORITY_MASK)

#define FLEXSPI_AHBRXBUFCR0_PREFETCHEN_MASK      (0x80000000U)
#define FLEXSPI_AHBRXBUFCR0_PREFETCHEN_SHIFT     (31U)
/*! PREFETCHEN - AHB Read Prefetch Enable for current AHB RX Buffer corresponding Master.
 */
#define FLEXSPI_AHBRXBUFCR0_PREFETCHEN(x)        (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBRXBUFCR0_PREFETCHEN_SHIFT)) & FLEXSPI_AHBRXBUFCR0_PREFETCHEN_MASK)
/*! @} */

/* The count of FLEXSPI_AHBRXBUFCR0 */
#define FLEXSPI_AHBRXBUFCR0_COUNT                (8U)

/*! @name FLSHCR0 - Flash Control Register 0 */
/*! @{ */

#define FLEXSPI_FLSHCR0_FLSHSZ_MASK              (0x7FFFFFU)
#define FLEXSPI_FLSHCR0_FLSHSZ_SHIFT             (0U)
/*! FLSHSZ - Flash Size in KByte.
 */
#define FLEXSPI_FLSHCR0_FLSHSZ(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR0_FLSHSZ_SHIFT)) & FLEXSPI_FLSHCR0_FLSHSZ_MASK)

#define FLEXSPI_FLSHCR0_SPLITWREN_MASK           (0x40000000U)
#define FLEXSPI_FLSHCR0_SPLITWREN_SHIFT          (30U)
/*! SPLITWREN - AHB write access split function control.
 */
#define FLEXSPI_FLSHCR0_SPLITWREN(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR0_SPLITWREN_SHIFT)) & FLEXSPI_FLSHCR0_SPLITWREN_MASK)

#define FLEXSPI_FLSHCR0_SPLITRDEN_MASK           (0x80000000U)
#define FLEXSPI_FLSHCR0_SPLITRDEN_SHIFT          (31U)
/*! SPLITRDEN - AHB read access split function control.
 */
#define FLEXSPI_FLSHCR0_SPLITRDEN(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR0_SPLITRDEN_SHIFT)) & FLEXSPI_FLSHCR0_SPLITRDEN_MASK)
/*! @} */

/* The count of FLEXSPI_FLSHCR0 */
#define FLEXSPI_FLSHCR0_COUNT                    (2U)

/*! @name FLSHCR1 - Flash Control Register 1 */
/*! @{ */

#define FLEXSPI_FLSHCR1_TCSS_MASK                (0x1FU)
#define FLEXSPI_FLSHCR1_TCSS_SHIFT               (0U)
/*! TCSS - Serial Flash CS setup time.
 */
#define FLEXSPI_FLSHCR1_TCSS(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR1_TCSS_SHIFT)) & FLEXSPI_FLSHCR1_TCSS_MASK)

#define FLEXSPI_FLSHCR1_TCSH_MASK                (0x3E0U)
#define FLEXSPI_FLSHCR1_TCSH_SHIFT               (5U)
/*! TCSH - Serial Flash CS Hold time.
 */
#define FLEXSPI_FLSHCR1_TCSH(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR1_TCSH_SHIFT)) & FLEXSPI_FLSHCR1_TCSH_MASK)

#define FLEXSPI_FLSHCR1_WA_MASK                  (0x400U)
#define FLEXSPI_FLSHCR1_WA_SHIFT                 (10U)
/*! WA - Word Addressable.
 */
#define FLEXSPI_FLSHCR1_WA(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR1_WA_SHIFT)) & FLEXSPI_FLSHCR1_WA_MASK)

#define FLEXSPI_FLSHCR1_CAS_MASK                 (0x7800U)
#define FLEXSPI_FLSHCR1_CAS_SHIFT                (11U)
/*! CAS - Column Address Size.
 */
#define FLEXSPI_FLSHCR1_CAS(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR1_CAS_SHIFT)) & FLEXSPI_FLSHCR1_CAS_MASK)

#define FLEXSPI_FLSHCR1_CSINTERVALUNIT_MASK      (0x8000U)
#define FLEXSPI_FLSHCR1_CSINTERVALUNIT_SHIFT     (15U)
/*! CSINTERVALUNIT - CS interval unit
 *  0b0..The CS interval unit is 1 serial clock cycle
 *  0b1..The CS interval unit is 256 serial clock cycle
 */
#define FLEXSPI_FLSHCR1_CSINTERVALUNIT(x)        (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR1_CSINTERVALUNIT_SHIFT)) & FLEXSPI_FLSHCR1_CSINTERVALUNIT_MASK)

#define FLEXSPI_FLSHCR1_CSINTERVAL_MASK          (0xFFFF0000U)
#define FLEXSPI_FLSHCR1_CSINTERVAL_SHIFT         (16U)
/*! CSINTERVAL - This field is used to set the minimum interval between flash device Chip selection
 *    deassertion and flash device Chip selection assertion. If external flash has a limitation on
 *    the interval between command sequences, this field should be set accordingly. If there is no
 *    limitation, set this field with value 0x0.
 */
#define FLEXSPI_FLSHCR1_CSINTERVAL(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR1_CSINTERVAL_SHIFT)) & FLEXSPI_FLSHCR1_CSINTERVAL_MASK)
/*! @} */

/* The count of FLEXSPI_FLSHCR1 */
#define FLEXSPI_FLSHCR1_COUNT                    (2U)

/*! @name FLSHCR2 - Flash Control Register 2 */
/*! @{ */

#define FLEXSPI_FLSHCR2_ARDSEQID_MASK            (0xFU)
#define FLEXSPI_FLSHCR2_ARDSEQID_SHIFT           (0U)
/*! ARDSEQID - Sequence Index for AHB Read triggered Command in LUT.
 */
#define FLEXSPI_FLSHCR2_ARDSEQID(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR2_ARDSEQID_SHIFT)) & FLEXSPI_FLSHCR2_ARDSEQID_MASK)

#define FLEXSPI_FLSHCR2_ARDSEQNUM_MASK           (0xE0U)
#define FLEXSPI_FLSHCR2_ARDSEQNUM_SHIFT          (5U)
/*! ARDSEQNUM - Sequence Number for AHB Read triggered Command in LUT.
 */
#define FLEXSPI_FLSHCR2_ARDSEQNUM(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR2_ARDSEQNUM_SHIFT)) & FLEXSPI_FLSHCR2_ARDSEQNUM_MASK)

#define FLEXSPI_FLSHCR2_AWRSEQID_MASK            (0xF00U)
#define FLEXSPI_FLSHCR2_AWRSEQID_SHIFT           (8U)
/*! AWRSEQID - Sequence Index for AHB Write triggered Command.
 */
#define FLEXSPI_FLSHCR2_AWRSEQID(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR2_AWRSEQID_SHIFT)) & FLEXSPI_FLSHCR2_AWRSEQID_MASK)

#define FLEXSPI_FLSHCR2_AWRSEQNUM_MASK           (0xE000U)
#define FLEXSPI_FLSHCR2_AWRSEQNUM_SHIFT          (13U)
/*! AWRSEQNUM - Sequence Number for AHB Write triggered Command.
 */
#define FLEXSPI_FLSHCR2_AWRSEQNUM(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR2_AWRSEQNUM_SHIFT)) & FLEXSPI_FLSHCR2_AWRSEQNUM_MASK)

#define FLEXSPI_FLSHCR2_AWRWAIT_MASK             (0xFFF0000U)
#define FLEXSPI_FLSHCR2_AWRWAIT_SHIFT            (16U)
/*! AWRWAIT - For certain devices (such as FPGA), it need some time to write data into internal
 *    memory after the command sequences finished on FlexSPI interface. If another Read command sequence
 *    comes before previous programming finished internally, the read data may be wrong. This field
 *    is used to hold AHB Bus ready for AHB write access to wait the programming finished in
 *    external device. Then there will be no AHB read command triggered before the programming finished in
 *    external device. The Wait cycle between AHB triggered command sequences finished on FlexSPI
 *    interface and AHB return Bus ready: AWRWAIT * AWRWAITUNIT
 */
#define FLEXSPI_FLSHCR2_AWRWAIT(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR2_AWRWAIT_SHIFT)) & FLEXSPI_FLSHCR2_AWRWAIT_MASK)

#define FLEXSPI_FLSHCR2_AWRWAITUNIT_MASK         (0x70000000U)
#define FLEXSPI_FLSHCR2_AWRWAITUNIT_SHIFT        (28U)
/*! AWRWAITUNIT - AWRWAIT unit
 *  0b000..The AWRWAIT unit is 2 ahb clock cycle
 *  0b001..The AWRWAIT unit is 8 ahb clock cycle
 *  0b010..The AWRWAIT unit is 32 ahb clock cycle
 *  0b011..The AWRWAIT unit is 128 ahb clock cycle
 *  0b100..The AWRWAIT unit is 512 ahb clock cycle
 *  0b101..The AWRWAIT unit is 2048 ahb clock cycle
 *  0b110..The AWRWAIT unit is 8192 ahb clock cycle
 *  0b111..The AWRWAIT unit is 32768 ahb clock cycle
 */
#define FLEXSPI_FLSHCR2_AWRWAITUNIT(x)           (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR2_AWRWAITUNIT_SHIFT)) & FLEXSPI_FLSHCR2_AWRWAITUNIT_MASK)

#define FLEXSPI_FLSHCR2_CLRINSTRPTR_MASK         (0x80000000U)
#define FLEXSPI_FLSHCR2_CLRINSTRPTR_SHIFT        (31U)
/*! CLRINSTRPTR - Clear the instruction pointer which is internally saved pointer by JMP_ON_CS.
 */
#define FLEXSPI_FLSHCR2_CLRINSTRPTR(x)           (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR2_CLRINSTRPTR_SHIFT)) & FLEXSPI_FLSHCR2_CLRINSTRPTR_MASK)
/*! @} */

/* The count of FLEXSPI_FLSHCR2 */
#define FLEXSPI_FLSHCR2_COUNT                    (2U)

/*! @name FLSHCR4 - Flash Control Register 4 */
/*! @{ */

#define FLEXSPI_FLSHCR4_WMOPT1_MASK              (0x1U)
#define FLEXSPI_FLSHCR4_WMOPT1_SHIFT             (0U)
/*! WMOPT1 - Write mask option bit 1. This option bit could be used to remove AHB write burst start address alignment limitation.
 *  0b0..DQS pin will be used as Write Mask when writing to external device. There is no limitation on AHB write
 *       burst start address alignment when flash is accessed in individual mode.
 *  0b1..DQS pin will not be used as Write Mask when writing to external device. There is limitation on AHB write
 *       burst start address alignment when flash is accessed in individual mode.
 */
#define FLEXSPI_FLSHCR4_WMOPT1(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR4_WMOPT1_SHIFT)) & FLEXSPI_FLSHCR4_WMOPT1_MASK)

#define FLEXSPI_FLSHCR4_WMENA_MASK               (0x4U)
#define FLEXSPI_FLSHCR4_WMENA_SHIFT              (2U)
/*! WMENA - Write mask enable bit for flash device on port A. When write mask function is needed for
 *    memory device on port A, this bit must be set.
 *  0b0..Write mask is disabled, DQS(RWDS) pin will not be driven when writing to external device.
 *  0b1..Write mask is enabled, DQS(RWDS) pin will be driven by FlexSPI as write mask output when writing to external device.
 */
#define FLEXSPI_FLSHCR4_WMENA(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR4_WMENA_SHIFT)) & FLEXSPI_FLSHCR4_WMENA_MASK)
/*! @} */

/*! @name IPCR0 - IP Control Register 0 */
/*! @{ */

#define FLEXSPI_IPCR0_SFAR_MASK                  (0xFFFFFFFFU)
#define FLEXSPI_IPCR0_SFAR_SHIFT                 (0U)
/*! SFAR - Serial Flash Address for IP command.
 */
#define FLEXSPI_IPCR0_SFAR(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPCR0_SFAR_SHIFT)) & FLEXSPI_IPCR0_SFAR_MASK)
/*! @} */

/*! @name IPCR1 - IP Control Register 1 */
/*! @{ */

#define FLEXSPI_IPCR1_IDATSZ_MASK                (0xFFFFU)
#define FLEXSPI_IPCR1_IDATSZ_SHIFT               (0U)
/*! IDATSZ - Flash Read/Program Data Size (in Bytes) for IP command.
 */
#define FLEXSPI_IPCR1_IDATSZ(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPCR1_IDATSZ_SHIFT)) & FLEXSPI_IPCR1_IDATSZ_MASK)

#define FLEXSPI_IPCR1_ISEQID_MASK                (0xF0000U)
#define FLEXSPI_IPCR1_ISEQID_SHIFT               (16U)
/*! ISEQID - Sequence Index in LUT for IP command.
 */
#define FLEXSPI_IPCR1_ISEQID(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPCR1_ISEQID_SHIFT)) & FLEXSPI_IPCR1_ISEQID_MASK)

#define FLEXSPI_IPCR1_ISEQNUM_MASK               (0x7000000U)
#define FLEXSPI_IPCR1_ISEQNUM_SHIFT              (24U)
/*! ISEQNUM - Sequence Number for IP command: ISEQNUM+1.
 */
#define FLEXSPI_IPCR1_ISEQNUM(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPCR1_ISEQNUM_SHIFT)) & FLEXSPI_IPCR1_ISEQNUM_MASK)
/*! @} */

/*! @name IPCMD - IP Command Register */
/*! @{ */

#define FLEXSPI_IPCMD_TRG_MASK                   (0x1U)
#define FLEXSPI_IPCMD_TRG_SHIFT                  (0U)
/*! TRG - Setting this bit will trigger an IP Command.
 */
#define FLEXSPI_IPCMD_TRG(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPCMD_TRG_SHIFT)) & FLEXSPI_IPCMD_TRG_MASK)
/*! @} */

/*! @name DLPR - Data Learn Pattern Register */
/*! @{ */

#define FLEXSPI_DLPR_DLP_MASK                    (0xFFFFFFFFU)
#define FLEXSPI_DLPR_DLP_SHIFT                   (0U)
/*! DLP - Data Learning Pattern.
 */
#define FLEXSPI_DLPR_DLP(x)                      (((uint32_t)(((uint32_t)(x)) << FLEXSPI_DLPR_DLP_SHIFT)) & FLEXSPI_DLPR_DLP_MASK)
/*! @} */

/*! @name IPRXFCR - IP RX FIFO Control Register */
/*! @{ */

#define FLEXSPI_IPRXFCR_CLRIPRXF_MASK            (0x1U)
#define FLEXSPI_IPRXFCR_CLRIPRXF_SHIFT           (0U)
/*! CLRIPRXF - Clear all valid data entries in IP RX FIFO.
 */
#define FLEXSPI_IPRXFCR_CLRIPRXF(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPRXFCR_CLRIPRXF_SHIFT)) & FLEXSPI_IPRXFCR_CLRIPRXF_MASK)

#define FLEXSPI_IPRXFCR_RXDMAEN_MASK             (0x2U)
#define FLEXSPI_IPRXFCR_RXDMAEN_SHIFT            (1U)
/*! RXDMAEN - IP RX FIFO reading by DMA enabled.
 *  0b0..IP RX FIFO would be read by processor.
 *  0b1..IP RX FIFO would be read by DMA.
 */
#define FLEXSPI_IPRXFCR_RXDMAEN(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPRXFCR_RXDMAEN_SHIFT)) & FLEXSPI_IPRXFCR_RXDMAEN_MASK)

#define FLEXSPI_IPRXFCR_RXWMRK_MASK              (0x1FCU)
#define FLEXSPI_IPRXFCR_RXWMRK_SHIFT             (2U)
/*! RXWMRK - Watermark level is (RXWMRK+1)*64 Bits.
 */
#define FLEXSPI_IPRXFCR_RXWMRK(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPRXFCR_RXWMRK_SHIFT)) & FLEXSPI_IPRXFCR_RXWMRK_MASK)
/*! @} */

/*! @name IPTXFCR - IP TX FIFO Control Register */
/*! @{ */

#define FLEXSPI_IPTXFCR_CLRIPTXF_MASK            (0x1U)
#define FLEXSPI_IPTXFCR_CLRIPTXF_SHIFT           (0U)
/*! CLRIPTXF - Clear all valid data entries in IP TX FIFO.
 */
#define FLEXSPI_IPTXFCR_CLRIPTXF(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPTXFCR_CLRIPTXF_SHIFT)) & FLEXSPI_IPTXFCR_CLRIPTXF_MASK)

#define FLEXSPI_IPTXFCR_TXDMAEN_MASK             (0x2U)
#define FLEXSPI_IPTXFCR_TXDMAEN_SHIFT            (1U)
/*! TXDMAEN - IP TX FIFO filling by DMA enabled.
 *  0b0..IP TX FIFO would be filled by processor.
 *  0b1..IP TX FIFO would be filled by DMA.
 */
#define FLEXSPI_IPTXFCR_TXDMAEN(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPTXFCR_TXDMAEN_SHIFT)) & FLEXSPI_IPTXFCR_TXDMAEN_MASK)

#define FLEXSPI_IPTXFCR_TXWMRK_MASK              (0x1FCU)
#define FLEXSPI_IPTXFCR_TXWMRK_SHIFT             (2U)
/*! TXWMRK - Watermark level is (TXWMRK+1)*64 Bits.
 */
#define FLEXSPI_IPTXFCR_TXWMRK(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPTXFCR_TXWMRK_SHIFT)) & FLEXSPI_IPTXFCR_TXWMRK_MASK)
/*! @} */

/*! @name DLLCR - DLL Control Register 0 */
/*! @{ */

#define FLEXSPI_DLLCR_DLLEN_MASK                 (0x1U)
#define FLEXSPI_DLLCR_DLLEN_SHIFT                (0U)
/*! DLLEN - DLL calibration enable.
 */
#define FLEXSPI_DLLCR_DLLEN(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_DLLCR_DLLEN_SHIFT)) & FLEXSPI_DLLCR_DLLEN_MASK)

#define FLEXSPI_DLLCR_DLLRESET_MASK              (0x2U)
#define FLEXSPI_DLLCR_DLLRESET_SHIFT             (1U)
/*! DLLRESET - DLL reset
 */
#define FLEXSPI_DLLCR_DLLRESET(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_DLLCR_DLLRESET_SHIFT)) & FLEXSPI_DLLCR_DLLRESET_MASK)

#define FLEXSPI_DLLCR_SLVDLYTARGET_MASK          (0x78U)
#define FLEXSPI_DLLCR_SLVDLYTARGET_SHIFT         (3U)
/*! SLVDLYTARGET - The delay target for slave delay line is: ((SLVDLYTARGET+1) * 1/32 * clock cycle
 *    of reference clock (serial root clock). If serial root clock is >= 100 MHz, DLLEN set to 0x1,
 *    OVRDEN set to =0x0, then SLVDLYTARGET setting of 0xF is recommended.
 */
#define FLEXSPI_DLLCR_SLVDLYTARGET(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_DLLCR_SLVDLYTARGET_SHIFT)) & FLEXSPI_DLLCR_SLVDLYTARGET_MASK)

#define FLEXSPI_DLLCR_OVRDEN_MASK                (0x100U)
#define FLEXSPI_DLLCR_OVRDEN_SHIFT               (8U)
/*! OVRDEN - Slave clock delay line delay cell number selection override enable.
 */
#define FLEXSPI_DLLCR_OVRDEN(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_DLLCR_OVRDEN_SHIFT)) & FLEXSPI_DLLCR_OVRDEN_MASK)

#define FLEXSPI_DLLCR_OVRDVAL_MASK               (0x7E00U)
#define FLEXSPI_DLLCR_OVRDVAL_SHIFT              (9U)
/*! OVRDVAL - Slave clock delay line delay cell number selection override value.
 */
#define FLEXSPI_DLLCR_OVRDVAL(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_DLLCR_OVRDVAL_SHIFT)) & FLEXSPI_DLLCR_OVRDVAL_MASK)
/*! @} */

/* The count of FLEXSPI_DLLCR */
#define FLEXSPI_DLLCR_COUNT                      (2U)

/*! @name STS0 - Status Register 0 */
/*! @{ */

#define FLEXSPI_STS0_SEQIDLE_MASK                (0x1U)
#define FLEXSPI_STS0_SEQIDLE_SHIFT               (0U)
/*! SEQIDLE - This status bit indicates the state machine in SEQ_CTL is idle and there is command
 *    sequence executing on FlexSPI interface.
 */
#define FLEXSPI_STS0_SEQIDLE(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS0_SEQIDLE_SHIFT)) & FLEXSPI_STS0_SEQIDLE_MASK)

#define FLEXSPI_STS0_ARBIDLE_MASK                (0x2U)
#define FLEXSPI_STS0_ARBIDLE_SHIFT               (1U)
/*! ARBIDLE - This status bit indicates the state machine in ARB_CTL is busy and there is command
 *    sequence granted by arbitrator and not finished yet on FlexSPI interface. When ARB_CTL state
 *    (ARBIDLE=0x1) is idle, there will be no transaction on FlexSPI interface also (SEQIDLE=0x1). So
 *    this bit should be polled to wait for FlexSPI controller become idle instead of SEQIDLE.
 */
#define FLEXSPI_STS0_ARBIDLE(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS0_ARBIDLE_SHIFT)) & FLEXSPI_STS0_ARBIDLE_MASK)

#define FLEXSPI_STS0_ARBCMDSRC_MASK              (0xCU)
#define FLEXSPI_STS0_ARBCMDSRC_SHIFT             (2U)
/*! ARBCMDSRC - This status field indicates the trigger source of current command sequence granted
 *    by arbitrator. This field value is meaningless when ARB_CTL is not busy (STS0[ARBIDLE]=0x1).
 *  0b00..Triggered by AHB read command (triggered by AHB read).
 *  0b01..Triggered by AHB write command (triggered by AHB Write).
 *  0b10..Triggered by IP command (triggered by setting register bit IPCMD.TRG).
 *  0b11..Triggered by suspended command (resumed).
 */
#define FLEXSPI_STS0_ARBCMDSRC(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS0_ARBCMDSRC_SHIFT)) & FLEXSPI_STS0_ARBCMDSRC_MASK)

#define FLEXSPI_STS0_DATALEARNPHASEA_MASK        (0xF0U)
#define FLEXSPI_STS0_DATALEARNPHASEA_SHIFT       (4U)
/*! DATALEARNPHASEA - Indicate the sampling clock phase selection on Port A after Data Learning.
 */
#define FLEXSPI_STS0_DATALEARNPHASEA(x)          (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS0_DATALEARNPHASEA_SHIFT)) & FLEXSPI_STS0_DATALEARNPHASEA_MASK)
/*! @} */

/*! @name STS1 - Status Register 1 */
/*! @{ */

#define FLEXSPI_STS1_AHBCMDERRID_MASK            (0xFU)
#define FLEXSPI_STS1_AHBCMDERRID_SHIFT           (0U)
/*! AHBCMDERRID - Indicates the sequence index when an AHB command error is detected. This field
 *    will be cleared when INTR[AHBCMDERR] is write-1-clear(w1c).
 */
#define FLEXSPI_STS1_AHBCMDERRID(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS1_AHBCMDERRID_SHIFT)) & FLEXSPI_STS1_AHBCMDERRID_MASK)

#define FLEXSPI_STS1_AHBCMDERRCODE_MASK          (0xF00U)
#define FLEXSPI_STS1_AHBCMDERRCODE_SHIFT         (8U)
/*! AHBCMDERRCODE - Indicates the Error Code when AHB command Error detected. This field will be
 *    cleared when INTR[AHBCMDERR] is write-1-clear(w1c).
 *  0b0000..No error.
 *  0b0010..AHB Write command with JMP_ON_CS instruction used in the sequence.
 *  0b0011..There is unknown instruction opcode in the sequence.
 *  0b0100..Instruction DUMMY_SDR/DUMMY_RWDS_SDR used in DDR sequence.
 *  0b0101..Instruction DUMMY_DDR/DUMMY_RWDS_DDR used in SDR sequence.
 *  0b1110..Sequence execution timeout.
 */
#define FLEXSPI_STS1_AHBCMDERRCODE(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS1_AHBCMDERRCODE_SHIFT)) & FLEXSPI_STS1_AHBCMDERRCODE_MASK)

#define FLEXSPI_STS1_IPCMDERRID_MASK             (0xF0000U)
#define FLEXSPI_STS1_IPCMDERRID_SHIFT            (16U)
/*! IPCMDERRID - Indicates the sequence Index when IP command error detected.
 */
#define FLEXSPI_STS1_IPCMDERRID(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS1_IPCMDERRID_SHIFT)) & FLEXSPI_STS1_IPCMDERRID_MASK)

#define FLEXSPI_STS1_IPCMDERRCODE_MASK           (0xF000000U)
#define FLEXSPI_STS1_IPCMDERRCODE_SHIFT          (24U)
/*! IPCMDERRCODE - Indicates the Error Code when IP command Error detected. This field will be
 *    cleared when INTR[IPCMDERR] is write-1-clear(w1c).
 *  0b0000..No error.
 *  0b0010..IP command with JMP_ON_CS instruction used in the sequence.
 *  0b0011..There is unknown instruction opcode in the sequence.
 *  0b0100..Instruction DUMMY_SDR/DUMMY_RWDS_SDR used in DDR sequence.
 *  0b0101..Instruction DUMMY_DDR/DUMMY_RWDS_DDR used in SDR sequence.
 *  0b0110..Flash access start address exceed the whole flash address range (A1/A2/B1/B2).
 *  0b1110..Sequence execution timeout.
 *  0b1111..Flash boundary crossed.
 */
#define FLEXSPI_STS1_IPCMDERRCODE(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS1_IPCMDERRCODE_SHIFT)) & FLEXSPI_STS1_IPCMDERRCODE_MASK)
/*! @} */

/*! @name STS2 - Status Register 2 */
/*! @{ */

#define FLEXSPI_STS2_ASLVLOCK_MASK               (0x1U)
#define FLEXSPI_STS2_ASLVLOCK_SHIFT              (0U)
/*! ASLVLOCK - Flash A sample clock slave delay line locked.
 */
#define FLEXSPI_STS2_ASLVLOCK(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS2_ASLVLOCK_SHIFT)) & FLEXSPI_STS2_ASLVLOCK_MASK)

#define FLEXSPI_STS2_AREFLOCK_MASK               (0x2U)
#define FLEXSPI_STS2_AREFLOCK_SHIFT              (1U)
/*! AREFLOCK - Flash A sample clock reference delay line locked.
 */
#define FLEXSPI_STS2_AREFLOCK(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS2_AREFLOCK_SHIFT)) & FLEXSPI_STS2_AREFLOCK_MASK)

#define FLEXSPI_STS2_ASLVSEL_MASK                (0xFCU)
#define FLEXSPI_STS2_ASLVSEL_SHIFT               (2U)
/*! ASLVSEL - Flash A sample clock slave delay line delay cell number selection .
 */
#define FLEXSPI_STS2_ASLVSEL(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS2_ASLVSEL_SHIFT)) & FLEXSPI_STS2_ASLVSEL_MASK)

#define FLEXSPI_STS2_AREFSEL_MASK                (0x3F00U)
#define FLEXSPI_STS2_AREFSEL_SHIFT               (8U)
/*! AREFSEL - Flash A sample clock reference delay line delay cell number selection.
 */
#define FLEXSPI_STS2_AREFSEL(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS2_AREFSEL_SHIFT)) & FLEXSPI_STS2_AREFSEL_MASK)
/*! @} */

/*! @name AHBSPNDSTS - AHB Suspend Status Register */
/*! @{ */

#define FLEXSPI_AHBSPNDSTS_ACTIVE_MASK           (0x1U)
#define FLEXSPI_AHBSPNDSTS_ACTIVE_SHIFT          (0U)
/*! ACTIVE - Indicates if an AHB read prefetch command sequence has been suspended.
 */
#define FLEXSPI_AHBSPNDSTS_ACTIVE(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBSPNDSTS_ACTIVE_SHIFT)) & FLEXSPI_AHBSPNDSTS_ACTIVE_MASK)

#define FLEXSPI_AHBSPNDSTS_BUFID_MASK            (0xEU)
#define FLEXSPI_AHBSPNDSTS_BUFID_SHIFT           (1U)
/*! BUFID - AHB RX BUF ID for suspended command sequence.
 */
#define FLEXSPI_AHBSPNDSTS_BUFID(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBSPNDSTS_BUFID_SHIFT)) & FLEXSPI_AHBSPNDSTS_BUFID_MASK)

#define FLEXSPI_AHBSPNDSTS_DATLFT_MASK           (0xFFFF0000U)
#define FLEXSPI_AHBSPNDSTS_DATLFT_SHIFT          (16U)
/*! DATLFT - Left Data size for suspended command sequence (in byte).
 */
#define FLEXSPI_AHBSPNDSTS_DATLFT(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBSPNDSTS_DATLFT_SHIFT)) & FLEXSPI_AHBSPNDSTS_DATLFT_MASK)
/*! @} */

/*! @name IPRXFSTS - IP RX FIFO Status Register */
/*! @{ */

#define FLEXSPI_IPRXFSTS_FILL_MASK               (0xFFU)
#define FLEXSPI_IPRXFSTS_FILL_SHIFT              (0U)
/*! FILL - Fill level of IP RX FIFO.
 */
#define FLEXSPI_IPRXFSTS_FILL(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPRXFSTS_FILL_SHIFT)) & FLEXSPI_IPRXFSTS_FILL_MASK)

#define FLEXSPI_IPRXFSTS_RDCNTR_MASK             (0xFFFF0000U)
#define FLEXSPI_IPRXFSTS_RDCNTR_SHIFT            (16U)
/*! RDCNTR - Total Read Data Counter: RDCNTR * 64 Bits.
 */
#define FLEXSPI_IPRXFSTS_RDCNTR(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPRXFSTS_RDCNTR_SHIFT)) & FLEXSPI_IPRXFSTS_RDCNTR_MASK)
/*! @} */

/*! @name IPTXFSTS - IP TX FIFO Status Register */
/*! @{ */

#define FLEXSPI_IPTXFSTS_FILL_MASK               (0xFFU)
#define FLEXSPI_IPTXFSTS_FILL_SHIFT              (0U)
/*! FILL - Fill level of IP TX FIFO.
 */
#define FLEXSPI_IPTXFSTS_FILL(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPTXFSTS_FILL_SHIFT)) & FLEXSPI_IPTXFSTS_FILL_MASK)

#define FLEXSPI_IPTXFSTS_WRCNTR_MASK             (0xFFFF0000U)
#define FLEXSPI_IPTXFSTS_WRCNTR_SHIFT            (16U)
/*! WRCNTR - Total Write Data Counter: WRCNTR * 64 Bits.
 */
#define FLEXSPI_IPTXFSTS_WRCNTR(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPTXFSTS_WRCNTR_SHIFT)) & FLEXSPI_IPTXFSTS_WRCNTR_MASK)
/*! @} */

/*! @name RFDR - IP RX FIFO Data Register 0..IP RX FIFO Data Register 31 */
/*! @{ */

#define FLEXSPI_RFDR_RXDATA_MASK                 (0xFFFFFFFFU)
#define FLEXSPI_RFDR_RXDATA_SHIFT                (0U)
/*! RXDATA - RX Data
 */
#define FLEXSPI_RFDR_RXDATA(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_RFDR_RXDATA_SHIFT)) & FLEXSPI_RFDR_RXDATA_MASK)
/*! @} */

/* The count of FLEXSPI_RFDR */
#define FLEXSPI_RFDR_COUNT                       (32U)

/*! @name TFDR - IP TX FIFO Data Register 0..IP TX FIFO Data Register 31 */
/*! @{ */

#define FLEXSPI_TFDR_TXDATA_MASK                 (0xFFFFFFFFU)
#define FLEXSPI_TFDR_TXDATA_SHIFT                (0U)
/*! TXDATA - TX Data
 */
#define FLEXSPI_TFDR_TXDATA(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_TFDR_TXDATA_SHIFT)) & FLEXSPI_TFDR_TXDATA_MASK)
/*! @} */

/* The count of FLEXSPI_TFDR */
#define FLEXSPI_TFDR_COUNT                       (32U)

/*! @name LUT - LUT 0..LUT 63 */
/*! @{ */

#define FLEXSPI_LUT_OPERAND0_MASK                (0xFFU)
#define FLEXSPI_LUT_OPERAND0_SHIFT               (0U)
/*! OPERAND0 - OPERAND0
 */
#define FLEXSPI_LUT_OPERAND0(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_LUT_OPERAND0_SHIFT)) & FLEXSPI_LUT_OPERAND0_MASK)

#define FLEXSPI_LUT_NUM_PADS0_MASK               (0x300U)
#define FLEXSPI_LUT_NUM_PADS0_SHIFT              (8U)
/*! NUM_PADS0 - NUM_PADS0
 */
#define FLEXSPI_LUT_NUM_PADS0(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_LUT_NUM_PADS0_SHIFT)) & FLEXSPI_LUT_NUM_PADS0_MASK)

#define FLEXSPI_LUT_OPCODE0_MASK                 (0xFC00U)
#define FLEXSPI_LUT_OPCODE0_SHIFT                (10U)
/*! OPCODE0 - OPCODE
 */
#define FLEXSPI_LUT_OPCODE0(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_LUT_OPCODE0_SHIFT)) & FLEXSPI_LUT_OPCODE0_MASK)

#define FLEXSPI_LUT_OPERAND1_MASK                (0xFF0000U)
#define FLEXSPI_LUT_OPERAND1_SHIFT               (16U)
/*! OPERAND1 - OPERAND1
 */
#define FLEXSPI_LUT_OPERAND1(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_LUT_OPERAND1_SHIFT)) & FLEXSPI_LUT_OPERAND1_MASK)

#define FLEXSPI_LUT_NUM_PADS1_MASK               (0x3000000U)
#define FLEXSPI_LUT_NUM_PADS1_SHIFT              (24U)
/*! NUM_PADS1 - NUM_PADS1
 */
#define FLEXSPI_LUT_NUM_PADS1(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_LUT_NUM_PADS1_SHIFT)) & FLEXSPI_LUT_NUM_PADS1_MASK)

#define FLEXSPI_LUT_OPCODE1_MASK                 (0xFC000000U)
#define FLEXSPI_LUT_OPCODE1_SHIFT                (26U)
/*! OPCODE1 - OPCODE1
 */
#define FLEXSPI_LUT_OPCODE1(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_LUT_OPCODE1_SHIFT)) & FLEXSPI_LUT_OPCODE1_MASK)
/*! @} */

/* The count of FLEXSPI_LUT */
#define FLEXSPI_LUT_COUNT                        (64U)

/*! @name HADDRSTART - HADDR REMAP START ADDR */
/*! @{ */

#define FLEXSPI_HADDRSTART_REMAPEN_MASK          (0x1U)
#define FLEXSPI_HADDRSTART_REMAPEN_SHIFT         (0U)
/*! REMAPEN - AHB Bus address remap function enable
 *  0b0..HADDR REMAP Disabled
 *  0b1..HADDR REMAP Enabled
 */
#define FLEXSPI_HADDRSTART_REMAPEN(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_HADDRSTART_REMAPEN_SHIFT)) & FLEXSPI_HADDRSTART_REMAPEN_MASK)

#define FLEXSPI_HADDRSTART_ADDRSTART_MASK        (0xFFFFF000U)
#define FLEXSPI_HADDRSTART_ADDRSTART_SHIFT       (12U)
/*! ADDRSTART - HADDR start address
 */
#define FLEXSPI_HADDRSTART_ADDRSTART(x)          (((uint32_t)(((uint32_t)(x)) << FLEXSPI_HADDRSTART_ADDRSTART_SHIFT)) & FLEXSPI_HADDRSTART_ADDRSTART_MASK)
/*! @} */

/*! @name HADDREND - HADDR REMAP END ADDR */
/*! @{ */

#define FLEXSPI_HADDREND_ENDSTART_MASK           (0xFFFFF000U)
#define FLEXSPI_HADDREND_ENDSTART_SHIFT          (12U)
/*! ENDSTART - HADDR remap range's end addr, 4K aligned
 */
#define FLEXSPI_HADDREND_ENDSTART(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_HADDREND_ENDSTART_SHIFT)) & FLEXSPI_HADDREND_ENDSTART_MASK)
/*! @} */

/*! @name HADDROFFSET - HADDR REMAP OFFSET */
/*! @{ */

#define FLEXSPI_HADDROFFSET_ADDROFFSET_MASK      (0xFFFFF000U)
#define FLEXSPI_HADDROFFSET_ADDROFFSET_SHIFT     (12U)
/*! ADDROFFSET - HADDR offset field, remapped address will be ADDR[31:12]=ADDR_original[31:12]+ADDROFFSET
 */
#define FLEXSPI_HADDROFFSET_ADDROFFSET(x)        (((uint32_t)(((uint32_t)(x)) << FLEXSPI_HADDROFFSET_ADDROFFSET_SHIFT)) & FLEXSPI_HADDROFFSET_ADDROFFSET_MASK)
/*! @} */

/*! @name IPEDCTRL - IPED function control */
/*! @{ */

#define FLEXSPI_IPEDCTRL_CONFIG_MASK             (0x1U)
#define FLEXSPI_IPEDCTRL_CONFIG_SHIFT            (0U)
/*! CONFIG - Drive IPED interface i_config.
 */
#define FLEXSPI_IPEDCTRL_CONFIG(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTRL_CONFIG_SHIFT)) & FLEXSPI_IPEDCTRL_CONFIG_MASK)

#define FLEXSPI_IPEDCTRL_IPED_EN_MASK            (0x2U)
#define FLEXSPI_IPEDCTRL_IPED_EN_SHIFT           (1U)
/*! IPED_EN - Drive IPED interface i_enable
 */
#define FLEXSPI_IPEDCTRL_IPED_EN(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTRL_IPED_EN_SHIFT)) & FLEXSPI_IPEDCTRL_IPED_EN_MASK)

#define FLEXSPI_IPEDCTRL_IPWR_EN_MASK            (0x4U)
#define FLEXSPI_IPEDCTRL_IPWR_EN_SHIFT           (2U)
/*! IPWR_EN - IP write IPED CTR mode encryption enable
 */
#define FLEXSPI_IPEDCTRL_IPWR_EN(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTRL_IPWR_EN_SHIFT)) & FLEXSPI_IPEDCTRL_IPWR_EN_MASK)

#define FLEXSPI_IPEDCTRL_AHBWR_EN_MASK           (0x8U)
#define FLEXSPI_IPEDCTRL_AHBWR_EN_SHIFT          (3U)
/*! AHBWR_EN - AHB write IPED CTR mode encryption enable
 */
#define FLEXSPI_IPEDCTRL_AHBWR_EN(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTRL_AHBWR_EN_SHIFT)) & FLEXSPI_IPEDCTRL_AHBWR_EN_MASK)

#define FLEXSPI_IPEDCTRL_AHBRD_EN_MASK           (0x10U)
#define FLEXSPI_IPEDCTRL_AHBRD_EN_SHIFT          (4U)
/*! AHBRD_EN - AHB read IPED CTR mode decryption enable
 */
#define FLEXSPI_IPEDCTRL_AHBRD_EN(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTRL_AHBRD_EN_SHIFT)) & FLEXSPI_IPEDCTRL_AHBRD_EN_MASK)

#define FLEXSPI_IPEDCTRL_IPGCMWR_MASK            (0x40U)
#define FLEXSPI_IPEDCTRL_IPGCMWR_SHIFT           (6U)
/*! IPGCMWR - IP write GCM mode enable
 */
#define FLEXSPI_IPEDCTRL_IPGCMWR(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTRL_IPGCMWR_SHIFT)) & FLEXSPI_IPEDCTRL_IPGCMWR_MASK)

#define FLEXSPI_IPEDCTRL_AHGCMWR_MASK            (0x80U)
#define FLEXSPI_IPEDCTRL_AHGCMWR_SHIFT           (7U)
/*! AHGCMWR - AHB write IPED GCM mode encryption enable
 */
#define FLEXSPI_IPEDCTRL_AHGCMWR(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTRL_AHGCMWR_SHIFT)) & FLEXSPI_IPEDCTRL_AHGCMWR_MASK)

#define FLEXSPI_IPEDCTRL_AHBGCMRD_MASK           (0x100U)
#define FLEXSPI_IPEDCTRL_AHBGCMRD_SHIFT          (8U)
/*! AHBGCMRD - AHB read IPED GCM mode decryption enable
 */
#define FLEXSPI_IPEDCTRL_AHBGCMRD(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTRL_AHBGCMRD_SHIFT)) & FLEXSPI_IPEDCTRL_AHBGCMRD_MASK)

#define FLEXSPI_IPEDCTRL_IPED_PROTECT_MASK       (0x200U)
#define FLEXSPI_IPEDCTRL_IPED_PROTECT_SHIFT      (9U)
/*! IPED_PROTECT - when ipedctrl protect = 0 or priviledge access, no restriction when ipedctrl
 *    protect = 1, only priviledge access can write.
 */
#define FLEXSPI_IPEDCTRL_IPED_PROTECT(x)         (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTRL_IPED_PROTECT_SHIFT)) & FLEXSPI_IPEDCTRL_IPED_PROTECT_MASK)

#define FLEXSPI_IPEDCTRL_IPED_SWRESET_MASK       (0x400U)
#define FLEXSPI_IPEDCTRL_IPED_SWRESET_SHIFT      (10U)
/*! IPED_SWRESET - Drive IPED interface i_abort.
 */
#define FLEXSPI_IPEDCTRL_IPED_SWRESET(x)         (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTRL_IPED_SWRESET_SHIFT)) & FLEXSPI_IPEDCTRL_IPED_SWRESET_MASK)
/*! @} */

/*! @name IPEDCTXCTRLX_IPEDCTXCTRL - IPED context control 0..IPED context control 1 */
/*! @{ */

#define FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX0_FREEZE0_MASK (0x3U)
#define FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX0_FREEZE0_SHIFT (0U)
/*! CTX0_FREEZE0 - Controls the RW properties of this field and region 0 context registers (CTX0_xxxx).
 */
#define FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX0_FREEZE0(x) (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX0_FREEZE0_SHIFT)) & FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX0_FREEZE0_MASK)

#define FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX0_FREEZE1_MASK (0x3U)
#define FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX0_FREEZE1_SHIFT (0U)
/*! CTX0_FREEZE1 - Controls the RW properties of this field and region 0 context registers (CTX0_xxxx).
 */
#define FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX0_FREEZE1(x) (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX0_FREEZE1_SHIFT)) & FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX0_FREEZE1_MASK)

#define FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX1_FREEZE0_MASK (0xCU)
#define FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX1_FREEZE0_SHIFT (2U)
/*! CTX1_FREEZE0 - Controls the RW properties of this field and region 1 context registers (CTX1_xxxx).
 */
#define FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX1_FREEZE0(x) (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX1_FREEZE0_SHIFT)) & FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX1_FREEZE0_MASK)

#define FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX1_FREEZE1_MASK (0xCU)
#define FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX1_FREEZE1_SHIFT (2U)
/*! CTX1_FREEZE1 - Controls the RW properties of this field and region 1 context registers (CTX1_xxxx).
 */
#define FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX1_FREEZE1(x) (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX1_FREEZE1_SHIFT)) & FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX1_FREEZE1_MASK)

#define FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX2_FREEZE0_MASK (0x30U)
#define FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX2_FREEZE0_SHIFT (4U)
/*! CTX2_FREEZE0 - Controls the RW properties of this field and region 2 context registers (CTX2_xxxx).
 */
#define FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX2_FREEZE0(x) (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX2_FREEZE0_SHIFT)) & FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX2_FREEZE0_MASK)

#define FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX2_FREEZE1_MASK (0x30U)
#define FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX2_FREEZE1_SHIFT (4U)
/*! CTX2_FREEZE1 - Controls the RW properties of this field and region 2 context registers (CTX2_xxxx).
 */
#define FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX2_FREEZE1(x) (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX2_FREEZE1_SHIFT)) & FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX2_FREEZE1_MASK)

#define FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX3_FREEZE0_MASK (0xC0U)
#define FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX3_FREEZE0_SHIFT (6U)
/*! CTX3_FREEZE0 - Controls the RW properties of this field and region 3 context registers (CTX3_xxxx).
 */
#define FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX3_FREEZE0(x) (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX3_FREEZE0_SHIFT)) & FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX3_FREEZE0_MASK)

#define FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX3_FREEZE1_MASK (0xC0U)
#define FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX3_FREEZE1_SHIFT (6U)
/*! CTX3_FREEZE1 - Controls the RW properties of this field and region 3 context registers (CTX3_xxxx).
 */
#define FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX3_FREEZE1(x) (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX3_FREEZE1_SHIFT)) & FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_CTX3_FREEZE1_MASK)
/*! @} */

/* The count of FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL */
#define FLEXSPI_IPEDCTXCTRLX_IPEDCTXCTRL_COUNT   (2U)

/*! @name IPEDCTX0IV0 - IPED context0 IV0 */
/*! @{ */

#define FLEXSPI_IPEDCTX0IV0_CTX0_IV0_MASK        (0xFFFFFFFFU)
#define FLEXSPI_IPEDCTX0IV0_CTX0_IV0_SHIFT       (0U)
/*! CTX0_IV0 - Lowest 32 bits of IV for region 0.
 */
#define FLEXSPI_IPEDCTX0IV0_CTX0_IV0(x)          (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTX0IV0_CTX0_IV0_SHIFT)) & FLEXSPI_IPEDCTX0IV0_CTX0_IV0_MASK)
/*! @} */

/*! @name IPEDCTX0IV1 - IPED context0 IV1 */
/*! @{ */

#define FLEXSPI_IPEDCTX0IV1_CTX0_IV1_MASK        (0xFFFFFFFFU)
#define FLEXSPI_IPEDCTX0IV1_CTX0_IV1_SHIFT       (0U)
/*! CTX0_IV1 - Highest 32 bits of IV for region 0.
 */
#define FLEXSPI_IPEDCTX0IV1_CTX0_IV1(x)          (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTX0IV1_CTX0_IV1_SHIFT)) & FLEXSPI_IPEDCTX0IV1_CTX0_IV1_MASK)
/*! @} */

/*! @name IPEDCTX0START - Start address of region 0 */
/*! @{ */

#define FLEXSPI_IPEDCTX0START_GCM_MASK           (0x1U)
#define FLEXSPI_IPEDCTX0START_GCM_SHIFT          (0U)
/*! GCM - If this bit is 1, current region is GCM mode region.
 */
#define FLEXSPI_IPEDCTX0START_GCM(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTX0START_GCM_SHIFT)) & FLEXSPI_IPEDCTX0START_GCM_MASK)

#define FLEXSPI_IPEDCTX0START_ahbbuserror_dis_MASK (0x2U)
#define FLEXSPI_IPEDCTX0START_ahbbuserror_dis_SHIFT (1U)
/*! ahbbuserror_dis - If this bit is 1, ahb bus error is disable.
 */
#define FLEXSPI_IPEDCTX0START_ahbbuserror_dis(x) (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTX0START_ahbbuserror_dis_SHIFT)) & FLEXSPI_IPEDCTX0START_ahbbuserror_dis_MASK)

#define FLEXSPI_IPEDCTX0START_start_address_MASK (0xFFFFFF00U)
#define FLEXSPI_IPEDCTX0START_start_address_SHIFT (8U)
/*! start_address - Start address of region 0. Minimal 256 Bytes aligned. It is system address.
 */
#define FLEXSPI_IPEDCTX0START_start_address(x)   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTX0START_start_address_SHIFT)) & FLEXSPI_IPEDCTX0START_start_address_MASK)
/*! @} */

/*! @name IPEDCTX0END - End address of region 0 */
/*! @{ */

#define FLEXSPI_IPEDCTX0END_end_address_MASK     (0xFFFFFF00U)
#define FLEXSPI_IPEDCTX0END_end_address_SHIFT    (8U)
/*! end_address - End address of region 0. Minimal 256 Bytes aligned. It is system address.
 */
#define FLEXSPI_IPEDCTX0END_end_address(x)       (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTX0END_end_address_SHIFT)) & FLEXSPI_IPEDCTX0END_end_address_MASK)
/*! @} */

/*! @name IPEDCTX0AAD0 - IPED context0 AAD0 */
/*! @{ */

#define FLEXSPI_IPEDCTX0AAD0_CTX0_AAD0_MASK      (0xFFFFFFFFU)
#define FLEXSPI_IPEDCTX0AAD0_CTX0_AAD0_SHIFT     (0U)
/*! CTX0_AAD0 - Lowest 32 bits of AAD for region 0.
 */
#define FLEXSPI_IPEDCTX0AAD0_CTX0_AAD0(x)        (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTX0AAD0_CTX0_AAD0_SHIFT)) & FLEXSPI_IPEDCTX0AAD0_CTX0_AAD0_MASK)
/*! @} */

/*! @name IPEDCTX0AAD1 - IPED context0 AAD1 */
/*! @{ */

#define FLEXSPI_IPEDCTX0AAD1_CTX0_AAD1_MASK      (0xFFFFFFFFU)
#define FLEXSPI_IPEDCTX0AAD1_CTX0_AAD1_SHIFT     (0U)
/*! CTX0_AAD1 - Highest 32 bits of AAD for region 0.
 */
#define FLEXSPI_IPEDCTX0AAD1_CTX0_AAD1(x)        (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTX0AAD1_CTX0_AAD1_SHIFT)) & FLEXSPI_IPEDCTX0AAD1_CTX0_AAD1_MASK)
/*! @} */

/*! @name IPEDCTX1IV0 - IPED context1 IV0 */
/*! @{ */

#define FLEXSPI_IPEDCTX1IV0_CTX1_IV0_MASK        (0xFFFFFFFFU)
#define FLEXSPI_IPEDCTX1IV0_CTX1_IV0_SHIFT       (0U)
/*! CTX1_IV0 - Lowest 32 bits of IV for region 1.
 */
#define FLEXSPI_IPEDCTX1IV0_CTX1_IV0(x)          (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTX1IV0_CTX1_IV0_SHIFT)) & FLEXSPI_IPEDCTX1IV0_CTX1_IV0_MASK)
/*! @} */

/*! @name IPEDCTX1IV1 - IPED context1 IV1 */
/*! @{ */

#define FLEXSPI_IPEDCTX1IV1_CTX1_IV1_MASK        (0xFFFFFFFFU)
#define FLEXSPI_IPEDCTX1IV1_CTX1_IV1_SHIFT       (0U)
/*! CTX1_IV1 - Highest 32 bits of IV for region 1.
 */
#define FLEXSPI_IPEDCTX1IV1_CTX1_IV1(x)          (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTX1IV1_CTX1_IV1_SHIFT)) & FLEXSPI_IPEDCTX1IV1_CTX1_IV1_MASK)
/*! @} */

/*! @name IPEDCTX1START - Start address of region 1 */
/*! @{ */

#define FLEXSPI_IPEDCTX1START_GCM_MASK           (0x1U)
#define FLEXSPI_IPEDCTX1START_GCM_SHIFT          (0U)
/*! GCM - If this bit is 1, current region is GCM mode region.
 */
#define FLEXSPI_IPEDCTX1START_GCM(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTX1START_GCM_SHIFT)) & FLEXSPI_IPEDCTX1START_GCM_MASK)

#define FLEXSPI_IPEDCTX1START_ahbbuserror_dis_MASK (0x2U)
#define FLEXSPI_IPEDCTX1START_ahbbuserror_dis_SHIFT (1U)
/*! ahbbuserror_dis - If this bit is 1, ahb bus error is disable.
 */
#define FLEXSPI_IPEDCTX1START_ahbbuserror_dis(x) (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTX1START_ahbbuserror_dis_SHIFT)) & FLEXSPI_IPEDCTX1START_ahbbuserror_dis_MASK)

#define FLEXSPI_IPEDCTX1START_start_address_MASK (0xFFFFFF00U)
#define FLEXSPI_IPEDCTX1START_start_address_SHIFT (8U)
/*! start_address - Start address of region 1. Minimal 256 Bytes aligned. It is system address.
 */
#define FLEXSPI_IPEDCTX1START_start_address(x)   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTX1START_start_address_SHIFT)) & FLEXSPI_IPEDCTX1START_start_address_MASK)
/*! @} */

/*! @name IPEDCTX1END - End address of region 1 */
/*! @{ */

#define FLEXSPI_IPEDCTX1END_end_address_MASK     (0xFFFFFF00U)
#define FLEXSPI_IPEDCTX1END_end_address_SHIFT    (8U)
/*! end_address - End address of region 1. Minimal 256 Bytes aligned. It is system address.
 */
#define FLEXSPI_IPEDCTX1END_end_address(x)       (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTX1END_end_address_SHIFT)) & FLEXSPI_IPEDCTX1END_end_address_MASK)
/*! @} */

/*! @name IPEDCTX1AAD0 - IPED context1 AAD0 */
/*! @{ */

#define FLEXSPI_IPEDCTX1AAD0_CTX1_AAD0_MASK      (0xFFFFFFFFU)
#define FLEXSPI_IPEDCTX1AAD0_CTX1_AAD0_SHIFT     (0U)
/*! CTX1_AAD0 - Lowest 32 bits of AAD for region 1.
 */
#define FLEXSPI_IPEDCTX1AAD0_CTX1_AAD0(x)        (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTX1AAD0_CTX1_AAD0_SHIFT)) & FLEXSPI_IPEDCTX1AAD0_CTX1_AAD0_MASK)
/*! @} */

/*! @name IPEDCTX1AAD1 - IPED context1 AAD1 */
/*! @{ */

#define FLEXSPI_IPEDCTX1AAD1_CTX1_AAD1_MASK      (0xFFFFFFFFU)
#define FLEXSPI_IPEDCTX1AAD1_CTX1_AAD1_SHIFT     (0U)
/*! CTX1_AAD1 - Highest 32 bits of AAD for region 1.
 */
#define FLEXSPI_IPEDCTX1AAD1_CTX1_AAD1(x)        (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTX1AAD1_CTX1_AAD1_SHIFT)) & FLEXSPI_IPEDCTX1AAD1_CTX1_AAD1_MASK)
/*! @} */

/*! @name IPEDCTX2IV0 - IPED context2 IV0 */
/*! @{ */

#define FLEXSPI_IPEDCTX2IV0_CTX2_IV0_MASK        (0xFFFFFFFFU)
#define FLEXSPI_IPEDCTX2IV0_CTX2_IV0_SHIFT       (0U)
/*! CTX2_IV0 - Lowest 32 bits of IV for region 2.
 */
#define FLEXSPI_IPEDCTX2IV0_CTX2_IV0(x)          (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTX2IV0_CTX2_IV0_SHIFT)) & FLEXSPI_IPEDCTX2IV0_CTX2_IV0_MASK)
/*! @} */

/*! @name IPEDCTX2IV1 - IPED context2 IV1 */
/*! @{ */

#define FLEXSPI_IPEDCTX2IV1_CTX2_IV1_MASK        (0xFFFFFFFFU)
#define FLEXSPI_IPEDCTX2IV1_CTX2_IV1_SHIFT       (0U)
/*! CTX2_IV1 - Highest 32 bits of IV for region 2.
 */
#define FLEXSPI_IPEDCTX2IV1_CTX2_IV1(x)          (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTX2IV1_CTX2_IV1_SHIFT)) & FLEXSPI_IPEDCTX2IV1_CTX2_IV1_MASK)
/*! @} */

/*! @name IPEDCTX2START - Start address of region 2 */
/*! @{ */

#define FLEXSPI_IPEDCTX2START_GCM_MASK           (0x1U)
#define FLEXSPI_IPEDCTX2START_GCM_SHIFT          (0U)
/*! GCM - If this bit is 1, current region is GCM mode region.
 */
#define FLEXSPI_IPEDCTX2START_GCM(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTX2START_GCM_SHIFT)) & FLEXSPI_IPEDCTX2START_GCM_MASK)

#define FLEXSPI_IPEDCTX2START_ahbbuserror_dis_MASK (0x2U)
#define FLEXSPI_IPEDCTX2START_ahbbuserror_dis_SHIFT (1U)
/*! ahbbuserror_dis - If this bit is 1, ahb bus error is disable.
 */
#define FLEXSPI_IPEDCTX2START_ahbbuserror_dis(x) (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTX2START_ahbbuserror_dis_SHIFT)) & FLEXSPI_IPEDCTX2START_ahbbuserror_dis_MASK)

#define FLEXSPI_IPEDCTX2START_start_address_MASK (0xFFFFFF00U)
#define FLEXSPI_IPEDCTX2START_start_address_SHIFT (8U)
/*! start_address - Start address of region 2. Minimal 256 Bytes aligned. It is system address.
 */
#define FLEXSPI_IPEDCTX2START_start_address(x)   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTX2START_start_address_SHIFT)) & FLEXSPI_IPEDCTX2START_start_address_MASK)
/*! @} */

/*! @name IPEDCTX2END - End address of region 2 */
/*! @{ */

#define FLEXSPI_IPEDCTX2END_end_address_MASK     (0xFFFFFF00U)
#define FLEXSPI_IPEDCTX2END_end_address_SHIFT    (8U)
/*! end_address - End address of region 2. Minimal 256 Bytes aligned. It is system address.
 */
#define FLEXSPI_IPEDCTX2END_end_address(x)       (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTX2END_end_address_SHIFT)) & FLEXSPI_IPEDCTX2END_end_address_MASK)
/*! @} */

/*! @name IPEDCTX2AAD0 - IPED context2 AAD0 */
/*! @{ */

#define FLEXSPI_IPEDCTX2AAD0_CTX2_AAD0_MASK      (0xFFFFFFFFU)
#define FLEXSPI_IPEDCTX2AAD0_CTX2_AAD0_SHIFT     (0U)
/*! CTX2_AAD0 - Lowest 32 bits of AAD for region 2.
 */
#define FLEXSPI_IPEDCTX2AAD0_CTX2_AAD0(x)        (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTX2AAD0_CTX2_AAD0_SHIFT)) & FLEXSPI_IPEDCTX2AAD0_CTX2_AAD0_MASK)
/*! @} */

/*! @name IPEDCTX2AAD1 - IPED context2 AAD1 */
/*! @{ */

#define FLEXSPI_IPEDCTX2AAD1_CTX2_AAD1_MASK      (0xFFFFFFFFU)
#define FLEXSPI_IPEDCTX2AAD1_CTX2_AAD1_SHIFT     (0U)
/*! CTX2_AAD1 - Highest 32 bits of AAD for region 2.
 */
#define FLEXSPI_IPEDCTX2AAD1_CTX2_AAD1(x)        (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTX2AAD1_CTX2_AAD1_SHIFT)) & FLEXSPI_IPEDCTX2AAD1_CTX2_AAD1_MASK)
/*! @} */

/*! @name IPEDCTX3IV0 - IPED context3 IV0 */
/*! @{ */

#define FLEXSPI_IPEDCTX3IV0_CTX3_IV0_MASK        (0xFFFFFFFFU)
#define FLEXSPI_IPEDCTX3IV0_CTX3_IV0_SHIFT       (0U)
/*! CTX3_IV0 - Lowest 32 bits of IV for region 3.
 */
#define FLEXSPI_IPEDCTX3IV0_CTX3_IV0(x)          (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTX3IV0_CTX3_IV0_SHIFT)) & FLEXSPI_IPEDCTX3IV0_CTX3_IV0_MASK)
/*! @} */

/*! @name IPEDCTX3IV1 - IPED context3 IV1 */
/*! @{ */

#define FLEXSPI_IPEDCTX3IV1_CTX3_IV1_MASK        (0xFFFFFFFFU)
#define FLEXSPI_IPEDCTX3IV1_CTX3_IV1_SHIFT       (0U)
/*! CTX3_IV1 - Highest 32 bits of IV for region 3.
 */
#define FLEXSPI_IPEDCTX3IV1_CTX3_IV1(x)          (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTX3IV1_CTX3_IV1_SHIFT)) & FLEXSPI_IPEDCTX3IV1_CTX3_IV1_MASK)
/*! @} */

/*! @name IPEDCTX3START - Start address of region 3 */
/*! @{ */

#define FLEXSPI_IPEDCTX3START_GCM_MASK           (0x1U)
#define FLEXSPI_IPEDCTX3START_GCM_SHIFT          (0U)
/*! GCM - If this bit is 1, current region is GCM mode region.
 */
#define FLEXSPI_IPEDCTX3START_GCM(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTX3START_GCM_SHIFT)) & FLEXSPI_IPEDCTX3START_GCM_MASK)

#define FLEXSPI_IPEDCTX3START_ahbbuserror_dis_MASK (0x2U)
#define FLEXSPI_IPEDCTX3START_ahbbuserror_dis_SHIFT (1U)
/*! ahbbuserror_dis - If this bit is 1, ahb bus error is disable.
 */
#define FLEXSPI_IPEDCTX3START_ahbbuserror_dis(x) (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTX3START_ahbbuserror_dis_SHIFT)) & FLEXSPI_IPEDCTX3START_ahbbuserror_dis_MASK)

#define FLEXSPI_IPEDCTX3START_start_address_MASK (0xFFFFFF00U)
#define FLEXSPI_IPEDCTX3START_start_address_SHIFT (8U)
/*! start_address - Start address of region 3. Minimal 256 Bytes aligned. It is system address.
 */
#define FLEXSPI_IPEDCTX3START_start_address(x)   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTX3START_start_address_SHIFT)) & FLEXSPI_IPEDCTX3START_start_address_MASK)
/*! @} */

/*! @name IPEDCTX3END - End address of region 3 */
/*! @{ */

#define FLEXSPI_IPEDCTX3END_end_address_MASK     (0xFFFFFF00U)
#define FLEXSPI_IPEDCTX3END_end_address_SHIFT    (8U)
/*! end_address - End address of region 3. Minimal 256 Bytes aligned. It is system address.
 */
#define FLEXSPI_IPEDCTX3END_end_address(x)       (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTX3END_end_address_SHIFT)) & FLEXSPI_IPEDCTX3END_end_address_MASK)
/*! @} */

/*! @name IPEDCTX3AAD0 - IPED context3 AAD0 */
/*! @{ */

#define FLEXSPI_IPEDCTX3AAD0_CTX3_AAD0_MASK      (0xFFFFFFFFU)
#define FLEXSPI_IPEDCTX3AAD0_CTX3_AAD0_SHIFT     (0U)
/*! CTX3_AAD0 - Lowest 32 bits of AAD for region 3.
 */
#define FLEXSPI_IPEDCTX3AAD0_CTX3_AAD0(x)        (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTX3AAD0_CTX3_AAD0_SHIFT)) & FLEXSPI_IPEDCTX3AAD0_CTX3_AAD0_MASK)
/*! @} */

/*! @name IPEDCTX3AAD1 - IPED context3 AAD1 */
/*! @{ */

#define FLEXSPI_IPEDCTX3AAD1_CTX3_AAD1_MASK      (0xFFFFFFFFU)
#define FLEXSPI_IPEDCTX3AAD1_CTX3_AAD1_SHIFT     (0U)
/*! CTX3_AAD1 - Highest 32 bits of AAD for region 3.
 */
#define FLEXSPI_IPEDCTX3AAD1_CTX3_AAD1(x)        (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPEDCTX3AAD1_CTX3_AAD1_SHIFT)) & FLEXSPI_IPEDCTX3AAD1_CTX3_AAD1_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group FLEXSPI_Register_Masks */


/* FLEXSPI - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral FLEXSPI0 base address */
  #define FLEXSPI0_BASE                            (0x500C0000u)
  /** Peripheral FLEXSPI0 base address */
  #define FLEXSPI0_BASE_NS                         (0x400C0000u)
  /** Peripheral FLEXSPI0 base pointer */
  #define FLEXSPI0                                 ((FLEXSPI_Type *)FLEXSPI0_BASE)
  /** Peripheral FLEXSPI0 base pointer */
  #define FLEXSPI0_NS                              ((FLEXSPI_Type *)FLEXSPI0_BASE_NS)
  /** Array initializer of FLEXSPI peripheral base addresses */
  #define FLEXSPI_BASE_ADDRS                       { FLEXSPI0_BASE }
  /** Array initializer of FLEXSPI peripheral base pointers */
  #define FLEXSPI_BASE_PTRS                        { FLEXSPI0 }
  /** Array initializer of FLEXSPI peripheral base addresses */
  #define FLEXSPI_BASE_ADDRS_NS                    { FLEXSPI0_BASE_NS }
  /** Array initializer of FLEXSPI peripheral base pointers */
  #define FLEXSPI_BASE_PTRS_NS                     { FLEXSPI0_NS }
#else
  /** Peripheral FLEXSPI0 base address */
  #define FLEXSPI0_BASE                            (0x400C0000u)
  /** Peripheral FLEXSPI0 base pointer */
  #define FLEXSPI0                                 ((FLEXSPI_Type *)FLEXSPI0_BASE)
  /** Array initializer of FLEXSPI peripheral base addresses */
  #define FLEXSPI_BASE_ADDRS                       { FLEXSPI0_BASE }
  /** Array initializer of FLEXSPI peripheral base pointers */
  #define FLEXSPI_BASE_PTRS                        { FLEXSPI0 }
#endif
/** Interrupt vectors for the FLEXSPI peripheral type */
#define FLEXSPI_IRQS                             { FlexSPI0_IRQn }
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
/** FlexSPI0 AMBA address */
#define FlexSPI0_AMBA_BASE                        (0x18000000u)
/** FlexSPI0 AMBA address */
#define FlexSPI0_AMBA_BASE_NS                     (0x08000000u)
#else
/** FlexSPI0 AMBA address */
#define FlexSPI0_AMBA_BASE                        (0x08000000u)
#endif


/*!
 * @}
 */ /* end of group FLEXSPI_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FREQME Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FREQME_Peripheral_Access_Layer FREQME Peripheral Access Layer
 * @{
 */

/** FREQME - Register Layout Typedef */
typedef struct {
  union {                                          /* offset: 0x0 */
    __I  uint32_t FREQMECTRL_R;                      /**< Frequency Measurement (in Read mode), offset: 0x0 */
    __O  uint32_t FREQMECTRL_W;                      /**< Frequency Measurement (in Write mode), offset: 0x0 */
  };
  __IO uint32_t FREQMECTRLSTAT;                    /**< Frequency Measurement Control Status, offset: 0x4 */
  __IO uint32_t FREQMEMIN;                         /**< Frequency Measurement Minimum, offset: 0x8 */
  __IO uint32_t FREQMEMAX;                         /**< Frequency Measurement Maximum, offset: 0xC */
} FREQME_Type;

/* ----------------------------------------------------------------------------
   -- FREQME Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FREQME_Register_Masks FREQME Register Masks
 * @{
 */

/*! @name FREQMECTRL_R - Frequency Measurement (in Read mode) */
/*! @{ */

#define FREQME_FREQMECTRL_R_RESULT_MASK          (0x7FFFFFFFU)
#define FREQME_FREQMECTRL_R_RESULT_SHIFT         (0U)
/*! RESULT - Result
 */
#define FREQME_FREQMECTRL_R_RESULT(x)            (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMECTRL_R_RESULT_SHIFT)) & FREQME_FREQMECTRL_R_RESULT_MASK)

#define FREQME_FREQMECTRL_R_MEASURE_IN_PROGRESS_MASK (0x80000000U)
#define FREQME_FREQMECTRL_R_MEASURE_IN_PROGRESS_SHIFT (31U)
/*! MEASURE_IN_PROGRESS - Measure in Progress
 *  0b0..Process complete. Measurement cycle is complete. The results are ready in the RESULT field.
 *  0b1..In Progress. Measurement cycle is in progress.
 */
#define FREQME_FREQMECTRL_R_MEASURE_IN_PROGRESS(x) (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMECTRL_R_MEASURE_IN_PROGRESS_SHIFT)) & FREQME_FREQMECTRL_R_MEASURE_IN_PROGRESS_MASK)
/*! @} */

/*! @name FREQMECTRL_W - Frequency Measurement (in Write mode) */
/*! @{ */

#define FREQME_FREQMECTRL_W_REF_SCALE_MASK       (0x1FU)
#define FREQME_FREQMECTRL_W_REF_SCALE_SHIFT      (0U)
/*! REF_SCALE - Reference Clock Scaling Factor
 *  0b00000..Count cycle = 2 ^ 0 = 1
 *  0b00001..Count cycle = 2 ^ 1 = 2
 *  0b00010..Count cycle = 2 ^ 2 = 4
 *  0b11111..Count cycle = 2 ^ 31 = 2,147,483,648
 */
#define FREQME_FREQMECTRL_W_REF_SCALE(x)         (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMECTRL_W_REF_SCALE_SHIFT)) & FREQME_FREQMECTRL_W_REF_SCALE_MASK)

#define FREQME_FREQMECTRL_W_PULSE_MODE_MASK      (0x100U)
#define FREQME_FREQMECTRL_W_PULSE_MODE_SHIFT     (8U)
/*! PULSE_MODE - Pulse Width Measurement mode select
 *  0b0..Frequency Measurement Mode. FREQMECTRL works in a Frequency Measurement mode. Once the measurement starts
 *       (real count start is aligned at rising edge arrival on reference clock), the target counter increments by
 *       the target clock until the reference counter running by the reference clock reaches the count end point
 *       selected by REF_SCALE.
 *  0b1..Pulse Width Measurement mode. FREQMECTRL works in a Pulse Width Measurement mode, measuring the high or
 *       low period of reference clock input selected by PULSE_POL. The target counter starts incrementing by the
 *       target clock once a corresponding trigger edge (rising edge for high period measurement and falling edge for
 *       low period) occurs.
 */
#define FREQME_FREQMECTRL_W_PULSE_MODE(x)        (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMECTRL_W_PULSE_MODE_SHIFT)) & FREQME_FREQMECTRL_W_PULSE_MODE_MASK)

#define FREQME_FREQMECTRL_W_PULSE_POL_MASK       (0x200U)
#define FREQME_FREQMECTRL_W_PULSE_POL_SHIFT      (9U)
/*! PULSE_POL - Pulse Polarity
 *  0b0..High Period. High period of reference clock is measured in Pulse Width Measurement mode triggered by the
 *       rising edge on the reference clock input.
 *  0b1..Low Period. Low period of reference clock is measured in Pulse Width Measurement mode triggered by the
 *       falling edge on the reference clock input.
 */
#define FREQME_FREQMECTRL_W_PULSE_POL(x)         (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMECTRL_W_PULSE_POL_SHIFT)) & FREQME_FREQMECTRL_W_PULSE_POL_MASK)

#define FREQME_FREQMECTRL_W_LT_MIN_INT_EN_MASK   (0x1000U)
#define FREQME_FREQMECTRL_W_LT_MIN_INT_EN_SHIFT  (12U)
/*! LT_MIN_INT_EN - Less Than Minimum Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define FREQME_FREQMECTRL_W_LT_MIN_INT_EN(x)     (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMECTRL_W_LT_MIN_INT_EN_SHIFT)) & FREQME_FREQMECTRL_W_LT_MIN_INT_EN_MASK)

#define FREQME_FREQMECTRL_W_GT_MAX_INT_EN_MASK   (0x2000U)
#define FREQME_FREQMECTRL_W_GT_MAX_INT_EN_SHIFT  (13U)
/*! GT_MAX_INT_EN - Greater Than Maximum Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define FREQME_FREQMECTRL_W_GT_MAX_INT_EN(x)     (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMECTRL_W_GT_MAX_INT_EN_SHIFT)) & FREQME_FREQMECTRL_W_GT_MAX_INT_EN_MASK)

#define FREQME_FREQMECTRL_W_RESULT_READY_INT_EN_MASK (0x4000U)
#define FREQME_FREQMECTRL_W_RESULT_READY_INT_EN_SHIFT (14U)
/*! RESULT_READY_INT_EN - Result Ready Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define FREQME_FREQMECTRL_W_RESULT_READY_INT_EN(x) (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMECTRL_W_RESULT_READY_INT_EN_SHIFT)) & FREQME_FREQMECTRL_W_RESULT_READY_INT_EN_MASK)

#define FREQME_FREQMECTRL_W_CONTINUOUS_MODE_EN_MASK (0x40000000U)
#define FREQME_FREQMECTRL_W_CONTINUOUS_MODE_EN_SHIFT (30U)
/*! CONTINUOUS_MODE_EN - Continuous Mode Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define FREQME_FREQMECTRL_W_CONTINUOUS_MODE_EN(x) (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMECTRL_W_CONTINUOUS_MODE_EN_SHIFT)) & FREQME_FREQMECTRL_W_CONTINUOUS_MODE_EN_MASK)

#define FREQME_FREQMECTRL_W_MEASURE_IN_PROGRESS_MASK (0x80000000U)
#define FREQME_FREQMECTRL_W_MEASURE_IN_PROGRESS_SHIFT (31U)
/*! MEASURE_IN_PROGRESS - Measure in Progress
 *  0b0..Force Terminate
 *  0b1..Initiates Measurement Cycle
 */
#define FREQME_FREQMECTRL_W_MEASURE_IN_PROGRESS(x) (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMECTRL_W_MEASURE_IN_PROGRESS_SHIFT)) & FREQME_FREQMECTRL_W_MEASURE_IN_PROGRESS_MASK)
/*! @} */

/*! @name FREQMECTRLSTAT - Frequency Measurement Control Status */
/*! @{ */

#define FREQME_FREQMECTRLSTAT_REF_SCALE_MASK     (0x1FU)
#define FREQME_FREQMECTRLSTAT_REF_SCALE_SHIFT    (0U)
/*! REF_SCALE - Reference Scale Value
 */
#define FREQME_FREQMECTRLSTAT_REF_SCALE(x)       (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMECTRLSTAT_REF_SCALE_SHIFT)) & FREQME_FREQMECTRLSTAT_REF_SCALE_MASK)

#define FREQME_FREQMECTRLSTAT_PULSE_MODE_MASK    (0x100U)
#define FREQME_FREQMECTRLSTAT_PULSE_MODE_SHIFT   (8U)
/*! PULSE_MODE - Pulse Mode Status
 */
#define FREQME_FREQMECTRLSTAT_PULSE_MODE(x)      (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMECTRLSTAT_PULSE_MODE_SHIFT)) & FREQME_FREQMECTRLSTAT_PULSE_MODE_MASK)

#define FREQME_FREQMECTRLSTAT_PULSE_POL_MASK     (0x200U)
#define FREQME_FREQMECTRLSTAT_PULSE_POL_SHIFT    (9U)
/*! PULSE_POL - Pulse Polarity Status
 */
#define FREQME_FREQMECTRLSTAT_PULSE_POL(x)       (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMECTRLSTAT_PULSE_POL_SHIFT)) & FREQME_FREQMECTRLSTAT_PULSE_POL_MASK)

#define FREQME_FREQMECTRLSTAT_LT_MIN_INT_EN_MASK (0x1000U)
#define FREQME_FREQMECTRLSTAT_LT_MIN_INT_EN_SHIFT (12U)
/*! LT_MIN_INT_EN - Less Than Minimum Interrupt Enable Status
 */
#define FREQME_FREQMECTRLSTAT_LT_MIN_INT_EN(x)   (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMECTRLSTAT_LT_MIN_INT_EN_SHIFT)) & FREQME_FREQMECTRLSTAT_LT_MIN_INT_EN_MASK)

#define FREQME_FREQMECTRLSTAT_GT_MAX_INT_EN_MASK (0x2000U)
#define FREQME_FREQMECTRLSTAT_GT_MAX_INT_EN_SHIFT (13U)
/*! GT_MAX_INT_EN - Greater Then Maximum Interrupt Enable Status
 */
#define FREQME_FREQMECTRLSTAT_GT_MAX_INT_EN(x)   (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMECTRLSTAT_GT_MAX_INT_EN_SHIFT)) & FREQME_FREQMECTRLSTAT_GT_MAX_INT_EN_MASK)

#define FREQME_FREQMECTRLSTAT_RESULT_READY_INT_EN_MASK (0x4000U)
#define FREQME_FREQMECTRLSTAT_RESULT_READY_INT_EN_SHIFT (14U)
/*! RESULT_READY_INT_EN - Result Ready Interrupt Enable Status
 */
#define FREQME_FREQMECTRLSTAT_RESULT_READY_INT_EN(x) (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMECTRLSTAT_RESULT_READY_INT_EN_SHIFT)) & FREQME_FREQMECTRLSTAT_RESULT_READY_INT_EN_MASK)

#define FREQME_FREQMECTRLSTAT_LT_MIN_STAT_MASK   (0x1000000U)
#define FREQME_FREQMECTRLSTAT_LT_MIN_STAT_SHIFT  (24U)
/*! LT_MIN_STAT - Less Than Minimum Results Status
 */
#define FREQME_FREQMECTRLSTAT_LT_MIN_STAT(x)     (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMECTRLSTAT_LT_MIN_STAT_SHIFT)) & FREQME_FREQMECTRLSTAT_LT_MIN_STAT_MASK)

#define FREQME_FREQMECTRLSTAT_GT_MAX_STAT_MASK   (0x2000000U)
#define FREQME_FREQMECTRLSTAT_GT_MAX_STAT_SHIFT  (25U)
/*! GT_MAX_STAT - Greater Than Maximum Result Status
 */
#define FREQME_FREQMECTRLSTAT_GT_MAX_STAT(x)     (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMECTRLSTAT_GT_MAX_STAT_SHIFT)) & FREQME_FREQMECTRLSTAT_GT_MAX_STAT_MASK)

#define FREQME_FREQMECTRLSTAT_RESULT_READY_STAT_MASK (0x4000000U)
#define FREQME_FREQMECTRLSTAT_RESULT_READY_STAT_SHIFT (26U)
/*! RESULT_READY_STAT - Result Ready Status
 */
#define FREQME_FREQMECTRLSTAT_RESULT_READY_STAT(x) (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMECTRLSTAT_RESULT_READY_STAT_SHIFT)) & FREQME_FREQMECTRLSTAT_RESULT_READY_STAT_MASK)

#define FREQME_FREQMECTRLSTAT_CONTINUOUS_MODE_EN_MASK (0x40000000U)
#define FREQME_FREQMECTRLSTAT_CONTINUOUS_MODE_EN_SHIFT (30U)
/*! CONTINUOUS_MODE_EN - Continuous Mode Enable Status
 */
#define FREQME_FREQMECTRLSTAT_CONTINUOUS_MODE_EN(x) (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMECTRLSTAT_CONTINUOUS_MODE_EN_SHIFT)) & FREQME_FREQMECTRLSTAT_CONTINUOUS_MODE_EN_MASK)

#define FREQME_FREQMECTRLSTAT_MEASURE_IN_PROGRESS_MASK (0x80000000U)
#define FREQME_FREQMECTRLSTAT_MEASURE_IN_PROGRESS_SHIFT (31U)
/*! MEASURE_IN_PROGRESS - Measure in Progress Status
 */
#define FREQME_FREQMECTRLSTAT_MEASURE_IN_PROGRESS(x) (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMECTRLSTAT_MEASURE_IN_PROGRESS_SHIFT)) & FREQME_FREQMECTRLSTAT_MEASURE_IN_PROGRESS_MASK)
/*! @} */

/*! @name FREQMEMIN - Frequency Measurement Minimum */
/*! @{ */

#define FREQME_FREQMEMIN_MIN_VALUE_MASK          (0x7FFFFFFFU)
#define FREQME_FREQMEMIN_MIN_VALUE_SHIFT         (0U)
/*! MIN_VALUE - Minumum Value
 */
#define FREQME_FREQMEMIN_MIN_VALUE(x)            (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMEMIN_MIN_VALUE_SHIFT)) & FREQME_FREQMEMIN_MIN_VALUE_MASK)
/*! @} */

/*! @name FREQMEMAX - Frequency Measurement Maximum */
/*! @{ */

#define FREQME_FREQMEMAX_MAX_VALUE_MASK          (0x7FFFFFFFU)
#define FREQME_FREQMEMAX_MAX_VALUE_SHIFT         (0U)
/*! MAX_VALUE - Maximum Value
 */
#define FREQME_FREQMEMAX_MAX_VALUE(x)            (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMEMAX_MAX_VALUE_SHIFT)) & FREQME_FREQMEMAX_MAX_VALUE_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group FREQME_Register_Masks */


/* FREQME - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral FREQME base address */
  #define FREQME_BASE                              (0x50013140u)
  /** Peripheral FREQME base address */
  #define FREQME_BASE_NS                           (0x40013140u)
  /** Peripheral FREQME base pointer */
  #define FREQME                                   ((FREQME_Type *)FREQME_BASE)
  /** Peripheral FREQME base pointer */
  #define FREQME_NS                                ((FREQME_Type *)FREQME_BASE_NS)
  /** Array initializer of FREQME peripheral base addresses */
  #define FREQME_BASE_ADDRS                        { FREQME_BASE }
  /** Array initializer of FREQME peripheral base pointers */
  #define FREQME_BASE_PTRS                         { FREQME }
  /** Array initializer of FREQME peripheral base addresses */
  #define FREQME_BASE_ADDRS_NS                     { FREQME_BASE_NS }
  /** Array initializer of FREQME peripheral base pointers */
  #define FREQME_BASE_PTRS_NS                      { FREQME_NS }
#else
  /** Peripheral FREQME base address */
  #define FREQME_BASE                              (0x40013140u)
  /** Peripheral FREQME base pointer */
  #define FREQME                                   ((FREQME_Type *)FREQME_BASE)
  /** Array initializer of FREQME peripheral base addresses */
  #define FREQME_BASE_ADDRS                        { FREQME_BASE }
  /** Array initializer of FREQME peripheral base pointers */
  #define FREQME_BASE_PTRS                         { FREQME }
#endif
/** Interrupt vectors for the FREQME peripheral type */
#define FREQME_IRQS                              { Freqme_IRQn }

/*!
 * @}
 */ /* end of group FREQME_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- GINT Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GINT_Peripheral_Access_Layer GINT Peripheral Access Layer
 * @{
 */

/** GINT - Register Layout Typedef */
typedef struct {
  __IO uint32_t CTRL;                              /**< GPIO grouped interrupt control, offset: 0x0 */
       uint8_t RESERVED_0[28];
  __IO uint32_t PORT_POL[2];                       /**< Port polarity, array offset: 0x20, array step: 0x4 */
       uint8_t RESERVED_1[24];
  __IO uint32_t PORT_ENA[2];                       /**< GPIO grouped interrupt port 0 enable register, array offset: 0x40, array step: 0x4 */
} GINT_Type;

/* ----------------------------------------------------------------------------
   -- GINT Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GINT_Register_Masks GINT Register Masks
 * @{
 */

/*! @name CTRL - GPIO grouped interrupt control */
/*! @{ */

#define GINT_CTRL_INT_MASK                       (0x1U)
#define GINT_CTRL_INT_SHIFT                      (0U)
/*! INT - Group interrupt status
 *  0b0..No interrupt request is pending.
 *  0b1..Interrupt request is pending.
 */
#define GINT_CTRL_INT(x)                         (((uint32_t)(((uint32_t)(x)) << GINT_CTRL_INT_SHIFT)) & GINT_CTRL_INT_MASK)

#define GINT_CTRL_COMB_MASK                      (0x2U)
#define GINT_CTRL_COMB_SHIFT                     (1U)
/*! COMB - Combine enabled inputs for group interrupt
 *  0b0..OR functionality
 *  0b1..AND functionality
 */
#define GINT_CTRL_COMB(x)                        (((uint32_t)(((uint32_t)(x)) << GINT_CTRL_COMB_SHIFT)) & GINT_CTRL_COMB_MASK)

#define GINT_CTRL_TRIG_MASK                      (0x4U)
#define GINT_CTRL_TRIG_SHIFT                     (2U)
/*! TRIG - Group interrupt trigger
 *  0b0..Edge-triggered
 *  0b1..Level-triggered
 */
#define GINT_CTRL_TRIG(x)                        (((uint32_t)(((uint32_t)(x)) << GINT_CTRL_TRIG_SHIFT)) & GINT_CTRL_TRIG_MASK)
/*! @} */

/*! @name PORT_POL - Port polarity */
/*! @{ */

#define GINT_PORT_POL_POL0_MASK                  (0x1U)
#define GINT_PORT_POL_POL0_SHIFT                 (0U)
/*! POL0 - Polarity of pin n of the port
 *  0b0..Pin is active LOW
 *  0b1..Pin is active HIGH
 */
#define GINT_PORT_POL_POL0(x)                    (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL0_SHIFT)) & GINT_PORT_POL_POL0_MASK)

#define GINT_PORT_POL_POL1_MASK                  (0x2U)
#define GINT_PORT_POL_POL1_SHIFT                 (1U)
/*! POL1 - Polarity of pin n of the port
 *  0b0..Pin is active LOW
 *  0b1..Pin is active HIGH
 */
#define GINT_PORT_POL_POL1(x)                    (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL1_SHIFT)) & GINT_PORT_POL_POL1_MASK)

#define GINT_PORT_POL_POL2_MASK                  (0x4U)
#define GINT_PORT_POL_POL2_SHIFT                 (2U)
/*! POL2 - Polarity of pin n of the port
 *  0b0..Pin is active LOW
 *  0b1..Pin is active HIGH
 */
#define GINT_PORT_POL_POL2(x)                    (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL2_SHIFT)) & GINT_PORT_POL_POL2_MASK)

#define GINT_PORT_POL_POL3_MASK                  (0x8U)
#define GINT_PORT_POL_POL3_SHIFT                 (3U)
/*! POL3 - Polarity of pin n of the port
 *  0b0..Pin is active LOW
 *  0b1..Pin is active HIGH
 */
#define GINT_PORT_POL_POL3(x)                    (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL3_SHIFT)) & GINT_PORT_POL_POL3_MASK)

#define GINT_PORT_POL_POL4_MASK                  (0x10U)
#define GINT_PORT_POL_POL4_SHIFT                 (4U)
/*! POL4 - Polarity of pin n of the port
 *  0b0..Pin is active LOW
 *  0b1..Pin is active HIGH
 */
#define GINT_PORT_POL_POL4(x)                    (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL4_SHIFT)) & GINT_PORT_POL_POL4_MASK)

#define GINT_PORT_POL_POL5_MASK                  (0x20U)
#define GINT_PORT_POL_POL5_SHIFT                 (5U)
/*! POL5 - Polarity of pin n of the port
 *  0b0..Pin is active LOW
 *  0b1..Pin is active HIGH
 */
#define GINT_PORT_POL_POL5(x)                    (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL5_SHIFT)) & GINT_PORT_POL_POL5_MASK)

#define GINT_PORT_POL_POL6_MASK                  (0x40U)
#define GINT_PORT_POL_POL6_SHIFT                 (6U)
/*! POL6 - Polarity of pin n of the port
 *  0b0..Pin is active LOW
 *  0b1..Pin is active HIGH
 */
#define GINT_PORT_POL_POL6(x)                    (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL6_SHIFT)) & GINT_PORT_POL_POL6_MASK)

#define GINT_PORT_POL_POL7_MASK                  (0x80U)
#define GINT_PORT_POL_POL7_SHIFT                 (7U)
/*! POL7 - Polarity of pin n of the port
 *  0b0..Pin is active LOW
 *  0b1..Pin is active HIGH
 */
#define GINT_PORT_POL_POL7(x)                    (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL7_SHIFT)) & GINT_PORT_POL_POL7_MASK)

#define GINT_PORT_POL_POL8_MASK                  (0x100U)
#define GINT_PORT_POL_POL8_SHIFT                 (8U)
/*! POL8 - Polarity of pin n of the port
 *  0b0..Pin is active LOW
 *  0b1..Pin is active HIGH
 */
#define GINT_PORT_POL_POL8(x)                    (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL8_SHIFT)) & GINT_PORT_POL_POL8_MASK)

#define GINT_PORT_POL_POL9_MASK                  (0x200U)
#define GINT_PORT_POL_POL9_SHIFT                 (9U)
/*! POL9 - Polarity of pin n of the port
 *  0b0..Pin is active LOW
 *  0b1..Pin is active HIGH
 */
#define GINT_PORT_POL_POL9(x)                    (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL9_SHIFT)) & GINT_PORT_POL_POL9_MASK)

#define GINT_PORT_POL_POL10_MASK                 (0x400U)
#define GINT_PORT_POL_POL10_SHIFT                (10U)
/*! POL10 - Polarity of pin n of the port
 *  0b0..Pin is active LOW
 *  0b1..Pin is active HIGH
 */
#define GINT_PORT_POL_POL10(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL10_SHIFT)) & GINT_PORT_POL_POL10_MASK)

#define GINT_PORT_POL_POL11_MASK                 (0x800U)
#define GINT_PORT_POL_POL11_SHIFT                (11U)
/*! POL11 - Polarity of pin n of the port
 *  0b0..Pin is active LOW
 *  0b1..Pin is active HIGH
 */
#define GINT_PORT_POL_POL11(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL11_SHIFT)) & GINT_PORT_POL_POL11_MASK)

#define GINT_PORT_POL_POL12_MASK                 (0x1000U)
#define GINT_PORT_POL_POL12_SHIFT                (12U)
/*! POL12 - Polarity of pin n of the port
 *  0b0..Pin is active LOW
 *  0b1..Pin is active HIGH
 */
#define GINT_PORT_POL_POL12(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL12_SHIFT)) & GINT_PORT_POL_POL12_MASK)

#define GINT_PORT_POL_POL13_MASK                 (0x2000U)
#define GINT_PORT_POL_POL13_SHIFT                (13U)
/*! POL13 - Polarity of pin n of the port
 *  0b0..Pin is active LOW
 *  0b1..Pin is active HIGH
 */
#define GINT_PORT_POL_POL13(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL13_SHIFT)) & GINT_PORT_POL_POL13_MASK)

#define GINT_PORT_POL_POL14_MASK                 (0x4000U)
#define GINT_PORT_POL_POL14_SHIFT                (14U)
/*! POL14 - Polarity of pin n of the port
 *  0b0..Pin is active LOW
 *  0b1..Pin is active HIGH
 */
#define GINT_PORT_POL_POL14(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL14_SHIFT)) & GINT_PORT_POL_POL14_MASK)

#define GINT_PORT_POL_POL15_MASK                 (0x8000U)
#define GINT_PORT_POL_POL15_SHIFT                (15U)
/*! POL15 - Polarity of pin n of the port
 *  0b0..Pin is active LOW
 *  0b1..Pin is active HIGH
 */
#define GINT_PORT_POL_POL15(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL15_SHIFT)) & GINT_PORT_POL_POL15_MASK)

#define GINT_PORT_POL_POL16_MASK                 (0x10000U)
#define GINT_PORT_POL_POL16_SHIFT                (16U)
/*! POL16 - Polarity of pin n of the port
 *  0b0..Pin is active LOW
 *  0b1..Pin is active HIGH
 */
#define GINT_PORT_POL_POL16(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL16_SHIFT)) & GINT_PORT_POL_POL16_MASK)

#define GINT_PORT_POL_POL17_MASK                 (0x20000U)
#define GINT_PORT_POL_POL17_SHIFT                (17U)
/*! POL17 - Polarity of pin n of the port
 *  0b0..Pin is active LOW
 *  0b1..Pin is active HIGH
 */
#define GINT_PORT_POL_POL17(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL17_SHIFT)) & GINT_PORT_POL_POL17_MASK)

#define GINT_PORT_POL_POL18_MASK                 (0x40000U)
#define GINT_PORT_POL_POL18_SHIFT                (18U)
/*! POL18 - Polarity of pin n of the port
 *  0b0..Pin is active LOW
 *  0b1..Pin is active HIGH
 */
#define GINT_PORT_POL_POL18(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL18_SHIFT)) & GINT_PORT_POL_POL18_MASK)

#define GINT_PORT_POL_POL19_MASK                 (0x80000U)
#define GINT_PORT_POL_POL19_SHIFT                (19U)
/*! POL19 - Polarity of pin n of the port
 *  0b0..Pin is active LOW
 *  0b1..Pin is active HIGH
 */
#define GINT_PORT_POL_POL19(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL19_SHIFT)) & GINT_PORT_POL_POL19_MASK)

#define GINT_PORT_POL_POL20_MASK                 (0x100000U)
#define GINT_PORT_POL_POL20_SHIFT                (20U)
/*! POL20 - Polarity of pin n of the port
 *  0b0..Pin is active LOW
 *  0b1..Pin is active HIGH
 */
#define GINT_PORT_POL_POL20(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL20_SHIFT)) & GINT_PORT_POL_POL20_MASK)

#define GINT_PORT_POL_POL21_MASK                 (0x200000U)
#define GINT_PORT_POL_POL21_SHIFT                (21U)
/*! POL21 - Polarity of pin n of the port
 *  0b0..Pin is active LOW
 *  0b1..Pin is active HIGH
 */
#define GINT_PORT_POL_POL21(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL21_SHIFT)) & GINT_PORT_POL_POL21_MASK)

#define GINT_PORT_POL_POL22_MASK                 (0x400000U)
#define GINT_PORT_POL_POL22_SHIFT                (22U)
/*! POL22 - Polarity of pin n of the port
 *  0b0..Pin is active LOW
 *  0b1..Pin is active HIGH
 */
#define GINT_PORT_POL_POL22(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL22_SHIFT)) & GINT_PORT_POL_POL22_MASK)

#define GINT_PORT_POL_POL23_MASK                 (0x800000U)
#define GINT_PORT_POL_POL23_SHIFT                (23U)
/*! POL23 - Polarity of pin n of the port
 *  0b0..Pin is active LOW
 *  0b1..Pin is active HIGH
 */
#define GINT_PORT_POL_POL23(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL23_SHIFT)) & GINT_PORT_POL_POL23_MASK)

#define GINT_PORT_POL_POL24_MASK                 (0x1000000U)
#define GINT_PORT_POL_POL24_SHIFT                (24U)
/*! POL24 - Polarity of pin n of the port
 *  0b0..Pin is active LOW
 *  0b1..Pin is active HIGH
 */
#define GINT_PORT_POL_POL24(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL24_SHIFT)) & GINT_PORT_POL_POL24_MASK)

#define GINT_PORT_POL_POL25_MASK                 (0x2000000U)
#define GINT_PORT_POL_POL25_SHIFT                (25U)
/*! POL25 - Polarity of pin n of the port
 *  0b0..Pin is active LOW
 *  0b1..Pin is active HIGH
 */
#define GINT_PORT_POL_POL25(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL25_SHIFT)) & GINT_PORT_POL_POL25_MASK)

#define GINT_PORT_POL_POL26_MASK                 (0x4000000U)
#define GINT_PORT_POL_POL26_SHIFT                (26U)
/*! POL26 - Polarity of pin n of the port
 *  0b0..Pin is active LOW
 *  0b1..Pin is active HIGH
 */
#define GINT_PORT_POL_POL26(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL26_SHIFT)) & GINT_PORT_POL_POL26_MASK)

#define GINT_PORT_POL_POL27_MASK                 (0x8000000U)
#define GINT_PORT_POL_POL27_SHIFT                (27U)
/*! POL27 - Polarity of pin n of the port
 *  0b0..Pin is active LOW
 *  0b1..Pin is active HIGH
 */
#define GINT_PORT_POL_POL27(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL27_SHIFT)) & GINT_PORT_POL_POL27_MASK)

#define GINT_PORT_POL_POL28_MASK                 (0x10000000U)
#define GINT_PORT_POL_POL28_SHIFT                (28U)
/*! POL28 - Polarity of pin n of the port
 *  0b0..Pin is active LOW
 *  0b1..Pin is active HIGH
 */
#define GINT_PORT_POL_POL28(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL28_SHIFT)) & GINT_PORT_POL_POL28_MASK)

#define GINT_PORT_POL_POL29_MASK                 (0x20000000U)
#define GINT_PORT_POL_POL29_SHIFT                (29U)
/*! POL29 - Polarity of pin n of the port
 *  0b0..Pin is active LOW
 *  0b1..Pin is active HIGH
 */
#define GINT_PORT_POL_POL29(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL29_SHIFT)) & GINT_PORT_POL_POL29_MASK)

#define GINT_PORT_POL_POL30_MASK                 (0x40000000U)
#define GINT_PORT_POL_POL30_SHIFT                (30U)
/*! POL30 - Polarity of pin n of the port
 *  0b0..Pin is active LOW
 *  0b1..Pin is active HIGH
 */
#define GINT_PORT_POL_POL30(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL30_SHIFT)) & GINT_PORT_POL_POL30_MASK)

#define GINT_PORT_POL_POL31_MASK                 (0x80000000U)
#define GINT_PORT_POL_POL31_SHIFT                (31U)
/*! POL31 - Polarity of pin n of the port
 *  0b0..Pin is active LOW
 *  0b1..Pin is active HIGH
 */
#define GINT_PORT_POL_POL31(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_POL_POL31_SHIFT)) & GINT_PORT_POL_POL31_MASK)
/*! @} */

/* The count of GINT_PORT_POL */
#define GINT_PORT_POL_COUNT                      (2U)

/*! @name PORT_ENA - GPIO grouped interrupt port 0 enable register */
/*! @{ */

#define GINT_PORT_ENA_ENA0_MASK                  (0x1U)
#define GINT_PORT_ENA_ENA0_SHIFT                 (0U)
/*! ENA0 - Enables port pin n to contribute to the group interrupt
 *  0b0..Pin is disabled and does not contribute to the grouped interrupt
 *  0b1..Pin is enabled and contributes to the grouped interrupt
 */
#define GINT_PORT_ENA_ENA0(x)                    (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA0_SHIFT)) & GINT_PORT_ENA_ENA0_MASK)

#define GINT_PORT_ENA_ENA1_MASK                  (0x2U)
#define GINT_PORT_ENA_ENA1_SHIFT                 (1U)
/*! ENA1 - Enables port pin n to contribute to the group interrupt
 *  0b0..Pin is disabled and does not contribute to the grouped interrupt
 *  0b1..Pin is enabled and contributes to the grouped interrupt
 */
#define GINT_PORT_ENA_ENA1(x)                    (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA1_SHIFT)) & GINT_PORT_ENA_ENA1_MASK)

#define GINT_PORT_ENA_ENA2_MASK                  (0x4U)
#define GINT_PORT_ENA_ENA2_SHIFT                 (2U)
/*! ENA2 - Enables port pin n to contribute to the group interrupt
 *  0b0..Pin is disabled and does not contribute to the grouped interrupt
 *  0b1..Pin is enabled and contributes to the grouped interrupt
 */
#define GINT_PORT_ENA_ENA2(x)                    (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA2_SHIFT)) & GINT_PORT_ENA_ENA2_MASK)

#define GINT_PORT_ENA_ENA3_MASK                  (0x8U)
#define GINT_PORT_ENA_ENA3_SHIFT                 (3U)
/*! ENA3 - Enables port pin n to contribute to the group interrupt
 *  0b0..Pin is disabled and does not contribute to the grouped interrupt
 *  0b1..Pin is enabled and contributes to the grouped interrupt
 */
#define GINT_PORT_ENA_ENA3(x)                    (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA3_SHIFT)) & GINT_PORT_ENA_ENA3_MASK)

#define GINT_PORT_ENA_ENA4_MASK                  (0x10U)
#define GINT_PORT_ENA_ENA4_SHIFT                 (4U)
/*! ENA4 - Enables port pin n to contribute to the group interrupt
 *  0b0..Pin is disabled and does not contribute to the grouped interrupt
 *  0b1..Pin is enabled and contributes to the grouped interrupt
 */
#define GINT_PORT_ENA_ENA4(x)                    (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA4_SHIFT)) & GINT_PORT_ENA_ENA4_MASK)

#define GINT_PORT_ENA_ENA5_MASK                  (0x20U)
#define GINT_PORT_ENA_ENA5_SHIFT                 (5U)
/*! ENA5 - Enables port pin n to contribute to the group interrupt
 *  0b0..Pin is disabled and does not contribute to the grouped interrupt
 *  0b1..Pin is enabled and contributes to the grouped interrupt
 */
#define GINT_PORT_ENA_ENA5(x)                    (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA5_SHIFT)) & GINT_PORT_ENA_ENA5_MASK)

#define GINT_PORT_ENA_ENA6_MASK                  (0x40U)
#define GINT_PORT_ENA_ENA6_SHIFT                 (6U)
/*! ENA6 - Enables port pin n to contribute to the group interrupt
 *  0b0..Pin is disabled and does not contribute to the grouped interrupt
 *  0b1..Pin is enabled and contributes to the grouped interrupt
 */
#define GINT_PORT_ENA_ENA6(x)                    (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA6_SHIFT)) & GINT_PORT_ENA_ENA6_MASK)

#define GINT_PORT_ENA_ENA7_MASK                  (0x80U)
#define GINT_PORT_ENA_ENA7_SHIFT                 (7U)
/*! ENA7 - Enables port pin n to contribute to the group interrupt
 *  0b0..Pin is disabled and does not contribute to the grouped interrupt
 *  0b1..Pin is enabled and contributes to the grouped interrupt
 */
#define GINT_PORT_ENA_ENA7(x)                    (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA7_SHIFT)) & GINT_PORT_ENA_ENA7_MASK)

#define GINT_PORT_ENA_ENA8_MASK                  (0x100U)
#define GINT_PORT_ENA_ENA8_SHIFT                 (8U)
/*! ENA8 - Enables port pin n to contribute to the group interrupt
 *  0b0..Pin is disabled and does not contribute to the grouped interrupt
 *  0b1..Pin is enabled and contributes to the grouped interrupt
 */
#define GINT_PORT_ENA_ENA8(x)                    (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA8_SHIFT)) & GINT_PORT_ENA_ENA8_MASK)

#define GINT_PORT_ENA_ENA9_MASK                  (0x200U)
#define GINT_PORT_ENA_ENA9_SHIFT                 (9U)
/*! ENA9 - Enables port pin n to contribute to the group interrupt
 *  0b0..Pin is disabled and does not contribute to the grouped interrupt
 *  0b1..Pin is enabled and contributes to the grouped interrupt
 */
#define GINT_PORT_ENA_ENA9(x)                    (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA9_SHIFT)) & GINT_PORT_ENA_ENA9_MASK)

#define GINT_PORT_ENA_ENA10_MASK                 (0x400U)
#define GINT_PORT_ENA_ENA10_SHIFT                (10U)
/*! ENA10 - Enables port pin n to contribute to the group interrupt
 *  0b0..Pin is disabled and does not contribute to the grouped interrupt
 *  0b1..Pin is enabled and contributes to the grouped interrupt
 */
#define GINT_PORT_ENA_ENA10(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA10_SHIFT)) & GINT_PORT_ENA_ENA10_MASK)

#define GINT_PORT_ENA_ENA11_MASK                 (0x800U)
#define GINT_PORT_ENA_ENA11_SHIFT                (11U)
/*! ENA11 - Enables port pin n to contribute to the group interrupt
 *  0b0..Pin is disabled and does not contribute to the grouped interrupt
 *  0b1..Pin is enabled and contributes to the grouped interrupt
 */
#define GINT_PORT_ENA_ENA11(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA11_SHIFT)) & GINT_PORT_ENA_ENA11_MASK)

#define GINT_PORT_ENA_ENA12_MASK                 (0x1000U)
#define GINT_PORT_ENA_ENA12_SHIFT                (12U)
/*! ENA12 - Enables port pin n to contribute to the group interrupt
 *  0b0..Pin is disabled and does not contribute to the grouped interrupt
 *  0b1..Pin is enabled and contributes to the grouped interrupt
 */
#define GINT_PORT_ENA_ENA12(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA12_SHIFT)) & GINT_PORT_ENA_ENA12_MASK)

#define GINT_PORT_ENA_ENA13_MASK                 (0x2000U)
#define GINT_PORT_ENA_ENA13_SHIFT                (13U)
/*! ENA13 - Enables port pin n to contribute to the group interrupt
 *  0b0..Pin is disabled and does not contribute to the grouped interrupt
 *  0b1..Pin is enabled and contributes to the grouped interrupt
 */
#define GINT_PORT_ENA_ENA13(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA13_SHIFT)) & GINT_PORT_ENA_ENA13_MASK)

#define GINT_PORT_ENA_ENA14_MASK                 (0x4000U)
#define GINT_PORT_ENA_ENA14_SHIFT                (14U)
/*! ENA14 - Enables port pin n to contribute to the group interrupt
 *  0b0..Pin is disabled and does not contribute to the grouped interrupt
 *  0b1..Pin is enabled and contributes to the grouped interrupt
 */
#define GINT_PORT_ENA_ENA14(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA14_SHIFT)) & GINT_PORT_ENA_ENA14_MASK)

#define GINT_PORT_ENA_ENA15_MASK                 (0x8000U)
#define GINT_PORT_ENA_ENA15_SHIFT                (15U)
/*! ENA15 - Enables port pin n to contribute to the group interrupt
 *  0b0..Pin is disabled and does not contribute to the grouped interrupt
 *  0b1..Pin is enabled and contributes to the grouped interrupt
 */
#define GINT_PORT_ENA_ENA15(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA15_SHIFT)) & GINT_PORT_ENA_ENA15_MASK)

#define GINT_PORT_ENA_ENA16_MASK                 (0x10000U)
#define GINT_PORT_ENA_ENA16_SHIFT                (16U)
/*! ENA16 - Enables port pin n to contribute to the group interrupt
 *  0b0..Pin is disabled and does not contribute to the grouped interrupt
 *  0b1..Pin is enabled and contributes to the grouped interrupt
 */
#define GINT_PORT_ENA_ENA16(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA16_SHIFT)) & GINT_PORT_ENA_ENA16_MASK)

#define GINT_PORT_ENA_ENA17_MASK                 (0x20000U)
#define GINT_PORT_ENA_ENA17_SHIFT                (17U)
/*! ENA17 - Enables port pin n to contribute to the group interrupt
 *  0b0..Pin is disabled and does not contribute to the grouped interrupt
 *  0b1..Pin is enabled and contributes to the grouped interrupt
 */
#define GINT_PORT_ENA_ENA17(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA17_SHIFT)) & GINT_PORT_ENA_ENA17_MASK)

#define GINT_PORT_ENA_ENA18_MASK                 (0x40000U)
#define GINT_PORT_ENA_ENA18_SHIFT                (18U)
/*! ENA18 - Enables port pin n to contribute to the group interrupt
 *  0b0..Pin is disabled and does not contribute to the grouped interrupt
 *  0b1..Pin is enabled and contributes to the grouped interrupt
 */
#define GINT_PORT_ENA_ENA18(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA18_SHIFT)) & GINT_PORT_ENA_ENA18_MASK)

#define GINT_PORT_ENA_ENA19_MASK                 (0x80000U)
#define GINT_PORT_ENA_ENA19_SHIFT                (19U)
/*! ENA19 - Enables port pin n to contribute to the group interrupt
 *  0b0..Pin is disabled and does not contribute to the grouped interrupt
 *  0b1..Pin is enabled and contributes to the grouped interrupt
 */
#define GINT_PORT_ENA_ENA19(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA19_SHIFT)) & GINT_PORT_ENA_ENA19_MASK)

#define GINT_PORT_ENA_ENA20_MASK                 (0x100000U)
#define GINT_PORT_ENA_ENA20_SHIFT                (20U)
/*! ENA20 - Enables port pin n to contribute to the group interrupt
 *  0b0..Pin is disabled and does not contribute to the grouped interrupt
 *  0b1..Pin is enabled and contributes to the grouped interrupt
 */
#define GINT_PORT_ENA_ENA20(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA20_SHIFT)) & GINT_PORT_ENA_ENA20_MASK)

#define GINT_PORT_ENA_ENA21_MASK                 (0x200000U)
#define GINT_PORT_ENA_ENA21_SHIFT                (21U)
/*! ENA21 - Enables port pin n to contribute to the group interrupt
 *  0b0..Pin is disabled and does not contribute to the grouped interrupt
 *  0b1..Pin is enabled and contributes to the grouped interrupt
 */
#define GINT_PORT_ENA_ENA21(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA21_SHIFT)) & GINT_PORT_ENA_ENA21_MASK)

#define GINT_PORT_ENA_ENA22_MASK                 (0x400000U)
#define GINT_PORT_ENA_ENA22_SHIFT                (22U)
/*! ENA22 - Enables port pin n to contribute to the group interrupt
 *  0b0..Pin is disabled and does not contribute to the grouped interrupt
 *  0b1..Pin is enabled and contributes to the grouped interrupt
 */
#define GINT_PORT_ENA_ENA22(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA22_SHIFT)) & GINT_PORT_ENA_ENA22_MASK)

#define GINT_PORT_ENA_ENA23_MASK                 (0x800000U)
#define GINT_PORT_ENA_ENA23_SHIFT                (23U)
/*! ENA23 - Enables port pin n to contribute to the group interrupt
 *  0b0..Pin is disabled and does not contribute to the grouped interrupt
 *  0b1..Pin is enabled and contributes to the grouped interrupt
 */
#define GINT_PORT_ENA_ENA23(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA23_SHIFT)) & GINT_PORT_ENA_ENA23_MASK)

#define GINT_PORT_ENA_ENA24_MASK                 (0x1000000U)
#define GINT_PORT_ENA_ENA24_SHIFT                (24U)
/*! ENA24 - Enables port pin n to contribute to the group interrupt
 *  0b0..Pin is disabled and does not contribute to the grouped interrupt
 *  0b1..Pin is enabled and contributes to the grouped interrupt
 */
#define GINT_PORT_ENA_ENA24(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA24_SHIFT)) & GINT_PORT_ENA_ENA24_MASK)

#define GINT_PORT_ENA_ENA25_MASK                 (0x2000000U)
#define GINT_PORT_ENA_ENA25_SHIFT                (25U)
/*! ENA25 - Enables port pin n to contribute to the group interrupt
 *  0b0..Pin is disabled and does not contribute to the grouped interrupt
 *  0b1..Pin is enabled and contributes to the grouped interrupt
 */
#define GINT_PORT_ENA_ENA25(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA25_SHIFT)) & GINT_PORT_ENA_ENA25_MASK)

#define GINT_PORT_ENA_ENA26_MASK                 (0x4000000U)
#define GINT_PORT_ENA_ENA26_SHIFT                (26U)
/*! ENA26 - Enables port pin n to contribute to the group interrupt
 *  0b0..Pin is disabled and does not contribute to the grouped interrupt
 *  0b1..Pin is enabled and contributes to the grouped interrupt
 */
#define GINT_PORT_ENA_ENA26(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA26_SHIFT)) & GINT_PORT_ENA_ENA26_MASK)

#define GINT_PORT_ENA_ENA27_MASK                 (0x8000000U)
#define GINT_PORT_ENA_ENA27_SHIFT                (27U)
/*! ENA27 - Enables port pin n to contribute to the group interrupt
 *  0b0..Pin is disabled and does not contribute to the grouped interrupt
 *  0b1..Pin is enabled and contributes to the grouped interrupt
 */
#define GINT_PORT_ENA_ENA27(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA27_SHIFT)) & GINT_PORT_ENA_ENA27_MASK)

#define GINT_PORT_ENA_ENA28_MASK                 (0x10000000U)
#define GINT_PORT_ENA_ENA28_SHIFT                (28U)
/*! ENA28 - Enables port pin n to contribute to the group interrupt
 *  0b0..Pin is disabled and does not contribute to the grouped interrupt
 *  0b1..Pin is enabled and contributes to the grouped interrupt
 */
#define GINT_PORT_ENA_ENA28(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA28_SHIFT)) & GINT_PORT_ENA_ENA28_MASK)

#define GINT_PORT_ENA_ENA29_MASK                 (0x20000000U)
#define GINT_PORT_ENA_ENA29_SHIFT                (29U)
/*! ENA29 - Enables port pin n to contribute to the group interrupt
 *  0b0..Pin is disabled and does not contribute to the grouped interrupt
 *  0b1..Pin is enabled and contributes to the grouped interrupt
 */
#define GINT_PORT_ENA_ENA29(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA29_SHIFT)) & GINT_PORT_ENA_ENA29_MASK)

#define GINT_PORT_ENA_ENA30_MASK                 (0x40000000U)
#define GINT_PORT_ENA_ENA30_SHIFT                (30U)
/*! ENA30 - Enables port pin n to contribute to the group interrupt
 *  0b0..Pin is disabled and does not contribute to the grouped interrupt
 *  0b1..Pin is enabled and contributes to the grouped interrupt
 */
#define GINT_PORT_ENA_ENA30(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA30_SHIFT)) & GINT_PORT_ENA_ENA30_MASK)

#define GINT_PORT_ENA_ENA31_MASK                 (0x80000000U)
#define GINT_PORT_ENA_ENA31_SHIFT                (31U)
/*! ENA31 - Enables port pin n to contribute to the group interrupt
 *  0b0..Pin is disabled and does not contribute to the grouped interrupt
 *  0b1..Pin is enabled and contributes to the grouped interrupt
 */
#define GINT_PORT_ENA_ENA31(x)                   (((uint32_t)(((uint32_t)(x)) << GINT_PORT_ENA_ENA31_SHIFT)) & GINT_PORT_ENA_ENA31_MASK)
/*! @} */

/* The count of GINT_PORT_ENA */
#define GINT_PORT_ENA_COUNT                      (2U)


/*!
 * @}
 */ /* end of group GINT_Register_Masks */


/* GINT - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral GINT0 base address */
  #define GINT0_BASE                               (0x50002000u)
  /** Peripheral GINT0 base address */
  #define GINT0_BASE_NS                            (0x40002000u)
  /** Peripheral GINT0 base pointer */
  #define GINT0                                    ((GINT_Type *)GINT0_BASE)
  /** Peripheral GINT0 base pointer */
  #define GINT0_NS                                 ((GINT_Type *)GINT0_BASE_NS)
  /** Peripheral GINT1 base address */
  #define GINT1_BASE                               (0x50003000u)
  /** Peripheral GINT1 base address */
  #define GINT1_BASE_NS                            (0x40003000u)
  /** Peripheral GINT1 base pointer */
  #define GINT1                                    ((GINT_Type *)GINT1_BASE)
  /** Peripheral GINT1 base pointer */
  #define GINT1_NS                                 ((GINT_Type *)GINT1_BASE_NS)
  /** Array initializer of GINT peripheral base addresses */
  #define GINT_BASE_ADDRS                          { GINT0_BASE, GINT1_BASE }
  /** Array initializer of GINT peripheral base pointers */
  #define GINT_BASE_PTRS                           { GINT0, GINT1 }
  /** Array initializer of GINT peripheral base addresses */
  #define GINT_BASE_ADDRS_NS                       { GINT0_BASE_NS, GINT1_BASE_NS }
  /** Array initializer of GINT peripheral base pointers */
  #define GINT_BASE_PTRS_NS                        { GINT0_NS, GINT1_NS }
#else
  /** Peripheral GINT0 base address */
  #define GINT0_BASE                               (0x40002000u)
  /** Peripheral GINT0 base pointer */
  #define GINT0                                    ((GINT_Type *)GINT0_BASE)
  /** Peripheral GINT1 base address */
  #define GINT1_BASE                               (0x40003000u)
  /** Peripheral GINT1 base pointer */
  #define GINT1                                    ((GINT_Type *)GINT1_BASE)
  /** Array initializer of GINT peripheral base addresses */
  #define GINT_BASE_ADDRS                          { GINT0_BASE, GINT1_BASE }
  /** Array initializer of GINT peripheral base pointers */
  #define GINT_BASE_PTRS                           { GINT0, GINT1 }
#endif
/** Interrupt vectors for the GINT peripheral type */
#define GINT_IRQS                                { GINT0_IRQn, GINT1_IRQn }

/*!
 * @}
 */ /* end of group GINT_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- GPIO Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPIO_Peripheral_Access_Layer GPIO Peripheral Access Layer
 * @{
 */

/** GPIO - Register Layout Typedef */
typedef struct {
  __IO uint8_t B[4][32];                           /**< Byte pin registers for all port GPIO pins, array offset: 0x0, array step: index*0x20, index2*0x1 */
       uint8_t RESERVED_0[3968];
  __IO uint32_t W[4][32];                          /**< Word pin registers for all port GPIO pins, array offset: 0x1000, array step: index*0x80, index2*0x4 */
       uint8_t RESERVED_1[3584];
  __O  uint32_t DIR[4];                            /**< Port direction, array offset: 0x2000, array step: 0x4 */
       uint8_t RESERVED_2[112];
  __IO uint32_t MASK[4];                           /**< Port mask, array offset: 0x2080, array step: 0x4 */
       uint8_t RESERVED_3[112];
  __IO uint32_t PIN[4];                            /**< Port pin, array offset: 0x2100, array step: 0x4 */
       uint8_t RESERVED_4[112];
  __IO uint32_t MPIN[4];                           /**< Masked Port Pin, array offset: 0x2180, array step: 0x4 */
       uint8_t RESERVED_5[112];
  __IO uint32_t SET[4];                            /**< Port set, array offset: 0x2200, array step: 0x4 */
       uint8_t RESERVED_6[112];
  __IO uint32_t CLR[4];                            /**< Port clear, array offset: 0x2280, array step: 0x4 */
       uint8_t RESERVED_7[112];
  __O  uint32_t NOT[4];                            /**< Port toggle, array offset: 0x2300, array step: 0x4 */
       uint8_t RESERVED_8[112];
  __O  uint32_t DIRSET[4];                         /**< Port direction set, array offset: 0x2380, array step: 0x4 */
       uint8_t RESERVED_9[112];
  __IO uint32_t DIRCLR[4];                         /**< Port direction clear, array offset: 0x2400, array step: 0x4 */
       uint8_t RESERVED_10[112];
  __O  uint32_t DIRNOT[4];                         /**< Port direction toggle, array offset: 0x2480, array step: 0x4 */
       uint8_t RESERVED_11[112];
  __IO uint32_t INTENA[4];                         /**< Interrupt A enable control, array offset: 0x2500, array step: 0x4 */
       uint8_t RESERVED_12[112];
  __IO uint32_t INTENB[4];                         /**< Interrupt B enable control, array offset: 0x2580, array step: 0x4 */
       uint8_t RESERVED_13[112];
  __IO uint32_t INTPOL[4];                         /**< Interupt polarity control, array offset: 0x2600, array step: 0x4 */
       uint8_t RESERVED_14[112];
  __IO uint32_t INTEDG[4];                         /**< Interrupt edge select, array offset: 0x2680, array step: 0x4 */
       uint8_t RESERVED_15[112];
  __IO uint32_t INTSTATA[4];                       /**< Interrupt status for interrupt A, array offset: 0x2700, array step: 0x4 */
       uint8_t RESERVED_16[112];
  __IO uint32_t INTSTATB[4];                       /**< Interrupt status for interrupt B, array offset: 0x2780, array step: 0x4 */
} GPIO_Type;

/* ----------------------------------------------------------------------------
   -- GPIO Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPIO_Register_Masks GPIO Register Masks
 * @{
 */

/*! @name BYTE_PIN_BYTE_PIN_B - Byte pin registers for all port GPIO pins */
/*! @{ */

#define GPIO_BYTE_PIN_BYTE_PIN_B_PBYTE_MASK      (0x1U)
#define GPIO_BYTE_PIN_BYTE_PIN_B_PBYTE_SHIFT     (0U)
/*! PBYTE - Port Byte
 */
#define GPIO_BYTE_PIN_BYTE_PIN_B_PBYTE(x)        (((uint8_t)(((uint8_t)(x)) << GPIO_BYTE_PIN_BYTE_PIN_B_PBYTE_SHIFT)) & GPIO_BYTE_PIN_BYTE_PIN_B_PBYTE_MASK)
/*! @} */

/* The count of GPIO_BYTE_PIN_BYTE_PIN_B */
#define GPIO_BYTE_PIN_BYTE_PIN_B_COUNT           (4U)

/* The count of GPIO_BYTE_PIN_BYTE_PIN_B */
#define GPIO_BYTE_PIN_BYTE_PIN_B_COUNT2          (32U)

/*! @name WORD_PIN_WORD_PIN_W - Word pin registers for all port GPIO pins */
/*! @{ */

#define GPIO_WORD_PIN_WORD_PIN_W_PWORD_MASK      (0xFFFFFFFFU)
#define GPIO_WORD_PIN_WORD_PIN_W_PWORD_SHIFT     (0U)
/*! PWORD - PWORD
 */
#define GPIO_WORD_PIN_WORD_PIN_W_PWORD(x)        (((uint32_t)(((uint32_t)(x)) << GPIO_WORD_PIN_WORD_PIN_W_PWORD_SHIFT)) & GPIO_WORD_PIN_WORD_PIN_W_PWORD_MASK)
/*! @} */

/* The count of GPIO_WORD_PIN_WORD_PIN_W */
#define GPIO_WORD_PIN_WORD_PIN_W_COUNT           (4U)

/* The count of GPIO_WORD_PIN_WORD_PIN_W */
#define GPIO_WORD_PIN_WORD_PIN_W_COUNT2          (32U)

/*! @name DIR - Port direction */
/*! @{ */

#define GPIO_DIR_DIRP0_MASK                      (0x1U)
#define GPIO_DIR_DIRP0_SHIFT                     (0U)
/*! DIRP0 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP0(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP0_SHIFT)) & GPIO_DIR_DIRP0_MASK)

#define GPIO_DIR_DIRP1_MASK                      (0x2U)
#define GPIO_DIR_DIRP1_SHIFT                     (1U)
/*! DIRP1 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP1(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP1_SHIFT)) & GPIO_DIR_DIRP1_MASK)

#define GPIO_DIR_DIRP2_MASK                      (0x4U)
#define GPIO_DIR_DIRP2_SHIFT                     (2U)
/*! DIRP2 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP2(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP2_SHIFT)) & GPIO_DIR_DIRP2_MASK)

#define GPIO_DIR_DIRP3_MASK                      (0x8U)
#define GPIO_DIR_DIRP3_SHIFT                     (3U)
/*! DIRP3 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP3(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP3_SHIFT)) & GPIO_DIR_DIRP3_MASK)

#define GPIO_DIR_DIRP4_MASK                      (0x10U)
#define GPIO_DIR_DIRP4_SHIFT                     (4U)
/*! DIRP4 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP4(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP4_SHIFT)) & GPIO_DIR_DIRP4_MASK)

#define GPIO_DIR_DIRP5_MASK                      (0x20U)
#define GPIO_DIR_DIRP5_SHIFT                     (5U)
/*! DIRP5 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP5(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP5_SHIFT)) & GPIO_DIR_DIRP5_MASK)

#define GPIO_DIR_DIRP6_MASK                      (0x40U)
#define GPIO_DIR_DIRP6_SHIFT                     (6U)
/*! DIRP6 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP6(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP6_SHIFT)) & GPIO_DIR_DIRP6_MASK)

#define GPIO_DIR_DIRP7_MASK                      (0x80U)
#define GPIO_DIR_DIRP7_SHIFT                     (7U)
/*! DIRP7 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP7(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP7_SHIFT)) & GPIO_DIR_DIRP7_MASK)

#define GPIO_DIR_DIRP8_MASK                      (0x100U)
#define GPIO_DIR_DIRP8_SHIFT                     (8U)
/*! DIRP8 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP8(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP8_SHIFT)) & GPIO_DIR_DIRP8_MASK)

#define GPIO_DIR_DIRP9_MASK                      (0x200U)
#define GPIO_DIR_DIRP9_SHIFT                     (9U)
/*! DIRP9 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP9(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP9_SHIFT)) & GPIO_DIR_DIRP9_MASK)

#define GPIO_DIR_DIRP10_MASK                     (0x400U)
#define GPIO_DIR_DIRP10_SHIFT                    (10U)
/*! DIRP10 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP10(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP10_SHIFT)) & GPIO_DIR_DIRP10_MASK)

#define GPIO_DIR_DIRP11_MASK                     (0x800U)
#define GPIO_DIR_DIRP11_SHIFT                    (11U)
/*! DIRP11 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP11(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP11_SHIFT)) & GPIO_DIR_DIRP11_MASK)

#define GPIO_DIR_DIRP12_MASK                     (0x1000U)
#define GPIO_DIR_DIRP12_SHIFT                    (12U)
/*! DIRP12 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP12(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP12_SHIFT)) & GPIO_DIR_DIRP12_MASK)

#define GPIO_DIR_DIRP13_MASK                     (0x2000U)
#define GPIO_DIR_DIRP13_SHIFT                    (13U)
/*! DIRP13 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP13(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP13_SHIFT)) & GPIO_DIR_DIRP13_MASK)

#define GPIO_DIR_DIRP14_MASK                     (0x4000U)
#define GPIO_DIR_DIRP14_SHIFT                    (14U)
/*! DIRP14 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP14(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP14_SHIFT)) & GPIO_DIR_DIRP14_MASK)

#define GPIO_DIR_DIRP15_MASK                     (0x8000U)
#define GPIO_DIR_DIRP15_SHIFT                    (15U)
/*! DIRP15 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP15(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP15_SHIFT)) & GPIO_DIR_DIRP15_MASK)

#define GPIO_DIR_DIRP16_MASK                     (0x10000U)
#define GPIO_DIR_DIRP16_SHIFT                    (16U)
/*! DIRP16 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP16(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP16_SHIFT)) & GPIO_DIR_DIRP16_MASK)

#define GPIO_DIR_DIRP17_MASK                     (0x20000U)
#define GPIO_DIR_DIRP17_SHIFT                    (17U)
/*! DIRP17 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP17(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP17_SHIFT)) & GPIO_DIR_DIRP17_MASK)

#define GPIO_DIR_DIRP18_MASK                     (0x40000U)
#define GPIO_DIR_DIRP18_SHIFT                    (18U)
/*! DIRP18 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP18(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP18_SHIFT)) & GPIO_DIR_DIRP18_MASK)

#define GPIO_DIR_DIRP19_MASK                     (0x80000U)
#define GPIO_DIR_DIRP19_SHIFT                    (19U)
/*! DIRP19 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP19(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP19_SHIFT)) & GPIO_DIR_DIRP19_MASK)

#define GPIO_DIR_DIRP20_MASK                     (0x100000U)
#define GPIO_DIR_DIRP20_SHIFT                    (20U)
/*! DIRP20 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP20(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP20_SHIFT)) & GPIO_DIR_DIRP20_MASK)

#define GPIO_DIR_DIRP21_MASK                     (0x200000U)
#define GPIO_DIR_DIRP21_SHIFT                    (21U)
/*! DIRP21 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP21(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP21_SHIFT)) & GPIO_DIR_DIRP21_MASK)

#define GPIO_DIR_DIRP22_MASK                     (0x400000U)
#define GPIO_DIR_DIRP22_SHIFT                    (22U)
/*! DIRP22 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP22(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP22_SHIFT)) & GPIO_DIR_DIRP22_MASK)

#define GPIO_DIR_DIRP23_MASK                     (0x800000U)
#define GPIO_DIR_DIRP23_SHIFT                    (23U)
/*! DIRP23 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP23(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP23_SHIFT)) & GPIO_DIR_DIRP23_MASK)

#define GPIO_DIR_DIRP24_MASK                     (0x1000000U)
#define GPIO_DIR_DIRP24_SHIFT                    (24U)
/*! DIRP24 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP24(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP24_SHIFT)) & GPIO_DIR_DIRP24_MASK)

#define GPIO_DIR_DIRP25_MASK                     (0x2000000U)
#define GPIO_DIR_DIRP25_SHIFT                    (25U)
/*! DIRP25 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP25(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP25_SHIFT)) & GPIO_DIR_DIRP25_MASK)

#define GPIO_DIR_DIRP26_MASK                     (0x4000000U)
#define GPIO_DIR_DIRP26_SHIFT                    (26U)
/*! DIRP26 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP26(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP26_SHIFT)) & GPIO_DIR_DIRP26_MASK)

#define GPIO_DIR_DIRP27_MASK                     (0x8000000U)
#define GPIO_DIR_DIRP27_SHIFT                    (27U)
/*! DIRP27 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP27(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP27_SHIFT)) & GPIO_DIR_DIRP27_MASK)

#define GPIO_DIR_DIRP28_MASK                     (0x10000000U)
#define GPIO_DIR_DIRP28_SHIFT                    (28U)
/*! DIRP28 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP28(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP28_SHIFT)) & GPIO_DIR_DIRP28_MASK)

#define GPIO_DIR_DIRP29_MASK                     (0x20000000U)
#define GPIO_DIR_DIRP29_SHIFT                    (29U)
/*! DIRP29 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP29(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP29_SHIFT)) & GPIO_DIR_DIRP29_MASK)

#define GPIO_DIR_DIRP30_MASK                     (0x40000000U)
#define GPIO_DIR_DIRP30_SHIFT                    (30U)
/*! DIRP30 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP30(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP30_SHIFT)) & GPIO_DIR_DIRP30_MASK)

#define GPIO_DIR_DIRP31_MASK                     (0x80000000U)
#define GPIO_DIR_DIRP31_SHIFT                    (31U)
/*! DIRP31 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP31(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP31_SHIFT)) & GPIO_DIR_DIRP31_MASK)
/*! @} */

/* The count of GPIO_DIR */
#define GPIO_DIR_COUNT                           (4U)

/*! @name MASK - Port mask */
/*! @{ */

#define GPIO_MASK_MASKP0_MASK                    (0x1U)
#define GPIO_MASK_MASKP0_SHIFT                   (0U)
/*! MASKP0 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP0(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP0_SHIFT)) & GPIO_MASK_MASKP0_MASK)

#define GPIO_MASK_MASKP1_MASK                    (0x2U)
#define GPIO_MASK_MASKP1_SHIFT                   (1U)
/*! MASKP1 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP1(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP1_SHIFT)) & GPIO_MASK_MASKP1_MASK)

#define GPIO_MASK_MASKP2_MASK                    (0x4U)
#define GPIO_MASK_MASKP2_SHIFT                   (2U)
/*! MASKP2 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP2(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP2_SHIFT)) & GPIO_MASK_MASKP2_MASK)

#define GPIO_MASK_MASKP3_MASK                    (0x8U)
#define GPIO_MASK_MASKP3_SHIFT                   (3U)
/*! MASKP3 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP3(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP3_SHIFT)) & GPIO_MASK_MASKP3_MASK)

#define GPIO_MASK_MASKP4_MASK                    (0x10U)
#define GPIO_MASK_MASKP4_SHIFT                   (4U)
/*! MASKP4 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP4(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP4_SHIFT)) & GPIO_MASK_MASKP4_MASK)

#define GPIO_MASK_MASKP5_MASK                    (0x20U)
#define GPIO_MASK_MASKP5_SHIFT                   (5U)
/*! MASKP5 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP5(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP5_SHIFT)) & GPIO_MASK_MASKP5_MASK)

#define GPIO_MASK_MASKP6_MASK                    (0x40U)
#define GPIO_MASK_MASKP6_SHIFT                   (6U)
/*! MASKP6 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP6(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP6_SHIFT)) & GPIO_MASK_MASKP6_MASK)

#define GPIO_MASK_MASKP7_MASK                    (0x80U)
#define GPIO_MASK_MASKP7_SHIFT                   (7U)
/*! MASKP7 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP7(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP7_SHIFT)) & GPIO_MASK_MASKP7_MASK)

#define GPIO_MASK_MASKP8_MASK                    (0x100U)
#define GPIO_MASK_MASKP8_SHIFT                   (8U)
/*! MASKP8 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP8(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP8_SHIFT)) & GPIO_MASK_MASKP8_MASK)

#define GPIO_MASK_MASKP9_MASK                    (0x200U)
#define GPIO_MASK_MASKP9_SHIFT                   (9U)
/*! MASKP9 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP9(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP9_SHIFT)) & GPIO_MASK_MASKP9_MASK)

#define GPIO_MASK_MASKP10_MASK                   (0x400U)
#define GPIO_MASK_MASKP10_SHIFT                  (10U)
/*! MASKP10 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP10(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP10_SHIFT)) & GPIO_MASK_MASKP10_MASK)

#define GPIO_MASK_MASKP11_MASK                   (0x800U)
#define GPIO_MASK_MASKP11_SHIFT                  (11U)
/*! MASKP11 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP11(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP11_SHIFT)) & GPIO_MASK_MASKP11_MASK)

#define GPIO_MASK_MASKP12_MASK                   (0x1000U)
#define GPIO_MASK_MASKP12_SHIFT                  (12U)
/*! MASKP12 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP12(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP12_SHIFT)) & GPIO_MASK_MASKP12_MASK)

#define GPIO_MASK_MASKP13_MASK                   (0x2000U)
#define GPIO_MASK_MASKP13_SHIFT                  (13U)
/*! MASKP13 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP13(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP13_SHIFT)) & GPIO_MASK_MASKP13_MASK)

#define GPIO_MASK_MASKP14_MASK                   (0x4000U)
#define GPIO_MASK_MASKP14_SHIFT                  (14U)
/*! MASKP14 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP14(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP14_SHIFT)) & GPIO_MASK_MASKP14_MASK)

#define GPIO_MASK_MASKP15_MASK                   (0x8000U)
#define GPIO_MASK_MASKP15_SHIFT                  (15U)
/*! MASKP15 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP15(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP15_SHIFT)) & GPIO_MASK_MASKP15_MASK)

#define GPIO_MASK_MASKP16_MASK                   (0x10000U)
#define GPIO_MASK_MASKP16_SHIFT                  (16U)
/*! MASKP16 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP16(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP16_SHIFT)) & GPIO_MASK_MASKP16_MASK)

#define GPIO_MASK_MASKP17_MASK                   (0x20000U)
#define GPIO_MASK_MASKP17_SHIFT                  (17U)
/*! MASKP17 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP17(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP17_SHIFT)) & GPIO_MASK_MASKP17_MASK)

#define GPIO_MASK_MASKP18_MASK                   (0x40000U)
#define GPIO_MASK_MASKP18_SHIFT                  (18U)
/*! MASKP18 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP18(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP18_SHIFT)) & GPIO_MASK_MASKP18_MASK)

#define GPIO_MASK_MASKP19_MASK                   (0x80000U)
#define GPIO_MASK_MASKP19_SHIFT                  (19U)
/*! MASKP19 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP19(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP19_SHIFT)) & GPIO_MASK_MASKP19_MASK)

#define GPIO_MASK_MASKP20_MASK                   (0x100000U)
#define GPIO_MASK_MASKP20_SHIFT                  (20U)
/*! MASKP20 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP20(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP20_SHIFT)) & GPIO_MASK_MASKP20_MASK)

#define GPIO_MASK_MASKP21_MASK                   (0x200000U)
#define GPIO_MASK_MASKP21_SHIFT                  (21U)
/*! MASKP21 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP21(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP21_SHIFT)) & GPIO_MASK_MASKP21_MASK)

#define GPIO_MASK_MASKP22_MASK                   (0x400000U)
#define GPIO_MASK_MASKP22_SHIFT                  (22U)
/*! MASKP22 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP22(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP22_SHIFT)) & GPIO_MASK_MASKP22_MASK)

#define GPIO_MASK_MASKP23_MASK                   (0x800000U)
#define GPIO_MASK_MASKP23_SHIFT                  (23U)
/*! MASKP23 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP23(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP23_SHIFT)) & GPIO_MASK_MASKP23_MASK)

#define GPIO_MASK_MASKP24_MASK                   (0x1000000U)
#define GPIO_MASK_MASKP24_SHIFT                  (24U)
/*! MASKP24 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP24(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP24_SHIFT)) & GPIO_MASK_MASKP24_MASK)

#define GPIO_MASK_MASKP25_MASK                   (0x2000000U)
#define GPIO_MASK_MASKP25_SHIFT                  (25U)
/*! MASKP25 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP25(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP25_SHIFT)) & GPIO_MASK_MASKP25_MASK)

#define GPIO_MASK_MASKP26_MASK                   (0x4000000U)
#define GPIO_MASK_MASKP26_SHIFT                  (26U)
/*! MASKP26 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP26(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP26_SHIFT)) & GPIO_MASK_MASKP26_MASK)

#define GPIO_MASK_MASKP27_MASK                   (0x8000000U)
#define GPIO_MASK_MASKP27_SHIFT                  (27U)
/*! MASKP27 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP27(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP27_SHIFT)) & GPIO_MASK_MASKP27_MASK)

#define GPIO_MASK_MASKP28_MASK                   (0x10000000U)
#define GPIO_MASK_MASKP28_SHIFT                  (28U)
/*! MASKP28 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP28(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP28_SHIFT)) & GPIO_MASK_MASKP28_MASK)

#define GPIO_MASK_MASKP29_MASK                   (0x20000000U)
#define GPIO_MASK_MASKP29_SHIFT                  (29U)
/*! MASKP29 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP29(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP29_SHIFT)) & GPIO_MASK_MASKP29_MASK)

#define GPIO_MASK_MASKP30_MASK                   (0x40000000U)
#define GPIO_MASK_MASKP30_SHIFT                  (30U)
/*! MASKP30 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP30(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP30_SHIFT)) & GPIO_MASK_MASKP30_MASK)

#define GPIO_MASK_MASKP31_MASK                   (0x80000000U)
#define GPIO_MASK_MASKP31_SHIFT                  (31U)
/*! MASKP31 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP31(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP31_SHIFT)) & GPIO_MASK_MASKP31_MASK)
/*! @} */

/* The count of GPIO_MASK */
#define GPIO_MASK_COUNT                          (4U)

/*! @name PIN - Port pin */
/*! @{ */

#define GPIO_PIN_PORT0_MASK                      (0x1U)
#define GPIO_PIN_PORT0_SHIFT                     (0U)
/*! PORT0 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT0(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT0_SHIFT)) & GPIO_PIN_PORT0_MASK)

#define GPIO_PIN_PORT1_MASK                      (0x2U)
#define GPIO_PIN_PORT1_SHIFT                     (1U)
/*! PORT1 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT1(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT1_SHIFT)) & GPIO_PIN_PORT1_MASK)

#define GPIO_PIN_PORT2_MASK                      (0x4U)
#define GPIO_PIN_PORT2_SHIFT                     (2U)
/*! PORT2 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT2(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT2_SHIFT)) & GPIO_PIN_PORT2_MASK)

#define GPIO_PIN_PORT3_MASK                      (0x8U)
#define GPIO_PIN_PORT3_SHIFT                     (3U)
/*! PORT3 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT3(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT3_SHIFT)) & GPIO_PIN_PORT3_MASK)

#define GPIO_PIN_PORT4_MASK                      (0x10U)
#define GPIO_PIN_PORT4_SHIFT                     (4U)
/*! PORT4 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT4(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT4_SHIFT)) & GPIO_PIN_PORT4_MASK)

#define GPIO_PIN_PORT5_MASK                      (0x20U)
#define GPIO_PIN_PORT5_SHIFT                     (5U)
/*! PORT5 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT5(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT5_SHIFT)) & GPIO_PIN_PORT5_MASK)

#define GPIO_PIN_PORT6_MASK                      (0x40U)
#define GPIO_PIN_PORT6_SHIFT                     (6U)
/*! PORT6 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT6(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT6_SHIFT)) & GPIO_PIN_PORT6_MASK)

#define GPIO_PIN_PORT7_MASK                      (0x80U)
#define GPIO_PIN_PORT7_SHIFT                     (7U)
/*! PORT7 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT7(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT7_SHIFT)) & GPIO_PIN_PORT7_MASK)

#define GPIO_PIN_PORT8_MASK                      (0x100U)
#define GPIO_PIN_PORT8_SHIFT                     (8U)
/*! PORT8 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT8(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT8_SHIFT)) & GPIO_PIN_PORT8_MASK)

#define GPIO_PIN_PORT9_MASK                      (0x200U)
#define GPIO_PIN_PORT9_SHIFT                     (9U)
/*! PORT9 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT9(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT9_SHIFT)) & GPIO_PIN_PORT9_MASK)

#define GPIO_PIN_PORT10_MASK                     (0x400U)
#define GPIO_PIN_PORT10_SHIFT                    (10U)
/*! PORT10 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT10(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT10_SHIFT)) & GPIO_PIN_PORT10_MASK)

#define GPIO_PIN_PORT11_MASK                     (0x800U)
#define GPIO_PIN_PORT11_SHIFT                    (11U)
/*! PORT11 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT11(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT11_SHIFT)) & GPIO_PIN_PORT11_MASK)

#define GPIO_PIN_PORT12_MASK                     (0x1000U)
#define GPIO_PIN_PORT12_SHIFT                    (12U)
/*! PORT12 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT12(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT12_SHIFT)) & GPIO_PIN_PORT12_MASK)

#define GPIO_PIN_PORT13_MASK                     (0x2000U)
#define GPIO_PIN_PORT13_SHIFT                    (13U)
/*! PORT13 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT13(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT13_SHIFT)) & GPIO_PIN_PORT13_MASK)

#define GPIO_PIN_PORT14_MASK                     (0x4000U)
#define GPIO_PIN_PORT14_SHIFT                    (14U)
/*! PORT14 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT14(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT14_SHIFT)) & GPIO_PIN_PORT14_MASK)

#define GPIO_PIN_PORT15_MASK                     (0x8000U)
#define GPIO_PIN_PORT15_SHIFT                    (15U)
/*! PORT15 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT15(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT15_SHIFT)) & GPIO_PIN_PORT15_MASK)

#define GPIO_PIN_PORT16_MASK                     (0x10000U)
#define GPIO_PIN_PORT16_SHIFT                    (16U)
/*! PORT16 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT16(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT16_SHIFT)) & GPIO_PIN_PORT16_MASK)

#define GPIO_PIN_PORT17_MASK                     (0x20000U)
#define GPIO_PIN_PORT17_SHIFT                    (17U)
/*! PORT17 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT17(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT17_SHIFT)) & GPIO_PIN_PORT17_MASK)

#define GPIO_PIN_PORT18_MASK                     (0x40000U)
#define GPIO_PIN_PORT18_SHIFT                    (18U)
/*! PORT18 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT18(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT18_SHIFT)) & GPIO_PIN_PORT18_MASK)

#define GPIO_PIN_PORT19_MASK                     (0x80000U)
#define GPIO_PIN_PORT19_SHIFT                    (19U)
/*! PORT19 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT19(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT19_SHIFT)) & GPIO_PIN_PORT19_MASK)

#define GPIO_PIN_PORT20_MASK                     (0x100000U)
#define GPIO_PIN_PORT20_SHIFT                    (20U)
/*! PORT20 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT20(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT20_SHIFT)) & GPIO_PIN_PORT20_MASK)

#define GPIO_PIN_PORT21_MASK                     (0x200000U)
#define GPIO_PIN_PORT21_SHIFT                    (21U)
/*! PORT21 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT21(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT21_SHIFT)) & GPIO_PIN_PORT21_MASK)

#define GPIO_PIN_PORT22_MASK                     (0x400000U)
#define GPIO_PIN_PORT22_SHIFT                    (22U)
/*! PORT22 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT22(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT22_SHIFT)) & GPIO_PIN_PORT22_MASK)

#define GPIO_PIN_PORT23_MASK                     (0x800000U)
#define GPIO_PIN_PORT23_SHIFT                    (23U)
/*! PORT23 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT23(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT23_SHIFT)) & GPIO_PIN_PORT23_MASK)

#define GPIO_PIN_PORT24_MASK                     (0x1000000U)
#define GPIO_PIN_PORT24_SHIFT                    (24U)
/*! PORT24 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT24(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT24_SHIFT)) & GPIO_PIN_PORT24_MASK)

#define GPIO_PIN_PORT25_MASK                     (0x2000000U)
#define GPIO_PIN_PORT25_SHIFT                    (25U)
/*! PORT25 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT25(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT25_SHIFT)) & GPIO_PIN_PORT25_MASK)

#define GPIO_PIN_PORT26_MASK                     (0x4000000U)
#define GPIO_PIN_PORT26_SHIFT                    (26U)
/*! PORT26 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT26(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT26_SHIFT)) & GPIO_PIN_PORT26_MASK)

#define GPIO_PIN_PORT27_MASK                     (0x8000000U)
#define GPIO_PIN_PORT27_SHIFT                    (27U)
/*! PORT27 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT27(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT27_SHIFT)) & GPIO_PIN_PORT27_MASK)

#define GPIO_PIN_PORT28_MASK                     (0x10000000U)
#define GPIO_PIN_PORT28_SHIFT                    (28U)
/*! PORT28 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT28(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT28_SHIFT)) & GPIO_PIN_PORT28_MASK)

#define GPIO_PIN_PORT29_MASK                     (0x20000000U)
#define GPIO_PIN_PORT29_SHIFT                    (29U)
/*! PORT29 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT29(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT29_SHIFT)) & GPIO_PIN_PORT29_MASK)

#define GPIO_PIN_PORT30_MASK                     (0x40000000U)
#define GPIO_PIN_PORT30_SHIFT                    (30U)
/*! PORT30 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT30(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT30_SHIFT)) & GPIO_PIN_PORT30_MASK)

#define GPIO_PIN_PORT31_MASK                     (0x80000000U)
#define GPIO_PIN_PORT31_SHIFT                    (31U)
/*! PORT31 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT31(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT31_SHIFT)) & GPIO_PIN_PORT31_MASK)
/*! @} */

/* The count of GPIO_PIN */
#define GPIO_PIN_COUNT                           (4U)

/*! @name MPIN - Masked Port Pin */
/*! @{ */

#define GPIO_MPIN_MPORTP0_MASK                   (0x1U)
#define GPIO_MPIN_MPORTP0_SHIFT                  (0U)
/*! MPORTP0 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP0(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP0_SHIFT)) & GPIO_MPIN_MPORTP0_MASK)

#define GPIO_MPIN_MPORTP1_MASK                   (0x2U)
#define GPIO_MPIN_MPORTP1_SHIFT                  (1U)
/*! MPORTP1 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP1(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP1_SHIFT)) & GPIO_MPIN_MPORTP1_MASK)

#define GPIO_MPIN_MPORTP2_MASK                   (0x4U)
#define GPIO_MPIN_MPORTP2_SHIFT                  (2U)
/*! MPORTP2 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP2(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP2_SHIFT)) & GPIO_MPIN_MPORTP2_MASK)

#define GPIO_MPIN_MPORTP3_MASK                   (0x8U)
#define GPIO_MPIN_MPORTP3_SHIFT                  (3U)
/*! MPORTP3 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP3(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP3_SHIFT)) & GPIO_MPIN_MPORTP3_MASK)

#define GPIO_MPIN_MPORTP4_MASK                   (0x10U)
#define GPIO_MPIN_MPORTP4_SHIFT                  (4U)
/*! MPORTP4 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP4(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP4_SHIFT)) & GPIO_MPIN_MPORTP4_MASK)

#define GPIO_MPIN_MPORTP5_MASK                   (0x20U)
#define GPIO_MPIN_MPORTP5_SHIFT                  (5U)
/*! MPORTP5 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP5(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP5_SHIFT)) & GPIO_MPIN_MPORTP5_MASK)

#define GPIO_MPIN_MPORTP6_MASK                   (0x40U)
#define GPIO_MPIN_MPORTP6_SHIFT                  (6U)
/*! MPORTP6 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP6(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP6_SHIFT)) & GPIO_MPIN_MPORTP6_MASK)

#define GPIO_MPIN_MPORTP7_MASK                   (0x80U)
#define GPIO_MPIN_MPORTP7_SHIFT                  (7U)
/*! MPORTP7 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP7(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP7_SHIFT)) & GPIO_MPIN_MPORTP7_MASK)

#define GPIO_MPIN_MPORTP8_MASK                   (0x100U)
#define GPIO_MPIN_MPORTP8_SHIFT                  (8U)
/*! MPORTP8 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP8(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP8_SHIFT)) & GPIO_MPIN_MPORTP8_MASK)

#define GPIO_MPIN_MPORTP9_MASK                   (0x200U)
#define GPIO_MPIN_MPORTP9_SHIFT                  (9U)
/*! MPORTP9 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP9(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP9_SHIFT)) & GPIO_MPIN_MPORTP9_MASK)

#define GPIO_MPIN_MPORTP10_MASK                  (0x400U)
#define GPIO_MPIN_MPORTP10_SHIFT                 (10U)
/*! MPORTP10 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP10(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP10_SHIFT)) & GPIO_MPIN_MPORTP10_MASK)

#define GPIO_MPIN_MPORTP11_MASK                  (0x800U)
#define GPIO_MPIN_MPORTP11_SHIFT                 (11U)
/*! MPORTP11 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP11(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP11_SHIFT)) & GPIO_MPIN_MPORTP11_MASK)

#define GPIO_MPIN_MPORTP12_MASK                  (0x1000U)
#define GPIO_MPIN_MPORTP12_SHIFT                 (12U)
/*! MPORTP12 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP12(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP12_SHIFT)) & GPIO_MPIN_MPORTP12_MASK)

#define GPIO_MPIN_MPORTP13_MASK                  (0x2000U)
#define GPIO_MPIN_MPORTP13_SHIFT                 (13U)
/*! MPORTP13 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP13(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP13_SHIFT)) & GPIO_MPIN_MPORTP13_MASK)

#define GPIO_MPIN_MPORTP14_MASK                  (0x4000U)
#define GPIO_MPIN_MPORTP14_SHIFT                 (14U)
/*! MPORTP14 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP14(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP14_SHIFT)) & GPIO_MPIN_MPORTP14_MASK)

#define GPIO_MPIN_MPORTP15_MASK                  (0x8000U)
#define GPIO_MPIN_MPORTP15_SHIFT                 (15U)
/*! MPORTP15 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP15(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP15_SHIFT)) & GPIO_MPIN_MPORTP15_MASK)

#define GPIO_MPIN_MPORTP16_MASK                  (0x10000U)
#define GPIO_MPIN_MPORTP16_SHIFT                 (16U)
/*! MPORTP16 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP16(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP16_SHIFT)) & GPIO_MPIN_MPORTP16_MASK)

#define GPIO_MPIN_MPORTP17_MASK                  (0x20000U)
#define GPIO_MPIN_MPORTP17_SHIFT                 (17U)
/*! MPORTP17 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP17(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP17_SHIFT)) & GPIO_MPIN_MPORTP17_MASK)

#define GPIO_MPIN_MPORTP18_MASK                  (0x40000U)
#define GPIO_MPIN_MPORTP18_SHIFT                 (18U)
/*! MPORTP18 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP18(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP18_SHIFT)) & GPIO_MPIN_MPORTP18_MASK)

#define GPIO_MPIN_MPORTP19_MASK            