/*--------------------------------------------------------------------------*/
/* Copyright 2020-2021 NXP                                                  */
/*                                                                          */
/* NXP Confidential. This software is owned or controlled by NXP and may    */
/* only be used strictly in accordance with the applicable license terms.   */
/* By expressly accepting such terms or by downloading, installing,         */
/* activating and/or otherwise using the software, you are agreeing that    */
/* you have read, and that you agree to comply with and are bound by, such  */
/* license terms. If you do not agree to be bound by the applicable license */
/* terms, then you may not retain, install, activate or otherwise use the   */
/* software.                                                                */
/*--------------------------------------------------------------------------*/

/**
 * @file  mcuxCsslFlowProtection_FunctionIdentifiers.h
 * @brief Definition of function identifiers for the flow protection mechanism.
 *
 * @note This file might be post-processed to update the identifier values to
 * proper/secure values.
 */

#ifndef MCUX_CSSL_FLOW_PROTECTION_FUNCTION_IDENTIFIERS_H_
#define MCUX_CSSL_FLOW_PROTECTION_FUNCTION_IDENTIFIERS_H_

/* START of function identifier list */
/* Flow Protection example values: */
#define MCUX_CSSL_FP_FUNCID_functionOnly0                 (0x7692u)
#define MCUX_CSSL_FP_FUNCID_functionOnly1                 (0x7AB0u)
#define MCUX_CSSL_FP_FUNCID_functionOnly2                 (0x7A1Au)
#define MCUX_CSSL_FP_FUNCID_functionCall                  (0x3CAAu)
#define MCUX_CSSL_FP_FUNCID_functionCalls                 (0x26F8u)
#define MCUX_CSSL_FP_FUNCID_functionLoop                  (0x471Bu)
#define MCUX_CSSL_FP_FUNCID_functionBranch                (0x1F92u)
#define MCUX_CSSL_FP_FUNCID_functionSwitch                (0x5C47u)
#define MCUX_CSSL_FP_FUNCID_functionComplex               (0x678Cu)
#define MCUX_CSSL_FP_FUNCID_data_invariant_memory_compare (0x678Du)
#define MCUX_CSSL_FP_FUNCID_data_invariant_memory_copy    (0x678Eu)

/* Values for production use: */
#define MCUX_CSSL_FP_FUNCID_mcuxCsslParamIntegrity_Validate                       (0x6533u)
#define MCUX_CSSL_FP_FUNCID_mcuxCsslMemory_Compare                                (0x7A0Du)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_GetHwVersion                                (0x6366u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_GetHwConfig                                 (0x4C37u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_GetHwState                                  (0x7907u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_Enable_Async                                (0x44DDu)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_Reset_Async                                 (0x5457u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_Disable                                     (0x466Eu)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_SetIntEnableFlags                           (0x0DB6u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_GetIntEnableFlags                           (0x4E2Eu)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_ResetIntFlags                               (0x0FB2u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_SetIntFlags                                 (0x55CCu)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_WaitForOperation                            (0x34B9u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_LimitedWaitForOperation                     (0x6CE4u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_ResetErrorFlags                             (0x710Fu)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_GetErrorCode                                (0x7456u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_GetErrorLevel                               (0x59D2u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_Hash_Async                                  (0x59D8u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_ShaDirect_Enable                            (0x496Bu)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_ShaDirect_Disable                           (0x23CBu)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_Hash_ShaDirect                              (0x7C29u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_Cipher_Async                                (0x13D5u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_EccKeyGen_Async                             (0x2E95u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_EccKeyExchange_Async                        (0x5762u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_EccKeyExchangeInt_Async                     (0x555Cu)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_EccSign_Async                               (0x3C36u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_EccVerify_Async                             (0x5B0Bu)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_EccVerifyInt_Async                          (0x62ADu)
#define MCUX_CSSL_FP_FUNCID_mcuxClMath_SecModExp                                  (0x5578u)
#define MCUX_CSSL_FP_FUNCID_mcuxClMath_SecModExp_SqrMultAws                       (0x067Bu)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_Aead_Init_Async                             (0x607Eu)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_Aead_PartialInit_Async                      (0x035Fu)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_Aead_UpdateAad_Async                        (0x0F59u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_Aead_UpdateData_Async                       (0x2E9Cu)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_Aead_Finalize_Async                         (0x2DA9u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_Cmac_Async                                  (0x1793u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_GlitchDetector_LoadConfig_Async             (0x693Cu)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_GlitchDetector_Trim_Async                   (0x09BEu)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_Hmac_Async                                  (0x4BE1u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_Hkdf_Rfc5869_Async                          (0x5B92u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_Ckdf_Sp800108_Async                         (0x27A5u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_TlsGenerateMasterKeyFromPreMasterKey_Async  (0x3F84u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_TlsGenerateSessionKeysFromMasterKey_Async   (0x7545u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_KeyDelete_Async                             (0x58F2u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_KeyProvision_Async                          (0x5ED0u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_KeyProvisionRom_Async                       (0x64B3u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_KeyImport_Async                             (0x1397u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_KeyImportPuk_Async                          (0x2CAEu)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_KeyExport_Async                             (0x258Fu)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_Rng_DrbgRequest_Async                       (0x4D9Cu)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_Rng_DrbgRequestRaw_Async                    (0x62D9u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_Rng_Dtrng_ConfigLoad_Async                  (0x2756u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_Rng_Dtrng_ConfigEvaluate_Async              (0x62E9u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_Prng_Init_Async                             (0x3BC4u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_Prng_GetRandomWord                          (0x3AC6u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_Prng_GetRandom                              (0x49D3u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_GetKeyProperties                            (0x7E14u)
#define MCUX_CSSL_FP_FUNCID_mcuxClHash_compute                                    (0x2DAAu)
#define MCUX_CSSL_FP_FUNCID_mcuxClHash_skeletonSha2                               (0x4E33u)
#define MCUX_CSSL_FP_FUNCID_mcuxClHash_algoEngineSha2                             (0x195Du)
#define MCUX_CSSL_FP_FUNCID_mcuxClHash_algoEngineSha2_direct                      (0x4EACu)
#define MCUX_CSSL_FP_FUNCID_mcuxClHash_dmaProtectionAddressReadback               (0x5C71u)
#define MCUX_CSSL_FP_FUNCID_mcuxClKey_loadCopro                                   (0x2579u)
#define MCUX_CSSL_FP_FUNCID_mcuxClKey_loadMemory                                  (0x7962u)
#define MCUX_CSSL_FP_FUNCID_mcuxClKey_flush                                       (0x26ECu)
#define MCUX_CSSL_FP_FUNCID_mcuxClKey_setKeyproperties                            (0x3879u)
#define MCUX_CSSL_FP_FUNCID_mcuxClKey_LoadFuncPtr_t                               (0x55C9u)
#define MCUX_CSSL_FP_FUNCID_mcuxClKey_FlushFuncPtr_t                              (0x476Cu)
#define MCUX_CSSL_FP_FUNCID_mcuxClKey_init                                        (0x3635u)
#define MCUX_CSSL_FP_FUNCID_mcuxClMac_compute                                     (0x22F9u)
#define MCUX_CSSL_FP_FUNCID_mcuxClMac_init                                        (0x16EAu)
#define MCUX_CSSL_FP_FUNCID_mcuxClMac_process                                     (0x5CB1u)
#define MCUX_CSSL_FP_FUNCID_mcuxClMac_finish                                      (0x4D59u)
#define MCUX_CSSL_FP_FUNCID_mcuxClMath_InitLocalUptrt                             (0x6762u)
#define MCUX_CSSL_FP_FUNCID_mcuxClMath_LeadingZeros                               (0x0DE5u)
#define MCUX_CSSL_FP_FUNCID_mcuxClMath_ShiftModulus                               (0x63E2u)
#define MCUX_CSSL_FP_FUNCID_mcuxClMath_NDash                                      (0x236Du)
#define MCUX_CSSL_FP_FUNCID_mcuxClMath_QDash                                      (0x60BBu)
#define MCUX_CSSL_FP_FUNCID_mcuxClMath_QSquared                                   (0x197Au)
#define MCUX_CSSL_FP_FUNCID_mcuxClMath_ModInv                                     (0x48DDu)
#define MCUX_CSSL_FP_FUNCID_mcuxClMath_ModExp_SqrMultL2R                          (0x791Cu)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_Rng_DrbgTestInstantiate_Async               (0x5C27u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_Rng_DrbgTestExtract_Async                   (0x2E9Au)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_Rng_DrbgTestAesEcb_Async                    (0x0B97u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_Rng_DrbgTestAesCtr_Async                    (0x743Au)
#define MCUX_CSSL_FP_FUNCID_mcuxClMemory_clear                                    (0x6BC8u)
#define MCUX_CSSL_FP_FUNCID_mcuxClMemory_copy                                     (0x126Fu)
#define MCUX_CSSL_FP_FUNCID_mcuxClMemory_set                                      (0x6AA6u)
#define MCUX_CSSL_FP_FUNCID_mcuxClPkc_Initialize                                  (0x7319u)
#define MCUX_CSSL_FP_FUNCID_mcuxClPkc_Deinitialize                                (0x7315u)
#define MCUX_CSSL_FP_FUNCID_mcuxClPkc_GenerateUPTRT                               (0x1C5Bu)
#define MCUX_CSSL_FP_FUNCID_mcuxClPkc_Calc                                        (0x152Fu)
#define MCUX_CSSL_FP_FUNCID_mcuxClPkc_CalcConst                                   (0x6693u)
#define MCUX_CSSL_FP_FUNCID_mcuxClPkc_CalcFup                                     (0x2B71u)
#define MCUX_CSSL_FP_FUNCID_mcuxClPkc_WaitForFinish                               (0x255Bu)
#define MCUX_CSSL_FP_FUNCID_mcuxClPkc_WaitForReady                                (0x05AFu)
#define MCUX_CSSL_FP_FUNCID_mcuxClSession_init                                    (0x58B5u)
#define MCUX_CSSL_FP_FUNCID_mcuxClSession_setRtf                                  (0x057Bu)
#define MCUX_CSSL_FP_FUNCID_mcuxClSession_cleanup                                 (0x2CD3u)
#define MCUX_CSSL_FP_FUNCID_mcuxClSession_destroy                                 (0x6A4Bu)
#define MCUX_CSSL_FP_FUNCID_nboot_selftest_sha512                                (0x6E2Cu)
#define MCUX_CSSL_FP_FUNCID_nboot_selftest_aead                                  (0x4D4Du)
#define MCUX_CSSL_FP_FUNCID_nboot_selftest_ecdsa_p256                            (0x1769u)
#define MCUX_CSSL_FP_FUNCID_nboot_selftest_ecdsa_p384                            (0x7526u)
#define MCUX_CSSL_FP_FUNCID_nboot_selftest_hmac                                  (0x7067u)
#define MCUX_CSSL_FP_FUNCID_nboot_selftest_eckxh                                 (0x2D36u)
#define MCUX_CSSL_FP_FUNCID_nboot_selftest_drbg_extract                          (0x61ABu)
#define MCUX_CSSL_FP_FUNCID_nboot_selftest_drbg_ctr                              (0x3E64u)
#define MCUX_CSSL_FP_FUNCID_nboot_selftest_drbg_ecb                              (0x415Fu)
#define MCUX_CSSL_FP_FUNCID_nboot_selftest_ckdf                                  (0x3E83u)
#define MCUX_CSSL_FP_FUNCID_nboot_selftest_hkdf                                  (0x4E2Du)
#define MCUX_CSSL_FP_FUNCID_nboot_selftest                                       (0x4F58u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_Ckdf_Sp80056c_Extract_Async                 (0x1F23u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_Ckdf_Sp80056c_Expand_Async                  (0x7427u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_Hkdf_Sp80056c_Async                         (0x307Du)
#define MCUX_CSSL_FP_FUNCID_mcuxClTrustProv_keyProv                               (0x59AAu)
#define MCUX_CSSL_FP_FUNCID_mcuxCLTrustProv_nboot_isp_get_oem_cust_cert_dice_puk  (0x436Eu)
#define MCUX_CSSL_FP_FUNCID_mcuxCLTrustProv_nboot_isp_hsm_eck_sign                (0x1F89u)
#define MCUX_CSSL_FP_FUNCID_mcuxCLTrustProv_nboot_isp_hsm_enc_blk                 (0x7C43u)
#define MCUX_CSSL_FP_FUNCID_mcuxCLTrustProv_nboot_isp_hsm_key_gen                 (0x653Cu)
#define MCUX_CSSL_FP_FUNCID_mcuxCLTrustProv_nboot_sb_store_key                    (0x75E0u)
#define MCUX_CSSL_FP_FUNCID_mcuxCLTrustProv_nboot_isp_mcux_rts_get_id_clns         (0x5935u)
#define MCUX_CSSL_FP_FUNCID_mcuxCLTrustProv_nboot_isp_gen_oem_master_share        (0x5D83u)
#define MCUX_CSSL_FP_FUNCID_mcuxCLTrustProv_nboot_isp_set_oem_master_share        (0x7D50u)
#define MCUX_CSSL_FP_FUNCID_mcuxCLTrustProv_nboot_isp_hsm_store_key               (0x1AADu)
#define MCUX_CSSL_FP_FUNCID_mcuxClTrustProv_rfc3394_wrap_manual                   (0x6B70u)
#define MCUX_CSSL_FP_FUNCID_mcuxCLTrustProv_nboot_isp_mcux_ssf_insert_cert         (0x15E6u)
#define MCUX_CSSL_FP_FUNCID_mcuxClEcc_Verify_P384                                 (0x155Du)
#define MCUX_CSSL_FP_FUNCID_nboot_img_authenticate_cmac                          (0x3E34u)
#define MCUX_CSSL_FP_FUNCID_nboot_key_delete                                     (0x29DAu)
#define MCUX_CSSL_FP_FUNCID_nboot_key_store_export_key                           (0x6A4Eu)
#define MCUX_CSSL_FP_FUNCID_nboot_key_store_is_loaded                            (0x7744u)
#define MCUX_CSSL_FP_FUNCID_nboot_key_store_init                                 (0x32BCu)
#define MCUX_CSSL_FP_FUNCID_nboot_key_store_generate_rom_key                     (0x259Du)
#define MCUX_CSSL_FP_FUNCID_nboot_cmac_authenticate_romapi                       (0x4CB5u)
#define MCUX_CSSL_FP_FUNCID_nboot_sb3_load_manifest                              (0x76C4u)
#define MCUX_CSSL_FP_FUNCID_nboot_sb3_load_block                                 (0x36E4u)
#define MCUX_CSSL_FP_FUNCID_mcuxClSb3_BlockVerify                                 (0x1BA9u)
#define MCUX_CSSL_FP_FUNCID_mcuxClSb3_BlockDecrypt_Start                          (0x238Fu)
#define MCUX_CSSL_FP_FUNCID_mcuxClSb3_BlockEncrypt_Start                          (0x785Au)
#define MCUX_CSSL_FP_FUNCID_mcuxClSb3_BlockCrypt_Finish                           (0x478Bu)
#define MCUX_CSSL_FP_FUNCID_mcuxClSb3_BlockDeriveKey                              (0x54EAu)
#define MCUX_CSSL_FP_FUNCID_mcuxClSb3_ManifestImportPck                           (0x437Au)
#define MCUX_CSSL_FP_FUNCID_mcuxClSb3_ManifestDeriveKdk                           (0x732Cu)
#define MCUX_CSSL_FP_FUNCID_mcuxClSb3_DeletePck                                   (0x5A5Au)
#define MCUX_CSSL_FP_FUNCID_mcuxClSb3_Cleanup                                     (0x4ED8u)
#define MCUX_CSSL_FP_FUNCID_nboot_img_authenticate_ecdsa                         (0x6E62u)
#define MCUX_CSSL_FP_FUNCID_nboot_img_authenticate_ecdsa_romapi                  (0x2D99u)
#define MCUX_CSSL_FP_FUNCID_nboot_sb3_img_authenticate_ecdsa                     (0x5AC6u)
#define MCUX_CSSL_FP_FUNCID_nboot_img_authenticate_ecdsa_internal                (0x4E65u)
#define MCUX_CSSL_FP_FUNCID_mcuxClKey_protect_fct_none                            (0x5A4Bu)
#define MCUX_CSSL_FP_FUNCID_mcuxClKey_protect_fct_ckdf                            (0x588Fu)
#define MCUX_CSSL_FP_FUNCID_mcuxClKey_flush_fct_none                              (0x05BEu)
#define MCUX_CSSL_FP_FUNCID_mcuxClKey_flush_fct_memory                            (0x10EFu)
#define MCUX_CSSL_FP_FUNCID_mcuxClKey_flush_fct_css                               (0x58B6u)
#define MCUX_CSSL_FP_FUNCID_mcuxClMac_Engine_CMAC_Oneshot                         (0x15E6u)
#define MCUX_CSSL_FP_FUNCID_mcuxClMac_Engine_CMAC_Init                            (0x528Fu)
#define MCUX_CSSL_FP_FUNCID_mcuxClMac_Engine_CMAC_Update                          (0x475Cu)
#define MCUX_CSSL_FP_FUNCID_mcuxClMac_Engine_CMAC_Finalize                        (0x7295u)
#define MCUX_CSSL_FP_FUNCID_mcuxClMac_Engine_HMAC_Init                            (0x72C5u)
#define MCUX_CSSL_FP_FUNCID_mcuxClMac_Engine_HMAC_Update                          (0x7711u)
#define MCUX_CSSL_FP_FUNCID_mcuxClMac_Engine_HMAC_Finalize                        (0x4AD6u)
#define MCUX_CSSL_FP_FUNCID_mcuxClMac_Engine_HMAC_Oneshot                         (0x4C67u)
#define MCUX_CSSL_FP_FUNCID_mcuxClEcc_Interleave                                  (0x28DEu)
#define MCUX_CSSL_FP_FUNCID_mcuxClEcc_RepeatPointDouble_NIST                      (0x4EB4u)
#define MCUX_CSSL_FP_FUNCID_mcuxClEcc_Int_PointMult_NIST                          (0x3672u)
#define MCUX_CSSL_FP_FUNCID_mcuxClEcc_PointCheckAffineNR_NIST                     (0x05E7u)
#define MCUX_CSSL_FP_FUNCID_mcuxClEcc_PointFullAdd_NIST                           (0x629Bu)
#define MCUX_CSSL_FP_FUNCID_mcuxClEcc_SwitchEndianness_P384                       (0x7C8Au)
#define MCUX_CSSL_FP_FUNCID_mcuxCLTrustProv_nboot_rts_insert_cert                 (0x0EBAu)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_SetRandomStartDelay                         (0x134Fu)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_GetRandomStartDelay                         (0x51C7u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_GetLock                                     (0x4AE6u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_ReleaseLock                                 (0x61D3u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_IsLocked                                    (0x646Eu)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_SetMasterUnlock                             (0x30B7u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_ConfigureCommandCRC                         (0x4CF1u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_GetCommandCRC                               (0x0B9Bu)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_RespGen_Async                               (0x7256u)
#define MCUX_CSSL_FP_FUNCID_mcuxClPkc_ImportBigEndianToPkc                        (0x5F30u)
#define MCUX_CSSL_FP_FUNCID_mcuxClPkc_ExportBigEndianFromPkc                      (0x3D1Cu)
#define MCUX_CSSL_FP_FUNCID_mcuxClEcc_Verify                                      (0x5CA5u)
#define MCUX_CSSL_FP_FUNCID_mcuxClPkc_SwitchEndianness                            (0x36A9u)
#define MCUX_CSSL_FP_FUNCID_mcuxClEcc_PointCheckAffineNR                          (0x65ACu)
#define MCUX_CSSL_FP_FUNCID_mcuxClEcc_RepeatPointDouble                           (0x7986u)
#define MCUX_CSSL_FP_FUNCID_mcuxClEcc_PointFullAdd                                (0x10FEu)
#define MCUX_CSSL_FP_FUNCID_mcuxClEcc_Int_PointMult                               (0x59B4u)
#define MCUX_CSSL_FP_FUNCID_mcuxClPkc_RandomizeUPTRT                              (0x1D87u)
#define MCUX_CSSL_FP_FUNCID_mcuxClPkc_ReRandomizeUPTRT                            (0x5E54u)
#define MCUX_CSSL_FP_FUNCID_mcuxClEcc_SecurePointMult                             (0x03BDu)
#define MCUX_CSSL_FP_FUNCID_mcuxClHash_skeletonSha2_streaming                     (0x73B0u)
#define MCUX_CSSL_FP_FUNCID_mcuxClHash_init                                       (0x416Fu)
#define MCUX_CSSL_FP_FUNCID_mcuxClHash_update                                     (0x5873u)
#define MCUX_CSSL_FP_FUNCID_mcuxClHash_finish                                     (0x17D8u)
#define MCUX_CSSL_FP_FUNCID_mcuxClRoPuf_GetHwVersion                              (0x0CCFu)
#define MCUX_CSSL_FP_FUNCID_mcuxClRoPuf_GetHwState                                (0x0B57u)
#define MCUX_CSSL_FP_FUNCID_mcuxClRoPuf_SetIntEnableFlags                         (0x176Au)
#define MCUX_CSSL_FP_FUNCID_mcuxClRoPuf_GetIntEnableFlags                         (0x346Bu)
#define MCUX_CSSL_FP_FUNCID_mcuxClRoPuf_ResetIntFlags                             (0x3E29u)
#define MCUX_CSSL_FP_FUNCID_mcuxClRoPuf_SetIntFlags                               (0x5D2Au)
#define MCUX_CSSL_FP_FUNCID_mcuxClRoPuf_Configuration                             (0x4EE2u)
#define MCUX_CSSL_FP_FUNCID_mcuxClRoPuf_Lock                                      (0x1177u)
#define MCUX_CSSL_FP_FUNCID_mcuxClRoPuf_ConfigEval                                (0x28EEu)
#define MCUX_CSSL_FP_FUNCID_mcuxClRoPuf_Enroll                                    (0x31B6u)
#define MCUX_CSSL_FP_FUNCID_mcuxClRoPuf_Reconstruct                               (0x3C9Au)
#define MCUX_CSSL_FP_FUNCID_mcuxClRoPuf_KeyGeneration                             (0x3EC8u)
#define MCUX_CSSL_FP_FUNCID_mcuxClRoPuf_GetIntFlags                               (0x6AD4u)
#define MCUX_CSSL_FP_FUNCID_mcuxClSb3_img_authenticate_ecdsa                      (0x788Bu)
#define MCUX_CSSL_FP_FUNCID_mcuxCLTrustProv_nboot_isp_dev_set_wrap_data           (0x5369u)
#define MCUX_CSSL_FP_FUNCID_mcuxCLTrustProv_nboot_isp_hsm_dev_auth_challenge      (0x4A6Du)
#define MCUX_CSSL_FP_FUNCID_mcuxCLTrustProv_nboot_isp_hsm_dev_auth_challenge_mcux  (0x48D7u)
#define MCUX_CSSL_FP_FUNCID_mcuxCLTrustProv_nboot_isp_hsm_dev_auth_challenge_oem  (0x12FCu)
#define MCUX_CSSL_FP_FUNCID_mcuxClMath_TrailingZeros                              (0x037Eu)
#define MCUX_CSSL_FP_FUNCID_mcuxClMath_ReduceModEven                              (0x235Eu)
#define MCUX_CSSL_FP_FUNCID_mcuxClEcc_KeyGen                                      (0x6726u)
#define MCUX_CSSL_FP_FUNCID_mcuxClPkc_SecureExportBigEndianFromPkc                (0x19E6u)
#define MCUX_CSSL_FP_FUNCID_mcuxClEcc_Int_CoreKeyGen                              (0x5C87u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_GlitchDetector_ResetEventCounter            (0x14EBu)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_GlitchDetector_GetEventCounter              (0x2D72u)
#define MCUX_CSSL_FP_FUNCID_mcuxClPkc_SecureImportBigEndianToPkc                  (0x271Du)
#define MCUX_CSSL_FP_FUNCID_mcuxClEcc_Sign                                        (0x59A3u)
#define MCUX_CSSL_FP_FUNCID_mcuxClEcc_PointMult                                   (0x5AD2u)
#define MCUX_CSSL_FP_FUNCID_mcuxClRsa_public                                      (0x7469u)
#define MCUX_CSSL_FP_FUNCID_mcuxClRsa_privatePlain                                (0x0E7Au)
#define MCUX_CSSL_FP_FUNCID_mcuxClRsa_verify                                      (0x2D78u)
#define MCUX_CSSL_FP_FUNCID_mcuxClRsa_noVerify                                    (0x689Eu)
#define MCUX_CSSL_FP_FUNCID_mcuxClRsa_pkcs1v15Encode                              (0x50DBu)
#define MCUX_CSSL_FP_FUNCID_mcuxClRsa_pkcs1v15Verify                              (0x270Fu)
#define MCUX_CSSL_FP_FUNCID_mcuxCsslMemory_Copy                                   (0x5AA6u)
#define MCUX_CSSL_FP_FUNCID_mcuxCsslMemory_Clear                                  (0x4E36u)
#define MCUX_CSSL_FP_FUNCID_mcuxClMath_ExactDivideOdd                             (0x509Fu)
#define MCUX_CSSL_FP_FUNCID_mcuxClRsa_pssVerify                                   (0x69B2u)
#define MCUX_CSSL_FP_FUNCID_mcuxClRsa_mgf1                                        (0x7878u)
#define MCUX_CSSL_FP_FUNCID_mcuxClRsa_privateCRT                                  (0x69D2u)
#define MCUX_CSSL_FP_FUNCID_mcuxClRsa_sign                                        (0x1C7Cu)
#define MCUX_CSSL_FP_FUNCID_mcuxClRsa_noEncode                                    (0x758Cu)
#define MCUX_CSSL_FP_FUNCID_mcuxClRsa_pssEncode                                   (0x3C66u)
#define MCUX_CSSL_FP_FUNCID_mcuxClEcc_SetupEnvironment                            (0x318Fu)
#define MCUX_CSSL_FP_FUNCID_mcuxClEcc_Mont_DhSetupEnvironment                     (0x6A39u)
#define MCUX_CSSL_FP_FUNCID_mcuxClEcc_Mont_SecureScalarMult_XZMontLadder          (0x4D55u)
#define MCUX_CSSL_FP_FUNCID_mcuxClEcc_Mont_DhX                                    (0x147Du)
#define MCUX_CSSL_FP_FUNCID_mcuxClEcc_Mont_DhDecodeScalar                         (0x5197u)
#define MCUX_CSSL_FP_FUNCID_mcuxClEcc_Mont_DhDecodeCoordinate                     (0x44F5u)
#define MCUX_CSSL_FP_FUNCID_mcuxClEcc_GenerateMultiplicativeBlinding              (0x03BEu)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_GetLastDmaAddress                           (0x3E51u)
#define MCUX_CSSL_FP_FUNCID_mcuxClCss_CompareDmaFinalOutputAddress                (0x6A3Cu)
#define MCUX_CSSL_FP_FUNCID_mcuxCsslMemory_Set                                    (0x24F3u)
#define MCUX_CSSL_FP_FUNCID_mcuxClEcc_Mont_DhKeyAgreement                         (0x6933u)
#define MCUX_CSSL_FP_FUNCID_mcuxClEcc_Mont_DhKeyGeneration                        (0x097Eu)
#define MCUX_CSSL_FP_FUNCID_mcuxClMath_ExactDivide                                (0x3CE4u)
#define MCUX_CSSL_FP_FUNCID_mcuxClRandom_init                                     (0x456Eu)
#define MCUX_CSSL_FP_FUNCID_mcuxClRandom_reseed                                   (0x4CE9u)
#define MCUX_CSSL_FP_FUNCID_mcuxClRandom_generate                                 (0x7D28u)
#define MCUX_CSSL_FP_FUNCID_mcuxClRandom_uninit                                   (0x41FCu)
#define MCUX_CSSL_FP_FUNCID_mcuxClRandom_selftest                                 (0x51E5u)
#define MCUX_CSSL_FP_FUNCID_mcuxClRandom_checkSecurityStrength                    (0x3B13u)
#define MCUX_CSSL_FP_FUNCID_mcuxClRandom_ncInit                                   (0x4E8Bu)
#define MCUX_CSSL_FP_FUNCID_mcuxClRandom_ncGenerate                               (0x20DFu)
#define MCUX_CSSL_FP_FUNCID_mcuxClRandom_CTR_DRBG_CSS_generate                    (0x246Fu)
#define MCUX_CSSL_FP_FUNCID_mcuxClRsa_TestPQDistance                              (0x345Bu)
#define MCUX_CSSL_FP_FUNCID_unused_0x0FE    (0x178Eu)
#define MCUX_CSSL_FP_FUNCID_unused_0x0FF    (0x5F42u)
#define MCUX_CSSL_FP_FUNCID_unused_0x101    (0x6A36u)
#define MCUX_CSSL_FP_FUNCID_unused_0x102    (0x53F0u)
#define MCUX_CSSL_FP_FUNCID_unused_0x103    (0x1ACEu)
#define MCUX_CSSL_FP_FUNCID_unused_0x107    (0x5F12u)
#define MCUX_CSSL_FP_FUNCID_unused_0x108    (0x275Cu)
#define MCUX_CSSL_FP_FUNCID_unused_0x10A    (0x05B7u)
#define MCUX_CSSL_FP_FUNCID_unused_0x10B    (0x5AA9u)
#define MCUX_CSSL_FP_FUNCID_unused_0x10C    (0x075Bu)
#define MCUX_CSSL_FP_FUNCID_unused_0x10D    (0x61B9u)
#define MCUX_CSSL_FP_FUNCID_unused_0x10E    (0x5C17u)
#define MCUX_CSSL_FP_FUNCID_unused_0x10F    (0x6D1Au)
#define MCUX_CSSL_FP_FUNCID_unused_0x110    (0x1BB2u)
#define MCUX_CSSL_FP_FUNCID_unused_0x111    (0x7683u)
#define MCUX_CSSL_FP_FUNCID_unused_0x112    (0x61E6u)
#define MCUX_CSSL_FP_FUNCID_unused_0x113    (0x60EEu)
#define MCUX_CSSL_FP_FUNCID_unused_0x114    (0x46B3u)
#define MCUX_CSSL_FP_FUNCID_unused_0x115    (0x61B6u)
#define MCUX_CSSL_FP_FUNCID_unused_0x116    (0x64F8u)
#define MCUX_CSSL_FP_FUNCID_unused_0x117    (0x16E6u)
#define MCUX_CSSL_FP_FUNCID_unused_0x118    (0x6F09u)
#define MCUX_CSSL_FP_FUNCID_unused_0x119    (0x58AEu)
#define MCUX_CSSL_FP_FUNCID_unused_0x11A    (0x0BDAu)
#define MCUX_CSSL_FP_FUNCID_unused_0x11B    (0x36C5u)
#define MCUX_CSSL_FP_FUNCID_unused_0x11C    (0x70B5u)
#define MCUX_CSSL_FP_FUNCID_unused_0x11D    (0x2C9Eu)
#define MCUX_CSSL_FP_FUNCID_unused_0x11E    (0x5F41u)
#define MCUX_CSSL_FP_FUNCID_unused_0x11F    (0x5786u)
#define MCUX_CSSL_FP_FUNCID_unused_0x120    (0x6734u)
#define MCUX_CSSL_FP_FUNCID_unused_0x121    (0x529Eu)
#define MCUX_CSSL_FP_FUNCID_unused_0x122    (0x33C9u)
#define MCUX_CSSL_FP_FUNCID_unused_0x123    (0x15BAu)
#define MCUX_CSSL_FP_FUNCID_unused_0x124    (0x21BEu)
#define MCUX_CSSL_FP_FUNCID_unused_0x125    (0x6D0Eu)
#define MCUX_CSSL_FP_FUNCID_unused_0x126    (0x6731u)
#define MCUX_CSSL_FP_FUNCID_unused_0x127    (0x19D6u)
#define MCUX_CSSL_FP_FUNCID_unused_0x128    (0x68BAu)
#define MCUX_CSSL_FP_FUNCID_unused_0x129    (0x6EA1u)
#define MCUX_CSSL_FP_FUNCID_unused_0x12A    (0x3E89u)
#define MCUX_CSSL_FP_FUNCID_unused_0x12B    (0x3BA8u)
#define MCUX_CSSL_FP_FUNCID_unused_0x12C    (0x34E5u)
#define MCUX_CSSL_FP_FUNCID_unused_0x12D    (0x5A1Eu)
#define MCUX_CSSL_FP_FUNCID_unused_0x12E    (0x41E7u)
#define MCUX_CSSL_FP_FUNCID_unused_0x12F    (0x14DBu)
#define MCUX_CSSL_FP_FUNCID_unused_0x130    (0x73D0u)
#define MCUX_CSSL_FP_FUNCID_unused_0x131    (0x7196u)
#define MCUX_CSSL_FP_FUNCID_unused_0x132    (0x52D3u)
#define MCUX_CSSL_FP_FUNCID_unused_0x133    (0x076Du)
#define MCUX_CSSL_FP_FUNCID_unused_0x134    (0x23B5u)
#define MCUX_CSSL_FP_FUNCID_unused_0x135    (0x3974u)
#define MCUX_CSSL_FP_FUNCID_unused_0x136    (0x334Eu)
#define MCUX_CSSL_FP_FUNCID_unused_0x137    (0x3B46u)
#define MCUX_CSSL_FP_FUNCID_unused_0x138    (0x3B2Au)
#define MCUX_CSSL_FP_FUNCID_unused_0x139    (0x3D38u)
#define MCUX_CSSL_FP_FUNCID_unused_0x13A    (0x2D6Au)
#define MCUX_CSSL_FP_FUNCID_unused_0x13B    (0x43F4u)
#define MCUX_CSSL_FP_FUNCID_unused_0x13C    (0x15DAu)
#define MCUX_CSSL_FP_FUNCID_unused_0x13D    (0x517Cu)
#define MCUX_CSSL_FP_FUNCID_unused_0x13E    (0x42FAu)
#define MCUX_CSSL_FP_FUNCID_unused_0x13F    (0x447Bu)
#define MCUX_CSSL_FP_FUNCID_unused_0x140    (0x54BAu)
#define MCUX_CSSL_FP_FUNCID_unused_0x141    (0x45E3u)
#define MCUX_CSSL_FP_FUNCID_unused_0x142    (0x7E84u)
#define MCUX_CSSL_FP_FUNCID_unused_0x143    (0x6D8Cu)
#define MCUX_CSSL_FP_FUNCID_unused_0x144    (0x35A9u)
#define MCUX_CSSL_FP_FUNCID_unused_0x145    (0x5B54u)
#define MCUX_CSSL_FP_FUNCID_unused_0x146    (0x13E5u)
#define MCUX_CSSL_FP_FUNCID_unused_0x147    (0x39E4u)
#define MCUX_CSSL_FP_FUNCID_unused_0x148    (0x525Eu)
#define MCUX_CSSL_FP_FUNCID_unused_0x149    (0x70DAu)
#define MCUX_CSSL_FP_FUNCID_unused_0x14A    (0x5CCAu)
#define MCUX_CSSL_FP_FUNCID_unused_0x14B    (0x72C6u)
#define MCUX_CSSL_FP_FUNCID_unused_0x14C    (0x327Au)
#define MCUX_CSSL_FP_FUNCID_unused_0x14D    (0x3C33u)
#define MCUX_CSSL_FP_FUNCID_unused_0x14E    (0x5E98u)
#define MCUX_CSSL_FP_FUNCID_unused_0x14F    (0x541Fu)
#define MCUX_CSSL_FP_FUNCID_unused_0x150    (0x4755u)
#define MCUX_CSSL_FP_FUNCID_unused_0x151    (0x22F5u)
#define MCUX_CSSL_FP_FUNCID_unused_0x152    (0x6C3Cu)
#define MCUX_CSSL_FP_FUNCID_unused_0x153    (0x3B70u)
#define MCUX_CSSL_FP_FUNCID_unused_0x154    (0x56CCu)
#define MCUX_CSSL_FP_FUNCID_unused_0x155    (0x31CBu)
#define MCUX_CSSL_FP_FUNCID_unused_0x156    (0x35A3u)
#define MCUX_CSSL_FP_FUNCID_unused_0x157    (0x1B9Au)
#define MCUX_CSSL_FP_FUNCID_unused_0x158    (0x368Du)
#define MCUX_CSSL_FP_FUNCID_unused_0x159    (0x7871u)
#define MCUX_CSSL_FP_FUNCID_unused_0x15A    (0x79C4u)
#define MCUX_CSSL_FP_FUNCID_unused_0x15B    (0x7923u)
#define MCUX_CSSL_FP_FUNCID_unused_0x15C    (0x3C6Au)
#define MCUX_CSSL_FP_FUNCID_unused_0x15D    (0x42F5u)
#define MCUX_CSSL_FP_FUNCID_unused_0x15E    (0x4D6Au)
#define MCUX_CSSL_FP_FUNCID_unused_0x15F    (0x321Fu)
#define MCUX_CSSL_FP_FUNCID_unused_0x160    (0x5857u)
#define MCUX_CSSL_FP_FUNCID_unused_0x161    (0x6A27u)
#define MCUX_CSSL_FP_FUNCID_unused_0x162    (0x2DC5u)
#define MCUX_CSSL_FP_FUNCID_unused_0x163    (0x718Du)
#define MCUX_CSSL_FP_FUNCID_unused_0x164    (0x3B0Du)
#define MCUX_CSSL_FP_FUNCID_unused_0x165    (0x08EFu)
#define MCUX_CSSL_FP_FUNCID_unused_0x166    (0x612Fu)
#define MCUX_CSSL_FP_FUNCID_unused_0x167    (0x0EAEu)
#define MCUX_CSSL_FP_FUNCID_unused_0x168    (0x3E43u)
#define MCUX_CSSL_FP_FUNCID_unused_0x169    (0x13EAu)
#define MCUX_CSSL_FP_FUNCID_unused_0x16A    (0x4D99u)
#define MCUX_CSSL_FP_FUNCID_unused_0x16B    (0x05BDu)
#define MCUX_CSSL_FP_FUNCID_unused_0x16C    (0x7C54u)
#define MCUX_CSSL_FP_FUNCID_unused_0x16D    (0x7323u)
#define MCUX_CSSL_FP_FUNCID_unused_0x16E    (0x7686u)
#define MCUX_CSSL_FP_FUNCID_unused_0x16F    (0x29F1u)
#define MCUX_CSSL_FP_FUNCID_unused_0x170    (0x6783u)
#define MCUX_CSSL_FP_FUNCID_unused_0x171    (0x3077u)
#define MCUX_CSSL_FP_FUNCID_unused_0x172    (0x7346u)
#define MCUX_CSSL_FP_FUNCID_unused_0x173    (0x44F3u)
#define MCUX_CSSL_FP_FUNCID_unused_0x174    (0x19E3u)
#define MCUX_CSSL_FP_FUNCID_unused_0x175    (0x72B8u)
#define MCUX_CSSL_FP_FUNCID_unused_0x176    (0x0F78u)
#define MCUX_CSSL_FP_FUNCID_unused_0x177    (0x36ACu)
#define MCUX_CSSL_FP_FUNCID_unused_0x178    (0x316Bu)
#define MCUX_CSSL_FP_FUNCID_unused_0x179    (0x6B1Cu)
#define MCUX_CSSL_FP_FUNCID_unused_0x17A    (0x70DCu)
#define MCUX_CSSL_FP_FUNCID_unused_0x17B    (0x29CDu)
#define MCUX_CSSL_FP_FUNCID_unused_0x17C    (0x21DEu)
#define MCUX_CSSL_FP_FUNCID_unused_0x17D    (0x7478u)
#define MCUX_CSSL_FP_FUNCID_unused_0x17E    (0x65D2u)
#define MCUX_CSSL_FP_FUNCID_unused_0x17F    (0x09DDu)
#define MCUX_CSSL_FP_FUNCID_unused_0x180    (0x2C6Du)
#define MCUX_CSSL_FP_FUNCID_unused_0x181    (0x734Cu)
#define MCUX_CSSL_FP_FUNCID_unused_0x182    (0x5C4Eu)
#define MCUX_CSSL_FP_FUNCID_unused_0x183    (0x2E39u)
#define MCUX_CSSL_FP_FUNCID_unused_0x184    (0x4F16u)
#define MCUX_CSSL_FP_FUNCID_unused_0x185    (0x343Bu)
#define MCUX_CSSL_FP_FUNCID_unused_0x186    (0x7626u)
#define MCUX_CSSL_FP_FUNCID_unused_0x187    (0x45ADu)
#define MCUX_CSSL_FP_FUNCID_unused_0x188    (0x2997u)
#define MCUX_CSSL_FP_FUNCID_unused_0x189    (0x46D9u)
#define MCUX_CSSL_FP_FUNCID_unused_0x18A    (0x55B4u)
#define MCUX_CSSL_FP_FUNCID_unused_0x18B    (0x0FB8u)
#define MCUX_CSSL_FP_FUNCID_unused_0x18C    (0x685Du)
#define MCUX_CSSL_FP_FUNCID_unused_0x18D    (0x07D5u)
#define MCUX_CSSL_FP_FUNCID_unused_0x18E    (0x38A7u)
#define MCUX_CSSL_FP_FUNCID_unused_0x18F    (0x1AD9u)
#define MCUX_CSSL_FP_FUNCID_unused_0x190    (0x4E78u)
#define MCUX_CSSL_FP_FUNCID_unused_0x191    (0x585Bu)
#define MCUX_CSSL_FP_FUNCID_unused_0x192    (0x21AFu)
#define MCUX_CSSL_FP_FUNCID_unused_0x193    (0x5437u)
#define MCUX_CSSL_FP_FUNCID_unused_0x194    (0x70F2u)
#define MCUX_CSSL_FP_FUNCID_unused_0x195    (0x05FCu)
#define MCUX_CSSL_FP_FUNCID_unused_0x196    (0x5AE4u)
#define MCUX_CSSL_FP_FUNCID_unused_0x197    (0x5955u)
#define MCUX_CSSL_FP_FUNCID_unused_0x198    (0x16CDu)
#define MCUX_CSSL_FP_FUNCID_unused_0x199    (0x655Au)
#define MCUX_CSSL_FP_FUNCID_unused_0x19A    (0x68D9u)
#define MCUX_CSSL_FP_FUNCID_unused_0x19B    (0x0B37u)
#define MCUX_CSSL_FP_FUNCID_unused_0x19C    (0x7135u)
#define MCUX_CSSL_FP_FUNCID_unused_0x19D    (0x2BB4u)
#define MCUX_CSSL_FP_FUNCID_unused_0x19E    (0x4BC5u)
#define MCUX_CSSL_FP_FUNCID_unused_0x19F    (0x6725u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1A0    (0x0A7Du)
#define MCUX_CSSL_FP_FUNCID_unused_0x1A1    (0x0FA3u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1A2    (0x660Fu)
#define MCUX_CSSL_FP_FUNCID_unused_0x1A3    (0x0FE2u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1A4    (0x53A5u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1A5    (0x707Cu)
#define MCUX_CSSL_FP_FUNCID_unused_0x1A6    (0x2D2Eu)
#define MCUX_CSSL_FP_FUNCID_unused_0x1A7    (0x6659u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1A8    (0x4DD2u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1A9    (0x0FC6u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1AA    (0x61C7u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1AB    (0x2FC4u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1AC    (0x3B91u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1AD    (0x4177u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1AE    (0x1AE5u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1AF    (0x16D3u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1B0    (0x4CC7u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1B1    (0x03DDu)
#define MCUX_CSSL_FP_FUNCID_unused_0x1B2    (0x2E55u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1B3    (0x43B9u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1B4    (0x46A7u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1B5    (0x6C35u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1B6    (0x0CF6u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1B7    (0x0F27u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1B8    (0x099Fu)
#define MCUX_CSSL_FP_FUNCID_unused_0x1B9    (0x5AA3u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1BA    (0x4973u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1BB    (0x790Bu)
#define MCUX_CSSL_FP_FUNCID_unused_0x1BC    (0x5E0Du)
#define MCUX_CSSL_FP_FUNCID_unused_0x1BD    (0x17D2u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1BE    (0x44DEu)
#define MCUX_CSSL_FP_FUNCID_unused_0x1BF    (0x69C6u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1C0    (0x4765u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1C1    (0x5D23u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1C2    (0x622Fu)
#define MCUX_CSSL_FP_FUNCID_unused_0x1C3    (0x71A9u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1C4    (0x7534u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1C5    (0x44F9u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1C6    (0x0D57u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1C7    (0x3726u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1C8    (0x287Du)
#define MCUX_CSSL_FP_FUNCID_unused_0x1C9    (0x7CC1u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1CA    (0x1E93u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1CB    (0x6A95u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1CC    (0x4DC6u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1CD    (0x6CB8u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1CE    (0x237Cu)
#define MCUX_CSSL_FP_FUNCID_unused_0x1CF    (0x66A5u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1D0    (0x5953u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1D1    (0x3F30u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1D2    (0x297Cu)
#define MCUX_CSSL_FP_FUNCID_unused_0x1D3    (0x562Du)
#define MCUX_CSSL_FP_FUNCID_unused_0x1D4    (0x37C4u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1D5    (0x1957u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1D6    (0x213Fu)
#define MCUX_CSSL_FP_FUNCID_unused_0x1D7    (0x38E6u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1D8    (0x25F8u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1D9    (0x617Cu)
#define MCUX_CSSL_FP_FUNCID_unused_0x1DA    (0x2A2Fu)
#define MCUX_CSSL_FP_FUNCID_unused_0x1DB    (0x7CA4u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1DC    (0x74D8u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1DD    (0x17D1u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1DE    (0x472Du)
#define MCUX_CSSL_FP_FUNCID_unused_0x1DF    (0x6387u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1E0    (0x36F0u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1E1    (0x1B2Bu)
#define MCUX_CSSL_FP_FUNCID_unused_0x1E2    (0x6E52u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1E3    (0x21EBu)
#define MCUX_CSSL_FP_FUNCID_unused_0x1E4    (0x341Fu)
#define MCUX_CSSL_FP_FUNCID_unused_0x1E5    (0x1A76u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1E6    (0x5F60u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1E7    (0x606Fu)
#define MCUX_CSSL_FP_FUNCID_unused_0x1E8    (0x153Eu)
#define MCUX_CSSL_FP_FUNCID_unused_0x1E9    (0x74CAu)
#define MCUX_CSSL_FP_FUNCID_unused_0x1EA    (0x6353u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1EB    (0x60AFu)
#define MCUX_CSSL_FP_FUNCID_unused_0x1EC    (0x0DE9u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1ED    (0x352Du)
#define MCUX_CSSL_FP_FUNCID_unused_0x1EE    (0x71E8u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1EF    (0x21DDu)
#define MCUX_CSSL_FP_FUNCID_unused_0x1F0    (0x5D07u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1F1    (0x0FE8u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1F2    (0x2BC9u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1F3    (0x65F0u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1F4    (0x2CDCu)
#define MCUX_CSSL_FP_FUNCID_unused_0x1F5    (0x4C3Bu)
#define MCUX_CSSL_FP_FUNCID_unused_0x1F6    (0x68C7u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1F7    (0x64D5u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1F8    (0x5A59u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1F9    (0x71B2u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1FA    (0x1EA9u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1FB    (0x5CF0u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1FC    (0x4F1Cu)
#define MCUX_CSSL_FP_FUNCID_unused_0x1FD    (0x0E97u)
#define MCUX_CSSL_FP_FUNCID_unused_0x1FE    (0x4ACBu)
#define MCUX_CSSL_FP_FUNCID_unused_0x1FF    (0x3F18u)
/* END of function identifier list */

#endif /* MCUX_CSSL_FLOW_PROTECTION_FUNCTION_IDENTIFIERS_H_ */
