/*
 * Copyright 2019 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/*${header:start}*/
#include "cmd.h"

#include <string.h>
#include <stdint.h>
#include "fsl_debug_console.h"
#include "fsl_shell.h"

#include "app_streamer.h"

#ifdef VIT_PROC
#include "PL_platformTypes_CortexM7.h"
#include "VIT.h"
#include "vit_proc.h"
#endif
/*${header:end}*/

/*******************************************************************************
 * Definitions
 ******************************************************************************/
/*${macro:start}*/
#define EAP_MAX_PRESET 10
/*${macro:end}*/

/*******************************************************************************
 * Prototypes
 ******************************************************************************/

/*${prototype:start}*/
static shell_status_t shellEcho(shell_handle_t shellHandle, int32_t argc, char **argv);
static shell_status_t shellRecMIC(shell_handle_t shellHandle, int32_t argc, char **argv);
static shell_status_t shellFile(shell_handle_t shellHandle, int32_t argc, char **argv);

/*${prototype:end}*/

/*******************************************************************************
 * Variables
 ******************************************************************************/
bool bRecMic = FALSE;

const uint8_t audiomedia[] = {
    0xff, 0xfb, 0x94, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0x69,
    0x6e, 0x67, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00, 0x66, 0x30, 0x00, 0x05, 0x09, 0x0d, 0x10,
    0x13, 0x16, 0x16, 0x1a, 0x1e, 0x21, 0x24, 0x28, 0x2a, 0x2a, 0x2e, 0x31, 0x34, 0x37, 0x3b, 0x3e, 0x3e, 0x42, 0x45,
    0x48, 0x4b, 0x4f, 0x4f, 0x52, 0x55, 0x58, 0x5c, 0x5f, 0x63, 0x63, 0x66, 0x68, 0x6c, 0x6f, 0x72, 0x75, 0x75, 0x78,
    0x7b, 0x7e, 0x81, 0x84, 0x84, 0x87, 0x8b, 0x8e, 0x91, 0x94, 0x97, 0x97, 0x9a, 0x9d, 0xa0, 0xa3, 0xa5, 0xa8, 0xa8,
    0xab, 0xae, 0xb1, 0xb4, 0xb7, 0xb7, 0xb9, 0xbc, 0xc0, 0xc2, 0xc5, 0xc8, 0xc8, 0xcb, 0xce, 0xd1, 0xd4, 0xd7, 0xda,
    0xda, 0xdd, 0xe0, 0xe2, 0xe5, 0xe8, 0xe8, 0xea, 0xed, 0xef, 0xf2, 0xf4, 0xf6, 0xf6, 0xf8, 0xfa, 0xfd, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x50, 0x4c, 0x41, 0x4d, 0x45, 0x33, 0x2e, 0x31, 0x30, 0x30, 0x04, 0xb9, 0x00, 0x00, 0x00, 0x00,
    0x2e, 0x16, 0x00, 0x00, 0x35, 0x20, 0x24, 0x05, 0x2a, 0x8d, 0x00, 0x01, 0xe0, 0x00, 0x00, 0x66, 0x30, 0x77, 0xbd,
    0x5a, 0x93, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xff, 0xfb, 0xb4, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x80, 0x00, 0x00, 0x08, 0x00,
    0x60, 0x18, 0x90, 0x04, 0x00, 0x01, 0x06, 0xd4, 0x1d, 0x15, 0x87, 0x84, 0xc6, 0x00, 0xf0, 0x03, 0x62, 0xa4, 0xf5,
    0x98, 0x40, 0x70, 0x44, 0x0b, 0x20, 0x03, 0xc9, 0x40, 0x65, 0x13, 0x73, 0xe0, 0x35, 0x00, 0x88, 0x5e, 0x99, 0xfb,
    0xb3, 0x85, 0xa6, 0x07, 0xff, 0xd9, 0x2c, 0x60, 0x06, 0xc2, 0x88, 0x3d, 0xfc, 0x84, 0x5c, 0x46, 0xa6, 0xdf, 0xd0,
    0x83, 0x86, 0x90, 0xe5, 0xa1, 0x9f, 0xd7, 0xfb, 0x3f, 0xdb, 0xa9, 0xff, 0xea, 0x7f, 0xee, 0x46, 0xcb, 0x12, 0x11,
    0xc7, 0x69, 0x23, 0xba, 0x80, 0x1e, 0x10, 0xb3, 0xe0, 0x35, 0x00, 0xc4, 0x20, 0x17, 0x75, 0x36, 0x4c, 0xd2, 0x0e,
    0x58, 0x33, 0x51, 0x60, 0x85, 0x6f, 0xd4, 0xa6, 0x29, 0x8f, 0x33, 0x68, 0xb1, 0xd2, 0x3c, 0xd5, 0xef, 0x20, 0x5e,
    0x04, 0xaf, 0xfe, 0xbe, 0xd5, 0x74, 0xef, 0xdf, 0x16, 0xfb, 0x7d, 0xe9, 0xdf, 0x28, 0xa7, 0x0c, 0x1b, 0x67, 0x59,
    0xaa, 0xe5, 0x2e, 0x82, 0xe6, 0xa3, 0x0d, 0x89, 0x24, 0x69, 0x01, 0x0c, 0x24, 0x38, 0x02, 0x00, 0x91, 0xd1, 0x2b,
    0x89, 0xd4, 0x0e, 0x58, 0xa0, 0x6d, 0xc3, 0x2d, 0x60, 0x5b, 0x0a, 0x6e, 0x34, 0xb8, 0x0a, 0x48, 0xdf, 0xf8, 0xda,
    0xcc, 0x4c, 0x64, 0x70, 0x38, 0x08, 0x38, 0x4e, 0x34, 0x1f, 0x3e, 0x26, 0x09, 0x03, 0xc3, 0xc9, 0x83, 0xe1, 0x73,
    0xee, 0x90, 0x07, 0x98, 0xa3, 0x61, 0x80, 0x9a, 0x6c, 0x71, 0xc7, 0x33, 0x4f, 0x0d, 0x53, 0x91, 0xa3, 0xff, 0xff,
    0xff, 0xb7, 0xe4, 0x1e, 0xeb, 0xd3, 0x08, 0xa0, 0x6a, 0x52, 0x30, 0x40, 0x00, 0x4e, 0x7e, 0xcb, 0xff, 0x42, 0x4b,
    0xaa, 0xa9, 0xff, 0x2a, 0x05, 0xa6, 0x00, 0x44, 0x97, 0x07, 0xc1, 0xb6, 0x0f, 0x3e, 0x96, 0x1c, 0x57, 0xff, 0xf5,
    0x3f, 0xfd, 0x1f, 0xfb, 0xff, 0xff, 0x7f, 0xaa, 0xdd, 0xfc, 0xbd, 0xe5, 0x4b, 0xac, 0x89, 0x6c, 0xad, 0x47, 0x6d,
    0x91, 0xb6, 0x83, 0x30, 0x30, 0x41, 0xc3, 0x1a, 0x82, 0x36, 0x13, 0xd3, 0x6f, 0x37, 0x22, 0x23, 0x0e, 0x0b, 0x45,
    0x04, 0x7d, 0x82, 0x27, 0x21, 0xb1, 0xa0, 0xe5, 0xe9, 0x87, 0xef, 0x5e, 0x41, 0x5d, 0xa5, 0xb9, 0xd1, 0x75, 0x91,
    0xc0, 0x8c, 0x30, 0x54, 0x16, 0x2d, 0xe8, 0x0d, 0x12, 0x49, 0x06, 0xa5, 0x38, 0x17, 0x86, 0xdd, 0x49, 0xdf, 0x26,
    0x85, 0x43, 0x8b, 0x7a, 0xce, 0x97, 0x26, 0x27, 0xc8, 0x19, 0x50, 0x45, 0xa4, 0x04, 0x0c, 0xa4, 0x92, 0x1e, 0x84,
    0x90, 0x58, 0x79, 0x4e, 0x81, 0xeb, 0x57, 0xb5, 0xa7, 0x6a, 0x8b, 0xbf, 0xff, 0xff, 0xda, 0x81, 0x74, 0xd7, 0x97,
    0x1e, 0xe4, 0x81, 0x80, 0x47, 0x6d, 0x0e, 0x62, 0x02, 0x31, 0x0f, 0x3a, 0x72, 0x90, 0xd3, 0x4f, 0x9c, 0x63, 0xd6,
    0xb6, 0x08, 0xde, 0x82, 0xaa, 0x28, 0x34, 0x2c, 0x30, 0x52, 0x18, 0xfe, 0x12, 0x38, 0x7a, 0xe5, 0xbf, 0xff, 0xff,
    0xfb, 0x51, 0xf4, 0xd4, 0xef, 0xff, 0xff, 0x77, 0x9f, 0x8f, 0x00, 0x07, 0x70, 0x87, 0x64, 0x47, 0x55, 0x65, 0x58,
    0x97, 0x49, 0x18, 0x40, 0x00, 0x00, 0x00, 0x95, 0x20, 0x4a, 0xcc, 0x54, 0xf8, 0x3b, 0x9c, 0x74, 0x78, 0x0e, 0x54,
    0x02, 0x2e, 0x8a, 0x98, 0x48, 0x02, 0x6d, 0x18, 0xf0, 0x51, 0x91, 0x09, 0x04, 0x24, 0x48, 0x43, 0x0b, 0x60, 0x43,
    0x4e, 0x20, 0x32, 0x60, 0xcd, 0x77, 0xf0, 0x05, 0x1d, 0x21, 0xf9, 0xba, 0xbf, 0x85, 0x86, 0x5e, 0x5a, 0xc4, 0x50,
    0xe6, 0x59, 0x58, 0xbf, 0xc5, 0x70, 0xa0, 0x0b, 0x13, 0x5d, 0xe7, 0xff, 0x32, 0xde, 0xf3, 0x75, 0x17, 0x5c, 0x5e,
    0x37, 0x73, 0x1e, 0x6b, 0xb8, 0xfe, 0x59, 0x6f, 0x3d, 0x7f, 0x3f, 0xf0, 0xce, 0xbb, 0x07, 0x1c, 0x67, 0x68, 0xcf,
    0xff, 0xff, 0xff, 0xfe, 0xf1, 0x1d, 0xb8, 0x7c, 0x30, 0xc0, 0x0d, 0xa8, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xca,
    0x58, 0xae, 0xea, 0xa4, 0xfe, 0x10, 0xb9, 0xd2, 0xc7, 0x25, 0xbd, 0x65, 0xce, 0x9f, 0xa3, 0x41, 0x64, 0x00, 0x00,
    0x00, 0x22, 0xd2, 0xcb, 0x9b, 0x3a, 0xb3, 0xcd, 0xcc, 0xa0, 0xff, 0xfb, 0x94, 0x64, 0xd4, 0x80, 0x02, 0x77, 0x17,
    0x46, 0x6b, 0x41, 0x1b, 0x50, 0x2d, 0xe3, 0x68, 0xba, 0x04, 0x22, 0x5e, 0x0c, 0x4c, 0x99, 0x1b, 0xb5, 0xb1, 0x80,
    0x00, 0xc7, 0x82, 0x23, 0x2a, 0x86, 0x00, 0x00, 0x40, 0xc0, 0x00, 0x00, 0x0d, 0x00, 0x73, 0x0f, 0xd1, 0xd2, 0x0a,
    0x81, 0x29, 0x83, 0x38, 0xae, 0x18, 0x02, 0x01, 0x69, 0x86, 0x78, 0x08, 0x18, 0x56, 0x8e, 0xd9, 0x82, 0x90, 0x6a,
    0x99, 0xad, 0x85, 0x68, 0x10, 0x0d, 0x0d, 0x04, 0xc1, 0x48, 0x74, 0x0f, 0x0c, 0x49, 0x41, 0x00, 0xc2, 0x40, 0x11,
    0xcc, 0x26, 0xc0, 0x4a, 0x54, 0x60, 0xf4, 0x0f, 0x46, 0x00, 0x60, 0x5a, 0x1e, 0x44, 0xe7, 0x1b, 0x8b, 0x67, 0x1a,
    0x3f, 0x58, 0x6b, 0xc4, 0xf0, 0xfd, 0x69, 0x4c, 0xdc, 0x25, 0xf3, 0x32, 0x3c, 0x42, 0x22, 0xf9, 0x57, 0xb5, 0x72,
    0x59, 0x53, 0x90, 0xfc, 0x04, 0xef, 0x3b, 0x54, 0xbc, 0xbd, 0x28, 0xfa, 0xd7, 0xf7, 0x16, 0xc6, 0x97, 0x1b, 0x37,
    0x2d, 0x65, 0xaf, 0xef, 0x33, 0xff, 0xe6, 0xee, 0x04, 0x8d, 0x81, 0xc2, 0x7e, 0xb2, 0xc3, 0x54, 0x03, 0x20, 0xec,
    0x46, 0xaf, 0xd4, 0xf8, 0xa7, 0xff, 0x4a, 0xc6, 0x95, 0x73, 0x3f, 0xfe, 0x96, 0x08, 0x0b, 0xc0, 0x9c, 0x81, 0xc8,
    0x25, 0xb0, 0x41, 0x6d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x66, 0x46, 0x1b, 0x04, 0x0f, 0xac, 0x32, 0xf7,
    0xc3, 0xe0, 0x23, 0x0e, 0x2d, 0x8e, 0x94, 0x48, 0xd1, 0x61, 0x72, 0x8b, 0x12, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0xa5, 0x10, 0x00, 0x00, 0x07, 0x79, 0x8d, 0xfe, 0x8c, 0x00, 0x1c, 0x23, 0x02, 0x81,
    0x00, 0x28, 0x82, 0x1c, 0xaf, 0x05, 0x80, 0xb3, 0x1a, 0x20, 0x53, 0x91, 0x60, 0x23, 0x37, 0xc5, 0x83, 0x0e, 0x43,
    0xa3, 0x07, 0x01, 0x53, 0x04, 0x01, 0xf1, 0xe1, 0x44, 0x30, 0x0d, 0x87, 0x78, 0xcb, 0xa5, 0x55, 0x4d, 0x01, 0x1a,
    0xb2, 0xe9, 0xc4, 0xb0, 0x3b, 0x67, 0x95, 0x97, 0x51, 0x34, 0xe3, 0x4c, 0x56, 0x6c, 0x66, 0x56, 0x65, 0xa9, 0x1e,
    0xd6, 0xfb, 0xf5, 0x88, 0xd6, 0xf3, 0x10, 0xed, 0x8a, 0xd6, 0xb7, 0x8d, 0xaa, 0x43, 0x80, 0x2e, 0x2a, 0x0d, 0x9e,
    0x83, 0x73, 0xa0, 0x9b, 0xc7, 0xa4, 0x2f, 0x14, 0x47, 0xe8, 0xc6, 0x68, 0xd3, 0xff, 0xfd, 0x0d, 0x47, 0xfb, 0xc4,
    0x9d, 0xbe, 0x71, 0xb0, 0x00, 0x01, 0xaf, 0x2e, 0x10, 0x36, 0x4d, 0xd7, 0x34, 0x59, 0xec, 0xa0, 0x51, 0x83, 0x0b,
    0x87, 0x41, 0x75, 0x71, 0x33, 0x4f, 0x91, 0x0a, 0x3c, 0x2f, 0xdb, 0xbb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe8, 0xb1, 0x36, 0x91, 0x4a, 0x00, 0x00, 0x01, 0x32, 0x44, 0x7f, 0xf3, 0x42, 0xa0, 0xff, 0xfb, 0x94, 0x64, 0xfa,
    0x00, 0x03, 0x64, 0x25, 0xc9, 0x7e, 0x6f, 0x00, 0x00, 0x1f, 0xa0, 0xf9, 0x4d, 0xc1, 0x80, 0x00, 0x13, 0x00, 0x91,
    0x29, 0xf9, 0xec, 0x10, 0x00, 0xbd, 0x80, 0x64, 0xb7, 0x02, 0x00, 0x00, 0x32, 0xf8, 0x05, 0xfc, 0xd2, 0x41, 0x01,
    0x49, 0xc7, 0x70, 0x40, 0x6b, 0x24, 0x39, 0x83, 0xc3, 0x2a, 0x06, 0x03, 0xf0, 0xa8, 0x03, 0x95, 0x40, 0x50, 0x0c,
    0x04, 0x08, 0x63, 0x2a, 0xcd, 0xa2, 0x44, 0x62, 0xe8, 0x31, 0x28, 0xc4, 0xac, 0xe9, 0x6d, 0x0a, 0x32, 0x73, 0xcc,
    0x98, 0x50, 0x0f, 0xb7, 0xca, 0x4f, 0x6e, 0xd2, 0xc8, 0x4f, 0xb1, 0xc3, 0xf5, 0xec, 0x3a, 0xc9, 0xca, 0xa6, 0xf1,
    0x76, 0x67, 0x3f, 0xcd, 0x7d, 0x98, 0xed, 0x9b, 0x74, 0xf4, 0xce, 0x4c, 0xfc, 0xc6, 0xb6, 0xa9, 0x47, 0x98, 0x05,
    0x9f, 0xdf, 0x67, 0xe9, 0xfd, 0x3b, 0xfe, 0xff, 0xd8, 0x60, 0x62, 0x7a, 0x26, 0xb2, 0xb1, 0x4d, 0x14, 0x0b, 0x76,
    0x46, 0x99, 0x2c, 0xec, 0xc0, 0xf1, 0x70, 0xb8, 0x84, 0x0c, 0x93, 0x75, 0xa1, 0x37, 0x0d, 0xdc, 0xbf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x8a, 0x50, 0x00, 0x00, 0x08, 0x28, 0x9f, 0xfe, 0x8c, 0x00, 0x0c, 0x0a,
    0x09, 0x4c, 0x54, 0x04, 0x07, 0x09, 0x73, 0x09, 0x83, 0x62, 0xa8, 0xb2, 0x60, 0xed, 0x8c, 0x64, 0x07, 0x22, 0x62,
    0xb0, 0xb8, 0x62, 0x4b, 0x83, 0x83, 0x83, 0x92, 0x03, 0xd1, 0x8f, 0x23, 0x81, 0x6d, 0x33, 0x17, 0x4a, 0x0d, 0x45,
    0xc7, 0x33, 0x72, 0x4c, 0x9b, 0xda, 0xf8, 0xbf, 0x72, 0x49, 0x5d, 0x49, 0x85, 0x04, 0xaf, 0x4d, 0x52, 0x58, 0x4f,
    0xa8, 0xc4, 0xa1, 0xf7, 0x58, 0xcb, 0xec, 0xc3, 0x44, 0x25, 0xc7, 0x88, 0x17, 0xdb, 0xc8, 0xa6, 0xab, 0xf6, 0x4a,
    0x48, 0xb0, 0x36, 0x26, 0x48, 0x50, 0x70, 0xa2, 0x20, 0xaa, 0x84, 0x10, 0x92, 0x99, 0xf6, 0xee, 0x5d, 0x3f, 0x67,
    0xff, 0x72, 0x74, 0x20, 0x1b, 0x61, 0xcb, 0x1c, 0x80, 0x00, 0x00, 0x0f, 0x39, 0x45, 0x05, 0x11, 0x46, 0x2c, 0x0e,
    0xb5, 0xe8, 0xda, 0xc7, 0x97, 0x73, 0x10, 0x97, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x58,
    0x00, 0x00, 0x00, 0x98, 0xb4, 0x7d, 0x73, 0x40, 0x00, 0xa5, 0xa6, 0x1b, 0x09, 0x18, 0x89, 0x02, 0x0e, 0xaa, 0x19,
    0x98, 0x20, 0x75, 0x3e, 0x19, 0xd7, 0xe8, 0x23, 0x98, 0xb2, 0x81, 0x29, 0xde, 0x4c, 0x64, 0x14, 0x18, 0x17, 0xe4,
    0x04, 0x4c, 0x41, 0x06, 0xc6, 0xfe, 0x37, 0x57, 0xab, 0x16, 0xfd, 0x5a, 0x6f, 0xc6, 0x31, 0x9e, 0xec, 0xfb, 0x5d,
    0x76, 0x67, 0x62, 0x90, 0x52, 0x8b, 0xd9, 0xb3, 0xed, 0x92, 0xe5, 0x0c, 0x7b, 0x3c, 0xea, 0x52, 0xbd, 0x74, 0xff,
    0xfb, 0x74, 0x64, 0xfe, 0x01, 0x13, 0x5a, 0x20, 0x49, 0xff, 0x75, 0xe0, 0x08, 0x2b, 0x60, 0x08, 0xda, 0xe0, 0x00,
    0x01, 0x0c, 0xa8, 0x9b, 0x27, 0xed, 0xf9, 0x85, 0x60, 0x92, 0x03, 0xe4, 0x34, 0x10, 0xa4, 0x24, 0xf9, 0xeb, 0x1a,
    0x4e, 0xc5, 0x33, 0xe6, 0x59, 0x72, 0x5f, 0x3f, 0x95, 0x3d, 0x4b, 0xf1, 0x6a, 0x71, 0x30, 0x7d, 0x00, 0xc0, 0x65,
    0xd1, 0x91, 0xe8, 0xbc, 0x79, 0xfe, 0xca, 0x8e, 0xa9, 0x06, 0xa2, 0xd6, 0xb9, 0x94, 0xa5, 0x77, 0x4d, 0xdc, 0x2c,
    0x8f, 0xf4, 0xff, 0xb3, 0xff, 0xad, 0x2d, 0x80, 0x14, 0x93, 0x6e, 0x5e, 0x03, 0x8c, 0x21, 0x74, 0x0c, 0x8b, 0x30,
    0x28, 0x30, 0xd2, 0xe4, 0x40, 0x06, 0x55, 0x5b, 0x20, 0x40, 0x18, 0xe6, 0x4d, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0xe3, 0x45, 0xc8, 0xd5, 0x00, 0x00, 0x03, 0x1b, 0xef, 0xb4, 0x40, 0x00, 0x97, 0xc0, 0x80,
    0x25, 0x4c, 0x43, 0x0e, 0x00, 0x33, 0x30, 0x05, 0x08, 0xc3, 0x07, 0xe4, 0x41, 0x33, 0xd6, 0x55, 0x23, 0x06, 0x00,
    0x91, 0x21, 0x1e, 0x1a, 0x14, 0x32, 0x70, 0x23, 0x82, 0x02, 0x08, 0x2d, 0x6f, 0x9e, 0xd6, 0xc9, 0x49, 0x48, 0x3a,
    0x13, 0x4b, 0x95, 0x2a, 0xcb, 0xdf, 0x9d, 0x90, 0x60, 0x59, 0xbc, 0x05, 0x6c, 0x75, 0x5a, 0x72, 0x0b, 0x63, 0x0b,
    0x36, 0x5b, 0x55, 0x82, 0xea, 0x83, 0x95, 0xeb, 0xf8, 0xcd, 0x92, 0xaf, 0xcb, 0x1b, 0x70, 0x56, 0x2f, 0x06, 0xf9,
    0xc3, 0x1d, 0x8e, 0x82, 0x24, 0x81, 0x93, 0x50, 0x8b, 0xd5, 0x52, 0x05, 0x5c, 0x0e, 0xfb, 0x65, 0xaa, 0x7f, 0xd7,
    0xda, 0x32, 0x94, 0xf8, 0xc7, 0x21, 0x40, 0x04, 0x9c, 0x42, 0x55, 0x20, 0x20, 0x00, 0x2d, 0x20, 0x0e, 0x10, 0x4b,
    0xde, 0xaa, 0xc8, 0x13, 0x16, 0x6b, 0xc6, 0x09, 0x49, 0x84, 0x4b, 0xb9, 0x2d, 0x07, 0x41, 0x0f, 0xc4, 0x4f, 0xbe,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x66, 0x54, 0x10, 0xde, 0x7b, 0x9b, 0xcc, 0x0c, 0x00, 0xe0,
    0xa8, 0x1d, 0xff, 0xfb, 0x84, 0x64, 0xeb, 0x80, 0x13, 0x69, 0x20, 0x49, 0xfb, 0xba, 0x49, 0xf8, 0x22, 0x80, 0x08,
    0xfd, 0x00, 0x00, 0x01, 0x0f, 0x6c, 0x81, 0x23, 0xee, 0x7b, 0x44, 0x20, 0x98, 0x80, 0xe3, 0x70, 0x60, 0x80, 0x04,
    0x01, 0x86, 0x50, 0xc1, 0x3c, 0x14, 0xcc, 0x4a, 0x09, 0x48, 0xea, 0x20, 0xca, 0x4c, 0x53, 0x01, 0x78, 0xef, 0xb7,
    0x33, 0x6b, 0x4c, 0xa3, 0xa3, 0x82, 0x18, 0xb8, 0x6e, 0x84, 0xce, 0x50, 0x1c, 0x50, 0x80, 0x3b, 0x1f, 0xe6, 0xa7,
    0x22, 0xd6, 0x6c, 0xcf, 0xc8, 0xa0, 0x4c, 0x72, 0x54, 0x3f, 0xdc, 0x74, 0xe2, 0x14, 0xa4, 0x20, 0x3d, 0xa0, 0xe9,
    0x46, 0x2c, 0x7e, 0x1f, 0x37, 0xd9, 0x6a, 0xda, 0x51, 0x69, 0xe5, 0xeb, 0x36, 0x17, 0x07, 0x84, 0xc9, 0xb8, 0x2f,
    0x04, 0x96, 0x05, 0x5d, 0x91, 0x4b, 0xb7, 0x3a, 0xcf, 0x42, 0x55, 0xe4, 0x91, 0xd6, 0xaa, 0x76, 0x10, 0xed, 0x73,
    0x10, 0x08, 0xe4, 0x82, 0x5b, 0x00, 0x66, 0x89, 0xae, 0x16, 0x45, 0x1b, 0xd1, 0x63, 0xfd, 0x2b, 0x79, 0x68, 0xad,
    0x8c, 0x2a, 0x84, 0xcf, 0x81, 0x0b, 0x49, 0x0b, 0xa6, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xbe,
    0xb5, 0x80, 0x04, 0x04, 0x1f, 0x5f, 0xfd, 0x80, 0x00, 0x66, 0x22, 0x74, 0x8e, 0x08, 0xe0, 0xc6, 0x00, 0xc0, 0x68,
    0x13, 0x4c, 0x1d, 0xc9, 0x80, 0xd5, 0x8c, 0xc3, 0xcc, 0x25, 0x41, 0x48, 0xd3, 0x13, 0x00, 0x86, 0x31, 0x82, 0xc1,
    0xe0, 0xc3, 0x11, 0x40, 0xb3, 0xce, 0x2b, 0xef, 0x19, 0x93, 0x35, 0x7e, 0x56, 0xab, 0x33, 0xbb, 0xd3, 0x3a, 0xdf,
    0xed, 0x67, 0xeb, 0x1c, 0x3e, 0xce, 0xfe, 0x13, 0x72, 0xaf, 0x20, 0xd8, 0xb7, 0x6e, 0xdf, 0xe7, 0x66, 0x35, 0x95,
    0xbb, 0x3a, 0x87, 0x75, 0x73, 0x9c, 0xd6, 0xa9, 0x44, 0x4f, 0x13, 0x86, 0x1c, 0x50, 0x8a, 0xe2, 0xf0, 0xdd, 0xe6,
    0x0f, 0x7f, 0x44, 0x45, 0xdb, 0xc2, 0x24, 0x00, 0x00, 0x05, 0xdc, 0x6c, 0xf2, 0x04, 0x48, 0x51, 0x96, 0x46, 0x4f,
    0xf9, 0x50, 0x54, 0xf2, 0xd8, 0xda, 0xdb, 0x19, 0x95, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xeb, 0xf7,
    0xa5, 0x0c, 0x00, 0x00, 0x43, 0x6b, 0xe6, 0x88, 0x00, 0x07, 0x40, 0x20, 0xc0, 0x20, 0x00, 0xc2, 0x81, 0x04, 0x60,
    0xae, 0x07, 0xe6, 0x07, 0x81, 0x10, 0x61, 0xf6, 0x6b, 0xe7, 0x0d, 0xa8, 0xd4, 0x62, 0x06, 0xff, 0xfb, 0x84, 0x64,
    0xe8, 0x89, 0x13, 0x83, 0x20, 0x49, 0x6b, 0xdb, 0x79, 0xc8, 0x2a, 0x80, 0x08, 0xed, 0x00, 0x00, 0x01, 0x0d, 0x18,
    0x81, 0x25, 0xaf, 0x69, 0x87, 0xe0, 0x9b, 0x8b, 0x63, 0xf4, 0x10, 0x8c, 0xfc, 0x12, 0xe7, 0x32, 0x11, 0xa4, 0x48,
    0x6a, 0xd4, 0x9e, 0xe0, 0xa4, 0xd0, 0x1b, 0x7a, 0x8f, 0xf4, 0x85, 0xf7, 0x20, 0x10, 0xdf, 0x63, 0x2e, 0xab, 0x12,
    0xb9, 0x49, 0x28, 0xb9, 0x2b, 0xce, 0x6d, 0x2f, 0x29, 0x73, 0xca, 0x84, 0x28, 0x6b, 0x12, 0x38, 0xe3, 0x40, 0x78,
    0x5d, 0xd7, 0x65, 0x0d, 0x0c, 0x83, 0x86, 0xa8, 0x45, 0x5b, 0xd0, 0x8c, 0x07, 0x1c, 0x94, 0x6c, 0x9a, 0xca, 0x41,
    0xb0, 0x80, 0x22, 0x22, 0x56, 0xba, 0x2d, 0x5e, 0xac, 0xa6, 0xc6, 0xa3, 0xe3, 0x7d, 0x77, 0xcc, 0x7a, 0xc9, 0xfe,
    0x8e, 0xe4, 0x16, 0xa0, 0xff, 0xc3, 0xac, 0x52, 0x28, 0x6d, 0x07, 0xfc, 0x58, 0x8b, 0x56, 0xb1, 0xa3, 0x38, 0x99,
    0x34, 0xaa, 0xc0, 0x3d, 0xbf, 0xff, 0x47, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x3f, 0xfa, 0x5f, 0x5c, 0xdc, 0x4c, 0xa5,
    0x40, 0x00, 0x09, 0x13, 0x6f, 0xb4, 0x04, 0x00, 0x61, 0xc2, 0x0e, 0x19, 0x31, 0xb0, 0x8e, 0x49, 0x73, 0x04, 0x70,
    0x46, 0x31, 0x00, 0x21, 0xd3, 0x8f, 0x42, 0xc0, 0x31, 0x10, 0x03, 0x91, 0x70, 0x66, 0x14, 0x98, 0xaa, 0xe0, 0x75,
    0xc1, 0x64, 0x8d, 0x0e, 0x08, 0x80, 0xe2, 0x17, 0x4b, 0x01, 0x24, 0x1c, 0xa7, 0xa9, 0x37, 0x73, 0x1a, 0xd9, 0xe5,
    0x3b, 0x7d, 0x02, 0x37, 0x2b, 0x63, 0x2b, 0xfc, 0xea, 0x5f, 0xb5, 0xc9, 0xf9, 0x4b, 0x9d, 0x43, 0x52, 0xf6, 0x5c,
    0xa7, 0xa9, 0x85, 0x9b, 0x97, 0x62, 0x3c, 0xed, 0xed, 0x65, 0x6a, 0x6b, 0xc1, 0x58, 0x28, 0x14, 0x82, 0x8e, 0xff,
    0x4a, 0x89, 0xc5, 0x96, 0x2b, 0x72, 0x33, 0x7f, 0xfd, 0x15, 0x32, 0x1c, 0x90, 0x31, 0x25, 0x88, 0x00, 0x00, 0x01,
    0x51, 0xcb, 0x59, 0x00, 0xb8, 0xcd, 0xf8, 0xa3, 0x04, 0x6a, 0xa8, 0x70, 0x28, 0x09, 0x93, 0x2a, 0x67, 0xee, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x5c, 0x92, 0x80, 0x00, 0x66, 0x06, 0xb7, 0xfc, 0xd8, 0x00, 0x0c,
    0x80, 0x01, 0x80, 0xf0, 0x2b, 0x98, 0x85, 0x8a, 0xd9, 0x8b, 0x58, 0x10, 0x18, 0x0a, 0x06, 0x19, 0x84, 0x02, 0x9c,
    0x1a, 0x93, 0x3c, 0x39, 0x80, 0xe1, 0xe0, 0x1b, 0x11, 0xff, 0xfb, 0x84, 0x64, 0xe9, 0x00, 0x13, 0x05, 0x20, 0x4a,
    0xeb, 0x3e, 0xd0, 0x98, 0x24, 0xc0, 0x08, 0xda, 0x00, 0x00, 0x01, 0x0e, 0x84, 0x91, 0x25, 0xaf, 0x69, 0x07, 0xe0,
    0x90, 0x00, 0x63, 0x24, 0x10, 0x00, 0x00, 0x2e, 0xc1, 0xa3, 0x38, 0x27, 0x1b, 0x72, 0x05, 0xd9, 0xae, 0x98, 0xbd,
    0x18, 0xd4, 0x99, 0x94, 0xa7, 0x00, 0x55, 0xd8, 0xd2, 0x19, 0x13, 0x0a, 0x25, 0xb8, 0x50, 0x10, 0x0a, 0x5a, 0x7b,
    0xa7, 0x44, 0x5c, 0x06, 0x6e, 0x3e, 0x04, 0x44, 0x33, 0xa2, 0xa1, 0xe1, 0x57, 0x55, 0xbb, 0x2f, 0xb6, 0x58, 0x44,
    0x67, 0x94, 0x30, 0xe9, 0xd0, 0xbb, 0xd7, 0x58, 0x8d, 0xa1, 0xde, 0x07, 0x34, 0x75, 0xc4, 0x09, 0x20, 0x22, 0x27,
    0x9a, 0x08, 0x85, 0x80, 0x91, 0x1a, 0x82, 0x0a, 0x32, 0x18, 0x90, 0x01, 0x0c, 0xd1, 0xf1, 0x83, 0xbd, 0xcb, 0xd5,
    0x4b, 0xa0, 0xd8, 0x0a, 0x09, 0xb2, 0xff, 0xbf, 0x33, 0x97, 0x29, 0xf2, 0xca, 0xad, 0xfd, 0xdc, 0xb5, 0x3f, 0x39,
    0x3d, 0x7a, 0xd5, 0x9b, 0x92, 0x5b, 0xb6, 0x32, 0x9d, 0xa6, 0xb3, 0x5a, 0xed, 0xce, 0x5b, 0xe5, 0xaa, 0x5e, 0x96,
    0x03, 0xba, 0x97, 0x93, 0x1c, 0x4a, 0x58, 0x24, 0xf7, 0x9e, 0x74, 0xc7, 0x5d, 0x90, 0xb0, 0xba, 0x71, 0x58, 0x66,
    0xec, 0x62, 0xfd, 0x2a, 0x98, 0x4a, 0x8e, 0xca, 0x52, 0x46, 0x0d, 0x8a, 0x0e, 0x51, 0x81, 0x57, 0x2a, 0xdd, 0x0f,
    0x89, 0x96, 0x22, 0x71, 0x50, 0xa8, 0xab, 0xc2, 0x34, 0xbc, 0x31, 0x7b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xbf,
    0xfb, 0x5f, 0xfd, 0x1f, 0x42, 0x30, 0x8a, 0xd5, 0x80, 0x00, 0x89, 0x0e, 0xbf, 0x74, 0x84, 0x00, 0x09, 0x02, 0xc3,
    0x01, 0x80, 0xb8, 0x31, 0xf6, 0x09, 0x40, 0xe0, 0xab, 0x30, 0x2e, 0x00, 0x33, 0x0d, 0x30, 0xbc, 0x37, 0x6d, 0x02,
    0x73, 0x0a, 0x31, 0x64, 0x34, 0x54, 0x59, 0xf3, 0x0e, 0xf0, 0x35, 0x3d, 0xf0, 0xb3, 0x36, 0x21, 0x11, 0x81, 0x2c,
    0x51, 0x40, 0x87, 0xf8, 0x2e, 0x10, 0xc7, 0x1f, 0x48, 0xd1, 0x50, 0x04, 0x98, 0x5c, 0x2e, 0x4c, 0x18, 0xc4, 0x91,
    0xc0, 0x23, 0x96, 0x9b, 0x66, 0x99, 0x5e, 0x55, 0x74, 0x32, 0x8d, 0x60, 0xfb, 0x46, 0xd9, 0x63, 0x26, 0x7f, 0xa9,
    0x62, 0x31, 0x6a, 0x70, 0xf4, 0xa1, 0x59, 0x45, 0x7b, 0x0e, 0x54, 0x5d, 0x5c, 0x2a, 0xe6, 0x03, 0xec, 0x68, 0xac,
    0xb5, 0xda, 0xc5, 0xff, 0xfb, 0x94, 0x64, 0xf0, 0x00, 0x13, 0x49, 0x20, 0xc9, 0xeb, 0x5e, 0xd0, 0x98, 0x26, 0x20,
    0x18, 0xfd, 0x04, 0x00, 0x01, 0x17, 0x6c, 0xc1, 0x21, 0xaf, 0x6f, 0x0b, 0x20, 0x9e, 0x80, 0x23, 0x28, 0x00, 0x00,
    0x00, 0xf6, 0x57, 0xea, 0xd3, 0x33, 0x43, 0x54, 0x93, 0xa4, 0x05, 0x09, 0xdc, 0x33, 0x22, 0xaa, 0x6c, 0xd3, 0xfe,
    0xf2, 0xc9, 0x5f, 0x44, 0x28, 0x98, 0x00, 0x00, 0x98, 0x2e, 0x0d, 0x2d, 0xcc, 0x73, 0xf7, 0x74, 0xe8, 0x11, 0x0d,
    0x12, 0x10, 0xd7, 0x42, 0xf3, 0xac, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8c, 0x15, 0x00, 0x00,
    0x0d, 0xbf, 0x6a, 0x97, 0x18, 0x0b, 0x06, 0x51, 0x8e, 0xa0, 0x1d, 0x90, 0x00, 0xa9, 0x08, 0x29, 0x16, 0x08, 0xe4,
    0xc6, 0xf8, 0xc0, 0x0c, 0x21, 0xc6, 0x54, 0xdb, 0x7c, 0x93, 0x0c, 0x29, 0x83, 0x18, 0x00, 0x50, 0x2e, 0xd0, 0xc1,
    0x23, 0x6c, 0x3a, 0x1d, 0x56, 0xf7, 0xe5, 0x78, 0x45, 0x14, 0x4d, 0x5a, 0xe0, 0x21, 0xe2, 0xdf, 0x06, 0x47, 0xd9,
    0xeb, 0x6e, 0x5a, 0x41, 0xf6, 0x08, 0x1c, 0xc6, 0x05, 0x8c, 0xce, 0xcd, 0xb1, 0xa5, 0x43, 0xdb, 0xcb, 0x0d, 0x8d,
    0x18, 0x4e, 0xf6, 0x29, 0x69, 0xc2, 0x2b, 0xa8, 0x74, 0xdd, 0xf2, 0xbd, 0xad, 0x7c, 0xf7, 0xc4, 0x76, 0xd6, 0xea,
    0x83, 0xd0, 0x90, 0xb7, 0x7d, 0xb7, 0x69, 0xff, 0xfd, 0xd2, 0x5f, 0xc4, 0x7c, 0x88, 0x59, 0xa3, 0x5c, 0xd0, 0x49,
    0x2a, 0x66, 0xed, 0x09, 0xb4, 0xd9, 0xf6, 0xee, 0x37, 0xdb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xdb, 0x52, 0x57, 0xdb, 0x50, 0x01, 0x7d, 0x80, 0x04, 0x70, 0xc3, 0xc8, 0x0f, 0xcc, 0x03, 0x80, 0x10, 0xc0, 0x54,
    0x04, 0xcc, 0x22, 0x82, 0xe8, 0xd1, 0xd0, 0x5a, 0x4c, 0x43, 0x81, 0xb0, 0xdf, 0x88, 0x97, 0x0c, 0x40, 0x41, 0xf4,
    0xe8, 0x44, 0xe1, 0x40, 0x90, 0x57, 0x08, 0x60, 0x59, 0xe4, 0x8d, 0x8b, 0xaf, 0xa6, 0xcc, 0xd5, 0x55, 0x7c, 0x36,
    0x3c, 0xdc, 0xb8, 0x68, 0x3f, 0xc2, 0xbd, 0x6a, 0x8e, 0xd2, 0x56, 0xc8, 0x1b, 0x00, 0x34, 0x45, 0x75, 0x8d, 0xbc,
    0x52, 0x50, 0xb8, 0x7f, 0x68, 0xcd, 0x21, 0x8d, 0x1c, 0xdf, 0x96, 0xd8, 0xbd, 0xd6, 0x6a, 0x15, 0xdb, 0xb6, 0xff,
    0x45, 0x9d, 0xd7, 0xb6, 0xd2, 0xb9, 0xf3, 0x96, 0x66, 0xd9, 0xb9, 0x3f, 0x6a, 0x3b, 0xce, 0x91, 0xe1, 0x73, 0x08,
    0x8b, 0x40, 0xbd, 0x00, 0x00, 0x9e, 0xd9, 0x10, 0xd1, 0xd9, 0x8a, 0x3b, 0xb4, 0x08, 0x8e, 0x8d, 0xf2, 0x4c, 0x9c,
    0x78, 0xa1, 0xff, 0xff, 0xff, 0xa3, 0xff, 0xff, 0xd7, 0xe9, 0x4d, 0x1f, 0xfe, 0xde, 0xad, 0x6f, 0x8f, 0x0c, 0x20,
    0xa6, 0xff, 0x40, 0x02, 0xd1, 0x15, 0x5f, 0xff, 0xfb, 0x94, 0x64, 0xe4, 0x81, 0x14, 0x03, 0x2a, 0x4a, 0x6b, 0xdb,
    0x42, 0x78, 0x22, 0xa0, 0x18, 0xea, 0x04, 0x00, 0x01, 0x0d, 0x4c, 0xa9, 0x2b, 0x4f, 0x65, 0x69, 0x60, 0x79, 0x00,
    0x63, 0xa4, 0x10, 0x00, 0x04, 0x18, 0xe0, 0x52, 0x22, 0x05, 0x0a, 0x09, 0xc6, 0x6a, 0xc7, 0x85, 0x46, 0x82, 0x68,
    0x06, 0x7b, 0x28, 0x12, 0x56, 0x0e, 0x46, 0x07, 0xe0, 0x18, 0x80, 0xd4, 0x0e, 0x65, 0xac, 0xca, 0x65, 0x8d, 0x5a,
    0x64, 0x6d, 0xee, 0x0f, 0xd4, 0x85, 0x1a, 0x9a, 0xa9, 0x10, 0x07, 0xd3, 0xd7, 0xdd, 0x98, 0x99, 0xc6, 0x7c, 0x66,
    0x19, 0xe0, 0xea, 0xe3, 0x66, 0xd2, 0xc8, 0x22, 0x89, 0xa5, 0x91, 0x62, 0xfa, 0xa2, 0x74, 0x9d, 0xbd, 0xa9, 0xa2,
    0x68, 0xa9, 0xf5, 0xcc, 0x49, 0xb5, 0x91, 0xcd, 0x8f, 0x5f, 0x7c, 0xae, 0xea, 0x9e, 0x59, 0x8e, 0x49, 0x00, 0x0f,
    0x36, 0x0a, 0xbc, 0x20, 0xb5, 0x00, 0xb8, 0x57, 0x4a, 0x00, 0xad, 0x0f, 0x01, 0x37, 0x44, 0xc5, 0x16, 0xd0, 0x5d,
    0x17, 0xd3, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0xff, 0xfe, 0xcd, 0x26, 0xf7, 0x14, 0x10, 0xbc, 0x56,
    0x01, 0x01, 0xfb, 0x61, 0x00, 0x30, 0xd0, 0x48, 0x9a, 0x18, 0x33, 0x80, 0x99, 0x78, 0xcc, 0x06, 0x80, 0x40, 0xc1,
    0x54, 0x03, 0x8c, 0x5e, 0x42, 0x80, 0xc0, 0xbc, 0x90, 0xcc, 0xc3, 0x60, 0xa8, 0xc1, 0xf8, 0x2e, 0x8e, 0x28, 0x24,
    0x88, 0xdc, 0x48, 0x31, 0x35, 0x91, 0x92, 0x1e, 0x65, 0x6f, 0x21, 0x54, 0x4e, 0x2b, 0x9d, 0xa8, 0xdb, 0x42, 0x2a,
    0x87, 0x96, 0x8a, 0x5f, 0x6e, 0x77, 0x2f, 0x3e, 0x97, 0xb0, 0xac, 0xf2, 0x6b, 0x55, 0x50, 0x6a, 0x6d, 0xaf, 0x2e,
    0x75, 0x95, 0xcb, 0x17, 0xb2, 0x85, 0xd0, 0x73, 0x11, 0xc3, 0x1f, 0x59, 0xc9, 0xdb, 0x36, 0x69, 0x6a, 0x5b, 0x37,
    0x7f, 0x67, 0x7a, 0xd9, 0xb6, 0x80, 0xc9, 0xd0, 0x34, 0x93, 0x1d, 0x9f, 0xb6, 0xa4, 0x7f, 0xff, 0xf7, 0x00, 0x51,
    0x31, 0x30, 0x9b, 0x40, 0x00, 0x6a, 0x82, 0x21, 0x11, 0xc2, 0xe1, 0x24, 0x38, 0xc6, 0xf4, 0x6c, 0x95, 0x4d, 0x21,
    0x7a, 0x99, 0xd5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x3b, 0x36, 0x67, 0xf5, 0xd1, 0x04, 0xae,
    0x8d, 0x4e, 0x0f, 0x2f, 0x00, 0x40, 0x0c, 0xc2, 0xc0, 0x33, 0x43, 0x13, 0x0d, 0x05, 0x5e, 0x37, 0x94, 0x44, 0x33,
    0x0e, 0x70, 0xd1, 0x3a, 0xd1, 0x05, 0x10, 0x9b, 0xf0, 0xc2, 0xd3, 0x9c, 0x51, 0x3f, 0x4f, 0x56, 0x2f, 0x56, 0xfb,
    0xd6, 0xe7, 0x10, 0x0a, 0x24, 0xc5, 0x9d, 0x58, 0xb1, 0xf2, 0x1f, 0xb1, 0xf2, 0x5c, 0x3b, 0xa7, 0x82, 0xd4, 0x03,
    0x0b, 0xdf, 0xca, 0xa5, 0x98, 0xce, 0xea, 0x2f, 0xf3, 0xb5, 0x69, 0xff, 0xfb, 0x74, 0x64, 0xfc, 0x84, 0x13, 0x7b,
    0x2f, 0x4b, 0x1b, 0xd9, 0x62, 0x58, 0x25, 0xc0, 0x08, 0xb9, 0x00, 0x00, 0x00, 0x0c, 0xe0, 0xab, 0x32, 0xee, 0x79,
    0x27, 0xa0, 0x82, 0x80, 0x63, 0x24, 0x10, 0x00, 0x00, 0x70, 0x9b, 0x90, 0x44, 0x2b, 0x56, 0xe5, 0xab, 0xf7, 0x71,
    0xfb, 0xda, 0xbc, 0xe2, 0x6a, 0x52, 0xd0, 0x58, 0x23, 0x5d, 0xef, 0x60, 0x44, 0x98, 0x02, 0x5e, 0x03, 0xa2, 0x60,
    0x54, 0x04, 0xad, 0xf5, 0xa9, 0x43, 0x6f, 0x52, 0xe8, 0x17, 0x8a, 0xce, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x45, 0x0b, 0xeb, 0x00, 0x01, 0xae, 0x80, 0x64, 0x84, 0xf5, 0xde, 0x45, 0x9a, 0x17, 0x62, 0x3e,
    0x89, 0x53, 0x9d, 0x15, 0x3a, 0x79, 0x09, 0x33, 0x0f, 0x40, 0xde, 0x30, 0x3d, 0x04, 0x80, 0x60, 0x09, 0x81, 0x40,
    0x29, 0x4c, 0x64, 0xb1, 0x38, 0x71, 0xe7, 0x4f, 0x45, 0x6a, 0xab, 0x7d, 0x47, 0xdb, 0xe7, 0x20, 0x98, 0x17, 0x67,
    0x2c, 0x5c, 0x96, 0xd1, 0x37, 0x6f, 0x94, 0xb5, 0xf9, 0x66, 0x6c, 0x3b, 0x4c, 0x8c, 0x0e, 0xb0, 0x4a, 0xb8, 0xaa,
    0xc9, 0xe2, 0x8a, 0x90, 0x36, 0x8b, 0x17, 0xa9, 0x9a, 0x3b, 0x04, 0x03, 0xb0, 0x8f, 0xfd, 0x8d, 0x5d, 0x25, 0x0d,
    0x89, 0xc2, 0x62, 0xe0, 0x41, 0xef, 0xff, 0xad, 0x04, 0x4a, 0x61, 0x88, 0xce, 0x00, 0x02, 0x07, 0x3c, 0x44, 0x83,
    0xea, 0xd3, 0xc6, 0xb1, 0x9c, 0xf2, 0xea, 0xeb, 0x3e, 0xa7, 0x96, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf7, 0xb0, 0x6d, 0x64, 0x17, 0xf6, 0xac, 0x01, 0x3a, 0x01, 0x03, 0x41, 0x21, 0xae, 0x4c, 0xd4, 0x34, 0x0e,
    0x02, 0xa0, 0x31, 0x79, 0x98, 0x21, 0x0a, 0xd9, 0xba, 0x42, 0x65, 0x18, 0x67, 0x82, 0x79, 0xfe, 0x7e, 0x67, 0xc5,
    0x00, 0x02, 0xa8, 0x33, 0x24, 0x6b, 0xcb, 0x22, 0xd1, 0x50, 0x14, 0xaa, 0xad, 0xf5, 0x1d, 0xc4, 0x90, 0x40, 0x70,
    0xda, 0x9a, 0x9e, 0x91, 0xf2, 0x5e, 0xcf, 0x47, 0x25, 0x66, 0x36, 0x48, 0x50, 0x3b, 0xff, 0xfb, 0x84, 0x64, 0xec,
    0x09, 0x13, 0x81, 0x2a, 0x4a, 0xbb, 0xdb, 0x62, 0x58, 0x22, 0xc0, 0x18, 0xdc, 0x00, 0x00, 0x01, 0x0b, 0xc4, 0x8d,
    0x2e, 0x6e, 0x7b, 0x26, 0x20, 0x7a, 0x80, 0xa3, 0xb0, 0x30, 0x00, 0x04, 0x4c, 0x8d, 0x37, 0x83, 0xf4, 0x3b, 0x15,
    0x3b, 0x3e, 0x69, 0x03, 0xf3, 0xcd, 0x4d, 0xa3, 0xb8, 0x91, 0x8a, 0x9e, 0xbf, 0xce, 0x8e, 0x46, 0x7e, 0x55, 0xed,
    0x5d, 0xf7, 0xf7, 0x5b, 0x00, 0x0f, 0x41, 0x67, 0xa8, 0x83, 0xaf, 0x19, 0xff, 0xfa, 0xcd, 0x46, 0x23, 0xae, 0x05,
    0x45, 0x8b, 0x15, 0xb6, 0xed, 0xbd, 0x29, 0xd4, 0xc5, 0x56, 0x2a, 0x5d, 0xfc, 0xf1, 0xaf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x5f, 0x56, 0x3d, 0x80, 0x00, 0x00, 0x1f, 0xab, 0x00, 0x07, 0x54, 0xc0, 0x44, 0x0a, 0x4c,
    0x4f, 0x40, 0x10, 0x58, 0x02, 0x20, 0x73, 0x00, 0xc0, 0x99, 0x30, 0x82, 0x0e, 0x03, 0x01, 0x02, 0x84, 0x32, 0x85,
    0x9a, 0xd0, 0x20, 0x36, 0x9e, 0xa9, 0x71, 0xa7, 0x02, 0x98, 0x28, 0x12, 0x14, 0xa0, 0x19, 0x7e, 0xaf, 0x66, 0xa0,
    0x2a, 0x00, 0xad, 0x1d, 0xa3, 0x4a, 0x55, 0x10, 0x19, 0x12, 0x05, 0x25, 0xcb, 0xb9, 0x2f, 0x8b, 0x61, 0x36, 0x22,
    0xe6, 0x62, 0xa6, 0x87, 0xe6, 0x70, 0x5e, 0x9a, 0x05, 0x9a, 0x5c, 0x54, 0x8b, 0x68, 0x87, 0xa2, 0x80, 0xc0, 0xa4,
    0x70, 0xd2, 0x9a, 0x76, 0x8a, 0x9e, 0x2c, 0x8e, 0x9f, 0x8b, 0x51, 0x4d, 0x54, 0x04, 0xb2, 0x82, 0x50, 0xb1, 0xb3,
    0x4d, 0xbb, 0xff, 0xd7, 0xd3, 0x8a, 0xee, 0x47, 0x27, 0xd1, 0x10, 0x70, 0x59, 0x02, 0xff, 0x00, 0x01, 0x54, 0x9a,
    0x12, 0xcb, 0x88, 0x67, 0x36, 0x58, 0xc5, 0x94, 0x73, 0xd3, 0x24, 0xd1, 0x96, 0xea, 0x02, 0x0a, 0x7b, 0xaa, 0x00,
    0x47, 0x02, 0xa4, 0x33, 0x59, 0x82, 0x16, 0x9b, 0x60, 0x06, 0x0a, 0x8f, 0x24, 0x23, 0x32, 0x5e, 0x14, 0xd6, 0xb5,
    0x77, 0x8c, 0x23, 0x02, 0xe0, 0x04, 0x15, 0x03, 0xc0, 0x4e, 0xd4, 0x5b, 0xf6, 0x63, 0x5d, 0x47, 0x76, 0xc8, 0xda,
    0x8e, 0x59, 0x3d, 0x29, 0x40, 0xed, 0x91, 0x02, 0x54, 0x8e, 0xbd, 0x5b, 0x12, 0x49, 0xd1, 0x82, 0x52, 0xe5, 0x50,
    0x53, 0x62, 0xa1, 0xcb, 0x87, 0x28, 0x0c, 0xf2, 0x12, 0x0b, 0x5a, 0x6d, 0x55, 0xa6, 0x5c, 0x44, 0x8f, 0x99, 0x6a,
    0xc8, 0x1e, 0x7a, 0xf3, 0x32, 0xd8, 0x42, 0x59, 0xff, 0xfb, 0x74, 0x64, 0xfa, 0x04, 0x13, 0x16, 0x26, 0x4b, 0x1b,
    0x7e, 0x49, 0xe8, 0x22, 0xa0, 0x08, 0xec, 0x00, 0x00, 0x01, 0x0d, 0x5c, 0xb7, 0x2e, 0xef, 0x69, 0x29, 0x60, 0x7a,
    0x00, 0x23, 0xa4, 0x00, 0x00, 0x04, 0xcc, 0x3e, 0x50, 0x50, 0x4d, 0x20, 0x44, 0x4c, 0xb5, 0xf1, 0xbd, 0xa1, 0x12,
    0x01, 0x4d, 0xcb, 0xc1, 0x2b, 0x18, 0x9a, 0xad, 0x94, 0x12, 0xbc, 0x5d, 0x81, 0xfa, 0xdf, 0x9a, 0x79, 0x24, 0x35,
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x00, 0x01, 0x09, 0x5f, 0xfd, 0x00, 0x0c, 0x05,
    0x41, 0x6c, 0x0c, 0x1d, 0xcc, 0x48, 0xb9, 0xe4, 0xa0, 0xb4, 0x62, 0x86, 0x12, 0xe6, 0x0e, 0x01, 0x68, 0x6f, 0x44,
    0x57, 0x26, 0x18, 0x61, 0x7a, 0x29, 0x09, 0x6a, 0x9a, 0x2c, 0x14, 0xdc, 0x62, 0xcc, 0xa6, 0x14, 0x94, 0xf4, 0xb7,
    0x3b, 0x8a, 0x84, 0x15, 0x43, 0x31, 0x42, 0x8d, 0xd3, 0xc9, 0xa4, 0x3d, 0x9a, 0xfc, 0xbe, 0x86, 0xc6, 0x7c, 0xbb,
    0x16, 0x68, 0x90, 0x7e, 0x66, 0x95, 0x09, 0xf6, 0xe8, 0x27, 0x02, 0x58, 0xfd, 0x20, 0x3c, 0xd3, 0x8b, 0x65, 0xfa,
    0x33, 0x31, 0x78, 0xc2, 0x2f, 0xed, 0x63, 0x73, 0xbc, 0xaa, 0xfd, 0x45, 0x4a, 0x23, 0xae, 0xba, 0x2a, 0xea, 0xfb,
    0x40, 0x01, 0xc7, 0x1a, 0xb4, 0x1a, 0x48, 0x7a, 0xab, 0x6c, 0x43, 0x43, 0x6d, 0xc2, 0xb7, 0x9b, 0x60, 0xbe, 0xc7,
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x44, 0xf2, 0xb2, 0x00, 0x7a, 0x04, 0x6d, 0x33, 0x44,
    0x85, 0x00, 0x43, 0xb3, 0x03, 0x03, 0x0c, 0x56, 0xb5, 0x38, 0x1c, 0x48, 0xdb, 0xee, 0x83, 0xcd, 0x33, 0x99, 0x31,
    0x58, 0x11, 0x43, 0x99, 0x54, 0x33, 0x81, 0xd0, 0x48, 0x22, 0x26, 0x8a, 0x80, 0x43, 0xa8, 0x10, 0x91, 0x21, 0xea,
    0xff, 0xa0, 0xe3, 0x74, 0x2b, 0x00, 0x14, 0x07, 0x07, 0x30, 0x49, 0xae, 0x52, 0x6f, 0xe3, 0xbd, 0xdf, 0xd4, 0xab,
    0xf8, 0x7c, 0x3e, 0xa3, 0xd2, 0x2a, 0x19, 0x14, 0x06, 0xf7, 0x55, 0xff, 0xfb, 0x84, 0x64, 0xf0, 0x80, 0x13, 0xa7,
    0x26, 0x4a, 0x53, 0xdb, 0x4a, 0x58, 0x17, 0x20, 0x29, 0x0c, 0x0c, 0x00, 0x01, 0x0c, 0x8c, 0xab, 0x2e, 0xee, 0x79,
    0x67, 0xa0, 0x7e, 0x80, 0x63, 0xb0, 0x00, 0x00, 0x04, 0x87, 0xa1, 0x9a, 0x3b, 0xd0, 0xac, 0xff, 0xe8, 0xeb, 0xc7,
    0xf7, 0x95, 0xed, 0xfe, 0xac, 0x4a, 0xe4, 0x75, 0x6c, 0x63, 0x49, 0xab, 0x39, 0xd4, 0xd7, 0x3f, 0xf5, 0xbf, 0xdd,
    0xe4, 0xc3, 0x3d, 0x6a, 0x4b, 0x0a, 0x8f, 0x75, 0x3e, 0x9f, 0xf4, 0xfd, 0xdb, 0x20, 0x2d, 0xb4, 0xd4, 0x97, 0xe0,
    0x82, 0xc9, 0x49, 0x32, 0x81, 0x57, 0x38, 0x7c, 0xb0, 0xd6, 0x02, 0x5a, 0x5c, 0x71, 0x04, 0xb1, 0x45, 0x5e, 0x99,
    0x35, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4d, 0x4a, 0x40, 0x09, 0xfb, 0x20, 0x00, 0x2d, 0x22,
    0xc0, 0x72, 0x98, 0x1e, 0x80, 0xe0, 0x08, 0x08, 0xd0, 0x14, 0x60, 0x4c, 0x07, 0xa6, 0x45, 0x40, 0xb4, 0x60, 0xf4,
    0x56, 0x66, 0xf7, 0x4e, 0x9c, 0x42, 0x13, 0x26, 0x17, 0x80, 0x32, 0x60, 0x6e, 0x01, 0x80, 0x68, 0x51, 0x4a, 0x51,
    0x0d, 0x35, 0x49, 0x63, 0x38, 0x4c, 0xea, 0xd5, 0x58, 0xc3, 0xfa, 0xf0, 0x1c, 0x81, 0xc3, 0x93, 0x92, 0xec, 0xa9,
    0x63, 0xd4, 0xd5, 0x39, 0x2a, 0xce, 0xe7, 0xd2, 0x5c, 0x67, 0xd2, 0x79, 0x99, 0x88, 0x66, 0x49, 0x2e, 0x7c, 0xa3,
    0x31, 0x8a, 0x77, 0x95, 0x0f, 0x02, 0x4c, 0x00, 0xd5, 0xcc, 0xf8, 0xb3, 0x7c, 0x6f, 0x45, 0xf7, 0xec, 0xdd, 0x6c,
    0xcf, 0x13, 0x00, 0xfc, 0x28, 0x80, 0x8f, 0xb1, 0x3f, 0xfd, 0x9d, 0x49, 0xf8, 0xd7, 0xff, 0xfd, 0x50, 0x25, 0x52,
    0x46, 0xd0, 0x00, 0x00, 0x74, 0x47, 0x4b, 0x15, 0x79, 0xeb, 0x11, 0xe3, 0x08, 0xb8, 0x85, 0x4a, 0xd2, 0xf4, 0x7f,
    0xff, 0xff, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xff, 0xff, 0x3b, 0x54, 0x34, 0x11, 0x32, 0x6f, 0xfe, 0x00, 0x0a, 0x61,
    0x81, 0x44, 0x68, 0x39, 0x4d, 0xe5, 0xf6, 0x00, 0x12, 0x0c, 0x41, 0x17, 0x4c, 0x72, 0x45, 0x0c, 0xd8, 0xd1, 0xcc,
    0x30, 0x10, 0x0c, 0x63, 0x6d, 0xd0, 0x7e, 0x7f, 0x6b, 0xa2, 0x33, 0x2d, 0x6e, 0x16, 0xb3, 0xa7, 0x8f, 0x5a, 0x67,
    0x89, 0x86, 0xe3, 0xc8, 0x3a, 0xff, 0x93, 0xec, 0x48, 0x58, 0xc8, 0x96, 0x3a, 0x17, 0xc4, 0x31, 0xf9, 0x20, 0x14,
    0x70, 0xae, 0x23, 0xa2, 0x12, 0xff, 0xfb, 0x74, 0x64, 0xfe, 0x88, 0x13, 0x1c, 0x2a, 0x4c, 0x53, 0xd9, 0x4a, 0x7a,
    0x20, 0xc0, 0x08, 0xe9, 0x00, 0x00, 0x01, 0x0e, 0xe0, 0xab, 0x28, 0x6e, 0x7b, 0x66, 0x20, 0x90, 0x80, 0x63, 0xb0,
    0x10, 0x00, 0x04, 0xc9, 0xef, 0x12, 0x0f, 0x21, 0x12, 0xd5, 0xa7, 0x33, 0x8d, 0x61, 0x86, 0xaf, 0x7f, 0x17, 0xbc,
    0xc2, 0x25, 0x37, 0x3f, 0xc5, 0x8f, 0xb8, 0xc3, 0xb7, 0xbe, 0x4f, 0x5b, 0x21, 0xec, 0x90, 0xaa, 0xe3, 0x0d, 0xb7,
    0x04, 0x9d, 0xe0, 0x51, 0x12, 0x96, 0xf7, 0x38, 0xc1, 0xbd, 0x55, 0xee, 0x47, 0x35, 0x92, 0xe9, 0x26, 0xe6, 0xb3,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x52, 0x00, 0x00, 0x0c, 0xaa, 0x4b, 0xbf, 0xcc, 0x01, 0x34,
    0x41, 0x44, 0x9b, 0xe3, 0x96, 0xb5, 0x0c, 0x2a, 0x73, 0x63, 0x99, 0x8c, 0xf2, 0xe0, 0x3d, 0x9e, 0x70, 0x05, 0x19,
    0x31, 0x88, 0x6a, 0x85, 0x53, 0x30, 0x19, 0x0b, 0x2d, 0x70, 0x9a, 0xf4, 0x41, 0x95, 0x35, 0xed, 0xe3, 0xd8, 0x92,
    0xea, 0x9f, 0xa6, 0xa6, 0xb4, 0x24, 0x02, 0x89, 0xc4, 0x96, 0x48, 0x2a, 0xc1, 0x42, 0x60, 0x18, 0x71, 0x60, 0x24,
    0x8d, 0x22, 0x89, 0xc4, 0xac, 0x8a, 0x47, 0xa3, 0x87, 0x12, 0x5b, 0x91, 0xd2, 0x28, 0xa8, 0xa5, 0xbc, 0xa3, 0x68,
    0x65, 0x2c, 0x30, 0x0d, 0x2c, 0x9d, 0xc2, 0x91, 0x5e, 0xce, 0x92, 0x0a, 0x42, 0x31, 0x1b, 0x70, 0x00, 0x00, 0x0c,
    0x34, 0xe1, 0xa1, 0x0b, 0x9a, 0x9e, 0x6d, 0xe9, 0x4f, 0x38, 0xe5, 0x22, 0xf0, 0xa8, 0x00, 0x00, 0x09, 0x33, 0xbc,
    0x6d, 0xeb, 0x40, 0x00, 0xc3, 0x8c, 0x08, 0xbb, 0x17, 0x08, 0x8d, 0x09, 0x40, 0xc0, 0x23, 0x15, 0x20, 0xce, 0x2c,
    0x29, 0x81, 0x43, 0x69, 0xa2, 0x01, 0xc9, 0x84, 0xe0, 0xe8, 0x38, 0x04, 0x4e, 0x84, 0x71, 0x71, 0xa4, 0xce, 0x53,
    0x5d, 0x91, 0x4c, 0xbf, 0x92, 0xfb, 0xb0, 0x1a, 0x51, 0x4a, 0xc1, 0xa6, 0x87, 0x66, 0x7b, 0x1a, 0x59, 0x82, 0xd7,
    0x53, 0x66, 0x45, 0x8e, 0x33, 0x38, 0x23, 0xeb, 0xff, 0xfb, 0x84, 0x64, 0xec, 0x88, 0x13, 0xb3, 0x2a, 0xca, 0x3b,
    0xd9, 0x32, 0xf8, 0x21, 0x80, 0x08, 0xda, 0x00, 0x00, 0x00, 0x0c, 0xac, 0xab, 0x35, 0xae, 0xe1, 0x89, 0x60, 0x7e,
    0x00, 0x63, 0xf0, 0x20, 0x00, 0x04, 0x39, 0xb2, 0xa1, 0x66, 0xc1, 0xf0, 0xda, 0xde, 0x34, 0x02, 0x38, 0xc3, 0x47,
    0x1e, 0x0f, 0x9d, 0x61, 0x51, 0x1f, 0xb0, 0x6b, 0x2e, 0xfa, 0xbe, 0x9a, 0x1b, 0x75, 0x75, 0x57, 0x67, 0x6d, 0x7f,
    0xe9, 0x85, 0x00, 0x43, 0x92, 0xc8, 0xc0, 0x24, 0xa2, 0x75, 0xa6, 0x95, 0x0e, 0x0f, 0x1c, 0x15, 0x01, 0x3c, 0xd3,
    0xc3, 0x8e, 0x68, 0xd2, 0xee, 0x06, 0x99, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd7, 0x3e,
    0x42, 0x00, 0x00, 0x02, 0x36, 0x78, 0x8b, 0xf6, 0x8c, 0x00, 0x02, 0xe0, 0x53, 0x03, 0x9a, 0xce, 0x0c, 0x04, 0x31,
    0xb0, 0x78, 0xc2, 0x41, 0xc3, 0x2a, 0x36, 0x8d, 0x29, 0x37, 0x32, 0x78, 0x44, 0xdf, 0xe5, 0xf7, 0xb1, 0x11, 0x80,
    0x40, 0xe6, 0x0e, 0xf1, 0xb4, 0xf9, 0x13, 0x3e, 0x86, 0x0b, 0x7a, 0xcc, 0xea, 0xd5, 0x38, 0x4f, 0x37, 0x9c, 0x0c,
    0x91, 0x6d, 0x1e, 0x06, 0xfc, 0x4d, 0x32, 0xc5, 0x96, 0xb0, 0xd7, 0x71, 0xf1, 0x3f, 0x9f, 0x39, 0xb6, 0xa6, 0x83,
    0x0a, 0x59, 0xad, 0x89, 0xe9, 0x88, 0x59, 0xcc, 0xf5, 0xcd, 0xef, 0xbd, 0x6f, 0x11, 0x06, 0x25, 0xc5, 0x10, 0x95,
    0x95, 0x67, 0xe8, 0xf6, 0x74, 0xfb, 0xd5, 0xff, 0xe9, 0xa2, 0x18, 0x3d, 0xc8, 0xc0, 0x00, 0x00, 0x49, 0xe9, 0x02,
    0x1e, 0x24, 0x4b, 0xca, 0x90, 0x93, 0xb4, 0x6b, 0x43, 0xae, 0xb9, 0x8e, 0x3b, 0x70, 0x8c, 0x61, 0x2f, 0xff, 0xff,
    0xf7, 0xff, 0xff, 0xec, 0xff, 0xfe, 0xcf, 0xe9, 0xae, 0xdd, 0x25, 0x0c, 0x80, 0x00, 0x00, 0x50, 0x03, 0x02, 0xb9,
    0x9b, 0x1b, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x4e, 0x13, 0x21, 0x60, 0x64, 0x31, 0x2e, 0x01, 0x73,
    0x0c, 0x90, 0x59, 0x30, 0x5f, 0x33, 0x23, 0x2e, 0xe0, 0x16, 0x1a, 0x1c, 0x60, 0xc0, 0xa5, 0x33, 0x13, 0x22, 0xc3,
    0x03, 0x50, 0xc9, 0x32, 0x95, 0x1f, 0x43, 0x24, 0x36, 0x65, 0x30, 0x89, 0x04, 0xa2, 0x50, 0x01, 0x31, 0x47, 0x0d,
    0x72, 0x50, 0x2a, 0x32, 0xe5, 0x37, 0x43, 0x07, 0xf0, 0xb5, 0x98, 0x90, 0x99, 0xc8, 0xf8, 0x70, 0x38, 0x72, 0x58,
    0x29, 0xd5, 0xff, 0xfb, 0x74, 0x64, 0xf4, 0x00, 0x12, 0xfc, 0x26, 0xcc, 0xeb, 0x5c, 0x31, 0x78, 0x16, 0x20, 0x08,
    0xfd, 0x00, 0x00, 0x01, 0x0c, 0xec, 0x6b, 0x25, 0xee, 0x75, 0x25, 0xa0, 0x97, 0x00, 0x23, 0xb4, 0x00, 0x00, 0x04,
    0xdb, 0xe5, 0x40, 0xc0, 0xf3, 0x08, 0x12, 0x32, 0x02, 0x23, 0x18, 0x0b, 0x31, 0x15, 0x03, 0x27, 0x23, 0xd6, 0x3c,
    0x08, 0x24, 0x93, 0xbe, 0x87, 0x0c, 0xb6, 0x6a, 0x8f, 0x40, 0xc0, 0xcf, 0xfc, 0xbf, 0x6c, 0xb1, 0x22, 0xd8, 0x9c,
    0x8e, 0x1f, 0x5b, 0xec, 0x39, 0x73, 0x28, 0x13, 0x65, 0xff, 0xff, 0xff, 0xcf, 0x3b, 0x18, 0x7e, 0x16, 0x70, 0xc6,
    0xad, 0x53, 0xdc, 0x81, 0xf2, 0x65, 0x92, 0x0d, 0x0b, 0xf9, 0xa9, 0xc0, 0x19, 0x50, 0x56, 0xaf, 0xfa, 0x0f, 0x35,
    0xe8, 0xfe, 0x53, 0x4d, 0xa6, 0x25, 0xdb, 0x6d, 0x9f, 0xff, 0xf2, 0xe9, 0xb3, 0xff, 0xf1, 0x57, 0x20, 0x12, 0x69,
    0x80, 0x00, 0x08, 0x00, 0x69, 0x8f, 0x05, 0x00, 0xe4, 0xde, 0xef, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xdb, 0xff, 0xfd, 0x35, 0x80, 0x0d, 0xdf, 0xaa, 0x00, 0x18, 0x0b, 0x81, 0x50, 0x00, 0x06, 0x8c,
    0x02, 0x88, 0x24, 0xd3, 0xd4, 0x88, 0xcc, 0x14, 0x80, 0x94, 0xc1, 0x28, 0x14, 0xcc, 0x13, 0x01, 0x00, 0x1a, 0x00,
    0x06, 0x07, 0xe1, 0x36, 0x60, 0x02, 0x02, 0x26, 0x03, 0x40, 0xb6, 0x60, 0x70, 0x0e, 0x66, 0x7e, 0x87, 0x42, 0x62,
    0x2a, 0x0b, 0x46, 0x04, 0x00, 0x12, 0xa5, 0xa8, 0x52, 0xd1, 0x0b, 0x15, 0x12, 0x73, 0xbc, 0xbb, 0x89, 0x8b, 0xd9,
    0xaa, 0x49, 0x23, 0x29, 0x26, 0xd5, 0x0d, 0x97, 0x86, 0x92, 0x81, 0xc4, 0x97, 0xb2, 0x22, 0xcb, 0xa9, 0x6d, 0x9a,
    0xff, 0x66, 0x92, 0x0f, 0x9e, 0xfb, 0x7a, 0xc6, 0xdd, 0xcd, 0x5d, 0xa7, 0xd4, 0x8e, 0xd6, 0x15, 0x6c, 0x52, 0xe7,
    0xbd, 0x77, 0x0a, 0xd5, 0x6d, 0x6a, 0xdf, 0x7f, 0x1b, 0xc4, 0x1f, 0x0e, 0x34, 0x25, 0x20, 0x3d, 0x79, 0xfd, 0xa6,
    0xe9, 0x09, 0x46, 0xe2, 0x6e, 0xff, 0xfb, 0x94, 0x64, 0xf0, 0x80, 0x03, 0x38, 0x24, 0xc9, 0xfd, 0x71, 0xe0, 0x08,
    0x29, 0x20, 0x08, 0xca, 0xa0, 0x00, 0x00, 0x16, 0x20, 0x95, 0x2f, 0xf9, 0xed, 0x82, 0x40, 0x71, 0x00, 0x24, 0x13,
    0x00, 0x00, 0x00, 0xb8, 0xd1, 0x00, 0x00, 0x90, 0x4d, 0x04, 0x00, 0x24, 0x58, 0x62, 0x7d, 0x4d, 0x41, 0x92, 0x8f,
    0xbd, 0x2b, 0x30, 0x57, 0x16, 0xaf, 0x5a, 0xb6, 0xf8, 0xb0, 0x00, 0x02, 0xf6, 0x7f, 0x98, 0x39, 0x80, 0x50, 0x27,
    0x08, 0xcc, 0xe4, 0xd3, 0x6c, 0x3a, 0x8e, 0xa8, 0xb3, 0x10, 0x80, 0xce, 0x25, 0x04, 0x15, 0x37, 0xfb, 0x0c, 0xc8,
    0x81, 0x01, 0x13, 0x69, 0xb0, 0xc8, 0x55, 0x0d, 0x8c, 0x03, 0x80, 0x69, 0x01, 0x6c, 0x82, 0x0b, 0x67, 0x86, 0x00,
    0x40, 0x0c, 0x34, 0x01, 0x56, 0x19, 0x81, 0x10, 0x0a, 0xc4, 0x6a, 0xc0, 0x8e, 0xa8, 0x58, 0x01, 0xc0, 0x40, 0x01,
    0x3d, 0x0c, 0xaf, 0x6a, 0x56, 0x92, 0x85, 0x76, 0xa6, 0xd0, 0x66, 0x7e, 0xcd, 0x8b, 0x5b, 0x88, 0x5f, 0xce, 0x95,
    0xe7, 0x94, 0xd9, 0x9b, 0xc3, 0x91, 0x09, 0x4f, 0x22, 0x9b, 0xb3, 0x35, 0xcb, 0x35, 0xf3, 0xe6, 0x7c, 0xde, 0x76,
    0xbb, 0xfc, 0xdf, 0xda, 0x6a, 0x53, 0x22, 0x8a, 0x6d, 0x7c, 0x55, 0x0a, 0x65, 0xa4, 0xe2, 0x4f, 0x19, 0x40, 0x19,
    0xa3, 0xe6, 0x95, 0x4b, 0x45, 0x61, 0xf4, 0x3e, 0x28, 0x52, 0xd3, 0x21, 0x70, 0xe6, 0xab, 0x92, 0x54, 0x65, 0xab,
    0x85, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb3, 0xbe, 0x9a, 0x13, 0x02, 0xbb, 0x70, 0xba, 0xab, 0x7f, 0x98,
    0x00, 0x2c, 0x00, 0xe5, 0x80, 0x7a, 0x30, 0x0e, 0x41, 0x13, 0x1d, 0x50, 0xf4, 0x25, 0x02, 0x31, 0x18, 0x0f, 0x07,
    0x03, 0x19, 0x08, 0x00, 0x18, 0x56, 0x02, 0xa8, 0x18, 0x01, 0x42, 0x80, 0x20, 0x60, 0x52, 0x07, 0xe6, 0x13, 0x4b,
    0x26, 0x61, 0xa6, 0x05, 0xe1, 0x40, 0x04, 0x11, 0x8d, 0xc0, 0x4a, 0xb0, 0xaf, 0x16, 0xa5, 0xa6, 0x7c, 0x4d, 0x89,
    0x4c, 0x3b, 0x6e, 0x3b, 0x14, 0x17, 0x84, 0x81, 0xa3, 0xaa, 0x1b, 0x0d, 0xd1, 0x4b, 0x2e, 0x5e, 0x10, 0x39, 0xa0,
    0x6e, 0x9a, 0xf6, 0xa3, 0xc1, 0x45, 0x10, 0x95, 0x3c, 0xdb, 0xd0, 0x3a, 0x59, 0x5c, 0xb9, 0x02, 0xdb, 0xb4, 0x76,
    0x1e, 0xb9, 0xeb, 0xf5, 0x95, 0x74, 0xfe, 0xbe, 0xdd, 0x9f, 0x9a, 0xe6, 0x53, 0xfe, 0xd3, 0x4c, 0xe8, 0x1c, 0x50,
    0xb3, 0x90, 0x1e, 0x7f, 0x50, 0x24, 0x95, 0x00, 0x4b, 0x18, 0x00, 0x1c, 0xe3, 0x64, 0x00, 0x82, 0x44, 0xf4, 0x39,
    0xd1, 0x82, 0x7b, 0x7f, 0x6d, 0x15, 0x37, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x16, 0x24, 0x04,
    0x01, 0x2c, 0xb7, 0xfe, 0x30, 0x0b, 0xaa, 0x05, 0x14, 0xff, 0xfb, 0x84, 0x64, 0xef, 0x81, 0x13, 0xf8, 0x26, 0x4b,
    0xbf, 0x7b, 0x00, 0x08, 0x1d, 0xa0, 0x08, 0xfd, 0xe0, 0x00, 0x01, 0x0e, 0x64, 0x99, 0x31, 0x4f, 0x6b, 0xc2, 0xe0,
    0xab, 0x80, 0x23, 0x28, 0x00, 0x00, 0x00, 0x8c, 0x24, 0xb8, 0xcd, 0x94, 0x20, 0x0c, 0x12, 0x02, 0x59, 0x38, 0xf0,
    0x96, 0xc2, 0x41, 0xc9, 0x50, 0x00, 0x00, 0x51, 0x53, 0x04, 0x44, 0x23, 0x18, 0x64, 0xc2, 0x06, 0x02, 0x00, 0x88,
    0x00, 0xc7, 0x01, 0x13, 0x8c, 0x83, 0x42, 0xb7, 0x6c, 0xb1, 0x82, 0x82, 0xce, 0xc3, 0xad, 0xbc, 0x28, 0x85, 0x45,
    0xa1, 0x94, 0x3a, 0x69, 0x81, 0x19, 0x55, 0x78, 0x71, 0xfd, 0xa5, 0x2d, 0xfb, 0xf3, 0x6a, 0xee, 0xf9, 0x40, 0xd9,
    0xa6, 0xa2, 0x73, 0x15, 0xe5, 0x36, 0x35, 0x56, 0x07, 0xb7, 0xf3, 0xf4, 0xdf, 0x14, 0xde, 0xf0, 0xe5, 0x69, 0xac,
    0xbe, 0x27, 0xdf, 0xc7, 0x1f, 0xce, 0x8e, 0xfb, 0x41, 0xb0, 0xd8, 0x99, 0xc1, 0xc0, 0x99, 0x9b, 0x28, 0xb2, 0xfa,
    0xd3, 0xbb, 0x3f, 0x5c, 0x04, 0x35, 0x1b, 0x6e, 0xa8, 0x01, 0xd1, 0xe1, 0xd5, 0x34, 0x8b, 0x2c, 0x1a, 0x90, 0x3b,
    0xea, 0x2f, 0x55, 0xe3, 0xf3, 0x76, 0xcf, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x52,
    0x81, 0xff, 0x90, 0x00, 0x00, 0x00, 0x26, 0x02, 0x20, 0xc8, 0x60, 0x94, 0x62, 0x26, 0x88, 0xc0, 0xc8, 0x60, 0x70,
    0x00, 0x28, 0x02, 0x30, 0x22, 0x01, 0x05, 0x17, 0x30, 0xf0, 0x05, 0x80, 0xb8, 0x08, 0x83, 0x40, 0x38, 0xc0, 0x88,
    0x34, 0xcd, 0x24, 0x5b, 0x04, 0xc3, 0x18, 0x13, 0x41, 0xa0, 0x1c, 0x4a, 0x1b, 0xd5, 0x2c, 0x0b, 0x3a, 0xfd, 0xf9,
    0x01, 0x03, 0xd0, 0xc1, 0xcc, 0xe6, 0x17, 0x1a, 0x4c, 0x60, 0xf4, 0xe3, 0x4c, 0xb6, 0x3f, 0x15, 0x1c, 0x01, 0x3e,
    0xfe, 0x9c, 0x51, 0x16, 0xa5, 0x63, 0x58, 0xfe, 0x64, 0x49, 0x4a, 0x69, 0x4a, 0x56, 0xac, 0x8d, 0x0f, 0xe1, 0x9b,
    0x4d, 0x1d, 0x45, 0x63, 0xe3, 0xd7, 0x9e, 0x28, 0x32, 0x41, 0x75, 0x76, 0xe7, 0xa5, 0x6b, 0xa9, 0x66, 0x56, 0xd2,
    0xb0, 0xde, 0x2f, 0xa6, 0xe3, 0x2e, 0x1c, 0x17, 0x4c, 0x73, 0xec, 0xff, 0x40, 0x68, 0x30, 0x8b, 0x71, 0xc6, 0x00,
    0x00, 0x04, 0x92, 0x34, 0x32, 0xd6, 0xa5, 0xb4, 0x0a, 0x22, 0xc2, 0xc5, 0x31, 0x08, 0xca, 0xae, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfb, 0x94, 0x64, 0xe8, 0x00, 0x13, 0xcd, 0x2e, 0x4c, 0x1b, 0xd8, 0x63, 0x58, 0x20, 0x20,
    0x18, 0xec, 0x00, 0x00, 0x01, 0x0f, 0x1c, 0x9b, 0x35, 0x4e, 0xfb, 0x0a, 0x20, 0x88, 0x80, 0x63, 0xb0, 0x10, 0x00,
    0x04, 0xff, 0xff, 0xff, 0xb2, 0xcb, 0xb1, 0x82, 0x10, 0x58, 0x7b, 0xf6, 0x00, 0x60, 0xa6, 0x00, 0x60, 0x38, 0x60,
    0x30, 0x18, 0xe1, 0xcc, 0xaa, 0x50, 0x07, 0x25, 0xf7, 0x30, 0x10, 0x00, 0x34, 0xdc, 0x30, 0x4f, 0x07, 0x10, 0x30,
    0x01, 0x22, 0x69, 0x80, 0xa8, 0x1e, 0x1a, 0x22, 0x1a, 0x91, 0x84, 0x18, 0x0d, 0x02, 0x80, 0x85, 0x18, 0x97, 0x2b,
    0x8e, 0x08, 0x23, 0x16, 0x94, 0x96, 0x04, 0x96, 0x31, 0x48, 0xac, 0xe4, 0x51, 0x17, 0xc2, 0x4d, 0x76, 0x59, 0x02,
    0x5a, 0x49, 0x78, 0x3a, 0x9a, 0x68, 0x2c, 0xa9, 0x76, 0x39, 0xff, 0xdd, 0x75, 0xa8, 0x66, 0x19, 0x09, 0xf0, 0x26,
    0xe2, 0x31, 0x5a, 0x67, 0x72, 0x13, 0x3b, 0x86, 0x74, 0x1f, 0x41, 0x4b, 0x98, 0x5d, 0x98, 0x79, 0x3b, 0x62, 0xa4,
    0x31, 0x8b, 0xd4, 0xb2, 0x17, 0x97, 0x89, 0x06, 0x65, 0x01, 0x49, 0xc8, 0x82, 0x7f, 0xe3, 0x45, 0xd8, 0x83, 0xe7,
    0x56, 0xd6, 0xed, 0x51, 0x2b, 0x8c, 0x31, 0x6b, 0x2c, 0xe6, 0x4e, 0xf1, 0x41, 0xa9, 0x4d, 0xa1, 0x08, 0x4b, 0xfb,
    0x00, 0x3c, 0x80, 0xe0, 0x0a, 0x04, 0x06, 0x51, 0x96, 0x60, 0x1a, 0x81, 0x80, 0xe0, 0x0a, 0x02, 0x05, 0x60, 0x2a,
    0xa6, 0xe1, 0x50, 0x7c, 0x1e, 0x01, 0x12, 0xd7, 0x18, 0x12, 0x00, 0x49, 0xa6, 0xe8, 0x7e, 0x81, 0x86, 0x80, 0x58,
    0x04, 0x81, 0x44, 0x68, 0x6e, 0xe8, 0xe8, 0x9f, 0x2e, 0x96, 0x08, 0xde, 0xcb, 0x25, 0x92, 0x69, 0xd4, 0x8d, 0x0c,
    0x85, 0x99, 0x55, 0x2f, 0x55, 0x52, 0xe6, 0x77, 0x8b, 0xb4, 0xab, 0x3b, 0x49, 0xfb, 0xba, 0xfe, 0x10, 0xa1, 0xcc,
    0xad, 0xec, 0x11, 0xe7, 0x74, 0xda, 0xdf, 0xf7, 0xe6, 0xca, 0x5a, 0xd8, 0xf2, 0xe6, 0xc2, 0xbe, 0x8f, 0x6c, 0xe2,
    0x0f, 0x74, 0xd6, 0xc8, 0x5f, 0xf6, 0xcc, 0x61, 0xf9, 0xd7, 0x2c, 0x11, 0xed, 0xa5, 0xa8, 0xd0, 0x2a, 0x60, 0x00,
    0x28, 0x0c, 0x9f, 0x1c, 0xc6, 0xa0, 0xff, 0xcb, 0xe1, 0xdf, 0x45, 0x16, 0x50, 0xa7, 0x96, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xd1, 0xb7, 0x42, 0xd2, 0x66, 0x18, 0x00, 0x02, 0x17, 0xfe, 0x00, 0x18, 0xc0, 0x04, 0x26,
    0x05, 0xcf, 0x1f, 0xe0, 0x92, 0x60, 0x20, 0x10, 0x8c, 0x4a, 0x62, 0xa1, 0x51, 0x00, 0x40, 0xc8, 0x05, 0xb4, 0x37,
    0x2e, 0x21, 0x8a, 0x42, 0xe6, 0x97, 0x45, 0x56, 0x61, 0x7e, 0x04, 0x22, 0xc0, 0x70, 0x10, 0x00, 0xeb, 0x52, 0x06,
    0x15, 0x00, 0x57, 0x93, 0x32, 0xc0, 0x01, 0xff, 0xfb, 0x84, 0x64, 0xfb, 0x88, 0x13, 0xf5, 0x2e, 0x4b, 0x9b, 0xd9,
    0x63, 0x58, 0x22, 0xc0, 0x18, 0xed, 0x04, 0x00, 0x01, 0x0e, 0x7c, 0xbf, 0x35, 0xaf, 0x61, 0x2d, 0x60, 0x61, 0x80,
    0x23, 0xf0, 0x00, 0x00, 0x04, 0x41, 0xf3, 0x10, 0x45, 0xea, 0x77, 0x00, 0x68, 0x0a, 0x6c, 0x53, 0x48, 0x3d, 0x97,
    0xcb, 0xac, 0xc7, 0x49, 0x40, 0x76, 0x57, 0xae, 0xf3, 0x7e, 0xbe, 0xf3, 0x3b, 0x77, 0xe0, 0x41, 0x0e, 0x0f, 0xa7,
    0xd2, 0x3b, 0xd2, 0x50, 0xe3, 0x65, 0xec, 0xc4, 0x84, 0x4d, 0x84, 0x13, 0xd2, 0x46, 0x6c, 0x76, 0xec, 0x7d, 0x5a,
    0x71, 0xc1, 0xd4, 0x26, 0x18, 0xc5, 0xb9, 0xd8, 0x0f, 0x7e, 0x7b, 0xb7, 0x50, 0x69, 0x49, 0x23, 0x9f, 0x03, 0x50,
    0x98, 0x68, 0x22, 0x41, 0xa8, 0x3e, 0x01, 0x24, 0xcd, 0xb2, 0x4d, 0xdb, 0xe8, 0x35, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x6a, 0x0d, 0x00, 0x45, 0x05, 0xbf, 0x80, 0x06, 0xe4, 0x42, 0x15, 0x30, 0x9f, 0xd8,
    0xdb, 0x04, 0x70, 0x00, 0x70, 0x84, 0x74, 0x61, 0x60, 0x9b, 0x34, 0x33, 0x38, 0xe1, 0x60, 0x01, 0x20, 0x93, 0x00,
    0x14, 0x8c, 0xf4, 0x53, 0x38, 0xc2, 0xc8, 0x12, 0x11, 0xbc, 0x38, 0x00, 0x18, 0x9a, 0xf0, 0x2e, 0x4a, 0xff, 0x90,
    0x22, 0xf2, 0x85, 0xd3, 0x41, 0x51, 0x78, 0x58, 0xc8, 0x01, 0x16, 0xce, 0x45, 0x7d, 0xe7, 0xdb, 0x41, 0x72, 0x72,
    0x95, 0x17, 0x41, 0x42, 0xec, 0xef, 0xff, 0x4b, 0xc9, 0x89, 0xee, 0x2f, 0x80, 0x41, 0xd2, 0x36, 0x4a, 0xd7, 0xe4,
    0xd2, 0xad, 0x52, 0xe9, 0x0c, 0x56, 0x62, 0x44, 0xdb, 0x45, 0x26, 0x2e, 0x20, 0x98, 0x82, 0xad, 0xb9, 0xdb, 0x5d,
    0xec, 0x6a, 0x54, 0xd3, 0x29, 0x08, 0x52, 0x11, 0x26, 0x07, 0x1a, 0xfa, 0x00, 0x05, 0x08, 0x16, 0x51, 0x20, 0x9e,
    0x11, 0x08, 0xb6, 0xf3, 0xef, 0x51, 0x44, 0xc8, 0x51, 0xde, 0xaf, 0x47, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0x91, 0x00, 0x01, 0x82, 0x20, 0xb7, 0xa7, 0x30, 0xa0, 0xc4, 0xc4, 0xbe, 0xa3, 0x63, 0x93, 0x4c, 0x0e,
    0x20, 0x10, 0x85, 0x49, 0x89, 0x4b, 0xa8, 0x14, 0xd1, 0x40, 0x59, 0x08, 0x20, 0xc0, 0xc8, 0xd3, 0x22, 0x25, 0x49,
    0x30, 0x6e, 0x04, 0xf2, 0x50, 0x04, 0x5a, 0x65, 0xf6, 0x5c, 0xea, 0xcd, 0x22, 0xea, 0x6f, 0x0f, 0x00, 0x74, 0x6a,
    0x55, 0xff, 0xfb, 0x84, 0x64, 0xfa, 0x80, 0x13, 0x86, 0x2f, 0xcd, 0x3b, 0xd8, 0x63, 0x58, 0x21, 0x00, 0x08, 0xd9,
    0x00, 0x00, 0x01, 0x0e, 0xf0, 0xbf, 0x35, 0x4e, 0x79, 0x6b, 0xa8, 0x7c, 0x80, 0x63, 0xf0, 0x10, 0x00, 0x04, 0x47,
    0xd7, 0x68, 0x58, 0x04, 0xa8, 0xf0, 0x96, 0xde, 0x50, 0x67, 0x1a, 0x2d, 0x40, 0x17, 0x00, 0x87, 0xeb, 0xb9, 0x7f,
    0xe4, 0x76, 0x34, 0x70, 0xe4, 0x88, 0x28, 0x22, 0x9c, 0xaa, 0xdf, 0xdb, 0xba, 0x54, 0x1a, 0x15, 0x88, 0x1e, 0x8e,
    0x76, 0xa2, 0xbc, 0x4d, 0xe4, 0x0d, 0xee, 0xba, 0x88, 0x81, 0xe8, 0x51, 0x57, 0x91, 0xa4, 0xa0, 0x94, 0x0d, 0xb0,
    0xdc, 0x61, 0x2d, 0x34, 0x87, 0x9d, 0xd4, 0xc9, 0xce, 0x11, 0xb9, 0xb7, 0xc4, 0x07, 0x44, 0x0b, 0x6b, 0xb2, 0x75,
    0x01, 0x80, 0x00, 0x8a, 0x57, 0xff, 0xcc, 0x00, 0xb0, 0xc1, 0x40, 0x9c, 0xc3, 0x56, 0xe8, 0xe0, 0x10, 0xe4, 0xd9,
    0x92, 0x30, 0xcc, 0x49, 0x07, 0x10, 0x0c, 0x32, 0xe2, 0x0c, 0x28, 0x80, 0xb0, 0xf3, 0x2f, 0xd8, 0xc2, 0x19, 0x30,
    0x0c, 0x20, 0xc0, 0xc0, 0x04, 0x02, 0x2a, 0xe9, 0xdd, 0xb6, 0x05, 0x00, 0x46, 0xb9, 0x19, 0x78, 0x87, 0x80, 0x3a,
    0x45, 0x7e, 0xfc, 0x84, 0x80, 0x00, 0xd2, 0x72, 0x33, 0x0d, 0x34, 0x28, 0xeb, 0x29, 0x74, 0x29, 0x61, 0x94, 0x6f,
    0x5c, 0x36, 0xb9, 0xde, 0x50, 0x5e, 0xb9, 0x2e, 0x81, 0x6b, 0xee, 0xa7, 0xd5, 0x90, 0x61, 0xaa, 0xf8, 0xea, 0x9b,
    0x0f, 0xab, 0xff, 0xce, 0x76, 0xad, 0x16, 0x7c, 0xe6, 0xf0, 0xd7, 0xea, 0xd2, 0xcb, 0x97, 0x08, 0xc0, 0xe8, 0xb1,
    0xa9, 0xfd, 0xc9, 0x04, 0xa4, 0x96, 0x47, 0x64, 0x40, 0x00, 0x18, 0xc1, 0xf9, 0xb7, 0xcb, 0xed, 0xd8, 0x2f, 0xcd,
    0xba, 0xdf, 0x7f, 0xd1, 0x8c, 0x96, 0x0c, 0x3e, 0xf0, 0x6d, 0xde, 0xe7, 0xcb, 0xf3, 0xfb, 0x33, 0x40, 0x1b, 0x8b,
    0xeb, 0x00, 0x02, 0xdb, 0x18, 0x08, 0x02, 0xa9, 0x83, 0xa8, 0xe9, 0x1a, 0x7f, 0x81, 0xa8, 0x40, 0x37, 0x18, 0x05,
    0x00, 0x41, 0x82, 0xa0, 0x0f, 0x95, 0x00, 0x40, 0xc0, 0x40, 0x11, 0xcc, 0x03, 0x80, 0x44, 0xc0, 0x44, 0x06, 0x8c,
    0x13, 0x82, 0x5c, 0xd0, 0x15, 0x95, 0x4c, 0x48, 0x80, 0xdc, 0xc0, 0x94, 0x00, 0x82, 0x22, 0xaf, 0x9a, 0xc1, 0x54,
    0x6c, 0x16, 0x55, 0x54, 0x89, 0xd4, 0xf3, 0x36, 0x38, 0xec, 0x93, 0x36, 0xf2, 0xa3, 0xff, 0xfb, 0x74, 0x64, 0xfc,
    0x01, 0x13, 0x97, 0x2f, 0xcd, 0x53, 0x9e, 0x5a, 0xe8, 0x21, 0x40, 0x08, 0xec, 0x00, 0x00, 0x01, 0x0d, 0xb4, 0xbf,
    0x35, 0xae, 0x79, 0x0b, 0xa0, 0x5a, 0x80, 0x23, 0xf4, 0x00, 0x00, 0x04, 0x6b, 0x74, 0xa9, 0x70, 0x8c, 0xf1, 0x1b,
    0xa8, 0xcb, 0x77, 0x5f, 0xff, 0xa0, 0x83, 0x1c, 0xcd, 0x41, 0x94, 0xfc, 0x7a, 0x22, 0x1b, 0x5c, 0x95, 0x67, 0x21,
    0x5a, 0x90, 0xce, 0x39, 0x92, 0x94, 0xe5, 0x68, 0x16, 0x1b, 0x56, 0xb8, 0x9a, 0x22, 0x19, 0x6d, 0xcb, 0xfe, 0x15,
    0x52, 0x10, 0x41, 0xa8, 0xb6, 0xf7, 0x8c, 0x1a, 0x3c, 0xb6, 0xed, 0x2a, 0xef, 0x44, 0x83, 0x3f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x95, 0x00, 0x00, 0x00, 0x8e, 0xfb, 0xf5, 0x80, 0x00, 0xbd, 0x8c, 0x02, 0x80,
    0x9c, 0xc1, 0x24, 0x2f, 0x4d, 0x1c, 0xc0, 0x88, 0x48, 0x13, 0x8c, 0x09, 0x80, 0x90, 0x80, 0x05, 0x00, 0x40, 0x12,
    0x60, 0xca, 0x05, 0xc1, 0x80, 0x14, 0x1c, 0x03, 0x26, 0x07, 0x60, 0x30, 0x69, 0x08, 0x50, 0x43, 0x43, 0xb6, 0x44,
    0x08, 0xa3, 0x4e, 0x53, 0xd0, 0xb1, 0x12, 0xd4, 0xda, 0xca, 0xb3, 0x91, 0x0a, 0x6e, 0x32, 0x9e, 0x0f, 0xd1, 0x29,
    0x02, 0x8b, 0x98, 0x8a, 0xa8, 0x64, 0x51, 0x1f, 0x98, 0x24, 0x0d, 0x4c, 0x5d, 0x44, 0x62, 0xb3, 0x85, 0x7b, 0x53,
    0x4d, 0xed, 0xc9, 0xa9, 0xd9, 0x56, 0xa7, 0x37, 0x71, 0x94, 0xc2, 0x11, 0x24, 0x55, 0x2c, 0xb8, 0x12, 0x8c, 0x22,
    0x46, 0xfb, 0x7e, 0x84, 0xe1, 0xaf, 0x66, 0x31, 0x1b, 0x92, 0x38, 0xe5, 0xa0, 0x00, 0x02, 0x19, 0xf9, 0x53, 0x07,
    0x3b, 0x77, 0xf3, 0xcc, 0xff, 0xbf, 0xfe, 0xf7, 0xbf, 0xb2, 0x9b, 0x95, 0x7c, 0x0e, 0x6b, 0x38, 0x15, 0xa0, 0x00,
    0x00, 0x28, 0xfc, 0xde, 0xd0, 0x00, 0x58, 0x73, 0x05, 0x00, 0x13, 0x05, 0x61, 0x53, 0xcc, 0x45, 0x42, 0x20, 0xfc,
    0xc0, 0x71, 0xb0, 0xc1, 0x20, 0xfc, 0x48, 0x15, 0x0e, 0x2c, 0x54, 0xd8, 0x94, 0x0d, 0x1d, 0x01, 0xcf, 0xff, 0xfb,
    0x84, 0x64, 0xed, 0x80, 0x13, 0xa3, 0x27, 0xcc, 0xeb, 0xba, 0xf0, 0xb8, 0x21, 0x00, 0x19, 0x0d, 0x04, 0x00, 0x01,
    0x4e, 0x0c, 0x99, 0x28, 0xef, 0x61, 0x2d, 0x60, 0x7e, 0x00, 0x23, 0xf0, 0x00, 0x00, 0x04, 0xd1, 0x6b, 0x0c, 0xe8,
    0x0f, 0x8c, 0x15, 0x04, 0xe2, 0x68, 0x03, 0xbe, 0x16, 0x14, 0x8e, 0x88, 0x84, 0x2f, 0x3b, 0x73, 0x95, 0xbf, 0xb6,
    0xe1, 0xa2, 0x8d, 0x45, 0xdc, 0xb2, 0xd1, 0xb0, 0x34, 0x75, 0x65, 0x6e, 0x3d, 0x41, 0x90, 0x5a, 0xaf, 0xb9, 0x7d,
    0x7a, 0xe1, 0x0c, 0x70, 0x59, 0xe4, 0xcf, 0x3f, 0x6c, 0xbd, 0x26, 0x98, 0x19, 0x33, 0xd3, 0xc5, 0x48, 0x68, 0x58,
    0xfc, 0x25, 0x5c, 0x7d, 0xe0, 0x40, 0xf9, 0x48, 0x54, 0x12, 0x04, 0x24, 0xc4, 0xa6, 0x03, 0xaf, 0x1a, 0x58, 0x23,
    0x32, 0x95, 0x8d, 0xd4, 0x08, 0x54, 0xc6, 0xb8, 0xbb, 0x5a, 0xb5, 0x7b, 0x05, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfd, 0x5a, 0xba, 0x4d, 0x17, 0x41, 0x80, 0x00, 0x2a, 0x59, 0xbe, 0xa0, 0x00, 0x30, 0x11, 0x06, 0x0c,
    0x00, 0x9d, 0x4d, 0x7b, 0x1e, 0x0c, 0x13, 0x0a, 0x4c, 0x0f, 0x06, 0xcc, 0x93, 0x08, 0xc0, 0x40, 0x11, 0x84, 0xa1,
    0x08, 0x18, 0x05, 0x48, 0x53, 0x0b, 0x8c, 0xf3, 0x7e, 0xa4, 0x73, 0x3a, 0x06, 0x50, 0xe0, 0x10, 0x1d, 0x07, 0x87,
    0xe2, 0x08, 0x19, 0x24, 0x83, 0x50, 0xa4, 0xf6, 0x8b, 0x8c, 0x8c, 0x4b, 0x26, 0x2b, 0x5d, 0x92, 0x50, 0x84, 0x4e,
    0x31, 0x3d, 0x52, 0xec, 0x56, 0xfc, 0x69, 0x6a, 0xd8, 0x9d, 0x9d, 0xb6, 0x34, 0xb5, 0xd7, 0x56, 0xf5, 0x62, 0xba,
    0xea, 0xa1, 0xd5, 0x96, 0x7b, 0xc7, 0x82, 0x82, 0xe9, 0xd8, 0xeb, 0xab, 0x6b, 0xda, 0x05, 0x44, 0x27, 0xb8, 0x00,
    0x05, 0x54, 0x04, 0x2e, 0x24, 0xb7, 0xa8, 0x66, 0xd7, 0xa5, 0xae, 0x27, 0xb4, 0x90, 0xf4, 0x1f, 0xba, 0x5b, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x7f, 0xba, 0xf6, 0x2d, 0x13, 0x28, 0x34, 0x82, 0x4b, 0x00, 0x00, 0x00, 0x03,
    0x58, 0x6f, 0xf4, 0x68, 0x00, 0x00, 0x80, 0x16, 0x09, 0x03, 0x43, 0x08, 0x24, 0xef, 0x31, 0xe6, 0x10, 0x43, 0x01,
    0x81, 0x30, 0xa9, 0x06, 0x60, 0x01, 0xb0, 0x38, 0x11, 0x98, 0x6e, 0x38, 0x20, 0x00, 0x70, 0x0d, 0x0a, 0x08, 0x06,
    0x35, 0xc8, 0x41, 0x80, 0x92, 0xc5, 0x0f, 0xe2, 0x7a, 0x92, 0x0a, 0xff, 0xfb, 0x84, 0x64, 0xf0, 0x80, 0x13, 0x8e,
    0x23, 0x4a, 0xeb, 0xd8, 0x1b, 0x6a, 0x1d, 0x60, 0x09, 0x0d, 0x00, 0x00, 0x01, 0x4d, 0x78, 0x81, 0x2d, 0xae, 0xe0,
    0xcd, 0x68, 0x90, 0x80, 0x23, 0x70, 0x00, 0x00, 0x04, 0x0f, 0x52, 0x83, 0x84, 0x11, 0x05, 0x09, 0x89, 0xb8, 0x8a,
    0x41, 0x2b, 0x3b, 0xd7, 0xc7, 0x39, 0x9a, 0xc2, 0xb7, 0x3b, 0xf8, 0x8f, 0x15, 0xb4, 0xdb, 0xfd, 0x37, 0xdd, 0xd5,
    0xb1, 0x5d, 0x3d, 0x30, 0x78, 0x3e, 0x4d, 0x80, 0x9b, 0x9a, 0xc2, 0x05, 0xdd, 0xbb, 0x21, 0x7a, 0xff, 0xba, 0x31,
    0x5d, 0x62, 0xca, 0xfa, 0x3f, 0x66, 0x53, 0x77, 0xd8, 0xad, 0xb2, 0xfb, 0x13, 0x80, 0x11, 0xb1, 0x22, 0x4d, 0x84,
    0xcd, 0x97, 0x4b, 0x55, 0x25, 0xd3, 0x8c, 0x68, 0x11, 0x20, 0x10, 0xf2, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0x2a, 0x14, 0xa5, 0x00, 0x00, 0x04, 0xb7, 0x7f, 0xf3, 0x40, 0x00, 0x60, 0x04, 0x01, 0x26, 0x01,
    0x60, 0x90, 0x61, 0x7c, 0x7b, 0x26, 0x9e, 0x81, 0x8c, 0x61, 0x90, 0x46, 0x60, 0xc0, 0xdc, 0x71, 0xa0, 0x2e, 0x2c,
    0x3a, 0x19, 0x04, 0x0d, 0x98, 0x36, 0x00, 0x96, 0x00, 0x01, 0x40, 0x9c, 0xcc, 0xf8, 0xec, 0x42, 0x08, 0xab, 0x11,
    0x28, 0x0a, 0xfb, 0x41, 0xaa, 0xcb, 0x0b, 0x8d, 0x08, 0x83, 0x66, 0x54, 0xd9, 0x74, 0x60, 0x7d, 0x70, 0xfa, 0x74,
    0x55, 0x1c, 0xd6, 0x4b, 0xee, 0xb0, 0x54, 0x2f, 0xba, 0xdf, 0xae, 0xd3, 0x86, 0xa2, 0xbf, 0x2e, 0x61, 0x97, 0xe2,
    0xbf, 0x5f, 0xfe, 0x8e, 0x51, 0x60, 0x12, 0xe2, 0x10, 0x18, 0x26, 0x48, 0x6e, 0x12, 0xf5, 0xe8, 0xfb, 0xbd, 0x9c,
    0x72, 0x1a, 0x97, 0xd3, 0xf6, 0xee, 0x29, 0xff, 0xea, 0x45, 0x42, 0x18, 0x01, 0xa8, 0xc0, 0x00, 0x00, 0xc5, 0x34,
    0x12, 0x71, 0x97, 0x37, 0xcb, 0xdb, 0xac, 0x2a, 0x58, 0xd9, 0x96, 0x9c, 0x48, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xee, 0xf7, 0xf6, 0x28, 0x0d, 0xa5, 0xbe, 0xd1, 0x80, 0x85, 0x38, 0x72, 0x30, 0xd0, 0x19, 0x13,
    0x63, 0x00, 0x30, 0x32, 0xc0, 0x5c, 0xc5, 0xed, 0xc3, 0x96, 0xcc, 0xcc, 0x2e, 0x16, 0x33, 0xf8, 0xec, 0x74, 0x08,
    0x97, 0xa6, 0x27, 0x12, 0x1e, 0xcb, 0x98, 0x62, 0x90, 0xa3, 0x01, 0x49, 0xe8, 0x26, 0x9c, 0xbd, 0x88, 0x5c, 0xfa,
    0xa4, 0xd0, 0x90, 0xa6, 0x24, 0xff, 0xfb, 0x84, 0x64, 0xf7, 0x00, 0x13, 0x30, 0x22, 0xcb, 0xeb, 0x1d, 0x60, 0x5a,
    0x27, 0x00, 0x08, 0xc9, 0x00, 0x00, 0x00, 0x0d, 0xd0, 0x6b, 0x25, 0xef, 0x75, 0xe3, 0x20, 0x89, 0x00, 0x63, 0x68,
    0x10, 0x00, 0x04, 0x9c, 0xb4, 0x96, 0x20, 0xd4, 0xce, 0xdc, 0x8e, 0x2b, 0x32, 0xfb, 0xcd, 0x5d, 0xce, 0x51, 0x5a,
    0x63, 0x0b, 0xb1, 0xee, 0xfe, 0x3a, 0xad, 0x9f, 0xd8, 0xa4, 0xb2, 0x30, 0x91, 0x85, 0x89, 0x90, 0x4c, 0x1f, 0x30,
    0xf7, 0x90, 0x3f, 0xb0, 0xac, 0xcd, 0xff, 0xa5, 0x1f, 0xd2, 0x8b, 0x7f, 0xdf, 0xe9, 0x6a, 0x2a, 0x21, 0xf1, 0x86,
    0x03, 0xef, 0x0d, 0x1b, 0x74, 0x03, 0xf3, 0x58, 0xd5, 0x07, 0xd5, 0x72, 0x7c, 0xa9, 0x1b, 0x61, 0xbf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa6, 0xb5, 0x00, 0x00, 0x00, 0x06, 0x68, 0x8f, 0xf5, 0x6c, 0x00, 0x16, 0x61,
    0x80, 0x78, 0x06, 0x18, 0x56, 0x0f, 0x91, 0xae, 0x20, 0x3f, 0x98, 0x2d, 0x00, 0xf1, 0x82, 0x48, 0x55, 0x99, 0x56,
    0x86, 0x01, 0x82, 0x58, 0x10, 0x98, 0x5c, 0x32, 0x09, 0x03, 0x88, 0xae, 0x60, 0xf0, 0x12, 0x71, 0x19, 0x96, 0x02,
    0x2d, 0x52, 0x08, 0x20, 0x21, 0x2f, 0xd3, 0x34, 0x1d, 0x03, 0x1f, 0x29, 0xf4, 0xa9, 0x26, 0x01, 0x65, 0x4c, 0xe5,
    0xfd, 0x7d, 0x60, 0xb4, 0x24, 0x5d, 0xbf, 0x84, 0x3e, 0xe9, 0xcb, 0xe8, 0x4f, 0x15, 0x0f, 0x0c, 0x05, 0x54, 0x8a,
    0x34, 0xdb, 0x73, 0x58, 0x76, 0x31, 0x1d, 0x89, 0xef, 0x75, 0x49, 0xd3, 0x65, 0xeb, 0xaf, 0x3c, 0xe0, 0x68, 0xca,
    0x42, 0x67, 0xee, 0x11, 0x32, 0xeb, 0x93, 0x45, 0xdd, 0xd7, 0xeb, 0xed, 0xb9, 0x7a, 0xb7, 0x6a, 0x60, 0xa4, 0x98,
    0xbb, 0x6b, 0xa8, 0x00, 0x00, 0x8c, 0xe5, 0x29, 0x13, 0xa7, 0x5e, 0x7a, 0x1b, 0x68, 0x58, 0xce, 0x2e, 0x07, 0x58,
    0x1e, 0x05, 0x72, 0x32, 0x4d, 0xca, 0xb4, 0xfb, 0x48, 0x60, 0x00, 0x02, 0x00, 0xf2, 0xff, 0xef, 0x02, 0xe0, 0xd1,
    0x30, 0x54, 0x62, 0x06, 0x70, 0x7a, 0x31, 0xa6, 0x60, 0x50, 0x58, 0x60, 0xe1, 0x8e, 0x70, 0x62, 0x14, 0x0a, 0x13,
    0x4c, 0x48, 0x0a, 0xd0, 0x16, 0x23, 0x00, 0x12, 0x34, 0xdf, 0x24, 0x74, 0x1c, 0x71, 0xa7, 0x83, 0x1f, 0x81, 0x28,
    0xc0, 0x21, 0x0e, 0x03, 0xee, 0xd3, 0xc7, 0xab, 0x06, 0x40, 0xb1, 0x5a, 0x08, 0xf2, 0x66, 0xd2, 0x38, 0x10, 0xff,
    0xfb, 0x74, 0x64, 0xfe, 0x09, 0x13, 0xa8, 0x20, 0x49, 0x6b, 0xdd, 0x60, 0xe8, 0x23, 0xc0, 0x08, 0xdd, 0x00, 0x00,
    0x01, 0x0d, 0x1c, 0x6b, 0x25, 0xec, 0xfb, 0x80, 0x20, 0x7b, 0x80, 0x23, 0xa8, 0x00, 0x00, 0x04, 0xb1, 0x28, 0x40,
    0xb2, 0x0a, 0x44, 0x85, 0x07, 0xd3, 0xc1, 0xe3, 0xcf, 0x79, 0x59, 0x18, 0xf4, 0x61, 0x28, 0x94, 0xdd, 0x2b, 0x4c,
    0xa6, 0x66, 0xf3, 0x32, 0xb2, 0x95, 0xdf, 0xfb, 0xc2, 0x6b, 0x91, 0x5a, 0xb5, 0x7f, 0xa3, 0xfd, 0xbf, 0x4d, 0x7f,
    0xff, 0xf5, 0xa7, 0xe4, 0x77, 0x24, 0x60, 0x51, 0x80, 0x22, 0x80, 0xfc, 0x5c, 0xed, 0x0e, 0xbc, 0xe4, 0x58, 0x3e,
    0x70, 0x99, 0x93, 0x87, 0x94, 0x84, 0xb8, 0xfa, 0x8d, 0xa4, 0xda, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xdc, 0xa5, 0x60, 0x00, 0x03, 0xfb, 0x6f, 0xeb, 0x60, 0x00, 0x67, 0xcc, 0x67, 0x32, 0x60, 0x32, 0x82, 0xc1,
    0x60, 0xdd, 0x0c, 0x07, 0x8c, 0x24, 0x43, 0x0e, 0x2a, 0x4e, 0x4c, 0x32, 0x01, 0x0c, 0xb3, 0x01, 0x90, 0xa9, 0x8e,
    0x08, 0xc2, 0xe3, 0x65, 0x69, 0x83, 0x11, 0x01, 0xe2, 0xd1, 0x96, 0xf1, 0x69, 0xb0, 0xc2, 0xe8, 0xae, 0xf7, 0x95,
    0x54, 0xde, 0xc9, 0x44, 0xbe, 0x11, 0x12, 0x88, 0x3f, 0xf7, 0xf5, 0x47, 0xdb, 0x54, 0x75, 0x29, 0xde, 0x8d, 0xc6,
    0xea, 0x45, 0xa5, 0x12, 0xda, 0xd2, 0xae, 0xca, 0xb1, 0x94, 0xd5, 0xe4, 0xa2, 0xcb, 0x4b, 0x0a, 0x81, 0xde, 0x0c,
    0x2a, 0xc4, 0x05, 0x07, 0xbc, 0x88, 0x24, 0x24, 0x2a, 0x54, 0x41, 0xdd, 0x5a, 0xed, 0xdf, 0xd3, 0xba, 0x9f, 0x8c,
    0xd6, 0xe8, 0x97, 0xaf, 0xfd, 0x88, 0x34, 0x98, 0x72, 0x49, 0x24, 0x00, 0x00, 0x0f, 0x82, 0xec, 0x22, 0xb6, 0x5e,
    0xb8, 0x86, 0x5d, 0x88, 0x7a, 0x87, 0xa4, 0x64, 0x26, 0x82, 0x8d, 0x32, 0x2e, 0x75, 0x0b, 0x0a, 0x7f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x00, 0xcc, 0x36, 0xff, 0xc8, 0x00, 0x06, 0x03, 0x82, 0x03, 0xc1, 0x41,
    0x89, 0xb5, 0xff, 0xfb, 0x84, 0x64, 0xeb, 0x81, 0x13, 0xd0, 0x26, 0x49, 0x7b, 0xdd, 0x41, 0xf8, 0x1e, 0xe2, 0x09,
    0x1d, 0x04, 0x03, 0x61, 0x4d, 0xa8, 0xb7, 0x27, 0xee, 0xe1, 0x0c, 0xe0, 0x99, 0x80, 0x23, 0xa8, 0x00, 0x00, 0x04,
    0x01, 0xcd, 0x23, 0x68, 0x70, 0x2c, 0x61, 0x18, 0xcc, 0x72, 0x69, 0x3e, 0x61, 0x78, 0x00, 0x64, 0xb0, 0x24, 0xdf,
    0xca, 0xc2, 0xe1, 0xb9, 0x88, 0x51, 0x89, 0x81, 0x40, 0x8a, 0xca, 0x3b, 0xdb, 0xa5, 0x16, 0x52, 0xe0, 0x2d, 0x43,
    0xb4, 0xac, 0x6e, 0x76, 0x35, 0xdc, 0x29, 0xf3, 0x7a, 0x25, 0x66, 0x93, 0x46, 0x88, 0x92, 0x81, 0x49, 0x45, 0xbc,
    0x9e, 0x5b, 0x1c, 0x5e, 0x1a, 0x5c, 0x9e, 0xa6, 0x42, 0x8e, 0x8a, 0x13, 0x68, 0x0c, 0xec, 0x1d, 0x58, 0x32, 0x15,
    0x72, 0xc8, 0x5d, 0xff, 0xfd, 0x7d, 0x3f, 0x77, 0xf7, 0x07, 0x21, 0x12, 0xc9, 0x65, 0xac, 0x72, 0x7d, 0x09, 0xd7,
    0xcd, 0x9d, 0x1c, 0x6f, 0x1e, 0x73, 0xd8, 0xca, 0x27, 0xa8, 0x86, 0x6b, 0xed, 0xcf, 0x77, 0xff, 0xd4, 0x00, 0x00,
    0x03, 0xbf, 0x7f, 0xab, 0x40, 0x00, 0x5a, 0x21, 0xe0, 0x20, 0x30, 0xa9, 0x24, 0xa3, 0x4f, 0xb0, 0x43, 0x30, 0xcc,
    0x36, 0x2c, 0x2a, 0x66, 0xa0, 0xb7, 0xc6, 0x14, 0x80, 0x46, 0x30, 0x8c, 0xa6, 0x14, 0x03, 0xc0, 0x90, 0x24, 0xc0,
    0x21, 0x08, 0xd7, 0xeb, 0x30, 0xc4, 0x50, 0x68, 0xb6, 0xa8, 0xfc, 0xd3, 0x5f, 0xe5, 0xb0, 0xd0, 0xa9, 0x4b, 0xee,
    0xbf, 0x64, 0xf3, 0xcd, 0xb2, 0x74, 0x8e, 0xe2, 0x59, 0xe1, 0x7d, 0x04, 0x9c, 0xdd, 0x81, 0x52, 0xda, 0xe8, 0x79,
    0x72, 0x0d, 0x36, 0x56, 0xa9, 0x81, 0x62, 0xbb, 0xbd, 0xd4, 0x7f, 0x9a, 0x74, 0xb1, 0xd4, 0x8e, 0x49, 0xd2, 0xa9,
    0x0d, 0xb1, 0x93, 0x80, 0xd8, 0xa1, 0x93, 0x2a, 0x3f, 0x62, 0xa9, 0x8a, 0x21, 0x7d, 0xe8, 0x3a, 0xa5, 0xda, 0x88,
    0xd4, 0xb2, 0xdb, 0x57, 0x47, 0x10, 0xdd, 0xff, 0xff, 0x56, 0xb0, 0x92, 0x0d, 0x05, 0x1c, 0xb2, 0x00, 0x00, 0x04,
    0xf7, 0x8b, 0x18, 0x58, 0x98, 0xcd, 0x50, 0xe8, 0x36, 0xa4, 0xa1, 0x86, 0xde, 0x05, 0x68, 0x40, 0xe1, 0x6a, 0x07,
    0x93, 0x0e, 0x60, 0x67, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0xff, 0xad, 0x1d, 0x20, 0x2d, 0xf7, 0xf5,
    0xb0, 0x00, 0x58, 0x61, 0x00, 0x18, 0x98, 0x8b, 0x88, 0x29, 0xa3, 0x78, 0x34, 0x18, 0x1b, 0xff, 0xfb, 0x84, 0x64,
    0xeb, 0x08, 0x13, 0xa3, 0x1b, 0x49, 0x6b, 0x3e, 0xe8, 0x08, 0x27, 0xc0, 0x18, 0xfd, 0x00, 0x00, 0x01, 0x0c, 0x60,
    0x81, 0x29, 0xee, 0xbc, 0xcc, 0xa0, 0x6b, 0x00, 0x24, 0x34, 0x00, 0x00, 0x05, 0x80, 0x59, 0x82, 0xd0, 0x0c, 0x99,
    0x9f, 0x02, 0x39, 0x83, 0xb0, 0x61, 0x1a, 0x3d, 0xc6, 0x66, 0x02, 0xb8, 0x14, 0x10, 0x61, 0x40, 0x69, 0xf5, 0xdc,
    0x61, 0x12, 0x12, 0x60, 0x33, 0x9a, 0xf9, 0xcb, 0x1f, 0x4e, 0x56, 0x56, 0x56, 0x68, 0xfa, 0x40, 0x97, 0xe5, 0x6f,
    0xab, 0x57, 0xb0, 0x78, 0x8a, 0x62, 0xe5, 0x32, 0xe0, 0x50, 0x77, 0x0d, 0x83, 0xca, 0xe4, 0x93, 0xc6, 0xa5, 0xc9,
    0x13, 0x5c, 0x91, 0xe3, 0xa4, 0x03, 0x6a, 0xd8, 0xfd, 0xdb, 0x76, 0x73, 0xec, 0xaa, 0xbd, 0xb1, 0x3d, 0xaf, 0x46,
    0x04, 0xf5, 0x2c, 0x17, 0x7b, 0xbf, 0xe7, 0x34, 0xfb, 0x52, 0xae, 0xcb, 0x89, 0x44, 0x83, 0x7f, 0xd3, 0xfd, 0x48,
    0x12, 0xd3, 0x0e, 0x45, 0x23, 0x00, 0x13, 0xee, 0x17, 0x51, 0x53, 0xfb, 0x56, 0x59, 0x8d, 0x46, 0x84, 0x93, 0x18,
    0x35, 0x87, 0xd8, 0x64, 0x9d, 0x4f, 0x77, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xad, 0x35, 0x00,
    0x00, 0x03, 0xbb, 0xff, 0xfd, 0x80, 0x01, 0x12, 0x21, 0x14, 0x4c, 0x4a, 0x3c, 0x4e, 0x27, 0x0e, 0x00, 0xa0, 0xd0,
    0xaa, 0xa0, 0xd2, 0x6e, 0xb1, 0x60, 0xd1, 0xc0, 0x51, 0xc6, 0x1c, 0x0a, 0x13, 0x00, 0x00, 0x43, 0x33, 0x9d, 0x3a,
    0xc3, 0x88, 0x6c, 0x91, 0x6b, 0xad, 0x48, 0xb3, 0x4b, 0x76, 0x23, 0xe2, 0x10, 0x81, 0x20, 0xe1, 0xa5, 0xc7, 0xe0,
    0xc6, 0x91, 0x13, 0x84, 0x14, 0xbb, 0x03, 0x9c, 0x82, 0x34, 0xc5, 0x3b, 0x2f, 0x6a, 0xaa, 0x72, 0x6a, 0x31, 0x87,
    0xc8, 0xc7, 0x19, 0x26, 0xa1, 0x10, 0xc1, 0x12, 0x85, 0xa7, 0xe3, 0x02, 0x2d, 0xa1, 0x7f, 0xee, 0x61, 0x20, 0xe3,
    0x11, 0xdb, 0x60, 0x00, 0x00, 0x12, 0x71, 0xf0, 0xd5, 0x46, 0x1c, 0x2d, 0x49, 0xc5, 0x6f, 0x05, 0x80, 0xcf, 0x87,
    0x8c, 0x06, 0x98, 0xe1, 0x1b, 0x08, 0x92, 0xbc, 0x77, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x9f, 0xff, 0xff, 0xff, 0x5d,
    0x61, 0xeb, 0x6e, 0xfa, 0x30, 0x00, 0x87, 0xcc, 0xac, 0x4d, 0x44, 0x8b, 0x4d, 0x6b, 0x17, 0x14, 0x60, 0xc2, 0x51,
    0x6c, 0xe6, 0x12, 0x78, 0xc2, 0x51, 0x40, 0xe3, 0xa0, 0xff, 0xfb, 0x94, 0x64, 0xf4, 0x08, 0x13, 0xf4, 0x1e, 0x48,
    0xeb, 0xdd, 0x60, 0xf8, 0x2a, 0xe0, 0x18, 0xdd, 0x04, 0x00, 0x00, 0x0e, 0xe0, 0xa1, 0x25, 0xaf, 0x71, 0x67, 0xa0,
    0x94, 0x00, 0x23, 0xb4, 0x00, 0x00, 0x04, 0xc8, 0xc1, 0x70, 0x74, 0x02, 0x08, 0x98, 0x00, 0x07, 0x1a, 0x1f, 0x0a,
    0x18, 0x38, 0x06, 0x39, 0x6c, 0x31, 0xf7, 0x67, 0x89, 0x07, 0xf1, 0xb1, 0x54, 0x90, 0x12, 0x1a, 0xb7, 0x01, 0xe1,
    0x11, 0xb8, 0x0f, 0x6c, 0x4e, 0x5b, 0x28, 0x40, 0x9a, 0xdc, 0x81, 0xf8, 0x60, 0x72, 0x18, 0x6b, 0x03, 0x59, 0x7c,
    0xdc, 0xfc, 0x8e, 0xd4, 0xaf, 0x46, 0x78, 0xa0, 0x8c, 0x36, 0x0d, 0x9d, 0x9e, 0x28, 0x2c, 0xb4, 0x83, 0x30, 0x9f,
    0xec, 0xff, 0xd5, 0xb3, 0xfa, 0xb7, 0x63, 0xbf, 0xfa, 0x41, 0x08, 0xc6, 0xd8, 0x0d, 0xd6, 0x0d, 0xac, 0xb2, 0x16,
    0x00, 0x55, 0x89, 0x7f, 0xc7, 0x5c, 0xa7, 0xbc, 0x28, 0x41, 0x43, 0x5e, 0xed, 0x88, 0x00, 0x00, 0x02, 0xda, 0xdf,
    0xf5, 0x60, 0x00, 0xdd, 0x42, 0x83, 0xe3, 0x89, 0x7b, 0xcc, 0xc0, 0x48, 0x05, 0x03, 0x0c, 0x20, 0x97, 0x3c, 0x23,
    0x29, 0x54, 0x0e, 0x11, 0x51, 0x44, 0x86, 0x03, 0x03, 0x41, 0x63, 0x01, 0x84, 0x50, 0x0b, 0xf2, 0x58, 0x03, 0xd6,
    0x19, 0x61, 0x6d, 0x44, 0xc0, 0x78, 0x22, 0x76, 0x4d, 0x20, 0x0f, 0x0d, 0xd3, 0xc8, 0xab, 0x57, 0x5d, 0x1b, 0x27,
    0x2c, 0x6b, 0xe4, 0x3f, 0xa3, 0xd6, 0x5e, 0xcd, 0x63, 0x8e, 0x3e, 0xa2, 0xef, 0xae, 0xe4, 0x79, 0x47, 0xea, 0x34,
    0x2e, 0x08, 0x03, 0xcb, 0x12, 0x05, 0x43, 0x04, 0xa9, 0x0b, 0x3e, 0xa4, 0x27, 0xfd, 0xb7, 0x7e, 0xcf, 0xff, 0xd0,
    0xd0, 0x4e, 0x54, 0xe4, 0x52, 0x40, 0x00, 0x01, 0xc9, 0x6a, 0x0c, 0x96, 0x28, 0xe4, 0xdc, 0x1f, 0x03, 0x3e, 0x9a,
    0x4d, 0x99, 0x66, 0x49, 0x11, 0xeb, 0x98, 0x58, 0x87, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x40,
    0x40, 0x00, 0xe6, 0xd7, 0x7d, 0x13, 0xd4, 0x44, 0x4d, 0x1a, 0x04, 0xee, 0x9b, 0x48, 0x18, 0x23, 0x21, 0x80, 0x21,
    0x29, 0xa8, 0xc5, 0xb9, 0x8a, 0xc5, 0x19, 0x93, 0x12, 0xb1, 0x83, 0xe0, 0x91, 0x85, 0xc0, 0x29, 0x82, 0xe0, 0xf1,
    0xa2, 0x8d, 0x21, 0x89, 0xa0, 0x72, 0x60, 0xa8, 0x33, 0x99, 0x2f, 0x15, 0x89, 0x7a, 0xe1, 0x58, 0x2e, 0x57, 0x1a,
    0xd2, 0xd3, 0xc3, 0x15, 0x78, 0xe1, 0x2a, 0x16, 0x6e, 0x85, 0x1b, 0x53, 0x7e, 0xed, 0x6c, 0x93, 0x1d, 0xdb, 0x5a,
    0xb5, 0xd4, 0xc8, 0xa6, 0xcc, 0x63, 0x34, 0x58, 0xa2, 0x83, 0xc1, 0xd6, 0x87, 0x42, 0xc6, 0x9a, 0xfa, 0x5c, 0xa0,
    0x57, 0x7f, 0xff, 0xd2, 0xbf, 0xff, 0xe8, 0xcd, 0x98, 0xf3, 0xfc, 0x19, 0x82, 0xff, 0xfb, 0x74, 0x64, 0xff, 0x08,
    0x12, 0xe8, 0x1f, 0xca, 0xeb, 0xbc, 0x48, 0xe8, 0x29, 0x60, 0x08, 0xed, 0x00, 0x00, 0x00, 0x0d, 0x3c, 0x7f, 0x27,
    0xac, 0xf5, 0x81, 0xa0, 0x5f, 0x00, 0x23, 0xf4, 0x00, 0x00, 0x04, 0x82, 0x42, 0x76, 0x9a, 0xcd, 0x21, 0xfd, 0xa0,
    0x70, 0x10, 0x88, 0x0d, 0x64, 0x65, 0x29, 0x91, 0x01, 0x8c, 0x77, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x9f, 0xb2, 0x95, 0x00, 0x00, 0x00, 0x7e, 0xbb, 0xeb, 0x40, 0x00, 0x5c, 0xd1, 0x1a, 0x10, 0x67, 0x83, 0x3e, 0x76,
    0x90, 0x6c, 0x60, 0x60, 0x1e, 0x17, 0x17, 0x8c, 0x95, 0x20, 0x4c, 0x1e, 0x3a, 0x0e, 0xf6, 0xb9, 0xcc, 0x53, 0x16,
    0xcc, 0x62, 0x05, 0x31, 0x20, 0xf8, 0xf1, 0x63, 0x50, 0x75, 0x64, 0x20, 0x66, 0x2c, 0x00, 0x59, 0xed, 0x71, 0x76,
    0x2b, 0xb8, 0x82, 0x81, 0xaa, 0x44, 0x82, 0x6c, 0xe2, 0xb1, 0xc4, 0x06, 0x91, 0xeb, 0x0b, 0x92, 0xaf, 0x42, 0x86,
    0x8f, 0x17, 0x64, 0xbb, 0x91, 0x9e, 0x14, 0x0a, 0xc8, 0x11, 0x8b, 0x2e, 0x8a, 0x0c, 0x24, 0xd3, 0x30, 0xa8, 0xc7,
    0x5e, 0xae, 0x81, 0xc1, 0x70, 0x1b, 0x42, 0xa0, 0x43, 0x61, 0x10, 0x50, 0xf0, 0xbd, 0x67, 0x96, 0x29, 0x7d, 0xf9,
    0x04, 0x11, 0xba, 0xab, 0x13, 0x3e, 0x1d, 0x5a, 0x36, 0xda, 0xee, 0x48, 0x51, 0xbe, 0xbe, 0xaf, 0xbb, 0xfd, 0x24,
    0x17, 0x00, 0x0c, 0x41, 0x20, 0x00, 0x00, 0x18, 0xd7, 0xa0, 0x9f, 0xb3, 0xb9, 0xfd, 0x56, 0x35, 0xce, 0xa0, 0x00,
    0x00, 0x08, 0x12, 0x1d, 0xff, 0xfa, 0x30, 0x00, 0x61, 0xa1, 0x52, 0xa8, 0xc4, 0x60, 0xe4, 0x8c, 0x1c, 0x12, 0x06,
    0x0c, 0x05, 0x07, 0x4c, 0x55, 0x14, 0x0c, 0x37, 0x0d, 0xcf, 0x47, 0x2d, 0x0c, 0x4a, 0x10, 0x89, 0x01, 0x01, 0xa1,
    0xe7, 0x55, 0x26, 0x3c, 0x26, 0xca, 0x9a, 0x3c, 0x61, 0xd3, 0x4d, 0xe5, 0x90, 0xc1, 0xa9, 0x65, 0x52, 0x27, 0x9e,
    0x2b, 0x56, 0xad, 0x2c, 0x04, 0x81, 0x0e, 0x15, 0x20, 0xf2, 0x91, 0xa7, 0xe1, 0xf5, 0x34, 0xd5, 0xff, 0xfb, 0x74,
    0x64, 0xf9, 0x01, 0x13, 0x1f, 0x1e, 0x4a, 0x6b, 0x9d, 0x61, 0xb8, 0x25, 0x60, 0x08, 0xfd, 0x00, 0x00, 0x01, 0x0c,
    0xd8, 0x8b, 0x27, 0xae, 0xb0, 0x6f, 0x60, 0x8e, 0x00, 0x63, 0x64, 0x20, 0x00, 0x04, 0x49, 0x6a, 0x8c, 0x27, 0xb7,
    0x37, 0x99, 0xb6, 0x9e, 0x13, 0x5b, 0x6a, 0x12, 0x9b, 0xa2, 0xbb, 0x1f, 0xff, 0xfb, 0x92, 0x41, 0x29, 0xc4, 0xd0,
    0x72, 0x30, 0xc1, 0x76, 0x39, 0x26, 0xc3, 0x4f, 0x49, 0xb5, 0xd9, 0x99, 0xc2, 0xe4, 0x9c, 0x39, 0xa3, 0xde, 0xa0,
    0x45, 0xeb, 0x59, 0x77, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xa5, 0x00, 0x80, 0x04, 0x9f, 0x7f,
    0xbc, 0x60, 0x00, 0xee, 0x83, 0x4b, 0x83, 0x03, 0x4d, 0xa3, 0x8b, 0x81, 0xb1, 0x60, 0x40, 0x0c, 0x02, 0x19, 0xbc,
    0x0e, 0x18, 0x7c, 0x1d, 0x9f, 0x68, 0xb3, 0x18, 0x82, 0x17, 0x98, 0x30, 0x03, 0x97, 0xd8, 0xc9, 0xf4, 0x08, 0x1c,
    0x08, 0x3a, 0x6c, 0xf1, 0xb9, 0xd3, 0x83, 0x82, 0x73, 0x89, 0xcc, 0xd5, 0x11, 0xdd, 0xa3, 0xb2, 0x3e, 0xa6, 0x03,
    0x93, 0xd2, 0x02, 0x29, 0x13, 0x81, 0x61, 0xc9, 0xde, 0x3e, 0x5f, 0xf2, 0x5f, 0xa2, 0x47, 0x26, 0xbb, 0x75, 0x85,
    0xad, 0x5f, 0xfc, 0x67, 0xe5, 0x60, 0x68, 0xa2, 0xde, 0x1c, 0x0a, 0x98, 0x15, 0x07, 0x89, 0x6a, 0xff, 0xfa, 0xff,
    0xf6, 0xeb, 0xe8, 0x60, 0x12, 0x23, 0x12, 0x49, 0x20, 0x00, 0x00, 0xc6, 0x30, 0xe3, 0x22, 0xc7, 0x5f, 0x29, 0x8b,
    0x58, 0xe6, 0xb1, 0xc6, 0x05, 0xa2, 0x03, 0x31, 0x86, 0x43, 0xe2, 0xc0, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xef, 0x6f, 0x48, 0x00, 0x00, 0x00, 0x2b, 0x4b, 0x40, 0x00, 0x9d, 0x06, 0x8f, 0x86, 0x2d, 0xa8, 0xc6,
    0xa1, 0x06, 0x2d, 0xa8, 0x54, 0x36, 0x30, 0x74, 0x7b, 0x00, 0x94, 0x46, 0xdf, 0xca, 0x61, 0xc1, 0xc9, 0x91, 0x80,
    0x10, 0x0c, 0x9a, 0x26, 0xf8, 0xb1, 0x8c, 0x69, 0x94, 0xb0, 0xa9, 0xf7, 0xe9, 0xa6, 0x3b, 0x10, 0x36, 0xa0, 0x76,
    0xff, 0xfb, 0x84, 0x64, 0xed, 0x00, 0x14, 0x0b, 0x20, 0xc8, 0xeb, 0xbc, 0x4a, 0x48, 0x12, 0x60, 0x09, 0x0d, 0x00,
    0x00, 0x01, 0x0b, 0xc4, 0x7f, 0x29, 0xee, 0xec, 0xc9, 0x60, 0x92, 0x80, 0x23, 0xb4, 0x00, 0x00, 0x04, 0x1d, 0x49,
    0x43, 0x01, 0x32, 0x83, 0x17, 0x6a, 0x2e, 0xa1, 0x53, 0xf9, 0x79, 0xb2, 0x6a, 0x07, 0x93, 0xdc, 0xa4, 0x59, 0x70,
    0x2d, 0x50, 0x34, 0x85, 0xb8, 0xe2, 0xd1, 0xa9, 0x62, 0x7b, 0xeb, 0xe2, 0x1f, 0xdc, 0xd8, 0xcd, 0x38, 0xad, 0xa0,
    0x89, 0x25, 0xb7, 0x23, 0x80, 0x0c, 0x51, 0xa3, 0xee, 0x43, 0x92, 0x44, 0xd8, 0x69, 0xa2, 0x36, 0x95, 0x0d, 0xad,
    0xbd, 0x0d, 0x72, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xfe, 0xc5, 0x28, 0x82, 0x95, 0x00,
    0x00, 0x05, 0x7f, 0x7d, 0xec, 0x60, 0x01, 0x05, 0x08, 0x4c, 0x46, 0xa9, 0xda, 0x18, 0x88, 0xa6, 0x14, 0x06, 0x18,
    0x2c, 0x7a, 0x6f, 0xd2, 0xb1, 0x8b, 0xd7, 0xa6, 0xc0, 0xdb, 0x46, 0x0a, 0x07, 0x82, 0x42, 0x0a, 0x19, 0x18, 0x54,
    0x78, 0x09, 0x00, 0x94, 0x4b, 0x19, 0xae, 0x3d, 0x00, 0xea, 0xac, 0x04, 0xd5, 0x2e, 0x3e, 0x3c, 0x9c, 0xd0, 0x88,
    0x04, 0xa0, 0x8c, 0x55, 0x40, 0x48, 0x76, 0x5f, 0x6c, 0xab, 0x4a, 0x28, 0x74, 0x91, 0x82, 0xf2, 0x6c, 0x02, 0x18,
    0x5c, 0xc1, 0x03, 0x50, 0xb9, 0xf0, 0x74, 0x90, 0xb3, 0xd0, 0x13, 0x15, 0x5b, 0xb6, 0x7f, 0xff, 0x57, 0xfe, 0xba,
    0x3d, 0x42, 0x4b, 0x45, 0xb8, 0xd8, 0x00, 0x00, 0x44, 0x02, 0xce, 0x1b, 0x61, 0x13, 0x7b, 0x52, 0x6c, 0xb3, 0x1d,
    0x20, 0x75, 0x60, 0x03, 0x8c, 0x6a, 0x1c, 0xa3, 0xae, 0x42, 0xff, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xea, 0xff, 0xff,
    0xa1, 0x9d, 0x7a, 0xc3, 0xa9, 0x03, 0x15, 0x12, 0x7f, 0xff, 0xd6, 0x00, 0x03, 0xb4, 0x3a, 0x12, 0x19, 0x72, 0xa6,
    0x1a, 0x2e, 0x1b, 0xa0, 0x18, 0xc0, 0xa0, 0x9c, 0xcc, 0x41, 0x38, 0xc3, 0x41, 0x80, 0xf1, 0x66, 0xdc, 0xc3, 0xf1,
    0x25, 0x0a, 0xc1, 0x00, 0x29, 0x8f, 0xe5, 0xd8, 0x28, 0x11, 0x8d, 0x14, 0xa8, 0xf5, 0x41, 0xf2, 0x93, 0x78, 0x83,
    0x7e, 0xab, 0x55, 0xb9, 0xd6, 0x90, 0x0c, 0x97, 0xc8, 0xe9, 0xeb, 0x23, 0x11, 0x82, 0x0c, 0xc4, 0x8e, 0x20, 0x02,
    0x0c, 0x91, 0x0c, 0x40, 0x9a, 0xb4, 0x9c, 0x99, 0xa1, 0x62, 0x78, 0x10, 0x4c, 0xff, 0xfb, 0x74, 0x64, 0xf7, 0x82,
    0x13, 0x38, 0x24, 0xc9, 0xeb, 0xac, 0x33, 0xa8, 0x27, 0xa0, 0x08, 0xfd, 0x00, 0x00, 0x01, 0x0b, 0x70, 0xb1, 0x29,
    0xee, 0xed, 0x09, 0x28, 0x94, 0x80, 0x23, 0x74, 0x00, 0x00, 0x00, 0x06, 0x17, 0x03, 0x1b, 0x02, 0x00, 0xa2, 0x33,
    0xa2, 0x80, 0xd7, 0xff, 0xff, 0xd3, 0xff, 0xa1, 0xa0, 0x10, 0x6a, 0x27, 0x25, 0x40, 0xcc, 0x6b, 0x57, 0xf3, 0x54,
    0x73, 0x7f, 0xd4, 0x2e, 0x06, 0xac, 0x59, 0x18, 0xdd, 0xa2, 0xc1, 0x22, 0x62, 0xb5, 0xec, 0x67, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x91, 0xda, 0xe0, 0x00, 0x06, 0xba, 0xfd, 0xf4, 0x60, 0x00, 0x64, 0xa0, 0x33, 0x19,
    0x98, 0xa6, 0x21, 0xb7, 0x20, 0x58, 0xd0, 0x06, 0x22, 0x10, 0x0c, 0x82, 0x1d, 0x46, 0x82, 0xe3, 0xe8, 0x41, 0x73,
    0x14, 0x04, 0x00, 0x48, 0x0c, 0x2a, 0x01, 0x99, 0x5c, 0x1c, 0x0d, 0x07, 0x52, 0x16, 0x66, 0xd7, 0x5d, 0xb2, 0xe0,
    0x0e, 0x41, 0x33, 0xa8, 0xcd, 0xb1, 0xfe, 0x0f, 0xb2, 0x54, 0xdc, 0x95, 0x9a, 0xd1, 0xb7, 0xd6, 0x13, 0xee, 0x6f,
    0xb6, 0x75, 0xf9, 0x6f, 0xf0, 0x82, 0xa0, 0x32, 0xc0, 0x20, 0xcb, 0x54, 0x24, 0x58, 0xeb, 0xd9, 0x75, 0xe9, 0x63,
    0xff, 0xff, 0xfb, 0xfd, 0xca, 0xff, 0xff, 0xad, 0x06, 0xa4, 0x72, 0x49, 0x25, 0x00, 0x00, 0x04, 0x53, 0x3c, 0x14,
    0x89, 0x9f, 0x02, 0x98, 0xe2, 0x3d, 0x9e, 0xe4, 0xdc, 0x48, 0x9f, 0x7b, 0x24, 0xb5, 0x61, 0x89, 0xff, 0xd6, 0x01,
    0x00, 0x09, 0x2e, 0xff, 0xe7, 0x2e, 0x25, 0x0b, 0x4c, 0xd9, 0x03, 0x40, 0x61, 0x11, 0x40, 0x5e, 0x60, 0x08, 0x2c,
    0x19, 0x25, 0x18, 0x08, 0x3e, 0x9e, 0xa1, 0x0a, 0x18, 0x86, 0x14, 0x98, 0xf0, 0x7a, 0x63, 0x1d, 0xab, 0x40, 0x60,
    0x84, 0x3e, 0x0b, 0x0f, 0x29, 0x84, 0x03, 0x34, 0x66, 0xf0, 0xc3, 0x62, 0x85, 0x2c, 0x76, 0x48, 0x49, 0x65, 0x6e,
    0x37, 0xc7, 0xf4, 0x7a, 0x17, 0x4f, 0xda, 0xc6, 0x9a, 0xb9, 0xca, 0xa7, 0xe8, 0xba, 0xfb, 0x6d, 0xff, 0xfb, 0x84,
    0x64, 0xed, 0x88, 0x13, 0x0b, 0x19, 0xc9, 0xeb, 0x9d, 0x49, 0xb8, 0x2b, 0xa0, 0x18, 0xca, 0x04, 0x00, 0x00, 0x0c,
    0x38, 0x85, 0x29, 0xae, 0xbc, 0x6d, 0x20, 0x94, 0x8b, 0xe3, 0xb4, 0x10, 0x8c, 0xfc, 0x8e, 0x60, 0x07, 0x43, 0x27,
    0xdc, 0x90, 0xcc, 0x50, 0x54, 0xeb, 0x04, 0xe6, 0x82, 0x25, 0xf3, 0x3d, 0x3f, 0xf6, 0xd6, 0xdf, 0xf4, 0xbf, 0xfa,
    0xd9, 0x20, 0x00, 0xd8, 0x99, 0xe0, 0xc2, 0x32, 0x87, 0x4f, 0xf7, 0x8e, 0x0b, 0xea, 0x63, 0x98, 0x04, 0x77, 0xb1,
    0xae, 0x78, 0xb4, 0x78, 0x4a, 0x43, 0xc8, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xde, 0xfa, 0xea, 0x00,
    0x00, 0x00, 0x03, 0x67, 0x8b, 0xf5, 0x6c, 0x00, 0x33, 0x1d, 0x37, 0x9b, 0x66, 0x1e, 0x7d, 0x91, 0x91, 0x30, 0x48,
    0x2c, 0x4b, 0x32, 0x01, 0xe8, 0xc1, 0x4c, 0x23, 0x3b, 0x6e, 0xf0, 0x80, 0x58, 0x14, 0x2d, 0x18, 0x08, 0x0e, 0x98,
    0xdc, 0x61, 0xa3, 0xeb, 0xbc, 0x0f, 0x90, 0xbc, 0x12, 0x70, 0x5c, 0x7c, 0x53, 0x20, 0x95, 0x1f, 0x81, 0x08, 0xe8,
    0x71, 0x77, 0xe6, 0xd6, 0x9a, 0x9f, 0x3e, 0x76, 0x6b, 0x65, 0x57, 0xb3, 0x2f, 0x3d, 0x6a, 0xde, 0x5f, 0x34, 0xf2,
    0x40, 0x04, 0x8f, 0x69, 0xf0, 0xda, 0x56, 0x97, 0x9d, 0x60, 0xd8, 0x28, 0x1b, 0x36, 0x1a, 0xff, 0x55, 0x58, 0xf9,
    0x95, 0xe8, 0xf6, 0x8b, 0x7a, 0xbf, 0xbd, 0x0a, 0x4d, 0x1f, 0xd9, 0x5a, 0x00, 0x00, 0x48, 0x4b, 0xcf, 0xbd, 0xcf,
    0x95, 0x32, 0x2d, 0x99, 0x58, 0x3a, 0x05, 0x1c, 0x86, 0x18, 0x03, 0x38, 0x30, 0x6c, 0x44, 0xc1, 0xcf, 0xa3, 0x56,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xbf, 0xef, 0x1a, 0x48, 0x00, 0x80, 0x0c, 0x16, 0x21, 0xfe, 0xf9,
    0xd2, 0x8c, 0x9f, 0x4c, 0xe3, 0x43, 0x35, 0xa9, 0x08, 0x40, 0x0d, 0x04, 0x88, 0x0d, 0xc0, 0x13, 0x14, 0x2c, 0x9b,
    0x7f, 0x02, 0x02, 0x84, 0x42, 0xea, 0x00, 0x81, 0x61, 0x11, 0x1c, 0xad, 0xd5, 0x56, 0xb4, 0x56, 0x55, 0x07, 0xbe,
    0x8f, 0xd0, 0x49, 0x23, 0xc1, 0xa0, 0xaf, 0xa7, 0x1f, 0x07, 0xa2, 0x79, 0x0a, 0xf2, 0x81, 0x15, 0x14, 0x51, 0x88,
    0xa4, 0x4c, 0x35, 0xa4, 0xca, 0x95, 0xd3, 0x5e, 0x46, 0x31, 0xef, 0x2e, 0x93, 0xe8, 0x63, 0x90, 0xe3, 0xe8, 0x28,
    0x11, 0xb9, 0xde, 0x9f, 0xd3, 0x6a, 0x53, 0xfa, 0xbf, 0x8a, 0xff, 0xfb, 0x74, 0x64, 0xf9, 0x81, 0x12, 0xfe, 0x1d,
    0x4a, 0x6b, 0x3d, 0x48, 0x68, 0x1d, 0x23, 0x58, 0xfd, 0x04, 0x23, 0x2f, 0x0c, 0x4c, 0x77, 0x27, 0xae, 0xed, 0x88,
    0x60, 0x90, 0x00, 0x63, 0x70, 0x20, 0x00, 0x04, 0xd0, 0x48, 0x48, 0xb8, 0xe4, 0x96, 0xc0, 0x63, 0x29, 0xc1, 0x4d,
    0x55, 0x02, 0xd6, 0x51, 0xdd, 0x17, 0xe5, 0xb5, 0x18, 0x54, 0xe4, 0x13, 0xba, 0x11, 0x56, 0x4b, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xed, 0xd7, 0xf6, 0x6b, 0x00, 0x00, 0x00, 0x05, 0x78, 0x6f, 0xff, 0x8c, 0x00, 0x21, 0xd1,
    0x1a, 0x3c, 0xc3, 0xb3, 0xb3, 0x45, 0x0d, 0x19, 0x08, 0x14, 0x78, 0xf5, 0x4e, 0x42, 0xa6, 0xa7, 0x70, 0xe6, 0x02,
    0x33, 0x08, 0x21, 0x41, 0x39, 0xad, 0x8c, 0x8b, 0x10, 0xd1, 0xb5, 0x69, 0x1e, 0x02, 0xa8, 0x48, 0x90, 0x56, 0x64,
    0x9b, 0x18, 0xa9, 0xf5, 0xd6, 0x27, 0x19, 0x27, 0x79, 0xc5, 0xf0, 0x90, 0xdb, 0x0b, 0x18, 0xc6, 0x22, 0xbb, 0x79,
    0xd7, 0x23, 0x69, 0x87, 0xa4, 0xda, 0xb2, 0xb9, 0xf4, 0xbc, 0x76, 0x17, 0x9f, 0x13, 0x88, 0xc2, 0x61, 0x41, 0x89,
    0x11, 0x8f, 0x61, 0xc4, 0x7f, 0xff, 0xff, 0xfd, 0xc4, 0x24, 0xdc, 0x82, 0x57, 0x2b, 0x00, 0x00, 0x04, 0x82, 0xc4,
    0x92, 0x91, 0x18, 0x0d, 0x4f, 0xa9, 0xea, 0x12, 0x8f, 0x5e, 0xd0, 0x0c, 0x83, 0xcf, 0x1c, 0x0b, 0xc4, 0x5f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x00, 0x00, 0x26, 0x0f, 0x0c, 0xff, 0xfd, 0x27, 0x07, 0x52,
    0xa6, 0x30, 0x6d, 0x9d, 0x08, 0x10, 0x8d, 0x02, 0x16, 0xa6, 0xe7, 0x52, 0x5f, 0x83, 0xc1, 0xac, 0x02, 0xaf, 0x02,
    0x0d, 0x3e, 0x54, 0x49, 0x93, 0xc8, 0x12, 0x2d, 0xcc, 0x7e, 0xe1, 0xf8, 0x02, 0xd6, 0x4d, 0x4d, 0x44, 0xfb, 0x1f,
    0x32, 0x29, 0x74, 0x9f, 0xa2, 0x62, 0xcd, 0xe8, 0x8c, 0xa4, 0x2a, 0x09, 0x2a, 0x02, 0x4f, 0x27, 0x93, 0x59, 0xce,
    0xd9, 0xd2, 0x85, 0x42, 0x20, 0x56, 0x00, 0xc0, 0x2d, 0x61, 0x30, 0x45, 0x30, 0xff, 0xfb, 0x74, 0x64, 0xf5, 0x81,
    0x13, 0x3b, 0x1a, 0xc9, 0x7b, 0x9d, 0x61, 0xa8, 0x2a, 0x60, 0x18, 0xda, 0x04, 0x00, 0x00, 0x0b, 0xc4, 0x7f, 0x27,
    0xee, 0x74, 0xc7, 0x20, 0x94, 0x8a, 0x23, 0xb4, 0x10, 0x8c, 0xf8, 0xe3, 0xfd, 0x9f, 0xfa, 0xdf, 0x93, 0xfe, 0xbd,
    0x5a, 0xef, 0x21, 0x04, 0x98, 0x82, 0x39, 0x10, 0x53, 0xcf, 0x45, 0x47, 0x1b, 0xc8, 0x9c, 0xa2, 0x74, 0xd9, 0x78,
    0xa0, 0x1d, 0xc7, 0xe0, 0x16, 0xd9, 0x55, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x28, 0xd4,
    0x55, 0x01, 0x00, 0x84, 0xbf, 0xed, 0xf3, 0x60, 0x01, 0x30, 0x55, 0x4e, 0x9a, 0x30, 0x8a, 0x1b, 0x49, 0x12, 0x0c,
    0x0b, 0x02, 0x00, 0x61, 0x52, 0x80, 0x89, 0x8e, 0x03, 0xc9, 0xae, 0xb3, 0x07, 0x42, 0x46, 0x4d, 0x5d, 0x37, 0x4a,
    0xec, 0xd1, 0xd7, 0x77, 0x00, 0x21, 0x7a, 0x12, 0xce, 0x2d, 0xb2, 0xa1, 0xb4, 0x51, 0x7f, 0xfa, 0x78, 0x1b, 0x0c,
    0x5a, 0xdf, 0x53, 0x88, 0x40, 0xf7, 0x4c, 0xb0, 0xd3, 0x4f, 0xe6, 0x36, 0x90, 0xb4, 0x8c, 0x40, 0x5c, 0x70, 0xb5,
    0x61, 0x71, 0xce, 0x86, 0x90, 0x82, 0xa2, 0x8e, 0x0f, 0xcb, 0x36, 0xff, 0xea, 0xdc, 0x91, 0x62, 0xc4, 0xed, 0x50,
    0x73, 0x4b, 0x7f, 0x58, 0x21, 0x20, 0x82, 0x71, 0xd9, 0x00, 0x00, 0x01, 0x41, 0x72, 0x01, 0x77, 0xd1, 0xa5, 0x08,
    0x78, 0x40, 0x33, 0x8d, 0x07, 0x44, 0x61, 0x41, 0x45, 0xe7, 0xd4, 0x7e, 0xf5, 0x0d, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfc, 0x7f, 0x42, 0xb7, 0x22, 0x80, 0x00, 0x00, 0x6f, 0xfe, 0xff, 0x43, 0x04, 0x86, 0x0c, 0x28, 0xb5,
    0x31, 0x59, 0x9c, 0xe1, 0xc1, 0x03, 0x11, 0x05, 0x4c, 0x2a, 0x38, 0x31, 0xf9, 0x0d, 0x7d, 0x18, 0x94, 0x52, 0xb5,
    0x0b, 0x34, 0x60, 0xc2, 0x79, 0xb6, 0x67, 0xa3, 0xca, 0xa4, 0xf1, 0x62, 0xcc, 0xe9, 0x9f, 0x80, 0x40, 0x2c, 0x0d,
    0x93, 0x82, 0x68, 0x69, 0xaa, 0xce, 0xa4, 0x1c, 0x0a, 0x73, 0x7d, 0x69, 0x9f, 0x2a, 0x39, 0xeb, 0xff, 0xfb, 0x84,
    0x64, 0xe9, 0x01, 0x12, 0xfb, 0x24, 0xc9, 0xfb, 0x9b, 0x48, 0xd8, 0x26, 0x80, 0x08, 0xfd, 0x00, 0x00, 0x01, 0x0b,
    0x44, 0x83, 0x27, 0xee, 0x68, 0xc3, 0xa0, 0x90, 0x80, 0x23, 0xb4, 0x00, 0x00, 0x04, 0xdb, 0x7f, 0xa2, 0x0a, 0x90,
    0x4d, 0xdd, 0xc4, 0x2a, 0x30, 0xe0, 0x01, 0xcd, 0x08, 0xaf, 0x9c, 0xa3, 0x88, 0xd4, 0x44, 0x10, 0x87, 0x06, 0xa4,
    0x8c, 0x9a, 0x91, 0xea, 0x5f, 0xff, 0xb7, 0x4f, 0xf5, 0xa8, 0x12, 0x48, 0x61, 0xc8, 0xe5, 0x40, 0x9b, 0xb6, 0x4e,
    0xf6, 0xbe, 0x45, 0x36, 0xa1, 0x3f, 0xcb, 0x0b, 0x1e, 0x69, 0x07, 0x0c, 0x96, 0x3a, 0x73, 0xd7, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xeb, 0xfc, 0x2f, 0xd2, 0x51, 0x55, 0x2a, 0x00, 0x00, 0x02, 0x03, 0x86, 0x7f, 0xfe, 0x68,
    0x00, 0x0c, 0x06, 0x40, 0x70, 0xc0, 0xe8, 0x21, 0x40, 0xa7, 0x86, 0x70, 0xd6, 0x37, 0x66, 0x9b, 0x30, 0x18, 0x20,
    0x2e, 0x64, 0xd1, 0xa2, 0x32, 0x85, 0x07, 0x8f, 0xcb, 0x18, 0x18, 0x02, 0x1b, 0xf2, 0x04, 0x1c, 0x4e, 0x79, 0x52,
    0xda, 0x33, 0x3e, 0x02, 0x0a, 0x07, 0x16, 0xa3, 0x20, 0xef, 0xac, 0xd1, 0xff, 0x49, 0xc4, 0xf4, 0xcc, 0x0c, 0x4b,
    0xeb, 0xc9, 0xcf, 0x3a, 0x4c, 0x2c, 0x46, 0xfc, 0x7a, 0xee, 0xd5, 0xec, 0xe6, 0xda, 0x75, 0xfb, 0xee, 0x73, 0x89,
    0xa0, 0x82, 0x0e, 0x89, 0x80, 0xaa, 0xcc, 0xe5, 0xba, 0x5f, 0x86, 0x7f, 0xff, 0xef, 0xab, 0xb7, 0xec, 0xa2, 0x72,
    0x01, 0xc1, 0x00, 0x00, 0x00, 0xd8, 0x49, 0x0d, 0x5a, 0xb6, 0x7e, 0xe5, 0x32, 0x8a, 0x3e, 0x6d, 0x43, 0x0c, 0x80,
    0x00, 0x00, 0x02, 0xa4, 0x2e, 0xff, 0x46, 0x00, 0x01, 0x70, 0x01, 0x30, 0x20, 0x03, 0xa0, 0xab, 0x2e, 0x9b, 0x99,
    0x8e, 0x51, 0x9c, 0xc7, 0x20, 0xa3, 0x00, 0x09, 0x02, 0x60, 0x00, 0x61, 0x8c, 0x86, 0xe8, 0xfe, 0xe5, 0x0c, 0x04,
    0x4e, 0x76, 0x83, 0x7b, 0x95, 0xf2, 0x81, 0xb4, 0x4d, 0x92, 0x04, 0x23, 0xd7, 0xd8, 0xdd, 0x87, 0x42, 0x0c, 0xcc,
    0x3b, 0x23, 0x44, 0xf1, 0x1e, 0xf2, 0x78, 0xe9, 0xc8, 0xad, 0x6b, 0x58, 0xbd, 0x82, 0x93, 0xae, 0x2a, 0x9e, 0x5f,
    0x01, 0xdb, 0xca, 0xa9, 0xae, 0x6c, 0x7d, 0x3f, 0x1e, 0xcf, 0x4e, 0x4b, 0xaa, 0x7b, 0xc3, 0xaf, 0x6b, 0x81, 0x3a,
    0xa1, 0x0f, 0xe8, 0xfd, 0xd6, 0x76, 0x7e, 0xff, 0x71, 0x00, 0xff, 0xfb, 0x74, 0x64, 0xfc, 0x81, 0x13, 0x0d, 0x1f,
    0xc9, 0x6b, 0x89, 0x33, 0xb8, 0x29, 0xe0, 0x08, 0xdd, 0x00, 0x00, 0x00, 0x0c, 0x68, 0x97, 0x27, 0xae, 0x30, 0x70,
    0xe0, 0x99, 0x8b, 0xa3, 0x74, 0x10, 0x8d, 0x38, 0xa2, 0x9b, 0x8d, 0xc8, 0xc2, 0xdd, 0x0d, 0x3d, 0xeb, 0x01, 0xa1,
    0x60, 0x69, 0xa9, 0xe7, 0x50, 0x82, 0x62, 0x78, 0x45, 0x82, 0x27, 0x16, 0xbe, 0x22, 0x5f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xdb, 0x49, 0xa5, 0xaa, 0x00, 0x00, 0x46, 0xbf, 0xed, 0xf3, 0x40, 0x00, 0x60, 0x14, 0x05,
    0x21, 0x70, 0xa8, 0x30, 0xa0, 0x85, 0x53, 0x11, 0xf1, 0xec, 0x31, 0x31, 0x64, 0xaa, 0x2a, 0x30, 0x60, 0x65, 0x7c,
    0x1a, 0x24, 0x3c, 0x83, 0x85, 0xb1, 0x2b, 0x05, 0x82, 0xe9, 0xa0, 0xe4, 0x52, 0x91, 0x5c, 0x4a, 0xb5, 0xaf, 0x07,
    0x01, 0xd0, 0xb3, 0x68, 0xbf, 0x0e, 0x3e, 0x8d, 0xd8, 0xf4, 0xb8, 0x1a, 0x8a, 0x1b, 0x8e, 0xcb, 0xd5, 0x89, 0x6a,
    0x0f, 0x0a, 0x94, 0xf8, 0x55, 0xc4, 0x86, 0x8a, 0x87, 0xc9, 0x56, 0x52, 0x1c, 0xbd, 0x3b, 0x79, 0x6b, 0x0e, 0xb2,
    0xda, 0x4a, 0x9d, 0x16, 0x1c, 0x09, 0xa0, 0x90, 0x9e, 0x84, 0x59, 0xdd, 0x7e, 0x15, 0x39, 0x43, 0xaa, 0x7c, 0x75,
    0xdd, 0x9f, 0x59, 0xbd, 0xcc, 0x4f, 0xfa, 0x46, 0xa7, 0xe3, 0x6e, 0x20, 0x00, 0x00, 0x38, 0x78, 0x28, 0x50, 0xa2,
    0xd4, 0x2c, 0x8b, 0xa8, 0x7f, 0x07, 0xa7, 0xb3, 0xa8, 0x62, 0x9f, 0xe3, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x9f,
    0x6f, 0xff, 0xff, 0xb1, 0x40, 0x02, 0x00, 0x93, 0xcd, 0xfe, 0x66, 0x02, 0xc0, 0x4a, 0x60, 0x4a, 0x15, 0x86, 0x20,
    0x0e, 0x7a, 0x6b, 0xf8, 0x2d, 0x46, 0x6e, 0x1e, 0x98, 0x64, 0x40, 0x60, 0xb0, 0xa9, 0x54, 0x00, 0x68, 0xe0, 0x62,
    0x00, 0xdb, 0xb9, 0x81, 0x01, 0x47, 0xb7, 0x94, 0x04, 0x20, 0x14, 0x2d, 0x35, 0x57, 0x5b, 0x80, 0x38, 0x15, 0x86,
    0xe9, 0x09, 0x00, 0x2f, 0xa4, 0x00, 0xcf, 0x9f, 0x9e, 0x18, 0x4b, 0xa0, 0xce, 0xff, 0xfb, 0x74, 0x64, 0xef, 0x80,
    0x13, 0x28, 0x20, 0x49, 0xfb, 0xdc, 0x60, 0xe8, 0x14, 0x20, 0x08, 0xfa, 0x00, 0x00, 0x01, 0x0d, 0x10, 0x8d, 0x27,
    0xef, 0x71, 0x83, 0xe0, 0x9c, 0x80, 0x23, 0xb4, 0x00, 0x00, 0x04, 0xd8, 0x60, 0xbd, 0x73, 0x4c, 0xfa, 0xc8, 0xdd,
    0x36, 0x51, 0x1b, 0x7e, 0xbd, 0x95, 0x91, 0x2c, 0xf6, 0x6f, 0xf4, 0x65, 0xea, 0x32, 0xd4, 0x29, 0x50, 0x90, 0x5c,
    0x8a, 0x48, 0x38, 0x9a, 0x2f, 0x31, 0xfe, 0x63, 0xaf, 0x92, 0x9c, 0xa6, 0x29, 0xd3, 0x5e, 0xde, 0x3c, 0x51, 0xdf,
    0xb1, 0x81, 0x10, 0x9b, 0x0e, 0x39, 0x6c, 0x07, 0x23, 0xac, 0x93, 0x10, 0x3e, 0xb3, 0x98, 0xd7, 0xd9, 0x5a, 0x30,
    0xe3, 0x3e, 0xf4, 0xb5, 0x56, 0xd0, 0x5a, 0x10, 0x21, 0x40, 0x88, 0xeb, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x4d, 0x00, 0x02, 0x01, 0x02, 0x89, 0xaf, 0xbe, 0x8c, 0x00, 0x0c, 0x30, 0x73, 0x43, 0x98, 0xc3, 0x40,
    0xdf, 0xcd, 0xa6, 0x01, 0xa8, 0xcb, 0xc0, 0x50, 0xe1, 0x59, 0x86, 0xc0, 0x86, 0x11, 0x07, 0x19, 0x1c, 0x7a, 0x98,
    0x8e, 0x90, 0x14, 0x0e, 0x70, 0x2c, 0x48, 0x60, 0x5d, 0xd4, 0x5c, 0xf2, 0x88, 0x99, 0x82, 0x80, 0xc2, 0xc0, 0x68,
    0x64, 0xb0, 0x01, 0x4c, 0xcd, 0x49, 0x1f, 0xc8, 0xda, 0x1c, 0x02, 0x00, 0xb2, 0x9a, 0xaf, 0xc5, 0x2d, 0xe9, 0x05,
    0xeb, 0x2f, 0x8d, 0xff, 0xb7, 0x63, 0xea, 0xc9, 0xf7, 0x56, 0xef, 0x71, 0xb1, 0xf5, 0xf5, 0xfc, 0xd6, 0xaa, 0xe0,
    0x34, 0x13, 0x17, 0x68, 0x64, 0xd8, 0xa0, 0x70, 0x71, 0x75, 0x30, 0xda, 0x6d, 0x5f, 0xff, 0xff, 0xff, 0xfe, 0xb2,
    0x00, 0x20, 0xb4, 0xe5, 0xf0, 0x00, 0x36, 0xa7, 0x97, 0xa9, 0xe5, 0x44, 0xa1, 0xd7, 0x85, 0x1e, 0x1d, 0x03, 0xbe,
    0x04, 0xc3, 0x22, 0xc4, 0x5c, 0xe3, 0x67, 0xc2, 0xa8, 0x3a, 0x23, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x4e, 0x87, 0x69, 0x48, 0x6d, 0x40, 0x00, 0x00, 0x00, 0x47, 0x11, 0xbf, 0xd0, 0x30, 0x01, 0x4c, 0xff, 0xfb, 0x84,
    0x64, 0xe9, 0x01, 0x13, 0x8a, 0x1f, 0x49, 0x6b, 0xdc, 0x60, 0xf8, 0x23, 0x20, 0x08, 0xda, 0x00, 0x00, 0x00, 0x0e,
    0x20, 0x81, 0x25, 0xaf, 0x71, 0x83, 0xe0, 0x9d, 0x0c, 0xe3, 0xf4, 0x10, 0x8c, 0xfc, 0x09, 0x41, 0x38, 0xc3, 0x08,
    0x1b, 0x4d, 0xed, 0x81, 0x0c, 0x48, 0x30, 0x03, 0x00, 0xbc, 0x0c, 0x38, 0x0c, 0x81, 0x22, 0x21, 0xaa, 0x2e, 0xb2,
    0x47, 0x01, 0xe3, 0x26, 0x64, 0x00, 0x30, 0x68, 0xc4, 0xd6, 0x23, 0x37, 0x9c, 0x25, 0x00, 0x31, 0xe1, 0x50, 0x03,
    0x42, 0x89, 0xa8, 0x9b, 0x1d, 0x8b, 0xba, 0x48, 0xd7, 0x23, 0x43, 0x3f, 0x66, 0x11, 0x73, 0x09, 0x04, 0x41, 0xf9,
    0x65, 0x5b, 0x3c, 0x8d, 0x37, 0x45, 0x02, 0xf8, 0xdd, 0x7e, 0xac, 0x7f, 0xfd, 0x19, 0xbd, 0x19, 0xa7, 0x56, 0x94,
    0xec, 0xfb, 0x42, 0xfe, 0x83, 0x08, 0xff, 0xfb, 0xf5, 0xfe, 0xef, 0xfb, 0xba, 0x7f, 0xff, 0xff, 0xfd, 0x24, 0x30,
    0x1b, 0x6c, 0x49, 0x23, 0x07, 0x6a, 0xbc, 0x2c, 0xab, 0xee, 0xa7, 0x1e, 0x14, 0x24, 0xc1, 0xeb, 0x9d, 0x50, 0x09,
    0xe8, 0xe9, 0x52, 0x00, 0x02, 0x00, 0x07, 0x68, 0x6b, 0x3e, 0x68, 0x00, 0x14, 0x10, 0xc0, 0x6c, 0x09, 0x0c, 0x22,
    0x0e, 0x10, 0xdd, 0x40, 0x38, 0xcc, 0x11, 0x00, 0x58, 0x88, 0x0a, 0xc0, 0xa0, 0x62, 0x80, 0x73, 0x04, 0x60, 0x67,
    0x72, 0xd7, 0x31, 0x50, 0x0b, 0xcc, 0x22, 0xcb, 0x5c, 0x28, 0x00, 0x6c, 0xc8, 0x48, 0x61, 0x52, 0x27, 0x59, 0x8f,
    0x68, 0x5b, 0x0a, 0x41, 0x91, 0xac, 0x5f, 0x69, 0x3c, 0xca, 0x03, 0x4e, 0x2e, 0x58, 0x63, 0xb7, 0x26, 0x37, 0xe5,
    0xe6, 0xe6, 0x38, 0xfe, 0x92, 0x89, 0x2a, 0x86, 0x9d, 0xe4, 0x99, 0x0a, 0xe5, 0xac, 0xc0, 0xef, 0x45, 0x80, 0xf0,
    0xe0, 0x0a, 0x8e, 0x39, 0x66, 0x74, 0xec, 0x19, 0xa6, 0xff, 0xf5, 0xff, 0xf5, 0xa5, 0xf6, 0xb8, 0x67, 0x42, 0x48,
    0x32, 0xa3, 0x91, 0xa8, 0xc0, 0x00, 0x09, 0x17, 0x57, 0x6f, 0x77, 0xcb, 0x27, 0xcb, 0x8d, 0x6f, 0x7e, 0x84, 0xfb,
    0xbf, 0xde, 0x96, 0x88, 0x17, 0x5b, 0x4f, 0x12, 0xfd, 0x88, 0x08, 0x00, 0x02, 0xb4, 0x4e, 0xdf, 0x46, 0x00, 0x04,
    0x20, 0x04, 0x34, 0x01, 0x61, 0x44, 0x0e, 0x33, 0x92, 0x0c, 0x53, 0x30, 0x98, 0x0a, 0x84, 0xcf, 0x92, 0x48, 0xf3,
    0x9e, 0xb1, 0x4c, 0x19, 0x88, 0x84, 0x91, 0xc8, 0x3d, 0x86, 0xff, 0xfb, 0x84, 0x64, 0xe8, 0x81, 0x13, 0x74, 0x1e,
    0x4a, 0x7b, 0x5e, 0xe0, 0x08, 0x2b, 0xe0, 0x08, 0xcc, 0x00, 0x00, 0x01, 0x0d, 0xa0, 0x95, 0x27, 0xef, 0x75, 0x85,
    0xe0, 0x5d, 0x00, 0x23, 0xf4, 0x00, 0x00, 0x04, 0x1b, 0x00, 0x30, 0x50, 0x68, 0x19, 0xb5, 0x86, 0x80, 0x00, 0xf4,
    0xb2, 0xbc, 0xd9, 0x49, 0x81, 0x9e, 0xf5, 0xb0, 0x48, 0x4b, 0x45, 0x4c, 0x09, 0x2d, 0x49, 0x1d, 0x8b, 0x11, 0x3c,
    0x33, 0x80, 0xe9, 0x3b, 0x85, 0xff, 0xb9, 0x63, 0x3b, 0x77, 0xf5, 0x87, 0xd7, 0xaf, 0x2a, 0x00, 0x85, 0x01, 0x45,
    0x8b, 0xa4, 0x81, 0x61, 0x23, 0xa1, 0x1b, 0x48, 0xa9, 0x28, 0xb5, 0x9f, 0xff, 0xd3, 0xff, 0xe8, 0x8b, 0x7b, 0x28,
    0x2c, 0xd2, 0x4d, 0xa5, 0x6c, 0xd5, 0xcf, 0xc0, 0xea, 0x18, 0x07, 0xa2, 0xe2, 0xeb, 0x2e, 0x14, 0xfd, 0xda, 0x7f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x2a, 0x10, 0x00, 0x01, 0x04, 0x38, 0x6f, 0xfe, 0x8c, 0x00, 0x01,
    0x20, 0x20, 0x4a, 0x06, 0x26, 0x09, 0xaa, 0x54, 0x61, 0xf0, 0x1a, 0xe3, 0x80, 0x3c, 0x87, 0x10, 0x30, 0x48, 0x2b,
    0x69, 0x98, 0x00, 0xac, 0xc5, 0x35, 0x87, 0x84, 0xa7, 0xb7, 0xab, 0x95, 0x98, 0x13, 0xcc, 0xb6, 0x8d, 0xfc, 0x38,
    0x83, 0x10, 0xbf, 0x97, 0x11, 0x04, 0x63, 0x51, 0x7a, 0xb7, 0x2f, 0x2b, 0xdc, 0xe9, 0xd9, 0xae, 0x39, 0x4a, 0x3a,
    0xd8, 0x19, 0x34, 0x88, 0x24, 0xb4, 0x47, 0x8f, 0x32, 0xa2, 0x27, 0x9f, 0x96, 0x34, 0xc6, 0xab, 0x08, 0xaf, 0x89,
    0xe5, 0x20, 0xa8, 0x27, 0x59, 0x1d, 0xf1, 0x6d, 0xa3, 0x40, 0xa2, 0xa2, 0x56, 0x34, 0x87, 0xf9, 0x4f, 0xb6, 0xaf,
    0xfd, 0x5f, 0xff, 0xfb, 0x99, 0x05, 0x26, 0x9c, 0x92, 0x34, 0x00, 0x00, 0x19, 0x9c, 0xb4, 0xd1, 0x46, 0xb2, 0xc9,
    0x6e, 0x76, 0xe4, 0xab, 0x31, 0x82, 0x4c, 0x32, 0xe3, 0xa4, 0x6e, 0xc0, 0xda, 0x91, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0x20, 0x00, 0x20, 0x00, 0x6b, 0x11, 0xf7, 0xf0, 0x0a, 0x01, 0x00, 0x00, 0x39, 0x30, 0x8d,
    0x4d, 0x63, 0x32, 0x30, 0xe7, 0x30, 0x98, 0x69, 0x35, 0x4c, 0x1a, 0x1f, 0x43, 0xb1, 0x90, 0x40, 0xb4, 0xcf, 0xa1,
    0x80, 0xc1, 0x27, 0x8c, 0x12, 0x80, 0x8e, 0x6a, 0xf1, 0x2e, 0xd6, 0xa3, 0xf6, 0x5d, 0xe6, 0x09, 0x3f, 0x71, 0xa0,
    0xca, 0xa0, 0x70, 0xc9, 0xff, 0xfb, 0x84, 0x64, 0xef, 0x00, 0x53, 0x6d, 0x1f, 0x49, 0x7b, 0xd8, 0x63, 0x38, 0x1d,
    0x80, 0x08, 0xed, 0x00, 0x00, 0x01, 0x4c, 0xfc, 0x6d, 0x29, 0xef, 0x6b, 0x82, 0xe0, 0x79, 0x00, 0x64, 0x28, 0x10,
    0x00, 0x04, 0x59, 0x20, 0x39, 0x85, 0x61, 0x7a, 0x5f, 0x22, 0xaf, 0xa1, 0x59, 0x06, 0x1c, 0x57, 0xd8, 0xb1, 0xd4,
    0x2a, 0x4f, 0x55, 0x25, 0x1b, 0xbb, 0x32, 0xc9, 0xd1, 0xac, 0x10, 0xb9, 0x13, 0x79, 0x31, 0x65, 0x39, 0x84, 0x08,
    0x52, 0x71, 0x37, 0x07, 0x49, 0x00, 0xc9, 0x55, 0xfd, 0x15, 0x33, 0xff, 0xa1, 0x7f, 0xde, 0xb8, 0xd0, 0x31, 0xc8,
    0x00, 0xee, 0x92, 0x02, 0xe4, 0x80, 0x2f, 0xc8, 0x0f, 0x10, 0x77, 0x1f, 0x28, 0xa3, 0xc6, 0x01, 0x92, 0x04, 0x98,
    0xd7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0xd3, 0x85, 0xea, 0x00, 0x06, 0x04, 0xdb, 0xdf,
    0xb3, 0x40, 0x00, 0x60, 0x0a, 0x01, 0x06, 0x02, 0x80, 0x9a, 0x61, 0xba, 0x84, 0x86, 0xc4, 0xe1, 0x7e, 0x64, 0x10,
    0xb1, 0x81, 0x00, 0x26, 0x4f, 0x09, 0x3f, 0xc1, 0xc1, 0xa5, 0xea, 0xd2, 0xc1, 0x01, 0x43, 0xa9, 0xc4, 0x8c, 0x18,
    0x02, 0x6b, 0xea, 0xb2, 0x26, 0xca, 0x0a, 0xa0, 0x37, 0x76, 0xa1, 0xc6, 0xa9, 0xaa, 0x26, 0xd3, 0x4d, 0xc1, 0x0e,
    0x51, 0x11, 0x18, 0x95, 0xe6, 0x05, 0x48, 0x60, 0x44, 0x7d, 0x94, 0xa9, 0xca, 0xce, 0xd9, 0x39, 0xad, 0x12, 0x34,
    0xf5, 0x65, 0x36, 0xcc, 0xaa, 0x00, 0x16, 0x07, 0xd2, 0x58, 0x70, 0x64, 0xbb, 0xd3, 0x4d, 0xef, 0x78, 0xdd, 0x89,
    0x6f, 0xba, 0xef, 0x5a, 0x93, 0x73, 0x17, 0xb2, 0xa4, 0x22, 0x70, 0x0b, 0x75, 0x96, 0xa0, 0x00, 0x13, 0x3c, 0xa0,
    0x40, 0x44, 0x46, 0xd6, 0xf1, 0x17, 0xb8, 0x06, 0xd3, 0xa7, 0xf8, 0x16, 0x61, 0xe5, 0x10, 0x54, 0x19, 0xa1, 0x55,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x90, 0x00, 0x24, 0x00, 0x77, 0x99, 0xff, 0xf8, 0xc0, 0x00,
    0xbb, 0x46, 0x02, 0x00, 0x56, 0x61, 0x52, 0x27, 0x06, 0xb2, 0x60, 0x32, 0x18, 0x7a, 0x05, 0x03, 0x4c, 0x4c, 0x02,
    0x40, 0x09, 0x8d, 0x42, 0x4a, 0xb5, 0xb8, 0x12, 0x82, 0xcd, 0x05, 0x03, 0x50, 0x38, 0x82, 0x87, 0xa9, 0x43, 0xee,
    0x48, 0x01, 0x9e, 0xac, 0xb8, 0x5d, 0xa7, 0x6a, 0x8a, 0x83, 0x98, 0xec, 0x74, 0xdd, 0xd9, 0x3f, 0x77, 0xff, 0xfb,
    0x74, 0x64, 0xfc, 0x01, 0x53, 0x6a, 0x25, 0x49, 0xfb, 0xdc, 0x49, 0xf8, 0x26, 0x22, 0x18, 0xed, 0x04, 0x23, 0x0d,
    0x0d, 0x84, 0x91, 0x27, 0xef, 0x71, 0x83, 0xe0, 0x8f, 0x00, 0xa3, 0xb4, 0x20, 0x00, 0x04, 0x1d, 0x4a, 0xa2, 0x28,
    0xa1, 0x61, 0x99, 0x61, 0xd6, 0x6b, 0x07, 0xb1, 0x6d, 0xf5, 0x9e, 0xd5, 0xdd, 0x3e, 0x60, 0xd8, 0xa0, 0x60, 0x4e,
    0x40, 0x30, 0x55, 0xa8, 0x99, 0xcf, 0x7f, 0xfe, 0xb2, 0x0b, 0x41, 0x39, 0x03, 0x8d, 0x80, 0x99, 0xc6, 0x1f, 0x2f,
    0xb4, 0x60, 0x22, 0x7c, 0x12, 0x76, 0x2a, 0xe4, 0x01, 0x14, 0x1f, 0x20, 0xa7, 0x0b, 0x22, 0x70, 0x4f, 0x78, 0x03,
    0xce, 0x45, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x67, 0xaa, 0x00, 0x03, 0x10, 0x07, 0x78, 0x8b, 0xfd,
    0x8c, 0x00, 0x17, 0x11, 0x80, 0x90, 0x0c, 0x98, 0x51, 0x8f, 0xa9, 0xb0, 0x88, 0x38, 0x19, 0x0c, 0x06, 0x0a, 0x02,
    0x12, 0x8a, 0x4c, 0x28, 0x00, 0x31, 0x80, 0x0d, 0x95, 0xc3, 0x24, 0x20, 0xc0, 0xac, 0x99, 0x07, 0x9f, 0x56, 0xa8,
    0xbe, 0x5f, 0x84, 0x78, 0x5b, 0xd3, 0x81, 0x38, 0x46, 0xc5, 0x9a, 0x2a, 0x86, 0x0a, 0xee, 0x30, 0x51, 0xa5, 0xcb,
    0x30, 0x45, 0x67, 0x11, 0x82, 0x96, 0xc6, 0x8a, 0xc0, 0xb9, 0xc4, 0x32, 0xf7, 0xf5, 0xa2, 0xfb, 0x4d, 0xc5, 0xd9,
    0x21, 0x51, 0xa2, 0xad, 0x8b, 0x03, 0x4b, 0x46, 0xa5, 0xfa, 0x2b, 0x5f, 0xd7, 0xbe, 0x9e, 0xf5, 0xe9, 0xe6, 0x7f,
    0xfd, 0x81, 0x46, 0x13, 0x82, 0x59, 0x2c, 0x00, 0x00, 0x08, 0xb9, 0x77, 0x3d, 0x0b, 0xcf, 0x56, 0xe4, 0xbe, 0xe8,
    0xb7, 0x53, 0x86, 0x0d, 0x34, 0x89, 0xe5, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x10, 0x00,
    0x80, 0x01, 0xa4, 0x46, 0xff, 0x41, 0x90, 0x07, 0x0e, 0x03, 0x93, 0x05, 0xf3, 0xd3, 0x34, 0x89, 0x0b, 0x63, 0x2b,
    0x19, 0x2f, 0x40, 0x60, 0x9a, 0xa8, 0x01, 0x8c, 0xda, 0x7a, 0x89, 0x18, 0x20, 0x11, 0xa2, 0xe1, 0x83, 0x99, 0x23,
    0x8d, 0xff, 0xfb, 0x84, 0x64, 0xe8, 0x00, 0x13, 0x64, 0x20, 0x49, 0x6b, 0xdc, 0x48, 0xe8, 0x27, 0x01, 0xc9, 0x1d,
    0x04, 0x02, 0x53, 0x0c, 0x00, 0x79, 0x29, 0xef, 0x71, 0x83, 0xa0, 0xa5, 0x00, 0x23, 0x74, 0x00, 0x00, 0x04, 0xab,
    0x6f, 0x18, 0x70, 0xb2, 0xc0, 0xd8, 0x4c, 0xb2, 0xaa, 0x94, 0x58, 0x32, 0xd9, 0xa7, 0xf5, 0xfc, 0x8d, 0x23, 0x56,
    0x66, 0xb1, 0x99, 0xa1, 0x12, 0x2e, 0x73, 0xb0, 0xa2, 0xc4, 0xdf, 0xaf, 0x71, 0x4b, 0xe6, 0x36, 0x24, 0x38, 0x74,
    0xa2, 0x5a, 0x92, 0xa6, 0x28, 0xa8, 0x0a, 0xa3, 0x5f, 0xab, 0xff, 0x7f, 0x47, 0x47, 0x52, 0x09, 0xa4, 0xe3, 0x01,
    0xc0, 0x09, 0x21, 0x42, 0x0b, 0x7b, 0x85, 0x4b, 0xb2, 0x77, 0xca, 0xba, 0x84, 0x1f, 0x57, 0xfe, 0x96, 0xe4, 0x4f,
    0x27, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x2f, 0x6a, 0x2a, 0x30, 0x02, 0x11, 0x05, 0x78, 0x7f, 0xfe,
    0x6c, 0x00, 0x0c, 0x01, 0x80, 0xb4, 0x70, 0x0d, 0x04, 0x49, 0x52, 0x63, 0x4a, 0x1f, 0x86, 0x2c, 0x62, 0x01, 0x02,
    0x88, 0xa9, 0x88, 0xa3, 0x13, 0xea, 0xf0, 0xc5, 0x00, 0x30, 0xd4, 0x04, 0xb7, 0x8a, 0xbd, 0xf8, 0x89, 0xb7, 0x77,
    0x92, 0x98, 0x46, 0xc6, 0x0b, 0xe0, 0xa5, 0x65, 0x61, 0x04, 0x64, 0xba, 0x6e, 0xaa, 0xe2, 0xdc, 0x98, 0x61, 0x41,
    0x1b, 0x3a, 0x99, 0x8d, 0x9b, 0x0f, 0x7a, 0xad, 0xdf, 0x97, 0xdd, 0xee, 0x1e, 0xb5, 0x0a, 0x80, 0xd3, 0x24, 0x60,
    0xc0, 0x62, 0xa6, 0x5b, 0xf6, 0xfa, 0x7f, 0x4d, 0x3d, 0x7a, 0x3a, 0xb6, 0x14, 0x43, 0x6a, 0x07, 0x5c, 0x8c, 0x00,
    0x00, 0x17, 0x17, 0x5a, 0x80, 0x61, 0x44, 0x42, 0x54, 0xcb, 0xb8, 0x38, 0xe3, 0x87, 0x14, 0xc0, 0x74, 0x83, 0x14,
    0x09, 0x18, 0x22, 0x2e, 0xc9, 0x51, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x46, 0xe5, 0x10, 0x00,
    0x8b, 0x04, 0x44, 0x37, 0xfb, 0x44, 0x00, 0x06, 0x02, 0x00, 0x42, 0x60, 0x2e, 0x06, 0xc6, 0x0d, 0x48, 0xca, 0x65,
    0x98, 0x1d, 0x47, 0xae, 0x97, 0x78, 0xf6, 0x14, 0x96, 0x3f, 0x46, 0xea, 0x7a, 0x88, 0x06, 0x0a, 0xd4, 0xbb, 0x6d,
    0x7a, 0x07, 0xa2, 0x05, 0x32, 0xd1, 0x1c, 0x44, 0xb9, 0xcb, 0xce, 0x83, 0x86, 0x03, 0x4d, 0x64, 0x50, 0x52, 0x47,
    0x20, 0xb5, 0xde, 0xa4, 0xe8, 0xb5, 0xc2, 0x74, 0xd3, 0xae, 0xdc, 0xcb, 0x16, 0x00, 0xff, 0xfb, 0x74, 0x64, 0xef,
    0x81, 0x13, 0x3b, 0x23, 0xc9, 0xfb, 0xdc, 0x40, 0xe8, 0x22, 0xc0, 0x19, 0x0d, 0x04, 0x00, 0x01, 0x0b, 0xd0, 0x7f,
    0x27, 0xef, 0x6d, 0x23, 0xa0, 0x8a, 0x80, 0x23, 0xb4, 0x00, 0x00, 0x04, 0x08, 0xce, 0x1d, 0x78, 0x22, 0x22, 0xef,
    0x53, 0xd9, 0xff, 0xf1, 0x4f, 0xf4, 0x7d, 0x0a, 0xb9, 0xcd, 0x42, 0xd0, 0x09, 0x05, 0x04, 0x82, 0xd0, 0x02, 0x76,
    0xe1, 0x6a, 0x2f, 0x3b, 0x14, 0x32, 0x65, 0x7e, 0x0e, 0x24, 0x64, 0xc1, 0xf8, 0x17, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xbb, 0xff, 0xff, 0xff, 0x26, 0xaa, 0x00, 0x03, 0x19, 0x07, 0x87, 0x7f, 0xfe, 0x8c, 0x00, 0x0c, 0x00, 0x00,
    0x04, 0xc0, 0x4c, 0x02, 0x8c, 0x2a, 0x0c, 0x1c, 0xd4, 0x40, 0x21, 0x8e, 0x00, 0x91, 0xa1, 0xe6, 0xa8, 0xd0, 0xd0,
    0x60, 0xc8, 0xef, 0xc1, 0x81, 0x06, 0x15, 0x2a, 0x63, 0x8c, 0xae, 0x3b, 0xcd, 0x30, 0x74, 0xe0, 0x88, 0x97, 0x66,
    0x63, 0x67, 0xb3, 0xa6, 0x14, 0x4d, 0x98, 0x23, 0x62, 0x18, 0xba, 0x4d, 0x34, 0x19, 0x24, 0xa9, 0xcd, 0x85, 0x63,
    0x14, 0x12, 0x74, 0x66, 0xbb, 0xee, 0x73, 0x86, 0xff, 0x1a, 0xa8, 0xd5, 0x6e, 0x4f, 0xca, 0xdc, 0x7d, 0x24, 0xc9,
    0x3e, 0x58, 0xf1, 0x2c, 0xd7, 0xaf, 0xb2, 0xea, 0x3f, 0xfd, 0xad, 0xb2, 0x30, 0x20, 0x0a, 0x50, 0x3b, 0x24, 0x60,
    0x00, 0x02, 0xc1, 0xdb, 0x47, 0x47, 0x82, 0x2e, 0xda, 0x25, 0x01, 0x8c, 0x84, 0xcc, 0x0f, 0x22, 0x2c, 0xf4, 0x95,
    0x02, 0x8b, 0x32, 0x51, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x6c, 0xbd, 0x02, 0x00, 0x02,
    0xc1, 0x11, 0x0f, 0xf7, 0xd0, 0xbd, 0x24, 0xc0, 0x6c, 0x61, 0x34, 0x0d, 0x66, 0x9e, 0xc0, 0x0e, 0x47, 0xe0, 0x70,
    0x43, 0x6a, 0xba, 0x66, 0x51, 0x51, 0xa5, 0x55, 0x0a, 0x04, 0x09, 0xb9, 0xe4, 0xd8, 0x80, 0x13, 0x48, 0x14, 0x6a,
    0x27, 0x60, 0xe8, 0x67, 0x61, 0x3a, 0xc1, 0x95, 0x95, 0x94, 0x13, 0x97, 0xc6, 0x96, 0xf0, 0xe9, 0xa1, 0xff, 0xfb,
    0x84, 0x64, 0xe7, 0x80, 0x12, 0xf9, 0x20, 0x49, 0xfb, 0xd9, 0x48, 0xe8, 0x2b, 0x00, 0x08, 0xed, 0x00, 0x00, 0x01,
    0x0b, 0x64, 0x7d, 0x27, 0xef, 0x60, 0xc3, 0x60, 0x85, 0x00, 0x63, 0xb4, 0x10, 0x00, 0x00, 0x85, 0xdb, 0x9b, 0x43,
    0xf7, 0x23, 0xaa, 0x0d, 0x5a, 0x21, 0xe7, 0x56, 0x87, 0xbb, 0x93, 0x48, 0x15, 0x1f, 0xff, 0xbf, 0xff, 0xfe, 0xb4,
    0x2f, 0xd4, 0x0a, 0x0c, 0x44, 0x6d, 0x80, 0xd2, 0x1a, 0x2f, 0x40, 0x88, 0x00, 0xca, 0x83, 0xbc, 0x44, 0x06, 0x03,
    0x3d, 0x8e, 0x33, 0x32, 0x80, 0xb0, 0x8d, 0xe0, 0x02, 0x20, 0x91, 0xaf, 0xff, 0xf6, 0xff, 0xfa, 0x7b, 0xfd, 0xfa,
    0x7f, 0xfd, 0x1b, 0x3e, 0x8d, 0x4f, 0x1b, 0x59, 0x44, 0x19, 0x6a, 0xea, 0x00, 0x02, 0x35, 0x09, 0x78, 0x8f, 0xfe,
    0x8c, 0x00, 0x1a, 0xc1, 0x80, 0x18, 0x01, 0x98, 0x3d, 0x10, 0x51, 0xa1, 0x90, 0x41, 0x9d, 0xc2, 0x0b, 0x0c, 0x75,
    0x9e, 0x95, 0xc6, 0x82, 0xf3, 0x8b, 0xfc, 0x64, 0x90, 0x6f, 0xb3, 0x7a, 0xb2, 0xfa, 0x46, 0xef, 0xc8, 0x73, 0xca,
    0x25, 0x6e, 0xcd, 0x96, 0x76, 0x1d, 0x3a, 0x61, 0xa2, 0xe5, 0x02, 0xd1, 0x05, 0x7f, 0xa6, 0xe1, 0xe4, 0x7a, 0x24,
    0x6e, 0x52, 0xdb, 0xd7, 0xac, 0x68, 0x2e, 0x61, 0x70, 0xe8, 0xf6, 0x89, 0xac, 0x9e, 0x49, 0xa7, 0x9d, 0x1e, 0xbf,
    0x51, 0x09, 0x06, 0xe2, 0x8e, 0xda, 0x00, 0x00, 0x03, 0x45, 0xde, 0x4a, 0xf5, 0xad, 0xae, 0x30, 0x0e, 0x37, 0x03,
    0x19, 0x14, 0x0c, 0x98, 0x41, 0x93, 0x35, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdb, 0xff, 0xfc, 0xbd,
    0x18, 0xd1, 0x02, 0x00, 0x70, 0x87, 0x78, 0xff, 0xe6, 0x80, 0x00, 0x46, 0x03, 0x08, 0xc2, 0x53, 0x0f, 0x38, 0x03,
    0x9f, 0x0d, 0xd3, 0x93, 0xe3, 0x17, 0x13, 0x84, 0xc5, 0x03, 0x08, 0x89, 0xc8, 0x41, 0xf1, 0x12, 0x06, 0xf7, 0xcc,
    0x5b, 0x17, 0xee, 0x53, 0x12, 0x92, 0xf3, 0x73, 0x4e, 0xe4, 0x6c, 0x54, 0xcb, 0x18, 0x61, 0xe8, 0x09, 0x44, 0x41,
    0x63, 0x41, 0x4b, 0x3e, 0x75, 0x45, 0x18, 0x84, 0xa3, 0xa7, 0x32, 0xc6, 0x51, 0xa7, 0x41, 0x03, 0x30, 0x0b, 0x45,
    0xf3, 0xc1, 0x9f, 0x67, 0x97, 0xe8, 0x3a, 0xfe, 0xdb, 0x28, 0xd9, 0xd9, 0xd2, 0x6d, 0x04, 0x5c, 0x72, 0x0b, 0x6c,
    0x01, 0x0f, 0x1a, 0x82, 0xe2, 0x25, 0x14, 0xbd, 0xf2, 0x84, 0x12, 0xff, 0xfb, 0x74, 0x64, 0xfa, 0x01, 0x13, 0x26,
    0x27, 0x49, 0xfb, 0xda, 0x48, 0xc8, 0x29, 0xa0, 0x18, 0xed, 0x00, 0x00, 0x01, 0x0a, 0x50, 0x77, 0x29, 0xef, 0x65,
    0x23, 0x20, 0xbd, 0x80, 0x22, 0xe8, 0x00, 0x00, 0x00, 0x2e, 0x22, 0x0e, 0x1b, 0x0b, 0x89, 0x45, 0x30, 0xea, 0x4f,
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x8a, 0x10, 0x00, 0x05, 0x08, 0x76, 0x6d, 0xf5, 0x6c,
    0x00, 0x0c, 0x00, 0xc0, 0x38, 0xc0, 0x18, 0x08, 0xcc, 0x04, 0x50, 0x28, 0xc5, 0xbc, 0x35, 0x4d, 0x16, 0x80, 0x88,
    0x9f, 0x46, 0x2e, 0xd1, 0xb0, 0x23, 0xea, 0x6c, 0x44, 0x81, 0xee, 0xaa, 0xb4, 0x51, 0xb1, 0x08, 0x53, 0x5c, 0x9d,
    0x8e, 0xe3, 0x55, 0xa5, 0xdc, 0x9d, 0x94, 0xf4, 0x31, 0x0f, 0x87, 0x8f, 0x04, 0xd2, 0xd8, 0xe0, 0x97, 0x24, 0xb2,
    0x0f, 0x78, 0x29, 0xa2, 0x9e, 0x6c, 0xcc, 0xef, 0x0c, 0xdd, 0xda, 0xa7, 0x7c, 0xdb, 0xf7, 0x7f, 0xde, 0x1f, 0xfc,
    0x67, 0x77, 0xfe, 0x52, 0xe2, 0xfd, 0xbf, 0xdd, 0x57, 0xfd, 0xd1, 0x9f, 0x5f, 0x67, 0xd8, 0x84, 0x14, 0x71, 0xc9,
    0x44, 0x72, 0x00, 0x00, 0x06, 0x94, 0x82, 0x2a, 0x78, 0x71, 0x01, 0xc2, 0x86, 0xcd, 0x23, 0x94, 0x2e, 0x2e, 0xa1,
    0x44, 0xe2, 0x81, 0x74, 0xaa, 0x50, 0x46, 0xa3, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x00,
    0x08, 0xd1, 0xf7, 0xff, 0xfd, 0x0b, 0xbc, 0x1c, 0x04, 0x98, 0x9f, 0x57, 0x1e, 0x76, 0x33, 0x80, 0xce, 0x2c, 0xc1,
    0xd5, 0x4a, 0x56, 0x1c, 0xe7, 0xf1, 0x4a, 0x81, 0x41, 0x9c, 0x42, 0xb4, 0x3b, 0xc0, 0x1c, 0xc1, 0xbe, 0xb4, 0x51,
    0x65, 0xb4, 0xde, 0x5b, 0x51, 0x21, 0x54, 0x9a, 0xcb, 0x4c, 0x50, 0x9c, 0x52, 0x19, 0xd5, 0x91, 0x36, 0xde, 0xca,
    0xdf, 0x52, 0x94, 0xdf, 0x18, 0xc6, 0x11, 0xca, 0x4a, 0x15, 0x26, 0x3e, 0xb4, 0x09, 0xbc, 0x1c, 0x1c, 0x48, 0x98,
    0xb3, 0xde, 0xc5, 0x5b, 0xd1, 0xdd, 0x62, 0x5f, 0x43, 0x5f, 0x47, 0x47, 0x5b, 0x13, 0xff, 0xfb, 0x74, 0x64, 0xef,
    0x80, 0x12, 0x9d, 0x1f, 0xca, 0x7b, 0xd9, 0x30, 0xf8, 0x26, 0xe0, 0x18, 0xed, 0x00, 0x00, 0x00, 0x0b, 0x08, 0x83,
    0x27, 0xee, 0xe4, 0xc3, 0xa0, 0x93, 0x00, 0x23, 0xf4, 0x00, 0x00, 0x04, 0xcd, 0x10, 0x93, 0x90, 0x07, 0x24, 0x80,
    0x1f, 0x58, 0x64, 0xb3, 0x44, 0x4f, 0x3d, 0xa9, 0x94, 0x1a, 0x13, 0xa9, 0x25, 0x14, 0x0b, 0xda, 0x30, 0xc1, 0xe7,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x66, 0xde, 0xc2, 0xd5, 0x10, 0x00, 0x37, 0x08, 0x68, 0x8f,
    0xfe, 0x8c, 0x80, 0x13, 0xa8, 0xc0, 0xa0, 0x08, 0xc5, 0x34, 0x28, 0x9e, 0xc7, 0x29, 0x29, 0x8a, 0x07, 0xfe, 0xca,
    0xca, 0xb8, 0x44, 0xd3, 0xa4, 0x60, 0x83, 0x26, 0xc6, 0xd3, 0x39, 0x03, 0xef, 0x60, 0xc7, 0xd4, 0x4d, 0xa4, 0x48,
    0x68, 0x4b, 0x12, 0x35, 0x1c, 0x68, 0x19, 0xe1, 0x12, 0xdb, 0x00, 0xd4, 0xfb, 0xca, 0xeb, 0x79, 0xb6, 0x77, 0xdb,
    0x89, 0x72, 0x80, 0x05, 0x80, 0x69, 0x29, 0x13, 0x11, 0x37, 0x71, 0xed, 0x1b, 0xd1, 0xb0, 0x5f, 0x4f, 0xf5, 0x92,
    0x1a, 0x85, 0xb9, 0x24, 0xb1, 0x00, 0x00, 0x3b, 0x1c, 0x0a, 0x03, 0x97, 0x25, 0x10, 0x15, 0x66, 0x29, 0x55, 0x58,
    0x9e, 0x39, 0x6b, 0x90, 0x4b, 0x15, 0xad, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5f, 0xff, 0xff, 0xbe, 0x8a, 0xc8,
    0x2a, 0x31, 0xff, 0xff, 0xfc, 0xd8, 0x00, 0x38, 0xe6, 0x00, 0x03, 0x06, 0x31, 0x9c, 0x27, 0xb7, 0x8b, 0x00, 0xeb,
    0xe0, 0x01, 0x64, 0x8b, 0x8b, 0x62, 0x0c, 0x36, 0xe3, 0xc4, 0x10, 0x42, 0x23, 0x8b, 0x19, 0xd3, 0xa3, 0x31, 0xe7,
    0xa1, 0x42, 0x17, 0x1f, 0xa6, 0x9c, 0x9a, 0x76, 0x03, 0xd0, 0x51, 0x20, 0x30, 0x69, 0x30, 0x0e, 0x95, 0xa8, 0x18,
    0x4a, 0xd0, 0xe4, 0x3d, 0x61, 0x10, 0x78, 0xd8, 0xa8, 0x90, 0x20, 0x97, 0xd7, 0x43, 0x58, 0x7c, 0xbb, 0xd0, 0x2b,
    0x02, 0x7f, 0x4e, 0xaf, 0x67, 0xad, 0x06, 0xa4, 0x96, 0x81, 0x65, 0x00, 0x5d, 0xa0, 0x41, 0x61, 0x44, 0xff, 0xfb,
    0x74, 0x64, 0xf1, 0x81, 0x13, 0x1c, 0x2f, 0xc9, 0x7b, 0xd9, 0x30, 0xe8, 0x28, 0xc0, 0x18, 0xfd, 0x04, 0x00, 0x01,
    0x0b, 0x7c, 0x8d, 0x27, 0xae, 0xe5, 0x23, 0x20, 0x95, 0x00, 0x23, 0xb4, 0x00, 0x00, 0x04, 0x10, 0x01, 0x9e, 0x00,
    0x3b, 0xc3, 0x06, 0x40, 0x39, 0xf6, 0x8c, 0x30, 0x04, 0x12, 0x1d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfb, 0x50, 0x20, 0x20, 0x65, 0x07, 0x68, 0x8f, 0xbf, 0x88, 0x00, 0x13, 0x74, 0x40, 0x0b, 0x18, 0x76, 0xe5,
    0x9c, 0x9a, 0x31, 0x1a, 0x6a, 0x98, 0x83, 0x01, 0xf5, 0x50, 0x43, 0x3a, 0x80, 0x52, 0xf0, 0x82, 0xef, 0x1a, 0x96,
    0x42, 0xac, 0x81, 0x51, 0x94, 0xfe, 0x89, 0xdb, 0xb9, 0x1b, 0x38, 0x95, 0xe0, 0xa0, 0x99, 0x12, 0xc5, 0x17, 0x46,
    0x44, 0x7b, 0x98, 0xf1, 0xb5, 0xdf, 0x09, 0x33, 0xaa, 0xcd, 0x86, 0xdb, 0x6a, 0x09, 0x2c, 0xb1, 0xd4, 0x68, 0x2c,
    0x30, 0x05, 0x01, 0x8f, 0x0b, 0x1f, 0x03, 0xea, 0xab, 0x5d, 0xbd, 0xbf, 0xff, 0xb3, 0x5f, 0xfd, 0xe9, 0x81, 0xa4,
    0xdb, 0x6d, 0x8f, 0x00, 0x00, 0x90, 0x69, 0x05, 0x84, 0x63, 0x09, 0x48, 0x39, 0x63, 0xf5, 0x23, 0xf7, 0xc1, 0xf5,
    0x26, 0xac, 0xa2, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x26, 0x84, 0x0a, 0x86, 0x10, 0x04, 0x06,
    0x01, 0xd9, 0xdf, 0xfd, 0x5b, 0x00, 0x00, 0x00, 0x2e, 0x32, 0x17, 0x15, 0x67, 0x53, 0x3d, 0x46, 0xe1, 0x44, 0x46,
    0x5e, 0x37, 0xd5, 0x65, 0x46, 0xe8, 0xf3, 0xac, 0xfd, 0x27, 0x0e, 0x92, 0xda, 0xb5, 0xf0, 0x80, 0xf9, 0xe8, 0x36,
    0xc3, 0x0c, 0xa1, 0xf0, 0xdd, 0x9a, 0x05, 0xf4, 0xfb, 0xcc, 0x48, 0x54, 0xd8, 0xb3, 0x03, 0xcb, 0x64, 0xd3, 0xa9,
    0x15, 0xc6, 0xd2, 0x86, 0x5f, 0x54, 0x28, 0x51, 0x21, 0x92, 0x63, 0x85, 0x82, 0xec, 0x0e, 0x07, 0x1c, 0x13, 0xb4,
    0x16, 0x71, 0xa1, 0x09, 0xdb, 0x17, 0xfa, 0xe9, 0x61, 0x5a, 0xad, 0xb7, 0x5d, 0x3e, 0x9b, 0xad, 0xff, 0xff, 0xff,
    0x5b, 0xff, 0xfb, 0x74, 0x64, 0xe8, 0x80, 0x12, 0x89, 0x1f, 0x4a, 0x7b, 0xb9, 0x30, 0xd8, 0x26, 0x20, 0x18, 0xed,
    0x04, 0x00, 0x00, 0x0a, 0x50, 0x6f, 0x27, 0xae, 0xe8, 0xc3, 0x60, 0x94, 0x80, 0x24, 0x34, 0x00, 0x00, 0x04, 0x08,
    0xa5, 0x28, 0xa2, 0x48, 0x09, 0x46, 0xad, 0x4c, 0x30, 0x1a, 0x2c, 0x62, 0x80, 0xeb, 0xf3, 0x0f, 0x02, 0x87, 0x62,
    0x13, 0x4d, 0x61, 0xf6, 0x3f, 0xea, 0x4d, 0x14, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x9a, 0x40, 0x20,
    0x05, 0x06, 0x68, 0x6b, 0xfd, 0x48, 0x00, 0x0c, 0x0c, 0x06, 0xcc, 0x15, 0x0c, 0x8c, 0x24, 0xa8, 0x4d, 0x3a, 0x1a,
    0x0d, 0xa7, 0x4d, 0x34, 0xcf, 0xb4, 0x19, 0x58, 0x11, 0x69, 0x52, 0x16, 0xb0, 0x63, 0xa0, 0xf4, 0xe3, 0xbc, 0xdb,
    0xc9, 0xaf, 0xd7, 0xcf, 0xb0, 0xfc, 0x5a, 0x2b, 0x2f, 0x0a, 0x85, 0xbc, 0xcd, 0x44, 0x19, 0x20, 0x89, 0x8f, 0x05,
    0x30, 0x81, 0xc3, 0x41, 0xb4, 0x71, 0x32, 0x34, 0x24, 0xba, 0xd4, 0x3f, 0x79, 0xf2, 0x4e, 0x5a, 0x2c, 0xb6, 0xb2,
    0x1f, 0x03, 0x02, 0xa2, 0x11, 0xc0, 0xeb, 0xda, 0x51, 0x87, 0xbd, 0x0e, 0x28, 0xa6, 0xae, 0x2d, 0xd5, 0xe6, 0x6a,
    0xbf, 0xd0, 0x99, 0x85, 0xfd, 0xba, 0x2a, 0x61, 0x8b, 0x40, 0x12, 0xd0, 0x00, 0x00, 0x20, 0xe2, 0x70, 0xb2, 0xd5,
    0x70, 0x98, 0x8f, 0xe8, 0x5c, 0x91, 0x31, 0xe3, 0xc3, 0x83, 0x47, 0x82, 0x44, 0x04, 0x42, 0xe1, 0x0c, 0xcd, 0xf7,
    0xd1, 0x80, 0x02, 0x12, 0x40, 0x20, 0x03, 0x13, 0x61, 0xcf, 0x80, 0x16, 0x01, 0x72, 0x58, 0x34, 0x8b, 0x45, 0x70,
    0x6a, 0x33, 0x2b, 0x5e, 0xc6, 0x01, 0x46, 0x3c, 0x8e, 0xe5, 0xd0, 0x04, 0xd0, 0xa2, 0xe7, 0xb1, 0xcd, 0x97, 0xb9,
    0x5f, 0x28, 0x44, 0x42, 0x5c, 0x7a, 0x4b, 0x2c, 0xba, 0x7e, 0x30, 0x42, 0xe8, 0x26, 0x65, 0x3f, 0x35, 0x10, 0xce,
    0x4f, 0x9c, 0xb1, 0x88, 0x9c, 0x36, 0x48, 0x1a, 0x02, 0x34, 0xd0, 0xc1, 0x42, 0x31, 0xc3, 0xdd, 0x5a, 0x77, 0xff,
    0xab, 0x26, 0x98, 0x01, 0xff, 0xfb, 0x74, 0x64, 0xef, 0x00, 0x12, 0xd0, 0x20, 0x49, 0xfb, 0xb9, 0x48, 0xc8, 0x25,
    0x40, 0x28, 0xdc, 0x08, 0x00, 0x01, 0x0c, 0x4c, 0x71, 0x25, 0xee, 0xe5, 0x23, 0x20, 0x93, 0x80, 0x23, 0xf4, 0x00,
    0x00, 0x04, 0x86, 0x1c, 0x4e, 0x30, 0x05, 0x19, 0x96, 0x74, 0x23, 0xac, 0xd4, 0x9b, 0xab, 0x34, 0xf2, 0xcc, 0x2a,
    0x4d, 0xa4, 0x4e, 0x98, 0x22, 0x2e, 0x21, 0x24, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x7d, 0xd9,
    0x12, 0x15, 0x30, 0x11, 0x04, 0x08, 0x67, 0x8f, 0xb6, 0x8c, 0x00, 0x10, 0x74, 0x0c, 0x0b, 0x18, 0x54, 0x69, 0x9c,
    0x30, 0x03, 0x0d, 0x42, 0xc1, 0x81, 0xd4, 0xb8, 0x61, 0x23, 0x3f, 0x8c, 0xc8, 0x80, 0x91, 0x13, 0x6c, 0x17, 0x20,
    0x34, 0x1a, 0x55, 0xf2, 0xa4, 0x6d, 0xdf, 0x49, 0x5c, 0xb4, 0x99, 0x68, 0x44, 0xe9, 0x94, 0x75, 0x97, 0xb4, 0x2c,
    0x64, 0x64, 0xf4, 0xa5, 0x33, 0xaa, 0xa0, 0xb9, 0x45, 0x2a, 0x66, 0xb6, 0x1b, 0x95, 0x9f, 0x32, 0x37, 0x94, 0x94,
    0x8c, 0x0e, 0x93, 0x32, 0x51, 0x2f, 0x14, 0x0f, 0xf5, 0x7f, 0xf4, 0x76, 0x52, 0xcd, 0xb5, 0xc8, 0x82, 0x56, 0xdc,
    0x00, 0x00, 0x01, 0xc1, 0x3b, 0xce, 0xed, 0xcf, 0x21, 0x00, 0x98, 0x8a, 0x70, 0x9b, 0xd6, 0x59, 0x85, 0x84, 0xcf,
    0x0c, 0x12, 0xff, 0xeb, 0xff, 0xff, 0x7f, 0xfe, 0xbb, 0xbf, 0xd9, 0xfb, 0xbf, 0x47, 0x9a, 0x45, 0x76, 0xd9, 0x0c,
    0x8a, 0x06, 0x90, 0x04, 0xc1, 0x41, 0xd6, 0x1f, 0xff, 0x9a, 0x00, 0x04, 0x91, 0x12, 0x0a, 0xcc, 0x28, 0x09, 0x83,
    0xc5, 0x12, 0x6a, 0x17, 0x18, 0x48, 0xef, 0xf8, 0x2d, 0x48, 0xba, 0xf1, 0x44, 0x20, 0x21, 0x14, 0xdc, 0x24, 0x6b,
    0x63, 0x73, 0xc8, 0x1b, 0xb0, 0x72, 0x9c, 0xa4, 0x93, 0xb2, 0x40, 0x62, 0xa5, 0x35, 0x1d, 0xca, 0x48, 0xdc, 0x44,
    0x29, 0xc4, 0x1b, 0xd5, 0x8b, 0x39, 0x12, 0x31, 0x7b, 0x09, 0x04, 0x6e, 0x24, 0x65, 0xe6, 0x3f, 0xb1, 0x9f, 0xfd,
    0xfa, 0x11, 0xf6, 0xdb, 0xec, 0x28, 0x35, 0xff, 0xfb, 0x74, 0x64, 0xe9, 0x80, 0x13, 0x3a, 0x1f, 0xc8, 0xfb, 0xb9,
    0x30, 0xf8, 0x19, 0x20, 0x29, 0x0d, 0x0c, 0x00, 0x01, 0x0a, 0x90, 0x7b, 0x27, 0xee, 0x65, 0x23, 0x20, 0x9e, 0x00,
    0x63, 0x74, 0x00, 0x00, 0x04, 0x20, 0x01, 0xca, 0xd8, 0x88, 0x29, 0x52, 0x33, 0x18, 0x84, 0x5f, 0xbe, 0xd6, 0xc3,
    0xac, 0x6e, 0xf0, 0x4b, 0x6e, 0x03, 0x4d, 0x91, 0x3a, 0x4e, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x62, 0xcb, 0xf7, 0xb9, 0x40, 0x25, 0x26, 0x07, 0x78, 0x6d, 0xfe, 0x8c, 0x80, 0x18, 0x61, 0x81, 0xc2, 0x26, 0x14,
    0x71, 0x1e, 0x60, 0x42, 0x0a, 0x90, 0xbd, 0xe0, 0xc9, 0x82, 0xa5, 0x1c, 0xb1, 0xc5, 0x11, 0x29, 0x66, 0x84, 0x07,
    0x26, 0xf8, 0x0e, 0x8b, 0x68, 0x39, 0x30, 0x7b, 0x01, 0x77, 0x6f, 0xce, 0x8f, 0xb1, 0xeb, 0xa0, 0x19, 0x0b, 0x3d,
    0x91, 0x82, 0xf7, 0x5d, 0x54, 0x49, 0xc2, 0xe2, 0x82, 0x62, 0x02, 0x80, 0x32, 0x84, 0xc5, 0x41, 0xe2, 0xa9, 0x4a,
    0x96, 0x84, 0x62, 0xb8, 0xa5, 0x3b, 0x72, 0x69, 0xdd, 0xff, 0x6e, 0x8d, 0x08, 0x0e, 0x8a, 0xf5, 0xb4, 0x00, 0x00,
    0x12, 0x16, 0x74, 0xef, 0xfe, 0x2d, 0x3f, 0xf7, 0xf7, 0x86, 0x81, 0xf3, 0x71, 0xea, 0xec, 0x65, 0x9c, 0x77, 0x36,
    0x54, 0x40, 0x44, 0x20, 0x19, 0x9e, 0x2f, 0xd5, 0xb0, 0x00, 0x66, 0x43, 0xa0, 0xd3, 0x04, 0x6c, 0x0e, 0x5c, 0x49,
    0x02, 0x02, 0x26, 0x53, 0xd4, 0x08, 0x81, 0x7d, 0x18, 0x0e, 0xea, 0x7d, 0x15, 0x82, 0x77, 0xe5, 0x93, 0xd5, 0x95,
    0x3b, 0x9a, 0xb2, 0x01, 0x10, 0x89, 0x09, 0x23, 0xa3, 0x93, 0x74, 0xa7, 0xb5, 0x28, 0xa2, 0x21, 0x46, 0xda, 0xb5,
    0xad, 0xc5, 0x00, 0xe2, 0x05, 0xc4, 0x61, 0x60, 0x44, 0x0a, 0x55, 0x62, 0x54, 0x18, 0x3e, 0x45, 0x45, 0xcc, 0x11,
    0x42, 0x81, 0xc6, 0xff, 0x4d, 0x9b, 0x6a, 0xa6, 0x91, 0xcd, 0xd5, 0xfb, 0x2a, 0x67, 0xd5, 0x18, 0x4d, 0x30, 0x2d,
    0x91, 0xc0, 0x19, 0x4b, 0x30, 0xd0, 0x11, 0x2f, 0xe9, 0x0b, 0xff, 0xfb, 0x74, 0x64, 0xe9, 0x00, 0x12, 0xc9, 0x25,
    0x49, 0xfb, 0xb9, 0x48, 0xc8, 0x2c, 0x20, 0x18, 0xba, 0x00, 0x00, 0x00, 0x09, 0xd8, 0x7d, 0x27, 0xee, 0xe4, 0xc3,
    0x20, 0x9b, 0x0a, 0xa3, 0xb4, 0x10, 0x0d, 0x94, 0x80, 0x9a, 0x78, 0x3a, 0x71, 0xe7, 0x61, 0x54, 0x5e, 0xe8, 0x9c,
    0xf1, 0x05, 0xcd, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xec, 0xeb, 0x30, 0x24, 0x08, 0x17, 0x67,
    0x7f, 0xfe, 0x6c, 0x00, 0x02, 0xe0, 0x00, 0xb0, 0x84, 0x67, 0x14, 0x64, 0xf2, 0x18, 0x84, 0x48, 0x20, 0xfb, 0x4d,
    0x0e, 0x07, 0x11, 0x30, 0xda, 0x83, 0xa8, 0xa0, 0x40, 0xcf, 0x67, 0x96, 0x92, 0x9d, 0xf0, 0x65, 0x97, 0xd2, 0xe1,
    0xe7, 0x13, 0x34, 0x72, 0x65, 0x83, 0x19, 0xd2, 0x52, 0x10, 0x46, 0xd0, 0x81, 0x88, 0x30, 0x96, 0xac, 0x4d, 0x9d,
    0x0d, 0x39, 0x7b, 0xed, 0x1e, 0x10, 0x44, 0xbb, 0x0b, 0x0b, 0xb1, 0xaa, 0x16, 0x4c, 0xd1, 0x2f, 0xfc, 0xcf, 0xff,
    0x6f, 0xdf, 0xd1, 0xca, 0x24, 0x7a, 0x91, 0x10, 0x00, 0x02, 0x98, 0xf3, 0x45, 0x05, 0x11, 0x7a, 0x69, 0x24, 0xa5,
    0xb1, 0x59, 0x23, 0xe3, 0x43, 0x6d, 0x16, 0x22, 0x87, 0x33, 0xaf, 0x6f, 0xff, 0xff, 0xff, 0xb1, 0x1b, 0x7f, 0xff,
    0xf1, 0xdf, 0xaf, 0xec, 0x59, 0x54, 0x0a, 0x96, 0x37, 0x30, 0xa0, 0x86, 0x32, 0x2e, 0xf0, 0xff, 0xff, 0x20, 0x00,
    0x18, 0x14, 0x14, 0x61, 0x61, 0x29, 0x81, 0xe2, 0x07, 0x37, 0x13, 0x9d, 0x67, 0x03, 0x13, 0x37, 0xcc, 0x79, 0xca,
    0x6b, 0x77, 0x0c, 0x30, 0x8b, 0x8a, 0x16, 0x3e, 0x1f, 0xe1, 0x3c, 0xb1, 0x18, 0xe9, 0x22, 0xa0, 0x93, 0xe5, 0xe3,
    0x10, 0x28, 0xbc, 0x39, 0x2b, 0x49, 0x02, 0x31, 0x36, 0xe4, 0xae, 0x73, 0x0c, 0x2b, 0x02, 0xec, 0x89, 0x27, 0x35,
    0xb2, 0x08, 0x26, 0x05, 0x66, 0x5b, 0x10, 0xac, 0xa8, 0x78, 0x4c, 0xb1, 0x00, 0x98, 0xb9, 0x65, 0x00, 0x3d, 0xbf,
    0xff, 0xff, 0xfe, 0xa6, 0x42, 0x2d, 0xb1, 0x23, 0x88, 0x03, 0x78, 0x4d, 0x84, 0xff, 0xfb, 0x74, 0x64, 0xe9, 0x80,
    0x12, 0x9c, 0x1b, 0x4a, 0x7b, 0x99, 0x30, 0xc8, 0x1b, 0x40, 0x39, 0x0d, 0x18, 0x20, 0x01, 0x4b, 0x44, 0x65, 0x25,
    0xee, 0x61, 0x23, 0x20, 0x9c, 0x80, 0xa3, 0xf4, 0x30, 0x00, 0x04, 0x0d, 0x25, 0xb6, 0xd0, 0x19, 0x01, 0x24, 0xf9,
    0x3c, 0x60, 0x80, 0xd7, 0xb3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x41, 0xcd, 0x29, 0x61, 0x21,
    0x86, 0xdf, 0xff, 0xb3, 0x40, 0x00, 0x5d, 0xa2, 0x60, 0x80, 0xc2, 0x32, 0x98, 0xe2, 0x10, 0x04, 0x4d, 0x60, 0xc1,
    0x43, 0xdc, 0x48, 0x93, 0x89, 0x08, 0xba, 0x70, 0x88, 0xc8, 0x25, 0x52, 0x5d, 0xed, 0xdc, 0x9d, 0xe6, 0x21, 0x94,
    0x15, 0x3b, 0x34, 0xa4, 0xa2, 0x35, 0x45, 0x4a, 0x12, 0x95, 0x56, 0x04, 0x48, 0x51, 0xc5, 0x26, 0xd5, 0xae, 0x69,
    0xec, 0xe5, 0xdc, 0xd6, 0x82, 0x8c, 0x3f, 0xb4, 0xc2, 0xc4, 0x83, 0x66, 0x84, 0x24, 0x9e, 0x91, 0x23, 0x17, 0x71,
    0x14, 0x31, 0xfb, 0x3e, 0xbb, 0xe6, 0xdf, 0xd0, 0xeb, 0x9b, 0xdb, 0xbf, 0xe8, 0x8d, 0x02, 0xe3, 0x72, 0x5f, 0x00,
    0x00, 0xc1, 0xc5, 0xc4, 0xad, 0x70, 0x40, 0x22, 0x44, 0x71, 0xb4, 0x06, 0x02, 0x6e, 0x14, 0x17, 0x4d, 0x6c, 0x15,
    0x95, 0x70, 0xa2, 0xd0, 0xf6, 0xab, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xeb, 0x50, 0x23, 0x27, 0x08,
    0x77, 0x8f, 0xff, 0x90, 0x00, 0x15, 0x79, 0x85, 0x05, 0x46, 0x13, 0x28, 0x9e, 0x2c, 0x10, 0x1d, 0x59, 0x7b, 0x04,
    0x28, 0x8a, 0x08, 0x01, 0xc6, 0x65, 0x0d, 0xa5, 0x28, 0x87, 0x3b, 0xd1, 0xc7, 0xaa, 0xb6, 0xe4, 0xa3, 0xdf, 0x09,
    0xe8, 0xc5, 0xf4, 0x53, 0x42, 0xce, 0x66, 0xd2, 0x57, 0xb9, 0x2e, 0x96, 0xf5, 0x1f, 0xe0, 0xc2, 0x1f, 0x0c, 0x86,
    0x3d, 0x1b, 0x81, 0xb2, 0x00, 0xe8, 0xa1, 0x30, 0x29, 0xe0, 0x06, 0x50, 0x73, 0xc4, 0x6e, 0x00, 0x7e, 0x9f, 0xff,
    0xff, 0xd4, 0x00, 0x41, 0xb8, 0xc4, 0x96, 0xc1, 0x25, 0x38, 0x11, 0x58, 0x8f, 0x0a, 0x72, 0x2e, 0xff, 0xfb, 0x74,
    0x64, 0xef, 0x80, 0x12, 0x9f, 0x20, 0xc9, 0xfb, 0x99, 0x30, 0xc8, 0x2d, 0x00, 0x28, 0xca, 0x08, 0x00, 0x00, 0x0b,
    0x14, 0x83, 0x29, 0xee, 0x64, 0xc3, 0x20, 0x8a, 0x00, 0x63, 0xb4, 0x10, 0x00, 0x04, 0x57, 0x46, 0xe8, 0xb2, 0x82,
    0x32, 0x07, 0x30, 0x2a, 0x50, 0x8a, 0x8f, 0xa0, 0xeb, 0x17, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xff,
    0xc5, 0x95, 0x20, 0x23, 0x09, 0x38, 0x67, 0x7f, 0xfe, 0x8c, 0x00, 0x1b, 0x28, 0x88, 0x2c, 0x60, 0xd7, 0xd9, 0xcf,
    0x45, 0x80, 0x62, 0xe1, 0xc0, 0x9a, 0x95, 0xbc, 0xcb, 0x3a, 0xa0, 0x42, 0x08, 0xdc, 0x10, 0x24, 0x8f, 0x8d, 0xc9,
    0xb8, 0x5d, 0x22, 0x5a, 0x19, 0x94, 0xb2, 0xd6, 0x85, 0xcb, 0x1d, 0x3c, 0xbb, 0x08, 0xe1, 0x02, 0xb2, 0x4e, 0x42,
    0x59, 0x37, 0x09, 0xd9, 0xf8, 0xc5, 0x1a, 0xf5, 0xda, 0x9c, 0x12, 0xa8, 0x33, 0x2a, 0xa4, 0xfc, 0xef, 0x1e, 0x23,
    0x20, 0xa4, 0x8e, 0xac, 0x5d, 0x21, 0xef, 0xfd, 0xbf, 0xf6, 0x55, 0x24, 0xff, 0xf5, 0x23, 0xff, 0xaf, 0x8a, 0x8e,
    0x09, 0x03, 0x00, 0x00, 0x02, 0xba, 0x92, 0x91, 0x32, 0x2b, 0x35, 0x7f, 0x93, 0x34, 0x7a, 0xe2, 0xa3, 0xff, 0x6d,
    0xc7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xbf, 0xf7, 0xed, 0x16, 0x30, 0x53, 0x08, 0x57, 0x77, 0x8f,
    0xff, 0xa8, 0x80, 0x14, 0xa4, 0x74, 0x44, 0x21, 0x83, 0x98, 0xf4, 0x54, 0x2b, 0xf5, 0x18, 0x39, 0x01, 0x04, 0x20,
    0xea, 0xc9, 0xcb, 0xf2, 0x28, 0x40, 0x0d, 0x15, 0x06, 0x7b, 0x7c, 0xcc, 0x46, 0x61, 0xcc, 0x27, 0xa4, 0x80, 0x80,
    0x8e, 0xd5, 0x90, 0x21, 0x12, 0x3c, 0xa2, 0x55, 0xa7, 0x1b, 0xbb, 0x24, 0x0a, 0x64, 0x16, 0x51, 0x02, 0x17, 0x8a,
    0x46, 0x24, 0xec, 0x36, 0x11, 0x7d, 0x78, 0xc7, 0x9d, 0x88, 0x42, 0x9f, 0xf4, 0x67, 0xdc, 0xbe, 0x7a, 0xe6, 0x7a,
    0xfd, 0x25, 0x00, 0x8b, 0x41, 0x47, 0x23, 0x06, 0x2c, 0xf5, 0x94, 0x26, 0x51, 0x86, 0xb4, 0xcb, 0x83, 0xec, 0xa9,
    0xff, 0xfb, 0x74, 0x64, 0xef, 0x80, 0x12, 0xd8, 0x1f, 0xc9, 0x6b, 0xb9, 0x48, 0xc8, 0x28, 0x00, 0x28, 0xdc, 0x08,
    0x00, 0x01, 0x0a, 0x3c, 0x7d, 0x29, 0xee, 0x65, 0x23, 0x20, 0x9d, 0x8a, 0x23, 0xb4, 0x10, 0x0a, 0x00, 0x23, 0xef,
    0x70, 0xa8, 0x88, 0x91, 0x17, 0xa1, 0xee, 0xff, 0xff, 0xff, 0xff, 0xe8, 0xff, 0xff, 0xd9, 0xff, 0xfd, 0x32, 0x25,
    0x14, 0x2a, 0x12, 0x20, 0x54, 0x58, 0x26, 0x67, 0x7f, 0xfe, 0x8c, 0x00, 0x14, 0xc4, 0x2a, 0x0e, 0x11, 0x43, 0x4d,
    0x80, 0x24, 0x3b, 0x9d, 0x06, 0xb8, 0x6c, 0x3a, 0xb0, 0x00, 0x6b, 0xe3, 0x8e, 0xd2, 0x9b, 0x8a, 0x9b, 0x43, 0xab,
    0x87, 0xd8, 0x72, 0x0e, 0xc9, 0x13, 0xe2, 0x4e, 0x71, 0x46, 0x20, 0xbb, 0x63, 0xd6, 0x60, 0x48, 0x08, 0x9f, 0x88,
    0x34, 0xd0, 0x66, 0x5b, 0xf1, 0xfe, 0xf6, 0xa4, 0x0d, 0xcd, 0x8a, 0x3f, 0x58, 0x0b, 0xa4, 0x2e, 0xf0, 0x25, 0xc8,
    0x1d, 0x10, 0x80, 0xea, 0xe9, 0xd3, 0xff, 0xfb, 0xd2, 0x96, 0x82, 0xc3, 0x24, 0x8c, 0x00, 0x00, 0x46, 0x58, 0xf6,
    0xb4, 0x08, 0x0e, 0x77, 0x1e, 0xe1, 0x23, 0xc7, 0x0d, 0x40, 0x07, 0x06, 0x90, 0x10, 0x86, 0x02, 0xc3, 0x89, 0x4e,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x7d, 0xdf, 0xe6, 0xd0, 0x7e, 0x84, 0x8c, 0x40, 0x53, 0x88, 0x07,
    0x87, 0x7d, 0xf6, 0x88, 0x00, 0x10, 0x74, 0xc1, 0x60, 0x20, 0x02, 0x8c, 0x0e, 0x6c, 0x01, 0x8d, 0x1a, 0x44, 0x45,
    0x4d, 0x93, 0x18, 0xe1, 0x92, 0x06, 0x7e, 0xa1, 0xc8, 0x4c, 0xb5, 0xf3, 0xfd, 0x9a, 0x90, 0x5a, 0xa9, 0x35, 0x4e,
    0xe8, 0x1a, 0x4e, 0xa0, 0xb8, 0xbd, 0x30, 0x71, 0xe2, 0x0a, 0x06, 0x27, 0x2a, 0xa4, 0xb9, 0x5b, 0x52, 0x61, 0x03,
    0x8d, 0x5c, 0xbc, 0x7a, 0x22, 0x26, 0x58, 0x10, 0x5d, 0x07, 0xc0, 0x6c, 0xfa, 0x54, 0xdf, 0x63, 0xff, 0xe9, 0xff,
    0x44, 0x05, 0x34, 0xdb, 0x70, 0x65, 0x90, 0xaa, 0xfb, 0x0f, 0x39, 0xa1, 0x1a, 0xd6, 0xbc, 0x2a, 0x32, 0x4f, 0x5f,
    0x7d, 0x03, 0xa6, 0xff, 0xfb, 0x74, 0x64, 0xef, 0x00, 0x12, 0xd6, 0x24, 0xc9, 0xfb, 0x99, 0x48, 0xc8, 0x22, 0x40,
    0x28, 0xda, 0x08, 0x00, 0x00, 0x0a, 0x6c, 0x9d, 0x29, 0xee, 0x60, 0xc3, 0x20, 0xa6, 0x80, 0x63, 0x34, 0x10, 0x00,
    0x00, 0x11, 0x70, 0xd3, 0x61, 0x61, 0x6a, 0xcd, 0x35, 0x4b, 0xff, 0xff, 0x57, 0xff, 0xff, 0xb7, 0xfd, 0x7f, 0xff,
    0xbf, 0xf9, 0xe8, 0x17, 0x63, 0x55, 0xa2, 0x4f, 0x8e, 0xbf, 0xdf, 0xab, 0x40, 0x00, 0x9c, 0x26, 0x21, 0x12, 0x98,
    0x18, 0x06, 0x7a, 0x20, 0x28, 0x7c, 0x00, 0x93, 0xcd, 0xc8, 0x98, 0x99, 0xba, 0x9b, 0x10, 0x83, 0xd3, 0x51, 0x01,
    0xf2, 0x1b, 0xe6, 0x2a, 0xa7, 0xe3, 0x8f, 0x9b, 0x2d, 0x23, 0x9a, 0xea, 0xb7, 0x8f, 0xa6, 0x99, 0x24, 0x44, 0x38,
    0x44, 0x01, 0x52, 0x28, 0x1b, 0x41, 0x0c, 0x9b, 0xd5, 0x7c, 0x51, 0x6f, 0x84, 0xe7, 0x22, 0x38, 0x2b, 0x0a, 0xaf,
    0x24, 0x54, 0x41, 0xe6, 0xde, 0x12, 0x11, 0xbc, 0x68, 0xca, 0x03, 0xc4, 0x7b, 0x7f, 0xed, 0x84, 0xd0, 0xaa, 0xdf,
    0x67, 0x3b, 0xb7, 0xdc, 0xbf, 0xbd, 0xbd, 0x04, 0x24, 0xda, 0x8c, 0x5c, 0xf0, 0x00, 0x32, 0x85, 0x18, 0x00, 0x02,
    0x38, 0xe1, 0x93, 0xac, 0xc1, 0x20, 0x32, 0x47, 0xa7, 0xfb, 0xc0, 0xe0, 0x62, 0x8a, 0x68, 0x79, 0xbf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x56, 0xd2, 0x46, 0x08, 0x04, 0xde, 0x09, 0xda, 0x1f, 0xfd, 0xa3, 0x00, 0x05,
    0x2a, 0x1c, 0x23, 0x30, 0x94, 0x23, 0xc2, 0x59, 0x37, 0x40, 0x5a, 0x21, 0xd8, 0xbb, 0x26, 0x34, 0x52, 0x85, 0xd4,
    0x5c, 0x20, 0x20, 0x2f, 0x77, 0x9a, 0x42, 0x9c, 0xda, 0xd3, 0x44, 0xd8, 0xa4, 0x11, 0x30, 0xfb, 0x17, 0x9f, 0x5c,
    0x95, 0x04, 0xe7, 0x95, 0x92, 0xb1, 0x45, 0xc0, 0xa5, 0xc2, 0xf3, 0x72, 0xee, 0xc6, 0xd4, 0x82, 0x9b, 0x4e, 0x0c,
    0x87, 0x83, 0x81, 0xf7, 0x04, 0x10, 0x10, 0x54, 0x84, 0xae, 0x95, 0x7f, 0x4f, 0xff, 0xab, 0xda, 0xaa, 0x7f, 0xff,
    0xd4, 0xc3, 0x6a, 0x09, 0x24, 0x16, 0xff, 0xfb, 0x74, 0x64, 0xf0, 0x00, 0x32, 0x94, 0x20, 0xc9, 0xfb, 0x99, 0x30,
    0xc8, 0x2b, 0x80, 0x18, 0xca, 0x04, 0x00, 0x00, 0x0a, 0x14, 0x7d, 0x27, 0xee, 0x68, 0xc3, 0xa0, 0xb2, 0x89, 0x23,
    0x10, 0x90, 0x8c, 0x00, 0x46, 0x21, 0xa3, 0x94, 0x04, 0x28, 0x7e, 0x60, 0x50, 0xd9, 0xc1, 0x56, 0x0e, 0xf1, 0x83,
    0x9d, 0xd0, 0xb9, 0xd1, 0x5b, 0xe2, 0x04, 0xab, 0x9c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x57, 0xf7, 0xff, 0xd2,
    0x40, 0x36, 0x79, 0x17, 0x87, 0x8f, 0xfe, 0x90, 0x00, 0x00, 0xa0, 0x03, 0x04, 0x0e, 0xcc, 0x02, 0x23, 0x38, 0x48,
    0x14, 0xf7, 0x29, 0x1c, 0x44, 0xcf, 0x7e, 0x47, 0x11, 0x97, 0xae, 0xe6, 0xee, 0x5f, 0x6e, 0xf7, 0x51, 0xa3, 0xf4,
    0x96, 0x46, 0x32, 0x65, 0xa5, 0x05, 0xad, 0xf8, 0xd8, 0x22, 0x37, 0xea, 0xcf, 0x62, 0x63, 0x4c, 0xe5, 0x12, 0xa2,
    0xb5, 0xcc, 0xae, 0xcd, 0x8e, 0xba, 0x10, 0x9e, 0x78, 0x12, 0x19, 0xc7, 0xb0, 0x60, 0x71, 0xea, 0x59, 0xb0, 0x02,
    0x3f, 0xf4, 0x74, 0x0a, 0xd5, 0x7f, 0x1c, 0x60, 0x00, 0x00, 0x88, 0xf3, 0x49, 0x18, 0x71, 0xdb, 0xc2, 0x41, 0x30,
    0xf8, 0x98, 0x52, 0x0a, 0x08, 0xc5, 0x4f, 0x88, 0x8b, 0x35, 0xad, 0x08, 0x9a, 0x0a, 0x20, 0x54, 0x93, 0x7f, 0xff,
    0xff, 0xff, 0xf5, 0xff, 0xff, 0x5f, 0xff, 0xfa, 0x22, 0x5b, 0xdf, 0xae, 0x41, 0xa1, 0x20, 0x21, 0xdd, 0xff, 0xfa,
    0xc4, 0x00, 0x0b, 0x84, 0x99, 0x70, 0x88, 0x56, 0x5c, 0xef, 0xca, 0x0f, 0x58, 0x4b, 0xd0, 0x74, 0x84, 0xd2, 0x43,
    0x8a, 0xc9, 0x96, 0x34, 0x76, 0x13, 0xdf, 0x19, 0x41, 0xdd, 0x91, 0x4b, 0x13, 0x5e, 0x0f, 0xa5, 0x26, 0x63, 0x23,
    0x83, 0xaa, 0x4d, 0x46, 0xed, 0x79, 0x2e, 0xa4, 0xa6, 0xd2, 0x88, 0x39, 0xa9, 0xba, 0x51, 0xf5, 0x2b, 0xe9, 0x1c,
    0x24, 0x75, 0x44, 0x41, 0xc0, 0x20, 0x84, 0xc4, 0x93, 0x01, 0xe3, 0xc7, 0x4c, 0xe5, 0x47, 0x01, 0xee, 0x14, 0x40,
    0xa0, 0xb7, 0xf7, 0xfa, 0xff, 0xa7, 0x7c, 0x21, 0x37, 0xff, 0xfb, 0x74, 0x64, 0xf0, 0x00, 0x13, 0x03, 0x22, 0xc8,
    0xeb, 0x99, 0x48, 0xc8, 0x27, 0xe0, 0x18, 0xec, 0x04, 0x00, 0x01, 0x0a, 0xd4, 0x7f, 0x27, 0xed, 0xe5, 0x23, 0x20,
    0x9c, 0x00, 0x63, 0xb4, 0x20, 0x00, 0x00, 0x24, 0x60, 0x15, 0x31, 0xce, 0x07, 0x82, 0xa6, 0x69, 0x4d, 0x47, 0xcf,
    0x42, 0xa0, 0x23, 0x6d, 0x07, 0x4d, 0x30, 0x33, 0x06, 0x15, 0x75, 0x86, 0x9a, 0xef, 0xff, 0xff, 0xfe, 0x9f, 0xd1,
    0xff, 0xfb, 0x3f, 0x14, 0xa3, 0xd5, 0x15, 0x77, 0xcc, 0x8b, 0x22, 0x80, 0x67, 0x49, 0x15, 0x68, 0x7d, 0xfe, 0x8c,
    0x80, 0x0c, 0x30, 0x94, 0xc1, 0xca, 0x82, 0x99, 0x26, 0x04, 0x44, 0x68, 0x56, 0x9a, 0x40, 0x70, 0x56, 0x20, 0xb4,
    0x36, 0xd7, 0x49, 0x54, 0x21, 0x80, 0xb2, 0xfa, 0xbe, 0xe9, 0x40, 0x8c, 0x4e, 0x7d, 0x2d, 0x67, 0x1e, 0x47, 0x39,
    0x6f, 0x59, 0x51, 0x89, 0x2b, 0x0e, 0x36, 0x74, 0xb5, 0x3e, 0xd9, 0x10, 0xf2, 0x0b, 0x43, 0x52, 0xb4, 0x3e, 0xfc,
    0x65, 0x06, 0x10, 0x02, 0x1c, 0x39, 0xc6, 0x9c, 0x3a, 0x1d, 0x48, 0x9d, 0xe4, 0xc4, 0x14, 0x31, 0x0f, 0xba, 0xe1,
    0x27, 0xfe, 0x9e, 0xf6, 0x27, 0xaf, 0xa3, 0xff, 0xa0, 0x86, 0x82, 0x40, 0x46, 0xe4, 0x60, 0x00, 0x04, 0xc8, 0x83,
    0x04, 0x8e, 0xad, 0x86, 0xb8, 0x8c, 0x16, 0x48, 0x08, 0xc5, 0x43, 0xcf, 0x50, 0xb0, 0x9d, 0xa9, 0x79, 0xb5, 0x54,
    0xef, 0xff, 0xff, 0xdf, 0xff, 0xd3, 0xff, 0xff, 0x72, 0x5e, 0xef, 0xfd, 0x32, 0xa0, 0x1a, 0xc5, 0x18, 0x16, 0x9e,
    0x09, 0x9e, 0x1f, 0xfd, 0xe3, 0x00, 0x00, 0x00, 0x08, 0x08, 0x48, 0xc1, 0xa5, 0xce, 0xa0, 0x18, 0xe2, 0x04, 0xb9,
    0x47, 0xf4, 0xa0, 0x65, 0x8f, 0x74, 0xdb, 0xc8, 0x79, 0xf1, 0x06, 0x8f, 0x3b, 0xf8, 0xb5, 0xcd, 0x2e, 0x31, 0x24,
    0x4c, 0x4e, 0x1f, 0x22, 0x81, 0x9b, 0x58, 0x79, 0x55, 0xf5, 0xe5, 0x98, 0x2a, 0x63, 0xe3, 0x08, 0x23, 0x06, 0x3b,
    0x57, 0x4c, 0x2a, 0xdc, 0x51, 0x75, 0x12, 0x7d, 0x6f, 0x92, 0xfa, 0x95, 0xff, 0xfb, 0x84, 0x64, 0xeb, 0x00, 0x52,
    0x79, 0x1e, 0xca, 0x7b, 0x99, 0x30, 0xc8, 0x2e, 0xa0, 0x08, 0xca, 0x00, 0x00, 0x00, 0x0b, 0x3c, 0x7b, 0x29, 0xed,
    0xe5, 0x23, 0x20, 0xb0, 0x80, 0xa3, 0x34, 0x60, 0x00, 0x00, 0xbc, 0x54, 0xe0, 0x00, 0x61, 0xe3, 0x95, 0x46, 0x0d,
    0x60, 0xb2, 0xbf, 0xa5, 0x6a, 0xb3, 0xff, 0xe9, 0xff, 0xfd, 0x0b, 0x57, 0x19, 0x10, 0x01, 0x42, 0x01, 0x82, 0x23,
    0xe3, 0x9f, 0x77, 0xe8, 0x59, 0x84, 0x0f, 0xb4, 0xbc, 0xe3, 0xc7, 0xb8, 0xe2, 0x5f, 0x77, 0xff, 0xff, 0xff, 0xff,
    0xf7, 0x7f, 0xff, 0xfe, 0xbd, 0x8c, 0x61, 0x86, 0xbd, 0xef, 0x55, 0x80, 0x58, 0x77, 0x26, 0x78, 0x7f, 0xff, 0x8c,
    0x80, 0x0b, 0xa2, 0x44, 0x66, 0x60, 0x85, 0xe3, 0x6b, 0x25, 0x16, 0xab, 0x50, 0xb9, 0x60, 0xd0, 0x4c, 0x0a, 0x98,
    0x94, 0x56, 0x54, 0x5d, 0x8c, 0xb9, 0x8d, 0x59, 0x1a, 0x0c, 0x69, 0x14, 0x33, 0x37, 0x75, 0x1c, 0x40, 0x86, 0xef,
    0x9b, 0x39, 0x93, 0x44, 0x0a, 0xe9, 0x1c, 0x0e, 0xc9, 0x9c, 0x77, 0x35, 0xca, 0x59, 0xea, 0x51, 0x90, 0x55, 0x03,
    0xa5, 0x45, 0x01, 0xdc, 0xeb, 0x6e, 0xb8, 0x79, 0x37, 0x32, 0xd5, 0x74, 0x53, 0xff, 0xff, 0x52, 0x01, 0x90, 0xdb,
    0x92, 0x40, 0x00, 0x00, 0x01, 0x67, 0xcc, 0x36, 0xd6, 0x8b, 0x00, 0xcc, 0x10, 0x10, 0x12, 0x2a, 0x09, 0x63, 0xc1,
    0x41, 0x37, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xff, 0xfa, 0x7f, 0xea, 0xec, 0x4d, 0x22, 0x90, 0x11, 0x2d,
    0x02, 0xca, 0xb1, 0xfe, 0xcd, 0x80, 0x03, 0x10, 0x01, 0x11, 0x98, 0x20, 0x51, 0xdd, 0x00, 0x9e, 0x8c, 0x18, 0xaa,
    0x9b, 0x57, 0x23, 0xb1, 0xc9, 0x1d, 0xb6, 0x3e, 0x95, 0x88, 0xb7, 0x3b, 0xec, 0xa7, 0x9e, 0xb5, 0x7c, 0xda, 0x65,
    0x82, 0x64, 0x28, 0x14, 0x23, 0x60, 0x99, 0x18, 0xe8, 0xa8, 0xfd, 0xcb, 0x58, 0x6a, 0x31, 0xa7, 0xaa, 0xda, 0x50,
    0x69, 0x75, 0x2a, 0x4a, 0x54, 0xe4, 0xd2, 0x4a, 0xe6, 0x78, 0x3e, 0x40, 0xc5, 0xa1, 0x31, 0x7c, 0x38, 0xb0, 0x5c,
    0x90, 0x6b, 0xab, 0x4b, 0x37, 0xfe, 0xc6, 0x5c, 0xd5, 0xd7, 0xff, 0xfa, 0xe0, 0x51, 0x32, 0xc4, 0xb2, 0x40, 0x80,
    0x9e, 0x4b, 0x71, 0x8d, 0x88, 0xd9, 0x0d, 0xd6, 0x3c, 0xb9, 0xe1, 0x78, 0x34, 0x26, 0x54, 0x61, 0x42, 0x07, 0x27,
    0x8e, 0xfd, 0x51, 0x62, 0xc4, 0xc4, 0xff, 0xfb, 0x74, 0x64, 0xff, 0x00, 0x32, 0xe6, 0x20, 0x49, 0xfb, 0x79, 0x48,
    0xc8, 0x2d, 0x80, 0x58, 0xcd, 0x04, 0x22, 0x00, 0x0b, 0x8c, 0x91, 0x27, 0xed, 0xe5, 0x23, 0x20, 0x94, 0x00, 0xe3,
    0x20, 0x20, 0x80, 0x00, 0xaa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xe4, 0x56, 0x70, 0x86, 0x67, 0x16,
    0x66, 0x79, 0xf6, 0x8c, 0x00, 0x14, 0x71, 0xa5, 0x03, 0x23, 0x1e, 0xe0, 0x60, 0x46, 0x1e, 0x90, 0xee, 0x64, 0xa7,
    0x68, 0x8d, 0x72, 0x35, 0x07, 0x96, 0xf6, 0x8f, 0x9a, 0x8c, 0xc6, 0xe6, 0x61, 0xcc, 0x3d, 0x32, 0x13, 0xbd, 0xe5,
    0xbe, 0xa2, 0x48, 0x03, 0x6c, 0x30, 0x8d, 0xd5, 0x6c, 0x8d, 0xac, 0xb0, 0xce, 0x29, 0x22, 0xbe, 0x87, 0x3b, 0x15,
    0x4a, 0x28, 0xf3, 0x7f, 0x32, 0xc4, 0x6f, 0x61, 0xa2, 0x4e, 0x60, 0x32, 0x8b, 0xcf, 0xfe, 0xb7, 0xf7, 0x6e, 0xca,
    0x77, 0x7b, 0xdf, 0xb3, 0x54, 0x70, 0xc1, 0xed, 0xc4, 0x00, 0x00, 0x20, 0xcc, 0x48, 0x08, 0x3c, 0x31, 0xac, 0xf0,
    0x70, 0x99, 0x0b, 0x2c, 0x05, 0x1c, 0xc7, 0x13, 0x00, 0x90, 0x2a, 0xe3, 0x9a, 0x99, 0xff, 0xff, 0xd7, 0xfd, 0xff,
    0xec, 0xff, 0xff, 0xad, 0x5b, 0x77, 0x7b, 0xf0, 0x42, 0xf4, 0xbd, 0xcd, 0x80, 0x96, 0x57, 0x16, 0x67, 0x7f, 0xf6,
    0x90, 0x80, 0x19, 0xf1, 0x50, 0xb0, 0xe4, 0x81, 0x69, 0xa2, 0x21, 0x30, 0xe0, 0x97, 0xd7, 0x23, 0x85, 0x3c, 0x7d,
    0x8d, 0x17, 0x3a, 0xc7, 0xe3, 0x5b, 0x5b, 0xba, 0x27, 0xf3, 0xfa, 0x7c, 0xd0, 0x04, 0xa6, 0x7a, 0x43, 0xd9, 0x32,
    0xae, 0x81, 0x56, 0xd4, 0xa2, 0x1c, 0x7a, 0xf9, 0x13, 0x2c, 0x81, 0x32, 0xd9, 0xeb, 0xb1, 0x3b, 0xdc, 0x96, 0xd2,
    0xc3, 0x6c, 0x24, 0x11, 0x22, 0x13, 0x28, 0x48, 0x48, 0xd1, 0x21, 0xd3, 0x93, 0x52, 0xbb, 0xef, 0x99, 0xab, 0xea,
    0x57, 0x47, 0x62, 0x21, 0x24, 0x02, 0x8e, 0x49, 0x11, 0x23, 0x0b, 0x8c, 0x36, 0x1f, 0x4c, 0xdd, 0xe6, 0x84, 0x51,
    0xa8, 0x63, 0xa6, 0x1c, 0x60, 0xf8, 0xb8, 0xc6, 0x83, 0xff, 0xfb, 0x74, 0x64, 0xf7, 0x00, 0x12, 0x85, 0x20, 0xca,
    0x7b, 0x79, 0x30, 0xc8, 0x26, 0xc0, 0x08, 0xdd, 0x00, 0x00, 0x00, 0x0b, 0x5c, 0x89, 0x25, 0xed, 0xe5, 0x23, 0x20,
    0xaa, 0x82, 0x23, 0xb4, 0x20, 0x8c, 0x04, 0xa6, 0x03, 0xf3, 0xc0, 0x50, 0x30, 0xe4, 0x2d, 0x89, 0x8b, 0x7f, 0xff,
    0xff, 0xfe, 0xef, 0xff, 0xe9, 0xff, 0xf6, 0x56, 0x52, 0xb1, 0x2d, 0x36, 0x55, 0x70, 0x97, 0x87, 0x17, 0x77, 0x9f,
    0xfe, 0x8c, 0x00, 0x23, 0xc4, 0x22, 0x09, 0x28, 0x13, 0x35, 0x01, 0x14, 0x0b, 0x93, 0x1d, 0x10, 0xce, 0x8d, 0xa9,
    0x15, 0xd8, 0xeb, 0x2f, 0x94, 0x38, 0xd9, 0xf6, 0x3c, 0x19, 0xb2, 0xd5, 0x0a, 0x5c, 0x1a, 0x47, 0x12, 0xa8, 0x40,
    0x44, 0xcd, 0x2c, 0xf0, 0xc3, 0x83, 0x11, 0x30, 0x42, 0x30, 0x69, 0x34, 0x2a, 0xf4, 0xce, 0x4e, 0x4b, 0xd4, 0x2d,
    0x90, 0x56, 0xd1, 0xbf, 0x3d, 0x39, 0x80, 0x11, 0x47, 0x9a, 0x51, 0xf2, 0xa8, 0x26, 0xd1, 0x43, 0x1f, 0xb1, 0xbf,
    0xf4, 0x6b, 0xeb, 0xfe, 0xfa, 0x9a, 0x20, 0xb6, 0xd4, 0x5f, 0xe0, 0x00, 0xa3, 0x01, 0x53, 0x45, 0xc1, 0x13, 0x60,
    0xab, 0x5a, 0x0d, 0x97, 0x4a, 0xb5, 0x8b, 0xda, 0x49, 0xb6, 0x3f, 0x68, 0xc2, 0x49, 0x77, 0xff, 0xff, 0xfa, 0xbf,
    0xff, 0xff, 0xff, 0xff, 0xdf, 0x4a, 0x51, 0x7c, 0x59, 0x10, 0x10, 0xd3, 0x05, 0x0d, 0x0e, 0xb2, 0x98, 0x71, 0x2d,
};

const uint32_t audiomedia_size = sizeof(audiomedia);

/*${variable:start}*/
SHELL_COMMAND_DEFINE(version, "\r\n\"version\": Display component versions\r\n", shellEcho, 0);

static shell_status_t shellEcho(shell_handle_t shellHandle, int32_t argc, char **argv)
{
    PRINTF(" Maestro version: 1.0\r\n");

#ifdef EAP_PROC
    PRINTF(" EAP version: 3.0\r\n");
#endif

#ifdef VIT_PROC
    PRINTF(" VIT version: 5.0.0\r\n");
#endif

    return kStatus_SHELL_Success;
}

SHELL_COMMAND_DEFINE(record_mic,
                     "\r\n\"record_mic\": Record MIC audio and either:\r\n"
#ifdef VIT_PROC
                     " - perform voice recognition (VIT)\r\n"
#endif
                     " - playback on WM8904 codec\r\n"
                     "\r\n"
#ifdef VIT_PROC
                     " USAGE: record_mic [audio|file|vit] 20 [en|cn]\r\n"
#else
                     " USAGE: record_mic [audio] 20\r\n"
#endif
                     " The number defines length of recording in seconds.\r\n"
#ifdef VIT_PROC
                     " For voice recognition say supported WakeWord and in 3s frame supported command.\r\n"
                     " Please note that this VIT demo is near-field and uses 1 on-board microphone.\r\n"
#endif
                     " NOTE: this command returns to shell after record finished.\r\n",
                     shellRecMIC,
                     SHELL_IGNORE_PARAMETER_COUNT);

SHELL_COMMAND_DEFINE(play_mp3,
                     "\r\n\"play_mp3\": Perform audio file decode and playback\r\n"
                     "\r\n"
                     "  USAGE: play_mp3 [audio]\r\n",
                     shellFile,
                     SHELL_IGNORE_PARAMETER_COUNT);

SDK_ALIGN(static uint8_t s_shellHandleBuffer[SHELL_HANDLE_SIZE], 4);
static shell_handle_t s_shellHandle;

extern serial_handle_t g_serialHandle;

streamer_handle_t streamerHandle;

/*${variable:end}*/

/*******************************************************************************
 * Code
 ******************************************************************************/

/*${function:start}*/
static shell_status_t shellRecMIC(shell_handle_t shellHandle, int32_t argc, char **argv)
{
    status_t ret;
    out_sink_t out_sink;
    int duration = 20;
#ifdef VIT_PROC
    Vit_Language = EN;
#endif

    bRecMic = TRUE;

    if ((argc >= 1) && (strcmp(argv[1], "file") == 0))
    {
        out_sink = FILE_SINK;
    }
    else if ((argc >= 1) && (strcmp(argv[1], "audio") == 0))
    {
        out_sink = AUDIO_SINK;
    }
    else if ((argc >= 1) && (strcmp(argv[1], "vit") == 0))
    {
        out_sink = VIT_SINK;
    }
    else
    {
        PRINTF("STREAMER_Create wrong out sink type, using default audio\r\n");
        out_sink = AUDIO_SINK;
    }

    if ((argc >= 2))
    {
        if (strcmp(argv[2], '\0') != 0)
        {
            duration = abs(atoi(argv[2]));
        }
    }

    if ((argc >= 3))
    {
        if (strcmp(argv[3], "cn") == 0)
        {
#ifdef VIT_PROC
            Vit_Language = CN;
#endif
        }
    }

    PRINTF("\r\nStarting streamer demo application for %d sec\r\n", duration);

    STREAMER_Init();

    ret = STREAMER_mic_Create(&streamerHandle, out_sink);

    if (ret != kStatus_Success)
    {
        PRINTF("STREAMER_Create failed\r\n");
        goto error;
    }

    PRINTF("Starting recording\r\n");
#ifdef VIT_PROC
    if (out_sink == VIT_SINK)
    {
        PRINTF("\r\nTo see VIT functionality say wake-word and command.\r\n");
    }
#endif
    STREAMER_Start(&streamerHandle);

    osa_time_delay(duration * 1000);

    STREAMER_Stop(&streamerHandle);

error:
    PRINTF("Cleanup\r\n");
    STREAMER_Destroy(&streamerHandle);
    osa_time_delay(100);
    return kStatus_SHELL_Success;
}

static shell_status_t shellFile(shell_handle_t shellHandle, int32_t argc, char **argv)
{
    status_t ret;
    int size, index = 12 * 1024;
    bRecMic = FALSE;

    PRINTF("Starting streamer demo application\r\n");

    STREAMER_Init();
    ret = STREAMER_Create(&streamerHandle);
    if (ret != kStatus_Success)
    {
        PRINTF("STREAMER_Create failed\r\n");
        goto error;
    }

    PRINTF("Starting playback\r\n");

    STREAMER_Write((uint8_t *)audiomedia, index);
    STREAMER_Start(&streamerHandle);

    while (index < audiomedia_size && streamerHandle.audioPlaying)
    {
        osa_time_delay(200);
        size = (audiomedia_size - index) > 2048 ? 2048 : (audiomedia_size - index);
        STREAMER_Write((uint8_t *)(audiomedia + index), size);
        index += size;
    }

    PRINTF("Waiting for 1 second\r\n");
    osa_time_delay(1000);

    STREAMER_Stop(&streamerHandle);

error:
    PRINTF("Cleanup\r\n");
    STREAMER_Destroy(&streamerHandle);
    return kStatus_SHELL_Success;
}

void shellCmd(handleShellMessageCallback_t *handleShellMessageCallback, void *arg)
{
    /* Init SHELL */
    s_shellHandle = &s_shellHandleBuffer[0];
    SHELL_Init(s_shellHandle, g_serialHandle, ">> ");

    /* Add new command to commands list */
    SHELL_RegisterCommand(s_shellHandle, SHELL_COMMAND(version));
    SHELL_RegisterCommand(s_shellHandle, SHELL_COMMAND(record_mic));
    SHELL_RegisterCommand(s_shellHandle, SHELL_COMMAND(play_mp3));

#if !(defined(SHELL_NON_BLOCKING_MODE) && (SHELL_NON_BLOCKING_MODE > 0U))
    while (1)
    {
        SHELL_Task(s_shellHandle);
    }
#endif
}
/*${function:end}*/
