/*--------------------------------------------------------------------------*/
/* Copyright 2022-2023 NXP                                                  */
/*                                                                          */
/* NXP Confidential. This software is owned or controlled by NXP and may    */
/* only be used strictly in accordance with the applicable license terms.   */
/* By expressly accepting such terms or by downloading, installing,         */
/* activating and/or otherwise using the software, you are agreeing that    */
/* you have read, and that you agree to comply with and are bound by, such  */
/* license terms. If you do not agree to be bound by the applicable license */
/* terms, then you may not retain, install, activate or otherwise use the   */
/* software.                                                                */
/*--------------------------------------------------------------------------*/

/**
 * @file  mcuxClMacModes_Functions.h
 * @brief Functions for the mcuxClMacModes component
 */

#ifndef MCUXCLMACMODES_FUNCTIONS_H_
#define MCUXCLMACMODES_FUNCTIONS_H_

#include <mcuxCsslFlowProtection.h>
#include <mcuxClSession_Types.h>
#include <mcuxClKey_Types.h>
#include <mcuxClMac_Types.h>
#include <mcuxClCore_Platform.h>
#include <mcuxClCore_Buffer.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * @defgroup mcuxClMacModes_Functions mcuxClMacModes Functions
 * @brief Defines all functions of @ref mcuxClMacModes
 * @ingroup mcuxClMacModes
 * @{
*/

/**
 * @defgroup mcuxClMacModes_Constructors APIs to construct Mac modes
 * @brief Interfaces to construct Mac modes of operation.
 * @ingroup mcuxClMacModes_Functions
 * @{
 */



/**
 * @}
 */ /* mcuxClMacModes_Constructors */

/**
 * @}
 */ /* mcuxClMacModes_Functions */

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* MCUXCLMACMODES_FUNCTIONS_H_ */
