/*--------------------------------------------------------------------------*/
/* Copyright 2020-2023 NXP                                                  */
/*                                                                          */
/* NXP Confidential. This software is owned or controlled by NXP and may    */
/* only be used strictly in accordance with the applicable license terms.   */
/* By expressly accepting such terms or by downloading, installing,         */
/* activating and/or otherwise using the software, you are agreeing that    */
/* you have read, and that you agree to comply with and are bound by, such  */
/* license terms. If you do not agree to be bound by the applicable license */
/* terms, then you may not retain, install, activate or otherwise use the   */
/* software.                                                                */
/*--------------------------------------------------------------------------*/

/**
 * @file mcuxClEcc.h
 * @brief Top level header of mcuxClEcc component
 *
 * @defgroup mcuxClEcc mcuxClEcc
 * @brief Elliptic Curve Cryptography component
 */


#ifndef MCUXCLECC_H_
#define MCUXCLECC_H_

#include <mcuxClConfig.h> // Exported features flags header
#include <mcuxClEcc_Types.h>
#include <mcuxClEcc_Functions.h>
#include <mcuxClEcc_MemoryConsumption.h>
#include <mcuxClEcc_Constants.h>
#include <mcuxClEcc_ParameterSizes.h>
#include <mcuxClEcc_KeyMechanisms.h>



#endif /* MCUXCLECC_H_ */
