/*
 * Copyright 2021 NXP
 * SPDX-License-Identifier: MIT
 */

#include "lvgl/lvgl.h"
#include <stdio.h>
#include "gui_guider.h"
#include "events_init.h"
#include "custom.h"


void setup_scr_screLight(lv_ui *ui){

	//Write codes screLight
	ui->screLight = lv_obj_create(NULL, NULL);

	//Write codes screLight_contBackground
	ui->screLight_contBackground = lv_cont_create(ui->screLight, NULL);

	//Write style LV_CONT_PART_MAIN for screLight_contBackground
	static lv_style_t style_screLight_contBackground_main;
	lv_style_init(&style_screLight_contBackground_main);

	//Write style state: LV_STATE_DEFAULT for style_screLight_contBackground_main
	lv_style_set_radius(&style_screLight_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screLight_contBackground_main, LV_STATE_DEFAULT, lv_color_make(0xe0, 0xe0, 0xe0));
	lv_style_set_bg_grad_color(&style_screLight_contBackground_main, LV_STATE_DEFAULT, lv_color_make(0xf4, 0xf4, 0xf4));
	lv_style_set_bg_grad_dir(&style_screLight_contBackground_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screLight_contBackground_main, LV_STATE_DEFAULT, 255);
	lv_style_set_border_color(&style_screLight_contBackground_main, LV_STATE_DEFAULT, lv_color_make(0x99, 0x99, 0x99));
	lv_style_set_border_width(&style_screLight_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_border_opa(&style_screLight_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screLight_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screLight_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screLight_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screLight_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screLight_contBackground, LV_CONT_PART_MAIN, &style_screLight_contBackground_main);
	lv_obj_set_pos(ui->screLight_contBackground, 0, 0);
	lv_obj_set_size(ui->screLight_contBackground, 480, 272);
	lv_obj_set_click(ui->screLight_contBackground, false);
	lv_cont_set_layout(ui->screLight_contBackground, LV_LAYOUT_OFF);
	lv_cont_set_fit(ui->screLight_contBackground, LV_FIT_NONE);

	//Write codes screLight_imgHead
	ui->screLight_imgHead = lv_img_create(ui->screLight, NULL);

	//Write style LV_IMG_PART_MAIN for screLight_imgHead
	static lv_style_t style_screLight_imgHead_main;
	lv_style_init(&style_screLight_imgHead_main);

	//Write style state: LV_STATE_DEFAULT for style_screLight_imgHead_main
	lv_style_set_image_recolor(&style_screLight_imgHead_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screLight_imgHead_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screLight_imgHead_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screLight_imgHead, LV_IMG_PART_MAIN, &style_screLight_imgHead_main);
	lv_obj_set_pos(ui->screLight_imgHead, 0, 1);
	lv_obj_set_size(ui->screLight_imgHead, 480, 80);
	lv_obj_set_click(ui->screLight_imgHead, true);
	lv_img_set_src(ui->screLight_imgHead,&_img_header_alpha_480x80);
	lv_img_set_pivot(ui->screLight_imgHead, 0,0);
	lv_img_set_angle(ui->screLight_imgHead, 0);

	//Write codes screLight_imgbtnHome
	ui->screLight_imgbtnHome = lv_imgbtn_create(ui->screLight, NULL);

	//Write style LV_IMGBTN_PART_MAIN for screLight_imgbtnHome
	static lv_style_t style_screLight_imgbtnHome_main;
	lv_style_init(&style_screLight_imgbtnHome_main);

	//Write style state: LV_STATE_DEFAULT for style_screLight_imgbtnHome_main
	lv_style_set_text_color(&style_screLight_imgbtnHome_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_image_recolor(&style_screLight_imgbtnHome_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screLight_imgbtnHome_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screLight_imgbtnHome_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screLight_imgbtnHome, LV_IMGBTN_PART_MAIN, &style_screLight_imgbtnHome_main);
	lv_obj_set_pos(ui->screLight_imgbtnHome, 36, 0);
	lv_obj_set_size(ui->screLight_imgbtnHome, 55, 50);
	lv_imgbtn_set_src(ui->screLight_imgbtnHome,LV_BTN_STATE_RELEASED,&_btn_long_top_house_alpha_55x50);
	lv_imgbtn_set_src(ui->screLight_imgbtnHome,LV_BTN_STATE_PRESSED,&_btn_long_top_house_alpha_55x50);

	//Write codes screLight_swCeiling
	ui->screLight_swCeiling = lv_switch_create(ui->screLight, NULL);

	//Write style LV_SWITCH_PART_BG for screLight_swCeiling
	static lv_style_t style_screLight_swCeiling_bg;
	lv_style_init(&style_screLight_swCeiling_bg);

	//Write style state: LV_STATE_DEFAULT for style_screLight_swCeiling_bg
	lv_style_set_radius(&style_screLight_swCeiling_bg, LV_STATE_DEFAULT, 100);
	lv_style_set_bg_color(&style_screLight_swCeiling_bg, LV_STATE_DEFAULT, lv_color_make(0x61, 0x61, 0x61));
	lv_style_set_bg_grad_color(&style_screLight_swCeiling_bg, LV_STATE_DEFAULT, lv_color_make(0x61, 0x61, 0x61));
	lv_style_set_bg_grad_dir(&style_screLight_swCeiling_bg, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screLight_swCeiling_bg, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screLight_swCeiling, LV_SWITCH_PART_BG, &style_screLight_swCeiling_bg);

	//Write style LV_SWITCH_PART_INDIC for screLight_swCeiling
	static lv_style_t style_screLight_swCeiling_indic;
	lv_style_init(&style_screLight_swCeiling_indic);

	//Write style state: LV_STATE_DEFAULT for style_screLight_swCeiling_indic
	lv_style_set_radius(&style_screLight_swCeiling_indic, LV_STATE_DEFAULT, 100);
	lv_style_set_bg_color(&style_screLight_swCeiling_indic, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_color(&style_screLight_swCeiling_indic, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_dir(&style_screLight_swCeiling_indic, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screLight_swCeiling_indic, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screLight_swCeiling, LV_SWITCH_PART_INDIC, &style_screLight_swCeiling_indic);

	//Write style LV_SWITCH_PART_KNOB for screLight_swCeiling
	static lv_style_t style_screLight_swCeiling_knob;
	lv_style_init(&style_screLight_swCeiling_knob);

	//Write style state: LV_STATE_DEFAULT for style_screLight_swCeiling_knob
	lv_style_set_radius(&style_screLight_swCeiling_knob, LV_STATE_DEFAULT, 100);
	lv_style_set_bg_color(&style_screLight_swCeiling_knob, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screLight_swCeiling_knob, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screLight_swCeiling_knob, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screLight_swCeiling_knob, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screLight_swCeiling, LV_SWITCH_PART_KNOB, &style_screLight_swCeiling_knob);
	lv_obj_set_pos(ui->screLight_swCeiling, 39, 83);
	lv_obj_set_size(ui->screLight_swCeiling, 55, 27);
	lv_switch_set_anim_time(ui->screLight_swCeiling, 50);

	//Write codes screLight_swLamps
	ui->screLight_swLamps = lv_switch_create(ui->screLight, NULL);

	//Write style LV_SWITCH_PART_BG for screLight_swLamps
	static lv_style_t style_screLight_swLamps_bg;
	lv_style_init(&style_screLight_swLamps_bg);

	//Write style state: LV_STATE_DEFAULT for style_screLight_swLamps_bg
	lv_style_set_radius(&style_screLight_swLamps_bg, LV_STATE_DEFAULT, 100);
	lv_style_set_bg_color(&style_screLight_swLamps_bg, LV_STATE_DEFAULT, lv_color_make(0x61, 0x61, 0x61));
	lv_style_set_bg_grad_color(&style_screLight_swLamps_bg, LV_STATE_DEFAULT, lv_color_make(0x61, 0x61, 0x61));
	lv_style_set_bg_grad_dir(&style_screLight_swLamps_bg, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screLight_swLamps_bg, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screLight_swLamps, LV_SWITCH_PART_BG, &style_screLight_swLamps_bg);

	//Write style LV_SWITCH_PART_INDIC for screLight_swLamps
	static lv_style_t style_screLight_swLamps_indic;
	lv_style_init(&style_screLight_swLamps_indic);

	//Write style state: LV_STATE_DEFAULT for style_screLight_swLamps_indic
	lv_style_set_radius(&style_screLight_swLamps_indic, LV_STATE_DEFAULT, 100);
	lv_style_set_bg_color(&style_screLight_swLamps_indic, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_color(&style_screLight_swLamps_indic, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_dir(&style_screLight_swLamps_indic, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screLight_swLamps_indic, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screLight_swLamps, LV_SWITCH_PART_INDIC, &style_screLight_swLamps_indic);

	//Write style LV_SWITCH_PART_KNOB for screLight_swLamps
	static lv_style_t style_screLight_swLamps_knob;
	lv_style_init(&style_screLight_swLamps_knob);

	//Write style state: LV_STATE_DEFAULT for style_screLight_swLamps_knob
	lv_style_set_radius(&style_screLight_swLamps_knob, LV_STATE_DEFAULT, 100);
	lv_style_set_bg_color(&style_screLight_swLamps_knob, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screLight_swLamps_knob, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screLight_swLamps_knob, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screLight_swLamps_knob, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screLight_swLamps, LV_SWITCH_PART_KNOB, &style_screLight_swLamps_knob);
	lv_obj_set_pos(ui->screLight_swLamps, 38, 129);
	lv_obj_set_size(ui->screLight_swLamps, 55, 27);
	lv_switch_set_anim_time(ui->screLight_swLamps, 50);

	//Write codes screLight_swReading
	ui->screLight_swReading = lv_switch_create(ui->screLight, NULL);

	//Write style LV_SWITCH_PART_BG for screLight_swReading
	static lv_style_t style_screLight_swReading_bg;
	lv_style_init(&style_screLight_swReading_bg);

	//Write style state: LV_STATE_DEFAULT for style_screLight_swReading_bg
	lv_style_set_radius(&style_screLight_swReading_bg, LV_STATE_DEFAULT, 100);
	lv_style_set_bg_color(&style_screLight_swReading_bg, LV_STATE_DEFAULT, lv_color_make(0x61, 0x61, 0x61));
	lv_style_set_bg_grad_color(&style_screLight_swReading_bg, LV_STATE_DEFAULT, lv_color_make(0x61, 0x61, 0x61));
	lv_style_set_bg_grad_dir(&style_screLight_swReading_bg, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screLight_swReading_bg, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screLight_swReading, LV_SWITCH_PART_BG, &style_screLight_swReading_bg);

	//Write style LV_SWITCH_PART_INDIC for screLight_swReading
	static lv_style_t style_screLight_swReading_indic;
	lv_style_init(&style_screLight_swReading_indic);

	//Write style state: LV_STATE_DEFAULT for style_screLight_swReading_indic
	lv_style_set_radius(&style_screLight_swReading_indic, LV_STATE_DEFAULT, 100);
	lv_style_set_bg_color(&style_screLight_swReading_indic, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_color(&style_screLight_swReading_indic, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_dir(&style_screLight_swReading_indic, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screLight_swReading_indic, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screLight_swReading, LV_SWITCH_PART_INDIC, &style_screLight_swReading_indic);

	//Write style LV_SWITCH_PART_KNOB for screLight_swReading
	static lv_style_t style_screLight_swReading_knob;
	lv_style_init(&style_screLight_swReading_knob);

	//Write style state: LV_STATE_DEFAULT for style_screLight_swReading_knob
	lv_style_set_radius(&style_screLight_swReading_knob, LV_STATE_DEFAULT, 100);
	lv_style_set_bg_color(&style_screLight_swReading_knob, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screLight_swReading_knob, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screLight_swReading_knob, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screLight_swReading_knob, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screLight_swReading, LV_SWITCH_PART_KNOB, &style_screLight_swReading_knob);
	lv_obj_set_pos(ui->screLight_swReading, 39, 171);
	lv_obj_set_size(ui->screLight_swReading, 55, 27);
	lv_switch_set_anim_time(ui->screLight_swReading, 50);

	//Write codes screLight_labelCeiling
	ui->screLight_labelCeiling = lv_label_create(ui->screLight, NULL);
	lv_label_set_text(ui->screLight_labelCeiling, "Ceiling");
	lv_label_set_long_mode(ui->screLight_labelCeiling, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screLight_labelCeiling, LV_LABEL_ALIGN_LEFT);

	//Write style LV_LABEL_PART_MAIN for screLight_labelCeiling
	static lv_style_t style_screLight_labelCeiling_main;
	lv_style_init(&style_screLight_labelCeiling_main);

	//Write style state: LV_STATE_DEFAULT for style_screLight_labelCeiling_main
	lv_style_set_radius(&style_screLight_labelCeiling_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screLight_labelCeiling_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screLight_labelCeiling_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screLight_labelCeiling_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screLight_labelCeiling_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screLight_labelCeiling_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_font(&style_screLight_labelCeiling_main, LV_STATE_DEFAULT, &lv_font_simsun_16);
	lv_style_set_text_letter_space(&style_screLight_labelCeiling_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screLight_labelCeiling_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screLight_labelCeiling_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screLight_labelCeiling_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screLight_labelCeiling_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screLight_labelCeiling, LV_LABEL_PART_MAIN, &style_screLight_labelCeiling_main);
	lv_obj_set_pos(ui->screLight_labelCeiling, 101, 91);
	lv_obj_set_size(ui->screLight_labelCeiling, 57, 0);

	//Write codes screLight_labelLamp
	ui->screLight_labelLamp = lv_label_create(ui->screLight, NULL);
	lv_label_set_text(ui->screLight_labelLamp, "Lamps");
	lv_label_set_long_mode(ui->screLight_labelLamp, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screLight_labelLamp, LV_LABEL_ALIGN_LEFT);

	//Write style LV_LABEL_PART_MAIN for screLight_labelLamp
	static lv_style_t style_screLight_labelLamp_main;
	lv_style_init(&style_screLight_labelLamp_main);

	//Write style state: LV_STATE_DEFAULT for style_screLight_labelLamp_main
	lv_style_set_radius(&style_screLight_labelLamp_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screLight_labelLamp_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screLight_labelLamp_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screLight_labelLamp_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screLight_labelLamp_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screLight_labelLamp_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_font(&style_screLight_labelLamp_main, LV_STATE_DEFAULT, &lv_font_simsun_16);
	lv_style_set_text_letter_space(&style_screLight_labelLamp_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screLight_labelLamp_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screLight_labelLamp_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screLight_labelLamp_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screLight_labelLamp_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screLight_labelLamp, LV_LABEL_PART_MAIN, &style_screLight_labelLamp_main);
	lv_obj_set_pos(ui->screLight_labelLamp, 101, 135);
	lv_obj_set_size(ui->screLight_labelLamp, 47, 0);

	//Write codes screLight_labelReading
	ui->screLight_labelReading = lv_label_create(ui->screLight, NULL);
	lv_label_set_text(ui->screLight_labelReading, "Reading");
	lv_label_set_long_mode(ui->screLight_labelReading, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screLight_labelReading, LV_LABEL_ALIGN_LEFT);

	//Write style LV_LABEL_PART_MAIN for screLight_labelReading
	static lv_style_t style_screLight_labelReading_main;
	lv_style_init(&style_screLight_labelReading_main);

	//Write style state: LV_STATE_DEFAULT for style_screLight_labelReading_main
	lv_style_set_radius(&style_screLight_labelReading_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screLight_labelReading_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screLight_labelReading_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screLight_labelReading_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screLight_labelReading_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screLight_labelReading_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_font(&style_screLight_labelReading_main, LV_STATE_DEFAULT, &lv_font_simsun_16);
	lv_style_set_text_letter_space(&style_screLight_labelReading_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screLight_labelReading_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screLight_labelReading_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screLight_labelReading_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screLight_labelReading_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screLight_labelReading, LV_LABEL_PART_MAIN, &style_screLight_labelReading_main);
	lv_obj_set_pos(ui->screLight_labelReading, 101, 175);
	lv_obj_set_size(ui->screLight_labelReading, 57, 0);

	//Write codes screLight_sliderCeiling
	ui->screLight_sliderCeiling = lv_slider_create(ui->screLight, NULL);

	//Write style LV_SLIDER_PART_INDIC for screLight_sliderCeiling
	static lv_style_t style_screLight_sliderCeiling_indic;
	lv_style_init(&style_screLight_sliderCeiling_indic);

	//Write style state: LV_STATE_DEFAULT for style_screLight_sliderCeiling_indic
	lv_style_set_radius(&style_screLight_sliderCeiling_indic, LV_STATE_DEFAULT, 50);
	lv_style_set_bg_color(&style_screLight_sliderCeiling_indic, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_color(&style_screLight_sliderCeiling_indic, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_dir(&style_screLight_sliderCeiling_indic, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screLight_sliderCeiling_indic, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screLight_sliderCeiling, LV_SLIDER_PART_INDIC, &style_screLight_sliderCeiling_indic);

	//Write style LV_SLIDER_PART_BG for screLight_sliderCeiling
	static lv_style_t style_screLight_sliderCeiling_bg;
	lv_style_init(&style_screLight_sliderCeiling_bg);

	//Write style state: LV_STATE_DEFAULT for style_screLight_sliderCeiling_bg
	lv_style_set_radius(&style_screLight_sliderCeiling_bg, LV_STATE_DEFAULT, 50);
	lv_style_set_bg_color(&style_screLight_sliderCeiling_bg, LV_STATE_DEFAULT, lv_color_make(0x85, 0x85, 0x85));
	lv_style_set_bg_grad_color(&style_screLight_sliderCeiling_bg, LV_STATE_DEFAULT, lv_color_make(0x85, 0x85, 0x85));
	lv_style_set_bg_grad_dir(&style_screLight_sliderCeiling_bg, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screLight_sliderCeiling_bg, LV_STATE_DEFAULT, 255);
	lv_style_set_outline_color(&style_screLight_sliderCeiling_bg, LV_STATE_DEFAULT, lv_color_make(0xd4, 0xd7, 0xd9));
	lv_style_set_outline_opa(&style_screLight_sliderCeiling_bg, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screLight_sliderCeiling_bg, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screLight_sliderCeiling_bg, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screLight_sliderCeiling_bg, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screLight_sliderCeiling_bg, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screLight_sliderCeiling, LV_SLIDER_PART_BG, &style_screLight_sliderCeiling_bg);

	//Write style LV_SLIDER_PART_KNOB for screLight_sliderCeiling
	static lv_style_t style_screLight_sliderCeiling_knob;
	lv_style_init(&style_screLight_sliderCeiling_knob);

	//Write style state: LV_STATE_DEFAULT for style_screLight_sliderCeiling_knob
	lv_style_set_radius(&style_screLight_sliderCeiling_knob, LV_STATE_DEFAULT, 50);
	lv_style_set_bg_color(&style_screLight_sliderCeiling_knob, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_color(&style_screLight_sliderCeiling_knob, LV_STATE_DEFAULT, lv_color_make(0x02, 0xa2, 0xb1));
	lv_style_set_bg_grad_dir(&style_screLight_sliderCeiling_knob, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screLight_sliderCeiling_knob, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screLight_sliderCeiling, LV_SLIDER_PART_KNOB, &style_screLight_sliderCeiling_knob);
	lv_obj_set_pos(ui->screLight_sliderCeiling, 174, 96);
	lv_obj_set_size(ui->screLight_sliderCeiling, 138, 11);
	lv_slider_set_range(ui->screLight_sliderCeiling,0, 100);
	lv_slider_set_value(ui->screLight_sliderCeiling,50,false);

	//Write codes screLight_sliderLamps
	ui->screLight_sliderLamps = lv_slider_create(ui->screLight, NULL);

	//Write style LV_SLIDER_PART_INDIC for screLight_sliderLamps
	static lv_style_t style_screLight_sliderLamps_indic;
	lv_style_init(&style_screLight_sliderLamps_indic);

	//Write style state: LV_STATE_DEFAULT for style_screLight_sliderLamps_indic
	lv_style_set_radius(&style_screLight_sliderLamps_indic, LV_STATE_DEFAULT, 50);
	lv_style_set_bg_color(&style_screLight_sliderLamps_indic, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_color(&style_screLight_sliderLamps_indic, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_dir(&style_screLight_sliderLamps_indic, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screLight_sliderLamps_indic, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screLight_sliderLamps, LV_SLIDER_PART_INDIC, &style_screLight_sliderLamps_indic);

	//Write style LV_SLIDER_PART_BG for screLight_sliderLamps
	static lv_style_t style_screLight_sliderLamps_bg;
	lv_style_init(&style_screLight_sliderLamps_bg);

	//Write style state: LV_STATE_DEFAULT for style_screLight_sliderLamps_bg
	lv_style_set_radius(&style_screLight_sliderLamps_bg, LV_STATE_DEFAULT, 50);
	lv_style_set_bg_color(&style_screLight_sliderLamps_bg, LV_STATE_DEFAULT, lv_color_make(0x85, 0x85, 0x85));
	lv_style_set_bg_grad_color(&style_screLight_sliderLamps_bg, LV_STATE_DEFAULT, lv_color_make(0x85, 0x85, 0x85));
	lv_style_set_bg_grad_dir(&style_screLight_sliderLamps_bg, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screLight_sliderLamps_bg, LV_STATE_DEFAULT, 255);
	lv_style_set_outline_color(&style_screLight_sliderLamps_bg, LV_STATE_DEFAULT, lv_color_make(0xd4, 0xd7, 0xd9));
	lv_style_set_outline_opa(&style_screLight_sliderLamps_bg, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screLight_sliderLamps_bg, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screLight_sliderLamps_bg, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screLight_sliderLamps_bg, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screLight_sliderLamps_bg, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screLight_sliderLamps, LV_SLIDER_PART_BG, &style_screLight_sliderLamps_bg);

	//Write style LV_SLIDER_PART_KNOB for screLight_sliderLamps
	static lv_style_t style_screLight_sliderLamps_knob;
	lv_style_init(&style_screLight_sliderLamps_knob);

	//Write style state: LV_STATE_DEFAULT for style_screLight_sliderLamps_knob
	lv_style_set_radius(&style_screLight_sliderLamps_knob, LV_STATE_DEFAULT, 50);
	lv_style_set_bg_color(&style_screLight_sliderLamps_knob, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_color(&style_screLight_sliderLamps_knob, LV_STATE_DEFAULT, lv_color_make(0x02, 0xa2, 0xb1));
	lv_style_set_bg_grad_dir(&style_screLight_sliderLamps_knob, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screLight_sliderLamps_knob, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screLight_sliderLamps, LV_SLIDER_PART_KNOB, &style_screLight_sliderLamps_knob);
	lv_obj_set_pos(ui->screLight_sliderLamps, 174, 139);
	lv_obj_set_size(ui->screLight_sliderLamps, 138, 11);
	lv_slider_set_range(ui->screLight_sliderLamps,0, 100);
	lv_slider_set_value(ui->screLight_sliderLamps,50,false);

	//Write codes screLight_imgbtnPalette
	ui->screLight_imgbtnPalette = lv_imgbtn_create(ui->screLight, NULL);

	//Write style LV_IMGBTN_PART_MAIN for screLight_imgbtnPalette
	static lv_style_t style_screLight_imgbtnPalette_main;
	lv_style_init(&style_screLight_imgbtnPalette_main);

	//Write style state: LV_STATE_DEFAULT for style_screLight_imgbtnPalette_main
	lv_style_set_text_color(&style_screLight_imgbtnPalette_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_image_recolor(&style_screLight_imgbtnPalette_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screLight_imgbtnPalette_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screLight_imgbtnPalette_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screLight_imgbtnPalette, LV_IMGBTN_PART_MAIN, &style_screLight_imgbtnPalette_main);
	lv_obj_set_pos(ui->screLight_imgbtnPalette, 333, 75);
	lv_obj_set_size(ui->screLight_imgbtnPalette, 140, 140);
	lv_imgbtn_set_src(ui->screLight_imgbtnPalette,LV_BTN_STATE_RELEASED,&_color_table_alpha_140x140);
	lv_imgbtn_set_src(ui->screLight_imgbtnPalette,LV_BTN_STATE_PRESSED,&_color_table_alpha_140x140);

	//Write codes screLight_sliderReading
	ui->screLight_sliderReading = lv_slider_create(ui->screLight, NULL);

	//Write style LV_SLIDER_PART_INDIC for screLight_sliderReading
	static lv_style_t style_screLight_sliderReading_indic;
	lv_style_init(&style_screLight_sliderReading_indic);

	//Write style state: LV_STATE_DEFAULT for style_screLight_sliderReading_indic
	lv_style_set_radius(&style_screLight_sliderReading_indic, LV_STATE_DEFAULT, 50);
	lv_style_set_bg_color(&style_screLight_sliderReading_indic, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_color(&style_screLight_sliderReading_indic, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_dir(&style_screLight_sliderReading_indic, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screLight_sliderReading_indic, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screLight_sliderReading, LV_SLIDER_PART_INDIC, &style_screLight_sliderReading_indic);

	//Write style LV_SLIDER_PART_BG for screLight_sliderReading
	static lv_style_t style_screLight_sliderReading_bg;
	lv_style_init(&style_screLight_sliderReading_bg);

	//Write style state: LV_STATE_DEFAULT for style_screLight_sliderReading_bg
	lv_style_set_radius(&style_screLight_sliderReading_bg, LV_STATE_DEFAULT, 50);
	lv_style_set_bg_color(&style_screLight_sliderReading_bg, LV_STATE_DEFAULT, lv_color_make(0x85, 0x85, 0x85));
	lv_style_set_bg_grad_color(&style_screLight_sliderReading_bg, LV_STATE_DEFAULT, lv_color_make(0x85, 0x85, 0x85));
	lv_style_set_bg_grad_dir(&style_screLight_sliderReading_bg, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screLight_sliderReading_bg, LV_STATE_DEFAULT, 255);
	lv_style_set_outline_color(&style_screLight_sliderReading_bg, LV_STATE_DEFAULT, lv_color_make(0xd4, 0xd7, 0xd9));
	lv_style_set_outline_opa(&style_screLight_sliderReading_bg, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screLight_sliderReading_bg, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screLight_sliderReading_bg, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screLight_sliderReading_bg, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screLight_sliderReading_bg, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screLight_sliderReading, LV_SLIDER_PART_BG, &style_screLight_sliderReading_bg);

	//Write style LV_SLIDER_PART_KNOB for screLight_sliderReading
	static lv_style_t style_screLight_sliderReading_knob;
	lv_style_init(&style_screLight_sliderReading_knob);

	//Write style state: LV_STATE_DEFAULT for style_screLight_sliderReading_knob
	lv_style_set_radius(&style_screLight_sliderReading_knob, LV_STATE_DEFAULT, 50);
	lv_style_set_bg_color(&style_screLight_sliderReading_knob, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_color(&style_screLight_sliderReading_knob, LV_STATE_DEFAULT, lv_color_make(0x02, 0xa2, 0xb1));
	lv_style_set_bg_grad_dir(&style_screLight_sliderReading_knob, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screLight_sliderReading_knob, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screLight_sliderReading, LV_SLIDER_PART_KNOB, &style_screLight_sliderReading_knob);
	lv_obj_set_pos(ui->screLight_sliderReading, 174, 179);
	lv_obj_set_size(ui->screLight_sliderReading, 138, 11);
	lv_slider_set_range(ui->screLight_sliderReading,0, 100);
	lv_slider_set_value(ui->screLight_sliderReading,50,false);

	//Write codes screLight_ddlistLight
	ui->screLight_ddlistLight = lv_dropdown_create(ui->screLight, NULL);
	lv_dropdown_set_options(ui->screLight_ddlistLight, "Living room\nDining room\nBed room");
	lv_dropdown_set_max_height(ui->screLight_ddlistLight, 90);

	//Write style LV_DROPDOWN_PART_MAIN for screLight_ddlistLight
	static lv_style_t style_screLight_ddlistLight_main;
	lv_style_init(&style_screLight_ddlistLight_main);

	//Write style state: LV_STATE_DEFAULT for style_screLight_ddlistLight_main
	lv_style_set_radius(&style_screLight_ddlistLight_main, LV_STATE_DEFAULT, 3);
	lv_style_set_bg_color(&style_screLight_ddlistLight_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screLight_ddlistLight_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screLight_ddlistLight_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screLight_ddlistLight_main, LV_STATE_DEFAULT, 0);
	lv_style_set_border_color(&style_screLight_ddlistLight_main, LV_STATE_DEFAULT, lv_color_make(0xe1, 0xe6, 0xee));
	lv_style_set_border_width(&style_screLight_ddlistLight_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screLight_ddlistLight_main, LV_STATE_DEFAULT, lv_color_make(0x0D, 0x30, 0x55));
	lv_style_set_text_font(&style_screLight_ddlistLight_main, LV_STATE_DEFAULT, &lv_font_simsun_16);
	lv_style_set_text_line_space(&style_screLight_ddlistLight_main, LV_STATE_DEFAULT, 20);
	lv_obj_add_style(ui->screLight_ddlistLight, LV_DROPDOWN_PART_MAIN, &style_screLight_ddlistLight_main);

	//Write style LV_DROPDOWN_PART_SELECTED for screLight_ddlistLight
	static lv_style_t style_screLight_ddlistLight_selected;
	lv_style_init(&style_screLight_ddlistLight_selected);

	//Write style state: LV_STATE_DEFAULT for style_screLight_ddlistLight_selected
	lv_style_set_radius(&style_screLight_ddlistLight_selected, LV_STATE_DEFAULT, 3);
	lv_style_set_bg_color(&style_screLight_ddlistLight_selected, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_color(&style_screLight_ddlistLight_selected, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_dir(&style_screLight_ddlistLight_selected, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screLight_ddlistLight_selected, LV_STATE_DEFAULT, 255);
	lv_style_set_border_color(&style_screLight_ddlistLight_selected, LV_STATE_DEFAULT, lv_color_make(0xe1, 0xe6, 0xee));
	lv_style_set_border_width(&style_screLight_ddlistLight_selected, LV_STATE_DEFAULT, 1);
	lv_style_set_text_color(&style_screLight_ddlistLight_selected, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_text_font(&style_screLight_ddlistLight_selected, LV_STATE_DEFAULT, &lv_font_simsun_16);
	lv_obj_add_style(ui->screLight_ddlistLight, LV_DROPDOWN_PART_SELECTED, &style_screLight_ddlistLight_selected);

	//Write style LV_DROPDOWN_PART_LIST for screLight_ddlistLight
	static lv_style_t style_screLight_ddlistLight_list;
	lv_style_init(&style_screLight_ddlistLight_list);

	//Write style state: LV_STATE_DEFAULT for style_screLight_ddlistLight_list
	lv_style_set_radius(&style_screLight_ddlistLight_list, LV_STATE_DEFAULT, 3);
	lv_style_set_bg_color(&style_screLight_ddlistLight_list, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screLight_ddlistLight_list, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screLight_ddlistLight_list, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screLight_ddlistLight_list, LV_STATE_DEFAULT, 255);
	lv_style_set_border_color(&style_screLight_ddlistLight_list, LV_STATE_DEFAULT, lv_color_make(0xe1, 0xe6, 0xee));
	lv_style_set_border_width(&style_screLight_ddlistLight_list, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screLight_ddlistLight_list, LV_STATE_DEFAULT, lv_color_make(0x0D, 0x30, 0x55));
	lv_style_set_text_font(&style_screLight_ddlistLight_list, LV_STATE_DEFAULT, &lv_font_simsun_16);
	lv_obj_add_style(ui->screLight_ddlistLight, LV_DROPDOWN_PART_LIST, &style_screLight_ddlistLight_list);
	lv_obj_set_pos(ui->screLight_ddlistLight, 179, 49);
	lv_obj_set_width(ui->screLight_ddlistLight, 146);

	//Write codes screLight_lineSeparator
	ui->screLight_lineSeparator = lv_line_create(ui->screLight, NULL);

	//Write style LV_LINE_PART_MAIN for screLight_lineSeparator
	static lv_style_t style_screLight_lineSeparator_main;
	lv_style_init(&style_screLight_lineSeparator_main);

	//Write style state: LV_STATE_DEFAULT for style_screLight_lineSeparator_main
	lv_style_set_line_color(&style_screLight_lineSeparator_main, LV_STATE_DEFAULT, lv_color_make(0x94, 0x94, 0x94));
	lv_style_set_line_width(&style_screLight_lineSeparator_main, LV_STATE_DEFAULT, 3);
	lv_obj_add_style(ui->screLight_lineSeparator, LV_LINE_PART_MAIN, &style_screLight_lineSeparator_main);
	lv_obj_set_pos(ui->screLight_lineSeparator, 156, 76);
	lv_obj_set_size(ui->screLight_lineSeparator, 200, 7);
	static lv_point_t screLight_lineSeparator[] ={{0,0},{200,0}};
	lv_line_set_points(ui->screLight_lineSeparator,screLight_lineSeparator,2);

	//Write codes screLight_imgbtnAllLightOn
	ui->screLight_imgbtnAllLightOn = lv_imgbtn_create(ui->screLight, NULL);

	//Write style LV_IMGBTN_PART_MAIN for screLight_imgbtnAllLightOn
	static lv_style_t style_screLight_imgbtnAllLightOn_main;
	lv_style_init(&style_screLight_imgbtnAllLightOn_main);

	//Write style state: LV_STATE_DEFAULT for style_screLight_imgbtnAllLightOn_main
	lv_style_set_text_color(&style_screLight_imgbtnAllLightOn_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_image_recolor(&style_screLight_imgbtnAllLightOn_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screLight_imgbtnAllLightOn_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screLight_imgbtnAllLightOn_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screLight_imgbtnAllLightOn, LV_IMGBTN_PART_MAIN, &style_screLight_imgbtnAllLightOn_main);
	lv_obj_set_pos(ui->screLight_imgbtnAllLightOn, 94, 207);
	lv_obj_set_size(ui->screLight_imgbtnAllLightOn, 50, 50);
	lv_imgbtn_set_src(ui->screLight_imgbtnAllLightOn,LV_BTN_STATE_RELEASED,&_btn_small_bg_allLightOn_alpha_50x50);
	lv_imgbtn_set_src(ui->screLight_imgbtnAllLightOn,LV_BTN_STATE_PRESSED,&_btn_small_bg_allLightOn_alpha_50x50);

	//Write codes screLight_imgbtnAllLightOff
	ui->screLight_imgbtnAllLightOff = lv_imgbtn_create(ui->screLight, NULL);

	//Write style LV_IMGBTN_PART_MAIN for screLight_imgbtnAllLightOff
	static lv_style_t style_screLight_imgbtnAllLightOff_main;
	lv_style_init(&style_screLight_imgbtnAllLightOff_main);

	//Write style state: LV_STATE_DEFAULT for style_screLight_imgbtnAllLightOff_main
	lv_style_set_text_color(&style_screLight_imgbtnAllLightOff_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_image_recolor(&style_screLight_imgbtnAllLightOff_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screLight_imgbtnAllLightOff_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screLight_imgbtnAllLightOff_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screLight_imgbtnAllLightOff, LV_IMGBTN_PART_MAIN, &style_screLight_imgbtnAllLightOff_main);
	lv_obj_set_pos(ui->screLight_imgbtnAllLightOff, 164, 207);
	lv_obj_set_size(ui->screLight_imgbtnAllLightOff, 50, 50);
	lv_imgbtn_set_src(ui->screLight_imgbtnAllLightOff,LV_BTN_STATE_RELEASED,&_btn_small_bg_allLightOff_alpha_50x50);
	lv_imgbtn_set_src(ui->screLight_imgbtnAllLightOff,LV_BTN_STATE_PRESSED,&_btn_small_bg_allLightOff_alpha_50x50);

	//Write codes screLight_imgbtnMovie
	ui->screLight_imgbtnMovie = lv_imgbtn_create(ui->screLight, NULL);

	//Write style LV_IMGBTN_PART_MAIN for screLight_imgbtnMovie
	static lv_style_t style_screLight_imgbtnMovie_main;
	lv_style_init(&style_screLight_imgbtnMovie_main);

	//Write style state: LV_STATE_DEFAULT for style_screLight_imgbtnMovie_main
	lv_style_set_text_color(&style_screLight_imgbtnMovie_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_image_recolor(&style_screLight_imgbtnMovie_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screLight_imgbtnMovie_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screLight_imgbtnMovie_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screLight_imgbtnMovie, LV_IMGBTN_PART_MAIN, &style_screLight_imgbtnMovie_main);
	lv_obj_set_pos(ui->screLight_imgbtnMovie, 232, 207);
	lv_obj_set_size(ui->screLight_imgbtnMovie, 50, 50);
	lv_imgbtn_set_src(ui->screLight_imgbtnMovie,LV_BTN_STATE_RELEASED,&_btn_small_bg_cinema_alpha_50x50);
	lv_imgbtn_set_src(ui->screLight_imgbtnMovie,LV_BTN_STATE_PRESSED,&_btn_small_bg_cinema_alpha_50x50);

	//Write codes screLight_imgbtnParty
	ui->screLight_imgbtnParty = lv_imgbtn_create(ui->screLight, NULL);

	//Write style LV_IMGBTN_PART_MAIN for screLight_imgbtnParty
	static lv_style_t style_screLight_imgbtnParty_main;
	lv_style_init(&style_screLight_imgbtnParty_main);

	//Write style state: LV_STATE_DEFAULT for style_screLight_imgbtnParty_main
	lv_style_set_text_color(&style_screLight_imgbtnParty_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_font(&style_screLight_imgbtnParty_main, LV_STATE_DEFAULT, &lv_font_simsun_12);
	lv_style_set_image_recolor(&style_screLight_imgbtnParty_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screLight_imgbtnParty_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screLight_imgbtnParty_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screLight_imgbtnParty, LV_IMGBTN_PART_MAIN, &style_screLight_imgbtnParty_main);
	lv_obj_set_pos(ui->screLight_imgbtnParty, 299, 208);
	lv_obj_set_size(ui->screLight_imgbtnParty, 50, 50);
	lv_imgbtn_set_src(ui->screLight_imgbtnParty,LV_BTN_STATE_RELEASED,&_btn_small_bg_alpha_50x50);
	lv_imgbtn_set_src(ui->screLight_imgbtnParty,LV_BTN_STATE_PRESSED,&_btn_small_bg_alpha_50x50);
	ui->screLight_imgbtnParty_label = lv_label_create(ui->screLight_imgbtnParty, NULL);
	lv_label_set_text(ui->screLight_imgbtnParty_label, "Party");

	//Write codes screLight_labelLightSlogan
	ui->screLight_labelLightSlogan = lv_label_create(ui->screLight, NULL);
	lv_label_set_text(ui->screLight_labelLightSlogan, "LIGHT CONTROL");
	lv_label_set_long_mode(ui->screLight_labelLightSlogan, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screLight_labelLightSlogan, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screLight_labelLightSlogan
	static lv_style_t style_screLight_labelLightSlogan_main;
	lv_style_init(&style_screLight_labelLightSlogan_main);

	//Write style state: LV_STATE_DEFAULT for style_screLight_labelLightSlogan_main
	lv_style_set_radius(&style_screLight_labelLightSlogan_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screLight_labelLightSlogan_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_bg_grad_color(&style_screLight_labelLightSlogan_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_bg_grad_dir(&style_screLight_labelLightSlogan_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screLight_labelLightSlogan_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screLight_labelLightSlogan_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_text_font(&style_screLight_labelLightSlogan_main, LV_STATE_DEFAULT, &lv_font_simsun_22);
	lv_style_set_text_letter_space(&style_screLight_labelLightSlogan_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screLight_labelLightSlogan_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screLight_labelLightSlogan_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screLight_labelLightSlogan_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screLight_labelLightSlogan_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screLight_labelLightSlogan, LV_LABEL_PART_MAIN, &style_screLight_labelLightSlogan_main);
	lv_obj_set_pos(ui->screLight_labelLightSlogan, 142, 9);
	lv_obj_set_size(ui->screLight_labelLightSlogan, 206, 0);

	//Write codes screLight_labelTime
	ui->screLight_labelTime = lv_label_create(ui->screLight, NULL);
	lv_label_set_text(ui->screLight_labelTime, "10:54 AM");
	lv_label_set_long_mode(ui->screLight_labelTime, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screLight_labelTime, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screLight_labelTime
	static lv_style_t style_screLight_labelTime_main;
	lv_style_init(&style_screLight_labelTime_main);

	//Write style state: LV_STATE_DEFAULT for style_screLight_labelTime_main
	lv_style_set_radius(&style_screLight_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screLight_labelTime_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_bg_grad_color(&style_screLight_labelTime_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screLight_labelTime_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screLight_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screLight_labelTime_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_text_font(&style_screLight_labelTime_main, LV_STATE_DEFAULT, &lv_font_simsun_20);
	lv_style_set_text_letter_space(&style_screLight_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screLight_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screLight_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screLight_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screLight_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screLight_labelTime, LV_LABEL_PART_MAIN, &style_screLight_labelTime_main);
	lv_obj_set_pos(ui->screLight_labelTime, 380, 7);
	lv_obj_set_size(ui->screLight_labelTime, 96, 0);

	//Init events for screen
	events_init_screLight(ui);
}