/*
 * Copyright 2021 NXP
 * SPDX-License-Identifier: MIT
 */

#include "lvgl/lvgl.h"
#include <stdio.h>
#include "gui_guider.h"
#include "events_init.h"
#include "custom.h"


void setup_scr_screAudio(lv_ui *ui){

	//Write codes screAudio
	ui->screAudio = lv_obj_create(NULL, NULL);

	//Write codes screAudio_contBackground
	ui->screAudio_contBackground = lv_cont_create(ui->screAudio, NULL);

	//Write style LV_CONT_PART_MAIN for screAudio_contBackground
	static lv_style_t style_screAudio_contBackground_main;
	lv_style_init(&style_screAudio_contBackground_main);

	//Write style state: LV_STATE_DEFAULT for style_screAudio_contBackground_main
	lv_style_set_radius(&style_screAudio_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screAudio_contBackground_main, LV_STATE_DEFAULT, lv_color_make(0xe0, 0xe0, 0xe0));
	lv_style_set_bg_grad_color(&style_screAudio_contBackground_main, LV_STATE_DEFAULT, lv_color_make(0xf4, 0xf4, 0xf4));
	lv_style_set_bg_grad_dir(&style_screAudio_contBackground_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screAudio_contBackground_main, LV_STATE_DEFAULT, 255);
	lv_style_set_border_color(&style_screAudio_contBackground_main, LV_STATE_DEFAULT, lv_color_make(0x99, 0x99, 0x99));
	lv_style_set_border_width(&style_screAudio_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_border_opa(&style_screAudio_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screAudio_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screAudio_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screAudio_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screAudio_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screAudio_contBackground, LV_CONT_PART_MAIN, &style_screAudio_contBackground_main);
	lv_obj_set_pos(ui->screAudio_contBackground, 0, 0);
	lv_obj_set_size(ui->screAudio_contBackground, 480, 272);
	lv_obj_set_click(ui->screAudio_contBackground, false);
	lv_cont_set_layout(ui->screAudio_contBackground, LV_LAYOUT_OFF);
	lv_cont_set_fit(ui->screAudio_contBackground, LV_FIT_NONE);

	//Write codes screAudio_imgHead
	ui->screAudio_imgHead = lv_img_create(ui->screAudio, NULL);

	//Write style LV_IMG_PART_MAIN for screAudio_imgHead
	static lv_style_t style_screAudio_imgHead_main;
	lv_style_init(&style_screAudio_imgHead_main);

	//Write style state: LV_STATE_DEFAULT for style_screAudio_imgHead_main
	lv_style_set_image_recolor(&style_screAudio_imgHead_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screAudio_imgHead_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screAudio_imgHead_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screAudio_imgHead, LV_IMG_PART_MAIN, &style_screAudio_imgHead_main);
	lv_obj_set_pos(ui->screAudio_imgHead, 0, 0);
	lv_obj_set_size(ui->screAudio_imgHead, 480, 80);
	lv_obj_set_click(ui->screAudio_imgHead, true);
	lv_img_set_src(ui->screAudio_imgHead,&_img_header_alpha_480x80);
	lv_img_set_pivot(ui->screAudio_imgHead, 0,0);
	lv_img_set_angle(ui->screAudio_imgHead, 0);

	//Write codes screAudio_labelAudioSlogan
	ui->screAudio_labelAudioSlogan = lv_label_create(ui->screAudio, NULL);
	lv_label_set_text(ui->screAudio_labelAudioSlogan, "MUSIC CONTROL");
	lv_label_set_long_mode(ui->screAudio_labelAudioSlogan, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screAudio_labelAudioSlogan, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screAudio_labelAudioSlogan
	static lv_style_t style_screAudio_labelAudioSlogan_main;
	lv_style_init(&style_screAudio_labelAudioSlogan_main);

	//Write style state: LV_STATE_DEFAULT for style_screAudio_labelAudioSlogan_main
	lv_style_set_radius(&style_screAudio_labelAudioSlogan_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screAudio_labelAudioSlogan_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_bg_grad_color(&style_screAudio_labelAudioSlogan_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_bg_grad_dir(&style_screAudio_labelAudioSlogan_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screAudio_labelAudioSlogan_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screAudio_labelAudioSlogan_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_text_font(&style_screAudio_labelAudioSlogan_main, LV_STATE_DEFAULT, &lv_font_simsun_22);
	lv_style_set_text_letter_space(&style_screAudio_labelAudioSlogan_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screAudio_labelAudioSlogan_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screAudio_labelAudioSlogan_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screAudio_labelAudioSlogan_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screAudio_labelAudioSlogan_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screAudio_labelAudioSlogan, LV_LABEL_PART_MAIN, &style_screAudio_labelAudioSlogan_main);
	lv_obj_set_pos(ui->screAudio_labelAudioSlogan, 143, 7);
	lv_obj_set_size(ui->screAudio_labelAudioSlogan, 206, 0);

	//Write codes screAudio_labelTime
	ui->screAudio_labelTime = lv_label_create(ui->screAudio, NULL);
	lv_label_set_text(ui->screAudio_labelTime, "10:54 AM");
	lv_label_set_long_mode(ui->screAudio_labelTime, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screAudio_labelTime, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screAudio_labelTime
	static lv_style_t style_screAudio_labelTime_main;
	lv_style_init(&style_screAudio_labelTime_main);

	//Write style state: LV_STATE_DEFAULT for style_screAudio_labelTime_main
	lv_style_set_radius(&style_screAudio_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screAudio_labelTime_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_bg_grad_color(&style_screAudio_labelTime_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screAudio_labelTime_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screAudio_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screAudio_labelTime_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_text_font(&style_screAudio_labelTime_main, LV_STATE_DEFAULT, &lv_font_simsun_20);
	lv_style_set_text_letter_space(&style_screAudio_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screAudio_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screAudio_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screAudio_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screAudio_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screAudio_labelTime, LV_LABEL_PART_MAIN, &style_screAudio_labelTime_main);
	lv_obj_set_pos(ui->screAudio_labelTime, 379, 8);
	lv_obj_set_size(ui->screAudio_labelTime, 100, 0);

	//Write codes screAudio_imgbtnAudioNext
	ui->screAudio_imgbtnAudioNext = lv_imgbtn_create(ui->screAudio, NULL);

	//Write style LV_IMGBTN_PART_MAIN for screAudio_imgbtnAudioNext
	static lv_style_t style_screAudio_imgbtnAudioNext_main;
	lv_style_init(&style_screAudio_imgbtnAudioNext_main);

	//Write style state: LV_STATE_DEFAULT for style_screAudio_imgbtnAudioNext_main
	lv_style_set_text_color(&style_screAudio_imgbtnAudioNext_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_image_recolor(&style_screAudio_imgbtnAudioNext_main, LV_STATE_DEFAULT, lv_color_make(0x78, 0x78, 0x78));
	lv_style_set_image_recolor_opa(&style_screAudio_imgbtnAudioNext_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screAudio_imgbtnAudioNext_main, LV_STATE_DEFAULT, 255);

	//Write style state: LV_STATE_PRESSED for style_screAudio_imgbtnAudioNext_main
	lv_style_set_text_color(&style_screAudio_imgbtnAudioNext_main, LV_STATE_PRESSED, lv_color_make(0xFF, 0x33, 0xFF));
	lv_style_set_image_recolor(&style_screAudio_imgbtnAudioNext_main, LV_STATE_PRESSED, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_image_recolor_opa(&style_screAudio_imgbtnAudioNext_main, LV_STATE_PRESSED, 0);

	//Write style state: LV_STATE_CHECKED for style_screAudio_imgbtnAudioNext_main
	lv_style_set_text_color(&style_screAudio_imgbtnAudioNext_main, LV_STATE_CHECKED, lv_color_make(0xFF, 0x33, 0xFF));
	lv_style_set_image_recolor(&style_screAudio_imgbtnAudioNext_main, LV_STATE_CHECKED, lv_color_make(0x80, 0x80, 0x80));
	lv_style_set_image_recolor_opa(&style_screAudio_imgbtnAudioNext_main, LV_STATE_CHECKED, 100);
	lv_obj_add_style(ui->screAudio_imgbtnAudioNext, LV_IMGBTN_PART_MAIN, &style_screAudio_imgbtnAudioNext_main);
	lv_obj_set_pos(ui->screAudio_imgbtnAudioNext, 371, 113);
	lv_obj_set_size(ui->screAudio_imgbtnAudioNext, 51, 52);
	lv_imgbtn_set_src(ui->screAudio_imgbtnAudioNext,LV_BTN_STATE_RELEASED,&_btn_big_bg_forward_alpha_51x52);

	//Write codes screAudio_imgbtnAudioPre
	ui->screAudio_imgbtnAudioPre = lv_imgbtn_create(ui->screAudio, NULL);

	//Write style LV_IMGBTN_PART_MAIN for screAudio_imgbtnAudioPre
	static lv_style_t style_screAudio_imgbtnAudioPre_main;
	lv_style_init(&style_screAudio_imgbtnAudioPre_main);

	//Write style state: LV_STATE_DEFAULT for style_screAudio_imgbtnAudioPre_main
	lv_style_set_text_color(&style_screAudio_imgbtnAudioPre_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_image_recolor(&style_screAudio_imgbtnAudioPre_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screAudio_imgbtnAudioPre_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screAudio_imgbtnAudioPre_main, LV_STATE_DEFAULT, 255);

	//Write style state: LV_STATE_CHECKED for style_screAudio_imgbtnAudioPre_main
	lv_style_set_text_color(&style_screAudio_imgbtnAudioPre_main, LV_STATE_CHECKED, lv_color_make(0xFF, 0x33, 0xFF));
	lv_style_set_image_recolor(&style_screAudio_imgbtnAudioPre_main, LV_STATE_CHECKED, lv_color_make(0x80, 0x80, 0x80));
	lv_style_set_image_recolor_opa(&style_screAudio_imgbtnAudioPre_main, LV_STATE_CHECKED, 100);
	lv_obj_add_style(ui->screAudio_imgbtnAudioPre, LV_IMGBTN_PART_MAIN, &style_screAudio_imgbtnAudioPre_main);
	lv_obj_set_pos(ui->screAudio_imgbtnAudioPre, 54, 113);
	lv_obj_set_size(ui->screAudio_imgbtnAudioPre, 51, 52);
	lv_imgbtn_set_src(ui->screAudio_imgbtnAudioPre,LV_BTN_STATE_RELEASED,&_btn_big_bg_backward_alpha_51x52);

	//Write codes screAudio_arcAudioControl
	ui->screAudio_arcAudioControl = lv_arc_create(ui->screAudio, NULL);

	//Write style LV_ARC_PART_BG for screAudio_arcAudioControl
	static lv_style_t style_screAudio_arcAudioControl_bg;
	lv_style_init(&style_screAudio_arcAudioControl_bg);

	//Write style state: LV_STATE_DEFAULT for style_screAudio_arcAudioControl_bg
	lv_style_set_bg_color(&style_screAudio_arcAudioControl_bg, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screAudio_arcAudioControl_bg, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screAudio_arcAudioControl_bg, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screAudio_arcAudioControl_bg, LV_STATE_DEFAULT, 0);
	lv_style_set_border_width(&style_screAudio_arcAudioControl_bg, LV_STATE_DEFAULT, 0);
	lv_style_set_line_color(&style_screAudio_arcAudioControl_bg, LV_STATE_DEFAULT, lv_color_make(0x8a, 0x8a, 0x8a));
	lv_style_set_line_width(&style_screAudio_arcAudioControl_bg, LV_STATE_DEFAULT, 9);
	lv_obj_add_style(ui->screAudio_arcAudioControl, LV_ARC_PART_BG, &style_screAudio_arcAudioControl_bg);

	//Write style LV_ARC_PART_INDIC for screAudio_arcAudioControl
	static lv_style_t style_screAudio_arcAudioControl_indic;
	lv_style_init(&style_screAudio_arcAudioControl_indic);

	//Write style state: LV_STATE_DEFAULT for style_screAudio_arcAudioControl_indic
	lv_style_set_line_color(&style_screAudio_arcAudioControl_indic, LV_STATE_DEFAULT, lv_color_make(0x52, 0x52, 0xff));
	lv_style_set_line_width(&style_screAudio_arcAudioControl_indic, LV_STATE_DEFAULT, 9);
	lv_obj_add_style(ui->screAudio_arcAudioControl, LV_ARC_PART_INDIC, &style_screAudio_arcAudioControl_indic);
	lv_obj_set_pos(ui->screAudio_arcAudioControl, 136, 60);
	lv_obj_set_size(ui->screAudio_arcAudioControl, 200, 200);
	lv_arc_set_bg_angles(ui->screAudio_arcAudioControl, 145, 395);
	lv_arc_set_angles(ui->screAudio_arcAudioControl, 145, 145);
	lv_arc_set_rotation(ui->screAudio_arcAudioControl, 0);
	lv_obj_set_style_local_pad_top(ui->screAudio_arcAudioControl, LV_ARC_PART_BG, LV_STATE_DEFAULT, 10);
	lv_obj_set_style_local_pad_bottom(ui->screAudio_arcAudioControl, LV_ARC_PART_BG, LV_STATE_DEFAULT, 10);
	lv_obj_set_style_local_pad_left(ui->screAudio_arcAudioControl, LV_ARC_PART_BG, LV_STATE_DEFAULT, 10);
	lv_obj_set_style_local_pad_right(ui->screAudio_arcAudioControl, LV_ARC_PART_BG, LV_STATE_DEFAULT, 10);
	lv_arc_set_adjustable(ui->screAudio_arcAudioControl, true);

	//Write codes screAudio_imgbtnHome
	ui->screAudio_imgbtnHome = lv_imgbtn_create(ui->screAudio, NULL);

	//Write style LV_IMGBTN_PART_MAIN for screAudio_imgbtnHome
	static lv_style_t style_screAudio_imgbtnHome_main;
	lv_style_init(&style_screAudio_imgbtnHome_main);

	//Write style state: LV_STATE_DEFAULT for style_screAudio_imgbtnHome_main
	lv_style_set_text_color(&style_screAudio_imgbtnHome_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_image_recolor(&style_screAudio_imgbtnHome_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screAudio_imgbtnHome_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screAudio_imgbtnHome_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screAudio_imgbtnHome, LV_IMGBTN_PART_MAIN, &style_screAudio_imgbtnHome_main);
	lv_obj_set_pos(ui->screAudio_imgbtnHome, 36, 0);
	lv_obj_set_size(ui->screAudio_imgbtnHome, 55, 50);
	lv_imgbtn_set_src(ui->screAudio_imgbtnHome,LV_BTN_STATE_RELEASED,&_btn_long_top_house_alpha_55x50);
	lv_imgbtn_set_src(ui->screAudio_imgbtnHome,LV_BTN_STATE_PRESSED,&_btn_long_top_house_alpha_55x50);

	//Write codes screAudio_contBackspeaker
	ui->screAudio_contBackspeaker = lv_cont_create(ui->screAudio, NULL);

	//Write style LV_CONT_PART_MAIN for screAudio_contBackspeaker
	static lv_style_t style_screAudio_contBackspeaker_main;
	lv_style_init(&style_screAudio_contBackspeaker_main);

	//Write style state: LV_STATE_DEFAULT for style_screAudio_contBackspeaker_main
	lv_style_set_radius(&style_screAudio_contBackspeaker_main, LV_STATE_DEFAULT, 5);
	lv_style_set_bg_color(&style_screAudio_contBackspeaker_main, LV_STATE_DEFAULT, lv_color_make(0x50, 0x50, 0x50));
	lv_style_set_bg_grad_color(&style_screAudio_contBackspeaker_main, LV_STATE_DEFAULT, lv_color_make(0x50, 0x50, 0x50));
	lv_style_set_bg_grad_dir(&style_screAudio_contBackspeaker_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screAudio_contBackspeaker_main, LV_STATE_DEFAULT, 255);
	lv_style_set_border_color(&style_screAudio_contBackspeaker_main, LV_STATE_DEFAULT, lv_color_make(0x99, 0x99, 0x99));
	lv_style_set_border_width(&style_screAudio_contBackspeaker_main, LV_STATE_DEFAULT, 1);
	lv_style_set_border_opa(&style_screAudio_contBackspeaker_main, LV_STATE_DEFAULT, 255);
	lv_style_set_pad_left(&style_screAudio_contBackspeaker_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screAudio_contBackspeaker_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screAudio_contBackspeaker_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screAudio_contBackspeaker_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screAudio_contBackspeaker, LV_CONT_PART_MAIN, &style_screAudio_contBackspeaker_main);
	lv_obj_set_pos(ui->screAudio_contBackspeaker, 0, 239);
	lv_obj_set_size(ui->screAudio_contBackspeaker, 480, 30);
	lv_obj_set_click(ui->screAudio_contBackspeaker, false);
	lv_cont_set_layout(ui->screAudio_contBackspeaker, LV_LAYOUT_OFF);
	lv_cont_set_fit(ui->screAudio_contBackspeaker, LV_FIT_NONE);

	//Write codes screAudio_imgbtnAudioSel
	ui->screAudio_imgbtnAudioSel = lv_imgbtn_create(ui->screAudio, NULL);

	//Write style LV_IMGBTN_PART_MAIN for screAudio_imgbtnAudioSel
	static lv_style_t style_screAudio_imgbtnAudioSel_main;
	lv_style_init(&style_screAudio_imgbtnAudioSel_main);

	//Write style state: LV_STATE_DEFAULT for style_screAudio_imgbtnAudioSel_main
	lv_style_set_text_color(&style_screAudio_imgbtnAudioSel_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_image_recolor(&style_screAudio_imgbtnAudioSel_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screAudio_imgbtnAudioSel_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screAudio_imgbtnAudioSel_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screAudio_imgbtnAudioSel, LV_IMGBTN_PART_MAIN, &style_screAudio_imgbtnAudioSel_main);
	lv_obj_set_pos(ui->screAudio_imgbtnAudioSel, 419, 220);
	lv_obj_set_size(ui->screAudio_imgbtnAudioSel, 49, 48);
	lv_imgbtn_set_src(ui->screAudio_imgbtnAudioSel,LV_BTN_STATE_RELEASED,&_btn_long_button_list_alpha_49x48);

	//Write codes screAudio_sliderSpeakerVol
	ui->screAudio_sliderSpeakerVol = lv_slider_create(ui->screAudio, NULL);

	//Write style LV_SLIDER_PART_INDIC for screAudio_sliderSpeakerVol
	static lv_style_t style_screAudio_sliderSpeakerVol_indic;
	lv_style_init(&style_screAudio_sliderSpeakerVol_indic);

	//Write style state: LV_STATE_DEFAULT for style_screAudio_sliderSpeakerVol_indic
	lv_style_set_radius(&style_screAudio_sliderSpeakerVol_indic, LV_STATE_DEFAULT, 50);
	lv_style_set_bg_color(&style_screAudio_sliderSpeakerVol_indic, LV_STATE_DEFAULT, lv_color_make(0x52, 0x52, 0xff));
	lv_style_set_bg_grad_color(&style_screAudio_sliderSpeakerVol_indic, LV_STATE_DEFAULT, lv_color_make(0x52, 0x52, 0xff));
	lv_style_set_bg_grad_dir(&style_screAudio_sliderSpeakerVol_indic, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screAudio_sliderSpeakerVol_indic, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screAudio_sliderSpeakerVol, LV_SLIDER_PART_INDIC, &style_screAudio_sliderSpeakerVol_indic);

	//Write style LV_SLIDER_PART_BG for screAudio_sliderSpeakerVol
	static lv_style_t style_screAudio_sliderSpeakerVol_bg;
	lv_style_init(&style_screAudio_sliderSpeakerVol_bg);

	//Write style state: LV_STATE_DEFAULT for style_screAudio_sliderSpeakerVol_bg
	lv_style_set_radius(&style_screAudio_sliderSpeakerVol_bg, LV_STATE_DEFAULT, 50);
	lv_style_set_bg_color(&style_screAudio_sliderSpeakerVol_bg, LV_STATE_DEFAULT, lv_color_make(0xde, 0xde, 0xde));
	lv_style_set_bg_grad_color(&style_screAudio_sliderSpeakerVol_bg, LV_STATE_DEFAULT, lv_color_make(0xde, 0xde, 0xde));
	lv_style_set_bg_grad_dir(&style_screAudio_sliderSpeakerVol_bg, LV_STATE_DEFAULT, LV_GRAD_DIR_HOR);
	lv_style_set_bg_opa(&style_screAudio_sliderSpeakerVol_bg, LV_STATE_DEFAULT, 255);
	lv_style_set_outline_color(&style_screAudio_sliderSpeakerVol_bg, LV_STATE_DEFAULT, lv_color_make(0xd4, 0xd7, 0xd9));
	lv_style_set_outline_opa(&style_screAudio_sliderSpeakerVol_bg, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screAudio_sliderSpeakerVol_bg, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screAudio_sliderSpeakerVol_bg, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screAudio_sliderSpeakerVol_bg, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screAudio_sliderSpeakerVol_bg, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screAudio_sliderSpeakerVol, LV_SLIDER_PART_BG, &style_screAudio_sliderSpeakerVol_bg);

	//Write style LV_SLIDER_PART_KNOB for screAudio_sliderSpeakerVol
	static lv_style_t style_screAudio_sliderSpeakerVol_knob;
	lv_style_init(&style_screAudio_sliderSpeakerVol_knob);

	//Write style state: LV_STATE_DEFAULT for style_screAudio_sliderSpeakerVol_knob
	lv_style_set_radius(&style_screAudio_sliderSpeakerVol_knob, LV_STATE_DEFAULT, 50);
	lv_style_set_bg_color(&style_screAudio_sliderSpeakerVol_knob, LV_STATE_DEFAULT, lv_color_make(0xf5, 0xf5, 0xf5));
	lv_style_set_bg_grad_color(&style_screAudio_sliderSpeakerVol_knob, LV_STATE_DEFAULT, lv_color_make(0xf5, 0xf5, 0xf5));
	lv_style_set_bg_grad_dir(&style_screAudio_sliderSpeakerVol_knob, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screAudio_sliderSpeakerVol_knob, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screAudio_sliderSpeakerVol, LV_SLIDER_PART_KNOB, &style_screAudio_sliderSpeakerVol_knob);
	lv_obj_set_pos(ui->screAudio_sliderSpeakerVol, 60, 253);
	lv_obj_set_size(ui->screAudio_sliderSpeakerVol, 122, 7);
	lv_slider_set_range(ui->screAudio_sliderSpeakerVol,0, 100);
	lv_slider_set_value(ui->screAudio_sliderSpeakerVol,30,false);

	//Write codes screAudio_imgSpeaker
	ui->screAudio_imgSpeaker = lv_img_create(ui->screAudio, NULL);

	//Write style LV_IMG_PART_MAIN for screAudio_imgSpeaker
	static lv_style_t style_screAudio_imgSpeaker_main;
	lv_style_init(&style_screAudio_imgSpeaker_main);

	//Write style state: LV_STATE_DEFAULT for style_screAudio_imgSpeaker_main
	lv_style_set_image_recolor(&style_screAudio_imgSpeaker_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screAudio_imgSpeaker_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screAudio_imgSpeaker_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screAudio_imgSpeaker, LV_IMG_PART_MAIN, &style_screAudio_imgSpeaker_main);
	lv_obj_set_pos(ui->screAudio_imgSpeaker, 9, 244);
	lv_obj_set_size(ui->screAudio_imgSpeaker, 20, 20);
	lv_obj_set_click(ui->screAudio_imgSpeaker, true);
	lv_img_set_src(ui->screAudio_imgSpeaker,&_inc_sound_alpha_20x20);
	lv_img_set_pivot(ui->screAudio_imgSpeaker, 0,0);
	lv_img_set_angle(ui->screAudio_imgSpeaker, 0);

	//Write codes screAudio_imgAudioBackground
	ui->screAudio_imgAudioBackground = lv_img_create(ui->screAudio, NULL);

	//Write style LV_IMG_PART_MAIN for screAudio_imgAudioBackground
	static lv_style_t style_screAudio_imgAudioBackground_main;
	lv_style_init(&style_screAudio_imgAudioBackground_main);

	//Write style state: LV_STATE_DEFAULT for style_screAudio_imgAudioBackground_main
	lv_style_set_image_recolor(&style_screAudio_imgAudioBackground_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screAudio_imgAudioBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screAudio_imgAudioBackground_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screAudio_imgAudioBackground, LV_IMG_PART_MAIN, &style_screAudio_imgAudioBackground_main);
	lv_obj_set_pos(ui->screAudio_imgAudioBackground, 176, 95);
	lv_obj_set_size(ui->screAudio_imgAudioBackground, 120, 120);
	lv_obj_set_click(ui->screAudio_imgAudioBackground, true);
	lv_img_set_src(ui->screAudio_imgAudioBackground,&_img_album_1_big_alpha_120x120);
	lv_img_set_pivot(ui->screAudio_imgAudioBackground, 60,60);
	lv_img_set_angle(ui->screAudio_imgAudioBackground, 0);

	//Write codes screAudio_imgbtnAudioPlay
	ui->screAudio_imgbtnAudioPlay = lv_imgbtn_create(ui->screAudio, NULL);

	//Write style LV_IMGBTN_PART_MAIN for screAudio_imgbtnAudioPlay
	static lv_style_t style_screAudio_imgbtnAudioPlay_main;
	lv_style_init(&style_screAudio_imgbtnAudioPlay_main);

	//Write style state: LV_STATE_DEFAULT for style_screAudio_imgbtnAudioPlay_main
	lv_style_set_text_color(&style_screAudio_imgbtnAudioPlay_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_image_recolor(&style_screAudio_imgbtnAudioPlay_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screAudio_imgbtnAudioPlay_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screAudio_imgbtnAudioPlay_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screAudio_imgbtnAudioPlay, LV_IMGBTN_PART_MAIN, &style_screAudio_imgbtnAudioPlay_main);
	lv_obj_set_pos(ui->screAudio_imgbtnAudioPlay, 217, 133);
	lv_obj_set_size(ui->screAudio_imgbtnAudioPlay, 48, 48);
	lv_imgbtn_set_src(ui->screAudio_imgbtnAudioPlay,LV_BTN_STATE_RELEASED,&_btn_play_alpha_48x48);

	//Write codes screAudio_labelSongname
	ui->screAudio_labelSongname = lv_label_create(ui->screAudio, NULL);
	lv_label_set_text(ui->screAudio_labelSongname, "Forever young (dance mix)");
	lv_label_set_long_mode(ui->screAudio_labelSongname, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screAudio_labelSongname, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screAudio_labelSongname
	static lv_style_t style_screAudio_labelSongname_main;
	lv_style_init(&style_screAudio_labelSongname_main);

	//Write style state: LV_STATE_DEFAULT for style_screAudio_labelSongname_main
	lv_style_set_radius(&style_screAudio_labelSongname_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screAudio_labelSongname_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_bg_grad_color(&style_screAudio_labelSongname_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_bg_grad_dir(&style_screAudio_labelSongname_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screAudio_labelSongname_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screAudio_labelSongname_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_font(&style_screAudio_labelSongname_main, LV_STATE_DEFAULT, &lv_font_simsun_16);
	lv_style_set_text_letter_space(&style_screAudio_labelSongname_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screAudio_labelSongname_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screAudio_labelSongname_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screAudio_labelSongname_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screAudio_labelSongname_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screAudio_labelSongname, LV_LABEL_PART_MAIN, &style_screAudio_labelSongname_main);
	lv_obj_set_pos(ui->screAudio_labelSongname, 134, 47);
	lv_obj_set_size(ui->screAudio_labelSongname, 220, 0);

	//Write codes screAudio_imgAudioBackground_1
	ui->screAudio_imgAudioBackground_1 = lv_img_create(ui->screAudio, NULL);

	//Write style LV_IMG_PART_MAIN for screAudio_imgAudioBackground_1
	static lv_style_t style_screAudio_imgAudioBackground_1_main;
	lv_style_init(&style_screAudio_imgAudioBackground_1_main);

	//Write style state: LV_STATE_DEFAULT for style_screAudio_imgAudioBackground_1_main
	lv_style_set_image_recolor(&style_screAudio_imgAudioBackground_1_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screAudio_imgAudioBackground_1_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screAudio_imgAudioBackground_1_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screAudio_imgAudioBackground_1, LV_IMG_PART_MAIN, &style_screAudio_imgAudioBackground_1_main);
	lv_obj_set_pos(ui->screAudio_imgAudioBackground_1, 480, 94);
	lv_obj_set_size(ui->screAudio_imgAudioBackground_1, 120, 120);
	lv_obj_set_click(ui->screAudio_imgAudioBackground_1, true);
	lv_img_set_src(ui->screAudio_imgAudioBackground_1,&_album2_alpha_120x120);
	lv_img_set_pivot(ui->screAudio_imgAudioBackground_1, 60,60);
	lv_img_set_angle(ui->screAudio_imgAudioBackground_1, 0);

	//Write codes screAudio_imgAudioBackground_2
	ui->screAudio_imgAudioBackground_2 = lv_img_create(ui->screAudio, NULL);

	//Write style LV_IMG_PART_MAIN for screAudio_imgAudioBackground_2
	static lv_style_t style_screAudio_imgAudioBackground_2_main;
	lv_style_init(&style_screAudio_imgAudioBackground_2_main);

	//Write style state: LV_STATE_DEFAULT for style_screAudio_imgAudioBackground_2_main
	lv_style_set_image_recolor(&style_screAudio_imgAudioBackground_2_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screAudio_imgAudioBackground_2_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screAudio_imgAudioBackground_2_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screAudio_imgAudioBackground_2, LV_IMG_PART_MAIN, &style_screAudio_imgAudioBackground_2_main);
	lv_obj_set_pos(ui->screAudio_imgAudioBackground_2, 480, 124);
	lv_obj_set_size(ui->screAudio_imgAudioBackground_2, 120, 120);
	lv_obj_set_click(ui->screAudio_imgAudioBackground_2, true);
	lv_img_set_src(ui->screAudio_imgAudioBackground_2,&_gutar_alpha_120x120);
	lv_img_set_pivot(ui->screAudio_imgAudioBackground_2, 60,60);
	lv_img_set_angle(ui->screAudio_imgAudioBackground_2, 0);

	//Write codes screAudio_imgbtnAudioPause
	ui->screAudio_imgbtnAudioPause = lv_imgbtn_create(ui->screAudio, NULL);

	//Write style LV_IMGBTN_PART_MAIN for screAudio_imgbtnAudioPause
	static lv_style_t style_screAudio_imgbtnAudioPause_main;
	lv_style_init(&style_screAudio_imgbtnAudioPause_main);

	//Write style state: LV_STATE_DEFAULT for style_screAudio_imgbtnAudioPause_main
	lv_style_set_text_color(&style_screAudio_imgbtnAudioPause_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_image_recolor(&style_screAudio_imgbtnAudioPause_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screAudio_imgbtnAudioPause_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screAudio_imgbtnAudioPause_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screAudio_imgbtnAudioPause, LV_IMGBTN_PART_MAIN, &style_screAudio_imgbtnAudioPause_main);
	lv_obj_set_pos(ui->screAudio_imgbtnAudioPause, 480, 40);
	lv_obj_set_size(ui->screAudio_imgbtnAudioPause, 48, 48);
	lv_imgbtn_set_src(ui->screAudio_imgbtnAudioPause,LV_BTN_STATE_RELEASED,&_pause_alpha_48x48);

	//Init events for screen
	events_init_screAudio(ui);
}