#include "lvgl/lvgl.h"

/*******************************************************************************
 * Size: 18 px
 * Bpp: 4
 * Opts: 
 ******************************************************************************/

#ifndef LV_FONT_SIMSUN_18
#define LV_FONT_SIMSUN_18 1
#endif

#if LV_FONT_SIMSUN_18

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t gylph_bitmap[] = {
    /* U+20 " " */

    /* U+21 "!" */
    0x2e, 0x15, 0xf2, 0x4f, 0x12, 0xf0, 0xe, 0x0,
    0xd0, 0xb, 0x0, 0x90, 0x1, 0x0, 0x0, 0x4d,
    0x35, 0xf3,

    /* U+22 "\"" */
    0x0, 0xb9, 0x1d, 0x50, 0x6f, 0x49, 0xe2, 0xd,
    0x42, 0xd2, 0x7, 0x30, 0x82, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+23 "#" */
    0x0, 0x54, 0x0, 0x72, 0x0, 0x6, 0x30, 0x9,
    0x10, 0x0, 0x82, 0x0, 0xa0, 0x5, 0xff, 0xff,
    0xff, 0xf4, 0x13, 0xb3, 0x33, 0xb3, 0x10, 0xa,
    0x0, 0xa, 0x0, 0x0, 0xa0, 0x0, 0xa0, 0x0,
    0xa, 0x0, 0x19, 0x0, 0x5f, 0xff, 0xff, 0xff,
    0x41, 0x4a, 0x33, 0x69, 0x31, 0x2, 0x80, 0x4,
    0x50, 0x0, 0x36, 0x0, 0x54, 0x0,

    /* U+24 "$" */
    0x0, 0xa, 0x0, 0x0, 0x38, 0xd8, 0x60, 0x1c,
    0xa, 0xd, 0x36, 0xa0, 0xa1, 0xf4, 0x4e, 0x1a,
    0x3, 0x0, 0xcd, 0xb0, 0x0, 0x0, 0xaf, 0x70,
    0x0, 0x0, 0xcf, 0x70, 0x0, 0xa, 0x4f, 0x23,
    0x50, 0xa0, 0xb7, 0xbc, 0xa, 0x9, 0x67, 0x80,
    0xa0, 0xb1, 0x7, 0x7d, 0x83, 0x0, 0x0, 0xa0,
    0x0, 0x0, 0xa, 0x0, 0x0,

    /* U+25 "%" */
    0x9, 0x82, 0x0, 0x60, 0x7, 0x40, 0xb0, 0x8,
    0x0, 0xb2, 0xd, 0x6, 0x20, 0xc, 0x20, 0xe0,
    0x90, 0x0, 0xa2, 0xd, 0x44, 0x0, 0x6, 0x62,
    0xa8, 0x0, 0x0, 0x6, 0x73, 0x62, 0x75, 0x0,
    0x0, 0x70, 0xc0, 0x83, 0x0, 0x7, 0x2b, 0x5,
    0x70, 0x6, 0x22, 0xb0, 0x58, 0x0, 0x80, 0xc,
    0x7, 0x50, 0x34, 0x0, 0x58, 0x90,

    /* U+26 "&" */
    0x0, 0x76, 0xa0, 0x0, 0x0, 0x39, 0x8, 0x60,
    0x0, 0x6, 0x80, 0x86, 0x0, 0x0, 0x59, 0xc,
    0x20, 0x0, 0x3, 0xe6, 0x70, 0x0, 0x0, 0x2f,
    0x60, 0x6b, 0x70, 0x1a, 0x8a, 0x0, 0xc0, 0x8,
    0x61, 0xf2, 0x9, 0x0, 0xb4, 0x9, 0xb3, 0x50,
    0xb, 0x60, 0x1e, 0xd1, 0x0, 0x5c, 0x0, 0x7f,
    0x40, 0x50, 0x7d, 0xa6, 0x3d, 0xb2,

    /* U+27 "'" */
    0x8, 0xe2, 0x5, 0xf6, 0x0, 0xb2, 0x6, 0x70,
    0x2, 0x0,

    /* U+28 "(" */
    0x0, 0x0, 0x80, 0x0, 0x8, 0x30, 0x0, 0x58,
    0x0, 0x1, 0xd0, 0x0, 0x6, 0x80, 0x0, 0xc,
    0x30, 0x0, 0xf, 0x0, 0x0, 0x1f, 0x0, 0x0,
    0xf, 0x0, 0x0, 0xe, 0x10, 0x0, 0xa, 0x50,
    0x0, 0x4, 0xa0, 0x0, 0x0, 0xb3, 0x0, 0x0,
    0x1b, 0x0, 0x0, 0x3, 0x80, 0x0, 0x0, 0x30,

    /* U+29 ")" */
    0x8, 0x0, 0x0, 0x4, 0x80, 0x0, 0x0, 0x94,
    0x0, 0x0, 0x1c, 0x0, 0x0, 0x9, 0x50, 0x0,
    0x4, 0xb0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0xf0,
    0x0, 0x0, 0xf0, 0x0, 0x2, 0xd0, 0x0, 0x6,
    0x90, 0x0, 0xb, 0x30, 0x0, 0x4a, 0x0, 0x0,
    0xb1, 0x0, 0x9, 0x20, 0x0, 0x2, 0x0, 0x0,

    /* U+2A "*" */
    0x0, 0x1, 0xe1, 0x0, 0x0, 0x0, 0x1f, 0x10,
    0x0, 0x3e, 0x50, 0xd0, 0x5e, 0x20, 0x7d, 0x78,
    0x8d, 0x70, 0x0, 0x7, 0xc6, 0x0, 0x0, 0x7d,
    0x78, 0x8d, 0x70, 0x4e, 0x50, 0xd0, 0x5e, 0x30,
    0x0, 0x2f, 0x0, 0x0, 0x0, 0x2, 0xe0, 0x0,
    0x0,

    /* U+2B "+" */
    0x0, 0x0, 0x70, 0x0, 0x0, 0x0, 0xa, 0x0,
    0x0, 0x0, 0x0, 0xa0, 0x0, 0x0, 0x0, 0xa,
    0x0, 0x0, 0x29, 0x99, 0xd9, 0x99, 0x40, 0x0,
    0xa, 0x0, 0x0, 0x0, 0x0, 0xa0, 0x0, 0x0,
    0x0, 0xa, 0x0, 0x0, 0x0, 0x0, 0x70, 0x0,
    0x0,

    /* U+2D "-" */
    0x49, 0x99, 0x99, 0x99, 0x30,

    /* U+2E "." */
    0x0, 0x9, 0xf2, 0x9e, 0x20,

    /* U+2F "/" */
    0x0, 0x0, 0x0, 0x2, 0x10, 0x0, 0x0, 0x0,
    0x90, 0x0, 0x0, 0x0, 0x27, 0x0, 0x0, 0x0,
    0x9, 0x0, 0x0, 0x0, 0x2, 0x70, 0x0, 0x0,
    0x0, 0x90, 0x0, 0x0, 0x0, 0x27, 0x0, 0x0,
    0x0, 0x9, 0x0, 0x0, 0x0, 0x2, 0x70, 0x0,
    0x0, 0x0, 0x80, 0x0, 0x0, 0x0, 0x27, 0x0,
    0x0, 0x0, 0x8, 0x0, 0x0, 0x0, 0x2, 0x70,
    0x0, 0x0, 0x0, 0x81, 0x0, 0x0, 0x0, 0x27,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+30 "0" */
    0x0, 0x3b, 0x8a, 0x20, 0x0, 0x1e, 0x20, 0x1d,
    0x10, 0x8, 0xb0, 0x0, 0xb8, 0x0, 0xe6, 0x0,
    0x7, 0xd0, 0xf, 0x40, 0x0, 0x5f, 0x2, 0xf3,
    0x0, 0x4, 0xf1, 0x2f, 0x30, 0x0, 0x4f, 0x10,
    0xf4, 0x0, 0x5, 0xf0, 0xe, 0x60, 0x0, 0x7c,
    0x0, 0x9a, 0x0, 0xa, 0x70, 0x1, 0xe2, 0x2,
    0xd1, 0x0, 0x3, 0xa8, 0xa2, 0x0,

    /* U+31 "1" */
    0x0, 0x72, 0x0, 0x6a, 0xf2, 0x0, 0x0, 0xf2,
    0x0, 0x0, 0xf2, 0x0, 0x0, 0xf2, 0x0, 0x0,
    0xf2, 0x0, 0x0, 0xf2, 0x0, 0x0, 0xf2, 0x0,
    0x0, 0xf2, 0x0, 0x0, 0xf2, 0x0, 0x0, 0xf2,
    0x0, 0x6a, 0xfb, 0x61,

    /* U+32 "2" */
    0x0, 0x67, 0x7a, 0x60, 0x7, 0x70, 0x0, 0xd5,
    0xd, 0x60, 0x0, 0x8a, 0xb, 0x90, 0x0, 0x8a,
    0x0, 0x0, 0x0, 0xc5, 0x0, 0x0, 0x5, 0xb0,
    0x0, 0x0, 0x3b, 0x0, 0x0, 0x2, 0xa0, 0x0,
    0x0, 0x1a, 0x0, 0x0, 0x0, 0xa0, 0x0, 0x7,
    0x9, 0x20, 0x0, 0x4a, 0x1f, 0xff, 0xff, 0xf8,

    /* U+33 "3" */
    0x7, 0x78, 0xa3, 0x7, 0x70, 0x3, 0xe1, 0xa9,
    0x0, 0xd, 0x50, 0x10, 0x0, 0xe3, 0x0, 0x0,
    0x7a, 0x0, 0x4, 0xbb, 0x0, 0x0, 0x0, 0x3c,
    0x10, 0x0, 0x0, 0x99, 0x21, 0x0, 0x6, 0xdd,
    0x90, 0x0, 0x8b, 0xa7, 0x0, 0xd, 0x30, 0x87,
    0x79, 0x40,

    /* U+34 "4" */
    0x0, 0x0, 0x8, 0x70, 0x0, 0x0, 0x2, 0xf7,
    0x0, 0x0, 0x0, 0x9a, 0x70, 0x0, 0x0, 0x63,
    0xa7, 0x0, 0x0, 0x18, 0xa, 0x70, 0x0, 0x8,
    0x10, 0xa7, 0x0, 0x3, 0x50, 0xa, 0x70, 0x0,
    0x90, 0x0, 0xa7, 0x0, 0x38, 0x66, 0x6c, 0xa6,
    0x20, 0x0, 0x0, 0xa7, 0x0, 0x0, 0x0, 0xa,
    0x70, 0x0, 0x0, 0x37, 0xed, 0x71,

    /* U+35 "5" */
    0x2f, 0xff, 0xff, 0x92, 0x50, 0x0, 0x0, 0x34,
    0x0, 0x0, 0x4, 0x30, 0x0, 0x0, 0x55, 0x9a,
    0xd6, 0x6, 0x90, 0x1, 0xe4, 0x10, 0x0, 0x8,
    0xa0, 0x0, 0x0, 0x5d, 0x64, 0x0, 0x5, 0xcd,
    0x80, 0x0, 0x89, 0x95, 0x0, 0xd, 0x20, 0x67,
    0x7a, 0x50,

    /* U+36 "6" */
    0x0, 0x7, 0x78, 0xa0, 0x0, 0xb, 0x20, 0xf,
    0x50, 0x6, 0x80, 0x0, 0x10, 0x0, 0xc5, 0x0,
    0x0, 0x0, 0xf, 0x49, 0xac, 0x90, 0x1, 0xfb,
    0x20, 0xb, 0x70, 0x2f, 0x60, 0x0, 0x4e, 0x1,
    0xf3, 0x0, 0x2, 0xf0, 0xf, 0x50, 0x0, 0x2f,
    0x0, 0xb9, 0x0, 0x4, 0xd0, 0x3, 0xe1, 0x0,
    0x96, 0x0, 0x4, 0xb7, 0x86, 0x0,

    /* U+37 "7" */
    0x7f, 0xff, 0xff, 0xda, 0x50, 0x0, 0x45, 0x70,
    0x0, 0xa, 0x0, 0x0, 0x6, 0x50, 0x0, 0x0,
    0xb0, 0x0, 0x0, 0x57, 0x0, 0x0, 0xc, 0x20,
    0x0, 0x2, 0xe0, 0x0, 0x0, 0x7c, 0x0, 0x0,
    0xa, 0xb0, 0x0, 0x0, 0xcc, 0x0, 0x0, 0xa,
    0xa0, 0x0,

    /* U+38 "8" */
    0x0, 0x78, 0x78, 0x60, 0x8, 0x60, 0x0, 0x96,
    0xd, 0x10, 0x0, 0x3b, 0xd, 0x60, 0x0, 0x4a,
    0x5, 0xf7, 0x0, 0xb2, 0x0, 0x5f, 0xec, 0x20,
    0x2, 0xa1, 0x6e, 0xb0, 0xd, 0x20, 0x1, 0xd9,
    0x2d, 0x0, 0x0, 0x4e, 0x2d, 0x0, 0x0, 0x2d,
    0xb, 0x40, 0x0, 0x86, 0x0, 0x78, 0x78, 0x60,

    /* U+39 "9" */
    0x0, 0x89, 0x79, 0x30, 0x0, 0x79, 0x0, 0xd,
    0x20, 0xf, 0x20, 0x0, 0x89, 0x2, 0xf0, 0x0,
    0x6, 0xd0, 0x3f, 0x0, 0x0, 0x5f, 0x0, 0xf3,
    0x0, 0xa, 0xf0, 0xa, 0xb0, 0x6, 0xaf, 0x0,
    0x7, 0xa9, 0x47, 0xc0, 0x0, 0x0, 0x0, 0xa8,
    0x0, 0x1, 0x0, 0xe, 0x20, 0x8, 0xd0, 0x7,
    0x90, 0x0, 0x2c, 0x78, 0x70, 0x0,

    /* U+3A ":" */
    0x6e, 0x25, 0xd2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5d, 0x26, 0xf2,

    /* U+3B ";" */
    0x6f, 0x33, 0x71, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x38, 0x16, 0xf3, 0xc, 0x3, 0x80,

    /* U+3C "<" */
    0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x66, 0x0,
    0x0, 0x76, 0x0, 0x0, 0x75, 0x0, 0x0, 0x85,
    0x0, 0x0, 0x84, 0x0, 0x0, 0x84, 0x0, 0x0,
    0x3, 0x90, 0x0, 0x0, 0x2, 0xa0, 0x0, 0x0,
    0x2, 0xa0, 0x0, 0x0, 0x2, 0xa1, 0x0, 0x0,
    0x1, 0xa1, 0x0, 0x0, 0x1, 0x60,

    /* U+3D "=" */
    0x49, 0x99, 0x99, 0x99, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x99, 0x99,
    0x99, 0x93,

    /* U+3E ">" */
    0x10, 0x0, 0x0, 0x6, 0x60, 0x0, 0x0, 0x6,
    0x70, 0x0, 0x0, 0x5, 0x70, 0x0, 0x0, 0x5,
    0x80, 0x0, 0x0, 0x4, 0x80, 0x0, 0x0, 0x4,
    0x80, 0x0, 0x0, 0x93, 0x0, 0x0, 0xa2, 0x0,
    0x0, 0xa2, 0x0, 0x0, 0xa2, 0x0, 0x1, 0xa1,
    0x0, 0x0, 0x61, 0x0, 0x0, 0x0,

    /* U+3F "?" */
    0x0, 0x59, 0x9a, 0x70, 0x0, 0x74, 0x0, 0xa,
    0x90, 0xc, 0x0, 0x0, 0x4f, 0x0, 0xf8, 0x0,
    0x3, 0xf0, 0x4, 0x20, 0x0, 0x9c, 0x0, 0x0,
    0x0, 0xab, 0x10, 0x0, 0x0, 0xa5, 0x0, 0x0,
    0x0, 0x9, 0x0, 0x0, 0x0, 0x0, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xd2,
    0x0, 0x0, 0x0, 0x6f, 0x20, 0x0,

    /* U+40 "@" */
    0x0, 0x18, 0x78, 0x80, 0x0, 0xb, 0x10, 0x1,
    0x90, 0x8, 0x40, 0x47, 0xa6, 0x20, 0xd0, 0x29,
    0xd, 0x26, 0x2c, 0xa, 0x22, 0xb1, 0x84, 0xb0,
    0xd0, 0x49, 0x18, 0x4b, 0x3b, 0x6, 0x72, 0x72,
    0xc4, 0xa0, 0x94, 0x54, 0xd, 0x3a, 0x1d, 0x39,
    0x0, 0x93, 0x87, 0x3a, 0x31, 0x1, 0xb0, 0x0,
    0x8, 0x10, 0x2, 0x98, 0x88, 0x10,

    /* U+41 "A" */
    0x0, 0x1, 0xa0, 0x0, 0x0, 0x0, 0x6f, 0x40,
    0x0, 0x0, 0x9, 0x98, 0x0, 0x0, 0x0, 0x95,
    0xc0, 0x0, 0x0, 0x36, 0x1f, 0x0, 0x0, 0x7,
    0x20, 0xd4, 0x0, 0x0, 0x90, 0x9, 0x80, 0x0,
    0xb, 0x66, 0x9c, 0x0, 0x4, 0x50, 0x1, 0xf0,
    0x0, 0x81, 0x0, 0xd, 0x40, 0xa, 0x0, 0x0,
    0xa8, 0x7, 0xf5, 0x0, 0x2c, 0xe4,

    /* U+42 "B" */
    0x3c, 0xd6, 0x7a, 0x90, 0x0, 0x89, 0x0, 0xb,
    0x80, 0x8, 0x90, 0x0, 0x7c, 0x0, 0x89, 0x0,
    0x8, 0xb0, 0x8, 0x90, 0x1, 0xd3, 0x0, 0x8c,
    0x67, 0xd4, 0x0, 0x8, 0x90, 0x0, 0xb7, 0x0,
    0x89, 0x0, 0x2, 0xf1, 0x8, 0x90, 0x0, 0xf,
    0x50, 0x89, 0x0, 0x1, 0xf4, 0x8, 0x90, 0x0,
    0x7d, 0x4, 0xcd, 0x66, 0x8a, 0x10,

    /* U+43 "C" */
    0x0, 0x19, 0x78, 0xed, 0x0, 0x1d, 0x20, 0x1,
    0xd0, 0xa, 0x80, 0x0, 0x5, 0x41, 0xf3, 0x0,
    0x0, 0x0, 0x4f, 0x0, 0x0, 0x0, 0x6, 0xf0,
    0x0, 0x0, 0x0, 0x6e, 0x0, 0x0, 0x0, 0x5,
    0xf0, 0x0, 0x0, 0x0, 0x2f, 0x20, 0x0, 0x1,
    0x20, 0xd6, 0x0, 0x0, 0x61, 0x4, 0xe1, 0x0,
    0x37, 0x0, 0x4, 0xba, 0x97, 0x0,

    /* U+44 "D" */
    0x3c, 0xd7, 0x79, 0x20, 0x0, 0x89, 0x0, 0x2d,
    0x20, 0x8, 0x90, 0x0, 0x7c, 0x0, 0x89, 0x0,
    0x2, 0xf1, 0x8, 0x90, 0x0, 0xf, 0x40, 0x89,
    0x0, 0x0, 0xf5, 0x8, 0x90, 0x0, 0xf, 0x50,
    0x89, 0x0, 0x0, 0xf3, 0x8, 0x90, 0x0, 0x3f,
    0x10, 0x89, 0x0, 0x8, 0xa0, 0x8, 0x90, 0x3,
    0xd2, 0x4, 0xcd, 0x67, 0x91, 0x0,

    /* U+45 "E" */
    0x2c, 0xe6, 0x67, 0xd9, 0x0, 0x7a, 0x0, 0x1,
    0xc0, 0x7, 0xa0, 0x0, 0x4, 0x10, 0x7a, 0x0,
    0x0, 0x0, 0x7, 0xa0, 0x0, 0x70, 0x0, 0x7c,
    0x66, 0xc7, 0x0, 0x7, 0xa0, 0x2, 0x70, 0x0,
    0x7a, 0x0, 0x7, 0x0, 0x7, 0xa0, 0x0, 0x0,
    0x0, 0x7a, 0x0, 0x0, 0x3, 0x7, 0xa0, 0x0,
    0x9, 0x13, 0xce, 0x66, 0x7b, 0xd0,

    /* U+46 "F" */
    0x3c, 0xe6, 0x67, 0xcf, 0x0, 0x7a, 0x0, 0x0,
    0x94, 0x7, 0xa0, 0x0, 0x0, 0x50, 0x7a, 0x0,
    0x0, 0x0, 0x7, 0xa0, 0x0, 0x70, 0x0, 0x7c,
    0x66, 0x9b, 0x0, 0x7, 0xa0, 0x0, 0x90, 0x0,
    0x7a, 0x0, 0x6, 0x0, 0x7, 0xa0, 0x0, 0x0,
    0x0, 0x7a, 0x0, 0x0, 0x0, 0x7, 0xa0, 0x0,
    0x0, 0x3, 0xce, 0x50, 0x0, 0x0,

    /* U+47 "G" */
    0x0, 0x39, 0x7b, 0xf2, 0x0, 0x2c, 0x10, 0x9,
    0x50, 0xb, 0x50, 0x0, 0x17, 0x1, 0xf0, 0x0,
    0x0, 0x0, 0x5d, 0x0, 0x0, 0x0, 0x7, 0xc0,
    0x0, 0x0, 0x0, 0x7c, 0x0, 0x6, 0xaa, 0x45,
    0xe0, 0x0, 0xa, 0x90, 0x2f, 0x10, 0x0, 0x98,
    0x0, 0xc5, 0x0, 0x9, 0x80, 0x4, 0xc0, 0x0,
    0xb8, 0x0, 0x5, 0xa7, 0x75, 0x10,

    /* U+48 "H" */
    0x4e, 0xb2, 0x2, 0xce, 0x30, 0xb6, 0x0, 0x7,
    0xa0, 0xb, 0x60, 0x0, 0x7a, 0x0, 0xb6, 0x0,
    0x7, 0xa0, 0xb, 0x60, 0x0, 0x7a, 0x0, 0xba,
    0x66, 0x6a, 0xa0, 0xb, 0x60, 0x0, 0x7a, 0x0,
    0xb6, 0x0, 0x7, 0xa0, 0xb, 0x60, 0x0, 0x7a,
    0x0, 0xb6, 0x0, 0x7, 0xa0, 0xb, 0x60, 0x0,
    0x7a, 0x4, 0xeb, 0x20, 0x2c, 0xe4,

    /* U+49 "I" */
    0x26, 0x8f, 0x86, 0x20, 0x1, 0xf1, 0x0, 0x0,
    0x1f, 0x10, 0x0, 0x1, 0xf1, 0x0, 0x0, 0x1f,
    0x10, 0x0, 0x1, 0xf1, 0x0, 0x0, 0x1f, 0x10,
    0x0, 0x1, 0xf1, 0x0, 0x0, 0x1f, 0x10, 0x0,
    0x1, 0xf1, 0x0, 0x0, 0x1f, 0x10, 0x2, 0x68,
    0xf8, 0x62,

    /* U+4A "J" */
    0x0, 0x16, 0x7f, 0xa6, 0x30, 0x0, 0x0, 0xd4,
    0x0, 0x0, 0x0, 0xd, 0x40, 0x0, 0x0, 0x0,
    0xd4, 0x0, 0x0, 0x0, 0xd, 0x40, 0x0, 0x0,
    0x0, 0xd4, 0x0, 0x0, 0x0, 0xd, 0x40, 0x0,
    0x0, 0x0, 0xd4, 0x0, 0x0, 0x0, 0xd, 0x40,
    0x0, 0x0, 0x0, 0xd4, 0x0, 0x0, 0x0, 0xd,
    0x40, 0x0, 0x10, 0x0, 0xe2, 0x0, 0x4f, 0x10,
    0x3b, 0x0, 0x0, 0xb8, 0x68, 0x10, 0x0,

    /* U+4B "K" */
    0x3c, 0xd4, 0x5, 0xfa, 0x10, 0x89, 0x0, 0x38,
    0x0, 0x8, 0x90, 0x9, 0x0, 0x0, 0x89, 0x8,
    0x10, 0x0, 0x8, 0x94, 0x90, 0x0, 0x0, 0x8a,
    0xbe, 0x0, 0x0, 0x8, 0xe1, 0xc7, 0x0, 0x0,
    0x89, 0x4, 0xe0, 0x0, 0x8, 0x90, 0xd, 0x50,
    0x0, 0x89, 0x0, 0x5d, 0x0, 0x8, 0x90, 0x0,
    0xe4, 0x3, 0xcd, 0x40, 0x2d, 0xe4,

    /* U+4C "L" */
    0x2a, 0xf6, 0x0, 0x0, 0x0, 0x5d, 0x0, 0x0,
    0x0, 0x5, 0xd0, 0x0, 0x0, 0x0, 0x5d, 0x0,
    0x0, 0x0, 0x5, 0xd0, 0x0, 0x0, 0x0, 0x5d,
    0x0, 0x0, 0x0, 0x5, 0xd0, 0x0, 0x0, 0x0,
    0x5d, 0x0, 0x0, 0x0, 0x5, 0xd0, 0x0, 0x0,
    0x0, 0x5d, 0x0, 0x0, 0x14, 0x5, 0xd0, 0x0,
    0x9, 0x22, 0xaf, 0x66, 0x7b, 0xe0,

    /* U+4D "M" */
    0x6f, 0x40, 0x0, 0x9f, 0x50, 0xf8, 0x0, 0xc,
    0xe0, 0xb, 0xb0, 0x0, 0xae, 0x0, 0x7e, 0x0,
    0x47, 0xe0, 0x6, 0xd2, 0x7, 0x4e, 0x0, 0x69,
    0x50, 0x74, 0xe0, 0x6, 0x69, 0x7, 0x4e, 0x0,
    0x62, 0xc3, 0x44, 0xe0, 0x6, 0xf, 0x70, 0x4e,
    0x0, 0x60, 0xcb, 0x4, 0xe0, 0x6, 0x8, 0x90,
    0x4e, 0x5, 0xc2, 0x55, 0x1a, 0xf5,

    /* U+4E "N" */
    0x4d, 0x90, 0x0, 0x6c, 0x50, 0x8f, 0x20, 0x0,
    0x60, 0x6, 0x9a, 0x0, 0x6, 0x0, 0x61, 0xf2,
    0x0, 0x60, 0x6, 0x9, 0xa0, 0x6, 0x0, 0x60,
    0x1f, 0x30, 0x60, 0x6, 0x0, 0x8b, 0x6, 0x0,
    0x60, 0x1, 0xf3, 0x60, 0x6, 0x0, 0x8, 0xb6,
    0x0, 0x60, 0x0, 0x1f, 0xa0, 0x6, 0x0, 0x0,
    0x8a, 0x5, 0xc6, 0x0, 0x1, 0x90,

    /* U+4F "O" */
    0x0, 0x39, 0x78, 0x50, 0x0, 0x2d, 0x0, 0xb,
    0x40, 0xb, 0x60, 0x0, 0x4d, 0x1, 0xf2, 0x0,
    0x0, 0xf2, 0x4f, 0x0, 0x0, 0xe, 0x65, 0xf0,
    0x0, 0x0, 0xd7, 0x5f, 0x0, 0x0, 0xd, 0x73,
    0xf0, 0x0, 0x0, 0xe6, 0xf, 0x20, 0x0, 0xf,
    0x30, 0xa6, 0x0, 0x3, 0xd0, 0x2, 0xc0, 0x0,
    0xa4, 0x0, 0x2, 0x86, 0x85, 0x0,

    /* U+50 "P" */
    0x3c, 0xe6, 0x67, 0x81, 0x0, 0x7a, 0x0, 0x5,
    0xb0, 0x7, 0xa0, 0x0, 0xf, 0x20, 0x7a, 0x0,
    0x0, 0xe4, 0x7, 0xa0, 0x0, 0x1f, 0x10, 0x7a,
    0x0, 0xa, 0x80, 0x7, 0xc6, 0x68, 0x40, 0x0,
    0x7a, 0x0, 0x0, 0x0, 0x7, 0xa0, 0x0, 0x0,
    0x0, 0x7a, 0x0, 0x0, 0x0, 0x7, 0xa0, 0x0,
    0x0, 0x3, 0xce, 0x50, 0x0, 0x0,

    /* U+51 "Q" */
    0x0, 0x59, 0x78, 0x40, 0x0, 0x4c, 0x0, 0xb,
    0x40, 0xd, 0x50, 0x0, 0x4d, 0x2, 0xf1, 0x0,
    0x1, 0xf2, 0x5f, 0x0, 0x0, 0xf, 0x56, 0xe0,
    0x0, 0x0, 0xe6, 0x6e, 0x0, 0x0, 0xe, 0x65,
    0xf0, 0x0, 0x0, 0xf5, 0x2f, 0x3a, 0xb1, 0xf,
    0x30, 0xdd, 0x15, 0xa4, 0xe0, 0x5, 0xe0, 0xf,
    0xc5, 0x0, 0x4, 0x97, 0xea, 0x0, 0x0, 0x0,
    0x4, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+52 "R" */
    0x2b, 0xe6, 0x79, 0x91, 0x0, 0x6c, 0x0, 0x9,
    0xa0, 0x6, 0xc0, 0x0, 0x4e, 0x0, 0x6c, 0x0,
    0x5, 0xd0, 0x6, 0xc0, 0x1, 0xc5, 0x0, 0x6d,
    0x69, 0xb3, 0x0, 0x6, 0xc0, 0x5c, 0x0, 0x0,
    0x6c, 0x0, 0xf2, 0x0, 0x6, 0xc0, 0x9, 0x80,
    0x0, 0x6c, 0x0, 0x3e, 0x0, 0x6, 0xc0, 0x0,
    0xd4, 0x2, 0xbe, 0x50, 0x7, 0xd4,

    /* U+53 "S" */
    0x0, 0x77, 0x8c, 0xf4, 0x9, 0x20, 0x0, 0x96,
    0xd, 0x0, 0x0, 0x4, 0xe, 0x10, 0x0, 0x0,
    0x9, 0xd5, 0x0, 0x0, 0x0, 0x6e, 0xd5, 0x0,
    0x0, 0x0, 0x6e, 0xb0, 0x0, 0x0, 0x0, 0xb9,
    0x1, 0x0, 0x0, 0x2e, 0x18, 0x0, 0x0, 0x1d,
    0xe, 0x30, 0x0, 0x76, 0xb, 0xfa, 0x77, 0x60,

    /* U+54 "T" */
    0xe, 0x99, 0xf8, 0x9e, 0x3, 0x70, 0x2f, 0x0,
    0x82, 0x40, 0x2, 0xf0, 0x1, 0x30, 0x0, 0x2f,
    0x0, 0x0, 0x0, 0x2, 0xf0, 0x0, 0x0, 0x0,
    0x2f, 0x0, 0x0, 0x0, 0x2, 0xf0, 0x0, 0x0,
    0x0, 0x2f, 0x0, 0x0, 0x0, 0x2, 0xf0, 0x0,
    0x0, 0x0, 0x2f, 0x0, 0x0, 0x0, 0x2, 0xf0,
    0x0, 0x0, 0x2, 0x9f, 0x71, 0x0,

    /* U+55 "U" */
    0x4e, 0xb2, 0x0, 0x6c, 0x30, 0xb6, 0x0, 0x0,
    0x60, 0xb, 0x60, 0x0, 0x6, 0x0, 0xb6, 0x0,
    0x0, 0x60, 0xb, 0x60, 0x0, 0x6, 0x0, 0xb6,
    0x0, 0x0, 0x60, 0xb, 0x60, 0x0, 0x6, 0x0,
    0xb6, 0x0, 0x0, 0x60, 0xb, 0x60, 0x0, 0x6,
    0x0, 0xa7, 0x0, 0x0, 0x60, 0x5, 0xb0, 0x0,
    0x62, 0x0, 0x6, 0x98, 0x83, 0x0,

    /* U+56 "V" */
    0x5e, 0xc2, 0x0, 0x9d, 0x30, 0x99, 0x0, 0x4,
    0x40, 0x5, 0xd0, 0x0, 0x80, 0x0, 0x1f, 0x10,
    0x8, 0x0, 0x0, 0xd5, 0x1, 0x70, 0x0, 0x9,
    0x90, 0x53, 0x0, 0x0, 0x5c, 0x8, 0x0, 0x0,
    0x1, 0xf0, 0x80, 0x0, 0x0, 0xd, 0x66, 0x0,
    0x0, 0x0, 0x9e, 0x10, 0x0, 0x0, 0x5, 0xd0,
    0x0, 0x0, 0x0, 0x19, 0x0, 0x0,

    /* U+57 "W" */
    0x8f, 0x44, 0xf6, 0x1c, 0x71, 0xe0, 0xd, 0x20,
    0x70, 0xe, 0x0, 0xb4, 0x7, 0x0, 0xc3, 0xd,
    0x60, 0x70, 0x9, 0x50, 0xe8, 0x6, 0x0, 0x77,
    0x38, 0xb3, 0x30, 0x4, 0xa7, 0x2d, 0x61, 0x0,
    0x2c, 0x80, 0xf7, 0x0, 0x0, 0xe8, 0xd, 0x90,
    0x0, 0xd, 0x70, 0xa8, 0x0, 0x0, 0xb4, 0x8,
    0x60, 0x0, 0x8, 0x0, 0x53, 0x0,

    /* U+58 "X" */
    0x1b, 0xf4, 0x2, 0xca, 0x10, 0x1f, 0x10, 0x9,
    0x0, 0x0, 0x98, 0x3, 0x50, 0x0, 0x2, 0xe0,
    0x80, 0x0, 0x0, 0xa, 0x96, 0x0, 0x0, 0x0,
    0x3f, 0x0, 0x0, 0x0, 0x1, 0xf5, 0x0, 0x0,
    0x0, 0x86, 0xd0, 0x0, 0x0, 0x18, 0xd, 0x40,
    0x0, 0x7, 0x10, 0x6c, 0x0, 0x0, 0x80, 0x0,
    0xe3, 0x3, 0xcb, 0x10, 0x2d, 0xd4,

    /* U+59 "Y" */
    0x4e, 0xc3, 0x1, 0xbd, 0x30, 0x6c, 0x0, 0x6,
    0x20, 0x0, 0xf2, 0x0, 0x80, 0x0, 0x9, 0x70,
    0x25, 0x0, 0x0, 0x3d, 0x7, 0x0, 0x0, 0x0,
    0xd3, 0x70, 0x0, 0x0, 0x7, 0xd2, 0x0, 0x0,
    0x0, 0x2f, 0x0, 0x0, 0x0, 0x2, 0xf0, 0x0,
    0x0, 0x0, 0x2f, 0x0, 0x0, 0x0, 0x2, 0xf0,
    0x0, 0x0, 0x2, 0x9f, 0x71, 0x0,

    /* U+5A "Z" */
    0x5, 0xf9, 0x66, 0x9e, 0x0, 0xa3, 0x0, 0xc,
    0x60, 0x4, 0x0, 0x4, 0xd0, 0x0, 0x0, 0x0,
    0xd5, 0x0, 0x0, 0x0, 0x5d, 0x0, 0x0, 0x0,
    0xd, 0x40, 0x0, 0x0, 0x6, 0xc0, 0x0, 0x0,
    0x0, 0xe3, 0x0, 0x0, 0x0, 0x7b, 0x0, 0x0,
    0x0, 0x1e, 0x20, 0x0, 0x50, 0x8, 0xa0, 0x0,
    0x1b, 0x1, 0xf8, 0x66, 0x7d, 0x80,

    /* U+5B "[" */
    0x6a, 0x99, 0x67, 0x30, 0x0, 0x73, 0x0, 0x7,
    0x30, 0x0, 0x73, 0x0, 0x7, 0x30, 0x0, 0x73,
    0x0, 0x7, 0x30, 0x0, 0x73, 0x0, 0x7, 0x30,
    0x0, 0x73, 0x0, 0x7, 0x30, 0x0, 0x73, 0x0,
    0x7, 0x30, 0x0, 0x6a, 0x99, 0x70,

    /* U+5C "\\" */
    0x76, 0x0, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x0,
    0xa, 0x30, 0x0, 0x0, 0x3, 0xa0, 0x0, 0x0,
    0x0, 0xc1, 0x0, 0x0, 0x0, 0x67, 0x0, 0x0,
    0x0, 0xc, 0x0, 0x0, 0x0, 0x9, 0x40, 0x0,
    0x0, 0x2, 0xa0, 0x0, 0x0, 0x0, 0xb1, 0x0,
    0x0, 0x0, 0x58, 0x0, 0x0, 0x0, 0xc, 0x0,
    0x0, 0x0, 0x8, 0x50, 0x0, 0x0, 0x1, 0xb0,
    0x0, 0x0, 0x0, 0x60,

    /* U+5D "]" */
    0x79, 0x9a, 0x50, 0x0, 0x46, 0x0, 0x4, 0x60,
    0x0, 0x46, 0x0, 0x4, 0x60, 0x0, 0x46, 0x0,
    0x4, 0x60, 0x0, 0x46, 0x0, 0x4, 0x60, 0x0,
    0x46, 0x0, 0x4, 0x60, 0x0, 0x46, 0x0, 0x4,
    0x60, 0x0, 0x46, 0x79, 0x9a, 0x50,

    /* U+5E "^" */
    0xb, 0xcb, 0x6, 0x30, 0x35,

    /* U+5F "_" */
    0x66, 0x66, 0x66, 0x66, 0x60,

    /* U+60 "`" */
    0x2a, 0xd2, 0x0, 0x1, 0x70,

    /* U+61 "a" */
    0x1, 0x86, 0x68, 0x50, 0x0, 0xa6, 0x0, 0xe,
    0x10, 0x4, 0x20, 0x0, 0xd2, 0x0, 0x4, 0x87,
    0x6d, 0x20, 0x9, 0xa0, 0x0, 0xd2, 0x2, 0xf1,
    0x0, 0xd, 0x20, 0x1f, 0x10, 0x1, 0xe2, 0x40,
    0x5b, 0x77, 0x69, 0xa4,

    /* U+62 "b" */
    0x1, 0x30, 0x0, 0x0, 0x3, 0xc7, 0x0, 0x0,
    0x0, 0x8, 0x70, 0x0, 0x0, 0x0, 0x87, 0x0,
    0x0, 0x0, 0x8, 0x70, 0x0, 0x0, 0x0, 0x87,
    0x68, 0xaa, 0x0, 0x8, 0xd2, 0x0, 0x97, 0x0,
    0x89, 0x0, 0x4, 0xd0, 0x8, 0x70, 0x0, 0x2f,
    0x0, 0x87, 0x0, 0x2, 0xf0, 0x8, 0x70, 0x0,
    0x4c, 0x0, 0x8b, 0x0, 0xa, 0x50, 0x7, 0x57,
    0x79, 0x60, 0x0,

    /* U+63 "c" */
    0x3, 0x96, 0x77, 0x2, 0xd0, 0x0, 0xe4, 0xa7,
    0x0, 0x7, 0x2e, 0x40, 0x0, 0x0, 0xd3, 0x0,
    0x0, 0xb, 0x60, 0x0, 0x3, 0x3d, 0x0, 0x2,
    0x50, 0x5b, 0x98, 0x60,

    /* U+64 "d" */
    0x0, 0x0, 0x1, 0x30, 0x0, 0x0, 0x4d, 0x70,
    0x0, 0x0, 0x8, 0x70, 0x0, 0x0, 0x8, 0x70,
    0x0, 0x0, 0x8, 0x70, 0x4, 0xb8, 0x8a, 0x70,
    0x3d, 0x0, 0xb, 0x70, 0xa6, 0x0, 0x8, 0x70,
    0xd4, 0x0, 0x8, 0x70, 0xd3, 0x0, 0x8, 0x70,
    0xb5, 0x0, 0x8, 0x70, 0x4b, 0x0, 0x1e, 0x70,
    0x6, 0xa8, 0x88, 0xb3,

    /* U+65 "e" */
    0x3, 0x97, 0x87, 0x2, 0xb0, 0x0, 0xa7, 0x95,
    0x0, 0x5, 0xdd, 0x86, 0x66, 0x7a, 0xd4, 0x0,
    0x0, 0xa, 0x70, 0x0, 0x2, 0x3d, 0x10, 0x3,
    0x40, 0x4b, 0x98, 0x60,

    /* U+66 "f" */
    0x0, 0x0, 0x76, 0x6b, 0x10, 0x0, 0x76, 0x0,
    0xb6, 0x0, 0xc, 0x20, 0x0, 0x0, 0x0, 0xd2,
    0x0, 0x0, 0x6, 0x6e, 0x76, 0x60, 0x0, 0x0,
    0xd2, 0x0, 0x0, 0x0, 0xd, 0x20, 0x0, 0x0,
    0x0, 0xd2, 0x0, 0x0, 0x0, 0xd, 0x20, 0x0,
    0x0, 0x0, 0xd2, 0x0, 0x0, 0x0, 0xd, 0x20,
    0x0, 0x0, 0x46, 0xf9, 0x63, 0x0,

    /* U+67 "g" */
    0x0, 0x67, 0x69, 0x7c, 0x40, 0x4a, 0x0, 0x1d,
    0x11, 0x7, 0x80, 0x0, 0xe0, 0x0, 0x2b, 0x0,
    0x2b, 0x0, 0x1, 0x97, 0x67, 0x0, 0x0, 0x5b,
    0x53, 0x0, 0x0, 0x1, 0xb9, 0xbe, 0xd5, 0x0,
    0xd1, 0x0, 0x3, 0xe0, 0xd, 0x10, 0x0, 0x1b,
    0x0, 0x29, 0x76, 0x78, 0x10,

    /* U+68 "h" */
    0x3c, 0x80, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x0, 0x78, 0x0,
    0x0, 0x0, 0x7, 0x87, 0x9a, 0xa0, 0x0, 0x7d,
    0x30, 0xb, 0x40, 0x7, 0x80, 0x0, 0x87, 0x0,
    0x78, 0x0, 0x8, 0x70, 0x7, 0x80, 0x0, 0x87,
    0x0, 0x78, 0x0, 0x8, 0x70, 0x7, 0x80, 0x0,
    0x87, 0x2, 0xcc, 0x30, 0x3c, 0xc2,

    /* U+69 "i" */
    0x0, 0x3e, 0x50, 0x0, 0x1, 0x92, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0x50, 0x0, 0x6, 0x7f,
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf, 0x0,
    0x0, 0x0, 0xf0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x67,
    0xf7, 0x60,

    /* U+6A "j" */
    0x0, 0x0, 0x5e, 0x20, 0x0, 0x2, 0xa1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x50, 0x0, 0x6,
    0x8f, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf,
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf, 0x0,
    0x0, 0x0, 0xf0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x1, 0xd0, 0x57, 0x0, 0x57, 0x3, 0xd8, 0x87,
    0x0,

    /* U+6B "k" */
    0x2b, 0x90, 0x0, 0x0, 0x0, 0x69, 0x0, 0x0,
    0x0, 0x6, 0x90, 0x0, 0x0, 0x0, 0x69, 0x0,
    0x0, 0x0, 0x6, 0x90, 0xa, 0xd6, 0x0, 0x69,
    0x0, 0xa0, 0x0, 0x6, 0x90, 0xa1, 0x0, 0x0,
    0x69, 0x9e, 0x20, 0x0, 0x6, 0xe3, 0x6c, 0x0,
    0x0, 0x69, 0x0, 0xc6, 0x0, 0x6, 0x90, 0x3,
    0xe1, 0x2, 0xbd, 0x30, 0x2d, 0xc2,

    /* U+6C "l" */
    0x16, 0x7f, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0,
    0xf, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf,
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf, 0x0,
    0x0, 0x0, 0xf0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0xf, 0x0, 0x1, 0x67,
    0xf7, 0x61,

    /* U+6D "m" */
    0x7e, 0x69, 0xb6, 0x8b, 0x1, 0xf2, 0xf, 0x40,
    0xc3, 0x1e, 0x0, 0xe1, 0xc, 0x31, 0xe0, 0xe,
    0x10, 0xc3, 0x1e, 0x0, 0xe1, 0xc, 0x31, 0xe0,
    0xe, 0x10, 0xc3, 0x1e, 0x0, 0xe1, 0xc, 0x36,
    0xf4, 0x4f, 0x63, 0xe9,

    /* U+6E "n" */
    0x3c, 0x86, 0x89, 0x90, 0x0, 0x7d, 0x30, 0xa,
    0x40, 0x7, 0x80, 0x0, 0x86, 0x0, 0x78, 0x0,
    0x8, 0x70, 0x7, 0x80, 0x0, 0x87, 0x0, 0x78,
    0x0, 0x8, 0x70, 0x7, 0x80, 0x0, 0x87, 0x2,
    0xcc, 0x30, 0x3c, 0xc2,

    /* U+6F "o" */
    0x0, 0x59, 0x79, 0x50, 0x0, 0x4a, 0x0, 0xa,
    0x40, 0xd, 0x30, 0x0, 0x3d, 0x1, 0xf0, 0x0,
    0x0, 0xf1, 0x1f, 0x0, 0x0, 0xf, 0x10, 0xe2,
    0x0, 0x2, 0xe0, 0x5, 0x90, 0x0, 0x95, 0x0,
    0x5, 0x87, 0x85, 0x0,

    /* U+70 "p" */
    0x4d, 0x87, 0x89, 0x80, 0x0, 0x7d, 0x20, 0x8,
    0x90, 0x7, 0x80, 0x0, 0x2f, 0x0, 0x78, 0x0,
    0x0, 0xf2, 0x7, 0x80, 0x0, 0xf, 0x10, 0x78,
    0x0, 0x2, 0xe0, 0x7, 0xc0, 0x0, 0xa6, 0x0,
    0x7a, 0x77, 0xa7, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x3, 0xcc, 0x40, 0x0, 0x0,

    /* U+71 "q" */
    0x0, 0x5a, 0x77, 0x46, 0x0, 0x5a, 0x0, 0xd,
    0x60, 0xd, 0x30, 0x0, 0x96, 0x0, 0xf1, 0x0,
    0x9, 0x60, 0xf, 0x10, 0x0, 0x96, 0x0, 0xd2,
    0x0, 0x9, 0x60, 0x6, 0x90, 0x0, 0xd6, 0x0,
    0x8, 0xa8, 0x8a, 0x60, 0x0, 0x0, 0x0, 0x96,
    0x0, 0x0, 0x0, 0x5d, 0xb2,

    /* U+72 "r" */
    0x38, 0xd9, 0x7, 0x9d, 0x10, 0x6, 0x98, 0x0,
    0xa1, 0x0, 0x6e, 0x10, 0x0, 0x0, 0x6, 0x90,
    0x0, 0x0, 0x0, 0x69, 0x0, 0x0, 0x0, 0x6,
    0x90, 0x0, 0x0, 0x0, 0x69, 0x0, 0x0, 0x2,
    0x6b, 0xd6, 0x40, 0x0,

    /* U+73 "s" */
    0x5, 0x76, 0xaf, 0x31, 0xa0, 0x0, 0x75, 0x2d,
    0x10, 0x0, 0x20, 0x7e, 0xa4, 0x0, 0x0, 0x6,
    0xcc, 0x14, 0x0, 0x0, 0x79, 0x66, 0x0, 0x4,
    0x75, 0xfa, 0x76, 0x70,

    /* U+74 "t" */
    0x0, 0x11, 0x0, 0x0, 0x6, 0x30, 0x0, 0x2,
    0xd3, 0x0, 0x5, 0x6d, 0x86, 0x60, 0x0, 0xc3,
    0x0, 0x0, 0xc, 0x30, 0x0, 0x0, 0xc3, 0x0,
    0x0, 0xc, 0x30, 0x0, 0x0, 0xb3, 0x0, 0x20,
    0x9, 0x50, 0x15, 0x0, 0x2b, 0x98, 0x0,

    /* U+75 "u" */
    0x3c, 0x70, 0x4, 0xd6, 0x0, 0x87, 0x0, 0x9,
    0x60, 0x8, 0x70, 0x0, 0x96, 0x0, 0x87, 0x0,
    0x9, 0x60, 0x8, 0x70, 0x0, 0x96, 0x0, 0x77,
    0x0, 0x9, 0x60, 0x5, 0xa0, 0x2, 0xe6, 0x0,
    0xa, 0xba, 0x79, 0xa2,

    /* U+76 "v" */
    0x2b, 0xe4, 0x2, 0xcb, 0x10, 0x1e, 0x0, 0x8,
    0x0, 0x0, 0xb4, 0x0, 0x80, 0x0, 0x6, 0xa0,
    0x53, 0x0, 0x0, 0x1e, 0x8, 0x0, 0x0, 0x0,
    0xb5, 0x70, 0x0, 0x0, 0x5, 0xe1, 0x0, 0x0,
    0x0, 0xb, 0x0, 0x0,

    /* U+77 "w" */
    0x8f, 0x46, 0xf5, 0x2d, 0x70, 0xe0, 0xd, 0x10,
    0x80, 0xa, 0x30, 0xe5, 0x7, 0x0, 0x77, 0x39,
    0x83, 0x40, 0x3, 0xa6, 0x2c, 0x60, 0x0, 0xd,
    0x60, 0xd7, 0x0, 0x0, 0xb7, 0xa, 0x70, 0x0,
    0x7, 0x30, 0x64, 0x0,

    /* U+78 "x" */
    0x6, 0xfb, 0x5, 0xe6, 0x0, 0x6, 0xc0, 0x45,
    0x0, 0x0, 0xc, 0x89, 0x0, 0x0, 0x0, 0x3f,
    0x20, 0x0, 0x0, 0x4, 0xc8, 0x0, 0x0, 0x0,
    0x90, 0xd2, 0x0, 0x0, 0x81, 0x5, 0xc0, 0x2,
    0x9e, 0x20, 0x6f, 0xa1,

    /* U+79 "y" */
    0x1a, 0xf5, 0x3, 0xda, 0x20, 0xe, 0x10, 0xa,
    0x0, 0x0, 0x77, 0x2, 0x70, 0x0, 0x1, 0xd0,
    0x72, 0x0, 0x0, 0xb, 0x39, 0x0, 0x0, 0x0,
    0x4b, 0x60, 0x0, 0x0, 0x0, 0xd1, 0x0, 0x0,
    0x0, 0x9, 0x0, 0x0, 0x1, 0x15, 0x40, 0x0,
    0x0, 0x9e, 0x70, 0x0, 0x0,

    /* U+7A "z" */
    0x8c, 0x66, 0x7f, 0x29, 0x10, 0xa, 0x70, 0x30,
    0x5, 0xc0, 0x0, 0x1, 0xe2, 0x0, 0x0, 0xb7,
    0x0, 0x0, 0x5c, 0x0, 0x6, 0x1e, 0x20, 0x3,
    0x8a, 0xc6, 0x67, 0xe5,

    /* U+7B "{" */
    0x0, 0x7, 0x50, 0x6, 0x40, 0x0, 0x90, 0x0,
    0xa, 0x0, 0x0, 0xa0, 0x0, 0xa, 0x0, 0x0,
    0xa0, 0x0, 0x66, 0x0, 0x5, 0x50, 0x0, 0xa,
    0x0, 0x0, 0xa0, 0x0, 0xa, 0x0, 0x0, 0xa0,
    0x0, 0x9, 0x0, 0x0, 0x64, 0x0, 0x0, 0x75,

    /* U+7C "|" */
    0x36, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66,

    /* U+7D "}" */
    0x47, 0x0, 0x0, 0x36, 0x0, 0x0, 0x90, 0x0,
    0xa, 0x0, 0x0, 0xa0, 0x0, 0xa, 0x0, 0x0,
    0xa0, 0x0, 0x6, 0x60, 0x0, 0x55, 0x0, 0xa,
    0x0, 0x0, 0xa0, 0x0, 0xa, 0x0, 0x0, 0xa0,
    0x0, 0x9, 0x0, 0x3, 0x60, 0x4, 0x70, 0x0,

    /* U+7E "~" */
    0x2, 0x89, 0x0, 0x0, 0x0, 0x60, 0x6b, 0x0,
    0x4, 0x22, 0x0, 0x89, 0x6, 0x0, 0x0, 0x0,
    0x7a, 0x40,

    /* U+F001 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x27,
    0xba, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x48,
    0xdf, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x1, 0x6a,
    0xff, 0xff, 0xff, 0xff, 0x20, 0x0, 0x0, 0x7c,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x0, 0x0,
    0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20,
    0x0, 0x5, 0xff, 0xff, 0xff, 0xff, 0xb7, 0x3f,
    0xf2, 0x0, 0x0, 0x5f, 0xff, 0xfe, 0x95, 0x0,
    0x1, 0xff, 0x20, 0x0, 0x5, 0xff, 0x73, 0x0,
    0x0, 0x0, 0x1f, 0xf2, 0x0, 0x0, 0x5f, 0xe0,
    0x0, 0x0, 0x0, 0x1, 0xff, 0x20, 0x0, 0x5,
    0xfe, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xf2, 0x0,
    0x0, 0x5f, 0xe0, 0x0, 0x0, 0x0, 0x1, 0xff,
    0x20, 0x0, 0x5, 0xfe, 0x0, 0x0, 0x0, 0x69,
    0x8f, 0xf2, 0x0, 0x0, 0x5f, 0xe0, 0x0, 0x2,
    0xef, 0xff, 0xff, 0x20, 0x3, 0x58, 0xfe, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0xf2, 0x2d, 0xff, 0xff,
    0xe0, 0x0, 0x4, 0xff, 0xff, 0xfd, 0xb, 0xff,
    0xff, 0xfe, 0x0, 0x0, 0x4, 0xbd, 0xc8, 0x10,
    0xaf, 0xff, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0xff, 0xb1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F008 "" */
    0x51, 0x6, 0x88, 0x88, 0x88, 0x88, 0x88, 0x30,
    0x15, 0xf7, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xb6, 0x8f, 0xfd, 0xcf, 0xf3, 0x33, 0x33, 0x33,
    0x6f, 0xec, 0xdf, 0xf2, 0xc, 0xe0, 0x0, 0x0,
    0x0, 0x3f, 0x70, 0x2f, 0xf2, 0xc, 0xe0, 0x0,
    0x0, 0x0, 0x3f, 0x80, 0x2f, 0xff, 0xff, 0xe0,
    0x0, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xf4, 0x2d,
    0xf9, 0x99, 0x99, 0x99, 0xbf, 0x92, 0x4f, 0xf2,
    0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x2f,
    0xfb, 0xaf, 0xf1, 0x11, 0x11, 0x11, 0x5f, 0xda,
    0xbf, 0xf9, 0x8e, 0xe0, 0x0, 0x0, 0x0, 0x3f,
    0xc8, 0x9f, 0xf2, 0xc, 0xe0, 0x0, 0x0, 0x0,
    0x3f, 0x70, 0x2f, 0xf6, 0x4d, 0xe0, 0x0, 0x0,
    0x0, 0x3f, 0xa4, 0x6f, 0xfe, 0xef, 0xfb, 0xbb,
    0xbb, 0xbb, 0xcf, 0xfe, 0xef, 0xc2, 0xc, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x80, 0x2c,

    /* U+F00B "" */
    0x58, 0x88, 0x70, 0x28, 0x88, 0x88, 0x88, 0x88,
    0x85, 0xff, 0xff, 0xf3, 0x9f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf3, 0xaf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xaf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xbf, 0xff, 0xd1, 0x6f,
    0xff, 0xff, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xff,
    0xe1, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xff,
    0xff, 0xf3, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf3, 0xaf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf3, 0x9f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x58, 0x88, 0x60, 0x27, 0x88, 0x88,
    0x88, 0x88, 0x85, 0x47, 0x77, 0x50, 0x17, 0x77,
    0x77, 0x77, 0x77, 0x74, 0xff, 0xff, 0xf3, 0x9f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3,
    0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf3, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf,
    0xff, 0xf1, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F00C "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0x90, 0x9, 0xd2, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0xf9, 0x0, 0x9f, 0xfe,
    0x20, 0x0, 0x8, 0xff, 0xff, 0x90, 0x0, 0xdf,
    0xff, 0xe2, 0x0, 0x8f, 0xff, 0xf9, 0x0, 0x0,
    0x2e, 0xff, 0xfe, 0x28, 0xff, 0xff, 0x90, 0x0,
    0x0, 0x2, 0xef, 0xff, 0xff, 0xff, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x2e, 0xff, 0xff, 0xff, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xef, 0xff, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2e, 0xff,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xd8, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F00D "" */
    0x2d, 0xb0, 0x0, 0x0, 0x6, 0xe6, 0xd, 0xff,
    0xc0, 0x0, 0x6, 0xff, 0xf3, 0xcf, 0xff, 0xc0,
    0x6, 0xff, 0xff, 0x31, 0xdf, 0xff, 0xc7, 0xff,
    0xff, 0x50, 0x1, 0xdf, 0xff, 0xff, 0xff, 0x50,
    0x0, 0x1, 0xdf, 0xff, 0xff, 0x50, 0x0, 0x0,
    0x7, 0xff, 0xff, 0xd0, 0x0, 0x0, 0x6, 0xff,
    0xff, 0xff, 0xc0, 0x0, 0x6, 0xff, 0xff, 0xdf,
    0xff, 0xc0, 0x6, 0xff, 0xff, 0x51, 0xdf, 0xff,
    0xc0, 0xff, 0xff, 0x50, 0x1, 0xdf, 0xff, 0x58,
    0xff, 0x50, 0x0, 0x1, 0xdf, 0xd0, 0x5, 0x30,
    0x0, 0x0, 0x1, 0x61, 0x0,

    /* U+F011 "" */
    0x0, 0x0, 0x0, 0x0, 0xcd, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xe3, 0x3, 0xff,
    0xa0, 0xb, 0xc1, 0x0, 0x0, 0x8, 0xff, 0xb0,
    0x3f, 0xfa, 0x4, 0xff, 0xd1, 0x0, 0x4, 0xff,
    0xf6, 0x3, 0xff, 0xa0, 0x1e, 0xff, 0xa0, 0x0,
    0xdf, 0xf7, 0x0, 0x3f, 0xfa, 0x0, 0x2e, 0xff,
    0x40, 0x3f, 0xfc, 0x0, 0x3, 0xff, 0xa0, 0x0,
    0x6f, 0xfa, 0x8, 0xff, 0x60, 0x0, 0x3f, 0xfa,
    0x0, 0x0, 0xef, 0xf0, 0xaf, 0xf2, 0x0, 0x3,
    0xff, 0xa0, 0x0, 0xb, 0xff, 0x1b, 0xff, 0x10,
    0x0, 0x1f, 0xf8, 0x0, 0x0, 0xbf, 0xf1, 0x9f,
    0xf3, 0x0, 0x0, 0x24, 0x0, 0x0, 0xd, 0xff,
    0x6, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xff, 0xd0, 0x1f, 0xff, 0x20, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xf8, 0x0, 0x9f, 0xfd, 0x20, 0x0,
    0x0, 0x0, 0x9f, 0xfe, 0x10, 0x0, 0xcf, 0xfe,
    0x71, 0x0, 0x4, 0xcf, 0xff, 0x50, 0x0, 0x1,
    0xdf, 0xff, 0xfe, 0xdf, 0xff, 0xff, 0x60, 0x0,
    0x0, 0x0, 0x9f, 0xff, 0xff, 0xff, 0xfd, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x28, 0xce, 0xfd, 0xa5,
    0x0, 0x0, 0x0,

    /* U+F013 "" */
    0x0, 0x0, 0x0, 0x4, 0x66, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x78, 0x17, 0xff, 0xff,
    0xff, 0x71, 0x87, 0x0, 0x4, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x40, 0xd, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x3f, 0xff,
    0xff, 0xfe, 0x88, 0xef, 0xff, 0xff, 0xf3, 0x8,
    0xff, 0xff, 0xd0, 0x0, 0xd, 0xff, 0xff, 0x80,
    0x0, 0xaf, 0xff, 0x50, 0x0, 0x5, 0xff, 0xfa,
    0x0, 0x0, 0xbf, 0xff, 0x30, 0x0, 0x3, 0xff,
    0xfb, 0x0, 0x1, 0xcf, 0xff, 0x80, 0x0, 0x8,
    0xff, 0xfc, 0x10, 0x3e, 0xff, 0xff, 0xf6, 0x0,
    0x6f, 0xff, 0xff, 0xe3, 0x1f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf1, 0x9, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x0, 0xdf,
    0x8e, 0xff, 0xff, 0xff, 0xe8, 0xfd, 0x0, 0x0,
    0x11, 0x1, 0x9f, 0xff, 0xf9, 0x10, 0x11, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2c, 0xee, 0xd2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F015 "" */
    0x0, 0x0, 0x0, 0x0, 0x8, 0x92, 0x0, 0x6b,
    0xb1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2d, 0xff,
    0xe4, 0xa, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x4e, 0xff, 0xff, 0xf6, 0xaf, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xfe, 0x31, 0xcf, 0xff, 0xff,
    0x20, 0x0, 0x0, 0x0, 0x9f, 0xfd, 0x25, 0x70,
    0xaf, 0xff, 0xf2, 0x0, 0x0, 0x1, 0xbf, 0xfa,
    0x8, 0xff, 0xb0, 0x7f, 0xff, 0x40, 0x0, 0x2,
    0xdf, 0xf8, 0xa, 0xff, 0xff, 0xd2, 0x5f, 0xff,
    0x50, 0x4, 0xff, 0xf5, 0x1d, 0xff, 0xff, 0xff,
    0xe4, 0x2e, 0xff, 0x70, 0xdf, 0xe3, 0x3e, 0xff,
    0xff, 0xff, 0xff, 0xf6, 0x1c, 0xff, 0x13, 0xb1,
    0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x9,
    0x60, 0x0, 0xa, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xe0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xfd,
    0x88, 0xbf, 0xff, 0xfe, 0x0, 0x0, 0x0, 0xa,
    0xff, 0xff, 0x70, 0x3, 0xff, 0xff, 0xe0, 0x0,
    0x0, 0x0, 0xaf, 0xff, 0xf7, 0x0, 0x3f, 0xff,
    0xfe, 0x0, 0x0, 0x0, 0xa, 0xff, 0xff, 0x70,
    0x3, 0xff, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x8f,
    0xff, 0xf5, 0x0, 0x2f, 0xff, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F019 "" */
    0x0, 0x0, 0x0, 0x9, 0xaa, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0xff, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xee, 0xef, 0xff, 0xfe, 0xee, 0xc0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,
    0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0xff,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xf8, 0x0, 0x0, 0x0, 0x24, 0x44, 0x44, 0x7,
    0xff, 0x70, 0x44, 0x44, 0x42, 0xff, 0xff, 0xff,
    0xc1, 0x66, 0x1d, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0x66, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x66, 0xc4,
    0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F01C "" */
    0x0, 0x0, 0x4, 0x44, 0x44, 0x44, 0x44, 0x41,
    0x0, 0x0, 0x0, 0x0, 0x1e, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0xb, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0x0, 0x0,
    0x6, 0xff, 0x50, 0x0, 0x0, 0x0, 0x1, 0xff,
    0xa0, 0x0, 0x1, 0xff, 0x90, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xff, 0x50, 0x0, 0xbf, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xfe, 0x10, 0x6f,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1e,
    0xfa, 0xe, 0xff, 0xcc, 0xcc, 0x20, 0x0, 0x0,
    0xbc, 0xcc, 0xef, 0xf2, 0xff, 0xff, 0xff, 0xfa,
    0x0, 0x0, 0x6f, 0xff, 0xff, 0xff, 0x4f, 0xff,
    0xff, 0xff, 0xf8, 0x88, 0x8e, 0xff, 0xff, 0xff,
    0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x4f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x37, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xa0,

    /* U+F021 "" */
    0x0, 0x0, 0x0, 0x15, 0x66, 0x40, 0x0, 0x5,
    0xcb, 0x0, 0x0, 0x3b, 0xff, 0xff, 0xff, 0x92,
    0x7, 0xff, 0x0, 0x7, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x66, 0xff, 0x0, 0x8f, 0xff, 0xa4, 0x12,
    0x5b, 0xff, 0xfd, 0xff, 0x4, 0xff, 0xe4, 0x0,
    0x0, 0x0, 0x4e, 0xff, 0xff, 0xd, 0xff, 0x30,
    0x0, 0x0, 0x45, 0x46, 0xff, 0xff, 0x4f, 0xf7,
    0x0, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xff, 0x8f,
    0xf1, 0x0, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xff,
    0x2, 0x10, 0x0, 0x0, 0x0, 0x12, 0x22, 0x22,
    0x21, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x67, 0x77, 0x77, 0x75, 0x0, 0x0,
    0x0, 0x6, 0x73, 0xff, 0xff, 0xff, 0xfe, 0x0,
    0x0, 0x0, 0x3f, 0xf6, 0xff, 0xff, 0xee, 0xfd,
    0x0, 0x0, 0x0, 0xcf, 0xf1, 0xff, 0xff, 0x70,
    0x0, 0x0, 0x0, 0x9, 0xff, 0xa0, 0xff, 0xff,
    0xfb, 0x20, 0x0, 0x2, 0xbf, 0xfe, 0x10, 0xff,
    0x8d, 0xff, 0xfc, 0xa9, 0xcf, 0xff, 0xe2, 0x0,
    0xff, 0x61, 0x9f, 0xff, 0xff, 0xff, 0xfb, 0x10,
    0x0, 0xff, 0x70, 0x1, 0x7c, 0xee, 0xd9, 0x30,
    0x0, 0x0, 0x56, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F026 "" */
    0x0, 0x0, 0x0, 0x2, 0x40, 0x0, 0x0, 0x2,
    0xef, 0x0, 0x0, 0x2, 0xef, 0xf0, 0x0, 0x3,
    0xef, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x7b, 0xbb, 0xdf,
    0xff, 0xf0, 0x0, 0x0, 0xbf, 0xff, 0x0, 0x0,
    0x0, 0xbf, 0xf0, 0x0, 0x0, 0x0, 0xbe, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F027 "" */
    0x0, 0x0, 0x0, 0x2, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2e, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xef, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x3e,
    0xff, 0xf0, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xff,
    0xf0, 0x7, 0x10, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x3f, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x8,
    0xf5, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x4, 0xf7,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0xd, 0xf3, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x3f, 0x70, 0x8b, 0xbb,
    0xdf, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F028 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0x40, 0x0, 0x0, 0x2d, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xef, 0x0, 0x0, 0x40, 0x1c,
    0xf4, 0x0, 0x0, 0x0, 0x2, 0xef, 0xf0, 0x0,
    0x5f, 0xb0, 0x1e, 0xe1, 0x0, 0x0, 0x3, 0xef,
    0xff, 0x0, 0x0, 0xaf, 0xa0, 0x6f, 0x70, 0xdf,
    0xff, 0xff, 0xff, 0xf0, 0x7, 0x10, 0xbf, 0x30,
    0xfd, 0xf, 0xff, 0xff, 0xff, 0xff, 0x3, 0xfd,
    0x3, 0xf9, 0xa, 0xf0, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x7, 0xf5, 0xe, 0xc0, 0x8f, 0x2f, 0xff,
    0xff, 0xff, 0xff, 0x0, 0x4f, 0x70, 0xdd, 0x7,
    0xf3, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x1d, 0xf3,
    0xf, 0xb0, 0x9f, 0x2f, 0xff, 0xff, 0xff, 0xff,
    0x3, 0xf7, 0x7, 0xf6, 0xc, 0xf0, 0x7b, 0xbb,
    0xdf, 0xff, 0xf0, 0x0, 0x3, 0xfe, 0x12, 0xfa,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0x0, 0x3, 0xff,
    0x40, 0xaf, 0x30, 0x0, 0x0, 0x0, 0xbf, 0xf0,
    0x0, 0x3c, 0x30, 0x6f, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0xbe, 0x0, 0x0, 0x0, 0x6f, 0xe1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0xd2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0x90, 0x0, 0x0,

    /* U+F03E "" */
    0x3a, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xa3, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0xff, 0xd5, 0x6e, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x20, 0x4, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x2, 0xff,
    0xff, 0xff, 0xbf, 0xff, 0xff, 0xff, 0x50, 0x7,
    0xff, 0xff, 0xf5, 0x8, 0xff, 0xff, 0xff, 0xfb,
    0xbf, 0xff, 0xff, 0x50, 0x0, 0x8f, 0xff, 0xff,
    0xff, 0xcb, 0xff, 0xf5, 0x0, 0x0, 0x9, 0xff,
    0xff, 0xfc, 0x0, 0xaf, 0x50, 0x0, 0x0, 0x4,
    0xff, 0xff, 0xc0, 0x0, 0x3, 0x0, 0x0, 0x0,
    0x4, 0xff, 0xff, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xff, 0xff, 0x74, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x47, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x6f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,

    /* U+F048 "" */
    0x6b, 0x90, 0x0, 0x0, 0x3, 0xa2, 0x9f, 0xe0,
    0x0, 0x0, 0x4f, 0xf9, 0x9f, 0xe0, 0x0, 0x5,
    0xff, 0xfa, 0x9f, 0xe0, 0x0, 0x6f, 0xff, 0xfa,
    0x9f, 0xe0, 0x7, 0xff, 0xff, 0xfa, 0x9f, 0xe0,
    0x8f, 0xff, 0xff, 0xfa, 0x9f, 0xe9, 0xff, 0xff,
    0xff, 0xfa, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x9f, 0xfe,
    0xff, 0xff, 0xff, 0xfa, 0x9f, 0xe1, 0xdf, 0xff,
    0xff, 0xfa, 0x9f, 0xe0, 0x1c, 0xff, 0xff, 0xfa,
    0x9f, 0xe0, 0x0, 0xbf, 0xff, 0xfa, 0x9f, 0xe0,
    0x0, 0xa, 0xff, 0xfa, 0x9f, 0xe0, 0x0, 0x0,
    0x9f, 0xfa, 0x9f, 0xe0, 0x0, 0x0, 0x8, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F04B "" */
    0x3a, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xfe, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xfb, 0x20, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xe6, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc3, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x91, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x60,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x20, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x40, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0x70, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xa1, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xd3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0xe6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F04C "" */
    0x3a, 0xbb, 0xb9, 0x10, 0x3, 0xab, 0xbb, 0x91,
    0xef, 0xff, 0xff, 0xa0, 0xe, 0xff, 0xff, 0xfa,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xb0, 0xf, 0xff, 0xff, 0xfb,
    0x7f, 0xff, 0xfe, 0x40, 0x7, 0xff, 0xff, 0xe4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F04D "" */
    0x3a, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0x91,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F051 "" */
    0x4a, 0x20, 0x0, 0x0, 0xa, 0xb4, 0xbf, 0xe3,
    0x0, 0x0, 0xf, 0xf8, 0xcf, 0xff, 0x40, 0x0,
    0xf, 0xf8, 0xcf, 0xff, 0xf5, 0x0, 0xf, 0xf8,
    0xcf, 0xff, 0xff, 0x60, 0xf, 0xf8, 0xcf, 0xff,
    0xff, 0xf7, 0xf, 0xf8, 0xcf, 0xff, 0xff, 0xff,
    0x9f, 0xf8, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xcf, 0xff,
    0xff, 0xff, 0xdf, 0xf8, 0xcf, 0xff, 0xff, 0xfc,
    0x1f, 0xf8, 0xcf, 0xff, 0xff, 0xb0, 0xf, 0xf8,
    0xcf, 0xff, 0xfa, 0x0, 0xf, 0xf8, 0xcf, 0xff,
    0x80, 0x0, 0xf, 0xf8, 0xbf, 0xf7, 0x0, 0x0,
    0xf, 0xf8, 0x7f, 0x60, 0x0, 0x0, 0xf, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F052 "" */
    0x0, 0x0, 0x0, 0x2, 0xca, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2e, 0xff, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xef, 0xff, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1d, 0xff, 0xff,
    0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xff,
    0xff, 0xff, 0xf9, 0x0, 0x0, 0x0, 0xb, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x70, 0x0, 0x0, 0xaf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x0, 0x8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xb0, 0xa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x60, 0x0, 0x34, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x42, 0x0, 0x3, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x10, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xb0, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0xc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F053 "" */
    0x0, 0x0, 0x0, 0x0, 0x41, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0xd0, 0x0, 0x0, 0x0, 0x9f, 0xff,
    0x20, 0x0, 0x0, 0x9f, 0xff, 0x50, 0x0, 0x0,
    0x9f, 0xff, 0x50, 0x0, 0x0, 0x9f, 0xff, 0x50,
    0x0, 0x0, 0x9f, 0xff, 0x50, 0x0, 0x0, 0x9f,
    0xff, 0x50, 0x0, 0x0, 0xe, 0xff, 0xd1, 0x0,
    0x0, 0x0, 0x3e, 0xff, 0xc1, 0x0, 0x0, 0x0,
    0x3e, 0xff, 0xc1, 0x0, 0x0, 0x0, 0x3e, 0xff,
    0xc1, 0x0, 0x0, 0x0, 0x3e, 0xff, 0xc1, 0x0,
    0x0, 0x0, 0x3e, 0xff, 0xc0, 0x0, 0x0, 0x0,
    0x3e, 0xff, 0x20, 0x0, 0x0, 0x0, 0x3c, 0x60,

    /* U+F054 "" */
    0x0, 0x50, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xc1,
    0x0, 0x0, 0x0, 0xe, 0xff, 0xc1, 0x0, 0x0,
    0x0, 0x2e, 0xff, 0xc1, 0x0, 0x0, 0x0, 0x2e,
    0xff, 0xc1, 0x0, 0x0, 0x0, 0x2e, 0xff, 0xc1,
    0x0, 0x0, 0x0, 0x2e, 0xff, 0xc1, 0x0, 0x0,
    0x0, 0x2e, 0xff, 0xc0, 0x0, 0x0, 0x0, 0xaf,
    0xff, 0x20, 0x0, 0x0, 0x9f, 0xff, 0x50, 0x0,
    0x0, 0x9f, 0xff, 0x50, 0x0, 0x0, 0x9f, 0xff,
    0x50, 0x0, 0x0, 0x9f, 0xff, 0x50, 0x0, 0x0,
    0x9f, 0xff, 0x60, 0x0, 0x0, 0xe, 0xff, 0x60,
    0x0, 0x0, 0x0, 0x3d, 0x50, 0x0, 0x0, 0x0,

    /* U+F067 "" */
    0x0, 0x0, 0x0, 0x39, 0x91, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xf9, 0x0, 0x0, 0x0,
    0x36, 0x77, 0x77, 0xef, 0xfc, 0x77, 0x77, 0x61,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xae, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6,
    0x0, 0x0, 0x0, 0xdf, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0x10, 0x0, 0x0, 0x0,

    /* U+F068 "" */
    0x36, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x61,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,

    /* U+F06E "" */
    0x0, 0x0, 0x0, 0x3, 0x68, 0x87, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8e, 0xff, 0xff,
    0xff, 0xf9, 0x20, 0x0, 0x0, 0x0, 0x4, 0xef,
    0xfd, 0x63, 0x25, 0xbf, 0xff, 0x70, 0x0, 0x0,
    0x7, 0xff, 0xfa, 0x0, 0x0, 0x0, 0x7f, 0xff,
    0xa0, 0x0, 0x6, 0xff, 0xfd, 0x0, 0x8, 0xfc,
    0x20, 0x9f, 0xff, 0xa0, 0x2, 0xff, 0xff, 0x50,
    0x0, 0x8f, 0xfe, 0x12, 0xff, 0xff, 0x60, 0xcf,
    0xff, 0xf2, 0x16, 0x7f, 0xff, 0xf5, 0xe, 0xff,
    0xfe, 0x1e, 0xff, 0xff, 0x12, 0xff, 0xff, 0xff,
    0x70, 0xdf, 0xff, 0xf2, 0x6f, 0xff, 0xf3, 0xe,
    0xff, 0xff, 0xf3, 0xf, 0xff, 0xfb, 0x0, 0xbf,
    0xff, 0x90, 0x4f, 0xff, 0xf8, 0x5, 0xff, 0xfe,
    0x10, 0x1, 0xdf, 0xff, 0x40, 0x28, 0x84, 0x1,
    0xef, 0xff, 0x30, 0x0, 0x1, 0xbf, 0xff, 0x60,
    0x0, 0x4, 0xef, 0xfd, 0x30, 0x0, 0x0, 0x0,
    0x6e, 0xff, 0xfb, 0xbe, 0xff, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xad, 0xff, 0xeb, 0x71,
    0x0, 0x0, 0x0,

    /* U+F070 "" */
    0x4a, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xfe, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0xff, 0x60, 0x0, 0x15, 0x78, 0x74, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2d, 0xff, 0xa6, 0xdf, 0xff,
    0xff, 0xff, 0xa2, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xff, 0xff, 0xe8, 0x32, 0x5b, 0xff, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xff, 0xf6, 0x0, 0x10,
    0x6, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xef, 0xf8, 0x7f, 0xd3, 0x9, 0xff, 0xfb, 0x0,
    0x0, 0x1e, 0x70, 0x1, 0xbf, 0xfe, 0xff, 0xf2,
    0x1f, 0xff, 0xf7, 0x0, 0x9, 0xff, 0xa0, 0x0,
    0x8f, 0xff, 0xff, 0x70, 0xdf, 0xff, 0xf1, 0x0,
    0xcf, 0xff, 0xd1, 0x0, 0x5f, 0xff, 0xf9, 0xc,
    0xff, 0xff, 0x30, 0x5, 0xff, 0xff, 0x60, 0x0,
    0x2d, 0xff, 0xb0, 0xef, 0xff, 0xb0, 0x0, 0xa,
    0xff, 0xfc, 0x0, 0x0, 0xa, 0xff, 0xef, 0xff,
    0xe1, 0x0, 0x0, 0xc, 0xff, 0xf6, 0x0, 0x0,
    0x6, 0xff, 0xff, 0xf3, 0x0, 0x0, 0x0, 0xa,
    0xff, 0xf8, 0x10, 0x0, 0x3, 0xef, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xef, 0xff, 0xcb, 0x80,
    0x1, 0xbf, 0xfb, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x5a, 0xdf, 0xfe, 0x70, 0x0, 0x8f, 0xfe, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0xff, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2d, 0xe1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0x0,

    /* U+F071 "" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0xcd, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xff, 0xff,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xff, 0xff, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xff, 0xff, 0xff, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xfb, 0x33,
    0x8f, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xff, 0xf9, 0x0, 0x6f, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xff, 0xfa, 0x0, 0x6f, 0xff,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xfb,
    0x0, 0x7f, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0xff, 0xfc, 0x0, 0x8f, 0xff, 0xff, 0x10,
    0x0, 0x0, 0x6, 0xff, 0xff, 0xfd, 0x0, 0x9f,
    0xff, 0xff, 0xa0, 0x0, 0x0, 0xe, 0xff, 0xff,
    0xff, 0xcb, 0xff, 0xff, 0xff, 0xf3, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0xfc, 0x0, 0x8f, 0xff, 0xff,
    0xfc, 0x0, 0x2, 0xff, 0xff, 0xff, 0xf9, 0x0,
    0x4f, 0xff, 0xff, 0xff, 0x60, 0xa, 0xff, 0xff,
    0xff, 0xfe, 0x42, 0xcf, 0xff, 0xff, 0xff, 0xe0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf3, 0x9, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x0, 0x23,
    0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33,
    0x0,

    /* U+F074 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xf9, 0x0, 0x12, 0x22, 0x10, 0x0, 0x0, 0x1,
    0x29, 0xff, 0x90, 0xff, 0xff, 0xe2, 0x0, 0x0,
    0x6f, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xfe, 0x20,
    0x5, 0xff, 0xff, 0xff, 0xfd, 0x9a, 0xad, 0xff,
    0xd0, 0x5f, 0xff, 0xbd, 0xff, 0xe2, 0x0, 0x0,
    0xcf, 0x44, 0xff, 0xf9, 0x8, 0xfe, 0x20, 0x0,
    0x0, 0x4, 0x4f, 0xff, 0x90, 0x4, 0xd2, 0x0,
    0x0, 0x0, 0x3, 0xff, 0xfa, 0x0, 0x0, 0x10,
    0x0, 0x0, 0x0, 0x3f, 0xff, 0xa1, 0x91, 0x6,
    0xf6, 0x0, 0x0, 0x2, 0xef, 0xfb, 0xc, 0xfc,
    0x8, 0xff, 0x60, 0xef, 0xff, 0xff, 0xb0, 0x1d,
    0xff, 0xff, 0xff, 0xf6, 0xff, 0xff, 0xfc, 0x0,
    0x2, 0xef, 0xff, 0xff, 0xfe, 0xdd, 0xdd, 0xb0,
    0x0, 0x0, 0x2d, 0xde, 0xff, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F077 "" */
    0x0, 0x0, 0x0, 0x4, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0xe2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xff, 0xfe, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xff, 0xff, 0xe3, 0x0, 0x0,
    0x0, 0x6, 0xff, 0xfa, 0xcf, 0xfe, 0x30, 0x0,
    0x0, 0x6f, 0xff, 0x90, 0xc, 0xff, 0xe3, 0x0,
    0x6, 0xff, 0xf9, 0x0, 0x0, 0xcf, 0xfe, 0x30,
    0x5f, 0xff, 0x90, 0x0, 0x0, 0xc, 0xff, 0xe2,
    0xaf, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xf6,
    0x1b, 0x80, 0x0, 0x0, 0x0, 0x0, 0xb, 0x90,

    /* U+F078 "" */
    0x3, 0x20, 0x0, 0x0, 0x0, 0x0, 0x3, 0x20,
    0x6f, 0xe2, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf2,
    0xaf, 0xfe, 0x20, 0x0, 0x0, 0x5, 0xff, 0xf6,
    0x1c, 0xff, 0xe3, 0x0, 0x0, 0x5f, 0xff, 0x90,
    0x1, 0xcf, 0xfe, 0x30, 0x5, 0xff, 0xf9, 0x0,
    0x0, 0x1c, 0xff, 0xe3, 0x5f, 0xff, 0x90, 0x0,
    0x0, 0x1, 0xcf, 0xff, 0xff, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x1c, 0xff, 0xff, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xcf, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1b, 0x90, 0x0, 0x0, 0x0,

    /* U+F079 "" */
    0x0, 0x0, 0x26, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xef, 0xa0,
    0x0, 0x44, 0x44, 0x44, 0x44, 0x42, 0x0, 0x0,
    0x0, 0x3e, 0xff, 0xfa, 0x4, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0x0, 0x0, 0x3, 0xef, 0xff, 0xff,
    0xa0, 0xaf, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x0,
    0xe, 0xfd, 0xef, 0xcf, 0xf8, 0x0, 0x0, 0x0,
    0x5, 0xfe, 0x0, 0x0, 0xb, 0xe2, 0xdf, 0x67,
    0xf5, 0x0, 0x0, 0x0, 0x5, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xfe, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0x60, 0x0, 0x0, 0x0, 0x4,
    0x15, 0xfe, 0x3, 0x20, 0x0, 0x0, 0xdf, 0x60,
    0x0, 0x0, 0x0, 0x6f, 0xd6, 0xfe, 0x4f, 0xf1,
    0x0, 0x0, 0xdf, 0x94, 0x44, 0x44, 0x41, 0x3f,
    0xff, 0xff, 0xff, 0xc0, 0x0, 0x0, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0x24, 0xff, 0xff, 0xfc, 0x10,
    0x0, 0x0, 0x9f, 0xff, 0xff, 0xff, 0xfe, 0x30,
    0x4f, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x10, 0x0, 0x0,

    /* U+F07B "" */
    0x17, 0x88, 0x88, 0x84, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x44,
    0x44, 0x44, 0x30, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,

    /* U+F093 "" */
    0x0, 0x0, 0x0, 0x0, 0x47, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff,
    0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff,
    0xff, 0xff, 0xf9, 0x0, 0x0, 0x0, 0x4, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x90, 0x0, 0x0, 0xc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x0,
    0x0, 0x11, 0x2f, 0xff, 0xf7, 0x11, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0xff, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xff, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xff, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xff,
    0xf6, 0x0, 0x0, 0x0, 0x24, 0x44, 0x42, 0x1f,
    0xff, 0xf6, 0x24, 0x44, 0x42, 0xff, 0xff, 0xfc,
    0x8, 0xbb, 0xa2, 0xcf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xa5, 0x55, 0x5a, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x66, 0xc4,
    0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F095 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xb8,
    0x41, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xff, 0xff, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xff,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xff, 0xff, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xff, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xff, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0xff, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0x90,
    0x0, 0x0, 0x4, 0xa5, 0x0, 0x0, 0xaf, 0xff,
    0xd0, 0x0, 0x0, 0x7d, 0xff, 0xf4, 0x2, 0xcf,
    0xff, 0xe2, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xe9,
    0xff, 0xff, 0xf3, 0x0, 0x0, 0xd, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe2, 0x0, 0x0, 0x0, 0x9f,
    0xff, 0xff, 0xff, 0xff, 0xa1, 0x0, 0x0, 0x0,
    0x6, 0xff, 0xff, 0xff, 0xfc, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xff, 0xfd, 0x83, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x23, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F0C4 "" */
    0x0, 0x35, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1c, 0xff, 0xfa, 0x0, 0x0, 0x1, 0x9c, 0xa1,
    0xaf, 0xfe, 0xff, 0x60, 0x0, 0x2e, 0xff, 0xf9,
    0xef, 0x60, 0xaf, 0xb0, 0x3, 0xef, 0xff, 0xb0,
    0xef, 0x92, 0xcf, 0x90, 0x3e, 0xff, 0xfa, 0x0,
    0x7f, 0xff, 0xff, 0xe6, 0xff, 0xff, 0xa0, 0x0,
    0x8, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0, 0x0,
    0x0, 0x1, 0xcf, 0xff, 0xff, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0xff, 0x10, 0x0, 0x0,
    0x0, 0x36, 0xef, 0xff, 0xff, 0xd1, 0x0, 0x0,
    0x1c, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x10, 0x0,
    0xaf, 0xfe, 0xff, 0xc2, 0xdf, 0xff, 0xd1, 0x0,
    0xef, 0x60, 0xaf, 0xa0, 0x1c, 0xff, 0xfd, 0x20,
    0xef, 0x92, 0xcf, 0xa0, 0x0, 0xcf, 0xff, 0xe2,
    0x7f, 0xff, 0xff, 0x40, 0x0, 0xb, 0xff, 0xf9,
    0x8, 0xff, 0xe5, 0x0, 0x0, 0x0, 0x58, 0x50,
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F0C5 "" */
    0x0, 0x0, 0x6f, 0xff, 0xff, 0xf1, 0x68, 0x0,
    0x0, 0x0, 0xaf, 0xff, 0xff, 0xf1, 0x7f, 0x80,
    0x0, 0x0, 0xaf, 0xff, 0xff, 0xf1, 0x7f, 0xf8,
    0x36, 0x62, 0xaf, 0xff, 0xff, 0xf1, 0x36, 0x66,
    0xff, 0xf6, 0xaf, 0xff, 0xff, 0xf6, 0x22, 0x22,
    0xff, 0xf6, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xf6, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xf6, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xf6, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xf6, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xf6, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xf6, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xf6, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xf6, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xf7, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0xff, 0xfe, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x0,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x0,
    0x14, 0x44, 0x44, 0x44, 0x44, 0x20, 0x0, 0x0,

    /* U+F0C7 "" */
    0x5, 0x66, 0x66, 0x66, 0x66, 0x64, 0x0, 0x0,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x0,
    0xff, 0xed, 0xdd, 0xdd, 0xdd, 0xef, 0xf9, 0x0,
    0xff, 0x40, 0x0, 0x0, 0x0, 0xf, 0xff, 0x90,
    0xff, 0x40, 0x0, 0x0, 0x0, 0xe, 0xff, 0xf6,
    0xff, 0x40, 0x0, 0x0, 0x0, 0xe, 0xff, 0xf9,
    0xff, 0x40, 0x0, 0x0, 0x0, 0xf, 0xff, 0xf9,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0xff, 0xff, 0xff, 0xc5, 0x7f, 0xff, 0xff, 0xf9,
    0xff, 0xff, 0xfe, 0x0, 0x5, 0xff, 0xff, 0xf9,
    0xff, 0xff, 0xfa, 0x0, 0x1, 0xff, 0xff, 0xf9,
    0xff, 0xff, 0xfd, 0x0, 0x4, 0xff, 0xff, 0xf9,
    0xff, 0xff, 0xff, 0x93, 0x4d, 0xff, 0xff, 0xf9,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe3,
    0x1, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21, 0x0,

    /* U+F0E7 "" */
    0x0, 0xaf, 0xff, 0xff, 0xa0, 0x0, 0x0, 0xf,
    0xff, 0xff, 0xfb, 0x0, 0x0, 0x1, 0xff, 0xff,
    0xff, 0x60, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xf1,
    0x0, 0x0, 0x5, 0xff, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0xa5, 0x55, 0x40, 0xa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0xcf, 0xff,
    0xff, 0xff, 0xff, 0xc0, 0xe, 0xff, 0xff, 0xff,
    0xff, 0xf3, 0x0, 0xef, 0xff, 0xff, 0xff, 0xfa,
    0x0, 0x1, 0x22, 0x23, 0xff, 0xff, 0x10, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0x70, 0x0, 0x0, 0x0,
    0x8, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0xf, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xff, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xe1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F0EA "" */
    0x0, 0x0, 0x8d, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x8b, 0xbc, 0xfa, 0xfd, 0xbb, 0x90, 0x0, 0x0,
    0xff, 0xff, 0xd0, 0xcf, 0xff, 0xf1, 0x0, 0x0,
    0xff, 0xff, 0xf8, 0xff, 0xff, 0xf1, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x0,
    0xff, 0xff, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0x95, 0xff, 0xff, 0xf1, 0x79, 0x0,
    0xff, 0xff, 0x88, 0xff, 0xff, 0xf1, 0x7f, 0xb0,
    0xff, 0xff, 0x88, 0xff, 0xff, 0xf1, 0x7f, 0xfa,
    0xff, 0xff, 0x88, 0xff, 0xff, 0xf2, 0x2, 0x21,
    0xff, 0xff, 0x88, 0xff, 0xff, 0xff, 0xdd, 0xdc,
    0xff, 0xff, 0x88, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0x88, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0x88, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x7a, 0xaa, 0x58, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0x6, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F0F3 "" */
    0x0, 0x0, 0x0, 0x8, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xcf, 0xfa, 0x40, 0x0, 0x0,
    0x0, 0x1, 0xcf, 0xff, 0xff, 0xf9, 0x0, 0x0,
    0x0, 0xc, 0xff, 0xff, 0xff, 0xff, 0x80, 0x0,
    0x0, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0,
    0x0, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x0,
    0x0, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x0,
    0x0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0,
    0x0, 0xef, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0,
    0x2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0,
    0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0x10, 0x0, 0x0, 0x0,

    /* U+F11C "" */
    0x4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x41, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xe0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f,
    0xf4, 0x4, 0xd0, 0x2f, 0x0, 0xf3, 0x3, 0xf0,
    0xf, 0xf4, 0xff, 0x40, 0x5d, 0x2, 0xf0, 0xf,
    0x40, 0x4f, 0x0, 0xff, 0x4f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xff,
    0xff, 0x22, 0xb7, 0x29, 0xa2, 0x4f, 0x42, 0xcf,
    0xff, 0x4f, 0xff, 0xf0, 0xa, 0x60, 0x79, 0x2,
    0xf2, 0xb, 0xff, 0xf4, 0xff, 0xff, 0xdd, 0xfe,
    0xdf, 0xfd, 0xef, 0xed, 0xff, 0xff, 0x4f, 0xf8,
    0x48, 0xe4, 0x44, 0x44, 0x44, 0x47, 0xf4, 0x5f,
    0xf4, 0xff, 0x40, 0x4d, 0x0, 0x0, 0x0, 0x0,
    0x3e, 0x0, 0xff, 0x4f, 0xf7, 0x48, 0xe4, 0x44,
    0x44, 0x44, 0x47, 0xf4, 0x4f, 0xf4, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x37, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xa0,

    /* U+F124 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0x8b, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xaf, 0xff, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xbf, 0xff, 0xff, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xcf, 0xff, 0xff,
    0xff, 0x70, 0x0, 0x0, 0x0, 0x6, 0xdf, 0xff,
    0xff, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x17, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x29,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0,
    0x7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x90, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x20, 0x0, 0xb, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x56,
    0x66, 0x66, 0x7f, 0xff, 0xff, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xff, 0xff, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xff,
    0xff, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xff, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xff, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xff, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xff,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x30, 0x0, 0x0, 0x0, 0x0,

    /* U+F15B "" */
    0x58, 0x88, 0x88, 0x87, 0x6, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xfe, 0xf, 0x90, 0x0, 0xff, 0xff,
    0xff, 0xfe, 0xf, 0xf9, 0x0, 0xff, 0xff, 0xff,
    0xfe, 0xf, 0xff, 0x90, 0xff, 0xff, 0xff, 0xfe,
    0xf, 0xff, 0xf5, 0xff, 0xff, 0xff, 0xff, 0x32,
    0x22, 0x21, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x14, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x30,

    /* U+F1EB "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x36,
    0x89, 0xa9, 0x74, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x29, 0xef, 0xff, 0xff, 0xff, 0xff, 0xc6,
    0x0, 0x0, 0x0, 0x1, 0xaf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x60, 0x0, 0x6, 0xff,
    0xff, 0xfc, 0x75, 0x43, 0x46, 0x9e, 0xff, 0xff,
    0xb1, 0x8, 0xff, 0xfe, 0x71, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xcf, 0xff, 0xe2, 0xcf, 0xfa, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4e, 0xff,
    0x40, 0xb6, 0x0, 0x0, 0x59, 0xde, 0xfe, 0xc7,
    0x20, 0x0, 0x1b, 0x50, 0x0, 0x0, 0x5, 0xdf,
    0xff, 0xff, 0xff, 0xff, 0xa1, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xff, 0xff, 0xfe, 0xde, 0xff, 0xff,
    0xe3, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xfc, 0x40,
    0x0, 0x2, 0x8f, 0xff, 0x50, 0x0, 0x0, 0x0,
    0x1, 0xb6, 0x0, 0x0, 0x0, 0x0, 0x1b, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x35,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0xfe, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xff, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xdf, 0xff, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F240 "" */
    0x4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x10, 0xa, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x10, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0xf, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xf3, 0xff, 0x4a,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf,
    0xff, 0x5f, 0xf4, 0xaf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0x3f, 0xf5, 0xff, 0x4a, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xef,
    0x5f, 0xf4, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x8f, 0xf5, 0xff, 0x45, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x88, 0xf, 0xff, 0x5f,
    0xf7, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x45, 0xff, 0xc1, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x6, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0x0,

    /* U+F241 "" */
    0x4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x10, 0xa, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x10, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0xf, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xf3, 0xff, 0x4d,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x0, 0xf,
    0xff, 0x5f, 0xf4, 0xdf, 0xff, 0xff, 0xff, 0xff,
    0xf6, 0x0, 0x0, 0x3f, 0xf5, 0xff, 0x4d, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x60, 0x0, 0x0, 0xef,
    0x5f, 0xf4, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf6,
    0x0, 0x0, 0x8f, 0xf5, 0xff, 0x46, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x30, 0x0, 0xf, 0xff, 0x5f,
    0xf7, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x45, 0xff, 0xc1, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x6, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0x0,

    /* U+F242 "" */
    0x4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x10, 0xa, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x10, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0xf, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xf3, 0xff, 0x4c,
    0xff, 0xff, 0xff, 0xf1, 0x0, 0x0, 0x0, 0xf,
    0xff, 0x5f, 0xf4, 0xcf, 0xff, 0xff, 0xff, 0x10,
    0x0, 0x0, 0x0, 0x3f, 0xf5, 0xff, 0x4c, 0xff,
    0xff, 0xff, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xef,
    0x5f, 0xf4, 0xcf, 0xff, 0xff, 0xff, 0x10, 0x0,
    0x0, 0x0, 0x8f, 0xf5, 0xff, 0x46, 0x88, 0x88,
    0x88, 0x80, 0x0, 0x0, 0x0, 0xf, 0xff, 0x5f,
    0xf7, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x45, 0xff, 0xc1, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x6, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0x0,

    /* U+F243 "" */
    0x4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x10, 0xa, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x10, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0xf, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xf3, 0xff, 0x49,
    0xff, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xff, 0x5f, 0xf4, 0x9f, 0xff, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xf5, 0xff, 0x49, 0xff,
    0xfe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef,
    0x5f, 0xf4, 0x9f, 0xff, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xf5, 0xff, 0x44, 0x88, 0x87,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0x5f,
    0xf7, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x45, 0xff, 0xc1, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x6, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0x0,

    /* U+F244 "" */
    0x4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x10, 0xa, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x10, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0xf, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xf3, 0xff, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xff, 0x5f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xf5, 0xff, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef,
    0x5f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xf5, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0x5f,
    0xf7, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x45, 0xff, 0xc1, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x6, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0x0,

    /* U+F287 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x78, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x26, 0x9f, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0xef, 0xff, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0x80,
    0x2e, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x20,
    0x0, 0x6, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xef, 0xe3, 0x0, 0xd7, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xa1, 0x0, 0xcf, 0xff, 0xd4,
    0x9f, 0x55, 0x55, 0x55, 0x55, 0x55, 0x7f, 0xf7,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf5, 0xaf, 0xff, 0xa0, 0x0,
    0xb, 0xb0, 0x0, 0x0, 0x0, 0x3f, 0xb2, 0x0,
    0x9c, 0x90, 0x0, 0x0, 0x3f, 0x30, 0x0, 0x0,
    0x1, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbb, 0x2, 0xbb, 0xb5, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xf9, 0x9f, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xbd, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F293 "" */
    0x0, 0x1, 0x7b, 0xdd, 0xb8, 0x20, 0x0, 0x0,
    0x5f, 0xff, 0xdf, 0xff, 0xf6, 0x0, 0x4, 0xff,
    0xff, 0x68, 0xff, 0xff, 0x40, 0xe, 0xff, 0xff,
    0x60, 0x9f, 0xff, 0xd0, 0x4f, 0xff, 0xff, 0x60,
    0x9, 0xff, 0xf3, 0x8f, 0xf6, 0xbf, 0x61, 0xc0,
    0x9f, 0xf7, 0xbf, 0xf6, 0xb, 0x60, 0xe2, 0x5f,
    0xf9, 0xdf, 0xff, 0x50, 0x20, 0x33, 0xff, 0xfb,
    0xef, 0xff, 0xf5, 0x0, 0x2e, 0xff, 0xfc, 0xef,
    0xff, 0xfc, 0x0, 0x7f, 0xff, 0xfc, 0xdf, 0xff,
    0xd1, 0x0, 0x9, 0xff, 0xfc, 0xcf, 0xfc, 0x14,
    0x50, 0x90, 0xaf, 0xfb, 0xaf, 0xf2, 0x4f, 0x60,
    0xf3, 0x2f, 0xf9, 0x6f, 0xfd, 0xff, 0x70, 0x52,
    0xef, 0xf6, 0x1f, 0xff, 0xff, 0x70, 0x2e, 0xff,
    0xf1, 0x9, 0xff, 0xff, 0x72, 0xef, 0xff, 0x90,
    0x0, 0xbf, 0xff, 0xae, 0xff, 0xfd, 0x10, 0x0,
    0x5, 0xcf, 0xff, 0xfd, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x11, 0x0, 0x0, 0x0,

    /* U+F2ED "" */
    0x0, 0x0, 0x5, 0x88, 0x88, 0x30, 0x0, 0x0,
    0x56, 0x66, 0x7f, 0xff, 0xff, 0xe6, 0x66, 0x63,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xcd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xd8,
    0x3, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x20,
    0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,
    0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,
    0xe, 0xff, 0x1f, 0xf6, 0xaf, 0xc4, 0xff, 0xa0,
    0xe, 0xff, 0xf, 0xf5, 0x9f, 0xb3, 0xff, 0xa0,
    0xe, 0xff, 0xf, 0xf5, 0x9f, 0xb3, 0xff, 0xa0,
    0xe, 0xff, 0xf, 0xf5, 0x9f, 0xb3, 0xff, 0xa0,
    0xe, 0xff, 0xf, 0xf5, 0x9f, 0xb3, 0xff, 0xa0,
    0xe, 0xff, 0xf, 0xf5, 0x9f, 0xb3, 0xff, 0xa0,
    0xe, 0xff, 0xf, 0xf5, 0x9f, 0xb3, 0xff, 0xa0,
    0xe, 0xff, 0xf, 0xf5, 0x9f, 0xb3, 0xff, 0xa0,
    0xe, 0xff, 0x1f, 0xf6, 0xaf, 0xc4, 0xff, 0xa0,
    0xd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,
    0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,
    0x0, 0x24, 0x44, 0x44, 0x44, 0x44, 0x31, 0x0,

    /* U+F304 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8a,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xff, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xff, 0xff, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x34, 0xff, 0xff, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0x44, 0xff, 0xff, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0x44, 0xff,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xff,
    0x44, 0xf4, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff,
    0xff, 0xff, 0x41, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xff, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xff, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xff, 0xff, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0xa, 0xff, 0xff,
    0xff, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xe, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xd4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0x31, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F55A "" */
    0x0, 0x0, 0x0, 0x57, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x72, 0x0, 0x0, 0x0, 0xaf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x0,
    0x0, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x70, 0x0, 0xbf, 0xff, 0xff, 0xf8,
    0xaf, 0xff, 0xa8, 0xff, 0xff, 0xf8, 0x0, 0xbf,
    0xff, 0xff, 0xfa, 0x0, 0xaf, 0xa0, 0xa, 0xff,
    0xff, 0x80, 0xbf, 0xff, 0xff, 0xff, 0xf3, 0x0,
    0x60, 0x3, 0xff, 0xff, 0xf8, 0xaf, 0xff, 0xff,
    0xff, 0xff, 0xf3, 0x0, 0x3, 0xff, 0xff, 0xff,
    0x8e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x0,
    0x9f, 0xff, 0xff, 0xf8, 0x4f, 0xff, 0xff, 0xff,
    0xff, 0xa0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0x80,
    0x4f, 0xff, 0xff, 0xff, 0xb0, 0x3, 0xe3, 0x0,
    0xbf, 0xff, 0xf8, 0x0, 0x4f, 0xff, 0xff, 0xfe,
    0x23, 0xff, 0xf3, 0x2e, 0xff, 0xff, 0x80, 0x0,
    0x4f, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xfe, 0xff,
    0xff, 0xf7, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0,
    0x3d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x90,

    /* U+F7C2 "" */
    0x0, 0x1, 0xcf, 0xff, 0xff, 0xfe, 0x60, 0x0,
    0x1c, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x0, 0xcf,
    0x47, 0xf4, 0xd8, 0x4f, 0xf5, 0xc, 0xff, 0x3,
    0xe0, 0xc5, 0xe, 0xf5, 0xcf, 0xff, 0x3, 0xe0,
    0xc5, 0xe, 0xf5, 0xff, 0xff, 0x24, 0xe2, 0xc6,
    0x2e, 0xf5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf5, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf5, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x5f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x1, 0x34,
    0x44, 0x44, 0x44, 0x42, 0x0,

    /* U+F8A2 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xff, 0x10, 0x0, 0x3e, 0x90,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xf1, 0x0, 0x4f,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0x10,
    0x5f, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xf1, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x1d, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf1, 0x3e, 0xff, 0xfe, 0xcc,
    0xcc, 0xcc, 0xcc, 0xcc, 0xca, 0x0, 0x2e, 0xff,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1d, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1b, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 144, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 144, .box_w = 3, .box_h = 12, .ofs_x = 3, .ofs_y = 0},
    {.bitmap_index = 18, .adv_w = 144, .box_w = 7, .box_h = 5, .ofs_x = 1, .ofs_y = 9},
    {.bitmap_index = 36, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 90, .adv_w = 144, .box_w = 7, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 143, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 197, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 251, .adv_w = 144, .box_w = 4, .box_h = 5, .ofs_x = 0, .ofs_y = 9},
    {.bitmap_index = 261, .adv_w = 144, .box_w = 6, .box_h = 16, .ofs_x = 3, .ofs_y = -2},
    {.bitmap_index = 309, .adv_w = 144, .box_w = 6, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 357, .adv_w = 144, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 398, .adv_w = 144, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 439, .adv_w = 144, .box_w = 9, .box_h = 1, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 444, .adv_w = 144, .box_w = 3, .box_h = 3, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 449, .adv_w = 144, .box_w = 9, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 521, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 575, .adv_w = 144, .box_w = 6, .box_h = 12, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 611, .adv_w = 144, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 659, .adv_w = 144, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 701, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 755, .adv_w = 144, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 797, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 851, .adv_w = 144, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 893, .adv_w = 144, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 941, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 995, .adv_w = 144, .box_w = 3, .box_h = 8, .ofs_x = 3, .ofs_y = 0},
    {.bitmap_index = 1007, .adv_w = 144, .box_w = 3, .box_h = 10, .ofs_x = 3, .ofs_y = -2},
    {.bitmap_index = 1022, .adv_w = 144, .box_w = 7, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1068, .adv_w = 144, .box_w = 9, .box_h = 4, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 1086, .adv_w = 144, .box_w = 7, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1132, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1186, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1240, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1294, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1348, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1402, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1456, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1510, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1564, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1618, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1672, .adv_w = 144, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1714, .adv_w = 144, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1777, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1831, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1885, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1939, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1993, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2047, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2101, .adv_w = 144, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 2164, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2218, .adv_w = 144, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2266, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2320, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2374, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2428, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2482, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2536, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2590, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2644, .adv_w = 144, .box_w = 5, .box_h = 15, .ofs_x = 3, .ofs_y = -1},
    {.bitmap_index = 2682, .adv_w = 144, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 2742, .adv_w = 144, .box_w = 5, .box_h = 15, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 2780, .adv_w = 144, .box_w = 5, .box_h = 2, .ofs_x = 2, .ofs_y = 12},
    {.bitmap_index = 2785, .adv_w = 144, .box_w = 9, .box_h = 1, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2790, .adv_w = 144, .box_w = 5, .box_h = 2, .ofs_x = 1, .ofs_y = 12},
    {.bitmap_index = 2795, .adv_w = 144, .box_w = 9, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2831, .adv_w = 144, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2890, .adv_w = 144, .box_w = 7, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2918, .adv_w = 144, .box_w = 8, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2970, .adv_w = 144, .box_w = 7, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2998, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3052, .adv_w = 144, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 3097, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3151, .adv_w = 144, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3193, .adv_w = 144, .box_w = 7, .box_h = 14, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 3242, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3296, .adv_w = 144, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3338, .adv_w = 144, .box_w = 9, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3374, .adv_w = 144, .box_w = 9, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3410, .adv_w = 144, .box_w = 9, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3446, .adv_w = 144, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 3491, .adv_w = 144, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 3536, .adv_w = 144, .box_w = 9, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3572, .adv_w = 144, .box_w = 7, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3600, .adv_w = 144, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3639, .adv_w = 144, .box_w = 9, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3675, .adv_w = 144, .box_w = 9, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3711, .adv_w = 144, .box_w = 9, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3747, .adv_w = 144, .box_w = 9, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3783, .adv_w = 144, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 3828, .adv_w = 144, .box_w = 7, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3856, .adv_w = 144, .box_w = 5, .box_h = 16, .ofs_x = 3, .ofs_y = -2},
    {.bitmap_index = 3896, .adv_w = 144, .box_w = 1, .box_h = 18, .ofs_x = 4, .ofs_y = -2},
    {.bitmap_index = 3905, .adv_w = 144, .box_w = 5, .box_h = 16, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 3945, .adv_w = 144, .box_w = 9, .box_h = 4, .ofs_x = 0, .ofs_y = 11},
    {.bitmap_index = 3963, .adv_w = 288, .box_w = 19, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4144, .adv_w = 288, .box_w = 18, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4270, .adv_w = 288, .box_w = 18, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4423, .adv_w = 288, .box_w = 18, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4549, .adv_w = 198, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4634, .adv_w = 288, .box_w = 19, .box_h = 18, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4805, .adv_w = 288, .box_w = 18, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4976, .adv_w = 324, .box_w = 21, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 5155, .adv_w = 288, .box_w = 18, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 5326, .adv_w = 324, .box_w = 21, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5473, .adv_w = 288, .box_w = 18, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 5644, .adv_w = 144, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5712, .adv_w = 216, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5817, .adv_w = 324, .box_w = 21, .box_h = 18, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 6006, .adv_w = 288, .box_w = 18, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6132, .adv_w = 252, .box_w = 12, .box_h = 17, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 6234, .adv_w = 252, .box_w = 16, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 6386, .adv_w = 252, .box_w = 16, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 6522, .adv_w = 252, .box_w = 16, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 6658, .adv_w = 252, .box_w = 12, .box_h = 17, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 6760, .adv_w = 252, .box_w = 18, .box_h = 17, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 6913, .adv_w = 180, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7001, .adv_w = 180, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7089, .adv_w = 252, .box_w = 16, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 7225, .adv_w = 252, .box_w = 16, .box_h = 4, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 7257, .adv_w = 324, .box_w = 21, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7404, .adv_w = 360, .box_w = 23, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 7623, .adv_w = 324, .box_w = 22, .box_h = 19, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 7832, .adv_w = 288, .box_w = 18, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 7985, .adv_w = 252, .box_w = 16, .box_h = 10, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 8065, .adv_w = 252, .box_w = 16, .box_h = 10, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 8145, .adv_w = 360, .box_w = 24, .box_h = 15, .ofs_x = -1, .ofs_y = -1},
    {.bitmap_index = 8325, .adv_w = 288, .box_w = 18, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8451, .adv_w = 288, .box_w = 18, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 8622, .adv_w = 288, .box_w = 19, .box_h = 19, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 8803, .adv_w = 252, .box_w = 16, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 8939, .adv_w = 252, .box_w = 16, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 9091, .adv_w = 252, .box_w = 16, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 9227, .adv_w = 180, .box_w = 13, .box_h = 19, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 9351, .adv_w = 252, .box_w = 16, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 9503, .adv_w = 252, .box_w = 16, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 9655, .adv_w = 324, .box_w = 21, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9802, .adv_w = 288, .box_w = 20, .box_h = 20, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 10002, .adv_w = 216, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 10135, .adv_w = 360, .box_w = 23, .box_h = 18, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 10342, .adv_w = 360, .box_w = 23, .box_h = 12, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 10480, .adv_w = 360, .box_w = 23, .box_h = 12, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 10618, .adv_w = 360, .box_w = 23, .box_h = 12, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 10756, .adv_w = 360, .box_w = 23, .box_h = 12, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 10894, .adv_w = 360, .box_w = 23, .box_h = 12, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 11032, .adv_w = 360, .box_w = 23, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 11205, .adv_w = 252, .box_w = 14, .box_h = 19, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 11338, .adv_w = 252, .box_w = 16, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 11490, .adv_w = 288, .box_w = 19, .box_h = 19, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 11671, .adv_w = 360, .box_w = 23, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11832, .adv_w = 216, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 11965, .adv_w = 290, .box_w = 19, .box_h = 12, .ofs_x = 0, .ofs_y = 1}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static const uint16_t unicode_list_2[] = {
    0x0, 0x7, 0xa, 0xb, 0xc, 0x10, 0x12, 0x14,
    0x18, 0x1b, 0x20, 0x25, 0x26, 0x27, 0x3d, 0x47,
    0x4a, 0x4b, 0x4c, 0x50, 0x51, 0x52, 0x53, 0x66,
    0x67, 0x6d, 0x6f, 0x70, 0x73, 0x76, 0x77, 0x78,
    0x7a, 0x92, 0x94, 0xc3, 0xc4, 0xc6, 0xe6, 0xe9,
    0xf2, 0x11b, 0x123, 0x15a, 0x1ea, 0x23f, 0x240, 0x241,
    0x242, 0x243, 0x286, 0x292, 0x2ec, 0x303, 0x559, 0x7c1,
    0x8a1
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 12, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 45, .range_length = 82, .glyph_id_start = 13,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 61441, .range_length = 2210, .glyph_id_start = 95,
        .unicode_list = unicode_list_2, .glyph_id_ofs_list = NULL, .list_length = 57, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    }
};



/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

/*Store all the custom data of the font*/
static lv_font_fmt_txt_dsc_t font_dsc = {
    .glyph_bitmap = gylph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = NULL,
    .kern_scale = 0,
    .cmap_num = 3,
    .bpp = 4,
    .kern_classes = 0,
    .bitmap_format = 0
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
lv_font_t lv_font_simsun_18 = {
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 20,          /*The maximum line height required by the font*/
    .base_line = 3,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
#if LV_VERSION_CHECK(7, 4, 0)
    .underline_position = -2,
    .underline_thickness = 1,
#endif
    .dsc = &font_dsc           /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
};



#endif /*#if LV_FONT_SIMSUN_18*/

