// SPDX-License-Identifier: MIT
// Copyright 2020 NXP

/*
 * custom.h
 *
 *  Created on: July 29, 2020
 *      Author: nxf53801
 */

#ifndef __CUSTOM_H_
#define __CUSTOM_H_

#include "gui_guider.h"



/*********************
 *      DEFINES
 *********************/
#define TEMPERATURE_MIN_VALUE       50      //Min value of temperature
#define TEMPERATURE_MAX_VALUE       90      //Max value of temperature
#define TEMP_ARC_BG_END_ANGLE       420
#define TEMP_ARC_BG_START_ANGLE     120

#define AUDIO_MAX_SONG_ITEM					3
/**********************
 *      TYPEDEFS
 **********************/

/* enumerate definition for temperature value operation */
typedef enum _temp_value_operate
{
    TEMP_VALUE_INCREASE,
    TEMP_VALUE_DECREASE
} temp_value_operate_t;

typedef enum _temp_mode
{
    TEMP_MODE_NULL = 0,
    TEMP_MODE_COLD,
    TEMP_MODE_AUTO,
    TEMP_MODE_WARM,
}temp_mode_t;

typedef struct _song_list_info
{
	uint32_t index;
	const char *name;
	const char *image;
	uint32_t totalTime;	
	uint8_t state;
}song_info_t;

typedef enum _audio_music_state
{
	MUSIC_PAUSE,
	MUSIC_PLAYING,
}music_state_t;

/**********************
 *      DECLARATION
 **********************/
song_info_t songInfo;
 
void custom_init(lv_ui *ui);

void btnAnimCustom(lv_obj_t *obj, int delta, lv_anim_ready_cb_t animCb);
void loadTempScreen(void);
void loadLightScreen(void);
void loadWelcomeScreen(void);
void loadSeurityArmScreen(void);
void loadAudioScreen(void);
void loadAudioListScreen(void);
void screTempSetModeBtnState(uint32_t mode);
void screTempIncreaseTempValue(void);
void screTempDecreaseTempValue(void);
void drawDegreeScaleLabelsForArc(lv_obj_t *parent, uint32_t x, uint32_t y, uint32_t r, uint32_t startAngle, uint32_t endAngle, uint32_t labelCount, char**labelString);
void screTemp_imgbtnTempOffCb(void);
void screLight_swReadingCb(void);
void screLight_swLampsCb(void);
void screLight_swCeilingCb(void);
void screLight_imgbtnAllLightOn(void);
void screLight_imgbtnAllLightOff(void);
void screAllLightOffConfirm_imgbtnDeny(void);
void screAllLightOffConfirm_imgbtnCheck(void);
void screLight_imgbtnMovie(void);
void screLight_imgbtnPalette(void);
void screLight_set_sliderCelling(void);
void screLight_set_sliderLamps(void);
void screLight_set_sliderReading(void);
void screLight_imgbtnParty(void);
void loadSecurityScreen(void);
void pinCodeInputProcess(uint8_t code);
void pinCodeDeleteProcess(void);
void pinCodeOkProcess(void);
void gotoNewMusicItem(void);
void show_screAudio(void);
void selMusicItem(uint32_t song_index);
void switchPlayerState(void);
void gotoNewMusicItem(void);
void gotoNextMusicItem(void);
void gotoPreMusicItem(void);
void loadWelcomeScreenfrAudio(void);

#endif /* EVENT_CB_H_ */
