// SPDX-License-Identifier: MIT
// Copyright 2020 NXP

/**
 * @file custom.c
 *
 */

/*********************
 *      INCLUDES
 *********************/
#include <stdio.h>
#include "lvgl/lvgl.h"
#include "custom.h"

void initAudioAlbumImgAnim(void);
void initAudioTimeIndicatorAnim(void);

/*********************
 *      DEFINES
 *********************/
#define PIN_CODE_COUNTER_MAX		4	            //Maximum value of pin code counter
#define AUDIO_IMG_ROTATION_CYCLE	10000

/**********************
 *      TYPEDEFS
 **********************/


/**********************
 *  STATIC PROTOTYPES
 **********************/

/**********************
 *  STATIC VARIABLES
 **********************/

int screenTemp_tempValue = 68;
static lv_obj_t *selectedSlider; 

uint32_t pinCodeCounter = 0;			            //counter of how many pin code have been inputed
uint32_t pinCodeValue = 0;				            //Store the pin code, one pin code value will take 8-bit
uint32_t pinCodePredefine = 0x01020304;	            //Predefine pin code value

lv_anim_t albumImgRotationAnim;
lv_anim_t	TimeIndicatorAnim;
const char *songName[AUDIO_MAX_SONG_ITEM] = {"Forever young (dance mix) ","The sound of the Shire","Save Tonight"};
uint32_t songTotalTime[AUDIO_MAX_SONG_ITEM] = {324000, 192000, 237000}; //ms
const char *songImage[AUDIO_MAX_SONG_ITEM];
/**
 * Create a demo application
 */

void custom_init(lv_ui *ui)
{
    /* Add your codes here */
}


/**
 * Draw degree scale labels for arc
 * @param parent the parent target widget
 * @param x coordinate of arc centre
 * @param y coordinate of arc centre
 * @param r distance between labels and arc centre
 * @param startAngle the start angle of arc, 0 degree is downward, clocwise,
 * @param endAngle the end angle of arc, 0 degree is downward, clocwise,
 * @param labelCount total count of labels to be created
 *            180
 *             |
 *     90  --  O   -- 270
 *             |
 *             0
 *
*/
void drawDegreeScaleLabelsForArc(lv_obj_t *parent, uint32_t x, uint32_t y, uint32_t r, uint32_t startAngle, uint32_t endAngle, uint32_t labelCount, char**labelString)
{
	uint32_t newX, newY;		//label coordinate
	lv_obj_t *label;
	char numString[10];			//string array for text
	

	for (uint32_t i = 0; i < labelCount; i++)
	{
		newX = x - r * _lv_trigo_sin(startAngle + i * (endAngle - startAngle) / (labelCount-1)) / 32767;
		newY = y + r * _lv_trigo_sin(startAngle + i * (endAngle - startAngle) / (labelCount-1) + 90) / 32767;

		label = lv_label_create(parent, NULL);
		lv_obj_set_pos(label, newX, newY);
		lv_label_set_text(label, labelString[i]);
	}
}

void screAllLightOffConfirm_imgbtnDeny(void)
{
    //Need to enable all buttons/slider/switch in screLight

    lv_obj_del(guider_ui.screAllLightOffConfirm);
}

void screAllLightOffConfirm_imgbtnCheck(void)
{
    lv_switch_off(guider_ui.screLight_swCeiling, LV_ANIM_ON);
    lv_switch_off(guider_ui.screLight_swLamps, LV_ANIM_ON);
    lv_switch_off(guider_ui.screLight_swReading, LV_ANIM_ON);

    lv_obj_del(guider_ui.screAllLightOffConfirm);
}

void screLight_imgbtnAllLightOn(void)
{
    lv_switch_on(guider_ui.screLight_swCeiling, LV_ANIM_ON);
    lv_switch_on(guider_ui.screLight_swLamps, LV_ANIM_ON);
    lv_switch_on(guider_ui.screLight_swReading, LV_ANIM_ON);
    
    lv_slider_set_value(guider_ui.screLight_sliderCeiling, 50, LV_ANIM_ON);
    lv_slider_set_value(guider_ui.screLight_sliderLamps, 50, LV_ANIM_ON);
  	lv_slider_set_value(guider_ui.screLight_sliderReading, 50, LV_ANIM_ON);
}

void screLight_imgbtnAllLightOff(void)
{
    lv_switch_off(guider_ui.screLight_swCeiling, LV_ANIM_ON);
    lv_switch_off(guider_ui.screLight_swLamps, LV_ANIM_ON);
    lv_switch_off(guider_ui.screLight_swReading, LV_ANIM_ON);

		lv_slider_set_value(guider_ui.screLight_sliderCeiling, 0, LV_ANIM_ON);
  	lv_slider_set_value(guider_ui.screLight_sliderLamps, 0, LV_ANIM_ON);
  	lv_slider_set_value(guider_ui.screLight_sliderReading, 0, LV_ANIM_ON);
    //Need to disable all buttons/slider/switch in screLight

    //setup_scr_screAllLightOffConfirm(&guider_ui);
    //lv_disp_load_scr(guider_ui.screAllLightOffConfirm);
    

}

void screLight_swCeilingCb(void)
{
    if(lv_switch_get_state(guider_ui.screLight_swCeiling) == true)
    {
        lv_slider_set_value(guider_ui.screLight_sliderCeiling, 50, LV_ANIM_ON);
    }
    else
    {
        lv_slider_set_value(guider_ui.screLight_sliderCeiling, 0, LV_ANIM_ON);
    }
    
        
}

void screLight_swLampsCb(void)
{
    if(lv_switch_get_state(guider_ui.screLight_swLamps) == true)
    {
        lv_slider_set_value(guider_ui.screLight_sliderLamps, 50, LV_ANIM_ON);
    }
    else
    {
        lv_slider_set_value(guider_ui.screLight_sliderLamps, 0, LV_ANIM_ON);
    }
}

void screLight_swReadingCb(void)
{
    if(lv_switch_get_state(guider_ui.screLight_swReading) == true)
    {
        lv_slider_set_value(guider_ui.screLight_swReading, 50, LV_ANIM_ON);
    }
    else
    {
        lv_slider_set_value(guider_ui.screLight_swReading, 0, LV_ANIM_ON);
    }
}

void screLight_imgbtnMovie(void)
{
	lv_switch_on(guider_ui.screLight_swCeiling, LV_ANIM_ON);
	lv_switch_off(guider_ui.screLight_swLamps, LV_ANIM_ON);
  lv_switch_off(guider_ui.screLight_swReading, LV_ANIM_ON);
  
  lv_slider_set_value(guider_ui.screLight_sliderCeiling, 20, LV_ANIM_ON);
  lv_slider_set_value(guider_ui.screLight_sliderLamps, 0, LV_ANIM_ON);
  lv_slider_set_value(guider_ui.screLight_sliderReading, 0, LV_ANIM_ON);
}

void screLight_imgbtnParty(void)
{
	lv_switch_on(guider_ui.screLight_swCeiling, LV_ANIM_ON);
	lv_switch_on(guider_ui.screLight_swLamps, LV_ANIM_ON);
  lv_switch_on(guider_ui.screLight_swReading, LV_ANIM_ON);
  
  lv_slider_set_value(guider_ui.screLight_sliderCeiling, 20, LV_ANIM_ON);
  lv_slider_set_value(guider_ui.screLight_sliderLamps, 80, LV_ANIM_ON);
  lv_slider_set_value(guider_ui.screLight_sliderReading, 50, LV_ANIM_ON);
}

void screLight_imgbtnPalette(void)
{
	lv_point_t mousePoint;
	uint32_t pixelIndex = 0;
  uint32_t pixelVal;
    
	lv_indev_get_point(lv_indev_get_act(), &mousePoint);
	pixelIndex = (mousePoint.y - 75 - 1) * _color_table_alpha_140x140.header.w * 3 + (mousePoint.x - 333) * 3;
  pixelVal = *(uint16_t *)&_color_table_alpha_140x140.data[pixelIndex];
  
  lv_style_t *pSliderStyle;
  static lv_style_t style_screLight_sliderCeiling_indic;
  static lv_style_t style_screLight_sliderLamps_indic;
  static lv_style_t style_screLight_sliderReading_indic;
  
  
  if(selectedSlider == guider_ui.screLight_sliderCeiling)
  {
    pSliderStyle = &style_screLight_sliderCeiling_indic;
  }
  else if(selectedSlider == guider_ui.screLight_sliderLamps)
  {
    pSliderStyle = &style_screLight_sliderLamps_indic;
  }
  else if(selectedSlider == guider_ui.screLight_sliderReading)
  {
    pSliderStyle = &style_screLight_sliderReading_indic;
  }
  else
  {
    selectedSlider = guider_ui.screLight_sliderCeiling;
    pSliderStyle = &style_screLight_sliderCeiling_indic;
  }
  lv_style_set_bg_color(pSliderStyle, LV_STATE_DEFAULT, lv_color_make(((pixelVal >> 11) << 3), ((pixelVal >> 5) & 0x3F) << 2, ((pixelVal >> 0) & 0x1F) << 3));
  lv_style_set_bg_grad_color(pSliderStyle, LV_STATE_DEFAULT, lv_color_make(((pixelVal >> 11) << 3), ((pixelVal >> 5) & 0x3F) << 2, ((pixelVal >> 0) & 0x1F) << 3));
  //lv_obj_refresh_style(selectedSlider, LV_SLIDER_PART_INDIC, LV_STYLE_PROP_ALL);
  lv_obj_add_style(selectedSlider, LV_SLIDER_PART_INDIC, pSliderStyle);
}

void screLight_set_sliderCelling(void)
{
	selectedSlider = guider_ui.screLight_sliderCeiling;
}

void screLight_set_sliderLamps(void)
{
	selectedSlider = guider_ui.screLight_sliderLamps;
}

void screLight_set_sliderReading(void)
{
	selectedSlider = guider_ui.screLight_sliderReading;
}

void screTemp_imgbtnTempOffCb(void)
{
    lv_slider_set_value(guider_ui.screenTemp_sliderFanSpeed, 0, LV_ANIM_ON);
}
void screTempUpdateArcTempControl(int tempVal)
{
    int tempArcEndAngle = (tempVal - TEMPERATURE_MIN_VALUE)*(TEMP_ARC_BG_END_ANGLE - TEMP_ARC_BG_START_ANGLE) / (TEMPERATURE_MAX_VALUE - TEMPERATURE_MIN_VALUE) + TEMP_ARC_BG_START_ANGLE;
    lv_arc_set_angles(guider_ui.screenTemp_arcTempControl, TEMP_ARC_BG_START_ANGLE, tempArcEndAngle);
}

void screTempIncreaseTempValue(void)
{
    screenTemp_tempValue = screenTemp_tempValue < TEMPERATURE_MAX_VALUE ? (screenTemp_tempValue + 1) : (screenTemp_tempValue);
    lv_label_set_text_fmt(guider_ui.screenTemp_labelTempSet, "%d", screenTemp_tempValue);
    screTempUpdateArcTempControl(screenTemp_tempValue);
}

void screTempDecreaseTempValue(void)
{
    screenTemp_tempValue = screenTemp_tempValue > TEMPERATURE_MIN_VALUE ? (screenTemp_tempValue - 1) : (screenTemp_tempValue);
    lv_label_set_text_fmt(guider_ui.screenTemp_labelTempSet, "%d", screenTemp_tempValue);
    screTempUpdateArcTempControl(screenTemp_tempValue);
}

void screTempSetModeBtnState(uint32_t mode)
{
	switch(mode)
	{
		case TEMP_MODE_COLD:
      lv_imgbtn_set_state(guider_ui.screenTemp_imgbtnAuto, LV_BTN_STATE_RELEASED);
      lv_imgbtn_set_state(guider_ui.screenTemp_imgbtnFire, LV_BTN_STATE_RELEASED);
    break;
    case TEMP_MODE_AUTO:
      lv_imgbtn_set_state(guider_ui.screenTemp_imgbtnCold, LV_BTN_STATE_RELEASED);
      lv_imgbtn_set_state(guider_ui.screenTemp_imgbtnFire, LV_BTN_STATE_RELEASED);
    break;
    case TEMP_MODE_WARM:
      lv_imgbtn_set_state(guider_ui.screenTemp_imgbtnCold, LV_BTN_STATE_RELEASED);
      lv_imgbtn_set_state(guider_ui.screenTemp_imgbtnAuto, LV_BTN_STATE_RELEASED);
    break;
    default:
    break;
  }
}

void showPasswordErrPopup(void)
{
	lv_obj_t *screSecurity_msgbPasswordErr = lv_msgbox_create(lv_scr_act(), NULL);
	lv_msgbox_set_text(screSecurity_msgbPasswordErr, "Password Error!");
	lv_obj_set_size(screSecurity_msgbPasswordErr, 200, 200);
	static const char * screSecurity_msgbPasswordErr_btns[] = {"OK",""};
	lv_msgbox_add_btns(screSecurity_msgbPasswordErr, screSecurity_msgbPasswordErr_btns);
	lv_obj_align(screSecurity_msgbPasswordErr, NULL, LV_ALIGN_CENTER, 0, 0);
}

void animSrceSecurityPasswordOK(lv_ui *ui)
{
	lv_anim_path_t lv_anim_path_SrceSecurityPasswordOK_img_1 = {.cb = lv_anim_path_linear};
	
	//Write animation: SrceSecurityPasswordOK_img_1move in y direction
	lv_anim_t SrceSecurityPasswordOK_img_1_y;
	lv_anim_init(&SrceSecurityPasswordOK_img_1_y);
	lv_anim_set_var(&SrceSecurityPasswordOK_img_1_y, ui->SrceSecurityPasswordOK_img_1);
	lv_anim_set_time(&SrceSecurityPasswordOK_img_1_y, 100);
	lv_anim_set_delay(&SrceSecurityPasswordOK_img_1_y, 2000);//added manually to delay for animat
	lv_anim_set_exec_cb(&SrceSecurityPasswordOK_img_1_y, (lv_anim_exec_xcb_t)lv_obj_set_y);
	lv_anim_set_values(&SrceSecurityPasswordOK_img_1_y, lv_obj_get_y(ui->SrceSecurityPasswordOK_img_1), 200);
	_lv_memcpy_small(&SrceSecurityPasswordOK_img_1_y.path, &lv_anim_path_SrceSecurityPasswordOK_img_1, sizeof(lv_anim_path_cb_t));
	lv_anim_set_ready_cb(&SrceSecurityPasswordOK_img_1_y, (lv_anim_ready_cb_t)loadSecurityScreen);//added mannually to call next function after animation
	lv_anim_start(&SrceSecurityPasswordOK_img_1_y);

	lv_img_set_src(ui->SrceSecurityPasswordOK_img_1,&_nxp_smart_home_10_alpha_480x272);
	lv_img_set_pivot(ui->SrceSecurityPasswordOK_img_1, 0,0);
	lv_img_set_angle(ui->SrceSecurityPasswordOK_img_1, 0);
	lv_cont_set_layout(ui->SrceSecurityPasswordOK_cont_1, LV_LAYOUT_OFF);
	lv_cont_set_fit(ui->SrceSecurityPasswordOK_cont_1, LV_FIT_NONE);
}

void loadWelcomeScreen(void)
{
    lv_obj_del(lv_scr_act());
    setup_scr_screWelcome(&guider_ui);
    lv_disp_load_scr(guider_ui.screWelcome);
}

void loadTempScreen(void)
{
    lv_obj_del(lv_scr_act());
    setup_scr_screenTemp(&guider_ui);
    lv_disp_load_scr(guider_ui.screenTemp);
    char *labelString[] = {"50", "55", "60", "65", "70", "75", "80", "85", "90"};
    drawDegreeScaleLabelsForArc(guider_ui.screenTemp_arcTempControl, 108, 108, 110, 30, 330, 9, labelString);
}

void loadLightScreen(void)
{
    lv_obj_del(lv_scr_act());
    setup_scr_screLight(&guider_ui);
    lv_disp_load_scr(guider_ui.screLight);
}

void loadSecurityScreen(void)
{
    lv_obj_del(lv_scr_act());
    setup_scr_screSecurityhome(&guider_ui);
    lv_disp_load_scr(guider_ui.screSecurityhome);
}

void loadSeurityArmScreen(void)
{
		pinCodeCounter = 0;			           
	  pinCodeValue = 0;	
		lv_obj_del(lv_scr_act());
    setup_scr_screSecurity(&guider_ui);
    lv_disp_load_scr(guider_ui.screSecurity);
}
void loadSecurityPasswordOKScreen(void)
{
		setup_scr_SrceSecurityPasswordOK(&guider_ui);
		animSrceSecurityPasswordOK(&guider_ui);
		lv_disp_load_scr(guider_ui.SrceSecurityPasswordOK);
}

void loadAudioScreen(void)
{
    lv_obj_del(lv_scr_act());
    setup_scr_screAudio(&guider_ui);
    initAudioAlbumImgAnim();
    initAudioTimeIndicatorAnim();
    lv_disp_load_scr(guider_ui.screAudio);
    
    songInfo.index = 0;
    songInfo.name = songName[0];
    songImage[0] = lv_img_get_src(guider_ui.screAudio_imgAudioBackground);
    songImage[1] = lv_img_get_src(guider_ui.screAudio_imgAudioBackground_1);
    songImage[2] = lv_img_get_src(guider_ui.screAudio_imgAudioBackground_2);
		songInfo.image = songImage[0];
		songInfo.totalTime = songTotalTime[0];
		songInfo.state = MUSIC_PAUSE;
}

void loadAudioListScreen(void)
{
	lv_obj_del(lv_scr_act());
	setup_scr_screAudioList(&guider_ui);
	lv_disp_load_scr(guider_ui.screAudioList);
}

void btnAnimCustom(lv_obj_t *obj, int delta, lv_anim_ready_cb_t animCb)
{
    lv_anim_t a; 
    
    //Initialize an animation variable
    lv_anim_init(&a);
    //Set the function "lv_obj_set_y()" to set the y coordinate in animation
    lv_anim_set_exec_cb(&a, (lv_anim_exec_xcb_t)lv_obj_set_y);
    //Set the object for animation
		lv_anim_set_var(&a, obj);
		//Set the duration of animation to 100ms
    lv_anim_set_time(&a, 100);
    //Get the current y coordinate
    int y = lv_obj_get_y(obj);
    //Set the start and end value of the animation on y coordinate
    lv_anim_set_values(&a, y, y+delta);
    //Set the duration of animation to play back to 100ms
    lv_anim_set_playback_time(&a, 100);
		lv_anim_set_delay(&a, 0);
    if(animCb)
    {//Set the function call when the animation is ready
        lv_anim_set_ready_cb(&a, animCb);
    }
    //Create the animation
    lv_anim_start(&a);
}

void pinCodeInputProcess(uint8_t code)
{
	pinCodeCounter++;						//counter increase by 1
	if (pinCodeCounter <= PIN_CODE_COUNTER_MAX)
	{
		pinCodeValue <<= 8;	//bit shift
		pinCodeValue |= code;					//XOR the code inputed
		
		if (pinCodeCounter == 1)
		{
			lv_label_set_text(guider_ui.screSecurity_labelPinNum1, "*");
		}
		else if (pinCodeCounter == 2)
		{
			lv_label_set_text(guider_ui.screSecurity_labelPinNum2, "*");
		}
		else if (pinCodeCounter == 3)
		{
			lv_label_set_text(guider_ui.screSecurity_labelPinNum3, "*");
		}
		else if (pinCodeCounter == 4)
		{
			lv_label_set_text(guider_ui.screSecurity_labelPinNum4, "*");
		}
		else
		{
			//printf("error");
		}

	}
}

void pinCodeDeleteProcess(void)
{
	if (pinCodeCounter > 0)
	{
		if (pinCodeCounter == 1)
		{
			lv_label_set_text(guider_ui.screSecurity_labelPinNum1, "");
		}
		else if (pinCodeCounter == 2)
		{
			lv_label_set_text(guider_ui.screSecurity_labelPinNum2, "");
		}
		else if (pinCodeCounter == 3)
		{
			lv_label_set_text(guider_ui.screSecurity_labelPinNum3, "");
		}
		else if (pinCodeCounter == 4)
		{
			lv_label_set_text(guider_ui.screSecurity_labelPinNum4, "");
		}

		pinCodeCounter--;		//pin code counter decrease
		pinCodeValue >>= 8;		//udpate pin code value
	}
}

void pinCodeOkProcess(void)
{
	if (pinCodeCounter == PIN_CODE_COUNTER_MAX)
	{
		if (pinCodeValue == pinCodePredefine)
		{
			pinCodeCounter = 0;
			pinCodeValue = 0;
			loadSecurityPasswordOKScreen();
		}
		else
		{
			showPasswordErrPopup();
		}
	}
  else
  {
  	showPasswordErrPopup();  
  }
}
/*------------------ Audio control ---------------------*/
void initAudioAlbumImgAnim(void)
{
	//rotation animation   
  lv_anim_init(&albumImgRotationAnim);

  lv_anim_set_exec_cb(&albumImgRotationAnim, (lv_anim_exec_xcb_t)lv_img_set_angle);
  lv_anim_set_var(&albumImgRotationAnim, guider_ui.screAudio_imgAudioBackground);
  lv_anim_set_time(&albumImgRotationAnim, AUDIO_IMG_ROTATION_CYCLE);
  lv_anim_set_repeat_count(&albumImgRotationAnim, 1000);
  lv_anim_set_values(&albumImgRotationAnim, 0, 3600);
  lv_anim_set_delay(&albumImgRotationAnim, 0);
    
  if(songInfo.state == MUSIC_PLAYING)
  {
    lv_anim_start(&albumImgRotationAnim);
  }
}
void initAudioTimeIndicatorAnim(void)
{
	//rotation animation   
  lv_anim_init(&TimeIndicatorAnim);

  lv_anim_set_exec_cb(&TimeIndicatorAnim, (lv_anim_exec_xcb_t)lv_arc_set_end_angle);
  lv_anim_set_var(&TimeIndicatorAnim, guider_ui.screAudio_arcAudioControl);
  lv_anim_set_time(&TimeIndicatorAnim, songTotalTime[0]);
  lv_anim_set_repeat_count(&TimeIndicatorAnim, 1000);
  lv_anim_set_values(&TimeIndicatorAnim, 145, 395);

  //lv_anim_set_playback_time(&a, animDur);
  lv_anim_set_delay(&TimeIndicatorAnim, 0);
    
  if(songInfo.state == MUSIC_PLAYING)
  {
    lv_anim_start(&TimeIndicatorAnim);
  }
}
void setAudioSonginfo(uint32_t index, uint8_t state)
{	
	songInfo.index = index;
	songInfo.name = songName[index];
	songInfo.image = songImage[index];
	songInfo.totalTime = songTotalTime[index];
	songInfo.state = state;
}

void selMusicItem(uint32_t song_index)
{
	setAudioSonginfo(song_index, songInfo.state);
}

void updatePlayerState(void)
{
	if(songInfo.state == MUSIC_PAUSE)
	{
		lv_imgbtn_set_src(guider_ui.screAudio_imgbtnAudioPlay,LV_BTN_STATE_RELEASED,&_btn_play_alpha_48x48);
		lv_anim_del(guider_ui.screAudio_imgAudioBackground, lv_img_set_angle);
		lv_anim_del(guider_ui.screAudio_arcAudioControl, lv_arc_set_end_angle);
	}
	else
	{
		lv_imgbtn_set_src(guider_ui.screAudio_imgbtnAudioPlay,LV_BTN_STATE_RELEASED,&_pause_alpha_48x48);	
		lv_anim_start(&albumImgRotationAnim);//start img to rotate
		lv_anim_start(&TimeIndicatorAnim);//start time indicator(arc) to rotate 
	}  
}

void switchPlayerState(void)
{
		
	if(songInfo.state == MUSIC_PLAYING)
  {
  	songInfo.state = MUSIC_PAUSE;
  }
  else
  {
  	songInfo.state = MUSIC_PLAYING;
  	
  	uint32_t angle = lv_img_get_angle(guider_ui.screAudio_imgAudioBackground);
		lv_anim_set_values(&albumImgRotationAnim, angle, angle+3600);
		
		uint32_t arc_angle = lv_arc_get_angle_end(guider_ui.screAudio_arcAudioControl);
		lv_anim_set_values(&TimeIndicatorAnim, arc_angle, 395);
  }
  
  updatePlayerState();
}

void gotoNewMusicItem(void)
{
	//set label of song name
	lv_label_set_text(guider_ui.screAudio_labelSongname, songInfo.name);
	
	//set album img
	lv_img_set_src(guider_ui.screAudio_imgAudioBackground, songInfo.image);
	
	//set arc process
	lv_anim_set_values(&TimeIndicatorAnim, 145, 395);
	lv_arc_set_angles(guider_ui.screAudio_arcAudioControl, 145, 145);
	
	//set image animation
	lv_anim_set_values(&albumImgRotationAnim, 0, 3600);
	lv_img_set_angle(guider_ui.screAudio_imgAudioBackground, 0);
	
	updatePlayerState();
}

void gotoNextMusicItem(void)
{
	if(songInfo.index < AUDIO_MAX_SONG_ITEM-1)
	{
		songInfo.index++;
	}
	else 
	{
		songInfo.index = 0;
	}
	selMusicItem(songInfo.index);
	gotoNewMusicItem();
}

void gotoPreMusicItem(void)
{
	if(songInfo.index > 0)
	{
		songInfo.index--;
	}
	else 
	{
		songInfo.index = AUDIO_MAX_SONG_ITEM-1;
	}
	selMusicItem(songInfo.index);
	gotoNewMusicItem();
}

void show_screAudio(void)
{
	lv_obj_del(lv_scr_act());
  setup_scr_screAudio(&guider_ui);
  initAudioAlbumImgAnim();
  initAudioTimeIndicatorAnim();
	gotoNewMusicItem();
	lv_disp_load_scr(guider_ui.screAudio);
}

void loadWelcomeScreenfrAudio(void)
{
	setAudioSonginfo(0, MUSIC_PAUSE);
	loadWelcomeScreen();
}