#!/usr/bin/env python
# coding: utf-8

# In[60]:


import numpy as np
import matplotlib.pyplot as plt
from keras.utils import to_categorical
import keras
from PIL import Image


# In[61]:


mnist = keras.datasets.mnist

(x_train, y_train), (x_test0, y_test) = mnist.load_data()
x_test =  x_test0 / 255.0
x_test = np.expand_dims(x_test, 3)

y_test = to_categorical(y_test)

random_number = np.random.randint(x_test.shape[0])
print('\r\nChoosing a random number... ' + str(random_number))


# In[62]:


x_test[random_number,0].shape


# In[63]:


img = Image.fromarray(x_test0[random_number], 'L')
img.save('current_test_image.png')
#img.show()


# In[64]:






# In[65]:


model = keras.models.load_model('MNIST_NXP.h5')
model.summary()

print('\r\n')
print(y_test[random_number])
print('\r\n')


# In[71]:


prediction = model.predict(np.expand_dims(x_test[random_number], axis=0))
print('\r\n')
print('Prediction:')
print(prediction)

