#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <linux/dma-buf.h>
#include <linux/types.h>
#include <stdint.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/time.h>
#include <time.h>
#include <bits/types/struct_timespec.h>
#include <bits/types/struct_timeval.h>
#include <linux/videodev2.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <pthread.h>
#define   CAPTURE_BUF_SIZE     4

static const char *Video_Name3 = "/dev/video3";
static const char *Video_Name4 = "/dev/video4";
#define Video_Width3     1920
#define Video_Height3    1080
#define Video_Width4     640
#define Video_Height4    480

#define CLEAR(x) memset(&(x), 0, sizeof(x))

uint8_t* g_buffer =NULL;

#define PAD_TO_WORD(a)  (((a)+3)&~3)

typedef struct _V4L2_BufferRecord
{
	int       mValid;
	void*     mStart;
	int       mOffset;
	int       mLength;
	int       mIndex;
	int 	  fd;
}V4L2_BufferRecord;

V4L2_BufferRecord  v4l2_buffer_record3[CAPTURE_BUF_SIZE];
V4L2_BufferRecord  v4l2_buffer_record_UV[CAPTURE_BUF_SIZE];
V4L2_BufferRecord  v4l2_buffer_record4[CAPTURE_BUF_SIZE];
int DumpNV12(char *frameY, int YbufferSize,char *frameUV, int UVbufferSize,int id)
{
	char buf[128];
	snprintf(buf, sizeof(buf), "video3_%d.yuv",id);

	int file_fd = open(buf, O_RDWR | O_CREAT, 0777);
	write(file_fd, (void *)(frameY), YbufferSize);
	write(file_fd, (void *)(frameUV), UVbufferSize);
	close(file_fd);
	return 0;
}
typedef struct MyBITMAPFILEHEADER_ST
{
	unsigned int   bfSize;
	unsigned short bfReserved1;
	unsigned short bfReserved2;
	unsigned int   bfOffBits;
}MyBITMAPFILEHEADER;

typedef struct MyBITMAPINFOHEADER_ST
{
    unsigned int   biSize;
    int            biWidth;
    int            biHeight;
    unsigned short biPlanes;
    unsigned short biBitCount;
    unsigned int   biCompression;
    unsigned int   biSizeImage;
    int            biXPelsPerMeter;
    int            biYPelsPerMeter;
    unsigned int   biClrUsed;
    unsigned int   biClrImportant;
}MyBITMAPINFOHEADER;

int DumpRGB(char *frame, int bufferSize,int id)
{
    MyBITMAPFILEHEADER bfh;
    MyBITMAPINFOHEADER bih;
    unsigned short bfType = 0x4d42;
    bfh.bfReserved1 = 0;
    bfh.bfReserved2 = 0;
    bfh.bfSize = 2 + sizeof(MyBITMAPFILEHEADER) + sizeof(MyBITMAPINFOHEADER) + Video_Width4*Video_Height4 * 3;
    bfh.bfOffBits = 0x36;

    bih.biSize = sizeof(MyBITMAPINFOHEADER);
    bih.biWidth = Video_Width4;
    bih.biHeight = -Video_Height4;
    bih.biPlanes = 1;
    bih.biBitCount = 24;
    bih.biCompression = 0;
    bih.biSizeImage = 0;
    bih.biXPelsPerMeter = 5000;
    bih.biYPelsPerMeter = 5000;
    bih.biClrUsed = 0;
    bih.biClrImportant = 0;
    FILE* file;
	char buf[128];
	snprintf(buf, sizeof(buf), "video4_%d.bmp",id);
    file = fopen(buf, "wb");
	if (!file)
	{
		printf("video4 Could not write file\n");
		return -1;
	}
    fwrite(&bfType, sizeof(bfType), 1, file);
    fwrite(&bfh, sizeof(bfh), 1, file);
    fwrite(&bih, sizeof(bih), 1, file);

    fwrite(frame, Video_Width4*Video_Height4 * 3, 1, file);
    fclose(file);
	return 0;
}
char* getSysTime() 
{ 
    struct timeval    tv; 
    struct timezone tz; 
    char* timeStr = malloc(128);
    struct tm         *p; 
       
    gettimeofday(&tv, &tz); 
       
    p = localtime(&tv.tv_sec); 
    sprintf(timeStr, "[%d-%d-%d:%d:%d:%d:%d]", 1900+p->tm_year, 1+p->tm_mon, p->tm_mday, p->tm_hour, p->tm_min, p->tm_sec, tv.tv_usec); 
	return timeStr;
} 
static int cnt3 = 0;
struct timeval  lastTimestamp3;
void *threadloop3()
{
	int ret,i;
    printf("threadloop3\n");
    int video_fd = open(Video_Name3, O_RDWR, 0);
    if(video_fd <= -1){
        printf("[threadloop3][%s](%d) Open %s Failed\n", __FUNCTION__, __LINE__, Video_Name3);
        return NULL;
    }else{
        printf("[threadloop3][%s](%d) Open %s Success ^_^\n", __FUNCTION__, __LINE__, Video_Name3);
    }

    struct v4l2_capability caps;
    ret = ioctl(video_fd, VIDIOC_QUERYCAP, &caps);
    if(ret < 0){
        printf("[threadloop3][%s](%d) failed to get device caps for %s (%d = %s)",__FUNCTION__, __LINE__, 
                Video_Name3, errno, strerror(errno));
        close(video_fd);
        return NULL;
    }

	printf("[threadloop3] Open Device: %s (fd=%d)\n", Video_Name3, video_fd);
	printf("[threadloop3]		Driver: %s\n", caps.driver);
	printf("[threadloop3]		Card: %s\n", caps.card);
	printf("[threadloop3]		Version: %u.%u.%u\n",
							        (caps.version >> 16) & 0xFF,
							        (caps.version >> 8)  & 0xFF,
							        (caps.version)       & 0xFF);
	printf("[threadloop3]		All Caps: %08X\n", caps.capabilities);
	printf("[threadloop3]		Dev Caps: %08X\n", caps.device_caps);

	printf("[threadloop3]Supported capture formats:\n");
    struct v4l2_fmtdesc formatDescriptions;
	formatDescriptions.type = V4L2_BUF_TYPE_VIDEO_CAPTURE_MPLANE;
	for (i = 0;; i++) 
	{
		formatDescriptions.index = i;
		if (ioctl(video_fd, VIDIOC_ENUM_FMT, &formatDescriptions) == 0) 
		{
			printf("[threadloop3]  %2d: %s 0x%08X 0x%X\n",
						       i,
						       formatDescriptions.description,
						       formatDescriptions.pixelformat,
						       formatDescriptions.flags	);
		} 
		else 
		{
			break;
		}
	}

	if (!(caps.capabilities & V4L2_CAP_VIDEO_CAPTURE_MPLANE) || !(caps.capabilities & V4L2_CAP_STREAMING)) 
	{
		printf("[threadloop3][%s]  Streaming capture not supported by %s.\n", __FUNCTION__, Video_Name3);	
        close(video_fd);
        return NULL;
	}

	struct v4l2_format format;
    memset(&format, 0, sizeof(format));
	format.type = V4L2_BUF_TYPE_VIDEO_CAPTURE_MPLANE;
	format.fmt.pix_mp.width = Video_Width3;
	format.fmt.pix_mp.height = Video_Height3;
	format.fmt.pix_mp.pixelformat = V4L2_PIX_FMT_NV12;//V4L2_PIX_FMT_YUYV;
	format.fmt.pix_mp.field = V4L2_FIELD_NONE;
	printf("Requesting format %c%c%c%c (0x%08X)\n",
								      ((char*)&format.fmt.pix.pixelformat)[0],
								      ((char*)&format.fmt.pix.pixelformat)[1],
								      ((char*)&format.fmt.pix.pixelformat)[2],
								      ((char*)&format.fmt.pix.pixelformat)[3],
								      format.fmt.pix.pixelformat);
    
    if (ioctl(video_fd, VIDIOC_S_FMT, &format) < 0) 
	{
		printf("[threadloop3][%s]  VIDIOC_S_FMT failed! %s.\n", __FUNCTION__, strerror(errno));
		close(video_fd);
        return NULL;
	}

    memset(&format, 0, sizeof(format));
    format.type = V4L2_BUF_TYPE_VIDEO_CAPTURE_MPLANE;
    if (ioctl(video_fd, VIDIOC_G_FMT, &format) == 0)
    {
        printf("[threadloop3][%s] Current output format:  fmt=0x%X, %dx%d\n", __FUNCTION__,
               format.fmt.pix_mp.pixelformat,
               format.fmt.pix_mp.width,
               format.fmt.pix_mp.height
        );
    } else {
        printf("[threadloop3] VIDIOC_G_FMT: %s", strerror(errno));
        close(video_fd);
        return NULL;
    }

    struct v4l2_requestbuffers bufrequest;
    CLEAR(bufrequest);
    bufrequest.type = V4L2_BUF_TYPE_VIDEO_CAPTURE_MPLANE;
	bufrequest.memory =  V4L2_MEMORY_MMAP; 
    bufrequest.count = CAPTURE_BUF_SIZE;

    if (ioctl(video_fd, VIDIOC_REQBUFS, &bufrequest) < 0) {
        printf("[threadloop3] VIDIOC_REQBUFS: %s", strerror(errno));
        close(video_fd);
        return NULL;
    }

    struct v4l2_buffer buffer;
    struct v4l2_plane  planes[2];
	int pmem_fd[CAPTURE_BUF_SIZE];

    memset(v4l2_buffer_record3, 0, sizeof(v4l2_buffer_record3));
	memset(v4l2_buffer_record_UV, 0, sizeof(v4l2_buffer_record_UV));
    for(i = 0; i < CAPTURE_BUF_SIZE; i++){
        CLEAR(buffer);
        CLEAR(planes[0]);
		CLEAR(planes[1]);
        buffer.type     = V4L2_BUF_TYPE_VIDEO_CAPTURE_MPLANE;
        buffer.memory   = V4L2_MEMORY_MMAP;
        buffer.index    = i;
        buffer.length   = 2;		// NV12 use 2 plane/yuyv only use 1 plane
        buffer.m.planes = &planes[0];

        if (ioctl(video_fd, VIDIOC_QUERYBUF, &buffer) < 0) {
            printf("[threadloop3] VIDIOC_QUERYBUF: %s", strerror(errno));
            close(video_fd);
            return NULL;
        }
        v4l2_buffer_record3[i].mLength =  buffer.m.planes->length;
        v4l2_buffer_record3[i].mOffset = (size_t)buffer.m.planes->m.mem_offset;;
        v4l2_buffer_record3[i].mIndex  = i;

        v4l2_buffer_record3[i].mStart = mmap (NULL, v4l2_buffer_record3[i].mLength, 
                                            PROT_READ | PROT_WRITE, MAP_SHARED, video_fd, 
                                            v4l2_buffer_record3[i].mOffset);
        if (v4l2_buffer_record3[i].mStart == MAP_FAILED) {
            printf("[threadloop3] mmap failed!!!!!");
            close(video_fd);
            return NULL;
        }
		printf("[threadloop3] Buffer description:");
		printf("[threadloop3]  index : %d", v4l2_buffer_record3[i].mIndex);
		printf("[threadloop3]  offset: %d", v4l2_buffer_record3[i].mOffset);
		printf("[threadloop3]  length: %d", v4l2_buffer_record3[i].mLength);
		printf("[threadloop3]  map start at %p", v4l2_buffer_record3[i].mStart);
    }

   for(i = 0; i < CAPTURE_BUF_SIZE; i++)
	{
		memset(&buffer, 0, sizeof(buffer));
        CLEAR(planes);

		buffer.type     = V4L2_BUF_TYPE_VIDEO_CAPTURE_MPLANE;
		buffer.m.planes = &planes[0];
		buffer.memory =  V4L2_MEMORY_MMAP; 
		buffer.m.planes->length   = v4l2_buffer_record3[i].mLength;
		buffer.m.planes->m.mem_offset = 0;
		buffer.index    = i;
        buffer.length   = 2; //NV12 use 2 plane

        printf("[threadloop3] VIDIOC_QBUF index=%d, length=%d \n", buffer.index, buffer.length);
		if (ioctl (video_fd, VIDIOC_QBUF, &buffer) < 0) 
		{
			printf("[threadloop3] %s  VIDIOC_QBUF failed! %s.", __FUNCTION__, strerror(errno));
			close(video_fd);
            return NULL;
		}
	}

	{
        enum v4l2_buf_type type;
		
        type = V4L2_BUF_TYPE_VIDEO_CAPTURE_MPLANE;
        if (ioctl(video_fd, VIDIOC_STREAMON, &type) < 0) 
        {
            printf("[threadloop3] %s  VIDIOC_STREAMON failed! %s.\n", __FUNCTION__, strerror(errno));
            close(video_fd);
            return NULL;
        }
        printf("[native_camera] %s  stream on END!!!", __FUNCTION__);
    }

	for(;;)  
	{
		struct v4l2_buffer buffer;
        struct v4l2_plane planes[2];

        CLEAR(buffer);
        CLEAR(planes[0]);
		CLEAR(planes[1]);
		char* str = getSysTime();
		free(str);
		memset(&buffer, 0, sizeof(buffer));

		buffer.type     = V4L2_BUF_TYPE_VIDEO_CAPTURE_MPLANE;
		buffer.memory =  V4L2_MEMORY_MMAP; 

        buffer.m.planes = &planes[0];
        buffer.length   = 2;   //2;

		if (ioctl(video_fd, VIDIOC_DQBUF, &buffer) < 0) {
			printf("[threadloop3] %s  VIDIOC_DQBUF failed! %s.\n", __FUNCTION__, strerror(errno));
			close(video_fd);
            return NULL;
		}
		str = getSysTime();	
		if(cnt3 % 30 == 0)
		{
			long diff = (buffer.timestamp.tv_sec - lastTimestamp3.tv_sec)*1000 + 
						(buffer.timestamp.tv_usec - lastTimestamp3.tv_usec)/1000;
			printf("%d[video3-fID:%d]%s %s Y/UVframe size=%d/%d fps =%2f ts=%ld\n", buffer.index, cnt3, str, __FUNCTION__, 
					v4l2_buffer_record3[buffer.index].mLength, v4l2_buffer_record3[buffer.index].mLength, 30000.0/diff, buffer.timestamp);
			lastTimestamp3 = buffer.timestamp;
		}
		//usleep(100000); test fps, will reduce fps to 10
		cnt3++;
		free(str);
		if(cnt3 % 100 == 0)
		{
			DumpNV12(v4l2_buffer_record3[buffer.index].mStart, v4l2_buffer_record3[buffer.index].mLength,
					v4l2_buffer_record_UV[buffer.index].mStart, v4l2_buffer_record_UV[buffer.index].mLength, cnt3);
		}
		if (ioctl(video_fd, VIDIOC_QBUF, &buffer) < 0) {
			printf("[threadloop3] %s  VIDIOC_QBUF failed! %s.\n", __FUNCTION__, strerror(errno));
			close(video_fd);
            return NULL;
		}
	}


	{
        enum v4l2_buf_type type;
		
        type = V4L2_BUF_TYPE_VIDEO_CAPTURE_MPLANE;
        if (ioctl(video_fd, VIDIOC_STREAMOFF, &type) < 0) 
        {
            printf("[threadloop3] %s  VIDIOC_STREAMOFF failed! %s.", __FUNCTION__, strerror(errno));
            close(video_fd);
            return NULL;
        }
        printf("[threadloop3] %s  stream OFF END!!!", __FUNCTION__);
    }

    CLEAR(bufrequest);
    bufrequest.type = V4L2_BUF_TYPE_VIDEO_CAPTURE_MPLANE;
	bufrequest.memory =  V4L2_MEMORY_MMAP; 
    bufrequest.count = 0;

    if (ioctl(video_fd, VIDIOC_REQBUFS, &bufrequest) < 0) {
        printf("[threadloop3] VIDIOC_REQBUFS: %s", strerror(errno));
        close(video_fd);
        return NULL;
    }

    for(i = 0; i < CAPTURE_BUF_SIZE; i++){
		if(v4l2_buffer_record3[i].mStart != NULL){
			uint32_t size = (v4l2_buffer_record3[i].mLength + 4095) & (~4095);
			if(munmap(v4l2_buffer_record3[i].mStart, size) < 0){
				printf("[threadloop3] munmapped Y size = %zu, virt_addr = 0x%p  Failed \n", size, v4l2_buffer_record3[i].mStart);
			}else{
				printf("[threadloop3] munmapped Y size = %zu, virt_addr = 0x%p, fd=%d Success\n", size, v4l2_buffer_record3[i].mStart, v4l2_buffer_record3[i].fd);
			}

			size = (v4l2_buffer_record_UV[i].mLength + 4095) & (~4095);
			if(munmap(v4l2_buffer_record_UV[i].mStart, size) < 0){
				printf("[threadloop3] munmapped UV size = %zu, virt_addr = 0x%p  Failed \n", size, v4l2_buffer_record_UV[i].mStart);
			}else{
				printf("[threadloop3] munmapped UV size = %zu, virt_addr = 0x%p, fd=%d Success\n", size, v4l2_buffer_record_UV[i].mStart, v4l2_buffer_record_UV[i].fd);
			}

			if(v4l2_buffer_record3[i].fd >= 0){
				if( close(v4l2_buffer_record3[i].fd) < 0 ){
					printf("[threadloop3] close(%d) failed, error=%s", v4l2_buffer_record3[i].fd, strerror(errno));
				}else{
					printf("[threadloop3] close(%d) success", v4l2_buffer_record3[i].fd);
				}
				v4l2_buffer_record3[i].fd = -1;
			}	

			if(v4l2_buffer_record_UV[i].fd >= 0){
				if( close(v4l2_buffer_record_UV[i].fd) < 0 ){
					printf("[threadloop3] close(%d) failed, error=%s", v4l2_buffer_record_UV[i].fd, strerror(errno));
				}else{
					printf("[threadloop3] close(%d) success", v4l2_buffer_record_UV[i].fd);
				}
				v4l2_buffer_record_UV[i].fd = -1;
			}	
		}
	}
    return NULL;

}

static int cnt4 = 0;
struct timeval  lastTimestamp4;
void *threadloop4()
{
	int ret,i;
    printf("threadloop4\n");
    int video_fd = open(Video_Name4, O_RDWR, 0);
    if(video_fd <= -1){
        printf("[threadloop4][%s](%d) Open %s Failed\n", __FUNCTION__, __LINE__, Video_Name4);
        return NULL;
    }else{
        printf("[threadloop4][%s](%d) Open %s Success ^_^\n", __FUNCTION__, __LINE__, Video_Name4);
    }

    struct v4l2_capability caps;
    ret = ioctl(video_fd, VIDIOC_QUERYCAP, &caps);
    if(ret < 0){
        printf("[threadloop4][%s](%d) failed to get device caps for %s (%d = %s)",__FUNCTION__, __LINE__, 
                Video_Name4, errno, strerror(errno));
        close(video_fd);
        return NULL;
    }

	printf("[threadloop4] Open Device: %s (fd=%d)\n", Video_Name4, video_fd);
	printf("[threadloop4]		Driver: %s\n", caps.driver);
	printf("[threadloop4]		Card: %s\n", caps.card);
	printf("[threadloop4]		Version: %u.%u.%u\n",
							        (caps.version >> 16) & 0xFF,
							        (caps.version >> 8)  & 0xFF,
							        (caps.version)       & 0xFF);
	printf("[threadloop4]		All Caps: %08X\n", caps.capabilities);
	printf("[threadloop4]		Dev Caps: %08X\n", caps.device_caps);

	printf("[threadloop4]Supported capture formats:\n");
    struct v4l2_fmtdesc formatDescriptions;
	formatDescriptions.type = V4L2_BUF_TYPE_VIDEO_CAPTURE_MPLANE;
	for (i = 0;; i++) 
	{
		formatDescriptions.index = i;
		if (ioctl(video_fd, VIDIOC_ENUM_FMT, &formatDescriptions) == 0) 
		{
			printf("[threadloop4]  %2d: %s 0x%08X 0x%X\n",
						       i,
						       formatDescriptions.description,
						       formatDescriptions.pixelformat,
						       formatDescriptions.flags	);
		} 
		else 
		{
			break;
		}
	}

	if (!(caps.capabilities & V4L2_CAP_VIDEO_CAPTURE_MPLANE) || !(caps.capabilities & V4L2_CAP_STREAMING)) 
	{
		printf("[threadloop4][%s]  Streaming capture not supported by %s.\n", __FUNCTION__, Video_Name4);	
        close(video_fd);
        return NULL;
	}

	struct v4l2_format format;
    memset(&format, 0, sizeof(format));
	format.type = V4L2_BUF_TYPE_VIDEO_CAPTURE_MPLANE;
	format.fmt.pix_mp.width = Video_Width4;
	format.fmt.pix_mp.height = Video_Height4;
	format.fmt.pix_mp.pixelformat = V4L2_PIX_FMT_RGB24;
	format.fmt.pix_mp.field = V4L2_FIELD_NONE;
	printf("Requesting format %c%c%c%c (0x%08X)\n",
								      ((char*)&format.fmt.pix.pixelformat)[0],
								      ((char*)&format.fmt.pix.pixelformat)[1],
								      ((char*)&format.fmt.pix.pixelformat)[2],
								      ((char*)&format.fmt.pix.pixelformat)[3],
								      format.fmt.pix.pixelformat);
    
    if (ioctl(video_fd, VIDIOC_S_FMT, &format) < 0) 
	{
		printf("[threadloop4][%s]  VIDIOC_S_FMT failed! %s.\n", __FUNCTION__, strerror(errno));
		close(video_fd);
        return NULL;
	}

    memset(&format, 0, sizeof(format));
    format.type = V4L2_BUF_TYPE_VIDEO_CAPTURE_MPLANE;
    if (ioctl(video_fd, VIDIOC_G_FMT, &format) == 0)
    {
        printf("[threadloop4][%s] Current output format:  fmt=0x%X, %dx%d\n", __FUNCTION__,
               format.fmt.pix_mp.pixelformat,
               format.fmt.pix_mp.width,
               format.fmt.pix_mp.height
        );
    } else {
        printf("[threadloop4] VIDIOC_G_FMT: %s", strerror(errno));
        close(video_fd);
        return NULL;
    }

    struct v4l2_requestbuffers bufrequest;
    CLEAR(bufrequest);
    bufrequest.type = V4L2_BUF_TYPE_VIDEO_CAPTURE_MPLANE;
	bufrequest.memory =  V4L2_MEMORY_MMAP; 

    bufrequest.count = CAPTURE_BUF_SIZE;

    if (ioctl(video_fd, VIDIOC_REQBUFS, &bufrequest) < 0) {
        printf("[threadloop4] VIDIOC_REQBUFS: %s", strerror(errno));
        close(video_fd);
        return NULL;
    }

    struct v4l2_buffer buffer;
    struct v4l2_plane  planes;
	int pmem_fd[CAPTURE_BUF_SIZE];

    memset(v4l2_buffer_record4, 0, sizeof(v4l2_buffer_record4));

    for(i = 0; i < CAPTURE_BUF_SIZE; i++){
        CLEAR(buffer);
        CLEAR(planes);

        buffer.type     = V4L2_BUF_TYPE_VIDEO_CAPTURE_MPLANE;
        buffer.memory   = V4L2_MEMORY_MMAP;
        buffer.index    = i;
        buffer.length   = 1;		// 1
        buffer.m.planes = &planes;

        if (ioctl(video_fd, VIDIOC_QUERYBUF, &buffer) < 0) {
            printf("[threadloop4] VIDIOC_QUERYBUF: %s", strerror(errno));
            close(video_fd);
            return NULL;
        }
        v4l2_buffer_record4[i].mLength =  buffer.m.planes->length;
        v4l2_buffer_record4[i].mOffset = (size_t)buffer.m.planes->m.mem_offset;
        v4l2_buffer_record4[i].mIndex  = i;

        v4l2_buffer_record4[i].mStart = mmap (NULL, v4l2_buffer_record4[i].mLength, 
                                            PROT_READ | PROT_WRITE, MAP_SHARED, video_fd, 
                                            v4l2_buffer_record4[i].mOffset);
        if (v4l2_buffer_record4[i].mStart == MAP_FAILED) {
            printf("[threadloop4] mmap failed!!!!!");
            close(video_fd);
            return NULL;
        }

		printf("[threadloop4] Buffer description:\n");
		printf("[threadloop4]  index : %d\n", v4l2_buffer_record4[i].mIndex);
		printf("[threadloop4]  offset: %d\n", v4l2_buffer_record4[i].mOffset);
		printf("[threadloop4]  length: %d\n", v4l2_buffer_record4[i].mLength);
		printf("[threadloop4]  map start at %p\n", v4l2_buffer_record4[i].mStart);

    }

   for(i = 0; i < CAPTURE_BUF_SIZE; i++)
	{
		memset(&buffer, 0, sizeof(buffer));
        CLEAR(planes);

		printf("[threadloop4] VIDIOC_QBUF Start 1111  \n");
		buffer.type     = V4L2_BUF_TYPE_VIDEO_CAPTURE_MPLANE;
		buffer.m.planes = &planes;
		buffer.memory =  V4L2_MEMORY_MMAP; 
		buffer.m.planes->length   = v4l2_buffer_record4[i].mLength;
		buffer.m.planes->m.mem_offset = 0;
		buffer.index    = i;
        buffer.length   = 1;		// 1

        printf("[threadloop4] VIDIOC_QBUF index=%d, length=%d \n", buffer.index, buffer.length);
		if (ioctl (video_fd, VIDIOC_QBUF, &buffer) < 0) 
		{
			printf("[threadloop4] %s  VIDIOC_QBUF failed! %s.", __FUNCTION__, strerror(errno));
			close(video_fd);
            return NULL;
		}
	}

	{
        enum v4l2_buf_type type;
		
        type = V4L2_BUF_TYPE_VIDEO_CAPTURE_MPLANE;
        if (ioctl(video_fd, VIDIOC_STREAMON, &type) < 0) 
        {
            printf("[threadloop4] %s  VIDIOC_STREAMON failed! %s.", __FUNCTION__, strerror(errno));
            close(video_fd);
            return NULL;
        }
        printf("[threadloop4] %s  stream on END!!!", __FUNCTION__);
    }


   printf("[threadloop4] VIDIOC_DQBUF Start\n");

	for(;;)  
	{
		struct v4l2_buffer buffer;
        struct v4l2_plane planes;

        CLEAR(buffer);
        CLEAR(planes);
		char* str = getSysTime();
		free(str);
		memset(&buffer, 0, sizeof(buffer));

		buffer.type     = V4L2_BUF_TYPE_VIDEO_CAPTURE_MPLANE;
		buffer.memory =  V4L2_MEMORY_MMAP; 

        buffer.m.planes = &planes;
        buffer.length   = 1;   //2;

		if (ioctl(video_fd, VIDIOC_DQBUF, &buffer) < 0) {
			printf("[native_camera] %s  VIDIOC_DQBUF failed! %s.\n", __FUNCTION__, strerror(errno));
			close(video_fd);
            return NULL;
		}
		str = getSysTime();	
		if(cnt4 % 30 == 0)
		{
			long diff = (buffer.timestamp.tv_sec - lastTimestamp4.tv_sec)*1000 + 
						(buffer.timestamp.tv_usec - lastTimestamp4.tv_usec)/1000;
			printf("%d [video4-fID:%d]%s %s  frame size=%d fps =%2f  ts=%ld \n",buffer.index, cnt4, str, __FUNCTION__,  v4l2_buffer_record4[buffer.index].mLength, 30000.0/diff, buffer.timestamp);
			lastTimestamp4 = buffer.timestamp;
		}
		cnt4++;
		free(str);
		if(cnt4 % 100 == 0)
			DumpRGB(v4l2_buffer_record4[buffer.index].mStart, v4l2_buffer_record4[buffer.index].mLength, cnt4);

		if (ioctl(video_fd, VIDIOC_QBUF, &buffer) < 0) {
			printf("[threadloop4] %s  VIDIOC_QBUF failed! %s.\n", __FUNCTION__, strerror(errno));
			close(video_fd);
            return NULL;
		}
	}


	{
        enum v4l2_buf_type type;
		
        type = V4L2_BUF_TYPE_VIDEO_CAPTURE_MPLANE;
        if (ioctl(video_fd, VIDIOC_STREAMOFF, &type) < 0) 
        {
            printf("[threadloop4] %s  VIDIOC_STREAMOFF failed! %s.", __FUNCTION__, strerror(errno));
            close(video_fd);
            return NULL;
        }
        printf("[threadloop4] %s  stream OFF END!!!", __FUNCTION__);
    }

    CLEAR(bufrequest);
    bufrequest.type = V4L2_BUF_TYPE_VIDEO_CAPTURE_MPLANE;
	bufrequest.memory =  V4L2_MEMORY_MMAP; 
    bufrequest.count = 0;

    if (ioctl(video_fd, VIDIOC_REQBUFS, &bufrequest) < 0) {
        printf("[threadloop4] VIDIOC_REQBUFS: %s", strerror(errno));
        close(video_fd);
        return NULL;
    }

    for(i = 0; i < CAPTURE_BUF_SIZE; i++){
		uint32_t size = (v4l2_buffer_record4[i].mLength + 4095) & (~4095);
		printf("[threadloop4] munmapped size = %zu, virt_addr = 0x%p, pmem_fd=%d\n", size, v4l2_buffer_record4[i].mStart, pmem_fd[i]);

		if( munmap(v4l2_buffer_record4[i].mStart, size) < 0){
			printf("[threadloop4] munmapped size = %zu, virt_addr = 0x%p  Failed \n", size, v4l2_buffer_record4[i].mStart);
		}
		close(pmem_fd[i]);
	}
    return NULL;

}

int main(int argc, char *argv[]){
	pthread_t tid3,tid4;
	void* ret3;
	void* ret4;
	if(pthread_create(&tid4, NULL, threadloop4, NULL) == 0){
		printf("threadloop4 create OK!\n");
	}
	usleep(100000);
	if(pthread_create(&tid3, NULL, threadloop3, NULL) == 0){
		printf("threadloop3 create OK!\n");
	}
	if(pthread_join(tid4, &ret4) == 0){
		printf("thread tid4 = %d\n", tid4);
	}
	if(pthread_join(tid3, &ret3) == 0){
		printf("thread tid3 = %d\n", tid3);
	}

    return 0;
}