/*
** ###################################################################
**     Processors:          MIMX8ML8CVNKZ
**                          MIMX8ML8DVNLZ
**
**     Compilers:           GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**                          Keil ARM C/C++ Compiler
**
**     Reference manual:    IMX8MPRM, Rev.D, 10/2020
**     Version:             rev. 4.0, 2020-11-16
**     Build:               b201104
**
**     Abstract:
**         CMSIS Peripheral Access Layer for MIMX8ML8_cm7
**
**     Copyright 1997-2016 Freescale Semiconductor, Inc.
**     Copyright 2016-2020 NXP
**     All rights reserved.
**
**     SPDX-License-Identifier: BSD-3-Clause
**
**     http:                 www.nxp.com
**     mail:                 support@nxp.com
**
**     Revisions:
**     - rev. 1.0 (2019-10-11)
**         Initial version.
**     - rev. 2.0 (2020-02-21)
**         Rev.B Header.
**     - rev. 3.0 (2020-06-22)
**         Rev.C Header.
**     - rev. 4.0 (2020-11-16)
**         Rev.D Header.
**
** ###################################################################
*/

/*!
 * @file MIMX8ML8_cm7.h
 * @version 4.0
 * @date 2020-11-16
 * @brief CMSIS Peripheral Access Layer for MIMX8ML8_cm7
 *
 * CMSIS Peripheral Access Layer for MIMX8ML8_cm7
 */

#ifndef _MIMX8ML8_CM7_H_
#define _MIMX8ML8_CM7_H_ /**< Symbol preventing repeated inclusion */

/** Memory map major version (memory maps with equal major version number are
 * compatible) */
#define MCU_MEM_MAP_VERSION 0x0400U
/** Memory map minor version */
#define MCU_MEM_MAP_VERSION_MINOR 0x0000U

/* ----------------------------------------------------------------------------
   -- Interrupt vector numbers
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Interrupt_vector_numbers Interrupt vector numbers
 * @{
 */

/** Interrupt Number Definitions */
#define NUMBER_OF_INT_VECTORS 170 /**< Number of interrupts in the Vector table */

typedef enum IRQn
{
    /* Auxiliary constants */
    NotAvail_IRQn = -128, /**< Not available device specific interrupt */

    /* Core interrupts */
    NonMaskableInt_IRQn   = -14, /**< Non Maskable Interrupt */
    HardFault_IRQn        = -13, /**< Cortex-M7 SV Hard Fault Interrupt */
    MemoryManagement_IRQn = -12, /**< Cortex-M7 Memory Management Interrupt */
    BusFault_IRQn         = -11, /**< Cortex-M7 Bus Fault Interrupt */
    UsageFault_IRQn       = -10, /**< Cortex-M7 Usage Fault Interrupt */
    SVCall_IRQn           = -5,  /**< Cortex-M7 SV Call Interrupt */
    DebugMonitor_IRQn     = -4,  /**< Cortex-M7 Debug Monitor Interrupt */
    PendSV_IRQn           = -2,  /**< Cortex-M7 Pend SV Interrupt */
    SysTick_IRQn          = -1,  /**< Cortex-M7 System Tick Interrupt */

    /* Device specific interrupts */
    DAP_IRQn               = 1,  /**< DAP Interrupt */
    SDMA1_IRQn             = 2,  /**< AND of all 48 SDMA1 interrupts (events) from all the channels */
    GPU3D_IRQn             = 3,  /**< GPU3D Interrupt */
    SNVS_IRQn              = 4,  /**< ON-OFF button press shorter than 5 seconds (pulse event) */
    LCDIF1_IRQn            = 5,  /**< LCDIF1 Interrupt */
    LCDIF2_IRQn            = 6,  /**< LCDIF2 Interrupt */
    VPU_G1_IRQn            = 7,  /**< VPU G1 Decoder Interrupt */
    VPU_G2_IRQn            = 8,  /**< VPU G2 Decoder Interrupt */
    QOS_IRQn               = 9,  /**< QOS interrupt */
    WDOG3_IRQn             = 10, /**< Watchdog Timer reset */
    HS_CP1_IRQn            = 11, /**< HS Interrupt Request */
    APBHDMA_IRQn           = 12, /**< GPMI operation channel 0-3 description complete interrupt */
    ML_IRQn                = 13, /**< Machine Learning Processor Interrupt */
    BCH_IRQn               = 14, /**< BCH operation complete interrupt */
    GPMI_IRQn              = 15, /**< GPMI operation TIMEOUT ERROR interrupt */
    ISI_IRQn               = 16, /**< ISI Interrupt */
    MIPI_CSI1_IRQn         = 17, /**< MIPI CSI Interrupt */
    MIPI_DSI_IRQn          = 18, /**< MIPI DSI Interrupt */
    SNVS_Consolidated_IRQn = 19, /**< SRTC Consolidated Interrupt. Non TZ. */
    SNVS_Security_IRQn     = 20, /**< SRTC Security Interrupt. TZ. */
    CSU_IRQn =
        21, /**< CSU Interrupt Request. Indicates to the processor that one or more alarm inputs were asserted. */
    USDHC1_IRQn          = 22, /**< uSDHC1 Enhanced SDHC Interrupt Request */
    USDHC2_IRQn          = 23, /**< uSDHC2 Enhanced SDHC Interrupt Request */
    USDHC3_IRQn          = 24, /**< uSDHC3 Enhanced SDHC Interrupt Request */
    GPU2D_IRQn           = 25, /**< GPU2D Interrupt */
    UART1_IRQn           = 26, /**< UART-1 ORed interrupt */
    UART2_IRQn           = 27, /**< UART-2 ORed interrupt */
    UART3_IRQn           = 28, /**< UART-3 ORed interrupt */
    UART4_IRQn           = 29, /**< UART-4 ORed interrupt */
    VPU_IRQn             = 30, /**< VPU Encoder Interrupt */
    ECSPI1_IRQn          = 31, /**< ECSPI1 interrupt request line to the core. */
    ECSPI2_IRQn          = 32, /**< ECSPI2 interrupt request line to the core. */
    ECSPI3_IRQn          = 33, /**< ECSPI3 interrupt request line to the core. */
    SDMA3_IRQn           = 34, /**< AND of all 48 SDMA3 interrupts (events) from all the channels */
    I2C1_IRQn            = 35, /**< I2C-1 Interrupt */
    I2C2_IRQn            = 36, /**< I2C-2 Interrupt */
    I2C3_IRQn            = 37, /**< I2C-3 Interrupt */
    I2C4_IRQn            = 38, /**< I2C-4 Interrupt */
    RDC_IRQn             = 39, /**< RDC interrupt */
    USB1_IRQn            = 40, /**< USB1 Interrupt */
    USB2_IRQn            = 41, /**< USB2 Interrupt */
    ISI_CH1_IRQn         = 42, /**< ISI Camera Channel 1 Interrupt */
    HDMI_TX_IRQn         = 43, /**< HDMI TX Subsystem Interrupt */
    PDM_HWVAD_EVENT_IRQn = 44, /**< Digital Microphone interface voice activity detector event interrupt */
    PDM_HWVAD_ERROR_IRQn = 45, /**< Digital Microphone interface voice activity detector error interrupt */
    GPT6_IRQn = 46,      /**< OR of GPT Rollover interrupt line, Input Capture 1 and 2 lines, Output Compare 1, 2, and 3
                            Interrupt lines */
    SCTR_IRQ0_IRQn = 47, /**< System Counter Interrupt 0 */
    SCTR_IRQ1_IRQn = 48, /**< System Counter Interrupt 1 */
    ANAMIX_IRQn    = 49, /**< TempSensor (Temperature alarm and criticl alarm). */
    I2S3_IRQn      = 50, /**< SAI3 Receive / Transmit Interrupt */
    GPT5_IRQn      = 51, /**< OR of GPT Rollover interrupt line, Input Capture 1 and 2 lines, Output Compare 1, 2, and 3
                            Interrupt lines */
    GPT4_IRQn = 52,      /**< OR of GPT Rollover interrupt line, Input Capture 1 and 2 lines, Output Compare 1, 2, and 3
                            Interrupt lines */
    GPT3_IRQn = 53,      /**< OR of GPT Rollover interrupt line, Input Capture 1 and 2 lines, Output Compare 1, 2, and 3
                            Interrupt lines */
    GPT2_IRQn = 54,      /**< OR of GPT Rollover interrupt line, Input Capture 1 and 2 lines, Output Compare 1, 2, and 3
                            Interrupt lines */
    GPT1_IRQn = 55,      /**< OR of GPT Rollover interrupt line, Input Capture 1 and 2 lines, Output Compare 1, 2, and 3
                            Interrupt lines */
    GPIO1_INT7_IRQn           = 56, /**< Active HIGH Interrupt from INT7 from GPIO */
    GPIO1_INT6_IRQn           = 57, /**< Active HIGH Interrupt from INT6 from GPIO */
    GPIO1_INT5_IRQn           = 58, /**< Active HIGH Interrupt from INT5 from GPIO */
    GPIO1_INT4_IRQn           = 59, /**< Active HIGH Interrupt from INT4 from GPIO */
    GPIO1_INT3_IRQn           = 60, /**< Active HIGH Interrupt from INT3 from GPIO */
    GPIO1_INT2_IRQn           = 61, /**< Active HIGH Interrupt from INT2 from GPIO */
    GPIO1_INT1_IRQn           = 62, /**< Active HIGH Interrupt from INT1 from GPIO */
    GPIO1_INT0_IRQn           = 63, /**< Active HIGH Interrupt from INT0 from GPIO */
    GPIO1_Combined_0_15_IRQn  = 64, /**< Combined interrupt indication for GPIO1 signal 0 throughout 15 */
    GPIO1_Combined_16_31_IRQn = 65, /**< Combined interrupt indication for GPIO1 signal 16 throughout 31 */
    GPIO2_Combined_0_15_IRQn  = 66, /**< Combined interrupt indication for GPIO2 signal 0 throughout 15 */
    GPIO2_Combined_16_31_IRQn = 67, /**< Combined interrupt indication for GPIO2 signal 16 throughout 31 */
    GPIO3_Combined_0_15_IRQn  = 68, /**< Combined interrupt indication for GPIO3 signal 0 throughout 15 */
    GPIO3_Combined_16_31_IRQn = 69, /**< Combined interrupt indication for GPIO3 signal 16 throughout 31 */
    GPIO4_Combined_0_15_IRQn  = 70, /**< Combined interrupt indication for GPIO4 signal 0 throughout 15 */
    GPIO4_Combined_16_31_IRQn = 71, /**< Combined interrupt indication for GPIO4 signal 16 throughout 31 */
    GPIO5_Combined_0_15_IRQn  = 72, /**< Combined interrupt indication for GPIO5 signal 0 throughout 15 */
    GPIO5_Combined_16_31_IRQn = 73, /**< Combined interrupt indication for GPIO5 signal 16 throughout 31 */
    ISP1_IRQn                 = 74, /**< ISP 1 ISP Interrupts */
    ISP2_IRQn                 = 75, /**< ISP 2 ISP Interrupts */
    I2C5_IRQn                 = 76, /**< I2C-5 Interrupt */
    I2C6_IRQn                 = 77, /**< I2C-6 Interrupt */
    WDOG1_IRQn                = 78, /**< Watchdog Timer reset */
    WDOG2_IRQn                = 79, /**< Watchdog Timer reset */
    MIPI_CSI2_IRQn            = 80, /**< MIPI CSI 2 Interrupt */
    PWM1_IRQn = 81, /**< Cumulative interrupt line. OR of Rollover Interrupt line, Compare Interrupt line and FIFO
                       Waterlevel crossing interrupt line. */
    PWM2_IRQn = 82, /**< Cumulative interrupt line. OR of Rollover Interrupt line, Compare Interrupt line and FIFO
                       Waterlevel crossing interrupt line. */
    PWM3_IRQn = 83, /**< Cumulative interrupt line. OR of Rollover Interrupt line, Compare Interrupt line and FIFO
                       Waterlevel crossing interrupt line. */
    PWM4_IRQn = 84, /**< Cumulative interrupt line. OR of Rollover Interrupt line, Compare Interrupt line and FIFO
                       Waterlevel crossing interrupt line. */
    CCM_IRQ1_IRQn               = 85,  /**< CCM Interrupt Request 1 */
    CCM_IRQ2_IRQn               = 86,  /**< CCM Interrupt Request 2 */
    GPC_IRQn                    = 87,  /**< GPC Interrupt Request 1 */
    MU1_A53_IRQn                = 88,  /**< Interrupt to A53 (A53,M7 MU) */
    SRC_IRQn                    = 89,  /**< SRC interrupt request */
    I2S56_IRQn                  = 90,  /**< SAI5/6 Receive / Transmit Interrupt */
    RTIC_IRQn                   = 91,  /**< RTIC Interrupt */
    CPU_PerformanceUnit_IRQn    = 92,  /**< Performance Unit Interrupts from Cheetah (interrnally: PMUIRQ[n] */
    CPU_CTI_Trigger_IRQn        = 93,  /**< CTI trigger outputs (internal: nCTIIRQ[n] */
    SRC_Combined_IRQn           = 94,  /**< Combined CPU wdog interrupts (4x) out of SRC. */
    I2S1_IRQn                   = 95,  /**< SAI1 Receive / Transmit Interrupt */
    I2S2_IRQn                   = 96,  /**< SAI2 Receive / Transmit Interrupt */
    MU1_M7_IRQn                 = 97,  /**< Interrupt to M7 (A53, M7 MU) */
    DDR_PerformanceMonitor_IRQn = 98,  /**< ddr Interrupt for performance monitor */
    DDR_IRQn                    = 99,  /**< ddr Interrupt */
    DEWARP_IRQn                 = 100, /**< Dewarp Interrupt */
    CPU_Error_AXI_IRQn   = 101, /**< CPU Error indicator for AXI transaction with a write response error condition */
    CPU_Error_L2RAM_IRQn = 102, /**< CPU Error indicator for L2 RAM double-bit ECC error */
    SDMA2_IRQn           = 103, /**< AND of all 48 SDMA2 interrupts (events) from all the channels */
    SJC_IRQn             = 104, /**< Interrupt triggered by SJC register */
    CAAM_IRQ0_IRQn       = 105, /**< CAAM interrupt queue for JQ */
    CAAM_IRQ1_IRQn       = 106, /**< CAAM interrupt queue for JQ */
    FlexSPI_IRQn         = 107, /**< FlexSPI Interrupt */
    TZASC_IRQn           = 108, /**< TZASC (PL380) interrupt */
    PDM_EVENT_IRQn       = 109, /**< Digital Microphone interface interrupt */
    PDM_ERROR_IRQn       = 110, /**< Digital Microphone interface error interrupt */
    I2S7_IRQn            = 111, /**< SAI7 Receive / Transmit Interrupt */
    PERFMON1_IRQn        = 112, /**< General Interrupt */
    PERFMON2_IRQn        = 113, /**< General Interrupt */
    CAAM_IRQ2_IRQn       = 114, /**< CAAM interrupt queue for JQ */
    CAAM_ERROR_IRQn      = 115, /**< Recoverable error interrupt */
    HS_CP0_IRQn          = 116, /**< HS Interrupt Request */
    CM7_CTI_IRQn         = 117, /**< CTI trigger outputs from CM7 platform */
    ENET1_MAC0_Rx_Tx_Done0_IRQn = 118, /**< MAC 0 Receive / Trasmit Frame / Buffer Done */
    ENET1_MAC0_Rx_Tx_Done1_IRQn = 119, /**< MAC 0 Receive / Trasmit Frame / Buffer Done */
    ENET1_IRQn                  = 120, /**< MAC 0 IRQ */
    ENET1_1588_IRQn             = 121, /**< MAC 0 1588 Timer Interrupt-synchronous */
    ASRC_IRQn                   = 122, /**< ASRC Interrupt */
    PCIE_CTRL1_0_IRQn   = 123, /**< Coming from GLUE logic, of set/reset FF, driven by PCIE signals, interrupt 0 */
    PCIE_CTRL1_1_IRQn   = 124, /**< Coming from GLUE logic, of set/reset FF, driven by PCIE signals, interrupt 1 */
    PCIE_CTRL1_2_IRQn   = 125, /**< Coming from GLUE logic, of set/reset FF, driven by PCIE signals, interrupt 2 */
    PCIE_CTRL1_3_IRQn   = 126, /**< Coming from GLUE logic, of set/reset FF, driven by PCIE signals, interrupt 3 */
    PCIE_EDMA_IRQn      = 127, /**< Channels [63:32] interrupts requests */
    AUDIO_XCVR0_IRQn    = 128, /**< eARC Interrupt 0 */
    AUDIO_XCVR1_IRQn    = 129, /**< eARC Interrupt 1 */
    AUD2HTX_IRQn        = 130, /**< Audio to HDMI TX Audio Link Master Interrupt */
    EDMA1_ERR_IRQn      = 131, /**< Audio Subsystem eDMA Error Interrupt */
    EDMA1_0_15_IRQn     = 132, /**< Audio Subsystem eDMA Channel Interrupts, Logical OR of channels [15:0] */
    EDMA1_16_31_IRQn    = 133, /**< Audio Subsystem eDMA Channel Interrupts, Logical OR of channels [31:16] */
    ENET_QOS_PMT_IRQn   = 134, /**< ENET QOS TSN Interrupt from PMT */
    ENET_QOS_IRQn       = 135, /**< ENET QOS TSN LPI RX exit/Host System/RX/TX Channels[4:0] Interrupt */
    MU2_A53_IRQn        = 136, /**< Interrupt to A53 (A53, Audio Processor MU) */
    MU2_AUDIO_IRQn      = 137, /**< Interrupt to Audio Processor (A53, Audio Processor MU) */
    MU3_M7_IRQn         = 138, /**< Interrupt to M7 (M7, Audio Processor MU) */
    MU3_AUDIO_IRQn      = 139, /**< Interrupt to Audio Processor (M7, Audio Processor MU) */
    PCIE_CTRL1_IRQn     = 140, /**< RC/EP message transaction Interrupt */
    PCIE_CTRL1_ERR_IRQn = 141, /**< RC/EP PME Message and Error Interrupt */
    CAN_FD1_IRQn = 142, /**< CAN-FD1 Interrupt from bus off/line error/RX warning/TX warning/wakeup/match in PN/timeout
                           in PN/busoff done/FD error */
    CAN_FD1_ERROR_IRQn = 143, /**< CAN-FD1 Interrupt from correctable error/non correctable error int host/ non
                                 correctable error int internal */
    CAN_FD2_IRQn = 144, /**< CAN-FD2 Interrupt from bus off/line error/RX warning/TX warning/wakeup/match in PN/timeout
                           in PN/busoff done/FD error */
    CAN_FD2_ERROR_IRQn = 145, /**< CAN-FD2 Interrupt from correctable error/non correctable error int host/ non
                                 correctable error int internal */
    AUDIO_XCVR_IRQn  = 146,   /**< eARC PHY - SPDIF wakeup interrupt */
    DDR_ERR_IRQn     = 147,   /**< DRAM Controller Error Interrupt  */
    USB1_WAKEUP_IRQn = 148,   /**< USB-1 Wake-up Interrupt */
    USB2_WAKEUP_IRQn = 149,   /**< USB-2 Wake-up Interrupt */
    MECC_IRQn        = 150,   /**< OCRAM Memory ECC Interrupt */
    MECC_ERR_IRQn    = 151,   /**< OCRAM Memory ECC Error Interrupt */
    MECC_S_IRQn      = 152,   /**< OCRAM_S Memory ECC Interrupt */
    MECC_S_ERR_IRQn  = 153    /**< OCRAM_S Memory ECC Error Interrupt */
} IRQn_Type;

/*!
 * @}
 */ /* end of group Interrupt_vector_numbers */

/* ----------------------------------------------------------------------------
   -- Cortex M7 Core Configuration
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Cortex_Core_Configuration Cortex M7 Core Configuration
 * @{
 */

#define __MPU_PRESENT          1 /**< Defines if an MPU is present or not */
#define __ICACHE_PRESENT       1 /**< Defines if an ICACHE is present or not */
#define __DCACHE_PRESENT       1 /**< Defines if an DCACHE is present or not */
#define __DTCM_PRESENT         1 /**< Defines if an DTCM is present or not */
#define __NVIC_PRIO_BITS       4 /**< Number of priority bits implemented in the NVIC */
#define __Vendor_SysTickConfig 0 /**< Vendor specific implementation of SysTickConfig is defined */
#define __FPU_PRESENT          1 /**< Defines if an FPU is present or not */

#include "core_cm7.h"            /* Core Peripheral Access Layer */
#include "system_MIMX8ML8_cm7.h" /* Device specific configuration file */

/*!
 * @}
 */ /* end of group Cortex_Core_Configuration */

/* ----------------------------------------------------------------------------
   -- Mapping Information
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Mapping_Information Mapping Information
 * @{
 */

/** Mapping Information */
/*!
 * @addtogroup iomuxc_pads
 * @{ */

/*******************************************************************************
 * Definitions
 *******************************************************************************/

/*!
 * @brief Enumeration for the IOMUXC SW_MUX_CTL_PAD
 *
 * Defines the enumeration for the IOMUXC SW_MUX_CTL_PAD collections.
 */
typedef enum _iomuxc_sw_mux_ctl_pad
{
    kIOMUXC_SW_MUX_CTL_PAD_GPIO1_IO00    = 0U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO1_IO01    = 1U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO1_IO02    = 2U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO1_IO03    = 3U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO1_IO04    = 4U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO1_IO05    = 5U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO1_IO06    = 6U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO1_IO07    = 7U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO1_IO08    = 8U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO1_IO09    = 9U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO1_IO10    = 10U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO1_IO11    = 11U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO1_IO12    = 12U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO1_IO13    = 13U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO1_IO14    = 14U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO1_IO15    = 15U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ENET_MDC      = 16U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ENET_MDIO     = 17U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ENET_TD3      = 18U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ENET_TD2      = 19U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ENET_TD1      = 20U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ENET_TD0      = 21U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ENET_TX_CTL   = 22U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ENET_TXC      = 23U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ENET_RX_CTL   = 24U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ENET_RXC      = 25U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ENET_RD0      = 26U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ENET_RD1      = 27U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ENET_RD2      = 28U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ENET_RD3      = 29U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SD1_CLK       = 30U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SD1_CMD       = 31U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SD1_DATA0     = 32U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SD1_DATA1     = 33U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SD1_DATA2     = 34U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SD1_DATA3     = 35U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SD1_DATA4     = 36U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SD1_DATA5     = 37U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SD1_DATA6     = 38U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SD1_DATA7     = 39U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SD1_RESET_B   = 40U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SD1_STROBE    = 41U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SD2_CD_B      = 42U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SD2_CLK       = 43U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SD2_CMD       = 44U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SD2_DATA0     = 45U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SD2_DATA1     = 46U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SD2_DATA2     = 47U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SD2_DATA3     = 48U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SD2_RESET_B   = 49U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SD2_WP        = 50U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_ALE      = 51U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_CE0_B    = 52U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_CE1_B    = 53U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_CE2_B    = 54U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_CE3_B    = 55U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_CLE      = 56U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_DATA00   = 57U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_DATA01   = 58U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_DATA02   = 59U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_DATA03   = 60U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_DATA04   = 61U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_DATA05   = 62U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_DATA06   = 63U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_DATA07   = 64U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_DQS      = 65U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_RE_B     = 66U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_READY_B  = 67U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_WE_B     = 68U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_NAND_WP_B     = 69U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI5_RXFS     = 70U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI5_RXC      = 71U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI5_RXD0     = 72U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI5_RXD1     = 73U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI5_RXD2     = 74U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI5_RXD3     = 75U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI5_MCLK     = 76U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI1_RXFS     = 77U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI1_RXC      = 78U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI1_RXD0     = 79U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI1_RXD1     = 80U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI1_RXD2     = 81U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI1_RXD3     = 82U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI1_RXD4     = 83U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI1_RXD5     = 84U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI1_RXD6     = 85U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI1_RXD7     = 86U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI1_TXFS     = 87U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI1_TXC      = 88U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI1_TXD0     = 89U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI1_TXD1     = 90U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI1_TXD2     = 91U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI1_TXD3     = 92U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI1_TXD4     = 93U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI1_TXD5     = 94U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI1_TXD6     = 95U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI1_TXD7     = 96U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI1_MCLK     = 97U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI2_RXFS     = 98U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI2_RXC      = 99U,  /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI2_RXD0     = 100U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI2_TXFS     = 101U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI2_TXC      = 102U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI2_TXD0     = 103U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI2_MCLK     = 104U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI3_RXFS     = 105U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI3_RXC      = 106U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI3_RXD      = 107U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI3_TXFS     = 108U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI3_TXC      = 109U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI3_TXD      = 110U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SAI3_MCLK     = 111U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SPDIF_TX      = 112U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SPDIF_RX      = 113U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_SPDIF_EXT_CLK = 114U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ECSPI1_SCLK   = 115U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ECSPI1_MOSI   = 116U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ECSPI1_MISO   = 117U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ECSPI1_SS0    = 118U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ECSPI2_SCLK   = 119U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ECSPI2_MOSI   = 120U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ECSPI2_MISO   = 121U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_ECSPI2_SS0    = 122U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_I2C1_SCL      = 123U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_I2C1_SDA      = 124U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_I2C2_SCL      = 125U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_I2C2_SDA      = 126U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_I2C3_SCL      = 127U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_I2C3_SDA      = 128U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_I2C4_SCL      = 129U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_I2C4_SDA      = 130U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_UART1_RXD     = 131U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_UART1_TXD     = 132U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_UART2_RXD     = 133U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_UART2_TXD     = 134U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_UART3_RXD     = 135U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_UART3_TXD     = 136U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_UART4_RXD     = 137U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_UART4_TXD     = 138U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_HDMI_DDC_SCL  = 139U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_HDMI_DDC_SDA  = 140U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_HDMI_CEC      = 141U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_HDMI_HPD      = 142U, /**< IOMUXC SW_MUX_CTL_PAD index */
} iomuxc_sw_mux_ctl_pad_t;

/*!
 * @addtogroup iomuxc_pads
 * @{ */

/*******************************************************************************
 * Definitions
 *******************************************************************************/

/*!
 * @brief Enumeration for the IOMUXC SW_PAD_CTL_PAD
 *
 * Defines the enumeration for the IOMUXC SW_PAD_CTL_PAD collections.
 */
typedef enum _iomuxc_sw_pad_ctl_pad
{
    kIOMUXC_SW_PAD_CTL_PAD_BOOT_MODE0    = 0U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_BOOT_MODE1    = 1U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_BOOT_MODE2    = 2U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_BOOT_MODE3    = 3U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_JTAG_MOD      = 4U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_JTAG_TDI      = 5U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_JTAG_TMS      = 6U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_JTAG_TCK      = 7U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_JTAG_TDO      = 8U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO1_IO00    = 9U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO1_IO01    = 10U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO1_IO02    = 11U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO1_IO03    = 12U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO1_IO04    = 13U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO1_IO05    = 14U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO1_IO06    = 15U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO1_IO07    = 16U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO1_IO08    = 17U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO1_IO09    = 18U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO1_IO10    = 19U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO1_IO11    = 20U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO1_IO12    = 21U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO1_IO13    = 22U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO1_IO14    = 23U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO1_IO15    = 24U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ENET_MDC      = 25U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ENET_MDIO     = 26U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ENET_TD3      = 27U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ENET_TD2      = 28U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ENET_TD1      = 29U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ENET_TD0      = 30U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ENET_TX_CTL   = 31U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ENET_TXC      = 32U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ENET_RX_CTL   = 33U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ENET_RXC      = 34U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ENET_RD0      = 35U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ENET_RD1      = 36U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ENET_RD2      = 37U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ENET_RD3      = 38U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SD1_CLK       = 39U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SD1_CMD       = 40U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SD1_DATA0     = 41U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SD1_DATA1     = 42U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SD1_DATA2     = 43U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SD1_DATA3     = 44U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SD1_DATA4     = 45U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SD1_DATA5     = 46U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SD1_DATA6     = 47U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SD1_DATA7     = 48U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SD1_RESET_B   = 49U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SD1_STROBE    = 50U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SD2_CD_B      = 51U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SD2_CLK       = 52U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SD2_CMD       = 53U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SD2_DATA0     = 54U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SD2_DATA1     = 55U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SD2_DATA2     = 56U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SD2_DATA3     = 57U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SD2_RESET_B   = 58U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SD2_WP        = 59U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_ALE      = 60U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_CE0_B    = 61U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_CE1_B    = 62U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_CE2_B    = 63U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_CE3_B    = 64U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_CLE      = 65U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_DATA00   = 66U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_DATA01   = 67U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_DATA02   = 68U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_DATA03   = 69U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_DATA04   = 70U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_DATA05   = 71U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_DATA06   = 72U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_DATA07   = 73U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_DQS      = 74U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_RE_B     = 75U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_READY_B  = 76U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_WE_B     = 77U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_NAND_WP_B     = 78U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI5_RXFS     = 79U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI5_RXC      = 80U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI5_RXD0     = 81U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI5_RXD1     = 82U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI5_RXD2     = 83U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI5_RXD3     = 84U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI5_MCLK     = 85U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI1_RXFS     = 86U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI1_RXC      = 87U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI1_RXD0     = 88U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI1_RXD1     = 89U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI1_RXD2     = 90U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI1_RXD3     = 91U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI1_RXD4     = 92U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI1_RXD5     = 93U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI1_RXD6     = 94U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI1_RXD7     = 95U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI1_TXFS     = 96U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI1_TXC      = 97U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI1_TXD0     = 98U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI1_TXD1     = 99U,  /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI1_TXD2     = 100U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI1_TXD3     = 101U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI1_TXD4     = 102U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI1_TXD5     = 103U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI1_TXD6     = 104U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI1_TXD7     = 105U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI1_MCLK     = 106U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI2_RXFS     = 107U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI2_RXC      = 108U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI2_RXD0     = 109U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI2_TXFS     = 110U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI2_TXC      = 111U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI2_TXD0     = 112U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI2_MCLK     = 113U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI3_RXFS     = 114U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI3_RXC      = 115U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI3_RXD      = 116U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI3_TXFS     = 117U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI3_TXC      = 118U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI3_TXD      = 119U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SAI3_MCLK     = 120U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SPDIF_TX      = 121U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SPDIF_RX      = 122U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_SPDIF_EXT_CLK = 123U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ECSPI1_SCLK   = 124U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ECSPI1_MOSI   = 125U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ECSPI1_MISO   = 126U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ECSPI1_SS0    = 127U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ECSPI2_SCLK   = 128U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ECSPI2_MOSI   = 129U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ECSPI2_MISO   = 130U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_ECSPI2_SS0    = 131U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_I2C1_SCL      = 132U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_I2C1_SDA      = 133U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_I2C2_SCL      = 134U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_I2C2_SDA      = 135U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_I2C3_SCL      = 136U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_I2C3_SDA      = 137U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_I2C4_SCL      = 138U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_I2C4_SDA      = 139U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_UART1_RXD     = 140U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_UART1_TXD     = 141U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_UART2_RXD     = 142U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_UART2_TXD     = 143U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_UART3_RXD     = 144U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_UART3_TXD     = 145U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_UART4_RXD     = 146U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_UART4_TXD     = 147U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_HDMI_DDC_SCL  = 148U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_HDMI_DDC_SDA  = 149U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_HDMI_CEC      = 150U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_HDMI_HPD      = 151U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_CLKIN1        = 152U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_CLKIN2        = 153U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_CLKOUT1       = 154U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_CLKOUT2       = 155U, /**< IOMUXC SW_PAD_CTL_PAD index */
} iomuxc_sw_pad_ctl_pad_t;

/* @} */

/*!
 * @brief Enumeration for the IOMUXC select input
 *
 * Defines the enumeration for the IOMUXC select input collections.
 */
typedef enum _iomuxc_select_input
{
    kIOMUXC_AUDIOMIX_PDM_MIC_PDM_BITSTREAM_SELECT_INPUT_0 = 0U,  /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_PDM_MIC_PDM_BITSTREAM_SELECT_INPUT_1 = 1U,  /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_PDM_MIC_PDM_BITSTREAM_SELECT_INPUT_2 = 2U,  /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_PDM_MIC_PDM_BITSTREAM_SELECT_INPUT_3 = 3U,  /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_SAI1_RXSYNC_SELECT_INPUT             = 4U,  /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_SAI1_TXBCLK_SELECT_INPUT             = 5U,  /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_SAI1_TXSYNC_SELECT_INPUT             = 6U,  /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_SAI2_RXDATA_SELECT_INPUT_1           = 7U,  /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_SAI3_MCLK_SELECT_INPUT               = 8U,  /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_SAI3_RXDATA_SELECT_INPUT_0           = 9U,  /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_SAI3_TXBCLK_SELECT_INPUT             = 10U, /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_SAI3_TXSYNC_SELECT_INPUT             = 11U, /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_SAI5_MCLK_SELECT_INPUT               = 12U, /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_SAI5_RXBCLK_SELECT_INPUT             = 13U, /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_SAI5_RXDATA_SELECT_INPUT_0           = 14U, /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_SAI5_RXDATA_SELECT_INPUT_1           = 15U, /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_SAI5_RXDATA_SELECT_INPUT_2           = 16U, /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_SAI5_RXDATA_SELECT_INPUT_3           = 17U, /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_SAI5_RXSYNC_SELECT_INPUT             = 18U, /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_SAI5_TXBCLK_SELECT_INPUT             = 19U, /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_SAI5_TXSYNC_SELECT_INPUT             = 20U, /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_SAI6_MCLK_SELECT_INPUT               = 21U, /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_SAI6_RXBCLK_SELECT_INPUT             = 22U, /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_SAI6_RXDATA_SELECT_INPUT_0           = 23U, /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_SAI6_RXSYNC_SELECT_INPUT             = 24U, /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_SAI6_TXBCLK_SELECT_INPUT             = 25U, /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_SAI6_TXSYNC_SELECT_INPUT             = 26U, /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_SAI7_MCLK_SELECT_INPUT               = 27U, /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_SAI7_RXBCLK_SELECT_INPUT             = 28U, /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_SAI7_RXDATA_SELECT_INPUT_0           = 29U, /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_SAI7_RXSYNC_SELECT_INPUT             = 30U, /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_SAI7_TXBCLK_SELECT_INPUT             = 31U, /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_SAI7_TXSYNC_SELECT_INPUT             = 32U, /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_EARC_PHY_SPDIF_IN_SELECT_INPUT       = 33U, /**< IOMUXC select input index */
    kIOMUXC_AUDIOMIX_SPDIF_EXTCLK_SELECT_INPUT            = 34U, /**< IOMUXC select input index */
    kIOMUXC_CAN1_CANRX_SELECT_INPUT                       = 35U, /**< IOMUXC select input index */
    kIOMUXC_CAN2_CANRX_SELECT_INPUT                       = 36U, /**< IOMUXC select input index */
    kIOMUXC_CCM_GPC_PMIC_VFUNCTIONAL_READY_SELECT_INPUT   = 37U, /**< IOMUXC select input index */
    kIOMUXC_ECSPI1_CSPI_CLK_IN_SELECT_INPUT               = 38U, /**< IOMUXC select input index */
    kIOMUXC_ECSPI1_MISO_SELECT_INPUT                      = 39U, /**< IOMUXC select input index */
    kIOMUXC_ECSPI1_MOSI_SELECT_INPUT                      = 40U, /**< IOMUXC select input index */
    kIOMUXC_ECSPI1_SS_B_SELECT_INPUT_0                    = 41U, /**< IOMUXC select input index */
    kIOMUXC_ECSPI2_CSPI_CLK_IN_SELECT_INPUT               = 42U, /**< IOMUXC select input index */
    kIOMUXC_ECSPI2_MISO_SELECT_INPUT                      = 43U, /**< IOMUXC select input index */
    kIOMUXC_ECSPI2_MOSI_SELECT_INPUT                      = 44U, /**< IOMUXC select input index */
    kIOMUXC_ECSPI2_SS_B_SELECT_INPUT_0                    = 45U, /**< IOMUXC select input index */
    kIOMUXC_ENET1_IPG_CLK_RMII_SELECT_INPUT               = 46U, /**< IOMUXC select input index */
    kIOMUXC_ENET1_MDIO_SELECT_INPUT                       = 47U, /**< IOMUXC select input index */
    kIOMUXC_ENET1_RXDATA_0_SELECT_INPUT                   = 48U, /**< IOMUXC select input index */
    kIOMUXC_ENET1_RXDATA_1_SELECT_INPUT                   = 49U, /**< IOMUXC select input index */
    kIOMUXC_ENET1_RXEN_SELECT_INPUT                       = 50U, /**< IOMUXC select input index */
    kIOMUXC_ENET1_RXERR_SELECT_INPUT                      = 51U, /**< IOMUXC select input index */
    kIOMUXC_ENET_QOS_GMII_MDI_I_SELECT_INPUT              = 52U, /**< IOMUXC select input index */
    kIOMUXC_GPT1_CAPIN1_SELECT_INPUT                      = 53U, /**< IOMUXC select input index */
    kIOMUXC_GPT1_CAPIN2_SELECT_INPUT                      = 54U, /**< IOMUXC select input index */
    kIOMUXC_GPT1_CLKIN_SELECT_INPUT                       = 55U, /**< IOMUXC select input index */
    kIOMUXC_PCIE_CLKREQ_B_SELECT_INPUT                    = 56U, /**< IOMUXC select input index */
    kIOMUXC_I2C1_SCL_IN_SELECT_INPUT                      = 57U, /**< IOMUXC select input index */
    kIOMUXC_I2C1_SDA_IN_SELECT_INPUT                      = 58U, /**< IOMUXC select input index */
    kIOMUXC_I2C2_SCL_IN_SELECT_INPUT                      = 59U, /**< IOMUXC select input index */
    kIOMUXC_I2C2_SDA_IN_SELECT_INPUT                      = 60U, /**< IOMUXC select input index */
    kIOMUXC_I2C3_SCL_IN_SELECT_INPUT                      = 61U, /**< IOMUXC select input index */
    kIOMUXC_I2C3_SDA_IN_SELECT_INPUT                      = 62U, /**< IOMUXC select input index */
    kIOMUXC_I2C4_SCL_IN_SELECT_INPUT                      = 63U, /**< IOMUXC select input index */
    kIOMUXC_I2C4_SDA_IN_SELECT_INPUT                      = 64U, /**< IOMUXC select input index */
    kIOMUXC_I2C5_SCL_IN_SELECT_INPUT                      = 65U, /**< IOMUXC select input index */
    kIOMUXC_I2C5_SDA_IN_SELECT_INPUT                      = 66U, /**< IOMUXC select input index */
    kIOMUXC_I2C6_SCL_IN_SELECT_INPUT                      = 67U, /**< IOMUXC select input index */
    kIOMUXC_I2C6_SDA_IN_SELECT_INPUT                      = 68U, /**< IOMUXC select input index */
    kIOMUXC_ISP_FL_TRIG_0_SELECT_INPUT                    = 69U, /**< IOMUXC select input index */
    kIOMUXC_ISP_FL_TRIG_1_SELECT_INPUT                    = 70U, /**< IOMUXC select input index */
    kIOMUXC_ISP_SHUTTER_TRIG_0_SELECT_INPUT               = 71U, /**< IOMUXC select input index */
    kIOMUXC_ISP_SHUTTER_TRIG_1_SELECT_INPUT               = 72U, /**< IOMUXC select input index */
    kIOMUXC_UART1_UART_RTS_B_SELECT_INPUT                 = 73U, /**< IOMUXC select input index */
    kIOMUXC_UART1_UART_RXD_MUX_SELECT_INPUT               = 74U, /**< IOMUXC select input index */
    kIOMUXC_UART2_UART_RTS_B_SELECT_INPUT                 = 75U, /**< IOMUXC select input index */
    kIOMUXC_UART2_UART_RXD_MUX_SELECT_INPUT               = 76U, /**< IOMUXC select input index */
    kIOMUXC_UART3_UART_RTS_B_SELECT_INPUT                 = 77U, /**< IOMUXC select input index */
    kIOMUXC_UART3_UART_RXD_MUX_SELECT_INPUT               = 78U, /**< IOMUXC select input index */
    kIOMUXC_UART4_UART_RTS_B_SELECT_INPUT                 = 79U, /**< IOMUXC select input index */
    kIOMUXC_UART4_UART_RXD_MUX_SELECT_INPUT               = 80U, /**< IOMUXC select input index */
    kIOMUXC_USDHC3_CARD_CLK_IN_SELECT_INPUT               = 81U, /**< IOMUXC select input index */
    kIOMUXC_USDHC3_CARD_DET_SELECT_INPUT                  = 82U, /**< IOMUXC select input index */
    kIOMUXC_USDHC3_CMD_IN_SELECT_INPUT                    = 83U, /**< IOMUXC select input index */
    kIOMUXC_USDHC3_DAT0_IN_SELECT_INPUT                   = 84U, /**< IOMUXC select input index */
    kIOMUXC_USDHC3_DAT1_IN_SELECT_INPUT                   = 85U, /**< IOMUXC select input index */
    kIOMUXC_USDHC3_DAT2_IN_SELECT_INPUT                   = 86U, /**< IOMUXC select input index */
    kIOMUXC_USDHC3_DAT3_IN_SELECT_INPUT                   = 87U, /**< IOMUXC select input index */
    kIOMUXC_USDHC3_DAT4_IN_SELECT_INPUT                   = 88U, /**< IOMUXC select input index */
    kIOMUXC_USDHC3_DAT5_IN_SELECT_INPUT                   = 89U, /**< IOMUXC select input index */
    kIOMUXC_USDHC3_DAT6_IN_SELECT_INPUT                   = 90U, /**< IOMUXC select input index */
    kIOMUXC_USDHC3_DAT7_IN_SELECT_INPUT                   = 91U, /**< IOMUXC select input index */
    kIOMUXC_USDHC3_STROBE_SELECT_INPUT                    = 92U, /**< IOMUXC select input index */
    kIOMUXC_USDHC3_WP_ON_SELECT_INPUT                     = 93U, /**< IOMUXC select input index */
} iomuxc_select_input_t;

/*!
 * @addtogroup rdc_mapping
 * @{
 */

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*!
 * @brief Structure for the RDC mapping
 *
 * Defines the structure for the RDC resource collections.
 */

typedef enum _rdc_master
{
    kRDC_Master_A53             = 0U,  /**< ARM Cortex-A53 RDC Master */
    kRDC_Master_M7              = 1U,  /**< ARM Cortex-M7 RDC Master */
    kRDC_PCIE_CTRL1             = 2U,  /**< Reserved */
    kRDC_Master_SDMA3_PERIPH    = 3U,  /**< SDMA3 PERIPHERAL RDC Master */
    kRDC_Master_SDMA3_BURST     = 4U,  /**< SDMA3 BURST RDC Master */
    kRDC_Master_LCDIF1          = 5U,  /**< LCDIF1 RDC Master */
    kRDC_Master_ISI             = 6U,  /**< ISI PORT RDC Master */
    kRDC_Master_NPU             = 7U,  /**< NPU RDC Master */
    kRDC_Master_Coresight       = 8U,  /**< CORESIGHT RDC Master */
    kRDC_Master_DAP             = 9U,  /**< DAP RDC Master */
    kRDC_Master_CAAM            = 10U, /**< CAAM RDC Master */
    kRDC_Master_SDMA1_PERIPH    = 11U, /**< SDMA1 PERIPHERAL RDC Master */
    kRDC_Master_SDMA1_BURST     = 12U, /**< SDMA1 BURST RDC Master */
    kRDC_Master_APBHDMA         = 13U, /**< APBH DMA RDC Master */
    kRDC_Master_RAWNAND         = 14U, /**< RAW NAND RDC Master */
    kRDC_Master_USDHC1          = 15U, /**< USDHC1 RDC Master */
    kRDC_Master_USDHC2          = 16U, /**< USDHC2 RDC Master */
    kRDC_Master_USDHC3          = 17U, /**< USDHC3 RDC Master */
    kRDC_Master_AUDIO_PROCESSOR = 18U, /**< AUDIO PROCESSOR RDC Master */
    kRDC_Master_USB1            = 19U, /**< USB1 RDC Master */
    kRDC_Master_USB2            = 20U, /**< USB2 RDC Master */
    kRDC_Master_TESTPORT        = 21U, /**< TESTPORT RDC Master */
    kRDC_Master_ENET1TX         = 22U, /**< ENET1 TX RDC Master */
    kRDC_Master_ENET1RX         = 23U, /**< ENET1 RX RDC Master */
    kRDC_Master_SDMA2_PERIPH    = 24U, /**< SDMA2 PERIPH RDC Master */
    kRDC_Master_SDMA2_BURST     = 24U, /**< SDMA2 BURST RDC Master */
    kRDC_Master_SDMA2_SPBA2     = 24U, /**< SDMA2 to SPBA2 RDC Master */
    kRDC_Master_SDMA3_SPBA2     = 25U, /**< SDMA3 to SPBA2 RDC Master */
    kRDC_Master_SDMA1_SPBA1     = 26U, /**< SDMA1 to SPBA1 RDC Master */
    kRDC_Master_LCDIF2          = 27U, /**< LCDIF2 RDC Master */
    kRDC_Master_HDMI_TX         = 28U, /**< HDMI_TX RDC Master */
    kRDC_Master_ENET2           = 29U, /**< ENET2 RDC Master */
    kRDC_Master_GPU3D           = 30U, /**< GPU3D RDC Master */
    kRDC_Master_GPU2D           = 31U, /**< GPU2D RDC Master */
    kRDC_Master_VPU_G1          = 32U, /**< VPU_G1 RDC Master */
    kRDC_Master_VPU_G2          = 33U, /**< VPU_G2 RDC Master */
    kRDC_Master_VPU_VC8000E     = 34U, /**< VPU_VC8000E RDC Master */
    kRDC_Master_AUDIO_EDMA      = 35U, /**< AUDIO_EDMA RDC Master */
    kRDC_Master_ISP1            = 36U, /**< ISP1 RDC Master */
    kRDC_Master_ISP2            = 37U, /**< ISP2 RDC Master */
    kRDC_Master_DEWARP          = 38U, /**< DEWARP RDC Master */
    kRDC_Master_GIC500          = 39U, /**< GIC500 RDC Master */
} rdc_master_t;

typedef enum _rdc_mem
{
    kRDC_Mem_MRC0_0  = 0U, /**< DEBUG(DAP). Region resolution 4KB. */
    kRDC_Mem_MRC0_1  = 1U,
    kRDC_Mem_MRC0_2  = 2U,
    kRDC_Mem_MRC0_3  = 3U,
    kRDC_Mem_MRC1_0  = 4U, /**< QSPI. Region resolution 4KB. */
    kRDC_Mem_MRC1_1  = 5U,
    kRDC_Mem_MRC1_2  = 6U,
    kRDC_Mem_MRC1_3  = 7U,
    kRDC_Mem_MRC1_4  = 8U,
    kRDC_Mem_MRC1_5  = 9U,
    kRDC_Mem_MRC1_6  = 10U,
    kRDC_Mem_MRC1_7  = 11U,
    kRDC_Mem_MRC2_0  = 12U, /**< OCRAM. Region resolution 128B. */
    kRDC_Mem_MRC2_1  = 13U,
    kRDC_Mem_MRC2_2  = 14U,
    kRDC_Mem_MRC2_3  = 15U,
    kRDC_Mem_MRC2_4  = 16U,
    kRDC_Mem_MRC3_0  = 17U, /**< OCRAM_S. Region resolution 128B. */
    kRDC_Mem_MRC3_1  = 18U,
    kRDC_Mem_MRC3_2  = 19U,
    kRDC_Mem_MRC3_3  = 20U,
    kRDC_Mem_MRC3_4  = 21U,
    kRDC_Mem_MRC4_0  = 22U, /**< TCM. Region resolution 128B. */
    kRDC_Mem_MRC4_1  = 23U,
    kRDC_Mem_MRC4_2  = 24U,
    kRDC_Mem_MRC4_3  = 25U,
    kRDC_Mem_MRC4_4  = 26U,
    kRDC_Mem_MRC5_0  = 27U, /**< GIC. Region resolution 4KB. */
    kRDC_Mem_MRC5_1  = 28U,
    kRDC_Mem_MRC5_2  = 29U,
    kRDC_Mem_MRC5_3  = 30U,
    kRDC_Mem_MRC6_0  = 31U, /**< GPU. Region resolution 4KB. */
    kRDC_Mem_MRC6_1  = 32U,
    kRDC_Mem_MRC6_2  = 33U,
    kRDC_Mem_MRC6_3  = 34U,
    kRDC_Mem_MRC6_4  = 35U,
    kRDC_Mem_MRC6_5  = 36U,
    kRDC_Mem_MRC6_6  = 37U,
    kRDC_Mem_MRC6_7  = 38U,
    kRDC_Mem_MRC7_0  = 39U, /**< DRAM. Region resolution 4KB. */
    kRDC_Mem_MRC7_1  = 40U,
    kRDC_Mem_MRC7_2  = 41U,
    kRDC_Mem_MRC7_3  = 42U,
    kRDC_Mem_MRC7_4  = 43U,
    kRDC_Mem_MRC7_5  = 44U,
    kRDC_Mem_MRC7_6  = 45U,
    kRDC_Mem_MRC7_7  = 46U,
    kRDC_Mem_MRC8_0  = 47U, /**< DDRC(REG). Region resolution 4KB. */
    kRDC_Mem_MRC8_1  = 48U,
    kRDC_Mem_MRC8_2  = 49U,
    kRDC_Mem_MRC8_3  = 50U,
    kRDC_Mem_MRC8_4  = 51U,
    kRDC_Mem_MRC9_0  = 52U, /**< PCIe1, USB1/2. Region resolution 4KB. */
    kRDC_Mem_MRC9_1  = 53U,
    kRDC_Mem_MRC9_2  = 54U,
    kRDC_Mem_MRC9_3  = 55U,
    kRDC_Mem_MRC9_4  = 56U,
    kRDC_Mem_MRC9_5  = 57U,
    kRDC_Mem_MRC9_6  = 58U,
    kRDC_Mem_MRC9_7  = 59U,
    kRDC_Mem_MRC10_0 = 60U, /**< VPU. Region resolution 4KB. */
    kRDC_Mem_MRC10_1 = 61U,
    kRDC_Mem_MRC10_2 = 62U,
    kRDC_Mem_MRC10_3 = 63U,
    kRDC_Mem_MRC11_0 = 64U, /**< NPU. Region resolution 4KB. */
    kRDC_Mem_MRC11_1 = 65U,
    kRDC_Mem_MRC11_2 = 66U,
    kRDC_Mem_MRC11_3 = 67U,
    kRDC_Mem_MRC12_0 = 68U, /**< AUDIO PROCESSOR. Region resolution 4KB. */
    kRDC_Mem_MRC12_1 = 69U,
    kRDC_Mem_MRC12_2 = 70U,
    kRDC_Mem_MRC12_3 = 71U,
    kRDC_Mem_MRC13_0 = 72U, /**< OCRAM_A. Region resolution 128B. */
    kRDC_Mem_MRC13_1 = 73U,
    kRDC_Mem_MRC13_2 = 74U,
    kRDC_Mem_MRC13_3 = 75U,
    kRDC_Mem_MRC13_4 = 76U,
} rdc_mem_t;

typedef enum _rdc_periph
{
    kRDC_Periph_GPIO1               = 0U,   /**< GPIO1 RDC Peripheral */
    kRDC_Periph_GPIO2               = 1U,   /**< GPIO2 RDC Peripheral */
    kRDC_Periph_GPIO3               = 2U,   /**< GPIO3 RDC Peripheral */
    kRDC_Periph_GPIO4               = 3U,   /**< GPIO4 RDC Peripheral */
    kRDC_Periph_GPIO5               = 4U,   /**< GPIO5 RDC Peripheral */
    kRDC_Periph_MU2_A               = 5U,   /**< MU_2_A (A53, Audio Processor) RDC Peripheral */
    kRDC_Periph_ANA_TSENSOR         = 6U,   /**< ANA_TSENSOR RDC Peripheral */
    kRDC_Periph_ANA_OSC             = 7U,   /**< ANA_OSC RDC Peripheral */
    kRDC_Periph_WDOG1               = 8U,   /**< WDOG1 RDC Peripheral */
    kRDC_Periph_WDOG2               = 9U,   /**< WDOG2 RDC Peripheral */
    kRDC_Periph_WDOG3               = 10U,  /**< WDOG3 RDC Peripheral */
    kRDC_Periph_OCRAM_MECC          = 11U,  /**< OCRAM MECC RDC Peripheral */
    kRDC_Periph_OCRAM_S_MECC        = 12U,  /**< OCRAM_S MECC RDC Peripheral */
    kRDC_Periph_GPT1                = 13U,  /**< GPT1 RDC Peripheral */
    kRDC_Periph_GPT2                = 14U,  /**< GPT2 RDC Peripheral */
    kRDC_Periph_GPT3                = 15U,  /**< GPT3 RDC Peripheral */
    kRDC_Periph_MU2_B               = 16U,  /**< MU_2_B (A53, Audio Processor) RDC Peripheral */
    kRDC_Periph_ROMCP               = 17U,  /**< ROMCP RDC Peripheral */
    kRDC_Periph_MU3_A               = 18U,  /**< MU_3_A (M7, Audio Processor) RDC Peripheral */
    kRDC_Periph_IOMUXC              = 19U,  /**< IOMUXC RDC Peripheral */
    kRDC_Periph_IOMUXC_GPR          = 20U,  /**< IOMUXC_GPR RDC Peripheral */
    kRDC_Periph_OCOTP_CTRL          = 21U,  /**< OCOTP_CTRL RDC Peripheral */
    kRDC_Periph_ANA_PLL             = 22U,  /**< ANA_PLL RDC Peripheral */
    kRDC_Periph_SNVS_HP             = 23U,  /**< SNVS_HP GPR RDC Peripheral */
    kRDC_Periph_CCM                 = 24U,  /**< CCM RDC Peripheral */
    kRDC_Periph_SRC                 = 25U,  /**< SRC RDC Peripheral */
    kRDC_Periph_GPC                 = 26U,  /**< GPC RDC Peripheral */
    kRDC_Periph_SEMAPHORE1          = 27U,  /**< SEMAPHORE1 RDC Peripheral */
    kRDC_Periph_SEMAPHORE2          = 28U,  /**< SEMAPHORE2 RDC Peripheral */
    kRDC_Periph_RDC                 = 29U,  /**< RDC RDC Peripheral */
    kRDC_Periph_CSU                 = 30U,  /**< CSU RDC Peripheral */
    kRDC_Periph_MU3_B               = 31U,  /**< MU_3_B (M7, Audio Processor) RDC Peripheral */
    kRDC_Periph_ISI                 = 32U,  /**< ISI RDC Peripheral */
    kRDC_Periph_ISP0                = 33U,  /**< ISP0 RDC Peripheral */
    kRDC_Periph_ISP1                = 34U,  /**< ISP1 RDC Peripheral */
    kRDC_Periph_IPS_DEWARP          = 35U,  /**< IPS DEWARP RDC Peripheral */
    kRDC_Periph_MIPI_CSI0           = 36U,  /**< MIPI CSI0 RDC Peripheral */
    kRDC_Periph_HSIOMIX_BLK_CTL     = 37U,  /**< HSIOMIX BLK CTL RDC Peripheral */
    kRDC_Periph_PWM1                = 38U,  /**< PWM1 RDC Peripheral */
    kRDC_Periph_PWM2                = 39U,  /**< PWM2 RDC Peripheral */
    kRDC_Periph_PWM3                = 40U,  /**< PWM3 RDC Peripheral */
    kRDC_Periph_PWM4                = 41U,  /**< PWM4 RDC Peripheral */
    kRDC_Periph_SYS_COUNTER_RD      = 42U,  /**< System counter read RDC Peripheral */
    kRDC_Periph_SYS_COUNTER_CMP     = 43U,  /**< System counter compare RDC Peripheral */
    kRDC_Periph_SYS_COUNTER_CTRL    = 44U,  /**< System counter control RDC Peripheral */
    kRDC_Periph_I2C5                = 45U,  /**< I2C1 RDC Peripheral */
    kRDC_Periph_GPT6                = 46U,  /**< GPT6 RDC Peripheral */
    kRDC_Periph_GPT5                = 47U,  /**< GPT5 RDC Peripheral */
    kRDC_Periph_GPT4                = 48U,  /**< GPT4 RDC Peripheral */
    kRDC_Periph_MIPI_CSI1           = 49U,  /**< MIPI CSI1 RDC Peripheral */
    kRDC_Periph_MIPI_DSI0           = 50U,  /**< MIPI DSI0 RDC Peripheral */
    kRDC_Periph_MEDIAMIX_BLK_CTL    = 51U,  /**< MEDIAMIX BLK CTL RDC Peripheral */
    kRDC_Periph_LCDIF1              = 52U,  /**< LCDIF1 RDC Peripheral */
    kRDC_Periph_EDMA                = 53U,  /**< EDMA RDC Peripheral */
    kRDC_Periph_EDMA_0_15           = 54U,  /**< EDMA Channels [0:15] RDC Peripheral */
    kRDC_Periph_EDMA_16_31          = 55U,  /**< EDMA Channels [1:31] RDC Peripheral */
    kRDC_Periph_TZASC               = 56U,  /**< TZASC RDC Peripheral */
    kRDC_Periph_I2C6                = 57U,  /**< I2C6 RDC Peripheral */
    kRDC_Periph_CAAM                = 58U,  /**< CAAM RDC Peripheral */
    kRDC_Periph_LCDIF2              = 59U,  /**< LCDIF2 RDC Peripheral */
    kRDC_Periph_PERFMON1            = 60U,  /**< PERFMON1 RDC Peripheral */
    kRDC_Periph_PERFMON2            = 61U,  /**< PERFMON2 RDC Peripheral */
    kRDC_Periph_PLATFORM_CTRL       = 62U,  /**< PLATFORM_CTRL RDC Peripheral */
    kRDC_Periph_QOSC                = 63U,  /**< QOSC RDC Peripheral */
    kRDC_Periph_LVDS0               = 64U,  /**< LVDS0 RDC Peripheral */
    kRDC_Periph_LVDS1               = 65U,  /**< LVDS1 RDC Peripheral */
    kRDC_Periph_I2C1                = 66U,  /**< I2C1 RDC Peripheral */
    kRDC_Periph_I2C2                = 67U,  /**< I2C2 RDC Peripheral */
    kRDC_Periph_I2C3                = 68U,  /**< I2C3 RDC Peripheral */
    kRDC_Periph_I2C4                = 69U,  /**< I2C4 RDC Peripheral */
    kRDC_Periph_UART4               = 70U,  /**< UART4 RDC Peripheral */
    kRDC_Periph_HDMI_TX             = 71U,  /**< HDMI TX RDC Peripheral */
    kRDC_Periph_IRQ_STEER           = 72U,  /**< IRQ STEER (Audio Processor) RDC Peripheral */
    kRDC_Periph_SDMA2               = 73U,  /**< SDMA2 RDC Peripheral */
    kRDC_Periph_MU1_A               = 74U,  /**< MU1_A RDC Peripheral */
    kRDC_Periph_MU1_B               = 75U,  /**< MU1_B RDC Peripheral */
    kRDC_Periph_SEMAPHORE_HS        = 76U,  /**< SEMAPHORE_HS RDC Peripheral */
    kRDC_Periph_SAI1                = 78U,  /**< SAI1 RDC Peripheral */
    kRDC_Periph_SAI2                = 79U,  /**< SAI2 RDC Peripheral */
    kRDC_Periph_SAI3                = 80U,  /**< SAI3 RDC Peripheral */
    kRDC_Periph_CAN_FD1             = 81U,  /**< CAN_FD1 RDC Peripheral */
    kRDC_Periph_SAI5                = 82U,  /**< SAI5 RDC Peripheral */
    kRDC_Periph_SAI6                = 83U,  /**< SAI6 RDC Peripheral */
    kRDC_Periph_USDHC1              = 84U,  /**< USDHC1 RDC Peripheral */
    kRDC_Periph_USDHC2              = 85U,  /**< USDHC2 RDC Peripheral */
    kRDC_Periph_USDHC3              = 86U,  /**< USDHC3 RDC Peripheral */
    kRDC_Periph_PCIE_PHY1           = 87U,  /**< PCIE PHY1 RDC Peripheral */
    kRDC_Periph_HDMI_TX_AUDLNK_MSTR = 88U,  /**< HDMI TX AUDLNK MSTR RDC Peripheral */
    kRDC_Periph_CAN_FD2             = 89U,  /**< CAN_FD2 RDC Peripheral */
    kRDC_Periph_SPBA2               = 90U,  /**< SPBA2 RDC Peripheral */
    kRDC_Periph_QSPI                = 91U,  /**< QSPI RDC Peripheral */
    kRDC_Periph_AUDIO_BLK_CTRL      = 92U,  /**< AUDIO BLK CTRL RDC Peripheral */
    kRDC_Periph_SDMA1               = 93U,  /**< SDMA1 RDC Peripheral */
    kRDC_Periph_ENET1               = 94U,  /**< ENET1 RDC Peripheral */
    kRDC_Periph_ENET2_TSN           = 95U,  /**< ENET2 TSN RDC Peripheral */
    kRDC_Periph_SPDIF1              = 97U,  /**< SPDIF1 RDC Peripheral */
    kRDC_Periph_ECSPI1              = 98U,  /**< ECSPI1 RDC Peripheral */
    kRDC_Periph_ECSPI2              = 99U,  /**< ECSPI2 RDC Peripheral */
    kRDC_Periph_ECSPI3              = 100U, /**< ECSPI3 RDC Peripheral */
    kRDC_Periph_SAI7                = 101U, /**< SAI7 RDC Peripheral */
    kRDC_Periph_UART1               = 102U, /**< UART1 RDC Peripheral */
    kRDC_Periph_UART3               = 104U, /**< UART3 RDC Peripheral */
    kRDC_Periph_UART2               = 105U, /**< UART2 RDC Peripheral */
    kRDC_Periph_PDM                 = 106U, /**< PDM (MICFIL) RDC Peripheral */
    kRDC_Periph_AUDIO_XCVR_RX       = 107U, /**< AUDIO XCVR RX RDC (eARC)Peripheral */
    kRDC_Periph_SDMA3               = 109U, /**< SDMA3 RDC Peripheral */
    kRDC_Periph_SPBA1               = 111U, /**< SPBA1 RDC Peripheral */
} rdc_periph_t;

/* @} */

/*!
 * @}
 */ /* end of group Mapping_Information */

/* ----------------------------------------------------------------------------
   -- Device Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Peripheral_access_layer Device Peripheral Access Layer
 * @{
 */

/*
** Start of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
#if (__ARMCC_VERSION >= 6010050)
#pragma clang diagnostic push
#else
#pragma push
#pragma anon_unions
#endif
#elif defined(__GNUC__)
/* anonymous unions are enabled by default */
#elif defined(__IAR_SYSTEMS_ICC__)
#pragma language = extended
#else
#error Not supported compiler type
#endif

/* ----------------------------------------------------------------------------
   -- AIPSTZ Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AIPSTZ_Peripheral_Access_Layer AIPSTZ Peripheral Access Layer
 * @{
 */

/** AIPSTZ - Register Layout Typedef */
typedef struct
{
    __IO uint32_t MPR; /**< Master Priviledge Registers, offset: 0x0 */
    uint8_t RESERVED_0[60];
    __IO uint32_t OPACR;  /**< Off-Platform Peripheral Access Control Registers, offset: 0x40 */
    __IO uint32_t OPACR1; /**< Off-Platform Peripheral Access Control Registers, offset: 0x44 */
    __IO uint32_t OPACR2; /**< Off-Platform Peripheral Access Control Registers, offset: 0x48 */
    __IO uint32_t OPACR3; /**< Off-Platform Peripheral Access Control Registers, offset: 0x4C */
    __IO uint32_t OPACR4; /**< Off-Platform Peripheral Access Control Registers, offset: 0x50 */
} AIPSTZ_Type;

/* ----------------------------------------------------------------------------
   -- AIPSTZ Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AIPSTZ_Register_Masks AIPSTZ Register Masks
 * @{
 */

/*! @name MPR - Master Priviledge Registers */
/*! @{ */
#define AIPSTZ_MPR_MPROT5_MASK  (0xF00U)
#define AIPSTZ_MPR_MPROT5_SHIFT (8U)
/*! MPROT5
 *  0bxxx0..Accesses from this master are forced to user-mode (ips_supervisor_access is forced to zero) regardless of
 * the hprot[1] access attribute. 0bxxx1..Accesses from this master are not forced to user-mode. The hprot[1] access
 * attribute is used directly to determine ips_supervisor_access. 0bxx0x..This master is not trusted for write accesses.
 *  0bxx1x..This master is trusted for write accesses.
 *  0bx0xx..This master is not trusted for read accesses.
 *  0bx1xx..This master is trusted for read accesses.
 *  0b1xxx..Write accesses from this master are allowed to be buffered
 */
#define AIPSTZ_MPR_MPROT5(x)    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_MPR_MPROT5_SHIFT)) & AIPSTZ_MPR_MPROT5_MASK)
#define AIPSTZ_MPR_MPROT3_MASK  (0xF0000U)
#define AIPSTZ_MPR_MPROT3_SHIFT (16U)
/*! MPROT3
 *  0bxxx0..Accesses from this master are forced to user-mode (ips_supervisor_access is forced to zero) regardless of
 * the hprot[1] access attribute. 0bxxx1..Accesses from this master are not forced to user-mode. The hprot[1] access
 * attribute is used directly to determine ips_supervisor_access. 0bxx0x..This master is not trusted for write accesses.
 *  0bxx1x..This master is trusted for write accesses.
 *  0bx0xx..This master is not trusted for read accesses.
 *  0bx1xx..This master is trusted for read accesses.
 *  0b1xxx..Write accesses from this master are allowed to be buffered
 */
#define AIPSTZ_MPR_MPROT3(x)    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_MPR_MPROT3_SHIFT)) & AIPSTZ_MPR_MPROT3_MASK)
#define AIPSTZ_MPR_MPROT2_MASK  (0xF00000U)
#define AIPSTZ_MPR_MPROT2_SHIFT (20U)
/*! MPROT2
 *  0bxxx0..Accesses from this master are forced to user-mode (ips_supervisor_access is forced to zero) regardless of
 * the hprot[1] access attribute. 0bxxx1..Accesses from this master are not forced to user-mode. The hprot[1] access
 * attribute is used directly to determine ips_supervisor_access. 0bxx0x..This master is not trusted for write accesses.
 *  0bxx1x..This master is trusted for write accesses.
 *  0bx0xx..This master is not trusted for read accesses.
 *  0bx1xx..This master is trusted for read accesses.
 *  0b1xxx..Write accesses from this master are allowed to be buffered
 */
#define AIPSTZ_MPR_MPROT2(x)    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_MPR_MPROT2_SHIFT)) & AIPSTZ_MPR_MPROT2_MASK)
#define AIPSTZ_MPR_MPROT1_MASK  (0xF000000U)
#define AIPSTZ_MPR_MPROT1_SHIFT (24U)
/*! MPROT1
 *  0bxxx0..Accesses from this master are forced to user-mode (ips_supervisor_access is forced to zero) regardless of
 * the hprot[1] access attribute. 0bxxx1..Accesses from this master are not forced to user-mode. The hprot[1] access
 * attribute is used directly to determine ips_supervisor_access. 0bxx0x..This master is not trusted for write accesses.
 *  0bxx1x..This master is trusted for write accesses.
 *  0bx0xx..This master is not trusted for read accesses.
 *  0bx1xx..This master is trusted for read accesses.
 *  0b1xxx..Write accesses from this master are allowed to be buffered
 */
#define AIPSTZ_MPR_MPROT1(x)    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_MPR_MPROT1_SHIFT)) & AIPSTZ_MPR_MPROT1_MASK)
#define AIPSTZ_MPR_MPROT0_MASK  (0xF0000000U)
#define AIPSTZ_MPR_MPROT0_SHIFT (28U)
/*! MPROT0
 *  0bxxx0..Accesses from this master are forced to user-mode (ips_supervisor_access is forced to zero) regardless of
 * the hprot[1] access attribute. 0bxxx1..Accesses from this master are not forced to user-mode. The hprot[1] access
 * attribute is used directly to determine ips_supervisor_access. 0bxx0x..This master is not trusted for write accesses.
 *  0bxx1x..This master is trusted for write accesses.
 *  0bx0xx..This master is not trusted for read accesses.
 *  0bx1xx..This master is trusted for read accesses.
 *  0b1xxx..Write accesses from this master are allowed to be buffered
 */
#define AIPSTZ_MPR_MPROT0(x) (((uint32_t)(((uint32_t)(x)) << AIPSTZ_MPR_MPROT0_SHIFT)) & AIPSTZ_MPR_MPROT0_MASK)
/*! @} */

/*! @name OPACR - Off-Platform Peripheral Access Control Registers */
/*! @{ */
#define AIPSTZ_OPACR_OPAC7_MASK  (0xFU)
#define AIPSTZ_OPACR_OPAC7_SHIFT (0U)
/*! OPAC7
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR_OPAC7(x)    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR_OPAC7_SHIFT)) & AIPSTZ_OPACR_OPAC7_MASK)
#define AIPSTZ_OPACR_OPAC6_MASK  (0xF0U)
#define AIPSTZ_OPACR_OPAC6_SHIFT (4U)
/*! OPAC6
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR_OPAC6(x)    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR_OPAC6_SHIFT)) & AIPSTZ_OPACR_OPAC6_MASK)
#define AIPSTZ_OPACR_OPAC5_MASK  (0xF00U)
#define AIPSTZ_OPACR_OPAC5_SHIFT (8U)
/*! OPAC5
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR_OPAC5(x)    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR_OPAC5_SHIFT)) & AIPSTZ_OPACR_OPAC5_MASK)
#define AIPSTZ_OPACR_OPAC4_MASK  (0xF000U)
#define AIPSTZ_OPACR_OPAC4_SHIFT (12U)
/*! OPAC4
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR_OPAC4(x)    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR_OPAC4_SHIFT)) & AIPSTZ_OPACR_OPAC4_MASK)
#define AIPSTZ_OPACR_OPAC3_MASK  (0xF0000U)
#define AIPSTZ_OPACR_OPAC3_SHIFT (16U)
/*! OPAC3
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR_OPAC3(x)    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR_OPAC3_SHIFT)) & AIPSTZ_OPACR_OPAC3_MASK)
#define AIPSTZ_OPACR_OPAC2_MASK  (0xF00000U)
#define AIPSTZ_OPACR_OPAC2_SHIFT (20U)
/*! OPAC2
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR_OPAC2(x)    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR_OPAC2_SHIFT)) & AIPSTZ_OPACR_OPAC2_MASK)
#define AIPSTZ_OPACR_OPAC1_MASK  (0xF000000U)
#define AIPSTZ_OPACR_OPAC1_SHIFT (24U)
/*! OPAC1
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR_OPAC1(x)    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR_OPAC1_SHIFT)) & AIPSTZ_OPACR_OPAC1_MASK)
#define AIPSTZ_OPACR_OPAC0_MASK  (0xF0000000U)
#define AIPSTZ_OPACR_OPAC0_SHIFT (28U)
/*! OPAC0
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR_OPAC0(x) (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR_OPAC0_SHIFT)) & AIPSTZ_OPACR_OPAC0_MASK)
/*! @} */

/*! @name OPACR1 - Off-Platform Peripheral Access Control Registers */
/*! @{ */
#define AIPSTZ_OPACR1_OPAC15_MASK  (0xFU)
#define AIPSTZ_OPACR1_OPAC15_SHIFT (0U)
/*! OPAC15
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR1_OPAC15(x) \
    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR1_OPAC15_SHIFT)) & AIPSTZ_OPACR1_OPAC15_MASK)
#define AIPSTZ_OPACR1_OPAC14_MASK  (0xF0U)
#define AIPSTZ_OPACR1_OPAC14_SHIFT (4U)
/*! OPAC14
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR1_OPAC14(x) \
    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR1_OPAC14_SHIFT)) & AIPSTZ_OPACR1_OPAC14_MASK)
#define AIPSTZ_OPACR1_OPAC13_MASK  (0xF00U)
#define AIPSTZ_OPACR1_OPAC13_SHIFT (8U)
/*! OPAC13
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR1_OPAC13(x) \
    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR1_OPAC13_SHIFT)) & AIPSTZ_OPACR1_OPAC13_MASK)
#define AIPSTZ_OPACR1_OPAC12_MASK  (0xF000U)
#define AIPSTZ_OPACR1_OPAC12_SHIFT (12U)
/*! OPAC12
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR1_OPAC12(x) \
    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR1_OPAC12_SHIFT)) & AIPSTZ_OPACR1_OPAC12_MASK)
#define AIPSTZ_OPACR1_OPAC11_MASK  (0xF0000U)
#define AIPSTZ_OPACR1_OPAC11_SHIFT (16U)
/*! OPAC11
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR1_OPAC11(x) \
    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR1_OPAC11_SHIFT)) & AIPSTZ_OPACR1_OPAC11_MASK)
#define AIPSTZ_OPACR1_OPAC10_MASK  (0xF00000U)
#define AIPSTZ_OPACR1_OPAC10_SHIFT (20U)
/*! OPAC10
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR1_OPAC10(x) \
    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR1_OPAC10_SHIFT)) & AIPSTZ_OPACR1_OPAC10_MASK)
#define AIPSTZ_OPACR1_OPAC9_MASK  (0xF000000U)
#define AIPSTZ_OPACR1_OPAC9_SHIFT (24U)
/*! OPAC9
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR1_OPAC9(x)    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR1_OPAC9_SHIFT)) & AIPSTZ_OPACR1_OPAC9_MASK)
#define AIPSTZ_OPACR1_OPAC8_MASK  (0xF0000000U)
#define AIPSTZ_OPACR1_OPAC8_SHIFT (28U)
/*! OPAC8
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR1_OPAC8(x) (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR1_OPAC8_SHIFT)) & AIPSTZ_OPACR1_OPAC8_MASK)
/*! @} */

/*! @name OPACR2 - Off-Platform Peripheral Access Control Registers */
/*! @{ */
#define AIPSTZ_OPACR2_OPAC23_MASK  (0xFU)
#define AIPSTZ_OPACR2_OPAC23_SHIFT (0U)
/*! OPAC23
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR2_OPAC23(x) \
    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR2_OPAC23_SHIFT)) & AIPSTZ_OPACR2_OPAC23_MASK)
#define AIPSTZ_OPACR2_OPAC22_MASK  (0xF0U)
#define AIPSTZ_OPACR2_OPAC22_SHIFT (4U)
/*! OPAC22
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR2_OPAC22(x) \
    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR2_OPAC22_SHIFT)) & AIPSTZ_OPACR2_OPAC22_MASK)
#define AIPSTZ_OPACR2_OPAC21_MASK  (0xF00U)
#define AIPSTZ_OPACR2_OPAC21_SHIFT (8U)
/*! OPAC21
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR2_OPAC21(x) \
    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR2_OPAC21_SHIFT)) & AIPSTZ_OPACR2_OPAC21_MASK)
#define AIPSTZ_OPACR2_OPAC20_MASK  (0xF000U)
#define AIPSTZ_OPACR2_OPAC20_SHIFT (12U)
/*! OPAC20
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR2_OPAC20(x) \
    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR2_OPAC20_SHIFT)) & AIPSTZ_OPACR2_OPAC20_MASK)
#define AIPSTZ_OPACR2_OPAC19_MASK  (0xF0000U)
#define AIPSTZ_OPACR2_OPAC19_SHIFT (16U)
/*! OPAC19
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR2_OPAC19(x) \
    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR2_OPAC19_SHIFT)) & AIPSTZ_OPACR2_OPAC19_MASK)
#define AIPSTZ_OPACR2_OPAC18_MASK  (0xF00000U)
#define AIPSTZ_OPACR2_OPAC18_SHIFT (20U)
/*! OPAC18
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR2_OPAC18(x) \
    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR2_OPAC18_SHIFT)) & AIPSTZ_OPACR2_OPAC18_MASK)
#define AIPSTZ_OPACR2_OPAC17_MASK  (0xF000000U)
#define AIPSTZ_OPACR2_OPAC17_SHIFT (24U)
/*! OPAC17
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR2_OPAC17(x) \
    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR2_OPAC17_SHIFT)) & AIPSTZ_OPACR2_OPAC17_MASK)
#define AIPSTZ_OPACR2_OPAC16_MASK  (0xF0000000U)
#define AIPSTZ_OPACR2_OPAC16_SHIFT (28U)
/*! OPAC16
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR2_OPAC16(x) \
    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR2_OPAC16_SHIFT)) & AIPSTZ_OPACR2_OPAC16_MASK)
/*! @} */

/*! @name OPACR3 - Off-Platform Peripheral Access Control Registers */
/*! @{ */
#define AIPSTZ_OPACR3_OPAC31_MASK  (0xFU)
#define AIPSTZ_OPACR3_OPAC31_SHIFT (0U)
/*! OPAC31
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR3_OPAC31(x) \
    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR3_OPAC31_SHIFT)) & AIPSTZ_OPACR3_OPAC31_MASK)
#define AIPSTZ_OPACR3_OPAC30_MASK  (0xF0U)
#define AIPSTZ_OPACR3_OPAC30_SHIFT (4U)
/*! OPAC30
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR3_OPAC30(x) \
    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR3_OPAC30_SHIFT)) & AIPSTZ_OPACR3_OPAC30_MASK)
#define AIPSTZ_OPACR3_OPAC29_MASK  (0xF00U)
#define AIPSTZ_OPACR3_OPAC29_SHIFT (8U)
/*! OPAC29
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR3_OPAC29(x) \
    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR3_OPAC29_SHIFT)) & AIPSTZ_OPACR3_OPAC29_MASK)
#define AIPSTZ_OPACR3_OPAC28_MASK  (0xF000U)
#define AIPSTZ_OPACR3_OPAC28_SHIFT (12U)
/*! OPAC28
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR3_OPAC28(x) \
    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR3_OPAC28_SHIFT)) & AIPSTZ_OPACR3_OPAC28_MASK)
#define AIPSTZ_OPACR3_OPAC27_MASK  (0xF0000U)
#define AIPSTZ_OPACR3_OPAC27_SHIFT (16U)
/*! OPAC27
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR3_OPAC27(x) \
    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR3_OPAC27_SHIFT)) & AIPSTZ_OPACR3_OPAC27_MASK)
#define AIPSTZ_OPACR3_OPAC26_MASK  (0xF00000U)
#define AIPSTZ_OPACR3_OPAC26_SHIFT (20U)
/*! OPAC26
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR3_OPAC26(x) \
    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR3_OPAC26_SHIFT)) & AIPSTZ_OPACR3_OPAC26_MASK)
#define AIPSTZ_OPACR3_OPAC25_MASK  (0xF000000U)
#define AIPSTZ_OPACR3_OPAC25_SHIFT (24U)
/*! OPAC25
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR3_OPAC25(x) \
    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR3_OPAC25_SHIFT)) & AIPSTZ_OPACR3_OPAC25_MASK)
#define AIPSTZ_OPACR3_OPAC24_MASK  (0xF0000000U)
#define AIPSTZ_OPACR3_OPAC24_SHIFT (28U)
/*! OPAC24
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR3_OPAC24(x) \
    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR3_OPAC24_SHIFT)) & AIPSTZ_OPACR3_OPAC24_MASK)
/*! @} */

/*! @name OPACR4 - Off-Platform Peripheral Access Control Registers */
/*! @{ */
#define AIPSTZ_OPACR4_OPAC33_MASK  (0xF000000U)
#define AIPSTZ_OPACR4_OPAC33_SHIFT (24U)
/*! OPAC33
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR4_OPAC33(x) \
    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR4_OPAC33_SHIFT)) & AIPSTZ_OPACR4_OPAC33_MASK)
#define AIPSTZ_OPACR4_OPAC32_MASK  (0xF0000000U)
#define AIPSTZ_OPACR4_OPAC32_SHIFT (28U)
/*! OPAC32
 *  0bxxx0..Accesses from an untrusted master are allowed.
 *  0bxxx1..Accesses from an untrusted master are not allowed. If an access is attempted by an untrusted master,
 *          the access is terminated with an error response and no peripheral access is initiated on the IPS bus.
 *  0bxx0x..This peripheral allows write accesses.
 *  0bxx1x..This peripheral is write protected. If a write access is attempted, the access is terminated with an
 *          error response and no peripheral access is initiated on the IPS bus.
 *  0bx0xx..This peripheral does not require supervisor privilege level for accesses.
 *  0bx1xx..This peripheral requires supervisor privilege level for accesses. The master privilege level must
 *          indicate supervisor via the hprot[1] access attribute, and the MPROTx[MPL] control bit for the master must
 *          be set. If not, the access is terminated with an error response and no peripheral access is initiated
 *          on the IPS bus.
 *  0b1xxx..Write accesses to this peripheral are allowed to be buffered by the AIPSTZ.
 */
#define AIPSTZ_OPACR4_OPAC32(x) \
    (((uint32_t)(((uint32_t)(x)) << AIPSTZ_OPACR4_OPAC32_SHIFT)) & AIPSTZ_OPACR4_OPAC32_MASK)
/*! @} */

/*!
 * @}
 */ /* end of group AIPSTZ_Register_Masks */

/* AIPSTZ - Peripheral instance base addresses */
/** Peripheral AIPSTZ1 base address */
#define AIPSTZ1_BASE (0x301F0000u)
/** Peripheral AIPSTZ1 base pointer */
#define AIPSTZ1 ((AIPSTZ_Type *)AIPSTZ1_BASE)
/** Peripheral AIPSTZ2 base address */
#define AIPSTZ2_BASE (0x305F0000u)
/** Peripheral AIPSTZ2 base pointer */
#define AIPSTZ2 ((AIPSTZ_Type *)AIPSTZ2_BASE)
/** Peripheral AIPSTZ3 base address */
#define AIPSTZ3_BASE (0x309F0000u)
/** Peripheral AIPSTZ3 base pointer */
#define AIPSTZ3 ((AIPSTZ_Type *)AIPSTZ3_BASE)
/** Peripheral AIPSTZ4 base address */
#define AIPSTZ4_BASE (0x32DF0000u)
/** Peripheral AIPSTZ4 base pointer */
#define AIPSTZ4 ((AIPSTZ_Type *)AIPSTZ4_BASE)
/** Peripheral AIPSTZ5 base address */
#define AIPSTZ5_BASE (0x30DF0000u)
/** Peripheral AIPSTZ5 base pointer */
#define AIPSTZ5 ((AIPSTZ_Type *)AIPSTZ5_BASE)
/** Array initializer of AIPSTZ peripheral base addresses */
#define AIPSTZ_BASE_ADDRS                                                    \
    {                                                                        \
        AIPSTZ1_BASE, AIPSTZ2_BASE, AIPSTZ3_BASE, AIPSTZ4_BASE, AIPSTZ5_BASE \
    }
/** Array initializer of AIPSTZ peripheral base pointers */
#define AIPSTZ_BASE_PTRS                            \
    {                                               \
        AIPSTZ1, AIPSTZ2, AIPSTZ3, AIPSTZ4, AIPSTZ5 \
    }

/*!
 * @}
 */ /* end of group AIPSTZ_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- APBH Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup APBH_Peripheral_Access_Layer APBH Peripheral Access Layer
 * @{
 */

/** APBH - Register Layout Typedef */
typedef struct
{
    __IO uint32_t CTRL0;            /**< AHB to APBH Bridge Control and Status Register 0, offset: 0x0 */
    __IO uint32_t CTRL0_SET;        /**< AHB to APBH Bridge Control and Status Register 0, offset: 0x4 */
    __IO uint32_t CTRL0_CLR;        /**< AHB to APBH Bridge Control and Status Register 0, offset: 0x8 */
    __IO uint32_t CTRL0_TOG;        /**< AHB to APBH Bridge Control and Status Register 0, offset: 0xC */
    __IO uint32_t CTRL1;            /**< AHB to APBH Bridge Control and Status Register 1, offset: 0x10 */
    __IO uint32_t CTRL1_SET;        /**< AHB to APBH Bridge Control and Status Register 1, offset: 0x14 */
    __IO uint32_t CTRL1_CLR;        /**< AHB to APBH Bridge Control and Status Register 1, offset: 0x18 */
    __IO uint32_t CTRL1_TOG;        /**< AHB to APBH Bridge Control and Status Register 1, offset: 0x1C */
    __IO uint32_t CTRL2;            /**< AHB to APBH Bridge Control and Status Register 2, offset: 0x20 */
    __IO uint32_t CTRL2_SET;        /**< AHB to APBH Bridge Control and Status Register 2, offset: 0x24 */
    __IO uint32_t CTRL2_CLR;        /**< AHB to APBH Bridge Control and Status Register 2, offset: 0x28 */
    __IO uint32_t CTRL2_TOG;        /**< AHB to APBH Bridge Control and Status Register 2, offset: 0x2C */
    __IO uint32_t CHANNEL_CTRL;     /**< AHB to APBH Bridge Channel Register, offset: 0x30 */
    __IO uint32_t CHANNEL_CTRL_SET; /**< AHB to APBH Bridge Channel Register, offset: 0x34 */
    __IO uint32_t CHANNEL_CTRL_CLR; /**< AHB to APBH Bridge Channel Register, offset: 0x38 */
    __IO uint32_t CHANNEL_CTRL_TOG; /**< AHB to APBH Bridge Channel Register, offset: 0x3C */
    __I uint32_t DEVSEL;            /**< AHB to APBH DMA Device Assignment Register, offset: 0x40 */
    uint8_t RESERVED_0[12];
    __IO uint32_t DMA_BURST_SIZE; /**< AHB to APBH DMA burst size, offset: 0x50 */
    uint8_t RESERVED_1[12];
    __IO uint32_t DEBUGr; /**< AHB to APBH DMA Debug Register, offset: 0x60 */
    uint8_t RESERVED_2[156];
    struct
    {                             /* offset: 0x100, array step: 0x70 */
        __I uint32_t CH_CURCMDAR; /**< APBH DMA Channel n Current Command Address Register, array offset: 0x100, array
                                     step: 0x70 */
        uint8_t RESERVED_0[12];
        __IO uint32_t
            CH_NXTCMDAR; /**< APBH DMA Channel n Next Command Address Register, array offset: 0x110, array step: 0x70 */
        uint8_t RESERVED_1[12];
        __I uint32_t CH_CMD; /**< APBH DMA Channel n Command Register, array offset: 0x120, array step: 0x70 */
        uint8_t RESERVED_2[12];
        __I uint32_t CH_BAR; /**< APBH DMA Channel n Buffer Address Register, array offset: 0x130, array step: 0x70 */
        uint8_t RESERVED_3[12];
        __IO uint32_t CH_SEMA; /**< APBH DMA Channel n Semaphore Register, array offset: 0x140, array step: 0x70 */
        uint8_t RESERVED_4[12];
        __I uint32_t
            CH_DEBUG1; /**< AHB to APBH DMA Channel n Debug Information, array offset: 0x150, array step: 0x70 */
        uint8_t RESERVED_5[12];
        __I uint32_t
            CH_DEBUG2; /**< AHB to APBH DMA Channel n Debug Information, array offset: 0x160, array step: 0x70 */
        uint8_t RESERVED_6[12];
    } CH_CFGn[16];
    __I uint32_t VERSION; /**< APBH Bridge Version Register, offset: 0x800 */
} APBH_Type;

/* ----------------------------------------------------------------------------
   -- APBH Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup APBH_Register_Masks APBH Register Masks
 * @{
 */

/*! @name CTRL0 - AHB to APBH Bridge Control and Status Register 0 */
/*! @{ */
#define APBH_CTRL0_CLKGATE_CHANNEL_MASK  (0xFFFFU)
#define APBH_CTRL0_CLKGATE_CHANNEL_SHIFT (0U)
/*! CLKGATE_CHANNEL
 *  0b0000000000000001..NAND0
 *  0b0000000000000010..NAND1
 *  0b0000000000000100..NAND2
 *  0b0000000000001000..NAND3
 *  0b0000000000010000..NAND4
 *  0b0000000000100000..NAND5
 *  0b0000000001000000..NAND6
 *  0b0000000010000000..NAND7
 *  0b0000000100000000..SSP
 */
#define APBH_CTRL0_CLKGATE_CHANNEL(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_CLKGATE_CHANNEL_SHIFT)) & APBH_CTRL0_CLKGATE_CHANNEL_MASK)
#define APBH_CTRL0_RSVD0_MASK         (0xFFF0000U)
#define APBH_CTRL0_RSVD0_SHIFT        (16U)
#define APBH_CTRL0_RSVD0(x)           (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_RSVD0_SHIFT)) & APBH_CTRL0_RSVD0_MASK)
#define APBH_CTRL0_APB_BURST_EN_MASK  (0x10000000U)
#define APBH_CTRL0_APB_BURST_EN_SHIFT (28U)
#define APBH_CTRL0_APB_BURST_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_APB_BURST_EN_SHIFT)) & APBH_CTRL0_APB_BURST_EN_MASK)
#define APBH_CTRL0_AHB_BURST8_EN_MASK  (0x20000000U)
#define APBH_CTRL0_AHB_BURST8_EN_SHIFT (29U)
#define APBH_CTRL0_AHB_BURST8_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_AHB_BURST8_EN_SHIFT)) & APBH_CTRL0_AHB_BURST8_EN_MASK)
#define APBH_CTRL0_CLKGATE_MASK  (0x40000000U)
#define APBH_CTRL0_CLKGATE_SHIFT (30U)
#define APBH_CTRL0_CLKGATE(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_CLKGATE_SHIFT)) & APBH_CTRL0_CLKGATE_MASK)
#define APBH_CTRL0_SFTRST_MASK   (0x80000000U)
#define APBH_CTRL0_SFTRST_SHIFT  (31U)
#define APBH_CTRL0_SFTRST(x)     (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_SFTRST_SHIFT)) & APBH_CTRL0_SFTRST_MASK)
/*! @} */

/*! @name CTRL0_SET - AHB to APBH Bridge Control and Status Register 0 */
/*! @{ */
#define APBH_CTRL0_SET_CLKGATE_CHANNEL_MASK  (0xFFFFU)
#define APBH_CTRL0_SET_CLKGATE_CHANNEL_SHIFT (0U)
/*! CLKGATE_CHANNEL
 *  0b0000000000000001..NAND0
 *  0b0000000000000010..NAND1
 *  0b0000000000000100..NAND2
 *  0b0000000000001000..NAND3
 *  0b0000000000010000..NAND4
 *  0b0000000000100000..NAND5
 *  0b0000000001000000..NAND6
 *  0b0000000010000000..NAND7
 *  0b0000000100000000..SSP
 */
#define APBH_CTRL0_SET_CLKGATE_CHANNEL(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_SET_CLKGATE_CHANNEL_SHIFT)) & APBH_CTRL0_SET_CLKGATE_CHANNEL_MASK)
#define APBH_CTRL0_SET_RSVD0_MASK  (0xFFF0000U)
#define APBH_CTRL0_SET_RSVD0_SHIFT (16U)
#define APBH_CTRL0_SET_RSVD0(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_SET_RSVD0_SHIFT)) & APBH_CTRL0_SET_RSVD0_MASK)
#define APBH_CTRL0_SET_APB_BURST_EN_MASK  (0x10000000U)
#define APBH_CTRL0_SET_APB_BURST_EN_SHIFT (28U)
#define APBH_CTRL0_SET_APB_BURST_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_SET_APB_BURST_EN_SHIFT)) & APBH_CTRL0_SET_APB_BURST_EN_MASK)
#define APBH_CTRL0_SET_AHB_BURST8_EN_MASK  (0x20000000U)
#define APBH_CTRL0_SET_AHB_BURST8_EN_SHIFT (29U)
#define APBH_CTRL0_SET_AHB_BURST8_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_SET_AHB_BURST8_EN_SHIFT)) & APBH_CTRL0_SET_AHB_BURST8_EN_MASK)
#define APBH_CTRL0_SET_CLKGATE_MASK  (0x40000000U)
#define APBH_CTRL0_SET_CLKGATE_SHIFT (30U)
#define APBH_CTRL0_SET_CLKGATE(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_SET_CLKGATE_SHIFT)) & APBH_CTRL0_SET_CLKGATE_MASK)
#define APBH_CTRL0_SET_SFTRST_MASK  (0x80000000U)
#define APBH_CTRL0_SET_SFTRST_SHIFT (31U)
#define APBH_CTRL0_SET_SFTRST(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_SET_SFTRST_SHIFT)) & APBH_CTRL0_SET_SFTRST_MASK)
/*! @} */

/*! @name CTRL0_CLR - AHB to APBH Bridge Control and Status Register 0 */
/*! @{ */
#define APBH_CTRL0_CLR_CLKGATE_CHANNEL_MASK  (0xFFFFU)
#define APBH_CTRL0_CLR_CLKGATE_CHANNEL_SHIFT (0U)
/*! CLKGATE_CHANNEL
 *  0b0000000000000001..NAND0
 *  0b0000000000000010..NAND1
 *  0b0000000000000100..NAND2
 *  0b0000000000001000..NAND3
 *  0b0000000000010000..NAND4
 *  0b0000000000100000..NAND5
 *  0b0000000001000000..NAND6
 *  0b0000000010000000..NAND7
 *  0b0000000100000000..SSP
 */
#define APBH_CTRL0_CLR_CLKGATE_CHANNEL(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_CLR_CLKGATE_CHANNEL_SHIFT)) & APBH_CTRL0_CLR_CLKGATE_CHANNEL_MASK)
#define APBH_CTRL0_CLR_RSVD0_MASK  (0xFFF0000U)
#define APBH_CTRL0_CLR_RSVD0_SHIFT (16U)
#define APBH_CTRL0_CLR_RSVD0(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_CLR_RSVD0_SHIFT)) & APBH_CTRL0_CLR_RSVD0_MASK)
#define APBH_CTRL0_CLR_APB_BURST_EN_MASK  (0x10000000U)
#define APBH_CTRL0_CLR_APB_BURST_EN_SHIFT (28U)
#define APBH_CTRL0_CLR_APB_BURST_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_CLR_APB_BURST_EN_SHIFT)) & APBH_CTRL0_CLR_APB_BURST_EN_MASK)
#define APBH_CTRL0_CLR_AHB_BURST8_EN_MASK  (0x20000000U)
#define APBH_CTRL0_CLR_AHB_BURST8_EN_SHIFT (29U)
#define APBH_CTRL0_CLR_AHB_BURST8_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_CLR_AHB_BURST8_EN_SHIFT)) & APBH_CTRL0_CLR_AHB_BURST8_EN_MASK)
#define APBH_CTRL0_CLR_CLKGATE_MASK  (0x40000000U)
#define APBH_CTRL0_CLR_CLKGATE_SHIFT (30U)
#define APBH_CTRL0_CLR_CLKGATE(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_CLR_CLKGATE_SHIFT)) & APBH_CTRL0_CLR_CLKGATE_MASK)
#define APBH_CTRL0_CLR_SFTRST_MASK  (0x80000000U)
#define APBH_CTRL0_CLR_SFTRST_SHIFT (31U)
#define APBH_CTRL0_CLR_SFTRST(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_CLR_SFTRST_SHIFT)) & APBH_CTRL0_CLR_SFTRST_MASK)
/*! @} */

/*! @name CTRL0_TOG - AHB to APBH Bridge Control and Status Register 0 */
/*! @{ */
#define APBH_CTRL0_TOG_CLKGATE_CHANNEL_MASK  (0xFFFFU)
#define APBH_CTRL0_TOG_CLKGATE_CHANNEL_SHIFT (0U)
/*! CLKGATE_CHANNEL
 *  0b0000000000000001..NAND0
 *  0b0000000000000010..NAND1
 *  0b0000000000000100..NAND2
 *  0b0000000000001000..NAND3
 *  0b0000000000010000..NAND4
 *  0b0000000000100000..NAND5
 *  0b0000000001000000..NAND6
 *  0b0000000010000000..NAND7
 *  0b0000000100000000..SSP
 */
#define APBH_CTRL0_TOG_CLKGATE_CHANNEL(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_TOG_CLKGATE_CHANNEL_SHIFT)) & APBH_CTRL0_TOG_CLKGATE_CHANNEL_MASK)
#define APBH_CTRL0_TOG_RSVD0_MASK  (0xFFF0000U)
#define APBH_CTRL0_TOG_RSVD0_SHIFT (16U)
#define APBH_CTRL0_TOG_RSVD0(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_TOG_RSVD0_SHIFT)) & APBH_CTRL0_TOG_RSVD0_MASK)
#define APBH_CTRL0_TOG_APB_BURST_EN_MASK  (0x10000000U)
#define APBH_CTRL0_TOG_APB_BURST_EN_SHIFT (28U)
#define APBH_CTRL0_TOG_APB_BURST_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_TOG_APB_BURST_EN_SHIFT)) & APBH_CTRL0_TOG_APB_BURST_EN_MASK)
#define APBH_CTRL0_TOG_AHB_BURST8_EN_MASK  (0x20000000U)
#define APBH_CTRL0_TOG_AHB_BURST8_EN_SHIFT (29U)
#define APBH_CTRL0_TOG_AHB_BURST8_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_TOG_AHB_BURST8_EN_SHIFT)) & APBH_CTRL0_TOG_AHB_BURST8_EN_MASK)
#define APBH_CTRL0_TOG_CLKGATE_MASK  (0x40000000U)
#define APBH_CTRL0_TOG_CLKGATE_SHIFT (30U)
#define APBH_CTRL0_TOG_CLKGATE(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_TOG_CLKGATE_SHIFT)) & APBH_CTRL0_TOG_CLKGATE_MASK)
#define APBH_CTRL0_TOG_SFTRST_MASK  (0x80000000U)
#define APBH_CTRL0_TOG_SFTRST_SHIFT (31U)
#define APBH_CTRL0_TOG_SFTRST(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL0_TOG_SFTRST_SHIFT)) & APBH_CTRL0_TOG_SFTRST_MASK)
/*! @} */

/*! @name CTRL1 - AHB to APBH Bridge Control and Status Register 1 */
/*! @{ */
#define APBH_CTRL1_CH0_CMDCMPLT_IRQ_MASK  (0x1U)
#define APBH_CTRL1_CH0_CMDCMPLT_IRQ_SHIFT (0U)
#define APBH_CTRL1_CH0_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH0_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CH0_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CH1_CMDCMPLT_IRQ_MASK  (0x2U)
#define APBH_CTRL1_CH1_CMDCMPLT_IRQ_SHIFT (1U)
#define APBH_CTRL1_CH1_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH1_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CH1_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CH2_CMDCMPLT_IRQ_MASK  (0x4U)
#define APBH_CTRL1_CH2_CMDCMPLT_IRQ_SHIFT (2U)
#define APBH_CTRL1_CH2_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH2_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CH2_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CH3_CMDCMPLT_IRQ_MASK  (0x8U)
#define APBH_CTRL1_CH3_CMDCMPLT_IRQ_SHIFT (3U)
#define APBH_CTRL1_CH3_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH3_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CH3_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CH4_CMDCMPLT_IRQ_MASK  (0x10U)
#define APBH_CTRL1_CH4_CMDCMPLT_IRQ_SHIFT (4U)
#define APBH_CTRL1_CH4_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH4_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CH4_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CH5_CMDCMPLT_IRQ_MASK  (0x20U)
#define APBH_CTRL1_CH5_CMDCMPLT_IRQ_SHIFT (5U)
#define APBH_CTRL1_CH5_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH5_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CH5_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CH6_CMDCMPLT_IRQ_MASK  (0x40U)
#define APBH_CTRL1_CH6_CMDCMPLT_IRQ_SHIFT (6U)
#define APBH_CTRL1_CH6_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH6_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CH6_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CH7_CMDCMPLT_IRQ_MASK  (0x80U)
#define APBH_CTRL1_CH7_CMDCMPLT_IRQ_SHIFT (7U)
#define APBH_CTRL1_CH7_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH7_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CH7_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CH8_CMDCMPLT_IRQ_MASK  (0x100U)
#define APBH_CTRL1_CH8_CMDCMPLT_IRQ_SHIFT (8U)
#define APBH_CTRL1_CH8_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH8_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CH8_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CH9_CMDCMPLT_IRQ_MASK  (0x200U)
#define APBH_CTRL1_CH9_CMDCMPLT_IRQ_SHIFT (9U)
#define APBH_CTRL1_CH9_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH9_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CH9_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CH10_CMDCMPLT_IRQ_MASK  (0x400U)
#define APBH_CTRL1_CH10_CMDCMPLT_IRQ_SHIFT (10U)
#define APBH_CTRL1_CH10_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH10_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CH10_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CH11_CMDCMPLT_IRQ_MASK  (0x800U)
#define APBH_CTRL1_CH11_CMDCMPLT_IRQ_SHIFT (11U)
#define APBH_CTRL1_CH11_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH11_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CH11_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CH12_CMDCMPLT_IRQ_MASK  (0x1000U)
#define APBH_CTRL1_CH12_CMDCMPLT_IRQ_SHIFT (12U)
#define APBH_CTRL1_CH12_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH12_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CH12_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CH13_CMDCMPLT_IRQ_MASK  (0x2000U)
#define APBH_CTRL1_CH13_CMDCMPLT_IRQ_SHIFT (13U)
#define APBH_CTRL1_CH13_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH13_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CH13_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CH14_CMDCMPLT_IRQ_MASK  (0x4000U)
#define APBH_CTRL1_CH14_CMDCMPLT_IRQ_SHIFT (14U)
#define APBH_CTRL1_CH14_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH14_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CH14_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CH15_CMDCMPLT_IRQ_MASK  (0x8000U)
#define APBH_CTRL1_CH15_CMDCMPLT_IRQ_SHIFT (15U)
#define APBH_CTRL1_CH15_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH15_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CH15_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CH0_CMDCMPLT_IRQ_EN_MASK  (0x10000U)
#define APBH_CTRL1_CH0_CMDCMPLT_IRQ_EN_SHIFT (16U)
#define APBH_CTRL1_CH0_CMDCMPLT_IRQ_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH0_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CH0_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CH1_CMDCMPLT_IRQ_EN_MASK  (0x20000U)
#define APBH_CTRL1_CH1_CMDCMPLT_IRQ_EN_SHIFT (17U)
#define APBH_CTRL1_CH1_CMDCMPLT_IRQ_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH1_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CH1_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CH2_CMDCMPLT_IRQ_EN_MASK  (0x40000U)
#define APBH_CTRL1_CH2_CMDCMPLT_IRQ_EN_SHIFT (18U)
#define APBH_CTRL1_CH2_CMDCMPLT_IRQ_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH2_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CH2_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CH3_CMDCMPLT_IRQ_EN_MASK  (0x80000U)
#define APBH_CTRL1_CH3_CMDCMPLT_IRQ_EN_SHIFT (19U)
#define APBH_CTRL1_CH3_CMDCMPLT_IRQ_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH3_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CH3_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CH4_CMDCMPLT_IRQ_EN_MASK  (0x100000U)
#define APBH_CTRL1_CH4_CMDCMPLT_IRQ_EN_SHIFT (20U)
#define APBH_CTRL1_CH4_CMDCMPLT_IRQ_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH4_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CH4_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CH5_CMDCMPLT_IRQ_EN_MASK  (0x200000U)
#define APBH_CTRL1_CH5_CMDCMPLT_IRQ_EN_SHIFT (21U)
#define APBH_CTRL1_CH5_CMDCMPLT_IRQ_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH5_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CH5_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CH6_CMDCMPLT_IRQ_EN_MASK  (0x400000U)
#define APBH_CTRL1_CH6_CMDCMPLT_IRQ_EN_SHIFT (22U)
#define APBH_CTRL1_CH6_CMDCMPLT_IRQ_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH6_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CH6_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CH7_CMDCMPLT_IRQ_EN_MASK  (0x800000U)
#define APBH_CTRL1_CH7_CMDCMPLT_IRQ_EN_SHIFT (23U)
#define APBH_CTRL1_CH7_CMDCMPLT_IRQ_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH7_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CH7_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CH8_CMDCMPLT_IRQ_EN_MASK  (0x1000000U)
#define APBH_CTRL1_CH8_CMDCMPLT_IRQ_EN_SHIFT (24U)
#define APBH_CTRL1_CH8_CMDCMPLT_IRQ_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH8_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CH8_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CH9_CMDCMPLT_IRQ_EN_MASK  (0x2000000U)
#define APBH_CTRL1_CH9_CMDCMPLT_IRQ_EN_SHIFT (25U)
#define APBH_CTRL1_CH9_CMDCMPLT_IRQ_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH9_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CH9_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CH10_CMDCMPLT_IRQ_EN_MASK  (0x4000000U)
#define APBH_CTRL1_CH10_CMDCMPLT_IRQ_EN_SHIFT (26U)
#define APBH_CTRL1_CH10_CMDCMPLT_IRQ_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH10_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CH10_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CH11_CMDCMPLT_IRQ_EN_MASK  (0x8000000U)
#define APBH_CTRL1_CH11_CMDCMPLT_IRQ_EN_SHIFT (27U)
#define APBH_CTRL1_CH11_CMDCMPLT_IRQ_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH11_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CH11_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CH12_CMDCMPLT_IRQ_EN_MASK  (0x10000000U)
#define APBH_CTRL1_CH12_CMDCMPLT_IRQ_EN_SHIFT (28U)
#define APBH_CTRL1_CH12_CMDCMPLT_IRQ_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH12_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CH12_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CH13_CMDCMPLT_IRQ_EN_MASK  (0x20000000U)
#define APBH_CTRL1_CH13_CMDCMPLT_IRQ_EN_SHIFT (29U)
#define APBH_CTRL1_CH13_CMDCMPLT_IRQ_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH13_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CH13_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CH14_CMDCMPLT_IRQ_EN_MASK  (0x40000000U)
#define APBH_CTRL1_CH14_CMDCMPLT_IRQ_EN_SHIFT (30U)
#define APBH_CTRL1_CH14_CMDCMPLT_IRQ_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH14_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CH14_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CH15_CMDCMPLT_IRQ_EN_MASK  (0x80000000U)
#define APBH_CTRL1_CH15_CMDCMPLT_IRQ_EN_SHIFT (31U)
#define APBH_CTRL1_CH15_CMDCMPLT_IRQ_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CH15_CMDCMPLT_IRQ_EN_SHIFT)) & APBH_CTRL1_CH15_CMDCMPLT_IRQ_EN_MASK)
/*! @} */

/*! @name CTRL1_SET - AHB to APBH Bridge Control and Status Register 1 */
/*! @{ */
#define APBH_CTRL1_SET_CH0_CMDCMPLT_IRQ_MASK  (0x1U)
#define APBH_CTRL1_SET_CH0_CMDCMPLT_IRQ_SHIFT (0U)
#define APBH_CTRL1_SET_CH0_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH0_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_SET_CH0_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_SET_CH1_CMDCMPLT_IRQ_MASK  (0x2U)
#define APBH_CTRL1_SET_CH1_CMDCMPLT_IRQ_SHIFT (1U)
#define APBH_CTRL1_SET_CH1_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH1_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_SET_CH1_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_SET_CH2_CMDCMPLT_IRQ_MASK  (0x4U)
#define APBH_CTRL1_SET_CH2_CMDCMPLT_IRQ_SHIFT (2U)
#define APBH_CTRL1_SET_CH2_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH2_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_SET_CH2_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_SET_CH3_CMDCMPLT_IRQ_MASK  (0x8U)
#define APBH_CTRL1_SET_CH3_CMDCMPLT_IRQ_SHIFT (3U)
#define APBH_CTRL1_SET_CH3_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH3_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_SET_CH3_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_SET_CH4_CMDCMPLT_IRQ_MASK  (0x10U)
#define APBH_CTRL1_SET_CH4_CMDCMPLT_IRQ_SHIFT (4U)
#define APBH_CTRL1_SET_CH4_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH4_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_SET_CH4_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_SET_CH5_CMDCMPLT_IRQ_MASK  (0x20U)
#define APBH_CTRL1_SET_CH5_CMDCMPLT_IRQ_SHIFT (5U)
#define APBH_CTRL1_SET_CH5_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH5_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_SET_CH5_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_SET_CH6_CMDCMPLT_IRQ_MASK  (0x40U)
#define APBH_CTRL1_SET_CH6_CMDCMPLT_IRQ_SHIFT (6U)
#define APBH_CTRL1_SET_CH6_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH6_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_SET_CH6_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_SET_CH7_CMDCMPLT_IRQ_MASK  (0x80U)
#define APBH_CTRL1_SET_CH7_CMDCMPLT_IRQ_SHIFT (7U)
#define APBH_CTRL1_SET_CH7_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH7_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_SET_CH7_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_SET_CH8_CMDCMPLT_IRQ_MASK  (0x100U)
#define APBH_CTRL1_SET_CH8_CMDCMPLT_IRQ_SHIFT (8U)
#define APBH_CTRL1_SET_CH8_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH8_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_SET_CH8_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_SET_CH9_CMDCMPLT_IRQ_MASK  (0x200U)
#define APBH_CTRL1_SET_CH9_CMDCMPLT_IRQ_SHIFT (9U)
#define APBH_CTRL1_SET_CH9_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH9_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_SET_CH9_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_SET_CH10_CMDCMPLT_IRQ_MASK  (0x400U)
#define APBH_CTRL1_SET_CH10_CMDCMPLT_IRQ_SHIFT (10U)
#define APBH_CTRL1_SET_CH10_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH10_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_SET_CH10_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_SET_CH11_CMDCMPLT_IRQ_MASK  (0x800U)
#define APBH_CTRL1_SET_CH11_CMDCMPLT_IRQ_SHIFT (11U)
#define APBH_CTRL1_SET_CH11_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH11_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_SET_CH11_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_SET_CH12_CMDCMPLT_IRQ_MASK  (0x1000U)
#define APBH_CTRL1_SET_CH12_CMDCMPLT_IRQ_SHIFT (12U)
#define APBH_CTRL1_SET_CH12_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH12_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_SET_CH12_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_SET_CH13_CMDCMPLT_IRQ_MASK  (0x2000U)
#define APBH_CTRL1_SET_CH13_CMDCMPLT_IRQ_SHIFT (13U)
#define APBH_CTRL1_SET_CH13_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH13_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_SET_CH13_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_SET_CH14_CMDCMPLT_IRQ_MASK  (0x4000U)
#define APBH_CTRL1_SET_CH14_CMDCMPLT_IRQ_SHIFT (14U)
#define APBH_CTRL1_SET_CH14_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH14_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_SET_CH14_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_SET_CH15_CMDCMPLT_IRQ_MASK  (0x8000U)
#define APBH_CTRL1_SET_CH15_CMDCMPLT_IRQ_SHIFT (15U)
#define APBH_CTRL1_SET_CH15_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH15_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_SET_CH15_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_SET_CH0_CMDCMPLT_IRQ_EN_MASK  (0x10000U)
#define APBH_CTRL1_SET_CH0_CMDCMPLT_IRQ_EN_SHIFT (16U)
#define APBH_CTRL1_SET_CH0_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH0_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_SET_CH0_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_SET_CH1_CMDCMPLT_IRQ_EN_MASK  (0x20000U)
#define APBH_CTRL1_SET_CH1_CMDCMPLT_IRQ_EN_SHIFT (17U)
#define APBH_CTRL1_SET_CH1_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH1_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_SET_CH1_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_SET_CH2_CMDCMPLT_IRQ_EN_MASK  (0x40000U)
#define APBH_CTRL1_SET_CH2_CMDCMPLT_IRQ_EN_SHIFT (18U)
#define APBH_CTRL1_SET_CH2_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH2_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_SET_CH2_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_SET_CH3_CMDCMPLT_IRQ_EN_MASK  (0x80000U)
#define APBH_CTRL1_SET_CH3_CMDCMPLT_IRQ_EN_SHIFT (19U)
#define APBH_CTRL1_SET_CH3_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH3_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_SET_CH3_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_SET_CH4_CMDCMPLT_IRQ_EN_MASK  (0x100000U)
#define APBH_CTRL1_SET_CH4_CMDCMPLT_IRQ_EN_SHIFT (20U)
#define APBH_CTRL1_SET_CH4_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH4_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_SET_CH4_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_SET_CH5_CMDCMPLT_IRQ_EN_MASK  (0x200000U)
#define APBH_CTRL1_SET_CH5_CMDCMPLT_IRQ_EN_SHIFT (21U)
#define APBH_CTRL1_SET_CH5_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH5_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_SET_CH5_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_SET_CH6_CMDCMPLT_IRQ_EN_MASK  (0x400000U)
#define APBH_CTRL1_SET_CH6_CMDCMPLT_IRQ_EN_SHIFT (22U)
#define APBH_CTRL1_SET_CH6_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH6_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_SET_CH6_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_SET_CH7_CMDCMPLT_IRQ_EN_MASK  (0x800000U)
#define APBH_CTRL1_SET_CH7_CMDCMPLT_IRQ_EN_SHIFT (23U)
#define APBH_CTRL1_SET_CH7_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH7_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_SET_CH7_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_SET_CH8_CMDCMPLT_IRQ_EN_MASK  (0x1000000U)
#define APBH_CTRL1_SET_CH8_CMDCMPLT_IRQ_EN_SHIFT (24U)
#define APBH_CTRL1_SET_CH8_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH8_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_SET_CH8_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_SET_CH9_CMDCMPLT_IRQ_EN_MASK  (0x2000000U)
#define APBH_CTRL1_SET_CH9_CMDCMPLT_IRQ_EN_SHIFT (25U)
#define APBH_CTRL1_SET_CH9_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH9_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_SET_CH9_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_SET_CH10_CMDCMPLT_IRQ_EN_MASK  (0x4000000U)
#define APBH_CTRL1_SET_CH10_CMDCMPLT_IRQ_EN_SHIFT (26U)
#define APBH_CTRL1_SET_CH10_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH10_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_SET_CH10_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_SET_CH11_CMDCMPLT_IRQ_EN_MASK  (0x8000000U)
#define APBH_CTRL1_SET_CH11_CMDCMPLT_IRQ_EN_SHIFT (27U)
#define APBH_CTRL1_SET_CH11_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH11_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_SET_CH11_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_SET_CH12_CMDCMPLT_IRQ_EN_MASK  (0x10000000U)
#define APBH_CTRL1_SET_CH12_CMDCMPLT_IRQ_EN_SHIFT (28U)
#define APBH_CTRL1_SET_CH12_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH12_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_SET_CH12_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_SET_CH13_CMDCMPLT_IRQ_EN_MASK  (0x20000000U)
#define APBH_CTRL1_SET_CH13_CMDCMPLT_IRQ_EN_SHIFT (29U)
#define APBH_CTRL1_SET_CH13_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH13_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_SET_CH13_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_SET_CH14_CMDCMPLT_IRQ_EN_MASK  (0x40000000U)
#define APBH_CTRL1_SET_CH14_CMDCMPLT_IRQ_EN_SHIFT (30U)
#define APBH_CTRL1_SET_CH14_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH14_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_SET_CH14_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_SET_CH15_CMDCMPLT_IRQ_EN_MASK  (0x80000000U)
#define APBH_CTRL1_SET_CH15_CMDCMPLT_IRQ_EN_SHIFT (31U)
#define APBH_CTRL1_SET_CH15_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_SET_CH15_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_SET_CH15_CMDCMPLT_IRQ_EN_MASK)
/*! @} */

/*! @name CTRL1_CLR - AHB to APBH Bridge Control and Status Register 1 */
/*! @{ */
#define APBH_CTRL1_CLR_CH0_CMDCMPLT_IRQ_MASK  (0x1U)
#define APBH_CTRL1_CLR_CH0_CMDCMPLT_IRQ_SHIFT (0U)
#define APBH_CTRL1_CLR_CH0_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH0_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CLR_CH0_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CLR_CH1_CMDCMPLT_IRQ_MASK  (0x2U)
#define APBH_CTRL1_CLR_CH1_CMDCMPLT_IRQ_SHIFT (1U)
#define APBH_CTRL1_CLR_CH1_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH1_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CLR_CH1_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CLR_CH2_CMDCMPLT_IRQ_MASK  (0x4U)
#define APBH_CTRL1_CLR_CH2_CMDCMPLT_IRQ_SHIFT (2U)
#define APBH_CTRL1_CLR_CH2_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH2_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CLR_CH2_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CLR_CH3_CMDCMPLT_IRQ_MASK  (0x8U)
#define APBH_CTRL1_CLR_CH3_CMDCMPLT_IRQ_SHIFT (3U)
#define APBH_CTRL1_CLR_CH3_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH3_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CLR_CH3_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CLR_CH4_CMDCMPLT_IRQ_MASK  (0x10U)
#define APBH_CTRL1_CLR_CH4_CMDCMPLT_IRQ_SHIFT (4U)
#define APBH_CTRL1_CLR_CH4_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH4_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CLR_CH4_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CLR_CH5_CMDCMPLT_IRQ_MASK  (0x20U)
#define APBH_CTRL1_CLR_CH5_CMDCMPLT_IRQ_SHIFT (5U)
#define APBH_CTRL1_CLR_CH5_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH5_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CLR_CH5_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CLR_CH6_CMDCMPLT_IRQ_MASK  (0x40U)
#define APBH_CTRL1_CLR_CH6_CMDCMPLT_IRQ_SHIFT (6U)
#define APBH_CTRL1_CLR_CH6_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH6_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CLR_CH6_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CLR_CH7_CMDCMPLT_IRQ_MASK  (0x80U)
#define APBH_CTRL1_CLR_CH7_CMDCMPLT_IRQ_SHIFT (7U)
#define APBH_CTRL1_CLR_CH7_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH7_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CLR_CH7_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CLR_CH8_CMDCMPLT_IRQ_MASK  (0x100U)
#define APBH_CTRL1_CLR_CH8_CMDCMPLT_IRQ_SHIFT (8U)
#define APBH_CTRL1_CLR_CH8_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH8_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CLR_CH8_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CLR_CH9_CMDCMPLT_IRQ_MASK  (0x200U)
#define APBH_CTRL1_CLR_CH9_CMDCMPLT_IRQ_SHIFT (9U)
#define APBH_CTRL1_CLR_CH9_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH9_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CLR_CH9_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CLR_CH10_CMDCMPLT_IRQ_MASK  (0x400U)
#define APBH_CTRL1_CLR_CH10_CMDCMPLT_IRQ_SHIFT (10U)
#define APBH_CTRL1_CLR_CH10_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH10_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CLR_CH10_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CLR_CH11_CMDCMPLT_IRQ_MASK  (0x800U)
#define APBH_CTRL1_CLR_CH11_CMDCMPLT_IRQ_SHIFT (11U)
#define APBH_CTRL1_CLR_CH11_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH11_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CLR_CH11_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CLR_CH12_CMDCMPLT_IRQ_MASK  (0x1000U)
#define APBH_CTRL1_CLR_CH12_CMDCMPLT_IRQ_SHIFT (12U)
#define APBH_CTRL1_CLR_CH12_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH12_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CLR_CH12_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CLR_CH13_CMDCMPLT_IRQ_MASK  (0x2000U)
#define APBH_CTRL1_CLR_CH13_CMDCMPLT_IRQ_SHIFT (13U)
#define APBH_CTRL1_CLR_CH13_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH13_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CLR_CH13_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CLR_CH14_CMDCMPLT_IRQ_MASK  (0x4000U)
#define APBH_CTRL1_CLR_CH14_CMDCMPLT_IRQ_SHIFT (14U)
#define APBH_CTRL1_CLR_CH14_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH14_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CLR_CH14_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CLR_CH15_CMDCMPLT_IRQ_MASK  (0x8000U)
#define APBH_CTRL1_CLR_CH15_CMDCMPLT_IRQ_SHIFT (15U)
#define APBH_CTRL1_CLR_CH15_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH15_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_CLR_CH15_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_CLR_CH0_CMDCMPLT_IRQ_EN_MASK  (0x10000U)
#define APBH_CTRL1_CLR_CH0_CMDCMPLT_IRQ_EN_SHIFT (16U)
#define APBH_CTRL1_CLR_CH0_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH0_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_CLR_CH0_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CLR_CH1_CMDCMPLT_IRQ_EN_MASK  (0x20000U)
#define APBH_CTRL1_CLR_CH1_CMDCMPLT_IRQ_EN_SHIFT (17U)
#define APBH_CTRL1_CLR_CH1_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH1_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_CLR_CH1_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CLR_CH2_CMDCMPLT_IRQ_EN_MASK  (0x40000U)
#define APBH_CTRL1_CLR_CH2_CMDCMPLT_IRQ_EN_SHIFT (18U)
#define APBH_CTRL1_CLR_CH2_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH2_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_CLR_CH2_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CLR_CH3_CMDCMPLT_IRQ_EN_MASK  (0x80000U)
#define APBH_CTRL1_CLR_CH3_CMDCMPLT_IRQ_EN_SHIFT (19U)
#define APBH_CTRL1_CLR_CH3_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH3_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_CLR_CH3_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CLR_CH4_CMDCMPLT_IRQ_EN_MASK  (0x100000U)
#define APBH_CTRL1_CLR_CH4_CMDCMPLT_IRQ_EN_SHIFT (20U)
#define APBH_CTRL1_CLR_CH4_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH4_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_CLR_CH4_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CLR_CH5_CMDCMPLT_IRQ_EN_MASK  (0x200000U)
#define APBH_CTRL1_CLR_CH5_CMDCMPLT_IRQ_EN_SHIFT (21U)
#define APBH_CTRL1_CLR_CH5_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH5_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_CLR_CH5_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CLR_CH6_CMDCMPLT_IRQ_EN_MASK  (0x400000U)
#define APBH_CTRL1_CLR_CH6_CMDCMPLT_IRQ_EN_SHIFT (22U)
#define APBH_CTRL1_CLR_CH6_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH6_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_CLR_CH6_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CLR_CH7_CMDCMPLT_IRQ_EN_MASK  (0x800000U)
#define APBH_CTRL1_CLR_CH7_CMDCMPLT_IRQ_EN_SHIFT (23U)
#define APBH_CTRL1_CLR_CH7_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH7_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_CLR_CH7_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CLR_CH8_CMDCMPLT_IRQ_EN_MASK  (0x1000000U)
#define APBH_CTRL1_CLR_CH8_CMDCMPLT_IRQ_EN_SHIFT (24U)
#define APBH_CTRL1_CLR_CH8_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH8_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_CLR_CH8_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CLR_CH9_CMDCMPLT_IRQ_EN_MASK  (0x2000000U)
#define APBH_CTRL1_CLR_CH9_CMDCMPLT_IRQ_EN_SHIFT (25U)
#define APBH_CTRL1_CLR_CH9_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH9_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_CLR_CH9_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CLR_CH10_CMDCMPLT_IRQ_EN_MASK  (0x4000000U)
#define APBH_CTRL1_CLR_CH10_CMDCMPLT_IRQ_EN_SHIFT (26U)
#define APBH_CTRL1_CLR_CH10_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH10_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_CLR_CH10_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CLR_CH11_CMDCMPLT_IRQ_EN_MASK  (0x8000000U)
#define APBH_CTRL1_CLR_CH11_CMDCMPLT_IRQ_EN_SHIFT (27U)
#define APBH_CTRL1_CLR_CH11_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH11_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_CLR_CH11_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CLR_CH12_CMDCMPLT_IRQ_EN_MASK  (0x10000000U)
#define APBH_CTRL1_CLR_CH12_CMDCMPLT_IRQ_EN_SHIFT (28U)
#define APBH_CTRL1_CLR_CH12_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH12_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_CLR_CH12_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CLR_CH13_CMDCMPLT_IRQ_EN_MASK  (0x20000000U)
#define APBH_CTRL1_CLR_CH13_CMDCMPLT_IRQ_EN_SHIFT (29U)
#define APBH_CTRL1_CLR_CH13_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH13_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_CLR_CH13_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CLR_CH14_CMDCMPLT_IRQ_EN_MASK  (0x40000000U)
#define APBH_CTRL1_CLR_CH14_CMDCMPLT_IRQ_EN_SHIFT (30U)
#define APBH_CTRL1_CLR_CH14_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH14_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_CLR_CH14_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_CLR_CH15_CMDCMPLT_IRQ_EN_MASK  (0x80000000U)
#define APBH_CTRL1_CLR_CH15_CMDCMPLT_IRQ_EN_SHIFT (31U)
#define APBH_CTRL1_CLR_CH15_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_CLR_CH15_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_CLR_CH15_CMDCMPLT_IRQ_EN_MASK)
/*! @} */

/*! @name CTRL1_TOG - AHB to APBH Bridge Control and Status Register 1 */
/*! @{ */
#define APBH_CTRL1_TOG_CH0_CMDCMPLT_IRQ_MASK  (0x1U)
#define APBH_CTRL1_TOG_CH0_CMDCMPLT_IRQ_SHIFT (0U)
#define APBH_CTRL1_TOG_CH0_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH0_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_TOG_CH0_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_TOG_CH1_CMDCMPLT_IRQ_MASK  (0x2U)
#define APBH_CTRL1_TOG_CH1_CMDCMPLT_IRQ_SHIFT (1U)
#define APBH_CTRL1_TOG_CH1_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH1_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_TOG_CH1_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_TOG_CH2_CMDCMPLT_IRQ_MASK  (0x4U)
#define APBH_CTRL1_TOG_CH2_CMDCMPLT_IRQ_SHIFT (2U)
#define APBH_CTRL1_TOG_CH2_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH2_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_TOG_CH2_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_TOG_CH3_CMDCMPLT_IRQ_MASK  (0x8U)
#define APBH_CTRL1_TOG_CH3_CMDCMPLT_IRQ_SHIFT (3U)
#define APBH_CTRL1_TOG_CH3_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH3_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_TOG_CH3_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_TOG_CH4_CMDCMPLT_IRQ_MASK  (0x10U)
#define APBH_CTRL1_TOG_CH4_CMDCMPLT_IRQ_SHIFT (4U)
#define APBH_CTRL1_TOG_CH4_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH4_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_TOG_CH4_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_TOG_CH5_CMDCMPLT_IRQ_MASK  (0x20U)
#define APBH_CTRL1_TOG_CH5_CMDCMPLT_IRQ_SHIFT (5U)
#define APBH_CTRL1_TOG_CH5_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH5_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_TOG_CH5_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_TOG_CH6_CMDCMPLT_IRQ_MASK  (0x40U)
#define APBH_CTRL1_TOG_CH6_CMDCMPLT_IRQ_SHIFT (6U)
#define APBH_CTRL1_TOG_CH6_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH6_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_TOG_CH6_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_TOG_CH7_CMDCMPLT_IRQ_MASK  (0x80U)
#define APBH_CTRL1_TOG_CH7_CMDCMPLT_IRQ_SHIFT (7U)
#define APBH_CTRL1_TOG_CH7_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH7_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_TOG_CH7_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_TOG_CH8_CMDCMPLT_IRQ_MASK  (0x100U)
#define APBH_CTRL1_TOG_CH8_CMDCMPLT_IRQ_SHIFT (8U)
#define APBH_CTRL1_TOG_CH8_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH8_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_TOG_CH8_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_TOG_CH9_CMDCMPLT_IRQ_MASK  (0x200U)
#define APBH_CTRL1_TOG_CH9_CMDCMPLT_IRQ_SHIFT (9U)
#define APBH_CTRL1_TOG_CH9_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH9_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_TOG_CH9_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_TOG_CH10_CMDCMPLT_IRQ_MASK  (0x400U)
#define APBH_CTRL1_TOG_CH10_CMDCMPLT_IRQ_SHIFT (10U)
#define APBH_CTRL1_TOG_CH10_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH10_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_TOG_CH10_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_TOG_CH11_CMDCMPLT_IRQ_MASK  (0x800U)
#define APBH_CTRL1_TOG_CH11_CMDCMPLT_IRQ_SHIFT (11U)
#define APBH_CTRL1_TOG_CH11_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH11_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_TOG_CH11_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_TOG_CH12_CMDCMPLT_IRQ_MASK  (0x1000U)
#define APBH_CTRL1_TOG_CH12_CMDCMPLT_IRQ_SHIFT (12U)
#define APBH_CTRL1_TOG_CH12_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH12_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_TOG_CH12_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_TOG_CH13_CMDCMPLT_IRQ_MASK  (0x2000U)
#define APBH_CTRL1_TOG_CH13_CMDCMPLT_IRQ_SHIFT (13U)
#define APBH_CTRL1_TOG_CH13_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH13_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_TOG_CH13_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_TOG_CH14_CMDCMPLT_IRQ_MASK  (0x4000U)
#define APBH_CTRL1_TOG_CH14_CMDCMPLT_IRQ_SHIFT (14U)
#define APBH_CTRL1_TOG_CH14_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH14_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_TOG_CH14_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_TOG_CH15_CMDCMPLT_IRQ_MASK  (0x8000U)
#define APBH_CTRL1_TOG_CH15_CMDCMPLT_IRQ_SHIFT (15U)
#define APBH_CTRL1_TOG_CH15_CMDCMPLT_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH15_CMDCMPLT_IRQ_SHIFT)) & APBH_CTRL1_TOG_CH15_CMDCMPLT_IRQ_MASK)
#define APBH_CTRL1_TOG_CH0_CMDCMPLT_IRQ_EN_MASK  (0x10000U)
#define APBH_CTRL1_TOG_CH0_CMDCMPLT_IRQ_EN_SHIFT (16U)
#define APBH_CTRL1_TOG_CH0_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH0_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_TOG_CH0_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_TOG_CH1_CMDCMPLT_IRQ_EN_MASK  (0x20000U)
#define APBH_CTRL1_TOG_CH1_CMDCMPLT_IRQ_EN_SHIFT (17U)
#define APBH_CTRL1_TOG_CH1_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH1_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_TOG_CH1_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_TOG_CH2_CMDCMPLT_IRQ_EN_MASK  (0x40000U)
#define APBH_CTRL1_TOG_CH2_CMDCMPLT_IRQ_EN_SHIFT (18U)
#define APBH_CTRL1_TOG_CH2_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH2_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_TOG_CH2_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_TOG_CH3_CMDCMPLT_IRQ_EN_MASK  (0x80000U)
#define APBH_CTRL1_TOG_CH3_CMDCMPLT_IRQ_EN_SHIFT (19U)
#define APBH_CTRL1_TOG_CH3_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH3_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_TOG_CH3_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_TOG_CH4_CMDCMPLT_IRQ_EN_MASK  (0x100000U)
#define APBH_CTRL1_TOG_CH4_CMDCMPLT_IRQ_EN_SHIFT (20U)
#define APBH_CTRL1_TOG_CH4_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH4_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_TOG_CH4_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_TOG_CH5_CMDCMPLT_IRQ_EN_MASK  (0x200000U)
#define APBH_CTRL1_TOG_CH5_CMDCMPLT_IRQ_EN_SHIFT (21U)
#define APBH_CTRL1_TOG_CH5_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH5_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_TOG_CH5_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_TOG_CH6_CMDCMPLT_IRQ_EN_MASK  (0x400000U)
#define APBH_CTRL1_TOG_CH6_CMDCMPLT_IRQ_EN_SHIFT (22U)
#define APBH_CTRL1_TOG_CH6_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH6_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_TOG_CH6_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_TOG_CH7_CMDCMPLT_IRQ_EN_MASK  (0x800000U)
#define APBH_CTRL1_TOG_CH7_CMDCMPLT_IRQ_EN_SHIFT (23U)
#define APBH_CTRL1_TOG_CH7_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH7_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_TOG_CH7_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_TOG_CH8_CMDCMPLT_IRQ_EN_MASK  (0x1000000U)
#define APBH_CTRL1_TOG_CH8_CMDCMPLT_IRQ_EN_SHIFT (24U)
#define APBH_CTRL1_TOG_CH8_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH8_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_TOG_CH8_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_TOG_CH9_CMDCMPLT_IRQ_EN_MASK  (0x2000000U)
#define APBH_CTRL1_TOG_CH9_CMDCMPLT_IRQ_EN_SHIFT (25U)
#define APBH_CTRL1_TOG_CH9_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH9_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_TOG_CH9_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_TOG_CH10_CMDCMPLT_IRQ_EN_MASK  (0x4000000U)
#define APBH_CTRL1_TOG_CH10_CMDCMPLT_IRQ_EN_SHIFT (26U)
#define APBH_CTRL1_TOG_CH10_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH10_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_TOG_CH10_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_TOG_CH11_CMDCMPLT_IRQ_EN_MASK  (0x8000000U)
#define APBH_CTRL1_TOG_CH11_CMDCMPLT_IRQ_EN_SHIFT (27U)
#define APBH_CTRL1_TOG_CH11_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH11_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_TOG_CH11_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_TOG_CH12_CMDCMPLT_IRQ_EN_MASK  (0x10000000U)
#define APBH_CTRL1_TOG_CH12_CMDCMPLT_IRQ_EN_SHIFT (28U)
#define APBH_CTRL1_TOG_CH12_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH12_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_TOG_CH12_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_TOG_CH13_CMDCMPLT_IRQ_EN_MASK  (0x20000000U)
#define APBH_CTRL1_TOG_CH13_CMDCMPLT_IRQ_EN_SHIFT (29U)
#define APBH_CTRL1_TOG_CH13_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH13_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_TOG_CH13_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_TOG_CH14_CMDCMPLT_IRQ_EN_MASK  (0x40000000U)
#define APBH_CTRL1_TOG_CH14_CMDCMPLT_IRQ_EN_SHIFT (30U)
#define APBH_CTRL1_TOG_CH14_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH14_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_TOG_CH14_CMDCMPLT_IRQ_EN_MASK)
#define APBH_CTRL1_TOG_CH15_CMDCMPLT_IRQ_EN_MASK  (0x80000000U)
#define APBH_CTRL1_TOG_CH15_CMDCMPLT_IRQ_EN_SHIFT (31U)
#define APBH_CTRL1_TOG_CH15_CMDCMPLT_IRQ_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL1_TOG_CH15_CMDCMPLT_IRQ_EN_SHIFT)) & \
     APBH_CTRL1_TOG_CH15_CMDCMPLT_IRQ_EN_MASK)
/*! @} */

/*! @name CTRL2 - AHB to APBH Bridge Control and Status Register 2 */
/*! @{ */
#define APBH_CTRL2_CH0_ERROR_IRQ_MASK  (0x1U)
#define APBH_CTRL2_CH0_ERROR_IRQ_SHIFT (0U)
#define APBH_CTRL2_CH0_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH0_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CH0_ERROR_IRQ_MASK)
#define APBH_CTRL2_CH1_ERROR_IRQ_MASK  (0x2U)
#define APBH_CTRL2_CH1_ERROR_IRQ_SHIFT (1U)
#define APBH_CTRL2_CH1_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH1_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CH1_ERROR_IRQ_MASK)
#define APBH_CTRL2_CH2_ERROR_IRQ_MASK  (0x4U)
#define APBH_CTRL2_CH2_ERROR_IRQ_SHIFT (2U)
#define APBH_CTRL2_CH2_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH2_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CH2_ERROR_IRQ_MASK)
#define APBH_CTRL2_CH3_ERROR_IRQ_MASK  (0x8U)
#define APBH_CTRL2_CH3_ERROR_IRQ_SHIFT (3U)
#define APBH_CTRL2_CH3_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH3_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CH3_ERROR_IRQ_MASK)
#define APBH_CTRL2_CH4_ERROR_IRQ_MASK  (0x10U)
#define APBH_CTRL2_CH4_ERROR_IRQ_SHIFT (4U)
#define APBH_CTRL2_CH4_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH4_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CH4_ERROR_IRQ_MASK)
#define APBH_CTRL2_CH5_ERROR_IRQ_MASK  (0x20U)
#define APBH_CTRL2_CH5_ERROR_IRQ_SHIFT (5U)
#define APBH_CTRL2_CH5_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH5_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CH5_ERROR_IRQ_MASK)
#define APBH_CTRL2_CH6_ERROR_IRQ_MASK  (0x40U)
#define APBH_CTRL2_CH6_ERROR_IRQ_SHIFT (6U)
#define APBH_CTRL2_CH6_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH6_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CH6_ERROR_IRQ_MASK)
#define APBH_CTRL2_CH7_ERROR_IRQ_MASK  (0x80U)
#define APBH_CTRL2_CH7_ERROR_IRQ_SHIFT (7U)
#define APBH_CTRL2_CH7_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH7_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CH7_ERROR_IRQ_MASK)
#define APBH_CTRL2_CH8_ERROR_IRQ_MASK  (0x100U)
#define APBH_CTRL2_CH8_ERROR_IRQ_SHIFT (8U)
#define APBH_CTRL2_CH8_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH8_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CH8_ERROR_IRQ_MASK)
#define APBH_CTRL2_CH9_ERROR_IRQ_MASK  (0x200U)
#define APBH_CTRL2_CH9_ERROR_IRQ_SHIFT (9U)
#define APBH_CTRL2_CH9_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH9_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CH9_ERROR_IRQ_MASK)
#define APBH_CTRL2_CH10_ERROR_IRQ_MASK  (0x400U)
#define APBH_CTRL2_CH10_ERROR_IRQ_SHIFT (10U)
#define APBH_CTRL2_CH10_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH10_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CH10_ERROR_IRQ_MASK)
#define APBH_CTRL2_CH11_ERROR_IRQ_MASK  (0x800U)
#define APBH_CTRL2_CH11_ERROR_IRQ_SHIFT (11U)
#define APBH_CTRL2_CH11_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH11_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CH11_ERROR_IRQ_MASK)
#define APBH_CTRL2_CH12_ERROR_IRQ_MASK  (0x1000U)
#define APBH_CTRL2_CH12_ERROR_IRQ_SHIFT (12U)
#define APBH_CTRL2_CH12_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH12_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CH12_ERROR_IRQ_MASK)
#define APBH_CTRL2_CH13_ERROR_IRQ_MASK  (0x2000U)
#define APBH_CTRL2_CH13_ERROR_IRQ_SHIFT (13U)
#define APBH_CTRL2_CH13_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH13_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CH13_ERROR_IRQ_MASK)
#define APBH_CTRL2_CH14_ERROR_IRQ_MASK  (0x4000U)
#define APBH_CTRL2_CH14_ERROR_IRQ_SHIFT (14U)
#define APBH_CTRL2_CH14_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH14_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CH14_ERROR_IRQ_MASK)
#define APBH_CTRL2_CH15_ERROR_IRQ_MASK  (0x8000U)
#define APBH_CTRL2_CH15_ERROR_IRQ_SHIFT (15U)
#define APBH_CTRL2_CH15_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH15_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CH15_ERROR_IRQ_MASK)
#define APBH_CTRL2_CH0_ERROR_STATUS_MASK  (0x10000U)
#define APBH_CTRL2_CH0_ERROR_STATUS_SHIFT (16U)
/*! CH0_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_CH0_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH0_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CH0_ERROR_STATUS_MASK)
#define APBH_CTRL2_CH1_ERROR_STATUS_MASK  (0x20000U)
#define APBH_CTRL2_CH1_ERROR_STATUS_SHIFT (17U)
/*! CH1_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_CH1_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH1_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CH1_ERROR_STATUS_MASK)
#define APBH_CTRL2_CH2_ERROR_STATUS_MASK  (0x40000U)
#define APBH_CTRL2_CH2_ERROR_STATUS_SHIFT (18U)
/*! CH2_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_CH2_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH2_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CH2_ERROR_STATUS_MASK)
#define APBH_CTRL2_CH3_ERROR_STATUS_MASK  (0x80000U)
#define APBH_CTRL2_CH3_ERROR_STATUS_SHIFT (19U)
/*! CH3_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_CH3_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH3_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CH3_ERROR_STATUS_MASK)
#define APBH_CTRL2_CH4_ERROR_STATUS_MASK  (0x100000U)
#define APBH_CTRL2_CH4_ERROR_STATUS_SHIFT (20U)
/*! CH4_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_CH4_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH4_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CH4_ERROR_STATUS_MASK)
#define APBH_CTRL2_CH5_ERROR_STATUS_MASK  (0x200000U)
#define APBH_CTRL2_CH5_ERROR_STATUS_SHIFT (21U)
/*! CH5_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_CH5_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH5_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CH5_ERROR_STATUS_MASK)
#define APBH_CTRL2_CH6_ERROR_STATUS_MASK  (0x400000U)
#define APBH_CTRL2_CH6_ERROR_STATUS_SHIFT (22U)
/*! CH6_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_CH6_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH6_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CH6_ERROR_STATUS_MASK)
#define APBH_CTRL2_CH7_ERROR_STATUS_MASK  (0x800000U)
#define APBH_CTRL2_CH7_ERROR_STATUS_SHIFT (23U)
/*! CH7_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_CH7_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH7_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CH7_ERROR_STATUS_MASK)
#define APBH_CTRL2_CH8_ERROR_STATUS_MASK  (0x1000000U)
#define APBH_CTRL2_CH8_ERROR_STATUS_SHIFT (24U)
/*! CH8_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_CH8_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH8_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CH8_ERROR_STATUS_MASK)
#define APBH_CTRL2_CH9_ERROR_STATUS_MASK  (0x2000000U)
#define APBH_CTRL2_CH9_ERROR_STATUS_SHIFT (25U)
/*! CH9_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_CH9_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH9_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CH9_ERROR_STATUS_MASK)
#define APBH_CTRL2_CH10_ERROR_STATUS_MASK  (0x4000000U)
#define APBH_CTRL2_CH10_ERROR_STATUS_SHIFT (26U)
/*! CH10_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_CH10_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH10_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CH10_ERROR_STATUS_MASK)
#define APBH_CTRL2_CH11_ERROR_STATUS_MASK  (0x8000000U)
#define APBH_CTRL2_CH11_ERROR_STATUS_SHIFT (27U)
/*! CH11_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_CH11_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH11_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CH11_ERROR_STATUS_MASK)
#define APBH_CTRL2_CH12_ERROR_STATUS_MASK  (0x10000000U)
#define APBH_CTRL2_CH12_ERROR_STATUS_SHIFT (28U)
/*! CH12_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_CH12_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH12_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CH12_ERROR_STATUS_MASK)
#define APBH_CTRL2_CH13_ERROR_STATUS_MASK  (0x20000000U)
#define APBH_CTRL2_CH13_ERROR_STATUS_SHIFT (29U)
/*! CH13_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_CH13_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH13_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CH13_ERROR_STATUS_MASK)
#define APBH_CTRL2_CH14_ERROR_STATUS_MASK  (0x40000000U)
#define APBH_CTRL2_CH14_ERROR_STATUS_SHIFT (30U)
/*! CH14_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_CH14_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH14_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CH14_ERROR_STATUS_MASK)
#define APBH_CTRL2_CH15_ERROR_STATUS_MASK  (0x80000000U)
#define APBH_CTRL2_CH15_ERROR_STATUS_SHIFT (31U)
/*! CH15_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_CH15_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CH15_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CH15_ERROR_STATUS_MASK)
/*! @} */

/*! @name CTRL2_SET - AHB to APBH Bridge Control and Status Register 2 */
/*! @{ */
#define APBH_CTRL2_SET_CH0_ERROR_IRQ_MASK  (0x1U)
#define APBH_CTRL2_SET_CH0_ERROR_IRQ_SHIFT (0U)
#define APBH_CTRL2_SET_CH0_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH0_ERROR_IRQ_SHIFT)) & APBH_CTRL2_SET_CH0_ERROR_IRQ_MASK)
#define APBH_CTRL2_SET_CH1_ERROR_IRQ_MASK  (0x2U)
#define APBH_CTRL2_SET_CH1_ERROR_IRQ_SHIFT (1U)
#define APBH_CTRL2_SET_CH1_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH1_ERROR_IRQ_SHIFT)) & APBH_CTRL2_SET_CH1_ERROR_IRQ_MASK)
#define APBH_CTRL2_SET_CH2_ERROR_IRQ_MASK  (0x4U)
#define APBH_CTRL2_SET_CH2_ERROR_IRQ_SHIFT (2U)
#define APBH_CTRL2_SET_CH2_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH2_ERROR_IRQ_SHIFT)) & APBH_CTRL2_SET_CH2_ERROR_IRQ_MASK)
#define APBH_CTRL2_SET_CH3_ERROR_IRQ_MASK  (0x8U)
#define APBH_CTRL2_SET_CH3_ERROR_IRQ_SHIFT (3U)
#define APBH_CTRL2_SET_CH3_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH3_ERROR_IRQ_SHIFT)) & APBH_CTRL2_SET_CH3_ERROR_IRQ_MASK)
#define APBH_CTRL2_SET_CH4_ERROR_IRQ_MASK  (0x10U)
#define APBH_CTRL2_SET_CH4_ERROR_IRQ_SHIFT (4U)
#define APBH_CTRL2_SET_CH4_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH4_ERROR_IRQ_SHIFT)) & APBH_CTRL2_SET_CH4_ERROR_IRQ_MASK)
#define APBH_CTRL2_SET_CH5_ERROR_IRQ_MASK  (0x20U)
#define APBH_CTRL2_SET_CH5_ERROR_IRQ_SHIFT (5U)
#define APBH_CTRL2_SET_CH5_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH5_ERROR_IRQ_SHIFT)) & APBH_CTRL2_SET_CH5_ERROR_IRQ_MASK)
#define APBH_CTRL2_SET_CH6_ERROR_IRQ_MASK  (0x40U)
#define APBH_CTRL2_SET_CH6_ERROR_IRQ_SHIFT (6U)
#define APBH_CTRL2_SET_CH6_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH6_ERROR_IRQ_SHIFT)) & APBH_CTRL2_SET_CH6_ERROR_IRQ_MASK)
#define APBH_CTRL2_SET_CH7_ERROR_IRQ_MASK  (0x80U)
#define APBH_CTRL2_SET_CH7_ERROR_IRQ_SHIFT (7U)
#define APBH_CTRL2_SET_CH7_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH7_ERROR_IRQ_SHIFT)) & APBH_CTRL2_SET_CH7_ERROR_IRQ_MASK)
#define APBH_CTRL2_SET_CH8_ERROR_IRQ_MASK  (0x100U)
#define APBH_CTRL2_SET_CH8_ERROR_IRQ_SHIFT (8U)
#define APBH_CTRL2_SET_CH8_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH8_ERROR_IRQ_SHIFT)) & APBH_CTRL2_SET_CH8_ERROR_IRQ_MASK)
#define APBH_CTRL2_SET_CH9_ERROR_IRQ_MASK  (0x200U)
#define APBH_CTRL2_SET_CH9_ERROR_IRQ_SHIFT (9U)
#define APBH_CTRL2_SET_CH9_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH9_ERROR_IRQ_SHIFT)) & APBH_CTRL2_SET_CH9_ERROR_IRQ_MASK)
#define APBH_CTRL2_SET_CH10_ERROR_IRQ_MASK  (0x400U)
#define APBH_CTRL2_SET_CH10_ERROR_IRQ_SHIFT (10U)
#define APBH_CTRL2_SET_CH10_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH10_ERROR_IRQ_SHIFT)) & APBH_CTRL2_SET_CH10_ERROR_IRQ_MASK)
#define APBH_CTRL2_SET_CH11_ERROR_IRQ_MASK  (0x800U)
#define APBH_CTRL2_SET_CH11_ERROR_IRQ_SHIFT (11U)
#define APBH_CTRL2_SET_CH11_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH11_ERROR_IRQ_SHIFT)) & APBH_CTRL2_SET_CH11_ERROR_IRQ_MASK)
#define APBH_CTRL2_SET_CH12_ERROR_IRQ_MASK  (0x1000U)
#define APBH_CTRL2_SET_CH12_ERROR_IRQ_SHIFT (12U)
#define APBH_CTRL2_SET_CH12_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH12_ERROR_IRQ_SHIFT)) & APBH_CTRL2_SET_CH12_ERROR_IRQ_MASK)
#define APBH_CTRL2_SET_CH13_ERROR_IRQ_MASK  (0x2000U)
#define APBH_CTRL2_SET_CH13_ERROR_IRQ_SHIFT (13U)
#define APBH_CTRL2_SET_CH13_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH13_ERROR_IRQ_SHIFT)) & APBH_CTRL2_SET_CH13_ERROR_IRQ_MASK)
#define APBH_CTRL2_SET_CH14_ERROR_IRQ_MASK  (0x4000U)
#define APBH_CTRL2_SET_CH14_ERROR_IRQ_SHIFT (14U)
#define APBH_CTRL2_SET_CH14_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH14_ERROR_IRQ_SHIFT)) & APBH_CTRL2_SET_CH14_ERROR_IRQ_MASK)
#define APBH_CTRL2_SET_CH15_ERROR_IRQ_MASK  (0x8000U)
#define APBH_CTRL2_SET_CH15_ERROR_IRQ_SHIFT (15U)
#define APBH_CTRL2_SET_CH15_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH15_ERROR_IRQ_SHIFT)) & APBH_CTRL2_SET_CH15_ERROR_IRQ_MASK)
#define APBH_CTRL2_SET_CH0_ERROR_STATUS_MASK  (0x10000U)
#define APBH_CTRL2_SET_CH0_ERROR_STATUS_SHIFT (16U)
/*! CH0_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_SET_CH0_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH0_ERROR_STATUS_SHIFT)) & APBH_CTRL2_SET_CH0_ERROR_STATUS_MASK)
#define APBH_CTRL2_SET_CH1_ERROR_STATUS_MASK  (0x20000U)
#define APBH_CTRL2_SET_CH1_ERROR_STATUS_SHIFT (17U)
/*! CH1_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_SET_CH1_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH1_ERROR_STATUS_SHIFT)) & APBH_CTRL2_SET_CH1_ERROR_STATUS_MASK)
#define APBH_CTRL2_SET_CH2_ERROR_STATUS_MASK  (0x40000U)
#define APBH_CTRL2_SET_CH2_ERROR_STATUS_SHIFT (18U)
/*! CH2_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_SET_CH2_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH2_ERROR_STATUS_SHIFT)) & APBH_CTRL2_SET_CH2_ERROR_STATUS_MASK)
#define APBH_CTRL2_SET_CH3_ERROR_STATUS_MASK  (0x80000U)
#define APBH_CTRL2_SET_CH3_ERROR_STATUS_SHIFT (19U)
/*! CH3_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_SET_CH3_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH3_ERROR_STATUS_SHIFT)) & APBH_CTRL2_SET_CH3_ERROR_STATUS_MASK)
#define APBH_CTRL2_SET_CH4_ERROR_STATUS_MASK  (0x100000U)
#define APBH_CTRL2_SET_CH4_ERROR_STATUS_SHIFT (20U)
/*! CH4_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_SET_CH4_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH4_ERROR_STATUS_SHIFT)) & APBH_CTRL2_SET_CH4_ERROR_STATUS_MASK)
#define APBH_CTRL2_SET_CH5_ERROR_STATUS_MASK  (0x200000U)
#define APBH_CTRL2_SET_CH5_ERROR_STATUS_SHIFT (21U)
/*! CH5_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_SET_CH5_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH5_ERROR_STATUS_SHIFT)) & APBH_CTRL2_SET_CH5_ERROR_STATUS_MASK)
#define APBH_CTRL2_SET_CH6_ERROR_STATUS_MASK  (0x400000U)
#define APBH_CTRL2_SET_CH6_ERROR_STATUS_SHIFT (22U)
/*! CH6_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_SET_CH6_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH6_ERROR_STATUS_SHIFT)) & APBH_CTRL2_SET_CH6_ERROR_STATUS_MASK)
#define APBH_CTRL2_SET_CH7_ERROR_STATUS_MASK  (0x800000U)
#define APBH_CTRL2_SET_CH7_ERROR_STATUS_SHIFT (23U)
/*! CH7_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_SET_CH7_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH7_ERROR_STATUS_SHIFT)) & APBH_CTRL2_SET_CH7_ERROR_STATUS_MASK)
#define APBH_CTRL2_SET_CH8_ERROR_STATUS_MASK  (0x1000000U)
#define APBH_CTRL2_SET_CH8_ERROR_STATUS_SHIFT (24U)
/*! CH8_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_SET_CH8_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH8_ERROR_STATUS_SHIFT)) & APBH_CTRL2_SET_CH8_ERROR_STATUS_MASK)
#define APBH_CTRL2_SET_CH9_ERROR_STATUS_MASK  (0x2000000U)
#define APBH_CTRL2_SET_CH9_ERROR_STATUS_SHIFT (25U)
/*! CH9_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_SET_CH9_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH9_ERROR_STATUS_SHIFT)) & APBH_CTRL2_SET_CH9_ERROR_STATUS_MASK)
#define APBH_CTRL2_SET_CH10_ERROR_STATUS_MASK  (0x4000000U)
#define APBH_CTRL2_SET_CH10_ERROR_STATUS_SHIFT (26U)
/*! CH10_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_SET_CH10_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH10_ERROR_STATUS_SHIFT)) & APBH_CTRL2_SET_CH10_ERROR_STATUS_MASK)
#define APBH_CTRL2_SET_CH11_ERROR_STATUS_MASK  (0x8000000U)
#define APBH_CTRL2_SET_CH11_ERROR_STATUS_SHIFT (27U)
/*! CH11_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_SET_CH11_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH11_ERROR_STATUS_SHIFT)) & APBH_CTRL2_SET_CH11_ERROR_STATUS_MASK)
#define APBH_CTRL2_SET_CH12_ERROR_STATUS_MASK  (0x10000000U)
#define APBH_CTRL2_SET_CH12_ERROR_STATUS_SHIFT (28U)
/*! CH12_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_SET_CH12_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH12_ERROR_STATUS_SHIFT)) & APBH_CTRL2_SET_CH12_ERROR_STATUS_MASK)
#define APBH_CTRL2_SET_CH13_ERROR_STATUS_MASK  (0x20000000U)
#define APBH_CTRL2_SET_CH13_ERROR_STATUS_SHIFT (29U)
/*! CH13_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_SET_CH13_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH13_ERROR_STATUS_SHIFT)) & APBH_CTRL2_SET_CH13_ERROR_STATUS_MASK)
#define APBH_CTRL2_SET_CH14_ERROR_STATUS_MASK  (0x40000000U)
#define APBH_CTRL2_SET_CH14_ERROR_STATUS_SHIFT (30U)
/*! CH14_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_SET_CH14_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH14_ERROR_STATUS_SHIFT)) & APBH_CTRL2_SET_CH14_ERROR_STATUS_MASK)
#define APBH_CTRL2_SET_CH15_ERROR_STATUS_MASK  (0x80000000U)
#define APBH_CTRL2_SET_CH15_ERROR_STATUS_SHIFT (31U)
/*! CH15_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_SET_CH15_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_SET_CH15_ERROR_STATUS_SHIFT)) & APBH_CTRL2_SET_CH15_ERROR_STATUS_MASK)
/*! @} */

/*! @name CTRL2_CLR - AHB to APBH Bridge Control and Status Register 2 */
/*! @{ */
#define APBH_CTRL2_CLR_CH0_ERROR_IRQ_MASK  (0x1U)
#define APBH_CTRL2_CLR_CH0_ERROR_IRQ_SHIFT (0U)
#define APBH_CTRL2_CLR_CH0_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH0_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CLR_CH0_ERROR_IRQ_MASK)
#define APBH_CTRL2_CLR_CH1_ERROR_IRQ_MASK  (0x2U)
#define APBH_CTRL2_CLR_CH1_ERROR_IRQ_SHIFT (1U)
#define APBH_CTRL2_CLR_CH1_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH1_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CLR_CH1_ERROR_IRQ_MASK)
#define APBH_CTRL2_CLR_CH2_ERROR_IRQ_MASK  (0x4U)
#define APBH_CTRL2_CLR_CH2_ERROR_IRQ_SHIFT (2U)
#define APBH_CTRL2_CLR_CH2_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH2_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CLR_CH2_ERROR_IRQ_MASK)
#define APBH_CTRL2_CLR_CH3_ERROR_IRQ_MASK  (0x8U)
#define APBH_CTRL2_CLR_CH3_ERROR_IRQ_SHIFT (3U)
#define APBH_CTRL2_CLR_CH3_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH3_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CLR_CH3_ERROR_IRQ_MASK)
#define APBH_CTRL2_CLR_CH4_ERROR_IRQ_MASK  (0x10U)
#define APBH_CTRL2_CLR_CH4_ERROR_IRQ_SHIFT (4U)
#define APBH_CTRL2_CLR_CH4_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH4_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CLR_CH4_ERROR_IRQ_MASK)
#define APBH_CTRL2_CLR_CH5_ERROR_IRQ_MASK  (0x20U)
#define APBH_CTRL2_CLR_CH5_ERROR_IRQ_SHIFT (5U)
#define APBH_CTRL2_CLR_CH5_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH5_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CLR_CH5_ERROR_IRQ_MASK)
#define APBH_CTRL2_CLR_CH6_ERROR_IRQ_MASK  (0x40U)
#define APBH_CTRL2_CLR_CH6_ERROR_IRQ_SHIFT (6U)
#define APBH_CTRL2_CLR_CH6_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH6_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CLR_CH6_ERROR_IRQ_MASK)
#define APBH_CTRL2_CLR_CH7_ERROR_IRQ_MASK  (0x80U)
#define APBH_CTRL2_CLR_CH7_ERROR_IRQ_SHIFT (7U)
#define APBH_CTRL2_CLR_CH7_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH7_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CLR_CH7_ERROR_IRQ_MASK)
#define APBH_CTRL2_CLR_CH8_ERROR_IRQ_MASK  (0x100U)
#define APBH_CTRL2_CLR_CH8_ERROR_IRQ_SHIFT (8U)
#define APBH_CTRL2_CLR_CH8_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH8_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CLR_CH8_ERROR_IRQ_MASK)
#define APBH_CTRL2_CLR_CH9_ERROR_IRQ_MASK  (0x200U)
#define APBH_CTRL2_CLR_CH9_ERROR_IRQ_SHIFT (9U)
#define APBH_CTRL2_CLR_CH9_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH9_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CLR_CH9_ERROR_IRQ_MASK)
#define APBH_CTRL2_CLR_CH10_ERROR_IRQ_MASK  (0x400U)
#define APBH_CTRL2_CLR_CH10_ERROR_IRQ_SHIFT (10U)
#define APBH_CTRL2_CLR_CH10_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH10_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CLR_CH10_ERROR_IRQ_MASK)
#define APBH_CTRL2_CLR_CH11_ERROR_IRQ_MASK  (0x800U)
#define APBH_CTRL2_CLR_CH11_ERROR_IRQ_SHIFT (11U)
#define APBH_CTRL2_CLR_CH11_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH11_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CLR_CH11_ERROR_IRQ_MASK)
#define APBH_CTRL2_CLR_CH12_ERROR_IRQ_MASK  (0x1000U)
#define APBH_CTRL2_CLR_CH12_ERROR_IRQ_SHIFT (12U)
#define APBH_CTRL2_CLR_CH12_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH12_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CLR_CH12_ERROR_IRQ_MASK)
#define APBH_CTRL2_CLR_CH13_ERROR_IRQ_MASK  (0x2000U)
#define APBH_CTRL2_CLR_CH13_ERROR_IRQ_SHIFT (13U)
#define APBH_CTRL2_CLR_CH13_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH13_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CLR_CH13_ERROR_IRQ_MASK)
#define APBH_CTRL2_CLR_CH14_ERROR_IRQ_MASK  (0x4000U)
#define APBH_CTRL2_CLR_CH14_ERROR_IRQ_SHIFT (14U)
#define APBH_CTRL2_CLR_CH14_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH14_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CLR_CH14_ERROR_IRQ_MASK)
#define APBH_CTRL2_CLR_CH15_ERROR_IRQ_MASK  (0x8000U)
#define APBH_CTRL2_CLR_CH15_ERROR_IRQ_SHIFT (15U)
#define APBH_CTRL2_CLR_CH15_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH15_ERROR_IRQ_SHIFT)) & APBH_CTRL2_CLR_CH15_ERROR_IRQ_MASK)
#define APBH_CTRL2_CLR_CH0_ERROR_STATUS_MASK  (0x10000U)
#define APBH_CTRL2_CLR_CH0_ERROR_STATUS_SHIFT (16U)
/*! CH0_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_CLR_CH0_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH0_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CLR_CH0_ERROR_STATUS_MASK)
#define APBH_CTRL2_CLR_CH1_ERROR_STATUS_MASK  (0x20000U)
#define APBH_CTRL2_CLR_CH1_ERROR_STATUS_SHIFT (17U)
/*! CH1_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_CLR_CH1_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH1_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CLR_CH1_ERROR_STATUS_MASK)
#define APBH_CTRL2_CLR_CH2_ERROR_STATUS_MASK  (0x40000U)
#define APBH_CTRL2_CLR_CH2_ERROR_STATUS_SHIFT (18U)
/*! CH2_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_CLR_CH2_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH2_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CLR_CH2_ERROR_STATUS_MASK)
#define APBH_CTRL2_CLR_CH3_ERROR_STATUS_MASK  (0x80000U)
#define APBH_CTRL2_CLR_CH3_ERROR_STATUS_SHIFT (19U)
/*! CH3_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_CLR_CH3_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH3_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CLR_CH3_ERROR_STATUS_MASK)
#define APBH_CTRL2_CLR_CH4_ERROR_STATUS_MASK  (0x100000U)
#define APBH_CTRL2_CLR_CH4_ERROR_STATUS_SHIFT (20U)
/*! CH4_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_CLR_CH4_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH4_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CLR_CH4_ERROR_STATUS_MASK)
#define APBH_CTRL2_CLR_CH5_ERROR_STATUS_MASK  (0x200000U)
#define APBH_CTRL2_CLR_CH5_ERROR_STATUS_SHIFT (21U)
/*! CH5_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_CLR_CH5_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH5_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CLR_CH5_ERROR_STATUS_MASK)
#define APBH_CTRL2_CLR_CH6_ERROR_STATUS_MASK  (0x400000U)
#define APBH_CTRL2_CLR_CH6_ERROR_STATUS_SHIFT (22U)
/*! CH6_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_CLR_CH6_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH6_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CLR_CH6_ERROR_STATUS_MASK)
#define APBH_CTRL2_CLR_CH7_ERROR_STATUS_MASK  (0x800000U)
#define APBH_CTRL2_CLR_CH7_ERROR_STATUS_SHIFT (23U)
/*! CH7_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_CLR_CH7_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH7_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CLR_CH7_ERROR_STATUS_MASK)
#define APBH_CTRL2_CLR_CH8_ERROR_STATUS_MASK  (0x1000000U)
#define APBH_CTRL2_CLR_CH8_ERROR_STATUS_SHIFT (24U)
/*! CH8_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_CLR_CH8_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH8_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CLR_CH8_ERROR_STATUS_MASK)
#define APBH_CTRL2_CLR_CH9_ERROR_STATUS_MASK  (0x2000000U)
#define APBH_CTRL2_CLR_CH9_ERROR_STATUS_SHIFT (25U)
/*! CH9_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_CLR_CH9_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH9_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CLR_CH9_ERROR_STATUS_MASK)
#define APBH_CTRL2_CLR_CH10_ERROR_STATUS_MASK  (0x4000000U)
#define APBH_CTRL2_CLR_CH10_ERROR_STATUS_SHIFT (26U)
/*! CH10_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_CLR_CH10_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH10_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CLR_CH10_ERROR_STATUS_MASK)
#define APBH_CTRL2_CLR_CH11_ERROR_STATUS_MASK  (0x8000000U)
#define APBH_CTRL2_CLR_CH11_ERROR_STATUS_SHIFT (27U)
/*! CH11_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_CLR_CH11_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH11_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CLR_CH11_ERROR_STATUS_MASK)
#define APBH_CTRL2_CLR_CH12_ERROR_STATUS_MASK  (0x10000000U)
#define APBH_CTRL2_CLR_CH12_ERROR_STATUS_SHIFT (28U)
/*! CH12_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_CLR_CH12_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH12_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CLR_CH12_ERROR_STATUS_MASK)
#define APBH_CTRL2_CLR_CH13_ERROR_STATUS_MASK  (0x20000000U)
#define APBH_CTRL2_CLR_CH13_ERROR_STATUS_SHIFT (29U)
/*! CH13_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_CLR_CH13_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH13_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CLR_CH13_ERROR_STATUS_MASK)
#define APBH_CTRL2_CLR_CH14_ERROR_STATUS_MASK  (0x40000000U)
#define APBH_CTRL2_CLR_CH14_ERROR_STATUS_SHIFT (30U)
/*! CH14_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_CLR_CH14_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH14_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CLR_CH14_ERROR_STATUS_MASK)
#define APBH_CTRL2_CLR_CH15_ERROR_STATUS_MASK  (0x80000000U)
#define APBH_CTRL2_CLR_CH15_ERROR_STATUS_SHIFT (31U)
/*! CH15_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_CLR_CH15_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_CLR_CH15_ERROR_STATUS_SHIFT)) & APBH_CTRL2_CLR_CH15_ERROR_STATUS_MASK)
/*! @} */

/*! @name CTRL2_TOG - AHB to APBH Bridge Control and Status Register 2 */
/*! @{ */
#define APBH_CTRL2_TOG_CH0_ERROR_IRQ_MASK  (0x1U)
#define APBH_CTRL2_TOG_CH0_ERROR_IRQ_SHIFT (0U)
#define APBH_CTRL2_TOG_CH0_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH0_ERROR_IRQ_SHIFT)) & APBH_CTRL2_TOG_CH0_ERROR_IRQ_MASK)
#define APBH_CTRL2_TOG_CH1_ERROR_IRQ_MASK  (0x2U)
#define APBH_CTRL2_TOG_CH1_ERROR_IRQ_SHIFT (1U)
#define APBH_CTRL2_TOG_CH1_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH1_ERROR_IRQ_SHIFT)) & APBH_CTRL2_TOG_CH1_ERROR_IRQ_MASK)
#define APBH_CTRL2_TOG_CH2_ERROR_IRQ_MASK  (0x4U)
#define APBH_CTRL2_TOG_CH2_ERROR_IRQ_SHIFT (2U)
#define APBH_CTRL2_TOG_CH2_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH2_ERROR_IRQ_SHIFT)) & APBH_CTRL2_TOG_CH2_ERROR_IRQ_MASK)
#define APBH_CTRL2_TOG_CH3_ERROR_IRQ_MASK  (0x8U)
#define APBH_CTRL2_TOG_CH3_ERROR_IRQ_SHIFT (3U)
#define APBH_CTRL2_TOG_CH3_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH3_ERROR_IRQ_SHIFT)) & APBH_CTRL2_TOG_CH3_ERROR_IRQ_MASK)
#define APBH_CTRL2_TOG_CH4_ERROR_IRQ_MASK  (0x10U)
#define APBH_CTRL2_TOG_CH4_ERROR_IRQ_SHIFT (4U)
#define APBH_CTRL2_TOG_CH4_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH4_ERROR_IRQ_SHIFT)) & APBH_CTRL2_TOG_CH4_ERROR_IRQ_MASK)
#define APBH_CTRL2_TOG_CH5_ERROR_IRQ_MASK  (0x20U)
#define APBH_CTRL2_TOG_CH5_ERROR_IRQ_SHIFT (5U)
#define APBH_CTRL2_TOG_CH5_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH5_ERROR_IRQ_SHIFT)) & APBH_CTRL2_TOG_CH5_ERROR_IRQ_MASK)
#define APBH_CTRL2_TOG_CH6_ERROR_IRQ_MASK  (0x40U)
#define APBH_CTRL2_TOG_CH6_ERROR_IRQ_SHIFT (6U)
#define APBH_CTRL2_TOG_CH6_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH6_ERROR_IRQ_SHIFT)) & APBH_CTRL2_TOG_CH6_ERROR_IRQ_MASK)
#define APBH_CTRL2_TOG_CH7_ERROR_IRQ_MASK  (0x80U)
#define APBH_CTRL2_TOG_CH7_ERROR_IRQ_SHIFT (7U)
#define APBH_CTRL2_TOG_CH7_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH7_ERROR_IRQ_SHIFT)) & APBH_CTRL2_TOG_CH7_ERROR_IRQ_MASK)
#define APBH_CTRL2_TOG_CH8_ERROR_IRQ_MASK  (0x100U)
#define APBH_CTRL2_TOG_CH8_ERROR_IRQ_SHIFT (8U)
#define APBH_CTRL2_TOG_CH8_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH8_ERROR_IRQ_SHIFT)) & APBH_CTRL2_TOG_CH8_ERROR_IRQ_MASK)
#define APBH_CTRL2_TOG_CH9_ERROR_IRQ_MASK  (0x200U)
#define APBH_CTRL2_TOG_CH9_ERROR_IRQ_SHIFT (9U)
#define APBH_CTRL2_TOG_CH9_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH9_ERROR_IRQ_SHIFT)) & APBH_CTRL2_TOG_CH9_ERROR_IRQ_MASK)
#define APBH_CTRL2_TOG_CH10_ERROR_IRQ_MASK  (0x400U)
#define APBH_CTRL2_TOG_CH10_ERROR_IRQ_SHIFT (10U)
#define APBH_CTRL2_TOG_CH10_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH10_ERROR_IRQ_SHIFT)) & APBH_CTRL2_TOG_CH10_ERROR_IRQ_MASK)
#define APBH_CTRL2_TOG_CH11_ERROR_IRQ_MASK  (0x800U)
#define APBH_CTRL2_TOG_CH11_ERROR_IRQ_SHIFT (11U)
#define APBH_CTRL2_TOG_CH11_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH11_ERROR_IRQ_SHIFT)) & APBH_CTRL2_TOG_CH11_ERROR_IRQ_MASK)
#define APBH_CTRL2_TOG_CH12_ERROR_IRQ_MASK  (0x1000U)
#define APBH_CTRL2_TOG_CH12_ERROR_IRQ_SHIFT (12U)
#define APBH_CTRL2_TOG_CH12_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH12_ERROR_IRQ_SHIFT)) & APBH_CTRL2_TOG_CH12_ERROR_IRQ_MASK)
#define APBH_CTRL2_TOG_CH13_ERROR_IRQ_MASK  (0x2000U)
#define APBH_CTRL2_TOG_CH13_ERROR_IRQ_SHIFT (13U)
#define APBH_CTRL2_TOG_CH13_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH13_ERROR_IRQ_SHIFT)) & APBH_CTRL2_TOG_CH13_ERROR_IRQ_MASK)
#define APBH_CTRL2_TOG_CH14_ERROR_IRQ_MASK  (0x4000U)
#define APBH_CTRL2_TOG_CH14_ERROR_IRQ_SHIFT (14U)
#define APBH_CTRL2_TOG_CH14_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH14_ERROR_IRQ_SHIFT)) & APBH_CTRL2_TOG_CH14_ERROR_IRQ_MASK)
#define APBH_CTRL2_TOG_CH15_ERROR_IRQ_MASK  (0x8000U)
#define APBH_CTRL2_TOG_CH15_ERROR_IRQ_SHIFT (15U)
#define APBH_CTRL2_TOG_CH15_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH15_ERROR_IRQ_SHIFT)) & APBH_CTRL2_TOG_CH15_ERROR_IRQ_MASK)
#define APBH_CTRL2_TOG_CH0_ERROR_STATUS_MASK  (0x10000U)
#define APBH_CTRL2_TOG_CH0_ERROR_STATUS_SHIFT (16U)
/*! CH0_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_TOG_CH0_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH0_ERROR_STATUS_SHIFT)) & APBH_CTRL2_TOG_CH0_ERROR_STATUS_MASK)
#define APBH_CTRL2_TOG_CH1_ERROR_STATUS_MASK  (0x20000U)
#define APBH_CTRL2_TOG_CH1_ERROR_STATUS_SHIFT (17U)
/*! CH1_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_TOG_CH1_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH1_ERROR_STATUS_SHIFT)) & APBH_CTRL2_TOG_CH1_ERROR_STATUS_MASK)
#define APBH_CTRL2_TOG_CH2_ERROR_STATUS_MASK  (0x40000U)
#define APBH_CTRL2_TOG_CH2_ERROR_STATUS_SHIFT (18U)
/*! CH2_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_TOG_CH2_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH2_ERROR_STATUS_SHIFT)) & APBH_CTRL2_TOG_CH2_ERROR_STATUS_MASK)
#define APBH_CTRL2_TOG_CH3_ERROR_STATUS_MASK  (0x80000U)
#define APBH_CTRL2_TOG_CH3_ERROR_STATUS_SHIFT (19U)
/*! CH3_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_TOG_CH3_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH3_ERROR_STATUS_SHIFT)) & APBH_CTRL2_TOG_CH3_ERROR_STATUS_MASK)
#define APBH_CTRL2_TOG_CH4_ERROR_STATUS_MASK  (0x100000U)
#define APBH_CTRL2_TOG_CH4_ERROR_STATUS_SHIFT (20U)
/*! CH4_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_TOG_CH4_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH4_ERROR_STATUS_SHIFT)) & APBH_CTRL2_TOG_CH4_ERROR_STATUS_MASK)
#define APBH_CTRL2_TOG_CH5_ERROR_STATUS_MASK  (0x200000U)
#define APBH_CTRL2_TOG_CH5_ERROR_STATUS_SHIFT (21U)
/*! CH5_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_TOG_CH5_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH5_ERROR_STATUS_SHIFT)) & APBH_CTRL2_TOG_CH5_ERROR_STATUS_MASK)
#define APBH_CTRL2_TOG_CH6_ERROR_STATUS_MASK  (0x400000U)
#define APBH_CTRL2_TOG_CH6_ERROR_STATUS_SHIFT (22U)
/*! CH6_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_TOG_CH6_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH6_ERROR_STATUS_SHIFT)) & APBH_CTRL2_TOG_CH6_ERROR_STATUS_MASK)
#define APBH_CTRL2_TOG_CH7_ERROR_STATUS_MASK  (0x800000U)
#define APBH_CTRL2_TOG_CH7_ERROR_STATUS_SHIFT (23U)
/*! CH7_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_TOG_CH7_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH7_ERROR_STATUS_SHIFT)) & APBH_CTRL2_TOG_CH7_ERROR_STATUS_MASK)
#define APBH_CTRL2_TOG_CH8_ERROR_STATUS_MASK  (0x1000000U)
#define APBH_CTRL2_TOG_CH8_ERROR_STATUS_SHIFT (24U)
/*! CH8_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_TOG_CH8_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH8_ERROR_STATUS_SHIFT)) & APBH_CTRL2_TOG_CH8_ERROR_STATUS_MASK)
#define APBH_CTRL2_TOG_CH9_ERROR_STATUS_MASK  (0x2000000U)
#define APBH_CTRL2_TOG_CH9_ERROR_STATUS_SHIFT (25U)
/*! CH9_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_TOG_CH9_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH9_ERROR_STATUS_SHIFT)) & APBH_CTRL2_TOG_CH9_ERROR_STATUS_MASK)
#define APBH_CTRL2_TOG_CH10_ERROR_STATUS_MASK  (0x4000000U)
#define APBH_CTRL2_TOG_CH10_ERROR_STATUS_SHIFT (26U)
/*! CH10_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_TOG_CH10_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH10_ERROR_STATUS_SHIFT)) & APBH_CTRL2_TOG_CH10_ERROR_STATUS_MASK)
#define APBH_CTRL2_TOG_CH11_ERROR_STATUS_MASK  (0x8000000U)
#define APBH_CTRL2_TOG_CH11_ERROR_STATUS_SHIFT (27U)
/*! CH11_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_TOG_CH11_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH11_ERROR_STATUS_SHIFT)) & APBH_CTRL2_TOG_CH11_ERROR_STATUS_MASK)
#define APBH_CTRL2_TOG_CH12_ERROR_STATUS_MASK  (0x10000000U)
#define APBH_CTRL2_TOG_CH12_ERROR_STATUS_SHIFT (28U)
/*! CH12_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_TOG_CH12_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH12_ERROR_STATUS_SHIFT)) & APBH_CTRL2_TOG_CH12_ERROR_STATUS_MASK)
#define APBH_CTRL2_TOG_CH13_ERROR_STATUS_MASK  (0x20000000U)
#define APBH_CTRL2_TOG_CH13_ERROR_STATUS_SHIFT (29U)
/*! CH13_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_TOG_CH13_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH13_ERROR_STATUS_SHIFT)) & APBH_CTRL2_TOG_CH13_ERROR_STATUS_MASK)
#define APBH_CTRL2_TOG_CH14_ERROR_STATUS_MASK  (0x40000000U)
#define APBH_CTRL2_TOG_CH14_ERROR_STATUS_SHIFT (30U)
/*! CH14_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_TOG_CH14_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH14_ERROR_STATUS_SHIFT)) & APBH_CTRL2_TOG_CH14_ERROR_STATUS_MASK)
#define APBH_CTRL2_TOG_CH15_ERROR_STATUS_MASK  (0x80000000U)
#define APBH_CTRL2_TOG_CH15_ERROR_STATUS_SHIFT (31U)
/*! CH15_ERROR_STATUS
 *  0b0..An early termination from the device causes error IRQ.
 *  0b1..An AHB bus error causes error IRQ.
 */
#define APBH_CTRL2_TOG_CH15_ERROR_STATUS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CTRL2_TOG_CH15_ERROR_STATUS_SHIFT)) & APBH_CTRL2_TOG_CH15_ERROR_STATUS_MASK)
/*! @} */

/*! @name CHANNEL_CTRL - AHB to APBH Bridge Channel Register */
/*! @{ */
#define APBH_CHANNEL_CTRL_FREEZE_CHANNEL_MASK  (0xFFFFU)
#define APBH_CHANNEL_CTRL_FREEZE_CHANNEL_SHIFT (0U)
/*! FREEZE_CHANNEL
 *  0b0000000000000001..NAND0
 *  0b0000000000000010..NAND1
 *  0b0000000000000100..NAND2
 *  0b0000000000001000..NAND3
 *  0b0000000000010000..NAND4
 *  0b0000000000100000..NAND5
 *  0b0000000001000000..NAND6
 *  0b0000000010000000..NAND7
 *  0b0000000100000000..SSP
 */
#define APBH_CHANNEL_CTRL_FREEZE_CHANNEL(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CHANNEL_CTRL_FREEZE_CHANNEL_SHIFT)) & APBH_CHANNEL_CTRL_FREEZE_CHANNEL_MASK)
#define APBH_CHANNEL_CTRL_RESET_CHANNEL_MASK  (0xFFFF0000U)
#define APBH_CHANNEL_CTRL_RESET_CHANNEL_SHIFT (16U)
/*! RESET_CHANNEL
 *  0b0000000000000001..NAND0
 *  0b0000000000000010..NAND1
 *  0b0000000000000100..NAND2
 *  0b0000000000001000..NAND3
 *  0b0000000000010000..NAND4
 *  0b0000000000100000..NAND5
 *  0b0000000001000000..NAND6
 *  0b0000000010000000..NAND7
 *  0b0000000100000000..SSP
 */
#define APBH_CHANNEL_CTRL_RESET_CHANNEL(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CHANNEL_CTRL_RESET_CHANNEL_SHIFT)) & APBH_CHANNEL_CTRL_RESET_CHANNEL_MASK)
/*! @} */

/*! @name CHANNEL_CTRL_SET - AHB to APBH Bridge Channel Register */
/*! @{ */
#define APBH_CHANNEL_CTRL_SET_FREEZE_CHANNEL_MASK  (0xFFFFU)
#define APBH_CHANNEL_CTRL_SET_FREEZE_CHANNEL_SHIFT (0U)
/*! FREEZE_CHANNEL
 *  0b0000000000000001..NAND0
 *  0b0000000000000010..NAND1
 *  0b0000000000000100..NAND2
 *  0b0000000000001000..NAND3
 *  0b0000000000010000..NAND4
 *  0b0000000000100000..NAND5
 *  0b0000000001000000..NAND6
 *  0b0000000010000000..NAND7
 *  0b0000000100000000..SSP
 */
#define APBH_CHANNEL_CTRL_SET_FREEZE_CHANNEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CHANNEL_CTRL_SET_FREEZE_CHANNEL_SHIFT)) & \
     APBH_CHANNEL_CTRL_SET_FREEZE_CHANNEL_MASK)
#define APBH_CHANNEL_CTRL_SET_RESET_CHANNEL_MASK  (0xFFFF0000U)
#define APBH_CHANNEL_CTRL_SET_RESET_CHANNEL_SHIFT (16U)
/*! RESET_CHANNEL
 *  0b0000000000000001..NAND0
 *  0b0000000000000010..NAND1
 *  0b0000000000000100..NAND2
 *  0b0000000000001000..NAND3
 *  0b0000000000010000..NAND4
 *  0b0000000000100000..NAND5
 *  0b0000000001000000..NAND6
 *  0b0000000010000000..NAND7
 *  0b0000000100000000..SSP
 */
#define APBH_CHANNEL_CTRL_SET_RESET_CHANNEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CHANNEL_CTRL_SET_RESET_CHANNEL_SHIFT)) & \
     APBH_CHANNEL_CTRL_SET_RESET_CHANNEL_MASK)
/*! @} */

/*! @name CHANNEL_CTRL_CLR - AHB to APBH Bridge Channel Register */
/*! @{ */
#define APBH_CHANNEL_CTRL_CLR_FREEZE_CHANNEL_MASK  (0xFFFFU)
#define APBH_CHANNEL_CTRL_CLR_FREEZE_CHANNEL_SHIFT (0U)
/*! FREEZE_CHANNEL
 *  0b0000000000000001..NAND0
 *  0b0000000000000010..NAND1
 *  0b0000000000000100..NAND2
 *  0b0000000000001000..NAND3
 *  0b0000000000010000..NAND4
 *  0b0000000000100000..NAND5
 *  0b0000000001000000..NAND6
 *  0b0000000010000000..NAND7
 *  0b0000000100000000..SSP
 */
#define APBH_CHANNEL_CTRL_CLR_FREEZE_CHANNEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CHANNEL_CTRL_CLR_FREEZE_CHANNEL_SHIFT)) & \
     APBH_CHANNEL_CTRL_CLR_FREEZE_CHANNEL_MASK)
#define APBH_CHANNEL_CTRL_CLR_RESET_CHANNEL_MASK  (0xFFFF0000U)
#define APBH_CHANNEL_CTRL_CLR_RESET_CHANNEL_SHIFT (16U)
/*! RESET_CHANNEL
 *  0b0000000000000001..NAND0
 *  0b0000000000000010..NAND1
 *  0b0000000000000100..NAND2
 *  0b0000000000001000..NAND3
 *  0b0000000000010000..NAND4
 *  0b0000000000100000..NAND5
 *  0b0000000001000000..NAND6
 *  0b0000000010000000..NAND7
 *  0b0000000100000000..SSP
 */
#define APBH_CHANNEL_CTRL_CLR_RESET_CHANNEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CHANNEL_CTRL_CLR_RESET_CHANNEL_SHIFT)) & \
     APBH_CHANNEL_CTRL_CLR_RESET_CHANNEL_MASK)
/*! @} */

/*! @name CHANNEL_CTRL_TOG - AHB to APBH Bridge Channel Register */
/*! @{ */
#define APBH_CHANNEL_CTRL_TOG_FREEZE_CHANNEL_MASK  (0xFFFFU)
#define APBH_CHANNEL_CTRL_TOG_FREEZE_CHANNEL_SHIFT (0U)
/*! FREEZE_CHANNEL
 *  0b0000000000000001..NAND0
 *  0b0000000000000010..NAND1
 *  0b0000000000000100..NAND2
 *  0b0000000000001000..NAND3
 *  0b0000000000010000..NAND4
 *  0b0000000000100000..NAND5
 *  0b0000000001000000..NAND6
 *  0b0000000010000000..NAND7
 *  0b0000000100000000..SSP
 */
#define APBH_CHANNEL_CTRL_TOG_FREEZE_CHANNEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CHANNEL_CTRL_TOG_FREEZE_CHANNEL_SHIFT)) & \
     APBH_CHANNEL_CTRL_TOG_FREEZE_CHANNEL_MASK)
#define APBH_CHANNEL_CTRL_TOG_RESET_CHANNEL_MASK  (0xFFFF0000U)
#define APBH_CHANNEL_CTRL_TOG_RESET_CHANNEL_SHIFT (16U)
/*! RESET_CHANNEL
 *  0b0000000000000001..NAND0
 *  0b0000000000000010..NAND1
 *  0b0000000000000100..NAND2
 *  0b0000000000001000..NAND3
 *  0b0000000000010000..NAND4
 *  0b0000000000100000..NAND5
 *  0b0000000001000000..NAND6
 *  0b0000000010000000..NAND7
 *  0b0000000100000000..SSP
 */
#define APBH_CHANNEL_CTRL_TOG_RESET_CHANNEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << APBH_CHANNEL_CTRL_TOG_RESET_CHANNEL_SHIFT)) & \
     APBH_CHANNEL_CTRL_TOG_RESET_CHANNEL_MASK)
/*! @} */

/*! @name DEVSEL - AHB to APBH DMA Device Assignment Register */
/*! @{ */
#define APBH_DEVSEL_CH0_MASK   (0x3U)
#define APBH_DEVSEL_CH0_SHIFT  (0U)
#define APBH_DEVSEL_CH0(x)     (((uint32_t)(((uint32_t)(x)) << APBH_DEVSEL_CH0_SHIFT)) & APBH_DEVSEL_CH0_MASK)
#define APBH_DEVSEL_CH1_MASK   (0xCU)
#define APBH_DEVSEL_CH1_SHIFT  (2U)
#define APBH_DEVSEL_CH1(x)     (((uint32_t)(((uint32_t)(x)) << APBH_DEVSEL_CH1_SHIFT)) & APBH_DEVSEL_CH1_MASK)
#define APBH_DEVSEL_CH2_MASK   (0x30U)
#define APBH_DEVSEL_CH2_SHIFT  (4U)
#define APBH_DEVSEL_CH2(x)     (((uint32_t)(((uint32_t)(x)) << APBH_DEVSEL_CH2_SHIFT)) & APBH_DEVSEL_CH2_MASK)
#define APBH_DEVSEL_CH3_MASK   (0xC0U)
#define APBH_DEVSEL_CH3_SHIFT  (6U)
#define APBH_DEVSEL_CH3(x)     (((uint32_t)(((uint32_t)(x)) << APBH_DEVSEL_CH3_SHIFT)) & APBH_DEVSEL_CH3_MASK)
#define APBH_DEVSEL_CH4_MASK   (0x300U)
#define APBH_DEVSEL_CH4_SHIFT  (8U)
#define APBH_DEVSEL_CH4(x)     (((uint32_t)(((uint32_t)(x)) << APBH_DEVSEL_CH4_SHIFT)) & APBH_DEVSEL_CH4_MASK)
#define APBH_DEVSEL_CH5_MASK   (0xC00U)
#define APBH_DEVSEL_CH5_SHIFT  (10U)
#define APBH_DEVSEL_CH5(x)     (((uint32_t)(((uint32_t)(x)) << APBH_DEVSEL_CH5_SHIFT)) & APBH_DEVSEL_CH5_MASK)
#define APBH_DEVSEL_CH6_MASK   (0x3000U)
#define APBH_DEVSEL_CH6_SHIFT  (12U)
#define APBH_DEVSEL_CH6(x)     (((uint32_t)(((uint32_t)(x)) << APBH_DEVSEL_CH6_SHIFT)) & APBH_DEVSEL_CH6_MASK)
#define APBH_DEVSEL_CH7_MASK   (0xC000U)
#define APBH_DEVSEL_CH7_SHIFT  (14U)
#define APBH_DEVSEL_CH7(x)     (((uint32_t)(((uint32_t)(x)) << APBH_DEVSEL_CH7_SHIFT)) & APBH_DEVSEL_CH7_MASK)
#define APBH_DEVSEL_CH8_MASK   (0x30000U)
#define APBH_DEVSEL_CH8_SHIFT  (16U)
#define APBH_DEVSEL_CH8(x)     (((uint32_t)(((uint32_t)(x)) << APBH_DEVSEL_CH8_SHIFT)) & APBH_DEVSEL_CH8_MASK)
#define APBH_DEVSEL_CH9_MASK   (0xC0000U)
#define APBH_DEVSEL_CH9_SHIFT  (18U)
#define APBH_DEVSEL_CH9(x)     (((uint32_t)(((uint32_t)(x)) << APBH_DEVSEL_CH9_SHIFT)) & APBH_DEVSEL_CH9_MASK)
#define APBH_DEVSEL_CH10_MASK  (0x300000U)
#define APBH_DEVSEL_CH10_SHIFT (20U)
#define APBH_DEVSEL_CH10(x)    (((uint32_t)(((uint32_t)(x)) << APBH_DEVSEL_CH10_SHIFT)) & APBH_DEVSEL_CH10_MASK)
#define APBH_DEVSEL_CH11_MASK  (0xC00000U)
#define APBH_DEVSEL_CH11_SHIFT (22U)
#define APBH_DEVSEL_CH11(x)    (((uint32_t)(((uint32_t)(x)) << APBH_DEVSEL_CH11_SHIFT)) & APBH_DEVSEL_CH11_MASK)
#define APBH_DEVSEL_CH12_MASK  (0x3000000U)
#define APBH_DEVSEL_CH12_SHIFT (24U)
#define APBH_DEVSEL_CH12(x)    (((uint32_t)(((uint32_t)(x)) << APBH_DEVSEL_CH12_SHIFT)) & APBH_DEVSEL_CH12_MASK)
#define APBH_DEVSEL_CH13_MASK  (0xC000000U)
#define APBH_DEVSEL_CH13_SHIFT (26U)
#define APBH_DEVSEL_CH13(x)    (((uint32_t)(((uint32_t)(x)) << APBH_DEVSEL_CH13_SHIFT)) & APBH_DEVSEL_CH13_MASK)
#define APBH_DEVSEL_CH14_MASK  (0x30000000U)
#define APBH_DEVSEL_CH14_SHIFT (28U)
#define APBH_DEVSEL_CH14(x)    (((uint32_t)(((uint32_t)(x)) << APBH_DEVSEL_CH14_SHIFT)) & APBH_DEVSEL_CH14_MASK)
#define APBH_DEVSEL_CH15_MASK  (0xC0000000U)
#define APBH_DEVSEL_CH15_SHIFT (30U)
#define APBH_DEVSEL_CH15(x)    (((uint32_t)(((uint32_t)(x)) << APBH_DEVSEL_CH15_SHIFT)) & APBH_DEVSEL_CH15_MASK)
/*! @} */

/*! @name DMA_BURST_SIZE - AHB to APBH DMA burst size */
/*! @{ */
#define APBH_DMA_BURST_SIZE_CH0_MASK  (0x3U)
#define APBH_DMA_BURST_SIZE_CH0_SHIFT (0U)
#define APBH_DMA_BURST_SIZE_CH0(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_DMA_BURST_SIZE_CH0_SHIFT)) & APBH_DMA_BURST_SIZE_CH0_MASK)
#define APBH_DMA_BURST_SIZE_CH1_MASK  (0xCU)
#define APBH_DMA_BURST_SIZE_CH1_SHIFT (2U)
#define APBH_DMA_BURST_SIZE_CH1(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_DMA_BURST_SIZE_CH1_SHIFT)) & APBH_DMA_BURST_SIZE_CH1_MASK)
#define APBH_DMA_BURST_SIZE_CH2_MASK  (0x30U)
#define APBH_DMA_BURST_SIZE_CH2_SHIFT (4U)
#define APBH_DMA_BURST_SIZE_CH2(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_DMA_BURST_SIZE_CH2_SHIFT)) & APBH_DMA_BURST_SIZE_CH2_MASK)
#define APBH_DMA_BURST_SIZE_CH3_MASK  (0xC0U)
#define APBH_DMA_BURST_SIZE_CH3_SHIFT (6U)
#define APBH_DMA_BURST_SIZE_CH3(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_DMA_BURST_SIZE_CH3_SHIFT)) & APBH_DMA_BURST_SIZE_CH3_MASK)
#define APBH_DMA_BURST_SIZE_CH4_MASK  (0x300U)
#define APBH_DMA_BURST_SIZE_CH4_SHIFT (8U)
#define APBH_DMA_BURST_SIZE_CH4(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_DMA_BURST_SIZE_CH4_SHIFT)) & APBH_DMA_BURST_SIZE_CH4_MASK)
#define APBH_DMA_BURST_SIZE_CH5_MASK  (0xC00U)
#define APBH_DMA_BURST_SIZE_CH5_SHIFT (10U)
#define APBH_DMA_BURST_SIZE_CH5(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_DMA_BURST_SIZE_CH5_SHIFT)) & APBH_DMA_BURST_SIZE_CH5_MASK)
#define APBH_DMA_BURST_SIZE_CH6_MASK  (0x3000U)
#define APBH_DMA_BURST_SIZE_CH6_SHIFT (12U)
#define APBH_DMA_BURST_SIZE_CH6(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_DMA_BURST_SIZE_CH6_SHIFT)) & APBH_DMA_BURST_SIZE_CH6_MASK)
#define APBH_DMA_BURST_SIZE_CH7_MASK  (0xC000U)
#define APBH_DMA_BURST_SIZE_CH7_SHIFT (14U)
#define APBH_DMA_BURST_SIZE_CH7(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_DMA_BURST_SIZE_CH7_SHIFT)) & APBH_DMA_BURST_SIZE_CH7_MASK)
#define APBH_DMA_BURST_SIZE_CH8_MASK  (0x30000U)
#define APBH_DMA_BURST_SIZE_CH8_SHIFT (16U)
/*! CH8
 *  0b00..BURST0
 *  0b01..BURST4
 *  0b10..BURST8
 */
#define APBH_DMA_BURST_SIZE_CH8(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_DMA_BURST_SIZE_CH8_SHIFT)) & APBH_DMA_BURST_SIZE_CH8_MASK)
#define APBH_DMA_BURST_SIZE_CH9_MASK  (0xC0000U)
#define APBH_DMA_BURST_SIZE_CH9_SHIFT (18U)
#define APBH_DMA_BURST_SIZE_CH9(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_DMA_BURST_SIZE_CH9_SHIFT)) & APBH_DMA_BURST_SIZE_CH9_MASK)
#define APBH_DMA_BURST_SIZE_CH10_MASK  (0x300000U)
#define APBH_DMA_BURST_SIZE_CH10_SHIFT (20U)
#define APBH_DMA_BURST_SIZE_CH10(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_DMA_BURST_SIZE_CH10_SHIFT)) & APBH_DMA_BURST_SIZE_CH10_MASK)
#define APBH_DMA_BURST_SIZE_CH11_MASK  (0xC00000U)
#define APBH_DMA_BURST_SIZE_CH11_SHIFT (22U)
#define APBH_DMA_BURST_SIZE_CH11(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_DMA_BURST_SIZE_CH11_SHIFT)) & APBH_DMA_BURST_SIZE_CH11_MASK)
#define APBH_DMA_BURST_SIZE_CH12_MASK  (0x3000000U)
#define APBH_DMA_BURST_SIZE_CH12_SHIFT (24U)
#define APBH_DMA_BURST_SIZE_CH12(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_DMA_BURST_SIZE_CH12_SHIFT)) & APBH_DMA_BURST_SIZE_CH12_MASK)
#define APBH_DMA_BURST_SIZE_CH13_MASK  (0xC000000U)
#define APBH_DMA_BURST_SIZE_CH13_SHIFT (26U)
#define APBH_DMA_BURST_SIZE_CH13(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_DMA_BURST_SIZE_CH13_SHIFT)) & APBH_DMA_BURST_SIZE_CH13_MASK)
#define APBH_DMA_BURST_SIZE_CH14_MASK  (0x30000000U)
#define APBH_DMA_BURST_SIZE_CH14_SHIFT (28U)
#define APBH_DMA_BURST_SIZE_CH14(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_DMA_BURST_SIZE_CH14_SHIFT)) & APBH_DMA_BURST_SIZE_CH14_MASK)
#define APBH_DMA_BURST_SIZE_CH15_MASK  (0xC0000000U)
#define APBH_DMA_BURST_SIZE_CH15_SHIFT (30U)
#define APBH_DMA_BURST_SIZE_CH15(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_DMA_BURST_SIZE_CH15_SHIFT)) & APBH_DMA_BURST_SIZE_CH15_MASK)
/*! @} */

/*! @name DEBUG - AHB to APBH DMA Debug Register */
/*! @{ */
#define APBH_DEBUG_GPMI_ONE_FIFO_MASK  (0x1U)
#define APBH_DEBUG_GPMI_ONE_FIFO_SHIFT (0U)
#define APBH_DEBUG_GPMI_ONE_FIFO(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_DEBUG_GPMI_ONE_FIFO_SHIFT)) & APBH_DEBUG_GPMI_ONE_FIFO_MASK)
/*! @} */

/*! @name CH_CURCMDAR - APBH DMA Channel n Current Command Address Register */
/*! @{ */
#define APBH_CH_CURCMDAR_CMD_ADDR_MASK  (0xFFFFFFFFU)
#define APBH_CH_CURCMDAR_CMD_ADDR_SHIFT (0U)
#define APBH_CH_CURCMDAR_CMD_ADDR(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CH_CURCMDAR_CMD_ADDR_SHIFT)) & APBH_CH_CURCMDAR_CMD_ADDR_MASK)
/*! @} */

/* The count of APBH_CH_CURCMDAR */
#define APBH_CH_CURCMDAR_COUNT (16U)

/*! @name CH_NXTCMDAR - APBH DMA Channel n Next Command Address Register */
/*! @{ */
#define APBH_CH_NXTCMDAR_CMD_ADDR_MASK  (0xFFFFFFFFU)
#define APBH_CH_NXTCMDAR_CMD_ADDR_SHIFT (0U)
#define APBH_CH_NXTCMDAR_CMD_ADDR(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CH_NXTCMDAR_CMD_ADDR_SHIFT)) & APBH_CH_NXTCMDAR_CMD_ADDR_MASK)
/*! @} */

/* The count of APBH_CH_NXTCMDAR */
#define APBH_CH_NXTCMDAR_COUNT (16U)

/*! @name CH_CMD - APBH DMA Channel n Command Register */
/*! @{ */
#define APBH_CH_CMD_COMMAND_MASK  (0x3U)
#define APBH_CH_CMD_COMMAND_SHIFT (0U)
/*! COMMAND
 *  0b00..Perform any requested PIO word transfers but terminate command before any DMA transfer.
 *  0b01..Perform any requested PIO word transfers and then perform a DMA transfer from the peripheral for the specified
 * number of bytes. 0b10..Perform any requested PIO word transfers and then perform a DMA transfer to the peripheral for
 * the specified number of bytes. 0b11..Perform any requested PIO word transfers and then perform a conditional branch
 * to the next chained device. Follow the NEXCMD_ADDR pointer if the perpheral sense is true. Follow the BUFFER_ADDRESS
 * as a chain pointer if the peripheral sense line is false.
 */
#define APBH_CH_CMD_COMMAND(x)       (((uint32_t)(((uint32_t)(x)) << APBH_CH_CMD_COMMAND_SHIFT)) & APBH_CH_CMD_COMMAND_MASK)
#define APBH_CH_CMD_CHAIN_MASK       (0x4U)
#define APBH_CH_CMD_CHAIN_SHIFT      (2U)
#define APBH_CH_CMD_CHAIN(x)         (((uint32_t)(((uint32_t)(x)) << APBH_CH_CMD_CHAIN_SHIFT)) & APBH_CH_CMD_CHAIN_MASK)
#define APBH_CH_CMD_IRQONCMPLT_MASK  (0x8U)
#define APBH_CH_CMD_IRQONCMPLT_SHIFT (3U)
#define APBH_CH_CMD_IRQONCMPLT(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CH_CMD_IRQONCMPLT_SHIFT)) & APBH_CH_CMD_IRQONCMPLT_MASK)
#define APBH_CH_CMD_NANDLOCK_MASK  (0x10U)
#define APBH_CH_CMD_NANDLOCK_SHIFT (4U)
#define APBH_CH_CMD_NANDLOCK(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CH_CMD_NANDLOCK_SHIFT)) & APBH_CH_CMD_NANDLOCK_MASK)
#define APBH_CH_CMD_NANDWAIT4READY_MASK  (0x20U)
#define APBH_CH_CMD_NANDWAIT4READY_SHIFT (5U)
#define APBH_CH_CMD_NANDWAIT4READY(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CH_CMD_NANDWAIT4READY_SHIFT)) & APBH_CH_CMD_NANDWAIT4READY_MASK)
#define APBH_CH_CMD_SEMAPHORE_MASK  (0x40U)
#define APBH_CH_CMD_SEMAPHORE_SHIFT (6U)
#define APBH_CH_CMD_SEMAPHORE(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CH_CMD_SEMAPHORE_SHIFT)) & APBH_CH_CMD_SEMAPHORE_MASK)
#define APBH_CH_CMD_WAIT4ENDCMD_MASK  (0x80U)
#define APBH_CH_CMD_WAIT4ENDCMD_SHIFT (7U)
#define APBH_CH_CMD_WAIT4ENDCMD(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CH_CMD_WAIT4ENDCMD_SHIFT)) & APBH_CH_CMD_WAIT4ENDCMD_MASK)
#define APBH_CH_CMD_HALTONTERMINATE_MASK  (0x100U)
#define APBH_CH_CMD_HALTONTERMINATE_SHIFT (8U)
#define APBH_CH_CMD_HALTONTERMINATE(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CH_CMD_HALTONTERMINATE_SHIFT)) & APBH_CH_CMD_HALTONTERMINATE_MASK)
#define APBH_CH_CMD_CMDWORDS_MASK  (0xF000U)
#define APBH_CH_CMD_CMDWORDS_SHIFT (12U)
#define APBH_CH_CMD_CMDWORDS(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CH_CMD_CMDWORDS_SHIFT)) & APBH_CH_CMD_CMDWORDS_MASK)
#define APBH_CH_CMD_XFER_COUNT_MASK  (0xFFFF0000U)
#define APBH_CH_CMD_XFER_COUNT_SHIFT (16U)
#define APBH_CH_CMD_XFER_COUNT(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CH_CMD_XFER_COUNT_SHIFT)) & APBH_CH_CMD_XFER_COUNT_MASK)
/*! @} */

/* The count of APBH_CH_CMD */
#define APBH_CH_CMD_COUNT (16U)

/*! @name CH_BAR - APBH DMA Channel n Buffer Address Register */
/*! @{ */
#define APBH_CH_BAR_ADDRESS_MASK  (0xFFFFFFFFU)
#define APBH_CH_BAR_ADDRESS_SHIFT (0U)
#define APBH_CH_BAR_ADDRESS(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CH_BAR_ADDRESS_SHIFT)) & APBH_CH_BAR_ADDRESS_MASK)
/*! @} */

/* The count of APBH_CH_BAR */
#define APBH_CH_BAR_COUNT (16U)

/*! @name CH_SEMA - APBH DMA Channel n Semaphore Register */
/*! @{ */
#define APBH_CH_SEMA_INCREMENT_SEMA_MASK  (0xFFU)
#define APBH_CH_SEMA_INCREMENT_SEMA_SHIFT (0U)
#define APBH_CH_SEMA_INCREMENT_SEMA(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CH_SEMA_INCREMENT_SEMA_SHIFT)) & APBH_CH_SEMA_INCREMENT_SEMA_MASK)
#define APBH_CH_SEMA_PHORE_MASK  (0xFF0000U)
#define APBH_CH_SEMA_PHORE_SHIFT (16U)
#define APBH_CH_SEMA_PHORE(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CH_SEMA_PHORE_SHIFT)) & APBH_CH_SEMA_PHORE_MASK)
/*! @} */

/* The count of APBH_CH_SEMA */
#define APBH_CH_SEMA_COUNT (16U)

/*! @name CH_DEBUG1 - AHB to APBH DMA Channel n Debug Information */
/*! @{ */
#define APBH_CH_DEBUG1_STATEMACHINE_MASK  (0x1FU)
#define APBH_CH_DEBUG1_STATEMACHINE_SHIFT (0U)
/*! STATEMACHINE
 *  0b00000..This is the idle state of the DMA state machine.
 *  0b00001..State in which the DMA is waiting to receive the first word of a command.
 *  0b00010..State in which the DMA is waiting to receive the third word of a command.
 *  0b00011..State in which the DMA is waiting to receive the second word of a command.
 *  0b00100..The state machine processes the descriptor command field in this state and branches accordingly.
 *  0b00101..The state machine waits in this state for the PIO APB cycles to complete.
 *  0b00110..State in which the DMA is waiting to receive the fourth word of a command, or waiting to receive the
 *           PIO words when PIO count is greater than 1.
 *  0b00111..This state determines whether another PIO cycle needs to occur before starting DMA transfers.
 *  0b01000..During a read transfers, the state machine enters this state waiting for the last bytes to be pushed out on
 * the APB. 0b01001..When an AHB read request occurs, the state machine waits in this state for the AHB transfer to
 * complete. 0b01100..During DMA Write transfers, the state machine waits in this state until the AHB master arbiter
 * accepts the request from this channel. 0b01101..During DMA Read transfers, the state machine waits in this state
 * until the AHB master arbiter accepts the request from this channel. 0b01110..Upon completion of the DMA transfers,
 * this state checks the value of the Chain bit and branches accordingly. 0b01111..The state machine goes to this state
 * after the DMA transfers are complete, and determines what step to take next. 0b10100..When a terminate signal is set,
 * the state machine enters this state until the current AHB transfer is completed. 0b10101..When the Wait for Command
 * End bit is set, the state machine enters this state until the DMA device indicates that the command is complete.
 *  0b11100..During DMA Write transfers, the state machine waits in this state until the AHB master completes the write
 * to the AHB memory space. 0b11101..If HALTONTERMINATE is set and a terminate signal is set, the state machine enters
 * this state and effectively halts. A channel reset is required to exit this state 0b11110..If the Chain bit is a 0,
 * the state machine enters this state and effectively halts. 0b11111..When the NAND Wait for Ready bit is set, the
 * state machine enters this state until the GPMI device indicates that the external device is ready.
 */
#define APBH_CH_DEBUG1_STATEMACHINE(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CH_DEBUG1_STATEMACHINE_SHIFT)) & APBH_CH_DEBUG1_STATEMACHINE_MASK)
#define APBH_CH_DEBUG1_RSVD1_MASK  (0xFFFE0U)
#define APBH_CH_DEBUG1_RSVD1_SHIFT (5U)
#define APBH_CH_DEBUG1_RSVD1(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CH_DEBUG1_RSVD1_SHIFT)) & APBH_CH_DEBUG1_RSVD1_MASK)
#define APBH_CH_DEBUG1_WR_FIFO_FULL_MASK  (0x100000U)
#define APBH_CH_DEBUG1_WR_FIFO_FULL_SHIFT (20U)
#define APBH_CH_DEBUG1_WR_FIFO_FULL(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CH_DEBUG1_WR_FIFO_FULL_SHIFT)) & APBH_CH_DEBUG1_WR_FIFO_FULL_MASK)
#define APBH_CH_DEBUG1_WR_FIFO_EMPTY_MASK  (0x200000U)
#define APBH_CH_DEBUG1_WR_FIFO_EMPTY_SHIFT (21U)
#define APBH_CH_DEBUG1_WR_FIFO_EMPTY(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CH_DEBUG1_WR_FIFO_EMPTY_SHIFT)) & APBH_CH_DEBUG1_WR_FIFO_EMPTY_MASK)
#define APBH_CH_DEBUG1_RD_FIFO_FULL_MASK  (0x400000U)
#define APBH_CH_DEBUG1_RD_FIFO_FULL_SHIFT (22U)
#define APBH_CH_DEBUG1_RD_FIFO_FULL(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CH_DEBUG1_RD_FIFO_FULL_SHIFT)) & APBH_CH_DEBUG1_RD_FIFO_FULL_MASK)
#define APBH_CH_DEBUG1_RD_FIFO_EMPTY_MASK  (0x800000U)
#define APBH_CH_DEBUG1_RD_FIFO_EMPTY_SHIFT (23U)
#define APBH_CH_DEBUG1_RD_FIFO_EMPTY(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CH_DEBUG1_RD_FIFO_EMPTY_SHIFT)) & APBH_CH_DEBUG1_RD_FIFO_EMPTY_MASK)
#define APBH_CH_DEBUG1_NEXTCMDADDRVALID_MASK  (0x1000000U)
#define APBH_CH_DEBUG1_NEXTCMDADDRVALID_SHIFT (24U)
#define APBH_CH_DEBUG1_NEXTCMDADDRVALID(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CH_DEBUG1_NEXTCMDADDRVALID_SHIFT)) & APBH_CH_DEBUG1_NEXTCMDADDRVALID_MASK)
#define APBH_CH_DEBUG1_LOCK_MASK   (0x2000000U)
#define APBH_CH_DEBUG1_LOCK_SHIFT  (25U)
#define APBH_CH_DEBUG1_LOCK(x)     (((uint32_t)(((uint32_t)(x)) << APBH_CH_DEBUG1_LOCK_SHIFT)) & APBH_CH_DEBUG1_LOCK_MASK)
#define APBH_CH_DEBUG1_READY_MASK  (0x4000000U)
#define APBH_CH_DEBUG1_READY_SHIFT (26U)
#define APBH_CH_DEBUG1_READY(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CH_DEBUG1_READY_SHIFT)) & APBH_CH_DEBUG1_READY_MASK)
#define APBH_CH_DEBUG1_SENSE_MASK  (0x8000000U)
#define APBH_CH_DEBUG1_SENSE_SHIFT (27U)
#define APBH_CH_DEBUG1_SENSE(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CH_DEBUG1_SENSE_SHIFT)) & APBH_CH_DEBUG1_SENSE_MASK)
#define APBH_CH_DEBUG1_END_MASK    (0x10000000U)
#define APBH_CH_DEBUG1_END_SHIFT   (28U)
#define APBH_CH_DEBUG1_END(x)      (((uint32_t)(((uint32_t)(x)) << APBH_CH_DEBUG1_END_SHIFT)) & APBH_CH_DEBUG1_END_MASK)
#define APBH_CH_DEBUG1_KICK_MASK   (0x20000000U)
#define APBH_CH_DEBUG1_KICK_SHIFT  (29U)
#define APBH_CH_DEBUG1_KICK(x)     (((uint32_t)(((uint32_t)(x)) << APBH_CH_DEBUG1_KICK_SHIFT)) & APBH_CH_DEBUG1_KICK_MASK)
#define APBH_CH_DEBUG1_BURST_MASK  (0x40000000U)
#define APBH_CH_DEBUG1_BURST_SHIFT (30U)
#define APBH_CH_DEBUG1_BURST(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CH_DEBUG1_BURST_SHIFT)) & APBH_CH_DEBUG1_BURST_MASK)
#define APBH_CH_DEBUG1_REQ_MASK  (0x80000000U)
#define APBH_CH_DEBUG1_REQ_SHIFT (31U)
#define APBH_CH_DEBUG1_REQ(x)    (((uint32_t)(((uint32_t)(x)) << APBH_CH_DEBUG1_REQ_SHIFT)) & APBH_CH_DEBUG1_REQ_MASK)
/*! @} */

/* The count of APBH_CH_DEBUG1 */
#define APBH_CH_DEBUG1_COUNT (16U)

/*! @name CH_DEBUG2 - AHB to APBH DMA Channel n Debug Information */
/*! @{ */
#define APBH_CH_DEBUG2_AHB_BYTES_MASK  (0xFFFFU)
#define APBH_CH_DEBUG2_AHB_BYTES_SHIFT (0U)
#define APBH_CH_DEBUG2_AHB_BYTES(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CH_DEBUG2_AHB_BYTES_SHIFT)) & APBH_CH_DEBUG2_AHB_BYTES_MASK)
#define APBH_CH_DEBUG2_APB_BYTES_MASK  (0xFFFF0000U)
#define APBH_CH_DEBUG2_APB_BYTES_SHIFT (16U)
#define APBH_CH_DEBUG2_APB_BYTES(x) \
    (((uint32_t)(((uint32_t)(x)) << APBH_CH_DEBUG2_APB_BYTES_SHIFT)) & APBH_CH_DEBUG2_APB_BYTES_MASK)
/*! @} */

/* The count of APBH_CH_DEBUG2 */
#define APBH_CH_DEBUG2_COUNT (16U)

/*! @name VERSION - APBH Bridge Version Register */
/*! @{ */
#define APBH_VERSION_STEP_MASK   (0xFFFFU)
#define APBH_VERSION_STEP_SHIFT  (0U)
#define APBH_VERSION_STEP(x)     (((uint32_t)(((uint32_t)(x)) << APBH_VERSION_STEP_SHIFT)) & APBH_VERSION_STEP_MASK)
#define APBH_VERSION_MINOR_MASK  (0xFF0000U)
#define APBH_VERSION_MINOR_SHIFT (16U)
#define APBH_VERSION_MINOR(x)    (((uint32_t)(((uint32_t)(x)) << APBH_VERSION_MINOR_SHIFT)) & APBH_VERSION_MINOR_MASK)
#define APBH_VERSION_MAJOR_MASK  (0xFF000000U)
#define APBH_VERSION_MAJOR_SHIFT (24U)
#define APBH_VERSION_MAJOR(x)    (((uint32_t)(((uint32_t)(x)) << APBH_VERSION_MAJOR_SHIFT)) & APBH_VERSION_MAJOR_MASK)
/*! @} */

/*!
 * @}
 */ /* end of group APBH_Register_Masks */

/* APBH - Peripheral instance base addresses */
/** Peripheral APBH base address */
#define APBH_BASE (0x33000000u)
/** Peripheral APBH base pointer */
#define APBH ((APBH_Type *)APBH_BASE)
/** Array initializer of APBH peripheral base addresses */
#define APBH_BASE_ADDRS \
    {                   \
        APBH_BASE       \
    }
/** Array initializer of APBH peripheral base pointers */
#define APBH_BASE_PTRS \
    {                  \
        APBH           \
    }
/** Interrupt vectors for the APBH peripheral type */
#define APBH_IRQS    \
    {                \
        APBHDMA_IRQn \
    }

/*!
 * @}
 */ /* end of group APBH_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- ASRC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ASRC_Peripheral_Access_Layer ASRC Peripheral Access Layer
 * @{
 */

/** ASRC - Register Layout Typedef */
typedef struct
{
    __O uint32_t WRFIFO[4];              /**< ASRC Input Write FIFO, array offset: 0x0, array step: 0x4 */
    __I uint32_t RDFIFO[4];              /**< ASRC Output Read FIFO, array offset: 0x10, array step: 0x4 */
    __IO uint32_t CTX_CTRL[4];           /**< ASRC Context Control, array offset: 0x20, array step: 0x4 */
    __IO uint32_t CTX_CTRL_EXT1[4];      /**< ASRC Context Control Extended 1, array offset: 0x30, array step: 0x4 */
    __IO uint32_t CTX_CTRL_EXT2[4];      /**< ASRC Context Control Extended 2, array offset: 0x40, array step: 0x4 */
    __IO uint32_t CTRL_IN_ACCESS[4];     /**< ASRC Control Input Access, array offset: 0x50, array step: 0x4 */
    __IO uint32_t PROC_CTRL_SLOT0_R0[4]; /**< ASRC Datapath Processor Control Slot0 Register0, array offset: 0x60, array
                                            step: 0x4 */
    __IO uint32_t PROC_CTRL_SLOT0_R1[4]; /**< ASRC Datapath Processor Control Slot0 Register1, array offset: 0x70, array
                                            step: 0x4 */
    __IO uint32_t PROC_CTRL_SLOT0_R2[4]; /**< ASRC Datapath Processor Control Slot0 Register2, array offset: 0x80, array
                                            step: 0x4 */
    __IO uint32_t PROC_CTRL_SLOT0_R3[4]; /**< ASRC Datapath Processor Control Slot0 Register3, array offset: 0x90, array
                                            step: 0x4 */
    __IO uint32_t PROC_CTRL_SLOT1_R0[4]; /**< ASRC Datapath Processor Control Slot1 Register0, array offset: 0xA0, array
                                            step: 0x4 */
    __IO uint32_t PROC_CTRL_SLOT1_R1[4]; /**< ASRC Datapath Processor Control SLOT1 Register1, array offset: 0xB0, array
                                            step: 0x4 */
    __IO uint32_t PROC_CTRL_SLOT1_R2[4]; /**< ASRC Datapath Processor Control SLOT1 Register2, array offset: 0xC0, array
                                            step: 0x4 */
    __IO uint32_t PROC_CTRL_SLOT1_R3[4]; /**< ASRC Datapath Processor Control SLOT1 Register3, array offset: 0xD0, array
                                            step: 0x4 */
    __IO uint32_t CTX_OUT_CTRL[4];       /**< ASRC Context Output Control, array offset: 0xE0, array step: 0x4 */
    __IO uint32_t CTRL_OUT_ACCESS[4];    /**< ASRC Control Output Access, array offset: 0xF0, array step: 0x4 */
    __I uint32_t SAMPLE_FIFO_STATUS[4];  /**< ASRC Sample FIFO Status, array offset: 0x100, array step: 0x4 */
    struct
    {                                /* offset: 0x110, array step: 0x8 */
        __IO uint32_t RS_RATIO_LOW;  /**< ASRC Resampling Ratio Low, array offset: 0x110, array step: 0x8 */
        __IO uint32_t RS_RATIO_HIGH; /**< ASRC Resampling Ratio High, array offset: 0x114, array step: 0x8 */
    } RS_RATIO_LOW[4];
    __IO uint32_t RS_UPDATE_CTRL[4]; /**< ASRC Resampling Ratio Update Control, array offset: 0x130, array step: 0x4 */
    __IO uint32_t RS_UPDATE_RATE[4]; /**< ASRC Resampling Ratio Update Rate, array offset: 0x140, array step: 0x4 */
    __IO uint32_t RS_CT_LOW;         /**< ASRC Resampling Center Tap Coefficient Low, offset: 0x150 */
    __IO uint32_t RS_CT_HIGH;        /**< ASRC Resampling Center Tap Coefficient High, offset: 0x154 */
    uint8_t RESERVED_0[8];
    __IO uint32_t PRE_COEFF_FIFO[4];   /**< ASRC Prefilter Coefficient FIFO, array offset: 0x160, array step: 0x4 */
    __O uint32_t CTX_RS_COEFF_MEM;     /**< ASRC Context Resampling Coefficient Memory, offset: 0x170 */
    __IO uint32_t CTX_RS_COEFF_CTRL;   /**< ASRC Context Resampling Coefficient Control, offset: 0x174 */
    __IO uint32_t IRQ_CTRL;            /**< ASRC Interrupt Control, offset: 0x178 */
    __IO uint32_t IRQ_FLAGS;           /**< ASRC Interrupt Status Flags, offset: 0x17C */
    __IO uint32_t CHANNEL_STATUS_0[4]; /**< ASRC Channel Status 0, array offset: 0x180, array step: 0x4 */
    __IO uint32_t CHANNEL_STATUS_1[4]; /**< ASRC Channel Status 1, array offset: 0x190, array step: 0x4 */
    __IO uint32_t CHANNEL_STATUS_2[4]; /**< ASRC Channel Status 2, array offset: 0x1A0, array step: 0x4 */
    __IO uint32_t CHANNEL_STATUS_3[4]; /**< ASRC Channel Status 3, array offset: 0x1B0, array step: 0x4 */
    __IO uint32_t CHANNEL_STATUS_4[4]; /**< ASRC Channel Status 4, array offset: 0x1C0, array step: 0x4 */
    __IO uint32_t CHANNEL_STATUS_5[4]; /**< ASRC Channel Status 5, array offset: 0x1D0, array step: 0x4 */
} ASRC_Type;

/* ----------------------------------------------------------------------------
   -- ASRC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ASRC_Register_Masks ASRC Register Masks
 * @{
 */

/*! @name WRFIFO - ASRC Input Write FIFO */
/*! @{ */
#define ASRC_WRFIFO_CTX_WR_DATA_MASK  (0xFFFFFFFFU)
#define ASRC_WRFIFO_CTX_WR_DATA_SHIFT (0U)
/*! CTX_WR_DATA - Write Data For CTX Input FIFO
 */
#define ASRC_WRFIFO_CTX_WR_DATA(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_WRFIFO_CTX_WR_DATA_SHIFT)) & ASRC_WRFIFO_CTX_WR_DATA_MASK)
/*! @} */

/* The count of ASRC_WRFIFO */
#define ASRC_WRFIFO_COUNT (4U)

/*! @name RDFIFO - ASRC Output Read FIFO */
/*! @{ */
#define ASRC_RDFIFO_CTX_RD_DATA_MASK  (0xFFFFFFFFU)
#define ASRC_RDFIFO_CTX_RD_DATA_SHIFT (0U)
/*! CTX_RD_DATA - Read Data For CTX Output FIFO
 */
#define ASRC_RDFIFO_CTX_RD_DATA(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_RDFIFO_CTX_RD_DATA_SHIFT)) & ASRC_RDFIFO_CTX_RD_DATA_MASK)
/*! @} */

/* The count of ASRC_RDFIFO */
#define ASRC_RDFIFO_COUNT (4U)

/*! @name CTX_CTRL - ASRC Context Control */
/*! @{ */
#define ASRC_CTX_CTRL_NUM_CH_EN_MASK  (0x1FU)
#define ASRC_CTX_CTRL_NUM_CH_EN_SHIFT (0U)
/*! NUM_CH_EN - Number of Channels In Context
 */
#define ASRC_CTX_CTRL_NUM_CH_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_CTRL_NUM_CH_EN_SHIFT)) & ASRC_CTX_CTRL_NUM_CH_EN_MASK)
#define ASRC_CTX_CTRL_SIGN_IN_MASK  (0x40U)
#define ASRC_CTX_CTRL_SIGN_IN_SHIFT (6U)
/*! SIGN_IN - Input Data Sign
 *  0b0..Signed Format
 *  0b1..Unsigned Format
 */
#define ASRC_CTX_CTRL_SIGN_IN(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_CTRL_SIGN_IN_SHIFT)) & ASRC_CTX_CTRL_SIGN_IN_MASK)
#define ASRC_CTX_CTRL_FLOAT_FMT_MASK  (0x80U)
#define ASRC_CTX_CTRL_FLOAT_FMT_SHIFT (7U)
/*! FLOAT_FMT - Context Input Floating Point Format
 *  0b0..Integer Format
 *  0b1..Single Precision Floating Point Format
 */
#define ASRC_CTX_CTRL_FLOAT_FMT(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_CTRL_FLOAT_FMT_SHIFT)) & ASRC_CTX_CTRL_FLOAT_FMT_MASK)
#define ASRC_CTX_CTRL_BITS_PER_SAMPLE_MASK  (0x300U)
#define ASRC_CTX_CTRL_BITS_PER_SAMPLE_SHIFT (8U)
/*! BITS_PER_SAMPLE - Number of Bits Per Audio Sample
 *  0b00..16-bits Per Sample
 *  0b01..20-bits Per Sample
 *  0b10..24-bits Per Sample
 *  0b11..32-bits Per Sample
 */
#define ASRC_CTX_CTRL_BITS_PER_SAMPLE(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_CTRL_BITS_PER_SAMPLE_SHIFT)) & ASRC_CTX_CTRL_BITS_PER_SAMPLE_MASK)
#define ASRC_CTX_CTRL_BIT_REV_MASK  (0x400U)
#define ASRC_CTX_CTRL_BIT_REV_SHIFT (10U)
/*! BIT_REV - Sample Bit Reversal
 *  0b0..Keep Input Ordering
 *  0b1..Reverse Bit Ordering
 */
#define ASRC_CTX_CTRL_BIT_REV(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_CTRL_BIT_REV_SHIFT)) & ASRC_CTX_CTRL_BIT_REV_MASK)
#define ASRC_CTX_CTRL_SAMPLE_POSITION_MASK  (0xF800U)
#define ASRC_CTX_CTRL_SAMPLE_POSITION_SHIFT (11U)
/*! SAMPLE_POSITION - Sample Position
 */
#define ASRC_CTX_CTRL_SAMPLE_POSITION(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_CTRL_SAMPLE_POSITION_SHIFT)) & ASRC_CTX_CTRL_SAMPLE_POSITION_MASK)
#define ASRC_CTX_CTRL_FIFO_WTMK_MASK  (0x7F0000U)
#define ASRC_CTX_CTRL_FIFO_WTMK_SHIFT (16U)
/*! FIFO_WTMK - Context Input FIFO Watermark
 */
#define ASRC_CTX_CTRL_FIFO_WTMK(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_CTRL_FIFO_WTMK_SHIFT)) & ASRC_CTX_CTRL_FIFO_WTMK_MASK)
#define ASRC_CTX_CTRL_FWMDE_MASK  (0x10000000U)
#define ASRC_CTX_CTRL_FWMDE_SHIFT (28U)
/*! FWMDE - FIFO Watermark DMA Enable
 *  0b0..Input DMA Requests Not Enabled for This Context
 *  0b1..Input DMA Requests Enabled for This Context
 */
#define ASRC_CTX_CTRL_FWMDE(x)       (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_CTRL_FWMDE_SHIFT)) & ASRC_CTX_CTRL_FWMDE_MASK)
#define ASRC_CTX_CTRL_RUN_STOP_MASK  (0x20000000U)
#define ASRC_CTX_CTRL_RUN_STOP_SHIFT (29U)
/*! RUN_STOP - Context Run Stop
 */
#define ASRC_CTX_CTRL_RUN_STOP(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_CTRL_RUN_STOP_SHIFT)) & ASRC_CTX_CTRL_RUN_STOP_MASK)
#define ASRC_CTX_CTRL_RUN_EN_MASK  (0x80000000U)
#define ASRC_CTX_CTRL_RUN_EN_SHIFT (31U)
/*! RUN_EN - Context Run Enable
 */
#define ASRC_CTX_CTRL_RUN_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_CTRL_RUN_EN_SHIFT)) & ASRC_CTX_CTRL_RUN_EN_MASK)
/*! @} */

/* The count of ASRC_CTX_CTRL */
#define ASRC_CTX_CTRL_COUNT (4U)

/*! @name CTX_CTRL_EXT1 - ASRC Context Control Extended 1 */
/*! @{ */
#define ASRC_CTX_CTRL_EXT1_PF_INIT_MODE_MASK  (0x3U)
#define ASRC_CTX_CTRL_EXT1_PF_INIT_MODE_SHIFT (0U)
/*! PF_INIT_MODE - Prefilter Initialization Mode
 *  0b00..Do not pre-fill any prefilter taps. The first sample written to the ASRC corresponds to the highest index
 * prefilter filter tap. 0b01..Replicate the first sample to fill the right half of the prefilter. 0b10..Zero fill the
 * right half of the prefilter. 0b11..N/A
 */
#define ASRC_CTX_CTRL_EXT1_PF_INIT_MODE(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_CTRL_EXT1_PF_INIT_MODE_SHIFT)) & ASRC_CTX_CTRL_EXT1_PF_INIT_MODE_MASK)
#define ASRC_CTX_CTRL_EXT1_RS_INIT_MODE_MASK  (0xCU)
#define ASRC_CTX_CTRL_EXT1_RS_INIT_MODE_SHIFT (2U)
/*! RS_INIT_MODE - Resampler Initialization Mode
 *  0b00..Do not pre-fill any resampler taps. The first sample output from the prefilter corresponds to the highest
 * index resampling filter tap. 0b01..Replicate the first prefilter output sample to fill the right half of the
 * resampler. 0b10..Fill the right half of the re-sampler with zeros. 0b11..N/A
 */
#define ASRC_CTX_CTRL_EXT1_RS_INIT_MODE(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_CTRL_EXT1_RS_INIT_MODE_SHIFT)) & ASRC_CTX_CTRL_EXT1_RS_INIT_MODE_MASK)
#define ASRC_CTX_CTRL_EXT1_PF_STOP_MODE_MASK  (0x10U)
#define ASRC_CTX_CTRL_EXT1_PF_STOP_MODE_SHIFT (4U)
/*! PF_STOP_MODE - Pre-Filter Stop Mode
 *  0b0..Replicate the last sample input to the ASRC_WRFIFO for the left-half of the pre-filter on RUN_STOP.
 *  0b1..Zero-Fill the left-half of the pre-filter on RUN_STOP.
 */
#define ASRC_CTX_CTRL_EXT1_PF_STOP_MODE(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_CTRL_EXT1_PF_STOP_MODE_SHIFT)) & ASRC_CTX_CTRL_EXT1_PF_STOP_MODE_MASK)
#define ASRC_CTX_CTRL_EXT1_RS_STOP_MODE_MASK  (0x20U)
#define ASRC_CTX_CTRL_EXT1_RS_STOP_MODE_SHIFT (5U)
/*! RS_STOP_MODE - Resampler Stop Mode
 *  0b0..Replicate the final prefilter output for the left-half of the resampler on RUN_STOP.
 *  0b1..Zero-Fill the left-half of the resampler on RUN_STOP.
 */
#define ASRC_CTX_CTRL_EXT1_RS_STOP_MODE(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_CTRL_EXT1_RS_STOP_MODE_SHIFT)) & ASRC_CTX_CTRL_EXT1_RS_STOP_MODE_MASK)
#define ASRC_CTX_CTRL_EXT1_PF_BYPASS_MODE_MASK  (0x40U)
#define ASRC_CTX_CTRL_EXT1_PF_BYPASS_MODE_SHIFT (6U)
/*! PF_BYPASS_MODE - Prefilter Bypass Mode
 *  0b0..Run the prefilter in normal operation.
 *  0b1..Run the prefilter in bypass mode.
 */
#define ASRC_CTX_CTRL_EXT1_PF_BYPASS_MODE(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_CTRL_EXT1_PF_BYPASS_MODE_SHIFT)) & ASRC_CTX_CTRL_EXT1_PF_BYPASS_MODE_MASK)
#define ASRC_CTX_CTRL_EXT1_RS_BYPASS_MODE_MASK  (0x80U)
#define ASRC_CTX_CTRL_EXT1_RS_BYPASS_MODE_SHIFT (7U)
/*! RS_BYPASS_MODE - Resampler Bypass Mode
 *  0b0..Run the resampler in normal operation.
 *  0b1..Run the resampler in bypass mode.
 */
#define ASRC_CTX_CTRL_EXT1_RS_BYPASS_MODE(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_CTRL_EXT1_RS_BYPASS_MODE_SHIFT)) & ASRC_CTX_CTRL_EXT1_RS_BYPASS_MODE_MASK)
#define ASRC_CTX_CTRL_EXT1_PF_TWO_STAGE_EN_MASK  (0x100U)
#define ASRC_CTX_CTRL_EXT1_PF_TWO_STAGE_EN_SHIFT (8U)
/*! PF_TWO_STAGE_EN - Prefilter Two-Stage Enable
 *  0b0..The pre-filter will run in single stage mode (ST1 only)
 *  0b1..The pre-filter will run in two stage mode (ST1 and ST2)
 */
#define ASRC_CTX_CTRL_EXT1_PF_TWO_STAGE_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_CTRL_EXT1_PF_TWO_STAGE_EN_SHIFT)) & \
     ASRC_CTX_CTRL_EXT1_PF_TWO_STAGE_EN_MASK)
#define ASRC_CTX_CTRL_EXT1_PF_ST1_WB_FLOAT_MASK  (0x200U)
#define ASRC_CTX_CTRL_EXT1_PF_ST1_WB_FLOAT_SHIFT (9U)
/*! PF_ST1_WB_FLOAT - Prefilter Stage1 Writeback Floating Point
 *  0b0..The pre-filter stage1 results are stored in 32-bit integer format.
 *  0b1..The pre-filter stage1 results are stored in 32-bit floating point format.
 */
#define ASRC_CTX_CTRL_EXT1_PF_ST1_WB_FLOAT(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_CTRL_EXT1_PF_ST1_WB_FLOAT_SHIFT)) & \
     ASRC_CTX_CTRL_EXT1_PF_ST1_WB_FLOAT_MASK)
#define ASRC_CTX_CTRL_EXT1_PF_EXPANSION_FACTOR_MASK  (0xFF0000U)
#define ASRC_CTX_CTRL_EXT1_PF_EXPANSION_FACTOR_SHIFT (16U)
/*! PF_EXPANSION_FACTOR - Prefilter IFIR Expansion Factor
 */
#define ASRC_CTX_CTRL_EXT1_PF_EXPANSION_FACTOR(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_CTRL_EXT1_PF_EXPANSION_FACTOR_SHIFT)) & \
     ASRC_CTX_CTRL_EXT1_PF_EXPANSION_FACTOR_MASK)
#define ASRC_CTX_CTRL_EXT1_PF_COEFF_MEM_RST_MASK  (0x1000000U)
#define ASRC_CTX_CTRL_EXT1_PF_COEFF_MEM_RST_SHIFT (24U)
/*! PF_COEFF_MEM_RST - Prefilter Coefficient Memory Reset
 */
#define ASRC_CTX_CTRL_EXT1_PF_COEFF_MEM_RST(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_CTRL_EXT1_PF_COEFF_MEM_RST_SHIFT)) & \
     ASRC_CTX_CTRL_EXT1_PF_COEFF_MEM_RST_MASK)
#define ASRC_CTX_CTRL_EXT1_PF_COEFF_STAGE_WR_MASK  (0x2000000U)
#define ASRC_CTX_CTRL_EXT1_PF_COEFF_STAGE_WR_SHIFT (25U)
/*! PF_COEFF_STAGE_WR - Prefilter Coefficient Write Select
 */
#define ASRC_CTX_CTRL_EXT1_PF_COEFF_STAGE_WR(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_CTRL_EXT1_PF_COEFF_STAGE_WR_SHIFT)) & \
     ASRC_CTX_CTRL_EXT1_PF_COEFF_STAGE_WR_MASK)
/*! @} */

/* The count of ASRC_CTX_CTRL_EXT1 */
#define ASRC_CTX_CTRL_EXT1_COUNT (4U)

/*! @name CTX_CTRL_EXT2 - ASRC Context Control Extended 2 */
/*! @{ */
#define ASRC_CTX_CTRL_EXT2_ST1_NUM_TAPS_MASK  (0x1FFU)
#define ASRC_CTX_CTRL_EXT2_ST1_NUM_TAPS_SHIFT (0U)
/*! ST1_NUM_TAPS - Prefilter Stage1 Number of Taps
 */
#define ASRC_CTX_CTRL_EXT2_ST1_NUM_TAPS(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_CTRL_EXT2_ST1_NUM_TAPS_SHIFT)) & ASRC_CTX_CTRL_EXT2_ST1_NUM_TAPS_MASK)
#define ASRC_CTX_CTRL_EXT2_ST2_NUM_TAPS_MASK  (0x1FF0000U)
#define ASRC_CTX_CTRL_EXT2_ST2_NUM_TAPS_SHIFT (16U)
/*! ST2_NUM_TAPS - Prefilter Stage2 Number of Taps
 */
#define ASRC_CTX_CTRL_EXT2_ST2_NUM_TAPS(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_CTRL_EXT2_ST2_NUM_TAPS_SHIFT)) & ASRC_CTX_CTRL_EXT2_ST2_NUM_TAPS_MASK)
/*! @} */

/* The count of ASRC_CTX_CTRL_EXT2 */
#define ASRC_CTX_CTRL_EXT2_COUNT (4U)

/*! @name CTRL_IN_ACCESS - ASRC Control Input Access */
/*! @{ */
#define ASRC_CTRL_IN_ACCESS_ACCESS_LENGTH_MASK  (0x3FU)
#define ASRC_CTRL_IN_ACCESS_ACCESS_LENGTH_SHIFT (0U)
/*! ACCESS_LENGTH - Number Of Channels Per Source
 */
#define ASRC_CTRL_IN_ACCESS_ACCESS_LENGTH(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTRL_IN_ACCESS_ACCESS_LENGTH_SHIFT)) & ASRC_CTRL_IN_ACCESS_ACCESS_LENGTH_MASK)
#define ASRC_CTRL_IN_ACCESS_GROUP_LENGTH_MASK  (0x3F00U)
#define ASRC_CTRL_IN_ACCESS_GROUP_LENGTH_SHIFT (8U)
/*! GROUP_LENGTH - Number of Channels in a Context
 */
#define ASRC_CTRL_IN_ACCESS_GROUP_LENGTH(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTRL_IN_ACCESS_GROUP_LENGTH_SHIFT)) & ASRC_CTRL_IN_ACCESS_GROUP_LENGTH_MASK)
#define ASRC_CTRL_IN_ACCESS_ITERATIONS_MASK  (0x3F0000U)
#define ASRC_CTRL_IN_ACCESS_ITERATIONS_SHIFT (16U)
/*! ITERATIONS - Number of Sequential Fetches Per Source
 */
#define ASRC_CTRL_IN_ACCESS_ITERATIONS(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTRL_IN_ACCESS_ITERATIONS_SHIFT)) & ASRC_CTRL_IN_ACCESS_ITERATIONS_MASK)
/*! @} */

/* The count of ASRC_CTRL_IN_ACCESS */
#define ASRC_CTRL_IN_ACCESS_COUNT (4U)

/*! @name PROC_CTRL_SLOT0_R0 - ASRC Datapath Processor Control Slot0 Register0 */
/*! @{ */
#define ASRC_PROC_CTRL_SLOT0_R0_SLOT0_EN_MASK  (0x1U)
#define ASRC_PROC_CTRL_SLOT0_R0_SLOT0_EN_SHIFT (0U)
/*! SLOT0_EN - SLOT0 Enable
 *  0b0..Context SLOT0 is disabled
 *  0b1..Context SLOT0 is enabled
 */
#define ASRC_PROC_CTRL_SLOT0_R0_SLOT0_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_PROC_CTRL_SLOT0_R0_SLOT0_EN_SHIFT)) & ASRC_PROC_CTRL_SLOT0_R0_SLOT0_EN_MASK)
#define ASRC_PROC_CTRL_SLOT0_R0_SLOT0_CTX_NUM_MASK  (0x6U)
#define ASRC_PROC_CTRL_SLOT0_R0_SLOT0_CTX_NUM_SHIFT (1U)
/*! SLOT0_CTX_NUM - Context SLOT0 Selection
 */
#define ASRC_PROC_CTRL_SLOT0_R0_SLOT0_CTX_NUM(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_PROC_CTRL_SLOT0_R0_SLOT0_CTX_NUM_SHIFT)) & \
     ASRC_PROC_CTRL_SLOT0_R0_SLOT0_CTX_NUM_MASK)
#define ASRC_PROC_CTRL_SLOT0_R0_SLOT0_NUM_CH_MASK  (0x1F00U)
#define ASRC_PROC_CTRL_SLOT0_R0_SLOT0_NUM_CH_SHIFT (8U)
/*! SLOT0_NUM_CH - SLOT0 Number of Channels
 *  0b00000..Context SLOT0 owns 1 of 8 channels
 *  0b00001..Context SLOT0 owns 2 of 8 channels
 *  0b00010..Context SLOT0 owns 3 of 8 channels
 *  0b00011-0b00111..Context SLOT0 owns N of 8 channels
 */
#define ASRC_PROC_CTRL_SLOT0_R0_SLOT0_NUM_CH(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_PROC_CTRL_SLOT0_R0_SLOT0_NUM_CH_SHIFT)) & \
     ASRC_PROC_CTRL_SLOT0_R0_SLOT0_NUM_CH_MASK)
#define ASRC_PROC_CTRL_SLOT0_R0_SLOT0_MIN_CH_MASK  (0x1F0000U)
#define ASRC_PROC_CTRL_SLOT0_R0_SLOT0_MIN_CH_SHIFT (16U)
/*! SLOT0_MIN_CH - SLOT0 Minimum Global Channel Number
 */
#define ASRC_PROC_CTRL_SLOT0_R0_SLOT0_MIN_CH(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_PROC_CTRL_SLOT0_R0_SLOT0_MIN_CH_SHIFT)) & \
     ASRC_PROC_CTRL_SLOT0_R0_SLOT0_MIN_CH_MASK)
#define ASRC_PROC_CTRL_SLOT0_R0_SLOT0_MAX_CH_MASK  (0x1F000000U)
#define ASRC_PROC_CTRL_SLOT0_R0_SLOT0_MAX_CH_SHIFT (24U)
/*! SLOT0_MAX_CH - SLOT0 Maximum Global Channel Number
 */
#define ASRC_PROC_CTRL_SLOT0_R0_SLOT0_MAX_CH(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_PROC_CTRL_SLOT0_R0_SLOT0_MAX_CH_SHIFT)) & \
     ASRC_PROC_CTRL_SLOT0_R0_SLOT0_MAX_CH_MASK)
/*! @} */

/* The count of ASRC_PROC_CTRL_SLOT0_R0 */
#define ASRC_PROC_CTRL_SLOT0_R0_COUNT (4U)

/*! @name PROC_CTRL_SLOT0_R1 - ASRC Datapath Processor Control Slot0 Register1 */
/*! @{ */
#define ASRC_PROC_CTRL_SLOT0_R1_SLOT0_ST1_CHANxEXP_MASK  (0x1FFFU)
#define ASRC_PROC_CTRL_SLOT0_R1_SLOT0_ST1_CHANxEXP_SHIFT (0U)
/*! SLOT0_ST1_CHANxEXP - SLOT0 Stage1 Channels x Expansion Factor
 */
#define ASRC_PROC_CTRL_SLOT0_R1_SLOT0_ST1_CHANxEXP(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_PROC_CTRL_SLOT0_R1_SLOT0_ST1_CHANxEXP_SHIFT)) & \
     ASRC_PROC_CTRL_SLOT0_R1_SLOT0_ST1_CHANxEXP_MASK)
/*! @} */

/* The count of ASRC_PROC_CTRL_SLOT0_R1 */
#define ASRC_PROC_CTRL_SLOT0_R1_COUNT (4U)

/*! @name PROC_CTRL_SLOT0_R2 - ASRC Datapath Processor Control Slot0 Register2 */
/*! @{ */
#define ASRC_PROC_CTRL_SLOT0_R2_SLOT0_ST1_ST_ADDR_MASK  (0x1FFFU)
#define ASRC_PROC_CTRL_SLOT0_R2_SLOT0_ST1_ST_ADDR_SHIFT (0U)
/*! SLOT0_ST1_ST_ADDR - SLOT0 Stage1 Start Address
 */
#define ASRC_PROC_CTRL_SLOT0_R2_SLOT0_ST1_ST_ADDR(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_PROC_CTRL_SLOT0_R2_SLOT0_ST1_ST_ADDR_SHIFT)) & \
     ASRC_PROC_CTRL_SLOT0_R2_SLOT0_ST1_ST_ADDR_MASK)
#define ASRC_PROC_CTRL_SLOT0_R2_SLOT0_ST1_MEM_ALLOC_MASK  (0x1FFF0000U)
#define ASRC_PROC_CTRL_SLOT0_R2_SLOT0_ST1_MEM_ALLOC_SHIFT (16U)
/*! SLOT0_ST1_MEM_ALLOC - SLOT0 Stage1 Memory Allocation
 */
#define ASRC_PROC_CTRL_SLOT0_R2_SLOT0_ST1_MEM_ALLOC(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_PROC_CTRL_SLOT0_R2_SLOT0_ST1_MEM_ALLOC_SHIFT)) & \
     ASRC_PROC_CTRL_SLOT0_R2_SLOT0_ST1_MEM_ALLOC_MASK)
/*! @} */

/* The count of ASRC_PROC_CTRL_SLOT0_R2 */
#define ASRC_PROC_CTRL_SLOT0_R2_COUNT (4U)

/*! @name PROC_CTRL_SLOT0_R3 - ASRC Datapath Processor Control Slot0 Register3 */
/*! @{ */
#define ASRC_PROC_CTRL_SLOT0_R3_SLOT0_ST2_ST_ADDR_MASK  (0x1FFFU)
#define ASRC_PROC_CTRL_SLOT0_R3_SLOT0_ST2_ST_ADDR_SHIFT (0U)
/*! SLOT0_ST2_ST_ADDR - SLOT0 Stage2 Start Address
 */
#define ASRC_PROC_CTRL_SLOT0_R3_SLOT0_ST2_ST_ADDR(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_PROC_CTRL_SLOT0_R3_SLOT0_ST2_ST_ADDR_SHIFT)) & \
     ASRC_PROC_CTRL_SLOT0_R3_SLOT0_ST2_ST_ADDR_MASK)
#define ASRC_PROC_CTRL_SLOT0_R3_SLOT0_ST2_MEM_ALLOC_MASK  (0x1FFF0000U)
#define ASRC_PROC_CTRL_SLOT0_R3_SLOT0_ST2_MEM_ALLOC_SHIFT (16U)
/*! SLOT0_ST2_MEM_ALLOC - SLOT0 Stage2 Memory Allocation
 */
#define ASRC_PROC_CTRL_SLOT0_R3_SLOT0_ST2_MEM_ALLOC(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_PROC_CTRL_SLOT0_R3_SLOT0_ST2_MEM_ALLOC_SHIFT)) & \
     ASRC_PROC_CTRL_SLOT0_R3_SLOT0_ST2_MEM_ALLOC_MASK)
/*! @} */

/* The count of ASRC_PROC_CTRL_SLOT0_R3 */
#define ASRC_PROC_CTRL_SLOT0_R3_COUNT (4U)

/*! @name PROC_CTRL_SLOT1_R0 - ASRC Datapath Processor Control Slot1 Register0 */
/*! @{ */
#define ASRC_PROC_CTRL_SLOT1_R0_SLOT1_EN_MASK  (0x1U)
#define ASRC_PROC_CTRL_SLOT1_R0_SLOT1_EN_SHIFT (0U)
/*! SLOT1_EN - SLOT1 Enable
 *  0b0..Context SLOT1 is disabled
 *  0b1..Context SLOT1 is enabled
 */
#define ASRC_PROC_CTRL_SLOT1_R0_SLOT1_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_PROC_CTRL_SLOT1_R0_SLOT1_EN_SHIFT)) & ASRC_PROC_CTRL_SLOT1_R0_SLOT1_EN_MASK)
#define ASRC_PROC_CTRL_SLOT1_R0_SLOT1_CTX_NUM_MASK  (0x6U)
#define ASRC_PROC_CTRL_SLOT1_R0_SLOT1_CTX_NUM_SHIFT (1U)
/*! SLOT1_CTX_NUM - Context SLOT1 Selection
 */
#define ASRC_PROC_CTRL_SLOT1_R0_SLOT1_CTX_NUM(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_PROC_CTRL_SLOT1_R0_SLOT1_CTX_NUM_SHIFT)) & \
     ASRC_PROC_CTRL_SLOT1_R0_SLOT1_CTX_NUM_MASK)
#define ASRC_PROC_CTRL_SLOT1_R0_SLOT1_NUM_CH_MASK  (0x1F00U)
#define ASRC_PROC_CTRL_SLOT1_R0_SLOT1_NUM_CH_SHIFT (8U)
/*! SLOT1_NUM_CH - SLOT1 Number of Channels
 *  0b00000..Context SLOT1 owns 1 of 8 channels
 *  0b00001..Context SLOT1 owns 2 of 8 channels
 *  0b00010..Context SLOT1 owns 3 of 8 channels
 *  0b00011-0b00111..Context SLOT1 owns N of 8 channels
 */
#define ASRC_PROC_CTRL_SLOT1_R0_SLOT1_NUM_CH(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_PROC_CTRL_SLOT1_R0_SLOT1_NUM_CH_SHIFT)) & \
     ASRC_PROC_CTRL_SLOT1_R0_SLOT1_NUM_CH_MASK)
#define ASRC_PROC_CTRL_SLOT1_R0_SLOT1_MIN_CH_MASK  (0x1F0000U)
#define ASRC_PROC_CTRL_SLOT1_R0_SLOT1_MIN_CH_SHIFT (16U)
/*! SLOT1_MIN_CH - Slot1 Minimum Global Channel Number
 */
#define ASRC_PROC_CTRL_SLOT1_R0_SLOT1_MIN_CH(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_PROC_CTRL_SLOT1_R0_SLOT1_MIN_CH_SHIFT)) & \
     ASRC_PROC_CTRL_SLOT1_R0_SLOT1_MIN_CH_MASK)
#define ASRC_PROC_CTRL_SLOT1_R0_SLOT1_MAX_CH_MASK  (0x1F000000U)
#define ASRC_PROC_CTRL_SLOT1_R0_SLOT1_MAX_CH_SHIFT (24U)
/*! SLOT1_MAX_CH - Slot1 Maximum Global Channel Number
 */
#define ASRC_PROC_CTRL_SLOT1_R0_SLOT1_MAX_CH(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_PROC_CTRL_SLOT1_R0_SLOT1_MAX_CH_SHIFT)) & \
     ASRC_PROC_CTRL_SLOT1_R0_SLOT1_MAX_CH_MASK)
/*! @} */

/* The count of ASRC_PROC_CTRL_SLOT1_R0 */
#define ASRC_PROC_CTRL_SLOT1_R0_COUNT (4U)

/*! @name PROC_CTRL_SLOT1_R1 - ASRC Datapath Processor Control SLOT1 Register1 */
/*! @{ */
#define ASRC_PROC_CTRL_SLOT1_R1_SLOT1_ST1_CHANxEXP_MASK  (0x1FFFU)
#define ASRC_PROC_CTRL_SLOT1_R1_SLOT1_ST1_CHANxEXP_SHIFT (0U)
/*! SLOT1_ST1_CHANxEXP - SLOT1 Stage1 Channels x Expansion Factor
 */
#define ASRC_PROC_CTRL_SLOT1_R1_SLOT1_ST1_CHANxEXP(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_PROC_CTRL_SLOT1_R1_SLOT1_ST1_CHANxEXP_SHIFT)) & \
     ASRC_PROC_CTRL_SLOT1_R1_SLOT1_ST1_CHANxEXP_MASK)
/*! @} */

/* The count of ASRC_PROC_CTRL_SLOT1_R1 */
#define ASRC_PROC_CTRL_SLOT1_R1_COUNT (4U)

/*! @name PROC_CTRL_SLOT1_R2 - ASRC Datapath Processor Control SLOT1 Register2 */
/*! @{ */
#define ASRC_PROC_CTRL_SLOT1_R2_SLOT1_ST1_ST_ADDR_MASK  (0x1FFFU)
#define ASRC_PROC_CTRL_SLOT1_R2_SLOT1_ST1_ST_ADDR_SHIFT (0U)
/*! SLOT1_ST1_ST_ADDR - SLOT1 Stage1 Start Address
 */
#define ASRC_PROC_CTRL_SLOT1_R2_SLOT1_ST1_ST_ADDR(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_PROC_CTRL_SLOT1_R2_SLOT1_ST1_ST_ADDR_SHIFT)) & \
     ASRC_PROC_CTRL_SLOT1_R2_SLOT1_ST1_ST_ADDR_MASK)
#define ASRC_PROC_CTRL_SLOT1_R2_SLOT1_ST1_MEM_ALLOC_MASK  (0x1FFF0000U)
#define ASRC_PROC_CTRL_SLOT1_R2_SLOT1_ST1_MEM_ALLOC_SHIFT (16U)
/*! SLOT1_ST1_MEM_ALLOC - SLOT1 Stage1 Memory Allocation
 */
#define ASRC_PROC_CTRL_SLOT1_R2_SLOT1_ST1_MEM_ALLOC(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_PROC_CTRL_SLOT1_R2_SLOT1_ST1_MEM_ALLOC_SHIFT)) & \
     ASRC_PROC_CTRL_SLOT1_R2_SLOT1_ST1_MEM_ALLOC_MASK)
/*! @} */

/* The count of ASRC_PROC_CTRL_SLOT1_R2 */
#define ASRC_PROC_CTRL_SLOT1_R2_COUNT (4U)

/*! @name PROC_CTRL_SLOT1_R3 - ASRC Datapath Processor Control SLOT1 Register3 */
/*! @{ */
#define ASRC_PROC_CTRL_SLOT1_R3_SLOT1_ST2_ST_ADDR_MASK  (0x1FFFU)
#define ASRC_PROC_CTRL_SLOT1_R3_SLOT1_ST2_ST_ADDR_SHIFT (0U)
/*! SLOT1_ST2_ST_ADDR - SLOT1 Stage2 Start Address
 */
#define ASRC_PROC_CTRL_SLOT1_R3_SLOT1_ST2_ST_ADDR(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_PROC_CTRL_SLOT1_R3_SLOT1_ST2_ST_ADDR_SHIFT)) & \
     ASRC_PROC_CTRL_SLOT1_R3_SLOT1_ST2_ST_ADDR_MASK)
#define ASRC_PROC_CTRL_SLOT1_R3_SLOT1_ST2_MEM_ALLOC_MASK  (0x1FFF0000U)
#define ASRC_PROC_CTRL_SLOT1_R3_SLOT1_ST2_MEM_ALLOC_SHIFT (16U)
/*! SLOT1_ST2_MEM_ALLOC - SLOT1 Stage2 Memory Allocation
 */
#define ASRC_PROC_CTRL_SLOT1_R3_SLOT1_ST2_MEM_ALLOC(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_PROC_CTRL_SLOT1_R3_SLOT1_ST2_MEM_ALLOC_SHIFT)) & \
     ASRC_PROC_CTRL_SLOT1_R3_SLOT1_ST2_MEM_ALLOC_MASK)
/*! @} */

/* The count of ASRC_PROC_CTRL_SLOT1_R3 */
#define ASRC_PROC_CTRL_SLOT1_R3_COUNT (4U)

/*! @name CTX_OUT_CTRL - ASRC Context Output Control */
/*! @{ */
#define ASRC_CTX_OUT_CTRL_DITHER_EN_MASK  (0x1U)
#define ASRC_CTX_OUT_CTRL_DITHER_EN_SHIFT (0U)
/*! DITHER_EN - Output Dither Enable
 */
#define ASRC_CTX_OUT_CTRL_DITHER_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_OUT_CTRL_DITHER_EN_SHIFT)) & ASRC_CTX_OUT_CTRL_DITHER_EN_MASK)
#define ASRC_CTX_OUT_CTRL_IEC_EN_MASK  (0x2U)
#define ASRC_CTX_OUT_CTRL_IEC_EN_SHIFT (1U)
/*! IEC_EN - IEC60958 Bit-Field Insertion Enable
 *  0b0..No Data Insertion Enabled.
 *  0b1..IEC60958 Bit-Field Insertion Enabled.
 */
#define ASRC_CTX_OUT_CTRL_IEC_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_OUT_CTRL_IEC_EN_SHIFT)) & ASRC_CTX_OUT_CTRL_IEC_EN_MASK)
#define ASRC_CTX_OUT_CTRL_IEC_V_DATA_MASK  (0x4U)
#define ASRC_CTX_OUT_CTRL_IEC_V_DATA_SHIFT (2U)
/*! IEC_V_DATA - IEC60958 Validity Flag
 */
#define ASRC_CTX_OUT_CTRL_IEC_V_DATA(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_OUT_CTRL_IEC_V_DATA_SHIFT)) & ASRC_CTX_OUT_CTRL_IEC_V_DATA_MASK)
#define ASRC_CTX_OUT_CTRL_SIGN_OUT_MASK  (0x40U)
#define ASRC_CTX_OUT_CTRL_SIGN_OUT_SHIFT (6U)
/*! SIGN_OUT - Output Data Sign
 *  0b0..Signed Format
 *  0b1..Convert to Unsigned
 */
#define ASRC_CTX_OUT_CTRL_SIGN_OUT(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_OUT_CTRL_SIGN_OUT_SHIFT)) & ASRC_CTX_OUT_CTRL_SIGN_OUT_MASK)
#define ASRC_CTX_OUT_CTRL_FLOAT_FMT_MASK  (0x80U)
#define ASRC_CTX_OUT_CTRL_FLOAT_FMT_SHIFT (7U)
/*! FLOAT_FMT - Context Output Floating Point Format
 *  0b0..Integer Format
 *  0b1..Single Precision Floating Point Format
 */
#define ASRC_CTX_OUT_CTRL_FLOAT_FMT(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_OUT_CTRL_FLOAT_FMT_SHIFT)) & ASRC_CTX_OUT_CTRL_FLOAT_FMT_MASK)
#define ASRC_CTX_OUT_CTRL_BITS_PER_SAMPLE_MASK  (0x300U)
#define ASRC_CTX_OUT_CTRL_BITS_PER_SAMPLE_SHIFT (8U)
/*! BITS_PER_SAMPLE - Number of Bits Per Audio Sample
 *  0b00..16-bits Per Sample
 *  0b01..20-bits Per Sample
 *  0b10..24-bits Per Sample
 *  0b11..32-bits Per Sample
 */
#define ASRC_CTX_OUT_CTRL_BITS_PER_SAMPLE(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_OUT_CTRL_BITS_PER_SAMPLE_SHIFT)) & ASRC_CTX_OUT_CTRL_BITS_PER_SAMPLE_MASK)
#define ASRC_CTX_OUT_CTRL_BIT_REV_MASK  (0x400U)
#define ASRC_CTX_OUT_CTRL_BIT_REV_SHIFT (10U)
/*! BIT_REV - Sample Bit-Reversal
 *  0b0..No change.
 *  0b1..Bit-reverse sample data.
 */
#define ASRC_CTX_OUT_CTRL_BIT_REV(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_OUT_CTRL_BIT_REV_SHIFT)) & ASRC_CTX_OUT_CTRL_BIT_REV_MASK)
#define ASRC_CTX_OUT_CTRL_SAMPLE_POSITION_MASK  (0xF800U)
#define ASRC_CTX_OUT_CTRL_SAMPLE_POSITION_SHIFT (11U)
/*! SAMPLE_POSITION - Sample Position
 */
#define ASRC_CTX_OUT_CTRL_SAMPLE_POSITION(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_OUT_CTRL_SAMPLE_POSITION_SHIFT)) & ASRC_CTX_OUT_CTRL_SAMPLE_POSITION_MASK)
#define ASRC_CTX_OUT_CTRL_FIFO_WTMK_MASK  (0x7F0000U)
#define ASRC_CTX_OUT_CTRL_FIFO_WTMK_SHIFT (16U)
/*! FIFO_WTMK - Context Output FIFO Watermark
 */
#define ASRC_CTX_OUT_CTRL_FIFO_WTMK(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_OUT_CTRL_FIFO_WTMK_SHIFT)) & ASRC_CTX_OUT_CTRL_FIFO_WTMK_MASK)
#define ASRC_CTX_OUT_CTRL_FWMDE_MASK  (0x10000000U)
#define ASRC_CTX_OUT_CTRL_FWMDE_SHIFT (28U)
/*! FWMDE - Output FIFO Watermark DMA Enable
 *  0b0..Output DMA Requests Not Enabled for This Context
 *  0b1..Output DMA Requests Enabled for This Context
 */
#define ASRC_CTX_OUT_CTRL_FWMDE(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_OUT_CTRL_FWMDE_SHIFT)) & ASRC_CTX_OUT_CTRL_FWMDE_MASK)
/*! @} */

/* The count of ASRC_CTX_OUT_CTRL */
#define ASRC_CTX_OUT_CTRL_COUNT (4U)

/*! @name CTRL_OUT_ACCESS - ASRC Control Output Access */
/*! @{ */
#define ASRC_CTRL_OUT_ACCESS_ACCESS_LENGTH_MASK  (0x3FU)
#define ASRC_CTRL_OUT_ACCESS_ACCESS_LENGTH_SHIFT (0U)
/*! ACCESS_LENGTH - Number Of Channels Per Destination
 */
#define ASRC_CTRL_OUT_ACCESS_ACCESS_LENGTH(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTRL_OUT_ACCESS_ACCESS_LENGTH_SHIFT)) & \
     ASRC_CTRL_OUT_ACCESS_ACCESS_LENGTH_MASK)
#define ASRC_CTRL_OUT_ACCESS_GROUP_LENGTH_MASK  (0x3F00U)
#define ASRC_CTRL_OUT_ACCESS_GROUP_LENGTH_SHIFT (8U)
/*! GROUP_LENGTH - Number of Channels in a Context
 */
#define ASRC_CTRL_OUT_ACCESS_GROUP_LENGTH(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTRL_OUT_ACCESS_GROUP_LENGTH_SHIFT)) & ASRC_CTRL_OUT_ACCESS_GROUP_LENGTH_MASK)
#define ASRC_CTRL_OUT_ACCESS_ITERATIONS_MASK  (0x3F0000U)
#define ASRC_CTRL_OUT_ACCESS_ITERATIONS_SHIFT (16U)
/*! ITERATIONS - Number of Sequential Fetches Per Channel Group
 */
#define ASRC_CTRL_OUT_ACCESS_ITERATIONS(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTRL_OUT_ACCESS_ITERATIONS_SHIFT)) & ASRC_CTRL_OUT_ACCESS_ITERATIONS_MASK)
/*! @} */

/* The count of ASRC_CTRL_OUT_ACCESS */
#define ASRC_CTRL_OUT_ACCESS_COUNT (4U)

/*! @name SAMPLE_FIFO_STATUS - ASRC Sample FIFO Status */
/*! @{ */
#define ASRC_SAMPLE_FIFO_STATUS_NUM_SAMPLE_GROUPS_OUT_MASK  (0x7FU)
#define ASRC_SAMPLE_FIFO_STATUS_NUM_SAMPLE_GROUPS_OUT_SHIFT (0U)
/*! NUM_SAMPLE_GROUPS_OUT - Number Of Sample Groups Stored in the output FIFO
 */
#define ASRC_SAMPLE_FIFO_STATUS_NUM_SAMPLE_GROUPS_OUT(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_SAMPLE_FIFO_STATUS_NUM_SAMPLE_GROUPS_OUT_SHIFT)) & \
     ASRC_SAMPLE_FIFO_STATUS_NUM_SAMPLE_GROUPS_OUT_MASK)
#define ASRC_SAMPLE_FIFO_STATUS_OUTFIFO_WTMK_MASK  (0x80U)
#define ASRC_SAMPLE_FIFO_STATUS_OUTFIFO_WTMK_SHIFT (7U)
/*! OUTFIFO_WTMK - Output FIFO Watermark Flag
 */
#define ASRC_SAMPLE_FIFO_STATUS_OUTFIFO_WTMK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_SAMPLE_FIFO_STATUS_OUTFIFO_WTMK_SHIFT)) & \
     ASRC_SAMPLE_FIFO_STATUS_OUTFIFO_WTMK_MASK)
#define ASRC_SAMPLE_FIFO_STATUS_NUM_SAMPLE_GROUPS_IN_MASK  (0x7F0000U)
#define ASRC_SAMPLE_FIFO_STATUS_NUM_SAMPLE_GROUPS_IN_SHIFT (16U)
/*! NUM_SAMPLE_GROUPS_IN - Number Of Sample Groups Stored in Input FIFO
 */
#define ASRC_SAMPLE_FIFO_STATUS_NUM_SAMPLE_GROUPS_IN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_SAMPLE_FIFO_STATUS_NUM_SAMPLE_GROUPS_IN_SHIFT)) & \
     ASRC_SAMPLE_FIFO_STATUS_NUM_SAMPLE_GROUPS_IN_MASK)
#define ASRC_SAMPLE_FIFO_STATUS_INFIFO_WTMK_MASK  (0x800000U)
#define ASRC_SAMPLE_FIFO_STATUS_INFIFO_WTMK_SHIFT (23U)
/*! INFIFO_WTMK - Input FIFO Watermark Flag
 */
#define ASRC_SAMPLE_FIFO_STATUS_INFIFO_WTMK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_SAMPLE_FIFO_STATUS_INFIFO_WTMK_SHIFT)) & \
     ASRC_SAMPLE_FIFO_STATUS_INFIFO_WTMK_MASK)
/*! @} */

/* The count of ASRC_SAMPLE_FIFO_STATUS */
#define ASRC_SAMPLE_FIFO_STATUS_COUNT (4U)

/*! @name RS_RATIO_LOW - ASRC Resampling Ratio Low */
/*! @{ */
#define ASRC_RS_RATIO_LOW_RS_RATIO_LOW_MASK  (0xFFFFFFFFU)
#define ASRC_RS_RATIO_LOW_RS_RATIO_LOW_SHIFT (0U)
/*! RS_RATIO_LOW - Resampling Ratio Low
 */
#define ASRC_RS_RATIO_LOW_RS_RATIO_LOW(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_RS_RATIO_LOW_RS_RATIO_LOW_SHIFT)) & ASRC_RS_RATIO_LOW_RS_RATIO_LOW_MASK)
/*! @} */

/* The count of ASRC_RS_RATIO_LOW */
#define ASRC_RS_RATIO_LOW_COUNT (4U)

/*! @name RS_RATIO_HIGH - ASRC Resampling Ratio High */
/*! @{ */
#define ASRC_RS_RATIO_HIGH_RS_RATIO_HIGH_MASK  (0xFFFU)
#define ASRC_RS_RATIO_HIGH_RS_RATIO_HIGH_SHIFT (0U)
/*! RS_RATIO_HIGH - Resampling Ratio High
 */
#define ASRC_RS_RATIO_HIGH_RS_RATIO_HIGH(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_RS_RATIO_HIGH_RS_RATIO_HIGH_SHIFT)) & ASRC_RS_RATIO_HIGH_RS_RATIO_HIGH_MASK)
#define ASRC_RS_RATIO_HIGH_RS_RATIO_VLD_MASK  (0x80000000U)
#define ASRC_RS_RATIO_HIGH_RS_RATIO_VLD_SHIFT (31U)
/*! RS_RATIO_VLD - Resampling Ratio Valid
 */
#define ASRC_RS_RATIO_HIGH_RS_RATIO_VLD(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_RS_RATIO_HIGH_RS_RATIO_VLD_SHIFT)) & ASRC_RS_RATIO_HIGH_RS_RATIO_VLD_MASK)
/*! @} */

/* The count of ASRC_RS_RATIO_HIGH */
#define ASRC_RS_RATIO_HIGH_COUNT (4U)

/*! @name RS_UPDATE_CTRL - ASRC Resampling Ratio Update Control */
/*! @{ */
#define ASRC_RS_UPDATE_CTRL_RS_RATIO_MOD_MASK  (0xFFFFFFFFU)
#define ASRC_RS_UPDATE_CTRL_RS_RATIO_MOD_SHIFT (0U)
/*! RS_RATIO_MOD - Resampling Ratio Modifier
 */
#define ASRC_RS_UPDATE_CTRL_RS_RATIO_MOD(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_RS_UPDATE_CTRL_RS_RATIO_MOD_SHIFT)) & ASRC_RS_UPDATE_CTRL_RS_RATIO_MOD_MASK)
/*! @} */

/* The count of ASRC_RS_UPDATE_CTRL */
#define ASRC_RS_UPDATE_CTRL_COUNT (4U)

/*! @name RS_UPDATE_RATE - ASRC Resampling Ratio Update Rate */
/*! @{ */
#define ASRC_RS_UPDATE_RATE_RS_RATIO_RAMP_RATE_MASK  (0x7FFFFFFFU)
#define ASRC_RS_UPDATE_RATE_RS_RATIO_RAMP_RATE_SHIFT (0U)
/*! RS_RATIO_RAMP_RATE - Resampling Ratio Ramp Rate
 */
#define ASRC_RS_UPDATE_RATE_RS_RATIO_RAMP_RATE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_RS_UPDATE_RATE_RS_RATIO_RAMP_RATE_SHIFT)) & \
     ASRC_RS_UPDATE_RATE_RS_RATIO_RAMP_RATE_MASK)
/*! @} */

/* The count of ASRC_RS_UPDATE_RATE */
#define ASRC_RS_UPDATE_RATE_COUNT (4U)

/*! @name RS_CT_LOW - ASRC Resampling Center Tap Coefficient Low */
/*! @{ */
#define ASRC_RS_CT_LOW_RS_CT_LOW_MASK  (0xFFFFFFFFU)
#define ASRC_RS_CT_LOW_RS_CT_LOW_SHIFT (0U)
/*! RS_CT_LOW - Resampling Center Tap Coefficient LSBs
 */
#define ASRC_RS_CT_LOW_RS_CT_LOW(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_RS_CT_LOW_RS_CT_LOW_SHIFT)) & ASRC_RS_CT_LOW_RS_CT_LOW_MASK)
/*! @} */

/*! @name RS_CT_HIGH - ASRC Resampling Center Tap Coefficient High */
/*! @{ */
#define ASRC_RS_CT_HIGH_RS_CT_HIGH_MASK  (0xFFFFFFFFU)
#define ASRC_RS_CT_HIGH_RS_CT_HIGH_SHIFT (0U)
/*! RS_CT_HIGH - Resampling Center Tap Coefficient MSBs
 */
#define ASRC_RS_CT_HIGH_RS_CT_HIGH(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_RS_CT_HIGH_RS_CT_HIGH_SHIFT)) & ASRC_RS_CT_HIGH_RS_CT_HIGH_MASK)
/*! @} */

/*! @name PRE_COEFF_FIFO - ASRC Prefilter Coefficient FIFO */
/*! @{ */
#define ASRC_PRE_COEFF_FIFO_COEFF_DATA_MASK  (0xFFFFFFFFU)
#define ASRC_PRE_COEFF_FIFO_COEFF_DATA_SHIFT (0U)
/*! COEFF_DATA - Coefficient Value For Prefilter
 */
#define ASRC_PRE_COEFF_FIFO_COEFF_DATA(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_PRE_COEFF_FIFO_COEFF_DATA_SHIFT)) & ASRC_PRE_COEFF_FIFO_COEFF_DATA_MASK)
/*! @} */

/* The count of ASRC_PRE_COEFF_FIFO */
#define ASRC_PRE_COEFF_FIFO_COUNT (4U)

/*! @name CTX_RS_COEFF_MEM - ASRC Context Resampling Coefficient Memory */
/*! @{ */
#define ASRC_CTX_RS_COEFF_MEM_RS_COEFF_WDATA_MASK  (0xFFFFFFFFU)
#define ASRC_CTX_RS_COEFF_MEM_RS_COEFF_WDATA_SHIFT (0U)
/*! RS_COEFF_WDATA - Resampling Coefficient Write Data
 */
#define ASRC_CTX_RS_COEFF_MEM_RS_COEFF_WDATA(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_RS_COEFF_MEM_RS_COEFF_WDATA_SHIFT)) & \
     ASRC_CTX_RS_COEFF_MEM_RS_COEFF_WDATA_MASK)
/*! @} */

/*! @name CTX_RS_COEFF_CTRL - ASRC Context Resampling Coefficient Control */
/*! @{ */
#define ASRC_CTX_RS_COEFF_CTRL_RS_COEFF_PTR_RST_MASK  (0x1U)
#define ASRC_CTX_RS_COEFF_CTRL_RS_COEFF_PTR_RST_SHIFT (0U)
/*! RS_COEFF_PTR_RST - Resampling Coefficient Write Pointer Reset
 */
#define ASRC_CTX_RS_COEFF_CTRL_RS_COEFF_PTR_RST(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_RS_COEFF_CTRL_RS_COEFF_PTR_RST_SHIFT)) & \
     ASRC_CTX_RS_COEFF_CTRL_RS_COEFF_PTR_RST_MASK)
#define ASRC_CTX_RS_COEFF_CTRL_NUM_RES_TAPS_MASK  (0x6U)
#define ASRC_CTX_RS_COEFF_CTRL_NUM_RES_TAPS_SHIFT (1U)
/*! NUM_RES_TAPS - Number of Resampling Coefficient Taps
 *  0b00..32-Tap Resampling Filter
 *  0b01..64-Tap Resampling Filter
 *  0b10..128-Tap Resampling Filter
 *  0b11..N/A
 */
#define ASRC_CTX_RS_COEFF_CTRL_NUM_RES_TAPS(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_RS_COEFF_CTRL_NUM_RES_TAPS_SHIFT)) & \
     ASRC_CTX_RS_COEFF_CTRL_NUM_RES_TAPS_MASK)
#define ASRC_CTX_RS_COEFF_CTRL_RS_COEFF_ADDR_MASK  (0x7FF0000U)
#define ASRC_CTX_RS_COEFF_CTRL_RS_COEFF_ADDR_SHIFT (16U)
/*! RS_COEFF_ADDR - Resampling Coefficient Address
 */
#define ASRC_CTX_RS_COEFF_CTRL_RS_COEFF_ADDR(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CTX_RS_COEFF_CTRL_RS_COEFF_ADDR_SHIFT)) & \
     ASRC_CTX_RS_COEFF_CTRL_RS_COEFF_ADDR_MASK)
/*! @} */

/*! @name IRQ_CTRL - ASRC Interrupt Control */
/*! @{ */
#define ASRC_IRQ_CTRL_INFIFO_OVF_MASK_MASK  (0xFU)
#define ASRC_IRQ_CTRL_INFIFO_OVF_MASK_SHIFT (0U)
/*! INFIFO_OVF_MASK - ASRC Input FIFO Overflow Mask
 *  0b0000..The INFIFO_OVF interrupt is enabled for Context 0 to 3.
 *  0b0001..The INFIFO_OVF interrupt is disabled for Context 0 and enabled for Context 1 to 3.
 *  0b0010..The INFIFO_OVF interrupt is disabled for Context 1 and enabled for Context 0, 2, and 3.
 *  0b0011-0b1110..The INFIFO_OVF interrupt is enabled for any context with a 1'b0 bit field.
 *  0b1111..The INFIFO_OVF interrupt is disabled for Context 0 to 3.
 */
#define ASRC_IRQ_CTRL_INFIFO_OVF_MASK(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_IRQ_CTRL_INFIFO_OVF_MASK_SHIFT)) & ASRC_IRQ_CTRL_INFIFO_OVF_MASK_MASK)
#define ASRC_IRQ_CTRL_OUTFIFO_EMPTY_RD_MASK_MASK  (0xF0U)
#define ASRC_IRQ_CTRL_OUTFIFO_EMPTY_RD_MASK_SHIFT (4U)
/*! OUTFIFO_EMPTY_RD_MASK - ASRC Output FIFO Empty Read Mask
 *  0b0000..The OUTFIFO_EMPTY_RD interrupt is enabled for Context 0 to 3.
 *  0b0001..The OUTFIFO_EMPTY_RD interrupt is disabled for Context 0 and enabled for Context 1 to 3.
 *  0b0010..The OUTFIFO_EMPTY_RD interrupt is disabled for Context 1 and enabled for Context 0, 2, and 3.
 *  0b0011-0b1110..The OUTFIFO_EMPTY_RD interrupt is enabled for any context with a 1'b0 bit field.
 *  0b1111..The OUTFIFO_EMPTY_RD interrupt is disabled for Context 0 to 3.
 */
#define ASRC_IRQ_CTRL_OUTFIFO_EMPTY_RD_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << ASRC_IRQ_CTRL_OUTFIFO_EMPTY_RD_MASK_SHIFT)) & \
     ASRC_IRQ_CTRL_OUTFIFO_EMPTY_RD_MASK_MASK)
#define ASRC_IRQ_CTRL_RUN_STOP_DONE_MASK_MASK  (0xF00U)
#define ASRC_IRQ_CTRL_RUN_STOP_DONE_MASK_SHIFT (8U)
/*! RUN_STOP_DONE_MASK - ASRC RUN STOP DONE MASK
 *  0b0000..The RUN_STOP_DONE interrupt is enabled for Context 0 to 3.
 *  0b0001..The RUN_STOP_DONE interrupt is disabled for Context 0 and enabled for Context 1 to 3.
 *  0b0010..The RUN_STOP_DONE interrupt is disabled for Context 1 and enabled for Context 0, 2, and 3.
 *  0b0011-0b1110..The RUN_STOP_DONE interrupt is enabled for any context with a 1'b0 bit field.
 *  0b1111..The RUN_STOP_DONE interrupt is disabled for Context 0 to 3.
 */
#define ASRC_IRQ_CTRL_RUN_STOP_DONE_MASK(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_IRQ_CTRL_RUN_STOP_DONE_MASK_SHIFT)) & ASRC_IRQ_CTRL_RUN_STOP_DONE_MASK_MASK)
/*! @} */

/*! @name IRQ_FLAGS - ASRC Interrupt Status Flags */
/*! @{ */
#define ASRC_IRQ_FLAGS_INFIFO_OVF_MASK  (0xFU)
#define ASRC_IRQ_FLAGS_INFIFO_OVF_SHIFT (0U)
/*! INFIFO_OVF - ASRC Input FIFO Overflow Flag
 *  0b0000..No INFIFO_OVF errors have been recorded.
 *  0b0001..The ASRC_WRFIFO0 has overflown.
 *  0b0010..The ASRC_WRFIFO1 has overflown.
 *  0b0011-0b1110..The ASRC_WRFIFOn has overflown. Where n = any bit position set to 0b1.
 *  0b1111..ASRC_WRFIFO0, ASRC_WRFIFO1, ASRC_WRFIFO2, and ASRC_WRFIFO3 have overflown.
 */
#define ASRC_IRQ_FLAGS_INFIFO_OVF(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_IRQ_FLAGS_INFIFO_OVF_SHIFT)) & ASRC_IRQ_FLAGS_INFIFO_OVF_MASK)
#define ASRC_IRQ_FLAGS_OUTFIFO_EMPTY_RD_MASK  (0xF0U)
#define ASRC_IRQ_FLAGS_OUTFIFO_EMPTY_RD_SHIFT (4U)
/*! OUTFIFO_EMPTY_RD - ASRC Output FIFO Empty Read Flag
 *  0b0000..No reads have been requested from an empty ASRC_RDFIFO.
 *  0b0001..A read has been requested from ASRC_RDFIFO0 when it was empty.
 *  0b0010..A read has been requested from ASRC_RDFIFO1 when it was empty.
 *  0b0011-0b1110..A read has been requested from ASRC_RDFIFOn when it was empty. n = any bit position with a 0b1.
 *  0b1111..A read has been requested from ASRC_RDFIFO0, ASRC_RDFIFO1, ASRC_RDFIFO2, and ASRC_RDFIFO3 while empty.
 */
#define ASRC_IRQ_FLAGS_OUTFIFO_EMPTY_RD(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_IRQ_FLAGS_OUTFIFO_EMPTY_RD_SHIFT)) & ASRC_IRQ_FLAGS_OUTFIFO_EMPTY_RD_MASK)
#define ASRC_IRQ_FLAGS_RUN_STOP_DONE_MASK  (0xF00U)
#define ASRC_IRQ_FLAGS_RUN_STOP_DONE_SHIFT (8U)
/*! RUN_STOP_DONE - ASRC RUN STOP DONE FLAG
 *  0b0000..No RUN_STOP operations have been completed.
 *  0b0001..The RUN_STOP operation for Context 0 has completed.
 *  0b0010..The RUN_STOP operation for Context 1 has completed.
 *  0b0011-0b1110..The RUN_STOP operation has completed for any context with a 1'b1 bit field.
 *  0b1111..The RUN_STOP operation has completed for Context 0 to 3.
 */
#define ASRC_IRQ_FLAGS_RUN_STOP_DONE(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_IRQ_FLAGS_RUN_STOP_DONE_SHIFT)) & ASRC_IRQ_FLAGS_RUN_STOP_DONE_MASK)
/*! @} */

/*! @name CHANNEL_STATUS_0 - ASRC Channel Status 0 */
/*! @{ */
#define ASRC_CHANNEL_STATUS_0_CHN_STAT_MASK  (0xFFFFFFFFU)
#define ASRC_CHANNEL_STATUS_0_CHN_STAT_SHIFT (0U)
/*! CHN_STAT - Channel Status Data
 */
#define ASRC_CHANNEL_STATUS_0_CHN_STAT(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CHANNEL_STATUS_0_CHN_STAT_SHIFT)) & ASRC_CHANNEL_STATUS_0_CHN_STAT_MASK)
/*! @} */

/* The count of ASRC_CHANNEL_STATUS_0 */
#define ASRC_CHANNEL_STATUS_0_COUNT (4U)

/*! @name CHANNEL_STATUS_1 - ASRC Channel Status 1 */
/*! @{ */
#define ASRC_CHANNEL_STATUS_1_CHN_STAT_MASK  (0xFFFFFFFFU)
#define ASRC_CHANNEL_STATUS_1_CHN_STAT_SHIFT (0U)
/*! CHN_STAT - Channel Status Data
 */
#define ASRC_CHANNEL_STATUS_1_CHN_STAT(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CHANNEL_STATUS_1_CHN_STAT_SHIFT)) & ASRC_CHANNEL_STATUS_1_CHN_STAT_MASK)
/*! @} */

/* The count of ASRC_CHANNEL_STATUS_1 */
#define ASRC_CHANNEL_STATUS_1_COUNT (4U)

/*! @name CHANNEL_STATUS_2 - ASRC Channel Status 2 */
/*! @{ */
#define ASRC_CHANNEL_STATUS_2_CHN_STAT_MASK  (0xFFFFFFFFU)
#define ASRC_CHANNEL_STATUS_2_CHN_STAT_SHIFT (0U)
/*! CHN_STAT - Channel Status Data
 */
#define ASRC_CHANNEL_STATUS_2_CHN_STAT(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CHANNEL_STATUS_2_CHN_STAT_SHIFT)) & ASRC_CHANNEL_STATUS_2_CHN_STAT_MASK)
/*! @} */

/* The count of ASRC_CHANNEL_STATUS_2 */
#define ASRC_CHANNEL_STATUS_2_COUNT (4U)

/*! @name CHANNEL_STATUS_3 - ASRC Channel Status 3 */
/*! @{ */
#define ASRC_CHANNEL_STATUS_3_CHN_STAT_MASK  (0xFFFFFFFFU)
#define ASRC_CHANNEL_STATUS_3_CHN_STAT_SHIFT (0U)
/*! CHN_STAT - Channel Status Data
 */
#define ASRC_CHANNEL_STATUS_3_CHN_STAT(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CHANNEL_STATUS_3_CHN_STAT_SHIFT)) & ASRC_CHANNEL_STATUS_3_CHN_STAT_MASK)
/*! @} */

/* The count of ASRC_CHANNEL_STATUS_3 */
#define ASRC_CHANNEL_STATUS_3_COUNT (4U)

/*! @name CHANNEL_STATUS_4 - ASRC Channel Status 4 */
/*! @{ */
#define ASRC_CHANNEL_STATUS_4_CHN_STAT_MASK  (0xFFFFFFFFU)
#define ASRC_CHANNEL_STATUS_4_CHN_STAT_SHIFT (0U)
/*! CHN_STAT - Channel Status Data
 */
#define ASRC_CHANNEL_STATUS_4_CHN_STAT(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CHANNEL_STATUS_4_CHN_STAT_SHIFT)) & ASRC_CHANNEL_STATUS_4_CHN_STAT_MASK)
/*! @} */

/* The count of ASRC_CHANNEL_STATUS_4 */
#define ASRC_CHANNEL_STATUS_4_COUNT (4U)

/*! @name CHANNEL_STATUS_5 - ASRC Channel Status 5 */
/*! @{ */
#define ASRC_CHANNEL_STATUS_5_CHN_STAT_MASK  (0xFFFFFFFFU)
#define ASRC_CHANNEL_STATUS_5_CHN_STAT_SHIFT (0U)
/*! CHN_STAT - Channel Status Data
 */
#define ASRC_CHANNEL_STATUS_5_CHN_STAT(x) \
    (((uint32_t)(((uint32_t)(x)) << ASRC_CHANNEL_STATUS_5_CHN_STAT_SHIFT)) & ASRC_CHANNEL_STATUS_5_CHN_STAT_MASK)
/*! @} */

/* The count of ASRC_CHANNEL_STATUS_5 */
#define ASRC_CHANNEL_STATUS_5_COUNT (4U)

/*!
 * @}
 */ /* end of group ASRC_Register_Masks */

/* ASRC - Peripheral instance base addresses */
/** Peripheral ASRC base address */
#define ASRC_BASE (0x30C90000u)
/** Peripheral ASRC base pointer */
#define ASRC ((ASRC_Type *)ASRC_BASE)
/** Array initializer of ASRC peripheral base addresses */
#define ASRC_BASE_ADDRS \
    {                   \
        ASRC_BASE       \
    }
/** Array initializer of ASRC peripheral base pointers */
#define ASRC_BASE_PTRS \
    {                  \
        ASRC           \
    }

/*!
 * @}
 */ /* end of group ASRC_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- AUDIOMIX Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AUDIOMIX_Peripheral_Access_Layer AUDIOMIX Peripheral Access Layer
 * @{
 */

/** AUDIOMIX - Register Layout Typedef */
typedef struct
{
    __IO uint32_t CLKEN0; /**< IP Clock Enable Control Register 0, offset: 0x0 */
    __IO uint32_t CLKEN1; /**< IP Clock Enable Control Register 1, offset: 0x4 */
    uint8_t RESERVED_0[248];
    __I uint32_t AUDIODSP_REG0;  /**< AudioDSP EXPSTATE Register, offset: 0x100 */
    __IO uint32_t AUDIODSP_REG1; /**< AudioDSP IMPWIRE Register, offset: 0x104 */
    __IO uint32_t AUDIODSP_REG2; /**< AudioDSP XOCDMODE Register, offset: 0x108 */
    __IO uint32_t AUDIODSP_REG3; /**< AudioDSP PID Register, offset: 0x10C */
    uint8_t RESERVED_1[240];
    __IO uint32_t EARC; /**< EARC Control Register, offset: 0x200 */
    uint8_t RESERVED_2[252];
    __IO uint32_t SAI1_MCLK_SEL; /**< SAI1 MCLK SELECT Register, offset: 0x300 */
    __IO uint32_t SAI2_MCLK_SEL; /**< SAI2 MCLK SELECT Register, offset: 0x304 */
    __IO uint32_t SAI3_MCLK_SEL; /**< SAI3 MCLK SELECT Register, offset: 0x308 */
    __IO uint32_t SAI5_MCLK_SEL; /**< SAI5 MCLK SELECT Register, offset: 0x30C */
    __IO uint32_t SAI6_MCLK_SEL; /**< SAI6 MCLK SELECT Register, offset: 0x310 */
    __IO uint32_t SAI7_MCLK_SEL; /**< SAI7 MCLK SELECT Register, offset: 0x314 */
    __IO uint32_t PDM_CLK;       /**< PDM Root Clock Select Register, offset: 0x318 */
    uint8_t RESERVED_3[228];
    __IO uint32_t SAI_PLL_GNRL_CTL;  /**< SAI PLL General control Register, offset: 0x400 */
    __IO uint32_t SAI_PLL_FDIV_CTL0; /**< SAI PLL Frequency Divider control Register, offset: 0x404 */
    __IO uint32_t SAI_PLL_FDIV_CTL1; /**< SAI PLL DSM value Register, offset: 0x408 */
    __IO uint32_t SAI_PLL_SSCG_CTL;  /**< SAI PLL SSCG control Register, offset: 0x40C */
    __IO uint32_t SAI_PLL_MNIT_CTL;  /**< SAI PLL SSCG control Register, offset: 0x410 */
    uint8_t RESERVED_4[236];
    __IO uint32_t AUDIO_EXT_ADDR;  /**< AUDIOMIX Extra Addr Bits Register, offset: 0x500 */
    __IO uint32_t IPG_LP_CTRL;     /**< IPG Low Power Control Register, offset: 0x504 */
    __IO uint32_t AUDIO_AXI_LIMIT; /**< AUDIOMIX AXI LIMIT CTRL Register, offset: 0x508 */
} AUDIOMIX_Type;

/* ----------------------------------------------------------------------------
   -- AUDIOMIX Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AUDIOMIX_Register_Masks AUDIOMIX Register Masks
 * @{
 */

/*! @name CLKEN0 - IP Clock Enable Control Register 0 */
/*! @{ */
#define AUDIOMIX_CLKEN0_SAI1_MASK  (0x1U)
#define AUDIOMIX_CLKEN0_SAI1_SHIFT (0U)
/*! SAI1 - SAI1 clock enable
 *  0b1..SAI1 sai clock enable
 *  0b0..SAI1 sai clock disable
 */
#define AUDIOMIX_CLKEN0_SAI1(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN0_SAI1_SHIFT)) & AUDIOMIX_CLKEN0_SAI1_MASK)
#define AUDIOMIX_CLKEN0_SAI1_MCLK1_MASK  (0x2U)
#define AUDIOMIX_CLKEN0_SAI1_MCLK1_SHIFT (1U)
/*! SAI1_MCLK1 - SAI1 mclk1 clock enable
 */
#define AUDIOMIX_CLKEN0_SAI1_MCLK1(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN0_SAI1_MCLK1_SHIFT)) & AUDIOMIX_CLKEN0_SAI1_MCLK1_MASK)
#define AUDIOMIX_CLKEN0_SAI1_MCLK2_MASK  (0x4U)
#define AUDIOMIX_CLKEN0_SAI1_MCLK2_SHIFT (2U)
/*! SAI1_MCLK2 - SAI1 mclk2 clock enable
 */
#define AUDIOMIX_CLKEN0_SAI1_MCLK2(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN0_SAI1_MCLK2_SHIFT)) & AUDIOMIX_CLKEN0_SAI1_MCLK2_MASK)
#define AUDIOMIX_CLKEN0_SAI1_MCLK3_MASK  (0x8U)
#define AUDIOMIX_CLKEN0_SAI1_MCLK3_SHIFT (3U)
/*! SAI1_MCLK3 - SAI1 mclk3 clock enable
 */
#define AUDIOMIX_CLKEN0_SAI1_MCLK3(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN0_SAI1_MCLK3_SHIFT)) & AUDIOMIX_CLKEN0_SAI1_MCLK3_MASK)
#define AUDIOMIX_CLKEN0_SAI2_MASK  (0x10U)
#define AUDIOMIX_CLKEN0_SAI2_SHIFT (4U)
/*! SAI2 - SAI2 clock enable
 *  0b1..SAI2 sai clock enable
 *  0b0..SAI2 sai clock disable
 */
#define AUDIOMIX_CLKEN0_SAI2(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN0_SAI2_SHIFT)) & AUDIOMIX_CLKEN0_SAI2_MASK)
#define AUDIOMIX_CLKEN0_SAI2_MCLK1_MASK  (0x20U)
#define AUDIOMIX_CLKEN0_SAI2_MCLK1_SHIFT (5U)
/*! SAI2_MCLK1 - SAI2 mclk1 clock enable
 */
#define AUDIOMIX_CLKEN0_SAI2_MCLK1(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN0_SAI2_MCLK1_SHIFT)) & AUDIOMIX_CLKEN0_SAI2_MCLK1_MASK)
#define AUDIOMIX_CLKEN0_SAI2_MCLK2_MASK  (0x40U)
#define AUDIOMIX_CLKEN0_SAI2_MCLK2_SHIFT (6U)
/*! SAI2_MCLK2 - SAI2 mclk2 clock enable
 */
#define AUDIOMIX_CLKEN0_SAI2_MCLK2(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN0_SAI2_MCLK2_SHIFT)) & AUDIOMIX_CLKEN0_SAI2_MCLK2_MASK)
#define AUDIOMIX_CLKEN0_SAI2_MCLK3_MASK  (0x80U)
#define AUDIOMIX_CLKEN0_SAI2_MCLK3_SHIFT (7U)
/*! SAI2_MCLK3 - SAI2 mclk3 clock enable
 */
#define AUDIOMIX_CLKEN0_SAI2_MCLK3(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN0_SAI2_MCLK3_SHIFT)) & AUDIOMIX_CLKEN0_SAI2_MCLK3_MASK)
#define AUDIOMIX_CLKEN0_SAI3_MASK  (0x100U)
#define AUDIOMIX_CLKEN0_SAI3_SHIFT (8U)
/*! SAI3 - SAI3 clock enable
 *  0b1..SAI3 sai clock enable
 *  0b0..SAI3 sai clock disable
 */
#define AUDIOMIX_CLKEN0_SAI3(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN0_SAI3_SHIFT)) & AUDIOMIX_CLKEN0_SAI3_MASK)
#define AUDIOMIX_CLKEN0_SAI3_MCLK1_MASK  (0x200U)
#define AUDIOMIX_CLKEN0_SAI3_MCLK1_SHIFT (9U)
/*! SAI3_MCLK1 - SAI3 mclk1 clock enable
 */
#define AUDIOMIX_CLKEN0_SAI3_MCLK1(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN0_SAI3_MCLK1_SHIFT)) & AUDIOMIX_CLKEN0_SAI3_MCLK1_MASK)
#define AUDIOMIX_CLKEN0_SAI3_MCLK2_MASK  (0x400U)
#define AUDIOMIX_CLKEN0_SAI3_MCLK2_SHIFT (10U)
/*! SAI3_MCLK2 - SAI3 mclk2 clock enable
 */
#define AUDIOMIX_CLKEN0_SAI3_MCLK2(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN0_SAI3_MCLK2_SHIFT)) & AUDIOMIX_CLKEN0_SAI3_MCLK2_MASK)
#define AUDIOMIX_CLKEN0_SAI3_MCLK3_MASK  (0x800U)
#define AUDIOMIX_CLKEN0_SAI3_MCLK3_SHIFT (11U)
/*! SAI3_MCLK3 - SAI3 mclk3 clock enable
 */
#define AUDIOMIX_CLKEN0_SAI3_MCLK3(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN0_SAI3_MCLK3_SHIFT)) & AUDIOMIX_CLKEN0_SAI3_MCLK3_MASK)
#define AUDIOMIX_CLKEN0_SAI5_MASK  (0x1000U)
#define AUDIOMIX_CLKEN0_SAI5_SHIFT (12U)
/*! SAI5 - SAI5 clock enable
 *  0b1..SAI5 sai clock enable
 *  0b0..SAI5 sai clock disable
 */
#define AUDIOMIX_CLKEN0_SAI5(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN0_SAI5_SHIFT)) & AUDIOMIX_CLKEN0_SAI5_MASK)
#define AUDIOMIX_CLKEN0_SAI5_MCLK1_MASK  (0x2000U)
#define AUDIOMIX_CLKEN0_SAI5_MCLK1_SHIFT (13U)
/*! SAI5_MCLK1 - SAI5 mclk1 clock enable
 */
#define AUDIOMIX_CLKEN0_SAI5_MCLK1(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN0_SAI5_MCLK1_SHIFT)) & AUDIOMIX_CLKEN0_SAI5_MCLK1_MASK)
#define AUDIOMIX_CLKEN0_SAI5_MCLK2_MASK  (0x4000U)
#define AUDIOMIX_CLKEN0_SAI5_MCLK2_SHIFT (14U)
/*! SAI5_MCLK2 - SAI5 mclk2 clock enable
 */
#define AUDIOMIX_CLKEN0_SAI5_MCLK2(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN0_SAI5_MCLK2_SHIFT)) & AUDIOMIX_CLKEN0_SAI5_MCLK2_MASK)
#define AUDIOMIX_CLKEN0_SAI5_MCLK3_MASK  (0x8000U)
#define AUDIOMIX_CLKEN0_SAI5_MCLK3_SHIFT (15U)
/*! SAI5_MCLK3 - SAI5 mclk3 clock enable
 */
#define AUDIOMIX_CLKEN0_SAI5_MCLK3(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN0_SAI5_MCLK3_SHIFT)) & AUDIOMIX_CLKEN0_SAI5_MCLK3_MASK)
#define AUDIOMIX_CLKEN0_SAI6_MASK  (0x10000U)
#define AUDIOMIX_CLKEN0_SAI6_SHIFT (16U)
/*! SAI6 - SAI6 clock enable
 *  0b1..SAI6 IPG clock enable
 *  0b0..SAI6 IPG clock disable
 */
#define AUDIOMIX_CLKEN0_SAI6(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN0_SAI6_SHIFT)) & AUDIOMIX_CLKEN0_SAI6_MASK)
#define AUDIOMIX_CLKEN0_SAI6_MCLK1_MASK  (0x20000U)
#define AUDIOMIX_CLKEN0_SAI6_MCLK1_SHIFT (17U)
/*! SAI6_MCLK1 - SAI6 mclk1 clock enable
 */
#define AUDIOMIX_CLKEN0_SAI6_MCLK1(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN0_SAI6_MCLK1_SHIFT)) & AUDIOMIX_CLKEN0_SAI6_MCLK1_MASK)
#define AUDIOMIX_CLKEN0_SAI6_MCLK2_MASK  (0x40000U)
#define AUDIOMIX_CLKEN0_SAI6_MCLK2_SHIFT (18U)
/*! SAI6_MCLK2 - SAI6 mclk2 clock enable
 */
#define AUDIOMIX_CLKEN0_SAI6_MCLK2(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN0_SAI6_MCLK2_SHIFT)) & AUDIOMIX_CLKEN0_SAI6_MCLK2_MASK)
#define AUDIOMIX_CLKEN0_SAI6_MCLK3_MASK  (0x80000U)
#define AUDIOMIX_CLKEN0_SAI6_MCLK3_SHIFT (19U)
/*! SAI6_MCLK3 - SAI6 mclk3 clock enable
 */
#define AUDIOMIX_CLKEN0_SAI6_MCLK3(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN0_SAI6_MCLK3_SHIFT)) & AUDIOMIX_CLKEN0_SAI6_MCLK3_MASK)
#define AUDIOMIX_CLKEN0_SAI7_MASK  (0x100000U)
#define AUDIOMIX_CLKEN0_SAI7_SHIFT (20U)
/*! SAI7 - SAI7 clock enable
 *  0b1..SAI7 sai clock enable
 *  0b0..SAI7 sai clock disable
 */
#define AUDIOMIX_CLKEN0_SAI7(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN0_SAI7_SHIFT)) & AUDIOMIX_CLKEN0_SAI7_MASK)
#define AUDIOMIX_CLKEN0_SAI7_MCLK1_MASK  (0x200000U)
#define AUDIOMIX_CLKEN0_SAI7_MCLK1_SHIFT (21U)
/*! SAI7_MCLK1 - SAI7 mclk1 clock enable
 */
#define AUDIOMIX_CLKEN0_SAI7_MCLK1(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN0_SAI7_MCLK1_SHIFT)) & AUDIOMIX_CLKEN0_SAI7_MCLK1_MASK)
#define AUDIOMIX_CLKEN0_SAI7_MCLK2_MASK  (0x400000U)
#define AUDIOMIX_CLKEN0_SAI7_MCLK2_SHIFT (22U)
/*! SAI7_MCLK2 - SAI7 mclk2 clock enable
 */
#define AUDIOMIX_CLKEN0_SAI7_MCLK2(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN0_SAI7_MCLK2_SHIFT)) & AUDIOMIX_CLKEN0_SAI7_MCLK2_MASK)
#define AUDIOMIX_CLKEN0_SAI7_MCLK3_MASK  (0x800000U)
#define AUDIOMIX_CLKEN0_SAI7_MCLK3_SHIFT (23U)
/*! SAI7_MCLK3 - SAI7 mclk3 clock enable
 */
#define AUDIOMIX_CLKEN0_SAI7_MCLK3(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN0_SAI7_MCLK3_SHIFT)) & AUDIOMIX_CLKEN0_SAI7_MCLK3_MASK)
#define AUDIOMIX_CLKEN0_ASRC_MASK  (0x1000000U)
#define AUDIOMIX_CLKEN0_ASRC_SHIFT (24U)
/*! ASRC - ASRC clock enable
 */
#define AUDIOMIX_CLKEN0_ASRC(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN0_ASRC_SHIFT)) & AUDIOMIX_CLKEN0_ASRC_MASK)
#define AUDIOMIX_CLKEN0_PDM_MASK  (0x2000000U)
#define AUDIOMIX_CLKEN0_PDM_SHIFT (25U)
/*! PDM - PDM clock enable
 */
#define AUDIOMIX_CLKEN0_PDM(x)      (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN0_PDM_SHIFT)) & AUDIOMIX_CLKEN0_PDM_MASK)
#define AUDIOMIX_CLKEN0_SDMA2_MASK  (0x4000000U)
#define AUDIOMIX_CLKEN0_SDMA2_SHIFT (26U)
/*! SDMA2 - SDMA2 clock enable
 */
#define AUDIOMIX_CLKEN0_SDMA2(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN0_SDMA2_SHIFT)) & AUDIOMIX_CLKEN0_SDMA2_MASK)
#define AUDIOMIX_CLKEN0_SDMA3_MASK  (0x8000000U)
#define AUDIOMIX_CLKEN0_SDMA3_SHIFT (27U)
/*! SDMA3 - SDMA3 clock enable
 */
#define AUDIOMIX_CLKEN0_SDMA3(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN0_SDMA3_SHIFT)) & AUDIOMIX_CLKEN0_SDMA3_MASK)
#define AUDIOMIX_CLKEN0_SPBA2_MASK  (0x10000000U)
#define AUDIOMIX_CLKEN0_SPBA2_SHIFT (28U)
/*! SPBA2 - SPBA2 clock enable
 */
#define AUDIOMIX_CLKEN0_SPBA2(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN0_SPBA2_SHIFT)) & AUDIOMIX_CLKEN0_SPBA2_MASK)
#define AUDIOMIX_CLKEN0_AUDIODSP_MASK  (0x20000000U)
#define AUDIOMIX_CLKEN0_AUDIODSP_SHIFT (29U)
/*! AudioDSP - AudioDSP core clock enable
 */
#define AUDIOMIX_CLKEN0_AUDIODSP(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN0_AUDIODSP_SHIFT)) & AUDIOMIX_CLKEN0_AUDIODSP_MASK)
#define AUDIOMIX_CLKEN0_AUDIODSP_DEBUG_MASK  (0x40000000U)
#define AUDIOMIX_CLKEN0_AUDIODSP_DEBUG_SHIFT (30U)
/*! AudioDSP_DEBUG - AudioDSP DEBUG clock enable
 */
#define AUDIOMIX_CLKEN0_AUDIODSP_DEBUG(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN0_AUDIODSP_DEBUG_SHIFT)) & AUDIOMIX_CLKEN0_AUDIODSP_DEBUG_MASK)
#define AUDIOMIX_CLKEN0_EARC_MASK  (0x80000000U)
#define AUDIOMIX_CLKEN0_EARC_SHIFT (31U)
/*! EARC - EARC clock enable
 */
#define AUDIOMIX_CLKEN0_EARC(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN0_EARC_SHIFT)) & AUDIOMIX_CLKEN0_EARC_MASK)
/*! @} */

/*! @name CLKEN1 - IP Clock Enable Control Register 1 */
/*! @{ */
#define AUDIOMIX_CLKEN1_OCRAM_A_MASK  (0x1U)
#define AUDIOMIX_CLKEN1_OCRAM_A_SHIFT (0U)
/*! OCRAM_A - OCRAM_A clock enable
 */
#define AUDIOMIX_CLKEN1_OCRAM_A(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN1_OCRAM_A_SHIFT)) & AUDIOMIX_CLKEN1_OCRAM_A_MASK)
#define AUDIOMIX_CLKEN1_AUD2HTX_MASK  (0x2U)
#define AUDIOMIX_CLKEN1_AUD2HTX_SHIFT (1U)
/*! AUD2HTX - AUDIO LINK MASTER clock enable
 */
#define AUDIOMIX_CLKEN1_AUD2HTX(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN1_AUD2HTX_SHIFT)) & AUDIOMIX_CLKEN1_AUD2HTX_MASK)
#define AUDIOMIX_CLKEN1_EDMA_MASK  (0x4U)
#define AUDIOMIX_CLKEN1_EDMA_SHIFT (2U)
/*! EDMA - EDMA clock enable
 */
#define AUDIOMIX_CLKEN1_EDMA(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN1_EDMA_SHIFT)) & AUDIOMIX_CLKEN1_EDMA_MASK)
#define AUDIOMIX_CLKEN1_PLL_MASK  (0x8U)
#define AUDIOMIX_CLKEN1_PLL_SHIFT (3U)
/*! PLL - PLL clock enable
 */
#define AUDIOMIX_CLKEN1_PLL(x)    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN1_PLL_SHIFT)) & AUDIOMIX_CLKEN1_PLL_MASK)
#define AUDIOMIX_CLKEN1_MU2_MASK  (0x10U)
#define AUDIOMIX_CLKEN1_MU2_SHIFT (4U)
/*! MU2 - MU2 clock enable
 */
#define AUDIOMIX_CLKEN1_MU2(x)    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN1_MU2_SHIFT)) & AUDIOMIX_CLKEN1_MU2_MASK)
#define AUDIOMIX_CLKEN1_MU3_MASK  (0x20U)
#define AUDIOMIX_CLKEN1_MU3_SHIFT (5U)
/*! MU3 - MU3 clock enable
 */
#define AUDIOMIX_CLKEN1_MU3(x)         (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN1_MU3_SHIFT)) & AUDIOMIX_CLKEN1_MU3_MASK)
#define AUDIOMIX_CLKEN1_EARC_PHY_MASK  (0x40U)
#define AUDIOMIX_CLKEN1_EARC_PHY_SHIFT (6U)
/*! EARC_PHY - EARC PHY audio ss clock enable
 */
#define AUDIOMIX_CLKEN1_EARC_PHY(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_CLKEN1_EARC_PHY_SHIFT)) & AUDIOMIX_CLKEN1_EARC_PHY_MASK)
/*! @} */

/*! @name AUDIODSP_REG0 - AudioDSP EXPSTATE Register */
/*! @{ */
#define AUDIOMIX_AUDIODSP_REG0_EXPSTATE_MASK  (0xFFFFFFFFU)
#define AUDIOMIX_AUDIODSP_REG0_EXPSTATE_SHIFT (0U)
/*! EXPSTATE - TIE_EXPSTATE output port of the AudioDSP
 */
#define AUDIOMIX_AUDIODSP_REG0_EXPSTATE(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_AUDIODSP_REG0_EXPSTATE_SHIFT)) & AUDIOMIX_AUDIODSP_REG0_EXPSTATE_MASK)
/*! @} */

/*! @name AUDIODSP_REG1 - AudioDSP IMPWIRE Register */
/*! @{ */
#define AUDIOMIX_AUDIODSP_REG1_IMPWIRE_MASK  (0xFFFFFFFFU)
#define AUDIOMIX_AUDIODSP_REG1_IMPWIRE_SHIFT (0U)
/*! IMPWIRE - TIE_IMPWIRE input port of the AudioDSP
 */
#define AUDIOMIX_AUDIODSP_REG1_IMPWIRE(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_AUDIODSP_REG1_IMPWIRE_SHIFT)) & AUDIOMIX_AUDIODSP_REG1_IMPWIRE_MASK)
/*! @} */

/*! @name AUDIODSP_REG2 - AudioDSP XOCDMODE Register */
/*! @{ */
#define AUDIOMIX_AUDIODSP_REG2_XOCDMODE_MASK  (0x1U)
#define AUDIOMIX_AUDIODSP_REG2_XOCDMODE_SHIFT (0U)
/*! XOCDMODE - Indicates that the AudioDSP is in OCD halt mode
 */
#define AUDIOMIX_AUDIODSP_REG2_XOCDMODE(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_AUDIODSP_REG2_XOCDMODE_SHIFT)) & AUDIOMIX_AUDIODSP_REG2_XOCDMODE_MASK)
#define AUDIOMIX_AUDIODSP_REG2_PWAITMODE_MASK  (0x2U)
#define AUDIOMIX_AUDIODSP_REG2_PWAITMODE_SHIFT (1U)
/*! PWAITMODE - Indicates that the AudioDSP is in sleep mode. The processor asserts this signal when
 *    it has executed a WAITI instruction and is waiting for an interrupt.
 */
#define AUDIOMIX_AUDIODSP_REG2_PWAITMODE(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_AUDIODSP_REG2_PWAITMODE_SHIFT)) & AUDIOMIX_AUDIODSP_REG2_PWAITMODE_MASK)
#define AUDIOMIX_AUDIODSP_REG2_OCDHALTONRESET_MASK  (0x10U)
#define AUDIOMIX_AUDIODSP_REG2_OCDHALTONRESET_SHIFT (4U)
/*! OCDHALTONRESET - AudioDSP enters OCDHaltMode if this signal is samped asserted on reset.
 */
#define AUDIOMIX_AUDIODSP_REG2_OCDHALTONRESET(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_AUDIODSP_REG2_OCDHALTONRESET_SHIFT)) & \
     AUDIOMIX_AUDIODSP_REG2_OCDHALTONRESET_MASK)
#define AUDIOMIX_AUDIODSP_REG2_RUNSTALL_MASK  (0x20U)
#define AUDIOMIX_AUDIODSP_REG2_RUNSTALL_SHIFT (5U)
/*! RunStall - AudioDSP RunStall control bit.
 *  0b1..stalls the processor
 */
#define AUDIOMIX_AUDIODSP_REG2_RUNSTALL(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_AUDIODSP_REG2_RUNSTALL_SHIFT)) & AUDIOMIX_AUDIODSP_REG2_RUNSTALL_MASK)
#define AUDIOMIX_AUDIODSP_REG2_STATVECTORSEL_MASK  (0x40U)
#define AUDIOMIX_AUDIODSP_REG2_STATVECTORSEL_SHIFT (6U)
/*! StatVectorSel - Selects between one of two stationary vector bases
 *  0b0..default
 *  0b1..alternative
 */
#define AUDIOMIX_AUDIODSP_REG2_STATVECTORSEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_AUDIODSP_REG2_STATVECTORSEL_SHIFT)) & \
     AUDIOMIX_AUDIODSP_REG2_STATVECTORSEL_MASK)
#define AUDIOMIX_AUDIODSP_REG2_ADDRMODE_MASK  (0x100U)
#define AUDIOMIX_AUDIODSP_REG2_ADDRMODE_SHIFT (8U)
#define AUDIOMIX_AUDIODSP_REG2_ADDRMODE(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_AUDIODSP_REG2_ADDRMODE_SHIFT)) & AUDIOMIX_AUDIODSP_REG2_ADDRMODE_MASK)
#define AUDIOMIX_AUDIODSP_REG2_DSMMODE_MASK  (0x200U)
#define AUDIOMIX_AUDIODSP_REG2_DSMMODE_SHIFT (9U)
/*! DsmMode - AudioDSP in DSM Mode for MU
 *  0b0..not in DSM mode
 *  0b1..in DSM mode
 */
#define AUDIOMIX_AUDIODSP_REG2_DSMMODE(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_AUDIODSP_REG2_DSMMODE_SHIFT)) & AUDIOMIX_AUDIODSP_REG2_DSMMODE_MASK)
#define AUDIOMIX_AUDIODSP_REG2_WAITMODE_MASK  (0x400U)
#define AUDIOMIX_AUDIODSP_REG2_WAITMODE_SHIFT (10U)
/*! WaitMode - AudioDSP in Wait Mode for MU
 *  0b0..not in wait mode
 *  0b1..in wait mode
 */
#define AUDIOMIX_AUDIODSP_REG2_WAITMODE(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_AUDIODSP_REG2_WAITMODE_SHIFT)) & AUDIOMIX_AUDIODSP_REG2_WAITMODE_MASK)
#define AUDIOMIX_AUDIODSP_REG2_M7DSMMODE_MASK  (0x800U)
#define AUDIOMIX_AUDIODSP_REG2_M7DSMMODE_SHIFT (11U)
/*! m7DsmMode - M7 in DSM Mode for MU3
 *  0b0..not in DSM mode
 *  0b1..in DSM mode
 */
#define AUDIOMIX_AUDIODSP_REG2_M7DSMMODE(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_AUDIODSP_REG2_M7DSMMODE_SHIFT)) & AUDIOMIX_AUDIODSP_REG2_M7DSMMODE_MASK)
#define AUDIOMIX_AUDIODSP_REG2_M7WAITMODE_MASK  (0x1000U)
#define AUDIOMIX_AUDIODSP_REG2_M7WAITMODE_SHIFT (12U)
/*! m7WaitMode - M7 in Wait Mode for MU3
 *  0b0..not in wait mode
 *  0b1..in wait mode
 */
#define AUDIOMIX_AUDIODSP_REG2_M7WAITMODE(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_AUDIODSP_REG2_M7WAITMODE_SHIFT)) & AUDIOMIX_AUDIODSP_REG2_M7WAITMODE_MASK)
#define AUDIOMIX_AUDIODSP_REG2_A53DSMMODE_MASK  (0x2000U)
#define AUDIOMIX_AUDIODSP_REG2_A53DSMMODE_SHIFT (13U)
/*! a53DsmMode - CA53 in DSM Mode for MU2
 *  0b0..not in DSM mode
 *  0b1..in DSM mode
 */
#define AUDIOMIX_AUDIODSP_REG2_A53DSMMODE(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_AUDIODSP_REG2_A53DSMMODE_SHIFT)) & AUDIOMIX_AUDIODSP_REG2_A53DSMMODE_MASK)
#define AUDIOMIX_AUDIODSP_REG2_A53WAITMODE_MASK  (0x4000U)
#define AUDIOMIX_AUDIODSP_REG2_A53WAITMODE_SHIFT (14U)
/*! a53WaitMode - CA53 in Wait Mode for MU2
 *  0b0..not in wait mode
 *  0b1..in wait mode
 */
#define AUDIOMIX_AUDIODSP_REG2_A53WAITMODE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_AUDIODSP_REG2_A53WAITMODE_SHIFT)) & \
     AUDIOMIX_AUDIODSP_REG2_A53WAITMODE_MASK)
/*! @} */

/*! @name AUDIODSP_REG3 - AudioDSP PID Register */
/*! @{ */
#define AUDIOMIX_AUDIODSP_REG3_PID_MASK  (0xFFFFU)
#define AUDIOMIX_AUDIODSP_REG3_PID_SHIFT (0U)
/*! PID - AudioDSP PID Register. Input to the AudioDSP, latched at reset into the low-order bits of
 *    the PRID(processor ID) special register.
 */
#define AUDIOMIX_AUDIODSP_REG3_PID(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_AUDIODSP_REG3_PID_SHIFT)) & AUDIOMIX_AUDIODSP_REG3_PID_MASK)
/*! @} */

/*! @name EARC - EARC Control Register */
/*! @{ */
#define AUDIOMIX_EARC_RESETB_MASK  (0x1U)
#define AUDIOMIX_EARC_RESETB_SHIFT (0U)
/*! RESETB - Earc Software Reset.
 *  0b0..provide a software reset for EARC controller
 *  0b1..return from reset
 */
#define AUDIOMIX_EARC_RESETB(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_EARC_RESETB_SHIFT)) & AUDIOMIX_EARC_RESETB_MASK)
#define AUDIOMIX_EARC_PHY_RESETB_MASK  (0x2U)
#define AUDIOMIX_EARC_PHY_RESETB_SHIFT (1U)
/*! PHY_RESETB - Earc PHY Software Reset.
 *  0b0..provide a software reset for EARC PHY
 *  0b1..return from reset
 */
#define AUDIOMIX_EARC_PHY_RESETB(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_EARC_PHY_RESETB_SHIFT)) & AUDIOMIX_EARC_PHY_RESETB_MASK)
/*! @} */

/*! @name SAI1_MCLK_SEL - SAI1 MCLK SELECT Register */
/*! @{ */
#define AUDIOMIX_SAI1_MCLK_SEL_MCLK1_SEL_MASK  (0x1U)
#define AUDIOMIX_SAI1_MCLK_SEL_MCLK1_SEL_SHIFT (0U)
/*! MCLK1_SEL
 *  0b0..SAI1_CLK_ROOT is selected
 *  0b1..SAI1.MCLK is selected
 */
#define AUDIOMIX_SAI1_MCLK_SEL_MCLK1_SEL(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI1_MCLK_SEL_MCLK1_SEL_SHIFT)) & AUDIOMIX_SAI1_MCLK_SEL_MCLK1_SEL_MASK)
#define AUDIOMIX_SAI1_MCLK_SEL_MCLK2_SEL_MASK  (0x1EU)
#define AUDIOMIX_SAI1_MCLK_SEL_MCLK2_SEL_SHIFT (1U)
/*! MCLK2_SEL
 *  0b0000..SAI1_CLK_ROOT is selected
 *  0b0001..SAI2_CLK_ROOT is selected
 *  0b0010..SAI3_CLK_ROOT is selected
 *  0b0011..Reserved, MCLK2 is 0
 *  0b0100..SAI5_CLK_ROOT is selected
 *  0b0101..SAI6_CLK_ROOT is selected
 *  0b0110..SAI7_CLK_ROOT is selected
 *  0b0111..SAI1.MCLK is selected
 *  0b1000..SAI2.MCLK is selected
 *  0b1001..SAI3.MCLK is selected
 *  0b1010..Reserved, MCLK2 is 0
 *  0b1011..SAI5.MCLK is selected
 *  0b1100..SAI6.MCLK is selected
 *  0b1101..SAI7.MCLK is selected
 *  0b1110..SPDIF.ETXCLK is selected
 */
#define AUDIOMIX_SAI1_MCLK_SEL_MCLK2_SEL(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI1_MCLK_SEL_MCLK2_SEL_SHIFT)) & AUDIOMIX_SAI1_MCLK_SEL_MCLK2_SEL_MASK)
/*! @} */

/*! @name SAI2_MCLK_SEL - SAI2 MCLK SELECT Register */
/*! @{ */
#define AUDIOMIX_SAI2_MCLK_SEL_MCLK1_SEL_MASK  (0x1U)
#define AUDIOMIX_SAI2_MCLK_SEL_MCLK1_SEL_SHIFT (0U)
/*! MCLK1_SEL
 *  0b0..SAI2_CLK_ROOT is selected
 *  0b1..SAI2.MCLK is selected
 */
#define AUDIOMIX_SAI2_MCLK_SEL_MCLK1_SEL(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI2_MCLK_SEL_MCLK1_SEL_SHIFT)) & AUDIOMIX_SAI2_MCLK_SEL_MCLK1_SEL_MASK)
#define AUDIOMIX_SAI2_MCLK_SEL_MCLK2_SEL_MASK  (0x1EU)
#define AUDIOMIX_SAI2_MCLK_SEL_MCLK2_SEL_SHIFT (1U)
/*! MCLK2_SEL
 *  0b0000..SAI1_CLK_ROOT is selected
 *  0b0001..SAI2_CLK_ROOT is selected
 *  0b0010..SAI3_CLK_ROOT is selected
 *  0b0011..Reserved, MCLK2 is 0
 *  0b0100..SAI5_CLK_ROOT is selected
 *  0b0101..SAI6_CLK_ROOT is selected
 *  0b0110..SAI7_CLK_ROOT is selected
 *  0b0111..SAI1.MCLK is selected
 *  0b1000..SAI2.MCLK is selected
 *  0b1001..SAI3.MCLK is selected
 *  0b1010..Reserved, MCLK is 0
 *  0b1011..SAI5.MCLK is selected
 *  0b1100..SAI6.MCLK is selected
 *  0b1101..SAI7.MCLK is selected
 *  0b1110..SPDIF.ETXCLK is selected
 */
#define AUDIOMIX_SAI2_MCLK_SEL_MCLK2_SEL(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI2_MCLK_SEL_MCLK2_SEL_SHIFT)) & AUDIOMIX_SAI2_MCLK_SEL_MCLK2_SEL_MASK)
/*! @} */

/*! @name SAI3_MCLK_SEL - SAI3 MCLK SELECT Register */
/*! @{ */
#define AUDIOMIX_SAI3_MCLK_SEL_MCLK1_SEL_MASK  (0x1U)
#define AUDIOMIX_SAI3_MCLK_SEL_MCLK1_SEL_SHIFT (0U)
/*! MCLK1_SEL - MCLK1 Select Register
 *  0b0..SAI3_CLK_ROOT is selected
 *  0b1..SAI3.MCLK is selected
 */
#define AUDIOMIX_SAI3_MCLK_SEL_MCLK1_SEL(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI3_MCLK_SEL_MCLK1_SEL_SHIFT)) & AUDIOMIX_SAI3_MCLK_SEL_MCLK1_SEL_MASK)
#define AUDIOMIX_SAI3_MCLK_SEL_MCLK2_SEL_MASK  (0x1EU)
#define AUDIOMIX_SAI3_MCLK_SEL_MCLK2_SEL_SHIFT (1U)
/*! MCLK2_SEL - MCLK2 Select Register
 *  0b0000..SAI1_CLK_ROOT is selected
 *  0b0001..SAI2_CLK_ROOT is selected
 *  0b0010..SAI3_CLK_ROOT is selected
 *  0b0011..Reserved, MCLK2 is 0
 *  0b0100..SAI5_CLK_ROOT is selected
 *  0b0101..SAI6_CLK_ROOT is selected
 *  0b0110..SAI7_CLK_ROOT is selected
 *  0b0111..SAI1.MCLK is selected
 *  0b1000..SAI2.MCLK is selected
 *  0b1001..SAI3.MCLK is selected
 *  0b1010..Reserved, MCLK is 0
 *  0b1011..SAI5.MCLK is selected
 *  0b1100..SAI6.MCLK is selected
 *  0b1101..SAI7.MCLK is selected
 *  0b1110..SPDIF.ETXCLK is selected
 */
#define AUDIOMIX_SAI3_MCLK_SEL_MCLK2_SEL(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI3_MCLK_SEL_MCLK2_SEL_SHIFT)) & AUDIOMIX_SAI3_MCLK_SEL_MCLK2_SEL_MASK)
/*! @} */

/*! @name SAI5_MCLK_SEL - SAI5 MCLK SELECT Register */
/*! @{ */
#define AUDIOMIX_SAI5_MCLK_SEL_MCLK1_SEL_MASK  (0x1U)
#define AUDIOMIX_SAI5_MCLK_SEL_MCLK1_SEL_SHIFT (0U)
/*! MCLK1_SEL - MCLK1 Select Register
 *  0b0..SAI5_CLK_ROOT is selected
 *  0b1..SAI5.MCLK is selected
 */
#define AUDIOMIX_SAI5_MCLK_SEL_MCLK1_SEL(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI5_MCLK_SEL_MCLK1_SEL_SHIFT)) & AUDIOMIX_SAI5_MCLK_SEL_MCLK1_SEL_MASK)
#define AUDIOMIX_SAI5_MCLK_SEL_MCLK2_SEL_MASK  (0x1EU)
#define AUDIOMIX_SAI5_MCLK_SEL_MCLK2_SEL_SHIFT (1U)
/*! MCLK2_SEL - MCLK2 Select Register
 *  0b0000..SAI1_CLK_ROOT is selected
 *  0b0001..SAI2_CLK_ROOT is selected
 *  0b0010..SAI3_CLK_ROOT is selected
 *  0b0011..Reserved, MCLK2 is 0
 *  0b0100..SAI5_CLK_ROOT is selected
 *  0b0101..SAI6_CLK_ROOT is selected
 *  0b0110..SAI7_CLK_ROOT is selected
 *  0b0111..SAI1.MCLK is selected
 *  0b1000..SAI2.MCLK is selected
 *  0b1001..SAI3.MCLK is selected
 *  0b1010..Reserved, MCLK is 0
 *  0b1011..SAI5.MCLK is selected
 *  0b1100..SAI6.MCLK is selected
 *  0b1101..SAI7.MCLK is selected
 *  0b1110..SPDIF.ETXCLK is selected
 */
#define AUDIOMIX_SAI5_MCLK_SEL_MCLK2_SEL(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI5_MCLK_SEL_MCLK2_SEL_SHIFT)) & AUDIOMIX_SAI5_MCLK_SEL_MCLK2_SEL_MASK)
/*! @} */

/*! @name SAI6_MCLK_SEL - SAI6 MCLK SELECT Register */
/*! @{ */
#define AUDIOMIX_SAI6_MCLK_SEL_MCLK1_SEL_MASK  (0x1U)
#define AUDIOMIX_SAI6_MCLK_SEL_MCLK1_SEL_SHIFT (0U)
/*! MCLK1_SEL - MCLK1 Select Register
 *  0b0..SAI6_CLK_ROOT is selected
 *  0b1..SAI6.MCLK is selected
 */
#define AUDIOMIX_SAI6_MCLK_SEL_MCLK1_SEL(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI6_MCLK_SEL_MCLK1_SEL_SHIFT)) & AUDIOMIX_SAI6_MCLK_SEL_MCLK1_SEL_MASK)
#define AUDIOMIX_SAI6_MCLK_SEL_MCLK2_SEL_MASK  (0x1EU)
#define AUDIOMIX_SAI6_MCLK_SEL_MCLK2_SEL_SHIFT (1U)
/*! MCLK2_SEL - MCLK2 Select Register
 *  0b0000..SAI1_CLK_ROOT is selected
 *  0b0001..SAI2_CLK_ROOT is selected
 *  0b0010..SAI3_CLK_ROOT is selected
 *  0b0011..Reserved, MCLK2 is 0
 *  0b0100..SAI5_CLK_ROOT is selected
 *  0b0101..SAI6_CLK_ROOT is selected
 *  0b0110..SAI7_CLK_ROOT is selected
 *  0b0111..SAI1.MCLK is selected
 *  0b1000..SAI2.MCLK is selected
 *  0b1001..SAI3.MCLK is selected
 *  0b1010..Reserved, MCLK is 0
 *  0b1011..SAI5.MCLK is selected
 *  0b1100..SAI6.MCLK is selected
 *  0b1101..SAI7.MCLK is selected
 *  0b1110..SPDIF.ETXCLK is selected
 */
#define AUDIOMIX_SAI6_MCLK_SEL_MCLK2_SEL(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI6_MCLK_SEL_MCLK2_SEL_SHIFT)) & AUDIOMIX_SAI6_MCLK_SEL_MCLK2_SEL_MASK)
/*! @} */

/*! @name SAI7_MCLK_SEL - SAI7 MCLK SELECT Register */
/*! @{ */
#define AUDIOMIX_SAI7_MCLK_SEL_MCLK1_SEL_MASK  (0x1U)
#define AUDIOMIX_SAI7_MCLK_SEL_MCLK1_SEL_SHIFT (0U)
/*! MCLK1_SEL - MCLK1 Select Register
 *  0b0..SAI7_CLK_ROOT is selected
 *  0b1..SAI7.MCLK is selected
 */
#define AUDIOMIX_SAI7_MCLK_SEL_MCLK1_SEL(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI7_MCLK_SEL_MCLK1_SEL_SHIFT)) & AUDIOMIX_SAI7_MCLK_SEL_MCLK1_SEL_MASK)
#define AUDIOMIX_SAI7_MCLK_SEL_MCLK2_SEL_MASK  (0x1EU)
#define AUDIOMIX_SAI7_MCLK_SEL_MCLK2_SEL_SHIFT (1U)
/*! MCLK2_SEL - MCLK2 Select Register
 *  0b0000..SAI1_CLK_ROOT is selected
 *  0b0001..SAI2_CLK_ROOT is selected
 *  0b0010..SAI3_CLK_ROOT is selected
 *  0b0011..Reserved, MCLK2 is 0
 *  0b0100..SAI5_CLK_ROOT is selected
 *  0b0101..SAI6_CLK_ROOT is selected
 *  0b0110..SAI7_CLK_ROOT is selected
 *  0b0111..SAI1.MCLK is selected
 *  0b1000..SAI2.MCLK is selected
 *  0b1001..SAI3.MCLK is selected
 *  0b1010..Reserved, MCLK is 0
 *  0b1011..SAI5.MCLK is selected
 *  0b1100..SAI6.MCLK is selected
 *  0b1101..SAI7.MCLK is selected
 *  0b1110..SPDIF.ETXCLK is selected
 */
#define AUDIOMIX_SAI7_MCLK_SEL_MCLK2_SEL(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI7_MCLK_SEL_MCLK2_SEL_SHIFT)) & AUDIOMIX_SAI7_MCLK_SEL_MCLK2_SEL_MASK)
/*! @} */

/*! @name PDM_CLK - PDM Root Clock Select Register */
/*! @{ */
#define AUDIOMIX_PDM_CLK_SELECT_MASK  (0x3U)
#define AUDIOMIX_PDM_CLK_SELECT_SHIFT (0U)
/*! select - PDM Root Clock Select Bits
 *  0b00..ccm pdm clock is selected
 *  0b01..sai_pll div2 is selected
 *  0b10..SAI1_MCLK is selected
 *  0b11..reserved.
 */
#define AUDIOMIX_PDM_CLK_SELECT(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_PDM_CLK_SELECT_SHIFT)) & AUDIOMIX_PDM_CLK_SELECT_MASK)
/*! @} */

/*! @name SAI_PLL_GNRL_CTL - SAI PLL General control Register */
/*! @{ */
#define AUDIOMIX_SAI_PLL_GNRL_CTL_REF_CLK_SEL_MASK  (0x3U)
#define AUDIOMIX_SAI_PLL_GNRL_CTL_REF_CLK_SEL_SHIFT (0U)
/*! ref_clk_sel - reference clock select
 */
#define AUDIOMIX_SAI_PLL_GNRL_CTL_REF_CLK_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI_PLL_GNRL_CTL_REF_CLK_SEL_SHIFT)) & \
     AUDIOMIX_SAI_PLL_GNRL_CTL_REF_CLK_SEL_MASK)
#define AUDIOMIX_SAI_PLL_GNRL_CTL_PAD_CLK_SEL_MASK  (0xCU)
#define AUDIOMIX_SAI_PLL_GNRL_CTL_PAD_CLK_SEL_SHIFT (2U)
/*! pad_clk_sel - pad clock select
 */
#define AUDIOMIX_SAI_PLL_GNRL_CTL_PAD_CLK_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI_PLL_GNRL_CTL_PAD_CLK_SEL_SHIFT)) & \
     AUDIOMIX_SAI_PLL_GNRL_CTL_PAD_CLK_SEL_MASK)
#define AUDIOMIX_SAI_PLL_GNRL_CTL_BYPASS_MASK  (0x10U)
#define AUDIOMIX_SAI_PLL_GNRL_CTL_BYPASS_SHIFT (4U)
/*! bypass - pll bypass
 */
#define AUDIOMIX_SAI_PLL_GNRL_CTL_BYPASS(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI_PLL_GNRL_CTL_BYPASS_SHIFT)) & AUDIOMIX_SAI_PLL_GNRL_CTL_BYPASS_MASK)
#define AUDIOMIX_SAI_PLL_GNRL_CTL_RESETB_OVERRIDE_MASK  (0x100U)
#define AUDIOMIX_SAI_PLL_GNRL_CTL_RESETB_OVERRIDE_SHIFT (8U)
/*! resetb_override - resetb override
 */
#define AUDIOMIX_SAI_PLL_GNRL_CTL_RESETB_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI_PLL_GNRL_CTL_RESETB_OVERRIDE_SHIFT)) & \
     AUDIOMIX_SAI_PLL_GNRL_CTL_RESETB_OVERRIDE_MASK)
#define AUDIOMIX_SAI_PLL_GNRL_CTL_RESETB_MASK  (0x200U)
#define AUDIOMIX_SAI_PLL_GNRL_CTL_RESETB_SHIFT (9U)
/*! resetb - pll resetb
 */
#define AUDIOMIX_SAI_PLL_GNRL_CTL_RESETB(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI_PLL_GNRL_CTL_RESETB_SHIFT)) & AUDIOMIX_SAI_PLL_GNRL_CTL_RESETB_MASK)
#define AUDIOMIX_SAI_PLL_GNRL_CTL_CKE_OVERRIDE_MASK  (0x1000U)
#define AUDIOMIX_SAI_PLL_GNRL_CTL_CKE_OVERRIDE_SHIFT (12U)
/*! cke_override - pll cke override.
 */
#define AUDIOMIX_SAI_PLL_GNRL_CTL_CKE_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI_PLL_GNRL_CTL_CKE_OVERRIDE_SHIFT)) & \
     AUDIOMIX_SAI_PLL_GNRL_CTL_CKE_OVERRIDE_MASK)
#define AUDIOMIX_SAI_PLL_GNRL_CTL_CKE_MASK  (0x2000U)
#define AUDIOMIX_SAI_PLL_GNRL_CTL_CKE_SHIFT (13U)
/*! cke - pll cke
 */
#define AUDIOMIX_SAI_PLL_GNRL_CTL_CKE(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI_PLL_GNRL_CTL_CKE_SHIFT)) & AUDIOMIX_SAI_PLL_GNRL_CTL_CKE_MASK)
#define AUDIOMIX_SAI_PLL_GNRL_CTL_BLK_BYPASS_MASK  (0x10000U)
#define AUDIOMIX_SAI_PLL_GNRL_CTL_BLK_BYPASS_SHIFT (16U)
/*! blk_bypass - blk bypass
 */
#define AUDIOMIX_SAI_PLL_GNRL_CTL_BLK_BYPASS(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI_PLL_GNRL_CTL_BLK_BYPASS_SHIFT)) & \
     AUDIOMIX_SAI_PLL_GNRL_CTL_BLK_BYPASS_MASK)
#define AUDIOMIX_SAI_PLL_GNRL_CTL_LOCK_MASK  (0x80000000U)
#define AUDIOMIX_SAI_PLL_GNRL_CTL_LOCK_SHIFT (31U)
/*! lock - pll lock
 */
#define AUDIOMIX_SAI_PLL_GNRL_CTL_LOCK(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI_PLL_GNRL_CTL_LOCK_SHIFT)) & AUDIOMIX_SAI_PLL_GNRL_CTL_LOCK_MASK)
/*! @} */

/*! @name SAI_PLL_FDIV_CTL0 - SAI PLL Frequency Divider control Register */
/*! @{ */
#define AUDIOMIX_SAI_PLL_FDIV_CTL0_POST_DIV_MASK  (0x7U)
#define AUDIOMIX_SAI_PLL_FDIV_CTL0_POST_DIV_SHIFT (0U)
/*! post_div - post divider value
 */
#define AUDIOMIX_SAI_PLL_FDIV_CTL0_POST_DIV(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI_PLL_FDIV_CTL0_POST_DIV_SHIFT)) & \
     AUDIOMIX_SAI_PLL_FDIV_CTL0_POST_DIV_MASK)
#define AUDIOMIX_SAI_PLL_FDIV_CTL0_PRE_DIV_MASK  (0x3F0U)
#define AUDIOMIX_SAI_PLL_FDIV_CTL0_PRE_DIV_SHIFT (4U)
/*! pre_div - pre divider value
 */
#define AUDIOMIX_SAI_PLL_FDIV_CTL0_PRE_DIV(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI_PLL_FDIV_CTL0_PRE_DIV_SHIFT)) & \
     AUDIOMIX_SAI_PLL_FDIV_CTL0_PRE_DIV_MASK)
#define AUDIOMIX_SAI_PLL_FDIV_CTL0_MAIN_DIV_MASK  (0x3FF000U)
#define AUDIOMIX_SAI_PLL_FDIV_CTL0_MAIN_DIV_SHIFT (12U)
/*! main_div - main divider value
 */
#define AUDIOMIX_SAI_PLL_FDIV_CTL0_MAIN_DIV(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI_PLL_FDIV_CTL0_MAIN_DIV_SHIFT)) & \
     AUDIOMIX_SAI_PLL_FDIV_CTL0_MAIN_DIV_MASK)
/*! @} */

/*! @name SAI_PLL_FDIV_CTL1 - SAI PLL DSM value Register */
/*! @{ */
#define AUDIOMIX_SAI_PLL_FDIV_CTL1_DSM_MASK  (0xFFFFU)
#define AUDIOMIX_SAI_PLL_FDIV_CTL1_DSM_SHIFT (0U)
/*! dsm - pll DSM(K) value
 */
#define AUDIOMIX_SAI_PLL_FDIV_CTL1_DSM(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI_PLL_FDIV_CTL1_DSM_SHIFT)) & AUDIOMIX_SAI_PLL_FDIV_CTL1_DSM_MASK)
/*! @} */

/*! @name SAI_PLL_SSCG_CTL - SAI PLL SSCG control Register */
/*! @{ */
#define AUDIOMIX_SAI_PLL_SSCG_CTL_SEL_PF_MASK  (0x3U)
#define AUDIOMIX_SAI_PLL_SSCG_CTL_SEL_PF_SHIFT (0U)
/*! sel_pf - pll modulation method control
 */
#define AUDIOMIX_SAI_PLL_SSCG_CTL_SEL_PF(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI_PLL_SSCG_CTL_SEL_PF_SHIFT)) & AUDIOMIX_SAI_PLL_SSCG_CTL_SEL_PF_MASK)
#define AUDIOMIX_SAI_PLL_SSCG_CTL_MRAT_CTL_MASK  (0x3F0U)
#define AUDIOMIX_SAI_PLL_SSCG_CTL_MRAT_CTL_SHIFT (4U)
/*! mrat_ctl - pll modulation rate control
 */
#define AUDIOMIX_SAI_PLL_SSCG_CTL_MRAT_CTL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI_PLL_SSCG_CTL_MRAT_CTL_SHIFT)) & \
     AUDIOMIX_SAI_PLL_SSCG_CTL_MRAT_CTL_MASK)
#define AUDIOMIX_SAI_PLL_SSCG_CTL_MFREQ_CTL_MASK  (0xFF000U)
#define AUDIOMIX_SAI_PLL_SSCG_CTL_MFREQ_CTL_SHIFT (12U)
/*! mfreq_ctl - pll modulation frequency control
 */
#define AUDIOMIX_SAI_PLL_SSCG_CTL_MFREQ_CTL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI_PLL_SSCG_CTL_MFREQ_CTL_SHIFT)) & \
     AUDIOMIX_SAI_PLL_SSCG_CTL_MFREQ_CTL_MASK)
#define AUDIOMIX_SAI_PLL_SSCG_CTL_SSCG_EN_MASK  (0x80000000U)
#define AUDIOMIX_SAI_PLL_SSCG_CTL_SSCG_EN_SHIFT (31U)
/*! sscg_en - SSCG Enable Bit
 */
#define AUDIOMIX_SAI_PLL_SSCG_CTL_SSCG_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI_PLL_SSCG_CTL_SSCG_EN_SHIFT)) & AUDIOMIX_SAI_PLL_SSCG_CTL_SSCG_EN_MASK)
/*! @} */

/*! @name SAI_PLL_MNIT_CTL - SAI PLL SSCG control Register */
/*! @{ */
#define AUDIOMIX_SAI_PLL_MNIT_CTL_ICP_MASK  (0x7U)
#define AUDIOMIX_SAI_PLL_MNIT_CTL_ICP_SHIFT (0U)
/*! icp - Charge-pump current control
 */
#define AUDIOMIX_SAI_PLL_MNIT_CTL_ICP(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI_PLL_MNIT_CTL_ICP_SHIFT)) & AUDIOMIX_SAI_PLL_MNIT_CTL_ICP_MASK)
#define AUDIOMIX_SAI_PLL_MNIT_CTL_AFC_ENB_MASK  (0x8U)
#define AUDIOMIX_SAI_PLL_MNIT_CTL_AFC_ENB_SHIFT (3U)
/*! afc_enb - AFC Enable control
 */
#define AUDIOMIX_SAI_PLL_MNIT_CTL_AFC_ENB(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI_PLL_MNIT_CTL_AFC_ENB_SHIFT)) & AUDIOMIX_SAI_PLL_MNIT_CTL_AFC_ENB_MASK)
#define AUDIOMIX_SAI_PLL_MNIT_CTL_EXTAFC_MASK  (0x1F0U)
#define AUDIOMIX_SAI_PLL_MNIT_CTL_EXTAFC_SHIFT (4U)
/*! extafc - AFC Enable control
 */
#define AUDIOMIX_SAI_PLL_MNIT_CTL_EXTAFC(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI_PLL_MNIT_CTL_EXTAFC_SHIFT)) & AUDIOMIX_SAI_PLL_MNIT_CTL_EXTAFC_MASK)
#define AUDIOMIX_SAI_PLL_MNIT_CTL_FEED_EN_MASK  (0x4000U)
#define AUDIOMIX_SAI_PLL_MNIT_CTL_FEED_EN_SHIFT (14U)
/*! feed_en - PLL FEED Enable control
 */
#define AUDIOMIX_SAI_PLL_MNIT_CTL_FEED_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI_PLL_MNIT_CTL_FEED_EN_SHIFT)) & AUDIOMIX_SAI_PLL_MNIT_CTL_FEED_EN_MASK)
#define AUDIOMIX_SAI_PLL_MNIT_CTL_FSEL_MASK  (0x8000U)
#define AUDIOMIX_SAI_PLL_MNIT_CTL_FSEL_SHIFT (15U)
/*! fsel - PLL FEED SEL control
 */
#define AUDIOMIX_SAI_PLL_MNIT_CTL_FSEL(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI_PLL_MNIT_CTL_FSEL_SHIFT)) & AUDIOMIX_SAI_PLL_MNIT_CTL_FSEL_MASK)
#define AUDIOMIX_SAI_PLL_MNIT_CTL_AFCINIT_SEL_MASK  (0x20000U)
#define AUDIOMIX_SAI_PLL_MNIT_CTL_AFCINIT_SEL_SHIFT (17U)
/*! afcinit_sel - PLL AFC INIT SEL
 */
#define AUDIOMIX_SAI_PLL_MNIT_CTL_AFCINIT_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI_PLL_MNIT_CTL_AFCINIT_SEL_SHIFT)) & \
     AUDIOMIX_SAI_PLL_MNIT_CTL_AFCINIT_SEL_MASK)
#define AUDIOMIX_SAI_PLL_MNIT_CTL_PBIAS_CTRL_EN_MASK  (0x40000U)
#define AUDIOMIX_SAI_PLL_MNIT_CTL_PBIAS_CTRL_EN_SHIFT (18U)
/*! pbias_ctrl_en - PLL PBIAS CTRL EN
 */
#define AUDIOMIX_SAI_PLL_MNIT_CTL_PBIAS_CTRL_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI_PLL_MNIT_CTL_PBIAS_CTRL_EN_SHIFT)) & \
     AUDIOMIX_SAI_PLL_MNIT_CTL_PBIAS_CTRL_EN_MASK)
#define AUDIOMIX_SAI_PLL_MNIT_CTL_PBIAS_CTRL_MASK  (0x80000U)
#define AUDIOMIX_SAI_PLL_MNIT_CTL_PBIAS_CTRL_SHIFT (19U)
/*! pbias_ctrl - PLL PBIAS CTRL
 */
#define AUDIOMIX_SAI_PLL_MNIT_CTL_PBIAS_CTRL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI_PLL_MNIT_CTL_PBIAS_CTRL_SHIFT)) & \
     AUDIOMIX_SAI_PLL_MNIT_CTL_PBIAS_CTRL_MASK)
#define AUDIOMIX_SAI_PLL_MNIT_CTL_AFC_SEL_MASK  (0x100000U)
#define AUDIOMIX_SAI_PLL_MNIT_CTL_AFC_SEL_SHIFT (20U)
/*! afc_sel - PLL AFC SEL
 */
#define AUDIOMIX_SAI_PLL_MNIT_CTL_AFC_SEL(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_SAI_PLL_MNIT_CTL_AFC_SEL_SHIFT)) & AUDIOMIX_SAI_PLL_MNIT_CTL_AFC_SEL_MASK)
/*! @} */

/*! @name AUDIO_EXT_ADDR - AUDIOMIX Extra Addr Bits Register */
/*! @{ */
#define AUDIOMIX_AUDIO_EXT_ADDR_SDMA2_MASK  (0x3U)
#define AUDIOMIX_AUDIO_EXT_ADDR_SDMA2_SHIFT (0U)
/*! sdma2 - SDMA2 Extra Addr Bits
 */
#define AUDIOMIX_AUDIO_EXT_ADDR_SDMA2(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_AUDIO_EXT_ADDR_SDMA2_SHIFT)) & AUDIOMIX_AUDIO_EXT_ADDR_SDMA2_MASK)
#define AUDIOMIX_AUDIO_EXT_ADDR_SDMA3_MASK  (0xCU)
#define AUDIOMIX_AUDIO_EXT_ADDR_SDMA3_SHIFT (2U)
/*! sdma3 - SDMA3 Extra Addr Bits
 */
#define AUDIOMIX_AUDIO_EXT_ADDR_SDMA3(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_AUDIO_EXT_ADDR_SDMA3_SHIFT)) & AUDIOMIX_AUDIO_EXT_ADDR_SDMA3_MASK)
#define AUDIOMIX_AUDIO_EXT_ADDR_EDMA_MASK  (0x30U)
#define AUDIOMIX_AUDIO_EXT_ADDR_EDMA_SHIFT (4U)
/*! edma - EDMA extra Addr Bits
 */
#define AUDIOMIX_AUDIO_EXT_ADDR_EDMA(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_AUDIO_EXT_ADDR_EDMA_SHIFT)) & AUDIOMIX_AUDIO_EXT_ADDR_EDMA_MASK)
/*! @} */

/*! @name IPG_LP_CTRL - IPG Low Power Control Register */
/*! @{ */
#define AUDIOMIX_IPG_LP_CTRL_EDMA_IPG_STOP_MASK  (0x1U)
#define AUDIOMIX_IPG_LP_CTRL_EDMA_IPG_STOP_SHIFT (0U)
/*! edma_ipg_stop - EDMA IPG_STOP Bit
 */
#define AUDIOMIX_IPG_LP_CTRL_EDMA_IPG_STOP(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_IPG_LP_CTRL_EDMA_IPG_STOP_SHIFT)) & \
     AUDIOMIX_IPG_LP_CTRL_EDMA_IPG_STOP_MASK)
#define AUDIOMIX_IPG_LP_CTRL_SDMA2_IPG_STOP_MASK  (0x2U)
#define AUDIOMIX_IPG_LP_CTRL_SDMA2_IPG_STOP_SHIFT (1U)
/*! sdma2_ipg_stop - SDMA2 IPG_STOP Bit
 */
#define AUDIOMIX_IPG_LP_CTRL_SDMA2_IPG_STOP(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_IPG_LP_CTRL_SDMA2_IPG_STOP_SHIFT)) & \
     AUDIOMIX_IPG_LP_CTRL_SDMA2_IPG_STOP_MASK)
#define AUDIOMIX_IPG_LP_CTRL_SDMA3_IPG_STOP_MASK  (0x4U)
#define AUDIOMIX_IPG_LP_CTRL_SDMA3_IPG_STOP_SHIFT (2U)
/*! sdma3_ipg_stop - SDMA3 IPG_STOP Bit
 */
#define AUDIOMIX_IPG_LP_CTRL_SDMA3_IPG_STOP(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_IPG_LP_CTRL_SDMA3_IPG_STOP_SHIFT)) & \
     AUDIOMIX_IPG_LP_CTRL_SDMA3_IPG_STOP_MASK)
#define AUDIOMIX_IPG_LP_CTRL_PDM_IPG_STOP_MASK  (0x8U)
#define AUDIOMIX_IPG_LP_CTRL_PDM_IPG_STOP_SHIFT (3U)
/*! pdm_ipg_stop - PDM IPG_STOP Bit
 */
#define AUDIOMIX_IPG_LP_CTRL_PDM_IPG_STOP(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_IPG_LP_CTRL_PDM_IPG_STOP_SHIFT)) & AUDIOMIX_IPG_LP_CTRL_PDM_IPG_STOP_MASK)
#define AUDIOMIX_IPG_LP_CTRL_SAI1_IPG_STOP_MASK  (0x10U)
#define AUDIOMIX_IPG_LP_CTRL_SAI1_IPG_STOP_SHIFT (4U)
/*! sai1_ipg_stop - SAI1 IPG_STOP Bit
 */
#define AUDIOMIX_IPG_LP_CTRL_SAI1_IPG_STOP(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_IPG_LP_CTRL_SAI1_IPG_STOP_SHIFT)) & \
     AUDIOMIX_IPG_LP_CTRL_SAI1_IPG_STOP_MASK)
#define AUDIOMIX_IPG_LP_CTRL_SAI2_IPG_STOP_MASK  (0x20U)
#define AUDIOMIX_IPG_LP_CTRL_SAI2_IPG_STOP_SHIFT (5U)
/*! sai2_ipg_stop - SAI2 IPG_STOP Bit
 */
#define AUDIOMIX_IPG_LP_CTRL_SAI2_IPG_STOP(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_IPG_LP_CTRL_SAI2_IPG_STOP_SHIFT)) & \
     AUDIOMIX_IPG_LP_CTRL_SAI2_IPG_STOP_MASK)
#define AUDIOMIX_IPG_LP_CTRL_SAI3_IPG_STOP_MASK  (0x40U)
#define AUDIOMIX_IPG_LP_CTRL_SAI3_IPG_STOP_SHIFT (6U)
/*! sai3_ipg_stop - SAI3 IPG_STOP Bit
 */
#define AUDIOMIX_IPG_LP_CTRL_SAI3_IPG_STOP(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_IPG_LP_CTRL_SAI3_IPG_STOP_SHIFT)) & \
     AUDIOMIX_IPG_LP_CTRL_SAI3_IPG_STOP_MASK)
#define AUDIOMIX_IPG_LP_CTRL_SAI5_IPG_STOP_MASK  (0x80U)
#define AUDIOMIX_IPG_LP_CTRL_SAI5_IPG_STOP_SHIFT (7U)
/*! sai5_ipg_stop - SAI5 IPG_STOP Bit
 */
#define AUDIOMIX_IPG_LP_CTRL_SAI5_IPG_STOP(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_IPG_LP_CTRL_SAI5_IPG_STOP_SHIFT)) & \
     AUDIOMIX_IPG_LP_CTRL_SAI5_IPG_STOP_MASK)
#define AUDIOMIX_IPG_LP_CTRL_SAI6_IPG_STOP_MASK  (0x100U)
#define AUDIOMIX_IPG_LP_CTRL_SAI6_IPG_STOP_SHIFT (8U)
/*! sai6_ipg_stop - SAI6 IPG_STOP Bit
 */
#define AUDIOMIX_IPG_LP_CTRL_SAI6_IPG_STOP(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_IPG_LP_CTRL_SAI6_IPG_STOP_SHIFT)) & \
     AUDIOMIX_IPG_LP_CTRL_SAI6_IPG_STOP_MASK)
#define AUDIOMIX_IPG_LP_CTRL_SAI7_IPG_STOP_MASK  (0x200U)
#define AUDIOMIX_IPG_LP_CTRL_SAI7_IPG_STOP_SHIFT (9U)
/*! sai7_ipg_stop - SAI1 IPG_STOP Bit
 */
#define AUDIOMIX_IPG_LP_CTRL_SAI7_IPG_STOP(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_IPG_LP_CTRL_SAI7_IPG_STOP_SHIFT)) & \
     AUDIOMIX_IPG_LP_CTRL_SAI7_IPG_STOP_MASK)
#define AUDIOMIX_IPG_LP_CTRL_EDMA_IPG_STOP_ACK_MASK  (0x400U)
#define AUDIOMIX_IPG_LP_CTRL_EDMA_IPG_STOP_ACK_SHIFT (10U)
/*! edma_ipg_stop_ack - EDMA IPG_STOP_ACK Bit
 */
#define AUDIOMIX_IPG_LP_CTRL_EDMA_IPG_STOP_ACK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_IPG_LP_CTRL_EDMA_IPG_STOP_ACK_SHIFT)) & \
     AUDIOMIX_IPG_LP_CTRL_EDMA_IPG_STOP_ACK_MASK)
#define AUDIOMIX_IPG_LP_CTRL_SDMA2_IPG_STOP_ACK_MASK  (0x800U)
#define AUDIOMIX_IPG_LP_CTRL_SDMA2_IPG_STOP_ACK_SHIFT (11U)
/*! sdma2_ipg_stop_ack - SDMA2 IPG_STOP_ACK Bit
 */
#define AUDIOMIX_IPG_LP_CTRL_SDMA2_IPG_STOP_ACK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_IPG_LP_CTRL_SDMA2_IPG_STOP_ACK_SHIFT)) & \
     AUDIOMIX_IPG_LP_CTRL_SDMA2_IPG_STOP_ACK_MASK)
#define AUDIOMIX_IPG_LP_CTRL_SDMA3_IPG_STOP_ACK_MASK  (0x1000U)
#define AUDIOMIX_IPG_LP_CTRL_SDMA3_IPG_STOP_ACK_SHIFT (12U)
/*! sdma3_ipg_stop_ack - SDMA3 IPG_STOP_ACK Bit
 */
#define AUDIOMIX_IPG_LP_CTRL_SDMA3_IPG_STOP_ACK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_IPG_LP_CTRL_SDMA3_IPG_STOP_ACK_SHIFT)) & \
     AUDIOMIX_IPG_LP_CTRL_SDMA3_IPG_STOP_ACK_MASK)
#define AUDIOMIX_IPG_LP_CTRL_PDM_IPG_STOP_ACK_MASK  (0x2000U)
#define AUDIOMIX_IPG_LP_CTRL_PDM_IPG_STOP_ACK_SHIFT (13U)
/*! pdm_ipg_stop_ack - PDM IPG_STOP_ACK Bit
 */
#define AUDIOMIX_IPG_LP_CTRL_PDM_IPG_STOP_ACK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_IPG_LP_CTRL_PDM_IPG_STOP_ACK_SHIFT)) & \
     AUDIOMIX_IPG_LP_CTRL_PDM_IPG_STOP_ACK_MASK)
#define AUDIOMIX_IPG_LP_CTRL_SAI1_IPG_STOP_ACK_MASK  (0x4000U)
#define AUDIOMIX_IPG_LP_CTRL_SAI1_IPG_STOP_ACK_SHIFT (14U)
/*! sai1_ipg_stop_ack - SAI1 IPG_STOP_ACK Bit
 */
#define AUDIOMIX_IPG_LP_CTRL_SAI1_IPG_STOP_ACK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_IPG_LP_CTRL_SAI1_IPG_STOP_ACK_SHIFT)) & \
     AUDIOMIX_IPG_LP_CTRL_SAI1_IPG_STOP_ACK_MASK)
#define AUDIOMIX_IPG_LP_CTRL_SAI2_IPG_STOP_ACK_MASK  (0x8000U)
#define AUDIOMIX_IPG_LP_CTRL_SAI2_IPG_STOP_ACK_SHIFT (15U)
/*! sai2_ipg_stop_ack - SAI2 IPG_STOP_ACK Bit
 */
#define AUDIOMIX_IPG_LP_CTRL_SAI2_IPG_STOP_ACK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_IPG_LP_CTRL_SAI2_IPG_STOP_ACK_SHIFT)) & \
     AUDIOMIX_IPG_LP_CTRL_SAI2_IPG_STOP_ACK_MASK)
#define AUDIOMIX_IPG_LP_CTRL_SAI3_IPG_STOP_ACK_MASK  (0x10000U)
#define AUDIOMIX_IPG_LP_CTRL_SAI3_IPG_STOP_ACK_SHIFT (16U)
/*! sai3_ipg_stop_ack - SAI3 IPG_STOP_ACK Bit
 */
#define AUDIOMIX_IPG_LP_CTRL_SAI3_IPG_STOP_ACK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_IPG_LP_CTRL_SAI3_IPG_STOP_ACK_SHIFT)) & \
     AUDIOMIX_IPG_LP_CTRL_SAI3_IPG_STOP_ACK_MASK)
#define AUDIOMIX_IPG_LP_CTRL_SAI5_IPG_STOP_ACK_MASK  (0x20000U)
#define AUDIOMIX_IPG_LP_CTRL_SAI5_IPG_STOP_ACK_SHIFT (17U)
/*! sai5_ipg_stop_ack - SAI5 IPG_STOP_ACK Bit
 */
#define AUDIOMIX_IPG_LP_CTRL_SAI5_IPG_STOP_ACK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_IPG_LP_CTRL_SAI5_IPG_STOP_ACK_SHIFT)) & \
     AUDIOMIX_IPG_LP_CTRL_SAI5_IPG_STOP_ACK_MASK)
#define AUDIOMIX_IPG_LP_CTRL_SAI6_IPG_STOP_ACK_MASK  (0x40000U)
#define AUDIOMIX_IPG_LP_CTRL_SAI6_IPG_STOP_ACK_SHIFT (18U)
/*! sai6_ipg_stop_ack - SAI6 IPG_STOP_ACK Bit
 */
#define AUDIOMIX_IPG_LP_CTRL_SAI6_IPG_STOP_ACK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_IPG_LP_CTRL_SAI6_IPG_STOP_ACK_SHIFT)) & \
     AUDIOMIX_IPG_LP_CTRL_SAI6_IPG_STOP_ACK_MASK)
#define AUDIOMIX_IPG_LP_CTRL_SAI7_IPG_STOP_ACK_MASK  (0x80000U)
#define AUDIOMIX_IPG_LP_CTRL_SAI7_IPG_STOP_ACK_SHIFT (19U)
/*! sai7_ipg_stop_ack - SAI1 IPG_STOP_ACK Bit
 */
#define AUDIOMIX_IPG_LP_CTRL_SAI7_IPG_STOP_ACK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_IPG_LP_CTRL_SAI7_IPG_STOP_ACK_SHIFT)) & \
     AUDIOMIX_IPG_LP_CTRL_SAI7_IPG_STOP_ACK_MASK)
/*! @} */

/*! @name AUDIO_AXI_LIMIT - AUDIOMIX AXI LIMIT CTRL Register */
/*! @{ */
#define AUDIOMIX_AUDIO_AXI_LIMIT_ENABLE_MASK  (0x1U)
#define AUDIOMIX_AUDIO_AXI_LIMIT_ENABLE_SHIFT (0U)
/*! enable - AXI Limit enable
 */
#define AUDIOMIX_AUDIO_AXI_LIMIT_ENABLE(x) \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_AUDIO_AXI_LIMIT_ENABLE_SHIFT)) & AUDIOMIX_AUDIO_AXI_LIMIT_ENABLE_MASK)
#define AUDIOMIX_AUDIO_AXI_LIMIT_BEAT_LIMIT_MASK  (0xFFFF0U)
#define AUDIOMIX_AUDIO_AXI_LIMIT_BEAT_LIMIT_SHIFT (4U)
/*! BEAT_LIMIT - Beat Limit. Limit the burst beat number from AudioDSP.
 */
#define AUDIOMIX_AUDIO_AXI_LIMIT_BEAT_LIMIT(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << AUDIOMIX_AUDIO_AXI_LIMIT_BEAT_LIMIT_SHIFT)) & \
     AUDIOMIX_AUDIO_AXI_LIMIT_BEAT_LIMIT_MASK)
/*! @} */

/*!
 * @}
 */ /* end of group AUDIOMIX_Register_Masks */

/* AUDIOMIX - Peripheral instance base addresses */
/** Peripheral AUDIOMIX base address */
#define AUDIOMIX_BASE (0x30E20000u)
/** Peripheral AUDIOMIX base pointer */
#define AUDIOMIX ((AUDIOMIX_Type *)AUDIOMIX_BASE)
/** Array initializer of AUDIOMIX peripheral base addresses */
#define AUDIOMIX_BASE_ADDRS \
    {                       \
        AUDIOMIX_BASE       \
    }
/** Array initializer of AUDIOMIX peripheral base pointers */
#define AUDIOMIX_BASE_PTRS \
    {                      \
        AUDIOMIX           \
    }

/*!
 * @}
 */ /* end of group AUDIOMIX_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- AUDIOPACKETIZER Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AUDIOPACKETIZER_Peripheral_Access_Layer AUDIOPACKETIZER Peripheral Access Layer
 * @{
 */

/** AUDIOPACKETIZER - Register Layout Typedef */
typedef struct
{
    __IO uint8_t AUD_N1;    /**< Audio Clock Regenerator N Value Register 1 For N expected values, refer to the HDMI 1.,
                               offset: 0x0 */
    __IO uint8_t AUD_N2;    /**< Audio Clock Regenerator N Value Register 2 For N expected values, refer to the HDMI 1.,
                               offset: 0x1 */
    __IO uint8_t AUD_N3;    /**< Audio Clock Regenerator N Value Register 3 For N expected values, refer to the HDMI 1.,
                               offset: 0x2 */
    __IO uint8_t AUD_CTS1;  /**< Audio Clock Regenerator CTS Value Register 1 For CTS expected values, refer to the
                               HDMI 1., offset: 0x3 */
    __IO uint8_t AUD_CTS2;  /**< Audio Clock Regenerator CTS Register 2 For CTS expected values, refer to the HDMI 1.,
                               offset: 0x4 */
    __IO uint8_t AUD_CTS3;  /**< Audio Clock Regenerator CTS value Register 3., offset: 0x5 */
    uint8_t AUD_INPUTCLKFS; /**< Audio Input Clock FS Factor Register, offset: 0x6 */
    __IO uint8_t AUD_CTS_DITHER; /**< Audio CTS Dither Register, offset: 0x7 */
} AUDIOPACKETIZER_Type;

/* ----------------------------------------------------------------------------
   -- AUDIOPACKETIZER Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AUDIOPACKETIZER_Register_Masks AUDIOPACKETIZER Register Masks
 * @{
 */

/*! @name AUD_N1 - Audio Clock Regenerator N Value Register 1 For N expected values, refer to the HDMI 1. */
/*! @{ */
#define AUDIOPACKETIZER_AUD_N1_AUDN_MASK  (0xFFU)
#define AUDIOPACKETIZER_AUD_N1_AUDN_SHIFT (0U)
/*! AudN - HDMI Audio Clock Regenerator N value
 */
#define AUDIOPACKETIZER_AUD_N1_AUDN(x) \
    (((uint8_t)(((uint8_t)(x)) << AUDIOPACKETIZER_AUD_N1_AUDN_SHIFT)) & AUDIOPACKETIZER_AUD_N1_AUDN_MASK)
/*! @} */

/*! @name AUD_N2 - Audio Clock Regenerator N Value Register 2 For N expected values, refer to the HDMI 1. */
/*! @{ */
#define AUDIOPACKETIZER_AUD_N2_AUDN_MASK  (0xFFU)
#define AUDIOPACKETIZER_AUD_N2_AUDN_SHIFT (0U)
/*! AudN - HDMI Audio Clock Regenerator N value
 */
#define AUDIOPACKETIZER_AUD_N2_AUDN(x) \
    (((uint8_t)(((uint8_t)(x)) << AUDIOPACKETIZER_AUD_N2_AUDN_SHIFT)) & AUDIOPACKETIZER_AUD_N2_AUDN_MASK)
/*! @} */

/*! @name AUD_N3 - Audio Clock Regenerator N Value Register 3 For N expected values, refer to the HDMI 1. */
/*! @{ */
#define AUDIOPACKETIZER_AUD_N3_AUDN_MASK  (0xFU)
#define AUDIOPACKETIZER_AUD_N3_AUDN_SHIFT (0U)
/*! AudN - HDMI Audio Clock Regenerator N value
 */
#define AUDIOPACKETIZER_AUD_N3_AUDN(x) \
    (((uint8_t)(((uint8_t)(x)) << AUDIOPACKETIZER_AUD_N3_AUDN_SHIFT)) & AUDIOPACKETIZER_AUD_N3_AUDN_MASK)
#define AUDIOPACKETIZER_AUD_N3_NCTS_ATOMIC_WRITE_MASK  (0x80U)
#define AUDIOPACKETIZER_AUD_N3_NCTS_ATOMIC_WRITE_SHIFT (7U)
/*! ncts_atomic_write - When set, the new N and CTS values are only used when aud_n1 register is written.
 */
#define AUDIOPACKETIZER_AUD_N3_NCTS_ATOMIC_WRITE(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << AUDIOPACKETIZER_AUD_N3_NCTS_ATOMIC_WRITE_SHIFT)) & \
     AUDIOPACKETIZER_AUD_N3_NCTS_ATOMIC_WRITE_MASK)
/*! @} */

/*! @name AUD_CTS1 - Audio Clock Regenerator CTS Value Register 1 For CTS expected values, refer to the HDMI 1. */
/*! @{ */
#define AUDIOPACKETIZER_AUD_CTS1_AUDCTS_MASK  (0xFFU)
#define AUDIOPACKETIZER_AUD_CTS1_AUDCTS_SHIFT (0U)
/*! AudCTS - HDMI Audio Clock Regenerator CTS calculated value.
 */
#define AUDIOPACKETIZER_AUD_CTS1_AUDCTS(x) \
    (((uint8_t)(((uint8_t)(x)) << AUDIOPACKETIZER_AUD_CTS1_AUDCTS_SHIFT)) & AUDIOPACKETIZER_AUD_CTS1_AUDCTS_MASK)
/*! @} */

/*! @name AUD_CTS2 - Audio Clock Regenerator CTS Register 2 For CTS expected values, refer to the HDMI 1. */
/*! @{ */
#define AUDIOPACKETIZER_AUD_CTS2_AUDCTS_MASK  (0xFFU)
#define AUDIOPACKETIZER_AUD_CTS2_AUDCTS_SHIFT (0U)
/*! AudCTS - HDMI Audio Clock Regenerator CTS calculated value.
 */
#define AUDIOPACKETIZER_AUD_CTS2_AUDCTS(x) \
    (((uint8_t)(((uint8_t)(x)) << AUDIOPACKETIZER_AUD_CTS2_AUDCTS_SHIFT)) & AUDIOPACKETIZER_AUD_CTS2_AUDCTS_MASK)
/*! @} */

/*! @name AUD_CTS3 - Audio Clock Regenerator CTS value Register 3. */
/*! @{ */
#define AUDIOPACKETIZER_AUD_CTS3_AUDCTS_MASK  (0xFU)
#define AUDIOPACKETIZER_AUD_CTS3_AUDCTS_SHIFT (0U)
/*! AudCTS - HDMI Audio Clock Regenerator CTS calculated value.
 */
#define AUDIOPACKETIZER_AUD_CTS3_AUDCTS(x) \
    (((uint8_t)(((uint8_t)(x)) << AUDIOPACKETIZER_AUD_CTS3_AUDCTS_SHIFT)) & AUDIOPACKETIZER_AUD_CTS3_AUDCTS_MASK)
#define AUDIOPACKETIZER_AUD_CTS3_CTS_MANUAL_MASK  (0x10U)
#define AUDIOPACKETIZER_AUD_CTS3_CTS_MANUAL_SHIFT (4U)
/*! CTS_manual - If the CTS_manual bit equals 0b, this registers contains audCTS[19:0] generated by
 *    the Cycle time counter according to the specified timing.
 */
#define AUDIOPACKETIZER_AUD_CTS3_CTS_MANUAL(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << AUDIOPACKETIZER_AUD_CTS3_CTS_MANUAL_SHIFT)) & \
     AUDIOPACKETIZER_AUD_CTS3_CTS_MANUAL_MASK)
#define AUDIOPACKETIZER_AUD_CTS3_SPARE_MASK  (0xE0U)
#define AUDIOPACKETIZER_AUD_CTS3_SPARE_SHIFT (5U)
/*! spare - Reserved as "spare" bit with no associated functionality.
 */
#define AUDIOPACKETIZER_AUD_CTS3_SPARE(x) \
    (((uint8_t)(((uint8_t)(x)) << AUDIOPACKETIZER_AUD_CTS3_SPARE_SHIFT)) & AUDIOPACKETIZER_AUD_CTS3_SPARE_MASK)
/*! @} */

/*! @name AUD_CTS_DITHER - Audio CTS Dither Register */
/*! @{ */
#define AUDIOPACKETIZER_AUD_CTS_DITHER_DIVISOR_MASK  (0xFU)
#define AUDIOPACKETIZER_AUD_CTS_DITHER_DIVISOR_SHIFT (0U)
/*! divisor - Dither divisor (4'd1 if no CTS Dither) This field should be configured with the value
 *    of divisor from the HDMI specification.
 */
#define AUDIOPACKETIZER_AUD_CTS_DITHER_DIVISOR(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << AUDIOPACKETIZER_AUD_CTS_DITHER_DIVISOR_SHIFT)) & \
     AUDIOPACKETIZER_AUD_CTS_DITHER_DIVISOR_MASK)
#define AUDIOPACKETIZER_AUD_CTS_DITHER_DIVIDEND_MASK  (0xF0U)
#define AUDIOPACKETIZER_AUD_CTS_DITHER_DIVIDEND_SHIFT (4U)
/*! dividend - Dither dividend (4'd1 if no CTS Dither) This field should be configured with the
 *    value of dividend from the HDMI specification.
 */
#define AUDIOPACKETIZER_AUD_CTS_DITHER_DIVIDEND(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << AUDIOPACKETIZER_AUD_CTS_DITHER_DIVIDEND_SHIFT)) & \
     AUDIOPACKETIZER_AUD_CTS_DITHER_DIVIDEND_MASK)
/*! @} */

/*!
 * @}
 */ /* end of group AUDIOPACKETIZER_Register_Masks */

/* AUDIOPACKETIZER - Peripheral instance base addresses */
/** Peripheral AUDIOPACKETIZER base address */
#define AUDIOPACKETIZER_BASE (0x32FDB200u)
/** Peripheral AUDIOPACKETIZER base pointer */
#define AUDIOPACKETIZER ((AUDIOPACKETIZER_Type *)AUDIOPACKETIZER_BASE)
/** Array initializer of AUDIOPACKETIZER peripheral base addresses */
#define AUDIOPACKETIZER_BASE_ADDRS \
    {                              \
        AUDIOPACKETIZER_BASE       \
    }
/** Array initializer of AUDIOPACKETIZER peripheral base pointers */
#define AUDIOPACKETIZER_BASE_PTRS \
    {                             \
        AUDIOPACKETIZER           \
    }

/*!
 * @}
 */ /* end of group AUDIOPACKETIZER_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- AUDIOSAMPLEGP Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AUDIOSAMPLEGP_Peripheral_Access_Layer AUDIOSAMPLEGP Peripheral Access Layer
 * @{
 */

/** AUDIOSAMPLEGP - Register Layout Typedef */
typedef struct
{
    __IO uint8_t GP_CONF0; /**< Audio GPA Software FIFO Reset Control Register 0, offset: 0x0 */
    __IO uint8_t GP_CONF1; /**< Audio GPA Channel Enable Configuration Register 1, offset: 0x1 */
    __IO uint8_t GP_CONF2; /**< Audio GPA HBR Enable Register 2, offset: 0x2 */
    uint8_t RESERVED_0[3];
    __IO uint8_t GP_MASK; /**< Audio GPA FIFO Full and Empty Mask Interrupt Register, offset: 0x6 */
} AUDIOSAMPLEGP_Type;

/* ----------------------------------------------------------------------------
   -- AUDIOSAMPLEGP Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AUDIOSAMPLEGP_Register_Masks AUDIOSAMPLEGP Register Masks
 * @{
 */

/*! @name GP_CONF0 - Audio GPA Software FIFO Reset Control Register 0 */
/*! @{ */
#define AUDIOSAMPLEGP_GP_CONF0_SW_AUDIO_FIFO_RST_MASK  (0x1U)
#define AUDIOSAMPLEGP_GP_CONF0_SW_AUDIO_FIFO_RST_SHIFT (0U)
/*! sw_audio_fifo_rst - Audio FIFOs software reset - Writing 0b: no action taken - Writing 1b:
 *    Resets all audio FIFOs Reading from this register always returns 0b.
 */
#define AUDIOSAMPLEGP_GP_CONF0_SW_AUDIO_FIFO_RST(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << AUDIOSAMPLEGP_GP_CONF0_SW_AUDIO_FIFO_RST_SHIFT)) & \
     AUDIOSAMPLEGP_GP_CONF0_SW_AUDIO_FIFO_RST_MASK)
/*! @} */

/*! @name GP_CONF1 - Audio GPA Channel Enable Configuration Register 1 */
/*! @{ */
#define AUDIOSAMPLEGP_GP_CONF1_CH_IN_EN_MASK  (0xFFU)
#define AUDIOSAMPLEGP_GP_CONF1_CH_IN_EN_SHIFT (0U)
/*! ch_in_en - Each bit controls the enabling of the respective audio channel.
 */
#define AUDIOSAMPLEGP_GP_CONF1_CH_IN_EN(x) \
    (((uint8_t)(((uint8_t)(x)) << AUDIOSAMPLEGP_GP_CONF1_CH_IN_EN_SHIFT)) & AUDIOSAMPLEGP_GP_CONF1_CH_IN_EN_MASK)
/*! @} */

/*! @name GP_CONF2 - Audio GPA HBR Enable Register 2 */
/*! @{ */
#define AUDIOSAMPLEGP_GP_CONF2_HBR_MASK  (0x1U)
#define AUDIOSAMPLEGP_GP_CONF2_HBR_SHIFT (0U)
/*! HBR - HBR packets enable.
 */
#define AUDIOSAMPLEGP_GP_CONF2_HBR(x) \
    (((uint8_t)(((uint8_t)(x)) << AUDIOSAMPLEGP_GP_CONF2_HBR_SHIFT)) & AUDIOSAMPLEGP_GP_CONF2_HBR_MASK)
#define AUDIOSAMPLEGP_GP_CONF2_INSERT_PCUV_MASK  (0x2U)
#define AUDIOSAMPLEGP_GP_CONF2_INSERT_PCUV_SHIFT (1U)
/*! insert_pcuv - When set (1'b1), this bit enables the insertion of the PCUV (Parity, Channel
 *    Status, User bit and Validity) bits on the incoming audio stream (support limited to Linear PCM
 *    audio).
 */
#define AUDIOSAMPLEGP_GP_CONF2_INSERT_PCUV(x) \
    (((uint8_t)(((uint8_t)(x)) << AUDIOSAMPLEGP_GP_CONF2_INSERT_PCUV_SHIFT)) & AUDIOSAMPLEGP_GP_CONF2_INSERT_PCUV_MASK)
/*! @} */

/*! @name GP_MASK - Audio GPA FIFO Full and Empty Mask Interrupt Register */
/*! @{ */
#define AUDIOSAMPLEGP_GP_MASK_FIFO_FULL_MASK_MASK  (0x1U)
#define AUDIOSAMPLEGP_GP_MASK_FIFO_FULL_MASK_SHIFT (0U)
/*! fifo_full_mask - FIFO full flag mask
 */
#define AUDIOSAMPLEGP_GP_MASK_FIFO_FULL_MASK(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << AUDIOSAMPLEGP_GP_MASK_FIFO_FULL_MASK_SHIFT)) & \
     AUDIOSAMPLEGP_GP_MASK_FIFO_FULL_MASK_MASK)
#define AUDIOSAMPLEGP_GP_MASK_FIFO_EMPTY_MASK_MASK  (0x2U)
#define AUDIOSAMPLEGP_GP_MASK_FIFO_EMPTY_MASK_SHIFT (1U)
/*! fifo_empty_mask - FIFO empty flag mask
 */
#define AUDIOSAMPLEGP_GP_MASK_FIFO_EMPTY_MASK(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << AUDIOSAMPLEGP_GP_MASK_FIFO_EMPTY_MASK_SHIFT)) & \
     AUDIOSAMPLEGP_GP_MASK_FIFO_EMPTY_MASK_MASK)
#define AUDIOSAMPLEGP_GP_MASK_FIFO_OVERRUN_MASK_MASK  (0x10U)
#define AUDIOSAMPLEGP_GP_MASK_FIFO_OVERRUN_MASK_SHIFT (4U)
/*! fifo_overrun_mask - FIFO overrun mask
 */
#define AUDIOSAMPLEGP_GP_MASK_FIFO_OVERRUN_MASK(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << AUDIOSAMPLEGP_GP_MASK_FIFO_OVERRUN_MASK_SHIFT)) & \
     AUDIOSAMPLEGP_GP_MASK_FIFO_OVERRUN_MASK_MASK)
/*! @} */

/*!
 * @}
 */ /* end of group AUDIOSAMPLEGP_Register_Masks */

/* AUDIOSAMPLEGP - Peripheral instance base addresses */
/** Peripheral AUDIOSAMPLEGP base address */
#define AUDIOSAMPLEGP_BASE (0x32FDB500u)
/** Peripheral AUDIOSAMPLEGP base pointer */
#define AUDIOSAMPLEGP ((AUDIOSAMPLEGP_Type *)AUDIOSAMPLEGP_BASE)
/** Array initializer of AUDIOSAMPLEGP peripheral base addresses */
#define AUDIOSAMPLEGP_BASE_ADDRS \
    {                            \
        AUDIOSAMPLEGP_BASE       \
    }
/** Array initializer of AUDIOSAMPLEGP peripheral base pointers */
#define AUDIOSAMPLEGP_BASE_PTRS \
    {                           \
        AUDIOSAMPLEGP           \
    }

/*!
 * @}
 */ /* end of group AUDIOSAMPLEGP_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- BCH Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup BCH_Peripheral_Access_Layer BCH Peripheral Access Layer
 * @{
 */

/** BCH - Register Layout Typedef */
typedef struct
{
    __IO uint32_t CTRL;     /**< Hardware BCH ECC Accelerator Control Register, offset: 0x0 */
    __IO uint32_t CTRL_SET; /**< Hardware BCH ECC Accelerator Control Register, offset: 0x4 */
    __IO uint32_t CTRL_CLR; /**< Hardware BCH ECC Accelerator Control Register, offset: 0x8 */
    __IO uint32_t CTRL_TOG; /**< Hardware BCH ECC Accelerator Control Register, offset: 0xC */
    __I uint32_t STATUS0;   /**< Hardware ECC Accelerator Status Register 0, offset: 0x10 */
    uint8_t RESERVED_0[12];
    __IO uint32_t MODE; /**< Hardware ECC Accelerator Mode Register, offset: 0x20 */
    uint8_t RESERVED_1[12];
    __IO uint32_t ENCODEPTR; /**< Hardware BCH ECC Loopback Encode Buffer Register, offset: 0x30 */
    uint8_t RESERVED_2[12];
    __IO uint32_t DATAPTR; /**< Hardware BCH ECC Loopback Data Buffer Register, offset: 0x40 */
    uint8_t RESERVED_3[12];
    __IO uint32_t METAPTR; /**< Hardware BCH ECC Loopback Metadata Buffer Register, offset: 0x50 */
    uint8_t RESERVED_4[28];
    __IO uint32_t LAYOUTSELECT; /**< Hardware ECC Accelerator Layout Select Register, offset: 0x70 */
    uint8_t RESERVED_5[12];
    __IO uint32_t FLASH0LAYOUT0; /**< Hardware BCH ECC Flash 0 Layout 0 Register, offset: 0x80 */
    uint8_t RESERVED_6[12];
    __IO uint32_t FLASH0LAYOUT1; /**< Hardware BCH ECC Flash 0 Layout 1 Register, offset: 0x90 */
    uint8_t RESERVED_7[12];
    __IO uint32_t FLASH1LAYOUT0; /**< Hardware BCH ECC Flash 1 Layout 0 Register, offset: 0xA0 */
    uint8_t RESERVED_8[12];
    __IO uint32_t FLASH1LAYOUT1; /**< Hardware BCH ECC Flash 1 Layout 1 Register, offset: 0xB0 */
    uint8_t RESERVED_9[12];
    __IO uint32_t FLASH2LAYOUT0; /**< Hardware BCH ECC Flash 2 Layout 0 Register, offset: 0xC0 */
    uint8_t RESERVED_10[12];
    __IO uint32_t FLASH2LAYOUT1; /**< Hardware BCH ECC Flash 2 Layout 1 Register, offset: 0xD0 */
    uint8_t RESERVED_11[12];
    __IO uint32_t FLASH3LAYOUT0; /**< Hardware BCH ECC Flash 3 Layout 0 Register, offset: 0xE0 */
    uint8_t RESERVED_12[12];
    __IO uint32_t FLASH3LAYOUT1; /**< Hardware BCH ECC Flash 3 Layout 1 Register, offset: 0xF0 */
    uint8_t RESERVED_13[12];
    __IO uint32_t DEBUG0;     /**< Hardware BCH ECC Debug Register0, offset: 0x100 */
    __IO uint32_t DEBUG0_SET; /**< Hardware BCH ECC Debug Register0, offset: 0x104 */
    __IO uint32_t DEBUG0_CLR; /**< Hardware BCH ECC Debug Register0, offset: 0x108 */
    __IO uint32_t DEBUG0_TOG; /**< Hardware BCH ECC Debug Register0, offset: 0x10C */
    __I uint32_t DBGKESREAD;  /**< KES Debug Read Register, offset: 0x110 */
    uint8_t RESERVED_14[12];
    __I uint32_t DBGCSFEREAD; /**< Chien Search Debug Read Register, offset: 0x120 */
    uint8_t RESERVED_15[12];
    __I uint32_t DBGSYNDGENREAD; /**< Syndrome Generator Debug Read Register, offset: 0x130 */
    uint8_t RESERVED_16[12];
    __I uint32_t DBGAHBMREAD; /**< Bus Master and ECC Controller Debug Read Register, offset: 0x140 */
    uint8_t RESERVED_17[12];
    __I uint32_t BLOCKNAME; /**< Block Name Register, offset: 0x150 */
    uint8_t RESERVED_18[12];
    __I uint32_t VERSION; /**< BCH Version Register, offset: 0x160 */
    uint8_t RESERVED_19[12];
    __IO uint32_t DEBUG1; /**< Hardware BCH ECC Debug Register 1, offset: 0x170 */
} BCH_Type;

/* ----------------------------------------------------------------------------
   -- BCH Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup BCH_Register_Masks BCH Register Masks
 * @{
 */

/*! @name CTRL - Hardware BCH ECC Accelerator Control Register */
/*! @{ */
#define BCH_CTRL_COMPLETE_IRQ_MASK  (0x1U)
#define BCH_CTRL_COMPLETE_IRQ_SHIFT (0U)
#define BCH_CTRL_COMPLETE_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_COMPLETE_IRQ_SHIFT)) & BCH_CTRL_COMPLETE_IRQ_MASK)
#define BCH_CTRL_RSVD0_MASK  (0x2U)
#define BCH_CTRL_RSVD0_SHIFT (1U)
/*! RSVD0 - This field is reserved.
 */
#define BCH_CTRL_RSVD0(x)              (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_RSVD0_SHIFT)) & BCH_CTRL_RSVD0_MASK)
#define BCH_CTRL_DEBUG_STALL_IRQ_MASK  (0x4U)
#define BCH_CTRL_DEBUG_STALL_IRQ_SHIFT (2U)
#define BCH_CTRL_DEBUG_STALL_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_DEBUG_STALL_IRQ_SHIFT)) & BCH_CTRL_DEBUG_STALL_IRQ_MASK)
#define BCH_CTRL_BM_ERROR_IRQ_MASK  (0x8U)
#define BCH_CTRL_BM_ERROR_IRQ_SHIFT (3U)
#define BCH_CTRL_BM_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_BM_ERROR_IRQ_SHIFT)) & BCH_CTRL_BM_ERROR_IRQ_MASK)
#define BCH_CTRL_RSVD1_MASK  (0xF0U)
#define BCH_CTRL_RSVD1_SHIFT (4U)
/*! RSVD1 - This field is reserved.
 */
#define BCH_CTRL_RSVD1(x)              (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_RSVD1_SHIFT)) & BCH_CTRL_RSVD1_MASK)
#define BCH_CTRL_COMPLETE_IRQ_EN_MASK  (0x100U)
#define BCH_CTRL_COMPLETE_IRQ_EN_SHIFT (8U)
#define BCH_CTRL_COMPLETE_IRQ_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_COMPLETE_IRQ_EN_SHIFT)) & BCH_CTRL_COMPLETE_IRQ_EN_MASK)
#define BCH_CTRL_RSVD2_MASK  (0x200U)
#define BCH_CTRL_RSVD2_SHIFT (9U)
/*! RSVD2 - This field is reserved.
 */
#define BCH_CTRL_RSVD2(x)                 (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_RSVD2_SHIFT)) & BCH_CTRL_RSVD2_MASK)
#define BCH_CTRL_DEBUG_STALL_IRQ_EN_MASK  (0x400U)
#define BCH_CTRL_DEBUG_STALL_IRQ_EN_SHIFT (10U)
#define BCH_CTRL_DEBUG_STALL_IRQ_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_DEBUG_STALL_IRQ_EN_SHIFT)) & BCH_CTRL_DEBUG_STALL_IRQ_EN_MASK)
#define BCH_CTRL_RSVD3_MASK  (0xF800U)
#define BCH_CTRL_RSVD3_SHIFT (11U)
/*! RSVD3 - This field is reserved.
 */
#define BCH_CTRL_RSVD3(x)         (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_RSVD3_SHIFT)) & BCH_CTRL_RSVD3_MASK)
#define BCH_CTRL_M2M_ENABLE_MASK  (0x10000U)
#define BCH_CTRL_M2M_ENABLE_SHIFT (16U)
#define BCH_CTRL_M2M_ENABLE(x)    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_M2M_ENABLE_SHIFT)) & BCH_CTRL_M2M_ENABLE_MASK)
#define BCH_CTRL_M2M_ENCODE_MASK  (0x20000U)
#define BCH_CTRL_M2M_ENCODE_SHIFT (17U)
#define BCH_CTRL_M2M_ENCODE(x)    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_M2M_ENCODE_SHIFT)) & BCH_CTRL_M2M_ENCODE_MASK)
#define BCH_CTRL_M2M_LAYOUT_MASK  (0xC0000U)
#define BCH_CTRL_M2M_LAYOUT_SHIFT (18U)
#define BCH_CTRL_M2M_LAYOUT(x)    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_M2M_LAYOUT_SHIFT)) & BCH_CTRL_M2M_LAYOUT_MASK)
#define BCH_CTRL_RSVD4_MASK       (0x300000U)
#define BCH_CTRL_RSVD4_SHIFT      (20U)
/*! RSVD4 - This field is reserved.
 */
#define BCH_CTRL_RSVD4(x)            (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_RSVD4_SHIFT)) & BCH_CTRL_RSVD4_MASK)
#define BCH_CTRL_DEBUGSYNDROME_MASK  (0x400000U)
#define BCH_CTRL_DEBUGSYNDROME_SHIFT (22U)
#define BCH_CTRL_DEBUGSYNDROME(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_DEBUGSYNDROME_SHIFT)) & BCH_CTRL_DEBUGSYNDROME_MASK)
#define BCH_CTRL_RSVD5_MASK  (0x3F800000U)
#define BCH_CTRL_RSVD5_SHIFT (23U)
/*! RSVD5 - This field is reserved.
 */
#define BCH_CTRL_RSVD5(x)      (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_RSVD5_SHIFT)) & BCH_CTRL_RSVD5_MASK)
#define BCH_CTRL_CLKGATE_MASK  (0x40000000U)
#define BCH_CTRL_CLKGATE_SHIFT (30U)
/*! CLKGATE
 *  0b0..Allow BCH to operate normally.
 *  0b1..Do not clock BCH gates in order to minimize power consumption.
 */
#define BCH_CTRL_CLKGATE(x)   (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLKGATE_SHIFT)) & BCH_CTRL_CLKGATE_MASK)
#define BCH_CTRL_SFTRST_MASK  (0x80000000U)
#define BCH_CTRL_SFTRST_SHIFT (31U)
/*! SFTRST
 *  0b0..Allow BCH to operate normally.
 *  0b1..Hold BCH in reset.
 */
#define BCH_CTRL_SFTRST(x) (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SFTRST_SHIFT)) & BCH_CTRL_SFTRST_MASK)
/*! @} */

/*! @name CTRL_SET - Hardware BCH ECC Accelerator Control Register */
/*! @{ */
#define BCH_CTRL_SET_COMPLETE_IRQ_MASK  (0x1U)
#define BCH_CTRL_SET_COMPLETE_IRQ_SHIFT (0U)
#define BCH_CTRL_SET_COMPLETE_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_COMPLETE_IRQ_SHIFT)) & BCH_CTRL_SET_COMPLETE_IRQ_MASK)
#define BCH_CTRL_SET_RSVD0_MASK  (0x2U)
#define BCH_CTRL_SET_RSVD0_SHIFT (1U)
/*! RSVD0 - This field is reserved.
 */
#define BCH_CTRL_SET_RSVD0(x)              (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_RSVD0_SHIFT)) & BCH_CTRL_SET_RSVD0_MASK)
#define BCH_CTRL_SET_DEBUG_STALL_IRQ_MASK  (0x4U)
#define BCH_CTRL_SET_DEBUG_STALL_IRQ_SHIFT (2U)
#define BCH_CTRL_SET_DEBUG_STALL_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_DEBUG_STALL_IRQ_SHIFT)) & BCH_CTRL_SET_DEBUG_STALL_IRQ_MASK)
#define BCH_CTRL_SET_BM_ERROR_IRQ_MASK  (0x8U)
#define BCH_CTRL_SET_BM_ERROR_IRQ_SHIFT (3U)
#define BCH_CTRL_SET_BM_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_BM_ERROR_IRQ_SHIFT)) & BCH_CTRL_SET_BM_ERROR_IRQ_MASK)
#define BCH_CTRL_SET_RSVD1_MASK  (0xF0U)
#define BCH_CTRL_SET_RSVD1_SHIFT (4U)
/*! RSVD1 - This field is reserved.
 */
#define BCH_CTRL_SET_RSVD1(x)              (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_RSVD1_SHIFT)) & BCH_CTRL_SET_RSVD1_MASK)
#define BCH_CTRL_SET_COMPLETE_IRQ_EN_MASK  (0x100U)
#define BCH_CTRL_SET_COMPLETE_IRQ_EN_SHIFT (8U)
#define BCH_CTRL_SET_COMPLETE_IRQ_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_COMPLETE_IRQ_EN_SHIFT)) & BCH_CTRL_SET_COMPLETE_IRQ_EN_MASK)
#define BCH_CTRL_SET_RSVD2_MASK  (0x200U)
#define BCH_CTRL_SET_RSVD2_SHIFT (9U)
/*! RSVD2 - This field is reserved.
 */
#define BCH_CTRL_SET_RSVD2(x)                 (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_RSVD2_SHIFT)) & BCH_CTRL_SET_RSVD2_MASK)
#define BCH_CTRL_SET_DEBUG_STALL_IRQ_EN_MASK  (0x400U)
#define BCH_CTRL_SET_DEBUG_STALL_IRQ_EN_SHIFT (10U)
#define BCH_CTRL_SET_DEBUG_STALL_IRQ_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_DEBUG_STALL_IRQ_EN_SHIFT)) & BCH_CTRL_SET_DEBUG_STALL_IRQ_EN_MASK)
#define BCH_CTRL_SET_RSVD3_MASK  (0xF800U)
#define BCH_CTRL_SET_RSVD3_SHIFT (11U)
/*! RSVD3 - This field is reserved.
 */
#define BCH_CTRL_SET_RSVD3(x)         (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_RSVD3_SHIFT)) & BCH_CTRL_SET_RSVD3_MASK)
#define BCH_CTRL_SET_M2M_ENABLE_MASK  (0x10000U)
#define BCH_CTRL_SET_M2M_ENABLE_SHIFT (16U)
#define BCH_CTRL_SET_M2M_ENABLE(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_M2M_ENABLE_SHIFT)) & BCH_CTRL_SET_M2M_ENABLE_MASK)
#define BCH_CTRL_SET_M2M_ENCODE_MASK  (0x20000U)
#define BCH_CTRL_SET_M2M_ENCODE_SHIFT (17U)
#define BCH_CTRL_SET_M2M_ENCODE(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_M2M_ENCODE_SHIFT)) & BCH_CTRL_SET_M2M_ENCODE_MASK)
#define BCH_CTRL_SET_M2M_LAYOUT_MASK  (0xC0000U)
#define BCH_CTRL_SET_M2M_LAYOUT_SHIFT (18U)
#define BCH_CTRL_SET_M2M_LAYOUT(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_M2M_LAYOUT_SHIFT)) & BCH_CTRL_SET_M2M_LAYOUT_MASK)
#define BCH_CTRL_SET_RSVD4_MASK  (0x300000U)
#define BCH_CTRL_SET_RSVD4_SHIFT (20U)
/*! RSVD4 - This field is reserved.
 */
#define BCH_CTRL_SET_RSVD4(x)            (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_RSVD4_SHIFT)) & BCH_CTRL_SET_RSVD4_MASK)
#define BCH_CTRL_SET_DEBUGSYNDROME_MASK  (0x400000U)
#define BCH_CTRL_SET_DEBUGSYNDROME_SHIFT (22U)
#define BCH_CTRL_SET_DEBUGSYNDROME(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_DEBUGSYNDROME_SHIFT)) & BCH_CTRL_SET_DEBUGSYNDROME_MASK)
#define BCH_CTRL_SET_RSVD5_MASK  (0x3F800000U)
#define BCH_CTRL_SET_RSVD5_SHIFT (23U)
/*! RSVD5 - This field is reserved.
 */
#define BCH_CTRL_SET_RSVD5(x)      (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_RSVD5_SHIFT)) & BCH_CTRL_SET_RSVD5_MASK)
#define BCH_CTRL_SET_CLKGATE_MASK  (0x40000000U)
#define BCH_CTRL_SET_CLKGATE_SHIFT (30U)
/*! CLKGATE
 *  0b0..Allow BCH to operate normally.
 *  0b1..Do not clock BCH gates in order to minimize power consumption.
 */
#define BCH_CTRL_SET_CLKGATE(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_CLKGATE_SHIFT)) & BCH_CTRL_SET_CLKGATE_MASK)
#define BCH_CTRL_SET_SFTRST_MASK  (0x80000000U)
#define BCH_CTRL_SET_SFTRST_SHIFT (31U)
/*! SFTRST
 *  0b0..Allow BCH to operate normally.
 *  0b1..Hold BCH in reset.
 */
#define BCH_CTRL_SET_SFTRST(x) (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_SET_SFTRST_SHIFT)) & BCH_CTRL_SET_SFTRST_MASK)
/*! @} */

/*! @name CTRL_CLR - Hardware BCH ECC Accelerator Control Register */
/*! @{ */
#define BCH_CTRL_CLR_COMPLETE_IRQ_MASK  (0x1U)
#define BCH_CTRL_CLR_COMPLETE_IRQ_SHIFT (0U)
#define BCH_CTRL_CLR_COMPLETE_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_COMPLETE_IRQ_SHIFT)) & BCH_CTRL_CLR_COMPLETE_IRQ_MASK)
#define BCH_CTRL_CLR_RSVD0_MASK  (0x2U)
#define BCH_CTRL_CLR_RSVD0_SHIFT (1U)
/*! RSVD0 - This field is reserved.
 */
#define BCH_CTRL_CLR_RSVD0(x)              (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_RSVD0_SHIFT)) & BCH_CTRL_CLR_RSVD0_MASK)
#define BCH_CTRL_CLR_DEBUG_STALL_IRQ_MASK  (0x4U)
#define BCH_CTRL_CLR_DEBUG_STALL_IRQ_SHIFT (2U)
#define BCH_CTRL_CLR_DEBUG_STALL_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_DEBUG_STALL_IRQ_SHIFT)) & BCH_CTRL_CLR_DEBUG_STALL_IRQ_MASK)
#define BCH_CTRL_CLR_BM_ERROR_IRQ_MASK  (0x8U)
#define BCH_CTRL_CLR_BM_ERROR_IRQ_SHIFT (3U)
#define BCH_CTRL_CLR_BM_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_BM_ERROR_IRQ_SHIFT)) & BCH_CTRL_CLR_BM_ERROR_IRQ_MASK)
#define BCH_CTRL_CLR_RSVD1_MASK  (0xF0U)
#define BCH_CTRL_CLR_RSVD1_SHIFT (4U)
/*! RSVD1 - This field is reserved.
 */
#define BCH_CTRL_CLR_RSVD1(x)              (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_RSVD1_SHIFT)) & BCH_CTRL_CLR_RSVD1_MASK)
#define BCH_CTRL_CLR_COMPLETE_IRQ_EN_MASK  (0x100U)
#define BCH_CTRL_CLR_COMPLETE_IRQ_EN_SHIFT (8U)
#define BCH_CTRL_CLR_COMPLETE_IRQ_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_COMPLETE_IRQ_EN_SHIFT)) & BCH_CTRL_CLR_COMPLETE_IRQ_EN_MASK)
#define BCH_CTRL_CLR_RSVD2_MASK  (0x200U)
#define BCH_CTRL_CLR_RSVD2_SHIFT (9U)
/*! RSVD2 - This field is reserved.
 */
#define BCH_CTRL_CLR_RSVD2(x)                 (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_RSVD2_SHIFT)) & BCH_CTRL_CLR_RSVD2_MASK)
#define BCH_CTRL_CLR_DEBUG_STALL_IRQ_EN_MASK  (0x400U)
#define BCH_CTRL_CLR_DEBUG_STALL_IRQ_EN_SHIFT (10U)
#define BCH_CTRL_CLR_DEBUG_STALL_IRQ_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_DEBUG_STALL_IRQ_EN_SHIFT)) & BCH_CTRL_CLR_DEBUG_STALL_IRQ_EN_MASK)
#define BCH_CTRL_CLR_RSVD3_MASK  (0xF800U)
#define BCH_CTRL_CLR_RSVD3_SHIFT (11U)
/*! RSVD3 - This field is reserved.
 */
#define BCH_CTRL_CLR_RSVD3(x)         (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_RSVD3_SHIFT)) & BCH_CTRL_CLR_RSVD3_MASK)
#define BCH_CTRL_CLR_M2M_ENABLE_MASK  (0x10000U)
#define BCH_CTRL_CLR_M2M_ENABLE_SHIFT (16U)
#define BCH_CTRL_CLR_M2M_ENABLE(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_M2M_ENABLE_SHIFT)) & BCH_CTRL_CLR_M2M_ENABLE_MASK)
#define BCH_CTRL_CLR_M2M_ENCODE_MASK  (0x20000U)
#define BCH_CTRL_CLR_M2M_ENCODE_SHIFT (17U)
#define BCH_CTRL_CLR_M2M_ENCODE(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_M2M_ENCODE_SHIFT)) & BCH_CTRL_CLR_M2M_ENCODE_MASK)
#define BCH_CTRL_CLR_M2M_LAYOUT_MASK  (0xC0000U)
#define BCH_CTRL_CLR_M2M_LAYOUT_SHIFT (18U)
#define BCH_CTRL_CLR_M2M_LAYOUT(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_M2M_LAYOUT_SHIFT)) & BCH_CTRL_CLR_M2M_LAYOUT_MASK)
#define BCH_CTRL_CLR_RSVD4_MASK  (0x300000U)
#define BCH_CTRL_CLR_RSVD4_SHIFT (20U)
/*! RSVD4 - This field is reserved.
 */
#define BCH_CTRL_CLR_RSVD4(x)            (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_RSVD4_SHIFT)) & BCH_CTRL_CLR_RSVD4_MASK)
#define BCH_CTRL_CLR_DEBUGSYNDROME_MASK  (0x400000U)
#define BCH_CTRL_CLR_DEBUGSYNDROME_SHIFT (22U)
#define BCH_CTRL_CLR_DEBUGSYNDROME(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_DEBUGSYNDROME_SHIFT)) & BCH_CTRL_CLR_DEBUGSYNDROME_MASK)
#define BCH_CTRL_CLR_RSVD5_MASK  (0x3F800000U)
#define BCH_CTRL_CLR_RSVD5_SHIFT (23U)
/*! RSVD5 - This field is reserved.
 */
#define BCH_CTRL_CLR_RSVD5(x)      (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_RSVD5_SHIFT)) & BCH_CTRL_CLR_RSVD5_MASK)
#define BCH_CTRL_CLR_CLKGATE_MASK  (0x40000000U)
#define BCH_CTRL_CLR_CLKGATE_SHIFT (30U)
/*! CLKGATE
 *  0b0..Allow BCH to operate normally.
 *  0b1..Do not clock BCH gates in order to minimize power consumption.
 */
#define BCH_CTRL_CLR_CLKGATE(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_CLKGATE_SHIFT)) & BCH_CTRL_CLR_CLKGATE_MASK)
#define BCH_CTRL_CLR_SFTRST_MASK  (0x80000000U)
#define BCH_CTRL_CLR_SFTRST_SHIFT (31U)
/*! SFTRST
 *  0b0..Allow BCH to operate normally.
 *  0b1..Hold BCH in reset.
 */
#define BCH_CTRL_CLR_SFTRST(x) (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_CLR_SFTRST_SHIFT)) & BCH_CTRL_CLR_SFTRST_MASK)
/*! @} */

/*! @name CTRL_TOG - Hardware BCH ECC Accelerator Control Register */
/*! @{ */
#define BCH_CTRL_TOG_COMPLETE_IRQ_MASK  (0x1U)
#define BCH_CTRL_TOG_COMPLETE_IRQ_SHIFT (0U)
#define BCH_CTRL_TOG_COMPLETE_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_COMPLETE_IRQ_SHIFT)) & BCH_CTRL_TOG_COMPLETE_IRQ_MASK)
#define BCH_CTRL_TOG_RSVD0_MASK  (0x2U)
#define BCH_CTRL_TOG_RSVD0_SHIFT (1U)
/*! RSVD0 - This field is reserved.
 */
#define BCH_CTRL_TOG_RSVD0(x)              (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_RSVD0_SHIFT)) & BCH_CTRL_TOG_RSVD0_MASK)
#define BCH_CTRL_TOG_DEBUG_STALL_IRQ_MASK  (0x4U)
#define BCH_CTRL_TOG_DEBUG_STALL_IRQ_SHIFT (2U)
#define BCH_CTRL_TOG_DEBUG_STALL_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_DEBUG_STALL_IRQ_SHIFT)) & BCH_CTRL_TOG_DEBUG_STALL_IRQ_MASK)
#define BCH_CTRL_TOG_BM_ERROR_IRQ_MASK  (0x8U)
#define BCH_CTRL_TOG_BM_ERROR_IRQ_SHIFT (3U)
#define BCH_CTRL_TOG_BM_ERROR_IRQ(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_BM_ERROR_IRQ_SHIFT)) & BCH_CTRL_TOG_BM_ERROR_IRQ_MASK)
#define BCH_CTRL_TOG_RSVD1_MASK  (0xF0U)
#define BCH_CTRL_TOG_RSVD1_SHIFT (4U)
/*! RSVD1 - This field is reserved.
 */
#define BCH_CTRL_TOG_RSVD1(x)              (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_RSVD1_SHIFT)) & BCH_CTRL_TOG_RSVD1_MASK)
#define BCH_CTRL_TOG_COMPLETE_IRQ_EN_MASK  (0x100U)
#define BCH_CTRL_TOG_COMPLETE_IRQ_EN_SHIFT (8U)
#define BCH_CTRL_TOG_COMPLETE_IRQ_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_COMPLETE_IRQ_EN_SHIFT)) & BCH_CTRL_TOG_COMPLETE_IRQ_EN_MASK)
#define BCH_CTRL_TOG_RSVD2_MASK  (0x200U)
#define BCH_CTRL_TOG_RSVD2_SHIFT (9U)
/*! RSVD2 - This field is reserved.
 */
#define BCH_CTRL_TOG_RSVD2(x)                 (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_RSVD2_SHIFT)) & BCH_CTRL_TOG_RSVD2_MASK)
#define BCH_CTRL_TOG_DEBUG_STALL_IRQ_EN_MASK  (0x400U)
#define BCH_CTRL_TOG_DEBUG_STALL_IRQ_EN_SHIFT (10U)
#define BCH_CTRL_TOG_DEBUG_STALL_IRQ_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_DEBUG_STALL_IRQ_EN_SHIFT)) & BCH_CTRL_TOG_DEBUG_STALL_IRQ_EN_MASK)
#define BCH_CTRL_TOG_RSVD3_MASK  (0xF800U)
#define BCH_CTRL_TOG_RSVD3_SHIFT (11U)
/*! RSVD3 - This field is reserved.
 */
#define BCH_CTRL_TOG_RSVD3(x)         (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_RSVD3_SHIFT)) & BCH_CTRL_TOG_RSVD3_MASK)
#define BCH_CTRL_TOG_M2M_ENABLE_MASK  (0x10000U)
#define BCH_CTRL_TOG_M2M_ENABLE_SHIFT (16U)
#define BCH_CTRL_TOG_M2M_ENABLE(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_M2M_ENABLE_SHIFT)) & BCH_CTRL_TOG_M2M_ENABLE_MASK)
#define BCH_CTRL_TOG_M2M_ENCODE_MASK  (0x20000U)
#define BCH_CTRL_TOG_M2M_ENCODE_SHIFT (17U)
#define BCH_CTRL_TOG_M2M_ENCODE(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_M2M_ENCODE_SHIFT)) & BCH_CTRL_TOG_M2M_ENCODE_MASK)
#define BCH_CTRL_TOG_M2M_LAYOUT_MASK  (0xC0000U)
#define BCH_CTRL_TOG_M2M_LAYOUT_SHIFT (18U)
#define BCH_CTRL_TOG_M2M_LAYOUT(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_M2M_LAYOUT_SHIFT)) & BCH_CTRL_TOG_M2M_LAYOUT_MASK)
#define BCH_CTRL_TOG_RSVD4_MASK  (0x300000U)
#define BCH_CTRL_TOG_RSVD4_SHIFT (20U)
/*! RSVD4 - This field is reserved.
 */
#define BCH_CTRL_TOG_RSVD4(x)            (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_RSVD4_SHIFT)) & BCH_CTRL_TOG_RSVD4_MASK)
#define BCH_CTRL_TOG_DEBUGSYNDROME_MASK  (0x400000U)
#define BCH_CTRL_TOG_DEBUGSYNDROME_SHIFT (22U)
#define BCH_CTRL_TOG_DEBUGSYNDROME(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_DEBUGSYNDROME_SHIFT)) & BCH_CTRL_TOG_DEBUGSYNDROME_MASK)
#define BCH_CTRL_TOG_RSVD5_MASK  (0x3F800000U)
#define BCH_CTRL_TOG_RSVD5_SHIFT (23U)
/*! RSVD5 - This field is reserved.
 */
#define BCH_CTRL_TOG_RSVD5(x)      (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_RSVD5_SHIFT)) & BCH_CTRL_TOG_RSVD5_MASK)
#define BCH_CTRL_TOG_CLKGATE_MASK  (0x40000000U)
#define BCH_CTRL_TOG_CLKGATE_SHIFT (30U)
/*! CLKGATE
 *  0b0..Allow BCH to operate normally.
 *  0b1..Do not clock BCH gates in order to minimize power consumption.
 */
#define BCH_CTRL_TOG_CLKGATE(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_CLKGATE_SHIFT)) & BCH_CTRL_TOG_CLKGATE_MASK)
#define BCH_CTRL_TOG_SFTRST_MASK  (0x80000000U)
#define BCH_CTRL_TOG_SFTRST_SHIFT (31U)
/*! SFTRST
 *  0b0..Allow BCH to operate normally.
 *  0b1..Hold BCH in reset.
 */
#define BCH_CTRL_TOG_SFTRST(x) (((uint32_t)(((uint32_t)(x)) << BCH_CTRL_TOG_SFTRST_SHIFT)) & BCH_CTRL_TOG_SFTRST_MASK)
/*! @} */

/*! @name STATUS0 - Hardware ECC Accelerator Status Register 0 */
/*! @{ */
#define BCH_STATUS0_RSVD0_MASK  (0x3U)
#define BCH_STATUS0_RSVD0_SHIFT (0U)
/*! RSVD0 - This field is reserved.
 */
#define BCH_STATUS0_RSVD0(x)            (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_RSVD0_SHIFT)) & BCH_STATUS0_RSVD0_MASK)
#define BCH_STATUS0_UNCORRECTABLE_MASK  (0x4U)
#define BCH_STATUS0_UNCORRECTABLE_SHIFT (2U)
#define BCH_STATUS0_UNCORRECTABLE(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_UNCORRECTABLE_SHIFT)) & BCH_STATUS0_UNCORRECTABLE_MASK)
#define BCH_STATUS0_CORRECTED_MASK  (0x8U)
#define BCH_STATUS0_CORRECTED_SHIFT (3U)
#define BCH_STATUS0_CORRECTED(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_CORRECTED_SHIFT)) & BCH_STATUS0_CORRECTED_MASK)
#define BCH_STATUS0_ALLONES_MASK  (0x10U)
#define BCH_STATUS0_ALLONES_SHIFT (4U)
#define BCH_STATUS0_ALLONES(x)    (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_ALLONES_SHIFT)) & BCH_STATUS0_ALLONES_MASK)
#define BCH_STATUS0_RSVD1_MASK    (0xE0U)
#define BCH_STATUS0_RSVD1_SHIFT   (5U)
/*! RSVD1 - This field is reserved.
 */
#define BCH_STATUS0_RSVD1(x)          (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_RSVD1_SHIFT)) & BCH_STATUS0_RSVD1_MASK)
#define BCH_STATUS0_STATUS_BLK0_MASK  (0xFF00U)
#define BCH_STATUS0_STATUS_BLK0_SHIFT (8U)
/*! STATUS_BLK0
 *  0b00000000..No errors found on block.
 *  0b00000001..One error found on block.
 *  0b00000010..One errors found on block.
 *  0b00000011..One errors found on block.
 *  0b00000100..One errors found on block.
 *  0b11111110..Block exhibited uncorrectable errors.
 *  0b11111111..Page is erased.
 */
#define BCH_STATUS0_STATUS_BLK0(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_STATUS_BLK0_SHIFT)) & BCH_STATUS0_STATUS_BLK0_MASK)
#define BCH_STATUS0_COMPLETED_CE_MASK  (0xF0000U)
#define BCH_STATUS0_COMPLETED_CE_SHIFT (16U)
#define BCH_STATUS0_COMPLETED_CE(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_COMPLETED_CE_SHIFT)) & BCH_STATUS0_COMPLETED_CE_MASK)
#define BCH_STATUS0_HANDLE_MASK  (0xFFF00000U)
#define BCH_STATUS0_HANDLE_SHIFT (20U)
#define BCH_STATUS0_HANDLE(x)    (((uint32_t)(((uint32_t)(x)) << BCH_STATUS0_HANDLE_SHIFT)) & BCH_STATUS0_HANDLE_MASK)
/*! @} */

/*! @name MODE - Hardware ECC Accelerator Mode Register */
/*! @{ */
#define BCH_MODE_ERASE_THRESHOLD_MASK  (0xFFU)
#define BCH_MODE_ERASE_THRESHOLD_SHIFT (0U)
#define BCH_MODE_ERASE_THRESHOLD(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_MODE_ERASE_THRESHOLD_SHIFT)) & BCH_MODE_ERASE_THRESHOLD_MASK)
#define BCH_MODE_RSVD_MASK  (0xFFFFFF00U)
#define BCH_MODE_RSVD_SHIFT (8U)
/*! RSVD - This field is reserved.
 */
#define BCH_MODE_RSVD(x) (((uint32_t)(((uint32_t)(x)) << BCH_MODE_RSVD_SHIFT)) & BCH_MODE_RSVD_MASK)
/*! @} */

/*! @name ENCODEPTR - Hardware BCH ECC Loopback Encode Buffer Register */
/*! @{ */
#define BCH_ENCODEPTR_ADDR_MASK  (0xFFFFFFFFU)
#define BCH_ENCODEPTR_ADDR_SHIFT (0U)
#define BCH_ENCODEPTR_ADDR(x)    (((uint32_t)(((uint32_t)(x)) << BCH_ENCODEPTR_ADDR_SHIFT)) & BCH_ENCODEPTR_ADDR_MASK)
/*! @} */

/*! @name DATAPTR - Hardware BCH ECC Loopback Data Buffer Register */
/*! @{ */
#define BCH_DATAPTR_ADDR_MASK  (0xFFFFFFFFU)
#define BCH_DATAPTR_ADDR_SHIFT (0U)
#define BCH_DATAPTR_ADDR(x)    (((uint32_t)(((uint32_t)(x)) << BCH_DATAPTR_ADDR_SHIFT)) & BCH_DATAPTR_ADDR_MASK)
/*! @} */

/*! @name METAPTR - Hardware BCH ECC Loopback Metadata Buffer Register */
/*! @{ */
#define BCH_METAPTR_ADDR_MASK  (0xFFFFFFFFU)
#define BCH_METAPTR_ADDR_SHIFT (0U)
#define BCH_METAPTR_ADDR(x)    (((uint32_t)(((uint32_t)(x)) << BCH_METAPTR_ADDR_SHIFT)) & BCH_METAPTR_ADDR_MASK)
/*! @} */

/*! @name LAYOUTSELECT - Hardware ECC Accelerator Layout Select Register */
/*! @{ */
#define BCH_LAYOUTSELECT_CS0_SELECT_MASK  (0x3U)
#define BCH_LAYOUTSELECT_CS0_SELECT_SHIFT (0U)
#define BCH_LAYOUTSELECT_CS0_SELECT(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CS0_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CS0_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS1_SELECT_MASK  (0xCU)
#define BCH_LAYOUTSELECT_CS1_SELECT_SHIFT (2U)
#define BCH_LAYOUTSELECT_CS1_SELECT(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CS1_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CS1_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS2_SELECT_MASK  (0x30U)
#define BCH_LAYOUTSELECT_CS2_SELECT_SHIFT (4U)
#define BCH_LAYOUTSELECT_CS2_SELECT(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CS2_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CS2_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS3_SELECT_MASK  (0xC0U)
#define BCH_LAYOUTSELECT_CS3_SELECT_SHIFT (6U)
#define BCH_LAYOUTSELECT_CS3_SELECT(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CS3_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CS3_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS4_SELECT_MASK  (0x300U)
#define BCH_LAYOUTSELECT_CS4_SELECT_SHIFT (8U)
#define BCH_LAYOUTSELECT_CS4_SELECT(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CS4_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CS4_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS5_SELECT_MASK  (0xC00U)
#define BCH_LAYOUTSELECT_CS5_SELECT_SHIFT (10U)
#define BCH_LAYOUTSELECT_CS5_SELECT(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CS5_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CS5_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS6_SELECT_MASK  (0x3000U)
#define BCH_LAYOUTSELECT_CS6_SELECT_SHIFT (12U)
#define BCH_LAYOUTSELECT_CS6_SELECT(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CS6_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CS6_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS7_SELECT_MASK  (0xC000U)
#define BCH_LAYOUTSELECT_CS7_SELECT_SHIFT (14U)
#define BCH_LAYOUTSELECT_CS7_SELECT(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CS7_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CS7_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS8_SELECT_MASK  (0x30000U)
#define BCH_LAYOUTSELECT_CS8_SELECT_SHIFT (16U)
#define BCH_LAYOUTSELECT_CS8_SELECT(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CS8_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CS8_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS9_SELECT_MASK  (0xC0000U)
#define BCH_LAYOUTSELECT_CS9_SELECT_SHIFT (18U)
#define BCH_LAYOUTSELECT_CS9_SELECT(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CS9_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CS9_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS10_SELECT_MASK  (0x300000U)
#define BCH_LAYOUTSELECT_CS10_SELECT_SHIFT (20U)
#define BCH_LAYOUTSELECT_CS10_SELECT(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CS10_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CS10_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS11_SELECT_MASK  (0xC00000U)
#define BCH_LAYOUTSELECT_CS11_SELECT_SHIFT (22U)
#define BCH_LAYOUTSELECT_CS11_SELECT(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CS11_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CS11_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS12_SELECT_MASK  (0x3000000U)
#define BCH_LAYOUTSELECT_CS12_SELECT_SHIFT (24U)
#define BCH_LAYOUTSELECT_CS12_SELECT(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CS12_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CS12_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS13_SELECT_MASK  (0xC000000U)
#define BCH_LAYOUTSELECT_CS13_SELECT_SHIFT (26U)
#define BCH_LAYOUTSELECT_CS13_SELECT(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CS13_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CS13_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS14_SELECT_MASK  (0x30000000U)
#define BCH_LAYOUTSELECT_CS14_SELECT_SHIFT (28U)
#define BCH_LAYOUTSELECT_CS14_SELECT(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CS14_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CS14_SELECT_MASK)
#define BCH_LAYOUTSELECT_CS15_SELECT_MASK  (0xC0000000U)
#define BCH_LAYOUTSELECT_CS15_SELECT_SHIFT (30U)
#define BCH_LAYOUTSELECT_CS15_SELECT(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_LAYOUTSELECT_CS15_SELECT_SHIFT)) & BCH_LAYOUTSELECT_CS15_SELECT_MASK)
/*! @} */

/*! @name FLASH0LAYOUT0 - Hardware BCH ECC Flash 0 Layout 0 Register */
/*! @{ */
#define BCH_FLASH0LAYOUT0_DATA0_SIZE_MASK  (0x3FFU)
#define BCH_FLASH0LAYOUT0_DATA0_SIZE_SHIFT (0U)
#define BCH_FLASH0LAYOUT0_DATA0_SIZE(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT0_DATA0_SIZE_SHIFT)) & BCH_FLASH0LAYOUT0_DATA0_SIZE_MASK)
#define BCH_FLASH0LAYOUT0_GF13_0_GF14_1_MASK  (0x400U)
#define BCH_FLASH0LAYOUT0_GF13_0_GF14_1_SHIFT (10U)
#define BCH_FLASH0LAYOUT0_GF13_0_GF14_1(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT0_GF13_0_GF14_1_SHIFT)) & BCH_FLASH0LAYOUT0_GF13_0_GF14_1_MASK)
#define BCH_FLASH0LAYOUT0_ECC0_MASK  (0xF800U)
#define BCH_FLASH0LAYOUT0_ECC0_SHIFT (11U)
/*! ECC0
 *  0b00000..No ECC to be performed
 *  0b00001..ECC 2 to be performed
 *  0b00010..ECC 4 to be performed
 *  0b11110..ECC 60 to be performed
 *  0b11111..ECC 62 to be performed
 */
#define BCH_FLASH0LAYOUT0_ECC0(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT0_ECC0_SHIFT)) & BCH_FLASH0LAYOUT0_ECC0_MASK)
#define BCH_FLASH0LAYOUT0_META_SIZE_MASK  (0xFF0000U)
#define BCH_FLASH0LAYOUT0_META_SIZE_SHIFT (16U)
#define BCH_FLASH0LAYOUT0_META_SIZE(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT0_META_SIZE_SHIFT)) & BCH_FLASH0LAYOUT0_META_SIZE_MASK)
#define BCH_FLASH0LAYOUT0_NBLOCKS_MASK  (0xFF000000U)
#define BCH_FLASH0LAYOUT0_NBLOCKS_SHIFT (24U)
#define BCH_FLASH0LAYOUT0_NBLOCKS(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT0_NBLOCKS_SHIFT)) & BCH_FLASH0LAYOUT0_NBLOCKS_MASK)
/*! @} */

/*! @name FLASH0LAYOUT1 - Hardware BCH ECC Flash 0 Layout 1 Register */
/*! @{ */
#define BCH_FLASH0LAYOUT1_DATAN_SIZE_MASK  (0x3FFU)
#define BCH_FLASH0LAYOUT1_DATAN_SIZE_SHIFT (0U)
#define BCH_FLASH0LAYOUT1_DATAN_SIZE(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT1_DATAN_SIZE_SHIFT)) & BCH_FLASH0LAYOUT1_DATAN_SIZE_MASK)
#define BCH_FLASH0LAYOUT1_GF13_0_GF14_1_MASK  (0x400U)
#define BCH_FLASH0LAYOUT1_GF13_0_GF14_1_SHIFT (10U)
#define BCH_FLASH0LAYOUT1_GF13_0_GF14_1(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT1_GF13_0_GF14_1_SHIFT)) & BCH_FLASH0LAYOUT1_GF13_0_GF14_1_MASK)
#define BCH_FLASH0LAYOUT1_ECCN_MASK  (0xF800U)
#define BCH_FLASH0LAYOUT1_ECCN_SHIFT (11U)
/*! ECCN
 *  0b00000..No ECC to be performed
 *  0b00001..ECC 2 to be performed
 *  0b00010..ECC 4 to be performed
 *  0b11110..ECC 60 to be performed
 *  0b11111..ECC 62 to be performed
 */
#define BCH_FLASH0LAYOUT1_ECCN(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT1_ECCN_SHIFT)) & BCH_FLASH0LAYOUT1_ECCN_MASK)
#define BCH_FLASH0LAYOUT1_PAGE_SIZE_MASK  (0xFFFF0000U)
#define BCH_FLASH0LAYOUT1_PAGE_SIZE_SHIFT (16U)
#define BCH_FLASH0LAYOUT1_PAGE_SIZE(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH0LAYOUT1_PAGE_SIZE_SHIFT)) & BCH_FLASH0LAYOUT1_PAGE_SIZE_MASK)
/*! @} */

/*! @name FLASH1LAYOUT0 - Hardware BCH ECC Flash 1 Layout 0 Register */
/*! @{ */
#define BCH_FLASH1LAYOUT0_DATA0_SIZE_MASK  (0x3FFU)
#define BCH_FLASH1LAYOUT0_DATA0_SIZE_SHIFT (0U)
#define BCH_FLASH1LAYOUT0_DATA0_SIZE(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT0_DATA0_SIZE_SHIFT)) & BCH_FLASH1LAYOUT0_DATA0_SIZE_MASK)
#define BCH_FLASH1LAYOUT0_GF13_0_GF14_1_MASK  (0x400U)
#define BCH_FLASH1LAYOUT0_GF13_0_GF14_1_SHIFT (10U)
#define BCH_FLASH1LAYOUT0_GF13_0_GF14_1(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT0_GF13_0_GF14_1_SHIFT)) & BCH_FLASH1LAYOUT0_GF13_0_GF14_1_MASK)
#define BCH_FLASH1LAYOUT0_ECC0_MASK  (0xF800U)
#define BCH_FLASH1LAYOUT0_ECC0_SHIFT (11U)
/*! ECC0
 *  0b00000..No ECC to be performed
 *  0b00001..ECC 2 to be performed
 *  0b00010..ECC 4 to be performed
 *  0b11110..ECC 60 to be performed
 *  0b11111..ECC 62 to be performed
 */
#define BCH_FLASH1LAYOUT0_ECC0(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT0_ECC0_SHIFT)) & BCH_FLASH1LAYOUT0_ECC0_MASK)
#define BCH_FLASH1LAYOUT0_META_SIZE_MASK  (0xFF0000U)
#define BCH_FLASH1LAYOUT0_META_SIZE_SHIFT (16U)
#define BCH_FLASH1LAYOUT0_META_SIZE(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT0_META_SIZE_SHIFT)) & BCH_FLASH1LAYOUT0_META_SIZE_MASK)
#define BCH_FLASH1LAYOUT0_NBLOCKS_MASK  (0xFF000000U)
#define BCH_FLASH1LAYOUT0_NBLOCKS_SHIFT (24U)
#define BCH_FLASH1LAYOUT0_NBLOCKS(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT0_NBLOCKS_SHIFT)) & BCH_FLASH1LAYOUT0_NBLOCKS_MASK)
/*! @} */

/*! @name FLASH1LAYOUT1 - Hardware BCH ECC Flash 1 Layout 1 Register */
/*! @{ */
#define BCH_FLASH1LAYOUT1_DATAN_SIZE_MASK  (0x3FFU)
#define BCH_FLASH1LAYOUT1_DATAN_SIZE_SHIFT (0U)
#define BCH_FLASH1LAYOUT1_DATAN_SIZE(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT1_DATAN_SIZE_SHIFT)) & BCH_FLASH1LAYOUT1_DATAN_SIZE_MASK)
#define BCH_FLASH1LAYOUT1_GF13_0_GF14_1_MASK  (0x400U)
#define BCH_FLASH1LAYOUT1_GF13_0_GF14_1_SHIFT (10U)
#define BCH_FLASH1LAYOUT1_GF13_0_GF14_1(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT1_GF13_0_GF14_1_SHIFT)) & BCH_FLASH1LAYOUT1_GF13_0_GF14_1_MASK)
#define BCH_FLASH1LAYOUT1_ECCN_MASK  (0xF800U)
#define BCH_FLASH1LAYOUT1_ECCN_SHIFT (11U)
/*! ECCN
 *  0b00000..No ECC to be performed
 *  0b00001..ECC 2 to be performed
 *  0b00010..ECC 4 to be performed
 *  0b11110..ECC 60 to be performed
 *  0b11111..ECC 62 to be performed
 */
#define BCH_FLASH1LAYOUT1_ECCN(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT1_ECCN_SHIFT)) & BCH_FLASH1LAYOUT1_ECCN_MASK)
#define BCH_FLASH1LAYOUT1_PAGE_SIZE_MASK  (0xFFFF0000U)
#define BCH_FLASH1LAYOUT1_PAGE_SIZE_SHIFT (16U)
#define BCH_FLASH1LAYOUT1_PAGE_SIZE(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH1LAYOUT1_PAGE_SIZE_SHIFT)) & BCH_FLASH1LAYOUT1_PAGE_SIZE_MASK)
/*! @} */

/*! @name FLASH2LAYOUT0 - Hardware BCH ECC Flash 2 Layout 0 Register */
/*! @{ */
#define BCH_FLASH2LAYOUT0_DATA0_SIZE_MASK  (0x3FFU)
#define BCH_FLASH2LAYOUT0_DATA0_SIZE_SHIFT (0U)
#define BCH_FLASH2LAYOUT0_DATA0_SIZE(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT0_DATA0_SIZE_SHIFT)) & BCH_FLASH2LAYOUT0_DATA0_SIZE_MASK)
#define BCH_FLASH2LAYOUT0_GF13_0_GF14_1_MASK  (0x400U)
#define BCH_FLASH2LAYOUT0_GF13_0_GF14_1_SHIFT (10U)
#define BCH_FLASH2LAYOUT0_GF13_0_GF14_1(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT0_GF13_0_GF14_1_SHIFT)) & BCH_FLASH2LAYOUT0_GF13_0_GF14_1_MASK)
#define BCH_FLASH2LAYOUT0_ECC0_MASK  (0xF800U)
#define BCH_FLASH2LAYOUT0_ECC0_SHIFT (11U)
/*! ECC0
 *  0b00000..No ECC to be performed
 *  0b00001..ECC 2 to be performed
 *  0b00010..ECC 4 to be performed
 *  0b11110..ECC 60 to be performed
 *  0b11111..ECC 62 to be performed
 */
#define BCH_FLASH2LAYOUT0_ECC0(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT0_ECC0_SHIFT)) & BCH_FLASH2LAYOUT0_ECC0_MASK)
#define BCH_FLASH2LAYOUT0_META_SIZE_MASK  (0xFF0000U)
#define BCH_FLASH2LAYOUT0_META_SIZE_SHIFT (16U)
#define BCH_FLASH2LAYOUT0_META_SIZE(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT0_META_SIZE_SHIFT)) & BCH_FLASH2LAYOUT0_META_SIZE_MASK)
#define BCH_FLASH2LAYOUT0_NBLOCKS_MASK  (0xFF000000U)
#define BCH_FLASH2LAYOUT0_NBLOCKS_SHIFT (24U)
#define BCH_FLASH2LAYOUT0_NBLOCKS(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT0_NBLOCKS_SHIFT)) & BCH_FLASH2LAYOUT0_NBLOCKS_MASK)
/*! @} */

/*! @name FLASH2LAYOUT1 - Hardware BCH ECC Flash 2 Layout 1 Register */
/*! @{ */
#define BCH_FLASH2LAYOUT1_DATAN_SIZE_MASK  (0x3FFU)
#define BCH_FLASH2LAYOUT1_DATAN_SIZE_SHIFT (0U)
#define BCH_FLASH2LAYOUT1_DATAN_SIZE(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT1_DATAN_SIZE_SHIFT)) & BCH_FLASH2LAYOUT1_DATAN_SIZE_MASK)
#define BCH_FLASH2LAYOUT1_GF13_0_GF14_1_MASK  (0x400U)
#define BCH_FLASH2LAYOUT1_GF13_0_GF14_1_SHIFT (10U)
#define BCH_FLASH2LAYOUT1_GF13_0_GF14_1(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT1_GF13_0_GF14_1_SHIFT)) & BCH_FLASH2LAYOUT1_GF13_0_GF14_1_MASK)
#define BCH_FLASH2LAYOUT1_ECCN_MASK  (0xF800U)
#define BCH_FLASH2LAYOUT1_ECCN_SHIFT (11U)
/*! ECCN
 *  0b00000..No ECC to be performed
 *  0b00001..ECC 2 to be performed
 *  0b00010..ECC 4 to be performed
 *  0b11110..ECC 60 to be performed
 *  0b11111..ECC 62 to be performed
 */
#define BCH_FLASH2LAYOUT1_ECCN(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT1_ECCN_SHIFT)) & BCH_FLASH2LAYOUT1_ECCN_MASK)
#define BCH_FLASH2LAYOUT1_PAGE_SIZE_MASK  (0xFFFF0000U)
#define BCH_FLASH2LAYOUT1_PAGE_SIZE_SHIFT (16U)
#define BCH_FLASH2LAYOUT1_PAGE_SIZE(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH2LAYOUT1_PAGE_SIZE_SHIFT)) & BCH_FLASH2LAYOUT1_PAGE_SIZE_MASK)
/*! @} */

/*! @name FLASH3LAYOUT0 - Hardware BCH ECC Flash 3 Layout 0 Register */
/*! @{ */
#define BCH_FLASH3LAYOUT0_DATA0_SIZE_MASK  (0x3FFU)
#define BCH_FLASH3LAYOUT0_DATA0_SIZE_SHIFT (0U)
#define BCH_FLASH3LAYOUT0_DATA0_SIZE(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT0_DATA0_SIZE_SHIFT)) & BCH_FLASH3LAYOUT0_DATA0_SIZE_MASK)
#define BCH_FLASH3LAYOUT0_GF13_0_GF14_1_MASK  (0x400U)
#define BCH_FLASH3LAYOUT0_GF13_0_GF14_1_SHIFT (10U)
#define BCH_FLASH3LAYOUT0_GF13_0_GF14_1(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT0_GF13_0_GF14_1_SHIFT)) & BCH_FLASH3LAYOUT0_GF13_0_GF14_1_MASK)
#define BCH_FLASH3LAYOUT0_ECC0_MASK  (0xF800U)
#define BCH_FLASH3LAYOUT0_ECC0_SHIFT (11U)
/*! ECC0
 *  0b00000..No ECC to be performed
 *  0b00001..ECC 2 to be performed
 *  0b00010..ECC 4 to be performed
 *  0b11110..ECC 60 to be performed
 *  0b11111..ECC 62 to be performed
 */
#define BCH_FLASH3LAYOUT0_ECC0(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT0_ECC0_SHIFT)) & BCH_FLASH3LAYOUT0_ECC0_MASK)
#define BCH_FLASH3LAYOUT0_META_SIZE_MASK  (0xFF0000U)
#define BCH_FLASH3LAYOUT0_META_SIZE_SHIFT (16U)
#define BCH_FLASH3LAYOUT0_META_SIZE(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT0_META_SIZE_SHIFT)) & BCH_FLASH3LAYOUT0_META_SIZE_MASK)
#define BCH_FLASH3LAYOUT0_NBLOCKS_MASK  (0xFF000000U)
#define BCH_FLASH3LAYOUT0_NBLOCKS_SHIFT (24U)
#define BCH_FLASH3LAYOUT0_NBLOCKS(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT0_NBLOCKS_SHIFT)) & BCH_FLASH3LAYOUT0_NBLOCKS_MASK)
/*! @} */

/*! @name FLASH3LAYOUT1 - Hardware BCH ECC Flash 3 Layout 1 Register */
/*! @{ */
#define BCH_FLASH3LAYOUT1_DATAN_SIZE_MASK  (0x3FFU)
#define BCH_FLASH3LAYOUT1_DATAN_SIZE_SHIFT (0U)
#define BCH_FLASH3LAYOUT1_DATAN_SIZE(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT1_DATAN_SIZE_SHIFT)) & BCH_FLASH3LAYOUT1_DATAN_SIZE_MASK)
#define BCH_FLASH3LAYOUT1_GF13_0_GF14_1_MASK  (0x400U)
#define BCH_FLASH3LAYOUT1_GF13_0_GF14_1_SHIFT (10U)
#define BCH_FLASH3LAYOUT1_GF13_0_GF14_1(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT1_GF13_0_GF14_1_SHIFT)) & BCH_FLASH3LAYOUT1_GF13_0_GF14_1_MASK)
#define BCH_FLASH3LAYOUT1_ECCN_MASK  (0xF800U)
#define BCH_FLASH3LAYOUT1_ECCN_SHIFT (11U)
/*! ECCN
 *  0b00000..No ECC to be performed
 *  0b00001..ECC 2 to be performed
 *  0b00010..ECC 4 to be performed
 *  0b11110..ECC 60 to be performed
 *  0b11111..ECC 62 to be performed
 */
#define BCH_FLASH3LAYOUT1_ECCN(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT1_ECCN_SHIFT)) & BCH_FLASH3LAYOUT1_ECCN_MASK)
#define BCH_FLASH3LAYOUT1_PAGE_SIZE_MASK  (0xFFFF0000U)
#define BCH_FLASH3LAYOUT1_PAGE_SIZE_SHIFT (16U)
#define BCH_FLASH3LAYOUT1_PAGE_SIZE(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_FLASH3LAYOUT1_PAGE_SIZE_SHIFT)) & BCH_FLASH3LAYOUT1_PAGE_SIZE_MASK)
/*! @} */

/*! @name DEBUG0 - Hardware BCH ECC Debug Register0 */
/*! @{ */
#define BCH_DEBUG0_DEBUG_REG_SELECT_MASK  (0x3FU)
#define BCH_DEBUG0_DEBUG_REG_SELECT_SHIFT (0U)
#define BCH_DEBUG0_DEBUG_REG_SELECT(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_DEBUG_REG_SELECT_SHIFT)) & BCH_DEBUG0_DEBUG_REG_SELECT_MASK)
#define BCH_DEBUG0_RSVD0_MASK  (0xC0U)
#define BCH_DEBUG0_RSVD0_SHIFT (6U)
/*! RSVD0 - This field is reserved.
 */
#define BCH_DEBUG0_RSVD0(x)                 (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_RSVD0_SHIFT)) & BCH_DEBUG0_RSVD0_MASK)
#define BCH_DEBUG0_BM_KES_TEST_BYPASS_MASK  (0x100U)
#define BCH_DEBUG0_BM_KES_TEST_BYPASS_SHIFT (8U)
/*! BM_KES_TEST_BYPASS
 *  0b0..Bus master address generator for SYND_GEN writes operates normally.
 *  0b1..Bus master address generator always addresses last four bytes in Auxiliary block.
 */
#define BCH_DEBUG0_BM_KES_TEST_BYPASS(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_BM_KES_TEST_BYPASS_SHIFT)) & BCH_DEBUG0_BM_KES_TEST_BYPASS_MASK)
#define BCH_DEBUG0_KES_DEBUG_STALL_MASK  (0x200U)
#define BCH_DEBUG0_KES_DEBUG_STALL_SHIFT (9U)
/*! KES_DEBUG_STALL
 *  0b0..KES FSM proceeds to next block supplied by bus master.
 *  0b1..KES FSM waits after current equations are solved and the search engine is started.
 */
#define BCH_DEBUG0_KES_DEBUG_STALL(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_KES_DEBUG_STALL_SHIFT)) & BCH_DEBUG0_KES_DEBUG_STALL_MASK)
#define BCH_DEBUG0_KES_DEBUG_STEP_MASK  (0x400U)
#define BCH_DEBUG0_KES_DEBUG_STEP_SHIFT (10U)
#define BCH_DEBUG0_KES_DEBUG_STEP(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_KES_DEBUG_STEP_SHIFT)) & BCH_DEBUG0_KES_DEBUG_STEP_MASK)
#define BCH_DEBUG0_KES_STANDALONE_MASK  (0x800U)
#define BCH_DEBUG0_KES_STANDALONE_SHIFT (11U)
/*! KES_STANDALONE
 *  0b0..Bus master address generator for SYND_GEN writes operates normally.
 *  0b1..Bus master address generator always addresses last four bytes in Auxiliary block.
 */
#define BCH_DEBUG0_KES_STANDALONE(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_KES_STANDALONE_SHIFT)) & BCH_DEBUG0_KES_STANDALONE_MASK)
#define BCH_DEBUG0_KES_DEBUG_KICK_MASK  (0x1000U)
#define BCH_DEBUG0_KES_DEBUG_KICK_SHIFT (12U)
#define BCH_DEBUG0_KES_DEBUG_KICK(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_KES_DEBUG_KICK_SHIFT)) & BCH_DEBUG0_KES_DEBUG_KICK_MASK)
#define BCH_DEBUG0_KES_DEBUG_MODE4K_MASK  (0x2000U)
#define BCH_DEBUG0_KES_DEBUG_MODE4K_SHIFT (13U)
/*! KES_DEBUG_MODE4K
 *  0b1..Mode is set for 4K NAND pages.
 *  0b1..Mode is set for 2K NAND pages.
 */
#define BCH_DEBUG0_KES_DEBUG_MODE4K(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_KES_DEBUG_MODE4K_SHIFT)) & BCH_DEBUG0_KES_DEBUG_MODE4K_MASK)
#define BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG_MASK  (0x4000U)
#define BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG_SHIFT (14U)
/*! KES_DEBUG_PAYLOAD_FLAG
 *  0b1..Payload is set for 512 bytes data block.
 *  0b1..Payload is set for 65 or 19 bytes auxiliary block.
 */
#define BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG_SHIFT)) & BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG_MASK)
#define BCH_DEBUG0_KES_DEBUG_SHIFT_SYND_MASK  (0x8000U)
#define BCH_DEBUG0_KES_DEBUG_SHIFT_SYND_SHIFT (15U)
#define BCH_DEBUG0_KES_DEBUG_SHIFT_SYND(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_KES_DEBUG_SHIFT_SYND_SHIFT)) & BCH_DEBUG0_KES_DEBUG_SHIFT_SYND_MASK)
#define BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL_MASK  (0x1FF0000U)
#define BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL_SHIFT (16U)
/*! KES_DEBUG_SYNDROME_SYMBOL
 *  0b000000000..Bus master address generator for SYND_GEN writes operates normally.
 *  0b000000001..Bus master address generator always addresses last four bytes in Auxiliary block.
 */
#define BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL_SHIFT)) & \
     BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL_MASK)
#define BCH_DEBUG0_RSVD1_MASK  (0xFE000000U)
#define BCH_DEBUG0_RSVD1_SHIFT (25U)
/*! RSVD1 - This field is reserved.
 */
#define BCH_DEBUG0_RSVD1(x) (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_RSVD1_SHIFT)) & BCH_DEBUG0_RSVD1_MASK)
/*! @} */

/*! @name DEBUG0_SET - Hardware BCH ECC Debug Register0 */
/*! @{ */
#define BCH_DEBUG0_SET_DEBUG_REG_SELECT_MASK  (0x3FU)
#define BCH_DEBUG0_SET_DEBUG_REG_SELECT_SHIFT (0U)
#define BCH_DEBUG0_SET_DEBUG_REG_SELECT(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_SET_DEBUG_REG_SELECT_SHIFT)) & BCH_DEBUG0_SET_DEBUG_REG_SELECT_MASK)
#define BCH_DEBUG0_SET_RSVD0_MASK  (0xC0U)
#define BCH_DEBUG0_SET_RSVD0_SHIFT (6U)
/*! RSVD0 - This field is reserved.
 */
#define BCH_DEBUG0_SET_RSVD0(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_SET_RSVD0_SHIFT)) & BCH_DEBUG0_SET_RSVD0_MASK)
#define BCH_DEBUG0_SET_BM_KES_TEST_BYPASS_MASK  (0x100U)
#define BCH_DEBUG0_SET_BM_KES_TEST_BYPASS_SHIFT (8U)
/*! BM_KES_TEST_BYPASS
 *  0b0..Bus master address generator for SYND_GEN writes operates normally.
 *  0b1..Bus master address generator always addresses last four bytes in Auxiliary block.
 */
#define BCH_DEBUG0_SET_BM_KES_TEST_BYPASS(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_SET_BM_KES_TEST_BYPASS_SHIFT)) & BCH_DEBUG0_SET_BM_KES_TEST_BYPASS_MASK)
#define BCH_DEBUG0_SET_KES_DEBUG_STALL_MASK  (0x200U)
#define BCH_DEBUG0_SET_KES_DEBUG_STALL_SHIFT (9U)
/*! KES_DEBUG_STALL
 *  0b0..KES FSM proceeds to next block supplied by bus master.
 *  0b1..KES FSM waits after current equations are solved and the search engine is started.
 */
#define BCH_DEBUG0_SET_KES_DEBUG_STALL(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_SET_KES_DEBUG_STALL_SHIFT)) & BCH_DEBUG0_SET_KES_DEBUG_STALL_MASK)
#define BCH_DEBUG0_SET_KES_DEBUG_STEP_MASK  (0x400U)
#define BCH_DEBUG0_SET_KES_DEBUG_STEP_SHIFT (10U)
#define BCH_DEBUG0_SET_KES_DEBUG_STEP(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_SET_KES_DEBUG_STEP_SHIFT)) & BCH_DEBUG0_SET_KES_DEBUG_STEP_MASK)
#define BCH_DEBUG0_SET_KES_STANDALONE_MASK  (0x800U)
#define BCH_DEBUG0_SET_KES_STANDALONE_SHIFT (11U)
/*! KES_STANDALONE
 *  0b0..Bus master address generator for SYND_GEN writes operates normally.
 *  0b1..Bus master address generator always addresses last four bytes in Auxiliary block.
 */
#define BCH_DEBUG0_SET_KES_STANDALONE(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_SET_KES_STANDALONE_SHIFT)) & BCH_DEBUG0_SET_KES_STANDALONE_MASK)
#define BCH_DEBUG0_SET_KES_DEBUG_KICK_MASK  (0x1000U)
#define BCH_DEBUG0_SET_KES_DEBUG_KICK_SHIFT (12U)
#define BCH_DEBUG0_SET_KES_DEBUG_KICK(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_SET_KES_DEBUG_KICK_SHIFT)) & BCH_DEBUG0_SET_KES_DEBUG_KICK_MASK)
#define BCH_DEBUG0_SET_KES_DEBUG_MODE4K_MASK  (0x2000U)
#define BCH_DEBUG0_SET_KES_DEBUG_MODE4K_SHIFT (13U)
/*! KES_DEBUG_MODE4K
 *  0b1..Mode is set for 4K NAND pages.
 *  0b1..Mode is set for 2K NAND pages.
 */
#define BCH_DEBUG0_SET_KES_DEBUG_MODE4K(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_SET_KES_DEBUG_MODE4K_SHIFT)) & BCH_DEBUG0_SET_KES_DEBUG_MODE4K_MASK)
#define BCH_DEBUG0_SET_KES_DEBUG_PAYLOAD_FLAG_MASK  (0x4000U)
#define BCH_DEBUG0_SET_KES_DEBUG_PAYLOAD_FLAG_SHIFT (14U)
/*! KES_DEBUG_PAYLOAD_FLAG
 *  0b1..Payload is set for 512 bytes data block.
 *  0b1..Payload is set for 65 or 19 bytes auxiliary block.
 */
#define BCH_DEBUG0_SET_KES_DEBUG_PAYLOAD_FLAG(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_SET_KES_DEBUG_PAYLOAD_FLAG_SHIFT)) & \
     BCH_DEBUG0_SET_KES_DEBUG_PAYLOAD_FLAG_MASK)
#define BCH_DEBUG0_SET_KES_DEBUG_SHIFT_SYND_MASK  (0x8000U)
#define BCH_DEBUG0_SET_KES_DEBUG_SHIFT_SYND_SHIFT (15U)
#define BCH_DEBUG0_SET_KES_DEBUG_SHIFT_SYND(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_SET_KES_DEBUG_SHIFT_SYND_SHIFT)) & \
     BCH_DEBUG0_SET_KES_DEBUG_SHIFT_SYND_MASK)
#define BCH_DEBUG0_SET_KES_DEBUG_SYNDROME_SYMBOL_MASK  (0x1FF0000U)
#define BCH_DEBUG0_SET_KES_DEBUG_SYNDROME_SYMBOL_SHIFT (16U)
/*! KES_DEBUG_SYNDROME_SYMBOL
 *  0b000000000..Bus master address generator for SYND_GEN writes operates normally.
 *  0b000000001..Bus master address generator always addresses last four bytes in Auxiliary block.
 */
#define BCH_DEBUG0_SET_KES_DEBUG_SYNDROME_SYMBOL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_SET_KES_DEBUG_SYNDROME_SYMBOL_SHIFT)) & \
     BCH_DEBUG0_SET_KES_DEBUG_SYNDROME_SYMBOL_MASK)
#define BCH_DEBUG0_SET_RSVD1_MASK  (0xFE000000U)
#define BCH_DEBUG0_SET_RSVD1_SHIFT (25U)
/*! RSVD1 - This field is reserved.
 */
#define BCH_DEBUG0_SET_RSVD1(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_SET_RSVD1_SHIFT)) & BCH_DEBUG0_SET_RSVD1_MASK)
/*! @} */

/*! @name DEBUG0_CLR - Hardware BCH ECC Debug Register0 */
/*! @{ */
#define BCH_DEBUG0_CLR_DEBUG_REG_SELECT_MASK  (0x3FU)
#define BCH_DEBUG0_CLR_DEBUG_REG_SELECT_SHIFT (0U)
#define BCH_DEBUG0_CLR_DEBUG_REG_SELECT(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_CLR_DEBUG_REG_SELECT_SHIFT)) & BCH_DEBUG0_CLR_DEBUG_REG_SELECT_MASK)
#define BCH_DEBUG0_CLR_RSVD0_MASK  (0xC0U)
#define BCH_DEBUG0_CLR_RSVD0_SHIFT (6U)
/*! RSVD0 - This field is reserved.
 */
#define BCH_DEBUG0_CLR_RSVD0(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_CLR_RSVD0_SHIFT)) & BCH_DEBUG0_CLR_RSVD0_MASK)
#define BCH_DEBUG0_CLR_BM_KES_TEST_BYPASS_MASK  (0x100U)
#define BCH_DEBUG0_CLR_BM_KES_TEST_BYPASS_SHIFT (8U)
/*! BM_KES_TEST_BYPASS
 *  0b0..Bus master address generator for SYND_GEN writes operates normally.
 *  0b1..Bus master address generator always addresses last four bytes in Auxiliary block.
 */
#define BCH_DEBUG0_CLR_BM_KES_TEST_BYPASS(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_CLR_BM_KES_TEST_BYPASS_SHIFT)) & BCH_DEBUG0_CLR_BM_KES_TEST_BYPASS_MASK)
#define BCH_DEBUG0_CLR_KES_DEBUG_STALL_MASK  (0x200U)
#define BCH_DEBUG0_CLR_KES_DEBUG_STALL_SHIFT (9U)
/*! KES_DEBUG_STALL
 *  0b0..KES FSM proceeds to next block supplied by bus master.
 *  0b1..KES FSM waits after current equations are solved and the search engine is started.
 */
#define BCH_DEBUG0_CLR_KES_DEBUG_STALL(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_CLR_KES_DEBUG_STALL_SHIFT)) & BCH_DEBUG0_CLR_KES_DEBUG_STALL_MASK)
#define BCH_DEBUG0_CLR_KES_DEBUG_STEP_MASK  (0x400U)
#define BCH_DEBUG0_CLR_KES_DEBUG_STEP_SHIFT (10U)
#define BCH_DEBUG0_CLR_KES_DEBUG_STEP(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_CLR_KES_DEBUG_STEP_SHIFT)) & BCH_DEBUG0_CLR_KES_DEBUG_STEP_MASK)
#define BCH_DEBUG0_CLR_KES_STANDALONE_MASK  (0x800U)
#define BCH_DEBUG0_CLR_KES_STANDALONE_SHIFT (11U)
/*! KES_STANDALONE
 *  0b0..Bus master address generator for SYND_GEN writes operates normally.
 *  0b1..Bus master address generator always addresses last four bytes in Auxiliary block.
 */
#define BCH_DEBUG0_CLR_KES_STANDALONE(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_CLR_KES_STANDALONE_SHIFT)) & BCH_DEBUG0_CLR_KES_STANDALONE_MASK)
#define BCH_DEBUG0_CLR_KES_DEBUG_KICK_MASK  (0x1000U)
#define BCH_DEBUG0_CLR_KES_DEBUG_KICK_SHIFT (12U)
#define BCH_DEBUG0_CLR_KES_DEBUG_KICK(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_CLR_KES_DEBUG_KICK_SHIFT)) & BCH_DEBUG0_CLR_KES_DEBUG_KICK_MASK)
#define BCH_DEBUG0_CLR_KES_DEBUG_MODE4K_MASK  (0x2000U)
#define BCH_DEBUG0_CLR_KES_DEBUG_MODE4K_SHIFT (13U)
/*! KES_DEBUG_MODE4K
 *  0b1..Mode is set for 4K NAND pages.
 *  0b1..Mode is set for 2K NAND pages.
 */
#define BCH_DEBUG0_CLR_KES_DEBUG_MODE4K(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_CLR_KES_DEBUG_MODE4K_SHIFT)) & BCH_DEBUG0_CLR_KES_DEBUG_MODE4K_MASK)
#define BCH_DEBUG0_CLR_KES_DEBUG_PAYLOAD_FLAG_MASK  (0x4000U)
#define BCH_DEBUG0_CLR_KES_DEBUG_PAYLOAD_FLAG_SHIFT (14U)
/*! KES_DEBUG_PAYLOAD_FLAG
 *  0b1..Payload is set for 512 bytes data block.
 *  0b1..Payload is set for 65 or 19 bytes auxiliary block.
 */
#define BCH_DEBUG0_CLR_KES_DEBUG_PAYLOAD_FLAG(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_CLR_KES_DEBUG_PAYLOAD_FLAG_SHIFT)) & \
     BCH_DEBUG0_CLR_KES_DEBUG_PAYLOAD_FLAG_MASK)
#define BCH_DEBUG0_CLR_KES_DEBUG_SHIFT_SYND_MASK  (0x8000U)
#define BCH_DEBUG0_CLR_KES_DEBUG_SHIFT_SYND_SHIFT (15U)
#define BCH_DEBUG0_CLR_KES_DEBUG_SHIFT_SYND(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_CLR_KES_DEBUG_SHIFT_SYND_SHIFT)) & \
     BCH_DEBUG0_CLR_KES_DEBUG_SHIFT_SYND_MASK)
#define BCH_DEBUG0_CLR_KES_DEBUG_SYNDROME_SYMBOL_MASK  (0x1FF0000U)
#define BCH_DEBUG0_CLR_KES_DEBUG_SYNDROME_SYMBOL_SHIFT (16U)
/*! KES_DEBUG_SYNDROME_SYMBOL
 *  0b000000000..Bus master address generator for SYND_GEN writes operates normally.
 *  0b000000001..Bus master address generator always addresses last four bytes in Auxiliary block.
 */
#define BCH_DEBUG0_CLR_KES_DEBUG_SYNDROME_SYMBOL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_CLR_KES_DEBUG_SYNDROME_SYMBOL_SHIFT)) & \
     BCH_DEBUG0_CLR_KES_DEBUG_SYNDROME_SYMBOL_MASK)
#define BCH_DEBUG0_CLR_RSVD1_MASK  (0xFE000000U)
#define BCH_DEBUG0_CLR_RSVD1_SHIFT (25U)
/*! RSVD1 - This field is reserved.
 */
#define BCH_DEBUG0_CLR_RSVD1(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_CLR_RSVD1_SHIFT)) & BCH_DEBUG0_CLR_RSVD1_MASK)
/*! @} */

/*! @name DEBUG0_TOG - Hardware BCH ECC Debug Register0 */
/*! @{ */
#define BCH_DEBUG0_TOG_DEBUG_REG_SELECT_MASK  (0x3FU)
#define BCH_DEBUG0_TOG_DEBUG_REG_SELECT_SHIFT (0U)
#define BCH_DEBUG0_TOG_DEBUG_REG_SELECT(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_TOG_DEBUG_REG_SELECT_SHIFT)) & BCH_DEBUG0_TOG_DEBUG_REG_SELECT_MASK)
#define BCH_DEBUG0_TOG_RSVD0_MASK  (0xC0U)
#define BCH_DEBUG0_TOG_RSVD0_SHIFT (6U)
/*! RSVD0 - This field is reserved.
 */
#define BCH_DEBUG0_TOG_RSVD0(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_TOG_RSVD0_SHIFT)) & BCH_DEBUG0_TOG_RSVD0_MASK)
#define BCH_DEBUG0_TOG_BM_KES_TEST_BYPASS_MASK  (0x100U)
#define BCH_DEBUG0_TOG_BM_KES_TEST_BYPASS_SHIFT (8U)
/*! BM_KES_TEST_BYPASS
 *  0b0..Bus master address generator for SYND_GEN writes operates normally.
 *  0b1..Bus master address generator always addresses last four bytes in Auxiliary block.
 */
#define BCH_DEBUG0_TOG_BM_KES_TEST_BYPASS(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_TOG_BM_KES_TEST_BYPASS_SHIFT)) & BCH_DEBUG0_TOG_BM_KES_TEST_BYPASS_MASK)
#define BCH_DEBUG0_TOG_KES_DEBUG_STALL_MASK  (0x200U)
#define BCH_DEBUG0_TOG_KES_DEBUG_STALL_SHIFT (9U)
/*! KES_DEBUG_STALL
 *  0b0..KES FSM proceeds to next block supplied by bus master.
 *  0b1..KES FSM waits after current equations are solved and the search engine is started.
 */
#define BCH_DEBUG0_TOG_KES_DEBUG_STALL(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_TOG_KES_DEBUG_STALL_SHIFT)) & BCH_DEBUG0_TOG_KES_DEBUG_STALL_MASK)
#define BCH_DEBUG0_TOG_KES_DEBUG_STEP_MASK  (0x400U)
#define BCH_DEBUG0_TOG_KES_DEBUG_STEP_SHIFT (10U)
#define BCH_DEBUG0_TOG_KES_DEBUG_STEP(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_TOG_KES_DEBUG_STEP_SHIFT)) & BCH_DEBUG0_TOG_KES_DEBUG_STEP_MASK)
#define BCH_DEBUG0_TOG_KES_STANDALONE_MASK  (0x800U)
#define BCH_DEBUG0_TOG_KES_STANDALONE_SHIFT (11U)
/*! KES_STANDALONE
 *  0b0..Bus master address generator for SYND_GEN writes operates normally.
 *  0b1..Bus master address generator always addresses last four bytes in Auxiliary block.
 */
#define BCH_DEBUG0_TOG_KES_STANDALONE(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_TOG_KES_STANDALONE_SHIFT)) & BCH_DEBUG0_TOG_KES_STANDALONE_MASK)
#define BCH_DEBUG0_TOG_KES_DEBUG_KICK_MASK  (0x1000U)
#define BCH_DEBUG0_TOG_KES_DEBUG_KICK_SHIFT (12U)
#define BCH_DEBUG0_TOG_KES_DEBUG_KICK(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_TOG_KES_DEBUG_KICK_SHIFT)) & BCH_DEBUG0_TOG_KES_DEBUG_KICK_MASK)
#define BCH_DEBUG0_TOG_KES_DEBUG_MODE4K_MASK  (0x2000U)
#define BCH_DEBUG0_TOG_KES_DEBUG_MODE4K_SHIFT (13U)
/*! KES_DEBUG_MODE4K
 *  0b1..Mode is set for 4K NAND pages.
 *  0b1..Mode is set for 2K NAND pages.
 */
#define BCH_DEBUG0_TOG_KES_DEBUG_MODE4K(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_TOG_KES_DEBUG_MODE4K_SHIFT)) & BCH_DEBUG0_TOG_KES_DEBUG_MODE4K_MASK)
#define BCH_DEBUG0_TOG_KES_DEBUG_PAYLOAD_FLAG_MASK  (0x4000U)
#define BCH_DEBUG0_TOG_KES_DEBUG_PAYLOAD_FLAG_SHIFT (14U)
/*! KES_DEBUG_PAYLOAD_FLAG
 *  0b1..Payload is set for 512 bytes data block.
 *  0b1..Payload is set for 65 or 19 bytes auxiliary block.
 */
#define BCH_DEBUG0_TOG_KES_DEBUG_PAYLOAD_FLAG(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_TOG_KES_DEBUG_PAYLOAD_FLAG_SHIFT)) & \
     BCH_DEBUG0_TOG_KES_DEBUG_PAYLOAD_FLAG_MASK)
#define BCH_DEBUG0_TOG_KES_DEBUG_SHIFT_SYND_MASK  (0x8000U)
#define BCH_DEBUG0_TOG_KES_DEBUG_SHIFT_SYND_SHIFT (15U)
#define BCH_DEBUG0_TOG_KES_DEBUG_SHIFT_SYND(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_TOG_KES_DEBUG_SHIFT_SYND_SHIFT)) & \
     BCH_DEBUG0_TOG_KES_DEBUG_SHIFT_SYND_MASK)
#define BCH_DEBUG0_TOG_KES_DEBUG_SYNDROME_SYMBOL_MASK  (0x1FF0000U)
#define BCH_DEBUG0_TOG_KES_DEBUG_SYNDROME_SYMBOL_SHIFT (16U)
/*! KES_DEBUG_SYNDROME_SYMBOL
 *  0b000000000..Bus master address generator for SYND_GEN writes operates normally.
 *  0b000000001..Bus master address generator always addresses last four bytes in Auxiliary block.
 */
#define BCH_DEBUG0_TOG_KES_DEBUG_SYNDROME_SYMBOL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_TOG_KES_DEBUG_SYNDROME_SYMBOL_SHIFT)) & \
     BCH_DEBUG0_TOG_KES_DEBUG_SYNDROME_SYMBOL_MASK)
#define BCH_DEBUG0_TOG_RSVD1_MASK  (0xFE000000U)
#define BCH_DEBUG0_TOG_RSVD1_SHIFT (25U)
/*! RSVD1 - This field is reserved.
 */
#define BCH_DEBUG0_TOG_RSVD1(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG0_TOG_RSVD1_SHIFT)) & BCH_DEBUG0_TOG_RSVD1_MASK)
/*! @} */

/*! @name DBGKESREAD - KES Debug Read Register */
/*! @{ */
#define BCH_DBGKESREAD_VALUES_MASK  (0xFFFFFFFFU)
#define BCH_DBGKESREAD_VALUES_SHIFT (0U)
#define BCH_DBGKESREAD_VALUES(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DBGKESREAD_VALUES_SHIFT)) & BCH_DBGKESREAD_VALUES_MASK)
/*! @} */

/*! @name DBGCSFEREAD - Chien Search Debug Read Register */
/*! @{ */
#define BCH_DBGCSFEREAD_VALUES_MASK  (0xFFFFFFFFU)
#define BCH_DBGCSFEREAD_VALUES_SHIFT (0U)
#define BCH_DBGCSFEREAD_VALUES(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DBGCSFEREAD_VALUES_SHIFT)) & BCH_DBGCSFEREAD_VALUES_MASK)
/*! @} */

/*! @name DBGSYNDGENREAD - Syndrome Generator Debug Read Register */
/*! @{ */
#define BCH_DBGSYNDGENREAD_VALUES_MASK  (0xFFFFFFFFU)
#define BCH_DBGSYNDGENREAD_VALUES_SHIFT (0U)
#define BCH_DBGSYNDGENREAD_VALUES(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DBGSYNDGENREAD_VALUES_SHIFT)) & BCH_DBGSYNDGENREAD_VALUES_MASK)
/*! @} */

/*! @name DBGAHBMREAD - Bus Master and ECC Controller Debug Read Register */
/*! @{ */
#define BCH_DBGAHBMREAD_VALUES_MASK  (0xFFFFFFFFU)
#define BCH_DBGAHBMREAD_VALUES_SHIFT (0U)
#define BCH_DBGAHBMREAD_VALUES(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DBGAHBMREAD_VALUES_SHIFT)) & BCH_DBGAHBMREAD_VALUES_MASK)
/*! @} */

/*! @name BLOCKNAME - Block Name Register */
/*! @{ */
#define BCH_BLOCKNAME_NAME_MASK  (0xFFFFFFFFU)
#define BCH_BLOCKNAME_NAME_SHIFT (0U)
#define BCH_BLOCKNAME_NAME(x)    (((uint32_t)(((uint32_t)(x)) << BCH_BLOCKNAME_NAME_SHIFT)) & BCH_BLOCKNAME_NAME_MASK)
/*! @} */

/*! @name VERSION - BCH Version Register */
/*! @{ */
#define BCH_VERSION_STEP_MASK   (0xFFFFU)
#define BCH_VERSION_STEP_SHIFT  (0U)
#define BCH_VERSION_STEP(x)     (((uint32_t)(((uint32_t)(x)) << BCH_VERSION_STEP_SHIFT)) & BCH_VERSION_STEP_MASK)
#define BCH_VERSION_MINOR_MASK  (0xFF0000U)
#define BCH_VERSION_MINOR_SHIFT (16U)
#define BCH_VERSION_MINOR(x)    (((uint32_t)(((uint32_t)(x)) << BCH_VERSION_MINOR_SHIFT)) & BCH_VERSION_MINOR_MASK)
#define BCH_VERSION_MAJOR_MASK  (0xFF000000U)
#define BCH_VERSION_MAJOR_SHIFT (24U)
#define BCH_VERSION_MAJOR(x)    (((uint32_t)(((uint32_t)(x)) << BCH_VERSION_MAJOR_SHIFT)) & BCH_VERSION_MAJOR_MASK)
/*! @} */

/*! @name DEBUG1 - Hardware BCH ECC Debug Register 1 */
/*! @{ */
#define BCH_DEBUG1_ERASED_ZERO_COUNT_MASK  (0x1FFU)
#define BCH_DEBUG1_ERASED_ZERO_COUNT_SHIFT (0U)
#define BCH_DEBUG1_ERASED_ZERO_COUNT(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG1_ERASED_ZERO_COUNT_SHIFT)) & BCH_DEBUG1_ERASED_ZERO_COUNT_MASK)
#define BCH_DEBUG1_RSVD_MASK  (0x7FFFFE00U)
#define BCH_DEBUG1_RSVD_SHIFT (9U)
/*! RSVD - This field is reserved.
 */
#define BCH_DEBUG1_RSVD(x)                  (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG1_RSVD_SHIFT)) & BCH_DEBUG1_RSVD_MASK)
#define BCH_DEBUG1_DEBUG1_PREERASECHK_MASK  (0x80000000U)
#define BCH_DEBUG1_DEBUG1_PREERASECHK_SHIFT (31U)
/*! DEBUG1_PREERASECHK
 *  0b0..Turn off pre-erase check
 *  0b1..Turn on pre-erase check
 */
#define BCH_DEBUG1_DEBUG1_PREERASECHK(x) \
    (((uint32_t)(((uint32_t)(x)) << BCH_DEBUG1_DEBUG1_PREERASECHK_SHIFT)) & BCH_DEBUG1_DEBUG1_PREERASECHK_MASK)
/*! @} */

/*!
 * @}
 */ /* end of group BCH_Register_Masks */

/* BCH - Peripheral instance base addresses */
/** Peripheral BCH base address */
#define BCH_BASE (0x33004000u)
/** Peripheral BCH base pointer */
#define BCH ((BCH_Type *)BCH_BASE)
/** Array initializer of BCH peripheral base addresses */
#define BCH_BASE_ADDRS \
    {                  \
        BCH_BASE       \
    }
/** Array initializer of BCH peripheral base pointers */
#define BCH_BASE_PTRS \
    {                 \
        BCH           \
    }
/** Interrupt vectors for the BCH peripheral type */
#define BCH_IRQS \
    {            \
        BCH_IRQn \
    }

/*!
 * @}
 */ /* end of group BCH_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- CAN Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAN_Peripheral_Access_Layer CAN Peripheral Access Layer
 * @{
 */

/** CAN - Register Layout Typedef */
typedef struct
{
    __IO uint32_t MCR;   /**< Module Configuration register, offset: 0x0 */
    __IO uint32_t CTRL1; /**< Control 1 register, offset: 0x4 */
    __IO uint32_t TIMER; /**< Free Running Timer, offset: 0x8 */
    uint8_t RESERVED_0[4];
    __IO uint32_t RXMGMASK; /**< Rx Mailboxes Global Mask register, offset: 0x10 */
    __IO uint32_t RX14MASK; /**< Rx 14 Mask register, offset: 0x14 */
    __IO uint32_t RX15MASK; /**< Rx 15 Mask register, offset: 0x18 */
    __IO uint32_t ECR;      /**< Error Counter, offset: 0x1C */
    __IO uint32_t ESR1;     /**< Error and Status 1 register, offset: 0x20 */
    __IO uint32_t IMASK2;   /**< Interrupt Masks 2 register, offset: 0x24 */
    __IO uint32_t IMASK1;   /**< Interrupt Masks 1 register, offset: 0x28 */
    __IO uint32_t IFLAG2;   /**< Interrupt Flags 2 register, offset: 0x2C */
    __IO uint32_t IFLAG1;   /**< Interrupt Flags 1 register, offset: 0x30 */
    __IO uint32_t CTRL2;    /**< Control 2 register, offset: 0x34 */
    __I uint32_t ESR2;      /**< Error and Status 2 register, offset: 0x38 */
    uint8_t RESERVED_1[8];
    __I uint32_t CRCR;      /**< CRC register, offset: 0x44 */
    __IO uint32_t RXFGMASK; /**< Rx FIFO Global Mask register, offset: 0x48 */
    __I uint32_t RXFIR;     /**< Rx FIFO Information register, offset: 0x4C */
    __IO uint32_t CBT;      /**< CAN Bit Timing register, offset: 0x50 */
    uint8_t RESERVED_2[44];
    struct
    {                        /* offset: 0x80, array step: 0x10 */
        __IO uint32_t CS;    /**< Message Buffer 0 CS Register..Message Buffer 63 CS Register, array offset: 0x80, array
                                step: 0x10 */
        __IO uint32_t ID;    /**< Message Buffer 0 ID Register..Message Buffer 63 ID Register, array offset: 0x84, array
                                step: 0x10 */
        __IO uint32_t WORD0; /**< Message Buffer 0 WORD0 Register..Message Buffer 63 WORD0 Register, array offset: 0x88,
                                array step: 0x10 */
        __IO uint32_t WORD1; /**< Message Buffer 0 WORD1 Register..Message Buffer 63 WORD1 Register, array offset: 0x8C,
                                array step: 0x10 */
    } MB[64];
    uint8_t RESERVED_3[1024];
    __IO uint32_t RXIMR[64]; /**< Rx Individual Mask registers, array offset: 0x880, array step: 0x4 */
    uint8_t RESERVED_4[352];
    __IO uint32_t MECR;    /**< Memory Error Control register, offset: 0xAE0 */
    __IO uint32_t ERRIAR;  /**< Error Injection Address register, offset: 0xAE4 */
    __IO uint32_t ERRIDPR; /**< Error Injection Data Pattern register, offset: 0xAE8 */
    __IO uint32_t ERRIPPR; /**< Error Injection Parity Pattern register, offset: 0xAEC */
    __I uint32_t RERRAR;   /**< Error Report Address register, offset: 0xAF0 */
    __I uint32_t RERRDR;   /**< Error Report Data register, offset: 0xAF4 */
    __I uint32_t RERRSYNR; /**< Error Report Syndrome register, offset: 0xAF8 */
    __IO uint32_t ERRSR;   /**< Error Status register, offset: 0xAFC */
    uint8_t RESERVED_5[256];
    __IO uint32_t FDCTRL; /**< CAN FD Control register, offset: 0xC00 */
    __IO uint32_t FDCBT;  /**< CAN FD Bit Timing register, offset: 0xC04 */
    __I uint32_t FDCRC;   /**< CAN FD CRC register, offset: 0xC08 */
} CAN_Type;

/* ----------------------------------------------------------------------------
   -- CAN Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAN_Register_Masks CAN Register Masks
 * @{
 */

/*! @name MCR - Module Configuration register */
/*! @{ */
#define CAN_MCR_MAXMB_MASK  (0x7FU)
#define CAN_MCR_MAXMB_SHIFT (0U)
/*! MAXMB - Number Of The Last Message Buffer
 */
#define CAN_MCR_MAXMB(x)   (((uint32_t)(((uint32_t)(x)) << CAN_MCR_MAXMB_SHIFT)) & CAN_MCR_MAXMB_MASK)
#define CAN_MCR_IDAM_MASK  (0x300U)
#define CAN_MCR_IDAM_SHIFT (8U)
/*! IDAM - ID Acceptance Mode
 *  0b00..Format A: One full ID (standard and extended) per ID filter table element.
 *  0b01..Format B: Two full standard IDs or two partial 14-bit (standard and extended) IDs per ID filter table element.
 *  0b10..Format C: Four partial 8-bit standard IDs per ID filter table element.
 *  0b11..Format D: All frames rejected.
 */
#define CAN_MCR_IDAM(x)    (((uint32_t)(((uint32_t)(x)) << CAN_MCR_IDAM_SHIFT)) & CAN_MCR_IDAM_MASK)
#define CAN_MCR_FDEN_MASK  (0x800U)
#define CAN_MCR_FDEN_SHIFT (11U)
/*! FDEN - CAN FD operation enable
 *  0b1..CAN FD is enabled. FlexCAN is able to receive and transmit messages in both CAN FD and CAN 2.0 formats.
 *  0b0..CAN FD is disabled. FlexCAN is able to receive and transmit messages in CAN 2.0 format.
 */
#define CAN_MCR_FDEN(x)   (((uint32_t)(((uint32_t)(x)) << CAN_MCR_FDEN_SHIFT)) & CAN_MCR_FDEN_MASK)
#define CAN_MCR_AEN_MASK  (0x1000U)
#define CAN_MCR_AEN_SHIFT (12U)
/*! AEN - Abort Enable
 *  0b0..Abort disabled.
 *  0b1..Abort enabled.
 */
#define CAN_MCR_AEN(x)        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_AEN_SHIFT)) & CAN_MCR_AEN_MASK)
#define CAN_MCR_LPRIOEN_MASK  (0x2000U)
#define CAN_MCR_LPRIOEN_SHIFT (13U)
/*! LPRIOEN - Local Priority Enable
 *  0b0..Local Priority disabled.
 *  0b1..Local Priority enabled.
 */
#define CAN_MCR_LPRIOEN(x) (((uint32_t)(((uint32_t)(x)) << CAN_MCR_LPRIOEN_SHIFT)) & CAN_MCR_LPRIOEN_MASK)
#define CAN_MCR_DMA_MASK   (0x8000U)
#define CAN_MCR_DMA_SHIFT  (15U)
/*! DMA - DMA Enable
 *  0b0..DMA feature for RX FIFO disabled.
 *  0b1..DMA feature for RX FIFO enabled.
 */
#define CAN_MCR_DMA(x)     (((uint32_t)(((uint32_t)(x)) << CAN_MCR_DMA_SHIFT)) & CAN_MCR_DMA_MASK)
#define CAN_MCR_IRMQ_MASK  (0x10000U)
#define CAN_MCR_IRMQ_SHIFT (16U)
/*! IRMQ - Individual Rx Masking And Queue Enable
 *  0b0..Individual Rx masking and queue feature are disabled. For backward compatibility with legacy
 *       applications, the reading of C/S word locks the MB even if it is EMPTY.
 *  0b1..Individual Rx masking and queue feature are enabled.
 */
#define CAN_MCR_IRMQ(x)      (((uint32_t)(((uint32_t)(x)) << CAN_MCR_IRMQ_SHIFT)) & CAN_MCR_IRMQ_MASK)
#define CAN_MCR_SRXDIS_MASK  (0x20000U)
#define CAN_MCR_SRXDIS_SHIFT (17U)
/*! SRXDIS - Self Reception Disable
 *  0b0..Self-reception enabled.
 *  0b1..Self-reception disabled.
 */
#define CAN_MCR_SRXDIS(x)  (((uint32_t)(((uint32_t)(x)) << CAN_MCR_SRXDIS_SHIFT)) & CAN_MCR_SRXDIS_MASK)
#define CAN_MCR_DOZE_MASK  (0x40000U)
#define CAN_MCR_DOZE_SHIFT (18U)
/*! DOZE - Doze Mode Enable
 *  0b0..FlexCAN is not enabled to enter low-power mode when Doze mode is requested.
 *  0b1..FlexCAN is enabled to enter low-power mode when Doze mode is requested.
 */
#define CAN_MCR_DOZE(x)      (((uint32_t)(((uint32_t)(x)) << CAN_MCR_DOZE_SHIFT)) & CAN_MCR_DOZE_MASK)
#define CAN_MCR_WAKSRC_MASK  (0x80000U)
#define CAN_MCR_WAKSRC_SHIFT (19U)
/*! WAKSRC - Wake Up Source
 *  0b0..FlexCAN uses the unfiltered Rx input to detect recessive to dominant edges on the CAN bus.
 *  0b1..FlexCAN uses the filtered Rx input to detect recessive to dominant edges on the CAN bus.
 */
#define CAN_MCR_WAKSRC(x)    (((uint32_t)(((uint32_t)(x)) << CAN_MCR_WAKSRC_SHIFT)) & CAN_MCR_WAKSRC_MASK)
#define CAN_MCR_LPMACK_MASK  (0x100000U)
#define CAN_MCR_LPMACK_SHIFT (20U)
/*! LPMACK - Low-Power Mode Acknowledge
 *  0b0..FlexCAN is not in a low-power mode.
 *  0b1..FlexCAN is in a low-power mode.
 */
#define CAN_MCR_LPMACK(x)   (((uint32_t)(((uint32_t)(x)) << CAN_MCR_LPMACK_SHIFT)) & CAN_MCR_LPMACK_MASK)
#define CAN_MCR_WRNEN_MASK  (0x200000U)
#define CAN_MCR_WRNEN_SHIFT (21U)
/*! WRNEN - Warning Interrupt Enable
 *  0b0..TWRNINT and RWRNINT bits are zero, independent of the values in the error counters.
 *  0b1..TWRNINT and RWRNINT bits are set when the respective error counter transitions from less than 96 to greater
 * than or equal to 96.
 */
#define CAN_MCR_WRNEN(x)     (((uint32_t)(((uint32_t)(x)) << CAN_MCR_WRNEN_SHIFT)) & CAN_MCR_WRNEN_MASK)
#define CAN_MCR_SLFWAK_MASK  (0x400000U)
#define CAN_MCR_SLFWAK_SHIFT (22U)
/*! SLFWAK - Self Wake Up
 *  0b0..FlexCAN Self Wake Up feature is disabled.
 *  0b1..FlexCAN Self Wake Up feature is enabled.
 */
#define CAN_MCR_SLFWAK(x)  (((uint32_t)(((uint32_t)(x)) << CAN_MCR_SLFWAK_SHIFT)) & CAN_MCR_SLFWAK_MASK)
#define CAN_MCR_SUPV_MASK  (0x800000U)
#define CAN_MCR_SUPV_SHIFT (23U)
/*! SUPV - Supervisor Mode
 *  0b0..FlexCAN is in User mode. Affected registers allow both Supervisor and Unrestricted accesses
 * (ips_supervisor_access signal is ignored). 0b1..FlexCAN is in Supervisor mode. Affected registers allow only
 * Supervisor access. Unrestricted access (ips_supervisor_access negated) behaves as though the access was done to an
 * unimplemented register location (ips_xfr_error asserted in the SkyBlue Interface).
 */
#define CAN_MCR_SUPV(x)      (((uint32_t)(((uint32_t)(x)) << CAN_MCR_SUPV_SHIFT)) & CAN_MCR_SUPV_MASK)
#define CAN_MCR_FRZACK_MASK  (0x1000000U)
#define CAN_MCR_FRZACK_SHIFT (24U)
/*! FRZACK - Freeze Mode Acknowledge
 *  0b0..FlexCAN not in Freeze mode, prescaler running.
 *  0b1..FlexCAN in Freeze mode, prescaler stopped.
 */
#define CAN_MCR_FRZACK(x)     (((uint32_t)(((uint32_t)(x)) << CAN_MCR_FRZACK_SHIFT)) & CAN_MCR_FRZACK_MASK)
#define CAN_MCR_SOFTRST_MASK  (0x2000000U)
#define CAN_MCR_SOFTRST_SHIFT (25U)
/*! SOFTRST - Soft Reset
 *  0b0..No reset request.
 *  0b1..Resets the registers affected by soft reset.
 */
#define CAN_MCR_SOFTRST(x)   (((uint32_t)(((uint32_t)(x)) << CAN_MCR_SOFTRST_SHIFT)) & CAN_MCR_SOFTRST_MASK)
#define CAN_MCR_WAKMSK_MASK  (0x4000000U)
#define CAN_MCR_WAKMSK_SHIFT (26U)
/*! WAKMSK - Wake Up Interrupt Mask
 *  0b0..Wake Up interrupt is disabled.
 *  0b1..Wake Up interrupt is enabled.
 */
#define CAN_MCR_WAKMSK(x)    (((uint32_t)(((uint32_t)(x)) << CAN_MCR_WAKMSK_SHIFT)) & CAN_MCR_WAKMSK_MASK)
#define CAN_MCR_NOTRDY_MASK  (0x8000000U)
#define CAN_MCR_NOTRDY_SHIFT (27U)
/*! NOTRDY - FlexCAN Not Ready
 *  0b0..FlexCAN module is either in Normal mode, Listen-Only mode, or Loop-Back mode.
 *  0b1..FlexCAN module is either in Disable mode, Doze mode, Stop mode, or Freeze mode.
 */
#define CAN_MCR_NOTRDY(x)  (((uint32_t)(((uint32_t)(x)) << CAN_MCR_NOTRDY_SHIFT)) & CAN_MCR_NOTRDY_MASK)
#define CAN_MCR_HALT_MASK  (0x10000000U)
#define CAN_MCR_HALT_SHIFT (28U)
/*! HALT - Halt FlexCAN
 *  0b0..No Freeze mode request.
 *  0b1..Enters Freeze mode if the FRZ bit is asserted.
 */
#define CAN_MCR_HALT(x)    (((uint32_t)(((uint32_t)(x)) << CAN_MCR_HALT_SHIFT)) & CAN_MCR_HALT_MASK)
#define CAN_MCR_RFEN_MASK  (0x20000000U)
#define CAN_MCR_RFEN_SHIFT (29U)
/*! RFEN - Rx FIFO Enable
 *  0b0..Rx FIFO not enabled.
 *  0b1..Rx FIFO enabled.
 */
#define CAN_MCR_RFEN(x)   (((uint32_t)(((uint32_t)(x)) << CAN_MCR_RFEN_SHIFT)) & CAN_MCR_RFEN_MASK)
#define CAN_MCR_FRZ_MASK  (0x40000000U)
#define CAN_MCR_FRZ_SHIFT (30U)
/*! FRZ - Freeze Enable
 *  0b0..Not enabled to enter Freeze mode.
 *  0b1..Enabled to enter Freeze mode.
 */
#define CAN_MCR_FRZ(x)     (((uint32_t)(((uint32_t)(x)) << CAN_MCR_FRZ_SHIFT)) & CAN_MCR_FRZ_MASK)
#define CAN_MCR_MDIS_MASK  (0x80000000U)
#define CAN_MCR_MDIS_SHIFT (31U)
/*! MDIS - Module Disable
 *  0b0..Enable the FlexCAN module.
 *  0b1..Disable the FlexCAN module.
 */
#define CAN_MCR_MDIS(x) (((uint32_t)(((uint32_t)(x)) << CAN_MCR_MDIS_SHIFT)) & CAN_MCR_MDIS_MASK)
/*! @} */

/*! @name CTRL1 - Control 1 register */
/*! @{ */
#define CAN_CTRL1_PROPSEG_MASK  (0x7U)
#define CAN_CTRL1_PROPSEG_SHIFT (0U)
/*! PROPSEG - Propagation Segment
 */
#define CAN_CTRL1_PROPSEG(x) (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PROPSEG_SHIFT)) & CAN_CTRL1_PROPSEG_MASK)
#define CAN_CTRL1_LOM_MASK   (0x8U)
#define CAN_CTRL1_LOM_SHIFT  (3U)
/*! LOM - Listen-Only Mode
 *  0b0..Listen-Only mode is deactivated.
 *  0b1..FlexCAN module operates in Listen-Only mode.
 */
#define CAN_CTRL1_LOM(x)     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_LOM_SHIFT)) & CAN_CTRL1_LOM_MASK)
#define CAN_CTRL1_LBUF_MASK  (0x10U)
#define CAN_CTRL1_LBUF_SHIFT (4U)
/*! LBUF - Lowest Buffer Transmitted First
 *  0b0..Buffer with highest priority is transmitted first.
 *  0b1..Lowest number buffer is transmitted first.
 */
#define CAN_CTRL1_LBUF(x)    (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_LBUF_SHIFT)) & CAN_CTRL1_LBUF_MASK)
#define CAN_CTRL1_TSYN_MASK  (0x20U)
#define CAN_CTRL1_TSYN_SHIFT (5U)
/*! TSYN - Timer Sync
 *  0b0..Timer sync feature disabled
 *  0b1..Timer sync feature enabled
 */
#define CAN_CTRL1_TSYN(x)       (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_TSYN_SHIFT)) & CAN_CTRL1_TSYN_MASK)
#define CAN_CTRL1_BOFFREC_MASK  (0x40U)
#define CAN_CTRL1_BOFFREC_SHIFT (6U)
/*! BOFFREC - Bus Off Recovery
 *  0b0..Automatic recovering from Bus Off state enabled.
 *  0b1..Automatic recovering from Bus Off state disabled.
 */
#define CAN_CTRL1_BOFFREC(x) (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_BOFFREC_SHIFT)) & CAN_CTRL1_BOFFREC_MASK)
#define CAN_CTRL1_SMP_MASK   (0x80U)
#define CAN_CTRL1_SMP_SHIFT  (7U)
/*! SMP - CAN Bit Sampling
 *  0b0..Just one sample is used to determine the bit value.
 *  0b1..Three samples are used to determine the value of the received bit: the regular one (sample point) and two
 *       preceding samples; a majority rule is used.
 */
#define CAN_CTRL1_SMP(x)        (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_SMP_SHIFT)) & CAN_CTRL1_SMP_MASK)
#define CAN_CTRL1_RWRNMSK_MASK  (0x400U)
#define CAN_CTRL1_RWRNMSK_SHIFT (10U)
/*! RWRNMSK - Rx Warning Interrupt Mask
 *  0b0..Rx Warning interrupt disabled.
 *  0b1..Rx Warning interrupt enabled.
 */
#define CAN_CTRL1_RWRNMSK(x)    (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_RWRNMSK_SHIFT)) & CAN_CTRL1_RWRNMSK_MASK)
#define CAN_CTRL1_TWRNMSK_MASK  (0x800U)
#define CAN_CTRL1_TWRNMSK_SHIFT (11U)
/*! TWRNMSK - Tx Warning Interrupt Mask
 *  0b0..Tx Warning interrupt disabled.
 *  0b1..Tx Warning interrupt enabled.
 */
#define CAN_CTRL1_TWRNMSK(x) (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_TWRNMSK_SHIFT)) & CAN_CTRL1_TWRNMSK_MASK)
#define CAN_CTRL1_LPB_MASK   (0x1000U)
#define CAN_CTRL1_LPB_SHIFT  (12U)
/*! LPB - Loop Back Mode
 *  0b0..Loop Back disabled.
 *  0b1..Loop Back enabled.
 */
#define CAN_CTRL1_LPB(x)       (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_LPB_SHIFT)) & CAN_CTRL1_LPB_MASK)
#define CAN_CTRL1_CLKSRC_MASK  (0x2000U)
#define CAN_CTRL1_CLKSRC_SHIFT (13U)
/*! CLKSRC - CAN Engine Clock Source
 *  0b0..The CAN engine clock source is the oscillator clock. Under this condition, the oscillator clock frequency must
 * be lower than the bus clock. 0b1..The CAN engine clock source is the peripheral clock.
 */
#define CAN_CTRL1_CLKSRC(x)    (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_CLKSRC_SHIFT)) & CAN_CTRL1_CLKSRC_MASK)
#define CAN_CTRL1_ERRMSK_MASK  (0x4000U)
#define CAN_CTRL1_ERRMSK_SHIFT (14U)
/*! ERRMSK - Error Interrupt Mask
 *  0b0..Error interrupt disabled.
 *  0b1..Error interrupt enabled.
 */
#define CAN_CTRL1_ERRMSK(x)     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_ERRMSK_SHIFT)) & CAN_CTRL1_ERRMSK_MASK)
#define CAN_CTRL1_BOFFMSK_MASK  (0x8000U)
#define CAN_CTRL1_BOFFMSK_SHIFT (15U)
/*! BOFFMSK - Bus Off Interrupt Mask
 *  0b0..Bus Off interrupt disabled.
 *  0b1..Bus Off interrupt enabled.
 */
#define CAN_CTRL1_BOFFMSK(x)  (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_BOFFMSK_SHIFT)) & CAN_CTRL1_BOFFMSK_MASK)
#define CAN_CTRL1_PSEG2_MASK  (0x70000U)
#define CAN_CTRL1_PSEG2_SHIFT (16U)
/*! PSEG2 - Phase Segment 2
 */
#define CAN_CTRL1_PSEG2(x)    (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PSEG2_SHIFT)) & CAN_CTRL1_PSEG2_MASK)
#define CAN_CTRL1_PSEG1_MASK  (0x380000U)
#define CAN_CTRL1_PSEG1_SHIFT (19U)
/*! PSEG1 - Phase Segment 1
 */
#define CAN_CTRL1_PSEG1(x)  (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PSEG1_SHIFT)) & CAN_CTRL1_PSEG1_MASK)
#define CAN_CTRL1_RJW_MASK  (0xC00000U)
#define CAN_CTRL1_RJW_SHIFT (22U)
/*! RJW - Resync Jump Width
 */
#define CAN_CTRL1_RJW(x)        (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_RJW_SHIFT)) & CAN_CTRL1_RJW_MASK)
#define CAN_CTRL1_PRESDIV_MASK  (0xFF000000U)
#define CAN_CTRL1_PRESDIV_SHIFT (24U)
/*! PRESDIV - Prescaler Division Factor
 */
#define CAN_CTRL1_PRESDIV(x) (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PRESDIV_SHIFT)) & CAN_CTRL1_PRESDIV_MASK)
/*! @} */

/*! @name TIMER - Free Running Timer */
/*! @{ */
#define CAN_TIMER_TIMER_MASK  (0xFFFFU)
#define CAN_TIMER_TIMER_SHIFT (0U)
/*! TIMER - Timer Value
 */
#define CAN_TIMER_TIMER(x) (((uint32_t)(((uint32_t)(x)) << CAN_TIMER_TIMER_SHIFT)) & CAN_TIMER_TIMER_MASK)
/*! @} */

/*! @name RXMGMASK - Rx Mailboxes Global Mask register */
/*! @{ */
#define CAN_RXMGMASK_MG_MASK  (0xFFFFFFFFU)
#define CAN_RXMGMASK_MG_SHIFT (0U)
/*! MG - Rx Mailboxes Global Mask Bits
 */
#define CAN_RXMGMASK_MG(x) (((uint32_t)(((uint32_t)(x)) << CAN_RXMGMASK_MG_SHIFT)) & CAN_RXMGMASK_MG_MASK)
/*! @} */

/*! @name RX14MASK - Rx 14 Mask register */
/*! @{ */
#define CAN_RX14MASK_RX14M_MASK  (0xFFFFFFFFU)
#define CAN_RX14MASK_RX14M_SHIFT (0U)
/*! RX14M - Rx Buffer 14 Mask Bits
 */
#define CAN_RX14MASK_RX14M(x) (((uint32_t)(((uint32_t)(x)) << CAN_RX14MASK_RX14M_SHIFT)) & CAN_RX14MASK_RX14M_MASK)
/*! @} */

/*! @name RX15MASK - Rx 15 Mask register */
/*! @{ */
#define CAN_RX15MASK_RX15M_MASK  (0xFFFFFFFFU)
#define CAN_RX15MASK_RX15M_SHIFT (0U)
/*! RX15M - Rx Buffer 15 Mask Bits
 */
#define CAN_RX15MASK_RX15M(x) (((uint32_t)(((uint32_t)(x)) << CAN_RX15MASK_RX15M_SHIFT)) & CAN_RX15MASK_RX15M_MASK)
/*! @} */

/*! @name ECR - Error Counter */
/*! @{ */
#define CAN_ECR_TXERRCNT_MASK  (0xFFU)
#define CAN_ECR_TXERRCNT_SHIFT (0U)
/*! TXERRCNT - Transmit Error Counter
 */
#define CAN_ECR_TXERRCNT(x)    (((uint32_t)(((uint32_t)(x)) << CAN_ECR_TXERRCNT_SHIFT)) & CAN_ECR_TXERRCNT_MASK)
#define CAN_ECR_RXERRCNT_MASK  (0xFF00U)
#define CAN_ECR_RXERRCNT_SHIFT (8U)
/*! RXERRCNT - Receive Error Counter
 */
#define CAN_ECR_RXERRCNT(x)         (((uint32_t)(((uint32_t)(x)) << CAN_ECR_RXERRCNT_SHIFT)) & CAN_ECR_RXERRCNT_MASK)
#define CAN_ECR_TXERRCNT_FAST_MASK  (0xFF0000U)
#define CAN_ECR_TXERRCNT_FAST_SHIFT (16U)
/*! TXERRCNT_FAST - Transmit Error Counter for fast bits
 */
#define CAN_ECR_TXERRCNT_FAST(x) \
    (((uint32_t)(((uint32_t)(x)) << CAN_ECR_TXERRCNT_FAST_SHIFT)) & CAN_ECR_TXERRCNT_FAST_MASK)
#define CAN_ECR_RXERRCNT_FAST_MASK  (0xFF000000U)
#define CAN_ECR_RXERRCNT_FAST_SHIFT (24U)
/*! RXERRCNT_FAST - Receive Error Counter for fast bits
 */
#define CAN_ECR_RXERRCNT_FAST(x) \
    (((uint32_t)(((uint32_t)(x)) << CAN_ECR_RXERRCNT_FAST_SHIFT)) & CAN_ECR_RXERRCNT_FAST_MASK)
/*! @} */

/*! @name ESR1 - Error and Status 1 register */
/*! @{ */
#define CAN_ESR1_WAKINT_MASK  (0x1U)
#define CAN_ESR1_WAKINT_SHIFT (0U)
/*! WAKINT - Wake-Up Interrupt
 *  0b0..No such occurrence.
 *  0b1..Indicates a recessive to dominant transition was received on the CAN bus.
 */
#define CAN_ESR1_WAKINT(x)    (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_WAKINT_SHIFT)) & CAN_ESR1_WAKINT_MASK)
#define CAN_ESR1_ERRINT_MASK  (0x2U)
#define CAN_ESR1_ERRINT_SHIFT (1U)
/*! ERRINT - Error Interrupt
 *  0b0..No such occurrence.
 *  0b1..Indicates setting of any error bit in the Error and Status register.
 */
#define CAN_ESR1_ERRINT(x)     (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_ERRINT_SHIFT)) & CAN_ESR1_ERRINT_MASK)
#define CAN_ESR1_BOFFINT_MASK  (0x4U)
#define CAN_ESR1_BOFFINT_SHIFT (2U)
/*! BOFFINT - Bus Off Interrupt
 *  0b0..No such occurrence.
 *  0b1..FlexCAN module entered Bus Off state.
 */
#define CAN_ESR1_BOFFINT(x) (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BOFFINT_SHIFT)) & CAN_ESR1_BOFFINT_MASK)
#define CAN_ESR1_RX_MASK    (0x8U)
#define CAN_ESR1_RX_SHIFT   (3U)
/*! RX - FlexCAN In Reception
 *  0b0..FlexCAN is not receiving a message.
 *  0b1..FlexCAN is receiving a message.
 */
#define CAN_ESR1_RX(x)         (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_RX_SHIFT)) & CAN_ESR1_RX_MASK)
#define CAN_ESR1_FLTCONF_MASK  (0x30U)
#define CAN_ESR1_FLTCONF_SHIFT (4U)
/*! FLTCONF - Fault Confinement State
 *  0b00..Error Active
 *  0b01..Error Passive
 *  0b1x..Bus Off
 */
#define CAN_ESR1_FLTCONF(x) (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_FLTCONF_SHIFT)) & CAN_ESR1_FLTCONF_MASK)
#define CAN_ESR1_TX_MASK    (0x40U)
#define CAN_ESR1_TX_SHIFT   (6U)
/*! TX - FlexCAN In Transmission
 *  0b0..FlexCAN is not transmitting a message.
 *  0b1..FlexCAN is transmitting a message.
 */
#define CAN_ESR1_TX(x)      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_TX_SHIFT)) & CAN_ESR1_TX_MASK)
#define CAN_ESR1_IDLE_MASK  (0x80U)
#define CAN_ESR1_IDLE_SHIFT (7U)
/*! IDLE - IDLE
 *  0b0..No such occurrence.
 *  0b1..CAN bus is now IDLE.
 */
#define CAN_ESR1_IDLE(x)     (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_IDLE_SHIFT)) & CAN_ESR1_IDLE_MASK)
#define CAN_ESR1_RXWRN_MASK  (0x100U)
#define CAN_ESR1_RXWRN_SHIFT (8U)
/*! RXWRN - Rx Error Warning
 *  0b0..No such occurrence.
 *  0b1..RXERRCNT is greater than or equal to 96.
 */
#define CAN_ESR1_RXWRN(x)    (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_RXWRN_SHIFT)) & CAN_ESR1_RXWRN_MASK)
#define CAN_ESR1_TXWRN_MASK  (0x200U)
#define CAN_ESR1_TXWRN_SHIFT (9U)
/*! TXWRN - TX Error Warning
 *  0b0..No such occurrence.
 *  0b1..TXERRCNT is greater than or equal to 96.
 */
#define CAN_ESR1_TXWRN(x)     (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_TXWRN_SHIFT)) & CAN_ESR1_TXWRN_MASK)
#define CAN_ESR1_STFERR_MASK  (0x400U)
#define CAN_ESR1_STFERR_SHIFT (10U)
/*! STFERR - Stuffing Error
 *  0b0..No such occurrence.
 *  0b1..A stuffing error occurred since last read of this register.
 */
#define CAN_ESR1_STFERR(x)    (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_STFERR_SHIFT)) & CAN_ESR1_STFERR_MASK)
#define CAN_ESR1_FRMERR_MASK  (0x800U)
#define CAN_ESR1_FRMERR_SHIFT (11U)
/*! FRMERR - Form Error
 *  0b0..No such occurrence.
 *  0b1..A Form Error occurred since last read of this register.
 */
#define CAN_ESR1_FRMERR(x)    (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_FRMERR_SHIFT)) & CAN_ESR1_FRMERR_MASK)
#define CAN_ESR1_CRCERR_MASK  (0x1000U)
#define CAN_ESR1_CRCERR_SHIFT (12U)
/*! CRCERR - Cyclic Redundancy Check Error
 *  0b0..No such occurrence.
 *  0b1..A CRC error occurred since last read of this register.
 */
#define CAN_ESR1_CRCERR(x)    (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_CRCERR_SHIFT)) & CAN_ESR1_CRCERR_MASK)
#define CAN_ESR1_ACKERR_MASK  (0x2000U)
#define CAN_ESR1_ACKERR_SHIFT (13U)
/*! ACKERR - Acknowledge Error
 *  0b0..No such occurrence.
 *  0b1..An ACK error occurred since last read of this register.
 */
#define CAN_ESR1_ACKERR(x)     (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_ACKERR_SHIFT)) & CAN_ESR1_ACKERR_MASK)
#define CAN_ESR1_BIT0ERR_MASK  (0x4000U)
#define CAN_ESR1_BIT0ERR_SHIFT (14U)
/*! BIT0ERR - Bit0 Error
 *  0b0..No such occurrence.
 *  0b1..At least one bit sent as dominant is received as recessive.
 */
#define CAN_ESR1_BIT0ERR(x)    (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BIT0ERR_SHIFT)) & CAN_ESR1_BIT0ERR_MASK)
#define CAN_ESR1_BIT1ERR_MASK  (0x8000U)
#define CAN_ESR1_BIT1ERR_SHIFT (15U)
/*! BIT1ERR - Bit1 Error
 *  0b0..No such occurrence.
 *  0b1..At least one bit sent as recessive is received as dominant.
 */
#define CAN_ESR1_BIT1ERR(x)    (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BIT1ERR_SHIFT)) & CAN_ESR1_BIT1ERR_MASK)
#define CAN_ESR1_RWRNINT_MASK  (0x10000U)
#define CAN_ESR1_RWRNINT_SHIFT (16U)
/*! RWRNINT - Rx Warning Interrupt Flag
 *  0b0..No such occurrence.
 *  0b1..The Rx error counter transitioned from less than 96 to greater than or equal to 96.
 */
#define CAN_ESR1_RWRNINT(x)    (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_RWRNINT_SHIFT)) & CAN_ESR1_RWRNINT_MASK)
#define CAN_ESR1_TWRNINT_MASK  (0x20000U)
#define CAN_ESR1_TWRNINT_SHIFT (17U)
/*! TWRNINT - Tx Warning Interrupt Flag
 *  0b0..No such occurrence.
 *  0b1..The Tx error counter transitioned from less than 96 to greater than or equal to 96.
 */
#define CAN_ESR1_TWRNINT(x)  (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_TWRNINT_SHIFT)) & CAN_ESR1_TWRNINT_MASK)
#define CAN_ESR1_SYNCH_MASK  (0x40000U)
#define CAN_ESR1_SYNCH_SHIFT (18U)
/*! SYNCH - CAN Synchronization Status
 *  0b0..FlexCAN is not synchronized to the CAN bus.
 *  0b1..FlexCAN is synchronized to the CAN bus.
 */
#define CAN_ESR1_SYNCH(x)          (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_SYNCH_SHIFT)) & CAN_ESR1_SYNCH_MASK)
#define CAN_ESR1_BOFFDONEINT_MASK  (0x80000U)
#define CAN_ESR1_BOFFDONEINT_SHIFT (19U)
/*! BOFFDONEINT - Bus Off Done Interrupt
 *  0b0..No such occurrence.
 *  0b1..FlexCAN module has completed Bus Off process.
 */
#define CAN_ESR1_BOFFDONEINT(x) \
    (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BOFFDONEINT_SHIFT)) & CAN_ESR1_BOFFDONEINT_MASK)
#define CAN_ESR1_ERRINT_FAST_MASK  (0x100000U)
#define CAN_ESR1_ERRINT_FAST_SHIFT (20U)
/*! ERRINT_FAST - Error interrupt for errors detected in Data Phase of CAN FD frames with BRS bit set
 *  0b0..No such occurrence.
 *  0b1..Indicates setting of any error bit detected in the data phase of CAN FD frames with the BRS bit set.
 */
#define CAN_ESR1_ERRINT_FAST(x) \
    (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_ERRINT_FAST_SHIFT)) & CAN_ESR1_ERRINT_FAST_MASK)
#define CAN_ESR1_ERROVR_MASK  (0x200000U)
#define CAN_ESR1_ERROVR_SHIFT (21U)
/*! ERROVR - Error Overrun
 *  0b0..Overrun has not occurred.
 *  0b1..Overrun has occurred.
 */
#define CAN_ESR1_ERROVR(x)         (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_ERROVR_SHIFT)) & CAN_ESR1_ERROVR_MASK)
#define CAN_ESR1_STFERR_FAST_MASK  (0x4000000U)
#define CAN_ESR1_STFERR_FAST_SHIFT (26U)
/*! STFERR_FAST - Stuffing Error in the Data Phase of CAN FD frames with the BRS bit set
 *  0b0..No such occurrence.
 *  0b1..A stuffing error occurred since last read of this register.
 */
#define CAN_ESR1_STFERR_FAST(x) \
    (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_STFERR_FAST_SHIFT)) & CAN_ESR1_STFERR_FAST_MASK)
#define CAN_ESR1_FRMERR_FAST_MASK  (0x8000000U)
#define CAN_ESR1_FRMERR_FAST_SHIFT (27U)
/*! FRMERR_FAST - Form Error in the Data Phase of CAN FD frames with the BRS bit set
 *  0b0..No such occurrence.
 *  0b1..A form error occurred since last read of this register.
 */
#define CAN_ESR1_FRMERR_FAST(x) \
    (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_FRMERR_FAST_SHIFT)) & CAN_ESR1_FRMERR_FAST_MASK)
#define CAN_ESR1_CRCERR_FAST_MASK  (0x10000000U)
#define CAN_ESR1_CRCERR_FAST_SHIFT (28U)
/*! CRCERR_FAST - Cyclic Redundancy Check Error in the CRC field of CAN FD frames with the BRS bit set
 *  0b0..No such occurrence.
 *  0b1..A CRC error occurred since last read of this register.
 */
#define CAN_ESR1_CRCERR_FAST(x) \
    (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_CRCERR_FAST_SHIFT)) & CAN_ESR1_CRCERR_FAST_MASK)
#define CAN_ESR1_BIT0ERR_FAST_MASK  (0x40000000U)
#define CAN_ESR1_BIT0ERR_FAST_SHIFT (30U)
/*! BIT0ERR_FAST - Bit0 Error in the Data Phase of CAN FD frames with the BRS bit set
 *  0b0..No such occurrence.
 *  0b1..At least one bit sent as dominant is received as recessive.
 */
#define CAN_ESR1_BIT0ERR_FAST(x) \
    (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BIT0ERR_FAST_SHIFT)) & CAN_ESR1_BIT0ERR_FAST_MASK)
#define CAN_ESR1_BIT1ERR_FAST_MASK  (0x80000000U)
#define CAN_ESR1_BIT1ERR_FAST_SHIFT (31U)
/*! BIT1ERR_FAST - Bit1 Error in the Data Phase of CAN FD frames with the BRS bit set
 *  0b0..No such occurrence.
 *  0b1..At least one bit sent as recessive is received as dominant.
 */
#define CAN_ESR1_BIT1ERR_FAST(x) \
    (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BIT1ERR_FAST_SHIFT)) & CAN_ESR1_BIT1ERR_FAST_MASK)
/*! @} */

/*! @name IMASK2 - Interrupt Masks 2 register */
/*! @{ */
#define CAN_IMASK2_BUF63TO32M_MASK  (0xFFFFFFFFU)
#define CAN_IMASK2_BUF63TO32M_SHIFT (0U)
/*! BUF63TO32M - Buffer MBi Mask
 */
#define CAN_IMASK2_BUF63TO32M(x) \
    (((uint32_t)(((uint32_t)(x)) << CAN_IMASK2_BUF63TO32M_SHIFT)) & CAN_IMASK2_BUF63TO32M_MASK)
/*! @} */

/*! @name IMASK1 - Interrupt Masks 1 register */
/*! @{ */
#define CAN_IMASK1_BUF31TO0M_MASK  (0xFFFFFFFFU)
#define CAN_IMASK1_BUF31TO0M_SHIFT (0U)
/*! BUF31TO0M - Buffer MBi Mask
 */
#define CAN_IMASK1_BUF31TO0M(x) \
    (((uint32_t)(((uint32_t)(x)) << CAN_IMASK1_BUF31TO0M_SHIFT)) & CAN_IMASK1_BUF31TO0M_MASK)
/*! @} */

/*! @name IFLAG2 - Interrupt Flags 2 register */
/*! @{ */
#define CAN_IFLAG2_BUF63TO32I_MASK  (0xFFFFFFFFU)
#define CAN_IFLAG2_BUF63TO32I_SHIFT (0U)
/*! BUF63TO32I - Buffer MBi Interrupt
 */
#define CAN_IFLAG2_BUF63TO32I(x) \
    (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG2_BUF63TO32I_SHIFT)) & CAN_IFLAG2_BUF63TO32I_MASK)
/*! @} */

/*! @name IFLAG1 - Interrupt Flags 1 register */
/*! @{ */
#define CAN_IFLAG1_BUF0I_MASK  (0x1U)
#define CAN_IFLAG1_BUF0I_SHIFT (0U)
/*! BUF0I - Buffer MB0 Interrupt Or Clear FIFO bit
 *  0b0..The corresponding buffer has no occurrence of successfully completed transmission or reception when
 * MCR[RFEN]=0. 0b1..The corresponding buffer has successfully completed transmission or reception when MCR[RFEN]=0.
 */
#define CAN_IFLAG1_BUF0I(x)       (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF0I_SHIFT)) & CAN_IFLAG1_BUF0I_MASK)
#define CAN_IFLAG1_BUF4TO1I_MASK  (0x1EU)
#define CAN_IFLAG1_BUF4TO1I_SHIFT (1U)
/*! BUF4TO1I - Buffer MBi Interrupt Or Reserved
 */
#define CAN_IFLAG1_BUF4TO1I(x) (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF4TO1I_SHIFT)) & CAN_IFLAG1_BUF4TO1I_MASK)
#define CAN_IFLAG1_BUF5I_MASK  (0x20U)
#define CAN_IFLAG1_BUF5I_SHIFT (5U)
/*! BUF5I - Buffer MB5 Interrupt Or Frames available in Rx FIFO
 *  0b0..No occurrence of MB5 completing transmission/reception when MCR[RFEN]=0, or of frame(s) available in the FIFO,
 * when MCR[RFEN]=1 0b1..MB5 completed transmission/reception when MCR[RFEN]=0, or frame(s) available in the Rx FIFO
 * when MCR[RFEN]=1. It generates a DMA request in case of MCR[RFEN] and MCR[DMA] are enabled.
 */
#define CAN_IFLAG1_BUF5I(x)    (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF5I_SHIFT)) & CAN_IFLAG1_BUF5I_MASK)
#define CAN_IFLAG1_BUF6I_MASK  (0x40U)
#define CAN_IFLAG1_BUF6I_SHIFT (6U)
/*! BUF6I - Buffer MB6 Interrupt Or Rx FIFO Warning
 *  0b0..No occurrence of MB6 completing transmission/reception when MCR[RFEN]=0, or of Rx FIFO almost full when
 * MCR[RFEN]=1 0b1..MB6 completed transmission/reception when MCR[RFEN]=0, or Rx FIFO almost full when MCR[RFEN]=1
 */
#define CAN_IFLAG1_BUF6I(x)    (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF6I_SHIFT)) & CAN_IFLAG1_BUF6I_MASK)
#define CAN_IFLAG1_BUF7I_MASK  (0x80U)
#define CAN_IFLAG1_BUF7I_SHIFT (7U)
/*! BUF7I - Buffer MB7 Interrupt Or Rx FIFO Overflow
 *  0b0..No occurrence of MB7 completing transmission/reception when MCR[RFEN]=0, or of Rx FIFO overflow when
 * MCR[RFEN]=1 0b1..MB7 completed transmission/reception when MCR[RFEN]=0, or Rx FIFO overflow when MCR[RFEN]=1
 */
#define CAN_IFLAG1_BUF7I(x)        (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF7I_SHIFT)) & CAN_IFLAG1_BUF7I_MASK)
#define CAN_IFLAG1_BUF31TO8I_MASK  (0xFFFFFF00U)
#define CAN_IFLAG1_BUF31TO8I_SHIFT (8U)
/*! BUF31TO8I - Buffer MBi Interrupt
 */
#define CAN_IFLAG1_BUF31TO8I(x) \
    (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF31TO8I_SHIFT)) & CAN_IFLAG1_BUF31TO8I_MASK)
/*! @} */

/*! @name CTRL2 - Control 2 register */
/*! @{ */
#define CAN_CTRL2_EDFLTDIS_MASK  (0x800U)
#define CAN_CTRL2_EDFLTDIS_SHIFT (11U)
/*! EDFLTDIS - Edge Filter Disable
 *  0b0..Edge filter is enabled
 *  0b1..Edge filter is disabled
 */
#define CAN_CTRL2_EDFLTDIS(x)      (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_EDFLTDIS_SHIFT)) & CAN_CTRL2_EDFLTDIS_MASK)
#define CAN_CTRL2_ISOCANFDEN_MASK  (0x1000U)
#define CAN_CTRL2_ISOCANFDEN_SHIFT (12U)
/*! ISOCANFDEN - ISO CAN FD Enable
 *  0b0..FlexCAN operates using the non-ISO CAN FD protocol.
 *  0b1..FlexCAN operates using the ISO CAN FD protocol (ISO 11898-1).
 */
#define CAN_CTRL2_ISOCANFDEN(x) \
    (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_ISOCANFDEN_SHIFT)) & CAN_CTRL2_ISOCANFDEN_MASK)
#define CAN_CTRL2_PREXCEN_MASK  (0x4000U)
#define CAN_CTRL2_PREXCEN_SHIFT (14U)
/*! PREXCEN - Protocol Exception Enable
 *  0b0..Protocol exception is disabled.
 *  0b1..Protocol exception is enabled.
 */
#define CAN_CTRL2_PREXCEN(x)      (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_PREXCEN_SHIFT)) & CAN_CTRL2_PREXCEN_MASK)
#define CAN_CTRL2_TIMER_SRC_MASK  (0x8000U)
#define CAN_CTRL2_TIMER_SRC_SHIFT (15U)
/*! TIMER_SRC - Timer Source
 *  0b0..The free running timer is clocked by the CAN bit clock, which defines the baud rate on the CAN bus.
 *  0b1..The free running timer is clocked by an external time tick. The period can be either adjusted to be equal
 *       to the baud rate on the CAN bus, or a different value as required. See the device-specific section for
 *       details about the external time tick.
 */
#define CAN_CTRL2_TIMER_SRC(x) (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_TIMER_SRC_SHIFT)) & CAN_CTRL2_TIMER_SRC_MASK)
#define CAN_CTRL2_EACEN_MASK   (0x10000U)
#define CAN_CTRL2_EACEN_SHIFT  (16U)
/*! EACEN - Entire Frame Arbitration Field Comparison Enable For Rx Mailboxes
 *  0b0..Rx mailbox filter's IDE bit is always compared and RTR is never compared despite mask bits.
 *  0b1..Enables the comparison of both Rx mailbox filter's IDE and RTR bit with their corresponding bits within
 *       the incoming frame. Mask bits do apply.
 */
#define CAN_CTRL2_EACEN(x)  (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_EACEN_SHIFT)) & CAN_CTRL2_EACEN_MASK)
#define CAN_CTRL2_RRS_MASK  (0x20000U)
#define CAN_CTRL2_RRS_SHIFT (17U)
/*! RRS - Remote Request Storing
 *  0b0..Remote response frame is generated.
 *  0b1..Remote request frame is stored.
 */
#define CAN_CTRL2_RRS(x)    (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_RRS_SHIFT)) & CAN_CTRL2_RRS_MASK)
#define CAN_CTRL2_MRP_MASK  (0x40000U)
#define CAN_CTRL2_MRP_SHIFT (18U)
/*! MRP - Mailboxes Reception Priority
 *  0b0..Matching starts from Rx FIFO or Enhanced Rx FIFO and continues on mailboxes.
 *  0b1..Matching starts from mailboxes and continues on Rx FIFO.
 */
#define CAN_CTRL2_MRP(x)     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_MRP_SHIFT)) & CAN_CTRL2_MRP_MASK)
#define CAN_CTRL2_TASD_MASK  (0xF80000U)
#define CAN_CTRL2_TASD_SHIFT (19U)
/*! TASD - Tx Arbitration Start Delay
 */
#define CAN_CTRL2_TASD(x)    (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_TASD_SHIFT)) & CAN_CTRL2_TASD_MASK)
#define CAN_CTRL2_RFFN_MASK  (0xF000000U)
#define CAN_CTRL2_RFFN_SHIFT (24U)
/*! RFFN - Number Of Rx FIFO Filters
 */
#define CAN_CTRL2_RFFN(x)      (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_RFFN_SHIFT)) & CAN_CTRL2_RFFN_MASK)
#define CAN_CTRL2_WRMFRZ_MASK  (0x10000000U)
#define CAN_CTRL2_WRMFRZ_SHIFT (28U)
/*! WRMFRZ - Write-Access To Memory In Freeze Mode
 *  0b0..Maintain the write access restrictions.
 *  0b1..Enable unrestricted write access to FlexCAN memory.
 */
#define CAN_CTRL2_WRMFRZ(x)    (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_WRMFRZ_SHIFT)) & CAN_CTRL2_WRMFRZ_MASK)
#define CAN_CTRL2_ECRWRE_MASK  (0x20000000U)
#define CAN_CTRL2_ECRWRE_SHIFT (29U)
/*! ECRWRE - Error-correction Configuration Register Write Enable
 *  0b0..Disable update.
 *  0b1..Enable update.
 */
#define CAN_CTRL2_ECRWRE(x)         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_ECRWRE_SHIFT)) & CAN_CTRL2_ECRWRE_MASK)
#define CAN_CTRL2_BOFFDONEMSK_MASK  (0x40000000U)
#define CAN_CTRL2_BOFFDONEMSK_SHIFT (30U)
/*! BOFFDONEMSK - Bus Off Done Interrupt Mask
 *  0b0..Bus off done interrupt disabled.
 *  0b1..Bus off done interrupt enabled.
 */
#define CAN_CTRL2_BOFFDONEMSK(x) \
    (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_BOFFDONEMSK_SHIFT)) & CAN_CTRL2_BOFFDONEMSK_MASK)
#define CAN_CTRL2_ERRMSK_FAST_MASK  (0x80000000U)
#define CAN_CTRL2_ERRMSK_FAST_SHIFT (31U)
/*! ERRMSK_FAST - Error Interrupt Mask for errors detected in the data phase of fast CAN FD frames
 *  0b0..ERRINT_FAST error interrupt disabled.
 *  0b1..ERRINT_FAST error interrupt enabled.
 */
#define CAN_CTRL2_ERRMSK_FAST(x) \
    (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_ERRMSK_FAST_SHIFT)) & CAN_CTRL2_ERRMSK_FAST_MASK)
/*! @} */

/*! @name ESR2 - Error and Status 2 register */
/*! @{ */
#define CAN_ESR2_IMB_MASK  (0x2000U)
#define CAN_ESR2_IMB_SHIFT (13U)
/*! IMB - Inactive Mailbox
 *  0b0..If ESR2[VPS] is asserted, the ESR2[LPTM] is not an inactive mailbox.
 *  0b1..If ESR2[VPS] is asserted, there is at least one inactive mailbox. LPTM content is the number of the first one.
 */
#define CAN_ESR2_IMB(x)    (((uint32_t)(((uint32_t)(x)) << CAN_ESR2_IMB_SHIFT)) & CAN_ESR2_IMB_MASK)
#define CAN_ESR2_VPS_MASK  (0x4000U)
#define CAN_ESR2_VPS_SHIFT (14U)
/*! VPS - Valid Priority Status
 *  0b0..Contents of IMB and LPTM are invalid.
 *  0b1..Contents of IMB and LPTM are valid.
 */
#define CAN_ESR2_VPS(x)     (((uint32_t)(((uint32_t)(x)) << CAN_ESR2_VPS_SHIFT)) & CAN_ESR2_VPS_MASK)
#define CAN_ESR2_LPTM_MASK  (0x7F0000U)
#define CAN_ESR2_LPTM_SHIFT (16U)
/*! LPTM - Lowest Priority Tx Mailbox
 */
#define CAN_ESR2_LPTM(x) (((uint32_t)(((uint32_t)(x)) << CAN_ESR2_LPTM_SHIFT)) & CAN_ESR2_LPTM_MASK)
/*! @} */

/*! @name CRCR - CRC register */
/*! @{ */
#define CAN_CRCR_TXCRC_MASK  (0x7FFFU)
#define CAN_CRCR_TXCRC_SHIFT (0U)
/*! TXCRC - Transmitted CRC value
 */
#define CAN_CRCR_TXCRC(x)    (((uint32_t)(((uint32_t)(x)) << CAN_CRCR_TXCRC_SHIFT)) & CAN_CRCR_TXCRC_MASK)
#define CAN_CRCR_MBCRC_MASK  (0x7F0000U)
#define CAN_CRCR_MBCRC_SHIFT (16U)
/*! MBCRC - CRC Mailbox
 */
#define CAN_CRCR_MBCRC(x) (((uint32_t)(((uint32_t)(x)) << CAN_CRCR_MBCRC_SHIFT)) & CAN_CRCR_MBCRC_MASK)
/*! @} */

/*! @name RXFGMASK - Rx FIFO Global Mask register */
/*! @{ */
#define CAN_RXFGMASK_FGM_MASK  (0xFFFFFFFFU)
#define CAN_RXFGMASK_FGM_SHIFT (0U)
/*! FGM - Rx FIFO Global Mask Bits
 */
#define CAN_RXFGMASK_FGM(x) (((uint32_t)(((uint32_t)(x)) << CAN_RXFGMASK_FGM_SHIFT)) & CAN_RXFGMASK_FGM_MASK)
/*! @} */

/*! @name RXFIR - Rx FIFO Information register */
/*! @{ */
#define CAN_RXFIR_IDHIT_MASK  (0x1FFU)
#define CAN_RXFIR_IDHIT_SHIFT (0U)
/*! IDHIT - Identifier Acceptance Filter Hit Indicator
 */
#define CAN_RXFIR_IDHIT(x) (((uint32_t)(((uint32_t)(x)) << CAN_RXFIR_IDHIT_SHIFT)) & CAN_RXFIR_IDHIT_MASK)
/*! @} */

/*! @name CBT - CAN Bit Timing register */
/*! @{ */
#define CAN_CBT_EPSEG2_MASK  (0x1FU)
#define CAN_CBT_EPSEG2_SHIFT (0U)
/*! EPSEG2 - Extended Phase Segment 2
 */
#define CAN_CBT_EPSEG2(x)    (((uint32_t)(((uint32_t)(x)) << CAN_CBT_EPSEG2_SHIFT)) & CAN_CBT_EPSEG2_MASK)
#define CAN_CBT_EPSEG1_MASK  (0x3E0U)
#define CAN_CBT_EPSEG1_SHIFT (5U)
/*! EPSEG1 - Extended Phase Segment 1
 */
#define CAN_CBT_EPSEG1(x)      (((uint32_t)(((uint32_t)(x)) << CAN_CBT_EPSEG1_SHIFT)) & CAN_CBT_EPSEG1_MASK)
#define CAN_CBT_EPROPSEG_MASK  (0xFC00U)
#define CAN_CBT_EPROPSEG_SHIFT (10U)
/*! EPROPSEG - Extended Propagation Segment
 */
#define CAN_CBT_EPROPSEG(x) (((uint32_t)(((uint32_t)(x)) << CAN_CBT_EPROPSEG_SHIFT)) & CAN_CBT_EPROPSEG_MASK)
#define CAN_CBT_ERJW_MASK   (0x1F0000U)
#define CAN_CBT_ERJW_SHIFT  (16U)
/*! ERJW - Extended Resync Jump Width
 */
#define CAN_CBT_ERJW(x)        (((uint32_t)(((uint32_t)(x)) << CAN_CBT_ERJW_SHIFT)) & CAN_CBT_ERJW_MASK)
#define CAN_CBT_EPRESDIV_MASK  (0x7FE00000U)
#define CAN_CBT_EPRESDIV_SHIFT (21U)
/*! EPRESDIV - Extended Prescaler Division Factor
 */
#define CAN_CBT_EPRESDIV(x) (((uint32_t)(((uint32_t)(x)) << CAN_CBT_EPRESDIV_SHIFT)) & CAN_CBT_EPRESDIV_MASK)
#define CAN_CBT_BTF_MASK    (0x80000000U)
#define CAN_CBT_BTF_SHIFT   (31U)
/*! BTF - Bit Timing Format Enable
 *  0b0..Extended bit time definitions disabled.
 *  0b1..Extended bit time definitions enabled.
 */
#define CAN_CBT_BTF(x) (((uint32_t)(((uint32_t)(x)) << CAN_CBT_BTF_SHIFT)) & CAN_CBT_BTF_MASK)
/*! @} */

/*! @name CS - Message Buffer 0 CS Register..Message Buffer 63 CS Register */
/*! @{ */
#define CAN_CS_TIME_STAMP_MASK  (0xFFFFU)
#define CAN_CS_TIME_STAMP_SHIFT (0U)
/*! TIME_STAMP - Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running
 *    Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field
 *    appears on the CAN bus.
 */
#define CAN_CS_TIME_STAMP(x) (((uint32_t)(((uint32_t)(x)) << CAN_CS_TIME_STAMP_SHIFT)) & CAN_CS_TIME_STAMP_MASK)
#define CAN_CS_DLC_MASK      (0xF0000U)
#define CAN_CS_DLC_SHIFT     (16U)
/*! DLC - Length of the data to be stored/transmitted.
 */
#define CAN_CS_DLC(x)    (((uint32_t)(((uint32_t)(x)) << CAN_CS_DLC_SHIFT)) & CAN_CS_DLC_MASK)
#define CAN_CS_RTR_MASK  (0x100000U)
#define CAN_CS_RTR_SHIFT (20U)
/*! RTR - Remote Transmission Request. One/zero for remote/data frame.
 */
#define CAN_CS_RTR(x)    (((uint32_t)(((uint32_t)(x)) << CAN_CS_RTR_SHIFT)) & CAN_CS_RTR_MASK)
#define CAN_CS_IDE_MASK  (0x200000U)
#define CAN_CS_IDE_SHIFT (21U)
/*! IDE - ID Extended. One/zero for extended/standard format frame.
 */
#define CAN_CS_IDE(x)    (((uint32_t)(((uint32_t)(x)) << CAN_CS_IDE_SHIFT)) & CAN_CS_IDE_MASK)
#define CAN_CS_SRR_MASK  (0x400000U)
#define CAN_CS_SRR_SHIFT (22U)
/*! SRR - Substitute Remote Request. Contains a fixed recessive bit.
 */
#define CAN_CS_SRR(x)     (((uint32_t)(((uint32_t)(x)) << CAN_CS_SRR_SHIFT)) & CAN_CS_SRR_MASK)
#define CAN_CS_CODE_MASK  (0xF000000U)
#define CAN_CS_CODE_SHIFT (24U)
/*! CODE - Message Buffer Code. This 4-bit field can be accessed (read or write) by the CPU and by
 *    the FlexCAN module itself, as part of the message buffer matching and arbitration process.
 */
#define CAN_CS_CODE(x)   (((uint32_t)(((uint32_t)(x)) << CAN_CS_CODE_SHIFT)) & CAN_CS_CODE_MASK)
#define CAN_CS_ESI_MASK  (0x20000000U)
#define CAN_CS_ESI_SHIFT (29U)
/*! ESI - Error State Indicator. This bit indicates if the transmitting node is error active or error passive.
 */
#define CAN_CS_ESI(x)    (((uint32_t)(((uint32_t)(x)) << CAN_CS_ESI_SHIFT)) & CAN_CS_ESI_MASK)
#define CAN_CS_BRS_MASK  (0x40000000U)
#define CAN_CS_BRS_SHIFT (30U)
/*! BRS - Bit Rate Switch. This bit defines whether the bit rate is switched inside a CAN FD format frame.
 */
#define CAN_CS_BRS(x)    (((uint32_t)(((uint32_t)(x)) << CAN_CS_BRS_SHIFT)) & CAN_CS_BRS_MASK)
#define CAN_CS_EDL_MASK  (0x80000000U)
#define CAN_CS_EDL_SHIFT (31U)
/*! EDL - Extended Data Length. This bit distinguishes between CAN format and CAN FD format frames.
 *    The EDL bit must not be set for Message Buffers configured to RANSWER with code field 0b1010.
 */
#define CAN_CS_EDL(x) (((uint32_t)(((uint32_t)(x)) << CAN_CS_EDL_SHIFT)) & CAN_CS_EDL_MASK)
/*! @} */

/* The count of CAN_CS */
#define CAN_CS_COUNT (64U)

/*! @name ID - Message Buffer 0 ID Register..Message Buffer 63 ID Register */
/*! @{ */
#define CAN_ID_EXT_MASK  (0x3FFFFU)
#define CAN_ID_EXT_SHIFT (0U)
/*! EXT - Contains extended (LOW word) identifier of message buffer.
 */
#define CAN_ID_EXT(x)    (((uint32_t)(((uint32_t)(x)) << CAN_ID_EXT_SHIFT)) & CAN_ID_EXT_MASK)
#define CAN_ID_STD_MASK  (0x1FFC0000U)
#define CAN_ID_STD_SHIFT (18U)
/*! STD - Contains standard/extended (HIGH word) identifier of message buffer.
 */
#define CAN_ID_STD(x)     (((uint32_t)(((uint32_t)(x)) << CAN_ID_STD_SHIFT)) & CAN_ID_STD_MASK)
#define CAN_ID_PRIO_MASK  (0xE0000000U)
#define CAN_ID_PRIO_SHIFT (29U)
/*! PRIO - Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only
 *    makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular
 *    ID to define the transmission priority.
 */
#define CAN_ID_PRIO(x) (((uint32_t)(((uint32_t)(x)) << CAN_ID_PRIO_SHIFT)) & CAN_ID_PRIO_MASK)
/*! @} */

/* The count of CAN_ID */
#define CAN_ID_COUNT (64U)

/*! @name WORD0 - Message Buffer 0 WORD0 Register..Message Buffer 63 WORD0 Register */
/*! @{ */
#define CAN_WORD0_DATA_BYTE_3_MASK  (0xFFU)
#define CAN_WORD0_DATA_BYTE_3_SHIFT (0U)
/*! DATA_BYTE_3 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD0_DATA_BYTE_3(x) \
    (((uint32_t)(((uint32_t)(x)) << CAN_WORD0_DATA_BYTE_3_SHIFT)) & CAN_WORD0_DATA_BYTE_3_MASK)
#define CAN_WORD0_DATA_BYTE_2_MASK  (0xFF00U)
#define CAN_WORD0_DATA_BYTE_2_SHIFT (8U)
/*! DATA_BYTE_2 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD0_DATA_BYTE_2(x) \
    (((uint32_t)(((uint32_t)(x)) << CAN_WORD0_DATA_BYTE_2_SHIFT)) & CAN_WORD0_DATA_BYTE_2_MASK)
#define CAN_WORD0_DATA_BYTE_1_MASK  (0xFF0000U)
#define CAN_WORD0_DATA_BYTE_1_SHIFT (16U)
/*! DATA_BYTE_1 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD0_DATA_BYTE_1(x) \
    (((uint32_t)(((uint32_t)(x)) << CAN_WORD0_DATA_BYTE_1_SHIFT)) & CAN_WORD0_DATA_BYTE_1_MASK)
#define CAN_WORD0_DATA_BYTE_0_MASK  (0xFF000000U)
#define CAN_WORD0_DATA_BYTE_0_SHIFT (24U)
/*! DATA_BYTE_0 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD0_DATA_BYTE_0(x) \
    (((uint32_t)(((uint32_t)(x)) << CAN_WORD0_DATA_BYTE_0_SHIFT)) & CAN_WORD0_DATA_BYTE_0_MASK)
/*! @} */

/* The count of CAN_WORD0 */
#define CAN_WORD0_COUNT (64U)

/*! @name WORD1 - Message Buffer 0 WORD1 Register..Message Buffer 63 WORD1 Register */
/*! @{ */
#define CAN_WORD1_DATA_BYTE_7_MASK  (0xFFU)
#define CAN_WORD1_DATA_BYTE_7_SHIFT (0U)
/*! DATA_BYTE_7 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD1_DATA_BYTE_7(x) \
    (((uint32_t)(((uint32_t)(x)) << CAN_WORD1_DATA_BYTE_7_SHIFT)) & CAN_WORD1_DATA_BYTE_7_MASK)
#define CAN_WORD1_DATA_BYTE_6_MASK  (0xFF00U)
#define CAN_WORD1_DATA_BYTE_6_SHIFT (8U)
/*! DATA_BYTE_6 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD1_DATA_BYTE_6(x) \
    (((uint32_t)(((uint32_t)(x)) << CAN_WORD1_DATA_BYTE_6_SHIFT)) & CAN_WORD1_DATA_BYTE_6_MASK)
#define CAN_WORD1_DATA_BYTE_5_MASK  (0xFF0000U)
#define CAN_WORD1_DATA_BYTE_5_SHIFT (16U)
/*! DATA_BYTE_5 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD1_DATA_BYTE_5(x) \
    (((uint32_t)(((uint32_t)(x)) << CAN_WORD1_DATA_BYTE_5_SHIFT)) & CAN_WORD1_DATA_BYTE_5_MASK)
#define CAN_WORD1_DATA_BYTE_4_MASK  (0xFF000000U)
#define CAN_WORD1_DATA_BYTE_4_SHIFT (24U)
/*! DATA_BYTE_4 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD1_DATA_BYTE_4(x) \
    (((uint32_t)(((uint32_t)(x)) << CAN_WORD1_DATA_BYTE_4_SHIFT)) & CAN_WORD1_DATA_BYTE_4_MASK)
/*! @} */

/* The count of CAN_WORD1 */
#define CAN_WORD1_COUNT (64U)

/*! @name RXIMR - Rx Individual Mask registers */
/*! @{ */
#define CAN_RXIMR_MI_MASK  (0xFFFFFFFFU)
#define CAN_RXIMR_MI_SHIFT (0U)
/*! MI - Individual Mask Bits
 */
#define CAN_RXIMR_MI(x) (((uint32_t)(((uint32_t)(x)) << CAN_RXIMR_MI_SHIFT)) & CAN_RXIMR_MI_MASK)
/*! @} */

/* The count of CAN_RXIMR */
#define CAN_RXIMR_COUNT (64U)

/*! @name MECR - Memory Error Control register */
/*! @{ */
#define CAN_MECR_NCEFAFRZ_MASK  (0x80U)
#define CAN_MECR_NCEFAFRZ_SHIFT (7U)
/*! NCEFAFRZ - Non-Correctable Errors In FlexCAN Access Put Device In Freeze Mode
 *  0b0..Keep normal operation.
 *  0b1..Put FlexCAN in Freeze mode (see section "Freeze mode").
 */
#define CAN_MECR_NCEFAFRZ(x)  (((uint32_t)(((uint32_t)(x)) << CAN_MECR_NCEFAFRZ_SHIFT)) & CAN_MECR_NCEFAFRZ_MASK)
#define CAN_MECR_ECCDIS_MASK  (0x100U)
#define CAN_MECR_ECCDIS_SHIFT (8U)
/*! ECCDIS - Error Correction Disable
 *  0b0..Enable memory error correction.
 *  0b1..Disable memory error correction.
 */
#define CAN_MECR_ECCDIS(x)     (((uint32_t)(((uint32_t)(x)) << CAN_MECR_ECCDIS_SHIFT)) & CAN_MECR_ECCDIS_MASK)
#define CAN_MECR_RERRDIS_MASK  (0x200U)
#define CAN_MECR_RERRDIS_SHIFT (9U)
/*! RERRDIS - Error Report Disable
 *  0b0..Enable updates of the error report registers.
 *  0b1..Disable updates of the error report registers.
 */
#define CAN_MECR_RERRDIS(x)     (((uint32_t)(((uint32_t)(x)) << CAN_MECR_RERRDIS_SHIFT)) & CAN_MECR_RERRDIS_MASK)
#define CAN_MECR_EXTERRIE_MASK  (0x2000U)
#define CAN_MECR_EXTERRIE_SHIFT (13U)
/*! EXTERRIE - Extended Error Injection Enable
 *  0b0..Error injection is applied only to the 32-bit word.
 *  0b1..Error injection is applied to the 64-bit word.
 */
#define CAN_MECR_EXTERRIE(x)   (((uint32_t)(((uint32_t)(x)) << CAN_MECR_EXTERRIE_SHIFT)) & CAN_MECR_EXTERRIE_MASK)
#define CAN_MECR_FAERRIE_MASK  (0x4000U)
#define CAN_MECR_FAERRIE_SHIFT (14U)
/*! FAERRIE - FlexCAN Access Error Injection Enable
 *  0b0..Injection is disabled.
 *  0b1..Injection is enabled.
 */
#define CAN_MECR_FAERRIE(x)    (((uint32_t)(((uint32_t)(x)) << CAN_MECR_FAERRIE_SHIFT)) & CAN_MECR_FAERRIE_MASK)
#define CAN_MECR_HAERRIE_MASK  (0x8000U)
#define CAN_MECR_HAERRIE_SHIFT (15U)
/*! HAERRIE - Host Access Error Injection Enable
 *  0b0..Injection is disabled.
 *  0b1..Injection is enabled.
 */
#define CAN_MECR_HAERRIE(x)    (((uint32_t)(((uint32_t)(x)) << CAN_MECR_HAERRIE_SHIFT)) & CAN_MECR_HAERRIE_MASK)
#define CAN_MECR_CEI_MSK_MASK  (0x10000U)
#define CAN_MECR_CEI_MSK_SHIFT (16U)
/*! CEI_MSK - Correctable Errors Interrupt Mask
 *  0b0..Interrupt is disabled.
 *  0b1..Interrupt is enabled.
 */
#define CAN_MECR_CEI_MSK(x)       (((uint32_t)(((uint32_t)(x)) << CAN_MECR_CEI_MSK_SHIFT)) & CAN_MECR_CEI_MSK_MASK)
#define CAN_MECR_FANCEI_MSK_MASK  (0x40000U)
#define CAN_MECR_FANCEI_MSK_SHIFT (18U)
/*! FANCEI_MSK - FlexCAN Access With Non-Correctable Errors Interrupt Mask
 *  0b0..Interrupt is disabled.
 *  0b1..Interrupt is enabled.
 */
#define CAN_MECR_FANCEI_MSK(x)    (((uint32_t)(((uint32_t)(x)) << CAN_MECR_FANCEI_MSK_SHIFT)) & CAN_MECR_FANCEI_MSK_MASK)
#define CAN_MECR_HANCEI_MSK_MASK  (0x80000U)
#define CAN_MECR_HANCEI_MSK_SHIFT (19U)
/*! HANCEI_MSK - Host Access With Non-Correctable Errors Interrupt Mask
 *  0b0..Interrupt is disabled.
 *  0b1..Interrupt is enabled.
 */
#define CAN_MECR_HANCEI_MSK(x)  (((uint32_t)(((uint32_t)(x)) << CAN_MECR_HANCEI_MSK_SHIFT)) & CAN_MECR_HANCEI_MSK_MASK)
#define CAN_MECR_ECRWRDIS_MASK  (0x80000000U)
#define CAN_MECR_ECRWRDIS_SHIFT (31U)
/*! ECRWRDIS - Error Configuration Register Write Disable
 *  0b0..Write is enabled.
 *  0b1..Write is disabled.
 */
#define CAN_MECR_ECRWRDIS(x) (((uint32_t)(((uint32_t)(x)) << CAN_MECR_ECRWRDIS_SHIFT)) & CAN_MECR_ECRWRDIS_MASK)
/*! @} */

/*! @name ERRIAR - Error Injection Address register */
/*! @{ */
#define CAN_ERRIAR_INJADDR_L_MASK  (0x3U)
#define CAN_ERRIAR_INJADDR_L_SHIFT (0U)
/*! INJADDR_L - Error Injection Address Low
 */
#define CAN_ERRIAR_INJADDR_L(x) \
    (((uint32_t)(((uint32_t)(x)) << CAN_ERRIAR_INJADDR_L_SHIFT)) & CAN_ERRIAR_INJADDR_L_MASK)
#define CAN_ERRIAR_INJADDR_H_MASK  (0x3FFCU)
#define CAN_ERRIAR_INJADDR_H_SHIFT (2U)
/*! INJADDR_H - Error Injection Address High
 */
#define CAN_ERRIAR_INJADDR_H(x) \
    (((uint32_t)(((uint32_t)(x)) << CAN_ERRIAR_INJADDR_H_SHIFT)) & CAN_ERRIAR_INJADDR_H_MASK)
/*! @} */

/*! @name ERRIDPR - Error Injection Data Pattern register */
/*! @{ */
#define CAN_ERRIDPR_DFLIP_MASK  (0xFFFFFFFFU)
#define CAN_ERRIDPR_DFLIP_SHIFT (0U)
/*! DFLIP - Data flip pattern
 */
#define CAN_ERRIDPR_DFLIP(x) (((uint32_t)(((uint32_t)(x)) << CAN_ERRIDPR_DFLIP_SHIFT)) & CAN_ERRIDPR_DFLIP_MASK)
/*! @} */

/*! @name ERRIPPR - Error Injection Parity Pattern register */
/*! @{ */
#define CAN_ERRIPPR_PFLIP0_MASK  (0x1FU)
#define CAN_ERRIPPR_PFLIP0_SHIFT (0U)
/*! PFLIP0 - Parity Flip Pattern For Byte 0 (Least Significant)
 */
#define CAN_ERRIPPR_PFLIP0(x)    (((uint32_t)(((uint32_t)(x)) << CAN_ERRIPPR_PFLIP0_SHIFT)) & CAN_ERRIPPR_PFLIP0_MASK)
#define CAN_ERRIPPR_PFLIP1_MASK  (0x1F00U)
#define CAN_ERRIPPR_PFLIP1_SHIFT (8U)
/*! PFLIP1 - Parity Flip Pattern For Byte 1
 */
#define CAN_ERRIPPR_PFLIP1(x)    (((uint32_t)(((uint32_t)(x)) << CAN_ERRIPPR_PFLIP1_SHIFT)) & CAN_ERRIPPR_PFLIP1_MASK)
#define CAN_ERRIPPR_PFLIP2_MASK  (0x1F0000U)
#define CAN_ERRIPPR_PFLIP2_SHIFT (16U)
/*! PFLIP2 - Parity Flip Pattern For Byte 2
 */
#define CAN_ERRIPPR_PFLIP2(x)    (((uint32_t)(((uint32_t)(x)) << CAN_ERRIPPR_PFLIP2_SHIFT)) & CAN_ERRIPPR_PFLIP2_MASK)
#define CAN_ERRIPPR_PFLIP3_MASK  (0x1F000000U)
#define CAN_ERRIPPR_PFLIP3_SHIFT (24U)
/*! PFLIP3 - Parity Flip Pattern For Byte 3 (most significant)
 */
#define CAN_ERRIPPR_PFLIP3(x) (((uint32_t)(((uint32_t)(x)) << CAN_ERRIPPR_PFLIP3_SHIFT)) & CAN_ERRIPPR_PFLIP3_MASK)
/*! @} */

/*! @name RERRAR - Error Report Address register */
/*! @{ */
#define CAN_RERRAR_ERRADDR_MASK  (0x3FFFU)
#define CAN_RERRAR_ERRADDR_SHIFT (0U)
/*! ERRADDR - Address Where Error Detected
 */
#define CAN_RERRAR_ERRADDR(x) (((uint32_t)(((uint32_t)(x)) << CAN_RERRAR_ERRADDR_SHIFT)) & CAN_RERRAR_ERRADDR_MASK)
#define CAN_RERRAR_SAID_MASK  (0x70000U)
#define CAN_RERRAR_SAID_SHIFT (16U)
/*! SAID - SAID
 */
#define CAN_RERRAR_SAID(x)   (((uint32_t)(((uint32_t)(x)) << CAN_RERRAR_SAID_SHIFT)) & CAN_RERRAR_SAID_MASK)
#define CAN_RERRAR_NCE_MASK  (0x1000000U)
#define CAN_RERRAR_NCE_SHIFT (24U)
/*! NCE - Non-Correctable Error
 *  0b0..Reporting a correctable error
 *  0b1..Reporting a non-correctable error
 */
#define CAN_RERRAR_NCE(x) (((uint32_t)(((uint32_t)(x)) << CAN_RERRAR_NCE_SHIFT)) & CAN_RERRAR_NCE_MASK)
/*! @} */

/*! @name RERRDR - Error Report Data register */
/*! @{ */
#define CAN_RERRDR_RDATA_MASK  (0xFFFFFFFFU)
#define CAN_RERRDR_RDATA_SHIFT (0U)
/*! RDATA - Raw data word read from memory with error
 */
#define CAN_RERRDR_RDATA(x) (((uint32_t)(((uint32_t)(x)) << CAN_RERRDR_RDATA_SHIFT)) & CAN_RERRDR_RDATA_MASK)
/*! @} */

/*! @name RERRSYNR - Error Report Syndrome register */
/*! @{ */
#define CAN_RERRSYNR_SYND0_MASK  (0x1FU)
#define CAN_RERRSYNR_SYND0_SHIFT (0U)
/*! SYND0 - Error Syndrome For Byte 0 (least significant)
 */
#define CAN_RERRSYNR_SYND0(x)  (((uint32_t)(((uint32_t)(x)) << CAN_RERRSYNR_SYND0_SHIFT)) & CAN_RERRSYNR_SYND0_MASK)
#define CAN_RERRSYNR_BE0_MASK  (0x80U)
#define CAN_RERRSYNR_BE0_SHIFT (7U)
/*! BE0 - Byte Enabled For Byte 0 (least significant)
 *  0b0..The byte was not read.
 *  0b1..The byte was read.
 */
#define CAN_RERRSYNR_BE0(x)      (((uint32_t)(((uint32_t)(x)) << CAN_RERRSYNR_BE0_SHIFT)) & CAN_RERRSYNR_BE0_MASK)
#define CAN_RERRSYNR_SYND1_MASK  (0x1F00U)
#define CAN_RERRSYNR_SYND1_SHIFT (8U)
/*! SYND1 - Error Syndrome for Byte 1
 */
#define CAN_RERRSYNR_SYND1(x)  (((uint32_t)(((uint32_t)(x)) << CAN_RERRSYNR_SYND1_SHIFT)) & CAN_RERRSYNR_SYND1_MASK)
#define CAN_RERRSYNR_BE1_MASK  (0x8000U)
#define CAN_RERRSYNR_BE1_SHIFT (15U)
/*! BE1 - Byte Enabled For Byte 1
 *  0b0..The byte was not read.
 *  0b1..The byte was read.
 */
#define CAN_RERRSYNR_BE1(x)      (((uint32_t)(((uint32_t)(x)) << CAN_RERRSYNR_BE1_SHIFT)) & CAN_RERRSYNR_BE1_MASK)
#define CAN_RERRSYNR_SYND2_MASK  (0x1F0000U)
#define CAN_RERRSYNR_SYND2_SHIFT (16U)
/*! SYND2 - Error Syndrome For Byte 2
 */
#define CAN_RERRSYNR_SYND2(x)  (((uint32_t)(((uint32_t)(x)) << CAN_RERRSYNR_SYND2_SHIFT)) & CAN_RERRSYNR_SYND2_MASK)
#define CAN_RERRSYNR_BE2_MASK  (0x800000U)
#define CAN_RERRSYNR_BE2_SHIFT (23U)
/*! BE2 - Byte Enabled For Byte 2
 *  0b0..The byte was not read.
 *  0b1..The byte was read.
 */
#define CAN_RERRSYNR_BE2(x)      (((uint32_t)(((uint32_t)(x)) << CAN_RERRSYNR_BE2_SHIFT)) & CAN_RERRSYNR_BE2_MASK)
#define CAN_RERRSYNR_SYND3_MASK  (0x1F000000U)
#define CAN_RERRSYNR_SYND3_SHIFT (24U)
/*! SYND3 - Error Syndrome For Byte 3 (most significant)
 */
#define CAN_RERRSYNR_SYND3(x)  (((uint32_t)(((uint32_t)(x)) << CAN_RERRSYNR_SYND3_SHIFT)) & CAN_RERRSYNR_SYND3_MASK)
#define CAN_RERRSYNR_BE3_MASK  (0x80000000U)
#define CAN_RERRSYNR_BE3_SHIFT (31U)
/*! BE3 - Byte Enabled For Byte 3 (most significant)
 *  0b0..The byte was not read.
 *  0b1..The byte was read.
 */
#define CAN_RERRSYNR_BE3(x) (((uint32_t)(((uint32_t)(x)) << CAN_RERRSYNR_BE3_SHIFT)) & CAN_RERRSYNR_BE3_MASK)
/*! @} */

/*! @name ERRSR - Error Status register */
/*! @{ */
#define CAN_ERRSR_CEIOF_MASK  (0x1U)
#define CAN_ERRSR_CEIOF_SHIFT (0U)
/*! CEIOF - Correctable Error Interrupt Overrun Flag
 *  0b0..No overrun on correctable errors
 *  0b1..Overrun on correctable errors
 */
#define CAN_ERRSR_CEIOF(x)       (((uint32_t)(((uint32_t)(x)) << CAN_ERRSR_CEIOF_SHIFT)) & CAN_ERRSR_CEIOF_MASK)
#define CAN_ERRSR_FANCEIOF_MASK  (0x4U)
#define CAN_ERRSR_FANCEIOF_SHIFT (2U)
/*! FANCEIOF - FlexCAN Access With Non-Correctable Error Interrupt Overrun Flag
 *  0b0..No overrun on non-correctable errors in FlexCAN access
 *  0b1..Overrun on non-correctable errors in FlexCAN access
 */
#define CAN_ERRSR_FANCEIOF(x)    (((uint32_t)(((uint32_t)(x)) << CAN_ERRSR_FANCEIOF_SHIFT)) & CAN_ERRSR_FANCEIOF_MASK)
#define CAN_ERRSR_HANCEIOF_MASK  (0x8U)
#define CAN_ERRSR_HANCEIOF_SHIFT (3U)
/*! HANCEIOF - Host Access With Non-Correctable Error Interrupt Overrun Flag
 *  0b0..No overrun on non-correctable errors in host access
 *  0b1..Overrun on non-correctable errors in host access
 */
#define CAN_ERRSR_HANCEIOF(x) (((uint32_t)(((uint32_t)(x)) << CAN_ERRSR_HANCEIOF_SHIFT)) & CAN_ERRSR_HANCEIOF_MASK)
#define CAN_ERRSR_CEIF_MASK   (0x10000U)
#define CAN_ERRSR_CEIF_SHIFT  (16U)
/*! CEIF - Correctable Error Interrupt Flag
 *  0b0..No correctable errors were detected so far.
 *  0b1..A correctable error was detected.
 */
#define CAN_ERRSR_CEIF(x)       (((uint32_t)(((uint32_t)(x)) << CAN_ERRSR_CEIF_SHIFT)) & CAN_ERRSR_CEIF_MASK)
#define CAN_ERRSR_FANCEIF_MASK  (0x40000U)
#define CAN_ERRSR_FANCEIF_SHIFT (18U)
/*! FANCEIF - FlexCAN Access With Non-Correctable Error Interrupt Flag
 *  0b0..No non-correctable errors were detected in FlexCAN accesses so far.
 *  0b1..A non-correctable error was detected in a FlexCAN access.
 */
#define CAN_ERRSR_FANCEIF(x)    (((uint32_t)(((uint32_t)(x)) << CAN_ERRSR_FANCEIF_SHIFT)) & CAN_ERRSR_FANCEIF_MASK)
#define CAN_ERRSR_HANCEIF_MASK  (0x80000U)
#define CAN_ERRSR_HANCEIF_SHIFT (19U)
/*! HANCEIF - Host Access With Non-Correctable Error Interrupt Flag
 *  0b0..No non-correctable errors were detected in host accesses so far.
 *  0b1..A non-correctable error was detected in a host access.
 */
#define CAN_ERRSR_HANCEIF(x) (((uint32_t)(((uint32_t)(x)) << CAN_ERRSR_HANCEIF_SHIFT)) & CAN_ERRSR_HANCEIF_MASK)
/*! @} */

/*! @name FDCTRL - CAN FD Control register */
/*! @{ */
#define CAN_FDCTRL_TDCVAL_MASK  (0x3FU)
#define CAN_FDCTRL_TDCVAL_SHIFT (0U)
/*! TDCVAL - Transceiver Delay Compensation Value
 */
#define CAN_FDCTRL_TDCVAL(x)    (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_TDCVAL_SHIFT)) & CAN_FDCTRL_TDCVAL_MASK)
#define CAN_FDCTRL_TDCOFF_MASK  (0x1F00U)
#define CAN_FDCTRL_TDCOFF_SHIFT (8U)
/*! TDCOFF - Transceiver Delay Compensation Offset
 */
#define CAN_FDCTRL_TDCOFF(x)     (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_TDCOFF_SHIFT)) & CAN_FDCTRL_TDCOFF_MASK)
#define CAN_FDCTRL_TDCFAIL_MASK  (0x4000U)
#define CAN_FDCTRL_TDCFAIL_SHIFT (14U)
/*! TDCFAIL - Transceiver Delay Compensation Fail
 *  0b0..Measured loop delay is in range.
 *  0b1..Measured loop delay is out of range.
 */
#define CAN_FDCTRL_TDCFAIL(x)  (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_TDCFAIL_SHIFT)) & CAN_FDCTRL_TDCFAIL_MASK)
#define CAN_FDCTRL_TDCEN_MASK  (0x8000U)
#define CAN_FDCTRL_TDCEN_SHIFT (15U)
/*! TDCEN - Transceiver Delay Compensation Enable
 *  0b0..TDC is disabled
 *  0b1..TDC is enabled
 */
#define CAN_FDCTRL_TDCEN(x)     (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_TDCEN_SHIFT)) & CAN_FDCTRL_TDCEN_MASK)
#define CAN_FDCTRL_MBDSR0_MASK  (0x30000U)
#define CAN_FDCTRL_MBDSR0_SHIFT (16U)
/*! MBDSR0 - Message Buffer Data Size for Region 0
 *  0b00..Selects 8 bytes per message buffer.
 *  0b01..Selects 16 bytes per message buffer.
 *  0b10..Selects 32 bytes per message buffer.
 *  0b11..Selects 64 bytes per message buffer.
 */
#define CAN_FDCTRL_MBDSR0(x)    (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_MBDSR0_SHIFT)) & CAN_FDCTRL_MBDSR0_MASK)
#define CAN_FDCTRL_MBDSR1_MASK  (0x180000U)
#define CAN_FDCTRL_MBDSR1_SHIFT (19U)
/*! MBDSR1 - Message Buffer Data Size for Region 1
 *  0b00..Selects 8 bytes per message buffer.
 *  0b01..Selects 16 bytes per message buffer.
 *  0b10..Selects 32 bytes per message buffer.
 *  0b11..Selects 64 bytes per message buffer.
 */
#define CAN_FDCTRL_MBDSR1(x)    (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_MBDSR1_SHIFT)) & CAN_FDCTRL_MBDSR1_MASK)
#define CAN_FDCTRL_FDRATE_MASK  (0x80000000U)
#define CAN_FDCTRL_FDRATE_SHIFT (31U)
/*! FDRATE - Bit Rate Switch Enable
 *  0b0..Transmit a frame in nominal rate. The BRS bit in the Tx MB has no effect.
 *  0b1..Transmit a frame with bit rate switching if the BRS bit in the Tx MB is recessive.
 */
#define CAN_FDCTRL_FDRATE(x) (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_FDRATE_SHIFT)) & CAN_FDCTRL_FDRATE_MASK)
/*! @} */

/*! @name FDCBT - CAN FD Bit Timing register */
/*! @{ */
#define CAN_FDCBT_FPSEG2_MASK  (0x7U)
#define CAN_FDCBT_FPSEG2_SHIFT (0U)
/*! FPSEG2 - Fast Phase Segment 2
 */
#define CAN_FDCBT_FPSEG2(x)    (((uint32_t)(((uint32_t)(x)) << CAN_FDCBT_FPSEG2_SHIFT)) & CAN_FDCBT_FPSEG2_MASK)
#define CAN_FDCBT_FPSEG1_MASK  (0xE0U)
#define CAN_FDCBT_FPSEG1_SHIFT (5U)
/*! FPSEG1 - Fast Phase Segment 1
 */
#define CAN_FDCBT_FPSEG1(x)      (((uint32_t)(((uint32_t)(x)) << CAN_FDCBT_FPSEG1_SHIFT)) & CAN_FDCBT_FPSEG1_MASK)
#define CAN_FDCBT_FPROPSEG_MASK  (0x7C00U)
#define CAN_FDCBT_FPROPSEG_SHIFT (10U)
/*! FPROPSEG - Fast Propagation Segment
 */
#define CAN_FDCBT_FPROPSEG(x) (((uint32_t)(((uint32_t)(x)) << CAN_FDCBT_FPROPSEG_SHIFT)) & CAN_FDCBT_FPROPSEG_MASK)
#define CAN_FDCBT_FRJW_MASK   (0x70000U)
#define CAN_FDCBT_FRJW_SHIFT  (16U)
/*! FRJW - Fast Resync Jump Width
 */
#define CAN_FDCBT_FRJW(x)        (((uint32_t)(((uint32_t)(x)) << CAN_FDCBT_FRJW_SHIFT)) & CAN_FDCBT_FRJW_MASK)
#define CAN_FDCBT_FPRESDIV_MASK  (0x3FF00000U)
#define CAN_FDCBT_FPRESDIV_SHIFT (20U)
/*! FPRESDIV - Fast Prescaler Division Factor
 */
#define CAN_FDCBT_FPRESDIV(x) (((uint32_t)(((uint32_t)(x)) << CAN_FDCBT_FPRESDIV_SHIFT)) & CAN_FDCBT_FPRESDIV_MASK)
/*! @} */

/*! @name FDCRC - CAN FD CRC register */
/*! @{ */
#define CAN_FDCRC_FD_TXCRC_MASK  (0x1FFFFFU)
#define CAN_FDCRC_FD_TXCRC_SHIFT (0U)
/*! FD_TXCRC - Extended Transmitted CRC value
 */
#define CAN_FDCRC_FD_TXCRC(x)    (((uint32_t)(((uint32_t)(x)) << CAN_FDCRC_FD_TXCRC_SHIFT)) & CAN_FDCRC_FD_TXCRC_MASK)
#define CAN_FDCRC_FD_MBCRC_MASK  (0x7F000000U)
#define CAN_FDCRC_FD_MBCRC_SHIFT (24U)
/*! FD_MBCRC - CRC Mailbox Number for FD_TXCRC
 */
#define CAN_FDCRC_FD_MBCRC(x) (((uint32_t)(((uint32_t)(x)) << CAN_FDCRC_FD_MBCRC_SHIFT)) & CAN_FDCRC_FD_MBCRC_MASK)
/*! @} */

/*!
 * @}
 */ /* end of group CAN_Register_Masks */

/* CAN - Peripheral instance base addresses */
/** Peripheral FLEXCAN1 base address */
#define FLEXCAN1_BASE (0x308C0000u)
/** Peripheral FLEXCAN1 base pointer */
#define FLEXCAN1 ((CAN_Type *)FLEXCAN1_BASE)
/** Peripheral FLEXCAN2 base address */
#define FLEXCAN2_BASE (0x308D0000u)
/** Peripheral FLEXCAN2 base pointer */
#define FLEXCAN2 ((CAN_Type *)FLEXCAN2_BASE)
/** Array initializer of CAN peripheral base addresses */
#define CAN_BASE_ADDRS                   \
    {                                    \
        0u, FLEXCAN1_BASE, FLEXCAN2_BASE \
    }
/** Array initializer of CAN peripheral base pointers */
#define CAN_BASE_PTRS                      \
    {                                      \
        (CAN_Type *)0u, FLEXCAN1, FLEXCAN2 \
    }
/** Interrupt vectors for the CAN peripheral type */
#define CAN_Rx_Warning_IRQS                       \
    {                                             \
        NotAvail_IRQn, CAN_FD1_IRQn, CAN_FD2_IRQn \
    }
#define CAN_Tx_Warning_IRQS                       \
    {                                             \
        NotAvail_IRQn, CAN_FD1_IRQn, CAN_FD2_IRQn \
    }
#define CAN_Wake_Up_IRQS                          \
    {                                             \
        NotAvail_IRQn, CAN_FD1_IRQn, CAN_FD2_IRQn \
    }
#define CAN_Error_IRQS                            \
    {                                             \
        NotAvail_IRQn, CAN_FD1_IRQn, CAN_FD2_IRQn \
    }
#define CAN_Bus_Off_IRQS                          \
    {                                             \
        NotAvail_IRQn, CAN_FD1_IRQn, CAN_FD2_IRQn \
    }
#define CAN_ORed_Message_buffer_IRQS              \
    {                                             \
        NotAvail_IRQn, CAN_FD1_IRQn, CAN_FD2_IRQn \
    }

/*!
 * @}
 */ /* end of group CAN_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- CCM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CCM_Peripheral_Access_Layer CCM Peripheral Access Layer
 * @{
 */

/** CCM - Register Layout Typedef */
typedef struct
{
    __IO uint32_t GPR0;     /**< General Purpose Register, offset: 0x0 */
    __IO uint32_t GPR0_SET; /**< General Purpose Register, offset: 0x4 */
    __IO uint32_t GPR0_CLR; /**< General Purpose Register, offset: 0x8 */
    __IO uint32_t GPR0_TOG; /**< General Purpose Register, offset: 0xC */
    uint8_t RESERVED_0[2032];
    struct
    {                               /* offset: 0x800, array step: 0x10 */
        __IO uint32_t PLL_CTRL;     /**< CCM PLL Control Register, array offset: 0x800, array step: 0x10 */
        __IO uint32_t PLL_CTRL_SET; /**< CCM PLL Control Register, array offset: 0x804, array step: 0x10 */
        __IO uint32_t PLL_CTRL_CLR; /**< CCM PLL Control Register, array offset: 0x808, array step: 0x10 */
        __IO uint32_t PLL_CTRL_TOG; /**< CCM PLL Control Register, array offset: 0x80C, array step: 0x10 */
    } PLL_CTRL[39];
    uint8_t RESERVED_1[13712];
    struct
    {                           /* offset: 0x4000, array step: 0x10 */
        __IO uint32_t CCGR;     /**< CCM Clock Gating Register, array offset: 0x4000, array step: 0x10 */
        __IO uint32_t CCGR_SET; /**< CCM Clock Gating Register, array offset: 0x4004, array step: 0x10 */
        __IO uint32_t CCGR_CLR; /**< CCM Clock Gating Register, array offset: 0x4008, array step: 0x10 */
        __IO uint32_t CCGR_TOG; /**< CCM Clock Gating Register, array offset: 0x400C, array step: 0x10 */
    } CCGR[192];
    uint8_t RESERVED_2[13312];
    struct
    {                                  /* offset: 0x8000, array step: 0x80 */
        __IO uint32_t TARGET_ROOT;     /**< Target Register, array offset: 0x8000, array step: 0x80 */
        __IO uint32_t TARGET_ROOT_SET; /**< Target Register, array offset: 0x8004, array step: 0x80 */
        __IO uint32_t TARGET_ROOT_CLR; /**< Target Register, array offset: 0x8008, array step: 0x80 */
        __IO uint32_t TARGET_ROOT_TOG; /**< Target Register, array offset: 0x800C, array step: 0x80 */
        __IO uint32_t MISC;            /**< Miscellaneous Register, array offset: 0x8010, array step: 0x80 */
        __IO uint32_t MISC_ROOT_SET;   /**< Miscellaneous Register, array offset: 0x8014, array step: 0x80 */
        __IO uint32_t MISC_ROOT_CLR;   /**< Miscellaneous Register, array offset: 0x8018, array step: 0x80 */
        __IO uint32_t MISC_ROOT_TOG;   /**< Miscellaneous Register, array offset: 0x801C, array step: 0x80 */
        __IO uint32_t POST;            /**< Post Divider Register, array offset: 0x8020, array step: 0x80 */
        __IO uint32_t POST_ROOT_SET;   /**< Post Divider Register, array offset: 0x8024, array step: 0x80 */
        __IO uint32_t POST_ROOT_CLR;   /**< Post Divider Register, array offset: 0x8028, array step: 0x80 */
        __IO uint32_t POST_ROOT_TOG;   /**< Post Divider Register, array offset: 0x802C, array step: 0x80 */
        __IO uint32_t PRE;             /**< Pre Divider Register, array offset: 0x8030, array step: 0x80 */
        __IO uint32_t PRE_ROOT_SET;    /**< Pre Divider Register, array offset: 0x8034, array step: 0x80 */
        __IO uint32_t PRE_ROOT_CLR;    /**< Pre Divider Register, array offset: 0x8038, array step: 0x80 */
        __IO uint32_t PRE_ROOT_TOG;    /**< Pre Divider Register, array offset: 0x803C, array step: 0x80 */
        uint8_t RESERVED_0[48];
        __IO uint32_t ACCESS_CTRL;          /**< Access Control Register, array offset: 0x8070, array step: 0x80 */
        __IO uint32_t ACCESS_CTRL_ROOT_SET; /**< Access Control Register, array offset: 0x8074, array step: 0x80 */
        __IO uint32_t ACCESS_CTRL_ROOT_CLR; /**< Access Control Register, array offset: 0x8078, array step: 0x80 */
        __IO uint32_t ACCESS_CTRL_ROOT_TOG; /**< Access Control Register, array offset: 0x807C, array step: 0x80 */
    } ROOT[142];
} CCM_Type;

/* ----------------------------------------------------------------------------
   -- CCM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CCM_Register_Masks CCM Register Masks
 * @{
 */

/*! @name GPR0 - General Purpose Register */
/*! @{ */
#define CCM_GPR0_GP0_MASK  (0xFFFFFFFFU)
#define CCM_GPR0_GP0_SHIFT (0U)
#define CCM_GPR0_GP0(x)    (((uint32_t)(((uint32_t)(x)) << CCM_GPR0_GP0_SHIFT)) & CCM_GPR0_GP0_MASK)
/*! @} */

/*! @name GPR0_SET - General Purpose Register */
/*! @{ */
#define CCM_GPR0_SET_GP0_MASK  (0xFFFFFFFFU)
#define CCM_GPR0_SET_GP0_SHIFT (0U)
#define CCM_GPR0_SET_GP0(x)    (((uint32_t)(((uint32_t)(x)) << CCM_GPR0_SET_GP0_SHIFT)) & CCM_GPR0_SET_GP0_MASK)
/*! @} */

/*! @name GPR0_CLR - General Purpose Register */
/*! @{ */
#define CCM_GPR0_CLR_GP0_MASK  (0xFFFFFFFFU)
#define CCM_GPR0_CLR_GP0_SHIFT (0U)
#define CCM_GPR0_CLR_GP0(x)    (((uint32_t)(((uint32_t)(x)) << CCM_GPR0_CLR_GP0_SHIFT)) & CCM_GPR0_CLR_GP0_MASK)
/*! @} */

/*! @name GPR0_TOG - General Purpose Register */
/*! @{ */
#define CCM_GPR0_TOG_GP0_MASK  (0xFFFFFFFFU)
#define CCM_GPR0_TOG_GP0_SHIFT (0U)
#define CCM_GPR0_TOG_GP0(x)    (((uint32_t)(((uint32_t)(x)) << CCM_GPR0_TOG_GP0_SHIFT)) & CCM_GPR0_TOG_GP0_MASK)
/*! @} */

/*! @name PLL_CTRL - CCM PLL Control Register */
/*! @{ */
#define CCM_PLL_CTRL_SETTING0_MASK  (0x3U)
#define CCM_PLL_CTRL_SETTING0_SHIFT (0U)
/*! SETTING0
 *  0b00..Domain clocks not needed
 *  0b01..Domain clocks needed when in RUN
 *  0b10..Domain clocks needed when in RUN and WAIT
 *  0b11..Domain clocks needed all the time
 */
#define CCM_PLL_CTRL_SETTING0(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PLL_CTRL_SETTING0_SHIFT)) & CCM_PLL_CTRL_SETTING0_MASK)
#define CCM_PLL_CTRL_SETTING1_MASK  (0x30U)
#define CCM_PLL_CTRL_SETTING1_SHIFT (4U)
/*! SETTING1
 *  0b00..Domain clocks not needed
 *  0b01..Domain clocks needed when in RUN
 *  0b10..Domain clocks needed when in RUN and WAIT
 *  0b11..Domain clocks needed all the time
 */
#define CCM_PLL_CTRL_SETTING1(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PLL_CTRL_SETTING1_SHIFT)) & CCM_PLL_CTRL_SETTING1_MASK)
#define CCM_PLL_CTRL_SETTING2_MASK  (0x300U)
#define CCM_PLL_CTRL_SETTING2_SHIFT (8U)
/*! SETTING2
 *  0b00..Domain clocks not needed
 *  0b01..Domain clocks needed when in RUN
 *  0b10..Domain clocks needed when in RUN and WAIT
 *  0b11..Domain clocks needed all the time
 */
#define CCM_PLL_CTRL_SETTING2(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PLL_CTRL_SETTING2_SHIFT)) & CCM_PLL_CTRL_SETTING2_MASK)
#define CCM_PLL_CTRL_SETTING3_MASK  (0x3000U)
#define CCM_PLL_CTRL_SETTING3_SHIFT (12U)
/*! SETTING3
 *  0b00..Domain clocks not needed
 *  0b01..Domain clocks needed when in RUN
 *  0b10..Domain clocks needed when in RUN and WAIT
 *  0b11..Domain clocks needed all the time
 */
#define CCM_PLL_CTRL_SETTING3(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PLL_CTRL_SETTING3_SHIFT)) & CCM_PLL_CTRL_SETTING3_MASK)
/*! @} */

/* The count of CCM_PLL_CTRL */
#define CCM_PLL_CTRL_COUNT (39U)

/*! @name PLL_CTRL_SET - CCM PLL Control Register */
/*! @{ */
#define CCM_PLL_CTRL_SET_SETTING0_MASK  (0x3U)
#define CCM_PLL_CTRL_SET_SETTING0_SHIFT (0U)
/*! SETTING0
 *  0b00..Domain clocks not needed
 *  0b01..Domain clocks needed when in RUN
 *  0b10..Domain clocks needed when in RUN and WAIT
 *  0b11..Domain clocks needed all the time
 */
#define CCM_PLL_CTRL_SET_SETTING0(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PLL_CTRL_SET_SETTING0_SHIFT)) & CCM_PLL_CTRL_SET_SETTING0_MASK)
#define CCM_PLL_CTRL_SET_SETTING1_MASK  (0x30U)
#define CCM_PLL_CTRL_SET_SETTING1_SHIFT (4U)
/*! SETTING1
 *  0b00..Domain clocks not needed
 *  0b01..Domain clocks needed when in RUN
 *  0b10..Domain clocks needed when in RUN and WAIT
 *  0b11..Domain clocks needed all the time
 */
#define CCM_PLL_CTRL_SET_SETTING1(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PLL_CTRL_SET_SETTING1_SHIFT)) & CCM_PLL_CTRL_SET_SETTING1_MASK)
#define CCM_PLL_CTRL_SET_SETTING2_MASK  (0x300U)
#define CCM_PLL_CTRL_SET_SETTING2_SHIFT (8U)
/*! SETTING2
 *  0b00..Domain clocks not needed
 *  0b01..Domain clocks needed when in RUN
 *  0b10..Domain clocks needed when in RUN and WAIT
 *  0b11..Domain clocks needed all the time
 */
#define CCM_PLL_CTRL_SET_SETTING2(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PLL_CTRL_SET_SETTING2_SHIFT)) & CCM_PLL_CTRL_SET_SETTING2_MASK)
#define CCM_PLL_CTRL_SET_SETTING3_MASK  (0x3000U)
#define CCM_PLL_CTRL_SET_SETTING3_SHIFT (12U)
/*! SETTING3
 *  0b00..Domain clocks not needed
 *  0b01..Domain clocks needed when in RUN
 *  0b10..Domain clocks needed when in RUN and WAIT
 *  0b11..Domain clocks needed all the time
 */
#define CCM_PLL_CTRL_SET_SETTING3(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PLL_CTRL_SET_SETTING3_SHIFT)) & CCM_PLL_CTRL_SET_SETTING3_MASK)
/*! @} */

/* The count of CCM_PLL_CTRL_SET */
#define CCM_PLL_CTRL_SET_COUNT (39U)

/*! @name PLL_CTRL_CLR - CCM PLL Control Register */
/*! @{ */
#define CCM_PLL_CTRL_CLR_SETTING0_MASK  (0x3U)
#define CCM_PLL_CTRL_CLR_SETTING0_SHIFT (0U)
/*! SETTING0
 *  0b00..Domain clocks not needed
 *  0b01..Domain clocks needed when in RUN
 *  0b10..Domain clocks needed when in RUN and WAIT
 *  0b11..Domain clocks needed all the time
 */
#define CCM_PLL_CTRL_CLR_SETTING0(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PLL_CTRL_CLR_SETTING0_SHIFT)) & CCM_PLL_CTRL_CLR_SETTING0_MASK)
#define CCM_PLL_CTRL_CLR_SETTING1_MASK  (0x30U)
#define CCM_PLL_CTRL_CLR_SETTING1_SHIFT (4U)
/*! SETTING1
 *  0b00..Domain clocks not needed
 *  0b01..Domain clocks needed when in RUN
 *  0b10..Domain clocks needed when in RUN and WAIT
 *  0b11..Domain clocks needed all the time
 */
#define CCM_PLL_CTRL_CLR_SETTING1(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PLL_CTRL_CLR_SETTING1_SHIFT)) & CCM_PLL_CTRL_CLR_SETTING1_MASK)
#define CCM_PLL_CTRL_CLR_SETTING2_MASK  (0x300U)
#define CCM_PLL_CTRL_CLR_SETTING2_SHIFT (8U)
/*! SETTING2
 *  0b00..Domain clocks not needed
 *  0b01..Domain clocks needed when in RUN
 *  0b10..Domain clocks needed when in RUN and WAIT
 *  0b11..Domain clocks needed all the time
 */
#define CCM_PLL_CTRL_CLR_SETTING2(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PLL_CTRL_CLR_SETTING2_SHIFT)) & CCM_PLL_CTRL_CLR_SETTING2_MASK)
#define CCM_PLL_CTRL_CLR_SETTING3_MASK  (0x3000U)
#define CCM_PLL_CTRL_CLR_SETTING3_SHIFT (12U)
/*! SETTING3
 *  0b00..Domain clocks not needed
 *  0b01..Domain clocks needed when in RUN
 *  0b10..Domain clocks needed when in RUN and WAIT
 *  0b11..Domain clocks needed all the time
 */
#define CCM_PLL_CTRL_CLR_SETTING3(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PLL_CTRL_CLR_SETTING3_SHIFT)) & CCM_PLL_CTRL_CLR_SETTING3_MASK)
/*! @} */

/* The count of CCM_PLL_CTRL_CLR */
#define CCM_PLL_CTRL_CLR_COUNT (39U)

/*! @name PLL_CTRL_TOG - CCM PLL Control Register */
/*! @{ */
#define CCM_PLL_CTRL_TOG_SETTING0_MASK  (0x3U)
#define CCM_PLL_CTRL_TOG_SETTING0_SHIFT (0U)
/*! SETTING0
 *  0b00..Domain clocks not needed
 *  0b01..Domain clocks needed when in RUN
 *  0b10..Domain clocks needed when in RUN and WAIT
 *  0b11..Domain clocks needed all the time
 */
#define CCM_PLL_CTRL_TOG_SETTING0(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PLL_CTRL_TOG_SETTING0_SHIFT)) & CCM_PLL_CTRL_TOG_SETTING0_MASK)
#define CCM_PLL_CTRL_TOG_SETTING1_MASK  (0x30U)
#define CCM_PLL_CTRL_TOG_SETTING1_SHIFT (4U)
/*! SETTING1
 *  0b00..Domain clocks not needed
 *  0b01..Domain clocks needed when in RUN
 *  0b10..Domain clocks needed when in RUN and WAIT
 *  0b11..Domain clocks needed all the time
 */
#define CCM_PLL_CTRL_TOG_SETTING1(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PLL_CTRL_TOG_SETTING1_SHIFT)) & CCM_PLL_CTRL_TOG_SETTING1_MASK)
#define CCM_PLL_CTRL_TOG_SETTING2_MASK  (0x300U)
#define CCM_PLL_CTRL_TOG_SETTING2_SHIFT (8U)
/*! SETTING2
 *  0b00..Domain clocks not needed
 *  0b01..Domain clocks needed when in RUN
 *  0b10..Domain clocks needed when in RUN and WAIT
 *  0b11..Domain clocks needed all the time
 */
#define CCM_PLL_CTRL_TOG_SETTING2(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PLL_CTRL_TOG_SETTING2_SHIFT)) & CCM_PLL_CTRL_TOG_SETTING2_MASK)
#define CCM_PLL_CTRL_TOG_SETTING3_MASK  (0x3000U)
#define CCM_PLL_CTRL_TOG_SETTING3_SHIFT (12U)
/*! SETTING3
 *  0b00..Domain clocks not needed
 *  0b01..Domain clocks needed when in RUN
 *  0b10..Domain clocks needed when in RUN and WAIT
 *  0b11..Domain clocks needed all the time
 */
#define CCM_PLL_CTRL_TOG_SETTING3(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PLL_CTRL_TOG_SETTING3_SHIFT)) & CCM_PLL_CTRL_TOG_SETTING3_MASK)
/*! @} */

/* The count of CCM_PLL_CTRL_TOG */
#define CCM_PLL_CTRL_TOG_COUNT (39U)

/*! @name CCGR - CCM Clock Gating Register */
/*! @{ */
#define CCM_CCGR_SETTING0_MASK  (0x3U)
#define CCM_CCGR_SETTING0_SHIFT (0U)
/*! SETTING0
 *  0b00..Domain clocks not needed
 *  0b01..Domain clocks needed when in RUN
 *  0b10..Domain clocks needed when in RUN and WAIT
 *  0b11..Domain clocks needed all the time
 */
#define CCM_CCGR_SETTING0(x)    (((uint32_t)(((uint32_t)(x)) << CCM_CCGR_SETTING0_SHIFT)) & CCM_CCGR_SETTING0_MASK)
#define CCM_CCGR_SETTING1_MASK  (0x30U)
#define CCM_CCGR_SETTING1_SHIFT (4U)
/*! SETTING1
 *  0b00..Domain clocks not needed
 *  0b01..Domain clocks needed when in RUN
 *  0b10..Domain clocks needed when in RUN and WAIT
 *  0b11..Domain clocks needed all the time
 */
#define CCM_CCGR_SETTING1(x)    (((uint32_t)(((uint32_t)(x)) << CCM_CCGR_SETTING1_SHIFT)) & CCM_CCGR_SETTING1_MASK)
#define CCM_CCGR_SETTING2_MASK  (0x300U)
#define CCM_CCGR_SETTING2_SHIFT (8U)
/*! SETTING2
 *  0b00..Domain clocks not needed
 *  0b01..Domain clocks needed when in RUN
 *  0b10..Domain clocks needed when in RUN and WAIT
 *  0b11..Domain clocks needed all the time
 */
#define CCM_CCGR_SETTING2(x)    (((uint32_t)(((uint32_t)(x)) << CCM_CCGR_SETTING2_SHIFT)) & CCM_CCGR_SETTING2_MASK)
#define CCM_CCGR_SETTING3_MASK  (0x3000U)
#define CCM_CCGR_SETTING3_SHIFT (12U)
/*! SETTING3
 *  0b00..Domain clocks not needed
 *  0b01..Domain clocks needed when in RUN
 *  0b10..Domain clocks needed when in RUN and WAIT
 *  0b11..Domain clocks needed all the time
 */
#define CCM_CCGR_SETTING3(x) (((uint32_t)(((uint32_t)(x)) << CCM_CCGR_SETTING3_SHIFT)) & CCM_CCGR_SETTING3_MASK)
/*! @} */

/* The count of CCM_CCGR */
#define CCM_CCGR_COUNT (192U)

/*! @name CCGR_SET - CCM Clock Gating Register */
/*! @{ */
#define CCM_CCGR_SET_SETTING0_MASK  (0x3U)
#define CCM_CCGR_SET_SETTING0_SHIFT (0U)
/*! SETTING0
 *  0b00..Domain clocks not needed
 *  0b01..Domain clocks needed when in RUN
 *  0b10..Domain clocks needed when in RUN and WAIT
 *  0b11..Domain clocks needed all the time
 */
#define CCM_CCGR_SET_SETTING0(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_CCGR_SET_SETTING0_SHIFT)) & CCM_CCGR_SET_SETTING0_MASK)
#define CCM_CCGR_SET_SETTING1_MASK  (0x30U)
#define CCM_CCGR_SET_SETTING1_SHIFT (4U)
/*! SETTING1
 *  0b00..Domain clocks not needed
 *  0b01..Domain clocks needed when in RUN
 *  0b10..Domain clocks needed when in RUN and WAIT
 *  0b11..Domain clocks needed all the time
 */
#define CCM_CCGR_SET_SETTING1(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_CCGR_SET_SETTING1_SHIFT)) & CCM_CCGR_SET_SETTING1_MASK)
#define CCM_CCGR_SET_SETTING2_MASK  (0x300U)
#define CCM_CCGR_SET_SETTING2_SHIFT (8U)
/*! SETTING2
 *  0b00..Domain clocks not needed
 *  0b01..Domain clocks needed when in RUN
 *  0b10..Domain clocks needed when in RUN and WAIT
 *  0b11..Domain clocks needed all the time
 */
#define CCM_CCGR_SET_SETTING2(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_CCGR_SET_SETTING2_SHIFT)) & CCM_CCGR_SET_SETTING2_MASK)
#define CCM_CCGR_SET_SETTING3_MASK  (0x3000U)
#define CCM_CCGR_SET_SETTING3_SHIFT (12U)
/*! SETTING3
 *  0b00..Domain clocks not needed
 *  0b01..Domain clocks needed when in RUN
 *  0b10..Domain clocks needed when in RUN and WAIT
 *  0b11..Domain clocks needed all the time
 */
#define CCM_CCGR_SET_SETTING3(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_CCGR_SET_SETTING3_SHIFT)) & CCM_CCGR_SET_SETTING3_MASK)
/*! @} */

/* The count of CCM_CCGR_SET */
#define CCM_CCGR_SET_COUNT (192U)

/*! @name CCGR_CLR - CCM Clock Gating Register */
/*! @{ */
#define CCM_CCGR_CLR_SETTING0_MASK  (0x3U)
#define CCM_CCGR_CLR_SETTING0_SHIFT (0U)
/*! SETTING0
 *  0b00..Domain clocks not needed
 *  0b01..Domain clocks needed when in RUN
 *  0b10..Domain clocks needed when in RUN and WAIT
 *  0b11..Domain clocks needed all the time
 */
#define CCM_CCGR_CLR_SETTING0(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_CCGR_CLR_SETTING0_SHIFT)) & CCM_CCGR_CLR_SETTING0_MASK)
#define CCM_CCGR_CLR_SETTING1_MASK  (0x30U)
#define CCM_CCGR_CLR_SETTING1_SHIFT (4U)
/*! SETTING1
 *  0b00..Domain clocks not needed
 *  0b01..Domain clocks needed when in RUN
 *  0b10..Domain clocks needed when in RUN and WAIT
 *  0b11..Domain clocks needed all the time
 */
#define CCM_CCGR_CLR_SETTING1(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_CCGR_CLR_SETTING1_SHIFT)) & CCM_CCGR_CLR_SETTING1_MASK)
#define CCM_CCGR_CLR_SETTING2_MASK  (0x300U)
#define CCM_CCGR_CLR_SETTING2_SHIFT (8U)
/*! SETTING2
 *  0b00..Domain clocks not needed
 *  0b01..Domain clocks needed when in RUN
 *  0b10..Domain clocks needed when in RUN and WAIT
 *  0b11..Domain clocks needed all the time
 */
#define CCM_CCGR_CLR_SETTING2(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_CCGR_CLR_SETTING2_SHIFT)) & CCM_CCGR_CLR_SETTING2_MASK)
#define CCM_CCGR_CLR_SETTING3_MASK  (0x3000U)
#define CCM_CCGR_CLR_SETTING3_SHIFT (12U)
/*! SETTING3
 *  0b00..Domain clocks not needed
 *  0b01..Domain clocks needed when in RUN
 *  0b10..Domain clocks needed when in RUN and WAIT
 *  0b11..Domain clocks needed all the time
 */
#define CCM_CCGR_CLR_SETTING3(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_CCGR_CLR_SETTING3_SHIFT)) & CCM_CCGR_CLR_SETTING3_MASK)
/*! @} */

/* The count of CCM_CCGR_CLR */
#define CCM_CCGR_CLR_COUNT (192U)

/*! @name CCGR_TOG - CCM Clock Gating Register */
/*! @{ */
#define CCM_CCGR_TOG_SETTING0_MASK  (0x3U)
#define CCM_CCGR_TOG_SETTING0_SHIFT (0U)
/*! SETTING0
 *  0b00..Domain clocks not needed
 *  0b01..Domain clocks needed when in RUN
 *  0b10..Domain clocks needed when in RUN and WAIT
 *  0b11..Domain clocks needed all the time
 */
#define CCM_CCGR_TOG_SETTING0(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_CCGR_TOG_SETTING0_SHIFT)) & CCM_CCGR_TOG_SETTING0_MASK)
#define CCM_CCGR_TOG_SETTING1_MASK  (0x30U)
#define CCM_CCGR_TOG_SETTING1_SHIFT (4U)
/*! SETTING1
 *  0b00..Domain clocks not needed
 *  0b01..Domain clocks needed when in RUN
 *  0b10..Domain clocks needed when in RUN and WAIT
 *  0b11..Domain clocks needed all the time
 */
#define CCM_CCGR_TOG_SETTING1(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_CCGR_TOG_SETTING1_SHIFT)) & CCM_CCGR_TOG_SETTING1_MASK)
#define CCM_CCGR_TOG_SETTING2_MASK  (0x300U)
#define CCM_CCGR_TOG_SETTING2_SHIFT (8U)
/*! SETTING2
 *  0b00..Domain clocks not needed
 *  0b01..Domain clocks needed when in RUN
 *  0b10..Domain clocks needed when in RUN and WAIT
 *  0b11..Domain clocks needed all the time
 */
#define CCM_CCGR_TOG_SETTING2(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_CCGR_TOG_SETTING2_SHIFT)) & CCM_CCGR_TOG_SETTING2_MASK)
#define CCM_CCGR_TOG_SETTING3_MASK  (0x3000U)
#define CCM_CCGR_TOG_SETTING3_SHIFT (12U)
/*! SETTING3
 *  0b00..Domain clocks not needed
 *  0b01..Domain clocks needed when in RUN
 *  0b10..Domain clocks needed when in RUN and WAIT
 *  0b11..Domain clocks needed all the time
 */
#define CCM_CCGR_TOG_SETTING3(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_CCGR_TOG_SETTING3_SHIFT)) & CCM_CCGR_TOG_SETTING3_MASK)
/*! @} */

/* The count of CCM_CCGR_TOG */
#define CCM_CCGR_TOG_COUNT (192U)

/*! @name TARGET_ROOT - Target Register */
/*! @{ */
#define CCM_TARGET_ROOT_POST_PODF_MASK  (0x3FU)
#define CCM_TARGET_ROOT_POST_PODF_SHIFT (0U)
/*! POST_PODF
 *  0b000000..Divide by 1
 *  0b000001..Divide by 2
 *  0b000010..Divide by 3
 *  0b000011..Divide by 4
 *  0b000100..Divide by 5
 *  0b000101..Divide by 6
 *  0b111111..Divide by 64
 */
#define CCM_TARGET_ROOT_POST_PODF(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_TARGET_ROOT_POST_PODF_SHIFT)) & CCM_TARGET_ROOT_POST_PODF_MASK)
#define CCM_TARGET_ROOT_PRE_PODF_MASK  (0x70000U)
#define CCM_TARGET_ROOT_PRE_PODF_SHIFT (16U)
/*! PRE_PODF
 *  0b000..Divide by 1
 *  0b001..Divide by 2
 *  0b010..Divide by 3
 *  0b011..Divide by 4
 *  0b100..Divide by 5
 *  0b101..Divide by 6
 *  0b110..Divide by 7
 *  0b111..Divide by 8
 */
#define CCM_TARGET_ROOT_PRE_PODF(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_TARGET_ROOT_PRE_PODF_SHIFT)) & CCM_TARGET_ROOT_PRE_PODF_MASK)
#define CCM_TARGET_ROOT_MUX_MASK     (0x7000000U)
#define CCM_TARGET_ROOT_MUX_SHIFT    (24U)
#define CCM_TARGET_ROOT_MUX(x)       (((uint32_t)(((uint32_t)(x)) << CCM_TARGET_ROOT_MUX_SHIFT)) & CCM_TARGET_ROOT_MUX_MASK)
#define CCM_TARGET_ROOT_ENABLE_MASK  (0x10000000U)
#define CCM_TARGET_ROOT_ENABLE_SHIFT (28U)
/*! ENABLE
 *  0b0..clock root is OFF
 *  0b1..clock root is ON
 */
#define CCM_TARGET_ROOT_ENABLE(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_TARGET_ROOT_ENABLE_SHIFT)) & CCM_TARGET_ROOT_ENABLE_MASK)
/*! @} */

/* The count of CCM_TARGET_ROOT */
#define CCM_TARGET_ROOT_COUNT (142U)

/*! @name TARGET_ROOT_SET - Target Register */
/*! @{ */
#define CCM_TARGET_ROOT_SET_POST_PODF_MASK  (0x3FU)
#define CCM_TARGET_ROOT_SET_POST_PODF_SHIFT (0U)
/*! POST_PODF
 *  0b000000..Divide by 1
 *  0b000001..Divide by 2
 *  0b000010..Divide by 3
 *  0b000011..Divide by 4
 *  0b000100..Divide by 5
 *  0b000101..Divide by 6
 *  0b111111..Divide by 64
 */
#define CCM_TARGET_ROOT_SET_POST_PODF(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_TARGET_ROOT_SET_POST_PODF_SHIFT)) & CCM_TARGET_ROOT_SET_POST_PODF_MASK)
#define CCM_TARGET_ROOT_SET_PRE_PODF_MASK  (0x70000U)
#define CCM_TARGET_ROOT_SET_PRE_PODF_SHIFT (16U)
/*! PRE_PODF
 *  0b000..Divide by 1
 *  0b001..Divide by 2
 *  0b010..Divide by 3
 *  0b011..Divide by 4
 *  0b100..Divide by 5
 *  0b101..Divide by 6
 *  0b110..Divide by 7
 *  0b111..Divide by 8
 */
#define CCM_TARGET_ROOT_SET_PRE_PODF(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_TARGET_ROOT_SET_PRE_PODF_SHIFT)) & CCM_TARGET_ROOT_SET_PRE_PODF_MASK)
#define CCM_TARGET_ROOT_SET_MUX_MASK  (0x7000000U)
#define CCM_TARGET_ROOT_SET_MUX_SHIFT (24U)
#define CCM_TARGET_ROOT_SET_MUX(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_TARGET_ROOT_SET_MUX_SHIFT)) & CCM_TARGET_ROOT_SET_MUX_MASK)
#define CCM_TARGET_ROOT_SET_ENABLE_MASK  (0x10000000U)
#define CCM_TARGET_ROOT_SET_ENABLE_SHIFT (28U)
/*! ENABLE
 *  0b0..clock root is OFF
 *  0b1..clock root is ON
 */
#define CCM_TARGET_ROOT_SET_ENABLE(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_TARGET_ROOT_SET_ENABLE_SHIFT)) & CCM_TARGET_ROOT_SET_ENABLE_MASK)
/*! @} */

/* The count of CCM_TARGET_ROOT_SET */
#define CCM_TARGET_ROOT_SET_COUNT (142U)

/*! @name TARGET_ROOT_CLR - Target Register */
/*! @{ */
#define CCM_TARGET_ROOT_CLR_POST_PODF_MASK  (0x3FU)
#define CCM_TARGET_ROOT_CLR_POST_PODF_SHIFT (0U)
/*! POST_PODF
 *  0b000000..Divide by 1
 *  0b000001..Divide by 2
 *  0b000010..Divide by 3
 *  0b000011..Divide by 4
 *  0b000100..Divide by 5
 *  0b000101..Divide by 6
 *  0b111111..Divide by 64
 */
#define CCM_TARGET_ROOT_CLR_POST_PODF(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_TARGET_ROOT_CLR_POST_PODF_SHIFT)) & CCM_TARGET_ROOT_CLR_POST_PODF_MASK)
#define CCM_TARGET_ROOT_CLR_PRE_PODF_MASK  (0x70000U)
#define CCM_TARGET_ROOT_CLR_PRE_PODF_SHIFT (16U)
/*! PRE_PODF
 *  0b000..Divide by 1
 *  0b001..Divide by 2
 *  0b010..Divide by 3
 *  0b011..Divide by 4
 *  0b100..Divide by 5
 *  0b101..Divide by 6
 *  0b110..Divide by 7
 *  0b111..Divide by 8
 */
#define CCM_TARGET_ROOT_CLR_PRE_PODF(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_TARGET_ROOT_CLR_PRE_PODF_SHIFT)) & CCM_TARGET_ROOT_CLR_PRE_PODF_MASK)
#define CCM_TARGET_ROOT_CLR_MUX_MASK  (0x7000000U)
#define CCM_TARGET_ROOT_CLR_MUX_SHIFT (24U)
#define CCM_TARGET_ROOT_CLR_MUX(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_TARGET_ROOT_CLR_MUX_SHIFT)) & CCM_TARGET_ROOT_CLR_MUX_MASK)
#define CCM_TARGET_ROOT_CLR_ENABLE_MASK  (0x10000000U)
#define CCM_TARGET_ROOT_CLR_ENABLE_SHIFT (28U)
/*! ENABLE
 *  0b0..clock root is OFF
 *  0b1..clock root is ON
 */
#define CCM_TARGET_ROOT_CLR_ENABLE(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_TARGET_ROOT_CLR_ENABLE_SHIFT)) & CCM_TARGET_ROOT_CLR_ENABLE_MASK)
/*! @} */

/* The count of CCM_TARGET_ROOT_CLR */
#define CCM_TARGET_ROOT_CLR_COUNT (142U)

/*! @name TARGET_ROOT_TOG - Target Register */
/*! @{ */
#define CCM_TARGET_ROOT_TOG_POST_PODF_MASK  (0x3FU)
#define CCM_TARGET_ROOT_TOG_POST_PODF_SHIFT (0U)
/*! POST_PODF
 *  0b000000..Divide by 1
 *  0b000001..Divide by 2
 *  0b000010..Divide by 3
 *  0b000011..Divide by 4
 *  0b000100..Divide by 5
 *  0b000101..Divide by 6
 *  0b111111..Divide by 64
 */
#define CCM_TARGET_ROOT_TOG_POST_PODF(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_TARGET_ROOT_TOG_POST_PODF_SHIFT)) & CCM_TARGET_ROOT_TOG_POST_PODF_MASK)
#define CCM_TARGET_ROOT_TOG_PRE_PODF_MASK  (0x70000U)
#define CCM_TARGET_ROOT_TOG_PRE_PODF_SHIFT (16U)
/*! PRE_PODF
 *  0b000..Divide by 1
 *  0b001..Divide by 2
 *  0b010..Divide by 3
 *  0b011..Divide by 4
 *  0b100..Divide by 5
 *  0b101..Divide by 6
 *  0b110..Divide by 7
 *  0b111..Divide by 8
 */
#define CCM_TARGET_ROOT_TOG_PRE_PODF(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_TARGET_ROOT_TOG_PRE_PODF_SHIFT)) & CCM_TARGET_ROOT_TOG_PRE_PODF_MASK)
#define CCM_TARGET_ROOT_TOG_MUX_MASK  (0x7000000U)
#define CCM_TARGET_ROOT_TOG_MUX_SHIFT (24U)
#define CCM_TARGET_ROOT_TOG_MUX(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_TARGET_ROOT_TOG_MUX_SHIFT)) & CCM_TARGET_ROOT_TOG_MUX_MASK)
#define CCM_TARGET_ROOT_TOG_ENABLE_MASK  (0x10000000U)
#define CCM_TARGET_ROOT_TOG_ENABLE_SHIFT (28U)
/*! ENABLE
 *  0b0..clock root is OFF
 *  0b1..clock root is ON
 */
#define CCM_TARGET_ROOT_TOG_ENABLE(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_TARGET_ROOT_TOG_ENABLE_SHIFT)) & CCM_TARGET_ROOT_TOG_ENABLE_MASK)
/*! @} */

/* The count of CCM_TARGET_ROOT_TOG */
#define CCM_TARGET_ROOT_TOG_COUNT (142U)

/*! @name MISC - Miscellaneous Register */
/*! @{ */
#define CCM_MISC_AUTHEN_FAIL_MASK  (0x1U)
#define CCM_MISC_AUTHEN_FAIL_SHIFT (0U)
#define CCM_MISC_AUTHEN_FAIL(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_MISC_AUTHEN_FAIL_SHIFT)) & CCM_MISC_AUTHEN_FAIL_MASK)
#define CCM_MISC_TIMEOUT_MASK  (0x10U)
#define CCM_MISC_TIMEOUT_SHIFT (4U)
#define CCM_MISC_TIMEOUT(x)    (((uint32_t)(((uint32_t)(x)) << CCM_MISC_TIMEOUT_SHIFT)) & CCM_MISC_TIMEOUT_MASK)
#define CCM_MISC_VIOLATE_MASK  (0x100U)
#define CCM_MISC_VIOLATE_SHIFT (8U)
#define CCM_MISC_VIOLATE(x)    (((uint32_t)(((uint32_t)(x)) << CCM_MISC_VIOLATE_SHIFT)) & CCM_MISC_VIOLATE_MASK)
/*! @} */

/* The count of CCM_MISC */
#define CCM_MISC_COUNT (142U)

/*! @name MISC_ROOT_SET - Miscellaneous Register */
/*! @{ */
#define CCM_MISC_ROOT_SET_AUTHEN_FAIL_MASK  (0x1U)
#define CCM_MISC_ROOT_SET_AUTHEN_FAIL_SHIFT (0U)
#define CCM_MISC_ROOT_SET_AUTHEN_FAIL(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_MISC_ROOT_SET_AUTHEN_FAIL_SHIFT)) & CCM_MISC_ROOT_SET_AUTHEN_FAIL_MASK)
#define CCM_MISC_ROOT_SET_TIMEOUT_MASK  (0x10U)
#define CCM_MISC_ROOT_SET_TIMEOUT_SHIFT (4U)
#define CCM_MISC_ROOT_SET_TIMEOUT(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_MISC_ROOT_SET_TIMEOUT_SHIFT)) & CCM_MISC_ROOT_SET_TIMEOUT_MASK)
#define CCM_MISC_ROOT_SET_VIOLATE_MASK  (0x100U)
#define CCM_MISC_ROOT_SET_VIOLATE_SHIFT (8U)
#define CCM_MISC_ROOT_SET_VIOLATE(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_MISC_ROOT_SET_VIOLATE_SHIFT)) & CCM_MISC_ROOT_SET_VIOLATE_MASK)
/*! @} */

/* The count of CCM_MISC_ROOT_SET */
#define CCM_MISC_ROOT_SET_COUNT (142U)

/*! @name MISC_ROOT_CLR - Miscellaneous Register */
/*! @{ */
#define CCM_MISC_ROOT_CLR_AUTHEN_FAIL_MASK  (0x1U)
#define CCM_MISC_ROOT_CLR_AUTHEN_FAIL_SHIFT (0U)
#define CCM_MISC_ROOT_CLR_AUTHEN_FAIL(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_MISC_ROOT_CLR_AUTHEN_FAIL_SHIFT)) & CCM_MISC_ROOT_CLR_AUTHEN_FAIL_MASK)
#define CCM_MISC_ROOT_CLR_TIMEOUT_MASK  (0x10U)
#define CCM_MISC_ROOT_CLR_TIMEOUT_SHIFT (4U)
#define CCM_MISC_ROOT_CLR_TIMEOUT(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_MISC_ROOT_CLR_TIMEOUT_SHIFT)) & CCM_MISC_ROOT_CLR_TIMEOUT_MASK)
#define CCM_MISC_ROOT_CLR_VIOLATE_MASK  (0x100U)
#define CCM_MISC_ROOT_CLR_VIOLATE_SHIFT (8U)
#define CCM_MISC_ROOT_CLR_VIOLATE(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_MISC_ROOT_CLR_VIOLATE_SHIFT)) & CCM_MISC_ROOT_CLR_VIOLATE_MASK)
/*! @} */

/* The count of CCM_MISC_ROOT_CLR */
#define CCM_MISC_ROOT_CLR_COUNT (142U)

/*! @name MISC_ROOT_TOG - Miscellaneous Register */
/*! @{ */
#define CCM_MISC_ROOT_TOG_AUTHEN_FAIL_MASK  (0x1U)
#define CCM_MISC_ROOT_TOG_AUTHEN_FAIL_SHIFT (0U)
#define CCM_MISC_ROOT_TOG_AUTHEN_FAIL(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_MISC_ROOT_TOG_AUTHEN_FAIL_SHIFT)) & CCM_MISC_ROOT_TOG_AUTHEN_FAIL_MASK)
#define CCM_MISC_ROOT_TOG_TIMEOUT_MASK  (0x10U)
#define CCM_MISC_ROOT_TOG_TIMEOUT_SHIFT (4U)
#define CCM_MISC_ROOT_TOG_TIMEOUT(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_MISC_ROOT_TOG_TIMEOUT_SHIFT)) & CCM_MISC_ROOT_TOG_TIMEOUT_MASK)
#define CCM_MISC_ROOT_TOG_VIOLATE_MASK  (0x100U)
#define CCM_MISC_ROOT_TOG_VIOLATE_SHIFT (8U)
#define CCM_MISC_ROOT_TOG_VIOLATE(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_MISC_ROOT_TOG_VIOLATE_SHIFT)) & CCM_MISC_ROOT_TOG_VIOLATE_MASK)
/*! @} */

/* The count of CCM_MISC_ROOT_TOG */
#define CCM_MISC_ROOT_TOG_COUNT (142U)

/*! @name POST - Post Divider Register */
/*! @{ */
#define CCM_POST_POST_PODF_MASK  (0x3FU)
#define CCM_POST_POST_PODF_SHIFT (0U)
/*! POST_PODF
 *  0b000000..Divide by 1
 *  0b000001..Divide by 2
 *  0b000010..Divide by 3
 *  0b000011..Divide by 4
 *  0b000100..Divide by 5
 *  0b000101..Divide by 6
 *  0b111111..Divide by 64
 */
#define CCM_POST_POST_PODF(x) (((uint32_t)(((uint32_t)(x)) << CCM_POST_POST_PODF_SHIFT)) & CCM_POST_POST_PODF_MASK)
#define CCM_POST_BUSY1_MASK   (0x80U)
#define CCM_POST_BUSY1_SHIFT  (7U)
#define CCM_POST_BUSY1(x)     (((uint32_t)(((uint32_t)(x)) << CCM_POST_BUSY1_SHIFT)) & CCM_POST_BUSY1_MASK)
#define CCM_POST_SELECT_MASK  (0x10000000U)
#define CCM_POST_SELECT_SHIFT (28U)
/*! SELECT
 *  0b0..select branch A
 *  0b1..select branch B
 */
#define CCM_POST_SELECT(x)   (((uint32_t)(((uint32_t)(x)) << CCM_POST_SELECT_SHIFT)) & CCM_POST_SELECT_MASK)
#define CCM_POST_BUSY2_MASK  (0x80000000U)
#define CCM_POST_BUSY2_SHIFT (31U)
#define CCM_POST_BUSY2(x)    (((uint32_t)(((uint32_t)(x)) << CCM_POST_BUSY2_SHIFT)) & CCM_POST_BUSY2_MASK)
/*! @} */

/* The count of CCM_POST */
#define CCM_POST_COUNT (142U)

/*! @name POST_ROOT_SET - Post Divider Register */
/*! @{ */
#define CCM_POST_ROOT_SET_POST_PODF_MASK  (0x3FU)
#define CCM_POST_ROOT_SET_POST_PODF_SHIFT (0U)
/*! POST_PODF
 *  0b000000..Divide by 1
 *  0b000001..Divide by 2
 *  0b000010..Divide by 3
 *  0b000011..Divide by 4
 *  0b000100..Divide by 5
 *  0b000101..Divide by 6
 *  0b111111..Divide by 64
 */
#define CCM_POST_ROOT_SET_POST_PODF(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_POST_ROOT_SET_POST_PODF_SHIFT)) & CCM_POST_ROOT_SET_POST_PODF_MASK)
#define CCM_POST_ROOT_SET_BUSY1_MASK  (0x80U)
#define CCM_POST_ROOT_SET_BUSY1_SHIFT (7U)
#define CCM_POST_ROOT_SET_BUSY1(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_POST_ROOT_SET_BUSY1_SHIFT)) & CCM_POST_ROOT_SET_BUSY1_MASK)
#define CCM_POST_ROOT_SET_SELECT_MASK  (0x10000000U)
#define CCM_POST_ROOT_SET_SELECT_SHIFT (28U)
/*! SELECT
 *  0b0..select branch A
 *  0b1..select branch B
 */
#define CCM_POST_ROOT_SET_SELECT(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_POST_ROOT_SET_SELECT_SHIFT)) & CCM_POST_ROOT_SET_SELECT_MASK)
#define CCM_POST_ROOT_SET_BUSY2_MASK  (0x80000000U)
#define CCM_POST_ROOT_SET_BUSY2_SHIFT (31U)
#define CCM_POST_ROOT_SET_BUSY2(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_POST_ROOT_SET_BUSY2_SHIFT)) & CCM_POST_ROOT_SET_BUSY2_MASK)
/*! @} */

/* The count of CCM_POST_ROOT_SET */
#define CCM_POST_ROOT_SET_COUNT (142U)

/*! @name POST_ROOT_CLR - Post Divider Register */
/*! @{ */
#define CCM_POST_ROOT_CLR_POST_PODF_MASK  (0x3FU)
#define CCM_POST_ROOT_CLR_POST_PODF_SHIFT (0U)
/*! POST_PODF
 *  0b000000..Divide by 1
 *  0b000001..Divide by 2
 *  0b000010..Divide by 3
 *  0b000011..Divide by 4
 *  0b000100..Divide by 5
 *  0b000101..Divide by 6
 *  0b111111..Divide by 64
 */
#define CCM_POST_ROOT_CLR_POST_PODF(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_POST_ROOT_CLR_POST_PODF_SHIFT)) & CCM_POST_ROOT_CLR_POST_PODF_MASK)
#define CCM_POST_ROOT_CLR_BUSY1_MASK  (0x80U)
#define CCM_POST_ROOT_CLR_BUSY1_SHIFT (7U)
#define CCM_POST_ROOT_CLR_BUSY1(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_POST_ROOT_CLR_BUSY1_SHIFT)) & CCM_POST_ROOT_CLR_BUSY1_MASK)
#define CCM_POST_ROOT_CLR_SELECT_MASK  (0x10000000U)
#define CCM_POST_ROOT_CLR_SELECT_SHIFT (28U)
/*! SELECT
 *  0b0..select branch A
 *  0b1..select branch B
 */
#define CCM_POST_ROOT_CLR_SELECT(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_POST_ROOT_CLR_SELECT_SHIFT)) & CCM_POST_ROOT_CLR_SELECT_MASK)
#define CCM_POST_ROOT_CLR_BUSY2_MASK  (0x80000000U)
#define CCM_POST_ROOT_CLR_BUSY2_SHIFT (31U)
#define CCM_POST_ROOT_CLR_BUSY2(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_POST_ROOT_CLR_BUSY2_SHIFT)) & CCM_POST_ROOT_CLR_BUSY2_MASK)
/*! @} */

/* The count of CCM_POST_ROOT_CLR */
#define CCM_POST_ROOT_CLR_COUNT (142U)

/*! @name POST_ROOT_TOG - Post Divider Register */
/*! @{ */
#define CCM_POST_ROOT_TOG_POST_PODF_MASK  (0x3FU)
#define CCM_POST_ROOT_TOG_POST_PODF_SHIFT (0U)
/*! POST_PODF
 *  0b000000..Divide by 1
 *  0b000001..Divide by 2
 *  0b000010..Divide by 3
 *  0b000011..Divide by 4
 *  0b000100..Divide by 5
 *  0b000101..Divide by 6
 *  0b111111..Divide by 64
 */
#define CCM_POST_ROOT_TOG_POST_PODF(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_POST_ROOT_TOG_POST_PODF_SHIFT)) & CCM_POST_ROOT_TOG_POST_PODF_MASK)
#define CCM_POST_ROOT_TOG_BUSY1_MASK  (0x80U)
#define CCM_POST_ROOT_TOG_BUSY1_SHIFT (7U)
#define CCM_POST_ROOT_TOG_BUSY1(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_POST_ROOT_TOG_BUSY1_SHIFT)) & CCM_POST_ROOT_TOG_BUSY1_MASK)
#define CCM_POST_ROOT_TOG_SELECT_MASK  (0x10000000U)
#define CCM_POST_ROOT_TOG_SELECT_SHIFT (28U)
/*! SELECT
 *  0b0..select branch A
 *  0b1..select branch B
 */
#define CCM_POST_ROOT_TOG_SELECT(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_POST_ROOT_TOG_SELECT_SHIFT)) & CCM_POST_ROOT_TOG_SELECT_MASK)
#define CCM_POST_ROOT_TOG_BUSY2_MASK  (0x80000000U)
#define CCM_POST_ROOT_TOG_BUSY2_SHIFT (31U)
#define CCM_POST_ROOT_TOG_BUSY2(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_POST_ROOT_TOG_BUSY2_SHIFT)) & CCM_POST_ROOT_TOG_BUSY2_MASK)
/*! @} */

/* The count of CCM_POST_ROOT_TOG */
#define CCM_POST_ROOT_TOG_COUNT (142U)

/*! @name PRE - Pre Divider Register */
/*! @{ */
#define CCM_PRE_PRE_PODF_B_MASK  (0x7U)
#define CCM_PRE_PRE_PODF_B_SHIFT (0U)
/*! PRE_PODF_B
 *  0b000..Divide by 1
 *  0b001..Divide by 2
 *  0b010..Divide by 3
 *  0b011..Divide by 4
 *  0b100..Divide by 5
 *  0b101..Divide by 6
 *  0b110..Divide by 7
 *  0b111..Divide by 8
 */
#define CCM_PRE_PRE_PODF_B(x) (((uint32_t)(((uint32_t)(x)) << CCM_PRE_PRE_PODF_B_SHIFT)) & CCM_PRE_PRE_PODF_B_MASK)
#define CCM_PRE_BUSY0_MASK    (0x8U)
#define CCM_PRE_BUSY0_SHIFT   (3U)
#define CCM_PRE_BUSY0(x)      (((uint32_t)(((uint32_t)(x)) << CCM_PRE_BUSY0_SHIFT)) & CCM_PRE_BUSY0_MASK)
#define CCM_PRE_MUX_B_MASK    (0x700U)
#define CCM_PRE_MUX_B_SHIFT   (8U)
#define CCM_PRE_MUX_B(x)      (((uint32_t)(((uint32_t)(x)) << CCM_PRE_MUX_B_SHIFT)) & CCM_PRE_MUX_B_MASK)
#define CCM_PRE_EN_B_MASK     (0x1000U)
#define CCM_PRE_EN_B_SHIFT    (12U)
/*! EN_B
 *  0b0..Clock shutdown
 *  0b1..Clock ON
 */
#define CCM_PRE_EN_B(x)          (((uint32_t)(((uint32_t)(x)) << CCM_PRE_EN_B_SHIFT)) & CCM_PRE_EN_B_MASK)
#define CCM_PRE_BUSY1_MASK       (0x8000U)
#define CCM_PRE_BUSY1_SHIFT      (15U)
#define CCM_PRE_BUSY1(x)         (((uint32_t)(((uint32_t)(x)) << CCM_PRE_BUSY1_SHIFT)) & CCM_PRE_BUSY1_MASK)
#define CCM_PRE_PRE_PODF_A_MASK  (0x70000U)
#define CCM_PRE_PRE_PODF_A_SHIFT (16U)
/*! PRE_PODF_A
 *  0b000..Divide by 1
 *  0b001..Divide by 2
 *  0b010..Divide by 3
 *  0b011..Divide by 4
 *  0b100..Divide by 5
 *  0b101..Divide by 6
 *  0b110..Divide by 7
 *  0b111..Divide by 8
 */
#define CCM_PRE_PRE_PODF_A(x) (((uint32_t)(((uint32_t)(x)) << CCM_PRE_PRE_PODF_A_SHIFT)) & CCM_PRE_PRE_PODF_A_MASK)
#define CCM_PRE_BUSY3_MASK    (0x80000U)
#define CCM_PRE_BUSY3_SHIFT   (19U)
#define CCM_PRE_BUSY3(x)      (((uint32_t)(((uint32_t)(x)) << CCM_PRE_BUSY3_SHIFT)) & CCM_PRE_BUSY3_MASK)
#define CCM_PRE_MUX_A_MASK    (0x7000000U)
#define CCM_PRE_MUX_A_SHIFT   (24U)
#define CCM_PRE_MUX_A(x)      (((uint32_t)(((uint32_t)(x)) << CCM_PRE_MUX_A_SHIFT)) & CCM_PRE_MUX_A_MASK)
#define CCM_PRE_EN_A_MASK     (0x10000000U)
#define CCM_PRE_EN_A_SHIFT    (28U)
/*! EN_A
 *  0b0..Clock shutdown
 *  0b1..clock ON
 */
#define CCM_PRE_EN_A(x)     (((uint32_t)(((uint32_t)(x)) << CCM_PRE_EN_A_SHIFT)) & CCM_PRE_EN_A_MASK)
#define CCM_PRE_BUSY4_MASK  (0x80000000U)
#define CCM_PRE_BUSY4_SHIFT (31U)
#define CCM_PRE_BUSY4(x)    (((uint32_t)(((uint32_t)(x)) << CCM_PRE_BUSY4_SHIFT)) & CCM_PRE_BUSY4_MASK)
/*! @} */

/* The count of CCM_PRE */
#define CCM_PRE_COUNT (142U)

/*! @name PRE_ROOT_SET - Pre Divider Register */
/*! @{ */
#define CCM_PRE_ROOT_SET_PRE_PODF_B_MASK  (0x7U)
#define CCM_PRE_ROOT_SET_PRE_PODF_B_SHIFT (0U)
/*! PRE_PODF_B
 *  0b000..Divide by 1
 *  0b001..Divide by 2
 *  0b010..Divide by 3
 *  0b011..Divide by 4
 *  0b100..Divide by 5
 *  0b101..Divide by 6
 *  0b110..Divide by 7
 *  0b111..Divide by 8
 */
#define CCM_PRE_ROOT_SET_PRE_PODF_B(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PRE_ROOT_SET_PRE_PODF_B_SHIFT)) & CCM_PRE_ROOT_SET_PRE_PODF_B_MASK)
#define CCM_PRE_ROOT_SET_BUSY0_MASK  (0x8U)
#define CCM_PRE_ROOT_SET_BUSY0_SHIFT (3U)
#define CCM_PRE_ROOT_SET_BUSY0(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PRE_ROOT_SET_BUSY0_SHIFT)) & CCM_PRE_ROOT_SET_BUSY0_MASK)
#define CCM_PRE_ROOT_SET_MUX_B_MASK  (0x700U)
#define CCM_PRE_ROOT_SET_MUX_B_SHIFT (8U)
#define CCM_PRE_ROOT_SET_MUX_B(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PRE_ROOT_SET_MUX_B_SHIFT)) & CCM_PRE_ROOT_SET_MUX_B_MASK)
#define CCM_PRE_ROOT_SET_EN_B_MASK  (0x1000U)
#define CCM_PRE_ROOT_SET_EN_B_SHIFT (12U)
/*! EN_B
 *  0b0..Clock shutdown
 *  0b1..Clock ON
 */
#define CCM_PRE_ROOT_SET_EN_B(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PRE_ROOT_SET_EN_B_SHIFT)) & CCM_PRE_ROOT_SET_EN_B_MASK)
#define CCM_PRE_ROOT_SET_BUSY1_MASK  (0x8000U)
#define CCM_PRE_ROOT_SET_BUSY1_SHIFT (15U)
#define CCM_PRE_ROOT_SET_BUSY1(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PRE_ROOT_SET_BUSY1_SHIFT)) & CCM_PRE_ROOT_SET_BUSY1_MASK)
#define CCM_PRE_ROOT_SET_PRE_PODF_A_MASK  (0x70000U)
#define CCM_PRE_ROOT_SET_PRE_PODF_A_SHIFT (16U)
/*! PRE_PODF_A
 *  0b000..Divide by 1
 *  0b001..Divide by 2
 *  0b010..Divide by 3
 *  0b011..Divide by 4
 *  0b100..Divide by 5
 *  0b101..Divide by 6
 *  0b110..Divide by 7
 *  0b111..Divide by 8
 */
#define CCM_PRE_ROOT_SET_PRE_PODF_A(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PRE_ROOT_SET_PRE_PODF_A_SHIFT)) & CCM_PRE_ROOT_SET_PRE_PODF_A_MASK)
#define CCM_PRE_ROOT_SET_BUSY3_MASK  (0x80000U)
#define CCM_PRE_ROOT_SET_BUSY3_SHIFT (19U)
#define CCM_PRE_ROOT_SET_BUSY3(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PRE_ROOT_SET_BUSY3_SHIFT)) & CCM_PRE_ROOT_SET_BUSY3_MASK)
#define CCM_PRE_ROOT_SET_MUX_A_MASK  (0x7000000U)
#define CCM_PRE_ROOT_SET_MUX_A_SHIFT (24U)
#define CCM_PRE_ROOT_SET_MUX_A(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PRE_ROOT_SET_MUX_A_SHIFT)) & CCM_PRE_ROOT_SET_MUX_A_MASK)
#define CCM_PRE_ROOT_SET_EN_A_MASK  (0x10000000U)
#define CCM_PRE_ROOT_SET_EN_A_SHIFT (28U)
/*! EN_A
 *  0b0..Clock shutdown
 *  0b1..clock ON
 */
#define CCM_PRE_ROOT_SET_EN_A(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PRE_ROOT_SET_EN_A_SHIFT)) & CCM_PRE_ROOT_SET_EN_A_MASK)
#define CCM_PRE_ROOT_SET_BUSY4_MASK  (0x80000000U)
#define CCM_PRE_ROOT_SET_BUSY4_SHIFT (31U)
#define CCM_PRE_ROOT_SET_BUSY4(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PRE_ROOT_SET_BUSY4_SHIFT)) & CCM_PRE_ROOT_SET_BUSY4_MASK)
/*! @} */

/* The count of CCM_PRE_ROOT_SET */
#define CCM_PRE_ROOT_SET_COUNT (142U)

/*! @name PRE_ROOT_CLR - Pre Divider Register */
/*! @{ */
#define CCM_PRE_ROOT_CLR_PRE_PODF_B_MASK  (0x7U)
#define CCM_PRE_ROOT_CLR_PRE_PODF_B_SHIFT (0U)
/*! PRE_PODF_B
 *  0b000..Divide by 1
 *  0b001..Divide by 2
 *  0b010..Divide by 3
 *  0b011..Divide by 4
 *  0b100..Divide by 5
 *  0b101..Divide by 6
 *  0b110..Divide by 7
 *  0b111..Divide by 8
 */
#define CCM_PRE_ROOT_CLR_PRE_PODF_B(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PRE_ROOT_CLR_PRE_PODF_B_SHIFT)) & CCM_PRE_ROOT_CLR_PRE_PODF_B_MASK)
#define CCM_PRE_ROOT_CLR_BUSY0_MASK  (0x8U)
#define CCM_PRE_ROOT_CLR_BUSY0_SHIFT (3U)
#define CCM_PRE_ROOT_CLR_BUSY0(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PRE_ROOT_CLR_BUSY0_SHIFT)) & CCM_PRE_ROOT_CLR_BUSY0_MASK)
#define CCM_PRE_ROOT_CLR_MUX_B_MASK  (0x700U)
#define CCM_PRE_ROOT_CLR_MUX_B_SHIFT (8U)
#define CCM_PRE_ROOT_CLR_MUX_B(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PRE_ROOT_CLR_MUX_B_SHIFT)) & CCM_PRE_ROOT_CLR_MUX_B_MASK)
#define CCM_PRE_ROOT_CLR_EN_B_MASK  (0x1000U)
#define CCM_PRE_ROOT_CLR_EN_B_SHIFT (12U)
/*! EN_B
 *  0b0..Clock shutdown
 *  0b1..Clock ON
 */
#define CCM_PRE_ROOT_CLR_EN_B(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PRE_ROOT_CLR_EN_B_SHIFT)) & CCM_PRE_ROOT_CLR_EN_B_MASK)
#define CCM_PRE_ROOT_CLR_BUSY1_MASK  (0x8000U)
#define CCM_PRE_ROOT_CLR_BUSY1_SHIFT (15U)
#define CCM_PRE_ROOT_CLR_BUSY1(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PRE_ROOT_CLR_BUSY1_SHIFT)) & CCM_PRE_ROOT_CLR_BUSY1_MASK)
#define CCM_PRE_ROOT_CLR_PRE_PODF_A_MASK  (0x70000U)
#define CCM_PRE_ROOT_CLR_PRE_PODF_A_SHIFT (16U)
/*! PRE_PODF_A
 *  0b000..Divide by 1
 *  0b001..Divide by 2
 *  0b010..Divide by 3
 *  0b011..Divide by 4
 *  0b100..Divide by 5
 *  0b101..Divide by 6
 *  0b110..Divide by 7
 *  0b111..Divide by 8
 */
#define CCM_PRE_ROOT_CLR_PRE_PODF_A(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PRE_ROOT_CLR_PRE_PODF_A_SHIFT)) & CCM_PRE_ROOT_CLR_PRE_PODF_A_MASK)
#define CCM_PRE_ROOT_CLR_BUSY3_MASK  (0x80000U)
#define CCM_PRE_ROOT_CLR_BUSY3_SHIFT (19U)
#define CCM_PRE_ROOT_CLR_BUSY3(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PRE_ROOT_CLR_BUSY3_SHIFT)) & CCM_PRE_ROOT_CLR_BUSY3_MASK)
#define CCM_PRE_ROOT_CLR_MUX_A_MASK  (0x7000000U)
#define CCM_PRE_ROOT_CLR_MUX_A_SHIFT (24U)
#define CCM_PRE_ROOT_CLR_MUX_A(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PRE_ROOT_CLR_MUX_A_SHIFT)) & CCM_PRE_ROOT_CLR_MUX_A_MASK)
#define CCM_PRE_ROOT_CLR_EN_A_MASK  (0x10000000U)
#define CCM_PRE_ROOT_CLR_EN_A_SHIFT (28U)
/*! EN_A
 *  0b0..Clock shutdown
 *  0b1..clock ON
 */
#define CCM_PRE_ROOT_CLR_EN_A(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PRE_ROOT_CLR_EN_A_SHIFT)) & CCM_PRE_ROOT_CLR_EN_A_MASK)
#define CCM_PRE_ROOT_CLR_BUSY4_MASK  (0x80000000U)
#define CCM_PRE_ROOT_CLR_BUSY4_SHIFT (31U)
#define CCM_PRE_ROOT_CLR_BUSY4(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PRE_ROOT_CLR_BUSY4_SHIFT)) & CCM_PRE_ROOT_CLR_BUSY4_MASK)
/*! @} */

/* The count of CCM_PRE_ROOT_CLR */
#define CCM_PRE_ROOT_CLR_COUNT (142U)

/*! @name PRE_ROOT_TOG - Pre Divider Register */
/*! @{ */
#define CCM_PRE_ROOT_TOG_PRE_PODF_B_MASK  (0x7U)
#define CCM_PRE_ROOT_TOG_PRE_PODF_B_SHIFT (0U)
/*! PRE_PODF_B
 *  0b000..Divide by 1
 *  0b001..Divide by 2
 *  0b010..Divide by 3
 *  0b011..Divide by 4
 *  0b100..Divide by 5
 *  0b101..Divide by 6
 *  0b110..Divide by 7
 *  0b111..Divide by 8
 */
#define CCM_PRE_ROOT_TOG_PRE_PODF_B(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PRE_ROOT_TOG_PRE_PODF_B_SHIFT)) & CCM_PRE_ROOT_TOG_PRE_PODF_B_MASK)
#define CCM_PRE_ROOT_TOG_BUSY0_MASK  (0x8U)
#define CCM_PRE_ROOT_TOG_BUSY0_SHIFT (3U)
#define CCM_PRE_ROOT_TOG_BUSY0(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PRE_ROOT_TOG_BUSY0_SHIFT)) & CCM_PRE_ROOT_TOG_BUSY0_MASK)
#define CCM_PRE_ROOT_TOG_MUX_B_MASK  (0x700U)
#define CCM_PRE_ROOT_TOG_MUX_B_SHIFT (8U)
#define CCM_PRE_ROOT_TOG_MUX_B(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PRE_ROOT_TOG_MUX_B_SHIFT)) & CCM_PRE_ROOT_TOG_MUX_B_MASK)
#define CCM_PRE_ROOT_TOG_EN_B_MASK  (0x1000U)
#define CCM_PRE_ROOT_TOG_EN_B_SHIFT (12U)
/*! EN_B
 *  0b0..Clock shutdown
 *  0b1..Clock ON
 */
#define CCM_PRE_ROOT_TOG_EN_B(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PRE_ROOT_TOG_EN_B_SHIFT)) & CCM_PRE_ROOT_TOG_EN_B_MASK)
#define CCM_PRE_ROOT_TOG_BUSY1_MASK  (0x8000U)
#define CCM_PRE_ROOT_TOG_BUSY1_SHIFT (15U)
#define CCM_PRE_ROOT_TOG_BUSY1(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PRE_ROOT_TOG_BUSY1_SHIFT)) & CCM_PRE_ROOT_TOG_BUSY1_MASK)
#define CCM_PRE_ROOT_TOG_PRE_PODF_A_MASK  (0x70000U)
#define CCM_PRE_ROOT_TOG_PRE_PODF_A_SHIFT (16U)
/*! PRE_PODF_A
 *  0b000..Divide by 1
 *  0b001..Divide by 2
 *  0b010..Divide by 3
 *  0b011..Divide by 4
 *  0b100..Divide by 5
 *  0b101..Divide by 6
 *  0b110..Divide by 7
 *  0b111..Divide by 8
 */
#define CCM_PRE_ROOT_TOG_PRE_PODF_A(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PRE_ROOT_TOG_PRE_PODF_A_SHIFT)) & CCM_PRE_ROOT_TOG_PRE_PODF_A_MASK)
#define CCM_PRE_ROOT_TOG_BUSY3_MASK  (0x80000U)
#define CCM_PRE_ROOT_TOG_BUSY3_SHIFT (19U)
#define CCM_PRE_ROOT_TOG_BUSY3(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PRE_ROOT_TOG_BUSY3_SHIFT)) & CCM_PRE_ROOT_TOG_BUSY3_MASK)
#define CCM_PRE_ROOT_TOG_MUX_A_MASK  (0x7000000U)
#define CCM_PRE_ROOT_TOG_MUX_A_SHIFT (24U)
#define CCM_PRE_ROOT_TOG_MUX_A(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PRE_ROOT_TOG_MUX_A_SHIFT)) & CCM_PRE_ROOT_TOG_MUX_A_MASK)
#define CCM_PRE_ROOT_TOG_EN_A_MASK  (0x10000000U)
#define CCM_PRE_ROOT_TOG_EN_A_SHIFT (28U)
/*! EN_A
 *  0b0..Clock shutdown
 *  0b1..clock ON
 */
#define CCM_PRE_ROOT_TOG_EN_A(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PRE_ROOT_TOG_EN_A_SHIFT)) & CCM_PRE_ROOT_TOG_EN_A_MASK)
#define CCM_PRE_ROOT_TOG_BUSY4_MASK  (0x80000000U)
#define CCM_PRE_ROOT_TOG_BUSY4_SHIFT (31U)
#define CCM_PRE_ROOT_TOG_BUSY4(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_PRE_ROOT_TOG_BUSY4_SHIFT)) & CCM_PRE_ROOT_TOG_BUSY4_MASK)
/*! @} */

/* The count of CCM_PRE_ROOT_TOG */
#define CCM_PRE_ROOT_TOG_COUNT (142U)

/*! @name ACCESS_CTRL - Access Control Register */
/*! @{ */
#define CCM_ACCESS_CTRL_DOMAIN0_INFO_MASK  (0xFU)
#define CCM_ACCESS_CTRL_DOMAIN0_INFO_SHIFT (0U)
#define CCM_ACCESS_CTRL_DOMAIN0_INFO(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_DOMAIN0_INFO_SHIFT)) & CCM_ACCESS_CTRL_DOMAIN0_INFO_MASK)
#define CCM_ACCESS_CTRL_DOMAIN1_INFO_MASK  (0xF0U)
#define CCM_ACCESS_CTRL_DOMAIN1_INFO_SHIFT (4U)
#define CCM_ACCESS_CTRL_DOMAIN1_INFO(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_DOMAIN1_INFO_SHIFT)) & CCM_ACCESS_CTRL_DOMAIN1_INFO_MASK)
#define CCM_ACCESS_CTRL_DOMAIN2_INFO_MASK  (0xF00U)
#define CCM_ACCESS_CTRL_DOMAIN2_INFO_SHIFT (8U)
#define CCM_ACCESS_CTRL_DOMAIN2_INFO(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_DOMAIN2_INFO_SHIFT)) & CCM_ACCESS_CTRL_DOMAIN2_INFO_MASK)
#define CCM_ACCESS_CTRL_DOMAIN3_INFO_MASK  (0xF000U)
#define CCM_ACCESS_CTRL_DOMAIN3_INFO_SHIFT (12U)
#define CCM_ACCESS_CTRL_DOMAIN3_INFO(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_DOMAIN3_INFO_SHIFT)) & CCM_ACCESS_CTRL_DOMAIN3_INFO_MASK)
#define CCM_ACCESS_CTRL_OWNER_ID_MASK  (0x30000U)
#define CCM_ACCESS_CTRL_OWNER_ID_SHIFT (16U)
/*! OWNER_ID
 *  0b00..domaino
 *  0b01..domain1
 *  0b10..domain2
 *  0b11..domain3
 */
#define CCM_ACCESS_CTRL_OWNER_ID(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_OWNER_ID_SHIFT)) & CCM_ACCESS_CTRL_OWNER_ID_MASK)
#define CCM_ACCESS_CTRL_MUTEX_MASK  (0x100000U)
#define CCM_ACCESS_CTRL_MUTEX_SHIFT (20U)
/*! MUTEX
 *  0b0..Semaphore is free to take
 *  0b1..Semaphore is taken
 */
#define CCM_ACCESS_CTRL_MUTEX(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_MUTEX_SHIFT)) & CCM_ACCESS_CTRL_MUTEX_MASK)
#define CCM_ACCESS_CTRL_DOMAIN0_WHITELIST_MASK  (0x1000000U)
#define CCM_ACCESS_CTRL_DOMAIN0_WHITELIST_SHIFT (24U)
/*! DOMAIN0_WHITELIST
 *  0b0..Domain cannot change the setting
 *  0b1..Domain can change the setting
 */
#define CCM_ACCESS_CTRL_DOMAIN0_WHITELIST(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_DOMAIN0_WHITELIST_SHIFT)) & CCM_ACCESS_CTRL_DOMAIN0_WHITELIST_MASK)
#define CCM_ACCESS_CTRL_DOMAIN1_WHITELIST_MASK  (0x2000000U)
#define CCM_ACCESS_CTRL_DOMAIN1_WHITELIST_SHIFT (25U)
/*! DOMAIN1_WHITELIST
 *  0b0..Domain cannot change the setting
 *  0b1..Domain can change the setting
 */
#define CCM_ACCESS_CTRL_DOMAIN1_WHITELIST(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_DOMAIN1_WHITELIST_SHIFT)) & CCM_ACCESS_CTRL_DOMAIN1_WHITELIST_MASK)
#define CCM_ACCESS_CTRL_DOMAIN2_WHITELIST_MASK  (0x4000000U)
#define CCM_ACCESS_CTRL_DOMAIN2_WHITELIST_SHIFT (26U)
/*! DOMAIN2_WHITELIST
 *  0b0..Domain cannot change the setting
 *  0b1..Domain can change the setting
 */
#define CCM_ACCESS_CTRL_DOMAIN2_WHITELIST(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_DOMAIN2_WHITELIST_SHIFT)) & CCM_ACCESS_CTRL_DOMAIN2_WHITELIST_MASK)
#define CCM_ACCESS_CTRL_DOMAIN3_WHITELIST_MASK  (0x8000000U)
#define CCM_ACCESS_CTRL_DOMAIN3_WHITELIST_SHIFT (27U)
/*! DOMAIN3_WHITELIST
 *  0b0..Domain cannot change the setting
 *  0b1..Domain can change the setting
 */
#define CCM_ACCESS_CTRL_DOMAIN3_WHITELIST(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_DOMAIN3_WHITELIST_SHIFT)) & CCM_ACCESS_CTRL_DOMAIN3_WHITELIST_MASK)
#define CCM_ACCESS_CTRL_SEMA_EN_MASK  (0x10000000U)
#define CCM_ACCESS_CTRL_SEMA_EN_SHIFT (28U)
/*! SEMA_EN
 *  0b0..Disable
 *  0b1..Enable
 */
#define CCM_ACCESS_CTRL_SEMA_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_SEMA_EN_SHIFT)) & CCM_ACCESS_CTRL_SEMA_EN_MASK)
#define CCM_ACCESS_CTRL_LOCK_MASK  (0x80000000U)
#define CCM_ACCESS_CTRL_LOCK_SHIFT (31U)
/*! LOCK
 *  0b0..Access control inactive
 *  0b1..Access control active
 */
#define CCM_ACCESS_CTRL_LOCK(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_LOCK_SHIFT)) & CCM_ACCESS_CTRL_LOCK_MASK)
/*! @} */

/* The count of CCM_ACCESS_CTRL */
#define CCM_ACCESS_CTRL_COUNT (142U)

/*! @name ACCESS_CTRL_ROOT_SET - Access Control Register */
/*! @{ */
#define CCM_ACCESS_CTRL_ROOT_SET_DOMAIN0_INFO_MASK  (0xFU)
#define CCM_ACCESS_CTRL_ROOT_SET_DOMAIN0_INFO_SHIFT (0U)
#define CCM_ACCESS_CTRL_ROOT_SET_DOMAIN0_INFO(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_SET_DOMAIN0_INFO_SHIFT)) & \
     CCM_ACCESS_CTRL_ROOT_SET_DOMAIN0_INFO_MASK)
#define CCM_ACCESS_CTRL_ROOT_SET_DOMAIN1_INFO_MASK  (0xF0U)
#define CCM_ACCESS_CTRL_ROOT_SET_DOMAIN1_INFO_SHIFT (4U)
#define CCM_ACCESS_CTRL_ROOT_SET_DOMAIN1_INFO(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_SET_DOMAIN1_INFO_SHIFT)) & \
     CCM_ACCESS_CTRL_ROOT_SET_DOMAIN1_INFO_MASK)
#define CCM_ACCESS_CTRL_ROOT_SET_DOMAIN2_INFO_MASK  (0xF00U)
#define CCM_ACCESS_CTRL_ROOT_SET_DOMAIN2_INFO_SHIFT (8U)
#define CCM_ACCESS_CTRL_ROOT_SET_DOMAIN2_INFO(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_SET_DOMAIN2_INFO_SHIFT)) & \
     CCM_ACCESS_CTRL_ROOT_SET_DOMAIN2_INFO_MASK)
#define CCM_ACCESS_CTRL_ROOT_SET_DOMAIN3_INFO_MASK  (0xF000U)
#define CCM_ACCESS_CTRL_ROOT_SET_DOMAIN3_INFO_SHIFT (12U)
#define CCM_ACCESS_CTRL_ROOT_SET_DOMAIN3_INFO(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_SET_DOMAIN3_INFO_SHIFT)) & \
     CCM_ACCESS_CTRL_ROOT_SET_DOMAIN3_INFO_MASK)
#define CCM_ACCESS_CTRL_ROOT_SET_OWNER_ID_MASK  (0x30000U)
#define CCM_ACCESS_CTRL_ROOT_SET_OWNER_ID_SHIFT (16U)
/*! OWNER_ID
 *  0b00..domaino
 *  0b01..domain1
 *  0b10..domain2
 *  0b11..domain3
 */
#define CCM_ACCESS_CTRL_ROOT_SET_OWNER_ID(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_SET_OWNER_ID_SHIFT)) & CCM_ACCESS_CTRL_ROOT_SET_OWNER_ID_MASK)
#define CCM_ACCESS_CTRL_ROOT_SET_MUTEX_MASK  (0x100000U)
#define CCM_ACCESS_CTRL_ROOT_SET_MUTEX_SHIFT (20U)
/*! MUTEX
 *  0b0..Semaphore is free to take
 *  0b1..Semaphore is taken
 */
#define CCM_ACCESS_CTRL_ROOT_SET_MUTEX(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_SET_MUTEX_SHIFT)) & CCM_ACCESS_CTRL_ROOT_SET_MUTEX_MASK)
#define CCM_ACCESS_CTRL_ROOT_SET_DOMAIN0_WHITELIST_MASK  (0x1000000U)
#define CCM_ACCESS_CTRL_ROOT_SET_DOMAIN0_WHITELIST_SHIFT (24U)
/*! DOMAIN0_WHITELIST
 *  0b0..Domain cannot change the setting
 *  0b1..Domain can change the setting
 */
#define CCM_ACCESS_CTRL_ROOT_SET_DOMAIN0_WHITELIST(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_SET_DOMAIN0_WHITELIST_SHIFT)) & \
     CCM_ACCESS_CTRL_ROOT_SET_DOMAIN0_WHITELIST_MASK)
#define CCM_ACCESS_CTRL_ROOT_SET_DOMAIN1_WHITELIST_MASK  (0x2000000U)
#define CCM_ACCESS_CTRL_ROOT_SET_DOMAIN1_WHITELIST_SHIFT (25U)
/*! DOMAIN1_WHITELIST
 *  0b0..Domain cannot change the setting
 *  0b1..Domain can change the setting
 */
#define CCM_ACCESS_CTRL_ROOT_SET_DOMAIN1_WHITELIST(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_SET_DOMAIN1_WHITELIST_SHIFT)) & \
     CCM_ACCESS_CTRL_ROOT_SET_DOMAIN1_WHITELIST_MASK)
#define CCM_ACCESS_CTRL_ROOT_SET_DOMAIN2_WHITELIST_MASK  (0x4000000U)
#define CCM_ACCESS_CTRL_ROOT_SET_DOMAIN2_WHITELIST_SHIFT (26U)
/*! DOMAIN2_WHITELIST
 *  0b0..Domain cannot change the setting
 *  0b1..Domain can change the setting
 */
#define CCM_ACCESS_CTRL_ROOT_SET_DOMAIN2_WHITELIST(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_SET_DOMAIN2_WHITELIST_SHIFT)) & \
     CCM_ACCESS_CTRL_ROOT_SET_DOMAIN2_WHITELIST_MASK)
#define CCM_ACCESS_CTRL_ROOT_SET_DOMAIN3_WHITELIST_MASK  (0x8000000U)
#define CCM_ACCESS_CTRL_ROOT_SET_DOMAIN3_WHITELIST_SHIFT (27U)
/*! DOMAIN3_WHITELIST
 *  0b0..Domain cannot change the setting
 *  0b1..Domain can change the setting
 */
#define CCM_ACCESS_CTRL_ROOT_SET_DOMAIN3_WHITELIST(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_SET_DOMAIN3_WHITELIST_SHIFT)) & \
     CCM_ACCESS_CTRL_ROOT_SET_DOMAIN3_WHITELIST_MASK)
#define CCM_ACCESS_CTRL_ROOT_SET_SEMA_EN_MASK  (0x10000000U)
#define CCM_ACCESS_CTRL_ROOT_SET_SEMA_EN_SHIFT (28U)
/*! SEMA_EN
 *  0b0..Disable
 *  0b1..Enable
 */
#define CCM_ACCESS_CTRL_ROOT_SET_SEMA_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_SET_SEMA_EN_SHIFT)) & CCM_ACCESS_CTRL_ROOT_SET_SEMA_EN_MASK)
#define CCM_ACCESS_CTRL_ROOT_SET_LOCK_MASK  (0x80000000U)
#define CCM_ACCESS_CTRL_ROOT_SET_LOCK_SHIFT (31U)
/*! LOCK
 *  0b0..Access control inactive
 *  0b1..Access control active
 */
#define CCM_ACCESS_CTRL_ROOT_SET_LOCK(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_SET_LOCK_SHIFT)) & CCM_ACCESS_CTRL_ROOT_SET_LOCK_MASK)
/*! @} */

/* The count of CCM_ACCESS_CTRL_ROOT_SET */
#define CCM_ACCESS_CTRL_ROOT_SET_COUNT (142U)

/*! @name ACCESS_CTRL_ROOT_CLR - Access Control Register */
/*! @{ */
#define CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN0_INFO_MASK  (0xFU)
#define CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN0_INFO_SHIFT (0U)
#define CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN0_INFO(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN0_INFO_SHIFT)) & \
     CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN0_INFO_MASK)
#define CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN1_INFO_MASK  (0xF0U)
#define CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN1_INFO_SHIFT (4U)
#define CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN1_INFO(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN1_INFO_SHIFT)) & \
     CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN1_INFO_MASK)
#define CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN2_INFO_MASK  (0xF00U)
#define CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN2_INFO_SHIFT (8U)
#define CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN2_INFO(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN2_INFO_SHIFT)) & \
     CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN2_INFO_MASK)
#define CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN3_INFO_MASK  (0xF000U)
#define CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN3_INFO_SHIFT (12U)
#define CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN3_INFO(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN3_INFO_SHIFT)) & \
     CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN3_INFO_MASK)
#define CCM_ACCESS_CTRL_ROOT_CLR_OWNER_ID_MASK  (0x30000U)
#define CCM_ACCESS_CTRL_ROOT_CLR_OWNER_ID_SHIFT (16U)
/*! OWNER_ID
 *  0b00..domaino
 *  0b01..domain1
 *  0b10..domain2
 *  0b11..domain3
 */
#define CCM_ACCESS_CTRL_ROOT_CLR_OWNER_ID(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_CLR_OWNER_ID_SHIFT)) & CCM_ACCESS_CTRL_ROOT_CLR_OWNER_ID_MASK)
#define CCM_ACCESS_CTRL_ROOT_CLR_MUTEX_MASK  (0x100000U)
#define CCM_ACCESS_CTRL_ROOT_CLR_MUTEX_SHIFT (20U)
/*! MUTEX
 *  0b0..Semaphore is free to take
 *  0b1..Semaphore is taken
 */
#define CCM_ACCESS_CTRL_ROOT_CLR_MUTEX(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_CLR_MUTEX_SHIFT)) & CCM_ACCESS_CTRL_ROOT_CLR_MUTEX_MASK)
#define CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN0_WHITELIST_MASK  (0x1000000U)
#define CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN0_WHITELIST_SHIFT (24U)
/*! DOMAIN0_WHITELIST
 *  0b0..Domain cannot change the setting
 *  0b1..Domain can change the setting
 */
#define CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN0_WHITELIST(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN0_WHITELIST_SHIFT)) & \
     CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN0_WHITELIST_MASK)
#define CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN1_WHITELIST_MASK  (0x2000000U)
#define CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN1_WHITELIST_SHIFT (25U)
/*! DOMAIN1_WHITELIST
 *  0b0..Domain cannot change the setting
 *  0b1..Domain can change the setting
 */
#define CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN1_WHITELIST(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN1_WHITELIST_SHIFT)) & \
     CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN1_WHITELIST_MASK)
#define CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN2_WHITELIST_MASK  (0x4000000U)
#define CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN2_WHITELIST_SHIFT (26U)
/*! DOMAIN2_WHITELIST
 *  0b0..Domain cannot change the setting
 *  0b1..Domain can change the setting
 */
#define CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN2_WHITELIST(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN2_WHITELIST_SHIFT)) & \
     CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN2_WHITELIST_MASK)
#define CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN3_WHITELIST_MASK  (0x8000000U)
#define CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN3_WHITELIST_SHIFT (27U)
/*! DOMAIN3_WHITELIST
 *  0b0..Domain cannot change the setting
 *  0b1..Domain can change the setting
 */
#define CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN3_WHITELIST(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN3_WHITELIST_SHIFT)) & \
     CCM_ACCESS_CTRL_ROOT_CLR_DOMAIN3_WHITELIST_MASK)
#define CCM_ACCESS_CTRL_ROOT_CLR_SEMA_EN_MASK  (0x10000000U)
#define CCM_ACCESS_CTRL_ROOT_CLR_SEMA_EN_SHIFT (28U)
/*! SEMA_EN
 *  0b0..Disable
 *  0b1..Enable
 */
#define CCM_ACCESS_CTRL_ROOT_CLR_SEMA_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_CLR_SEMA_EN_SHIFT)) & CCM_ACCESS_CTRL_ROOT_CLR_SEMA_EN_MASK)
#define CCM_ACCESS_CTRL_ROOT_CLR_LOCK_MASK  (0x80000000U)
#define CCM_ACCESS_CTRL_ROOT_CLR_LOCK_SHIFT (31U)
/*! LOCK
 *  0b0..Access control inactive
 *  0b1..Access control active
 */
#define CCM_ACCESS_CTRL_ROOT_CLR_LOCK(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_CLR_LOCK_SHIFT)) & CCM_ACCESS_CTRL_ROOT_CLR_LOCK_MASK)
/*! @} */

/* The count of CCM_ACCESS_CTRL_ROOT_CLR */
#define CCM_ACCESS_CTRL_ROOT_CLR_COUNT (142U)

/*! @name ACCESS_CTRL_ROOT_TOG - Access Control Register */
/*! @{ */
#define CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN0_INFO_MASK  (0xFU)
#define CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN0_INFO_SHIFT (0U)
#define CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN0_INFO(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN0_INFO_SHIFT)) & \
     CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN0_INFO_MASK)
#define CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN1_INFO_MASK  (0xF0U)
#define CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN1_INFO_SHIFT (4U)
#define CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN1_INFO(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN1_INFO_SHIFT)) & \
     CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN1_INFO_MASK)
#define CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN2_INFO_MASK  (0xF00U)
#define CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN2_INFO_SHIFT (8U)
#define CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN2_INFO(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN2_INFO_SHIFT)) & \
     CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN2_INFO_MASK)
#define CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN3_INFO_MASK  (0xF000U)
#define CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN3_INFO_SHIFT (12U)
#define CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN3_INFO(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN3_INFO_SHIFT)) & \
     CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN3_INFO_MASK)
#define CCM_ACCESS_CTRL_ROOT_TOG_OWNER_ID_MASK  (0x30000U)
#define CCM_ACCESS_CTRL_ROOT_TOG_OWNER_ID_SHIFT (16U)
/*! OWNER_ID
 *  0b00..domaino
 *  0b01..domain1
 *  0b10..domain2
 *  0b11..domain3
 */
#define CCM_ACCESS_CTRL_ROOT_TOG_OWNER_ID(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_TOG_OWNER_ID_SHIFT)) & CCM_ACCESS_CTRL_ROOT_TOG_OWNER_ID_MASK)
#define CCM_ACCESS_CTRL_ROOT_TOG_MUTEX_MASK  (0x100000U)
#define CCM_ACCESS_CTRL_ROOT_TOG_MUTEX_SHIFT (20U)
/*! MUTEX
 *  0b0..Semaphore is free to take
 *  0b1..Semaphore is taken
 */
#define CCM_ACCESS_CTRL_ROOT_TOG_MUTEX(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_TOG_MUTEX_SHIFT)) & CCM_ACCESS_CTRL_ROOT_TOG_MUTEX_MASK)
#define CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN0_WHITELIST_MASK  (0x1000000U)
#define CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN0_WHITELIST_SHIFT (24U)
/*! DOMAIN0_WHITELIST
 *  0b0..Domain cannot change the setting
 *  0b1..Domain can change the setting
 */
#define CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN0_WHITELIST(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN0_WHITELIST_SHIFT)) & \
     CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN0_WHITELIST_MASK)
#define CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN1_WHITELIST_MASK  (0x2000000U)
#define CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN1_WHITELIST_SHIFT (25U)
/*! DOMAIN1_WHITELIST
 *  0b0..Domain cannot change the setting
 *  0b1..Domain can change the setting
 */
#define CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN1_WHITELIST(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN1_WHITELIST_SHIFT)) & \
     CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN1_WHITELIST_MASK)
#define CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN2_WHITELIST_MASK  (0x4000000U)
#define CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN2_WHITELIST_SHIFT (26U)
/*! DOMAIN2_WHITELIST
 *  0b0..Domain cannot change the setting
 *  0b1..Domain can change the setting
 */
#define CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN2_WHITELIST(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN2_WHITELIST_SHIFT)) & \
     CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN2_WHITELIST_MASK)
#define CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN3_WHITELIST_MASK  (0x8000000U)
#define CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN3_WHITELIST_SHIFT (27U)
/*! DOMAIN3_WHITELIST
 *  0b0..Domain cannot change the setting
 *  0b1..Domain can change the setting
 */
#define CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN3_WHITELIST(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN3_WHITELIST_SHIFT)) & \
     CCM_ACCESS_CTRL_ROOT_TOG_DOMAIN3_WHITELIST_MASK)
#define CCM_ACCESS_CTRL_ROOT_TOG_SEMA_EN_MASK  (0x10000000U)
#define CCM_ACCESS_CTRL_ROOT_TOG_SEMA_EN_SHIFT (28U)
/*! SEMA_EN
 *  0b0..Disable
 *  0b1..Enable
 */
#define CCM_ACCESS_CTRL_ROOT_TOG_SEMA_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_TOG_SEMA_EN_SHIFT)) & CCM_ACCESS_CTRL_ROOT_TOG_SEMA_EN_MASK)
#define CCM_ACCESS_CTRL_ROOT_TOG_LOCK_MASK  (0x80000000U)
#define CCM_ACCESS_CTRL_ROOT_TOG_LOCK_SHIFT (31U)
/*! LOCK
 *  0b0..Access control inactive
 *  0b1..Access control active
 */
#define CCM_ACCESS_CTRL_ROOT_TOG_LOCK(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ACCESS_CTRL_ROOT_TOG_LOCK_SHIFT)) & CCM_ACCESS_CTRL_ROOT_TOG_LOCK_MASK)
/*! @} */

/* The count of CCM_ACCESS_CTRL_ROOT_TOG */
#define CCM_ACCESS_CTRL_ROOT_TOG_COUNT (142U)

/*!
 * @}
 */ /* end of group CCM_Register_Masks */

/* CCM - Peripheral instance base addresses */
/** Peripheral CCM base address */
#define CCM_BASE (0x30380000u)
/** Peripheral CCM base pointer */
#define CCM ((CCM_Type *)CCM_BASE)
/** Array initializer of CCM peripheral base addresses */
#define CCM_BASE_ADDRS \
    {                  \
        CCM_BASE       \
    }
/** Array initializer of CCM peripheral base pointers */
#define CCM_BASE_PTRS \
    {                 \
        CCM           \
    }
/** Interrupt vectors for the CCM peripheral type */
#define CCM_IRQS                     \
    {                                \
        CCM_IRQ1_IRQn, CCM_IRQ2_IRQn \
    }

/*!
 * @}
 */ /* end of group CCM_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- CCM_ANALOG Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CCM_ANALOG_Peripheral_Access_Layer CCM_ANALOG Peripheral Access Layer
 * @{
 */

/** CCM_ANALOG - Register Layout Typedef */
typedef struct
{
    __IO uint32_t AUDIO_PLL1_GEN_CTRL;  /**< AUDIO PLL1 General Function Control Register, offset: 0x0 */
    __IO uint32_t AUDIO_PLL1_FDIV_CTL0; /**< AUDIO PLL1 Divide and Fraction Data Control 0 Register, offset: 0x4 */
    __IO uint32_t AUDIO_PLL1_FDIV_CTL1; /**< AUDIO PLL1 Divide and Fraction Data Control 1 Register, offset: 0x8 */
    __IO uint32_t AUDIO_PLL1_SSCG_CTRL; /**< AUDIO PLL1 PLL SSCG Control Register, offset: 0xC */
    __IO uint32_t AUDIO_PLL1_MNIT_CTRL; /**< AUDIO PLL1 PLL Monitoring Control Register, offset: 0x10 */
    __IO uint32_t AUDIO_PLL2_GEN_CTRL;  /**< AUDIO PLL2 General Function Control Register, offset: 0x14 */
    __IO uint32_t AUDIO_PLL2_FDIV_CTL0; /**< AUDIO PLL2 Divide and Fraction Data Control 0 Register, offset: 0x18 */
    __IO uint32_t AUDIO_PLL2_FDIV_CTL1; /**< AUDIO PLL2 Divide and Fraction Data Control 1 Register, offset: 0x1C */
    __IO uint32_t AUDIO_PLL2_SSCG_CTRL; /**< AUDIO PLL2 PLL SSCG Control Register, offset: 0x20 */
    __IO uint32_t AUDIO_PLL2_MNIT_CTRL; /**< AUDIO PLL2 PLL Monitoring Control Register, offset: 0x24 */
    __IO uint32_t VIDEO_PLL1_GEN_CTRL;  /**< VIDEO PLL1 General Function Control Register, offset: 0x28 */
    __IO uint32_t VIDEO_PLL1_FDIV_CTL0; /**< VIDEO PLL1 Divide and Fraction Data Control 0 Register, offset: 0x2C */
    __IO uint32_t VIDEO_PLL1_FDIV_CTL1; /**< VIDEO PLL1 Divide and Fraction Data Control 1 Register, offset: 0x30 */
    __IO uint32_t VIDEO_PLL1_SSCG_CTRL; /**< VIDEO PLL1 PLL SSCG Control Register, offset: 0x34 */
    __IO uint32_t VIDEO_PLL1_MNIT_CTRL; /**< VIDEO PLL1 PLL Monitoring Control Register, offset: 0x38 */
    uint8_t RESERVED_0[20];
    __IO uint32_t DRAM_PLL_GEN_CTRL;   /**< DRAM PLL General Function Control Register, offset: 0x50 */
    __IO uint32_t DRAM_PLL_FDIV_CTL0;  /**< DRAM PLL Divide and Fraction Data Control 0 Register, offset: 0x54 */
    __IO uint32_t DRAM_PLL_FDIV_CTL1;  /**< DRAM PLL Divide and Fraction Data Control 1 Register, offset: 0x58 */
    __IO uint32_t DRAM_PLL_SSCG_CTRL;  /**< DRAM PLL PLL SSCG Control Register, offset: 0x5C */
    __IO uint32_t DRAM_PLL_MNIT_CTRL;  /**< DRAM PLL PLL Monitoring Control Register, offset: 0x60 */
    __IO uint32_t GPU_PLL_GEN_CTRL;    /**< GPU PLL General Function Control Register, offset: 0x64 */
    __IO uint32_t GPU_PLL_FDIV_CTL0;   /**< GPU PLL Divide and Fraction Data Control 0 Register, offset: 0x68 */
    __IO uint32_t GPU_PLL_LOCKD_CTRL;  /**< PLL Lock Detector Control Register, offset: 0x6C */
    __IO uint32_t GPU_PLL_MNIT_CTRL;   /**< PLL Monitoring Control Register, offset: 0x70 */
    __IO uint32_t VPU_PLL_GEN_CTRL;    /**< VPU PLL General Function Control Register, offset: 0x74 */
    __IO uint32_t VPU_PLL_FDIV_CTL0;   /**< VPU PLL Divide and Fraction Data Control 0 Register, offset: 0x78 */
    __IO uint32_t VPU_PLL_LOCKD_CTRL;  /**< PLL Lock Detector Control Register, offset: 0x7C */
    __IO uint32_t VPU_PLL_MNIT_CTRL;   /**< PLL Monitoring Control Register, offset: 0x80 */
    __IO uint32_t ARM_PLL_GEN_CTRL;    /**< ARM PLL General Function Control Register, offset: 0x84 */
    __IO uint32_t ARM_PLL_FDIV_CTL0;   /**< ARM PLL Divide and Fraction Data Control 0 Register, offset: 0x88 */
    __IO uint32_t ARM_PLL_LOCKD_CTRL;  /**< PLL Lock Detector Control Register, offset: 0x8C */
    __IO uint32_t ARM_PLL_MNIT_CTRL;   /**< PLL Monitoring Control Register, offset: 0x90 */
    __IO uint32_t SYS_PLL1_GEN_CTRL;   /**< SYS PLL1 General Function Control Register, offset: 0x94 */
    __IO uint32_t SYS_PLL1_FDIV_CTL0;  /**< SYS PLL1 Divide and Fraction Data Control 0 Register, offset: 0x98 */
    __IO uint32_t SYS_PLL1_LOCKD_CTRL; /**< PLL Lock Detector Control Register, offset: 0x9C */
    uint8_t RESERVED_1[96];
    __IO uint32_t SYS_PLL1_MNIT_CTRL;  /**< PLL Monitoring Control Register, offset: 0x100 */
    __IO uint32_t SYS_PLL2_GEN_CTRL;   /**< SYS PLL2 General Function Control Register, offset: 0x104 */
    __IO uint32_t SYS_PLL2_FDIV_CTL0;  /**< SYS PLL2 Divide and Fraction Data Control 0 Register, offset: 0x108 */
    __IO uint32_t SYS_PLL2_LOCKD_CTRL; /**< PLL Lock Detector Control Register, offset: 0x10C */
    __IO uint32_t SYS_PLL2_MNIT_CTRL;  /**< PLL Monitoring Control Register, offset: 0x110 */
    __IO uint32_t SYS_PLL3_GEN_CTRL;   /**< SYS PLL3 General Function Control Register, offset: 0x114 */
    __IO uint32_t SYS_PLL3_FDIV_CTL0;  /**< SYS PLL3 Divide and Fraction Data Control 0 Register, offset: 0x118 */
    __IO uint32_t SYS_PLL3_LOCKD_CTRL; /**< PLL Lock Detector Control Register, offset: 0x11C */
    __IO uint32_t SYS_PLL3_MNIT_CTRL;  /**< PLL Monitoring Control Register, offset: 0x120 */
    __IO uint32_t OSC_MISC_CFG;        /**< Osc Misc Configuration Register, offset: 0x124 */
    __IO uint32_t ANAMIX_PLL_MNIT_CTL; /**< PLL Clock Output for Test Enable and Select Register, offset: 0x128 */
    uint8_t RESERVED_2[1748];
    __I uint32_t DIGPROG; /**< DIGPROG Register, offset: 0x800 */
} CCM_ANALOG_Type;

/* ----------------------------------------------------------------------------
   -- CCM_ANALOG Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CCM_ANALOG_Register_Masks CCM_ANALOG Register Masks
 * @{
 */

/*! @name AUDIO_PLL1_GEN_CTRL - AUDIO PLL1 General Function Control Register */
/*! @{ */
#define CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_REF_CLK_SEL_MASK  (0x3U)
#define CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_REF_CLK_SEL_SHIFT (0U)
/*! PLL_REF_CLK_SEL
 *  0b00..24M_REF_CLK
 *  0b01..PAD_CLK
 *  0b10..Reserved
 *  0b11..Reserved
 */
#define CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_REF_CLK_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_REF_CLK_SEL_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_REF_CLK_SEL_MASK)
#define CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PAD_CLK_SEL_MASK  (0xCU)
#define CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PAD_CLK_SEL_SHIFT (2U)
/*! PAD_CLK_SEL
 *  0b00..CLKIN1 XOR CLKIN2
 *  0b01..CLKIN2
 *  0b10..CLKIN1
 *  0b11..Reserved
 */
#define CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PAD_CLK_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PAD_CLK_SEL_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PAD_CLK_SEL_MASK)
#define CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_BYPASS_MASK  (0x10U)
#define CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_BYPASS_SHIFT (4U)
#define CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_BYPASS(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_BYPASS_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_BYPASS_MASK)
#define CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_RST_OVERRIDE_MASK  (0x100U)
#define CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_RST_OVERRIDE_SHIFT (8U)
#define CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_RST_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_RST_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_RST_OVERRIDE_MASK)
#define CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_RST_MASK  (0x200U)
#define CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_RST_SHIFT (9U)
#define CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_RST(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_RST_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_RST_MASK)
#define CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_CLKE_OVERRIDE_MASK  (0x1000U)
#define CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_CLKE_OVERRIDE_SHIFT (12U)
#define CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_CLKE_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_CLKE_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_CLKE_OVERRIDE_MASK)
#define CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_CLKE_MASK  (0x2000U)
#define CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_CLKE_SHIFT (13U)
#define CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_CLKE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_CLKE_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_CLKE_MASK)
#define CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_EXT_BYPASS_MASK  (0x10000U)
#define CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_EXT_BYPASS_SHIFT (16U)
#define CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_EXT_BYPASS(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_EXT_BYPASS_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_EXT_BYPASS_MASK)
#define CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_LOCK_MASK  (0x80000000U)
#define CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_LOCK_SHIFT (31U)
#define CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_LOCK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_LOCK_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL1_GEN_CTRL_PLL_LOCK_MASK)
/*! @} */

/*! @name AUDIO_PLL1_FDIV_CTL0 - AUDIO PLL1 Divide and Fraction Data Control 0 Register */
/*! @{ */
#define CCM_ANALOG_AUDIO_PLL1_FDIV_CTL0_PLL_POST_DIV_MASK  (0x7U)
#define CCM_ANALOG_AUDIO_PLL1_FDIV_CTL0_PLL_POST_DIV_SHIFT (0U)
#define CCM_ANALOG_AUDIO_PLL1_FDIV_CTL0_PLL_POST_DIV(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL1_FDIV_CTL0_PLL_POST_DIV_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL1_FDIV_CTL0_PLL_POST_DIV_MASK)
#define CCM_ANALOG_AUDIO_PLL1_FDIV_CTL0_PLL_PRE_DIV_MASK  (0x3F0U)
#define CCM_ANALOG_AUDIO_PLL1_FDIV_CTL0_PLL_PRE_DIV_SHIFT (4U)
#define CCM_ANALOG_AUDIO_PLL1_FDIV_CTL0_PLL_PRE_DIV(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL1_FDIV_CTL0_PLL_PRE_DIV_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL1_FDIV_CTL0_PLL_PRE_DIV_MASK)
#define CCM_ANALOG_AUDIO_PLL1_FDIV_CTL0_PLL_MAIN_DIV_MASK  (0x3FF000U)
#define CCM_ANALOG_AUDIO_PLL1_FDIV_CTL0_PLL_MAIN_DIV_SHIFT (12U)
#define CCM_ANALOG_AUDIO_PLL1_FDIV_CTL0_PLL_MAIN_DIV(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL1_FDIV_CTL0_PLL_MAIN_DIV_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL1_FDIV_CTL0_PLL_MAIN_DIV_MASK)
/*! @} */

/*! @name AUDIO_PLL1_FDIV_CTL1 - AUDIO PLL1 Divide and Fraction Data Control 1 Register */
/*! @{ */
#define CCM_ANALOG_AUDIO_PLL1_FDIV_CTL1_PLL_DSM_MASK  (0xFFFFU)
#define CCM_ANALOG_AUDIO_PLL1_FDIV_CTL1_PLL_DSM_SHIFT (0U)
#define CCM_ANALOG_AUDIO_PLL1_FDIV_CTL1_PLL_DSM(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL1_FDIV_CTL1_PLL_DSM_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL1_FDIV_CTL1_PLL_DSM_MASK)
/*! @} */

/*! @name AUDIO_PLL1_SSCG_CTRL - AUDIO PLL1 PLL SSCG Control Register */
/*! @{ */
#define CCM_ANALOG_AUDIO_PLL1_SSCG_CTRL_SEL_PF_MASK  (0x3U)
#define CCM_ANALOG_AUDIO_PLL1_SSCG_CTRL_SEL_PF_SHIFT (0U)
/*! SEL_PF
 *  0b00..Down spread
 *  0b01..Up spread
 *  0b1x..Center spread
 */
#define CCM_ANALOG_AUDIO_PLL1_SSCG_CTRL_SEL_PF(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL1_SSCG_CTRL_SEL_PF_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL1_SSCG_CTRL_SEL_PF_MASK)
#define CCM_ANALOG_AUDIO_PLL1_SSCG_CTRL_PLL_MRAT_CTL_MASK  (0x3F0U)
#define CCM_ANALOG_AUDIO_PLL1_SSCG_CTRL_PLL_MRAT_CTL_SHIFT (4U)
#define CCM_ANALOG_AUDIO_PLL1_SSCG_CTRL_PLL_MRAT_CTL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL1_SSCG_CTRL_PLL_MRAT_CTL_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL1_SSCG_CTRL_PLL_MRAT_CTL_MASK)
#define CCM_ANALOG_AUDIO_PLL1_SSCG_CTRL_PLL_MFREQ_CTL_MASK  (0xFF000U)
#define CCM_ANALOG_AUDIO_PLL1_SSCG_CTRL_PLL_MFREQ_CTL_SHIFT (12U)
#define CCM_ANALOG_AUDIO_PLL1_SSCG_CTRL_PLL_MFREQ_CTL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL1_SSCG_CTRL_PLL_MFREQ_CTL_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL1_SSCG_CTRL_PLL_MFREQ_CTL_MASK)
#define CCM_ANALOG_AUDIO_PLL1_SSCG_CTRL_SSCG_EN_MASK  (0x80000000U)
#define CCM_ANALOG_AUDIO_PLL1_SSCG_CTRL_SSCG_EN_SHIFT (31U)
/*! SSCG_EN
 *  0b1..Enable Spread Spectrum Mode
 *  0b0..Disable Spread Spectrum Mode
 */
#define CCM_ANALOG_AUDIO_PLL1_SSCG_CTRL_SSCG_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL1_SSCG_CTRL_SSCG_EN_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL1_SSCG_CTRL_SSCG_EN_MASK)
/*! @} */

/*! @name AUDIO_PLL1_MNIT_CTRL - AUDIO PLL1 PLL Monitoring Control Register */
/*! @{ */
#define CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_ICP_MASK  (0x7U)
#define CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_ICP_SHIFT (0U)
#define CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_ICP(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_ICP_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_ICP_MASK)
#define CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_AFC_EN_MASK  (0x8U)
#define CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_AFC_EN_SHIFT (3U)
#define CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_AFC_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_AFC_EN_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_AFC_EN_MASK)
#define CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_EXTAFC_MASK  (0x1F0U)
#define CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_EXTAFC_SHIFT (4U)
#define CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_EXTAFC(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_EXTAFC_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_EXTAFC_MASK)
#define CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_FEED_EN_MASK  (0x4000U)
#define CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_FEED_EN_SHIFT (14U)
#define CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_FEED_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_FEED_EN_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_FEED_EN_MASK)
#define CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_FSEL_MASK  (0x8000U)
#define CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_FSEL_SHIFT (15U)
/*! FSEL
 *  0b0..FEED_OUT = FREF
 *  0b1..FEED_OUT = FEED
 */
#define CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_FSEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_FSEL_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_FSEL_MASK)
#define CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_AFCINIT_SEL_MASK  (0x20000U)
#define CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_AFCINIT_SEL_SHIFT (17U)
/*! AFCINIT_SEL
 *  0b0..nominal delay
 *  0b1..nominal delay * 2
 */
#define CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_AFCINIT_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_AFCINIT_SEL_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_AFCINIT_SEL_MASK)
#define CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_PBIAS_CTRL_EN_MASK  (0x40000U)
#define CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_PBIAS_CTRL_EN_SHIFT (18U)
#define CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_PBIAS_CTRL_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_PBIAS_CTRL_EN_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_PBIAS_CTRL_EN_MASK)
#define CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_PBIAS_CTRL_MASK  (0x80000U)
#define CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_PBIAS_CTRL_SHIFT (19U)
/*! PBIAS_CTRL
 *  0b0..0.50*VDD
 *  0b1..0.67*VDD
 */
#define CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_PBIAS_CTRL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_PBIAS_CTRL_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_PBIAS_CTRL_MASK)
#define CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_AFC_SEL_MASK  (0x100000U)
#define CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_AFC_SEL_SHIFT (20U)
#define CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_AFC_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_AFC_SEL_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL1_MNIT_CTRL_AFC_SEL_MASK)
/*! @} */

/*! @name AUDIO_PLL2_GEN_CTRL - AUDIO PLL2 General Function Control Register */
/*! @{ */
#define CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_REF_CLK_SEL_MASK  (0x3U)
#define CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_REF_CLK_SEL_SHIFT (0U)
/*! PLL_REF_CLK_SEL
 *  0b00..24M_REF_CLK
 *  0b01..PAD_CLK
 *  0b10..Reserved
 *  0b11..Reserved
 */
#define CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_REF_CLK_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_REF_CLK_SEL_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_REF_CLK_SEL_MASK)
#define CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PAD_CLK_SEL_MASK  (0xCU)
#define CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PAD_CLK_SEL_SHIFT (2U)
/*! PAD_CLK_SEL
 *  0b00..CLKIN1 XOR CLKIN2
 *  0b01..CLKIN2
 *  0b10..CLKIN1
 *  0b11..Reserved
 */
#define CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PAD_CLK_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PAD_CLK_SEL_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PAD_CLK_SEL_MASK)
#define CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_BYPASS_MASK  (0x10U)
#define CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_BYPASS_SHIFT (4U)
#define CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_BYPASS(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_BYPASS_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_BYPASS_MASK)
#define CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_RST_OVERRIDE_MASK  (0x100U)
#define CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_RST_OVERRIDE_SHIFT (8U)
#define CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_RST_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_RST_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_RST_OVERRIDE_MASK)
#define CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_RST_MASK  (0x200U)
#define CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_RST_SHIFT (9U)
#define CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_RST(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_RST_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_RST_MASK)
#define CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_CLKE_OVERRIDE_MASK  (0x1000U)
#define CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_CLKE_OVERRIDE_SHIFT (12U)
#define CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_CLKE_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_CLKE_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_CLKE_OVERRIDE_MASK)
#define CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_CLKE_MASK  (0x2000U)
#define CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_CLKE_SHIFT (13U)
#define CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_CLKE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_CLKE_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_CLKE_MASK)
#define CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_EXT_BYPASS_MASK  (0x10000U)
#define CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_EXT_BYPASS_SHIFT (16U)
#define CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_EXT_BYPASS(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_EXT_BYPASS_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_EXT_BYPASS_MASK)
#define CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_LOCK_MASK  (0x80000000U)
#define CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_LOCK_SHIFT (31U)
#define CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_LOCK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_LOCK_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL2_GEN_CTRL_PLL_LOCK_MASK)
/*! @} */

/*! @name AUDIO_PLL2_FDIV_CTL0 - AUDIO PLL2 Divide and Fraction Data Control 0 Register */
/*! @{ */
#define CCM_ANALOG_AUDIO_PLL2_FDIV_CTL0_PLL_POST_DIV_MASK  (0x7U)
#define CCM_ANALOG_AUDIO_PLL2_FDIV_CTL0_PLL_POST_DIV_SHIFT (0U)
#define CCM_ANALOG_AUDIO_PLL2_FDIV_CTL0_PLL_POST_DIV(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL2_FDIV_CTL0_PLL_POST_DIV_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL2_FDIV_CTL0_PLL_POST_DIV_MASK)
#define CCM_ANALOG_AUDIO_PLL2_FDIV_CTL0_PLL_PRE_DIV_MASK  (0x3F0U)
#define CCM_ANALOG_AUDIO_PLL2_FDIV_CTL0_PLL_PRE_DIV_SHIFT (4U)
#define CCM_ANALOG_AUDIO_PLL2_FDIV_CTL0_PLL_PRE_DIV(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL2_FDIV_CTL0_PLL_PRE_DIV_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL2_FDIV_CTL0_PLL_PRE_DIV_MASK)
#define CCM_ANALOG_AUDIO_PLL2_FDIV_CTL0_PLL_MAIN_DIV_MASK  (0x3FF000U)
#define CCM_ANALOG_AUDIO_PLL2_FDIV_CTL0_PLL_MAIN_DIV_SHIFT (12U)
#define CCM_ANALOG_AUDIO_PLL2_FDIV_CTL0_PLL_MAIN_DIV(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL2_FDIV_CTL0_PLL_MAIN_DIV_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL2_FDIV_CTL0_PLL_MAIN_DIV_MASK)
/*! @} */

/*! @name AUDIO_PLL2_FDIV_CTL1 - AUDIO PLL2 Divide and Fraction Data Control 1 Register */
/*! @{ */
#define CCM_ANALOG_AUDIO_PLL2_FDIV_CTL1_PLL_DSM_MASK  (0xFFFFU)
#define CCM_ANALOG_AUDIO_PLL2_FDIV_CTL1_PLL_DSM_SHIFT (0U)
#define CCM_ANALOG_AUDIO_PLL2_FDIV_CTL1_PLL_DSM(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL2_FDIV_CTL1_PLL_DSM_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL2_FDIV_CTL1_PLL_DSM_MASK)
/*! @} */

/*! @name AUDIO_PLL2_SSCG_CTRL - AUDIO PLL2 PLL SSCG Control Register */
/*! @{ */
#define CCM_ANALOG_AUDIO_PLL2_SSCG_CTRL_SEL_PF_MASK  (0x3U)
#define CCM_ANALOG_AUDIO_PLL2_SSCG_CTRL_SEL_PF_SHIFT (0U)
/*! SEL_PF
 *  0b00..Down spread
 *  0b01..Up spread
 *  0b1x..Center spread
 */
#define CCM_ANALOG_AUDIO_PLL2_SSCG_CTRL_SEL_PF(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL2_SSCG_CTRL_SEL_PF_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL2_SSCG_CTRL_SEL_PF_MASK)
#define CCM_ANALOG_AUDIO_PLL2_SSCG_CTRL_PLL_MRAT_CTL_MASK  (0x3F0U)
#define CCM_ANALOG_AUDIO_PLL2_SSCG_CTRL_PLL_MRAT_CTL_SHIFT (4U)
#define CCM_ANALOG_AUDIO_PLL2_SSCG_CTRL_PLL_MRAT_CTL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL2_SSCG_CTRL_PLL_MRAT_CTL_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL2_SSCG_CTRL_PLL_MRAT_CTL_MASK)
#define CCM_ANALOG_AUDIO_PLL2_SSCG_CTRL_PLL_MFREQ_CTL_MASK  (0xFF000U)
#define CCM_ANALOG_AUDIO_PLL2_SSCG_CTRL_PLL_MFREQ_CTL_SHIFT (12U)
#define CCM_ANALOG_AUDIO_PLL2_SSCG_CTRL_PLL_MFREQ_CTL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL2_SSCG_CTRL_PLL_MFREQ_CTL_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL2_SSCG_CTRL_PLL_MFREQ_CTL_MASK)
#define CCM_ANALOG_AUDIO_PLL2_SSCG_CTRL_SSCG_EN_MASK  (0x80000000U)
#define CCM_ANALOG_AUDIO_PLL2_SSCG_CTRL_SSCG_EN_SHIFT (31U)
/*! SSCG_EN
 *  0b1..Enable Spread Spectrum Mode
 *  0b0..Disable Spread Spectrum Mode
 */
#define CCM_ANALOG_AUDIO_PLL2_SSCG_CTRL_SSCG_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL2_SSCG_CTRL_SSCG_EN_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL2_SSCG_CTRL_SSCG_EN_MASK)
/*! @} */

/*! @name AUDIO_PLL2_MNIT_CTRL - AUDIO PLL2 PLL Monitoring Control Register */
/*! @{ */
#define CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_ICP_MASK  (0x7U)
#define CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_ICP_SHIFT (0U)
#define CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_ICP(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_ICP_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_ICP_MASK)
#define CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_AFC_EN_MASK  (0x8U)
#define CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_AFC_EN_SHIFT (3U)
#define CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_AFC_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_AFC_EN_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_AFC_EN_MASK)
#define CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_EXTAFC_MASK  (0x1F0U)
#define CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_EXTAFC_SHIFT (4U)
#define CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_EXTAFC(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_EXTAFC_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_EXTAFC_MASK)
#define CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_FEED_EN_MASK  (0x4000U)
#define CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_FEED_EN_SHIFT (14U)
#define CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_FEED_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_FEED_EN_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_FEED_EN_MASK)
#define CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_FSEL_MASK  (0x8000U)
#define CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_FSEL_SHIFT (15U)
/*! FSEL
 *  0b0..FEED_OUT = FREF
 *  0b1..FEED_OUT = FEED
 */
#define CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_FSEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_FSEL_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_FSEL_MASK)
#define CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_AFCINIT_SEL_MASK  (0x20000U)
#define CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_AFCINIT_SEL_SHIFT (17U)
/*! AFCINIT_SEL
 *  0b0..nominal delay
 *  0b1..nominal delay * 2
 */
#define CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_AFCINIT_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_AFCINIT_SEL_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_AFCINIT_SEL_MASK)
#define CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_PBIAS_CTRL_EN_MASK  (0x40000U)
#define CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_PBIAS_CTRL_EN_SHIFT (18U)
#define CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_PBIAS_CTRL_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_PBIAS_CTRL_EN_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_PBIAS_CTRL_EN_MASK)
#define CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_PBIAS_CTRL_MASK  (0x80000U)
#define CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_PBIAS_CTRL_SHIFT (19U)
/*! PBIAS_CTRL
 *  0b0..0.50*VDD
 *  0b1..0.67*VDD
 */
#define CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_PBIAS_CTRL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_PBIAS_CTRL_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_PBIAS_CTRL_MASK)
#define CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_AFC_SEL_MASK  (0x100000U)
#define CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_AFC_SEL_SHIFT (20U)
#define CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_AFC_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_AFC_SEL_SHIFT)) & \
     CCM_ANALOG_AUDIO_PLL2_MNIT_CTRL_AFC_SEL_MASK)
/*! @} */

/*! @name VIDEO_PLL1_GEN_CTRL - VIDEO PLL1 General Function Control Register */
/*! @{ */
#define CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_REF_CLK_SEL_MASK  (0x3U)
#define CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_REF_CLK_SEL_SHIFT (0U)
/*! PLL_REF_CLK_SEL
 *  0b00..24M_REF_CLK
 *  0b01..PAD_CLK
 *  0b10..Reserved
 *  0b11..Reserved
 */
#define CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_REF_CLK_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_REF_CLK_SEL_SHIFT)) & \
     CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_REF_CLK_SEL_MASK)
#define CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PAD_CLK_SEL_MASK  (0xCU)
#define CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PAD_CLK_SEL_SHIFT (2U)
/*! PAD_CLK_SEL
 *  0b00..CLKIN1 XOR CLKIN2
 *  0b01..CLKIN2
 *  0b10..CLKIN1
 *  0b11..Reserved
 */
#define CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PAD_CLK_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PAD_CLK_SEL_SHIFT)) & \
     CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PAD_CLK_SEL_MASK)
#define CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_BYPASS_MASK  (0x10U)
#define CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_BYPASS_SHIFT (4U)
#define CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_BYPASS(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_BYPASS_SHIFT)) & \
     CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_BYPASS_MASK)
#define CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_RST_OVERRIDE_MASK  (0x100U)
#define CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_RST_OVERRIDE_SHIFT (8U)
#define CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_RST_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_RST_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_RST_OVERRIDE_MASK)
#define CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_RST_MASK  (0x200U)
#define CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_RST_SHIFT (9U)
#define CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_RST(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_RST_SHIFT)) & \
     CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_RST_MASK)
#define CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_CLKE_OVERRIDE_MASK  (0x1000U)
#define CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_CLKE_OVERRIDE_SHIFT (12U)
#define CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_CLKE_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_CLKE_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_CLKE_OVERRIDE_MASK)
#define CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_CLKE_MASK  (0x2000U)
#define CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_CLKE_SHIFT (13U)
#define CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_CLKE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_CLKE_SHIFT)) & \
     CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_CLKE_MASK)
#define CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_EXT_BYPASS_MASK  (0x10000U)
#define CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_EXT_BYPASS_SHIFT (16U)
#define CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_EXT_BYPASS(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_EXT_BYPASS_SHIFT)) & \
     CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_EXT_BYPASS_MASK)
#define CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_LOCK_MASK  (0x80000000U)
#define CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_LOCK_SHIFT (31U)
#define CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_LOCK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_LOCK_SHIFT)) & \
     CCM_ANALOG_VIDEO_PLL1_GEN_CTRL_PLL_LOCK_MASK)
/*! @} */

/*! @name VIDEO_PLL1_FDIV_CTL0 - VIDEO PLL1 Divide and Fraction Data Control 0 Register */
/*! @{ */
#define CCM_ANALOG_VIDEO_PLL1_FDIV_CTL0_PLL_POST_DIV_MASK  (0x7U)
#define CCM_ANALOG_VIDEO_PLL1_FDIV_CTL0_PLL_POST_DIV_SHIFT (0U)
#define CCM_ANALOG_VIDEO_PLL1_FDIV_CTL0_PLL_POST_DIV(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VIDEO_PLL1_FDIV_CTL0_PLL_POST_DIV_SHIFT)) & \
     CCM_ANALOG_VIDEO_PLL1_FDIV_CTL0_PLL_POST_DIV_MASK)
#define CCM_ANALOG_VIDEO_PLL1_FDIV_CTL0_PLL_PRE_DIV_MASK  (0x3F0U)
#define CCM_ANALOG_VIDEO_PLL1_FDIV_CTL0_PLL_PRE_DIV_SHIFT (4U)
#define CCM_ANALOG_VIDEO_PLL1_FDIV_CTL0_PLL_PRE_DIV(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VIDEO_PLL1_FDIV_CTL0_PLL_PRE_DIV_SHIFT)) & \
     CCM_ANALOG_VIDEO_PLL1_FDIV_CTL0_PLL_PRE_DIV_MASK)
#define CCM_ANALOG_VIDEO_PLL1_FDIV_CTL0_PLL_MAIN_DIV_MASK  (0x3FF000U)
#define CCM_ANALOG_VIDEO_PLL1_FDIV_CTL0_PLL_MAIN_DIV_SHIFT (12U)
#define CCM_ANALOG_VIDEO_PLL1_FDIV_CTL0_PLL_MAIN_DIV(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VIDEO_PLL1_FDIV_CTL0_PLL_MAIN_DIV_SHIFT)) & \
     CCM_ANALOG_VIDEO_PLL1_FDIV_CTL0_PLL_MAIN_DIV_MASK)
/*! @} */

/*! @name VIDEO_PLL1_FDIV_CTL1 - VIDEO PLL1 Divide and Fraction Data Control 1 Register */
/*! @{ */
#define CCM_ANALOG_VIDEO_PLL1_FDIV_CTL1_PLL_DSM_MASK  (0xFFFFU)
#define CCM_ANALOG_VIDEO_PLL1_FDIV_CTL1_PLL_DSM_SHIFT (0U)
#define CCM_ANALOG_VIDEO_PLL1_FDIV_CTL1_PLL_DSM(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VIDEO_PLL1_FDIV_CTL1_PLL_DSM_SHIFT)) & \
     CCM_ANALOG_VIDEO_PLL1_FDIV_CTL1_PLL_DSM_MASK)
/*! @} */

/*! @name VIDEO_PLL1_SSCG_CTRL - VIDEO PLL1 PLL SSCG Control Register */
/*! @{ */
#define CCM_ANALOG_VIDEO_PLL1_SSCG_CTRL_SEL_PF_MASK  (0x3U)
#define CCM_ANALOG_VIDEO_PLL1_SSCG_CTRL_SEL_PF_SHIFT (0U)
/*! SEL_PF
 *  0b00..Down spread
 *  0b01..Up spread
 *  0b1x..Center spread
 */
#define CCM_ANALOG_VIDEO_PLL1_SSCG_CTRL_SEL_PF(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VIDEO_PLL1_SSCG_CTRL_SEL_PF_SHIFT)) & \
     CCM_ANALOG_VIDEO_PLL1_SSCG_CTRL_SEL_PF_MASK)
#define CCM_ANALOG_VIDEO_PLL1_SSCG_CTRL_PLL_MRAT_CTL_MASK  (0x3F0U)
#define CCM_ANALOG_VIDEO_PLL1_SSCG_CTRL_PLL_MRAT_CTL_SHIFT (4U)
#define CCM_ANALOG_VIDEO_PLL1_SSCG_CTRL_PLL_MRAT_CTL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VIDEO_PLL1_SSCG_CTRL_PLL_MRAT_CTL_SHIFT)) & \
     CCM_ANALOG_VIDEO_PLL1_SSCG_CTRL_PLL_MRAT_CTL_MASK)
#define CCM_ANALOG_VIDEO_PLL1_SSCG_CTRL_PLL_MFREQ_CTL_MASK  (0xFF000U)
#define CCM_ANALOG_VIDEO_PLL1_SSCG_CTRL_PLL_MFREQ_CTL_SHIFT (12U)
#define CCM_ANALOG_VIDEO_PLL1_SSCG_CTRL_PLL_MFREQ_CTL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VIDEO_PLL1_SSCG_CTRL_PLL_MFREQ_CTL_SHIFT)) & \
     CCM_ANALOG_VIDEO_PLL1_SSCG_CTRL_PLL_MFREQ_CTL_MASK)
#define CCM_ANALOG_VIDEO_PLL1_SSCG_CTRL_SSCG_EN_MASK  (0x80000000U)
#define CCM_ANALOG_VIDEO_PLL1_SSCG_CTRL_SSCG_EN_SHIFT (31U)
/*! SSCG_EN
 *  0b1..Enable Spread Spectrum Mode
 *  0b0..Disable Spread Spectrum Mode
 */
#define CCM_ANALOG_VIDEO_PLL1_SSCG_CTRL_SSCG_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VIDEO_PLL1_SSCG_CTRL_SSCG_EN_SHIFT)) & \
     CCM_ANALOG_VIDEO_PLL1_SSCG_CTRL_SSCG_EN_MASK)
/*! @} */

/*! @name VIDEO_PLL1_MNIT_CTRL - VIDEO PLL1 PLL Monitoring Control Register */
/*! @{ */
#define CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_ICP_MASK  (0x7U)
#define CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_ICP_SHIFT (0U)
#define CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_ICP(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_ICP_SHIFT)) & \
     CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_ICP_MASK)
#define CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_AFC_EN_MASK  (0x8U)
#define CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_AFC_EN_SHIFT (3U)
#define CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_AFC_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_AFC_EN_SHIFT)) & \
     CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_AFC_EN_MASK)
#define CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_EXTAFC_MASK  (0x1F0U)
#define CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_EXTAFC_SHIFT (4U)
#define CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_EXTAFC(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_EXTAFC_SHIFT)) & \
     CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_EXTAFC_MASK)
#define CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_FEED_EN_MASK  (0x4000U)
#define CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_FEED_EN_SHIFT (14U)
#define CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_FEED_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_FEED_EN_SHIFT)) & \
     CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_FEED_EN_MASK)
#define CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_FSEL_MASK  (0x8000U)
#define CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_FSEL_SHIFT (15U)
/*! FSEL
 *  0b0..FEED_OUT = FREF
 *  0b1..FEED_OUT = FEED
 */
#define CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_FSEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_FSEL_SHIFT)) & \
     CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_FSEL_MASK)
#define CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_AFCINIT_SEL_MASK  (0x20000U)
#define CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_AFCINIT_SEL_SHIFT (17U)
/*! AFCINIT_SEL
 *  0b0..nominal delay
 *  0b1..nominal delay * 2
 */
#define CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_AFCINIT_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_AFCINIT_SEL_SHIFT)) & \
     CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_AFCINIT_SEL_MASK)
#define CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_PBIAS_CTRL_EN_MASK  (0x40000U)
#define CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_PBIAS_CTRL_EN_SHIFT (18U)
#define CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_PBIAS_CTRL_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_PBIAS_CTRL_EN_SHIFT)) & \
     CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_PBIAS_CTRL_EN_MASK)
#define CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_PBIAS_CTRL_MASK  (0x80000U)
#define CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_PBIAS_CTRL_SHIFT (19U)
/*! PBIAS_CTRL
 *  0b0..0.50*VDD
 *  0b1..0.67*VDD
 */
#define CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_PBIAS_CTRL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_PBIAS_CTRL_SHIFT)) & \
     CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_PBIAS_CTRL_MASK)
#define CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_AFC_SEL_MASK  (0x100000U)
#define CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_AFC_SEL_SHIFT (20U)
#define CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_AFC_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_AFC_SEL_SHIFT)) & \
     CCM_ANALOG_VIDEO_PLL1_MNIT_CTRL_AFC_SEL_MASK)
/*! @} */

/*! @name DRAM_PLL_GEN_CTRL - DRAM PLL General Function Control Register */
/*! @{ */
#define CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_REF_CLK_SEL_MASK  (0x3U)
#define CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_REF_CLK_SEL_SHIFT (0U)
/*! PLL_REF_CLK_SEL
 *  0b00..24M_REF_CLK
 *  0b01..PAD_CLK
 *  0b10..Reserved
 *  0b11..Reserved
 */
#define CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_REF_CLK_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_REF_CLK_SEL_SHIFT)) & \
     CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_REF_CLK_SEL_MASK)
#define CCM_ANALOG_DRAM_PLL_GEN_CTRL_PAD_CLK_SEL_MASK  (0xCU)
#define CCM_ANALOG_DRAM_PLL_GEN_CTRL_PAD_CLK_SEL_SHIFT (2U)
/*! PAD_CLK_SEL
 *  0b00..CLKIN1 XOR CLKIN2
 *  0b01..CLKIN2
 *  0b10..CLKIN1
 *  0b11..Reserved
 */
#define CCM_ANALOG_DRAM_PLL_GEN_CTRL_PAD_CLK_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_DRAM_PLL_GEN_CTRL_PAD_CLK_SEL_SHIFT)) & \
     CCM_ANALOG_DRAM_PLL_GEN_CTRL_PAD_CLK_SEL_MASK)
#define CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_BYPASS_MASK  (0x10U)
#define CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_BYPASS_SHIFT (4U)
#define CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_BYPASS(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_BYPASS_SHIFT)) & \
     CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_BYPASS_MASK)
#define CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_RST_OVERRIDE_MASK  (0x100U)
#define CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_RST_OVERRIDE_SHIFT (8U)
#define CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_RST_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_RST_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_RST_OVERRIDE_MASK)
#define CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_RST_MASK  (0x200U)
#define CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_RST_SHIFT (9U)
#define CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_RST(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_RST_SHIFT)) & \
     CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_RST_MASK)
#define CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_CLKE_OVERRIDE_MASK  (0x1000U)
#define CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_CLKE_OVERRIDE_SHIFT (12U)
#define CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_CLKE_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_CLKE_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_CLKE_OVERRIDE_MASK)
#define CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_CLKE_MASK  (0x2000U)
#define CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_CLKE_SHIFT (13U)
#define CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_CLKE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_CLKE_SHIFT)) & \
     CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_CLKE_MASK)
#define CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_EXT_BYPASS_MASK  (0x10000U)
#define CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_EXT_BYPASS_SHIFT (16U)
#define CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_EXT_BYPASS(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_EXT_BYPASS_SHIFT)) & \
     CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_EXT_BYPASS_MASK)
#define CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_LOCK_MASK  (0x80000000U)
#define CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_LOCK_SHIFT (31U)
#define CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_LOCK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_LOCK_SHIFT)) & \
     CCM_ANALOG_DRAM_PLL_GEN_CTRL_PLL_LOCK_MASK)
/*! @} */

/*! @name DRAM_PLL_FDIV_CTL0 - DRAM PLL Divide and Fraction Data Control 0 Register */
/*! @{ */
#define CCM_ANALOG_DRAM_PLL_FDIV_CTL0_PLL_POST_DIV_MASK  (0x7U)
#define CCM_ANALOG_DRAM_PLL_FDIV_CTL0_PLL_POST_DIV_SHIFT (0U)
#define CCM_ANALOG_DRAM_PLL_FDIV_CTL0_PLL_POST_DIV(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_DRAM_PLL_FDIV_CTL0_PLL_POST_DIV_SHIFT)) & \
     CCM_ANALOG_DRAM_PLL_FDIV_CTL0_PLL_POST_DIV_MASK)
#define CCM_ANALOG_DRAM_PLL_FDIV_CTL0_PLL_PRE_DIV_MASK  (0x3F0U)
#define CCM_ANALOG_DRAM_PLL_FDIV_CTL0_PLL_PRE_DIV_SHIFT (4U)
#define CCM_ANALOG_DRAM_PLL_FDIV_CTL0_PLL_PRE_DIV(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_DRAM_PLL_FDIV_CTL0_PLL_PRE_DIV_SHIFT)) & \
     CCM_ANALOG_DRAM_PLL_FDIV_CTL0_PLL_PRE_DIV_MASK)
#define CCM_ANALOG_DRAM_PLL_FDIV_CTL0_PLL_MAIN_DIV_MASK  (0x3FF000U)
#define CCM_ANALOG_DRAM_PLL_FDIV_CTL0_PLL_MAIN_DIV_SHIFT (12U)
#define CCM_ANALOG_DRAM_PLL_FDIV_CTL0_PLL_MAIN_DIV(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_DRAM_PLL_FDIV_CTL0_PLL_MAIN_DIV_SHIFT)) & \
     CCM_ANALOG_DRAM_PLL_FDIV_CTL0_PLL_MAIN_DIV_MASK)
/*! @} */

/*! @name DRAM_PLL_FDIV_CTL1 - DRAM PLL Divide and Fraction Data Control 1 Register */
/*! @{ */
#define CCM_ANALOG_DRAM_PLL_FDIV_CTL1_PLL_DSM_MASK  (0xFFFFU)
#define CCM_ANALOG_DRAM_PLL_FDIV_CTL1_PLL_DSM_SHIFT (0U)
#define CCM_ANALOG_DRAM_PLL_FDIV_CTL1_PLL_DSM(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_DRAM_PLL_FDIV_CTL1_PLL_DSM_SHIFT)) & \
     CCM_ANALOG_DRAM_PLL_FDIV_CTL1_PLL_DSM_MASK)
/*! @} */

/*! @name DRAM_PLL_SSCG_CTRL - DRAM PLL PLL SSCG Control Register */
/*! @{ */
#define CCM_ANALOG_DRAM_PLL_SSCG_CTRL_SEL_PF_MASK  (0x3U)
#define CCM_ANALOG_DRAM_PLL_SSCG_CTRL_SEL_PF_SHIFT (0U)
/*! SEL_PF
 *  0b00..Down spread
 *  0b01..Up spread
 *  0b1x..Center spread
 */
#define CCM_ANALOG_DRAM_PLL_SSCG_CTRL_SEL_PF(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_DRAM_PLL_SSCG_CTRL_SEL_PF_SHIFT)) & \
     CCM_ANALOG_DRAM_PLL_SSCG_CTRL_SEL_PF_MASK)
#define CCM_ANALOG_DRAM_PLL_SSCG_CTRL_PLL_MRAT_CTL_MASK  (0x3F0U)
#define CCM_ANALOG_DRAM_PLL_SSCG_CTRL_PLL_MRAT_CTL_SHIFT (4U)
#define CCM_ANALOG_DRAM_PLL_SSCG_CTRL_PLL_MRAT_CTL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_DRAM_PLL_SSCG_CTRL_PLL_MRAT_CTL_SHIFT)) & \
     CCM_ANALOG_DRAM_PLL_SSCG_CTRL_PLL_MRAT_CTL_MASK)
#define CCM_ANALOG_DRAM_PLL_SSCG_CTRL_PLL_MFREQ_CTL_MASK  (0xFF000U)
#define CCM_ANALOG_DRAM_PLL_SSCG_CTRL_PLL_MFREQ_CTL_SHIFT (12U)
#define CCM_ANALOG_DRAM_PLL_SSCG_CTRL_PLL_MFREQ_CTL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_DRAM_PLL_SSCG_CTRL_PLL_MFREQ_CTL_SHIFT)) & \
     CCM_ANALOG_DRAM_PLL_SSCG_CTRL_PLL_MFREQ_CTL_MASK)
#define CCM_ANALOG_DRAM_PLL_SSCG_CTRL_SSCG_EN_MASK  (0x80000000U)
#define CCM_ANALOG_DRAM_PLL_SSCG_CTRL_SSCG_EN_SHIFT (31U)
/*! SSCG_EN
 *  0b1..Enable Spread Spectrum Mode
 *  0b0..Disable Spread Spectrum Mode
 */
#define CCM_ANALOG_DRAM_PLL_SSCG_CTRL_SSCG_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_DRAM_PLL_SSCG_CTRL_SSCG_EN_SHIFT)) & \
     CCM_ANALOG_DRAM_PLL_SSCG_CTRL_SSCG_EN_MASK)
/*! @} */

/*! @name DRAM_PLL_MNIT_CTRL - DRAM PLL PLL Monitoring Control Register */
/*! @{ */
#define CCM_ANALOG_DRAM_PLL_MNIT_CTRL_ICP_MASK  (0x7U)
#define CCM_ANALOG_DRAM_PLL_MNIT_CTRL_ICP_SHIFT (0U)
#define CCM_ANALOG_DRAM_PLL_MNIT_CTRL_ICP(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_DRAM_PLL_MNIT_CTRL_ICP_SHIFT)) & CCM_ANALOG_DRAM_PLL_MNIT_CTRL_ICP_MASK)
#define CCM_ANALOG_DRAM_PLL_MNIT_CTRL_AFC_EN_MASK  (0x8U)
#define CCM_ANALOG_DRAM_PLL_MNIT_CTRL_AFC_EN_SHIFT (3U)
#define CCM_ANALOG_DRAM_PLL_MNIT_CTRL_AFC_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_DRAM_PLL_MNIT_CTRL_AFC_EN_SHIFT)) & \
     CCM_ANALOG_DRAM_PLL_MNIT_CTRL_AFC_EN_MASK)
#define CCM_ANALOG_DRAM_PLL_MNIT_CTRL_EXTAFC_MASK  (0x1F0U)
#define CCM_ANALOG_DRAM_PLL_MNIT_CTRL_EXTAFC_SHIFT (4U)
#define CCM_ANALOG_DRAM_PLL_MNIT_CTRL_EXTAFC(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_DRAM_PLL_MNIT_CTRL_EXTAFC_SHIFT)) & \
     CCM_ANALOG_DRAM_PLL_MNIT_CTRL_EXTAFC_MASK)
#define CCM_ANALOG_DRAM_PLL_MNIT_CTRL_FEED_EN_MASK  (0x4000U)
#define CCM_ANALOG_DRAM_PLL_MNIT_CTRL_FEED_EN_SHIFT (14U)
#define CCM_ANALOG_DRAM_PLL_MNIT_CTRL_FEED_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_DRAM_PLL_MNIT_CTRL_FEED_EN_SHIFT)) & \
     CCM_ANALOG_DRAM_PLL_MNIT_CTRL_FEED_EN_MASK)
#define CCM_ANALOG_DRAM_PLL_MNIT_CTRL_FSEL_MASK  (0x8000U)
#define CCM_ANALOG_DRAM_PLL_MNIT_CTRL_FSEL_SHIFT (15U)
/*! FSEL
 *  0b0..FEED_OUT = FREF
 *  0b1..FEED_OUT = FEED
 */
#define CCM_ANALOG_DRAM_PLL_MNIT_CTRL_FSEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_DRAM_PLL_MNIT_CTRL_FSEL_SHIFT)) & \
     CCM_ANALOG_DRAM_PLL_MNIT_CTRL_FSEL_MASK)
#define CCM_ANALOG_DRAM_PLL_MNIT_CTRL_AFCINIT_SEL_MASK  (0x20000U)
#define CCM_ANALOG_DRAM_PLL_MNIT_CTRL_AFCINIT_SEL_SHIFT (17U)
/*! AFCINIT_SEL
 *  0b0..nominal delay
 *  0b1..nominal delay * 2
 */
#define CCM_ANALOG_DRAM_PLL_MNIT_CTRL_AFCINIT_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_DRAM_PLL_MNIT_CTRL_AFCINIT_SEL_SHIFT)) & \
     CCM_ANALOG_DRAM_PLL_MNIT_CTRL_AFCINIT_SEL_MASK)
#define CCM_ANALOG_DRAM_PLL_MNIT_CTRL_PBIAS_CTRL_EN_MASK  (0x40000U)
#define CCM_ANALOG_DRAM_PLL_MNIT_CTRL_PBIAS_CTRL_EN_SHIFT (18U)
#define CCM_ANALOG_DRAM_PLL_MNIT_CTRL_PBIAS_CTRL_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_DRAM_PLL_MNIT_CTRL_PBIAS_CTRL_EN_SHIFT)) & \
     CCM_ANALOG_DRAM_PLL_MNIT_CTRL_PBIAS_CTRL_EN_MASK)
#define CCM_ANALOG_DRAM_PLL_MNIT_CTRL_PBIAS_CTRL_MASK  (0x80000U)
#define CCM_ANALOG_DRAM_PLL_MNIT_CTRL_PBIAS_CTRL_SHIFT (19U)
/*! PBIAS_CTRL
 *  0b0..0.50*VDD
 *  0b1..0.67*VDD
 */
#define CCM_ANALOG_DRAM_PLL_MNIT_CTRL_PBIAS_CTRL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_DRAM_PLL_MNIT_CTRL_PBIAS_CTRL_SHIFT)) & \
     CCM_ANALOG_DRAM_PLL_MNIT_CTRL_PBIAS_CTRL_MASK)
#define CCM_ANALOG_DRAM_PLL_MNIT_CTRL_AFC_SEL_MASK  (0x100000U)
#define CCM_ANALOG_DRAM_PLL_MNIT_CTRL_AFC_SEL_SHIFT (20U)
#define CCM_ANALOG_DRAM_PLL_MNIT_CTRL_AFC_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_DRAM_PLL_MNIT_CTRL_AFC_SEL_SHIFT)) & \
     CCM_ANALOG_DRAM_PLL_MNIT_CTRL_AFC_SEL_MASK)
/*! @} */

/*! @name GPU_PLL_GEN_CTRL - GPU PLL General Function Control Register */
/*! @{ */
#define CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_REF_CLK_SEL_MASK  (0x3U)
#define CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_REF_CLK_SEL_SHIFT (0U)
/*! PLL_REF_CLK_SEL
 *  0b00..24M_REF_CLK
 *  0b01..PAD_CLK
 *  0b10..Reserved
 *  0b11..Reserved
 */
#define CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_REF_CLK_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_REF_CLK_SEL_SHIFT)) & \
     CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_REF_CLK_SEL_MASK)
#define CCM_ANALOG_GPU_PLL_GEN_CTRL_PAD_CLK_SEL_MASK  (0xCU)
#define CCM_ANALOG_GPU_PLL_GEN_CTRL_PAD_CLK_SEL_SHIFT (2U)
/*! PAD_CLK_SEL
 *  0b00..CLKIN1 XOR CLKIN2
 *  0b01..CLKIN2
 *  0b10..CLKIN1
 *  0b11..Reserved
 */
#define CCM_ANALOG_GPU_PLL_GEN_CTRL_PAD_CLK_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_GPU_PLL_GEN_CTRL_PAD_CLK_SEL_SHIFT)) & \
     CCM_ANALOG_GPU_PLL_GEN_CTRL_PAD_CLK_SEL_MASK)
#define CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_BYPASS_MASK  (0x10U)
#define CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_BYPASS_SHIFT (4U)
#define CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_BYPASS(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_BYPASS_SHIFT)) & \
     CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_BYPASS_MASK)
#define CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_RST_OVERRIDE_MASK  (0x100U)
#define CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_RST_OVERRIDE_SHIFT (8U)
#define CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_RST_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_RST_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_RST_OVERRIDE_MASK)
#define CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_RST_MASK  (0x200U)
#define CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_RST_SHIFT (9U)
#define CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_RST(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_RST_SHIFT)) & \
     CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_RST_MASK)
#define CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_CLKE_OVERRIDE_MASK  (0x400U)
#define CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_CLKE_OVERRIDE_SHIFT (10U)
#define CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_CLKE_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_CLKE_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_CLKE_OVERRIDE_MASK)
#define CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_CLKE_MASK  (0x800U)
#define CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_CLKE_SHIFT (11U)
#define CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_CLKE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_CLKE_SHIFT)) & \
     CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_CLKE_MASK)
#define CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_EXT_BYPASS_MASK  (0x10000000U)
#define CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_EXT_BYPASS_SHIFT (28U)
#define CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_EXT_BYPASS(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_EXT_BYPASS_SHIFT)) & \
     CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_EXT_BYPASS_MASK)
#define CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_LOCK_SEL_MASK  (0x20000000U)
#define CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_LOCK_SEL_SHIFT (29U)
/*! PLL_LOCK_SEL
 *  0b0..Using PLL maximum lock time
 *  0b1..Using PLL output lock
 */
#define CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_LOCK_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_LOCK_SEL_SHIFT)) & \
     CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_LOCK_SEL_MASK)
#define CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_LOCK_MASK  (0x80000000U)
#define CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_LOCK_SHIFT (31U)
#define CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_LOCK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_LOCK_SHIFT)) & \
     CCM_ANALOG_GPU_PLL_GEN_CTRL_PLL_LOCK_MASK)
/*! @} */

/*! @name GPU_PLL_FDIV_CTL0 - GPU PLL Divide and Fraction Data Control 0 Register */
/*! @{ */
#define CCM_ANALOG_GPU_PLL_FDIV_CTL0_PLL_POST_DIV_MASK  (0x7U)
#define CCM_ANALOG_GPU_PLL_FDIV_CTL0_PLL_POST_DIV_SHIFT (0U)
#define CCM_ANALOG_GPU_PLL_FDIV_CTL0_PLL_POST_DIV(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_GPU_PLL_FDIV_CTL0_PLL_POST_DIV_SHIFT)) & \
     CCM_ANALOG_GPU_PLL_FDIV_CTL0_PLL_POST_DIV_MASK)
#define CCM_ANALOG_GPU_PLL_FDIV_CTL0_PLL_PRE_DIV_MASK  (0x3F0U)
#define CCM_ANALOG_GPU_PLL_FDIV_CTL0_PLL_PRE_DIV_SHIFT (4U)
#define CCM_ANALOG_GPU_PLL_FDIV_CTL0_PLL_PRE_DIV(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_GPU_PLL_FDIV_CTL0_PLL_PRE_DIV_SHIFT)) & \
     CCM_ANALOG_GPU_PLL_FDIV_CTL0_PLL_PRE_DIV_MASK)
#define CCM_ANALOG_GPU_PLL_FDIV_CTL0_PLL_MAIN_DIV_MASK  (0x3FF000U)
#define CCM_ANALOG_GPU_PLL_FDIV_CTL0_PLL_MAIN_DIV_SHIFT (12U)
#define CCM_ANALOG_GPU_PLL_FDIV_CTL0_PLL_MAIN_DIV(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_GPU_PLL_FDIV_CTL0_PLL_MAIN_DIV_SHIFT)) & \
     CCM_ANALOG_GPU_PLL_FDIV_CTL0_PLL_MAIN_DIV_MASK)
/*! @} */

/*! @name GPU_PLL_LOCKD_CTRL - PLL Lock Detector Control Register */
/*! @{ */
#define CCM_ANALOG_GPU_PLL_LOCKD_CTRL_LOCK_CON_IN_MASK  (0x3U)
#define CCM_ANALOG_GPU_PLL_LOCKD_CTRL_LOCK_CON_IN_SHIFT (0U)
#define CCM_ANALOG_GPU_PLL_LOCKD_CTRL_LOCK_CON_IN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_GPU_PLL_LOCKD_CTRL_LOCK_CON_IN_SHIFT)) & \
     CCM_ANALOG_GPU_PLL_LOCKD_CTRL_LOCK_CON_IN_MASK)
#define CCM_ANALOG_GPU_PLL_LOCKD_CTRL_LOCK_CON_OUT_MASK  (0xCU)
#define CCM_ANALOG_GPU_PLL_LOCKD_CTRL_LOCK_CON_OUT_SHIFT (2U)
#define CCM_ANALOG_GPU_PLL_LOCKD_CTRL_LOCK_CON_OUT(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_GPU_PLL_LOCKD_CTRL_LOCK_CON_OUT_SHIFT)) & \
     CCM_ANALOG_GPU_PLL_LOCKD_CTRL_LOCK_CON_OUT_MASK)
#define CCM_ANALOG_GPU_PLL_LOCKD_CTRL_LOCK_CON_DLY_MASK  (0x30U)
#define CCM_ANALOG_GPU_PLL_LOCKD_CTRL_LOCK_CON_DLY_SHIFT (4U)
#define CCM_ANALOG_GPU_PLL_LOCKD_CTRL_LOCK_CON_DLY(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_GPU_PLL_LOCKD_CTRL_LOCK_CON_DLY_SHIFT)) & \
     CCM_ANALOG_GPU_PLL_LOCKD_CTRL_LOCK_CON_DLY_MASK)
/*! @} */

/*! @name GPU_PLL_MNIT_CTRL - PLL Monitoring Control Register */
/*! @{ */
#define CCM_ANALOG_GPU_PLL_MNIT_CTRL_ICP_MASK  (0x3U)
#define CCM_ANALOG_GPU_PLL_MNIT_CTRL_ICP_SHIFT (0U)
#define CCM_ANALOG_GPU_PLL_MNIT_CTRL_ICP(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_GPU_PLL_MNIT_CTRL_ICP_SHIFT)) & CCM_ANALOG_GPU_PLL_MNIT_CTRL_ICP_MASK)
#define CCM_ANALOG_GPU_PLL_MNIT_CTRL_AFC_EN_MASK  (0x4U)
#define CCM_ANALOG_GPU_PLL_MNIT_CTRL_AFC_EN_SHIFT (2U)
#define CCM_ANALOG_GPU_PLL_MNIT_CTRL_AFC_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_GPU_PLL_MNIT_CTRL_AFC_EN_SHIFT)) & \
     CCM_ANALOG_GPU_PLL_MNIT_CTRL_AFC_EN_MASK)
#define CCM_ANALOG_GPU_PLL_MNIT_CTRL_EXTAFC_MASK  (0xF8U)
#define CCM_ANALOG_GPU_PLL_MNIT_CTRL_EXTAFC_SHIFT (3U)
#define CCM_ANALOG_GPU_PLL_MNIT_CTRL_EXTAFC(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_GPU_PLL_MNIT_CTRL_EXTAFC_SHIFT)) & \
     CCM_ANALOG_GPU_PLL_MNIT_CTRL_EXTAFC_MASK)
#define CCM_ANALOG_GPU_PLL_MNIT_CTRL_FEED_EN_MASK  (0x2000U)
#define CCM_ANALOG_GPU_PLL_MNIT_CTRL_FEED_EN_SHIFT (13U)
#define CCM_ANALOG_GPU_PLL_MNIT_CTRL_FEED_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_GPU_PLL_MNIT_CTRL_FEED_EN_SHIFT)) & \
     CCM_ANALOG_GPU_PLL_MNIT_CTRL_FEED_EN_MASK)
#define CCM_ANALOG_GPU_PLL_MNIT_CTRL_FSEL_MASK  (0x4000U)
#define CCM_ANALOG_GPU_PLL_MNIT_CTRL_FSEL_SHIFT (14U)
/*! FSEL
 *  0b0..FEED_OUT = FREF
 *  0b1..FEED_OUT = FEED
 */
#define CCM_ANALOG_GPU_PLL_MNIT_CTRL_FSEL(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_GPU_PLL_MNIT_CTRL_FSEL_SHIFT)) & CCM_ANALOG_GPU_PLL_MNIT_CTRL_FSEL_MASK)
#define CCM_ANALOG_GPU_PLL_MNIT_CTRL_AFCINIT_SEL_MASK  (0x10000U)
#define CCM_ANALOG_GPU_PLL_MNIT_CTRL_AFCINIT_SEL_SHIFT (16U)
/*! AFCINIT_SEL
 *  0b0..nominal delay
 *  0b1..nominal delay * 2
 */
#define CCM_ANALOG_GPU_PLL_MNIT_CTRL_AFCINIT_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_GPU_PLL_MNIT_CTRL_AFCINIT_SEL_SHIFT)) & \
     CCM_ANALOG_GPU_PLL_MNIT_CTRL_AFCINIT_SEL_MASK)
#define CCM_ANALOG_GPU_PLL_MNIT_CTRL_PBIAS_CTRL_EN_MASK  (0x20000U)
#define CCM_ANALOG_GPU_PLL_MNIT_CTRL_PBIAS_CTRL_EN_SHIFT (17U)
#define CCM_ANALOG_GPU_PLL_MNIT_CTRL_PBIAS_CTRL_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_GPU_PLL_MNIT_CTRL_PBIAS_CTRL_EN_SHIFT)) & \
     CCM_ANALOG_GPU_PLL_MNIT_CTRL_PBIAS_CTRL_EN_MASK)
#define CCM_ANALOG_GPU_PLL_MNIT_CTRL_PBIAS_CTRL_MASK  (0x40000U)
#define CCM_ANALOG_GPU_PLL_MNIT_CTRL_PBIAS_CTRL_SHIFT (18U)
/*! PBIAS_CTRL
 *  0b0..0.50*VDD
 *  0b1..0.67*VDD
 */
#define CCM_ANALOG_GPU_PLL_MNIT_CTRL_PBIAS_CTRL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_GPU_PLL_MNIT_CTRL_PBIAS_CTRL_SHIFT)) & \
     CCM_ANALOG_GPU_PLL_MNIT_CTRL_PBIAS_CTRL_MASK)
#define CCM_ANALOG_GPU_PLL_MNIT_CTRL_AFC_SEL_MASK  (0x80000U)
#define CCM_ANALOG_GPU_PLL_MNIT_CTRL_AFC_SEL_SHIFT (19U)
#define CCM_ANALOG_GPU_PLL_MNIT_CTRL_AFC_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_GPU_PLL_MNIT_CTRL_AFC_SEL_SHIFT)) & \
     CCM_ANALOG_GPU_PLL_MNIT_CTRL_AFC_SEL_MASK)
#define CCM_ANALOG_GPU_PLL_MNIT_CTRL_FOUT_MASK_MASK  (0x100000U)
#define CCM_ANALOG_GPU_PLL_MNIT_CTRL_FOUT_MASK_SHIFT (20U)
#define CCM_ANALOG_GPU_PLL_MNIT_CTRL_FOUT_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_GPU_PLL_MNIT_CTRL_FOUT_MASK_SHIFT)) & \
     CCM_ANALOG_GPU_PLL_MNIT_CTRL_FOUT_MASK_MASK)
#define CCM_ANALOG_GPU_PLL_MNIT_CTRL_LRD_EN_MASK  (0x200000U)
#define CCM_ANALOG_GPU_PLL_MNIT_CTRL_LRD_EN_SHIFT (21U)
#define CCM_ANALOG_GPU_PLL_MNIT_CTRL_LRD_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_GPU_PLL_MNIT_CTRL_LRD_EN_SHIFT)) & \
     CCM_ANALOG_GPU_PLL_MNIT_CTRL_LRD_EN_MASK)
/*! @} */

/*! @name VPU_PLL_GEN_CTRL - VPU PLL General Function Control Register */
/*! @{ */
#define CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_REF_CLK_SEL_MASK  (0x3U)
#define CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_REF_CLK_SEL_SHIFT (0U)
/*! PLL_REF_CLK_SEL
 *  0b00..24M_REF_CLK
 *  0b01..PAD_CLK
 *  0b10..Reserved
 *  0b11..Reserved
 */
#define CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_REF_CLK_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_REF_CLK_SEL_SHIFT)) & \
     CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_REF_CLK_SEL_MASK)
#define CCM_ANALOG_VPU_PLL_GEN_CTRL_PAD_CLK_SEL_MASK  (0xCU)
#define CCM_ANALOG_VPU_PLL_GEN_CTRL_PAD_CLK_SEL_SHIFT (2U)
/*! PAD_CLK_SEL
 *  0b00..CLKIN1 XOR CLKIN2
 *  0b01..CLKIN2
 *  0b10..CLKIN1
 *  0b11..Reserved
 */
#define CCM_ANALOG_VPU_PLL_GEN_CTRL_PAD_CLK_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VPU_PLL_GEN_CTRL_PAD_CLK_SEL_SHIFT)) & \
     CCM_ANALOG_VPU_PLL_GEN_CTRL_PAD_CLK_SEL_MASK)
#define CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_BYPASS_MASK  (0x10U)
#define CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_BYPASS_SHIFT (4U)
#define CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_BYPASS(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_BYPASS_SHIFT)) & \
     CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_BYPASS_MASK)
#define CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_RST_OVERRIDE_MASK  (0x100U)
#define CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_RST_OVERRIDE_SHIFT (8U)
#define CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_RST_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_RST_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_RST_OVERRIDE_MASK)
#define CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_RST_MASK  (0x200U)
#define CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_RST_SHIFT (9U)
#define CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_RST(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_RST_SHIFT)) & \
     CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_RST_MASK)
#define CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_CLKE_OVERRIDE_MASK  (0x400U)
#define CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_CLKE_OVERRIDE_SHIFT (10U)
#define CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_CLKE_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_CLKE_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_CLKE_OVERRIDE_MASK)
#define CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_CLKE_MASK  (0x800U)
#define CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_CLKE_SHIFT (11U)
#define CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_CLKE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_CLKE_SHIFT)) & \
     CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_CLKE_MASK)
#define CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_EXT_BYPASS_MASK  (0x10000000U)
#define CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_EXT_BYPASS_SHIFT (28U)
#define CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_EXT_BYPASS(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_EXT_BYPASS_SHIFT)) & \
     CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_EXT_BYPASS_MASK)
#define CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_LOCK_SEL_MASK  (0x20000000U)
#define CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_LOCK_SEL_SHIFT (29U)
/*! PLL_LOCK_SEL
 *  0b0..Using PLL maximum lock time
 *  0b1..Using PLL output lock
 */
#define CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_LOCK_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_LOCK_SEL_SHIFT)) & \
     CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_LOCK_SEL_MASK)
#define CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_LOCK_MASK  (0x80000000U)
#define CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_LOCK_SHIFT (31U)
#define CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_LOCK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_LOCK_SHIFT)) & \
     CCM_ANALOG_VPU_PLL_GEN_CTRL_PLL_LOCK_MASK)
/*! @} */

/*! @name VPU_PLL_FDIV_CTL0 - VPU PLL Divide and Fraction Data Control 0 Register */
/*! @{ */
#define CCM_ANALOG_VPU_PLL_FDIV_CTL0_PLL_POST_DIV_MASK  (0x7U)
#define CCM_ANALOG_VPU_PLL_FDIV_CTL0_PLL_POST_DIV_SHIFT (0U)
#define CCM_ANALOG_VPU_PLL_FDIV_CTL0_PLL_POST_DIV(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VPU_PLL_FDIV_CTL0_PLL_POST_DIV_SHIFT)) & \
     CCM_ANALOG_VPU_PLL_FDIV_CTL0_PLL_POST_DIV_MASK)
#define CCM_ANALOG_VPU_PLL_FDIV_CTL0_PLL_PRE_DIV_MASK  (0x3F0U)
#define CCM_ANALOG_VPU_PLL_FDIV_CTL0_PLL_PRE_DIV_SHIFT (4U)
#define CCM_ANALOG_VPU_PLL_FDIV_CTL0_PLL_PRE_DIV(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VPU_PLL_FDIV_CTL0_PLL_PRE_DIV_SHIFT)) & \
     CCM_ANALOG_VPU_PLL_FDIV_CTL0_PLL_PRE_DIV_MASK)
#define CCM_ANALOG_VPU_PLL_FDIV_CTL0_PLL_MAIN_DIV_MASK  (0x3FF000U)
#define CCM_ANALOG_VPU_PLL_FDIV_CTL0_PLL_MAIN_DIV_SHIFT (12U)
#define CCM_ANALOG_VPU_PLL_FDIV_CTL0_PLL_MAIN_DIV(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VPU_PLL_FDIV_CTL0_PLL_MAIN_DIV_SHIFT)) & \
     CCM_ANALOG_VPU_PLL_FDIV_CTL0_PLL_MAIN_DIV_MASK)
/*! @} */

/*! @name VPU_PLL_LOCKD_CTRL - PLL Lock Detector Control Register */
/*! @{ */
#define CCM_ANALOG_VPU_PLL_LOCKD_CTRL_LOCK_CON_IN_MASK  (0x3U)
#define CCM_ANALOG_VPU_PLL_LOCKD_CTRL_LOCK_CON_IN_SHIFT (0U)
#define CCM_ANALOG_VPU_PLL_LOCKD_CTRL_LOCK_CON_IN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VPU_PLL_LOCKD_CTRL_LOCK_CON_IN_SHIFT)) & \
     CCM_ANALOG_VPU_PLL_LOCKD_CTRL_LOCK_CON_IN_MASK)
#define CCM_ANALOG_VPU_PLL_LOCKD_CTRL_LOCK_CON_OUT_MASK  (0xCU)
#define CCM_ANALOG_VPU_PLL_LOCKD_CTRL_LOCK_CON_OUT_SHIFT (2U)
#define CCM_ANALOG_VPU_PLL_LOCKD_CTRL_LOCK_CON_OUT(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VPU_PLL_LOCKD_CTRL_LOCK_CON_OUT_SHIFT)) & \
     CCM_ANALOG_VPU_PLL_LOCKD_CTRL_LOCK_CON_OUT_MASK)
#define CCM_ANALOG_VPU_PLL_LOCKD_CTRL_LOCK_CON_DLY_MASK  (0x30U)
#define CCM_ANALOG_VPU_PLL_LOCKD_CTRL_LOCK_CON_DLY_SHIFT (4U)
#define CCM_ANALOG_VPU_PLL_LOCKD_CTRL_LOCK_CON_DLY(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VPU_PLL_LOCKD_CTRL_LOCK_CON_DLY_SHIFT)) & \
     CCM_ANALOG_VPU_PLL_LOCKD_CTRL_LOCK_CON_DLY_MASK)
/*! @} */

/*! @name VPU_PLL_MNIT_CTRL - PLL Monitoring Control Register */
/*! @{ */
#define CCM_ANALOG_VPU_PLL_MNIT_CTRL_ICP_MASK  (0x3U)
#define CCM_ANALOG_VPU_PLL_MNIT_CTRL_ICP_SHIFT (0U)
#define CCM_ANALOG_VPU_PLL_MNIT_CTRL_ICP(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VPU_PLL_MNIT_CTRL_ICP_SHIFT)) & CCM_ANALOG_VPU_PLL_MNIT_CTRL_ICP_MASK)
#define CCM_ANALOG_VPU_PLL_MNIT_CTRL_AFC_EN_MASK  (0x4U)
#define CCM_ANALOG_VPU_PLL_MNIT_CTRL_AFC_EN_SHIFT (2U)
#define CCM_ANALOG_VPU_PLL_MNIT_CTRL_AFC_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VPU_PLL_MNIT_CTRL_AFC_EN_SHIFT)) & \
     CCM_ANALOG_VPU_PLL_MNIT_CTRL_AFC_EN_MASK)
#define CCM_ANALOG_VPU_PLL_MNIT_CTRL_EXTAFC_MASK  (0xF8U)
#define CCM_ANALOG_VPU_PLL_MNIT_CTRL_EXTAFC_SHIFT (3U)
#define CCM_ANALOG_VPU_PLL_MNIT_CTRL_EXTAFC(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VPU_PLL_MNIT_CTRL_EXTAFC_SHIFT)) & \
     CCM_ANALOG_VPU_PLL_MNIT_CTRL_EXTAFC_MASK)
#define CCM_ANALOG_VPU_PLL_MNIT_CTRL_FEED_EN_MASK  (0x2000U)
#define CCM_ANALOG_VPU_PLL_MNIT_CTRL_FEED_EN_SHIFT (13U)
#define CCM_ANALOG_VPU_PLL_MNIT_CTRL_FEED_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VPU_PLL_MNIT_CTRL_FEED_EN_SHIFT)) & \
     CCM_ANALOG_VPU_PLL_MNIT_CTRL_FEED_EN_MASK)
#define CCM_ANALOG_VPU_PLL_MNIT_CTRL_FSEL_MASK  (0x4000U)
#define CCM_ANALOG_VPU_PLL_MNIT_CTRL_FSEL_SHIFT (14U)
/*! FSEL
 *  0b0..FEED_OUT = FREF
 *  0b1..FEED_OUT = FEED
 */
#define CCM_ANALOG_VPU_PLL_MNIT_CTRL_FSEL(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VPU_PLL_MNIT_CTRL_FSEL_SHIFT)) & CCM_ANALOG_VPU_PLL_MNIT_CTRL_FSEL_MASK)
#define CCM_ANALOG_VPU_PLL_MNIT_CTRL_AFCINIT_SEL_MASK  (0x10000U)
#define CCM_ANALOG_VPU_PLL_MNIT_CTRL_AFCINIT_SEL_SHIFT (16U)
/*! AFCINIT_SEL
 *  0b0..nominal delay
 *  0b1..nominal delay * 2
 */
#define CCM_ANALOG_VPU_PLL_MNIT_CTRL_AFCINIT_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VPU_PLL_MNIT_CTRL_AFCINIT_SEL_SHIFT)) & \
     CCM_ANALOG_VPU_PLL_MNIT_CTRL_AFCINIT_SEL_MASK)
#define CCM_ANALOG_VPU_PLL_MNIT_CTRL_PBIAS_CTRL_EN_MASK  (0x20000U)
#define CCM_ANALOG_VPU_PLL_MNIT_CTRL_PBIAS_CTRL_EN_SHIFT (17U)
#define CCM_ANALOG_VPU_PLL_MNIT_CTRL_PBIAS_CTRL_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VPU_PLL_MNIT_CTRL_PBIAS_CTRL_EN_SHIFT)) & \
     CCM_ANALOG_VPU_PLL_MNIT_CTRL_PBIAS_CTRL_EN_MASK)
#define CCM_ANALOG_VPU_PLL_MNIT_CTRL_PBIAS_CTRL_MASK  (0x40000U)
#define CCM_ANALOG_VPU_PLL_MNIT_CTRL_PBIAS_CTRL_SHIFT (18U)
/*! PBIAS_CTRL
 *  0b0..0.50*VDD
 *  0b1..0.67*VDD
 */
#define CCM_ANALOG_VPU_PLL_MNIT_CTRL_PBIAS_CTRL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VPU_PLL_MNIT_CTRL_PBIAS_CTRL_SHIFT)) & \
     CCM_ANALOG_VPU_PLL_MNIT_CTRL_PBIAS_CTRL_MASK)
#define CCM_ANALOG_VPU_PLL_MNIT_CTRL_AFC_SEL_MASK  (0x80000U)
#define CCM_ANALOG_VPU_PLL_MNIT_CTRL_AFC_SEL_SHIFT (19U)
#define CCM_ANALOG_VPU_PLL_MNIT_CTRL_AFC_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VPU_PLL_MNIT_CTRL_AFC_SEL_SHIFT)) & \
     CCM_ANALOG_VPU_PLL_MNIT_CTRL_AFC_SEL_MASK)
#define CCM_ANALOG_VPU_PLL_MNIT_CTRL_FOUT_MASK_MASK  (0x100000U)
#define CCM_ANALOG_VPU_PLL_MNIT_CTRL_FOUT_MASK_SHIFT (20U)
#define CCM_ANALOG_VPU_PLL_MNIT_CTRL_FOUT_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VPU_PLL_MNIT_CTRL_FOUT_MASK_SHIFT)) & \
     CCM_ANALOG_VPU_PLL_MNIT_CTRL_FOUT_MASK_MASK)
#define CCM_ANALOG_VPU_PLL_MNIT_CTRL_LRD_EN_MASK  (0x200000U)
#define CCM_ANALOG_VPU_PLL_MNIT_CTRL_LRD_EN_SHIFT (21U)
#define CCM_ANALOG_VPU_PLL_MNIT_CTRL_LRD_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_VPU_PLL_MNIT_CTRL_LRD_EN_SHIFT)) & \
     CCM_ANALOG_VPU_PLL_MNIT_CTRL_LRD_EN_MASK)
/*! @} */

/*! @name ARM_PLL_GEN_CTRL - ARM PLL General Function Control Register */
/*! @{ */
#define CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_REF_CLK_SEL_MASK  (0x3U)
#define CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_REF_CLK_SEL_SHIFT (0U)
/*! PLL_REF_CLK_SEL
 *  0b00..24M_REF_CLK
 *  0b01..PAD_CLK
 *  0b10..Reserved
 *  0b11..Reserved
 */
#define CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_REF_CLK_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_REF_CLK_SEL_SHIFT)) & \
     CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_REF_CLK_SEL_MASK)
#define CCM_ANALOG_ARM_PLL_GEN_CTRL_PAD_CLK_SEL_MASK  (0xCU)
#define CCM_ANALOG_ARM_PLL_GEN_CTRL_PAD_CLK_SEL_SHIFT (2U)
/*! PAD_CLK_SEL
 *  0b00..CLKIN1 XOR CLKIN2
 *  0b01..CLKIN2
 *  0b10..CLKIN1
 *  0b11..Reserved
 */
#define CCM_ANALOG_ARM_PLL_GEN_CTRL_PAD_CLK_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_ARM_PLL_GEN_CTRL_PAD_CLK_SEL_SHIFT)) & \
     CCM_ANALOG_ARM_PLL_GEN_CTRL_PAD_CLK_SEL_MASK)
#define CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_BYPASS_MASK  (0x10U)
#define CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_BYPASS_SHIFT (4U)
#define CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_BYPASS(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_BYPASS_SHIFT)) & \
     CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_BYPASS_MASK)
#define CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_RST_OVERRIDE_MASK  (0x100U)
#define CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_RST_OVERRIDE_SHIFT (8U)
#define CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_RST_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_RST_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_RST_OVERRIDE_MASK)
#define CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_RST_MASK  (0x200U)
#define CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_RST_SHIFT (9U)
#define CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_RST(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_RST_SHIFT)) & \
     CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_RST_MASK)
#define CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_CLKE_OVERRIDE_MASK  (0x400U)
#define CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_CLKE_OVERRIDE_SHIFT (10U)
#define CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_CLKE_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_CLKE_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_CLKE_OVERRIDE_MASK)
#define CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_CLKE_MASK  (0x800U)
#define CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_CLKE_SHIFT (11U)
#define CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_CLKE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_CLKE_SHIFT)) & \
     CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_CLKE_MASK)
#define CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_EXT_BYPASS_MASK  (0x10000000U)
#define CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_EXT_BYPASS_SHIFT (28U)
#define CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_EXT_BYPASS(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_EXT_BYPASS_SHIFT)) & \
     CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_EXT_BYPASS_MASK)
#define CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_LOCK_SEL_MASK  (0x20000000U)
#define CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_LOCK_SEL_SHIFT (29U)
/*! PLL_LOCK_SEL
 *  0b0..Using PLL maximum lock time
 *  0b1..Using PLL output lock
 */
#define CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_LOCK_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_LOCK_SEL_SHIFT)) & \
     CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_LOCK_SEL_MASK)
#define CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_LOCK_MASK  (0x80000000U)
#define CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_LOCK_SHIFT (31U)
#define CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_LOCK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_LOCK_SHIFT)) & \
     CCM_ANALOG_ARM_PLL_GEN_CTRL_PLL_LOCK_MASK)
/*! @} */

/*! @name ARM_PLL_FDIV_CTL0 - ARM PLL Divide and Fraction Data Control 0 Register */
/*! @{ */
#define CCM_ANALOG_ARM_PLL_FDIV_CTL0_PLL_POST_DIV_MASK  (0x7U)
#define CCM_ANALOG_ARM_PLL_FDIV_CTL0_PLL_POST_DIV_SHIFT (0U)
#define CCM_ANALOG_ARM_PLL_FDIV_CTL0_PLL_POST_DIV(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_ARM_PLL_FDIV_CTL0_PLL_POST_DIV_SHIFT)) & \
     CCM_ANALOG_ARM_PLL_FDIV_CTL0_PLL_POST_DIV_MASK)
#define CCM_ANALOG_ARM_PLL_FDIV_CTL0_PLL_PRE_DIV_MASK  (0x3F0U)
#define CCM_ANALOG_ARM_PLL_FDIV_CTL0_PLL_PRE_DIV_SHIFT (4U)
#define CCM_ANALOG_ARM_PLL_FDIV_CTL0_PLL_PRE_DIV(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_ARM_PLL_FDIV_CTL0_PLL_PRE_DIV_SHIFT)) & \
     CCM_ANALOG_ARM_PLL_FDIV_CTL0_PLL_PRE_DIV_MASK)
#define CCM_ANALOG_ARM_PLL_FDIV_CTL0_PLL_MAIN_DIV_MASK  (0x3FF000U)
#define CCM_ANALOG_ARM_PLL_FDIV_CTL0_PLL_MAIN_DIV_SHIFT (12U)
#define CCM_ANALOG_ARM_PLL_FDIV_CTL0_PLL_MAIN_DIV(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_ARM_PLL_FDIV_CTL0_PLL_MAIN_DIV_SHIFT)) & \
     CCM_ANALOG_ARM_PLL_FDIV_CTL0_PLL_MAIN_DIV_MASK)
/*! @} */

/*! @name ARM_PLL_LOCKD_CTRL - PLL Lock Detector Control Register */
/*! @{ */
#define CCM_ANALOG_ARM_PLL_LOCKD_CTRL_LOCK_CON_IN_MASK  (0x3U)
#define CCM_ANALOG_ARM_PLL_LOCKD_CTRL_LOCK_CON_IN_SHIFT (0U)
#define CCM_ANALOG_ARM_PLL_LOCKD_CTRL_LOCK_CON_IN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_ARM_PLL_LOCKD_CTRL_LOCK_CON_IN_SHIFT)) & \
     CCM_ANALOG_ARM_PLL_LOCKD_CTRL_LOCK_CON_IN_MASK)
#define CCM_ANALOG_ARM_PLL_LOCKD_CTRL_LOCK_CON_OUT_MASK  (0xCU)
#define CCM_ANALOG_ARM_PLL_LOCKD_CTRL_LOCK_CON_OUT_SHIFT (2U)
#define CCM_ANALOG_ARM_PLL_LOCKD_CTRL_LOCK_CON_OUT(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_ARM_PLL_LOCKD_CTRL_LOCK_CON_OUT_SHIFT)) & \
     CCM_ANALOG_ARM_PLL_LOCKD_CTRL_LOCK_CON_OUT_MASK)
#define CCM_ANALOG_ARM_PLL_LOCKD_CTRL_LOCK_CON_DLY_MASK  (0x30U)
#define CCM_ANALOG_ARM_PLL_LOCKD_CTRL_LOCK_CON_DLY_SHIFT (4U)
#define CCM_ANALOG_ARM_PLL_LOCKD_CTRL_LOCK_CON_DLY(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_ARM_PLL_LOCKD_CTRL_LOCK_CON_DLY_SHIFT)) & \
     CCM_ANALOG_ARM_PLL_LOCKD_CTRL_LOCK_CON_DLY_MASK)
/*! @} */

/*! @name ARM_PLL_MNIT_CTRL - PLL Monitoring Control Register */
/*! @{ */
#define CCM_ANALOG_ARM_PLL_MNIT_CTRL_ICP_MASK  (0x3U)
#define CCM_ANALOG_ARM_PLL_MNIT_CTRL_ICP_SHIFT (0U)
#define CCM_ANALOG_ARM_PLL_MNIT_CTRL_ICP(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_ARM_PLL_MNIT_CTRL_ICP_SHIFT)) & CCM_ANALOG_ARM_PLL_MNIT_CTRL_ICP_MASK)
#define CCM_ANALOG_ARM_PLL_MNIT_CTRL_AFC_EN_MASK  (0x4U)
#define CCM_ANALOG_ARM_PLL_MNIT_CTRL_AFC_EN_SHIFT (2U)
#define CCM_ANALOG_ARM_PLL_MNIT_CTRL_AFC_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_ARM_PLL_MNIT_CTRL_AFC_EN_SHIFT)) & \
     CCM_ANALOG_ARM_PLL_MNIT_CTRL_AFC_EN_MASK)
#define CCM_ANALOG_ARM_PLL_MNIT_CTRL_EXTAFC_MASK  (0xF8U)
#define CCM_ANALOG_ARM_PLL_MNIT_CTRL_EXTAFC_SHIFT (3U)
#define CCM_ANALOG_ARM_PLL_MNIT_CTRL_EXTAFC(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_ARM_PLL_MNIT_CTRL_EXTAFC_SHIFT)) & \
     CCM_ANALOG_ARM_PLL_MNIT_CTRL_EXTAFC_MASK)
#define CCM_ANALOG_ARM_PLL_MNIT_CTRL_FEED_EN_MASK  (0x2000U)
#define CCM_ANALOG_ARM_PLL_MNIT_CTRL_FEED_EN_SHIFT (13U)
#define CCM_ANALOG_ARM_PLL_MNIT_CTRL_FEED_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_ARM_PLL_MNIT_CTRL_FEED_EN_SHIFT)) & \
     CCM_ANALOG_ARM_PLL_MNIT_CTRL_FEED_EN_MASK)
#define CCM_ANALOG_ARM_PLL_MNIT_CTRL_FSEL_MASK  (0x4000U)
#define CCM_ANALOG_ARM_PLL_MNIT_CTRL_FSEL_SHIFT (14U)
/*! FSEL
 *  0b0..FEED_OUT = FREF
 *  0b1..FEED_OUT = FEED
 */
#define CCM_ANALOG_ARM_PLL_MNIT_CTRL_FSEL(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_ARM_PLL_MNIT_CTRL_FSEL_SHIFT)) & CCM_ANALOG_ARM_PLL_MNIT_CTRL_FSEL_MASK)
#define CCM_ANALOG_ARM_PLL_MNIT_CTRL_AFCINIT_SEL_MASK  (0x10000U)
#define CCM_ANALOG_ARM_PLL_MNIT_CTRL_AFCINIT_SEL_SHIFT (16U)
/*! AFCINIT_SEL
 *  0b0..nominal delay
 *  0b1..nominal delay * 2
 */
#define CCM_ANALOG_ARM_PLL_MNIT_CTRL_AFCINIT_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_ARM_PLL_MNIT_CTRL_AFCINIT_SEL_SHIFT)) & \
     CCM_ANALOG_ARM_PLL_MNIT_CTRL_AFCINIT_SEL_MASK)
#define CCM_ANALOG_ARM_PLL_MNIT_CTRL_PBIAS_CTRL_EN_MASK  (0x20000U)
#define CCM_ANALOG_ARM_PLL_MNIT_CTRL_PBIAS_CTRL_EN_SHIFT (17U)
#define CCM_ANALOG_ARM_PLL_MNIT_CTRL_PBIAS_CTRL_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_ARM_PLL_MNIT_CTRL_PBIAS_CTRL_EN_SHIFT)) & \
     CCM_ANALOG_ARM_PLL_MNIT_CTRL_PBIAS_CTRL_EN_MASK)
#define CCM_ANALOG_ARM_PLL_MNIT_CTRL_PBIAS_CTRL_MASK  (0x40000U)
#define CCM_ANALOG_ARM_PLL_MNIT_CTRL_PBIAS_CTRL_SHIFT (18U)
/*! PBIAS_CTRL
 *  0b0..0.50*VDD
 *  0b1..0.67*VDD
 */
#define CCM_ANALOG_ARM_PLL_MNIT_CTRL_PBIAS_CTRL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_ARM_PLL_MNIT_CTRL_PBIAS_CTRL_SHIFT)) & \
     CCM_ANALOG_ARM_PLL_MNIT_CTRL_PBIAS_CTRL_MASK)
#define CCM_ANALOG_ARM_PLL_MNIT_CTRL_AFC_SEL_MASK  (0x80000U)
#define CCM_ANALOG_ARM_PLL_MNIT_CTRL_AFC_SEL_SHIFT (19U)
#define CCM_ANALOG_ARM_PLL_MNIT_CTRL_AFC_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_ARM_PLL_MNIT_CTRL_AFC_SEL_SHIFT)) & \
     CCM_ANALOG_ARM_PLL_MNIT_CTRL_AFC_SEL_MASK)
#define CCM_ANALOG_ARM_PLL_MNIT_CTRL_FOUT_MASK_MASK  (0x100000U)
#define CCM_ANALOG_ARM_PLL_MNIT_CTRL_FOUT_MASK_SHIFT (20U)
#define CCM_ANALOG_ARM_PLL_MNIT_CTRL_FOUT_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_ARM_PLL_MNIT_CTRL_FOUT_MASK_SHIFT)) & \
     CCM_ANALOG_ARM_PLL_MNIT_CTRL_FOUT_MASK_MASK)
#define CCM_ANALOG_ARM_PLL_MNIT_CTRL_LRD_EN_MASK  (0x200000U)
#define CCM_ANALOG_ARM_PLL_MNIT_CTRL_LRD_EN_SHIFT (21U)
#define CCM_ANALOG_ARM_PLL_MNIT_CTRL_LRD_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_ARM_PLL_MNIT_CTRL_LRD_EN_SHIFT)) & \
     CCM_ANALOG_ARM_PLL_MNIT_CTRL_LRD_EN_MASK)
/*! @} */

/*! @name SYS_PLL1_GEN_CTRL - SYS PLL1 General Function Control Register */
/*! @{ */
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_REF_CLK_SEL_MASK  (0x3U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_REF_CLK_SEL_SHIFT (0U)
/*! PLL_REF_CLK_SEL
 *  0b00..24M_REF_CLK
 *  0b01..PAD_CLK
 *  0b10..Reserved
 *  0b11..Reserved
 */
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_REF_CLK_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_REF_CLK_SEL_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_REF_CLK_SEL_MASK)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PAD_CLK_SEL_MASK  (0xCU)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PAD_CLK_SEL_SHIFT (2U)
/*! PAD_CLK_SEL
 *  0b00..CLKIN1 XOR CLKIN2
 *  0b01..CLKIN2
 *  0b10..CLKIN1
 *  0b11..Reserved
 */
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PAD_CLK_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_GEN_CTRL_PAD_CLK_SEL_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_GEN_CTRL_PAD_CLK_SEL_MASK)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_BYPASS_MASK  (0x10U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_BYPASS_SHIFT (4U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_BYPASS(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_BYPASS_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_BYPASS_MASK)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_RST_OVERRIDE_MASK  (0x100U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_RST_OVERRIDE_SHIFT (8U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_RST_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_RST_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_RST_OVERRIDE_MASK)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_RST_MASK  (0x200U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_RST_SHIFT (9U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_RST(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_RST_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_RST_MASK)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_CLKE_OVERRIDE_MASK  (0x400U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_CLKE_OVERRIDE_SHIFT (10U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_CLKE_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_CLKE_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_CLKE_OVERRIDE_MASK)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_CLKE_MASK  (0x800U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_CLKE_SHIFT (11U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_CLKE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_CLKE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_CLKE_MASK)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV2_CLKE_OVERRIDE_MASK  (0x1000U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV2_CLKE_OVERRIDE_SHIFT (12U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV2_CLKE_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV2_CLKE_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV2_CLKE_OVERRIDE_MASK)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV2_CLKE_MASK  (0x2000U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV2_CLKE_SHIFT (13U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV2_CLKE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV2_CLKE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV2_CLKE_MASK)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV3_CLKE_OVERRIDE_MASK  (0x4000U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV3_CLKE_OVERRIDE_SHIFT (14U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV3_CLKE_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV3_CLKE_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV3_CLKE_OVERRIDE_MASK)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV3_CLKE_MASK  (0x8000U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV3_CLKE_SHIFT (15U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV3_CLKE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV3_CLKE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV3_CLKE_MASK)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV4_CLKE_OVERRIDE_MASK  (0x10000U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV4_CLKE_OVERRIDE_SHIFT (16U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV4_CLKE_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV4_CLKE_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV4_CLKE_OVERRIDE_MASK)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV4_CLKE_MASK  (0x20000U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV4_CLKE_SHIFT (17U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV4_CLKE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV4_CLKE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV4_CLKE_MASK)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV5_CLKE_OVERRIDE_MASK  (0x40000U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV5_CLKE_OVERRIDE_SHIFT (18U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV5_CLKE_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV5_CLKE_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV5_CLKE_OVERRIDE_MASK)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV5_CLKE_MASK  (0x80000U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV5_CLKE_SHIFT (19U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV5_CLKE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV5_CLKE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV5_CLKE_MASK)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV6_CLKE_OVERRIDE_MASK  (0x100000U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV6_CLKE_OVERRIDE_SHIFT (20U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV6_CLKE_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV6_CLKE_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV6_CLKE_OVERRIDE_MASK)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV6_CLKE_MASK  (0x200000U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV6_CLKE_SHIFT (21U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV6_CLKE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV6_CLKE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV6_CLKE_MASK)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV8_CLKE_OVERRIDE_MASK  (0x400000U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV8_CLKE_OVERRIDE_SHIFT (22U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV8_CLKE_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV8_CLKE_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV8_CLKE_OVERRIDE_MASK)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV8_CLKE_MASK  (0x800000U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV8_CLKE_SHIFT (23U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV8_CLKE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV8_CLKE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV8_CLKE_MASK)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV10_CLKE_OVERRIDE_MASK  (0x1000000U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV10_CLKE_OVERRIDE_SHIFT (24U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV10_CLKE_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV10_CLKE_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV10_CLKE_OVERRIDE_MASK)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV10_CLKE_MASK  (0x2000000U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV10_CLKE_SHIFT (25U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV10_CLKE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV10_CLKE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV10_CLKE_MASK)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV20_CLKE_OVERRIDE_MASK  (0x4000000U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV20_CLKE_OVERRIDE_SHIFT (26U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV20_CLKE_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV20_CLKE_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV20_CLKE_OVERRIDE_MASK)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV20_CLKE_MASK  (0x8000000U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV20_CLKE_SHIFT (27U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV20_CLKE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV20_CLKE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_DIV20_CLKE_MASK)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_EXT_BYPASS_MASK  (0x10000000U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_EXT_BYPASS_SHIFT (28U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_EXT_BYPASS(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_EXT_BYPASS_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_EXT_BYPASS_MASK)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_LOCK_SEL_MASK  (0x20000000U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_LOCK_SEL_SHIFT (29U)
/*! PLL_LOCK_SEL
 *  0b0..Using PLL maximum lock time
 *  0b1..Using PLL output lock
 */
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_LOCK_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_LOCK_SEL_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_LOCK_SEL_MASK)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_LOCK_MASK  (0x80000000U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_LOCK_SHIFT (31U)
#define CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_LOCK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_LOCK_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_GEN_CTRL_PLL_LOCK_MASK)
/*! @} */

/*! @name SYS_PLL1_FDIV_CTL0 - SYS PLL1 Divide and Fraction Data Control 0 Register */
/*! @{ */
#define CCM_ANALOG_SYS_PLL1_FDIV_CTL0_PLL_POST_DIV_MASK  (0x7U)
#define CCM_ANALOG_SYS_PLL1_FDIV_CTL0_PLL_POST_DIV_SHIFT (0U)
#define CCM_ANALOG_SYS_PLL1_FDIV_CTL0_PLL_POST_DIV(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_FDIV_CTL0_PLL_POST_DIV_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_FDIV_CTL0_PLL_POST_DIV_MASK)
#define CCM_ANALOG_SYS_PLL1_FDIV_CTL0_PLL_PRE_DIV_MASK  (0x3F0U)
#define CCM_ANALOG_SYS_PLL1_FDIV_CTL0_PLL_PRE_DIV_SHIFT (4U)
#define CCM_ANALOG_SYS_PLL1_FDIV_CTL0_PLL_PRE_DIV(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_FDIV_CTL0_PLL_PRE_DIV_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_FDIV_CTL0_PLL_PRE_DIV_MASK)
#define CCM_ANALOG_SYS_PLL1_FDIV_CTL0_PLL_MAIN_DIV_MASK  (0x3FF000U)
#define CCM_ANALOG_SYS_PLL1_FDIV_CTL0_PLL_MAIN_DIV_SHIFT (12U)
#define CCM_ANALOG_SYS_PLL1_FDIV_CTL0_PLL_MAIN_DIV(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_FDIV_CTL0_PLL_MAIN_DIV_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_FDIV_CTL0_PLL_MAIN_DIV_MASK)
/*! @} */

/*! @name SYS_PLL1_LOCKD_CTRL - PLL Lock Detector Control Register */
/*! @{ */
#define CCM_ANALOG_SYS_PLL1_LOCKD_CTRL_LOCK_CON_IN_MASK  (0x3U)
#define CCM_ANALOG_SYS_PLL1_LOCKD_CTRL_LOCK_CON_IN_SHIFT (0U)
#define CCM_ANALOG_SYS_PLL1_LOCKD_CTRL_LOCK_CON_IN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_LOCKD_CTRL_LOCK_CON_IN_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_LOCKD_CTRL_LOCK_CON_IN_MASK)
#define CCM_ANALOG_SYS_PLL1_LOCKD_CTRL_LOCK_CON_OUT_MASK  (0xCU)
#define CCM_ANALOG_SYS_PLL1_LOCKD_CTRL_LOCK_CON_OUT_SHIFT (2U)
#define CCM_ANALOG_SYS_PLL1_LOCKD_CTRL_LOCK_CON_OUT(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_LOCKD_CTRL_LOCK_CON_OUT_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_LOCKD_CTRL_LOCK_CON_OUT_MASK)
#define CCM_ANALOG_SYS_PLL1_LOCKD_CTRL_LOCK_CON_DLY_MASK  (0x30U)
#define CCM_ANALOG_SYS_PLL1_LOCKD_CTRL_LOCK_CON_DLY_SHIFT (4U)
#define CCM_ANALOG_SYS_PLL1_LOCKD_CTRL_LOCK_CON_DLY(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_LOCKD_CTRL_LOCK_CON_DLY_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_LOCKD_CTRL_LOCK_CON_DLY_MASK)
/*! @} */

/*! @name SYS_PLL1_MNIT_CTRL - PLL Monitoring Control Register */
/*! @{ */
#define CCM_ANALOG_SYS_PLL1_MNIT_CTRL_ICP_MASK  (0x3U)
#define CCM_ANALOG_SYS_PLL1_MNIT_CTRL_ICP_SHIFT (0U)
#define CCM_ANALOG_SYS_PLL1_MNIT_CTRL_ICP(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_MNIT_CTRL_ICP_SHIFT)) & CCM_ANALOG_SYS_PLL1_MNIT_CTRL_ICP_MASK)
#define CCM_ANALOG_SYS_PLL1_MNIT_CTRL_AFC_EN_MASK  (0x4U)
#define CCM_ANALOG_SYS_PLL1_MNIT_CTRL_AFC_EN_SHIFT (2U)
#define CCM_ANALOG_SYS_PLL1_MNIT_CTRL_AFC_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_MNIT_CTRL_AFC_EN_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_MNIT_CTRL_AFC_EN_MASK)
#define CCM_ANALOG_SYS_PLL1_MNIT_CTRL_EXTAFC_MASK  (0xF8U)
#define CCM_ANALOG_SYS_PLL1_MNIT_CTRL_EXTAFC_SHIFT (3U)
#define CCM_ANALOG_SYS_PLL1_MNIT_CTRL_EXTAFC(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_MNIT_CTRL_EXTAFC_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_MNIT_CTRL_EXTAFC_MASK)
#define CCM_ANALOG_SYS_PLL1_MNIT_CTRL_FEED_EN_MASK  (0x2000U)
#define CCM_ANALOG_SYS_PLL1_MNIT_CTRL_FEED_EN_SHIFT (13U)
#define CCM_ANALOG_SYS_PLL1_MNIT_CTRL_FEED_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_MNIT_CTRL_FEED_EN_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_MNIT_CTRL_FEED_EN_MASK)
#define CCM_ANALOG_SYS_PLL1_MNIT_CTRL_FSEL_MASK  (0x4000U)
#define CCM_ANALOG_SYS_PLL1_MNIT_CTRL_FSEL_SHIFT (14U)
/*! FSEL
 *  0b0..FEED_OUT = FREF
 *  0b1..FEED_OUT = FEED
 */
#define CCM_ANALOG_SYS_PLL1_MNIT_CTRL_FSEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_MNIT_CTRL_FSEL_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_MNIT_CTRL_FSEL_MASK)
#define CCM_ANALOG_SYS_PLL1_MNIT_CTRL_AFCINIT_SEL_MASK  (0x10000U)
#define CCM_ANALOG_SYS_PLL1_MNIT_CTRL_AFCINIT_SEL_SHIFT (16U)
/*! AFCINIT_SEL
 *  0b0..nominal delay
 *  0b1..nominal delay * 2
 */
#define CCM_ANALOG_SYS_PLL1_MNIT_CTRL_AFCINIT_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_MNIT_CTRL_AFCINIT_SEL_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_MNIT_CTRL_AFCINIT_SEL_MASK)
#define CCM_ANALOG_SYS_PLL1_MNIT_CTRL_PBIAS_CTRL_EN_MASK  (0x20000U)
#define CCM_ANALOG_SYS_PLL1_MNIT_CTRL_PBIAS_CTRL_EN_SHIFT (17U)
#define CCM_ANALOG_SYS_PLL1_MNIT_CTRL_PBIAS_CTRL_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_MNIT_CTRL_PBIAS_CTRL_EN_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_MNIT_CTRL_PBIAS_CTRL_EN_MASK)
#define CCM_ANALOG_SYS_PLL1_MNIT_CTRL_PBIAS_CTRL_MASK  (0x40000U)
#define CCM_ANALOG_SYS_PLL1_MNIT_CTRL_PBIAS_CTRL_SHIFT (18U)
/*! PBIAS_CTRL
 *  0b0..0.50*VDD
 *  0b1..0.67*VDD
 */
#define CCM_ANALOG_SYS_PLL1_MNIT_CTRL_PBIAS_CTRL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_MNIT_CTRL_PBIAS_CTRL_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_MNIT_CTRL_PBIAS_CTRL_MASK)
#define CCM_ANALOG_SYS_PLL1_MNIT_CTRL_AFC_SEL_MASK  (0x80000U)
#define CCM_ANALOG_SYS_PLL1_MNIT_CTRL_AFC_SEL_SHIFT (19U)
#define CCM_ANALOG_SYS_PLL1_MNIT_CTRL_AFC_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_MNIT_CTRL_AFC_SEL_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_MNIT_CTRL_AFC_SEL_MASK)
#define CCM_ANALOG_SYS_PLL1_MNIT_CTRL_FOUT_MASK_MASK  (0x100000U)
#define CCM_ANALOG_SYS_PLL1_MNIT_CTRL_FOUT_MASK_SHIFT (20U)
#define CCM_ANALOG_SYS_PLL1_MNIT_CTRL_FOUT_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_MNIT_CTRL_FOUT_MASK_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_MNIT_CTRL_FOUT_MASK_MASK)
#define CCM_ANALOG_SYS_PLL1_MNIT_CTRL_LRD_EN_MASK  (0x200000U)
#define CCM_ANALOG_SYS_PLL1_MNIT_CTRL_LRD_EN_SHIFT (21U)
#define CCM_ANALOG_SYS_PLL1_MNIT_CTRL_LRD_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL1_MNIT_CTRL_LRD_EN_SHIFT)) & \
     CCM_ANALOG_SYS_PLL1_MNIT_CTRL_LRD_EN_MASK)
/*! @} */

/*! @name SYS_PLL2_GEN_CTRL - SYS PLL2 General Function Control Register */
/*! @{ */
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_REF_CLK_SEL_MASK  (0x3U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_REF_CLK_SEL_SHIFT (0U)
/*! PLL_REF_CLK_SEL
 *  0b00..24M_REF_CLK
 *  0b01..PAD_CLK
 *  0b10..Reserved
 *  0b11..Reserved
 */
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_REF_CLK_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_REF_CLK_SEL_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_REF_CLK_SEL_MASK)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PAD_CLK_SEL_MASK  (0xCU)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PAD_CLK_SEL_SHIFT (2U)
/*! PAD_CLK_SEL
 *  0b00..CLKIN1 XOR CLKIN2
 *  0b01..CLKIN2
 *  0b10..CLKIN1
 *  0b11..Reserved
 */
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PAD_CLK_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_GEN_CTRL_PAD_CLK_SEL_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_GEN_CTRL_PAD_CLK_SEL_MASK)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_BYPASS_MASK  (0x10U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_BYPASS_SHIFT (4U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_BYPASS(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_BYPASS_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_BYPASS_MASK)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_RST_OVERRIDE_MASK  (0x100U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_RST_OVERRIDE_SHIFT (8U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_RST_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_RST_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_RST_OVERRIDE_MASK)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_RST_MASK  (0x200U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_RST_SHIFT (9U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_RST(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_RST_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_RST_MASK)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_CLKE_OVERRIDE_MASK  (0x400U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_CLKE_OVERRIDE_SHIFT (10U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_CLKE_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_CLKE_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_CLKE_OVERRIDE_MASK)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_CLKE_MASK  (0x800U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_CLKE_SHIFT (11U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_CLKE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_CLKE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_CLKE_MASK)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV2_CLKE_OVERRIDE_MASK  (0x1000U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV2_CLKE_OVERRIDE_SHIFT (12U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV2_CLKE_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV2_CLKE_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV2_CLKE_OVERRIDE_MASK)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV2_CLKE_MASK  (0x2000U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV2_CLKE_SHIFT (13U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV2_CLKE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV2_CLKE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV2_CLKE_MASK)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV3_CLKE_OVERRIDE_MASK  (0x4000U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV3_CLKE_OVERRIDE_SHIFT (14U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV3_CLKE_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV3_CLKE_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV3_CLKE_OVERRIDE_MASK)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV3_CLKE_MASK  (0x8000U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV3_CLKE_SHIFT (15U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV3_CLKE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV3_CLKE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV3_CLKE_MASK)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV4_CLKE_OVERRIDE_MASK  (0x10000U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV4_CLKE_OVERRIDE_SHIFT (16U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV4_CLKE_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV4_CLKE_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV4_CLKE_OVERRIDE_MASK)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV4_CLKE_MASK  (0x20000U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV4_CLKE_SHIFT (17U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV4_CLKE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV4_CLKE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV4_CLKE_MASK)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV5_CLKE_OVERRIDE_MASK  (0x40000U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV5_CLKE_OVERRIDE_SHIFT (18U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV5_CLKE_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV5_CLKE_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV5_CLKE_OVERRIDE_MASK)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV5_CLKE_MASK  (0x80000U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV5_CLKE_SHIFT (19U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV5_CLKE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV5_CLKE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV5_CLKE_MASK)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV6_CLKE_OVERRIDE_MASK  (0x100000U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV6_CLKE_OVERRIDE_SHIFT (20U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV6_CLKE_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV6_CLKE_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV6_CLKE_OVERRIDE_MASK)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV6_CLKE_MASK  (0x200000U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV6_CLKE_SHIFT (21U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV6_CLKE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV6_CLKE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV6_CLKE_MASK)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV8_CLKE_OVERRIDE_MASK  (0x400000U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV8_CLKE_OVERRIDE_SHIFT (22U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV8_CLKE_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV8_CLKE_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV8_CLKE_OVERRIDE_MASK)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV8_CLKE_MASK  (0x800000U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV8_CLKE_SHIFT (23U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV8_CLKE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV8_CLKE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV8_CLKE_MASK)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV10_CLKE_OVERRIDE_MASK  (0x1000000U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV10_CLKE_OVERRIDE_SHIFT (24U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV10_CLKE_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV10_CLKE_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV10_CLKE_OVERRIDE_MASK)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV10_CLKE_MASK  (0x2000000U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV10_CLKE_SHIFT (25U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV10_CLKE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV10_CLKE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV10_CLKE_MASK)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV20_CLKE_OVERRIDE_MASK  (0x4000000U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV20_CLKE_OVERRIDE_SHIFT (26U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV20_CLKE_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV20_CLKE_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV20_CLKE_OVERRIDE_MASK)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV20_CLKE_MASK  (0x8000000U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV20_CLKE_SHIFT (27U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV20_CLKE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV20_CLKE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_DIV20_CLKE_MASK)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_EXT_BYPASS_MASK  (0x10000000U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_EXT_BYPASS_SHIFT (28U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_EXT_BYPASS(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_EXT_BYPASS_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_EXT_BYPASS_MASK)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_LOCK_SEL_MASK  (0x20000000U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_LOCK_SEL_SHIFT (29U)
/*! PLL_LOCK_SEL
 *  0b0..Using PLL maximum lock time
 *  0b1..Using PLL output lock
 */
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_LOCK_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_LOCK_SEL_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_LOCK_SEL_MASK)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_LOCK_MASK  (0x80000000U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_LOCK_SHIFT (31U)
#define CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_LOCK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_LOCK_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_GEN_CTRL_PLL_LOCK_MASK)
/*! @} */

/*! @name SYS_PLL2_FDIV_CTL0 - SYS PLL2 Divide and Fraction Data Control 0 Register */
/*! @{ */
#define CCM_ANALOG_SYS_PLL2_FDIV_CTL0_PLL_POST_DIV_MASK  (0x7U)
#define CCM_ANALOG_SYS_PLL2_FDIV_CTL0_PLL_POST_DIV_SHIFT (0U)
#define CCM_ANALOG_SYS_PLL2_FDIV_CTL0_PLL_POST_DIV(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_FDIV_CTL0_PLL_POST_DIV_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_FDIV_CTL0_PLL_POST_DIV_MASK)
#define CCM_ANALOG_SYS_PLL2_FDIV_CTL0_PLL_PRE_DIV_MASK  (0x3F0U)
#define CCM_ANALOG_SYS_PLL2_FDIV_CTL0_PLL_PRE_DIV_SHIFT (4U)
#define CCM_ANALOG_SYS_PLL2_FDIV_CTL0_PLL_PRE_DIV(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_FDIV_CTL0_PLL_PRE_DIV_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_FDIV_CTL0_PLL_PRE_DIV_MASK)
#define CCM_ANALOG_SYS_PLL2_FDIV_CTL0_PLL_MAIN_DIV_MASK  (0x3FF000U)
#define CCM_ANALOG_SYS_PLL2_FDIV_CTL0_PLL_MAIN_DIV_SHIFT (12U)
#define CCM_ANALOG_SYS_PLL2_FDIV_CTL0_PLL_MAIN_DIV(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_FDIV_CTL0_PLL_MAIN_DIV_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_FDIV_CTL0_PLL_MAIN_DIV_MASK)
/*! @} */

/*! @name SYS_PLL2_LOCKD_CTRL - PLL Lock Detector Control Register */
/*! @{ */
#define CCM_ANALOG_SYS_PLL2_LOCKD_CTRL_LOCK_CON_IN_MASK  (0x3U)
#define CCM_ANALOG_SYS_PLL2_LOCKD_CTRL_LOCK_CON_IN_SHIFT (0U)
#define CCM_ANALOG_SYS_PLL2_LOCKD_CTRL_LOCK_CON_IN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_LOCKD_CTRL_LOCK_CON_IN_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_LOCKD_CTRL_LOCK_CON_IN_MASK)
#define CCM_ANALOG_SYS_PLL2_LOCKD_CTRL_LOCK_CON_OUT_MASK  (0xCU)
#define CCM_ANALOG_SYS_PLL2_LOCKD_CTRL_LOCK_CON_OUT_SHIFT (2U)
#define CCM_ANALOG_SYS_PLL2_LOCKD_CTRL_LOCK_CON_OUT(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_LOCKD_CTRL_LOCK_CON_OUT_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_LOCKD_CTRL_LOCK_CON_OUT_MASK)
#define CCM_ANALOG_SYS_PLL2_LOCKD_CTRL_LOCK_CON_DLY_MASK  (0x30U)
#define CCM_ANALOG_SYS_PLL2_LOCKD_CTRL_LOCK_CON_DLY_SHIFT (4U)
#define CCM_ANALOG_SYS_PLL2_LOCKD_CTRL_LOCK_CON_DLY(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_LOCKD_CTRL_LOCK_CON_DLY_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_LOCKD_CTRL_LOCK_CON_DLY_MASK)
/*! @} */

/*! @name SYS_PLL2_MNIT_CTRL - PLL Monitoring Control Register */
/*! @{ */
#define CCM_ANALOG_SYS_PLL2_MNIT_CTRL_ICP_MASK  (0x3U)
#define CCM_ANALOG_SYS_PLL2_MNIT_CTRL_ICP_SHIFT (0U)
#define CCM_ANALOG_SYS_PLL2_MNIT_CTRL_ICP(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_MNIT_CTRL_ICP_SHIFT)) & CCM_ANALOG_SYS_PLL2_MNIT_CTRL_ICP_MASK)
#define CCM_ANALOG_SYS_PLL2_MNIT_CTRL_AFC_EN_MASK  (0x4U)
#define CCM_ANALOG_SYS_PLL2_MNIT_CTRL_AFC_EN_SHIFT (2U)
#define CCM_ANALOG_SYS_PLL2_MNIT_CTRL_AFC_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_MNIT_CTRL_AFC_EN_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_MNIT_CTRL_AFC_EN_MASK)
#define CCM_ANALOG_SYS_PLL2_MNIT_CTRL_EXTAFC_MASK  (0xF8U)
#define CCM_ANALOG_SYS_PLL2_MNIT_CTRL_EXTAFC_SHIFT (3U)
#define CCM_ANALOG_SYS_PLL2_MNIT_CTRL_EXTAFC(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_MNIT_CTRL_EXTAFC_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_MNIT_CTRL_EXTAFC_MASK)
#define CCM_ANALOG_SYS_PLL2_MNIT_CTRL_FEED_EN_MASK  (0x2000U)
#define CCM_ANALOG_SYS_PLL2_MNIT_CTRL_FEED_EN_SHIFT (13U)
#define CCM_ANALOG_SYS_PLL2_MNIT_CTRL_FEED_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_MNIT_CTRL_FEED_EN_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_MNIT_CTRL_FEED_EN_MASK)
#define CCM_ANALOG_SYS_PLL2_MNIT_CTRL_FSEL_MASK  (0x4000U)
#define CCM_ANALOG_SYS_PLL2_MNIT_CTRL_FSEL_SHIFT (14U)
/*! FSEL
 *  0b0..FEED_OUT = FREF
 *  0b1..FEED_OUT = FEED
 */
#define CCM_ANALOG_SYS_PLL2_MNIT_CTRL_FSEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_MNIT_CTRL_FSEL_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_MNIT_CTRL_FSEL_MASK)
#define CCM_ANALOG_SYS_PLL2_MNIT_CTRL_AFCINIT_SEL_MASK  (0x10000U)
#define CCM_ANALOG_SYS_PLL2_MNIT_CTRL_AFCINIT_SEL_SHIFT (16U)
/*! AFCINIT_SEL
 *  0b0..nominal delay
 *  0b1..nominal delay * 2
 */
#define CCM_ANALOG_SYS_PLL2_MNIT_CTRL_AFCINIT_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_MNIT_CTRL_AFCINIT_SEL_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_MNIT_CTRL_AFCINIT_SEL_MASK)
#define CCM_ANALOG_SYS_PLL2_MNIT_CTRL_PBIAS_CTRL_EN_MASK  (0x20000U)
#define CCM_ANALOG_SYS_PLL2_MNIT_CTRL_PBIAS_CTRL_EN_SHIFT (17U)
#define CCM_ANALOG_SYS_PLL2_MNIT_CTRL_PBIAS_CTRL_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_MNIT_CTRL_PBIAS_CTRL_EN_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_MNIT_CTRL_PBIAS_CTRL_EN_MASK)
#define CCM_ANALOG_SYS_PLL2_MNIT_CTRL_PBIAS_CTRL_MASK  (0x40000U)
#define CCM_ANALOG_SYS_PLL2_MNIT_CTRL_PBIAS_CTRL_SHIFT (18U)
/*! PBIAS_CTRL
 *  0b0..0.50*VDD
 *  0b1..0.67*VDD
 */
#define CCM_ANALOG_SYS_PLL2_MNIT_CTRL_PBIAS_CTRL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_MNIT_CTRL_PBIAS_CTRL_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_MNIT_CTRL_PBIAS_CTRL_MASK)
#define CCM_ANALOG_SYS_PLL2_MNIT_CTRL_AFC_SEL_MASK  (0x80000U)
#define CCM_ANALOG_SYS_PLL2_MNIT_CTRL_AFC_SEL_SHIFT (19U)
#define CCM_ANALOG_SYS_PLL2_MNIT_CTRL_AFC_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_MNIT_CTRL_AFC_SEL_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_MNIT_CTRL_AFC_SEL_MASK)
#define CCM_ANALOG_SYS_PLL2_MNIT_CTRL_FOUT_MASK_MASK  (0x100000U)
#define CCM_ANALOG_SYS_PLL2_MNIT_CTRL_FOUT_MASK_SHIFT (20U)
#define CCM_ANALOG_SYS_PLL2_MNIT_CTRL_FOUT_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_MNIT_CTRL_FOUT_MASK_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_MNIT_CTRL_FOUT_MASK_MASK)
#define CCM_ANALOG_SYS_PLL2_MNIT_CTRL_LRD_EN_MASK  (0x200000U)
#define CCM_ANALOG_SYS_PLL2_MNIT_CTRL_LRD_EN_SHIFT (21U)
#define CCM_ANALOG_SYS_PLL2_MNIT_CTRL_LRD_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL2_MNIT_CTRL_LRD_EN_SHIFT)) & \
     CCM_ANALOG_SYS_PLL2_MNIT_CTRL_LRD_EN_MASK)
/*! @} */

/*! @name SYS_PLL3_GEN_CTRL - SYS PLL3 General Function Control Register */
/*! @{ */
#define CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_REF_CLK_SEL_MASK  (0x3U)
#define CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_REF_CLK_SEL_SHIFT (0U)
/*! PLL_REF_CLK_SEL
 *  0b00..24M_REF_CLK
 *  0b01..PAD_CLK
 *  0b10..Reserved
 *  0b11..Reserved
 */
#define CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_REF_CLK_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_REF_CLK_SEL_SHIFT)) & \
     CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_REF_CLK_SEL_MASK)
#define CCM_ANALOG_SYS_PLL3_GEN_CTRL_PAD_CLK_SEL_MASK  (0xCU)
#define CCM_ANALOG_SYS_PLL3_GEN_CTRL_PAD_CLK_SEL_SHIFT (2U)
/*! PAD_CLK_SEL
 *  0b00..CLKIN1 XOR CLKIN2
 *  0b01..CLKIN2
 *  0b10..CLKIN1
 *  0b11..Reserved
 */
#define CCM_ANALOG_SYS_PLL3_GEN_CTRL_PAD_CLK_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL3_GEN_CTRL_PAD_CLK_SEL_SHIFT)) & \
     CCM_ANALOG_SYS_PLL3_GEN_CTRL_PAD_CLK_SEL_MASK)
#define CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_BYPASS_MASK  (0x10U)
#define CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_BYPASS_SHIFT (4U)
#define CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_BYPASS(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_BYPASS_SHIFT)) & \
     CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_BYPASS_MASK)
#define CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_RST_OVERRIDE_MASK  (0x100U)
#define CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_RST_OVERRIDE_SHIFT (8U)
#define CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_RST_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_RST_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_RST_OVERRIDE_MASK)
#define CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_RST_MASK  (0x200U)
#define CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_RST_SHIFT (9U)
#define CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_RST(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_RST_SHIFT)) & \
     CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_RST_MASK)
#define CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_CLKE_OVERRIDE_MASK  (0x400U)
#define CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_CLKE_OVERRIDE_SHIFT (10U)
#define CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_CLKE_OVERRIDE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_CLKE_OVERRIDE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_CLKE_OVERRIDE_MASK)
#define CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_CLKE_MASK  (0x800U)
#define CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_CLKE_SHIFT (11U)
#define CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_CLKE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_CLKE_SHIFT)) & \
     CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_CLKE_MASK)
#define CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_EXT_BYPASS_MASK  (0x10000000U)
#define CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_EXT_BYPASS_SHIFT (28U)
#define CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_EXT_BYPASS(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_EXT_BYPASS_SHIFT)) & \
     CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_EXT_BYPASS_MASK)
#define CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_LOCK_SEL_MASK  (0x20000000U)
#define CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_LOCK_SEL_SHIFT (29U)
/*! PLL_LOCK_SEL
 *  0b0..Using PLL maximum lock time
 *  0b1..Using PLL output lock
 */
#define CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_LOCK_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_LOCK_SEL_SHIFT)) & \
     CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_LOCK_SEL_MASK)
#define CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_LOCK_MASK  (0x80000000U)
#define CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_LOCK_SHIFT (31U)
#define CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_LOCK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_LOCK_SHIFT)) & \
     CCM_ANALOG_SYS_PLL3_GEN_CTRL_PLL_LOCK_MASK)
/*! @} */

/*! @name SYS_PLL3_FDIV_CTL0 - SYS PLL3 Divide and Fraction Data Control 0 Register */
/*! @{ */
#define CCM_ANALOG_SYS_PLL3_FDIV_CTL0_PLL_POST_DIV_MASK  (0x7U)
#define CCM_ANALOG_SYS_PLL3_FDIV_CTL0_PLL_POST_DIV_SHIFT (0U)
#define CCM_ANALOG_SYS_PLL3_FDIV_CTL0_PLL_POST_DIV(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL3_FDIV_CTL0_PLL_POST_DIV_SHIFT)) & \
     CCM_ANALOG_SYS_PLL3_FDIV_CTL0_PLL_POST_DIV_MASK)
#define CCM_ANALOG_SYS_PLL3_FDIV_CTL0_PLL_PRE_DIV_MASK  (0x3F0U)
#define CCM_ANALOG_SYS_PLL3_FDIV_CTL0_PLL_PRE_DIV_SHIFT (4U)
#define CCM_ANALOG_SYS_PLL3_FDIV_CTL0_PLL_PRE_DIV(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL3_FDIV_CTL0_PLL_PRE_DIV_SHIFT)) & \
     CCM_ANALOG_SYS_PLL3_FDIV_CTL0_PLL_PRE_DIV_MASK)
#define CCM_ANALOG_SYS_PLL3_FDIV_CTL0_PLL_MAIN_DIV_MASK  (0x3FF000U)
#define CCM_ANALOG_SYS_PLL3_FDIV_CTL0_PLL_MAIN_DIV_SHIFT (12U)
#define CCM_ANALOG_SYS_PLL3_FDIV_CTL0_PLL_MAIN_DIV(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL3_FDIV_CTL0_PLL_MAIN_DIV_SHIFT)) & \
     CCM_ANALOG_SYS_PLL3_FDIV_CTL0_PLL_MAIN_DIV_MASK)
/*! @} */

/*! @name SYS_PLL3_LOCKD_CTRL - PLL Lock Detector Control Register */
/*! @{ */
#define CCM_ANALOG_SYS_PLL3_LOCKD_CTRL_LOCK_CON_IN_MASK  (0x3U)
#define CCM_ANALOG_SYS_PLL3_LOCKD_CTRL_LOCK_CON_IN_SHIFT (0U)
#define CCM_ANALOG_SYS_PLL3_LOCKD_CTRL_LOCK_CON_IN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL3_LOCKD_CTRL_LOCK_CON_IN_SHIFT)) & \
     CCM_ANALOG_SYS_PLL3_LOCKD_CTRL_LOCK_CON_IN_MASK)
#define CCM_ANALOG_SYS_PLL3_LOCKD_CTRL_LOCK_CON_OUT_MASK  (0xCU)
#define CCM_ANALOG_SYS_PLL3_LOCKD_CTRL_LOCK_CON_OUT_SHIFT (2U)
#define CCM_ANALOG_SYS_PLL3_LOCKD_CTRL_LOCK_CON_OUT(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL3_LOCKD_CTRL_LOCK_CON_OUT_SHIFT)) & \
     CCM_ANALOG_SYS_PLL3_LOCKD_CTRL_LOCK_CON_OUT_MASK)
#define CCM_ANALOG_SYS_PLL3_LOCKD_CTRL_LOCK_CON_DLY_MASK  (0x30U)
#define CCM_ANALOG_SYS_PLL3_LOCKD_CTRL_LOCK_CON_DLY_SHIFT (4U)
#define CCM_ANALOG_SYS_PLL3_LOCKD_CTRL_LOCK_CON_DLY(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL3_LOCKD_CTRL_LOCK_CON_DLY_SHIFT)) & \
     CCM_ANALOG_SYS_PLL3_LOCKD_CTRL_LOCK_CON_DLY_MASK)
/*! @} */

/*! @name SYS_PLL3_MNIT_CTRL - PLL Monitoring Control Register */
/*! @{ */
#define CCM_ANALOG_SYS_PLL3_MNIT_CTRL_ICP_MASK  (0x3U)
#define CCM_ANALOG_SYS_PLL3_MNIT_CTRL_ICP_SHIFT (0U)
#define CCM_ANALOG_SYS_PLL3_MNIT_CTRL_ICP(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL3_MNIT_CTRL_ICP_SHIFT)) & CCM_ANALOG_SYS_PLL3_MNIT_CTRL_ICP_MASK)
#define CCM_ANALOG_SYS_PLL3_MNIT_CTRL_AFC_EN_MASK  (0x4U)
#define CCM_ANALOG_SYS_PLL3_MNIT_CTRL_AFC_EN_SHIFT (2U)
#define CCM_ANALOG_SYS_PLL3_MNIT_CTRL_AFC_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL3_MNIT_CTRL_AFC_EN_SHIFT)) & \
     CCM_ANALOG_SYS_PLL3_MNIT_CTRL_AFC_EN_MASK)
#define CCM_ANALOG_SYS_PLL3_MNIT_CTRL_EXTAFC_MASK  (0xF8U)
#define CCM_ANALOG_SYS_PLL3_MNIT_CTRL_EXTAFC_SHIFT (3U)
#define CCM_ANALOG_SYS_PLL3_MNIT_CTRL_EXTAFC(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL3_MNIT_CTRL_EXTAFC_SHIFT)) & \
     CCM_ANALOG_SYS_PLL3_MNIT_CTRL_EXTAFC_MASK)
#define CCM_ANALOG_SYS_PLL3_MNIT_CTRL_FEED_EN_MASK  (0x2000U)
#define CCM_ANALOG_SYS_PLL3_MNIT_CTRL_FEED_EN_SHIFT (13U)
#define CCM_ANALOG_SYS_PLL3_MNIT_CTRL_FEED_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL3_MNIT_CTRL_FEED_EN_SHIFT)) & \
     CCM_ANALOG_SYS_PLL3_MNIT_CTRL_FEED_EN_MASK)
#define CCM_ANALOG_SYS_PLL3_MNIT_CTRL_FSEL_MASK  (0x4000U)
#define CCM_ANALOG_SYS_PLL3_MNIT_CTRL_FSEL_SHIFT (14U)
/*! FSEL
 *  0b0..FEED_OUT = FREF
 *  0b1..FEED_OUT = FEED
 */
#define CCM_ANALOG_SYS_PLL3_MNIT_CTRL_FSEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL3_MNIT_CTRL_FSEL_SHIFT)) & \
     CCM_ANALOG_SYS_PLL3_MNIT_CTRL_FSEL_MASK)
#define CCM_ANALOG_SYS_PLL3_MNIT_CTRL_AFCINIT_SEL_MASK  (0x10000U)
#define CCM_ANALOG_SYS_PLL3_MNIT_CTRL_AFCINIT_SEL_SHIFT (16U)
/*! AFCINIT_SEL
 *  0b0..nominal delay
 *  0b1..nominal delay * 2
 */
#define CCM_ANALOG_SYS_PLL3_MNIT_CTRL_AFCINIT_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL3_MNIT_CTRL_AFCINIT_SEL_SHIFT)) & \
     CCM_ANALOG_SYS_PLL3_MNIT_CTRL_AFCINIT_SEL_MASK)
#define CCM_ANALOG_SYS_PLL3_MNIT_CTRL_PBIAS_CTRL_EN_MASK  (0x20000U)
#define CCM_ANALOG_SYS_PLL3_MNIT_CTRL_PBIAS_CTRL_EN_SHIFT (17U)
#define CCM_ANALOG_SYS_PLL3_MNIT_CTRL_PBIAS_CTRL_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL3_MNIT_CTRL_PBIAS_CTRL_EN_SHIFT)) & \
     CCM_ANALOG_SYS_PLL3_MNIT_CTRL_PBIAS_CTRL_EN_MASK)
#define CCM_ANALOG_SYS_PLL3_MNIT_CTRL_PBIAS_CTRL_MASK  (0x40000U)
#define CCM_ANALOG_SYS_PLL3_MNIT_CTRL_PBIAS_CTRL_SHIFT (18U)
/*! PBIAS_CTRL
 *  0b0..0.50*VDD
 *  0b1..0.67*VDD
 */
#define CCM_ANALOG_SYS_PLL3_MNIT_CTRL_PBIAS_CTRL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL3_MNIT_CTRL_PBIAS_CTRL_SHIFT)) & \
     CCM_ANALOG_SYS_PLL3_MNIT_CTRL_PBIAS_CTRL_MASK)
#define CCM_ANALOG_SYS_PLL3_MNIT_CTRL_AFC_SEL_MASK  (0x80000U)
#define CCM_ANALOG_SYS_PLL3_MNIT_CTRL_AFC_SEL_SHIFT (19U)
#define CCM_ANALOG_SYS_PLL3_MNIT_CTRL_AFC_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL3_MNIT_CTRL_AFC_SEL_SHIFT)) & \
     CCM_ANALOG_SYS_PLL3_MNIT_CTRL_AFC_SEL_MASK)
#define CCM_ANALOG_SYS_PLL3_MNIT_CTRL_FOUT_MASK_MASK  (0x100000U)
#define CCM_ANALOG_SYS_PLL3_MNIT_CTRL_FOUT_MASK_SHIFT (20U)
#define CCM_ANALOG_SYS_PLL3_MNIT_CTRL_FOUT_MASK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL3_MNIT_CTRL_FOUT_MASK_SHIFT)) & \
     CCM_ANALOG_SYS_PLL3_MNIT_CTRL_FOUT_MASK_MASK)
#define CCM_ANALOG_SYS_PLL3_MNIT_CTRL_LRD_EN_MASK  (0x200000U)
#define CCM_ANALOG_SYS_PLL3_MNIT_CTRL_LRD_EN_SHIFT (21U)
#define CCM_ANALOG_SYS_PLL3_MNIT_CTRL_LRD_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_SYS_PLL3_MNIT_CTRL_LRD_EN_SHIFT)) & \
     CCM_ANALOG_SYS_PLL3_MNIT_CTRL_LRD_EN_MASK)
/*! @} */

/*! @name OSC_MISC_CFG - Osc Misc Configuration Register */
/*! @{ */
#define CCM_ANALOG_OSC_MISC_CFG_OSC_32K_SEL_MASK  (0x1U)
#define CCM_ANALOG_OSC_MISC_CFG_OSC_32K_SEL_SHIFT (0U)
/*! OSC_32K_SEL
 *  0b0..Divided by 24M clock
 *  0b1..32K Oscillator
 */
#define CCM_ANALOG_OSC_MISC_CFG_OSC_32K_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_OSC_MISC_CFG_OSC_32K_SEL_SHIFT)) & \
     CCM_ANALOG_OSC_MISC_CFG_OSC_32K_SEL_MASK)
/*! @} */

/*! @name ANAMIX_PLL_MNIT_CTL - PLL Clock Output for Test Enable and Select Register */
/*! @{ */
#define CCM_ANALOG_ANAMIX_PLL_MNIT_CTL_CLKOUT1_OUTPUT_DIV_VAL_MASK  (0xFU)
#define CCM_ANALOG_ANAMIX_PLL_MNIT_CTL_CLKOUT1_OUTPUT_DIV_VAL_SHIFT (0U)
#define CCM_ANALOG_ANAMIX_PLL_MNIT_CTL_CLKOUT1_OUTPUT_DIV_VAL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_ANAMIX_PLL_MNIT_CTL_CLKOUT1_OUTPUT_DIV_VAL_SHIFT)) & \
     CCM_ANALOG_ANAMIX_PLL_MNIT_CTL_CLKOUT1_OUTPUT_DIV_VAL_MASK)
#define CCM_ANALOG_ANAMIX_PLL_MNIT_CTL_CLKOUT1_OUTPUT_SEL_MASK  (0xF0U)
#define CCM_ANALOG_ANAMIX_PLL_MNIT_CTL_CLKOUT1_OUTPUT_SEL_SHIFT (4U)
#define CCM_ANALOG_ANAMIX_PLL_MNIT_CTL_CLKOUT1_OUTPUT_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_ANAMIX_PLL_MNIT_CTL_CLKOUT1_OUTPUT_SEL_SHIFT)) & \
     CCM_ANALOG_ANAMIX_PLL_MNIT_CTL_CLKOUT1_OUTPUT_SEL_MASK)
#define CCM_ANALOG_ANAMIX_PLL_MNIT_CTL_CLKOUT1_OUTPUT_CKE_MASK  (0x100U)
#define CCM_ANALOG_ANAMIX_PLL_MNIT_CTL_CLKOUT1_OUTPUT_CKE_SHIFT (8U)
#define CCM_ANALOG_ANAMIX_PLL_MNIT_CTL_CLKOUT1_OUTPUT_CKE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_ANAMIX_PLL_MNIT_CTL_CLKOUT1_OUTPUT_CKE_SHIFT)) & \
     CCM_ANALOG_ANAMIX_PLL_MNIT_CTL_CLKOUT1_OUTPUT_CKE_MASK)
#define CCM_ANALOG_ANAMIX_PLL_MNIT_CTL_CLKOUT2_OUTPUT_DIV_VAL_MASK  (0xF0000U)
#define CCM_ANALOG_ANAMIX_PLL_MNIT_CTL_CLKOUT2_OUTPUT_DIV_VAL_SHIFT (16U)
#define CCM_ANALOG_ANAMIX_PLL_MNIT_CTL_CLKOUT2_OUTPUT_DIV_VAL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_ANAMIX_PLL_MNIT_CTL_CLKOUT2_OUTPUT_DIV_VAL_SHIFT)) & \
     CCM_ANALOG_ANAMIX_PLL_MNIT_CTL_CLKOUT2_OUTPUT_DIV_VAL_MASK)
#define CCM_ANALOG_ANAMIX_PLL_MNIT_CTL_CLKOUT2_OUTPUT_SEL_MASK  (0xF00000U)
#define CCM_ANALOG_ANAMIX_PLL_MNIT_CTL_CLKOUT2_OUTPUT_SEL_SHIFT (20U)
#define CCM_ANALOG_ANAMIX_PLL_MNIT_CTL_CLKOUT2_OUTPUT_SEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_ANAMIX_PLL_MNIT_CTL_CLKOUT2_OUTPUT_SEL_SHIFT)) & \
     CCM_ANALOG_ANAMIX_PLL_MNIT_CTL_CLKOUT2_OUTPUT_SEL_MASK)
#define CCM_ANALOG_ANAMIX_PLL_MNIT_CTL_CLKOUT2_OUTPUT_CKE_MASK  (0x1000000U)
#define CCM_ANALOG_ANAMIX_PLL_MNIT_CTL_CLKOUT2_OUTPUT_CKE_SHIFT (24U)
#define CCM_ANALOG_ANAMIX_PLL_MNIT_CTL_CLKOUT2_OUTPUT_CKE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_ANAMIX_PLL_MNIT_CTL_CLKOUT2_OUTPUT_CKE_SHIFT)) & \
     CCM_ANALOG_ANAMIX_PLL_MNIT_CTL_CLKOUT2_OUTPUT_CKE_MASK)
/*! @} */

/*! @name DIGPROG - DIGPROG Register */
/*! @{ */
#define CCM_ANALOG_DIGPROG_DIGPROG_MINOR_MASK  (0xFFU)
#define CCM_ANALOG_DIGPROG_DIGPROG_MINOR_SHIFT (0U)
#define CCM_ANALOG_DIGPROG_DIGPROG_MINOR(x) \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_DIGPROG_DIGPROG_MINOR_SHIFT)) & CCM_ANALOG_DIGPROG_DIGPROG_MINOR_MASK)
#define CCM_ANALOG_DIGPROG_DIGPROG_MAJOR_LOWER_MASK  (0xFF00U)
#define CCM_ANALOG_DIGPROG_DIGPROG_MAJOR_LOWER_SHIFT (8U)
#define CCM_ANALOG_DIGPROG_DIGPROG_MAJOR_LOWER(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_DIGPROG_DIGPROG_MAJOR_LOWER_SHIFT)) & \
     CCM_ANALOG_DIGPROG_DIGPROG_MAJOR_LOWER_MASK)
#define CCM_ANALOG_DIGPROG_DIGPROG_MAJOR_UPPER_MASK  (0xFF0000U)
#define CCM_ANALOG_DIGPROG_DIGPROG_MAJOR_UPPER_SHIFT (16U)
#define CCM_ANALOG_DIGPROG_DIGPROG_MAJOR_UPPER(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << CCM_ANALOG_DIGPROG_DIGPROG_MAJOR_UPPER_SHIFT)) & \
     CCM_ANALOG_DIGPROG_DIGPROG_MAJOR_UPPER_MASK)
/*! @} */

/*!
 * @}
 */ /* end of group CCM_ANALOG_Register_Masks */

/* CCM_ANALOG - Peripheral instance base addresses */
/** Peripheral CCM_ANALOG base address */
#define CCM_ANALOG_BASE (0x30360000u)
/** Peripheral CCM_ANALOG base pointer */
#define CCM_ANALOG ((CCM_ANALOG_Type *)CCM_ANALOG_BASE)
/** Array initializer of CCM_ANALOG peripheral base addresses */
#define CCM_ANALOG_BASE_ADDRS \
    {                         \
        CCM_ANALOG_BASE       \
    }
/** Array initializer of CCM_ANALOG peripheral base pointers */
#define CCM_ANALOG_BASE_PTRS \
    {                        \
        CCM_ANALOG           \
    }

/*!
 * @}
 */ /* end of group CCM_ANALOG_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- CEC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CEC_Peripheral_Access_Layer CEC Peripheral Access Layer
 * @{
 */

/** CEC - Register Layout Typedef */
typedef struct
{
    __IO uint8_t
        CEC_CTRL; /**< CEC Control Register This register handles the main control of the CEC initiator., offset: 0x0 */
    uint8_t RESERVED_0[1];
    __IO uint8_t CEC_MASK; /**< CEC Interrupt Mask Register This read/write register masks/unmasks the interrupt
                              events., offset: 0x2 */
    uint8_t RESERVED_1[2];
    __IO uint8_t CEC_ADDR_L; /**< CEC Logical Address Register Low This register indicates the logical address(es)
                                allocated to the CEC device., offset: 0x5 */
    __IO uint8_t CEC_ADDR_H; /**< CEC Logical Address Register High This register indicates the logical address(es)
                                allocated to the CEC device., offset: 0x6 */
    __IO uint8_t
        CEC_TX_CNT; /**< CEC TX Frame Size Register This register indicates the size of the frame in bytes (including
                       header and data blocks), which are available in the transmitter data buffer., offset: 0x7 */
    __I uint8_t
        CEC_RX_CNT; /**< CEC RX Frame Size Register This register indicates the size of the frame in bytes (including
                       header and data blocks), which are available in the receiver data buffer., offset: 0x8 */
    uint8_t RESERVED_2[39];
    __IO uint8_t CEC_LOCK;       /**< CEC Buffer Lock Register, offset: 0x30 */
    __IO uint8_t CEC_WAKEUPCTRL; /**< CEC Wake-up Control Register After receiving a message in the CEC_RX_DATA1
                                    (OPCODE) registers, the CEC engine verifies the message opcode[7:0] against one of
                                    the previously defined values to generate the wake-up status: Wakeupstatus is 1
                                    when: received opcode is 0x04 and opcode0x04en is 1 or received opcode is 0x0D and
                                    opcode0x0Den is 1 or received opcode is 0x41 and opcode0x41en is 1 or received
                                    opcode is 0x42 and opcode0x42en is 1 or received opcode is 0x44 and opcode0x44en is
                                    1 or received opcode is 0x70 and opcode0x70en is 1 or received opcode is 0x82 and
                                    opcode0x82en is 1 or received opcode is 0x86 and opcode0x86en is 1 Wakeupstatus is 0
                                    when none of the previous conditions are true., offset: 0x31 */
} CEC_Type;

/* ----------------------------------------------------------------------------
   -- CEC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CEC_Register_Masks CEC Register Masks
 * @{
 */

/*! @name CEC_CTRL - CEC Control Register This register handles the main control of the CEC initiator. */
/*! @{ */
#define CEC_CEC_CTRL_SEND_MASK  (0x1U)
#define CEC_CEC_CTRL_SEND_SHIFT (0U)
/*! send - - 1'b1: Set by software to trigger CEC sending a frame as an initiator.
 */
#define CEC_CEC_CTRL_SEND(x)         (((uint8_t)(((uint8_t)(x)) << CEC_CEC_CTRL_SEND_SHIFT)) & CEC_CEC_CTRL_SEND_MASK)
#define CEC_CEC_CTRL_FRAME_TYP_MASK  (0x6U)
#define CEC_CEC_CTRL_FRAME_TYP_SHIFT (1U)
/*! frame_typ - - 2'b00: Signal Free Time = 3-bit periods.
 */
#define CEC_CEC_CTRL_FRAME_TYP(x) \
    (((uint8_t)(((uint8_t)(x)) << CEC_CEC_CTRL_FRAME_TYP_SHIFT)) & CEC_CEC_CTRL_FRAME_TYP_MASK)
#define CEC_CEC_CTRL_BC_NACK_MASK  (0x8U)
#define CEC_CEC_CTRL_BC_NACK_SHIFT (3U)
/*! bc_nack - - 1'b1: Set by software to NACK the received broadcast message.
 */
#define CEC_CEC_CTRL_BC_NACK(x)    (((uint8_t)(((uint8_t)(x)) << CEC_CEC_CTRL_BC_NACK_SHIFT)) & CEC_CEC_CTRL_BC_NACK_MASK)
#define CEC_CEC_CTRL_STANDBY_MASK  (0x10U)
#define CEC_CEC_CTRL_STANDBY_SHIFT (4U)
/*! standby - - 1: CEC controller responds with a NACK to all messages and generates a wakeup status for opcode.
 */
#define CEC_CEC_CTRL_STANDBY(x)                   (((uint8_t)(((uint8_t)(x)) << CEC_CEC_CTRL_STANDBY_SHIFT)) & CEC_CEC_CTRL_STANDBY_MASK)
#define CEC_CEC_CTRL_SLOWDRVSUPPORT_DISABLE_MASK  (0x20U)
#define CEC_CEC_CTRL_SLOWDRVSUPPORT_DISABLE_SHIFT (5U)
/*! slowdrvsupport_disable - - 1: CEC controller supports IO drivers with risetime of up to 1 CEC clock period.
 */
#define CEC_CEC_CTRL_SLOWDRVSUPPORT_DISABLE(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << CEC_CEC_CTRL_SLOWDRVSUPPORT_DISABLE_SHIFT)) & \
     CEC_CEC_CTRL_SLOWDRVSUPPORT_DISABLE_MASK)
/*! @} */

/*! @name CEC_MASK - CEC Interrupt Mask Register This read/write register masks/unmasks the interrupt events. */
/*! @{ */
#define CEC_CEC_MASK_DONE_MASK  (0x1U)
#define CEC_CEC_MASK_DONE_SHIFT (0U)
/*! done - The current transmission is successful (for initiator only)
 */
#define CEC_CEC_MASK_DONE(x)   (((uint8_t)(((uint8_t)(x)) << CEC_CEC_MASK_DONE_SHIFT)) & CEC_CEC_MASK_DONE_MASK)
#define CEC_CEC_MASK_EOM_MASK  (0x2U)
#define CEC_CEC_MASK_EOM_SHIFT (1U)
/*! eom - EOM is detected so that the received data is ready in the receiver data buffer (for follower only)
 */
#define CEC_CEC_MASK_EOM(x)     (((uint8_t)(((uint8_t)(x)) << CEC_CEC_MASK_EOM_SHIFT)) & CEC_CEC_MASK_EOM_MASK)
#define CEC_CEC_MASK_NACK_MASK  (0x4U)
#define CEC_CEC_MASK_NACK_SHIFT (2U)
/*! nack - A frame is not acknowledged in a directly addressed message.
 */
#define CEC_CEC_MASK_NACK(x)        (((uint8_t)(((uint8_t)(x)) << CEC_CEC_MASK_NACK_SHIFT)) & CEC_CEC_MASK_NACK_MASK)
#define CEC_CEC_MASK_ARB_LOST_MASK  (0x8U)
#define CEC_CEC_MASK_ARB_LOST_SHIFT (3U)
/*! arb_lost - The initiator losses the CEC line arbitration to a second initiator.
 */
#define CEC_CEC_MASK_ARB_LOST(x) \
    (((uint8_t)(((uint8_t)(x)) << CEC_CEC_MASK_ARB_LOST_SHIFT)) & CEC_CEC_MASK_ARB_LOST_MASK)
#define CEC_CEC_MASK_ERROR_INITIATOR_MASK  (0x10U)
#define CEC_CEC_MASK_ERROR_INITIATOR_SHIFT (4U)
/*! error_initiator - An error is detected on a CEC line (for initiator only).
 */
#define CEC_CEC_MASK_ERROR_INITIATOR(x) \
    (((uint8_t)(((uint8_t)(x)) << CEC_CEC_MASK_ERROR_INITIATOR_SHIFT)) & CEC_CEC_MASK_ERROR_INITIATOR_MASK)
#define CEC_CEC_MASK_ERROR_FLOW_MASK  (0x20U)
#define CEC_CEC_MASK_ERROR_FLOW_SHIFT (5U)
/*! error_flow - An error is notified by a follower.
 */
#define CEC_CEC_MASK_ERROR_FLOW(x) \
    (((uint8_t)(((uint8_t)(x)) << CEC_CEC_MASK_ERROR_FLOW_SHIFT)) & CEC_CEC_MASK_ERROR_FLOW_MASK)
#define CEC_CEC_MASK_WAKEUP_MASK  (0x40U)
#define CEC_CEC_MASK_WAKEUP_SHIFT (6U)
/*! wakeup - Follower wake-up signal mask
 */
#define CEC_CEC_MASK_WAKEUP(x) (((uint8_t)(((uint8_t)(x)) << CEC_CEC_MASK_WAKEUP_SHIFT)) & CEC_CEC_MASK_WAKEUP_MASK)
/*! @} */

/*! @name CEC_ADDR_L - CEC Logical Address Register Low This register indicates the logical address(es) allocated to the
 * CEC device. */
/*! @{ */
#define CEC_CEC_ADDR_L_CEC_ADDR_L_0_MASK  (0x1U)
#define CEC_CEC_ADDR_L_CEC_ADDR_L_0_SHIFT (0U)
/*! cec_addr_l_0 - Logical address 0 - Device TV
 */
#define CEC_CEC_ADDR_L_CEC_ADDR_L_0(x) \
    (((uint8_t)(((uint8_t)(x)) << CEC_CEC_ADDR_L_CEC_ADDR_L_0_SHIFT)) & CEC_CEC_ADDR_L_CEC_ADDR_L_0_MASK)
#define CEC_CEC_ADDR_L_CEC_ADDR_L_1_MASK  (0x2U)
#define CEC_CEC_ADDR_L_CEC_ADDR_L_1_SHIFT (1U)
/*! cec_addr_l_1 - Logical address 1 - Recording Device 1
 */
#define CEC_CEC_ADDR_L_CEC_ADDR_L_1(x) \
    (((uint8_t)(((uint8_t)(x)) << CEC_CEC_ADDR_L_CEC_ADDR_L_1_SHIFT)) & CEC_CEC_ADDR_L_CEC_ADDR_L_1_MASK)
#define CEC_CEC_ADDR_L_CEC_ADDR_L_2_MASK  (0x4U)
#define CEC_CEC_ADDR_L_CEC_ADDR_L_2_SHIFT (2U)
/*! cec_addr_l_2 - Logical address 2 - Recording Device 2
 */
#define CEC_CEC_ADDR_L_CEC_ADDR_L_2(x) \
    (((uint8_t)(((uint8_t)(x)) << CEC_CEC_ADDR_L_CEC_ADDR_L_2_SHIFT)) & CEC_CEC_ADDR_L_CEC_ADDR_L_2_MASK)
#define CEC_CEC_ADDR_L_CEC_ADDR_L_3_MASK  (0x8U)
#define CEC_CEC_ADDR_L_CEC_ADDR_L_3_SHIFT (3U)
/*! cec_addr_l_3 - Logical address 3 - Tuner 1
 */
#define CEC_CEC_ADDR_L_CEC_ADDR_L_3(x) \
    (((uint8_t)(((uint8_t)(x)) << CEC_CEC_ADDR_L_CEC_ADDR_L_3_SHIFT)) & CEC_CEC_ADDR_L_CEC_ADDR_L_3_MASK)
#define CEC_CEC_ADDR_L_CEC_ADDR_L_4_MASK  (0x10U)
#define CEC_CEC_ADDR_L_CEC_ADDR_L_4_SHIFT (4U)
/*! cec_addr_l_4 - Logical address 4 - Playback Device 1
 */
#define CEC_CEC_ADDR_L_CEC_ADDR_L_4(x) \
    (((uint8_t)(((uint8_t)(x)) << CEC_CEC_ADDR_L_CEC_ADDR_L_4_SHIFT)) & CEC_CEC_ADDR_L_CEC_ADDR_L_4_MASK)
#define CEC_CEC_ADDR_L_CEC_ADDR_L_5_MASK  (0x20U)
#define CEC_CEC_ADDR_L_CEC_ADDR_L_5_SHIFT (5U)
/*! cec_addr_l_5 - Logical address 5 - Audio System
 */
#define CEC_CEC_ADDR_L_CEC_ADDR_L_5(x) \
    (((uint8_t)(((uint8_t)(x)) << CEC_CEC_ADDR_L_CEC_ADDR_L_5_SHIFT)) & CEC_CEC_ADDR_L_CEC_ADDR_L_5_MASK)
#define CEC_CEC_ADDR_L_CEC_ADDR_L_6_MASK  (0x40U)
#define CEC_CEC_ADDR_L_CEC_ADDR_L_6_SHIFT (6U)
/*! cec_addr_l_6 - Logical address 6 - Tuner 2
 */
#define CEC_CEC_ADDR_L_CEC_ADDR_L_6(x) \
    (((uint8_t)(((uint8_t)(x)) << CEC_CEC_ADDR_L_CEC_ADDR_L_6_SHIFT)) & CEC_CEC_ADDR_L_CEC_ADDR_L_6_MASK)
#define CEC_CEC_ADDR_L_CEC_ADDR_L_7_MASK  (0x80U)
#define CEC_CEC_ADDR_L_CEC_ADDR_L_7_SHIFT (7U)
/*! cec_addr_l_7 - Logical address 7 - Tuner 3
 */
#define CEC_CEC_ADDR_L_CEC_ADDR_L_7(x) \
    (((uint8_t)(((uint8_t)(x)) << CEC_CEC_ADDR_L_CEC_ADDR_L_7_SHIFT)) & CEC_CEC_ADDR_L_CEC_ADDR_L_7_MASK)
/*! @} */

/*! @name CEC_ADDR_H - CEC Logical Address Register High This register indicates the logical address(es) allocated to
 * the CEC device. */
/*! @{ */
#define CEC_CEC_ADDR_H_CEC_ADDR_H_0_MASK  (0x1U)
#define CEC_CEC_ADDR_H_CEC_ADDR_H_0_SHIFT (0U)
/*! cec_addr_h_0 - Logical address 8 - Playback Device 2
 */
#define CEC_CEC_ADDR_H_CEC_ADDR_H_0(x) \
    (((uint8_t)(((uint8_t)(x)) << CEC_CEC_ADDR_H_CEC_ADDR_H_0_SHIFT)) & CEC_CEC_ADDR_H_CEC_ADDR_H_0_MASK)
#define CEC_CEC_ADDR_H_CEC_ADDR_H_1_MASK  (0x2U)
#define CEC_CEC_ADDR_H_CEC_ADDR_H_1_SHIFT (1U)
/*! cec_addr_h_1 - Logical address 9 - Playback Device 3
 */
#define CEC_CEC_ADDR_H_CEC_ADDR_H_1(x) \
    (((uint8_t)(((uint8_t)(x)) << CEC_CEC_ADDR_H_CEC_ADDR_H_1_SHIFT)) & CEC_CEC_ADDR_H_CEC_ADDR_H_1_MASK)
#define CEC_CEC_ADDR_H_CEC_ADDR_H_2_MASK  (0x4U)
#define CEC_CEC_ADDR_H_CEC_ADDR_H_2_SHIFT (2U)
/*! cec_addr_h_2 - Logical address 10 - Tuner 4
 */
#define CEC_CEC_ADDR_H_CEC_ADDR_H_2(x) \
    (((uint8_t)(((uint8_t)(x)) << CEC_CEC_ADDR_H_CEC_ADDR_H_2_SHIFT)) & CEC_CEC_ADDR_H_CEC_ADDR_H_2_MASK)
#define CEC_CEC_ADDR_H_CEC_ADDR_H_3_MASK  (0x8U)
#define CEC_CEC_ADDR_H_CEC_ADDR_H_3_SHIFT (3U)
/*! cec_addr_h_3 - Logical address 11 - Playback Device 3
 */
#define CEC_CEC_ADDR_H_CEC_ADDR_H_3(x) \
    (((uint8_t)(((uint8_t)(x)) << CEC_CEC_ADDR_H_CEC_ADDR_H_3_SHIFT)) & CEC_CEC_ADDR_H_CEC_ADDR_H_3_MASK)
#define CEC_CEC_ADDR_H_CEC_ADDR_H_4_MASK  (0x10U)
#define CEC_CEC_ADDR_H_CEC_ADDR_H_4_SHIFT (4U)
/*! cec_addr_h_4 - Logical address 12 - Reserved
 */
#define CEC_CEC_ADDR_H_CEC_ADDR_H_4(x) \
    (((uint8_t)(((uint8_t)(x)) << CEC_CEC_ADDR_H_CEC_ADDR_H_4_SHIFT)) & CEC_CEC_ADDR_H_CEC_ADDR_H_4_MASK)
#define CEC_CEC_ADDR_H_CEC_ADDR_H_5_MASK  (0x20U)
#define CEC_CEC_ADDR_H_CEC_ADDR_H_5_SHIFT (5U)
/*! cec_addr_h_5 - Logical address 13 - Reserved
 */
#define CEC_CEC_ADDR_H_CEC_ADDR_H_5(x) \
    (((uint8_t)(((uint8_t)(x)) << CEC_CEC_ADDR_H_CEC_ADDR_H_5_SHIFT)) & CEC_CEC_ADDR_H_CEC_ADDR_H_5_MASK)
#define CEC_CEC_ADDR_H_CEC_ADDR_H_6_MASK  (0x40U)
#define CEC_CEC_ADDR_H_CEC_ADDR_H_6_SHIFT (6U)
/*! cec_addr_h_6 - Logical address 14 - Free use
 */
#define CEC_CEC_ADDR_H_CEC_ADDR_H_6(x) \
    (((uint8_t)(((uint8_t)(x)) << CEC_CEC_ADDR_H_CEC_ADDR_H_6_SHIFT)) & CEC_CEC_ADDR_H_CEC_ADDR_H_6_MASK)
#define CEC_CEC_ADDR_H_CEC_ADDR_H_7_MASK  (0x80U)
#define CEC_CEC_ADDR_H_CEC_ADDR_H_7_SHIFT (7U)
/*! cec_addr_h_7 - Logical address 15 - Unregistered (as initiator address), Broadcast (as destination address)
 */
#define CEC_CEC_ADDR_H_CEC_ADDR_H_7(x) \
    (((uint8_t)(((uint8_t)(x)) << CEC_CEC_ADDR_H_CEC_ADDR_H_7_SHIFT)) & CEC_CEC_ADDR_H_CEC_ADDR_H_7_MASK)
/*! @} */

/*! @name CEC_TX_CNT - CEC TX Frame Size Register This register indicates the size of the frame in bytes (including
 * header and data blocks), which are available in the transmitter data buffer. */
/*! @{ */
#define CEC_CEC_TX_CNT_CEC_TX_CNT_MASK  (0x1FU)
#define CEC_CEC_TX_CNT_CEC_TX_CNT_SHIFT (0U)
/*! cec_tx_cnt - CEC Transmitter Counter register 5'd0: No data needs to be transmitted 5'd1: Frame size is 1 byte .
 */
#define CEC_CEC_TX_CNT_CEC_TX_CNT(x) \
    (((uint8_t)(((uint8_t)(x)) << CEC_CEC_TX_CNT_CEC_TX_CNT_SHIFT)) & CEC_CEC_TX_CNT_CEC_TX_CNT_MASK)
/*! @} */

/*! @name CEC_RX_CNT - CEC RX Frame Size Register This register indicates the size of the frame in bytes (including
 * header and data blocks), which are available in the receiver data buffer. */
/*! @{ */
#define CEC_CEC_RX_CNT_CEC_RX_CNT_MASK  (0x1FU)
#define CEC_CEC_RX_CNT_CEC_RX_CNT_SHIFT (0U)
/*! cec_rx_cnt - CEC Receiver Counter register: 5'd0: No data received 5'd1: 1-byte data is received .
 */
#define CEC_CEC_RX_CNT_CEC_RX_CNT(x) \
    (((uint8_t)(((uint8_t)(x)) << CEC_CEC_RX_CNT_CEC_RX_CNT_SHIFT)) & CEC_CEC_RX_CNT_CEC_RX_CNT_MASK)
/*! @} */

/*! @name CEC_LOCK - CEC Buffer Lock Register */
/*! @{ */
#define CEC_CEC_LOCK_LOCKED_BUFFER_MASK  (0x1U)
#define CEC_CEC_LOCK_LOCKED_BUFFER_SHIFT (0U)
/*! locked_buffer - When a frame is received, this bit would be active.
 */
#define CEC_CEC_LOCK_LOCKED_BUFFER(x) \
    (((uint8_t)(((uint8_t)(x)) << CEC_CEC_LOCK_LOCKED_BUFFER_SHIFT)) & CEC_CEC_LOCK_LOCKED_BUFFER_MASK)
/*! @} */

/*! @name CEC_WAKEUPCTRL - CEC Wake-up Control Register After receiving a message in the CEC_RX_DATA1 (OPCODE)
 * registers, the CEC engine verifies the message opcode[7:0] against one of the previously defined values to generate
 * the wake-up status: Wakeupstatus is 1 when: received opcode is 0x04 and opcode0x04en is 1 or received opcode is 0x0D
 * and opcode0x0Den is 1 or received opcode is 0x41 and opcode0x41en is 1 or received opcode is 0x42 and opcode0x42en is
 * 1 or received opcode is 0x44 and opcode0x44en is 1 or received opcode is 0x70 and opcode0x70en is 1 or received
 * opcode is 0x82 and opcode0x82en is 1 or received opcode is 0x86 and opcode0x86en is 1 Wakeupstatus is 0 when none of
 * the previous conditions are true. */
/*! @{ */
#define CEC_CEC_WAKEUPCTRL_OPCODE0X04EN_MASK  (0x1U)
#define CEC_CEC_WAKEUPCTRL_OPCODE0X04EN_SHIFT (0U)
/*! opcode0x04en - OPCODE 0x04 wake up enable
 */
#define CEC_CEC_WAKEUPCTRL_OPCODE0X04EN(x) \
    (((uint8_t)(((uint8_t)(x)) << CEC_CEC_WAKEUPCTRL_OPCODE0X04EN_SHIFT)) & CEC_CEC_WAKEUPCTRL_OPCODE0X04EN_MASK)
#define CEC_CEC_WAKEUPCTRL_OPCODE0X0DEN_MASK  (0x2U)
#define CEC_CEC_WAKEUPCTRL_OPCODE0X0DEN_SHIFT (1U)
/*! opcode0x0Den - OPCODE 0x0D wake up enable
 */
#define CEC_CEC_WAKEUPCTRL_OPCODE0X0DEN(x) \
    (((uint8_t)(((uint8_t)(x)) << CEC_CEC_WAKEUPCTRL_OPCODE0X0DEN_SHIFT)) & CEC_CEC_WAKEUPCTRL_OPCODE0X0DEN_MASK)
#define CEC_CEC_WAKEUPCTRL_OPCODE0X41EN_MASK  (0x4U)
#define CEC_CEC_WAKEUPCTRL_OPCODE0X41EN_SHIFT (2U)
/*! opcode0x41en - OPCODE 0x41 wake up enable
 */
#define CEC_CEC_WAKEUPCTRL_OPCODE0X41EN(x) \
    (((uint8_t)(((uint8_t)(x)) << CEC_CEC_WAKEUPCTRL_OPCODE0X41EN_SHIFT)) & CEC_CEC_WAKEUPCTRL_OPCODE0X41EN_MASK)
#define CEC_CEC_WAKEUPCTRL_OPCODE0X42EN_MASK  (0x8U)
#define CEC_CEC_WAKEUPCTRL_OPCODE0X42EN_SHIFT (3U)
/*! opcode0x42en - OPCODE 0x42 wake up enable
 */
#define CEC_CEC_WAKEUPCTRL_OPCODE0X42EN(x) \
    (((uint8_t)(((uint8_t)(x)) << CEC_CEC_WAKEUPCTRL_OPCODE0X42EN_SHIFT)) & CEC_CEC_WAKEUPCTRL_OPCODE0X42EN_MASK)
#define CEC_CEC_WAKEUPCTRL_OPCODE0X44EN_MASK  (0x10U)
#define CEC_CEC_WAKEUPCTRL_OPCODE0X44EN_SHIFT (4U)
/*! opcode0x44en - OPCODE 0x44 wake up enable
 */
#define CEC_CEC_WAKEUPCTRL_OPCODE0X44EN(x) \
    (((uint8_t)(((uint8_t)(x)) << CEC_CEC_WAKEUPCTRL_OPCODE0X44EN_SHIFT)) & CEC_CEC_WAKEUPCTRL_OPCODE0X44EN_MASK)
#define CEC_CEC_WAKEUPCTRL_OPCODE0X70EN_MASK  (0x20U)
#define CEC_CEC_WAKEUPCTRL_OPCODE0X70EN_SHIFT (5U)
/*! opcode0x70en - OPCODE 0x70 wake up enable
 */
#define CEC_CEC_WAKEUPCTRL_OPCODE0X70EN(x) \
    (((uint8_t)(((uint8_t)(x)) << CEC_CEC_WAKEUPCTRL_OPCODE0X70EN_SHIFT)) & CEC_CEC_WAKEUPCTRL_OPCODE0X70EN_MASK)
#define CEC_CEC_WAKEUPCTRL_OPCODE0X82EN_MASK  (0x40U)
#define CEC_CEC_WAKEUPCTRL_OPCODE0X82EN_SHIFT (6U)
/*! opcode0x82en - OPCODE 0x82 wake up enable
 */
#define CEC_CEC_WAKEUPCTRL_OPCODE0X82EN(x) \
    (((uint8_t)(((uint8_t)(x)) << CEC_CEC_WAKEUPCTRL_OPCODE0X82EN_SHIFT)) & CEC_CEC_WAKEUPCTRL_OPCODE0X82EN_MASK)
#define CEC_CEC_WAKEUPCTRL_OPCODE0X86EN_MASK  (0x80U)
#define CEC_CEC_WAKEUPCTRL_OPCODE0X86EN_SHIFT (7U)
/*! opcode0x86en - OPCODE 0x86 wake up enable
 */
#define CEC_CEC_WAKEUPCTRL_OPCODE0X86EN(x) \
    (((uint8_t)(((uint8_t)(x)) << CEC_CEC_WAKEUPCTRL_OPCODE0X86EN_SHIFT)) & CEC_CEC_WAKEUPCTRL_OPCODE0X86EN_MASK)
/*! @} */

/*!
 * @}
 */ /* end of group CEC_Register_Masks */

/* CEC - Peripheral instance base addresses */
/** Peripheral CEC base address */
#define CEC_BASE (0x32FDFD00u)
/** Peripheral CEC base pointer */
#define CEC ((CEC_Type *)CEC_BASE)
/** Array initializer of CEC peripheral base addresses */
#define CEC_BASE_ADDRS \
    {                  \
        CEC_BASE       \
    }
/** Array initializer of CEC peripheral base pointers */
#define CEC_BASE_PTRS \
    {                 \
        CEC           \
    }

/*!
 * @}
 */ /* end of group CEC_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- COLORSPACECONVERTER Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup COLORSPACECONVERTER_Peripheral_Access_Layer COLORSPACECONVERTER Peripheral Access Layer
 * @{
 */

/** COLORSPACECONVERTER - Register Layout Typedef */
typedef struct
{
    __IO uint8_t CSC_CFG; /**< Color Space Converter Interpolation and Decimation Configuration Register, offset: 0x0 */
    __IO uint8_t CSC_SCALE; /**< Color Space Converter Scale and Deep Color Configuration Register, offset: 0x1 */
    __IO uint8_t
        CSC_COEF_A1_MSB; /**< Color Space Converter Matrix A1 Coefficient Register MSB Notes: - The coefficients used in
                            the CSC matrix use only 15 bits for the internal computations., offset: 0x2 */
    __IO uint8_t
        CSC_COEF_A1_LSB; /**< Color Space Converter Matrix A1 Coefficient Register LSB Notes: - The coefficients used in
                            the CSC matrix use only 15 bits for the internal computations., offset: 0x3 */
    __IO uint8_t CSC_COEF_A2_MSB;  /**< Color Space Converter Matrix A2 Coefficient Register MSB Color Space Conversion
                                      A2 coefficient., offset: 0x4 */
    __IO uint8_t CSC_COEF_A2_LSB;  /**< Color Space Converter Matrix A2 Coefficient Register LSB Color Space Conversion
                                      A2 coefficient., offset: 0x5 */
    __IO uint8_t CSC_COEF_A3_MSB;  /**< Color Space Converter Matrix A3 Coefficient Register MSB Color Space Conversion
                                      A3 coefficient., offset: 0x6 */
    __IO uint8_t CSC_COEF_A3_LSB;  /**< Color Space Converter Matrix A3 Coefficient Register LSB Color Space Conversion
                                      A3 coefficient., offset: 0x7 */
    __IO uint8_t CSC_COEF_A4_MSB;  /**< Color Space Converter Matrix A4 Coefficient Register MSB Color Space Conversion
                                      A4 coefficient., offset: 0x8 */
    __IO uint8_t CSC_COEF_A4_LSB;  /**< Color Space Converter Matrix A4 Coefficient Register LSB Color Space Conversion
                                      A4 coefficient., offset: 0x9 */
    __IO uint8_t CSC_COEF_B1_MSB;  /**< Color Space Converter Matrix B1 Coefficient Register MSB Color Space Conversion
                                      B1 coefficient., offset: 0xA */
    __IO uint8_t CSC_COEF_B1_LSB;  /**< Color Space Converter Matrix B1 Coefficient Register LSB Color Space Conversion
                                      B1 coefficient., offset: 0xB */
    __IO uint8_t CSC_COEF_B2_MSB;  /**< Color Space Converter Matrix B2 Coefficient Register MSB Color Space Conversion
                                      B2 coefficient., offset: 0xC */
    __IO uint8_t CSC_COEF_B2_LSB;  /**< Color Space Converter Matrix B2 Coefficient Register LSB Color Space Conversion
                                      B2 coefficient., offset: 0xD */
    __IO uint8_t CSC_COEF_B3_MSB;  /**< Color Space Converter Matrix B3 Coefficient Register MSB Color Space Conversion
                                      B3 coefficient., offset: 0xE */
    __IO uint8_t CSC_COEF_B3_LSB;  /**< Color Space Converter Matrix B3 Coefficient Register LSB Color Space Conversion
                                      B3 coefficient., offset: 0xF */
    __IO uint8_t CSC_COEF_B4_MSB;  /**< Color Space Converter Matrix B4 Coefficient Register MSB Color Space Conversion
                                      B4 coefficient., offset: 0x10 */
    __IO uint8_t CSC_COEF_B4_LSB;  /**< Color Space Converter Matrix B4 Coefficient Register LSB Color Space Conversion
                                      B4 coefficient., offset: 0x11 */
    __IO uint8_t CSC_COEF_C1_MSB;  /**< Color Space Converter Matrix C1 Coefficient Register MSB Color Space Conversion
                                      C1 coefficient., offset: 0x12 */
    __IO uint8_t CSC_COEF_C1_LSB;  /**< Color Space Converter Matrix C1 Coefficient Register LSB Color Space Conversion
                                      C1 coefficient., offset: 0x13 */
    __IO uint8_t CSC_COEF_C2_MSB;  /**< Color Space Converter Matrix C2 Coefficient Register MSB Color Space Conversion
                                      C2 coefficient., offset: 0x14 */
    __IO uint8_t CSC_COEF_C2_LSB;  /**< Color Space Converter Matrix C2 Coefficient Register LSB Color Space Conversion
                                      C2 coefficient., offset: 0x15 */
    __IO uint8_t CSC_COEF_C3_MSB;  /**< Color Space Converter Matrix C3 Coefficient Register MSB Color Space Conversion
                                      C3 coefficient., offset: 0x16 */
    __IO uint8_t CSC_COEF_C3_LSB;  /**< Color Space Converter Matrix C3 Coefficient Register LSB Color Space Conversion
                                      C3 coefficient., offset: 0x17 */
    __IO uint8_t CSC_COEF_C4_MSB;  /**< Color Space Converter Matrix C4 Coefficient Register MSB Color Space Conversion
                                      C4 coefficient., offset: 0x18 */
    __IO uint8_t CSC_COEF_C4_LSB;  /**< Color Space Converter Matrix C4 Coefficient Register LSB Color Space Conversion
                                      C4 coefficient., offset: 0x19 */
    __IO uint8_t CSC_LIMIT_UP_MSB; /**< Color Space Converter Matrix Output Up Limit Register MSB For more details,
                                      refer to the HDMI 1., offset: 0x1A */
    __IO uint8_t CSC_LIMIT_UP_LSB; /**< Color Space Converter Matrix output Up Limit Register LSB For more details,
                                      refer to the HDMI 1., offset: 0x1B */
    __IO uint8_t CSC_LIMIT_DN_MSB; /**< Color Space Converter Matrix output Down Limit Register MSB For more details,
                                      refer to the HDMI 1., offset: 0x1C */
    __IO uint8_t CSC_LIMIT_DN_LSB; /**< Color Space Converter Matrix output Down Limit Register LSB For more details,
                                      refer to the HDMI 1., offset: 0x1D */
} COLORSPACECONVERTER_Type;

/* ----------------------------------------------------------------------------
   -- COLORSPACECONVERTER Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup COLORSPACECONVERTER_Register_Masks COLORSPACECONVERTER Register Masks
 * @{
 */

/*! @name CSC_CFG - Color Space Converter Interpolation and Decimation Configuration Register */
/*! @{ */
#define COLORSPACECONVERTER_CSC_CFG_DECMODE_MASK  (0x3U)
#define COLORSPACECONVERTER_CSC_CFG_DECMODE_SHIFT (0U)
/*! decmode - Chroma decimation configuration: decmode[1:0] | Chroma Decimation 00 | decimation
 *    disabled 01 | Hd (z) =1 10 | Hd(z)=1/ 4 + 1/2z^(-1 )+1/4 z^(-2) 11 | Hd(z)x2^(11)= -5+12z^(-2) -
 *    22z^(-4)+39z^(-8) +109z^(-10) -204z^(-12)+648z^(-14) + 1024z^(-15) +648z^(-16) -204z^(-18)
 *    +109z^(-20)- 65z^(-22) +39z^(-24) -22z^(-26) +12z^(-28)-5z^(-30)
 */
#define COLORSPACECONVERTER_CSC_CFG_DECMODE(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_CFG_DECMODE_SHIFT)) & \
     COLORSPACECONVERTER_CSC_CFG_DECMODE_MASK)
#define COLORSPACECONVERTER_CSC_CFG_SPARE_1_MASK  (0xCU)
#define COLORSPACECONVERTER_CSC_CFG_SPARE_1_SHIFT (2U)
/*! spare_1 - Reserved as "spare" register with no associated functionality.
 */
#define COLORSPACECONVERTER_CSC_CFG_SPARE_1(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_CFG_SPARE_1_SHIFT)) & \
     COLORSPACECONVERTER_CSC_CFG_SPARE_1_MASK)
#define COLORSPACECONVERTER_CSC_CFG_INTMODE_MASK  (0x30U)
#define COLORSPACECONVERTER_CSC_CFG_INTMODE_SHIFT (4U)
/*! intmode - Chroma interpolation configuration: intmode[1:0] | Chroma Interpolation 00 |
 *    interpolation disabled 01 | Hu (z) =1 + z^(-1) 10 | Hu(z)=1/ 2 + z^(-11)+1/2 z^(-2) 11 | interpolation
 *    disabled
 */
#define COLORSPACECONVERTER_CSC_CFG_INTMODE(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_CFG_INTMODE_SHIFT)) & \
     COLORSPACECONVERTER_CSC_CFG_INTMODE_MASK)
#define COLORSPACECONVERTER_CSC_CFG_SPARE_2_MASK  (0x40U)
#define COLORSPACECONVERTER_CSC_CFG_SPARE_2_SHIFT (6U)
/*! spare_2 - Reserved as "spare" register with no associated functionality.
 */
#define COLORSPACECONVERTER_CSC_CFG_SPARE_2(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_CFG_SPARE_2_SHIFT)) & \
     COLORSPACECONVERTER_CSC_CFG_SPARE_2_MASK)
#define COLORSPACECONVERTER_CSC_CFG_CSC_LIMIT_MASK  (0x80U)
#define COLORSPACECONVERTER_CSC_CFG_CSC_LIMIT_SHIFT (7U)
/*! csc_limit - When set (1'b1), the range limitation values defined in registers csc_mat_uplim and
 *    csc_mat_dnlim are applied to the output of the Color Space Conversion matrix.
 */
#define COLORSPACECONVERTER_CSC_CFG_CSC_LIMIT(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_CFG_CSC_LIMIT_SHIFT)) & \
     COLORSPACECONVERTER_CSC_CFG_CSC_LIMIT_MASK)
/*! @} */

/*! @name CSC_SCALE - Color Space Converter Scale and Deep Color Configuration Register */
/*! @{ */
#define COLORSPACECONVERTER_CSC_SCALE_CSCSCALE_MASK  (0x3U)
#define COLORSPACECONVERTER_CSC_SCALE_CSCSCALE_SHIFT (0U)
/*! cscscale - Defines the cscscale[1:0] scale factor to apply to all coefficients in Color Space Conversion.
 */
#define COLORSPACECONVERTER_CSC_SCALE_CSCSCALE(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_SCALE_CSCSCALE_SHIFT)) & \
     COLORSPACECONVERTER_CSC_SCALE_CSCSCALE_MASK)
#define COLORSPACECONVERTER_CSC_SCALE_SPARE_MASK  (0xCU)
#define COLORSPACECONVERTER_CSC_SCALE_SPARE_SHIFT (2U)
/*! spare - The is a Reserved as "spare" register with no associated functionality.
 */
#define COLORSPACECONVERTER_CSC_SCALE_SPARE(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_SCALE_SPARE_SHIFT)) & \
     COLORSPACECONVERTER_CSC_SCALE_SPARE_MASK)
#define COLORSPACECONVERTER_CSC_SCALE_CSC_COLOR_DEPTH_MASK  (0xF0U)
#define COLORSPACECONVERTER_CSC_SCALE_CSC_COLOR_DEPTH_SHIFT (4U)
/*! csc_color_depth - Color space converter color depth configuration: csc_colordepth[3:0] | Action
 *    0000 | 24 bit per pixel video (8 bit per component).
 */
#define COLORSPACECONVERTER_CSC_SCALE_CSC_COLOR_DEPTH(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_SCALE_CSC_COLOR_DEPTH_SHIFT)) & \
     COLORSPACECONVERTER_CSC_SCALE_CSC_COLOR_DEPTH_MASK)
/*! @} */

/*! @name CSC_COEF_A1_MSB - Color Space Converter Matrix A1 Coefficient Register MSB Notes: - The coefficients used in
 * the CSC matrix use only 15 bits for the internal computations. */
/*! @{ */
#define COLORSPACECONVERTER_CSC_COEF_A1_MSB_CSC_COEF_A1_MSB_MASK  (0xFFU)
#define COLORSPACECONVERTER_CSC_COEF_A1_MSB_CSC_COEF_A1_MSB_SHIFT (0U)
/*! csc_coef_a1_msb - Color Space Converter Matrix A1 Coefficient Register MSB
 */
#define COLORSPACECONVERTER_CSC_COEF_A1_MSB_CSC_COEF_A1_MSB(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_COEF_A1_MSB_CSC_COEF_A1_MSB_SHIFT)) & \
     COLORSPACECONVERTER_CSC_COEF_A1_MSB_CSC_COEF_A1_MSB_MASK)
/*! @} */

/*! @name CSC_COEF_A1_LSB - Color Space Converter Matrix A1 Coefficient Register LSB Notes: - The coefficients used in
 * the CSC matrix use only 15 bits for the internal computations. */
/*! @{ */
#define COLORSPACECONVERTER_CSC_COEF_A1_LSB_CSC_COEF_A1_LSB_MASK  (0xFFU)
#define COLORSPACECONVERTER_CSC_COEF_A1_LSB_CSC_COEF_A1_LSB_SHIFT (0U)
/*! csc_coef_a1_lsb - Color Space Converter Matrix A1 Coefficient Register LSB
 */
#define COLORSPACECONVERTER_CSC_COEF_A1_LSB_CSC_COEF_A1_LSB(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_COEF_A1_LSB_CSC_COEF_A1_LSB_SHIFT)) & \
     COLORSPACECONVERTER_CSC_COEF_A1_LSB_CSC_COEF_A1_LSB_MASK)
/*! @} */

/*! @name CSC_COEF_A2_MSB - Color Space Converter Matrix A2 Coefficient Register MSB Color Space Conversion A2
 * coefficient. */
/*! @{ */
#define COLORSPACECONVERTER_CSC_COEF_A2_MSB_CSC_COEF_A2_MSB_MASK  (0xFFU)
#define COLORSPACECONVERTER_CSC_COEF_A2_MSB_CSC_COEF_A2_MSB_SHIFT (0U)
/*! csc_coef_a2_msb - Color Space Converter Matrix A2 Coefficient Register MSB
 */
#define COLORSPACECONVERTER_CSC_COEF_A2_MSB_CSC_COEF_A2_MSB(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_COEF_A2_MSB_CSC_COEF_A2_MSB_SHIFT)) & \
     COLORSPACECONVERTER_CSC_COEF_A2_MSB_CSC_COEF_A2_MSB_MASK)
/*! @} */

/*! @name CSC_COEF_A2_LSB - Color Space Converter Matrix A2 Coefficient Register LSB Color Space Conversion A2
 * coefficient. */
/*! @{ */
#define COLORSPACECONVERTER_CSC_COEF_A2_LSB_CSC_COEF_A2_LSB_MASK  (0xFFU)
#define COLORSPACECONVERTER_CSC_COEF_A2_LSB_CSC_COEF_A2_LSB_SHIFT (0U)
/*! csc_coef_a2_lsb - Color Space Converter Matrix A2 Coefficient Register LSB
 */
#define COLORSPACECONVERTER_CSC_COEF_A2_LSB_CSC_COEF_A2_LSB(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_COEF_A2_LSB_CSC_COEF_A2_LSB_SHIFT)) & \
     COLORSPACECONVERTER_CSC_COEF_A2_LSB_CSC_COEF_A2_LSB_MASK)
/*! @} */

/*! @name CSC_COEF_A3_MSB - Color Space Converter Matrix A3 Coefficient Register MSB Color Space Conversion A3
 * coefficient. */
/*! @{ */
#define COLORSPACECONVERTER_CSC_COEF_A3_MSB_CSC_COEF_A3_MSB_MASK  (0xFFU)
#define COLORSPACECONVERTER_CSC_COEF_A3_MSB_CSC_COEF_A3_MSB_SHIFT (0U)
/*! csc_coef_a3_msb - Color Space Converter Matrix A3 Coefficient Register MSB
 */
#define COLORSPACECONVERTER_CSC_COEF_A3_MSB_CSC_COEF_A3_MSB(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_COEF_A3_MSB_CSC_COEF_A3_MSB_SHIFT)) & \
     COLORSPACECONVERTER_CSC_COEF_A3_MSB_CSC_COEF_A3_MSB_MASK)
/*! @} */

/*! @name CSC_COEF_A3_LSB - Color Space Converter Matrix A3 Coefficient Register LSB Color Space Conversion A3
 * coefficient. */
/*! @{ */
#define COLORSPACECONVERTER_CSC_COEF_A3_LSB_CSC_COEF_A3_LSB_MASK  (0xFFU)
#define COLORSPACECONVERTER_CSC_COEF_A3_LSB_CSC_COEF_A3_LSB_SHIFT (0U)
/*! csc_coef_a3_lsb - Color Space Converter Matrix A3 Coefficient Register LSB
 */
#define COLORSPACECONVERTER_CSC_COEF_A3_LSB_CSC_COEF_A3_LSB(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_COEF_A3_LSB_CSC_COEF_A3_LSB_SHIFT)) & \
     COLORSPACECONVERTER_CSC_COEF_A3_LSB_CSC_COEF_A3_LSB_MASK)
/*! @} */

/*! @name CSC_COEF_A4_MSB - Color Space Converter Matrix A4 Coefficient Register MSB Color Space Conversion A4
 * coefficient. */
/*! @{ */
#define COLORSPACECONVERTER_CSC_COEF_A4_MSB_CSC_COEF_A4_MSB_MASK  (0xFFU)
#define COLORSPACECONVERTER_CSC_COEF_A4_MSB_CSC_COEF_A4_MSB_SHIFT (0U)
/*! csc_coef_a4_msb - Color Space Converter Matrix A4 Coefficient Register MSB
 */
#define COLORSPACECONVERTER_CSC_COEF_A4_MSB_CSC_COEF_A4_MSB(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_COEF_A4_MSB_CSC_COEF_A4_MSB_SHIFT)) & \
     COLORSPACECONVERTER_CSC_COEF_A4_MSB_CSC_COEF_A4_MSB_MASK)
/*! @} */

/*! @name CSC_COEF_A4_LSB - Color Space Converter Matrix A4 Coefficient Register LSB Color Space Conversion A4
 * coefficient. */
/*! @{ */
#define COLORSPACECONVERTER_CSC_COEF_A4_LSB_CSC_COEF_A4_LSB_MASK  (0xFFU)
#define COLORSPACECONVERTER_CSC_COEF_A4_LSB_CSC_COEF_A4_LSB_SHIFT (0U)
/*! csc_coef_a4_lsb - Color Space Converter Matrix A4 Coefficient Register LSB
 */
#define COLORSPACECONVERTER_CSC_COEF_A4_LSB_CSC_COEF_A4_LSB(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_COEF_A4_LSB_CSC_COEF_A4_LSB_SHIFT)) & \
     COLORSPACECONVERTER_CSC_COEF_A4_LSB_CSC_COEF_A4_LSB_MASK)
/*! @} */

/*! @name CSC_COEF_B1_MSB - Color Space Converter Matrix B1 Coefficient Register MSB Color Space Conversion B1
 * coefficient. */
/*! @{ */
#define COLORSPACECONVERTER_CSC_COEF_B1_MSB_CSC_COEF_B1_MSB_MASK  (0xFFU)
#define COLORSPACECONVERTER_CSC_COEF_B1_MSB_CSC_COEF_B1_MSB_SHIFT (0U)
/*! csc_coef_b1_msb - Color Space Converter Matrix B1 Coefficient Register MSB
 */
#define COLORSPACECONVERTER_CSC_COEF_B1_MSB_CSC_COEF_B1_MSB(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_COEF_B1_MSB_CSC_COEF_B1_MSB_SHIFT)) & \
     COLORSPACECONVERTER_CSC_COEF_B1_MSB_CSC_COEF_B1_MSB_MASK)
/*! @} */

/*! @name CSC_COEF_B1_LSB - Color Space Converter Matrix B1 Coefficient Register LSB Color Space Conversion B1
 * coefficient. */
/*! @{ */
#define COLORSPACECONVERTER_CSC_COEF_B1_LSB_CSC_COEF_B1_LSB_MASK  (0xFFU)
#define COLORSPACECONVERTER_CSC_COEF_B1_LSB_CSC_COEF_B1_LSB_SHIFT (0U)
/*! csc_coef_b1_lsb - Color Space Converter Matrix B1 Coefficient Register LSB
 */
#define COLORSPACECONVERTER_CSC_COEF_B1_LSB_CSC_COEF_B1_LSB(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_COEF_B1_LSB_CSC_COEF_B1_LSB_SHIFT)) & \
     COLORSPACECONVERTER_CSC_COEF_B1_LSB_CSC_COEF_B1_LSB_MASK)
/*! @} */

/*! @name CSC_COEF_B2_MSB - Color Space Converter Matrix B2 Coefficient Register MSB Color Space Conversion B2
 * coefficient. */
/*! @{ */
#define COLORSPACECONVERTER_CSC_COEF_B2_MSB_CSC_COEF_B2_MSB_MASK  (0xFFU)
#define COLORSPACECONVERTER_CSC_COEF_B2_MSB_CSC_COEF_B2_MSB_SHIFT (0U)
/*! csc_coef_b2_msb - Color Space Converter Matrix B2 Coefficient Register MSB
 */
#define COLORSPACECONVERTER_CSC_COEF_B2_MSB_CSC_COEF_B2_MSB(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_COEF_B2_MSB_CSC_COEF_B2_MSB_SHIFT)) & \
     COLORSPACECONVERTER_CSC_COEF_B2_MSB_CSC_COEF_B2_MSB_MASK)
/*! @} */

/*! @name CSC_COEF_B2_LSB - Color Space Converter Matrix B2 Coefficient Register LSB Color Space Conversion B2
 * coefficient. */
/*! @{ */
#define COLORSPACECONVERTER_CSC_COEF_B2_LSB_CSC_COEF_B2_LSB_MASK  (0xFFU)
#define COLORSPACECONVERTER_CSC_COEF_B2_LSB_CSC_COEF_B2_LSB_SHIFT (0U)
/*! csc_coef_b2_lsb - Color Space Converter Matrix B2 Coefficient Register LSB
 */
#define COLORSPACECONVERTER_CSC_COEF_B2_LSB_CSC_COEF_B2_LSB(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_COEF_B2_LSB_CSC_COEF_B2_LSB_SHIFT)) & \
     COLORSPACECONVERTER_CSC_COEF_B2_LSB_CSC_COEF_B2_LSB_MASK)
/*! @} */

/*! @name CSC_COEF_B3_MSB - Color Space Converter Matrix B3 Coefficient Register MSB Color Space Conversion B3
 * coefficient. */
/*! @{ */
#define COLORSPACECONVERTER_CSC_COEF_B3_MSB_CSC_COEF_B3_MSB_MASK  (0xFFU)
#define COLORSPACECONVERTER_CSC_COEF_B3_MSB_CSC_COEF_B3_MSB_SHIFT (0U)
/*! csc_coef_b3_msb - Color Space Converter Matrix B3 Coefficient Register MSB
 */
#define COLORSPACECONVERTER_CSC_COEF_B3_MSB_CSC_COEF_B3_MSB(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_COEF_B3_MSB_CSC_COEF_B3_MSB_SHIFT)) & \
     COLORSPACECONVERTER_CSC_COEF_B3_MSB_CSC_COEF_B3_MSB_MASK)
/*! @} */

/*! @name CSC_COEF_B3_LSB - Color Space Converter Matrix B3 Coefficient Register LSB Color Space Conversion B3
 * coefficient. */
/*! @{ */
#define COLORSPACECONVERTER_CSC_COEF_B3_LSB_CSC_COEF_B3_LSB_MASK  (0xFFU)
#define COLORSPACECONVERTER_CSC_COEF_B3_LSB_CSC_COEF_B3_LSB_SHIFT (0U)
/*! csc_coef_b3_lsb - Color Space Converter Matrix B3 Coefficient Register LSB
 */
#define COLORSPACECONVERTER_CSC_COEF_B3_LSB_CSC_COEF_B3_LSB(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_COEF_B3_LSB_CSC_COEF_B3_LSB_SHIFT)) & \
     COLORSPACECONVERTER_CSC_COEF_B3_LSB_CSC_COEF_B3_LSB_MASK)
/*! @} */

/*! @name CSC_COEF_B4_MSB - Color Space Converter Matrix B4 Coefficient Register MSB Color Space Conversion B4
 * coefficient. */
/*! @{ */
#define COLORSPACECONVERTER_CSC_COEF_B4_MSB_CSC_COEF_B4_MSB_MASK  (0xFFU)
#define COLORSPACECONVERTER_CSC_COEF_B4_MSB_CSC_COEF_B4_MSB_SHIFT (0U)
/*! csc_coef_b4_msb - Color Space Converter Matrix B4 Coefficient Register MSB
 */
#define COLORSPACECONVERTER_CSC_COEF_B4_MSB_CSC_COEF_B4_MSB(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_COEF_B4_MSB_CSC_COEF_B4_MSB_SHIFT)) & \
     COLORSPACECONVERTER_CSC_COEF_B4_MSB_CSC_COEF_B4_MSB_MASK)
/*! @} */

/*! @name CSC_COEF_B4_LSB - Color Space Converter Matrix B4 Coefficient Register LSB Color Space Conversion B4
 * coefficient. */
/*! @{ */
#define COLORSPACECONVERTER_CSC_COEF_B4_LSB_CSC_COEF_B4_LSB_MASK  (0xFFU)
#define COLORSPACECONVERTER_CSC_COEF_B4_LSB_CSC_COEF_B4_LSB_SHIFT (0U)
/*! csc_coef_b4_lsb - Color Space Converter Matrix B4 Coefficient Register LSB
 */
#define COLORSPACECONVERTER_CSC_COEF_B4_LSB_CSC_COEF_B4_LSB(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_COEF_B4_LSB_CSC_COEF_B4_LSB_SHIFT)) & \
     COLORSPACECONVERTER_CSC_COEF_B4_LSB_CSC_COEF_B4_LSB_MASK)
/*! @} */

/*! @name CSC_COEF_C1_MSB - Color Space Converter Matrix C1 Coefficient Register MSB Color Space Conversion C1
 * coefficient. */
/*! @{ */
#define COLORSPACECONVERTER_CSC_COEF_C1_MSB_CSC_COEF_C1_MSB_MASK  (0xFFU)
#define COLORSPACECONVERTER_CSC_COEF_C1_MSB_CSC_COEF_C1_MSB_SHIFT (0U)
/*! csc_coef_c1_msb - Color Space Converter Matrix C1 Coefficient Register MSB
 */
#define COLORSPACECONVERTER_CSC_COEF_C1_MSB_CSC_COEF_C1_MSB(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_COEF_C1_MSB_CSC_COEF_C1_MSB_SHIFT)) & \
     COLORSPACECONVERTER_CSC_COEF_C1_MSB_CSC_COEF_C1_MSB_MASK)
/*! @} */

/*! @name CSC_COEF_C1_LSB - Color Space Converter Matrix C1 Coefficient Register LSB Color Space Conversion C1
 * coefficient. */
/*! @{ */
#define COLORSPACECONVERTER_CSC_COEF_C1_LSB_CSC_COEF_C1_LSB_MASK  (0xFFU)
#define COLORSPACECONVERTER_CSC_COEF_C1_LSB_CSC_COEF_C1_LSB_SHIFT (0U)
/*! csc_coef_c1_lsb - Color Space Converter Matrix C1 Coefficient Register LSB
 */
#define COLORSPACECONVERTER_CSC_COEF_C1_LSB_CSC_COEF_C1_LSB(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_COEF_C1_LSB_CSC_COEF_C1_LSB_SHIFT)) & \
     COLORSPACECONVERTER_CSC_COEF_C1_LSB_CSC_COEF_C1_LSB_MASK)
/*! @} */

/*! @name CSC_COEF_C2_MSB - Color Space Converter Matrix C2 Coefficient Register MSB Color Space Conversion C2
 * coefficient. */
/*! @{ */
#define COLORSPACECONVERTER_CSC_COEF_C2_MSB_CSC_COEF_C2_MSB_MASK  (0xFFU)
#define COLORSPACECONVERTER_CSC_COEF_C2_MSB_CSC_COEF_C2_MSB_SHIFT (0U)
/*! csc_coef_c2_msb - Color Space Converter Matrix C2 Coefficient Register MSB
 */
#define COLORSPACECONVERTER_CSC_COEF_C2_MSB_CSC_COEF_C2_MSB(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_COEF_C2_MSB_CSC_COEF_C2_MSB_SHIFT)) & \
     COLORSPACECONVERTER_CSC_COEF_C2_MSB_CSC_COEF_C2_MSB_MASK)
/*! @} */

/*! @name CSC_COEF_C2_LSB - Color Space Converter Matrix C2 Coefficient Register LSB Color Space Conversion C2
 * coefficient. */
/*! @{ */
#define COLORSPACECONVERTER_CSC_COEF_C2_LSB_CSC_COEF_C2_LSB_MASK  (0xFFU)
#define COLORSPACECONVERTER_CSC_COEF_C2_LSB_CSC_COEF_C2_LSB_SHIFT (0U)
/*! csc_coef_c2_lsb - Color Space Converter Matrix C2 Coefficient Register LSB
 */
#define COLORSPACECONVERTER_CSC_COEF_C2_LSB_CSC_COEF_C2_LSB(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_COEF_C2_LSB_CSC_COEF_C2_LSB_SHIFT)) & \
     COLORSPACECONVERTER_CSC_COEF_C2_LSB_CSC_COEF_C2_LSB_MASK)
/*! @} */

/*! @name CSC_COEF_C3_MSB - Color Space Converter Matrix C3 Coefficient Register MSB Color Space Conversion C3
 * coefficient. */
/*! @{ */
#define COLORSPACECONVERTER_CSC_COEF_C3_MSB_CSC_COEF_C3_MSB_MASK  (0xFFU)
#define COLORSPACECONVERTER_CSC_COEF_C3_MSB_CSC_COEF_C3_MSB_SHIFT (0U)
/*! csc_coef_c3_msb - Color Space Converter Matrix C3 Coefficient Register MSB
 */
#define COLORSPACECONVERTER_CSC_COEF_C3_MSB_CSC_COEF_C3_MSB(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_COEF_C3_MSB_CSC_COEF_C3_MSB_SHIFT)) & \
     COLORSPACECONVERTER_CSC_COEF_C3_MSB_CSC_COEF_C3_MSB_MASK)
/*! @} */

/*! @name CSC_COEF_C3_LSB - Color Space Converter Matrix C3 Coefficient Register LSB Color Space Conversion C3
 * coefficient. */
/*! @{ */
#define COLORSPACECONVERTER_CSC_COEF_C3_LSB_CSC_COEF_C3_LSB_MASK  (0xFFU)
#define COLORSPACECONVERTER_CSC_COEF_C3_LSB_CSC_COEF_C3_LSB_SHIFT (0U)
/*! csc_coef_c3_lsb - Color Space Converter Matrix C3 Coefficient Register LSB
 */
#define COLORSPACECONVERTER_CSC_COEF_C3_LSB_CSC_COEF_C3_LSB(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_COEF_C3_LSB_CSC_COEF_C3_LSB_SHIFT)) & \
     COLORSPACECONVERTER_CSC_COEF_C3_LSB_CSC_COEF_C3_LSB_MASK)
/*! @} */

/*! @name CSC_COEF_C4_MSB - Color Space Converter Matrix C4 Coefficient Register MSB Color Space Conversion C4
 * coefficient. */
/*! @{ */
#define COLORSPACECONVERTER_CSC_COEF_C4_MSB_CSC_COEF_C4_MSB_MASK  (0xFFU)
#define COLORSPACECONVERTER_CSC_COEF_C4_MSB_CSC_COEF_C4_MSB_SHIFT (0U)
/*! csc_coef_c4_msb - Color Space Converter Matrix C4 Coefficient Register MSB
 */
#define COLORSPACECONVERTER_CSC_COEF_C4_MSB_CSC_COEF_C4_MSB(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_COEF_C4_MSB_CSC_COEF_C4_MSB_SHIFT)) & \
     COLORSPACECONVERTER_CSC_COEF_C4_MSB_CSC_COEF_C4_MSB_MASK)
/*! @} */

/*! @name CSC_COEF_C4_LSB - Color Space Converter Matrix C4 Coefficient Register LSB Color Space Conversion C4
 * coefficient. */
/*! @{ */
#define COLORSPACECONVERTER_CSC_COEF_C4_LSB_CSC_COEF_C4_LSB_MASK  (0xFFU)
#define COLORSPACECONVERTER_CSC_COEF_C4_LSB_CSC_COEF_C4_LSB_SHIFT (0U)
/*! csc_coef_c4_lsb - Color Space Converter Matrix C4 Coefficient Register LSB
 */
#define COLORSPACECONVERTER_CSC_COEF_C4_LSB_CSC_COEF_C4_LSB(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_COEF_C4_LSB_CSC_COEF_C4_LSB_SHIFT)) & \
     COLORSPACECONVERTER_CSC_COEF_C4_LSB_CSC_COEF_C4_LSB_MASK)
/*! @} */

/*! @name CSC_LIMIT_UP_MSB - Color Space Converter Matrix Output Up Limit Register MSB For more details, refer to the
 * HDMI 1. */
/*! @{ */
#define COLORSPACECONVERTER_CSC_LIMIT_UP_MSB_CSC_LIMIT_UP_MSB_MASK  (0xFFU)
#define COLORSPACECONVERTER_CSC_LIMIT_UP_MSB_CSC_LIMIT_UP_MSB_SHIFT (0U)
/*! csc_limit_up_msb - Color Space Converter Matrix Output Upper Limit Register MSB
 */
#define COLORSPACECONVERTER_CSC_LIMIT_UP_MSB_CSC_LIMIT_UP_MSB(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_LIMIT_UP_MSB_CSC_LIMIT_UP_MSB_SHIFT)) & \
     COLORSPACECONVERTER_CSC_LIMIT_UP_MSB_CSC_LIMIT_UP_MSB_MASK)
/*! @} */

/*! @name CSC_LIMIT_UP_LSB - Color Space Converter Matrix output Up Limit Register LSB For more details, refer to the
 * HDMI 1. */
/*! @{ */
#define COLORSPACECONVERTER_CSC_LIMIT_UP_LSB_CSC_LIMIT_UP_LSB_MASK  (0xFFU)
#define COLORSPACECONVERTER_CSC_LIMIT_UP_LSB_CSC_LIMIT_UP_LSB_SHIFT (0U)
/*! csc_limit_up_lsb - Color Space Converter Matrix Output Upper Limit Register LSB
 */
#define COLORSPACECONVERTER_CSC_LIMIT_UP_LSB_CSC_LIMIT_UP_LSB(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_LIMIT_UP_LSB_CSC_LIMIT_UP_LSB_SHIFT)) & \
     COLORSPACECONVERTER_CSC_LIMIT_UP_LSB_CSC_LIMIT_UP_LSB_MASK)
/*! @} */

/*! @name CSC_LIMIT_DN_MSB - Color Space Converter Matrix output Down Limit Register MSB For more details, refer to the
 * HDMI 1. */
/*! @{ */
#define COLORSPACECONVERTER_CSC_LIMIT_DN_MSB_CSC_LIMIT_DN_MSB_MASK  (0xFFU)
#define COLORSPACECONVERTER_CSC_LIMIT_DN_MSB_CSC_LIMIT_DN_MSB_SHIFT (0U)
/*! csc_limit_dn_msb - Color Space Converter Matrix output Down Limit Register MSB
 */
#define COLORSPACECONVERTER_CSC_LIMIT_DN_MSB_CSC_LIMIT_DN_MSB(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_LIMIT_DN_MSB_CSC_LIMIT_DN_MSB_SHIFT)) & \
     COLORSPACECONVERTER_CSC_LIMIT_DN_MSB_CSC_LIMIT_DN_MSB_MASK)
/*! @} */

/*! @name CSC_LIMIT_DN_LSB - Color Space Converter Matrix output Down Limit Register LSB For more details, refer to the
 * HDMI 1. */
/*! @{ */
#define COLORSPACECONVERTER_CSC_LIMIT_DN_LSB_CSC_LIMIT_DN_LSB_MASK  (0xFFU)
#define COLORSPACECONVERTER_CSC_LIMIT_DN_LSB_CSC_LIMIT_DN_LSB_SHIFT (0U)
/*! csc_limit_dn_lsb - Color Space Converter Matrix Output Down Limit Register LSB
 */
#define COLORSPACECONVERTER_CSC_LIMIT_DN_LSB_CSC_LIMIT_DN_LSB(x)                                  \
    (((uint8_t)(((uint8_t)(x)) << COLORSPACECONVERTER_CSC_LIMIT_DN_LSB_CSC_LIMIT_DN_LSB_SHIFT)) & \
     COLORSPACECONVERTER_CSC_LIMIT_DN_LSB_CSC_LIMIT_DN_LSB_MASK)
/*! @} */

/*!
 * @}
 */ /* end of group COLORSPACECONVERTER_Register_Masks */

/* COLORSPACECONVERTER - Peripheral instance base addresses */
/** Peripheral COLORSPACECONVERTER base address */
#define COLORSPACECONVERTER_BASE (0x32FDC100u)
/** Peripheral COLORSPACECONVERTER base pointer */
#define COLORSPACECONVERTER ((COLORSPACECONVERTER_Type *)COLORSPACECONVERTER_BASE)
/** Array initializer of COLORSPACECONVERTER peripheral base addresses */
#define COLORSPACECONVERTER_BASE_ADDRS \
    {                                  \
        COLORSPACECONVERTER_BASE       \
    }
/** Array initializer of COLORSPACECONVERTER peripheral base pointers */
#define COLORSPACECONVERTER_BASE_PTRS \
    {                                 \
        COLORSPACECONVERTER           \
    }

/*!
 * @}
 */ /* end of group COLORSPACECONVERTER_Peripheral_Access_Layer */

/* ----------------------------------------------------------------------------
   -- DDRC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DDRC_Peripheral_Access_Layer DDRC Peripheral Access Layer
 * @{
 */

/** DDRC - Register Layout Typedef */
typedef struct
{
    __IO uint32_t MSTR;      /**< Master Register0, offset: 0x0 */
    __I uint32_t STAT;       /**< Operating Mode Status Register, offset: 0x4 */
    __IO uint32_t MSTR1;     /**< Operating Mode Status Register, offset: 0x8 */
    __IO uint32_t MRCTRL3;   /**< Operating Mode Status Register, offset: 0xC */
    __IO uint32_t MRCTRL0;   /**< Mode Register Read/Write Control Register 0., offset: 0x10 */
    __IO uint32_t MRCTRL1;   /**< Mode Register Read/Write Control Register 1, offset: 0x14 */
    __I uint32_t MRSTAT;     /**< Mode Register Read/Write Status Register, offset: 0x18 */
    __IO uint32_t MRCTRL2;   /**< Mode Register Read/Write Control Register 2, offset: 0x1C */
    __IO uint32_t DERATEEN;  /**< Temperature Derate Enable Register, offset: 0x20 */
    __IO uint32_t DERATEINT; /**< Temperature Derate Interval Register, offset: 0x24 */
    uint8_t RESERVED_0[8];
    __IO uint32_t PWRCTL;  /**< Low Power Control Register, offset: 0x30 */
    __IO uint32_t PWRTMG;  /**< Low Power Timing Register, offset: 0x34 */
    __IO uint32_t HWLPCTL; /**< Hardware Low Power Control Register, offset: 0x38 */
    uint8_t RESERVED_1[20];
    __IO uint32_t RFSHCTL0; /**< Refresh Control Register 0, offset: 0x50 */
    __IO uint32_t RFSHCTL1; /**< Refresh Control Register 1, offset: 0x54 */
    uint8_t RESERVED_2[8];
    __IO uint32_t RFSHCTL3; /**< Refresh Control Register 3, offset: 0x60 */
    __IO uint32_t RFSHTMG;  /**< Refresh Timing Register, offset: 0x64 */
    uint8_t RESERVED_3[8];
    __IO uint32_t ECCCFG0; /**< ECC Configuration Register 0, offset: 0x70 */
    __IO uint32_t ECCCFG1; /**< ECC Configuration Register 1, offset: 0x74 */
    uint8_t RESERVED_4[88];
    __IO uint32_t INIT0;   /**< SDRAM Initialization Register 0, offset: 0xD0 */
    __IO uint32_t INIT1;   /**< SDRAM Initialization Register 1, offset: 0xD4 */
    __IO uint32_t INIT2;   /**< SDRAM Initialization Register 2, offset: 0xD8 */
    __IO uint32_t INIT3;   /**< SDRAM Initialization Register 3, offset: 0xDC */
    __IO uint32_t INIT4;   /**< SDRAM Initialization Register 4, offset: 0xE0 */
    __IO uint32_t INIT5;   /**< SDRAM Initialization Register 5, offset: 0xE4 */
    __IO uint32_t INIT6;   /**< SDRAM Initialization Register 6, offset: 0xE8 */
    __IO uint32_t INIT7;   /**< SDRAM Initialization Register 7, offset: 0xEC */
    __IO uint32_t DIMMCTL; /**< DIMM Control Register, offset: 0xF0 */
    __IO uint32_t RANKCTL; /**< Rank Control Register, offset: 0xF4 */
    uint8_t RESERVED_5[8];
    __IO uint32_t DRAMTMG0;  /**< SDRAM Timing Register 0, offset: 0x100 */
    __IO uint32_t DRAMTMG1;  /**< SDRAM Timing Register 1, offset: 0x104 */
    __IO uint32_t DRAMTMG2;  /**< SDRAM Timing Register 2, offset: 0x108 */
    __IO uint32_t DRAMTMG3;  /**< SDRAM Timing Register 3, offset: 0x10C */
    __IO uint32_t DRAMTMG4;  /**< SDRAM Timing Register 4, offset: 0x110 */
    __IO uint32_t DRAMTMG5;  /**< SDRAM Timing Register 5, offset: 0x114 */
    __IO uint32_t DRAMTMG6;  /**< SDRAM Timing Register 6, offset: 0x118 */
    __IO uint32_t DRAMTMG7;  /**< SDRAM Timing Register 7, offset: 0x11C */
    __IO uint32_t DRAMTMG8;  /**< SDRAM Timing Register 8, offset: 0x120 */
    __IO uint32_t DRAMTMG9;  /**< SDRAM Timing Register 9, offset: 0x124 */
    __IO uint32_t DRAMTMG10; /**< SDRAM Timing Register 10, offset: 0x128 */
    __IO uint32_t DRAMTMG11; /**< SDRAM Timing Register 11, offset: 0x12C */
    __IO uint32_t DRAMTMG12; /**< SDRAM Timing Register 12, offset: 0x130 */
    __IO uint32_t DRAMTMG13; /**< SDRAM Timing Register 13, offset: 0x134 */
    __IO uint32_t DRAMTMG14; /**< SDRAM Timing Register 14, offset: 0x138 */
    __IO uint32_t DRAMTMG15; /**< SDRAM Timing Register 15, offset: 0x13C */
    uint8_t RESERVED_6[64];
    __IO uint32_t ZQCTL0;    /**< ZQ Control Register 0, offset: 0x180 */
    __IO uint32_t ZQCTL1;    /**< ZQ Control Register 1, offset: 0x184 */
    __IO uint32_t ZQCTL2;    /**< ZQ Control Register 2, offset: 0x188 */
    __I uint32_t ZQSTAT;     /**< ZQ Status Register, offset: 0x18C */
    __IO uint32_t DFITMG0;   /**< DFI Timing Register 0, offset: 0x190 */
    __IO uint32_t DFITMG1;   /**< DFI Timing Register 1, offset: 0x194 */
    __IO uint32_t DFILPCFG0; /**< DFI Low Power Configuration Register 0, offset: 0x198 */
    __IO uint32_t DFILPCFG1; /**< DFI Low Power Configuration Register 1, offset: 0x19C */
    __IO uint32_t DFIUPD0;   /**< DFI Update Register 0, offset: 0x1A0 */
    __IO uint32_t DFIUPD1;   /**< DFI Update Register 1, offset: 0x1A4 */
    __IO uint32_t DFIUPD2;   /**< DFI Update Register 2, offset: 0x1A8 */
    uint8_t RESERVED_7[4];
    __IO uint32_t DFIMISC; /**< DFI Miscellaneous Control Register, offset: 0x1B0 */
    __IO uint32_t DFITMG2; /**< DFI Timing Register 2, offset: 0x1B4 */
    __IO uint32_t DFITMG3; /**< DFI Timing Register 3, offset: 0x1B8 */
    __I uint32_t DFISTAT;  /**< DFI Status Register, offset: 0x1BC */
    __IO uint32_t DBICTL;  /**< DM/DBI Control Register, offset: 0x1C0 */
    uint8_t RESERVED_8[60];
    __IO uint32_t ADDRMAP0;  /**< Address Map Register 0, offset: 0x200 */
    __IO uint32_t ADDRMAP1;  /**< Address Map Register 1, offset: 0x204 */
    __IO uint32_t ADDRMAP2;  /**< Address Map Register 2, offset: 0x208 */
    __IO uint32_t ADDRMAP3;  /**< Address Map Register 3, offset: 0x20C */
    __IO uint32_t ADDRMAP4;  /**< Address Map Register 4, offset: 0x210 */
    __IO uint32_t ADDRMAP5;  /**< Address Map Register 5, offset: 0x214 */
    __IO uint32_t ADDRMAP6;  /**< Address Map Register 6, offset: 0x218 */
    __IO uint32_t ADDRMAP7;  /**< Address Map Register 7, offset: 0x21C */
    __IO uint32_t ADDRMAP8;  /**< Address Map Register 8, offset: 0x220 */
    __IO uint32_t ADDRMAP9;  /**< Address Map Register 9, offset: 0x224 */
    __IO uint32_t ADDRMAP10; /**< Address Map Register 10, offset: 0x228 */
    __IO uint32_t ADDRMAP11; /**< Address Map Register 11, offset: 0x22C */
    uint8_t RESERVED_9[16];
    __IO uint32_t ODTCFG; /**< ODT Configuration Register, offset: 0x240 */
    __IO uint32_t ODTMAP; /**< ODT/Rank Map Register, offset: 0x244 */
    uint8_t RESERVED_10[8];
    __IO uint32_t SCHED;  /**< Scheduler Control Register, offset: 0x250 */
    __IO uint32_t SCHED1; /**< Scheduler Control Register 1, offset: 0x254 */
    uint8_t RESERVED_11[4];
    __IO uint32_t PERFHPR1; /**< High Priority Read CAM Register 1, offset: 0x25C */
    uint8_t RESERVED_12[4];
    __IO uint32_t PERFLPR1; /**< Low Priority Read CAM Register 1, offset: 0x264 */
    uint8_t RESERVED_13[4];
    __IO uint32_t PERFWR1; /**< Write CAM Register 1, offset: 0x26C */
    uint8_t RESERVED_14[144];
    __IO uint32_t DBG0;   /**< Debug Register 0, offset: 0x300 */
    __IO uint32_t DBG1;   /**< Debug Register 1, offset: 0x304 */
    __I uint32_t DBGCAM;  /**< CAM Debug Register, offset: 0x308 */
    __IO uint32_t DBGCMD; /**< Command Debug Register, offset: 0x30C */
    __I uint32_t DBGSTAT; /**< Status Debug Register, offset: 0x310 */
    uint8_t RESERVED_15[12];
    __IO uint32_t SWCTL; /**< Software Register Programming Control Enable, offset: 0x320 */
    __I uint32_t SWSTAT; /**< Software Register Programming Control Status, offset: 0x324 */
    uint8_t RESERVED_16[68];
    __IO uint32_t POISONCFG; /**< AXI Poison Configuration Register., offset: 0x36C */
    __I uint32_t POISONSTAT; /**< AXI Poison Status Register, offset: 0x370 */
    uint8_t RESERVED_17[136];
    __I uint32_t PSTAT;    /**< Port Status Register, offset: 0x3FC */
    __IO uint32_t PCCFG;   /**< Port Common Configuration Register, offset: 0x400 */
    __IO uint32_t PCFGR_0; /**< Port n Configuration Read Register, offset: 0x404 */
    __IO uint32_t PCFGW_0; /**< Port n Configuration Write Register, offset: 0x408 */
    uint8_t RESERVED_18[132];
    __IO uint32_t PCTRL_0;     /**< Port n Control Register, offset: 0x490 */
    __IO uint32_t PCFGQOS0_0;  /**< Port n Read QoS Configuration Register 0, offset: 0x494 */
    __IO uint32_t PCFGQOS1_0;  /**< Port n Read QoS Configuration Register 1, offset: 0x498 */
    __IO uint32_t PCFGWQOS0_0; /**< Port n Write QoS Configuration Register 0, offset: 0x49C */
    __IO uint32_t PCFGWQOS1_0; /**< Port n Write QoS Configuration Register 1, offset: 0x4A0 */
    uint8_t RESERVED_19[7036];
    __IO uint32_t DERATEEN_SHADOW;  /**< [SHADOW] Temperature Derate Enable Register, offset: 0x2020 */
    __IO uint32_t DERATEINT_SHADOW; /**< [SHADOW] Temperature Derate Interval Register, offset: 0x2024 */
    uint8_t RESERVED_20[40];
    __IO uint32_t RFSHCTL0_SHADOW; /**< [SHADOW] Refresh Control Register 0, offset: 0x2050 */
    uint8_t RESERVED_21[16];
    __IO uint32_t RFSHTMG_SHADOW; /**< [SHADOW] Refresh Timing Register, offset: 0x2064 */
    uint8_t RESERVED_22[116];
    __IO uint32_t INIT3_SHADOW; /**< [SHADOW] SDRAM Initialization Register 3, offset: 0x20DC */
    __IO uint32_t INIT4_SHADOW; /**< [SHADOW] SDRAM Initialization Register 4, offset: 0x20E0 */
    uint8_t RESERVED_23[4];
    __IO uint32_t INIT6_SHADOW; /**< [SHADOW] SDRAM Initialization Register 6, offset: 0x20E8 */
    __IO uint32_t INIT7_SHADOW; /**< [SHADOW] SDRAM Initialization Register 7, offset: 0x20EC */
    uint8_t RESERVED_24[16];
    __IO uint32_t DRAMTMG0_SHADOW;  /**< [SHADOW] SDRAM Timing Register 0, offset: 0x2100 */
    __IO uint32_t DRAMTMG1_SHADOW;  /**< [SHADOW] SDRAM Timing Register 1, offset: 0x2104 */
    __IO uint32_t DRAMTMG2_SHADOW;  /**< [SHADOW] SDRAM Timing Register 2, offset: 0x2108 */
    __IO uint32_t DRAMTMG3_SHADOW;  /**< [SHADOW] SDRAM Timing Register 3, offset: 0x210C */
    __IO uint32_t DRAMTMG4_SHADOW;  /**< [SHADOW] SDRAM Timing Register 4, offset: 0x2110 */
    __IO uint32_t DRAMTMG5_SHADOW;  /**< [SHADOW] SDRAM Timing Register 5, offset: 0x2114 */
    __IO uint32_t DRAMTMG6_SHADOW;  /**< [SHADOW] SDRAM Timing Register 6, offset: 0x2118 */
    __IO uint32_t DRAMTMG7_SHADOW;  /**< [SHADOW] SDRAM Timing Register 7, offset: 0x211C */
    __IO uint32_t DRAMTMG8_SHADOW;  /**< [SHADOW] SDRAM Timing Register 8, offset: 0x2120 */
    __IO uint32_t DRAMTMG9_SHADOW;  /**< [SHADOW] SDRAM Timing Register 9, offset: 0x2124 */
    __IO uint32_t DRAMTMG10_SHADOW; /**< [SHADOW] SDRAM Timing Register 10, offset: 0x2128 */
    __IO uint32_t DRAMTMG11_SHADOW; /**< [SHADOW] SDRAM Timing Register 11, offset: 0x212C */
    __IO uint32_t DRAMTMG12_SHADOW; /**< [SHADOW] SDRAM Timing Register 12, offset: 0x2130 */
    __IO uint32_t DRAMTMG13_SHADOW; /**< [SHADOW] SDRAM Timing Register 13, offset: 0x2134 */
    __IO uint32_t DRAMTMG14_SHADOW; /**< [SHADOW] SDRAM Timing Register 14, offset: 0x2138 */
    __IO uint32_t DRAMTMG15_SHADOW; /**< [SHADOW] SDRAM Timing Register 15, offset: 0x213C */
    uint8_t RESERVED_25[64];
    __IO uint32_t ZQCTL0_SHADOW; /**< [SHADOW] ZQ Control Register 0, offset: 0x2180 */
    uint8_t RESERVED_26[12];
    __IO uint32_t DFITMG0_SHADOW; /**< [SHADOW] DFI Timing Register 0, offset: 0x2190 */
    __IO uint32_t DFITMG1_SHADOW; /**< [SHADOW] DFI Timing Register 1, offset: 0x2194 */
    uint8_t RESERVED_27[28];
    __IO uint32_t DFITMG2_SHADOW; /**< [SHADOW] DFI Timing Register 2, offset: 0x21B4 */
    __IO uint32_t DFITMG3_SHADOW; /**< [SHADOW] DFI Timing Register 3, offset: 0x21B8 */
    uint8_t RESERVED_28[132];
    __IO uint32_t ODTCFG_SHADOW; /**< [SHADOW] ODT Configuration Register, offset: 0x2240 */
} DDRC_Type;

/* ----------------------------------------------------------------------------
   -- DDRC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DDRC_Register_Masks DDRC Register Masks
 * @{
 */

/*! @name MSTR - Master Register0 */
/*! @{ */
#define DDRC_MSTR_DDR3_MASK  (0x1U)
#define DDRC_MSTR_DDR3_SHIFT (0U)
/*! ddr3 - Select DDR3 SDRAM - 1 - DDR3 SDRAM device in use - 0 - non-DDR3 SDRAM device in use Only
 *    present in designs that support DDR3.
 */
#define DDRC_MSTR_DDR3(x)      (((uint32_t)(((uint32_t)(x)) << DDRC_MSTR_DDR3_SHIFT)) & DDRC_MSTR_DDR3_MASK)
#define DDRC_MSTR_LPDDR2_MASK  (0x4U)
#define DDRC_MSTR_LPDDR2_SHIFT (2U)
/*! lpddr2 - Select LPDDR2 SDRAM - 1 - LPDDR2 SDRAM device in use. - 0 - non-LPDDR2 device in use
 *    Present only in designs configured to support LPDDR2.
 */
#define DDRC_MSTR_LPDDR2(x)    (((uint32_t)(((uint32_t)(x)) << DDRC_MSTR_LPDDR2_SHIFT)) & DDRC_MSTR_LPDDR2_MASK)
#define DDRC_MSTR_LPDDR3_MASK  (0x8U)
#define DDRC_MSTR_LPDDR3_SHIFT (3U)
/*! lpddr3 - Select LPDDR3 SDRAM - 1 - LPDDR3 SDRAM device in use. - 0 - non-LPDDR3 device in use
 *    Present only in designs configured to support LPDDR3.
 */
#define DDRC_MSTR_LPDDR3(x)  (((uint32_t)(((uint32_t)(x)) << DDRC_MSTR_LPDDR3_SHIFT)) & DDRC_MSTR_LPDDR3_MASK)
#define DDRC_MSTR_DDR4_MASK  (0x10U)
#define DDRC_MSTR_DDR4_SHIFT (4U)
/*! ddr4 - Select DDR4 SDRAM - 1 - DDR4 SDRAM device in use. - 0 - non-DDR4 device in use Present
 *    only in designs configured to support DDR4.
 */
#define DDRC_MSTR_DDR4(x)      (((uint32_t)(((uint32_t)(x)) << DDRC_MSTR_DDR4_SHIFT)) & DDRC_MSTR_DDR4_MASK)
#define DDRC_MSTR_LPDDR4_MASK  (0x20U)
#define DDRC_MSTR_LPDDR4_SHIFT (5U)
/*! lpddr4 - Select LPDDR4 SDRAM - 1 - LPDDR4 SDRAM device in use. - 0 - non-LPDDR4 device in use
 *    Present only in designs configured to support LPDDR4.
 */
#define DDRC_MSTR_LPDDR4(x)       (((uint32_t)(((uint32_t)(x)) << DDRC_MSTR_LPDDR4_SHIFT)) & DDRC_MSTR_LPDDR4_MASK)
#define DDRC_MSTR_BURSTCHOP_MASK  (0x200U)
#define DDRC_MSTR_BURSTCHOP_SHIFT (9U)
/*! burstchop - When set, enable burst-chop (BC4 or 8 on-the-fly) in DDR3/DDR4. Burst Chop for Reads
 *    is exercised only in HIF configurations (DDRC_INCL_ARB not set) and if in full bus width mode
 *    (MSTR.data_bus_width = 00) and if MEMC_BURST_LENGTH=8 or 16. Burst Chop for Writes is
 *    exercised only if Partial Writes enabled (DDRC_PARTIAL_WR=1) and if CRC is disabled
 *    (CRCPARCTL1.crc_enable = 0). If DDR4 CRC/parity retry is enabled (CRCPARCTL1.crc_parity_retry_enable = 1),
 *    burst chop is not supported, and this bit must be set to '0'. BC4 (fixed) mode is not supported.
 */
#define DDRC_MSTR_BURSTCHOP(x)            (((uint32_t)(((uint32_t)(x)) << DDRC_MSTR_BURSTCHOP_SHIFT)) & DDRC_MSTR_BURSTCHOP_MASK)
#define DDRC_MSTR_EN_2T_TIMING_MODE_MASK  (0x400U)
#define DDRC_MSTR_EN_2T_TIMING_MODE_SHIFT (10U)
/*! en_2t_timing_mode - If 1, then DDRC uses 2T timing. Otherwise, uses 1T timing. In 2T timing, all
 *    command signals (except chip select) are held for 2 clocks on the SDRAM bus. Chip select is
 *    asserted on the second cycle of the command Note: 2T timing is not supported in
 *    LPDDR2/LPDDR3/LPDDR4 mode Note: 2T timing is not supported if the configuration parameter MEMC_CMD_RTN2IDLE
 *    is set Note: 2T timing is not supported in DDR4 geardown mode. Note: 2T timing is not supported
 *    in Shared-AC dual channel mode and the register value is don't care.
 */
#define DDRC_MSTR_EN_2T_TIMING_MODE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_MSTR_EN_2T_TIMING_MODE_SHIFT)) & DDRC_MSTR_EN_2T_TIMING_MODE_MASK)
#define DDRC_MSTR_GEARDOWN_MODE_MASK  (0x800U)
#define DDRC_MSTR_GEARDOWN_MODE_SHIFT (11U)
/*! geardown_mode - 1 indicates put the DRAM in geardown mode (2N) and 0 indicates put the DRAM in
 *    normal mode (1N). This register can be changed, only when the Controller is in self-refresh
 *    mode. This signal must be set the same value as MR3 bit A3. Note: Geardown mode is not supported
 *    if the configuration parameter MEMC_CMD_RTN2IDLE is set Note: Geardown mode is not supported
 *    if the configuration parameter DDRC_SHARED_AC is set (in Shared-AC mode) and the register value
 *    is don't care
 */
#define DDRC_MSTR_GEARDOWN_MODE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_MSTR_GEARDOWN_MODE_SHIFT)) & DDRC_MSTR_GEARDOWN_MODE_MASK)
#define DDRC_MSTR_DATA_BUS_WIDTH_MASK  (0x3000U)
#define DDRC_MSTR_DATA_BUS_WIDTH_SHIFT (12U)
/*! data_bus_width - Selects proportion of DQ bus width that is used by the SDRAM - 00 - Full DQ bus
 *    width to SDRAM - 01 - Half DQ bus width to SDRAM - 10 - Quarter DQ bus width to SDRAM - 11 -
 *    Reserved. Note that half bus width mode is only supported when the SDRAM bus width is a
 *    multiple of 16, and quarter bus width mode is only supported when the SDRAM bus width is a multiple
 *    of 32 and the configuration parameter MEMC_QBUS_SUPPORT is set. Bus width refers to DQ bus
 *    width (excluding any ECC width).
 */
#define DDRC_MSTR_DATA_BUS_WIDTH(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_MSTR_DATA_BUS_WIDTH_SHIFT)) & DDRC_MSTR_DATA_BUS_WIDTH_MASK)
#define DDRC_MSTR_DLL_OFF_MODE_MASK  (0x8000U)
#define DDRC_MSTR_DLL_OFF_MODE_SHIFT (15U)
/*! dll_off_mode - Set to 1 when the DDRC and DRAM has to be put in DLL-off mode for low frequency
 *    operation. Set to 0 to put DDRC and DRAM in DLL-on mode for normal frequency operation. If DDR4
 *    CRC/parity retry is enabled (CRCPARCTL1.crc_parity_retry_enable = 1), dll_off_mode is not
 *    supported, and this bit must be set to '0'.
 */
#define DDRC_MSTR_DLL_OFF_MODE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_MSTR_DLL_OFF_MODE_SHIFT)) & DDRC_MSTR_DLL_OFF_MODE_MASK)
#define DDRC_MSTR_BURST_RDWR_MASK  (0xF0000U)
#define DDRC_MSTR_BURST_RDWR_SHIFT (16U)
/*! burst_rdwr - SDRAM burst length used
 *  0b0001..Burst length of 2 (only supported for mDDR)
 *  0b0010..Burst length of 4
 *  0b0100..Burst length of 8
 *  0b1000..Burst length of 16 (only supported for mDDR, LPDDR2, and LPDDR4)
 */
#define DDRC_MSTR_BURST_RDWR(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_MSTR_BURST_RDWR_SHIFT)) & DDRC_MSTR_BURST_RDWR_MASK)
#define DDRC_MSTR_FREQUENCY_RATIO_MASK  (0x400000U)
#define DDRC_MSTR_FREQUENCY_RATIO_SHIFT (22U)
/*! frequency_ratio - Selects the Frequency Ratio
 *  0b0..1:2 Mode
 *  0b1..1:1 Mode
 */
#define DDRC_MSTR_FREQUENCY_RATIO(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_MSTR_FREQUENCY_RATIO_SHIFT)) & DDRC_MSTR_FREQUENCY_RATIO_MASK)
#define DDRC_MSTR_ACTIVE_RANKS_MASK  (0x3000000U)
#define DDRC_MSTR_ACTIVE_RANKS_SHIFT (24U)
/*! active_ranks - Only present for multi-rank configurations. Each bit represents one rank. For
 *    two-rank configurations, only bits[25:24] are present.
 */
#define DDRC_MSTR_ACTIVE_RANKS(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_MSTR_ACTIVE_RANKS_SHIFT)) & DDRC_MSTR_ACTIVE_RANKS_MASK)
#define DDRC_MSTR_FREQUENCY_MODE_MASK  (0x20000000U)
#define DDRC_MSTR_FREQUENCY_MODE_SHIFT (29U)
/*! frequency_mode - Choose which registers are used.
 *  0b0..Original Registers
 *  0b1..Shadow Registers
 */
#define DDRC_MSTR_FREQUENCY_MODE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_MSTR_FREQUENCY_MODE_SHIFT)) & DDRC_MSTR_FREQUENCY_MODE_MASK)
#define DDRC_MSTR_DEVICE_CONFIG_MASK  (0xC0000000U)
#define DDRC_MSTR_DEVICE_CONFIG_SHIFT (30U)
/*! device_config - Indicates the configuration of the device used in the system.
 *  0b00..x4 device
 *  0b01..x8 device
 *  0b10..x16 device
 *  0b11..x32 device
 */
#define DDRC_MSTR_DEVICE_CONFIG(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_MSTR_DEVICE_CONFIG_SHIFT)) & DDRC_MSTR_DEVICE_CONFIG_MASK)
/*! @} */

/*! @name STAT - Operating Mode Status Register */
/*! @{ */
#define DDRC_STAT_OPERATING_MODE_MASK  (0x7U)
#define DDRC_STAT_OPERATING_MODE_SHIFT (0U)
/*! operating_mode - Operating mode
 */
#define DDRC_STAT_OPERATING_MODE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_STAT_OPERATING_MODE_SHIFT)) & DDRC_STAT_OPERATING_MODE_MASK)
#define DDRC_STAT_SELFREF_TYPE_MASK  (0x30U)
#define DDRC_STAT_SELFREF_TYPE_SHIFT (4U)
/*! selfref_type - Flags if Self Refresh (except LPDDR4) or SR-Powerdown (LPDDR4) is entered and if
 *    it was under Automatic Self Refresh control only or not.
 *  0b00..SDRAM is not in Self Refresh (except LPDDR4) or SR-Powerdown (LPDDR4). If retry is enabled by
 *        CRCPARCTRL1.crc_parity_retry_enable, this also indicates SRE command is still in parity error window or retry
 * is in-progress. 0b11..SDRAM is in Self Refresh (except LPDDR4) or SR-Powerdown (LPDDR4), which was caused by
 * Automatic Self Refresh only. If retry is enabled, this guarantees SRE command is executed correctly without parity
 * error. 0b10..SDRAM is in Self Refresh (except LPDDR4) or SR-Powerdown (LPDDR4), which was not caused solely under
 *        Automatic Self Refresh control. It could have been caused by Hardware Low Power Interface and/or Software
 *        (reg_ddrc_selfref_sw). If retry is enabled, this guarantees SRE command is executed correctly without parity
 */
#define DDRC_STAT_SELFREF_TYPE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_STAT_SELFREF_TYPE_SHIFT)) & DDRC_STAT_SELFREF_TYPE_MASK)
#define DDRC_STAT_SELFREF_STATE_MASK  (0x300U)
#define DDRC_STAT_SELFREF_STATE_SHIFT (8U)
/*! selfref_state - Self refresh state. This indicates self refresh or self refresh power down state
 *    for LPDDR4. This register is used for frequency change and MRR/MRW access during self refresh.
 *  0b00..SDRAM is not in Self Refresh.
 *  0b01..Self refresh 1
 *  0b10..Self refresh power down
 *  0b11..Self refresh
 */
#define DDRC_STAT_SELFREF_STATE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_STAT_SELFREF_STATE_SHIFT)) & DDRC_STAT_SELFREF_STATE_MASK)
/*! @} */

/*! @name MSTR1 - Operating Mode Status Register */
/*! @{ */
#define DDRC_MSTR1_RANK_TMGREG_SEL_MASK  (0x3U)
#define DDRC_MSTR1_RANK_TMGREG_SEL_SHIFT (0U)
/*! rank_tmgreg_sel - rank_tmgreg_sel
 *  0b00..USE DRAMTMGx registers for the rank
 *  0b01..USE MRAMTMGx registers for the rank
 */
#define DDRC_MSTR1_RANK_TMGREG_SEL(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_MSTR1_RANK_TMGREG_SEL_SHIFT)) & DDRC_MSTR1_RANK_TMGREG_SEL_MASK)
#define DDRC_MSTR1_ALT_ADDRMAP_EN_MASK  (0x10000U)
#define DDRC_MSTR1_ALT_ADDRMAP_EN_SHIFT (16U)
/*! alt_addrmap_en - Enable Alternative Address Map
 *  0b0..Disable Alternative Address Map
 *  0b1..Enable Alternative Address Map
 */
#define DDRC_MSTR1_ALT_ADDRMAP_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_MSTR1_ALT_ADDRMAP_EN_SHIFT)) & DDRC_MSTR1_ALT_ADDRMAP_EN_MASK)
/*! @} */

/*! @name MRCTRL3 - Operating Mode Status Register */
/*! @{ */
#define DDRC_MRCTRL3_MR_RANK_SEL_MASK  (0x3U)
#define DDRC_MRCTRL3_MR_RANK_SEL_SHIFT (0U)
/*! mr_rank_sel - mr_rank_sel
 */
#define DDRC_MRCTRL3_MR_RANK_SEL(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_MRCTRL3_MR_RANK_SEL_SHIFT)) & DDRC_MRCTRL3_MR_RANK_SEL_MASK)
/*! @} */

/*! @name MRCTRL0 - Mode Register Read/Write Control Register 0. */
/*! @{ */
#define DDRC_MRCTRL0_MR_TYPE_MASK  (0x1U)
#define DDRC_MRCTRL0_MR_TYPE_SHIFT (0U)
/*! mr_type - Indicates whether the mode register operation is read or write. Only used for LPDDR2/LPDDR3/LPDDR4/DDR4.
 *  0b0..Write
 *  0b1..Read
 */
#define DDRC_MRCTRL0_MR_TYPE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_MRCTRL0_MR_TYPE_SHIFT)) & DDRC_MRCTRL0_MR_TYPE_MASK)
#define DDRC_MRCTRL0_MPR_EN_MASK  (0x2U)
#define DDRC_MRCTRL0_MPR_EN_SHIFT (1U)
/*! mpr_en - Indicates whether the mode register operation is MRS or WR/RD for MPR (only supported for DDR4).
 *  0b0..MRS
 *  0b1..WR/RD for MPR
 */
#define DDRC_MRCTRL0_MPR_EN(x)    (((uint32_t)(((uint32_t)(x)) << DDRC_MRCTRL0_MPR_EN_SHIFT)) & DDRC_MRCTRL0_MPR_EN_MASK)
#define DDRC_MRCTRL0_PDA_EN_MASK  (0x4U)
#define DDRC_MRCTRL0_PDA_EN_SHIFT (2U)
/*! pda_en - Indicates whether the mode register operation is MRS in PDA mode or not. Note that when
 *    pba_mode=1, PBA access is initiated instead of PDA access.
 *  0b0..MRS
 *  0b1..MRS in Per DRAM Addressability
 */
#define DDRC_MRCTRL0_PDA_EN(x)         (((uint32_t)(((uint32_t)(x)) << DDRC_MRCTRL0_PDA_EN_SHIFT)) & DDRC_MRCTRL0_PDA_EN_MASK)
#define DDRC_MRCTRL0_SW_INIT_INT_MASK  (0x8U)
#define DDRC_MRCTRL0_SW_INIT_INT_SHIFT (3U)
/*! sw_init_int - Indicates whether Software intervention is allowed via MRCTRL0/MRCTRL1 before
 *    automatic SDRAM initialization routine or not. For DDR4, this bit can be used to initialize the
 *    DDR4 RCD (MR7) before automatic SDRAM initialization. For LPDDR4, this bit can be used to
 *    program additional mode registers before automatic SDRAM initialization if necessary. In LPDDR4
 *    independent channel mode, note that this must be programmed to both channels beforehand. Note that
 *    this must be cleared to 0 after completing Software operation. Otherwise, SDRAM
 *    initialization routine will not re-start.
 *  0b0..Software intervention is not allowed
 *  0b1..Software intervention is allowed
 */
#define DDRC_MRCTRL0_SW_INIT_INT(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_MRCTRL0_SW_INIT_INT_SHIFT)) & DDRC_MRCTRL0_SW_INIT_INT_MASK)
#define DDRC_MRCTRL0_MR_RANK_MASK  (0x30U)
#define DDRC_MRCTRL0_MR_RANK_SHIFT (4U)
/*! mr_rank - Controls which rank is accessed by MRCTRL0.mr_wr. Normally, it is desired to access
 *    all ranks, so all bits should be set to 1. However, for multi-rank UDIMMs/RDIMMs/LRDIMMs which
 *    implement address mirroring, it may be necessary to access ranks individually. Examples (assume
 *    DDRC is configured for 4 ranks): 0x1 - select rank 0 only 0x2 - select rank 1 only 0x5 -
 *    select ranks 0 and 2 0xA - select ranks 1 and 3 0xF - select ranks 0, 1, 2 and 3
 */
#define DDRC_MRCTRL0_MR_RANK(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_MRCTRL0_MR_RANK_SHIFT)) & DDRC_MRCTRL0_MR_RANK_MASK)
#define DDRC_MRCTRL0_MR_ADDR_MASK  (0xF000U)
#define DDRC_MRCTRL0_MR_ADDR_SHIFT (12U)
/*! mr_addr - Address of the mode register that is to be written to.
 *  0b0000..MR0
 *  0b0001..MR1
 *  0b0010..MR2
 *  0b0011..MR3
 *  0b0100..MR4
 *  0b0101..MR5
 *  0b0110..MR6
 *  0b0111..MR7
 */
#define DDRC_MRCTRL0_MR_ADDR(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_MRCTRL0_MR_ADDR_SHIFT)) & DDRC_MRCTRL0_MR_ADDR_MASK)
#define DDRC_MRCTRL0_PBA_MODE_MASK  (0x40000000U)
#define DDRC_MRCTRL0_PBA_MODE_SHIFT (30U)
/*! pba_mode - Indicates whether PBA access is executed. When setting this bit to 1 along with
 *    setting pda_en to 1, DDRC initiates PBA access instead of PDA access. - 0 - Per DRAM Addressability
 *    mode - 1 - Per Buffer Addressability mode The completion of PBA access is confirmed by
 *    MRSTAT.pda_done in the same way as PDA.
 */
#define DDRC_MRCTRL0_PBA_MODE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_MRCTRL0_PBA_MODE_SHIFT)) & DDRC_MRCTRL0_PBA_MODE_MASK)
#define DDRC_MRCTRL0_MR_WR_MASK  (0x80000000U)
#define DDRC_MRCTRL0_MR_WR_SHIFT (31U)
/*! mr_wr - Setting this register bit to 1 triggers a mode register read or write operation. When
 *    the MR operation is complete, the DDRC automatically clears this bit. The other register fields
 *    of this register must be written in a separate APB transaction, before setting this mr_wr bit.
 *    It is recommended NOT to set this signal if in Init, Deep power-down or MPSM operating modes.
 */
#define DDRC_MRCTRL0_MR_WR(x) (((uint32_t)(((uint32_t)(x)) << DDRC_MRCTRL0_MR_WR_SHIFT)) & DDRC_MRCTRL0_MR_WR_MASK)
/*! @} */

/*! @name MRCTRL1 - Mode Register Read/Write Control Register 1 */
/*! @{ */
#define DDRC_MRCTRL1_MR_DATA_MASK  (0x3FFFFU)
#define DDRC_MRCTRL1_MR_DATA_SHIFT (0U)
/*! mr_data - Mode register write data for all non-LPDDR2/non-LPDDR3/non-LPDDR4 modes. For
 *    LPDDR2/LPDDR3/LPDDR4, MRCTRL1[15:0] are interpreted as [15:8] MR Address [7:0] MR data for writes,
 *    don't care for reads. This is 18-bits wide in configurations with DDR4 support and 16-bits in all
 *    other configurations.
 */
#define DDRC_MRCTRL1_MR_DATA(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_MRCTRL1_MR_DATA_SHIFT)) & DDRC_MRCTRL1_MR_DATA_MASK)
/*! @} */

/*! @name MRSTAT - Mode Register Read/Write Status Register */
/*! @{ */
#define DDRC_MRSTAT_MR_WR_BUSY_MASK  (0x1U)
#define DDRC_MRSTAT_MR_WR_BUSY_SHIFT (0U)
/*! mr_wr_busy - The SoC core may initiate a MR write operation only if this signal is low. This
 *    signal goes high in the clock after the DDRC accepts the MRW/MRR request. It goes low when the
 *    MRW/MRR command is issued to the SDRAM. It is recommended not to perform MRW/MRR commands when
 *    'MRSTAT.mr_wr_busy' is high.
 *  0b0..Indicates that the SoC core can initiate a mode register write operation
 *  0b1..Indicates that mode register write operation is in progress
 */
#define DDRC_MRSTAT_MR_WR_BUSY(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_MRSTAT_MR_WR_BUSY_SHIFT)) & DDRC_MRSTAT_MR_WR_BUSY_MASK)
#define DDRC_MRSTAT_PDA_DONE_MASK  (0x100U)
#define DDRC_MRSTAT_PDA_DONE_SHIFT (8U)
/*! pda_done - The SoC core may initiate a MR write operation in PDA/PBA mode only if this signal is
 *    low. This signal goes high when three consecutive MRS commands related to the PDA/PBA mode
 *    are issued to the SDRAM. This signal goes low when MRCTRL0.pda_en becomes 0. Therefore, it is
 *    recommended to write MRCTRL0.pda_en to 0 after this signal goes high in order to prepare to
 *    perform PDA operation next time
 *  0b0..Indicates that mode register write operation related to PDA/PBA is in progress or has not started yet.
 *  0b1..Indicates that mode register write operation related to PDA/PBA has competed.
 */
#define DDRC_MRSTAT_PDA_DONE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_MRSTAT_PDA_DONE_SHIFT)) & DDRC_MRSTAT_PDA_DONE_MASK)
/*! @} */

/*! @name MRCTRL2 - Mode Register Read/Write Control Register 2 */
/*! @{ */
#define DDRC_MRCTRL2_MR_DEVICE_SEL_MASK  (0xFFFFFFFFU)
#define DDRC_MRCTRL2_MR_DEVICE_SEL_SHIFT (0U)
/*! mr_device_sel - Indicates the device(s) to be selected during the MRS that happens in PDA mode.
 *    Each bit is associated with one device. For example, bit[0] corresponds to Device 0, bit[1] to
 *    Device 1 etc. A '1' should be programmed to indicate that the MRS command should be applied
 *    to that device. A '0' indicates that the MRS commands should be skipped for that device.
 */
#define DDRC_MRCTRL2_MR_DEVICE_SEL(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_MRCTRL2_MR_DEVICE_SEL_SHIFT)) & DDRC_MRCTRL2_MR_DEVICE_SEL_MASK)
/*! @} */

/*! @name DERATEEN - Temperature Derate Enable Register */
/*! @{ */
#define DDRC_DERATEEN_DERATE_ENABLE_MASK  (0x1U)
#define DDRC_DERATEEN_DERATE_ENABLE_SHIFT (0U)
/*! derate_enable - Enables derating. Present only in designs configured to support
 *    LPDDR2/LPDDR3/LPDDR4. This field must be set to '0' for non-LPDDR2/LPDDR3/LPDDR4 mode.
 *  0b0..Timing parameter derating is disabled
 *  0b1..Timing parameter derating is enabled using MR4 read value.
 */
#define DDRC_DERATEEN_DERATE_ENABLE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DERATEEN_DERATE_ENABLE_SHIFT)) & DDRC_DERATEEN_DERATE_ENABLE_MASK)
#define DDRC_DERATEEN_DERATE_VALUE_MASK  (0x2U)
#define DDRC_DERATEEN_DERATE_VALUE_SHIFT (1U)
/*! derate_value - Derate value. Present only in designs configured to support LPDDR2/LPDDR3/LPDDR4
 *    Set to 0 for all LPDDR2 speed grades as derating value of +1.875 ns is less than a
 *    core_ddrc_core_clk period. For LPDDR3/4, if the period of core_ddrc_core_clk is less than 1.875ns, this
 *    register field should be set to 1; otherwise it should be set to 0.
 *  0b0..Derating uses +1
 *  0b1..Derating uses +2
 */
#define DDRC_DERATEEN_DERATE_VALUE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DERATEEN_DERATE_VALUE_SHIFT)) & DDRC_DERATEEN_DERATE_VALUE_MASK)
#define DDRC_DERATEEN_DERATE_BYTE_MASK  (0xF0U)
#define DDRC_DERATEEN_DERATE_BYTE_SHIFT (4U)
/*! derate_byte - Derate byte Present only in designs configured to support LPDDR2/LPDDR3/LPDDR4
 *    Indicates which byte of the MRR data is used for derating. The maximum valid value depends on
 *    MEMC_DRAM_TOTAL_DATA_WIDTH.
 */
#define DDRC_DERATEEN_DERATE_BYTE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DERATEEN_DERATE_BYTE_SHIFT)) & DDRC_DERATEEN_DERATE_BYTE_MASK)
#define DDRC_DERATEEN_RC_DERATE_VALUE_MASK  (0x300U)
#define DDRC_DERATEEN_RC_DERATE_VALUE_SHIFT (8U)
/*! rc_derate_value - Derate value of tRC for LPDDR4. Present only in designs configured to support
 *    LPDDR4. The required number of cycles for derating can be determined by dividing 3.75ns by the
 *    core_ddrc_core_clk period, and rounding up the next integer.
 *  0b00..Derating uses +1
 *  0b01..Derating uses +2
 *  0b10..Derating uses +3
 *  0b11..Derating uses +4
 */
#define DDRC_DERATEEN_RC_DERATE_VALUE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DERATEEN_RC_DERATE_VALUE_SHIFT)) & DDRC_DERATEEN_RC_DERATE_VALUE_MASK)
/*! @} */

/*! @name DERATEINT - Temperature Derate Interval Register */
/*! @{ */
#define DDRC_DERATEINT_MR4_READ_INTERVAL_MASK  (0xFFFFFFFFU)
#define DDRC_DERATEINT_MR4_READ_INTERVAL_SHIFT (0U)
/*! mr4_read_interval - Interval between two MR4 reads, used to derate the timing parameters.
 *    Present only in designs configured to support LPDDR2/LPDDR3/LPDDR4. This register must not be set to
 *    zero. Unit: DFI clock cycle.
 */
#define DDRC_DERATEINT_MR4_READ_INTERVAL(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DERATEINT_MR4_READ_INTERVAL_SHIFT)) & DDRC_DERATEINT_MR4_READ_INTERVAL_MASK)
/*! @} */

/*! @name PWRCTL - Low Power Control Register */
/*! @{ */
#define DDRC_PWRCTL_SELFREF_EN_MASK  (0x1U)
#define DDRC_PWRCTL_SELFREF_EN_SHIFT (0U)
/*! selfref_en - If true then the DDRC puts the SDRAM into Self Refresh after a programmable number
 *    of cycles "maximum idle clocks before Self Refresh (PWRTMG.selfref_to_x32)". This register bit
 *    may be re-programmed during the course of normal operation.
 */
#define DDRC_PWRCTL_SELFREF_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PWRCTL_SELFREF_EN_SHIFT)) & DDRC_PWRCTL_SELFREF_EN_MASK)
#define DDRC_PWRCTL_POWERDOWN_EN_MASK  (0x2U)
#define DDRC_PWRCTL_POWERDOWN_EN_SHIFT (1U)
/*! powerdown_en - If true then the DDRC goes into power-down after a programmable number of cycles
 *    "maximum idle clocks before power down" (PWRTMG.powerdown_to_x32). This register bit may be
 *    re-programmed during the course of normal operation.
 */
#define DDRC_PWRCTL_POWERDOWN_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PWRCTL_POWERDOWN_EN_SHIFT)) & DDRC_PWRCTL_POWERDOWN_EN_MASK)
#define DDRC_PWRCTL_DEEPPOWERDOWN_EN_MASK  (0x4U)
#define DDRC_PWRCTL_DEEPPOWERDOWN_EN_SHIFT (2U)
/*! deeppowerdown_en - When this is 1, DDRC puts the SDRAM into deep power-down mode when the
 *    transaction store is empty. This register must be reset to '0' to bring DDRC out of deep power-down
 *    mode. Controller performs automatic SDRAM initialization on deep power-down exit. Present only
 *    in designs configured to support mDDR or LPDDR2 or LPDDR3. For
 *    non-mDDR/non-LPDDR2/non-LPDDR3, this register should not be set to 1. FOR PERFORMANCE ONLY.
 */
#define DDRC_PWRCTL_DEEPPOWERDOWN_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PWRCTL_DEEPPOWERDOWN_EN_SHIFT)) & DDRC_PWRCTL_DEEPPOWERDOWN_EN_MASK)
#define DDRC_PWRCTL_EN_DFI_DRAM_CLK_DISABLE_MASK  (0x8U)
#define DDRC_PWRCTL_EN_DFI_DRAM_CLK_DISABLE_SHIFT (3U)
/*! en_dfi_dram_clk_disable - Enable the assertion of dfi_dram_clk_disable whenever a clock is not
 *    required by the SDRAM. If set to 0, dfi_dram_clk_disable is never asserted. Assertion of
 *    dfi_dram_clk_disable is as follows: In DDR2/DDR3, can only be asserted in Self Refresh. In DDR4, can
 *    be asserted in following: in Self Refresh in Maximum Power Saving Mode In mDDR/LPDDR2/LPDDR3,
 *    can be asserted in following: in Self Refresh in Power Down in Deep Power Down during Normal
 *    operation (Clock Stop) In LPDDR4, can be asserted in following: in Self Refresh Power Down in
 *    Power Down during Normal operation (Clock Stop)
 */
#define DDRC_PWRCTL_EN_DFI_DRAM_CLK_DISABLE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PWRCTL_EN_DFI_DRAM_CLK_DISABLE_SHIFT)) & \
     DDRC_PWRCTL_EN_DFI_DRAM_CLK_DISABLE_MASK)
#define DDRC_PWRCTL_MPSM_EN_MASK  (0x10U)
#define DDRC_PWRCTL_MPSM_EN_SHIFT (4U)
/*! mpsm_en - When this is 1, the DDRC puts the SDRAM into maximum power saving mode when the
 *    transaction store is empty. This register must be reset to '0' to bring DDRC out of maximum power
 *    saving mode. Present only in designs configured to support DDR4. For non-DDR4, this register
 *    should not be set to 1. Note that MPSM is not supported when using a DDR PHY, if the PHY
 *    parameter DDRC_AC_CS_USE is disabled, as the MPSM exit sequence requires the chip-select signal to
 *    toggle. FOR PERFORMANCE ONLY.
 */
#define DDRC_PWRCTL_MPSM_EN(x)       (((uint32_t)(((uint32_t)(x)) << DDRC_PWRCTL_MPSM_EN_SHIFT)) & DDRC_PWRCTL_MPSM_EN_MASK)
#define DDRC_PWRCTL_SELFREF_SW_MASK  (0x20U)
#define DDRC_PWRCTL_SELFREF_SW_SHIFT (5U)
/*! selfref_sw - A value of 1 to this register causes system to move to Self Refresh state
 *    immediately, as long as it is not in INIT or DPD/MPSM operating_mode. This is referred to as Software
 *    Entry/Exit to Self Refresh.
 *  0b0..Software Exit from Self Refresh
 *  0b1..Software Entry to Self Refresh
 */
#define DDRC_PWRCTL_SELFREF_SW(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PWRCTL_SELFREF_SW_SHIFT)) & DDRC_PWRCTL_SELFREF_SW_MASK)
#define DDRC_PWRCTL_STAY_IN_SELFREF_MASK  (0x40U)
#define DDRC_PWRCTL_STAY_IN_SELFREF_SHIFT (6U)
/*! stay_in_selfref - Self refresh state is an intermediate state to enter to Self refresh power
 *    down state or exit Self refresh power down state for LPDDR4. This register controls transition
 *    from the Self refresh state. - 1 - Prohibit transition from Self refresh state - 0 - Allow
 *    transition from Self refresh state
 *  0b0..
 *  0b1..
 */
#define DDRC_PWRCTL_STAY_IN_SELFREF(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PWRCTL_STAY_IN_SELFREF_SHIFT)) & DDRC_PWRCTL_STAY_IN_SELFREF_MASK)
/*! @} */

/*! @name PWRTMG - Low Power Timing Register */
/*! @{ */
#define DDRC_PWRTMG_POWERDOWN_TO_X32_MASK  (0x1FU)
#define DDRC_PWRTMG_POWERDOWN_TO_X32_SHIFT (0U)
/*! powerdown_to_x32 - After this many clocks of the DDRC command channel being idle the DDRC
 *    automatically puts the SDRAM into power-down. The DDRC command channel is considered idle when there
 *    are no HIF commands outstanding. This must be enabled in the PWRCTL.powerdown_en. Unit:
 *    Multiples of 32 DFI clocks FOR PERFORMANCE ONLY.
 */
#define DDRC_PWRTMG_POWERDOWN_TO_X32(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PWRTMG_POWERDOWN_TO_X32_SHIFT)) & DDRC_PWRTMG_POWERDOWN_TO_X32_MASK)
#define DDRC_PWRTMG_T_DPD_X4096_MASK  (0xFF00U)
#define DDRC_PWRTMG_T_DPD_X4096_SHIFT (8U)
/*! t_dpd_x4096 - Minimum deep power-down time. For mDDR, value from the JEDEC specification is 0 as
 *    mDDR exits from deep power-down mode immediately after PWRCTL.deeppowerdown_en is
 *    de-asserted. For LPDDR2/LPDDR3, value from the JEDEC specification is 500us. Unit: Multiples of 4096 DFI
 *    clocks. Present only in designs configured to support mDDR, LPDDR2 or LPDDR3. FOR PERFORMANCE
 *    ONLY.
 */
#define DDRC_PWRTMG_T_DPD_X4096(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PWRTMG_T_DPD_X4096_SHIFT)) & DDRC_PWRTMG_T_DPD_X4096_MASK)
#define DDRC_PWRTMG_SELFREF_TO_X32_MASK  (0xFF0000U)
#define DDRC_PWRTMG_SELFREF_TO_X32_SHIFT (16U)
/*! selfref_to_x32 - After this many clocks of the DDRC command channel being idle the DDRC
 *    automatically puts the SDRAM into Self Refresh. The DDRC command channel is considered idle when there
 *    are no HIF commands outstanding. This must be enabled in the PWRCTL.selfref_en. Unit:
 *    Multiples of 32 DFI clocks. FOR PERFORMANCE ONLY.
 */
#define DDRC_PWRTMG_SELFREF_TO_X32(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PWRTMG_SELFREF_TO_X32_SHIFT)) & DDRC_PWRTMG_SELFREF_TO_X32_MASK)
/*! @} */

/*! @name HWLPCTL - Hardware Low Power Control Register */
/*! @{ */
#define DDRC_HWLPCTL_HW_LP_EN_MASK  (0x1U)
#define DDRC_HWLPCTL_HW_LP_EN_SHIFT (0U)
/*! hw_lp_en - Enable for Hardware Low Power Interface.
 */
#define DDRC_HWLPCTL_HW_LP_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_HWLPCTL_HW_LP_EN_SHIFT)) & DDRC_HWLPCTL_HW_LP_EN_MASK)
#define DDRC_HWLPCTL_HW_LP_EXIT_IDLE_EN_MASK  (0x2U)
#define DDRC_HWLPCTL_HW_LP_EXIT_IDLE_EN_SHIFT (1U)
/*! hw_lp_exit_idle_en - When this bit is programmed to 1 the cactive_in_ddrc pin of the DDRC can be
 *    used to exit from the automatic clock stop, automatic power down or automatic self-refresh
 *    modes. Note, it will not cause exit of Self-Refresh that was caused by Hardware Low Power
 *    Interface and/or Software (PWRCTL.selfref_sw).
 */
#define DDRC_HWLPCTL_HW_LP_EXIT_IDLE_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_HWLPCTL_HW_LP_EXIT_IDLE_EN_SHIFT)) & DDRC_HWLPCTL_HW_LP_EXIT_IDLE_EN_MASK)
#define DDRC_HWLPCTL_HW_LP_IDLE_X32_MASK  (0xFFF0000U)
#define DDRC_HWLPCTL_HW_LP_IDLE_X32_SHIFT (16U)
/*! hw_lp_idle_x32 - Hardware idle period. The cactive_ddrc output is driven low if the DDRC command
 *    channel is idle for hw_lp_idle * 32 cycles if not in INIT or DPD/MPSM operating_mode. The
 *    DDRC command channel is considered idle when there are no HIF commands outstanding. The hardware
 *    idle function is disabled when hw_lp_idle_x32=0. Unit: Multiples of 32 DFI clocks. FOR
 *    PERFORMANCE ONLY.
 */
#define DDRC_HWLPCTL_HW_LP_IDLE_X32(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_HWLPCTL_HW_LP_IDLE_X32_SHIFT)) & DDRC_HWLPCTL_HW_LP_IDLE_X32_MASK)
/*! @} */

/*! @name RFSHCTL0 - Refresh Control Register 0 */
/*! @{ */
#define DDRC_RFSHCTL0_PER_BANK_REFRESH_MASK  (0x4U)
#define DDRC_RFSHCTL0_PER_BANK_REFRESH_SHIFT (2U)
/*! per_bank_refresh - Per bank refresh allows traffic to flow to other banks. Per bank refresh is
 *    not supported by all LPDDR2 devices but should be supported by all LPDDR3/LPDDR4 devices.
 *    Present only in designs configured to support LPDDR2/LPDDR3/LPDDR4
 *  0b1..Per bank refresh
 *  0b0..All bank refresh
 */
#define DDRC_RFSHCTL0_PER_BANK_REFRESH(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_RFSHCTL0_PER_BANK_REFRESH_SHIFT)) & DDRC_RFSHCTL0_PER_BANK_REFRESH_MASK)
#define DDRC_RFSHCTL0_REFRESH_BURST_MASK  (0x1F0U)
#define DDRC_RFSHCTL0_REFRESH_BURST_SHIFT (4U)
/*! refresh_burst - The programmed value + 1 is the number of refresh timeouts that is allowed to
 *    accumulate before traffic is blocked and the refreshes are forced to execute. Closing pages to
 *    perform a refresh is a one-time penalty that must be paid for each group of refreshes.
 *    Therefore, performing refreshes in a burst reduces the per-refresh penalty of these page closings.
 *    Higher numbers for RFSHCTL.refresh_burst slightly increases utilization; lower numbers decreases
 *    the worst-case latency associated with refreshes. - 0 - single refresh - 1 - burst-of-2
 *    refresh - 7 - burst-of-8 refresh For information on burst refresh feature refer to section 3.9 of
 *    DDR2 JEDEC specification - JESD79-2F.pdf. For DDR2/3, the refresh is always per-rank and not
 *    per-bank. The rank refresh can be accumulated over 8*tREFI cycles using the burst refresh
 *    feature. In DDR4 mode, according to Fine Granularity feature, 8 refreshes can be postponed in 1X
 *    mode, 16 refreshes in 2X mode and 32 refreshes in 4X mode. If using PHY-initiated updates, care
 *    must be taken in the setting of RFSHCTL0.refresh_burst, to ensure that tRFCmax is not violated
 *    due to a PHY-initiated update occurring shortly before a refresh burst was due. In this
 *    situation, the refresh burst will be delayed until the PHY-initiated update is complete.
 */
#define DDRC_RFSHCTL0_REFRESH_BURST(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_RFSHCTL0_REFRESH_BURST_SHIFT)) & DDRC_RFSHCTL0_REFRESH_BURST_MASK)
#define DDRC_RFSHCTL0_REFRESH_TO_X32_MASK  (0x1F000U)
#define DDRC_RFSHCTL0_REFRESH_TO_X32_SHIFT (12U)
/*! refresh_to_x32 - If the refresh timer (tRFCnom, also known as tREFI) has expired at least once,
 *    but it has not expired (RFSHCTL0.refresh_burst+1) times yet, then a speculative refresh may be
 *    performed. A speculative refresh is a refresh performed at a time when refresh would be
 *    useful, but before it is absolutely required. When the SDRAM bus is idle for a period of time
 *    determined by this RFSHCTL0.refresh_to_x32 and the refresh timer has expired at least once since
 *    the last refresh, then a speculative refresh is performed. Speculative refreshes continues
 *    successively until there are no refreshes pending or until new reads or writes are issued to the
 *    DDRC. FOR PERFORMANCE ONLY. Unit: Multiples of 32 DFI clocks.
 */
#define DDRC_RFSHCTL0_REFRESH_TO_X32(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_RFSHCTL0_REFRESH_TO_X32_SHIFT)) & DDRC_RFSHCTL0_REFRESH_TO_X32_MASK)
#define DDRC_RFSHCTL0_REFRESH_MARGIN_MASK  (0xF00000U)
#define DDRC_RFSHCTL0_REFRESH_MARGIN_SHIFT (20U)
/*! refresh_margin - Threshold value in number of DFI clock cycles before the critical refresh or
 *    page timer expires. A critical refresh is to be issued before this threshold is reached. It is
 *    recommended that this not be changed from the default value, currently shown as 0x2. It must
 *    always be less than internally used t_rfc_nom_x32. Note that, in LPDDR2/LPDDR3/LPDDR4,
 *    internally used t_rfc_nom_x32 may be equal to RFSHTMG.t_rfc_nom_x32>>2 if derating is enabled
 *    (DERATEEN.derate_enable=1). Otherwise, internally used t_rfc_nom_x32 will be equal to
 *    RFSHTMG.t_rfc_nom_x32. Unit: Multiples of 32 DFI clocks.
 */
#define DDRC_RFSHCTL0_REFRESH_MARGIN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_RFSHCTL0_REFRESH_MARGIN_SHIFT)) & DDRC_RFSHCTL0_REFRESH_MARGIN_MASK)
/*! @} */

/*! @name RFSHCTL1 - Refresh Control Register 1 */
/*! @{ */
#define DDRC_RFSHCTL1_REFRESH_TIMER0_START_VALUE_X32_MASK  (0xFFFU)
#define DDRC_RFSHCTL1_REFRESH_TIMER0_START_VALUE_X32_SHIFT (0U)
/*! refresh_timer0_start_value_x32 - Refresh timer start for rank 0 (only present in multi-rank
 *    configurations). This is useful in staggering the refreshes to multiple ranks to help traffic to
 *    proceed. This is explained in Refresh Controls section of architecture chapter. Unit: Multiples
 *    of 32 DFI clock cycles. FOR PERFORMANCE ONLY.
 */
#define DDRC_RFSHCTL1_REFRESH_TIMER0_START_VALUE_X32(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_RFSHCTL1_REFRESH_TIMER0_START_VALUE_X32_SHIFT)) & \
     DDRC_RFSHCTL1_REFRESH_TIMER0_START_VALUE_X32_MASK)
#define DDRC_RFSHCTL1_REFRESH_TIMER1_START_VALUE_X32_MASK  (0xFFF0000U)
#define DDRC_RFSHCTL1_REFRESH_TIMER1_START_VALUE_X32_SHIFT (16U)
/*! refresh_timer1_start_value_x32 - Refresh timer start for rank 1 (only present in multi-rank
 *    configurations). This is useful in staggering the refreshes to multiple ranks to help traffic to
 *    proceed. This is explained in Refresh Controls section of architecture chapter. Unit: Multiples
 *    of 32 DFI clock cycles. FOR PERFORMANCE ONLY.
 */
#define DDRC_RFSHCTL1_REFRESH_TIMER1_START_VALUE_X32(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_RFSHCTL1_REFRESH_TIMER1_START_VALUE_X32_SHIFT)) & \
     DDRC_RFSHCTL1_REFRESH_TIMER1_START_VALUE_X32_MASK)
/*! @} */

/*! @name RFSHCTL3 - Refresh Control Register 3 */
/*! @{ */
#define DDRC_RFSHCTL3_DIS_AUTO_REFRESH_MASK  (0x1U)
#define DDRC_RFSHCTL3_DIS_AUTO_REFRESH_SHIFT (0U)
/*! dis_auto_refresh - When '1', disable auto-refresh generated by the DDRC. When auto-refresh is
 *    disabled, the SoC core must generate refreshes using the registers reg_ddrc_rank0_refresh,
 *    reg_ddrc_rank1_refresh, reg_ddrc_rank2_refresh and reg_ddrc_rank3_refresh. When dis_auto_refresh
 *    transitions from 0 to 1, any pending refreshes are immediately scheduled by the DDRC. If DDR4
 *    CRC/parity retry is enabled (CRCPARCTL1.crc_parity_retry_enable = 1), disable auto-refresh is
 *    not supported, and this bit must be set to '0'. (DDR4 only) If FGR mode is enabled
 *    (RFSHCTL3.refresh_mode > 0), disable auto-refresh is not supported, and this bit must be set to '0'. This
 *    register field is changeable on the fly.
 */
#define DDRC_RFSHCTL3_DIS_AUTO_REFRESH(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_RFSHCTL3_DIS_AUTO_REFRESH_SHIFT)) & DDRC_RFSHCTL3_DIS_AUTO_REFRESH_MASK)
#define DDRC_RFSHCTL3_REFRESH_UPDATE_LEVEL_MASK  (0x2U)
#define DDRC_RFSHCTL3_REFRESH_UPDATE_LEVEL_SHIFT (1U)
/*! refresh_update_level - Toggle this signal (either from 0 to 1 or from 1 to 0) to indicate that
 *    the refresh register(s) have been updated. refresh_update_level must not be toggled when the
 *    DDRC is in reset (core_ddrc_rstn = 0). The refresh register(s) are automatically updated when
 *    exiting reset.
 */
#define DDRC_RFSHCTL3_REFRESH_UPDATE_LEVEL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_RFSHCTL3_REFRESH_UPDATE_LEVEL_SHIFT)) & \
     DDRC_RFSHCTL3_REFRESH_UPDATE_LEVEL_MASK)
#define DDRC_RFSHCTL3_REFRESH_MODE_MASK  (0x70U)
#define DDRC_RFSHCTL3_REFRESH_MODE_SHIFT (4U)
/*! refresh_mode - Fine Granularity Refresh Mode - 000 - Fixed 1x (Normal mode) - 001 - Fixed 2x -
 *    010 - Fixed 4x - 101 - Enable on the fly 2x (not supported) - 110 - Enable on the fly 4x (not
 *    supported) - Everything else - reserved Note: Only Fixed 1x mode is supported if
 *    RFSHCTL3.dis_auto_refresh = 1. Note: The on-the-fly modes are not supported in this version of the DDRC.
 *    Note: This must be set up while the Controller is in reset or while the Controller is in
 *    self-refresh mode. Changing this during normal operation is not allowed. Making this a dynamic
 *    register will be supported in future version of the DDRC. Note: This register field has effect only
 *    if a DDR4 SDRAM device is in use (MSTR.ddr4 = 1).
 */
#define DDRC_RFSHCTL3_REFRESH_MODE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_RFSHCTL3_REFRESH_MODE_SHIFT)) & DDRC_RFSHCTL3_REFRESH_MODE_MASK)
/*! @} */

/*! @name RFSHTMG - Refresh Timing Register */
/*! @{ */
#define DDRC_RFSHTMG_T_RFC_MIN_MASK  (0x3FFU)
#define DDRC_RFSHTMG_T_RFC_MIN_SHIFT (0U)
/*! t_rfc_min - tRFC (min): Minimum time from refresh to refresh or activate. When the controller is
 *    operating in 1:1 mode, t_rfc_min should be set to RoundUp(tRFCmin/tCK). When the controller
 *    is operating in 1:2 mode, t_rfc_min should be set to RoundUp(RoundUp(tRFCmin/tCK)/2). In
 *    LPDDR2/LPDDR3/LPDDR4 mode: - if using all-bank refreshes, the tRFCmin value in the above equations
 *    is equal to tRFCab - if using per-bank refreshes, the tRFCmin value in the above equations is
 *    equal to tRFCpb In DDR4 mode, the tRFCmin value in the above equations is different depending
 *    on the refresh mode (fixed 1X,2X,4X) and the device density. The user should program the
 *    appropriate value from the spec based on the 'refresh_mode' and the device density that is used.
 *    Unit: Clocks.
 */
#define DDRC_RFSHTMG_T_RFC_MIN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_RFSHTMG_T_RFC_MIN_SHIFT)) & DDRC_RFSHTMG_T_RFC_MIN_MASK)
#define DDRC_RFSHTMG_LPDDR3_TREFBW_EN_MASK  (0x8000U)
#define DDRC_RFSHTMG_LPDDR3_TREFBW_EN_SHIFT (15U)
/*! lpddr3_trefbw_en - Used only when LPDDR3 memory type is connected. Should only be changed when
 *    DDRC is in reset. Specifies whether to use the tREFBW parameter (required by some LPDDR3
 *    devices which comply with earlier versions of the LPDDR3 JEDEC specification) or not: - 0 - tREFBW
 *    parameter not used - 1 - tREFBW parameter used
 */
#define DDRC_RFSHTMG_LPDDR3_TREFBW_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_RFSHTMG_LPDDR3_TREFBW_EN_SHIFT)) & DDRC_RFSHTMG_LPDDR3_TREFBW_EN_MASK)
#define DDRC_RFSHTMG_T_RFC_NOM_X32_MASK  (0xFFF0000U)
#define DDRC_RFSHTMG_T_RFC_NOM_X32_SHIFT (16U)
/*! t_rfc_nom_x32 - tREFI: Average time interval between refreshes per rank (Specification: 7.8us
 *    for DDR2, DDR3 and DDR4. See JEDEC specification for mDDR, LPDDR2, LPDDR3 and LPDDR4). For
 *    LPDDR2/LPDDR3/LPDDR4: - if using all-bank refreshes (RFSHCTL0.per_bank_refresh = 0), this register
 *    should be set to tREFIab - if using per-bank refreshes (RFSHCTL0.per_bank_refresh = 1), this
 *    register should be set to tREFIpb When the controller is operating in 1:2 frequency ratio mode,
 *    program this to (tREFI/2), no rounding up. In DDR4 mode, tREFI value is different depending
 *    on the refresh mode. The user should program the appropriate value from the spec based on the
 *    value programmed in the refresh mode register. Note that RFSHTMG.t_rfc_nom_x32 * 32 must be
 *    greater than RFSHTMG.t_rfc_min, and RFSHTMG.t_rfc_nom_x32 must be greater than 0x1. - Non-DDR4 or
 *    DDR4 Fixed 1x mode: RFSHTMG.t_rfc_nom_x32 must be less than or equal to 0xFFE. - DDR4 Fixed
 *    2x mode: RFSHTMG.t_rfc_nom_x32 must be less than or equal to 0x7FF. - DDR4 Fixed 4x mode:
 *    RFSHTMG.t_rfc_nom_x32 must be less than or equal to 0x3FF. Unit: Multiples of 32 clocks.
 */
#define DDRC_RFSHTMG_T_RFC_NOM_X32(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_RFSHTMG_T_RFC_NOM_X32_SHIFT)) & DDRC_RFSHTMG_T_RFC_NOM_X32_MASK)
/*! @} */

/*! @name ECCCFG0 - ECC Configuration Register 0 */
/*! @{ */
#define DDRC_ECCCFG0_ECC_MODE_MASK  (0x7U)
#define DDRC_ECCCFG0_ECC_MODE_SHIFT (0U)
/*! ecc_mode - ECC mode indicator.
 */
#define DDRC_ECCCFG0_ECC_MODE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ECCCFG0_ECC_MODE_SHIFT)) & DDRC_ECCCFG0_ECC_MODE_MASK)
#define DDRC_ECCCFG0_DIS_SCRUB_MASK  (0x10U)
#define DDRC_ECCCFG0_DIS_SCRUB_SHIFT (4U)
/*! dis_scrub - Disables ECC scrubs.
 */
#define DDRC_ECCCFG0_DIS_SCRUB(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ECCCFG0_DIS_SCRUB_SHIFT)) & DDRC_ECCCFG0_DIS_SCRUB_MASK)
#define DDRC_ECCCFG0_ECC_AP_EN_MASK  (0x40U)
#define DDRC_ECCCFG0_ECC_AP_EN_SHIFT (6U)
/*! ecc_ap_en - Enables address protection feature. Only supported when inline ECC is enabled.
 */
#define DDRC_ECCCFG0_ECC_AP_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ECCCFG0_ECC_AP_EN_SHIFT)) & DDRC_ECCCFG0_ECC_AP_EN_MASK)
#define DDRC_ECCCFG0_ECC_REGION_REMAP_EN_MASK  (0x80U)
#define DDRC_ECCCFG0_ECC_REGION_REMAP_EN_SHIFT (7U)
/*! ecc_region_remap_en - Enables remapping ECC region feature. Only supported when inline ECC is enabled.
 */
#define DDRC_ECCCFG0_ECC_REGION_REMAP_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ECCCFG0_ECC_REGION_REMAP_EN_SHIFT)) & DDRC_ECCCFG0_ECC_REGION_REMAP_EN_MASK)
#define DDRC_ECCCFG0_ECC_REGION_MAP_MASK  (0x7F00U)
#define DDRC_ECCCFG0_ECC_REGION_MAP_SHIFT (8U)
/*! ecc_region_map - Selectable Protected Region setting.
 */
#define DDRC_ECCCFG0_ECC_REGION_MAP(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ECCCFG0_ECC_REGION_MAP_SHIFT)) & DDRC_ECCCFG0_ECC_REGION_MAP_MASK)
#define DDRC_ECCCFG0_BLK_CHANNEL_IDLE_TIME_X32_MASK  (0x3F0000U)
#define DDRC_ECCCFG0_BLK_CHANNEL_IDLE_TIME_X32_SHIFT (16U)
/*! blk_channel_idle_time_x32 - Indicates the number of cycles on HIF interface with no access to
 *    protected regions which causes flush of all the block channels.
 */
#define DDRC_ECCCFG0_BLK_CHANNEL_IDLE_TIME_X32(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ECCCFG0_BLK_CHANNEL_IDLE_TIME_X32_SHIFT)) & \
     DDRC_ECCCFG0_BLK_CHANNEL_IDLE_TIME_X32_MASK)
#define DDRC_ECCCFG0_ECC_AP_ERR_THRESHOLD_MASK  (0x7000000U)
#define DDRC_ECCCFG0_ECC_AP_ERR_THRESHOLD_SHIFT (24U)
/*! ecc_ap_err_threshold - Sets threshold for address parity error.
 */
#define DDRC_ECCCFG0_ECC_AP_ERR_THRESHOLD(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ECCCFG0_ECC_AP_ERR_THRESHOLD_SHIFT)) & DDRC_ECCCFG0_ECC_AP_ERR_THRESHOLD_MASK)
#define DDRC_ECCCFG0_ECC_REGION_MAP_OTHER_MASK  (0x20000000U)
#define DDRC_ECCCFG0_ECC_REGION_MAP_OTHER_SHIFT (29U)
/*! ecc_region_map_other - When ECCCFG0[ecc_region_map_granu] > 0, there is a region which is not
 *    controlled by ecc_region_map. This register defines the region to be protected or non-protected
 *    for Inline ECC. This register is valid only when ECCCFG0[ecc_region_map_granu]>0 &&
 *    ECCCFG0[ecc_mode]=4.
 */
#define DDRC_ECCCFG0_ECC_REGION_MAP_OTHER(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ECCCFG0_ECC_REGION_MAP_OTHER_SHIFT)) & DDRC_ECCCFG0_ECC_REGION_MAP_OTHER_MASK)
#define DDRC_ECCCFG0_ECC_REGION_MAP_GRANU_MASK  (0xC0000000U)
#define DDRC_ECCCFG0_ECC_REGION_MAP_GRANU_SHIFT (30U)
/*! ecc_region_map_granu - Indicates granularity of selectable protected region
 */
#define DDRC_ECCCFG0_ECC_REGION_MAP_GRANU(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ECCCFG0_ECC_REGION_MAP_GRANU_SHIFT)) & DDRC_ECCCFG0_ECC_REGION_MAP_GRANU_MASK)
/*! @} */

/*! @name ECCCFG1 - ECC Configuration Register 1 */
/*! @{ */
#define DDRC_ECCCFG1_DATA_POISON_EN_MASK  (0x1U)
#define DDRC_ECCCFG1_DATA_POISON_EN_SHIFT (0U)
/*! data_poison_en - Enables ECC data poisoning - introduces ECC errors on writes to address specified by the
 * ECCPOISONADDR0/1 registers.
 */
#define DDRC_ECCCFG1_DATA_POISON_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ECCCFG1_DATA_POISON_EN_SHIFT)) & DDRC_ECCCFG1_DATA_POISON_EN_MASK)
#define DDRC_ECCCFG1_DATA_POISON_BIT_MASK  (0x2U)
#define DDRC_ECCCFG1_DATA_POISON_BIT_SHIFT (1U)
/*! data_poison_bit - Selects whether to poison 1 or 2 bits.
 */
#define DDRC_ECCCFG1_DATA_POISON_BIT(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ECCCFG1_DATA_POISON_BIT_SHIFT)) & DDRC_ECCCFG1_DATA_POISON_BIT_MASK)
#define DDRC_ECCCFG1_POISON_CHIP_EN_MASK  (0x4U)
#define DDRC_ECCCFG1_POISON_CHIP_EN_SHIFT (2U)
/*! poison_chip_en - Indicates the data poison based on chip (that is, persistently poisons the DRAM
 *    data once its cs is selected to mimic chip failure). It is valid if ECCCFG1[data_poison_en]=1.
 */
#define DDRC_ECCCFG1_POISON_CHIP_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ECCCFG1_POISON_CHIP_EN_SHIFT)) & DDRC_ECCCFG1_POISON_CHIP_EN_MASK)
#define DDRC_ECCCFG1_ECC_REGION_PARITY_LOCK_MASK  (0x10U)
#define DDRC_ECCCFG1_ECC_REGION_PARITY_LOCK_SHIFT (4U)
/*! ecc_region_parity_lock - Locks the parity section of the ECC region (hole) which is the highest
 *    system address part of the memory that stores ECC parity for protected region.
 */
#define DDRC_ECCCFG1_ECC_REGION_PARITY_LOCK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ECCCFG1_ECC_REGION_PARITY_LOCK_SHIFT)) & \
     DDRC_ECCCFG1_ECC_REGION_PARITY_LOCK_MASK)
#define DDRC_ECCCFG1_ECC_REGION_WASTE_LOCK_MASK  (0x20U)
#define DDRC_ECCCFG1_ECC_REGION_WASTE_LOCK_SHIFT (5U)
/*! ecc_region_waste_lock - Locks the remaining waste parts of the ECC region (hole) that are not locked by
 * ecc_region_parity_lock.
 */
#define DDRC_ECCCFG1_ECC_REGION_WASTE_LOCK(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ECCCFG1_ECC_REGION_WASTE_LOCK_SHIFT)) & \
     DDRC_ECCCFG1_ECC_REGION_WASTE_LOCK_MASK)
#define DDRC_ECCCFG1_BLK_CHANNEL_ACTIVE_TERM_MASK  (0x80U)
#define DDRC_ECCCFG1_BLK_CHANNEL_ACTIVE_TERM_SHIFT (7U)
/*! blk_channel_active_term - If enabled, block channel is terminated when full block write or full
 *    block read is performed (all address within block are written or read). This is debug
 *    register, and this must be set to 1 for normal operation.
 */
#define DDRC_ECCCFG1_BLK_CHANNEL_ACTIVE_TERM(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ECCCFG1_BLK_CHANNEL_ACTIVE_TERM_SHIFT)) & \
     DDRC_ECCCFG1_BLK_CHANNEL_ACTIVE_TERM_MASK)
#define DDRC_ECCCFG1_ACTIVE_BLK_CHANNEL_MASK  (0xF00U)
#define DDRC_ECCCFG1_ACTIVE_BLK_CHANNEL_SHIFT (8U)
/*! active_blk_channel - Indicated the number of active block channels.
 */
#define DDRC_ECCCFG1_ACTIVE_BLK_CHANNEL(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ECCCFG1_ACTIVE_BLK_CHANNEL_SHIFT)) & DDRC_ECCCFG1_ACTIVE_BLK_CHANNEL_MASK)
/*! @} */

/*! @name INIT0 - SDRAM Initialization Register 0 */
/*! @{ */
#define DDRC_INIT0_PRE_CKE_X1024_MASK  (0xFFFU)
#define DDRC_INIT0_PRE_CKE_X1024_SHIFT (0U)
/*! pre_cke_x1024 - Cycles to wait after reset before driving CKE high to start the SDRAM
 *    initialization sequence. Unit: 1024 DFI clock cycles. DDR2 specifications typically require this to be
 *    programmed for a delay of >= 200 us. LPDDR2/LPDDR3: tINIT1 of 100 ns (min) LPDDR4: tINIT3 of 2
 *    ms (min) When the controller is operating in 1:2 frequency ratio mode, program this to JEDEC
 *    spec value divided by 2, and round it up to the next integer value. For DDR3/DDR4 RDIMMs, this
 *    should include the time needed to satisfy tSTAB
 */
#define DDRC_INIT0_PRE_CKE_X1024(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_INIT0_PRE_CKE_X1024_SHIFT)) & DDRC_INIT0_PRE_CKE_X1024_MASK)
#define DDRC_INIT0_POST_CKE_X1024_MASK  (0x3FF0000U)
#define DDRC_INIT0_POST_CKE_X1024_SHIFT (16U)
/*! post_cke_x1024 - Cycles to wait after driving CKE high to start the SDRAM initialization
 *    sequence. Unit: 1024 DFI clock cycles. DDR2 typically requires a 400 ns delay, requiring this value
 *    to be programmed to 2 at all clock speeds. LPDDR2/LPDDR3 typically requires this to be
 *    programmed for a delay of 200 us. LPDDR4 typically requires this to be programmed for a delay of 2 us.
 *    When the controller is operating in 1:2 frequency ratio mode, program this to JEDEC spec
 *    value divided by 2, and round it up to the next integer value.
 */
#define DDRC_INIT0_POST_CKE_X1024(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_INIT0_POST_CKE_X1024_SHIFT)) & DDRC_INIT0_POST_CKE_X1024_MASK)
#define DDRC_INIT0_SKIP_DRAM_INIT_MASK  (0xC0000000U)
#define DDRC_INIT0_SKIP_DRAM_INIT_SHIFT (30U)
/*! skip_dram_init - If lower bit is enabled the SDRAM initialization routine is skipped. The upper
 *    bit decides what state the controller starts up in when reset is removed - 00 - SDRAM
 *    Intialization routine is run after power-up - 01 - SDRAM Initialization routine is skipped after
 *    power-up. Controller starts up in Normal Mode - 11 - SDRAM Initialization routine is skipped after
 *    power-up. Controller starts up in Self-refresh Mode - 10 - SDRAM Initialization routine is run
 *    after power-up.
 *  0b00..SDRAM Initialization routine is run after power-up
 *  0b01..SDRAM Initialization routine is skipped after power-up
 *  0b10..SDRAM Initialization routine is run after power-up
 *  0b11..SDRAM Initialization routine is skipped after power-up
 */
#define DDRC_INIT0_SKIP_DRAM_INIT(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_INIT0_SKIP_DRAM_INIT_SHIFT)) & DDRC_INIT0_SKIP_DRAM_INIT_MASK)
/*! @} */

/*! @name INIT1 - SDRAM Initialization Register 1 */
/*! @{ */
#define DDRC_INIT1_PRE_OCD_X32_MASK  (0xFU)
#define DDRC_INIT1_PRE_OCD_X32_SHIFT (0U)
/*! pre_ocd_x32 - Wait period before driving the OCD complete command to SDRAM. Unit: Counts of a
 *    global timer that pulses every 32 DFI clock cycles. There is no known specific requirement for
 *    this; it may be set to zero.
 */
#define DDRC_INIT1_PRE_OCD_X32(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_INIT1_PRE_OCD_X32_SHIFT)) & DDRC_INIT1_PRE_OCD_X32_MASK)
#define DDRC_INIT1_DRAM_RSTN_X1024_MASK  (0x1FF0000U)
#define DDRC_INIT1_DRAM_RSTN_X1024_SHIFT (16U)
/*! dram_rstn_x1024 - Number of cycles to assert SDRAM reset signal during init sequence. This is
 *    only present for designs supporting DDR3, DDR4 or LPDDR4 devices. For use with a DDR PHY, this
 *    should be set to a minimum of 1. When the controller is operating in 1:2 frequency ratio mode,
 *    program this to JEDEC spec value divided by 2, and round it up to the next integer value.
 *    Unit: 1024 DFI clock cycles.
 */
#define DDRC_INIT1_DRAM_RSTN_X1024(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_INIT1_DRAM_RSTN_X1024_SHIFT)) & DDRC_INIT1_DRAM_RSTN_X1024_MASK)
/*! @} */

/*! @name INIT2 - SDRAM Initialization Register 2 */
/*! @{ */
#define DDRC_INIT2_MIN_STABLE_CLOCK_X1_MASK  (0xFU)
#define DDRC_INIT2_MIN_STABLE_CLOCK_X1_SHIFT (0U)
/*! min_stable_clock_x1 - Time to wait after the first CKE high, tINIT2. Present only in designs
 *    configured to support LPDDR2/LPDDR3. LPDDR2/LPDDR3 typically requires 5 x tCK delay. When the
 *    controller is operating in 1:2 frequency ratio mode, program this to JEDEC spec value divided by
 *    2, and round it up to the next integer value. Unit: DFI clock cycles.
 */
#define DDRC_INIT2_MIN_STABLE_CLOCK_X1(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_INIT2_MIN_STABLE_CLOCK_X1_SHIFT)) & DDRC_INIT2_MIN_STABLE_CLOCK_X1_MASK)
#define DDRC_INIT2_IDLE_AFTER_RESET_X32_MASK  (0xFF00U)
#define DDRC_INIT2_IDLE_AFTER_RESET_X32_SHIFT (8U)
/*! idle_after_reset_x32 - Idle time after the reset command, tINIT4. Present only in designs
 *    configured to support LPDDR2. When the controller is operating in 1:2 frequency ratio mode, program
 *    this to JEDEC spec value divided by 2, and round it up to the next integer value. Unit: 32 DFI
 *    clock cycles.
 */
#define DDRC_INIT2_IDLE_AFTER_RESET_X32(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_INIT2_IDLE_AFTER_RESET_X32_SHIFT)) & DDRC_INIT2_IDLE_AFTER_RESET_X32_MASK)
/*! @} */

/*! @name INIT3 - SDRAM Initialization Register 3 */
/*! @{ */
#define DDRC_INIT3_EMR_MASK  (0xFFFFU)
#define DDRC_INIT3_EMR_SHIFT (0U)
/*! emr - DDR2: Value to write to EMR register. Bits 9:7 are for OCD and the setting in this
 *    register is ignored. The DDRC sets those bits appropriately. DDR3/DDR4: Value to write to MR1
 *    register Set bit 7 to 0. If PHY-evaluation mode training is enabled, this bit is set appropriately by
 *    the DDRC during write leveling. mDDR: Value to write to EMR register. LPDDR2/LPDDR3/LPDDR4 -
 *    Value to write to MR2 register
 */
#define DDRC_INIT3_EMR(x)   (((uint32_t)(((uint32_t)(x)) << DDRC_INIT3_EMR_SHIFT)) & DDRC_INIT3_EMR_MASK)
#define DDRC_INIT3_MR_MASK  (0xFFFF0000U)
#define DDRC_INIT3_MR_SHIFT (16U)
/*! mr - DDR2: Value to write to MR register. Bit 8 is for DLL and the setting here is ignored. The
 *    DDRC sets this bit appropriately. DDR3/DDR4: Value loaded into MR0 register. mDDR: Value to
 *    write to MR register. LPDDR2/LPDDR3/LPDDR4 - Value to write to MR1 register
 */
#define DDRC_INIT3_MR(x) (((uint32_t)(((uint32_t)(x)) << DDRC_INIT3_MR_SHIFT)) & DDRC_INIT3_MR_MASK)
/*! @} */

/*! @name INIT4 - SDRAM Initialization Register 4 */
/*! @{ */
#define DDRC_INIT4_EMR3_MASK  (0xFFFFU)
#define DDRC_INIT4_EMR3_SHIFT (0U)
/*! emr3 - DDR2: Value to write to EMR3 register. DDR3/DDR4: Value to write to MR3 register
 *    mDDR/LPDDR2/LPDDR3: Unused LPDDR4: Value to write to MR13 register
 */
#define DDRC_INIT4_EMR3(x)    (((uint32_t)(((uint32_t)(x)) << DDRC_INIT4_EMR3_SHIFT)) & DDRC_INIT4_EMR3_MASK)
#define DDRC_INIT4_EMR2_MASK  (0xFFFF0000U)
#define DDRC_INIT4_EMR2_SHIFT (16U)
/*! emr2 - DDR2: Value to write to EMR2 register. DDR3/DDR4: Value to write to MR2 register
 *    LPDDR2/LPDDR3/LPDDR4: Value to write to MR3 register mDDR: Unused
 */
#define DDRC_INIT4_EMR2(x) (((uint32_t)(((uint32_t)(x)) << DDRC_INIT4_EMR2_SHIFT)) & DDRC_INIT4_EMR2_MASK)
/*! @} */

/*! @name INIT5 - SDRAM Initialization Register 5 */
/*! @{ */
#define DDRC_INIT5_MAX_AUTO_INIT_X1024_MASK  (0x3FFU)
#define DDRC_INIT5_MAX_AUTO_INIT_X1024_SHIFT (0U)
/*! max_auto_init_x1024 - Maximum duration of the auto initialization, tINIT5. Present only in
 *    designs configured to support LPDDR2/LPDDR3. LPDDR2/LPDDR3 typically requires 10 us. Unit: 1024 DFI
 *    clock cycles.
 */
#define DDRC_INIT5_MAX_AUTO_INIT_X1024(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_INIT5_MAX_AUTO_INIT_X1024_SHIFT)) & DDRC_INIT5_MAX_AUTO_INIT_X1024_MASK)
#define DDRC_INIT5_DEV_ZQINIT_X32_MASK  (0xFF0000U)
#define DDRC_INIT5_DEV_ZQINIT_X32_SHIFT (16U)
/*! dev_zqinit_x32 - ZQ initial calibration, tZQINIT. Present only in designs configured to support
 *    DDR3 or DDR4 or LPDDR2/LPDDR3. DDR3 typically requires 512 SDRAM clock cycles. DDR4 requires
 *    1024 SDRAM clock cycles. LPDDR2/LPDDR3 requires 1 us. When the controller is operating in 1:2
 *    frequency ratio mode, program this to JEDEC spec value divided by 2, and round it up to the
 *    next integer value. Unit: 32 DFI clock cycles.
 */
#define DDRC_INIT5_DEV_ZQINIT_X32(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_INIT5_DEV_ZQINIT_X32_SHIFT)) & DDRC_INIT5_DEV_ZQINIT_X32_MASK)
/*! @} */

/*! @name INIT6 - SDRAM Initialization Register 6 */
/*! @{ */
#define DDRC_INIT6_MR5_MASK  (0xFFFFU)
#define DDRC_INIT6_MR5_SHIFT (0U)
/*! mr5 - DDR4- Value to be loaded into SDRAM MR5 registers. Used in DDR4 designs only.
 */
#define DDRC_INIT6_MR5(x)    (((uint32_t)(((uint32_t)(x)) << DDRC_INIT6_MR5_SHIFT)) & DDRC_INIT6_MR5_MASK)
#define DDRC_INIT6_MR4_MASK  (0xFFFF0000U)
#define DDRC_INIT6_MR4_SHIFT (16U)
/*! mr4 - DDR4- Value to be loaded into SDRAM MR4 registers. Used in DDR4 designs only.
 */
#define DDRC_INIT6_MR4(x) (((uint32_t)(((uint32_t)(x)) << DDRC_INIT6_MR4_SHIFT)) & DDRC_INIT6_MR4_MASK)
/*! @} */

/*! @name INIT7 - SDRAM Initialization Register 7 */
/*! @{ */
#define DDRC_INIT7_MR6_MASK  (0xFFFF0000U)
#define DDRC_INIT7_MR6_SHIFT (16U)
/*! mr6 - DDR4- Value to be loaded into SDRAM MR6 registers. Used in DDR4 designs only.
 */
#define DDRC_INIT7_MR6(x) (((uint32_t)(((uint32_t)(x)) << DDRC_INIT7_MR6_SHIFT)) & DDRC_INIT7_MR6_MASK)
/*! @} */

/*! @name DIMMCTL - DIMM Control Register */
/*! @{ */
#define DDRC_DIMMCTL_DIMM_STAGGER_CS_EN_MASK  (0x1U)
#define DDRC_DIMMCTL_DIMM_STAGGER_CS_EN_SHIFT (0U)
/*! dimm_stagger_cs_en - Staggering enable for multi-rank accesses (for multi-rank UDIMM, RDIMM and
 *    LRDIMM implementations only). This is not supported for mDDR, LPDDR2, LPDDR3 or LPDDR4 SDRAMs.
 *    Even if this bit is set it does not take care of software driven MR commands (via
 *    MRCTRL0/MRCTRL1), where software is responsible to send them to separate ranks as appropriate.
 *  0b0..Do not stagger accesses
 *  0b1..(non-DDR4) Send all commands to even and odd ranks separately
 *  0b1..(DDR4) Send MRS commands to each ranks separately
 */
#define DDRC_DIMMCTL_DIMM_STAGGER_CS_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DIMMCTL_DIMM_STAGGER_CS_EN_SHIFT)) & DDRC_DIMMCTL_DIMM_STAGGER_CS_EN_MASK)
#define DDRC_DIMMCTL_DIMM_ADDR_MIRR_EN_MASK  (0x2U)
#define DDRC_DIMMCTL_DIMM_ADDR_MIRR_EN_SHIFT (1U)
/*! dimm_addr_mirr_en - Address Mirroring Enable (for multi-rank UDIMM implementations and
 *    multi-rank DDR4 RDIMM/LRDIMM implementations). Some UDIMMs and DDR4 RDIMMs/LRDIMMs implement address
 *    mirroring for odd ranks, which means that the following address, bank address and bank group
 *    bits are swapped: (A3, A4), (A5, A6), (A7, A8), (BA0, BA1) and also (A11, A13), (BG0, BG1) for
 *    the DDR4. Setting this bit ensures that, for mode register accesses during the automatic
 *    initialization routine, these bits are swapped within the DDRC to compensate for this
 *    UDIMM/RDIMM/LRDIMM swapping. In addition to the automatic initialization routine, in case of DDR4
 *    UDIMM/RDIMM/LRDIMM, they are swapped during the automatic MRS access to enable/disable of a particular
 *    DDR4 feature. Note: This has no effect on the address of any other memory accesses, or of
 *    software-driven mode register accesses. This is not supported for mDDR, LPDDR2, LPDDR3 or LPDDR4
 *    SDRAMs. Note: In case of x16 DDR4 DIMMs, BG1 output of MRS for the odd ranks is same as BG0
 *    because BG1 is invalid, hence dimm_dis_bg_mirroring register must be set to 1.
 *  0b0..Do not implement address mirroring
 *  0b1..For odd ranks, implement address mirroring for MRS commands to during initialization and for any
 *       automatic DDR4 MRS commands (to be used if UDIMM/RDIMM/LRDIMM implements address mirroring)
 */
#define DDRC_DIMMCTL_DIMM_ADDR_MIRR_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DIMMCTL_DIMM_ADDR_MIRR_EN_SHIFT)) & DDRC_DIMMCTL_DIMM_ADDR_MIRR_EN_MASK)
#define DDRC_DIMMCTL_DIMM_OUTPUT_INV_EN_MASK  (0x4U)
#define DDRC_DIMMCTL_DIMM_OUTPUT_INV_EN_SHIFT (2U)
/*! dimm_output_inv_en - Output Inversion Enable (for DDR4 RDIMM/LRDIMM implementations only). DDR4
 *    RDIMM/LRDIMM implements the Output Inversion feature by default, which means that the
 *    following address, bank address and bank group bits of B-side DRAMs are inverted: A3-A9, A11, A13,
 *    A17, BA0-BA1, BG0-BG1. Setting this bit ensures that, for mode register accesses generated by the
 *    DDRC during the automatic initialization routine and enabling of a particular DDR4 feature,
 *    separate A-side and B-side mode register accesses are generated. For B-side mode register
 *    accesses, these bits are inverted within the DDRC to compensate for this RDIMM/LRDIMM inversion. It
 *    is recommended to set this bit always, if using DDR4 RDIMMs/LRDIMMs. Note: This has no effect
 *    on the address of any other memory accesses, or of software-driven mode register accesses.
 *  0b0..Do not implement output inversion for B-side DRAMs.
 *  0b1..Implement output inversion for B-side DRAMs.
 */
#define DDRC_DIMMCTL_DIMM_OUTPUT_INV_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DIMMCTL_DIMM_OUTPUT_INV_EN_SHIFT)) & DDRC_DIMMCTL_DIMM_OUTPUT_INV_EN_MASK)
#define DDRC_DIMMCTL_MRS_A17_EN_MASK  (0x8U)
#define DDRC_DIMMCTL_MRS_A17_EN_SHIFT (3U)
/*! mrs_a17_en - Enable for A17 bit of MRS command. A17 bit of the mode register address is
 *    specified as RFU (Reserved for Future Use) and must be programmed to 0 during MRS. In case where DRAMs
 *    which do not have A17 are attached and the Output Inversion are enabled, this must be set to
 *    0, so that the calculation of CA parity will not include A17 bit. Note: This has no effect on
 *    the address of any other memory accesses, or of software-driven mode register accesses.
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define DDRC_DIMMCTL_MRS_A17_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DIMMCTL_MRS_A17_EN_SHIFT)) & DDRC_DIMMCTL_MRS_A17_EN_MASK)
#define DDRC_DIMMCTL_MRS_BG1_EN_MASK  (0x10U)
#define DDRC_DIMMCTL_MRS_BG1_EN_SHIFT (4U)
/*! mrs_bg1_en - Enable for BG1 bit of MRS command. BG1 bit of the mode register address is
 *    specified as RFU (Reserved for Future Use) and must be programmed to 0 during MRS. In case where DRAMs
 *    which do not have BG1 are attached and both the CA parity and the Output Inversion are
 *    enabled, this must be set to 0, so that the calculation of CA parity will not include BG1 bit. Note:
 *    This has no effect on the address of any other memory accesses, or of software-driven mode
 *    register accesses. If address mirroring is enabled, this is applied to BG1 of even ranks and BG0
 *    of odd ranks.
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define DDRC_DIMMCTL_MRS_BG1_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DIMMCTL_MRS_BG1_EN_SHIFT)) & DDRC_DIMMCTL_MRS_BG1_EN_MASK)
#define DDRC_DIMMCTL_DIMM_DIS_BG_MIRRORING_MASK  (0x20U)
#define DDRC_DIMMCTL_DIMM_DIS_BG_MIRRORING_SHIFT (5U)
/*! dimm_dis_bg_mirroring - Disabling Address Mirroring for BG bits. When this is set to 1, BG0 and
 *    BG1 are NOT swapped even if Address Mirroring is enabled. This will be required for DDR4 DIMMs
 *    with x16 devices.
 *  0b0..BG0 and BG1 are swapped if address mirroring is enabled.
 *  0b1..BG0 and BG1 are NOT swapped.
 */
#define DDRC_DIMMCTL_DIMM_DIS_BG_MIRRORING(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DIMMCTL_DIMM_DIS_BG_MIRRORING_SHIFT)) & \
     DDRC_DIMMCTL_DIMM_DIS_BG_MIRRORING_MASK)
#define DDRC_DIMMCTL_LRDIMM_BCOM_CMD_PROT_MASK  (0x40U)
#define DDRC_DIMMCTL_LRDIMM_BCOM_CMD_PROT_SHIFT (6U)
/*! lrdimm_bcom_cmd_prot - Protects the timing restrictions (tBCW/tMRC) between consecutive BCOM
 *    commands defined in the Data Buffer specification. When using DDR4 LRDIMM, this bit must be set
 *    to 1. Otherwise, this bit must be set to 0.
 */
#define DDRC_DIMMCTL_LRDIMM_BCOM_CMD_PROT(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DIMMCTL_LRDIMM_BCOM_CMD_PROT_SHIFT)) & DDRC_DIMMCTL_LRDIMM_BCOM_CMD_PROT_MASK)
/*! @} */

/*! @name RANKCTL - Rank Control Register */
/*! @{ */
#define DDRC_RANKCTL_MAX_RANK_RD_MASK  (0xFU)
#define DDRC_RANKCTL_MAX_RANK_RD_SHIFT (0U)
/*! max_rank_rd - Only present for multi-rank configurations. Background: Reads to the same rank can
 *    be performed back-to-back. Reads to different ranks require additional gap dictated by the
 *    register RANKCTL.diff_rank_rd_gap. This is to avoid possible data bus contention as well as to
 *    give PHY enough time to switch the delay when changing ranks. The DDRC arbitrates for bus
 *    access on a cycle-by-cycle basis; therefore after a read is scheduled, there are few clock cycles
 *    (determined by the value on RANKCTL.diff_rank_rd_gap register) in which only reads from the
 *    same rank are eligible to be scheduled. This prevents reads from other ranks from having fair
 *    access to the data bus. This parameter represents the maximum number of reads that can be
 *    scheduled consecutively to the same rank. After this number is reached, a delay equal to
 *    RANKCTL.diff_rank_rd_gap is inserted by the scheduler to allow all ranks a fair opportunity to be
 *    scheduled. Higher numbers increase bandwidth utilization, lower numbers increase fairness. This
 *    feature can be DISABLED by setting this register to 0. When set to 0, the Controller will stay on
 *    the same rank as long as commands are available for it. Minimum programmable value is 0 (feature
 *    disabled) and maximum programmable value is 0xF. FOR PERFORMANCE ONLY.
 */
#define DDRC_RANKCTL_MAX_RANK_RD(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_RANKCTL_MAX_RANK_RD_SHIFT)) & DDRC_RANKCTL_MAX_RANK_RD_MASK)
#define DDRC_RANKCTL_DIFF_RANK_RD_GAP_MASK  (0xF0U)
#define DDRC_RANKCTL_DIFF_RANK_RD_GAP_SHIFT (4U)
/*! diff_rank_rd_gap - Only present for multi-rank configurations. Indicates the number of clocks of
 *    gap in data responses when performing consecutive reads to different ranks. This is used to
 *    switch the delays in the PHY to match the rank requirements. This value should consider both
 *    PHY requirement and ODT requirement. - PHY requirement: tphy_rdcsgap + 1 (see PHY databook for
 *    value of tphy_rdcsgap) If read preamble is set to 2tCK(DDR4/LPDDR4 only), should be increased
 *    by 1. If read postamble is set to 1.5tCK(LPDDR4 only), should be increased by 1. - ODT
 *    requirement: The value programmed in this register takes care of the ODT switch off timing requirement
 *    when switching ranks during reads. When the controller is operating in 1:1 mode, program this
 *    to the larger of PHY requirement or ODT requirement. When the controller is operating in 1:2
 *    mode, program this to the larger value divided by two and round it up to the next integer.
 *    Note that, if using DDR4-LRDIMM, refer to TRDRD timing requirements in JEDEC DDR4 Data Buffer
 *    (DDR4DB01) Specification.
 */
#define DDRC_RANKCTL_DIFF_RANK_RD_GAP(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_RANKCTL_DIFF_RANK_RD_GAP_SHIFT)) & DDRC_RANKCTL_DIFF_RANK_RD_GAP_MASK)
#define DDRC_RANKCTL_DIFF_RANK_WR_GAP_MASK  (0xF00U)
#define DDRC_RANKCTL_DIFF_RANK_WR_GAP_SHIFT (8U)
/*! diff_rank_wr_gap - Only present for multi-rank configurations. Indicates the number of clocks of
 *    gap in data responses when performing consecutive writes to different ranks. This is used to
 *    switch the delays in the PHY to match the rank requirements. This value should consider both
 *    PHY requirement and ODT requirement. - PHY requirement: tphy_wrcsgap + 1 (see PHY databook for
 *    value of tphy_wrcsgap) If CRC feature is enabled, should be increased by 1. If write preamble
 *    is set to 2tCK(DDR4/LPDDR4 only), should be increased by 1. If write postamble is set to
 *    1.5tCK(LPDDR4 only), should be increased by 1. - ODT requirement: The value programmed in this
 *    register takes care of the ODT switch off timing requirement when switching ranks during writes.
 *    For LPDDR4, the requirement is ODTLoff - ODTLon - BL/2 + 1 When the controller is operating in
 *    1:1 mode, program this to the larger of PHY requirement or ODT requirement. When the
 *    controller is operating in 1:2 mode, program this to the larger value divided by two and round it up to
 *    the next integer. Note that, if using DDR4-LRDIMM, refer to TWRWR timing requirements in
 *    JEDEC DDR4 Data Buffer (DDR4DB01) Specification.
 */
#define DDRC_RANKCTL_DIFF_RANK_WR_GAP(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_RANKCTL_DIFF_RANK_WR_GAP_SHIFT)) & DDRC_RANKCTL_DIFF_RANK_WR_GAP_MASK)
/*! @} */

/*! @name DRAMTMG0 - SDRAM Timing Register 0 */
/*! @{ */
#define DDRC_DRAMTMG0_T_RAS_MIN_MASK  (0x3FU)
#define DDRC_DRAMTMG0_T_RAS_MIN_SHIFT (0U)
/*! t_ras_min - tRAS(min): Minimum time between activate and precharge to the same bank. When the
 *    controller is operating in 1:2 frequency mode, 1T mode, program this to tRAS(min)/2. No rounding
 *    up. When the controller is operating in 1:2 frequency ratio mode, 2T mode or LPDDR4 mode,
 *    program this to (tRAS(min)/2) and round it up to the next integer value. Unit: Clocks
 */
#define DDRC_DRAMTMG0_T_RAS_MIN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG0_T_RAS_MIN_SHIFT)) & DDRC_DRAMTMG0_T_RAS_MIN_MASK)
#define DDRC_DRAMTMG0_T_RAS_MAX_MASK  (0x7F00U)
#define DDRC_DRAMTMG0_T_RAS_MAX_SHIFT (8U)
/*! t_ras_max - tRAS(max): Maximum time between activate and precharge to same bank. This is the
 *    maximum time that a page can be kept open Minimum value of this register is 1. Zero is invalid.
 *    When the controller is operating in 1:2 frequency ratio mode, program this to (tRAS(max)-1)/2.
 *    No rounding up. Unit: Multiples of 1024 clocks.
 */
#define DDRC_DRAMTMG0_T_RAS_MAX(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG0_T_RAS_MAX_SHIFT)) & DDRC_DRAMTMG0_T_RAS_MAX_MASK)
#define DDRC_DRAMTMG0_T_FAW_MASK  (0x3F0000U)
#define DDRC_DRAMTMG0_T_FAW_SHIFT (16U)
/*! t_faw - tFAW Valid only when 8 or more banks(or banks x bank groups) are present. In 8-bank
 *    design, at most 4 banks must be activated in a rolling window of tFAW cycles. When the controller
 *    is operating in 1:2 frequency ratio mode, program this to (tFAW/2) and round up to next
 *    integer value. In a 4-bank design, set this register to 0x1 independent of the 1:1/1:2 frequency
 *    mode. Unit: Clocks
 */
#define DDRC_DRAMTMG0_T_FAW(x)     (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG0_T_FAW_SHIFT)) & DDRC_DRAMTMG0_T_FAW_MASK)
#define DDRC_DRAMTMG0_WR2PRE_MASK  (0x7F000000U)
#define DDRC_DRAMTMG0_WR2PRE_SHIFT (24U)
/*! wr2pre - Minimum time between write and precharge to same bank. Unit: Clocks Specifications: WL
 *    + BL/2 + tWR = approximately 8 cycles + 15 ns = 14 clocks @400MHz and less for lower
 *    frequencies where: - WL = write latency - BL = burst length. This must match the value programmed in
 *    the BL bit of the mode register to the SDRAM. BST (burst terminate) is not supported at present.
 *    - tWR = Write recovery time. This comes directly from the SDRAM specification. Add one extra
 *    cycle for LPDDR2/LPDDR3/LPDDR4 for this parameter. When the controller is operating in 1:2
 *    frequency ratio mode, 1T mode, divide the above value by 2. No rounding up. When the controller
 *    is operating in 1:2 frequency ratio mode, 2T mode or LPDDR4 mode, divide the above value by 2
 *    and round it up to the next integer value. Note that, depending on the PHY, if using LRDIMM, it
 *    may be necessary to adjust the value of this parameter to compensate for the extra cycle of
 *    latency through the LRDIMM.
 */
#define DDRC_DRAMTMG0_WR2PRE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG0_WR2PRE_SHIFT)) & DDRC_DRAMTMG0_WR2PRE_MASK)
/*! @} */

/*! @name DRAMTMG1 - SDRAM Timing Register 1 */
/*! @{ */
#define DDRC_DRAMTMG1_T_RC_MASK  (0x7FU)
#define DDRC_DRAMTMG1_T_RC_SHIFT (0U)
/*! t_rc - tRC: Minimum time between activates to same bank. When the controller is operating in 1:2
 *    frequency ratio mode, program this to (tRC/2) and round up to next integer value. Unit:
 *    Clocks.
 */
#define DDRC_DRAMTMG1_T_RC(x)      (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG1_T_RC_SHIFT)) & DDRC_DRAMTMG1_T_RC_MASK)
#define DDRC_DRAMTMG1_RD2PRE_MASK  (0x3F00U)
#define DDRC_DRAMTMG1_RD2PRE_SHIFT (8U)
/*! rd2pre - tRTP: Minimum time from read to precharge of same bank. - DDR2: tAL + BL/2 + max(tRTP,
 *    2) - 2 - DDR3: tAL + max (tRTP, 4) - DDR4: Max of following two equations: tAL + max (tRTP, 4)
 *    or, RL + BL/2 - tRP (*). - mDDR: BL/2 - LPDDR2: Depends on if it's LPDDR2-S2 or LPDDR2-S4:
 *    LPDDR2-S2: BL/2 + tRTP - 1. LPDDR2-S4: BL/2 + max(tRTP,2) - 2. - LPDDR3: BL/2 + max(tRTP,4) - 4
 *    - LPDDR4: BL/2 + max(tRTP,8) - 8 (*) When both DDR4 SDRAM and ST-MRAM are used simultaneously,
 *    use SDRAM's tRP value for calculation. When the controller is operating in 1:2 mode, 1T mode,
 *    divide the above value by 2. No rounding up. When the controller is operating in 1:2 mode, 2T
 *    mode or LPDDR4 mode, divide the above value by 2 and round it up to the next integer value.
 *    Unit: Clocks.
 */
#define DDRC_DRAMTMG1_RD2PRE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG1_RD2PRE_SHIFT)) & DDRC_DRAMTMG1_RD2PRE_MASK)
#define DDRC_DRAMTMG1_T_XP_MASK  (0x1F0000U)
#define DDRC_DRAMTMG1_T_XP_SHIFT (16U)
/*! t_xp - tXP: Minimum time after power-down exit to any operation. For DDR3, this should be
 *    programmed to tXPDLL if slow powerdown exit is selected in MR0[12]. If C/A parity for DDR4 is used,
 *    set to (tXP+PL) instead. When the controller is operating in 1:2 frequency ratio mode, program
 *    this to (tXP/2) and round it up to the next integer value. Units: Clocks
 */
#define DDRC_DRAMTMG1_T_XP(x) (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG1_T_XP_SHIFT)) & DDRC_DRAMTMG1_T_XP_MASK)
/*! @} */

/*! @name DRAMTMG2 - SDRAM Timing Register 2 */
/*! @{ */
#define DDRC_DRAMTMG2_WR2RD_MASK  (0x3FU)
#define DDRC_DRAMTMG2_WR2RD_SHIFT (0U)
/*! wr2rd - DDR4: CWL + PL + BL/2 + tWTR_L Others: CWL + BL/2 + tWTR In DDR4, minimum time from
 *    write command to read command for same bank group. In others, minimum time from write command to
 *    read command. Includes time for bus turnaround, recovery times, and all per-bank, per-rank, and
 *    global constraints. Unit: Clocks. Where: - CWL = CAS write latency - PL = Parity latency - BL
 *    = burst length. This must match the value programmed in the BL bit of the mode register to
 *    the SDRAM - tWTR_L = internal write to read command delay for same bank group. This comes
 *    directly from the SDRAM specification. - tWTR = internal write to read command delay. This comes
 *    directly from the SDRAM specification. Add one extra cycle for LPDDR2/LPDDR3/LPDDR4 operation.
 *    When the controller is operating in 1:2 mode, divide the value calculated using the above
 *    equation by 2, and round it up to next integer.
 */
#define DDRC_DRAMTMG2_WR2RD(x)    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG2_WR2RD_SHIFT)) & DDRC_DRAMTMG2_WR2RD_MASK)
#define DDRC_DRAMTMG2_RD2WR_MASK  (0x3F00U)
#define DDRC_DRAMTMG2_RD2WR_SHIFT (8U)
/*! rd2wr - DDR2/3/mDDR: RL + BL/2 + 2 - WL DDR4: RL + BL/2 + 1 + WR_PREAMBLE - WL LPDDR2/LPDDR3: RL
 *    + BL/2 + RU(tDQSCKmax/tCK) + 1 - WL LPDDR4(DQ ODT is Disabled): RL + BL/2 + RU(tDQSCKmax/tCK)
 *    + WR_PREAMBLE + RD_POSTAMBLE - WL LPDDR4(DQ ODT is Enabled) : RL + BL/2 + RU(tDQSCKmax/tCK) +
 *    RD_POSTAMBLE - ODTLon - RU(tODTon(min)/tCK) Minimum time from read command to write command.
 *    Include time for bus turnaround and all per-bank, per-rank, and global constraints. Please see
 *    the relevant PHY databook for details of what should be included here. Unit: Clocks. Where: -
 *    WL = write latency - BL = burst length. This must match the value programmed in the BL bit of
 *    the mode register to the SDRAM - RL = read latency = CAS latency - WR_PREAMBLE = write
 *    preamble. This is unique to DDR4 and LPDDR4. - RD_POSTAMBLE = read postamble. This is unique to
 *    LPDDR4. For LPDDR2/LPDDR3/LPDDR4, if derating is enabled (DERATEEN.derate_enable=1), derated
 *    tDQSCKmax should be used. When the controller is operating in 1:2 frequency ratio mode, divide the
 *    value calculated using the above equation by 2, and round it up to next integer. Note that,
 *    depending on the PHY, if using LRDIMM, it may be necessary to adjust the value of this parameter
 *    to compensate for the extra cycle of latency through the LRDIMM.
 */
#define DDRC_DRAMTMG2_RD2WR(x)           (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG2_RD2WR_SHIFT)) & DDRC_DRAMTMG2_RD2WR_MASK)
#define DDRC_DRAMTMG2_READ_LATENCY_MASK  (0x3F0000U)
#define DDRC_DRAMTMG2_READ_LATENCY_SHIFT (16U)
/*! read_latency - Set to RL Time from read command to read data on SDRAM interface. This must be
 *    set to RL. Note that, depending on the PHY, if using RDIMM/LRDIMM, it may be necessary to adjust
 *    the value of RL to compensate for the extra cycle of latency through the RDIMM/LRDIMM. When
 *    the controller is operating in 1:2 frequency ratio mode, divide the value calculated using the
 *    above equation by 2, and round it up to next integer. This register field is not required for
 *    DDR2 and DDR3 (except if MEMC_TRAINING is set), as the DFI read and write latencies defined in
 *    DFITMG0 and DFITMG1 are sufficient for those protocols Unit: clocks
 */
#define DDRC_DRAMTMG2_READ_LATENCY(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG2_READ_LATENCY_SHIFT)) & DDRC_DRAMTMG2_READ_LATENCY_MASK)
#define DDRC_DRAMTMG2_WRITE_LATENCY_MASK  (0x3F000000U)
#define DDRC_DRAMTMG2_WRITE_LATENCY_SHIFT (24U)
/*! write_latency - Set to WL Time from write command to write data on SDRAM interface. This must be
 *    set to WL. For mDDR, it should normally be set to 1. Note that, depending on the PHY, if
 *    using RDIMM/LRDIMM, it may be necessary to adjust the value of WL to compensate for the extra
 *    cycle of latency through the RDIMM/LRDIMM. When the controller is operating in 1:2 frequency ratio
 *    mode, divide the value calculated using the above equation by 2, and round it up to next
 *    integer. This register field is not required for DDR2 and DDR3 (except if MEMC_TRAINING is set),
 *    as the DFI read and write latencies defined in DFITMG0 and DFITMG1 are sufficient for those
 *    protocols Unit: clocks
 */
#define DDRC_DRAMTMG2_WRITE_LATENCY(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG2_WRITE_LATENCY_SHIFT)) & DDRC_DRAMTMG2_WRITE_LATENCY_MASK)
/*! @} */

/*! @name DRAMTMG3 - SDRAM Timing Register 3 */
/*! @{ */
#define DDRC_DRAMTMG3_T_MOD_MASK  (0x3FFU)
#define DDRC_DRAMTMG3_T_MOD_SHIFT (0U)
/*! t_mod - tMOD: Parameter used only in DDR3 and DDR4. Cycles between load mode command and
 *    following non-load mode command. If C/A parity for DDR4 is used, set to tMOD_PAR(tMOD+PL) instead.
 *    Set to tMOD if controller is operating in 1:1 frequency ratio mode, or tMOD/2 (rounded up to
 *    next integer) if controller is operating in 1:2 frequency ratio mode. Note that if using
 *    RDIMM/LRDIMM, depending on the PHY, it may be necessary to adjust the value of this parameter to
 *    compensate for the extra cycle of latency applied to mode register writes by the RDIMM/LRDIMM chip.
 *    Also note that if using LRDIMM, the minimum value of this register is tMRD_L2 if controller
 *    is operating in 1:1 frequency ratio mode, or tMRD_L2/2 (rounded up to next integer) if
 *    controller is operating in 1:2 frequency ratio mode.
 */
#define DDRC_DRAMTMG3_T_MOD(x)    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG3_T_MOD_SHIFT)) & DDRC_DRAMTMG3_T_MOD_MASK)
#define DDRC_DRAMTMG3_T_MRD_MASK  (0x3F000U)
#define DDRC_DRAMTMG3_T_MRD_SHIFT (12U)
/*! t_mrd - tMRD: Cycles to wait after a mode register write or read. Depending on the connected
 *    SDRAM, tMRD represents: DDR2/mDDR: Time from MRS to any command DDR3/4: Time from MRS to MRS
 *    command LPDDR2: not used LPDDR3/4: Time from MRS to non-MRS command. When the controller is
 *    operating in 1:2 frequency ratio mode, program this to (tMRD/2) and round it up to the next integer
 *    value. If C/A parity for DDR4 is used, set to tMRD_PAR(tMOD+PL) instead.
 */
#define DDRC_DRAMTMG3_T_MRD(x)    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG3_T_MRD_SHIFT)) & DDRC_DRAMTMG3_T_MRD_MASK)
#define DDRC_DRAMTMG3_T_MRW_MASK  (0x3FF00000U)
#define DDRC_DRAMTMG3_T_MRW_SHIFT (20U)
/*! t_mrw - Time to wait after a mode register write or read (MRW or MRR). Present only in designs
 *    configured to support LPDDR2, LPDDR3 or LPDDR4. LPDDR2 typically requires value of 5. LPDDR3
 *    typically requires value of 10. LPDDR4: Set this to the larger of tMRW and tMRWCKEL. For LPDDR2,
 *    this register is used for the time from a MRW/MRR to all other commands. When the controller
 *    is operating in 1:2 frequency ratio mode, program this to the above values divided by 2 and
 *    round it up to the next integer value. For LDPDR3, this register is used for the time from a
 *    MRW/MRR to a MRW/MRR.
 */
#define DDRC_DRAMTMG3_T_MRW(x) (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG3_T_MRW_SHIFT)) & DDRC_DRAMTMG3_T_MRW_MASK)
/*! @} */

/*! @name DRAMTMG4 - SDRAM Timing Register 4 */
/*! @{ */
#define DDRC_DRAMTMG4_T_RP_MASK  (0x1FU)
#define DDRC_DRAMTMG4_T_RP_SHIFT (0U)
/*! t_rp - tRP: Minimum time from precharge to activate of same bank. When the controller is
 *    operating in 1:1 frequency ratio mode, t_rp should be set to RoundUp(tRP/tCK). When the controller is
 *    operating in 1:2 frequency ratio mode, t_rp should be set to RoundDown(RoundUp(tRP/tCK)/2) +
 *    1. When the controller is operating in 1:2 frequency ratio mode in LPDDR4, t_rp should be set
 *    to RoundUp(RoundUp(tRP/tCK)/2). Unit: Clocks.
 */
#define DDRC_DRAMTMG4_T_RP(x)     (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG4_T_RP_SHIFT)) & DDRC_DRAMTMG4_T_RP_MASK)
#define DDRC_DRAMTMG4_T_RRD_MASK  (0xF00U)
#define DDRC_DRAMTMG4_T_RRD_SHIFT (8U)
/*! t_rrd - DDR4: tRRD_L: Minimum time between activates from bank "a" to bank "b" for same bank
 *    group. Others: tRRD: Minimum time between activates from bank "a" to bank "b" When the controller
 *    is operating in 1:2 frequency ratio mode, program this to (tRRD_L/2 or tRRD/2) and round it
 *    up to the next integer value. Unit: Clocks.
 */
#define DDRC_DRAMTMG4_T_RRD(x)    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG4_T_RRD_SHIFT)) & DDRC_DRAMTMG4_T_RRD_MASK)
#define DDRC_DRAMTMG4_T_CCD_MASK  (0xF0000U)
#define DDRC_DRAMTMG4_T_CCD_SHIFT (16U)
/*! t_ccd - DDR4: tCCD_L: This is the minimum time between two reads or two writes for same bank
 *    group. Others: tCCD: This is the minimum time between two reads or two writes. When the
 *    controller is operating in 1:2 frequency ratio mode, program this to (tCCD_L/2 or tCCD/2) and round it
 *    up to the next integer value. Unit: clocks.
 */
#define DDRC_DRAMTMG4_T_CCD(x)    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG4_T_CCD_SHIFT)) & DDRC_DRAMTMG4_T_CCD_MASK)
#define DDRC_DRAMTMG4_T_RCD_MASK  (0x1F000000U)
#define DDRC_DRAMTMG4_T_RCD_SHIFT (24U)
/*! t_rcd - tRCD - tAL: Minimum time from activate to read or write command to same bank. When the
 *    controller is operating in 1:2 frequency ratio mode, program this to ((tRCD - tAL)/2) and round
 *    it up to the next integer value. Minimum value allowed for this register is 1, which implies
 *    minimum (tRCD - tAL) value to be 2 when the controller is operating in 1:2 frequency ratio
 *    mode. Unit: Clocks.
 */
#define DDRC_DRAMTMG4_T_RCD(x) (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG4_T_RCD_SHIFT)) & DDRC_DRAMTMG4_T_RCD_MASK)
/*! @} */

/*! @name DRAMTMG5 - SDRAM Timing Register 5 */
/*! @{ */
#define DDRC_DRAMTMG5_T_CKE_MASK  (0x1FU)
#define DDRC_DRAMTMG5_T_CKE_SHIFT (0U)
/*! t_cke - Minimum number of cycles of CKE HIGH/LOW during power-down and self refresh. -
 *    LPDDR2/LPDDR3 mode: Set this to the larger of tCKE or tCKESR - LPDDR4 mode: Set this to the larger of
 *    tCKE, tCKELPD or tSR. - Non-LPDDR2/non-LPDDR3/non-LPDDR4 designs: Set this to tCKE value. When
 *    the controller is operating in 1:2 frequency ratio mode, program this to (value described
 *    above)/2 and round it up to the next integer value. Unit: Clocks.
 */
#define DDRC_DRAMTMG5_T_CKE(x)      (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG5_T_CKE_SHIFT)) & DDRC_DRAMTMG5_T_CKE_MASK)
#define DDRC_DRAMTMG5_T_CKESR_MASK  (0x3F00U)
#define DDRC_DRAMTMG5_T_CKESR_SHIFT (8U)
/*! t_ckesr - Minimum CKE low width for Self refresh or Self refresh power down entry to exit timing
 *    in memory clock cycles. Recommended settings: - mDDR: tRFC - LPDDR2: tCKESR - LPDDR3: tCKESR
 *    - LPDDR4: max(tCKELPD, tSR) - DDR2: tCKE - DDR3: tCKE + 1 - DDR4: tCKE + 1 (+ PL(parity
 *    latency)(*)) (*)Only if CRCPARCTL1.caparity_disable_before_sr=0, this register should be increased
 *    by PL. When the controller is operating in 1:2 frequency ratio mode, program this to
 *    recommended value divided by two and round it up to next integer.
 */
#define DDRC_DRAMTMG5_T_CKESR(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG5_T_CKESR_SHIFT)) & DDRC_DRAMTMG5_T_CKESR_MASK)
#define DDRC_DRAMTMG5_T_CKSRE_MASK  (0xF0000U)
#define DDRC_DRAMTMG5_T_CKSRE_SHIFT (16U)
/*! t_cksre - This is the time after Self Refresh Down Entry that CK is maintained as a valid clock.
 *    Specifies the clock disable delay after SRE. Recommended settings: - mDDR: 0 - LPDDR2: 2 -
 *    LPDDR3: 2 - LPDDR4: tCKCKEL - DDR2: 1 - DDR3: max (10 ns, 5 tCK) - DDR4: max (10 ns, 5 tCK) (+
 *    PL(parity latency)(*)) (*)Only if CRCPARCTL1.caparity_disable_before_sr=0, this register should
 *    be increased by PL. When the controller is operating in 1:2 frequency ratio mode, program
 *    this to recommended value divided by two and round it up to next integer.
 */
#define DDRC_DRAMTMG5_T_CKSRE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG5_T_CKSRE_SHIFT)) & DDRC_DRAMTMG5_T_CKSRE_MASK)
#define DDRC_DRAMTMG5_T_CKSRX_MASK  (0xF000000U)
#define DDRC_DRAMTMG5_T_CKSRX_SHIFT (24U)
/*! t_cksrx - This is the time before Self Refresh Exit that CK is maintained as a valid clock
 *    before issuing SRX. Specifies the clock stable time before SRX. Recommended settings: - mDDR: 1 -
 *    LPDDR2: 2 - LPDDR3: 2 - LPDDR4: tCKCKEH - DDR2: 1 - DDR3: tCKSRX - DDR4: tCKSRX When the
 *    controller is operating in 1:2 frequency ratio mode, program this to recommended value divided by
 *    two and round it up to next integer.
 */
#define DDRC_DRAMTMG5_T_CKSRX(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG5_T_CKSRX_SHIFT)) & DDRC_DRAMTMG5_T_CKSRX_MASK)
/*! @} */

/*! @name DRAMTMG6 - SDRAM Timing Register 6 */
/*! @{ */
#define DDRC_DRAMTMG6_T_CKCSX_MASK  (0xFU)
#define DDRC_DRAMTMG6_T_CKCSX_SHIFT (0U)
/*! t_ckcsx - This is the time before Clock Stop Exit that CK is maintained as a valid clock before
 *    issuing Clock Stop Exit. Specifies the clock stable time before next command after Clock Stop
 *    Exit. Recommended settings: - mDDR: 1 - LPDDR2: tXP + 2 - LPDDR3: tXP + 2 - LPDDR4: tXP + 2
 *    When the controller is operating in 1:2 frequency ratio mode, program this to recommended value
 *    divided by two and round it up to next integer. This is only present for designs supporting
 *    mDDR or LPDDR2/LPDDR3/LPDDR4 devices.
 */
#define DDRC_DRAMTMG6_T_CKCSX(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG6_T_CKCSX_SHIFT)) & DDRC_DRAMTMG6_T_CKCSX_MASK)
#define DDRC_DRAMTMG6_T_CKDPDX_MASK  (0xF0000U)
#define DDRC_DRAMTMG6_T_CKDPDX_SHIFT (16U)
/*! t_ckdpdx - This is the time before Deep Power Down Exit that CK is maintained as a valid clock
 *    before issuing DPDX. Specifies the clock stable time before DPDX. Recommended settings: - mDDR:
 *    1 - LPDDR2: 2 - LPDDR3: 2 When the controller is operating in 1:2 frequency ratio mode,
 *    program this to recommended value divided by two and round it up to next integer. This is only
 *    present for designs supporting mDDR or LPDDR2 devices.
 */
#define DDRC_DRAMTMG6_T_CKDPDX(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG6_T_CKDPDX_SHIFT)) & DDRC_DRAMTMG6_T_CKDPDX_MASK)
#define DDRC_DRAMTMG6_T_CKDPDE_MASK  (0xF000000U)
#define DDRC_DRAMTMG6_T_CKDPDE_SHIFT (24U)
/*! t_ckdpde - This is the time after Deep Power Down Entry that CK is maintained as a valid clock.
 *    Specifies the clock disable delay after DPDE. Recommended settings: - mDDR: 0 - LPDDR2: 2 -
 *    LPDDR3: 2 When the controller is operating in 1:2 frequency ratio mode, program this to
 *    recommended value divided by two and round it up to next integer. This is only present for designs
 *    supporting mDDR or LPDDR2/LPDDR3 devices.
 */
#define DDRC_DRAMTMG6_T_CKDPDE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG6_T_CKDPDE_SHIFT)) & DDRC_DRAMTMG6_T_CKDPDE_MASK)
/*! @} */

/*! @name DRAMTMG7 - SDRAM Timing Register 7 */
/*! @{ */
#define DDRC_DRAMTMG7_T_CKPDX_MASK  (0xFU)
#define DDRC_DRAMTMG7_T_CKPDX_SHIFT (0U)
/*! t_ckpdx - This is the time before Power Down Exit that CK is maintained as a valid clock before
 *    issuing PDX. Specifies the clock stable time before PDX. Recommended settings: - mDDR: 0 -
 *    LPDDR2: 2 - LPDDR3: 2 - LPDDR4: 2 When using DDR2/3/4 SDRAM, this register should be set to the
 *    same value as DRAMTMG5.t_cksrx. When the controller is operating in 1:2 frequency ratio mode,
 *    program this to recommended value divided by two and round it up to next integer. This is only
 *    present for designs supporting mDDR or LPDDR2/LPDDR3/LPDDR4 devices.
 */
#define DDRC_DRAMTMG7_T_CKPDX(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG7_T_CKPDX_SHIFT)) & DDRC_DRAMTMG7_T_CKPDX_MASK)
#define DDRC_DRAMTMG7_T_CKPDE_MASK  (0xF00U)
#define DDRC_DRAMTMG7_T_CKPDE_SHIFT (8U)
/*! t_ckpde - This is the time after Power Down Entry that CK is maintained as a valid clock.
 *    Specifies the clock disable delay after PDE. Recommended settings: - mDDR: 0 - LPDDR2: 2 - LPDDR3: 2
 *    - LPDDR4: tCKCKEL When using DDR2/3/4 SDRAM, this register should be set to the same value as
 *    DRAMTMG5.t_cksre. When the controller is operating in 1:2 frequency ratio mode, program this
 *    to recommended value divided by two and round it up to next integer. This is only present for
 *    designs supporting mDDR or LPDDR2/LPDDR3/LPDDR4 devices.
 */
#define DDRC_DRAMTMG7_T_CKPDE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG7_T_CKPDE_SHIFT)) & DDRC_DRAMTMG7_T_CKPDE_MASK)
/*! @} */

/*! @name DRAMTMG8 - SDRAM Timing Register 8 */
/*! @{ */
#define DDRC_DRAMTMG8_T_XS_X32_MASK  (0x7FU)
#define DDRC_DRAMTMG8_T_XS_X32_SHIFT (0U)
/*! t_xs_x32 - tXS: Exit Self Refresh to commands not requiring a locked DLL. When the controller is
 *    operating in 1:2 frequency ratio mode, program this to the above value divided by 2 and round
 *    up to next integer value. Unit: Multiples of 32 clocks. Note: Used only for DDR2, DDR3 and
 *    DDR4 SDRAMs.
 */
#define DDRC_DRAMTMG8_T_XS_X32(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG8_T_XS_X32_SHIFT)) & DDRC_DRAMTMG8_T_XS_X32_MASK)
#define DDRC_DRAMTMG8_T_XS_DLL_X32_MASK  (0x7F00U)
#define DDRC_DRAMTMG8_T_XS_DLL_X32_SHIFT (8U)
/*! t_xs_dll_x32 - tXSDLL: Exit Self Refresh to commands requiring a locked DLL. When the controller
 *    is operating in 1:2 frequency ratio mode, program this to the above value divided by 2 and
 *    round up to next integer value. Unit: Multiples of 32 clocks. Note: Used only for DDR2, DDR3 and
 *    DDR4 SDRAMs.
 */
#define DDRC_DRAMTMG8_T_XS_DLL_X32(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG8_T_XS_DLL_X32_SHIFT)) & DDRC_DRAMTMG8_T_XS_DLL_X32_MASK)
#define DDRC_DRAMTMG8_T_XS_ABORT_X32_MASK  (0x7F0000U)
#define DDRC_DRAMTMG8_T_XS_ABORT_X32_SHIFT (16U)
/*! t_xs_abort_x32 - tXS_ABORT: Exit Self Refresh to commands not requiring a locked DLL in Self
 *    Refresh Abort. When the controller is operating in 1:2 frequency ratio mode, program this to the
 *    above value divided by 2 and round up to next integer value. Unit: Multiples of 32 clocks.
 *    Note: Ensure this is less than or equal to t_xs_x32.
 */
#define DDRC_DRAMTMG8_T_XS_ABORT_X32(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG8_T_XS_ABORT_X32_SHIFT)) & DDRC_DRAMTMG8_T_XS_ABORT_X32_MASK)
#define DDRC_DRAMTMG8_T_XS_FAST_X32_MASK  (0x7F000000U)
#define DDRC_DRAMTMG8_T_XS_FAST_X32_SHIFT (24U)
/*! t_xs_fast_x32 - tXS_FAST: Exit Self Refresh to ZQCL, ZQCS and MRS (only CL, WR, RTP and Geardown
 *    mode). When the controller is operating in 1:2 frequency ratio mode, program this to the
 *    above value divided by 2 and round up to next integer value. Unit: Multiples of 32 clocks. Note:
 *    This is applicable to only ZQCL/ZQCS commands. Note: Ensure this is less than or equal to
 *    t_xs_x32.
 */
#define DDRC_DRAMTMG8_T_XS_FAST_X32(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG8_T_XS_FAST_X32_SHIFT)) & DDRC_DRAMTMG8_T_XS_FAST_X32_MASK)
/*! @} */

/*! @name DRAMTMG9 - SDRAM Timing Register 9 */
/*! @{ */
#define DDRC_DRAMTMG9_WR2RD_S_MASK  (0x3FU)
#define DDRC_DRAMTMG9_WR2RD_S_SHIFT (0U)
/*! wr2rd_s - CWL + PL + BL/2 + tWTR_S Minimum time from write command to read command for different
 *    bank group. Includes time for bus turnaround, recovery times, and all per-bank, per-rank, and
 *    global constraints. Present only in designs configured to support DDR4. Unit: Clocks. Where:
 *    - CWL = CAS write latency - PL = Parity latency - BL = burst length. This must match the value
 *    programmed in the BL bit of the mode register to the SDRAM - tWTR_S = internal write to read
 *    command delay for different bank group. This comes directly from the SDRAM specification. When
 *    the controller is operating in 1:2 mode, divide the value calculated using the above equation
 *    by 2, and round it up to next integer.
 */
#define DDRC_DRAMTMG9_WR2RD_S(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG9_WR2RD_S_SHIFT)) & DDRC_DRAMTMG9_WR2RD_S_MASK)
#define DDRC_DRAMTMG9_T_RRD_S_MASK  (0xF00U)
#define DDRC_DRAMTMG9_T_RRD_S_SHIFT (8U)
/*! t_rrd_s - tRRD_S: Minimum time between activates from bank "a" to bank "b" for different bank
 *    group. When the controller is operating in 1:2 frequency ratio mode, program this to (tRRD_S/2)
 *    and round it up to the next integer value. Present only in designs configured to support DDR4.
 *    Unit: Clocks.
 */
#define DDRC_DRAMTMG9_T_RRD_S(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG9_T_RRD_S_SHIFT)) & DDRC_DRAMTMG9_T_RRD_S_MASK)
#define DDRC_DRAMTMG9_T_CCD_S_MASK  (0x70000U)
#define DDRC_DRAMTMG9_T_CCD_S_SHIFT (16U)
/*! t_ccd_s - tCCD_S: This is the minimum time between two reads or two writes for different bank
 *    group. For bank switching (from bank "a" to bank "b"), the minimum time is this value + 1. When
 *    the controller is operating in 1:2 frequency ratio mode, program this to (tCCD_S/2) and round
 *    it up to the next integer value. Present only in designs configured to support DDR4. Unit:
 *    clocks.
 */
#define DDRC_DRAMTMG9_T_CCD_S(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG9_T_CCD_S_SHIFT)) & DDRC_DRAMTMG9_T_CCD_S_MASK)
#define DDRC_DRAMTMG9_DDR4_WR_PREAMBLE_MASK  (0x40000000U)
#define DDRC_DRAMTMG9_DDR4_WR_PREAMBLE_SHIFT (30U)
/*! ddr4_wr_preamble - DDR4 Write preamble mode - 0: 1tCK preamble - 1: 2tCK preamble Present only with
 * MEMC_FREQ_RATIO=2
 */
#define DDRC_DRAMTMG9_DDR4_WR_PREAMBLE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG9_DDR4_WR_PREAMBLE_SHIFT)) & DDRC_DRAMTMG9_DDR4_WR_PREAMBLE_MASK)
/*! @} */

/*! @name DRAMTMG10 - SDRAM Timing Register 10 */
/*! @{ */
#define DDRC_DRAMTMG10_T_GEAR_HOLD_MASK  (0x3U)
#define DDRC_DRAMTMG10_T_GEAR_HOLD_SHIFT (0U)
/*! t_gear_hold - Geardown hold time. Minimum value of this register is 1. Zero is invalid. For
 *    DDR4-2666 and DDR4-3200, this parameter is defined as 2 clks When the controller is operating in
 *    1:2 frequency ratio mode, program this to (tGEAR_hold/2) and round it up to the next integer
 *    value. Unit: Clocks
 */
#define DDRC_DRAMTMG10_T_GEAR_HOLD(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG10_T_GEAR_HOLD_SHIFT)) & DDRC_DRAMTMG10_T_GEAR_HOLD_MASK)
#define DDRC_DRAMTMG10_T_GEAR_SETUP_MASK  (0xCU)
#define DDRC_DRAMTMG10_T_GEAR_SETUP_SHIFT (2U)
/*! t_gear_setup - Geardown setup time. Minimum value of this register is 1. Zero is invalid. For
 *    DDR4-2666 and DDR4-3200, this parameter is defined as 2 clks When the controller is operating in
 *    1:2 frequency ratio mode, program this to (tGEAR_setup/2) and round it up to the next integer
 *    value. Unit: Clocks
 */
#define DDRC_DRAMTMG10_T_GEAR_SETUP(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG10_T_GEAR_SETUP_SHIFT)) & DDRC_DRAMTMG10_T_GEAR_SETUP_MASK)
#define DDRC_DRAMTMG10_T_CMD_GEAR_MASK  (0x1F00U)
#define DDRC_DRAMTMG10_T_CMD_GEAR_SHIFT (8U)
/*! t_cmd_gear - Sync pulse to first valid command. For DDR4-2666 and DDR4-3200, this parameter is
 *    defined as tMOD(min) tMOD(min) is greater of 24nCK or 15ns 15ns / .625ns = 24 Max value for
 *    this register is 24 When the controller is operating in 1:2 mode, program this to (tCMD_GEAR/2)
 *    and round it up to the next integer value. Unit: Clocks
 */
#define DDRC_DRAMTMG10_T_CMD_GEAR(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG10_T_CMD_GEAR_SHIFT)) & DDRC_DRAMTMG10_T_CMD_GEAR_MASK)
#define DDRC_DRAMTMG10_T_SYNC_GEAR_MASK  (0x1F0000U)
#define DDRC_DRAMTMG10_T_SYNC_GEAR_SHIFT (16U)
/*! t_sync_gear - Indicates the time between MRS command and the sync pulse time. This must be even
 *    number of clocks. For DDR4-2666 and DDR4-3200, this parameter is defined as tMOD(min)+4nCK
 *    tMOD(min) is greater of 24nCK or 15ns 15ns / .625ns = 24 Max value for this register is 24+4 = 28
 *    When the controller is operating in 1:2 mode, program this to (tSYNC_GEAR/2) and round it up
 *    to the next integer value. Unit: Clocks
 */
#define DDRC_DRAMTMG10_T_SYNC_GEAR(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG10_T_SYNC_GEAR_SHIFT)) & DDRC_DRAMTMG10_T_SYNC_GEAR_MASK)
/*! @} */

/*! @name DRAMTMG11 - SDRAM Timing Register 11 */
/*! @{ */
#define DDRC_DRAMTMG11_T_CKMPE_MASK  (0x1FU)
#define DDRC_DRAMTMG11_T_CKMPE_SHIFT (0U)
/*! t_ckmpe - tCKMPE: Minimum valid clock requirement after MPSM entry. Present only in designs
 *    configured to support DDR4. Unit: Clocks. When the controller is operating in 1:2 frequency ratio
 *    mode, divide the value calculated using the above equation by 2, and round it up to next
 *    integer.
 */
#define DDRC_DRAMTMG11_T_CKMPE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG11_T_CKMPE_SHIFT)) & DDRC_DRAMTMG11_T_CKMPE_MASK)
#define DDRC_DRAMTMG11_T_MPX_S_MASK  (0x300U)
#define DDRC_DRAMTMG11_T_MPX_S_SHIFT (8U)
/*! t_mpx_s - tMPX_S: Minimum time CS setup time to CKE. When the controller is operating in 1:2
 *    frequency ratio mode, program this to (tMPX_S/2) and round it up to the next integer value.
 *    Present only in designs configured to support DDR4. Unit: Clocks.
 */
#define DDRC_DRAMTMG11_T_MPX_S(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG11_T_MPX_S_SHIFT)) & DDRC_DRAMTMG11_T_MPX_S_MASK)
#define DDRC_DRAMTMG11_T_MPX_LH_MASK  (0x1F0000U)
#define DDRC_DRAMTMG11_T_MPX_LH_SHIFT (16U)
/*! t_mpx_lh - tMPX_LH: This is the minimum CS_n Low hold time to CKE rising edge. When the
 *    controller is operating in 1:2 frequency ratio mode, program this to RoundUp(tMPX_LH/2)+1. Present
 *    only in designs configured to support DDR4. Unit: clocks.
 */
#define DDRC_DRAMTMG11_T_MPX_LH(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG11_T_MPX_LH_SHIFT)) & DDRC_DRAMTMG11_T_MPX_LH_MASK)
#define DDRC_DRAMTMG11_POST_MPSM_GAP_X32_MASK  (0x7F000000U)
#define DDRC_DRAMTMG11_POST_MPSM_GAP_X32_SHIFT (24U)
/*! post_mpsm_gap_x32 - tXMPDLL: This is the minimum Exit MPSM to commands requiring a locked DLL.
 *    When the controller is operating in 1:2 frequency ratio mode, program this to (tXMPDLL/2) and
 *    round it up to the next integer value. Present only in designs configured to support DDR4.
 *    Unit: Multiples of 32 clocks.
 */
#define DDRC_DRAMTMG11_POST_MPSM_GAP_X32(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG11_POST_MPSM_GAP_X32_SHIFT)) & DDRC_DRAMTMG11_POST_MPSM_GAP_X32_MASK)
/*! @} */

/*! @name DRAMTMG12 - SDRAM Timing Register 12 */
/*! @{ */
#define DDRC_DRAMTMG12_T_MRD_PDA_MASK  (0x1FU)
#define DDRC_DRAMTMG12_T_MRD_PDA_SHIFT (0U)
/*! t_mrd_pda - tMRD_PDA: This is the Mode Register Set command cycle time in PDA mode. When the
 *    controller is operating in 1:2 frequency ratio mode, program this to (tMRD_PDA/2) and round it up
 *    to the next integer value.
 */
#define DDRC_DRAMTMG12_T_MRD_PDA(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG12_T_MRD_PDA_SHIFT)) & DDRC_DRAMTMG12_T_MRD_PDA_MASK)
#define DDRC_DRAMTMG12_T_CKEHCMD_MASK  (0xF00U)
#define DDRC_DRAMTMG12_T_CKEHCMD_SHIFT (8U)
/*! t_ckehcmd - tCKEHCMD: Valid command requirement after CKE input HIGH. When the controller is
 *    operating in 1:2 frequency ratio mode, program this to (tCKEHCMD/2) and round it up to the next
 *    integer value.
 */
#define DDRC_DRAMTMG12_T_CKEHCMD(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG12_T_CKEHCMD_SHIFT)) & DDRC_DRAMTMG12_T_CKEHCMD_MASK)
#define DDRC_DRAMTMG12_T_CMDCKE_MASK  (0x30000U)
#define DDRC_DRAMTMG12_T_CMDCKE_SHIFT (16U)
/*! t_cmdcke - tCMDCKE: Delay from valid command to CKE input LOW. Set this to the larger of tESCKE
 *    or tCMDCKE When the controller is operating in 1:2 frequency ratio mode, program this to
 *    (max(tESCKE, tCMDCKE)/2) and round it up to the next integer value.
 */
#define DDRC_DRAMTMG12_T_CMDCKE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG12_T_CMDCKE_SHIFT)) & DDRC_DRAMTMG12_T_CMDCKE_MASK)
/*! @} */

/*! @name DRAMTMG13 - SDRAM Timing Register 13 */
/*! @{ */
#define DDRC_DRAMTMG13_T_PPD_MASK  (0x7U)
#define DDRC_DRAMTMG13_T_PPD_SHIFT (0U)
/*! t_ppd - LPDDR4: tPPD: This is the minimum time from precharge to precharge command. When the
 *    controller is operating in 1:2 frequency ratio mode, program this to (tPPD/2) and round it up to
 *    the next integer value. Unit: Clocks.
 */
#define DDRC_DRAMTMG13_T_PPD(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG13_T_PPD_SHIFT)) & DDRC_DRAMTMG13_T_PPD_MASK)
#define DDRC_DRAMTMG13_T_CCD_MW_MASK  (0x3F0000U)
#define DDRC_DRAMTMG13_T_CCD_MW_SHIFT (16U)
/*! t_ccd_mw - LPDDR4: tCCDMW: This is the minimum time from write or masked write to masked write
 *    command for same bank. When the controller is operating in 1:2 frequency ratio mode, program
 *    this to (tCCDMW/2) and round it up to the next integer value. Unit: Clocks.
 */
#define DDRC_DRAMTMG13_T_CCD_MW(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG13_T_CCD_MW_SHIFT)) & DDRC_DRAMTMG13_T_CCD_MW_MASK)
#define DDRC_DRAMTMG13_ODTLOFF_MASK  (0x7F000000U)
#define DDRC_DRAMTMG13_ODTLOFF_SHIFT (24U)
/*! odtloff - LPDDR4: tODTLoff: This is the latency from CAS-2 command to tODToff reference. When
 *    the controller is operating in 1:2 frequency ratio mode, program this to (tODTLoff/2) and round
 *    it up to the next integer value. Unit: Clocks.
 */
#define DDRC_DRAMTMG13_ODTLOFF(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG13_ODTLOFF_SHIFT)) & DDRC_DRAMTMG13_ODTLOFF_MASK)
/*! @} */

/*! @name DRAMTMG14 - SDRAM Timing Register 14 */
/*! @{ */
#define DDRC_DRAMTMG14_T_XSR_MASK  (0xFFFU)
#define DDRC_DRAMTMG14_T_XSR_SHIFT (0U)
/*! t_xsr - tXSR: Exit Self Refresh to any command. When the controller is operating in 1:2
 *    frequency ratio mode, program this to the above value divided by 2 and round up to next integer value.
 *    Note: Used only for mDDR/LPDDR2/LPDDR3/LPDDR4 mode.
 */
#define DDRC_DRAMTMG14_T_XSR(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG14_T_XSR_SHIFT)) & DDRC_DRAMTMG14_T_XSR_MASK)
/*! @} */

/*! @name DRAMTMG15 - SDRAM Timing Register 15 */
/*! @{ */
#define DDRC_DRAMTMG15_T_STAB_X32_MASK  (0xFFU)
#define DDRC_DRAMTMG15_T_STAB_X32_SHIFT (0U)
/*! t_stab_x32 - tSTAB: Stabilization time. It is required in the following two cases for DDR3/DDR4
 *    RDIMM : - when exiting power saving mode, if the clock was stopped, after re-enabling it the
 *    clock must be stable for a time specified by tSTAB - in the case of input clock frequency
 *    change (DDR4) - after issuing control words that refers to clock timing (Specification: 6us for
 *    DDR3, 5us for DDR4) When the controller is operating in 1:2 frequency ratio mode, program this to
 *    recommended value divided by two and round it up to next integer. Unit: Multiples of 32 clock
 *    cycles.
 */
#define DDRC_DRAMTMG15_T_STAB_X32(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG15_T_STAB_X32_SHIFT)) & DDRC_DRAMTMG15_T_STAB_X32_MASK)
#define DDRC_DRAMTMG15_EN_DFI_LP_T_STAB_MASK  (0x80000000U)
#define DDRC_DRAMTMG15_EN_DFI_LP_T_STAB_SHIFT (31U)
/*! en_dfi_lp_t_stab - Enable DFI tSTAB
 *  0b0..Disable using tSTAB when exiting DFI LP
 *  0b1..Enable using tSTAB when exiting DFI LP. Needs to be set when the PHY is stopping the clock during DFI LP to
 * save maximum power.
 */
#define DDRC_DRAMTMG15_EN_DFI_LP_T_STAB(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG15_EN_DFI_LP_T_STAB_SHIFT)) & DDRC_DRAMTMG15_EN_DFI_LP_T_STAB_MASK)
/*! @} */

/*! @name ZQCTL0 - ZQ Control Register 0 */
/*! @{ */
#define DDRC_ZQCTL0_T_ZQ_SHORT_NOP_MASK  (0x3FFU)
#define DDRC_ZQCTL0_T_ZQ_SHORT_NOP_SHIFT (0U)
/*! t_zq_short_nop - tZQCS for DDR3/DD4/LPDDR2/LPDDR3, tZQLAT for LPDDR4: Number of DFI clock cycles
 *    of NOP required after a ZQCS (ZQ calibration short)/MPC(ZQ Latch) command is issued to SDRAM.
 *    When the controller is operating in 1:2 frequency ratio mode, program this to tZQCS/2 and
 *    round it up to the next integer value. This is only present for designs supporting DDR3/DDR4 or
 *    LPDDR2/LPDDR3/LPDDR4 devices.
 */
#define DDRC_ZQCTL0_T_ZQ_SHORT_NOP(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ZQCTL0_T_ZQ_SHORT_NOP_SHIFT)) & DDRC_ZQCTL0_T_ZQ_SHORT_NOP_MASK)
#define DDRC_ZQCTL0_T_ZQ_LONG_NOP_MASK  (0x7FF0000U)
#define DDRC_ZQCTL0_T_ZQ_LONG_NOP_SHIFT (16U)
/*! t_zq_long_nop - tZQoper for DDR3/DDR4, tZQCL for LPDDR2/LPDDR3, tZQCAL for LPDDR4: Number of DFI
 *    clock cycles of NOP required after a ZQCL (ZQ calibration long)/MPC(ZQ Start) command is
 *    issued to SDRAM. When the controller is operating in 1:2 frequency ratio mode: DDR3/DDR4: program
 *    this to tZQoper/2 and round it up to the next integer value. LPDDR2/LPDDR3: program this to
 *    tZQCL/2 and round it up to the next integer value. LPDDR4: program this to tZQCAL/2 and round it
 *    up to the next integer value. This is only present for designs supporting DDR3/DDR4 or
 *    LPDDR2/LPDDR3/LPDDR4 devices.
 */
#define DDRC_ZQCTL0_T_ZQ_LONG_NOP(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ZQCTL0_T_ZQ_LONG_NOP_SHIFT)) & DDRC_ZQCTL0_T_ZQ_LONG_NOP_MASK)
#define DDRC_ZQCTL0_DIS_MPSMX_ZQCL_MASK  (0x10000000U)
#define DDRC_ZQCTL0_DIS_MPSMX_ZQCL_SHIFT (28U)
/*! dis_mpsmx_zqcl - Do not issue ZQCL command at Maximum Power Save Mode exit if the DDRC_SHARED_AC
 *    configuration parameter is set. Program it to 1'b1. The software can send ZQCS after exiting
 *    MPSM mode.
 *  0b0..Enable issuing of ZQCL command at Maximum Power Saving Mode exit. Only applicable when run in DDR4 mode.
 *       This is only present for designs supporting DDR4 devices.
 *  0b1..Disable issuing of ZQCL command at Maximum Power Saving Mode exit. Only applicable when run in DDR4 mode.
 */
#define DDRC_ZQCTL0_DIS_MPSMX_ZQCL(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ZQCTL0_DIS_MPSMX_ZQCL_SHIFT)) & DDRC_ZQCTL0_DIS_MPSMX_ZQCL_MASK)
#define DDRC_ZQCTL0_ZQ_RESISTOR_SHARED_MASK  (0x20000000U)
#define DDRC_ZQCTL0_ZQ_RESISTOR_SHARED_SHIFT (29U)
/*! zq_resistor_shared - ZQ resistor sharing
 *  0b0..ZQ resistor is not shared. This is only present for designs supporting DDR3/DDR4 or LPDDR2/LPDDR3/LPDDR4
 * devices. 0b1..Denotes that ZQ resistor is shared between ranks. Means ZQinit/ZQCL/ZQCS/MPC(ZQ calibration) commands
 * are sent to one rank at a time with tZQinit/tZQCL/tZQCS/tZQCAL/tZQLAT timing met between commands so that commands to
 * different ranks do not overlap.
 */
#define DDRC_ZQCTL0_ZQ_RESISTOR_SHARED(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ZQCTL0_ZQ_RESISTOR_SHARED_SHIFT)) & DDRC_ZQCTL0_ZQ_RESISTOR_SHARED_MASK)
#define DDRC_ZQCTL0_DIS_SRX_ZQCL_MASK  (0x40000000U)
#define DDRC_ZQCTL0_DIS_SRX_ZQCL_SHIFT (30U)
/*! dis_srx_zqcl - Disable ZQCL/MPC
 *  0b0..Enable issuing of ZQCL/MPC(ZQ calibration) command at Self-Refresh/SR-Powerdown exit. Only applicable
 *       when run in DDR3 or DDR4 or LPDDR2 or LPDDR3 or LPDDR4 mode. This is only present for designs supporting
 *       DDR3/DDR4 or LPDDR2/LPDDR3/LPDDR4 devices.
 *  0b1..Disable issuing of ZQCL/MPC(ZQ calibration) command at Self-Refresh/SR-Powerdown exit. Only applicable
 *       when run in DDR3 or DDR4 or LPDDR2 or LPDDR3 or LPDDR4 mode.
 */
#define DDRC_ZQCTL0_DIS_SRX_ZQCL(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ZQCTL0_DIS_SRX_ZQCL_SHIFT)) & DDRC_ZQCTL0_DIS_SRX_ZQCL_MASK)
#define DDRC_ZQCTL0_DIS_AUTO_ZQ_MASK  (0x80000000U)
#define DDRC_ZQCTL0_DIS_AUTO_ZQ_SHIFT (31U)
/*! dis_auto_zq - Disable Auto ZQCS/MPC
 *  0b0..Internally generate ZQCS/MPC(ZQ calibration) commands based on ZQCTL1.t_zq_short_interval_x1024.
 *  0b1..Disable DDRC generation of ZQCS/MPC(ZQ calibration) command. Register DBGCMD.zq_calib_short can be used
 *       instead to issue ZQ calibration request from APB module.
 */
#define DDRC_ZQCTL0_DIS_AUTO_ZQ(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ZQCTL0_DIS_AUTO_ZQ_SHIFT)) & DDRC_ZQCTL0_DIS_AUTO_ZQ_MASK)
/*! @} */

/*! @name ZQCTL1 - ZQ Control Register 1 */
/*! @{ */
#define DDRC_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_MASK  (0xFFFFFU)
#define DDRC_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_SHIFT (0U)
/*! t_zq_short_interval_x1024 - Average interval to wait between automatically issuing ZQCS (ZQ
 *    calibration short)/MPC(ZQ calibration) commands to DDR3/DDR4/LPDDR2/LPDDR3/LPDDR4 devices.
 *    Meaningless, if ZQCTL0.dis_auto_zq=1. Unit: 1024 DFI clock cycles. This is only present for designs
 *    supporting DDR3/DDR4 or LPDDR2/LPDDR3/LPDDR4 devices.
 */
#define DDRC_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_SHIFT)) & \
     DDRC_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_MASK)
#define DDRC_ZQCTL1_T_ZQ_RESET_NOP_MASK  (0x3FF00000U)
#define DDRC_ZQCTL1_T_ZQ_RESET_NOP_SHIFT (20U)
/*! t_zq_reset_nop - tZQReset: Number of DFI clock cycles of NOP required after a ZQReset (ZQ
 *    calibration Reset) command is issued to SDRAM. When the controller is operating in 1:2 frequency
 *    ratio mode, program this to tZQReset/2 and round it up to the next integer value. This is only
 *    present for designs supporting LPDDR2/LPDDR3/LPDDR4 devices.
 */
#define DDRC_ZQCTL1_T_ZQ_RESET_NOP(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ZQCTL1_T_ZQ_RESET_NOP_SHIFT)) & DDRC_ZQCTL1_T_ZQ_RESET_NOP_MASK)
/*! @} */

/*! @name ZQCTL2 - ZQ Control Register 2 */
/*! @{ */
#define DDRC_ZQCTL2_ZQ_RESET_MASK  (0x1U)
#define DDRC_ZQCTL2_ZQ_RESET_SHIFT (0U)
/*! zq_reset - Setting this register bit to 1 triggers a ZQ Reset operation. When the ZQ Reset
 *    operation is complete, the DDRC automatically clears this bit. It is recommended NOT to set this
 *    signal if in Init, Self-Refresh(except LPDDR4) or SR-Powerdown(LPDDR4) or Deep power-down
 *    operating modes. This is only present for designs supporting LPDDR2/LPDDR3/LPDDR4 devices.
 */
#define DDRC_ZQCTL2_ZQ_RESET(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ZQCTL2_ZQ_RESET_SHIFT)) & DDRC_ZQCTL2_ZQ_RESET_MASK)
/*! @} */

/*! @name ZQSTAT - ZQ Status Register */
/*! @{ */
#define DDRC_ZQSTAT_ZQ_RESET_BUSY_MASK  (0x1U)
#define DDRC_ZQSTAT_ZQ_RESET_BUSY_SHIFT (0U)
/*! zq_reset_busy - SoC core may initiate a ZQ Reset operation only if this signal is low. This
 *    signal goes high in the clock after the DDRC accepts the ZQ Reset request. It goes low when the ZQ
 *    Reset command is issued to the SDRAM and the associated NOP period is over. It is recommended
 *    not to perform ZQ Reset commands when this signal is high.
 *  0b0..Indicates that the SoC core can initiate a ZQ Reset operation
 *  0b1..Indicates that ZQ Reset operation is in progress
 */
#define DDRC_ZQSTAT_ZQ_RESET_BUSY(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ZQSTAT_ZQ_RESET_BUSY_SHIFT)) & DDRC_ZQSTAT_ZQ_RESET_BUSY_MASK)
/*! @} */

/*! @name DFITMG0 - DFI Timing Register 0 */
/*! @{ */
#define DDRC_DFITMG0_DFI_TPHY_WRLAT_MASK  (0x3FU)
#define DDRC_DFITMG0_DFI_TPHY_WRLAT_SHIFT (0U)
/*! dfi_tphy_wrlat - Write latency Number of clocks from the write command to write data enable
 *    (dfi_wrdata_en). This corresponds to the DFI timing parameter tphy_wrlat. Refer to PHY
 *    specification for correct value.Note that, depending on the PHY, if using RDIMM/LRDIMM, it may be
 *    necessary to use the adjusted value of CL in the calculation of tphy_wrlat. This is to compensate for
 *    the extra cycle(s) of latency through the RDIMM/LRDIMM. Unit: DFI clock cycles or DFI PHY
 *    clock cycles, depending on DFITMG0.dfi_wrdata_use_sdr.
 */
#define DDRC_DFITMG0_DFI_TPHY_WRLAT(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFITMG0_DFI_TPHY_WRLAT_SHIFT)) & DDRC_DFITMG0_DFI_TPHY_WRLAT_MASK)
#define DDRC_DFITMG0_DFI_TPHY_WRDATA_MASK  (0x3F00U)
#define DDRC_DFITMG0_DFI_TPHY_WRDATA_SHIFT (8U)
/*! dfi_tphy_wrdata - Specifies the number of clock cycles between when dfi_wrdata_en is asserted to
 *    when the associated write data is driven on the dfi_wrdata signal. This corresponds to the
 *    DFI timing parameter tphy_wrdata. Refer to PHY specification for correct value. Note, max
 *    supported value is 8. Unit: DFI clock cycles or DFI PHY clock cycles, depending on
 *    DFITMG0.dfi_wrdata_use_sdr.
 */
#define DDRC_DFITMG0_DFI_TPHY_WRDATA(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFITMG0_DFI_TPHY_WRDATA_SHIFT)) & DDRC_DFITMG0_DFI_TPHY_WRDATA_MASK)
#define DDRC_DFITMG0_DFI_WRDATA_USE_SDR_MASK  (0x8000U)
#define DDRC_DFITMG0_DFI_WRDATA_USE_SDR_SHIFT (15U)
/*! dfi_wrdata_use_sdr - Defines whether dfi_wrdata_en/dfi_wrdata/dfi_wrdata_mask is generated using
 *    HDR (DFI clock) or SDR (DFI PHY clock) values Selects whether value in DFITMG0.dfi_tphy_wrlat
 *    is in terms of HDR (DFI clock) or SDR (DFI PHY clock) cycles Selects whether value in
 *    DFITMG0.dfi_tphy_wrdata is in terms of HDR (DFI clock) or SDR (DFI PHY clock) cycles - 0 in terms of
 *    HDR (DFI clock) cycles - 1 in terms of SDR (DFI PHY clock) cycles Refer to PHY specification
 *    for correct value.
 */
#define DDRC_DFITMG0_DFI_WRDATA_USE_SDR(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFITMG0_DFI_WRDATA_USE_SDR_SHIFT)) & DDRC_DFITMG0_DFI_WRDATA_USE_SDR_MASK)
#define DDRC_DFITMG0_DFI_T_RDDATA_EN_MASK  (0x7F0000U)
#define DDRC_DFITMG0_DFI_T_RDDATA_EN_SHIFT (16U)
/*! dfi_t_rddata_en - Time from the assertion of a read command on the DFI interface to the
 *    assertion of the dfi_rddata_en signal. Refer to PHY specification for correct value. This corresponds
 *    to the DFI parameter trddata_en. Note that, depending on the PHY, if using RDIMM/LRDIMM, it
 *    may be necessary to use the adjusted value of CL in the calculation of trddata_en. This is to
 *    compensate for the extra cycle(s) of latency through the RDIMM/LRDIMM. Unit: DFI clock cycles or
 *    DFI PHY clock cycles, depending on DFITMG0.dfi_rddata_use_sdr.
 */
#define DDRC_DFITMG0_DFI_T_RDDATA_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFITMG0_DFI_T_RDDATA_EN_SHIFT)) & DDRC_DFITMG0_DFI_T_RDDATA_EN_MASK)
#define DDRC_DFITMG0_DFI_RDDATA_USE_SDR_MASK  (0x800000U)
#define DDRC_DFITMG0_DFI_RDDATA_USE_SDR_SHIFT (23U)
/*! dfi_rddata_use_sdr - Defines whether dfi_rddata_en/dfi_rddata/dfi_rddata_valid is generated
 *    using HDR (DFI clock) or SDR (DFI PHY clock) values. Selects whether value in
 *    DFITMG0.dfi_t_rddata_en is in terms of HDR (DFI clock) or SDR (DFI PHY clock) cycles: - 0 in terms of HDR (DFI
 *    clock) cycles - 1 in terms of SDR (DFI PHY clock) cycles Refer to PHY specification for correct
 *    value.
 */
#define DDRC_DFITMG0_DFI_RDDATA_USE_SDR(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFITMG0_DFI_RDDATA_USE_SDR_SHIFT)) & DDRC_DFITMG0_DFI_RDDATA_USE_SDR_MASK)
#define DDRC_DFITMG0_DFI_T_CTRL_DELAY_MASK  (0x1F000000U)
#define DDRC_DFITMG0_DFI_T_CTRL_DELAY_SHIFT (24U)
/*! dfi_t_ctrl_delay - Specifies the number of DFI clock cycles after an assertion or de-assertion
 *    of the DFI control signals that the control signals at the PHY-DRAM interface reflect the
 *    assertion or de-assertion. If the DFI clock and the memory clock are not phase-aligned, this timing
 *    parameter should be rounded up to the next integer value. Note that if using RDIMM/LRDIMM, it
 *    is necessary to increment this parameter by RDIMM's/LRDIMM's extra cycle of latency in terms
 *    of DFI clock.
 */
#define DDRC_DFITMG0_DFI_T_CTRL_DELAY(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFITMG0_DFI_T_CTRL_DELAY_SHIFT)) & DDRC_DFITMG0_DFI_T_CTRL_DELAY_MASK)
/*! @} */

/*! @name DFITMG1 - DFI Timing Register 1 */
/*! @{ */
#define DDRC_DFITMG1_DFI_T_DRAM_CLK_ENABLE_MASK  (0x1FU)
#define DDRC_DFITMG1_DFI_T_DRAM_CLK_ENABLE_SHIFT (0U)
/*! dfi_t_dram_clk_enable - Specifies the number of DFI clock cycles from the de-assertion of the
 *    dfi_dram_clk_disable signal on the DFI until the first valid rising edge of the clock to the
 *    DRAM memory devices, at the PHY-DRAM boundary. If the DFI clock and the memory clock are not
 *    phase aligned, this timing parameter should be rounded up to the next integer value.
 */
#define DDRC_DFITMG1_DFI_T_DRAM_CLK_ENABLE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFITMG1_DFI_T_DRAM_CLK_ENABLE_SHIFT)) & \
     DDRC_DFITMG1_DFI_T_DRAM_CLK_ENABLE_MASK)
#define DDRC_DFITMG1_DFI_T_DRAM_CLK_DISABLE_MASK  (0x1F00U)
#define DDRC_DFITMG1_DFI_T_DRAM_CLK_DISABLE_SHIFT (8U)
/*! dfi_t_dram_clk_disable - Specifies the number of DFI clock cycles from the assertion of the
 *    dfi_dram_clk_disable signal on the DFI until the clock to the DRAM memory devices, at the PHY-DRAM
 *    boundary, maintains a low value. If the DFI clock and the memory clock are not phase aligned,
 *    this timing parameter should be rounded up to the next integer value.
 */
#define DDRC_DFITMG1_DFI_T_DRAM_CLK_DISABLE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFITMG1_DFI_T_DRAM_CLK_DISABLE_SHIFT)) & \
     DDRC_DFITMG1_DFI_T_DRAM_CLK_DISABLE_MASK)
#define DDRC_DFITMG1_DFI_T_WRDATA_DELAY_MASK  (0x1F0000U)
#define DDRC_DFITMG1_DFI_T_WRDATA_DELAY_SHIFT (16U)
/*! dfi_t_wrdata_delay - Specifies the number of DFI clock cycles between when the dfi_wrdata_en
 *    signal is asserted and when the corresponding write data transfer is completed on the DRAM bus.
 *    This corresponds to the DFI timing parameter twrdata_delay. Refer to PHY specification for
 *    correct value. For DFI 3.0 PHY, set to twrdata_delay, a new timing parameter introduced in DFI
 *    3.0. For DFI 2.1 PHY, set to tphy_wrdata + (delay of DFI write data to the DRAM). Value to be
 *    programmed is in terms of DFI clocks, not PHY clocks. In FREQ_RATIO=2, divide PHY's value by 2
 *    and round up to next integer. If using DFITMG0.dfi_wrdata_use_sdr=1, add 1 to the value. Unit:
 *    Clocks
 */
#define DDRC_DFITMG1_DFI_T_WRDATA_DELAY(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFITMG1_DFI_T_WRDATA_DELAY_SHIFT)) & DDRC_DFITMG1_DFI_T_WRDATA_DELAY_MASK)
#define DDRC_DFITMG1_DFI_T_PARIN_LAT_MASK  (0x3000000U)
#define DDRC_DFITMG1_DFI_T_PARIN_LAT_SHIFT (24U)
/*! dfi_t_parin_lat - Specifies the number of DFI PHY clock cycles between when the dfi_cs signal is
 *    asserted and when the associated dfi_parity_in signal is driven.
 */
#define DDRC_DFITMG1_DFI_T_PARIN_LAT(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFITMG1_DFI_T_PARIN_LAT_SHIFT)) & DDRC_DFITMG1_DFI_T_PARIN_LAT_MASK)
#define DDRC_DFITMG1_DFI_T_CMD_LAT_MASK  (0xF0000000U)
#define DDRC_DFITMG1_DFI_T_CMD_LAT_SHIFT (28U)
/*! dfi_t_cmd_lat - Specifies the number of DFI PHY clock cycles between when the dfi_cs signal is
 *    asserted and when the associated command is driven. This field is used for CAL mode, should be
 *    set to '0' or the value which matches the CAL mode register setting in the DRAM. If the PHY
 *    can add the latency for CAL mode, this should be set to '0'. Valid Range: 0, 3, 4, 5, 6, and 8
 */
#define DDRC_DFITMG1_DFI_T_CMD_LAT(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFITMG1_DFI_T_CMD_LAT_SHIFT)) & DDRC_DFITMG1_DFI_T_CMD_LAT_MASK)
/*! @} */

/*! @name DFILPCFG0 - DFI Low Power Configuration Register 0 */
/*! @{ */
#define DDRC_DFILPCFG0_DFI_LP_EN_PD_MASK  (0x1U)
#define DDRC_DFILPCFG0_DFI_LP_EN_PD_SHIFT (0U)
/*! dfi_lp_en_pd - Enables DFI Low Power interface handshaking during Power Down Entry/Exit. - 0 - Disabled - 1 -
 * Enabled
 */
#define DDRC_DFILPCFG0_DFI_LP_EN_PD(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFILPCFG0_DFI_LP_EN_PD_SHIFT)) & DDRC_DFILPCFG0_DFI_LP_EN_PD_MASK)
#define DDRC_DFILPCFG0_DFI_LP_WAKEUP_PD_MASK  (0xF0U)
#define DDRC_DFILPCFG0_DFI_LP_WAKEUP_PD_SHIFT (4U)
/*! dfi_lp_wakeup_pd - Value in DFI clock cycles to drive on dfi_lp_wakeup signal when Power Down
 *    mode is entered. Determines the DFI's tlp_wakeup time:
 *  0b0000..16 cycles
 *  0b0001..32 cycles
 *  0b0010..64 cycles
 *  0b0011..128 cycles
 *  0b0100..256 cycles
 *  0b0101..512 cycles
 *  0b0110..1024 cycles
 *  0b0111..2048 cycles
 *  0b1000..4096 cycles
 *  0b1001..8192 cycles
 *  0b1010..16384 cycles
 *  0b1011..32768 cycles
 *  0b1100..65536 cycles
 *  0b1101..131072 cycles
 *  0b1110..262144 cycles
 *  0b1111..Unlimited cycles
 */
#define DDRC_DFILPCFG0_DFI_LP_WAKEUP_PD(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFILPCFG0_DFI_LP_WAKEUP_PD_SHIFT)) & DDRC_DFILPCFG0_DFI_LP_WAKEUP_PD_MASK)
#define DDRC_DFILPCFG0_DFI_LP_EN_SR_MASK  (0x100U)
#define DDRC_DFILPCFG0_DFI_LP_EN_SR_SHIFT (8U)
/*! dfi_lp_en_sr - Enables DFI Low Power interface handshaking during Self Refresh Entry/Exit. - 0 - Disabled - 1 -
 * Enabled 0b0..Disabled 0b1..Enabled
 */
#define DDRC_DFILPCFG0_DFI_LP_EN_SR(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFILPCFG0_DFI_LP_EN_SR_SHIFT)) & DDRC_DFILPCFG0_DFI_LP_EN_SR_MASK)
#define DDRC_DFILPCFG0_DFI_LP_WAKEUP_SR_MASK  (0xF000U)
#define DDRC_DFILPCFG0_DFI_LP_WAKEUP_SR_SHIFT (12U)
/*! dfi_lp_wakeup_sr - Value in DFI clpck cycles to drive on dfi_lp_wakeup signal when Self Refresh
 *    mode is entered. Determines the DFI's tlp_wakeup time:
 *  0b0000..16 cycles
 *  0b0001..32 cycles
 *  0b0010..64 cycles
 *  0b0011..128 cycles
 *  0b0100..256 cycles
 *  0b0101..512 cycles
 *  0b0110..1024 cycles
 *  0b0111..2048 cycles
 *  0b1000..4096 cycles
 *  0b1001..8192 cycles
 *  0b1010..16384 cycles
 *  0b1011..32768 cycles
 *  0b1100..65536 cycles
 *  0b1101..131072 cycles
 *  0b1110..262144 cycles
 *  0b1111..Unlimited cycles
 */
#define DDRC_DFILPCFG0_DFI_LP_WAKEUP_SR(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFILPCFG0_DFI_LP_WAKEUP_SR_SHIFT)) & DDRC_DFILPCFG0_DFI_LP_WAKEUP_SR_MASK)
#define DDRC_DFILPCFG0_DFI_LP_EN_DPD_MASK  (0x10000U)
#define DDRC_DFILPCFG0_DFI_LP_EN_DPD_SHIFT (16U)
/*! dfi_lp_en_dpd - Enables DFI Low Power interface handshaking during Deep Power Down Entry/Exit. -
 *    0 - Disabled - 1 - Enabled This is only present for designs supporting mDDR or LPDDR2/LPDDR3
 *    devices.
 */
#define DDRC_DFILPCFG0_DFI_LP_EN_DPD(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFILPCFG0_DFI_LP_EN_DPD_SHIFT)) & DDRC_DFILPCFG0_DFI_LP_EN_DPD_MASK)
#define DDRC_DFILPCFG0_DFI_LP_WAKEUP_DPD_MASK  (0xF00000U)
#define DDRC_DFILPCFG0_DFI_LP_WAKEUP_DPD_SHIFT (20U)
/*! dfi_lp_wakeup_dpd - Value in DFI clock cycles to drive on dfi_lp_wakeup signal when Deep Power
 *    Down mode is entered. Determines the DFI's tlp_wakeup time: This is only present for designs
 *    supporting mDDR or LPDDR2/LPDDR3 devices.
 *  0b0000..16 cycles
 *  0b0001..32 cycles
 *  0b0010..64 cycles
 *  0b0011..128 cycles
 *  0b0100..256 cycles
 *  0b0101..512 cycles
 *  0b0110..1024 cycles
 *  0b0111..2048 cycles
 *  0b1000..4096 cycles
 *  0b1001..8192 cycles
 *  0b1010..16384 cycles
 *  0b1011..32768 cycles
 *  0b1100..65536 cycles
 *  0b1101..131072 cycles
 *  0b1110..262144 cycles
 *  0b1111..Unlimited cycles
 */
#define DDRC_DFILPCFG0_DFI_LP_WAKEUP_DPD(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFILPCFG0_DFI_LP_WAKEUP_DPD_SHIFT)) & DDRC_DFILPCFG0_DFI_LP_WAKEUP_DPD_MASK)
#define DDRC_DFILPCFG0_DFI_TLP_RESP_MASK  (0x1F000000U)
#define DDRC_DFILPCFG0_DFI_TLP_RESP_SHIFT (24U)
/*! dfi_tlp_resp - Setting in DFI clock cycles for DFI's tlp_resp time. Same value is used for both
 *    Power Down, Self Refresh, Deep Power Down and Maximum Power Saving modes. DFI 2.1
 *    specification onwards, recommends using a fixed value of 7 always.
 */
#define DDRC_DFILPCFG0_DFI_TLP_RESP(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFILPCFG0_DFI_TLP_RESP_SHIFT)) & DDRC_DFILPCFG0_DFI_TLP_RESP_MASK)
/*! @} */

/*! @name DFILPCFG1 - DFI Low Power Configuration Register 1 */
/*! @{ */
#define DDRC_DFILPCFG1_DFI_LP_EN_MPSM_MASK  (0x1U)
#define DDRC_DFILPCFG1_DFI_LP_EN_MPSM_SHIFT (0U)
/*! dfi_lp_en_mpsm - Enables DFI Low Power interface handshaking during Maximum Power Saving Mode
 *    Entry/Exit. - 0 - Disabled - 1 - Enabled This is only present for designs supporting DDR4
 *    devices.
 */
#define DDRC_DFILPCFG1_DFI_LP_EN_MPSM(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFILPCFG1_DFI_LP_EN_MPSM_SHIFT)) & DDRC_DFILPCFG1_DFI_LP_EN_MPSM_MASK)
#define DDRC_DFILPCFG1_DFI_LP_WAKEUP_MPSM_MASK  (0xF0U)
#define DDRC_DFILPCFG1_DFI_LP_WAKEUP_MPSM_SHIFT (4U)
/*! dfi_lp_wakeup_mpsm - Value in DFI clock cycles to drive on dfi_lp_wakeup signal when Maximum
 *    Power Saving Mode is entered. Determines the DFI's tlp_wakeup time:
 *  0b0000..16 cycles
 *  0b0001..32 cycles
 *  0b0010..64 cycles
 *  0b0011..128 cycles
 *  0b0100..256 cycles
 *  0b0101..512 cycles
 *  0b0110..1024 cycles
 *  0b0111..2048 cycles
 *  0b1000..4096 cycles
 *  0b1001..8192 cycles
 *  0b1010..16384 cycles
 *  0b1011..32768 cycles
 *  0b1100..65536 cycles
 *  0b1101..131072 cycles
 *  0b1110..262144 cycles
 *  0b1111..Unlimited cycles
 */
#define DDRC_DFILPCFG1_DFI_LP_WAKEUP_MPSM(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFILPCFG1_DFI_LP_WAKEUP_MPSM_SHIFT)) & DDRC_DFILPCFG1_DFI_LP_WAKEUP_MPSM_MASK)
/*! @} */

/*! @name DFIUPD0 - DFI Update Register 0 */
/*! @{ */
#define DDRC_DFIUPD0_DFI_T_CTRLUP_MIN_MASK  (0x3FFU)
#define DDRC_DFIUPD0_DFI_T_CTRLUP_MIN_SHIFT (0U)
/*! dfi_t_ctrlup_min - Specifies the minimum number of DFI clock cycles that the dfi_ctrlupd_req
 *    signal must be asserted. The DDRC expects the PHY to respond within this time. If the PHY does
 *    not respond, the DDRC will de-assert dfi_ctrlupd_req after dfi_t_ctrlup_min + 2 cycles. Lowest
 *    value to assign to this variable is 0x3.
 */
#define DDRC_DFIUPD0_DFI_T_CTRLUP_MIN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFIUPD0_DFI_T_CTRLUP_MIN_SHIFT)) & DDRC_DFIUPD0_DFI_T_CTRLUP_MIN_MASK)
#define DDRC_DFIUPD0_DFI_T_CTRLUP_MAX_MASK  (0x3FF0000U)
#define DDRC_DFIUPD0_DFI_T_CTRLUP_MAX_SHIFT (16U)
/*! dfi_t_ctrlup_max - Specifies the maximum number of DFI clock cycles that the dfi_ctrlupd_req
 *    signal can assert. Lowest value to assign to this variable is 0x40.
 */
#define DDRC_DFIUPD0_DFI_T_CTRLUP_MAX(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFIUPD0_DFI_T_CTRLUP_MAX_SHIFT)) & DDRC_DFIUPD0_DFI_T_CTRLUP_MAX_MASK)
#define DDRC_DFIUPD0_CTRLUPD_PRE_SRX_MASK  (0x20000000U)
#define DDRC_DFIUPD0_CTRLUPD_PRE_SRX_SHIFT (29U)
/*! ctrlupd_pre_srx - Selects dfi_ctrlupd_req requirements at SRX: - 0 : send ctrlupd after SRX - 1
 *    : send ctrlupd before SRX If DFIUPD0.dis_auto_ctrlupd_srx=1, this register has no impact,
 *    because no dfi_ctrlupd_req will be issued when SRX.
 *  0b0..send ctrlupd after SRX
 *  0b1..send ctrlupd before SRX
 */
#define DDRC_DFIUPD0_CTRLUPD_PRE_SRX(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFIUPD0_CTRLUPD_PRE_SRX_SHIFT)) & DDRC_DFIUPD0_CTRLUPD_PRE_SRX_MASK)
#define DDRC_DFIUPD0_DIS_AUTO_CTRLUPD_SRX_MASK  (0x40000000U)
#define DDRC_DFIUPD0_DIS_AUTO_CTRLUPD_SRX_SHIFT (30U)
/*! dis_auto_ctrlupd_srx - Auto ctrlupd request generation
 *  0b1..disable the automatic dfi_ctrlupd_req generation by the DDRC at self-refresh exit.
 *  0b0..DDRC issues a dfi_ctrlupd_req before or after exiting self-refresh, depending on DFIUPD0.ctrlupd_pre_srx.
 */
#define DDRC_DFIUPD0_DIS_AUTO_CTRLUPD_SRX(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFIUPD0_DIS_AUTO_CTRLUPD_SRX_SHIFT)) & DDRC_DFIUPD0_DIS_AUTO_CTRLUPD_SRX_MASK)
#define DDRC_DFIUPD0_DIS_AUTO_CTRLUPD_MASK  (0x80000000U)
#define DDRC_DFIUPD0_DIS_AUTO_CTRLUPD_SHIFT (31U)
/*! dis_auto_ctrlupd - automatic dfi_ctrlupd_req generation by the DDRC
 *  0b0..DDRC issues dfi_ctrlupd_req periodically.
 *  0b1..disable the automatic dfi_ctrlupd_req generation by the DDRC. The core must issue the dfi_ctrlupd_req
 *       signal using register reg_ddrc_ctrlupd.
 */
#define DDRC_DFIUPD0_DIS_AUTO_CTRLUPD(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFIUPD0_DIS_AUTO_CTRLUPD_SHIFT)) & DDRC_DFIUPD0_DIS_AUTO_CTRLUPD_MASK)
/*! @} */

/*! @name DFIUPD1 - DFI Update Register 1 */
/*! @{ */
#define DDRC_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MAX_X1024_MASK  (0xFFU)
#define DDRC_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MAX_X1024_SHIFT (0U)
/*! dfi_t_ctrlupd_interval_max_x1024 - This is the maximum amount of time between DDRC initiated DFI
 *    update requests. This timer resets with each update request; when the timer expires
 *    dfi_ctrlupd_req is sent and traffic is blocked until the dfi_ctrlupd_ackx is received. PHY can use this
 *    idle time to recalibrate the delay lines to the DLLs. The DFI controller update is also used
 *    to reset PHY FIFO pointers in case of data capture errors. Updates are required to maintain
 *    calibration over PVT, but frequent updates may impact performance. Minimum allowed value for
 *    this field is 1. Note: Value programmed for DFIUPD1.dfi_t_ctrlupd_interval_max_x1024 must be
 *    greater than DFIUPD1.dfi_t_ctrlupd_interval_min_x1024. Unit: 1024 DFI clock cycles
 */
#define DDRC_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MAX_X1024(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MAX_X1024_SHIFT)) & \
     DDRC_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MAX_X1024_MASK)
#define DDRC_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MIN_X1024_MASK  (0xFF0000U)
#define DDRC_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MIN_X1024_SHIFT (16U)
/*! dfi_t_ctrlupd_interval_min_x1024 - This is the minimum amount of time between DDRC initiated DFI
 *    update requests (which is executed whenever the DDRC is idle). Set this number higher to
 *    reduce the frequency of update requests, which can have a small impact on the latency of the first
 *    read request when the DDRC is idle. Minimum allowed value for this field is 1. Unit: 1024 DFI
 *    clock cycles
 */
#define DDRC_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MIN_X1024(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MIN_X1024_SHIFT)) & \
     DDRC_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MIN_X1024_MASK)
/*! @} */

/*! @name DFIUPD2 - DFI Update Register 2 */
/*! @{ */
#define DDRC_DFIUPD2_DFI_PHYUPD_EN_MASK  (0x80000000U)
#define DDRC_DFIUPD2_DFI_PHYUPD_EN_SHIFT (31U)
/*! dfi_phyupd_en - Enables the support for acknowledging PHY-initiated updates:
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define DDRC_DFIUPD2_DFI_PHYUPD_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFIUPD2_DFI_PHYUPD_EN_SHIFT)) & DDRC_DFIUPD2_DFI_PHYUPD_EN_MASK)
/*! @} */

/*! @name DFIMISC - DFI Miscellaneous Control Register */
/*! @{ */
#define DDRC_DFIMISC_DFI_INIT_COMPLETE_EN_MASK  (0x1U)
#define DDRC_DFIMISC_DFI_INIT_COMPLETE_EN_SHIFT (0U)
/*! dfi_init_complete_en - PHY initialization complete enable signal. When asserted the
 *    dfi_init_complete signal can be used to trigger SDRAM initialisation
 */
#define DDRC_DFIMISC_DFI_INIT_COMPLETE_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFIMISC_DFI_INIT_COMPLETE_EN_SHIFT)) & DDRC_DFIMISC_DFI_INIT_COMPLETE_EN_MASK)
#define DDRC_DFIMISC_PHY_DBI_MODE_MASK  (0x2U)
#define DDRC_DFIMISC_PHY_DBI_MODE_SHIFT (1U)
/*! phy_dbi_mode - DBI implemented in DDRC or PHY. Present only in designs configured to support DDR4 and LPDDR4.
 *  0b0..DDRC implements DBI functionality.
 *  0b1..PHY implements DBI functionality.
 */
#define DDRC_DFIMISC_PHY_DBI_MODE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFIMISC_PHY_DBI_MODE_SHIFT)) & DDRC_DFIMISC_PHY_DBI_MODE_MASK)
#define DDRC_DFIMISC_DFI_DATA_CS_POLARITY_MASK  (0x4U)
#define DDRC_DFIMISC_DFI_DATA_CS_POLARITY_SHIFT (2U)
/*! dfi_data_cs_polarity - Defines polarity of dfi_wrdata_cs and dfi_rddata_cs signals.
 *  0b0..Signals are active low
 *  0b1..Signals are active high
 */
#define DDRC_DFIMISC_DFI_DATA_CS_POLARITY(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFIMISC_DFI_DATA_CS_POLARITY_SHIFT)) & DDRC_DFIMISC_DFI_DATA_CS_POLARITY_MASK)
#define DDRC_DFIMISC_CTL_IDLE_EN_MASK  (0x10U)
#define DDRC_DFIMISC_CTL_IDLE_EN_SHIFT (4U)
/*! ctl_idle_en - Enables support of ctl_idle signal, which is non-DFI related pin specific to
 *    certain PHYs. See signal description of ctl_idle signal for further details of ctl_idle
 *    functionality.
 */
#define DDRC_DFIMISC_CTL_IDLE_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFIMISC_CTL_IDLE_EN_SHIFT)) & DDRC_DFIMISC_CTL_IDLE_EN_MASK)
#define DDRC_DFIMISC_DFI_INIT_START_MASK  (0x20U)
#define DDRC_DFIMISC_DFI_INIT_START_SHIFT (5U)
/*! dfi_init_start - PHY init start request signal.When asserted it triggers the PHY init start request
 */
#define DDRC_DFIMISC_DFI_INIT_START(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFIMISC_DFI_INIT_START_SHIFT)) & DDRC_DFIMISC_DFI_INIT_START_MASK)
#define DDRC_DFIMISC_DFI_FREQUENCY_MASK  (0x1F00U)
#define DDRC_DFIMISC_DFI_FREQUENCY_SHIFT (8U)
/*! dfi_frequency - Indicates the operating frequency of the system. The number of supported
 *    frequencies and the mapping of signal values to clock frequencies are defined by the PHY.
 */
#define DDRC_DFIMISC_DFI_FREQUENCY(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFIMISC_DFI_FREQUENCY_SHIFT)) & DDRC_DFIMISC_DFI_FREQUENCY_MASK)
/*! @} */

/*! @name DFITMG2 - DFI Timing Register 2 */
/*! @{ */
#define DDRC_DFITMG2_DFI_TPHY_WRCSLAT_MASK  (0x3FU)
#define DDRC_DFITMG2_DFI_TPHY_WRCSLAT_SHIFT (0U)
/*! dfi_tphy_wrcslat - Number of DFI PHY clock cycles between when a write command is sent on the
 *    DFI control interface and when the associated dfi_wrdata_cs signal is asserted. This corresponds
 *    to the DFI timing parameter tphy_wrcslat. Refer to PHY specification for correct value.
 */
#define DDRC_DFITMG2_DFI_TPHY_WRCSLAT(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFITMG2_DFI_TPHY_WRCSLAT_SHIFT)) & DDRC_DFITMG2_DFI_TPHY_WRCSLAT_MASK)
#define DDRC_DFITMG2_DFI_TPHY_RDCSLAT_MASK  (0x7F00U)
#define DDRC_DFITMG2_DFI_TPHY_RDCSLAT_SHIFT (8U)
/*! dfi_tphy_rdcslat - Number of DFI PHY clock cycles between when a read command is sent on the DFI
 *    control interface and when the associated dfi_rddata_cs signal is asserted. This corresponds
 *    to the DFI timing parameter tphy_rdcslat. Refer to PHY specification for correct value.
 */
#define DDRC_DFITMG2_DFI_TPHY_RDCSLAT(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFITMG2_DFI_TPHY_RDCSLAT_SHIFT)) & DDRC_DFITMG2_DFI_TPHY_RDCSLAT_MASK)
/*! @} */

/*! @name DFITMG3 - DFI Timing Register 3 */
/*! @{ */
#define DDRC_DFITMG3_DFI_T_GEARDOWN_DELAY_MASK  (0x1FU)
#define DDRC_DFITMG3_DFI_T_GEARDOWN_DELAY_SHIFT (0U)
/*! dfi_t_geardown_delay - The delay from dfi_geardown_en assertion to the time of the PHY being
 *    ready to receive commands. Refer to PHY specification for correct value. When the controller is
 *    operating in 1:2 frequency ratio mode, program this to (tgeardown_delay/2) and round it up to
 *    the next integer value. Unit: Clocks
 */
#define DDRC_DFITMG3_DFI_T_GEARDOWN_DELAY(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFITMG3_DFI_T_GEARDOWN_DELAY_SHIFT)) & DDRC_DFITMG3_DFI_T_GEARDOWN_DELAY_MASK)
/*! @} */

/*! @name DFISTAT - DFI Status Register */
/*! @{ */
#define DDRC_DFISTAT_DFI_INIT_COMPLETE_MASK  (0x1U)
#define DDRC_DFISTAT_DFI_INIT_COMPLETE_SHIFT (0U)
/*! dfi_init_complete - The status flag register which announces when the DFI initialization has
 *    been completed. The DFI INIT triggered by dfi_init_start signal and then the dfi_init_complete
 *    flag is polled to know when the initialization is done.
 */
#define DDRC_DFISTAT_DFI_INIT_COMPLETE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFISTAT_DFI_INIT_COMPLETE_SHIFT)) & DDRC_DFISTAT_DFI_INIT_COMPLETE_MASK)
#define DDRC_DFISTAT_DFI_LP_ACK_MASK  (0x2U)
#define DDRC_DFISTAT_DFI_LP_ACK_SHIFT (1U)
/*! dfi_lp_ack - Stores the value of the dfi_lp_ack input to the controller.
 */
#define DDRC_DFISTAT_DFI_LP_ACK(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFISTAT_DFI_LP_ACK_SHIFT)) & DDRC_DFISTAT_DFI_LP_ACK_MASK)
/*! @} */

/*! @name DBICTL - DM/DBI Control Register */
/*! @{ */
#define DDRC_DBICTL_DM_EN_MASK  (0x1U)
#define DDRC_DBICTL_DM_EN_SHIFT (0U)
/*! dm_en - DM enable signal in DDRC. This signal must be set the same logical value as DRAM's mode
 *    register. - DDR4: Set this to same value as MR5 bit A10. When x4 devices are used, this signal
 *    must be set to 0. - LPDDR4: Set this to inverted value of MR13[5] which is opposite polarity
 *    from this signal
 *  0b0..DM is disabled
 *  0b1..DM is enabled
 */
#define DDRC_DBICTL_DM_EN(x)        (((uint32_t)(((uint32_t)(x)) << DDRC_DBICTL_DM_EN_SHIFT)) & DDRC_DBICTL_DM_EN_MASK)
#define DDRC_DBICTL_WR_DBI_EN_MASK  (0x2U)
#define DDRC_DBICTL_WR_DBI_EN_SHIFT (1U)
/*! wr_dbi_en - This signal must be set the same value as DRAM's mode register. - DDR4: MR5 bit A11.
 *    When x4 devices are used, this signal must be set to 0. - LPDDR4: MR3[7]
 *  0b0..Write DBI is disabled
 *  0b1..Write DBI is enabled.
 */
#define DDRC_DBICTL_WR_DBI_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DBICTL_WR_DBI_EN_SHIFT)) & DDRC_DBICTL_WR_DBI_EN_MASK)
#define DDRC_DBICTL_RD_DBI_EN_MASK  (0x4U)
#define DDRC_DBICTL_RD_DBI_EN_SHIFT (2U)
/*! rd_dbi_en - Read DBI enable signal in DDRC. - 0 - Read DBI is disabled. - 1 - Read DBI is
 *    enabled. This signal must be set the same value as DRAM's mode register. - DDR4: MR5 bit A12. When
 *    x4 devices are used, this signal must be set to 0. - LPDDR4: MR3[6]
 */
#define DDRC_DBICTL_RD_DBI_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DBICTL_RD_DBI_EN_SHIFT)) & DDRC_DBICTL_RD_DBI_EN_MASK)
/*! @} */

/*! @name ADDRMAP0 - Address Map Register 0 */
/*! @{ */
#define DDRC_ADDRMAP0_ADDRMAP_CS_BIT0_MASK  (0x1FU)
#define DDRC_ADDRMAP0_ADDRMAP_CS_BIT0_SHIFT (0U)
/*! addrmap_cs_bit0 - Selects the HIF address bit used as rank address bit 0. Valid Range: 0 to 28,
 *    and 31 Internal Base: 6 The selected HIF address bit is determined by adding the internal base
 *    to the value of this field. If set to 31, rank address bit 0 is set to 0.
 */
#define DDRC_ADDRMAP0_ADDRMAP_CS_BIT0(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP0_ADDRMAP_CS_BIT0_SHIFT)) & DDRC_ADDRMAP0_ADDRMAP_CS_BIT0_MASK)
/*! @} */

/*! @name ADDRMAP1 - Address Map Register 1 */
/*! @{ */
#define DDRC_ADDRMAP1_ADDRMAP_BANK_B0_MASK  (0x1FU)
#define DDRC_ADDRMAP1_ADDRMAP_BANK_B0_SHIFT (0U)
/*! addrmap_bank_b0 - Selects the HIF address bits used as bank address bit 0. Valid Range: 0 to 31
 *    Internal Base: 2 The selected HIF address bit for each of the bank address bits is determined
 *    by adding the internal base to the value of this field.
 */
#define DDRC_ADDRMAP1_ADDRMAP_BANK_B0(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP1_ADDRMAP_BANK_B0_SHIFT)) & DDRC_ADDRMAP1_ADDRMAP_BANK_B0_MASK)
#define DDRC_ADDRMAP1_ADDRMAP_BANK_B1_MASK  (0x1F00U)
#define DDRC_ADDRMAP1_ADDRMAP_BANK_B1_SHIFT (8U)
/*! addrmap_bank_b1 - Selects the HIF address bits used as bank address bit 1. Valid Range: 0 to 31
 *    Internal Base: 3 The selected HIF address bit for each of the bank address bits is determined
 *    by adding the internal base to the value of this field.
 */
#define DDRC_ADDRMAP1_ADDRMAP_BANK_B1(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP1_ADDRMAP_BANK_B1_SHIFT)) & DDRC_ADDRMAP1_ADDRMAP_BANK_B1_MASK)
#define DDRC_ADDRMAP1_ADDRMAP_BANK_B2_MASK  (0x1F0000U)
#define DDRC_ADDRMAP1_ADDRMAP_BANK_B2_SHIFT (16U)
/*! addrmap_bank_b2 - Selects the HIF address bit used as bank address bit 2. Valid Range: 0 to 30
 *    and 31 Internal Base: 4 The selected HIF address bit is determined by adding the internal base
 *    to the value of this field. If set to 31, bank address bit 2 is set to 0.
 */
#define DDRC_ADDRMAP1_ADDRMAP_BANK_B2(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP1_ADDRMAP_BANK_B2_SHIFT)) & DDRC_ADDRMAP1_ADDRMAP_BANK_B2_MASK)
/*! @} */

/*! @name ADDRMAP2 - Address Map Register 2 */
/*! @{ */
#define DDRC_ADDRMAP2_ADDRMAP_COL_B2_MASK  (0xFU)
#define DDRC_ADDRMAP2_ADDRMAP_COL_B2_SHIFT (0U)
/*! addrmap_col_b2 - - Full bus width mode: Selects the HIF address bit used as column address bit
 *    2. - Half bus width mode: Selects the HIF address bit used as column address bit 3. - Quarter
 *    bus width mode: Selects the HIF address bit used as column address bit 4. Valid Range: 0 to 7
 *    Internal Base: 2 The selected HIF address bit is determined by adding the internal base to the
 *    value of this field. Note, if DDRC_INCL_ARB=1 and MEMC_BURST_LENGTH=8, it is required to
 *    program this to 0 unless: - in Half or Quarter bus width (MSTR.data_bus_width!=00) and -
 *    PCCFG.bl_exp_mode==1 and either - In DDR4 and ADDRMAP8.addrmap_bg_b0==0 or - In LPDDR4 and
 *    ADDRMAP1.addrmap_bank_b0==0 If DDRC_INCL_ARB=1 and MEMC_BURST_LENGTH=16, it is required to program this to
 *    0 unless: - in Half or Quarter bus width (MSTR.data_bus_width!=00) and - PCCFG.bl_exp_mode==1
 *    and - In DDR4 and ADDRMAP8.addrmap_bg_b0==0 Otherwise, if MEMC_BURST_LENGTH=8 and Full Bus
 *    Width (MSTR.data_bus_width==00), it is recommended to program this to 0 so that HIF[2] maps to
 *    column address bit 2. If MEMC_BURST_LENGTH=16 and Full Bus Width (MSTR.data_bus_width==00), it
 *    is recommended to program this to 0 so that HIF[2] maps to column address bit 2. If
 *    MEMC_BURST_LENGTH=16 and Half Bus Width (MSTR.data_bus_width==01), it is recommended to program this to 0
 *    so that HIF[2] maps to column address bit 3.
 */
#define DDRC_ADDRMAP2_ADDRMAP_COL_B2(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP2_ADDRMAP_COL_B2_SHIFT)) & DDRC_ADDRMAP2_ADDRMAP_COL_B2_MASK)
#define DDRC_ADDRMAP2_ADDRMAP_COL_B3_MASK  (0xF00U)
#define DDRC_ADDRMAP2_ADDRMAP_COL_B3_SHIFT (8U)
/*! addrmap_col_b3 - - Full bus width mode: Selects the HIF address bit used as column address bit
 *    3. - Half bus width mode: Selects the HIF address bit used as column address bit 4. - Quarter
 *    bus width mode: Selects the HIF address bit used as column address bit 5. Valid Range: 0 to 7
 *    Internal Base: 3 The selected HIF address bit is determined by adding the internal base to the
 *    value of this field. Note, if DDRC_INCL_ARB=1, MEMC_BURST_LENGTH=16, Full bus width
 *    (MSTR.data_bus_width=00) and BL16 (MSTR.burst_rdwr=1000), it is recommended to program this to 0.
 */
#define DDRC_ADDRMAP2_ADDRMAP_COL_B3(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP2_ADDRMAP_COL_B3_SHIFT)) & DDRC_ADDRMAP2_ADDRMAP_COL_B3_MASK)
#define DDRC_ADDRMAP2_ADDRMAP_COL_B4_MASK  (0xF0000U)
#define DDRC_ADDRMAP2_ADDRMAP_COL_B4_SHIFT (16U)
/*! addrmap_col_b4 - - Full bus width mode: Selects the HIF address bit used as column address bit
 *    4. - Half bus width mode: Selects the HIF address bit used as column address bit 5. - Quarter
 *    bus width mode: Selects the HIF address bit used as column address bit 6. Valid Range: 0 to 7,
 *    and 15 Internal Base: 4 The selected HIF address bit is determined by adding the internal base
 *    to the value of this field. If set to 15, this column address bit is set to 0.
 */
#define DDRC_ADDRMAP2_ADDRMAP_COL_B4(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP2_ADDRMAP_COL_B4_SHIFT)) & DDRC_ADDRMAP2_ADDRMAP_COL_B4_MASK)
#define DDRC_ADDRMAP2_ADDRMAP_COL_B5_MASK  (0xF000000U)
#define DDRC_ADDRMAP2_ADDRMAP_COL_B5_SHIFT (24U)
/*! addrmap_col_b5 - - Full bus width mode: Selects the HIF address bit used as column address bit
 *    5. - Half bus width mode: Selects the HIF address bit used as column address bit 6. - Quarter
 *    bus width mode: Selects the HIF address bit used as column address bit 7 . Valid Range: 0 to 7,
 *    and 15 Internal Base: 5 The selected HIF address bit is determined by adding the internal
 *    base to the value of this field. If set to 15, this column address bit is set to 0.
 */
#define DDRC_ADDRMAP2_ADDRMAP_COL_B5(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP2_ADDRMAP_COL_B5_SHIFT)) & DDRC_ADDRMAP2_ADDRMAP_COL_B5_MASK)
/*! @} */

/*! @name ADDRMAP3 - Address Map Register 3 */
/*! @{ */
#define DDRC_ADDRMAP3_ADDRMAP_COL_B6_MASK  (0xFU)
#define DDRC_ADDRMAP3_ADDRMAP_COL_B6_SHIFT (0U)
/*! addrmap_col_b6 - - Full bus width mode: Selects the HIF address bit used as column address bit
 *    6. - Half bus width mode: Selects the HIF address bit used as column address bit 7. - Quarter
 *    bus width mode: Selects the HIF address bit used as column address bit 8. Valid Range: 0 to 7,
 *    and 15 Internal Base: 6 The selected HIF address bit is determined by adding the internal base
 *    to the value of this field. If set to 15, this column address bit is set to 0.
 */
#define DDRC_ADDRMAP3_ADDRMAP_COL_B6(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP3_ADDRMAP_COL_B6_SHIFT)) & DDRC_ADDRMAP3_ADDRMAP_COL_B6_MASK)
#define DDRC_ADDRMAP3_ADDRMAP_COL_B7_MASK  (0xF00U)
#define DDRC_ADDRMAP3_ADDRMAP_COL_B7_SHIFT (8U)
/*! addrmap_col_b7 - - Full bus width mode: Selects the HIF address bit used as column address bit
 *    7. - Half bus width mode: Selects the HIF address bit used as column address bit 8. - Quarter
 *    bus width mode: Selects the HIF address bit used as column address bit 9. Valid Range: 0 to 7,
 *    and 15 Internal Base: 7 The selected HIF address bit is determined by adding the internal base
 *    to the value of this field. If set to 15, this column address bit is set to 0.
 */
#define DDRC_ADDRMAP3_ADDRMAP_COL_B7(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP3_ADDRMAP_COL_B7_SHIFT)) & DDRC_ADDRMAP3_ADDRMAP_COL_B7_MASK)
#define DDRC_ADDRMAP3_ADDRMAP_COL_B8_MASK  (0xF0000U)
#define DDRC_ADDRMAP3_ADDRMAP_COL_B8_SHIFT (16U)
/*! addrmap_col_b8 - - Full bus width mode: Selects the HIF address bit used as column address bit
 *    8. - Half bus width mode: Selects the HIF address bit used as column address bit 9. - Quarter
 *    bus width mode: Selects the HIF address bit used as column address bit 11 (10 in LPDDR2/LPDDR3
 *    mode). Valid Range: 0 to 7, and 15 Internal Base: 8 The selected HIF address bit is determined
 *    by adding the internal base to the value of this field. If set to 15, this column address bit
 *    is set to 0. Note: Per JEDEC DDR2/3/mDDR specification, column address bit 10 is reserved for
 *    indicating auto-precharge, and hence no source address bit can be mapped to column address
 *    bit 10. In LPDDR2/LPDDR3, there is a dedicated bit for auto-precharge in the CA bus and hence
 *    column bit 10 is used.
 */
#define DDRC_ADDRMAP3_ADDRMAP_COL_B8(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP3_ADDRMAP_COL_B8_SHIFT)) & DDRC_ADDRMAP3_ADDRMAP_COL_B8_MASK)
#define DDRC_ADDRMAP3_ADDRMAP_COL_B9_MASK  (0xF000000U)
#define DDRC_ADDRMAP3_ADDRMAP_COL_B9_SHIFT (24U)
/*! addrmap_col_b9 - - Full bus width mode: Selects the HIF address bit used as column address bit
 *    9. - Half bus width mode: Selects the HIF address bit used as column address bit 11 (10 in
 *    LPDDR2/LPDDR3 mode). - Quarter bus width mode: Selects the HIF address bit used as column address
 *    bit 13 (11 in LPDDR2/LPDDR3 mode). Valid Range: 0 to 7, and 15 Internal Base: 9 The selected
 *    HIF address bit is determined by adding the internal base to the value of this field. If set to
 *    15, this column address bit is set to 0. Note: Per JEDEC DDR2/3/mDDR specification, column
 *    address bit 10 is reserved for indicating auto-precharge, and hence no source address bit can be
 *    mapped to column address bit 10. In LPDDR2/LPDDR3, there is a dedicated bit for
 *    auto-precharge in the CA bus and hence column bit 10 is used.
 */
#define DDRC_ADDRMAP3_ADDRMAP_COL_B9(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP3_ADDRMAP_COL_B9_SHIFT)) & DDRC_ADDRMAP3_ADDRMAP_COL_B9_MASK)
/*! @} */

/*! @name ADDRMAP4 - Address Map Register 4 */
/*! @{ */
#define DDRC_ADDRMAP4_ADDRMAP_COL_B10_MASK  (0xFU)
#define DDRC_ADDRMAP4_ADDRMAP_COL_B10_SHIFT (0U)
/*! addrmap_col_b10 - - Full bus width mode: Selects the HIF address bit used as column address bit
 *    11 (10 in LPDDR2/LPDDR3 mode). - Half bus width mode: Selects the HIF address bit used as
 *    column address bit 13 (11 in LPDDR2/LPDDR3 mode). - Quarter bus width mode: UNUSED. To make it
 *    unused, this must be tied to 4'hF. Valid Range: 0 to 7, and 15 Internal Base: 10 The selected HIF
 *    address bit is determined by adding the internal base to the value of this field. If set to
 *    15, this column address bit is set to 0. Note: Per JEDEC DDR2/3/mDDR specification, column
 *    address bit 10 is reserved for indicating auto-precharge, and hence no source address bit can be
 *    mapped to column address bit 10. In LPDDR2/LPDDR3, there is a dedicated bit for auto-precharge
 *    in the CA bus and hence column bit 10 is used.
 */
#define DDRC_ADDRMAP4_ADDRMAP_COL_B10(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP4_ADDRMAP_COL_B10_SHIFT)) & DDRC_ADDRMAP4_ADDRMAP_COL_B10_MASK)
#define DDRC_ADDRMAP4_ADDRMAP_COL_B11_MASK  (0xF00U)
#define DDRC_ADDRMAP4_ADDRMAP_COL_B11_SHIFT (8U)
/*! addrmap_col_b11 - - Full bus width mode: Selects the HIF address bit used as column address bit
 *    13 (11 in LPDDR2/LPDDR3 mode). - Half bus width mode: Unused. To make it unused, this should
 *    be tied to 4'hF. - Quarter bus width mode: Unused. To make it unused, this must be tied to
 *    4'hF. Valid Range: 0 to 7, and 15 Internal Base: 11 The selected HIF address bit is determined by
 *    adding the internal base to the value of this field. If set to 15, this column address bit is
 *    set to 0. Note: Per JEDEC DDR2/3/mDDR specification, column address bit 10 is reserved for
 *    indicating auto-precharge, and hence no source address bit can be mapped to column address bit
 *    10. In LPDDR2/LPDDR3, there is a dedicated bit for auto-precharge in the CA bus and hence column
 *    bit 10 is used.
 */
#define DDRC_ADDRMAP4_ADDRMAP_COL_B11(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP4_ADDRMAP_COL_B11_SHIFT)) & DDRC_ADDRMAP4_ADDRMAP_COL_B11_MASK)
/*! @} */

/*! @name ADDRMAP5 - Address Map Register 5 */
/*! @{ */
#define DDRC_ADDRMAP5_ADDRMAP_ROW_B0_MASK  (0xFU)
#define DDRC_ADDRMAP5_ADDRMAP_ROW_B0_SHIFT (0U)
/*! addrmap_row_b0 - Selects the HIF address bits used as row address bit 0. Valid Range: 0 to 11
 *    Internal Base: 6 The selected HIF address bit for each of the row address bits is determined by
 *    adding the internal base to the value of this field.
 */
#define DDRC_ADDRMAP5_ADDRMAP_ROW_B0(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP5_ADDRMAP_ROW_B0_SHIFT)) & DDRC_ADDRMAP5_ADDRMAP_ROW_B0_MASK)
#define DDRC_ADDRMAP5_ADDRMAP_ROW_B1_MASK  (0xF00U)
#define DDRC_ADDRMAP5_ADDRMAP_ROW_B1_SHIFT (8U)
/*! addrmap_row_b1 - Selects the HIF address bits used as row address bit 1. Valid Range: 0 to 11
 *    Internal Base: 7 The selected HIF address bit for each of the row address bits is determined by
 *    adding the internal base to the value of this field.
 */
#define DDRC_ADDRMAP5_ADDRMAP_ROW_B1(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP5_ADDRMAP_ROW_B1_SHIFT)) & DDRC_ADDRMAP5_ADDRMAP_ROW_B1_MASK)
#define DDRC_ADDRMAP5_ADDRMAP_ROW_B2_10_MASK  (0xF0000U)
#define DDRC_ADDRMAP5_ADDRMAP_ROW_B2_10_SHIFT (16U)
/*! addrmap_row_b2_10 - Selects the HIF address bits used as row address bits 2 to 10. Valid Range:
 *    0 to 11, and 15 Internal Base: 8 (for row address bit 2), 9 (for row address bit 3), 10 (for
 *    row address bit 4) etc increasing to 16 (for row address bit 10) The selected HIF address bit
 *    for each of the row address bits is determined by adding the internal base to the value of this
 *    field. When value 15 is used the values of row address bits 2 to 10 are defined by registers
 *    ADDRMAP9, ADDRMAP10, ADDRMAP11.
 */
#define DDRC_ADDRMAP5_ADDRMAP_ROW_B2_10(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP5_ADDRMAP_ROW_B2_10_SHIFT)) & DDRC_ADDRMAP5_ADDRMAP_ROW_B2_10_MASK)
#define DDRC_ADDRMAP5_ADDRMAP_ROW_B11_MASK  (0xF000000U)
#define DDRC_ADDRMAP5_ADDRMAP_ROW_B11_SHIFT (24U)
/*! addrmap_row_b11 - Selects the HIF address bit used as row address bit 11. Valid Range: 0 to 11,
 *    and 15 Internal Base: 17 The selected HIF address bit is determined by adding the internal
 *    base to the value of this field. If set to 15, row address bit 11 is set to 0.
 */
#define DDRC_ADDRMAP5_ADDRMAP_ROW_B11(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP5_ADDRMAP_ROW_B11_SHIFT)) & DDRC_ADDRMAP5_ADDRMAP_ROW_B11_MASK)
/*! @} */

/*! @name ADDRMAP6 - Address Map Register 6 */
/*! @{ */
#define DDRC_ADDRMAP6_ADDRMAP_ROW_B12_MASK  (0xFU)
#define DDRC_ADDRMAP6_ADDRMAP_ROW_B12_SHIFT (0U)
/*! addrmap_row_b12 - Selects the HIF address bit used as row address bit 12. Valid Range: 0 to 11,
 *    and 15 Internal Base: 18 The selected HIF address bit is determined by adding the internal
 *    base to the value of this field. If set to 15, row address bit 12 is set to 0.
 */
#define DDRC_ADDRMAP6_ADDRMAP_ROW_B12(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP6_ADDRMAP_ROW_B12_SHIFT)) & DDRC_ADDRMAP6_ADDRMAP_ROW_B12_MASK)
#define DDRC_ADDRMAP6_ADDRMAP_ROW_B13_MASK  (0xF00U)
#define DDRC_ADDRMAP6_ADDRMAP_ROW_B13_SHIFT (8U)
/*! addrmap_row_b13 - Selects the HIF address bit used as row address bit 13. Valid Range: 0 to 11,
 *    and 15 Internal Base: 19 The selected HIF address bit is determined by adding the internal
 *    base to the value of this field. If set to 15, row address bit 13 is set to 0.
 */
#define DDRC_ADDRMAP6_ADDRMAP_ROW_B13(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP6_ADDRMAP_ROW_B13_SHIFT)) & DDRC_ADDRMAP6_ADDRMAP_ROW_B13_MASK)
#define DDRC_ADDRMAP6_ADDRMAP_ROW_B14_MASK  (0xF0000U)
#define DDRC_ADDRMAP6_ADDRMAP_ROW_B14_SHIFT (16U)
/*! addrmap_row_b14 - Selects the HIF address bit used as row address bit 14. Valid Range: 0 to 11,
 *    and 15 Internal Base: 20 The selected HIF address bit is determined by adding the internal
 *    base to the value of this field. If set to 15, row address bit 14 is set to 0.
 */
#define DDRC_ADDRMAP6_ADDRMAP_ROW_B14(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP6_ADDRMAP_ROW_B14_SHIFT)) & DDRC_ADDRMAP6_ADDRMAP_ROW_B14_MASK)
#define DDRC_ADDRMAP6_ADDRMAP_ROW_B15_MASK  (0xF000000U)
#define DDRC_ADDRMAP6_ADDRMAP_ROW_B15_SHIFT (24U)
/*! addrmap_row_b15 - Selects the HIF address bit used as row address bit 15. Valid Range: 0 to 11,
 *    and 15 Internal Base: 21 The selected HIF address bit is determined by adding the internal
 *    base to the value of this field. If set to 15, row address bit 15 is set to 0.
 */
#define DDRC_ADDRMAP6_ADDRMAP_ROW_B15(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP6_ADDRMAP_ROW_B15_SHIFT)) & DDRC_ADDRMAP6_ADDRMAP_ROW_B15_MASK)
#define DDRC_ADDRMAP6_LPDDR3_6GB_12GB_MASK  (0x80000000U)
#define DDRC_ADDRMAP6_LPDDR3_6GB_12GB_SHIFT (31U)
/*! lpddr3_6gb_12gb - Set this to 1 if there is an LPDDR3 SDRAM 6Gb or 12Gb device in use. - 1 -
 *    LPDDR3 SDRAM 6Gb/12Gb device in use. Every address having row[14:13]==2'b11 is considered as
 *    invalid - 0 - non-LPDDR3 6Gb/12Gb device in use. All addresses are valid Present only in designs
 *    configured to support LPDDR3.
 */
#define DDRC_ADDRMAP6_LPDDR3_6GB_12GB(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP6_LPDDR3_6GB_12GB_SHIFT)) & DDRC_ADDRMAP6_LPDDR3_6GB_12GB_MASK)
/*! @} */

/*! @name ADDRMAP7 - Address Map Register 7 */
/*! @{ */
#define DDRC_ADDRMAP7_ADDRMAP_ROW_B16_MASK  (0xFU)
#define DDRC_ADDRMAP7_ADDRMAP_ROW_B16_SHIFT (0U)
/*! addrmap_row_b16 - Selects the HIF address bit used as row address bit 16. Valid Range: 0 to 11,
 *    and 15 Internal Base: 22 The selected HIF address bit is determined by adding the internal
 *    base to the value of this field. If set to 15, row address bit 16 is set to 0.
 */
#define DDRC_ADDRMAP7_ADDRMAP_ROW_B16(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP7_ADDRMAP_ROW_B16_SHIFT)) & DDRC_ADDRMAP7_ADDRMAP_ROW_B16_MASK)
#define DDRC_ADDRMAP7_ADDRMAP_ROW_B17_MASK  (0xF00U)
#define DDRC_ADDRMAP7_ADDRMAP_ROW_B17_SHIFT (8U)
/*! addrmap_row_b17 - Selects the HIF address bit used as row address bit 17. Valid Range: 0 to 11,
 *    and 15 Internal Base: 23 The selected HIF address bit is determined by adding the internal
 *    base to the value of this field. If set to 15, row address bit 17 is set to 0.
 */
#define DDRC_ADDRMAP7_ADDRMAP_ROW_B17(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP7_ADDRMAP_ROW_B17_SHIFT)) & DDRC_ADDRMAP7_ADDRMAP_ROW_B17_MASK)
/*! @} */

/*! @name ADDRMAP8 - Address Map Register 8 */
/*! @{ */
#define DDRC_ADDRMAP8_ADDRMAP_BG_B0_MASK  (0x1FU)
#define DDRC_ADDRMAP8_ADDRMAP_BG_B0_SHIFT (0U)
/*! addrmap_bg_b0 - Selects the HIF address bits used as bank group address bit 0. Valid Range: 0 to
 *    31 Internal Base: 2 The selected HIF address bit for each of the bank group address bits is
 *    determined by adding the internal base to the value of this field.
 */
#define DDRC_ADDRMAP8_ADDRMAP_BG_B0(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP8_ADDRMAP_BG_B0_SHIFT)) & DDRC_ADDRMAP8_ADDRMAP_BG_B0_MASK)
#define DDRC_ADDRMAP8_ADDRMAP_BG_B1_MASK  (0x3F00U)
#define DDRC_ADDRMAP8_ADDRMAP_BG_B1_SHIFT (8U)
/*! addrmap_bg_b1 - Selects the HIF address bits used as bank group address bit 1. Valid Range: 0 to
 *    31, and 63 Internal Base: 3 The selected HIF address bit for each of the bank group address
 *    bits is determined by adding the internal base to the value of this field. If set to 63, bank
 *    group address bit 1 is set to 0.
 */
#define DDRC_ADDRMAP8_ADDRMAP_BG_B1(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP8_ADDRMAP_BG_B1_SHIFT)) & DDRC_ADDRMAP8_ADDRMAP_BG_B1_MASK)
/*! @} */

/*! @name ADDRMAP9 - Address Map Register 9 */
/*! @{ */
#define DDRC_ADDRMAP9_ADDRMAP_ROW_B2_MASK  (0xFU)
#define DDRC_ADDRMAP9_ADDRMAP_ROW_B2_SHIFT (0U)
/*! addrmap_row_b2 - Selects the HIF address bits used as row address bit 2. Valid Range: 0 to 11
 *    Internal Base: 8 The selected HIF address bit for each of the row address bits is determined by
 *    adding the internal base to the value of this field. This register field is used only when
 *    ADDRMAP5.addrmap_row_b2_10 is set to value 15.
 */
#define DDRC_ADDRMAP9_ADDRMAP_ROW_B2(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP9_ADDRMAP_ROW_B2_SHIFT)) & DDRC_ADDRMAP9_ADDRMAP_ROW_B2_MASK)
#define DDRC_ADDRMAP9_ADDRMAP_ROW_B3_MASK  (0xF00U)
#define DDRC_ADDRMAP9_ADDRMAP_ROW_B3_SHIFT (8U)
/*! addrmap_row_b3 - Selects the HIF address bits used as row address bit 3. Valid Range: 0 to 11
 *    Internal Base: 9 The selected HIF address bit for each of the row address bits is determined by
 *    adding the internal base to the value of this field. This register field is used only when
 *    ADDRMAP5.addrmap_row_b2_10 is set to value 15.
 */
#define DDRC_ADDRMAP9_ADDRMAP_ROW_B3(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP9_ADDRMAP_ROW_B3_SHIFT)) & DDRC_ADDRMAP9_ADDRMAP_ROW_B3_MASK)
#define DDRC_ADDRMAP9_ADDRMAP_ROW_B4_MASK  (0xF0000U)
#define DDRC_ADDRMAP9_ADDRMAP_ROW_B4_SHIFT (16U)
/*! addrmap_row_b4 - Selects the HIF address bits used as row address bit 4. Valid Range: 0 to 11
 *    Internal Base: 10 The selected HIF address bit for each of the row address bits is determined by
 *    adding the internal base to the value of this field. This register field is used only when
 *    ADDRMAP5.addrmap_row_b2_10 is set to value 15.
 */
#define DDRC_ADDRMAP9_ADDRMAP_ROW_B4(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP9_ADDRMAP_ROW_B4_SHIFT)) & DDRC_ADDRMAP9_ADDRMAP_ROW_B4_MASK)
#define DDRC_ADDRMAP9_ADDRMAP_ROW_B5_MASK  (0xF000000U)
#define DDRC_ADDRMAP9_ADDRMAP_ROW_B5_SHIFT (24U)
/*! addrmap_row_b5 - Selects the HIF address bits used as row address bit 5. Valid Range: 0 to 11
 *    Internal Base: 11 The selected HIF address bit for each of the row address bits is determined by
 *    adding the internal base to the value of this field. This register field is used only when
 *    ADDRMAP5.addrmap_row_b2_10 is set to value 15.
 */
#define DDRC_ADDRMAP9_ADDRMAP_ROW_B5(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP9_ADDRMAP_ROW_B5_SHIFT)) & DDRC_ADDRMAP9_ADDRMAP_ROW_B5_MASK)
/*! @} */

/*! @name ADDRMAP10 - Address Map Register 10 */
/*! @{ */
#define DDRC_ADDRMAP10_ADDRMAP_ROW_B6_MASK  (0xFU)
#define DDRC_ADDRMAP10_ADDRMAP_ROW_B6_SHIFT (0U)
/*! addrmap_row_b6 - Selects the HIF address bits used as row address bit 6. Valid Range: 0 to 11
 *    Internal Base: 12 The selected HIF address bit for each of the row address bits is determined by
 *    adding the internal base to the value of this field. This register field is used only when
 *    ADDRMAP5.addrmap_row_b2_10 is set to value 15.
 */
#define DDRC_ADDRMAP10_ADDRMAP_ROW_B6(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP10_ADDRMAP_ROW_B6_SHIFT)) & DDRC_ADDRMAP10_ADDRMAP_ROW_B6_MASK)
#define DDRC_ADDRMAP10_ADDRMAP_ROW_B7_MASK  (0xF00U)
#define DDRC_ADDRMAP10_ADDRMAP_ROW_B7_SHIFT (8U)
/*! addrmap_row_b7 - Selects the HIF address bits used as row address bit 7. Valid Range: 0 to 11
 *    Internal Base: 13 The selected HIF address bit for each of the row address bits is determined by
 *    adding the internal base to the value of this field. This register field is used only when
 *    ADDRMAP5.addrmap_row_b2_10 is set to value 15.
 */
#define DDRC_ADDRMAP10_ADDRMAP_ROW_B7(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP10_ADDRMAP_ROW_B7_SHIFT)) & DDRC_ADDRMAP10_ADDRMAP_ROW_B7_MASK)
#define DDRC_ADDRMAP10_ADDRMAP_ROW_B8_MASK  (0xF0000U)
#define DDRC_ADDRMAP10_ADDRMAP_ROW_B8_SHIFT (16U)
/*! addrmap_row_b8 - Selects the HIF address bits used as row address bit 8. Valid Range: 0 to 11
 *    Internal Base: 14 The selected HIF address bit for each of the row address bits is determined by
 *    adding the internal base to the value of this field. This register field is used only when
 *    ADDRMAP5.addrmap_row_b2_10 is set to value 15.
 */
#define DDRC_ADDRMAP10_ADDRMAP_ROW_B8(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP10_ADDRMAP_ROW_B8_SHIFT)) & DDRC_ADDRMAP10_ADDRMAP_ROW_B8_MASK)
#define DDRC_ADDRMAP10_ADDRMAP_ROW_B9_MASK  (0xF000000U)
#define DDRC_ADDRMAP10_ADDRMAP_ROW_B9_SHIFT (24U)
/*! addrmap_row_b9 - Selects the HIF address bits used as row address bit 9. Valid Range: 0 to 11
 *    Internal Base: 15 The selected HIF address bit for each of the row address bits is determined by
 *    adding the internal base to the value of this field. This register field is used only when
 *    ADDRMAP5.addrmap_row_b2_10 is set to value 15.
 */
#define DDRC_ADDRMAP10_ADDRMAP_ROW_B9(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP10_ADDRMAP_ROW_B9_SHIFT)) & DDRC_ADDRMAP10_ADDRMAP_ROW_B9_MASK)
/*! @} */

/*! @name ADDRMAP11 - Address Map Register 11 */
/*! @{ */
#define DDRC_ADDRMAP11_ADDRMAP_ROW_B10_MASK  (0xFU)
#define DDRC_ADDRMAP11_ADDRMAP_ROW_B10_SHIFT (0U)
/*! addrmap_row_b10 - Selects the HIF address bits used as row address bit 10. Valid Range: 0 to 11
 *    Internal Base: 16 The selected HIF address bit for each of the row address bits is determined
 *    by adding the internal base to the value of this field. This register field is used only when
 *    ADDRMAP5.addrmap_row_b2_10 is set to value 15.
 */
#define DDRC_ADDRMAP11_ADDRMAP_ROW_B10(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ADDRMAP11_ADDRMAP_ROW_B10_SHIFT)) & DDRC_ADDRMAP11_ADDRMAP_ROW_B10_MASK)
/*! @} */

/*! @name ODTCFG - ODT Configuration Register */
/*! @{ */
#define DDRC_ODTCFG_RD_ODT_DELAY_MASK  (0x7CU)
#define DDRC_ODTCFG_RD_ODT_DELAY_SHIFT (2U)
/*! rd_odt_delay - The delay, in DFI PHY clock cycles, from issuing a read command to setting ODT
 *    values associated with that command. ODT setting must remain constant for the entire time that
 *    DQS is driven by the DDRC. Recommended values: DDR2: - CL + AL - 4 (not DDR2-1066), CL + AL - 5
 *    (DDR2-1066) If (CL + AL - 4 < 0), DDRC does not support ODT for read operation. DDR3: - CL -
 *    CWL DDR4: - CL - CWL - RD_PREAMBLE + WR_PREAMBLE + DFITMG1.dfi_t_cmd_lat (to adjust for CAL
 *    mode) WR_PREAMBLE = 1 (1tCK write preamble), 2 (2tCK write preamble) RD_PREAMBLE = 1 (1tCK write
 *    preamble), 2 (2tCK write preamble) If (CL - CWL - RD_PREAMBLE + WR_PREAMBLE) < 0, DDRC does
 *    not support ODT for read operation. LPDDR3: - RL + RD(tDQSCK(min)/tCK) - 1 - RU(tODTon(max)/tCK)
 */
#define DDRC_ODTCFG_RD_ODT_DELAY(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ODTCFG_RD_ODT_DELAY_SHIFT)) & DDRC_ODTCFG_RD_ODT_DELAY_MASK)
#define DDRC_ODTCFG_RD_ODT_HOLD_MASK  (0xF00U)
#define DDRC_ODTCFG_RD_ODT_HOLD_SHIFT (8U)
/*! rd_odt_hold - DFI PHY clock cycles to hold ODT for a read command. The minimum supported value
 *    is 2. Recommended values: DDR2: - BL8: 0x6 (not DDR2-1066), 0x7 (DDR2-1066) - BL4: 0x4 (not
 *    DDR2-1066), 0x5 (DDR2-1066) DDR3: - BL8 - 0x6 DDR4: - BL8: 5 + RD_PREAMBLE RD_PREAMBLE = 1 (1tCK
 *    write preamble), 2 (2tCK write preamble) LPDDR3: - BL8: 5 + RU(tDQSCK(max)/tCK) -
 *    RD(tDQSCK(min)/tCK) + RU(tODTon(max)/tCK)
 */
#define DDRC_ODTCFG_RD_ODT_HOLD(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ODTCFG_RD_ODT_HOLD_SHIFT)) & DDRC_ODTCFG_RD_ODT_HOLD_MASK)
#define DDRC_ODTCFG_WR_ODT_DELAY_MASK  (0x1F0000U)
#define DDRC_ODTCFG_WR_ODT_DELAY_SHIFT (16U)
/*! wr_odt_delay - The delay, in DFI PHY clock cycles, from issuing a write command to setting ODT
 *    values associated with that command. ODT setting must remain constant for the entire time that
 *    DQS is driven by the DDRC. Recommended values: DDR2: - CWL + AL - 3 (DDR2-400/533/667), CWL +
 *    AL - 4 (DDR2-800), CWL + AL - 5 (DDR2-1066) If (CWL + AL - 3 < 0), DDRC does not support ODT
 *    for write operation. DDR3: - 0x0 DDR4: - DFITMG1.dfi_t_cmd_lat (to adjust for CAL mode) LPDDR3:
 *    - WL - 1 - RU(tODTon(max)/tCK))
 */
#define DDRC_ODTCFG_WR_ODT_DELAY(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ODTCFG_WR_ODT_DELAY_SHIFT)) & DDRC_ODTCFG_WR_ODT_DELAY_MASK)
#define DDRC_ODTCFG_WR_ODT_HOLD_MASK  (0xF000000U)
#define DDRC_ODTCFG_WR_ODT_HOLD_SHIFT (24U)
/*! wr_odt_hold - DFI PHY clock cycles to hold ODT for a write command. The minimum supported value
 *    is 2. Recommended values: DDR2: - BL8: 0x5 (DDR2-400/533/667), 0x6 (DDR2-800), 0x7 (DDR2-1066)
 *    - BL4: 0x3 (DDR2-400/533/667), 0x4 (DDR2-800), 0x5 (DDR2-1066) DDR3: - BL8: 0x6 DDR4: - BL8:
 *    5 + WR_PREAMBLE + CRC_MODE WR_PREAMBLE = 1 (1tCK write preamble), 2 (2tCK write preamble)
 *    CRC_MODE = 0 (not CRC mode), 1 (CRC mode) LPDDR3: - BL8: 7 + RU(tODTon(max)/tCK)
 */
#define DDRC_ODTCFG_WR_ODT_HOLD(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ODTCFG_WR_ODT_HOLD_SHIFT)) & DDRC_ODTCFG_WR_ODT_HOLD_MASK)
/*! @} */

/*! @name ODTMAP - ODT/Rank Map Register */
/*! @{ */
#define DDRC_ODTMAP_RANK0_WR_ODT_MASK  (0x3U)
#define DDRC_ODTMAP_RANK0_WR_ODT_SHIFT (0U)
/*! rank0_wr_odt - Indicates which remote ODTs must be turned on during a write to rank 0. Each rank
 *    has a remote ODT (in the SDRAM) which can be turned on by setting the appropriate bit here.
 *    Rank 0 is controlled by the LSB; rank 1 is controlled by bit next to the LSB, etc. For each
 *    rank, set its bit to 1 to enable its ODT.
 */
#define DDRC_ODTMAP_RANK0_WR_ODT(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ODTMAP_RANK0_WR_ODT_SHIFT)) & DDRC_ODTMAP_RANK0_WR_ODT_MASK)
#define DDRC_ODTMAP_RANK0_RD_ODT_MASK  (0x30U)
#define DDRC_ODTMAP_RANK0_RD_ODT_SHIFT (4U)
/*! rank0_rd_odt - Indicates which remote ODTs must be turned on during a read from rank 0. Each
 *    rank has a remote ODT (in the SDRAM) which can be turned on by setting the appropriate bit here.
 *    Rank 0 is controlled by the LSB; rank 1 is controlled by bit next to the LSB, etc. For each
 *    rank, set its bit to 1 to enable its ODT.
 */
#define DDRC_ODTMAP_RANK0_RD_ODT(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ODTMAP_RANK0_RD_ODT_SHIFT)) & DDRC_ODTMAP_RANK0_RD_ODT_MASK)
#define DDRC_ODTMAP_RANK1_WR_ODT_MASK  (0x300U)
#define DDRC_ODTMAP_RANK1_WR_ODT_SHIFT (8U)
/*! rank1_wr_odt - Indicates which remote ODTs must be turned on during a write to rank 1. Each rank
 *    has a remote ODT (in the SDRAM) which can be turned on by setting the appropriate bit here.
 *    Rank 0 is controlled by the LSB; rank 1 is controlled by bit next to the LSB, etc. For each
 *    rank, set its bit to 1 to enable its ODT. Present only in configurations that have 2 or more ranks
 */
#define DDRC_ODTMAP_RANK1_WR_ODT(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ODTMAP_RANK1_WR_ODT_SHIFT)) & DDRC_ODTMAP_RANK1_WR_ODT_MASK)
#define DDRC_ODTMAP_RANK1_RD_ODT_MASK  (0x3000U)
#define DDRC_ODTMAP_RANK1_RD_ODT_SHIFT (12U)
/*! rank1_rd_odt - Indicates which remote ODTs must be turned on during a read from rank 1. Each
 *    rank has a remote ODT (in the SDRAM) which can be turned on by setting the appropriate bit here.
 *    Rank 0 is controlled by the LSB; rank 1 is controlled by bit next to the LSB, etc. For each
 *    rank, set its bit to 1 to enable its ODT. Present only in configurations that have 2 or more
 *    ranks
 */
#define DDRC_ODTMAP_RANK1_RD_ODT(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ODTMAP_RANK1_RD_ODT_SHIFT)) & DDRC_ODTMAP_RANK1_RD_ODT_MASK)
/*! @} */

/*! @name SCHED - Scheduler Control Register */
/*! @{ */
#define DDRC_SCHED_FORCE_LOW_PRI_N_MASK  (0x1U)
#define DDRC_SCHED_FORCE_LOW_PRI_N_SHIFT (0U)
/*! force_low_pri_n - Active low signal. When asserted ('0'), all incoming transactions are forced
 *    to low priority. This implies that all High Priority Read (HPR) and Variable Priority Read
 *    commands (VPR) will be treated as Low Priority Read (LPR) commands. On the write side, all
 *    Variable Priority Write (VPW) commands will be treated as Normal Priority Write (NPW) commands.
 *    Forcing the incoming transactions to low priority implicitly turns off Bypass path for read
 *    commands. FOR PERFORMANCE ONLY.
 */
#define DDRC_SCHED_FORCE_LOW_PRI_N(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_SCHED_FORCE_LOW_PRI_N_SHIFT)) & DDRC_SCHED_FORCE_LOW_PRI_N_MASK)
#define DDRC_SCHED_PREFER_WRITE_MASK  (0x2U)
#define DDRC_SCHED_PREFER_WRITE_SHIFT (1U)
/*! prefer_write - If set then the bank selector prefers writes over reads. FOR DEBUG ONLY.
 */
#define DDRC_SCHED_PREFER_WRITE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_SCHED_PREFER_WRITE_SHIFT)) & DDRC_SCHED_PREFER_WRITE_MASK)
#define DDRC_SCHED_PAGECLOSE_MASK  (0x4U)
#define DDRC_SCHED_PAGECLOSE_SHIFT (2U)
/*! pageclose - If true, bank is kept open only while there are page hit transactions available in
 *    the CAM to that bank. The last read or write command in the CAM with a bank and page hit will
 *    be executed with auto-precharge if SCHED1.pageclose_timer=0. Even if this register set to 1 and
 *    SCHED1.pageclose_timer is set to 0, explicit precharge (and not auto-precharge) may be issued
 *    in some cases where there is a mode switch between Write and Read or between LPR and HPR. The
 *    Read and Write commands that are executed as part of the ECC scrub requests are also executed
 *    without auto-precharge. If false, the bank remains open until there is a need to close it (to
 *    open a different page, or for page timeout or refresh timeout) - also known as open page
 *    policy. The open page policy can be overridden by setting the per-command-autopre bit on the HIF
 *    interface (hif_cmd_autopre). The pageclose feature provids a midway between Open and Close page
 *    policies. FOR PERFORMANCE ONLY.
 */
#define DDRC_SCHED_PAGECLOSE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_SCHED_PAGECLOSE_SHIFT)) & DDRC_SCHED_PAGECLOSE_MASK)
#define DDRC_SCHED_LPR_NUM_ENTRIES_MASK  (0x1F00U)
#define DDRC_SCHED_LPR_NUM_ENTRIES_SHIFT (8U)
/*! lpr_num_entries - Number of entries in the low priority transaction store is this value + 1.
 *    (MEMC_NO_OF_ENTRY - (SCHED.lpr_num_entries + 1)) is the number of entries available for the high
 *    priority transaction store. Setting this to maximum value allocates all entries to low
 *    priority transaction store. Setting this to 0 allocates 1 entry to low priority transaction store and
 *    the rest to high priority transaction store. Note: In ECC configurations, the numbers of
 *    write and low priority read credits issued is one less than in the non-ECC case. One entry each is
 *    reserved in the write and low-priority read CAMs for storing the RMW requests arising out of
 *    single bit error correction RMW operation.
 */
#define DDRC_SCHED_LPR_NUM_ENTRIES(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_SCHED_LPR_NUM_ENTRIES_SHIFT)) & DDRC_SCHED_LPR_NUM_ENTRIES_MASK)
#define DDRC_SCHED_GO2CRITICAL_HYSTERESIS_MASK  (0xFF0000U)
#define DDRC_SCHED_GO2CRITICAL_HYSTERESIS_SHIFT (16U)
/*! go2critical_hysteresis - UNUSED
 */
#define DDRC_SCHED_GO2CRITICAL_HYSTERESIS(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_SCHED_GO2CRITICAL_HYSTERESIS_SHIFT)) & DDRC_SCHED_GO2CRITICAL_HYSTERESIS_MASK)
#define DDRC_SCHED_RDWR_IDLE_GAP_MASK  (0x7F000000U)
#define DDRC_SCHED_RDWR_IDLE_GAP_SHIFT (24U)
/*! rdwr_idle_gap - When the preferred transaction store is empty for these many clock cycles,
 *    switch to the alternate transaction store if it is non-empty. The read transaction store (both high
 *    and low priority) is the default preferred transaction store and the write transaction store
 *    is the alternative store. When prefer write over read is set this is reversed. 0x0 is a legal
 *    value for this register. When set to 0x0, the transaction store switching will happen
 *    immediately when the switching conditions become true. FOR PERFORMANCE ONLY
 */
#define DDRC_SCHED_RDWR_IDLE_GAP(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_SCHED_RDWR_IDLE_GAP_SHIFT)) & DDRC_SCHED_RDWR_IDLE_GAP_MASK)
/*! @} */

/*! @name SCHED1 - Scheduler Control Register 1 */
/*! @{ */
#define DDRC_SCHED1_PAGECLOSE_TIMER_MASK  (0xFFU)
#define DDRC_SCHED1_PAGECLOSE_TIMER_SHIFT (0U)
/*! pageclose_timer - This field works in conjunction with SCHED.pageclose. It only has meaning if
 *    SCHED.pageclose==1. If SCHED.pageclose==1 and pageclose_timer==0, then an auto-precharge may be
 *    scheduled for last read or write command in the CAM with a bank and page hit. Note, sometimes
 *    an explicit precharge is scheduled instead of the auto-precharge. See SCHED.pageclose for
 *    details of when this may happen. If SCHED.pageclose==1 and pageclose_timer>0, then an
 *    auto-precharge is not scheduled for last read or write command in the CAM with a bank and page hit.
 *    Instead, a timer is started, with pageclose_timer as the initial value. There is a timer on a per
 *    bank basis. The timer decrements unless the next read or write in the CAM to a bank is a page
 *    hit. It gets reset to pageclose_timer value if the next read or write in the CAM to a bank is a
 *    page hit. Once the timer has reached zero, an explcit precharge will be attempted to be
 *    scheduled.
 */
#define DDRC_SCHED1_PAGECLOSE_TIMER(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_SCHED1_PAGECLOSE_TIMER_SHIFT)) & DDRC_SCHED1_PAGECLOSE_TIMER_MASK)
/*! @} */

/*! @name PERFHPR1 - High Priority Read CAM Register 1 */
/*! @{ */
#define DDRC_PERFHPR1_HPR_MAX_STARVE_MASK  (0xFFFFU)
#define DDRC_PERFHPR1_HPR_MAX_STARVE_SHIFT (0U)
/*! hpr_max_starve - Number of DFI clocks that the HPR queue can be starved before it goes critical.
 *    The minimum valid functional value for this register is 0x1. Programming it to 0x0 will
 *    disable the starvation functionality; during normal operation, this function should not be disabled
 *    as it will cause excessive latencies. FOR PERFORMANCE ONLY.
 */
#define DDRC_PERFHPR1_HPR_MAX_STARVE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PERFHPR1_HPR_MAX_STARVE_SHIFT)) & DDRC_PERFHPR1_HPR_MAX_STARVE_MASK)
#define DDRC_PERFHPR1_HPR_XACT_RUN_LENGTH_MASK  (0xFF000000U)
#define DDRC_PERFHPR1_HPR_XACT_RUN_LENGTH_SHIFT (24U)
/*! hpr_xact_run_length - Number of transactions that are serviced once the HPR queue goes critical
 *    is the smaller of: - (a) This number - (b) Number of transactions available. Unit:
 *    Transaction. FOR PERFORMANCE ONLY.
 */
#define DDRC_PERFHPR1_HPR_XACT_RUN_LENGTH(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PERFHPR1_HPR_XACT_RUN_LENGTH_SHIFT)) & DDRC_PERFHPR1_HPR_XACT_RUN_LENGTH_MASK)
/*! @} */

/*! @name PERFLPR1 - Low Priority Read CAM Register 1 */
/*! @{ */
#define DDRC_PERFLPR1_LPR_MAX_STARVE_MASK  (0xFFFFU)
#define DDRC_PERFLPR1_LPR_MAX_STARVE_SHIFT (0U)
/*! lpr_max_starve - Number of DFI clocks that the LPR queue can be starved before it goes critical.
 *    The minimum valid functional value for this register is 0x1. Programming it to 0x0 will
 *    disable the starvation functionality; during normal operation, this function should not be disabled
 *    as it will cause excessive latencies. FOR PERFORMANCE ONLY.
 */
#define DDRC_PERFLPR1_LPR_MAX_STARVE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PERFLPR1_LPR_MAX_STARVE_SHIFT)) & DDRC_PERFLPR1_LPR_MAX_STARVE_MASK)
#define DDRC_PERFLPR1_LPR_XACT_RUN_LENGTH_MASK  (0xFF000000U)
#define DDRC_PERFLPR1_LPR_XACT_RUN_LENGTH_SHIFT (24U)
/*! lpr_xact_run_length - Number of transactions that are serviced once the LPR queue goes critical
 *    is the smaller of: - (a) This number - (b) Number of transactions available. Unit:
 *    Transaction. FOR PERFORMANCE ONLY.
 */
#define DDRC_PERFLPR1_LPR_XACT_RUN_LENGTH(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PERFLPR1_LPR_XACT_RUN_LENGTH_SHIFT)) & DDRC_PERFLPR1_LPR_XACT_RUN_LENGTH_MASK)
/*! @} */

/*! @name PERFWR1 - Write CAM Register 1 */
/*! @{ */
#define DDRC_PERFWR1_W_MAX_STARVE_MASK  (0xFFFFU)
#define DDRC_PERFWR1_W_MAX_STARVE_SHIFT (0U)
/*! w_max_starve - Number of DFI clocks that the WR queue can be starved before it goes critical.
 *    The minimum valid functional value for this register is 0x1. Programming it to 0x0 will disable
 *    the starvation functionality; during normal operation, this function should not be disabled as
 *    it will cause excessive latencies. FOR PERFORMANCE ONLY.
 */
#define DDRC_PERFWR1_W_MAX_STARVE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PERFWR1_W_MAX_STARVE_SHIFT)) & DDRC_PERFWR1_W_MAX_STARVE_MASK)
#define DDRC_PERFWR1_W_XACT_RUN_LENGTH_MASK  (0xFF000000U)
#define DDRC_PERFWR1_W_XACT_RUN_LENGTH_SHIFT (24U)
/*! w_xact_run_length - Number of transactions that are serviced once the WR queue goes critical is
 *    the smaller of: - (a) This number - (b) Number of transactions available. Unit: Transaction.
 *    FOR PERFORMANCE ONLY.
 */
#define DDRC_PERFWR1_W_XACT_RUN_LENGTH(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PERFWR1_W_XACT_RUN_LENGTH_SHIFT)) & DDRC_PERFWR1_W_XACT_RUN_LENGTH_MASK)
/*! @} */

/*! @name DBG0 - Debug Register 0 */
/*! @{ */
#define DDRC_DBG0_DIS_WC_MASK  (0x1U)
#define DDRC_DBG0_DIS_WC_SHIFT (0U)
/*! dis_wc - When 1, disable write combine. FOR DEBUG ONLY
 */
#define DDRC_DBG0_DIS_WC(x)           (((uint32_t)(((uint32_t)(x)) << DDRC_DBG0_DIS_WC_SHIFT)) & DDRC_DBG0_DIS_WC_MASK)
#define DDRC_DBG0_DIS_RD_BYPASS_MASK  (0x2U)
#define DDRC_DBG0_DIS_RD_BYPASS_SHIFT (1U)
/*! dis_rd_bypass - Only present in designs supporting read bypass. When 1, disable bypass path for
 *    high priority read page hits FOR DEBUG ONLY.
 */
#define DDRC_DBG0_DIS_RD_BYPASS(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DBG0_DIS_RD_BYPASS_SHIFT)) & DDRC_DBG0_DIS_RD_BYPASS_MASK)
#define DDRC_DBG0_DIS_ACT_BYPASS_MASK  (0x4U)
#define DDRC_DBG0_DIS_ACT_BYPASS_SHIFT (2U)
/*! dis_act_bypass - Only present in designs supporting activate bypass. When 1, disable bypass path
 *    for high priority read activates FOR DEBUG ONLY.
 */
#define DDRC_DBG0_DIS_ACT_BYPASS(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DBG0_DIS_ACT_BYPASS_SHIFT)) & DDRC_DBG0_DIS_ACT_BYPASS_MASK)
#define DDRC_DBG0_DIS_COLLISION_PAGE_OPT_MASK  (0x10U)
#define DDRC_DBG0_DIS_COLLISION_PAGE_OPT_SHIFT (4U)
/*! dis_collision_page_opt - When this is set to '0', auto-precharge is disabled for the flushed
 *    command in a collision case. Collision cases are write followed by read to same address, read
 *    followed by write to same address, or write followed by write to same address with DBG0.dis_wc
 *    bit = 1 (where same address comparisons exclude the two address bits representing critical
 *    word). FOR DEBUG ONLY.
 */
#define DDRC_DBG0_DIS_COLLISION_PAGE_OPT(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DBG0_DIS_COLLISION_PAGE_OPT_SHIFT)) & DDRC_DBG0_DIS_COLLISION_PAGE_OPT_MASK)
/*! @} */

/*! @name DBG1 - Debug Register 1 */
/*! @{ */
#define DDRC_DBG1_DIS_DQ_MASK  (0x1U)
#define DDRC_DBG1_DIS_DQ_SHIFT (0U)
/*! dis_dq - When 1, DDRC will not de-queue any transactions from the CAM. Bypass is also disabled.
 *    All transactions are queued in the CAM. No reads or writes are issued to SDRAM as long as this
 *    is asserted. This bit may be used to prevent reads or writes being issued by the DDRC, which
 *    makes it safe to modify certain register fields associated with reads and writes (see User
 *    Guide for details). After setting this bit, it is strongly recommended to poll
 *    DBGCAM.wr_data_pipeline_empty and DBGCAM.rd_data_pipeline_empty, before making changes to any registers which
 *    affect reads and writes. This will ensure that the relevant logic in the DDRC is idle. This bit
 *    is intended to be switched on-the-fly.
 */
#define DDRC_DBG1_DIS_DQ(x)     (((uint32_t)(((uint32_t)(x)) << DDRC_DBG1_DIS_DQ_SHIFT)) & DDRC_DBG1_DIS_DQ_MASK)
#define DDRC_DBG1_DIS_HIF_MASK  (0x2U)
#define DDRC_DBG1_DIS_HIF_SHIFT (1U)
/*! dis_hif - When 1, DDRC asserts the HIF command signal hif_cmd_stall. DDRC will ignore the
 *    hif_cmd_valid and all other associated request signals. This bit is intended to be switched
 *    on-the-fly.
 */
#define DDRC_DBG1_DIS_HIF(x) (((uint32_t)(((uint32_t)(x)) << DDRC_DBG1_DIS_HIF_SHIFT)) & DDRC_DBG1_DIS_HIF_MASK)
/*! @} */

/*! @name DBGCAM - CAM Debug Register */
/*! @{ */
#define DDRC_DBGCAM_DBG_HPR_Q_DEPTH_MASK  (0x3FU)
#define DDRC_DBGCAM_DBG_HPR_Q_DEPTH_SHIFT (0U)
/*! dbg_hpr_q_depth - High priority read queue depth FOR DEBUG ONLY
 */
#define DDRC_DBGCAM_DBG_HPR_Q_DEPTH(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DBGCAM_DBG_HPR_Q_DEPTH_SHIFT)) & DDRC_DBGCAM_DBG_HPR_Q_DEPTH_MASK)
#define DDRC_DBGCAM_DBG_LPR_Q_DEPTH_MASK  (0x3F00U)
#define DDRC_DBGCAM_DBG_LPR_Q_DEPTH_SHIFT (8U)
/*! dbg_lpr_q_depth - Low priority read queue depth The last entry of Lpr queue is reserved for ECC
 *    SCRUB operation. This entry is not included in the calculation of the queue depth. FOR DEBUG
 *    ONLY
 */
#define DDRC_DBGCAM_DBG_LPR_Q_DEPTH(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DBGCAM_DBG_LPR_Q_DEPTH_SHIFT)) & DDRC_DBGCAM_DBG_LPR_Q_DEPTH_MASK)
#define DDRC_DBGCAM_DBG_W_Q_DEPTH_MASK  (0x3F0000U)
#define DDRC_DBGCAM_DBG_W_Q_DEPTH_SHIFT (16U)
/*! dbg_w_q_depth - Write queue depth The last entry of WR queue is reserved for ECC SCRUB
 *    operation. This entry is not included in the calculation of the queue depth. FOR DEBUG ONLY
 */
#define DDRC_DBGCAM_DBG_W_Q_DEPTH(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DBGCAM_DBG_W_Q_DEPTH_SHIFT)) & DDRC_DBGCAM_DBG_W_Q_DEPTH_MASK)
#define DDRC_DBGCAM_DBG_STALL_MASK  (0x1000000U)
#define DDRC_DBGCAM_DBG_STALL_SHIFT (24U)
/*! dbg_stall - Stall FOR DEBUG ONLY
 */
#define DDRC_DBGCAM_DBG_STALL(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DBGCAM_DBG_STALL_SHIFT)) & DDRC_DBGCAM_DBG_STALL_MASK)
#define DDRC_DBGCAM_DBG_RD_Q_EMPTY_MASK  (0x2000000U)
#define DDRC_DBGCAM_DBG_RD_Q_EMPTY_SHIFT (25U)
/*! dbg_rd_q_empty - When 1, all the Read command queues and Read data buffers inside DDRC are
 *    empty. This register is to be used for debug purpose. An example use-case scenario: When Controller
 *    enters Self-Refresh using the Low-Power entry sequence, Controller is expected to have
 *    executed all the commands in its queues and the write and read data drained. Hence this register
 *    should be 1 at that time. FOR DEBUG ONLY
 */
#define DDRC_DBGCAM_DBG_RD_Q_EMPTY(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DBGCAM_DBG_RD_Q_EMPTY_SHIFT)) & DDRC_DBGCAM_DBG_RD_Q_EMPTY_MASK)
#define DDRC_DBGCAM_DBG_WR_Q_EMPTY_MASK  (0x4000000U)
#define DDRC_DBGCAM_DBG_WR_Q_EMPTY_SHIFT (26U)
/*! dbg_wr_q_empty - When 1, all the Write command queues and Write data buffers inside DDRC are
 *    empty. This register is to be used for debug purpose. An example use-case scenario: When
 *    Controller enters Self-Refresh using the Low-Power entry sequence, Controller is expected to have
 *    executed all the commands in its queues and the write and read data drained. Hence this register
 *    should be 1 at that time. FOR DEBUG ONLY
 */
#define DDRC_DBGCAM_DBG_WR_Q_EMPTY(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DBGCAM_DBG_WR_Q_EMPTY_SHIFT)) & DDRC_DBGCAM_DBG_WR_Q_EMPTY_MASK)
#define DDRC_DBGCAM_RD_DATA_PIPELINE_EMPTY_MASK  (0x10000000U)
#define DDRC_DBGCAM_RD_DATA_PIPELINE_EMPTY_SHIFT (28U)
/*! rd_data_pipeline_empty - This bit indicates that the read data pipeline on the DFI interface is
 *    empty. This register is intended to be polled at least twice after setting DBG1.dis_dq, to
 *    ensure that all remaining commands/data have completed.
 */
#define DDRC_DBGCAM_RD_DATA_PIPELINE_EMPTY(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DBGCAM_RD_DATA_PIPELINE_EMPTY_SHIFT)) & \
     DDRC_DBGCAM_RD_DATA_PIPELINE_EMPTY_MASK)
#define DDRC_DBGCAM_WR_DATA_PIPELINE_EMPTY_MASK  (0x20000000U)
#define DDRC_DBGCAM_WR_DATA_PIPELINE_EMPTY_SHIFT (29U)
/*! wr_data_pipeline_empty - This bit indicates that the write data pipeline on the DFI interface is
 *    empty. This register is intended to be polled at least twice after setting DBG1.dis_dq, to
 *    ensure that all remaining commands/data have completed.
 */
#define DDRC_DBGCAM_WR_DATA_PIPELINE_EMPTY(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DBGCAM_WR_DATA_PIPELINE_EMPTY_SHIFT)) & \
     DDRC_DBGCAM_WR_DATA_PIPELINE_EMPTY_MASK)
#define DDRC_DBGCAM_DBG_STALL_WR_MASK  (0x40000000U)
#define DDRC_DBGCAM_DBG_STALL_WR_SHIFT (30U)
/*! dbg_stall_wr - Stall for Write channel FOR DEBUG ONLY
 */
#define DDRC_DBGCAM_DBG_STALL_WR(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DBGCAM_DBG_STALL_WR_SHIFT)) & DDRC_DBGCAM_DBG_STALL_WR_MASK)
#define DDRC_DBGCAM_DBG_STALL_RD_MASK  (0x80000000U)
#define DDRC_DBGCAM_DBG_STALL_RD_SHIFT (31U)
/*! dbg_stall_rd - Stall for Read channel FOR DEBUG ONLY
 */
#define DDRC_DBGCAM_DBG_STALL_RD(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DBGCAM_DBG_STALL_RD_SHIFT)) & DDRC_DBGCAM_DBG_STALL_RD_MASK)
/*! @} */

/*! @name DBGCMD - Command Debug Register */
/*! @{ */
#define DDRC_DBGCMD_RANK0_REFRESH_MASK  (0x1U)
#define DDRC_DBGCMD_RANK0_REFRESH_SHIFT (0U)
/*! rank0_refresh - Setting this register bit to 1 indicates to the DDRC to issue a refresh to rank
 *    0. Writing to this bit causes DBGSTAT.rank0_refresh_busy to be set. When
 *    DBGSTAT.rank0_refresh_busy is cleared, the command has been stored in DDRC. For 3DS configuration, refresh is sent
 *    to rank index 0. This operation can be performed only when RFSHCTL3.dis_auto_refresh=1. It is
 *    recommended NOT to set this register bit if in Init or Deep power-down operating modes or
 *    Maximum Power Saving Mode.
 */
#define DDRC_DBGCMD_RANK0_REFRESH(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DBGCMD_RANK0_REFRESH_SHIFT)) & DDRC_DBGCMD_RANK0_REFRESH_MASK)
#define DDRC_DBGCMD_RANK1_REFRESH_MASK  (0x2U)
#define DDRC_DBGCMD_RANK1_REFRESH_SHIFT (1U)
/*! rank1_refresh - Setting this register bit to 1 indicates to the DDRC to issue a refresh to rank
 *    1. Writing to this bit causes DBGSTAT.rank1_refresh_busy to be set. When
 *    DBGSTAT.rank1_refresh_busy is cleared, the command has been stored in DDRC. For 3DS configuration, refresh is sent
 *    to rank index 1. This operation can be performed only when RFSHCTL3.dis_auto_refresh=1. It is
 *    recommended NOT to set this register bit if in Init or Deep power-down operating modes or
 *    Maximum Power Saving Mode.
 */
#define DDRC_DBGCMD_RANK1_REFRESH(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DBGCMD_RANK1_REFRESH_SHIFT)) & DDRC_DBGCMD_RANK1_REFRESH_MASK)
#define DDRC_DBGCMD_ZQ_CALIB_SHORT_MASK  (0x10U)
#define DDRC_DBGCMD_ZQ_CALIB_SHORT_SHIFT (4U)
/*! zq_calib_short - Setting this register bit to 1 indicates to the DDRC to issue a ZQCS (ZQ
 *    calibration short)/MPC(ZQ calibration) command to the SDRAM. When this request is stored in the
 *    DDRC, the bit is automatically cleared. This operation can be performed only when
 *    ZQCTL0.dis_auto_zq=1. It is recommended NOT to set this register bit if in Init operating mode. This register
 *    bit is ignored when in Self-Refresh(except LPDDR4) and SR-Powerdown(LPDDR4) and Deep
 *    power-down operating modes and Maximum Power Saving Mode.
 */
#define DDRC_DBGCMD_ZQ_CALIB_SHORT(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DBGCMD_ZQ_CALIB_SHORT_SHIFT)) & DDRC_DBGCMD_ZQ_CALIB_SHORT_MASK)
#define DDRC_DBGCMD_CTRLUPD_MASK  (0x20U)
#define DDRC_DBGCMD_CTRLUPD_SHIFT (5U)
/*! ctrlupd - Setting this register bit to 1 indicates to the DDRC to issue a dfi_ctrlupd_req to the
 *    PHY. When this request is stored in the DDRC, the bit is automatically cleared. This
 *    operation must only be performed when DFIUPD0.dis_auto_ctrlupd=1.
 */
#define DDRC_DBGCMD_CTRLUPD(x) (((uint32_t)(((uint32_t)(x)) << DDRC_DBGCMD_CTRLUPD_SHIFT)) & DDRC_DBGCMD_CTRLUPD_MASK)
/*! @} */

/*! @name DBGSTAT - Status Debug Register */
/*! @{ */
#define DDRC_DBGSTAT_RANK0_REFRESH_BUSY_MASK  (0x1U)
#define DDRC_DBGSTAT_RANK0_REFRESH_BUSY_SHIFT (0U)
/*! rank0_refresh_busy - SoC core may initiate a rank0_refresh operation (refresh operation to rank
 *    0) only if this signal is low. This signal goes high in the clock after DBGCMD.rank0_refresh
 *    is set to one. It goes low when the rank0_refresh operation is stored in the DDRC. It is
 *    recommended not to perform rank0_refresh operations when this signal is high. - 0 - Indicates that
 *    the SoC core can initiate a rank0_refresh operation - 1 - Indicates that rank0_refresh
 *    operation has not been stored yet in the DDRC
 */
#define DDRC_DBGSTAT_RANK0_REFRESH_BUSY(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DBGSTAT_RANK0_REFRESH_BUSY_SHIFT)) & DDRC_DBGSTAT_RANK0_REFRESH_BUSY_MASK)
#define DDRC_DBGSTAT_RANK1_REFRESH_BUSY_MASK  (0x2U)
#define DDRC_DBGSTAT_RANK1_REFRESH_BUSY_SHIFT (1U)
/*! rank1_refresh_busy - SoC core may initiate a rank1_refresh operation (refresh operation to rank
 *    1) only if this signal is low. This signal goes high in the clock after DBGCMD.rank1_refresh
 *    is set to one. It goes low when the rank1_refresh operation is stored in the DDRC. It is
 *    recommended not to perform rank1_refresh operations when this signal is high. - 0 - Indicates that
 *    the SoC core can initiate a rank1_refresh operation - 1 - Indicates that rank1_refresh
 *    operation has not been stored yet in the DDRC
 */
#define DDRC_DBGSTAT_RANK1_REFRESH_BUSY(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DBGSTAT_RANK1_REFRESH_BUSY_SHIFT)) & DDRC_DBGSTAT_RANK1_REFRESH_BUSY_MASK)
#define DDRC_DBGSTAT_ZQ_CALIB_SHORT_BUSY_MASK  (0x10U)
#define DDRC_DBGSTAT_ZQ_CALIB_SHORT_BUSY_SHIFT (4U)
/*! zq_calib_short_busy - SoC core may initiate a ZQCS (ZQ calibration short) operation only if this
 *    signal is low. This signal goes high in the clock after the DDRC accepts the ZQCS request. It
 *    goes low when the ZQCS operation is initiated in the DDRC. It is recommended not to perform
 *    ZQCS operations when this signal is high. - 0 - Indicates that the SoC core can initiate a ZQCS
 *    operation - 1 - Indicates that ZQCS operation has not been initiated yet in the DDRC
 */
#define DDRC_DBGSTAT_ZQ_CALIB_SHORT_BUSY(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DBGSTAT_ZQ_CALIB_SHORT_BUSY_SHIFT)) & DDRC_DBGSTAT_ZQ_CALIB_SHORT_BUSY_MASK)
#define DDRC_DBGSTAT_CTRLUPD_BUSY_MASK  (0x20U)
#define DDRC_DBGSTAT_CTRLUPD_BUSY_SHIFT (5U)
/*! ctrlupd_busy - SoC core may initiate a ctrlupd operation only if this signal is low. This signal
 *    goes high in the clock after the DDRC accepts the ctrlupd request. It goes low when the
 *    ctrlupd operation is initiated in the DDRC. It is recommended not to perform ctrlupd operations
 *    when this signal is high. - 0 - Indicates that the SoC core can initiate a ctrlupd operation - 1
 *    - Indicates that ctrlupd operation has not been initiated yet in the DDRC
 */
#define DDRC_DBGSTAT_CTRLUPD_BUSY(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DBGSTAT_CTRLUPD_BUSY_SHIFT)) & DDRC_DBGSTAT_CTRLUPD_BUSY_MASK)
/*! @} */

/*! @name SWCTL - Software Register Programming Control Enable */
/*! @{ */
#define DDRC_SWCTL_SW_DONE_MASK  (0x1U)
#define DDRC_SWCTL_SW_DONE_SHIFT (0U)
/*! sw_done - Enable quasi-dynamic register programming outside reset. Program register to 0 to
 *    enable quasi-dynamic programming. Set back register to 1 once programming is done.
 */
#define DDRC_SWCTL_SW_DONE(x) (((uint32_t)(((uint32_t)(x)) << DDRC_SWCTL_SW_DONE_SHIFT)) & DDRC_SWCTL_SW_DONE_MASK)
/*! @} */

/*! @name SWSTAT - Software Register Programming Control Status */
/*! @{ */
#define DDRC_SWSTAT_SW_DONE_ACK_MASK  (0x1U)
#define DDRC_SWSTAT_SW_DONE_ACK_SHIFT (0U)
/*! sw_done_ack - Register programming done. This register is the echo of SWCTL.sw_done. Wait for
 *    sw_done value 1 to propagate to sw_done_ack at the end of the programming sequence to ensure
 *    that the correct registers values are propagated to the destination clock domains.
 */
#define DDRC_SWSTAT_SW_DONE_ACK(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_SWSTAT_SW_DONE_ACK_SHIFT)) & DDRC_SWSTAT_SW_DONE_ACK_MASK)
/*! @} */

/*! @name POISONCFG - AXI Poison Configuration Register. */
/*! @{ */
#define DDRC_POISONCFG_WR_POISON_SLVERR_EN_MASK  (0x1U)
#define DDRC_POISONCFG_WR_POISON_SLVERR_EN_SHIFT (0U)
/*! wr_poison_slverr_en - If set to 1, enables SLVERR response for write transaction poisoning
 */
#define DDRC_POISONCFG_WR_POISON_SLVERR_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_POISONCFG_WR_POISON_SLVERR_EN_SHIFT)) & \
     DDRC_POISONCFG_WR_POISON_SLVERR_EN_MASK)
#define DDRC_POISONCFG_WR_POISON_INTR_EN_MASK  (0x10U)
#define DDRC_POISONCFG_WR_POISON_INTR_EN_SHIFT (4U)
/*! wr_poison_intr_en - If set to 1, enables interrupts for write transaction poisoning
 */
#define DDRC_POISONCFG_WR_POISON_INTR_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_POISONCFG_WR_POISON_INTR_EN_SHIFT)) & DDRC_POISONCFG_WR_POISON_INTR_EN_MASK)
#define DDRC_POISONCFG_WR_POISON_INTR_CLR_MASK  (0x100U)
#define DDRC_POISONCFG_WR_POISON_INTR_CLR_SHIFT (8U)
/*! wr_poison_intr_clr - Interrupt clear for write transaction poisoning. Allow 2/3 clock cycles for
 *    correct value to propagate to core logic and clear the interrupts.
 */
#define DDRC_POISONCFG_WR_POISON_INTR_CLR(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_POISONCFG_WR_POISON_INTR_CLR_SHIFT)) & DDRC_POISONCFG_WR_POISON_INTR_CLR_MASK)
#define DDRC_POISONCFG_RD_POISON_SLVERR_EN_MASK  (0x10000U)
#define DDRC_POISONCFG_RD_POISON_SLVERR_EN_SHIFT (16U)
/*! rd_poison_slverr_en - If set to 1, enables SLVERR response for read transaction poisoning
 */
#define DDRC_POISONCFG_RD_POISON_SLVERR_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_POISONCFG_RD_POISON_SLVERR_EN_SHIFT)) & \
     DDRC_POISONCFG_RD_POISON_SLVERR_EN_MASK)
#define DDRC_POISONCFG_RD_POISON_INTR_EN_MASK  (0x100000U)
#define DDRC_POISONCFG_RD_POISON_INTR_EN_SHIFT (20U)
/*! rd_poison_intr_en - If set to 1, enables interrupts for read transaction poisoning
 */
#define DDRC_POISONCFG_RD_POISON_INTR_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_POISONCFG_RD_POISON_INTR_EN_SHIFT)) & DDRC_POISONCFG_RD_POISON_INTR_EN_MASK)
#define DDRC_POISONCFG_RD_POISON_INTR_CLR_MASK  (0x1000000U)
#define DDRC_POISONCFG_RD_POISON_INTR_CLR_SHIFT (24U)
/*! rd_poison_intr_clr - Interrupt clear for read transaction poisoning. Allow 2/3 clock cycles for
 *    correct value to propagate to core logic and clear the interrupts.
 */
#define DDRC_POISONCFG_RD_POISON_INTR_CLR(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_POISONCFG_RD_POISON_INTR_CLR_SHIFT)) & DDRC_POISONCFG_RD_POISON_INTR_CLR_MASK)
/*! @} */

/*! @name POISONSTAT - AXI Poison Status Register */
/*! @{ */
#define DDRC_POISONSTAT_WR_POISON_INTR_0_MASK  (0x1U)
#define DDRC_POISONSTAT_WR_POISON_INTR_0_SHIFT (0U)
/*! wr_poison_intr_0 - Write transaction poisoning error interrupt for port 0. This register is a
 *    APB clock copy (double register synchronizer) of the interrupt asserted when a transaction is
 *    poisoned on the corresponding AXI port's write address channel. Bit 0 corresponds to Port 0, and
 *    so on. Interrupt is cleared by register wr_poison_intr_clr, then value propagated to APB
 *    clock.
 */
#define DDRC_POISONSTAT_WR_POISON_INTR_0(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_POISONSTAT_WR_POISON_INTR_0_SHIFT)) & DDRC_POISONSTAT_WR_POISON_INTR_0_MASK)
#define DDRC_POISONSTAT_RD_POISON_INTR_0_MASK  (0x10000U)
#define DDRC_POISONSTAT_RD_POISON_INTR_0_SHIFT (16U)
/*! rd_poison_intr_0 - Read transaction poisoning error interrupt for port 0. This register is a APB
 *    clock copy (double register synchronizer) of the interrupt asserted when a transaction is
 *    poisoned on the corresponding AXI port's read address channel. Bit 0 corresponds to Port 0, and
 *    so on. Interrupt is cleared by register rd_poison_intr_clr, then value propagated to APB clock.
 */
#define DDRC_POISONSTAT_RD_POISON_INTR_0(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_POISONSTAT_RD_POISON_INTR_0_SHIFT)) & DDRC_POISONSTAT_RD_POISON_INTR_0_MASK)
/*! @} */

/*! @name PSTAT - Port Status Register */
/*! @{ */
#define DDRC_PSTAT_RD_PORT_BUSY_0_MASK  (0x1U)
#define DDRC_PSTAT_RD_PORT_BUSY_0_SHIFT (0U)
/*! rd_port_busy_0 - Indicates if there are outstanding reads for AXI port 0.
 */
#define DDRC_PSTAT_RD_PORT_BUSY_0(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PSTAT_RD_PORT_BUSY_0_SHIFT)) & DDRC_PSTAT_RD_PORT_BUSY_0_MASK)
#define DDRC_PSTAT_WR_PORT_BUSY_0_MASK  (0x10000U)
#define DDRC_PSTAT_WR_PORT_BUSY_0_SHIFT (16U)
/*! wr_port_busy_0 - Indicates if there are outstanding writes for AXI port 0.
 */
#define DDRC_PSTAT_WR_PORT_BUSY_0(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PSTAT_WR_PORT_BUSY_0_SHIFT)) & DDRC_PSTAT_WR_PORT_BUSY_0_MASK)
/*! @} */

/*! @name PCCFG - Port Common Configuration Register */
/*! @{ */
#define DDRC_PCCFG_GO2CRITICAL_EN_MASK  (0x1U)
#define DDRC_PCCFG_GO2CRITICAL_EN_SHIFT (0U)
/*! go2critical_en - If set to 1 (enabled), sets co_gs_go2critical_wr and
 *    co_gs_go2critical_lpr/co_gs_go2critical_hpr signals going to DDRC based on urgent input (awurgent, arurgent)
 * coming from AXI master. If set to 0 (disabled), co_gs_go2critical_wr and co_gs_go2critical_lpr/co_gs_go2critical_hpr
 * signals at DDRC are driven to 1b'0.
 */
#define DDRC_PCCFG_GO2CRITICAL_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PCCFG_GO2CRITICAL_EN_SHIFT)) & DDRC_PCCFG_GO2CRITICAL_EN_MASK)
#define DDRC_PCCFG_PAGEMATCH_LIMIT_MASK  (0x10U)
#define DDRC_PCCFG_PAGEMATCH_LIMIT_SHIFT (4U)
/*! pagematch_limit - Page match four limit. If set to 1, limits the number of consecutive same page
 *    DDRC transactions that can be granted by the Port Arbiter to four when Page Match feature is
 *    enabled. If set to 0, there is no limit imposed on number of consecutive same page DDRC
 *    transactions.
 */
#define DDRC_PCCFG_PAGEMATCH_LIMIT(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PCCFG_PAGEMATCH_LIMIT_SHIFT)) & DDRC_PCCFG_PAGEMATCH_LIMIT_MASK)
#define DDRC_PCCFG_BL_EXP_MODE_MASK  (0x100U)
#define DDRC_PCCFG_BL_EXP_MODE_SHIFT (8U)
/*! bl_exp_mode - Burst length expansion mode. By default (i.e. bl_exp_mode==0) XPI expands every
 *    AXI burst into multiple HIF commands, using the memory burst length as a unit. If set to 1, then
 *    XPI will use half of the memory burst length as a unit. This applies to both reads and
 *    writes. When MSTR.data_bus_width==00, setting bl_exp_mode to 1 has no effect. This can be used in
 *    cases where Partial Writes is enabled (DDRC_PARTIAL_WR=1), in order to avoid or minimize t_ccd_l
 *    penalty in DDR4 and t_ccd_mw penalty in LPDDR4. Hence, bl_exp_mode=1 is only recommended if
 *    DDR4 or LPDDR4. Note that if DBICTL.reg_ddrc_dm_en=0, functionality is not supported in the
 *    following cases: - DDRC_PARTIAL_WR=0 - DDRC_PARTIAL_WR=1, MSTR.data_bus_width=01,
 *    MEMC_BURST_LENGTH=8 and MSTR.burst_rdwr=1000 (LPDDR4 only) - DDRC_PARTIAL_WR=1, MSTR.data_bus_width=01,
 *    MEMC_BURST_LENGTH=4 and MSTR.burst_rdwr=0100 (DDR4 only), with either MSTR.reg_ddrc_burstchop=0 or
 *    CRCPARCTL1.reg_ddrc_crc_enable=1 Functionality is also not supported if Data Channel
 *    Interleave is enabled
 */
#define DDRC_PCCFG_BL_EXP_MODE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PCCFG_BL_EXP_MODE_SHIFT)) & DDRC_PCCFG_BL_EXP_MODE_MASK)
/*! @} */

/*! @name PCFGR_0 - Port n Configuration Read Register */
/*! @{ */
#define DDRC_PCFGR_0_RD_PORT_PRIORITY_MASK  (0x3FFU)
#define DDRC_PCFGR_0_RD_PORT_PRIORITY_SHIFT (0U)
/*! rd_port_priority - Determines the initial load value of read aging counters. These counters will
 *    be parallel loaded after reset, or after each grant to the corresponding port. The aging
 *    counters down-count every clock cycle where the port is requesting but not granted. The higher
 *    significant 5-bits of the read aging counter sets the priority of the read channel of a given
 *    port. Port's priority will increase as the higher significant 5-bits of the counter starts to
 *    decrease. When the aging counter becomes 0, the corresponding port channel will have the highest
 *    priority level (timeout condition - Priority0). For multi-port configurations, the aging
 *    counters cannot be used to set port priorities when external dynamic priority inputs (arqos) are
 *    enabled (timeout is still applicable). For single port configurations, the aging counters are
 *    only used when they timeout (become 0) to force read-write direction switching. In this case,
 *    external dynamic priority input, arqos (for reads only) can still be used to set the DDRC read
 *    priority (2 priority levels: low priority read - LPR, high priority read - HPR) on a command by
 *    command basis. Note: The two LSBs of this register field are tied internally to 2'b00.
 */
#define DDRC_PCFGR_0_RD_PORT_PRIORITY(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PCFGR_0_RD_PORT_PRIORITY_SHIFT)) & DDRC_PCFGR_0_RD_PORT_PRIORITY_MASK)
#define DDRC_PCFGR_0_RD_PORT_AGING_EN_MASK  (0x1000U)
#define DDRC_PCFGR_0_RD_PORT_AGING_EN_SHIFT (12U)
/*! rd_port_aging_en - If set to 1, enables aging function for the read channel of the port.
 */
#define DDRC_PCFGR_0_RD_PORT_AGING_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PCFGR_0_RD_PORT_AGING_EN_SHIFT)) & DDRC_PCFGR_0_RD_PORT_AGING_EN_MASK)
#define DDRC_PCFGR_0_RD_PORT_URGENT_EN_MASK  (0x2000U)
#define DDRC_PCFGR_0_RD_PORT_URGENT_EN_SHIFT (13U)
/*! rd_port_urgent_en - If set to 1, enables the AXI urgent sideband signal (arurgent). When enabled
 *    and arurgent is asserted by the master, that port becomes the highest priority and
 *    co_gs_go2critical_lpr/co_gs_go2critical_hpr signal to DDRC is asserted if enabled in
 *    PCCFG.go2critical_en register. Note that arurgent signal can be asserted anytime and as long as required which is
 *    independent of address handshaking (it is not associated with any particular command).
 */
#define DDRC_PCFGR_0_RD_PORT_URGENT_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PCFGR_0_RD_PORT_URGENT_EN_SHIFT)) & DDRC_PCFGR_0_RD_PORT_URGENT_EN_MASK)
#define DDRC_PCFGR_0_RD_PORT_PAGEMATCH_EN_MASK  (0x4000U)
#define DDRC_PCFGR_0_RD_PORT_PAGEMATCH_EN_SHIFT (14U)
/*! rd_port_pagematch_en - If set to 1, enables the Page Match feature. If enabled, once a
 *    requesting port is granted, the port is continued to be granted if the following immediate commands are
 *    to the same memory page (same bank and same row). See also related PCCFG.pagematch_limit
 *    register.
 */
#define DDRC_PCFGR_0_RD_PORT_PAGEMATCH_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PCFGR_0_RD_PORT_PAGEMATCH_EN_SHIFT)) & DDRC_PCFGR_0_RD_PORT_PAGEMATCH_EN_MASK)
#define DDRC_PCFGR_0_RDWR_ORDERED_EN_MASK  (0x10000U)
#define DDRC_PCFGR_0_RDWR_ORDERED_EN_SHIFT (16U)
/*! rdwr_ordered_en - Enable ordered read/writes. If set to 1, preserves the ordering between read
 *    transaction and write transaction issued to the same address, on a given port. In other words,
 *    the controller ensures that all same address read and write commands from the application port
 *    interface are transported to the DFI interface in the order of acceptance. This feature is
 *    useful in cases where software coherency is desired for masters issuing back-to-back read/write
 *    transactions without waiting for write/read responses. Note that this register has an effect
 *    only if necessary logic is instantiated via the DDRC_RDWR_ORDERED_n parameter.
 */
#define DDRC_PCFGR_0_RDWR_ORDERED_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PCFGR_0_RDWR_ORDERED_EN_SHIFT)) & DDRC_PCFGR_0_RDWR_ORDERED_EN_MASK)
/*! @} */

/*! @name PCFGW_0 - Port n Configuration Write Register */
/*! @{ */
#define DDRC_PCFGW_0_WR_PORT_PRIORITY_MASK  (0x3FFU)
#define DDRC_PCFGW_0_WR_PORT_PRIORITY_SHIFT (0U)
/*! wr_port_priority - Determines the initial load value of write aging counters. These counters
 *    will be parallel loaded after reset, or after each grant to the corresponding port. The aging
 *    counters down-count every clock cycle where the port is requesting but not granted. The higher
 *    significant 5-bits of the write aging counter sets the initial priority of the write channel of
 *    a given port. Port's priority will increase as the higher significant 5-bits of the counter
 *    starts to decrease. When the aging counter becomes 0, the corresponding port channel will have
 *    the highest priority level. For multi-port configurations, the aging counters cannot be used to
 *    set port priorities when external dynamic priority inputs (awqos) are enabled (timeout is
 *    still applicable). For single port configurations, the aging counters are only used when they
 *    timeout (become 0) to force read-write direction switching. Note: The two LSBs of this register
 *    field are tied internally to 2'b00.
 */
#define DDRC_PCFGW_0_WR_PORT_PRIORITY(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PCFGW_0_WR_PORT_PRIORITY_SHIFT)) & DDRC_PCFGW_0_WR_PORT_PRIORITY_MASK)
#define DDRC_PCFGW_0_WR_PORT_AGING_EN_MASK  (0x1000U)
#define DDRC_PCFGW_0_WR_PORT_AGING_EN_SHIFT (12U)
/*! wr_port_aging_en - If set to 1, enables aging function for the write channel of the port.
 */
#define DDRC_PCFGW_0_WR_PORT_AGING_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PCFGW_0_WR_PORT_AGING_EN_SHIFT)) & DDRC_PCFGW_0_WR_PORT_AGING_EN_MASK)
#define DDRC_PCFGW_0_WR_PORT_URGENT_EN_MASK  (0x2000U)
#define DDRC_PCFGW_0_WR_PORT_URGENT_EN_SHIFT (13U)
/*! wr_port_urgent_en - If set to 1, enables the AXI urgent sideband signal (awurgent). When enabled
 *    and awurgent is asserted by the master, that port becomes the highest priority and
 *    co_gs_go2critical_wr signal to DDRC is asserted if enabled in PCCFG.go2critical_en register. Note that
 *    awurgent signal can be asserted anytime and as long as required which is independent of address
 *    handshaking (it is not associated with any particular command).
 */
#define DDRC_PCFGW_0_WR_PORT_URGENT_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PCFGW_0_WR_PORT_URGENT_EN_SHIFT)) & DDRC_PCFGW_0_WR_PORT_URGENT_EN_MASK)
#define DDRC_PCFGW_0_WR_PORT_PAGEMATCH_EN_MASK  (0x4000U)
#define DDRC_PCFGW_0_WR_PORT_PAGEMATCH_EN_SHIFT (14U)
/*! wr_port_pagematch_en - If set to 1, enables the Page Match feature. If enabled, once a
 *    requesting port is granted, the port is continued to be granted if the following immediate commands are
 *    to the same memory page (same bank and same row). See also related PCCFG.pagematch_limit
 *    register.
 */
#define DDRC_PCFGW_0_WR_PORT_PAGEMATCH_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PCFGW_0_WR_PORT_PAGEMATCH_EN_SHIFT)) & DDRC_PCFGW_0_WR_PORT_PAGEMATCH_EN_MASK)
/*! @} */

/*! @name PCTRL_0 - Port n Control Register */
/*! @{ */
#define DDRC_PCTRL_0_PORT_EN_MASK  (0x1U)
#define DDRC_PCTRL_0_PORT_EN_SHIFT (0U)
/*! port_en - Enables AXI port n.
 */
#define DDRC_PCTRL_0_PORT_EN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PCTRL_0_PORT_EN_SHIFT)) & DDRC_PCTRL_0_PORT_EN_MASK)
/*! @} */

/*! @name PCFGQOS0_0 - Port n Read QoS Configuration Register 0 */
/*! @{ */
#define DDRC_PCFGQOS0_0_RQOS_MAP_LEVEL1_MASK  (0xFU)
#define DDRC_PCFGQOS0_0_RQOS_MAP_LEVEL1_SHIFT (0U)
/*! rqos_map_level1 - Separation level1 indicating the end of region0 mapping; start of region0 is
 *    0. Possible values for level1 are 0 to 13 (for dual RAQ) or 0 to 14 (for single RAQ) which
 *    corresponds to arqos. Note that for PA, arqos values are used directly as port priorities, where
 *    the higher the value corresponds to higher port priority. All of the map_level* registers must
 *    be set to distinct values.
 */
#define DDRC_PCFGQOS0_0_RQOS_MAP_LEVEL1(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PCFGQOS0_0_RQOS_MAP_LEVEL1_SHIFT)) & DDRC_PCFGQOS0_0_RQOS_MAP_LEVEL1_MASK)
#define DDRC_PCFGQOS0_0_RQOS_MAP_REGION0_MASK  (0x30000U)
#define DDRC_PCFGQOS0_0_RQOS_MAP_REGION0_SHIFT (16U)
/*! rqos_map_region0 - This bitfield indicates the traffic class of region 0. Valid values are: 0:
 *    LPR, 1: VPR, 2: HPR. For dual address queue configurations, region 0 maps to the blue address
 *    queue. In this case, valid values are: 0: LPR and 1: VPR only. When VPR support is disabled
 *    (DDRC_VPR_EN = 0) and traffic class of region0 is set to 1 (VPR), VPR traffic is aliased to LPR
 *    traffic.
 */
#define DDRC_PCFGQOS0_0_RQOS_MAP_REGION0(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PCFGQOS0_0_RQOS_MAP_REGION0_SHIFT)) & DDRC_PCFGQOS0_0_RQOS_MAP_REGION0_MASK)
#define DDRC_PCFGQOS0_0_RQOS_MAP_REGION1_MASK  (0x300000U)
#define DDRC_PCFGQOS0_0_RQOS_MAP_REGION1_SHIFT (20U)
/*! rqos_map_region1 - This bitfield indicates the traffic class of region 1. Valid values are: 0 :
 *    LPR, 1: VPR, 2: HPR. For dual address queue configurations, region1 maps to the blue address
 *    queue. In this case, valid values are 0: LPR and 1: VPR only. When VPR support is disabled
 *    (DDRC_VPR_EN = 0) and traffic class of region 1 is set to 1 (VPR), VPR traffic is aliased to LPR
 *    traffic.
 */
#define DDRC_PCFGQOS0_0_RQOS_MAP_REGION1(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PCFGQOS0_0_RQOS_MAP_REGION1_SHIFT)) & DDRC_PCFGQOS0_0_RQOS_MAP_REGION1_MASK)
/*! @} */

/*! @name PCFGQOS1_0 - Port n Read QoS Configuration Register 1 */
/*! @{ */
#define DDRC_PCFGQOS1_0_RQOS_MAP_TIMEOUTB_MASK  (0x7FFU)
#define DDRC_PCFGQOS1_0_RQOS_MAP_TIMEOUTB_SHIFT (0U)
/*! rqos_map_timeoutb - Specifies the timeout value for transactions mapped to the blue address queue.
 */
#define DDRC_PCFGQOS1_0_RQOS_MAP_TIMEOUTB(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PCFGQOS1_0_RQOS_MAP_TIMEOUTB_SHIFT)) & DDRC_PCFGQOS1_0_RQOS_MAP_TIMEOUTB_MASK)
#define DDRC_PCFGQOS1_0_RQOS_MAP_TIMEOUTR_MASK  (0x7FF0000U)
#define DDRC_PCFGQOS1_0_RQOS_MAP_TIMEOUTR_SHIFT (16U)
/*! rqos_map_timeoutr - Specifies the timeout value for transactions mapped to the red address queue.
 */
#define DDRC_PCFGQOS1_0_RQOS_MAP_TIMEOUTR(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PCFGQOS1_0_RQOS_MAP_TIMEOUTR_SHIFT)) & DDRC_PCFGQOS1_0_RQOS_MAP_TIMEOUTR_MASK)
/*! @} */

/*! @name PCFGWQOS0_0 - Port n Write QoS Configuration Register 0 */
/*! @{ */
#define DDRC_PCFGWQOS0_0_WQOS_MAP_LEVEL_MASK  (0xFU)
#define DDRC_PCFGWQOS0_0_WQOS_MAP_LEVEL_SHIFT (0U)
/*! wqos_map_level - Separation level indicating the end of region0 mapping; start of region0 is 0.
 *    Possible values for level1 are 0 to 14 which corresponds to awqos. Note that for PA, awqos
 *    values are used directly as port priorities, where the higher the value corresponds to higher
 *    port priority.
 */
#define DDRC_PCFGWQOS0_0_WQOS_MAP_LEVEL(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PCFGWQOS0_0_WQOS_MAP_LEVEL_SHIFT)) & DDRC_PCFGWQOS0_0_WQOS_MAP_LEVEL_MASK)
#define DDRC_PCFGWQOS0_0_WQOS_MAP_REGION0_MASK  (0x30000U)
#define DDRC_PCFGWQOS0_0_WQOS_MAP_REGION0_SHIFT (16U)
/*! wqos_map_region0 - This bitfield indicates the traffic class of region 0. Valid values are: 0:
 *    NPW, 1: VPW. When VPW support is disabled (DDRC_VPW_EN = 0) and traffic class of region0 is set
 *    to 1 (VPW), VPW traffic is aliased to NPW traffic.
 */
#define DDRC_PCFGWQOS0_0_WQOS_MAP_REGION0(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PCFGWQOS0_0_WQOS_MAP_REGION0_SHIFT)) & DDRC_PCFGWQOS0_0_WQOS_MAP_REGION0_MASK)
#define DDRC_PCFGWQOS0_0_WQOS_MAP_REGION1_MASK  (0x300000U)
#define DDRC_PCFGWQOS0_0_WQOS_MAP_REGION1_SHIFT (20U)
/*! wqos_map_region1 - This bitfield indicates the traffic class of region 1. Valid values are: 0:
 *    NPW, 1: VPW. When VPW support is disabled (DDRC_VPW_EN = 0) and traffic class of region 1 is
 *    set to 1 (VPW), VPW traffic is aliased to LPW traffic.
 */
#define DDRC_PCFGWQOS0_0_WQOS_MAP_REGION1(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PCFGWQOS0_0_WQOS_MAP_REGION1_SHIFT)) & DDRC_PCFGWQOS0_0_WQOS_MAP_REGION1_MASK)
/*! @} */

/*! @name PCFGWQOS1_0 - Port n Write QoS Configuration Register 1 */
/*! @{ */
#define DDRC_PCFGWQOS1_0_WQOS_MAP_TIMEOUT_MASK  (0x7FFU)
#define DDRC_PCFGWQOS1_0_WQOS_MAP_TIMEOUT_SHIFT (0U)
/*! wqos_map_timeout - Specifies the timeout value for write transactions.
 */
#define DDRC_PCFGWQOS1_0_WQOS_MAP_TIMEOUT(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_PCFGWQOS1_0_WQOS_MAP_TIMEOUT_SHIFT)) & DDRC_PCFGWQOS1_0_WQOS_MAP_TIMEOUT_MASK)
/*! @} */

/*! @name DERATEEN_SHADOW - [SHADOW] Temperature Derate Enable Register */
/*! @{ */
#define DDRC_DERATEEN_SHADOW_DERATE_ENABLE_MASK  (0x1U)
#define DDRC_DERATEEN_SHADOW_DERATE_ENABLE_SHIFT (0U)
/*! derate_enable - Enables derating - 0 - Timing parameter derating is disabled - 1 - Timing
 *    parameter derating is enabled using MR4 read value. Present only in designs configured to support
 *    LPDDR2/LPDDR3/LPDDR4 This field must be set to '0' for non-LPDDR2/LPDDR3/LPDDR4 mode.
 */
#define DDRC_DERATEEN_SHADOW_DERATE_ENABLE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DERATEEN_SHADOW_DERATE_ENABLE_SHIFT)) & \
     DDRC_DERATEEN_SHADOW_DERATE_ENABLE_MASK)
#define DDRC_DERATEEN_SHADOW_DERATE_VALUE_MASK  (0x2U)
#define DDRC_DERATEEN_SHADOW_DERATE_VALUE_SHIFT (1U)
/*! derate_value - Derate value - 0 - Derating uses +1. - 1 - Derating uses +2. Present only in
 *    designs configured to support LPDDR2/LPDDR3/LPDDR4 Set to 0 for all LPDDR2 speed grades as
 *    derating value of +1.875 ns is less than a core_ddrc_core_clk period. For LPDDR3/4, if the period of
 *    core_ddrc_core_clk is less than 1.875ns, this register field should be set to 1; otherwise it
 *    should be set to 0.
 */
#define DDRC_DERATEEN_SHADOW_DERATE_VALUE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DERATEEN_SHADOW_DERATE_VALUE_SHIFT)) & DDRC_DERATEEN_SHADOW_DERATE_VALUE_MASK)
#define DDRC_DERATEEN_SHADOW_DERATE_BYTE_MASK  (0xF0U)
#define DDRC_DERATEEN_SHADOW_DERATE_BYTE_SHIFT (4U)
/*! derate_byte - Derate byte Present only in designs configured to support LPDDR2/LPDDR3/LPDDR4
 *    Indicates which byte of the MRR data is used for derating. The maximum valid value depends on
 *    MEMC_DRAM_TOTAL_DATA_WIDTH.
 */
#define DDRC_DERATEEN_SHADOW_DERATE_BYTE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DERATEEN_SHADOW_DERATE_BYTE_SHIFT)) & DDRC_DERATEEN_SHADOW_DERATE_BYTE_MASK)
#define DDRC_DERATEEN_SHADOW_RC_DERATE_VALUE_MASK  (0x300U)
#define DDRC_DERATEEN_SHADOW_RC_DERATE_VALUE_SHIFT (8U)
/*! rc_derate_value - Derate value of tRC for LPDDR4 - 0 - Derating uses +1. - 1 - Derating uses +2.
 *    - 2 - Derating uses +3. - 3 - Derating uses +4. Present only in designs configured to support
 *    LPDDR4. The required number of cycles for derating can be determined by dividing 3.75ns by
 *    the core_ddrc_core_clk period, and rounding up the next integer.
 */
#define DDRC_DERATEEN_SHADOW_RC_DERATE_VALUE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DERATEEN_SHADOW_RC_DERATE_VALUE_SHIFT)) & \
     DDRC_DERATEEN_SHADOW_RC_DERATE_VALUE_MASK)
/*! @} */

/*! @name DERATEINT_SHADOW - [SHADOW] Temperature Derate Interval Register */
/*! @{ */
#define DDRC_DERATEINT_SHADOW_MR4_READ_INTERVAL_MASK  (0xFFFFFFFFU)
#define DDRC_DERATEINT_SHADOW_MR4_READ_INTERVAL_SHIFT (0U)
/*! mr4_read_interval - Interval between two MR4 reads, used to derate the timing parameters.
 *    Present only in designs configured to support LPDDR2/LPDDR3/LPDDR4. This register must not be set to
 *    zero. Unit: DFI clock cycle.
 */
#define DDRC_DERATEINT_SHADOW_MR4_READ_INTERVAL(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DERATEINT_SHADOW_MR4_READ_INTERVAL_SHIFT)) & \
     DDRC_DERATEINT_SHADOW_MR4_READ_INTERVAL_MASK)
/*! @} */

/*! @name RFSHCTL0_SHADOW - [SHADOW] Refresh Control Register 0 */
/*! @{ */
#define DDRC_RFSHCTL0_SHADOW_PER_BANK_REFRESH_MASK  (0x4U)
#define DDRC_RFSHCTL0_SHADOW_PER_BANK_REFRESH_SHIFT (2U)
/*! per_bank_refresh - - 1 - Per bank refresh; - 0 - All bank refresh. Per bank refresh allows
 *    traffic to flow to other banks. Per bank refresh is not supported by all LPDDR2 devices but should
 *    be supported by all LPDDR3/LPDDR4 devices. Present only in designs configured to support
 *    LPDDR2/LPDDR3/LPDDR4
 */
#define DDRC_RFSHCTL0_SHADOW_PER_BANK_REFRESH(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_RFSHCTL0_SHADOW_PER_BANK_REFRESH_SHIFT)) & \
     DDRC_RFSHCTL0_SHADOW_PER_BANK_REFRESH_MASK)
#define DDRC_RFSHCTL0_SHADOW_REFRESH_BURST_MASK  (0x1F0U)
#define DDRC_RFSHCTL0_SHADOW_REFRESH_BURST_SHIFT (4U)
/*! refresh_burst - The programmed value + 1 is the number of refresh timeouts that is allowed to
 *    accumulate before traffic is blocked and the refreshes are forced to execute. Closing pages to
 *    perform a refresh is a one-time penalty that must be paid for each group of refreshes.
 *    Therefore, performing refreshes in a burst reduces the per-refresh penalty of these page closings.
 *    Higher numbers for RFSHCTL.refresh_burst slightly increases utilization; lower numbers decreases
 *    the worst-case latency associated with refreshes. - 0 - single refresh - 1 - burst-of-2
 *    refresh - 7 - burst-of-8 refresh For information on burst refresh feature refer to section 3.9 of
 *    DDR2 JEDEC specification - JESD79-2F.pdf. For DDR2/3, the refresh is always per-rank and not
 *    per-bank. The rank refresh can be accumulated over 8*tREFI cycles using the burst refresh
 *    feature. In DDR4 mode, according to Fine Granularity feature, 8 refreshes can be postponed in 1X
 *    mode, 16 refreshes in 2X mode and 32 refreshes in 4X mode. If using PHY-initiated updates, care
 *    must be taken in the setting of RFSHCTL0.refresh_burst, to ensure that tRFCmax is not violated
 *    due to a PHY-initiated update occurring shortly before a refresh burst was due. In this
 *    situation, the refresh burst will be delayed until the PHY-initiated update is complete.
 */
#define DDRC_RFSHCTL0_SHADOW_REFRESH_BURST(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_RFSHCTL0_SHADOW_REFRESH_BURST_SHIFT)) & \
     DDRC_RFSHCTL0_SHADOW_REFRESH_BURST_MASK)
#define DDRC_RFSHCTL0_SHADOW_REFRESH_TO_X32_MASK  (0x1F000U)
#define DDRC_RFSHCTL0_SHADOW_REFRESH_TO_X32_SHIFT (12U)
/*! refresh_to_x32 - If the refresh timer (tRFCnom, also known as tREFI) has expired at least once,
 *    but it has not expired (RFSHCTL0.refresh_burst+1) times yet, then a speculative refresh may be
 *    performed. A speculative refresh is a refresh performed at a time when refresh would be
 *    useful, but before it is absolutely required. When the SDRAM bus is idle for a period of time
 *    determined by this RFSHCTL0.refresh_to_x32 and the refresh timer has expired at least once since
 *    the last refresh, then a speculative refresh is performed. Speculative refreshes continues
 *    successively until there are no refreshes pending or until new reads or writes are issued to the
 *    DDRC. FOR PERFORMANCE ONLY. Unit: Multiples of 32 DFI clocks.
 */
#define DDRC_RFSHCTL0_SHADOW_REFRESH_TO_X32(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_RFSHCTL0_SHADOW_REFRESH_TO_X32_SHIFT)) & \
     DDRC_RFSHCTL0_SHADOW_REFRESH_TO_X32_MASK)
#define DDRC_RFSHCTL0_SHADOW_REFRESH_MARGIN_MASK  (0xF00000U)
#define DDRC_RFSHCTL0_SHADOW_REFRESH_MARGIN_SHIFT (20U)
/*! refresh_margin - Threshold value in number of DFI clock cycles before the critical refresh or
 *    page timer expires. A critical refresh is to be issued before this threshold is reached. It is
 *    recommended that this not be changed from the default value, currently shown as 0x2. It must
 *    always be less than internally used t_rfc_nom_x32. Note that, in LPDDR2/LPDDR3/LPDDR4,
 *    internally used t_rfc_nom_x32 may be equal to RFSHTMG.t_rfc_nom_x32>>2 if derating is enabled
 *    (DERATEEN.derate_enable=1). Otherwise, internally used t_rfc_nom_x32 will be equal to
 *    RFSHTMG.t_rfc_nom_x32. Unit: Multiples of 32 DFI clocks.
 */
#define DDRC_RFSHCTL0_SHADOW_REFRESH_MARGIN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_RFSHCTL0_SHADOW_REFRESH_MARGIN_SHIFT)) & \
     DDRC_RFSHCTL0_SHADOW_REFRESH_MARGIN_MASK)
/*! @} */

/*! @name RFSHTMG_SHADOW - [SHADOW] Refresh Timing Register */
/*! @{ */
#define DDRC_RFSHTMG_SHADOW_T_RFC_MIN_MASK  (0x3FFU)
#define DDRC_RFSHTMG_SHADOW_T_RFC_MIN_SHIFT (0U)
/*! t_rfc_min - tRFC (min): Minimum time from refresh to refresh or activate. When the controller is
 *    operating in 1:1 mode, t_rfc_min should be set to RoundUp(tRFCmin/tCK). When the controller
 *    is operating in 1:2 mode, t_rfc_min should be set to RoundUp(RoundUp(tRFCmin/tCK)/2). In
 *    LPDDR2/LPDDR3/LPDDR4 mode: - if using all-bank refreshes, the tRFCmin value in the above equations
 *    is equal to tRFCab - if using per-bank refreshes, the tRFCmin value in the above equations is
 *    equal to tRFCpb In DDR4 mode, the tRFCmin value in the above equations is different depending
 *    on the refresh mode (fixed 1X,2X,4X) and the device density. The user should program the
 *    appropriate value from the spec based on the 'refresh_mode' and the device density that is used.
 *    Unit: Clocks.
 */
#define DDRC_RFSHTMG_SHADOW_T_RFC_MIN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_RFSHTMG_SHADOW_T_RFC_MIN_SHIFT)) & DDRC_RFSHTMG_SHADOW_T_RFC_MIN_MASK)
#define DDRC_RFSHTMG_SHADOW_LPDDR3_TREFBW_EN_MASK  (0x8000U)
#define DDRC_RFSHTMG_SHADOW_LPDDR3_TREFBW_EN_SHIFT (15U)
/*! lpddr3_trefbw_en - Used only when LPDDR3 memory type is connected. Should only be changed when
 *    DDRC is in reset. Specifies whether to use the tREFBW parameter (required by some LPDDR3
 *    devices which comply with earlier versions of the LPDDR3 JEDEC specification) or not: - 0 - tREFBW
 *    parameter not used - 1 - tREFBW parameter used
 */
#define DDRC_RFSHTMG_SHADOW_LPDDR3_TREFBW_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_RFSHTMG_SHADOW_LPDDR3_TREFBW_EN_SHIFT)) & \
     DDRC_RFSHTMG_SHADOW_LPDDR3_TREFBW_EN_MASK)
#define DDRC_RFSHTMG_SHADOW_T_RFC_NOM_X32_MASK  (0xFFF0000U)
#define DDRC_RFSHTMG_SHADOW_T_RFC_NOM_X32_SHIFT (16U)
/*! t_rfc_nom_x32 - tREFI: Average time interval between refreshes per rank (Specification: 7.8us
 *    for DDR2, DDR3 and DDR4. See JEDEC specification for mDDR, LPDDR2, LPDDR3 and LPDDR4). For
 *    LPDDR2/LPDDR3/LPDDR4: - if using all-bank refreshes (RFSHCTL0.per_bank_refresh = 0), this register
 *    should be set to tREFIab - if using per-bank refreshes (RFSHCTL0.per_bank_refresh = 1), this
 *    register should be set to tREFIpb When the controller is operating in 1:2 frequency ratio mode,
 *    program this to (tREFI/2), no rounding up. In DDR4 mode, tREFI value is different depending
 *    on the refresh mode. The user should program the appropriate value from the spec based on the
 *    value programmed in the refresh mode register. Note that RFSHTMG.t_rfc_nom_x32 * 32 must be
 *    greater than RFSHTMG.t_rfc_min, and RFSHTMG.t_rfc_nom_x32 must be greater than 0x1. - Non-DDR4 or
 *    DDR4 Fixed 1x mode: RFSHTMG.t_rfc_nom_x32 must be less than or equal to 0xFFE. - DDR4 Fixed
 *    2x mode: RFSHTMG.t_rfc_nom_x32 must be less than or equal to 0x7FF. - DDR4 Fixed 4x mode:
 *    RFSHTMG.t_rfc_nom_x32 must be less than or equal to 0x3FF. Unit: Multiples of 32 clocks.
 */
#define DDRC_RFSHTMG_SHADOW_T_RFC_NOM_X32(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_RFSHTMG_SHADOW_T_RFC_NOM_X32_SHIFT)) & DDRC_RFSHTMG_SHADOW_T_RFC_NOM_X32_MASK)
/*! @} */

/*! @name INIT3_SHADOW - [SHADOW] SDRAM Initialization Register 3 */
/*! @{ */
#define DDRC_INIT3_SHADOW_EMR_MASK  (0xFFFFU)
#define DDRC_INIT3_SHADOW_EMR_SHIFT (0U)
/*! emr - DDR2: Value to write to EMR register. Bits 9:7 are for OCD and the setting in this
 *    register is ignored. The DDRC sets those bits appropriately. DDR3/DDR4: Value to write to MR1
 *    register Set bit 7 to 0. If PHY-evaluation mode training is enabled, this bit is set appropriately by
 *    the DDRC during write leveling. mDDR: Value to write to EMR register. LPDDR2/LPDDR3/LPDDR4 -
 *    Value to write to MR2 register
 */
#define DDRC_INIT3_SHADOW_EMR(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_INIT3_SHADOW_EMR_SHIFT)) & DDRC_INIT3_SHADOW_EMR_MASK)
#define DDRC_INIT3_SHADOW_MR_MASK  (0xFFFF0000U)
#define DDRC_INIT3_SHADOW_MR_SHIFT (16U)
/*! mr - DDR2: Value to write to MR register. Bit 8 is for DLL and the setting here is ignored. The
 *    DDRC sets this bit appropriately. DDR3/DDR4: Value loaded into MR0 register. mDDR: Value to
 *    write to MR register. LPDDR2/LPDDR3/LPDDR4 - Value to write to MR1 register
 */
#define DDRC_INIT3_SHADOW_MR(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_INIT3_SHADOW_MR_SHIFT)) & DDRC_INIT3_SHADOW_MR_MASK)
/*! @} */

/*! @name INIT4_SHADOW - [SHADOW] SDRAM Initialization Register 4 */
/*! @{ */
#define DDRC_INIT4_SHADOW_EMR3_MASK  (0xFFFFU)
#define DDRC_INIT4_SHADOW_EMR3_SHIFT (0U)
/*! emr3 - DDR2: Value to write to EMR3 register. DDR3/DDR4: Value to write to MR3 register
 *    mDDR/LPDDR2/LPDDR3: Unused LPDDR4: Value to write to MR13 register
 */
#define DDRC_INIT4_SHADOW_EMR3(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_INIT4_SHADOW_EMR3_SHIFT)) & DDRC_INIT4_SHADOW_EMR3_MASK)
#define DDRC_INIT4_SHADOW_EMR2_MASK  (0xFFFF0000U)
#define DDRC_INIT4_SHADOW_EMR2_SHIFT (16U)
/*! emr2 - DDR2: Value to write to EMR2 register. DDR3/DDR4: Value to write to MR2 register
 *    LPDDR2/LPDDR3/LPDDR4: Value to write to MR3 register mDDR: Unused
 */
#define DDRC_INIT4_SHADOW_EMR2(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_INIT4_SHADOW_EMR2_SHIFT)) & DDRC_INIT4_SHADOW_EMR2_MASK)
/*! @} */

/*! @name INIT6_SHADOW - [SHADOW] SDRAM Initialization Register 6 */
/*! @{ */
#define DDRC_INIT6_SHADOW_MR5_MASK  (0xFFFFU)
#define DDRC_INIT6_SHADOW_MR5_SHIFT (0U)
/*! mr5 - DDR4- Value to be loaded into SDRAM MR5 registers. Used in DDR4 designs only.
 */
#define DDRC_INIT6_SHADOW_MR5(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_INIT6_SHADOW_MR5_SHIFT)) & DDRC_INIT6_SHADOW_MR5_MASK)
#define DDRC_INIT6_SHADOW_MR4_MASK  (0xFFFF0000U)
#define DDRC_INIT6_SHADOW_MR4_SHIFT (16U)
/*! mr4 - DDR4- Value to be loaded into SDRAM MR4 registers. Used in DDR4 designs only.
 */
#define DDRC_INIT6_SHADOW_MR4(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_INIT6_SHADOW_MR4_SHIFT)) & DDRC_INIT6_SHADOW_MR4_MASK)
/*! @} */

/*! @name INIT7_SHADOW - [SHADOW] SDRAM Initialization Register 7 */
/*! @{ */
#define DDRC_INIT7_SHADOW_MR6_MASK  (0xFFFF0000U)
#define DDRC_INIT7_SHADOW_MR6_SHIFT (16U)
/*! mr6 - DDR4- Value to be loaded into SDRAM MR6 registers. Used in DDR4 designs only.
 */
#define DDRC_INIT7_SHADOW_MR6(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_INIT7_SHADOW_MR6_SHIFT)) & DDRC_INIT7_SHADOW_MR6_MASK)
/*! @} */

/*! @name DRAMTMG0_SHADOW - [SHADOW] SDRAM Timing Register 0 */
/*! @{ */
#define DDRC_DRAMTMG0_SHADOW_T_RAS_MIN_MASK  (0x3FU)
#define DDRC_DRAMTMG0_SHADOW_T_RAS_MIN_SHIFT (0U)
/*! t_ras_min - tRAS(min): Minimum time between activate and precharge to the same bank. When the
 *    controller is operating in 1:2 frequency mode, 1T mode, program this to tRAS(min)/2. No rounding
 *    up. When the controller is operating in 1:2 frequency ratio mode, 2T mode or LPDDR4 mode,
 *    program this to (tRAS(min)/2) and round it up to the next integer value. Unit: Clocks
 */
#define DDRC_DRAMTMG0_SHADOW_T_RAS_MIN(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG0_SHADOW_T_RAS_MIN_SHIFT)) & DDRC_DRAMTMG0_SHADOW_T_RAS_MIN_MASK)
#define DDRC_DRAMTMG0_SHADOW_T_RAS_MAX_MASK  (0x7F00U)
#define DDRC_DRAMTMG0_SHADOW_T_RAS_MAX_SHIFT (8U)
/*! t_ras_max - tRAS(max): Maximum time between activate and precharge to same bank. This is the
 *    maximum time that a page can be kept open Minimum value of this register is 1. Zero is invalid.
 *    When the controller is operating in 1:2 frequency ratio mode, program this to (tRAS(max)-1)/2.
 *    No rounding up. Unit: Multiples of 1024 clocks.
 */
#define DDRC_DRAMTMG0_SHADOW_T_RAS_MAX(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG0_SHADOW_T_RAS_MAX_SHIFT)) & DDRC_DRAMTMG0_SHADOW_T_RAS_MAX_MASK)
#define DDRC_DRAMTMG0_SHADOW_T_FAW_MASK  (0x3F0000U)
#define DDRC_DRAMTMG0_SHADOW_T_FAW_SHIFT (16U)
/*! t_faw - tFAW Valid only when 8 or more banks(or banks x bank groups) are present. In 8-bank
 *    design, at most 4 banks must be activated in a rolling window of tFAW cycles. When the controller
 *    is operating in 1:2 frequency ratio mode, program this to (tFAW/2) and round up to next
 *    integer value. In a 4-bank design, set this register to 0x1 independent of the 1:1/1:2 frequency
 *    mode. Unit: Clocks
 */
#define DDRC_DRAMTMG0_SHADOW_T_FAW(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG0_SHADOW_T_FAW_SHIFT)) & DDRC_DRAMTMG0_SHADOW_T_FAW_MASK)
#define DDRC_DRAMTMG0_SHADOW_WR2PRE_MASK  (0x7F000000U)
#define DDRC_DRAMTMG0_SHADOW_WR2PRE_SHIFT (24U)
/*! wr2pre - Minimum time between write and precharge to same bank. Unit: Clocks Specifications: WL
 *    + BL/2 + tWR = approximately 8 cycles + 15 ns = 14 clocks @400MHz and less for lower
 *    frequencies where: - WL = write latency - BL = burst length. This must match the value programmed in
 *    the BL bit of the mode register to the SDRAM. BST (burst terminate) is not supported at present.
 *    - tWR = Write recovery time. This comes directly from the SDRAM specification. Add one extra
 *    cycle for LPDDR2/LPDDR3/LPDDR4 for this parameter. When the controller is operating in 1:2
 *    frequency ratio mode, 1T mode, divide the above value by 2. No rounding up. When the controller
 *    is operating in 1:2 frequency ratio mode, 2T mode or LPDDR4 mode, divide the above value by 2
 *    and round it up to the next integer value. Note that, depending on the PHY, if using LRDIMM, it
 *    may be necessary to adjust the value of this parameter to compensate for the extra cycle of
 *    latency through the LRDIMM.
 */
#define DDRC_DRAMTMG0_SHADOW_WR2PRE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG0_SHADOW_WR2PRE_SHIFT)) & DDRC_DRAMTMG0_SHADOW_WR2PRE_MASK)
/*! @} */

/*! @name DRAMTMG1_SHADOW - [SHADOW] SDRAM Timing Register 1 */
/*! @{ */
#define DDRC_DRAMTMG1_SHADOW_T_RC_MASK  (0x7FU)
#define DDRC_DRAMTMG1_SHADOW_T_RC_SHIFT (0U)
/*! t_rc - tRC: Minimum time between activates to same bank. When the controller is operating in 1:2
 *    frequency ratio mode, program this to (tRC/2) and round up to next integer value. Unit:
 *    Clocks.
 */
#define DDRC_DRAMTMG1_SHADOW_T_RC(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG1_SHADOW_T_RC_SHIFT)) & DDRC_DRAMTMG1_SHADOW_T_RC_MASK)
#define DDRC_DRAMTMG1_SHADOW_RD2PRE_MASK  (0x3F00U)
#define DDRC_DRAMTMG1_SHADOW_RD2PRE_SHIFT (8U)
/*! rd2pre - tRTP: Minimum time from read to precharge of same bank. - DDR2: tAL + BL/2 + max(tRTP,
 *    2) - 2 - DDR3: tAL + max (tRTP, 4) - DDR4: Max of following two equations: tAL + max (tRTP, 4)
 *    or, RL + BL/2 - tRP (*). - mDDR: BL/2 - LPDDR2: Depends on if it's LPDDR2-S2 or LPDDR2-S4:
 *    LPDDR2-S2: BL/2 + tRTP - 1. LPDDR2-S4: BL/2 + max(tRTP,2) - 2. - LPDDR3: BL/2 + max(tRTP,4) - 4
 *    - LPDDR4: BL/2 + max(tRTP,8) - 8 (*) When both DDR4 SDRAM and ST-MRAM are used simultaneously,
 *    use SDRAM's tRP value for calculation. When the controller is operating in 1:2 mode, 1T mode,
 *    divide the above value by 2. No rounding up. When the controller is operating in 1:2 mode, 2T
 *    mode or LPDDR4 mode, divide the above value by 2 and round it up to the next integer value.
 *    Unit: Clocks.
 */
#define DDRC_DRAMTMG1_SHADOW_RD2PRE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG1_SHADOW_RD2PRE_SHIFT)) & DDRC_DRAMTMG1_SHADOW_RD2PRE_MASK)
#define DDRC_DRAMTMG1_SHADOW_T_XP_MASK  (0x1F0000U)
#define DDRC_DRAMTMG1_SHADOW_T_XP_SHIFT (16U)
/*! t_xp - tXP: Minimum time after power-down exit to any operation. For DDR3, this should be
 *    programmed to tXPDLL if slow powerdown exit is selected in MR0[12]. If C/A parity for DDR4 is used,
 *    set to (tXP+PL) instead. When the controller is operating in 1:2 frequency ratio mode, program
 *    this to (tXP/2) and round it up to the next integer value. Units: Clocks
 */
#define DDRC_DRAMTMG1_SHADOW_T_XP(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG1_SHADOW_T_XP_SHIFT)) & DDRC_DRAMTMG1_SHADOW_T_XP_MASK)
/*! @} */

/*! @name DRAMTMG2_SHADOW - [SHADOW] SDRAM Timing Register 2 */
/*! @{ */
#define DDRC_DRAMTMG2_SHADOW_WR2RD_MASK  (0x3FU)
#define DDRC_DRAMTMG2_SHADOW_WR2RD_SHIFT (0U)
/*! wr2rd - DDR4: CWL + PL + BL/2 + tWTR_L Others: CWL + BL/2 + tWTR In DDR4, minimum time from
 *    write command to read command for same bank group. In others, minimum time from write command to
 *    read command. Includes time for bus turnaround, recovery times, and all per-bank, per-rank, and
 *    global constraints. Unit: Clocks. Where: - CWL = CAS write latency - PL = Parity latency - BL
 *    = burst length. This must match the value programmed in the BL bit of the mode register to
 *    the SDRAM - tWTR_L = internal write to read command delay for same bank group. This comes
 *    directly from the SDRAM specification. - tWTR = internal write to read command delay. This comes
 *    directly from the SDRAM specification. Add one extra cycle for LPDDR2/LPDDR3/LPDDR4 operation.
 *    When the controller is operating in 1:2 mode, divide the value calculated using the above
 *    equation by 2, and round it up to next integer.
 */
#define DDRC_DRAMTMG2_SHADOW_WR2RD(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG2_SHADOW_WR2RD_SHIFT)) & DDRC_DRAMTMG2_SHADOW_WR2RD_MASK)
#define DDRC_DRAMTMG2_SHADOW_RD2WR_MASK  (0x3F00U)
#define DDRC_DRAMTMG2_SHADOW_RD2WR_SHIFT (8U)
/*! rd2wr - DDR2/3/mDDR: RL + BL/2 + 2 - WL DDR4: RL + BL/2 + 1 + WR_PREAMBLE - WL LPDDR2/LPDDR3: RL
 *    + BL/2 + RU(tDQSCKmax/tCK) + 1 - WL LPDDR4(DQ ODT is Disabled): RL + BL/2 + RU(tDQSCKmax/tCK)
 *    + WR_PREAMBLE + RD_POSTAMBLE - WL LPDDR4(DQ ODT is Enabled) : RL + BL/2 + RU(tDQSCKmax/tCK) +
 *    RD_POSTAMBLE - ODTLon - RU(tODTon(min)/tCK) Minimum time from read command to write command.
 *    Include time for bus turnaround and all per-bank, per-rank, and global constraints. Please see
 *    the relevant PHY databook for details of what should be included here. Unit: Clocks. Where: -
 *    WL = write latency - BL = burst length. This must match the value programmed in the BL bit of
 *    the mode register to the SDRAM - RL = read latency = CAS latency - WR_PREAMBLE = write
 *    preamble. This is unique to DDR4 and LPDDR4. - RD_POSTAMBLE = read postamble. This is unique to
 *    LPDDR4. For LPDDR2/LPDDR3/LPDDR4, if derating is enabled (DERATEEN.derate_enable=1), derated
 *    tDQSCKmax should be used. When the controller is operating in 1:2 frequency ratio mode, divide the
 *    value calculated using the above equation by 2, and round it up to next integer. Note that,
 *    depending on the PHY, if using LRDIMM, it may be necessary to adjust the value of this parameter
 *    to compensate for the extra cycle of latency through the LRDIMM.
 */
#define DDRC_DRAMTMG2_SHADOW_RD2WR(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG2_SHADOW_RD2WR_SHIFT)) & DDRC_DRAMTMG2_SHADOW_RD2WR_MASK)
#define DDRC_DRAMTMG2_SHADOW_READ_LATENCY_MASK  (0x3F0000U)
#define DDRC_DRAMTMG2_SHADOW_READ_LATENCY_SHIFT (16U)
/*! read_latency - Set to RL Time from read command to read data on SDRAM interface. This must be
 *    set to RL. Note that, depending on the PHY, if using RDIMM/LRDIMM, it may be necessary to adjust
 *    the value of RL to compensate for the extra cycle of latency through the RDIMM/LRDIMM. When
 *    the controller is operating in 1:2 frequency ratio mode, divide the value calculated using the
 *    above equation by 2, and round it up to next integer. This register field is not required for
 *    DDR2 and DDR3 (except if MEMC_TRAINING is set), as the DFI read and write latencies defined in
 *    DFITMG0 and DFITMG1 are sufficient for those protocols Unit: clocks
 */
#define DDRC_DRAMTMG2_SHADOW_READ_LATENCY(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG2_SHADOW_READ_LATENCY_SHIFT)) & DDRC_DRAMTMG2_SHADOW_READ_LATENCY_MASK)
#define DDRC_DRAMTMG2_SHADOW_WRITE_LATENCY_MASK  (0x3F000000U)
#define DDRC_DRAMTMG2_SHADOW_WRITE_LATENCY_SHIFT (24U)
/*! write_latency - Set to WL Time from write command to write data on SDRAM interface. This must be
 *    set to WL. For mDDR, it should normally be set to 1. Note that, depending on the PHY, if
 *    using RDIMM/LRDIMM, it may be necessary to adjust the value of WL to compensate for the extra
 *    cycle of latency through the RDIMM/LRDIMM. When the controller is operating in 1:2 frequency ratio
 *    mode, divide the value calculated using the above equation by 2, and round it up to next
 *    integer. This register field is not required for DDR2 and DDR3 (except if MEMC_TRAINING is set),
 *    as the DFI read and write latencies defined in DFITMG0 and DFITMG1 are sufficient for those
 *    protocols Unit: clocks
 */
#define DDRC_DRAMTMG2_SHADOW_WRITE_LATENCY(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG2_SHADOW_WRITE_LATENCY_SHIFT)) & \
     DDRC_DRAMTMG2_SHADOW_WRITE_LATENCY_MASK)
/*! @} */

/*! @name DRAMTMG3_SHADOW - [SHADOW] SDRAM Timing Register 3 */
/*! @{ */
#define DDRC_DRAMTMG3_SHADOW_T_MOD_MASK  (0x3FFU)
#define DDRC_DRAMTMG3_SHADOW_T_MOD_SHIFT (0U)
/*! t_mod - tMOD: Parameter used only in DDR3 and DDR4. Cycles between load mode command and
 *    following non-load mode command. If C/A parity for DDR4 is used, set to tMOD_PAR(tMOD+PL) instead.
 *    Set to tMOD if controller is operating in 1:1 frequency ratio mode, or tMOD/2 (rounded up to
 *    next integer) if controller is operating in 1:2 frequency ratio mode. Note that if using
 *    RDIMM/LRDIMM, depending on the PHY, it may be necessary to adjust the value of this parameter to
 *    compensate for the extra cycle of latency applied to mode register writes by the RDIMM/LRDIMM chip.
 *    Also note that if using LRDIMM, the minimum value of this register is tMRD_L2 if controller
 *    is operating in 1:1 frequency ratio mode, or tMRD_L2/2 (rounded up to next integer) if
 *    controller is operating in 1:2 frequency ratio mode.
 */
#define DDRC_DRAMTMG3_SHADOW_T_MOD(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG3_SHADOW_T_MOD_SHIFT)) & DDRC_DRAMTMG3_SHADOW_T_MOD_MASK)
#define DDRC_DRAMTMG3_SHADOW_T_MRD_MASK  (0x3F000U)
#define DDRC_DRAMTMG3_SHADOW_T_MRD_SHIFT (12U)
/*! t_mrd - tMRD: Cycles to wait after a mode register write or read. Depending on the connected
 *    SDRAM, tMRD represents: DDR2/mDDR: Time from MRS to any command DDR3/4: Time from MRS to MRS
 *    command LPDDR2: not used LPDDR3/4: Time from MRS to non-MRS command. When the controller is
 *    operating in 1:2 frequency ratio mode, program this to (tMRD/2) and round it up to the next integer
 *    value. If C/A parity for DDR4 is used, set to tMRD_PAR(tMOD+PL) instead.
 */
#define DDRC_DRAMTMG3_SHADOW_T_MRD(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG3_SHADOW_T_MRD_SHIFT)) & DDRC_DRAMTMG3_SHADOW_T_MRD_MASK)
#define DDRC_DRAMTMG3_SHADOW_T_MRW_MASK  (0x3FF00000U)
#define DDRC_DRAMTMG3_SHADOW_T_MRW_SHIFT (20U)
/*! t_mrw - Time to wait after a mode register write or read (MRW or MRR). Present only in designs
 *    configured to support LPDDR2, LPDDR3 or LPDDR4. LPDDR2 typically requires value of 5. LPDDR3
 *    typically requires value of 10. LPDDR4: Set this to the larger of tMRW and tMRWCKEL. For LPDDR2,
 *    this register is used for the time from a MRW/MRR to all other commands. When the controller
 *    is operating in 1:2 frequency ratio mode, program this to the above values divided by 2 and
 *    round it up to the next integer value. For LDPDR3, this register is used for the time from a
 *    MRW/MRR to a MRW/MRR.
 */
#define DDRC_DRAMTMG3_SHADOW_T_MRW(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG3_SHADOW_T_MRW_SHIFT)) & DDRC_DRAMTMG3_SHADOW_T_MRW_MASK)
/*! @} */

/*! @name DRAMTMG4_SHADOW - [SHADOW] SDRAM Timing Register 4 */
/*! @{ */
#define DDRC_DRAMTMG4_SHADOW_T_RP_MASK  (0x1FU)
#define DDRC_DRAMTMG4_SHADOW_T_RP_SHIFT (0U)
/*! t_rp - tRP: Minimum time from precharge to activate of same bank. When the controller is
 *    operating in 1:1 frequency ratio mode, t_rp should be set to RoundUp(tRP/tCK). When the controller is
 *    operating in 1:2 frequency ratio mode, t_rp should be set to RoundDown(RoundUp(tRP/tCK)/2) +
 *    1. When the controller is operating in 1:2 frequency ratio mode in LPDDR4, t_rp should be set
 *    to RoundUp(RoundUp(tRP/tCK)/2). Unit: Clocks.
 */
#define DDRC_DRAMTMG4_SHADOW_T_RP(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG4_SHADOW_T_RP_SHIFT)) & DDRC_DRAMTMG4_SHADOW_T_RP_MASK)
#define DDRC_DRAMTMG4_SHADOW_T_RRD_MASK  (0xF00U)
#define DDRC_DRAMTMG4_SHADOW_T_RRD_SHIFT (8U)
/*! t_rrd - DDR4: tRRD_L: Minimum time between activates from bank "a" to bank "b" for same bank
 *    group. Others: tRRD: Minimum time between activates from bank "a" to bank "b" When the controller
 *    is operating in 1:2 frequency ratio mode, program this to (tRRD_L/2 or tRRD/2) and round it
 *    up to the next integer value. Unit: Clocks.
 */
#define DDRC_DRAMTMG4_SHADOW_T_RRD(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG4_SHADOW_T_RRD_SHIFT)) & DDRC_DRAMTMG4_SHADOW_T_RRD_MASK)
#define DDRC_DRAMTMG4_SHADOW_T_CCD_MASK  (0xF0000U)
#define DDRC_DRAMTMG4_SHADOW_T_CCD_SHIFT (16U)
/*! t_ccd - DDR4: tCCD_L: This is the minimum time between two reads or two writes for same bank
 *    group. Others: tCCD: This is the minimum time between two reads or two writes. When the
 *    controller is operating in 1:2 frequency ratio mode, program this to (tCCD_L/2 or tCCD/2) and round it
 *    up to the next integer value. Unit: clocks.
 */
#define DDRC_DRAMTMG4_SHADOW_T_CCD(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG4_SHADOW_T_CCD_SHIFT)) & DDRC_DRAMTMG4_SHADOW_T_CCD_MASK)
#define DDRC_DRAMTMG4_SHADOW_T_RCD_MASK  (0x1F000000U)
#define DDRC_DRAMTMG4_SHADOW_T_RCD_SHIFT (24U)
/*! t_rcd - tRCD - tAL: Minimum time from activate to read or write command to same bank. When the
 *    controller is operating in 1:2 frequency ratio mode, program this to ((tRCD - tAL)/2) and round
 *    it up to the next integer value. Minimum value allowed for this register is 1, which implies
 *    minimum (tRCD - tAL) value to be 2 when the controller is operating in 1:2 frequency ratio
 *    mode. Unit: Clocks.
 */
#define DDRC_DRAMTMG4_SHADOW_T_RCD(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG4_SHADOW_T_RCD_SHIFT)) & DDRC_DRAMTMG4_SHADOW_T_RCD_MASK)
/*! @} */

/*! @name DRAMTMG5_SHADOW - [SHADOW] SDRAM Timing Register 5 */
/*! @{ */
#define DDRC_DRAMTMG5_SHADOW_T_CKE_MASK  (0x1FU)
#define DDRC_DRAMTMG5_SHADOW_T_CKE_SHIFT (0U)
/*! t_cke - Minimum number of cycles of CKE HIGH/LOW during power-down and self refresh. -
 *    LPDDR2/LPDDR3 mode: Set this to the larger of tCKE or tCKESR - LPDDR4 mode: Set this to the larger of
 *    tCKE, tCKELPD or tSR. - Non-LPDDR2/non-LPDDR3/non-LPDDR4 designs: Set this to tCKE value. When
 *    the controller is operating in 1:2 frequency ratio mode, program this to (value described
 *    above)/2 and round it up to the next integer value. Unit: Clocks.
 */
#define DDRC_DRAMTMG5_SHADOW_T_CKE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG5_SHADOW_T_CKE_SHIFT)) & DDRC_DRAMTMG5_SHADOW_T_CKE_MASK)
#define DDRC_DRAMTMG5_SHADOW_T_CKESR_MASK  (0x3F00U)
#define DDRC_DRAMTMG5_SHADOW_T_CKESR_SHIFT (8U)
/*! t_ckesr - Minimum CKE low width for Self refresh or Self refresh power down entry to exit timing
 *    in memory clock cycles. Recommended settings: - mDDR: tRFC - LPDDR2: tCKESR - LPDDR3: tCKESR
 *    - LPDDR4: max(tCKELPD, tSR) - DDR2: tCKE - DDR3: tCKE + 1 - DDR4: tCKE + 1 (+ PL(parity
 *    latency)(*)) (*)Only if CRCPARCTL1.caparity_disable_before_sr=0, this register should be increased
 *    by PL. When the controller is operating in 1:2 frequency ratio mode, program this to
 *    recommended value divided by two and round it up to next integer.
 */
#define DDRC_DRAMTMG5_SHADOW_T_CKESR(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG5_SHADOW_T_CKESR_SHIFT)) & DDRC_DRAMTMG5_SHADOW_T_CKESR_MASK)
#define DDRC_DRAMTMG5_SHADOW_T_CKSRE_MASK  (0xF0000U)
#define DDRC_DRAMTMG5_SHADOW_T_CKSRE_SHIFT (16U)
/*! t_cksre - This is the time after Self Refresh Down Entry that CK is maintained as a valid clock.
 *    Specifies the clock disable delay after SRE. Recommended settings: - mDDR: 0 - LPDDR2: 2 -
 *    LPDDR3: 2 - LPDDR4: tCKCKEL - DDR2: 1 - DDR3: max (10 ns, 5 tCK) - DDR4: max (10 ns, 5 tCK) (+
 *    PL(parity latency)(*)) (*)Only if CRCPARCTL1.caparity_disable_before_sr=0, this register should
 *    be increased by PL. When the controller is operating in 1:2 frequency ratio mode, program
 *    this to recommended value divided by two and round it up to next integer.
 */
#define DDRC_DRAMTMG5_SHADOW_T_CKSRE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG5_SHADOW_T_CKSRE_SHIFT)) & DDRC_DRAMTMG5_SHADOW_T_CKSRE_MASK)
#define DDRC_DRAMTMG5_SHADOW_T_CKSRX_MASK  (0xF000000U)
#define DDRC_DRAMTMG5_SHADOW_T_CKSRX_SHIFT (24U)
/*! t_cksrx - This is the time before Self Refresh Exit that CK is maintained as a valid clock
 *    before issuing SRX. Specifies the clock stable time before SRX. Recommended settings: - mDDR: 1 -
 *    LPDDR2: 2 - LPDDR3: 2 - LPDDR4: tCKCKEH - DDR2: 1 - DDR3: tCKSRX - DDR4: tCKSRX When the
 *    controller is operating in 1:2 frequency ratio mode, program this to recommended value divided by
 *    two and round it up to next integer.
 */
#define DDRC_DRAMTMG5_SHADOW_T_CKSRX(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG5_SHADOW_T_CKSRX_SHIFT)) & DDRC_DRAMTMG5_SHADOW_T_CKSRX_MASK)
/*! @} */

/*! @name DRAMTMG6_SHADOW - [SHADOW] SDRAM Timing Register 6 */
/*! @{ */
#define DDRC_DRAMTMG6_SHADOW_T_CKCSX_MASK  (0xFU)
#define DDRC_DRAMTMG6_SHADOW_T_CKCSX_SHIFT (0U)
/*! t_ckcsx - This is the time before Clock Stop Exit that CK is maintained as a valid clock before
 *    issuing Clock Stop Exit. Specifies the clock stable time before next command after Clock Stop
 *    Exit. Recommended settings: - mDDR: 1 - LPDDR2: tXP + 2 - LPDDR3: tXP + 2 - LPDDR4: tXP + 2
 *    When the controller is operating in 1:2 frequency ratio mode, program this to recommended value
 *    divided by two and round it up to next integer. This is only present for designs supporting
 *    mDDR or LPDDR2/LPDDR3/LPDDR4 devices.
 */
#define DDRC_DRAMTMG6_SHADOW_T_CKCSX(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG6_SHADOW_T_CKCSX_SHIFT)) & DDRC_DRAMTMG6_SHADOW_T_CKCSX_MASK)
#define DDRC_DRAMTMG6_SHADOW_T_CKDPDX_MASK  (0xF0000U)
#define DDRC_DRAMTMG6_SHADOW_T_CKDPDX_SHIFT (16U)
/*! t_ckdpdx - This is the time before Deep Power Down Exit that CK is maintained as a valid clock
 *    before issuing DPDX. Specifies the clock stable time before DPDX. Recommended settings: - mDDR:
 *    1 - LPDDR2: 2 - LPDDR3: 2 When the controller is operating in 1:2 frequency ratio mode,
 *    program this to recommended value divided by two and round it up to next integer. This is only
 *    present for designs supporting mDDR or LPDDR2 devices.
 */
#define DDRC_DRAMTMG6_SHADOW_T_CKDPDX(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG6_SHADOW_T_CKDPDX_SHIFT)) & DDRC_DRAMTMG6_SHADOW_T_CKDPDX_MASK)
#define DDRC_DRAMTMG6_SHADOW_T_CKDPDE_MASK  (0xF000000U)
#define DDRC_DRAMTMG6_SHADOW_T_CKDPDE_SHIFT (24U)
/*! t_ckdpde - This is the time after Deep Power Down Entry that CK is maintained as a valid clock.
 *    Specifies the clock disable delay after DPDE. Recommended settings: - mDDR: 0 - LPDDR2: 2 -
 *    LPDDR3: 2 When the controller is operating in 1:2 frequency ratio mode, program this to
 *    recommended value divided by two and round it up to next integer. This is only present for designs
 *    supporting mDDR or LPDDR2/LPDDR3 devices.
 */
#define DDRC_DRAMTMG6_SHADOW_T_CKDPDE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG6_SHADOW_T_CKDPDE_SHIFT)) & DDRC_DRAMTMG6_SHADOW_T_CKDPDE_MASK)
/*! @} */

/*! @name DRAMTMG7_SHADOW - [SHADOW] SDRAM Timing Register 7 */
/*! @{ */
#define DDRC_DRAMTMG7_SHADOW_T_CKPDX_MASK  (0xFU)
#define DDRC_DRAMTMG7_SHADOW_T_CKPDX_SHIFT (0U)
/*! t_ckpdx - This is the time before Power Down Exit that CK is maintained as a valid clock before
 *    issuing PDX. Specifies the clock stable time before PDX. Recommended settings: - mDDR: 0 -
 *    LPDDR2: 2 - LPDDR3: 2 - LPDDR4: 2 When using DDR2/3/4 SDRAM, this register should be set to the
 *    same value as DRAMTMG5.t_cksrx. When the controller is operating in 1:2 frequency ratio mode,
 *    program this to recommended value divided by two and round it up to next integer. This is only
 *    present for designs supporting mDDR or LPDDR2/LPDDR3/LPDDR4 devices.
 */
#define DDRC_DRAMTMG7_SHADOW_T_CKPDX(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG7_SHADOW_T_CKPDX_SHIFT)) & DDRC_DRAMTMG7_SHADOW_T_CKPDX_MASK)
#define DDRC_DRAMTMG7_SHADOW_T_CKPDE_MASK  (0xF00U)
#define DDRC_DRAMTMG7_SHADOW_T_CKPDE_SHIFT (8U)
/*! t_ckpde - This is the time after Power Down Entry that CK is maintained as a valid clock.
 *    Specifies the clock disable delay after PDE. Recommended settings: - mDDR: 0 - LPDDR2: 2 - LPDDR3: 2
 *    - LPDDR4: tCKCKEL When using DDR2/3/4 SDRAM, this register should be set to the same value as
 *    DRAMTMG5.t_cksre. When the controller is operating in 1:2 frequency ratio mode, program this
 *    to recommended value divided by two and round it up to next integer. This is only present for
 *    designs supporting mDDR or LPDDR2/LPDDR3/LPDDR4 devices.
 */
#define DDRC_DRAMTMG7_SHADOW_T_CKPDE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG7_SHADOW_T_CKPDE_SHIFT)) & DDRC_DRAMTMG7_SHADOW_T_CKPDE_MASK)
/*! @} */

/*! @name DRAMTMG8_SHADOW - [SHADOW] SDRAM Timing Register 8 */
/*! @{ */
#define DDRC_DRAMTMG8_SHADOW_T_XS_X32_MASK  (0x7FU)
#define DDRC_DRAMTMG8_SHADOW_T_XS_X32_SHIFT (0U)
/*! t_xs_x32 - tXS: Exit Self Refresh to commands not requiring a locked DLL. When the controller is
 *    operating in 1:2 frequency ratio mode, program this to the above value divided by 2 and round
 *    up to next integer value. Unit: Multiples of 32 clocks. Note: Used only for DDR2, DDR3 and
 *    DDR4 SDRAMs.
 */
#define DDRC_DRAMTMG8_SHADOW_T_XS_X32(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG8_SHADOW_T_XS_X32_SHIFT)) & DDRC_DRAMTMG8_SHADOW_T_XS_X32_MASK)
#define DDRC_DRAMTMG8_SHADOW_T_XS_DLL_X32_MASK  (0x7F00U)
#define DDRC_DRAMTMG8_SHADOW_T_XS_DLL_X32_SHIFT (8U)
/*! t_xs_dll_x32 - tXSDLL: Exit Self Refresh to commands requiring a locked DLL. When the controller
 *    is operating in 1:2 frequency ratio mode, program this to the above value divided by 2 and
 *    round up to next integer value. Unit: Multiples of 32 clocks. Note: Used only for DDR2, DDR3 and
 *    DDR4 SDRAMs.
 */
#define DDRC_DRAMTMG8_SHADOW_T_XS_DLL_X32(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG8_SHADOW_T_XS_DLL_X32_SHIFT)) & DDRC_DRAMTMG8_SHADOW_T_XS_DLL_X32_MASK)
#define DDRC_DRAMTMG8_SHADOW_T_XS_ABORT_X32_MASK  (0x7F0000U)
#define DDRC_DRAMTMG8_SHADOW_T_XS_ABORT_X32_SHIFT (16U)
/*! t_xs_abort_x32 - tXS_ABORT: Exit Self Refresh to commands not requiring a locked DLL in Self
 *    Refresh Abort. When the controller is operating in 1:2 frequency ratio mode, program this to the
 *    above value divided by 2 and round up to next integer value. Unit: Multiples of 32 clocks.
 *    Note: Ensure this is less than or equal to t_xs_x32.
 */
#define DDRC_DRAMTMG8_SHADOW_T_XS_ABORT_X32(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG8_SHADOW_T_XS_ABORT_X32_SHIFT)) & \
     DDRC_DRAMTMG8_SHADOW_T_XS_ABORT_X32_MASK)
#define DDRC_DRAMTMG8_SHADOW_T_XS_FAST_X32_MASK  (0x7F000000U)
#define DDRC_DRAMTMG8_SHADOW_T_XS_FAST_X32_SHIFT (24U)
/*! t_xs_fast_x32 - tXS_FAST: Exit Self Refresh to ZQCL, ZQCS and MRS (only CL, WR, RTP and Geardown
 *    mode). When the controller is operating in 1:2 frequency ratio mode, program this to the
 *    above value divided by 2 and round up to next integer value. Unit: Multiples of 32 clocks. Note:
 *    This is applicable to only ZQCL/ZQCS commands. Note: Ensure this is less than or equal to
 *    t_xs_x32.
 */
#define DDRC_DRAMTMG8_SHADOW_T_XS_FAST_X32(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG8_SHADOW_T_XS_FAST_X32_SHIFT)) & \
     DDRC_DRAMTMG8_SHADOW_T_XS_FAST_X32_MASK)
/*! @} */

/*! @name DRAMTMG9_SHADOW - [SHADOW] SDRAM Timing Register 9 */
/*! @{ */
#define DDRC_DRAMTMG9_SHADOW_WR2RD_S_MASK  (0x3FU)
#define DDRC_DRAMTMG9_SHADOW_WR2RD_S_SHIFT (0U)
/*! wr2rd_s - CWL + PL + BL/2 + tWTR_S Minimum time from write command to read command for different
 *    bank group. Includes time for bus turnaround, recovery times, and all per-bank, per-rank, and
 *    global constraints. Present only in designs configured to support DDR4. Unit: Clocks. Where:
 *    - CWL = CAS write latency - PL = Parity latency - BL = burst length. This must match the value
 *    programmed in the BL bit of the mode register to the SDRAM - tWTR_S = internal write to read
 *    command delay for different bank group. This comes directly from the SDRAM specification. When
 *    the controller is operating in 1:2 mode, divide the value calculated using the above equation
 *    by 2, and round it up to next integer.
 */
#define DDRC_DRAMTMG9_SHADOW_WR2RD_S(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG9_SHADOW_WR2RD_S_SHIFT)) & DDRC_DRAMTMG9_SHADOW_WR2RD_S_MASK)
#define DDRC_DRAMTMG9_SHADOW_T_RRD_S_MASK  (0xF00U)
#define DDRC_DRAMTMG9_SHADOW_T_RRD_S_SHIFT (8U)
/*! t_rrd_s - tRRD_S: Minimum time between activates from bank "a" to bank "b" for different bank
 *    group. When the controller is operating in 1:2 frequency ratio mode, program this to (tRRD_S/2)
 *    and round it up to the next integer value. Present only in designs configured to support DDR4.
 *    Unit: Clocks.
 */
#define DDRC_DRAMTMG9_SHADOW_T_RRD_S(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG9_SHADOW_T_RRD_S_SHIFT)) & DDRC_DRAMTMG9_SHADOW_T_RRD_S_MASK)
#define DDRC_DRAMTMG9_SHADOW_T_CCD_S_MASK  (0x70000U)
#define DDRC_DRAMTMG9_SHADOW_T_CCD_S_SHIFT (16U)
/*! t_ccd_s - tCCD_S: This is the minimum time between two reads or two writes for different bank
 *    group. For bank switching (from bank "a" to bank "b"), the minimum time is this value + 1. When
 *    the controller is operating in 1:2 frequency ratio mode, program this to (tCCD_S/2) and round
 *    it up to the next integer value. Present only in designs configured to support DDR4. Unit:
 *    clocks.
 */
#define DDRC_DRAMTMG9_SHADOW_T_CCD_S(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG9_SHADOW_T_CCD_S_SHIFT)) & DDRC_DRAMTMG9_SHADOW_T_CCD_S_MASK)
#define DDRC_DRAMTMG9_SHADOW_DDR4_WR_PREAMBLE_MASK  (0x40000000U)
#define DDRC_DRAMTMG9_SHADOW_DDR4_WR_PREAMBLE_SHIFT (30U)
/*! ddr4_wr_preamble - DDR4 Write preamble mode - 0: 1tCK preamble - 1: 2tCK preamble Present only with
 * MEMC_FREQ_RATIO=2
 */
#define DDRC_DRAMTMG9_SHADOW_DDR4_WR_PREAMBLE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG9_SHADOW_DDR4_WR_PREAMBLE_SHIFT)) & \
     DDRC_DRAMTMG9_SHADOW_DDR4_WR_PREAMBLE_MASK)
/*! @} */

/*! @name DRAMTMG10_SHADOW - [SHADOW] SDRAM Timing Register 10 */
/*! @{ */
#define DDRC_DRAMTMG10_SHADOW_T_GEAR_HOLD_MASK  (0x3U)
#define DDRC_DRAMTMG10_SHADOW_T_GEAR_HOLD_SHIFT (0U)
/*! t_gear_hold - Geardown hold time. Minimum value of this register is 1. Zero is invalid. For
 *    DDR4-2666 and DDR4-3200, this parameter is defined as 2 clks When the controller is operating in
 *    1:2 frequency ratio mode, program this to (tGEAR_hold/2) and round it up to the next integer
 *    value. Unit: Clocks
 */
#define DDRC_DRAMTMG10_SHADOW_T_GEAR_HOLD(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG10_SHADOW_T_GEAR_HOLD_SHIFT)) & DDRC_DRAMTMG10_SHADOW_T_GEAR_HOLD_MASK)
#define DDRC_DRAMTMG10_SHADOW_T_GEAR_SETUP_MASK  (0xCU)
#define DDRC_DRAMTMG10_SHADOW_T_GEAR_SETUP_SHIFT (2U)
/*! t_gear_setup - Geardown setup time. Minimum value of this register is 1. Zero is invalid. For
 *    DDR4-2666 and DDR4-3200, this parameter is defined as 2 clks When the controller is operating in
 *    1:2 frequency ratio mode, program this to (tGEAR_setup/2) and round it up to the next integer
 *    value. Unit: Clocks
 */
#define DDRC_DRAMTMG10_SHADOW_T_GEAR_SETUP(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG10_SHADOW_T_GEAR_SETUP_SHIFT)) & \
     DDRC_DRAMTMG10_SHADOW_T_GEAR_SETUP_MASK)
#define DDRC_DRAMTMG10_SHADOW_T_CMD_GEAR_MASK  (0x1F00U)
#define DDRC_DRAMTMG10_SHADOW_T_CMD_GEAR_SHIFT (8U)
/*! t_cmd_gear - Sync pulse to first valid command. For DDR4-2666 and DDR4-3200, this parameter is
 *    defined as tMOD(min) tMOD(min) is greater of 24nCK or 15ns 15ns / .625ns = 24 Max value for
 *    this register is 24 When the controller is operating in 1:2 mode, program this to (tCMD_GEAR/2)
 *    and round it up to the next integer value. Unit: Clocks
 */
#define DDRC_DRAMTMG10_SHADOW_T_CMD_GEAR(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG10_SHADOW_T_CMD_GEAR_SHIFT)) & DDRC_DRAMTMG10_SHADOW_T_CMD_GEAR_MASK)
#define DDRC_DRAMTMG10_SHADOW_T_SYNC_GEAR_MASK  (0x1F0000U)
#define DDRC_DRAMTMG10_SHADOW_T_SYNC_GEAR_SHIFT (16U)
/*! t_sync_gear - Indicates the time between MRS command and the sync pulse time. This must be even
 *    number of clocks. For DDR4-2666 and DDR4-3200, this parameter is defined as tMOD(min)+4nCK
 *    tMOD(min) is greater of 24nCK or 15ns 15ns / .625ns = 24 Max value for this register is 24+4 = 28
 *    When the controller is operating in 1:2 mode, program this to (tSYNC_GEAR/2) and round it up
 *    to the next integer value. Unit: Clocks
 */
#define DDRC_DRAMTMG10_SHADOW_T_SYNC_GEAR(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG10_SHADOW_T_SYNC_GEAR_SHIFT)) & DDRC_DRAMTMG10_SHADOW_T_SYNC_GEAR_MASK)
/*! @} */

/*! @name DRAMTMG11_SHADOW - [SHADOW] SDRAM Timing Register 11 */
/*! @{ */
#define DDRC_DRAMTMG11_SHADOW_T_CKMPE_MASK  (0x1FU)
#define DDRC_DRAMTMG11_SHADOW_T_CKMPE_SHIFT (0U)
/*! t_ckmpe - tCKMPE: Minimum valid clock requirement after MPSM entry. Present only in designs
 *    configured to support DDR4. Unit: Clocks. When the controller is operating in 1:2 frequency ratio
 *    mode, divide the value calculated using the above equation by 2, and round it up to next
 *    integer.
 */
#define DDRC_DRAMTMG11_SHADOW_T_CKMPE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG11_SHADOW_T_CKMPE_SHIFT)) & DDRC_DRAMTMG11_SHADOW_T_CKMPE_MASK)
#define DDRC_DRAMTMG11_SHADOW_T_MPX_S_MASK  (0x300U)
#define DDRC_DRAMTMG11_SHADOW_T_MPX_S_SHIFT (8U)
/*! t_mpx_s - tMPX_S: Minimum time CS setup time to CKE. When the controller is operating in 1:2
 *    frequency ratio mode, program this to (tMPX_S/2) and round it up to the next integer value.
 *    Present only in designs configured to support DDR4. Unit: Clocks.
 */
#define DDRC_DRAMTMG11_SHADOW_T_MPX_S(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG11_SHADOW_T_MPX_S_SHIFT)) & DDRC_DRAMTMG11_SHADOW_T_MPX_S_MASK)
#define DDRC_DRAMTMG11_SHADOW_T_MPX_LH_MASK  (0x1F0000U)
#define DDRC_DRAMTMG11_SHADOW_T_MPX_LH_SHIFT (16U)
/*! t_mpx_lh - tMPX_LH: This is the minimum CS_n Low hold time to CKE rising edge. When the
 *    controller is operating in 1:2 frequency ratio mode, program this to RoundUp(tMPX_LH/2)+1. Present
 *    only in designs configured to support DDR4. Unit: clocks.
 */
#define DDRC_DRAMTMG11_SHADOW_T_MPX_LH(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG11_SHADOW_T_MPX_LH_SHIFT)) & DDRC_DRAMTMG11_SHADOW_T_MPX_LH_MASK)
#define DDRC_DRAMTMG11_SHADOW_POST_MPSM_GAP_X32_MASK  (0x7F000000U)
#define DDRC_DRAMTMG11_SHADOW_POST_MPSM_GAP_X32_SHIFT (24U)
/*! post_mpsm_gap_x32 - tXMPDLL: This is the minimum Exit MPSM to commands requiring a locked DLL.
 *    When the controller is operating in 1:2 frequency ratio mode, program this to (tXMPDLL/2) and
 *    round it up to the next integer value. Present only in designs configured to support DDR4.
 *    Unit: Multiples of 32 clocks.
 */
#define DDRC_DRAMTMG11_SHADOW_POST_MPSM_GAP_X32(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG11_SHADOW_POST_MPSM_GAP_X32_SHIFT)) & \
     DDRC_DRAMTMG11_SHADOW_POST_MPSM_GAP_X32_MASK)
/*! @} */

/*! @name DRAMTMG12_SHADOW - [SHADOW] SDRAM Timing Register 12 */
/*! @{ */
#define DDRC_DRAMTMG12_SHADOW_T_MRD_PDA_MASK  (0x1FU)
#define DDRC_DRAMTMG12_SHADOW_T_MRD_PDA_SHIFT (0U)
/*! t_mrd_pda - tMRD_PDA: This is the Mode Register Set command cycle time in PDA mode. When the
 *    controller is operating in 1:2 frequency ratio mode, program this to (tMRD_PDA/2) and round it up
 *    to the next integer value.
 */
#define DDRC_DRAMTMG12_SHADOW_T_MRD_PDA(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG12_SHADOW_T_MRD_PDA_SHIFT)) & DDRC_DRAMTMG12_SHADOW_T_MRD_PDA_MASK)
#define DDRC_DRAMTMG12_SHADOW_T_CKEHCMD_MASK  (0xF00U)
#define DDRC_DRAMTMG12_SHADOW_T_CKEHCMD_SHIFT (8U)
/*! t_ckehcmd - tCKEHCMD: Valid command requirement after CKE input HIGH. When the controller is
 *    operating in 1:2 frequency ratio mode, program this to (tCKEHCMD/2) and round it up to the next
 *    integer value.
 */
#define DDRC_DRAMTMG12_SHADOW_T_CKEHCMD(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG12_SHADOW_T_CKEHCMD_SHIFT)) & DDRC_DRAMTMG12_SHADOW_T_CKEHCMD_MASK)
#define DDRC_DRAMTMG12_SHADOW_T_CMDCKE_MASK  (0x30000U)
#define DDRC_DRAMTMG12_SHADOW_T_CMDCKE_SHIFT (16U)
/*! t_cmdcke - tCMDCKE: Delay from valid command to CKE input LOW. Set this to the larger of tESCKE
 *    or tCMDCKE When the controller is operating in 1:2 frequency ratio mode, program this to
 *    (max(tESCKE, tCMDCKE)/2) and round it up to the next integer value.
 */
#define DDRC_DRAMTMG12_SHADOW_T_CMDCKE(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG12_SHADOW_T_CMDCKE_SHIFT)) & DDRC_DRAMTMG12_SHADOW_T_CMDCKE_MASK)
/*! @} */

/*! @name DRAMTMG13_SHADOW - [SHADOW] SDRAM Timing Register 13 */
/*! @{ */
#define DDRC_DRAMTMG13_SHADOW_T_PPD_MASK  (0x7U)
#define DDRC_DRAMTMG13_SHADOW_T_PPD_SHIFT (0U)
/*! t_ppd - LPDDR4: tPPD: This is the minimum time from precharge to precharge command. When the
 *    controller is operating in 1:2 frequency ratio mode, program this to (tPPD/2) and round it up to
 *    the next integer value. Unit: Clocks.
 */
#define DDRC_DRAMTMG13_SHADOW_T_PPD(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG13_SHADOW_T_PPD_SHIFT)) & DDRC_DRAMTMG13_SHADOW_T_PPD_MASK)
#define DDRC_DRAMTMG13_SHADOW_T_CCD_MW_MASK  (0x3F0000U)
#define DDRC_DRAMTMG13_SHADOW_T_CCD_MW_SHIFT (16U)
/*! t_ccd_mw - LPDDR4: tCCDMW: This is the minimum time from write or masked write to masked write
 *    command for same bank. When the controller is operating in 1:2 frequency ratio mode, program
 *    this to (tCCDMW/2) and round it up to the next integer value. Unit: Clocks.
 */
#define DDRC_DRAMTMG13_SHADOW_T_CCD_MW(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG13_SHADOW_T_CCD_MW_SHIFT)) & DDRC_DRAMTMG13_SHADOW_T_CCD_MW_MASK)
#define DDRC_DRAMTMG13_SHADOW_ODTLOFF_MASK  (0x7F000000U)
#define DDRC_DRAMTMG13_SHADOW_ODTLOFF_SHIFT (24U)
/*! odtloff - LPDDR4: tODTLoff: This is the latency from CAS-2 command to tODToff reference. When
 *    the controller is operating in 1:2 frequency ratio mode, program this to (tODTLoff/2) and round
 *    it up to the next integer value. Unit: Clocks.
 */
#define DDRC_DRAMTMG13_SHADOW_ODTLOFF(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG13_SHADOW_ODTLOFF_SHIFT)) & DDRC_DRAMTMG13_SHADOW_ODTLOFF_MASK)
/*! @} */

/*! @name DRAMTMG14_SHADOW - [SHADOW] SDRAM Timing Register 14 */
/*! @{ */
#define DDRC_DRAMTMG14_SHADOW_T_XSR_MASK  (0xFFFU)
#define DDRC_DRAMTMG14_SHADOW_T_XSR_SHIFT (0U)
/*! t_xsr - tXSR: Exit Self Refresh to any command. When the controller is operating in 1:2
 *    frequency ratio mode, program this to the above value divided by 2 and round up to next integer value.
 *    Note: Used only for mDDR/LPDDR2/LPDDR3/LPDDR4 mode.
 */
#define DDRC_DRAMTMG14_SHADOW_T_XSR(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG14_SHADOW_T_XSR_SHIFT)) & DDRC_DRAMTMG14_SHADOW_T_XSR_MASK)
/*! @} */

/*! @name DRAMTMG15_SHADOW - [SHADOW] SDRAM Timing Register 15 */
/*! @{ */
#define DDRC_DRAMTMG15_SHADOW_T_STAB_X32_MASK  (0xFFU)
#define DDRC_DRAMTMG15_SHADOW_T_STAB_X32_SHIFT (0U)
/*! t_stab_x32 - tSTAB: Stabilization time. It is required in the following two cases for DDR3/DDR4
 *    RDIMM : - when exiting power saving mode, if the clock was stopped, after re-enabling it the
 *    clock must be stable for a time specified by tSTAB - in the case of input clock frequency
 *    change (DDR4) - after issuing control words that refers to clock timing (Specification: 6us for
 *    DDR3, 5us for DDR4) When the controller is operating in 1:2 frequency ratio mode, program this to
 *    recommended value divided by two and round it up to next integer. Unit: Multiples of 32 clock
 *    cycles.
 */
#define DDRC_DRAMTMG15_SHADOW_T_STAB_X32(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG15_SHADOW_T_STAB_X32_SHIFT)) & DDRC_DRAMTMG15_SHADOW_T_STAB_X32_MASK)
#define DDRC_DRAMTMG15_SHADOW_EN_DFI_LP_T_STAB_MASK  (0x80000000U)
#define DDRC_DRAMTMG15_SHADOW_EN_DFI_LP_T_STAB_SHIFT (31U)
/*! en_dfi_lp_t_stab - - 1 - Enable using tSTAB when exiting DFI LP. Needs to be set when the PHY is
 *    stopping the clock during DFI LP to save maximum power. - 0 - Disable using tSTAB when
 *    exiting DFI LP
 */
#define DDRC_DRAMTMG15_SHADOW_EN_DFI_LP_T_STAB(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DRAMTMG15_SHADOW_EN_DFI_LP_T_STAB_SHIFT)) & \
     DDRC_DRAMTMG15_SHADOW_EN_DFI_LP_T_STAB_MASK)
/*! @} */

/*! @name ZQCTL0_SHADOW - [SHADOW] ZQ Control Register 0 */
/*! @{ */
#define DDRC_ZQCTL0_SHADOW_T_ZQ_SHORT_NOP_MASK  (0x3FFU)
#define DDRC_ZQCTL0_SHADOW_T_ZQ_SHORT_NOP_SHIFT (0U)
/*! t_zq_short_nop - tZQCS for DDR3/DD4/LPDDR2/LPDDR3, tZQLAT for LPDDR4: Number of DFI clock cycles
 *    of NOP required after a ZQCS (ZQ calibration short)/MPC(ZQ Latch) command is issued to SDRAM.
 *    When the controller is operating in 1:2 frequency ratio mode, program this to tZQCS/2 and
 *    round it up to the next integer value. This is only present for designs supporting DDR3/DDR4 or
 *    LPDDR2/LPDDR3/LPDDR4 devices.
 */
#define DDRC_ZQCTL0_SHADOW_T_ZQ_SHORT_NOP(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ZQCTL0_SHADOW_T_ZQ_SHORT_NOP_SHIFT)) & DDRC_ZQCTL0_SHADOW_T_ZQ_SHORT_NOP_MASK)
#define DDRC_ZQCTL0_SHADOW_T_ZQ_LONG_NOP_MASK  (0x7FF0000U)
#define DDRC_ZQCTL0_SHADOW_T_ZQ_LONG_NOP_SHIFT (16U)
/*! t_zq_long_nop - tZQoper for DDR3/DDR4, tZQCL for LPDDR2/LPDDR3, tZQCAL for LPDDR4: Number of DFI
 *    clock cycles of NOP required after a ZQCL (ZQ calibration long)/MPC(ZQ Start) command is
 *    issued to SDRAM. When the controller is operating in 1:2 frequency ratio mode: DDR3/DDR4: program
 *    this to tZQoper/2 and round it up to the next integer value. LPDDR2/LPDDR3: program this to
 *    tZQCL/2 and round it up to the next integer value. LPDDR4: program this to tZQCAL/2 and round it
 *    up to the next integer value. This is only present for designs supporting DDR3/DDR4 or
 *    LPDDR2/LPDDR3/LPDDR4 devices.
 */
#define DDRC_ZQCTL0_SHADOW_T_ZQ_LONG_NOP(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ZQCTL0_SHADOW_T_ZQ_LONG_NOP_SHIFT)) & DDRC_ZQCTL0_SHADOW_T_ZQ_LONG_NOP_MASK)
#define DDRC_ZQCTL0_SHADOW_DIS_MPSMX_ZQCL_MASK  (0x10000000U)
#define DDRC_ZQCTL0_SHADOW_DIS_MPSMX_ZQCL_SHIFT (28U)
/*! dis_mpsmx_zqcl - - 1 - Disable issuing of ZQCL command at Maximum Power Saving Mode exit. Only
 *    applicable when run in DDR4 mode. - 0 - Enable issuing of ZQCL command at Maximum Power Saving
 *    Mode exit. Only applicable when run in DDR4 mode. This is only present for designs supporting
 *    DDR4 devices. Note: Do not issue ZQCL command at Maximum Power Save Mode exit if the
 *    DDRC_SHARED_AC configuration parameter is set. Program it to 1'b1. The software can send ZQCS after
 *    exiting MPSM mode.
 */
#define DDRC_ZQCTL0_SHADOW_DIS_MPSMX_ZQCL(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ZQCTL0_SHADOW_DIS_MPSMX_ZQCL_SHIFT)) & DDRC_ZQCTL0_SHADOW_DIS_MPSMX_ZQCL_MASK)
#define DDRC_ZQCTL0_SHADOW_ZQ_RESISTOR_SHARED_MASK  (0x20000000U)
#define DDRC_ZQCTL0_SHADOW_ZQ_RESISTOR_SHARED_SHIFT (29U)
/*! zq_resistor_shared - - 1 - Denotes that ZQ resistor is shared between ranks. Means
 *    ZQinit/ZQCL/ZQCS/MPC(ZQ calibration) commands are sent to one rank at a time with
 *    tZQinit/tZQCL/tZQCS/tZQCAL/tZQLAT timing met between commands so that commands to different ranks do not overlap.
 * - 0 - ZQ resistor is not shared. This is only present for designs supporting DDR3/DDR4 or LPDDR2/LPDDR3/LPDDR4
 * devices.
 */
#define DDRC_ZQCTL0_SHADOW_ZQ_RESISTOR_SHARED(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ZQCTL0_SHADOW_ZQ_RESISTOR_SHARED_SHIFT)) & \
     DDRC_ZQCTL0_SHADOW_ZQ_RESISTOR_SHARED_MASK)
#define DDRC_ZQCTL0_SHADOW_DIS_SRX_ZQCL_MASK  (0x40000000U)
#define DDRC_ZQCTL0_SHADOW_DIS_SRX_ZQCL_SHIFT (30U)
/*! dis_srx_zqcl - - 1 - Disable issuing of ZQCL/MPC(ZQ calibration) command at
 *    Self-Refresh/SR-Powerdown exit. Only applicable when run in DDR3 or DDR4 or LPDDR2 or LPDDR3 or LPDDR4 mode. - 0 -
 *    Enable issuing of ZQCL/MPC(ZQ calibration) command at Self-Refresh/SR-Powerdown exit. Only
 *    applicable when run in DDR3 or DDR4 or LPDDR2 or LPDDR3 or LPDDR4 mode. This is only present for
 *    designs supporting DDR3/DDR4 or LPDDR2/LPDDR3/LPDDR4 devices.
 */
#define DDRC_ZQCTL0_SHADOW_DIS_SRX_ZQCL(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ZQCTL0_SHADOW_DIS_SRX_ZQCL_SHIFT)) & DDRC_ZQCTL0_SHADOW_DIS_SRX_ZQCL_MASK)
#define DDRC_ZQCTL0_SHADOW_DIS_AUTO_ZQ_MASK  (0x80000000U)
#define DDRC_ZQCTL0_SHADOW_DIS_AUTO_ZQ_SHIFT (31U)
/*! dis_auto_zq - - 1 - Disable DDRC generation of ZQCS/MPC(ZQ calibration) command. Register
 *    DBGCMD.zq_calib_short can be used instead to issue ZQ calibration request from APB module. - 0 -
 *    Internally generate ZQCS/MPC(ZQ calibration) commands based on ZQCTL1.t_zq_short_interval_x1024.
 *    This is only present for designs supporting DDR3/DDR4 or LPDDR2/LPDDR3/LPDDR4 devices.
 */
#define DDRC_ZQCTL0_SHADOW_DIS_AUTO_ZQ(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_ZQCTL0_SHADOW_DIS_AUTO_ZQ_SHIFT)) & DDRC_ZQCTL0_SHADOW_DIS_AUTO_ZQ_MASK)
/*! @} */

/*! @name DFITMG0_SHADOW - [SHADOW] DFI Timing Register 0 */
/*! @{ */
#define DDRC_DFITMG0_SHADOW_DFI_TPHY_WRLAT_MASK  (0x3FU)
#define DDRC_DFITMG0_SHADOW_DFI_TPHY_WRLAT_SHIFT (0U)
/*! dfi_tphy_wrlat - Write latency Number of clocks from the write command to write data enable
 *    (dfi_wrdata_en). This corresponds to the DFI timing parameter tphy_wrlat. Refer to PHY
 *    specification for correct value.Note that, depending on the PHY, if using RDIMM/LRDIMM, it may be
 *    necessary to use the adjusted value of CL in the calculation of tphy_wrlat. This is to compensate for
 *    the extra cycle(s) of latency through the RDIMM/LRDIMM. Unit: DFI clock cycles or DFI PHY
 *    clock cycles, depending on DFITMG0.dfi_wrdata_use_sdr.
 */
#define DDRC_DFITMG0_SHADOW_DFI_TPHY_WRLAT(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFITMG0_SHADOW_DFI_TPHY_WRLAT_SHIFT)) & \
     DDRC_DFITMG0_SHADOW_DFI_TPHY_WRLAT_MASK)
#define DDRC_DFITMG0_SHADOW_DFI_TPHY_WRDATA_MASK  (0x3F00U)
#define DDRC_DFITMG0_SHADOW_DFI_TPHY_WRDATA_SHIFT (8U)
/*! dfi_tphy_wrdata - Specifies the number of clock cycles between when dfi_wrdata_en is asserted to
 *    when the associated write data is driven on the dfi_wrdata signal. This corresponds to the
 *    DFI timing parameter tphy_wrdata. Refer to PHY specification for correct value. Note, max
 *    supported value is 8. Unit: DFI clock cycles or DFI PHY clock cycles, depending on
 *    DFITMG0.dfi_wrdata_use_sdr.
 */
#define DDRC_DFITMG0_SHADOW_DFI_TPHY_WRDATA(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFITMG0_SHADOW_DFI_TPHY_WRDATA_SHIFT)) & \
     DDRC_DFITMG0_SHADOW_DFI_TPHY_WRDATA_MASK)
#define DDRC_DFITMG0_SHADOW_DFI_WRDATA_USE_SDR_MASK  (0x8000U)
#define DDRC_DFITMG0_SHADOW_DFI_WRDATA_USE_SDR_SHIFT (15U)
/*! dfi_wrdata_use_sdr - Defines whether dfi_wrdata_en/dfi_wrdata/dfi_wrdata_mask is generated using
 *    HDR (DFI clock) or SDR (DFI PHY clock) values Selects whether value in DFITMG0.dfi_tphy_wrlat
 *    is in terms of HDR (DFI clock) or SDR (DFI PHY clock) cycles Selects whether value in
 *    DFITMG0.dfi_tphy_wrdata is in terms of HDR (DFI clock) or SDR (DFI PHY clock) cycles - 0 in terms of
 *    HDR (DFI clock) cycles - 1 in terms of SDR (DFI PHY clock) cycles Refer to PHY specification
 *    for correct value.
 */
#define DDRC_DFITMG0_SHADOW_DFI_WRDATA_USE_SDR(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFITMG0_SHADOW_DFI_WRDATA_USE_SDR_SHIFT)) & \
     DDRC_DFITMG0_SHADOW_DFI_WRDATA_USE_SDR_MASK)
#define DDRC_DFITMG0_SHADOW_DFI_T_RDDATA_EN_MASK  (0x7F0000U)
#define DDRC_DFITMG0_SHADOW_DFI_T_RDDATA_EN_SHIFT (16U)
/*! dfi_t_rddata_en - Time from the assertion of a read command on the DFI interface to the
 *    assertion of the dfi_rddata_en signal. Refer to PHY specification for correct value. This corresponds
 *    to the DFI parameter trddata_en. Note that, depending on the PHY, if using RDIMM/LRDIMM, it
 *    may be necessary to use the adjusted value of CL in the calculation of trddata_en. This is to
 *    compensate for the extra cycle(s) of latency through the RDIMM/LRDIMM. Unit: DFI clock cycles or
 *    DFI PHY clock cycles, depending on DFITMG0.dfi_rddata_use_sdr.
 */
#define DDRC_DFITMG0_SHADOW_DFI_T_RDDATA_EN(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFITMG0_SHADOW_DFI_T_RDDATA_EN_SHIFT)) & \
     DDRC_DFITMG0_SHADOW_DFI_T_RDDATA_EN_MASK)
#define DDRC_DFITMG0_SHADOW_DFI_RDDATA_USE_SDR_MASK  (0x800000U)
#define DDRC_DFITMG0_SHADOW_DFI_RDDATA_USE_SDR_SHIFT (23U)
/*! dfi_rddata_use_sdr - Defines whether dfi_rddata_en/dfi_rddata/dfi_rddata_valid is generated
 *    using HDR (DFI clock) or SDR (DFI PHY clock) values. Selects whether value in
 *    DFITMG0.dfi_t_rddata_en is in terms of HDR (DFI clock) or SDR (DFI PHY clock) cycles: - 0 in terms of HDR (DFI
 *    clock) cycles - 1 in terms of SDR (DFI PHY clock) cycles Refer to PHY specification for correct
 *    value.
 */
#define DDRC_DFITMG0_SHADOW_DFI_RDDATA_USE_SDR(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFITMG0_SHADOW_DFI_RDDATA_USE_SDR_SHIFT)) & \
     DDRC_DFITMG0_SHADOW_DFI_RDDATA_USE_SDR_MASK)
#define DDRC_DFITMG0_SHADOW_DFI_T_CTRL_DELAY_MASK  (0x1F000000U)
#define DDRC_DFITMG0_SHADOW_DFI_T_CTRL_DELAY_SHIFT (24U)
/*! dfi_t_ctrl_delay - Specifies the number of DFI clock cycles after an assertion or de-assertion
 *    of the DFI control signals that the control signals at the PHY-DRAM interface reflect the
 *    assertion or de-assertion. If the DFI clock and the memory clock are not phase-aligned, this timing
 *    parameter should be rounded up to the next integer value. Note that if using RDIMM/LRDIMM, it
 *    is necessary to increment this parameter by RDIMM's/LRDIMM's extra cycle of latency in terms
 *    of DFI clock.
 */
#define DDRC_DFITMG0_SHADOW_DFI_T_CTRL_DELAY(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFITMG0_SHADOW_DFI_T_CTRL_DELAY_SHIFT)) & \
     DDRC_DFITMG0_SHADOW_DFI_T_CTRL_DELAY_MASK)
/*! @} */

/*! @name DFITMG1_SHADOW - [SHADOW] DFI Timing Register 1 */
/*! @{ */
#define DDRC_DFITMG1_SHADOW_DFI_T_DRAM_CLK_ENABLE_MASK  (0x1FU)
#define DDRC_DFITMG1_SHADOW_DFI_T_DRAM_CLK_ENABLE_SHIFT (0U)
/*! dfi_t_dram_clk_enable - Specifies the number of DFI clock cycles from the de-assertion of the
 *    dfi_dram_clk_disable signal on the DFI until the first valid rising edge of the clock to the
 *    DRAM memory devices, at the PHY-DRAM boundary. If the DFI clock and the memory clock are not
 *    phase aligned, this timing parameter should be rounded up to the next integer value.
 */
#define DDRC_DFITMG1_SHADOW_DFI_T_DRAM_CLK_ENABLE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFITMG1_SHADOW_DFI_T_DRAM_CLK_ENABLE_SHIFT)) & \
     DDRC_DFITMG1_SHADOW_DFI_T_DRAM_CLK_ENABLE_MASK)
#define DDRC_DFITMG1_SHADOW_DFI_T_DRAM_CLK_DISABLE_MASK  (0x1F00U)
#define DDRC_DFITMG1_SHADOW_DFI_T_DRAM_CLK_DISABLE_SHIFT (8U)
/*! dfi_t_dram_clk_disable - Specifies the number of DFI clock cycles from the assertion of the
 *    dfi_dram_clk_disable signal on the DFI until the clock to the DRAM memory devices, at the PHY-DRAM
 *    boundary, maintains a low value. If the DFI clock and the memory clock are not phase aligned,
 *    this timing parameter should be rounded up to the next integer value.
 */
#define DDRC_DFITMG1_SHADOW_DFI_T_DRAM_CLK_DISABLE(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFITMG1_SHADOW_DFI_T_DRAM_CLK_DISABLE_SHIFT)) & \
     DDRC_DFITMG1_SHADOW_DFI_T_DRAM_CLK_DISABLE_MASK)
#define DDRC_DFITMG1_SHADOW_DFI_T_WRDATA_DELAY_MASK  (0x1F0000U)
#define DDRC_DFITMG1_SHADOW_DFI_T_WRDATA_DELAY_SHIFT (16U)
/*! dfi_t_wrdata_delay - Specifies the number of DFI clock cycles between when the dfi_wrdata_en
 *    signal is asserted and when the corresponding write data transfer is completed on the DRAM bus.
 *    This corresponds to the DFI timing parameter twrdata_delay. Refer to PHY specification for
 *    correct value. For DFI 3.0 PHY, set to twrdata_delay, a new timing parameter introduced in DFI
 *    3.0. For DFI 2.1 PHY, set to tphy_wrdata + (delay of DFI write data to the DRAM). Value to be
 *    programmed is in terms of DFI clocks, not PHY clocks. In FREQ_RATIO=2, divide PHY's value by 2
 *    and round up to next integer. If using DFITMG0.dfi_wrdata_use_sdr=1, add 1 to the value. Unit:
 *    Clocks
 */
#define DDRC_DFITMG1_SHADOW_DFI_T_WRDATA_DELAY(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFITMG1_SHADOW_DFI_T_WRDATA_DELAY_SHIFT)) & \
     DDRC_DFITMG1_SHADOW_DFI_T_WRDATA_DELAY_MASK)
#define DDRC_DFITMG1_SHADOW_DFI_T_PARIN_LAT_MASK  (0x3000000U)
#define DDRC_DFITMG1_SHADOW_DFI_T_PARIN_LAT_SHIFT (24U)
/*! dfi_t_parin_lat - Specifies the number of DFI PHY clock cycles between when the dfi_cs signal is
 *    asserted and when the associated dfi_parity_in signal is driven.
 */
#define DDRC_DFITMG1_SHADOW_DFI_T_PARIN_LAT(x)                                    \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFITMG1_SHADOW_DFI_T_PARIN_LAT_SHIFT)) & \
     DDRC_DFITMG1_SHADOW_DFI_T_PARIN_LAT_MASK)
#define DDRC_DFITMG1_SHADOW_DFI_T_CMD_LAT_MASK  (0xF0000000U)
#define DDRC_DFITMG1_SHADOW_DFI_T_CMD_LAT_SHIFT (28U)
/*! dfi_t_cmd_lat - Specifies the number of DFI PHY clock cycles between when the dfi_cs signal is
 *    asserted and when the associated command is driven. This field is used for CAL mode, should be
 *    set to '0' or the value which matches the CAL mode register setting in the DRAM. If the PHY
 *    can add the latency for CAL mode, this should be set to '0'. Valid Range: 0, 3, 4, 5, 6, and 8
 */
#define DDRC_DFITMG1_SHADOW_DFI_T_CMD_LAT(x) \
    (((uint32_t)(((uint32_t)(x)) << DDRC_DFITMG1_SHADOW_DFI_T_CMD_LAT_SHIFT)) & DDRC_DFITMG1_SHADOW_DFI_T_CMD_LAT_MASK)
/*! @} */

/*! @name DFITMG2_SHADOW - [SHADOW] DFI Timing Register 2 */
/*! @{ */
#define DDRC_DFITMG2_SHADOW_DFI_TPHY_WRCSLAT_MASK  (0x3FU)
#define DDRC_DFITMG2_SHADOW_DFI_TPHY_WRCSLAT_SHIFT (0U)
/*! dfi_tphy_wrcslat - Number of DFI PHY clock cycles between when a write command is sent on the
 *    DFI control interface and 