/*
 * Copyright 2008-2020 NXP
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms.  By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms.  If you do not agree to
 * be bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

#ifndef CRITICAL_H_
#define CRITICAL_H_

#include "fsl_common.h"

/**
 * @addtogroup KL_MODULES_GENERIC
 * @{
 */

/**
 * Sanity check macro (assert-like); enters critical section and hangs if the condition fails
 * @param __cond The condition to check
 */
#define critical_SanityCheck(__cond)                                  \
    if (!(__cond)) {                                            \
        critical_Enter();                                     \
        PERR("[%s:%d] SanityCheck failed", __func__, __LINE__); \
        for (;;) { }                                            \
    }

/**
 * Disable Interrupt to enter critical section
 */
void critical_Enter(void);

/**
 * Enable Interrupt to exit critical section
 */
void critical_Exit(void);

/** @} */

#endif /* CRITICAL_H_ */
