/*
 * Copyright 2015 Freescale
 * Copyright 2016,2019-2020 NXP
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms.  By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms.  If you do not agree to
 * be bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

#ifndef __USB_DEVICE_HID_CONSUMER_CONTROL_H__
#define __USB_DEVICE_HID_CONSUMER_CONTROL_H__

#include <stdint.h>
#include "usb.h"
#include "usb_device_class.h"
//#include "usb_ctrl.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/

typedef struct _usb_device_hid_consumer_control_ctxt
{
    usb_device_handle deviceHandle;
    class_handle_t hidHandle;
    uint8_t *buffer;
    uint8_t idleRate;
} usb_device_hid_consumer_control_ctxt_t;

typedef enum _phUSBHIDReport {
    PHUSB_HID_CLEAR = 0,               /**< No HID. */
    PHUSB_HID_BEGIN = PHUSB_HID_CLEAR, /**< Used as placeholder. */

    PHUSB_HID_VOLUME_INCREMENT, /**< Increment volume. */
    PHUSB_HID_VOLUME_DECREMENT, /**< Decrement volume. */
    PHUSB_HID_NEXT_TRACK,       /**< Next track. */
    PHUSB_HID_PREVIOUS_TRACK,   /**< Previous track. */
    PHUSB_HID_PLAYPAUSE,        /**< Play/pause. */

    PHUSB_HID_COUNT,            /**< Number of elements. */
} usbHIDReport_t;

/*******************************************************************************
 * API
 ******************************************************************************/

/**
 * Send a USB HID event to the USB host
 *
 * @param event HID event to send
 * @return kStatus_USB_Success or error (previous request still busy, not attached, ...).
 */
usb_status_t USB_DeviceHidConsumerControlSendEvent(usbHIDReport_t event);

#endif /* __USB_DEVICE_HID_CONSUMER_CONTROL_H__ */
