/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * Copyright 2016-2017 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */


#ifndef _PIN_MUX_H_
#define _PIN_MUX_H_

/***********************************************************************************************************************
 * Definitions
 **********************************************************************************************************************/

/*! @brief Direction type  */
typedef enum _pin_mux_direction
{
    kPIN_MUX_DirectionInput = 0U,        /* Input direction */
    kPIN_MUX_DirectionOutput = 1U,       /* Output direction */
    kPIN_MUX_DirectionInputOrOutput = 2U /* Input or output direction */
} pin_mux_direction_t;

/*! @brief Define the I2C clock pin */
#define BOARD_I2C_CLK_PORT        PORTC
#define BOARD_I2C_CLK_PORT_MODE   kPORT_MuxAlt2
#define BOARD_I2C_CLK_PORT_PIN    10u
#define BOARD_I2C_CLK_GPIO        GPIOC
#define BOARD_I2C_CLK_GPIO_PIN    BOARD_I2C_CLK_PORT_PIN
#define BOARD_I2C_CLK_PORT_CLOCK  kCLOCK_PortC

/*! @brief Define the I2C data pin */
#define BOARD_I2C_DATA_PORT        PORTC
#define BOARD_I2C_DATA_PORT_MODE   kPORT_MuxAlt2
#define BOARD_I2C_DATA_PORT_PIN    11u
#define BOARD_I2C_DATA_GPIO        GPIOC
#define BOARD_I2C_DATA_GPIO_PIN    BOARD_I2C_DATA_PORT_PIN
#define BOARD_I2C_DATA_PORT_CLOCK  kCLOCK_PortC


/*!
 * @addtogroup pin_mux
 * @{
 */

/***********************************************************************************************************************
 * API
 **********************************************************************************************************************/

#if defined(__cplusplus)
extern "C" {
#endif


#define SOPT5_LPUART0RXSRC_LPUART_RX 0x00u /*!<@brief LPUART0 Receive Data Source Select: LPUART_RX pin */
#define SOPT5_LPUART0TXSRC_LPUART_TX 0x00u /*!<@brief LPUART0 Transmit Data Source Select: LPUART0_TX pin */

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitPins(void);

#if defined(__cplusplus)
}
#endif

/*!
 * @}
 */
#endif /* _PIN_MUX_H_ */

/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
