/*
 * Copyright (c) 2010-2016, Freescale Semiconductor, Inc.
 * Copyright (c) 2016-2021, NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#ifndef __METERINGINTERFACE3PH_H
#define __METERINGINTERFACE3PH_H

/*******************************************************************************
 * Definitions
 ******************************************************************************/
//#define NSAMPLES 3000
#define NSAMPLES 6000
#define METERCONSTANT 1600

#define ENERSIGN 0xDEADBEEF

#define NOMET_TO (8)

#define nBUFFERS 2
#define SECSIN1HR 3600
#define POWERTOENERGY      (74.56540444) //(46.603375)

#define MAXUNITSIN15MINS   (7)   

#define CALIBLED_COMPARE      0x0A3D70A3

#define ONCOUNTS 20

#if (NSAMPLES==1500)
#define RPH_DELAY 0
#define YPH_DELAY 240
#define BPH_DELAY 480
#define NEU_DELAY 0
#define QCYCLEFACTOR 0.00066666
#endif
#if (NSAMPLES==3000)
#define RPH_DELAY 0
#define YPH_DELAY 120
#define BPH_DELAY 240
#define NEU_DELAY 0
#define QCYCLEFACTOR 0.000333333
#endif
#if (NSAMPLES==6000)
#define RPH_DELAY 0
#define YPH_DELAY 60
#define BPH_DELAY 120
#define NEU_DELAY 0
#define QCYCLEFACTOR 0.0001666666
#endif

#define MAXPOWER (240.0*3.0*100.0)

#define PERIOD_ACCUMULATION_CYCLES 20
#define TMR_CNTS_50HZ (BUS_CLOCK/FREQ_COUNTER_DIV/50)

#define IOVERLOAD 91.0f
#define VBASIC    240.0f

typedef enum
{
  SYNC_V1 = 0x00,
  SYNC_V2 = 0x01,
  SYNC_V3 = 0x02,
  SYNC_TRYING_V1 = 0x10,
  SYNC_TRYING_V2 = 0x11,
  SYNC_TRYING_V3 = 0x12,
  SYNC_NONE = 0xFF
}SYNC;

/*******************************************************************************
* Prototypes
******************************************************************************/   
extern uint8  NoMetTO;
extern uint8  ResetPLL;
extern uint8  StopMetering;
extern uint8  SyncVChl;
extern uint8  PhaseSequence;

extern uint16 Syncing;

extern uint32 IThisMetActEnergy;
extern uint32 IThisMetReactEnergy;
extern uint8  nZCurs;
extern uint32 ActAccumulator;
extern uint32 ReactAccumulator;

/******************************************************************************
 * public function prototypes                                                 *
 ******************************************************************************/
extern void ClearSums3Ph(void);
extern void InitEnergies(void);
extern void ReadBuckets(void);
extern void CheckEnergies(void);
extern void BackupEnergies(void);             
extern void IncEnerReg(uint8 EnerType);
extern void DoSyncing(void);

extern void MeteringInit(void);
extern void StopMeteringProcess(void);
extern void CheckForWakeupSources(void);
#endif /* __METERINGINTERFACE3PH_H */
