/*
 * Copyright (c) 2018-2021, NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#include "stdio.h"
#include "Defines.h"
#include "ComPortDriver.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*******************************************************************************
* Prototypes
******************************************************************************/
/* command set specific to OEM begin */
/* update commands as per OEM choice */
char cmdunlock[] = "nxpunlock";
const char cmdgcsm[] = "nxpgcsm";
const char cmdgsr[] = "nxpgsr";
const char cmdgln[] = "nxpgln";
const char cmdgpcb[] = "nxpgpcb";
const char cmdgnv256[] = "nxpgnv256";
const char cmdgnv128[] = "nxpgnv128";
const char cmdgnv16[] = "nxpgnv16";
const char cmdginst[] = "nxpginst";
const char cmdsmm[] = "nxpsmm";
const char cmdsbm[] = "nxpsbm";
const char cmdsmdr[] = "nxpsmdr";
const char cmdssr[] = "nxpssr";
const char cmdsln[] = "nxpsln";
const char cmdspcb[] = "nxpspcb";
const char cmdgrtc[] = "nxpgrtc";
const char cmdsrtc[] = "nxpsrtc";
const char cmdsbp[] = "nxpsbp";
const char cmdmer[] = "nxpmer";
const char cmdscall[] = "nxpscall";
const char cmdcalp[] = "nxpcalp";
const char cmdcaln[] = "nxpcaln";
const char cmddcal[] = "nxpdcal";
const char cmdrtccomps[] = "nxprtccomps";
const char cmdrtccompg[] = "nxprtccompg";
const char cmdsignin[] = "nxpsignin";
const char cmdfwuinit[] = "nxpfwuinit";
const char cmdctompd[] = "nxpctompd";
const char cmdfwuhdr[] = "nxpfwuhdr";
const char cmdfwutx[] = "nxpfwutx";
const char cmdfwuver[] = "nxpfwuver";
const char cmdfwuact[] = "nxpfwuact";
const char cmdfwusts[] = "nxpfwusts";

const sidecommand_t metercommand[] = 
{
  /* #    size    cmd_string */
  /* 0 */   {9, cmdunlock},               /* unlock communiction, time bounded */
  /* 1 */   {7, cmdgcsm},                 /* get checksum of the metering fw */ 
  /* 2 */   {6, cmdgsr},                  /* get meter serial no. */
  /* 3 */   {6, cmdgln},                  /* get meter lot no. */
  /* 4 */   {7, cmdgpcb},                 /* get PCB no. */
  /* 5 */   {9, cmdgnv256},               /* read 256 bytes form NV memory */
  /* 6 */   {9, cmdgnv128},               /* read 128 bytes form NV memory */
  /* 7 */   {8, cmdgnv16},                /* read 16 bytes form NV memory */
  /* 8 */   {8, cmdginst},                /* get meter instantaneous param data */
  /* 9 */   {6, cmdsmm},                  /* set meter manufacture year */
  /* 10 */  {6, cmdssr},                  /* set meter serial no */
  /* 11 */  {6, cmdsln},                  /* set meter lot no */
  /* 12 */  {7, cmdspcb},                 /* set meter PCB no */
  /* 13 */  {7, cmdgrtc},                 /* get meter date-time */
  /* 14 */  {7, cmdsrtc},                 /* set meter date-time */
  /* 15 */  {6, cmdmer},                  /* erase meter NV memory unreserved data area */
  /* 16 */  {8, cmdscall},                /* set calibration lock */
  /* 17 */  {7, cmdcalp},                 /* start meter calibration for phase */
  /* 18 */  {7, cmdcaln},                 /* start meter calibration for neutral */
  /* 19 */  {6, cmddcal},                 /* restore meter default calibration */
  /* 20 */  {11, cmdrtccomps},            /* set RTC compensation */  
  /* 21 */  {11, cmdrtccompg},            /* get RTC compensation */
  /* 22 */  {9, cmdsignin},               /* sign in command */
  /* 23 */  {9, cmdctompd},               /* sign in client to meter payload */
  /* 24 */  {10, cmdfwuinit},             /* Initiate firmware image transfer */  
  /* 25 */  {9, cmdfwuhdr},               /* Header of firmware image */    
  /* 26 */  {8, cmdfwutx},                /* firmware image transfer */  
  /* 27 */  {9, cmdfwuver},               /* Verify firmware image */    
  /* 28 */  {9, cmdfwuact},               /* activate firmware image */
  /* 29 */  {9, cmdfwusts},               /* firmware transfer status */
};
/* command set specific to OEM end */
