/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * Copyright 2016-2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */


#include <string.h>
#include "board.h"
#include "stdint.h"
#include "driver_oled_ssd1306.h"
#ifdef SSD1306_USE_I2C_HW
#include "fsl_i2c.h"
#endif
#ifdef SSD1306_USE_SPI_HW
#include "fsl_spi.h"
#endif

#include "fsl_gpio.h"

#include "pin_mux.h"

#include "u8x8.h"

#ifdef SSD1306_USE_I2C_GPIO

/* although we use SW I2C, use the HW pins for later upgrade */
uint8_t u8x8_gpio_and_delay_lpc55(u8x8_t *u8x8, uint8_t msg, uint8_t arg_int, void *arg_ptr)
{
    gpio_pin_config_t   gpioPinConfig;
    gpioPinConfig.pinDirection = kGPIO_DigitalOutput;
    gpioPinConfig.outputLogic  = 1u; /* output high as default. */
    
    switch(msg)
    {
        case U8X8_MSG_GPIO_AND_DELAY_INIT:
            /* only support for software I2C*/
            CLOCK_EnableClock(kCLOCK_Iocon);
            IOCON->PIO[SSD1306_SCL_PORT][SSD1306_SCL_PIN] = (SSD1306_SCL_FUNC  | SSD1306_SCL_PINCFG );
            IOCON->PIO[SSD1306_SDA_PORT][SSD1306_SDA_PIN] = (SSD1306_SDA_FUNC  | SSD1306_SDA_PINCFG );
            CLOCK_DisableClock(kCLOCK_Iocon);
        
            GPIO_PinInit (GPIO, SSD1306_SCL_PORT, SSD1306_SCL_PIN, &gpioPinConfig);
            GPIO_PinInit (GPIO, SSD1306_SDA_PORT, SSD1306_SDA_PIN, &gpioPinConfig);
        break;
        case U8X8_MSG_DELAY_NANO:
        /* not required for SW I2C */
        break;

        case U8X8_MSG_DELAY_10MICRO:
        /* not used at the moment */
        break;

        case U8X8_MSG_DELAY_100NANO:
        /* not used at the moment */
        break;

        case U8X8_MSG_DELAY_MILLI:
            //delay_micro_seconds(arg_int*1000UL);
            SDK_DelayAtLeastUs(arg_int, SDK_DEVICE_MAXIMUM_CPU_CLOCK_FREQUENCY);
        break;
        case U8X8_MSG_DELAY_I2C:
            /* arg_int is 1 or 4: 100KHz (5us) or 400KHz (1.25us) */
            //delay_micro_seconds(arg_int<=2?5:1);
            SDK_DelayAtLeastUs((arg_int<=2?5:1), SDK_DEVICE_MAXIMUM_CPU_CLOCK_FREQUENCY);
        break;

        case U8X8_MSG_GPIO_I2C_CLOCK:
            if ( arg_int == 0 )
            {
                SSD1306_SCL_LOW();
            }
            else
            {
                SSD1306_SCL_HIGH();
            }
        break;
        case U8X8_MSG_GPIO_I2C_DATA:
            if ( arg_int == 0 )
            {
                SSD1306_SDA_LOW();
            }
            else
            {
                SSD1306_SDA_HIGH();
            }
        break;
        /*
        case U8X8_MSG_GPIO_MENU_SELECT:
        u8x8_SetGPIOResult(u8x8, Chip_GPIO_GetPinState(LPC_GPIO, KEY_SELECT_PORT, KEY_SELECT_PIN));
        break;
        case U8X8_MSG_GPIO_MENU_NEXT:
        u8x8_SetGPIOResult(u8x8, Chip_GPIO_GetPinState(LPC_GPIO, KEY_NEXT_PORT, KEY_NEXT_PIN));
        break;
        case U8X8_MSG_GPIO_MENU_PREV:
        u8x8_SetGPIOResult(u8x8, Chip_GPIO_GetPinState(LPC_GPIO, KEY_PREV_PORT, KEY_PREV_PIN));
        break;

        case U8X8_MSG_GPIO_MENU_HOME:
        u8x8_SetGPIOResult(u8x8, Chip_GPIO_GetPinState(LPC_GPIO, KEY_HOME_PORT, KEY_HOME_PIN));
        break;
        */
        default:
            u8x8_SetGPIOResult(u8x8, 1);
        break;
    }
    return 1;
}

#endif

#ifdef SSD1306_USE_I2C_HW
uint8_t u8x8_byte_hw_i2c_lpc55(u8x8_t *u8x8, uint8_t msg, uint8_t arg_int, void *arg_ptr)
{
	i2c_master_config_t iic_ssd1306_config;
	status_t reVal = kStatus_Fail;
	uint8_t addr;

	switch(msg)
	{
		case U8X8_MSG_BYTE_SEND:
	        reVal = I2C_MasterWriteBlocking(SSD1306_I2C, arg_ptr, arg_int, kI2C_TransferNoStopFlag);
	        if (reVal != kStatus_Success)
	        {
	            return -1;
	        }
		break;

		case U8X8_MSG_BYTE_INIT:
		    CLOCK_EnableClock(kCLOCK_Iocon);
		    IOCON->PIO[SSD1306_SCL_PORT][SSD1306_SCL_PIN] = (SSD1306_SCL_FUNC  | SSD1306_SCL_PINCFG );
		    IOCON->PIO[SSD1306_SDA_PORT][SSD1306_SDA_PIN] = (SSD1306_SDA_FUNC  | SSD1306_SDA_PINCFG );
		    CLOCK_DisableClock(kCLOCK_Iocon);

		    /* attach 12 MHz clock to FLEXCOMMx (I2C master) */
		    CLOCK_AttachClk(SSD1306_I2C_CLKATTACH);
		    /* reset FLEXCOMM for I2C */
		    RESET_PeripheralReset(SSD1306_I2C_RST);
		    /*
		     * masterConfig.debugEnable = false;
		     * masterConfig.ignoreAck = false;
		     * masterConfig.pinConfig = kI2C_2PinOpenDrain;
		     * masterConfig.baudRate_Bps = 100000U;
		     * masterConfig.busIdleTimeout_ns = 0;
		     * masterConfig.pinLowTimeout_ns = 0;
		     * masterConfig.sdaGlitchFilterWidth_ns = 0;
		     * masterConfig.sclGlitchFilterWidth_ns = 0;
		     */
		    I2C_MasterGetDefaultConfig(&iic_ssd1306_config);
		    /* Change the default baudrate configuration */
		    iic_ssd1306_config.baudRate_Bps = SSD1306_I2C_RATE;
		    /* Initialize the I2C master peripheral */
		    I2C_MasterInit(SSD1306_I2C, &iic_ssd1306_config, SSD1306_I2C_CLKFREQ);

			//i2c_init(u8x8);
		break;
		case U8X8_MSG_BYTE_SET_DC:
		break;
		case U8X8_MSG_BYTE_START_TRANSFER:
			addr = u8x8_GetI2CAddress(u8x8) >> 1;
			I2C_MasterStart(SSD1306_I2C, addr, kI2C_Write);
		break;
		case U8X8_MSG_BYTE_END_TRANSFER:
	        reVal = I2C_MasterStop(SSD1306_I2C);
	        if (reVal != kStatus_Success)
	        {
	            return -1;
	        }
		break;
		default:
			return 0;
	}
	return 1;
}

/* although we use SW I2C, use the HW pins for later upgrade */
uint8_t u8x8_gpio_and_delay_lpc55(u8x8_t *u8x8, uint8_t msg, uint8_t arg_int, void *arg_ptr)
{
    switch(msg)
    {
        case U8X8_MSG_GPIO_AND_DELAY_INIT:
            /* only support for software I2C*/
        break;
        case U8X8_MSG_DELAY_NANO:
        /* not required for SW I2C */
        break;

        case U8X8_MSG_DELAY_10MICRO:
        /* not used at the moment */
        break;

        case U8X8_MSG_DELAY_100NANO:
        /* not used at the moment */
        break;

        case U8X8_MSG_DELAY_MILLI:
            //delay_micro_seconds(arg_int*1000UL);
            SDK_DelayAtLeastUs(arg_int, SDK_DEVICE_MAXIMUM_CPU_CLOCK_FREQUENCY);
        break;
        case U8X8_MSG_DELAY_I2C:
            /* arg_int is 1 or 4: 100KHz (5us) or 400KHz (1.25us) */
            //delay_micro_seconds(arg_int<=2?5:1);
            SDK_DelayAtLeastUs((arg_int<=2?5:1), SDK_DEVICE_MAXIMUM_CPU_CLOCK_FREQUENCY);
        break;

        case U8X8_MSG_GPIO_I2C_CLOCK:

        break;
        case U8X8_MSG_GPIO_I2C_DATA:

        break;
        /*
        case U8X8_MSG_GPIO_MENU_SELECT:
        u8x8_SetGPIOResult(u8x8, Chip_GPIO_GetPinState(LPC_GPIO, KEY_SELECT_PORT, KEY_SELECT_PIN));
        break;
        case U8X8_MSG_GPIO_MENU_NEXT:
        u8x8_SetGPIOResult(u8x8, Chip_GPIO_GetPinState(LPC_GPIO, KEY_NEXT_PORT, KEY_NEXT_PIN));
        break;
        case U8X8_MSG_GPIO_MENU_PREV:
        u8x8_SetGPIOResult(u8x8, Chip_GPIO_GetPinState(LPC_GPIO, KEY_PREV_PORT, KEY_PREV_PIN));
        break;

        case U8X8_MSG_GPIO_MENU_HOME:
        u8x8_SetGPIOResult(u8x8, Chip_GPIO_GetPinState(LPC_GPIO, KEY_HOME_PORT, KEY_HOME_PIN));
        break;
        */
        default:
            u8x8_SetGPIOResult(u8x8, 1);
        break;
    }
    return 1;
}

#endif

#ifdef SSD1306_USE_SPI_GPIO

/* although we use SW I2C, use the HW pins for later upgrade */
uint8_t u8x8_gpio_and_delay_lpc55(u8x8_t *u8x8, uint8_t msg, uint8_t arg_int, void *arg_ptr)
{
    gpio_pin_config_t   gpioPinConfig;
    gpioPinConfig.pinDirection = kGPIO_DigitalOutput;
    gpioPinConfig.outputLogic  = 1u; /* output high as default. */
    uint32_t i, j;
    switch(msg)
    {
        case U8X8_MSG_GPIO_AND_DELAY_INIT:
            /* only support for software I2C*/
            CLOCK_EnableClock(kCLOCK_Iocon);
            IOCON->PIO[SSD1306_SCK_PORT][SSD1306_SCK_PIN]   = (SSD1306_SCK_FUNC  | SSD1306_SCK_PINCFG );
            IOCON->PIO[SSD1306_MOSI_PORT][SSD1306_MOSI_PIN] = (SSD1306_MOSI_FUNC | SSD1306_MOSI_PINCFG );
            IOCON->PIO[SSD1306_RST_PORT][SSD1306_RST_PIN]   = (SSD1306_RST_FUNC  | SSD1306_RST_PINCFG );
            IOCON->PIO[SSD1306_DC_PORT][SSD1306_DC_PIN]     = (SSD1306_DC_FUNC   | SSD1306_DC_PINCFG );
            IOCON->PIO[SSD1306_CS_PORT][SSD1306_CS_PIN]     = (SSD1306_CS_FUNC   | SSD1306_CS_PINCFG );
            CLOCK_DisableClock(kCLOCK_Iocon);

            GPIO_PinInit (GPIO, SSD1306_SCK_PORT,  SSD1306_SCK_PIN,  &gpioPinConfig);
            GPIO_PinInit (GPIO, SSD1306_MOSI_PORT, SSD1306_MOSI_PIN, &gpioPinConfig);
            GPIO_PinInit (GPIO, SSD1306_RST_PORT,  SSD1306_RST_PIN,  &gpioPinConfig);
            GPIO_PinInit (GPIO, SSD1306_DC_PORT,   SSD1306_DC_PIN,   &gpioPinConfig);
            GPIO_PinInit (GPIO, SSD1306_CS_PORT,   SSD1306_CS_PIN,   &gpioPinConfig);
        break;
        case U8X8_MSG_DELAY_NANO:
        	for(i=0; i<10; i++);
        break;

        case U8X8_MSG_DELAY_10MICRO:
        	for(i=0; i<10; i++)
        		for(j=0; j<100000; j++);
        break;

        case U8X8_MSG_DELAY_100NANO:
        	for(i=0; i<10; i++)
        		for(j=0; j<100; j++);
        break;

        case U8X8_MSG_DELAY_MILLI:
            //delay_micro_seconds(arg_int*1000UL);
            SDK_DelayAtLeastUs(arg_int, SDK_DEVICE_MAXIMUM_CPU_CLOCK_FREQUENCY);
        break;
        case U8X8_MSG_DELAY_I2C:
            /* arg_int is 1 or 4: 100KHz (5us) or 400KHz (1.25us) */
            //delay_micro_seconds(arg_int<=2?5:1);
            SDK_DelayAtLeastUs((arg_int<=2?5:1), SDK_DEVICE_MAXIMUM_CPU_CLOCK_FREQUENCY);
        break;

        case U8X8_MSG_GPIO_DC:
            if ( arg_int == 0 )
            {
                SSD1306_DC_LOW();
            }
            else
            {
                SSD1306_DC_HIGH();
            }
        break;

        case U8X8_MSG_GPIO_CS:
            if ( arg_int == 0 )
            {
                SSD1306_CS_LOW();
            }
            else
            {
                SSD1306_CS_HIGH();
            }
        break;

        case U8X8_MSG_GPIO_RESET:
            if ( arg_int == 0 )
            {
                SSD1306_RST_LOW();
            }
            else
            {
                SSD1306_RST_HIGH();
            }
        break;

        case U8X8_MSG_GPIO_SPI_CLOCK:
            if ( arg_int == 0 )
            {
                SSD1306_SCK_LOW();
            }
            else
            {
                SSD1306_SCK_HIGH();
            }
        break;

        case U8X8_MSG_GPIO_SPI_DATA:
            if ( arg_int == 0 )
            {
                SSD1306_MOSI_LOW();
            }
            else
            {
                SSD1306_MOSI_HIGH();
            }
        break;
        /*
        case U8X8_MSG_GPIO_MENU_SELECT:
        u8x8_SetGPIOResult(u8x8, Chip_GPIO_GetPinState(LPC_GPIO, KEY_SELECT_PORT, KEY_SELECT_PIN));
        break;
        case U8X8_MSG_GPIO_MENU_NEXT:
        u8x8_SetGPIOResult(u8x8, Chip_GPIO_GetPinState(LPC_GPIO, KEY_NEXT_PORT, KEY_NEXT_PIN));
        break;
        case U8X8_MSG_GPIO_MENU_PREV:
        u8x8_SetGPIOResult(u8x8, Chip_GPIO_GetPinState(LPC_GPIO, KEY_PREV_PORT, KEY_PREV_PIN));
        break;

        case U8X8_MSG_GPIO_MENU_HOME:
        u8x8_SetGPIOResult(u8x8, Chip_GPIO_GetPinState(LPC_GPIO, KEY_HOME_PORT, KEY_HOME_PIN));
        break;
        */
        default:
            u8x8_SetGPIOResult(u8x8, 1);
        break;
    }
    return 1;
}

#endif

#ifdef SSD1306_USE_SPI_HW

uint8_t u8x8_byte_4wire_hw_spi_lpc55(u8x8_t *u8x8, uint8_t msg, uint8_t arg_int, void *arg_ptr)
{
	uint8_t i, b;
	uint8_t *data;
	uint8_t takeover_edge = u8x8_GetSPIClockPhase(u8x8);
	uint8_t not_takeover_edge = 1 - takeover_edge;
	spi_master_config_t oledSpiConfig;
	uint32_t temp;

	switch(msg)
	{
		case U8X8_MSG_BYTE_SEND:
			data = (uint8_t *)arg_ptr;
			while( arg_int > 0 )
			{
				b = *data;
				data++;
				arg_int--;

				SSD1306_SPI->FIFOWR = b | 0x07300000;
			    /* wait if TX FIFO of previous transfer is not empty */
			    while ((SSD1306_SPI->FIFOSTAT & SPI_FIFOSTAT_RXNOTEMPTY_MASK) == 0) {
			    }
			    temp = (SSD1306_SPI->FIFORD)&0x000000FF;
			}
		break;

		case U8X8_MSG_BYTE_INIT:
			/* disable chipselect */
			u8x8_gpio_SetCS(u8x8, u8x8->display_info->chip_disable_level);
			/* no wait required here */

			/* for SPI: setup correct level of the clock signal */
			u8x8_gpio_SetSPIClock(u8x8, u8x8_GetSPIClockPhase(u8x8));

		    CLOCK_AttachClk(SSD1306_SPI_CLKATTACH);   /* attach clock source to HSLSPI */
		    RESET_PeripheralReset(SSD1306_SPI_RST);   /* reset FLEXCOMM for SPI */

		    /* SPI init */
		    SPI_MasterGetDefaultConfig(&oledSpiConfig);
		    oledSpiConfig.sselNum = (spi_ssel_t)0;
		    oledSpiConfig.sselPol = (spi_spol_t)kSPI_SpolActiveAllLow;
		    oledSpiConfig.baudRate_Bps = SSD1306_SPI_RATE;
		    SPI_MasterInit(SSD1306_SPI, &oledSpiConfig, CLOCK_GetHsLspiClkFreq());

		break;
		case U8X8_MSG_BYTE_SET_DC:
			u8x8_gpio_SetDC(u8x8, arg_int);
		break;
		case U8X8_MSG_BYTE_START_TRANSFER:
			u8x8_gpio_SetCS(u8x8, u8x8->display_info->chip_enable_level);
			u8x8->gpio_and_delay_cb(u8x8, U8X8_MSG_DELAY_NANO, u8x8->display_info->post_chip_enable_wait_ns, NULL);
		break;
		case U8X8_MSG_BYTE_END_TRANSFER:
			u8x8->gpio_and_delay_cb(u8x8, U8X8_MSG_DELAY_NANO, u8x8->display_info->pre_chip_disable_wait_ns, NULL);
			u8x8_gpio_SetCS(u8x8, u8x8->display_info->chip_disable_level);
		break;
		default:
		return 0;
	}
	return 1;
}


/* although we use SW I2C, use the HW pins for later upgrade */
uint8_t u8x8_gpio_and_delay_lpc55(u8x8_t *u8x8, uint8_t msg, uint8_t arg_int, void *arg_ptr)
{
    gpio_pin_config_t   gpioPinConfig;
    gpioPinConfig.pinDirection = kGPIO_DigitalOutput;
    gpioPinConfig.outputLogic  = 1u; /* output high as default. */
    uint32_t i, j;
    switch(msg)
    {
        case U8X8_MSG_GPIO_AND_DELAY_INIT:
            /* only support for software I2C*/
            CLOCK_EnableClock(kCLOCK_Iocon);
            IOCON->PIO[SSD1306_SCK_PORT][SSD1306_SCK_PIN]   = (SSD1306_SCK_FUNC  | SSD1306_SCK_PINCFG );
            IOCON->PIO[SSD1306_MOSI_PORT][SSD1306_MOSI_PIN] = (SSD1306_MOSI_FUNC | SSD1306_MOSI_PINCFG );
            IOCON->PIO[SSD1306_RST_PORT][SSD1306_RST_PIN]   = (SSD1306_RST_FUNC  | SSD1306_RST_PINCFG );
            IOCON->PIO[SSD1306_DC_PORT][SSD1306_DC_PIN]     = (SSD1306_DC_FUNC   | SSD1306_DC_PINCFG );
            IOCON->PIO[SSD1306_CS_PORT][SSD1306_CS_PIN]     = (SSD1306_CS_FUNC   | SSD1306_CS_PINCFG );
            CLOCK_DisableClock(kCLOCK_Iocon);

            GPIO_PinInit (GPIO, SSD1306_RST_PORT,  SSD1306_RST_PIN,  &gpioPinConfig);
            GPIO_PinInit (GPIO, SSD1306_DC_PORT,   SSD1306_DC_PIN,   &gpioPinConfig);
            GPIO_PinInit (GPIO, SSD1306_CS_PORT,   SSD1306_CS_PIN,   &gpioPinConfig);

        break;
        case U8X8_MSG_DELAY_NANO:
        	for(i=0; i<10; i++);
        break;

        case U8X8_MSG_DELAY_10MICRO:
        	for(i=0; i<10; i++)
        		for(j=0; j<100000; j++);
        break;

        case U8X8_MSG_DELAY_100NANO:
        	for(i=0; i<10; i++)
        		for(j=0; j<100; j++);
        break;

        case U8X8_MSG_DELAY_MILLI:
            //delay_micro_seconds(arg_int*1000UL);
            SDK_DelayAtLeastUs(arg_int, SDK_DEVICE_MAXIMUM_CPU_CLOCK_FREQUENCY);
        break;

        case U8X8_MSG_GPIO_DC:
            if ( arg_int == 0 )
            {
                SSD1306_DC_LOW();
            }
            else
            {
                SSD1306_DC_HIGH();
            }
        break;

        case U8X8_MSG_GPIO_CS:
            if ( arg_int == 0 )
            {
                SSD1306_CS_LOW();
            }
            else
            {
                SSD1306_CS_HIGH();
            }
        break;

        case U8X8_MSG_GPIO_RESET:
            if ( arg_int == 0 )
            {
                SSD1306_RST_LOW();
            }
            else
            {
                SSD1306_RST_HIGH();
            }
        break;
        /*
        case U8X8_MSG_GPIO_MENU_SELECT:
        u8x8_SetGPIOResult(u8x8, Chip_GPIO_GetPinState(LPC_GPIO, KEY_SELECT_PORT, KEY_SELECT_PIN));
        break;
        case U8X8_MSG_GPIO_MENU_NEXT:
        u8x8_SetGPIOResult(u8x8, Chip_GPIO_GetPinState(LPC_GPIO, KEY_NEXT_PORT, KEY_NEXT_PIN));
        break;
        case U8X8_MSG_GPIO_MENU_PREV:
        u8x8_SetGPIOResult(u8x8, Chip_GPIO_GetPinState(LPC_GPIO, KEY_PREV_PORT, KEY_PREV_PIN));
        break;

        case U8X8_MSG_GPIO_MENU_HOME:
        u8x8_SetGPIOResult(u8x8, Chip_GPIO_GetPinState(LPC_GPIO, KEY_HOME_PORT, KEY_HOME_PIN));
        break;
        */
        default:
            u8x8_SetGPIOResult(u8x8, 1);
        break;
    }
    return 1;
}

#endif


// end file
