/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * Copyright (c) 2016-2021, NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#ifndef _CALIBRATION1PH_H        /* prevent duplicated includes*/
#define _CALIBRATION1PH_H

#include "types.h"
#include "Metering1Ph.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/
#define CALIBACCUMCYCLES 6
#define CALIBDONE    0xABCDEFAB
#define CALIBNOTDONE 0xBEEFDEAD
#define CALIBSTATSWRBATT 0xA5
#define CALIBDONEBYT 0xA5

#define CALIBLOCK 0xA5A5
  
/** Updated Calibration Parameters, only during Factory Calibration */
typedef enum
{
  CALIB_PHASE,
  CALIB_NEUTRAL,
  nCALIB_ELEMENTS
} CALIB_ELEMENTS;

typedef enum
{
  CALIBPH_RUN = 0x10,
  CALIBPH_LPR,
  CALIBPH_SWR,
  CALIBNU_RUN = 0x20,
  CALIBNU_LPR,
  CALIBNU_SWR,
} CALIB_STATE;

typedef struct
{
  uint32 CalibSign;             /*!< Defines calibration status */
  float FrequencyCoeff;         /*!< Frequency coefficient for calibration */
  float VCoeff;                 /*!< Calibration Voltage coefficient */
  float ICoeff[nCURRENTS];      /*!< Calibration Current coefficient with gain enabled */
  float ActPowerCoeff[nCURRENTS];/*!< Phase active power coefficient */
  float PhAngle[nCURRENTS];     /*!< Phase error */
  float VFCoeff;                /*!< Calibration Voltage coefficient fundamental */
  float IFCoeff[nCURRENTS];     /*!< Calibration Current coefficient fundamental */
  float ICoeff_LP;              /*!< Calibration Current coefficient with gain disabled */
  float ActPowerCoeff_LP;       /*!< Calibration power coefficient with gain disabled */
  int8 RTCCompValue;            /*!< RTC crystal compensation value */
  uint8 RTCCompInterval;        /*!< RTC crystal compensation interval */
  uint8 PhCalibDone;            /*!< Phase calibration done */
  uint8 NuCalibDone;            /*!< Neutral calibration done */
  uint16 CRC;                   /*!< CRC */
}tCalibStruct1Ph;

typedef enum
{
  CALIB_SETUP,
  CALIB_ANGLEACCUMULATE,
  CALIB_ANGLEAPPLY,
  CALIB_ACCUMULATE,
  CALIB_APPLY,
  CALIB_SETUP_LP,
  CALIB_ACCUMULATE_LP,
  CALIB_APPLY_LP,
  CALIB_MEMWRITE,
  CALIB_COMPLETE
} CALIBSTEPS;

typedef enum
{
  CALIBSTATE_IDLE,
  CALIBSTATE_PROGRESS,
  CALIBSTATE_COMPLETE
} CALIBSTATE;

typedef struct
{
  float VSum;
  float ISum;
  float ActPowerSums;
  float PhAngle;
  float Frequency;
  float VfSum;
  float IfSum;
} tCalibSums1Ph;

typedef struct
{
  float Voltage;        /*!< Calibration voltage - application to load */
  float Current;        /*!< Calibration current - application to load */
  float PhAngle;        /*!< Calibration Phase angle in radians - application to load */
  float PowerFactor;    /*!< Calibration voltage - application to load */
  float Frequency;      /*!< Calibration frequency - application to load */
  uint8 CalibPhase;     /*!< Calibration CURRENT_PHASE or CURRENT_NEUTRAL - application to load */
} tCalibPoint1Ph;

typedef enum
{
  CALIBLOCATION_MAIN,
  CALIBLOCATION_BKUP
} CALIBLOCATIONS;

/*******************************************************************************
* Prototypes
******************************************************************************/
extern uint8  CalibStep1Ph;
extern tCalibStruct1Ph CalibStruct1Ph;
extern tCalibSums1Ph CalibSums1Ph;
extern tCalibPoint1Ph CalibPoint1Ph;
extern tCalibStruct1Ph *PFlashCalibStruct;

extern void DoCalibration1Ph(tCalibPoint1Ph  *calibpoint);
extern void RestoreDefCalib(void);

#endif /* _CALIBRATION_H */
