/*
 * Copyright 2017 NXP
 * All rights reserved.
 *
 * 
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef __WIFI_SHIELD_GT202_H__
#define __WIFI_SHIELD_GT202_H__

#include "fsl_port.h"
#include "wifi_common.h"
#include "pin_mux.h"

/* This file cannot be included directly in common code, it must pass through "wifi_shield.h" */
#ifndef WIFISHIELD_ENABLED
#   define WIFISHIELD_ENABLED
#else
#   error "Other WiFi shield is already enabled !"
#endif

/* Pinmux function, generated by pinmuxtool */
#define WIFISHIELD_PINMUX_INIT BOARD_InitGT202Shield

/* WLAN_IRQ signal */
#define WIFISHIELD_WLAN_IRQn (PORTC_IRQn)
#define WIFISHIELD_WLAN_ISR PORTC_IRQHandler
#define WIFISHIELD_WLAN_IRQ_DIRECTION (BOARD_INITGT202SHIELD_IRQ_DIRECTION)
#define WIFISHIELD_WLAN_IRQ_PORT (BOARD_INITGT202SHIELD_IRQ_PORT)
#define WIFISHIELD_WLAN_IRQ_GPIO (BOARD_INITGT202SHIELD_IRQ_GPIO)
#define WIFISHIELD_WLAN_IRQ_PIN (BOARD_INITGT202SHIELD_IRQ_GPIO_PIN)

/* WLAN_PWRON (PWRDWN) signal */
#define WIFISHIELD_WLAN_PWRON_DIRECTION (BOARD_INITGT202SHIELD_PWRON_DIRECTION)
#define WIFISHIELD_WLAN_PWRON_PORT (BOARD_INITGT202SHIELD_PWRON_PORT)
#define WIFISHIELD_WLAN_PWRON_GPIO (BOARD_INITGT202SHIELD_PWRON_GPIO)
#define WIFISHIELD_WLAN_PWRON_PIN (BOARD_INITGT202SHIELD_PWRON_GPIO_PIN)

/* SPI settings */
#define WIFISHIELD_SPI (SPI1)
#define WIFISHIELD_SPI_INIT_CS (kDSPI_Pcs0)
#define WIFISHIELD_SPI_XFER_CS (kDSPI_MasterPcs0)
#define WIFISHIELD_SPI_CLOCKSRC (kCLOCK_BusClk)
#define WIFISHIELD_SPI_BAUDRATE (20000000)
#define WIFISHIELD_SPI_THRESHOLD (8)

/* DMAMUX settings, interconnect SPI with DMA */
#define WIFISHIELD_DMAMUX (DMAMUX0)
#define WIFISHIELD_DMAMUX_RX_REQ (kDmaRequestMux0SPI1)

/* EDMA settings */
#define WIFISHIELD_DMA (DMA0)
#define WIFISHIELD_DMA_RX_CHNL (0)
#define WIFISHIELD_DMA_IM_CHNL (1)
#define WIFISHIELD_DMA_TX_CHNL (2)

#endif
