/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * Copyright 2016-2017 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef _PIN_MUX_H_
#define _PIN_MUX_H_


/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*! @brief Direction type  */
typedef enum _pin_mux_direction
{
  kPIN_MUX_DirectionInput = 0U,         /* Input direction */
  kPIN_MUX_DirectionOutput = 1U,        /* Output direction */
  kPIN_MUX_DirectionInputOrOutput = 2U  /* Input or output direction */
} pin_mux_direction_t;

/*!
 * @addtogroup pin_mux
 * @{
 */

/*******************************************************************************
 * API
 ******************************************************************************/

#if defined(__cplusplus)
extern "C" {
#endif


/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitPins(void);


/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void LPI2C0_InitPins(void);


/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void LPI2C0_DeinitPins(void);


/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void LPI2C1_InitPins(void);


/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void LPI2C1_DeinitPins(void);

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void LPSPI0_InitPins(void);


/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void LPSPI0_DeinitPins(void);


/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void LPSPI1_InitPins(void);


/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void LPSPI1_DeinitPins(void);

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void LPUART0_InitPins(void);


/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void LPUART0_DeinitPins(void);


/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void LPUART1_InitPins(void);


/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void LPUART1_DeinitPins(void);


/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void LPUART2_InitPins(void);


/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void LPUART2_DeinitPins(void);

#if defined(__cplusplus)
}
#endif

/*!
 * @}
 */
#endif /* _PIN_MUX_H_ */

/*******************************************************************************
 * EOF
 ******************************************************************************/
