/*
 * Copyright (c) 2013 - 2015, Freescale Semiconductor, Inc.
 * Copyright 2016-2017 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include "fsl_device_registers.h"
#include "fsl_debug_console.h"
#include "board.h"

#include "pin_mux.h"
#include "clock_config.h"
#include "fsl_mecc.h"
#include "mecc_test.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/


/*******************************************************************************
 * Prototypes
 ******************************************************************************/

/*******************************************************************************
 * Code
 ******************************************************************************/
/*!
 * @brief Main function
 */
   
int main(void)
{
    /* Init board hardware. */
    BOARD_ConfigMPU();
    BOARD_InitPins();
    BOARD_BootClockRUN();
    BOARD_InitDebugConsole();
    
    PRINTF("&SCB->ITCMCR = %x \r\n", &SCB->ITCMCR);
    PRINTF("&SCB->DTCMCR = %x \r\n", &SCB->DTCMCR);
    PRINTF("SCB_ITCMCR_RMW_Msk = %x \r\n", SCB_ITCMCR_RMW_Msk);
    PRINTF("SCB_DTCMCR_RMW_Msk = %x \r\n", SCB_DTCMCR_RMW_Msk);
    
    MECC_example();
    
    while (1)
    {
    }
}











