/*
 * Copyright (c) 2013 - 2015, Freescale Semiconductor, Inc.
 * Copyright 2016-2017 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include "fsl_device_registers.h"
#include "fsl_debug_console.h"
#include "board.h"

#include "pin_mux.h"
#include <stdbool.h>

#include "spifi_flash.h"
#include "spifi_flash_test.h"
/*******************************************************************************
 * Definitions
 ******************************************************************************/


/*******************************************************************************
 * Prototypes
 ******************************************************************************/

/*******************************************************************************
 * Code
 ******************************************************************************/
/*!
 * @brief Main function
 */
int main(void)
{
    char ch;

    /* Init board hardware. */
    /* attach 12 MHz clock to FLEXCOMM0 (debug console) */
    CLOCK_AttachClk(BOARD_DEBUG_UART_CLK_ATTACH);

    BOARD_InitPins();
    BOARD_InitBootClocks();
    BOARD_InitDebugConsole();
    
    spifi_flash_init();             /* Initialization for SPIFI flash */
    spifi_set_memory_mode();        /* Set SPIFI to memory mode */
    spifi_flash_func();             /* Call function allocated at SPIFI flash */

    spifi_set_command_mode();       /* set spifi to command mode */
    spifi_sector_program_test();    /* Call function allocated at RAM to write data to SPIFI flash */
    
    spifi_set_memory_mode();        /* Set SPIFI to memory mode */
    spifi_sector_read_test();       /* Read data from SPIFI flash */
    
    
    
    PRINTF("hello world.\r\n");

    while (1)
    {
        ch = GETCHAR();
        PUTCHAR(ch);
    }
}
