;/*****************************************************************************
; * @file:    startup_LPC802.s
; * @purpose: CMSIS Cortex-M0 Core Device Startup File for the
; *           LPC802
; * @version: 1.0
; * @date:    2018-1-9
; *
; * Copyright 1997-2016 Freescale Semiconductor, Inc.
; * Copyright 2016-2018 NXP
; *
; * SPDX-License-Identifier: BSD-3-Clause
; *
; *------- <<< Use Configuration Wizard in Context Menu >>> ------------------
; *
; *****************************************************************************/


                PRESERVE8
                THUMB

; Vector Table Mapped to Address 0 at Reset
                AREA    RESET, DATA, READONLY
                EXPORT  __Vectors
                IMPORT  |Image$$ARM_LIB_STACK$$ZI$$Limit|

__Vectors       DCD     |Image$$ARM_LIB_STACK$$ZI$$Limit| ; Top of Stack
                DCD     Reset_Handler             ; Reset Handler

                DCD     NMI_Handler
                DCD     HardFault_Handler
                DCD     0
                DCD     0
                DCD     0
__vector_table_0x1c
                DCD     0                         ; Checksum of the first 7 words
                DCD     0
                DCD     0                         ; Enhanced image marker, set to 0x0 for legacy boot
                DCD     0                         ; Pointer to enhanced boot block, set to 0x0 for legacy boot
                DCD     SVC_Handler
                DCD     0
                DCD     0
                DCD     PendSV_Handler
                DCD     SysTick_Handler

                ; External Interrupts
                DCD     SPI0_IRQHandler  ; SPI0 interrupt
                DCD     Reserved17_IRQHandler  ; Reserved interrupt
                DCD     Reserved18_IRQHandler  ; Reserved interrupt
                DCD     USART0_IRQHandler  ; USART0 interrupt
                DCD     USART1_IRQHandler  ; USART1 interrupt
                DCD     Reserved21_IRQHandler  ; Reserved interrupt
                DCD     Reserved22_IRQHandler  ; Reserved interrupt
                DCD     Reserved23_IRQHandler  ; Reserved interrupt
                DCD     I2C0_IRQHandler  ; I2C0 interrupt
                DCD     Reserved25_IRQHandler  ; Reserved interrupt
                DCD     MRT0_IRQHandler  ; Multi-rate timer interrupt
                DCD     CMP_IRQHandler  ; Analog comparator interrupt
                DCD     WDT_IRQHandler  ; Windowed watchdog timer interrupt
                DCD     BOD_IRQHandler  ; BOD interrupts
                DCD     FLASH_IRQHandler  ; flash interrupt
                DCD     WKT_IRQHandler  ; Self-wake-up timer interrupt
                DCD     ADC0_SEQA_IRQHandler  ; ADC0 sequence A completion.
                DCD     ADC0_SEQB_IRQHandler  ; ADC0 sequence B completion.
                DCD     ADC0_THCMP_IRQHandler  ; ADC0 threshold compare and error.
                DCD     ADC0_OVR_IRQHandler  ; ADC0 overrun
                DCD     Reserved36_IRQHandler  ; Reserved interrupt
                DCD     Reserved37_IRQHandler  ; Reserved interrupt
                DCD     Reserved38_IRQHandler  ; Reserved interrupt
                DCD     CTIMER0_IRQHandler  ; Timer interrupt
                DCD     PIN_INT0_IRQHandler  ; Pin interrupt 0 or pattern match engine slice 0 interrupt
                DCD     PIN_INT1_IRQHandler  ; Pin interrupt 1 or pattern match engine slice 1 interrupt
                DCD     PIN_INT2_IRQHandler  ; Pin interrupt 2 or pattern match engine slice 2 interrupt
                DCD     PIN_INT3_IRQHandler  ; Pin interrupt 3 or pattern match engine slice 3 interrupt
                DCD     PIN_INT4_IRQHandler  ; Pin interrupt 4 or pattern match engine slice 4 interrupt
                DCD     PIN_INT5_IRQHandler  ; Pin interrupt 5 or pattern match engine slice 5 interrupt
                DCD     PIN_INT6_IRQHandler  ; Pin interrupt 6 or pattern match engine slice 6 interrupt
                DCD     PIN_INT7_IRQHandler  ; Pin interrupt 7 or pattern match engine slice 7 interrupt

                AREA    |.text|, CODE, READONLY

; Reset Handler
Reset_Handler   PROC
                EXPORT  Reset_Handler               [WEAK]
                IMPORT  SystemInit
                IMPORT  __main

                LDR     r0, =SystemInit
                BLX     r0
                LDR     r0, =__main
                BX      r0
                ENDP

; Dummy Exception Handlers (infinite loops which can be modified)
NMI_Handler     PROC
                EXPORT  NMI_Handler               [WEAK]
                B       .
                ENDP

HardFault_Handler \
                PROC
                EXPORT  HardFault_Handler         [WEAK]
                B       .
                ENDP

SVC_Handler     PROC
                EXPORT  SVC_Handler               [WEAK]
                B       .
                ENDP

PendSV_Handler  PROC
                EXPORT  PendSV_Handler            [WEAK]
                B       .
                ENDP

SysTick_Handler PROC
                EXPORT  SysTick_Handler           [WEAK]
                B       .
                ENDP

SPI0_IRQHandler\
                PROC
                EXPORT     SPI0_IRQHandler        [WEAK]
                LDR        R0, =SPI0_DriverIRQHandler
                BX         R0
                ENDP

Reserved17_IRQHandler\
                PROC
                EXPORT     Reserved17_IRQHandler        [WEAK]
                LDR        R0, =Reserved17_DriverIRQHandler
                BX         R0
                ENDP

Reserved18_IRQHandler\
                PROC
                EXPORT     Reserved18_IRQHandler        [WEAK]
                LDR        R0, =Reserved18_DriverIRQHandler
                BX         R0
                ENDP

USART0_IRQHandler\
                PROC
                EXPORT     USART0_IRQHandler        [WEAK]
                LDR        R0, =USART0_DriverIRQHandler
                BX         R0
                ENDP

USART1_IRQHandler\
                PROC
                EXPORT     USART1_IRQHandler        [WEAK]
                LDR        R0, =USART1_DriverIRQHandler
                BX         R0
                ENDP

Reserved21_IRQHandler\
                PROC
                EXPORT     Reserved21_IRQHandler        [WEAK]
                LDR        R0, =Reserved21_DriverIRQHandler
                BX         R0
                ENDP

Reserved22_IRQHandler\
                PROC
                EXPORT     Reserved22_IRQHandler        [WEAK]
                LDR        R0, =Reserved22_DriverIRQHandler
                BX         R0
                ENDP

Reserved23_IRQHandler\
                PROC
                EXPORT     Reserved23_IRQHandler        [WEAK]
                LDR        R0, =Reserved23_DriverIRQHandler
                BX         R0
                ENDP

I2C0_IRQHandler\
                PROC
                EXPORT     I2C0_IRQHandler        [WEAK]
                LDR        R0, =I2C0_DriverIRQHandler
                BX         R0
                ENDP

Reserved25_IRQHandler\
                PROC
                EXPORT     Reserved25_IRQHandler        [WEAK]
                LDR        R0, =Reserved25_DriverIRQHandler
                BX         R0
                ENDP

MRT0_IRQHandler\
                PROC
                EXPORT     MRT0_IRQHandler        [WEAK]
                LDR        R0, =MRT0_DriverIRQHandler
                BX         R0
                ENDP

CMP_IRQHandler\
                PROC
                EXPORT     CMP_IRQHandler        [WEAK]
                LDR        R0, =CMP_DriverIRQHandler
                BX         R0
                ENDP

WDT_IRQHandler\
                PROC
                EXPORT     WDT_IRQHandler        [WEAK]
                LDR        R0, =WDT_DriverIRQHandler
                BX         R0
                ENDP

BOD_IRQHandler\
                PROC
                EXPORT     BOD_IRQHandler        [WEAK]
                LDR        R0, =BOD_DriverIRQHandler
                BX         R0
                ENDP

FLASH_IRQHandler\
                PROC
                EXPORT     FLASH_IRQHandler        [WEAK]
                LDR        R0, =FLASH_DriverIRQHandler
                BX         R0
                ENDP

WKT_IRQHandler\
                PROC
                EXPORT     WKT_IRQHandler        [WEAK]
                LDR        R0, =WKT_DriverIRQHandler
                BX         R0
                ENDP

ADC0_SEQA_IRQHandler\
                PROC
                EXPORT     ADC0_SEQA_IRQHandler        [WEAK]
                LDR        R0, =ADC0_SEQA_DriverIRQHandler
                BX         R0
                ENDP

ADC0_SEQB_IRQHandler\
                PROC
                EXPORT     ADC0_SEQB_IRQHandler        [WEAK]
                LDR        R0, =ADC0_SEQB_DriverIRQHandler
                BX         R0
                ENDP

ADC0_THCMP_IRQHandler\
                PROC
                EXPORT     ADC0_THCMP_IRQHandler        [WEAK]
                LDR        R0, =ADC0_THCMP_DriverIRQHandler
                BX         R0
                ENDP

ADC0_OVR_IRQHandler\
                PROC
                EXPORT     ADC0_OVR_IRQHandler        [WEAK]
                LDR        R0, =ADC0_OVR_DriverIRQHandler
                BX         R0
                ENDP

Reserved36_IRQHandler\
                PROC
                EXPORT     Reserved36_IRQHandler        [WEAK]
                LDR        R0, =Reserved36_DriverIRQHandler
                BX         R0
                ENDP

Reserved37_IRQHandler\
                PROC
                EXPORT     Reserved37_IRQHandler        [WEAK]
                LDR        R0, =Reserved37_DriverIRQHandler
                BX         R0
                ENDP

Reserved38_IRQHandler\
                PROC
                EXPORT     Reserved38_IRQHandler        [WEAK]
                LDR        R0, =Reserved38_DriverIRQHandler
                BX         R0
                ENDP

CTIMER0_IRQHandler\
                PROC
                EXPORT     CTIMER0_IRQHandler        [WEAK]
                LDR        R0, =CTIMER0_DriverIRQHandler
                BX         R0
                ENDP

PIN_INT0_IRQHandler\
                PROC
                EXPORT     PIN_INT0_IRQHandler        [WEAK]
                LDR        R0, =PIN_INT0_DriverIRQHandler
                BX         R0
                ENDP

PIN_INT1_IRQHandler\
                PROC
                EXPORT     PIN_INT1_IRQHandler        [WEAK]
                LDR        R0, =PIN_INT1_DriverIRQHandler
                BX         R0
                ENDP

PIN_INT2_IRQHandler\
                PROC
                EXPORT     PIN_INT2_IRQHandler        [WEAK]
                LDR        R0, =PIN_INT2_DriverIRQHandler
                BX         R0
                ENDP

PIN_INT3_IRQHandler\
                PROC
                EXPORT     PIN_INT3_IRQHandler        [WEAK]
                LDR        R0, =PIN_INT3_DriverIRQHandler
                BX         R0
                ENDP

PIN_INT4_IRQHandler\
                PROC
                EXPORT     PIN_INT4_IRQHandler        [WEAK]
                LDR        R0, =PIN_INT4_DriverIRQHandler
                BX         R0
                ENDP

PIN_INT5_IRQHandler\
                PROC
                EXPORT     PIN_INT5_IRQHandler        [WEAK]
                LDR        R0, =PIN_INT5_DriverIRQHandler
                BX         R0
                ENDP

PIN_INT6_IRQHandler\
                PROC
                EXPORT     PIN_INT6_IRQHandler        [WEAK]
                LDR        R0, =PIN_INT6_DriverIRQHandler
                BX         R0
                ENDP

PIN_INT7_IRQHandler\
                PROC
                EXPORT     PIN_INT7_IRQHandler        [WEAK]
                LDR        R0, =PIN_INT7_DriverIRQHandler
                BX         R0
                ENDP

Default_Handler PROC
                EXPORT     SPI0_DriverIRQHandler        [WEAK]
                EXPORT     Reserved17_DriverIRQHandler        [WEAK]
                EXPORT     Reserved18_DriverIRQHandler        [WEAK]
                EXPORT     USART0_DriverIRQHandler        [WEAK]
                EXPORT     USART1_DriverIRQHandler        [WEAK]
                EXPORT     Reserved21_DriverIRQHandler        [WEAK]
                EXPORT     Reserved22_DriverIRQHandler        [WEAK]
                EXPORT     Reserved23_DriverIRQHandler        [WEAK]
                EXPORT     I2C0_DriverIRQHandler        [WEAK]
                EXPORT     Reserved25_DriverIRQHandler        [WEAK]
                EXPORT     MRT0_DriverIRQHandler        [WEAK]
                EXPORT     CMP_DriverIRQHandler        [WEAK]
                EXPORT     WDT_DriverIRQHandler        [WEAK]
                EXPORT     BOD_DriverIRQHandler        [WEAK]
                EXPORT     FLASH_DriverIRQHandler        [WEAK]
                EXPORT     WKT_DriverIRQHandler        [WEAK]
                EXPORT     ADC0_SEQA_DriverIRQHandler        [WEAK]
                EXPORT     ADC0_SEQB_DriverIRQHandler        [WEAK]
                EXPORT     ADC0_THCMP_DriverIRQHandler        [WEAK]
                EXPORT     ADC0_OVR_DriverIRQHandler        [WEAK]
                EXPORT     Reserved36_DriverIRQHandler        [WEAK]
                EXPORT     Reserved37_DriverIRQHandler        [WEAK]
                EXPORT     Reserved38_DriverIRQHandler        [WEAK]
                EXPORT     CTIMER0_DriverIRQHandler        [WEAK]
                EXPORT     PIN_INT0_DriverIRQHandler        [WEAK]
                EXPORT     PIN_INT1_DriverIRQHandler        [WEAK]
                EXPORT     PIN_INT2_DriverIRQHandler        [WEAK]
                EXPORT     PIN_INT3_DriverIRQHandler        [WEAK]
                EXPORT     PIN_INT4_DriverIRQHandler        [WEAK]
                EXPORT     PIN_INT5_DriverIRQHandler        [WEAK]
                EXPORT     PIN_INT6_DriverIRQHandler        [WEAK]
                EXPORT     PIN_INT7_DriverIRQHandler        [WEAK]

SPI0_DriverIRQHandler
Reserved17_DriverIRQHandler
Reserved18_DriverIRQHandler
USART0_DriverIRQHandler
USART1_DriverIRQHandler
Reserved21_DriverIRQHandler
Reserved22_DriverIRQHandler
Reserved23_DriverIRQHandler
I2C0_DriverIRQHandler
Reserved25_DriverIRQHandler
MRT0_DriverIRQHandler
CMP_DriverIRQHandler
WDT_DriverIRQHandler
BOD_DriverIRQHandler
FLASH_DriverIRQHandler
WKT_DriverIRQHandler
ADC0_SEQA_DriverIRQHandler
ADC0_SEQB_DriverIRQHandler
ADC0_THCMP_DriverIRQHandler
ADC0_OVR_DriverIRQHandler
Reserved36_DriverIRQHandler
Reserved37_DriverIRQHandler
Reserved38_DriverIRQHandler
CTIMER0_DriverIRQHandler
PIN_INT0_DriverIRQHandler
PIN_INT1_DriverIRQHandler
PIN_INT2_DriverIRQHandler
PIN_INT3_DriverIRQHandler
PIN_INT4_DriverIRQHandler
PIN_INT5_DriverIRQHandler
PIN_INT6_DriverIRQHandler
PIN_INT7_DriverIRQHandler

                B       .

                ENDP


                ALIGN


                END

