
'''
* Copyright 2020 NXP
* All rights reserved.
*
* SPDX-License-Identifier: BSD-3-Clause
'''

from scipy.io import wavfile
import os
import argparse

parser = argparse.ArgumentParser()
parser.add_argument('--wave', type=str, default=\
                    "male1.wav",
                    help='Get audio wave file')
cmd_args, _ = parser.parse_known_args()
audioFile = cmd_args.wave
# Path to saved model directory
os.chdir("../audio")
 
rate, data = wavfile.read(audioFile)
with open('commands.h', 'w') as fout:
  print('const int16_t WAVE_DATA[]= {', file=fout)
  data.tofile(fout, ',', '%d')
  print('};\n', file=fout)
print(' file commands.h generated..')