﻿/* spi_comm.h */
#ifndef __SPI_COMM_H__
#define __SPI_COMM_H__

#include "fsl_common.h"

typedef enum
{
    eSPI_Speed_1843k = 0u,
    eSPI_Speed_461k = 1u,
    eSPI_Speed_115k = 2u,
    eSPI_Speed_58k = 3u,
    eSPI_Speed_None
} spi_speed_t;

typedef enum
{
    eSPI_CpolCpha_00 = 0u,
    eSPI_CpolCpha_01 = 1u,
    eSPI_CpolCpha_10 = 2u,
    eSPI_CpolCpha_11 = 3u,
} spi_cpolcpha_t;

typedef enum
{
    eSPI_BitOrder_MSB = 0u,
    eSPI_BitOrder_LSB = 1u,
} spi_bitorder_t;

typedef void (*spi_func1_t)(void *param1);

typedef struct
{
    uint8_t *rx_buff;
    uint8_t *tx_buff;
    uint32_t cs_mask;
    uint32_t buff_len;
    uint32_t buff_index;
    spi_func1_t xfer_done_callback;
} spi_master_xfer_handler_t;

void spi_init_master(SPI_Type *base);
void spi_conf_master(SPI_Type *base, spi_speed_t speed, spi_cpolcpha_t cpolcpha, spi_bitorder_t bitorder);
void spi_master_start_xfer(SPI_Type *base, spi_master_xfer_handler_t *xfer_handler);
void spi_master_isr_hook(SPI_Type *base, spi_master_xfer_handler_t *xfer_handler);

#endif /* __SPI_COMM_H__ */

