﻿/* i2c_comm.h */
#ifndef __I2C_COMM_H__
#define __I2C_COMM_H__

#include "fsl_common.h"

#define I2C_DEV_ADDR_WRITE_MASK  0x0
#define I2C_DEV_ADDR_READ_MASK  0x1
#define I2C_DEV_ADDR(x)                  ((x) << 1u)

#define I2C_SLAVE_XFER_DONE_FLAG_RECEIVE_DATA   (1u << 1u)
#define I2C_SLAVE_XFER_DONE_FLAG_TRANSMIT_DATA (1u << 2u)
#define I2C_SLAVE_XFER_DONE_FLAG_RX_OVERFLOW  (1u << 3u)
#define I2C_SLAVE_XFER_DONE_FLAG_TX_OVERFLOW (1u << 4u)

typedef struct
{
    uint32_t flags;
    uint32_t xfer_len;
    uint8_t *xfer_data;
    uint8_t rx_cmd;
} i2c_slave_xfer_done_callback_param_t;

typedef enum
{
    eI2C_Speed_100k = 0u,
    eI2C_Speed_400k = 1u
} i2c_speed_t;

typedef void (*i2c_func1_t)(void *param1);

/* an i2c hardware instance can only be either master or  slave in a time. */

/* master. polling method.*/
void i2c_init_master(I2C_Type * base, i2c_speed_t speed);
void i2c_master_read(I2C_Type * base, uint8_t dev_addr, uint8_t *buff, uint8_t len);
void i2c_master_write(I2C_Type * base, uint8_t dev_addr, uint8_t *buff, uint8_t len);

/* slave. interrupt method.*/
void i2c_init_slave(I2C_Type * base, uint8_t slave_addr, uint8_t *xfer_buff, uint8_t xfer_len);
void i2c_disable_slave(I2C_Type *base);
void i2c_enable_slave(I2C_Type *base);
void i2c_slave_isr_hook(I2C_Type *base);
void i2c_slave_install_xfer_done_callback(I2C_Type *base, i2c_func1_t func);

#endif /* __I2C_COMM_H__ */

