﻿/* gpio_ctrl.c */

#include "gpio_ctrl.h"
#include "fsl_gpio.h"

/*******************************************************************************
* CS pin.
*******************************************************************************/

const uint8_t gpio_cs_pin_gpio_pin[GPIO_CS_PIN_NUM] =
{
    11
};
const uint8_t gpio_cs_pin_iocon_pad[GPIO_CS_PIN_NUM] =
{
    IOCON_INDEX_PIO0_11
};

void gpio_cs_pin_init(uint8_t pins)
{
    for (uint8_t i = 0u; i < GPIO_CS_PIN_NUM; i++)
    {
        if ( 0u != ( pins & (1u << i) ) )
        {
            gpio_cs_pin_set_pin_mode(i, eGPIO_CsPinMode_SpiCsOutput);
        }
    }
}

void gpio_cs_pin_write_1(uint8_t pins)
{
    for (uint8_t i = 0u; i < GPIO_CS_PIN_NUM; i++)
    {
        if ( 0u != ( pins & (1u << i) ) )
        {
            GPIO_PinWrite(GPIO, 0u, gpio_cs_pin_gpio_pin[i], 1u);
        }
    }
}

void gpio_cs_pin_write_0(uint8_t pins)
{
    for (uint8_t i = 0u; i < GPIO_CS_PIN_NUM; i++)
    {
        if ( 0u != ( pins & (1u << i) ) )
        {
            GPIO_PinWrite(GPIO, 0u, gpio_cs_pin_gpio_pin[i], 0u);
        }
    }
}

uint8_t gpio_cs_pin_read(uint8_t pins)
{
    uint8_t tmp8 = 0u;

    for (uint8_t i = 0u; i < GPIO_CS_PIN_NUM; i++)
    {
        if (1u == GPIO_PinRead(GPIO, 0u, gpio_cs_pin_gpio_pin[i]))
        {
            tmp8 |= (1u << i);
        }
    }

    return tmp8;
}

#define IOCON_PIO_RESERVED (1u << 7u)

void gpio_cs_pin_set_pin_mode(uint8_t pin, gpio_cs_pin_mode_t mode)
{
    CLOCK_EnableClock(kCLOCK_Iocon);
    CLOCK_EnableClock(kCLOCK_Gpio0);

    /* iocon. */
    if ( mode == eGPIO_CsPinMode_OpenDrainOutput)
    {
        IOCON->PIO[gpio_cs_pin_iocon_pad[pin]] = IOCON_PIO_MODE(0x2) | IOCON_PIO_RESERVED
                                                                          | IOCON_PIO_OD_MASK ;
    }
    else
    {
        IOCON->PIO[gpio_cs_pin_iocon_pad[pin]] = IOCON_PIO_MODE(0x2) | IOCON_PIO_RESERVED ;
    }

    /* gpio. */
    gpio_pin_config_t pin_config;
    if (mode == eGPIO_CsPinMode_InputOnly)
    {
        pin_config.pinDirection = kGPIO_DigitalInput;
    }
    else
    {
        pin_config.pinDirection = kGPIO_DigitalOutput;
        pin_config.outputLogic = 1u;
    }
    GPIO_PinInit(GPIO, 0u, gpio_cs_pin_gpio_pin[pin], &pin_config);
}

/*******************************************************************************
* INT pin.
*******************************************************************************/

#define CMD_INT_GPIO_PIN  12u
#define CMD_INT_IOCON_PAD IOCON_INDEX_PIO0_12

void gpio_int_pin_init(void)
{
    CLOCK_EnableClock(kCLOCK_Iocon);
    CLOCK_EnableClock(kCLOCK_Gpio0);

    IOCON->PIO[CMD_INT_IOCON_PAD] = IOCON_PIO_MODE(0x2) | IOCON_PIO_RESERVED ;

    gpio_pin_config_t pin_config;
    pin_config.outputLogic = 1u;
    pin_config.pinDirection = kGPIO_DigitalOutput;
    GPIO_PinInit(GPIO, 0u, CMD_INT_GPIO_PIN, &pin_config);
}

void gpio_int_pin_set(void)
{
    GPIO_PinWrite(GPIO, 0u, CMD_INT_GPIO_PIN, 0u);
}

void gpio_int_pin_clear(void)
{
    GPIO_PinWrite(GPIO, 0u, CMD_INT_GPIO_PIN, 1u);
}

/* EOF. */

