/*
 * Copyright 2018, NXP
 * Copyright 2017-2018 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include <stdio.h>

#include "fsl_common.h"

#include "clock_config.h"
#include "pin_mux.h"
#include "board.h"

#include "fsl_clock.h"
#include "fsl_usart.h"

/*******************************************************************************
 * Declerations.
 ******************************************************************************/
status_t BOARD_InitDebugConsole(void);

/*******************************************************************************
 * Variables.
 ******************************************************************************/

/*******************************************************************************
 * Code.
 ******************************************************************************/



void board_init(void)
{
    BOARD_InitBootClocks();
    BOARD_InitPins();
    BOARD_InitDebugConsole();
}

/* Initialize debug console. */
status_t BOARD_InitDebugConsole(void)
{
    CLOCK_Select(kUART0_Clk_From_MainClk);

    usart_config_t usart_config;
    usart_config.baudRate_Bps = 9600u;
    usart_config.enableRx = true;
    usart_config.enableTx = true;
    usart_config.loopback = false;
    usart_config.enableContinuousSCLK = false;
    usart_config.parityMode = kUSART_ParityDisabled;
    usart_config.stopBitCount = kUSART_OneStopBit;
    usart_config.bitCountPerChar = kUSART_8BitsPerChar;
    usart_config.syncMode = kUSART_SyncModeDisabled;
    usart_config.clockPolarity = kUSART_RxSampleOnFallingEdge;
    USART_Init(USART0, &usart_config, CLOCK_GetMainClkFreq() );

    return kStatus_Success;
}

int fputc(int ch, FILE *f)
{
    uint8_t tmp8 = (uint8_t)ch;

    USART_WriteBlocking(USART0, &tmp8, 1u);

    return ch;
}

int fgetc(FILE *f)
{
    uint8_t tmp8;

    USART_ReadBlocking(USART0, &tmp8, 1u);

    return tmp8;
}

/* EOF. */

