#include "../../lvgl.h"

/*******************************************************************************
 * Size: 28 px
 * Bpp: 3
 * Opts: --bpp 3 --size 28 --font Roboto-Regular.woff -r 0x20-0x7F --font FontAwesome5-Solid+Brands+Regular.woff -r 61441,61448,61451,61452,61452,61453,61457,61459,61461,61465,61468,61473,61478,61479,61480,61502,61512,61515,61516,61517,61521,61522,61523,61524,61543,61544,61550,61552,61553,61556,61559,61560,61561,61563,61587,61589,61636,61637,61639,61671,61674,61683,61724,61732,61787,61931,62016,62017,62018,62019,62020,62087,62099,62212,62189,62810,63426,63650 --format lvgl -o lv_font_roboto_28_compressed.c --force-fast-kern-format
 ******************************************************************************/

#ifndef LV_FONT_ROBOTO_28_COMPRESSED
#define LV_FONT_ROBOTO_28_COMPRESSED 1
#endif

#if LV_FONT_ROBOTO_28_COMPRESSED

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t gylph_bitmap[] = {
    /* U+20 " " */

    /* U+21 "!" */
    0xbf, 0x80, 0xff, 0xe3, 0x90, 0x38, 0x81, 0xff,
    0xcf, 0x9b, 0x80, 0x24, 0x7, 0x2d, 0x4, 0x2c,
    0xd0, 0x88,

    /* U+22 "\"" */
    0x3f, 0x7, 0xd8, 0x1f, 0xcc, 0xf, 0xf1, 0x0,
    0x40, 0xf7, 0x2, 0x65, 0x10, 0x51,

    /* U+23 "#" */
    0x3, 0xef, 0xc0, 0x53, 0xb0, 0x3f, 0x20, 0x80,
    0x88, 0x20, 0x7e, 0x20, 0x81, 0x20, 0x80, 0xfd,
    0x86, 0x3, 0xff, 0x84, 0xc3, 0x0, 0x82, 0x3,
    0xf8, 0x82, 0x0, 0x82, 0x7, 0x7f, 0x80, 0x7f,
    0x40, 0xff, 0x10, 0x3f, 0xf8, 0xff, 0xcc, 0x5f,
    0xe0, 0x1f, 0xc4, 0xe, 0x41, 0x0, 0x41, 0x1,
    0xfc, 0x40, 0xc4, 0x60, 0x3f, 0x20, 0x80, 0xb0,
    0x40, 0x77, 0xf5, 0xb, 0xf9, 0xd, 0xf8, 0x81,
    0xff, 0xc7, 0xfe, 0x23, 0xfa, 0x85, 0xfc, 0x40,
    0xe2, 0x6, 0x23, 0x1, 0xf8, 0x84, 0x5, 0x81,
    0x3, 0xf2, 0x4, 0x9, 0x86, 0x7, 0xee, 0x30,
    0x11, 0x4, 0xf, 0xc8, 0x30, 0x4, 0x10, 0x3c,

    /* U+24 "$" */
    0x3, 0xdb, 0x90, 0x3f, 0xfb, 0x33, 0x91, 0xa9,
    0x3, 0x8f, 0x60, 0x65, 0x98, 0x1b, 0x0, 0x9b,
    0x20, 0x8, 0x40, 0x30, 0x15, 0x92, 0x74, 0x5,
    0x1, 0x80, 0x20, 0x32, 0x21, 0x81, 0x88, 0x1e,
    0x40, 0x62, 0x8, 0x1e, 0xb6, 0x1, 0x80, 0x50,
    0x38, 0xa4, 0x0, 0x88, 0x59, 0x81, 0xfd, 0x88,
    0x33, 0xd2, 0x7, 0xda, 0x10, 0xb, 0x50, 0x3e,
    0x7b, 0x18, 0x5, 0xc0, 0xfc, 0x67, 0x40, 0x28,
    0x1f, 0xea, 0x82, 0xa, 0xd0, 0x1f, 0x60, 0x4,
    0x92, 0x10, 0x3c, 0x40, 0x90, 0xa, 0x7, 0xb8,
    0x2, 0x60, 0xd8, 0xd, 0x10, 0x40, 0x38, 0x9,
    0xf6, 0x76, 0x2, 0x80, 0x39, 0x0, 0x24, 0x1,
    0x70, 0x31, 0xbe, 0x0, 0xbe, 0x81, 0xf9, 0x80,
    0x40, 0x7f, 0xf1, 0xc0,

    /* U+25 "%" */
    0x0, 0xf7, 0xcc, 0xf, 0xfe, 0xd, 0x85, 0x19,
    0x40, 0xff, 0x92, 0x1f, 0x79, 0x48, 0x6, 0x84,
    0xd, 0x85, 0x2, 0xa3, 0x1, 0x36, 0xa0, 0x78,
    0x81, 0x10, 0x31, 0x86, 0x1, 0xe2, 0x7, 0xe8,
    0x20, 0x1d, 0x85, 0x2, 0x83, 0x6, 0x94, 0x7,
    0x24, 0x3e, 0xe2, 0x90, 0x41, 0x40, 0xfa, 0xc2,
    0x8c, 0xa2, 0x8a, 0x7, 0xf3, 0xdf, 0x98, 0x4b,
    0x1, 0xff, 0xc3, 0xa2, 0x81, 0xff, 0xc3, 0x82,
    0x0, 0xbf, 0xb2, 0x3, 0xf1, 0x65, 0x8e, 0x8a,
    0x35, 0x81, 0xf7, 0x1c, 0x40, 0xf5, 0xc2, 0x1,
    0xe8, 0x59, 0x8, 0x40, 0x5, 0x4, 0x6, 0x2c,
    0xc0, 0x4, 0xe, 0x20, 0x7b, 0x8e, 0x4, 0x40,
    0xe2, 0x7, 0xcc, 0x81, 0x21, 0x0, 0x14, 0x10,
    0x1b, 0x40, 0x34, 0xf, 0x5c, 0x20, 0x1f, 0xfc,
    0xe, 0x8a, 0x35, 0x80,

    /* U+26 "&" */
    0x3, 0x3d, 0xfb, 0x30, 0x3f, 0xda, 0x10, 0x6,
    0x50, 0x3f, 0x42, 0x1e, 0xc6, 0x12, 0x1, 0xf2,
    0x6, 0x12, 0x84, 0x70, 0x3e, 0x21, 0x1, 0x98,
    0x1f, 0xf1, 0x3, 0x21, 0x80, 0xf9, 0x84, 0x40,
    0x60, 0xc, 0xf, 0xa8, 0xe, 0xb9, 0x18, 0xf,
    0xc6, 0x3, 0x41, 0xe4, 0xf, 0xe4, 0x4, 0x70,
    0x1f, 0xe7, 0x80, 0x8a, 0x3, 0x12, 0x2, 0x70,
    0x2c, 0x45, 0x20, 0xe, 0xc0, 0x28, 0xd, 0x38,
    0x8c, 0x43, 0x3, 0x30, 0x1c, 0xb, 0x80, 0xe3,
    0x2, 0x3, 0x80, 0x20, 0x46, 0x83, 0x98, 0x40,
    0x7f, 0x95, 0x4, 0x4, 0x1, 0x80, 0x40, 0x39,
    0x10, 0x8, 0x9, 0x20, 0x74, 0x80, 0x58, 0x80,
    0x48, 0x5, 0x50, 0x5b, 0xf5, 0x21, 0x91, 0x48,
    0x15, 0xa4, 0x4, 0x5e, 0x9c, 0x7, 0x0,

    /* U+27 "'" */
    0x9d, 0x81, 0xf8, 0x81, 0xcf, 0x32,

    /* U+28 "(" */
    0x3, 0xe2, 0x7, 0xd7, 0x81, 0xea, 0x98, 0x1d,
    0x11, 0xa0, 0x64, 0xc6, 0x3, 0xa0, 0x80, 0x73,
    0x21, 0x81, 0xd4, 0x30, 0x38, 0x90, 0xa0, 0x72,
    0x0, 0x40, 0xec, 0x10, 0x1e, 0x40, 0x81, 0xfb,
    0x81, 0xc4, 0xf, 0xf8, 0x81, 0xff, 0xc5, 0x20,
    0x71, 0x3, 0xfe, 0xe0, 0x79, 0x2, 0x7, 0xb0,
    0x40, 0x79, 0x0, 0x20, 0x71, 0x21, 0x40, 0xf5,
    0xc, 0xf, 0x32, 0x18, 0x1e, 0x82, 0x1, 0xe4,
    0xc5, 0x3, 0xd1, 0x25, 0x3, 0xd5, 0x30, 0x3e,
    0xbc, 0x0,

    /* U+29 ")" */
    0x3, 0xf2, 0xe8, 0xe, 0x62, 0xa0, 0x31, 0xc2,
    0x90, 0x31, 0x63, 0x81, 0xd0, 0x16, 0x7, 0x41,
    0x0, 0xe6, 0x1, 0x81, 0xc8, 0x60, 0x3b, 0x4,
    0x7, 0x20, 0x8, 0xc, 0x40, 0x10, 0x3e, 0xe0,
    0x71, 0x4, 0xf, 0xfe, 0x89, 0x4, 0xf, 0xb8,
    0x18, 0x80, 0x20, 0x64, 0x1, 0x1, 0xb0, 0x40,
    0x72, 0x18, 0xc, 0x80, 0x30, 0x34, 0x10, 0xc,
    0xc9, 0x30, 0x23, 0x7, 0x2, 0x38, 0x52, 0x4,
    0xc5, 0x40, 0x65, 0x90, 0x1c,

    /* U+2A "*" */
    0x3, 0xbf, 0x1, 0xff, 0xd2, 0xa8, 0xf, 0x18,
    0x1a, 0xbe, 0x0, 0x7b, 0x1b, 0x26, 0x43, 0x1,
    0x8, 0x44, 0xa6, 0xc2, 0x0, 0xdf, 0x50, 0x13,
    0x20, 0xb, 0x3, 0xd4, 0x58, 0x38, 0x1d, 0x42,
    0x46, 0x4a, 0x1, 0xea, 0x3, 0x82, 0x6, 0xb8,
    0x8, 0xda, 0x0,

    /* U+2B "+" */
    0x3, 0x8b, 0x60, 0x3f, 0xe5, 0x20, 0x81, 0xff,
    0xf1, 0x4d, 0xee, 0x1, 0x37, 0x95, 0x93, 0x30,
    0x12, 0x77, 0x3, 0xff, 0x85, 0xff, 0x40, 0x1b,
    0xfd, 0x40, 0xff, 0xfd, 0x0,

    /* U+2C "," */
    0xb, 0xf1, 0x3, 0xfe, 0x20, 0x8, 0xa1, 0x84,
    0x44, 0x9, 0x28, 0x0,

    /* U+2D "-" */
    0x3, 0xf4, 0xff, 0xc4, 0xf, 0xc0,

    /* U+2E "." */
    0x13, 0xd0, 0xc, 0x20, 0xc, 0x20,

    /* U+2F "/" */
    0x3, 0xf5, 0xf0, 0xf, 0xc8, 0x50, 0x3e, 0x60,
    0x90, 0x1f, 0x51, 0x0, 0xf8, 0x90, 0x40, 0x7d,
    0x43, 0x3, 0xf3, 0x14, 0xf, 0x90, 0x24, 0x7,
    0xdc, 0x50, 0x3f, 0x20, 0xc0, 0xf9, 0x84, 0x7,
    0xe8, 0x38, 0x1f, 0x20, 0x8, 0xf, 0xb8, 0x60,
    0x7e, 0x42, 0x81, 0xf3, 0x8, 0x81, 0xf5, 0x1c,
    0xf, 0x89, 0x4, 0x7, 0xd4, 0x30, 0x3f, 0x31,
    0x40, 0xf9, 0x2, 0x40, 0x7e, 0x70, 0xf, 0xc0,

    /* U+30 "0" */
    0x2, 0x33, 0x7e, 0xd0, 0xf, 0x2c, 0xc8, 0x2,
    0xf9, 0x2, 0x34, 0x1b, 0xf4, 0x1, 0xc0, 0xa0,
    0xc, 0x81, 0x74, 0x14, 0x1, 0x6, 0x7, 0x22,
    0x38, 0x20, 0x30, 0x1e, 0x41, 0x6, 0x1, 0x81,
    0xee, 0x4, 0x40, 0xff, 0xe2, 0x10, 0x3f, 0x88,
    0x1f, 0xfd, 0xe2, 0x0, 0x81, 0xfc, 0x40, 0xff,
    0xe1, 0x30, 0xc, 0xf, 0x70, 0x22, 0x3, 0x1,
    0xe6, 0x10, 0x6, 0x19, 0x3, 0x20, 0x1c, 0x5,
    0x1, 0x90, 0x7, 0x41, 0x40, 0xd, 0x1, 0x7f,
    0x40, 0x1c, 0xc, 0xb3, 0x20, 0xb, 0xe4, 0x0,

    /* U+31 "1" */
    0x3, 0x8c, 0xe0, 0x4f, 0x63, 0xa, 0xf8, 0x40,
    0xba, 0x6, 0x20, 0x5, 0xec, 0x64, 0x4, 0x82,
    0x7, 0xff, 0xfc, 0xf, 0xfe, 0xf0,

    /* U+32 "2" */
    0x2, 0x57, 0xfb, 0x40, 0x3d, 0x69, 0x1, 0x17,
    0xc8, 0x15, 0x41, 0x6f, 0x98, 0xc, 0x0, 0xa0,
    0xe9, 0x6, 0x40, 0x6, 0x28, 0x8, 0x7, 0x30,
    0x18, 0x10, 0x3f, 0x88, 0x62, 0xfe, 0x3, 0xe2,
    0x10, 0x1f, 0xe2, 0x3, 0x1, 0xfe, 0xe0, 0xa0,
    0x3f, 0xa1, 0x1c, 0xf, 0xe4, 0xc4, 0x20, 0x7e,
    0x54, 0x26, 0x7, 0xe3, 0x42, 0xa0, 0x7e, 0x38,
    0x1a, 0x7, 0xf6, 0x7, 0x1, 0xfd, 0x81, 0xc0,
    0x7f, 0x62, 0x38, 0x1f, 0xd4, 0x8c, 0x40, 0xfc,
    0x90, 0x6, 0xff, 0xf5, 0x3, 0xff, 0x84,

    /* U+33 "3" */
    0x2, 0x57, 0xfb, 0x30, 0x3a, 0xd2, 0x2, 0x33,
    0x1, 0x44, 0x15, 0xf9, 0x83, 0x81, 0x61, 0x54,
    0xc, 0x80, 0x52, 0x0, 0x80, 0x73, 0x1, 0x94,
    0x82, 0x7, 0xf1, 0x6c, 0x7, 0xf7, 0x3, 0xfa,
    0x0, 0x60, 0x7c, 0xab, 0x10, 0xe, 0xbf, 0xaa,
    0x15, 0x81, 0xff, 0x70, 0x3d, 0x7f, 0x66, 0x16,
    0x3, 0xf1, 0x98, 0x16, 0x7, 0xf1, 0x21, 0x4a,
    0x40, 0x3e, 0x60, 0xcb, 0x40, 0x7c, 0xc1, 0xc0,
    0x18, 0x1c, 0x88, 0x4c, 0x89, 0x4, 0x17, 0x40,
    0x41, 0x88, 0x7b, 0xe8, 0x3, 0x1, 0x68, 0x80,
    0x8c, 0xe4, 0x0,

    /* U+34 "4" */
    0x3, 0xfa, 0xfe, 0x40, 0x7f, 0xc9, 0x0, 0xff,
    0xe1, 0x50, 0x3f, 0xf8, 0x54, 0xf, 0xfe, 0x12,
    0x41, 0x40, 0xff, 0xe0, 0x51, 0x18, 0x1f, 0xf5,
    0x5, 0x81, 0xff, 0x24, 0x1c, 0xf, 0xfe, 0x5,
    0xc, 0x81, 0xff, 0x40, 0x60, 0x1f, 0xf2, 0x63,
    0x81, 0xff, 0xc0, 0xa1, 0x90, 0x3f, 0xe8, 0xc,
    0x3, 0xfe, 0x2c, 0x1f, 0xfb, 0x0, 0xbf, 0x83,
    0x3, 0xff, 0x86, 0xbf, 0xfd, 0x80, 0x5f, 0xc0,
    0x7f, 0xfd, 0x40,

    /* U+35 "5" */
    0x7, 0xff, 0xf0, 0x6, 0x7, 0xff, 0x0, 0x80,
    0xb7, 0xf0, 0xe, 0xa, 0x5f, 0x80, 0x10, 0xc0,
    0xff, 0xe0, 0x10, 0x3f, 0xcc, 0x70, 0x4c, 0x7,
    0x88, 0xdf, 0x6b, 0xc0, 0x3c, 0x80, 0xe7, 0x80,
    0xe3, 0xbf, 0x52, 0xd, 0x1, 0xf6, 0x10, 0xb,
    0x10, 0x88, 0x2, 0x7, 0xa0, 0x4, 0x7, 0xf2,
    0x1, 0xc0, 0xff, 0xe0, 0xb8, 0x80, 0xff, 0x67,
    0x0, 0xf2, 0x1, 0xb0, 0x14, 0x7, 0x40, 0x9,
    0x91, 0x59, 0x6, 0x91, 0x0, 0x72, 0x26, 0xf9,
    0x4, 0xc0, 0x1d, 0x8, 0x12, 0xb4, 0x0,

    /* U+36 "6" */
    0x3, 0xca, 0xef, 0x0, 0xf9, 0x7a, 0x88, 0x1f,
    0x9d, 0x0, 0xae, 0x80, 0x72, 0x80, 0xea, 0x88,
    0x1e, 0x80, 0xe2, 0x7, 0xe4, 0x44, 0x3, 0xfd,
    0x81, 0x40, 0x7f, 0x90, 0x46, 0xff, 0x64, 0x6,
    0x21, 0x64, 0x4, 0x6c, 0x3, 0x88, 0x9b, 0xd2,
    0x1a, 0x4, 0xb, 0x32, 0x16, 0x1, 0x0, 0xd0,
    0x81, 0xd0, 0x12, 0x2, 0x20, 0x78, 0x80, 0x60,
    0x44, 0xf, 0x30, 0x22, 0x3, 0x81, 0xe6, 0x6,
    0x41, 0x81, 0xec, 0x1, 0xe, 0x2, 0x1, 0xcc,
    0x20, 0x9, 0x3, 0x84, 0x2c, 0x2, 0x1, 0x54,
    0x1e, 0xf4, 0x8a, 0x40, 0xd6, 0x88, 0x2, 0xf2,
    0x0,

    /* U+37 "7" */
    0xff, 0xff, 0x83, 0x0, 0xff, 0xe0, 0xff, 0xff,
    0x40, 0xc, 0xf, 0xf5, 0xc, 0xf, 0xf2, 0x22,
    0x81, 0xfe, 0xe1, 0x10, 0x3f, 0x8a, 0x10, 0xf,
    0xf4, 0x4, 0x80, 0xfe, 0x28, 0x40, 0x3f, 0xd4,
    0x2, 0x3, 0xfc, 0xc4, 0x3, 0xfc, 0xc0, 0x30,
    0x3f, 0xd0, 0x30, 0x3f, 0xcc, 0x5, 0x3, 0xfd,
    0x42, 0x20, 0x7f, 0x22, 0x38, 0x1f, 0xe8, 0xa,
    0x3, 0xf8, 0x90, 0x80, 0x7f, 0xa0, 0x4, 0x7,
    0xf1, 0x42, 0x1, 0xf8,

    /* U+38 "8" */
    0x2, 0x33, 0x7e, 0xcc, 0xf, 0x3c, 0xc8, 0x3,
    0x39, 0x2, 0x30, 0x5, 0xd8, 0xc0, 0x60, 0x28,
    0x3, 0x22, 0x52, 0x0, 0x30, 0x8, 0x22, 0x6,
    0x60, 0x30, 0x18, 0x81, 0xe2, 0x6, 0x20, 0x81,
    0xe2, 0x8, 0x4, 0x11, 0x3, 0x30, 0x14, 0x4,
    0x23, 0x22, 0x52, 0x3, 0x20, 0x59, 0xb, 0xb1,
    0x87, 0x0, 0xc9, 0x81, 0xe2, 0x6, 0x54, 0xad,
    0xfa, 0x85, 0x80, 0xa8, 0x54, 0x80, 0x5c, 0x1a,
    0x10, 0x8, 0x7, 0x98, 0x40, 0x80, 0x20, 0x7b,
    0x0, 0x20, 0x44, 0xf, 0x10, 0x5, 0x0, 0x80,
    0x7a, 0x2, 0xa, 0xa, 0xa0, 0x56, 0x1, 0x0,
    0x54, 0x15, 0xfa, 0x91, 0x10, 0x15, 0xa4, 0x4,
    0x5e, 0x60, 0x0,

    /* U+39 "9" */
    0x2, 0x57, 0xfa, 0x90, 0x3a, 0x54, 0x4, 0xb4,
    0x2, 0x6c, 0x15, 0xf4, 0x86, 0xc0, 0x20, 0x35,
    0x5, 0x88, 0x81, 0x0, 0xe0, 0x77, 0x0, 0xb0,
    0x2, 0x7, 0x10, 0x18, 0xf, 0xf2, 0x8, 0xf,
    0xfe, 0xf, 0x0, 0x40, 0xfc, 0x58, 0x8, 0x7,
    0x34, 0x8, 0x41, 0x52, 0xc, 0x80, 0x35, 0x21,
    0x6f, 0x99, 0x20, 0xc0, 0x66, 0x4, 0x66, 0x0,
    0x40, 0xa7, 0xf6, 0x60, 0x8c, 0x7, 0xf2, 0x0,
    0x80, 0xfe, 0xa1, 0x1, 0xf8, 0xe0, 0x10, 0xe,
    0x2a, 0x62, 0x29, 0x3, 0x6c, 0xac, 0x1a, 0x80,
    0xf8, 0xab, 0x90, 0x10,

    /* U+3A ":" */
    0x17, 0xc0, 0x83, 0x8, 0x31, 0x7c, 0x3, 0xff,
    0xab, 0x7c, 0x28, 0x32, 0x83,

    /* U+3B ";" */
    0x7, 0x74, 0x11, 0x18, 0x22, 0x30, 0x3b, 0xa0,
    0x3f, 0xfb, 0xdf, 0x98, 0x1e, 0x20, 0x8, 0x60,
    0x18, 0xe0, 0x99, 0xe, 0xb, 0x84, 0x0,

    /* U+3C "<" */
    0x3, 0xfc, 0x69, 0x3, 0xf2, 0xb9, 0x1, 0xf2,
    0xd5, 0x1, 0xf3, 0xd4, 0x83, 0x39, 0x0, 0xfc,
    0x21, 0x6c, 0x60, 0x5e, 0x3, 0x3d, 0x20, 0x7e,
    0xac, 0xf, 0xd0, 0x89, 0xe1, 0x3, 0xcf, 0x52,
    0x1e, 0xc6, 0x7, 0x96, 0xa8, 0x19, 0xe0, 0x1e,
    0x57, 0x20, 0xc, 0x81, 0xf1, 0xb9, 0x81, 0xff,
    0x19, 0xc8,

    /* U+3D "=" */
    0xff, 0xfe, 0x60, 0x7f, 0xf0, 0x36, 0xff, 0x99,
    0x3f, 0xf0, 0x1f, 0xfc, 0x12, 0x7f, 0xe1, 0xb7,
    0xfc, 0xc0, 0xff, 0xe0, 0x0,

    /* U+3E ">" */
    0x34, 0x81, 0xff, 0x2d, 0x88, 0xf, 0xc4, 0x1,
    0xbd, 0x81, 0xf7, 0xa8, 0x4, 0xf0, 0x81, 0xca,
    0xf8, 0x43, 0xd5, 0x1, 0xe7, 0xb1, 0x85, 0x58,
    0x1f, 0x1c, 0x80, 0x70, 0x38, 0xcf, 0x50, 0x74,
    0x9, 0x5c, 0xc0, 0x3f, 0x8, 0x9e, 0xa0, 0x67,
    0x80, 0x45, 0x80, 0x57, 0x30, 0x3e, 0x7a, 0xa0,
    0x3e, 0x3e, 0x10, 0x3f, 0x80,

    /* U+3F "?" */
    0x0, 0x6f, 0xf6, 0x60, 0x69, 0x90, 0x11, 0x94,
    0x2, 0x60, 0xcd, 0x48, 0x50, 0x70, 0x19, 0x95,
    0x88, 0x61, 0x96, 0x7, 0x20, 0x2d, 0x90, 0xe,
    0xe0, 0x7f, 0xd8, 0xf, 0xf2, 0x41, 0x0, 0xf8,
    0xd0, 0x58, 0x1e, 0x38, 0x7, 0x3, 0xec, 0x3,
    0x10, 0x3d, 0x0, 0x62, 0x7, 0xcc, 0x22, 0x7,
    0xfb, 0x1, 0xfd, 0x69, 0x1, 0xfc, 0x90, 0x81,
    0xff, 0xc9, 0xb9, 0x1, 0xf8, 0xa3, 0xc0, 0xfc,
    0x48, 0x60, 0x38,

    /* U+40 "@" */
    0x3, 0xf2, 0xbb, 0xfb, 0x42, 0x7, 0xff, 0x1,
    0x7a, 0x89, 0x81, 0x7a, 0x90, 0x3f, 0xad, 0x7,
    0xbe, 0xcf, 0xd5, 0x26, 0x40, 0x7d, 0x51, 0xd0,
    0x81, 0xca, 0xd0, 0xa4, 0xe, 0x89, 0x31, 0x3,
    0xf9, 0x61, 0xc0, 0xc9, 0x8a, 0x7, 0xff, 0x0,
    0xc2, 0xc0, 0xa0, 0xa0, 0x71, 0x96, 0x98, 0x19,
    0x8a, 0x0, 0x99, 0x1, 0xa6, 0x69, 0x26, 0x20,
    0x4c, 0x90, 0xa2, 0x81, 0x9b, 0xb, 0xf1, 0x26,
    0x5, 0x82, 0x8, 0x20, 0x23, 0x6, 0x40, 0x80,
    0x60, 0x4c, 0x70, 0x41, 0x2, 0xa1, 0x90, 0x22,
    0x8, 0x11, 0x4, 0x82, 0x3, 0x31, 0x40, 0xff,
    0xe0, 0xb0, 0x38, 0x80, 0x20, 0x7f, 0xf0, 0x48,
    0x20, 0x48, 0x10, 0x31, 0x4, 0xc, 0x40, 0xfd,
    0xc3, 0x3, 0x30, 0xc0, 0xcc, 0x12, 0x3, 0xff,
    0x80, 0x40, 0xf1, 0x18, 0x1, 0x2, 0xe1, 0x1,
    0xa0, 0x1e, 0x81, 0x20, 0x40, 0x48, 0x3, 0x1,
    0x40, 0x20, 0x28, 0x20, 0x2, 0x8, 0x2, 0x84,
    0xfc, 0xb1, 0x1a, 0xe6, 0x98, 0xa, 0x28, 0x15,
    0x60, 0x16, 0x39, 0x14, 0x25, 0x2, 0x61, 0x90,
    0x29, 0xfa, 0x90, 0x17, 0xf6, 0x60, 0x73, 0x1c,
    0xf, 0xfe, 0x44, 0x25, 0x40, 0xff, 0xe4, 0x62,
    0xbb, 0x20, 0x72, 0x80, 0x7f, 0xda, 0x9, 0xb5,
    0x77, 0xac, 0x81, 0xff, 0x3f, 0x10, 0x28, 0x93,
    0xc4, 0xf, 0x0,

    /* U+41 "A" */
    0x3, 0xe3, 0xf9, 0x81, 0xff, 0xc2, 0xa0, 0x28,
    0x1f, 0xfc, 0x26, 0x0, 0x90, 0x1f, 0xfc, 0x4,
    0x0, 0x8a, 0x7, 0xff, 0x3, 0x85, 0x43, 0x3,
    0xff, 0x80, 0x87, 0x60, 0x10, 0x1f, 0xe6, 0x1,
    0x4, 0x20, 0x1f, 0xea, 0x10, 0xe, 0x9, 0x1,
    0xf8, 0x90, 0xe0, 0x10, 0xa, 0x7, 0xea, 0x1,
    0x1, 0x20, 0xc0, 0xfc, 0xc3, 0x3, 0x70, 0x8,
    0xf, 0x30, 0x14, 0xc, 0x80, 0x70, 0x3d, 0x40,
    0x89, 0xe4, 0x10, 0x1c, 0x48, 0x6, 0xde, 0x40,
    0x18, 0x1a, 0x81, 0xff, 0xc0, 0xa0, 0x66, 0xf,
    0xff, 0x98, 0x24, 0x1, 0x0, 0xa0, 0x7e, 0xa0,
    0x28, 0xe, 0x1, 0x81, 0xf8, 0x90, 0x60, 0x10,
    0x40, 0x7f, 0xa0, 0x4, 0xc0, 0x70, 0x3f, 0xc8,
    0x7,

    /* U+42 "B" */
    0xbf, 0xfd, 0xaa, 0x3, 0xfe, 0x2a, 0xd0, 0x1d,
    0xb7, 0x52, 0x14, 0x3, 0x13, 0xcb, 0x10, 0xc0,
    0xff, 0xa8, 0x2, 0x7, 0xf8, 0x80, 0x60, 0x7f,
    0x88, 0x6, 0x7, 0xfa, 0x2, 0x40, 0x7c, 0x5f,
    0x1, 0xc0, 0xdf, 0xed, 0x1, 0xc4, 0xf, 0xf8,
    0xc0, 0x3b, 0xff, 0x40, 0xb0, 0x1f, 0xe7, 0x41,
    0x60, 0x7f, 0x90, 0xc, 0x7, 0xfc, 0x43, 0x3,
    0xfe, 0x20, 0x7f, 0xf0, 0x20, 0xa, 0x4, 0x4f,
    0x2a, 0xc0, 0x30, 0x2d, 0xba, 0xa0, 0x18, 0xf,
    0xf2, 0x9c, 0x80,

    /* U+43 "C" */
    0x3, 0x9d, 0xfe, 0xd0, 0xf, 0x8e, 0x88, 0x8,
    0xbe, 0xc0, 0xc7, 0x10, 0xee, 0xc8, 0x2, 0x30,
    0x2e, 0x3, 0x44, 0x49, 0xf0, 0x10, 0x3, 0x22,
    0x90, 0x3d, 0x40, 0x31, 0x41, 0x40, 0x7c, 0x80,
    0x50, 0x42, 0x3, 0xfa, 0x3a, 0x80, 0x60, 0x3f,
    0x9c, 0x60, 0x7f, 0xf1, 0x8, 0x1f, 0xfd, 0x32,
    0x7, 0xff, 0x4d, 0x0, 0xc0, 0x7f, 0x26, 0xc0,
    0x84, 0x7, 0xf5, 0x94, 0x50, 0x50, 0x1f, 0x20,
    0x14, 0x30, 0x14, 0x81, 0xe8, 0x1, 0x80, 0xa0,
    0x34, 0x26, 0x7c, 0x88, 0x4, 0xa8, 0x7, 0xb5,
    0x0, 0x46, 0x6, 0x5e, 0x10, 0x22, 0xfb, 0x0,

    /* U+44 "D" */
    0xbf, 0xfb, 0x54, 0x7, 0xff, 0x0, 0xab, 0x88,
    0x1e, 0xdb, 0x54, 0xe, 0x20, 0x71, 0x39, 0x5c,
    0x3, 0x1, 0xff, 0x1c, 0x2, 0x1, 0xff, 0x14,
    0x18, 0x1f, 0xfc, 0xe, 0x1, 0x1, 0xff, 0x20,
    0x18, 0xf, 0xfe, 0x11, 0x3, 0xff, 0xde, 0x40,
    0xff, 0x90, 0xc, 0x7, 0xfd, 0xc0, 0x20, 0x3f,
    0xc9, 0x3, 0x3, 0xfc, 0xa8, 0x8, 0x6, 0x27,
    0x2b, 0x40, 0x30, 0x1d, 0xb6, 0xa8, 0x1c, 0x40,
    0xfe, 0x2e, 0xe2, 0x4,

    /* U+45 "E" */
    0xbf, 0xff, 0xd8, 0xf, 0xfe, 0x26, 0xdf, 0xdc,
    0x8, 0x9f, 0xf0, 0x1f, 0xfe, 0xb2, 0x7f, 0x1,
    0xdb, 0x7e, 0x80, 0x7f, 0xf1, 0x7f, 0xfd, 0x0,
    0xff, 0xfc, 0x93, 0xfe, 0x2, 0xdb, 0xfc, 0x7,
    0xff, 0x4,

    /* U+46 "F" */
    0xbf, 0xff, 0xd4, 0xf, 0xfe, 0x26, 0xdf, 0xd4,
    0x8, 0x9f, 0xe0, 0x3f, 0xff, 0x3f, 0xfe, 0x40,
    0x7f, 0xf1, 0x76, 0xfc, 0x80, 0xc4, 0xfe, 0x3,
    0xff, 0xfe, 0x7, 0xff, 0x18,

    /* U+47 "G" */
    0x3, 0x9d, 0xfe, 0xd0, 0x81, 0xf2, 0xf1, 0x1,
    0x17, 0xa0, 0x1c, 0xa8, 0x7, 0x76, 0x42, 0x1c,
    0x3, 0x50, 0x1a, 0x22, 0x4f, 0x10, 0xc8, 0x6,
    0x2, 0x90, 0x3d, 0xc0, 0x40, 0x14, 0x2, 0x3,
    0xe2, 0x83, 0x0, 0x43, 0x3, 0xfa, 0xfc, 0x8,
    0xe, 0x7, 0xff, 0x5, 0x80, 0x20, 0x7f, 0xf2,
    0x89, 0xf8, 0xf, 0xe3, 0xb7, 0xc0, 0x7f, 0xf1,
    0x98, 0x2, 0x6, 0x3f, 0xe6, 0x4, 0x40, 0x60,
    0x3f, 0xf8, 0x48, 0x20, 0x3f, 0xf8, 0x5c, 0x4,
    0x3, 0xff, 0x82, 0x88, 0x6c, 0x7, 0xc8, 0xe,
    0xc0, 0x25, 0x44, 0xcf, 0x10, 0x80, 0xdc, 0x85,
    0x76, 0xa1, 0xe, 0x81, 0xda, 0xa2, 0x4, 0x5e,
    0x80, 0x0,

    /* U+48 "H" */
    0xbf, 0x80, 0xff, 0x7e, 0x80, 0x7f, 0xff, 0xc0,
    0xff, 0xee, 0x13, 0xfe, 0x3, 0xdb, 0x7f, 0x80,
    0xff, 0xe5, 0x7f, 0xfe, 0x3, 0xff, 0xfe, 0x7,
    0xff, 0xb0,

    /* U+49 "I" */
    0x9f, 0x88, 0x1f, 0xff, 0xf0,

    /* U+4A "J" */
    0x3, 0xfc, 0xbf, 0x20, 0x3f, 0xff, 0xe0, 0x7f,
    0xff, 0xc0, 0xff, 0xea, 0x1b, 0x48, 0xf, 0x10,
    0x32, 0x4c, 0x7, 0xb8, 0x4, 0x40, 0x30, 0x38,
    0xb0, 0x40, 0x40, 0x1d, 0x92, 0x78, 0x4, 0x0,
    0xd8, 0x4, 0xd9, 0x0, 0x44, 0x5, 0x32, 0x20,
    0xb, 0xcc, 0x0,

    /* U+4B "K" */
    0xbf, 0x80, 0xfd, 0x7f, 0x40, 0x3f, 0xe8, 0x83,
    0x80, 0x7f, 0x9b, 0x5, 0x0, 0xff, 0x28, 0xd,
    0x3, 0xfc, 0xa8, 0x38, 0xf, 0xf1, 0xa0, 0x38,
    0x1f, 0xe3, 0x80, 0x62, 0x7, 0xfb, 0x80, 0xa4,
    0xf, 0xf6, 0x22, 0x20, 0x3f, 0xd4, 0x80, 0xc0,
    0x7f, 0xc8, 0x9, 0x30, 0x3f, 0xe7, 0xc0, 0x42,
    0x7, 0xf2, 0x82, 0x80, 0xe0, 0x7f, 0x50, 0x9,
    0x83, 0x40, 0xff, 0xe0, 0x44, 0x13, 0x3, 0xff,
    0x81, 0x40, 0x42, 0x7, 0xff, 0x2, 0x80, 0xe0,
    0x7f, 0xf0, 0x14, 0x6, 0x81, 0xff, 0xc0, 0x68,
    0x26, 0x7, 0xff, 0x2, 0x80, 0x84,

    /* U+4C "L" */
    0xbf, 0x80, 0xff, 0xff, 0x81, 0xff, 0xff, 0x3,
    0xff, 0xf6, 0x4f, 0xf0, 0x1b, 0x6f, 0xe6, 0x7,
    0xff, 0x4,

    /* U+4D "M" */
    0xbf, 0xc0, 0x7f, 0xf0, 0x1f, 0xf1, 0x3, 0x20,
    0x3f, 0xea, 0x7, 0xee, 0x7, 0xf9, 0x10, 0x3f,
    0x20, 0x3f, 0xdc, 0xf, 0x88, 0x6, 0x7, 0xf2,
    0x8, 0xe, 0x68, 0x40, 0x3f, 0x30, 0x18, 0xe,
    0x7c, 0x2, 0x3, 0xea, 0x11, 0x3, 0xc8, 0x8e,
    0x7, 0x91, 0x1c, 0xf, 0xd4, 0x20, 0x3d, 0xc1,
    0x44, 0xf, 0x98, 0x6, 0x7, 0x21, 0x40, 0xf8,
    0x80, 0x42, 0x1, 0x98, 0x6, 0x7, 0xfa, 0x0,
    0x40, 0x54, 0x20, 0x3f, 0xe2, 0x43, 0x80, 0x44,
    0x40, 0x3f, 0xf8, 0x14, 0x20, 0x1c, 0x12, 0x1,
    0xc0, 0xfe, 0x60, 0x18, 0x42, 0x81, 0xff, 0xc2,
    0x62, 0xb0, 0xc, 0xf, 0xfe, 0x15, 0x6, 0x6,
    0x7, 0xff, 0xc, 0x90, 0x15, 0x3, 0xff, 0x89,
    0x40, 0x12, 0x3, 0xff, 0x88, 0xc0, 0x50, 0x3f,
    0x80,

    /* U+4E "N" */
    0xbf, 0x90, 0x1f, 0xdf, 0xa0, 0x15, 0x3, 0xff,
    0x89, 0x0, 0xff, 0xe1, 0xb2, 0x7, 0xff, 0xf,
    0x81, 0xff, 0xc1, 0x80, 0xc0, 0x3f, 0xf8, 0xc,
    0x86, 0x40, 0xff, 0xe0, 0x70, 0x1c, 0xf, 0xfe,
    0x1, 0x60, 0xb0, 0x3f, 0xf8, 0x10, 0x88, 0x40,
    0xff, 0xe0, 0x70, 0x1c, 0xf, 0xfe, 0x1, 0x60,
    0xb0, 0x3f, 0xf8, 0x10, 0x88, 0x7, 0xff, 0x6,
    0x0, 0xa0, 0x7f, 0xf0, 0x13, 0x9, 0x0, 0xff,
    0xe0, 0x40, 0x14, 0xf, 0xfe, 0xd, 0x3, 0xff,
    0x86, 0x90, 0xf, 0xfe, 0x1d, 0x3, 0xff, 0x89,
    0x40, 0x80,

    /* U+4F "O" */
    0x3, 0x95, 0xfe, 0xcc, 0xf, 0xc7, 0x54, 0x4,
    0x67, 0x40, 0x71, 0xc4, 0x29, 0x69, 0x80, 0xac,
    0xd, 0xc0, 0x5a, 0x69, 0x26, 0x1, 0x8, 0x4,
    0x44, 0x40, 0x71, 0xc0, 0x20, 0x8, 0x1, 0x81,
    0xf1, 0x41, 0x0, 0x21, 0x81, 0xfd, 0xc0, 0x22,
    0x3, 0x1, 0xfc, 0xc0, 0x16, 0x7, 0xff, 0x0,
    0x80, 0xe4, 0x3, 0x3, 0xff, 0xa4, 0x40, 0x30,
    0x3f, 0xfa, 0x3d, 0x0, 0xc0, 0x7f, 0x20, 0x4,
    0x10, 0xc0, 0xfe, 0xe0, 0x10, 0xa0, 0x18, 0x1f,
    0x14, 0x10, 0x6, 0x44, 0x40, 0x7b, 0x80, 0x80,
    0x5c, 0x5, 0xa4, 0x54, 0xe4, 0x42, 0x4, 0x71,
    0xa, 0xea, 0xc0, 0x56, 0x7, 0x1d, 0x50, 0x11,
    0x9d, 0x1, 0x0,

    /* U+50 "P" */
    0xbf, 0xfe, 0xd0, 0x81, 0xff, 0xc0, 0x2f, 0x40,
    0x3b, 0x6f, 0x40, 0xd, 0x80, 0xc4, 0xf9, 0xf2,
    0x20, 0x1f, 0xfc, 0x8, 0x1, 0x81, 0xff, 0x20,
    0x1c, 0xf, 0xfe, 0x71, 0x1, 0xc0, 0xff, 0xa0,
    0x4, 0x7, 0xf2, 0xa8, 0x22, 0x5, 0xff, 0xaa,
    0x6, 0x81, 0xff, 0x19, 0x80, 0xed, 0xb7, 0xf6,
    0x60, 0x78, 0x9c, 0x7, 0xff, 0xfc, 0xf, 0xfe,
    0x58,

    /* U+51 "Q" */
    0x3, 0x9d, 0xfe, 0xac, 0xf, 0xc7, 0xc4, 0x4,
    0xa7, 0x40, 0x72, 0xc0, 0x15, 0xb2, 0x1, 0x50,
    0x1a, 0x80, 0xd5, 0x2a, 0xe0, 0x14, 0x9, 0x80,
    0xa4, 0xe, 0x34, 0x4, 0x1, 0x1, 0x40, 0x7c,
    0x88, 0x60, 0x80, 0xa0, 0x7f, 0x50, 0x5, 0x80,
    0x20, 0x7f, 0x20, 0x8, 0x80, 0x60, 0x7f, 0xf0,
    0x78, 0x2, 0x7, 0xf1, 0x1, 0xc0, 0xff, 0xe2,
    0xf0, 0x4, 0xf, 0xe2, 0x3, 0x81, 0x30, 0x3f,
    0xf8, 0x5, 0x0, 0x20, 0x7f, 0x20, 0xc, 0x80,
    0xa0, 0x7f, 0x50, 0x4, 0x30, 0x50, 0x1f, 0x22,
    0x18, 0x8, 0x2, 0x90, 0x38, 0xd0, 0x10, 0xa,
    0x80, 0xd5, 0x15, 0x30, 0xa, 0x6, 0x58, 0x2,
    0xba, 0xb0, 0x15, 0x1, 0xc7, 0xc4, 0x4, 0x40,
    0x52, 0x7, 0xce, 0xff, 0x68, 0x3, 0x30, 0x3f,
    0xf8, 0xe, 0x80, 0x88, 0xf, 0xfe, 0x2, 0xc6,
    0x20, 0x3f, 0xf8, 0x27, 0x30,

    /* U+52 "R" */
    0xbf, 0xfe, 0xa8, 0xf, 0xfe, 0xa, 0xb8, 0xf,
    0x6d, 0xd4, 0x83, 0x80, 0xe2, 0x79, 0x66, 0xb,
    0x3, 0xfe, 0x80, 0x30, 0x1f, 0xfc, 0x2, 0x18,
    0x1f, 0xfc, 0xf2, 0x18, 0x1f, 0xf5, 0x1, 0xc0,
    0xc4, 0xf2, 0xc8, 0x24, 0x3, 0x6d, 0xd4, 0x85,
    0x40, 0xff, 0xe0, 0x5a, 0x3, 0xdf, 0xec, 0x3,
    0x81, 0xff, 0x16, 0x11, 0x3, 0xfe, 0x80, 0x20,
    0x1f, 0xfc, 0x8, 0x12, 0x1, 0xff, 0x30, 0x10,
    0xf, 0xfe, 0x4, 0x5, 0x81, 0xff, 0x32, 0x20,
    0x1f, 0xfc, 0x8, 0x1, 0x80,

    /* U+53 "S" */
    0x3, 0x4d, 0xfd, 0x98, 0x1e, 0x7d, 0x90, 0x23,
    0x3a, 0x2, 0x50, 0x4, 0xda, 0x80, 0x2a, 0x1,
    0x40, 0x76, 0x4c, 0xf8, 0xa, 0x8, 0x6, 0x7,
    0xd0, 0x2, 0x60, 0x38, 0x1f, 0x20, 0x5, 0x0,
    0xc0, 0x7c, 0x7f, 0x30, 0x82, 0xa0, 0x7f, 0xd4,
    0x85, 0xea, 0x3, 0xfb, 0x30, 0xa, 0xfa, 0x80,
    0xfa, 0x78, 0x40, 0x2b, 0x88, 0x1f, 0x3d, 0x90,
    0x83, 0x90, 0x1f, 0x8b, 0xd4, 0x5, 0x3, 0xfe,
    0x50, 0x3, 0xde, 0x81, 0xf9, 0x0, 0xec, 0x20,
    0x3f, 0xef, 0xc0, 0x28, 0x1f, 0x40, 0x9, 0x18,
    0x5d, 0xa2, 0x4f, 0x20, 0x88, 0x90, 0x2, 0x5d,
    0x90, 0x85, 0x40, 0x9f, 0x84, 0x8, 0xbd, 0x40,
    0x0,

    /* U+54 "T" */
    0x5f, 0xff, 0xf0, 0xc0, 0xff, 0xe3, 0x2d, 0xbc,
    0x1, 0x6d, 0xe0, 0x4, 0xf8, 0x8, 0x9f, 0x1,
    0xff, 0xff, 0x3, 0xff, 0xfe, 0x7, 0xff, 0xfc,
    0xf, 0xff, 0x20,

    /* U+55 "U" */
    0x1f, 0xa0, 0x1f, 0x97, 0xe4, 0x7, 0xff, 0xfc,
    0xf, 0xff, 0xf8, 0x1f, 0xff, 0x12, 0x7, 0xe2,
    0x1, 0x82, 0x10, 0x1f, 0xb0, 0x2, 0x28, 0x8,
    0x7, 0x92, 0x6, 0x1, 0x90, 0xea, 0x24, 0xad,
    0x3, 0x0, 0xb2, 0xa, 0xec, 0xa8, 0x1e, 0x7,
    0x5a, 0x44, 0x9, 0x5c, 0x40, 0x0,

    /* U+56 "V" */
    0x7f, 0x98, 0x1f, 0xe9, 0xf9, 0x30, 0x14, 0xf,
    0xf3, 0x0, 0x82, 0x4, 0xf, 0xe4, 0x1, 0x80,
    0xe0, 0x18, 0x1f, 0xb8, 0xa, 0x1, 0x0, 0xa0,
    0x7e, 0x40, 0x90, 0x13, 0x4, 0x80, 0xf2, 0x1,
    0x40, 0xd4, 0x2, 0x3, 0xdc, 0x3, 0x3, 0x12,
    0x14, 0xf, 0x20, 0x80, 0xf5, 0x4, 0x80, 0xc8,
    0x7, 0x3, 0xcc, 0x5, 0x3, 0x70, 0x8, 0xf,
    0x90, 0x40, 0x64, 0x18, 0x1f, 0xb0, 0x24, 0x1,
    0x80, 0xa0, 0x7e, 0x60, 0x28, 0xa, 0x9, 0x1,
    0xfc, 0x83, 0x0, 0x45, 0x3, 0xfd, 0xc0, 0x26,
    0x1, 0x81, 0xfe, 0x40, 0x35, 0x8, 0xf, 0xfe,
    0x3, 0xc, 0x8e, 0x7, 0xff, 0x2, 0x81, 0x90,
    0x1f, 0xfc, 0x2, 0x40, 0x10, 0x1f, 0xfc, 0x2a,
    0x3, 0x81, 0xf0,

    /* U+57 "W" */
    0x1f, 0xa0, 0x1f, 0x5f, 0x80, 0xfa, 0x7e, 0x0,
    0x42, 0x3, 0xe4, 0x8, 0x1f, 0x10, 0x40, 0x20,
    0x40, 0xf1, 0x2, 0x60, 0x79, 0x6, 0x3, 0x0,
    0x40, 0x75, 0x2, 0xc0, 0x71, 0x1, 0x80, 0x20,
    0x4, 0xe, 0x40, 0x84, 0x7, 0x20, 0x8, 0x8,
    0x8c, 0x7, 0x11, 0x0, 0x10, 0x36, 0x0, 0x40,
    0x90, 0x40, 0x64, 0x1, 0x10, 0x80, 0xcc, 0x20,
    0x36, 0x0, 0x40, 0xb8, 0x42, 0x8a, 0x6, 0x23,
    0x1, 0x98, 0x4, 0x4, 0x86, 0x8, 0x10, 0x24,
    0x1, 0x1, 0x88, 0xc, 0x0, 0x80, 0x60, 0x80,
    0x40, 0x30, 0x2, 0x7, 0x20, 0xc0, 0x20, 0x40,
    0x90, 0xc0, 0x10, 0x40, 0x7b, 0x2, 0x2, 0x84,
    0x5, 0xc2, 0x0, 0x46, 0x3, 0xc8, 0x2, 0x4,
    0x50, 0x24, 0x9, 0x80, 0x20, 0x3c, 0x40, 0x64,
    0x0, 0x81, 0x88, 0x48, 0x0, 0x81, 0xf2, 0x7,
    0x4, 0x7, 0x21, 0xb8, 0x40, 0x7e, 0xc1, 0xa1,
    0xc0, 0xec, 0x12, 0x2, 0x7, 0xe4, 0x9, 0x4,
    0x7, 0x20, 0x4, 0x60, 0x3f, 0x10, 0x22, 0x7,
    0xc8, 0x9, 0x1, 0xfc, 0x80, 0x50, 0x3e, 0xc0,
    0x8, 0x1f, 0xec, 0x1, 0x1, 0xf2, 0x0, 0x80,
    0xe0,

    /* U+58 "X" */
    0x17, 0xf2, 0x3, 0xf5, 0xfc, 0x84, 0x1, 0x40,
    0xf9, 0x20, 0x48, 0xc, 0x1, 0x0, 0xf5, 0x1,
    0x0, 0x99, 0xc, 0x81, 0xa0, 0x8, 0x40, 0xdc,
    0x7, 0x2, 0x2c, 0x16, 0x7, 0x16, 0xb, 0x1,
    0xc0, 0x70, 0x3e, 0x80, 0x21, 0x64, 0x32, 0x7,
    0xea, 0x3, 0xc0, 0x60, 0x1f, 0xc9, 0x1, 0x1,
    0x0, 0xff, 0xa8, 0x12, 0x40, 0x3f, 0xe2, 0x7,
    0xff, 0x13, 0x81, 0x26, 0x7, 0xf9, 0x90, 0x80,
    0x40, 0x3f, 0xd0, 0x5, 0x80, 0x28, 0x1f, 0xa8,
    0xa, 0x1a, 0x9, 0x0, 0xf2, 0x40, 0x90, 0x4,
    0x1, 0x40, 0xf5, 0x1, 0x0, 0x8c, 0x1, 0x0,
    0xd0, 0x4, 0x20, 0x66, 0x43, 0x20, 0x13, 0x5,
    0x81, 0xee, 0x3, 0x80, 0x80, 0x38, 0x1f, 0x16,
    0xb,

    /* U+59 "Y" */
    0x9f, 0x98, 0x1f, 0xd7, 0xf2, 0x80, 0x20, 0x1f,
    0x8a, 0x9, 0x4, 0x1, 0x0, 0xfa, 0x0, 0x80,
    0x19, 0xc, 0xf, 0x24, 0x8, 0x81, 0x40, 0x10,
    0xe, 0x80, 0x28, 0x19, 0x10, 0xc0, 0xc8, 0x86,
    0x7, 0xb8, 0x8, 0x5, 0x0, 0x40, 0x3c, 0x50,
    0x60, 0x11, 0x10, 0xf, 0xd0, 0x4, 0x10, 0x16,
    0x7, 0xe2, 0xc3, 0x84, 0x40, 0x3f, 0xd0, 0x3,
    0x5, 0x1, 0xff, 0x30, 0x28, 0x7, 0xff, 0x2,
    0x0, 0x28, 0xf, 0xfe, 0x1b, 0x3, 0xff, 0xfe,
    0x7, 0xff, 0x58,

    /* U+5A "Z" */
    0xbf, 0xff, 0xf0, 0x48, 0x1f, 0xfc, 0x3b, 0xb7,
    0xf5, 0x0, 0x48, 0x13, 0xfd, 0x0, 0x70, 0x3f,
    0xd0, 0x88, 0x40, 0xfe, 0x2c, 0x16, 0x7, 0xfb,
    0x80, 0xe0, 0x7f, 0xa1, 0x10, 0x81, 0xfc, 0x98,
    0x4c, 0xf, 0xf5, 0x1, 0x40, 0xff, 0x50, 0x14,
    0xf, 0xf2, 0x40, 0x90, 0xf, 0xf5, 0x1, 0x40,
    0xff, 0x50, 0x14, 0xf, 0xf3, 0x41, 0xa0, 0x3f,
    0x8c, 0x6, 0x1, 0xfe, 0xe0, 0x38, 0x1f, 0xe6,
    0x42, 0x4, 0xff, 0xa, 0x1, 0x6d, 0xfe, 0xa0,
    0x7f, 0xf0, 0xc0,

    /* U+5B "[" */
    0xff, 0x88, 0x1f, 0x9f, 0xe2, 0x7, 0xff, 0xfc,
    0xf, 0xff, 0x7b, 0xfc, 0x40, 0xf0,

    /* U+5C "\\" */
    0x5f, 0x88, 0x1f, 0x91, 0x14, 0xf, 0xea, 0x18,
    0x1f, 0xcc, 0x2, 0x3, 0xf9, 0xe, 0x7, 0xf7,
    0x8, 0xf, 0xe4, 0x1, 0x81, 0xfc, 0xc5, 0x3,
    0xfa, 0x82, 0x40, 0x7e, 0x24, 0x28, 0x1f, 0xd4,
    0x30, 0x3f, 0x98, 0x6, 0x7, 0xf3, 0x14, 0xf,
    0xea, 0x9, 0x1, 0xf8, 0x90, 0xa0, 0x7f, 0x50,
    0xc0, 0xfe, 0x60, 0x10, 0x1f, 0xc8, 0x70, 0x3f,
    0xb8, 0x40, 0x7f, 0x20, 0xc, 0xf, 0xe6, 0x28,
    0x1f, 0xd1, 0xa0,

    /* U+5D "]" */
    0xff, 0x90, 0x1e, 0xfd, 0x40, 0xe6, 0x7, 0xff,
    0xfc, 0xf, 0xff, 0x33, 0x2, 0xfd, 0x40, 0xfe,

    /* U+5E "^" */
    0x3, 0x1f, 0xc0, 0x7e, 0x80, 0x10, 0x1f, 0x20,
    0x1c, 0xf, 0x30, 0x24, 0x40, 0xea, 0x21, 0x14,
    0xc, 0x88, 0x70, 0x30, 0x37, 0xc, 0x20, 0x8,
    0x9, 0xa, 0x1, 0x88, 0x2, 0x2, 0x40, 0x28,
    0x24, 0x18, 0xa0, 0x44, 0x85,

    /* U+5F "_" */
    0x3, 0xff, 0x83, 0xff, 0xff, 0x2, 0x1, 0xff,
    0xc1,

    /* U+60 "`" */
    0x1b, 0xf1, 0x2, 0xc4, 0x70, 0x36, 0x5, 0x81,
    0xb0, 0x84,

    /* U+61 "a" */
    0x2, 0x57, 0xfb, 0x30, 0x3a, 0xd2, 0x2, 0x33,
    0x1, 0x44, 0x1e, 0xf9, 0x83, 0x0, 0x30, 0xe1,
    0x6, 0x20, 0xc0, 0x5a, 0x80, 0x76, 0x0, 0x42,
    0x40, 0x3c, 0x40, 0xf3, 0xbf, 0xea, 0x6, 0x3a,
    0x20, 0x4, 0xc0, 0x6e, 0x45, 0xfd, 0xb2, 0x1,
    0x22, 0x32, 0x3, 0xf1, 0x0, 0x40, 0xe2, 0x7,
    0x90, 0x1d, 0x40, 0x98, 0xa, 0xca, 0x9c, 0x80,
    0x62, 0x0, 0x9a, 0xb0, 0xc0, 0x10, 0xf2, 0x2,
    0x7a, 0x24, 0x0,

    /* U+62 "b" */
    0x1f, 0x98, 0x1f, 0xff, 0xf0, 0x3f, 0xd3, 0xfa,
    0x90, 0x3d, 0xbb, 0x2, 0x59, 0x81, 0xc8, 0x4d,
    0x90, 0x4, 0x20, 0x76, 0x64, 0x9e, 0x1, 0x0,
    0xd0, 0x81, 0x8b, 0x8, 0xf, 0xfb, 0x0, 0x40,
    0x7f, 0x98, 0x2, 0x7, 0xf8, 0x81, 0xff, 0xc1,
    0x20, 0x7f, 0xf0, 0x58, 0x2, 0x7, 0xfb, 0x80,
    0x40, 0x50, 0x81, 0x8a, 0x8, 0xe, 0xcc, 0x93,
    0xc0, 0x20, 0x19, 0x89, 0xb2, 0x0, 0x84, 0xd,
    0xb1, 0x81, 0x2c, 0xc0, 0x0,

    /* U+63 "c" */
    0x2, 0x33, 0x7e, 0xcc, 0xe, 0x79, 0x90, 0x6,
    0x60, 0x25, 0x1, 0xbf, 0x30, 0x70, 0xa, 0xe,
    0x40, 0xca, 0xa, 0x40, 0x10, 0xe, 0x44, 0x6c,
    0x0, 0x80, 0xf7, 0xb4, 0x41, 0x3, 0xe2, 0x88,
    0x1f, 0xfc, 0xe2, 0x8, 0x1f, 0xec, 0x1, 0x1,
    0xeb, 0xa2, 0x1, 0x0, 0xe2, 0x8f, 0x14, 0x1c,
    0x81, 0x78, 0x16, 0x14, 0x6, 0xfd, 0x1, 0xc0,
    0x4f, 0x32, 0x0, 0xcc, 0x0,

    /* U+64 "d" */
    0x3, 0xfd, 0xbe, 0x3, 0xff, 0xf0, 0xaf, 0xed,
    0x0, 0xf4, 0xa8, 0x1, 0x78, 0xc, 0xd8, 0x1b,
    0xb1, 0x92, 0x2, 0x80, 0xe4, 0x4a, 0x50, 0x24,
    0x2, 0x81, 0xc8, 0x80, 0xc0, 0x18, 0x1f, 0xc4,
    0xf, 0xfe, 0x11, 0x3, 0xff, 0x80, 0x40, 0xff,
    0x10, 0x3f, 0xf8, 0x18, 0x3, 0x3, 0xf9, 0x0,
    0xa0, 0x72, 0x20, 0x54, 0x1c, 0x89, 0x4a, 0x6,
    0x4c, 0x1b, 0xb1, 0x82, 0x6, 0x95, 0x0, 0x2f,
    0xa0, 0x0,

    /* U+65 "e" */
    0x3, 0x4d, 0xfb, 0x30, 0x39, 0x76, 0x40, 0x19,
    0x80, 0x8d, 0x6, 0xfc, 0xc1, 0xa0, 0x38, 0x39,
    0x3, 0x20, 0x22, 0x61, 0x0, 0xe6, 0x2, 0xd0,
    0x4, 0x7, 0x88, 0x24, 0x3, 0xff, 0x88, 0x60,
    0x7f, 0xf0, 0xcf, 0xff, 0xd8, 0x82, 0x7, 0xfb,
    0x0, 0x60, 0x7f, 0x20, 0x10, 0xf, 0x3a, 0x2,
    0x80, 0xec, 0x1, 0xb1, 0x20, 0x54, 0x4, 0xfd,
    0x90, 0x88, 0x2, 0xec, 0x80, 0x2f, 0x30,

    /* U+66 "f" */
    0x3, 0xff, 0x87, 0x3f, 0xa8, 0x1b, 0x30, 0x3e,
    0x64, 0x3f, 0xd4, 0xb, 0x0, 0x80, 0x79, 0x84,
    0x7, 0xff, 0x8, 0xfe, 0x21, 0x7e, 0xc0, 0x7f,
    0xc7, 0xf1, 0xb, 0xf6, 0x3, 0xff, 0xfe, 0x7,
    0xff, 0x88,

    /* U+67 "g" */
    0x2, 0x57, 0xf6, 0x82, 0x7c, 0x2, 0x54, 0x0,
    0xbc, 0x40, 0x9b, 0x3, 0x76, 0x32, 0x80, 0xa0,
    0xc, 0x89, 0x4a, 0x4, 0x80, 0x40, 0x39, 0x20,
    0xc, 0x1, 0x81, 0xfc, 0x40, 0xff, 0xe1, 0x10,
    0x3f, 0xf8, 0x4, 0xf, 0xf1, 0x3, 0xff, 0x81,
    0x80, 0x30, 0x3c, 0xc0, 0x20, 0x14, 0xe, 0x44,
    0xa, 0x83, 0x91, 0x29, 0x40, 0xc9, 0x83, 0x76,
    0x32, 0x40, 0x69, 0x50, 0x2, 0xf3, 0x3, 0x95,
    0xfd, 0xa0, 0x61, 0x81, 0xfe, 0x20, 0x85, 0xc8,
    0x1d, 0x0, 0x61, 0xc6, 0x64, 0x1a, 0xc2, 0x41,
    0x48, 0x9b, 0xe4, 0xd, 0x2, 0xd5, 0x1, 0x29,
    0x80, 0x0,

    /* U+68 "h" */
    0x1f, 0x98, 0x1f, 0xff, 0xf0, 0x33, 0xdf, 0xb2,
    0x3, 0xbe, 0x84, 0x1, 0xac, 0xc, 0xcb, 0xd9,
    0x0, 0x40, 0x3b, 0x42, 0x4e, 0x0, 0x40, 0x4c,
    0x81, 0x98, 0x2, 0x5, 0xc0, 0xfd, 0xc0, 0xff,
    0xff, 0x81, 0xff, 0xde,

    /* U+69 "i" */
    0x17, 0xc0, 0x83, 0xc, 0xc1, 0x33, 0x3, 0xb7,
    0xa0, 0x7f, 0xfb, 0x0,

    /* U+6A "j" */
    0x2, 0xdd, 0x0, 0x24, 0x38, 0x2, 0x8f, 0x2,
    0xb9, 0x1, 0xfd, 0xfa, 0x1, 0xff, 0xff, 0x3,
    0xff, 0x9d, 0xc9, 0x50, 0x7, 0x62, 0x5, 0x10,
    0xb, 0x0,

    /* U+6B "k" */
    0x1f, 0x98, 0x1f, 0xff, 0xf0, 0x3f, 0xf8, 0x27,
    0xf8, 0x81, 0xfd, 0xc0, 0x62, 0x7, 0xec, 0x46,
    0x20, 0x7e, 0xc4, 0x52, 0x7, 0xec, 0x45, 0x40,
    0x7e, 0xa4, 0x44, 0x7, 0xea, 0x80, 0x30, 0x3f,
    0x88, 0x15, 0x3, 0xfc, 0x90, 0x26, 0x7, 0xe5,
    0x68, 0x88, 0x40, 0xfb, 0x0, 0xe0, 0x38, 0x1f,
    0xe3, 0x1, 0x80, 0x7f, 0x9a, 0xd, 0x1, 0xfe,
    0xa4, 0x52, 0x7, 0xfb, 0x80, 0xe0,

    /* U+6C "l" */
    0xde, 0x81, 0xff, 0xf0,

    /* U+6D "m" */
    0x1f, 0x90, 0x9b, 0xf5, 0x40, 0x53, 0x7e, 0xc8,
    0xe, 0xdd, 0x90, 0xa, 0xa4, 0xec, 0x80, 0x36,
    0x1, 0x99, 0xbb, 0x18, 0xb, 0x42, 0x6c, 0x80,
    0x19, 0x2, 0x39, 0x12, 0x90, 0x5, 0x99, 0x27,
    0x40, 0x20, 0x2a, 0x7, 0x20, 0x8, 0x81, 0x90,
    0xe, 0x7, 0xf1, 0x0, 0x40, 0xfc, 0x40, 0xff,
    0xff, 0x81, 0xff, 0xff, 0x3, 0xff, 0xc8,

    /* U+6E "n" */
    0x1f, 0x90, 0x7b, 0xf6, 0x40, 0x71, 0xd0, 0x80,
    0x35, 0x81, 0xa1, 0x7b, 0x20, 0x8, 0x7, 0x68,
    0x49, 0xc0, 0x8, 0x9, 0x90, 0x33, 0x0, 0x40,
    0xb8, 0x1f, 0xb8, 0x1f, 0xff, 0xf0, 0x3f, 0xfb,
    0xc0,

    /* U+6F "o" */
    0x3, 0x4d, 0xfb, 0x40, 0x3c, 0xbb, 0x20, 0xb,
    0xe8, 0x8, 0xd0, 0x17, 0xf4, 0x1, 0x48, 0xe,
    0x3, 0xa0, 0xf, 0x0, 0xe1, 0x11, 0x0, 0xe3,
    0x1, 0x2c, 0x1, 0x81, 0xe6, 0x2, 0x90, 0x40,
    0xff, 0x10, 0x3f, 0xe2, 0x7, 0xff, 0x10, 0x82,
    0x7, 0xe2, 0xe, 0x0, 0xc0, 0xf3, 0x1, 0x91,
    0x10, 0xf, 0x40, 0x50, 0xe0, 0x32, 0x0, 0xb8,
    0xe, 0x0, 0xd0, 0x6f, 0xea, 0x2, 0x90, 0x25,
    0xd9, 0x0, 0x5f, 0x40, 0x0,

    /* U+70 "p" */
    0x1f, 0x91, 0x9f, 0xd4, 0x81, 0xed, 0x8c, 0x9,
    0x66, 0x7, 0x33, 0x36, 0x30, 0x10, 0x81, 0x8e,
    0x64, 0xa5, 0x1, 0x0, 0xd4, 0xe, 0x48, 0x10,
    0x1f, 0xf7, 0x0, 0x40, 0xff, 0x30, 0xc, 0xf,
    0xfe, 0x9, 0x3, 0xff, 0x82, 0x40, 0xff, 0x30,
    0xc, 0xf, 0xf7, 0x0, 0x40, 0xa8, 0x1c, 0x50,
    0x40, 0x63, 0x90, 0x7, 0x80, 0x40, 0x31, 0x2b,
    0xfa, 0x0, 0xa4, 0xd, 0x72, 0x2, 0x59, 0x1,
    0xe3, 0x7f, 0xa9, 0x3, 0xff, 0xfa,

    /* U+71 "q" */
    0x2, 0x57, 0xf6, 0x82, 0x7c, 0x2, 0x54, 0x0,
    0xbe, 0x80, 0x9b, 0x3, 0x7e, 0x80, 0x81, 0x40,
    0x72, 0x5, 0xe0, 0x24, 0x2, 0x81, 0xc4, 0x80,
    0x60, 0xc, 0xf, 0xe2, 0x7, 0xff, 0x8, 0x81,
    0xff, 0xc0, 0x20, 0x7f, 0x88, 0x1f, 0xfc, 0xc,
    0x1, 0x81, 0xfc, 0x80, 0x50, 0x38, 0x90, 0x14,
    0x7, 0x20, 0x5e, 0x3, 0x36, 0x6, 0xfd, 0x0,
    0xf4, 0xa8, 0x1, 0x7c, 0x81, 0xca, 0xfe, 0xd0,
    0xf, 0xff, 0xc8,

    /* U+72 "r" */
    0x1f, 0x99, 0xbf, 0x80, 0xdb, 0x10, 0x1e, 0x41,
    0x48, 0x3, 0xb5, 0x6c, 0x6, 0x64, 0xf, 0xb8,
    0x1f, 0xff, 0xf0, 0x3f, 0xe0,

    /* U+73 "s" */
    0x2, 0x7b, 0xfa, 0xa0, 0x3b, 0x42, 0x4, 0xac,
    0x2, 0xa4, 0x4d, 0xe9, 0xd, 0x0, 0x41, 0xb1,
    0xb, 0x0, 0x80, 0x80, 0xe0, 0x75, 0x74, 0x10,
    0x10, 0x81, 0x94, 0x60, 0x28, 0xd, 0xeb, 0x3,
    0xcb, 0x30, 0xa, 0x7a, 0x40, 0xc6, 0x7d, 0x10,
    0x59, 0x1, 0xe2, 0xee, 0x1, 0x3, 0xb4, 0x7,
    0x16, 0x8, 0x4, 0x84, 0xe, 0x20, 0x4c, 0x6,
    0x64, 0x18, 0x83, 0x1, 0x80, 0x4d, 0xf3, 0x6,
    0x0, 0x3e, 0x10, 0x25, 0x70, 0x0,

    /* U+74 "t" */
    0x2, 0x90, 0x40, 0xe2, 0xdc, 0x7, 0xff, 0x27,
    0xf6, 0x1, 0x7f, 0x2, 0x7, 0xed, 0xf0, 0xb,
    0xf8, 0xf, 0xff, 0xf8, 0x11, 0x3, 0x88, 0xa,
    0x48, 0xc, 0x81, 0xd8, 0x40, 0xab, 0x0, 0x40,

    /* U+75 "u" */
    0x3f, 0x98, 0x1e, 0xfd, 0x0, 0xff, 0xff, 0x81,
    0xff, 0xde, 0x20, 0x7f, 0xf0, 0xe8, 0x1d, 0x0,
    0xcc, 0x1a, 0x49, 0x56, 0x6, 0x80, 0x16, 0xca,
    0x88, 0x1d, 0xd8, 0x11, 0x98, 0x8,

    /* U+76 "v" */
    0x5f, 0x88, 0x1e, 0xbf, 0x4, 0x2, 0x81, 0xe4,
    0x10, 0x4, 0x10, 0x1c, 0x80, 0x50, 0x1c, 0x12,
    0x3, 0x70, 0x48, 0x2, 0x1, 0x40, 0xc8, 0x50,
    0x33, 0x8, 0x9, 0x0, 0x60, 0x6a, 0x9, 0x0,
    0xe1, 0x1, 0xc4, 0x85, 0x0, 0x86, 0x3, 0xc8,
    0x20, 0x80, 0x30, 0x3d, 0x41, 0x2c, 0x10, 0x1f,
    0x12, 0x15, 0x8e, 0x7, 0xea, 0x18, 0x4, 0x7,
    0xe6, 0x4, 0xc0, 0xff, 0x20, 0x18, 0xf, 0xf7,
    0x0, 0x80, 0xe0,

    /* U+77 "w" */
    0x5f, 0x88, 0x1d, 0x7d, 0x3, 0x97, 0xe2, 0x80,
    0x20, 0x39, 0x4, 0x7, 0x60, 0x4, 0x21, 0x40,
    0xc8, 0x9, 0x1, 0x90, 0x40, 0x30, 0x20, 0x6c,
    0x5, 0x80, 0xc4, 0x60, 0xc, 0x2, 0x2, 0x62,
    0x6, 0x4, 0x80, 0x30, 0x22, 0x30, 0x2, 0xb,
    0x0, 0x40, 0x60, 0x40, 0xc8, 0x20, 0x14, 0x20,
    0x85, 0x0, 0x82, 0x3, 0x60, 0x40, 0x21, 0x47,
    0x8, 0x1, 0x14, 0xc, 0x80, 0x22, 0x40, 0x84,
    0x9, 0x20, 0x4, 0xe, 0x43, 0x20, 0x80, 0x90,
    0x58, 0x20, 0x3d, 0x82, 0xa3, 0x81, 0x61, 0x50,
    0xe0, 0x79, 0x2, 0x41, 0x1, 0x30, 0x48, 0x20,
    0x3c, 0x48, 0x2, 0x3, 0x88, 0x2, 0x7, 0xe4,
    0x3, 0x1, 0xd4, 0x2, 0x3, 0xf6, 0x0, 0xc0,
    0xe4, 0x2, 0x81, 0x80,

    /* U+78 "x" */
    0x1f, 0xc0, 0x71, 0xfd, 0x80, 0x50, 0x10, 0xd,
    0xc0, 0x70, 0x9, 0x3, 0x20, 0x11, 0x10, 0x81,
    0x50, 0x10, 0x5, 0x5, 0x81, 0xd4, 0x24, 0x80,
    0x38, 0x1e, 0x48, 0x2b, 0xc, 0x81, 0xf5, 0x2,
    0x30, 0xf, 0xe6, 0x2, 0x81, 0xfc, 0x58, 0x8,
    0x7, 0xf7, 0x4, 0x5, 0x3, 0xe6, 0x47, 0x81,
    0x20, 0x1c, 0x60, 0x45, 0x91, 0x40, 0xee, 0x2,
    0x80, 0xe0, 0x20, 0x13, 0x22, 0x1, 0x16, 0x1a,
    0x6, 0x2, 0xc0, 0xd0, 0x5, 0x0,

    /* U+79 "y" */
    0x9f, 0x88, 0x1e, 0xfd, 0x68, 0x5, 0x3, 0x90,
    0xc, 0x48, 0x30, 0x3b, 0x0, 0x62, 0x80, 0x20,
    0x66, 0x10, 0x6, 0x2, 0x81, 0x10, 0x1c, 0x9,
    0x6, 0x5, 0x40, 0x20, 0x2c, 0x0, 0x80, 0x41,
    0x1, 0x98, 0xa, 0x9, 0xe, 0x7, 0x20, 0xc2,
    0x0, 0x80, 0xee, 0x0, 0xd0, 0x80, 0xf2, 0x1,
    0x8, 0xe0, 0x7c, 0xc2, 0x0, 0x80, 0xfa, 0x81,
    0x30, 0x3f, 0x10, 0x2c, 0x7, 0xf3, 0x0, 0x80,
    0xfe, 0x21, 0x81, 0xfe, 0x42, 0x81, 0xfd, 0x1,
    0x20, 0x3c, 0x54, 0x62, 0x1, 0xf7, 0xac, 0x24,
    0x3, 0xe6, 0x2, 0x50, 0x3e,

    /* U+7A "z" */
    0xbf, 0xff, 0xa0, 0x1f, 0xfc, 0xb, 0xff, 0xb0,
    0x14, 0x3, 0xe8, 0x2, 0x81, 0xf3, 0x41, 0xa0,
    0x3c, 0x60, 0x30, 0xf, 0xb8, 0xc, 0x7, 0xd4,
    0x8a, 0x7, 0xcd, 0x6, 0x80, 0xf1, 0x80, 0xc0,
    0x3e, 0xe0, 0x38, 0x1f, 0x42, 0x29, 0x3, 0xc9,
    0x84, 0x80, 0x7d, 0x0, 0x2f, 0xff, 0x1, 0xff,
    0xc0,

    /* U+7B "{" */
    0x3, 0xf1, 0x3, 0xe7, 0xf0, 0x1e, 0x90, 0x18,
    0x1c, 0xd8, 0x58, 0x7, 0x50, 0x50, 0x1e, 0x22,
    0x81, 0xe2, 0x0, 0x81, 0xff, 0xd8, 0x60, 0x18,
    0x1e, 0xc0, 0x8, 0x1c, 0xd8, 0x30, 0x3b, 0xc0,
    0xa0, 0x18, 0x81, 0xfc, 0x7c, 0xa, 0x1, 0xe6,
    0xc1, 0x81, 0xf6, 0x0, 0x40, 0xf3, 0x0, 0xc0,
    0xff, 0xec, 0x10, 0x4, 0xf, 0x88, 0xc0, 0x7d,
    0x42, 0x40, 0x3c, 0xd0, 0xb0, 0xf, 0x58, 0x18,
    0x1f, 0x3f, 0x80,

    /* U+7C "|" */
    0x9d, 0x81, 0xff, 0xf6, 0xcd, 0x0,

    /* U+7D "}" */
    0x3, 0xf9, 0xfa, 0x7, 0x89, 0x2e, 0x40, 0xcb,
    0x11, 0xc0, 0xf4, 0x5, 0x1, 0xc8, 0x1, 0x3,
    0xf7, 0x3, 0xf1, 0x3, 0xff, 0x86, 0x40, 0xff,
    0xe2, 0xa0, 0x80, 0xf5, 0x1, 0x48, 0x18, 0xd0,
    0xb4, 0x3, 0x32, 0x7, 0x8e, 0x25, 0xa0, 0x15,
    0x1, 0x88, 0x19, 0x4, 0x7, 0xff, 0xc, 0x81,
    0xff, 0xc7, 0x20, 0x7e, 0xe0, 0x72, 0x0, 0x40,
    0xe8, 0xa, 0x2, 0x58, 0x8e, 0x6, 0xc5, 0x72,
    0x6, 0x9a, 0x81, 0xe0,

    /* U+7E "~" */
    0x3, 0x12, 0x3, 0xff, 0x82, 0xb6, 0xbd, 0x3,
    0xdb, 0x8, 0x34, 0x81, 0x2e, 0x80, 0x89, 0xc3,
    0x83, 0xbc, 0x1, 0x62, 0x4e, 0x10, 0x2, 0x39,
    0xf, 0x90, 0xed, 0x11, 0x0, 0x36, 0x20, 0x6d,
    0x8, 0x5, 0xc8,

    /* U+F001 "" */
    0x3, 0xff, 0x9c, 0x40, 0xff, 0xe5, 0x99, 0xbe,
    0x80, 0x7f, 0xf1, 0xd5, 0xf9, 0x90, 0xc, 0xf,
    0xfe, 0x19, 0x7b, 0xd4, 0x7, 0xff, 0x1d, 0x4f,
    0xa1, 0x3, 0xff, 0x8e, 0xef, 0xac, 0xf, 0xfe,
    0x4c, 0xf1, 0x1, 0xff, 0xcc, 0x60, 0x7f, 0xf7,
    0xda, 0x3, 0xff, 0x94, 0x66, 0xf0, 0x81, 0xff,
    0xc7, 0x57, 0xe6, 0x40, 0xff, 0xe3, 0x17, 0xbd,
    0x40, 0x7f, 0xf2, 0x16, 0xc8, 0x40, 0xff, 0xe5,
    0x92, 0x3, 0xff, 0xfe, 0x7, 0xff, 0xf5, 0xdd,
    0x50, 0x1f, 0xfc, 0x95, 0xe2, 0x28, 0x81, 0xff,
    0xc8, 0x34, 0xf, 0xfe, 0x9, 0x30, 0x1f, 0xe4,
    0x7, 0xfc, 0x77, 0xda, 0x3, 0xfc, 0x40, 0xfe,
    0x2b, 0x10, 0x3f, 0xf8, 0x49, 0x0, 0xfd, 0x20,
    0xf, 0xfe, 0x2d, 0x80, 0x72, 0xc8, 0x81, 0xfd,
    0xc0, 0xfc, 0xff, 0x6c, 0xf4, 0x84, 0x7, 0xf2,
    0x3, 0xfe, 0x24, 0x6, 0xa8, 0xf, 0xa9, 0x3,
    0xff, 0x8d, 0x74, 0x48, 0xef, 0x40, 0x7f, 0xf1,
    0x80,

    /* U+F008 "" */
    0x94, 0xb, 0x7f, 0xff, 0xc4, 0xa0, 0x56, 0x34,
    0xb1, 0x3, 0xff, 0x88, 0x97, 0x30, 0x16, 0xc0,
    0x49, 0x7f, 0xf0, 0x0, 0xad, 0x80, 0xcd, 0xc0,
    0xd, 0xbf, 0xfc, 0x0, 0x26, 0xe0, 0x23, 0x24,
    0x40, 0xff, 0xe2, 0x29, 0x22, 0x7, 0xff, 0x9d,
    0x81, 0xe3, 0xfc, 0x40, 0xff, 0xe2, 0x1f, 0xe2,
    0x4, 0x4c, 0x0, 0x81, 0xff, 0xc3, 0x26, 0x2,
    0x3b, 0x44, 0x6, 0xdf, 0xfc, 0x0, 0x7, 0x68,
    0x81, 0xfc, 0x4f, 0xff, 0x0, 0x3, 0x3, 0xff,
    0x82, 0x4f, 0xff, 0x0, 0x3, 0x3, 0xc7, 0x68,
    0x80, 0xdb, 0xff, 0x80, 0x0, 0xed, 0x10, 0x22,
    0x60, 0x4, 0xf, 0xfe, 0x19, 0x30, 0x11, 0xfe,
    0x20, 0x7f, 0xf1, 0xf, 0xf1, 0x3, 0xff, 0x96,
    0xc0, 0xff, 0xeb, 0x19, 0x22, 0x7, 0xff, 0x11,
    0x49, 0x10, 0x26, 0xe0, 0x6, 0xdf, 0xfe, 0x0,
    0x13, 0x70, 0x1a, 0xd8, 0x9, 0x2f, 0xfe, 0x0,
    0x15, 0xb0, 0x4, 0xb8, 0x81, 0xff, 0xc4, 0x4b,
    0x98,

    /* U+F00B "" */
    0x9f, 0xfa, 0x80, 0xbf, 0xff, 0xf1, 0x23, 0x3,
    0xc8, 0x84, 0x7, 0xff, 0x11, 0x81, 0xff, 0xff,
    0x3, 0xff, 0xb2, 0x80, 0xf1, 0x20, 0x40, 0xff,
    0xe2, 0x2b, 0xff, 0xb0, 0xd, 0xff, 0xff, 0x12,
    0x81, 0xff, 0xd0, 0x9f, 0xfa, 0x80, 0xbf, 0xff,
    0xf1, 0x23, 0x3, 0xc8, 0x84, 0x7, 0xff, 0x11,
    0x81, 0xff, 0xff, 0x3, 0xff, 0xb2, 0x80, 0xf1,
    0x20, 0x80, 0xff, 0xe2, 0x3b, 0xff, 0xb0, 0xb,
    0xff, 0xff, 0x12, 0x1, 0xff, 0xd0, 0xbf, 0xfb,
    0x0, 0xdf, 0xff, 0xf1, 0x2a, 0x3, 0xc4, 0x81,
    0x3, 0xff, 0x88, 0x80, 0xff, 0xff, 0x81, 0xff,
    0xd9, 0x60, 0x79, 0x10, 0x80, 0xff, 0xe2, 0x30,

    /* U+F00C "" */
    0x3, 0xff, 0x96, 0xbc, 0x3, 0xff, 0x98, 0xe8,
    0x74, 0xf, 0xfe, 0x53, 0x80, 0x4a, 0x1, 0xff,
    0xc8, 0x70, 0xe, 0x60, 0x7f, 0xf1, 0xdc, 0x3,
    0xcc, 0xf, 0xfe, 0x33, 0x80, 0x79, 0xc0, 0x3f,
    0xf8, 0xae, 0x1, 0xe7, 0x0, 0xa7, 0x40, 0x7f,
    0xce, 0x1, 0xe7, 0x0, 0xab, 0x15, 0x81, 0xfc,
    0xe0, 0x1e, 0x70, 0xa, 0x20, 0x28, 0xc0, 0xf9,
    0xc0, 0x3c, 0xe0, 0x19, 0x81, 0xd1, 0x81, 0xce,
    0x1, 0xe7, 0x0, 0xe6, 0x7, 0xa3, 0x2, 0x70,
    0xf, 0x38, 0x7, 0xa3, 0x3, 0xd1, 0x87, 0x0,
    0xf3, 0x80, 0x7e, 0x8c, 0xf, 0x4b, 0x0, 0xf3,
    0x80, 0x7f, 0xa3, 0x3, 0xc8, 0xf, 0x38, 0x7,
    0xff, 0x2, 0x30, 0x3f, 0xe7, 0x0, 0xff, 0xe1,
    0x46, 0x7, 0xf3, 0x80, 0x7f, 0xf1, 0x23, 0x3,
    0xe9, 0x0, 0x7f, 0xf1, 0xa4, 0x1, 0xd1, 0x81,
    0xff, 0xc8, 0x70, 0xa, 0x30, 0x3f, 0xf9, 0x4e,
    0x8, 0xc0, 0xff, 0xe1, 0x80,

    /* U+F00D "" */
    0x3, 0xff, 0x92, 0xff, 0x20, 0x3f, 0x8e, 0xf4,
    0x3, 0x80, 0x2a, 0x3, 0xe3, 0x88, 0x54, 0x40,
    0x35, 0x40, 0x71, 0xc0, 0x64, 0x48, 0xe, 0xa8,
    0x8, 0xe0, 0x3c, 0x78, 0x1e, 0xa8, 0x1c, 0x7,
    0xa8, 0x38, 0xf, 0x57, 0x80, 0xf5, 0x40, 0xe,
    0x3, 0xd0, 0xf, 0x54, 0x6, 0x38, 0xf, 0xfa,
    0xa0, 0x3c, 0x70, 0x1f, 0xd5, 0x1, 0xf8, 0xd0,
    0x3e, 0x68, 0xf, 0xe3, 0x40, 0xf9, 0xa0, 0x3f,
    0x1c, 0x7, 0xf5, 0x40, 0x78, 0xe0, 0x3f, 0xea,
    0x80, 0xc7, 0x1, 0xe8, 0x7, 0xaa, 0x0, 0x70,
    0x1e, 0xaf, 0x1, 0xea, 0x87, 0x3, 0xd5, 0x3,
    0x80, 0xf5, 0x4, 0xe, 0xa8, 0x8, 0xe0, 0x3c,
    0x60, 0x1a, 0xa0, 0x38, 0xe0, 0x32, 0x2e, 0x0,
    0xa8, 0xf, 0x8e, 0x21, 0x50, 0xf, 0xf2, 0x3,
    0xf8, 0xef, 0x40, 0x0,

    /* U+F011 "" */
    0x3, 0xff, 0x80, 0xe4, 0x30, 0x3f, 0xf9, 0x66,
    0x36, 0x84, 0xf, 0xff, 0xd, 0x80, 0x7f, 0xf0,
    0x25, 0x3, 0xfc, 0x7a, 0x6c, 0x7, 0xf9, 0xb2,
    0xe4, 0xf, 0x8e, 0x2, 0x80, 0x7f, 0xa0, 0x16,
    0x20, 0x7b, 0x81, 0xff, 0xc8, 0xe0, 0x74, 0x20,
    0x6c, 0x7, 0xfb, 0x1, 0x8c, 0x2, 0x2c, 0xd,
    0x88, 0x1f, 0xe3, 0x80, 0xcc, 0x80, 0xa0, 0x6a,
    0x40, 0xff, 0xe0, 0x1a, 0x6, 0xa0, 0x18, 0x11,
    0x40, 0x7f, 0xf0, 0x91, 0x2, 0x60, 0x81, 0xa0,
    0x1f, 0xfc, 0x4a, 0x6, 0x28, 0xc, 0x80, 0xff,
    0xe2, 0x30, 0x32, 0x3, 0xff, 0x9f, 0xf8, 0x8,
    0x81, 0xff, 0xc6, 0x20, 0x7e, 0x20, 0x78, 0x81,
    0x88, 0x1e, 0x20, 0x5f, 0x80, 0xff, 0xbe, 0xce,
    0x7, 0xff, 0x1, 0x1, 0x90, 0x1f, 0x12, 0x3,
    0xe4, 0x6, 0x44, 0xd, 0xc0, 0xff, 0xe2, 0x70,
    0x31, 0xc, 0x9, 0x20, 0x1f, 0xfc, 0x24, 0x80,
    0x4c, 0x5, 0x3, 0x52, 0x7, 0xff, 0x0, 0xd0,
    0x35, 0x0, 0x58, 0x1b, 0x10, 0x3f, 0xc7, 0x1,
    0x99, 0x2, 0x80, 0x76, 0x80, 0x7e, 0x98, 0xc,
    0x60, 0x1d, 0x80, 0xe7, 0xeb, 0x48, 0xef, 0x60,
    0x77, 0x3, 0xc7, 0x1, 0xe5, 0x2d, 0x44, 0x7,
    0xb1, 0x3, 0xe3, 0x88, 0x1f, 0xfc, 0x23, 0xc8,
    0x1f, 0xc7, 0x40, 0x3f, 0xf8, 0x13, 0x1, 0xff,
    0xc1, 0x7e, 0xb2, 0x6, 0x2e, 0xf6, 0x7, 0xff,
    0x11, 0x4d, 0xfe, 0xd1, 0x1, 0xfc,

    /* U+F013 "" */
    0x3, 0xff, 0xb0, 0x77, 0xfb, 0x30, 0x3f, 0xf8,
    0xec, 0x81, 0x8e, 0x3, 0xff, 0xc5, 0x80, 0xf3,
    0x3, 0xff, 0x83, 0xa0, 0x5, 0x98, 0x1e, 0x3e,
    0x0, 0x79, 0x1, 0xd8, 0xbf, 0x68, 0x81, 0xfc,
    0xf6, 0x43, 0x48, 0x13, 0x20, 0x48, 0xf, 0xfe,
    0x1, 0x20, 0x28, 0x5, 0x0, 0xff, 0xe5, 0x24,
    0xc, 0xf, 0xfe, 0x67, 0x14, 0xf, 0xf4, 0xd9,
    0x48, 0x1f, 0xc8, 0x72, 0x7, 0xee, 0xc9, 0x2c,
    0x80, 0xfd, 0x1, 0xd0, 0xf, 0x50, 0x3d, 0x40,
    0xf2, 0xec, 0x8, 0x81, 0xe4, 0x7, 0xcc, 0xe,
    0x20, 0x7f, 0xc4, 0xf, 0xfe, 0x11, 0x3, 0xfe,
    0x20, 0x7f, 0xf0, 0x88, 0x1c, 0x40, 0xf2, 0x3,
    0xe6, 0x7, 0x10, 0x23, 0xa0, 0x1e, 0xa0, 0x7a,
    0x81, 0xe5, 0xd8, 0xe4, 0xf, 0xdd, 0x92, 0x59,
    0x1, 0xfa, 0xa, 0x7, 0xfa, 0x6c, 0xa4, 0xf,
    0xe4, 0x18, 0x1f, 0xfc, 0xce, 0x2, 0x1, 0xff,
    0xca, 0x48, 0x1, 0x90, 0x24, 0x7, 0xff, 0x0,
    0x90, 0x15, 0x3, 0x62, 0xfd, 0xa2, 0x7, 0xf3,
    0xd9, 0x4d, 0x3, 0xda, 0x0, 0x59, 0x81, 0xe3,
    0xe0, 0x5, 0x90, 0x1f, 0xfc, 0xc, 0x7, 0x98,
    0x1f, 0xfe, 0x26, 0x40, 0xc7, 0x1, 0xff, 0xc7,
    0x3b, 0xfd, 0x98, 0x1f, 0xe0,

    /* U+F015 "" */
    0x3, 0xff, 0x84, 0x5b, 0x1, 0xca, 0x49, 0x1,
    0xff, 0xc6, 0x7a, 0x46, 0x3, 0x76, 0xee, 0x7,
    0xff, 0x16, 0xc0, 0x23, 0xc8, 0x1f, 0xfc, 0xbc,
    0x80, 0xf6, 0x60, 0x7f, 0xf2, 0xf, 0x20, 0x4c,
    0x81, 0x48, 0x3, 0xff, 0x8c, 0xf0, 0x1b, 0x4c,
    0x80, 0x9a, 0x3, 0xff, 0x89, 0x20, 0x8, 0xe2,
    0x42, 0xc0, 0x3f, 0xf8, 0xf5, 0x81, 0x2c, 0x66,
    0xc2, 0xe8, 0x1f, 0xfc, 0x43, 0x90, 0x13, 0xa2,
    0xb0, 0x72, 0x4c, 0x40, 0xff, 0xe0, 0xac, 0x40,
    0xac, 0x39, 0x1, 0xab, 0x39, 0x1, 0x2a, 0x7,
    0x9d, 0x3, 0x64, 0x71, 0x3, 0xd2, 0x8a, 0xc0,
    0x96, 0x3, 0x58, 0x4, 0x79, 0x78, 0xf, 0xe5,
    0x84, 0x80, 0x23, 0xc8, 0xa8, 0x9, 0x61, 0x20,
    0xf, 0xf8, 0xf2, 0xe8, 0x1b, 0x20, 0x34, 0xa2,
    0xb0, 0x3f, 0xf8, 0x59, 0x26, 0x20, 0x4e, 0x91,
    0x59, 0xc8, 0xf, 0xfe, 0x25, 0x87, 0x21, 0x8,
    0xd8, 0x84, 0x20, 0x7f, 0xf1, 0x99, 0x17, 0x30,
    0x22, 0x1, 0x81, 0xff, 0xc8, 0x60, 0x8, 0x1f,
    0xfe, 0x3b, 0xfe, 0x20, 0x7f, 0xf3, 0x98, 0x19,
    0x81, 0xff, 0xff, 0x3, 0xff, 0xf6, 0x80, 0xf1,
    0x20, 0x36, 0x3, 0xe4, 0x7, 0x0,

    /* U+F019 "" */
    0x3, 0xfe, 0x29, 0x62, 0x7, 0xff, 0x25, 0x6b,
    0x76, 0x40, 0x7f, 0xf2, 0x30, 0x1e, 0xc0, 0x7f,
    0xff, 0xc0, 0xff, 0xff, 0x81, 0xff, 0xff, 0x3,
    0xff, 0x85, 0xb7, 0x30, 0x3c, 0xf6, 0xe0, 0x3f,
    0x91, 0x3c, 0x7, 0xe2, 0x79, 0x1, 0xf9, 0x30,
    0x3f, 0xf8, 0x8d, 0x1, 0xfd, 0x18, 0x1f, 0xfc,
    0x27, 0x0, 0xff, 0xa3, 0x3, 0xff, 0x80, 0xe0,
    0x1f, 0xfc, 0x18, 0xc0, 0xff, 0x38, 0x7, 0xff,
    0xe, 0x30, 0x3f, 0x38, 0x7, 0xff, 0x16, 0x30,
    0x3c, 0xe0, 0x1f, 0xfc, 0x78, 0xc0, 0xce, 0x1,
    0xfe, 0xbf, 0xfe, 0xc2, 0x30, 0xe, 0xd, 0xff,
    0xea, 0x80, 0xfc, 0x79, 0x93, 0x1c, 0x40, 0xfc,
    0x80, 0xff, 0xb1, 0x6c, 0x71, 0x3, 0xff, 0x95,
    0xb6, 0x3, 0xff, 0x9a, 0x48, 0xf, 0xfe, 0xa5,
    0xe1, 0x76, 0x7, 0xff, 0x2c, 0x86, 0x7, 0xff,
    0x32, 0xe0, 0x7b, 0x2, 0xd1, 0xbf, 0xfe, 0x64,
    0xc0,

    /* U+F01C "" */
    0x3, 0xc6, 0xff, 0xff, 0xc4, 0x80, 0x7f, 0xf0,
    0x72, 0x3, 0xff, 0x88, 0xe0, 0x1f, 0xf5, 0x3,
    0xff, 0x8e, 0xc8, 0x1f, 0xc9, 0x0, 0x16, 0xff,
    0xf8, 0x40, 0x5c, 0xf, 0xea, 0x5, 0xe4, 0xff,
    0xe1, 0x20, 0x6, 0x1, 0xf5, 0x2, 0x64, 0xf,
    0xfe, 0x15, 0x2, 0x64, 0xe, 0x48, 0x0, 0xc0,
    0x3f, 0xf8, 0x94, 0xb, 0x81, 0xd4, 0xb, 0x81,
    0xff, 0xc5, 0x48, 0x0, 0xc0, 0x2a, 0x4, 0xc8,
    0x1f, 0xfc, 0x6a, 0x4, 0xc8, 0x48, 0x0, 0xc0,
    0x3f, 0xf9, 0x14, 0xb, 0x88, 0x4, 0xe4, 0xe6,
    0x7, 0xf2, 0x93, 0xb0, 0x11, 0x44, 0x9, 0x37,
    0xd1, 0x81, 0xfa, 0xb7, 0xe0, 0x31, 0x3, 0xfe,
    0x80, 0x7c, 0xc0, 0xff, 0xb8, 0x1f, 0xfc, 0x6,
    0x7, 0xa0, 0x1f, 0xfc, 0xc9, 0xff, 0x80, 0xff,
    0xff, 0x81, 0xff, 0xf5, 0xe8, 0xf, 0xfe, 0x92,
    0xa8, 0xf, 0xfe, 0x85, 0x20,

    /* U+F021 "" */
    0x3, 0xff, 0x98, 0xa4, 0x30, 0x3f, 0x94, 0xdf,
    0xea, 0xc8, 0x1d, 0x1b, 0x40, 0x3e, 0x7a, 0xb2,
    0x6, 0x53, 0x52, 0x7, 0xff, 0x6, 0xc2, 0x7,
    0xf9, 0x6a, 0x7, 0xf8, 0xf4, 0x7, 0xff, 0x9,
    0x72, 0xc0, 0xf1, 0xc0, 0x73, 0xbf, 0xea, 0x80,
    0xec, 0xc0, 0xf7, 0x3, 0x1d, 0x10, 0x19, 0x5c,
    0x40, 0xc4, 0xe, 0x84, 0x9, 0xe2, 0x7, 0xe3,
    0x98, 0x1f, 0x8b, 0x2, 0x70, 0xf, 0xfe, 0x4,
    0x60, 0x7d, 0x40, 0x8c, 0x3, 0xf1, 0xff, 0x98,
    0x1f, 0x30, 0x28, 0x7, 0xf3, 0x3, 0xff, 0x80,
    0x40, 0xc8, 0xf, 0xfe, 0x5a, 0x25, 0x0, 0xff,
    0x24, 0x27, 0xfc, 0x8d, 0xd8, 0xc0, 0xff, 0xae,
    0xdf, 0xea, 0x7, 0xff, 0xb2, 0xed, 0xfe, 0xa0,
    0x7f, 0xce, 0xea, 0x51, 0x3f, 0xe4, 0x80, 0x7f,
    0xa2, 0x28, 0xf, 0xfe, 0x5a, 0x3, 0x10, 0x3f,
    0xf8, 0xc, 0xf, 0xe8, 0x4, 0xc0, 0xf9, 0xff,
    0xc4, 0xf, 0xd4, 0x81, 0x50, 0x3e, 0x70, 0xf,
    0xfe, 0x4, 0x40, 0x4c, 0x81, 0xf9, 0xd2, 0x7,
    0xe3, 0x98, 0x11, 0x80, 0x71, 0x3, 0x2d, 0x50,
    0x19, 0x5c, 0x40, 0xdc, 0xf, 0x3c, 0x7, 0x2b,
    0xfe, 0xa8, 0xe, 0xc4, 0xf, 0x33, 0xd0, 0x1f,
    0xfc, 0x25, 0xc8, 0x1f, 0xeb, 0x90, 0x1f, 0xe3,
    0x28, 0x1f, 0xfc, 0x13, 0x74, 0x20, 0x62, 0xee,
    0x60, 0x7d, 0x1b, 0x40, 0x38, 0xbd, 0xfe, 0xd1,
    0x1, 0xfc,

    /* U+F026 "" */
    0x3, 0xff, 0x9a, 0x6b, 0x3, 0xfc, 0x72, 0x80,
    0x7f, 0x1c, 0x7, 0xfc, 0x70, 0x1f, 0xf1, 0xc0,
    0x71, 0x93, 0xd8, 0xf, 0x66, 0xfc, 0x7, 0xff,
    0xfc, 0xf, 0xff, 0x3, 0x3, 0xff, 0x83, 0x3f,
    0xf3, 0x3, 0xff, 0x83, 0x18, 0x1f, 0xfc, 0x18,
    0xc0, 0xff, 0xe0, 0xc6, 0x7, 0xff, 0x6, 0x30,
    0x40, 0xff, 0xa7, 0xc0,

    /* U+F027 "" */
    0x3, 0xff, 0xa8, 0x6b, 0x3, 0xff, 0x8a, 0x72,
    0x80, 0x7f, 0xf1, 0xe, 0x3, 0xff, 0x8c, 0x70,
    0x1f, 0xfc, 0x63, 0x80, 0xff, 0xe0, 0x19, 0x3d,
    0x80, 0xff, 0xe0, 0xe6, 0xfc, 0x7, 0xfa, 0xc0,
    0x3f, 0xf8, 0xcd, 0x3c, 0x7, 0xff, 0x15, 0x90,
    0x58, 0x1f, 0xfc, 0x5c, 0x2, 0x81, 0xff, 0xc6,
    0x40, 0x81, 0xff, 0xc6, 0x60, 0x81, 0xff, 0xc5,
    0xa4, 0x20, 0x3f, 0xf8, 0x8d, 0x3, 0x0, 0xff,
    0xe2, 0x22, 0xb0, 0x60, 0x7f, 0xf0, 0xce, 0xa0,
    0x27, 0xfe, 0x60, 0x7f, 0xf2, 0x23, 0x3, 0xff,
    0x91, 0x18, 0x1f, 0xfc, 0x88, 0xc0, 0xff, 0xe4,
    0x46, 0x8, 0x1f, 0xfc, 0x69, 0xb0, 0xf, 0x80,

    /* U+F028 "" */
    0x3, 0xff, 0x97, 0x10, 0x1f, 0xfd, 0x16, 0xd6,
    0x80, 0xff, 0xe8, 0x20, 0xb, 0x1, 0xff, 0xc4,
    0x35, 0x81, 0xf8, 0xe2, 0xe, 0x3, 0xff, 0x84,
    0x72, 0x80, 0x78, 0x80, 0x38, 0x83, 0x0, 0xff,
    0xe0, 0x1c, 0x7, 0xe5, 0xba, 0x1, 0x80, 0x32,
    0x7, 0xf8, 0xe0, 0x3f, 0xf8, 0x15, 0x80, 0xa0,
    0x38, 0x1f, 0xc7, 0x1, 0xfe, 0x50, 0x4, 0x41,
    0x20, 0x28, 0x19, 0x3d, 0x80, 0xff, 0xe0, 0x3a,
    0x2, 0x80, 0x80, 0x38, 0xcd, 0xf8, 0xf, 0xf6,
    0xa0, 0x13, 0x0, 0xc1, 0x20, 0x80, 0xff, 0xe2,
    0xb2, 0xb0, 0x8, 0x2, 0x80, 0x40, 0x8, 0x1f,
    0xfc, 0x46, 0x41, 0x80, 0x10, 0x20, 0x30, 0x6,
    0x7, 0xff, 0x17, 0x10, 0x80, 0x60, 0x4, 0x30,
    0x4, 0xf, 0xfe, 0x33, 0x4, 0xf, 0xfe, 0x8b,
    0x4, 0xf, 0xfe, 0x86, 0x21, 0x0, 0xc0, 0x8,
    0x60, 0x8, 0x1f, 0xfc, 0x46, 0x41, 0x80, 0x10,
    0x20, 0x30, 0x6, 0x7, 0xff, 0x11, 0x95, 0x80,
    0x40, 0x14, 0x2, 0x0, 0x58, 0x1f, 0xfc, 0x4d,
    0x40, 0x26, 0x1, 0x82, 0x41, 0x9, 0xff, 0x98,
    0x1f, 0xfc, 0x7, 0x40, 0x50, 0x10, 0x7, 0x3,
    0xf4, 0x60, 0x7f, 0x94, 0x1, 0x10, 0x48, 0xa,
    0x3, 0xfa, 0x30, 0x3f, 0xf8, 0x15, 0x80, 0xa0,
    0x38, 0x1f, 0xf4, 0x60, 0x7e, 0x5b, 0xa0, 0x18,
    0x3, 0x20, 0x7f, 0xf0, 0x23, 0x4, 0xf, 0x10,
    0x7, 0x10, 0x60, 0x1f, 0xfc, 0x29, 0xf0, 0x1f,
    0x8e, 0x20, 0xe0, 0x3f, 0xf9, 0xc8, 0x2, 0xc0,
    0x7f, 0xf3, 0xdb, 0x5a, 0x3, 0xc0,

    /* U+F03E "" */
    0x17, 0xff, 0xfe, 0x65, 0x15, 0x1, 0xff, 0xcc,
    0x55, 0x1, 0xff, 0xce, 0x40, 0x67, 0xb2, 0x1,
    0xff, 0xcb, 0x70, 0x93, 0xa0, 0x7f, 0xf2, 0xa8,
    0x19, 0x1, 0xff, 0xd9, 0x2c, 0xf, 0xf9, 0x1,
    0x88, 0x1f, 0x8e, 0x90, 0x7, 0xfa, 0x20, 0x7,
    0x81, 0xf1, 0xc0, 0x1c, 0x3, 0xfd, 0x7f, 0x62,
    0x7, 0x8e, 0x3, 0x38, 0x7, 0xff, 0x1c, 0xe0,
    0x3c, 0xe0, 0x1f, 0xe3, 0xf0, 0x18, 0xe0, 0x3f,
    0x36, 0x3, 0xf1, 0xc0, 0xe0, 0x7, 0x1, 0xff,
    0xc6, 0x38, 0x8, 0xe5, 0x80, 0xff, 0xe3, 0x1c,
    0x7, 0x1a, 0x7, 0xff, 0x1d, 0x1, 0xff, 0xeb,
    0x52, 0x7f, 0xf2, 0x10, 0x1e, 0x2d, 0xff, 0xf2,
    0x8, 0x12, 0x3, 0xff, 0x9c, 0xaa, 0x3, 0xff,
    0x98, 0xa8,

    /* U+F048 "" */
    0x52, 0x40, 0x7f, 0xcd, 0x87, 0x6e, 0x20, 0x7f,
    0x59, 0x20, 0x3f, 0xf8, 0x39, 0x0, 0x40, 0x7f,
    0xf0, 0x31, 0x3, 0xff, 0x84, 0x79, 0x3, 0xff,
    0x84, 0x70, 0x1f, 0xfc, 0x35, 0x80, 0xff, 0xe1,
    0xaa, 0x7, 0xff, 0xd, 0xd0, 0x3f, 0xf8, 0x6e,
    0x1, 0xff, 0xc3, 0x90, 0x7, 0xff, 0x11, 0x1,
    0xff, 0xfb, 0xa4, 0xf, 0xfe, 0x23, 0xc4, 0xf,
    0xfe, 0x2e, 0x40, 0x7f, 0xf1, 0x6a, 0x3, 0xff,
    0x8b, 0x58, 0x1f, 0xfc, 0x58, 0xc0, 0xff, 0xe2,
    0xc8, 0x3, 0xff, 0x8a, 0xe8, 0x1f, 0xfc, 0x55,
    0x40, 0x99, 0x3, 0xff, 0x80, 0xb1, 0x29, 0x1f,
    0xc4, 0xf, 0xe3, 0xb0, 0x80,

    /* U+F04B "" */
    0x5, 0xa0, 0x3f, 0xf9, 0x2f, 0x4b, 0x88, 0x1f,
    0xfc, 0x78, 0x4, 0x74, 0x3, 0xff, 0x98, 0xfb,
    0x3, 0xff, 0x99, 0x31, 0x3, 0xff, 0x96, 0x75,
    0x3, 0xff, 0x98, 0xbb, 0x3, 0xff, 0x99, 0x32,
    0x3, 0xff, 0x96, 0x6d, 0x10, 0x3f, 0xf9, 0x6b,
    0x40, 0x3f, 0xf9, 0x8f, 0xa0, 0x3f, 0xf9, 0x96,
    0x88, 0x1f, 0xfc, 0xb5, 0x98, 0x1f, 0xfc, 0xc8,
    0x80, 0xff, 0xe6, 0x10, 0x3f, 0xf9, 0x84, 0xf,
    0xfe, 0x5c, 0x40, 0x7f, 0xf2, 0x56, 0x60, 0x7f,
    0xf2, 0x6d, 0x10, 0x3f, 0xf9, 0xf, 0xa0, 0x3f,
    0xf9, 0xb, 0x40, 0x3f, 0xf9, 0x6, 0xd1, 0x3,
    0xff, 0x91, 0x32, 0x3, 0xff, 0x90, 0xbb, 0x3,
    0xff, 0x90, 0x75, 0x3, 0xff, 0x93, 0x31, 0x3,
    0xff, 0x90, 0xfb, 0x3, 0xff, 0x89, 0x0, 0x8e,
    0x80, 0x7f, 0xf1, 0x9e, 0x97, 0x10, 0x3f, 0xf8,
    0xe0,

    /* U+F04C "" */
    0x17, 0xff, 0x64, 0x7, 0x5f, 0xfd, 0x90, 0xa8,
    0xf, 0x1a, 0x40, 0xaa, 0x3, 0xc6, 0x94, 0x7,
    0xf2, 0x2, 0x40, 0x7f, 0x20, 0x3f, 0xdc, 0xf,
    0xfe, 0xf, 0x3, 0xff, 0xfe, 0x7, 0xff, 0xfc,
    0xf, 0xff, 0xf8, 0x1f, 0xff, 0xf0, 0x3f, 0xff,
    0xe0, 0x7f, 0xfc, 0x38, 0x1f, 0xfc, 0x1e, 0x7,
    0xff, 0x36, 0x1, 0xf8, 0xb0, 0x28, 0x7, 0xe2,
    0xda, 0xb7, 0xe9, 0x80, 0xce, 0xb7, 0xe9, 0x80,

    /* U+F04D "" */
    0x6, 0x4f, 0xfe, 0x43, 0x0, 0xf3, 0x7f, 0xfc,
    0x89, 0x84, 0x3, 0xff, 0x94, 0x58, 0x1f, 0xfe,
    0x5e, 0x7, 0xff, 0xfc, 0xf, 0xff, 0xf8, 0x1f,
    0xff, 0xf0, 0x3f, 0xff, 0xe0, 0x7f, 0xff, 0xc0,
    0xff, 0xff, 0x74, 0x7, 0xff, 0x2d, 0x54, 0x7,
    0xff, 0x20, 0xd2,

    /* U+F051 "" */
    0xa, 0x1, 0xff, 0x39, 0xd, 0x57, 0xc8, 0x1f,
    0xd1, 0xb4, 0x20, 0x58, 0x81, 0xff, 0xc0, 0xe0,
    0x6c, 0x80, 0xff, 0xe2, 0xd4, 0x7, 0xff, 0x16,
    0xb0, 0x3f, 0xf8, 0xb2, 0x0, 0xff, 0xe2, 0xb8,
    0x7, 0xff, 0x15, 0xd0, 0x3f, 0xf8, 0xaa, 0x81,
    0xff, 0xc5, 0x58, 0xf, 0xfe, 0x29, 0x3, 0xff,
    0xf7, 0x80, 0xff, 0xe2, 0x62, 0x7, 0xff, 0x8,
    0xe2, 0x7, 0xff, 0x8, 0xe2, 0x7, 0xff, 0x8,
    0xe0, 0x3f, 0xf8, 0x6b, 0x1, 0xff, 0xc3, 0x54,
    0xf, 0xfe, 0x1b, 0xa0, 0x7f, 0xdc, 0x9, 0xc0,
    0x3f, 0xf8, 0xc, 0x89, 0x0, 0x7f, 0x10, 0x4,
    0x6e, 0xc0, 0xff, 0x6f, 0xd8,

    /* U+F052 "" */
    0x3, 0xff, 0x81, 0x2a, 0x3, 0xff, 0x95, 0xda,
    0xb0, 0xf, 0xfe, 0x46, 0x3, 0x36, 0x3, 0xff,
    0x8d, 0x88, 0x1d, 0x10, 0x1f, 0xfc, 0x4a, 0x40,
    0xfa, 0xa0, 0x3f, 0xf8, 0x55, 0x1, 0xfd, 0x48,
    0x1f, 0xfc, 0x8, 0x80, 0xff, 0xb1, 0x3, 0xfd,
    0x18, 0x1f, 0xfc, 0x1c, 0x7, 0xf3, 0x60, 0x3f,
    0xf8, 0x78, 0xf, 0x94, 0x3, 0xff, 0x88, 0x70,
    0x1c, 0xa8, 0x1f, 0xfc, 0x63, 0x40, 0x8d, 0x3,
    0xff, 0x90, 0xa8, 0xe, 0x7, 0xff, 0x29, 0x20,
    0x20, 0x7f, 0xf2, 0xc8, 0x40, 0x7f, 0xf2, 0xd0,
    0xa8, 0xf, 0xfe, 0x4c, 0x20, 0x2f, 0xff, 0xfc,
    0x96, 0x7, 0xff, 0x41, 0xff, 0xff, 0xca, 0xc0,
    0x20, 0x1f, 0xfc, 0xa2, 0xc0, 0xff, 0xe6, 0xf0,
    0x3f, 0xff, 0xe0, 0x38, 0xa0, 0x7f, 0xf2, 0x93,

    /* U+F053 "" */
    0x3, 0xfe, 0x30, 0x81, 0xff, 0xc0, 0x59, 0xe2,
    0x7, 0xf9, 0x50, 0x2c, 0x7, 0xf2, 0xa0, 0x62,
    0x7, 0xe5, 0x40, 0xc7, 0x1, 0xf2, 0xa0, 0x63,
    0x80, 0xf9, 0x50, 0x31, 0xc0, 0x7c, 0xa8, 0x18,
    0xe0, 0x3e, 0x54, 0xc, 0x70, 0x1f, 0x2a, 0x6,
    0x38, 0xf, 0x95, 0x3, 0x1c, 0x7, 0xc6, 0x81,
    0x8e, 0x3, 0xf2, 0x3, 0xa8, 0x1f, 0xcd, 0x1,
    0xa3, 0x3, 0xfa, 0xa0, 0x34, 0x60, 0x7f, 0x54,
    0x6, 0x8c, 0xf, 0xea, 0x80, 0xd1, 0x81, 0xfd,
    0x50, 0x1a, 0x30, 0x3f, 0xa9, 0x3, 0x46, 0x7,
    0xf6, 0x20, 0x68, 0xc0, 0xfe, 0xc4, 0xd, 0x18,
    0x1f, 0xd8, 0x81, 0xa0, 0x1f, 0xec, 0x40, 0x90,
    0x1f, 0xf6, 0x41, 0x50, 0x3f, 0xf8, 0x17, 0x50,
    0x0,

    /* U+F054 "" */
    0x0, 0xe0, 0x1f, 0xfc, 0x1b, 0x1d, 0x3, 0xfe,
    0x68, 0x2, 0xa0, 0x7f, 0x88, 0x19, 0x50, 0x3f,
    0x94, 0x3, 0x2a, 0x7, 0xf3, 0x80, 0x65, 0x40,
    0xfe, 0x70, 0xc, 0xa8, 0x1f, 0xce, 0x1, 0x95,
    0x3, 0xf9, 0xc0, 0x32, 0xa0, 0x7f, 0x38, 0x6,
    0x54, 0xf, 0xe7, 0x0, 0xca, 0x81, 0xfc, 0xe0,
    0x19, 0x50, 0x3f, 0x98, 0x1c, 0x80, 0xfe, 0xc0,
    0x75, 0x3, 0xf6, 0x20, 0x6a, 0x80, 0xfb, 0x10,
    0x35, 0x40, 0x7d, 0x88, 0x1a, 0xa0, 0x3e, 0xc4,
    0xd, 0x50, 0x1f, 0x62, 0x6, 0xa8, 0xf, 0xb1,
    0x3, 0x54, 0x7, 0xd8, 0x81, 0xaa, 0x3, 0xe6,
    0x40, 0xd5, 0x1, 0xf9, 0x1, 0xaa, 0x3, 0xf8,
    0xe0, 0x15, 0x1, 0xff, 0x1f, 0xc8, 0xf, 0xf8,

    /* U+F067 "" */
    0x3, 0xfc, 0xad, 0x40, 0x3f, 0xf9, 0x6, 0xa4,
    0x74, 0xf, 0xfe, 0x3b, 0x3, 0x30, 0x3f, 0xf8,
    0xe4, 0xc, 0x40, 0xff, 0xff, 0x81, 0xff, 0xff,
    0x3, 0xfc, 0xff, 0xfd, 0x0, 0xef, 0xff, 0x61,
    0x0, 0xff, 0xe5, 0x16, 0x7, 0xff, 0x33, 0x81,
    0xff, 0xcc, 0xec, 0xf, 0xfe, 0x5a, 0x9b, 0x7e,
    0x60, 0x76, 0xdf, 0xb9, 0x4, 0xfe, 0xe0, 0x71,
    0x3f, 0x80, 0xff, 0xff, 0x81, 0xff, 0xff, 0x3,
    0xfe, 0x20, 0x62, 0x7, 0xff, 0x1d, 0x32, 0x6e,
    0x7, 0xf8,

    /* U+F068 "" */
    0x0, 0x4f, 0xff, 0x20, 0xa, 0x7d, 0xbf, 0xf9,
    0x1f, 0x83, 0x3, 0xff, 0x96, 0xc0, 0xff, 0xe6,
    0x70, 0x3f, 0xf9, 0x9e, 0x1, 0xff, 0xcb, 0x6d,
    0xf6, 0xff, 0xe4, 0x7e, 0x0,

    /* U+F06E "" */
    0x3, 0xfc, 0x5d, 0xdf, 0xed, 0x10, 0x1f, 0xfc,
    0x75, 0xb2, 0x22, 0x6, 0x2e, 0xfa, 0x40, 0xff,
    0xe1, 0x1d, 0x48, 0x19, 0x28, 0x81, 0x96, 0x80,
    0x7f, 0xf0, 0x26, 0x20, 0x46, 0xfb, 0x6d, 0xd8,
    0x19, 0xf4, 0x7, 0xf5, 0x60, 0x65, 0x90, 0x1e,
    0x98, 0xe, 0xac, 0xf, 0xb2, 0x3, 0x2a, 0x4,
    0x64, 0x20, 0x7, 0x1, 0xd1, 0x81, 0xd4, 0x81,
    0xd4, 0xe, 0x6d, 0x71, 0x6, 0x81, 0xd1, 0x1,
    0x34, 0x7, 0x40, 0x3f, 0x8e, 0x0, 0x88, 0x1d,
    0x48, 0x30, 0xf, 0x20, 0x3a, 0x1, 0xd0, 0x2,
    0x3, 0xdc, 0x40, 0x3e, 0x21, 0x47, 0x50, 0x1c,
    0x80, 0x60, 0x3c, 0x52, 0x1, 0xfc, 0x5c, 0x40,
    0x78, 0x81, 0xfe, 0xc8, 0xf, 0xfe, 0x96, 0xa0,
    0x7c, 0x43, 0x3, 0xf9, 0x80, 0xc0, 0x78, 0xa1,
    0x0, 0xf2, 0x0, 0xc0, 0xfd, 0x40, 0x20, 0x3d,
    0xc0, 0x34, 0x7, 0x40, 0x11, 0x1, 0xea, 0x42,
    0x20, 0x75, 0x20, 0x55, 0x1, 0xd4, 0x5, 0xa4,
    0x49, 0xf4, 0xd, 0x3, 0xa2, 0x3, 0xaa, 0x3,
    0x2a, 0x1, 0x5d, 0x90, 0x1, 0xc0, 0x74, 0x60,
    0x7d, 0x60, 0x19, 0x64, 0x7, 0xa6, 0x3, 0xab,
    0x3, 0xf9, 0xe2, 0x4, 0x6f, 0xb6, 0xdd, 0x81,
    0x9f, 0x40, 0x7f, 0xc7, 0x52, 0x6, 0x4a, 0x20,
    0x65, 0xa0, 0x1f, 0xfc, 0x35, 0xb2, 0x22, 0x6,
    0x2e, 0xfa, 0x40, 0xfc,

    /* U+F070 "" */
    0x9, 0x0, 0xff, 0xea, 0x2b, 0x50, 0xf, 0xfe,
    0x9d, 0x0, 0xf0, 0x1f, 0xfd, 0x26, 0x4, 0x79,
    0x3, 0xff, 0xa1, 0x28, 0x1b, 0x30, 0x31, 0x77,
    0x7f, 0x6a, 0xc8, 0x1f, 0xfc, 0x15, 0x88, 0x14,
    0xa1, 0xec, 0x88, 0x81, 0x15, 0x36, 0x30, 0x3f,
    0xf8, 0x7, 0x20, 0x25, 0xe1, 0x3, 0x25, 0x1,
    0x8c, 0xec, 0xf, 0xfe, 0x5, 0x80, 0x7c, 0x6f,
    0xb6, 0xf9, 0x1, 0xa5, 0x3, 0xff, 0x80, 0xf0,
    0x1c, 0x72, 0x3, 0x8d, 0x80, 0x65, 0xc8, 0x1f,
    0xf1, 0xe8, 0x8, 0xe0, 0xe, 0xd2, 0x0, 0xe0,
    0x1d, 0x88, 0x1f, 0xfc, 0xa, 0xc0, 0x8f, 0x41,
    0x25, 0xc0, 0x1a, 0x3, 0xb8, 0x1f, 0x5c, 0x40,
    0xa5, 0x3, 0x5a, 0x2, 0x38, 0x4, 0x3, 0x8d,
    0x3, 0x92, 0x1c, 0x80, 0x96, 0x20, 0x44, 0xc,
    0x50, 0x20, 0x79, 0x20, 0x1a, 0x81, 0x58, 0x4,
    0x72, 0x3, 0xf7, 0x0, 0x80, 0xf5, 0x2, 0x20,
    0x73, 0xc4, 0xa, 0xc0, 0x3f, 0xf8, 0xc4, 0x1,
    0x3, 0xc7, 0x81, 0x9e, 0x3, 0xf9, 0x81, 0xf1,
    0x2, 0xa0, 0x78, 0x81, 0xc7, 0xa0, 0x33, 0x20,
    0x81, 0xea, 0x6, 0x48, 0x7, 0x90, 0x1e, 0xb0,
    0x8, 0xe8, 0x7, 0x9a, 0x3, 0xa9, 0x3, 0xa0,
    0x1f, 0x3a, 0x6, 0x60, 0x71, 0x80, 0x7d, 0xc0,
    0xe3, 0x0, 0xf9, 0x72, 0x7, 0xec, 0x7, 0xe3,
    0x88, 0x19, 0xb0, 0x1f, 0xb3, 0x3, 0xd8, 0xf,
    0xf1, 0xc8, 0xd, 0x32, 0x3, 0xe9, 0x40, 0xe4,
    0x7, 0xff, 0x2, 0xc0, 0x31, 0xbe, 0xd9, 0x1,
    0x2c, 0x40, 0xa5, 0x3, 0xff, 0x80, 0xfc, 0x20,
    0x64, 0xab, 0x0, 0x8e, 0x40, 0x4b, 0x10, 0x3f,
    0xf8, 0xf, 0x64, 0x44, 0x8, 0x92, 0x3, 0x58,
    0x4, 0x72, 0x3, 0xff, 0x82, 0x5d, 0xdf, 0xda,
    0xa0, 0x39, 0xe0, 0x35, 0x80, 0x7f, 0xf4, 0xf,
    0x20, 0x4c, 0xf, 0xfe, 0x96, 0x60, 0x28, 0x1f,
    0xfd, 0x39, 0x69, 0x0,

    /* U+F071 "" */
    0x3, 0xff, 0x86, 0xa3, 0x3, 0xff, 0xa2, 0xab,
    0x98, 0xf, 0xfe, 0x85, 0x2, 0x2c, 0xf, 0xfe,
    0x74, 0x3, 0xa0, 0x1f, 0xfc, 0xd2, 0xc0, 0xf5,
    0x3, 0xff, 0x99, 0x0, 0xf9, 0x10, 0x3f, 0xf9,
    0x49, 0x0, 0xfd, 0xc0, 0xff, 0xe5, 0x40, 0x3f,
    0x8a, 0x3, 0xff, 0x90, 0xc8, 0x1f, 0xea, 0x7,
    0xff, 0x22, 0x1, 0xff, 0xc0, 0x80, 0x7f, 0xf1,
    0xa0, 0x19, 0xff, 0x80, 0xcc, 0xf, 0xfe, 0x29,
    0x60, 0x6e, 0x7, 0xf5, 0x3, 0xff, 0x89, 0x0,
    0xff, 0xe1, 0xa2, 0x7, 0xff, 0x9, 0x20, 0x1d,
    0xc0, 0xff, 0x70, 0x3f, 0xf8, 0x50, 0xf, 0xfe,
    0x29, 0x40, 0x7f, 0xf0, 0x19, 0x3, 0xff, 0x8d,
    0x40, 0xff, 0xe0, 0x40, 0x3e, 0x20, 0x44, 0xf,
    0xd0, 0xf, 0xf4, 0x3, 0xff, 0x92, 0xc0, 0xfe,
    0x2c, 0xf, 0xcc, 0x9, 0x1, 0xfd, 0x40, 0xfd,
    0x0, 0xfe, 0x3f, 0xd0, 0xf, 0xe4, 0x40, 0xf2,
    0x40, 0x3f, 0xd7, 0xf2, 0x3, 0xfd, 0xc0, 0xf4,
    0x3, 0xfd, 0x10, 0xa, 0x7, 0xf8, 0xb0, 0x33,
    0x20, 0x7f, 0x88, 0x18, 0x81, 0xfe, 0x80, 0x68,
    0x7, 0xfd, 0x80, 0xc4, 0xf, 0xfa, 0x0, 0x80,
    0x7f, 0xf0, 0x1b, 0x3, 0x80, 0xff, 0xe0, 0x30,
    0xc, 0xf, 0xfe, 0xc, 0xf8, 0x81, 0xff, 0xc1,
    0x60, 0x7f, 0xf5, 0xa0, 0x1f, 0xfd, 0x26, 0x1d,
    0x6f, 0xff, 0x9f, 0x38,

    /* U+F074 "" */
    0x3, 0xff, 0x92, 0xe9, 0x3, 0xff, 0x9b, 0x16,
    0x20, 0x7f, 0xf3, 0xf1, 0x0, 0x52, 0xe2, 0x7,
    0xf8, 0xa5, 0x1, 0xb1, 0x1a, 0xde, 0xd4, 0xf,
    0xc7, 0x5b, 0x1, 0xd8, 0x81, 0xf2, 0xa0, 0x78,
    0xe0, 0x3f, 0xd8, 0xf, 0xca, 0x1, 0x8e, 0x3,
    0xfe, 0x20, 0x7f, 0x38, 0x5, 0x80, 0xff, 0x8e,
    0xfb, 0x68, 0x6, 0x20, 0x30, 0x18, 0xec, 0x3,
    0x1c, 0x0, 0x9c, 0xe0, 0x5, 0x46, 0x20, 0x47,
    0x12, 0x2, 0x38, 0xf, 0xcd, 0x8d, 0x18, 0x81,
    0xb8, 0x1c, 0x70, 0x1f, 0xe9, 0x85, 0x20, 0x6c,
    0x40, 0xab, 0xc0, 0x7f, 0xf0, 0x6a, 0x3, 0x62,
    0x6, 0x50, 0xf, 0xfe, 0xc, 0x40, 0x6a, 0x40,
    0xe5, 0x0, 0xff, 0xe0, 0x46, 0x6, 0xa9, 0x39,
    0x2, 0xaf, 0x90, 0x3f, 0x9b, 0x1, 0xa2, 0x4a,
    0x38, 0x1e, 0xc4, 0x8, 0x9c, 0xe0, 0x1a, 0x33,
    0x40, 0x1c, 0x48, 0xd, 0x88, 0xfb, 0x68, 0x6,
    0x6c, 0x8, 0x18, 0xec, 0x3, 0xb1, 0x3, 0xf9,
    0xc0, 0x2c, 0x7, 0xff, 0x3, 0x81, 0xf9, 0x40,
    0x31, 0xc0, 0x7f, 0xf1, 0xd5, 0x3, 0xc7, 0x1,
    0xfe, 0xfa, 0xde, 0xd4, 0xf, 0xc7, 0x5b, 0x1,
    0xd8, 0x92, 0x5c, 0x40, 0xff, 0x14, 0xa0, 0x36,
    0x20, 0x7f, 0xf3, 0x71, 0x3, 0xff, 0x97, 0x16,
    0x20, 0x40,

    /* U+F077 "" */
    0x3, 0xfe, 0x74, 0x81, 0xff, 0xc9, 0x90, 0xb1,
    0x3, 0xff, 0x8f, 0x18, 0x16, 0x20, 0x7f, 0xf1,
    0x63, 0x3, 0xb1, 0x3, 0xff, 0x87, 0x18, 0x1f,
    0x62, 0x7, 0xff, 0x6, 0x30, 0x3f, 0xb1, 0x3,
    0xfe, 0x8c, 0xc, 0xb0, 0x1d, 0x88, 0x1f, 0xd1,
    0x81, 0x95, 0x38, 0xe, 0xc4, 0xf, 0xa3, 0x3,
    0x2a, 0x0, 0xe0, 0x3b, 0x10, 0x3a, 0x30, 0x32,
    0xa0, 0x63, 0x80, 0xec, 0x40, 0xa3, 0x3, 0x2a,
    0x7, 0x8e, 0x3, 0xb1, 0xd, 0x80, 0xca, 0x81,
    0xf8, 0xe0, 0x3b, 0xe, 0x6, 0x54, 0xf, 0xf1,
    0xc0, 0x7a, 0x10, 0xa, 0x81, 0xff, 0xc0, 0x38,
    0xa, 0x0, 0xc9, 0xd0, 0x3f, 0xf8, 0x47, 0x2a,
    0xc0,

    /* U+F078 "" */
    0x1, 0x60, 0x1f, 0xfc, 0x43, 0x58, 0x16, 0x4e,
    0x81, 0xff, 0xc2, 0x39, 0x46, 0x21, 0x0, 0xa8,
    0x1f, 0xfc, 0x3, 0x80, 0xa0, 0xe0, 0x65, 0x40,
    0xff, 0x1c, 0x6, 0x21, 0xb0, 0x19, 0x50, 0x3f,
    0x1c, 0x7, 0x70, 0x11, 0x81, 0x95, 0x3, 0xc7,
    0x1, 0xd8, 0x81, 0x46, 0x6, 0x54, 0xc, 0x70,
    0x1d, 0x88, 0x1d, 0x18, 0x19, 0x50, 0x7, 0x1,
    0xd8, 0x81, 0xf4, 0x60, 0x65, 0x4e, 0x3, 0xb1,
    0x3, 0xfa, 0x30, 0x32, 0xc0, 0x76, 0x20, 0x7f,
    0xd1, 0x81, 0xfd, 0x88, 0x1f, 0xfc, 0x18, 0xc0,
    0xfb, 0x10, 0x3f, 0xf8, 0x71, 0x81, 0xd8, 0x81,
    0xff, 0xc5, 0x8c, 0xb, 0x10, 0x3f, 0xf8, 0xf2,
    0x16, 0x20, 0x7f, 0x80,

    /* U+F079 "" */
    0x3, 0xc8, 0x81, 0xff, 0xd4, 0x97, 0x20, 0x3f,
    0xfa, 0x51, 0x80, 0xa8, 0xc, 0x9b, 0xff, 0xe1,
    0x1, 0xfd, 0x18, 0x1a, 0xa0, 0xa, 0xc9, 0xff,
    0xc2, 0x60, 0x7d, 0x18, 0x1e, 0xa8, 0x30, 0x3f,
    0xf8, 0x7c, 0xf, 0x46, 0x7, 0xea, 0x8d, 0x3,
    0xff, 0x91, 0x18, 0x1f, 0xea, 0x93, 0xff, 0xf8,
    0xf, 0xe6, 0x5, 0x40, 0x9b, 0x1, 0x60, 0x3f,
    0xf9, 0x30, 0x5, 0x40, 0x68, 0x80, 0x50, 0x3f,
    0xf9, 0x2f, 0x62, 0x3, 0xd6, 0xb9, 0x3, 0xff,
    0x94, 0x48, 0xf, 0xc8, 0xf, 0xff, 0xf8, 0x1f,
    0xfd, 0xc9, 0x0, 0x7c, 0x6b, 0x3, 0xff, 0x95,
    0x9b, 0x50, 0x38, 0xe5, 0x18, 0x1f, 0xfc, 0x92,
    0x1, 0x40, 0x23, 0xc0, 0xb8, 0x1f, 0x93, 0x7f,
    0xe2, 0x28, 0x13, 0x2, 0x44, 0x1, 0x80, 0x7e,
    0x32, 0x7f, 0xb2, 0x4a, 0x7, 0xf1, 0xc0, 0x7f,
    0xf2, 0x68, 0x54, 0xf, 0x8e, 0x3, 0xe6, 0x7,
    0xff, 0x9, 0x0, 0x58, 0xe, 0x38, 0xf, 0xd3,
    0xff, 0xfe, 0x15, 0x2, 0x38, 0x8, 0xe0, 0x3f,
    0xfa, 0x27, 0x15, 0x80, 0xe0,

    /* U+F07B "" */
    0x17, 0xff, 0xec, 0x7, 0xff, 0x12, 0xa0, 0x3f,
    0x8e, 0x3, 0xff, 0x86, 0x80, 0xff, 0x8e, 0x3,
    0xff, 0x9e, 0x74, 0x9f, 0xe6, 0x40, 0xff, 0xe1,
    0x96, 0xff, 0xd3, 0x20, 0x3f, 0xf9, 0xf4, 0xf,
    0xff, 0xf8, 0x1f, 0xff, 0xf0, 0x3f, 0xff, 0xe0,
    0x7f, 0xff, 0xc0, 0xff, 0xfa, 0x20, 0x3f, 0xf9,
    0xca, 0xa0, 0x3f, 0xf9, 0x8a, 0x80,

    /* U+F093 "" */
    0x3, 0xff, 0x82, 0x40, 0xff, 0xe7, 0x3d, 0xc8,
    0x1f, 0xfc, 0xb7, 0x0, 0x62, 0x7, 0xff, 0x25,
    0xc0, 0x36, 0x20, 0x7f, 0xf1, 0xdc, 0x3, 0xd8,
    0x81, 0xff, 0xc5, 0x70, 0xf, 0xd8, 0x81, 0xff,
    0xc3, 0x70, 0xf, 0xf6, 0x20, 0x7f, 0xf0, 0x5c,
    0x3, 0xff, 0x81, 0x88, 0x1f, 0xf3, 0x80, 0x7f,
    0xf0, 0xb1, 0x3, 0xf9, 0x40, 0x3f, 0xf8, 0x98,
    0xf, 0xe2, 0x7, 0xff, 0x3d, 0xed, 0xc4, 0xf,
    0x4d, 0xb7, 0x3, 0xfc, 0x4f, 0x30, 0x3c, 0x4f,
    0x1, 0xff, 0xff, 0x3, 0xff, 0xfe, 0x7, 0xff,
    0xa2, 0xff, 0xf6, 0x3, 0xf3, 0x1b, 0xff, 0xaa,
    0x3, 0xe2, 0x2b, 0x7d, 0x8, 0x20, 0x7c, 0x80,
    0xfe, 0xc2, 0x4e, 0x63, 0x1, 0xff, 0xc6, 0x3f,
    0x6f, 0x72, 0x7, 0xff, 0x20, 0x9f, 0x1, 0xff,
    0xd2, 0xbc, 0x2e, 0xc0, 0xff, 0xe5, 0x90, 0xc0,
    0xff, 0xe6, 0x5c, 0xf, 0x60, 0x5a, 0x37, 0xff,
    0xcc, 0x98,

    /* U+F095 "" */
    0x3, 0xff, 0x92, 0xd8, 0x81, 0xff, 0xcd, 0x52,
    0x37, 0xac, 0x81, 0xff, 0xc9, 0xe0, 0x65, 0x36,
    0x1, 0xff, 0xc7, 0x28, 0xf, 0x88, 0x1f, 0xfc,
    0x7a, 0x7, 0xff, 0x41, 0x81, 0xff, 0xcf, 0x60,
    0x7f, 0x10, 0x3f, 0xf8, 0xd4, 0xf, 0xe6, 0x7,
    0xff, 0x19, 0x81, 0xfd, 0x80, 0xff, 0xe3, 0x54,
    0x7, 0xe4, 0x7, 0xff, 0x1e, 0xb0, 0x3e, 0x20,
    0x7f, 0xf2, 0x24, 0x1, 0xcc, 0xf, 0xfe, 0x56,
    0x3, 0xb0, 0x1f, 0xfc, 0x92, 0x80, 0xc5, 0x1,
    0xff, 0xc9, 0xe0, 0x74, 0x3, 0xff, 0x93, 0x8,
    0x18, 0xa0, 0x3f, 0xf9, 0xd, 0x80, 0xee, 0x7,
    0xf8, 0xb0, 0x3f, 0x28, 0x7, 0x32, 0x7, 0xe5,
    0x74, 0xc0, 0x79, 0xd0, 0x38, 0xc0, 0x3e, 0x7a,
    0xa0, 0x6, 0x81, 0xac, 0x3, 0xd8, 0xf, 0x3f,
    0x8, 0x1c, 0x98, 0x5d, 0x1, 0xec, 0x7, 0xd0,
    0xf, 0xe9, 0xa8, 0x1f, 0x62, 0x7, 0xc4, 0xf,
    0xf1, 0x3, 0xc7, 0x10, 0x3f, 0x20, 0x3f, 0xf8,
    0x8b, 0x10, 0x3f, 0xb0, 0x1f, 0xfc, 0x39, 0x40,
    0xff, 0x90, 0x1f, 0xfc, 0x17, 0xd8, 0x1f, 0xfc,
    0x12, 0x7, 0xf9, 0xf8, 0x7, 0xff, 0xd, 0x1,
    0xe2, 0xef, 0x80, 0x7f, 0xf1, 0x64, 0xd7, 0x7d,
    0x10, 0x1f, 0xfc, 0x50,

    /* U+F0C4 "" */
    0x2, 0x52, 0x19, 0x3, 0xff, 0x8c, 0x75, 0x6d,
    0x33, 0x3, 0xfc, 0xed, 0x40, 0x2c, 0x40, 0xe8,
    0xc0, 0xf8, 0xf8, 0x91, 0xf3, 0x0, 0xfd, 0x0,
    0xf1, 0xc0, 0x79, 0xa0, 0x2f, 0xd0, 0x9, 0x1,
    0x8e, 0x3, 0xd5, 0x10, 0xc, 0x3, 0x2, 0x20,
    0x47, 0x1, 0xea, 0x80, 0xc8, 0x2, 0x3, 0xc7,
    0x1, 0xea, 0x80, 0x20, 0x7, 0x5a, 0x2, 0x20,
    0xe0, 0x3d, 0x50, 0x14, 0x2, 0x28, 0xd, 0x56,
    0x3, 0xd5, 0x1, 0x8d, 0x3, 0xfa, 0x81, 0xea,
    0x80, 0xf2, 0xec, 0x90, 0x1f, 0xf5, 0x40, 0x7f,
    0x4d, 0x94, 0xf, 0xea, 0x80, 0xff, 0xe0, 0xa8,
    0x7, 0xd1, 0x1, 0xff, 0xc2, 0x30, 0xf, 0xa1,
    0x3, 0xfe, 0x52, 0x30, 0x1f, 0xd8, 0x81, 0xf8,
    0xea, 0xd8, 0xf, 0xfb, 0x10, 0x3e, 0xc4, 0xf,
    0xcc, 0xf, 0x62, 0x7, 0x40, 0x3f, 0xa4, 0x50,
    0x3d, 0x88, 0x19, 0x1, 0x7e, 0x80, 0x44, 0x2a,
    0x7, 0xb1, 0x2, 0x20, 0x18, 0x6, 0x4, 0x40,
    0x2a, 0x7, 0xb1, 0x3, 0x90, 0x4, 0x7, 0xca,
    0x81, 0xec, 0x42, 0x0, 0x75, 0xa0, 0x24, 0x6,
    0x54, 0xf, 0x63, 0x0, 0x8a, 0x2, 0x64, 0xe,
    0x54, 0xf, 0x33, 0x40, 0xf2, 0x80, 0x7c, 0xb2,
    0x0, 0xb2, 0xb, 0xb2, 0x4a, 0xd0, 0x1f, 0xc6,
    0xfe, 0xa4, 0x0,

    /* U+F0C5 "" */
    0x3, 0xf2, 0x5f, 0xc4, 0x10, 0x3f, 0xf8, 0x1a,
    0xdf, 0xf0, 0xd4, 0xf, 0xf8, 0x81, 0xff, 0xc0,
    0x54, 0xf, 0xfe, 0x62, 0xa0, 0x7f, 0xf3, 0x15,
    0x3, 0xff, 0x98, 0x92, 0xff, 0x90, 0x1f, 0xf1,
    0x1f, 0xf2, 0x40, 0x3f, 0xf8, 0x8b, 0x5b, 0xc4,
    0xf, 0xfe, 0x31, 0x4b, 0x98, 0x1f, 0xff, 0xf0,
    0x3f, 0xff, 0xe0, 0x7f, 0xff, 0xc0, 0xff, 0xff,
    0x81, 0xff, 0xd4, 0x40, 0x7f, 0xf1, 0x10, 0x1d,
    0xc5, 0xff, 0xff, 0x88, 0x7, 0x95, 0x20, 0x7f,
    0xf2, 0xd6, 0xff, 0xfa, 0x1, 0xff, 0xe5, 0xe0,
    0x7d, 0xa3, 0x7f, 0xfc, 0x28, 0xc0, 0xf8,

    /* U+F0C7 "" */
    0xa, 0x4f, 0xfe, 0x1b, 0x20, 0x79, 0xd6, 0xff,
    0xf8, 0x73, 0x20, 0x3a, 0x1, 0xff, 0xc6, 0xa8,
    0xf, 0xfe, 0x65, 0x40, 0x79, 0xff, 0xff, 0xc1,
    0x20, 0x55, 0x1, 0xff, 0xc7, 0x60, 0x6a, 0x40,
    0xff, 0xe6, 0x60, 0x3f, 0xf9, 0xa4, 0xf, 0xfe,
    0x63, 0x3, 0xff, 0xa0, 0x9b, 0xff, 0xe0, 0xa0,
    0x3f, 0xc6, 0x4f, 0xfe, 0x8, 0x1f, 0xff, 0x87,
    0xbd, 0x3, 0xff, 0x91, 0x20, 0x85, 0x80, 0xff,
    0xe3, 0xb0, 0x31, 0x40, 0x7f, 0xf1, 0x48, 0x1e,
    0x20, 0x7f, 0xf1, 0x48, 0x1f, 0xfc, 0xd2, 0x7,
    0x30, 0x3f, 0xf8, 0xdc, 0xd, 0x0, 0xff, 0xe3,
    0x9f, 0x66, 0x60, 0x7f, 0xf2, 0x53, 0x20, 0x7f,
    0x9a, 0x3, 0xff, 0x96, 0x6a, 0x3, 0xff, 0x90,
    0x70,

    /* U+F0E7 "" */
    0x2, 0x96, 0xfe, 0x80, 0x7e, 0x2d, 0x2f, 0xcc,
    0x81, 0xf2, 0x3, 0xfc, 0x40, 0xfb, 0x81, 0xfc,
    0x80, 0xfc, 0x40, 0xfe, 0xe0, 0x7e, 0x60, 0x7f,
    0x20, 0x3f, 0x10, 0x3f, 0x20, 0x3f, 0xf8, 0xd8,
    0xf, 0xc4, 0xf, 0xe6, 0x7, 0xe6, 0x7, 0xf7,
    0xfe, 0xc4, 0x10, 0x3f, 0xf8, 0x65, 0xe, 0x7,
    0xff, 0x11, 0x82, 0x7, 0xff, 0xe, 0x0, 0x60,
    0x7f, 0xf0, 0x8b, 0x0, 0x40, 0xff, 0xe1, 0x40,
    0x24, 0x7, 0xff, 0x5, 0x20, 0x15, 0xff, 0xd4,
    0xf, 0x40, 0x3f, 0xec, 0x7, 0x32, 0x7, 0xfc,
    0x80, 0xe8, 0x7, 0xff, 0x0, 0x81, 0xa0, 0x1f,
    0xfc, 0x2, 0x6, 0x2c, 0xf, 0xfe, 0x2, 0x3,
    0x40, 0x3f, 0xf8, 0x38, 0x9, 0x20, 0x1f, 0xfc,
    0x14, 0x5, 0x0, 0xff, 0xe0, 0x90, 0x26, 0x40,
    0xff, 0xe0, 0xa0, 0x28, 0x7, 0xff, 0xb, 0x0,
    0x80, 0x7f, 0xf0, 0xc8, 0x2c, 0xf, 0xfe, 0x1c,
    0xd8, 0x7, 0xf8,

    /* U+F0EA "" */
    0x3, 0xf2, 0x20, 0x7f, 0xf2, 0x5f, 0xbb, 0x90,
    0x3f, 0xf8, 0x2a, 0x4f, 0x1, 0xb4, 0x9c, 0x7,
    0xea, 0xdf, 0x5, 0xf8, 0x3, 0x7d, 0x0, 0xff,
    0xe6, 0x10, 0x3f, 0xf8, 0x4b, 0xf0, 0x1f, 0xfe,
    0x43, 0x2d, 0xfa, 0x1, 0xff, 0xc2, 0x59, 0xa5,
    0xf1, 0x3, 0xff, 0x85, 0x5, 0xff, 0xea, 0x33,
    0x3, 0xfe, 0x21, 0x1, 0xfc, 0x63, 0x3, 0xff,
    0x99, 0x18, 0x1f, 0xfc, 0xc8, 0xc0, 0xff, 0xe6,
    0x42, 0x7, 0xff, 0x1e, 0xde, 0x20, 0x7f, 0xf1,
    0x50, 0x4b, 0x80, 0xff, 0xe3, 0xff, 0xe4, 0x7,
    0xff, 0xfc, 0xf, 0xff, 0x32, 0x3, 0xff, 0x99,
    0x7f, 0xf0, 0x1f, 0xff, 0xf0, 0x3f, 0xfb, 0xcc,
    0xf, 0xef, 0x6f, 0xff, 0x7, 0x10,

    /* U+F0F3 "" */
    0x3, 0xfe, 0x74, 0x81, 0xff, 0xc9, 0x51, 0x70,
    0x3f, 0xf9, 0x24, 0x1, 0x3, 0xff, 0x8e, 0x65,
    0x2, 0xa8, 0xf, 0xfe, 0x24, 0xcc, 0x81, 0x2b,
    0x90, 0x1f, 0xfc, 0x1c, 0xc0, 0xfc, 0x6a, 0x3,
    0xfe, 0xc4, 0xf, 0xfa, 0xa0, 0x3f, 0x99, 0x3,
    0xff, 0x83, 0x0, 0xfe, 0x80, 0x7f, 0xf0, 0x8a,
    0x3, 0xe2, 0x7, 0xff, 0x13, 0x81, 0xf2, 0x3,
    0xff, 0x88, 0xc0, 0xff, 0xe6, 0x10, 0x3e, 0xe0,
    0x7f, 0xf9, 0x50, 0x1f, 0xfc, 0x54, 0x7, 0x88,
    0x1f, 0xfc, 0x52, 0x7, 0x10, 0x3f, 0xf8, 0xd8,
    0xe, 0xa0, 0x7f, 0xf1, 0x90, 0x18, 0xb0, 0x3f,
    0xf8, 0xf4, 0xb, 0x1, 0xff, 0xc8, 0x4c, 0x50,
    0x3f, 0xf9, 0x50, 0xa0, 0x3f, 0xf9, 0x6a, 0x1,
    0xff, 0xca, 0x2d, 0xbf, 0xff, 0xe5, 0x60, 0x3f,
    0xfa, 0xc7, 0xff, 0x50, 0x3f, 0xf8, 0xa4, 0xf,
    0x60, 0x3f, 0xf8, 0xd8, 0xc, 0xd8, 0xf, 0xfe,
    0x31, 0xf6, 0x68, 0x7, 0xf8,

    /* U+F11C "" */
    0x17, 0xff, 0xfe, 0x82, 0x15, 0x1, 0xff, 0xd0,
    0xa5, 0x1, 0xff, 0xd2, 0x40, 0x45, 0xb8, 0x3,
    0x70, 0x6, 0xe0, 0x9, 0xb2, 0x5, 0xb8, 0xb,
    0x81, 0x29, 0x20, 0x64, 0x88, 0x92, 0x42, 0xc8,
    0xe2, 0xc9, 0x1, 0xff, 0xe9, 0x60, 0x80, 0x23,
    0x81, 0xfe, 0x7f, 0xc0, 0xff, 0x11, 0xfc, 0x46,
    0xfd, 0x3, 0xfe, 0x3, 0xfc, 0x4c, 0x4, 0x4c,
    0x0, 0x98, 0x1, 0x30, 0x1f, 0xfc, 0x1f, 0xb2,
    0x9, 0xb3, 0x87, 0xb4, 0xe, 0xd2, 0x3, 0xff,
    0xfe, 0x3e, 0xc8, 0x26, 0xce, 0x1e, 0xd0, 0x3b,
    0x48, 0xf, 0xfe, 0x1, 0x30, 0x11, 0x30, 0x2,
    0x60, 0x4, 0xc0, 0x7f, 0x9f, 0xf0, 0x3f, 0xff,
    0xf0, 0x60, 0x7f, 0xc0, 0x7f, 0xf3, 0x88, 0xe0,
    0x7f, 0xf7, 0x94, 0x90, 0x32, 0x7f, 0xf0, 0x78,
    0xb2, 0x40, 0x7c, 0x5b, 0x80, 0x37, 0xff, 0xc1,
    0x40, 0xb7, 0x1, 0x74, 0x7, 0xff, 0x49, 0x54,
    0x7, 0xff, 0x42, 0x90,

    /* U+F124 "" */
    0x3, 0xff, 0x9a, 0x99, 0x3, 0xff, 0x9a, 0xfd,
    0x99, 0x1, 0xff, 0xca, 0x9e, 0x1, 0xa0, 0x1f,
    0xfc, 0x73, 0x3b, 0x3, 0xc4, 0xf, 0xfe, 0x29,
    0xb9, 0x81, 0xf9, 0x81, 0xff, 0xc3, 0x5b, 0x10,
    0x1f, 0xea, 0x7, 0xff, 0x5, 0xea, 0x40, 0xff,
    0x91, 0x3, 0xfe, 0x7e, 0x10, 0x3f, 0xf8, 0x30,
    0xf, 0xf4, 0xf0, 0xf, 0xfe, 0x19, 0x20, 0x3e,
    0x37, 0xb0, 0x3f, 0xf8, 0xb0, 0xf, 0x2b, 0x90,
    0x1f, 0xfc, 0x62, 0x80, 0xeb, 0x48, 0xf, 0xfe,
    0x45, 0x3, 0xaa, 0x3, 0xff, 0x94, 0xc0, 0xe4,
    0x7, 0xff, 0x2a, 0x1, 0xe2, 0x7, 0xff, 0x29,
    0x81, 0xe8, 0x7, 0xff, 0x25, 0x81, 0xf2, 0xfa,
    0xdf, 0xe2, 0x7, 0xf5, 0x3, 0xf8, 0xa5, 0xfc,
    0x7, 0xf2, 0x20, 0x7f, 0xf4, 0x20, 0x1f, 0xfd,
    0x4, 0x40, 0xff, 0xe8, 0x70, 0x3f, 0xfa, 0x5,
    0x1, 0xff, 0xd0, 0x80, 0x7f, 0xf4, 0x50, 0x1f,
    0xfd, 0x8, 0x7, 0xff, 0x2d, 0x81, 0xcc, 0xf,
    0xfe, 0x83, 0x3, 0xff, 0x99, 0x0, 0x8c, 0x3,
    0xff, 0x98, 0x7c, 0x8c, 0x7, 0xff, 0x0,

    /* U+F15B "" */
    0x9, 0x7f, 0xc0, 0x8, 0x1e, 0xd6, 0xff, 0xc8,
    0x6a, 0x7, 0x10, 0x3f, 0xf8, 0x4a, 0x81, 0xff,
    0xc8, 0x54, 0xf, 0xfe, 0x42, 0xa0, 0x7f, 0xf2,
    0x15, 0x3, 0xff, 0x90, 0xa0, 0x1f, 0xfc, 0x24,
    0xbc, 0x40, 0xff, 0xe0, 0x61, 0x6f, 0xc0, 0x7f,
    0xf0, 0x1f, 0xff, 0x80, 0xff, 0xff, 0x81, 0xff,
    0xff, 0x3, 0xff, 0xfe, 0x7, 0xff, 0xfc, 0xf,
    0xff, 0x69, 0x3, 0xff, 0x8e, 0x75, 0xbf, 0xfc,
    0x7c,

    /* U+F1EB "" */
    0x3, 0xff, 0xc6, 0x5c, 0xb5, 0xad, 0x46, 0x40,
    0xff, 0xe4, 0x17, 0xbe, 0x8d, 0x21, 0x48, 0xe6,
    0xf9, 0x90, 0x3f, 0xf8, 0x46, 0xe8, 0x40, 0xff,
    0xe0, 0x99, 0xa9, 0x3, 0xfc, 0x76, 0x20, 0x3f,
    0xf8, 0xeb, 0x61, 0x3, 0xe9, 0x88, 0x1f, 0x8a,
    0x5c, 0x40, 0xfc, 0x74, 0x3, 0xb3, 0x3, 0xc6,
    0x6f, 0xad, 0xed, 0xf4, 0x20, 0x79, 0xe0, 0x7,
    0x90, 0x39, 0xec, 0x64, 0xf, 0xe2, 0xf6, 0x30,
    0x38, 0xf3, 0x80, 0xe5, 0xa1, 0x3, 0xff, 0x86,
    0x66, 0x40, 0x76, 0x80, 0x69, 0x48, 0x1f, 0xfc,
    0x73, 0x60, 0x1a, 0x38, 0x3, 0x30, 0x3c, 0xa5,
    0xff, 0x6b, 0x10, 0x1e, 0x78, 0x88, 0xc3, 0xbc,
    0x81, 0xd3, 0xd6, 0x80, 0xc5, 0x3b, 0xe0, 0x1c,
    0x75, 0x60, 0x48, 0xe, 0x7d, 0x81, 0xff, 0xc1,
    0x7d, 0x81, 0xc8, 0xf, 0xeb, 0x0, 0xff, 0xe2,
    0xca, 0x7, 0xff, 0x6, 0xa0, 0x3c, 0x5c, 0x93,
    0x20, 0x79, 0x60, 0x3f, 0xf8, 0x4, 0xe, 0x9f,
    0x46, 0xe9, 0xbc, 0x3, 0x90, 0x1f, 0xfc, 0x8,
    0xc0, 0x3e, 0xc0, 0xfe, 0x7d, 0x80, 0x70, 0xf,
    0xfe, 0xc, 0x8b, 0x0, 0xff, 0xe0, 0xcb, 0x20,
    0xf, 0xfe, 0x1b, 0x40, 0x7f, 0xf0, 0xd3, 0x3,
    0xff, 0x96, 0xff, 0x98, 0x1f, 0xfd, 0x17, 0x0,
    0xa3, 0x3, 0xff, 0xa1, 0x0, 0xe8, 0x7, 0xff,
    0xcc, 0x81, 0xc4, 0xf, 0xfe, 0x84, 0x3, 0xa0,
    0x1f, 0xfd, 0x5, 0x91, 0x59, 0x1, 0xff, 0xc2,

    /* U+F240 "" */
    0x5, 0xbf, 0xfe, 0x8a, 0x2, 0x5a, 0x4f, 0xfe,
    0x8d, 0x80, 0x20, 0x1f, 0xfd, 0x36, 0x0, 0x81,
    0xff, 0xd4, 0x20, 0x67, 0xff, 0xff, 0x36, 0x81,
    0x68, 0x7, 0xff, 0x59, 0x81, 0xdb, 0xff, 0xfe,
    0x50, 0x1f, 0xfd, 0x86, 0xc4, 0xf, 0xfe, 0xa1,
    0x88, 0xf, 0xff, 0xf8, 0x1f, 0xfc, 0xf3, 0xd8,
    0x1f, 0xfd, 0x46, 0x7, 0xfb, 0x7f, 0xff, 0xca,
    0x3, 0xfc, 0x5b, 0xff, 0xe6, 0xe0, 0x25, 0x80,
    0x94, 0x9f, 0xfc, 0xd6, 0x5, 0xa, 0x3, 0xff,
    0xa8, 0x45, 0x40, 0x7f, 0xf4, 0x4e, 0x2, 0xbf,
    0xff, 0xf4, 0x71, 0x0,

    /* U+F241 "" */
    0x5, 0xbf, 0xfe, 0x8a, 0x2, 0x5a, 0x4f, 0xfe,
    0x8d, 0x80, 0x20, 0x1f, 0xfd, 0x36, 0x0, 0x81,
    0xff, 0xd4, 0x20, 0x67, 0xff, 0xff, 0x36, 0x81,
    0x68, 0x7, 0xff, 0x59, 0x81, 0xdf, 0xff, 0xf1,
    0x60, 0x1f, 0xfd, 0xd6, 0xc4, 0xf, 0xfe, 0xa1,
    0x88, 0xf, 0xff, 0xf8, 0x1f, 0xfc, 0xf3, 0xd8,
    0x1f, 0xfd, 0x46, 0x7, 0xfb, 0xff, 0xfe, 0x2c,
    0x3, 0xff, 0x86, 0x5b, 0xff, 0xe6, 0xe0, 0x25,
    0x80, 0x94, 0x9f, 0xfc, 0xd6, 0x5, 0xa, 0x3,
    0xff, 0xa8, 0x45, 0x40, 0x7f, 0xf4, 0x4e, 0x2,
    0xbf, 0xff, 0xf4, 0x71, 0x0,

    /* U+F242 "" */
    0x5, 0xbf, 0xfe, 0x8a, 0x2, 0x5a, 0x4f, 0xfe,
    0x8d, 0x80, 0x20, 0x1f, 0xfd, 0x36, 0x0, 0x81,
    0xff, 0xd4, 0x20, 0x67, 0xff, 0xff, 0x36, 0x81,
    0x68, 0x7, 0xff, 0x59, 0x81, 0xdf, 0xff, 0xf0,
    0x10, 0x1f, 0xfe, 0x26, 0xc4, 0xf, 0xfe, 0xa1,
    0x88, 0xf, 0xff, 0xf8, 0x1f, 0xfc, 0xf3, 0xd8,
    0x1f, 0xfd, 0x46, 0x7, 0xfb, 0xff, 0xfe, 0x2,
    0x3, 0xff, 0x90, 0x5b, 0xff, 0xe6, 0xe0, 0x25,
    0x80, 0x94, 0x9f, 0xfc, 0xd6, 0x5, 0xa, 0x3,
    0xff, 0xa8, 0x45, 0x40, 0x7f, 0xf4, 0x4e, 0x2,
    0xbf, 0xff, 0xf4, 0x71, 0x0,

    /* U+F243 "" */
    0x5, 0xbf, 0xfe, 0x8a, 0x2, 0x5a, 0x4f, 0xfe,
    0x8d, 0x80, 0x20, 0x1f, 0xfd, 0x36, 0x0, 0x81,
    0xff, 0xd4, 0x20, 0x67, 0xff, 0xff, 0x36, 0x81,
    0x68, 0x7, 0xff, 0x59, 0x81, 0xdf, 0xfc, 0x7,
    0xff, 0xa1, 0xb1, 0x3, 0xff, 0xa8, 0x62, 0x3,
    0xff, 0xfe, 0x7, 0xff, 0x3c, 0xf6, 0x7, 0xff,
    0x51, 0x81, 0xfe, 0xff, 0xe0, 0x3f, 0xf9, 0xc5,
    0xbf, 0xfe, 0x6e, 0x2, 0x58, 0x9, 0x49, 0xff,
    0xcd, 0x60, 0x50, 0xa0, 0x3f, 0xfa, 0x84, 0x54,
    0x7, 0xff, 0x44, 0xe0, 0x2b, 0xff, 0xff, 0x47,
    0x10, 0x0,

    /* U+F244 "" */
    0x5, 0xbf, 0xfe, 0x8a, 0x2, 0x5a, 0x4f, 0xfe,
    0x8d, 0x80, 0x20, 0x1f, 0xfd, 0x36, 0x0, 0x81,
    0xff, 0xd4, 0x20, 0x67, 0xff, 0xff, 0x36, 0x81,
    0x68, 0x7, 0xff, 0x59, 0x81, 0xff, 0xf4, 0x6c,
    0x40, 0xff, 0xea, 0x18, 0x80, 0xff, 0xff, 0x81,
    0xff, 0xcf, 0x3d, 0x81, 0xff, 0xd4, 0x60, 0x7f,
    0xf7, 0xcb, 0x7f, 0xfc, 0xdc, 0x4, 0xb0, 0x12,
    0x93, 0xff, 0x9a, 0xc0, 0xa1, 0x40, 0x7f, 0xf5,
    0x8, 0xa8, 0xf, 0xfe, 0x89, 0xc0, 0x57, 0xff,
    0xfe, 0x8e, 0x20, 0x0,

    /* U+F287 "" */
    0x3, 0xff, 0xd4, 0xbf, 0x90, 0x1f, 0xfd, 0x12,
    0x54, 0xa, 0x81, 0xff, 0xcf, 0xbf, 0x60, 0x1c,
    0x80, 0xff, 0xe6, 0xd4, 0x9, 0x1, 0xff, 0xd2,
    0x48, 0x3e, 0xc2, 0x4, 0x50, 0x1f, 0xfc, 0xc8,
    0x28, 0x16, 0x8a, 0x60, 0x3f, 0xf8, 0x84, 0xf,
    0x91, 0x24, 0x6, 0x75, 0x81, 0xff, 0xc3, 0x5f,
    0x7c, 0x40, 0xd0, 0x40, 0x3f, 0xf8, 0x6d, 0x1,
    0xca, 0x81, 0x1c, 0x4, 0x88, 0x40, 0x7f, 0xf0,
    0xed, 0x88, 0x14, 0x3, 0xd4, 0xaa, 0x1a, 0x5f,
    0xfc, 0x40, 0xb, 0x30, 0x4, 0xf, 0x2d, 0x40,
    0x3b, 0x7f, 0xf8, 0x84, 0xa, 0x60, 0x3f, 0x92,
    0xe2, 0x0, 0xa5, 0xff, 0xc0, 0x3, 0xa0, 0x60,
    0x7a, 0xdf, 0x66, 0x1d, 0xbf, 0xfc, 0x2, 0x1,
    0xf4, 0x22, 0x3, 0x34, 0x7, 0xa0, 0x44, 0xf,
    0xfe, 0x2, 0xd0, 0xd, 0x69, 0xcd, 0x0, 0xfd,
    0x4, 0x3, 0xfe, 0xd4, 0x81, 0xe5, 0x19, 0x3,
    0xf9, 0x84, 0x40, 0x3d, 0xb8, 0x81, 0xff, 0xcc,
    0x63, 0x80, 0xe4, 0xf3, 0x3, 0xff, 0x99, 0x9,
    0x7c, 0xc0, 0xff, 0xe9, 0xe4, 0x8, 0x1f, 0xfd,
    0x5b, 0xf9, 0x81, 0xff, 0xfb, 0x9f, 0xf2, 0x3,
    0xf0,

    /* U+F293 "" */
    0x3, 0xfc, 0x51, 0x20, 0x3f, 0xf8, 0x46, 0xfe,
    0xd7, 0x67, 0xa8, 0xf, 0xf5, 0xc8, 0xf, 0x95,
    0xc0, 0x7e, 0xc8, 0xc, 0x60, 0x1c, 0x70, 0x1e,
    0xa4, 0xf, 0x36, 0x3, 0x8e, 0x3, 0x24, 0x3,
    0xf4, 0x60, 0x71, 0x40, 0x50, 0xf, 0xf4, 0x40,
    0x77, 0x0, 0x48, 0xf, 0xfa, 0xa0, 0x32, 0x0,
    0x80, 0xc8, 0xe, 0x30, 0x52, 0x6, 0x43, 0x1,
    0x3b, 0x80, 0xe7, 0x6, 0x20, 0x58, 0x30, 0x24,
    0xe, 0x3, 0x88, 0x1e, 0x20, 0x81, 0x1c, 0xe,
    0x60, 0x15, 0x14, 0x81, 0x30, 0x3c, 0x70, 0x34,
    0x1a, 0x22, 0x3, 0xff, 0x80, 0x70, 0x1c, 0xd8,
    0xe, 0x20, 0x7e, 0x38, 0x9, 0x40, 0x3f, 0xf8,
    0x8c, 0x9, 0x81, 0xff, 0xc4, 0x54, 0x8, 0xe0,
    0x3c, 0x40, 0xf9, 0x50, 0x40, 0x8d, 0x3, 0xff,
    0x80, 0xa8, 0x5c, 0x1c, 0x15, 0x3, 0xc4, 0x9,
    0x50, 0xa8, 0x11, 0xc1, 0x40, 0x26, 0x10, 0x1c,
    0xa8, 0x1d, 0x40, 0x50, 0x2c, 0x30, 0x12, 0xd4,
    0xe, 0x8c, 0x62, 0x4, 0x42, 0x3, 0x10, 0x38,
    0xb1, 0x88, 0x19, 0x0, 0x40, 0x7f, 0xd8, 0x81,
    0x90, 0x14, 0x3, 0xfd, 0x88, 0x1d, 0x0, 0x8c,
    0x3, 0xf6, 0x20, 0x73, 0x20, 0x67, 0x0, 0xe3,
    0x88, 0x1c, 0xa0, 0x1e, 0x79, 0x1, 0x88, 0x1d,
    0x28, 0x1f, 0x8d, 0xf5, 0xa5, 0x9d, 0xec, 0xc,

    /* U+F2ED "" */
    0x3, 0xf9, 0x2f, 0x10, 0x3f, 0xf8, 0xbe, 0xdf,
    0x68, 0x7, 0xe5, 0x27, 0xb0, 0x1f, 0x9c, 0x9f,
    0xa, 0xdf, 0x88, 0x1f, 0xcd, 0xfe, 0x3, 0xff,
    0x99, 0xd0, 0x1f, 0xfc, 0xbd, 0x7f, 0xff, 0xe5,
    0xa0, 0x64, 0xff, 0xe4, 0x30, 0x26, 0xff, 0xf9,
    0x34, 0xf, 0xff, 0x75, 0xa0, 0x27, 0x80, 0x8f,
    0x20, 0x7f, 0xf0, 0x1b, 0x1, 0x72, 0x4, 0xc3,
    0x3, 0xff, 0xfe, 0x7, 0xff, 0xfc, 0xf, 0xff,
    0xf8, 0x1f, 0xff, 0x26, 0xc0, 0x5c, 0x81, 0x30,
    0xc0, 0xf9, 0x81, 0xad, 0x1, 0x3c, 0x4, 0x79,
    0x2, 0x60, 0x7f, 0xf4, 0xb, 0x3, 0xff, 0x8f,
    0x0, 0xd2, 0xc6, 0xff, 0xf8, 0x73, 0x90, 0x0,

    /* U+F304 "" */
    0x3, 0xff, 0x94, 0xd8, 0xf, 0xfe, 0x69, 0xd2,
    0x39, 0x3, 0xff, 0x94, 0x71, 0x2, 0xc4, 0xf,
    0xfe, 0x41, 0xc0, 0x7b, 0x10, 0x3f, 0xf8, 0xf4,
    0xf, 0xd8, 0x81, 0xff, 0xc6, 0x88, 0xf, 0xdc,
    0xf, 0xfe, 0x19, 0xf8, 0x54, 0x7, 0xc4, 0xf,
    0xfe, 0x11, 0xc0, 0xe1, 0x50, 0x1e, 0x40, 0x7f,
    0xf0, 0x4e, 0x2, 0x38, 0x54, 0x7, 0x50, 0x3f,
    0xf8, 0x7, 0x1, 0xc7, 0xa, 0x80, 0xb0, 0x1f,
    0xfc, 0x3, 0x80, 0xf8, 0xe1, 0x50, 0xc4, 0xf,
    0xf8, 0xe0, 0x3f, 0x8e, 0x17, 0x90, 0x3f, 0xe3,
    0x80, 0xff, 0x8d, 0x3, 0xff, 0x82, 0x70, 0x1f,
    0xfc, 0x18, 0x7, 0xff, 0x0, 0xe0, 0x3f, 0xf8,
    0x38, 0x81, 0xff, 0x1c, 0x7, 0xff, 0x7, 0x10,
    0x3f, 0xe3, 0x80, 0xff, 0xe0, 0xe2, 0x7, 0xfc,
    0x70, 0x1f, 0xfc, 0x1c, 0x40, 0xff, 0x8e, 0x3,
    0xff, 0x83, 0x88, 0x1f, 0xf1, 0xc0, 0x7f, 0xf0,
    0x71, 0x3, 0xff, 0x81, 0x80, 0xff, 0xe0, 0xe2,
    0x7, 0xff, 0x1, 0x1, 0xff, 0xc1, 0xc4, 0xf,
    0xfe, 0x9, 0x3, 0xff, 0x81, 0x88, 0x1f, 0xfc,
    0x2e, 0x7, 0xfd, 0x88, 0x1f, 0xfc, 0x32, 0x7,
    0xfb, 0x10, 0x3f, 0xf8, 0x8c, 0xf, 0xec, 0x40,
    0xff, 0xe2, 0x90, 0x3f, 0x62, 0x7, 0xff, 0x34,
    0xe2, 0x7, 0xff, 0x1f, 0x48, 0xbb, 0xf6, 0x20,
    0x7f, 0xf1, 0xc0,

    /* U+F55A "" */
    0x3, 0xfa, 0x7f, 0xff, 0xca, 0xc8, 0xf, 0xea,
    0xc0, 0xff, 0xe5, 0x1a, 0x80, 0xfa, 0xa0, 0x3f,
    0xf9, 0xb0, 0xf, 0x54, 0x7, 0xff, 0x38, 0x81,
    0xd5, 0x1, 0xfc, 0xd8, 0xf, 0x36, 0x3, 0xff,
    0x83, 0x50, 0x1f, 0xce, 0x43, 0x3, 0x39, 0x20,
    0x3f, 0xea, 0x80, 0xff, 0x40, 0x11, 0x80, 0x70,
    0x3, 0x3, 0xfd, 0x50, 0x1f, 0xf4, 0x2, 0x8d,
    0xa0, 0x14, 0x3, 0xfa, 0xa0, 0x3f, 0xf8, 0xe,
    0x1, 0x48, 0x2, 0x8c, 0xf, 0xd5, 0x1, 0xff,
    0xc2, 0x70, 0xf, 0x46, 0x7, 0xf2, 0x3, 0xff,
    0x88, 0xd0, 0x19, 0x30, 0x3f, 0xc8, 0xf, 0xfe,
    0x23, 0x40, 0x64, 0xc0, 0xff, 0x54, 0x7, 0xff,
    0x9, 0xc0, 0x3d, 0x18, 0x1f, 0xea, 0x80, 0xff,
    0xe0, 0x38, 0x5, 0x20, 0xa, 0x30, 0x3f, 0xd5,
    0x1, 0xff, 0x40, 0x28, 0xda, 0x1, 0x40, 0x3f,
    0xea, 0x80, 0xff, 0x40, 0x11, 0x80, 0x70, 0x4,
    0x3, 0xff, 0x81, 0x50, 0x1f, 0xce, 0x43, 0x3,
    0x39, 0xc, 0xf, 0xfe, 0xd, 0x40, 0x7f, 0x36,
    0x3, 0xcd, 0x80, 0xff, 0xe1, 0xd4, 0x7, 0xff,
    0x38, 0x81, 0xf5, 0x40, 0x7f, 0xf3, 0x60, 0x1f,
    0xab, 0x3, 0xff, 0x94, 0x6a,

    /* U+F7C2 "" */
    0x3, 0xe7, 0x27, 0xf3, 0x40, 0x7e, 0xd1, 0xbf,
    0xe9, 0x70, 0x1c, 0x71, 0x3, 0xff, 0x80, 0x68,
    0x11, 0xc4, 0xf, 0xfe, 0x12, 0x0, 0x70, 0xd,
    0xf8, 0x2f, 0xc0, 0xfe, 0x60, 0x63, 0x80, 0xff,
    0xe3, 0x1c, 0x7, 0xff, 0x1f, 0x1, 0xff, 0xe3,
    0xdf, 0x82, 0xfc, 0xf, 0xe6, 0x7, 0xff, 0xfc,
    0xf, 0xff, 0xf8, 0x1f, 0xff, 0xf0, 0x3f, 0xff,
    0xe0, 0x7f, 0xf6, 0xd8, 0x1f, 0xfc, 0x77, 0x10,
    0x1f, 0xfc, 0x57, 0x5, 0xd6, 0xff, 0xf0, 0xf4,
    0x0,

    /* U+F8A2 "" */
    0x3, 0xff, 0x9e, 0x80, 0xff, 0xe7, 0xca, 0x7,
    0xff, 0x3a, 0x30, 0x3f, 0xf9, 0xd1, 0x81, 0xfc,
    0xb2, 0x3, 0xff, 0x84, 0x58, 0x1f, 0xce, 0x98,
    0x7, 0xff, 0x9, 0x81, 0xfd, 0x20, 0xf, 0xfe,
    0x74, 0x60, 0x7f, 0xf3, 0xab, 0x3, 0xff, 0x9d,
    0x50, 0x1c, 0x7f, 0xff, 0xe1, 0x50, 0x3a, 0xa0,
    0x3f, 0xf9, 0xec, 0xf, 0xfe, 0x87, 0x3, 0xff,
    0xa0, 0x79, 0x3, 0xd6, 0xff, 0xf1, 0xb8, 0x16,
    0x20, 0x62, 0x97, 0xff, 0x18, 0xe, 0xc4, 0xf,
    0xfe, 0x86, 0x40, 0x7f, 0xf4, 0x2a, 0x8, 0xf,
    0xfe, 0x75, 0xf0, 0xf, 0xfe, 0x40
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 111, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 115, .box_w = 4, .box_h = 20, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 18, .adv_w = 143, .box_w = 7, .box_h = 7, .ofs_x = 1, .ofs_y = 14},
    {.bitmap_index = 32, .adv_w = 279, .box_w = 17, .box_h = 20, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 128, .adv_w = 252, .box_w = 14, .box_h = 26, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 236, .adv_w = 328, .box_w = 19, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 352, .adv_w = 278, .box_w = 17, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 463, .adv_w = 78, .box_w = 3, .box_h = 7, .ofs_x = 1, .ofs_y = 14},
    {.bitmap_index = 469, .adv_w = 153, .box_w = 9, .box_h = 30, .ofs_x = 1, .ofs_y = -7},
    {.bitmap_index = 543, .adv_w = 156, .box_w = 8, .box_h = 30, .ofs_x = 0, .ofs_y = -7},
    {.bitmap_index = 612, .adv_w = 193, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 8},
    {.bitmap_index = 655, .adv_w = 254, .box_w = 14, .box_h = 15, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 684, .adv_w = 88, .box_w = 5, .box_h = 7, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 696, .adv_w = 124, .box_w = 8, .box_h = 3, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 702, .adv_w = 118, .box_w = 5, .box_h = 3, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 708, .adv_w = 185, .box_w = 11, .box_h = 22, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 772, .adv_w = 252, .box_w = 14, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 852, .adv_w = 252, .box_w = 8, .box_h = 20, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 874, .adv_w = 252, .box_w = 14, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 953, .adv_w = 252, .box_w = 13, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1036, .adv_w = 252, .box_w = 16, .box_h = 20, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1103, .adv_w = 252, .box_w = 13, .box_h = 20, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 1182, .adv_w = 251, .box_w = 14, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1271, .adv_w = 252, .box_w = 14, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1339, .adv_w = 252, .box_w = 14, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1438, .adv_w = 252, .box_w = 13, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1522, .adv_w = 109, .box_w = 4, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1535, .adv_w = 95, .box_w = 5, .box_h = 19, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 1558, .adv_w = 228, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 1608, .adv_w = 246, .box_w = 12, .box_h = 8, .ofs_x = 2, .ofs_y = 5},
    {.bitmap_index = 1629, .adv_w = 234, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 1682, .adv_w = 212, .box_w = 12, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1749, .adv_w = 402, .box_w = 23, .box_h = 26, .ofs_x = 1, .ofs_y = -6},
    {.bitmap_index = 1936, .adv_w = 292, .box_w = 18, .box_h = 20, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2041, .adv_w = 279, .box_w = 14, .box_h = 20, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 2116, .adv_w = 292, .box_w = 16, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2204, .adv_w = 294, .box_w = 15, .box_h = 20, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 2272, .adv_w = 255, .box_w = 13, .box_h = 20, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 2306, .adv_w = 248, .box_w = 13, .box_h = 20, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 2335, .adv_w = 305, .box_w = 17, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2433, .adv_w = 319, .box_w = 16, .box_h = 20, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 2459, .adv_w = 122, .box_w = 4, .box_h = 20, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 2464, .adv_w = 247, .box_w = 14, .box_h = 20, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2507, .adv_w = 281, .box_w = 16, .box_h = 20, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 2593, .adv_w = 241, .box_w = 13, .box_h = 20, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 2611, .adv_w = 391, .box_w = 21, .box_h = 20, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 2724, .adv_w = 319, .box_w = 16, .box_h = 20, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 2806, .adv_w = 308, .box_w = 17, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2905, .adv_w = 283, .box_w = 15, .box_h = 20, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 2962, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 3087, .adv_w = 276, .box_w = 15, .box_h = 20, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 3164, .adv_w = 266, .box_w = 15, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3261, .adv_w = 267, .box_w = 17, .box_h = 20, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3288, .adv_w = 291, .box_w = 16, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3334, .adv_w = 285, .box_w = 18, .box_h = 20, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3441, .adv_w = 397, .box_w = 25, .box_h = 20, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3602, .adv_w = 281, .box_w = 17, .box_h = 20, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3707, .adv_w = 269, .box_w = 17, .box_h = 20, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3782, .adv_w = 268, .box_w = 15, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3857, .adv_w = 119, .box_w = 6, .box_h = 27, .ofs_x = 2, .ofs_y = -4},
    {.bitmap_index = 3871, .adv_w = 184, .box_w = 12, .box_h = 22, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 3938, .adv_w = 119, .box_w = 6, .box_h = 27, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 3954, .adv_w = 187, .box_w = 11, .box_h = 10, .ofs_x = 0, .ofs_y = 10},
    {.bitmap_index = 3991, .adv_w = 202, .box_w = 13, .box_h = 3, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4000, .adv_w = 138, .box_w = 7, .box_h = 4, .ofs_x = 0, .ofs_y = 17},
    {.bitmap_index = 4010, .adv_w = 244, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4077, .adv_w = 251, .box_w = 14, .box_h = 21, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4146, .adv_w = 235, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4207, .adv_w = 253, .box_w = 13, .box_h = 21, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4273, .adv_w = 237, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4336, .adv_w = 156, .box_w = 10, .box_h = 22, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4370, .adv_w = 251, .box_w = 13, .box_h = 21, .ofs_x = 1, .ofs_y = -6},
    {.bitmap_index = 4460, .adv_w = 247, .box_w = 13, .box_h = 21, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4496, .adv_w = 109, .box_w = 4, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4508, .adv_w = 107, .box_w = 6, .box_h = 26, .ofs_x = -1, .ofs_y = -6},
    {.bitmap_index = 4534, .adv_w = 227, .box_w = 14, .box_h = 21, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4596, .adv_w = 109, .box_w = 3, .box_h = 21, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4600, .adv_w = 393, .box_w = 22, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4655, .adv_w = 247, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4688, .adv_w = 256, .box_w = 14, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4757, .adv_w = 251, .box_w = 14, .box_h = 21, .ofs_x = 1, .ofs_y = -6},
    {.bitmap_index = 4827, .adv_w = 255, .box_w = 13, .box_h = 21, .ofs_x = 1, .ofs_y = -6},
    {.bitmap_index = 4894, .adv_w = 152, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4915, .adv_w = 231, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4985, .adv_w = 146, .box_w = 9, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5017, .adv_w = 247, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5047, .adv_w = 217, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5114, .adv_w = 337, .box_w = 21, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5222, .adv_w = 222, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5292, .adv_w = 212, .box_w = 13, .box_h = 21, .ofs_x = 0, .ofs_y = -6},
    {.bitmap_index = 5377, .adv_w = 222, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5426, .adv_w = 152, .box_w = 10, .box_h = 28, .ofs_x = 0, .ofs_y = -6},
    {.bitmap_index = 5493, .adv_w = 109, .box_w = 3, .box_h = 24, .ofs_x = 2, .ofs_y = -4},
    {.bitmap_index = 5499, .adv_w = 152, .box_w = 9, .box_h = 28, .ofs_x = 0, .ofs_y = -6},
    {.bitmap_index = 5567, .adv_w = 305, .box_w = 17, .box_h = 6, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 5602, .adv_w = 448, .box_w = 28, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 5739, .adv_w = 448, .box_w = 28, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5876, .adv_w = 448, .box_w = 28, .box_h = 25, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 5972, .adv_w = 448, .box_w = 28, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6105, .adv_w = 308, .box_w = 20, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6221, .adv_w = 448, .box_w = 28, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 6419, .adv_w = 448, .box_w = 27, .box_h = 29, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 6592, .adv_w = 504, .box_w = 32, .box_h = 25, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 6758, .adv_w = 448, .box_w = 28, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 6887, .adv_w = 504, .box_w = 32, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7012, .adv_w = 448, .box_w = 28, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 7206, .adv_w = 224, .box_w = 14, .box_h = 23, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7258, .adv_w = 336, .box_w = 21, .box_h = 23, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7354, .adv_w = 504, .box_w = 32, .box_h = 27, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 7568, .adv_w = 448, .box_w = 28, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7674, .adv_w = 392, .box_w = 18, .box_h = 26, .ofs_x = 3, .ofs_y = -3},
    {.bitmap_index = 7767, .adv_w = 392, .box_w = 25, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 7888, .adv_w = 392, .box_w = 25, .box_h = 25, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 7952, .adv_w = 392, .box_w = 25, .box_h = 25, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 7995, .adv_w = 392, .box_w = 18, .box_h = 26, .ofs_x = 3, .ofs_y = -3},
    {.bitmap_index = 8088, .adv_w = 392, .box_w = 26, .box_h = 25, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 8200, .adv_w = 280, .box_w = 16, .box_h = 25, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 8305, .adv_w = 280, .box_w = 16, .box_h = 25, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 8409, .adv_w = 392, .box_w = 25, .box_h = 25, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 8483, .adv_w = 392, .box_w = 25, .box_h = 7, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 8512, .adv_w = 504, .box_w = 32, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8700, .adv_w = 560, .box_w = 35, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 8960, .adv_w = 504, .box_w = 33, .box_h = 29, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 9148, .adv_w = 448, .box_w = 28, .box_h = 25, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 9326, .adv_w = 392, .box_w = 25, .box_h = 15, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 9423, .adv_w = 392, .box_w = 25, .box_h = 15, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 9523, .adv_w = 560, .box_w = 35, .box_h = 22, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9672, .adv_w = 448, .box_w = 28, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9726, .adv_w = 448, .box_w = 28, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 9856, .adv_w = 448, .box_w = 29, .box_h = 29, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 10028, .adv_w = 392, .box_w = 25, .box_h = 25, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 10207, .adv_w = 392, .box_w = 25, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 10294, .adv_w = 392, .box_w = 25, .box_h = 25, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 10399, .adv_w = 280, .box_w = 19, .box_h = 29, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 10530, .adv_w = 392, .box_w = 25, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 10632, .adv_w = 392, .box_w = 25, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 10765, .adv_w = 504, .box_w = 32, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10897, .adv_w = 448, .box_w = 30, .box_h = 29, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 11048, .adv_w = 336, .box_w = 21, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 11113, .adv_w = 560, .box_w = 35, .box_h = 26, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 11313, .adv_w = 560, .box_w = 35, .box_h = 19, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 11397, .adv_w = 560, .box_w = 35, .box_h = 19, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 11482, .adv_w = 560, .box_w = 35, .box_h = 19, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 11567, .adv_w = 560, .box_w = 35, .box_h = 19, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 11649, .adv_w = 560, .box_w = 35, .box_h = 19, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 11725, .adv_w = 560, .box_w = 36, .box_h = 23, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 11886, .adv_w = 392, .box_w = 22, .box_h = 29, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 12070, .adv_w = 392, .box_w = 25, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 12166, .adv_w = 448, .box_w = 29, .box_h = 29, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 12353, .adv_w = 560, .box_w = 35, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12518, .adv_w = 336, .box_w = 21, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 12591, .adv_w = 451, .box_w = 29, .box_h = 19, .ofs_x = 0, .ofs_y = 1}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static const uint16_t unicode_list_1[] = {
    0x0, 0x7, 0xa, 0xb, 0xc, 0x10, 0x12, 0x14,
    0x18, 0x1b, 0x20, 0x25, 0x26, 0x27, 0x3d, 0x47,
    0x4a, 0x4b, 0x4c, 0x50, 0x51, 0x52, 0x53, 0x66,
    0x67, 0x6d, 0x6f, 0x70, 0x73, 0x76, 0x77, 0x78,
    0x7a, 0x92, 0x94, 0xc3, 0xc4, 0xc6, 0xe6, 0xe9,
    0xf2, 0x11b, 0x123, 0x15a, 0x1ea, 0x23f, 0x240, 0x241,
    0x242, 0x243, 0x286, 0x292, 0x2ec, 0x303, 0x559, 0x7c1,
    0x8a1
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 61441, .range_length = 2210, .glyph_id_start = 96,
        .unicode_list = unicode_list_1, .glyph_id_ofs_list = NULL, .list_length = 57, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Map glyph_ids to kern left classes*/
static const uint8_t kern_left_class_mapping[] =
{
    0, 1, 0, 2, 0, 0, 0, 0,
    2, 3, 0, 0, 0, 4, 0, 4,
    5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 6, 7, 8, 9, 10, 11,
    0, 12, 12, 13, 14, 15, 12, 12,
    9, 16, 17, 18, 0, 19, 13, 20,
    21, 22, 23, 24, 25, 0, 0, 0,
    0, 0, 26, 27, 28, 0, 29, 30,
    0, 31, 0, 0, 32, 0, 31, 31,
    33, 27, 0, 34, 0, 35, 0, 36,
    37, 38, 36, 39, 40, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0
};

/*Map glyph_ids to kern right classes*/
static const uint8_t kern_right_class_mapping[] =
{
    0, 1, 0, 2, 0, 0, 0, 3,
    2, 0, 4, 5, 0, 6, 7, 6,
    8, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    9, 0, 10, 0, 11, 0, 0, 0,
    11, 0, 0, 12, 0, 0, 0, 0,
    11, 0, 11, 0, 13, 14, 15, 16,
    17, 18, 19, 20, 0, 0, 21, 0,
    0, 0, 22, 0, 23, 23, 23, 24,
    23, 0, 0, 0, 0, 0, 25, 25,
    26, 25, 23, 27, 28, 29, 30, 31,
    32, 33, 31, 34, 0, 0, 35, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0
};

/*Kern values between classes*/
static const int8_t kern_class_values[] =
{
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -9, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -23, 0, 0, 0,
    0, 0, 0, 0, -26, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -11, -13, 0, -4, -13, 0, -17, 0,
    0, 0, 2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 4, 4, 0,
    5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -37, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -49, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -26, 0, 0, 0, 0, 0, 0, -13,
    0, -2, 0, 0, -28, -4, -19, -15,
    0, -21, 0, 0, 0, 0, 0, 0,
    -3, 0, 0, -4, -2, -11, -7, 0,
    3, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -6,
    0, -5, 0, 0, -12, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -6, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -6, 0, 0, 0, 0, 0,
    0, -3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -4,
    0, 0, 0, 0, 0, -22, 0, 0,
    0, -5, 0, 0, 0, -6, 0, -5,
    0, -5, -9, -5, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4, 0, 0, 0, 0, 0, 0, 0,
    0, -4, -4, 0, -4, 0, 0, 0,
    -4, -6, -5, 0, 0, 0, 0, 0,
    0, 0, 0, -51, 0, 0, 0, -37,
    0, -58, 0, 4, 0, 0, 0, 0,
    0, 0, 0, -7, -5, 0, 0, -5,
    -6, 0, 0, -5, -5, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 4, 0, 0, 0, -6, 0,
    0, 0, 4, -6, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -14, 0, 0,
    0, -7, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -6, 0, -5,
    -6, 0, 0, 0, -5, -9, -14, 0,
    0, 0, 0, -73, 0, 0, 0, 0,
    0, 0, 0, 4, -14, 0, 0, -60,
    -12, -38, -31, 0, -52, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -10,
    -29, -20, 0, 0, 0, 0, 0, 0,
    0, 0, -71, 0, 0, 0, -30, 0,
    -44, 0, 0, 0, 0, 0, -7, 0,
    -6, 0, -2, -3, 0, 0, -3, 0,
    0, 3, 0, 3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -9, 0, -6,
    -4, 0, -8, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -17, 0, -4, 0, 0, -10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -9, 0,
    0, 0, 0, -48, -51, 0, 0, -17,
    -6, -52, -3, 4, 0, 4, 3, 0,
    4, 0, 0, -25, -22, 0, -24, -22,
    -16, -25, 0, -21, -16, -12, -17, -13,
    0, 0, 0, 0, 4, 0, -49, -8,
    0, 0, -16, -3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 4, -10, -10,
    0, 0, -10, -7, 0, 0, -6, -2,
    0, 0, 0, 4, 0, 0, 0, 3,
    0, -27, -13, 0, 0, -9, 0, 0,
    0, 3, 0, 0, 0, 0, 0, 0,
    3, -7, -7, 0, 0, -7, -5, 0,
    0, -4, 0, 0, 0, 0, 3, 0,
    0, 0, 0, 0, 0, -10, 0, 0,
    0, -5, 0, 0, 0, 0, 3, 0,
    0, 0, 0, 0, 0, -6, 0, 0,
    -5, 0, 0, 0, -5, -7, 0, 0,
    0, 0, 0, 0, -7, 4, -11, -46,
    -11, 0, 0, -21, -6, -21, -3, 4,
    -21, 4, 4, 3, 4, 0, 4, -16,
    -14, -5, -9, -14, -9, -13, -5, -9,
    -4, 0, -5, -7, 4, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 3, -6,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -5, 0, 0, -5, 0,
    0, 0, -4, -6, -6, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -4, 0, 0, -4, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -15, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -3, 0, 0, 0, 0, 0, -6,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -2, 0, -3, -3,
    0, 0, -2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -3, 0, 0, 0, 0, 0,
    4, 0, 4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 4, 0, -5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 4, 0, -23, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -4, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -30, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -3, 0,
    -5, -3, 0, 0, 4, 0, 0, 0,
    -27, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -9, -4, 3, 0, -4, 0, 0, 11,
    0, 4, 4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 3, 0, 0, 0, -23, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -3, -3,
    3, 0, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -27, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -4, 0, 0,
    -4, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -3, 0, 0, -3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -4, 0, 0, -4, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0
};


/*Collect the kern class' data in one place*/
static const lv_font_fmt_txt_kern_classes_t kern_classes =
{
    .class_pair_values   = kern_class_values,
    .left_class_mapping  = kern_left_class_mapping,
    .right_class_mapping = kern_right_class_mapping,
    .left_class_cnt      = 40,
    .right_class_cnt     = 35,
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

/*Store all the custom data of the font*/
static lv_font_fmt_txt_dsc_t font_dsc = {
    .glyph_bitmap = gylph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = &kern_classes,
    .kern_scale = 16,
    .cmap_num = 2,
    .bpp = 3,
    .kern_classes = 1,
    .bitmap_format = 1
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
lv_font_t lv_font_roboto_28_compressed = {
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 32,          /*The maximum line height required by the font*/
    .base_line = 7,             /*Baseline measured from the bottom of the line*/
    .subpx = LV_FONT_SUBPX_NONE,
    .dsc = &font_dsc           /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
};

#endif /*#if LV_FONT_ROBOTO_28_COMPRESSED*/

