/*********************************Header File********************************************************/
#include "fsl_power.h"
#include "fsl_adc.h"
#include "fsl_debug_console.h"
#include "mlib_types.h"
#include "BLDC_app.h"
#include "BLDC_gpio.h"
/*********************************Header File********************************************************/

/*********************************Function definition************************************************/
/*****************************************************************************
+FUNCTION----------------------------------------------------------------
* @function name: ADC_Configuration
*
* @brief   Initialization of ADC
*        
* @param  none
*
* @return none
*
* @ Pass/ Fail criteria: none
*****************************************************************************/
void ADC_Configuration(void)
{
  //Temporary variable
  uint32_t temp = 0;
  
  /*************************Step 1. Power up and reset the ADC, and enable clock************************************/
  //if you want to use ADC in LPC51U68, please power on ADC converter, 
  //analog supply and reference voltage source
  //Power on the ADC converter
  POWER_DisablePD(kPDRUNCFG_PD_ADC0);
  //Power on the analog power supply
  POWER_DisablePD(kPDRUNCFG_PD_VD7_ENA);
  //Power on the reference voltage source
  POWER_DisablePD(kPDRUNCFG_PD_VREFP_SW);    
  //Reset ADC including assert reset and then clear reset 
  RESET_PeripheralReset(kADC0_RST_SHIFT_RSTn); 
  //Use main clock as source for ADC sync clock
  CLOCK_AttachClk(kMAIN_CLK_to_ADC_CLK);
  //Enable clock for ADC
  CLOCK_EnableClock(kCLOCK_Adc0);
  /*************************Step 1. Power up and reset the ADC, and enable clock************************************/
  
  /*************************Step 2. Perform a self-calibration******************************************************/ 
  #if !(defined(FSL_FEATURE_ADC_HAS_NO_CALIB_FUNC) && FSL_FEATURE_ADC_HAS_NO_CALIB_FUNC)
      uint32_t frequency = 0U;
      /* Calibration after power up. */
  #if defined(FSL_FEATURE_ADC_HAS_CALIB_REG) && FSL_FEATURE_ADC_HAS_CALIB_REG
      ADC0->CTRL |= ADC_CTRL_BYPASSCAL_MASK;
      frequency = CLOCK_GetFreq(kCLOCK_BusClk);
      if (true == ADC_DoOffsetCalibration(ADC0, frequency))
  #else
  #if defined(SYSCON_ADCCLKDIV_DIV_MASK)
      frequency = CLOCK_GetFreq(DEMO_ADC_CLOCK_SOURCE) / CLOCK_GetClkDivider(kCLOCK_DivAdcClk);
  #else
      frequency = CLOCK_GetFreq(DEMO_ADC_CLOCK_SOURCE);
  #endif /* SYSCON_ADCCLKDIV_DIV_MASK */
      if (true == ADC_DoSelfCalibration(ADC0, frequency))
  #endif /* FSL_FEATURE_ADC_HAS_CALIB_REG */
      {
          PRINTF("ADC Calibration Done.\r\n");
      }
      else
      {
          PRINTF("ADC Calibration Failed.\r\n");
      }
  #endif /* FSL_FEATURE_ADC_HAS_NO_CALIB_FUNC */
  /*************************Step 2. Perform a self-calibration******************************************************/
      
  /*************************Step 3. Set Channel 3 and 4 for sequence A (DCB VOLT, DCB CURRENT enable sequence*******/
  //configure the ADC including preparing everything, enabling as the last step
  ADC0->SEQ_CTRL[0] = 0;
  //enable SEQA interrupt
  ADC0->INTEN = 1<<0;   
  //dump ADC_3 reading
  temp = ADC0->DAT[3];
  //dump ADC_4 reading  
  temp = ADC0->DAT[4];
  //avoid unused warning  
  temp = temp;
  
  //IMPORTANT: make sure pins acting as ADC inputs have internal 
  //           pull-up/down disabled in BOARD_InitPins() !!!
  ADC0->SEQ_CTRL[0] = ADC_SEQ_CTRL_CHANNELS(1<<3 | 1<<4) | //ADC_IN3/4
                      ADC_SEQ_CTRL_TRIGGER(2)            | //SCT_OUT7 hw trigger, this is different from LPC845
                      ADC_SEQ_CTRL_TRIGPOL(1)            |  //trigger @ positive edge
                      ADC_SEQ_CTRL_SYNCBYPASS(0)         |  //enable synchronization
                      ADC_SEQ_CTRL_START(0)              |  //do not START
                      ADC_SEQ_CTRL_BURST(0)              |  //no BURST
                      ADC_SEQ_CTRL_SINGLESTEP(0)         |  //no SINGLESTEP
                      ADC_SEQ_CTRL_LOWPRIO(0)            |  //set SEQ A as high priority, this is different from LPC845
                      ADC_SEQ_CTRL_MODE(1)               |  //retrieve data at the end of sequence
                      ADC_SEQ_CTRL_SEQ_ENA(0);              //disable sequence
				 
  ADC0->SEQ_CTRL[0] = ADC_SEQ_CTRL_CHANNELS(1<<3 | 1<<4) | //ADC_IN3/4
                      ADC_SEQ_CTRL_TRIGGER(2)            | //SCT_OUT7 hw trigger,this is different from LPC845
                      ADC_SEQ_CTRL_TRIGPOL(1)            |  //trigger @ positive edge
                      ADC_SEQ_CTRL_SYNCBYPASS(0)         |  //enable synchronization
                      ADC_SEQ_CTRL_START(0)              |  //do not START
                      ADC_SEQ_CTRL_BURST(0)              |  //no BURST
                      ADC_SEQ_CTRL_SINGLESTEP(0)         |  //no SINGLESTEP
                      ADC_SEQ_CTRL_LOWPRIO(0)            |  //set SEQ A as high priority,this is different from LPC845
                      ADC_SEQ_CTRL_MODE(1)               |  //retrieve data at the end of sequence
                      ADC_SEQ_CTRL_SEQ_ENA(1);              //enable sequence
  //ADC0 sequence A interrupt priority
  NVIC_SetPriority(ADC0_SEQA_IRQn, 2);
  //ADC0 sequence A interrupt enable
  NVIC_EnableIRQ(ADC0_SEQA_IRQn);
  /*************************Step 3. Set Channel 3 and 4 for sequence A (DCB VOLT, DCB CURRENT enable sequence*******/
}

/*****************************************************************************
+FUNCTION----------------------------------------------------------------
* @function name: ADC0_SEQA_IRQHandler
*
* @brief  ADC0 SEQA interrupt handler - ADC0_SEQA_IRQHandler
*        
* @param  none
*
* @return none
*
* @ Pass/ Fail criteria: none
*****************************************************************************/
void ADC0_SEQA_IRQHandler(void)
{
  /**********************indicate ADC isr begin, (only for debugging)**************************/
  /*
   * Rising edge is used to indicate ADC isr begin
  */
  //drive pin 21 on port 0 to low
  GPIO_PinWrite(GPIO, GPIO_PORT_0, 21, 0);
  //delay and set direction of pin 21 on port 0 as output
  GPIO->DIRSET[0] = (1 << (21));
  //drive pin 21 on port 0 to high
  GPIO_PinWrite(GPIO, GPIO_PORT_0, 21, 1);
  /**********************indicate ADC isr begin, (only for debugging)**************************/
  
  /**********************Get the current value and voltage value of the DC bus*****************/
  //Get the voltage value on Direct Current Bus from ADC channel 3
  f16Vdcb =  ((ADC0->DAT[3]& ADC_DAT_RESULT_MASK)>>  ADC_DAT_RESULT_SHIFT);
  //Get the current value on Direct Current Bus from ADC channel 4
  f16Idcb =  ((ADC0->DAT[4]& ADC_DAT_RESULT_MASK)>>  ADC_DAT_RESULT_SHIFT) - 2048;
  /**********************Get the current value and voltage value of the DC bus*****************/
  
  /**********************Clear flag to enable new interrupt************************************/
  ADC0->FLAGS = ADC_FLAGS_SEQA_INT(1); 
  /**********************Clear flag to enable new interrupt************************************/
	
  /**********************indicate ADC isr end,(only for debugging)*****************************/
  //drive pin 21 on port 0 to low
  GPIO_PinWrite(GPIO, GPIO_PORT_0, 21, 0);
  /**********************indicate ADC isr end,(only for debugging)*****************************/
  
  //FMSTR_Recorder(0);
 
  return;
}
/*********************************Function definition************************************************/