/* touch_2d.c */

#include "touch_2d.h"
#include <stdlib.h>

int32_t touch_channel_baselines[TOUCH_2D_ALL_COUNT];

/* using hardware filter, software calibration would not check the idle state. */
bool touch_2d_calib(int32_t *inputs)
{
    for (uint32_t i = 0u; i < TOUCH_2D_ALL_COUNT; i++)
    {
        touch_channel_baselines[i] = inputs[i];
    }
    return true;
}

/* 输入为offset值 */
bool touch_slider_calc_position(int32_t *inputs, int32_t shield_val)
{
    return true;
}

int32_t touch_channel_offsets[TOUCH_2D_ALL_COUNT] = {0};
int32_t touch_channel_offsets2[TOUCH_2D_ALL_COUNT] = {0};

#define TOUCH_BOUNDARY_THRESHOLD  20
#define TOUCH_ON_TOUCH_THRESHOLD  17
#define TOUCH_BOUNDARY_X_OFFSET   (TOUCH_2D_X_POS_RANGE / 2)
#define TOUCH_BOUNDARY_Y_OFFSET   (TOUCH_2D_Y_POS_RANGE / 2)

volatile int32_t touch_channel_offsets_sum = 0u;

/* 返回错误码 */
int32_t touch_2d_calc_position(int32_t *inputs, int32_t *x_pos, int32_t *y_pos)
{
    uint32_t m_touch_val_max_idx = 0;
    uint32_t m_touch_val_min_idx = 0;


    touch_channel_offsets[0] = inputs[0] - touch_channel_baselines[0];
    int32_t m_touch_channel_offsets_sum = touch_channel_offsets[0];

    /* cut off the baseline for each. */
    for (uint32_t i = 1u; i < TOUCH_2D_ALL_COUNT; i++)
    {
        touch_channel_offsets[i] = inputs[i] - touch_channel_baselines[i];

        m_touch_channel_offsets_sum += touch_channel_offsets[i];

        if (touch_channel_offsets[i] > touch_channel_offsets[m_touch_val_max_idx])
        {
            m_touch_val_max_idx = i;
        }
        if (touch_channel_offsets[i] < touch_channel_offsets[m_touch_val_min_idx])
        {
            m_touch_val_min_idx = i;
        }
    }
    /* shield不参与计算, 但用于边界判定 */
    //touch_channel_offsets[TOUCH_2D_ALL_COUNT-1] = touch_channel_baselines[TOUCH_2D_ALL_COUNT-1] - inputs[TOUCH_2D_ALL_COUNT-1];

    touch_channel_offsets_sum = m_touch_channel_offsets_sum;
    if (touch_channel_offsets_sum >= 250)
    {
        return 3; /* 触摸面积太大, all cover. */
    }

    /* cut off the baseline in system. */
    for (uint32_t i = 0u; i < TOUCH_2D_ALL_COUNT; i++)
    {
        touch_channel_offsets2[i] = touch_channel_offsets[i] - touch_channel_offsets[m_touch_val_min_idx];
    }
#if 0
    if (touch_channel_offsets2[TOUCH_2D_ALL_COUNT-1] > TOUCH_BOUNDARY_THRESHOLD)
    {
        return 1; /* 触摸到边界, 位置无效. */
    }
#endif
    if (touch_channel_offsets2[m_touch_val_max_idx] < TOUCH_ON_TOUCH_THRESHOLD)
    {
        if (touch_channel_offsets[m_touch_val_min_idx] < TOUCH_ON_TOUCH_THRESHOLD)
        {
            return 2;  /* 凸显不多, 触摸无效. */
        }
    }

    /* x. */
    int32_t *calc_base = touch_channel_offsets2;
    int32_t m_touch_calc_val[2];
    m_touch_calc_val[0] = 0;
    m_touch_calc_val[1] = 0;
    for (uint32_t i = 0u; i < TOUCH_2D_X_COUNT; i++)
    {
        m_touch_calc_val[0] += (*calc_base) * i;
        m_touch_calc_val[1] += (*calc_base);
        calc_base++;
    }

    m_touch_calc_val[0] = m_touch_calc_val[0] * TOUCH_2D_X_POS_RANGE / m_touch_calc_val[1];
    m_touch_calc_val[0] -= TOUCH_BOUNDARY_X_OFFSET;
    *x_pos = (m_touch_calc_val[0] > 0) ? m_touch_calc_val[0] : 0;

    /* y. */
    m_touch_calc_val[0] = 0;
    m_touch_calc_val[1] = 0;
    for (uint32_t i = 0u; i < TOUCH_2D_Y_COUNT; i++)
    {
        m_touch_calc_val[0] += (*calc_base) * i;
        m_touch_calc_val[1] += (*calc_base);
        calc_base++;
    }

    m_touch_calc_val[0] = m_touch_calc_val[0] * TOUCH_2D_Y_POS_RANGE / m_touch_calc_val[1];
    m_touch_calc_val[0] -= TOUCH_BOUNDARY_Y_OFFSET;
    *y_pos = (m_touch_calc_val[0] > 0) ? m_touch_calc_val[0] : 0;

    return 0;
}

/* gestures. */
/* 运动趋势的判定 */
volatile int32_t touch_2d_x_pos_pre = 0;
volatile int32_t touch_2d_y_pos_pre = 0;
volatile int32_t touch_2d_x_pos_delta = 0;
volatile int32_t touch_2d_y_pos_delta = 0;

/*
 * gesture_code:
 * 0: no touch
 * 2: just_on_touch
 * 3: on_touch_move_0 前提是已经on_touch, 属于长按事件
 * 4: on_touch_move_1
 * 5: on_touch_move_2
 * 6: on_touch_move_3
 * 7: on_touch_move_4
 * 8: 2nd_click
 * 9: 3rd_click
 */

volatile touch_2d_gesture_event_t touch_2d_gesture_event_pre = eTouch_2d_gesture_event_no_touch_keep;
volatile touch_2d_gesture_event_t touch_2d_gesture_event = eTouch_2d_gesture_event_no_touch_keep;

#define TOUCH_2D_GESTURE_MOVEMENT_STEP_THRESHOLD  80 /* 判定两个采样点之间是否为移动 */

volatile uint32_t touch_2d_gesture_no_touch_interval_on_hold_counter = 0u; /* 记录连击的松开时间间隔 */
volatile uint32_t touch_2d_gesture_no_touch_interval_counter = 0u;

touch_2d_gesture_event_t touch_2d_gesture_process(int32_t x_pos, int32_t y_pos, bool on_touch)
{
    if (on_touch)
    {
        /* 触发on_touch_just事件:
         * 之前没有摸, 刚摸上, 仅缓存有效位置并更新状态 */
        if (     (touch_2d_gesture_event_pre == eTouch_2d_gesture_event_no_touch_keep)
              || (touch_2d_gesture_event_pre == eTouch_2d_gesture_event_no_touch_interval)
            )
        {
            if (touch_2d_gesture_no_touch_interval_counter == 0u)
            {
                touch_2d_gesture_event = eTouch_2d_gesture_event_on_touch_just;
            }
            else if (touch_2d_gesture_no_touch_interval_counter == 1u)
            {
                touch_2d_gesture_event = eTouch_2d_gesture_event_on_touch_just_2nd_click;
            }
            else if (touch_2d_gesture_no_touch_interval_counter == 2u)
            {
                touch_2d_gesture_event = eTouch_2d_gesture_event_on_touch_just_3rd_click;
            }
            else
            {
                touch_2d_gesture_event = eTouch_2d_gesture_event_on_touch_no_process;
            }

            touch_2d_x_pos_delta = 0;
            touch_2d_y_pos_delta = 0;
        }

        /* 触发方向检测事件on_touch_move_0/1/2/3/4.
         * 之前为刚摸着, 此时保持摸着, 从而识别摸来摸去.
         * 计算坐标的变化, 判断是保持摸住的滑动方向.
         */
        else if (    (touch_2d_gesture_event_pre == eTouch_2d_gesture_event_on_touch_just)
                ||   (touch_2d_gesture_event_pre == eTouch_2d_gesture_event_on_touch_just_2nd_click) /* 连击之后仍可以计算坐标滑动. */
                ||   (touch_2d_gesture_event_pre == eTouch_2d_gesture_event_on_touch_just_3rd_click) /* 连击之后仍可以计算坐标滑动. */
                ||   (touch_2d_gesture_event_pre == eTouch_2d_gesture_event_on_touch_no_process)
                || ( (touch_2d_gesture_event_pre >= eTouch_2d_gesture_event_on_touch_move_0) && (touch_2d_gesture_event_pre <= eTouch_2d_gesture_event_on_touch_move_4)  )
                )
        {
            touch_2d_x_pos_delta = x_pos - touch_2d_x_pos_pre;
            touch_2d_y_pos_delta = y_pos - touch_2d_y_pos_pre;

            if (abs(touch_2d_x_pos_delta) > abs(touch_2d_y_pos_delta))
            {
                if (abs(touch_2d_x_pos_delta) < TOUCH_2D_GESTURE_MOVEMENT_STEP_THRESHOLD)
                {
                    touch_2d_gesture_event = eTouch_2d_gesture_event_on_touch_move_0;
                }
                else
                {
                    if (touch_2d_x_pos_delta > 0)
                    {
                        touch_2d_gesture_event = eTouch_2d_gesture_event_on_touch_move_1;
                    }
                    else
                    {
                        touch_2d_gesture_event = eTouch_2d_gesture_event_on_touch_move_3;
                    }
                }
            }
            else
            {
                if (abs(touch_2d_y_pos_delta) < TOUCH_2D_GESTURE_MOVEMENT_STEP_THRESHOLD)
                {
                    touch_2d_gesture_event = eTouch_2d_gesture_event_on_touch_move_0;
                }
                else
                {
                    if (touch_2d_y_pos_delta > 0)
                    {
                        touch_2d_gesture_event = eTouch_2d_gesture_event_on_touch_move_2;
                    }
                    else
                    {
                        touch_2d_gesture_event = eTouch_2d_gesture_event_on_touch_move_4;
                    }
                }
            }
        }

        touch_2d_x_pos_pre = x_pos;
        touch_2d_y_pos_pre = y_pos;
    }
    else /* no touch. */
    {
       /* 触发no_touch_on_hold事件:
        * 之前摸着或者摸来摸去, 此时刚松手
        */
        if (  ((touch_2d_gesture_event_pre >= eTouch_2d_gesture_event_on_touch_just) && (touch_2d_gesture_event_pre <= eTouch_2d_gesture_event_on_touch_move_4))
            || (touch_2d_gesture_event_pre == eTouch_2d_gesture_event_on_touch_just_2nd_click)
            || (touch_2d_gesture_event_pre == eTouch_2d_gesture_event_on_touch_just_3rd_click)
            || (touch_2d_gesture_event_pre == eTouch_2d_gesture_event_on_touch_no_process)
            )
        {
            touch_2d_gesture_event = eTouch_2d_gesture_event_no_touch_interval;
            touch_2d_gesture_no_touch_interval_counter++; /* 对interval进行计数. */

            touch_2d_gesture_no_touch_interval_on_hold_counter = 0u; /* 开始计时. */

            touch_2d_x_pos_delta = 0;
            touch_2d_y_pos_delta = 0;
        }

        /* 将no_touch_on_hold转变为no_touch_keep. */
        else if (touch_2d_gesture_event_pre == eTouch_2d_gesture_event_no_touch_interval)
        {
            touch_2d_gesture_no_touch_interval_on_hold_counter++;
            if (touch_2d_gesture_no_touch_interval_on_hold_counter >= 4u) /* 0.6s interval. */
            {
                touch_2d_gesture_event = eTouch_2d_gesture_event_no_touch_keep;
                touch_2d_gesture_no_touch_interval_counter = 0u; /* 清零interval计数值. */
            }
        }

        else /* eTouch_2d_gesture_event_no_touch_keep. */
        {
            touch_2d_gesture_no_touch_interval_counter = 0u;
        }
    }

    touch_2d_gesture_event_pre = touch_2d_gesture_event;

    return touch_2d_gesture_event;
}

/* EOF. */

