/*
 * Copyright 2019 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/******************************************************************************
*
* @file board.h
*
* @author nxf47721
*
* @version 0.0.1
*
* @date Oct 20, 2019
*
*******************************************************************************/

#ifndef board_H_
#define board_H_

#include "mc9s08pb16.h"
#include "commonTypes.h"

/* define print system log */
#define PRINT_SYS_LOG

/* define output bus clock */
//#define OUTPUT_BUSCLK

/* define what clock mode at startup 
 * if USE_FEE is not defined by commenting out the following line, 
 * then it will use FEI mode which is default mode 
 * after reset  
 */
#define USE_FEE		/* FEE clock mode */	

/* define external crystal frequency */
#define EXT_CLK_CRYST	8000	//PT60-LITE board includes 8MHz	external osc

/* define BUS clock in HZ */
#define  BUS_CLK_HZ		16000000L

/* define SCI port # to be used to realize the PRINF function, it is used in printf.c file  */
#define USE_SCI		0

#define DAC5571_I2C_ADDRESS    0x4C   // SA0 = 0
#define DAC5571_ADC_CHANNEL    3

#define LED0_Init()                 PORT_PTBOE_PTBOE3 = 1
#define LED0_Toggle()		        PORT_PTBD_PTBD3  ^= 1
#define LED0_On()		            PORT_PTBD_PTBD3   = 0
#define LED0_Off()		            PORT_PTBD_PTBD3   = 1

#define LED1_Init()                 PORT_PTAOE_PTAOE1 = 1
#define LED1_Toggle()		        PORT_PTAD_PTAD1  ^= 1
#define LED1_On()		            PORT_PTAD_PTAD1   = 0
#define LED1_Off()		            PORT_PTAD_PTAD1   = 1

#define LED2_Init()                 PORT_PTAOE_PTAOE2 = 1
#define LED2_Toggle()		        PORT_PTAD_PTAD2  ^= 1
#define LED2_On()		            PORT_PTAD_PTAD2   = 0
#define LED2_Off()		            PORT_PTAD_PTAD2   = 1


extern void delay(void);
extern void Sys_Init(void);
extern void BOARD_InitDebugConsole(void);
    
#endif /* board_H_ */
