/*
 * Copyright 2019 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/******************************************************************************
*
* @file sci.c
*
* @author nxf47721
*
* @version 0.0.1
*
* @date Nov 20, 2019
*
* @brief providing common SCI routines. 
*
*******************************************************************************
*
* provide APIs for access SCIs. more APIs to be added.
******************************************************************************/
#include "derivative.h" /* include peripheral declarations */
#include "sci.h"
#include "common.h"

/*****************************************************************************//*!
+FUNCTION----------------------------------------------------------------
* @function name: TERMIO_PutChar0
*
* @brief print a char via SCI0
*        
* @param  send	a char to print 
*
* @return none
*
* @ Pass/ Fail criteria: none
*****************************************************************************/

  void TERMIO_PutChar0(char send)
  {
    char dummy;

    while((SCI0_S1 & SCI0_S1_TDRE_MASK) != SCI0_S1_TDRE_MASK);
    dummy = SCI0_S1;
    SCI0_D  = send;
  }//end SCI_PutChar

  /*****************************************************************************//*!
  +FUNCTION----------------------------------------------------------------
  * @function name: TERMIO_GetChar0
  *
  * @brief receives a char via SCI0
  *        
  * @param  none 
  *
  * @return a char received
  *
  * @ Pass/ Fail criteria: none
  *****************************************************************************/

  char TERMIO_GetChar0(void)
  {
    char dummy;

    while(( SCI0_S1 & SCI0_S1_RDRF_MASK) != SCI0_S1_RDRF_MASK);
    dummy = SCI0_S1;
    dummy = SCI0_D;
    return dummy;
  } //end SCI_GetChar

  /*****************************************************************************//*!
    +FUNCTION----------------------------------------------------------------
    * @function name: Init_SCI0
    *
    * @brief initializes SCI0 baud rate, enable both tx and rx
    *        
    * @param  none 
    *
    * @return none
    *
    * @ Pass/ Fail criteria: none
    *****************************************************************************/
void Init_SCI0(dword busCLKHz)
  {   
      /* make sure clocks to peripheral modules are enabled */
      SYS_SCGC3 |= 0x10;
      
      /* Bus clock 16MHz*/
      SCI0_BDH = 0;                 //  1 stop bit, first write to SCI0_BDH, then write SCI0_BDL
      SCI0_BDL = 9;                 //  SCIx_BD = BUSCLK / 16 / baudrate   16M / 16 / 115200 = 9; 
      
      SCI0_C1  = 0;                 //  8 bit mode, no parity

      SCI0_C2 |= SCI0_C2_TE_MASK|SCI0_C2_RE_MASK;  // enable TX , enable RX 
  }//end Init_SCI0


  /*****************************************************************************//*!
   +FUNCTION----------------------------------------------------------------
   * @function name: wait_sci_tx_empty
   *
   * @brief loops to wait for the SCI tx empty
   *        
   * @param  none 
   *
   * @return none
   *
   * @ Pass/ Fail criteria: none
   *****************************************************************************/

void wait_sci_tx_empty(void)
{
    while(( SCI0_S1 & SCI0_S1_TDRE_MASK) !=SCI0_S1_TDRE_MASK);

}

void uart_putchar (char ch)
{
  TERMIO_PutChar0(ch);      
}

char uart_getchar(void)
{
  //return SCI0_D;  
  return TERMIO_GetChar0();
}
char uart_rx_ready(void)
{
  return (SCI0_S1 & SCI0_S1_RDRF_MASK);     
}
